/* X_ITE v14.0.4 */
(function webpackUniversalModuleDefinition(root, factory) {
	if(typeof exports === 'object' && typeof module === 'object')
		module.exports = factory();
	else if(typeof define === 'function' && define.amd)
		define([], factory);
	else if(typeof exports === 'object')
		exports["X3D"] = factory();
	else
		root["X3D"] = factory();
})(self, () => {
return /******/ (() => { // webpackBootstrap
/******/ 	var __webpack_modules__ = ({

/***/ 2692
(module, exports) {

var __WEBPACK_AMD_DEFINE_FACTORY__, __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;/*
	SuperGif

	Example usage:

		<img src="./example1_preview.gif" rel:animated_src="./example1.gif" width="360" height="360" rel:auto_play="1" />

		<script type="text/javascript">
			$$('img').each(function (img_tag) {
				if (/.*\.gif/.test(img_tag.src)) {
					var rub = new SuperGif({ gif: img_tag } );
					rub.load();
				}
			});
		</script>

	Image tag attributes:

		rel:animated_src -	If this url is specified, it's loaded into the player instead of src.
							This allows a preview frame to be shown until animated gif data is streamed into the canvas

		rel:auto_play -		Defaults to 1 if not specified. If set to zero, a call to the play() method is needed

	Constructor options args

		gif 				Required. The DOM element of an img tag.
		loop_mode			Optional. Setting this to false will force disable looping of the gif.
		auto_play 			Optional. Same as the rel:auto_play attribute above, this arg overrides the img tag info.
		max_width			Optional. Scale images over max_width down to max_width. Helpful with mobile.
 		on_end				Optional. Add a callback for when the gif reaches the end of a single loop (one iteration). The first argument passed will be the gif HTMLElement.
		loop_delay			Optional. The amount of time to pause (in ms) after each single loop (iteration).
		draw_while_loading	Optional. Determines whether the gif will be drawn to the canvas whilst it is loaded.
		show_progress_bar	Optional. Only applies when draw_while_loading is set to true.
        on_error            Optional. Add a callback for when a load error occurs.

	Instance methods

		// loading
		load( callback )		Loads the gif specified by the src or rel:animated_src sttributie of the img tag into a canvas element and then calls callback if one is passed
		load_url( src, callback )	Loads the gif file specified in the src argument into a canvas element and then calls callback if one is passed

		// play controls
		play -				Start playing the gif
		pause -				Stop playing the gif
		move_to(i) -		Move to frame i of the gif
		move_relative(i) -	Move i frames ahead (or behind if i < 0)

		// getters
		get_canvas			The canvas element that the gif is playing in. Handy for assigning event handlers to.
		get_playing			Whether or not the gif is currently playing
		get_loading			Whether or not the gif has finished loading/parsing
		get_auto_play		Whether or not the gif is set to play automatically
		get_length			The number of frames in the gif
		get_current_frame	The index of the currently displayed frame of the gif
		get_frames	        An array containing the data for all parsed frames
		get_duration	    Returns the duration of the gif in hundredths of a second (standard for GIF spec)
		get_duration_ms	    Returns the duration of the gif in milliseconds

		For additional customization (viewport inside iframe) these params may be passed:
		c_w, c_h - width and height of canvas
		vp_t, vp_l, vp_ w, vp_h - top, left, width and height of the viewport

		A bonus: few articles to understand what is going on
			http://enthusiasms.org/post/16976438906
			http://www.matthewflickinger.com/lab/whatsinagif/bits_and_bytes.asp
			http://humpy77.deviantart.com/journal/Frame-Delay-Times-for-Animated-GIFs-214150546

*/
(function (root, factory) {
    if (true) {
        !(__WEBPACK_AMD_DEFINE_ARRAY__ = [], __WEBPACK_AMD_DEFINE_FACTORY__ = (factory),
		__WEBPACK_AMD_DEFINE_RESULT__ = (typeof __WEBPACK_AMD_DEFINE_FACTORY__ === 'function' ?
		(__WEBPACK_AMD_DEFINE_FACTORY__.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__)) : __WEBPACK_AMD_DEFINE_FACTORY__),
		__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
    } else // removed by dead control flow
{}
}(this, function () {
    // Generic functions
    var bitsToNum = function (ba) {
        return ba.reduce(function (s, n) {
            return s * 2 + n;
        }, 0);
    };

    var byteToBitArr = function (bite) {
        var a = [];
        for (var i = 7; i >= 0; i--) {
            a.push( !! (bite & (1 << i)));
        }
        return a;
    };

    // Stream
    /**
     * @constructor
     */
    // Make compiler happy.
    var Stream = function (data) {
        this.data = data;
        this.len = this.data.length;
        this.pos = 0;

        this.readByte = function () {
            if (this.pos >= this.data.length) {
                throw new Error('Attempted to read past end of stream.');
            }
            if (data instanceof Uint8Array)
                return data[this.pos++];
            else
                return data.charCodeAt(this.pos++) & 0xFF;
        };

        this.readBytes = function (n) {
            var bytes = [];
            for (var i = 0; i < n; i++) {
                bytes.push(this.readByte());
            }
            return bytes;
        };

        this.read = function (n) {
            var s = '';
            for (var i = 0; i < n; i++) {
                s += String.fromCharCode(this.readByte());
            }
            return s;
        };

        this.readUnsigned = function () { // Little-endian.
            var a = this.readBytes(2);
            return (a[1] << 8) + a[0];
        };
    };

    var lzwDecode = function (minCodeSize, data) {
        // TODO: Now that the GIF parser is a bit different, maybe this should get an array of bytes instead of a String?
        var pos = 0; // Maybe this streaming thing should be merged with the Stream?
        var readCode = function (size) {
            var code = 0;
            for (var i = 0; i < size; i++) {
                if (data.charCodeAt(pos >> 3) & (1 << (pos & 7))) {
                    code |= 1 << i;
                }
                pos++;
            }
            return code;
        };

        var output = [];

        var clearCode = 1 << minCodeSize;
        var eoiCode = clearCode + 1;

        var codeSize = minCodeSize + 1;

        var dict = [];

        var clear = function () {
            dict = [];
            codeSize = minCodeSize + 1;
            for (var i = 0; i < clearCode; i++) {
                dict[i] = [i];
            }
            dict[clearCode] = [];
            dict[eoiCode] = null;

        };

        var code;
        var last;

        while (true) {
            last = code;
            code = readCode(codeSize);

            if (code === clearCode) {
                clear();
                continue;
            }
            if (code === eoiCode) break;

            if (code < dict.length) {
                if (last !== clearCode) {
                    dict.push(dict[last].concat(dict[code][0]));
                }
            }
            else {
                if (code !== dict.length) throw new Error('Invalid LZW code.');
                dict.push(dict[last].concat(dict[last][0]));
            }
            output.push.apply(output, dict[code]);

            if (dict.length === (1 << codeSize) && codeSize < 12) {
                // If we're at the last code and codeSize is 12, the next code will be a clearCode, and it'll be 12 bits long.
                codeSize++;
            }
        }

        // I don't know if this is technically an error, but some GIFs do it.
        //if (Math.ceil(pos / 8) !== data.length) throw new Error('Extraneous LZW bytes.');
        return output;
    };


    // The actual parsing; returns an object with properties.
    var parseGIF = function (st, handler) {
        handler || (handler = {});

        // LZW (GIF-specific)
        var parseCT = function (entries) { // Each entry is 3 bytes, for RGB.
            var ct = [];
            for (var i = 0; i < entries; i++) {
                ct.push(st.readBytes(3));
            }
            return ct;
        };

        var readSubBlocks = function () {
            var size, data;
            data = '';
            do {
                size = st.readByte();
                data += st.read(size);
            } while (size !== 0);
            return data;
        };

        var parseHeader = function () {
            var hdr = {};
            hdr.sig = st.read(3);
            hdr.ver = st.read(3);
            if (hdr.sig !== 'GIF') throw new Error('Not a GIF file.'); // XXX: This should probably be handled more nicely.
            hdr.width = st.readUnsigned();
            hdr.height = st.readUnsigned();

            var bits = byteToBitArr(st.readByte());
            hdr.gctFlag = bits.shift();
            hdr.colorRes = bitsToNum(bits.splice(0, 3));
            hdr.sorted = bits.shift();
            hdr.gctSize = bitsToNum(bits.splice(0, 3));

            hdr.bgColor = st.readByte();
            hdr.pixelAspectRatio = st.readByte(); // if not 0, aspectRatio = (pixelAspectRatio + 15) / 64
            if (hdr.gctFlag) {
                hdr.gct = parseCT(1 << (hdr.gctSize + 1));
            }
            handler.hdr && handler.hdr(hdr);
        };

        var parseExt = function (block) {
            var parseGCExt = function (block) {
                var blockSize = st.readByte(); // Always 4
                var bits = byteToBitArr(st.readByte());
                block.reserved = bits.splice(0, 3); // Reserved; should be 000.
                block.disposalMethod = bitsToNum(bits.splice(0, 3));
                block.userInput = bits.shift();
                block.transparencyGiven = bits.shift();

                block.delayTime = st.readUnsigned();

                block.transparencyIndex = st.readByte();

                block.terminator = st.readByte();

                handler.gce && handler.gce(block);
            };

            var parseComExt = function (block) {
                block.comment = readSubBlocks();
                handler.com && handler.com(block);
            };

            var parsePTExt = function (block) {
                // No one *ever* uses this. If you use it, deal with parsing it yourself.
                var blockSize = st.readByte(); // Always 12
                block.ptHeader = st.readBytes(12);
                block.ptData = readSubBlocks();
                handler.pte && handler.pte(block);
            };

            var parseAppExt = function (block) {
                var parseNetscapeExt = function (block) {
                    var blockSize = st.readByte(); // Always 3
                    block.unknown = st.readByte(); // ??? Always 1? What is this?
                    block.iterations = st.readUnsigned();
                    block.terminator = st.readByte();
                    handler.app && handler.app.NETSCAPE && handler.app.NETSCAPE(block);
                };

                var parseUnknownAppExt = function (block) {
                    block.appData = readSubBlocks();
                    // FIXME: This won't work if a handler wants to match on any identifier.
                    handler.app && handler.app[block.identifier] && handler.app[block.identifier](block);
                };

                var blockSize = st.readByte(); // Always 11
                block.identifier = st.read(8);
                block.authCode = st.read(3);
                switch (block.identifier) {
                    case 'NETSCAPE':
                        parseNetscapeExt(block);
                        break;
                    default:
                        parseUnknownAppExt(block);
                        break;
                }
            };

            var parseUnknownExt = function (block) {
                block.data = readSubBlocks();
                handler.unknown && handler.unknown(block);
            };

            block.label = st.readByte();
            switch (block.label) {
                case 0xF9:
                    block.extType = 'gce';
                    parseGCExt(block);
                    break;
                case 0xFE:
                    block.extType = 'com';
                    parseComExt(block);
                    break;
                case 0x01:
                    block.extType = 'pte';
                    parsePTExt(block);
                    break;
                case 0xFF:
                    block.extType = 'app';
                    parseAppExt(block);
                    break;
                default:
                    block.extType = 'unknown';
                    parseUnknownExt(block);
                    break;
            }
        };

        var parseImg = function (img) {
            var deinterlace = function (pixels, width) {
                // Of course this defeats the purpose of interlacing. And it's *probably*
                // the least efficient way it's ever been implemented. But nevertheless...
                var newPixels = new Array(pixels.length);
                var rows = pixels.length / width;
                var cpRow = function (toRow, fromRow) {
                    var fromPixels = pixels.slice(fromRow * width, (fromRow + 1) * width);
                    newPixels.splice.apply(newPixels, [toRow * width, width].concat(fromPixels));
                };

                // See appendix E.
                var offsets = [0, 4, 2, 1];
                var steps = [8, 8, 4, 2];

                var fromRow = 0;
                for (var pass = 0; pass < 4; pass++) {
                    for (var toRow = offsets[pass]; toRow < rows; toRow += steps[pass]) {
                        cpRow(toRow, fromRow)
                        fromRow++;
                    }
                }

                return newPixels;
            };

            img.leftPos = st.readUnsigned();
            img.topPos = st.readUnsigned();
            img.width = st.readUnsigned();
            img.height = st.readUnsigned();

            var bits = byteToBitArr(st.readByte());
            img.lctFlag = bits.shift();
            img.interlaced = bits.shift();
            img.sorted = bits.shift();
            img.reserved = bits.splice(0, 2);
            img.lctSize = bitsToNum(bits.splice(0, 3));

            if (img.lctFlag) {
                img.lct = parseCT(1 << (img.lctSize + 1));
            }

            img.lzwMinCodeSize = st.readByte();

            var lzwData = readSubBlocks();

            img.pixels = lzwDecode(img.lzwMinCodeSize, lzwData);

            if (img.interlaced) { // Move
                img.pixels = deinterlace(img.pixels, img.width);
            }

            handler.img && handler.img(img);
        };

        var parseBlock = function () {
            var block = {};
            block.sentinel = st.readByte();

            switch (String.fromCharCode(block.sentinel)) { // For ease of matching
                case '!':
                    block.type = 'ext';
                    parseExt(block);
                    break;
                case ',':
                    block.type = 'img';
                    parseImg(block);
                    break;
                case ';':
                    block.type = 'eof';
                    handler.eof && handler.eof(block);
                    break;
                default:
                    throw new Error('Unknown block: 0x' + block.sentinel.toString(16)); // TODO: Pad this with a 0.
            }

            if (block.type !== 'eof') setTimeout(parseBlock, 0);
        };

        var parse = function () {
            parseHeader();
            setTimeout(parseBlock, 0);
        };

        parse();
    };

    var SuperGif = function ( opts ) {
        var options = {
            //viewport position
            vp_l: 0,
            vp_t: 0,
            vp_w: null,
            vp_h: null,
            //canvas sizes
            c_w: null,
            c_h: null
        };
        for (var i in opts ) { options[i] = opts[i] }
        if (options.vp_w && options.vp_h) options.is_vp = true;

        var stream;
        var hdr;

        var loadError = null;
        var loading = false;

        var transparency = null;
        var delay = null;
        var disposalMethod = null;
        var disposalRestoreFromIdx = null;
        var lastDisposalMethod = null;
        var frame = null;
        var lastImg = null;

        var playing = true;
        var forward = true;

        var ctx_scaled = false;

        var frames = [];
        var frameOffsets = []; // elements have .x and .y properties

        var gif = options.gif;
        if (typeof options.auto_play == 'undefined')
            options.auto_play = (!gif.getAttribute('rel:auto_play') || gif.getAttribute('rel:auto_play') == '1');

        var onEndListener = (options.hasOwnProperty('on_end') ? options.on_end : null);
        var onErrorListener = (options.hasOwnProperty('on_error') ? options.on_error : null);
        var loopDelay = (options.hasOwnProperty('loop_delay') ? options.loop_delay : 0);
        var overrideLoopMode = (options.hasOwnProperty('loop_mode') ? options.loop_mode : 'auto');
        var drawWhileLoading = (options.hasOwnProperty('draw_while_loading') ? options.draw_while_loading : true);
        var showProgressBar = drawWhileLoading ? (options.hasOwnProperty('show_progress_bar') ? options.show_progress_bar : true) : false;
        var progressBarHeight = (options.hasOwnProperty('progressbar_height') ? options.progressbar_height : 25);
        var progressBarBackgroundColor = (options.hasOwnProperty('progressbar_background_color') ? options.progressbar_background_color : 'rgba(255,255,255,0.4)');
        var progressBarForegroundColor = (options.hasOwnProperty('progressbar_foreground_color') ? options.progressbar_foreground_color : 'rgba(255,0,22,.8)');

        var clear = function () {
            transparency = null;
            delay = null;
            lastDisposalMethod = disposalMethod;
            disposalMethod = null;
            frame = null;
        };

        // XXX: There's probably a better way to handle catching exceptions when
        // callbacks are involved.
        var doParse = function () {
            try {
                parseGIF(stream, handler);
            }
            catch (err) {
                doLoadError('parse');
            }
        };

        var doText = function (text) {
            toolbar.innerHTML = text; // innerText? Escaping? Whatever.
            toolbar.style.visibility = 'visible';
        };

        var setSizes = function(w, h) {
            canvas.width = w * get_canvas_scale();
            canvas.height = h * get_canvas_scale();
            toolbar.style.minWidth = ( w * get_canvas_scale() ) + 'px';

            tmpCanvas.width = w;
            tmpCanvas.height = h;
            tmpCanvas.style.width = w + 'px';
            tmpCanvas.style.height = h + 'px';
            tmpCanvas.getContext('2d', { willReadFrequently: true }).setTransform(1, 0, 0, 1, 0, 0);
        };

        var setFrameOffset = function(frame, offset) {
            if (!frameOffsets[frame]) {
                frameOffsets[frame] = offset;
                return;
            }
            if (typeof offset.x !== 'undefined') {
                frameOffsets[frame].x = offset.x;
            }
            if (typeof offset.y !== 'undefined') {
                frameOffsets[frame].y = offset.y;
            }
        };

        var doShowProgress = function (pos, length, draw) {
            if (draw && showProgressBar) {
                var height = progressBarHeight;
                var left, mid, top, width;
                if (options.is_vp) {
                    if (!ctx_scaled) {
                        top = (options.vp_t + options.vp_h - height);
                        height = height;
                        left = options.vp_l;
                        mid = left + (pos / length) * options.vp_w;
                        width = canvas.width;
                    } else {
                        top = (options.vp_t + options.vp_h - height) / get_canvas_scale();
                        height = height / get_canvas_scale();
                        left = (options.vp_l / get_canvas_scale() );
                        mid = left + (pos / length) * (options.vp_w / get_canvas_scale());
                        width = canvas.width / get_canvas_scale();
                    }
                    //some debugging, draw rect around viewport
                    if (false) // removed by dead control flow
{ var w, h, l, t; }
                }
                else {
                    top = (canvas.height - height) / (ctx_scaled ? get_canvas_scale() : 1);
                    mid = ((pos / length) * canvas.width) / (ctx_scaled ? get_canvas_scale() : 1);
                    width = canvas.width / (ctx_scaled ? get_canvas_scale() : 1 );
                    height /= ctx_scaled ? get_canvas_scale() : 1;
                }

                ctx.fillStyle = progressBarBackgroundColor;
                ctx.fillRect(mid, top, width - mid, height);

                ctx.fillStyle = progressBarForegroundColor;
                ctx.fillRect(0, top, mid, height);
            }
        };

        var doLoadError = function (originOfError) {
            var drawError = function () {
                ctx.fillStyle = 'black';
                ctx.fillRect(0, 0, options.c_w ? options.c_w : hdr.width, options.c_h ? options.c_h : hdr.height);
                ctx.strokeStyle = 'red';
                ctx.lineWidth = 3;
                ctx.moveTo(0, 0);
                ctx.lineTo(options.c_w ? options.c_w : hdr.width, options.c_h ? options.c_h : hdr.height);
                ctx.moveTo(0, options.c_h ? options.c_h : hdr.height);
                ctx.lineTo(options.c_w ? options.c_w : hdr.width, 0);
                ctx.stroke();
            };

            loadError = originOfError;
            hdr = {
                width: gif.width,
                height: gif.height
            }; // Fake header.
            frames = [];
            drawError();

            if (originOfError)
                onErrorListener ?.(originOfError);
        };

        var doHdr = function (_hdr) {
            hdr = _hdr;
            setSizes(hdr.width, hdr.height)
        };

        var doGCE = function (gce) {
            pushFrame();
            clear();
            transparency = gce.transparencyGiven ? gce.transparencyIndex : null;
            delay = gce.delayTime;
            disposalMethod = gce.disposalMethod;
            // We don't have much to do with the rest of GCE.
        };

        var pushFrame = function () {
            if (!frame) return;
            frames.push({
                            data: frame.getImageData(0, 0, hdr.width, hdr.height),
                            delay: delay
                        });
            frameOffsets.push({ x: 0, y: 0 });
        };

        var doImg = function (img) {
            if (!frame) frame = tmpCanvas.getContext('2d', { willReadFrequently: true });

            var currIdx = frames.length;

            //ct = color table, gct = global color table
            var ct = img.lctFlag ? img.lct : hdr.gct; // TODO: What if neither exists?

            /*
            Disposal method indicates the way in which the graphic is to
            be treated after being displayed.

            Values :    0 - No disposal specified. The decoder is
                            not required to take any action.
                        1 - Do not dispose. The graphic is to be left
                            in place.
                        2 - Restore to background color. The area used by the
                            graphic must be restored to the background color.
                        3 - Restore to previous. The decoder is required to
                            restore the area overwritten by the graphic with
                            what was there prior to rendering the graphic.

                            Importantly, "previous" means the frame state
                            after the last disposal of method 0, 1, or 2.
            */
            if (currIdx > 0) {
                if (lastDisposalMethod === 3) {
                    // Restore to previous
                    // If we disposed every frame including first frame up to this point, then we have
                    // no composited frame to restore to. In this case, restore to background instead.
                    if (disposalRestoreFromIdx !== null) {
                    	frame.putImageData(frames[disposalRestoreFromIdx].data, 0, 0);
                    } else {
                    	frame.clearRect(lastImg.leftPos, lastImg.topPos, lastImg.width, lastImg.height);
                    }
                } else {
                    disposalRestoreFromIdx = currIdx - 1;
                }

                if (lastDisposalMethod === 2) {
                    // Restore to background color
                    // Browser implementations historically restore to transparent; we do the same.
                    // http://www.wizards-toolkit.org/discourse-server/viewtopic.php?f=1&t=21172#p86079
                    frame.clearRect(lastImg.leftPos, lastImg.topPos, lastImg.width, lastImg.height);
                }
            }
            // else, Undefined/Do not dispose.
            // frame contains final pixel data from the last frame; do nothing

            //Get existing pixels for img region after applying disposal method
            var imgData = frame.getImageData(img.leftPos, img.topPos, img.width, img.height);

            //apply color table colors
            img.pixels.forEach(function (pixel, i) {
                // imgData.data === [R,G,B,A,R,G,B,A,...]
                if (pixel !== transparency) {
                    imgData.data[i * 4 + 0] = ct[pixel][0];
                    imgData.data[i * 4 + 1] = ct[pixel][1];
                    imgData.data[i * 4 + 2] = ct[pixel][2];
                    imgData.data[i * 4 + 3] = 255; // Opaque.
                }
            });

            frame.putImageData(imgData, img.leftPos, img.topPos);

            if (!ctx_scaled) {
                ctx.scale(get_canvas_scale(),get_canvas_scale());
                ctx_scaled = true;
            }

            // We could use the on-page canvas directly, except that we draw a progress
            // bar for each image chunk (not just the final image).
            if (drawWhileLoading) {
                ctx.drawImage(tmpCanvas, 0, 0);
                drawWhileLoading = options.auto_play;
            }

            lastImg = img;
        };

        var player = (function () {
            var i = -1;
            var iterationCount = 0;

            var showingInfo = false;
            var pinned = false;

            /**
             * Gets the index of the frame "up next".
             * @returns {number}
             */
            var getNextFrameNo = function () {
                var delta = (forward ? 1 : -1);
                return (i + delta + frames.length) % frames.length;
            };

            var stepFrame = function (amount) { // XXX: Name is confusing.
                i = i + amount;

                putFrame();
            };

            var step = (function () {
                var stepping = false;

                var completeLoop = function () {
                    if (onEndListener !== null)
                        onEndListener(gif);
                    iterationCount++;

                    if (overrideLoopMode !== false || iterationCount < 0) {
                        doStep();
                    } else {
                        stepping = false;
                        playing = false;
                    }
                };

                var doStep = function () {
                    stepping = playing;
                    if (!stepping) return;

                    stepFrame(1);
                    var delay = frames[i].delay * 10;
                    if (!delay) delay = 100; // FIXME: Should this even default at all? What should it be?

                    var nextFrameNo = getNextFrameNo();
                    if (nextFrameNo === 0) {
                        delay += loopDelay;
                        setTimeout(completeLoop, delay);
                    } else {
                        setTimeout(doStep, delay);
                    }
                };

                return function () {
                    if (!stepping) setTimeout(doStep, 0);
                };
            }());

            var putFrame = function () {
                var offset;
                i = parseInt(i, 10);

                if (i > frames.length - 1){
                    i = 0;
                }

                if (i < 0){
                    i = 0;
                }

                offset = frameOffsets[i];

                tmpCanvas.getContext("2d", { willReadFrequently: true }).putImageData(frames[i].data, offset.x, offset.y);
                ctx.globalCompositeOperation = "copy";
                ctx.drawImage(tmpCanvas, 0, 0);
            };

            var play = function () {
                playing = true;
                step();
            };

            var pause = function () {
                playing = false;
            };


            return {
                init: function () {
                    if (loadError) return;

                    if ( ! (options.c_w && options.c_h) ) {
                        ctx.scale(get_canvas_scale(),get_canvas_scale());
                    }

                    if (options.auto_play) {
                        step();
                    }
                    else {
                        i = 0;
                        putFrame();
                    }
                },
                step: step,
                play: play,
                pause: pause,
                playing: playing,
                move_relative: stepFrame,
                current_frame: function() { return i; },
                length: function() { return frames.length },
                move_to: function ( frame_idx ) {
                    i = frame_idx;
                    putFrame();
                }
            }
        }());

        var doDecodeProgress = function (draw) {
            doShowProgress(stream.pos, stream.data.length, draw);
        };

        var doNothing = function () {};
        /**
         * @param{boolean=} draw Whether to draw progress bar or not; this is not idempotent because of translucency.
         *                       Note that this means that the text will be unsynchronized with the progress bar on non-frames;
         *                       but those are typically so small (GCE etc.) that it doesn't really matter. TODO: Do this properly.
         */
        var withProgress = function (fn, draw) {
            return function (block) {
                fn(block);
                doDecodeProgress(draw);
            };
        };


        var handler = {
            hdr: withProgress(doHdr),
            gce: withProgress(doGCE),
            com: withProgress(doNothing),
            // I guess that's all for now.
            app: {
                // TODO: Is there much point in actually supporting iterations?
                NETSCAPE: withProgress(doNothing)
            },
            img: withProgress(doImg, true),
            eof: function (block) {
                //toolbar.style.display = '';
                pushFrame();
                doDecodeProgress(false);
                if ( ! (options.c_w && options.c_h) ) {
                    canvas.width = hdr.width * get_canvas_scale();
                    canvas.height = hdr.height * get_canvas_scale();
                }
                player.init();
                loading = false;
                if (load_callback) {
                    load_callback(gif);
                }

            }
        };

        var init = function () {
            var parent = gif.parentNode;

            var div = document.createElement('div');
            canvas = document.createElement('canvas');
            ctx = canvas.getContext('2d', { willReadFrequently: true });
            toolbar = document.createElement('div');

            tmpCanvas = document.createElement('canvas');

            div.width = canvas.width = gif.width;
            div.height = canvas.height = gif.height;
            toolbar.style.minWidth = gif.width + 'px';

            div.className = 'jsgif';
            toolbar.className = 'jsgif_toolbar';
            div.appendChild(canvas);
            div.appendChild(toolbar);

            parent.insertBefore(div, gif);
            parent.removeChild(gif);

            if (options.c_w && options.c_h) setSizes(options.c_w, options.c_h);
            initialized=true;
        };

        var get_canvas_scale = function() {
            var scale;
            if (options.max_width && hdr && hdr.width > options.max_width) {
                scale = options.max_width / hdr.width;
            }
            else {
                scale = 1;
            }
            return scale;
        }

        var canvas, ctx, toolbar, tmpCanvas;
        var initialized = false;
        var load_callback = false;

        var load_setup = function(callback) {
            if (loading) return false;
            if (callback) load_callback = callback;
            else load_callback = false;

            loading = true;
            frames = [];
            clear();
            disposalRestoreFromIdx = null;
            lastDisposalMethod = null;
            frame = null;
            lastImg = null;

            return true;
        }

        var calculateDuration = function() {
            return frames.reduce(function(duration, frame) {
                return duration + frame.delay;
            }, 0);
        }

        return {
            // play controls
            play: player.play,
            pause: player.pause,
            move_relative: player.move_relative,
            move_to: player.move_to,

            // getters for instance vars
            get_playing      : function() { return playing },
            get_canvas       : function() { return canvas },
            get_canvas_scale : function() { return get_canvas_scale() },
            get_loading      : function() { return loading },
            get_auto_play    : function() { return options.auto_play },
            get_length       : function() { return player.length() },
            get_frames       : function() { return frames },
            get_duration     : function() { return calculateDuration() },
            get_duration_ms  : function() { return calculateDuration() * 10 },
            get_current_frame: function() { return player.current_frame() },
            load_url: function(src,callback){
                if (!load_setup(callback)) return;

                var h = new XMLHttpRequest();
                // new browsers (XMLHttpRequest2-compliant)
                h.open('GET', src, true);

                if ('overrideMimeType' in h) {
                    h.overrideMimeType('text/plain; charset=x-user-defined');
                }

                // old browsers (XMLHttpRequest-compliant)
                else if ('responseType' in h) {
                    h.responseType = 'arraybuffer';
                }

                // IE9 (Microsoft.XMLHTTP-compliant)
                else {
                    h.setRequestHeader('Accept-Charset', 'x-user-defined');
                }

                h.onloadstart = function() {
                    // Wait until connection is opened to replace the gif element with a canvas to avoid a blank img
                    if (!initialized) init();
                };
                h.onload = function(e) {
                    if (this.status != 200) {
                        doLoadError('xhr - response');
                    }
                    // emulating response field for IE9
                    if (!('response' in this)) {
                        this.response = new VBArray(this.responseText).toArray().map(String.fromCharCode).join('');
                    }
                    var data = this.response;
                    if (data.toString().indexOf("ArrayBuffer") > 0) {
                        data = new Uint8Array(data);
                    }

                    stream = new Stream(data);
                    setTimeout(doParse, 0);
                };
                h.onprogress = function (e) {
                    if (e.lengthComputable) doShowProgress(e.loaded, e.total, true);
                };
                h.onerror = function() { doLoadError('xhr'); };
                h.send();
            },
            load: function (callback) {
                this.load_url(gif.getAttribute('rel:animated_src') || gif.src,callback);
            },
            load_raw: function(arr, callback) {
                if (!load_setup(callback)) return;
                if (!initialized) init();
                stream = new Stream(arr);
                setTimeout(doParse, 0);
            },
            set_frame_offset: setFrameOffset
        };
    };

    return SuperGif;
}));




/***/ },

/***/ 6878
(module) {

(function webpackUniversalModuleDefinition(root, factory) {
	if(true)
		module.exports = factory();
	else // removed by dead control flow
{}
})(this, function() {
return /******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};

/******/ 	// The require function
/******/ 	function __nested_webpack_require_529__(moduleId) {

/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId])
/******/ 			return installedModules[moduleId].exports;

/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			exports: {},
/******/ 			id: moduleId,
/******/ 			loaded: false
/******/ 		};

/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __nested_webpack_require_529__);

/******/ 		// Flag the module as loaded
/******/ 		module.loaded = true;

/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}


/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__nested_webpack_require_529__.m = modules;

/******/ 	// expose the module cache
/******/ 	__nested_webpack_require_529__.c = installedModules;

/******/ 	// __webpack_public_path__
/******/ 	__nested_webpack_require_529__.p = "";

/******/ 	// Load entry module and return exports
/******/ 	return __nested_webpack_require_529__(0);
/******/ })
/************************************************************************/
/******/ ([
/* 0 */
/***/ (function(module, exports, __nested_webpack_require_1730__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	    value: true
	});
	exports.isNotPNG = isNotPNG;
	exports.isNotAPNG = isNotAPNG;
	exports.default = parseAPNG;

	var _crc = __nested_webpack_require_1730__(1);

	var _crc2 = _interopRequireDefault(_crc);

	var _structs = __nested_webpack_require_1730__(2);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	var errNotPNG = new Error('Not a PNG');
	var errNotAPNG = new Error('Not an animated PNG');

	function isNotPNG(err) {
	    return err === errNotPNG;
	}
	function isNotAPNG(err) {
	    return err === errNotAPNG;
	}

	// '\x89PNG\x0d\x0a\x1a\x0a'
	var PNGSignature = new Uint8Array([0x89, 0x50, 0x4e, 0x47, 0x0d, 0x0a, 0x1a, 0x0a]);

	/**
	 * Parse APNG data
	 * @param {ArrayBuffer} buffer
	 * @return {APNG|Error}
	 */
	function parseAPNG(buffer) {
	    var bytes = new Uint8Array(buffer);

	    if (Array.prototype.some.call(PNGSignature, function (b, i) {
	        return b !== bytes[i];
	    })) {
	        return errNotPNG;
	    }

	    // fast animation test
	    var isAnimated = false;
	    eachChunk(bytes, function (type) {
	        return !(isAnimated = type === 'acTL');
	    });
	    if (!isAnimated) {
	        return errNotAPNG;
	    }

	    var preDataParts = [],
	        postDataParts = [];
	    var headerDataBytes = null,
	        frame = null,
	        frameNumber = 0,
	        apng = new _structs.APNG();

	    eachChunk(bytes, function (type, bytes, off, length) {
	        var dv = new DataView(bytes.buffer);
	        switch (type) {
	            case 'IHDR':
	                headerDataBytes = bytes.subarray(off + 8, off + 8 + length);
	                apng.width = dv.getUint32(off + 8);
	                apng.height = dv.getUint32(off + 12);
	                break;
	            case 'acTL':
	                apng.numPlays = dv.getUint32(off + 8 + 4);
	                break;
	            case 'fcTL':
	                if (frame) {
	                    apng.frames.push(frame);
	                    frameNumber++;
	                }
	                frame = new _structs.Frame();
	                frame.width = dv.getUint32(off + 8 + 4);
	                frame.height = dv.getUint32(off + 8 + 8);
	                frame.left = dv.getUint32(off + 8 + 12);
	                frame.top = dv.getUint32(off + 8 + 16);
	                var delayN = dv.getUint16(off + 8 + 20);
	                var delayD = dv.getUint16(off + 8 + 22);
	                if (delayD === 0) {
	                    delayD = 100;
	                }
	                frame.delay = 1000 * delayN / delayD;
	                // https://bugzilla.mozilla.org/show_bug.cgi?id=125137
	                // https://bugzilla.mozilla.org/show_bug.cgi?id=139677
	                // https://bugzilla.mozilla.org/show_bug.cgi?id=207059
	                if (frame.delay <= 10) {
	                    frame.delay = 100;
	                }
	                apng.playTime += frame.delay;
	                frame.disposeOp = dv.getUint8(off + 8 + 24);
	                frame.blendOp = dv.getUint8(off + 8 + 25);
	                frame.dataParts = [];
	                if (frameNumber === 0 && frame.disposeOp === 2) {
	                    frame.disposeOp = 1;
	                }
	                break;
	            case 'fdAT':
	                if (frame) {
	                    frame.dataParts.push(bytes.subarray(off + 8 + 4, off + 8 + length));
	                }
	                break;
	            case 'IDAT':
	                if (frame) {
	                    frame.dataParts.push(bytes.subarray(off + 8, off + 8 + length));
	                }
	                break;
	            case 'IEND':
	                postDataParts.push(subBuffer(bytes, off, 12 + length));
	                break;
	            default:
	                preDataParts.push(subBuffer(bytes, off, 12 + length));
	        }
	    });

	    if (frame) {
	        apng.frames.push(frame);
	    }

	    if (apng.frames.length == 0) {
	        return errNotAPNG;
	    }

	    var preBlob = new Blob(preDataParts),
	        postBlob = new Blob(postDataParts);

	    apng.frames.forEach(function (frame) {
	        var bb = [];
	        bb.push(PNGSignature);
	        headerDataBytes.set(makeDWordArray(frame.width), 0);
	        headerDataBytes.set(makeDWordArray(frame.height), 4);
	        bb.push(makeChunkBytes('IHDR', headerDataBytes));
	        bb.push(preBlob);
	        frame.dataParts.forEach(function (p) {
	            return bb.push(makeChunkBytes('IDAT', p));
	        });
	        bb.push(postBlob);
	        frame.imageData = new Blob(bb, { 'type': 'image/png' });
	        delete frame.dataParts;
	        bb = null;
	    });

	    return apng;
	}

	/**
	 * @param {Uint8Array} bytes
	 * @param {function(string, Uint8Array, int, int): boolean} callback
	 */
	function eachChunk(bytes, callback) {
	    var dv = new DataView(bytes.buffer);
	    var off = 8,
	        type = void 0,
	        length = void 0,
	        res = void 0;
	    do {
	        length = dv.getUint32(off);
	        type = readString(bytes, off + 4, 4);
	        res = callback(type, bytes, off, length);
	        off += 12 + length;
	    } while (res !== false && type != 'IEND' && off < bytes.length);
	}

	/**
	 *
	 * @param {Uint8Array} bytes
	 * @param {number} off
	 * @param {number} length
	 * @return {string}
	 */
	function readString(bytes, off, length) {
	    var chars = Array.prototype.slice.call(bytes.subarray(off, off + length));
	    return String.fromCharCode.apply(String, chars);
	}

	/**
	 *
	 * @param {string} x
	 * @return {Uint8Array}
	 */
	function makeStringArray(x) {
	    var res = new Uint8Array(x.length);
	    for (var i = 0; i < x.length; i++) {
	        res[i] = x.charCodeAt(i);
	    }
	    return res;
	}

	/**
	 * @param {Uint8Array} bytes
	 * @param {int} start
	 * @param {int} length
	 * @return {Uint8Array}
	 */
	function subBuffer(bytes, start, length) {
	    var a = new Uint8Array(length);
	    a.set(bytes.subarray(start, start + length));
	    return a;
	}

	/**
	 * @param {string} type
	 * @param {Uint8Array} dataBytes
	 * @return {Uint8Array}
	 */
	var makeChunkBytes = function makeChunkBytes(type, dataBytes) {
	    var crcLen = type.length + dataBytes.length;
	    var bytes = new Uint8Array(crcLen + 8);
	    var dv = new DataView(bytes.buffer);

	    dv.setUint32(0, dataBytes.length);
	    bytes.set(makeStringArray(type), 4);
	    bytes.set(dataBytes, 8);
	    var crc = (0, _crc2.default)(bytes, 4, crcLen);
	    dv.setUint32(crcLen + 4, crc);
	    return bytes;
	};

	var makeDWordArray = function makeDWordArray(x) {
	    return new Uint8Array([x >>> 24 & 0xff, x >>> 16 & 0xff, x >>> 8 & 0xff, x & 0xff]);
	};

/***/ }),
/* 1 */
/***/ (function(module, exports) {

	"use strict";

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	exports.default = function (bytes) {
	  var start = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
	  var length = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : bytes.length - start;

	  var crc = -1;
	  for (var _i = start, l = start + length; _i < l; _i++) {
	    crc = crc >>> 8 ^ table[(crc ^ bytes[_i]) & 0xFF];
	  }
	  return crc ^ -1;
	};

	var table = new Uint32Array(256);

	for (var i = 0; i < 256; i++) {
	  var c = i;
	  for (var k = 0; k < 8; k++) {
	    c = (c & 1) !== 0 ? 0xEDB88320 ^ c >>> 1 : c >>> 1;
	  }
	  table[i] = c;
	}

	/**
	 *
	 * @param {Uint8Array} bytes
	 * @param {number} start
	 * @param {number} length
	 * @return {number}
	 */

/***/ }),
/* 2 */
/***/ (function(module, exports, __nested_webpack_require_9403__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	    value: true
	});
	exports.Frame = exports.APNG = undefined;

	var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

	var _player = __nested_webpack_require_9403__(3);

	var _player2 = _interopRequireDefault(_player);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

	/**
	 * @property {number} currFrameNumber
	 * @property {Frame} currFrame
	 * @property {boolean} paused
	 * @property {boolean} ended
	 */
	var APNG = exports.APNG = function () {
	    function APNG() {
	        _classCallCheck(this, APNG);

	        this.width = 0;
	        this.height = 0;
	        this.numPlays = 0;
	        this.playTime = 0;
	        this.frames = [];
	    }
	    /** @type {number} */

	    /** @type {number} */

	    /** @type {number} */

	    /** @type {number} */

	    /** @type {Frame[]} */


	    _createClass(APNG, [{
	        key: 'createImages',


	        /**
	         *
	         * @return {Promise.<*>}
	         */
	        value: function createImages() {
	            return Promise.all(this.frames.map(function (f) {
	                return f.createImage();
	            }));
	        }

	        /**
	         *
	         * @param {CanvasRenderingContext2D} context
	         * @param {boolean} autoPlay
	         * @return {Promise.<Player>}
	         */

	    }, {
	        key: 'getPlayer',
	        value: function getPlayer(context) {
	            var _this = this;

	            var autoPlay = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;

	            return this.createImages().then(function () {
	                return new _player2.default(_this, context, autoPlay);
	            });
	        }
	    }]);

	    return APNG;
	}();

	var Frame = exports.Frame = function () {
	    function Frame() {
	        _classCallCheck(this, Frame);

	        this.left = 0;
	        this.top = 0;
	        this.width = 0;
	        this.height = 0;
	        this.delay = 0;
	        this.disposeOp = 0;
	        this.blendOp = 0;
	        this.imageData = null;
	        this.imageElement = null;
	    }
	    /** @type {number} */

	    /** @type {number} */

	    /** @type {number} */

	    /** @type {number} */

	    /** @type {number} */

	    /** @type {number} */

	    /** @type {number} */

	    /** @type {Blob} */

	    /** @type {HTMLImageElement} */


	    _createClass(Frame, [{
	        key: 'createImage',
	        value: function createImage() {
	            var _this2 = this;

	            if (this.imageElement) {
	                return Promise.resolve();
	            }
	            return new Promise(function (resolve, reject) {
	                var url = URL.createObjectURL(_this2.imageData);
	                _this2.imageElement = document.createElement('img');
	                _this2.imageElement.onload = function () {
	                    URL.revokeObjectURL(url);
	                    resolve();
	                };
	                _this2.imageElement.onerror = function () {
	                    URL.revokeObjectURL(url);
	                    _this2.imageElement = null;
	                    reject(new Error("Image creation error"));
	                };
	                _this2.imageElement.src = url;
	            });
	        }
	    }]);

	    return Frame;
	}();

/***/ }),
/* 3 */
/***/ (function(module, exports, __nested_webpack_require_13509__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	    value: true
	});

	var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

	var _events = __nested_webpack_require_13509__(4);

	var _events2 = _interopRequireDefault(_events);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

	function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

	function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

	var _class = function (_EventEmitter) {
	    _inherits(_class, _EventEmitter);

	    /**
	     * @param {APNG} apng
	     * @param {CanvasRenderingContext2D} context
	     * @param {boolean} autoPlay
	     */

	    /** @type {number} */


	    /** @type {boolean} */

	    /** @type {ImageData} */


	    /** @type {APNG} */

	    /** @type {CanvasRenderingContext2D} */
	    function _class(apng, context, autoPlay) {
	        _classCallCheck(this, _class);

	        var _this = _possibleConstructorReturn(this, (_class.__proto__ || Object.getPrototypeOf(_class)).call(this));

	        _this.playbackRate = 1.0;
	        _this._currentFrameNumber = 0;
	        _this._ended = false;
	        _this._paused = true;
	        _this._numPlays = 0;
	        _this._rafId = null;

	        _this._apng = apng;
	        _this.context = context;
	        _this.stop();
	        if (autoPlay) {
	            _this.play();
	        }
	        return _this;
	    }

	    /**
	     *
	     * @return {number}
	     */

	    /** @type {number|null} */

	    /** @type {boolean} */

	    /** @type {number} */

	    /** @type {Frame} */

	    /** @type {number} */


	    _createClass(_class, [{
	        key: 'renderNextFrame',
	        value: function renderNextFrame() {
	            this._currentFrameNumber = (this._currentFrameNumber + 1) % this._apng.frames.length;
	            if (this._currentFrameNumber === this._apng.frames.length - 1) {
	                this._numPlays++;
	                if (this._apng.numPlays !== 0 && this._numPlays >= this._apng.numPlays) {
	                    this._ended = true;
	                    this._paused = true;
	                }
	            }

	            if (this._prevFrame && this._prevFrame.disposeOp == 1) {
	                this.context.clearRect(this._prevFrame.left, this._prevFrame.top, this._prevFrame.width, this._prevFrame.height);
	            } else if (this._prevFrame && this._prevFrame.disposeOp == 2) {
	                this.context.putImageData(this._prevFrameData, this._prevFrame.left, this._prevFrame.top);
	            }

	            var frame = this.currentFrame;
	            this._prevFrame = frame;
	            this._prevFrameData = null;
	            if (frame.disposeOp == 2) {
	                this._prevFrameData = this.context.getImageData(frame.left, frame.top, frame.width, frame.height);
	            }
	            if (frame.blendOp == 0) {
	                this.context.clearRect(frame.left, frame.top, frame.width, frame.height);
	            }

	            this.context.drawImage(frame.imageElement, frame.left, frame.top);

	            this.emit('frame', this._currentFrameNumber);
	            if (this._ended) {
	                this.emit('end');
	            }
	        }

	        // playback

	    }, {
	        key: 'play',
	        value: function play() {
	            var _this2 = this;

	            if (this._rafId) {
	                cancelAnimationFrame(this._rafId);
	            }

	            this.emit('play');

	            if (this._ended) {
	                this.stop();
	            }
	            this._paused = false;

	            var nextRenderTime = performance.now() + this.currentFrame.delay / this.playbackRate;
	            var tick = function tick(now) {
	                if (_this2._ended || _this2._paused) {
	                    return;
	                }
	                if (now >= nextRenderTime) {
	                    while (now - nextRenderTime >= _this2._apng.playTime / _this2.playbackRate) {
	                        nextRenderTime += _this2._apng.playTime / _this2.playbackRate;
	                        _this2._numPlays++;
	                    }
	                    do {
	                        _this2.renderNextFrame();
	                        nextRenderTime += _this2.currentFrame.delay / _this2.playbackRate;
	                    } while (!_this2._ended && !_this2._paused && now > nextRenderTime);
	                }
	                _this2._rafId = requestAnimationFrame(tick);
	            };
	            this._rafId = requestAnimationFrame(tick);
	        }
	    }, {
	        key: 'pause',
	        value: function pause() {
	            if (!this._paused) {
	                if (this._rafId) {
	                    cancelAnimationFrame(this._rafId);
	                    this._rafId = null;
	                }
	                this.emit('pause');
	                this._paused = true;
	            }
	        }
	    }, {
	        key: 'stop',
	        value: function stop() {
	            if (this._rafId) {
	                cancelAnimationFrame(this._rafId);
	                this._rafId = null;
	            }
	            this.emit('stop');
	            this._numPlays = 0;
	            this._ended = false;
	            this._paused = true;
	            // render first frame
	            this._currentFrameNumber = -1;
	            this.context.clearRect(0, 0, this._apng.width, this._apng.height);
	            this.renderNextFrame();
	        }
	    }, {
	        key: 'currentFrameNumber',
	        get: function get() {
	            return this._currentFrameNumber;
	        }

	        /**
	         *
	         * @return {Frame}
	         */

	    }, {
	        key: 'currentFrame',
	        get: function get() {
	            return this._apng.frames[this._currentFrameNumber];
	        }
	    }, {
	        key: 'paused',
	        get: function get() {
	            return this._paused;
	        }
	    }, {
	        key: 'ended',
	        get: function get() {
	            return this._ended;
	        }
	    }]);

	    return _class;
	}(_events2.default);

	exports.default = _class;

/***/ }),
/* 4 */
/***/ (function(module, exports) {

	// Copyright Joyent, Inc. and other Node contributors.
	//
	// Permission is hereby granted, free of charge, to any person obtaining a
	// copy of this software and associated documentation files (the
	// "Software"), to deal in the Software without restriction, including
	// without limitation the rights to use, copy, modify, merge, publish,
	// distribute, sublicense, and/or sell copies of the Software, and to permit
	// persons to whom the Software is furnished to do so, subject to the
	// following conditions:
	//
	// The above copyright notice and this permission notice shall be included
	// in all copies or substantial portions of the Software.
	//
	// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
	// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
	// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
	// NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
	// DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
	// OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
	// USE OR OTHER DEALINGS IN THE SOFTWARE.

	function EventEmitter() {
	  this._events = this._events || {};
	  this._maxListeners = this._maxListeners || undefined;
	}
	module.exports = EventEmitter;

	// Backwards-compat with node 0.10.x
	EventEmitter.EventEmitter = EventEmitter;

	EventEmitter.prototype._events = undefined;
	EventEmitter.prototype._maxListeners = undefined;

	// By default EventEmitters will print a warning if more than 10 listeners are
	// added to it. This is a useful default which helps finding memory leaks.
	EventEmitter.defaultMaxListeners = 10;

	// Obviously not all Emitters should be limited to 10. This function allows
	// that to be increased. Set to zero for unlimited.
	EventEmitter.prototype.setMaxListeners = function(n) {
	  if (!isNumber(n) || n < 0 || isNaN(n))
	    throw TypeError('n must be a positive number');
	  this._maxListeners = n;
	  return this;
	};

	EventEmitter.prototype.emit = function(type) {
	  var er, handler, len, args, i, listeners;

	  if (!this._events)
	    this._events = {};

	  // If there is no 'error' event listener then throw.
	  if (type === 'error') {
	    if (!this._events.error ||
	        (isObject(this._events.error) && !this._events.error.length)) {
	      er = arguments[1];
	      if (er instanceof Error) {
	        throw er; // Unhandled 'error' event
	      } else {
	        // At least give some kind of context to the user
	        var err = new Error('Uncaught, unspecified "error" event. (' + er + ')');
	        err.context = er;
	        throw err;
	      }
	    }
	  }

	  handler = this._events[type];

	  if (isUndefined(handler))
	    return false;

	  if (isFunction(handler)) {
	    switch (arguments.length) {
	      // fast cases
	      case 1:
	        handler.call(this);
	        break;
	      case 2:
	        handler.call(this, arguments[1]);
	        break;
	      case 3:
	        handler.call(this, arguments[1], arguments[2]);
	        break;
	      // slower
	      default:
	        args = Array.prototype.slice.call(arguments, 1);
	        handler.apply(this, args);
	    }
	  } else if (isObject(handler)) {
	    args = Array.prototype.slice.call(arguments, 1);
	    listeners = handler.slice();
	    len = listeners.length;
	    for (i = 0; i < len; i++)
	      listeners[i].apply(this, args);
	  }

	  return true;
	};

	EventEmitter.prototype.addListener = function(type, listener) {
	  var m;

	  if (!isFunction(listener))
	    throw TypeError('listener must be a function');

	  if (!this._events)
	    this._events = {};

	  // To avoid recursion in the case that type === "newListener"! Before
	  // adding it to the listeners, first emit "newListener".
	  if (this._events.newListener)
	    this.emit('newListener', type,
	              isFunction(listener.listener) ?
	              listener.listener : listener);

	  if (!this._events[type])
	    // Optimize the case of one listener. Don't need the extra array object.
	    this._events[type] = listener;
	  else if (isObject(this._events[type]))
	    // If we've already got an array, just append.
	    this._events[type].push(listener);
	  else
	    // Adding the second element, need to change to array.
	    this._events[type] = [this._events[type], listener];

	  // Check for listener leak
	  if (isObject(this._events[type]) && !this._events[type].warned) {
	    if (!isUndefined(this._maxListeners)) {
	      m = this._maxListeners;
	    } else {
	      m = EventEmitter.defaultMaxListeners;
	    }

	    if (m && m > 0 && this._events[type].length > m) {
	      this._events[type].warned = true;
	      console.error('(node) warning: possible EventEmitter memory ' +
	                    'leak detected. %d listeners added. ' +
	                    'Use emitter.setMaxListeners() to increase limit.',
	                    this._events[type].length);
	      if (typeof console.trace === 'function') {
	        // not supported in IE 10
	        console.trace();
	      }
	    }
	  }

	  return this;
	};

	EventEmitter.prototype.on = EventEmitter.prototype.addListener;

	EventEmitter.prototype.once = function(type, listener) {
	  if (!isFunction(listener))
	    throw TypeError('listener must be a function');

	  var fired = false;

	  function g() {
	    this.removeListener(type, g);

	    if (!fired) {
	      fired = true;
	      listener.apply(this, arguments);
	    }
	  }

	  g.listener = listener;
	  this.on(type, g);

	  return this;
	};

	// emits a 'removeListener' event iff the listener was removed
	EventEmitter.prototype.removeListener = function(type, listener) {
	  var list, position, length, i;

	  if (!isFunction(listener))
	    throw TypeError('listener must be a function');

	  if (!this._events || !this._events[type])
	    return this;

	  list = this._events[type];
	  length = list.length;
	  position = -1;

	  if (list === listener ||
	      (isFunction(list.listener) && list.listener === listener)) {
	    delete this._events[type];
	    if (this._events.removeListener)
	      this.emit('removeListener', type, listener);

	  } else if (isObject(list)) {
	    for (i = length; i-- > 0;) {
	      if (list[i] === listener ||
	          (list[i].listener && list[i].listener === listener)) {
	        position = i;
	        break;
	      }
	    }

	    if (position < 0)
	      return this;

	    if (list.length === 1) {
	      list.length = 0;
	      delete this._events[type];
	    } else {
	      list.splice(position, 1);
	    }

	    if (this._events.removeListener)
	      this.emit('removeListener', type, listener);
	  }

	  return this;
	};

	EventEmitter.prototype.removeAllListeners = function(type) {
	  var key, listeners;

	  if (!this._events)
	    return this;

	  // not listening for removeListener, no need to emit
	  if (!this._events.removeListener) {
	    if (arguments.length === 0)
	      this._events = {};
	    else if (this._events[type])
	      delete this._events[type];
	    return this;
	  }

	  // emit removeListener for all listeners on all events
	  if (arguments.length === 0) {
	    for (key in this._events) {
	      if (key === 'removeListener') continue;
	      this.removeAllListeners(key);
	    }
	    this.removeAllListeners('removeListener');
	    this._events = {};
	    return this;
	  }

	  listeners = this._events[type];

	  if (isFunction(listeners)) {
	    this.removeListener(type, listeners);
	  } else if (listeners) {
	    // LIFO order
	    while (listeners.length)
	      this.removeListener(type, listeners[listeners.length - 1]);
	  }
	  delete this._events[type];

	  return this;
	};

	EventEmitter.prototype.listeners = function(type) {
	  var ret;
	  if (!this._events || !this._events[type])
	    ret = [];
	  else if (isFunction(this._events[type]))
	    ret = [this._events[type]];
	  else
	    ret = this._events[type].slice();
	  return ret;
	};

	EventEmitter.prototype.listenerCount = function(type) {
	  if (this._events) {
	    var evlistener = this._events[type];

	    if (isFunction(evlistener))
	      return 1;
	    else if (evlistener)
	      return evlistener.length;
	  }
	  return 0;
	};

	EventEmitter.listenerCount = function(emitter, type) {
	  return emitter.listenerCount(type);
	};

	function isFunction(arg) {
	  return typeof arg === 'function';
	}

	function isNumber(arg) {
	  return typeof arg === 'number';
	}

	function isObject(arg) {
	  return typeof arg === 'object' && arg !== null;
	}

	function isUndefined(arg) {
	  return arg === void 0;
	}


/***/ })
/******/ ])
});
;

/***/ },

/***/ 9205
(module, exports, __webpack_require__) {

var __WEBPACK_AMD_DEFINE_FACTORY__, __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;/*!
 * jQuery Mousewheel 3.2.2
 * Copyright OpenJS Foundation and other contributors
 */

( function( factory ) {
    "use strict";

    if ( true ) {

        // AMD. Register as an anonymous module.
        !(__WEBPACK_AMD_DEFINE_ARRAY__ = [ __webpack_require__(5388) ], __WEBPACK_AMD_DEFINE_FACTORY__ = (factory),
		__WEBPACK_AMD_DEFINE_RESULT__ = (typeof __WEBPACK_AMD_DEFINE_FACTORY__ === 'function' ?
		(__WEBPACK_AMD_DEFINE_FACTORY__.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__)) : __WEBPACK_AMD_DEFINE_FACTORY__),
		__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
    } else // removed by dead control flow
{}
} )( function( $ ) {
    "use strict";

    var nullLowestDeltaTimeout, lowestDelta,
        modernEvents = !!$.fn.on,
        toFix  = [ "wheel", "mousewheel", "DOMMouseScroll", "MozMousePixelScroll" ],
        toBind = ( "onwheel" in window.document || window.document.documentMode >= 9 ) ?
            [ "wheel" ] : [ "mousewheel", "DomMouseScroll", "MozMousePixelScroll" ],
        slice  = Array.prototype.slice;

    if ( $.event.fixHooks ) {
        for ( var i = toFix.length; i; ) {
            $.event.fixHooks[ toFix[ --i ] ] = $.event.mouseHooks;
        }
    }

    var special = $.event.special.mousewheel = {
        version: "3.2.2",

        setup: function() {
            if ( this.addEventListener ) {
                for ( var i = toBind.length; i; ) {
                    this.addEventListener( toBind[ --i ], handler, false );
                }
            } else {
                this.onmousewheel = handler;
            }

            // Store the line height and page height for this particular element
            $.data( this, "mousewheel-line-height", special.getLineHeight( this ) );
            $.data( this, "mousewheel-page-height", special.getPageHeight( this ) );
        },

        teardown: function() {
            if ( this.removeEventListener ) {
                for ( var i = toBind.length; i; ) {
                    this.removeEventListener( toBind[ --i ], handler, false );
                }
            } else {
                this.onmousewheel = null;
            }

            // Clean up the data we added to the element
            $.removeData( this, "mousewheel-line-height" );
            $.removeData( this, "mousewheel-page-height" );
        },

        getLineHeight: function( elem ) {
            var $elem = $( elem ),
                $parent = $elem[ "offsetParent" in $.fn ? "offsetParent" : "parent" ]();
            if ( !$parent.length ) {
                $parent = $( "body" );
            }
            return parseInt( $parent.css( "fontSize" ), 10 ) ||
                parseInt( $elem.css( "fontSize" ), 10 ) || 16;
        },

        getPageHeight: function( elem ) {
            return $( elem ).height();
        },

        settings: {
            adjustOldDeltas: true, // see shouldAdjustOldDeltas() below
            normalizeOffset: true  // calls getBoundingClientRect for each event
        }
    };

    $.fn.extend( {
        mousewheel: function( fn ) {
            return fn ?
                this[ modernEvents ? "on" : "bind" ]( "mousewheel", fn ) :
                this.trigger( "mousewheel" );
        },

        unmousewheel: function( fn ) {
            return this[ modernEvents ? "off" : "unbind" ]( "mousewheel", fn );
        }
    } );


    function handler( event ) {
        var orgEvent   = event || window.event,
            args       = slice.call( arguments, 1 ),
            delta      = 0,
            deltaX     = 0,
            deltaY     = 0,
            absDelta   = 0;
        event = $.event.fix( orgEvent );
        event.type = "mousewheel";

        // Old school scrollwheel delta
        if ( "detail" in orgEvent ) {
            deltaY = orgEvent.detail * -1;
        }
        if ( "wheelDelta" in orgEvent ) {
            deltaY = orgEvent.wheelDelta;
        }
        if ( "wheelDeltaY" in orgEvent ) {
            deltaY = orgEvent.wheelDeltaY;
        }
        if ( "wheelDeltaX" in orgEvent ) {
            deltaX = orgEvent.wheelDeltaX * -1;
        }

        // Firefox < 17 horizontal scrolling related to DOMMouseScroll event
        if ( "axis" in orgEvent && orgEvent.axis === orgEvent.HORIZONTAL_AXIS ) {
            deltaX = deltaY * -1;
            deltaY = 0;
        }

        // Set delta to be deltaY or deltaX if deltaY is 0 for backwards compatability
        delta = deltaY === 0 ? deltaX : deltaY;

        // New school wheel delta (wheel event)
        if ( "deltaY" in orgEvent ) {
            deltaY = orgEvent.deltaY * -1;
            delta  = deltaY;
        }
        if ( "deltaX" in orgEvent ) {
            deltaX = orgEvent.deltaX;
            if ( deltaY === 0 ) {
                delta  = deltaX * -1;
            }
        }

        // No change actually happened, no reason to go any further
        if ( deltaY === 0 && deltaX === 0 ) {
            return;
        }

        // Need to convert lines and pages to pixels if we aren't already in pixels
        // There are three delta modes:
        //   * deltaMode 0 is by pixels, nothing to do
        //   * deltaMode 1 is by lines
        //   * deltaMode 2 is by pages
        if ( orgEvent.deltaMode === 1 ) {
            var lineHeight = $.data( this, "mousewheel-line-height" );
            delta  *= lineHeight;
            deltaY *= lineHeight;
            deltaX *= lineHeight;
        } else if ( orgEvent.deltaMode === 2 ) {
            var pageHeight = $.data( this, "mousewheel-page-height" );
            delta  *= pageHeight;
            deltaY *= pageHeight;
            deltaX *= pageHeight;
        }

        // Store lowest absolute delta to normalize the delta values
        absDelta = Math.max( Math.abs( deltaY ), Math.abs( deltaX ) );

        if ( !lowestDelta || absDelta < lowestDelta ) {
            lowestDelta = absDelta;

            // Adjust older deltas if necessary
            if ( shouldAdjustOldDeltas( orgEvent, absDelta ) ) {
                lowestDelta /= 40;
            }
        }

        // Adjust older deltas if necessary
        if ( shouldAdjustOldDeltas( orgEvent, absDelta ) ) {

            // Divide all the things by 40!
            delta  /= 40;
            deltaX /= 40;
            deltaY /= 40;
        }

        // Get a whole, normalized value for the deltas
        delta  = Math[ delta  >= 1 ? "floor" : "ceil" ]( delta  / lowestDelta );
        deltaX = Math[ deltaX >= 1 ? "floor" : "ceil" ]( deltaX / lowestDelta );
        deltaY = Math[ deltaY >= 1 ? "floor" : "ceil" ]( deltaY / lowestDelta );

        // Normalise offsetX and offsetY properties
        if ( special.settings.normalizeOffset && this.getBoundingClientRect ) {
            var boundingRect = this.getBoundingClientRect();
            event.offsetX = event.clientX - boundingRect.left;
            event.offsetY = event.clientY - boundingRect.top;
        }

        // Add information to the event object
        event.deltaX = deltaX;
        event.deltaY = deltaY;
        event.deltaFactor = lowestDelta;

        // Go ahead and set deltaMode to 0 since we converted to pixels
        // Although this is a little odd since we overwrite the deltaX/Y
        // properties with normalized deltas.
        event.deltaMode = 0;

        // Add event and delta to the front of the arguments
        args.unshift( event, delta, deltaX, deltaY );

        // Clear out lowestDelta after sometime to better
        // handle multiple device types that give different
        // a different lowestDelta
        // Ex: trackpad = 3 and mouse wheel = 120
        if ( nullLowestDeltaTimeout ) {
            window.clearTimeout( nullLowestDeltaTimeout );
        }
        nullLowestDeltaTimeout = window.setTimeout( function() {
            lowestDelta = null;
        }, 200 );

        return ( $.event.dispatch || $.event.handle ).apply( this, args );
    }

    function shouldAdjustOldDeltas( orgEvent, absDelta ) {

        // If this is an older event and the delta is divisible by 120,
        // then we are assuming that the browser is treating this as an
        // older mouse wheel event and that we should divide the deltas
        // by 40 to try and get a more usable deltaFactor.
        // Side note, this actually impacts the reported scroll distance
        // in older browsers and can cause scrolling to be slower than native.
        // Turn this off by setting $.event.special.mousewheel.settings.adjustOldDeltas to false.
        return special.settings.adjustOldDeltas && orgEvent.type === "mousewheel" &&
            absDelta % 120 === 0;
    }

} );


/***/ },

/***/ 702
(module) {

/**
 * @license
 * Copyright 2000, Silicon Graphics, Inc. All Rights Reserved.
 * Copyright 2015, Google Inc. All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to
 * deal in the Software without restriction, including without limitation the
 * rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
 * sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice including the dates of first publication and
 * either this permission notice or a reference to http://oss.sgi.com/projects/FreeB/
 * shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * SILICON GRAPHICS, INC. BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR
 * IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 * Original Code. The Original Code is: OpenGL Sample Implementation,
 * Version 1.2.1, released January 26, 2000, developed by Silicon Graphics,
 * Inc. The Original Code is Copyright (c) 1991-2000 Silicon Graphics, Inc.
 * Copyright in any portions created by third parties is as indicated
 * elsewhere herein. All Rights Reserved.
 */
/**
 * @author ericv@cs.stanford.edu (Eric Veach)
 * @author bckenny@google.com (Brendan Kenny)
 */

/**
 * Base namespace.
 * @const
 */
var libtess = {};

/**
 * Whether to run asserts and extra debug checks.
 * @define {boolean}
 */
libtess.DEBUG = false;

/**
 * Checks if the condition evaluates to true if libtess.DEBUG is true.
 * @param {*} condition The condition to check.
 * @param {string=} opt_message Error message in case of failure.
 * @throws {Error} Assertion failed, the condition evaluates to false.
 */
libtess.assert = function(condition, opt_message) {
  if (libtess.DEBUG && !condition) {
    throw new Error('Assertion failed' +
        (opt_message ? ': ' + opt_message : ''));
  }
};

/**
 * The maximum vertex coordinate size, 1e150. Anything larger will trigger a
 * GLU_TESS_COORD_TOO_LARGE error callback and the vertex will be clamped to
 * this value for all tessellation calculations.
 * @const {number}
 */
libtess.GLU_TESS_MAX_COORD = 1e150;
// NOTE(bckenny): value from glu.pl generator

/**
 * Normally the polygon is projected to a plane perpendicular to one of the
 * three coordinate axes before tessellating in 2d. This helps numerical
 * accuracy by forgoing a transformation step by simply dropping one coordinate
 * dimension.
 *
 * However, this can affect the placement of intersection points for non-axis-
 * aligned polygons. Setting TRUE_PROJECT to true will instead project onto a
 * plane actually perpendicular to the polygon's normal.
 *
 * NOTE(bckenny): I can find no instances on the internet in which this mode has
 * been used, but it's difficult to search for. This was a compile-time setting
 * in the original, so setting this as constant. If this is exposed in the
 * public API, remove the ignore coverage directives on
 * libtess.normal.projectPolygon and libtess.normal.normalize_.
 * @const {boolean}
 */
libtess.TRUE_PROJECT = false;

/**
 * The default tolerance for merging features, 0, meaning vertices are only
 * merged if they are exactly coincident
 * If a higher tolerance is needed, significant rewriting will need to occur.
 * See libtess.sweep.TOLERANCE_NONZERO_ as a starting place.
 * @const {number}
 */
libtess.GLU_TESS_DEFAULT_TOLERANCE = 0;

/**
 * The input contours parition the plane into regions. A winding
 * rule determines which of these regions are inside the polygon.
 *
 * For a single contour C, the winding number of a point x is simply
 * the signed number of revolutions we make around x as we travel
 * once around C (where CCW is positive). When there are several
 * contours, the individual winding numbers are summed. This
 * procedure associates a signed integer value with each point x in
 * the plane. Note that the winding number is the same for all
 * points in a single region.
 *
 * The winding rule classifies a region as "inside" if its winding
 * number belongs to the chosen category (odd, nonzero, positive,
 * negative, or absolute value of at least two). The current GLU
 * tesselator implements the "odd" rule. The "nonzero" rule is another
 * common way to define the interior. The other three rules are
 * useful for polygon CSG operations.
 * @enum {number}
 */
libtess.windingRule = {
  // NOTE(bckenny): values from enumglu.spec
  GLU_TESS_WINDING_ODD: 100130,
  GLU_TESS_WINDING_NONZERO: 100131,
  GLU_TESS_WINDING_POSITIVE: 100132,
  GLU_TESS_WINDING_NEGATIVE: 100133,
  GLU_TESS_WINDING_ABS_GEQ_TWO: 100134
};

/**
 * The type of primitive return from a "begin" callback. GL_LINE_LOOP is only
 * returned when GLU_TESS_BOUNDARY_ONLY is true. GL_TRIANGLE_STRIP and
 * GL_TRIANGLE_FAN are no longer returned since 1.1.0 (see release notes).
 * @enum {number}
 */
libtess.primitiveType = {
  GL_LINE_LOOP: 2,
  GL_TRIANGLES: 4,
  GL_TRIANGLE_STRIP: 5,
  GL_TRIANGLE_FAN: 6
};

/**
 * The types of errors provided in the error callback.
 * @enum {number}
 */
libtess.errorType = {
  // TODO(bckenny) doc types
  // NOTE(bckenny): values from enumglu.spec
  GLU_TESS_MISSING_BEGIN_POLYGON: 100151,
  GLU_TESS_MISSING_END_POLYGON: 100153,
  GLU_TESS_MISSING_BEGIN_CONTOUR: 100152,
  GLU_TESS_MISSING_END_CONTOUR: 100154,
  GLU_TESS_COORD_TOO_LARGE: 100155,
  GLU_TESS_NEED_COMBINE_CALLBACK: 100156
};

/**
 * Enum values necessary for providing settings and callbacks. See the readme
 * for details.
 * @enum {number}
 */
libtess.gluEnum = {
  // TODO(bckenny): rename so not always typing libtess.gluEnum.*?

  // NOTE(bckenny): values from enumglu.spec
  GLU_TESS_BEGIN: 100100,
  GLU_TESS_VERTEX: 100101,
  GLU_TESS_END: 100102,
  GLU_TESS_ERROR: 100103,
  GLU_TESS_EDGE_FLAG: 100104,
  GLU_TESS_COMBINE: 100105,
  GLU_TESS_BEGIN_DATA: 100106,
  GLU_TESS_VERTEX_DATA: 100107,
  GLU_TESS_END_DATA: 100108,
  GLU_TESS_ERROR_DATA: 100109,
  GLU_TESS_EDGE_FLAG_DATA: 100110,
  GLU_TESS_COMBINE_DATA: 100111,

  GLU_TESS_MESH: 100112,  //  NOTE(bckenny): from tess.c
  GLU_TESS_TOLERANCE: 100142,
  GLU_TESS_WINDING_RULE: 100140,
  GLU_TESS_BOUNDARY_ONLY: 100141,

  // TODO(bckenny): move this to libtess.errorType?
  GLU_INVALID_ENUM: 100900,
  GLU_INVALID_VALUE: 100901
};

/** @typedef {number} */
libtess.PQHandle;

/* global libtess */

/** @const */
libtess.geom = {};

/**
 * Returns whether vertex u and vertex v are equal.
 * @param {libtess.GluVertex} u
 * @param {libtess.GluVertex} v
 * @return {boolean}
 */
libtess.geom.vertEq = function(u, v) {
  return u.s === v.s && u.t === v.t;
};

/**
 * Returns whether vertex u is lexicographically less than or equal to vertex v.
 * @param {libtess.GluVertex} u
 * @param {libtess.GluVertex} v
 * @return {boolean}
 */
libtess.geom.vertLeq = function(u, v) {
  return (u.s < v.s) || (u.s === v.s && u.t <= v.t);
};

/**
 * Given three vertices u,v,w such that geom.vertLeq(u,v) && geom.vertLeq(v,w),
 * evaluates the t-coord of the edge uw at the s-coord of the vertex v.
 * Returns v.t - (uw)(v.s), ie. the signed distance from uw to v.
 * If uw is vertical (and thus passes thru v), the result is zero.
 *
 * The calculation is extremely accurate and stable, even when v
 * is very close to u or w.  In particular if we set v.t = 0 and
 * let r be the negated result (this evaluates (uw)(v.s)), then
 * r is guaranteed to satisfy MIN(u.t,w.t) <= r <= MAX(u.t,w.t).
 * @param {libtess.GluVertex} u
 * @param {libtess.GluVertex} v
 * @param {libtess.GluVertex} w
 * @return {number}
 */
libtess.geom.edgeEval = function(u, v, w) {

  var gapL = v.s - u.s;
  var gapR = w.s - v.s;

  if (gapL + gapR > 0) {
    if (gapL < gapR) {
      return (v.t - u.t) + (u.t - w.t) * (gapL / (gapL + gapR));
    } else {
      return (v.t - w.t) + (w.t - u.t) * (gapR / (gapL + gapR));
    }
  }

  // vertical line
  return 0;
};

/**
 * Returns a number whose sign matches geom.edgeEval(u,v,w) but which
 * is cheaper to evaluate.  Returns > 0, == 0 , or < 0
 * as v is above, on, or below the edge uw.
 * @param {libtess.GluVertex} u
 * @param {libtess.GluVertex} v
 * @param {libtess.GluVertex} w
 * @return {number}
 */
libtess.geom.edgeSign = function(u, v, w) {

  var gapL = v.s - u.s;
  var gapR = w.s - v.s;

  if (gapL + gapR > 0) {
    return (v.t - w.t) * gapL + (v.t - u.t) * gapR;
  }

  // vertical line
  return 0;
};

/**
 * Version of VertLeq with s and t transposed.
 * Returns whether vertex u is lexicographically less than or equal to vertex v.
 * @param {libtess.GluVertex} u
 * @param {libtess.GluVertex} v
 * @return {boolean}
 */
libtess.geom.transLeq = function(u, v) {
  return (u.t < v.t) || (u.t === v.t && u.s <= v.s);
};

/**
 * Version of geom.edgeEval with s and t transposed.
 * Given three vertices u,v,w such that geom.transLeq(u,v) &&
 * geom.transLeq(v,w), evaluates the t-coord of the edge uw at the s-coord of
 * the vertex v. Returns v.s - (uw)(v.t), ie. the signed distance from uw to v.
 * If uw is vertical (and thus passes thru v), the result is zero.
 *
 * The calculation is extremely accurate and stable, even when v
 * is very close to u or w.  In particular if we set v.s = 0 and
 * let r be the negated result (this evaluates (uw)(v.t)), then
 * r is guaranteed to satisfy MIN(u.s,w.s) <= r <= MAX(u.s,w.s).
 * @param {libtess.GluVertex} u
 * @param {libtess.GluVertex} v
 * @param {libtess.GluVertex} w
 * @return {number}
 */
libtess.geom.transEval = function(u, v, w) {

  var gapL = v.t - u.t;
  var gapR = w.t - v.t;

  if (gapL + gapR > 0) {
    if (gapL < gapR) {
      return (v.s - u.s) + (u.s - w.s) * (gapL / (gapL + gapR));
    } else {
      return (v.s - w.s) + (w.s - u.s) * (gapR / (gapL + gapR));
    }
  }

  // vertical line
  return 0;
};

/**
 * Version of geom.edgeSign with s and t transposed.
 * Returns a number whose sign matches geom.transEval(u,v,w) but which
 * is cheaper to evaluate.  Returns > 0, == 0 , or < 0
 * as v is above, on, or below the edge uw.
 * @param {libtess.GluVertex} u
 * @param {libtess.GluVertex} v
 * @param {libtess.GluVertex} w
 * @return {number}
 */
libtess.geom.transSign = function(u, v, w) {

  var gapL = v.t - u.t;
  var gapR = w.t - v.t;

  if (gapL + gapR > 0) {
    return (v.s - w.s) * gapL + (v.s - u.s) * gapR;
  }

  // vertical line
  return 0;
};

/**
 * Returns whether edge is directed from right to left.
 * @param {libtess.GluHalfEdge} e
 * @return {boolean}
 */
libtess.geom.edgeGoesLeft = function(e) {
  return libtess.geom.vertLeq(e.dst(), e.org);
};

/**
 * Returns whether edge is directed from left to right.
 * @param {libtess.GluHalfEdge} e
 * @return {boolean}
 */
libtess.geom.edgeGoesRight = function(e) {
  return libtess.geom.vertLeq(e.org, e.dst());
};

/**
 * Calculates the L1 distance between vertices u and v.
 * @param {libtess.GluVertex} u
 * @param {libtess.GluVertex} v
 * @return {number}
 */
libtess.geom.vertL1dist = function(u, v) {
  return Math.abs(u.s - v.s) + Math.abs(u.t - v.t);
};

// NOTE(bckenny): vertCCW is called nowhere in libtess and isn't part of the
// public API.
/* istanbul ignore next */
/**
 * For almost-degenerate situations, the results are not reliable.
 * Unless the floating-point arithmetic can be performed without
 * rounding errors, *any* implementation will give incorrect results
 * on some degenerate inputs, so the client must have some way to
 * handle this situation.
 * @param {!libtess.GluVertex} u
 * @param {!libtess.GluVertex} v
 * @param {!libtess.GluVertex} w
 * @return {boolean}
 */
libtess.geom.vertCCW = function(u, v, w) {
  return (u.s * (v.t - w.t) + v.s * (w.t - u.t) + w.s * (u.t - v.t)) >= 0;
};

/**
 * Given parameters a,x,b,y returns the value (b*x+a*y)/(a+b),
 * or (x+y)/2 if a==b==0. It requires that a,b >= 0, and enforces
 * this in the rare case that one argument is slightly negative.
 * The implementation is extremely stable numerically.
 * In particular it guarantees that the result r satisfies
 * MIN(x,y) <= r <= MAX(x,y), and the results are very accurate
 * even when a and b differ greatly in magnitude.
 * @private
 * @param {number} a
 * @param {number} x
 * @param {number} b
 * @param {number} y
 * @return {number}
 */
libtess.geom.interpolate_ = function(a, x, b, y) {
  // from Macro RealInterpolate:
  //(a = (a < 0) ? 0 : a, b = (b < 0) ? 0 : b, ((a <= b) ? ((b == 0) ? ((x+y) / 2) : (x + (y-x) * (a/(a+b)))) : (y + (x-y) * (b/(a+b)))))
  a = (a < 0) ? 0 : a;
  b = (b < 0) ? 0 : b;

  if (a <= b) {
    if (b === 0) {
      return (x + y) / 2;
    } else {
      return x + (y - x) * (a / (a + b));
    }
  } else {
    return y + (x - y) * (b / (a + b));
  }
};

/**
 * Given edges (o1,d1) and (o2,d2), compute their point of intersection.
 * The computed point is guaranteed to lie in the intersection of the
 * bounding rectangles defined by each edge.
 * @param {!libtess.GluVertex} o1
 * @param {!libtess.GluVertex} d1
 * @param {!libtess.GluVertex} o2
 * @param {!libtess.GluVertex} d2
 * @param {!libtess.GluVertex} v
 */
libtess.geom.edgeIntersect = function(o1, d1, o2, d2, v) {
  // This is certainly not the most efficient way to find the intersection
  // of two line segments, but it is very numerically stable.

  // Strategy: find the two middle vertices in the VertLeq ordering,
  // and interpolate the intersection s-value from these. Then repeat
  // using the TransLeq ordering to find the intersection t-value.
  var z1;
  var z2;
  var tmp;
  if (!libtess.geom.vertLeq(o1, d1)) {
    // Swap(o1, d1);
    tmp = o1;
    o1 = d1;
    d1 = tmp;
  }
  if (!libtess.geom.vertLeq(o2, d2)) {
    // Swap(o2, d2);
    tmp = o2;
    o2 = d2;
    d2 = tmp;
  }
  if (!libtess.geom.vertLeq(o1, o2)) {
    // Swap(o1, o2);
    tmp = o1;
    o1 = o2;
    o2 = tmp;
    // Swap(d1, d2);
    tmp = d1;
    d1 = d2;
    d2 = tmp;
  }

  if (!libtess.geom.vertLeq(o2, d1)) {
    // Technically, no intersection -- do our best
    v.s = (o2.s + d1.s) / 2;

  } else if (libtess.geom.vertLeq(d1, d2)) {
    // Interpolate between o2 and d1
    z1 = libtess.geom.edgeEval(o1, o2, d1);
    z2 = libtess.geom.edgeEval(o2, d1, d2);
    if (z1 + z2 < 0) { z1 = -z1; z2 = -z2; }
    v.s = libtess.geom.interpolate_(z1, o2.s, z2, d1.s);

  } else {
    // Interpolate between o2 and d2
    z1 = libtess.geom.edgeSign(o1, o2, d1);
    z2 = -libtess.geom.edgeSign(o1, d2, d1);
    if (z1 + z2 < 0) { z1 = -z1; z2 = -z2; }
    v.s = libtess.geom.interpolate_(z1, o2.s, z2, d2.s);
  }

  // Now repeat the process for t
  if (!libtess.geom.transLeq(o1, d1)) {
    // Swap(o1, d1);
    tmp = o1;
    o1 = d1;
    d1 = tmp;
  }
  if (!libtess.geom.transLeq(o2, d2)) {
    // Swap(o2, d2);
    tmp = o2;
    o2 = d2;
    d2 = tmp;
  }
  if (!libtess.geom.transLeq(o1, o2)) {
    // Swap(o1, o2);
    tmp = o1;
    o1 = o2;
    o2 = tmp;
    // Swap(d1, d2);
    tmp = d1;
    d1 = d2;
    d2 = tmp;
  }

  if (!libtess.geom.transLeq(o2, d1)) {
    // Technically, no intersection -- do our best
    v.t = (o2.t + d1.t) / 2;

  } else if (libtess.geom.transLeq(d1, d2)) {
    // Interpolate between o2 and d1
    z1 = libtess.geom.transEval(o1, o2, d1);
    z2 = libtess.geom.transEval(o2, d1, d2);
    if (z1 + z2 < 0) { z1 = -z1; z2 = -z2; }
    v.t = libtess.geom.interpolate_(z1, o2.t, z2, d1.t);

  } else {
    // Interpolate between o2 and d2
    z1 = libtess.geom.transSign(o1, o2, d1);
    z2 = -libtess.geom.transSign(o1, d2, d1);
    if (z1 + z2 < 0) { z1 = -z1; z2 = -z2; }
    v.t = libtess.geom.interpolate_(z1, o2.t, z2, d2.t);
  }
};

/* global libtess */

// TODO(bckenny): could maybe merge GluMesh and mesh.js since these are
// operations on the mesh

/** @const */
libtess.mesh = {};

/****************** Basic Edge Operations **********************/


/**
 * makeEdge creates one edge, two vertices, and a loop (face).
 * The loop consists of the two new half-edges.
 *
 * @param {libtess.GluMesh} mesh [description].
 * @return {libtess.GluHalfEdge} [description].
 */
libtess.mesh.makeEdge = function(mesh) {
  // TODO(bckenny): probably move to GluMesh, but needs Make* methods with it

  var e = libtess.mesh.makeEdgePair_(mesh.eHead);

  // complete edge with vertices and face (see mesh.makeEdgePair_)
  libtess.mesh.makeVertex_(e, mesh.vHead);
  libtess.mesh.makeVertex_(e.sym, mesh.vHead);
  libtess.mesh.makeFace_(e, mesh.fHead);

  return e;
};


/**
 * meshSplice(eOrg, eDst) is the basic operation for changing the
 * mesh connectivity and topology. It changes the mesh so that
 *  eOrg.oNext <- OLD( eDst.oNext )
 *  eDst.oNext <- OLD( eOrg.oNext )
 * where OLD(...) means the value before the meshSplice operation.
 *
 * This can have two effects on the vertex structure:
 *  - if eOrg.org != eDst.org, the two vertices are merged together
 *  - if eOrg.org == eDst.org, the origin is split into two vertices
 * In both cases, eDst.org is changed and eOrg.org is untouched.
 *
 * Similarly (and independently) for the face structure,
 *  - if eOrg.lFace == eDst.lFace, one loop is split into two
 *  - if eOrg.lFace != eDst.lFace, two distinct loops are joined into one
 * In both cases, eDst.lFace is changed and eOrg.lFace is unaffected.
 *
 * Some special cases:
 * If eDst == eOrg, the operation has no effect.
 * If eDst == eOrg.lNext, the new face will have a single edge.
 * If eDst == eOrg.lPrev(), the old face will have a single edge.
 * If eDst == eOrg.oNext, the new vertex will have a single edge.
 * If eDst == eOrg.oPrev(), the old vertex will have a single edge.
 *
 * @param {libtess.GluHalfEdge} eOrg [description].
 * @param {libtess.GluHalfEdge} eDst [description].
 */
libtess.mesh.meshSplice = function(eOrg, eDst) {
  // TODO: more descriptive name?

  var joiningLoops = false;
  var joiningVertices = false;

  if (eOrg === eDst) {
    return;
  }

  if (eDst.org !== eOrg.org) {
    // We are merging two disjoint vertices -- destroy eDst.org
    joiningVertices = true;
    libtess.mesh.killVertex_(eDst.org, eOrg.org);
  }

  if (eDst.lFace !== eOrg.lFace) {
    // We are connecting two disjoint loops -- destroy eDst.lFace
    joiningLoops = true;
    libtess.mesh.killFace_(eDst.lFace, eOrg.lFace);
  }

  // Change the edge structure
  libtess.mesh.splice_(eDst, eOrg);

  if (!joiningVertices) {
    // We split one vertex into two -- the new vertex is eDst.org.
    // Make sure the old vertex points to a valid half-edge.
    libtess.mesh.makeVertex_(eDst, eOrg.org);
    eOrg.org.anEdge = eOrg;
  }

  if (!joiningLoops) {
    // We split one loop into two -- the new loop is eDst.lFace.
    // Make sure the old face points to a valid half-edge.
    libtess.mesh.makeFace_(eDst, eOrg.lFace);
    eOrg.lFace.anEdge = eOrg;
  }
};


/**
 * deleteEdge(eDel) removes the edge eDel. There are several cases:
 * if (eDel.lFace != eDel.rFace()), we join two loops into one; the loop
 * eDel.lFace is deleted. Otherwise, we are splitting one loop into two;
 * the newly created loop will contain eDel.dst(). If the deletion of eDel
 * would create isolated vertices, those are deleted as well.
 *
 * This function could be implemented as two calls to __gl_meshSplice
 * plus a few calls to memFree, but this would allocate and delete
 * unnecessary vertices and faces.
 *
 * @param {libtess.GluHalfEdge} eDel [description].
 */
libtess.mesh.deleteEdge = function(eDel) {
  var eDelSym = eDel.sym;
  var joiningLoops = false;

  // First step: disconnect the origin vertex eDel.org.  We make all
  // changes to get a consistent mesh in this "intermediate" state.
  if (eDel.lFace !== eDel.rFace()) {
    // We are joining two loops into one -- remove the left face
    joiningLoops = true;
    libtess.mesh.killFace_(eDel.lFace, eDel.rFace());
  }

  if (eDel.oNext === eDel) {
    libtess.mesh.killVertex_(eDel.org, null);

  } else {
    // Make sure that eDel.org and eDel.rFace() point to valid half-edges
    eDel.rFace().anEdge = eDel.oPrev();
    eDel.org.anEdge = eDel.oNext;

    libtess.mesh.splice_(eDel, eDel.oPrev());

    if (!joiningLoops) {
      // We are splitting one loop into two -- create a new loop for eDel.
      libtess.mesh.makeFace_(eDel, eDel.lFace);
    }
  }

  // Claim: the mesh is now in a consistent state, except that eDel.org
  // may have been deleted.  Now we disconnect eDel.dst().
  if (eDelSym.oNext === eDelSym) {
    libtess.mesh.killVertex_(eDelSym.org, null);
    libtess.mesh.killFace_(eDelSym.lFace, null);

  } else {
    // Make sure that eDel.dst() and eDel.lFace point to valid half-edges
    eDel.lFace.anEdge = eDelSym.oPrev();
    eDelSym.org.anEdge = eDelSym.oNext;
    libtess.mesh.splice_(eDelSym, eDelSym.oPrev());
  }

  // Any isolated vertices or faces have already been freed.
  libtess.mesh.killEdge_(eDel);
};

/******************** Other Edge Operations **********************/

/* All these routines can be implemented with the basic edge
 * operations above.  They are provided for convenience and efficiency.
 */


/**
 * addEdgeVertex(eOrg) creates a new edge eNew such that
 * eNew == eOrg.lNext, and eNew.dst() is a newly created vertex.
 * eOrg and eNew will have the same left face.
 *
 * @param {libtess.GluHalfEdge} eOrg [description].
 * @return {libtess.GluHalfEdge} [description].
 */
libtess.mesh.addEdgeVertex = function(eOrg) {
  // TODO(bckenny): why is it named this?

  var eNew = libtess.mesh.makeEdgePair_(eOrg);
  var eNewSym = eNew.sym;

  // Connect the new edge appropriately
  libtess.mesh.splice_(eNew, eOrg.lNext);

  // Set the vertex and face information
  eNew.org = eOrg.dst();

  libtess.mesh.makeVertex_(eNewSym, eNew.org);

  eNew.lFace = eNewSym.lFace = eOrg.lFace;

  return eNew;
};


/**
 * splitEdge(eOrg) splits eOrg into two edges eOrg and eNew,
 * such that eNew == eOrg.lNext. The new vertex is eOrg.dst() == eNew.org.
 * eOrg and eNew will have the same left face.
 *
 * @param {libtess.GluHalfEdge} eOrg [description].
 * @return {!libtess.GluHalfEdge} [description].
 */
libtess.mesh.splitEdge = function(eOrg) {
  var tempHalfEdge = libtess.mesh.addEdgeVertex(eOrg);
  var eNew = tempHalfEdge.sym;

  // Disconnect eOrg from eOrg.dst() and connect it to eNew.org
  libtess.mesh.splice_(eOrg.sym, eOrg.sym.oPrev());
  libtess.mesh.splice_(eOrg.sym, eNew);

  // Set the vertex and face information
  eOrg.sym.org = eNew.org; // NOTE(bckenny): assignment to dst
  eNew.dst().anEdge = eNew.sym;  // may have pointed to eOrg.sym
  eNew.sym.lFace = eOrg.rFace(); // NOTE(bckenny): assignment to rFace
  eNew.winding = eOrg.winding;  // copy old winding information
  eNew.sym.winding = eOrg.sym.winding;

  return eNew;
};


/**
 * connect(eOrg, eDst) creates a new edge from eOrg.dst()
 * to eDst.org, and returns the corresponding half-edge eNew.
 * If eOrg.lFace == eDst.lFace, this splits one loop into two,
 * and the newly created loop is eNew.lFace. Otherwise, two disjoint
 * loops are merged into one, and the loop eDst.lFace is destroyed.
 *
 * If (eOrg == eDst), the new face will have only two edges.
 * If (eOrg.lNext == eDst), the old face is reduced to a single edge.
 * If (eOrg.lNext.lNext == eDst), the old face is reduced to two edges.
 *
 * @param {libtess.GluHalfEdge} eOrg [description].
 * @param {libtess.GluHalfEdge} eDst [description].
 * @return {!libtess.GluHalfEdge} [description].
 */
libtess.mesh.connect = function(eOrg, eDst) {
  var joiningLoops = false;
  var eNew = libtess.mesh.makeEdgePair_(eOrg);
  var eNewSym = eNew.sym;

  if (eDst.lFace !== eOrg.lFace) {
    // We are connecting two disjoint loops -- destroy eDst.lFace
    joiningLoops = true;
    libtess.mesh.killFace_(eDst.lFace, eOrg.lFace);
  }

  // Connect the new edge appropriately
  libtess.mesh.splice_(eNew, eOrg.lNext);
  libtess.mesh.splice_(eNewSym, eDst);

  // Set the vertex and face information
  eNew.org = eOrg.dst();
  eNewSym.org = eDst.org;
  eNew.lFace = eNewSym.lFace = eOrg.lFace;

  // Make sure the old face points to a valid half-edge
  eOrg.lFace.anEdge = eNewSym;

  if (!joiningLoops) {
    // We split one loop into two -- the new loop is eNew.lFace
    libtess.mesh.makeFace_(eNew, eOrg.lFace);
  }
  return eNew;
};

/******************** Other Operations **********************/


/**
 * zapFace(fZap) destroys a face and removes it from the
 * global face list. All edges of fZap will have a null pointer as their
 * left face. Any edges which also have a null pointer as their right face
 * are deleted entirely (along with any isolated vertices this produces).
 * An entire mesh can be deleted by zapping its faces, one at a time,
 * in any order. Zapped faces cannot be used in further mesh operations!
 *
 * @param {libtess.GluFace} fZap [description].
 */
libtess.mesh.zapFace = function(fZap) {
  var eStart = fZap.anEdge;

  // walk around face, deleting edges whose right face is also NULL
  var eNext = eStart.lNext;
  var e;
  do {
    e = eNext;
    eNext = e.lNext;

    e.lFace = null;
    if (e.rFace() === null) {
      // delete the edge -- see mesh.deleteEdge above
      if (e.oNext === e) {
        libtess.mesh.killVertex_(e.org, null);

      } else {
        // Make sure that e.org points to a valid half-edge
        e.org.anEdge = e.oNext;
        libtess.mesh.splice_(e, e.oPrev());
      }

      var eSym = e.sym;

      if (eSym.oNext === eSym) {
        libtess.mesh.killVertex_(eSym.org, null);

      } else {
        // Make sure that eSym.org points to a valid half-edge
        eSym.org.anEdge = eSym.oNext;
        libtess.mesh.splice_(eSym, eSym.oPrev());
      }
      libtess.mesh.killEdge_(e);
    }
  } while (e !== eStart);

  // delete from circular doubly-linked list
  var fPrev = fZap.prev;
  var fNext = fZap.next;
  fNext.prev = fPrev;
  fPrev.next = fNext;

  // TODO(bckenny): memFree( fZap );
  // TODO(bckenny): probably null at callsite
};

// TODO(bckenny): meshUnion isn't called within libtess and isn't part of the
// public API. Could be useful if more mesh manipulation functions are exposed.
/* istanbul ignore next */
/**
 * meshUnion() forms the union of all structures in
 * both meshes, and returns the new mesh (the old meshes are destroyed).
 *
 * @param {!libtess.GluMesh} mesh1
 * @param {!libtess.GluMesh} mesh2
 * @return {!libtess.GluMesh}
 */
libtess.mesh.meshUnion = function(mesh1, mesh2) {
  // TODO(bceknny): probably move to GluMesh method
  var f1 = mesh1.fHead;
  var v1 = mesh1.vHead;
  var e1 = mesh1.eHead;

  var f2 = mesh2.fHead;
  var v2 = mesh2.vHead;
  var e2 = mesh2.eHead;

  // Add the faces, vertices, and edges of mesh2 to those of mesh1
  if (f2.next !== f2) {
    f1.prev.next = f2.next;
    f2.next.prev = f1.prev;
    f2.prev.next = f1;
    f1.prev = f2.prev;
  }

  if (v2.next !== v2) {
    v1.prev.next = v2.next;
    v2.next.prev = v1.prev;
    v2.prev.next = v1;
    v1.prev = v2.prev;
  }

  if (e2.next !== e2) {
    e1.sym.next.sym.next = e2.next;
    e2.next.sym.next = e1.sym.next;
    e2.sym.next.sym.next = e1;
    e1.sym.next = e2.sym.next;
  }

  // TODO(bckenny): memFree(mesh2);
  // TODO(bckenny): If function is kept, remove mesh2's data to enforce.
  return mesh1;
};


/**
 * deleteMesh(mesh) will free all storage for any valid mesh.
 * @param {libtess.GluMesh} mesh [description].
 */
libtess.mesh.deleteMesh = function(mesh) {
  // TODO(bckenny): unnecessary, I think.
  // TODO(bckenny): might want to explicitly null at callsite
  // lots of memFrees. see also DELETE_BY_ZAPPING
};

/************************ Utility Routines ************************/


/**
 * Creates a new pair of half-edges which form their own loop.
 * No vertex or face structures are allocated, but these must be assigned
 * before the current edge operation is completed.
 *
 * TODO(bckenny): warning about eNext strictly being first of pair? (see code)
 *
 * @private
 * @param {libtess.GluHalfEdge} eNext [description].
 * @return {libtess.GluHalfEdge} [description].
 */
libtess.mesh.makeEdgePair_ = function(eNext) {
  var e = new libtess.GluHalfEdge();
  var eSym = new libtess.GluHalfEdge();

  // TODO(bckenny): how do we ensure this? see above comment in jsdoc
  // Make sure eNext points to the first edge of the edge pair
  // if (eNext->Sym < eNext ) { eNext = eNext->Sym; }

  // NOTE(bckenny): check this for bugs in current implementation!

  // Insert in circular doubly-linked list before eNext.
  // Note that the prev pointer is stored in sym.next.
  var ePrev = eNext.sym.next;
  eSym.next = ePrev;
  ePrev.sym.next = e;
  e.next = eNext;
  eNext.sym.next = eSym;

  e.sym = eSym;
  e.oNext = e;
  e.lNext = eSym;

  eSym.sym = e;
  eSym.oNext = eSym;
  eSym.lNext = e;

  return e;
};


/**
 * splice_ is best described by the Guibas/Stolfi paper or the
 * CS348a notes. Basically, it modifies the mesh so that
 * a.oNext and b.oNext are exchanged. This can have various effects
 * depending on whether a and b belong to different face or vertex rings.
 * For more explanation see mesh.meshSplice below.
 *
 * @private
 * @param {libtess.GluHalfEdge} a [description].
 * @param {libtess.GluHalfEdge} b [description].
 */
libtess.mesh.splice_ = function(a, b) {
  var aONext = a.oNext;
  var bONext = b.oNext;

  aONext.sym.lNext = b;
  bONext.sym.lNext = a;
  a.oNext = bONext;
  b.oNext = aONext;
};


/**
 * makeVertex_(eOrig, vNext) attaches a new vertex and makes it the
 * origin of all edges in the vertex loop to which eOrig belongs. "vNext" gives
 * a place to insert the new vertex in the global vertex list.  We insert
 * the new vertex *before* vNext so that algorithms which walk the vertex
 * list will not see the newly created vertices.
 *
 * NOTE: unlike original, acutally allocates new vertex.
 *
 * @private
 * @param {libtess.GluHalfEdge} eOrig [description].
 * @param {libtess.GluVertex} vNext [description].
 */
libtess.mesh.makeVertex_ = function(eOrig, vNext) {
  // insert in circular doubly-linked list before vNext
  var vPrev = vNext.prev;
  var vNew = new libtess.GluVertex(vNext, vPrev);
  vPrev.next = vNew;
  vNext.prev = vNew;

  vNew.anEdge = eOrig;
  // leave coords, s, t undefined
  // TODO(bckenny): does above line mean 0 specifically, or does it matter?

  // fix other edges on this vertex loop
  var e = eOrig;
  do {
    e.org = vNew;
    e = e.oNext;
  } while (e !== eOrig);
};


/**
 * makeFace_(eOrig, fNext) attaches a new face and makes it the left
 * face of all edges in the face loop to which eOrig belongs. "fNext" gives
 * a place to insert the new face in the global face list.  We insert
 * the new face *before* fNext so that algorithms which walk the face
 * list will not see the newly created faces.
 *
 * NOTE: unlike original, acutally allocates new face.
 *
 * @private
 * @param {libtess.GluHalfEdge} eOrig [description].
 * @param {libtess.GluFace} fNext [description].
 */
libtess.mesh.makeFace_ = function(eOrig, fNext) {
  // insert in circular doubly-linked list before fNext
  var fPrev = fNext.prev;
  var fNew = new libtess.GluFace(fNext, fPrev);
  fPrev.next = fNew;
  fNext.prev = fNew;

  fNew.anEdge = eOrig;

  // The new face is marked "inside" if the old one was.  This is a
  // convenience for the common case where a face has been split in two.
  fNew.inside = fNext.inside;

  // fix other edges on this face loop
  var e = eOrig;
  do {
    e.lFace = fNew;
    e = e.lNext;
  } while (e !== eOrig);
};


/**
 * killEdge_ destroys an edge (the half-edges eDel and eDel.sym),
 * and removes from the global edge list.
 *
 * @private
 * @param {libtess.GluHalfEdge} eDel [description].
 */
libtess.mesh.killEdge_ = function(eDel) {
  // TODO(bckenny): in this case, no need to worry(?), but check when checking mesh.makeEdgePair_
  // Half-edges are allocated in pairs, see EdgePair above
  // if (eDel->Sym < eDel ) { eDel = eDel->Sym; }

  // delete from circular doubly-linked list
  var eNext = eDel.next;
  var ePrev = eDel.sym.next;
  eNext.sym.next = ePrev;
  ePrev.sym.next = eNext;

  // TODO(bckenny): memFree( eDel ); (which also frees eDel.sym)
  // TODO(bckenny): need to null at callsites?
};


/**
 * killVertex_ destroys a vertex and removes it from the global
 * vertex list. It updates the vertex loop to point to a given new vertex.
 *
 * @private
 * @param {libtess.GluVertex} vDel [description].
 * @param {libtess.GluVertex} newOrg [description].
 */
libtess.mesh.killVertex_ = function(vDel, newOrg) {
  var eStart = vDel.anEdge;

  // change the origin of all affected edges
  var e = eStart;
  do {
    e.org = newOrg;
    e = e.oNext;
  } while (e !== eStart);

  // delete from circular doubly-linked list
  var vPrev = vDel.prev;
  var vNext = vDel.next;
  vNext.prev = vPrev;
  vPrev.next = vNext;

  // TODO(bckenny): memFree( vDel );
  // TODO(bckenny): need to null at callsites?
};


/**
 * killFace_ destroys a face and removes it from the global face
 * list. It updates the face loop to point to a given new face.
 *
 * @private
 * @param {libtess.GluFace} fDel [description].
 * @param {libtess.GluFace} newLFace [description].
 */
libtess.mesh.killFace_ = function(fDel, newLFace) {
  var eStart = fDel.anEdge;

  // change the left face of all affected edges
  var e = eStart;
  do {
    e.lFace = newLFace;
    e = e.lNext;
  } while (e !== eStart);

  // delete from circular doubly-linked list
  var fPrev = fDel.prev;
  var fNext = fDel.next;
  fNext.prev = fPrev;
  fPrev.next = fNext;

  // TODO(bckenny): memFree( fDel );
  // TODO(bckenny): need to null at callsites?
};

/* global libtess */

/** @const */
libtess.normal = {};

// TODO(bckenny): Integrate SLANTED_SWEEP somehow?
/* The "feature merging" is not intended to be complete. There are
 * special cases where edges are nearly parallel to the sweep line
 * which are not implemented. The algorithm should still behave
 * robustly (ie. produce a reasonable tesselation) in the presence
 * of such edges, however it may miss features which could have been
 * merged. We could minimize this effect by choosing the sweep line
 * direction to be something unusual (ie. not parallel to one of the
 * coordinate axes).
 * #if defined(SLANTED_SWEEP)
 * #define S_UNIT_X  0.50941539564955385 // Pre-normalized
 * #define S_UNIT_Y  0.86052074622010633
 * #endif
 */

/**
 * X coordinate of local basis for polygon projection.
 * @private {number}
 * @const
 */
libtess.normal.S_UNIT_X_ = 1.0;

/**
 * Y coordinate of local basis for polygon projection.
 * @private {number}
 * @const
 */
libtess.normal.S_UNIT_Y_ = 0.0;

/**
 * Determines a polygon normal and projects vertices onto the plane of the
 * polygon. A pre-computed normal for the data may be provided, or set to the
 * zero vector if one should be computed from it.
 * @param {!libtess.GluTesselator} tess
 * @param {number} normalX
 * @param {number} normalY
 * @param {number} normalZ
 */
libtess.normal.projectPolygon = function(tess, normalX, normalY, normalZ) {
  var computedNormal = false;

  var norm = [
    normalX,
    normalY,
    normalZ
  ];
  if (normalX === 0 && normalY === 0 && normalZ === 0) {
    libtess.normal.computeNormal_(tess, norm);
    computedNormal = true;
  }

  var i = libtess.normal.longAxis_(norm);
  var vHead = tess.mesh.vHead;
  var v;

  // NOTE(bckenny): This branch is never taken. See comment on
  // libtess.TRUE_PROJECT.
  /* istanbul ignore if */
  if (libtess.TRUE_PROJECT) {
    // Choose the initial sUnit vector to be approximately perpendicular
    // to the normal.
    libtess.normal.normalize_(norm);

    var sUnit = [0, 0, 0];
    var tUnit = [0, 0, 0];

    sUnit[i] = 0;
    sUnit[(i + 1) % 3] = libtess.normal.S_UNIT_X_;
    sUnit[(i + 2) % 3] = libtess.normal.S_UNIT_Y_;

    // Now make it exactly perpendicular
    var w = libtess.normal.dot_(sUnit, norm);
    sUnit[0] -= w * norm[0];
    sUnit[1] -= w * norm[1];
    sUnit[2] -= w * norm[2];
    libtess.normal.normalize_(sUnit);

    // Choose tUnit so that (sUnit,tUnit,norm) form a right-handed frame
    tUnit[0] = norm[1] * sUnit[2] - norm[2] * sUnit[1];
    tUnit[1] = norm[2] * sUnit[0] - norm[0] * sUnit[2];
    tUnit[2] = norm[0] * sUnit[1] - norm[1] * sUnit[0];
    libtess.normal.normalize_(tUnit);

    // Project the vertices onto the sweep plane
    for (v = vHead.next; v !== vHead; v = v.next) {
      v.s = libtess.normal.dot_(v.coords, sUnit);
      v.t = libtess.normal.dot_(v.coords, tUnit);
    }

  } else {
    // Project perpendicular to a coordinate axis -- better numerically
    var sAxis = (i + 1) % 3;
    var tAxis = (i + 2) % 3;
    var tNegate = norm[i] > 0 ? 1 : -1;

    // Project the vertices onto the sweep plane
    for (v = vHead.next; v !== vHead; v = v.next) {
      v.s = v.coords[sAxis];
      v.t = tNegate * v.coords[tAxis];
    }
  }

  if (computedNormal) {
    libtess.normal.checkOrientation_(tess);
  }
};

// NOTE(bckenny): libtess.normal.dot_ is no longer called in code without
// libtess.TRUE_PROJECT defined.
/* istanbul ignore next */
/**
 * Computes the dot product of vectors u and v.
 * @private
 * @param {!Array<number>} u
 * @param {!Array<number>} v
 * @return {number}
 */
libtess.normal.dot_ = function(u, v) {
  return u[0] * v[0] + u[1] * v[1] + u[2] * v[2];
};

// NOTE(bckenny): only called from within libtess.normal.projectPolygon's
// TRUE_PROJECT branch, so ignoring for code coverage.
/* istanbul ignore next */
/**
 * Normalize vector v.
 * @private
 * @param {!Array<number>} v
 */
libtess.normal.normalize_ = function(v) {
  var len = v[0] * v[0] + v[1] * v[1] + v[2] * v[2];

  len = Math.sqrt(len);
  v[0] /= len;
  v[1] /= len;
  v[2] /= len;
};

/**
 * Returns the index of the longest component of vector v.
 * @private
 * @param {!Array<number>} v
 * @return {number}
 */
libtess.normal.longAxis_ = function(v) {
  var i = 0;

  if (Math.abs(v[1]) > Math.abs(v[0])) {
    i = 1;
  }
  if (Math.abs(v[2]) > Math.abs(v[i])) {
    i = 2;
  }

  return i;
};

/**
 * Compute an approximate normal of the polygon from the vertices themselves.
 * Result returned in norm.
 * @private
 * @param {!libtess.GluTesselator} tess
 * @param {!Array<number>} norm
 */
libtess.normal.computeNormal_ = function(tess, norm) {
  var maxVal = [
    -2 * libtess.GLU_TESS_MAX_COORD,
    -2 * libtess.GLU_TESS_MAX_COORD,
    -2 * libtess.GLU_TESS_MAX_COORD
  ];
  var minVal = [
    2 * libtess.GLU_TESS_MAX_COORD,
    2 * libtess.GLU_TESS_MAX_COORD,
    2 * libtess.GLU_TESS_MAX_COORD
  ];
  var maxVert = [];
  var minVert = [];

  var v;
  var vHead = tess.mesh.vHead;
  for (v = vHead.next; v !== vHead; v = v.next) {
    for (var i = 0; i < 3; ++i) {
      var c = v.coords[i];
      if (c < minVal[i]) { minVal[i] = c; minVert[i] = v; }
      if (c > maxVal[i]) { maxVal[i] = c; maxVert[i] = v; }
    }
  }

  // Find two vertices separated by at least 1/sqrt(3) of the maximum
  // distance between any two vertices
  var index = 0;
  if (maxVal[1] - minVal[1] > maxVal[0] - minVal[0]) { index = 1; }
  if (maxVal[2] - minVal[2] > maxVal[index] - minVal[index]) { index = 2; }
  if (minVal[index] >= maxVal[index]) {
    // All vertices are the same -- normal doesn't matter
    norm[0] = 0; norm[1] = 0; norm[2] = 1;
    return;
  }

  // Look for a third vertex which forms the triangle with maximum area
  // (Length of normal == twice the triangle area)
  var maxLen2 = 0;
  var v1 = minVert[index];
  var v2 = maxVert[index];
  var tNorm = [0, 0, 0];
  var d1 = [
    v1.coords[0] - v2.coords[0],
    v1.coords[1] - v2.coords[1],
    v1.coords[2] - v2.coords[2]
  ];
  var d2 = [0, 0, 0];
  for (v = vHead.next; v !== vHead; v = v.next) {
    d2[0] = v.coords[0] - v2.coords[0];
    d2[1] = v.coords[1] - v2.coords[1];
    d2[2] = v.coords[2] - v2.coords[2];
    tNorm[0] = d1[1] * d2[2] - d1[2] * d2[1];
    tNorm[1] = d1[2] * d2[0] - d1[0] * d2[2];
    tNorm[2] = d1[0] * d2[1] - d1[1] * d2[0];
    var tLen2 = tNorm[0] * tNorm[0] + tNorm[1] * tNorm[1] + tNorm[2] * tNorm[2];
    if (tLen2 > maxLen2) {
      maxLen2 = tLen2;
      norm[0] = tNorm[0];
      norm[1] = tNorm[1];
      norm[2] = tNorm[2];
    }
  }

  if (maxLen2 <= 0) {
    // All points lie on a single line -- any decent normal will do
    norm[0] = norm[1] = norm[2] = 0;
    norm[libtess.normal.longAxis_(d1)] = 1;
  }
};

/**
 * Check that the sum of the signed area of all projected contours is
 * non-negative. If not, negate the t-coordinates to reverse the orientation and
 * make it so.
 * @private
 * @param {!libtess.GluTesselator} tess
 */
libtess.normal.checkOrientation_ = function(tess) {
  var area = 0;
  var fHead = tess.mesh.fHead;
  for (var f = fHead.next; f !== fHead; f = f.next) {
    var e = f.anEdge;
    if (e.winding <= 0) { continue; }
    do {
      area += (e.org.s - e.dst().s) * (e.org.t + e.dst().t);
      e = e.lNext;
    } while (e !== f.anEdge);
  }

  if (area < 0) {
    // Reverse the orientation by flipping all the t-coordinates
    var vHead = tess.mesh.vHead;
    for (var v = vHead.next; v !== vHead; v = v.next) {
      v.t = -v.t;
    }
  }
};

/* global libtess */

/** @const */
libtess.render = {};

/**
 * Takes a mesh, breaks it into separate triangles, and renders them. The
 * rendering output is provided as callbacks (see the API). Set flagEdges to
 * true to get edgeFlag callbacks (tess.flagBoundary in original libtess).
 * @param {!libtess.GluTesselator} tess
 * @param {!libtess.GluMesh} mesh
 * @param {boolean} flagEdges
 */
libtess.render.renderMesh = function(tess, mesh, flagEdges) {
  var beginCallbackCalled = false;

  // TODO(bckenny): edgeState needs to be boolean, but !== on first call
  // force edge state output for first vertex
  var edgeState = -1;

  // We examine all faces in an arbitrary order. Whenever we find
  // an inside triangle f, we render f.
  // NOTE(bckenny): go backwards through face list to match original libtess
  // triangle order
  for (var f = mesh.fHead.prev; f !== mesh.fHead; f = f.prev) {
    if (f.inside) {
      // We're going to emit a triangle, so call begin callback once
      if (!beginCallbackCalled) {
        tess.callBeginCallback(libtess.primitiveType.GL_TRIANGLES);
        beginCallbackCalled = true;
      }

      // check that face has only three edges
      var e = f.anEdge;
      // Loop once for each edge (there will always be 3 edges)
      do {
        if (flagEdges) {
          // Set the "edge state" to true just before we output the
          // first vertex of each edge on the polygon boundary.
          var newState = !e.rFace().inside ? 1 : 0; // TODO(bckenny): total hack to get edgeState working. fix me.
          if (edgeState !== newState) {
            edgeState = newState;
            // TODO(bckenny): edgeState should be boolean now
            tess.callEdgeFlagCallback(!!edgeState);
          }
        }

        // emit vertex
        tess.callVertexCallback(e.org.data);

        e = e.lNext;
      } while (e !== f.anEdge);
    }
  }

  // only call end callback if begin was called
  if (beginCallbackCalled) {
    tess.callEndCallback();
  }
};

/**
 * Takes a mesh, and outputs one contour for each face marked "inside". The
 * rendering output is provided as callbacks (see the API).
 * @param {!libtess.GluTesselator} tess
 * @param {!libtess.GluMesh} mesh
 */
libtess.render.renderBoundary = function(tess, mesh) {
  for (var f = mesh.fHead.next; f !== mesh.fHead; f = f.next) {
    if (f.inside) {
      tess.callBeginCallback(libtess.primitiveType.GL_LINE_LOOP);

      var e = f.anEdge;
      do {
        tess.callVertexCallback(e.org.data);
        e = e.lNext;
      } while (e !== f.anEdge);

      tess.callEndCallback();
    }
  }
};

/* global libtess */

// TODO(bckenny): a number of these never return null (as opposed to original) and should be typed appropriately

/*
 * Invariants for the Edge Dictionary.
 * - each pair of adjacent edges e2=succ(e1) satisfies edgeLeq_(e1,e2)
 *   at any valid location of the sweep event
 * - if edgeLeq_(e2,e1) as well (at any valid sweep event), then e1 and e2
 *   share a common endpoint
 * - for each e, e.dst() has been processed, but not e.org
 * - each edge e satisfies vertLeq(e.dst(),event) && vertLeq(event,e.org)
 *   where "event" is the current sweep line event.
 * - no edge e has zero length
 *
 * Invariants for the Mesh (the processed portion).
 * - the portion of the mesh left of the sweep line is a planar graph,
 *   ie. there is *some* way to embed it in the plane
 * - no processed edge has zero length
 * - no two processed vertices have identical coordinates
 * - each "inside" region is monotone, ie. can be broken into two chains
 *   of monotonically increasing vertices according to VertLeq(v1,v2)
 *   - a non-invariant: these chains may intersect (very slightly)
 *
 * Invariants for the Sweep.
 * - if none of the edges incident to the event vertex have an activeRegion
 *   (ie. none of these edges are in the edge dictionary), then the vertex
 *   has only right-going edges.
 * - if an edge is marked "fixUpperEdge" (it is a temporary edge introduced
 *   by ConnectRightVertex), then it is the only right-going edge from
 *   its associated vertex.  (This says that these edges exist only
 *   when it is necessary.)
 */

/** @const */
libtess.sweep = {};


/**
 * Make the sentinel coordinates big enough that they will never be
 * merged with real input features.  (Even with the largest possible
 * input contour and the maximum tolerance of 1.0, no merging will be
 * done with coordinates larger than 3 * libtess.GLU_TESS_MAX_COORD).
 * @private
 * @const
 * @type {number}
 */
libtess.sweep.SENTINEL_COORD_ = 4 * libtess.GLU_TESS_MAX_COORD;


/**
 * Because vertices at exactly the same location are merged together
 * before we process the sweep event, some degenerate cases can't occur.
 * However if someone eventually makes the modifications required to
 * merge features which are close together, the cases below marked
 * TOLERANCE_NONZERO will be useful.  They were debugged before the
 * code to merge identical vertices in the main loop was added.
 * @private
 * @const
 * @type {boolean}
 */
libtess.sweep.TOLERANCE_NONZERO_ = false;


/**
 * computeInterior(tess) computes the planar arrangement specified
 * by the given contours, and further subdivides this arrangement
 * into regions. Each region is marked "inside" if it belongs
 * to the polygon, according to the rule given by tess.windingRule.
 * Each interior region is guaranteed be monotone.
 *
 * @param {libtess.GluTesselator} tess [description].
 */
libtess.sweep.computeInterior = function(tess) {
  tess.fatalError = false;

  // Each vertex defines an event for our sweep line. Start by inserting
  // all the vertices in a priority queue. Events are processed in
  // lexicographic order, ie.
  // e1 < e2  iff  e1.x < e2.x || (e1.x == e2.x && e1.y < e2.y)
  libtess.sweep.removeDegenerateEdges_(tess);
  libtess.sweep.initPriorityQ_(tess);
  libtess.sweep.initEdgeDict_(tess);

  var v;
  while ((v = tess.pq.extractMin()) !== null) {
    for (;;) {
      var vNext = tess.pq.minimum();
      if (vNext === null || !libtess.geom.vertEq(vNext, v)) {
        break;
      }

      /* Merge together all vertices at exactly the same location.
       * This is more efficient than processing them one at a time,
       * simplifies the code (see connectLeftDegenerate), and is also
       * important for correct handling of certain degenerate cases.
       * For example, suppose there are two identical edges A and B
       * that belong to different contours (so without this code they would
       * be processed by separate sweep events).  Suppose another edge C
       * crosses A and B from above.  When A is processed, we split it
       * at its intersection point with C.  However this also splits C,
       * so when we insert B we may compute a slightly different
       * intersection point.  This might leave two edges with a small
       * gap between them.  This kind of error is especially obvious
       * when using boundary extraction (GLU_TESS_BOUNDARY_ONLY).
       */
      vNext = tess.pq.extractMin();
      libtess.sweep.spliceMergeVertices_(tess, v.anEdge, vNext.anEdge);
    }
    libtess.sweep.sweepEvent_(tess, v);
  }

  // TODO(bckenny): what does the next comment mean? can we eliminate event except when debugging?
  // Set tess.event for debugging purposes
  var minRegion = tess.dict.getMin().getKey();
  tess.event = minRegion.eUp.org;
  libtess.sweep.doneEdgeDict_(tess);
  libtess.sweep.donePriorityQ_(tess);

  libtess.sweep.removeDegenerateFaces_(tess.mesh);
  tess.mesh.checkMesh();
};


/**
 * When we merge two edges into one, we need to compute the combined
 * winding of the new edge.
 * @private
 * @param {libtess.GluHalfEdge} eDst [description].
 * @param {libtess.GluHalfEdge} eSrc [description].
 */
libtess.sweep.addWinding_ = function(eDst, eSrc) {
  // NOTE(bckenny): from AddWinding macro
  eDst.winding += eSrc.winding;
  eDst.sym.winding += eSrc.sym.winding;
};


/**
 * Both edges must be directed from right to left (this is the canonical
 * direction for the upper edge of each region).
 *
 * The strategy is to evaluate a "t" value for each edge at the
 * current sweep line position, given by tess.event.  The calculations
 * are designed to be very stable, but of course they are not perfect.
 *
 * Special case: if both edge destinations are at the sweep event,
 * we sort the edges by slope (they would otherwise compare equally).
 *
 * @private
 * @param {!libtess.GluTesselator} tess
 * @param {!libtess.ActiveRegion} reg1
 * @param {!libtess.ActiveRegion} reg2
 * @return {boolean}
 */
libtess.sweep.edgeLeq_ = function(tess, reg1, reg2) {
  var event = tess.event;
  var e1 = reg1.eUp;
  var e2 = reg2.eUp;

  if (e1.dst() === event) {
    if (e2.dst() === event) {
      // Two edges right of the sweep line which meet at the sweep event.
      // Sort them by slope.
      if (libtess.geom.vertLeq(e1.org, e2.org)) {
        return libtess.geom.edgeSign(e2.dst(), e1.org, e2.org) <= 0;
      }

      return libtess.geom.edgeSign(e1.dst(), e2.org, e1.org) >= 0;
    }

    return libtess.geom.edgeSign(e2.dst(), event, e2.org) <= 0;
  }

  if (e2.dst() === event) {
    return libtess.geom.edgeSign(e1.dst(), event, e1.org) >= 0;
  }

  // General case - compute signed distance *from* e1, e2 to event
  var t1 = libtess.geom.edgeEval(e1.dst(), event, e1.org);
  var t2 = libtess.geom.edgeEval(e2.dst(), event, e2.org);
  return (t1 >= t2);
};


/**
 * [deleteRegion_ description]
 * @private
 * @param {libtess.GluTesselator} tess [description].
 * @param {libtess.ActiveRegion} reg [description].
 */
libtess.sweep.deleteRegion_ = function(tess, reg) {
  if (reg.fixUpperEdge) {
    // It was created with zero winding number, so it better be
    // deleted with zero winding number (ie. it better not get merged
    // with a real edge).
  }

  reg.eUp.activeRegion = null;

  tess.dict.deleteNode(reg.nodeUp);
  reg.nodeUp = null;

  // memFree( reg ); TODO(bckenny)
  // TODO(bckenny): may need to null at callsite
};


/**
 * Replace an upper edge which needs fixing (see connectRightVertex).
 * @private
 * @param {libtess.ActiveRegion} reg [description].
 * @param {libtess.GluHalfEdge} newEdge [description].
 */
libtess.sweep.fixUpperEdge_ = function(reg, newEdge) {
  libtess.mesh.deleteEdge(reg.eUp);

  reg.fixUpperEdge = false;
  reg.eUp = newEdge;
  newEdge.activeRegion = reg;
};


/**
 * Find the region above the uppermost edge with the same origin.
 * @private
 * @param {libtess.ActiveRegion} reg [description].
 * @return {libtess.ActiveRegion} [description].
 */
libtess.sweep.topLeftRegion_ = function(reg) {
  var org = reg.eUp.org;

  // Find the region above the uppermost edge with the same origin
  do {
    reg = reg.regionAbove();
  } while (reg.eUp.org === org);

  // If the edge above was a temporary edge introduced by connectRightVertex,
  // now is the time to fix it.
  if (reg.fixUpperEdge) {
    var e = libtess.mesh.connect(reg.regionBelow().eUp.sym, reg.eUp.lNext);
    libtess.sweep.fixUpperEdge_(reg, e);
    reg = reg.regionAbove();
  }

  return reg;
};


/**
 * Find the region above the uppermost edge with the same destination.
 * @private
 * @param {libtess.ActiveRegion} reg [description].
 * @return {libtess.ActiveRegion} [description].
 */
libtess.sweep.topRightRegion_ = function(reg) {
  var dst = reg.eUp.dst();

  do {
    reg = reg.regionAbove();
  } while (reg.eUp.dst() === dst);

  return reg;
};


/**
 * Add a new active region to the sweep line, *somewhere* below "regAbove"
 * (according to where the new edge belongs in the sweep-line dictionary).
 * The upper edge of the new region will be "eNewUp".
 * Winding number and "inside" flag are not updated.
 *
 * @private
 * @param {libtess.GluTesselator} tess [description].
 * @param {libtess.ActiveRegion} regAbove [description].
 * @param {libtess.GluHalfEdge} eNewUp [description].
 * @return {libtess.ActiveRegion} regNew.
 */
libtess.sweep.addRegionBelow_ = function(tess, regAbove, eNewUp) {
  var regNew = new libtess.ActiveRegion();

  regNew.eUp = eNewUp;
  regNew.nodeUp = tess.dict.insertBefore(regAbove.nodeUp, regNew);
  eNewUp.activeRegion = regNew;

  return regNew;
};


/**
 * [isWindingInside_ description]
 * @private
 * @param {libtess.GluTesselator} tess [description].
 * @param {number} n int.
 * @return {boolean} [description].
 */
libtess.sweep.isWindingInside_ = function(tess, n) {
  switch (tess.windingRule) {
    case libtess.windingRule.GLU_TESS_WINDING_ODD:
      return ((n & 1) !== 0);
    case libtess.windingRule.GLU_TESS_WINDING_NONZERO:
      return (n !== 0);
    case libtess.windingRule.GLU_TESS_WINDING_POSITIVE:
      return (n > 0);
    case libtess.windingRule.GLU_TESS_WINDING_NEGATIVE:
      return (n < 0);
    case libtess.windingRule.GLU_TESS_WINDING_ABS_GEQ_TWO:
      return (n >= 2) || (n <= -2);
  }

  // TODO(bckenny): not reached
  return false;
};


/**
 * [computeWinding_ description]
 * @private
 * @param {libtess.GluTesselator} tess [description].
 * @param {libtess.ActiveRegion} reg [description].
 */
libtess.sweep.computeWinding_ = function(tess, reg) {
  reg.windingNumber = reg.regionAbove().windingNumber + reg.eUp.winding;
  reg.inside = libtess.sweep.isWindingInside_(tess, reg.windingNumber);
};


/**
 * Delete a region from the sweep line. This happens when the upper
 * and lower chains of a region meet (at a vertex on the sweep line).
 * The "inside" flag is copied to the appropriate mesh face (we could
 * not do this before -- since the structure of the mesh is always
 * changing, this face may not have even existed until now).
 *
 * @private
 * @param {libtess.GluTesselator} tess [description].
 * @param {libtess.ActiveRegion} reg [description].
 */
libtess.sweep.finishRegion_ = function(tess, reg) {
  // TODO(bckenny): may need to null reg at callsite

  var e = reg.eUp;
  var f = e.lFace;

  f.inside = reg.inside;
  f.anEdge = e;   // optimization for tessmono.tessellateMonoRegion() // TODO(bckenny): how so?
  libtess.sweep.deleteRegion_(tess, reg);
};


/**
 * We are given a vertex with one or more left-going edges. All affected
 * edges should be in the edge dictionary. Starting at regFirst.eUp,
 * we walk down deleting all regions where both edges have the same
 * origin vOrg. At the same time we copy the "inside" flag from the
 * active region to the face, since at this point each face will belong
 * to at most one region (this was not necessarily true until this point
 * in the sweep). The walk stops at the region above regLast; if regLast
 * is null we walk as far as possible. At the same time we relink the
 * mesh if necessary, so that the ordering of edges around vOrg is the
 * same as in the dictionary.
 *
 * @private
 * @param {libtess.GluTesselator} tess [description].
 * @param {libtess.ActiveRegion} regFirst [description].
 * @param {libtess.ActiveRegion} regLast [description].
 * @return {libtess.GluHalfEdge} [description].
 */
libtess.sweep.finishLeftRegions_ = function(tess, regFirst, regLast) {
  var regPrev = regFirst;
  var ePrev = regFirst.eUp;
  while (regPrev !== regLast) {
    // placement was OK
    regPrev.fixUpperEdge = false;
    var reg = regPrev.regionBelow();
    var e = reg.eUp;
    if (e.org !== ePrev.org) {
      if (!reg.fixUpperEdge) {
        /* Remove the last left-going edge. Even though there are no further
         * edges in the dictionary with this origin, there may be further
         * such edges in the mesh (if we are adding left edges to a vertex
         * that has already been processed). Thus it is important to call
         * finishRegion rather than just deleteRegion.
         */
        libtess.sweep.finishRegion_(tess, regPrev);
        break;
      }

      // If the edge below was a temporary edge introduced by
      // connectRightVertex, now is the time to fix it.
      e = libtess.mesh.connect(ePrev.lPrev(), e.sym);
      libtess.sweep.fixUpperEdge_(reg, e);
    }

    // Relink edges so that ePrev.oNext === e
    if (ePrev.oNext !== e) {
      libtess.mesh.meshSplice(e.oPrev(), e);
      libtess.mesh.meshSplice(ePrev, e);
    }

    // may change reg.eUp
    libtess.sweep.finishRegion_(tess, regPrev);
    ePrev = reg.eUp;
    regPrev = reg;
  }

  return ePrev;
};


/**
 * Purpose: insert right-going edges into the edge dictionary, and update
 * winding numbers and mesh connectivity appropriately. All right-going
 * edges share a common origin vOrg. Edges are inserted CCW starting at
 * eFirst; the last edge inserted is eLast.oPrev. If vOrg has any
 * left-going edges already processed, then eTopLeft must be the edge
 * such that an imaginary upward vertical segment from vOrg would be
 * contained between eTopLeft.oPrev and eTopLeft; otherwise eTopLeft
 * should be null.
 *
 * @private
 * @param {libtess.GluTesselator} tess [description].
 * @param {libtess.ActiveRegion} regUp [description].
 * @param {libtess.GluHalfEdge} eFirst [description].
 * @param {libtess.GluHalfEdge} eLast [description].
 * @param {libtess.GluHalfEdge} eTopLeft [description].
 * @param {boolean} cleanUp [description].
 */
libtess.sweep.addRightEdges_ = function(tess, regUp, eFirst, eLast, eTopLeft,
    cleanUp) {

  var firstTime = true;

  // Insert the new right-going edges in the dictionary
  var e = eFirst;
  do {
    libtess.sweep.addRegionBelow_(tess, regUp, e.sym);
    e = e.oNext;
  } while (e !== eLast);

  // Walk *all* right-going edges from e.org, in the dictionary order,
  // updating the winding numbers of each region, and re-linking the mesh
  // edges to match the dictionary ordering (if necessary).
  if (eTopLeft === null) {
    eTopLeft = regUp.regionBelow().eUp.rPrev();
  }
  var regPrev = regUp;
  var ePrev = eTopLeft;
  var reg;
  for (;;) {
    reg = regPrev.regionBelow();
    e = reg.eUp.sym;
    if (e.org !== ePrev.org) {
      break;
    }

    if (e.oNext !== ePrev) {
      // Unlink e from its current position, and relink below ePrev
      libtess.mesh.meshSplice(e.oPrev(), e);
      libtess.mesh.meshSplice(ePrev.oPrev(), e);
    }
    // Compute the winding number and "inside" flag for the new regions
    reg.windingNumber = regPrev.windingNumber - e.winding;
    reg.inside = libtess.sweep.isWindingInside_(tess, reg.windingNumber);

    // Check for two outgoing edges with same slope -- process these
    // before any intersection tests (see example in libtess.sweep.computeInterior).
    regPrev.dirty = true;
    if (!firstTime && libtess.sweep.checkForRightSplice_(tess, regPrev)) {
      libtess.sweep.addWinding_(e, ePrev);
      libtess.sweep.deleteRegion_(tess, regPrev); // TODO(bckenny): need to null regPrev anywhere else?
      libtess.mesh.deleteEdge(ePrev);
    }
    firstTime = false;
    regPrev = reg;
    ePrev = e;
  }

  regPrev.dirty = true;

  if (cleanUp) {
    // Check for intersections between newly adjacent edges.
    libtess.sweep.walkDirtyRegions_(tess, regPrev);
  }
};


/**
 * Set up data for and call GLU_TESS_COMBINE callback on GluTesselator.
 * @private
 * @param {!libtess.GluTesselator} tess
 * @param {!libtess.GluVertex} isect A raw vertex at the intersection.
 * @param {!Array<Object>} data The vertices of the intersecting edges.
 * @param {!Array<number>} weights The linear combination coefficients for this intersection.
 * @param {boolean} needed Whether a returned vertex is necessary in this case.
 */
libtess.sweep.callCombine_ = function(tess, isect, data, weights, needed) {
  // Copy coord data in case the callback changes it.
  var coords = [
    isect.coords[0],
    isect.coords[1],
    isect.coords[2]
  ];

  isect.data = null;
  isect.data = tess.callCombineCallback(coords, data, weights);
  if (isect.data === null) {
    if (!needed) {
      // not needed, so just use data from first vertex
      isect.data = data[0];

    } else if (!tess.fatalError) {
      // The only way fatal error is when two edges are found to intersect,
      // but the user has not provided the callback necessary to handle
      // generated intersection points.
      tess.callErrorCallback(libtess.errorType.GLU_TESS_NEED_COMBINE_CALLBACK);
      tess.fatalError = true;
    }
  }
};


/**
 * Two vertices with idential coordinates are combined into one.
 * e1.org is kept, while e2.org is discarded.
 * @private
 * @param {!libtess.GluTesselator} tess
 * @param {libtess.GluHalfEdge} e1 [description].
 * @param {libtess.GluHalfEdge} e2 [description].
 */
libtess.sweep.spliceMergeVertices_ = function(tess, e1, e2) {
  // TODO(bckenny): better way to init these? save them?
  var data = [null, null, null, null];
  var weights = [0.5, 0.5, 0, 0];

  data[0] = e1.org.data;
  data[1] = e2.org.data;
  libtess.sweep.callCombine_(tess, e1.org, data, weights, false);
  libtess.mesh.meshSplice(e1, e2);
};


/**
 * Find some weights which describe how the intersection vertex is
 * a linear combination of org and dst. Each of the two edges
 * which generated "isect" is allocated 50% of the weight; each edge
 * splits the weight between its org and dst according to the
 * relative distance to "isect".
 *
 * @private
 * @param {libtess.GluVertex} isect [description].
 * @param {libtess.GluVertex} org [description].
 * @param {libtess.GluVertex} dst [description].
 * @param {Array.<number>} weights [description].
 * @param {number} weightIndex Index into weights for first weight to supply.
 */
libtess.sweep.vertexWeights_ = function(isect, org, dst, weights, weightIndex) {
  // TODO(bckenny): think through how we can use L1dist here and be correct for coords
  var t1 = libtess.geom.vertL1dist(org, isect);
  var t2 = libtess.geom.vertL1dist(dst, isect);

  // TODO(bckenny): introduced weightIndex to mimic addressing in original
  // 1) document (though it is private and only used from getIntersectData)
  // 2) better way? manually inline into getIntersectData? supply two two-length tmp arrays?
  var i0 = weightIndex;
  var i1 = weightIndex + 1;
  weights[i0] = 0.5 * t2 / (t1 + t2);
  weights[i1] = 0.5 * t1 / (t1 + t2);
  isect.coords[0] += weights[i0] * org.coords[0] + weights[i1] * dst.coords[0];
  isect.coords[1] += weights[i0] * org.coords[1] + weights[i1] * dst.coords[1];
  isect.coords[2] += weights[i0] * org.coords[2] + weights[i1] * dst.coords[2];
};


/**
 * We've computed a new intersection point, now we need a "data" pointer
 * from the user so that we can refer to this new vertex in the
 * rendering callbacks.
 * @private
 * @param {!libtess.GluTesselator} tess
 * @param {libtess.GluVertex} isect [description].
 * @param {libtess.GluVertex} orgUp [description].
 * @param {libtess.GluVertex} dstUp [description].
 * @param {libtess.GluVertex} orgLo [description].
 * @param {libtess.GluVertex} dstLo [description].
 */
libtess.sweep.getIntersectData_ = function(tess, isect, orgUp, dstUp, orgLo,
    dstLo) {

  // TODO(bckenny): called for every intersection event, should these be from a pool?
  // TODO(bckenny): better way to init these?
  var weights = [0, 0, 0, 0];
  var data = [
    orgUp.data,
    dstUp.data,
    orgLo.data,
    dstLo.data
  ];

  // TODO(bckenny): it appears isect is a reappropriated vertex, so does need to be zeroed.
  // double check this.
  isect.coords[0] = isect.coords[1] = isect.coords[2] = 0;

  // TODO(bckenny): see note in libtess.sweep.vertexWeights_ for explanation of weightIndex. fix?
  libtess.sweep.vertexWeights_(isect, orgUp, dstUp, weights, 0);
  libtess.sweep.vertexWeights_(isect, orgLo, dstLo, weights, 2);

  libtess.sweep.callCombine_(tess, isect, data, weights, true);
};


/**
 * Check the upper and lower edge of regUp, to make sure that the
 * eUp.org is above eLo, or eLo.org is below eUp (depending on which
 * origin is leftmost).
 *
 * The main purpose is to splice right-going edges with the same
 * dest vertex and nearly identical slopes (ie. we can't distinguish
 * the slopes numerically). However the splicing can also help us
 * to recover from numerical errors. For example, suppose at one
 * point we checked eUp and eLo, and decided that eUp.org is barely
 * above eLo. Then later, we split eLo into two edges (eg. from
 * a splice operation like this one). This can change the result of
 * our test so that now eUp.org is incident to eLo, or barely below it.
 * We must correct this condition to maintain the dictionary invariants.
 *
 * One possibility is to check these edges for intersection again
 * (i.e. checkForIntersect). This is what we do if possible. However
 * checkForIntersect requires that tess.event lies between eUp and eLo,
 * so that it has something to fall back on when the intersection
 * calculation gives us an unusable answer. So, for those cases where
 * we can't check for intersection, this routine fixes the problem
 * by just splicing the offending vertex into the other edge.
 * This is a guaranteed solution, no matter how degenerate things get.
 * Basically this is a combinatorial solution to a numerical problem.
 *
 * @private
 * @param {libtess.GluTesselator} tess [description].
 * @param {libtess.ActiveRegion} regUp [description].
 * @return {boolean} [description].
 */
libtess.sweep.checkForRightSplice_ = function(tess, regUp) {
  // TODO(bckenny): fully learn how these two checks work

  var regLo = regUp.regionBelow();
  var eUp = regUp.eUp;
  var eLo = regLo.eUp;

  if (libtess.geom.vertLeq(eUp.org, eLo.org)) {
    if (libtess.geom.edgeSign(eLo.dst(), eUp.org, eLo.org) > 0) {
      return false;
    }

    // eUp.org appears to be below eLo
    if (!libtess.geom.vertEq(eUp.org, eLo.org)) {
      // Splice eUp.org into eLo
      libtess.mesh.splitEdge(eLo.sym);
      libtess.mesh.meshSplice(eUp, eLo.oPrev());
      regUp.dirty = regLo.dirty = true;

    } else if (eUp.org !== eLo.org) {
      // merge the two vertices, discarding eUp.org
      tess.pq.remove(eUp.org.pqHandle);
      libtess.sweep.spliceMergeVertices_(tess, eLo.oPrev(), eUp);
    }

  } else {
    if (libtess.geom.edgeSign(eUp.dst(), eLo.org, eUp.org) < 0) {
      return false;
    }

    // eLo.org appears to be above eUp, so splice eLo.org into eUp
    regUp.regionAbove().dirty = regUp.dirty = true;
    libtess.mesh.splitEdge(eUp.sym);
    libtess.mesh.meshSplice(eLo.oPrev(), eUp);
  }

  return true;
};


/**
 * Check the upper and lower edge of regUp to make sure that the
 * eUp.dst() is above eLo, or eLo.dst() is below eUp (depending on which
 * destination is rightmost).
 *
 * Theoretically, this should always be true. However, splitting an edge
 * into two pieces can change the results of previous tests. For example,
 * suppose at one point we checked eUp and eLo, and decided that eUp.dst()
 * is barely above eLo. Then later, we split eLo into two edges (eg. from
 * a splice operation like this one). This can change the result of
 * the test so that now eUp.dst() is incident to eLo, or barely below it.
 * We must correct this condition to maintain the dictionary invariants
 * (otherwise new edges might get inserted in the wrong place in the
 * dictionary, and bad stuff will happen).
 *
 * We fix the problem by just splicing the offending vertex into the
 * other edge.
 *
 * @private
 * @param {libtess.GluTesselator} tess description].
 * @param {libtess.ActiveRegion} regUp [description].
 * @return {boolean} [description].
 */
libtess.sweep.checkForLeftSplice_ = function(tess, regUp) {
  var regLo = regUp.regionBelow();
  var eUp = regUp.eUp;
  var eLo = regLo.eUp;
  var e;

  if (libtess.geom.vertLeq(eUp.dst(), eLo.dst())) {
    if (libtess.geom.edgeSign(eUp.dst(), eLo.dst(), eUp.org) < 0) {
      return false;
    }

    // eLo.dst() is above eUp, so splice eLo.dst() into eUp
    regUp.regionAbove().dirty = regUp.dirty = true;
    e = libtess.mesh.splitEdge(eUp);
    libtess.mesh.meshSplice(eLo.sym, e);
    e.lFace.inside = regUp.inside;

  } else {
    if (libtess.geom.edgeSign(eLo.dst(), eUp.dst(), eLo.org) > 0) {
      return false;
    }

    // eUp.dst() is below eLo, so splice eUp.dst() into eLo
    regUp.dirty = regLo.dirty = true;
    e = libtess.mesh.splitEdge(eLo);
    libtess.mesh.meshSplice(eUp.lNext, eLo.sym);
    e.rFace().inside = regUp.inside;
  }

  return true;
};


/**
 * Check the upper and lower edges of the given region to see if
 * they intersect. If so, create the intersection and add it
 * to the data structures.
 *
 * Returns true if adding the new intersection resulted in a recursive
 * call to addRightEdges_(); in this case all "dirty" regions have been
 * checked for intersections, and possibly regUp has been deleted.
 *
 * @private
 * @param {libtess.GluTesselator} tess [description].
 * @param {libtess.ActiveRegion} regUp [description].
 * @return {boolean} [description].
 */
libtess.sweep.checkForIntersect_ = function(tess, regUp) {
  var regLo = regUp.regionBelow();
  var eUp = regUp.eUp;
  var eLo = regLo.eUp;
  var orgUp = eUp.org;
  var orgLo = eLo.org;
  var dstUp = eUp.dst();
  var dstLo = eLo.dst();

  var isect = new libtess.GluVertex();

  if (orgUp === orgLo) {
    // right endpoints are the same
    return false;
  }

  var tMinUp = Math.min(orgUp.t, dstUp.t);
  var tMaxLo = Math.max(orgLo.t, dstLo.t);
  if (tMinUp > tMaxLo) {
    // t ranges do not overlap
    return false;
  }

  if (libtess.geom.vertLeq(orgUp, orgLo)) {
    if (libtess.geom.edgeSign(dstLo, orgUp, orgLo) > 0) {
      return false;
    }
  } else {
    if (libtess.geom.edgeSign(dstUp, orgLo, orgUp) < 0) {
      return false;
    }
  }

  // At this point the edges intersect, at least marginally
  libtess.geom.edgeIntersect(dstUp, orgUp, dstLo, orgLo, isect);

  // The following properties are guaranteed:

  if (libtess.geom.vertLeq(isect, tess.event)) {
    /* The intersection point lies slightly to the left of the sweep line,
     * so move it until it's slightly to the right of the sweep line.
     * (If we had perfect numerical precision, this would never happen
     * in the first place). The easiest and safest thing to do is
     * replace the intersection by tess.event.
     */
    isect.s = tess.event.s;
    isect.t = tess.event.t;
  }

  // TODO(bckenny): try to find test54.d
  /* Similarly, if the computed intersection lies to the right of the
   * rightmost origin (which should rarely happen), it can cause
   * unbelievable inefficiency on sufficiently degenerate inputs.
   * (If you have the test program, try running test54.d with the
   * "X zoom" option turned on).
   */
  var orgMin = libtess.geom.vertLeq(orgUp, orgLo) ? orgUp : orgLo;
  if (libtess.geom.vertLeq(orgMin, isect)) {
    isect.s = orgMin.s;
    isect.t = orgMin.t;
  }

  if (libtess.geom.vertEq(isect, orgUp) || libtess.geom.vertEq(isect, orgLo)) {
    // Easy case -- intersection at one of the right endpoints
    libtess.sweep.checkForRightSplice_(tess, regUp);
    return false;
  }

  // TODO(bckenny): clean this up; length is distracting
  if ((!libtess.geom.vertEq(dstUp, tess.event) &&
      libtess.geom.edgeSign(dstUp, tess.event, isect) >= 0) ||
      (!libtess.geom.vertEq(dstLo, tess.event) &&
      libtess.geom.edgeSign(dstLo, tess.event, isect) <= 0)) {

    /* Very unusual -- the new upper or lower edge would pass on the
     * wrong side of the sweep event, or through it. This can happen
     * due to very small numerical errors in the intersection calculation.
     */
    if (dstLo === tess.event) {
      // Splice dstLo into eUp, and process the new region(s)
      libtess.mesh.splitEdge(eUp.sym);
      libtess.mesh.meshSplice(eLo.sym, eUp);
      regUp = libtess.sweep.topLeftRegion_(regUp);
      eUp = regUp.regionBelow().eUp;
      libtess.sweep.finishLeftRegions_(tess, regUp.regionBelow(), regLo);
      libtess.sweep.addRightEdges_(tess, regUp, eUp.oPrev(), eUp, eUp, true);
      return true;
    }

    if (dstUp === tess.event) {
      // Splice dstUp into eLo, and process the new region(s)
      libtess.mesh.splitEdge(eLo.sym);
      libtess.mesh.meshSplice(eUp.lNext, eLo.oPrev());
      regLo = regUp;
      regUp = libtess.sweep.topRightRegion_(regUp);
      var e = regUp.regionBelow().eUp.rPrev();
      regLo.eUp = eLo.oPrev();
      eLo = libtess.sweep.finishLeftRegions_(tess, regLo, null);
      libtess.sweep.addRightEdges_(tess, regUp, eLo.oNext, eUp.rPrev(), e,
          true);
      return true;
    }

    /* Special case: called from connectRightVertex. If either
     * edge passes on the wrong side of tess.event, split it
     * (and wait for connectRightVertex to splice it appropriately).
     */
    if (libtess.geom.edgeSign(dstUp, tess.event, isect) >= 0) {
      regUp.regionAbove().dirty = regUp.dirty = true;
      libtess.mesh.splitEdge(eUp.sym);
      eUp.org.s = tess.event.s;
      eUp.org.t = tess.event.t;
    }

    if (libtess.geom.edgeSign(dstLo, tess.event, isect) <= 0) {
      regUp.dirty = regLo.dirty = true;
      libtess.mesh.splitEdge(eLo.sym);
      eLo.org.s = tess.event.s;
      eLo.org.t = tess.event.t;
    }

    // leave the rest for connectRightVertex
    return false;
  }

  /* General case -- split both edges, splice into new vertex.
   * When we do the splice operation, the order of the arguments is
   * arbitrary as far as correctness goes. However, when the operation
   * creates a new face, the work done is proportional to the size of
   * the new face. We expect the faces in the processed part of
   * the mesh (ie. eUp.lFace) to be smaller than the faces in the
   * unprocessed original contours (which will be eLo.oPrev.lFace).
   */
  libtess.mesh.splitEdge(eUp.sym);
  libtess.mesh.splitEdge(eLo.sym);
  libtess.mesh.meshSplice(eLo.oPrev(), eUp);
  eUp.org.s = isect.s;
  eUp.org.t = isect.t;
  eUp.org.pqHandle = tess.pq.insert(eUp.org);
  libtess.sweep.getIntersectData_(tess, eUp.org, orgUp, dstUp, orgLo, dstLo);
  regUp.regionAbove().dirty = regUp.dirty = regLo.dirty = true;

  return false;
};


/**
 * When the upper or lower edge of any region changes, the region is
 * marked "dirty". This routine walks through all the dirty regions
 * and makes sure that the dictionary invariants are satisfied
 * (see the comments at the beginning of this file). Of course,
 * new dirty regions can be created as we make changes to restore
 * the invariants.
 * @private
 * @param {libtess.GluTesselator} tess [description].
 * @param {libtess.ActiveRegion} regUp [description].
 */
libtess.sweep.walkDirtyRegions_ = function(tess, regUp) {
  var regLo = regUp.regionBelow();

  for (;;) {
    // Find the lowest dirty region (we walk from the bottom up).
    while (regLo.dirty) {
      regUp = regLo;
      regLo = regLo.regionBelow();
    }
    if (!regUp.dirty) {
      regLo = regUp;
      regUp = regUp.regionAbove();
      if (regUp === null || !regUp.dirty) {
        // We've walked all the dirty regions
        return;
      }
    }

    regUp.dirty = false;
    var eUp = regUp.eUp;
    var eLo = regLo.eUp;

    if (eUp.dst() !== eLo.dst()) {
      // Check that the edge ordering is obeyed at the dst vertices.
      if (libtess.sweep.checkForLeftSplice_(tess, regUp)) {
        // If the upper or lower edge was marked fixUpperEdge, then
        // we no longer need it (since these edges are needed only for
        // vertices which otherwise have no right-going edges).
        if (regLo.fixUpperEdge) {
          libtess.sweep.deleteRegion_(tess, regLo);
          libtess.mesh.deleteEdge(eLo);
          regLo = regUp.regionBelow();
          eLo = regLo.eUp;

        } else if (regUp.fixUpperEdge) {
          libtess.sweep.deleteRegion_(tess, regUp);
          libtess.mesh.deleteEdge(eUp);
          regUp = regLo.regionAbove();
          eUp = regUp.eUp;
        }
      }
    }

    if (eUp.org !== eLo.org) {
      if (eUp.dst() !== eLo.dst() && !regUp.fixUpperEdge &&
          !regLo.fixUpperEdge &&
          (eUp.dst() === tess.event || eLo.dst() === tess.event)) {
        /* When all else fails in checkForIntersect(), it uses tess.event
         * as the intersection location. To make this possible, it requires
         * that tess.event lie between the upper and lower edges, and also
         * that neither of these is marked fixUpperEdge (since in the worst
         * case it might splice one of these edges into tess.event, and
         * violate the invariant that fixable edges are the only right-going
         * edge from their associated vertex).
         */
        if (libtess.sweep.checkForIntersect_(tess, regUp)) {
          // walkDirtyRegions() was called recursively; we're done
          return;
        }

      } else {
        // Even though we can't use checkForIntersect(), the org vertices
        // may violate the dictionary edge ordering. Check and correct this.
        libtess.sweep.checkForRightSplice_(tess, regUp);
      }
    }

    if (eUp.org === eLo.org && eUp.dst() === eLo.dst()) {
      // A degenerate loop consisting of only two edges -- delete it.
      libtess.sweep.addWinding_(eLo, eUp);
      libtess.sweep.deleteRegion_(tess, regUp);
      libtess.mesh.deleteEdge(eUp);
      regUp = regLo.regionAbove();
    }
  }
};


/**
 * Purpose: connect a "right" vertex vEvent (one where all edges go left)
 * to the unprocessed portion of the mesh. Since there are no right-going
 * edges, two regions (one above vEvent and one below) are being merged
 * into one. regUp is the upper of these two regions.
 *
 * There are two reasons for doing this (adding a right-going edge):
 *  - if the two regions being merged are "inside", we must add an edge
 *    to keep them separated (the combined region would not be monotone).
 *  - in any case, we must leave some record of vEvent in the dictionary,
 *    so that we can merge vEvent with features that we have not seen yet.
 *    For example, maybe there is a vertical edge which passes just to
 *    the right of vEvent; we would like to splice vEvent into this edge.
 *
 * However, we don't want to connect vEvent to just any vertex. We don't
 * want the new edge to cross any other edges; otherwise we will create
 * intersection vertices even when the input data had no self-intersections.
 * (This is a bad thing; if the user's input data has no intersections,
 * we don't want to generate any false intersections ourselves.)
 *
 * Our eventual goal is to connect vEvent to the leftmost unprocessed
 * vertex of the combined region (the union of regUp and regLo).
 * But because of unseen vertices with all right-going edges, and also
 * new vertices which may be created by edge intersections, we don't
 * know where that leftmost unprocessed vertex is. In the meantime, we
 * connect vEvent to the closest vertex of either chain, and mark the region
 * as "fixUpperEdge". This flag says to delete and reconnect this edge
 * to the next processed vertex on the boundary of the combined region.
 * Quite possibly the vertex we connected to will turn out to be the
 * closest one, in which case we won't need to make any changes.
 *
 * @private
 * @param {libtess.GluTesselator} tess [description].
 * @param {libtess.ActiveRegion} regUp [description].
 * @param {libtess.GluHalfEdge} eBottomLeft [description].
 */
libtess.sweep.connectRightVertex_ = function(tess, regUp, eBottomLeft) {
  var eTopLeft = eBottomLeft.oNext;
  var regLo = regUp.regionBelow();
  var eUp = regUp.eUp;
  var eLo = regLo.eUp;
  var degenerate = false;

  if (eUp.dst() !== eLo.dst()) {
    libtess.sweep.checkForIntersect_(tess, regUp);
  }

  // Possible new degeneracies: upper or lower edge of regUp may pass
  // through vEvent, or may coincide with new intersection vertex
  if (libtess.geom.vertEq(eUp.org, tess.event)) {
    libtess.mesh.meshSplice(eTopLeft.oPrev(), eUp);
    regUp = libtess.sweep.topLeftRegion_(regUp);
    eTopLeft = regUp.regionBelow().eUp;
    libtess.sweep.finishLeftRegions_(tess, regUp.regionBelow(), regLo);
    degenerate = true;
  }
  if (libtess.geom.vertEq(eLo.org, tess.event)) {
    libtess.mesh.meshSplice(eBottomLeft, eLo.oPrev());
    eBottomLeft = libtess.sweep.finishLeftRegions_(tess, regLo, null);
    degenerate = true;
  }
  if (degenerate) {
    libtess.sweep.addRightEdges_(tess, regUp, eBottomLeft.oNext, eTopLeft,
        eTopLeft, true);
    return;
  }

  // Non-degenerate situation -- need to add a temporary, fixable edge.
  // Connect to the closer of eLo.org, eUp.org.
  var eNew;
  if (libtess.geom.vertLeq(eLo.org, eUp.org)) {
    eNew = eLo.oPrev();
  } else {
    eNew = eUp;
  }
  eNew = libtess.mesh.connect(eBottomLeft.lPrev(), eNew);

  // Prevent cleanup, otherwise eNew might disappear before we've even
  // had a chance to mark it as a temporary edge.
  libtess.sweep.addRightEdges_(tess, regUp, eNew, eNew.oNext, eNew.oNext,
      false);
  eNew.sym.activeRegion.fixUpperEdge = true;
  libtess.sweep.walkDirtyRegions_(tess, regUp);
};


/**
 * The event vertex lies exacty on an already-processed edge or vertex.
 * Adding the new vertex involves splicing it into the already-processed
 * part of the mesh.
 * @private
 * @param {!libtess.GluTesselator} tess
 * @param {libtess.ActiveRegion} regUp [description].
 * @param {libtess.GluVertex} vEvent [description].
 */
libtess.sweep.connectLeftDegenerate_ = function(tess, regUp, vEvent) {
  var e = regUp.eUp;
  /* istanbul ignore if */
  if (libtess.geom.vertEq(e.org, vEvent)) {
    // NOTE(bckenny): this code is unreachable but remains for a hypothetical
    // future extension of libtess. See docs on libtess.sweep.TOLERANCE_NONZERO_
    // for more information. Conditional on TOLERANCE_NONZERO_ to help Closure
    // Compiler eliminate dead code.
    // e.org is an unprocessed vertex - just combine them, and wait
    // for e.org to be pulled from the queue
    if (libtess.sweep.TOLERANCE_NONZERO_) {
      libtess.sweep.spliceMergeVertices_(tess, e, vEvent.anEdge);
    }
    return;
  }

  if (!libtess.geom.vertEq(e.dst(), vEvent)) {
    // General case -- splice vEvent into edge e which passes through it
    libtess.mesh.splitEdge(e.sym);

    if (regUp.fixUpperEdge) {
      // This edge was fixable -- delete unused portion of original edge
      libtess.mesh.deleteEdge(e.oNext);
      regUp.fixUpperEdge = false;
    }

    libtess.mesh.meshSplice(vEvent.anEdge, e);

    // recurse
    libtess.sweep.sweepEvent_(tess, vEvent);
    return;
  }

  // NOTE(bckenny): this code is unreachable but remains for a hypothetical
  // future extension of libtess. See docs on libtess.sweep.TOLERANCE_NONZERO_
  // for more information. Conditional on TOLERANCE_NONZERO_ to help Closure
  // Compiler eliminate dead code.
  // vEvent coincides with e.dst(), which has already been processed.
  // Splice in the additional right-going edges.
  /* istanbul ignore next */

  /* istanbul ignore next */
  if (libtess.sweep.TOLERANCE_NONZERO_) {
    regUp = libtess.sweep.topRightRegion_(regUp);
    var reg = regUp.regionBelow();
    var eTopRight = reg.eUp.sym;
    var eTopLeft = eTopRight.oNext;
    var eLast = eTopLeft;

    if (reg.fixUpperEdge) {
      // Here e.dst() has only a single fixable edge going right.
      // We can delete it since now we have some real right-going edges.

      // there are some left edges too
      libtess.sweep.deleteRegion_(tess, reg); // TODO(bckenny): something to null?
      libtess.mesh.deleteEdge(eTopRight);
      eTopRight = eTopLeft.oPrev();
    }

    libtess.mesh.meshSplice(vEvent.anEdge, eTopRight);
    if (!libtess.geom.edgeGoesLeft(eTopLeft)) {
      // e.dst() had no left-going edges -- indicate this to addRightEdges()
      eTopLeft = null;
    }

    libtess.sweep.addRightEdges_(tess, regUp, eTopRight.oNext, eLast, eTopLeft,
        true);
  }
};


/**
 * Connect a "left" vertex (one where both edges go right)
 * to the processed portion of the mesh. Let R be the active region
 * containing vEvent, and let U and L be the upper and lower edge
 * chains of R. There are two possibilities:
 *
 * - the normal case: split R into two regions, by connecting vEvent to
 *   the rightmost vertex of U or L lying to the left of the sweep line
 *
 * - the degenerate case: if vEvent is close enough to U or L, we
 *   merge vEvent into that edge chain. The subcases are:
 *  - merging with the rightmost vertex of U or L
 *  - merging with the active edge of U or L
 *  - merging with an already-processed portion of U or L
 *
 * @private
 * @param {libtess.GluTesselator} tess   [description].
 * @param {libtess.GluVertex} vEvent [description].
 */
libtess.sweep.connectLeftVertex_ = function(tess, vEvent) {
  // TODO(bckenny): tmp only used for sweep. better to keep tmp across calls?
  var tmp = new libtess.ActiveRegion();

  // NOTE(bckenny): this was commented out in the original
  // libtess.assert(vEvent.anEdge.oNext.oNext === vEvent.anEdge);

  // Get a pointer to the active region containing vEvent
  tmp.eUp = vEvent.anEdge.sym;
  var regUp = tess.dict.search(tmp).getKey();
  var regLo = regUp.regionBelow();
  var eUp = regUp.eUp;
  var eLo = regLo.eUp;

  // try merging with U or L first
  if (libtess.geom.edgeSign(eUp.dst(), vEvent, eUp.org) === 0) {
    libtess.sweep.connectLeftDegenerate_(tess, regUp, vEvent);
    return;
  }

  // Connect vEvent to rightmost processed vertex of either chain.
  // e.dst() is the vertex that we will connect to vEvent.
  var reg = libtess.geom.vertLeq(eLo.dst(), eUp.dst()) ? regUp : regLo;
  var eNew;
  if (regUp.inside || reg.fixUpperEdge) {
    if (reg === regUp) {
      eNew = libtess.mesh.connect(vEvent.anEdge.sym, eUp.lNext);

    } else {
      var tempHalfEdge = libtess.mesh.connect(eLo.dNext(), vEvent.anEdge);
      eNew = tempHalfEdge.sym;
    }

    if (reg.fixUpperEdge) {
      libtess.sweep.fixUpperEdge_(reg, eNew);

    } else {
      libtess.sweep.computeWinding_(tess,
          libtess.sweep.addRegionBelow_(tess, regUp, eNew));
    }
    libtess.sweep.sweepEvent_(tess, vEvent);

  } else {
    // The new vertex is in a region which does not belong to the polygon.
    // We don''t need to connect this vertex to the rest of the mesh.
    libtess.sweep.addRightEdges_(tess, regUp, vEvent.anEdge, vEvent.anEdge,
        null, true);
  }
};


/**
 * Does everything necessary when the sweep line crosses a vertex.
 * Updates the mesh and the edge dictionary.
 * @private
 * @param {libtess.GluTesselator} tess [description].
 * @param {libtess.GluVertex} vEvent [description].
 */
libtess.sweep.sweepEvent_ = function(tess, vEvent) {
  tess.event = vEvent; // for access in edgeLeq_ // TODO(bckenny): wuh?

  /* Check if this vertex is the right endpoint of an edge that is
   * already in the dictionary.  In this case we don't need to waste
   * time searching for the location to insert new edges.
   */
  var e = vEvent.anEdge;
  while (e.activeRegion === null) {
    e = e.oNext;
    if (e === vEvent.anEdge) {
      // All edges go right -- not incident to any processed edges
      libtess.sweep.connectLeftVertex_(tess, vEvent);
      return;
    }
  }

  /* Processing consists of two phases: first we "finish" all the
   * active regions where both the upper and lower edges terminate
   * at vEvent (ie. vEvent is closing off these regions).
   * We mark these faces "inside" or "outside" the polygon according
   * to their winding number, and delete the edges from the dictionary.
   * This takes care of all the left-going edges from vEvent.
   */
  var regUp = libtess.sweep.topLeftRegion_(e.activeRegion);
  var reg = regUp.regionBelow();
  var eTopLeft = reg.eUp;
  var eBottomLeft = libtess.sweep.finishLeftRegions_(tess, reg, null);

  /* Next we process all the right-going edges from vEvent. This
   * involves adding the edges to the dictionary, and creating the
   * associated "active regions" which record information about the
   * regions between adjacent dictionary edges.
   */
  if (eBottomLeft.oNext === eTopLeft) {
    // No right-going edges -- add a temporary "fixable" edge
    libtess.sweep.connectRightVertex_(tess, regUp, eBottomLeft);

  } else {
    libtess.sweep.addRightEdges_(tess, regUp, eBottomLeft.oNext, eTopLeft,
        eTopLeft, true);
  }
};


/**
 * We add two sentinel edges above and below all other edges,
 * to avoid special cases at the top and bottom.
 * @private
 * @param {libtess.GluTesselator} tess [description].
 * @param {number} t [description].
 */
libtess.sweep.addSentinel_ = function(tess, t) {
  var reg = new libtess.ActiveRegion();

  var e = libtess.mesh.makeEdge(tess.mesh);

  e.org.s = libtess.sweep.SENTINEL_COORD_;
  e.org.t = t;
  e.dst().s = -libtess.sweep.SENTINEL_COORD_;
  e.dst().t = t;
  tess.event = e.dst(); //initialize it

  reg.eUp = e;
  reg.windingNumber = 0;
  reg.inside = false;
  reg.fixUpperEdge = false;
  reg.sentinel = true;
  reg.dirty = false;
  reg.nodeUp = tess.dict.insert(reg);
};


/**
 * We maintain an ordering of edge intersections with the sweep line.
 * This order is maintained in a dynamic dictionary.
 * @private
 * @param {libtess.GluTesselator} tess [description].
 */
libtess.sweep.initEdgeDict_ = function(tess) {
  tess.dict = new libtess.Dict(tess, libtess.sweep.edgeLeq_);

  libtess.sweep.addSentinel_(tess, -libtess.sweep.SENTINEL_COORD_);
  libtess.sweep.addSentinel_(tess, libtess.sweep.SENTINEL_COORD_);
};


/**
 * [doneEdgeDict_ description]
 * @private
 * @param {libtess.GluTesselator} tess [description].
 */
libtess.sweep.doneEdgeDict_ = function(tess) {
  // NOTE(bckenny): fixedEdges is only used in the assert below, so ignore so
  // when asserts are removed jshint won't error.
  /* jshint unused:false */
  var fixedEdges = 0;

  var reg;
  while ((reg = tess.dict.getMin().getKey()) !== null) {
    // At the end of all processing, the dictionary should contain
    // only the two sentinel edges, plus at most one "fixable" edge
    // created by connectRightVertex().
    if (!reg.sentinel) {
    }
    libtess.sweep.deleteRegion_(tess, reg);
  }

  // NOTE(bckenny): see tess.dict.deleteDict_() for old delete dict function
  tess.dict = null;
};


/**
 * Remove zero-length edges, and contours with fewer than 3 vertices.
 * @private
 * @param {libtess.GluTesselator} tess [description].
 */
libtess.sweep.removeDegenerateEdges_ = function(tess) {
  var eHead = tess.mesh.eHead;

  var eNext;
  for (var e = eHead.next; e !== eHead; e = eNext) {
    eNext = e.next;
    var eLNext = e.lNext;

    if (libtess.geom.vertEq(e.org, e.dst()) && e.lNext.lNext !== e) {
      // Zero-length edge, contour has at least 3 edges
      libtess.sweep.spliceMergeVertices_(tess, eLNext, e); // deletes e.org
      libtess.mesh.deleteEdge(e); // e is a self-loop TODO(bckenny): does this comment really apply here?
      e = eLNext;
      eLNext = e.lNext;
    }

    if (eLNext.lNext === e) {
      // Degenerate contour (one or two edges)
      if (eLNext !== e) {
        if (eLNext === eNext || eLNext === eNext.sym) {
          eNext = eNext.next;
        }
        libtess.mesh.deleteEdge(eLNext);
      }

      if (e === eNext || e === eNext.sym) {
        eNext = eNext.next;
      }
      libtess.mesh.deleteEdge(e);
    }
  }
};


/**
 * Construct priority queue and insert all vertices into it, which determines
 * the order in which vertices cross the sweep line.
 * @private
 * @param {libtess.GluTesselator} tess [description].
 */
libtess.sweep.initPriorityQ_ = function(tess) {
  var pq = new libtess.PriorityQ();
  tess.pq = pq;

  var vHead = tess.mesh.vHead;
  var v;
  for (v = vHead.next; v !== vHead; v = v.next) {
    v.pqHandle = pq.insert(v);
  }

  pq.init();
};


/**
 * [donePriorityQ_ description]
 * @private
 * @param {libtess.GluTesselator} tess [description].
 */
libtess.sweep.donePriorityQ_ = function(tess) {
  // TODO(bckenny): probably don't need deleteQ. check that function for comment
  tess.pq.deleteQ();
  tess.pq = null;
};


/**
 * Delete any degenerate faces with only two edges. walkDirtyRegions()
 * will catch almost all of these, but it won't catch degenerate faces
 * produced by splice operations on already-processed edges.
 * The two places this can happen are in finishLeftRegions(), when
 * we splice in a "temporary" edge produced by connectRightVertex(),
 * and in checkForLeftSplice(), where we splice already-processed
 * edges to ensure that our dictionary invariants are not violated
 * by numerical errors.
 *
 * In both these cases it is *very* dangerous to delete the offending
 * edge at the time, since one of the routines further up the stack
 * will sometimes be keeping a pointer to that edge.
 *
 * @private
 * @param {libtess.GluMesh} mesh [description].
 */
libtess.sweep.removeDegenerateFaces_ = function(mesh) {
  var fNext;
  for (var f = mesh.fHead.next; f !== mesh.fHead; f = fNext) {
    fNext = f.next;
    var e = f.anEdge;

    if (e.lNext.lNext === e) {
      // A face with only two edges
      libtess.sweep.addWinding_(e.oNext, e);
      libtess.mesh.deleteEdge(e);
    }
  }
};

/* global libtess */

/** @const */
libtess.tessmono = {};

/**
 * Tessellates a monotone region (what else would it do??). The region must
 * consist of a single loop of half-edges (see mesh.js) oriented CCW. "Monotone"
 * in this case means that any vertical line intersects the interior of the
 * region in a single interval.
 *
 * Tessellation consists of adding interior edges (actually pairs of
 * half-edges), to split the region into non-overlapping triangles.
 * @private
 * @param {!libtess.GluFace} face
 */
libtess.tessmono.tessellateMonoRegion_ = function(face) {
  /* The basic idea is explained in Preparata and Shamos (which I don't
   * have handy right now), although their implementation is more
   * complicated than this one. The are two edge chains, an upper chain
   * and a lower chain. We process all vertices from both chains in order,
   * from right to left.
   *
   * The algorithm ensures that the following invariant holds after each
   * vertex is processed: the untessellated region consists of two
   * chains, where one chain (say the upper) is a single edge, and
   * the other chain is concave. The left vertex of the single edge
   * is always to the left of all vertices in the concave chain.
   *
   * Each step consists of adding the rightmost unprocessed vertex to one
   * of the two chains, and forming a fan of triangles from the rightmost
   * of two chain endpoints. Determining whether we can add each triangle
   * to the fan is a simple orientation test. By making the fan as large
   * as possible, we restore the invariant (check it yourself).
   *
   * All edges are oriented CCW around the boundary of the region.
   * First, find the half-edge whose origin vertex is rightmost.
   * Since the sweep goes from left to right, face.anEdge should
   * be close to the edge we want.
   */
  var up = face.anEdge;

  for (; libtess.geom.vertLeq(up.dst(), up.org); up = up.lPrev()) { }
  for (; libtess.geom.vertLeq(up.org, up.dst()); up = up.lNext) { }

  var lo = up.lPrev();

  var tempHalfEdge;
  while (up.lNext !== lo) {
    if (libtess.geom.vertLeq(up.dst(), lo.org)) {
      // up.dst() is on the left. It is safe to form triangles from lo.org.
      // The edgeGoesLeft test guarantees progress even when some triangles
      // are CW, given that the upper and lower chains are truly monotone.
      while (lo.lNext !== up && (libtess.geom.edgeGoesLeft(lo.lNext) ||
          libtess.geom.edgeSign(lo.org, lo.dst(), lo.lNext.dst()) <= 0)) {

        tempHalfEdge = libtess.mesh.connect(lo.lNext, lo);
        lo = tempHalfEdge.sym;
      }
      lo = lo.lPrev();

    } else {
      // lo.org is on the left. We can make CCW triangles from up.dst().
      while (lo.lNext !== up && (libtess.geom.edgeGoesRight(up.lPrev()) ||
          libtess.geom.edgeSign(up.dst(), up.org, up.lPrev().org) >= 0)) {

        tempHalfEdge = libtess.mesh.connect(up, up.lPrev());
        up = tempHalfEdge.sym;
      }
      up = up.lNext;
    }
  }

  // Now lo.org == up.dst() == the leftmost vertex. The remaining region
  // can be tessellated in a fan from this leftmost vertex.
  while (lo.lNext.lNext !== up) {
    tempHalfEdge = libtess.mesh.connect(lo.lNext, lo);
    lo = tempHalfEdge.sym;
  }
};

/**
 * Tessellates each region of the mesh which is marked "inside" the polygon.
 * Each such region must be monotone.
 * @param {!libtess.GluMesh} mesh
 */
libtess.tessmono.tessellateInterior = function(mesh) {
  var next;
  for (var f = mesh.fHead.next; f !== mesh.fHead; f = next) {
    // Make sure we don't try to tessellate the new triangles.
    next = f.next;
    if (f.inside) {
      libtess.tessmono.tessellateMonoRegion_(f);
    }
  }
};

/**
 * Zaps (i.e. sets to null) all faces which are not marked "inside" the polygon.
 * Since further mesh operations on null faces are not allowed, the main purpose
 * is to clean up the mesh so that exterior loops are not represented in the
 * data structure.
 * @param {!libtess.GluMesh} mesh
 */
libtess.tessmono.discardExterior = function(mesh) {
  var next;
  for (var f = mesh.fHead.next; f !== mesh.fHead; f = next) {
    // Since f will be destroyed, save its next pointer.
    next = f.next;
    if (!f.inside) {
      libtess.mesh.zapFace(f);
    }
  }
};

/**
 * Resets the winding numbers on all edges so that regions marked "inside" the
 * polygon have a winding number of "value", and regions outside have a winding
 * number of 0.
 *
 * If keepOnlyBoundary is true, it also deletes all edges which do not separate
 * an interior region from an exterior one.
 *
 * @param {!libtess.GluMesh} mesh
 * @param {number} value
 * @param {boolean} keepOnlyBoundary
 */
libtess.tessmono.setWindingNumber = function(mesh, value, keepOnlyBoundary) {
  var eNext;
  for (var e = mesh.eHead.next; e !== mesh.eHead; e = eNext) {
    eNext = e.next;

    if (e.rFace().inside !== e.lFace.inside) {
      // This is a boundary edge (one side is interior, one is exterior).
      e.winding = (e.lFace.inside) ? value : -value;

    } else {
      // Both regions are interior, or both are exterior.
      if (!keepOnlyBoundary) {
        e.winding = 0;

      } else {
        libtess.mesh.deleteEdge(e);
      }
    }
  }
};

/* global libtess */

/**
 * A list of edges crossing the sweep line, sorted from top to bottom.
 * Implementation is a doubly-linked list, sorted by the injected edgeLeq
 * comparator function. Here it is a simple ordering, but see libtess.sweep for
 * the list of invariants on the edge dictionary this ordering creates.
 * @constructor
 * @struct
 * @param {!libtess.GluTesselator} frame
 * @param {function(!libtess.GluTesselator, !libtess.ActiveRegion, !libtess.ActiveRegion): boolean} leq
 */
libtess.Dict = function(frame, leq) {

  /**
   * The head of the doubly-linked DictNode list. At creation time, links back
   * and forward only to itself.
   * @private {!libtess.DictNode}
   */
  this.head_ = new libtess.DictNode();

  /**
   * The GluTesselator used as the frame for edge/event comparisons.
   * @private {!libtess.GluTesselator}
   */
  this.frame_ = frame;

  /**
   * Comparison function to maintain the invariants of the Dict. See
   * libtess.sweep.edgeLeq_ for source.
   * @private
   * @type {function(!libtess.GluTesselator, !libtess.ActiveRegion, !libtess.ActiveRegion): boolean}
   */
  this.leq_ = leq;
};

/* istanbul ignore next */
/**
 * Formerly used to delete the dict.
 * NOTE(bckenny): No longer called but left for memFree documentation. Nulled at
 * former callsite instead (sweep.doneEdgeDict_)
 * @private
 */
libtess.Dict.prototype.deleteDict_ = function() {
  // for (var node = this.head_.next; node !== this.head_; node = node.next) {
  //   memFree(node);
  // }
  // memFree(dict);
};

/**
 * Insert the supplied key into the edge list and return its new node.
 * @param {libtess.DictNode} node
 * @param {!libtess.ActiveRegion} key
 * @return {!libtess.DictNode}
 */
libtess.Dict.prototype.insertBefore = function(node, key) {
  do {
    node = node.prev;
  } while (node.key !== null && !this.leq_(this.frame_, node.key, key));

  // insert the new node and update the surrounding nodes to point to it
  var newNode = new libtess.DictNode(key, node.next, node);
  node.next.prev = newNode;
  node.next = newNode;

  return newNode;
};

/**
 * Insert key into the dict and return the new node that contains it.
 * @param {!libtess.ActiveRegion} key
 * @return {!libtess.DictNode}
 */
libtess.Dict.prototype.insert = function(key) {
  // NOTE(bckenny): from a macro in dict.h/dict-list.h
  return this.insertBefore(this.head_, key);
};

/**
 * Remove node from the list.
 * @param {libtess.DictNode} node
 */
libtess.Dict.prototype.deleteNode = function(node) {
  node.next.prev = node.prev;
  node.prev.next = node.next;

  // NOTE(bckenny): nulled at callsite (sweep.deleteRegion_)
  // memFree( node );
};

/**
 * Search returns the node with the smallest key greater than or equal
 * to the given key. If there is no such key, returns a node whose
 * key is null. Similarly, max(d).getSuccessor() has a null key, etc.
 * @param {!libtess.ActiveRegion} key
 * @return {!libtess.DictNode}
 */
libtess.Dict.prototype.search = function(key) {
  var node = this.head_;

  do {
    node = node.next;
  } while (node.key !== null && !this.leq_(this.frame_, key, node.key));

  return node;
};

/**
 * Return the node with the smallest key.
 * @return {!libtess.DictNode}
 */
libtess.Dict.prototype.getMin = function() {
  // NOTE(bckenny): from a macro in dict.h/dict-list.h
  return this.head_.next;
};

// NOTE(bckenny): libtess.Dict.getMax isn't called within libtess and isn't part
// of the public API. For now, leaving in but ignoring for coverage.
/* istanbul ignore next */
/**
 * Returns the node with the greatest key.
 * @return {!libtess.DictNode}
 */
libtess.Dict.prototype.getMax = function() {
  // NOTE(bckenny): from a macro in dict.h/dict-list.h
  return this.head_.prev;
};

/* global libtess */

/**
 * A doubly-linked-list node with a libtess.ActiveRegion payload.
 * The key for this node and the next and previous nodes in the parent Dict list
 * can be provided to insert it into an existing list (or all can be omitted if
 * this is to be the founding node of the list).
 * @param {!libtess.ActiveRegion=} opt_key
 * @param {!libtess.DictNode=} opt_nextNode
 * @param {!libtess.DictNode=} opt_prevNode
 * @constructor
 * @struct
 */
libtess.DictNode = function(opt_key, opt_nextNode, opt_prevNode) {
  /**
   * The ActiveRegion key for this node, or null if the head of the list.
   * @type {libtess.ActiveRegion}
   */
  this.key = opt_key || null;

  /**
   * Link to next DictNode in parent list or to self if this is the first node.
   * @type {!libtess.DictNode}
   */
  this.next = opt_nextNode || this;

  /**
   * Link to previous DictNode in parent list or to self if this is the first
   * node.
   * @type {!libtess.DictNode}
   */
  this.prev = opt_prevNode || this;
};

/**
 * Get the key from this node.
 * @return {libtess.ActiveRegion}
 */
libtess.DictNode.prototype.getKey = function() {
  return this.key;
};

/**
 * Get the successor node to this one.
 * @return {!libtess.DictNode}
 */
libtess.DictNode.prototype.getSuccessor = function() {
  return this.next;
};

/**
 * Get the predecessor node to this one.
 * @return {!libtess.DictNode}
 */
libtess.DictNode.prototype.getPredecessor = function() {
  return this.prev;
};

/* global libtess */

// TODO(bckenny): create more javascript-y API, e.g. make gluTessEndPolygon
// async, don't require so many temp objects created

/**
 * The tesselator main class, providing the public API.
 * @constructor
 * @struct
 */
libtess.GluTesselator = function() {
  // Only initialize fields which can be changed by the api. Other fields
  // are initialized where they are used.

  /*** state needed for collecting the input data ***/

  /**
   * Tesselator state, tracking what begin/end calls have been seen.
   * @private {libtess.GluTesselator.tessState_}
   */
  this.state_ = libtess.GluTesselator.tessState_.T_DORMANT;

  /**
   * lastEdge_.org is the most recent vertex
   * @private {libtess.GluHalfEdge}
   */
  this.lastEdge_ = null;

  /**
   * stores the input contours, and eventually the tessellation itself
   * @type {libtess.GluMesh}
   */
  this.mesh = null;

  /**
   * Error callback.
   * @private {?function((libtess.errorType|libtess.gluEnum), Object=)}
   */
  this.errorCallback_ = null;

  /*** state needed for projecting onto the sweep plane ***/

  /**
   * user-specified normal (if provided)
   * @private {!Array<number>}
   */
  this.normal_ = [0, 0, 0];

  /*** state needed for the line sweep ***/

  /**
   * rule for determining polygon interior
   * @type {libtess.windingRule}
   */
  this.windingRule = libtess.windingRule.GLU_TESS_WINDING_ODD;

  /**
   * fatal error: needed combine callback
   * @type {boolean}
   */
  this.fatalError = false;

  /**
   * edge dictionary for sweep line
   * @type {libtess.Dict}
   */
  this.dict = null;
  // NOTE(bckenny): dict initialized in sweep.initEdgeDict_, removed in sweep.doneEdgeDict_

  /**
   * priority queue of vertex events
   * @type {libtess.PriorityQ}
   */
  this.pq = null;
  // NOTE(bckenny): pq initialized in sweep.initPriorityQ

  /**
   * current sweep event being processed
   * @type {libtess.GluVertex}
   */
  this.event = null;

  /**
   * Combine callback.
   * @private {?function(Array<number>, Array<Object>, Array<number>, Object=): Object}
   */
  this.combineCallback_ = null;

  /*** state needed for rendering callbacks (see render.js) ***/

  /**
   * Extract contours, not triangles
   * @private {boolean}
   */
  this.boundaryOnly_ = false;

  /**
   * Begin callback.
   * @private {?function(libtess.primitiveType, Object=)}
   */
  this.beginCallback_ = null;

  /**
   * Edge flag callback.
   * @private {?function(boolean, Object=)}
   */
  this.edgeFlagCallback_ = null;

  /**
   * Vertex callback.
   * @private {?function(Object, Object=)}
   */
  this.vertexCallback_ = null;

  /**
   * End callback.
   * @private {?function(Object=)}
   */
  this.endCallback_ = null;

  /**
   * Mesh callback.
   * @private {?function(libtess.GluMesh)}
   */
  this.meshCallback_ = null;

  /**
   * client data for current polygon
   * @private {Object}
   */
  this.polygonData_ = null;
};

/**
 * The begin/end calls must be properly nested. We keep track of the current
 * state to enforce the ordering.
 * @enum {number}
 * @private
 */
libtess.GluTesselator.tessState_ = {
  T_DORMANT: 0,
  T_IN_POLYGON: 1,
  T_IN_CONTOUR: 2
};

/**
 * Destory the tesselator object. See README.
 */
libtess.GluTesselator.prototype.gluDeleteTess = function() {
  // TODO(bckenny): This does nothing but assert that it isn't called while
  // building the polygon since we rely on GC to handle memory. *If* the public
  // API changes, this should go.
  this.requireState_(libtess.GluTesselator.tessState_.T_DORMANT);
  // memFree(tess); TODO(bckenny)
};

/**
 * Set properties for control over tesselation. See README.
 * @param {libtess.gluEnum} which [description].
 * @param {number|boolean} value [description].
 */
libtess.GluTesselator.prototype.gluTessProperty = function(which, value) {
  // TODO(bckenny): split into more setters?
  // TODO(bckenny): in any case, we can do better than this switch statement

  switch (which) {
    case libtess.gluEnum.GLU_TESS_TOLERANCE:
      // NOTE(bckenny): libtess has never supported any tolerance but 0.
      return;

    case libtess.gluEnum.GLU_TESS_WINDING_RULE:
      var windingRule = /** @type {libtess.windingRule} */(value);

      switch (windingRule) {
        case libtess.windingRule.GLU_TESS_WINDING_ODD:
        case libtess.windingRule.GLU_TESS_WINDING_NONZERO:
        case libtess.windingRule.GLU_TESS_WINDING_POSITIVE:
        case libtess.windingRule.GLU_TESS_WINDING_NEGATIVE:
        case libtess.windingRule.GLU_TESS_WINDING_ABS_GEQ_TWO:
          this.windingRule = windingRule;
          return;
        default:
      }
      break;

    case libtess.gluEnum.GLU_TESS_BOUNDARY_ONLY:
      this.boundaryOnly_ = !!value;
      return;

    default:
      this.callErrorCallback(libtess.gluEnum.GLU_INVALID_ENUM);
      return;
  }
  this.callErrorCallback(libtess.gluEnum.GLU_INVALID_VALUE);
};

/**
 * Returns tessellator property
 * @param {libtess.gluEnum} which [description].
 * @return {number|boolean} [description].
 */
libtess.GluTesselator.prototype.gluGetTessProperty = function(which) {
  // TODO(bckenny): as above, split into more getters? and improve on switch statement
  // why are these being asserted in getter but not setter?

  switch (which) {
    case libtess.gluEnum.GLU_TESS_TOLERANCE:
      return 0;

    case libtess.gluEnum.GLU_TESS_WINDING_RULE:
      var rule = this.windingRule;
      return rule;

    case libtess.gluEnum.GLU_TESS_BOUNDARY_ONLY:
      return this.boundaryOnly_;

    default:
      this.callErrorCallback(libtess.gluEnum.GLU_INVALID_ENUM);
      break;
  }
  return false;
};

/**
 * Lets the user supply the polygon normal, if known. All input data is
 * projected into a plane perpendicular to the normal before tesselation. All
 * output triangles are oriented CCW with respect to the normal (CW orientation
 * can be obtained by reversing the sign of the supplied normal). For example,
 * if you know that all polygons lie in the x-y plane, call
 * `tess.gluTessNormal(0.0, 0.0, 1.0)` before rendering any polygons.
 * @param {number} x
 * @param {number} y
 * @param {number} z
 */
libtess.GluTesselator.prototype.gluTessNormal = function(x, y, z) {
  this.normal_[0] = x;
  this.normal_[1] = y;
  this.normal_[2] = z;
};

/**
 * Specify callbacks. See README for callback descriptions. A null or undefined
 * opt_fn removes current callback.
 * @param {libtess.gluEnum} which The callback-type gluEnum value.
 * @param {?Function=} opt_fn
 */
libtess.GluTesselator.prototype.gluTessCallback = function(which, opt_fn) {
  var fn = !opt_fn ? null : opt_fn;
  // TODO(bckenny): better opt_fn typing?
  // TODO(bckenny): should add documentation that references in callback are volatile (or make a copy)

  switch (which) {
    case libtess.gluEnum.GLU_TESS_BEGIN:
    case libtess.gluEnum.GLU_TESS_BEGIN_DATA:
      this.beginCallback_ = /** @type {?function(libtess.primitiveType, Object=)} */ (fn);
      return;

    case libtess.gluEnum.GLU_TESS_EDGE_FLAG:
    case libtess.gluEnum.GLU_TESS_EDGE_FLAG_DATA:
      this.edgeFlagCallback_ = /** @type {?function(boolean, Object=)} */ (fn);
      return;

    case libtess.gluEnum.GLU_TESS_VERTEX:
    case libtess.gluEnum.GLU_TESS_VERTEX_DATA:
      this.vertexCallback_ = /** @type {?function(Object, Object=)} */ (fn);
      return;

    case libtess.gluEnum.GLU_TESS_END:
    case libtess.gluEnum.GLU_TESS_END_DATA:
      this.endCallback_ = /** @type {?function(Object=)} */ (fn);
      return;

    case libtess.gluEnum.GLU_TESS_ERROR:
    case libtess.gluEnum.GLU_TESS_ERROR_DATA:
      this.errorCallback_ = /** @type {?function((libtess.errorType|libtess.gluEnum), Object=)} */ (fn);
      return;

    case libtess.gluEnum.GLU_TESS_COMBINE:
    case libtess.gluEnum.GLU_TESS_COMBINE_DATA:
      this.combineCallback_ = /** @type {?function(Array<number>, Array<Object>, Array<number>, Object=): Object} */ (fn);
      return;

    case libtess.gluEnum.GLU_TESS_MESH:
      this.meshCallback_ = /** @type {?function(libtess.GluMesh)} */ (fn);
      return;

    default:
      this.callErrorCallback(libtess.gluEnum.GLU_INVALID_ENUM);
      return;
  }
};

/**
 * Specify a vertex and associated data. Must be within calls to
 * beginContour/endContour. See README.
 * @param {!Array<number>} coords
 * @param {Object} data
 */
libtess.GluTesselator.prototype.gluTessVertex = function(coords, data) {
  var tooLarge = false;

  // TODO(bckenny): pool allocation?
  var clamped = [0, 0, 0];

  this.requireState_(libtess.GluTesselator.tessState_.T_IN_CONTOUR);

  for (var i = 0; i < 3; ++i) {
    var x = coords[i];
    if (x < -libtess.GLU_TESS_MAX_COORD) {
      x = -libtess.GLU_TESS_MAX_COORD;
      tooLarge = true;
    }
    if (x > libtess.GLU_TESS_MAX_COORD) {
      x = libtess.GLU_TESS_MAX_COORD;
      tooLarge = true;
    }
    clamped[i] = x;
  }

  if (tooLarge) {
    this.callErrorCallback(libtess.errorType.GLU_TESS_COORD_TOO_LARGE);
  }

  this.addVertex_(clamped, data);
};

/**
 * [gluTessBeginPolygon description]
 * @param {Object} data Client data for current polygon.
 */
libtess.GluTesselator.prototype.gluTessBeginPolygon = function(data) {
  this.requireState_(libtess.GluTesselator.tessState_.T_DORMANT);

  this.state_ = libtess.GluTesselator.tessState_.T_IN_POLYGON;

  this.mesh = new libtess.GluMesh();

  this.polygonData_ = data;
};

/**
 * [gluTessBeginContour description]
 */
libtess.GluTesselator.prototype.gluTessBeginContour = function() {
  this.requireState_(libtess.GluTesselator.tessState_.T_IN_POLYGON);

  this.state_ = libtess.GluTesselator.tessState_.T_IN_CONTOUR;
  this.lastEdge_ = null;
};

/**
 * [gluTessEndContour description]
 */
libtess.GluTesselator.prototype.gluTessEndContour = function() {
  this.requireState_(libtess.GluTesselator.tessState_.T_IN_CONTOUR);
  this.state_ = libtess.GluTesselator.tessState_.T_IN_POLYGON;
};

/**
 * [gluTessEndPolygon description]
 */
libtess.GluTesselator.prototype.gluTessEndPolygon = function() {
  this.requireState_(libtess.GluTesselator.tessState_.T_IN_POLYGON);
  this.state_ = libtess.GluTesselator.tessState_.T_DORMANT;

  // Determine the polygon normal and project vertices onto the plane
  // of the polygon.
  libtess.normal.projectPolygon(this, this.normal_[0], this.normal_[1],
      this.normal_[2]);

  // computeInterior(tess) computes the planar arrangement specified
  // by the given contours, and further subdivides this arrangement
  // into regions. Each region is marked "inside" if it belongs
  // to the polygon, according to the rule given by this.windingRule.
  // Each interior region is guaranteed be monotone.
  libtess.sweep.computeInterior(this);

  if (!this.fatalError) {
    // If the user wants only the boundary contours, we throw away all edges
    // except those which separate the interior from the exterior.
    // Otherwise we tessellate all the regions marked "inside".
    // NOTE(bckenny): we know this.mesh has been initialized, so help closure out.
    var mesh = /** @type {!libtess.GluMesh} */(this.mesh);
    if (this.boundaryOnly_) {
      libtess.tessmono.setWindingNumber(mesh, 1, true);
    } else {
      libtess.tessmono.tessellateInterior(mesh);
    }

    this.mesh.checkMesh();

    if (this.beginCallback_ || this.endCallback_ || this.vertexCallback_ ||
        this.edgeFlagCallback_) {

      if (this.boundaryOnly_) {
        // output boundary contours
        libtess.render.renderBoundary(this, this.mesh);

      } else {
        // output triangles (with edge callback if one is set)
        var flagEdges = !!this.edgeFlagCallback_;
        libtess.render.renderMesh(this, this.mesh, flagEdges);
      }
    }

    if (this.meshCallback_) {
      // Throw away the exterior faces, so that all faces are interior.
      // This way the user doesn't have to check the "inside" flag,
      // and we don't need to even reveal its existence. It also leaves
      // the freedom for an implementation to not generate the exterior
      // faces in the first place.
      libtess.tessmono.discardExterior(this.mesh);
      // user wants the mesh itself
      this.meshCallback_(this.mesh);

      this.mesh = null;
      this.polygonData_ = null;
      return;
    }
  }

  libtess.mesh.deleteMesh(this.mesh);
  this.polygonData_ = null;
  this.mesh = null;
};

/**
 * Change the tesselator state.
 * @private
 * @param {libtess.GluTesselator.tessState_} state
 */
libtess.GluTesselator.prototype.requireState_ = function(state) {
  if (this.state_ !== state) {
    this.gotoState_(state);
  }
};

/**
 * Change the current tesselator state one level at a time to get to the
 * desired state. Only triggered when the API is not called in the correct order
 * so an error callback is made, however the tesselator will always attempt to
 * recover afterwards (see README).
 * @private
 * @param {libtess.GluTesselator.tessState_} newState
 */
libtess.GluTesselator.prototype.gotoState_ = function(newState) {
  while (this.state_ !== newState) {
    if (this.state_ < newState) {
      switch (this.state_) {
        case libtess.GluTesselator.tessState_.T_DORMANT:
          this.callErrorCallback(
              libtess.errorType.GLU_TESS_MISSING_BEGIN_POLYGON);
          this.gluTessBeginPolygon(null);
          break;

        case libtess.GluTesselator.tessState_.T_IN_POLYGON:
          this.callErrorCallback(
              libtess.errorType.GLU_TESS_MISSING_BEGIN_CONTOUR);
          this.gluTessBeginContour();
          break;
      }

    } else {
      switch (this.state_) {
        case libtess.GluTesselator.tessState_.T_IN_CONTOUR:
          this.callErrorCallback(
              libtess.errorType.GLU_TESS_MISSING_END_CONTOUR);
          this.gluTessEndContour();
          break;

        case libtess.GluTesselator.tessState_.T_IN_POLYGON:
          this.callErrorCallback(
              libtess.errorType.GLU_TESS_MISSING_END_POLYGON);
          // NOTE(bckenny): libtess originally reset the tesselator, even though
          // the README claims it should spit out the tessellated results at
          // this point.
          // (see http://cgit.freedesktop.org/mesa/glu/tree/src/libtess/tess.c#n180)
          this.gluTessEndPolygon();
          break;
      }
    }
  }
};

/**
 * [addVertex_ description]
 * @private
 * @param {!Array<number>} coords [description].
 * @param {Object} data [description].
 */
libtess.GluTesselator.prototype.addVertex_ = function(coords, data) {
  var e = this.lastEdge_;
  if (e === null) {
    // Make a self-loop (one vertex, one edge).
    e = libtess.mesh.makeEdge(this.mesh);
    libtess.mesh.meshSplice(e, e.sym);

  } else {
    // Create a new vertex and edge which immediately follow e
    // in the ordering around the left face.
    libtess.mesh.splitEdge(e);
    e = e.lNext;
  }

  // The new vertex is now e.org.
  e.org.data = data;
  e.org.coords[0] = coords[0];
  e.org.coords[1] = coords[1];
  e.org.coords[2] = coords[2];

  // The winding of an edge says how the winding number changes as we
  // cross from the edge''s right face to its left face.  We add the
  // vertices in such an order that a CCW contour will add +1 to
  // the winding number of the region inside the contour.
  e.winding = 1;
  e.sym.winding = -1;

  this.lastEdge_ = e;
};

/**
 * Call callback to indicate the start of a primitive, to be followed by emitted
 * vertices, if any. In libtess.js, `type` will always be `GL_TRIANGLES`.
 * @param {libtess.primitiveType} type
 */
libtess.GluTesselator.prototype.callBeginCallback = function(type) {
  if (this.beginCallback_) {
    this.beginCallback_(type, this.polygonData_);
  }
};

/**
 * Call callback to emit a vertex of the tessellated polygon.
 * @param {Object} data
 */
libtess.GluTesselator.prototype.callVertexCallback = function(data) {
  if (this.vertexCallback_) {
    this.vertexCallback_(data, this.polygonData_);
  }
};

/**
 * Call callback to indicate whether the vertices to follow begin edges which
 * lie on a polygon boundary.
 * @param {boolean} flag
 */
libtess.GluTesselator.prototype.callEdgeFlagCallback = function(flag) {
  if (this.edgeFlagCallback_) {
    this.edgeFlagCallback_(flag, this.polygonData_);
  }
};

/**
 * Call callback to indicate the end of tessellation.
 */
libtess.GluTesselator.prototype.callEndCallback = function() {
  if (this.endCallback_) {
    this.endCallback_(this.polygonData_);
  }
};

/* jscs:disable maximumLineLength */
/**
 * Call callback for combining vertices at edge intersection requiring the
 * creation of a new vertex.
 * @param {!Array<number>} coords Intersection coordinates.
 * @param {!Array<Object>} data Array of vertex data, one per edge vertices.
 * @param {!Array<number>} weight Coefficients used for the linear combination of vertex coordinates that gives coords.
 * @return {?Object} Interpolated vertex.
 */
libtess.GluTesselator.prototype.callCombineCallback = function(coords, data, weight) {
  if (this.combineCallback_) {
    return this.combineCallback_(coords, data, weight, this.polygonData_) ||
        null;
  }

  return null;
};
/* jscs:enable maximumLineLength */

/**
 * Call error callback, if specified, with errno.
 * @param {(libtess.errorType|libtess.gluEnum)} errno
 */
libtess.GluTesselator.prototype.callErrorCallback = function(errno) {
  if (this.errorCallback_) {
    this.errorCallback_(errno, this.polygonData_);
  }
};

/* global libtess */

/**
 * Each face has a pointer to the next and previous faces in the
 * circular list, and a pointer to a half-edge with this face as
 * the left face (null if this is the dummy header). There is also
 * a field "data" for client data.
 *
 * @param {libtess.GluFace=} opt_nextFace
 * @param {libtess.GluFace=} opt_prevFace
 * @constructor
 * @struct
 */
libtess.GluFace = function(opt_nextFace, opt_prevFace) {
  // TODO(bckenny): reverse order of params?

  /**
   * next face (never null)
   * @type {!libtess.GluFace}
   */
  this.next = opt_nextFace || this;

  /**
   * previous face (never NULL)
   * @type {!libtess.GluFace}
   */
  this.prev = opt_prevFace || this;

  /**
   * A half edge with this left face.
   * @type {libtess.GluHalfEdge}
   */
  this.anEdge = null;

  /**
   * room for client's data
   * @type {Object}
   */
  this.data = null;

  /**
   * This face is in the polygon interior.
   * @type {boolean}
   */
  this.inside = false;
};

/* global libtess */

/**
 * The fundamental data structure is the "half-edge". Two half-edges
 * go together to make an edge, but they point in opposite directions.
 * Each half-edge has a pointer to its mate (the "symmetric" half-edge sym),
 * its origin vertex (org), the face on its left side (lFace), and the
 * adjacent half-edges in the CCW direction around the origin vertex
 * (oNext) and around the left face (lNext). There is also a "next"
 * pointer for the global edge list (see below).
 *
 * The notation used for mesh navigation:
 *  sym   = the mate of a half-edge (same edge, but opposite direction)
 *  oNext = edge CCW around origin vertex (keep same origin)
 *  dNext = edge CCW around destination vertex (keep same dest)
 *  lNext = edge CCW around left face (dest becomes new origin)
 *  rNext = edge CCW around right face (origin becomes new dest)
 *
 * "prev" means to substitute CW for CCW in the definitions above.
 *
 * The circular edge list is special; since half-edges always occur
 * in pairs (e and e.sym), each half-edge stores a pointer in only
 * one direction. Starting at eHead and following the e.next pointers
 * will visit each *edge* once (ie. e or e.sym, but not both).
 * e.sym stores a pointer in the opposite direction, thus it is
 * always true that e.sym.next.sym.next === e.
 *
 * @param {libtess.GluHalfEdge=} opt_nextEdge
 * @constructor
 * @struct
 */
libtess.GluHalfEdge = function(opt_nextEdge) {
  // TODO(bckenny): are these the right defaults? (from gl_meshNewMesh requirements)

  /**
   * doubly-linked list (prev==sym->next)
   * @type {!libtess.GluHalfEdge}
   */
  this.next = opt_nextEdge || this;

  // TODO(bckenny): how can this be required if created in pairs? move to factory creation only?
  /**
   * same edge, opposite direction
   * @type {libtess.GluHalfEdge}
   */
  this.sym = null;

  /**
   * next edge CCW around origin
   * @type {libtess.GluHalfEdge}
   */
  this.oNext = null;

  /**
   * next edge CCW around left face
   * @type {libtess.GluHalfEdge}
   */
  this.lNext = null;

  /**
   * origin vertex (oVertex too long)
   * @type {libtess.GluVertex}
   */
  this.org = null;

  /**
   * left face
   * @type {libtess.GluFace}
   */
  this.lFace = null;

  // Internal data (keep hidden)
  // NOTE(bckenny): can't be private, though...

  /**
   * a region with this upper edge (see sweep.js)
   * @type {libtess.ActiveRegion}
   */
  this.activeRegion = null;

  /**
   * change in winding number when crossing from the right face to the left face
   * @type {number}
   */
  this.winding = 0;
};

// NOTE(bckenny): the following came from macros in mesh
// TODO(bckenny): using methods as aliases for sym connections for now.
// not sure about this approach. getters? renames?


/**
 * [rFace description]
 * @return {libtess.GluFace} [description].
 */
libtess.GluHalfEdge.prototype.rFace = function() {
  return this.sym.lFace;
};


/**
 * [dst description]
 * @return {libtess.GluVertex} [description].
 */
libtess.GluHalfEdge.prototype.dst = function() {
  return this.sym.org;
};


/**
 * [oPrev description]
 * @return {libtess.GluHalfEdge} [description].
 */
libtess.GluHalfEdge.prototype.oPrev = function() {
  return this.sym.lNext;
};


/**
 * [lPrev description]
 * @return {libtess.GluHalfEdge} [description].
 */
libtess.GluHalfEdge.prototype.lPrev = function() {
  return this.oNext.sym;
};

// NOTE(bckenny): libtess.GluHalfEdge.dPrev is called nowhere in libtess and
// isn't part of the current public API. It could be useful for mesh traversal
// and manipulation if made public, however.
/* istanbul ignore next */
/**
 * The edge clockwise around destination vertex (keep same dest).
 * @return {libtess.GluHalfEdge}
 */
libtess.GluHalfEdge.prototype.dPrev = function() {
  return this.lNext.sym;
};


/**
 * [rPrev description]
 * @return {libtess.GluHalfEdge} [description].
 */
libtess.GluHalfEdge.prototype.rPrev = function() {
  return this.sym.oNext;
};


/**
 * [dNext description]
 * @return {libtess.GluHalfEdge} [description].
 */
libtess.GluHalfEdge.prototype.dNext = function() {
  return this.rPrev().sym;
};


// NOTE(bckenny): libtess.GluHalfEdge.rNext is called nowhere in libtess and
// isn't part of the current public API. It could be useful for mesh traversal
// and manipulation if made public, however.
/* istanbul ignore next */
/**
 * The edge CCW around the right face (origin of this becomes new dest).
 * @return {libtess.GluHalfEdge}
 */
libtess.GluHalfEdge.prototype.rNext = function() {
  return this.oPrev().sym;
};

/* global libtess */

/**
 * Creates a new mesh with no edges, no vertices,
 * and no loops (what we usually call a "face").
 *
 * @constructor
 * @struct
 */
libtess.GluMesh = function() {
  /**
   * dummy header for vertex list
   * @type {libtess.GluVertex}
   */
  this.vHead = new libtess.GluVertex();

  /**
   * dummy header for face list
   * @type {libtess.GluFace}
   */
  this.fHead = new libtess.GluFace();

  /**
   * dummy header for edge list
   * @type {libtess.GluHalfEdge}
   */
  this.eHead = new libtess.GluHalfEdge();

  /**
   * and its symmetric counterpart
   * @type {libtess.GluHalfEdge}
   */
  this.eHeadSym = new libtess.GluHalfEdge();

  // TODO(bckenny): better way to pair these?
  this.eHead.sym = this.eHeadSym;
  this.eHeadSym.sym = this.eHead;
};


// TODO(bckenny): #ifndef NDEBUG
/**
 * Checks mesh for self-consistency.
 */
libtess.GluMesh.prototype.checkMesh = function() {
  if (!libtess.DEBUG) {
    return;
  }

  var fHead = this.fHead;
  var vHead = this.vHead;
  var eHead = this.eHead;

  var e;

  // faces
  var f;
  var fPrev = fHead;
  for (fPrev = fHead; (f = fPrev.next) !== fHead; fPrev = f) {
    e = f.anEdge;
    do {
      e = e.lNext;
    } while (e !== f.anEdge);
  }

  // vertices
  var v;
  var vPrev = vHead;
  for (vPrev = vHead; (v = vPrev.next) !== vHead; vPrev = v) {
    e = v.anEdge;
    do {
      e = e.oNext;
    } while (e !== v.anEdge);
  }

  // edges
  var ePrev = eHead;
  for (ePrev = eHead; (e = ePrev.next) !== eHead; ePrev = e) {
  }
};

/* global libtess */

/**
 * Each vertex has a pointer to next and previous vertices in the
 * circular list, and a pointer to a half-edge with this vertex as
 * the origin (null if this is the dummy header). There is also a
 * field "data" for client data.
 * @param {libtess.GluVertex=} opt_nextVertex Optional reference to next vertex in the vertex list.
 * @param {libtess.GluVertex=} opt_prevVertex Optional reference to previous vertex in the vertex list.
 * @constructor
 * @struct
 */
libtess.GluVertex = function(opt_nextVertex, opt_prevVertex) {
  /**
   * Next vertex (never null).
   * @type {!libtess.GluVertex}
   */
  this.next = opt_nextVertex || this;

  /**
   * Previous vertex (never null).
   * @type {!libtess.GluVertex}
   */
  this.prev = opt_prevVertex || this;

  /**
   * A half-edge with this origin.
   * @type {libtess.GluHalfEdge}
   */
  this.anEdge = null;

  /**
   * The client's data.
   * @type {Object}
   */
  this.data = null;

  /**
   * The vertex location in 3D.
   * @type {!Array.<number>}
   */
  this.coords = [0, 0, 0];
  // TODO(bckenny): we may want to rethink coords, either eliminate (using s
  // and t and user data) or index into contiguous storage?

  /**
   * Component of projection onto the sweep plane.
   * @type {number}
   */
  this.s = 0;

  /**
   * Component of projection onto the sweep plane.
   * @type {number}
   */
  this.t = 0;

  /**
   * Handle to allow deletion from priority queue, or 0 if not yet inserted into
   * queue.
   * @type {libtess.PQHandle}
   */
  this.pqHandle = 0;
};

/* global libtess */

/**
 * A priority queue of vertices, ordered by libtess.geom.vertLeq, implemented
 * with a sorted array. Used for initial insertion of vertices (see
 * libtess.sweep.initPriorityQ_), sorted once, then it uses an internal
 * libtess.PriorityQHeap for any subsequently created vertices from
 * intersections.
 * @constructor
 * @struct
 */
libtess.PriorityQ = function() {
  /**
   * An unordered list of vertices that have been inserted in the queue, with
   * null in empty slots.
   * @private {Array<libtess.GluVertex>}
   */
  this.verts_ = [];

  /**
   * Array of indices into this.verts_, sorted by vertLeq over the addressed
   * vertices.
   * @private {Array<number>}
   */
  this.order_ = null;

  /**
   * The size of this queue, not counting any vertices stored in heap_.
   * @private {number}
   */
  this.size_ = 0;

  /**
   * Indicates that the queue has been initialized via init. If false, inserts
   * are fast insertions at the end of the verts_ array. If true, the verts_
   * array is sorted and subsequent inserts are done in the heap.
   * @private {boolean}
   */
  this.initialized_ = false;

  /**
   * A priority queue heap, used for faster insertions of vertices after verts_
   * has been sorted.
   * @private {libtess.PriorityQHeap}
   */
  this.heap_ = new libtess.PriorityQHeap();
};

/**
 * Release major storage memory used by priority queue.
 */
libtess.PriorityQ.prototype.deleteQ = function() {
  // TODO(bckenny): could instead clear most of these.
  this.heap_ = null;
  this.order_ = null;
  this.verts_ = null;
  // NOTE(bckenny): nulled at callsite (sweep.donePriorityQ_)
};

/**
 * Sort vertices by libtess.geom.vertLeq. Must be called before any method other
 * than insert is called to ensure correctness when removing or querying.
 */
libtess.PriorityQ.prototype.init = function() {
  // TODO(bckenny): reuse. in theory, we don't have to empty this, as access is
  // dictated by this.size_, but array.sort doesn't know that
  this.order_ = [];

  // Create an array of indirect pointers to the verts, so that
  // the handles we have returned are still valid.
  // TODO(bckenny): valid for when? it appears we can just store indexes into
  // verts_, but what did this mean?
  for (var i = 0; i < this.size_; i++) {
    this.order_[i] = i;
  }

  // sort the indirect pointers in descending order of the verts themselves
  // TODO(bckenny): make sure it's ok that verts[a] === verts[b] returns 1
  // TODO(bckenny): unstable sort means we may get slightly different polys in
  // different browsers, but only when passing in equal points
  // TODO(bckenny): make less awkward closure?
  var comparator = (function(verts) {
    return function(a, b) {
      return libtess.geom.vertLeq(verts[a], verts[b]) ? 1 : -1;
    };
  })(this.verts_);
  this.order_.sort(comparator);

  this.initialized_ = true;
  this.heap_.init();

  // NOTE(bckenny): debug assert of ordering of the verts_ array.
  if (libtess.DEBUG) {
    var p = 0;
    var r = p + this.size_ - 1;
    for (i = p; i < r; ++i) {
    }
  }
};

/**
 * Insert a vertex into the priority queue. Returns a PQHandle to refer to it,
 * which will never be 0.
 * @param {libtess.GluVertex} vert
 * @return {libtess.PQHandle}
 */
libtess.PriorityQ.prototype.insert = function(vert) {
  // NOTE(bckenny): originally returned LONG_MAX as alloc failure signal. no
  // longer does.
  if (this.initialized_) {
    return this.heap_.insert(vert);
  }

  var curr = this.size_++;

  this.verts_[curr] = vert;

  // Negative handles index the sorted array.
  return -(curr + 1);
};

/**
 * Removes the minimum vertex from the queue and returns it. If the queue is
 * empty, null will be returned.
 * @return {libtess.GluVertex}
 */
libtess.PriorityQ.prototype.extractMin = function() {
  if (this.size_ === 0) {
    return this.heap_.extractMin();
  }

  var sortMin = this.verts_[this.order_[this.size_ - 1]];
  if (!this.heap_.isEmpty()) {
    var heapMin = this.heap_.minimum();
    if (libtess.geom.vertLeq(heapMin, sortMin)) {
      return this.heap_.extractMin();
    }
  }

  do {
    --this.size_;
  } while (this.size_ > 0 && this.verts_[this.order_[this.size_ - 1]] === null);

  return sortMin;
};

/**
 * Returns the minimum vertex in the queue. If the queue is empty, null will be
 * returned.
 * @return {libtess.GluVertex}
 */
libtess.PriorityQ.prototype.minimum = function() {
  if (this.size_ === 0) {
    return this.heap_.minimum();
  }

  var sortMin = this.verts_[this.order_[this.size_ - 1]];
  if (!this.heap_.isEmpty()) {
    var heapMin = this.heap_.minimum();
    if (libtess.geom.vertLeq(heapMin, sortMin)) {
      return heapMin;
    }
  }

  return sortMin;
};

/**
 * Remove vertex with handle removeHandle from queue.
 * @param {libtess.PQHandle} removeHandle
 */
libtess.PriorityQ.prototype.remove = function(removeHandle) {
  if (removeHandle >= 0) {
    this.heap_.remove(removeHandle);
    return;
  }
  removeHandle = -(removeHandle + 1);

  this.verts_[removeHandle] = null;
  while (this.size_ > 0 && this.verts_[this.order_[this.size_ - 1]] === null) {
    --this.size_;
  }
};

/* global libtess */

/**
 * A priority queue of vertices, ordered by libtess.geom.vertLeq, implemented
 * with a binary heap. Used only within libtess.PriorityQ for prioritizing
 * vertices created by intersections (see libtess.sweep.checkForIntersect_).
 * @constructor
 * @struct
 */
libtess.PriorityQHeap = function() {
  /**
   * The heap itself. Active nodes are stored in the range 1..size, with the
   * minimum at 1. Each node stores only an index into verts_ and handles_.
   * @private {!Array<number>}
   */
  this.heap_ = libtess.PriorityQHeap.reallocNumeric_([0],
      libtess.PriorityQHeap.INIT_SIZE_ + 1);

  /**
   * An unordered list of vertices in the heap, with null in empty slots.
   * @private {!Array<libtess.GluVertex>}
   */
  this.verts_ = [null, null];

  /**
   * An unordered list of indices mapping vertex handles into the heap. An entry
   * at index i will map the vertex at i in verts_ to its place in the heap
   * (i.e. heap_[handles_[i]] === i).
   * Empty slots below size_ are a free list chain starting at freeList_.
   * @private {!Array<number>}
   */
  this.handles_ = [0, 0];

  /**
   * The size of the queue.
   * @private {number}
   */
  this.size_ = 0;

  /**
   * The queue's current allocated space.
   * @private {number}
   */
  this.max_ = libtess.PriorityQHeap.INIT_SIZE_;

  /**
   * The index of the next free hole in the verts_ array. That slot in handles_
   * has the next index in the free list. If there are no holes, freeList_ === 0
   * and a new vertex must be appended to the list.
   * @private {libtess.PQHandle}
   */
  this.freeList_ = 0;

  /**
   * Indicates that the heap has been initialized via init. If false, inserts
   * are fast insertions at the end of a list. If true, all inserts will now be
   * correctly ordered in the queue before returning.
   * @private {boolean}
   */
  this.initialized_ = false;

  // Point the first index at the first (currently null) vertex.
  this.heap_[1] = 1;
};

/**
 * The initial allocated space for the queue.
 * @const
 * @private {number}
 */
libtess.PriorityQHeap.INIT_SIZE_ = 32;

/**
 * Allocate a numeric index array of size size. oldArray's contents are copied
 * to the beginning of the new array. The rest of the array is filled with
 * zeroes.
 * @private
 * @param {!Array<number>} oldArray
 * @param {number} size
 * @return {!Array<number>}
 */
libtess.PriorityQHeap.reallocNumeric_ = function(oldArray, size) {
  var newArray = new Array(size);

  // NOTE(bckenny): V8 likes this significantly more than simply growing the
  // array element-by-element or expanding the existing array all at once, so,
  // for now, emulating realloc.
  for (var index = 0; index < oldArray.length; index++) {
    newArray[index] = oldArray[index];
  }

  for (; index < size; index++) {
    newArray[index] = 0;
  }

  return newArray;
};

/**
 * Initializing ordering of the heap. Must be called before any method other
 * than insert is called to ensure correctness when removing or querying.
 */
libtess.PriorityQHeap.prototype.init = function() {
  // This method of building a heap is O(n), rather than O(n lg n).
  for (var i = this.size_; i >= 1; --i) {
    // TODO(bckenny): since init is called before anything is inserted (see
    // PriorityQ.init), this will always be empty. Better to lazily init?
    this.floatDown_(i);
  }

  this.initialized_ = true;
};

/**
 * Insert a new vertex into the heap.
 * @param {libtess.GluVertex} vert The vertex to insert.
 * @return {libtess.PQHandle} A handle that can be used to remove the vertex.
 */
libtess.PriorityQHeap.prototype.insert = function(vert) {
  var endIndex = ++this.size_;

  // If the heap overflows, double its size.
  if ((endIndex * 2) > this.max_) {
    this.max_ *= 2;

    this.handles_ = libtess.PriorityQHeap.reallocNumeric_(this.handles_,
        this.max_ + 1);
  }

  var newVertSlot;
  if (this.freeList_ === 0) {
    // No free slots, append vertex.
    newVertSlot = endIndex;
  } else {
    // Put vertex in free slot, update freeList_ to next free slot.
    newVertSlot = this.freeList_;
    this.freeList_ = this.handles_[this.freeList_];
  }

  this.verts_[newVertSlot] = vert;
  this.handles_[newVertSlot] = endIndex;
  this.heap_[endIndex] = newVertSlot;

  if (this.initialized_) {
    this.floatUp_(endIndex);
  }
  return newVertSlot;
};

/**
 * @return {boolean} Whether the heap is empty.
 */
libtess.PriorityQHeap.prototype.isEmpty = function() {
  return this.size_ === 0;
};

/**
 * Returns the minimum vertex in the heap. If the heap is empty, null will be
 * returned.
 * @return {libtess.GluVertex}
 */
libtess.PriorityQHeap.prototype.minimum = function() {
  return this.verts_[this.heap_[1]];
};

/**
 * Removes the minimum vertex from the heap and returns it. If the heap is
 * empty, null will be returned.
 * @return {libtess.GluVertex}
 */
libtess.PriorityQHeap.prototype.extractMin = function() {
  var heap = this.heap_;
  var verts = this.verts_;
  var handles = this.handles_;

  var minHandle = heap[1];
  var minVertex = verts[minHandle];

  if (this.size_ > 0) {
    // Replace min with last vertex.
    heap[1] = heap[this.size_];
    handles[heap[1]] = 1;

    // Clear min vertex and put slot at front of freeList_.
    verts[minHandle] = null;
    handles[minHandle] = this.freeList_;
    this.freeList_ = minHandle;

    // Restore heap.
    if (--this.size_ > 0) {
      this.floatDown_(1);
    }
  }

  return minVertex;
};

/**
 * Remove vertex with handle removeHandle from heap.
 * @param {libtess.PQHandle} removeHandle
 */
libtess.PriorityQHeap.prototype.remove = function(removeHandle) {
  var heap = this.heap_;
  var verts = this.verts_;
  var handles = this.handles_;

  var heapIndex = handles[removeHandle];

  // Replace with last vertex.
  heap[heapIndex] = heap[this.size_];
  handles[heap[heapIndex]] = heapIndex;

  // Restore heap.
  if (heapIndex <= --this.size_) {
    if (heapIndex <= 1) {
      this.floatDown_(heapIndex);
    } else {
      var vert = verts[heap[heapIndex]];
      var parentVert = verts[heap[heapIndex >> 1]];
      if (libtess.geom.vertLeq(parentVert, vert)) {
        this.floatDown_(heapIndex);
      } else {
        this.floatUp_(heapIndex);
      }
    }
  }

  // Clear vertex and put slot at front of freeList_.
  verts[removeHandle] = null;
  handles[removeHandle] = this.freeList_;
  this.freeList_ = removeHandle;
};

/**
 * Restore heap by moving the vertex at index in the heap downwards to a valid
 * slot.
 * @private
 * @param {libtess.PQHandle} index
 */
libtess.PriorityQHeap.prototype.floatDown_ = function(index) {
  var heap = this.heap_;
  var verts = this.verts_;
  var handles = this.handles_;

  var currIndex = index;
  var currHandle = heap[currIndex];
  for (;;) {
    // The children of node i are nodes 2i and 2i+1.
    var childIndex = currIndex << 1;
    if (childIndex < this.size_) {
      // Set child to the index of the child with the minimum vertex.
      if (libtess.geom.vertLeq(verts[heap[childIndex + 1]],
          verts[heap[childIndex]])) {
        childIndex = childIndex + 1;
      }
    }

    var childHandle = heap[childIndex];
    if (childIndex > this.size_ ||
        libtess.geom.vertLeq(verts[currHandle], verts[childHandle])) {
      // Heap restored.
      heap[currIndex] = currHandle;
      handles[currHandle] = currIndex;
      return;
    }

    // Swap current node and child; repeat from childIndex.
    heap[currIndex] = childHandle;
    handles[childHandle] = currIndex;
    currIndex = childIndex;
  }
};

/**
 * Restore heap by moving the vertex at index in the heap upwards to a valid
 * slot.
 * @private
 * @param {libtess.PQHandle} index
 */
libtess.PriorityQHeap.prototype.floatUp_ = function(index) {
  var heap = this.heap_;
  var verts = this.verts_;
  var handles = this.handles_;

  var currIndex = index;
  var currHandle = heap[currIndex];
  for (;;) {
    // The parent of node i is node floor(i/2).
    var parentIndex = currIndex >> 1;
    var parentHandle = heap[parentIndex];

    if (parentIndex === 0 ||
        libtess.geom.vertLeq(verts[parentHandle], verts[currHandle])) {
      // Heap restored.
      heap[currIndex] = currHandle;
      handles[currHandle] = currIndex;
      return;
    }

    // Swap current node and parent; repeat from parentIndex.
    heap[currIndex] = parentHandle;
    handles[parentHandle] = currIndex;
    currIndex = parentIndex;
  }
};

/* global libtess */

// TODO(bckenny): apparently only visible outside of sweep for debugging routines.
// find out if we can hide

/**
 * For each pair of adjacent edges crossing the sweep line, there is
 * an ActiveRegion to represent the region between them. The active
 * regions are kept in sorted order in a dynamic dictionary. As the
 * sweep line crosses each vertex, we update the affected regions.
 * @constructor
 * @struct
 */
libtess.ActiveRegion = function() {
  // TODO(bckenny): I *think* eUp and nodeUp could be passed in as constructor params

  /**
   * The upper edge of the region, directed right to left
   * @type {libtess.GluHalfEdge}
   */
  this.eUp = null;

  /**
   * Dictionary node corresponding to eUp edge.
   * @type {libtess.DictNode}
   */
  this.nodeUp = null;

  /**
   * Used to determine which regions are inside the polygon.
   * @type {number}
   */
  this.windingNumber = 0;

  /**
   * Whether this region is inside the polygon.
   * @type {boolean}
   */
  this.inside = false;

  /**
   * Marks fake edges at t = +/-infinity.
   * @type {boolean}
   */
  this.sentinel = false;

  /**
   * Marks regions where the upper or lower edge has changed, but we haven't
   * checked whether they intersect yet.
   * @type {boolean}
   */
  this.dirty = false;

  /**
   * marks temporary edges introduced when we process a "right vertex" (one
   * without any edges leaving to the right)
   * @type {boolean}
   */
  this.fixUpperEdge = false;
};

/**
 * Returns the ActiveRegion below this one.
 * @return {libtess.ActiveRegion}
 */
libtess.ActiveRegion.prototype.regionBelow = function() {
  return this.nodeUp.getPredecessor().getKey();
};

/**
 * Returns the ActiveRegion above this one.
 * @return {libtess.ActiveRegion}
 */
libtess.ActiveRegion.prototype.regionAbove = function() {
  return this.nodeUp.getSuccessor().getKey();
};

/* global libtess, module */

/**
 * node.js export for non-compiled source
 */
if (true) {
  module.exports = libtess;
}


/***/ },

/***/ 7593
(__unused_webpack_module, exports) {


/*! pako 2.1.0 https://github.com/nodeca/pako @license (MIT AND Zlib) */
(function (global, factory) {
   true ? factory(exports) :
  0;
})(this, (function (exports) { 'use strict';

  // Note: adler32 takes 12% for level 0 and 2% for level 6.
  // It isn't worth it to make additional optimizations as in original.
  // Small size is preferable.

  // (C) 1995-2013 Jean-loup Gailly and Mark Adler
  // (C) 2014-2017 Vitaly Puzrin and Andrey Tupitsin
  //
  // This software is provided 'as-is', without any express or implied
  // warranty. In no event will the authors be held liable for any damages
  // arising from the use of this software.
  //
  // Permission is granted to anyone to use this software for any purpose,
  // including commercial applications, and to alter it and redistribute it
  // freely, subject to the following restrictions:
  //
  // 1. The origin of this software must not be misrepresented; you must not
  //   claim that you wrote the original software. If you use this software
  //   in a product, an acknowledgment in the product documentation would be
  //   appreciated but is not required.
  // 2. Altered source versions must be plainly marked as such, and must not be
  //   misrepresented as being the original software.
  // 3. This notice may not be removed or altered from any source distribution.

  const adler32 = (adler, buf, len, pos) => {
    let s1 = (adler & 0xffff) |0,
        s2 = ((adler >>> 16) & 0xffff) |0,
        n = 0;

    while (len !== 0) {
      // Set limit ~ twice less than 5552, to keep
      // s2 in 31-bits, because we force signed ints.
      // in other case %= will fail.
      n = len > 2000 ? 2000 : len;
      len -= n;

      do {
        s1 = (s1 + buf[pos++]) |0;
        s2 = (s2 + s1) |0;
      } while (--n);

      s1 %= 65521;
      s2 %= 65521;
    }

    return (s1 | (s2 << 16)) |0;
  };


  var adler32_1 = adler32;

  // Note: we can't get significant speed boost here.
  // So write code to minimize size - no pregenerated tables
  // and array tools dependencies.

  // (C) 1995-2013 Jean-loup Gailly and Mark Adler
  // (C) 2014-2017 Vitaly Puzrin and Andrey Tupitsin
  //
  // This software is provided 'as-is', without any express or implied
  // warranty. In no event will the authors be held liable for any damages
  // arising from the use of this software.
  //
  // Permission is granted to anyone to use this software for any purpose,
  // including commercial applications, and to alter it and redistribute it
  // freely, subject to the following restrictions:
  //
  // 1. The origin of this software must not be misrepresented; you must not
  //   claim that you wrote the original software. If you use this software
  //   in a product, an acknowledgment in the product documentation would be
  //   appreciated but is not required.
  // 2. Altered source versions must be plainly marked as such, and must not be
  //   misrepresented as being the original software.
  // 3. This notice may not be removed or altered from any source distribution.

  // Use ordinary array, since untyped makes no boost here
  const makeTable = () => {
    let c, table = [];

    for (var n = 0; n < 256; n++) {
      c = n;
      for (var k = 0; k < 8; k++) {
        c = ((c & 1) ? (0xEDB88320 ^ (c >>> 1)) : (c >>> 1));
      }
      table[n] = c;
    }

    return table;
  };

  // Create table on load. Just 255 signed longs. Not a problem.
  const crcTable = new Uint32Array(makeTable());


  const crc32 = (crc, buf, len, pos) => {
    const t = crcTable;
    const end = pos + len;

    crc ^= -1;

    for (let i = pos; i < end; i++) {
      crc = (crc >>> 8) ^ t[(crc ^ buf[i]) & 0xFF];
    }

    return (crc ^ (-1)); // >>> 0;
  };


  var crc32_1 = crc32;

  // (C) 1995-2013 Jean-loup Gailly and Mark Adler
  // (C) 2014-2017 Vitaly Puzrin and Andrey Tupitsin
  //
  // This software is provided 'as-is', without any express or implied
  // warranty. In no event will the authors be held liable for any damages
  // arising from the use of this software.
  //
  // Permission is granted to anyone to use this software for any purpose,
  // including commercial applications, and to alter it and redistribute it
  // freely, subject to the following restrictions:
  //
  // 1. The origin of this software must not be misrepresented; you must not
  //   claim that you wrote the original software. If you use this software
  //   in a product, an acknowledgment in the product documentation would be
  //   appreciated but is not required.
  // 2. Altered source versions must be plainly marked as such, and must not be
  //   misrepresented as being the original software.
  // 3. This notice may not be removed or altered from any source distribution.

  // See state defs from inflate.js
  const BAD$1 = 16209;       /* got a data error -- remain here until reset */
  const TYPE$1 = 16191;      /* i: waiting for type bits, including last-flag bit */

  /*
     Decode literal, length, and distance codes and write out the resulting
     literal and match bytes until either not enough input or output is
     available, an end-of-block is encountered, or a data error is encountered.
     When large enough input and output buffers are supplied to inflate(), for
     example, a 16K input buffer and a 64K output buffer, more than 95% of the
     inflate execution time is spent in this routine.

     Entry assumptions:

          state.mode === LEN
          strm.avail_in >= 6
          strm.avail_out >= 258
          start >= strm.avail_out
          state.bits < 8

     On return, state.mode is one of:

          LEN -- ran out of enough output space or enough available input
          TYPE -- reached end of block code, inflate() to interpret next block
          BAD -- error in block data

     Notes:

      - The maximum input bits used by a length/distance pair is 15 bits for the
        length code, 5 bits for the length extra, 15 bits for the distance code,
        and 13 bits for the distance extra.  This totals 48 bits, or six bytes.
        Therefore if strm.avail_in >= 6, then there is enough input to avoid
        checking for available input while decoding.

      - The maximum bytes that a single length/distance pair can output is 258
        bytes, which is the maximum length that can be coded.  inflate_fast()
        requires strm.avail_out >= 258 for each loop to avoid checking for
        output space.
   */
  var inffast = function inflate_fast(strm, start) {
    let _in;                    /* local strm.input */
    let last;                   /* have enough input while in < last */
    let _out;                   /* local strm.output */
    let beg;                    /* inflate()'s initial strm.output */
    let end;                    /* while out < end, enough space available */
  //#ifdef INFLATE_STRICT
    let dmax;                   /* maximum distance from zlib header */
  //#endif
    let wsize;                  /* window size or zero if not using window */
    let whave;                  /* valid bytes in the window */
    let wnext;                  /* window write index */
    // Use `s_window` instead `window`, avoid conflict with instrumentation tools
    let s_window;               /* allocated sliding window, if wsize != 0 */
    let hold;                   /* local strm.hold */
    let bits;                   /* local strm.bits */
    let lcode;                  /* local strm.lencode */
    let dcode;                  /* local strm.distcode */
    let lmask;                  /* mask for first level of length codes */
    let dmask;                  /* mask for first level of distance codes */
    let here;                   /* retrieved table entry */
    let op;                     /* code bits, operation, extra bits, or */
                                /*  window position, window bytes to copy */
    let len;                    /* match length, unused bytes */
    let dist;                   /* match distance */
    let from;                   /* where to copy match from */
    let from_source;


    let input, output; // JS specific, because we have no pointers

    /* copy state to local variables */
    const state = strm.state;
    //here = state.here;
    _in = strm.next_in;
    input = strm.input;
    last = _in + (strm.avail_in - 5);
    _out = strm.next_out;
    output = strm.output;
    beg = _out - (start - strm.avail_out);
    end = _out + (strm.avail_out - 257);
  //#ifdef INFLATE_STRICT
    dmax = state.dmax;
  //#endif
    wsize = state.wsize;
    whave = state.whave;
    wnext = state.wnext;
    s_window = state.window;
    hold = state.hold;
    bits = state.bits;
    lcode = state.lencode;
    dcode = state.distcode;
    lmask = (1 << state.lenbits) - 1;
    dmask = (1 << state.distbits) - 1;


    /* decode literals and length/distances until end-of-block or not enough
       input data or output space */

    top:
    do {
      if (bits < 15) {
        hold += input[_in++] << bits;
        bits += 8;
        hold += input[_in++] << bits;
        bits += 8;
      }

      here = lcode[hold & lmask];

      dolen:
      for (;;) { // Goto emulation
        op = here >>> 24/*here.bits*/;
        hold >>>= op;
        bits -= op;
        op = (here >>> 16) & 0xff/*here.op*/;
        if (op === 0) {                          /* literal */
          //Tracevv((stderr, here.val >= 0x20 && here.val < 0x7f ?
          //        "inflate:         literal '%c'\n" :
          //        "inflate:         literal 0x%02x\n", here.val));
          output[_out++] = here & 0xffff/*here.val*/;
        }
        else if (op & 16) {                     /* length base */
          len = here & 0xffff/*here.val*/;
          op &= 15;                           /* number of extra bits */
          if (op) {
            if (bits < op) {
              hold += input[_in++] << bits;
              bits += 8;
            }
            len += hold & ((1 << op) - 1);
            hold >>>= op;
            bits -= op;
          }
          //Tracevv((stderr, "inflate:         length %u\n", len));
          if (bits < 15) {
            hold += input[_in++] << bits;
            bits += 8;
            hold += input[_in++] << bits;
            bits += 8;
          }
          here = dcode[hold & dmask];

          dodist:
          for (;;) { // goto emulation
            op = here >>> 24/*here.bits*/;
            hold >>>= op;
            bits -= op;
            op = (here >>> 16) & 0xff/*here.op*/;

            if (op & 16) {                      /* distance base */
              dist = here & 0xffff/*here.val*/;
              op &= 15;                       /* number of extra bits */
              if (bits < op) {
                hold += input[_in++] << bits;
                bits += 8;
                if (bits < op) {
                  hold += input[_in++] << bits;
                  bits += 8;
                }
              }
              dist += hold & ((1 << op) - 1);
  //#ifdef INFLATE_STRICT
              if (dist > dmax) {
                strm.msg = 'invalid distance too far back';
                state.mode = BAD$1;
                break top;
              }
  //#endif
              hold >>>= op;
              bits -= op;
              //Tracevv((stderr, "inflate:         distance %u\n", dist));
              op = _out - beg;                /* max distance in output */
              if (dist > op) {                /* see if copy from window */
                op = dist - op;               /* distance back in window */
                if (op > whave) {
                  if (state.sane) {
                    strm.msg = 'invalid distance too far back';
                    state.mode = BAD$1;
                    break top;
                  }

  // (!) This block is disabled in zlib defaults,
  // don't enable it for binary compatibility
  //#ifdef INFLATE_ALLOW_INVALID_DISTANCE_TOOFAR_ARRR
  //                if (len <= op - whave) {
  //                  do {
  //                    output[_out++] = 0;
  //                  } while (--len);
  //                  continue top;
  //                }
  //                len -= op - whave;
  //                do {
  //                  output[_out++] = 0;
  //                } while (--op > whave);
  //                if (op === 0) {
  //                  from = _out - dist;
  //                  do {
  //                    output[_out++] = output[from++];
  //                  } while (--len);
  //                  continue top;
  //                }
  //#endif
                }
                from = 0; // window index
                from_source = s_window;
                if (wnext === 0) {           /* very common case */
                  from += wsize - op;
                  if (op < len) {         /* some from window */
                    len -= op;
                    do {
                      output[_out++] = s_window[from++];
                    } while (--op);
                    from = _out - dist;  /* rest from output */
                    from_source = output;
                  }
                }
                else if (wnext < op) {      /* wrap around window */
                  from += wsize + wnext - op;
                  op -= wnext;
                  if (op < len) {         /* some from end of window */
                    len -= op;
                    do {
                      output[_out++] = s_window[from++];
                    } while (--op);
                    from = 0;
                    if (wnext < len) {  /* some from start of window */
                      op = wnext;
                      len -= op;
                      do {
                        output[_out++] = s_window[from++];
                      } while (--op);
                      from = _out - dist;      /* rest from output */
                      from_source = output;
                    }
                  }
                }
                else {                      /* contiguous in window */
                  from += wnext - op;
                  if (op < len) {         /* some from window */
                    len -= op;
                    do {
                      output[_out++] = s_window[from++];
                    } while (--op);
                    from = _out - dist;  /* rest from output */
                    from_source = output;
                  }
                }
                while (len > 2) {
                  output[_out++] = from_source[from++];
                  output[_out++] = from_source[from++];
                  output[_out++] = from_source[from++];
                  len -= 3;
                }
                if (len) {
                  output[_out++] = from_source[from++];
                  if (len > 1) {
                    output[_out++] = from_source[from++];
                  }
                }
              }
              else {
                from = _out - dist;          /* copy direct from output */
                do {                        /* minimum length is three */
                  output[_out++] = output[from++];
                  output[_out++] = output[from++];
                  output[_out++] = output[from++];
                  len -= 3;
                } while (len > 2);
                if (len) {
                  output[_out++] = output[from++];
                  if (len > 1) {
                    output[_out++] = output[from++];
                  }
                }
              }
            }
            else if ((op & 64) === 0) {          /* 2nd level distance code */
              here = dcode[(here & 0xffff)/*here.val*/ + (hold & ((1 << op) - 1))];
              continue dodist;
            }
            else {
              strm.msg = 'invalid distance code';
              state.mode = BAD$1;
              break top;
            }

            break; // need to emulate goto via "continue"
          }
        }
        else if ((op & 64) === 0) {              /* 2nd level length code */
          here = lcode[(here & 0xffff)/*here.val*/ + (hold & ((1 << op) - 1))];
          continue dolen;
        }
        else if (op & 32) {                     /* end-of-block */
          //Tracevv((stderr, "inflate:         end of block\n"));
          state.mode = TYPE$1;
          break top;
        }
        else {
          strm.msg = 'invalid literal/length code';
          state.mode = BAD$1;
          break top;
        }

        break; // need to emulate goto via "continue"
      }
    } while (_in < last && _out < end);

    /* return unused bytes (on entry, bits < 8, so in won't go too far back) */
    len = bits >> 3;
    _in -= len;
    bits -= len << 3;
    hold &= (1 << bits) - 1;

    /* update state and return */
    strm.next_in = _in;
    strm.next_out = _out;
    strm.avail_in = (_in < last ? 5 + (last - _in) : 5 - (_in - last));
    strm.avail_out = (_out < end ? 257 + (end - _out) : 257 - (_out - end));
    state.hold = hold;
    state.bits = bits;
    return;
  };

  // (C) 1995-2013 Jean-loup Gailly and Mark Adler
  // (C) 2014-2017 Vitaly Puzrin and Andrey Tupitsin
  //
  // This software is provided 'as-is', without any express or implied
  // warranty. In no event will the authors be held liable for any damages
  // arising from the use of this software.
  //
  // Permission is granted to anyone to use this software for any purpose,
  // including commercial applications, and to alter it and redistribute it
  // freely, subject to the following restrictions:
  //
  // 1. The origin of this software must not be misrepresented; you must not
  //   claim that you wrote the original software. If you use this software
  //   in a product, an acknowledgment in the product documentation would be
  //   appreciated but is not required.
  // 2. Altered source versions must be plainly marked as such, and must not be
  //   misrepresented as being the original software.
  // 3. This notice may not be removed or altered from any source distribution.

  const MAXBITS = 15;
  const ENOUGH_LENS$1 = 852;
  const ENOUGH_DISTS$1 = 592;
  //const ENOUGH = (ENOUGH_LENS+ENOUGH_DISTS);

  const CODES$1 = 0;
  const LENS$1 = 1;
  const DISTS$1 = 2;

  const lbase = new Uint16Array([ /* Length codes 257..285 base */
    3, 4, 5, 6, 7, 8, 9, 10, 11, 13, 15, 17, 19, 23, 27, 31,
    35, 43, 51, 59, 67, 83, 99, 115, 131, 163, 195, 227, 258, 0, 0
  ]);

  const lext = new Uint8Array([ /* Length codes 257..285 extra */
    16, 16, 16, 16, 16, 16, 16, 16, 17, 17, 17, 17, 18, 18, 18, 18,
    19, 19, 19, 19, 20, 20, 20, 20, 21, 21, 21, 21, 16, 72, 78
  ]);

  const dbase = new Uint16Array([ /* Distance codes 0..29 base */
    1, 2, 3, 4, 5, 7, 9, 13, 17, 25, 33, 49, 65, 97, 129, 193,
    257, 385, 513, 769, 1025, 1537, 2049, 3073, 4097, 6145,
    8193, 12289, 16385, 24577, 0, 0
  ]);

  const dext = new Uint8Array([ /* Distance codes 0..29 extra */
    16, 16, 16, 16, 17, 17, 18, 18, 19, 19, 20, 20, 21, 21, 22, 22,
    23, 23, 24, 24, 25, 25, 26, 26, 27, 27,
    28, 28, 29, 29, 64, 64
  ]);

  const inflate_table = (type, lens, lens_index, codes, table, table_index, work, opts) =>
  {
    const bits = opts.bits;
        //here = opts.here; /* table entry for duplication */

    let len = 0;               /* a code's length in bits */
    let sym = 0;               /* index of code symbols */
    let min = 0, max = 0;          /* minimum and maximum code lengths */
    let root = 0;              /* number of index bits for root table */
    let curr = 0;              /* number of index bits for current table */
    let drop = 0;              /* code bits to drop for sub-table */
    let left = 0;                   /* number of prefix codes available */
    let used = 0;              /* code entries in table used */
    let huff = 0;              /* Huffman code */
    let incr;              /* for incrementing code, index */
    let fill;              /* index for replicating entries */
    let low;               /* low bits for current root entry */
    let mask;              /* mask for low root bits */
    let next;             /* next available space in table */
    let base = null;     /* base value table to use */
  //  let shoextra;    /* extra bits table to use */
    let match;                  /* use base and extra for symbol >= match */
    const count = new Uint16Array(MAXBITS + 1); //[MAXBITS+1];    /* number of codes of each length */
    const offs = new Uint16Array(MAXBITS + 1); //[MAXBITS+1];     /* offsets in table for each length */
    let extra = null;

    let here_bits, here_op, here_val;

    /*
     Process a set of code lengths to create a canonical Huffman code.  The
     code lengths are lens[0..codes-1].  Each length corresponds to the
     symbols 0..codes-1.  The Huffman code is generated by first sorting the
     symbols by length from short to long, and retaining the symbol order
     for codes with equal lengths.  Then the code starts with all zero bits
     for the first code of the shortest length, and the codes are integer
     increments for the same length, and zeros are appended as the length
     increases.  For the deflate format, these bits are stored backwards
     from their more natural integer increment ordering, and so when the
     decoding tables are built in the large loop below, the integer codes
     are incremented backwards.

     This routine assumes, but does not check, that all of the entries in
     lens[] are in the range 0..MAXBITS.  The caller must assure this.
     1..MAXBITS is interpreted as that code length.  zero means that that
     symbol does not occur in this code.

     The codes are sorted by computing a count of codes for each length,
     creating from that a table of starting indices for each length in the
     sorted table, and then entering the symbols in order in the sorted
     table.  The sorted table is work[], with that space being provided by
     the caller.

     The length counts are used for other purposes as well, i.e. finding
     the minimum and maximum length codes, determining if there are any
     codes at all, checking for a valid set of lengths, and looking ahead
     at length counts to determine sub-table sizes when building the
     decoding tables.
     */

    /* accumulate lengths for codes (assumes lens[] all in 0..MAXBITS) */
    for (len = 0; len <= MAXBITS; len++) {
      count[len] = 0;
    }
    for (sym = 0; sym < codes; sym++) {
      count[lens[lens_index + sym]]++;
    }

    /* bound code lengths, force root to be within code lengths */
    root = bits;
    for (max = MAXBITS; max >= 1; max--) {
      if (count[max] !== 0) { break; }
    }
    if (root > max) {
      root = max;
    }
    if (max === 0) {                     /* no symbols to code at all */
      //table.op[opts.table_index] = 64;  //here.op = (var char)64;    /* invalid code marker */
      //table.bits[opts.table_index] = 1;   //here.bits = (var char)1;
      //table.val[opts.table_index++] = 0;   //here.val = (var short)0;
      table[table_index++] = (1 << 24) | (64 << 16) | 0;


      //table.op[opts.table_index] = 64;
      //table.bits[opts.table_index] = 1;
      //table.val[opts.table_index++] = 0;
      table[table_index++] = (1 << 24) | (64 << 16) | 0;

      opts.bits = 1;
      return 0;     /* no symbols, but wait for decoding to report error */
    }
    for (min = 1; min < max; min++) {
      if (count[min] !== 0) { break; }
    }
    if (root < min) {
      root = min;
    }

    /* check for an over-subscribed or incomplete set of lengths */
    left = 1;
    for (len = 1; len <= MAXBITS; len++) {
      left <<= 1;
      left -= count[len];
      if (left < 0) {
        return -1;
      }        /* over-subscribed */
    }
    if (left > 0 && (type === CODES$1 || max !== 1)) {
      return -1;                      /* incomplete set */
    }

    /* generate offsets into symbol table for each length for sorting */
    offs[1] = 0;
    for (len = 1; len < MAXBITS; len++) {
      offs[len + 1] = offs[len] + count[len];
    }

    /* sort symbols by length, by symbol order within each length */
    for (sym = 0; sym < codes; sym++) {
      if (lens[lens_index + sym] !== 0) {
        work[offs[lens[lens_index + sym]]++] = sym;
      }
    }

    /*
     Create and fill in decoding tables.  In this loop, the table being
     filled is at next and has curr index bits.  The code being used is huff
     with length len.  That code is converted to an index by dropping drop
     bits off of the bottom.  For codes where len is less than drop + curr,
     those top drop + curr - len bits are incremented through all values to
     fill the table with replicated entries.

     root is the number of index bits for the root table.  When len exceeds
     root, sub-tables are created pointed to by the root entry with an index
     of the low root bits of huff.  This is saved in low to check for when a
     new sub-table should be started.  drop is zero when the root table is
     being filled, and drop is root when sub-tables are being filled.

     When a new sub-table is needed, it is necessary to look ahead in the
     code lengths to determine what size sub-table is needed.  The length
     counts are used for this, and so count[] is decremented as codes are
     entered in the tables.

     used keeps track of how many table entries have been allocated from the
     provided *table space.  It is checked for LENS and DIST tables against
     the constants ENOUGH_LENS and ENOUGH_DISTS to guard against changes in
     the initial root table size constants.  See the comments in inftrees.h
     for more information.

     sym increments through all symbols, and the loop terminates when
     all codes of length max, i.e. all codes, have been processed.  This
     routine permits incomplete codes, so another loop after this one fills
     in the rest of the decoding tables with invalid code markers.
     */

    /* set up for code type */
    // poor man optimization - use if-else instead of switch,
    // to avoid deopts in old v8
    if (type === CODES$1) {
      base = extra = work;    /* dummy value--not used */
      match = 20;

    } else if (type === LENS$1) {
      base = lbase;
      extra = lext;
      match = 257;

    } else {                    /* DISTS */
      base = dbase;
      extra = dext;
      match = 0;
    }

    /* initialize opts for loop */
    huff = 0;                   /* starting code */
    sym = 0;                    /* starting code symbol */
    len = min;                  /* starting code length */
    next = table_index;              /* current table to fill in */
    curr = root;                /* current table index bits */
    drop = 0;                   /* current bits to drop from code for index */
    low = -1;                   /* trigger new sub-table when len > root */
    used = 1 << root;          /* use root table entries */
    mask = used - 1;            /* mask for comparing low */

    /* check available table space */
    if ((type === LENS$1 && used > ENOUGH_LENS$1) ||
      (type === DISTS$1 && used > ENOUGH_DISTS$1)) {
      return 1;
    }

    /* process all codes and make table entries */
    for (;;) {
      /* create table entry */
      here_bits = len - drop;
      if (work[sym] + 1 < match) {
        here_op = 0;
        here_val = work[sym];
      }
      else if (work[sym] >= match) {
        here_op = extra[work[sym] - match];
        here_val = base[work[sym] - match];
      }
      else {
        here_op = 32 + 64;         /* end of block */
        here_val = 0;
      }

      /* replicate for those indices with low len bits equal to huff */
      incr = 1 << (len - drop);
      fill = 1 << curr;
      min = fill;                 /* save offset to next table */
      do {
        fill -= incr;
        table[next + (huff >> drop) + fill] = (here_bits << 24) | (here_op << 16) | here_val |0;
      } while (fill !== 0);

      /* backwards increment the len-bit code huff */
      incr = 1 << (len - 1);
      while (huff & incr) {
        incr >>= 1;
      }
      if (incr !== 0) {
        huff &= incr - 1;
        huff += incr;
      } else {
        huff = 0;
      }

      /* go to next symbol, update count, len */
      sym++;
      if (--count[len] === 0) {
        if (len === max) { break; }
        len = lens[lens_index + work[sym]];
      }

      /* create new sub-table if needed */
      if (len > root && (huff & mask) !== low) {
        /* if first time, transition to sub-tables */
        if (drop === 0) {
          drop = root;
        }

        /* increment past last table */
        next += min;            /* here min is 1 << curr */

        /* determine length of next table */
        curr = len - drop;
        left = 1 << curr;
        while (curr + drop < max) {
          left -= count[curr + drop];
          if (left <= 0) { break; }
          curr++;
          left <<= 1;
        }

        /* check for enough space */
        used += 1 << curr;
        if ((type === LENS$1 && used > ENOUGH_LENS$1) ||
          (type === DISTS$1 && used > ENOUGH_DISTS$1)) {
          return 1;
        }

        /* point entry in root table to sub-table */
        low = huff & mask;
        /*table.op[low] = curr;
        table.bits[low] = root;
        table.val[low] = next - opts.table_index;*/
        table[low] = (root << 24) | (curr << 16) | (next - table_index) |0;
      }
    }

    /* fill in remaining table entry if code is incomplete (guaranteed to have
     at most one remaining entry, since if the code is incomplete, the
     maximum code length that was allowed to get this far is one bit) */
    if (huff !== 0) {
      //table.op[next + huff] = 64;            /* invalid code marker */
      //table.bits[next + huff] = len - drop;
      //table.val[next + huff] = 0;
      table[next + huff] = ((len - drop) << 24) | (64 << 16) |0;
    }

    /* set return parameters */
    //opts.table_index += used;
    opts.bits = root;
    return 0;
  };


  var inftrees = inflate_table;

  // (C) 1995-2013 Jean-loup Gailly and Mark Adler
  // (C) 2014-2017 Vitaly Puzrin and Andrey Tupitsin
  //
  // This software is provided 'as-is', without any express or implied
  // warranty. In no event will the authors be held liable for any damages
  // arising from the use of this software.
  //
  // Permission is granted to anyone to use this software for any purpose,
  // including commercial applications, and to alter it and redistribute it
  // freely, subject to the following restrictions:
  //
  // 1. The origin of this software must not be misrepresented; you must not
  //   claim that you wrote the original software. If you use this software
  //   in a product, an acknowledgment in the product documentation would be
  //   appreciated but is not required.
  // 2. Altered source versions must be plainly marked as such, and must not be
  //   misrepresented as being the original software.
  // 3. This notice may not be removed or altered from any source distribution.

  var constants$1 = {

    /* Allowed flush values; see deflate() and inflate() below for details */
    Z_NO_FLUSH:         0,
    Z_PARTIAL_FLUSH:    1,
    Z_SYNC_FLUSH:       2,
    Z_FULL_FLUSH:       3,
    Z_FINISH:           4,
    Z_BLOCK:            5,
    Z_TREES:            6,

    /* Return codes for the compression/decompression functions. Negative values
    * are errors, positive values are used for special but normal events.
    */
    Z_OK:               0,
    Z_STREAM_END:       1,
    Z_NEED_DICT:        2,
    Z_ERRNO:           -1,
    Z_STREAM_ERROR:    -2,
    Z_DATA_ERROR:      -3,
    Z_MEM_ERROR:       -4,
    Z_BUF_ERROR:       -5,
    //Z_VERSION_ERROR: -6,

    /* compression levels */
    Z_NO_COMPRESSION:         0,
    Z_BEST_SPEED:             1,
    Z_BEST_COMPRESSION:       9,
    Z_DEFAULT_COMPRESSION:   -1,


    Z_FILTERED:               1,
    Z_HUFFMAN_ONLY:           2,
    Z_RLE:                    3,
    Z_FIXED:                  4,
    Z_DEFAULT_STRATEGY:       0,

    /* Possible values of the data_type field (though see inflate()) */
    Z_BINARY:                 0,
    Z_TEXT:                   1,
    //Z_ASCII:                1, // = Z_TEXT (deprecated)
    Z_UNKNOWN:                2,

    /* The deflate compression method */
    Z_DEFLATED:               8
    //Z_NULL:                 null // Use -1 or null inline, depending on var type
  };

  // (C) 1995-2013 Jean-loup Gailly and Mark Adler
  // (C) 2014-2017 Vitaly Puzrin and Andrey Tupitsin
  //
  // This software is provided 'as-is', without any express or implied
  // warranty. In no event will the authors be held liable for any damages
  // arising from the use of this software.
  //
  // Permission is granted to anyone to use this software for any purpose,
  // including commercial applications, and to alter it and redistribute it
  // freely, subject to the following restrictions:
  //
  // 1. The origin of this software must not be misrepresented; you must not
  //   claim that you wrote the original software. If you use this software
  //   in a product, an acknowledgment in the product documentation would be
  //   appreciated but is not required.
  // 2. Altered source versions must be plainly marked as such, and must not be
  //   misrepresented as being the original software.
  // 3. This notice may not be removed or altered from any source distribution.






  const CODES = 0;
  const LENS = 1;
  const DISTS = 2;

  /* Public constants ==========================================================*/
  /* ===========================================================================*/

  const {
    Z_FINISH: Z_FINISH$1, Z_BLOCK, Z_TREES,
    Z_OK: Z_OK$1, Z_STREAM_END: Z_STREAM_END$1, Z_NEED_DICT: Z_NEED_DICT$1, Z_STREAM_ERROR: Z_STREAM_ERROR$1, Z_DATA_ERROR: Z_DATA_ERROR$1, Z_MEM_ERROR: Z_MEM_ERROR$1, Z_BUF_ERROR,
    Z_DEFLATED
  } = constants$1;


  /* STATES ====================================================================*/
  /* ===========================================================================*/


  const    HEAD = 16180;       /* i: waiting for magic header */
  const    FLAGS = 16181;      /* i: waiting for method and flags (gzip) */
  const    TIME = 16182;       /* i: waiting for modification time (gzip) */
  const    OS = 16183;         /* i: waiting for extra flags and operating system (gzip) */
  const    EXLEN = 16184;      /* i: waiting for extra length (gzip) */
  const    EXTRA = 16185;      /* i: waiting for extra bytes (gzip) */
  const    NAME = 16186;       /* i: waiting for end of file name (gzip) */
  const    COMMENT = 16187;    /* i: waiting for end of comment (gzip) */
  const    HCRC = 16188;       /* i: waiting for header crc (gzip) */
  const    DICTID = 16189;    /* i: waiting for dictionary check value */
  const    DICT = 16190;      /* waiting for inflateSetDictionary() call */
  const        TYPE = 16191;      /* i: waiting for type bits, including last-flag bit */
  const        TYPEDO = 16192;    /* i: same, but skip check to exit inflate on new block */
  const        STORED = 16193;    /* i: waiting for stored size (length and complement) */
  const        COPY_ = 16194;     /* i/o: same as COPY below, but only first time in */
  const        COPY = 16195;      /* i/o: waiting for input or output to copy stored block */
  const        TABLE = 16196;     /* i: waiting for dynamic block table lengths */
  const        LENLENS = 16197;   /* i: waiting for code length code lengths */
  const        CODELENS = 16198;  /* i: waiting for length/lit and distance code lengths */
  const            LEN_ = 16199;      /* i: same as LEN below, but only first time in */
  const            LEN = 16200;       /* i: waiting for length/lit/eob code */
  const            LENEXT = 16201;    /* i: waiting for length extra bits */
  const            DIST = 16202;      /* i: waiting for distance code */
  const            DISTEXT = 16203;   /* i: waiting for distance extra bits */
  const            MATCH = 16204;     /* o: waiting for output space to copy string */
  const            LIT = 16205;       /* o: waiting for output space to write literal */
  const    CHECK = 16206;     /* i: waiting for 32-bit check value */
  const    LENGTH = 16207;    /* i: waiting for 32-bit length (gzip) */
  const    DONE = 16208;      /* finished check, done -- remain here until reset */
  const    BAD = 16209;       /* got a data error -- remain here until reset */
  const    MEM = 16210;       /* got an inflate() memory error -- remain here until reset */
  const    SYNC = 16211;      /* looking for synchronization bytes to restart inflate() */

  /* ===========================================================================*/



  const ENOUGH_LENS = 852;
  const ENOUGH_DISTS = 592;
  //const ENOUGH =  (ENOUGH_LENS+ENOUGH_DISTS);

  const MAX_WBITS = 15;
  /* 32K LZ77 window */
  const DEF_WBITS = MAX_WBITS;


  const zswap32 = (q) => {

    return  (((q >>> 24) & 0xff) +
            ((q >>> 8) & 0xff00) +
            ((q & 0xff00) << 8) +
            ((q & 0xff) << 24));
  };


  function InflateState() {
    this.strm = null;           /* pointer back to this zlib stream */
    this.mode = 0;              /* current inflate mode */
    this.last = false;          /* true if processing last block */
    this.wrap = 0;              /* bit 0 true for zlib, bit 1 true for gzip,
                                   bit 2 true to validate check value */
    this.havedict = false;      /* true if dictionary provided */
    this.flags = 0;             /* gzip header method and flags (0 if zlib), or
                                   -1 if raw or no header yet */
    this.dmax = 0;              /* zlib header max distance (INFLATE_STRICT) */
    this.check = 0;             /* protected copy of check value */
    this.total = 0;             /* protected copy of output count */
    // TODO: may be {}
    this.head = null;           /* where to save gzip header information */

    /* sliding window */
    this.wbits = 0;             /* log base 2 of requested window size */
    this.wsize = 0;             /* window size or zero if not using window */
    this.whave = 0;             /* valid bytes in the window */
    this.wnext = 0;             /* window write index */
    this.window = null;         /* allocated sliding window, if needed */

    /* bit accumulator */
    this.hold = 0;              /* input bit accumulator */
    this.bits = 0;              /* number of bits in "in" */

    /* for string and stored block copying */
    this.length = 0;            /* literal or length of data to copy */
    this.offset = 0;            /* distance back to copy string from */

    /* for table and code decoding */
    this.extra = 0;             /* extra bits needed */

    /* fixed and dynamic code tables */
    this.lencode = null;          /* starting table for length/literal codes */
    this.distcode = null;         /* starting table for distance codes */
    this.lenbits = 0;           /* index bits for lencode */
    this.distbits = 0;          /* index bits for distcode */

    /* dynamic table building */
    this.ncode = 0;             /* number of code length code lengths */
    this.nlen = 0;              /* number of length code lengths */
    this.ndist = 0;             /* number of distance code lengths */
    this.have = 0;              /* number of code lengths in lens[] */
    this.next = null;              /* next available space in codes[] */

    this.lens = new Uint16Array(320); /* temporary storage for code lengths */
    this.work = new Uint16Array(288); /* work area for code table building */

    /*
     because we don't have pointers in js, we use lencode and distcode directly
     as buffers so we don't need codes
    */
    //this.codes = new Int32Array(ENOUGH);       /* space for code tables */
    this.lendyn = null;              /* dynamic table for length/literal codes (JS specific) */
    this.distdyn = null;             /* dynamic table for distance codes (JS specific) */
    this.sane = 0;                   /* if false, allow invalid distance too far */
    this.back = 0;                   /* bits back of last unprocessed length/lit */
    this.was = 0;                    /* initial length of match */
  }


  const inflateStateCheck = (strm) => {

    if (!strm) {
      return 1;
    }
    const state = strm.state;
    if (!state || state.strm !== strm ||
      state.mode < HEAD || state.mode > SYNC) {
      return 1;
    }
    return 0;
  };


  const inflateResetKeep = (strm) => {

    if (inflateStateCheck(strm)) { return Z_STREAM_ERROR$1; }
    const state = strm.state;
    strm.total_in = strm.total_out = state.total = 0;
    strm.msg = ''; /*Z_NULL*/
    if (state.wrap) {       /* to support ill-conceived Java test suite */
      strm.adler = state.wrap & 1;
    }
    state.mode = HEAD;
    state.last = 0;
    state.havedict = 0;
    state.flags = -1;
    state.dmax = 32768;
    state.head = null/*Z_NULL*/;
    state.hold = 0;
    state.bits = 0;
    //state.lencode = state.distcode = state.next = state.codes;
    state.lencode = state.lendyn = new Int32Array(ENOUGH_LENS);
    state.distcode = state.distdyn = new Int32Array(ENOUGH_DISTS);

    state.sane = 1;
    state.back = -1;
    //Tracev((stderr, "inflate: reset\n"));
    return Z_OK$1;
  };


  const inflateReset = (strm) => {

    if (inflateStateCheck(strm)) { return Z_STREAM_ERROR$1; }
    const state = strm.state;
    state.wsize = 0;
    state.whave = 0;
    state.wnext = 0;
    return inflateResetKeep(strm);

  };


  const inflateReset2 = (strm, windowBits) => {
    let wrap;

    /* get the state */
    if (inflateStateCheck(strm)) { return Z_STREAM_ERROR$1; }
    const state = strm.state;

    /* extract wrap request from windowBits parameter */
    if (windowBits < 0) {
      wrap = 0;
      windowBits = -windowBits;
    }
    else {
      wrap = (windowBits >> 4) + 5;
      if (windowBits < 48) {
        windowBits &= 15;
      }
    }

    /* set number of window bits, free window if different */
    if (windowBits && (windowBits < 8 || windowBits > 15)) {
      return Z_STREAM_ERROR$1;
    }
    if (state.window !== null && state.wbits !== windowBits) {
      state.window = null;
    }

    /* update state and reset the rest of it */
    state.wrap = wrap;
    state.wbits = windowBits;
    return inflateReset(strm);
  };


  const inflateInit2 = (strm, windowBits) => {

    if (!strm) { return Z_STREAM_ERROR$1; }
    //strm.msg = Z_NULL;                 /* in case we return an error */

    const state = new InflateState();

    //if (state === Z_NULL) return Z_MEM_ERROR;
    //Tracev((stderr, "inflate: allocated\n"));
    strm.state = state;
    state.strm = strm;
    state.window = null/*Z_NULL*/;
    state.mode = HEAD;     /* to pass state test in inflateReset2() */
    const ret = inflateReset2(strm, windowBits);
    if (ret !== Z_OK$1) {
      strm.state = null/*Z_NULL*/;
    }
    return ret;
  };


  const inflateInit = (strm) => {

    return inflateInit2(strm, DEF_WBITS);
  };


  /*
   Return state with length and distance decoding tables and index sizes set to
   fixed code decoding.  Normally this returns fixed tables from inffixed.h.
   If BUILDFIXED is defined, then instead this routine builds the tables the
   first time it's called, and returns those tables the first time and
   thereafter.  This reduces the size of the code by about 2K bytes, in
   exchange for a little execution time.  However, BUILDFIXED should not be
   used for threaded applications, since the rewriting of the tables and virgin
   may not be thread-safe.
   */
  let virgin = true;

  let lenfix, distfix; // We have no pointers in JS, so keep tables separate


  const fixedtables = (state) => {

    /* build fixed huffman tables if first call (may not be thread safe) */
    if (virgin) {
      lenfix = new Int32Array(512);
      distfix = new Int32Array(32);

      /* literal/length table */
      let sym = 0;
      while (sym < 144) { state.lens[sym++] = 8; }
      while (sym < 256) { state.lens[sym++] = 9; }
      while (sym < 280) { state.lens[sym++] = 7; }
      while (sym < 288) { state.lens[sym++] = 8; }

      inftrees(LENS,  state.lens, 0, 288, lenfix,   0, state.work, { bits: 9 });

      /* distance table */
      sym = 0;
      while (sym < 32) { state.lens[sym++] = 5; }

      inftrees(DISTS, state.lens, 0, 32,   distfix, 0, state.work, { bits: 5 });

      /* do this just once */
      virgin = false;
    }

    state.lencode = lenfix;
    state.lenbits = 9;
    state.distcode = distfix;
    state.distbits = 5;
  };


  /*
   Update the window with the last wsize (normally 32K) bytes written before
   returning.  If window does not exist yet, create it.  This is only called
   when a window is already in use, or when output has been written during this
   inflate call, but the end of the deflate stream has not been reached yet.
   It is also called to create a window for dictionary data when a dictionary
   is loaded.

   Providing output buffers larger than 32K to inflate() should provide a speed
   advantage, since only the last 32K of output is copied to the sliding window
   upon return from inflate(), and since all distances after the first 32K of
   output will fall in the output data, making match copies simpler and faster.
   The advantage may be dependent on the size of the processor's data caches.
   */
  const updatewindow = (strm, src, end, copy) => {

    let dist;
    const state = strm.state;

    /* if it hasn't been done already, allocate space for the window */
    if (state.window === null) {
      state.wsize = 1 << state.wbits;
      state.wnext = 0;
      state.whave = 0;

      state.window = new Uint8Array(state.wsize);
    }

    /* copy state->wsize or less output bytes into the circular window */
    if (copy >= state.wsize) {
      state.window.set(src.subarray(end - state.wsize, end), 0);
      state.wnext = 0;
      state.whave = state.wsize;
    }
    else {
      dist = state.wsize - state.wnext;
      if (dist > copy) {
        dist = copy;
      }
      //zmemcpy(state->window + state->wnext, end - copy, dist);
      state.window.set(src.subarray(end - copy, end - copy + dist), state.wnext);
      copy -= dist;
      if (copy) {
        //zmemcpy(state->window, end - copy, copy);
        state.window.set(src.subarray(end - copy, end), 0);
        state.wnext = copy;
        state.whave = state.wsize;
      }
      else {
        state.wnext += dist;
        if (state.wnext === state.wsize) { state.wnext = 0; }
        if (state.whave < state.wsize) { state.whave += dist; }
      }
    }
    return 0;
  };


  const inflate$1 = (strm, flush) => {

    let state;
    let input, output;          // input/output buffers
    let next;                   /* next input INDEX */
    let put;                    /* next output INDEX */
    let have, left;             /* available input and output */
    let hold;                   /* bit buffer */
    let bits;                   /* bits in bit buffer */
    let _in, _out;              /* save starting available input and output */
    let copy;                   /* number of stored or match bytes to copy */
    let from;                   /* where to copy match bytes from */
    let from_source;
    let here = 0;               /* current decoding table entry */
    let here_bits, here_op, here_val; // paked "here" denormalized (JS specific)
    //let last;                   /* parent table entry */
    let last_bits, last_op, last_val; // paked "last" denormalized (JS specific)
    let len;                    /* length to copy for repeats, bits to drop */
    let ret;                    /* return code */
    const hbuf = new Uint8Array(4);    /* buffer for gzip header crc calculation */
    let opts;

    let n; // temporary variable for NEED_BITS

    const order = /* permutation of code lengths */
      new Uint8Array([ 16, 17, 18, 0, 8, 7, 9, 6, 10, 5, 11, 4, 12, 3, 13, 2, 14, 1, 15 ]);


    if (inflateStateCheck(strm) || !strm.output ||
        (!strm.input && strm.avail_in !== 0)) {
      return Z_STREAM_ERROR$1;
    }

    state = strm.state;
    if (state.mode === TYPE) { state.mode = TYPEDO; }    /* skip check */


    //--- LOAD() ---
    put = strm.next_out;
    output = strm.output;
    left = strm.avail_out;
    next = strm.next_in;
    input = strm.input;
    have = strm.avail_in;
    hold = state.hold;
    bits = state.bits;
    //---

    _in = have;
    _out = left;
    ret = Z_OK$1;

    inf_leave: // goto emulation
    for (;;) {
      switch (state.mode) {
        case HEAD:
          if (state.wrap === 0) {
            state.mode = TYPEDO;
            break;
          }
          //=== NEEDBITS(16);
          while (bits < 16) {
            if (have === 0) { break inf_leave; }
            have--;
            hold += input[next++] << bits;
            bits += 8;
          }
          //===//
          if ((state.wrap & 2) && hold === 0x8b1f) {  /* gzip header */
            if (state.wbits === 0) {
              state.wbits = 15;
            }
            state.check = 0/*crc32(0L, Z_NULL, 0)*/;
            //=== CRC2(state.check, hold);
            hbuf[0] = hold & 0xff;
            hbuf[1] = (hold >>> 8) & 0xff;
            state.check = crc32_1(state.check, hbuf, 2, 0);
            //===//

            //=== INITBITS();
            hold = 0;
            bits = 0;
            //===//
            state.mode = FLAGS;
            break;
          }
          if (state.head) {
            state.head.done = false;
          }
          if (!(state.wrap & 1) ||   /* check if zlib header allowed */
            (((hold & 0xff)/*BITS(8)*/ << 8) + (hold >> 8)) % 31) {
            strm.msg = 'incorrect header check';
            state.mode = BAD;
            break;
          }
          if ((hold & 0x0f)/*BITS(4)*/ !== Z_DEFLATED) {
            strm.msg = 'unknown compression method';
            state.mode = BAD;
            break;
          }
          //--- DROPBITS(4) ---//
          hold >>>= 4;
          bits -= 4;
          //---//
          len = (hold & 0x0f)/*BITS(4)*/ + 8;
          if (state.wbits === 0) {
            state.wbits = len;
          }
          if (len > 15 || len > state.wbits) {
            strm.msg = 'invalid window size';
            state.mode = BAD;
            break;
          }

          // !!! pako patch. Force use `options.windowBits` if passed.
          // Required to always use max window size by default.
          state.dmax = 1 << state.wbits;
          //state.dmax = 1 << len;

          state.flags = 0;               /* indicate zlib header */
          //Tracev((stderr, "inflate:   zlib header ok\n"));
          strm.adler = state.check = 1/*adler32(0L, Z_NULL, 0)*/;
          state.mode = hold & 0x200 ? DICTID : TYPE;
          //=== INITBITS();
          hold = 0;
          bits = 0;
          //===//
          break;
        case FLAGS:
          //=== NEEDBITS(16); */
          while (bits < 16) {
            if (have === 0) { break inf_leave; }
            have--;
            hold += input[next++] << bits;
            bits += 8;
          }
          //===//
          state.flags = hold;
          if ((state.flags & 0xff) !== Z_DEFLATED) {
            strm.msg = 'unknown compression method';
            state.mode = BAD;
            break;
          }
          if (state.flags & 0xe000) {
            strm.msg = 'unknown header flags set';
            state.mode = BAD;
            break;
          }
          if (state.head) {
            state.head.text = ((hold >> 8) & 1);
          }
          if ((state.flags & 0x0200) && (state.wrap & 4)) {
            //=== CRC2(state.check, hold);
            hbuf[0] = hold & 0xff;
            hbuf[1] = (hold >>> 8) & 0xff;
            state.check = crc32_1(state.check, hbuf, 2, 0);
            //===//
          }
          //=== INITBITS();
          hold = 0;
          bits = 0;
          //===//
          state.mode = TIME;
          /* falls through */
        case TIME:
          //=== NEEDBITS(32); */
          while (bits < 32) {
            if (have === 0) { break inf_leave; }
            have--;
            hold += input[next++] << bits;
            bits += 8;
          }
          //===//
          if (state.head) {
            state.head.time = hold;
          }
          if ((state.flags & 0x0200) && (state.wrap & 4)) {
            //=== CRC4(state.check, hold)
            hbuf[0] = hold & 0xff;
            hbuf[1] = (hold >>> 8) & 0xff;
            hbuf[2] = (hold >>> 16) & 0xff;
            hbuf[3] = (hold >>> 24) & 0xff;
            state.check = crc32_1(state.check, hbuf, 4, 0);
            //===
          }
          //=== INITBITS();
          hold = 0;
          bits = 0;
          //===//
          state.mode = OS;
          /* falls through */
        case OS:
          //=== NEEDBITS(16); */
          while (bits < 16) {
            if (have === 0) { break inf_leave; }
            have--;
            hold += input[next++] << bits;
            bits += 8;
          }
          //===//
          if (state.head) {
            state.head.xflags = (hold & 0xff);
            state.head.os = (hold >> 8);
          }
          if ((state.flags & 0x0200) && (state.wrap & 4)) {
            //=== CRC2(state.check, hold);
            hbuf[0] = hold & 0xff;
            hbuf[1] = (hold >>> 8) & 0xff;
            state.check = crc32_1(state.check, hbuf, 2, 0);
            //===//
          }
          //=== INITBITS();
          hold = 0;
          bits = 0;
          //===//
          state.mode = EXLEN;
          /* falls through */
        case EXLEN:
          if (state.flags & 0x0400) {
            //=== NEEDBITS(16); */
            while (bits < 16) {
              if (have === 0) { break inf_leave; }
              have--;
              hold += input[next++] << bits;
              bits += 8;
            }
            //===//
            state.length = hold;
            if (state.head) {
              state.head.extra_len = hold;
            }
            if ((state.flags & 0x0200) && (state.wrap & 4)) {
              //=== CRC2(state.check, hold);
              hbuf[0] = hold & 0xff;
              hbuf[1] = (hold >>> 8) & 0xff;
              state.check = crc32_1(state.check, hbuf, 2, 0);
              //===//
            }
            //=== INITBITS();
            hold = 0;
            bits = 0;
            //===//
          }
          else if (state.head) {
            state.head.extra = null/*Z_NULL*/;
          }
          state.mode = EXTRA;
          /* falls through */
        case EXTRA:
          if (state.flags & 0x0400) {
            copy = state.length;
            if (copy > have) { copy = have; }
            if (copy) {
              if (state.head) {
                len = state.head.extra_len - state.length;
                if (!state.head.extra) {
                  // Use untyped array for more convenient processing later
                  state.head.extra = new Uint8Array(state.head.extra_len);
                }
                state.head.extra.set(
                  input.subarray(
                    next,
                    // extra field is limited to 65536 bytes
                    // - no need for additional size check
                    next + copy
                  ),
                  /*len + copy > state.head.extra_max - len ? state.head.extra_max : copy,*/
                  len
                );
                //zmemcpy(state.head.extra + len, next,
                //        len + copy > state.head.extra_max ?
                //        state.head.extra_max - len : copy);
              }
              if ((state.flags & 0x0200) && (state.wrap & 4)) {
                state.check = crc32_1(state.check, input, copy, next);
              }
              have -= copy;
              next += copy;
              state.length -= copy;
            }
            if (state.length) { break inf_leave; }
          }
          state.length = 0;
          state.mode = NAME;
          /* falls through */
        case NAME:
          if (state.flags & 0x0800) {
            if (have === 0) { break inf_leave; }
            copy = 0;
            do {
              // TODO: 2 or 1 bytes?
              len = input[next + copy++];
              /* use constant limit because in js we should not preallocate memory */
              if (state.head && len &&
                  (state.length < 65536 /*state.head.name_max*/)) {
                state.head.name += String.fromCharCode(len);
              }
            } while (len && copy < have);

            if ((state.flags & 0x0200) && (state.wrap & 4)) {
              state.check = crc32_1(state.check, input, copy, next);
            }
            have -= copy;
            next += copy;
            if (len) { break inf_leave; }
          }
          else if (state.head) {
            state.head.name = null;
          }
          state.length = 0;
          state.mode = COMMENT;
          /* falls through */
        case COMMENT:
          if (state.flags & 0x1000) {
            if (have === 0) { break inf_leave; }
            copy = 0;
            do {
              len = input[next + copy++];
              /* use constant limit because in js we should not preallocate memory */
              if (state.head && len &&
                  (state.length < 65536 /*state.head.comm_max*/)) {
                state.head.comment += String.fromCharCode(len);
              }
            } while (len && copy < have);
            if ((state.flags & 0x0200) && (state.wrap & 4)) {
              state.check = crc32_1(state.check, input, copy, next);
            }
            have -= copy;
            next += copy;
            if (len) { break inf_leave; }
          }
          else if (state.head) {
            state.head.comment = null;
          }
          state.mode = HCRC;
          /* falls through */
        case HCRC:
          if (state.flags & 0x0200) {
            //=== NEEDBITS(16); */
            while (bits < 16) {
              if (have === 0) { break inf_leave; }
              have--;
              hold += input[next++] << bits;
              bits += 8;
            }
            //===//
            if ((state.wrap & 4) && hold !== (state.check & 0xffff)) {
              strm.msg = 'header crc mismatch';
              state.mode = BAD;
              break;
            }
            //=== INITBITS();
            hold = 0;
            bits = 0;
            //===//
          }
          if (state.head) {
            state.head.hcrc = ((state.flags >> 9) & 1);
            state.head.done = true;
          }
          strm.adler = state.check = 0;
          state.mode = TYPE;
          break;
        case DICTID:
          //=== NEEDBITS(32); */
          while (bits < 32) {
            if (have === 0) { break inf_leave; }
            have--;
            hold += input[next++] << bits;
            bits += 8;
          }
          //===//
          strm.adler = state.check = zswap32(hold);
          //=== INITBITS();
          hold = 0;
          bits = 0;
          //===//
          state.mode = DICT;
          /* falls through */
        case DICT:
          if (state.havedict === 0) {
            //--- RESTORE() ---
            strm.next_out = put;
            strm.avail_out = left;
            strm.next_in = next;
            strm.avail_in = have;
            state.hold = hold;
            state.bits = bits;
            //---
            return Z_NEED_DICT$1;
          }
          strm.adler = state.check = 1/*adler32(0L, Z_NULL, 0)*/;
          state.mode = TYPE;
          /* falls through */
        case TYPE:
          if (flush === Z_BLOCK || flush === Z_TREES) { break inf_leave; }
          /* falls through */
        case TYPEDO:
          if (state.last) {
            //--- BYTEBITS() ---//
            hold >>>= bits & 7;
            bits -= bits & 7;
            //---//
            state.mode = CHECK;
            break;
          }
          //=== NEEDBITS(3); */
          while (bits < 3) {
            if (have === 0) { break inf_leave; }
            have--;
            hold += input[next++] << bits;
            bits += 8;
          }
          //===//
          state.last = (hold & 0x01)/*BITS(1)*/;
          //--- DROPBITS(1) ---//
          hold >>>= 1;
          bits -= 1;
          //---//

          switch ((hold & 0x03)/*BITS(2)*/) {
            case 0:                             /* stored block */
              //Tracev((stderr, "inflate:     stored block%s\n",
              //        state.last ? " (last)" : ""));
              state.mode = STORED;
              break;
            case 1:                             /* fixed block */
              fixedtables(state);
              //Tracev((stderr, "inflate:     fixed codes block%s\n",
              //        state.last ? " (last)" : ""));
              state.mode = LEN_;             /* decode codes */
              if (flush === Z_TREES) {
                //--- DROPBITS(2) ---//
                hold >>>= 2;
                bits -= 2;
                //---//
                break inf_leave;
              }
              break;
            case 2:                             /* dynamic block */
              //Tracev((stderr, "inflate:     dynamic codes block%s\n",
              //        state.last ? " (last)" : ""));
              state.mode = TABLE;
              break;
            case 3:
              strm.msg = 'invalid block type';
              state.mode = BAD;
          }
          //--- DROPBITS(2) ---//
          hold >>>= 2;
          bits -= 2;
          //---//
          break;
        case STORED:
          //--- BYTEBITS() ---// /* go to byte boundary */
          hold >>>= bits & 7;
          bits -= bits & 7;
          //---//
          //=== NEEDBITS(32); */
          while (bits < 32) {
            if (have === 0) { break inf_leave; }
            have--;
            hold += input[next++] << bits;
            bits += 8;
          }
          //===//
          if ((hold & 0xffff) !== ((hold >>> 16) ^ 0xffff)) {
            strm.msg = 'invalid stored block lengths';
            state.mode = BAD;
            break;
          }
          state.length = hold & 0xffff;
          //Tracev((stderr, "inflate:       stored length %u\n",
          //        state.length));
          //=== INITBITS();
          hold = 0;
          bits = 0;
          //===//
          state.mode = COPY_;
          if (flush === Z_TREES) { break inf_leave; }
          /* falls through */
        case COPY_:
          state.mode = COPY;
          /* falls through */
        case COPY:
          copy = state.length;
          if (copy) {
            if (copy > have) { copy = have; }
            if (copy > left) { copy = left; }
            if (copy === 0) { break inf_leave; }
            //--- zmemcpy(put, next, copy); ---
            output.set(input.subarray(next, next + copy), put);
            //---//
            have -= copy;
            next += copy;
            left -= copy;
            put += copy;
            state.length -= copy;
            break;
          }
          //Tracev((stderr, "inflate:       stored end\n"));
          state.mode = TYPE;
          break;
        case TABLE:
          //=== NEEDBITS(14); */
          while (bits < 14) {
            if (have === 0) { break inf_leave; }
            have--;
            hold += input[next++] << bits;
            bits += 8;
          }
          //===//
          state.nlen = (hold & 0x1f)/*BITS(5)*/ + 257;
          //--- DROPBITS(5) ---//
          hold >>>= 5;
          bits -= 5;
          //---//
          state.ndist = (hold & 0x1f)/*BITS(5)*/ + 1;
          //--- DROPBITS(5) ---//
          hold >>>= 5;
          bits -= 5;
          //---//
          state.ncode = (hold & 0x0f)/*BITS(4)*/ + 4;
          //--- DROPBITS(4) ---//
          hold >>>= 4;
          bits -= 4;
          //---//
  //#ifndef PKZIP_BUG_WORKAROUND
          if (state.nlen > 286 || state.ndist > 30) {
            strm.msg = 'too many length or distance symbols';
            state.mode = BAD;
            break;
          }
  //#endif
          //Tracev((stderr, "inflate:       table sizes ok\n"));
          state.have = 0;
          state.mode = LENLENS;
          /* falls through */
        case LENLENS:
          while (state.have < state.ncode) {
            //=== NEEDBITS(3);
            while (bits < 3) {
              if (have === 0) { break inf_leave; }
              have--;
              hold += input[next++] << bits;
              bits += 8;
            }
            //===//
            state.lens[order[state.have++]] = (hold & 0x07);//BITS(3);
            //--- DROPBITS(3) ---//
            hold >>>= 3;
            bits -= 3;
            //---//
          }
          while (state.have < 19) {
            state.lens[order[state.have++]] = 0;
          }
          // We have separate tables & no pointers. 2 commented lines below not needed.
          //state.next = state.codes;
          //state.lencode = state.next;
          // Switch to use dynamic table
          state.lencode = state.lendyn;
          state.lenbits = 7;

          opts = { bits: state.lenbits };
          ret = inftrees(CODES, state.lens, 0, 19, state.lencode, 0, state.work, opts);
          state.lenbits = opts.bits;

          if (ret) {
            strm.msg = 'invalid code lengths set';
            state.mode = BAD;
            break;
          }
          //Tracev((stderr, "inflate:       code lengths ok\n"));
          state.have = 0;
          state.mode = CODELENS;
          /* falls through */
        case CODELENS:
          while (state.have < state.nlen + state.ndist) {
            for (;;) {
              here = state.lencode[hold & ((1 << state.lenbits) - 1)];/*BITS(state.lenbits)*/
              here_bits = here >>> 24;
              here_op = (here >>> 16) & 0xff;
              here_val = here & 0xffff;

              if ((here_bits) <= bits) { break; }
              //--- PULLBYTE() ---//
              if (have === 0) { break inf_leave; }
              have--;
              hold += input[next++] << bits;
              bits += 8;
              //---//
            }
            if (here_val < 16) {
              //--- DROPBITS(here.bits) ---//
              hold >>>= here_bits;
              bits -= here_bits;
              //---//
              state.lens[state.have++] = here_val;
            }
            else {
              if (here_val === 16) {
                //=== NEEDBITS(here.bits + 2);
                n = here_bits + 2;
                while (bits < n) {
                  if (have === 0) { break inf_leave; }
                  have--;
                  hold += input[next++] << bits;
                  bits += 8;
                }
                //===//
                //--- DROPBITS(here.bits) ---//
                hold >>>= here_bits;
                bits -= here_bits;
                //---//
                if (state.have === 0) {
                  strm.msg = 'invalid bit length repeat';
                  state.mode = BAD;
                  break;
                }
                len = state.lens[state.have - 1];
                copy = 3 + (hold & 0x03);//BITS(2);
                //--- DROPBITS(2) ---//
                hold >>>= 2;
                bits -= 2;
                //---//
              }
              else if (here_val === 17) {
                //=== NEEDBITS(here.bits + 3);
                n = here_bits + 3;
                while (bits < n) {
                  if (have === 0) { break inf_leave; }
                  have--;
                  hold += input[next++] << bits;
                  bits += 8;
                }
                //===//
                //--- DROPBITS(here.bits) ---//
                hold >>>= here_bits;
                bits -= here_bits;
                //---//
                len = 0;
                copy = 3 + (hold & 0x07);//BITS(3);
                //--- DROPBITS(3) ---//
                hold >>>= 3;
                bits -= 3;
                //---//
              }
              else {
                //=== NEEDBITS(here.bits + 7);
                n = here_bits + 7;
                while (bits < n) {
                  if (have === 0) { break inf_leave; }
                  have--;
                  hold += input[next++] << bits;
                  bits += 8;
                }
                //===//
                //--- DROPBITS(here.bits) ---//
                hold >>>= here_bits;
                bits -= here_bits;
                //---//
                len = 0;
                copy = 11 + (hold & 0x7f);//BITS(7);
                //--- DROPBITS(7) ---//
                hold >>>= 7;
                bits -= 7;
                //---//
              }
              if (state.have + copy > state.nlen + state.ndist) {
                strm.msg = 'invalid bit length repeat';
                state.mode = BAD;
                break;
              }
              while (copy--) {
                state.lens[state.have++] = len;
              }
            }
          }

          /* handle error breaks in while */
          if (state.mode === BAD) { break; }

          /* check for end-of-block code (better have one) */
          if (state.lens[256] === 0) {
            strm.msg = 'invalid code -- missing end-of-block';
            state.mode = BAD;
            break;
          }

          /* build code tables -- note: do not change the lenbits or distbits
             values here (9 and 6) without reading the comments in inftrees.h
             concerning the ENOUGH constants, which depend on those values */
          state.lenbits = 9;

          opts = { bits: state.lenbits };
          ret = inftrees(LENS, state.lens, 0, state.nlen, state.lencode, 0, state.work, opts);
          // We have separate tables & no pointers. 2 commented lines below not needed.
          // state.next_index = opts.table_index;
          state.lenbits = opts.bits;
          // state.lencode = state.next;

          if (ret) {
            strm.msg = 'invalid literal/lengths set';
            state.mode = BAD;
            break;
          }

          state.distbits = 6;
          //state.distcode.copy(state.codes);
          // Switch to use dynamic table
          state.distcode = state.distdyn;
          opts = { bits: state.distbits };
          ret = inftrees(DISTS, state.lens, state.nlen, state.ndist, state.distcode, 0, state.work, opts);
          // We have separate tables & no pointers. 2 commented lines below not needed.
          // state.next_index = opts.table_index;
          state.distbits = opts.bits;
          // state.distcode = state.next;

          if (ret) {
            strm.msg = 'invalid distances set';
            state.mode = BAD;
            break;
          }
          //Tracev((stderr, 'inflate:       codes ok\n'));
          state.mode = LEN_;
          if (flush === Z_TREES) { break inf_leave; }
          /* falls through */
        case LEN_:
          state.mode = LEN;
          /* falls through */
        case LEN:
          if (have >= 6 && left >= 258) {
            //--- RESTORE() ---
            strm.next_out = put;
            strm.avail_out = left;
            strm.next_in = next;
            strm.avail_in = have;
            state.hold = hold;
            state.bits = bits;
            //---
            inffast(strm, _out);
            //--- LOAD() ---
            put = strm.next_out;
            output = strm.output;
            left = strm.avail_out;
            next = strm.next_in;
            input = strm.input;
            have = strm.avail_in;
            hold = state.hold;
            bits = state.bits;
            //---

            if (state.mode === TYPE) {
              state.back = -1;
            }
            break;
          }
          state.back = 0;
          for (;;) {
            here = state.lencode[hold & ((1 << state.lenbits) - 1)];  /*BITS(state.lenbits)*/
            here_bits = here >>> 24;
            here_op = (here >>> 16) & 0xff;
            here_val = here & 0xffff;

            if (here_bits <= bits) { break; }
            //--- PULLBYTE() ---//
            if (have === 0) { break inf_leave; }
            have--;
            hold += input[next++] << bits;
            bits += 8;
            //---//
          }
          if (here_op && (here_op & 0xf0) === 0) {
            last_bits = here_bits;
            last_op = here_op;
            last_val = here_val;
            for (;;) {
              here = state.lencode[last_val +
                      ((hold & ((1 << (last_bits + last_op)) - 1))/*BITS(last.bits + last.op)*/ >> last_bits)];
              here_bits = here >>> 24;
              here_op = (here >>> 16) & 0xff;
              here_val = here & 0xffff;

              if ((last_bits + here_bits) <= bits) { break; }
              //--- PULLBYTE() ---//
              if (have === 0) { break inf_leave; }
              have--;
              hold += input[next++] << bits;
              bits += 8;
              //---//
            }
            //--- DROPBITS(last.bits) ---//
            hold >>>= last_bits;
            bits -= last_bits;
            //---//
            state.back += last_bits;
          }
          //--- DROPBITS(here.bits) ---//
          hold >>>= here_bits;
          bits -= here_bits;
          //---//
          state.back += here_bits;
          state.length = here_val;
          if (here_op === 0) {
            //Tracevv((stderr, here.val >= 0x20 && here.val < 0x7f ?
            //        "inflate:         literal '%c'\n" :
            //        "inflate:         literal 0x%02x\n", here.val));
            state.mode = LIT;
            break;
          }
          if (here_op & 32) {
            //Tracevv((stderr, "inflate:         end of block\n"));
            state.back = -1;
            state.mode = TYPE;
            break;
          }
          if (here_op & 64) {
            strm.msg = 'invalid literal/length code';
            state.mode = BAD;
            break;
          }
          state.extra = here_op & 15;
          state.mode = LENEXT;
          /* falls through */
        case LENEXT:
          if (state.extra) {
            //=== NEEDBITS(state.extra);
            n = state.extra;
            while (bits < n) {
              if (have === 0) { break inf_leave; }
              have--;
              hold += input[next++] << bits;
              bits += 8;
            }
            //===//
            state.length += hold & ((1 << state.extra) - 1)/*BITS(state.extra)*/;
            //--- DROPBITS(state.extra) ---//
            hold >>>= state.extra;
            bits -= state.extra;
            //---//
            state.back += state.extra;
          }
          //Tracevv((stderr, "inflate:         length %u\n", state.length));
          state.was = state.length;
          state.mode = DIST;
          /* falls through */
        case DIST:
          for (;;) {
            here = state.distcode[hold & ((1 << state.distbits) - 1)];/*BITS(state.distbits)*/
            here_bits = here >>> 24;
            here_op = (here >>> 16) & 0xff;
            here_val = here & 0xffff;

            if ((here_bits) <= bits) { break; }
            //--- PULLBYTE() ---//
            if (have === 0) { break inf_leave; }
            have--;
            hold += input[next++] << bits;
            bits += 8;
            //---//
          }
          if ((here_op & 0xf0) === 0) {
            last_bits = here_bits;
            last_op = here_op;
            last_val = here_val;
            for (;;) {
              here = state.distcode[last_val +
                      ((hold & ((1 << (last_bits + last_op)) - 1))/*BITS(last.bits + last.op)*/ >> last_bits)];
              here_bits = here >>> 24;
              here_op = (here >>> 16) & 0xff;
              here_val = here & 0xffff;

              if ((last_bits + here_bits) <= bits) { break; }
              //--- PULLBYTE() ---//
              if (have === 0) { break inf_leave; }
              have--;
              hold += input[next++] << bits;
              bits += 8;
              //---//
            }
            //--- DROPBITS(last.bits) ---//
            hold >>>= last_bits;
            bits -= last_bits;
            //---//
            state.back += last_bits;
          }
          //--- DROPBITS(here.bits) ---//
          hold >>>= here_bits;
          bits -= here_bits;
          //---//
          state.back += here_bits;
          if (here_op & 64) {
            strm.msg = 'invalid distance code';
            state.mode = BAD;
            break;
          }
          state.offset = here_val;
          state.extra = (here_op) & 15;
          state.mode = DISTEXT;
          /* falls through */
        case DISTEXT:
          if (state.extra) {
            //=== NEEDBITS(state.extra);
            n = state.extra;
            while (bits < n) {
              if (have === 0) { break inf_leave; }
              have--;
              hold += input[next++] << bits;
              bits += 8;
            }
            //===//
            state.offset += hold & ((1 << state.extra) - 1)/*BITS(state.extra)*/;
            //--- DROPBITS(state.extra) ---//
            hold >>>= state.extra;
            bits -= state.extra;
            //---//
            state.back += state.extra;
          }
  //#ifdef INFLATE_STRICT
          if (state.offset > state.dmax) {
            strm.msg = 'invalid distance too far back';
            state.mode = BAD;
            break;
          }
  //#endif
          //Tracevv((stderr, "inflate:         distance %u\n", state.offset));
          state.mode = MATCH;
          /* falls through */
        case MATCH:
          if (left === 0) { break inf_leave; }
          copy = _out - left;
          if (state.offset > copy) {         /* copy from window */
            copy = state.offset - copy;
            if (copy > state.whave) {
              if (state.sane) {
                strm.msg = 'invalid distance too far back';
                state.mode = BAD;
                break;
              }
  // (!) This block is disabled in zlib defaults,
  // don't enable it for binary compatibility
  //#ifdef INFLATE_ALLOW_INVALID_DISTANCE_TOOFAR_ARRR
  //          Trace((stderr, "inflate.c too far\n"));
  //          copy -= state.whave;
  //          if (copy > state.length) { copy = state.length; }
  //          if (copy > left) { copy = left; }
  //          left -= copy;
  //          state.length -= copy;
  //          do {
  //            output[put++] = 0;
  //          } while (--copy);
  //          if (state.length === 0) { state.mode = LEN; }
  //          break;
  //#endif
            }
            if (copy > state.wnext) {
              copy -= state.wnext;
              from = state.wsize - copy;
            }
            else {
              from = state.wnext - copy;
            }
            if (copy > state.length) { copy = state.length; }
            from_source = state.window;
          }
          else {                              /* copy from output */
            from_source = output;
            from = put - state.offset;
            copy = state.length;
          }
          if (copy > left) { copy = left; }
          left -= copy;
          state.length -= copy;
          do {
            output[put++] = from_source[from++];
          } while (--copy);
          if (state.length === 0) { state.mode = LEN; }
          break;
        case LIT:
          if (left === 0) { break inf_leave; }
          output[put++] = state.length;
          left--;
          state.mode = LEN;
          break;
        case CHECK:
          if (state.wrap) {
            //=== NEEDBITS(32);
            while (bits < 32) {
              if (have === 0) { break inf_leave; }
              have--;
              // Use '|' instead of '+' to make sure that result is signed
              hold |= input[next++] << bits;
              bits += 8;
            }
            //===//
            _out -= left;
            strm.total_out += _out;
            state.total += _out;
            if ((state.wrap & 4) && _out) {
              strm.adler = state.check =
                  /*UPDATE_CHECK(state.check, put - _out, _out);*/
                  (state.flags ? crc32_1(state.check, output, _out, put - _out) : adler32_1(state.check, output, _out, put - _out));

            }
            _out = left;
            // NB: crc32 stored as signed 32-bit int, zswap32 returns signed too
            if ((state.wrap & 4) && (state.flags ? hold : zswap32(hold)) !== state.check) {
              strm.msg = 'incorrect data check';
              state.mode = BAD;
              break;
            }
            //=== INITBITS();
            hold = 0;
            bits = 0;
            //===//
            //Tracev((stderr, "inflate:   check matches trailer\n"));
          }
          state.mode = LENGTH;
          /* falls through */
        case LENGTH:
          if (state.wrap && state.flags) {
            //=== NEEDBITS(32);
            while (bits < 32) {
              if (have === 0) { break inf_leave; }
              have--;
              hold += input[next++] << bits;
              bits += 8;
            }
            //===//
            if ((state.wrap & 4) && hold !== (state.total & 0xffffffff)) {
              strm.msg = 'incorrect length check';
              state.mode = BAD;
              break;
            }
            //=== INITBITS();
            hold = 0;
            bits = 0;
            //===//
            //Tracev((stderr, "inflate:   length matches trailer\n"));
          }
          state.mode = DONE;
          /* falls through */
        case DONE:
          ret = Z_STREAM_END$1;
          break inf_leave;
        case BAD:
          ret = Z_DATA_ERROR$1;
          break inf_leave;
        case MEM:
          return Z_MEM_ERROR$1;
        case SYNC:
          /* falls through */
        default:
          return Z_STREAM_ERROR$1;
      }
    }

    // inf_leave <- here is real place for "goto inf_leave", emulated via "break inf_leave"

    /*
       Return from inflate(), updating the total counts and the check value.
       If there was no progress during the inflate() call, return a buffer
       error.  Call updatewindow() to create and/or update the window state.
       Note: a memory error from inflate() is non-recoverable.
     */

    //--- RESTORE() ---
    strm.next_out = put;
    strm.avail_out = left;
    strm.next_in = next;
    strm.avail_in = have;
    state.hold = hold;
    state.bits = bits;
    //---

    if (state.wsize || (_out !== strm.avail_out && state.mode < BAD &&
                        (state.mode < CHECK || flush !== Z_FINISH$1))) {
      if (updatewindow(strm, strm.output, strm.next_out, _out - strm.avail_out)) ;
    }
    _in -= strm.avail_in;
    _out -= strm.avail_out;
    strm.total_in += _in;
    strm.total_out += _out;
    state.total += _out;
    if ((state.wrap & 4) && _out) {
      strm.adler = state.check = /*UPDATE_CHECK(state.check, strm.next_out - _out, _out);*/
        (state.flags ? crc32_1(state.check, output, _out, strm.next_out - _out) : adler32_1(state.check, output, _out, strm.next_out - _out));
    }
    strm.data_type = state.bits + (state.last ? 64 : 0) +
                      (state.mode === TYPE ? 128 : 0) +
                      (state.mode === LEN_ || state.mode === COPY_ ? 256 : 0);
    if (((_in === 0 && _out === 0) || flush === Z_FINISH$1) && ret === Z_OK$1) {
      ret = Z_BUF_ERROR;
    }
    return ret;
  };


  const inflateEnd = (strm) => {

    if (inflateStateCheck(strm)) {
      return Z_STREAM_ERROR$1;
    }

    let state = strm.state;
    if (state.window) {
      state.window = null;
    }
    strm.state = null;
    return Z_OK$1;
  };


  const inflateGetHeader = (strm, head) => {

    /* check state */
    if (inflateStateCheck(strm)) { return Z_STREAM_ERROR$1; }
    const state = strm.state;
    if ((state.wrap & 2) === 0) { return Z_STREAM_ERROR$1; }

    /* save header structure */
    state.head = head;
    head.done = false;
    return Z_OK$1;
  };


  const inflateSetDictionary = (strm, dictionary) => {
    const dictLength = dictionary.length;

    let state;
    let dictid;
    let ret;

    /* check state */
    if (inflateStateCheck(strm)) { return Z_STREAM_ERROR$1; }
    state = strm.state;

    if (state.wrap !== 0 && state.mode !== DICT) {
      return Z_STREAM_ERROR$1;
    }

    /* check for correct dictionary identifier */
    if (state.mode === DICT) {
      dictid = 1; /* adler32(0, null, 0)*/
      /* dictid = adler32(dictid, dictionary, dictLength); */
      dictid = adler32_1(dictid, dictionary, dictLength, 0);
      if (dictid !== state.check) {
        return Z_DATA_ERROR$1;
      }
    }
    /* copy dictionary to window using updatewindow(), which will amend the
     existing dictionary if appropriate */
    ret = updatewindow(strm, dictionary, dictLength, dictLength);
    if (ret) {
      state.mode = MEM;
      return Z_MEM_ERROR$1;
    }
    state.havedict = 1;
    // Tracev((stderr, "inflate:   dictionary set\n"));
    return Z_OK$1;
  };


  var inflateReset_1 = inflateReset;
  var inflateReset2_1 = inflateReset2;
  var inflateResetKeep_1 = inflateResetKeep;
  var inflateInit_1 = inflateInit;
  var inflateInit2_1 = inflateInit2;
  var inflate_2$1 = inflate$1;
  var inflateEnd_1 = inflateEnd;
  var inflateGetHeader_1 = inflateGetHeader;
  var inflateSetDictionary_1 = inflateSetDictionary;
  var inflateInfo = 'pako inflate (from Nodeca project)';

  /* Not implemented
  module.exports.inflateCodesUsed = inflateCodesUsed;
  module.exports.inflateCopy = inflateCopy;
  module.exports.inflateGetDictionary = inflateGetDictionary;
  module.exports.inflateMark = inflateMark;
  module.exports.inflatePrime = inflatePrime;
  module.exports.inflateSync = inflateSync;
  module.exports.inflateSyncPoint = inflateSyncPoint;
  module.exports.inflateUndermine = inflateUndermine;
  module.exports.inflateValidate = inflateValidate;
  */

  var inflate_1$1 = {
  	inflateReset: inflateReset_1,
  	inflateReset2: inflateReset2_1,
  	inflateResetKeep: inflateResetKeep_1,
  	inflateInit: inflateInit_1,
  	inflateInit2: inflateInit2_1,
  	inflate: inflate_2$1,
  	inflateEnd: inflateEnd_1,
  	inflateGetHeader: inflateGetHeader_1,
  	inflateSetDictionary: inflateSetDictionary_1,
  	inflateInfo: inflateInfo
  };

  const _has = (obj, key) => {
    return Object.prototype.hasOwnProperty.call(obj, key);
  };

  var assign = function (obj /*from1, from2, from3, ...*/) {
    const sources = Array.prototype.slice.call(arguments, 1);
    while (sources.length) {
      const source = sources.shift();
      if (!source) { continue; }

      if (typeof source !== 'object') {
        throw new TypeError(source + 'must be non-object');
      }

      for (const p in source) {
        if (_has(source, p)) {
          obj[p] = source[p];
        }
      }
    }

    return obj;
  };


  // Join array of chunks to single array.
  var flattenChunks = (chunks) => {
    // calculate data length
    let len = 0;

    for (let i = 0, l = chunks.length; i < l; i++) {
      len += chunks[i].length;
    }

    // join chunks
    const result = new Uint8Array(len);

    for (let i = 0, pos = 0, l = chunks.length; i < l; i++) {
      let chunk = chunks[i];
      result.set(chunk, pos);
      pos += chunk.length;
    }

    return result;
  };

  var common = {
  	assign: assign,
  	flattenChunks: flattenChunks
  };

  // String encode/decode helpers


  // Quick check if we can use fast array to bin string conversion
  //
  // - apply(Array) can fail on Android 2.2
  // - apply(Uint8Array) can fail on iOS 5.1 Safari
  //
  let STR_APPLY_UIA_OK = true;

  try { String.fromCharCode.apply(null, new Uint8Array(1)); } catch (__) { STR_APPLY_UIA_OK = false; }


  // Table with utf8 lengths (calculated by first byte of sequence)
  // Note, that 5 & 6-byte values and some 4-byte values can not be represented in JS,
  // because max possible codepoint is 0x10ffff
  const _utf8len = new Uint8Array(256);
  for (let q = 0; q < 256; q++) {
    _utf8len[q] = (q >= 252 ? 6 : q >= 248 ? 5 : q >= 240 ? 4 : q >= 224 ? 3 : q >= 192 ? 2 : 1);
  }
  _utf8len[254] = _utf8len[254] = 1; // Invalid sequence start


  // convert string to array (typed, when possible)
  var string2buf = (str) => {
    if (typeof TextEncoder === 'function' && TextEncoder.prototype.encode) {
      return new TextEncoder().encode(str);
    }

    let buf, c, c2, m_pos, i, str_len = str.length, buf_len = 0;

    // count binary size
    for (m_pos = 0; m_pos < str_len; m_pos++) {
      c = str.charCodeAt(m_pos);
      if ((c & 0xfc00) === 0xd800 && (m_pos + 1 < str_len)) {
        c2 = str.charCodeAt(m_pos + 1);
        if ((c2 & 0xfc00) === 0xdc00) {
          c = 0x10000 + ((c - 0xd800) << 10) + (c2 - 0xdc00);
          m_pos++;
        }
      }
      buf_len += c < 0x80 ? 1 : c < 0x800 ? 2 : c < 0x10000 ? 3 : 4;
    }

    // allocate buffer
    buf = new Uint8Array(buf_len);

    // convert
    for (i = 0, m_pos = 0; i < buf_len; m_pos++) {
      c = str.charCodeAt(m_pos);
      if ((c & 0xfc00) === 0xd800 && (m_pos + 1 < str_len)) {
        c2 = str.charCodeAt(m_pos + 1);
        if ((c2 & 0xfc00) === 0xdc00) {
          c = 0x10000 + ((c - 0xd800) << 10) + (c2 - 0xdc00);
          m_pos++;
        }
      }
      if (c < 0x80) {
        /* one byte */
        buf[i++] = c;
      } else if (c < 0x800) {
        /* two bytes */
        buf[i++] = 0xC0 | (c >>> 6);
        buf[i++] = 0x80 | (c & 0x3f);
      } else if (c < 0x10000) {
        /* three bytes */
        buf[i++] = 0xE0 | (c >>> 12);
        buf[i++] = 0x80 | (c >>> 6 & 0x3f);
        buf[i++] = 0x80 | (c & 0x3f);
      } else {
        /* four bytes */
        buf[i++] = 0xf0 | (c >>> 18);
        buf[i++] = 0x80 | (c >>> 12 & 0x3f);
        buf[i++] = 0x80 | (c >>> 6 & 0x3f);
        buf[i++] = 0x80 | (c & 0x3f);
      }
    }

    return buf;
  };

  // Helper
  const buf2binstring = (buf, len) => {
    // On Chrome, the arguments in a function call that are allowed is `65534`.
    // If the length of the buffer is smaller than that, we can use this optimization,
    // otherwise we will take a slower path.
    if (len < 65534) {
      if (buf.subarray && STR_APPLY_UIA_OK) {
        return String.fromCharCode.apply(null, buf.length === len ? buf : buf.subarray(0, len));
      }
    }

    let result = '';
    for (let i = 0; i < len; i++) {
      result += String.fromCharCode(buf[i]);
    }
    return result;
  };


  // convert array to string
  var buf2string = (buf, max) => {
    const len = max || buf.length;

    if (typeof TextDecoder === 'function' && TextDecoder.prototype.decode) {
      return new TextDecoder().decode(buf.subarray(0, max));
    }

    let i, out;

    // Reserve max possible length (2 words per char)
    // NB: by unknown reasons, Array is significantly faster for
    //     String.fromCharCode.apply than Uint16Array.
    const utf16buf = new Array(len * 2);

    for (out = 0, i = 0; i < len;) {
      let c = buf[i++];
      // quick process ascii
      if (c < 0x80) { utf16buf[out++] = c; continue; }

      let c_len = _utf8len[c];
      // skip 5 & 6 byte codes
      if (c_len > 4) { utf16buf[out++] = 0xfffd; i += c_len - 1; continue; }

      // apply mask on first byte
      c &= c_len === 2 ? 0x1f : c_len === 3 ? 0x0f : 0x07;
      // join the rest
      while (c_len > 1 && i < len) {
        c = (c << 6) | (buf[i++] & 0x3f);
        c_len--;
      }

      // terminated by end of string?
      if (c_len > 1) { utf16buf[out++] = 0xfffd; continue; }

      if (c < 0x10000) {
        utf16buf[out++] = c;
      } else {
        c -= 0x10000;
        utf16buf[out++] = 0xd800 | ((c >> 10) & 0x3ff);
        utf16buf[out++] = 0xdc00 | (c & 0x3ff);
      }
    }

    return buf2binstring(utf16buf, out);
  };


  // Calculate max possible position in utf8 buffer,
  // that will not break sequence. If that's not possible
  // - (very small limits) return max size as is.
  //
  // buf[] - utf8 bytes array
  // max   - length limit (mandatory);
  var utf8border = (buf, max) => {

    max = max || buf.length;
    if (max > buf.length) { max = buf.length; }

    // go back from last position, until start of sequence found
    let pos = max - 1;
    while (pos >= 0 && (buf[pos] & 0xC0) === 0x80) { pos--; }

    // Very small and broken sequence,
    // return max, because we should return something anyway.
    if (pos < 0) { return max; }

    // If we came to start of buffer - that means buffer is too small,
    // return max too.
    if (pos === 0) { return max; }

    return (pos + _utf8len[buf[pos]] > max) ? pos : max;
  };

  var strings = {
  	string2buf: string2buf,
  	buf2string: buf2string,
  	utf8border: utf8border
  };

  // (C) 1995-2013 Jean-loup Gailly and Mark Adler
  // (C) 2014-2017 Vitaly Puzrin and Andrey Tupitsin
  //
  // This software is provided 'as-is', without any express or implied
  // warranty. In no event will the authors be held liable for any damages
  // arising from the use of this software.
  //
  // Permission is granted to anyone to use this software for any purpose,
  // including commercial applications, and to alter it and redistribute it
  // freely, subject to the following restrictions:
  //
  // 1. The origin of this software must not be misrepresented; you must not
  //   claim that you wrote the original software. If you use this software
  //   in a product, an acknowledgment in the product documentation would be
  //   appreciated but is not required.
  // 2. Altered source versions must be plainly marked as such, and must not be
  //   misrepresented as being the original software.
  // 3. This notice may not be removed or altered from any source distribution.

  var messages = {
    2:      'need dictionary',     /* Z_NEED_DICT       2  */
    1:      'stream end',          /* Z_STREAM_END      1  */
    0:      '',                    /* Z_OK              0  */
    '-1':   'file error',          /* Z_ERRNO         (-1) */
    '-2':   'stream error',        /* Z_STREAM_ERROR  (-2) */
    '-3':   'data error',          /* Z_DATA_ERROR    (-3) */
    '-4':   'insufficient memory', /* Z_MEM_ERROR     (-4) */
    '-5':   'buffer error',        /* Z_BUF_ERROR     (-5) */
    '-6':   'incompatible version' /* Z_VERSION_ERROR (-6) */
  };

  // (C) 1995-2013 Jean-loup Gailly and Mark Adler
  // (C) 2014-2017 Vitaly Puzrin and Andrey Tupitsin
  //
  // This software is provided 'as-is', without any express or implied
  // warranty. In no event will the authors be held liable for any damages
  // arising from the use of this software.
  //
  // Permission is granted to anyone to use this software for any purpose,
  // including commercial applications, and to alter it and redistribute it
  // freely, subject to the following restrictions:
  //
  // 1. The origin of this software must not be misrepresented; you must not
  //   claim that you wrote the original software. If you use this software
  //   in a product, an acknowledgment in the product documentation would be
  //   appreciated but is not required.
  // 2. Altered source versions must be plainly marked as such, and must not be
  //   misrepresented as being the original software.
  // 3. This notice may not be removed or altered from any source distribution.

  function ZStream() {
    /* next input byte */
    this.input = null; // JS specific, because we have no pointers
    this.next_in = 0;
    /* number of bytes available at input */
    this.avail_in = 0;
    /* total number of input bytes read so far */
    this.total_in = 0;
    /* next output byte should be put there */
    this.output = null; // JS specific, because we have no pointers
    this.next_out = 0;
    /* remaining free space at output */
    this.avail_out = 0;
    /* total number of bytes output so far */
    this.total_out = 0;
    /* last error message, NULL if no error */
    this.msg = ''/*Z_NULL*/;
    /* not visible by applications */
    this.state = null;
    /* best guess about the data type: binary or text */
    this.data_type = 2/*Z_UNKNOWN*/;
    /* adler32 value of the uncompressed data */
    this.adler = 0;
  }

  var zstream = ZStream;

  // (C) 1995-2013 Jean-loup Gailly and Mark Adler
  // (C) 2014-2017 Vitaly Puzrin and Andrey Tupitsin
  //
  // This software is provided 'as-is', without any express or implied
  // warranty. In no event will the authors be held liable for any damages
  // arising from the use of this software.
  //
  // Permission is granted to anyone to use this software for any purpose,
  // including commercial applications, and to alter it and redistribute it
  // freely, subject to the following restrictions:
  //
  // 1. The origin of this software must not be misrepresented; you must not
  //   claim that you wrote the original software. If you use this software
  //   in a product, an acknowledgment in the product documentation would be
  //   appreciated but is not required.
  // 2. Altered source versions must be plainly marked as such, and must not be
  //   misrepresented as being the original software.
  // 3. This notice may not be removed or altered from any source distribution.

  function GZheader() {
    /* true if compressed data believed to be text */
    this.text       = 0;
    /* modification time */
    this.time       = 0;
    /* extra flags (not used when writing a gzip file) */
    this.xflags     = 0;
    /* operating system */
    this.os         = 0;
    /* pointer to extra field or Z_NULL if none */
    this.extra      = null;
    /* extra field length (valid if extra != Z_NULL) */
    this.extra_len  = 0; // Actually, we don't need it in JS,
                         // but leave for few code modifications

    //
    // Setup limits is not necessary because in js we should not preallocate memory
    // for inflate use constant limit in 65536 bytes
    //

    /* space at extra (only when reading header) */
    // this.extra_max  = 0;
    /* pointer to zero-terminated file name or Z_NULL */
    this.name       = '';
    /* space at name (only when reading header) */
    // this.name_max   = 0;
    /* pointer to zero-terminated comment or Z_NULL */
    this.comment    = '';
    /* space at comment (only when reading header) */
    // this.comm_max   = 0;
    /* true if there was or will be a header crc */
    this.hcrc       = 0;
    /* true when done reading gzip header (not used when writing a gzip file) */
    this.done       = false;
  }

  var gzheader = GZheader;

  const toString = Object.prototype.toString;

  /* Public constants ==========================================================*/
  /* ===========================================================================*/

  const {
    Z_NO_FLUSH, Z_FINISH,
    Z_OK, Z_STREAM_END, Z_NEED_DICT, Z_STREAM_ERROR, Z_DATA_ERROR, Z_MEM_ERROR
  } = constants$1;

  /* ===========================================================================*/


  /**
   * class Inflate
   *
   * Generic JS-style wrapper for zlib calls. If you don't need
   * streaming behaviour - use more simple functions: [[inflate]]
   * and [[inflateRaw]].
   **/

  /* internal
   * inflate.chunks -> Array
   *
   * Chunks of output data, if [[Inflate#onData]] not overridden.
   **/

  /**
   * Inflate.result -> Uint8Array|String
   *
   * Uncompressed result, generated by default [[Inflate#onData]]
   * and [[Inflate#onEnd]] handlers. Filled after you push last chunk
   * (call [[Inflate#push]] with `Z_FINISH` / `true` param).
   **/

  /**
   * Inflate.err -> Number
   *
   * Error code after inflate finished. 0 (Z_OK) on success.
   * Should be checked if broken data possible.
   **/

  /**
   * Inflate.msg -> String
   *
   * Error message, if [[Inflate.err]] != 0
   **/


  /**
   * new Inflate(options)
   * - options (Object): zlib inflate options.
   *
   * Creates new inflator instance with specified params. Throws exception
   * on bad params. Supported options:
   *
   * - `windowBits`
   * - `dictionary`
   *
   * [http://zlib.net/manual.html#Advanced](http://zlib.net/manual.html#Advanced)
   * for more information on these.
   *
   * Additional options, for internal needs:
   *
   * - `chunkSize` - size of generated data chunks (16K by default)
   * - `raw` (Boolean) - do raw inflate
   * - `to` (String) - if equal to 'string', then result will be converted
   *   from utf8 to utf16 (javascript) string. When string output requested,
   *   chunk length can differ from `chunkSize`, depending on content.
   *
   * By default, when no options set, autodetect deflate/gzip data format via
   * wrapper header.
   *
   * ##### Example:
   *
   * ```javascript
   * const pako = require('pako')
   * const chunk1 = new Uint8Array([1,2,3,4,5,6,7,8,9])
   * const chunk2 = new Uint8Array([10,11,12,13,14,15,16,17,18,19]);
   *
   * const inflate = new pako.Inflate({ level: 3});
   *
   * inflate.push(chunk1, false);
   * inflate.push(chunk2, true);  // true -> last chunk
   *
   * if (inflate.err) { throw new Error(inflate.err); }
   *
   * console.log(inflate.result);
   * ```
   **/
  function Inflate(options) {
    this.options = common.assign({
      chunkSize: 1024 * 64,
      windowBits: 15,
      to: ''
    }, options || {});

    const opt = this.options;

    // Force window size for `raw` data, if not set directly,
    // because we have no header for autodetect.
    if (opt.raw && (opt.windowBits >= 0) && (opt.windowBits < 16)) {
      opt.windowBits = -opt.windowBits;
      if (opt.windowBits === 0) { opt.windowBits = -15; }
    }

    // If `windowBits` not defined (and mode not raw) - set autodetect flag for gzip/deflate
    if ((opt.windowBits >= 0) && (opt.windowBits < 16) &&
        !(options && options.windowBits)) {
      opt.windowBits += 32;
    }

    // Gzip header has no info about windows size, we can do autodetect only
    // for deflate. So, if window size not set, force it to max when gzip possible
    if ((opt.windowBits > 15) && (opt.windowBits < 48)) {
      // bit 3 (16) -> gzipped data
      // bit 4 (32) -> autodetect gzip/deflate
      if ((opt.windowBits & 15) === 0) {
        opt.windowBits |= 15;
      }
    }

    this.err    = 0;      // error code, if happens (0 = Z_OK)
    this.msg    = '';     // error message
    this.ended  = false;  // used to avoid multiple onEnd() calls
    this.chunks = [];     // chunks of compressed data

    this.strm   = new zstream();
    this.strm.avail_out = 0;

    let status  = inflate_1$1.inflateInit2(
      this.strm,
      opt.windowBits
    );

    if (status !== Z_OK) {
      throw new Error(messages[status]);
    }

    this.header = new gzheader();

    inflate_1$1.inflateGetHeader(this.strm, this.header);

    // Setup dictionary
    if (opt.dictionary) {
      // Convert data if needed
      if (typeof opt.dictionary === 'string') {
        opt.dictionary = strings.string2buf(opt.dictionary);
      } else if (toString.call(opt.dictionary) === '[object ArrayBuffer]') {
        opt.dictionary = new Uint8Array(opt.dictionary);
      }
      if (opt.raw) { //In raw mode we need to set the dictionary early
        status = inflate_1$1.inflateSetDictionary(this.strm, opt.dictionary);
        if (status !== Z_OK) {
          throw new Error(messages[status]);
        }
      }
    }
  }

  /**
   * Inflate#push(data[, flush_mode]) -> Boolean
   * - data (Uint8Array|ArrayBuffer): input data
   * - flush_mode (Number|Boolean): 0..6 for corresponding Z_NO_FLUSH..Z_TREE
   *   flush modes. See constants. Skipped or `false` means Z_NO_FLUSH,
   *   `true` means Z_FINISH.
   *
   * Sends input data to inflate pipe, generating [[Inflate#onData]] calls with
   * new output chunks. Returns `true` on success. If end of stream detected,
   * [[Inflate#onEnd]] will be called.
   *
   * `flush_mode` is not needed for normal operation, because end of stream
   * detected automatically. You may try to use it for advanced things, but
   * this functionality was not tested.
   *
   * On fail call [[Inflate#onEnd]] with error code and return false.
   *
   * ##### Example
   *
   * ```javascript
   * push(chunk, false); // push one of data chunks
   * ...
   * push(chunk, true);  // push last chunk
   * ```
   **/
  Inflate.prototype.push = function (data, flush_mode) {
    const strm = this.strm;
    const chunkSize = this.options.chunkSize;
    const dictionary = this.options.dictionary;
    let status, _flush_mode, last_avail_out;

    if (this.ended) return false;

    if (flush_mode === ~~flush_mode) _flush_mode = flush_mode;
    else _flush_mode = flush_mode === true ? Z_FINISH : Z_NO_FLUSH;

    // Convert data if needed
    if (toString.call(data) === '[object ArrayBuffer]') {
      strm.input = new Uint8Array(data);
    } else {
      strm.input = data;
    }

    strm.next_in = 0;
    strm.avail_in = strm.input.length;

    for (;;) {
      if (strm.avail_out === 0) {
        strm.output = new Uint8Array(chunkSize);
        strm.next_out = 0;
        strm.avail_out = chunkSize;
      }

      status = inflate_1$1.inflate(strm, _flush_mode);

      if (status === Z_NEED_DICT && dictionary) {
        status = inflate_1$1.inflateSetDictionary(strm, dictionary);

        if (status === Z_OK) {
          status = inflate_1$1.inflate(strm, _flush_mode);
        } else if (status === Z_DATA_ERROR) {
          // Replace code with more verbose
          status = Z_NEED_DICT;
        }
      }

      // Skip snyc markers if more data follows and not raw mode
      while (strm.avail_in > 0 &&
             status === Z_STREAM_END &&
             strm.state.wrap > 0 &&
             data[strm.next_in] !== 0)
      {
        inflate_1$1.inflateReset(strm);
        status = inflate_1$1.inflate(strm, _flush_mode);
      }

      switch (status) {
        case Z_STREAM_ERROR:
        case Z_DATA_ERROR:
        case Z_NEED_DICT:
        case Z_MEM_ERROR:
          this.onEnd(status);
          this.ended = true;
          return false;
      }

      // Remember real `avail_out` value, because we may patch out buffer content
      // to align utf8 strings boundaries.
      last_avail_out = strm.avail_out;

      if (strm.next_out) {
        if (strm.avail_out === 0 || status === Z_STREAM_END) {

          if (this.options.to === 'string') {

            let next_out_utf8 = strings.utf8border(strm.output, strm.next_out);

            let tail = strm.next_out - next_out_utf8;
            let utf8str = strings.buf2string(strm.output, next_out_utf8);

            // move tail & realign counters
            strm.next_out = tail;
            strm.avail_out = chunkSize - tail;
            if (tail) strm.output.set(strm.output.subarray(next_out_utf8, next_out_utf8 + tail), 0);

            this.onData(utf8str);

          } else {
            this.onData(strm.output.length === strm.next_out ? strm.output : strm.output.subarray(0, strm.next_out));
          }
        }
      }

      // Must repeat iteration if out buffer is full
      if (status === Z_OK && last_avail_out === 0) continue;

      // Finalize if end of stream reached.
      if (status === Z_STREAM_END) {
        status = inflate_1$1.inflateEnd(this.strm);
        this.onEnd(status);
        this.ended = true;
        return true;
      }

      if (strm.avail_in === 0) break;
    }

    return true;
  };


  /**
   * Inflate#onData(chunk) -> Void
   * - chunk (Uint8Array|String): output data. When string output requested,
   *   each chunk will be string.
   *
   * By default, stores data blocks in `chunks[]` property and glue
   * those in `onEnd`. Override this handler, if you need another behaviour.
   **/
  Inflate.prototype.onData = function (chunk) {
    this.chunks.push(chunk);
  };


  /**
   * Inflate#onEnd(status) -> Void
   * - status (Number): inflate status. 0 (Z_OK) on success,
   *   other if not.
   *
   * Called either after you tell inflate that the input stream is
   * complete (Z_FINISH). By default - join collected chunks,
   * free memory and fill `results` / `err` properties.
   **/
  Inflate.prototype.onEnd = function (status) {
    // On success - join
    if (status === Z_OK) {
      if (this.options.to === 'string') {
        this.result = this.chunks.join('');
      } else {
        this.result = common.flattenChunks(this.chunks);
      }
    }
    this.chunks = [];
    this.err = status;
    this.msg = this.strm.msg;
  };


  /**
   * inflate(data[, options]) -> Uint8Array|String
   * - data (Uint8Array|ArrayBuffer): input data to decompress.
   * - options (Object): zlib inflate options.
   *
   * Decompress `data` with inflate/ungzip and `options`. Autodetect
   * format via wrapper header by default. That's why we don't provide
   * separate `ungzip` method.
   *
   * Supported options are:
   *
   * - windowBits
   *
   * [http://zlib.net/manual.html#Advanced](http://zlib.net/manual.html#Advanced)
   * for more information.
   *
   * Sugar (options):
   *
   * - `raw` (Boolean) - say that we work with raw stream, if you don't wish to specify
   *   negative windowBits implicitly.
   * - `to` (String) - if equal to 'string', then result will be converted
   *   from utf8 to utf16 (javascript) string. When string output requested,
   *   chunk length can differ from `chunkSize`, depending on content.
   *
   *
   * ##### Example:
   *
   * ```javascript
   * const pako = require('pako');
   * const input = pako.deflate(new Uint8Array([1,2,3,4,5,6,7,8,9]));
   * let output;
   *
   * try {
   *   output = pako.inflate(input);
   * } catch (err) {
   *   console.log(err);
   * }
   * ```
   **/
  function inflate(input, options) {
    const inflator = new Inflate(options);

    inflator.push(input);

    // That will never happens, if you don't cheat with options :)
    if (inflator.err) throw inflator.msg || messages[inflator.err];

    return inflator.result;
  }


  /**
   * inflateRaw(data[, options]) -> Uint8Array|String
   * - data (Uint8Array|ArrayBuffer): input data to decompress.
   * - options (Object): zlib inflate options.
   *
   * The same as [[inflate]], but creates raw data, without wrapper
   * (header and adler32 crc).
   **/
  function inflateRaw(input, options) {
    options = options || {};
    options.raw = true;
    return inflate(input, options);
  }


  /**
   * ungzip(data[, options]) -> Uint8Array|String
   * - data (Uint8Array|ArrayBuffer): input data to decompress.
   * - options (Object): zlib inflate options.
   *
   * Just shortcut to [[inflate]], because it autodetects format
   * by header.content. Done for convenience.
   **/


  var Inflate_1 = Inflate;
  var inflate_2 = inflate;
  var inflateRaw_1 = inflateRaw;
  var ungzip = inflate;
  var constants = constants$1;

  var inflate_1 = {
  	Inflate: Inflate_1,
  	inflate: inflate_2,
  	inflateRaw: inflateRaw_1,
  	ungzip: ungzip,
  	constants: constants
  };

  exports.Inflate = Inflate_1;
  exports.constants = constants;
  exports["default"] = inflate_1;
  exports.inflate = inflate_2;
  exports.inflateRaw = inflateRaw_1;
  exports.ungzip = ungzip;

  Object.defineProperty(exports, '__esModule', { value: true });

}));


/***/ },

/***/ 9919
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _x_ite_Namespace_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(8427);
const Algorithm =
{
   radians (value)
   {
      // Convert degrees to radians.
      return value * (Math .PI / 180);
   },
   degrees (value)
   {
      // Convert radians to degrees.
      return value * (180 / Math .PI);
   },
   random (min, max)
   {
      return min + Math .random () * (max - min);
   },
   fract (value)
   {
      return value % 1;
   },
   clamp (value, min, max)
   {
      // https://registry.khronos.org/OpenGL-Refpages/gl4/html/clamp.xhtml
      return Math .min (Math .max (value, min), max);
   },
   interval (value, low, high)
   {
      if (value >= high)
         return ((value - low) % (high - low)) + low;

      if (value < low)
         return ((value - high) % (high - low)) + high;

      return value;
   },
   project (value, fromLow, fromHigh, toLow, toHigh)
   {
      return toLow + ((value - fromLow) / (fromHigh - fromLow)) * (toHigh - toLow);
   },
   roundToMultiple (value, multiple)
   {
      return Math .ceil (value / multiple) * multiple;
   },
   lerp (source, destination, t)
   {
      return source + t * (destination - source);
   },
   slerp (source, destination, t, short = true)
   {
      let cosom = source .dot (destination);

      // if (cosom <= -1) ... vectors are inverse colinear.
      // ; // This case is not handled.

      if (short && cosom < 0)
      {
         // Reverse signs so we travel the short way round.
         cosom = -cosom;
         destination .negate ();
      }

      if (cosom >= 1) // Both normal vectors are equal.
         return source;

      const
         omega  = Math .acos (cosom),
         sinom  = Math .sin  (omega),
         scale0 = Math .sin ((1 - t) * omega) / sinom,
         scale1 = Math .sin (t * omega) / sinom;

      source .x = source .x * scale0 + destination .x * scale1;
      source .y = source .y * scale0 + destination .y * scale1;
      source .z = source .z * scale0 + destination .z * scale1;
      source .w = source .w * scale0 + destination .w * scale1;

      return source;
   },
   simpleSlerp (source, destination, t)
   {
      return this .slerp (source, destination, t, false);
   },
   isPowerOfTwo (n)
   {
      return ((n - 1) & n) === 0;
   },
   nextPowerOfTwo (n)
   {
      ///  Returns the next power of two of @a n. If n is a power of two, n is returned.

      if (Algorithm .isPowerOfTwo (n))
         return n;

      return 1 << (32 - Math .clz32 (n));
   },
   bitCount (n)
   {
      n = n - ((n >>> 1) & 0x55555555);
      n = (n & 0x33333333) + ((n >>> 2) & 0x33333333);
      return ((n + (n >>> 4) & 0xF0F0F0F) * 0x1010101) >>> 24;
   },
   cmp (lhs, rhs)
   {
      return lhs > rhs ? 1 : lhs < rhs ? -1 : 0;
   },
   less (lhs, rhs)
   {
      return lhs < rhs;
   },
   greater (lhs, rhs)
   {
      return lhs > rhs;
   },
   lowerBound (array, first, last, value, comp = Algorithm.less)
   {
      // https://en.cppreference.com/w/cpp/algorithm/lower_bound

      let
         index = 0,
         step  = 0,
         count = last - first;

      while (count > 0)
      {
         step  = count >>> 1;
         index = first + step;

         if (comp (array [index], value))
         {
            first  = ++ index;
            count -= step + 1;
         }
         else
         {
            count = step;
         }
      }

      return first;
   },
   upperBound (array, first, last, value, comp = Algorithm.less)
   {
      // https://en.cppreference.com/w/cpp/algorithm/upper_bound

      let
         index = 0,
         step  = 0,
         count = last - first;

      while (count > 0)
      {
         step  = count >>> 1;
         index = first + step;

         if (comp (value, array [index]))
         {
            count = step;
         }
         else
         {
            first  = ++ index;
            count -= step + 1;
         }
      }

      return first;
   },
};

const __default__ = Algorithm;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_x_ite_Namespace_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .add ("Algorithm", __default__));

/***/ },

/***/ 7977
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _x_ite_Namespace_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(8427);
const
   extents1 = { min: 0, max: 0 },
   extents2 = { min: 0, max: 0 };

/**
 *  Class to represent the Separating Axis Theorem.
 */
function SAT () { }

SAT .isSeparated = function (axes, points1, points2)
{
   // https://gamedev.stackexchange.com/questions/25397/obb-vs-obb-collision-detection

   for (const axis of axes)
   {
      project (points1, axis, extents1);
      project (points2, axis, extents2);

      if (overlaps (extents1 .min, extents1 .max, extents2 .min, extents2 .max))
         continue;

      return true;
   }

   return false;
};

///  Projects @a points to @a axis and returns the minimum and maximum bounds.
function project (points, axis, extents)
{
   extents .min = Number .POSITIVE_INFINITY;
   extents .max = Number .NEGATIVE_INFINITY;

   for (const point of points)
   {
      // Just dot it to get the min and max along this axis.
      // NOTE: the axis must be normalized to get accurate projections to calculate the MTV, but if it is only needed to
      // know whether it overlaps, every axis can be used.

      const dotVal = point .dot (axis);

      if (dotVal < extents .min)
         extents .min = dotVal;

      if (dotVal > extents .max)
         extents .max = dotVal;
   }
}

///  Returns true if both ranges overlap, otherwise false.
function overlaps (min1, max1, min2, max2)
{
   return is_between (min2, min1, max1) || is_between (min1, min2, max2);
}

///  Returns true if @a value is between @a lowerBound and @a upperBound, otherwise false.
function is_between (value, lowerBound, upperBound)
{
   return lowerBound <= value && value <= upperBound;
}

const __default__ = SAT;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_x_ite_Namespace_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .add ("SAT", __default__));

/***/ },

/***/ 2973
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _x_ite_Namespace_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(8427);
const a = [ ]; // more scratch
const b = [ ]; // more scratch
const z = [ ]; // more scratch

// Calculate eigenvalues and eigenvectors.
// This is from SGI Inventor Matrix.cpp.
function eigen_decomposition (matrix, result)
{
   const
      ORDER   = matrix .order,
      SIZE    = matrix .length,
      values  = result .values,
      vectors = result .vectors;

   let
      sm,         // smallest entry
      theta,      // angle for Jacobi rotation
      c, s, t,    // cosine, sine, tangent of theta
      tau,        // sine / (1 + cos)
      h, g,       // two scrap values
      thresh,     // threshold below which no rotation done
      p, q, i, j; // indices

   // initializations
   for (i = 0; i < ORDER; ++ i)
   {
      a [i] = a [i] ?? [ ];
      b [i] = values [i] = matrix .get1 (i, i);
      z [i] = 0;

      for (j = 0; j < ORDER; ++ j)
      {
         vectors [i] [j] = (i === j) ? 1 : 0;
         a [i] [j] = matrix .get1 (j, i);
      }
   }

   // Why 50? I don't know--it's the way the folks who wrote the
   // algorithm did it:
   for (i = 0; i < 50; ++ i)
   {
      sm = 0;

      for (p = 0; p < ORDER - 1; ++ p)
      {
         for (q = p + 1; q < ORDER; ++ q)
            sm += Math .abs (a [p] [q]);
      }

      if (sm === 0)
         break;

      thresh = i < 3 ?
         0.2 * sm / SIZE :
         0;

      for (p = 0; p < ORDER - 1; ++ p)
      {
         for (q = p + 1; q < ORDER; ++ q)
         {
            g = 100 * Math .abs (a [p] [q]);

            if (i > 3
                && (Math .abs (values [p]) + g === Math .abs (values [p]))
                && (Math .abs (values [q]) + g === Math .abs (values [q]))
            )
            {
               a [p] [q] = 0;
            }

            else if (Math .abs (a [p] [q]) > thresh)
            {
               h = values [q] - values [p];

               if (Math .abs (h) + g === Math .abs (h))
               {
                  t = a [p] [q] / h;
               }
               else
               {
                  theta = 0.5 * h / a [p] [q];
                  t     = 1 / (Math .abs (theta) + Math .sqrt (1 + theta * theta));

                  if (theta < 0)  t = -t;
               }
               // End of computing tangent of rotation angle

               c           = 1 / Math .sqrt (1 + t * t);
               s           = t * c;
               tau         = s / (1 + c);
               h           = t * a [p] [q];
               z [p]      -= h;
               z [q]      += h;
               values [p] -= h;
               values [q] += h;
               a [p] [q]   = 0;

               for (j = 0; j < p; ++ j)
               {
                  g = a [j] [p];
                  h = a [j] [q];
                  a [j] [p] = g - s * (h + g * tau);
                  a [j] [q] = h + s * (g - h * tau);
               }

               for (j = p + 1; j < q; ++ j)
               {
                  g = a [p] [j];
                  h = a [j] [q];
                  a [p] [j] = g - s * (h + g * tau);
                  a [j] [q] = h + s * (g - h * tau);
               }

               for (j = q + 1; j < ORDER; ++ j)
               {
                  g = a [p] [j];
                  h = a [q] [j];
                  a [p] [j] = g - s * (h + g * tau);
                  a [q] [j] = h + s * (g - h * tau);
               }

               for (j = 0; j < ORDER; ++ j)
               {
                  g = vectors [j] [p];
                  h = vectors [j] [q];
                  vectors [j] [p] = g - s * (h + g * tau);
                  vectors [j] [q] = h + s * (g - h * tau);
               }
            }
         }
      }

      for (p = 0; p < ORDER; ++ p)
      {
         values [p] = b [p] += z [p];
         z [p] = 0;
      }
   }

   return result;
}

const __default__ = eigen_decomposition;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_x_ite_Namespace_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .add ("eigen_decomposition", __default__));

/***/ },

/***/ 1789
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Numbers_Matrix4_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6776);
/* harmony import */ var _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(8655);
/* harmony import */ var _Algorithms_SAT_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(7977);
/* harmony import */ var _x_ite_Namespace_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(8427);




function Box3 (... args) /* size, center */
{
   this .matrix = new _Numbers_Matrix4_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A ();

   this .set (... arguments);
}

Object .assign (Box3 .prototype,
{
   copy ()
   {
      const copy = Object .create (Box3 .prototype);

      copy .matrix = this .matrix .copy ();

      return copy;
   },
   assign (box)
   {
      this .matrix .assign (box .matrix);

      return this;
   },
   equals (box)
   {
      return this .matrix .equals (box .matrix);
   },
   getMatrix ()
   {
      return this .matrix;
   },
   set (size, center)
   {
      switch (arguments .length)
      {
         case 0:
         {
            this .matrix .set (0, 0, 0, 0,
                               0, 0, 0, 0,
                               0, 0, 0, 0,
                               0, 0, 0, 0);

            return this;
         }
         case 2:
         {
            this .matrix .set (size .x / 2, 0, 0, 0,
                               0, size .y / 2, 0, 0,
                               0, 0, size .z / 2, 0,
                               center .x, center .y, center .z, 1);

            return this;
         }
         // case 3:
         // {
         //    console .trace ()
         //    return this .setExtents (arguments [0], arguments [1]);
         // }
      }
   },
   setExtents (min, max)
   {
      const
         sx = (max .x - min .x) / 2,
         sy = (max .y - min .y) / 2,
         sz = (max .z - min .z) / 2,
         cx = (max .x + min .x) / 2,
         cy = (max .y + min .y) / 2,
         cz = (max .z + min .z) / 2;

      this .matrix .set (sx, 0,  0,  0,
                         0,  sy, 0,  0,
                         0,  0,  sz, 0,
                         cx, cy, cz, 1);

      return this;
   },
   getExtents (min, max)
   {
      this .getAbsoluteExtents (min, max);

      min .add (this .center);
      max .add (this .center);
   },
   getAbsoluteExtents: (() =>
   {
      const
         r1 = new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (),
         p1 = new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (),
         p4 = new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A ();

      return function (min, max)
      {
         const
            m = this .matrix,
            x = m .xAxis,
            y = m .yAxis,
            z = m .zAxis;

         r1 .assign (y) .add (z);

         const r2 = z .subtract (y);

         p1 .assign (x) .add (r1),
         p4 .assign (x) .add (r2);

         const
            p2 = r1 .subtract (x),
            p3 = r2 .subtract (x);

         min .assign (p1) .min (p2, p3, p4);
         max .assign (p1) .max (p2, p3, p4);

         p1 .negate ();
         p2 .negate ();
         p3 .negate ();
         p4 .negate ();

         min .min (p1, p2, p3, p4);
         max .max (p1, p2, p3, p4);
      };
   })(),
   getPoints: (() =>
   {
      const
         x  = new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (),
         y  = new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (),
         z  = new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (),
         r1 = new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A ();

      return function (points)
      {
         /*
          * p6 ---------- p5
          * | \           | \
          * | p2------------ p1
          * |  |          |  |
          * |  |          |  |
          * p7 |_________ p8 |
          *  \ |           \ |
          *   \|            \|
          *    p3 ---------- p4
          */

         const m = this .matrix;

         x .assign (m .xAxis);
         y .assign (m .yAxis);
         z .assign (m .zAxis);

         r1 .assign (y) .add (z);

         const r2 = z .subtract (y);

         points [0] .assign (x)  .add (r1);
         points [1] .assign (r1) .subtract (x);
         points [2] .assign (r2) .subtract (x);
         points [3] .assign (x)  .add (r2);

         points [4] .assign (points [2]) .negate ();
         points [5] .assign (points [3]) .negate ();
         points [6] .assign (points [0]) .negate ();
         points [7] .assign (points [1]) .negate ();

         const center = this .center;

         points [0] .add (center);
         points [1] .add (center);
         points [2] .add (center);
         points [3] .add (center);

         points [4] .add (center);
         points [5] .add (center);
         points [6] .add (center);
         points [7] .add (center);

         return points;
      };
   })(),
   getAxes (axes)
   {
      const m = this .matrix;

      axes [0] .assign (m .xAxis);
      axes [1] .assign (m .yAxis);
      axes [2] .assign (m .zAxis);

      return axes;
   },
   getNormals: (() =>
   {
      const
         x = new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (),
         y = new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (),
         z = new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A ();

      const axes = [ _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .X_AXIS, _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .Y_AXIS, _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .Z_AXIS ];

      return function (normals)
      {
         const m = this .matrix;

         x .assign (m .xAxis);
         y .assign (m .yAxis);
         z .assign (m .zAxis);

         if (x .squaredNorm () === 0)
         {
            x .assign (y) .cross (z);

            if (x .squaredNorm () === 0)
            {
               for (const axis of axes)
               {
                  x .assign (axis) .cross (y);

                  if (x .squaredNorm () !== 0)
                     break;
               }

               if (x .squaredNorm () === 0)
               {
                  for (const axis of axes)
                  {
                     x .assign (axis) .cross (z);

                     if (x .squaredNorm () !== 0)
                        break;
                  }

                  if (x .squaredNorm () === 0)
                     x .assign (_Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .X_AXIS);
               }
            }
         }

         if (y .squaredNorm () === 0)
         {
            y .assign (z) .cross (x);

            if (y .squaredNorm () === 0)
            {
               for (const axis of axes)
               {
                  y .assign (axis) .cross (z);

                  if (y .squaredNorm () !== 0)
                     break;
               }

               if (y .squaredNorm () === 0)
               {
                  for (const axis of axes)
                  {
                     y .assign (axis) .cross (x);

                     if (y .squaredNorm () !== 0)
                        break;
                  }

                  if (y .squaredNorm () === 0)
                     y .assign (_Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .Y_AXIS);
               }
            }
         }

         if (z .squaredNorm () === 0)
         {
            z .assign (x) .cross (y);

            if (z .squaredNorm () === 0)
            {
               for (const axis of axes)
               {
                  z .assign (axis) .cross (x);

                  if (z .squaredNorm () !== 0)
                     break;
               }

               if (z .squaredNorm () === 0)
               {
                  for (const axis of axes)
                  {
                     z .assign (axis) .cross (y);

                     if (z .squaredNorm () !== 0)
                        break;
                  }

                  if (z .squaredNorm () === 0)
                     z .assign (_Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .Z_AXIS);
               }
            }
         }

         normals [0] .assign (y) .cross (z) .normalize ();
         normals [1] .assign (z) .cross (x) .normalize ();
         normals [2] .assign (x) .cross (y) .normalize ();

         return normals;
      };
   })(),
   isEmpty ()
   {
      return this .matrix [15] === 0;
   },
   add: (() =>
   {
      const
         lhs_min = new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (),
         lhs_max = new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (),
         rhs_min = new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (),
         rhs_max = new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A ();

      return function (box)
      {
         if (this .isEmpty ())
            return this .assign (box);

         if (box .isEmpty ())
            return this;

         this .getExtents (lhs_min, lhs_max);
         box  .getExtents (rhs_min, rhs_max);

         return this .setExtents (lhs_min .min (rhs_min), lhs_max .max (rhs_max));
      };
   })(),
   multLeft (matrix)
   {
      this .matrix .multLeft (matrix);
      return this;
   },
   multRight (matrix)
   {
      this .matrix .multRight (matrix);
      return this;
   },
   containsPoint: (() =>
   {
      const
         min = new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (),
         max = new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A ();

      return function (point)
      {
         this .getExtents (min, max);

         return min .x <= point .x &&
                max .x >= point .x &&
                min .y <= point .y &&
                max .y >= point .y &&
                min .z <= point .z &&
                max .z >= point .z;
      };
   })(),
   intersectsBox: (() =>
   {
      const
         points1 = Array .from ({ length: 8 }, () => new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A ()),
         points2 = Array .from ({ length: 8 }, () => new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A ()),
         axes1   = Array .from ({ length: 3 }, () => new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A ()),
         axes2   = Array .from ({ length: 3 }, () => new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A ()),
         axes9   = Array .from ({ length: 9 }, () => new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A ()),
         normals = Array .from ({ length: 3 }, () => new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A ());

      return function (other)
      {
         // Test special cases.

         if (this .isEmpty ())
            return false;

         if (other .isEmpty ())
            return false;

         // Get points.

         this  .getPoints (points1);
         other .getPoints (points2);

         // Test the three planes spanned by the normal vectors of the faces of the first parallelepiped.

         if (_Algorithms_SAT_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .isSeparated (this .getNormals (normals), points1, points2))
            return false;

         // Test the three planes spanned by the normal vectors of the faces of the second parallelepiped.

         if (_Algorithms_SAT_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .isSeparated (other .getNormals (normals), points1, points2))
            return false;

         // Test the nine other planes spanned by the edges of each parallelepiped.

         this  .getAxes (axes1);
         other .getAxes (axes2);

         for (let i1 = 0; i1 < 3; ++ i1)
         {
            for (let i2 = 0; i2 < 3; ++ i2)
               axes9 [i1 * 3 + i2] .assign (axes1 [i1]) .cross (axes2 [i2]);
         }

         if (_Algorithms_SAT_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .isSeparated (axes9, points1, points2))
            return false;

         // Both boxes intersect.

         return true;
      };
   })(),
   // import Triangle3 from "./Triangle3.js";
   // intersectsTriangle: (() =>
   // {
   //    const
   //       points1        = Array .from ({ length: 8 }, () => new Vector3 ()),
   //       axes1          = Array .from ({ length: 3 }, () => new Vector3 ()),
   //       axes9          = Array .from ({ length: 9 }, () => new Vector3 ()),
   //       normals        = Array .from ({ length: 3 }, () => new Vector3 ()),
   //       triangle       = [ ],
   //       triangleNormal = [ new Vector3 () ],
   //       triangleEdges  = Array .from ({ length: 3 }, () => new Vector3 ());

   //    return function (a, b, c)
   //    {
   //       // Test special cases.

   //       if (this .isEmpty ())
   //          return false;

   //       // Get points.

   //       this .getPoints (points1);

   //       triangle [0] = a;
   //       triangle [1] = b;
   //       triangle [2] = c;

   //       // Test the three planes spanned by the normal vectors of the faces of the first parallelepiped.

   //       if (SAT .isSeparated (this .getNormals (normals), points1, triangle))
   //          return false;

   //       // Test the normal of the triangle.

   //       Triangle3 .normal (a, b, c, triangleNormal [0]);

   //       if (SAT .isSeparated (triangleNormal, points1, triangle))
   //          return false;

   //       // Test the nine other planes spanned by the edges of each parallelepiped.

   //       this .getAxes (axes1);

   //       triangleEdges [0] .assign (a) .subtract (b);
   //       triangleEdges [1] .assign (b) .subtract (c);
   //       triangleEdges [2] .assign (c) .subtract (a);

   //       for (let i1 = 0; i1 < 3; ++ i1)
   //       {
   //          for (let i2 = 0; i2 < 3; ++ i2)
   //             axes9 [i1 * 3 + i2] .assign (axes1 [i1]) .cross (triangleEdges [i2]);
   //       }

   //       if (SAT .isSeparated (axes9, points1, triangle))
   //          return false;

   //       // Box and triangle intersect.

   //       return true;
   //    };
   // })(),
   toString ()
   {
      return `${this .size}, ${this .center}`;
   },
});

Object .assign (Box3,
{
   fromExtents (min, max)
   {
      return new Box3 () .setExtents (min, max);
   },
   fromPoints (points)
   {
      const
         min = new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (Number .POSITIVE_INFINITY),
         max = new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (Number .NEGATIVE_INFINITY);

      for (const point of points)
      {
         min .min (point);
         max .max (point);
      }

      return new Box3 () .setExtents (min, max);
   },
});

Object .defineProperties (Box3 .prototype,
{
   size:
   {
      get: (() =>
      {
         const
            min = new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (),
            max = new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A ();

         return function ()
         {
            this .getAbsoluteExtents (min, max);

            return max .subtract (min);
         };
      })(),
      enumerable: true,
   },
   center:
   {
      get ()
      {
         return this .matrix .origin;
      },
      enumerable: true,
   },
});

const __default__ = Box3;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_x_ite_Namespace_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .add ("Box3", __default__));

/***/ },

/***/ 7184
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(8655);
/* harmony import */ var _x_ite_Namespace_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(8427);


const Camera =
{
   frustum (l, r, b, t, n, f, matrix)
   {
      const
         r_l = r - l,
         t_b = t - b,
         f_n = f - n,
         n_2 = 2 * n,

         A = (r + l) / r_l,
         B = (t + b) / t_b,
         C = -(f + n) / f_n,
         D = -(n_2 * f) / f_n,
         E = n_2 / r_l,
         F = n_2 / t_b;

      return matrix .set (E, 0, 0, 0,
                          0, F, 0, 0,
                          A, B, C, -1,
                          0, 0, D, 0);
   },
   perspective (fieldOfView, zNear, zFar, width, height, matrix)
   {
      const ratio = Math .tan (fieldOfView / 2) * zNear;

      if (width > height)
      {
         const aspect = width * ratio / height;
         return this .frustum (-aspect, aspect, -ratio, ratio, zNear, zFar, matrix);
      }
      else
      {
         const aspect = height * ratio / width;
         return this .frustum (-ratio, ratio, -aspect, aspect, zNear, zFar, matrix);
      }
   },
   perspective2 (fieldOfView, zNear, zFar, width, height, matrix)
   {
      const ratio = Math .tan (fieldOfView / 2) * zNear;

      return this .frustum (-ratio, ratio, -ratio, ratio, zNear, zFar, matrix);
   },
   ortho (l, r, b, t, n, f, matrix)
   {
      const
         r_l = r - l,
         t_b = t - b,
         f_n = f - n,

         A =  2 / r_l,
         B =  2 / t_b,
         C = -2 / f_n,
         D = -(r + l) / r_l,
         E = -(t + b) / t_b,
         F = -(f + n) / f_n;

      return matrix .set (A, 0, 0, 0,
                          0, B, 0, 0,
                          0, 0, C, 0,
                          D, E, F, 1);
   },
   orthoBox: (() =>
   {
      const
         min = new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A (),
         max = new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A ();

      return function (box, matrix)
      {
         box .getExtents (min, max);

         return this .ortho (min .x, max .x, min .y, max .y, -max .z, -min .z, matrix);
      };
   })(),
};

const __default__ = Camera;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_x_ite_Namespace_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .add ("Camera", __default__));

/***/ },

/***/ 7972
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(8655);
/* harmony import */ var _x_ite_Namespace_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(8427);


function Line3 (point = _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .ZERO, direction = _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .Z_AXIS)
{
   this .point     = new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A ();
   this .direction = new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A ();

   this .set (point, direction);
}

Object .assign (Line3 .prototype,
{
   copy ()
   {
      const copy = Object .create (Line3 .prototype);

      copy .point     = this .point .copy ();
      copy .direction = this .direction .copy ();

      return copy;
   },
   assign (line)
   {
      this .point     .assign (line .point);
      this .direction .assign (line .direction);

      return this;
   },
   equals (line)
   {
      return this .point .equals (line .point) && this .direction .equals (line .direction);
   },
   set (point = _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .ZERO, direction = _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .Z_AXIS)
   {
      this .point     .assign (point);
      this .direction .assign (direction);
      return this;
   },
   setPoints (point1, point2)
   {
      this .point .assign (point1);
      this .direction .assign (point2) .subtract (point1) .normalize ();
      return this;
   },
   multMatrixLine (matrix)
   {
      matrix .multMatrixVec (this .point);
      matrix .multMatrixDir (this .direction) .normalize ();
      return this;
   },
   multLineMatrix (matrix)
   {
      matrix .multVecMatrix (this .point);
      matrix .multDirMatrix (this .direction) .normalize ();
      return this;
   },
   getClosestPointToPoint (point, result = new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A ())
   {
      const
         r = result .assign (point) .subtract (this .point),
         d = r .dot (this .direction);

      return result .assign (this .direction) .multiply (d) .add (this .point);
   },
   getClosestPointToLine: (() =>
   {
      const u = new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A ();

      return function (line, point)
      {
         const
            { point: p1, direction: d1 } = this,
            { point: p2, direction: d2 } = line;

         let t = d1 .dot (d2);

         if (Math .abs (t) >= 1)
            return false;  // lines are parallel

         u .assign (p2) .subtract (p1);

         t = (u .dot (d1) - t * u .dot (d2)) / (1 - t * t);

         point .assign (d1) .multiply (t) .add (p1);
         return true;
      };
   })(),
   getPerpendicularVectorToPoint: (() =>
   {
      const t = new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A ();

      return function (point, result = new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A ())
      {
         result .assign (this .point) .subtract (point);

         return result .subtract (t .assign (this .direction) .multiply (result .dot (this .direction)));
      };
   })(),
   getPerpendicularVectorToLine: (() =>
   {
      const
         diff   = new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A (),
         proj   = new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A (),
         d      = new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A (),
         point1 = new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A ();

      return function (line, result = new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A ())
      {
         const
            { point: p1, direction: d1 } = this,
            { point: p2, direction: d2 } = line;

         const t = d1 .dot (d2);

         if (Math .abs (t) >= 1)
         {
            // Lines are parallel

            diff .assign (p2) .subtract (p1);
            proj .assign (d1) .multiply (diff .dot (d1) / d1 .dot (d1));

            return proj .subtract (diff);
         }

         d .assign (p1) .subtract (p2);

         const
            re1 = d .dot (d1),
            re2 = d .dot (d2),
            e12 = d1 .dot (d2),
            E12 = e12 * e12;

         const
            a =  (re1 - re2 * e12) / (1 - E12),
            b = -(re2 - re1 * e12) / (1 - E12);

         point1 .assign (d1) .multiply (a);
         result .assign (d2) .multiply (b);

         return result .subtract (point1) .add (d);
      };
   })(),
   intersectsTriangle: (() =>
   {
      const
         pvec = new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A (),
         tvec = new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A ();

      return function (A, B, C, uvt)
      {
         // Find vectors for two edges sharing vert0.
         const
            edge1 = B .subtract (A),
            edge2 = C .subtract (A);

         // Begin calculating determinant - also used to calculate U parameter.
         pvec .assign (this .direction) .cross (edge2);

         // If determinant is near zero, ray lies in plane of triangle.
         const det = edge1 .dot (pvec);

         // Non culling intersection.

         if (det === 0)
            return false;

            const inv_det = 1 / det;

         // Calculate distance from vert0 to ray point.
         tvec .assign (this .point) .subtract (A);

         // Calculate U parameter and test bounds.
         const u = tvec .dot (pvec) * inv_det;

         if (u < 0 || u > 1)
            return false;

         // Prepare to test V parameter.
         const qvec = tvec .cross (edge1);

         // Calculate V parameter and test bounds.
         const v = this .direction .dot (qvec) * inv_det;

         if (v < 0 || u + v > 1)
            return false;

         //let u = edge2 .dot (qvec) * inv_det;

         uvt .u = 1 - u - v;
         uvt .v = u;
         uvt .t = v;

         return true;
      };
   })(),
   toString ()
   {
      return `${this .point}, ${this .direction}`;
   },
});

Object .assign (Line3,
{
   fromPoints (point1, point2)
   {
      const line = Object .create (Line3 .prototype);
      line .point     = point1 .copy ();
      line .direction = point2 .copy () .subtract (point1) .normalize ();
      return line;
   },
});

const __default__ = Line3;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_x_ite_Namespace_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .add ("Line3", __default__));

/***/ },

/***/ 460
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(8655);
/* harmony import */ var _Numbers_Matrix4_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(6776);
/* harmony import */ var _x_ite_Namespace_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(8427);



const
   point     = new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A (),
   invMatrix = new _Numbers_Matrix4_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A ();

function Plane3 (point = _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .ZERO, normal = _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .Z_AXIS)
{
   this .normal = new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A ();

   this .set (point, normal);
}

Object .assign (Plane3 .prototype,
{
   copy ()
   {
      const copy = Object .create (Plane3 .prototype);

      copy .normal             = this .normal .copy ();
      copy .distanceFromOrigin = this .distanceFromOrigin;

      return copy;
   },
   assign (plane)
   {
      this .normal .assign (plane .normal);
      this .distanceFromOrigin = plane .distanceFromOrigin;

      return this;
   },
   equals (plane)
   {
      return this .distanceFromOrigin === plane .distanceFromOrigin && this .normal .equals (plane .normal);
   },
   set (point = _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .ZERO, normal = _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .Z_AXIS)
   {
      this .normal .assign (normal);
      this .distanceFromOrigin = normal .dot (point);
      return this;
   },
   multLeft (matrix)
   {
      // Taken from Inventor:

      // Find the point on the plane along the normal from the origin
      point .assign (this .normal) .multiply (this .distanceFromOrigin);

      // Transform the plane normal by the matrix
      // to get the new normal. Use the inverse transpose
      // of the matrix so that normals are not scaled incorrectly.
      // n' = !~m * n = n * ~m
      invMatrix .assign (matrix) .submatrix .inverse ()
         .multVecMatrix (this .normal) .normalize ();

      // Transform the point by the matrix
      matrix .multMatrixVec (point);

      // The new distance is the projected distance of the vector to the
      // transformed point onto the (unit) transformed normal. This is
      // just a dot product.
      this .distanceFromOrigin = this .normal .dot (point);

      return this;
   },
   multRight (matrix)
   {
      // Taken from Inventor:

      // Find the point on the plane along the normal from the origin
      point .assign (this .normal) .multiply (this .distanceFromOrigin);

      // Transform the plane normal by the matrix
      // to get the new normal. Use the inverse transpose
      // of the matrix so that normals are not scaled incorrectly.
      // n' = n * !~m = ~m * n
      invMatrix .assign (matrix) .submatrix .inverse ()
         .multMatrixVec (this .normal) .normalize ();

      // Transform the point by the matrix
      matrix .multVecMatrix (point);

      // The new distance is the projected distance of the vector to the
      // transformed point onto the (unit) transformed normal. This is
      // just a dot product.
      this .distanceFromOrigin = this .normal .dot (point);

      return this;
   },
   getDistanceToPoint (point)
   {
      return point .dot (this .normal) - this .distanceFromOrigin;
   },
   getPerpendicularVectorToPoint (point, result = new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A ())
   {
      return result .assign (this .normal) .multiply (-this .getDistanceToPoint (point));
   },
   getClosestPointToPoint (point, result = new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A ())
   {
      return this .getPerpendicularVectorToPoint (point, result) .add (point);
   },
   intersectsLine (line, intersection)
   {
      const { point, direction } = line;

      // Check if the line is parallel to the plane.
      const theta = direction .dot (this .normal);

      // Plane and line are parallel.
      if (theta === 0)
         return false;

      // Plane and line are not parallel. The intersection point can be calculated now.
      const t = (this .distanceFromOrigin - this .normal .dot (point)) / theta;

      intersection .assign (direction) .multiply (t) .add (point);

      return true;
   },
   toString ()
   {
      return `${this .normal}, ${this .distanceFromOrigin}`;
   },
});

const __default__ = Plane3;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_x_ite_Namespace_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .add ("Plane3", __default__));

/***/ },

/***/ 5962
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(8655);
/* harmony import */ var _x_ite_Namespace_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(8427);
/* provided dependency */ var libtess = __webpack_require__(702);


const Triangle3 =
{
   /**
    *
    * @param {Vector3} a first point of triangle
    * @param {Vector3} b second point of triangle
    * @param {Vector3} c third point of triangle
    * @returns
    */
   area: (() =>
   {
      const
         B = new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A (),
         C = new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A ();

      return function (a, b, c)
      {
         return B .assign (b) .subtract (a) .cross (C .assign (c) .subtract (a)) .norm () / 2;
      };
   })(),
   /**
    *
    * @param {Vector3} a first point of triangle
    * @param {Vector3} b second point of triangle
    * @param {Vector3} c third point of triangle
    * @param {Vector3} normal resulting normal
    * @returns
    */
   normal (a, b, c, normal)
   {
      const
         x1 = c .x - b .x,
         y1 = c .y - b .y,
         z1 = c .z - b .z,
         x2 = a .x - b .x,
         y2 = a .y - b .y,
         z2 = a .z - b .z;

      normal .set (y1 * z2 - z1 * y2,
                   z1 * x2 - x1 * z2,
                   x1 * y2 - y1 * x2);

      return normal .normalize ();
   },
   /**
    *
    * @param {Vector3} a first point of quad
    * @param {Vector3} b second point of quad
    * @param {Vector3} c third point of quad
    * @param {Vector3} d third point of quad
    * @param {Vector3} normal resulting normal
    * @returns
    */
   quadNormal (a, b, c, d, normal)
   {
      const
         x1 = c .x - a .x,
         y1 = c .y - a .y,
         z1 = c .z - a .z,
         x2 = d .x - b .x,
         y2 = d .y - b .y,
         z2 = d .z - b .z;

      normal .set (y1 * z2 - z1 * y2,
                   z1 * x2 - x1 * z2,
                   x1 * y2 - y1 * x2);

      return normal .normalize ();
   },
   triangulatePolygon: (() =>
   {
      // Function called for each vertex of tesselator output.

      function vertexCallback (index, triangles)
      {
         triangles .push (index);
      }

      // Required in case of a combine, otherwise an empty array is returned.

      function combineCallback (coords, data, weight)
      {
         return data [0];
      }

      const tessy = new libtess .GluTesselator ();

      tessy .gluTessCallback (libtess .gluEnum .GLU_TESS_VERTEX_DATA,  vertexCallback);
      tessy .gluTessCallback (libtess .gluEnum .GLU_TESS_COMBINE,      combineCallback);
      tessy .gluTessProperty (libtess .gluEnum .GLU_TESS_WINDING_RULE, libtess .windingRule .GLU_TESS_WINDING_ODD);

      return function (polygon, triangles)
      {
         tessy .gluTessBeginPolygon (triangles);
         tessy .gluTessBeginContour ();

         for (const point of polygon)
            tessy .gluTessVertex (point, point .index);

         tessy .gluTessEndContour ();
         tessy .gluTessEndPolygon ();

         // Return array of indices.
         return triangles;
      };
   })(),
   triangulateConvexPolygon (vertices, triangles)
   {
      // Fallback: Very simple triangulation for convex polygons.

      const numVertices_1 = vertices .length - 1;

      for (let i = 1; i < numVertices_1; ++ i)
         triangles .push (vertices [0], vertices [i], vertices [i + 1]);

      return triangles;
   },
};

const __default__ = Triangle3;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_x_ite_Namespace_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .add ("Triangle3", __default__));

/***/ },

/***/ 3892
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Plane3_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(460);
/* harmony import */ var _Triangle3_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(5962);
/* harmony import */ var _Numbers_Vector2_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(4296);
/* harmony import */ var _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(8655);
/* harmony import */ var _Numbers_Vector4_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(4974);
/* harmony import */ var _Numbers_Matrix4_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(6776);
/* harmony import */ var _Algorithms_SAT_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(7977);
/* harmony import */ var _x_ite_Namespace_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(8427);








/*
 * p7 -------- p6  far plane
 * | \         | \
 * | p3 --------- p2
 * |  |        |  |
 * |  |        |  |
 * p4 |______ p5  |
 *  \ |         \ |
 *   \|          \|
 *    p0 -------- p1  near plane
 */

function ViewVolume (... args)
{
   this .viewport = new _Numbers_Vector4_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A ();

   this .points  = Array .from ({ length: 8 }, () => new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A ());
   // front, left, right, top, bottom, back
   this .normals = Array .from ({ length: 6 }, () => new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A ());
   this .edges   = Array .from ({ length: 8 }, () => new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A ());
   // front, left, right, top, bottom, back
   this .planes  = Array .from ({ length: 6 }, () => new _Plane3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A ());

   if (args .length)
      this .set (... args);
}

Object .assign (ViewVolume .prototype,
{
   set: (() =>
   {
      const matrix = new _Numbers_Matrix4_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A ();

      return function (projectionMatrix, viewport)
      {
         this .viewport .assign (viewport);

         const [p0, p1 ,p2, p3, p4, p5, p6, p7] = this .points;

         const
            x1 = viewport [0],
            x2 = x1 + viewport [2],
            y1 = viewport [1],
            y2 = y1 + viewport [3];

         matrix .assign (projectionMatrix) .inverse ();

         ViewVolume .unProjectPointMatrix (x1, y1, 0, matrix, viewport, p0),
         ViewVolume .unProjectPointMatrix (x2, y1, 0, matrix, viewport, p1),
         ViewVolume .unProjectPointMatrix (x2, y2, 0, matrix, viewport, p2),
         ViewVolume .unProjectPointMatrix (x1, y2, 0, matrix, viewport, p3),
         ViewVolume .unProjectPointMatrix (x1, y1, 1, matrix, viewport, p4),
         ViewVolume .unProjectPointMatrix (x2, y1, 1, matrix, viewport, p5);
         ViewVolume .unProjectPointMatrix (x2, y2, 1, matrix, viewport, p6);
         ViewVolume .unProjectPointMatrix (x1, y2, 1, matrix, viewport, p7);

         const normals = this .normals;

         _Triangle3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .normal (p0, p1, p2, normals [0]); // front
         _Triangle3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .normal (p7, p4, p0, normals [1]); // left
         _Triangle3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .normal (p6, p2, p1, normals [2]); // right
         _Triangle3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .normal (p2, p6, p7, normals [3]); // top
         _Triangle3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .normal (p1, p0, p4, normals [4]); // bottom
         _Triangle3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .normal (p4, p7, p6, normals [5]); // back

         const planes = this .planes;

         planes [0] .set (p1, normals [0]); // front
         planes [1] .set (p4, normals [1]); // left
         planes [2] .set (p2, normals [2]); // right
         planes [3] .set (p6, normals [3]); // top
         planes [4] .set (p0, normals [4]); // bottom
         planes [5] .set (p7, normals [5]); // back

         this .edges .tainted = true;

         return this;
      };
   })(),
   getViewport ()
   {
      return this .viewport;
   },
   getEdges ()
   {
      // Return suitable edges for SAT theorem.

      const edges = this .edges;

      if (edges .tainted)
      {
         const [p0, p1 ,p2, p3, p4, p5, p6, p7] = this .points;

         edges [0] .assign (p0) .subtract (p1);
         edges [1] .assign (p1) .subtract (p2);
         edges [2] .assign (p2) .subtract (p3);
         edges [3] .assign (p3) .subtract (p0);

         edges [4] .assign (p0) .subtract (p4);
         edges [5] .assign (p1) .subtract (p5);
         edges [6] .assign (p2) .subtract (p6);
         edges [7] .assign (p3) .subtract (p7);

         // Edges 8 - 11 are equal to edges 0 - 3.

         edges .tainted = false;
      }

      return edges;
   },
   intersectsSphere (radius, center)
   {
      for (const plane of this .planes)
      {
         if (plane .getDistanceToPoint (center) > radius)
            return false;
      }

      return true;
   },
   intersectsBox: (() =>
   {
      const
         points1  = Array .from ({ length: 8 }, () => new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A ()),
         normals1 = Array .from ({ length: 3 }, () => new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A ()),
         axes1    = Array .from ({ length: 3 }, () => new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A ()),
         axes     = Array .from ({ length: 3 * 8 }, () => new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A ());

      return function (box)
      {
         // Get points.

         box .getPoints (points1);

         const points2 = this .points;

         // Test the three planes spanned by the normal vectors of the faces of the box.

         if (_Algorithms_SAT_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .isSeparated (box .getNormals (normals1), points1, points2))
            return false;

         // Test the six planes spanned by the normal vectors of the faces of the view volume.

         if (_Algorithms_SAT_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .isSeparated (this .normals, points1, points2))
            return false;

         // Test the planes spanned by the edges of each object.

         box .getAxes (axes1);

         const edges = this .getEdges ();

         for (let i1 = 0; i1 < 3; ++ i1)
         {
            for (let i2 = 0; i2 < 8; ++ i2)
               axes [i1 * 3 + i2] .assign (axes1 [i1]) .cross (edges [i2]);
         }

         if (_Algorithms_SAT_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .isSeparated (axes, points1, points2))
            return false;

         // Both boxes intersect.

         return true;
      };
   })(),
});

Object .assign (ViewVolume,
{
   unProjectPoint: (() =>
   {
      const invModelViewProjectionMatrix = new _Numbers_Matrix4_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A ();

      return function (winX, winY, winZ, modelViewMatrix, projectionMatrix, viewport, point)
      {
         return this .unProjectPointMatrix (winX, winY, winZ, invModelViewProjectionMatrix .assign (modelViewMatrix) .multRight (projectionMatrix) .inverse (), viewport, point);
      };
   })(),
   unProjectPointMatrix: (() =>
   {
      const vin = new _Numbers_Vector4_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A ();

      return function (winX, winY, winZ, invModelViewProjectionMatrix, viewport, point)
      {
         // Transformation of normalized coordinates between -1 and 1
         vin .set ((winX - viewport [0]) / viewport [2] * 2 - 1,
                   (winY - viewport [1]) / viewport [3] * 2 - 1,
                   winZ * 2 - 1,
                   1);

         //Objects coordinates
         invModelViewProjectionMatrix .multVecMatrix (vin);

         const d = 1 / vin .w;

         return point .set (vin .x * d, vin .y * d, vin .z * d, 1);
      };
   })(),
   unProjectRay: (() =>
   {
      const invModelViewProjectionMatrix = new _Numbers_Matrix4_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A ();

      return function (winX, winY, modelViewMatrix, projectionMatrix, viewport, result)
      {
         return this .unProjectRayMatrix (winX, winY, invModelViewProjectionMatrix .assign (modelViewMatrix) .multRight (projectionMatrix) .inverse (), viewport, result);
      };
   })(),
   unProjectRayMatrix: (() =>
   {
      const
         near = new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A (),
         far  = new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A ();

      return function (winX, winY, invModelViewProjectionMatrix, viewport, result)
      {
         ViewVolume .unProjectPointMatrix (winX, winY, 0.0, invModelViewProjectionMatrix, viewport, near);
         ViewVolume .unProjectPointMatrix (winX, winY, 0.9, invModelViewProjectionMatrix, viewport, far);

         return result .setPoints (near, far);
      };
   })(),
   projectPoint: (() =>
   {
      const vin = new _Numbers_Vector4_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A ();

      return function (point, modelViewMatrix, projectionMatrix, viewport, vOut)
      {
         if (point .length === 4)
            vin .assign (point);
         else
            vin .set (point .x, point .y, point .z, 1);

         projectionMatrix .multVecMatrix (modelViewMatrix .multVecMatrix (vin));

         const d = 1 / (2 * vin .w);

         return vOut .set ((vin .x * d + 0.5) * viewport [2] + viewport [0],
                           (vin .y * d + 0.5) * viewport [3] + viewport [1],
                           (vin .z * d + 0.5));
      };
   })(),
   projectPointMatrix: (() =>
   {
      const vin = new _Numbers_Vector4_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A ();

      return function (point, modelViewProjectionMatrix, viewport, vOut)
      {
         if (point .length === 4)
            vin .assign (point);
         else
            vin .set (point .x, point .y, point .z, 1);

         modelViewProjectionMatrix .multVecMatrix (vin);

         const d = 1 / (2 * vin .w);

         return vOut .set ((vin .x * d + 0.5) * viewport [2] + viewport [0],
                           (vin .y * d + 0.5) * viewport [3] + viewport [1],
                           (vin .z * d + 0.5));
      };
   })(),
   projectLine: (() =>
   {
      const modelViewProjectionMatrix = new _Numbers_Matrix4_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A ();

      return function (line, modelViewMatrix, projectionMatrix, viewport, result)
      {
         return this .projectLineMatrix (line, modelViewProjectionMatrix .assign (modelViewMatrix) .multRight (projectionMatrix), viewport, result);
      };
   })(),
   projectLineMatrix: (() =>
   {
      const
         near      = new _Numbers_Vector2_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A (),
         far       = new _Numbers_Vector2_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A (),
         direction = new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A ();

      return function (line, modelViewProjectionMatrix, viewport, result)
      {
         ViewVolume .projectPointMatrix (line .point, modelViewProjectionMatrix, viewport, near);
         ViewVolume .projectPointMatrix (direction .assign (line .direction) .multiply (1e9) .add (line .point), modelViewProjectionMatrix, viewport, far);

         return result .setPoints (near, far);
      };
   })(),
});

const __default__ = ViewVolume;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_x_ite_Namespace_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .add ("ViewVolume", __default__));

/***/ },

/***/ 8759
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Algorithm_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(9919);
/* harmony import */ var _x_ite_Namespace_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(8427);


const { interval, degrees } = _Algorithm_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A;

const
   _r = Symbol .for ("X_ITE.Color3.r"),
   _g = Symbol .for ("X_ITE.Color3.g"),
   _b = Symbol .for ("X_ITE.Color3.b");

// glTF sometimes allows color values greater than 1.
// See: https://github.com/KhronosGroup/glTF/blob/main/extensions/2.0/Khronos/KHR_materials_specular/README.md
// See: https://raw.githubusercontent.com/KhronosGroup/glTF-Sample-Assets/master/Models/SpecularTest/glTF/SpecularTest.gltf

function Color3 (r = 0, g = r, b = g)
{
   this [_r] = r;
   this [_g] = g;
   this [_b] = b;
}

Object .assign (Color3 .prototype,
{
   *[Symbol .iterator] ()
   {
      yield this [_r];
      yield this [_g];
      yield this [_b];
   },
   copy ()
   {
      const copy = Object .create (Color3 .prototype);
      copy [_r] = this [_r];
      copy [_g] = this [_g];
      copy [_b] = this [_b];
      return copy;
   },
   assign (color)
   {
      this [_r] = color [_r];
      this [_g] = color [_g];
      this [_b] = color [_b];
      return this;
   },
   set (r = 0, g = r, b = g)
   {
      this [_r] = r;
      this [_g] = g;
      this [_b] = b;
      return this;
   },
   equals (color)
   {
      return this [_r] === color [_r] &&
             this [_g] === color [_g] &&
             this [_b] === color [_b];
   },
   getHSV (result = [ ])
   {
      let h, s, v;

      const
         r = this [_r],
         g = this [_g],
         b = this [_b];

      const
         min = Math .min (r, g, b),
         max = Math .max (r, g, b);

      v = max; // value

      const delta = max - min;

      if (max !== 0 && delta !== 0)
      {
         s = delta / max; // s

         if (r === max)
            h =     (g - b) / delta;  // between yellow & magenta
         else if (g === max)
            h = 2 + (b - r) / delta;  // between cyan & yellow
         else
            h = 4 + (r - g) / delta;  // between magenta & cyan

         h *= Math .PI / 3;  // radiants

         if (h < 0)
            h += Math .PI * 2;
      }
      else
      {
         s = h = 0; // s = 0, h is undefined
      }

      result [0] = h;
      result [1] = s;
      result [2] = v;

      return result;
   },
   setHSV (h, s, v)
   {
      s = Math .max (s, 0),
      v = Math .max (v, 0);

      // H is given on [0, 2 * Pi]. S and V are given on [0, 1].
      // RGB are each returned on [0, 1].

      if (s === 0)
      {
         // achromatic (grey)
         this [_r] = this [_g] = this [_b] = v;
      }
      else
      {
         const w = degrees (interval (h, 0, Math .PI * 2)) / 60;     // sector 0 to 5

         const i = Math .floor (w);
         const f = w - i;                      // factorial part of h
         const p = v * ( 1 - s );
         const q = v * ( 1 - s * f );
         const t = v * ( 1 - s * ( 1 - f ) );

         switch (i % 6)
         {
            case 0:  this [_r] = v; this [_g] = t; this [_b] = p; break;
            case 1:  this [_r] = q; this [_g] = v; this [_b] = p; break;
            case 2:  this [_r] = p; this [_g] = v; this [_b] = t; break;
            case 3:  this [_r] = p; this [_g] = q; this [_b] = v; break;
            case 4:  this [_r] = t; this [_g] = p; this [_b] = v; break;
            default: this [_r] = v; this [_g] = p; this [_b] = q; break;
         }
      }

      return this;
   },
   linearToSRGB (color = new Color3 ())
   {
      color [_r] = Math .pow (this [_r], 1 / 2.2);
      color [_g] = Math .pow (this [_g], 1 / 2.2);
      color [_b] = Math .pow (this [_b], 1 / 2.2);

      return color;
   },
   sRGBToLinear (color = new Color3 ())
   {
      color [_r] = Math .pow (this [_r], 2.2);
      color [_g] = Math .pow (this [_g], 2.2);
      color [_b] = Math .pow (this [_b], 2.2);

      return color;
   },
   toString ()
   {
      return this [_r] + " " +
             this [_g] + " " +
             this [_b];
   },
});

for (const key of Object .keys (Color3 .prototype))
   Object .defineProperty (Color3 .prototype, key, { enumerable: false });

const r = {
   get () { return this [_r]; },
   set (value) { this [_r] = value; },
};

const g = {
   get () { return this [_g]; },
   set (value) { this [_g] = value; },
};

const b = {
   get () { return this [_b]; },
   set (value) { this [_b] = value; },
};

Object .defineProperties (Color3 .prototype,
{
   length: { value: 3 },
   0: r,
   1: g,
   2: b,
   r: Object .assign ({ enumerable: true }, r),
   g: Object .assign ({ enumerable: true }, g),
   b: Object .assign ({ enumerable: true }, b),
});

Object .assign (Color3,
{
   BLACK: Object .freeze (new Color3 ()),
   WHITE: Object .freeze (new Color3 (1)),
   HSV (h, s, v)
   {
      const color = Object .create (this .prototype);
      color .setHSV (h, s, v);
      return color;
   },
   lerp (a, b, t, r)
   {
      // Linearly interpolate in HSV space between source color @a a and destination color @a b by an amount of @a t.
      // Source and destination color must be in HSV space. The resulting HSV color is stored in @a r.

      let
         [ha, sa, va] = a,
         [hb, sb, vb] = b;

      if (sa === 0)
         ha = hb;

      if (sb === 0)
         hb = ha;

      const range = Math .abs (hb - ha);

      if (range <= Math .PI)
      {
         r [0] = ha + t * (hb - ha);
         r [1] = sa + t * (sb - sa);
         r [2] = va + t * (vb - va);
         return r;
      }

      const
         PI2  = Math .PI * 2,
         step = (PI2 - range) * t;

      let h = ha < hb ? ha - step : ha + step;

      if (h < 0)
         h += PI2;

      else if (h > PI2)
         h -= PI2;

      r [0] = h;
      r [1] = sa + t * (sb - sa);
      r [2] = va + t * (vb - va);
      return r;
   },
});

const __default__ = Color3;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_x_ite_Namespace_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .add ("Color3", __default__));

/***/ },

/***/ 2246
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Color3_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(8759);
/* harmony import */ var _x_ite_Namespace_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(8427);


const
   _r = Symbol .for ("X_ITE.Color3.r"),
   _g = Symbol .for ("X_ITE.Color3.g"),
   _b = Symbol .for ("X_ITE.Color3.b"),
   _a = Symbol ();

// glTF sometimes allows color values greater than 1.
// See: https://github.com/KhronosGroup/glTF/blob/main/extensions/2.0/Khronos/KHR_materials_specular/README.md
// See: https://raw.githubusercontent.com/KhronosGroup/glTF-Sample-Assets/master/Models/SpecularTest/glTF/SpecularTest.gltf

function Color4 (r = 0, g = r, b = g, a = b)
{
   this [_r] = r;
   this [_g] = g;
   this [_b] = b;
   this [_a] = a;
}

Object .assign (Color4 .prototype,
{
   *[Symbol .iterator] ()
   {
      yield this [_r];
      yield this [_g];
      yield this [_b];
      yield this [_a];
   },
   copy ()
   {
      const copy = Object .create (Color4 .prototype);
      copy [_r] = this [_r];
      copy [_g] = this [_g];
      copy [_b] = this [_b];
      copy [_a] = this [_a];
      return copy;
   },
   assign (color)
   {
      this [_r] = color [_r];
      this [_g] = color [_g];
      this [_b] = color [_b];
      this [_a] = color [_a];
      return this;
   },
   set (r = 0, g = r, b = g, a = b)
   {
      this [_r] = r;
      this [_g] = g;
      this [_b] = b;
      this [_a] = a;
      return this;
   },
   equals (color)
   {
      return this [_r] === color [_r] &&
             this [_g] === color [_g] &&
             this [_b] === color [_b] &&
             this [_a] === color [_a];
   },
   getHSVA (result)
   {
      _Color3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .prototype .getHSV .call (this, result);

      result [3] = this [_a];

      return result;
   },
   setHSVA (h, s, v, a)
   {
      _Color3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .prototype .setHSV .call (this, h, s, v);

      this [_a] = a;

      return this;
   },
   linearToSRGB (color = new Color4 ())
   {
      _Color3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .prototype .linearToSRGB .call (this, color);

      color [_a] = this [_a];

      return color;
   },
   sRGBToLinear (color = new Color4 ())
   {
      _Color3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .prototype .sRGBToLinear .call (this, color);

      color [_a] = this [_a];

      return color;
   },
   toString ()
   {
      return this [_r] + " " +
             this [_g] + " " +
             this [_b] + " " +
             this [_a];
   },
});

for (const key of Object .keys (Color4 .prototype))
   Object .defineProperty (Color4 .prototype, key, { enumerable: false });

const r = {
   get () { return this [_r]; },
   set (value) { this [_r] = value; },
};

const g = {
   get () { return this [_g]; },
   set (value) { this [_g] = value; },
};

const b = {
   get () { return this [_b]; },
   set (value) { this [_b] = value; },
};

const a = {
   get () { return this [_a]; },
   set (value) { this [_a] = value; },
};

Object .defineProperties (Color4 .prototype,
{
   length: { value: 4 },
   0: r,
   1: g,
   2: b,
   3: a,
   r: Object .assign ({ enumerable: true }, r),
   g: Object .assign ({ enumerable: true }, g),
   b: Object .assign ({ enumerable: true }, b),
   a: Object .assign ({ enumerable: true }, a),
});

Object .assign (Color4,
{
   TRANSPARENT: Object .freeze (new Color4 ()),
   BLACK: Object .freeze (new Color4 (0, 0, 0, 1)),
   WHITE: Object .freeze (new Color4 (1)),
   HSVA (h, s, v, a)
   {
      const color = Object .create (this .prototype);
      color .setHSVA (h, s, v, a);
      return color;
   },
   lerp (a, b, t, r)
   {
      // Linearely interpolate in HSVA space between source color @a a and destination color @a b by an amount of @a t.
      // Source and destination color must be in HSVA space. The resulting HSVA color is stored in @a r.
      const aa = a [3];
      _Color3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .lerp (a, b, t, r);
      r [3] = aa + t * (b [3] - aa);
      return r;
   },
});

const __default__ = Color4;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_x_ite_Namespace_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .add ("Color4", __default__));

/***/ },

/***/ 6295
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _x_ite_Namespace_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(8427);
function Complex (real = 0, imag = 0)
{
   this .real = real;
   this .imag = imag;
}

Object .assign (Complex .prototype,
{
   *[Symbol .iterator] ()
   {
      yield this .real;
      yield this .imag;
   },
   copy ()
   {
      const copy = Object .create (Complex .prototype);
      copy .real = this .real;
      copy .imag = this .imag;
      return copy;
   },
   assign (complex)
   {
      this .real = complex .real;
      this .imag = complex .imag;
      return this;
   },
   equals (complex)
   {
      return this .real === complex .real &&
             this .imag === complex .imag;
   },
   set (real = 0, imag = 0)
   {
      this .real = real;
      this .imag = imag;
      return this;
   },
   setPolar (magnitude, angle)
   {
      this .real = magnitude * Math .cos (angle);
      this .imag = magnitude * Math .sin (angle);
      return this;
   },
   conjugate ()
   {
      this .imag = -this .imag;
      return this;
   },
   negate ()
   {
      this .real = -this .real;
      this .imag = -this .imag;
      return this;
   },
   inverse ()
   {
      const d = this .real * this .real + this .imag * this .imag;

      this .real /=  d;
      this .imag /= -d;
      return this;
   },
   add (value)
   {
      this .real += value .real;
      this .imag += value .imag;
      return this;
   },
   subtract (value)
   {
      this .real -= value .real;
      this .imag -= value .imag;
      return this;
   },
   multiply (value)
   {
      this .real *= value;
      this .imag *= value;
      return this;
   },
   multComp (value)
   {
      const
         { real: ar, imag: ai } = this,
         { real: br, imag: bi } = value;

      this .real = ar * br - ai * bi;
      this .imag = ar * bi + ai * br;
      return this;
   },
   divide (value)
   {
      this .real /= value;
      this .imag /= value;
      return this;
   },
   divComp (value)
   {
      const
         { real: ar, imag: ai } = this,
         { real: br, imag: bi } = value,
         d = br * br + bi * bi;

      this .real = (ar * br + ai * bi) / d;
      this .imag = (ai * br - ar * bi) / d;
      return this;
   },
   toString ()
   {
      let string = "";

      string += this .real;

      if (this .imag < 0)
      {
         string += this .imag;
         string += "i";
      }
      else if (this .imag > 0)
      {
         string += "+";
         string += this .imag;
         string += "i";
      }

      return string;
   },
});

for (const key of Object .keys (Complex .prototype))
   Object .defineProperty (Complex .prototype, key, { enumerable: false });

Object .defineProperties (Complex .prototype,
{
   length: { value: 2 },
   0:
   {
      get ()
      {
         return this .real;
      },
      set (value)
      {
         this .real = value;
      },
   },
   1:
   {
      get ()
      {
         return this .imag;
      },
      set (value)
      {
         this .imag = value;
      },
   },
   magnitude:
   {
      get ()
      {
         if (this .real)
         {
            if (this .imag)
               return Math .hypot (this .real, this .imag);

            return Math .abs (this .real);
         }

         return Math .abs (this .imag);
      },
      set (magnitude)
      {
         this .setPolar (magnitude, this .angle);
      },
   },
   angle:
   {
      get ()
      {
         return Math .atan2 (this .imag, this .real);
      },
      set (angle)
      {
         this .setPolar (this .magnitude, angle);
      },
   },
});

Object .assign (Complex,
{
   fromPolar (magnitude, angle)
   {
      return Object .create (Complex .prototype) .setPolar (magnitude, angle);
   },
});

const __default__ = Complex;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_x_ite_Namespace_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .add ("Complex", __default__));

/***/ },

/***/ 3817
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  A: () => (/* binding */ Numbers_Matrix3)
});

// EXTERNAL MODULE: ./src/standard/Math/Numbers/Vector2.js
var Vector2 = __webpack_require__(4296);
// EXTERNAL MODULE: ./src/standard/Math/Numbers/Vector3.js
var Vector3 = __webpack_require__(8655);
// EXTERNAL MODULE: ./src/x_ite/Namespace.js
var Namespace = __webpack_require__(8427);
;// ./src/standard/Math/Numbers/Matrix2.js


function Matrix2 (... args)
{
   if (args .length)
   {
      for (let i = 0; i < 4; ++ i)
         this [i] = args [i];
   }
   else
   {
      this .identity ();
   }
}

Object .assign (Matrix2 .prototype,
{
   *[Symbol .iterator] ()
   {
      for (let i = 0; i < 4; ++ i)
         yield this [i];
   },
   copy ()
   {
      const copy = Object .create (Matrix2 .prototype);

      for (let i = 0; i < 4; ++ i)
         copy [i] = this [i];

      return copy;
   },
   assign (matrix)
   {
      for (let i = 0; i < 4; ++ i)
         this [i] = matrix [i];

      return this;
   },
   equals (matrix)
   {
      return this [0] === matrix [0] &&
             this [1] === matrix [1] &&
             this [2] === matrix [2] &&
             this [3] === matrix [3];
   },
   set1 (r, c, value)
   {
      this [r * this .order + c] = value;
   },
   get1 (r, c)
   {
      return this [r * this .order + c];
   },
   set ()
   {
      switch (arguments .length)
      {
         case 0:
         {
            this .identity ();
            break;
         }
         case 4:
         {
            for (let i = 0; i < 4; ++ i)
               this [i] = arguments [i];

            break;
         }
      }

      return this;
   },
   determinant1 ()
   {
      return this [0];
   },
   determinant ()
   {
      const { 0: m0, 1: m1, 2: m2, 3: m3 } = this;

      return m0 * m3 - m1 * m2;
   },
   transpose ()
   {
      const tmp = this [1];

      this [1] = this [2];
      this [2] = tmp;

      return this;
   },
   inverse ()
   {
      const
         { 0: A, 1: B, 2: C, 3: D } = this,
         d = A * D - B * C;

      // if (d === 0) ... determinant is zero.

      this [0] =  D / d;
      this [1] = -B / d;
      this [2] = -C / d;
      this [3] =  A / d;

      return this;
   },
   multLeft (matrix)
   {
      const { 0: a0, 1: a1, 2: a2, 3: a3 } = this;

      var { 0: b0, 1: b1 } = matrix;

      this [0] = a0 * b0 + a2 * b1;
      this [1] = a1 * b0 + a3 * b1;

      var { 2: b0, 3: b1 } = matrix;

      this [2] = a0 * b0 + a2 * b1;
      this [3] = a1 * b0 + a3 * b1;

      return this;
   },
   multRight (matrix)
   {
      const { 0: b0, 1: b1, 2: b2, 3: b3 } = matrix;

      var { 0: a0, 1: a1 } = this;

      this [0] = b0 * a0 + b2 * a1;
      this [1] = b1 * a0 + b3 * a1;

      var { 2: a0, 3: a1 } = this;

      this [2] = b0 * a0 + b2 * a1;
      this [3] = b1 * a0 + b3 * a1;

      return this;
   },
   multVecMatrix (vector)
   {
      if (typeof vector === "number")
      {
         const
            x = vector,
            w = x * this [1] + this [3];

         return (x * this [0] + this [2]) / w;
      }
      else
      {
         const { x, y } = vector;

         vector .x = x * this [0] + y * this [2];
         vector .y = x * this [1] + y * this [3];

         return vector;
      }
   },
   multMatrixVec (vector)
   {
      if (typeof vector === "number")
      {
         const
            x = vector,
            w = x * this [2] + this [3];

         return (x * this [0] + this [1]) / w;
      }
      else
      {
         const { x, y } = vector;

         vector .x = x * this [0] + y * this [1];
         vector .y = x * this [2] + y * this [3];

         return vector;
      }
   },
   identity ()
   {
      this [0] = 1;
      this [1] = 0;
      this [2] = 0;
      this [3] = 1;
   },
   toString ()
   {
      return Array .prototype .join .call (this, " ");
   },
});

for (const key of Object .keys (Matrix2 .prototype))
   Object .defineProperty (Matrix2 .prototype, key, { enumerable: false });

Object .defineProperties (Matrix2 .prototype,
{
   order: { value: 2 },
   length: { value: 4 },
   x:
   {
      get: (() =>
      {
         const vector = new Vector2/* default */.A ();

         return function () { return vector .set (this [0], this [1]); };
      })(),
   },
   y:
   {
      get: (() =>
      {
         const vector = new Vector2/* default */.A ();

         return function () { return vector .set (this [2], this [3]); };
      })(),
   },
   xAxis:
   {
      get () { return this [0]; },
   },
   origin:
   {
      get () { return this [2]; },
   },
   submatrix:
   {
      get () { return this [0]; },
   },
});

Object .assign (Matrix2,
{
   IDENTITY: Object .freeze (new Matrix2 ()),
});

const __default__ = Matrix2;
;

/* harmony default export */ const Numbers_Matrix2 = (Namespace/* default */.A .add ("Matrix2", __default__));
// EXTERNAL MODULE: ./src/standard/Math/Algorithms/eigen_decomposition.js
var eigen_decomposition = __webpack_require__(2973);
;// ./src/standard/Math/Numbers/Matrix3.js





function Matrix3 (... args)
{
   if (args .length)
   {
      for (let i = 0; i < 9; ++ i)
         this [i] = args [i];
   }
   else
   {
      this .identity ();
   }
}

Object .assign (Matrix3 .prototype,
{
   *[Symbol .iterator] ()
   {
      for (let i = 0; i < 9; ++ i)
         yield this [i];
   },
   copy ()
   {
      const copy = Object .create (Matrix3 .prototype);

      for (let i = 0; i < 9; ++ i)
         copy [i] = this [i];

      return copy;
   },
   assign (matrix)
   {
      for (let i = 0; i < 9; ++ i)
         this [i] = matrix [i];

      return this;
   },
   equals (matrix)
   {
      return this [0] === matrix [0] &&
             this [1] === matrix [1] &&
             this [2] === matrix [2] &&
             this [3] === matrix [3] &&
             this [4] === matrix [4] &&
             this [5] === matrix [5] &&
             this [6] === matrix [6] &&
             this [7] === matrix [7] &&
             this [8] === matrix [8];
   },
   set1 (r, c, value)
   {
      this [r * this .order + c] = value;

      return this;
   },
   get1 (r, c)
   {
      return this [r * this .order + c];
   },
   set: (() =>
   {
      const invCenter = new Vector2/* default */.A ();

      return function (translation, rotation, scale, scaleOrientation, center)
      {
         this .identity ();

         switch (arguments .length)
         {
            case 1:
            {
               if (translation && !translation .equals (Vector2/* default */.A .ZERO))
                  this .translate (translation);

               break;
            }
            case 2:
            {
               if (translation && !translation .equals (Vector2/* default */.A .ZERO))
                  this .translate (translation);

               if (rotation)
                  this .rotate (rotation);

               break;
            }
            case 3:
            {
               if (translation && !translation .equals (Vector2/* default */.A .ZERO))
                  this .translate (translation);

               if (rotation)
                  this .rotate (rotation);

               if (scale && !scale .equals (Vector2/* default */.A .ONE))
                  this .scale  (scale);

               break;
            }
            case 4:
            {
               if (translation && !translation .equals (Vector2/* default */.A .ZERO))
                  this .translate (translation);

               if (rotation)
                  this .rotate (rotation);

               if (scale && !scale .equals (Vector2/* default */.A .ONE))
               {
                  if (scaleOrientation)
                  {
                     this .rotate (scaleOrientation);
                     this .scale (scale);
                     this .rotate (-scaleOrientation);
                  }
                  else
                  {
                     this .scale (scale);
                  }
               }

               break;
            }
            case 5:
            {
               // P' = T * C * R * SR * S * -SR * -C * P
               if (translation && !translation .equals (Vector2/* default */.A .ZERO))
                  this .translate (translation);

               const hasCenter = center && !center .equals (Vector2/* default */.A .ZERO);

               if (hasCenter)
                  this .translate (center);

               if (rotation)
                  this .rotate (rotation);

               if (scale && !scale .equals (Vector2/* default */.A .ONE))
               {
                  if (scaleOrientation)
                  {
                     this .rotate (scaleOrientation);
                     this .scale (scale);
                     this .rotate (-scaleOrientation);
                  }
                  else
                  {
                     this .scale (scale);
                  }
               }

               if (hasCenter)
                  this .translate (invCenter .assign (center) .negate ());

               break;
            }
            case 9:
            {
               for (let i = 0; i < 9; ++ i)
                  this [i] = arguments [i];

               break;
            }
         }

         return this;
      };
   })(),
   get: (() =>
   {
      const c = new Vector2/* default */.A ();

      return function (translation, rotation, scale, scaleOrientation, center)
      {
         switch (arguments .length)
         {
            case 1:
            {
               translation .set (this [6], this [7]);
               break;
            }
            case 2:
            case 3:
            case 4:
            {
               this .factor (translation, rotation, scale, scaleOrientation);
               break;
            }
            case 5:
            {
               if (center)
               {
                  m .set (c .assign (center) .negate ());
                  m .multLeft (this);
                  m .translate (center);
                  m .get (translation, rotation, scale, scaleOrientation);
               }
               else
               {
                  this .factor (translation, rotation, scale, scaleOrientation);
               }

               break;
            }
         }
      };
   })(),
   factor: (() =>
   {
      const
         s  = new Vector2/* default */.A (),
         si = new Numbers_Matrix2 (),
         so = new Numbers_Matrix2 (),
         b  = new Numbers_Matrix2 ();

      const eigen = { values: [ ], vectors: [[ ], [ ]] };

      return function (translation, rotation, scale, scaleOrientation)
      {
         // (1) Get translation.
         translation ?.set (this [6], this [7]);

         // (2) Create 3x3 matrix.
         const a = this .submatrix;

         // (3) Compute det A. If negative, set sign = -1, else sign = 1
         const det      = a .determinant ();
         const det_sign = det < 0 ? -1 : 1;

         // (4) B = A * !A  (here !A means A transpose)
         b .assign (a) .transpose () .multLeft (a);
         const e = (0,eigen_decomposition/* default */.A) (b, eigen);

         // Find min / max eigenvalues and do ratio test to determine singularity.

         so .set (e .vectors [0] [0], e .vectors [1] [0],
                  e .vectors [0] [1], e .vectors [1] [1]);

         if (scaleOrientation)
         {
            scaleOrientation [0] = so [0];
            scaleOrientation [1] = so [1];
            scaleOrientation [2] = Math .atan2 (so [1], so [0]);
         }

         // Compute s = sqrt(eigen values), with sign. Set si = s-inverse

         s .set (det_sign * Math .sqrt (e .values [0]),
                 det_sign * Math .sqrt (e .values [1]));

         scale ?.assign (s);

         if (rotation)
         {
            si [0] = 1 / s .x;
            si [3] = 1 / s .y;

            // (5) Compute U = !R ~S R A.
            a .multLeft (so) .multLeft (si) .multLeft (so .transpose ());

            rotation [0] = a [0];
            rotation [1] = a [1];
            rotation [2] = Math .atan2 (a [1], a [0]);
         }
      };
   })(),
   determinant2 ()
   {
      const { 0: m0, 1: m1, 3: m3, 4: m4 } = this;

      return m0 * m4 - m1 * m3;
   },
   determinant ()
   {
      const { 0: m0, 1: m1, 2: m2, 3: m3, 4: m4, 5: m5, 6: m6, 7: m7, 8: m8 } = this;

      return m0 * (m4 * m8 - m5 * m7) -
             m1 * (m3 * m8 - m5 * m6) +
             m2 * (m3 * m7 - m4 * m6);
   },
   transpose ()
   {
      let tmp;

      tmp = this [1]; this [1] = this [3]; this [3] = tmp;
      tmp = this [2]; this [2] = this [6]; this [6] = tmp;
      tmp = this [5]; this [5] = this [7]; this [7] = tmp;

      return this;
   },
   inverse ()
   {
      // Complexity 2 +, 16 -, 33 *, 1 /.

      const
         { 0: m0, 1: m1, 2: m2, 3: m3, 4: m4, 5: m5, 6: m6, 7: m7, 8: m8 } = this,
         t4  = m0 * m4,
         t6  = m0 * m7,
         t8  = m3 * m1,
         t10 = m3 * m7,
         t12 = m6 * m1,
         t14 = m6 * m4;

      let d = (t4 * m8 - t6 * m5 - t8 * m8 + t10 * m2 + t12 * m5 - t14 * m2);

      // if (d === 0) ... determinant is zero.

      d = 1 / d;

      const
         b0 =  (m4 * m8 - m7 * m5) * d,
         b1 = -(m1 * m8 - m7 * m2) * d,
         b2 =  (m1 * m5 - m4 * m2) * d,
         b3 = -(m3 * m8 - m6 * m5) * d,
         b4 =  (m0 * m8 - m6 * m2) * d,
         b5 = -(m0 * m5 - m3 * m2) * d;

      this [0] = b0;
      this [1] = b1;
      this [2] = b2;
      this [3] = b3;
      this [4] = b4;
      this [5] = b5;
      this [6] =  (t10 - t14) * d;
      this [7] = -(t6 - t12) * d;
      this [8] =  (t4 - t8) * d;

      return this;
   },
   multLeft (matrix)
   {
      // Complexity 18 +, 27 *.

      const { 0: a0, 1: a1, 2: a2, 3: a3, 4: a4, 5: a5, 6: a6, 7: a7, 8: a8 } = this;

      var { 0: b0, 1: b1, 2: b2 } = matrix;

      this [0] = a0 * b0 + a3 * b1 + a6 * b2;
      this [1] = a1 * b0 + a4 * b1 + a7 * b2;
      this [2] = a2 * b0 + a5 * b1 + a8 * b2;

      var { 3: b0, 4: b1, 5: b2 } = matrix;

      this [3] = a0 * b0 + a3 * b1 + a6 * b2;
      this [4] = a1 * b0 + a4 * b1 + a7 * b2;
      this [5] = a2 * b0 + a5 * b1 + a8 * b2;

      var { 6: b0, 7: b1, 8: b2 } = matrix;

      this [6] = a0 * b0 + a3 * b1 + a6 * b2;
      this [7] = a1 * b0 + a4 * b1 + a7 * b2;
      this [8] = a2 * b0 + a5 * b1 + a8 * b2;

      return this;
   },
   multRight (matrix)
   {
      // Complexity 18 +, 27 *.

      const { 0: b0, 1: b1, 2: b2, 3: b3, 4: b4, 5: b5, 6: b6, 7: b7, 8: b8 } = matrix;

      var { 0: a0, 1: a1, 2: a2 } = this;

      this [0] = a0 * b0 + a1 * b3 + a2 * b6;
      this [1] = a0 * b1 + a1 * b4 + a2 * b7;
      this [2] = a0 * b2 + a1 * b5 + a2 * b8;

      var { 3: a0, 4: a1, 5: a2 } = this;

      this [3] = a0 * b0 + a1 * b3 + a2 * b6;
      this [4] = a0 * b1 + a1 * b4 + a2 * b7;
      this [5] = a0 * b2 + a1 * b5 + a2 * b8;

      var { 6: a0, 7: a1, 8: a2 } = this;

      this [6] = a0 * b0 + a1 * b3 + a2 * b6;
      this [7] = a0 * b1 + a1 * b4 + a2 * b7;
      this [8] = a0 * b2 + a1 * b5 + a2 * b8;

      return this;
   },
   multVecMatrix (vector)
   {
      if (vector .length === 2)
      {
         const
            { x, y } = vector,
            w = x * this [2] + y * this [5] + this [8];

         vector .x = (x * this [0] + y * this [3] + this [6]) / w;
         vector .y = (x * this [1] + y * this [4] + this [7]) / w;

         return vector;
      }
      else
      {
         const { x, y, z } = vector;

         vector .x = x * this [0] + y * this [3] + z * this [6];
         vector .y = x * this [1] + y * this [4] + z * this [7];
         vector .z = x * this [2] + y * this [5] + z * this [8];

         return vector;
      }
   },
   multMatrixVec (vector)
   {
      if (vector .length === 2)
      {
         const
            { x, y } = vector,
            w = x * this [6] + y * this [7] + this [8];

         vector .x = (x * this [0] + y * this [1] + this [2]) / w;
         vector .y = (x * this [3] + y * this [4] + this [5]) / w;

         return vector;
      }
      else
      {
         const { x, y, z } = vector;

         vector .x = x * this [0] + y * this [1] + z * this [2];
         vector .y = x * this [3] + y * this [4] + z * this [5];
         vector .z = x * this [6] + y * this [7] + z * this [8];

         return vector;
      }
   },
   multDirMatrix (vector)
   {
      const { x, y } = vector;

      vector .x = x * this [0] + y * this [3];
      vector .y = x * this [1] + y * this [4];

      return vector;
   },
   multMatrixDir (vector)
   {
      const { x, y } = vector;

      vector .x = x * this [0] + y * this [1];
      vector .y = x * this [3] + y * this [4];

      return vector;
   },
   identity ()
   {
      this [0] = 1; this [1] = 0; this [2] = 0;
      this [3] = 0; this [4] = 1; this [5] = 0;
      this [6] = 0; this [7] = 0; this [8] = 1;

      return this;
   },
   translate (translation)
   {
      const { x, y } = translation;

      this [6] += this [0] * x + this [3] * y;
      this [7] += this [1] * x + this [4] * y;

      return this;
   },
   rotate (rotation)
   {
      return this .multLeft (Matrix3 .fromRotation (rotation));
   },
   scale (scale)
   {
      const { x, y } = scale;

      this [0] *= x;
      this [3] *= y;

      this [1] *= x;
      this [4] *= y;

      return this;
   },
   skewX (angle)
   {
      const a = Math .tan (angle);

      this [3] += this [0] * a;
      this [4] += this [1] * a;
      this [5] += this [2] * a;

      return this;
   },
   skewY (angle)
   {
      const a = Math .tan (angle);

      this [0] += this [3] * a;
      this [1] += this [4] * a;
      this [2] += this [5] * a;

      return this;
   },
   toString ()
   {
      return Array .prototype .join .call (this, " ");
   },
});

for (const key of Object .keys (Matrix3 .prototype))
   Object .defineProperty (Matrix3 .prototype, key, { enumerable: false });

Object .defineProperties (Matrix3 .prototype,
{
   order: { value: 3 },
   length: { value: 9 },
   x:
   {
      get: (() =>
      {
         const vector = new Vector3/* default */.A ();

         return function () { return vector .set (this [0], this [1], this [2]); };
      })(),
   },
   y:
   {
      get: (() =>
      {
         const vector = new Vector3/* default */.A ();

         return function () { return vector .set (this [3], this [4], this [5]); };
      })(),
   },
   z:
   {
      get: (() =>
      {
         const vector = new Vector3/* default */.A ();

         return function () { return vector .set (this [6], this [7], this [8]); };
      })(),
   },
   xAxis:
   {
      get: (() =>
      {
         const vector = new Vector2/* default */.A ();

         return function () { return vector .set (this [0], this [1]); };
      })(),
   },
   yAxis:
   {
      get: (() =>
      {
         const vector = new Vector2/* default */.A ();

         return function () { return vector .set (this [3], this [4]); };
      })(),
   },
   origin:
   {
      get: (() =>
      {
         const vector = new Vector2/* default */.A ();

         return function () { return vector .set (this [6], this [7]); };
      })(),
   },
   submatrix:
   {
      get: (() =>
      {
         const matrix = new Numbers_Matrix2 ();

         return function ()
         {
            matrix [0] = this [0]; matrix [1] = this [1];
            matrix [2] = this [3]; matrix [3] = this [4];
            return matrix;
         };
      })(),
   },
});

Object .assign (Matrix3,
{
   IDENTITY: Object .freeze (new Matrix3 ()),
   fromRotation (rotation)
   {
      const
         sinAngle = Math .sin (rotation),
         cosAngle = Math .cos (rotation);

      return new Matrix3 ( cosAngle, sinAngle, 0,
                          -sinAngle, cosAngle, 0,
                           0, 0, 1);
   },
   fromMatrix2 (matrix)
   {
      return new Matrix3 (matrix [0], matrix [1], 0,
                          matrix [2], matrix [3], 0,
                          0, 0, 1);
   },
});

const m = new Matrix3 ();

const Matrix3_default_ = Matrix3;
;

/* harmony default export */ const Numbers_Matrix3 = (Namespace/* default */.A .add ("Matrix3", Matrix3_default_));

/***/ },

/***/ 6776
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Vector3_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(8655);
/* harmony import */ var _Vector4_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(4974);
/* harmony import */ var _Quaternion_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(6795);
/* harmony import */ var _Rotation4_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(9461);
/* harmony import */ var _Matrix3_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(3817);
/* harmony import */ var _Algorithms_eigen_decomposition_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(2973);
/* harmony import */ var _x_ite_Namespace_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(8427);







function Matrix4 (... args)
{
   if (args .length)
   {
      for (let i = 0; i < 16; ++ i)
         this [i] = args [i];
   }
   else
   {
      this .identity ();
   }
}

Object .assign (Matrix4 .prototype,
{
   *[Symbol .iterator] ()
   {
      for (let i = 0; i < 16; ++ i)
         yield this [i];
   },
   copy ()
   {
      const copy = Object .create (Matrix4 .prototype);

      for (let i = 0; i < 16; ++ i)
         copy [i] = this [i];

      return copy;
   },
   assign (matrix)
   {
      for (let i = 0; i < 16; ++ i)
         this [i] = matrix [i];

      return this;
   },
   equals (matrix)
   {
      return this [ 0] === matrix [ 0] &&
             this [ 1] === matrix [ 1] &&
             this [ 2] === matrix [ 2] &&
             this [ 3] === matrix [ 3] &&
             this [ 4] === matrix [ 4] &&
             this [ 5] === matrix [ 5] &&
             this [ 6] === matrix [ 6] &&
             this [ 7] === matrix [ 7] &&
             this [ 8] === matrix [ 8] &&
             this [ 9] === matrix [ 9] &&
             this [10] === matrix [10] &&
             this [11] === matrix [11] &&
             this [12] === matrix [12] &&
             this [13] === matrix [13] &&
             this [14] === matrix [14] &&
             this [15] === matrix [15];
   },
   set1 (r, c, value)
   {
      this [r * this .order + c] = value;

      return this;
   },
   get1 (r, c)
   {
      return this [r * this .order + c];
   },
   set: (() =>
   {
      const
         invScaleOrientation = new _Rotation4_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A (),
         invCenter           = new _Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A ();

      return function (translation, rotation, scale, scaleOrientation, center)
      {
         this .identity ();

         switch (arguments .length)
         {
            case 1:
            {
               if (translation && !translation .equals (_Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .ZERO))
                  this .translate (translation);

               break;
            }
            case 2:
            {
               if (translation && !translation .equals (_Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .ZERO))
                  this .translate (translation);

               if (rotation && !rotation .equals (_Rotation4_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .IDENTITY))
                  this .rotate (rotation);

               break;
            }
            case 3:
            {
               if (translation && !translation .equals (_Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .ZERO))
                  this .translate (translation);

               if (rotation && !rotation .equals (_Rotation4_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .IDENTITY))
                  this .rotate (rotation);

               if (scale && !scale .equals (_Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .ONE))
                  this .scale (scale);

               break;
            }
            case 4:
            {
               if (translation && !translation .equals (_Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .ZERO))
                  this .translate (translation);

               if (rotation && !rotation .equals (_Rotation4_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .IDENTITY))
                  this .rotate (rotation);

               if (scale && !scale .equals (_Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .ONE))
               {
                  if (scaleOrientation && !scaleOrientation .equals (_Rotation4_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .IDENTITY))
                  {
                     this .rotate (scaleOrientation);
                     this .scale (scale);
                     this .rotate (invScaleOrientation .assign (scaleOrientation) .inverse ());
                  }
                  else
                  {
                     this .scale (scale);
                  }
               }

               break;
            }
            case 5:
            {
               // P' = T * C * R * SR * S * -SR * -C * P
               if (translation && !translation .equals (_Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .ZERO))
                  this .translate (translation);

               const hasCenter = center && !center .equals (_Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .ZERO);

               if (hasCenter)
                  this .translate (center);

               if (rotation && !rotation .equals (_Rotation4_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .IDENTITY))
                  this .rotate (rotation);

               if (scale && !scale .equals (_Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .ONE))
               {
                  if (scaleOrientation && !scaleOrientation .equals (_Rotation4_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .IDENTITY))
                  {
                     this .rotate (scaleOrientation);
                     this .scale (scale);
                     this .rotate (invScaleOrientation .assign (scaleOrientation) .inverse ());
                  }
                  else
                  {
                     this .scale (scale);
                  }
               }

               if (hasCenter)
                  this .translate (invCenter .assign (center) .negate ());

               break;
            }
            case 16:
            {
               for (let i = 0; i < 16; ++ i)
                  this [i] = arguments [i];

               break;
            }
         }

         return this;
      };
   })(),
   get: (() =>
   {
      const c = new _Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A ();

      return function (translation, rotation, scale, scaleOrientation, center)
      {
         switch (arguments .length)
         {
            case 1:
            {
               translation .set (this [12], this [13], this [14]);
               break;
            }
            case 2:
            case 3:
            case 4:
            {
               this .factor (translation, rotation, scale, scaleOrientation);
               break;
            }
            case 5:
            {
               if (center)
               {
                  m .set (c .assign (center) .negate ());
                  m .multLeft (this);
                  m .translate (center);
                  m .get (translation, rotation, scale, scaleOrientation);
               }
               else
               {
                  this .factor (translation, rotation, scale, scaleOrientation);
               }

               break;
            }
         }
      };
   })(),
   setRotation (rotation)
   {
      return this .setQuaternion (rotation .getQuaternion (q));
   },
   setQuaternion (quaternion)
   {
      const
         { x, y, z, w } = quaternion,
         A = y * y,
         B = z * z,
         C = x * y,
         D = z * w,
         E = z * x,
         F = y * w,
         G = x * x,
         H = y * z,
         I = x * w;

      this [0]  = 1 - 2 * (A + B);
      this [1]  = 2 * (C + D);
      this [2]  = 2 * (E - F);
      this [3]  = 0;
      this [4]  = 2 * (C - D);
      this [5]  = 1 - 2 * (B + G);
      this [6]  = 2 * (H + I);
      this [7]  = 0;
      this [8]  = 2 * (E + F);
      this [9]  = 2 * (H - I);
      this [10] = 1 - 2 * (A + G);
      this [11] = 0;
      this [12] = 0;
      this [13] = 0;
      this [14] = 0;
      this [15] = 1;

      return this;
   },
   factor: (() =>
   {
      const
         s  = new _Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A (),
         si = new _Matrix3_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A (),
         so = new _Matrix3_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A (),
         b  = new _Matrix3_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A ();

      const eigen = { values: [ ], vectors: [[ ], [ ], [ ]] };

      return function (translation, rotation, scale, scaleOrientation)
      {
         // (1) Get translation.
         translation ?.set (this [12], this [13], this [14]);

         // (2) Create 3x3 matrix.
         const a = this .submatrix;

         // (3) Compute det A. If negative, set sign = -1, else sign = 1
         const det      = a .determinant ();
         const det_sign = det < 0 ? -1 : 1;

         // (4) B = A * !A  (here !A means A transpose)
         b .assign (a) .transpose () .multLeft (a);
         const e = (0,_Algorithms_eigen_decomposition_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A) (b, eigen);

         // Find min / max eigenvalues and do ratio test to determine singularity.

         so .set (e .vectors [0] [0], e .vectors [1] [0], e .vectors [2] [0],
                  e .vectors [0] [1], e .vectors [1] [1], e .vectors [2] [1],
                  e .vectors [0] [2], e .vectors [1] [2], e .vectors [2] [2]);

         scaleOrientation ?.setMatrix (so);

         // Compute s = sqrt(eigen values), with sign. Set si = s-inverse

         s .set (det_sign * Math .sqrt (e .values [0]),
                 det_sign * Math .sqrt (e .values [1]),
                 det_sign * Math .sqrt (e .values [2]));

         scale ?.assign (s);

         if (rotation)
         {
            si [0] = 1 / s .x;
            si [4] = 1 / s .y;
            si [8] = 1 / s .z;

            // (5) Compute U = !R ~S R A.
            rotation .setMatrix (a .multLeft (so) .multLeft (si) .multLeft (so .transpose ()));
         }
      };
   })(),
   determinant3 ()
   {
      const { 0: m00, 1: m01, 2: m02,
              4: m04, 5: m05, 6: m06,
              8: m08, 9: m09, 10: m10 } = this;

      return m00 * (m05 * m10 - m06 * m09) -
             m01 * (m04 * m10 - m06 * m08) +
             m02 * (m04 * m09 - m05 * m08);
   },
   determinant ()
   {
      const
         { 0: m00, 1: m01, 2: m02, 3: m03, 4: m04, 5: m05, 6: m06, 7: m07,
           8: m08, 9: m09, 10: m10, 11: m11, 12: m12, 13: m13, 14: m14, 15: m15 } = this,
         b = m10 * m15,
         c = m14 * m11,
         d = m06 * m15,
         e = m14 * m07,
         f = m06 * m11,
         g = m10 * m07,
         h = m02 * m15,
         i = m14 * m03,
         j = m02 * m11,
         o = m10 * m03,
         r = m02 * m07,
         x = m06 * m03,
         H = b * m05 + e * m09 + f * m13 - (c * m05) - (d * m09) - (g * m13),
         I = c * m01 + h * m09 + o * m13 - (b * m01) - (i * m09) - (j * m13),
         J = d * m01 + i * m05 + r * m13 - (e * m01) - (h * m05) - (x * m13),
         K = g * m01 + j * m05 + x * m09 - (f * m01) - (o * m05) - (r * m09);

      return m00 * H + m04 * I + m08 * J + m12 * K;
   },
   transpose ()
   {
      let tmp;

      tmp = this [ 1]; this [ 1] = this [ 4]; this [ 4] = tmp;
      tmp = this [ 2]; this [ 2] = this [ 8]; this [ 8] = tmp;
      tmp = this [ 3]; this [ 3] = this [12]; this [12] = tmp;
      tmp = this [ 6]; this [ 6] = this [ 9]; this [ 9] = tmp;
      tmp = this [ 7]; this [ 7] = this [13]; this [13] = tmp;
      tmp = this [11]; this [11] = this [14]; this [14] = tmp;

      return this;
   },
   inverse ()
   {
      // Complexity 43 +, 40 -, 140 *. 1 /

      const
         { 0: m00, 1: m01, 2: m02, 3: m03, 4: m04, 5: m05, 6: m06, 7: m07,
           8: m08, 9: m09, 10: m10, 11: m11, 12: m12, 13: m13, 14: m14, 15: m15 } = this,
         b = m10 * m15,
         c = m14 * m11,
         d = m06 * m15,
         e = m14 * m07,
         f = m06 * m11,
         g = m10 * m07,
         h = m02 * m15,
         i = m14 * m03,
         j = m02 * m11,
         o = m10 * m03,
         r = m02 * m07,
         x = m06 * m03,
         t = m08 * m13,
         p = m12 * m09,
         v = m04 * m13,
         s = m12 * m05,
         y = m04 * m09,
         z = m08 * m05,
         A = m00 * m13,
         C = m12 * m01,
         D = m00 * m09,
         E = m08 * m01,
         F = m00 * m05,
         G = m04 * m01,
         H = b * m05 + e * m09 + f * m13 - ((c * m05) + (d * m09) + (g * m13)),
         I = c * m01 + h * m09 + o * m13 - ((b * m01) + (i * m09) + (j * m13)),
         J = d * m01 + i * m05 + r * m13 - ((e * m01) + (h * m05) + (x * m13)),
         K = g * m01 + j * m05 + x * m09 - ((f * m01) + (o * m05) + (r * m09));

      let B = m00 * H + m04 * I + m08 * J + m12 * K;

      // if (B === 0) ... determinant is zero.

      B = 1 / B;

      this [ 0] = B * H;
      this [ 1] = B * I;
      this [ 2] = B * J;
      this [ 3] = B * K;
      this [ 4] = B * (c * m04 + d * m08 + g * m12 - (b * m04) - (e * m08) - (f * m12));
      this [ 5] = B * (b * m00 + i * m08 + j * m12 - (c * m00) - (h * m08) - (o * m12));
      this [ 6] = B * (e * m00 + h * m04 + x * m12 - (d * m00) - (i * m04) - (r * m12));
      this [ 7] = B * (f * m00 + o * m04 + r * m08 - (g * m00) - (j * m04) - (x * m08));
      this [ 8] = B * (t * m07 + s * m11 + y * m15 - (p * m07) - (v * m11) - (z * m15));
      this [ 9] = B * (p * m03 + A * m11 + E * m15 - (t * m03) - (C * m11) - (D * m15));
      this [10] = B * (v * m03 + C * m07 + F * m15 - (s * m03) - (A * m07) - (G * m15));
      this [11] = B * (z * m03 + D * m07 + G * m11 - (y * m03) - (E * m07) - (F * m11));
      this [12] = B * (v * m10 + z * m14 + p * m06 - (y * m14) - (t * m06) - (s * m10));
      this [13] = B * (D * m14 + t * m02 + C * m10 - (A * m10) - (E * m14) - (p * m02));
      this [14] = B * (A * m06 + G * m14 + s * m02 - (F * m14) - (v * m02) - (C * m06));
      this [15] = B * (F * m10 + y * m02 + E * m06 - (D * m06) - (G * m10) - (z * m02));

      return this;
   },
   multLeft (matrix)
   {
      // Complexity 48 +, 64 *.

      const {
         0:  a00, 1:  a01, 2:  a02, 3:  a03,
         4:  a04, 5:  a05, 6:  a06, 7:  a07,
         8:  a08, 9:  a09, 10: a10, 11: a11,
         12: a12, 13: a13, 14: a14, 15: a15
      } = this;

      var { 0: b0, 1: b1, 2: b2, 3: b3 } = matrix;

      this [ 0] = a00 * b0 + a04 * b1 + a08 * b2 + a12 * b3;
      this [ 1] = a01 * b0 + a05 * b1 + a09 * b2 + a13 * b3;
      this [ 2] = a02 * b0 + a06 * b1 + a10 * b2 + a14 * b3;
      this [ 3] = a03 * b0 + a07 * b1 + a11 * b2 + a15 * b3;

      var { 4: b0, 5: b1, 6: b2, 7: b3 } = matrix;

      this [ 4] = a00 * b0 + a04 * b1 + a08 * b2 + a12 * b3;
      this [ 5] = a01 * b0 + a05 * b1 + a09 * b2 + a13 * b3;
      this [ 6] = a02 * b0 + a06 * b1 + a10 * b2 + a14 * b3;
      this [ 7] = a03 * b0 + a07 * b1 + a11 * b2 + a15 * b3;

      var { 8: b0, 9: b1, 10: b2, 11: b3 } = matrix;

      this [ 8] = a00 * b0 + a04 * b1 + a08 * b2 + a12 * b3;
      this [ 9] = a01 * b0 + a05 * b1 + a09 * b2 + a13 * b3;
      this [10] = a02 * b0 + a06 * b1 + a10 * b2 + a14 * b3;
      this [11] = a03 * b0 + a07 * b1 + a11 * b2 + a15 * b3;

      var { 12: b0, 13: b1, 14: b2, 15: b3 } = matrix;

      this [12] = a00 * b0 + a04 * b1 + a08 * b2 + a12 * b3;
      this [13] = a01 * b0 + a05 * b1 + a09 * b2 + a13 * b3;
      this [14] = a02 * b0 + a06 * b1 + a10 * b2 + a14 * b3;
      this [15] = a03 * b0 + a07 * b1 + a11 * b2 + a15 * b3;

      return this;
   },
   multRight (matrix)
   {
      // Complexity 48 +, 64 *.

      const {
         0:  b00, 1:  b01, 2:  b02, 3:  b03,
         4:  b04, 5:  b05, 6:  b06, 7:  b07,
         8:  b08, 9:  b09, 10: b10, 11: b11,
         12: b12, 13: b13, 14: b14, 15: b15
      } = matrix;

      var { 0: a0, 1: a1, 2: a2, 3: a3 } = this;

      this [ 0] = a0 * b00 + a1 * b04 + a2 * b08 + a3 * b12;
      this [ 1] = a0 * b01 + a1 * b05 + a2 * b09 + a3 * b13;
      this [ 2] = a0 * b02 + a1 * b06 + a2 * b10 + a3 * b14;
      this [ 3] = a0 * b03 + a1 * b07 + a2 * b11 + a3 * b15;

      var { 4: a0, 5: a1, 6: a2, 7: a3 } = this;

      this [ 4] = a0 * b00 + a1 * b04 + a2 * b08 + a3 * b12;
      this [ 5] = a0 * b01 + a1 * b05 + a2 * b09 + a3 * b13;
      this [ 6] = a0 * b02 + a1 * b06 + a2 * b10 + a3 * b14;
      this [ 7] = a0 * b03 + a1 * b07 + a2 * b11 + a3 * b15;

      var { 8: a0, 9: a1, 10: a2, 11: a3 } = this;

      this [ 8] = a0 * b00 + a1 * b04 + a2 * b08 + a3 * b12;
      this [ 9] = a0 * b01 + a1 * b05 + a2 * b09 + a3 * b13;
      this [10] = a0 * b02 + a1 * b06 + a2 * b10 + a3 * b14;
      this [11] = a0 * b03 + a1 * b07 + a2 * b11 + a3 * b15;

      var { 12: a0, 13: a1, 14: a2, 15: a3 } = this;

      this [12] = a0 * b00 + a1 * b04 + a2 * b08 + a3 * b12;
      this [13] = a0 * b01 + a1 * b05 + a2 * b09 + a3 * b13;
      this [14] = a0 * b02 + a1 * b06 + a2 * b10 + a3 * b14;
      this [15] = a0 * b03 + a1 * b07 + a2 * b11 + a3 * b15;

      return this;
   },
   multVecMatrix (vector)
   {
      if (vector .length === 3)
      {
         const
            { x, y, z } = vector,
            w = 1 / (x * this [3] + y * this [7] + z * this [11] + this [15]);

         vector .x = (x * this [0] + y * this [4] + z * this [ 8] + this [12]) * w;
         vector .y = (x * this [1] + y * this [5] + z * this [ 9] + this [13]) * w;
         vector .z = (x * this [2] + y * this [6] + z * this [10] + this [14]) * w;

         return vector;
      }
      else
      {
         const { x, y, z, w } = vector;

         vector .x = x * this [0] + y * this [4] + z * this [ 8] + w * this [12];
         vector .y = x * this [1] + y * this [5] + z * this [ 9] + w * this [13];
         vector .z = x * this [2] + y * this [6] + z * this [10] + w * this [14];
         vector .w = x * this [3] + y * this [7] + z * this [11] + w * this [15];

         return vector;
      }
   },
   multMatrixVec (vector)
   {
      if (vector .length === 3)
      {
         const
            { x, y, z } = vector,
            w = 1 / (x * this [12] + y * this [13] + z * this [14] + this [15]);

         vector .x = (x * this [0] + y * this [1] + z * this [ 2] + this [ 3]) * w;
         vector .y = (x * this [4] + y * this [5] + z * this [ 6] + this [ 7]) * w;
         vector .z = (x * this [8] + y * this [9] + z * this [10] + this [11]) * w;

         return vector;
      }
      else
      {
         const { x, y, z, w } = vector;

         vector .x = x * this [ 0] + y * this [ 1] + z * this [ 2] + w * this [ 3];
         vector .y = x * this [ 4] + y * this [ 5] + z * this [ 6] + w * this [ 7];
         vector .z = x * this [ 8] + y * this [ 9] + z * this [10] + w * this [11];
         vector .w = x * this [12] + y * this [13] + z * this [14] + w * this [15];

         return vector;
      }
   },
   multDirMatrix (vector)
   {
      const { x, y, z } = vector;

      vector .x = x * this [0] + y * this [4] + z * this [ 8];
      vector .y = x * this [1] + y * this [5] + z * this [ 9];
      vector .z = x * this [2] + y * this [6] + z * this [10];

      return vector;
   },
   multMatrixDir (vector)
   {
      const { x, y, z } = vector;

      vector .x = x * this [0] + y * this [1] + z * this [ 2];
      vector .y = x * this [4] + y * this [5] + z * this [ 6];
      vector .z = x * this [8] + y * this [9] + z * this [10];

      return vector;
   },
   identity ()
   {
      this [ 0] = 1; this [ 1] = 0; this [ 2] = 0; this [ 3] = 0;
      this [ 4] = 0; this [ 5] = 1; this [ 6] = 0; this [ 7] = 0;
      this [ 8] = 0; this [ 9] = 0; this [10] = 1; this [11] = 0;
      this [12] = 0; this [13] = 0; this [14] = 0; this [15] = 1;

      return this;
   },
   translate (translation)
   {
      const { x, y, z } = translation;

      this [12] += this [ 0] * x + this [ 4] * y + this [ 8] * z;
      this [13] += this [ 1] * x + this [ 5] * y + this [ 9] * z;
      this [14] += this [ 2] * x + this [ 6] * y + this [10] * z;

      return this;
   },
   rotate (rotation)
   {
      return this .multLeft (m .setQuaternion (rotation .getQuaternion (q)));
   },
   scale (scale)
   {
      const { x, y, z } = scale;

      this [ 0] *= x;
      this [ 4] *= y;
      this [ 8] *= z;

      this [ 1] *= x;
      this [ 5] *= y;
      this [ 9] *= z;

      this [ 2] *= x;
      this [ 6] *= y;
      this [10] *= z;

      return this;
   },
   toString ()
   {
      return Array .prototype .join .call (this, " ");
   },
});

for (const key of Object .keys (Matrix4 .prototype))
   Object .defineProperty (Matrix4 .prototype, key, { enumerable: false });

Object .defineProperties (Matrix4 .prototype,
{
   order: { value: 4 },
   length: { value: 16 },
   x:
   {
      get: (() =>
      {
         const vector = new _Vector4_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A ();

         return function () { return vector .set (this [0], this [1], this [2], this [3]); };
      })(),
   },
   y:
   {
      get: (() =>
      {
         const vector = new _Vector4_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A ();

         return function () { return vector .set (this [4], this [5], this [6], this [7]); };
      })(),
   },
   z:
   {
      get: (() =>
      {
         const vector = new _Vector4_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A ();

         return function () { return vector .set (this [8], this [9], this [10], this [11]); };
      })(),
   },
   w:
   {
      get: (() =>
      {
         const vector = new _Vector4_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A ();

         return function () { return vector .set (this [12], this [13], this [14], this [15]); };
      })(),
   },
   xAxis:
   {
      get: (() =>
      {
         const vector = new _Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A ();

         return function () { return vector .set (this [0], this [1], this [2]); };
      })(),
   },
   yAxis:
   {
      get: (() =>
      {
         const vector = new _Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A ();

         return function () { return vector .set (this [4], this [5], this [6]); };
      })(),
   },
   zAxis:
   {
      get: (() =>
      {
         const vector = new _Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A ();

         return function () { return vector .set (this [8], this [9], this [10]); };
      })(),
   },
   origin:
   {
      get: (() =>
      {
         const vector = new _Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A ();

         return function () { return vector .set (this [12], this [13], this [14]); };
      })(),
   },
   submatrix:
   {
      get: (() =>
      {
         const matrix = new _Matrix3_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A ();

         return function ()
         {
            matrix [0] = this [0]; matrix [1] = this [1]; matrix [2] = this [ 2];
            matrix [3] = this [4]; matrix [4] = this [5]; matrix [5] = this [ 6];
            matrix [6] = this [8]; matrix [7] = this [9]; matrix [8] = this [10];
            return matrix;
         };
      })(),
   },
});

Object .assign (Matrix4,
{
   IDENTITY: Object .freeze (new Matrix4 ()),
   fromRotation (rotation)
   {
      return Object .create (this .prototype) .setQuaternion (rotation .getQuaternion (q));
   },
   fromQuaternion (quaternion)
   {
      return Object .create (this .prototype) .setQuaternion (quaternion);
   },
   fromMatrix3 (matrix)
   {
      return new Matrix4 (matrix [0], matrix [1], 0, 0,
                          matrix [3], matrix [4], 0, 0,
                          0, 0, 1, 0,
                          matrix [6], matrix [7], 0, 1);
   },
   fromSubMatrix (matrix)
   {
      return new Matrix4 (matrix [0], matrix [1], matrix [2], 0,
                          matrix [3], matrix [4], matrix [5], 0,
                          matrix [6], matrix [7], matrix [8], 0,
                          0, 0, 0, 1);
   },
});

const
   q = new _Quaternion_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A (),
   m = new Matrix4 ();

const __default__ = Matrix4;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_x_ite_Namespace_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .add ("Matrix4", __default__));

/***/ },

/***/ 6795
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Vector3_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(8655);
/* harmony import */ var _Matrix3_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(3817);
/* harmony import */ var _Algorithm_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(9919);
/* harmony import */ var _x_ite_Namespace_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(8427);




function Quaternion (x = 0, y = 0, z = 0, w = 1)
{
   this .x = x;
   this .y = y;
   this .z = z;
   this .w = w;
}

Object .assign (Quaternion .prototype,
{
   *[Symbol .iterator] ()
   {
      yield this .x;
      yield this .y;
      yield this .z;
      yield this .w;
   },
   copy ()
   {
      const copy = Object .create (Quaternion .prototype);
      copy .x = this .x;
      copy .y = this .y;
      copy .z = this .z;
      copy .w = this .w;
      return copy;
   },
   assign ({ x, y, z, w })
   {
      this .x = x;
      this .y = y;
      this .z = z;
      this .w = w;
      return this;
   },
   set (x = 0, y = 0, z = 0, w = 1)
   {
      this .x = x;
      this .y = y;
      this .z = z;
      this .w = w;
      return this;
   },
   setMatrix (matrix)
   {
      // First, find largest diagonal in matrix:

      const i = matrix [0] > matrix [4]
         ? matrix [0] > matrix [8] ? 0 : 2
         : matrix [4] > matrix [8] ? 1 : 2;

      const scaleRow = matrix [0] + matrix [4] + matrix [8];

      if (scaleRow > matrix [i * 3 + i])
      {
         // Compute w first:
         this [3] = Math .sqrt (scaleRow + 1) / 2;

         // And compute other values:
         const d = 4 * this [3];
         this [0] = (matrix [5] - matrix [7]) / d;
         this [1] = (matrix [6] - matrix [2]) / d;
         this [2] = (matrix [1] - matrix [3]) / d;
      }
      else
      {
         // Compute x, y, or z first:
         const j = (i + 1) % 3;
         const k = (i + 2) % 3;

         // Compute first value:
         this [i] = Math .sqrt (matrix [i * 3 + i] - matrix [j * 3 + j] - matrix [k * 3 + k] + 1) / 2;

         // And the others:
         const d = 4 * this [i];
         this [j] = (matrix [i * 3 + j] + matrix [j * 3 + i]) / d;
         this [k] = (matrix [i * 3 + k] + matrix [k * 3 + i]) / d;
         this [3] = (matrix [j * 3 + k] - matrix [k * 3 + j]) / d;
      }

      return this;
   },
   getMatrix (matrix = new _Matrix3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A ())
   {
      const { x, y, z, w } = this;

      const
         a = x * x,
         b = x * y,
         c = y * y,
         d = y * z,
         e = z * x,
         f = z * z,
         g = w * x,
         h = w * y,
         i = w * z;

      matrix [0] = 1 - 2 * (c + f);
      matrix [1] =     2 * (b + i);
      matrix [2] =     2 * (e - h);

      matrix [3] =     2 * (b - i);
      matrix [4] = 1 - 2 * (f + a);
      matrix [5] =     2 * (d + g);

      matrix [6] =     2 * (e + h);
      matrix [7] =     2 * (d - g);
      matrix [8] = 1 - 2 * (c + a);

      return matrix;
   },
   /**
    * Sets the Euler components.
    * @param {number} x - The angle of the x axis in radians.
    * @param {number} y - The angle of the y axis in radians.
    * @param {number} z - The angle of the z axis in radians.
    * @param {string} order - A string representing the order that the rotations are applied.
    * @returns {Quaternion} A reference to this quaternion.
    */
   setEuler (x, y, z, order = "XYZ")
   {
      // https://github.com/toji/gl-matrix/blob/accefb6ddf1897a0dc443bbc7664c90e67af6455/src/quat.js#L460

      x /= 2;
      y /= 2;
      z /= 2;

      const
         sx = Math .sin (x),
         sy = Math .sin (y),
         sz = Math .sin (z),
         cx = Math .cos (x),
         cy = Math .cos (y),
         cz = Math .cos (z);

      switch (order)
      {
         case "XYZ":
            this .x = sx * cy * cz + cx * sy * sz;
            this .y = cx * sy * cz - sx * cy * sz;
            this .z = cx * cy * sz + sx * sy * cz;
            this .w = cx * cy * cz - sx * sy * sz;
            break;

         case "ZYX":
            this .x = sx * cy * cz - cx * sy * sz;
            this .y = cx * sy * cz + sx * cy * sz;
            this .z = cx * cy * sz - sx * sy * cz;
            this .w = cx * cy * cz + sx * sy * sz;
            break;

         case "YXZ":
            this .x = sx * cy * cz + cx * sy * sz;
            this .y = cx * sy * cz - sx * cy * sz;
            this .z = cx * cy * sz - sx * sy * cz;
            this .w = cx * cy * cz + sx * sy * sz;
            break;

         case "ZXY":
            this .x = sx * cy * cz - cx * sy * sz;
            this .y = cx * sy * cz + sx * cy * sz;
            this .z = cx * cy * sz + sx * sy * cz;
            this .w = cx * cy * cz - sx * sy * sz;
            break;

         case "YZX":
            this .x = sx * cy * cz + cx * sy * sz;
            this .y = cx * sy * cz + sx * cy * sz;
            this .z = cx * cy * sz - sx * sy * cz;
            this .w = cx * cy * cz - sx * sy * sz;
            break;

         case "XZY":
            this .x = sx * cy * cz - cx * sy * sz;
            this .y = cx * sy * cz - sx * cy * sz;
            this .z = cx * cy * sz + sx * sy * cz;
            this .w = cx * cy * cz + sx * sy * sz;
            break;
      }

      return this;
   },
   /**
    * Gets the Euler components.
    * @param {number[]} euler - Array to be returned.
    * @param {string} order - A string representing the order that the rotations are applied.
    * @returns {number[]} The angles of the Euler rotations in radians.
    */
   getEuler (euler = [ ], order = "XYZ")
   {
      // https://github.com/mrdoob/three.js/blob/7a4f6b6637fbf10f1f36c9bb1f34b32452e516c6/src/math/Euler.js#L189

      const { 0: m0, 1: m1, 2: m2, 3: m3, 4: m4, 5: m5, 6: m6, 7: m7, 8: m8 } = this .getMatrix (m);

      switch (order)
      {
         case "XYZ":
         {
            euler [1] = Math .asin (_Algorithm_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .clamp (m6, -1, 1));

            if (Math .abs (m6) < 0.9999999)
            {
               euler [0] = Math .atan2 (-m7, m8);
               euler [2] = Math .atan2 (-m3, m0);
            }
            else
            {
               euler [0] = Math .atan2 (m5, m4);
               euler [2] = 0;
            }

            break;
         }
         case "ZYX":
         {
            euler [1] = Math .asin (-_Algorithm_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .clamp (m2, -1, 1));

            if (Math .abs (m2) < 0.9999999)
            {
               euler [0] = Math .atan2 (m5, m8);
               euler [2] = Math .atan2 (m1, m0);
            }
            else
            {
               euler [0] = 0;
               euler [2] = Math .atan2 (-m3, m4);
            }

            break;
         }
         case "YXZ":
         {
            euler [0] = Math .asin (-_Algorithm_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .clamp (m7, -1, 1));

            if (Math .abs (m7) < 0.9999999)
            {
               euler [1] = Math .atan2 (m6, m8);
               euler [2] = Math .atan2 (m1, m4);

            }
            else
            {
               euler [1] = Math .atan2 (-m2, m0);
               euler [2] = 0;
            }

            break;
         }
         case "ZXY":
         {
            euler [0] = Math .asin (_Algorithm_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .clamp (m5, -1, 1));

            if (Math .abs (m5) < 0.9999999)
            {
               euler [1] = Math .atan2 (-m2, m8);
               euler [2] = Math .atan2 (-m3, m4);
            }
            else
            {
               euler [1] = 0;
               euler [2] = Math .atan2 (m1, m0);
            }

            break;
         }
         case "YZX":
         {
            euler [2] = Math .asin (_Algorithm_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .clamp (m1, -1, 1));

            if (Math .abs (m1) < 0.9999999)
            {
               euler [0] = Math .atan2 (-m7, m4);
               euler [1] = Math .atan2 (-m2, m0);
            }
            else
            {
               euler [0] = 0;
               euler [1] = Math .atan2 (m6, m8);
            }

            break;
         }
         case "XZY":
         {
            euler [2] = Math .asin (-_Algorithm_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .clamp (m3, -1, 1));

            if (Math .abs (m3) < 0.9999999)
            {
               euler [0] = Math .atan2 (m5, m4);
               euler [1] = Math .atan2 (m6, m0);

            }
            else
            {
               euler [0] = Math .atan2 (-m7, m8);
               euler [1] = 0;
            }

            break;
         }
      }

      return euler;
   },
   isReal ()
   {
      return !(this .x || this .y || this .z);
   },
   isImag ()
   {
      return !this .w;
   },
   equals ({ x, y, z, w })
   {
      return this .x === x &&
             this .y === y &&
             this .z === z &&
             this .w === w;
   },
   negate ()
   {
      this .x = -this .x;
      this .y = -this .y;
      this .z = -this .z;
      this .w = -this .w;
      return this;
   },
   inverse ()
   {
      this .x = -this .x;
      this .y = -this .y;
      this .z = -this .z;
      return this;
   },
   add ({ x, y, z, w })
   {
      this .x += x;
      this .y += y;
      this .z += z;
      this .w += w;
      return this;
   },
   subtract ({ x, y, z, w })
   {
      this .x -= x;
      this .y -= y;
      this .z -= z;
      this .w -= w;
      return this;
   },
   multiply (value)
   {
      this .x *= value;
      this .y *= value;
      this .z *= value;
      this .w *= value;
      return this;
   },
   multLeft (quat)
   {
      const
         { x: ax, y: ay, z: az, w: aw } = this,
         { x: bx, y: by, z: bz, w: bw } = quat;

      this .x = aw * bx + ax * bw + ay * bz - az * by;
      this .y = aw * by + ay * bw + az * bx - ax * bz;
      this .z = aw * bz + az * bw + ax * by - ay * bx;
      this .w = aw * bw - ax * bx - ay * by - az * bz;

      return this;
   },
   multRight (quat)
   {
      const
         { x: ax, y: ay, z: az, w: aw } = this,
         { x: bx, y: by, z: bz, w: bw } = quat;

      this .x = bw * ax + bx * aw + by * az - bz * ay;
      this .y = bw * ay + by * aw + bz * ax - bx * az;
      this .z = bw * az + bz * aw + bx * ay - by * ax;
      this .w = bw * aw - bx * ax - by * ay - bz * az;

      return this;
   },
   divide (value)
   {
      this .x /= value;
      this .y /= value;
      this .z /= value;
      this .w /= value;
      return this;
   },
   multVecQuat (vector)
   {
      // https://en.wikipedia.org/wiki/Conversion_between_quaternions_and_Euler_angles#Vector_rotation

      const
         { x: qx, y: qy, z: qz, w: qw } = this,
         { x: vx, y: vy, z: vz } = vector,
         tx = 2 * (qy * vz - qz * vy),
         ty = 2 * (qz * vx - qx * vz),
         tz = 2 * (qx * vy - qy * vx);

      vector .x += qw * tx + qy * tz - qz * ty;
      vector .y += qw * ty + qz * tx - qx * tz;
      vector .z += qw * tz + qx * ty - qy * tx;

      return vector;
   },
   multQuatVec (vector)
   {
      // https://en.wikipedia.org/wiki/Conversion_between_quaternions_and_Euler_angles#Vector_rotation

      const
         { x: qx, y: qy, z: qz, w: qw } = this,
         { x: vx, y: vy, z: vz } = vector,
         tx = 2 * (qz * vy - qy * vz),
         ty = 2 * (qx * vz - qz * vx),
         tz = 2 * (qy * vx - qx * vy);

      vector .x += qw * tx - qy * tz + qz * ty;
      vector .y += qw * ty - qz * tx + qx * tz;
      vector .z += qw * tz - qx * ty + qy * tx;

      return vector;
   },
   normalize ()
   {
      const length = Math .hypot (this .x, this .y, this .z, this .w);

      if (length)
      {
         this .x /= length;
         this .y /= length;
         this .z /= length;
         this .w /= length;
      }

      return this;
   },
   dot (quat)
   {
      return this .x * quat .x +
             this .y * quat .y +
             this .z * quat .z +
             this .w * quat .w;
   },
   squaredNorm ()
   {
      const { x, y, z, w } = this;

      return x * x +
             y * y +
             z * z +
             w * w;
   },
   norm ()
   {
      return Math .hypot (this .x, this .y, this .z, this .w);
   },
   pow (exponent)
   {
      if (exponent instanceof Quaternion)
         return this .assign (e .assign (exponent) .multRight (this .log ()) .exp ());

      if (this .isReal ())
         return this .set (0, 0, 0, this .w ** exponent);

      const
         l     = this .norm (),
         theta = Math .acos (this .w / l),
         li    = this .imag .norm (),
         ltoe  = l ** exponent,
         et    = exponent * theta,
         scale = ltoe / li * Math .sin (et);

      this .x *= scale;
      this .y *= scale;
      this .z *= scale;
      this .w  = ltoe * Math .cos (et);
      return this;
   },
   log ()
   {
      if (this .isReal ())
      {
         if (this .w > 0)
            return this .set (0, 0, 0, Math .log (this .w));

         else
            return this .set (Math .PI, 0, 0, Math .log (-this .w));
      }

      const
         l = this .norm (),
         v = this .imag .normalize () .multiply (Math .acos (this .w / l)),
         w = Math .log (l);

      this .x = v .x;
      this .y = v .y;
      this .z = v .z;
      this .w = w;
      return this;
   },
   exp ()
   {
      if (this .isReal ())
         return this .set (0, 0, 0, Math .exp (this .w));

      const
         i  = this .imag,
         li = i .norm (),
         ew = Math .exp (this .w),
         w  = ew * Math .cos (li),
         v  = i .multiply (ew * Math .sin (li) / li);

      this .x = v .x;
      this .y = v .y;
      this .z = v .z;
      this .w = w;
      return this;
   },
   slerp (destination, t)
   {
      return _Algorithm_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .slerp (this, t1 .assign (destination), t);
   },
   squad (a, b, destination, t)
   {
      // Ken Shoemake defines Squad as:
      // We must use shortest path slerp to prevent flipping. See also spline below.
      // a = spline (si-1, si, si+1) and b = spline (di-1, di, di+1), where si = source and di = destination

      return _Algorithm_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .slerp (_Algorithm_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .slerp (this, t1 .assign (destination), t),
                               _Algorithm_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .slerp (t2 .assign (a), t3 .assign (b), t),
                               2 * t * (1 - t));
   },
   toString ()
   {
      return this .x + " " +
             this .y + " " +
             this .z + " " +
             this .w;
   },
});

for (const key of Object .keys (Quaternion .prototype))
   Object .defineProperty (Quaternion .prototype, key, { enumerable: false });

Object .defineProperties (Quaternion .prototype,
{
   length: { value: 4 },
   0:
   {
      get () { return this .x; },
      set (value) { this .x = value; },
   },
   1:
   {
      get () { return this .y; },
      set (value) { this .y = value; },
   },
   2:
   {
      get () { return this .z; },
      set (value) { this .z = value; },
   },
   3:
   {
      get () { return this .w; },
      set (value) { this .w = value; },
   },
   real:
   {
      get () { return this .w; },
   },
   imag:
   {
      get: (() =>
      {
         const result = new _Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A ();

         return function ()
         {
            return result .set (this .x,
                                this .y,
                                this .z);
         };
      })(),
   },
});

Object .assign (Quaternion,
{
   IDENTITY: Object .freeze (new Quaternion ()),
   spline: (() =>
   {
      const
         q0   = new Quaternion (),
         q1   = new Quaternion (),
         q2   = new Quaternion (),
         q1_i = new Quaternion ();

      return function (Q0, Q1, Q2)
      {
         q0 .assign (Q0);
         q1 .assign (Q1);
         q2 .assign (Q2);

         // If the dot product is smaller than 0 we must negate the quaternion to prevent flipping. If we negate all
         // the terms we get a different quaternion but it represents the same rotation.

         if (q0 .dot (q1) < 0)
            q0 .negate ();

         if (q2 .dot (q1) < 0)
            q2 .negate ();

         q1_i .assign (q1) .inverse ();

         // The result must be normalized as it will be used in slerp and we can only slerp normalized vectors.

         return q1 .multRight (
            t1 .assign (q1_i) .multRight (q0) .log () .add (t2 .assign (q1_i) .multRight (q2) .log ()) .divide (-4) .exp ()
         )
         .normalize () .copy ();
      };
   })(),
});

const
   t1 = new Quaternion (),
   t2 = new Quaternion (),
   t3 = new Quaternion (),
   m  = new _Matrix3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A ();

const __default__ = Quaternion;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_x_ite_Namespace_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .add ("Quaternion", __default__));

/***/ },

/***/ 9461
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Quaternion_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6795);
/* harmony import */ var _Vector3_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(8655);
/* harmony import */ var _Vector4_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(4974);
/* harmony import */ var _Matrix3_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(3817);
/* harmony import */ var _Algorithm_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(9919);
/* harmony import */ var _x_ite_Namespace_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(8427);






const
   _x          = Symbol (),
   _y          = Symbol (),
   _z          = Symbol (),
   _angle      = Symbol (),
   _quaternion = Symbol ();

function Rotation4 (x, y, z, angle)
{
   this [_x]     = 0;
   this [_y]     = 0;
   this [_z]     = 1;
   this [_angle] = 0;

   switch (arguments .length)
   {
      case 0:
      {
         this [_quaternion] = new _Quaternion_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A ();
         return;
      }
      case 1:
      {
         this [_quaternion] = arguments [0];
         this .update ();
         return;
      }
      case 2:
      {
         const
            arg0 = arguments [0],
            arg1 = arguments [1];

         this [_quaternion] = new _Quaternion_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A ();

         if (arg1 instanceof _Vector3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A)
            return this .setFromToVec (arg0, arg1);

         this .set (arg0 .x,
                    arg0 .y,
                    arg0 .z,
                    arg1);

         return;
      }
      case 4:
      {
         this [_quaternion] = new _Quaternion_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A ();
         this .set (x, y, z, angle);
         return;
      }
   }
}

Object .assign (Rotation4 .prototype,
{
   *[Symbol .iterator] ()
   {
      yield this [_x];
      yield this [_y];
      yield this [_z];
      yield this [_angle];
   },
   update ()
   {
      const rotation = this .get ();

      this [_x]     = rotation .x;
      this [_y]     = rotation .y;
      this [_z]     = rotation .z;
      this [_angle] = rotation .w;

      return this;
   },
   copy ()
   {
      const copy = Object .create (Rotation4 .prototype);

      copy [_x]     = this [_x];
      copy [_y]     = this [_y];
      copy [_z]     = this [_z];
      copy [_angle] = this [_angle];

      copy [_quaternion] = this [_quaternion] .copy ();

      return copy;
   },
   assign (rotation)
   {
      this [_x]     = rotation [_x];
      this [_y]     = rotation [_y];
      this [_z]     = rotation [_z];
      this [_angle] = rotation [_angle];

      this [_quaternion] .assign (rotation [_quaternion]);

      return this;
   },
   set (x = 0, y = 0, z = 1, angle = 0)
   {
      this [_x]     = x;
      this [_y]     = y;
      this [_z]     = z;
      this [_angle] = angle;

      const scale = Math .hypot (x, y, z);

      if (scale === 0)
      {
         this [_quaternion] .set (0, 0, 0, 1);
         return this;
      }

      // Calculate quaternion

      const
         halfTheta = _Algorithm_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .interval (angle / 2, 0, Math .PI),
         ascale    = Math .sin (halfTheta) / scale;

      this [_quaternion] .set (x * ascale,
                               y * ascale,
                               z * ascale,
                               Math .cos (halfTheta));
      return this;
   },
   get: (() =>
   {
      const result = new _Vector4_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A ();

      return function ()
      {
         const quaternion = this [_quaternion];

         if (Math .abs (quaternion .w) > 1)
         {
            return _Vector4_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .Z_AXIS;
         }
         else
         {
            const
               angle = Math .acos (quaternion .w) * 2,
               scale = Math .sin (angle / 2);

            if (scale === 0)
            {
               return _Vector4_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .Z_AXIS;
            }
            else
            {
               const axis = quaternion .imag .divide (scale);

               return result .set (axis .x,
                                   axis .y,
                                   axis .z,
                                   angle);
            }
         }
      };
   })(),
   setAxisAngle (axis, angle)
   {
      return this .set (axis .x, axis .y, axis .z, angle);
   },
   setFromToVec: (() =>
   {
      const
         from = new _Vector3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (),
         to   = new _Vector3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (),
         cv   = new _Vector3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (),
         t    = new _Vector3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A ();

      return function (fromVec, toVec)
      {
         // https://bitbucket.org/Coin3D/coin/src/abc9f50968c9/src/base/SbRotation.cpp

         from .assign (fromVec) .normalize ();
         to   .assign (toVec)   .normalize ();

         const
            cos_angle = _Algorithm_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .clamp (from .dot (to), -1, 1),
            crossvec  = cv .assign (from) .cross (to) .normalize (),
            crosslen  = crossvec .norm ();

         if (crosslen === 0)
         {
            // Parallel vectors
            // Check if they are pointing in the same direction.
            if (cos_angle > 0)
               this [_quaternion] .set (0, 0, 0, 1); // standard rotation

            // Ok, so they are parallel and pointing in the opposite direction
            // of each other.
            else
            {
               // Try crossing with x axis.
               t .assign (from) .cross (_Vector3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .X_AXIS);

               // If not ok, cross with y axis.
               if (t .squaredNorm () === 0)
                  t .assign (from) .cross (_Vector3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .Y_AXIS);

               t .normalize ();

               this [_quaternion] .set (t .x, t .y, t .z, 0);
            }
         }
         else
         {
            // Vectors are not parallel
            // The abs () wrapping is to avoid problems when `dot' "overflows" a tiny wee bit,
            // which can lead to sqrt () returning NaN.
            crossvec .multiply (Math .sqrt (Math .abs (1 - cos_angle) / 2));

            this [_quaternion] .set (crossvec .x,
                                     crossvec .y,
                                     crossvec .z,
                                     Math .sqrt (Math .abs (1 + cos_angle) / 2));
         }

         this .update ();

         return this;
      };
   })(),
   setAxis (vector)
   {
      this .set (vector .x, vector .y, vector .z, this [_angle]);
   },
   getAxis (axis = new _Vector3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A ())
   {
      return axis .set (this [_x], this [_y], this [_z]);
   },
   setQuaternion (quaternion)
   {
      this [_quaternion] .assign (quaternion) .normalize ();
      this .update ();
      return this;
   },
   getQuaternion (quaternion = new _Quaternion_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A ())
   {
      return quaternion .assign (this [_quaternion]);
   },
   setMatrix (matrix)
   {
      this [_quaternion] .setMatrix (matrix) .normalize ();
      this .update ();
      return this;
   },
   getMatrix (matrix = new _Matrix3_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A ())
   {
      return this [_quaternion] .getMatrix (matrix);
   },
   setEuler (x, y, z, order = "XYZ")
   {
      // Quaternion is then already normalized.
      this [_quaternion] .setEuler (x, y, z, order);
      this .update ();
      return this;
   },
   getEuler (euler = [ ], order = "XYZ")
   {
      return this [_quaternion] .getEuler (euler, order);
   },
   equals (rotation)
   {
      return this [_quaternion] .equals (rotation [_quaternion]);
   },
   inverse ()
   {
      this [_quaternion] .inverse ();
      this .update ();
      return this;
   },
   multLeft (rotation)
   {
      this [_quaternion] .multLeft (rotation [_quaternion]) .normalize ();
      this .update ();
      return this;
   },
   multRight (rotation)
   {
      this [_quaternion] .multRight (rotation [_quaternion]) .normalize ();
      this .update ();
      return this;
   },
   multVecRot (vector)
   {
      return this [_quaternion] .multVecQuat (vector);
   },
   multRotVec (vector)
   {
      return this [_quaternion] .multQuatVec (vector);
   },
   normalize ()
   {
      this [_quaternion] .normalize ();
      this .update ();
      return this;
   },
   pow (exponent)
   {
      this [_quaternion] .pow (exponent);
      this .update ();
      return this;
   },
   slerp (dest, t)
   {
      this [_quaternion] .slerp (dest [_quaternion], t);
      this .update ();
      return this;
   },
   squad (a, b, dest, t)
   {
      this [_quaternion] .squad (a [_quaternion], b [_quaternion], dest [_quaternion], t);
      this .update ();
      return this;
   },
   /**
    * Straightens the rotation so that the x-axis of this rotation is parallel to the plane spawned by upVector.
    */
   straighten: (() =>
   {
      const
         localXAxis = new _Vector3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (),
         localZAxis = new _Vector3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (),
         upNormal   = new _Vector3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (),
         rotation   = new Rotation4 ();

      return function (upVector = _Vector3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .Y_AXIS)
      {
         upNormal .assign (upVector) .normalize ();

         this .multVecRot (localXAxis .assign (_Vector3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .X_AXIS) .negate ());
         this .multVecRot (localZAxis .assign (_Vector3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .Z_AXIS));

         // If viewer looks along up vector.
         if (Math .abs (localZAxis .dot (upNormal)) >= 1)
            return this;

         const newXAxis = localZAxis .cross (upNormal) .normalize ();

         if (newXAxis .dot (localXAxis) <= -1)
         {
            rotation .setAxisAngle (_Vector3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .Z_AXIS, Math .PI);

            return this .multLeft (rotation);
         }
         else
         {
            rotation .setFromToVec (localXAxis, newXAxis);

            return this .multRight (rotation);
         }
      };
   })(),
   toString ()
   {
      return this [_x] + " " +
             this [_y] + " " +
             this [_z] + " " +
             this [_angle];
   }
});

for (const key of Object .keys (Rotation4 .prototype))
   Object .defineProperty (Rotation4 .prototype, key, { enumerable: false });

const x = {
   get ()
   {
      return this [_x];
   },
   set (x)
   {
      this [_x] = x;
      this .set (x, this [_y], this [_z], this [_angle]);
   },
   enumerable: true,
};

const y = {
   get ()
   {
      return this [_y];
   },
   set (y)
   {
      this [_y] = y;
      this .set (this [_x], y, this [_z], this [_angle]);
   },
   enumerable: true,
};

const z = {
   get ()
   {
      return this [_z];
   },
   set (z)
   {
      this [_z] = z;
      this .set (this [_x], this [_y], z, this [_angle]);
   },
   enumerable: true,
};

const angle = {
   get ()
   {
      return this [_angle];
   },
   set (angle)
   {
      this [_angle] = angle;
      this .set (this [_x], this [_y], this [_z], angle);
   },
   enumerable: true,
};

Object .defineProperties (Rotation4 .prototype,
{
   length: { value: 4 },
   x: x,
   y: y,
   z: z,
   angle: angle,
});

x     .enumerable = false;
y     .enumerable = false;
z     .enumerable = false;
angle .enumerable = false;

Object .defineProperties (Rotation4 .prototype,
{
   0: x,
   1: y,
   2: z,
   3: angle,
});

Object .assign (Rotation4,
{
   IDENTITY: Object .freeze (new Rotation4 ()),
   fromQuaternion (quaternion)
   {
      return new Rotation4 () .setQuaternion (quaternion);
   },
   fromMatrix (matrix)
   {
      return new Rotation4 () .setMatrix (matrix);
   },
   fromEuler (x, y, z, order = "XYZ")
   {
      return new Rotation4 () .setEuler (x, y, z, order);
   },
   spline (r0, r1, r2)
   {
      const copy = Object .create (this .prototype);
      copy [_quaternion] = _Quaternion_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .spline (r0 [_quaternion], r1 [_quaternion], r2 [_quaternion]);
      copy .update ();
      return copy;
   },
});

const __default__ = Rotation4;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_x_ite_Namespace_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .add ("Rotation4", __default__));

/***/ },

/***/ 4296
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Algorithm_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(9919);
/* harmony import */ var _x_ite_Namespace_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(8427);


function Vector2 (x = 0, y = x)
{
   this .x = x;
   this .y = y;
}

Object .assign (Vector2 .prototype,
{
   *[Symbol .iterator] ()
   {
      yield this .x;
      yield this .y;
   },
   copy ()
   {
      const copy = Object .create (Vector2 .prototype);
      copy .x = this .x;
      copy .y = this .y;
      return copy;
   },
   assign ({ x, y })
   {
      this .x = x;
      this .y = y;
      return this;
   },
   set (x = 0, y = x)
   {
      this .x = x;
      this .y = y;
      return this;
   },
   equals ({ x, y })
   {
      return this .x === x &&
             this .y === y;
   },
   negate ()
   {
      this .x = -this .x;
      this .y = -this .y;
      return this;
   },
   inverse ()
   {
      this .x = 1 / this .x;
      this .y = 1 / this .y;
      return this;
   },
   add ({ x, y })
   {
      this .x += x;
      this .y += y;
      return this;
   },
   subtract ({ x, y })
   {
      this .x -= x;
      this .y -= y;
      return this;
   },
   multiply (value)
   {
      this .x *= value;
      this .y *= value;
      return this;
   },
   multVec ({ x, y })
   {
      this .x *= x;
      this .y *= y;
      return this;
   },
   divide (value)
   {
      this .x /= value;
      this .y /= value;
      return this;
   },
   divVec ({ x, y })
   {
      this .x /= x;
      this .y /= y;
      return this;
   },
   normalize ()
   {
      const length = Math .hypot (this .x, this .y);

      if (length)
      {
         this .x /= length;
         this .y /= length;
      }

      return this;
   },
   dot ({ x, y })
   {
      return this .x * x +
             this .y * y;
   },
   squaredNorm ()
   {
      const { x, y } = this;

      return x * x +
             y * y;
   },
   norm ()
   {
      return Math .hypot (this .x, this .y);
   },
   distance ({ x, y })
   {
      return Math .hypot (this .x - x,
                          this .y - y);
   },
   lerp ({ x: dX, y: dY }, t)
   {
      const { x, y } = this;

      this .x = x + t * (dX - x);
      this .y = y + t * (dY - y);
      return this;
   },
   abs ()
   {
      const { x, y } = this;

      this .x = Math .abs (x);
      this .y = Math .abs (y);
      return this;
   },
   min (vector)
   {
      let { x, y } = this;

      for (const { x: minX, y: minY } of arguments)
      {
         x = Math .min (x, minX);
         y = Math .min (y, minY);
      }

      this .x = x;
      this .y = y;
      return this;
   },
   max (vector)
   {
      let { x, y } = this;

      for (const { x: maxX, y: maxY } of arguments)
      {
         x = Math .max (x, maxX);
         y = Math .max (y, maxY);
      }

      this .x = x;
      this .y = y;
      return this;
   },
   clamp ({ x: minX, y: minY }, { x: maxX, y: maxY })
   {
      this .x = _Algorithm_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .clamp (this .x, minX, maxX);
      this .y = _Algorithm_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .clamp (this .y, minY, maxY);
      return this;
   },
   toString ()
   {
      return this .x + " " +
             this .y;
   }
});

for (const key of Object .keys (Vector2 .prototype))
   Object .defineProperty (Vector2 .prototype, key, { enumerable: false });

Object .defineProperties (Vector2 .prototype,
{
   length: { value: 2 },
   0:
   {
      get () { return this .x; },
      set (value) { this .x = value; },
   },
   1:
   {
      get () { return this .y; },
      set (value) { this .y = value; },
   },
});

Object .assign (Vector2,
{
   ZERO: Object .freeze (new Vector2 ()),
   // Positive values
   ONE: Object .freeze (new Vector2 (1)),
   X_AXIS: Object .freeze (new Vector2 (1, 0)),
   Y_AXIS: Object .freeze (new Vector2 (0, 1)),
   // Negative values
   NEGATIVE_ONE: Object .freeze (new Vector2 (-1)),
   NEGATIVE_X_AXIS: Object .freeze (new Vector2 (-1, 0)),
   NEGATIVE_Y_AXIS: Object .freeze (new Vector2 (0, -1)),
});

const __default__ = Vector2;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_x_ite_Namespace_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .add ("Vector2", __default__));

/***/ },

/***/ 8655
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Algorithm_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(9919);
/* harmony import */ var _x_ite_Namespace_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(8427);


function Vector3 (x = 0, y = x, z = y)
{
   this .x = x;
   this .y = y;
   this .z = z;
}

Object .assign (Vector3 .prototype,
{
   *[Symbol .iterator] ()
   {
      yield this .x;
      yield this .y;
      yield this .z;
   },
   copy ()
   {
      const copy = Object .create (Vector3 .prototype);
      copy .x = this .x;
      copy .y = this .y;
      copy .z = this .z;
      return copy;
   },
   assign ({ x, y, z })
   {
      this .x = x;
      this .y = y;
      this .z = z;
      return this;
   },
   set (x = 0, y = x, z = y)
   {
      this .x = x;
      this .y = y;
      this .z = z;
      return this;
   },
   equals ({ x, y, z })
   {
      return this .x === x &&
             this .y === y &&
             this .z === z;
   },
   negate ()
   {
      this .x = -this .x;
      this .y = -this .y;
      this .z = -this .z;
      return this;
   },
   inverse ()
   {
      this .x = 1 / this .x;
      this .y = 1 / this .y;
      this .z = 1 / this .z;
      return this;
   },
   add ({ x, y, z })
   {
      this .x += x;
      this .y += y;
      this .z += z;
      return this;
   },
   subtract ({ x, y, z })
   {
      this .x -= x;
      this .y -= y;
      this .z -= z;
      return this;
   },
   multiply (value)
   {
      this .x *= value;
      this .y *= value;
      this .z *= value;
      return this;
   },
   multVec ({ x, y, z })
   {
      this .x *= x;
      this .y *= y;
      this .z *= z;
      return this;
   },
   divide (value)
   {
      this .x /= value;
      this .y /= value;
      this .z /= value;
      return this;
   },
   divVec ({ x, y, z })
   {
      this .x /= x;
      this .y /= y;
      this .z /= z;
      return this;
   },
   cross ({ x: bx, y: by, z: bz })
   {
      const { x: ax, y: ay, z: az } = this;

      this .x = ay * bz - az * by;
      this .y = az * bx - ax * bz;
      this .z = ax * by - ay * bx;

      return this;
   },
   normalize ()
   {
      const length = Math .hypot (this .x, this .y, this .z);

      if (length)
      {
         this .x /= length;
         this .y /= length;
         this .z /= length;
      }

      return this;
   },
   dot ({ x, y, z })
   {
      return this .x * x +
             this .y * y +
             this .z * z;
   },
   squaredNorm ()
   {
      const { x, y, z } = this;

      return x * x +
             y * y +
             z * z;
   },
   norm ()
   {
      return Math .hypot (this .x, this .y, this .z);
   },
   distance ({ x, y, z })
   {
      return Math .hypot (this .x - x,
                          this .y - y,
                          this .z - z);
   },
   lerp ({ x: dX, y: dY, z: dZ }, t)
   {
      const { x, y, z } = this;

      this .x = x + t * (dX - x);
      this .y = y + t * (dY - y);
      this .z = z + t * (dZ - z);
      return this;
   },
   slerp: (() =>
   {
      const tmp = new Vector3 ();

      return function (destination, t)
      {
         return _Algorithm_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .simpleSlerp (this, tmp .assign (destination), t);
      };
   })(),
   abs ()
   {
      const { x, y, z } = this;

      this .x = Math .abs (x);
      this .y = Math .abs (y);
      this .z = Math .abs (z);
      return this;
   },
   min (vector)
   {
      let { x, y, z } = this;

      for (const { x: minX, y: minY, z: minZ } of arguments)
      {
         x = Math .min (x, minX);
         y = Math .min (y, minY);
         z = Math .min (z, minZ);
      }

      this .x = x;
      this .y = y;
      this .z = z;
      return this;
   },
   max (vector)
   {
      let { x, y, z } = this;

      for (const { x: maxX, y: maxY, z: maxZ } of arguments)
      {
         x = Math .max (x, maxX);
         y = Math .max (y, maxY);
         z = Math .max (z, maxZ);
      }

      this .x = x;
      this .y = y;
      this .z = z;
      return this;
   },
   clamp ({ x: minX, y: minY, z: minZ }, { x: maxX, y: maxY, z: maxZ })
   {
      this .x = _Algorithm_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .clamp (this .x, minX, maxX);
      this .y = _Algorithm_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .clamp (this .y, minY, maxY);
      this .z = _Algorithm_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .clamp (this .z, minZ, maxZ);
      return this;
   },
   toString ()
   {
      return this .x + " " +
             this .y + " " +
             this .z;
   }
});

for (const key of Object .keys (Vector3 .prototype))
   Object .defineProperty (Vector3 .prototype, key, { enumerable: false });

Object .defineProperties (Vector3 .prototype,
{
   length: { value: 3 },
   0:
   {
      get () { return this .x; },
      set (value) { this .x = value; },
   },
   1:
   {
      get () { return this .y; },
      set (value) { this .y = value; },
   },
   2:
   {
      get () { return this .z; },
      set (value) { this .z = value; },
   },
});

Object .assign (Vector3,
{
   ZERO: Object .freeze (new Vector3 ()),
   // Positive values
   ONE: Object .freeze (new Vector3 (1)),
   X_AXIS: Object .freeze (new Vector3 (1, 0, 0)),
   Y_AXIS: Object .freeze (new Vector3 (0, 1, 0)),
   Z_AXIS: Object .freeze (new Vector3 (0, 0, 1)),
   // Negative values
   NEGATIVE_ONE: Object .freeze (new Vector3 (-1)),
   NEGATIVE_X_AXIS: Object .freeze (new Vector3 (-1, 0, 0)),
   NEGATIVE_Y_AXIS: Object .freeze (new Vector3 (0, -1, 0)),
   NEGATIVE_Z_AXIS: Object .freeze (new Vector3 (0, 0, -1)),
});

const __default__ = Vector3;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_x_ite_Namespace_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .add ("Vector3", __default__));

/***/ },

/***/ 4974
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Algorithm_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(9919);
/* harmony import */ var _x_ite_Namespace_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(8427);


function Vector4 (x = 0, y = x, z = y, w = z)
{
   this .x = x;
   this .y = y;
   this .z = z;
   this .w = w;
}

Object .assign (Vector4 .prototype,
{
   *[Symbol .iterator] ()
   {
      yield this .x;
      yield this .y;
      yield this .z;
      yield this .w;
   },
   copy ()
   {
      const copy = Object .create (Vector4 .prototype);
      copy .x = this .x;
      copy .y = this .y;
      copy .z = this .z;
      copy .w = this .w;
      return copy;
   },
   assign ({ x, y, z, w })
   {
      this .x = x;
      this .y = y;
      this .z = z;
      this .w = w;
      return this;
   },
   set (x = 0, y = x, z = y, w = z)
   {
      this .x = x;
      this .y = y;
      this .z = z;
      this .w = w;
      return this;
   },
   equals ({ x, y, z, w })
   {
      return this .x === x &&
             this .y === y &&
             this .z === z &&
             this .w === w;
   },
   negate ()
   {
      this .x = -this .x;
      this .y = -this .y;
      this .z = -this .z;
      this .w = -this .w;
      return this;
   },
   inverse ()
   {
      this .x = 1 / this .x;
      this .y = 1 / this .y;
      this .z = 1 / this .z;
      this .w = 1 / this .w;
      return this;
   },
   add ({ x, y, z, w })
   {
      this .x += x;
      this .y += y;
      this .z += z;
      this .w += w;
      return this;
   },
   subtract ({ x, y, z, w })
   {
      this .x -= x;
      this .y -= y;
      this .z -= z;
      this .w -= w;
      return this;
   },
   multiply (value)
   {
      this .x *= value;
      this .y *= value;
      this .z *= value;
      this .w *= value;
      return this;
   },
   multVec ({ x, y, z, w })
   {
      this .x *= x;
      this .y *= y;
      this .z *= z;
      this .w *= w;
      return this;
   },
   divide (value)
   {
      this .x /= value;
      this .y /= value;
      this .z /= value;
      this .w /= value;
      return this;
   },
   divVec ({ x, y, z, w })
   {
      this .x /= x;
      this .y /= y;
      this .z /= z;
      this .w /= w;
      return this;
   },
   normalize ()
   {
      const length = Math .hypot (this .x, this .y, this .z, this .w);

      if (length)
      {
         this .x /= length;
         this .y /= length;
         this .z /= length;
         this .w /= length;
      }

      return this;
   },
   dot ({ x, y, z, w })
   {
      return this .x * x +
             this .y * y +
             this .z * z +
             this .w * w;
   },
   squaredNorm ()
   {
      const { x, y, z, w } = this;

      return x * x +
             y * y +
             z * z +
             w * w;
   },
   norm ()
   {
      return Math .hypot (this .x, this .y, this .z, this .w);
   },
   distance ({ x, y, z, w })
   {
      return Math .hypot (this .x - x,
                          this .y - y,
                          this .z - z,
                          this .w - w);
   },
   lerp ({ x: dX, y: dY, z: dZ, w: dW }, t)
   {
      const { x, y, z, w } = this;

      this .x = x + t * (dX - x);
      this .y = y + t * (dY - y);
      this .z = z + t * (dZ - z);
      this .w = w + t * (dW - w);
      return this;
   },
   abs ()
   {
      const { x, y, z, w } = this;

      this .x = Math .abs (x);
      this .y = Math .abs (y);
      this .z = Math .abs (z);
      this .w = Math .abs (w);
      return this;
   },
   min (vector)
   {
      let { x, y, z, w } = this;

      for (const { x: minX, y: minY, z: minZ, w: minW } of arguments)
      {
         x = Math .min (x, minX);
         y = Math .min (y, minY);
         z = Math .min (z, minZ);
         w = Math .min (w, minW);
      }

      this .x = x;
      this .y = y;
      this .z = z;
      this .w = w;
      return this;
   },
   max (vector)
   {
      let { x, y, z, w } = this;

      for (const { x: maxX, y: maxY, z: maxZ, w: maxW } of arguments)
      {
         x = Math .max (x, maxX);
         y = Math .max (y, maxY);
         z = Math .max (z, maxZ);
         w = Math .max (w, maxW);
      }

      this .x = x;
      this .y = y;
      this .z = z;
      this .w = w;
      return this;
   },
   clamp  ({ x: minX, y: minY, z: minZ, w: minW }, { x: maxX, y: maxY, z: maxZ, w: maxW })
   {
      this .x = _Algorithm_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .clamp (this .x, minX, maxX);
      this .y = _Algorithm_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .clamp (this .y, minY, maxY);
      this .z = _Algorithm_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .clamp (this .z, minZ, maxZ);
      this .w = _Algorithm_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .clamp (this .w, minW, maxW);
      return this;
   },
   toString ()
   {
      return this .x + " " +
             this .y + " " +
             this .z + " " +
             this .w;
   },
});

for (const key of Object .keys (Vector4 .prototype))
   Object .defineProperty (Vector4 .prototype, key, { enumerable: false });

Object .defineProperties (Vector4 .prototype,
{
   length: { value: 4 },
   0:
   {
      get () { return this .x; },
      set (value) { this .x = value; },
   },
   1:
   {
      get () { return this .y; },
      set (value) { this .y = value; },
   },
   2:
   {
      get () { return this .z; },
      set (value) { this .z = value; },
   },
   3:
   {
      get () { return this .w; },
      set (value) { this .w = value; },
   },
});

Object .assign (Vector4,
{
   ZERO: Object .freeze (new Vector4 ()),
   // Positive values
   ONE: Object .freeze (new Vector4 (1)),
   X_AXIS: Object .freeze (new Vector4 (1, 0, 0, 0)),
   Y_AXIS: Object .freeze (new Vector4 (0, 1, 0, 0)),
   Z_AXIS: Object .freeze (new Vector4 (0, 0, 1, 0)),
   W_AXIS: Object .freeze (new Vector4 (0, 0, 0, 1)),
   // Negative values
   NEGATIVE_ONE: Object .freeze (new Vector4 (-1)),
   NEGATIVE_X_AXIS: Object .freeze (new Vector4 (-1, 0, 0, 0)),
   NEGATIVE_Y_AXIS: Object .freeze (new Vector4 (0, -1, 0, 0)),
   NEGATIVE_Z_AXIS: Object .freeze (new Vector4 (0, 0, -1, 0)),
   NEGATIVE_W_AXIS: Object .freeze (new Vector4 (0, 0, 0, -1)),
});

const __default__ = Vector4;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_x_ite_Namespace_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .add ("Vector4", __default__));

/***/ },

/***/ 7666
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _x_ite_Namespace_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(8427);
class MatrixStack extends Array
{
   #top = 0;

   constructor (Type)
   {
      super ();

      this .push (new Type ());
   }

   set (matrix)
   {
      this [this .#top] .assign (matrix);
   }

   get ()
   {
      return this [this .#top];
   }

   push (matrix = this [this .#top])
   {
      const top = ++ this .#top;

      if (top < this .length)
         this [top] .assign (matrix);
      else
         this [top] = matrix .copy ();
   }

   pop ()
   {
      -- this .#top;
   }

   clear ()
   {
      this .#top = 0;
   }

   size ()
   {
      return this .#top + 1;
   }

   identity ()
   {
      this [this .#top] .identity ();
   }

   inverse ()
   {
      this [this .#top] .inverse ();
   }

   multRight (matrix)
   {
      this [this .#top] .multRight (matrix);
   }

   multLeft (matrix)
   {
      this [this .#top] .multLeft (matrix);
   }

   translate (vector)
   {
      this [this .#top] .translate (vector);
   }

   rotate (rotation)
   {
      this [this .#top] .rotate (rotation);
   }

   scale (vector)
   {
      this [this .#top] .scale (vector);
   }
}

const __default__ = MatrixStack;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_x_ite_Namespace_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .add ("MatrixStack", __default__));

/***/ },

/***/ 6538
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _x_ite_Namespace_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(8427);
class StopWatch
{
   #startTime = 0;
   #stopTime = 0;
   cycles = 0;
   elapsedTime = 0;

   start ()
   {
      this .#startTime = Date .now ();
   }

   stop ()
   {
      if (this .#startTime <= this .#stopTime)
         return;

      this .#stopTime    = Date .now ();
      this .cycles      += 1;
      this .elapsedTime += this .#stopTime - this .#startTime;
   }

   reset ()
   {
      this .#startTime  = 0;
      this .#stopTime   = 0;
      this .cycles      = 0;
      this .elapsedTime = 0;
   }

   get averageTime ()
   {
      return this .cycles ? this .elapsedTime / this .cycles : 0;
   }
}

const __default__ = StopWatch;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_x_ite_Namespace_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .add ("StopWatch", __default__));

/***/ },

/***/ 6895
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Math_Algorithm_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(9919);
/* harmony import */ var _x_ite_Namespace_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(8427);


const _value = Symbol ();

function BitSet (value = 0)
{
   this [_value] = value >>> 0;
}

Object .assign (BitSet .prototype,
{
   *[Symbol .iterator] ()
   {
      let
         value = this [_value],
         index = 0;

      while (value)
      {
         if (value & 1)
            yield index;

         value >>>= 1;
         ++ index;
      }
   },
   get (index)
   {
      const mask = 1 << index;

      return !! (this [_value] & mask);
   },
   set (index, value)
   {
      if (value)
         this .add (index);
      else
         this .remove (index);
   },
   add (index, mask = 1)
   {
      this [_value] |= mask << index;
      this [_value] >>>= 0;
   },
   remove (index, mask = 1)
   {
      this [_value] &= ~(mask << index);
      this [_value] >>>= 0;
   },
   clear ()
   {
      this [_value] = 0;
   },
   *entries ()
   {
      for (const i of this)
         yield [i, i];
   },
   valueOf ()
   {
      return this [_value];
   },
   toString (radix)
   {
      return this [_value] .toString (radix);
   },
});

BitSet .prototype .keys   = BitSet .prototype [Symbol .iterator];
BitSet .prototype .values = BitSet .prototype [Symbol .iterator];

Object .defineProperty (BitSet .prototype, "size",
{
   get ()
   {
      return _Math_Algorithm_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .bitCount (this [_value]);
   },
});

const __default__ = BitSet;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_x_ite_Namespace_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .add ("BitSet", __default__));

/***/ },

/***/ 9975
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _x_ite_Namespace_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(8427);
function ObjectCache (Type)
{
   return Object .assign ([ ],
   {
      top: 0,
      pop ()
      {
         if (this .top !== 0)
            return this [-- this .top];

         return new Type ();
      },
      push (object)
      {
         this [this .top ++] = object;
      },
      clear ()
      {
         this .length = 0;
         this .top    = 0;
      },
   });
}

const __default__ = ObjectCache;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_x_ite_Namespace_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .add ("ObjectCache", __default__));

/***/ },

/***/ 8130
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(8427);
const __default__ = "14.0.4";
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .add ("BROWSER_VERSION", __default__));

/***/ },

/***/ 246
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(8427);
const Events = Object .assign ([ ],
{
   create (field)
   {
      const event = this .pop () ?? new Set ();

      event .field = field;
      event .clear ();

      return event;
   },
   copy (event)
   {
      const copy = this .create (event .field);

      for (const source of event)
         copy .add (source);

      return copy;
   },
   from (field)
   {
      const event = this .create (field);

      event .add (field);

      return event;
   },
});

for (const key of Object .keys (Events))
   Object .defineProperty (Events, key, { enumerable: false });

const __default__ = Events;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .add ("Events", __default__));

/***/ },

/***/ 5373
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _X3DInfoArray_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(9563);
/* harmony import */ var _X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(3927);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(8427);



function FieldDefinitionArray (values = [ ])
{
   return _X3DInfoArray_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .call (this, Array .from (values, value => [value .name, value]), _X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A);
}

Object .setPrototypeOf (FieldDefinitionArray .prototype, _X3DInfoArray_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .prototype);

for (const key of Object .keys (FieldDefinitionArray .prototype))
   Object .defineProperty (FieldDefinitionArray .prototype, key, { enumerable: false });

Object .defineProperties (FieldDefinitionArray,
{
   typeName:
   {
      value: "FieldDefinitionArray",
      enumerable: true,
   },
});

const __default__ = FieldDefinitionArray;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .add ("FieldDefinitionArray", __default__));

/***/ },

/***/ 9041
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Features_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(7538);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(8427);


const __default__ = _Features_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .WEAK_REF && _Features_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .FINALIZATION_REGISTRY ?
/**
 * IterableWeakSet is a writable set-like class.
 */
class IterableWeakSet
{
   #map      = new Map ();
   #registry = new FinalizationRegistry (id => this .#map .delete (id));

   constructor (objects)
   {
      if (objects)
      {
         for (const object of objects)
            this .add (object);
      }
   }

   *[Symbol .iterator] ()
   {
      yield* this .values ();
   }

   get size ()
   {
      return this .#map .size;
   }

   add (object)
   {
      this .#map .set (object .getId (), new WeakRef (object));
      this .#registry .register (object, object .getId (), object);
   }

   clear ()
   {
      for (const object of this .values ())
         this .#registry .unregister (object);

      this .#map .clear ();
   }

   delete (object)
   {
      this .#map .delete (object .getId ());
      this .#registry .unregister (object);
   }

   forEach (callbackFn, thisArg)
   {
      for (const object of this .values ())
         callbackFn .call (thisArg, object, object, this);
   }

   has (object)
   {
      return this .#map .has (object .getId ());
   }

   *entries ()
   {
      for (const object of this .values ())
         yield [object, object];
   }

   *keys ()
   {
      yield *this .values ();
   }

   *values ()
   {
      for (const weakRef of this .#map .values ())
      {
         const object = weakRef .deref ();

         if (object)
            yield object;
      }
   }
}
:
class IterableWeakSet extends Set
{
   constructor (objects)
   {
      super (objects);
   }
};
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .add ("IterableWeakSet", __default__));

/***/ },

/***/ 6059
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _X3DField_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(9862);
/* harmony import */ var _Features_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(7538);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(8427);




function X3DArrayField (value)
{
   _X3DField_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .call (this, value);
}

Object .assign (Object .setPrototypeOf (X3DArrayField .prototype, _X3DField_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .prototype),
{
   // Implement all function also in TypedArray, if possible.
   at: Array .prototype .at,
   concat: Array .prototype .concat,
   // copyWithin: Array.prototype.copyWithin,
   entries: Array .prototype .entries,
   every: Array .prototype .every,
   fill: Array .prototype .fill,
   filter (/* callbackFn, thisArg */)
   {
      const array = new (this .constructor) ();

      for (const v of Array .prototype .filter .call (this, ... arguments))
         array .push (v);

      return array;
   },
   find: Array .prototype .find,
   findIndex: Array .prototype .findIndex,
   findLast: Array .prototype .findLast,
   findLastIndex: Array .prototype .findLastIndex,
   flat: Array .prototype .flat,
   flatMap: Array .prototype .flatMap,
   forEach: Array .prototype .forEach,
   includes: Array .prototype .includes,
   indexOf: Array .prototype .indexOf,
   join: Array .prototype .join,
   keys: Array .prototype .keys,
   lastIndexOf: Array .prototype .lastIndexOf,
   map (/* callbackFn, thisArg */)
   {
      const array = new (this .constructor) ();

      for (const v of Array .prototype .map .call (this, ... arguments))
         array .push (v);

      return array;
   },
   reduce: Array .prototype .reduce,
   reduceRight: Array .prototype .reduceRight,
   reverse: Array .prototype .reverse,
   slice (/* start, end */)
   {
      const array = new (this .constructor) ();

      for (const v of Array .prototype .slice .call (this, ... arguments))
         array .push (v);

      return array;
   },
   some: Array .prototype .some,
   sort: Array .prototype .sort,
   toReversed ()
   {
      return this .copy () .reverse ();
   },
   toSorted (/* compareFn */)
   {
      return this .copy () .sort (... arguments);
   },
   toSpliced (/* start, deleteCount, ... insertValues */)
   {
      const copy = this .copy ();

      copy .splice (... arguments);

      return copy;
   },
   values: Array .prototype .values,
   with (index, value)
   {
      const copy = this .copy ();

      copy [index] = value;

      return copy;
   },
});

for (const key of Object .keys (X3DArrayField .prototype))
   Object .defineProperty (X3DArrayField .prototype, key, { enumerable: false });

const __default__ = X3DArrayField;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .add ("X3DArrayField", __default__));

/***/ },

/***/ 2188
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  A: () => (/* binding */ Base_X3DBaseNode)
});

// EXTERNAL MODULE: ./src/x_ite/Base/X3DChildObject.js
var X3DChildObject = __webpack_require__(8927);
// EXTERNAL MODULE: ./src/x_ite/Base/Events.js
var Events = __webpack_require__(246);
// EXTERNAL MODULE: ./src/x_ite/Base/X3DFieldDefinition.js
var X3DFieldDefinition = __webpack_require__(3927);
// EXTERNAL MODULE: ./src/x_ite/Base/FieldDefinitionArray.js
var FieldDefinitionArray = __webpack_require__(5373);
// EXTERNAL MODULE: ./src/x_ite/Base/X3DInfoArray.js
var X3DInfoArray = __webpack_require__(9563);
// EXTERNAL MODULE: ./src/x_ite/Base/X3DField.js
var X3DField = __webpack_require__(9862);
// EXTERNAL MODULE: ./src/x_ite/Namespace.js
var Namespace = __webpack_require__(8427);
;// ./src/x_ite/Base/FieldArray.js



function FieldArray (values = [ ])
{
   return X3DInfoArray/* default */.A .call (this, Array .from (values, value => [value .getName (), value]), X3DField/* default */.A);
}

Object .setPrototypeOf (FieldArray .prototype, X3DInfoArray/* default */.A .prototype);

for (const key of Object .keys (FieldArray .prototype))
   Object .defineProperty (FieldArray .prototype, key, { enumerable: false });

Object .defineProperties (FieldArray,
{
   typeName:
   {
      value: "FieldArray",
      enumerable: true,
   },
});

const __default__ = FieldArray;
;

/* harmony default export */ const Base_FieldArray = (Namespace/* default */.A .add ("FieldArray", __default__));
// EXTERNAL MODULE: ./src/x_ite/Fields.js + 15 modules
var Fields = __webpack_require__(9818);
// EXTERNAL MODULE: ./src/x_ite/Base/X3DConstants.js
var X3DConstants = __webpack_require__(3411);
// EXTERNAL MODULE: ./src/x_ite/Parser/HTMLSupport.js
var HTMLSupport = __webpack_require__(2501);
;// ./src/x_ite/Base/X3DBaseNode.js









const
   _browser           = Symbol (),
   _executionContext  = Symbol (),
   _type              = Symbol (),
   _fieldDefinitions  = Symbol .for ("X_ITE.X3DBaseNode.fieldDefinitions"),
   _predefinedFields  = Symbol (),
   _userDefinedFields = Symbol (),
   _childObjects      = Symbol (),
   _changedTypes      = Symbol (),
   _initialized       = Symbol (),
   _live              = Symbol (),
   _set_live__        = Symbol .for ("X_ITE.X3DBaseNode.set_live__");

function X3DBaseNode (executionContext, browser = executionContext .getBrowser ())
{
   if (this [_executionContext])
      return;

   X3DChildObject/* default */.A .call (this);

   this [_browser]           = browser;
   this [_executionContext]  = executionContext;
   this [_type]              = [ ];
   this [_fieldDefinitions]  = this .constructor .fieldDefinitions ?? this [_fieldDefinitions];
   this [_predefinedFields]  = new Base_FieldArray ();
   this [_userDefinedFields] = new Base_FieldArray ();
   this [_childObjects]      = [ ];
   this [_live]              = true;
   this [_initialized]       = false;

   // Create fields.

   if (this .canUserDefinedFields ())
      this [_fieldDefinitions] = new FieldDefinitionArray/* default */.A (this [_fieldDefinitions]);

   for (const fieldDefinition of this [_fieldDefinitions])
      this .addPredefinedField (fieldDefinition);

   // Create events.

   this .addChildObjects (X3DConstants/* default */.A .outputOnly, "name_changed",     new Fields/* default */.A .SFTime (),
                          X3DConstants/* default */.A .outputOnly, "typeName_changed", new Fields/* default */.A .SFTime (),
                          X3DConstants/* default */.A .outputOnly, "parents_changed",  new Fields/* default */.A .SFTime ());
}

Object .assign (Object .setPrototypeOf (X3DBaseNode .prototype, X3DChildObject/* default */.A .prototype),
{
   [_fieldDefinitions]: new FieldDefinitionArray/* default */.A ([ ]),
   setName (value)
   {
      X3DChildObject/* default */.A .prototype .setName .call (this, value)

      this ._name_changed = Date .now () / 1000;
   },
   getBrowser ()
   {
      return this [_browser];
   },
   getScene ()
   {
      return this [_executionContext] ?.getLocalScene () ?? null;
   },
   getExecutionContext ()
   {
      return this [_executionContext];
   },
   setExecutionContext (executionContext)
   {
      if (!this [_type] .includes (X3DConstants/* default */.A .X3DScene))
         throw new Error (`${this .getTypeName ()}.setExecutionContext is not supported.`);

      // Disconnect interests.

      this .getOuterNode ?.()  ?.getLive () .removeInterest (_set_live__, this);
      this [_executionContext] ?.getLive () .removeInterest (_set_live__, this);
      this [_browser]           .getLive () .removeInterest (_set_live__, this);

      // Currently only useful for Scene.
      this [_executionContext] = executionContext;

      // Connect interests.

      if (this .getOuterNode ?.())
         this .getOuterNode () .getLive () .addInterest (_set_live__, this);

      else if (this [_executionContext])
         this [_executionContext] .getLive () .addInterest (_set_live__, this);

      else
         this [_browser] .getLive () .addInterest (_set_live__, this);

      this [_set_live__] ();
   },
   addType (value)
   {
      this [_type] .push (value);
   },
   getType ()
   {
      return this [_type];
   },
   setup ()
   {
      Object .freeze (this [_type]);

      this [_fieldDefinitions]  .addParent (this);
      this [_predefinedFields]  .addParent (this);
      this [_userDefinedFields] .addParent (this);

      for (const field of this [_childObjects])
         field .setTainted (false);

      for (const field of this [_predefinedFields])
         field .setTainted (false);

      for (const field of this [_userDefinedFields])
         field .setTainted (false);

      this .initialize ();

      this [_initialized] = true;
   },
   initialize ()
   { },
   isInitialized ()
   {
      return this [_initialized];
   },
   getInnerNode ()
   {
      return this;
   },
   isLive ()
   {
      ///  Returns the own live state of this node.

      return this [_live];
   },
   setLive (value)
   {
      ///  Sets the own live state of this node.  Setting the live state to false
      ///  temporarily disables this node completely.

      this [_live] = !!value .valueOf ();

      this [_set_live__] ();
   },
   getLive: (() =>
   {
      function getLive ()
      {
         return this ._live;
      }

      return function ()
      {
         ///  Returns the live event of this node.

         // Change function.

         Object .defineProperty (this, "getLive", { value: getLive });

         // Add isLive event.

         this .addChildObjects (X3DConstants/* default */.A .outputOnly, "live", new Fields/* default */.A .SFBool (this .checkLiveState ()));

         // Event processing is done manually and immediately, so:
         this ._live .removeParent (this);

         // Connect to execution context.

         if (this .getOuterNode ?.())
            this .getOuterNode () .getLive () .addInterest (_set_live__, this);

         else if (this [_executionContext] && this !== this [_browser])
            this [_executionContext] .getLive () .addInterest (_set_live__, this);

         else if (!this [_executionContext] && this !== this [_browser])
            this [_browser] .getLive () .addInterest (_set_live__, this);

         // Return field.

         return this ._live;
      };
   })(),
   checkLiveState ()
   {
      ///  Determines the live state of this node.

      if (this .getOuterNode ?.())
         return this [_live] && this .getOuterNode () .getLive () .getValue ();

      else if (this [_executionContext] && this !== this [_browser])
         return this [_live] && this [_executionContext] .getLive () .getValue ();

      else if (!this [_executionContext] && this !== this [_browser])
         return this [_live] && this [_browser] .isLive ();

      return this [_live];
   },
   [_set_live__] ()
   {
      const live = this ._live;

      if (!live)
         return;

      if (this .checkLiveState ())
      {
         if (live .getValue ())
            return;

         live .set (true);
         live .processEvent ();
      }
      else
      {
         if (live .getValue ())
         {
            live .set (false);
            live .processEvent ();
         }
      }
   },
   addChildObjects (... args /* accessType, name, field, ... */)
   {
      const length = args .length;

      for (let i = 0; i < length; i += 3)
         this .addChildObject (args [i], args [i + 1], args [i + 2]);
   },
   addChildObject (accessType, name, field)
   {
      this [_childObjects] .push (field);

      field .setPrivate (true);
      field .setTainted (true);
      field .addParent (this);
      field .setName (name);
      field .setAccessType (accessType);

      Object .defineProperty (this, `_${name}`,
      {
         get () { return field; },
         set (value) { field .setValue (value); },
      });
   },
   getFieldDefinition (name)
   {
      return this [_fieldDefinitions] .get (name);
   },
   getFieldDefinitions ()
   {
      return this [_fieldDefinitions];
   },
   getField (name)
   {
      const field = getFieldFromArray (this [_userDefinedFields], name)
         ?? getFieldFromArray (this [_predefinedFields], name);

      if (field)
         return field;

      throw new Error (`Unknown field '${name}' in node class ${this .getTypeName ()}.`);
   },
   getFields ()
   {
      return [... this [_predefinedFields], ... this [_userDefinedFields]];
   },
   addPredefinedField (fieldDefinition)
   {
      const
         accessType = fieldDefinition .getAccessType (),
         name       = fieldDefinition .getName (),
         field      = fieldDefinition .getValue () .copy ();

      field .setTainted (!this [_initialized]);
      field .addParent (this);
      field .setName (name);
      field .setAccessType (accessType);

      this [_predefinedFields] .add (name, field);

      Object .defineProperty (this, `_${name}`,
      {
         get () { return field; },
         set (value) { field .setValue (value); },
         configurable: true,
      });
   },
   addAlias (alias, field)
   {
      this [_predefinedFields] .alias (alias, field);

      if (field .isInitializable ())
         HTMLSupport/* default */.A .addFieldName (alias);
   },
   changeField (accessType, name, value)
   {
      const
         original = this [_predefinedFields] .get (name),
         field    = value .copy ();

      field .setTainted (!this [_initialized]);
      field .addParent (this);
      field .setName (name);
      field .setAccessType (accessType);

      this [_fieldDefinitions] = this [_fieldDefinitions] .copy ();
      this [_fieldDefinitions] .update (name, name, new X3DFieldDefinition/* default */.A (accessType, name, value));
      this [_predefinedFields] .update (name, name, field);

      Object .defineProperty (this, `_${name}`,
      {
         get () { return field; },
         set (value) { field .setValue (value); },
         configurable: true,
      });

      this [_changedTypes] ??= new Map ();

      this [_changedTypes] .set (field, original);
   },
   removePredefinedField (name)
   {
      const field = this [_predefinedFields] .get (name);

      if (!field)
         return;

      field .removeParent (this);

      this [_predefinedFields] .remove (name);

      delete this [`_${field .getName ()}`];
   },
   getPredefinedField (name)
   {
      const field = getFieldFromArray (this [_predefinedFields], name);

      if (field)
         return field;

      throw new Error (`Unknown predefined field '${name}' in node class ${this .getTypeName ()}.`);
   },
   getPredefinedFields ()
   {
      return this [_predefinedFields];
   },
   canUserDefinedFields ()
   {
      return false;
   },
   addUserDefinedField (accessType, name, field)
   {
      if (!this .canUserDefinedFields ())
         throw new Error ("Couldn't add user-defined field, node does not support this.");

      if (this [_userDefinedFields] .has (name))
         this .removeUserDefinedField (name);

      field .setTainted (!this [_initialized]);
      field .addParent (this);
      field .setName (name);
      field .setAccessType (accessType);

      this [_fieldDefinitions] .remove (name);

      this [_fieldDefinitions]  .add (name, new X3DFieldDefinition/* default */.A (accessType, name, field));
      this [_userDefinedFields] .add (name, field);
   },
   removeUserDefinedField (name)
   {
      const field = this [_userDefinedFields] .get (name);

      if (!field)
         return;

      field .removeParent (this);

      this [_fieldDefinitions]  .remove (name);
      this [_userDefinedFields] .remove (name);
   },
   getUserDefinedField (name)
   {
      const field = getFieldFromArray (this [_userDefinedFields], name);

      if (field)
         return field;

      throw new Error (`Unknown user-defined field '${name}' in node class ${this .getTypeName ()}.`);
   },
   getUserDefinedFields ()
   {
      return this [_userDefinedFields];
   },
   /**
    *
    * @param {boolean} extended  also return user-defined fields and fields with routes
    * @returns Array<X3DField>
    */
   getChangedFields (extended = false)
   {
      const changedFields = [ ];

      if (extended)
      {
         for (const field of this [_userDefinedFields])
            changedFields .push (field);
      }

      for (const field of this [_predefinedFields])
      {
         if (extended)
         {
            if (field .getInputRoutes () .size || field .getOutputRoutes () .size)
            {
               changedFields .push (field);
               continue;
            }
         }

         if (field .getReferences () .size === 0)
         {
            if (!field .isInitializable ())
               continue;

            if (this .isDefaultValue (field))
               continue;
         }

         changedFields .push (field);
      }

      return changedFields;
   },
   getConvertedFields (fields)
   {
      return this .convertFields (fields .map (field => this [_changedTypes] ?.get (field) ?? field));
   },
   convertFields (fields)
   {
      return fields;
   },
   isDefaultValue (field)
   {
      const
         name = field .getName (),
         f    = this [_userDefinedFields] .get (name) ?? this [_predefinedFields] .get (name);

      const fieldDefinition = f === field
         ? this [_fieldDefinitions] .get (name)
         : this .constructor .fieldDefinitions ?.get (name);

      return fieldDefinition ?.getValue () .equals (field) ?? field .getModificationTime () < 0;
   },
   getExtendedEventHandling ()
   {
      // Whether initializeOnly field are treated like inputOnly and inputOutput fields.
      return true;
   },
   addEvent (field)
   {
      if (field .isTainted ())
      {
         field .setModificationTime (Date .now () / 1000);
         return;
      }

      // if (this .getTypeName () === "HAnimMotion")
      // {
      //    console .log (this .getTypeName (), field .getName ());
      //    console .trace ();
      // }

      field .setTainted (true);

      this .addEventObject (field, Events/* default */.A .create (field));
   },
   addEventObject (field, event)
   {
      const browser = this [_browser];

      field .setModificationTime (Date .now () / 1000);

      // Register for processEvent

      browser .addTaintedField (field, event);
      browser .addBrowserEvent ();

      // Register for eventsProcessed

      if (this .isTainted ())
         return;

      if (field .isInput () || (this .getExtendedEventHandling () && field .isInitializable ()))
      {
         this .addNodeEvent ();
      }
   },
   addNodeEvent ()
   {
      this .setModificationTime (Date .now () / 1000);

      if (this .isTainted ())
         return;

      // if (this .getTypeName () === "HAnimMotion")
      // {
      //    console .trace ();
      // }

      const browser = this [_browser];

      this .setTainted (true);
      browser .addTaintedNode (this);
      browser .addBrowserEvent ();
   },
   parentsChanged ()
   {
      const time = Date .now () / 1000;

      if (this [_executionContext])
         this [_executionContext] ._sceneGraph_changed = time;

      this ._parents_changed = time;
   },
   dispose ()
   {
      this .getOuterNode ?.()  ?.getLive () .removeInterest (_set_live__, this);
      this [_executionContext] ?.getLive () .removeInterest (_set_live__, this);
      this [_browser]          ?.getLive () .removeInterest (_set_live__, this);

      this .setLive (false);

      for (const field of this [_childObjects])
         field .dispose ();

      for (const field of this [_predefinedFields])
         field .dispose ();

      for (const field of this [_userDefinedFields])
         field .dispose ();

      X3DChildObject/* default */.A .prototype .dispose .call (this);
   },
});

const getFieldFromArray = (() =>
{
   const
      set_field     = /^set_(.*?)$/,
      field_changed = /^(.*?)_changed$/;

   return function (array, name)
   {
      const field = array .get (name);

      if (field)
         return field;

      const match = name .match (set_field);

      if (match)
      {
         const field = array .get (match [1]);

         if (field ?.getAccessType () === X3DConstants/* default */.A .inputOutput)
            return field;
      }
      else
      {
         const match = name .match (field_changed);

         if (match)
         {
            const field = array .get (match [1]);

            if (field ?.getAccessType () === X3DConstants/* default */.A .inputOutput)
               return field;
         }
      }
   };
})();

for (const key of Object .keys (X3DBaseNode .prototype))
   Object .defineProperty (X3DBaseNode .prototype, key, { enumerable: false });

Object .defineProperties (X3DBaseNode .prototype,
{
   name_changed:
   {
      get () { return this ._name_changed; },
   },
   typeName_changed:
   {
      get () { return this ._typeName_changed; },
   },
   parents_changed:
   {
      get () { return this ._parents_changed; },
   },
});

const X3DBaseNode_default_ = X3DBaseNode;
;

/* harmony default export */ const Base_X3DBaseNode = (Namespace/* default */.A .add ("X3DBaseNode", X3DBaseNode_default_));

/***/ },

/***/ 7995
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Fields_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(9818);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(8427);


function X3DCast (type, node, innerNode = true)
{
   try
   {
      if (node instanceof _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFNode)
         node = node .getValue ();

      node = innerNode ? node ?.getInnerNode () : node ?.valueOf ();

      if (node ?.getType () .includes (type))
         return node;
   }
   catch
   { }

   return null;
}

const __default__ = X3DCast;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .add ("X3DCast", __default__));

/***/ },

/***/ 8927
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _X3DObject_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(4664);
/* harmony import */ var _IterableWeakSet_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(9041);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(8427);



const
   _modificationTime = Symbol (),
   _tainted          = Symbol (),
   _parents          = Symbol (),
   _private          = Symbol ();

const EMPTY = [ ];

function X3DChildObject ()
{
   _X3DObject_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .call (this);
}

Object .assign (Object .setPrototypeOf (X3DChildObject .prototype, _X3DObject_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .prototype),
{
   [_modificationTime]: -1,
   [_tainted]: false,
   [_parents]: null,
   [_private]: false,
   isInitializable ()
   {
      return true;
   },
   isInput ()
   {
      return false;
   },
   isOutput ()
   {
      return false;
   },
   setModificationTime (value)
   {
      this [_modificationTime] = value;
   },
   getModificationTime ()
   {
      return this [_modificationTime];
   },
   setTainted (value)
   {
      this [_tainted] = value;
   },
   isTainted ()
   {
      return this [_tainted];
   },
   addEvent ()
   {
      for (const parent of this [_parents] ?? EMPTY)
         parent .addEvent (this);
   },
   addEventObject (field, event)
   {
      for (const parent of this [_parents] ?? EMPTY)
         parent .addEventObject (this, event);
   },
   processEvent ()
   {
      this .setTainted (false);
      this .processInterests ();
   },
   isPrivate ()
   {
      return this [_private];
   },
   setPrivate (value)
   {
      this [_private] = value;
   },
   collectCloneCount ()
   {
      let cloneCount = 0;

      for (const parent of this [_parents] ?? EMPTY)
      {
         if (parent [_private])
            continue;

         cloneCount += parent .collectCloneCount ();
      }

      return cloneCount;
   },
   addParent (parent)
   {
      this .getParents () .add (parent);

      this .parentsChanged ();
   },
   removeParent (parent)
   {
      this [_parents] ?.delete (parent);

      this .parentsChanged ();
   },
   getParents ()
   {
      return this [_parents] ??= new _IterableWeakSet_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A ();
   },
   parentsChanged ()
   { },
   dispose ()
   {
      this [_parents] ?.clear ();

      _X3DObject_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .prototype .dispose .call (this);
   },
});

for (const key of Object .keys (X3DChildObject .prototype))
   Object .defineProperty (X3DChildObject .prototype, key, { enumerable: false });

const __default__ = X3DChildObject;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .add ("X3DChildObject", __default__));

/***/ },

/***/ 3411
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(8427);
const X3DConstants =
{
   [Symbol .toStringTag]: "X3DConstants",
};

let CONSTANT_VALUE = 1000;

Object .defineProperty (X3DConstants, "addConstant",
{
   value (name, value)
   {
      if (this .hasOwnProperty (name) || this .hasOwnProperty (value))
         return;

      Object .defineProperty (this, name,
      {
         value: value ?? ++ CONSTANT_VALUE,
         enumerable: true,
      });

      Object .defineProperty (this, this [name],
      {
         value: name,
      });
   },
});

Object .entries ({
   // Access types

   initializeOnly: 0b001,
   inputOnly:      0b010,
   outputOnly:     0b100,
   inputOutput:    0b111,
})
.forEach (([name, value]) => X3DConstants .addConstant (name, value));

[
   // Browser events

   "CONNECTION_ERROR",
   "BROWSER_EVENT",
   "INITIALIZED_EVENT",
   "SHUTDOWN_EVENT",
   "INITIALIZED_ERROR",

   // Load states

   "NOT_STARTED_STATE",
   "IN_PROGRESS_STATE",
   "COMPLETE_STATE",
   "FAILED_STATE",

   // X3DField

   "SFBool",
   "SFColor",
   "SFColorRGBA",
   "SFDouble",
   "SFFloat",
   "SFImage",
   "SFInt32",
   "SFMatrix3d",
   "SFMatrix3f",
   "SFMatrix4d",
   "SFMatrix4f",
   "SFNode",
   "SFRotation",
   "SFString",
   "SFTime",
   "SFVec2d",
   "SFVec2f",
   "SFVec3d",
   "SFVec3f",
   "SFVec4d",
   "SFVec4f",

   "VrmlMatrix",

   // X3DArrayField

   "MFBool",
   "MFColor",
   "MFColorRGBA",
   "MFDouble",
   "MFFloat",
   "MFImage",
   "MFInt32",
   "MFMatrix3d",
   "MFMatrix3f",
   "MFMatrix4d",
   "MFMatrix4f",
   "MFNode",
   "MFRotation",
   "MFString",
   "MFTime",
   "MFVec2d",
   "MFVec2f",
   "MFVec3d",
   "MFVec3f",
   "MFVec4d",
   "MFVec4f",

   // Abstract and concrete nodes and nodes types are added later.
]
.forEach (name => X3DConstants .addConstant (name));

const __default__ = X3DConstants;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .add ("X3DConstants", __default__));

/***/ },

/***/ 9862
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _X3DChildObject_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(8927);
/* harmony import */ var _X3DConstants_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(3411);
/* harmony import */ var _Events_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(246);
/* harmony import */ var _IterableWeakSet_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(9041);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(8427);





const
   _value               = Symbol (),
   _accessType          = Symbol (),
   _unit                = Symbol (),
   _references          = Symbol (),
   _referencesCallbacks = Symbol (),
   _fieldInterests      = Symbol (),
   _fieldCallbacks      = Symbol (),
   _inputRoutes         = Symbol (),
   _outputRoutes        = Symbol (),
   _routeCallbacks      = Symbol (),
   _appInfo             = Symbol (),
   _documentation       = Symbol (),
   _uniformLocation     = Symbol .for ("X_ITE.X3DField.uniformLocation");

const EMPTY = [ ];

function X3DField (value)
{
   _X3DChildObject_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .call (this);

   this [_value] = value;
}

Object .assign (Object .setPrototypeOf (X3DField .prototype, _X3DChildObject_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .prototype),
{
   [_value]: undefined,
   [_accessType]: _X3DConstants_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .initializeOnly,
   [_unit]: undefined,
   [_references]: null,
   [_referencesCallbacks]: null,
   [_fieldInterests]: null,
   [_fieldCallbacks]: null,
   [_inputRoutes]: null,
   [_outputRoutes]: null,
   [_routeCallbacks]: null,
   [_uniformLocation]: null,
   [_appInfo]: "",
   [_documentation]: "",
   create ()
   {
      return new (this .constructor) ();
   },
   equals (field)
   {
      return this [_value] === field .valueOf ();
   },
   assign (field)
   {
      // Assigns field to this field.
      this .set (field .getValue ());
      this .addEvent ();
   },
   set (value)
   {
      // Sets internal value without generating event.
      this [_value] = value;
   },
   setValue (value)
   {
      // Sets internal value and generates event.
      this .set (value instanceof this .constructor ? value .getValue () : value);
      this .addEvent ();
   },
   getValue ()
   {
      return this [_value];
   },
   getType ()
   {
      return this .constructor .type;
   },
   setAccessType (value)
   {
      this [_accessType] = value;
   },
   getAccessType ()
   {
      return this [_accessType];
   },
   isInitializable ()
   {
      return !! (this [_accessType] & _X3DConstants_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .initializeOnly);
   },
   isInput ()
   {
      return !! (this [_accessType] & _X3DConstants_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .inputOnly);
   },
   isOutput ()
   {
      return !! (this [_accessType] & _X3DConstants_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .outputOnly);
   },
   isReadable ()
   {
      return this [_accessType] !== _X3DConstants_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .inputOnly;
   },
   isWritable ()
   {
      return this [_accessType] !== _X3DConstants_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .outputOnly;
   },
   setUnit (value)
   {
      this [_unit] = value;
   },
   getUnit ()
   {
      return this [_unit];
   },
   isReference (accessType)
   {
      return accessType === this [_accessType] || accessType === _X3DConstants_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .inputOutput;
   },
   addReference (reference)
   {
      const references = this .getReferences ();

      if (references .has (reference))
         return;

      references .add (reference);

      // Create IS relationship

      switch (this .getAccessType () & reference .getAccessType ())
      {
         case _X3DConstants_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .initializeOnly:
            reference .addFieldInterest (this);
            this .processEvent (_Events_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .from (reference));
            break;
         case _X3DConstants_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .inputOnly:
            reference .addFieldInterest (this);
            break;
         case _X3DConstants_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .outputOnly:
            this .addFieldInterest (reference);
            break;
         case _X3DConstants_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .inputOutput:
            reference .addFieldInterest (this);
            this .addFieldInterest (reference);
            this .processEvent (_Events_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .from (reference));
            break;
      }

      this .processReferencesCallbacks ();
   },
   removeReference (reference)
   {
      this [_references] ?.delete (reference);

      // Create IS relationship

      switch (this .getAccessType () & reference .getAccessType ())
      {
         case _X3DConstants_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .initializeOnly:
            reference .removeFieldInterest (this);
            break;
         case _X3DConstants_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .inputOnly:
            reference .removeFieldInterest (this);
            break;
         case _X3DConstants_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .outputOnly:
            this .removeFieldInterest (reference);
            break;
         case _X3DConstants_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .inputOutput:
            reference .removeFieldInterest (this);
            this .removeFieldInterest (reference);
            break;
      }

      this .processReferencesCallbacks ();
   },
   getReferences ()
   {
      return this [_references] ??= new _IterableWeakSet_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A ();
   },
   addReferencesCallback (key, object)
   {
      this [_referencesCallbacks] = new Map (this [_referencesCallbacks]);

      this [_referencesCallbacks] .set (key, object);
   },
   removeReferencesCallback (key)
   {
      this [_referencesCallbacks] ?.delete (key);
   },
   getReferencesCallbacks ()
   {
      return this [_referencesCallbacks] ??= new Map ();
   },
   processReferencesCallbacks ()
   {
      for (const callback of this [_referencesCallbacks] ?.values () ?? EMPTY)
         callback ();
   },
   addFieldInterest (field)
   {
      // There must be no copy, because the event is not executed immediately.

      this .getFieldInterests () .add (field);
   },
   removeFieldInterest (field)
   {
      this [_fieldInterests] ?.delete (field);
   },
   getFieldInterests ()
   {
      return this [_fieldInterests] ??= new _IterableWeakSet_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A ();
   },
   addFieldCallback (key, object)
   {
      this [_fieldCallbacks] = new Map (this [_fieldCallbacks]);

      this [_fieldCallbacks] .set (key, object);
   },
   removeFieldCallback (key)
   {
      this [_fieldCallbacks] ?.delete (key);
   },
   getFieldCallbacks ()
   {
      return this [_fieldCallbacks] ??= new Map ();
   },
   addInputRoute (route)
   {
      this .getInputRoutes () .add (route);
      this .processRouteCallbacks ();
   },
   removeInputRoute (route)
   {
      this [_inputRoutes] ?.delete (route);

      this .processRouteCallbacks ();
   },
   getInputRoutes ()
   {
      return this [_inputRoutes] ??= new _IterableWeakSet_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A ();
   },
   addOutputRoute (route)
   {
      this .getOutputRoutes () .add (route);
      this .processRouteCallbacks ();
   },
   removeOutputRoute (route)
   {
      this [_outputRoutes] ?.delete (route);

      this .processRouteCallbacks ();
   },
   getOutputRoutes ()
   {
      return this [_outputRoutes] ??= new _IterableWeakSet_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A ();
   },
   addRouteCallback (key, object)
   {
      // Processed if routes are changed.

      this [_routeCallbacks] = new Map (this [_routeCallbacks]);

      this [_routeCallbacks] .set (key, object);
   },
   removeRouteCallback (key)
   {
      this [_routeCallbacks] ?.delete (key);
   },
   getRouteCallbacks ()
   {
      return this [_routeCallbacks] ??= new Map ();
   },
   processRouteCallbacks ()
   {
      for (const callback of this [_routeCallbacks] ?.values () ?? EMPTY)
         callback ();
   },
   processEvent (event = _Events_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .create (this))
   {
      event .add (this);

      this .setTainted (false);

      const field = event .field;

      if (field !== this)
         this .set (field .getValue (), field .length);

      // Process interests.

      this .processInterests ();

      // Process routes.

      let first = true;

      for (const field of this [_fieldInterests] ?? EMPTY)
      {
         if (event .has (field))
            continue;

         if (first)
         {
            first = false;
            field .addEventObject (this, event);
         }
         else
         {
            field .addEventObject (this, _Events_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .copy (event));
         }
      }

      if (first)
         _Events_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .push (event);

      // Process field callbacks.

      for (const callback of this [_fieldCallbacks] ?.values () ?? EMPTY)
         callback (this .valueOf ());
   },
   getAppInfo ()
   {
      return this [_appInfo];
   },
   setAppInfo (value)
   {
      this [_appInfo] = String (value);
   },
   setDocumentation (value)
   {
      this [_documentation] = String (value);
   },
   getDocumentation ()
   {
      return this [_documentation];
   },
   fromString (string, scene)
   {
      this .fromVRMLString (string, scene);
   },
   fromVRMLString (string, scene)
   {
      // Function will be overridden in VRMLParser.
   },
   fromXMLString (string, scene)
   {
      // Function will be overridden in XMLParser.
   },
   dispose ()
   {
      for (const reference of this [_references] ?? EMPTY)
         reference .removeFieldInterest (this);

      for (const route of Array .from (this [_inputRoutes] ?? EMPTY))
         route .dispose ();

      for (const route of Array .from (this [_outputRoutes] ?? EMPTY))
         route .dispose ();

      this [_references]          ?.clear ();
      this [_referencesCallbacks] ?.clear ();
      this [_fieldInterests]      ?.clear ();
      this [_fieldCallbacks]      ?.clear ();
      this [_inputRoutes]         ?.clear ();
      this [_outputRoutes]        ?.clear ();
      this [_routeCallbacks]      ?.clear ();

      _X3DChildObject_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .prototype .dispose .call (this);
   }
});

for (const key of Object .keys (X3DField .prototype))
   Object .defineProperty (X3DField .prototype, key, { enumerable: false });

const __default__ = X3DField;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .add ("X3DField", __default__));

/***/ },

/***/ 3927
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _X3DObject_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(4664);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(8427);


const
   _accessType = Symbol (),
   _name       = Symbol (),
   _value      = Symbol ();

function X3DFieldDefinition (accessType, name, value)
{
   this [_accessType] = accessType;
   this [_name]       = name;
   this [_value]      = value;
}

Object .assign (Object .setPrototypeOf (X3DFieldDefinition .prototype, _X3DObject_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .prototype),
{
   getAccessType ()
   {
      return this [_accessType];
   },
   getDataType ()
   {
      return this [_value] .getType ();
   },
   getName ()
   {
      return this [_name];
   },
   getValue ()
   {
      return this [_value];
   },
   getAppInfo ()
   {
      return this [_value] .getAppInfo ();
   },
   setAppInfo (value)
   {
      return this [_value] .setAppInfo (value);
   },
   getDocumentation ()
   {
      return this [_value] .getDocumentation ();
   },
   setDocumentation (value)
   {
      this [_value] .setDocumentation (value);
   },
});

for (const key of Object .keys (X3DFieldDefinition .prototype))
   Object .defineProperty (X3DFieldDefinition .prototype, key, { enumerable: false });

Object .defineProperties (X3DFieldDefinition .prototype,
{
   accessType:
   {
      get: X3DFieldDefinition .prototype .getAccessType,
      enumerable: true,
   },
   dataType:
   {
      get: X3DFieldDefinition .prototype .getDataType,
      enumerable: true,
   },
   name:
   {
      get: X3DFieldDefinition .prototype .getName,
      enumerable: true,
   },
   value:
   {
      get () { return this .getValue () .valueOf (); },
      enumerable: true,
   },
   appInfo:
   {
      get: X3DFieldDefinition .prototype .getAppInfo,
      set: X3DFieldDefinition .prototype .setAppInfo,
      enumerable: true,
   },
   documentation:
   {
      get: X3DFieldDefinition .prototype .getDocumentation,
      set: X3DFieldDefinition .prototype .setDocumentation,
      enumerable: true,
   },
});

Object .defineProperties (X3DFieldDefinition,
{
   typeName:
   {
      value: "X3DFieldDefinition",
      enumerable: true,
   },
});

const __default__ = X3DFieldDefinition;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .add ("X3DFieldDefinition", __default__));

/***/ },

/***/ 9563
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _X3DChildObject_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(8927);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(8427);


const
   _array     = Symbol (),
   _index     = Symbol (),
   _valueType = Symbol ();

const handler =
{
   get (target, key)
   {
      const value = target [key];

      if (value !== undefined)
         return value;

      if (typeof key === "string")
      {
         const index = +key;

         if (Number .isInteger (index))
            return target [_array] [index];

         return;
      }
   },
   set (target, key, value)
   {
      if (target [key] === undefined)
         return false;

      target [key] = value;
      return true;
   },
   has (target, key)
   {
      if (Number .isInteger (+key))
         return key < target [_array] .length;

      return key in target;
   },
   ownKeys (target)
   {
      return Object .keys (target [_array]);
   },
   getOwnPropertyDescriptor (target, key)
   {
      if (typeof key !== "string")
         return;

      const index = +key;

      if (Number .isInteger (index) && index < target [_array] .length)
      {
         const propertyDescriptor = Object .getOwnPropertyDescriptor (target [_array], key);

         if (propertyDescriptor)
            propertyDescriptor .writable = false;

         return propertyDescriptor;
      }
   },
};

function X3DInfoArray (values, valueType)
{
   const proxy = new Proxy (this, handler);

   _X3DChildObject_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .call (this);

   this [_array]     = [ ];
   this [_index]     = new Map ();
   this [_valueType] = valueType;

   for (const [key, value] of values)
      this .add (key, value);

   return proxy;
}

Object .assign (Object .setPrototypeOf (X3DInfoArray .prototype, _X3DChildObject_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .prototype),
{
   *[Symbol .iterator] ()
   {
      yield* this [_array];
   },
   copy ()
   {
      const copy = new (this .constructor) ();

      copy .assign (this);

      return copy;
   },
   clear ()
   {
      this [_array] .length = 0;
      this [_index] .clear ();

      this .addEvent ();
   },
   assign (array)
   {
      if (!(array instanceof this .constructor))
         throw new Error ("Couldn't assign info array, wrong type.");

      this [_array] = Array .from (array [_array]);
      this [_index] = new Map (array [_index]);

      this .addEvent ();
   },
   equals (array)
   {
      const
         a      = this [_array],
         b      = array [_array],
         length = a .length;

      if (a === b)
         return true;

      if (length !== b .length)
         return false;

      for (let i = 0; i < length; ++ i)
      {
         if (a [i] !== b [i])
            return false;
      }

      return true;
   },
   has (key)
   {
      return this [_index] .has (key);
   },
   get (key)
   {
      return this [_index] .get (key);
   },
   add (key, value)
   {
      if (this [_index] .has (key))
         throw new Error (`Couldn't add value to ${this .getTypeName ()}, key '${key}' already exists.`);

      if (!(value instanceof this [_valueType]))
         throw new Error (`Couldn't add value to ${this .getTypeName ()}, value for key '${key}' has wrong type.`);

      this [_array] .push (value);
      this [_index] .set (key, value);

      this .addEvent ();
   },
   alias (alias, value)
   {
      this [_index] .set (alias, value);

      this .addEvent ();
   },
   update (oldKey, newKey, value)
   {
      // TODO: update alias.

      if (!(value instanceof this [_valueType]))
         throw new Error (`Couldn't update value of ${this .getTypeName ()}, value for key '${key}' has wrong type.`);

      const oldValue = this [_index] .get (oldKey);

      if (oldKey !== newKey)
         this .remove (newKey);

      this [_index] .delete (oldKey);
      this [_index] .set (newKey, value);

      if (oldValue !== undefined)
      {
         const index = this [_array] .indexOf (oldValue);

         if (index > -1)
            this [_array] [index] = value;
      }
      else
      {
         this [_array] .push (value);
      }

      this .addEvent ();
   },
   remove (key)
   {
      // TODO: remove alias.

      const value = this [_index] .get (key);

      if (value === undefined)
         return;

      const index = this [_array] .indexOf (value);

      this [_index] .delete (key);

      if (index > -1)
         this [_array] .splice (index, 1);

      this .addEvent ();
   },
   at: Array .prototype .at,
   // concat: Array .prototype .concat,
   // copyWithin: Array.prototype.copyWithin,
   entries: Array .prototype .entries,
   every: Array .prototype .every,
   // fill: Array .prototype .fill,
   filter (callbackFn, thisArg)
   {
      return new (this .constructor) (Array .prototype .filter .call (this, callbackFn, thisArg));
   },
   find: Array .prototype .find,
   findIndex: Array .prototype .findIndex,
   findLast: Array .prototype .findLast,
   findLastIndex: Array .prototype .findLastIndex,
   flat: Array .prototype .flat,
   flatMap: Array .prototype .flatMap,
   forEach: Array .prototype .forEach,
   includes: Array .prototype .includes,
   indexOf: Array .prototype .indexOf,
   join: Array .prototype .join,
   keys: Array .prototype .keys,
   lastIndexOf: Array .prototype .lastIndexOf,
   map (callbackFn, thisArg)
   {
      return new (this .constructor) (Array .prototype .map .call (this, callbackFn, thisArg));
   },
   reduce: Array .prototype .reduce,
   reduceRight: Array .prototype .reduceRight,
   // reverse: Array .prototype .reverse,
   slice (start, end)
   {
      return new (this .constructor) (Array .prototype .slice .call (this, start, end));
   },
   some: Array .prototype .some,
   // sort: Array .prototype .sort,
   toReversed ()
   {
      return new (this .constructor) ([... this] .reverse ());
   },
   toSorted (compareFn)
   {
      return new (this .constructor) ([... this] .sort (compareFn));
   },
   toSpliced (start, deleteCount, ... insertValues)
   {
      const array = [... this];

      array .splice (start, deleteCount, ... insertValues)

      return new (this .constructor) (array);
   },
   values: Array .prototype .values,
   with (index, value)
   {
      const array = [... this];

      array [index] = value;

      return new (this .constructor) (array);
   },
   toVRMLStream (generator)
   {
      const proto = this .getTypeName () .includes ("Proto");

      for (const value of this [_array])
      {
         try
         {
            value .toVRMLStream (generator);

            generator .Break ();

            if (proto)
               generator .TidyBreak ();
         }
         catch (error)
         {
            // console .error (error);
         }
      }
   },
   toXMLStream (generator)
   {
      for (const value of this [_array])
      {
         try
         {
            value .toXMLStream (generator);

            generator .TidyBreak ();
         }
         catch (error)
         {
            // console .error (error);
         }
      }
   },
   toJSONStream (generator, comma = false)
   {
      for (const value of this [_array])
      {
         try
         {
            if (comma)
               generator .string += ',';

            value .toJSONStream (generator, true);

            comma = true;
         }
         catch
         {
            generator .RemoveComma ();
         }
      }

      return comma;
   },
});

for (const key of Object .keys (X3DInfoArray .prototype))
   Object .defineProperty (X3DInfoArray .prototype, key, { enumerable: false });

Object .defineProperties (X3DInfoArray .prototype,
{
   length:
   {
      get () { return this [_array] .length; },
   },
});

const __default__ = X3DInfoArray;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .add ("X3DInfoArray", __default__));

/***/ },

/***/ 4664
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  A: () => (/* binding */ Base_X3DObject)
});

// EXTERNAL MODULE: ./src/x_ite/Base/X3DConstants.js
var X3DConstants = __webpack_require__(3411);
// EXTERNAL MODULE: ./src/standard/Math/Algorithm.js
var Algorithm = __webpack_require__(9919);
// EXTERNAL MODULE: ./src/x_ite/Execution/NamedNodesHandling.js
var NamedNodesHandling = __webpack_require__(5277);
// EXTERNAL MODULE: ./src/x_ite/Namespace.js
var Namespace = __webpack_require__(8427);
;// ./src/x_ite/InputOutput/X3DGenerator.js




function Generator ({ style = "TIDY", indent = "", indentChar = "  ", precision = 7, doublePrecision = 15, names = true } = { })
{
   this .string          = "";
   this .indent          = indent;
   this .listIndent      = indent;
   this .precision       = Algorithm/* default */.A .clamp (precision, 1, 21);
   this .doublePrecision = Algorithm/* default */.A .clamp (doublePrecision, 1, 21);
   this .outputNames     = names; // private option: used in StaticGroup for toVRMLString.

   this .floatFormat             = this .createFloatFormat (this .precision);
   this .floatExponentialFormat  = this .createFloatExponentialFormat (this .precision);
   this .doubleFormat            = this .createFloatFormat (this .doublePrecision);
   this .doubleExponentialFormat = this .createFloatExponentialFormat (this .doublePrecision);

   this .Style (style, indentChar);

   this .executionContextStack = [ ];
   this .executionContextIndex = new Set ();
   this .importedNodesIndex    = new Map ();
   this .importedNames         = new Map ();
   this .exportedNodesIndex    = new Map ();
   this .nodes                 = new Map ();
   this .names                 = new Map ();
   this .namesByNode           = new Map ();
   this .routeNodes            = new Map ();
}

Object .assign (Generator .prototype,
{
   Style (style, indentChar = "  ")
   {
      switch (style)
      {
         case "CLEAN":
         {
            this .listIndent = "";

            this .comma          = " ";
            this .break          = " ";
            this .tidyBreak      = "";
            this .tidySpace      = "";
            this .indentChar     = "";
            this .listEnclosure  = "";
            this .listBreak      = "";
            this .listIndentChar = "";
            this .attribBreak    = " ";
            break;
         }
         case "SMALL":
         {
            this .listIndent = "";

            this .comma          = ",";
            this .break          = "\n";
            this .tidyBreak      = "\n";
            this .tidySpace      = "";
            this .indentChar     = "";
            this .listEnclosure  = "";
            this .listBreak      = "";
            this .listIndentChar = "";
            this .attribBreak    = " ";
            break;
         }
         case "COMPACT":
         {
            this .listIndent = "";

            this .comma          = ",";
            this .break          = "\n";
            this .tidyBreak      = "\n";
            this .tidySpace      = " ";
            this .indentChar     = indentChar;
            this .listEnclosure  = " ";
            this .listBreak      = " ";
            this .listIndentChar = "";
            this .attribBreak    = " ";
            break;
         }
         case "TIDY":
         default:
         {
            this .comma          = ",";
            this .break          = "\n";
            this .tidyBreak      = "\n";
            this .tidySpace      = " ";
            this .indentChar     = indentChar;
            this .listEnclosure  = "\n";
            this .listBreak      = "\n";
            this .listIndentChar = this .indentChar;
            this .attribBreak    = "\n";
            break;
         }
      }
   },
   Comma ()
   {
      this .string += this .comma;
   },
   Break ()
   {
      this .needsSpace = false;

      this .string += this .break;
   },
   TidyBreak ()
   {
      this .needsSpace &&= !this .tidyBreak;

      this .string += this .tidyBreak;
   },
   Space ()
   {
      this .needsSpace = false;

      this .string += " ";
   },
   TidySpace ()
   {
      this .needsSpace &&= !this .tidySpace;

      this .string += this .tidySpace;
   },
   ListStart ()
   {
      this .string += this .listEnclosure;
   },
   ListEnd ()
   {
      this .string += this .listEnclosure;
   },
   ListBreak ()
   {
      this .string += this .listBreak;
   },
   AttribBreak ()
   {
      this .string += this .attribBreak;
   },
   Indent ()
   {
      this .string += this .indent;
   },
   ListIndent ()
   {
      this .string += this .listIndent;
   },
   IncIndent ()
   {
      this .indent     += this .indentChar;
      this .listIndent += this .listIndentChar;
   },
   DecIndent ()
   {
      this .indent     = this .indent     .slice (0, -this .indentChar     .length);
      this .listIndent = this .listIndent .slice (0, -this .listIndentChar .length);
   },
   NeedsSpace ()
   {
      this .needsSpace = true;
   },
   CheckSpace ()
   {
      if (this .needsSpace)
         this .string += " ";

      this .needsSpace = false;
   },
   createFloatFormat (precision)
   {
      return new Intl .NumberFormat ("en",
      {
         notation: "standard",
         maximumSignificantDigits: precision,
         useGrouping: false,
      })
      .format;
   },
   createFloatExponentialFormat (precision)
   {
      return new Intl .NumberFormat ("en",
      {
         notation: "scientific",
         maximumSignificantDigits: precision,
         useGrouping: false,
      })
      .format;
   },
   FloatFormat  (value)
   {
      if (Number .isFinite (value))
      {
         const exponent = Math .log10 (Math .abs (value));

         if ((this .precision > exponent && exponent >= -4) || value === 0)
            return this .floatFormat (value);

         return this .floatExponentialFormat (value) .toLowerCase ();
      }
      else
      {
         return String (value);
      }
   },
   DoubleFormat  (value)
   {
      if (Number .isFinite (value))
      {
         const exponent = Math .log10 (Math .abs (value));

         if ((this .doublePrecision > exponent && exponent >= -4) || value === 0)
            return this .doubleFormat (value);

         return this .doubleExponentialFormat (value) .toLowerCase ();
      }
      else
      {
         return String (value);
      }
   },
   PushExecutionContext (executionContext)
   {
      this .executionContextStack .push (executionContext);

      if (this .executionContextIndex .has (executionContext))
         return;

      this .executionContextIndex .add (executionContext);
      this .importedNodesIndex    .set (executionContext, new Set ());
      this .importedNames         .set (executionContext, new Map ());
      this .exportedNodesIndex    .set (executionContext, new Set ());
      this .nodes                 .set (executionContext, new Set ());
      this .names                 .set (executionContext, new Set ());
      this .namesByNode           .set (executionContext, new Map ());
      this .routeNodes            .set (executionContext, new Set ());

      this .needsSpace = false;
   },
   PopExecutionContext ()
   {
      const executionContext = this .executionContextStack .pop ();

      if (this .executionContextStack .at (-1) === executionContext)
         return;

      this .executionContextIndex .delete (executionContext);
      this .importedNodesIndex    .delete (executionContext);
      this .importedNames         .delete (executionContext);
      this .exportedNodesIndex    .delete (executionContext);
      this .nodes                 .delete (executionContext);
      this .names                 .delete (executionContext);
      this .namesByNode           .delete (executionContext);
      this .routeNodes            .delete (executionContext);
   },
   ExecutionContext ()
   {
      return this .executionContextStack .at (-1);
   },
   NamedNodes (namedNodes)
   {
      const
         names       = this .names .get (this .ExecutionContext ()),
         namesByNode = this .namesByNode .get (this .ExecutionContext ());

      for (const node of namedNodes)
      {
         if (node .getNodeName () .match (/^_\d+$/))
            continue;

         names .add (node .getNodeName ());
         namesByNode .set (node .getValue (), node .getNodeName ());
      }
   },
   ExportedNodes (exportedNodes)
   {
      const index = this .exportedNodesIndex .get (this .ExecutionContext ());

      for (const exportedNode of exportedNodes)
         index .add (exportedNode .getLocalNode ());
   },
   ImportedNodes (importedNodes)
   {
      const index = this .importedNodesIndex .get (this .ExecutionContext ());

      for (const importedNode of importedNodes)
         index .add (importedNode .getInlineNode ());
   },
   AddRouteNode (routeNode)
   {
      const routeNodes = this .routeNodes .get (this .ExecutionContext ());

      routeNodes .add (routeNode);
   },
   ExistsRouteNode (routeNode)
   {
      const routeNodes = this .routeNodes .get (this .ExecutionContext ());

      return routeNodes .has (routeNode);
   },
   IsSharedNode (baseNode)
   {
      return this .ExecutionContext () !== baseNode .getExecutionContext ();
   },
   AddNode (baseNode)
   {
      const nodes = this .nodes .get (this .ExecutionContext ());

      nodes .add (baseNode);

      this .AddRouteNode (baseNode);
   },
   ExistsNode (baseNode)
   {
      const nodes = this .nodes .get (this .ExecutionContext ());

      return nodes .has (baseNode);
   },
   Name (baseNode)
   {
      // Is the node already in index.

      const
         namesByNode = this .namesByNode .get (this .ExecutionContext ()),
         name        = namesByNode .get (baseNode);

      if (name !== undefined)
      {
         return name;
      }
      else
      {
         const
            names = this .names .get (this .ExecutionContext ()),
            name  = baseNode .getName ();

         // The node has no name.

         if (name .match (/^(?:_\d+)?$/) && !this .NeedsName (baseNode))
            return "";

         const newName = (0,NamedNodesHandling/* getUniqueName */.l) (names, name);

         // Add to indices.

         names .add (newName);
         namesByNode .set (baseNode, newName);

         return newName;
      }
   },
   NeedsName (baseNode)
   {
      if (baseNode .getCloneCount () > 1)
         return true;

      if (baseNode .hasRoutes ())
         return true;

      const executionContext = this .ExecutionContext ();

      if (this .importedNodesIndex .get (executionContext) .has (baseNode))
         return true;

      if (this .exportedNodesIndex .get (executionContext) .has (baseNode))
         return true;

      return false;
   },
   ImportedName (importedNode)
   {
      const importedNames = this .importedNames .get (this .ExecutionContext ());

      if (importedNames .has (importedNode))
         return importedNames .get (importedNode);

      const
         names   = this .names .get (this .ExecutionContext ()),
         newName = (0,NamedNodesHandling/* getUniqueName */.l) (names, importedNode .getImportedName ());

      // Add to indices.

      names .add (newName);
      importedNames .set (importedNode, newName);

      return newName;
   },
   AccessType (accessType)
   {
      switch (accessType)
      {
         case X3DConstants/* default */.A .initializeOnly:
            return "initializeOnly";
         case X3DConstants/* default */.A .inputOnly:
            return "inputOnly";
         case X3DConstants/* default */.A .outputOnly:
            return "outputOnly";
         case X3DConstants/* default */.A .inputOutput:
            return "inputOutput";
      }
   },
   ToUnit (category, value)
   {
      return this .ExecutionContext () ?.toUnit (category, value) ?? value;
   },
});

for (const key of Object .keys (Generator .prototype))
   Object .defineProperty (Generator .prototype, key, { enumerable: false });

const __default__ = Generator;
;

/* harmony default export */ const X3DGenerator = (Namespace/* default */.A .add ("X3DGenerator", __default__));
;// ./src/x_ite/InputOutput/VRMLGenerator.js


function VRMLGenerator (options)
{
   X3DGenerator .call (this, options);
}

Object .assign (Object .setPrototypeOf (VRMLGenerator .prototype, X3DGenerator .prototype),
{
   NULL ()
   {
      this .CheckSpace ();
      this .string += "NULL";
      this .NeedsSpace ();
   },
});

for (const key of Object .keys (VRMLGenerator .prototype))
   Object .defineProperty (VRMLGenerator .prototype, key, { enumerable: false });

const VRMLGenerator_default_ = VRMLGenerator;
;

/* harmony default export */ const InputOutput_VRMLGenerator = (Namespace/* default */.A .add ("VRMLGenerator", VRMLGenerator_default_));
;// ./src/x_ite/InputOutput/XMLGenerator.js


function XMLGenerator (options = { })
{
   X3DGenerator .call (this, options);

   const { html = false, closingTags = false } = options;

   this .html            = html;
   this .closingTags     = html || closingTags;
   this .containerFields = [ ];
}

Object .assign (Object .setPrototypeOf (XMLGenerator .prototype, X3DGenerator .prototype),
{
   PushContainerField (field)
   {
      this .containerFields .push (field);
   },
   PopContainerField ()
   {
      this .containerFields .pop ();
   },
   EncodeString: (() =>
   {
      const map = {
         "\\": "\\\\",
         "\r": "&#xD;",
         "\n": "&#xA;",
         "\t": "&#x9;",
         "\"": "\\\"",
         "'": "&apos;",
         "<": "&lt;",
         ">": "&gt;",
         "&": "&amp;",
      };

      const regex = /([\\\r\n\t"'<>&])/g;

      return function (string)
      {
         return String (string) .replace (regex, char => map [char]);
      };
   })(),
   EncodeSourceText: (() =>
   {
      const map = {
         "\\": "\\\\",
         "\"": "\\\"",
         "'": "&apos;",
         "<": "&lt;",
         ">": "&gt;",
         "&": "&amp;",
      };

      const regex = /([\\"'<>&])/g;

      return function (string)
      {
         return string .replace (regex, char => map [char]);
      };
   })(),
   openingTag (name)
   {
      this .Indent ();
      this .string += "<";
      this .string += name;
      this .string += ">";
   },
   closingTag (name)
   {
      this .Indent ();
      this .string += "</";
      this .string += name;
      this .string += ">";
   },
   openTag (name)
   {
      this .Indent ();
      this .string += "<";
      this .string += name;
   },
   endTag ()
   {
      this .string += ">";
      this .TidyBreak ();
   },
   closeTag (name)
   {
      if (this .closingTags)
      {
         this .string += "></";
         this .string += name;
         this .string += ">";
      }
      else
      {
         this .string += "/>";
      }
   },
   attribute (name, value)
   {
      this .Space ();
      this .string += name;
      this .string += "='";
      this .string += this .EncodeString (value);
      this .string += "'";
   },
   containerField (defaultContainerField)
   {
      const containerField = this .containerFields .at (-1);

      if (!containerField)
         return;

      if (containerField .getName () !== defaultContainerField)
         this .attribute ("containerField", containerField .getName ());
   },
});

for (const key of Object .keys (XMLGenerator .prototype))
   Object .defineProperty (XMLGenerator .prototype, key, { enumerable: false });

const XMLGenerator_default_ = XMLGenerator;
;

/* harmony default export */ const InputOutput_XMLGenerator = (Namespace/* default */.A .add ("XMLGenerator", XMLGenerator_default_));
;// ./src/x_ite/InputOutput/JSONGenerator.js


function JSONGenerator (options)
{
   X3DGenerator .call (this, options);
}

Object .assign (Object .setPrototypeOf (JSONGenerator .prototype, X3DGenerator .prototype),
{
   EncodeString: (() =>
   {
      const map = {
         "\\": "\\\\",
         "\r": "\\r",
         "\n": "\\n",
         "\t": "\\t",
         "\"": "\\\"",
      };

      const regex = /([\\\t\n\r"])/g;

      return function (string)
      {
         return String (string) .replace (regex, char => map [char]);
      };
   })(),
   Number (value)
   {
      switch (value)
      {
         case "NaN":
         case "Infinity":
         case "-Infinity":
            return '"' + value + '"';
         default:
            return value;
      }
   },
   RemoveComma ()
   {
      this .string = this .string .replace (/,\s*$/s, "");
   },
   stringProperty (key, value, comma = true)
   {
      if (comma)
         this .string += ',';

      this .TidyBreak ();
      this .Indent ();
      this .string += '"';
      this .string += key;
      this .string += '"';
      this .string += ':';
      this .TidySpace ();
      this .string += '"';
      this .string += this .EncodeString (value);
      this .string += '"';
   },
   numberProperty (key, value, comma = true)
   {
      if (comma)
         this .string += ',';

      this .TidyBreak ();
      this .Indent ();
      this .string += '"';
      this .string += key;
      this .string += '"';
      this .string += ':';
      this .TidySpace ();
      this .string += value;
   },
   beginObject (name, comma = true, main = false)
   {
      if (comma)
         this .string += ',';

      if (name)
      {
         if (main)
         {
            this .string += '{';
            this .TidySpace ();
            this .string += '"';
            this .string += name;
            this .string += '"';
            this .string += ':';
            this .TidyBreak ();
            this .IncIndent ();
            this .Indent ();
            this .string += '{';
            this .IncIndent ();
         }
         else
         {
            this .TidyBreak ();
            this .Indent ();
            this .string += '"';
            this .string += name;
            this .string += '"';
            this .string += ':';
            this .TidySpace ();
            this .string += '{';
            this .IncIndent ();
         }
      }
      else
      {
         this .TidyBreak ();
         this .Indent ();
         this .string += '{';
         this .IncIndent ();
      }
   },
   endObject ()
   {
      this .TidyBreak ();
      this .DecIndent ();
      this .Indent ();
      this .string += '}';
   },
   beginArray (name, comma = true)
   {
      this .beginValue (name, comma);

      this .string += '[';
      this .IncIndent ();
   },
   endArray ()
   {
      this .TidyBreak ();
      this .DecIndent ();
      this .Indent ();
      this .string += ']';
   },
   beginValue (name, comma = true)
   {
      if (comma)
         this .string += ',';

      this .TidyBreak ();
      this .Indent ();
      this .string += '"';
      this .string += name;
      this .string += '"';
      this .string += ':';
      this .TidySpace ();
   },
});

for (const key of Object .keys (JSONGenerator .prototype))
   Object .defineProperty (JSONGenerator .prototype, key, { enumerable: false });

const JSONGenerator_default_ = JSONGenerator;
;

/* harmony default export */ const InputOutput_JSONGenerator = (Namespace/* default */.A .add ("JSONGenerator", JSONGenerator_default_));
// EXTERNAL MODULE: ./src/x_ite/Features.js
var Features = __webpack_require__(7538);
;// ./src/x_ite/Base/X3DObject.js
/* provided dependency */ var $ = __webpack_require__(8316)["default"];





const
   _name          = Symbol (),
   _interests     = Symbol (),
   _registry      = Symbol (),
   _userData      = Symbol (),
   _vrmlGenerator = Symbol (),
   _xmlGenerator  = Symbol (),
   _jsonGenerator = Symbol ();

function X3DObject () { }

Object .assign (X3DObject .prototype,
{
   [_name]: "",
   [_interests]: null,
   [_registry]: null,
   [_userData]: null,
   getId ()
   {
      return X3DObject .getId (this);
   },
   getTypeName ()
   {
      return this .constructor .typeName;
   },
   setName (value)
   {
      this [_name] = value;
   },
   getName ()
   {
      return this [_name];
   },
   getDisplayName ()
   {
      return this [_name];
   },
   hasInterest (callbackName, object)
   {
      return this [_interests] ?.has (X3DObject .getInterestId (object [callbackName], object)) ?? false;
   },
   addInterest (callbackName, object, ... args)
   {
      const
         weakRef    = new WeakRef (object),
         callback   = object [callbackName],
         interestId = X3DObject .getInterestId (callback, object);

      this [_registry] ??= new FinalizationRegistry (objectId =>
      {
         for (const interestId of this [_interests] .keys ())
         {
            if (interestId .endsWith (objectId))
               this [_interests] .delete (interestId);
         }
      });

      this [_interests] = new Map (this [_interests]);

      this [_registry] .register (object, interestId .replace (/^[^:]+/, ""), object);
      this [_interests] .set (interestId, { callback, weakRef, args });
   },
   removeInterest (callbackName, object)
   {
      this [_interests] ?.delete (X3DObject .getInterestId (object [callbackName], object));
   },
   getInterests ()
   {
      return this [_interests] ??= new Map ();
   },
   processInterests: (() =>
   {
      const EMPTY = [ ];

      return function ()
      {
         for (const { callback, weakRef, args } of this [_interests] ?.values () ?? EMPTY)
         {
            const object = weakRef .deref ();

            if (object)
               callback .call (object, ... args, this);
         }
      };
   })(),
   getUserData (key)
   {
      return this [_userData] ?.get (key);
   },
   setUserData (key, value)
   {
      this [_userData] ??= new Map ();

      this [_userData] .set (key, value);
   },
   removeUserData (key)
   {
      this [_userData] ?.delete (key);
   },
   toString (options)
   {
      const generator = !options || $.isEmptyObject (options)
         ? X3DObject [_vrmlGenerator] ??= new InputOutput_VRMLGenerator ()
         : new InputOutput_VRMLGenerator (options);

      generator .string = "";

      generator .PushExecutionContext (options ?.scene ?? null);

      this .toStream (generator);

      generator .PopExecutionContext ();

      return generator .string;
   },
   toVRMLString (options)
   {
      const generator = !options || $.isEmptyObject (options)
         ? X3DObject [_vrmlGenerator] ??= new InputOutput_VRMLGenerator ()
         : new InputOutput_VRMLGenerator (options);

      generator .string = "";

      generator .PushExecutionContext (options ?.scene ?? null);

      this .toVRMLStream (generator);

      generator .PopExecutionContext ();

      return generator .string;
   },
   toXMLString (options)
   {
      const generator = !options || $.isEmptyObject (options)
         ? X3DObject [_xmlGenerator] ??= new InputOutput_XMLGenerator ()
         : new InputOutput_XMLGenerator (options);

      generator .string = "";

      generator .PushExecutionContext (options ?.scene ?? null);

      this .toXMLStream (generator);

      generator .PopExecutionContext ();

      return generator .string;
   },
   toJSONString (options)
   {
      const generator = !options || $.isEmptyObject (options)
         ? X3DObject [_jsonGenerator] ??= new InputOutput_JSONGenerator ()
         : new InputOutput_JSONGenerator (options);

      generator .string = "";

      generator .PushExecutionContext (options ?.scene ?? null);

      this .toJSONStream (generator);

      generator .PopExecutionContext ();

      return generator .string;
   },
   toStream (generator)
   {
      generator .string = Object .prototype .toString .call (this);
   },
   dispose ()
   {
      this [_interests] ?.clear ();
      this [_userData]  ?.clear ();
   },
});

for (const key of Object .keys (X3DObject .prototype))
   Object .defineProperty (X3DObject .prototype, key, { enumerable: false });

Object .defineProperties (X3DObject .prototype,
{
   [Symbol .toStringTag]:
   {
      get () { return this .getTypeName (); },
   },
   // using and Symbol.dispose are not yet supported by Safari.
   // https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Statements/using
   // [Symbol .dispose]:
   // {
   //    get () { this .dispose (); },
   // },
});

Object .assign (X3DObject,
{
   [_vrmlGenerator]: null,
   [_xmlGenerator]: null,
   [_jsonGenerator]: null,
   getId: Features/* default */.A .FINALIZATION_REGISTRY ? (() =>
   {
      const
         map      = new WeakMap (),
         cache    = [ ],
         registry = new FinalizationRegistry (id => cache .push (id));

      let counter = 0;

      return function (object)
      {
         const id = map .get (object);

         if (id !== undefined)
         {
            return id;
         }
         else
         {
            const id = cache .pop () ?? ++ counter;

            map .set (object, id);
            registry .register (object, id);

            return id;
         }
      };
   })() : (() =>
   {
      const map = new WeakMap ();

      let counter = 0;

      return function (object)
      {
         const id = map .get (object);

         if (id !== undefined)
            return id;

         map .set (object, ++ counter);

         return counter;
      };
   })(),
   getInterestId (callback, object)
   {
      return `${this .getId (callback)}:${this .getId (object)}`;
   },
});

const X3DObject_default_ = X3DObject;
;

/* harmony default export */ const Base_X3DObject = (Namespace/* default */.A .add ("X3DObject", X3DObject_default_));

/***/ },

/***/ 4583
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Features_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(7538);
/* harmony import */ var _BROWSER_VERSION_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(8130);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(8427);



const URLs =
{
   getScriptURL: (() =>
   {
      let src;

      switch (_Features_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .ENVIRONMENT)
      {
         case "NODE":
         {
            src = __webpack_require__.g .require ("url") .pathToFileURL (__filename) .href;
            break;
         }
         case "BROWSER":
         {
            src = document .currentScript ?.src ?? document .location .href;
            break;
         }
         case "MODULE":
         {
            // src = import .meta .url;
            break;
         }
      }

      // Prevent caching issues with jsDelivr and UNPKG.
      src = src .replace ("/x_ite@latest/", `/x_ite@${_BROWSER_VERSION_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A}/`);

      return function ()
      {
         return src;
      };
   })(),
   getProviderURL (component)
   {
      if (!component)
         return "https://create3000.github.io/x_ite/";

      const min = this .getScriptURL () .match (/\.min\.m?js$/) ? ".min" : "";

      return new URL (`assets/components/${component}Component${min}.js`, this .getScriptURL ()) .href;
   },
   getFontsURL (file)
   {
      return new URL (`assets/fonts/${file}`, this .getScriptURL ()) .href;
   },
   getLinetypeURL ()
   {
      return new URL ("assets/linetype/linetypes.png", this .getScriptURL ()) .href;
   },
   getHatchingURL (index)
   {
      return new URL (`assets/hatching/${index}.png`, this .getScriptURL ()) .href;
   },
   getLibraryURL (file)
   {
      return new URL (`assets/lib/${file}`, this .getScriptURL ()) .href;
   },
};

const __default__ = URLs;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .add ("URLs", __default__));

/***/ },

/***/ 582
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Components_Rendering_X3DGeometryNode_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(3181);
/* harmony import */ var _Shape_AlphaMode_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(2283);
/* harmony import */ var _standard_Math_Numbers_Matrix4_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(6776);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(8427);




function GeometryContext (options = { })
{
   Object .assign (this,
   {
      alphaMode: _Shape_AlphaMode_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .OPAQUE,
      geometryType: 3,
      hasFogCoords: false,
      colorMaterial: false,
      hasNormals: false,
      hasTangents: false,
      textureNode: null,
      localObjectsKeys: [ ],
      textureCoordinateMapping: new Map (),
      textureCoordinateNode: null,
   },
   options)

   this .updateGeometryKey ();
}

Object .assign (GeometryContext .prototype,
{
   getMatrix ()
   {
      return _standard_Math_Numbers_Matrix4_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .IDENTITY;
   },
   getTextureCoordinateMapping ()
   {
      return this .textureCoordinateMapping;
   },
   getTextureCoordinate ()
   {
      return this .textureCoordinateNode;
   },
   updateGeometryKey: _Components_Rendering_X3DGeometryNode_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .prototype .updateGeometryKey,
});

const __default__ = GeometryContext;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .add ("GeometryContext", __default__));

/***/ },

/***/ 2283
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(8427);
let i = 0;

const AlphaMode =
{
   AUTO:   i ++, // Must be zero!
   OPAQUE: i ++,
   MASK:   i ++,
   BLEND:  i ++,
};

const __default__ = Object .assign (new Map (Object .entries (AlphaMode)), AlphaMode);
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .add ("AlphaMode", __default__));

/***/ },

/***/ 532
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(1743);
/* harmony import */ var _X3DChildNode_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(7745);
/* harmony import */ var _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(3411);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(8427);




let modificationCount = 0;

function X3DBindableNode (executionContext)
{
   _X3DChildNode_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .call (this, executionContext);

   this .addType (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .X3DBindableNode);

   this .modificationCount = 0;
}

Object .assign (Object .setPrototypeOf (X3DBindableNode .prototype, _X3DChildNode_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .prototype),
{
   initialize ()
   {
      _X3DChildNode_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .prototype .initialize .call (this);

      this ._set_bind .addInterest ("set_bind__", this);
   },
   isCameraObject ()
   {
      return true;
   },
   getModificationCount ()
   {
      return this .modificationCount;
   },
   transitionStart ()
   { },
   set_bind__ ()
   {
      if (modificationCount === Number .MAX_SAFE_INTEGER)
         modificationCount = 0;

      this .modificationCount = ++ modificationCount;
   },
});

Object .defineProperties (X3DBindableNode, _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .getStaticProperties ("X3DBindableNode", "Core", 1));

Object .defineProperties (X3DBindableNode,
{
   getModificationCount:
   {
      value ()
      {
         return modificationCount;
      },
      enumerable: false,
   },
});

const __default__ = X3DBindableNode;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .add ("X3DBindableNode", __default__));

/***/ },

/***/ 7745
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Fields_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(9818);
/* harmony import */ var _X3DNode_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(1743);
/* harmony import */ var _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(3411);
/* harmony import */ var _Rendering_TraverseType_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(3970);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(8427);





function X3DChildNode (executionContext)
{
   if (this .getExecutionContext ())
      return;

   _X3DNode_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .call (this, executionContext);

   this .addType (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .X3DChildNode);

   this .addChildObjects (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .outputOnly, "isBoundedObject",   new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFBool (),
                          _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .outputOnly, "isPointingObject",  new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFBool (),
                          _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .outputOnly, "isCameraObject",    new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFBool (),
                          _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .outputOnly, "isPickableObject",  new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFBool (),
                          _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .outputOnly, "isCollisionObject", new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFBool (),
                          _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .outputOnly, "isShadowObject",    new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFBool (),
                          _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .outputOnly, "isVisibleObject",   new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFBool ());
}

Object .assign (Object .setPrototypeOf (X3DChildNode .prototype, _X3DNode_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .prototype),
{
   setBoundedObject (value)
   {
      if (!!value !== this ._isBoundedObject .getValue ())
         this ._isBoundedObject = value;
   },
   isBoundedObject ()
   {
      return this ._isBoundedObject .getValue ();
   },
   setPointingObject (value)
   {
      if (!!value !== this ._isPointingObject .getValue ())
         this ._isPointingObject = value;
   },
   isPointingObject ()
   {
      return this ._isPointingObject .getValue ();
   },
   setCameraObject (value)
   {
      if (!!value !== this ._isCameraObject .getValue ())
         this ._isCameraObject = value;
   },
   isCameraObject ()
   {
      return this ._isCameraObject .getValue ();
   },
   setPickableObject (value)
   {
      if (!!value !== this ._isPickableObject .getValue ())
         this ._isPickableObject = value;
   },
   isPickableObject ()
   {
      return this ._isPickableObject .getValue ();
   },
   setShadowObject (value)
   {
      if (!!value !== this ._isShadowObject .getValue ())
         this ._isShadowObject = value;
   },
   isShadowObject ()
   {
      return this ._isShadowObject .getValue ();
   },
   setCollisionObject (value)
   {
      if (!!value !== this ._isCollisionObject .getValue ())
         this ._isCollisionObject = value;
   },
   isCollisionObject ()
   {
      return this ._isCollisionObject .getValue ();
   },
   setVisibleObject (value)
   {
      if (!!value !== this ._isVisibleObject .getValue ())
         this ._isVisibleObject = value;
   },
   isVisibleObject ()
   {
      return this ._isVisibleObject .getValue ();
   },
   isVisible ()
   {
      // This function will be overloaded by X3DBoundedObject.
      return true;
   },
   connectChildNode (childNode, excludes)
   {
      if (!excludes ?.includes (_Rendering_TraverseType_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .BBOX))
      {
         childNode ._isBoundedObject .addFieldInterest (this ._isBoundedObject);
         this .setBoundedObject (childNode .isBoundedObject ());
      }

      if (!excludes ?.includes (_Rendering_TraverseType_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .POINTER))
      {
         childNode ._isPointingObject .addFieldInterest (this ._isPointingObject);
         this .setPointingObject (childNode .isPointingObject ());
      }

      if (!excludes ?.includes (_Rendering_TraverseType_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .CAMERA))
      {
         childNode ._isCameraObject .addFieldInterest (this ._isCameraObject);
         this .setCameraObject (childNode .isCameraObject ());
      }

      if (!excludes ?.includes (_Rendering_TraverseType_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .PICKING))
      {
         childNode ._isPickableObject .addFieldInterest (this ._isPickableObject);
         this .setPickableObject (childNode .isPickableObject ());
      }

      if (!excludes ?.includes (_Rendering_TraverseType_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .COLLISION))
      {
         childNode ._isCollisionObject .addFieldInterest (this ._isCollisionObject);
         this .setCollisionObject (childNode .isCollisionObject ());
      }

      if (!excludes ?.includes (_Rendering_TraverseType_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .SHADOW))
      {
         childNode ._isShadowObject .addFieldInterest (this ._isShadowObject);
         this .setShadowObject (childNode .isShadowObject ());
      }

      if (!excludes ?.includes (_Rendering_TraverseType_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .DISPLAY))
      {
         childNode ._isVisibleObject .addFieldInterest (this ._isVisibleObject);
         this .setVisibleObject (childNode .isVisibleObject ());
      }
   },
   disconnectChildNode (childNode)
   {
      childNode ._isBoundedObject   .removeFieldInterest (this ._isBoundedObject);
      childNode ._isPointingObject  .removeFieldInterest (this ._isPointingObject);
      childNode ._isCameraObject    .removeFieldInterest (this ._isCameraObject);
      childNode ._isPickableObject  .removeFieldInterest (this ._isPickableObject);
      childNode ._isCollisionObject .removeFieldInterest (this ._isCollisionObject);
      childNode ._isShadowObject    .removeFieldInterest (this ._isShadowObject);
      childNode ._isVisibleObject   .removeFieldInterest (this ._isVisibleObject);
   },
   getShapes (shapes, modelMatrix)
   {
      return shapes;
   },
});

Object .defineProperties (X3DChildNode, _X3DNode_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .getStaticProperties ("X3DChildNode", "Core", 1));

const __default__ = X3DChildNode;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .add ("X3DChildNode", __default__));

/***/ },

/***/ 8155
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Base_X3DChildObject_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(8927);
/* harmony import */ var _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(3411);
/* harmony import */ var _X3DNode_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(1743);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(8427);
/* provided dependency */ var $ = __webpack_require__(8316)["default"];




const
   _importedName = Symbol (),
   _importedNode = Symbol (),
   _type         = Symbol ();

const handler =
{
   get (target, key)
   {
      if (key in target)
         return target [key];

      const
         node     = target .getSharedNode (),
         property = node ?.[key];

      if (typeof property === "function")
         return property .bind (node);

      return property;
   },
   set (target, key, value)
   {
      if (key in target)
      {
         target [key] = value;
      }
      else
      {
         const node = target .getSharedNode ();

         if (node)
            node [key] = value;
      }

      return true;
   },
   has (target, key)
   {
      return key in (target .getSharedNode () ?? { });
   },
   ownKeys (target)
   {
      return Object .keys (target .getSharedNode () ?? { });
   },
   getOwnPropertyDescriptor (target, key)
   {
      return Object .getOwnPropertyDescriptor (target .getSharedNode () ?? { }, key);
   },
}

function X3DImportedNodeProxy (executionContext, importedName, type)
{
   _X3DNode_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .call (this, executionContext);

   const proxy = new Proxy (this, handler);

   this [_importedName] = importedName;
   this [_type]         = type;

   this .setup ();

   return proxy;
}

Object .assign (Object .setPrototypeOf (X3DImportedNodeProxy .prototype, _X3DNode_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .prototype),
{
   initialize ()
   {
      _X3DNode_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .prototype .initialize .call (this);

      this .getExecutionContext () .importedNodes .addInterest ("update", this);

      this .update ();
   },
   getExtendedEventHandling ()
   {
      return false;
   },
   setTypeHint (value)
   {
      this [_type] ??= value;
   },
   getSharedNode ()
   {
      return $.try (() => this [_importedNode] .getSharedNode ()) ?? null;
   },
   getImportedNode ()
   {
      return this [_importedNode];
   },
   getInnerNode ()
   {
      return this [_importedNode] .getSharedNode () .getInnerNode ();
   },
   getName ()
   {
      return this [_importedName];
   },
   setName (value)
   {
      this [_importedName] = value;

      this ._name_changed = Date .now () / 1000;
   },
   ... Object .fromEntries ([
      ["getComponentInfo",      "componentInfo"],
      ["getContainerField",     "containerField"],
      ["getSpecificationRange", "specificationRange"],
      ["getTypeName",           "typeName"],
   ]
   .map (([fn, property]) => [fn, function ()
   {
      return this .getSharedNode () ?.[fn] () ?? this .constructor [property];
   }])),
   ... Object .fromEntries ([
      "getType",
      "getFieldDefinitions",
      "getPredefinedField",
      "getPredefinedFields",
      "getUserDefinedField",
      "getUserDefinedFields",
      "getField",
      "getFields",
      "getChangedFields",
      "isDefaultValue",
      "hasRoutes",
   ]
   .map (fn => [fn, function (... args)
   {
      return this .getSharedNode () ?.[fn] (... args) ?? _X3DNode_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .prototype [fn] .call (this, ... args);
   }])),
   update ()
   {
      const importedNode = this .getExecutionContext () .getImportedNodes () .get (this [_importedName])
         ?? null;

      this [_importedNode] ?.getInlineNode () ._loadState .removeInterest ("set_loadState__", this);

      this [_importedNode] = importedNode;

      this [_importedNode] ?.getInlineNode () ._loadState .addInterest ("set_loadState__", this);

      this .set_loadState__ ();
   },
   set_loadState__ ()
   {
      if (this [_importedNode] ?.getInlineNode () .checkLoadState () === _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .COMPLETE_STATE)
         this [_type] = this .getSharedNode () ?.constructor ?? this [_type];

      this ._typeName_changed = Date .now () / 1000;

      _Base_X3DChildObject_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .prototype .addEvent .call (this);
   },
   toVRMLStream (generator)
   {
      generator .CheckSpace ();
      generator .string += "USE";
      generator .Space ();
      generator .string += this [_importedName];
      generator .NeedsSpace ();
   },
   toXMLStream (generator)
   {
      generator .openTag (this .getTypeName ());

      if (generator .html && this .getTypeName () === "Script")
         generator .attribute ("type", "model/x3d+xml");

      generator .attribute ("USE", this [_importedName]);
      generator .containerField (this .getContainerField ());
      generator .closeTag (this .getTypeName ());
   },
   toJSONStream (generator)
   {
      generator .beginObject (this .getTypeName (), false, true);
      generator .stringProperty ("@USE", this [_importedName], false);
      generator .endObject ();
      generator .endObject ();
   },
});

Object .defineProperties (X3DImportedNodeProxy .prototype,
{
   constructor:
   {
      get ()
      {
         return this [_type] ?? _X3DNode_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A;
      },
   }
});

Object .defineProperties (X3DImportedNodeProxy, _X3DNode_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .getStaticProperties ("X3DImportedNodeProxy", "Core", 2, "children", "4.1"));

const __default__ = X3DImportedNodeProxy;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .add ("X3DImportedNodeProxy", __default__));

/***/ },

/***/ 1743
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Fields_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(9818);
/* harmony import */ var _Base_X3DBaseNode_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(2188);
/* harmony import */ var _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(3411);
/* harmony import */ var _Base_X3DField_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(9862);
/* harmony import */ var _Fields_SFNodeCache_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(658);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(8427);






const _metaDataCallbacks = Symbol ();

function X3DNode (executionContext)
{
   _Base_X3DBaseNode_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .call (this, executionContext);

   this .addType (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .X3DNode);
}

Object .assign (Object .setPrototypeOf (X3DNode .prototype, _Base_X3DBaseNode_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .prototype),
{
   getComponentInfo ()
   {
      return this .constructor .componentInfo;
   },
   getContainerField ()
   {
      return this .constructor .containerField;
   },
   getSpecificationRange ()
   {
      return this .constructor .specificationRange;
   },
   create (executionContext = this .getExecutionContext ())
   {
      return new (this .constructor) (executionContext);
   },
   copy (instance)
   {
      if (instance ?.getType () .includes (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .X3DExecutionContext) ?? true)
      {
         const copy = this .create (instance);

         for (const field of this .getPredefinedFields ())
            copy .getPredefinedFields () .get (field .getName ()) .assign (field);

         if (this .canUserDefinedFields ())
         {
            for (const field of this .getUserDefinedFields ())
               copy .addUserDefinedField (field .getAccessType (), field .getName (), field .copy ());
         }

         return copy;
      }
      else
      {
         const executionContext = instance .getBody ();

         // First try to get a named node with the node's name.

         if (this .getName () .length)
         {
            const namedNode = executionContext .getNamedNodes () .get (this .getName ());

            if (namedNode)
               return namedNode .getValue ();
         }

         // Create copy.

         const copy = this .create (executionContext);

         // Support editing of protos.
         if (this .getNeedsName ())
            this .getExecutionContext () .updateNamedNode (this .getExecutionContext () .getUniqueName (), this);

         if (this .getName () .length)
            executionContext .updateNamedNode (this .getName (), copy);

         // Default fields

         for (const sourceField of this .getPredefinedFields ())
         {
            try
            {
               const destinationField = copy .getPredefinedField (sourceField .getName ());

               let initializableReferences = false;

               for (const originalReference of sourceField .getReferences ())
                  initializableReferences ||= originalReference .isInitializable ();

               if (sourceField .isInitializable () && !initializableReferences)
               {
                  switch (sourceField .getType ())
                  {
                     case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .SFNode:
                     case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .MFNode:
                        destinationField .assign (sourceField .copy (instance));
                        break;
                     default:
                        destinationField .assign (sourceField);
                        break;
                  }
               }

               if (sourceField .getReferences () .size)
               {
                  // IS relationship

                  for (const originalReference of sourceField .getReferences ())
                  {
                     try
                     {
                        destinationField .addReference (instance .getField (originalReference .getName ()));
                     }
                     catch (error)
                     {
                        console .error (error);
                     }
                  }
               }

               destinationField .setModificationTime (sourceField .getModificationTime ());
            }
            catch (error)
            {
               console .error (error);
            }
         }

         // User-defined fields

         for (const sourceField of this .getUserDefinedFields ())
         {
            let initializableReferences = false;

            for (const originalReference of sourceField .getReferences ())
               initializableReferences ||= originalReference .isInitializable ();

            const destinationField = initializableReferences
               ? sourceField .create ()
               : sourceField .copy (instance);

            copy .addUserDefinedField (sourceField .getAccessType (),
                                       sourceField .getName (),
                                       destinationField);

            if (sourceField .getReferences () .size)
            {
               // IS relationship

               for (const originalReference of sourceField .getReferences ())
               {
                  try
                  {
                     destinationField .addReference (instance .getField (originalReference .getName ()));
                  }
                  catch (error)
                  {
                     console .error (`No reference '${originalReference .getName ()}' inside execution context ${instance .getTypeName ()} '${instance .getName ()}'.`);
                  }
               }
            }

            destinationField .setModificationTime (sourceField .getModificationTime ());
         }

         return copy;
      }
   },
   getDisplayName ()
   {
      return this .getName () .replace (/_\d+$/, "");
   },
   getNeedsName ()
   {
      if (this .getName () .length)
         return false;

      if (this .getCloneCount () > 1)
         return true;

      if (this .hasRoutes ())
         return true;

      const executionContext = this .getExecutionContext ()

      for (const importedNode of executionContext .getImportedNodes ())
      {
         if (importedNode .getInlineNode () === this)
            return true;
      }

      if (executionContext .isScene)
      {
         for (const exportedNode of executionContext .getExportedNodes ())
         {
            if (exportedNode .getLocalNode () === this)
               return true;
         }
      }

      return false;
   },
   hasRoutes ()
   {
      ///  Returns true if there are any routes from or to fields of this node, otherwise false.

      for (const field of this .getPredefinedFields ())
      {
         if (field .getInputRoutes () .size || field .getOutputRoutes () .size)
            return true;
      }

      for (const field of this .getUserDefinedFields ())
      {
         if (field .getInputRoutes () .size || field .getOutputRoutes () .size)
            return true;
      }

      for (const route of this .getExecutionContext () .getRoutes ())
      {
         if (route .getSourceNode () === this || route .getDestinationNode () === this)
            return true;
      }

      return false;
   },
   getCloneCount ()
   {
      return _Base_X3DBaseNode_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .prototype .collectCloneCount .call (this);
   },
   collectCloneCount ()
   {
      return 1;
   },
   getSourceText ()
   {
      return null;
   },
   traverse ()
   { },
   hasMetaData (path)
   {
      const names = path .split ("/");

      if (names .length < 2)
         return false;

      const
         last           = names .pop (),
         metadataSet    = this .getMetadataSet (names),
         metadataObject = metadataSet ?.getValue () .getMetaValue (last);

      return !!metadataObject;
   },
   getMetaData (path, field)
   {
      const names = path .split ("/");

      if (names .length < 2)
         return;

      const
         last           = names .pop (),
         metadataSet    = this .getMetadataSet (names),
         metadataObject = metadataSet ?.getValue () .getMetaValue (last);

      if (field instanceof _Base_X3DField_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A)
      {
         if (!metadataObject)
            return field;

         switch (field .getType ())
         {
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .SFBool:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .SFDouble:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .SFFloat:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .SFInt32:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .SFString:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .SFTime:
            {
               field .setValue (metadataObject .value [0]);
               break;
            }
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .SFColor:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .SFColorRGBA:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .SFMatrix3d:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .SFMatrix3f:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .SFMatrix4d:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .SFMatrix4f:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .SFRotation:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .SFVec2d:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .SFVec2f:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .SFVec3d:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .SFVec3f:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .SFVec4d:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .SFVec4f:
            {
               const value = metadataObject .value;

               let i = 0;

               for (const key in field)
                  field [key] = value [i ++];

               break;
            }
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .SFImage:
            {
               const
                  value = metadataObject .value,
                  array = field .array;

               field .width  = value [0];
               field .height = value [1];
               field .comp   = value [2];

               const l = array .length;

               for (let i = 0; i < l; ++ i)
                  array [i] = value [3 + i];

               break;
            }
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .SFNode:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .MFNode:
            {
               throw new Error ("SFNode and MFNode are not supported as metadata value.");
            }
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .MFBool:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .MFDouble:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .MFFloat:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .MFInt32:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .MFString:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .MFTime:
            {
               field .length = 0;

               for (const v of metadataObject .value)
                  field .push (v);

               break;
            }
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .MFColor:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .MFColorRGBA:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .MFMatrix3d:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .MFMatrix3f:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .MFMatrix4d:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .MFMatrix4f:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .MFRotation:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .MFVec2d:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .MFVec2f:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .MFVec3d:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .MFVec3f:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .MFVec4d:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .MFVec4f:
            {
               const
                  value  = metadataObject .value,
                  length = value .length;

               field .length = 0;

               for (let i = 0; i < length;)
               {
                  const
                     l = field .length ++,
                     f = field [l];

                  for (const key in f)
                     f [key] = value [i ++];
               }

               break;
            }
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .MFImage:
            {
               const
                  value  = metadataObject .value,
                  length = value .length;

               field .length = 0;

               for (let i = 0; i < length;)
               {
                  const
                     l = field .length ++,
                     f = field [l],
                     a = f .array;

                  f .width  = value [i ++];
                  f .height = value [i ++];
                  f .comp   = value [i ++];

                  const p = a .length;

                  for (let k = 0; k < p; ++ k)
                     a [k] = value [i ++];
               }

               break;
            }
         }

         return field;
      }
      else if (field)
      {
         // Support for Numbers (Vector234, Color34, ...).

         if (!metadataObject)
            return field;

         const value = metadataObject .value;

         let i = 0;

         for (const key in field)
            field [key] = value [i ++];

         return field;
      }

      return metadataObject ? Array .from (metadataObject .value) : [ ];
   },
   setMetaData (path, value)
   {
      const names = path .split ("/");

      if (names .length < 2)
         return;

      const
         last        = names .pop (),
         metadataSet = this .getMetadataSet (names, true);

      if (value instanceof _Base_X3DField_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A)
      {
         const field = value;

         switch (value .getType ())
         {
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .SFBool:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .SFDouble:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .SFFloat:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .SFInt32:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .SFString:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .SFTime:
            {
               value = [field .valueOf ()];
               break;
            }
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .SFNode:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .MFNode:
               throw new Error ("SFNode and MFNode are not supported as metadata value.");
            default:
            {
               value = Array .from (field, f => f instanceof _Base_X3DField_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A ? Array .from (f) : f) .flat ();
               break;
            }
         }

         switch (field .getType ())
         {
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .SFBool:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .MFBool:
               value .type = "boolean";
               break;
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .SFDouble:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .SFMatrix3d:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .SFMatrix4d:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .SFRotation:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .SFTime:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .SFVec2d:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .SFVec3d:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .SFVec4d:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .MFDouble:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .MFMatrix3d:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .MFMatrix4d:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .MFRotation:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .MFTime:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .MFVec2d:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .MFVec3d:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .MFVec4d:
               value .type = "double";
               break;
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .SFColor:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .SFColorRGBA:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .SFFloat:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .SFMatrix3f:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .SFMatrix4f:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .SFVec2f:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .SFVec3f:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .SFVec4f:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .MFColor:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .MFColorRGBA:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .MFFloat:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .MFMatrix3f:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .MFMatrix4f:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .MFVec2f:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .MFVec3f:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .MFVec4f:
               value .type = "float";
               break;
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .SFInt32:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .SFImage:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .MFInt32:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .MFImage:
               value .type = "integer";
               break;
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .SFString:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .MFString:
               value .type = "string";
               break;
         }
      }
      else if (!Array .isArray (value) && value .valueOf () instanceof Object)
      {
         // Support for Numbers (Vector234, Color34, ...).

         value = Array .from (value);
         value .type = "double";
      }

      metadataSet .getValue () .setMetaValue (last, value);

      this .processMetaDataCallback (path);
   },
   removeMetaData (path)
   {
      const names = path .split ("/");

      if (names .length < 2)
         return;

      function removeMetaData (metadataSet, names)
      {
         if (!metadataSet)
            return false;

         const name = names .shift ();

         if (!names .length || removeMetaData (metadataSet .getValue () .getMetadataObject ("MetadataSet", name), names))
         {
            metadataSet .getValue () .removeMetaValue (name);
         }

         return !metadataSet .value .length;
      }

      if (removeMetaData (this .getMetadataSet ([names .shift ()]), names))
         this ._metadata = null;
   },
   getMetadataSet (names, create = false)
   {
      const name = names .shift ();

      let metadataSet = this ._metadata .valueOf ();

      if (metadataSet ?.getNodeTypeName () !== "MetadataSet" || metadataSet ?.name !== name)
      {
         if (!create)
            return null;

         this ._metadata = this .getExecutionContext () .createNode ("MetadataSet");
         metadataSet     = this ._metadata .valueOf ();

         this .getExecutionContext () .addNamedNode (this .getExecutionContext () .getUniqueName (name), metadataSet);

         metadataSet .reference = this .getBrowser () .getBrowserOption ("MetadataReference");
         metadataSet .name      = name;
      }

      for (const name of names)
         metadataSet = metadataSet .getValue () .getMetadataObject ("MetadataSet", name, create);

      return metadataSet;
   },
   [_metaDataCallbacks]: new Map (),
   addMetaDataCallback (key, path, callback)
   {
      if (!this .hasOwnProperty (_metaDataCallbacks))
         this [_metaDataCallbacks] = new Map ();

      let map = this [_metaDataCallbacks] .get (path);

      if (!map)
         this [_metaDataCallbacks] .set (path, map = new Map ());

      map .set (key, callback);
   },
   removeMetaDataCallback (key, path)
   {
      const map = this [_metaDataCallbacks] .get (path);

      if (!map)
         return;

      map .delete (key);

      if (map .size === 0)
         this [_metaDataCallbacks] .delete (path);
   },
   processMetaDataCallback (path)
   {
      const map = this [_metaDataCallbacks] .get (path);

      if (!map)
         return;

      for (const callback of map .values ())
         callback ();
   },
   toStream (generator)
   {
      generator .string += this .getTypeName ();
      generator .TidySpace ();
      generator .string += "{";
      generator .TidySpace ();
      generator .string += "}";
   },
   toVRMLStream (generator)
   {
      generator .CheckSpace ();

      if (generator .outputNames)
      {
         const name = generator .Name (this);

         if (name .length)
         {
            if (generator .ExistsNode (this))
            {
               generator .string += "USE";
               generator .Space ();
               generator .string += name;
               generator .NeedsSpace ();
               return;
            }
         }

         if (name .length)
         {
            generator .AddNode (this);

            generator .string += "DEF";
            generator .Space ();
            generator .string += name;
            generator .Space ();
         }
      }

      generator .string += this .getTypeName ();
      generator .TidySpace ();
      generator .string += "{";

      const
         fields            = this .getConvertedFields (this .getChangedFields ()),
         userDefinedFields = this .getUserDefinedFields ();

      if (this .canUserDefinedFields ())
      {
         if (userDefinedFields .length)
         {
            let
               fieldTypeLength  = 0,
               accessTypeLength = 0;

            for (const field of userDefinedFields)
            {
               fieldTypeLength  = Math .max (fieldTypeLength, field .getTypeName () .length);
               accessTypeLength = Math .max (accessTypeLength, generator .AccessType (field .getAccessType ()) .length);
            }

            generator .TidyBreak ();
            generator .IncIndent ();

            const last = userDefinedFields .at (-1);

            for (const field of userDefinedFields)
            {
               this .toVRMLStreamUserDefinedField (generator, field, fieldTypeLength, accessTypeLength);

               if (field === last)
                  generator .TidyBreak ();
               else
                  generator .Break ();
            }

            generator .DecIndent ();

            if (fields .length !== 0)
               generator .TidyBreak ();
         }
      }

      if (fields .length === 0)
      {
         if (userDefinedFields .length)
            generator .Indent ();
         else
            generator .TidySpace ();
      }
      else
      {
         const last = fields .at (-1);

         if (userDefinedFields .length === 0)
            generator .TidyBreak ();

         generator .IncIndent ();

         for (const field of fields)
         {
            this .toVRMLStreamField (generator, field);

            if (field === last)
               generator .TidyBreak ();
            else
               generator .Break ();
         }

         generator .DecIndent ();
         generator .Indent ();
      }

      generator .string += "}";
   },
   toVRMLStreamUserDefinedField (generator, field, fieldTypeLength, accessTypeLength)
   {
      const sharedNode = generator .IsSharedNode (this);

      if (field .getReferences () .size === 0 || !generator .ExecutionContext () || sharedNode)
      {
         generator .Indent ();
         generator .string += generator .AccessType (field .getAccessType ()) .padEnd (accessTypeLength, generator .TidySpace ());
         generator .Space ();
         generator .string += field .getTypeName () .padEnd (fieldTypeLength, generator .TidySpace ());
         generator .Space ();
         generator .string += field .getName ();

         if (field .isInitializable ())
         {
            generator .Space ();

            field .toVRMLStream (generator);
         }
      }
      else
      {
         let
            index                  = 0,
            initializableReferences = false;

         for (const reference of field .getReferences ())
         {
            initializableReferences ||= reference .isInitializable ();

            // Output user defined reference field

            generator .Indent ();
            generator .string += generator .AccessType (field .getAccessType ()) .padEnd (accessTypeLength, generator .TidySpace ());
            generator .Space ();
            generator .string += field .getTypeName () .padEnd (fieldTypeLength, generator .TidySpace ());
            generator .Space ();
            generator .string += field .getName ();
            generator .Space ();
            generator .string += "IS";
            generator .Space ();
            generator .string += reference .getName ();

            ++ index;

            if (index !== field .getReferences () .size)
               generator .Break ();
         }

         if (field .getAccessType () === _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .inputOutput && !initializableReferences && !field .isDefaultValue ())
         {
            generator .Break ();
            generator .Indent ();
            generator .string += generator .AccessType (field .getAccessType ()) .padEnd (accessTypeLength, generator .TidySpace ());
            generator .Space ();
            generator .string += field .getTypeName () .padEnd (fieldTypeLength, generator .TidySpace ());
            generator .Space ();
            generator .string += field .getName ();

            if (field .isInitializable ())
            {
               generator .Space ();

               field .toVRMLStream (generator);
            }
         }
      }
   },
   toVRMLStreamField (generator, field)
   {
      const sharedNode = generator .IsSharedNode (this);

      if (field .getReferences () .size === 0 || !generator .ExecutionContext () || sharedNode)
      {
         if (field .isInitializable ())
         {
            generator .Indent ();
            generator .string += field .getName ();
            generator .Space ();

            field .toVRMLStream (generator);
         }
      }
      else
      {
         let
            index                  = 0,
            initializableReferences = false;

         for (const reference of field .getReferences ())
         {
            initializableReferences ||= reference .isInitializable ();

            // Output build in reference field

            generator .Indent ();
            generator .string += field .getName ();
            generator .Space ();
            generator .string += "IS";
            generator .Space ();
            generator .string += reference .getName ();

            ++ index;

            if (index !== field .getReferences () .size)
               generator .Break ();
         }

         if (field .getAccessType () === _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .inputOutput && !initializableReferences && !this .isDefaultValue (field))
         {
            // Output build in field

            generator .Break ();
            generator .Indent ();
            generator .string += field .getName ();
            generator .Space ();

            field .toVRMLStream (generator);
         }
      }
   },
   toXMLStream (generator)
   {
      const
         sharedNode = generator .IsSharedNode (this),
         name       = generator .Name (this);

      if (name .length)
      {
         if (generator .ExistsNode (this))
         {
            generator .openTag (this .getTypeName ());

            if (generator .html && this .getTypeName () === "Script")
               generator .attribute ("type", "model/x3d+xml");

            generator .attribute ("USE", name);
            generator .containerField (this .getContainerField ());
            generator .closeTag (this .getTypeName ());
            return;
         }
      }

      generator .openTag (this .getTypeName ());

      if (generator .html && this .getTypeName () === "Script")
         generator .attribute ("type", "model/x3d+xml");

      if (name .length)
      {
         generator .AddNode (this);
         generator .attribute ("DEF", name);
      }

      generator .containerField (this .getContainerField ());

      const
         fields            = this .getConvertedFields (this .getChangedFields ()),
         userDefinedFields = this .getUserDefinedFields ();

      const
         references = [ ],
         childNodes = [ ];

      let cdata = this .getSourceText ();

      if (cdata ?.length === 0 || (generator .html && this .getTypeName () !== "Script"))
         cdata = null;

      if (!cdata ?.some (string => string .match (/^\s*(?:data|ecmascript|javascript|vrmlscript)\:/s)))
         cdata = null;

      generator .IncIndent ();
      generator .IncIndent ();

      for (const field of fields)
      {
         // If the field is a inputOutput and we have as reference only inputOnly or outputOnly we must output the value
         // for this field.

         let mustOutputValue = false;

         if (generator .ExecutionContext ())
         {
            if (field .getAccessType () === _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .inputOutput && field .getReferences () .size !== 0)
            {
               if (!Array .from (field .getReferences ()) .some (reference => reference .isInitializable ()))
                  mustOutputValue = !this .isDefaultValue (field);
            }
         }

         // If we have no execution context we are not in a proto and must not generate IS references the same is true
         // if the node is a shared node as the node does not belong to the execution context.

         if (field .getReferences () .size === 0 || !generator .ExecutionContext () || sharedNode || mustOutputValue)
         {
            if (mustOutputValue)
               references .push (field);

            if (field .isInitializable ())
            {
               switch (field .getType ())
               {
                  case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .SFNode:
                  case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .MFNode:
                  {
                     childNodes .push (field);
                     break;
                  }
                  default:
                  {
                     if (field === cdata)
                        break;

                     generator .AttribBreak ();
                     generator .ListIndent ();
                     generator .string += field .getName ();
                     generator .string += "='";

                     field .toXMLStream (generator, field === this .getSourceText ());

                     generator .string += "'";
                     break;
                  }
               }
            }
         }
         else
         {
            references .push (field);
         }
      }

      generator .DecIndent ();
      generator .DecIndent ();

      if ((!this .canUserDefinedFields () || !userDefinedFields .length) && (!references .length || sharedNode) && !childNodes .length && !cdata)
      {
         generator .closeTag (this .getTypeName ());
      }
      else
      {
         generator .endTag ();
         generator .IncIndent ();

         if (this .canUserDefinedFields ())
         {
            for (const field of userDefinedFields)
            {
               generator .openTag ("field");
               generator .attribute ("accessType", generator .AccessType (field .getAccessType ()));
               generator .attribute ("type",       field .getTypeName ());
               generator .attribute ("name",       field .getName ());

               // If the field is a inputOutput and we have as reference only inputOnly or outputOnly we must output the value
               // for this field.

               let mustOutputValue = false;

               if (generator .ExecutionContext ())
               {
                  if (field .getAccessType () === _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .inputOutput && field .getReferences () .size !== 0)
                  {
                     if (!Array .from (field .getReferences ()) .some (reference => reference .isInitializable ()))
                        mustOutputValue = true;
                  }
               }

               if ((field .getReferences () .size === 0 || !generator .ExecutionContext ()) || sharedNode || mustOutputValue)
               {
                  if (mustOutputValue && generator .ExecutionContext ())
                     references .push (field);

                  if (!field .isInitializable () || field .isDefaultValue ())
                  {
                     if (field .getAppInfo ())
                        generator .attribute ("appinfo", field .getAppInfo ());

                     if (field .getDocumentation ())
                        generator .attribute ("documentation", field .getDocumentation ());

                     generator .closeTag ("field");
                     generator .TidyBreak ();
                  }
                  else
                  {
                     // Output value

                     switch (field .getType ())
                     {
                        case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .SFNode:
                        case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .MFNode:
                        {
                           if (field .getAppInfo ())
                              generator .attribute ("appinfo", field .getAppInfo ());

                           if (field .getDocumentation ())
                              generator .attribute ("documentation", field .getDocumentation ());

                           generator .endTag ();
                           generator .IncIndent ();
                           generator .PushContainerField (null);

                           field .toXMLStream (generator);

                           generator .TidyBreak ();
                           generator .DecIndent ();
                           generator .closingTag ("field");
                           generator .TidyBreak ();
                           generator .PopContainerField ();
                           break;
                        }
                        default:
                        {
                           generator .Space ();
                           generator .string += "value='";

                           field .toXMLStream (generator);

                           generator .string += "'";

                           if (field .getAppInfo ())
                              generator .attribute ("appinfo", field .getAppInfo ());

                           if (field .getDocumentation ())
                              generator .attribute ("documentation", field .getDocumentation ());

                           generator .closeTag ("field");
                           generator .TidyBreak ();
                           break;
                        }
                     }
                  }
               }
               else
               {
                  if (generator .ExecutionContext ())
                     references .push (field);

                  if (field .getAppInfo ())
                     generator .attribute ("appinfo", field .getAppInfo ());

                  if (field .getDocumentation ())
                     generator .attribute ("documentation", field .getDocumentation ());

                  generator .closeTag ("field");
                  generator .TidyBreak ();
               }
            }
         }

         if (references .length && !sharedNode)
         {
            generator .openingTag ("IS");
            generator .TidyBreak ();
            generator .IncIndent ();

            for (const field of references)
            {
               const protoFields = field .getReferences ();

               for (const protoField of protoFields)
               {
                  generator .openTag ("connect");
                  generator .attribute ("nodeField",  field .getName ());
                  generator .attribute ("protoField", protoField .getName ());
                  generator .closeTag ("connect");
                  generator .TidyBreak ();
               }
            }

            generator .DecIndent ();
            generator .closingTag ("IS");
            generator .TidyBreak ();
         }

         for (const field of childNodes)
         {
            generator .PushContainerField (field);

            field .toXMLStream (generator);

            generator .TidyBreak ();
            generator .PopContainerField ();
         }

         for (const value of cdata ?? [ ])
         {
            generator .string += "<![CDATA[";
            generator .string += value;
            generator .string += "]]>";
            generator .Break ();
         }

         generator .DecIndent ();
         generator .closingTag (this .getTypeName ());
      }
   },
   toJSONStream (generator)
   {
      const
         sharedNode = generator .IsSharedNode (this),
         name       = generator .Name (this);

      // Type name

      generator .beginObject (this .getTypeName (), false, true);

      // USE name

      if (name .length)
      {
         if (generator .ExistsNode (this))
         {
            generator .stringProperty ("@USE", name, false);
            generator .endObject ();
            generator .endObject ();
            return;
         }
      }

      let comma = false;

      // DEF name

      if (name .length)
      {
         generator .AddNode (this);
         generator .stringProperty ("@DEF", name, false);

         comma = true;
      }

      // Fields

      const
         fields            = this .getConvertedFields (this .getChangedFields ()),
         userDefinedFields = this .getUserDefinedFields ();

      const references = [ ];

      let sourceText = this .getSourceText ();

      // Source text

      if (sourceText ?.length !== 1)
         sourceText = null;

      if (!sourceText ?.some (string => string .match (/^\s*(?:data|ecmascript|javascript|vrmlscript)\:/s)))
         sourceText = null;

      // Predefined fields

      if (fields .length)
      {
         const outputFields = [ ];

         for (const field of fields)
         {
            // If the field is a inputOutput and we have as reference only inputOnly or outputOnly we must output the value
            // for this field.

            let mustOutputValue = false;

            if (generator .ExecutionContext ())
            {
               if (field .getAccessType () === _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .inputOutput && field .getReferences () .size !== 0)
               {
                  if (!Array .from (field .getReferences ()) .some (reference => reference .isInitializable ()))
                     mustOutputValue = !this .isDefaultValue (field);
               }
            }

            // If we have no execution context we are not in a proto and must not generate IS references the same is true
            // if the node is a shared node as the node does not belong to the execution context.

            if (field .getReferences () .size === 0 || !generator .ExecutionContext () || sharedNode || mustOutputValue)
            {
               if (mustOutputValue)
                  references .push (field);

               if (field !== sourceText && field .isInitializable ())
                  outputFields .push (field);
            }
            else
            {
               references .push (field);
            }
         }

         for (const field of outputFields)
         {
            switch (field .getType ())
            {
               case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .SFNode:
               case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .MFNode:
               {
                  generator .beginValue (`-${field .getName ()}`, comma || field !== outputFields [0]);

                  field .toJSONStream (generator);
                  break;
               }
               default:
               {
                  generator .beginValue (`@${field .getName ()}`, comma || field !== outputFields [0]);

                  field .toJSONStream (generator);
                  break;
               }
            }
         }

         comma ||= !! outputFields .length;
      }

      // User defined fields

      if (this .canUserDefinedFields () && userDefinedFields .length)
      {
         generator .beginArray ("field", comma);

         for (const field of userDefinedFields)
         {
            generator .beginObject ("", field !== userDefinedFields [0]);
            generator .stringProperty ("@accessType", generator .AccessType (field .getAccessType ()), false);
            generator .stringProperty ("@type",       field .getTypeName ());
            generator .stringProperty ("@name",       field .getName ());

            // If the field is a inputOutput and we have as reference only inputOnly or outputOnly we must output the value
            // for this field.

            let mustOutputValue = false;

            if (generator .ExecutionContext ())
            {
               if (field .getAccessType () === _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .inputOutput && field .getReferences () .size !== 0)
               {
                  if (!Array .from (field .getReferences ()) .some (reference => reference .isInitializable ()))
                     mustOutputValue = true;
               }
            }

            if ((field .getReferences () .size === 0 || !generator .ExecutionContext ()) || sharedNode || mustOutputValue)
            {
               if (mustOutputValue && generator .ExecutionContext ())
                  references .push (field);

               if (field .isInitializable () && !field .isDefaultValue ())
               {
                  // Output value

                  switch (field .getType ())
                  {
                     case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .SFNode:
                     {
                        generator .beginArray ("-children");

                        generator .TidyBreak ();
                        generator .Indent ();

                        field .toJSONStream (generator);

                        generator .endArray ();
                        break;
                     }
                     case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .MFNode:
                     {
                        generator .beginValue ("-children");

                        field .toJSONStream (generator);
                        break;
                     }
                     default:
                     {
                        generator .beginValue ("@value");

                        field .toJSONStream (generator);
                        break;
                     }
                  }
               }
            }
            else
            {
               if (generator .ExecutionContext ())
                  references .push (field);
            }

            if (field .getAppInfo ())
               generator .stringProperty ("@appinfo", field .getAppInfo ());

            if (field .getDocumentation ())
               generator .stringProperty ("@documentation", field .getDocumentation ());

            generator .endObject ();
         }

         generator .endArray ();

         comma = true;
      }

      // Source text

      if (sourceText)
      {
         generator .beginArray ("#sourceCode", comma);

         const lines = sourceText [0] .split ("\n");

         for (const [i, line] of lines .entries ())
         {
            if (i !== 0)
               generator .string += ',';

            generator .TidyBreak ();
            generator .ListIndent ();
            generator .string += '"';
            generator .string += generator .EncodeString (line);
            generator .string += '"';
         }

         generator .endArray ();

         comma = true;
      }

      // IS references

      if (references .length && !sharedNode)
      {
         generator .beginObject ("IS", comma);
         generator .beginArray ("connect", false);

         for (const field of references)
         {
            const protoFields = Array .from (field .getReferences ());

            for (const protoField of protoFields)
            {
               generator .beginObject ("", field !== references [0] || protoField !== protoFields [0]);
               generator .stringProperty ("@nodeField",  field .getName (), false);
               generator .stringProperty ("@protoField", protoField .getName ());
               generator .endObject ();
            }
         }

         generator .endArray ();
         generator .endObject ();
      }

      // End

      generator .endObject ();
      generator .endObject ();
   },
   dispose ()
   {
      const executionContext = this .getExecutionContext ();

      // Remove named node if any.

      if (this .getName ())
         executionContext .removeNamedNode (this .getName ())

      if (executionContext .isScene)
      {
         // Remove exported node if any.

         for (const exportedNode of Array .from (executionContext .getExportedNodes ()))
         {
            if (exportedNode .getLocalNode () === this)
               executionContext .removeExportedNode (exportedNode .getExportedName ());
         }

         // Remove imported node if any.

         const parentContext = executionContext .getExecutionContext ();

         if (parentContext)
         {
            for (const importedNode of parentContext .getImportedNodes ())
               importedNode .getExportedNode () .update ();
         }
      }

      // Remove node from entire scene graph.

      for (const firstParent of Array .from (this .getParents ()))
      {
         if (!(firstParent instanceof _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFNode))
            continue;

         for (const secondParent of Array .from (firstParent .getParents ()))
         {
            if (!(secondParent instanceof _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFNode))
               continue;

            secondParent .setValue (Array .from (secondParent) .filter (node => node ?.getValue () !== this))
         }
      }

      for (const firstParent of Array .from (this .getParents ()))
      {
         if (!(firstParent instanceof _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFNode))
            continue;

         firstParent .setValue (null);
      }

      _Fields_SFNodeCache_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .delete (this);

      // Call super.dispose, where fields get disposed.

      _Base_X3DBaseNode_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .prototype .dispose .call (this);
   },
});

for (const key of Object .keys (X3DNode .prototype))
   Object .defineProperty (X3DNode .prototype, key, { enumerable: false });

Object .defineProperties (X3DNode,
{
   getStaticProperties:
   {
      value (typeName, componentName, componentLevel, containerField, fromVersion, toVersion = "Infinity")
      {
         return {
            typeName:
            {
               value: typeName,
               enumerable: true,
            },
            componentInfo:
            {
               value: Object .freeze ({ name: componentName, level: componentLevel }),
               enumerable: true,
            },
            ... containerField ?
            {
               containerField:
               {
                  value: containerField,
                  enumerable: true,
               },
            } : { },
            ... fromVersion && toVersion ?
            {
               specificationRange:
               {
                  value: Object .freeze ({ from: fromVersion, to: toVersion }),
                  enumerable: true,
               },
            } : { },
         };
      },
   },
})

Object .defineProperties (X3DNode, X3DNode .getStaticProperties ("X3DNode", "Core", 1));

const __default__ = X3DNode;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .add ("X3DNode", __default__));

/***/ },

/***/ 3222
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Base_X3DChildObject_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(8927);
/* harmony import */ var _X3DNode_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(1743);
/* harmony import */ var _Execution_X3DExecutionContext_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(6982);
/* harmony import */ var _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(3411);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(8427);





const
   _fieldDefinitions = Symbol .for ("X_ITE.X3DBaseNode.fieldDefinitions"),
   _protoNode        = Symbol (),
   _protoFields      = Symbol (),
   _body             = Symbol ();

function X3DPrototypeInstance (executionContext, protoNode)
{
   this [_protoNode]        = protoNode;
   this [_fieldDefinitions] = protoNode .getFieldDefinitions ();
   this [_body]             = null;

   _X3DNode_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .call (this, executionContext);

   this .addType (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .X3DPrototypeInstance);

   this .setProtoNode (protoNode, true);
}

Object .assign (Object .setPrototypeOf (X3DPrototypeInstance .prototype, _X3DNode_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .prototype),
{
   create (executionContext)
   {
      return new X3DPrototypeInstance (executionContext, this [_protoNode]);
   },
   getTypeName ()
   {
      return this [_protoNode] .getName ();
   },
   getAppInfo ()
   {
      return this [_protoNode] .getAppInfo ();
   },
   getDocumentation ()
   {
      return this [_protoNode] .getDocumentation ();
   },
   initialize ()
   {
      _X3DNode_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .prototype .initialize .call (this);

      this .realize ();
   },
   realize ()
   {
      const
         protoNode = this [_protoNode],
         proto     = protoNode .getProtoDeclaration ();

      if (protoNode .isExternProto && protoNode .checkLoadState () !== _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .COMPLETE_STATE)
         return;

      // Create execution context.

      this [_body] = new _Execution_X3DExecutionContext_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A (proto .getExecutionContext (), this);

      // Copy proto.

      this .importExternProtos  (proto .getBody () .externprotos);
      this .importProtos        (proto .getBody () .protos);
      this .copyRootNodes       (proto .getBody () .rootNodes);
      this .importImportedNodes (proto .getBody () .importedNodes);
      this .copyRoutes          (proto .getBody () .routes);

      this [_body] .setup ();

      _Base_X3DChildObject_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .prototype .addEvent .call (this);
   },
   construct ()
   {
      const
         protoNode = this [_protoNode],
         proto     = protoNode .getProtoDeclaration ();

      // Dispose body and assign field definitions.

      this [_body] ?.dispose ();

      // If there is a proto, the externproto is completely loaded.

      if (protoNode .isExternProto)
      {
         if (protoNode .checkLoadState () !== _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .COMPLETE_STATE)
         {
            this [_body] = null;

            if (this .isInitialized ())
               _Base_X3DChildObject_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .prototype .addEvent .call (this);

            protoNode ._updateInstances .addInterest ("construct", this);
            protoNode .requestImmediateLoad () .catch (Function .prototype);

            return;
         }

         for (const protoField of proto .getUserDefinedFields ())
         {
            try
            {
               const field = this .getField (protoField .getName ());

               // Continue if different.
               if (field .getAccessType () !== protoField .getAccessType ())
                  continue;

               // Continue if different.
               if (field .getType () !== protoField .getType ())
                  continue;

               // Continue if field is eventIn or eventOut.
               if (!field .isInitializable ())
                  continue;

               // Is set during parse, or already changed by an route event.
               if (field .getModificationTime () >= 0)
                  continue;

               // Has IS references.
               if (field .getReferences () .size)
                  continue;

               // Default value of protoField is different from field.
               if (field .equals (protoField))
                  continue;

               // Update default value of field.
               field .assign (protoField);
            }
            catch
            {
               // Definition exists in proto but does not exist in extern proto.
               this .addPredefinedField (proto .getFieldDefinitions () .get (protoField .getName ()));
            }
         }
      }

      if (this .isInitialized ())
         this .realize ();

      protoNode ._updateInstances .removeInterest ("construct", this);
      protoNode ._updateInstances .addInterest ("update", this);
   },
   update ()
   {
      // Remove old fields.

      const
         oldProtoFields = this [_protoFields],
         oldFields      = Array .from (this .getPredefinedFields ());

      for (const field of oldFields)
         this .removePredefinedField (field .getName ());

      // Add new fields.

      this [_protoFields] = Array .from (this [_protoNode] .getUserDefinedFields ());

      for (const fieldDefinition of this [_protoNode] .getFieldDefinitions ())
         this .addPredefinedField (fieldDefinition);

      // Reuse old fields, and therefor routes.

      for (const protoField of this [_protoFields])
      {
         const oldFieldName = oldProtoFields .find (field => field === protoField) ?.getName ()
            ?? protoField .getName ();

         if (!oldFieldName)
            continue;

         const
            newField = this .getPredefinedFields () .get (protoField .getName ()),
            oldField = oldFields .find (field => field .getName () === oldFieldName);

         if (!oldField)
            continue;

         if (oldField .getType () !== newField .getType ())
            continue;

         // Assign default value.
         if (oldField .isInitializable ())
         {
            if (oldField .getModificationTime () < 0)
            {
               oldField .assign (newField);
               oldField .setModificationTime (-1);
            }
         }

         oldField .addParent (this);
         oldField .setAccessType (newField .getAccessType ());
         oldField .setName (newField .getName ());

         // Replace field, ie. reuse old field.
         this .getPredefinedFields () .update (newField .getName (), newField .getName (), oldField);

         const references = Array .from (oldField .getReferences ());

         // Remove references and routes.
         for (const field of oldField .getFieldInterests ())
            oldField .removeFieldInterest (field);

         // Readd references.
         for (const field of references)
         {
            oldField .removeReference (field);
            oldField .addReference (field);
         }

         // Reconnect input routes.
         for (const route of Array .from (oldField .getInputRoutes ()))
         {
            try
            {
               const { sourceNode, sourceField } = route;

               route .getExecutionContext () .deleteRoute (route);
               route .getExecutionContext () .addRoute (sourceNode, sourceField, this, oldField .getName ());
            }
            catch
            { }
         }

         // Reconnect output routes.
         for (const route of Array .from (oldField .getOutputRoutes ()))
         {
            try
            {
               const { destinationNode, destinationField } = route;

               route .getExecutionContext () .deleteRoute (route);
               route .getExecutionContext () .addRoute (this, oldField .getName (), destinationNode, destinationField );
            }
            catch
            { }
         }

         // Remove from old fields and dispose new field.
         oldFields .splice (oldFields .indexOf (oldField), 1);
         newField .dispose ();
      }

      // Dispose unused old fields.

      for (const oldField of oldFields)
         oldField .dispose ();

      // Construct now.

      this .construct ();
   },
   getExtendedEventHandling ()
   {
      return false;
   },
   getProtoNode ()
   {
      return this [_protoNode];
   },
   setProtoNode (protoNode, construct = false)
   {
      // Disconnect old proto node.

      const oldProtoNode = this [_protoNode];

      oldProtoNode ._name_changed .removeFieldInterest (this ._typeName_changed);
      oldProtoNode ._updateInstances .removeInterest ("construct", this);
      oldProtoNode ._updateInstances .removeInterest ("update",    this);

      // Get fields from new proto node.

      this [_protoNode]        = protoNode;
      this [_fieldDefinitions] = protoNode .getFieldDefinitions ();
      this [_protoFields]      = Array .from (protoNode .getUserDefinedFields ());

      protoNode ._name_changed .addFieldInterest (this ._typeName_changed);

      construct ? this .construct () : this .update ();
   },
   getBody ()
   {
      return this [_body];
   },
   getInnerNode ()
   {
      if (this [_body])
      {
         const rootNodes = this [_body] .getRootNodes ();

         if (rootNodes .length)
         {
            const rootNode = rootNodes [0];

            if (rootNode)
               return rootNode .getValue () .getInnerNode ();
         }
      }

      throw new Error ("Root node not available.");
   },
   isDefaultValue (field)
   {
      const protoNode = this [_protoNode];

      if (protoNode .isExternProto && protoNode .checkLoadState () !== _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .COMPLETE_STATE)
         return field .getModificationTime () < 0;

      return _X3DNode_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .prototype .isDefaultValue .call (this, field);
   },
   importExternProtos (externprotos1)
   {
      const externprotos2 = this [_body] .externprotos;

      for (const externproto of externprotos1)
         externprotos2 .add (externproto .getName (), externproto);
   },
   importProtos (protos1)
   {
      const protos2 = this [_body] .protos;

      for (const proto of protos1)
         protos2 .add (proto .getName (), proto);
   },
   copyRootNodes (rootNodes1)
   {
      const rootNodes2 = this [_body] .getRootNodes ();

      for (const node of rootNodes1 .getValue ())
         rootNodes2 .push (node .copy (this));
   },
   importImportedNodes (importedNodes)
   {
      for (const importedNode of importedNodes)
      {
         try
         {
            const inlineNode = this [_body] .getNamedNode (importedNode .getInlineNode () .getName ());

            this [_body] .addImportedNode (inlineNode, importedNode .getExportedName (), importedNode .getImportedName ());
         }
         catch (error)
         {
            console .error (error);
         }
      }
   },
   copyRoutes (routes)
   {
      for (const route of routes)
      {
         try
         {
            const sourceNode = route .getSourceNode () instanceof _X3DNode_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A
               ? this [_body] .getLocalNode (route .getSourceNode () .getName ())
               : this [_body] .getLocalNode (route .getSourceNode () .getImportedName ());

            const destinationNode = route .getDestinationNode () instanceof _X3DNode_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A
               ? this [_body] .getLocalNode (route .getDestinationNode () .getName ())
               : this [_body] .getLocalNode (route .getDestinationNode () .getImportedName ());

            this [_body] .addRoute (sourceNode, route .sourceField, destinationNode, route .destinationField);
         }
         catch (error)
         {
            console .error (error);
         }
      }
   },
   toXMLStream (generator)
   {
      const sharedNode = generator .IsSharedNode (this);

      const name = generator .Name (this);

      if (name .length)
      {
         if (generator .ExistsNode (this))
         {
            generator .openTag ("ProtoInstance");
            generator .attribute ("name", this .getTypeName ());
            generator .attribute ("USE",  name);
            generator .containerField (this .getContainerField ());
            generator .closeTag ("ProtoInstance");
            return;
         }
      }

      generator .openTag ("ProtoInstance");
      generator .attribute ("name", this .getTypeName ());

      if (name .length)
      {
         generator .AddNode (this);
         generator .attribute ("DEF", name);
      }

      generator .containerField (this .getContainerField ());

      const fields = this .getChangedFields ();

      if (fields .length === 0)
      {
         generator .closeTag ("ProtoInstance");
      }
      else
      {
         generator .endTag ();
         generator .IncIndent ();

         const references = [ ];

         for (const field of fields)
         {
            // If the field is a inputOutput and we have as reference only inputOnly or outputOnly we must output the value
            // for this field.

            let mustOutputValue = false;

            if (generator .ExecutionContext ())
            {
               if (field .getAccessType () === _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .inputOutput && field .getReferences () .size !== 0)
               {
                  if (![... field .getReferences ()] .some (reference => reference .isInitializable ()))
                     mustOutputValue = !this .isDefaultValue (field);
               }
            }

            // If we have no execution context we are not in a proto and must not generate IS references the same is true
            // if the node is a shared node as the node does not belong to the execution context.

            if (field .getReferences () .size === 0 || !generator .ExecutionContext () || sharedNode || mustOutputValue)
            {
               if (mustOutputValue)
                  references .push (field);

               switch (field .getType ())
               {
                  case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .MFNode:
                  {
                     generator .openTag ("fieldValue");
                     generator .attribute ("name", field .getName ());

                     if (field .length === 0)
                     {
                        generator .closeTag ("fieldValue");
                        generator .TidyBreak ();
                     }
                     else
                     {
                        generator .endTag ();
                        generator .IncIndent ();
                        generator .PushContainerField (null);

                        field .toXMLStream (generator);

                        generator .TidyBreak ();
                        generator .DecIndent ();
                        generator .closingTag ("fieldValue");
                        generator .TidyBreak ();
                        generator .PopContainerField ();
                     }

                     break;
                  }
                  case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .SFNode:
                  {
                     generator .openTag ("fieldValue");
                     generator .attribute ("name", field .getName ());

                     if (field .getValue () === null)
                     {
                        generator .attribute ("value", "null");
                        generator .closeTag ("fieldValue");
                        generator .TidyBreak ();
                     }
                     else
                     {
                        generator .endTag ();
                        generator .IncIndent ();
                        generator .PushContainerField (null);

                        field .toXMLStream (generator);

                        generator .TidyBreak ();
                        generator .DecIndent ();
                        generator .closingTag ("fieldValue");
                        generator .TidyBreak ();
                     }

                     generator .PopContainerField ();
                     break;
                  }
                  default:
                  {
                     generator .openTag ("fieldValue");
                     generator .attribute ("name", field .getName ());

                     generator .Space ();
                     generator .string += "value='";

                     field .toXMLStream (generator);

                     generator .string += "'";
                     generator .closeTag ("fieldValue");
                     generator .TidyBreak ();
                     break;
                  }
               }
            }
            else
            {
               references .push (field);
            }
         }

         if (references .length && !sharedNode)
         {
            generator .openingTag ("IS");
            generator .TidyBreak ();
            generator .IncIndent ();

            for (const field of references)
            {
               const protoFields = field .getReferences ();

               for (const protoField of protoFields)
               {
                  generator .openTag ("connect");
                  generator .attribute ("nodeField",  field .getName ());
                  generator .attribute ("protoField", protoField .getName ());
                  generator .closeTag ("connect");
                  generator .TidyBreak ();
               }
            }

            generator .DecIndent ();
            generator .closingTag ("IS");
            generator .TidyBreak ();
         }

         generator .DecIndent ();
         generator .closingTag ("ProtoInstance");
      }
   },
   toJSONStream (generator)
   {
      const sharedNode = generator .IsSharedNode (this);

      // Type name

      generator .beginObject ("ProtoInstance", false, true);

      const name = generator .Name (this);

      if (name .length)
      {
         if (generator .ExistsNode (this))
         {
            generator .stringProperty ("@name", this .getTypeName (), false);
            generator .stringProperty ("@USE", name);
            generator .endObject ();
            generator .endObject ();
            return;
         }
      }

      // DEF name

      if (name .length)
      {
         generator .AddNode (this);
         generator .stringProperty ("@DEF", name, false);
      }

      // Type name

      generator .stringProperty ("@name", this .getTypeName (), name .length);

      // Fields

      const
         fields     = this .getChangedFields (),
         references = [ ];

      if (fields .length)
      {
         generator .beginArray ("fieldValue");

         const outputFields = [ ];

         for (const field of fields)
         {
            // If the field is a inputOutput and we have as reference only inputOnly or outputOnly we must output the value
            // for this field.

            let mustOutputValue = false;

            if (generator .ExecutionContext ())
            {
               if (field .getAccessType () === _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .inputOutput && field .getReferences () .size !== 0)
               {
                  if (![... field .getReferences ()] .some (reference => reference .isInitializable ()))
                     mustOutputValue = !this .isDefaultValue (field);
               }
            }

            // If we have no execution context we are not in a proto and must not generate IS references the same is true
            // if the node is a shared node as the node does not belong to the execution context.

            if (field .getReferences () .size === 0 || !generator .ExecutionContext () || sharedNode || mustOutputValue)
            {
               if (mustOutputValue)
                  references .push (field);

               outputFields .push (field);
            }
            else
            {
               references .push (field);
            }
         }

         for (const field of outputFields)
         {
            switch (field .getType ())
            {
               case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .SFNode:
               {
                  generator .beginObject ("", field !== outputFields [0]);
                  generator .stringProperty ("@name", field .getName (), false);
                  generator .beginArray ("-children");

                  generator .TidyBreak ();
                  generator .Indent ();

                  field .toJSONStream (generator);

                  generator .endArray ();
                  generator .endObject ();
                  break;
               }
               case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .MFNode:
               {
                  generator .beginObject ("", field !== outputFields [0]);
                  generator .stringProperty ("@name", field .getName (), false);
                  generator .beginValue ("-children");

                  field .toJSONStream (generator);

                  generator .endObject ();
                  break;
               }
               default:
               {
                  generator .beginObject ("", field !== outputFields [0]);
                  generator .stringProperty ("@name", field .getName (), false);
                  generator .beginValue ("@value");

                  field .toJSONStream (generator);

                  generator .endObject ();
                  break;
               }
            }
         }

         generator .endArray ();

         // IS references

         if (references .length && !sharedNode)
         {
            generator .beginObject ("IS");
            generator .beginArray ("connect", false);

            for (const field of references)
            {
               const protoFields = Array .from (field .getReferences ());

               for (const protoField of protoFields)
               {
                  generator .beginObject ("", field !== references [0] || protoField !== protoFields [0]);
                  generator .stringProperty ("@nodeField",  field .getName (), false);
                  generator .stringProperty ("@protoField", protoField .getName ());
                  generator .endObject ();
               }
            }

            generator .endArray ();
            generator .endObject ();
         }
      }

      // End

      generator .endObject ();
      generator .endObject ();
   },
   dispose ()
   {
      const protoNode = this [_protoNode];

      protoNode ._name_changed .removeFieldInterest (this ._typeName_changed);
      protoNode ._updateInstances .removeInterest ("construct", this);
      protoNode ._updateInstances .removeInterest ("update",    this);

      this [_body] ?.dispose ();

      _X3DNode_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .prototype .dispose .call (this);
   },
});

Object .defineProperties (X3DPrototypeInstance, _X3DNode_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .getStaticProperties ("X3DPrototypeInstance", "Core", 2, "children", "2.0"));

const __default__ = X3DPrototypeInstance;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .add ("X3DPrototypeInstance", __default__));

/***/ },

/***/ 2905
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(1743);
/* harmony import */ var _X3DChildNode_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(7745);
/* harmony import */ var _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(3411);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(8427);




function X3DSensorNode (executionContext)
{
   _X3DChildNode_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .call (this, executionContext);

   this .addType (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .X3DSensorNode);
}

Object .setPrototypeOf (X3DSensorNode .prototype, _X3DChildNode_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .prototype);

Object .defineProperties (X3DSensorNode, _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .getStaticProperties ("X3DSensorNode", "Core", 1));

const __default__ = X3DSensorNode;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .add ("X3DSensorNode", __default__));

/***/ },

/***/ 2497
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Fields_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(9818);
/* harmony import */ var _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(3927);
/* harmony import */ var _Base_FieldDefinitionArray_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(5373);
/* harmony import */ var _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(1743);
/* harmony import */ var _X3DBackgroundNode_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(7814);
/* harmony import */ var _Texturing_ImageTexture_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(3113);
/* harmony import */ var _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(3411);
/* harmony import */ var _standard_Math_Numbers_Color3_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(8759);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(8427);









function Background (executionContext)
{
   _X3DBackgroundNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .call (this, executionContext);

   this .addType (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .Background);
}

Object .assign (Object .setPrototypeOf (Background .prototype, _X3DBackgroundNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .prototype),
{
   initialize ()
   {
      _X3DBackgroundNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .prototype .initialize .call (this);

      const
         frontTexture      = new _Texturing_ImageTexture_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A (this .getExecutionContext ()),
         backTexture       = new _Texturing_ImageTexture_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A (this .getExecutionContext ()),
         leftTexture       = new _Texturing_ImageTexture_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A (this .getExecutionContext ()),
         rightTexture      = new _Texturing_ImageTexture_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A (this .getExecutionContext ()),
         topTexture        = new _Texturing_ImageTexture_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A (this .getExecutionContext ()),
         bottomTexture     = new _Texturing_ImageTexture_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A (this .getExecutionContext ()),
         textureProperties = this .getBrowser () .getBackgroundTextureProperties ();

      this ._frontUrl  .addFieldInterest (frontTexture  ._url);
      this ._backUrl   .addFieldInterest (backTexture   ._url);
      this ._leftUrl   .addFieldInterest (leftTexture   ._url);
      this ._rightUrl  .addFieldInterest (rightTexture  ._url);
      this ._topUrl    .addFieldInterest (topTexture    ._url);
      this ._bottomUrl .addFieldInterest (bottomTexture ._url);

      frontTexture  ._url = this ._frontUrl;
      backTexture   ._url = this ._backUrl;
      leftTexture   ._url = this ._leftUrl;
      rightTexture  ._url = this ._rightUrl;
      topTexture    ._url = this ._topUrl;
      bottomTexture ._url = this ._bottomUrl;

      frontTexture  ._textureProperties = textureProperties;
      backTexture   ._textureProperties = textureProperties;
      leftTexture   ._textureProperties = textureProperties;
      rightTexture  ._textureProperties = textureProperties;
      topTexture    ._textureProperties = textureProperties;
      bottomTexture ._textureProperties = textureProperties;

      frontTexture  .setup ();
      backTexture   .setup ();
      leftTexture   .setup ();
      rightTexture  .setup ();
      topTexture    .setup ();
      bottomTexture .setup ();

      this .set_texture__ (0, frontTexture);
      this .set_texture__ (1, backTexture);
      this .set_texture__ (2, leftTexture);
      this .set_texture__ (3, rightTexture);
      this .set_texture__ (4, topTexture);
      this .set_texture__ (5, bottomTexture);
   }
});

Object .defineProperties (Background,
{
   ... _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .getStaticProperties ("Background", "EnvironmentalEffects", 1, "children", "2.0"),
   fieldDefinitions:
   {
      value: new _Base_FieldDefinitionArray_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A ([
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .inputOutput, "metadata",     new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFNode ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .inputOnly,   "set_bind",     new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFBool ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .inputOutput, "frontUrl",     new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFString ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .inputOutput, "backUrl",      new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFString ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .inputOutput, "leftUrl",      new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFString ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .inputOutput, "rightUrl",     new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFString ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .inputOutput, "topUrl",       new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFString ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .inputOutput, "bottomUrl",    new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFString ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .inputOutput, "skyAngle",     new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFFloat ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .inputOutput, "skyColor",     new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFColor (new _standard_Math_Numbers_Color3_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A ())),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .inputOutput, "groundAngle",  new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFFloat ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .inputOutput, "groundColor",  new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFColor ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .inputOutput, "transparency", new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFFloat ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .outputOnly,  "isBound",      new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFBool ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .outputOnly,  "bindTime",     new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFTime ()),
      ]),
      enumerable: true,
   },
});

const __default__ = Background;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_8__/* ["default"] */ .A .add ("Background", __default__));

/***/ },

/***/ 2121
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Fields_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(9818);
/* harmony import */ var _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(3927);
/* harmony import */ var _Base_FieldDefinitionArray_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(5373);
/* harmony import */ var _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(1743);
/* harmony import */ var _Core_X3DBindableNode_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(532);
/* harmony import */ var _X3DFogObject_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(4643);
/* harmony import */ var _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(3411);
/* harmony import */ var _standard_Math_Numbers_Matrix4_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(6776);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(8427);









function Fog (executionContext)
{
   _Core_X3DBindableNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .call (this, executionContext);
   _X3DFogObject_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A    .call (this, executionContext);

   this .addType (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .Fog);

   this .modelMatrix = new _standard_Math_Numbers_Matrix4_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A ();
}

Object .assign (Object .setPrototypeOf (Fog .prototype, _Core_X3DBindableNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .prototype),
   _X3DFogObject_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .prototype,
{
   initialize ()
   {
      _Core_X3DBindableNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .prototype .initialize .call (this);
      _X3DFogObject_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A    .prototype .initialize .call (this);
   },
   getModelMatrix ()
   {
      return this .modelMatrix;
   },
   traverse (type, renderObject)
   {
      renderObject .getLayer () .getFogs () .push (this);

      this .modelMatrix .assign (renderObject .getModelViewMatrix () .get ());
   },
   dispose ()
   {
      _X3DFogObject_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A    .prototype .dispose .call (this);
      _Core_X3DBindableNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .prototype .dispose .call (this);
   },
});

Object .defineProperties (Fog,
{
   ... _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .getStaticProperties ("Fog", "EnvironmentalEffects", 2, "children", "2.0"),
   fieldDefinitions:
   {
      value: new _Base_FieldDefinitionArray_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A ([
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .inputOutput, "metadata",        new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFNode ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .inputOnly,   "set_bind",        new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFBool ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .inputOutput, "fogType",         new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFString ("LINEAR")),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .inputOutput, "color",           new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFColor (1, 1, 1)),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .inputOutput, "visibilityStart", new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFFloat ()), // experimental
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .inputOutput, "visibilityRange", new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFFloat ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .outputOnly,  "isBound",         new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFBool ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .outputOnly,  "bindTime",        new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFTime ()),
      ]),
      enumerable: true,
   },
});

const __default__ = Fog;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_8__/* ["default"] */ .A .add ("Fog", __default__));

/***/ },

/***/ 7814
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Fields_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(9818);
/* harmony import */ var _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(1743);
/* harmony import */ var _Core_X3DBindableNode_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(532);
/* harmony import */ var _Browser_Rendering_GeometryContext_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(582);
/* harmony import */ var _Rendering_VertexArray_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(2793);
/* harmony import */ var _Rendering_TraverseType_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(3970);
/* harmony import */ var _Browser_Shape_AlphaMode_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(2283);
/* harmony import */ var _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(3411);
/* harmony import */ var _Rendering_RenderPass_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(8045);
/* harmony import */ var _standard_Math_Numbers_Complex_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(6295);
/* harmony import */ var _standard_Math_Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(8655);
/* harmony import */ var _standard_Math_Numbers_Rotation4_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(9461);
/* harmony import */ var _standard_Math_Numbers_Matrix4_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(6776);
/* harmony import */ var _standard_Math_Algorithm_js__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(9919);
/* harmony import */ var _standard_Utility_BitSet_js__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(6895);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(8427);
















function X3DBackgroundNode (executionContext)
{
   _Core_X3DBindableNode_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .call (this, executionContext);

   this .addType (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .X3DBackgroundNode);

   this .addChildObjects (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .inputOutput, "hidden", new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFBool ());

   this .setVisibleObject (true);

   // Units

   this ._skyAngle    .setUnit ("angle");
   this ._groundAngle .setUnit ("angle");

   // Private properties

   this .modelMatrix      = new _standard_Math_Numbers_Matrix4_js__WEBPACK_IMPORTED_MODULE_12__/* ["default"] */ .A ();
   this .clipPlanes       = [ ];
   this .colors           = [ ];
   this .sphere           = [ ];
   this .textureNodes     = new Array (6);
   this .textureBits      = new _standard_Utility_BitSet_js__WEBPACK_IMPORTED_MODULE_14__/* ["default"] */ .A ();
   this .sphereContext    = new _Browser_Rendering_GeometryContext_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A ({ colorMaterial: true });
   this .texturesContext  = new _Browser_Rendering_GeometryContext_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A ({ localObjectsKeys: this .sphereContext .localObjectsKeys });
   this .localObjectsKeys = this .sphereContext .localObjectsKeys;

   this [_Rendering_RenderPass_js__WEBPACK_IMPORTED_MODULE_8__/* ["default"] */ .A .RENDER_KEY]         = this;
   this [_Rendering_RenderPass_js__WEBPACK_IMPORTED_MODULE_8__/* ["default"] */ .A .TRANSMISSION_KEY]   = this;
   this [_Rendering_RenderPass_js__WEBPACK_IMPORTED_MODULE_8__/* ["default"] */ .A .VOLUME_SCATTER_KEY] = null;

}

Object .assign (Object .setPrototypeOf (X3DBackgroundNode .prototype, _Core_X3DBindableNode_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .prototype),
{
   initialize ()
   {
      _Core_X3DBindableNode_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .prototype .initialize .call (this);

      const
         browser = this .getBrowser (),
         gl      = browser .getContext ();

      this .colorBuffer         = gl .createBuffer ();
      this .sphereBuffer        = gl .createBuffer ();
      this .texCoordBuffers     = [gl .createBuffer ()];
      this .textureBuffers      = Array .from ({length: 6}, () => gl .createBuffer ());
      this .sphereArrayObject   = new _Rendering_VertexArray_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A (gl);
      this .textureArrayObjects = Array .from ({length: 6}, () => new _Rendering_VertexArray_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A (gl));

      this ._groundAngle .addInterest ("build", this);
      this ._groundColor .addInterest ("build", this);
      this ._skyAngle    .addInterest ("build", this);
      this ._skyColor    .addInterest ("build", this);

      this .build ();
      this .transferRectangle ();
   },
   isHidden ()
   {
      return this ._hidden .getValue ();
   },
   setHidden (value)
   {
      if (value === this ._hidden .getValue ())
         return;

      this ._hidden = value;
   },
   isTransparent ()
   {
      if (this ._hidden .getValue ())
         return true;

      if (this ._transparency .getValue () <= 0)
         return false;

      if (this .textureBits .size !== 6)
         return true;

      for (const i of this .textureBits)
      {
         if (this .textureNodes [i] ._transparent .getValue ())
            return true;
      }

      return false;
   },
   getRenderPassNodes ()
   {
      return this .renderPassNodes;
   },
   set_texture__ (index, textureNode)
   {
      this .textureNodes [index] ?.removeInterest (`set_loadState${index}__`, this);

      this .textureNodes [index] = textureNode;

      textureNode ?.addInterest (`set_loadState${index}__`, this, index, textureNode);

      this .set_loadState__ (index, textureNode);
   },
   set_loadState__ (index, textureNode)
   {
      this .setTextureBit (index, textureNode ?.checkLoadState ());
   },
   setTextureBit (bit, loadState)
   {
      this .textureBits .set (bit, loadState === _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .COMPLETE_STATE);
   },
   getColor (theta, color, angle)
   {
      const index = _standard_Math_Algorithm_js__WEBPACK_IMPORTED_MODULE_13__/* ["default"] */ .A .upperBound (angle, 0, angle .length, theta);

      return color [index];
   },
   build ()
   {
      this .colors .length = 0;
      this .sphere .length = 0;

      if (this ._groundColor .length === 0 && this ._skyColor .length == 1)
      {
         // Build cube

         this .sphere .vertices = 36;

         this .sphere .push ( 1,  1, -1, 1, -1,  1, -1, 1, -1, -1, -1, 1, // Back
                              1,  1, -1, 1, -1, -1, -1, 1,  1, -1, -1, 1,
                             -1,  1,  1, 1,  1,  1,  1, 1, -1, -1,  1, 1, // Front
                             -1, -1,  1, 1,  1,  1,  1, 1,  1, -1,  1, 1,
                             -1,  1, -1, 1, -1,  1,  1, 1, -1, -1,  1, 1, // Left
                             -1,  1, -1, 1, -1, -1,  1, 1, -1, -1, -1, 1,
                              1,  1,  1, 1,  1,  1, -1, 1,  1, -1,  1, 1, // Right
                              1, -1,  1, 1,  1,  1, -1, 1,  1, -1, -1, 1,
                              1,  1,  1, 1, -1,  1,  1, 1, -1,  1, -1, 1, // Top
                              1,  1,  1, 1, -1,  1, -1, 1,  1,  1, -1, 1,
                             -1, -1,  1, 1,  1, -1,  1, 1, -1, -1, -1, 1, // Bottom
                             -1, -1, -1, 1,  1, -1,  1, 1,  1, -1, -1, 1);

         const color = this ._skyColor [0];

         for (let i = 0, vertices = this .sphere .vertices; i < vertices; ++ i)
            this .colors .push (... color, 1);
      }
      else
      {
         // Build sphere

         if (this ._skyColor .length > this ._skyAngle .length)
         {
            const vAngle = this ._skyAngle .slice ();

            if (vAngle .length === 0 || vAngle [0] > 0)
               vAngle .unshift (0);

            if (vAngle .at (-1) < Math .PI)
               vAngle .push (Math .PI);

            if (vAngle .length === 2)
               vAngle .splice (1, 0, (vAngle [0] + vAngle [1]) / 2)

            this .buildSphere (vAngle, this ._skyAngle, this ._skyColor, false);
         }

         if (this ._groundColor .length > this ._groundAngle .length)
         {
            const vAngle = this ._groundAngle .slice () .reverse ();

            if (vAngle .length === 0 || vAngle [0] < Math .PI / 2)
               vAngle .unshift (Math .PI / 2);

            if (vAngle .at (-1) > 0)
               vAngle .push (0);

            this .buildSphere (vAngle, this ._groundAngle, this ._groundColor, true);
         }
      }

      this .transferSphere ();
   },
   buildSphere: (() =>
   {
      const U_DIMENSION = 20;

      const
         z1 = new _standard_Math_Numbers_Complex_js__WEBPACK_IMPORTED_MODULE_9__/* ["default"] */ .A (),
         z2 = new _standard_Math_Numbers_Complex_js__WEBPACK_IMPORTED_MODULE_9__/* ["default"] */ .A (),
         y1 = new _standard_Math_Numbers_Complex_js__WEBPACK_IMPORTED_MODULE_9__/* ["default"] */ .A (),
         y2 = new _standard_Math_Numbers_Complex_js__WEBPACK_IMPORTED_MODULE_9__/* ["default"] */ .A (),
         y3 = new _standard_Math_Numbers_Complex_js__WEBPACK_IMPORTED_MODULE_9__/* ["default"] */ .A (),
         y4 = new _standard_Math_Numbers_Complex_js__WEBPACK_IMPORTED_MODULE_9__/* ["default"] */ .A ();

      return function (vAngle, angle, color, bottom)
      {
         const
            vAngleMax   = bottom ? Math .PI / 2 : Math .PI,
            V_DIMENSION = vAngle .length - 1;

         for (let v = 0; v < V_DIMENSION; ++ v)
         {
            let
               theta1 = _standard_Math_Algorithm_js__WEBPACK_IMPORTED_MODULE_13__/* ["default"] */ .A .clamp (vAngle [v],     0, vAngleMax),
               theta2 = _standard_Math_Algorithm_js__WEBPACK_IMPORTED_MODULE_13__/* ["default"] */ .A .clamp (vAngle [v + 1], 0, vAngleMax);

            if (bottom)
            {
               theta1 = Math .PI - theta1;
               theta2 = Math .PI - theta2;
            }

            z1 .setPolar (1, theta1);
            z2 .setPolar (1, theta2);

            const
               c1 = this .getColor (vAngle [v],     color, angle),
               c2 = this .getColor (vAngle [v + 1], color, angle);

            for (let u = 0; u < U_DIMENSION; ++ u)
            {
               // p4 --- p1
               //  |   / |
               //  | /   |
               // p3 --- p2

               // The last point is the first one.
               const u1 = u < U_DIMENSION - 1 ? u + 1 : 0;

               // p1, p2
               let phi = 2 * Math .PI * (u / U_DIMENSION);
               y1 .setPolar (-z1 .imag, phi);
               y2 .setPolar (-z2 .imag, phi);

               // p3, p4
               phi = 2 * Math .PI * (u1 / U_DIMENSION);
               y3 .setPolar (-z2 .imag, phi);
               y4 .setPolar (-z1 .imag, phi);

               // Triangle 1 and 2

               this .colors .push (... c1, 1,
                                   ... c2, 1,
                                   ... c2, 1,
                                   // Triangle 2
                                   ... c1, 1,
                                   ... c1, 1,
                                   ... c2, 1);

               this .sphere .push (y1 .imag, z1 .real, y1 .real, 1,
                                   y3 .imag, z2 .real, y3 .real, 1,
                                   y2 .imag, z2 .real, y2 .real, 1,
                                   // Triangle 2
                                   y1 .imag, z1 .real, y1 .real, 1,
                                   y4 .imag, z1 .real, y4 .real, 1,
                                   y3 .imag, z2 .real, y3 .real, 1);
            }
         }
      };
   })(),
   transferSphere ()
   {
      const gl = this .getBrowser () .getContext ();

      // Transfer colors.

      gl .bindBuffer (gl .ARRAY_BUFFER, this .colorBuffer);
      gl .bufferData (gl .ARRAY_BUFFER, new Float32Array (this .colors), gl .DYNAMIC_DRAW);

      // Transfer sphere.

      gl .bindBuffer (gl .ARRAY_BUFFER, this .sphereBuffer);
      gl .bufferData (gl .ARRAY_BUFFER, new Float32Array (this .sphere), gl .DYNAMIC_DRAW);

      this .sphereCount = this .sphere .length / 4;
   },
   transferRectangle: (() =>
   {
      const texCoords = new Float32Array ([
         1, 1, 0, 1,
         0, 1, 0, 1,
         0, 0, 0, 1,
         1, 1, 0, 1,
         0, 0, 0, 1,
         1, 0, 0, 1,
      ]);

      const frontVertices = new Float32Array ([
         1,  1, -1, 1,
        -1,  1, -1, 1,
        -1, -1, -1, 1,
         1,  1, -1, 1,
        -1, -1, -1, 1,
         1, -1, -1, 1,
      ]);

      const backVertices = new Float32Array ([
         -1,  1,  1, 1,
          1,  1,  1, 1,
          1, -1,  1, 1,
         -1,  1,  1, 1,
          1, -1,  1, 1,
         -1, -1,  1, 1,
      ]);

      const leftVertices = new Float32Array ([
         -1,  1, -1, 1,
         -1,  1,  1, 1,
         -1, -1,  1, 1,
         -1,  1, -1, 1,
         -1, -1,  1, 1,
         -1, -1, -1, 1,
      ]);

      const rightVertices = new Float32Array ([
         1,  1,  1, 1,
         1,  1, -1, 1,
         1, -1, -1, 1,
         1,  1,  1, 1,
         1, -1, -1, 1,
         1, -1,  1, 1,
      ]);

      const topVertices = new Float32Array ([
          1, 1,  1, 1,
         -1, 1,  1, 1,
         -1, 1, -1, 1,
          1, 1,  1, 1,
         -1, 1, -1, 1,
          1, 1, -1, 1,
      ]);

      const bottomVertices = new Float32Array ([
          1, -1, -1, 1,
         -1, -1, -1, 1,
         -1, -1,  1, 1,
          1, -1, -1, 1,
         -1, -1,  1, 1,
          1, -1,  1, 1,
      ]);

      const vertices = [
         frontVertices,
         backVertices,
         leftVertices,
         rightVertices,
         topVertices,
         bottomVertices,
      ];

      return function ()
      {
         const gl = this .getBrowser () .getContext ();

         // Transfer texCoords.

         gl .bindBuffer (gl .ARRAY_BUFFER, this .texCoordBuffers [0]);
         gl .bufferData (gl .ARRAY_BUFFER, texCoords, gl .DYNAMIC_DRAW);

         // Transfer rectangle.

         for (let i = 0; i < 6; ++ i)
         {
            gl .bindBuffer (gl .ARRAY_BUFFER, this .textureBuffers [i]);
            gl .bufferData (gl .ARRAY_BUFFER, vertices [i], gl .DYNAMIC_DRAW);
         }
      };
   })(),
   traverse (type, renderObject)
   {
      switch (type)
      {
         case _Rendering_TraverseType_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .CAMERA:
         {
            renderObject .getLayer () .getBackgrounds () .push (this);

            this .modelMatrix .assign (renderObject .getModelViewMatrix () .get ());
            return;
         }
         case _Rendering_TraverseType_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .DISPLAY:
         {
            const
               localObjects     = renderObject .getLocalObjects (),
               clipPlanes       = this .clipPlanes,
               localObjectsKeys = this .localObjectsKeys;

            let c = 0;

            for (const localObject of localObjects)
            {
               if (localObject .isClipPlane)
                  clipPlanes [c ++] = localObject;
            }

            clipPlanes       .length = c;
            localObjectsKeys .length = c;
            localObjectsKeys .fill (0);
            return;
         }
      }
   },
   display: (() =>
   {
      const
         projectionMatrixArray = new Float32Array (16),
         projectionMatrix      = new _standard_Math_Numbers_Matrix4_js__WEBPACK_IMPORTED_MODULE_12__/* ["default"] */ .A (),
         projectionScale       = new _standard_Math_Numbers_Matrix4_js__WEBPACK_IMPORTED_MODULE_12__/* ["default"] */ .A (1,0,0,0, 0,1,0,0, 0,0,0,0, 0,0,0,1),
         modelViewMatrixArray  = new Float32Array (16),
         modelViewMatrix       = new _standard_Math_Numbers_Matrix4_js__WEBPACK_IMPORTED_MODULE_12__/* ["default"] */ .A (),
         rotation              = new _standard_Math_Numbers_Rotation4_js__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A (),
         scale                 = new _standard_Math_Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_10__/* ["default"] */ .A ();

      return function (gl, renderObject)
      {
         if (this ._hidden .getValue ())
            return;

         const browser = this .getBrowser ();

         // Always fill background.

         if (browser .getWireframe ())
         {
            const ext = gl .getExtension ("WEBGL_polygon_mode");

            ext ?.polygonModeWEBGL (gl .FRONT_AND_BACK, ext .FILL_WEBGL);
         }

         // Setup context.

         gl .disable (gl .DEPTH_TEST);
         gl .depthMask (false);
         gl .enable (gl .CULL_FACE);
         gl .frontFace (gl .CCW);

         // Create projection matrix.
         // The projectionScale will set gl_Position.z to 0,
         // so it is in the middle of near and far plane.

         projectionMatrixArray .set (projectionMatrix
            .assign (renderObject .getProjectionMatrixArray ())
            .multRight (projectionScale));

         // Rotate and scale background.

         const far = renderObject .getViewpoint () .getMaxFarValue ();

         modelViewMatrix .assign (this .modelMatrix);
         modelViewMatrix .multRight (renderObject .getViewMatrix () .get ());
         modelViewMatrix .get (null, rotation);
         modelViewMatrix .identity ();
         modelViewMatrix .rotate (rotation);
         modelViewMatrix .scale (scale .set (far, far, far));

         modelViewMatrixArray .set (modelViewMatrix);

         // Draw background sphere and texture cube.

         this .drawSphere (renderObject, modelViewMatrixArray, projectionMatrixArray);

         if (+this .textureBits)
            this .drawCube (renderObject, modelViewMatrixArray, projectionMatrixArray);

         gl .depthMask (true);
         gl .enable (gl .DEPTH_TEST);
         gl .disable (gl .BLEND);

         // Restore polygon mode.

         if (browser .getWireframe ())
         {
            const ext = gl .getExtension ("WEBGL_polygon_mode");

            ext ?.polygonModeWEBGL (gl .FRONT_AND_BACK, ext .LINE_WEBGL);
         }
      };
   })(),
   drawSphere (renderObject, modelViewMatrixArray, projectionMatrixArray)
   {
      const transparency = _standard_Math_Algorithm_js__WEBPACK_IMPORTED_MODULE_13__/* ["default"] */ .A .clamp (this ._transparency .getValue (), 0, 1);

      if (transparency === 1)
         return;

      const
         browser       = this .getBrowser (),
         gl            = browser .getContext (),
         sphereContext = this .sphereContext;

      sphereContext .alphaMode    = transparency ? _Browser_Shape_AlphaMode_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .BLEND : _Browser_Shape_AlphaMode_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .OPAQUE;
      sphereContext .renderObject = renderObject;

      const shaderNode = browser .getDefaultMaterial () .getShader (sphereContext);

      shaderNode .enable (gl);
      shaderNode .setClipPlanes (gl, this .clipPlanes, renderObject);

      // Uniforms

      gl .uniformMatrix4fv (shaderNode .x3d_ProjectionMatrix, false, projectionMatrixArray);
      gl .uniformMatrix4fv (shaderNode .x3d_EyeMatrix,        false, renderObject .getEyeMatrixArray ());
      gl .uniformMatrix4fv (shaderNode .x3d_ModelViewMatrix,  false, modelViewMatrixArray);

      gl .uniform3f (shaderNode .x3d_EmissiveColor,                        1, 1, 1)
      gl .uniform1f (shaderNode .x3d_Transparency,                         transparency)
      gl .uniform1i (shaderNode .x3d_TextureCoordinateGenerator [0] .mode, 0);

      // Enable vertex attribute arrays.

      if (this .sphereArrayObject .enable (shaderNode .getProgram ()))
      {
         shaderNode .enableColorAttribute  (gl, this .colorBuffer,  0, 0);
         shaderNode .enableVertexAttribute (gl, this .sphereBuffer, 0, 0);
      }

      // Draw.

      if (transparency)
         gl .enable (gl .BLEND);
      else
         gl .disable (gl .BLEND);

      gl .drawArrays (gl .TRIANGLES, 0, this .sphereCount);
   },
   drawCube: (() =>
   {
      const textureMatrixArray = new Float32Array (_standard_Math_Numbers_Matrix4_js__WEBPACK_IMPORTED_MODULE_12__/* ["default"] */ .A .IDENTITY);

      return function (renderObject, modelViewMatrixArray, projectionMatrixArray)
      {
         const
            browser         = this .getBrowser (),
            gl              = browser .getContext (),
            texturesContext = this .texturesContext;

         // Draw all textures.

         for (const i of this .textureBits)
         {
            const textureNode = this .textureNodes [i];

            texturesContext .alphaMode    = textureNode ._transparent .getValue () ? _Browser_Shape_AlphaMode_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .BLEND : _Browser_Shape_AlphaMode_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .OPAQUE;
            texturesContext .textureNode  = textureNode;
            texturesContext .renderObject = renderObject;

            const shaderNode = browser .getDefaultMaterial () .getShader (texturesContext);

            shaderNode .enable (gl);
            shaderNode .setClipPlanes (gl, this .clipPlanes, renderObject);

            // Set uniforms.

            gl .uniformMatrix4fv (shaderNode .x3d_ProjectionMatrix,  false, projectionMatrixArray);
            gl .uniformMatrix4fv (shaderNode .x3d_EyeMatrix,         false, renderObject .getEyeMatrixArray ());
            gl .uniformMatrix4fv (shaderNode .x3d_ModelViewMatrix,   false, modelViewMatrixArray);
            gl .uniformMatrix4fv (shaderNode .x3d_TextureMatrix [0], false, textureMatrixArray);

            gl .uniform3f (shaderNode .x3d_EmissiveColor,                        1, 1, 1);
            gl .uniform1f (shaderNode .x3d_Transparency,                         0);
            gl .uniform1i (shaderNode .x3d_TextureCoordinateGenerator [0] .mode, 0);

            this .drawRectangle (gl, browser, shaderNode, textureNode, this .textureBuffers [i], this .textureArrayObjects [i]);
         }
      };
   })(),
   drawRectangle (gl, browser, shaderNode, textureNode, buffer, vertexArray)
   {
      textureNode .setShaderUniforms (gl, shaderNode .x3d_Texture [0]);

      if (vertexArray .enable (shaderNode .getProgram ()))
      {
         shaderNode .enableTexCoordAttribute (gl, this .texCoordBuffers, 0, 0);
         shaderNode .enableVertexAttribute (gl, buffer, 0, 0);
      }

      // Draw.

      if (textureNode ._transparent .getValue ())
         gl .enable (gl .BLEND);
      else
         gl .disable (gl .BLEND);

      gl .drawArrays (gl .TRIANGLES, 0, 6);

      browser .resetTextureUnits ();
   },
});

Object .defineProperties (X3DBackgroundNode, _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .getStaticProperties ("X3DBackgroundNode", "EnvironmentalEffects", 1));

for (let index = 0; index < 6; ++ index)
{
   X3DBackgroundNode .prototype [`set_loadState${index}__`] = function (index, textureNode)
   {
      this .set_loadState__ (index, textureNode);
   };
}

const __default__ = X3DBackgroundNode;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_15__/* ["default"] */ .A .add ("X3DBackgroundNode", __default__));

/***/ },

/***/ 4643
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Fields_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(9818);
/* harmony import */ var _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(1743);
/* harmony import */ var _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(3411);
/* harmony import */ var _standard_Utility_ObjectCache_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(9975);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(8427);





const Fogs = (0,_standard_Utility_ObjectCache_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A) (FogContainer);

function FogContainer ()
{
   this .fogMatrix = new Float32Array (9);
}

Object .assign (FogContainer .prototype,
{
   set (fogNode, modelViewMatrix)
   {
      this .fogNode = fogNode;

      this .fogMatrix .set (modelViewMatrix .submatrix .inverse ());
   },
   getFogType ()
   {
      return this .fogNode .getFogType ();
   },
   setShaderUniforms (gl, shaderObject)
   {
      if (shaderObject .hasFog (this))
         return;

      const fogNode = this .fogNode;

      gl .uniform3fv       (shaderObject .x3d_FogColor,           fogNode .colorArray);
      gl .uniform1f        (shaderObject .x3d_FogVisibilityStart, fogNode .visibilityStart);
      gl .uniform1f        (shaderObject .x3d_FogVisibilityRange, fogNode .visibilityRange);
      gl .uniformMatrix3fv (shaderObject .x3d_FogMatrix, false,   this .fogMatrix);
   },
   dispose ()
   {
      Fogs .push (this);
   },
});

function X3DFogObject (executionContext)
{
   this .addType (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .X3DFogObject);

   this .addChildObjects (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .inputOutput, "hidden", new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFBool ());

   // Units

   this ._visibilityStart .setUnit ("length");
   this ._visibilityRange .setUnit ("length");

   // Private properties

   this .colorArray = new Float32Array (3);
}

Object .assign (X3DFogObject .prototype,
{
   initialize ()
   {
      this ._hidden          .addInterest ("set_fogType__",         this);
      this ._fogType         .addInterest ("set_fogType__",         this);
      this ._color           .addInterest ("set_color__",           this);
      this ._visibilityStart .addInterest ("set_visibilityRange__", this);
      this ._visibilityRange .addInterest ("set_visibilityRange__", this);

      this .set_color__ ();
      this .set_visibilityRange__ ();
   },
   isHidden ()
   {
      return this ._hidden .getValue ();
   },
   setHidden (value)
   {
      if (value === this ._hidden .getValue ())
         return;

      this ._hidden = value;
   },
   getFogType ()
   {
      return this .fogType;
   },
   getFogs ()
   {
      return Fogs;
   },
   set_fogType__: (() =>
   {
      const fogTypes = new Map ([
         ["LINEAR",      1],
         ["EXPONENTIAL", 2],
      ]);

      return function ()
      {
         if (this ._hidden .getValue () || (this .visibilityRange === 0 && this .visibilityStart === 0))
            this .fogType = 0;
         else
            this .fogType = fogTypes .get (this ._fogType .getValue ()) || 1;
      };
   })(),
   set_color__ ()
   {
      this .colorArray .set (this ._color .getValue ());
   },
   set_visibilityRange__ ()
   {
      const
         visibilityStart = Math .max (this ._visibilityStart .getValue (), 0),
         visibilityRange = Math .max (this ._visibilityRange .getValue (), 0);

      this .visibilityStart = Math .min (visibilityStart, visibilityRange);
      this .visibilityRange = visibilityRange;

      this .set_fogType__ ();
   },
   dispose () { },
});

Object .defineProperties (X3DFogObject, _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .getStaticProperties ("X3DFogObject", "EnvironmentalEffects", 1));

const __default__ = X3DFogObject;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .add ("X3DFogObject", __default__));

/***/ },

/***/ 8489
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Fields_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(9818);
/* harmony import */ var _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(3927);
/* harmony import */ var _Base_FieldDefinitionArray_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(5373);
/* harmony import */ var _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(1743);
/* harmony import */ var _X3DGroupingNode_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(6368);
/* harmony import */ var _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(3411);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(8427);







function Group (executionContext)
{
   _X3DGroupingNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .call (this, executionContext);

   this .addType (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .Group);
}

Object .setPrototypeOf (Group .prototype, _X3DGroupingNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .prototype);

Object .defineProperties (Group,
{
   ... _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .getStaticProperties ("Group", "Grouping", 1, "children", "2.0"),
   fieldDefinitions:
   {
      value: new _Base_FieldDefinitionArray_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A ([
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .inputOutput,    "metadata",       new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFNode ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .inputOutput,    "visible",        new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFBool (true)),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .inputOutput,    "bboxDisplay",    new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFBool ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .initializeOnly, "bboxSize",       new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFVec3f (-1, -1, -1)),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .initializeOnly, "bboxCenter",     new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFVec3f ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .inputOnly,      "addChildren",    new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFNode ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .inputOnly,      "removeChildren", new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFNode ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .inputOutput,    "children",       new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFNode ()),
      ]),
      enumerable: true,
   },
});

const __default__ = Group;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .add ("Group", __default__));

/***/ },

/***/ 8690
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  A: () => (/* binding */ Grouping_X3DBoundedObject)
});

// EXTERNAL MODULE: ./src/x_ite/Fields.js + 15 modules
var Fields = __webpack_require__(9818);
// EXTERNAL MODULE: ./src/x_ite/Components/Core/X3DNode.js
var X3DNode = __webpack_require__(1743);
// EXTERNAL MODULE: ./src/x_ite/Base/X3DConstants.js
var X3DConstants = __webpack_require__(3411);
// EXTERNAL MODULE: ./src/x_ite/Base/X3DFieldDefinition.js
var X3DFieldDefinition = __webpack_require__(3927);
// EXTERNAL MODULE: ./src/x_ite/Base/FieldDefinitionArray.js
var FieldDefinitionArray = __webpack_require__(5373);
// EXTERNAL MODULE: ./src/x_ite/Components/Core/X3DChildNode.js
var X3DChildNode = __webpack_require__(7745);
// EXTERNAL MODULE: ./src/x_ite/Rendering/TraverseType.js
var TraverseType = __webpack_require__(3970);
// EXTERNAL MODULE: ./src/standard/Math/Numbers/Matrix4.js
var Matrix4 = __webpack_require__(6776);
// EXTERNAL MODULE: ./src/standard/Math/Geometry/Box3.js
var Box3 = __webpack_require__(1789);
// EXTERNAL MODULE: ./src/standard/Math/Numbers/Vector3.js
var Vector3 = __webpack_require__(8655);
// EXTERNAL MODULE: ./src/x_ite/Namespace.js
var Namespace = __webpack_require__(8427);
;// ./src/x_ite/Browser/Grouping/X3DBBoxNode.js











function X3DBBoxNode (executionContext, boundedObject)
{
   X3DChildNode/* default */.A .call (this, executionContext);

   // Private properties

   this .boundedObject = boundedObject;
   this .bboxShape     = this .getBrowser () .getBBoxShape ();
}

Object .assign (Object .setPrototypeOf (X3DBBoxNode .prototype, X3DChildNode/* default */.A .prototype),
{
   getMatrix: (() =>
   {
      const
         bbox    = new Box3/* default */.A (),
         matrix  = new Matrix4/* default */.A (),
         epsilon = new Vector3/* default */.A (1e-6);

      return function ()
      {
         this .boundedObject .getBBox (bbox);

         const
            browser    = this .getBrowser (),
            max        = browser .getRenderingProperty ("ContentScale") === 1 ? Vector3/* default */.A .ZERO : epsilon,
            bboxSize   = bbox .size .max (max),
            bboxCenter = bbox .center;

         return matrix .set (bboxCenter, null, bboxSize);
      };
   })(),
   getShapes (shapes, parentModelMatrix)
   {
      const modelMatrix = parentModelMatrix .copy () .multLeft (this .getMatrix ());

      return this .bboxShape .getShapes (shapes, modelMatrix);
   },
   traverse (type, renderObject)
   {
      if (type === TraverseType/* default */.A .PICKING)
         return;

      const modelViewMatrix = renderObject .getModelViewMatrix ();

      modelViewMatrix .push ();
      modelViewMatrix .multLeft (this .getMatrix ());

      this .bboxShape .traverse (type, renderObject);

      modelViewMatrix .pop ();
   },
});

Object .defineProperties (X3DBBoxNode,
{
   ... X3DNode/* default */.A .getStaticProperties ("X3DBBoxNode", "Grouping", 1, "children", "2.0"),
   fieldDefinitions:
   {
      value: new FieldDefinitionArray/* default */.A ([
         new X3DFieldDefinition/* default */.A (X3DConstants/* default */.A .inputOutput, "metadata", new Fields/* default */.A .SFNode ()),
      ]),
      enumerable: true,
   },
});

const __default__ = X3DBBoxNode;
;

/* harmony default export */ const Grouping_X3DBBoxNode = (Namespace/* default */.A .add ("X3DBBoxNode", __default__));
;// ./src/x_ite/Components/Grouping/X3DBoundedObject.js







function X3DBoundedObject (executionContext)
{
   this .addType (X3DConstants/* default */.A .X3DBoundedObject);

   this .addChildObjects (X3DConstants/* default */.A .outputOnly, "hidden",           new Fields/* default */.A .SFBool (),
                          X3DConstants/* default */.A .outputOnly, "display",          new Fields/* default */.A .SFBool (true),
                          X3DConstants/* default */.A .outputOnly, "transformSensors", new Fields/* default */.A .SFTime ());

   // Units

   this ._bboxSize   .setUnit ("length");
   this ._bboxCenter .setUnit ("length");

   // Private properties

   this .childBBox            = new Box3/* default */.A (); // Must be unique for each X3DBoundedObject.
   this .transformSensorNodes = new Set ();
}

Object .assign (X3DBoundedObject .prototype,
{
   childBBox: new Box3/* default */.A (), // X3DExecutionContext needs this.
   initialize ()
   {
      this ._hidden  .addInterest ("set_visible_and_hidden__", this);
      this ._visible .addInterest ("set_visible_and_hidden__", this);

      this .set_visible_and_hidden__ ();
   },
   isVisible ()
   {
      return this ._display .getValue ();
   },
   isHidden ()
   {
      return this ._hidden .getValue ();
   },
   setHidden (value)
   {
      if (value === this ._hidden .getValue ())
         return;

      this ._hidden = value;
   },
   isDefaultBBoxSize: (() =>
   {
      const defaultBBoxSize = new Vector3/* default */.A (-1);

      return function ()
      {
         return this ._bboxSize .getValue () .equals (defaultBBoxSize);
      };
   })(),
   isBBoxVisible ()
   {
      return this ._bboxDisplay .getValue ();
   },
   getBBox (nodes, bbox, shadows)
   {
      // Must be unique for each X3DBoundedObject.
      const childBBox = this .childBBox;

      // Add bounding boxes.

      bbox .set ();

      for (const node of nodes)
         bbox .add (node .getBBox ?.(childBBox, shadows) ?? childBBox .set ());

      return bbox;
   },
   getBBoxNode ()
   {
      return this .bboxNode ??= (() =>
      {
         const bboxNode = new Grouping_X3DBBoxNode (this .getExecutionContext (), this);

         bboxNode .setPrivate (true);
         bboxNode .setup ();

         return bboxNode;
      })();
   },
   addTransformSensor (transformSensorNode)
   {
      this .transformSensorNodes .add (transformSensorNode);

      this ._transformSensors = this .getBrowser () .getCurrentTime ();
   },
   removeTransformSensor (transformSensorNode)
   {
      this .transformSensorNodes .delete (transformSensorNode);

      this ._transformSensors = this .getBrowser () .getCurrentTime ();
   },
   getTransformSensors ()
   {
      return this .transformSensorNodes;
   },
   set_visible_and_hidden__ ()
   {
      const value = this ._visible .getValue () && !this ._hidden .getValue ();

      if (value === this ._display .getValue ())
         return;

      this ._display = value;
   },
   dispose () { },
});

Object .defineProperties (X3DBoundedObject, X3DNode/* default */.A .getStaticProperties ("X3DBoundedObject", "Grouping", 1));

const X3DBoundedObject_default_ = X3DBoundedObject;
;

/* harmony default export */ const Grouping_X3DBoundedObject = (Namespace/* default */.A .add ("X3DBoundedObject", X3DBoundedObject_default_));

/***/ },

/***/ 6368
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Fields_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(9818);
/* harmony import */ var _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(1743);
/* harmony import */ var _Core_X3DChildNode_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(7745);
/* harmony import */ var _X3DBoundedObject_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(8690);
/* harmony import */ var _Rendering_TraverseType_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(3970);
/* harmony import */ var _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(3411);
/* harmony import */ var _Base_X3DCast_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(7995);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(8427);








function X3DGroupingNode (executionContext)
{
   _Core_X3DChildNode_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A     .call (this, executionContext);
   _X3DBoundedObject_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .call (this, executionContext);

   this .addType (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .X3DGroupingNode);

   this .addChildObjects (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .outputOnly, "rebuild", new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFTime ());

   this .setBoundedObject (true);
   this .setPointingObject (true);
   this .setCollisionObject (true);
   this .setShadowObject (true);
   this .setVisibleObject (true);

   // Private properties

   this .allowedTypes              = new Set ();
   this .pointingDeviceSensorNodes = new Set ();
   this .pointingObjects           = new Set ();
   this .clipPlaneNodes            = new Set ();
   this .displayNodes              = new Set ();
   this .cameraObjects             = new Set ();
   this .pickableSensorNodes       = new Set ();
   this .pickableObjects           = new Set ();
   this .collisionObjects          = new Set ();
   this .shadowObjects             = new Set ();
   this .childNodes                = new Set ();
   this .visibleObjects            = new Set ();
   this .boundedObjects            = new Set ();
   this .sensors                   = [ ];
}

Object .assign (Object .setPrototypeOf (X3DGroupingNode .prototype, _Core_X3DChildNode_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .prototype),
   _X3DBoundedObject_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .prototype,
{
   initialize ()
   {
      _Core_X3DChildNode_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A     .prototype .initialize .call (this);
      _X3DBoundedObject_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .prototype .initialize .call (this);

      this ._rebuild          .addInterest ("set_children__",        this);
      this ._transformSensors .addInterest ("set_pickableObjects__", this);

      this ._bboxSize       .addInterest ("set_boundedObjects__", this);
      this ._addChildren    .addInterest ("set_addChildren__",    this);
      this ._removeChildren .addInterest ("set_removeChildren__", this);
      this ._children       .addInterest ("requestRebuild",       this);

      this .set_children__ ();
   },
   addAllowedTypes (... types)
   {
      for (const type of types)
         this .allowedTypes .add (type);
   },
   getBBox (bbox, shadows)
   {
      if (this .isDefaultBBoxSize ())
         return this .getSubBBox (bbox, shadows);

      return bbox .set (this ._bboxSize .getValue (), this ._bboxCenter .getValue ());
   },
   getSubBBox (bbox, shadows)
   {
      return _X3DBoundedObject_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .prototype .getBBox .call (this, this .boundedObjects, bbox, shadows);
   },
   getShapes (shapes, modelMatrix)
   {
      for (const visibleObject of this .visibleObjects)
         visibleObject .getShapes (shapes, modelMatrix);

      return shapes;
   },
   requestRebuild ()
   {
      this ._rebuild .addEvent ();
   },
   set_addChildren__ ()
   {
      if (this ._addChildren .length === 0)
         return;

      this ._addChildren .setTainted (true);

      const addChildren = new Set (this ._addChildren);

      for (const node of this ._children)
         addChildren .delete (node);

      this .addChildren (addChildren);

      if (!this ._children .isTainted ())
      {
         this ._children .removeInterest ("requestRebuild", this);
         this ._children .addInterest ("connectChildren", this);
      }

      for (const child of addChildren)
         this ._children .push (child);

      this ._addChildren .length = 0;
      this ._addChildren .setTainted (false);
   },
   set_removeChildren__ ()
   {
      if (this ._removeChildren .length === 0)
         return;

      this ._removeChildren .setTainted (true);

      if (this ._children .length > 0)
      {
         const removeChildren = new Set (this ._removeChildren);

         this .removeChildren (removeChildren);

         if (!this ._children .isTainted ())
         {
            this ._children .removeInterest ("requestRebuild", this);
            this ._children .addInterest ("connectChildren", this);
         }

         this ._children = this ._children .filter (child => !removeChildren .has (child));
      }

      this ._removeChildren .length = 0;
      this ._removeChildren .setTainted (false);
   },
   set_children__ ()
   {
      this .clearChildren ();
      this .addChildren (this ._children);
   },
   connectChildren ()
   {
      this ._children .removeInterest ("connectChildren", this);
      this ._children .addInterest ("requestRebuild", this);
   },
   clearChildren ()
   {
      for (const childNode of this .childNodes)
      {
         childNode ._isBoundedObject   .removeInterest ("requestRebuild", this);
         childNode ._isPointingObject  .removeInterest ("requestRebuild", this);
         childNode ._isCameraObject    .removeInterest ("requestRebuild", this);
         childNode ._isPickableObject  .removeInterest ("requestRebuild", this);
         childNode ._isCollisionObject .removeInterest ("requestRebuild", this);
         childNode ._isShadowObject    .removeInterest ("requestRebuild", this);
         childNode ._isVisibleObject   .removeInterest ("requestRebuild", this);

         if ((0,_Base_X3DCast_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A) (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .X3DBoundedObject, childNode))
         {
            childNode ._display     .removeInterest ("requestRebuild", this);
            childNode ._bboxDisplay .removeInterest ("requestRebuild", this);
         }
      }

      this .boundedObjects            .clear ();
      this .pointingDeviceSensorNodes .clear ();
      this .pointingObjects           .clear ();
      this .clipPlaneNodes            .clear ();
      this .displayNodes              .clear ();
      this .cameraObjects             .clear ();
      this .pickableSensorNodes       .clear ();
      this .pickableObjects           .clear ();
      this .collisionObjects          .clear ();
      this .shadowObjects             .clear ();
      this .childNodes                .clear ();
      this .visibleObjects            .clear ();
   },
   addChildren (children)
   {
      // Make sure that the order of children is preserved,
      // otherwise flickering of transparent objects may occur.

      for (const child of children)
         this .addChild (child);

      this .set_objects__ ();
   },
   addChild (child)
   {
      const childNode = (0,_Base_X3DCast_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A) (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .X3DChildNode, child);

      if (!childNode)
         return;

      const type = childNode .getType ();

      if (this .allowedTypes .size)
      {
         if (!type .some (Set .prototype .has, this .allowedTypes))
            return;
      }

      for (let t = type .length - 1; t >= 0; -- t)
      {
         switch (type [t])
         {
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .X3DPointingDeviceSensorNode:
            {
               this .pointingDeviceSensorNodes .add (childNode);
               continue;
            }
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .ClipPlane:
            {
               this .clipPlaneNodes .add (childNode);
               this .displayNodes   .add (childNode);
               continue;
            }
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .LocalFog:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .X3DLightNode:
            {
               this .displayNodes .add (childNode);
               continue;
            }
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .TransformSensor:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .X3DPickSensorNode:
            {
               if (childNode .isPickableObject ())
                  this .pickableSensorNodes .add (childNode);

               continue;
            }
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .X3DChildNode:
            {
               childNode ._isBoundedObject   .addInterest ("requestRebuild", this);
               childNode ._isPointingObject  .addInterest ("requestRebuild", this);
               childNode ._isCameraObject    .addInterest ("requestRebuild", this);
               childNode ._isPickableObject  .addInterest ("requestRebuild", this);
               childNode ._isCollisionObject .addInterest ("requestRebuild", this);
               childNode ._isShadowObject    .addInterest ("requestRebuild", this);
               childNode ._isVisibleObject   .addInterest ("requestRebuild", this);

               this .childNodes .add (childNode);

               if (childNode .isVisible ())
               {
                  if (childNode .isBoundedObject ())
                     this .boundedObjects .add (childNode);

                  if (childNode .isPointingObject ())
                     this .pointingObjects .add (childNode);

                  if (childNode .isCameraObject ())
                     this .cameraObjects .add (childNode);

                  if (childNode .isPickableObject () && !this .pickableSensorNodes .has (childNode))
                     this .pickableObjects .add (childNode);

                  if (childNode .isCollisionObject ())
                     this .collisionObjects .add (childNode);

                  if (childNode .isShadowObject ())
                     this .shadowObjects .add (childNode);

                  if (childNode .isVisibleObject ())
                     this .visibleObjects .add (childNode);
               }

               if ((0,_Base_X3DCast_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A) (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .X3DBoundedObject, childNode))
               {
                  childNode ._display     .addInterest ("requestRebuild", this);
                  childNode ._bboxDisplay .addInterest ("requestRebuild", this);

                  if (childNode .isBBoxVisible ())
                     this .visibleObjects .add (childNode .getBBoxNode ());
               }

               break;
            }
            default:
               continue;
         }

         break;
      }
   },
   removeChildren (children)
   {
      for (const child of children)
         this .removeChild (child);

      this .set_objects__ ();
   },
   removeChild (child)
   {
      const childNode = (0,_Base_X3DCast_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A) (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .X3DChildNode, child);

      if (!childNode)
         return;

      const type = childNode .getType ();

      for (let t = type .length - 1; t >= 0; -- t)
      {
         switch (type [t])
         {
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .X3DPointingDeviceSensorNode:
            {
               this .pointingDeviceSensorNodes .delete (childNode);
               continue;
            }
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .ClipPlane:
            {
               this .clipPlaneNodes .delete (childNode);
               this .displayNodes   .delete (childNode);
               continue;
            }
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .LocalFog:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .X3DLightNode:
            {
               this .displayNodes .delete (childNode);
               continue;
            }
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .TransformSensor:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .X3DPickSensorNode:
            {
               this .pickableSensorNodes .delete (childNode);
               continue;
            }
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .X3DChildNode:
            {
               childNode ._isBoundedObject   .removeInterest ("requestRebuild", this);
               childNode ._isPointingObject  .removeInterest ("requestRebuild", this);
               childNode ._isCameraObject    .removeInterest ("requestRebuild", this);
               childNode ._isPickableObject  .removeInterest ("requestRebuild", this);
               childNode ._isCollisionObject .removeInterest ("requestRebuild", this);
               childNode ._isShadowObject    .removeInterest ("requestRebuild", this);
               childNode ._isVisibleObject   .removeInterest ("requestRebuild", this);

               if ((0,_Base_X3DCast_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A) (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .X3DBoundedObject, childNode))
               {
                  childNode ._display     .removeInterest ("requestRebuild", this);
                  childNode ._bboxDisplay .removeInterest ("requestRebuild", this);
               }

               this .boundedObjects   .delete (childNode);
               this .pointingObjects  .delete (childNode);
               this .cameraObjects    .delete (childNode);
               this .pickableObjects  .delete (childNode);
               this .collisionObjects .delete (childNode);
               this .shadowObjects    .delete (childNode);
               this .childNodes       .delete (childNode);
               this .visibleObjects   .delete (childNode);
               break;
            }
            default:
               continue;
         }

         break;
      }
   },
   set_objects__ ()
   {
      this .set_boundedObjects__ ();
      this .set_pointingObjects__ ();
      this .set_cameraObjects__ ();
      this .set_pickableObjects__ ();
      this .set_collisionObjects__ ();
      this .set_shadowObjects__ ();
      this .set_visibleObjects__ ();
   },
   set_boundedObjects__ ()
   {
      this .setBoundedObject (this .boundedObjects .size || !this .isDefaultBBoxSize ());
   },
   set_pointingObjects__ ()
   {
      this .setPointingObject (this .pointingObjects .size);
   },
   set_cameraObjects__ ()
   {
      this .setCameraObject (this .cameraObjects .size);
   },
   set_pickableObjects__ ()
   {
      this .setPickableObject (this .getTransformSensors () .size || this .pickableSensorNodes .size || this .pickableObjects .size);
   },
   set_collisionObjects__ ()
   {
      this .setCollisionObject (this .collisionObjects .size);
   },
   set_shadowObjects__ ()
   {
      this .setShadowObject (this .shadowObjects .size);
   },
   set_visibleObjects__ ()
   {
      this .setVisibleObject (this .visibleObjects .size);
   },
   traverse (type, renderObject)
   {
      switch (type)
      {
         case _Rendering_TraverseType_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .POINTER:
         {
            const { sensors, pointingDeviceSensorNodes, clipPlaneNodes, pointingObjects } = this;

            if (pointingDeviceSensorNodes .size)
            {
               for (const pointingDeviceSensorNode of pointingDeviceSensorNodes)
                  pointingDeviceSensorNode .push (renderObject, sensors);

               if (sensors .length)
                  renderObject .getSensors () .push (sensors);
            }

            for (const clipPlaneNode of clipPlaneNodes)
               clipPlaneNode .push (renderObject);

            for (const pointingObject of pointingObjects)
               pointingObject .traverse (type, renderObject);

            for (const clipPlaneNode of clipPlaneNodes)
               clipPlaneNode .pop (renderObject);

            if (sensors .length)
            {
               sensors .length = 0;

               renderObject .getSensors () .pop ();
            }

            return;
         }
         case _Rendering_TraverseType_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .CAMERA:
         {
            for (const cameraObject of this .cameraObjects)
               cameraObject .traverse (type, renderObject);

            return;
         }
         case _Rendering_TraverseType_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .PICKING:
         {
            if (this .getTransformSensors () .size)
            {
               const modelMatrix = renderObject .getModelViewMatrix () .get ();

               for (const transformSensorNode of this .getTransformSensors ())
                  transformSensorNode .collect (modelMatrix);
            }

            for (const pickableSensorNode of this .pickableSensorNodes)
               pickableSensorNode .traverse (type, renderObject);

            const
               browser          = this .getBrowser (),
               pickingHierarchy = browser .getPickingHierarchy ();

            pickingHierarchy .push (this);

            if (browser .getPickable () .at (-1))
            {
               for (const visibleObject of this .visibleObjects)
                  visibleObject .traverse (type, renderObject);
            }
            else
            {
               for (const pickableObject of this .pickableObjects)
                  pickableObject .traverse (type, renderObject);
            }

            pickingHierarchy .pop ();
            return;
         }
         case _Rendering_TraverseType_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .COLLISION:
         {
            const { clipPlaneNodes, collisionObjects } = this;

            for (const clipPlaneNode of clipPlaneNodes)
               clipPlaneNode .push (renderObject);

            for (const collisionObject of collisionObjects)
               collisionObject .traverse (type, renderObject);

            for (const clipPlaneNode of clipPlaneNodes)
               clipPlaneNode .pop (renderObject);

            return;
         }
         case _Rendering_TraverseType_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .SHADOW:
         {
            // Nodes that are not visible do not cast shadows.

            const { clipPlaneNodes, shadowObjects } = this;

            for (const clipPlaneNode of clipPlaneNodes)
               clipPlaneNode .push (renderObject);

            for (const shadowObject of shadowObjects)
               shadowObject .traverse (type, renderObject);

            for (const clipPlaneNode of clipPlaneNodes)
               clipPlaneNode .pop (renderObject);

            return;
         }
         case _Rendering_TraverseType_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .DISPLAY:
         {
            const { displayNodes, visibleObjects } = this;

            for (const displayNode of displayNodes)
               displayNode .push (renderObject, this);

            for (const visibleObject of visibleObjects)
               visibleObject .traverse (type, renderObject);

            for (const displayNode of displayNodes)
               displayNode .pop (renderObject);

            return;
         }
      }
   },
   dispose ()
   {
      _X3DBoundedObject_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .prototype .dispose .call (this);
      _Core_X3DChildNode_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A     .prototype .dispose .call (this);
   },
});

Object .defineProperties (X3DGroupingNode, _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .getStaticProperties ("X3DGroupingNode", "Grouping", 1));

const __default__ = X3DGroupingNode;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .add ("X3DGroupingNode", __default__));

/***/ },

/***/ 4770
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Fields_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(9818);
/* harmony import */ var _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(3927);
/* harmony import */ var _Base_FieldDefinitionArray_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(5373);
/* harmony import */ var _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(1743);
/* harmony import */ var _X3DInterpolatorNode_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(1201);
/* harmony import */ var _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(3411);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(8427);







function EaseInEaseOut (executionContext)
{
   _X3DInterpolatorNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .call (this, executionContext);

   this .addType (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .EaseInEaseOut);
}

Object .assign (Object .setPrototypeOf (EaseInEaseOut .prototype, _X3DInterpolatorNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .prototype),
{
   initialize ()
   {
      _X3DInterpolatorNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .prototype .initialize .call (this);

      this ._easeInEaseOut .addInterest ("set_keyValue__", this);
   },
   set_keyValue__ ()
   {
      if (this ._easeInEaseOut .length < this ._key .length)
         this ._easeInEaseOut .resize (this ._key .length, this ._easeInEaseOut .length ? this ._easeInEaseOut [this ._easeInEaseOut .length - 1] : new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFVec2f ());

      // If there was already an set_fraction event in this frame, send a new value_changed to prevent glitches.
      if (this ._set_fraction .getModificationTime () >= this .getBrowser () .getCurrentTime ())
         this .set_fraction__ ();
   },
   interpolate (index0, index1, weight)
   {
      let
         easeOut = this ._easeInEaseOut [index0] .y,
         easeIn  = this ._easeInEaseOut [index1] .x;

      const sum = easeOut + easeIn;

      if (sum < 0)
      {
         this ._modifiedFraction_changed = weight;
      }
      else
      {
         if (sum > 1)
         {
            easeIn  /= sum;
            easeOut /= sum;
         }

         const t = 1 / (2 - easeOut - easeIn);

         if (weight < easeOut)
         {
            this ._modifiedFraction_changed = (t / easeOut) * weight * weight;
         }
         else if (weight <= 1 - easeIn) // Spec says (weight < 1 - easeIn), but then we get a NaN below if easeIn == 0.
         {
            this ._modifiedFraction_changed = t * (2 * weight - easeOut);
         }
         else
         {
            const w = 1 - weight;

            this ._modifiedFraction_changed = 1 - ((t * w * w) / easeIn);
         }
      }
   },
});

Object .defineProperties (EaseInEaseOut,
{
   ... _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .getStaticProperties ("EaseInEaseOut", "Interpolation", 4, "children", "3.2"),
   fieldDefinitions:
   {
      value: new _Base_FieldDefinitionArray_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A ([
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .inputOutput, "metadata",                 new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFNode ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .inputOnly,   "set_fraction",             new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFFloat ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .inputOutput, "key",                      new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFFloat ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .inputOutput, "easeInEaseOut",            new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFVec2f ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .outputOnly,  "modifiedFraction_changed", new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFFloat ()),
      ]),
      enumerable: true,
   },
});

const __default__ = EaseInEaseOut;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .add ("EaseInEaseOut", __default__));

/***/ },

/***/ 9656
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Fields_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(9818);
/* harmony import */ var _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(3927);
/* harmony import */ var _Base_FieldDefinitionArray_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(5373);
/* harmony import */ var _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(1743);
/* harmony import */ var _X3DInterpolatorNode_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(1201);
/* harmony import */ var _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(3411);
/* harmony import */ var _standard_Math_Numbers_Rotation4_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(9461);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(8427);








function OrientationInterpolator (executionContext)
{
   _X3DInterpolatorNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .call (this, executionContext);

   this .addType (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .OrientationInterpolator);

   // Units

   this ._keyValue      .setUnit ("angle");
   this ._value_changed .setUnit ("angle");
}

Object .assign (Object .setPrototypeOf (OrientationInterpolator .prototype, _X3DInterpolatorNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .prototype),
{
   initialize ()
   {
      _X3DInterpolatorNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .prototype .initialize .call (this);

      this ._keyValue .addInterest ("set_keyValue__", this);
   },
   set_keyValue__ ()
   {
      const
         key      = this ._key,
         keyValue = this ._keyValue;

      if (keyValue .length < key .length)
         keyValue .resize (key .length, keyValue .length ? keyValue [keyValue .length - 1] : new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFRotation ());

      // If there was already an set_fraction event in this frame, send a new value_changed to prevent glitches.
      if (this ._set_fraction .getModificationTime () >= this .getBrowser () .getCurrentTime ())
         this .set_fraction__ ();
   },
   interpolate: (() =>
   {
      const
         keyValue0 = new _standard_Math_Numbers_Rotation4_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A (),
         keyValue1 = new _standard_Math_Numbers_Rotation4_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A ();

      return function (index0, index1, weight)
      {
         // Both values can change in slerp.
         keyValue0 .assign (this ._keyValue [index0] .getValue ());
         keyValue1 .assign (this ._keyValue [index1] .getValue ());

         this ._value_changed = keyValue0 .slerp (keyValue1, weight);
      };
   })(),
});

Object .defineProperties (OrientationInterpolator,
{
   ... _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .getStaticProperties ("OrientationInterpolator", "Interpolation", 1, "children", "2.0"),
   fieldDefinitions:
   {
      value: new _Base_FieldDefinitionArray_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A ([
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .inputOutput, "metadata",      new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFNode ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .inputOnly,   "set_fraction",  new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFFloat ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .inputOutput, "key",           new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFFloat ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .inputOutput, "keyValue",      new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFRotation ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .outputOnly,  "value_changed", new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFRotation ()),
      ]),
      enumerable: true,
   },
});

const __default__ = OrientationInterpolator;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .add ("OrientationInterpolator", __default__));

/***/ },

/***/ 8737
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Fields_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(9818);
/* harmony import */ var _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(3927);
/* harmony import */ var _Base_FieldDefinitionArray_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(5373);
/* harmony import */ var _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(1743);
/* harmony import */ var _X3DInterpolatorNode_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(1201);
/* harmony import */ var _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(3411);
/* harmony import */ var _standard_Math_Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(8655);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(8427);








function PositionInterpolator (executionContext)
{
   _X3DInterpolatorNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .call (this, executionContext);

   this .addType (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .PositionInterpolator);
}

Object .assign (Object .setPrototypeOf (PositionInterpolator .prototype, _X3DInterpolatorNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .prototype),
{
   initialize ()
   {
      _X3DInterpolatorNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .prototype .initialize .call (this);

      this ._keyValue .addInterest ("set_keyValue__", this);
   },
   set_keyValue__ ()
   {
      const
         key      = this ._key,
         keyValue = this ._keyValue;

      if (keyValue .length < key .length)
         keyValue .resize (key .length, keyValue .length ? keyValue [keyValue .length - 1] : new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFVec3f ());

      // If there was already an set_fraction event in this frame, send a new value_changed to prevent glitches.
      if (this ._set_fraction .getModificationTime () >= this .getBrowser () .getCurrentTime ())
         this .set_fraction__ ();
   },
   interpolate: (() =>
   {
      const keyValue = new _standard_Math_Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A ();

      return function (index0, index1, weight)
      {
         this ._value_changed = keyValue .assign (this ._keyValue [index0] .getValue ()) .lerp (this ._keyValue [index1] .getValue (), weight);
      };
   })(),
});

Object .defineProperties (PositionInterpolator,
{
   ... _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .getStaticProperties ("PositionInterpolator", "Interpolation", 1, "children", "2.0"),
   fieldDefinitions:
   {
      value: new _Base_FieldDefinitionArray_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A ([
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .inputOutput, "metadata",      new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFNode ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .inputOnly,   "set_fraction",  new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFFloat ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .inputOutput, "key",           new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFFloat ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .inputOutput, "keyValue",      new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFVec3f ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .outputOnly,  "value_changed", new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFVec3f ()),
      ]),
      enumerable: true,
   },
});

const __default__ = PositionInterpolator;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .add ("PositionInterpolator", __default__));

/***/ },

/***/ 2186
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Fields_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(9818);
/* harmony import */ var _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(3927);
/* harmony import */ var _Base_FieldDefinitionArray_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(5373);
/* harmony import */ var _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(1743);
/* harmony import */ var _X3DInterpolatorNode_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(1201);
/* harmony import */ var _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(3411);
/* harmony import */ var _standard_Math_Algorithm_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(9919);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(8427);








function ScalarInterpolator (executionContext)
{
   _X3DInterpolatorNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .call (this, executionContext);

   this .addType (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .ScalarInterpolator);
}

Object .assign (Object .setPrototypeOf (ScalarInterpolator .prototype, _X3DInterpolatorNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .prototype),
{
   initialize ()
   {
      _X3DInterpolatorNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .prototype .initialize .call (this);

      this ._keyValue .addInterest ("set_keyValue__", this);
   },
   set_keyValue__ ()
   {
      const
         key      = this ._key,
         keyValue = this ._keyValue;

      if (keyValue .length < key .length)
         keyValue .resize (key .length, keyValue .length ? keyValue [keyValue .length - 1] : 0);

      // If there was already an set_fraction event in this frame, send a new value_changed to prevent glitches.
      if (this ._set_fraction .getModificationTime () >= this .getBrowser () .getCurrentTime ())
         this .set_fraction__ ();
   },
   interpolate (index0, index1, weight)
   {
      this ._value_changed = _standard_Math_Algorithm_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .lerp (this ._keyValue [index0], this ._keyValue [index1], weight);
   },
});

Object .defineProperties (ScalarInterpolator,
{
   ... _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .getStaticProperties ("ScalarInterpolator", "Interpolation", 1, "children", "2.0"),
   fieldDefinitions:
   {
      value: new _Base_FieldDefinitionArray_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A ([
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .inputOutput, "metadata",      new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFNode ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .inputOnly,   "set_fraction",  new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFFloat ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .inputOutput, "key",           new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFFloat ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .inputOutput, "keyValue",      new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFFloat ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .outputOnly,  "value_changed", new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFFloat ()),
      ]),
      enumerable: true,
   },
});

const __default__ = ScalarInterpolator;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .add ("ScalarInterpolator", __default__));

/***/ },

/***/ 1201
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(1743);
/* harmony import */ var _Core_X3DChildNode_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(7745);
/* harmony import */ var _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(3411);
/* harmony import */ var _standard_Math_Algorithm_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(9919);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(8427);





function X3DInterpolatorNode (executionContext)
{
   _Core_X3DChildNode_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .call (this, executionContext);

   this .addType (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .X3DInterpolatorNode);
}

Object .assign (Object .setPrototypeOf (X3DInterpolatorNode .prototype, _Core_X3DChildNode_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .prototype),
{
   setup ()
   {
      // If an X3DInterpolatorNode value_changed outputOnly field is read before it receives any inputs,
      // keyValue[0] is returned if keyValue is not empty. If keyValue is empty (i.e., [ ]), the initial
      // value for the respective field type is returned (EXAMPLE  (0, 0, 0) for Fields .SFVec3f);

      this .set_key__ ();
      this .set_fraction__ ();

      _Core_X3DChildNode_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .prototype .setup .call (this);
   },
   initialize ()
   {
      _Core_X3DChildNode_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .prototype .initialize .call (this);

      this ._set_fraction .addInterest ("set_fraction__", this);
      this ._key          .addInterest ("set_key__",      this);
   },
   set_fraction__ ()
   {
      const
         key      = this ._key,
         length   = key .length,
         fraction = this ._set_fraction .getValue ();

      switch (length)
      {
         case 0:
            // Interpolator nodes containing no keys in the key field shall not produce any events.
            return;
         case 1:
            return this .interpolate (0, 0, 0);
         default:
         {
            if (fraction <= key [0])
               return this .interpolate (0, 1, 0);

            const index1 = _standard_Math_Algorithm_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .upperBound (key, 0, length, fraction);

            if (index1 !== length)
            {
               const
                  index0 = index1 - 1,
                  weight = (fraction - key [index0]) / (key [index1] - key [index0]);

               this .interpolate (index0, index1, _standard_Math_Algorithm_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .clamp (weight, 0, 1));
            }
            else
               this .interpolate (length - 2, length - 1, 1);
         }
      }
   },
   set_key__ ()
   {
      this .set_keyValue__ ();
   },
});

Object .defineProperties (X3DInterpolatorNode, _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .getStaticProperties ("X3DInterpolatorNode", "Interpolation", 1));

const __default__ = X3DInterpolatorNode;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .add ("X3DInterpolatorNode", __default__));

/***/ },

/***/ 6825
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Fields_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(9818);
/* harmony import */ var _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(3927);
/* harmony import */ var _Base_FieldDefinitionArray_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(5373);
/* harmony import */ var _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(1743);
/* harmony import */ var _X3DLayerNode_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(4516);
/* harmony import */ var _Navigation_Viewpoint_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(1080);
/* harmony import */ var _Grouping_Group_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(8489);
/* harmony import */ var _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(3411);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(8427);









function Layer (executionContext)
{
   _X3DLayerNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .call (this,
                       executionContext,
                       new _Navigation_Viewpoint_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A (executionContext),
                       new _Grouping_Group_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A (executionContext));

   this .addType (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .Layer);
}

Object .assign (Object .setPrototypeOf (Layer .prototype, _X3DLayerNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .prototype),
{
   initialize ()
   {
      _X3DLayerNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .prototype .initialize .call (this);

      const groupNode = this .getGroups () ._children [0] .getValue ();

      this ._addChildren    .addFieldInterest (groupNode ._addChildren);
      this ._removeChildren .addFieldInterest (groupNode ._removeChildren);
      this ._children       .addFieldInterest (groupNode ._children);

      groupNode ._children = this ._children;

      groupNode .setPrivate (true);
      groupNode .setup ();

      this .getGroups () .setup ();
   },
});

Object .defineProperties (Layer,
{
   ... _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .getStaticProperties ("Layer", "Layering", 1, "layers", "3.2"),
   fieldDefinitions:
   {
      value: new _Base_FieldDefinitionArray_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A ([
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .inputOutput, "metadata",       new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFNode ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .inputOutput, "pickable",       new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFBool (true)),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .inputOutput, "objectType",     new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFString ("ALL")),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .inputOutput, "pointerEvents",  new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFBool (true)), // skip test
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .inputOutput, "visible",        new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFBool (true)),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .inputOutput, "viewport",       new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFNode ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .inputOnly,   "addChildren",    new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFNode ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .inputOnly,   "removeChildren", new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFNode ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .inputOutput, "children",       new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFNode ()),
      ]),
      enumerable: true,
   },
});

const __default__ = Layer;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_8__/* ["default"] */ .A .add ("Layer", __default__));

/***/ },

/***/ 873
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Fields_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(9818);
/* harmony import */ var _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(3927);
/* harmony import */ var _Base_FieldDefinitionArray_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(5373);
/* harmony import */ var _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(1743);
/* harmony import */ var _Layer_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(6825);
/* harmony import */ var _Base_X3DCast_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(7995);
/* harmony import */ var _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(3411);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(8427);








function LayerSet (executionContext)
{
   _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .call (this, executionContext);

   this .addType (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .LayerSet);

   this .addChildObject (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .outputOnly, "activeLayerNode",  new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFNode ());

   this .layerNodes = [ new _Layer_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A (executionContext) ];
   this .layerNode0 = this .layerNodes [0];
}

Object .assign (Object .setPrototypeOf (LayerSet .prototype, _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .prototype),
{
   initialize ()
   {
      _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .prototype .initialize .call (this);

      this .layerNode0 .setPrivate (true);
      this .layerNode0 .setup ();
      this .layerNode0 .setLayer0 (true);

      this ._activeLayer .addInterest ("set_activeLayer__", this);
      this ._order       .addInterest ("set_layers__",      this);
      this ._layers      .addInterest ("set_layers__",      this);

      this .set_layers__ ();
   },
   getActiveLayer ()
   {
      return this ._activeLayerNode .getValue ();
   },
   getLayer0 ()
   {
      return this .layerNode0;
   },
   setLayer0 (value)
   {
      this .layerNode0 = value;

      this .set_layers__ ();
   },
   getLayers ()
   {
      return this .layerNodes;
   },
   set_activeLayer__ ()
   {
      let activeLayerNode;

      if (this ._activeLayer .getValue () === 0)
      {
         activeLayerNode = this .layerNode0;
      }
      else
      {
         const index = this ._activeLayer .getValue () - 1;

         if (index >= 0 && index < this ._layers .length)
         {
            activeLayerNode = (0,_Base_X3DCast_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A) (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .X3DLayerNode, this ._layers [index]);
         }
         else
         {
            activeLayerNode = null;
         }
      }

      if (!activeLayerNode ?._display .getValue ())
         activeLayerNode = null;

      if (this ._activeLayerNode .getValue () !== activeLayerNode)
         this ._activeLayerNode = activeLayerNode;
   },
   set_layers__ ()
   {
      const layers = this ._layers .getValue ();

      for (const layerNode of this .layerNodes)
         layerNode ._display .removeInterest ("set_layers__", this);

      this .layerNodes .length = 0;

      for (let index of this ._order)
      {
         if (index === 0)
         {
            this .layerNode0 ._display .addInterest ("set_layers__", this);
            this .layerNodes .push (this .layerNode0);
         }
         else
         {
            -- index;

            if (index >= 0 && index < layers .length)
            {
               const layerNode = (0,_Base_X3DCast_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A) (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .X3DLayerNode, layers [index]);

               if (!layerNode)
                  continue;

               layerNode ._display .addInterest ("set_layers__", this);

               if (layerNode ._display .getValue ())
                  this .layerNodes .push (layerNode);
            }
         }
      }

      this .set_activeLayer__ ();
   },
   bindBindables (viewpointName)
   {
      this .layerNode0 ?.bindBindables (viewpointName);

      for (const node of this ._layers)
      {
         const layerNode = (0,_Base_X3DCast_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A) (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .X3DLayerNode, node);

         layerNode ?.bindBindables (viewpointName);
      }
   },
   traverse (type, renderObject)
   {
      for (const layerNode of this .layerNodes)
         layerNode .traverse (type, renderObject);
   },
});

Object .defineProperties (LayerSet,
{
   ... _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .getStaticProperties ("LayerSet", "Layering", 1, "children", "3.2"),
   fieldDefinitions:
   {
      value: new _Base_FieldDefinitionArray_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A ([
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .inputOutput, "metadata",    new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFNode ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .inputOutput, "activeLayer", new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFInt32 ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .inputOutput, "order",       new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFInt32 (0)),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .inputOutput, "layers",      new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFNode ()),
      ]),
      enumerable: true,
   },
});

const __default__ = LayerSet;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .add ("LayerSet", __default__));

/***/ },

/***/ 4516
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  A: () => (/* binding */ Layering_X3DLayerNode)
});

// EXTERNAL MODULE: ./src/x_ite/Fields.js + 15 modules
var Fields = __webpack_require__(9818);
// EXTERNAL MODULE: ./src/x_ite/Components/Core/X3DNode.js
var X3DNode = __webpack_require__(1743);
// EXTERNAL MODULE: ./src/x_ite/Rendering/TextureBuffer.js
var TextureBuffer = __webpack_require__(2707);
// EXTERNAL MODULE: ./src/x_ite/Rendering/TraverseType.js
var TraverseType = __webpack_require__(3970);
// EXTERNAL MODULE: ./src/x_ite/Rendering/RenderPass.js
var RenderPass = __webpack_require__(8045);
// EXTERNAL MODULE: ./src/standard/Math/Algorithm.js
var Algorithm = __webpack_require__(9919);
// EXTERNAL MODULE: ./src/x_ite/Namespace.js
var Namespace = __webpack_require__(8427);
;// ./src/standard/Math/Algorithms/MergeSort.js
function MergeSort (array, compare)
{
   this .array     = array;
   this .auxiliary = [ ];

   if (compare)
      this .compare = compare;
}

Object .assign (MergeSort .prototype,
{
   compare (lhs, rhs)
   {
      return lhs < rhs;
   },
   sort (first, last)
   {
      this .mergeSort (first, last - 1);
   },
   mergeSort (lo, hi)
   {
      if (lo < hi)
      {
         const m = (lo + hi) >>> 1;
         this .mergeSort (lo, m);   // Recursion
         this .mergeSort (m + 1, hi); // Recursion
         this .merge (lo, m, hi);
      }
   },
   merge (lo, m, hi)
   {
      const { array, auxiliary, compare } = this;

      let i, j, k;

      i = 0, j = lo;
      // Copy first half of array a to auxiliary array b.
      while (j <= m)
         auxiliary [i++] = array [j++];

      i = 0; k = lo;
      // Copy back next-greatest element at each time.
      while (k < j && j <= hi)
      {
         if (compare (array [j], auxiliary [i]))
            array [k++] = array [j++];
         else
            array [k++] = auxiliary [i++];
      }

      // Copy back remaining elements of first half (if any).
      while (k < j)
         array [k++] = auxiliary [i++];
   }
});

const __default__ = MergeSort;
;

/* harmony default export */ const Algorithms_MergeSort = (Namespace/* default */.A .add ("MergeSort", __default__));
// EXTERNAL MODULE: ./src/standard/Math/Geometry/Camera.js
var Camera = __webpack_require__(7184);
// EXTERNAL MODULE: ./src/standard/Math/Geometry/Line3.js
var Line3 = __webpack_require__(7972);
// EXTERNAL MODULE: ./src/standard/Math/Geometry/ViewVolume.js
var ViewVolume = __webpack_require__(3892);
// EXTERNAL MODULE: ./src/standard/Math/Numbers/Vector3.js
var Vector3 = __webpack_require__(8655);
// EXTERNAL MODULE: ./src/standard/Math/Numbers/Vector4.js
var Vector4 = __webpack_require__(4974);
// EXTERNAL MODULE: ./src/standard/Math/Numbers/Rotation4.js
var Rotation4 = __webpack_require__(9461);
// EXTERNAL MODULE: ./src/standard/Math/Numbers/Matrix4.js
var Matrix4 = __webpack_require__(6776);
// EXTERNAL MODULE: ./src/standard/Math/Utility/MatrixStack.js
var MatrixStack = __webpack_require__(7666);
// EXTERNAL MODULE: ./src/standard/Math/Geometry/Plane3.js
var Plane3 = __webpack_require__(460);
// EXTERNAL MODULE: ./src/standard/Time/StopWatch.js
var StopWatch = __webpack_require__(6538);
;// ./src/x_ite/Rendering/X3DRenderObject.js
















const DEPTH_BUFFER_SIZE = 16;

function X3DRenderObject (executionContext)
{
   const browser = executionContext .getBrowser ();

   this .partialRenderKey         = "";
   this .renderKey                = "";
   this .renderCount              = 0;
   this .view                     = null;
   this .viewVolumes              = [ ];
   this .projectionMatrix         = new MatrixStack/* default */.A (Matrix4/* default */.A);
   this .modelViewMatrix          = new MatrixStack/* default */.A (Matrix4/* default */.A);
   this .viewMatrix               = new MatrixStack/* default */.A (Matrix4/* default */.A);
   this .cameraSpaceMatrix        = new MatrixStack/* default */.A (Matrix4/* default */.A);
   this .viewportArray            = new Int32Array (4);
   this .projectionMatrixArray    = new Float32Array (16);
   this .eyeMatrixArray           = new Float32Array (16);
   this .viewMatrixArray          = new Float32Array (16);
   this .cameraSpaceMatrixArray   = new Float32Array (16);
   this .hitRay                   = new Line3/* default */.A ();
   this .sensors                  = [[ ]];
   this .viewpointGroups          = [ ];
   this .lights                   = [ ];
   this .globalLightsKeys         = [ ];
   this .globalLights             = [ ];
   this .localObjectsKeys         = [ ];
   this .localObjects             = [ ];
   this .globalShadows            = [ false ];
   this .globalShadow             = false;
   this .localShadows             = [ false ];
   this .localFogs                = [ null ];
   this .layouts                  = [ ];
   this .hAnimNode                = [ null ];
   this .invHumanoidMatrix        = new MatrixStack/* default */.A (Matrix4/* default */.A);
   this .generatedCubeMapTextures = new Set ();
   this .collisions               = [ ];
   this .collisionTime            = new StopWatch/* default */.A ();
   this .numPointingShapes        = 0;
   this .numCollisionShapes       = 0;
   this .numShadowShapes          = 0;
   this .numOpaqueShapes          = 0;
   this .numTransparentShapes     = 0;
   this .pointingShapes           = [ ];
   this .collisionShapes          = [ ];
   this .activeCollisions         = [ ];
   this .shadowShapes             = [ ];
   this .opaqueShapes             = [ ];
   this .transparentShapes        = [ ];
   this .transparencySorter       = new Algorithms_MergeSort (this .transparentShapes, (a, b) => a .distance < b .distance);
   this .renderPasses             = 0;
   this .renderPass               = RenderPass/* default */.A .NONE;
   this .speed                    = 0;
   this .depthBuffer              = new TextureBuffer/* default */.A ({ browser, width: DEPTH_BUFFER_SIZE, height: DEPTH_BUFFER_SIZE, float: true, colorTextures: 2 });
}

Object .assign (X3DRenderObject .prototype,
{
   initialize ()
   {
      const browser = this .getBrowser ();

      browser .getRenderingProperties () ._Shading                 .addInterest ("set_renderKey__", this);
      browser .getRenderingProperties () ._LogarithmicDepthBuffer  .addInterest ("set_renderKey__", this);
      browser .getRenderingProperties () ._XRSession               .addInterest ("set_renderKey__", this);
      browser .getBrowserOptions () ._ColorSpace                   .addInterest ("set_renderKey__", this);
      browser .getBrowserOptions () ._OrderIndependentTransparency .addInterest ("set_renderKey__", this);
      browser .getBrowserOptions () ._ToneMapping                  .addInterest ("set_renderKey__", this);

      this .getViewpointStack ()  .addInterest ("set_renderKey__", this);

      this .set_renderKey__ ();
   },
   isIndependent ()
   {
      return true;
   },
   set_renderKey__ ()
   {
      const browser = this .getBrowser ();

      this .logarithmicDepthBuffer       = browser .getRenderingProperty ("LogarithmicDepthBuffer")
         || this .getViewpoint () .getLogarithmicDepthBuffer ();
      this .orderIndependentTransparency = browser .getBrowserOption ("OrderIndependentTransparency");

      let renderKey = "";

      renderKey += browser .getRenderingProperty ("Shading") === "FLAT" ? 1 : 0;
      renderKey += browser .getRenderingProperty ("XRSession")          ? 1 : 0;
      renderKey += this .logarithmicDepthBuffer                         ? 1 : 0;
      renderKey += this .orderIndependentTransparency                   ? 1 : 0;

      switch (browser .getBrowserOption ("ColorSpace"))
      {
         case "SRGB":
            renderKey += 0;
            break;
         default: // LINEAR_WHEN_PHYSICAL_MATERIAL
            renderKey += 1;
            break;
         case "LINEAR":
            renderKey += 2;
            break;
      }

      switch (browser .getBrowserOption ("ToneMapping"))
      {
         default: // NONE
            renderKey += 0;
            break;
         case "ACES_NARKOWICZ":
            renderKey += 1;
            break;
         case "ACES_HILL":
            renderKey += 2;
            break;
         case "ACES_HILL_EXPOSURE_BOOST":
            renderKey += 3;
            break;
         case "KHR_PBR_NEUTRAL":
            renderKey += 4;
            break;
      }

      this .partialRenderKey = renderKey;
   },
   getLogarithmicDepthBuffer ()
   {
      return this .logarithmicDepthBuffer;
   },
   getOrderIndependentTransparency ()
   {
      return this .orderIndependentTransparency;
   },
   getRenderKey ()
   {
      return this .renderKey;
   },
   getRenderCount ()
   {
      return this .renderCount;
   },
   advanceRenderCount: (() =>
   {
      let renderCount = 0;

      return function ()
      {
         if (renderCount === Number .MAX_SAFE_INTEGER)
            renderCount = 0;

         this .renderCount = ++ renderCount;
      }
   })(),
   getFramebuffers ()
   {
      return this .getBrowser () .getFramebuffers ();
   },
   getView ()
   {
      return this .view;
   },
   getViewVolumes ()
   {
      return this .viewVolumes;
   },
   getViewVolume ()
   {
      return this .viewVolumes .at (-1);
   },
   getProjectionMatrix ()
   {
      return this .projectionMatrix;
   },
   getProjectionMatrixWithLimits (nearValue, farValue, viewport)
   {
      return this .getViewpoint () .getProjectionMatrixWithLimits (nearValue, farValue, viewport);
   },
   getModelViewMatrix ()
   {
      return this .modelViewMatrix;
   },
   getViewMatrix ()
   {
      return this .viewMatrix;
   },
   getCameraSpaceMatrix ()
   {
      return this .cameraSpaceMatrix;
   },
   getViewportArray ()
   {
      return this .viewportArray;
   },
   getProjectionMatrixArray ()
   {
      return this .projectionMatrixArray;
   },
   getEyeMatrixArray ()
   {
      return this .eyeMatrixArray;
   },
   getViewMatrixArray ()
   {
      return this .viewMatrixArray;
   },
   getCameraSpaceMatrixArray ()
   {
      return this .cameraSpaceMatrixArray;
   },
   getHitRay ()
   {
      return this .hitRay;
   },
   getSensors ()
   {
      return this .sensors;
   },
   getViewpointGroups ()
   {
      return this .viewpointGroups;
   },
   getLights ()
   {
      return this .lights;
   },
   getGlobalLights ()
   {
      return this .globalLights;
   },
   getGlobalLightsKeys ()
   {
      return this .globalLightsKeys;
   },
   getLocalObjects ()
   {
      return this .localObjects;
   },
   getLocalObjectsKeys ()
   {
      return this .localObjectsKeys;
   },
   pushGlobalShadows (value)
   {
      this .globalShadows .push (value || this .globalShadows .at (-1));
   },
   getGlobalShadows ()
   {
      return this .globalShadows;
   },
   getGlobalShadow ()
   {
      return this .globalShadow;
   },
   pushLocalShadows (value)
   {
      this .localShadows .push (value || this .localShadows .at (-1));
   },
   popLocalShadows ()
   {
      this .localShadows .pop ();
   },
   setGlobalFog: (() =>
   {
      const modelViewMatrix = new Matrix4/* default */.A ();

      return function (fogNode)
      {
         if (fogNode .getFogType ())
         {
            const fogContainer = this .localFogs [0] || fogNode .getFogs () .pop ();

            modelViewMatrix .assign (fogNode .getModelMatrix ()) .multRight (this .getViewMatrix () .get ());
            fogContainer .set (fogNode, modelViewMatrix);

            this .localFogs [0] = fogContainer;
         }
         else
         {
            this .localFogs [0] = null;
         }
      };
   })(),
   getLocalFogs ()
   {
      return this .localFogs;
   },
   getLayouts ()
   {
      return this .layouts;
   },
   getParentLayout ()
   {
      return this .layouts .at (-1);
   },
   getHAnimNode ()
   {
      return this .hAnimNode;
   },
   getInvHumanoidMatrix ()
   {
      return this .invHumanoidMatrix;
   },
   getGeneratedCubeMapTextures ()
   {
      return this .generatedCubeMapTextures;
   },
   getCollisions ()
   {
      return this .collisions;
   },
   getCollisionTime ()
   {
      return this .collisionTime;
   },
   getNumPointingShapes ()
   {
      return this .numPointingShapes;
   },
   getPointingShapes ()
   {
      return this .pointingShapes;
   },
   getNumCollisionShapes ()
   {
      return this .numCollisionShapes;
   },
   getCollisionShapes ()
   {
      return this .collisionShapes;
   },
   getNumShadowShapes ()
   {
      return this .numShadowShapes;
   },
   getShadowShapes ()
   {
      return this .shadowShapes;
   },
   getNumOpaqueShapes ()
   {
      return this .numOpaqueShapes;
   },
   getOpaqueShapes ()
   {
      return this .opaqueShapes;
   },
   getNumTransparentShapes ()
   {
      return this .numTransparentShapes;
   },
   getTransparentShapes ()
   {
      return this .transparentShapes;
   },
   getRenderPass ()
   {
      return this .renderPass;
   },
   constrainTranslation: (() =>
   {
      const
         plane       = new Plane3/* default */.A (),
         point       = new Vector3/* default */.A (),
         closest     = new Vector3/* default */.A (),
         constrained = new Vector3/* default */.A ();

      return function (translation, stepBack = true, slide = true)
      {
         // Constrains a *translation*, which should be added to viewpoint position to a possible value that avatar can move to. If the avatar reaches or intersects with an obstacle the translation is either constrained to slide along the wall or to stop.

         // Constrain translation when the viewer collides with an obstacle.

         const
            closestObject   = this .getClosestObject (translation),
            collisionRadius = this .getNavigationInfo () .getCollisionRadius (),
            distance        = closestObject .distance - collisionRadius;

         if (distance > 0)
         {
            // Move.

            const length = translation .norm ();

            if (length > distance)
            {
               // Collision, the avatar would intersect with the obstacle.
               // Slide along normal plane.

               point .assign (translation) .normalize () .multiply (distance);

               if (!slide)
                  return point;

               const wallFriction = Algorithm/* default */.A .clamp (this .getBrowser () .getBrowserOption ("WallFriction"), 0, 1);

               // Project translation on normal plane.
               plane .set (point, closestObject .normal);
               plane .getClosestPointToPoint (translation, closest);

               // Project translation on up-vector plane.
               plane .set (Vector3/* default */.A .ZERO, this .getViewpoint () .getUpVector ());
               plane .getClosestPointToPoint (closest, constrained);

               // Adjust length.
               constrained .subtract (point) .normalize () .multiply (length * (1 - wallFriction));

               return this .constrainTranslation (constrained, false, false);
            }

            // Everything is fine.

            return translation;
         }

         // Collision, the avatar is already within an obstacle.

         if (stepBack)
         {
            point .assign (translation) .normalize () .multiply (distance);

            return this .constrainTranslation (point, false, false);
         }

         return translation .assign (Vector3/* default */.A .ZERO);
      };
   })(),
   getClosestObject: (() =>
   {
      const
         projectionMatrix     = new Matrix4/* default */.A (),
         viewProjectionMatrix = new Matrix4/* default */.A (),
         viewMatrix           = new Matrix4/* default */.A (),
         localOrientation     = new Rotation4/* default */.A (),
         rotation             = new Rotation4/* default */.A ();

      return function (direction)
      {
         ///  Returns the distance to the closest object in @a direction.  The maximum determinable value is avatarHeight * 2.

         this .collisionTime .start ();

         const
            navigationInfoNode = this .getNavigationInfo (),
            viewpointNode      = this .getViewpoint (),
            collisionRadius    = navigationInfoNode .getCollisionRadius (),
            bottom             = navigationInfoNode .getStepHeight () - navigationInfoNode .getAvatarHeight (),
            nearValue          = viewpointNode .getNearDistance (navigationInfoNode),
            avatarHeight       = navigationInfoNode .getAvatarHeight ();

         // Determine width and height of camera

         // Reshape camera

         Camera/* default */.A .ortho (-collisionRadius,
                        collisionRadius,
                        Math .min (bottom, -collisionRadius), /// TODO: bottom could be a positive value if stepHeight > avatarHeight.
                        collisionRadius,
                        nearValue,
                        Math .max (collisionRadius * 2, avatarHeight * 2),
                        projectionMatrix);

         // Translate camera to user position and to look in the direction of the direction.

         localOrientation
            .assign (viewpointNode ._orientation .getValue ())
            .inverse ()
            .multRight (viewpointNode .getOrientation ());

         rotation
            .setFromToVec (Vector3/* default */.A .NEGATIVE_Z_AXIS, direction)
            .multRight (localOrientation);

         viewpointNode .straightenHorizon (rotation);

         viewMatrix
            .assign (viewpointNode .getModelMatrix ())
            .translate (viewpointNode .getUserPosition ())
            .rotate (rotation)
            .inverse ()
            .multLeft (viewpointNode .getCameraSpaceMatrix ());

         viewProjectionMatrix
            .assign (viewMatrix)
            .multRight (projectionMatrix);

         this .getProjectionMatrix () .push (viewProjectionMatrix);

         const closestObject = this .getCollisionShape (projectionMatrix);

         closestObject .modelViewMatrix .multRight (viewMatrix) .submatrix
            .inverse () .multMatrixVec (closestObject .normal);

         rotation .multVecRot (closestObject .normal) .normalize ();

         this .getProjectionMatrix () .pop ();

         this .collisionTime .stop ();

         return closestObject;
      };
   })(),
   getCollisionShape: (() =>
   {
      const
         depthBufferViewport   = new Vector4/* default */.A (0, 0, DEPTH_BUFFER_SIZE, DEPTH_BUFFER_SIZE),
         depthBufferViewVolume = new ViewVolume/* default */.A (Matrix4/* default */.A .IDENTITY, depthBufferViewport),
         result                = { id: -1, distance: 0, normal: new Vector3/* default */.A (), modelViewMatrix: new Matrix4/* default */.A () };

      return function (projectionMatrix)
      {
         // Returns the depth value to the closest object.
         // The maximum determinable value is avatarHeight * 2.

         this .depthBuffer .bind ();
         this .viewVolumes .push (depthBufferViewVolume);

         this .depth (this .collisionShapes, this .numCollisionShapes, true);

         const depth = this .depthBuffer .readDepth (projectionMatrix, depthBufferViewport, result);

         this .viewVolumes .pop ();

         if (depth .id < 0)
         {
            depth .node = null;
         }
         else
         {
            const renderContext = this .collisionShapes [depth .id];

            depth .node = renderContext .shapeNode;
            depth .modelViewMatrix .assign (renderContext .modelViewMatrix);
         }

         return depth;
      };
   })(),
   render (type, callback, group)
   {
      switch (type)
      {
         case TraverseType/* default */.A .POINTER:
         {
            this .numPointingShapes = 0;

            callback .call (group, type, this);
            this .pointing (this .pointingShapes, this .numPointingShapes);
            break;
         }
         case TraverseType/* default */.A .COLLISION:
         {
            // Collect for collide and gravitate
            this .numCollisionShapes = 0;

            callback .call (group, type, this);
            this .collide ();
            this .gravitate ();
            break;
         }
         case TraverseType/* default */.A .SHADOW:
         {
            this .numShadowShapes = 0;

            callback .call (group, type, this);
            this .depth (this .shadowShapes, this .numShadowShapes, false);
            break;
         }
         case TraverseType/* default */.A .DISPLAY:
         {
            this .lightIndex           = 0;
            this .renderPasses         = 0;
            this .numOpaqueShapes      = 0;
            this .numTransparentShapes = 0;

            this .setGlobalFog (this .getFog ());

            callback .call (group, type, this);
            this .draw ();
            break;
         }
      }
   },
   setHitRay (projectionMatrix, viewport, pointer)
   {
      ViewVolume/* default */.A .unProjectRay (pointer .x, pointer .y, Matrix4/* default */.A .IDENTITY, projectionMatrix, viewport, this .hitRay);
   },
   addPointingShape: (() =>
   {
      const
         bboxSize   = new Vector3/* default */.A (),
         bboxCenter = new Vector3/* default */.A ();

      return function (shapeNode)
      {
         const modelViewMatrix = this .getModelViewMatrix () .get ();

         modelViewMatrix .multDirMatrix (bboxSize   .assign (shapeNode .getBBoxSize ()));
         modelViewMatrix .multVecMatrix (bboxCenter .assign (shapeNode .getBBoxCenter ()));

         const
            radius     = bboxSize .norm () / 2,
            viewVolume = this .viewVolumes .at (-1);

         if (!viewVolume .intersectsSphere (radius, bboxCenter))
            return false;

         const num = this .numPointingShapes ++;

         if (num === this .pointingShapes .length)
         {
            const renderContext = {
               renderObject: this,
               modelViewMatrix: new Float32Array (16),
               viewport: new Vector4/* default */.A (),
               clipPlanes: [ ],
               sensors: [ ],
               get renderContext () { return this; },
            };

            this .pointingShapes .push (renderContext);
         }

         const renderContext = this .pointingShapes [num];

         renderContext .modelViewMatrix .set (modelViewMatrix);
         renderContext .viewport .assign (viewVolume .getViewport ());
         renderContext .hAnimNode = this .hAnimNode .at (-1);
         renderContext .shapeNode = shapeNode;

         // Clip planes & sensors

         X3DRenderObject_assign (renderContext .clipPlanes, this .localObjects);
         X3DRenderObject_assign (renderContext .sensors,    this .sensors .at (-1));

         return true;
      };
   })(),
   addCollisionShape: (() =>
   {
      const
         bboxSize   = new Vector3/* default */.A (),
         bboxCenter = new Vector3/* default */.A ();

      return function (shapeNode)
      {
         const modelViewMatrix = this .getModelViewMatrix () .get ();

         modelViewMatrix .multDirMatrix (bboxSize   .assign (shapeNode .getBBoxSize ()));
         modelViewMatrix .multVecMatrix (bboxCenter .assign (shapeNode .getBBoxCenter ()));

         const
            radius     = bboxSize .norm () / 2,
            viewVolume = this .viewVolumes .at (-1);

         if (!viewVolume .intersectsSphere (radius, bboxCenter))
            return false;

         const num = this .numCollisionShapes ++;

         if (num === this .collisionShapes .length)
         {
            const renderContext = {
               renderObject: this,
               modelViewMatrix: new Float32Array (16),
               collisions: [ ],
               clipPlanes: [ ],
               get renderContext () { return this; },
            };

            this .collisionShapes .push (renderContext);
         }

         const renderContext = this .collisionShapes [num];

         renderContext .modelViewMatrix .set (modelViewMatrix);
         renderContext .hAnimNode = this .hAnimNode .at (-1);
         renderContext .shapeNode = shapeNode;

         // Clip planes & Collision nodes

         X3DRenderObject_assign (renderContext .clipPlanes, this .localObjects);
         X3DRenderObject_assign (renderContext .collisions, this .collisions);

         return true;
      };
   })(),
   addShadowShape: (() =>
   {
      const
         bboxSize   = new Vector3/* default */.A (),
         bboxCenter = new Vector3/* default */.A ();

      return function (shapeNode)
      {
         const modelViewMatrix = this .getModelViewMatrix () .get ();

         modelViewMatrix .multDirMatrix (bboxSize   .assign (shapeNode .getBBoxSize ()));
         modelViewMatrix .multVecMatrix (bboxCenter .assign (shapeNode .getBBoxCenter ()));

         const
            radius     = bboxSize .norm () / 2,
            viewVolume = this .viewVolumes .at (-1);

         if (!viewVolume .intersectsSphere (radius, bboxCenter))
            return false;

         const num = this .numShadowShapes ++;

         if (num === this .shadowShapes .length)
         {
            const renderContext = {
               renderObject: this,
               modelViewMatrix: new Float32Array (16),
               viewport: new Vector4/* default */.A (),
               clipPlanes: [ ],
               get renderContext () { return this; },
            };

            this .shadowShapes .push (renderContext);
         }

         const renderContext = this .shadowShapes [num];

         renderContext .modelViewMatrix .set (modelViewMatrix);
         renderContext .viewport .assign (viewVolume .getViewport ());
         renderContext .hAnimNode = this .hAnimNode .at (-1);
         renderContext .shapeNode = shapeNode;

         // Clip planes

         X3DRenderObject_assign (renderContext .clipPlanes, this .localObjects);

         return true;
      };
   })(),
   addDisplayShape: (() =>
   {
      const
         bboxSize   = new Vector3/* default */.A (),
         bboxCenter = new Vector3/* default */.A ();

      return function (shapeNode)
      {
         const modelViewMatrix = this .getModelViewMatrix () .get ();

         modelViewMatrix .multDirMatrix (bboxSize   .assign (shapeNode .getBBoxSize ()));
         modelViewMatrix .multVecMatrix (bboxCenter .assign (shapeNode .getBBoxCenter ()));

         const
            radius     = bboxSize .norm () / 2,
            viewVolume = this .viewVolumes .at (-1);

         if (!viewVolume .intersectsSphere (radius, bboxCenter))
            return false;

         let renderContext;

         if (shapeNode .isTransparent ())
         {
            const num = this .numTransparentShapes ++;

            if (num === this .transparentShapes .length)
               this .transparentShapes .push (this .createRenderContext (true));

            renderContext = this .transparentShapes [num];

            renderContext .distance = bboxCenter .z;
         }
         else
         {
            const num = this .numOpaqueShapes ++;

            if (num === this .opaqueShapes .length)
               this .opaqueShapes .push (this .createRenderContext (false));

            renderContext = this .opaqueShapes [num];
         }

         this .renderPasses |= shapeNode .getRenderPasses ();

         renderContext .modelViewMatrix .set (modelViewMatrix);
         renderContext .viewport .assign (viewVolume .getViewport ());

         renderContext .shadows        = this .localShadows .at (-1);
         renderContext .fogNode        = this .localFogs .at (-1);
         renderContext .hAnimNode      = this .hAnimNode .at (-1);
         renderContext .shapeNode      = shapeNode;
         renderContext .appearanceNode = shapeNode .getAppearance ();

         // Clip planes and local lights

         X3DRenderObject_assign (renderContext .localObjects,     this .localObjects); // ClipPane, X3DLightNode
         X3DRenderObject_assign (renderContext .localObjectsKeys, this .localObjectsKeys);

         return true;
      };
   })(),
   createRenderContext (transparent)
   {
      return {
         renderObject: this,
         transparent: transparent,
         modelViewMatrix: new Float32Array (16),
         viewport: new Vector4/* default */.A (),
         localObjects: [ ],
         localObjectsKeys: [ ], // [clip planes, lights]
         get renderContext () { return this; },
      };
   },
   pointing: (() =>
   {
      const projectionMatrixArray = new Float32Array (16);

      return function (shapes, numShapes)
      {
         const
            browser  = this .getBrowser (),
            gl       = browser .getContext (),
            viewport = this .viewVolumes .at (-1) .getViewport (),
            { x, y } = browser .getPointer ();

         // Configure depth shaders.

         projectionMatrixArray .set (this .getProjectionMatrix () .get ());

         // Configure viewport and background.

         gl .viewport (viewport .x - x,
                       viewport .y - y,
                       viewport .z,
                       viewport .w);

         gl .scissor (0, 0, 1, 1);
         gl .clear (gl .DEPTH_BUFFER_BIT);

         // Render all objects.

         gl .disable (gl .CULL_FACE);

         for (let s = 0; s < numShapes; ++ s)
         {
            const
               { renderContext, modelViewMatrix, viewport, shapeNode, hAnimNode, clipPlanes } = shapes [s],
               appearanceNode      = shapeNode .getAppearance (),
               geometryContext     = shapeNode .getGeometryContext (),
               depthModeNode       = appearanceNode .getDepthMode (),
               stylePropertiesNode = appearanceNode .getStyleProperties (geometryContext .geometryType),
               shaderNode          = browser .getPointingShader (clipPlanes .length, shapeNode, hAnimNode),
               id                  = browser .addPointingShape (renderContext);

            gl .viewport (viewport .x - x,
                          viewport .y - y,
                          viewport .z,
                          viewport .w);

            // Draw shape.

            shaderNode .enable (gl);
            shaderNode .setClipPlanes (gl, clipPlanes);

            gl .uniformMatrix4fv (shaderNode .x3d_ProjectionMatrix, false, projectionMatrixArray);
            gl .uniformMatrix4fv (shaderNode .x3d_ModelViewMatrix,  false, modelViewMatrix);
            gl .uniform1f (shaderNode .x3d_Id, id);

            depthModeNode       ?.enable (gl);
            stylePropertiesNode ?.setShaderUniforms (gl, shaderNode);
            hAnimNode           ?.setShaderUniforms (gl, shaderNode);

            shapeNode .displaySimple (gl, renderContext, shaderNode);

            depthModeNode ?.disable (gl);
            browser .resetTextureUnits ();
         }
      };
   })(),
   collide: (() =>
   {
      const axes = [
         Vector3/* default */.A .X_AXIS,
         Vector3/* default */.A .Y_AXIS,
         Vector3/* default */.A .Z_AXIS,
         Vector3/* default */.A .NEGATIVE_X_AXIS,
         Vector3/* default */.A .NEGATIVE_Y_AXIS,
         Vector3/* default */.A .NEGATIVE_Z_AXIS,
      ];

      const
         closestShapes    = new Set (),
         activeCollisions = [ ]; // current active Collision nodes

      return function ()
      {
         const browser = this .getBrowser ();

         // Check if there are enabled Collision nodes.
         if (!browser .getCollisionCount ())
            return;

         // Collision nodes are handled here.

         const collisionRadius = this .getNavigationInfo () .getCollisionRadius () * Math .SQRT2;

         if (this .numCollisionShapes)
         {
            for (const axis of axes)
            {
               const closestObject = this .getClosestObject (axis);

               if (closestObject .id < 0)
                  continue;

               if (closestObject .distance > collisionRadius)
                  continue;

               closestShapes .add (closestObject .id);
            }

            for (const i of closestShapes)
            {
               const { collisions } = this .collisionShapes [i];

               for (const collision of collisions)
                  activeCollisions .push (collision);
            }

            closestShapes .clear ();
         }

         // Set isActive to FALSE for affected nodes.

         for (const collision of this .activeCollisions)
         {
            if (activeCollisions .includes (collision))
               continue;

            collision .set_active__ (false);
         }

         // Set isActive to TRUE for affected nodes.

         for (const collision of activeCollisions)
            collision .set_active__ (true);

         X3DRenderObject_assign (this .activeCollisions, activeCollisions);

         activeCollisions .length = 0;
      };
   })(),
   gravitate: (() =>
   {
      const
         projectionMatrix     = new Matrix4/* default */.A (),
         viewProjectionMatrix = new Matrix4/* default */.A (),
         translation          = new Vector3/* default */.A (),
         rotation             = new Rotation4/* default */.A ();

      return function ()
      {
         const browser = this .getBrowser ();

         // Terrain following and gravitation.

         if (browser .getActiveLayer () === this)
         {
            if (browser .getCurrentViewer () !== "WALK")
               return;
         }
         else
         {
            return;
         }

         // Get NavigationInfo values.

         const
            navigationInfoNode = this .getNavigationInfo (),
            viewpointNode      = this .getViewpoint (),
            collisionRadius    = navigationInfoNode .getCollisionRadius (),
            avatarHeight       = navigationInfoNode .getAvatarHeight (),
            stepHeight         = navigationInfoNode .getStepHeight (),
            nearValue          = viewpointNode .getNearDistance (navigationInfoNode);

         // Reshape viewpoint for gravitate.

         Camera/* default */.A .ortho (-collisionRadius,
                        collisionRadius,
                        -collisionRadius,
                        collisionRadius,
                        nearValue,
                        Math .max (collisionRadius, avatarHeight) * 2,
                        projectionMatrix);

         // Transform viewpoint to look down the up vector.

         const
            upVector = viewpointNode .getUpVector (),
            down     = rotation .setFromToVec (Vector3/* default */.A .Z_AXIS, upVector);

         viewProjectionMatrix
            .assign (viewpointNode .getModelMatrix ())
            .translate (viewpointNode .getUserPosition ())
            .rotate (down)
            .inverse ()
            .multRight (projectionMatrix)
            .multLeft (viewpointNode .getCameraSpaceMatrix ());

         this .getProjectionMatrix () .push (viewProjectionMatrix);

         const depth = this .getCollisionShape (projectionMatrix);

         let distance = depth .distance;

         this .getProjectionMatrix () .pop ();

         // gravitate or step up.

         distance -= avatarHeight;

         const up = rotation .setFromToVec (Vector3/* default */.A .Y_AXIS, upVector);

         if (distance > 0)
         {
            // Gravitate and fall down the to the floor.

            const currentFrameRate = this .speed ? browser .getCurrentFrameRate () : 1000000;

            this .speed -= browser .getBrowserOptions () ._Gravity .getValue () / currentFrameRate;

            let dy = this .speed / currentFrameRate;

            if (dy < -distance)
            {
               // The ground has been reached.

               dy = -distance;

               this .speed = 0;
            }

            const falling = up .multVecRot (translation .set (0, dy, 0));

            viewpointNode ._positionOffset = falling .add (viewpointNode ._positionOffset .getValue ());
         }
         else
         {
            this .speed = 0;

            distance = -distance;

            if (distance > 0.01 && distance < stepHeight)
            {
               // Step up.

               const step = up .multVecRot (translation .set (0, distance, 0));

               viewpointNode ._positionOffset = step .add (viewpointNode ._positionOffset .getValue ());
            }
         }
      };
   })(),
   depth: (() =>
   {
      const projectionMatrixArray = new Float32Array (16);

      return function (shapes, numShapes, normal)
      {
         const
            browser  = this .getBrowser (),
            gl       = browser .getContext (),
            viewport = this .viewVolumes .at (-1) .getViewport ();

         // Configure depth shaders.

         projectionMatrixArray .set (this .getProjectionMatrix () .get ());

         // Configure viewport and background

         gl .viewport (... viewport);
         gl .scissor (... viewport);

         gl .clearColor (1, -1, -1, -1); // '1' for infinity, '-1' for no hit.
         gl .clear (gl .COLOR_BUFFER_BIT | gl .DEPTH_BUFFER_BIT);

         // Render all objects

         gl .disable (gl .CULL_FACE);

         for (let s = 0; s < numShapes; ++ s)
         {
            const
               { renderContext, clipPlanes, modelViewMatrix, shapeNode, hAnimNode } = shapes [s],
               appearanceNode      = shapeNode .getAppearance (),
               geometryContext     = shapeNode .getGeometryContext (),
               stylePropertiesNode = appearanceNode .getStyleProperties (geometryContext .geometryType),
               shaderNode          = browser .getDepthShader (normal, clipPlanes .length, shapeNode, hAnimNode);

            // Cannot change viewport here, because the viewport is special here.

            // Draw

            shaderNode .enable (gl);
            shaderNode .setClipPlanes (gl, clipPlanes);

            gl .uniform1i (shaderNode .x3d_Id, s);
            gl .uniformMatrix4fv (shaderNode .x3d_ProjectionMatrix, false, projectionMatrixArray);
            gl .uniformMatrix4fv (shaderNode .x3d_ModelViewMatrix,  false, modelViewMatrix);

            stylePropertiesNode ?.setShaderUniforms (gl, shaderNode);
            hAnimNode           ?.setShaderUniforms (gl, shaderNode);

            shapeNode .displaySimple (gl, renderContext, shaderNode);
            browser .resetTextureUnits ();
         }
      };
   })(),
   draw ()
   {
      const
         independent              = this .isIndependent (),
         browser                  = this .getBrowser (),
         gl                       = browser .getContext (),
         pose                     = browser .getPose (),
         framebuffers             = this .getFramebuffers (),
         numFramebuffers          = framebuffers .length,
         viewport                 = this .viewVolumes .at (-1) .getViewport (),
         lights                   = this .lights,
         globalLightsKeys         = this .globalLightsKeys,
         globalLightsKey          = globalLightsKeys .join (""),
         globalLights             = this .globalLights,
         generatedCubeMapTextures = this .generatedCubeMapTextures,
         globalShadows            = this .globalShadows,
         headlight                = this .getNavigationInfo () ._headlight .getValue ();

      // PREPARATIONS

      // Set matrices.

      this .viewportArray          .set (viewport);
      this .viewMatrixArray        .set (this .getViewMatrix () .get ());
      this .cameraSpaceMatrixArray .set (this .getCameraSpaceMatrix () .get ());

      if (independent)
      {
         // Render shadow maps and prepare texture projectors.

         for (const light of lights)
            light .renderShadowMap (this);

         // Render GeneratedCubeMapTexture nodes.

         for (const generatedCubeMapTexture of generatedCubeMapTextures)
            generatedCubeMapTexture .renderTexture (this);
      }

      this .globalShadow = globalShadows .at (-1);

      // DRAW

      // Sort transparent shapes.

      if (!this .orderIndependentTransparency)
      {
         const { numTransparentShapes, transparencySorter } = this;

         transparencySorter .sort (0, numTransparentShapes);
      }

      // Draw to all framebuffers.

      for (let i = 0; i < numFramebuffers; ++ i)
      {
         this .advanceRenderCount ();

         // Set matrices with XR support.

         const view = this .view = pose ?.views [i];

         if (view)
         {
            this .projectionMatrixArray .set (view .projectionMatrix);
            this .eyeMatrixArray        .set (view .matrix);
         }
         else
         {
            this .projectionMatrixArray .set (this .getProjectionMatrix () .get ());
            this .eyeMatrixArray        .set (Matrix4/* default */.A .IDENTITY);
         }

         // Set up shadow matrix for all lights, and matrices for all projective textures.

         if (headlight)
            browser .getHeadlight () .setGlobalVariables (this);

         for (const light of lights)
            light .setGlobalVariables (this);

         // Render transmission texture and volume scatter texture.

         if (this .renderPasses !== RenderPass/* default */.A .NONE)
         {
            // Render to volume scatter buffer.

            if (this .renderPasses & RenderPass/* default */.A .VOLUME_SCATTER_BIT)
            {
               browser .resetShapeId ();

               this .renderPass = RenderPass/* default */.A .VOLUME_SCATTER_KEY;
               this .renderKey  = `.${this .partialRenderKey}.${this .renderPass}.${globalLightsKey}.`;

               const volumeScatterBuffer = browser .getVolumeScatterBuffer ();

               this .drawShapes (RenderPass/* default */.A .VOLUME_SCATTER_KEY, gl, volumeScatterBuffer, gl .COLOR_BUFFER_BIT, viewport);
            }

            // Render to transmission buffer.

            if (this .renderPasses & RenderPass/* default */.A .TRANSMISSION_BIT)
            {
               this .renderPass = RenderPass/* default */.A .TRANSMISSION_KEY;
               this .renderKey  = `.${this .partialRenderKey}.${this .renderPass}.${globalLightsKey}.`;

               const transmissionBuffer = browser .getTransmissionBuffer ();

               this .drawShapes (RenderPass/* default */.A .TRANSMISSION_KEY, gl, transmissionBuffer, gl .COLOR_BUFFER_BIT, viewport);

               // Mipmap is later selected based on roughness and ior.
               gl .bindTexture (gl .TEXTURE_2D, transmissionBuffer .getColorTexture ());
               gl .generateMipmap (gl .TEXTURE_2D);
            }
         }

         // Draw with sorted blend or OIT.

         this .renderPass = RenderPass/* default */.A .RENDER_KEY;
         this .renderKey  = `.${this .partialRenderKey}.${this .renderPass}.${globalLightsKey}.`;

         const frameBuffer = framebuffers [i];

         this .drawShapes (RenderPass/* default */.A .RENDER_KEY, gl, frameBuffer, 0, viewport);
      }

      this .view = null;

      // POST DRAW

      if (independent)
      {
         // Recycle clip planes, local fogs, local lights, and local projective textures.

         const localObjects = browser .getLocalObjects ();

         for (const localObject of localObjects)
            localObject .dispose ();

         localObjects .length = 0;

         // Recycle global lights and global projective textures.

         for (const globalObject of globalLights)
            globalObject .dispose ();

         browser .resetGlobalTextureUnits ();
      }

      // Reset containers.

      globalLightsKeys .length = 0;
      globalLights     .length = 0;
      lights           .length = 0;
      globalShadows    .length = 1;

      generatedCubeMapTextures .clear ();
   },
   drawShapes (renderPass, gl, frameBuffer, clearBits, viewport)
   {
      const { opaqueShapes, numOpaqueShapes, transparentShapes, numTransparentShapes } = this;

      frameBuffer .bind ();

      // Configure viewport and background.

      gl .viewport (... viewport);
      gl .scissor (... viewport);

      // Draw background.

      gl .clearColor (0, 0, 0, 0);
      gl .clear (gl .DEPTH_BUFFER_BIT | clearBits);
      gl .blendFuncSeparate (gl .SRC_ALPHA, gl .ONE_MINUS_SRC_ALPHA, gl .ONE, gl .ONE_MINUS_SRC_ALPHA);

      this .getBackground () [renderPass] ?.display (gl, this);

      // Use sorted blend or order independent transparency.
      // Render opaque objects first.

      for (let i = 0; i < numOpaqueShapes; ++ i)
      {
         const { renderContext, shapeNode } = opaqueShapes [i];

         shapeNode [renderPass] ?.display (gl, renderContext);
      }

      // Render transparent objects.

      if (frameBuffer .getOIT ())
         frameBuffer .bindTransparency ();

      gl .depthMask (false);
      gl .enable (gl .BLEND);

      for (let i = 0; i < numTransparentShapes; ++ i)
      {
         const { renderContext, shapeNode } = transparentShapes [i];

         shapeNode [renderPass] ?.display (gl, renderContext);
      }

      gl .depthMask (true);
      gl .disable (gl .BLEND);

      if (frameBuffer .getOIT ())
         frameBuffer .compose ();
   },
});

function X3DRenderObject_assign (lhs, rhs)
{
   const length = rhs .length;

   for (let i = 0; i < length; ++ i)
      lhs [i] = rhs [i];

   lhs .length = length;
}

const X3DRenderObject_default_ = X3DRenderObject;
;

/* harmony default export */ const Rendering_X3DRenderObject = (Namespace/* default */.A .add ("X3DRenderObject", X3DRenderObject_default_));
// EXTERNAL MODULE: ./src/x_ite/Base/X3DBaseNode.js + 1 modules
var X3DBaseNode = __webpack_require__(2188);
;// ./src/x_ite/Execution/BindableStack.js


function BindableStack (executionContext, defaultNode)
{
   X3DBaseNode/* default */.A .call (this, executionContext);

   this .nodes = [ defaultNode ];
}

Object .assign (Object .setPrototypeOf (BindableStack .prototype, X3DBaseNode/* default */.A .prototype),
{
   get ()
   {
      return this .nodes;
   },
   top ()
   {
      return this .nodes .at (-1);
   },
   pushOnTop (node)
   {
      if (node !== this .nodes [0])
      {
         this .nodes .at (-1) ._isBound = false;
         this .nodes .push (node);
      }

      // Don't do set_bind.
      node ._isBound  = true;
      node ._bindTime = this .getBrowser () .getCurrentTime ();

      this .addNodeEvent ();
   },
   update (layerNode, removedNodes, changedNodes)
   {
      if (!removedNodes .length && !changedNodes .length)
         return;

      // Save top node for later use.

      const
         fromNode  = this .top (),
         boundNode = this .nodes .at (-1);

      // Remove invisible nodes and unbind them if needed.

      for (const removedNode of removedNodes)
      {
         const index = this .nodes .indexOf (removedNode);

         if (index > 0)
            this .nodes .splice (index, 1);
      }

      // Unbind nodes with set_bind false and pop top node.

      if (boundNode !== this .nodes [0])
      {
         if (changedNodes .some (node => !node ._set_bind .getValue () && node === boundNode))
         {
            this .nodes .pop ();
         }
      }

      // Push nodes with set_bind true to top of stack.

      for (const bindNode of changedNodes)
      {
         if (!bindNode ._set_bind .getValue ())
            continue;

         const index = this .nodes .indexOf (bindNode);

         if (index > -1)
            this .nodes .splice (index, 1);

         this .nodes .push (bindNode);
      }

      // Bind top node if not bound.

      const top = this .nodes .at (-1);

      if (top !== boundNode)
      {
         // First unbind last bound node.

         boundNode ._isBound = false;

         // Now bind new top node.

         top ._isBound  = true;
         top ._bindTime = this .getBrowser () .getCurrentTime ();

         // Do transition.

         top .transitionStart (layerNode, fromNode);
      }
      else
      {
         // Do transition.

         if (changedNodes .includes (top))
            top .transitionStart (layerNode, fromNode);
      }

      this .addNodeEvent ();
   },
});

for (const key of Object .keys (BindableStack .prototype))
   Object .defineProperty (BindableStack .prototype, key, { enumerable: false });

Object .defineProperties (BindableStack,
{
   typeName:
   {
      value: "BindableStack",
      enumerable: true,
   },
});

const BindableStack_default_ = BindableStack;
;

/* harmony default export */ const Execution_BindableStack = (Namespace/* default */.A .add ("BindableStack", BindableStack_default_));
// EXTERNAL MODULE: ./src/x_ite/Components/Core/X3DBindableNode.js
var X3DBindableNode = __webpack_require__(532);
;// ./src/x_ite/Execution/BindableList.js



function BindableList (executionContext, defaultNode)
{
   X3DBaseNode/* default */.A .call (this, executionContext);

   this .modificationCount = 0;
   this .nodes             = [ defaultNode ];
   this .collectedNodes    = [ defaultNode ];
   this .changedNodes      = [ ];
   this .removedNodes      = [ ];
}

Object .assign (Object .setPrototypeOf (BindableList .prototype, X3DBaseNode/* default */.A .prototype),
{
   get ()
   {
      return this .nodes;
   },
   getBound (name)
   {
      const length = this .nodes .length;

      if (length === 1)
         return this .nodes [0]; // Return default viewpoint.

      const enableInlineBindables = false;

      if (name)
      {
         // Return first viewpoint with @name.

         for (let i = 1; i < length; ++ i)
         {
            const
               node  = this .nodes [i],
               scene = node .getExecutionContext () .getOuterNode () ?.getScene () ?? node .getScene ();

            if (!enableInlineBindables && scene .getExecutionContext ())
               continue;

            if (node .getName () == name)
               return node;
         }
      }

      // Return first bound viewpoint in scene.

      for (let i = 1; i < length; ++ i)
      {
         const
            node  = this .nodes [i],
            scene = node .getExecutionContext () .getOuterNode () ?.getScene () ?? node .getScene ();

         if (!enableInlineBindables && scene .getExecutionContext ())
            continue;

         if (node ._isBound .getValue ())
            return node;
      }

      // Return first viewpoint in scene.

      for (let i = 1; i < length; ++ i)
      {
         const
            node  = this .nodes [i],
            scene = node .getExecutionContext () .getOuterNode () ?.getScene () ?? node .getScene ();

         if (!enableInlineBindables && scene .getExecutionContext ())
            continue;

         return node;
      }

      return this .nodes [0]; // Return default viewpoint.
   },
   push (node)
   {
      return this .collectedNodes .push (node);
   },
   update (layerNode, stack)
   {
      const { collectedNodes, changedNodes, removedNodes } = this;

      for (const node of collectedNodes)
      {
         if (node .getModificationCount () > this .modificationCount)
            changedNodes .push (node);
      }

      if (!equals (collectedNodes, this .nodes))
      {
         // Unbind nodes not in current list (collectedNodes);

         for (const node of this .nodes)
         {
            if (!collectedNodes .includes (node))
               removedNodes .push (node);
         }

         // Swap nodes.

         const tmp = this .nodes;

         this .nodes          = collectedNodes;
         this .collectedNodes = tmp;

         this .addNodeEvent ();
      }

      // Clear collected nodes.

      this .collectedNodes .length = 1;

      // Update stack.

      stack .update (layerNode, removedNodes, changedNodes)

      changedNodes .length = 0;
      removedNodes .length = 0;

      // Advance modificationCount time.

      this .modificationCount = X3DBindableNode/* default */.A .getModificationCount ();
   },
});

for (const key of Object .keys (BindableList .prototype))
   Object .defineProperty (BindableList .prototype, key, { enumerable: false });

// Compares two arrays.

function equals (lhs, rhs)
{
   const lhsLength = lhs .length;

   if (lhsLength !== rhs .length)
      return false;

   for (let i = 0; i < lhsLength; ++ i)
   {
      if (lhs [i] !== rhs [i])
         return false;
   }

   return true;
}

Object .defineProperties (BindableList,
{
   typeName:
   {
      value: "BindableList",
      enumerable: true,
   },
});

const BindableList_default_ = BindableList;
;

/* harmony default export */ const Execution_BindableList = (Namespace/* default */.A .add ("BindableList", BindableList_default_));
// EXTERNAL MODULE: ./src/x_ite/Components/Grouping/Group.js
var Group = __webpack_require__(8489);
// EXTERNAL MODULE: ./src/x_ite/Components/Navigation/NavigationInfo.js
var NavigationInfo = __webpack_require__(411);
// EXTERNAL MODULE: ./src/x_ite/Components/EnvironmentalEffects/Fog.js
var Fog = __webpack_require__(2121);
// EXTERNAL MODULE: ./src/x_ite/Components/EnvironmentalEffects/Background.js
var Background = __webpack_require__(2497);
// EXTERNAL MODULE: ./src/x_ite/Base/X3DCast.js
var X3DCast = __webpack_require__(7995);
// EXTERNAL MODULE: ./src/x_ite/Base/X3DConstants.js
var X3DConstants = __webpack_require__(3411);
// EXTERNAL MODULE: ./src/standard/Math/Geometry/Box3.js
var Box3 = __webpack_require__(1789);
;// ./src/x_ite/Components/Layering/X3DLayerNode.js

















function X3DLayerNode (executionContext, defaultViewpoint, groupNode)
{
   X3DNode/* default */.A         .call (this, executionContext);
   Rendering_X3DRenderObject .call (this, executionContext);

   this .addType (X3DConstants/* default */.A .X3DLayerNode);

   this .addChildObjects (X3DConstants/* default */.A .inputOutput, "hidden",  new Fields/* default */.A .SFBool (),
                          X3DConstants/* default */.A .outputOnly,  "display", new Fields/* default */.A .SFBool (true));

   // Legacy

   if (executionContext .getSpecificationVersion () <= 3.3)
      this .addAlias ("isPickable", this ._pickable);

   // Create main Group node.
   // This Group node is setuped in Layer or LayoutLayer.

   let groupNodes;

   if (executionContext .hasComponent ("Picking"))
   {
      groupNodes = executionContext .createNode ("PickableGroup", false);

      if (groupNodes)
      {
         this ._pickable   .addFieldInterest (groupNodes ._pickable);
         this ._objectType .addFieldInterest (groupNodes ._objectType);
      }
   }

   groupNodes ??= new Group/* default */.A (executionContext);

   groupNodes ._children = [groupNode];
   groupNodes .setPrivate (true);

   // Private properties

   this .active     = false;
   this .layer0     = false;
   this .groupNodes = groupNodes;

   this .defaultNavigationInfo = new NavigationInfo/* default */.A (executionContext);
   this .defaultViewpoint      = defaultViewpoint;
   this .defaultBackground     = new Background/* default */.A (executionContext);
   this .defaultFog            = new Fog/* default */.A (executionContext);

   this .navigationInfoStack = new Execution_BindableStack (executionContext, this .defaultNavigationInfo);
   this .viewpointStack      = new Execution_BindableStack (executionContext, this .defaultViewpoint);
   this .backgroundStack     = new Execution_BindableStack (executionContext, this .defaultBackground);
   this .fogStack            = new Execution_BindableStack (executionContext, this .defaultFog);

   this .navigationInfos = new Execution_BindableList (executionContext, this .defaultNavigationInfo);
   this .viewpoints      = new Execution_BindableList (executionContext, this .defaultViewpoint);
   this .backgrounds     = new Execution_BindableList (executionContext, this .defaultBackground);
   this .fogs            = new Execution_BindableList (executionContext, this .defaultFog);

   this .defaultBackground .setHidden (true);
   this .defaultFog        .setHidden (true);
}

Object .assign (Object .setPrototypeOf (X3DLayerNode .prototype, X3DNode/* default */.A .prototype),
   Rendering_X3DRenderObject .prototype,
{
   layer0: false,
   initialize ()
   {
      X3DNode/* default */.A         .prototype .initialize .call (this);
      Rendering_X3DRenderObject .prototype .initialize .call (this);

      this .defaultNavigationInfo .setup ();
      this .defaultViewpoint      .setup ();
      this .defaultBackground     .setup ();
      this .defaultFog            .setup ();

      this .navigationInfoStack .setup ();
      this .viewpointStack      .setup ();
      this .backgroundStack     .setup ();
      this .fogStack            .setup ();

      this .navigationInfos .setup ();
      this .viewpoints      .setup ();
      this .backgrounds     .setup ();
      this .fogs            .setup ();

      this ._hidden   .addInterest ("set_visible_and_hidden__", this);
      this ._visible  .addInterest ("set_visible_and_hidden__", this);
      this ._viewport .addInterest ("set_viewport__",           this);

      this .set_visible_and_hidden__ ();
      this .set_viewport__ ();
   },
   isHidden ()
   {
      return this ._hidden .getValue ();
   },
   setHidden (value)
   {
      if (value === this ._hidden .getValue ())
         return;

      this ._hidden = value;
   },
   getBBox (bbox, shadows)
   {
      return this .groupNodes .getBBox (bbox, shadows);
   },
   isLayer0 ()
   {
      return this .layer0;
   },
   setLayer0 (value)
   {
      this .layer0 = value;
      this .defaultBackground .setHidden (!value);
   },
   getLayer ()
   {
      return this;
   },
   getGroups ()
   {
      return this .groupNodes;
   },
   getViewport ()
   {
      return this .viewportNode;
   },
   getBackground ()
   {
      return this .backgroundStack .top ();
   },
   getFog ()
   {
      return this .fogStack .top ();
   },
   getNavigationInfo ()
   {
      return this .navigationInfoStack .top ();
   },
   getViewpoint ()
   {
      return this .viewpointStack .top ();
   },
   getBackgrounds ()
   {
      return this .backgrounds;
   },
   getFogs ()
   {
      return this .fogs;
   },
   getNavigationInfos ()
   {
      return this .navigationInfos;
   },
   getViewpoints ()
   {
      return this .viewpoints;
   },
   getUserViewpoints ()
   {
      const
         browser                = this .getBrowser (),
         enableInlineViewpoints = browser .getBrowserOption ("EnableInlineViewpoints"),
         currentScene           = browser .currentScene;

      return Array .from (new Set (this .viewpoints .get ()
         .filter (viewpointNode => viewpointNode .getDescriptions () .length)
         .filter (viewpointNode => enableInlineViewpoints || viewpointNode .getScene () === currentScene)));
   },
   getBackgroundStack ()
   {
      return this .backgroundStack;
   },
   getFogStack ()
   {
      return this .fogStack;
   },
   getNavigationInfoStack ()
   {
      return this .navigationInfoStack;
   },
   getViewpointStack ()
   {
      return this .viewpointStack;
   },
   viewAll (transitionTime = 1, factor = 1, straighten = false)
   {
      const
         viewpointNode = this .getViewpoint (),
         bbox          = this .getBBox (new Box3/* default */.A ()) .multRight (viewpointNode .getModelMatrix () .copy () .inverse ());

      if (bbox .size .equals (Vector3/* default */.A .ZERO))
         return;

      viewpointNode .lookAt (this, bbox .center, viewpointNode .getLookAtDistance (bbox), transitionTime, factor, straighten);
   },
   straightenView ()
   {
      this .getViewpoint () .straightenView (this);
   },
   set_visible_and_hidden__ ()
   {
      const value = this ._visible .getValue () && !this ._hidden .getValue ();

      if (value === this ._display .getValue ())
         return;

      this ._display = value;
   },
   set_viewport__ ()
   {
      this .viewportNode = (0,X3DCast/* default */.A) (X3DConstants/* default */.A .X3DViewportNode, this ._viewport)
         ?? this .getBrowser () .getDefaultViewport ();
   },
   bindBindables (viewpointName)
   {
      this .traverse (TraverseType/* default */.A .CAMERA, this);

      // Bind first viewpoint in viewpoint list and other bindables too.

      const
         navigationInfoNode = this .navigationInfos .getBound (),
         backgroundNode     = this .backgrounds     .getBound (),
         fogNode            = this .fogs            .getBound (),
         viewpointNode      = this .viewpoints      .getBound (viewpointName);

      this .navigationInfoStack .pushOnTop (navigationInfoNode);
      this .backgroundStack     .pushOnTop (backgroundNode);
      this .fogStack            .pushOnTop (fogNode);
      this .viewpointStack      .pushOnTop (viewpointNode);

      // Update matrices of viewpoint.

      viewpointNode .resetUserOffsets ();

      if (viewpointNode ._viewAll .getValue ())
         viewpointNode .viewAll (this .getBBox (new Box3/* default */.A ()));

      viewpointNode .update ();
   },
   traverse: (() =>
   {
      const projectionMatrix = new Matrix4/* default */.A ();

      return function (type, renderObject = this)
      {
         const
            browser       = this .getBrowser (),
            viewpointNode = this .getViewpoint (),
            pose          = browser .getPose ();

         if (pose ?.views .length)
         {
            switch (type)
            {
               case TraverseType/* default */.A .POINTER:
               {
                  const
                     navigationInfoNode = this .getNavigationInfo (),
                     farValue           = viewpointNode .getFarDistance (navigationInfoNode),
                     inputSource        = browser .getPointingInputSource ();

                  Camera/* default */.A .ortho (-1, 1, -1, 1, 0, farValue, projectionMatrix);

                  this .getProjectionMatrix ()  .push (projectionMatrix);
                  this .getCameraSpaceMatrix () .push (inputSource .matrix);
                  this .getViewMatrix ()        .push (inputSource .inverse);

                  if (this !== browser .getActiveLayer ())
                  {
                     // Remove pose effect from matrices here.
                     this .getCameraSpaceMatrix () .multRight (pose .viewMatrix);
                     this .getViewMatrix ()        .multLeft  (pose .cameraSpaceMatrix);
                  }

                  this .getCameraSpaceMatrix () .multRight (viewpointNode .getCameraSpaceMatrix ());
                  this .getViewMatrix ()        .multLeft  (viewpointNode .getViewMatrix ());
                  break;
               }
               case TraverseType/* default */.A .COLLISION:
               {
                  // This projection matrix will change later before rendering.
                  this .getProjectionMatrix ()  .push (pose .views [0] .projectionMatrix);
                  this .getCameraSpaceMatrix () .push (viewpointNode .getCameraSpaceMatrix ());
                  this .getViewMatrix ()        .push (viewpointNode .getViewMatrix ());
                  break;
               }
               default:
               {
                  // This projection matrix will change later before rendering.
                  this .getProjectionMatrix () .push (pose .views [0] .projectionMatrix);

                  if (this === browser .getActiveLayer ())
                  {
                     this .getCameraSpaceMatrix () .push (pose .cameraSpaceMatrix);
                     this .getViewMatrix ()        .push (pose .viewMatrix);

                     this .getCameraSpaceMatrix () .multRight (viewpointNode .getCameraSpaceMatrix ());
                     this .getViewMatrix ()        .multLeft  (viewpointNode .getViewMatrix ());
                  }
                  else
                  {
                     this .getCameraSpaceMatrix () .push (viewpointNode .getCameraSpaceMatrix ());
                     this .getViewMatrix ()        .push (viewpointNode .getViewMatrix ());
                  }

                  break;
               }
            }
         }
         else
         {
            this .getProjectionMatrix ()  .push (viewpointNode .getProjectionMatrix (this));
            this .getCameraSpaceMatrix () .push (viewpointNode .getCameraSpaceMatrix ());
            this .getViewMatrix ()        .push (viewpointNode .getViewMatrix ());
         }

         switch (type)
         {
            case TraverseType/* default */.A .POINTER:
               this .pointer (type, renderObject);
               break;
            case TraverseType/* default */.A .CAMERA:
               this .camera (type, renderObject);
               break;
            case TraverseType/* default */.A .PICKING:
               this .picking (type, renderObject);
               break;
            case TraverseType/* default */.A .COLLISION:
               this .collision (type, renderObject);
               break;
            case TraverseType/* default */.A .SHADOW:
            case TraverseType/* default */.A .DISPLAY:
               this .display (type, renderObject);
               break;
         }

         this .getViewMatrix ()        .pop ();
         this .getCameraSpaceMatrix () .pop ();
         this .getProjectionMatrix ()  .pop ();
      };
   })(),
   pointer (type, renderObject)
   {
      if (!this ._pointerEvents .getValue ())
         return;

      const
         browser  = this .getBrowser (),
         viewport = this .viewportNode .getRectangle ();

      if (browser .getPointingLayer ())
      {
         if (browser .getPointingLayer () !== this)
            return;
      }
      else
      {
         if (!browser .isPointerInRectangle (viewport))
            return;
      }

      const { viewportNode, groupNodes } = this;

      this .setHitRay (this .getProjectionMatrix () .get (), viewport, browser .getPointer ());
      this .getModelViewMatrix () .push (this .getViewMatrix () .get ());

      viewportNode .push (this);
      renderObject .render (type, groupNodes .traverse, groupNodes);
      viewportNode .pop (this);

      this .getModelViewMatrix () .pop ();
   },
   camera (type, renderObject)
   {
      this .getModelViewMatrix () .push (Matrix4/* default */.A .IDENTITY);

      const { viewportNode, groupNodes } = this;

      viewportNode .push (this);
      groupNodes .traverse (type, renderObject);
      viewportNode .pop (this);

      this .getModelViewMatrix () .pop ();

      this .navigationInfos .update (this, this .navigationInfoStack);
      this .viewpoints      .update (this, this .viewpointStack);
      this .backgrounds     .update (this, this .backgroundStack);
      this .fogs            .update (this, this .fogStack);

      this .getViewpoint () .update ();
   },
   picking (type, renderObject)
   {
      if (!this ._pickable .getValue ())
         return;

      const { viewportNode, groupNodes } = this;

      this .getModelViewMatrix () .push (Matrix4/* default */.A .IDENTITY);

      viewportNode .push (this);
      groupNodes .traverse (type, renderObject);
      viewportNode .pop (this);

      this .getModelViewMatrix () .pop ();
   },
   collision: (() =>
   {
      const projectionMatrix = new Matrix4/* default */.A ();

      return function (type, renderObject)
      {
         const navigationInfoNode = this .getNavigationInfo ();

         if (navigationInfoNode ._transitionActive .getValue ())
            return;

         const
            collisionRadius = navigationInfoNode .getCollisionRadius (),
            avatarHeight    = navigationInfoNode .getAvatarHeight (),
            size            = Math .max (collisionRadius * 2, avatarHeight * 2);

         const { viewportNode, groupNodes } = this;

         Camera/* default */.A .ortho (-size, size, -size, size, -size, size, projectionMatrix);

         this .getProjectionMatrix () .push (projectionMatrix);
         this .getModelViewMatrix  () .push (this .getViewMatrix () .get ());

         // Render
         viewportNode .push (this);
         renderObject .render (type, groupNodes .traverse, groupNodes);
         viewportNode .pop (this);

         this .getModelViewMatrix  () .pop ();
         this .getProjectionMatrix () .pop ();
      };
   })(),
   display (type, renderObject)
   {
      const { viewportNode, groupNodes } = this;

      this .getNavigationInfo () .enable (type, renderObject);
      this .getModelViewMatrix () .push (this .getViewMatrix () .get ());

      viewportNode .push (this);
      renderObject .render (type, groupNodes .traverse, groupNodes);
      viewportNode .pop (this);

      this .getModelViewMatrix () .pop ();
   },
});

Object .defineProperties (X3DLayerNode, X3DNode/* default */.A .getStaticProperties ("X3DLayerNode", "Layering", 1));

const X3DLayerNode_default_ = X3DLayerNode;
;

/* harmony default export */ const Layering_X3DLayerNode = (Namespace/* default */.A .add ("X3DLayerNode", X3DLayerNode_default_));

/***/ },

/***/ 411
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Fields_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(9818);
/* harmony import */ var _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(3927);
/* harmony import */ var _Base_FieldDefinitionArray_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(5373);
/* harmony import */ var _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(1743);
/* harmony import */ var _Core_X3DBindableNode_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(532);
/* harmony import */ var _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(3411);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(8427);







function NavigationInfo (executionContext)
{
   _Core_X3DBindableNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .call (this, executionContext);

   this .addType (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .NavigationInfo);

   this .addChildObjects (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .outputOnly, "transitionStart",  new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFBool (),
                          _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .outputOnly, "transitionActive", new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFBool (),
                          _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .outputOnly, "availableViewers", new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFString (),
                          _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .outputOnly, "viewer",           new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFString ());

   // Units

   this ._avatarSize      .setUnit ("length");
   this ._speed           .setUnit ("speed");
   this ._visibilityLimit .setUnit ("length");

   // Legacy

   // Actually the type field had this value, but we never knew this.
   // if (executionContext .getSpecificationVersion () == 2.0)
   //    this ._type = ["WALK", "ANY"]; // VRML2
}

Object .assign (Object .setPrototypeOf (NavigationInfo .prototype, _Core_X3DBindableNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .prototype),
{
   initialize ()
   {
      _Core_X3DBindableNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .prototype .initialize .call (this);

      this ._type               .addInterest ("set_type__",               this);
      this ._headlight          .addInterest ("set_headlight__",          this);
      this ._visibilityLimit    .addInterest ("set_visibilityLimit__",    this);
      this ._transitionStart    .addInterest ("set_transitionStart__",    this);
      this ._transitionComplete .addInterest ("set_transitionComplete__", this);
      this ._isBound            .addInterest ("set_isBound__",            this);

      this .set_type__ ();
      this .set_headlight__ ();
      this .set_visibilityLimit__ ();
   },
   getViewer ()
   {
      return this ._viewer .getValue ();
   },
   getCollisionRadius ()
   {
      if (this ._avatarSize .length > 0)
      {
         if (this ._avatarSize [0] > 0)
            return this ._avatarSize [0];
      }

      return 0.25;
   },
   getAvatarHeight ()
   {
      if (this ._avatarSize .length > 1)
         return this ._avatarSize [1];

      return 1.6;
   },
   getStepHeight ()
   {
      if (this ._avatarSize .length > 2)
         return this ._avatarSize [2];

      return 0.75;
   },
   getNearValue ()
   {
      const nearValue = this .getCollisionRadius ();

      return nearValue === 0 ? 1e-5 : nearValue / 2;
   },
   getFarValue ()
   {
      return this .visibilityLimit;
   },
   getTransitionType: (() =>
   {
      const TransitionTypes = new Set ([
         "TELEPORT",
         "LINEAR",
         "ANIMATE",
      ]);

      return function ()
      {
         for (const value of this ._transitionType)
         {
            if (TransitionTypes .has (value))
               return value;
         }

         return "LINEAR";
      };
   })(),
   set_type__ ()
   {
      // Determine active viewer.

      this ._viewer = "EXAMINE";

      for (const string of this ._type)
      {
         switch (string)
         {
            case "EXAMINE":
            case "WALK":
            case "FLY":
            case "LOOKAT":
            case "PLANE":
            case "NONE":
               this ._viewer = string;
               break;
            case "EXPLORE":
               this ._viewer = "EXAMINE";
               break;
            case "PLANE_create3000.github.io":
            case "PLANE_create3000.de":
               this ._viewer = "PLANE";
               break;
            default:
               continue;
         }

         // Leave for loop.
         break;
      }

      // Determine available viewers.

      let
         examineViewer = false,
         walkViewer    = false,
         flyViewer     = false,
         planeViewer   = false,
         noneViewer    = false,
         lookAt        = false;

      if (!this ._type .length)
      {
         examineViewer = true;
         walkViewer    = true;
         flyViewer     = true;
         planeViewer   = true;
         noneViewer    = true;
         lookAt        = true;
      }
      else
      {
         for (const string of this ._type)
         {
            switch (string)
            {
               case "EXAMINE":
                  examineViewer = true;
                  continue;
               case "WALK":
                  walkViewer = true;
                  continue;
               case "FLY":
                  flyViewer = true;
                  continue;
               case "LOOKAT":
                  lookAt = true;
                  continue;
               case "PLANE":
               case "PLANE_create3000.github.io":
               case "PLANE_create3000.de":
                  planeViewer = true;
                  continue;
               case "NONE":
                  noneViewer = true;
                  continue;
               case "ANY":
                  examineViewer = true;
                  walkViewer    = true;
                  flyViewer     = true;
                  planeViewer   = true;
                  noneViewer    = true;
                  lookAt        = true;
                  break;
               default:
                  // Any string leads to:
                  examineViewer = true;
                  continue;
            }

            break;
         }
      }

      this ._availableViewers .length = 0;

      if (examineViewer)
         this ._availableViewers .push ("EXAMINE");

      if (walkViewer)
         this ._availableViewers .push ("WALK");

      if (flyViewer)
         this ._availableViewers .push ("FLY");

      if (planeViewer)
         this ._availableViewers .push ("PLANE");

      if (lookAt)
         this ._availableViewers .push ("LOOKAT");

      if (noneViewer)
         this ._availableViewers .push ("NONE");
   },
   set_headlight__ ()
   {
      if (this ._headlight .getValue ())
         delete this .enable;
      else
         this .enable = Function .prototype;
   },
   set_visibilityLimit__ ()
   {
      this .visibilityLimit = Math .max (this ._visibilityLimit .getValue (), 0);
   },
   set_transitionStart__ ()
   {
      if (!this ._transitionActive .getValue ())
         this ._transitionActive = true;
   },
   set_transitionComplete__ ()
   {
      if (this ._transitionActive .getValue ())
         this ._transitionActive = false;
   },
   set_isBound__ ()
   {
      if (this ._isBound .getValue ())
         return;

      if (this ._transitionActive .getValue ())
         this ._transitionActive = false;
   },
   enable (type, renderObject)
   {
      if (!this ._headlight .getValue ())
         return;

      const headlight = this .getBrowser () .getHeadlight ();

      renderObject .getGlobalLights ()     .push (headlight);
      renderObject .getGlobalLightsKeys () .push (headlight .lightNode .getLightKey ());
   },
   traverse (type, renderObject)
   {
      renderObject .getLayer () .getNavigationInfos () .push (this);
   }
});

Object .defineProperties (NavigationInfo,
{
   ... _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .getStaticProperties ("NavigationInfo", "Navigation", 1, "children", "2.0"),
   fieldDefinitions:
   {
      value: new _Base_FieldDefinitionArray_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A ([
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .inputOutput, "metadata",           new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFNode ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .inputOnly,   "set_bind",           new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFBool ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .inputOutput, "type",               new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFString ("EXAMINE", "ANY")),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .inputOutput, "avatarSize",         new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFFloat (0.25, 1.6, 0.75)),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .inputOutput, "speed",              new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFFloat (1)),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .inputOutput, "headlight",          new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFBool (true)),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .inputOutput, "visibilityLimit",    new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFFloat ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .inputOutput, "transitionType",     new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFString ("LINEAR")),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .inputOutput, "transitionTime",     new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFTime (1)),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .outputOnly,  "transitionComplete", new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFBool ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .outputOnly,  "isBound",            new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFBool ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .outputOnly,  "bindTime",           new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFTime ()),
      ]),
      enumerable: true,
   },
});

const __default__ = NavigationInfo;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .add ("NavigationInfo", __default__));

/***/ },

/***/ 1080
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Fields_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(9818);
/* harmony import */ var _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(3927);
/* harmony import */ var _Base_FieldDefinitionArray_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(5373);
/* harmony import */ var _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(1743);
/* harmony import */ var _X3DViewpointNode_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(8753);
/* harmony import */ var _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(3411);
/* harmony import */ var _standard_Math_Geometry_Camera_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(7184);
/* harmony import */ var _standard_Math_Numbers_Vector2_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(4296);
/* harmony import */ var _standard_Math_Numbers_Matrix4_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(6776);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(8427);










function Viewpoint (executionContext)
{
   _X3DViewpointNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .call (this, executionContext);

   this .addType (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .Viewpoint);

   // Units

   this ._position         .setUnit ("length");
   this ._centerOfRotation .setUnit ("length");
   this ._fieldOfView      .setUnit ("angle");

   // Private properties

   this .projectionMatrix = new _standard_Math_Numbers_Matrix4_js__WEBPACK_IMPORTED_MODULE_8__/* ["default"] */ .A ();
}

Object .assign (Object .setPrototypeOf (Viewpoint .prototype, _X3DViewpointNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .prototype),
{
   getRelativeTransformation (fromViewpointNode)
   {
      const relative = _X3DViewpointNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .prototype .getRelativeTransformation .call (this, fromViewpointNode);

      if (fromViewpointNode .constructor === this .constructor)
         relative .fieldOfView = fromViewpointNode .getUserFieldOfView ();

      return relative;
   },
   setInterpolators (fromViewpointNode, relative)
   {
      if (fromViewpointNode .constructor === this .constructor)
      {
         const scale = relative .fieldOfView / this .getUserFieldOfView ();

         this .fieldOfViewScaleInterpolator ._keyValue = new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFFloat (scale, this ._fieldOfViewScale .getValue ());

         this ._fieldOfViewScale = scale;
      }
      else
      {
         this .fieldOfViewScaleInterpolator ._keyValue = new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFFloat (this ._fieldOfViewScale .getValue (), this ._fieldOfViewScale .getValue ());

         this ._fieldOfViewScale = this ._fieldOfViewScale .getValue ();
      }
   },
   getLogarithmicDepthBuffer ()
   {
      return false;
   },
   getFieldOfView ()
   {
      const fov = this ._fieldOfView .getValue ();

      return fov > 0 && fov < Math .PI ? fov : Math .PI / 4;
   },
   setFieldOfView (value)
   {
      this ._fieldOfView = value;
   },
   getUserFieldOfView ()
   {
      const fov = this ._fieldOfView .getValue () * this ._fieldOfViewScale .getValue ();

      return fov > 0 && fov < Math .PI ? fov : Math .PI / 4;
   },
   getScreenScale (point, viewport, screenScale)
   {
      // Returns the screen scale in meter/pixel for on pixel.

      const
         width  = viewport [2],
         height = viewport [3],
         pose   = this .getBrowser () .getPose ();

      // MDN says fov can be determined from projectionMatrix.
      // https://developer.mozilla.org/en-US/docs/Web/API/WebXR_Device_API/Perspective
      const fov1_2 = pose
         ? 1 / pose .views [0] .projectionMatrix [5]
         : Math .tan (this .getUserFieldOfView () / 2);

      let size = Math .abs (point .z) * fov1_2 * 2;

      if (width > height)
         size /= height;
      else
         size /= width;

      return screenScale .set (size, size, size);
   },
   getViewportSize: (() =>
   {
      const viewportSize = new _standard_Math_Numbers_Vector2_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A ();

      return function (viewport, nearValue)
      {
         // Returns viewport size in meters.

         const
            width  = viewport [2],
            height = viewport [3],
            size   = nearValue * Math .tan (this .getUserFieldOfView () / 2) * 2,
            aspect = width / height;

         if (aspect > 1)
            return viewportSize .set (size * aspect, size);

         return viewportSize .set (size, size / aspect);
      };
   })(),
   getLookAtDistance (bbox)
   {
      return (bbox .size .norm () / 2) / Math .tan (this .getUserFieldOfView () / 2);
   },
   getProjectionMatrixWithLimits (nearValue, farValue, viewport)
   {
      return _standard_Math_Geometry_Camera_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .perspective (this .getUserFieldOfView (), nearValue, farValue, viewport [2], viewport [3], this .projectionMatrix);
   },
});

Object .defineProperties (Viewpoint,
{
   ... _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .getStaticProperties ("Viewpoint", "Navigation", 1, "children", "2.0"),
   fieldDefinitions:
   {
      value: new _Base_FieldDefinitionArray_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A ([
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .inputOutput, "metadata",          new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFNode ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .inputOnly,   "set_bind",          new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFBool ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .inputOutput, "description",       new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFString ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .inputOutput, "position",          new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFVec3f (0, 0, 10)),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .inputOutput, "orientation",       new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFRotation ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .inputOutput, "centerOfRotation",  new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFVec3f ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .inputOutput, "fieldOfView",       new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFFloat (0.785398)),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .inputOutput, "nearDistance",      new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFFloat (-1)),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .inputOutput, "farDistance",       new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFFloat (-1)),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .inputOutput, "viewAll",           new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFBool ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .inputOutput, "jump",              new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFBool (true)),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .inputOutput, "retainUserOffsets", new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFBool ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .outputOnly,  "isBound",           new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFBool ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .outputOnly,  "bindTime",          new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFTime ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .inputOutput, "navigationInfo",    new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFNode ()),
      ]),
      enumerable: true,
   },
});

const __default__ = Viewpoint;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_9__/* ["default"] */ .A .add ("Viewpoint", __default__));

/***/ },

/***/ 8753
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Fields_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(9818);
/* harmony import */ var _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(1743);
/* harmony import */ var _Core_X3DBindableNode_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(532);
/* harmony import */ var _Time_TimeSensor_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(7867);
/* harmony import */ var _Interpolation_EaseInEaseOut_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(4770);
/* harmony import */ var _Interpolation_PositionInterpolator_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(8737);
/* harmony import */ var _Interpolation_OrientationInterpolator_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(9656);
/* harmony import */ var _Interpolation_ScalarInterpolator_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(2186);
/* harmony import */ var _Base_X3DCast_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(7995);
/* harmony import */ var _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(3411);
/* harmony import */ var _standard_Math_Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(8655);
/* harmony import */ var _standard_Math_Numbers_Rotation4_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(9461);
/* harmony import */ var _standard_Math_Numbers_Matrix3_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(3817);
/* harmony import */ var _standard_Math_Numbers_Matrix4_js__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(6776);
/* harmony import */ var _standard_Math_Geometry_Box3_js__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(1789);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(8427);
















function X3DViewpointNode (executionContext)
{
   _Core_X3DBindableNode_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .call (this, executionContext);

   this .addType (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_9__/* ["default"] */ .A .X3DViewpointNode);

   this .addChildObjects (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_9__/* ["default"] */ .A .inputOutput, "positionOffset",         new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFVec3f (),
                          _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_9__/* ["default"] */ .A .inputOutput, "orientationOffset",      new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFRotation (),
                          _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_9__/* ["default"] */ .A .inputOutput, "scaleOffset",            new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFVec3f (1, 1, 1),
                          _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_9__/* ["default"] */ .A .inputOutput, "scaleOrientationOffset", new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFRotation (),
                          _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_9__/* ["default"] */ .A .inputOutput, "centerOfRotationOffset", new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFVec3f (),
                          _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_9__/* ["default"] */ .A .inputOutput, "fieldOfViewScale",       new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFFloat (1));

   // Units

   this ._nearDistance .setUnit ("length");
   this ._farDistance  .setUnit ("length");

   // Private properties

   this .descriptions         = [ ];
   this .userPosition         = new _standard_Math_Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_10__/* ["default"] */ .A ();
   this .userOrientation      = new _standard_Math_Numbers_Rotation4_js__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A ();
   this .userCenterOfRotation = new _standard_Math_Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_10__/* ["default"] */ .A ();
   this .modelMatrix          = new _standard_Math_Numbers_Matrix4_js__WEBPACK_IMPORTED_MODULE_13__/* ["default"] */ .A ();
   this .cameraSpaceMatrix    = new _standard_Math_Numbers_Matrix4_js__WEBPACK_IMPORTED_MODULE_13__/* ["default"] */ .A (1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0,  10, 1);
   this .viewMatrix           = new _standard_Math_Numbers_Matrix4_js__WEBPACK_IMPORTED_MODULE_13__/* ["default"] */ .A (1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, -10, 1);

   const
      browser      = this .getBrowser (),
      privateScene = browser .getPrivateScene ();

   this .timeSensor                   = new _Time_TimeSensor_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A              (privateScene);
   this .easeInEaseOut                = new _Interpolation_EaseInEaseOut_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A           (privateScene);
   this .positionInterpolator         = new _Interpolation_PositionInterpolator_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A    (privateScene);
   this .orientationInterpolator      = new _Interpolation_OrientationInterpolator_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A (privateScene);
   this .scaleInterpolator            = new _Interpolation_PositionInterpolator_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A    (privateScene);
   this .scaleOrientationInterpolator = new _Interpolation_OrientationInterpolator_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A (privateScene);
   this .fieldOfViewScaleInterpolator = new _Interpolation_ScalarInterpolator_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A      (privateScene);
}

Object .assign (Object .setPrototypeOf (X3DViewpointNode .prototype, _Core_X3DBindableNode_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .prototype),
{
   initialize ()
   {
      _Core_X3DBindableNode_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .prototype .initialize .call (this);

      this .timeSensor ._stopTime = 1;
      this .timeSensor .setup ();

      this .easeInEaseOut ._key           = new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFFloat (0, 1);
      this .easeInEaseOut ._easeInEaseOut = new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFVec2f (new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFVec2f (), new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFVec2f ());
      this .easeInEaseOut .setup ();

      this .positionInterpolator         ._key = new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFFloat (0, 1);
      this .orientationInterpolator      ._key = new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFFloat (0, 1);
      this .scaleInterpolator            ._key = new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFFloat (0, 1);
      this .scaleOrientationInterpolator ._key = new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFFloat (0, 1);
      this .fieldOfViewScaleInterpolator ._key = new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFFloat (0, 1);

      this .positionInterpolator         .setup ();
      this .orientationInterpolator      .setup ();
      this .scaleInterpolator            .setup ();
      this .scaleOrientationInterpolator .setup ();
      this .fieldOfViewScaleInterpolator .setup ();

      this .timeSensor ._fraction_changed .addFieldInterest (this .easeInEaseOut ._set_fraction);

      this .easeInEaseOut ._modifiedFraction_changed .addFieldInterest (this .positionInterpolator         ._set_fraction);
      this .easeInEaseOut ._modifiedFraction_changed .addFieldInterest (this .orientationInterpolator      ._set_fraction);
      this .easeInEaseOut ._modifiedFraction_changed .addFieldInterest (this .scaleInterpolator            ._set_fraction);
      this .easeInEaseOut ._modifiedFraction_changed .addFieldInterest (this .scaleOrientationInterpolator ._set_fraction);
      this .easeInEaseOut ._modifiedFraction_changed .addFieldInterest (this .fieldOfViewScaleInterpolator ._set_fraction);

      this .positionInterpolator         ._value_changed .addFieldInterest (this ._positionOffset);
      this .orientationInterpolator      ._value_changed .addFieldInterest (this ._orientationOffset);
      this .scaleInterpolator            ._value_changed .addFieldInterest (this ._scaleOffset);
      this .scaleOrientationInterpolator ._value_changed .addFieldInterest (this ._scaleOrientationOffset);
      this .fieldOfViewScaleInterpolator ._value_changed .addFieldInterest (this ._fieldOfViewScale);

      this ._nearDistance   .addInterest ("set_nearDistance__",   this);
      this ._farDistance    .addInterest ("set_farDistance__",    this);
      this ._viewAll        .addInterest ("set_viewAll__",        this);
      this ._navigationInfo .addInterest ("set_navigationInfo__", this);
      this ._isBound        .addInterest ("set_bound__",          this);

      this .set_nearDistance__ ();
      this .set_farDistance__ ();
      this .set_navigationInfo__ ();
   },
   set_nearDistance__ ()
   {
      const nearDistance = this ._nearDistance .getValue ();

      this .nearDistance = nearDistance >= 0 ? nearDistance : undefined;
   },
   set_farDistance__ ()
   {
      const farDistance = this ._farDistance .getValue ();

      this .farDistance = farDistance >= 0 ? farDistance : undefined;
   },
   set_viewAll__ ()
   {
      if (!this ._viewAll .getValue ())
         return;

      if (!this ._isBound .getValue ())
         return;

      this ._set_bind = true;
   },
   set_navigationInfo__ ()
   {
      if (this .navigationInfoNode)
         this ._isBound .removeFieldInterest (this .navigationInfoNode ._set_bind);

      this .navigationInfoNode = (0,_Base_X3DCast_js__WEBPACK_IMPORTED_MODULE_8__/* ["default"] */ .A) (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_9__/* ["default"] */ .A .NavigationInfo, this ._navigationInfo);

      if (this .navigationInfoNode)
         this ._isBound .addFieldInterest (this .navigationInfoNode ._set_bind);
   },
   set_bound__ ()
   {
      if (this ._isBound .getValue ())
         this .getBrowser () .setDescription (this ._description);
      else
         this .timeSensor ._stopTime = Date .now () / 1000;
   },
   set_active__ (navigationInfoNode, active)
   {
      if (active .getValue ())
         return;

      this .timeSensor ._isActive .removeInterest ("set_active__", this);

      if (!this ._isBound .getValue ())
         return;

      if (this .timeSensor ._fraction_changed .getValue () !== 1)
         return;

      navigationInfoNode ._transitionComplete = true;
   },
   setInterpolators ()
   { },
   getDescriptions ()
   {
      return this .descriptions;
   },
   getPosition ()
   {
      return this ._position .getValue ();
   },
   setPosition (value)
   {
      this ._position = value;
   },
   getOrientation ()
   {
      return this ._orientation .getValue ();
   },
   setOrientation (value)
   {
      this ._orientation = value;
   },
   getCenterOfRotation ()
   {
      return this ._centerOfRotation .getValue ();
   },
   setCenterOfRotation (value)
   {
      this ._centerOfRotation = value;
   },
   getUserPosition ()
   {
      return this .userPosition .assign (this .getPosition ())
         .add (this ._positionOffset .getValue ());
   },
   setUserPosition (userPosition)
   {
      this ._positionOffset = this .userPosition .assign (userPosition)
         .subtract (this .getPosition ());
   },
   getUserOrientation ()
   {
      return this .userOrientation .assign (this .getOrientation ())
         .multRight (this ._orientationOffset .getValue ());
   },
   setUserOrientation (userOrientation)
   {
      this ._orientationOffset = this .userOrientation .assign (this .getOrientation ()) .inverse ()
         .multRight (userOrientation);
   },
   getUserCenterOfRotation ()
   {
      return this .userCenterOfRotation .assign (this .getCenterOfRotation ())
         .add (this ._centerOfRotationOffset .getValue ());
   },
   setUserCenterOfRotation (userCenterOfRotation)
   {
      this ._centerOfRotationOffset = this .userCenterOfRotation .assign (userCenterOfRotation)
         .subtract (this .getCenterOfRotation ());
   },
   getFieldOfViewScale ()
   {
      return this ._fieldOfViewScale .getValue ();
   },
   setFieldOfViewScale (value)
   {
      this ._fieldOfViewScale = value;
   },
   getNearDistance (navigationInfoNode)
   {
      return this .nearDistance ?? navigationInfoNode ?.getNearValue ();
   },
   setNearDistance (value)
   {
      this .nearDistance = value;
   },
   getFarDistance (navigationInfoNode)
   {
      return this .farDistance
         ?? (navigationInfoNode ? navigationInfoNode .getFarValue () || this .getMaxFarValue () : undefined);
   },
   setFarDistance (value)
   {
      this .farDistance = value;
   },
   getProjectionMatrix (renderObject)
   {
      const navigationInfoNode = renderObject .getNavigationInfo ();

      return this .getProjectionMatrixWithLimits (this .getNearDistance (navigationInfoNode),
                                                  this .getFarDistance (navigationInfoNode),
                                                  renderObject .getLayer () .getViewport () .getRectangle ());
   },
   getCameraSpaceMatrix ()
   {
      return this .cameraSpaceMatrix;
   },
   getViewMatrix ()
   {
      return this .viewMatrix;
   },
   getModelMatrix ()
   {
      return this .modelMatrix;
   },
   getMaxFarValue ()
   {
      return this .getBrowser () .getRenderingProperty ("LogarithmicDepthBuffer") ? 1e10 : 1e5;
   },
   getUpVector ()
   {
      // Local y-axis,
      // see https://www.web3d.org/documents/specifications/19775-1/V4.0/Part01/components/navigation.html#NavigationInfo.
      return _standard_Math_Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_10__/* ["default"] */ .A .Y_AXIS;
   },
   getSpeedFactor ()
   {
      return 1;
   },
   setVRMLTransition (value)
   {
      // VRML behavior support.
      this .VRMLTransition = value;
   },
   getVRMLTransition ()
   {
      // VRML behavior support.
      return this .VRMLTransition;
   },
   checkTransition (description)
   {
      if (this .timeSensor ._isActive .getValue () && this .timeSensor ._description .getValue () === description)
         return true;

      this .timeSensor ._description = description;

      return false;
   },
   transitionStart (layerNode, fromViewpointNode)
   {
      if (this ._jump .getValue ())
      {
         if (this .checkTransition ("transitionStart"))
            return;

         const relative = this .getRelativeTransformation (fromViewpointNode);

         if (!this ._retainUserOffsets .getValue ())
            this .resetUserOffsets ();

         if (this ._viewAll .getValue ())
            this .viewAll (layerNode .getBBox (new _standard_Math_Geometry_Box3_js__WEBPACK_IMPORTED_MODULE_14__/* ["default"] */ .A ()));

         // Handle NavigationInfo.

         const
            navigationInfoNode = layerNode .getNavigationInfo (),
            transitionTime     = navigationInfoNode ._transitionTime .getValue ();

         let transitionType = navigationInfoNode .getTransitionType ();

         // VRML behavior

         if (this .getExecutionContext () .getSpecificationVersion () == 2.0)
         {
            if (this .getVRMLTransition ())
               transitionType = "LINEAR";
            else
               transitionType = "TELEPORT";
         }

         this .setVRMLTransition (false);

         // End VRML behavior

         if (transitionTime <= 0)
            transitionType = "TELEPORT";

         if (this .constructor !== fromViewpointNode .constructor)
            transitionType = "TELEPORT";

         switch (transitionType)
         {
            case "TELEPORT":
            {
               navigationInfoNode ._transitionComplete = true;
               return;
            }
            case "ANIMATE":
            {
               this .easeInEaseOut ._easeInEaseOut = new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFVec2f (new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFVec2f (0, 1), new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFVec2f (1, 0));
               break;
            }
            default:
            {
               // LINEAR
               this .easeInEaseOut ._easeInEaseOut = new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFVec2f (new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFVec2f (), new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFVec2f ());
               break;
            }
         }

         navigationInfoNode ._transitionStart = true;

         this .timeSensor ._cycleInterval = transitionTime;
         this .timeSensor ._stopTime      = Date .now () / 1000;
         this .timeSensor ._startTime     = Date .now () / 1000;

         this .timeSensor ._isActive .addInterest ("set_active__", this, navigationInfoNode);

         this .positionInterpolator         ._keyValue = new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFVec3f    (relative .position,         this ._positionOffset);
         this .orientationInterpolator      ._keyValue = new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFRotation (relative .orientation,      this ._orientationOffset);
         this .scaleInterpolator            ._keyValue = new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFVec3f    (relative .scale,            this ._scaleOffset);
         this .scaleOrientationInterpolator ._keyValue = new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFRotation (relative .scaleOrientation, this ._scaleOrientationOffset);

         this ._positionOffset         = relative .position;
         this ._orientationOffset      = relative .orientation;
         this ._scaleOffset            = relative .scale;
         this ._scaleOrientationOffset = relative .scaleOrientation;

         this .setInterpolators (fromViewpointNode, relative);
      }
      else
      {
         this .transitionStop ();

         const navigationInfoNode = layerNode .getNavigationInfo ();

         navigationInfoNode ._transitionComplete = true;

         const relative = this .getRelativeTransformation (fromViewpointNode);

         this ._positionOffset         = relative .position;
         this ._orientationOffset      = relative .orientation;
         this ._scaleOffset            = relative .scale;
         this ._scaleOrientationOffset = relative .scaleOrientation;

         this .setInterpolators (fromViewpointNode, relative);
      }
   },
   transitionStop ()
   {
      this .timeSensor ._stopTime = Date .now () / 1000;
      this .timeSensor ._isActive .removeInterest ("set_active__", this);
   },
   resetUserOffsets ()
   {
      this ._positionOffset         = _standard_Math_Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_10__/* ["default"] */ .A   .ZERO;
      this ._orientationOffset      = _standard_Math_Numbers_Rotation4_js__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A .IDENTITY;
      this ._scaleOffset            = _standard_Math_Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_10__/* ["default"] */ .A   .ONE;
      this ._scaleOrientationOffset = _standard_Math_Numbers_Rotation4_js__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A .IDENTITY;
      this ._centerOfRotationOffset = _standard_Math_Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_10__/* ["default"] */ .A   .ZERO;
      this ._fieldOfViewScale       = 1;

      this .set_nearDistance__ ();
      this .set_farDistance__ ();
   },
   getRelativeTransformation: (() =>
   {
      const
         position         = new _standard_Math_Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_10__/* ["default"] */ .A (),
         orientation      = new _standard_Math_Numbers_Rotation4_js__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A (),
         scale            = new _standard_Math_Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_10__/* ["default"] */ .A (),
         scaleOrientation = new _standard_Math_Numbers_Rotation4_js__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A ();

      return function (fromViewpointNode)
      {
         const differenceMatrix = this .modelMatrix .copy () .multRight (fromViewpointNode .getViewMatrix ()) .inverse ();

         differenceMatrix .get (position, orientation, scale, scaleOrientation);

         position .subtract (this .getPosition ());
         orientation .multLeft (this .getOrientation () .copy () .inverse ());

         return {
            position: position,
            orientation: orientation,
            scale: scale,
            scaleOrientation: scaleOrientation,
         };
      };
   })(),
   getLookAtRotation: (() =>
   {
      const
         x = new _standard_Math_Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_10__/* ["default"] */ .A (),
         y = new _standard_Math_Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_10__/* ["default"] */ .A (),
         z = new _standard_Math_Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_10__/* ["default"] */ .A (),
         m = new _standard_Math_Numbers_Matrix3_js__WEBPACK_IMPORTED_MODULE_12__/* ["default"] */ .A (),
         r = new _standard_Math_Numbers_Rotation4_js__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A ();

      return function (fromPoint, toPoint)
      {
         const up = this .getUpVector (true);

         z .assign (fromPoint) .subtract (toPoint) .normalize ();
         x .assign (up) .cross (z) .normalize ();
         y .assign (z) .cross (x) .normalize ();

         m .set (... x, ... y, ... z);
         r .setMatrix (m);

         return r;
      };
   })(),
   lookAtPoint (layerNode, point, transitionTime = 1, factor = 1, straighten = false)
   {
      this .getCameraSpaceMatrix () .multVecMatrix (point);
      this .getModelMatrix () .copy () .inverse () .multVecMatrix (point);

      const minDistance = this .getNearDistance (layerNode .getNavigationInfo ()) * 2;

      this .lookAt (layerNode, point, minDistance, transitionTime, factor, straighten);
   },
   lookAtBBox (layerNode, bbox, transitionTime = 1, factor = 1, straighten = false)
   {
      if (bbox .size .equals (_standard_Math_Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_10__/* ["default"] */ .A .ZERO))
         return;

      bbox = bbox .copy () .multRight (this .getModelMatrix () .copy () .inverse ());

      this .lookAt (layerNode, bbox .center, this .getLookAtDistance (bbox), transitionTime, factor, straighten);
   },
   lookAt (layerNode, point, distance, transitionTime = 1, factor = 1, straighten = false)
   {
      this .timeSensor ._description = "lookAt";

      const
         offset = point .copy () .add (this .getUserOrientation () .multVecRot (new _standard_Math_Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_10__/* ["default"] */ .A (0, 0, distance))) .subtract (this .getPosition ());

      layerNode .getNavigationInfo () ._transitionStart = true;

      this .timeSensor ._cycleInterval = transitionTime;
      this .timeSensor ._stopTime      = Date .now () / 1000;
      this .timeSensor ._startTime     = Date .now () / 1000;

      this .timeSensor ._isActive .addInterest ("set_active__", this, layerNode .getNavigationInfo ());

      this .easeInEaseOut ._easeInEaseOut = new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFVec2f (new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFVec2f (0, 1), new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFVec2f (1, 0));

      const
         translation = this ._positionOffset .getValue () .copy () .lerp (offset, factor),
         direction   = this .getPosition () .copy () .add (translation) .subtract (point);

      let rotation = this ._orientationOffset .getValue () .copy () .multRight (new _standard_Math_Numbers_Rotation4_js__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A (this .getUserOrientation () .multVecRot (new _standard_Math_Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_10__/* ["default"] */ .A (0, 0, 1)), direction));

      if (straighten)
      {
         rotation = this .getOrientation () .copy () .inverse () .multRight (this .straightenHorizon (this .getOrientation () .copy () .multRight (rotation)));
      }

      this .positionInterpolator         ._keyValue = new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFVec3f (this ._positionOffset, translation);
      this .orientationInterpolator      ._keyValue = new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFRotation (this ._orientationOffset, rotation);
      this .scaleInterpolator            ._keyValue = new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFVec3f (this ._scaleOffset, _standard_Math_Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_10__/* ["default"] */ .A .ONE);
      this .scaleOrientationInterpolator ._keyValue = new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFRotation (this ._scaleOrientationOffset, this ._scaleOrientationOffset);

      const relative = this .getRelativeTransformation (this);

      this ._fieldOfViewScale       = 1;
      this ._centerOfRotationOffset = point .copy () .subtract (this .getCenterOfRotation ());
      this .nearDistance            = distance * (0.125 / 10);
      this .farDistance             = this .nearDistance * this .getMaxFarValue () / 0.125;

      this .setInterpolators (this, relative);
   },
   straightenView (layerNode)
   {
      if (this .checkTransition ("straightenView"))
         return;

      layerNode .getNavigationInfo () ._transitionStart = true;

      this .timeSensor ._cycleInterval = 1;
      this .timeSensor ._stopTime      = Date .now () / 1000;
      this .timeSensor ._startTime     = Date .now () / 1000;

      this .timeSensor ._isActive .addInterest ("set_active__", this, layerNode .getNavigationInfo ());

      this .easeInEaseOut ._easeInEaseOut = new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFVec2f (new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFVec2f (0, 1), new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFVec2f (1, 0));

      const rotation = this .getOrientation () .copy () .inverse () .multRight (this .straightenHorizon (this .getUserOrientation ()));

      this .positionInterpolator         ._keyValue = new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFVec3f (this ._positionOffset, this ._positionOffset);
      this .orientationInterpolator      ._keyValue = new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFRotation (this ._orientationOffset, rotation);
      this .scaleInterpolator            ._keyValue = new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFVec3f (this ._scaleOffset, this ._scaleOffset);
      this .scaleOrientationInterpolator ._keyValue = new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFRotation (this ._scaleOrientationOffset, this ._scaleOrientationOffset);

      const relative = this .getRelativeTransformation (this);

      this ._fieldOfViewScale = 1;

      this .setInterpolators (this, relative);
   },
   straightenHorizon (orientation, upVector = this .getUpVector (true))
   {
      return orientation .straighten (upVector);
   },
   viewAll (bbox)
   {
      bbox .copy () .multRight (this .modelMatrix .copy () .inverse ());

      if (bbox .size .equals (_standard_Math_Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_10__/* ["default"] */ .A .ZERO))
      {
         this .set_nearDistance__ ();
         this .set_farDistance__ ();
      }
      else
      {
         const
            direction       = this .getUserPosition () .copy () .subtract (bbox .center) .normalize (),
            distance        = this .getLookAtDistance (bbox),
            userPosition    = bbox .center .copy () .add (direction .multiply (distance)),
            userOrientation = this .getLookAtRotation (userPosition, bbox .center);

         this ._positionOffset         = userPosition .subtract (this .getPosition ());
         this ._orientationOffset      = this .getOrientation () .copy () .inverse () .multRight (userOrientation);
         this ._centerOfRotationOffset = bbox .center .copy () .subtract (this .getCenterOfRotation ());
         this ._fieldOfViewScale       = 1;
         this .nearDistance            = distance * (0.125 / 10);
         this .farDistance             = this .nearDistance * this .getMaxFarValue () / 0.125;
      }
   },
   traverse (type, renderObject)
   {
      // Handle NavigationInfo node.

      this .navigationInfoNode ?.traverse (type, renderObject);

      // Check if the viewpoint is displayed.

      this .descriptions .length = 0;

      const description = this ._description .getValue ();

      if (description)
      {
         if (renderObject .getViewpointGroups () .every (viewpointGroupNode => viewpointGroupNode .getDisplayed ()))
         {
            for (const viewpointGroupNode of renderObject .getViewpointGroups ())
            {
               const description = viewpointGroupNode ._description .getValue ();

               if (description)
                  this .descriptions .push (description);
            }

            this .descriptions .push (description);
         }
      }

      // Add the viewpoint to the list of available viewpoints.

      renderObject .getLayer () .getViewpoints () .push (this);

      this .modelMatrix .assign (renderObject .getModelViewMatrix () .get ());
   },
   update ()
   {
      this .cameraSpaceMatrix .set (this .getUserPosition (),
                                    this .getUserOrientation (),
                                    this ._scaleOffset .getValue (),
                                    this ._scaleOrientationOffset .getValue ());

      this .cameraSpaceMatrix .multRight (this .modelMatrix);

      this .viewMatrix .assign (this .cameraSpaceMatrix) .inverse ();
   }
});

Object .defineProperties (X3DViewpointNode, _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .getStaticProperties ("X3DViewpointNode", "Navigation", 1));

const __default__ = X3DViewpointNode;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_15__/* ["default"] */ .A .add ("X3DViewpointNode", __default__));

/***/ },

/***/ 7274
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Fields_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(9818);
/* harmony import */ var _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(1743);
/* harmony import */ var _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(3411);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(8427);




const
   _cache                   = Symbol (),
   _autoRefreshStartTime    = Symbol (),
   _autoRefreshCompleteTime = Symbol (),
   _autoRefreshId           = Symbol ();

function X3DUrlObject (executionContext)
{
   this .addType (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .X3DUrlObject);

   this .addChildObjects (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .outputOnly, "loadState", new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFInt32 (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .NOT_STARTED_STATE),
                          _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .outputOnly, "loadData",  new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFTime ());

   this [_cache]                = true;
   this [_autoRefreshStartTime] = Date .now ();
}

Object .assign (X3DUrlObject .prototype,
{
   initialize ()
   {
      this .getLive () .addInterest ("set_live__", this);

      this ._load                 .addInterest ("set_load__",        this);
      this ._url                  .addInterest ("set_url__",         this);
      this ._loadData             .addInterest ("loadData",          this);
      this ._autoRefresh          .addInterest ("set_autoRefresh__", this);
      this ._autoRefreshTimeLimit .addInterest ("set_autoRefresh__", this);
   },
   getAllowEmptyUrl ()
   {
      return false;
   },
   setLoadState (value, notify = true)
   {
      this ._loadState = value;

      switch (value)
      {
         case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .COMPLETE_STATE:
         case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .FAILED_STATE:
         {
            this [_autoRefreshCompleteTime] = Date .now ();
            this .setAutoRefreshTimer (Math .max (this ._autoRefresh .getValue (), 0));
            break;
         }
      }

      if (!notify)
         return;

      switch (value)
      {
         case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .NOT_STARTED_STATE:
            break;
         case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .IN_PROGRESS_STATE:
         {
            this .getScene () .addLoadingObject (this);
            break;
         }
         case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .COMPLETE_STATE:
         case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .FAILED_STATE:
         {
            this .getScene () .removeLoadingObject (this);
            break;
         }
      }
   },
   checkLoadState ()
   {
      return this ._loadState .getValue ();
   },
   getLoadState ()
   {
      return this ._loadState;
   },
   setCache (value)
   {
      this [_cache] = value;
   },
   getCache ()
   {
      return this [_cache] && this .getBrowser () .getBrowserOption ("Cache");
   },
   async requestImmediateLoad (cache = true)
   {
      switch (this .checkLoadState ())
      {
         case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .IN_PROGRESS_STATE:
         {
            await this .loading ();
            return;
         }
         case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .COMPLETE_STATE:
         {
            return;
         }
         case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .FAILED_STATE:
         {
            throw new Error (`Failed loading ${this .getTypeName ()}.`);
         }
      }

      const browser = this .getBrowser ();

      if (!browser .getBrowserOption ("LoadUrlObjects") && this .getExecutionContext () !== browser .getPrivateScene ())
         return;

      if (!this ._load .getValue ())
         throw new Error (`${this .getTypeName ()}.load is false.`);

      if (this ._url .length === 0 && !this .getAllowEmptyUrl ())
      {
         this .unloadData ();
         return;
      }

      this .setCache (cache);
      this .setLoadState (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .IN_PROGRESS_STATE);

      if (this .isInitialized ())
         // Buffer prevents double load of the scene if load and url field are set at the same time.
         this ._loadData = this .getBrowser () .getCurrentTime ();
      else
         this .loadData ();

      await this .loading ();
   },
   loading ()
   {
      return new Promise ((resolve, reject) =>
      {
         const _loading = Symbol ();

         const test = () =>
         {
            switch (this .checkLoadState ())
            {
               case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .COMPLETE_STATE:
               {
                  this ._loadState .removeFieldCallback (_loading);
                  resolve ();
                  break;
               }
               case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .FAILED_STATE:
               {
                  this ._loadState .removeFieldCallback (_loading);
                  reject (new Error (`Failed loading ${this .getTypeName ()}.`));
                  break;
               }
            }
         }

         this ._loadState .addFieldCallback (_loading, test);

         test ();
      });
   },
   loadNow ()
   {
      this .setLoadState (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .NOT_STARTED_STATE);

      return this .requestImmediateLoad ();
   },
   loadData ()
   { },
   requestUnload ()
   {
      const loadState = this .checkLoadState ();

      if (loadState === _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .NOT_STARTED_STATE || loadState === _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .FAILED_STATE)
         return;

      this .setLoadState (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .NOT_STARTED_STATE);
      this .unloadData ();
   },
   unloadNow ()
   {
      this .requestUnload ();
   },
   unloadData ()
   { },
   setAutoRefreshTimer (autoRefreshInterval)
   {
      clearTimeout (this [_autoRefreshId]);

      if (this ._autoRefresh .getValue () <= 0)
         return;

      const autoRefreshTimeLimit = this ._autoRefreshTimeLimit .getValue ();

      if (autoRefreshTimeLimit > 0)
      {
         if ((Date .now () - this [_autoRefreshStartTime]) / 1000 > autoRefreshTimeLimit - autoRefreshInterval)
            return;
      }

      this [_autoRefreshId] = setTimeout (this .performAutoRefresh .bind (this), autoRefreshInterval * 1000);
   },
   performAutoRefresh ()
   {
      this .setLoadState (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .NOT_STARTED_STATE);
      this .requestImmediateLoad (false) .catch (Function .prototype);
   },
   set_live__ ()
   {
      if (this .getLive () .getValue ())
         this .set_autoRefresh__ ();
      else
         clearTimeout (this [_autoRefreshId]);
   },
   set_load__ ()
   {
      if (this ._load .getValue ())
         this .requestImmediateLoad () .catch (Function .prototype);
      else
         this .requestUnload ();
   },
   set_url__ ()
   {
      if (!this ._load .getValue ())
         return;

      this .setLoadState (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .NOT_STARTED_STATE);
      this .requestImmediateLoad () .catch (Function .prototype);
   },
   set_autoRefresh__ ()
   {
      if (this .checkLoadState () !== _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .COMPLETE_STATE)
         return;

      const
         elapsedTime = (Date .now () - this [_autoRefreshCompleteTime]) / 1000,
         autoRefresh = Math .max (this ._autoRefresh .getValue (), 0);

      let autoRefreshInterval = autoRefresh - elapsedTime;

      if (autoRefreshInterval < 0)
         autoRefreshInterval = Math .ceil (elapsedTime / autoRefresh) * autoRefresh - elapsedTime;

      this .setAutoRefreshTimer (autoRefreshInterval);
   },
   dispose () { },
});

Object .defineProperties (X3DUrlObject, _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .getStaticProperties ("X3DUrlObject", "Networking", 1));

const __default__ = X3DUrlObject;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .add ("X3DUrlObject", __default__));

/***/ },

/***/ 3181
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  A: () => (/* binding */ Rendering_X3DGeometryNode)
});

// EXTERNAL MODULE: ./src/x_ite/Fields.js + 15 modules
var Fields = __webpack_require__(9818);
// EXTERNAL MODULE: ./src/x_ite/Rendering/VertexArray.js
var VertexArray = __webpack_require__(2793);
// EXTERNAL MODULE: ./src/x_ite/Components/Core/X3DNode.js
var X3DNode = __webpack_require__(1743);
// EXTERNAL MODULE: ./src/x_ite/Base/X3DConstants.js
var X3DConstants = __webpack_require__(3411);
// EXTERNAL MODULE: ./src/x_ite/Base/X3DCast.js
var X3DCast = __webpack_require__(7995);
// EXTERNAL MODULE: ./src/x_ite/Browser/Networking/URLs.js
var URLs = __webpack_require__(4583);
// EXTERNAL MODULE: ./src/x_ite/Namespace.js
var Namespace = __webpack_require__(8427);
;// ./src/x_ite/Browser/Rendering/MikkTSpace.js


// See: https://github.com/donmccurdy/mikktspace-wasm

const __default__ = new class MikkTSpace
{
   #promise;

   async initialize ()
   {
      return this .#promise = this .#promise ?? new Promise (async resolve =>
      {
         const imports =
         {
            wbg:
            {
               __wbindgen_string_new: (arg0, arg1) =>
               {
                  const ret = this .#getStringFromWasm0 (arg0, arg1);

                  return this .#addHeapObject (ret);
               },
               __wbindgen_rethrow: (arg0) =>
               {
                  throw this .#takeObject (arg0);
               },
            },
         };

         const input = await fetch (URLs/* default */.A .getLibraryURL ("mikktspace_bg.wasm"));

         const { instance } = await this .#load (input, imports);

         this .#wasm = instance .exports;

         resolve ();
      });
   }

   isInitialized ()
   {
      return !! this .#wasm;
   }

   async #load (response, imports)
   {
      if (typeof WebAssembly .instantiateStreaming === "function")
      {
         try
         {
            return await WebAssembly .instantiateStreaming (response, imports);
         }
         catch (error)
         {
            if (response .headers .get ("Content-Type") !== "application/wasm")
            {
               // console .warn ("`WebAssembly.instantiateStreaming` failed because your server does not serve wasm with `application/wasm` MIME type. Falling back to `WebAssembly.instantiate` which is slower. Original error:\n", error);
            }
            else
            {
               throw error;
            }
         }
      }

      const bytes = await response .arrayBuffer ();

      return await WebAssembly .instantiate (bytes, imports);
   }

   /**
   * Generates vertex tangents for the given position/normal/texcoord attributes.
   * @param {Float32Array} position vec3
   * @param {Float32Array} normal vec3
   * @param {Float32Array} texcoord vec2
   * @returns {Float32Array} vec4
   */
   generateTangents (position, normal, texcoord)
   {
      try
      {
         const
            retptr = this .#wasm .__wbindgen_add_to_stack_pointer (-16),
            ptr0   = this .#passArrayF32ToWasm0 (position, this .#wasm .__wbindgen_malloc),
            len0   = this .#WASM_VECTOR_LEN,
            ptr1   = this .#passArrayF32ToWasm0 (normal, this .#wasm .__wbindgen_malloc),
            len1   = this .#WASM_VECTOR_LEN,
            ptr2   = this .#passArrayF32ToWasm0 (texcoord, this .#wasm .__wbindgen_malloc),
            len2   = this .#WASM_VECTOR_LEN;

         this .#wasm .generateTangents (retptr, ptr0, len0, ptr1, len1, ptr2, len2);

         const
            r0 = this .#getInt32Memory0 () [retptr / 4 + 0],
            r1 = this .#getInt32Memory0 () [retptr / 4 + 1],
            v3 = this .#getArrayF32FromWasm0 (r0, r1) .slice ();

         this .#wasm .__wbindgen_free (r0, r1 * 4);

         return v3;
      }
      finally
      {
         this .#wasm .__wbindgen_add_to_stack_pointer (16);
      }
   }

   #wasm;
   #textDecoder = new TextDecoder ("utf-8", { ignoreBOM: true, fatal: true });
   #uint8Memory0;

   #getUint8Memory0 ()
   {
      if (this .#uint8Memory0 ?.buffer !== this .#wasm .memory .buffer)
         this .#uint8Memory0 = new Uint8Array (this .#wasm .memory .buffer);

      return this .#uint8Memory0;
   }

   #getStringFromWasm0 (ptr, len)
   {
      return this .#textDecoder .decode (this .#getUint8Memory0 () .subarray (ptr, ptr + len));
   }

   #heap = Array .from ({ length: 32 }) .concat ([undefined, null, true, false]);
   #heap_next = this .#heap .length;

   #addHeapObject (obj)
   {
      if (this .#heap_next === this .#heap .length)
         this .#heap .push (this .#heap .length + 1);

      const i = this .#heap_next;

      this .#heap_next = this .#heap [i];
      this .#heap [i]  = obj;

      return i;
   }

   #getObject (i)
   {
      return this .#heap [i];
   }

   #dropObject (i)
   {
      if (i < 36)
         return;

      this .#heap [i] = this .#heap_next;

      this .#heap_next = i;
   }

   #takeObject (i)
   {
      const ret = this .#getObject (i);

      this .#dropObject (i);

      return ret;
   }

   #float32Memory0;

   #getFloat32Memory0 ()
   {
      if (this .#float32Memory0 ?.buffer !== this .#wasm .memory .buffer)
         this .#float32Memory0 = new Float32Array (this .#wasm .memory .buffer);

      return this .#float32Memory0;
   }

   #WASM_VECTOR_LEN = 0;

   #passArrayF32ToWasm0 (arg, malloc)
   {
      const ptr = malloc (arg .length * 4);

      this .#getFloat32Memory0 () .set (arg, ptr / 4);

      this .#WASM_VECTOR_LEN = arg .length;

      return ptr;
   }

   #int32Memory0;

   #getInt32Memory0 ()
   {
      if (this .#int32Memory0 ?.buffer !== this .#wasm .memory .buffer)
         this .#int32Memory0 = new Int32Array (this .#wasm .memory .buffer);

      return this .#int32Memory0;
   }

   #getArrayF32FromWasm0 (ptr, len)
   {
      return this .#getFloat32Memory0 () .subarray (ptr / 4, ptr / 4 + len);
   }
};
;

/* harmony default export */ const MikkTSpace = (Namespace/* default */.A .add ("MikkTSpace", __default__));
// EXTERNAL MODULE: ./src/standard/Math/Numbers/Vector3.js
var Vector3 = __webpack_require__(8655);
// EXTERNAL MODULE: ./src/standard/Math/Numbers/Matrix4.js
var Matrix4 = __webpack_require__(6776);
// EXTERNAL MODULE: ./src/standard/Math/Geometry/Box3.js
var Box3 = __webpack_require__(1789);
// EXTERNAL MODULE: ./src/standard/Math/Geometry/Plane3.js
var Plane3 = __webpack_require__(460);
// EXTERNAL MODULE: ./src/standard/Math/Algorithm.js
var Algorithm = __webpack_require__(9919);
// EXTERNAL MODULE: ./src/x_ite/DEVELOPMENT.js
var DEVELOPMENT = __webpack_require__(1476);
;// ./src/x_ite/Components/Rendering/X3DGeometryNode.js













// Box normals for bbox / line intersection.
const boxNormals = [
   Vector3/* default */.A .Z_AXIS,          // front
   Vector3/* default */.A .NEGATIVE_Z_AXIS, // back
   Vector3/* default */.A .Y_AXIS,          // top
   Vector3/* default */.A .NEGATIVE_Y_AXIS, // bottom
   Vector3/* default */.A .X_AXIS,          // right
   // left: We do not need to test for left.
];

function X3DGeometryNode (executionContext)
{
   X3DNode/* default */.A .call (this, executionContext);

   this .addType (X3DConstants/* default */.A .X3DGeometryNode);

   this .addChildObjects (X3DConstants/* default */.A .outputOnly, "transparent",  new Fields/* default */.A .SFBool (),
                          X3DConstants/* default */.A .outputOnly, "bbox_changed", new Fields/* default */.A .SFTime (),
                          X3DConstants/* default */.A .outputOnly, "rebuild",      new Fields/* default */.A .SFTime (Date .now () / 1000));

   // Private members

   this .min                      = new Vector3/* default */.A ();
   this .max                      = new Vector3/* default */.A ();
   this .bbox                     = Box3/* default */.A .fromExtents (this .min, this .max);
   this .solid                    = true;
   this .geometryType             = 3;
   this .colorMaterial            = false;
   this .attribNodes              = [ ];
   this .attribArrays             = [ ];
   this .textureCoordinateMapping = new Map ();
   this .multiTexCoords           = [ ];
   this .coordIndices             = X3DGeometryNode .createArray ();
   this .texCoords                = X3DGeometryNode .createArray ();
   this .fogDepths                = X3DGeometryNode .createArray ();
   this .colors                   = X3DGeometryNode .createArray ();
   this .tangents                 = X3DGeometryNode .createArray ();
   this .normals                  = X3DGeometryNode .createArray ();
   this .vertices                 = X3DGeometryNode .createArray ();
   this .hasFogCoords             = false;
   this .hasNormals               = false;
   this .geometryKey              = "";
   this .vertexCount              = 0;
   this .planes                   = Array .from ({ length: 5 }, () => new Plane3/* default */.A ()); // For LinePickSensor
}

class GeometryArray extends Array
{
   #typedArray = new Float32Array ();

   assign (value)
   {
      const length = value .length;

      this .length = length;

      for (let i = 0; i < length; ++ i)
         this [i] = value [i];
   }

   getValue ()
   {
      return this .#typedArray;
   }

   shrinkToFit ()
   {
      if (this .length === this .#typedArray .length)
         this .#typedArray .set (this);
      else
         this .#typedArray = new Float32Array (this);

      return this .#typedArray;
   }
}

Object .defineProperty (X3DGeometryNode, "createArray",
{
   // Function to select ether Array or MFFloat for color/normal/vertex arrays.
   // Array version runs faster, see BeyondGermany and TreasureIsland.
   value ()
   {
      // return new Fields .MFFloat ();

      return new GeometryArray ();
   },
})

Object .assign (Object .setPrototypeOf (X3DGeometryNode .prototype, X3DNode/* default */.A .prototype),
{
   setup ()
   {
      X3DNode/* default */.A .prototype .setup .call (this);

      this .rebuild ();
   },
   initialize ()
   {
      X3DNode/* default */.A .prototype .initialize .call (this);

      const
         browser = this .getBrowser (),
         gl      = browser .getContext ();

      this .getLive () .addInterest ("set_live__", this);

      this .addInterest ("requestRebuild", this);
      this ._rebuild .addInterest ("rebuild", this);

      this .coordIndexBuffer      = gl .createBuffer ();
      this .attribBuffers         = [ ];
      this .textureCoordinateNode = browser .getDefaultTextureCoordinate ();
      this .texCoordBuffers       = Array .from ({ length: browser .getMaxTexCoords () }, () => gl .createBuffer ());
      this .fogDepthBuffer        = gl .createBuffer ();
      this .colorBuffer           = gl .createBuffer ();
      this .tangentBuffer         = gl .createBuffer ();
      this .normalBuffer          = gl .createBuffer ();
      this .vertexBuffer          = gl .createBuffer ();
      this .vertexArrayObject     = new VertexArray/* default */.A (gl);

      this .setCCW (true);
      this .set_live__ ();
   },
   getGeometryType ()
   {
      return this .geometryType;
   },
   setGeometryType (value)
   {
      this .geometryType = value;
   },
   setTransparent (value)
   {
      if (!!value !== this ._transparent .getValue ())
         this ._transparent = value;
   },
   isTransparent ()
   {
      return this ._transparent .getValue ();
   },
   getBBox ()
   {
      // With screen matrix applied.
      return this .bbox;
   },
   setBBox (bbox)
   {
      if (bbox .equals (this .bbox))
         return;

      const { min, max } = this;

      bbox .getExtents (min, max);

      this .bbox .assign (bbox);
      this .planes .forEach ((plane, i) => plane .set (i % 2 ? min : max, boxNormals [i]));

      this ._bbox_changed .addEvent ();
   },
   getMin ()
   {
      // With screen matrix applied.
      return this .min;
   },
   getMax ()
   {
      // With screen matrix applied.
      return this .max;
   },
   getMatrix ()
   {
      return Matrix4/* default */.A .IDENTITY;
   },
   isSolid ()
   {
      return this .solid;
   },
   setSolid (value)
   {
      this .solid = value;
   },
   getCCW ()
   {
      const gl = this .getBrowser () .getContext ();

      return this .frontFace ===  gl .CCW;
   },
   setCCW (value)
   {
      const gl = this .getBrowser () .getContext ();

      this .frontFace = value ? gl .CCW : gl .CW;
      this .backFace  = value ? gl .CW  : gl .CCW;
   },
   getCoordIndices ()
   {
      return this .coordIndices;
   },
   getAttrib ()
   {
      return this .attribNodes;
   },
   getAttribs ()
   {
      return this .attribArrays;
   },
   getAttribBuffers ()
   {
      return this .attribBuffers;
   },
   getFogDepths ()
   {
      return this .fogDepths;
   },
   getColors ()
   {
      return this .colors;
   },
   getMultiTexCoords ()
   {
      return this .multiTexCoords;
   },
   getTexCoords ()
   {
      return this .texCoords;
   },
   getTextureCoordinate ()
   {
      return this .textureCoordinateNode;
   },
   setTextureCoordinate (value)
   {
      this .textureCoordinateNode .removeInterest ("updateTextureCoordinateMapping", this);

      this .textureCoordinateNode = value ?? this .getBrowser () .getDefaultTextureCoordinate ();

      this .textureCoordinateNode .addInterest ("updateTextureCoordinateMapping", this);

      this .updateTextureCoordinateMapping ();
   },
   getTextureCoordinateMapping ()
   {
      return this .textureCoordinateMapping;
   },
   updateTextureCoordinateMapping ()
   {
      this .textureCoordinateMapping .clear ();

      this .textureCoordinateNode .getTextureCoordinateMapping (this .textureCoordinateMapping);
   },
   getTangents ()
   {
      return this .tangents;
   },
   getNormals ()
   {
      return this .normals;
   },
   getVertices ()
   {
      return this .vertices;
   },
   updateVertexArrays ()
   {
      this .vertexArrayObject .update ();

      this .updateInstances = true;
   },
   generateTexCoords ()
   {
      const texCoords = this .texCoords;

      if (texCoords .length === 0)
      {
         const
            p         = this .getTexCoordParams (),
            min       = p .min,
            Sindex    = p .Sindex,
            Tindex    = p .Tindex,
            Ssize     = p .Ssize,
            S         = min [Sindex],
            T         = min [Tindex],
            vertices  = this .vertices .getValue (),
            length    = vertices .length;

         for (let i = 0; i < length; i += 4)
         {
            texCoords .push ((vertices [i + Sindex] - S) / Ssize,
                             (vertices [i + Tindex] - T) / Ssize,
                             0,
                             1);
         }

         texCoords .shrinkToFit ();
      }

      this .getMultiTexCoords () .push (texCoords);
   },
   getTexCoordParams: (() =>
   {
      const texCoordParams = { min: new Vector3/* default */.A (), Ssize: 0, Sindex: 0, Tindex: 0 };

      return function ()
      {
         const
            bbox  = this .getBBox (),
            size  = bbox .size,
            Xsize = size .x,
            Ysize = size .y,
            Zsize = size .z;

         texCoordParams .min .assign (bbox .center) .subtract (size .divide (2));

         if ((Xsize >= Ysize) && (Xsize >= Zsize))
         {
            // X size largest
            texCoordParams .Ssize  = Xsize;
            texCoordParams .Sindex = 0;

            if (Ysize >= Zsize)
               texCoordParams .Tindex = 1;
            else
               texCoordParams .Tindex = 2;
         }
         else if ((Ysize >= Xsize) && (Ysize >= Zsize))
         {
            // Y size largest
            texCoordParams .Ssize  = Ysize;
            texCoordParams .Sindex = 1;

            if (Xsize >= Zsize)
               texCoordParams .Tindex = 0;
            else
               texCoordParams .Tindex = 2;
         }
         else
         {
            // Z is the largest
            texCoordParams .Ssize  = Zsize;
            texCoordParams .Sindex = 2;

            if (Xsize >= Ysize)
               texCoordParams .Tindex = 0;
            else
               texCoordParams .Tindex = 1;
         }

         return texCoordParams;
      };
   })(),
   generateTangents ()
   {
      try
      {
         if (this .geometryType < 2)
            return;

         if (!this .vertices .length)
            return;

         if (!MikkTSpace .isInitialized ())
         {
            return void (MikkTSpace .initialize () .then (() =>
            {
               this .generateTangents ();
               this .transfer ();
               this .updateGeometryKey ();
               this .updateRenderFunctions ();
               this .getBrowser () .addBrowserEvent ();
            }));
         }

         const
            vertices  = this .vertices .getValue () .filter ((v, i) => i % 4 < 3),
            normals   = this .normals .getValue (),
            texCoords = this .multiTexCoords [0] .getValue () .filter ((v, i) => i % 4 < 2),
            tangents  = MikkTSpace .generateTangents (vertices, normals, texCoords),
            length    = tangents .length;

         // Convert coordinate system handedness to respect output format of MikkTSpace.
         for (let i = 3; i < length; i += 4)
            tangents [i] = -tangents [i]; // Flip w-channel.

         this .tangents .assign (tangents);
         this .tangents .shrinkToFit ();
      }
      catch (error)
      {
         if (DEVELOPMENT/* default */.A)
            console .error (error);
      }
   },
   refineNormals (normalIndex, normals, creaseAngle)
   {
      if (creaseAngle <= 0)
         return normals;

      const
         cosCreaseAngle = Math .cos (Algorithm/* default */.A .clamp (creaseAngle, 0, Math .PI)),
         refinedNormals = [ ];

      for (const vertex of normalIndex .values ())
      {
         for (const p of vertex)
         {
            const
               P = normals [p],
               N = new Vector3/* default */.A ();

            for (const q of vertex)
            {
               const Q = normals [q];

               if (Q .dot (P) > cosCreaseAngle)
                  N .add (Q);
            }

            refinedNormals [p] = N .normalize ();
         }
      }

      return refinedNormals;
   },
   set_live__ ()
   {
      // Is overloaded by primitives with option nodes.
   },
   connectOptions (options)
   {
      const
         browser      = this .getBrowser (),
         alwaysUpdate = this .isLive () && browser .getBrowserOption ("AlwaysUpdateGeometries");

      if (this .getLive () .getValue () || alwaysUpdate)
      {
         options .addInterest ("requestRebuild", this);

         if (options .getModificationTime () >= this ._rebuild .getValue ())
            this .requestRebuild ();
      }
      else
      {
         options .removeInterest ("requestRebuild", this);
      }
   },
   requestRebuild ()
   {
      this ._rebuild = Date .now () / 1000;
   },
   rebuild ()
   {
      this .clear ();
      this .build ();

      // Shrink arrays before transferring them to graphics card.

      for (const attribArray of this .attribArrays)
         attribArray .shrinkToFit ();

      for (const multiTexCoord of this .multiTexCoords)
         multiTexCoord .shrinkToFit ();

      this .coordIndices .shrinkToFit ();
      this .fogDepths    .shrinkToFit ();
      this .colors       .shrinkToFit ();
      this .tangents     .shrinkToFit ();
      this .normals      .shrinkToFit ();
      this .vertices     .shrinkToFit ();

      this .updateBBox ();

      // Generate texCoord if needed.

      if (!this .multiTexCoords .length)
         this .generateTexCoords ();

      // Generate tangents if needed.

      if (!this .tangents .length)
         this .generateTangents ();

      // Transfer arrays and update.

      this .transfer ();
      this .updateGeometryKey ();
      this .updateRenderFunctions ();
   },
   clear ()
   {
      // BBox

      this .min .set (Number .POSITIVE_INFINITY);
      this .max .set (Number .NEGATIVE_INFINITY);

      // Create attribArray arrays.
      {
         const attribArrays = this .attribArrays;

         for (const attribArray of attribArrays)
            attribArray .length = 0;

         const length = this .attribNodes .length;

         for (let a = attribArrays .length; a < length; ++ a)
            attribArrays [a] = X3DGeometryNode .createArray ();

         attribArrays .length = length;
      }

      // Buffer

      this .coordIndices   .length = 0;
      this .fogDepths      .length = 0;
      this .colors         .length = 0;
      this .multiTexCoords .length = 0;
      this .texCoords      .length = 0;
      this .tangents       .length = 0;
      this .normals        .length = 0;
      this .vertices       .length = 0;
   },
   updateBBox: (() =>
   {
      const point = new Vector3/* default */.A ();

      return function ()
      {
         // Determine bbox.

         const
            vertices    = this .vertices .getValue (),
            numVertices = vertices .length,
            min         = this .min,
            max         = this .max;

         if (numVertices)
         {
            if (min .x === Number .POSITIVE_INFINITY)
            {
               for (let i = 0; i < numVertices; i += 4)
               {
                  const { [i]: v1, [i + 1]: v2, [i + 2]: v3 } = vertices;

                  point .set (v1, v2, v3);

                  min .min (point);
                  max .max (point);
               }
            }

            this .bbox .setExtents (min, max);
         }
         else
         {
            this .bbox .setExtents (min .set (0), max .set (0));
         }

         for (let i = 0; i < 5; ++ i)
            this .planes [i] .set (i % 2 ? min : max, boxNormals [i]);

         this ._bbox_changed .addEvent ();
      };
   })(),
   transfer ()
   {
      const gl = this .getBrowser () .getContext ();

      // Transfer coord indices.

      gl .bindBuffer (gl .ARRAY_BUFFER, this .coordIndexBuffer);
      gl .bufferData (gl .ARRAY_BUFFER, this .coordIndices .getValue (), gl .DYNAMIC_DRAW);

      // Transfer attribArrays.

      for (let i = this .attribBuffers .length, length = this .attribArrays .length; i < length; ++ i)
         this .attribBuffers .push (gl .createBuffer ());

      for (let i = 0, length = this .attribArrays .length; i < length; ++ i)
      {
         gl .bindBuffer (gl .ARRAY_BUFFER, this .attribBuffers [i]);
         gl .bufferData (gl .ARRAY_BUFFER, this .attribArrays [i] .getValue (), gl .DYNAMIC_DRAW);
      }

      // Transfer fog depths.

      const lastHasFogCoords = this .hasFogCoords;

      gl .bindBuffer (gl .ARRAY_BUFFER, this .fogDepthBuffer);
      gl .bufferData (gl .ARRAY_BUFFER, this .fogDepths .getValue (), gl .DYNAMIC_DRAW);

      this .hasFogCoords = !! this .fogDepths .length;

      if (this .hasFogCoords !== lastHasFogCoords)
         this .updateVertexArrays ();

      // Transfer colors.

      const lastColorMaterial = this .colorMaterial;

      gl .bindBuffer (gl .ARRAY_BUFFER, this .colorBuffer);
      gl .bufferData (gl .ARRAY_BUFFER, this .colors .getValue (), gl .DYNAMIC_DRAW);

      this .colorMaterial = !! this .colors .length;

      if (this .colorMaterial !== lastColorMaterial)
         this .updateVertexArrays ();

      // Transfer multiTexCoords.

      for (let i = 0, length = this .multiTexCoords .length; i < length; ++ i)
      {
         gl .bindBuffer (gl .ARRAY_BUFFER, this .texCoordBuffers [i]);
         gl .bufferData (gl .ARRAY_BUFFER, this .multiTexCoords [i] .getValue (), gl .DYNAMIC_DRAW);
      }

      // Transfer tangents.

      const lastHasTangents = this .hasTangents;

      gl .bindBuffer (gl .ARRAY_BUFFER, this .tangentBuffer);
      gl .bufferData (gl .ARRAY_BUFFER, this .tangents .getValue (), gl .DYNAMIC_DRAW);

      this .hasTangents = !! this .tangents .length;

      if (this .hasTangents !== lastHasTangents)
         this .updateVertexArrays ();

      // Transfer normals or flat normals.

      const lastHasNormals = this .hasNormals;

      gl .bindBuffer (gl .ARRAY_BUFFER, this .normalBuffer);
      gl .bufferData (gl .ARRAY_BUFFER, this .normals .getValue (), gl .DYNAMIC_DRAW);

      this .hasNormals = !! this .normals .length;

      if (this .hasNormals !== lastHasNormals)
         this .updateVertexArrays ();

      // Transfer vertices.

      gl .bindBuffer (gl .ARRAY_BUFFER, this .vertexBuffer);
      gl .bufferData (gl .ARRAY_BUFFER, this .vertices .getValue (), gl .DYNAMIC_DRAW);

      this .vertexCount = this .vertices .length / 4;
   },
   updateGeometryKey ()
   {
      let key = "";

      key += this .geometryType;
      key += this .hasFogCoords  ? 1 : 0;
      key += this .colorMaterial ? 1 : 0;
      key += this .hasTangents   ? 1 : 0;
      key += this .hasNormals    ? 1 : 0;

      this .geometryKey = key;
   },
   updateRenderFunctions ()
   {
      if (this .vertexCount)
      {
         // Use default render functions.

         this .setBase (this .base);
      }
      else
      {
         // Use no render function.

         this .displaySimple          = Function .prototype;
         this .display                = Function .prototype;
         this .displaySimpleInstanced = Function .prototype;
         this .displayInstanced       = Function .prototype;
      }
   },
   setBase: (() =>
   {
      // Actually all functions that are overloaded must be listed here.

      const functions = [
         "intersectsLine",
         "updateVertexArrays",
         "updateLengthSoFar",
         "generateTexCoords",
         "displaySimple",
         "displaySimpleThick",
         "displaySimpleInstanced",
         "displaySimpleInstancedThick",
         "display",
         "displayThick",
         "displayInstanced",
         "displayInstancedThick",
      ];

      return function (base)
      {
         this .base = base;

         if (base)
         {
            for (const fn of functions)
               this [fn] = base [fn];
         }
         else
         {
            // Use default render functions.
            for (const fn of functions)
               delete this [fn];
         }
      };
   })(),
   displaySimple (gl, renderContext, shaderNode)
   {
      if (this .vertexArrayObject .enable (shaderNode .getProgram ()))
      {
         if (this .coordIndices .length)
            shaderNode .enableCoordIndexAttribute (gl, this .coordIndexBuffer, 0, 0);

         if (this .multiTexCoords .length)
            shaderNode .enableTexCoordAttribute (gl, this .texCoordBuffers, 0, 0);

         if (this .hasNormals)
            shaderNode .enableNormalAttribute (gl, this .normalBuffer, 0, 0);

         shaderNode .enableVertexAttribute (gl, this .vertexBuffer, 0, 0);
      }

      gl .drawArrays (gl .TRIANGLES, 0, this .vertexCount);
   },
   display (gl, renderContext)
   {
      const
         { viewport, appearanceNode, modelViewMatrix } = renderContext,
         browser         = this .getBrowser (),
         primitiveMode   = browser .getPrimitiveMode (gl .TRIANGLES),
         renderModeNodes = appearanceNode .getRenderModes (),
         shaderNode      = appearanceNode .getShader (this, renderContext);

      // Set viewport.

      gl .viewport (... viewport);

      // Enable render mode nodes.

      for (const node of renderModeNodes)
         node .enable (gl);

      // Handle negative scale.

      const positiveScale = Matrix4/* default */.A .prototype .determinant3 .call (modelViewMatrix) >= 0;

      gl .frontFace (positiveScale ? this .frontFace : this .backFace);

      // Draw front and back faces.

      if (this .solid || !appearanceNode .getBackMaterial ())
      {
         this .displayGeometry (gl, renderContext, shaderNode, primitiveMode, true, true);
      }
      else
      {
         const backShaderNode = appearanceNode .getBackShader (this, renderContext);

         this .displayGeometry (gl, renderContext, backShaderNode, primitiveMode, true,  false);
         this .displayGeometry (gl, renderContext, shaderNode,     primitiveMode, false, true);
      }

      // Disable render mode nodes.

      for (const node of renderModeNodes)
         node .disable (gl);

      // Reset texture units.

      browser .resetTextureUnits ();
   },
   displayGeometry (gl, renderContext, shaderNode, primitiveMode, back, front)
   {
      shaderNode .enable (gl);
      shaderNode .setUniforms (gl, renderContext, this, front);

      // Setup vertex attributes.

      if (this .vertexArrayObject .enable (shaderNode .getProgram ()))
      {
         const
            attribNodes   = this .getAttrib (),
            attribBuffers = this .getAttribBuffers ();

         if (this .coordIndices .length)
            shaderNode .enableCoordIndexAttribute (gl, this .coordIndexBuffer, 0, 0);

         for (let i = 0, length = attribNodes .length; i < length; ++ i)
            attribNodes [i] .enable (gl, shaderNode, attribBuffers [i]);

         if (this .hasFogCoords)
            shaderNode .enableFogDepthAttribute (gl, this .fogDepthBuffer, 0, 0);

         if (this .colorMaterial)
            shaderNode .enableColorAttribute (gl, this .colorBuffer, 0, 0);

         if (this .hasTangents)
            shaderNode .enableTangentAttribute (gl, this .tangentBuffer, 0, 0);

         shaderNode .enableTexCoordAttribute (gl, this .texCoordBuffers, 0, 0);
         shaderNode .enableNormalAttribute   (gl, this .normalBuffer,    0, 0);
         shaderNode .enableVertexAttribute   (gl, this .vertexBuffer,    0, 0);
      }

      // Draw depending on wireframe, solid and transparent.

      if (renderContext .transparent || back !== front)
      {
         // Render transparent or back or front.

         gl .enable (gl .CULL_FACE);

         // Render back.

         if (back && !this .solid)
         {
            gl .cullFace (gl .FRONT);
            gl .drawArrays (primitiveMode, 0, this .vertexCount);
         }

         // Render front.

         if (front)
         {
            gl .cullFace (gl .BACK);
            gl .drawArrays (primitiveMode, 0, this .vertexCount);
         }
      }
      else
      {
         // Render solid or both sides.

         if (this .solid)
            gl .enable (gl .CULL_FACE);
         else
            gl .disable (gl .CULL_FACE);

         gl .drawArrays (primitiveMode, 0, this .vertexCount);
      }
   },
   displaySimpleInstanced (gl, shaderNode, shapeNode)
   {
      const instances = shapeNode .getInstances ();

      if (instances .vertexArrayObject .update (this .updateInstances) .enable (shaderNode .getProgram ()))
      {
         const { instancesStride, particleOffset, matrixOffset, normalMatrixOffset } = shapeNode;

         if (particleOffset !== undefined)
            shaderNode .enableParticleAttribute (gl, instances, instancesStride, particleOffset, 1);

         shaderNode .enableInstanceMatrixAttribute (gl, instances, instancesStride, matrixOffset, 1);

         if (normalMatrixOffset !== undefined)
            shaderNode .enableInstanceNormalMatrixAttribute (gl, instances, instancesStride, normalMatrixOffset, 1);

         if (this .coordIndices .length)
            shaderNode .enableCoordIndexAttribute (gl, this .coordIndexBuffer, 0, 0);

         shaderNode .enableTexCoordAttribute (gl, this .texCoordBuffers, 0, 0);
         shaderNode .enableNormalAttribute   (gl, this .normalBuffer,    0, 0);
         shaderNode .enableVertexAttribute   (gl, this .vertexBuffer,    0, 0);

         this .updateInstances = false;
      }

      gl .drawArraysInstanced (gl .TRIANGLES, 0, this .vertexCount, shapeNode .getNumInstances ());
   },
   displayInstanced (gl, renderContext, shapeNode)
   {
      const
         { viewport, appearanceNode, modelViewMatrix } = renderContext,
         browser         = this .getBrowser (),
         primitiveMode   = browser .getPrimitiveMode (gl .TRIANGLES),
         renderModeNodes = appearanceNode .getRenderModes (),
         shaderNode      = appearanceNode .getShader (this, renderContext);

      // Set viewport.

      gl .viewport (... viewport);

      // Enable render mode nodes.

      for (const node of renderModeNodes)
         node .enable (gl);

      // Handle negative scale.

      const positiveScale = Matrix4/* default */.A .prototype .determinant3 .call (modelViewMatrix) >= 0;

      gl .frontFace (positiveScale ? this .frontFace : this .backFace);

      // Draw front and back faces.

      if (this .solid || !appearanceNode .getBackMaterial ())
      {
         this .displayInstancedGeometry (gl, renderContext, shaderNode, primitiveMode, true, true, shapeNode);
      }
      else
      {
         const backShaderNode = appearanceNode .getBackShader (this, renderContext);

         this .displayInstancedGeometry (gl, renderContext, backShaderNode, primitiveMode, true,  false, shapeNode);
         this .displayInstancedGeometry (gl, renderContext, shaderNode,     primitiveMode, false, true,  shapeNode);
      }

      // Disable render mode nodes.

      for (const node of renderModeNodes)
         node .disable (gl);

      // Reset texture units.

      browser .resetTextureUnits ();
   },
   displayInstancedGeometry (gl, renderContext, shaderNode, primitiveMode, back, front, shapeNode)
   {
      // Setup shader.

      shaderNode .enable (gl);
      shaderNode .setUniforms (gl, renderContext, this, front);

      // Setup vertex attributes.

      const instances = shapeNode .getInstances ();

      if (instances .vertexArrayObject .update (this .updateInstances) .enable (shaderNode .getProgram ()))
      {
         const { instancesStride, particleOffset, velocityOffset, matrixOffset, normalMatrixOffset } = shapeNode;

         const
            attribNodes   = this .getAttrib (),
            attribBuffers = this .getAttribBuffers ();

         if (particleOffset !== undefined)
            shaderNode .enableParticleAttribute (gl, instances, instancesStride, particleOffset, 1);

         if (velocityOffset !== undefined)
            shaderNode .enableParticleVelocityAttribute (gl, instances, instancesStride, velocityOffset, 1);

         shaderNode .enableInstanceMatrixAttribute (gl, instances, instancesStride, matrixOffset, 1);

         if (normalMatrixOffset !== undefined)
            shaderNode .enableInstanceNormalMatrixAttribute (gl, instances, instancesStride, normalMatrixOffset, 1);

         if (this .coordIndices .length)
            shaderNode .enableCoordIndexAttribute (gl, this .coordIndexBuffer, 0, 0);

         for (let i = 0, length = attribNodes .length; i < length; ++ i)
            attribNodes [i] .enable (gl, shaderNode, attribBuffers [i]);

         if (this .hasFogCoords)
            shaderNode .enableFogDepthAttribute (gl, this .fogDepthBuffer, 0, 0);

         if (this .colorMaterial)
            shaderNode .enableColorAttribute (gl, this .colorBuffer, 0, 0);

         if (this .hasTangents)
            shaderNode .enableTangentAttribute  (gl, this .tangentBuffer, 0, 0);

         shaderNode .enableTexCoordAttribute (gl, this .texCoordBuffers, 0, 0);
         shaderNode .enableNormalAttribute   (gl, this .normalBuffer,    0, 0);
         shaderNode .enableVertexAttribute   (gl, this .vertexBuffer,    0, 0);

         this .updateInstances = false;
      }

      // Draw depending on wireframe, solid and transparent.

      if (renderContext .transparent || back !== front)
      {
         // Render transparent or back or front.

         gl .enable (gl .CULL_FACE);

         if (back && !this .solid)
         {
            gl .cullFace (gl .FRONT);
            gl .drawArraysInstanced (primitiveMode, 0, this .vertexCount, shapeNode .getNumInstances ());
         }

         if (front)
         {
            gl .cullFace (gl .BACK);
            gl .drawArraysInstanced (primitiveMode, 0, this .vertexCount, shapeNode .getNumInstances ());
         }
      }
      else
      {
         // Render solid or both sides.

         if (this .solid)
            gl .enable (gl .CULL_FACE);
         else
            gl .disable (gl .CULL_FACE);

         gl .drawArraysInstanced (primitiveMode, 0, this .vertexCount, shapeNode .getNumInstances ());
      }
   },
},
// Common functions for all X3DComposedGeometryNode types and some other nodes:
{
   getFogCoord ()
   {
      return this .fogCoordNode;
   },
   getColor ()
   {
      return this .colorNode;
   },
   getTexCoord ()
   {
      return this .texCoordNode;
   },
   getTangent ()
   {
      return this .tangentNode;
   },
   getNormal ()
   {
      return this .normalNode;
   },
   getCoord ()
   {
      return this .coordNode;
   },
   set_attrib__ ()
   {
      const attribNodes = this .getAttrib ();

      for (const attribNode of attribNodes)
      {
         attribNode .removeInterest ("requestRebuild", this);
         attribNode ._attribute_changed .removeInterest ("updateVertexArrays", this);
      }

      attribNodes .length = 0;

      for (const node of this ._attrib)
      {
         const attribNode = (0,X3DCast/* default */.A) (X3DConstants/* default */.A .X3DVertexAttributeNode, node);

         if (attribNode)
            attribNodes .push (attribNode);
      }

      for (const attribNode of attribNodes)
      {
         attribNode .addInterest ("requestRebuild", this);
         attribNode ._attribute_changed .addInterest ("updateVertexArrays", this);
      }

      this .updateVertexArrays ();
   },
   set_fogCoord__ ()
   {
      this .fogCoordNode ?.removeInterest ("requestRebuild", this);

      this .fogCoordNode = (0,X3DCast/* default */.A) (X3DConstants/* default */.A .FogCoordinate, this ._fogCoord);

      this .fogCoordNode ?.addInterest ("requestRebuild", this);
   },
   set_color__ ()
   {
      this .colorNode ?.removeInterest ("requestRebuild", this);

      this .colorNode = (0,X3DCast/* default */.A) (X3DConstants/* default */.A .X3DColorNode, this ._color);

      this .colorNode ?.addInterest ("requestRebuild", this);

      this .setTransparent (this .colorNode ?.isTransparent ());
   },
   set_texCoord__ ()
   {
      this .texCoordNode ?.removeInterest ("requestRebuild", this);

      this .texCoordNode = (0,X3DCast/* default */.A) (X3DConstants/* default */.A .X3DTextureCoordinateNode, this ._texCoord);

      this .texCoordNode ?.addInterest ("requestRebuild", this);

      this .setTextureCoordinate (this .texCoordNode);
   },
   set_tangent__ ()
   {
      this .tangentNode ?.removeInterest ("requestRebuild", this);

      this .tangentNode = (0,X3DCast/* default */.A) (X3DConstants/* default */.A .X3DTangentNode, this ._tangent);

      this .tangentNode ?.addInterest ("requestRebuild", this);
   },
   set_normal__ ()
   {
      this .normalNode ?.removeInterest ("requestRebuild", this);

      this .normalNode = (0,X3DCast/* default */.A) (X3DConstants/* default */.A .X3DNormalNode, this ._normal);

      this .normalNode ?.addInterest ("requestRebuild", this);
   },
   set_coord__ ()
   {
      this .coordNode ?.removeInterest ("requestRebuild", this);

      this .coordNode = (0,X3DCast/* default */.A) (X3DConstants/* default */.A .X3DCoordinateNode, this ._coord);

      this .coordNode ?.addInterest ("requestRebuild", this);
   },
});

Object .defineProperties (X3DGeometryNode, X3DNode/* default */.A .getStaticProperties ("X3DGeometryNode", "Rendering", 1));

const X3DGeometryNode_default_ = X3DGeometryNode;
;

/* harmony default export */ const Rendering_X3DGeometryNode = (Namespace/* default */.A .add ("X3DGeometryNode", X3DGeometryNode_default_));

/***/ },

/***/ 7587
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(1743);
/* harmony import */ var _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(3411);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(8427);



function X3DAppearanceChildNode (executionContext)
{
   _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .call (this, executionContext);

   this .addType (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .X3DAppearanceChildNode);
}

Object .setPrototypeOf (X3DAppearanceChildNode .prototype, _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .prototype);

Object .defineProperties (X3DAppearanceChildNode, _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .getStaticProperties ("X3DAppearanceChildNode", "Shape", 1));

const __default__ = X3DAppearanceChildNode;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .add ("X3DAppearanceChildNode", __default__));

/***/ },

/***/ 3113
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Fields_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(9818);
/* harmony import */ var _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(3927);
/* harmony import */ var _Base_FieldDefinitionArray_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(5373);
/* harmony import */ var _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(1743);
/* harmony import */ var _X3DTexture2DNode_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(9197);
/* harmony import */ var _Networking_X3DUrlObject_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(7274);
/* harmony import */ var _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(3411);
/* harmony import */ var _DEVELOPMENT_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(1476);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(8427);
/* provided dependency */ var $ = __webpack_require__(8316)["default"];









function ImageTexture (executionContext)
{
   _X3DTexture2DNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .call (this, executionContext);
   _Networking_X3DUrlObject_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A     .call (this, executionContext);

   this .addType (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .ImageTexture);

   this .image    = $("<img></img>");
   this .urlStack = new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFString ();

   this .getMatrix () .set ([1, 0, 0, 0, 0, -1, 0, 0, 0, 0, 1, 0, 0, 1, 0, 1]); // flipY
}

Object .assign (Object .setPrototypeOf (ImageTexture .prototype, _X3DTexture2DNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .prototype),
   _Networking_X3DUrlObject_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .prototype,
{
   initialize ()
   {
      _X3DTexture2DNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .prototype .initialize .call (this);
      _Networking_X3DUrlObject_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A     .prototype .initialize .call (this);

      this ._colorSpaceConversion .addInterest ("loadNow", this);

      this .image
         .on ("load", this .setImage .bind (this))
         .on ("abort error", this .setError .bind (this))
         .attr ("crossorigin", "anonymous");

      this .requestImmediateLoad () .catch (Function .prototype);
   },
   getTextureType ()
   {
      return 1;
   },
   unloadData ()
   {
      this .clearTexture ();
   },
   loadData ()
   {
      this .urlStack .setValue (this ._url);
      this .loadNext ();
   },
   loadNext ()
   {
      if (this .urlStack .length === 0)
      {
         this .clearTexture ();
         this .setLoadState (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .FAILED_STATE);
         return;
      }

      // Get URL.

      this .URL = new URL (this .urlStack .shift (), this .getExecutionContext () .getBaseURL ());

      if (this .URL .pathname .match (/\.ktx2?(?:\.gz)?$/) || this .URL .href .match (/^data:image\/ktx2[;,]/))
      {
         this .setLinear (true);
         this .setMipMaps (false);

         this .getBrowser () .getKTXDecoder ()
            .then (decoder => decoder .loadKTXFromURL (this .URL, this .getCache ()))
            .then (texture => this .setKTXTexture (texture))
            .catch (error => this .setError ({ type: error .message }));
      }
      else
      {
         this .setLinear (false);
         this .setMipMaps (true);

         if (this .URL .protocol !== "data:")
         {
            if (!this .getCache ())
               this .URL .searchParams .set ("_", Date .now ());
         }

         this .image .attr ("src", this .URL);
      }
   },
   setError (event)
   {
      if (this .URL .protocol !== "data:")
         console .warn (`Error loading image '${decodeURI (this .URL)}:'`, event .type);

      this .loadNext ();
   },
   setKTXTexture (texture)
   {
      if (texture .target !== this .getTarget ())
         return this .setError ({ type: "Invalid KTX texture target, must be 'TEXTURE_2D'." });

      if (_DEVELOPMENT_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A)
      {
         if (this .URL .protocol !== "data:")
            console .info (`Done loading image texture '${decodeURI (this .URL)}'.`);
      }

      try
      {
         this .setTexture (texture);
         this .setTransparent (false);
         this .setWidth (texture .baseWidth);
         this .setHeight (texture .baseHeight);
         this .updateTextureParameters ();

         this .setLoadState (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .COMPLETE_STATE);
      }
      catch (error)
      {
         // Catch security error from cross origin requests.
         this .setError ({ type: error .message });
      }
   },
   setImage ()
   {
      if (_DEVELOPMENT_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A)
      {
         if (this .URL .protocol !== "data:")
            console .info (`Done loading image texture '${decodeURI (this .URL)}'.`);
      }

      try
      {
         const
            image             = this .image [0],
            { width, height } = image;

         // Upload image to GPU.

         this .setTextureData (width, height, this ._colorSpaceConversion .getValue (), this .isTransparent (), image);
         this .setTransparent (this .isImageTransparent (this .getTextureData (this .getTexture (), width, height)));
         this .setLoadState (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .COMPLETE_STATE);
         this .addNodeEvent ();
      }
      catch (error)
      {
         // Catch security error from cross origin requests.
         this .setError ({ type: error .message });
      }
   },
   dispose ()
   {
      _Networking_X3DUrlObject_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A     .prototype .dispose .call (this);
      _X3DTexture2DNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .prototype .dispose .call (this);
   },
});

Object .defineProperties (ImageTexture,
{
   ... _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .getStaticProperties ("ImageTexture", "Texturing", 1, "texture", "2.0"),
   fieldDefinitions:
   {
      value: new _Base_FieldDefinitionArray_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A ([
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .inputOutput,    "metadata",             new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFNode ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .inputOutput,    "description",          new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFString ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .inputOutput,    "load",                 new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFBool (true)),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .inputOutput,    "url",                  new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFString ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .inputOutput,    "autoRefresh",          new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFTime (0)),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .inputOutput,    "autoRefreshTimeLimit", new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFTime (3600)),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .initializeOnly, "colorSpaceConversion", new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFBool (true)), // experimental
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .initializeOnly, "repeatS",              new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFBool (true)),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .initializeOnly, "repeatT",              new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFBool (true)),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .initializeOnly, "textureProperties",    new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFNode ()),
      ]),
      enumerable: true,
   },
});

const __default__ = ImageTexture;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_8__/* ["default"] */ .A .add ("ImageTexture", __default__));

/***/ },

/***/ 3599
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Fields_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(9818);
/* harmony import */ var _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(1743);
/* harmony import */ var _X3DTextureNode_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(9491);
/* harmony import */ var _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(3411);
/* harmony import */ var _Base_X3DCast_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(7995);
/* harmony import */ var _standard_Math_Numbers_Matrix4_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(6776);
/* harmony import */ var _standard_Math_Algorithm_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(9919);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(8427);








function X3DSingleTextureNode (executionContext)
{
   _X3DTextureNode_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .call (this, executionContext);

   this .addType (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .X3DSingleTextureNode);

   this .addChildObjects (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .outputOnly, "linear", new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFBool ())

   this .matrix = new Float32Array (_standard_Math_Numbers_Matrix4_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .IDENTITY);
}

Object .assign (Object .setPrototypeOf (X3DSingleTextureNode .prototype, _X3DTextureNode_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .prototype),
{
   initialize ()
   {
      _X3DTextureNode_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .prototype .initialize .call (this);

      this ._textureProperties .addInterest ("set_textureProperties__", this, true);

      const gl = this .getBrowser () .getContext ();

      this .texture = gl .createTexture ();

      this .set_textureProperties__ (false);
   },
   getCount ()
   {
      return 1;
   },
   getTextureTypeString ()
   {
      switch (this .getTextureType ())
      {
         case 1:                // ImageTexture, MovieTexture (flipY)
         case 2: return "2D";   // PixelTexture
         case 3: return "3D";   // X3DTexture3DNode
         case 4: return "CUBE"; // X3DEnvironmentTextureNode
      }
   },
   getTexture ()
   {
      return this .texture;
   },
   setTexture (texture)
   {
      const gl = this .getBrowser () .getContext ();

      gl .deleteTexture (this .texture);

      this .texture = texture;

      this .addNodeEvent ();
   },
   isLinear ()
   {
      return this ._linear .getValue ();
   },
   setLinear (value)
   {
      if (!!value !== this ._linear .getValue ())
         this ._linear = value;
   },
   canMipMaps ()
   {
      return this .mipMaps;
   },
   setMipMaps (value)
   {
      this .mipMaps = value;
   },
   getMatrix ()
   {
      // Normally the identity matrix or a flipY matrix.
      return this .matrix;
   },
   isImageTransparent (data)
   {
      const length = data .length;

      for (let i = 3; i < length; i += 4)
      {
         if (data [i] !== 255)
            return true;
      }

      return false;
   },
   set_textureProperties__ (update)
   {
      if (this .texturePropertiesNode)
         this .texturePropertiesNode .removeInterest ("updateTextureParameters", this);

      this .texturePropertiesNode = (0,_Base_X3DCast_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A) (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .TextureProperties, this ._textureProperties)
         ?? this .getBrowser () .getDefaultTextureProperties ();

      this .texturePropertiesNode .addInterest ("updateTextureParameters", this);

      if (update)
         this .updateTextureParameters ();
   },
   updateTextureParameters (target, haveTextureProperties, textureProperties, width, height, repeatS, repeatT, repeatR)
   {
      const
         browser = this .getBrowser (),
         gl      = browser .getContext ();

      gl .bindTexture (target, this .getTexture ());

      if (!haveTextureProperties && Math .max (width, height) < browser .getMinTextureSize ())
      {
         // Don't generate MipMaps.
         gl .texParameteri (target, gl .TEXTURE_MIN_FILTER, gl .NEAREST);
         gl .texParameteri (target, gl .TEXTURE_MAG_FILTER, gl .NEAREST);
      }
      else if (this .canMipMaps () && textureProperties ._generateMipMaps .getValue ())
      {
         // Can MipMaps and wants MipMaps.
         gl .generateMipmap (target);

         gl .texParameteri (target, gl .TEXTURE_MIN_FILTER, gl [textureProperties .getMinificationFilter ()]);
         gl .texParameteri (target, gl .TEXTURE_MAG_FILTER, gl [textureProperties .getMagnificationFilter ()]);
      }
      else
      {
         // No MipMaps.
         gl .texParameteri (target, gl .TEXTURE_MIN_FILTER, gl [textureProperties .getMinificationFilter (false)]);
         gl .texParameteri (target, gl .TEXTURE_MAG_FILTER, gl [textureProperties .getMagnificationFilter (false)]);
      }

      if (haveTextureProperties)
      {
         gl .texParameteri (target, gl .TEXTURE_WRAP_S, gl [textureProperties .getBoundaryModeS ()]);
         gl .texParameteri (target, gl .TEXTURE_WRAP_T, gl [textureProperties .getBoundaryModeT ()]);
         gl .texParameteri (target, gl .TEXTURE_WRAP_R, gl [textureProperties .getBoundaryModeR ()]);
      }
      else
      {
         gl .texParameteri (target, gl .TEXTURE_WRAP_S, repeatS ? gl .REPEAT : gl .CLAMP_TO_EDGE);
         gl .texParameteri (target, gl .TEXTURE_WRAP_T, repeatT ? gl .REPEAT : gl .CLAMP_TO_EDGE);
         gl .texParameteri (target, gl .TEXTURE_WRAP_R, repeatR ? gl .REPEAT : gl .CLAMP_TO_EDGE);
      }

      //gl .texParameterfv (target, gl .TEXTURE_BORDER_COLOR, textureProperties ._borderColor .getValue ());
      //gl .texParameterf  (target, gl .TEXTURE_PRIORITY,     textureProperties ._texturePriority .getValue ());

      const ext = browser .getAnisotropicExtension ();

      if (ext)
      {
         const max = gl .getParameter (ext .MAX_TEXTURE_MAX_ANISOTROPY_EXT);

         gl .texParameterf (target, ext .TEXTURE_MAX_ANISOTROPY_EXT, _standard_Math_Algorithm_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .clamp (textureProperties ._anisotropicDegree .getValue (), 0, max));
      }
   },
   getTextureBits ()
   {
      return (this .isLinear () << 3) | this .getTextureType ();
   },
   updateTextureBits (textureBits, channel = 0)
   {
      textureBits .add (channel * 4, this .getTextureBits ());
   },
   getShaderOptions (options, name = 0, ext = false)
   {
      if (typeof name === "number")
      {
         options .push (`X3D_TEXTURE_${name}_${this .getTextureTypeString ()}`);

         if (this .getTextureType () === 1)
            options .push (`X3D_TEXTURE_${name}_FLIP_Y`);

         if (this .isLinear ())
            options .push (`X3D_TEXTURE_${name}_LINEAR`);
      }
      else
      {
         ext = ext ? "_EXT" : "";

         options .push (`X3D_${name}_TEXTURE${ext}`, `X3D_${name}_TEXTURE${ext}_${this .getTextureTypeString ()}`);

         if (this .getTextureType () === 1)
            options .push (`X3D_${name}_TEXTURE${ext}_FLIP_Y`);

         if (this .isLinear ())
            options .push (`X3D_${name}_TEXTURE${ext}_LINEAR`);
      }
   },
   setNamedShaderUniforms (gl, uniformStruct, mapping, textureTransformMapping, textureCoordinateMapping)
   {
      this .setShaderUniforms (gl, uniformStruct);

      gl .uniform1i (uniformStruct .textureTransformMapping,  textureTransformMapping  .get (mapping) ?? 0);
      gl .uniform1i (uniformStruct .textureCoordinateMapping, textureCoordinateMapping .get (mapping) ?? 0);
   },
});

Object .defineProperties (X3DSingleTextureNode, _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .getStaticProperties ("X3DSingleTextureNode", "Texturing", 1));

const __default__ = X3DSingleTextureNode;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .add ("X3DSingleTextureNode", __default__));

/***/ },

/***/ 9197
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(1743);
/* harmony import */ var _X3DSingleTextureNode_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(3599);
/* harmony import */ var _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(3411);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(8427);




const defaultData = new Uint8Array ([ 255, 255, 255, 255 ]);

function X3DTexture2DNode (executionContext)
{
   _X3DSingleTextureNode_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .call (this, executionContext);

   this .addType (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .X3DTexture2DNode);

   const gl = this .getBrowser () .getContext ();

   this .target = gl .TEXTURE_2D;
   this .width  = 0;
   this .height = 0;
}

Object .assign (Object .setPrototypeOf (X3DTexture2DNode .prototype, _X3DSingleTextureNode_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .prototype),
{
   initialize ()
   {
      _X3DSingleTextureNode_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .prototype .initialize .call (this);

      this ._repeatS .addInterest ("updateTextureParameters", this);
      this ._repeatT .addInterest ("updateTextureParameters", this);

      const gl = this .getBrowser () .getContext ();

      gl .bindTexture (gl .TEXTURE_2D, this .getTexture ());
      gl .texImage2D  (gl .TEXTURE_2D, 0, gl .RGBA, 1, 1, 0, gl .RGBA, gl .UNSIGNED_BYTE, defaultData);
   },
   getTarget ()
   {
      return this .target;
   },
   getWidth ()
   {
      return this .width;
   },
   setWidth (value)
   {
      this .width = value;
   },
   getHeight ()
   {
      return this .height;
   },
   setHeight (value)
   {
      this .height = value;
   },
   clearTexture ()
   {
      this .setTextureData (1, 1, false, false, defaultData);
   },
   getTextureData (texture = this .getTexture (), width = this .getWidth (), height = this .getHeight ())
   {
      const
         gl          = this .getBrowser () .getContext (),
         framebuffer = gl .createFramebuffer (),
         data        = new Uint8Array (width * height * 4);

      gl .bindFramebuffer (gl .FRAMEBUFFER, framebuffer);
      gl .framebufferTexture2D (gl .FRAMEBUFFER, gl .COLOR_ATTACHMENT0, gl .TEXTURE_2D, texture, 0);
      gl .readPixels (0, 0, width, height, gl .RGBA, gl .UNSIGNED_BYTE, data);
      gl .deleteFramebuffer (framebuffer);

      return data;
   },
   setTextureData (width, height, colorSpaceConversion, transparent, data)
   {
      this .width  = width;
      this .height = height;

      const
         gl  = this .getBrowser () .getContext (),
         max = gl .getParameter (gl .MAX_TEXTURE_SIZE);

      if (width > max || height > max)
      {
         throw new Error (`At least one dimension (${width} × ${height}) is greater than the maximum texture size (${max} px).`);
      }

      gl .bindTexture (gl .TEXTURE_2D, this .getTexture ());
      gl .pixelStorei (gl .UNPACK_COLORSPACE_CONVERSION_WEBGL, colorSpaceConversion ? gl .BROWSER_DEFAULT_WEBGL : gl .NONE);
      gl .texImage2D  (gl .TEXTURE_2D, 0, gl .RGBA, width, height, 0, gl .RGBA, gl .UNSIGNED_BYTE, data);
      gl .pixelStorei (gl .UNPACK_COLORSPACE_CONVERSION_WEBGL, gl .BROWSER_DEFAULT_WEBGL);

      this .setTransparent (transparent);
      this .updateTextureParameters ();
      this .addNodeEvent ();
   },
   updateTextureData (data)
   {
      const gl = this .getBrowser () .getContext ();

      gl .bindTexture (gl .TEXTURE_2D, this .getTexture ());
      gl .texSubImage2D (gl .TEXTURE_2D, 0, 0, 0, gl .RGBA, gl .UNSIGNED_BYTE, data);

      if (this .texturePropertiesNode ._generateMipMaps .getValue ())
         gl .generateMipmap (gl .TEXTURE_2D);

      this .addNodeEvent ();
   },
   updateTextureParameters ()
   {
      _X3DSingleTextureNode_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .prototype .updateTextureParameters .call (this,
                                                                      this .target,
                                                                      this ._textureProperties .getValue (),
                                                                      this .texturePropertiesNode,
                                                                      this .width,
                                                                      this .height,
                                                                      this ._repeatS .getValue (),
                                                                      this ._repeatT .getValue (),
                                                                      false);
   },
   setShaderUniforms (gl, channel)
   {
      const textureUnit = this .getBrowser () .popTextureUnit ();

      gl .activeTexture (gl .TEXTURE0 + textureUnit);
      gl .bindTexture (gl .TEXTURE_2D, this .getTexture ());
      gl .uniform1i (channel .texture2D, textureUnit);
   },
});

Object .defineProperties (X3DTexture2DNode, _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .getStaticProperties ("X3DTexture2DNode", "Texturing", 1));

const __default__ = X3DTexture2DNode;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .add ("X3DTexture2DNode", __default__));

/***/ },

/***/ 9491
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Fields_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(9818);
/* harmony import */ var _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(1743);
/* harmony import */ var _Shape_X3DAppearanceChildNode_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(7587);
/* harmony import */ var _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(3411);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(8427);





function X3DTextureNode (executionContext)
{
   _Shape_X3DAppearanceChildNode_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .call (this, executionContext);

   this .addType (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .X3DTextureNode);

   this .addChildObjects (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .outputOnly, "transparent", new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFBool ());
}

Object .assign (Object .setPrototypeOf (X3DTextureNode .prototype, _Shape_X3DAppearanceChildNode_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .prototype),
{
   setTransparent (value)
   {
      if (!!value !== this ._transparent .getValue ())
         this ._transparent = value;
   },
   isTransparent ()
   {
      return this ._transparent .getValue ();
   },
});

Object .defineProperties (X3DTextureNode, _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .getStaticProperties ("X3DTextureNode", "Texturing", 1));

const __default__ = X3DTextureNode;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .add ("X3DTextureNode", __default__));

/***/ },

/***/ 7867
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Fields_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(9818);
/* harmony import */ var _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(3927);
/* harmony import */ var _Base_FieldDefinitionArray_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(5373);
/* harmony import */ var _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(1743);
/* harmony import */ var _Core_X3DSensorNode_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(2905);
/* harmony import */ var _X3DTimeDependentNode_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(9605);
/* harmony import */ var _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(3411);
/* harmony import */ var _standard_Math_Algorithm_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(9919);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(8427);









function TimeSensor (executionContext)
{
   _Core_X3DSensorNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A        .call (this, executionContext);
   _X3DTimeDependentNode_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .call (this, executionContext);

   this .addType (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .TimeSensor);

   this .addChildObjects (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .inputOutput, "range", new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFFloat (0, 0, 1)); // current, first, last (in fractions) - play range starting at current

   this .cycle    = 0;
   this .interval = 0;
   this .fraction = 0;
   this .first    = 0;
   this .last     = 1;
   this .scale    = 1;
}

Object .assign (Object .setPrototypeOf (TimeSensor .prototype, _Core_X3DSensorNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .prototype),
   _X3DTimeDependentNode_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .prototype,
{
   initialize ()
   {
      _Core_X3DSensorNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A        .prototype .initialize .call (this);
      _X3DTimeDependentNode_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .prototype .initialize .call (this);

      this ._cycleInterval .addInterest ("set_cycleInterval__", this);
      this ._range         .addInterest ("set_range__",         this);
   },
   setRange (fraction, firstFraction, lastFraction, offset)
   {
      const
         currentTime   = this .getBrowser () .getCurrentTime (),
         startTime     = this ._startTime .getValue (),
         cycleInterval = this ._cycleInterval .getValue ();

      this .first    = _standard_Math_Algorithm_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .clamp (firstFraction, 0, 1);
      this .last     = _standard_Math_Algorithm_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .clamp (lastFraction, 0, 1);
      this .scale    = this .last - this .first;
      this .interval = cycleInterval * this .scale;
      this .offset   = offset && this .interval ? (currentTime - startTime) / this .interval : 0;
      this .fraction = _standard_Math_Algorithm_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .fract (fraction + this .offset);
      this .cycle    = currentTime - (this .fraction - this .first) * cycleInterval;
   },
   set_cycleInterval__ ()
   {
      if (!this ._isActive .getValue ())
         return;

      this .setRange (this .fraction, this ._range [1], this ._range [2], false);
   },
   set_range__ ()
   {
      if (!this ._isActive .getValue ())
         return;

      this .setRange (this ._range [0], this ._range [1], this ._range [2], false);

      if (this ._isPaused .getValue ())
         return;

      this .set_fraction (this .getBrowser () .getCurrentTime ());
   },
   set_start ()
   {
      this .setRange (this ._range [0], this ._range [1], this ._range [2], true);

      const time = this .getBrowser () .getCurrentTime ();

      this ._time             = time;
      this ._cycleTime        = time;
      this ._fraction_changed = this .fraction;
   },
   set_resume (pauseInterval)
   {
      this .setRange (this .fraction, this ._range [1], this ._range [2], false);
   },
   set_fraction (time)
   {
      const fraction = this .first + (this .interval ? _standard_Math_Algorithm_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .fract ((time - this .cycle) / this .interval) : 0) * this .scale;

      this .fraction          = fraction;
      this ._fraction_changed = fraction;
   },
   set_time ()
   {
      // The event order below is very important.

      const time = this .getBrowser () .getCurrentTime ();

      this ._time