/* X_ITE v12.2.6 */
(function webpackUniversalModuleDefinition(root, factory) {
	if(typeof exports === 'object' && typeof module === 'object')
		module.exports = factory();
	else if(typeof define === 'function' && define.amd)
		define([], factory);
	else if(typeof exports === 'object')
		exports["X3D"] = factory();
	else
		root["X3D"] = factory();
})(self, () => {
return /******/ (() => { // webpackBootstrap
/******/ 	var __webpack_modules__ = ({

/***/ 41
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(7910);
/* harmony import */ var _Numbers_Matrix4_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(2597);
/* harmony import */ var _x_ite_Namespace_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(6334);



const
   point     = new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A (),
   invMatrix = new _Numbers_Matrix4_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A ();

function Plane3 (point = _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .ZERO, normal = _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .Z_AXIS)
{
   this .normal = new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A ();

   this .set (point, normal);
}

Object .assign (Plane3 .prototype,
{
   copy ()
   {
      const copy = Object .create (Plane3 .prototype);

      copy .normal             = this .normal .copy ();
      copy .distanceFromOrigin = this .distanceFromOrigin;

      return copy;
   },
   assign (plane)
   {
      this .normal .assign (plane .normal);
      this .distanceFromOrigin = plane .distanceFromOrigin;

      return this;
   },
   equals (plane)
   {
      return this .distanceFromOrigin === plane .distanceFromOrigin && this .normal .equals (plane .normal);
   },
   set (point = _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .ZERO, normal = _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .Z_AXIS)
   {
      this .normal .assign (normal);
      this .distanceFromOrigin = normal .dot (point);
      return this;
   },
   multLeft (matrix)
   {
      // Taken from Inventor:

      // Find the point on the plane along the normal from the origin
      point .assign (this .normal) .multiply (this .distanceFromOrigin);

      // Transform the plane normal by the matrix
      // to get the new normal. Use the inverse transpose
      // of the matrix so that normals are not scaled incorrectly.
      // n' = !~m * n = n * ~m
      invMatrix .assign (matrix) .submatrix .inverse ()
         .multVecMatrix (this .normal) .normalize ();

      // Transform the point by the matrix
      matrix .multMatrixVec (point);

      // The new distance is the projected distance of the vector to the
      // transformed point onto the (unit) transformed normal. This is
      // just a dot product.
      this .distanceFromOrigin = this .normal .dot (point);

      return this;
   },
   multRight (matrix)
   {
      // Taken from Inventor:

      // Find the point on the plane along the normal from the origin
      point .assign (this .normal) .multiply (this .distanceFromOrigin);

      // Transform the plane normal by the matrix
      // to get the new normal. Use the inverse transpose
      // of the matrix so that normals are not scaled incorrectly.
      // n' = n * !~m = ~m * n
      invMatrix .assign (matrix) .submatrix .inverse ()
         .multMatrixVec (this .normal) .normalize ();

      // Transform the point by the matrix
      matrix .multVecMatrix (point);

      // The new distance is the projected distance of the vector to the
      // transformed point onto the (unit) transformed normal. This is
      // just a dot product.
      this .distanceFromOrigin = this .normal .dot (point);

      return this;
   },
   getDistanceToPoint (point)
   {
      return point .dot (this .normal) - this .distanceFromOrigin;
   },
   getPerpendicularVectorToPoint (point, result = new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A ())
   {
      return result .assign (this .normal) .multiply (-this .getDistanceToPoint (point));
   },
   getClosestPointToPoint (point, result = new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A ())
   {
      return this .getPerpendicularVectorToPoint (point, result) .add (point);
   },
   intersectsLine (line, intersection)
   {
      const { point, direction } = line;

      // Check if the line is parallel to the plane.
      const theta = direction .dot (this .normal);

      // Plane and line are parallel.
      if (theta === 0)
         return false;

      // Plane and line are not parallel. The intersection point can be calculated now.
      const t = (this .distanceFromOrigin - this .normal .dot (point)) / theta;

      intersection .assign (direction) .multiply (t) .add (point);

      return true;
   },
   toString ()
   {
      return `${this .normal}, ${this .distanceFromOrigin}`;
   },
});

const __default__ = Plane3;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_x_ite_Namespace_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .add ("Plane3", __default__));

/***/ },

/***/ 151
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _x_ite_Namespace_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6334);
class MatrixStack extends Array
{
   #top = 0;

   constructor (Type)
   {
      super ();

      this .push (new Type ());
   }

   set (matrix)
   {
      this [this .#top] .assign (matrix);
   }

   get ()
   {
      return this [this .#top];
   }

   push (matrix = this [this .#top])
   {
      const top = ++ this .#top;

      if (top < this .length)
         this [top] .assign (matrix);
      else
         this [top] = matrix .copy ();
   }

   pop ()
   {
      -- this .#top;
   }

   clear ()
   {
      this .#top = 0;
   }

   size ()
   {
      return this .#top + 1;
   }

   identity ()
   {
      this [this .#top] .identity ();
   }

   inverse ()
   {
      this [this .#top] .inverse ();
   }

   multRight (matrix)
   {
      this [this .#top] .multRight (matrix);
   }

   multLeft (matrix)
   {
      this [this .#top] .multLeft (matrix);
   }

   translate (vector)
   {
      this [this .#top] .translate (vector);
   }

   rotate (rotation)
   {
      this [this .#top] .rotate (rotation);
   }

   scale (vector)
   {
      this [this .#top] .scale (vector);
   }
}

const __default__ = MatrixStack;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_x_ite_Namespace_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .add ("MatrixStack", __default__));

/***/ },

/***/ 164
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(8450);
/* harmony import */ var _X3DChildNode_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(266);
/* harmony import */ var _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(4946);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(6334);




function X3DSensorNode (executionContext)
{
   _X3DChildNode_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .call (this, executionContext);

   this .addType (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .X3DSensorNode);
}

Object .setPrototypeOf (X3DSensorNode .prototype, _X3DChildNode_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .prototype);

Object .defineProperties (X3DSensorNode, _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .getStaticProperties ("X3DSensorNode", "Core", 1));

const __default__ = X3DSensorNode;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .add ("X3DSensorNode", __default__));

/***/ },

/***/ 171
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Base_X3DInfoArray_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(3046);
/* harmony import */ var _X3DRoute_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(4609);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(6334);



function RouteArray (values = [ ])
{
   return _Base_X3DInfoArray_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .call (this, Array .from (values, value => [value .getId (), value]), _X3DRoute_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A);
}

Object .setPrototypeOf (RouteArray .prototype, _Base_X3DInfoArray_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .prototype);

for (const key of Object .keys (RouteArray .prototype))
   Object .defineProperty (RouteArray .prototype, key, { enumerable: false });

Object .defineProperties (RouteArray,
{
   typeName:
   {
      value: "RouteArray",
      enumerable: true,
   },
});

const __default__ = RouteArray;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .add ("RouteArray", __default__));

/***/ },

/***/ 266
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Fields_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(3515);
/* harmony import */ var _X3DNode_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(8450);
/* harmony import */ var _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(4946);
/* harmony import */ var _Rendering_TraverseType_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(5465);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(6334);





function X3DChildNode (executionContext)
{
   if (this .getExecutionContext ())
      return;

   _X3DNode_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .call (this, executionContext);

   this .addType (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .X3DChildNode);

   this .addChildObjects (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .outputOnly, "isBoundedObject",   new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFBool (),
                          _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .outputOnly, "isPointingObject",  new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFBool (),
                          _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .outputOnly, "isCameraObject",    new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFBool (),
                          _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .outputOnly, "isPickableObject",  new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFBool (),
                          _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .outputOnly, "isCollisionObject", new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFBool (),
                          _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .outputOnly, "isShadowObject",    new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFBool (),
                          _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .outputOnly, "isVisibleObject",   new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFBool ());
}

Object .assign (Object .setPrototypeOf (X3DChildNode .prototype, _X3DNode_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .prototype),
{
   setBoundedObject (value)
   {
      if (!!value !== this ._isBoundedObject .getValue ())
         this ._isBoundedObject = value;
   },
   isBoundedObject ()
   {
      return this ._isBoundedObject .getValue ();
   },
   setPointingObject (value)
   {
      if (!!value !== this ._isPointingObject .getValue ())
         this ._isPointingObject = value;
   },
   isPointingObject ()
   {
      return this ._isPointingObject .getValue ();
   },
   setCameraObject (value)
   {
      if (!!value !== this ._isCameraObject .getValue ())
         this ._isCameraObject = value;
   },
   isCameraObject ()
   {
      return this ._isCameraObject .getValue ();
   },
   setPickableObject (value)
   {
      if (!!value !== this ._isPickableObject .getValue ())
         this ._isPickableObject = value;
   },
   isPickableObject ()
   {
      return this ._isPickableObject .getValue ();
   },
   setShadowObject (value)
   {
      if (!!value !== this ._isShadowObject .getValue ())
         this ._isShadowObject = value;
   },
   isShadowObject ()
   {
      return this ._isShadowObject .getValue ();
   },
   setCollisionObject (value)
   {
      if (!!value !== this ._isCollisionObject .getValue ())
         this ._isCollisionObject = value;
   },
   isCollisionObject ()
   {
      return this ._isCollisionObject .getValue ();
   },
   setVisibleObject (value)
   {
      if (!!value !== this ._isVisibleObject .getValue ())
         this ._isVisibleObject = value;
   },
   isVisibleObject ()
   {
      return this ._isVisibleObject .getValue ();
   },
   isVisible ()
   {
      // This function will be overloaded by X3DBoundedObject.
      return true;
   },
   connectChildNode (childNode, excludes)
   {
      if (!excludes ?.includes (_Rendering_TraverseType_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .BBOX))
      {
         childNode ._isBoundedObject .addFieldInterest (this ._isBoundedObject);
         this .setBoundedObject (childNode .isBoundedObject ());
      }

      if (!excludes ?.includes (_Rendering_TraverseType_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .POINTER))
      {
         childNode ._isPointingObject .addFieldInterest (this ._isPointingObject);
         this .setPointingObject (childNode .isPointingObject ());
      }

      if (!excludes ?.includes (_Rendering_TraverseType_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .CAMERA))
      {
         childNode ._isCameraObject .addFieldInterest (this ._isCameraObject);
         this .setCameraObject (childNode .isCameraObject ());
      }

      if (!excludes ?.includes (_Rendering_TraverseType_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .PICKING))
      {
         childNode ._isPickableObject .addFieldInterest (this ._isPickableObject);
         this .setPickableObject (childNode .isPickableObject ());
      }

      if (!excludes ?.includes (_Rendering_TraverseType_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .COLLISION))
      {
         childNode ._isCollisionObject .addFieldInterest (this ._isCollisionObject);
         this .setCollisionObject (childNode .isCollisionObject ());
      }

      if (!excludes ?.includes (_Rendering_TraverseType_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .SHADOW))
      {
         childNode ._isShadowObject .addFieldInterest (this ._isShadowObject);
         this .setShadowObject (childNode .isShadowObject ());
      }

      if (!excludes ?.includes (_Rendering_TraverseType_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .DISPLAY))
      {
         childNode ._isVisibleObject .addFieldInterest (this ._isVisibleObject);
         this .setVisibleObject (childNode .isVisibleObject ());
      }
   },
   disconnectChildNode (childNode)
   {
      childNode ._isBoundedObject   .removeFieldInterest (this ._isBoundedObject);
      childNode ._isPointingObject  .removeFieldInterest (this ._isPointingObject);
      childNode ._isCameraObject    .removeFieldInterest (this ._isCameraObject);
      childNode ._isPickableObject  .removeFieldInterest (this ._isPickableObject);
      childNode ._isCollisionObject .removeFieldInterest (this ._isCollisionObject);
      childNode ._isShadowObject    .removeFieldInterest (this ._isShadowObject);
      childNode ._isVisibleObject   .removeFieldInterest (this ._isVisibleObject);
   },
   getShapes (shapes, modelMatrix)
   {
      return shapes;
   },
});

Object .defineProperties (X3DChildNode, _X3DNode_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .getStaticProperties ("X3DChildNode", "Core", 1));

const __default__ = X3DChildNode;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .add ("X3DChildNode", __default__));

/***/ },

/***/ 324
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "default": () => (/* binding */ InputOutput_FileLoader)
});

// EXTERNAL MODULE: ./src/x_ite/Base/X3DObject.js + 4 modules
var X3DObject = __webpack_require__(7092);
// EXTERNAL MODULE: ./src/x_ite/Fields.js + 15 modules
var Fields = __webpack_require__(3515);
// EXTERNAL MODULE: ./src/x_ite/Parser/X3DParser.js
var X3DParser = __webpack_require__(6570);
// EXTERNAL MODULE: ./src/x_ite/Parser/JSONParser.js
var JSONParser = __webpack_require__(8057);
// EXTERNAL MODULE: ./src/x_ite/Parser/VRMLParser.js
var VRMLParser = __webpack_require__(3122);
// EXTERNAL MODULE: ./src/x_ite/Parser/XMLParser.js
var XMLParser = __webpack_require__(7588);
// EXTERNAL MODULE: ./src/standard/Math/Numbers/Vector3.js
var Vector3 = __webpack_require__(7910);
// EXTERNAL MODULE: ./src/standard/Math/Numbers/Rotation4.js
var Rotation4 = __webpack_require__(4580);
// EXTERNAL MODULE: ./src/standard/Math/Numbers/Matrix4.js
var Matrix4 = __webpack_require__(2597);
// EXTERNAL MODULE: ./src/standard/Math/Geometry/Box3.js
var Box3 = __webpack_require__(6524);
// EXTERNAL MODULE: ./src/x_ite/Base/X3DConstants.js
var X3DConstants = __webpack_require__(4946);
// EXTERNAL MODULE: ./src/x_ite/Namespace.js
var Namespace = __webpack_require__(6334);
;// ./src/x_ite/Parser/X3DOptimizer.js






function X3DOptimizer () { }

Object .assign (X3DOptimizer .prototype,
{
   removeEmptyGroups: false,
   combineGroupingNodes: false,
   optimizeInterpolators: false,
   optimizeSceneGraph (nodes)
   {
      const removedNodes = [ ];

      nodes .setValue (this .optimizeNodes (null, nodes, true, removedNodes));

      removedNodes
         .filter (node => node .getValue () .getCloneCount () === 0)
         .forEach (node => node .dispose ());
   },
   optimizeNodes (parent, nodes, combine, removedNodes)
   {
      return Array .from (nodes) .flatMap (node => this .optimizeNode (parent, node, combine, removedNodes));
   },
   optimizeNode (parent, node, combine, removedNodes)
   {
      if (!node)
         return [ ];

      if (this .optimizeInterpolators)
         this .removeInterpolatorsWithOnlyOneValue (node, removedNodes);

      switch (node .getNodeTypeName ())
      {
         case "Transform":
         {
            node .children = this .optimizeNodes (node, node .children, true, removedNodes);

            if (this .removeEmptyGroups)
            {
               if (node .children .length === 0)
                  return [ ];
            }

            break;
         }
         case "Anchor":
         case "Group":
         {
            node .children = this .optimizeNodes (node, node .children, true, removedNodes);

            return this .removeIfNoChildren (node, removedNodes);
         }
         case "Collision":
         case "LOD":
         case "Switch":
         {
            this .optimizeNodes (node, node .children, false, removedNodes);

            return this .removeIfNoChildren (node, removedNodes);
         }
         case "HAnimJoint":
         case "HAnimSegment":
         case "HAnimSite":
         {
            node .children = this .optimizeNodes (node, node .children, true, removedNodes);

            switch (parent ?.getNodeTypeName ())
            {
               case "HAnimHumanoid":
               case "HAnimJoint":
               case "HAnimSegment":
               case "HAnimSite":
               {
                  return node;
               }
               default:
               {
                  removedNodes .push (node);

                  return [ ];
               }
            }
         }
         case "HAnimHumanoid":
         {
            node .skeleton = this .optimizeNodes (node, node .skeleton, true, removedNodes);
            node .skin     = this .optimizeNodes (node, node .skin,     true, removedNodes);

            return this .removeIfNoChildren (node, removedNodes);
         }
         default:
         {
            return node;
         }
      }

      if (!combine)
         return node;

      if (!this .combineGroupingNodes)
         return node;

      if (node .getValue () .hasRoutes ())
         return node;

      if (node .getNodeTypeName () === "Transform")
      {
         node = this .combineSingleChild (node, removedNodes);

         if (!node .translation ?.getValue () .equals (Vector3/* default */.A .ZERO))
            return node;

         if (!node .rotation ?.getValue () .equals (Rotation4/* default */.A .IDENTITY))
            return node;

         if (!node .scale ?.getValue () .equals (Vector3/* default */.A .ONE))
            return node;
      }

      if (!node .children)
         return node;

      const children = Array .from (node .children);

      removedNodes .push (this .removeChildren (node));

      return children;
   },
   removeChildren (node)
   {
      for (const field of node .getValue () .getFields ())
      {
         switch (field .getType ())
         {
            case X3DConstants/* default */.A .SFNode:
               field .setValue (null);
               break;
            case X3DConstants/* default */.A .MFNode:
               field .length = 0;
               break;
         }
      }

      return node;
   },
   removeIfNoChildren (node, removedNodes)
   {
      if (!this .removeEmptyGroups)
         return node;

      switch (node .getNodeTypeName ())
      {
         case "HAnimHumanoid":
         {
            if (node .skeleton .length || node .skin .length)
               return node;

            break;
         }
         default:
         {
            if (node .children .length !== 0)
               return node;

            break;
         }
      }

      removedNodes .push (node);

      return [ ];
   },
   removeInterpolatorsWithOnlyOneValue (node, removedNodes)
   {
      for (const field of node .getValue () .getFields ())
      {
         if (field .getInputRoutes () .size !== 1)
            continue;

         const
            route      = Array .from (field .getInputRoutes ()) [0],
            sourceNode = route .sourceNode;

         if (!sourceNode .getNodeType () .includes (X3DConstants/* default */.A .X3DInterpolatorNode))
            continue;

         if (sourceNode .key .length !== 1)
            continue;

         node [route .destinationField] = sourceNode .keyValue [0];

         removedNodes .push (this .removeChildren (sourceNode));

         route .dispose ();
      }
   },
   combineSingleChild (node, removedNodes)
   {
      if (node .children .length !== 1)
         return node;

      if (!node .visible)
         return node;

      const child = node .children [0];

      if (child .getValue () .getCloneCount () > 1)
         return node;

      if (child .getValue () .hasRoutes ())
         return node;

      switch (child .getNodeTypeName ())
      {
         case "Transform":
         case "HAnimHumanoid":
            return this .combineTransform (node, child, removedNodes);
         case "DirectionalLight":
         case "PointLight":
         case "SpotLight":
            return this .combineLight (node, child, removedNodes);
         case "Viewpoint":
         case "OrthoViewpoint":
            return this .combineViewpoint (node, child, removedNodes);
         default:
            return node;
      }
   },
   combineTransform (node, child, removedNodes)
   {
      // Combine single Transform nodes.

      const
         translation      = new Vector3/* default */.A (),
         rotation         = new Rotation4/* default */.A (),
         scale            = new Vector3/* default */.A (1),
         scaleOrientation = new Rotation4/* default */.A (),
         nodeMatrix       = new Matrix4/* default */.A (),
         childMatrix      = new Matrix4/* default */.A ();

      nodeMatrix .set (node .translation .getValue (),
                       node .rotation .getValue (),
                       node .scale .getValue (),
                       node .scaleOrientation .getValue (),
                       node .center .getValue ());

      childMatrix .set (child .translation .getValue (),
                        child .rotation .getValue (),
                        child .scale .getValue (),
                        child .scaleOrientation .getValue (),
                        child .center .getValue ());

      nodeMatrix .multLeft (childMatrix);

      nodeMatrix .get (translation, rotation, scale, scaleOrientation, child .center .getValue ());

      child .translation      = translation;
      child .rotation         = rotation;
      child .scale            = scale;
      child .scaleOrientation = scaleOrientation;

      if (!child .getNodeTypeName () && node .getNodeTypeName ())
      {
         const executionContext = child .getExecutionContext ();

         executionContext .addNamedNode (executionContext .getUniqueName (node .getNodeTypeName ()), child);
      }

      removedNodes .push (this .removeChildren (node));

      return child;
   },
   combineLight (node, child, removedNodes)
   {
      // Combine single light nodes.

      const nodeMatrix = new Matrix4/* default */.A ();

      nodeMatrix .set (node .translation .getValue (),
                       node .rotation .getValue (),
                       node .scale .getValue (),
                       node .scaleOrientation .getValue (),
                       node .center .getValue ());

      if (child .location)
         child .location = nodeMatrix .multVecMatrix (child .location .getValue ());

      if (child .direction)
         child .direction = nodeMatrix .multDirMatrix (child .direction .getValue ()) .normalize ();

      removedNodes .push (this .removeChildren (node));

      return child;
   },
   combineViewpoint (node, child, removedNodes)
   {
      // Combine single viewpoint nodes.

      const
         nodeMatrix      = new Matrix4/* default */.A (),
         viewpointMatrix = new Matrix4/* default */.A (),
         translation     = new Vector3/* default */.A (),
         rotation        = new Rotation4/* default */.A ();

      nodeMatrix .set (node .translation .getValue (),
                       node .rotation .getValue (),
                       node .scale .getValue (),
                       node .scaleOrientation .getValue (),
                       node .center .getValue ());

      viewpointMatrix .set (child .position .getValue (),
                            child .orientation .getValue ());

      viewpointMatrix
         .multRight (nodeMatrix)
         .get (translation, rotation);

      child .position         = translation;
      child .orientation      = rotation;
      child .centerOfRotation = nodeMatrix .multVecMatrix (child .centerOfRotation .getValue ());

      removedNodes .push (this .removeChildren (node));

      return child;
   },
   viewpointsCenterOfRotation (scene)
   {
      const
         bbox        = scene .getBBox (new Box3/* default */.A ()),
         modelMatrix = new Matrix4/* default */.A (),
         seen        = new Set ();

      this .viewpointsCenterOfRotationNodes (scene .rootNodes, bbox, modelMatrix, seen);
   },
   viewpointsCenterOfRotationNodes (nodes, bbox, modelMatrix, seen)
   {
      for (const node of nodes)
         this .viewpointsCenterOfRotationNode (node ?.getValue (), bbox, modelMatrix, seen);
   },
   viewpointsCenterOfRotationNode (node, bbox, modelMatrix, seen)
   {
      if (!node)
         return;

      if (seen .has (node))
         return;

      seen .add (node);

      if (node .getMatrix)
         modelMatrix = modelMatrix .copy () .multLeft (node .getMatrix ());

      switch (node .getType () .at (-1))
      {
         case X3DConstants/* default */.A .Viewpoint:
         case X3DConstants/* default */.A .OrthoViewpoint:
         {
            node ._centerOfRotation = modelMatrix .copy () .inverse () .multVecMatrix (bbox .center);
            break;
         }
      }

      for (const field of node .getFields ())
      {
         switch (field .getType ())
         {
            case X3DConstants/* default */.A .SFNode:
               this .viewpointsCenterOfRotationNode (field .getValue (), bbox, modelMatrix, seen);
               break;
            case X3DConstants/* default */.A .MFNode:
               this .viewpointsCenterOfRotationNodes (field, bbox, modelMatrix, seen);
               break;
         }
      }
   },
});

const __default__ = X3DOptimizer;
;

/* harmony default export */ const Parser_X3DOptimizer = (Namespace/* default */.A .add ("X3DOptimizer", __default__));
// EXTERNAL MODULE: ./src/x_ite/Browser/Networking/URLs.js
var URLs = __webpack_require__(4030);
// EXTERNAL MODULE: ./src/standard/Math/Algorithm.js
var Algorithm = __webpack_require__(5370);
// EXTERNAL MODULE: ./src/standard/Math/Numbers/Vector2.js
var Vector2 = __webpack_require__(2005);
// EXTERNAL MODULE: ./src/standard/Math/Numbers/Quaternion.js
var Quaternion = __webpack_require__(4556);
// EXTERNAL MODULE: ./src/standard/Math/Numbers/Color3.js
var Color3 = __webpack_require__(2028);
// EXTERNAL MODULE: ./src/standard/Math/Numbers/Color4.js
var Color4 = __webpack_require__(857);
;// ./src/x_ite/Parser/GLTF2Parser.js
/* provided dependency */ var $ = __webpack_require__(4993);














// https://registry.khronos.org/glTF/specs/2.0/glTF-2.0.html
// https://github.com/KhronosGroup/glTF-Sample-Assets

const SAMPLES_PER_SECOND = 30; // in 1/s

function GLTF2Parser (scene)
{
   X3DParser/* default */.A    .call (this, scene);
   Parser_X3DOptimizer .call (this);

   // Optimizer

   this .removeEmptyGroups     = true;
   this .combineGroupingNodes  = true;
   this .optimizeInterpolators = true;

   // Globals

   this .extensions            = new Set ();
   this .envLights             = [ ];
   this .lights                = [ ];
   this .materialVariants      = [ ];
   this .materialVariantNodes  = [ ];
   this .buffers               = [ ];
   this .bufferViews           = [ ];
   this .accessors             = [ ];
   this .samplers              = [ ];
   this .textureCache          = new Map ();
   this .materials             = [ ];
   this .textureTransformNodes = [ ];
   this .meshes                = [ ];
   this .cameras               = [ ];
   this .nodes                 = [ ];
   this .skins                 = [ ];
   this .humanoidIndex         = new Map ();
   this .joints                = new Set ();
   this .pointerAliases        = new Map ();
   this .animationScripts      = [ ];
   this .physicsNodes          = [ ];
}

Object .assign (Object .setPrototypeOf (GLTF2Parser .prototype, X3DParser/* default */.A .prototype),
   Parser_X3DOptimizer .prototype,
{
   getEncoding ()
   {
      return "JSON";
   },
   setInput (json)
   {
      try
      {
         if (typeof json === "string")
            json = JSON .parse (json);

         this .input = json;
      }
      catch
      {
         this .input = undefined;
      }
   },
   isValid: (() =>
   {
      const keys = new Set ([
         "asset",
         "extra",
         "extensions",
         "extensionsRequired",
         "extensionsUsed",
         "buffers",
         "bufferViews",
         "accessors",
         "samplers",
         "images",
         "textures",
         "materials",
         "meshes",
         "cameras",
         "skins",
         "nodes",
         "scenes",
         "scene",
         "animations",
      ]);

      return function ()
      {
         if (!(this .input instanceof Object))
            return false;

         if (!Object .keys (this .input) .every (key => keys .has (key)))
            return false;

         const asset = this .input .asset;

         if (!(asset instanceof Object && asset .version === "2.0"))
            return false;

         return true;
      };
   })(),
   setBuffers (buffers)
   {
      this .buffers = buffers;
   },
   parseIntoScene (resolve, reject)
   {
      this .rootObject (this .input)
         .then (resolve)
         .catch (reject);
   },
   async rootObject (glTF)
   {
      if (!(glTF instanceof Object))
         return;

      // Set profile and components.

      const
         browser = this .getBrowser (),
         scene   = this .getScene ();

      scene .setEncoding ("GLTF");
      scene .setProfile (browser .getProfile ("Interchange"));

      if (glTF .skins)
         scene .addComponent (browser .getComponent ("HAnim"));

      // Parse root objects.

      this .assetObject      (glTF .asset, glTF .extensions);
      this .extensionsArray  (glTF .extensionsRequired, this .extensions);
      this .extensionsArray  (glTF .extensionsUsed, this .extensions);
      this .extensionsObject (glTF .extensions);

      await browser .loadComponents (scene);
      await this .buffersArray (glTF .buffers);

      if (this .extensions .has ("KHR_draco_mesh_compression"))
         this .draco = await this .createDraco ();

      this .bufferViewsArray (glTF .bufferViews);
      this .accessorsArray   (glTF .accessors);
      this .samplersArray    (glTF .samplers);

      await this .imagesArray (glTF .images);

      this .texturesArray   (glTF .textures);
      this .materialsArray  (glTF .materials);
      this .meshesArray     (glTF .meshes);
      this .camerasArray    (glTF .cameras);
      this .skinsArray      (glTF .skins, glTF .nodes);
      this .nodesArray      (glTF .nodes);
      this .scenesArray     (glTF, glTF .scenes, glTF .scene);
      this .animationsArray (glTF .animations);

      this .viewpointsCenterOfRotation (scene);
      this .optimizeSceneGraph (scene .getRootNodes ());

      this .exportGroup ("Viewpoints",        this .cameras);
      this .exportGroup ("EnvironmentLights", this .envLights);
      this .exportGroup ("Lights",            this .lights);
      this .exportGroup ("Animations",        glTF .animations);

      this .cleanupAnimationScripts ();
      this .materialVariantsSwitch ();

      return scene;
   },
   assetObject (asset, extensions)
   {
      if (!(asset instanceof Object))
         return;

      const
         scene         = this .getScene (),
         worldURL      = scene .getWorldURL (),
         worldInfoNode = scene .createNode ("WorldInfo", false);

      for (const [key, value] of Object .entries (asset))
      {
         if (typeof value !== "string")
            continue;

         worldInfoNode ._info .push (`${key}: ${value}`);
      }

      if (asset .extras instanceof Object)
      {
         for (const [key, value] of Object .entries (asset .extras))
         {
            if (typeof value !== "string")
               continue;

            if (key === "title")
               worldInfoNode ._title = value;
            else
               worldInfoNode ._info .push (`${key}: ${value}`);
         }
      }

      if (!worldInfoNode ._title .getValue ())
      {
         const url = new URL (worldURL);

         if (url .protocol === "data:")
            worldInfoNode ._title = "glTF Model";
         else
            worldInfoNode ._title = decodeURIComponent (url .pathname .split ("/") .at (-1) || worldURL);
      }

      if (asset .extensions ?.KHR_xmp_json_ld instanceof Object)
      {
         const packet = asset .extensions .KHR_xmp_json_ld .packet;

         this .khrXmpJsonLdObject (packet, extensions ?.KHR_xmp_json_ld, worldInfoNode);
      }

      worldInfoNode ._info .sort ();
      worldInfoNode .setup ();

      scene .getRootNodes () .push (worldInfoNode);
   },
   extensionsArray (extensions, set)
   {
      if (!(extensions instanceof Array))
         return;

      const
         browser    = this .getBrowser (),
         scene      = this .getScene (),
         components = [ ];

      for (const extension of extensions)
      {
         set .add (extension);

         switch (extension)
         {
            case "EXT_lights_image_based":
            {
               components .push (browser .getComponent ("CubeMapTexturing", 3));
               break;
            }
            // https://github.com/KhronosGroup/glTF/pull/1956
            // case "KHR_lights_environment": // in development
            // {
            //    break;
            // },
            case "EXT_mesh_gpu_instancing":
            case "KHR_materials_pbrSpecularGlossiness":
            case "KHR_materials_anisotropy":
            case "KHR_materials_clearcoat":
            case "KHR_materials_diffuse_transmission":
            case "KHR_materials_dispersion":
            case "KHR_materials_emissive_strength":
            case "KHR_materials_ior":
            case "KHR_materials_iridescence":
            case "KHR_materials_sheen":
            case "KHR_materials_specular":
            case "KHR_materials_transmission":
            case "KHR_materials_volume":
            case "KHR_materials_volume_scatter":
            {
               components .push (browser .getComponent ("X_ITE", 1));
               break;
            }
            case "KHR_texture_transform":
            {
               components .push (browser .getComponent ("Texturing3D", 2));
               break;
            }
            case "KHR_animation_pointer":
            {
               components .push (browser .getComponent ("EventUtilities", 1));
               components .push (browser .getComponent ("Scripting",      1));
               break;
            }
         }
      }

      for (const component of components)
      {
         if (scene .hasComponent (component))
            continue;

         scene .updateComponent (component);
      }
   },
   extensionsObject (extensions)
   {
      if (!(extensions instanceof Object))
         return;

      for (const [key, value] of Object .entries (extensions))
      {
         switch (key)
         {
            case "EXT_lights_image_based":
               this .extLightsImageBasedObject (value);
               break;
            // https://github.com/KhronosGroup/glTF/pull/1956
            // case "KHR_lights_environment": // in development
            //    this .khrLightsEnvironment (value);
            //    break;
            case "KHR_lights_punctual":
               this .khrLightsPunctualObject (value);
               break;
            case "KHR_materials_variants":
               this .khrMaterialsVariantsObjectVariants (value);
               break;
         }
      }
   },
   extLightsImageBasedObject (EXT_lights_image_based)
   {
      if (!(EXT_lights_image_based instanceof Object))
         return;

      this .envLightsArray (EXT_lights_image_based .lights);
   },
   envLightsArray (lights)
   {
      if (!(lights instanceof Array))
         return;

      this .envLights = lights;
   },
   envLightObject (id, light = this .envLights [id])
   {
      if (!(light instanceof Object))
         return null;

      if (light .node)
         return light .node;

      const
         scene      = this .getScene (),
         lightNode  = scene .createNode ("EnvironmentLight", false),
         name       = `EnvironmentLight${id + 1}`,
         quaternion = new Quaternion/* default */.A ();

      scene .addNamedNode    (scene .getUniqueName       (name), lightNode);
      scene .addExportedNode (scene .getUniqueExportName (name), lightNode);

      lightNode ._global    = false;
      lightNode ._intensity = this .numberValue (light .intensity, 1);

      if (this .vectorValue (lightNode .rotation, quaternion))
         lightNode ._rotation = new Rotation4/* default */.A (0, 0, 1, Math .PI) .multRight (new Rotation4/* default */.A (quaternion));
      else
         lightNode ._rotation = new Rotation4/* default */.A (0, 0, 1, Math .PI);

      if (light .irradianceCoefficients instanceof Array)
      {
         for (const irradianceCoefficient of light .irradianceCoefficients)
         {
            if (!(irradianceCoefficient instanceof Array))
               continue;

            lightNode ._diffuseCoefficients .push (... irradianceCoefficient);
         }
      }

      if (light .specularImages instanceof Array)
      {
         const
            specularTextureNode = scene .createNode ("ComposedCubeMapTexture", false),
            baseImages          = light .specularImages [0];

         if (baseImages instanceof Array)
         {
            const faces = ["right", "left", "bottom", "top", "front", "back"];

            for (const [i, image] of baseImages .map (image => this .images [image]) .entries ())
            {
               const
                  textureNode = scene .createNode ("ImageTexture", false),
                  name        = this .sanitizeName (image ?.name);

               if (name)
                  scene .addNamedNode (scene .getUniqueName (name), textureNode);

               textureNode ._description = image ?.name ?? `${$.toUpperCaseFirst (faces [i])} Texture`;
               textureNode ._url         = image ? [image .uri] : [ ];
               textureNode .setup ();

               specularTextureNode [`_${faces [i]}Texture`] = textureNode;
            }

            specularTextureNode .setup ();

            lightNode ._specularTexture = specularTextureNode;
         }
      }

      lightNode .setup ();

      light .pointers = [lightNode];

      return light .node = lightNode;
   },
   khrLightsPunctualObject (KHR_lights_punctual)
   {
      if (!(KHR_lights_punctual instanceof Object))
         return;

      this .lightsArray (KHR_lights_punctual .lights);
   },
   lightsArray (lights)
   {
      if (!(lights instanceof Array))
         return;

      this .lights = lights;
   },
   lightObject (id, light = this .lights [id])
   {
      if (!(light instanceof Object))
         return null;

      if (light .node)
         return light .node;

      const lightNode = this .lightType (light);

      if (!lightNode)
         return null;

      const
         scene = this .getScene (),
         name  = this .sanitizeName (light .name) || `Light${id + 1}`;

      const color = new Color3/* default */.A (1);

      if (this .vectorValue (light .color, color))
         lightNode ._color = color;

      lightNode ._global    = true;
      lightNode ._intensity = this .numberValue (light .intensity, 1);

      lightNode .setup ();

      scene .addNamedNode    (scene .getUniqueName       (name), lightNode);
      scene .addExportedNode (scene .getUniqueExportName (name), lightNode);

      light .pointers = [lightNode];

      return light .node = lightNode;
   },
   lightType (light)
   {
      switch (light .type)
      {
         case "directional":
            return this .directionalLight (light);
         case "spot":
            return this .spotLight (light);
         case "point":
            return this .pointLight (light);
      }
   },
   directionalLight (light)
   {
      const
         scene     = this .getScene (),
         lightNode = scene .createNode ("DirectionalLight", false);

      return lightNode;
   },
   spotLight (light)
   {
      const
         scene     = this .getScene (),
         lightNode = scene .createNode ("SpotLight", false);

      lightNode ._radius      = this .numberValue (light .range, 0) || -1;
      lightNode ._cutOffAngle = this .numberValue (light .outerConeAngle, Math .PI / 4);
      lightNode ._beamWidth   = this .numberValue (light .innerConeAngle, 0);

      this .addAnimationPointerAlias (lightNode, "range",          "radius");
      this .addAnimationPointerAlias (lightNode, "outerConeAngle", "cutOffAngle");
      this .addAnimationPointerAlias (lightNode, "innerConeAngle", "beamWidth");

      return lightNode;
   },
   pointLight (light)
   {
      const
         scene     = this .getScene (),
         lightNode = scene .createNode ("PointLight", false);

      lightNode ._radius = this .numberValue (light .range, 0) || -1;

      this .addAnimationPointerAlias (lightNode, "range", "radius");

      return lightNode;
   },
   khrMaterialsVariantsObjectVariants (KHR_materials_variants)
   {
      if (!(KHR_materials_variants instanceof Object))
         return;

      const variants = KHR_materials_variants .variants;

      if (!(variants instanceof Array))
         return;

      this .materialVariants = variants;
   },
   khrXmpJsonLdObject (index, KHR_xmp_json_ld, worldInfoNode)
   {
      if (!(KHR_xmp_json_ld instanceof Object))
         return;

      const packet = KHR_xmp_json_ld .packets [index];

      for (const [key, value] of Object .entries (packet))
      {
         const match = key .match (/\w+:(.*)/);

         if (!match)
            continue;

         if (value instanceof Object)
         {
            const array = value ["@set"] ?? value ["@list"];

            if (array instanceof Array)
            {
               worldInfoNode ._info .push (`${match [1]}: ${array .map (v => v .toString ()) .join (", ")}`);
               continue;
            }

            if (value ["rdf:_1"] ?.["@value"])
            {
               worldInfoNode ._info .push (`${match [1]}: ${JSON .stringify (value ["rdf:_1"] ["@value"])}`);
               continue;
            }
         };

         if (typeof value !== "string")
            continue;

         worldInfoNode ._info .push (`${match [1]}: ${value}`);
      }
   },
   async buffersArray (buffers)
   {
      if (!(buffers instanceof Array))
         return;

      this .buffers = await Promise .all (buffers .map ((buffer, i) => this .bufferObject (buffer, i)));
   },
   async bufferObject (buffer, i)
   {
      if (!(buffer instanceof Object))
         return;

      if (!buffer .uri)
         return this .buffers [i];

      const
         url         = new URL (buffer .uri, this .getScene () .getBaseURL ()),
         response    = await fetch (url),
         blob        = await response .blob (),
         arrayBuffer = await blob .arrayBuffer ();

      return $.ungzip (arrayBuffer);
   },
   bufferViewsArray (bufferViews)
   {
      if (!(bufferViews instanceof Array))
         return;

      this .bufferViews = bufferViews;

      for (const bufferView of bufferViews)
         bufferView .buffer = this .bufferViewObject (bufferView);
   },
   bufferViewObject (bufferView)
   {
      if (!(bufferView instanceof Object))
         return;

      const buffer = this .buffers [bufferView .buffer];

      if (!buffer)
         return;

      const
         byteOffset = bufferView .byteOffset || 0,
         byteLength = bufferView .byteLength;

      return buffer .slice (byteOffset, byteOffset + byteLength);
   },
   accessorsArray (accessors)
   {
      if (!(accessors instanceof Array))
         return;

      this .accessors = accessors;

      for (const accessor of accessors)
         this .accessorObject (accessor);
   },
   accessorObject: (() =>
   {
      // https://github.com/KhronosGroup/glTF/blob/2e51b3a2c5078a29f5c0d7aee567eb1d926265b4/extensions/2.0/Khronos/KHR_accessor_float64/README.md

      const TypedArrays = new Map ([
         [5120, Int8Array],
         [5121, Uint8Array],
         [5122, Int16Array],
         [5123, Uint16Array],
         [5124, Int32Array],
         [5125, Uint32Array],
         [5126, Float32Array],
         [5130, Float64Array],
      ]);

      const Components = new Map ([
         ["SCALAR", 1],
         ["VEC2",   2],
         ["VEC3",   3],
         ["VEC4",   4],
         ["MAT2",   4],
         ["MAT3",   9],
         ["MAT4",   16],
      ]);

      return function (accessor)
      {
         if (!(accessor instanceof Object))
            return;

         Object .defineProperty (accessor, "array",
         {
            get: () =>
            {
               const
                  TypedArray = TypedArrays .get (accessor .componentType),
                  bufferView = this .bufferViews [accessor .bufferView || 0],
                  byteOffset = accessor .byteOffset || 0,
                  byteStride = bufferView .byteStride || 0,
                  components = Components .get (accessor .type),
                  count      = accessor .count || 0,
                  stride     = byteStride ? byteStride / TypedArray .BYTES_PER_ELEMENT : components,
                  length     = Math .min (stride * count, (bufferView .byteLength - byteOffset) / TypedArray .BYTES_PER_ELEMENT),
                  array      = new TypedArray (bufferView .buffer, byteOffset, length);

               let value;

               value = this .denseArray (TypedArray, components, count, stride, array);
               value = this .sparseObject (accessor, components, value);
               value = this .normalizedArray (accessor, value);

               Object .defineProperty (accessor, "array", { value });

               return value;
            },
            configurable: true,
         });
      };
   })(),
   denseArray (TypedArray, components, count, stride, array)
   {
      if (stride === components)
         return array;

      const
         length = count * components,
         dense  = new TypedArray (length);

      for (let i = 0, j = 0; i < length; j += stride)
      {
         for (let c = 0; c < components; ++ c, ++ i)
            dense [i] = array [j + c];
      }

      return dense;
   },
   sparseObject: (() =>
   {
      const TypedArrays = new Map ([
         [5121, Uint8Array],
         [5123, Uint16Array],
         [5125, Uint32Array],
      ]);

      return function ({ sparse }, components, array)
      {
         if (!(sparse instanceof Object))
            return array;

         if (!(sparse .indices instanceof Object))
            return array;

         if (!(sparse .values instanceof Object))
            return array;

         const
            IndicesTypedArray = TypedArrays .get (sparse .indices .componentType),
            indicesBufferView = this .bufferViews [sparse .indices .bufferView],
            indicesByteOffset = sparse .indices .byteOffset,
            indices           = new IndicesTypedArray (indicesBufferView .buffer, indicesByteOffset, sparse .count);

         const
            ValuesTypedArray = array .constructor,
            valuesBufferView = this .bufferViews [sparse .values .bufferView],
            valuesByteOffset = sparse .values .byteOffset,
            values           = new ValuesTypedArray (valuesBufferView .buffer, valuesByteOffset, sparse .count * components);

         array = array .slice ();

         let v = 0;

         for (const i of indices)
         {
            for (let c = 0; c < components; ++ c, ++ v)
               array [i * components + c] = values [v];
         }

         return array;
      };
   })(),
   normalizedArray ({ normalized, componentType }, array)
   {
      if (!normalized)
         return array;

      switch (componentType)
      {
         case 5120: // Int8Array
            return Float32Array .from (array, v => Math .max (v / 127, -1));
         case 5121: // Uint8Array
            return Float32Array .from (array, v => v / 255);
         case 5122: // Int16Array
            return Float32Array .from (array, v => Math .max (v / 32767, -1));
         case 5123: // Uint16Array
            return Float32Array .from (array, v => v / 65535);
         case 5124: // Int32Array
            return Float32Array .from (array, v => Math .max (v / 2147483647, -1));
         case 5125: // Uint32Array
            return Float32Array .from (array, v => v / 4294967295);
         case 5126: // Float32Array
         case 5130: // Float64Array
            return array; // Their normalized property MUST NOT be set to true;
      }
   },
   samplersArray (samplers)
   {
      if (!(samplers instanceof Array))
         return;

      this .samplers = samplers;

      for (const sampler of samplers)
         this .samplerObject (sampler);
   },
   samplerObject: (() =>
   {
      const MinificationFilters = new Map ([
         [9728, ["NEAREST_PIXEL",                false]],
         [9729, ["AVG_PIXEL",                    false]],
         [9984, ["NEAREST_PIXEL_NEAREST_MIPMAP", true]],
         [9985, ["AVG_PIXEL_NEAREST_MIPMAP",     true]],
         [9986, ["NEAREST_PIXEL_AVG_MIPMAP",     true]],
         [9987, ["AVG_PIXEL_AVG_MIPMAP",         true]],
      ]);

      const MagnificationFilters = new Map ([
         [9728, "NEAREST_PIXEL"],
         [9729, "AVG_PIXEL"],
      ]);

      const BoundaryModes = new Map ([
         [33071, "CLAMP_TO_EDGE"],
         [33648, "MIRRORED_REPEAT"],
         [10497, "REPEAT"],
      ]);

      return function (sampler)
      {
         if (!(sampler instanceof Object))
            return;

         Object .defineProperty (sampler, "texturePropertiesNode",
         {
            get: () =>
            {
               const
                  scene                 = this .getScene (),
                  texturePropertiesNode = scene .createNode ("TextureProperties", false),
                  name                  = this .sanitizeName (sampler .name);

               if (name)
                  scene .addNamedNode (scene .getUniqueName (name), texturePropertiesNode);

               // minFilter

               const minificationFilter = MinificationFilters .get (sampler .minFilter) ?? ["AVG_PIXEL_AVG_MIPMAP", true];

               texturePropertiesNode ._minificationFilter = minificationFilter [0];
               texturePropertiesNode ._generateMipMaps    = minificationFilter [1];

               // magFilter

               texturePropertiesNode ._magnificationFilter = MagnificationFilters .get (sampler .magFilter) ?? "AVG_PIXEL";

               // boundaryMode

               texturePropertiesNode ._boundaryModeS = BoundaryModes .get (sampler .wrapS) ?? "REPEAT";
               texturePropertiesNode ._boundaryModeT = BoundaryModes .get (sampler .wrapT) ?? "REPEAT";

               // anisotropicDegree

               texturePropertiesNode ._anisotropicDegree = this .getBrowser () .getRenderingProperty ("MaxAnisotropicDegree");

               // setup

               texturePropertiesNode .setup ();

               Object .defineProperty (sampler, "texturePropertiesNode", { value: texturePropertiesNode });

               return texturePropertiesNode;
            },
            configurable: true,
         });
      };
   })(),
   async imagesArray (images)
   {
      if (!(images instanceof Array))
         return;

      this .images = await Promise .all (images .map ((image, index) => this .imageObject (image, index)));
   },
   async imageObject (image, index)
   {
      if (!(image instanceof Object))
         return;

      image .index = index;

      if (image .uri)
         return image;

      const bufferView = this .bufferViews [image .bufferView];

      if (!bufferView)
         return image;

      const
         buffer = bufferView .buffer,
         blob   = new Blob ([new Uint8Array (buffer)], { type: image .mimeType }),
         uri    = await this .blobToDataUrl (blob);

      image .uri = uri;

      return image;
   },
   blobToDataUrl (blob)
   {
      return new Promise ((resolve, reject) =>
      {
         const fileReader = new FileReader ();

         fileReader .onload  = resolve;
         fileReader .onerror = reject;

         fileReader .readAsDataURL (blob);
      })
      .then (event => event .target .result);
   },
   texturesArray (textures)
   {
      if (!(textures instanceof Array))
         return;

      this .textures = textures;
   },
   textureObject (texture)
   {
      if (!(texture instanceof Object))
         return;

      if (texture .textureNode)
         return texture .textureNode;

      const images = this .textureImageObject (texture);

      if (!images .length)
         return null;

      const
         key    = `${images .map (image => image .index) .join (",")}:${texture .sampler}`,
         cached = this .textureCache .get (key);

      if (cached)
         return texture .textureNode = cached;

      const
         scene       = this .getScene (),
         textureNode = scene .createNode ("ImageTexture", false),
         name        = this .sanitizeName (texture .name || images [0] .name);

      if (name)
         scene .addNamedNode (scene .getUniqueName (name), textureNode);

      textureNode ._url                  = images .map (image => image .uri);
      textureNode ._colorSpaceConversion = false;

      const sampler = this .samplers [texture .sampler];

      if (sampler instanceof Object)
         textureNode ._textureProperties = sampler .texturePropertiesNode;

      textureNode .setup ();

      this .textureCache .set (key, textureNode);

      return texture .textureNode = textureNode;
   },
   textureImageObject (texture)
   {
      const images = [this .images [texture .source]];

      if (this .extensions .has ("KHR_texture_basisu"))
         images .unshift (this .images [texture .extensions ?.KHR_texture_basisu ?.source]);

      if (this .extensions .has ("EXT_texture_webp"))
         images .unshift (this .images [texture .extensions ?.EXT_texture_webp ?.source]);

      return images .filter (image => image);
   },
   materialsArray (materials)
   {
      if (!(materials instanceof Array))
         return;

      this .materials = materials;
   },
   materialObject ({ material })
   {
      if (!(material instanceof Object))
         return this .getDefaultAppearance ();

      if (material .appearanceNode)
         return material .appearanceNode;

      const texCoordIndices = this .getTexCoordIndices ("", material);

      this .texCoordIndex           = Array .from (texCoordIndices) .reduce ((p, c) => Math .max (p, c), -1);
      this .textureTransformNodes   = [ ];
      this .texCoordMappings        = new Map ();
      this .texCoordOfNode          = new Map ();
      this .texCoordExtensionOfNode = new Map ();
      material .texCoordMappings    = this .texCoordMappings;

      const
         scene          = this .getScene (),
         appearanceNode = scene .createNode ("Appearance", false),
         materialNode   = this .createMaterial (material),
         name           = this .sanitizeName (material .name);

      const emissiveFactor = new Color3/* default */.A ();

      if (this .vectorValue (material .emissiveFactor, emissiveFactor))
         materialNode ._emissiveColor = emissiveFactor;

      materialNode ._emissiveTexture        = this .textureInfo    (material .emissiveTexture);
      materialNode ._emissiveTextureMapping = this .textureMapping (material .emissiveTexture);

      this .occlusionTextureInfo (material .occlusionTexture, materialNode);
      this .normalTextureInfo    (material .normalTexture,    materialNode);
      this .materialExtensions   (material .extensions,       materialNode);

      materialNode .setup ();

      for (const i of texCoordIndices)
      {
         const mapping = `TEXCOORD_${i}`;

         if (this .textureTransformNodes .length)
         {
            // If there are texture transform nodes, create a TextureTransform node for missing mappings.

            if (this .textureTransformNodes .every (node => node ._mapping !== mapping))
            {
               const textureTransformNode = scene .createNode ("TextureTransform", false);

               // Flip Y
               textureTransformNode ._mapping        = mapping;
               textureTransformNode ._translation .y = -1;
               textureTransformNode ._scale .y       = -1;

               textureTransformNode .setup ();

               this .textureTransformNodes .push (textureTransformNode);
            }
         }

         this .texCoordMappings .set (mapping, i);
      }

      if (name)
         scene .addNamedNode (scene .getUniqueName (name), appearanceNode);

      appearanceNode ._alphaMode        = this .stringValue (material .alphaMode, "OPAQUE");
      appearanceNode ._alphaCutoff      = this .numberValue (material .alphaCutoff, 0.5);
      appearanceNode ._material         = this .khrMaterialsUnlitObject (material .extensions ?.KHR_materials_unlit, materialNode);
      appearanceNode ._textureTransform = this .createMultiTextureTransform (appearanceNode ._material .getValue ());

      appearanceNode .setup ();

      material .pointers = [appearanceNode, materialNode];

      return material .appearanceNode = appearanceNode;
   },
   getTexCoordIndices (key, object, indices = new Set ())
   {
      if (!(object instanceof Object))
         return indices;

      if (key .endsWith ("Texture") && !object ?.extensions ?.KHR_texture_transform)
         indices .add (object .texCoord || 0);

      for (const [key, value] of Object .entries (object))
         this .getTexCoordIndices (key, value, indices);

      return indices;
   },
   createMaterial (material)
   {
      const materials = [
         this .pbrMetallicRoughnessObject  .bind (this, material .pbrMetallicRoughness),
         this .pbrSpecularGlossinessObject .bind (this, material .extensions ?.KHR_materials_pbrSpecularGlossiness),
         this .pbrMetallicRoughnessObject  .bind (this, { }),
      ];

      for (const material of materials)
      {
         const materialNode = material ();

         if (materialNode)
            return materialNode;
      }
   },
   pbrMetallicRoughnessObject (pbrMetallicRoughness)
   {
      if (!(pbrMetallicRoughness instanceof Object))
         return null;

      const
         scene        = this .getScene (),
         materialNode = scene .createNode ("PhysicalMaterial", false);

      const
         baseColorFactor = new Color4/* default */.A (),
         baseColor       = new Color3/* default */.A ();

      if (this .vectorValue (pbrMetallicRoughness .baseColorFactor, baseColorFactor))
      {
         materialNode ._baseColor    = baseColor .set (... baseColorFactor);
         materialNode ._transparency = 1 - baseColorFactor .a;
      }

      materialNode ._metallic  = this .numberValue (pbrMetallicRoughness .metallicFactor,  1);
      materialNode ._roughness = this .numberValue (pbrMetallicRoughness .roughnessFactor, 1);

      materialNode ._baseTexture                     = this .textureInfo (pbrMetallicRoughness .baseColorTexture);
      materialNode ._baseTextureMapping              = this .textureMapping (pbrMetallicRoughness .baseColorTexture);
      materialNode ._metallicRoughnessTexture        = this .textureInfo (pbrMetallicRoughness .metallicRoughnessTexture);
      materialNode ._metallicRoughnessTextureMapping = this .textureMapping (pbrMetallicRoughness .metallicRoughnessTexture);

      pbrMetallicRoughness .pointers = [materialNode];

      return materialNode;
   },
   pbrSpecularGlossinessObject (pbrSpecularGlossiness)
   {
      if (!(pbrSpecularGlossiness instanceof Object))
         return null;

      const
         scene        = this .getScene (),
         materialNode = scene .createNode ("SpecularGlossinessMaterial", false);

      const
         diffuseFactor  = new Color4/* default */.A (),
         diffuseColor   = new Color3/* default */.A (),
         specularFactor = new Color3/* default */.A ();

      if (this .vectorValue (pbrSpecularGlossiness .diffuseFactor, diffuseFactor))
      {
         materialNode ._diffuseColor = diffuseColor .set (... diffuseFactor);
         materialNode ._transparency = 1 - diffuseFactor .a;
      }

      materialNode ._diffuseTexture        = this .textureInfo (pbrSpecularGlossiness .diffuseTexture);
      materialNode ._diffuseTextureMapping = this .textureMapping (pbrSpecularGlossiness .diffuseTexture);

      if (this .vectorValue (pbrSpecularGlossiness .specularFactor, specularFactor))
         materialNode ._specularColor = specularFactor;
      else
         materialNode ._specularColor = Color3/* default */.A .WHITE;

      materialNode ._glossiness = this .numberValue (pbrSpecularGlossiness .glossinessFactor, 1);

      materialNode ._specularGlossinessTexture        = this .textureInfo (pbrSpecularGlossiness .specularGlossinessTexture);
      materialNode ._specularGlossinessTextureMapping = this .textureMapping (pbrSpecularGlossiness .specularGlossinessTexture);

      pbrSpecularGlossiness .pointers = [materialNode];

      return materialNode;
   },
   occlusionTextureInfo (occlusionTexture, materialNode)
   {
      if (!(occlusionTexture instanceof Object))
         return null;

      materialNode ._occlusionStrength       = this .numberValue (occlusionTexture .strength, 1);
      materialNode ._occlusionTexture        = this .textureInfo (occlusionTexture);
      materialNode ._occlusionTextureMapping = this .textureMapping (occlusionTexture);
   },
   normalTextureInfo (normalTexture, materialNode)
   {
      if (!(normalTexture instanceof Object))
         return null;

      materialNode ._normalScale          = this .numberValue (normalTexture .scale, 1);
      materialNode ._normalTexture        = this .textureInfo (normalTexture);
      materialNode ._normalTextureMapping = this .textureMapping (normalTexture);
   },
   textureInfo (texture)
   {
      if (!(texture instanceof Object))
         return null;

      if (texture .extensions instanceof Object)
         texture .mapping = this .textureTransformObject (texture .extensions .KHR_texture_transform, texture .texCoord || 0);
      else
         texture .mapping = `TEXCOORD_${texture .texCoord || 0}`;

      return this .textureObject (this .textures [texture .index]);
   },
   textureMapping (texture)
   {
      if (!(texture instanceof Object))
         return "";

      return texture .mapping;
   },
   materialExtensions (extensions, materialNode)
   {
      if (!(extensions instanceof Object))
         return;

      if (!materialNode .getType () .includes (X3DConstants/* default */.A .PhysicalMaterial))
         return;

      for (const [key, value] of Object .entries (extensions))
      {
         switch (key)
         {
            case "KHR_materials_anisotropy":
               this .khrMaterialsAnisotropyObject (value, materialNode);
               break;
            case "KHR_materials_clearcoat":
               this .khrMaterialsClearcoatObject (value, materialNode);
               break;
            case "KHR_materials_diffuse_transmission":
               this .khrMaterialsDiffuseTransmissionObject (value, materialNode);
               break;
            case "KHR_materials_dispersion":
               this .khrMaterialsDispersionObject (value, materialNode);
               break;
            case "KHR_materials_emissive_strength":
               this .khrMaterialsEmissiveStrengthObject (value, materialNode);
               break;
            case "KHR_materials_ior":
               this .khrMaterialsIorStrengthObject (value, materialNode);
               break;
            case "KHR_materials_iridescence":
               this .khrMaterialsIridescenceObject (value, materialNode);
               break;
            case "KHR_materials_sheen":
               this .khrMaterialsSheenObject (value, materialNode);
               break;
            case "KHR_materials_specular":
               this .khrMaterialsSpecularObject (value, materialNode);
               break;
            case "KHR_materials_transmission":
               this .khrMaterialsTransmission (value, materialNode);
               break;
            case "KHR_materials_volume":
               this .khrMaterialsVolumeObject (value, materialNode);
               break;
            case "KHR_materials_volume_scatter":
               this .khrMaterialsVolumeScatterObject (value, materialNode);
               break;
         }
      }
   },
   khrMaterialsAnisotropyObject (KHR_materials_anisotropy, materialNode)
   {
      if (!(KHR_materials_anisotropy instanceof Object))
         return;

      const extension = this .getScene () .createNode ("AnisotropyMaterialExtension", false);

      extension ._anisotropyStrength       = this .numberValue (KHR_materials_anisotropy .anisotropyStrength, 0);
      extension ._anisotropyRotation       = this .numberValue (KHR_materials_anisotropy .anisotropyRotation, 0);
      extension ._anisotropyTexture        = this .textureInfo (KHR_materials_anisotropy .anisotropyTexture);
      extension ._anisotropyTextureMapping = this .textureMapping (KHR_materials_anisotropy .anisotropyTexture);

      extension .setup ();

      KHR_materials_anisotropy .pointers = [extension];

      materialNode ._extensions .push (extension);
   },
   khrMaterialsClearcoatObject (KHR_materials_clearcoat, materialNode)
   {
      if (!(KHR_materials_clearcoat instanceof Object))
         return;

      const extension = this .getScene () .createNode ("ClearcoatMaterialExtension", false);

      extension ._clearcoat               = this .numberValue (KHR_materials_clearcoat .clearcoatFactor, 0);
      extension ._clearcoatTexture        = this .textureInfo (KHR_materials_clearcoat .clearcoatTexture);
      extension ._clearcoatTextureMapping = this .textureMapping (KHR_materials_clearcoat .clearcoatTexture);

      extension ._clearcoatRoughness               = this .numberValue (KHR_materials_clearcoat .clearcoatRoughnessFactor, 0);
      extension ._clearcoatRoughnessTexture        = this .textureInfo (KHR_materials_clearcoat .clearcoatRoughnessTexture);
      extension ._clearcoatRoughnessTextureMapping = this .textureMapping (KHR_materials_clearcoat .clearcoatRoughnessTexture);

      extension ._clearcoatNormalTexture        = this .textureInfo (KHR_materials_clearcoat .clearcoatNormalTexture);
      extension ._clearcoatNormalTextureMapping = this .textureMapping (KHR_materials_clearcoat .clearcoatNormalTexture);

      extension .setup ();

      KHR_materials_clearcoat .pointers = [extension];

      materialNode ._extensions .push (extension);
   },
   khrMaterialsDiffuseTransmissionObject (KHR_materials_diffuse_transmission, materialNode)
   {
      if (!(KHR_materials_diffuse_transmission instanceof Object))
         return;

      const extension = this .getScene () .createNode ("DiffuseTransmissionMaterialExtension", false);

      extension ._diffuseTransmission               = this .numberValue (KHR_materials_diffuse_transmission .diffuseTransmissionFactor, 0);
      extension ._diffuseTransmissionTexture        = this .textureInfo (KHR_materials_diffuse_transmission .diffuseTransmissionTexture);
      extension ._diffuseTransmissionTextureMapping = this .textureMapping (KHR_materials_diffuse_transmission .diffuseTransmissionTexture);

      const diffuseTransmissionColorFactor = new Color3/* default */.A ();

      if (this .vectorValue (KHR_materials_diffuse_transmission .diffuseTransmissionColorFactor, diffuseTransmissionColorFactor))
         extension ._diffuseTransmissionColor = diffuseTransmissionColorFactor;

      extension ._diffuseTransmissionColorTexture        = this .textureInfo (KHR_materials_diffuse_transmission .diffuseTransmissionColorTexture);
      extension ._diffuseTransmissionColorTextureMapping = this .textureMapping (KHR_materials_diffuse_transmission .diffuseTransmissionColorTexture);

      extension .setup ();

      KHR_materials_diffuse_transmission .pointers = [extension];

      materialNode ._extensions .push (extension);
   },
   khrMaterialsDispersionObject (KHR_materials_dispersion, materialNode)
   {
      if (!(KHR_materials_dispersion instanceof Object))
         return;

      const extension = this .getScene () .createNode ("DispersionMaterialExtension", false);

      extension ._dispersion = this .numberValue (KHR_materials_dispersion .dispersion, 0);

      extension .setup ();

      KHR_materials_dispersion .pointers = [extension];

      materialNode ._extensions .push (extension);
   },
   khrMaterialsEmissiveStrengthObject (KHR_materials_emissive_strength, materialNode)
   {
      if (!(KHR_materials_emissive_strength instanceof Object))
         return;

      const extension = this .getScene () .createNode ("EmissiveStrengthMaterialExtension", false);

      extension ._emissiveStrength = this .numberValue (KHR_materials_emissive_strength .emissiveStrength, 1);

      extension .setup ();

      KHR_materials_emissive_strength .pointers = [extension];

      materialNode ._extensions .push (extension);
   },
   khrMaterialsIorStrengthObject (KHR_materials_ior, materialNode)
   {
      const extension = this .getScene () .createNode ("IORMaterialExtension", false);

      extension ._indexOfRefraction = this .numberValue (KHR_materials_ior .ior, 1.5);

      extension .setup ();

      KHR_materials_ior .pointers = [extension];

      materialNode ._extensions .push (extension);
   },
   khrMaterialsIridescenceObject (KHR_materials_iridescence, materialNode)
   {
      const extension = this .getScene () .createNode ("IridescenceMaterialExtension", false);

      extension ._iridescence                        = this .numberValue (KHR_materials_iridescence .iridescenceFactor, 0);
      extension ._iridescenceTexture                 = this .textureInfo (KHR_materials_iridescence .iridescenceTexture);
      extension ._iridescenceTextureMapping          = this .textureMapping (KHR_materials_iridescence .iridescenceTexture);
      extension ._iridescenceIndexOfRefraction       = this .numberValue (KHR_materials_iridescence .iridescenceIor, 1.3);
      extension ._iridescenceThicknessMinimum        = this .numberValue (KHR_materials_iridescence .iridescenceThicknessMinimum, 100);
      extension ._iridescenceThicknessMaximum        = this .numberValue (KHR_materials_iridescence .iridescenceThicknessMaximum, 400);
      extension ._iridescenceThicknessTexture        = this .textureInfo (KHR_materials_iridescence .iridescenceThicknessTexture);
      extension ._iridescenceThicknessTextureMapping = this .textureMapping (KHR_materials_iridescence .iridescenceThicknessTexture);

      extension .setup ();

      KHR_materials_iridescence .pointers = [extension];

      materialNode ._extensions .push (extension);
   },
   khrMaterialsSheenObject (KHR_materials_sheen, materialNode)
   {
      if (!(KHR_materials_sheen instanceof Object))
         return;

      const extension = this .getScene () .createNode ("SheenMaterialExtension", false);

      const sheenColorFactor = new Color3/* default */.A ();

      if (this .vectorValue (KHR_materials_sheen .sheenColorFactor, sheenColorFactor))
         extension ._sheenColor = sheenColorFactor;

      extension ._sheenColorTexture        = this .textureInfo (KHR_materials_sheen .sheenColorTexture);
      extension ._sheenColorTextureMapping = this .textureMapping (KHR_materials_sheen .sheenColorTexture);

      extension ._sheenRoughness               = this .numberValue (KHR_materials_sheen .sheenRoughnessFactor, 0);
      extension ._sheenRoughnessTexture        = this .textureInfo (KHR_materials_sheen .sheenRoughnessTexture);
      extension ._sheenRoughnessTextureMapping = this .textureMapping (KHR_materials_sheen .sheenRoughnessTexture);

      extension .setup ();

      KHR_materials_sheen .pointers = [extension];

      materialNode ._extensions .push (extension);
   },
   khrMaterialsSpecularObject (KHR_materials_specular, materialNode)
   {
      if (!(KHR_materials_specular instanceof Object))
         return;

      const extension = this .getScene () .createNode ("SpecularMaterialExtension", false);

      extension ._specular               = this .numberValue (KHR_materials_specular .specularFactor, 1);
      extension ._specularTexture        = this .textureInfo (KHR_materials_specular .specularTexture);
      extension ._specularTextureMapping = this .textureMapping (KHR_materials_specular .specularTexture);

      const specularColorFactor = new Color3/* default */.A ();

      if (this .vectorValue (KHR_materials_specular .specularColorFactor, specularColorFactor))
         extension ._specularColor = specularColorFactor;

      extension ._specularColorTexture        = this .textureInfo (KHR_materials_specular .specularColorTexture);
      extension ._specularColorTextureMapping = this .textureMapping (KHR_materials_specular .specularColorTexture);

      extension .setup ();

      KHR_materials_specular .pointers = [extension];

      materialNode ._extensions .push (extension);
   },
   khrMaterialsTransmission (KHR_materials_transmission, materialNode)
   {
      if (!(KHR_materials_transmission instanceof Object))
         return;

      const extension = this .getScene () .createNode ("TransmissionMaterialExtension", false);

      extension ._transmission               = this .numberValue (KHR_materials_transmission .transmissionFactor, 0);
      extension ._transmissionTexture        = this .textureInfo (KHR_materials_transmission .transmissionTexture);
      extension ._transmissionTextureMapping = this .textureMapping (KHR_materials_transmission .transmissionTexture);

      extension .setup ();

      KHR_materials_transmission .pointers = [extension];

      materialNode ._extensions .push (extension);
   },
   khrMaterialsVolumeObject (KHR_materials_volume, materialNode)
   {
      const extension = this .getScene () .createNode ("VolumeMaterialExtension", false);

      extension ._thickness               = this .numberValue (KHR_materials_volume .thicknessFactor, 0);
      extension ._thicknessTexture        = this .textureInfo (KHR_materials_volume .thicknessTexture);
      extension ._thicknessTextureMapping = this .textureMapping (KHR_materials_volume .thicknessTexture);
      extension ._attenuationDistance     = this .numberValue (KHR_materials_volume .attenuationDistance, 1_000_000);

      const attenuationColor = new Color3/* default */.A ();

      if (this .vectorValue (KHR_materials_volume .attenuationColor, attenuationColor))
         extension ._attenuationColor = attenuationColor;

      extension .setup ();

      KHR_materials_volume .pointers = [extension];

      materialNode ._extensions .push (extension);
   },
   khrMaterialsVolumeScatterObject (KHR_materials_volume_scatter, materialNode)
   {
      if (!(KHR_materials_volume_scatter instanceof Object))
         return;

      const extension = this .getScene () .createNode ("VolumeScatterMaterialExtension", false);

      const multiscatterColor = new Color3/* default */.A ();

      if (this .vectorValue (KHR_materials_volume_scatter .multiscatterColor, multiscatterColor))
         extension ._multiscatterColor = multiscatterColor;

      extension ._scatterAnisotropy = this .numberValue (KHR_materials_volume_scatter .scatterAnisotropy, 0);

      extension .setup ();

      KHR_materials_volume_scatter .pointers = [extension];

      materialNode ._extensions .push (extension);
   },
   khrMaterialsUnlitObject (KHR_materials_unlit, materialNode)
   {
      if (!KHR_materials_unlit)
         return materialNode;

      const unlitMaterialNode = this .getScene () .createNode ("UnlitMaterial", false);

      unlitMaterialNode ._emissiveColor          = materialNode ._baseColor;
      unlitMaterialNode ._emissiveTextureMapping = materialNode ._baseTextureMapping;
      unlitMaterialNode ._emissiveTexture        = materialNode ._baseTexture;
      unlitMaterialNode ._normalScale            = materialNode ._normalScale;
      unlitMaterialNode ._normalTextureMapping   = materialNode ._normalTextureMapping;
      unlitMaterialNode ._normalTexture          = materialNode ._normalTexture;
      unlitMaterialNode ._transparency           = materialNode ._transparency;

      unlitMaterialNode .setup ();
      this .addAnimationPointerAlias (unlitMaterialNode, "baseColor", "emissiveColor");

      materialNode .dispose ();

      return unlitMaterialNode;
   },
   textureTransformObject: (() =>
   {
      const
         matrix   = new Matrix4/* default */.A (),
         vector   = new Vector3/* default */.A (),
         rotation = new Rotation4/* default */.A ();

      return function (KHR_texture_transform, texCoord)
      {
         if (!(KHR_texture_transform instanceof Object))
            return;

         if (!this .extensions .has ("KHR_texture_transform"))
            return;

         texCoord = KHR_texture_transform .texCoord ?? texCoord;

         const
            translation = new Vector2/* default */.A (),
            scale       = new Vector2/* default */.A (1);

         // Reset matrix.
         matrix .set ();

         // Flip Y
         matrix .scale (vector .set (1, -1, 1));
         matrix .translate (vector .set (0, -1, 0));

         if (this .vectorValue (KHR_texture_transform .offset, translation))
            matrix .translate (vector .set (... translation, 0));

         const angle = this .numberValue (KHR_texture_transform .rotation, 0)

         matrix .rotate (rotation .set (0, 0, -1, angle));

         if (this .vectorValue (KHR_texture_transform .scale, scale))
            matrix .scale (vector .set (... scale, 1));

         // Check for existing node.

         const existing = this .textureTransformNodes .find (node => this .texCoordOfNode .get (node) === texCoord && node ._matrix .getValue () .equals (matrix));

         if (existing)
         {
            Object .defineProperty (KHR_texture_transform, "pointers",
            {
               get: () =>
               {
                  return this .texCoordExtensionOfNode .get (existing);
               },
               configurable: true,
            });

            return existing ._mapping .getValue ();
         }

         // Create new TextureTransformMatrix3D.

         const
            scene                = this .getScene (),
            textureTransformNode = scene .createNode ("TextureTransformMatrix3D", false),
            mapping              = `TEXCOORD_${this .texCoordIndex + this .textureTransformNodes .length + 1}`;

         textureTransformNode ._mapping = mapping;
         textureTransformNode ._matrix  = matrix;

         textureTransformNode .setup ();

         this .textureTransformNodes .push (textureTransformNode);
         this .texCoordMappings .set (mapping, texCoord);
         this .texCoordOfNode .set (textureTransformNode, texCoord);
         this .texCoordExtensionOfNode .set (textureTransformNode, KHR_texture_transform);

         Object .defineProperty (KHR_texture_transform, "pointers",
         {
            get: () =>
            {
               const scriptNode = scene .createNode ("Script", false);

               scriptNode .addUserDefinedField (X3DConstants/* default */.A .inputOutput, "translation",   new Fields/* default */.A .SFVec2f (... translation));
               scriptNode .addUserDefinedField (X3DConstants/* default */.A .inputOutput, "rotation",      new Fields/* default */.A .SFFloat (angle));
               scriptNode .addUserDefinedField (X3DConstants/* default */.A .inputOutput, "scale",         new Fields/* default */.A .SFVec2f (... scale));
               scriptNode .addUserDefinedField (X3DConstants/* default */.A .outputOnly,  "value_changed", new Fields/* default */.A .SFMatrix4f ());

               scriptNode ._url = [/* js */ `ecmascript:

const m = new SFMatrix3f ();

function eventsProcessed ()
{
   m .setTransform (translation, -rotation, scale);

   // m' = m * flipY

   value_changed [0]  = m [0];
   value_changed [1]  = -m [1] + m [2];
   value_changed [4]  = m [3];
   value_changed [5]  = -m [4] + m [5];
   value_changed [12] = m [6];
   value_changed [13] = -m [7] + m [8];
}
`];

               scriptNode .setup ();

               scene .addNamedNode (scene .getUniqueName ("CombineTextureMatrixScript"), scriptNode);
               scene .addRoute (scriptNode, "value_changed", textureTransformNode, "set_matrix");

               this .addAnimationPointerAlias (scriptNode, "offset", "translation");
               this .animationScripts .push (scriptNode);

               Object .defineProperty (KHR_texture_transform, "pointers", { value: [scriptNode] });

               return [scriptNode];
            },
            configurable: true,
         });

         return mapping;
      };
   })(),
   meshesArray (meshes)
   {
      if (!(meshes instanceof Array))
         return;

      this .meshes = meshes;
   },
   meshObject (mesh, skin, EXT_mesh_gpu_instancing)
   {
      if (!(mesh instanceof Object))
         return;

      if (mesh .shapeNodes)
      {
         const primitives = mesh .primitives;

         if (!(primitives instanceof Array))
            return mesh .shapeNodes;

         for (const primitive of primitives)
            this .attributesJointsArray (skin, primitive .attributes ?.JOINTS, primitive .attributes ?.WEIGHTS);

         return mesh .shapeNodes;
      }

      const shapeNodes = this .primitivesArray (mesh, skin, EXT_mesh_gpu_instancing);

      // Name Shape nodes.

      const
         scene = this .getScene (),
         name  = this .sanitizeName (mesh .name);

      if (name)
      {
         for (const shapeNode of shapeNodes)
            scene .addNamedNode (scene .getUniqueName (name), shapeNode);
      }

      return mesh .shapeNodes = shapeNodes;
   },
   primitivesArray ({ primitives, weights }, skin, EXT_mesh_gpu_instancing)
   {
      if (!(primitives instanceof Array))
         return [ ];

      const shapeNodes = [ ];

      for (const primitive of primitives)
         this .primitiveObject (primitive, weights, skin, EXT_mesh_gpu_instancing, shapeNodes);

      return shapeNodes;
   },
   primitiveObject (primitive, weights, skin, EXT_mesh_gpu_instancing, shapeNodes)
   {
      if (!(primitive instanceof Object))
         return;

      this .attributesObject (primitive .attributes);
      this .targetsArray     (primitive .targets);

      primitive .indices  = this .accessors [primitive .indices];
      primitive .material = this .materials [primitive .material];

      this .primitiveExtensionsObject (primitive .extensions, primitive);

      const
         shapeNode    = this .createShape (primitive, weights, skin, EXT_mesh_gpu_instancing),
         variantsNode = this .khrMaterialsVariantsExtension (primitive .extensions, shapeNode);

      shapeNodes .push (primitive .shapeNode = variantsNode ?? shapeNode);
   },
   attributesObject (attributes)
   {
      if (!(attributes instanceof Object))
         return;

      for (const key in attributes)
         attributes [key] = this .accessors [attributes [key]];

      attributes .TEXCOORD = [ ];
      attributes .COLOR    = [ ];
      attributes .JOINTS   = [ ];
      attributes .WEIGHTS  = [ ];

      for (let i = 0; attributes ["TEXCOORD_" + i]; ++ i)
         attributes .TEXCOORD .push (attributes ["TEXCOORD_" + i]);

      for (let i = 0; attributes ["COLOR_" + i]; ++ i)
         attributes .COLOR .push (attributes ["COLOR_" + i]);

      for (let i = 0; attributes ["JOINTS_" + i]; ++ i)
         attributes .JOINTS .push (attributes ["JOINTS_" + i]);

      for (let i = 0; attributes ["WEIGHTS_" + i]; ++ i)
         attributes .WEIGHTS .push (attributes ["WEIGHTS_" + i]);
   },
   targetsArray (targets)
   {
      if (!(targets instanceof Array))
         return;
   },
   primitiveExtensionsObject (extensions, primitive)
   {
      if (!(extensions instanceof Object))
         return;

      for (const [key, value] of Object .entries (extensions))
      {
         switch (key)
         {
            case "KHR_draco_mesh_compression":
               this .khrDracoMeshCompressionObject (value, primitive);
               break;
         }
      }
   },
   khrDracoMeshCompressionObject (draco, primitive)
   {
      if (!(draco instanceof Object))
         return;

      if (!this .draco)
         return;

      function indicesCallback (value)
      {
         Object .defineProperty (primitive .indices, "array", { value });
      }

      function attributeCallback (key, value)
      {
         if (attributes [key])
            Object .defineProperty (attributes [key], "array", { value });
      }

      const
         attributes = primitive .attributes,
         dataView   = new Uint8Array (this .bufferViews [draco .bufferView] .buffer);

      this .dracoDecodeMesh (this .draco, dataView, draco .attributes, indicesCallback, attributeCallback);
   },
   dracoDecodeMesh (draco, dataView, attributes, indicesCallback, attributeCallback)
   {
      const
         buffer  = new draco .DecoderBuffer (),
         decoder = new draco .Decoder ();

      buffer .Init (dataView, dataView .byteLength);

      let geometry, status;

      try
      {
         const type = decoder .GetEncodedGeometryType (buffer);

         switch (type)
         {
            case draco .TRIANGULAR_MESH:
               geometry = new draco .Mesh ();
               status   = decoder .DecodeBufferToMesh (buffer, geometry);
               break;
            case draco .POINT_CLOUD:
               geometry = new draco .PointCloud ();
               status   = decoder .DecodeBufferToPointCloud (buffer, geometry);
               break;
            default:
               throw new Error (`Invalid geometry type ${type}.`);
         }

         if (!status .ok () || !geometry .ptr)
            throw new Error (status .error_msg ());

         if (type === draco .TRIANGULAR_MESH)
         {
            const
               numFaces   = geometry .num_faces (),
               numIndices = numFaces * 3,
               byteLength = numIndices * 4,
               ptr        = draco ._malloc (byteLength);

            try
            {
               const indices = new Uint32Array (numIndices);

               decoder .GetTrianglesUInt32Array (geometry, byteLength, ptr);

               indices .set (new Uint32Array (draco .HEAPF32 .buffer, ptr, numIndices));

               indicesCallback (indices);
            }
            finally
            {
               draco ._free (ptr);
            }
         }

         for (const [key, id] of Object .entries (attributes))
         {
            const
               attribute     = decoder .GetAttributeByUniqueId (geometry, id),
               numComponents = attribute .num_components (),
               numPoints     = geometry .num_points (),
               numValues     = numPoints * numComponents,
               byteLength    = numValues * Float32Array .BYTES_PER_ELEMENT,
               ptr           = draco ._malloc (byteLength);

            try
            {
               const array = new Float32Array (numValues);

               decoder .GetAttributeDataArrayForAllPoints (geometry, attribute, draco .DT_FLOAT32, byteLength, ptr);

               array .set (new Float32Array (draco .HEAPF32 .buffer, ptr, numValues));

               attributeCallback (key, array);
            }
            finally
            {
               draco ._free (ptr);
            }
         }
      }
      finally
      {
         if (geometry)
            draco .destroy (geometry);

         draco .destroy (decoder);
         draco .destroy (buffer);
      }
   },
   async createDraco ()
   {
      if (this .constructor .draco)
      {
         return this .constructor .draco;
      }
      else
      {
         const
            response = await fetch (URLs/* default */.A .getLibraryURL ("draco_decoder_gltf.js")),
            text     = await response .text (),
            draco    = await new Function (text) () ();

         return this .constructor .draco = draco;
      }
   },
   khrMaterialsVariantsExtension (extensions, shapeNode)
   {
      if (!(extensions instanceof Object))
         return;

      return this .khrMaterialsVariantsObjectMappings (extensions .KHR_materials_variants, shapeNode);
   },
   khrMaterialsVariantsObjectMappings (KHR_materials_variants, shapeNode)
   {
      if (!(KHR_materials_variants instanceof Object))
         return;

      const mappings = KHR_materials_variants .mappings;

      if (!(mappings instanceof Array))
         return;

      if (!mappings .length)
         return;

      const
         scene        = this .getScene (),
         variantsNode = scene .createNode ("Switch", false);

      for (const mapping of mappings)
         this .khrMaterialsVariantsObjectMapping (mapping, shapeNode, variantsNode);

      variantsNode ._whichChoice = this .materialVariants .length;

      if (!variantsNode ._children .length)
         return;

      // Last child ist default material.
      variantsNode ._children [this .materialVariants .length] = shapeNode;

      // Fall back to default material if no active variant.
      for (const i of variantsNode ._children .keys ())
      {
         if (!variantsNode ._children [i])
            variantsNode ._children [i] = shapeNode;
      }

      variantsNode .setup ();

      this .materialVariantNodes .push (variantsNode);

      return variantsNode;
   },
   khrMaterialsVariantsObjectMapping (mapping, shapeNode, variantsNode)
   {
      if (!(mapping instanceof Object))
         return;

      mapping .material = this .materials [mapping .material];

      if (!mapping .material)
         return;

      const
         scene          = this .getScene (),
         variantNode    = this .getScene () .createNode ("Shape", false),
         appearanceNode = this .materialObject (mapping),
         variant        = mapping .variants ?.[0] ?? 0,
         name           = this .sanitizeName (this .materialVariants [variant] ?.name ?? "");

      if (name)
         scene .addNamedNode (scene .getUniqueName (name), variantNode);

      variantNode ._appearance = appearanceNode;
      variantNode ._geometry   = shapeNode ._geometry;

      variantNode .setup ();

      variantsNode ._children [variant] = variantNode;
   },
   camerasArray (cameras)
   {
      if (!(cameras instanceof Array))
         return;

      this .cameras = cameras;
   },
   cameraObject (id, camera)
   {
      if (!(camera instanceof Object))
         return null;

      if (camera .node !== undefined)
         return camera .node;

      const viewpointNode = this .cameraType (camera);

      if (!viewpointNode)
         return camera .node = null;

      const
         scene = this .getScene (),
         name  = this .sanitizeName (camera .name);

      // Name

      if (name)
      {
         scene .addNamedNode    (scene .getUniqueName       (name), viewpointNode);
         scene .addExportedNode (scene .getUniqueExportName (name), viewpointNode);
      }

      viewpointNode ._description = this .description (camera .name || `Viewpoint ${id + 1}`);
      viewpointNode ._position    = Vector3/* default */.A .ZERO;

      return camera .node = viewpointNode;
   },
   cameraType (camera)
   {
      switch (camera .type)
      {
         case "orthographic":
            return this .orthographicCamera (camera .orthographic);
         case "perspective":
            return this .perspectiveCamera (camera .perspective);
         default:
            return null;
      }
   },
   orthographicCamera (camera)
   {
      if (!(camera instanceof Object))
         return null;

      const
         scene         = this .getScene (),
         viewpointNode = scene .createNode ("OrthoViewpoint", false),
         xmag          = typeof camera .xmag === "number" ? camera .xmag : 1,
         ymag          = typeof camera .ymag === "number" ? camera .ymag : 1;

      viewpointNode ._fieldOfView [0] = -xmag;
      viewpointNode ._fieldOfView [1] = -ymag;
      viewpointNode ._fieldOfView [2] =  xmag;
      viewpointNode ._fieldOfView [3] =  ymag;

      if (typeof camera .znear === "number")
         viewpointNode ._nearDistance = camera .znear;

      if (typeof camera .zfar === "number")
         viewpointNode ._farDistance = camera .zfar;

      viewpointNode .setup ();

      this .addAnimationPointerAlias (viewpointNode, "znear", "nearDistance");
      this .addAnimationPointerAlias (viewpointNode, "zfar",  "farDistance");

      Object .defineProperty (camera, "pointers",
      {
         get: () =>
         {
            const scriptNode = scene .createNode ("Script", false);

            scriptNode .addUserDefinedField (X3DConstants/* default */.A .inputOutput, "xmag",          new Fields/* default */.A .SFFloat (xmag));
            scriptNode .addUserDefinedField (X3DConstants/* default */.A .inputOutput, "ymag",          new Fields/* default */.A .SFFloat (ymag));
            scriptNode .addUserDefinedField (X3DConstants/* default */.A .outputOnly,  "value_changed", new Fields/* default */.A .MFFloat ());

            scriptNode ._url = [/* js */ `ecmascript:

function eventsProcessed ()
{
   value_changed [0] = -xmag;
   value_changed [1] = -ymag;
   value_changed [2] =  xmag;
   value_changed [3] =  ymag;
}
`];

            scriptNode .setup ();

            scene .addNamedNode (scene .getUniqueName ("CombineFieldOfViewScript"), scriptNode);
            scene .addRoute (scriptNode, "value_changed", viewpointNode, "set_fieldOfView");

            this .animationScripts .push (scriptNode);

            Object .defineProperty (camera, "pointers", { value: [viewpointNode, scriptNode] });

            return [viewpointNode, scriptNode];
         },
         configurable: true,
      });

      return viewpointNode;
   },
   perspectiveCamera (camera)
   {
      if (!(camera instanceof Object))
         return null;

      const
         scene         = this .getScene (),
         viewpointNode = scene .createNode ("Viewpoint", false);

      if (typeof camera .yfov === "number")
         viewpointNode ._fieldOfView = camera .yfov;

      if (typeof camera .znear === "number")
         viewpointNode ._nearDistance = camera .znear;

      if (typeof camera .zfar === "number")
         viewpointNode ._farDistance = camera .zfar;

      viewpointNode .setup ();

      this .addAnimationPointerAlias (viewpointNode, "yfov",  "fieldOfView");
      this .addAnimationPointerAlias (viewpointNode, "znear", "nearDistance");
      this .addAnimationPointerAlias (viewpointNode, "zfar",  "farDistance");

      camera .pointers = [viewpointNode];

      return viewpointNode;
   },
   nodesArray (nodes)
   {
      if (!(nodes instanceof Array))
         return;

      this .nodes = nodes .map ((node, index) => this .nodeObject (node, index));

      // 1. Replace skeleton nodes with humanoid.
      // 2. Add children.

      this .nodes .forEach ((node, index) => this .nodeSkeleton (node, index));
      this .nodes .forEach ((node, index) => this .nodeChildren (node, index));
   },
   nodeObject (node, index)
   {
      if (!(node instanceof Object))
         return { };

      if (node .transformNode)
         return node;

      // Create Transform or HAnimJoint.

      const
         scene         = this .getScene (),
         typeName      = this .joints .has (index) ? "HAnimJoint" : "Transform",
         transformNode = scene .createNode (typeName, false);

      node .transformNode = transformNode;

      // Create humanoid.

      const skin = this .skins [node .skin];

      if (skin)
      {
         // Skins can be cloned.

         if (!skin .humanoidNode)
         {
            skin .humanoidNode = scene .createNode ("HAnimHumanoid", false);

            skin .joints .map (joint => this .humanoidIndex .set (joint, skin .humanoidNode))
         }

         node .humanoidNode = skin .humanoidNode;
      }

      node .childNode = node .humanoidNode ?? node .transformNode;
      node .pointers  = [node .childNode];

      return node;
   },
   nodeSkeleton (node, index)
   {
      const skin = this .skins [node .skin];

      if (!skin)
         return;

      const
         skeleton     = skin .skeleton .map (index => this .nodes [index]) .filter (node => node),
         humanoidNode = skin .humanoidNode;

      for (const node of skeleton)
      {
         node .humanoidNode = humanoidNode;
         node .childNode    = humanoidNode;
      }
   },
   nodeChildren: (() =>
   {
      const
         translation      = new Vector3/* default */.A (),
         rotation         = new Rotation4/* default */.A (),
         scale            = new Vector3/* default */.A (1),
         scaleOrientation = new Rotation4/* default */.A (),
         quaternion       = new Quaternion/* default */.A (),
         matrix           = new Matrix4/* default */.A ();

      return function (node, index)
      {
         const
            scene         = this .getScene (),
            transformNode = node .transformNode,
            name          = this .sanitizeName (node .name);

         // Name

         if (name)
         {
            scene .addNamedNode (scene .getUniqueName (name), transformNode);

            if (transformNode .getType () .at (-1) === X3DConstants/* default */.A .HAnimJoint)
               transformNode ._name = node .name;
         }

         // Set transformation matrix.

         if (this .vectorValue (node .matrix, matrix))
         {
            matrix .get (translation, rotation, scale, scaleOrientation);

            transformNode ._translation      = translation;
            transformNode ._rotation         = rotation;
            transformNode ._scale            = scale;
            transformNode ._scaleOrientation = scaleOrientation;
         }
         else
         {
            if (this .vectorValue (node .translation, translation))
               transformNode ._translation = translation;

            if (this .vectorValue (node .rotation, quaternion))
               transformNode ._rotation = rotation .setQuaternion (quaternion);

            if (this .vectorValue (node .scale, scale))
               transformNode ._scale = scale;
         }

         // Add mesh.

         const
            skin                    = this .skins [node .skin],
            EXT_mesh_gpu_instancing = node .extensions ?.EXT_mesh_gpu_instancing,
            shapeNodes              = this .meshObject (this .meshes [node .mesh], skin, EXT_mesh_gpu_instancing);

         // Add camera.

         const viewpointNode = this .cameraObject (node .camera, this .cameras [node .camera]);

         if (viewpointNode)
            transformNode ._children .push (viewpointNode);

         // Handle extensions.

         this .nodeExtensions (node);

         // Add children.

         let children = this .nodeChildrenArray (node .children);

         if (transformNode .getType () .at (-1) === X3DConstants/* default */.A .HAnimJoint)
         {
            // Add a HAnimSegment if there are recursive skeletons.

            children = children .map (childNode =>
            {
               if (childNode .getType () .at (-1) === X3DConstants/* default */.A .HAnimHumanoid)
               {
                  const segmentNode = scene .createNode ("HAnimSegment", false);

                  segmentNode ._children .push (childNode);

                  segmentNode .setup ();

                  const humanoidNode = this .humanoidIndex .get (index);

                  humanoidNode ?._segments .push (segmentNode);

                  return segmentNode;
               }
               else
               {
                  return childNode;
               }
            });
         }

         transformNode ._children .push (... children);

         // Add Shape nodes.

         if (shapeNodes)
            transformNode ._children .push (... shapeNodes);

         transformNode .setup ();

         // Skin

         if (!skin)
            return;

         const humanoidNode = skin .humanoidNode;

         if (!humanoidNode .isInitialized ())
         {
            const name = this .sanitizeName (skin .name) || transformNode .getName ();

            if (name)
               scene .addNamedNode (scene .getUniqueName (name), humanoidNode);

            humanoidNode ._name                  = skin .name ?? node .name ?? "";
            humanoidNode ._version               = "2.0";
            humanoidNode ._skeletalConfiguration = "GLTF";

            humanoidNode ._skeleton .push (... skin .skeleton
               .map (index => this .nodes [index] ?.transformNode) .filter (node => node));

            for (const [i, joint] of skin .joints .entries ())
            {
               const
                  jointNode         = this .nodes [joint] ?.transformNode,
                  inverseBindMatrix = skin .inverseBindMatrices [i] ?? Matrix4/* default */.A .IDENTITY;

               if (!jointNode)
                  continue;

               inverseBindMatrix .get (translation, rotation, scale);

               humanoidNode ._joints                .push (jointNode);
               humanoidNode ._jointBindingPositions .push (translation);
               humanoidNode ._jointBindingRotations .push (rotation);
               humanoidNode ._jointBindingScales    .push (scale);
            }

            humanoidNode .setup ();
         }

         if (shapeNodes ?.length)
         {
            humanoidNode ._skinNormal = shapeNodes [0] ._geometry .normal;
            humanoidNode ._skinCoord  = shapeNodes [0] ._geometry .coord;
         }

         humanoidNode ._skin .push (transformNode);
      };
   })(),
   nodeExtensions (node)
   {
      if (!(node .extensions instanceof Object))
         return;

      for (const [key, extension] of Object .entries (node .extensions))
      {
         if (!(extension instanceof Object))
            continue;

         switch (key)
         {
            case "KHR_lights_punctual":
            {
               const lightNode = this .lightObject (extension .light);

               if (!lightNode)
                  break;

               node .transformNode ._children .push (lightNode);
               break;
            }
            case "KHR_node_visibility":
            {
               // https://github.com/KhronosGroup/glTF/tree/main/extensions/2.0/Khronos/KHR_node_visibility
               extension .pointers       = [node .childNode];
               node .childNode ._visible = extension .visible ?? true;
               break;
            }
         }
      }
   },
   nodeChildrenArray (children)
   {
      if (!(children instanceof Array))
         return [ ];

      const nodes = Array .from (new Set (children
         .map (index => this .nodes [index] ?.childNode)
         .filter (node => node)
         .filter (node => node .getType () .at (-1) !== X3DConstants/* default */.A .HAnimHumanoid || !node .getCloneCount ())
      ));

      return nodes;
   },
   skinsArray (skins, nodes)
   {
      if (!(skins instanceof Array))
         return;

      if (!(nodes instanceof Array))
         return;

      this .skins = skins;

      for (const [i, skin] of skins .entries ())
         this .skinObject (i, skin, nodes);
   },
   skinObject (index, skin, nodes)
   {
      if (!(skin instanceof Object))
         return;

      const
         scene    = this .getScene (),
         skeleton = skin .skeleton;

      skin .joints              = this .jointsArray (skin .joints, nodes .some (node => node .skin === index));
      skin .skeleton            = skeleton !== undefined ? [skeleton] : this .skeleton (skin .joints, nodes);
      skin .inverseBindMatrices = this .inverseBindMatricesAccessors (this .accessors [skin .inverseBindMatrices]);

      if (skeleton !== undefined && !skin .joints .includes (skeleton))
      {
         // Ensure skeleton root node becomes a HAnimJoint node.

         this .joints .add (skeleton);
         skin .joints .push (skeleton);
      }

      skin .textureCoordinateNode      = scene .createNode ("TextureCoordinate",      false);
      skin .multiTextureCoordinateNode = scene .createNode ("MultiTextureCoordinate", false);
      skin .normalNode                 = scene .createNode ("Normal",                 false);
      skin .coordinateNode             = scene .createNode ("Coordinate",             false);

      skin .textureCoordinateNode ._mapping = "TEXCOORD_0";

      skin .textureCoordinateNode      .setup ();
      skin .multiTextureCoordinateNode .setup ();
      skin .normalNode                 .setup ();
      skin .coordinateNode             .setup ();
   },
   jointsArray (joints, add)
   {
      if (!(joints instanceof Array))
         return [ ];

      // If skin is not references anywhere, don't create HAnimJoint nodes.

      if (add)
         joints .forEach (index => this .joints .add (index));

      return joints;
   },
   skeleton (joints, nodes)
   {
      const children = new Set (joints
         .map (index => nodes [index])
         .filter (node => node instanceof Object)
         .filter (node => node .children instanceof Array)
         .flatMap (node => node .children));

      return joints .filter (index => !children .has (index));
   },
   inverseBindMatricesAccessors (inverseBindMatrices)
   {
      if (!inverseBindMatrices)
         return [ ];

      const
         array    = inverseBindMatrices .array,
         length   = array .length,
         matrices = [ ];

      for (let i = 0; i < length; i += 16)
         matrices .push (new Matrix4/* default */.A (... array .subarray (i, i + 16)));

      return matrices;
   },
   scenesArray (glTF, scenes, sceneNumber = 0)
   {
      if (!(scenes instanceof Array))
         return;

      const
         scene    = this .getScene (),
         children = scenes .map (scene => this .sceneObject (scene)) .filter (node => node);

      switch (children .length)
      {
         case 0:
         {
            return;
         }
         case 1:
         {
            if (sceneNumber === 0)
            {
               scene .getRootNodes () .push (children [0]);
               return;
            }

            // Proceed with next case:
         }
         default:
         {
            // Root

            const switchNode = scene .createNode ("Switch", false);

            scene .addNamedNode    (scene .getUniqueName       ("Scenes"), switchNode);
            scene .addExportedNode (scene .getUniqueExportName ("Scenes"), switchNode);

            // Scenes.

            switchNode ._whichChoice = sceneNumber;
            switchNode ._children    = children;

            switchNode .setup ();

            this .addAnimationPointerAlias (switchNode, "scene", "whichChoice");

            glTF .pointers = [switchNode];

            scene .getRootNodes () .push (switchNode);
            return;
         }
      }
   },
   sceneObject (scene)
   {
      if (!(scene instanceof Object))
         return null;

      const
         lightNode = this .envLightObject (scene .extensions ?.EXT_lights_image_based ?.light),
         nodes     = this .sceneNodesArray (scene .nodes);

      if (lightNode)
         nodes .unshift (lightNode);

      switch (nodes .length)
      {
         case 0:
         {
            return null;
         }
         case 1:
         {
            return nodes [0];
         }
         default:
         {
            const
               scene     = this .getScene (),
               groupNode = scene .createNode ("Group", false),
               name      = this .sanitizeName (scene .name);

            if (name)
               scene .addNamedNode (scene .getUniqueName (name), groupNode);

            groupNode ._children = nodes;

            groupNode .setup ();

            return groupNode;
         }
      }
   },
   sceneNodesArray (nodes)
   {
      return this .nodeChildrenArray (nodes);
   },
   exportGroup (name, array)
   {
      if (!(array instanceof Array))
         return;

      const nodes = array .map (object => object .node) .filter (node => node);

      if (!nodes .length)
         return;

      const
         scene     = this .getScene (),
         groupNode = scene .createNode ("Group", false);

      scene .addNamedNode    (scene .getUniqueName       (name), groupNode);
      scene .addExportedNode (scene .getUniqueExportName (name), groupNode);

      groupNode ._visible  = false;
      groupNode ._children = nodes;

      groupNode .setup ();

      scene .getRootNodes () .push (groupNode);
   },
   materialVariantsSwitch ()
   {
      if (!this .materialVariantNodes .length)
         return;

      const
         scene      = this .getScene (),
         switchNode = scene .createNode ("Switch", false),
         names      = this .materialVariants .map (object => object .name);

      scene .addNamedNode    (scene .getUniqueName       ("MaterialVariants"), switchNode);
      scene .addExportedNode (scene .getUniqueExportName ("MaterialVariants"), switchNode);

      switchNode ._whichChoice = 0;
      switchNode ._visible     = false;

      switchNode .setup ();
      switchNode .setMetaData ("MaterialVariants/names", new Fields/* default */.A .MFString (... names));

      for (const variantNode of this .materialVariantNodes)
         scene .addRoute (switchNode, "whichChoice", variantNode, "whichChoice");

      scene .getRootNodes () .push (switchNode);
   },
   animationsArray (animations)
   {
      if (!(animations instanceof Array))
         return;

      for (const [i, animation] of animations .entries ())
         this .animationObject (i, animation);
   },
   animationObject (id, animation)
   {
      if (!(animation instanceof Object))
         return null;

      const
         scene          = this .getScene (),
         timeSensorNode = scene .createNode ("TimeSensor", false),
         channelNodes   = this .animationChannelsArray (animation .channels, animation .samplers, timeSensorNode);

      if (!channelNodes .length)
         return;

      const
         groupNode = scene .createNode ("Group", false),
         name      = this .sanitizeName (animation .name);

      scene .addNamedNode (scene .getUniqueName (name || `Animation${id + 1}`), groupNode);
      scene .addNamedNode (scene .getUniqueName (`Timer${id + 1}`), timeSensorNode);
      scene .addExportedNode (scene .getUniqueExportName (name || `Animation${id + 1}`), groupNode);
      scene .addExportedNode (scene .getUniqueExportName (`Timer${id + 1}`), timeSensorNode);

      timeSensorNode ._description = this .description (animation .name) || `Animation ${id + 1}`;

      groupNode ._children .push (timeSensorNode, ... channelNodes);

      timeSensorNode .setup ();
      groupNode .setup ();

      animation .node = groupNode;
   },
   animationChannelsArray (channels, samplers, timeSensorNode)
   {
      if (!(channels instanceof Array))
         return [ ];

      if (!(samplers instanceof Array))
         return [ ];

      // Determine cycleInterval.

      const cycleInterval = samplers
         .map (sampler => this .accessors [sampler .input])
         .filter (input => input ?.array .length)
         .reduce ((value, input) => Math .max (value, input .array .at (-1)), 0);

      timeSensorNode ._cycleInterval = cycleInterval;

      // Get interpolators.

      channels = channels
         .flatMap (channel => this .animationChannelObject (channel, samplers, timeSensorNode));

      // Insert Script nodes after last interpolator.

      for (const scriptNode of this .animationScripts)
      {
         const index = channels .findLastIndex (node => node .getFields ()
            .some (field => Array .from (field .getOutputRoutes ())
            .some (route => route .getDestinationNode () === scriptNode)));

         channels .splice (index + 1, 0, scriptNode);
      }

      this .animationScripts .length = 0;

      return channels;
   },
   animationChannelObject (channel, samplers, timeSensorNode)
   {
      if (!(channel instanceof Object))
         return [ ];

      const target = channel .target;

      if (!(target instanceof Object))
         return [ ];

      const node = this .nodes [target .node] ?.transformNode;

      if (!node && target .path !== "pointer")
         return [ ];

      const sampler = samplers [channel .sampler];

      if (!sampler)
         return [ ];

      const input = this .accessors [sampler .input];

      if (!input)
         return [ ];

      if (!input .array .length)
         return [ ];

      const output = this .accessors [sampler .output];

      if (!output)
         return [ ];

      if (!output .array .length)
         return [ ];

      return this .createInterpolator (timeSensorNode, node, target, sampler .interpolation, input .array, output, timeSensorNode ._cycleInterval .getValue ());
   },
   cleanupAnimationScripts ()
   {
      // It can happen, that some scripts are not used, so let us remove them.

      const
         scene       = this .getScene (),
         scriptNodes = Array .from (scene .getNamedNodes (), node => node .getValue ())
            .filter (node => node .getType () .at (-1) === X3DConstants/* default */.A .Script);

      for (const scriptNode of scriptNodes)
      {
         if (scriptNode .getFields () .every (field => !field .getInputRoutes () .size))
         {
            scriptNode .dispose ();
            continue;
         }

         if (scriptNode .getFields () .every (field => !field .getOutputRoutes () .size))
         {
            scriptNode .dispose ();
            continue;
         }
      }
   },
   createShape (primitive, weights, skin, EXT_mesh_gpu_instancing)
   {
      const
         scene          = this .getScene (),
         shapeNode      = this .meshInstancing (EXT_mesh_gpu_instancing) ?? scene .createNode ("Shape", false),
         appearanceNode = this .materialObject (primitive),
         geometryNode   = this .createGeometry (primitive, weights, skin);

      shapeNode ._appearance = appearanceNode;
      shapeNode ._geometry   = geometryNode;

      shapeNode .setup ();

      return shapeNode;
   },
   meshInstancing (EXT_mesh_gpu_instancing)
   {
      if (!(EXT_mesh_gpu_instancing instanceof Object))
         return null;

      let
         attributes  = EXT_mesh_gpu_instancing .attributes,
         translation = this .accessors [attributes ?.TRANSLATION],
         rotation    = this .accessors [attributes ?.ROTATION],
         scale       = this .accessors [attributes ?.SCALE],
         count       = Math .max (translation ?.count ?? 0, rotation ?.count ?? 0, scale ?.count ?? 0);

      if (!count)
         return null;

      if (translation ?.type !== "VEC3")
         translation = null;

      if (rotation ?.type !== "VEC4")
         rotation = null;

      if (scale ?.type !== "VEC3")
         scale = null;

      const
         scene              = this .getScene (),
         instancedShapeNode = scene .createNode ("InstancedShape", false),
         translationArray   = translation ?.array,
         rotationArray      = rotation ?.array,
         scaleArray         = scale ?.array;

      if (translationArray)
         instancedShapeNode ._translations = translationArray;

      if (rotationArray)
      {
         const length = rotation .count * 4;

         for (let i = 0; i < length; i += 4)
         {
            instancedShapeNode ._rotations .push (new Rotation4/* default */.A (new Quaternion/* default */.A (rotationArray [i + 0],
                                                                                 rotationArray [i + 1],
                                                                                 rotationArray [i + 2],
                                                                                 rotationArray [i + 3])));
         }
      }

      if (scaleArray)
         instancedShapeNode ._scales = scaleArray;

      instancedShapeNode .setup ();

      return instancedShapeNode;
   },
   getDefaultAppearance ()
   {
      if (this .defaultAppearance)
         return this .defaultAppearance;

      const
         scene          = this .getScene (),
         appearanceNode = scene .createNode ("Appearance", false),
         materialNode   = scene .createNode ("PhysicalMaterial", false);

      appearanceNode ._alphaMode = "OPAQUE";
      appearanceNode ._material  = materialNode;
      materialNode   ._metallic  = 0;

      materialNode   .setup ();
      appearanceNode .setup ();

      return this .defaultAppearance = appearanceNode;
   },
   hasTextures (materialNode)
   {
      // Test PhysicalMaterial, UnlitMaterial ...

      if (+materialNode .getTextureBits ())
         return true;

      if (materialNode ._extensions ?.some (extension => +extension .getValue () .getTextureBits ()))
         return true;

      return false;
   },
   createMultiTextureTransform (materialNode)
   {
      if (!this .hasTextures (materialNode))
         return null;

      const textureTransformNodes = this .textureTransformNodes
         .sort ((a, b) => Algorithm/* default */.A .cmp (a ._mapping .getValue (), b ._mapping .getValue ()));

      switch (textureTransformNodes .length)
      {
         case 0:
         {
            return this .textureTransformNode ??= (() =>
            {
               const
                  scene                = this .getScene (),
                  textureTransformNode = scene .createNode ("TextureTransform", false);

               // Flip Y
               textureTransformNode ._translation .y = -1;
               textureTransformNode ._scale .y       = -1;

               textureTransformNode .setup ();

               return textureTransformNode;
            })();
         }
         case 1:
         {
            return textureTransformNodes [0];
         }
         default:
         {
            const
               scene                = this .getScene (),
               textureTransformNode = scene .createNode ("MultiTextureTransform", false);

            textureTransformNode ._textureTransform = textureTransformNodes;

            textureTransformNode .setup ();

            return textureTransformNode;
         }
      }
   },
   createGeometry (primitive, weights, skin)
   {
      switch (primitive .mode)
      {
         case 0: // POINTS
         {
            return this .createPointSet (primitive, weights, skin);
         }
         case 1: // LINES
         {
            if (primitive .indices)
               return this .createIndexedLineSet (primitive, weights, skin, 1);

            return this .createLineSet (primitive, weights, skin);
         }
         case 2: // LINE_LOOP
         {
            return this .createIndexedLineSet (primitive, weights, skin, 2);
         }
         case 3: // LINE_STRIP
         {
            return this .createIndexedLineSet (primitive, weights, skin, 3);
         }
         default:
         case 4: // TRIANGLES
         {
            if (primitive .indices)
               return this .createIndexedTriangleSet (primitive, weights, skin);

            return this .createTriangleSet (primitive, weights, skin);
         }
         case 5: // TRIANGLE_STRIP
         {
            if (primitive .indices)
               return this .createIndexedTriangleStripSet (primitive, weights, skin);

            return this .createTriangleStripSet (primitive, weights, skin);
         }
         case 6: // TRIANGLE_FAN
         {
            if (primitive .indices)
               return this .createIndexedTriangleFanSet (primitive, weights, skin);

            return this .createTriangleFanSet (primitive, weights, skin);
         }
      }
   },
   createPointSet ({ attributes, material, targets }, weights, skin)
   {
      const
         scene        = this .getScene (),
         geometryNode = scene .createNode ("PointSet", false);

      geometryNode ._color   = this .createColor (attributes .COLOR [0], material);
      geometryNode ._normal  = this .createNormal (attributes .NORMAL, targets, weights);
      geometryNode ._tangent = this .createTangent (attributes .TANGENT, attributes .NORMAL);
      geometryNode ._coord   = this .createCoordinate (attributes .POSITION, targets, weights);

      this .attributesJointsArray (skin, attributes .JOINTS, attributes .WEIGHTS);
      this .skinGeometry (skin, geometryNode);

      geometryNode .setup ();

      return geometryNode;
   },
   createIndexedLineSet ({ attributes, indices, material, targets }, weights, skin, mode)
   {
      const
         scene        = this .getScene (),
         geometryNode = scene .createNode ("IndexedLineSet", false);

      geometryNode ._color   = this .createColor (attributes .COLOR [0], material);
      geometryNode ._normal  = this .createNormal (attributes .NORMAL, targets, weights);
      geometryNode ._tangent = this .createTangent (attributes .TANGENT, attributes .NORMAL);
      geometryNode ._coord   = this .createCoordinate (attributes .POSITION, targets, weights);

      switch (mode)
      {
         case 1: // LINES
         {
            const
               coordIndex = geometryNode ._coordIndex,
               array      = indices .array,
               length     = array .length;

            for (let i = 0; i < length; i += 2)
               coordIndex .push (array [i], array [i + 1], -1);

            break;
         }
         case 2: // LINE_LOOP
         {
            const coordIndex = geometryNode ._coordIndex;

            if (indices)
            {
               for (const i of indices .array)
                  coordIndex .push (i);

               if (coordIndex .length)
                  coordIndex .push (coordIndex [0], -1);
            }
            else
            {
               const coord = geometryNode ._coord;

               if (coord ?.point .length)
               {
                  for (const i of coord .point .keys ())
                     coordIndex .push (i);

                  coordIndex .push (0, -1);
               }
            }

            break;
         }
         case 3: // LINE_STRIP
         {
            const coordIndex = geometryNode ._coordIndex;

            if (indices)
            {
               for (const i of indices .array)
                  coordIndex .push (i);

               if (coordIndex .length)
                  coordIndex .push (-1);
            }
            else
            {
               const coord = geometryNode ._coord;

               if (coord ?.point .length)
               {
                  for (const i of coord .point .keys ())
                     coordIndex .push (i);

                  coordIndex .push (-1);
               }
            }

            break;
         }
      }

      this .attributesJointsArray (skin, attributes .JOINTS, attributes .WEIGHTS);
      this .skinGeometry (skin, geometryNode);

      geometryNode .setup ();

      return geometryNode;
   },
   createLineSet ({ attributes, material, targets }, weights, skin)
   {
      const
         scene        = this .getScene (),
         geometryNode = scene .createNode ("LineSet", false);

      geometryNode ._color   = this .createColor (attributes .COLOR [0], material);
      geometryNode ._normal  = this .createNormal (attributes .NORMAL, targets, weights);
      geometryNode ._tangent = this .createTangent (attributes .TANGENT, attributes .NORMAL);
      geometryNode ._coord   = this .createCoordinate (attributes .POSITION, targets, weights);

      this .attributesJointsArray (skin, attributes .JOINTS, attributes .WEIGHTS);
      this .skinGeometry (skin, geometryNode);

      geometryNode .setup ();

      return geometryNode;
   },
   createIndexedTriangleSet ({ attributes, indices, material, targets }, weights, skin)
   {
      const
         scene        = this .getScene (),
         geometryNode = scene .createNode ("IndexedTriangleSet", false);

      geometryNode ._solid           = !material ?.doubleSided;
      geometryNode ._index           = indices .array;
      geometryNode ._color           = this .createColor (attributes .COLOR [0], material);
      geometryNode ._texCoord        = this .createMultiTextureCoordinate (attributes .TEXCOORD, material);
      geometryNode ._normal          = this .createNormal (attributes .NORMAL, targets, weights);
      geometryNode ._tangent         = this .createTangent (attributes .TANGENT, attributes .NORMAL);
      geometryNode ._coord           = this .createCoordinate (attributes .POSITION, targets, weights);
      geometryNode ._normalPerVertex = !! geometryNode ._normal .getValue ();

      this .attributesJointsArray (skin, attributes .JOINTS, attributes .WEIGHTS);
      this .skinGeometry (skin, geometryNode);

      geometryNode .setup ();

      return geometryNode;
   },
   createTriangleSet ({ attributes, material, targets }, weights, skin)
   {
      const
         scene        = this .getScene (),
         geometryNode = scene .createNode ("TriangleSet", false);

      geometryNode ._solid           = !material ?.doubleSided;
      geometryNode ._color           = this .createColor (attributes .COLOR [0], material);
      geometryNode ._texCoord        = this .createMultiTextureCoordinate (attributes .TEXCOORD, material);
      geometryNode ._normal          = this .createNormal (attributes .NORMAL, targets, weights);
      geometryNode ._tangent         = this .createTangent (attributes .TANGENT, attributes .NORMAL);
      geometryNode ._coord           = this .createCoordinate (attributes .POSITION, targets, weights);
      geometryNode ._normalPerVertex = !! geometryNode ._normal .getValue ();

      this .attributesJointsArray (skin, attributes .JOINTS, attributes .WEIGHTS);
      this .skinGeometry (skin, geometryNode);

      geometryNode .setup ();

      return geometryNode;
   },
   createIndexedTriangleStripSet ({ attributes, indices, material, targets }, weights, skin)
   {
      const
         scene        = this .getScene (),
         geometryNode = scene .createNode ("IndexedTriangleStripSet", false);

      geometryNode ._solid           = !material ?.doubleSided;
      geometryNode ._index           = indices .array;
      geometryNode ._color           = this .createColor (attributes .COLOR [0], material);
      geometryNode ._texCoord        = this .createMultiTextureCoordinate (attributes .TEXCOORD, material);
      geometryNode ._normal          = this .createNormal (attributes .NORMAL, targets, weights);
      geometryNode ._tangent         = this .createTangent (attributes .TANGENT, attributes .NORMAL);
      geometryNode ._coord           = this .createCoordinate (attributes .POSITION, targets, weights);
      geometryNode ._normalPerVertex = !! geometryNode ._normal .getValue ();

      this .attributesJointsArray (skin, attributes .JOINTS, attributes .WEIGHTS);
      this .skinGeometry (skin, geometryNode);

      geometryNode .setup ();

      return geometryNode;
   },
   createTriangleStripSet ({ attributes, material, targets }, weights, skin)
   {
      const
         scene        = this .getScene (),
         geometryNode = scene .createNode ("TriangleStripSet", false);

      geometryNode ._solid           = !material ?.doubleSided;
      geometryNode ._color           = this .createColor (attributes .COLOR [0], material);
      geometryNode ._texCoord        = this .createMultiTextureCoordinate (attributes .TEXCOORD, material);
      geometryNode ._normal          = this .createNormal (attributes .NORMAL, targets, weights);
      geometryNode ._tangent         = this .createTangent (attributes .TANGENT, attributes .NORMAL);
      geometryNode ._coord           = this .createCoordinate (attributes .POSITION, targets, weights);
      geometryNode ._normalPerVertex = !! geometryNode ._normal .getValue ();

      const coord = geometryNode ._coord;

      if (coord)
      {
         if (coord .point .length)
            geometryNode ._stripCount = [coord .point .length];
      }

      this .attributesJointsArray (skin, attributes .JOINTS, attributes .WEIGHTS);
      this .skinGeometry (skin, geometryNode);

      geometryNode .setup ();

      return geometryNode;
   },
   createIndexedTriangleFanSet ({ attributes, indices, material, targets }, weights, skin)
   {
      const
         scene        = this .getScene (),
         geometryNode = scene .createNode ("IndexedTriangleFanSet", false);

      geometryNode ._solid           = !material ?.doubleSided;
      geometryNode ._index           = indices .array;
      geometryNode ._color           = this .createColor (attributes .COLOR [0], material);
      geometryNode ._texCoord        = this .createMultiTextureCoordinate (attributes .TEXCOORD, material);
      geometryNode ._normal          = this .createNormal (attributes .NORMAL, targets, weights);
      geometryNode ._tangent         = this .createTangent (attributes .TANGENT, attributes .NORMAL);
      geometryNode ._coord           = this .createCoordinate (attributes .POSITION, targets, weights);
      geometryNode ._normalPerVertex = !! geometryNode ._normal .getValue ();

      this .attributesJointsArray (skin, attributes .JOINTS, attributes .WEIGHTS);
      this .skinGeometry (skin, geometryNode);

      geometryNode .setup ();

      return geometryNode;
   },
   createTriangleFanSet ({ attributes, material, targets }, weights, skin)
   {
      const
         scene        = this .getScene (),
         geometryNode = scene .createNode ("TriangleFanSet", false);

      geometryNode ._solid           = !material ?.doubleSided;
      geometryNode ._color           = this .createColor (attributes .COLOR [0], material);
      geometryNode ._texCoord        = this .createMultiTextureCoordinate (attributes .TEXCOORD, material);
      geometryNode ._normal          = this .createNormal (attributes .NORMAL, targets, weights);
      geometryNode ._tangent         = this .createTangent (attributes .TANGENT, attributes .NORMAL);
      geometryNode ._coord           = this .createCoordinate (attributes .POSITION, targets, weights);
      geometryNode ._normalPerVertex = !! geometryNode ._normal .getValue ();

      const coord = geometryNode ._coord;

      if (coord)
      {
         if (coord .point .length)
            geometryNode ._fanCount = [coord .point .length];
      }

      this .attributesJointsArray (skin, attributes .JOINTS, attributes .WEIGHTS);
      this .skinGeometry (skin, geometryNode);

      geometryNode .setup ();

      return geometryNode;
   },
   createColor: (() =>
   {
      const TypeNames = new Map ([
         ["VEC3", "Color"],
         ["VEC4", "ColorRGBA"],
      ]);

      return function (color, material)
      {
         if (!(color instanceof Object))
            return null;

         const typeName = TypeNames .get (color .type);

         if (!typeName)
            return null;

         if (color .colorNode)
            return color .colorNode;

         const
            scene          = this .getScene (),
            appearanceNode = this .materialObject ({ material }),
            opaque         = appearanceNode ._alphaMode .getValue () === "OPAQUE",
            colorNode      = scene .createNode (opaque ? "Color" : typeName, false);

         colorNode ._color = opaque && typeName !== "Color"
            ? color .array .filter ((_, i) => (i + 1) % 4)
            : color .array;

         colorNode .setup ();

         return color .colorNode = colorNode;
      };
   })(),
   createMultiTextureCoordinate (texCoords, material)
   {
      const
         appearanceNode = this .materialObject ({ material }),
         materialNode   = appearanceNode ._material .getValue ();

      if (!this .hasTextures (materialNode))
         return null;

      if (texCoords .textureCoordinateNode)
         return texCoords .textureCoordinateNode;

      switch (texCoords .length === 1 ? 1 : material .texCoordMappings .size)
      {
         case 0:
         {
            return null;
         }
         case 1:
         {
            return texCoords .textureCoordinateNode = Array .from (material .texCoordMappings .entries (), ([mapping, i]) => this .createTextureCoordinate (texCoords [i], mapping)) [0];
         }
         default:
         {
            const textureCoordinateNodes = Array .from (material .texCoordMappings .entries ())
               .sort ((a, b) => Algorithm/* default */.A .cmp (a [0], b [0]))
               .sort ((a, b) => a [1] - b [1])
               .map (([mapping, i]) => this .createTextureCoordinate (texCoords [i], mapping));

            if (!textureCoordinateNodes .length)
               return null;

            const
               scene                 = this .getScene (),
               textureCoordinateNode = scene .createNode ("MultiTextureCoordinate", false);

            textureCoordinateNode ._texCoord = textureCoordinateNodes;

            textureCoordinateNode .setup ();

            return texCoords .textureCoordinateNode = textureCoordinateNode;
         }
      }
   },
   createTextureCoordinate (texCoord, mapping)
   {
      if (texCoord ?.type !== "VEC2")
         return null;

      if (texCoord [mapping])
         return texCoord [mapping];

      const
         scene                 = this .getScene (),
         textureCoordinateNode = scene .createNode ("TextureCoordinate", false);

      textureCoordinateNode ._mapping = mapping;
      textureCoordinateNode ._point   = texCoord .array;

      textureCoordinateNode .setup ();

      return texCoord [mapping] = textureCoordinateNode;
   },
   createNormal (normal, targets, weights)
   {
      if (normal ?.type !== "VEC3")
         return null;

      if (normal .normalNode)
         return normal .normalNode;

      const
         scene      = this .getScene (),
         normalNode = scene .createNode ("Normal", false);

      normalNode ._vector = normal .array;

      if ((targets instanceof Array) && (weights instanceof Array))
      {
         normal .field = normalNode ._vector .copy ();

         const vectors = this .applyMorphTargets (normalNode ._vector, targets, "NORMAL", weights);

         normalNode ._vector .length = 0;

         for (const vector of vectors)
            normalNode ._vector .push (vector);
      }
      else
      {
         normal .field = normalNode ._vector;
      }

      normalNode .setup ();

      return normal .normalNode = normalNode;
   },
   createTangent (tangent, normal)
   {
      // When the base mesh primitive does not specify normals, client implementations
      // MUST calculate flat normals for each morph target; the provided tangents and
      // their displacements (if present) MUST be ignored.

      if (normal ?.type !== "VEC3")
         return null;

      if (tangent ?.type !== "VEC4")
         return null;

      if (tangent .tangentNode)
         return tangent .tangentNode;

      const
         scene       = this .getScene (),
         tangentNode = scene .createNode ("Tangent", false);

      tangentNode ._vector = tangent .array;

      tangentNode .setup ();

      return tangent .tangentNode = tangentNode;
   },
   createCoordinate (position, targets, weights)
   {
      if (position ?.type !== "VEC3")
         return null;

      if (position .coordinateNode)
         return position .coordinateNode;

      const
         scene          = this .getScene (),
         coordinateNode = scene .createNode ("Coordinate", false);

      coordinateNode ._point = position .array;

      if ((targets instanceof Array) && (weights instanceof Array))
      {
         position .field = coordinateNode ._point .copy ();

         const points = this .applyMorphTargets (coordinateNode ._point, targets, "POSITION", weights);

         coordinateNode ._point .length = 0;

         for (const point of points)
            coordinateNode ._point .push (point);
      }
      else
      {
         position .field = coordinateNode ._point;
      }

      coordinateNode .setup ();

      return position .coordinateNode = coordinateNode;
   },
   attributesJointsArray (skin, joints, weights)
   {
      if (!(skin instanceof Object))
         return;

      if (!(joints instanceof Array))
         return;

      if (!(weights instanceof Array))
         return;

      for (let i = 0, length = joints .length; i < length; ++ i)
         this .attributesJointsObject (skin, joints [i], weights [i]);
   },
   attributesJointsObject (skin, joints, weights)
   {
      if (joints ?.type !== "VEC4")
         return;

      if (weights ?.type !== "VEC4")
         return;

      const
         start        = skin .coordinateNode ._point .length,
         jointsArray  = joints .array,
         weightsArray = weights .array,
         numVertices  = jointsArray .length / 4;

      for (let v = 0; v < numVertices; ++ v)
      {
         for (let i = 0; i < 4; ++ i)
         {
            const w = weightsArray [v * 4 + i];

            if (w === 0)
               continue;

            const
               index     = skin .joints [jointsArray [v * 4 + i]],
               jointNode = this .nodes [index] ?.transformNode;

            if (jointNode ?.getType () .at (-1) !== X3DConstants/* default */.A .HAnimJoint)
               continue;

            jointNode ._skinCoordIndex  .push (v + start);
            jointNode ._skinCoordWeight .push (w);
         }
      }
   },
   skinGeometry (skin, geometryNode)
   {
      if (!(skin instanceof Object))
         return;

      const
         skinCoordinateNode    = skin .coordinateNode,
         start                 = skinCoordinateNode ._point .length,
         textureCoordinateNode = geometryNode ._texCoord ?.getValue (),
         normalNode            = geometryNode ._normal ?.getValue (),
         coordinateNode        = geometryNode ._coord ?.getValue ();

      if (geometryNode ._coordIndex)
         geometryNode ._coordIndex = geometryNode ._coordIndex .map (index => index < 0 ? -1 : index + start);

      if (geometryNode ._index)
         geometryNode ._index = geometryNode ._index .map (index => index < 0 ? -1 : index + start);

      if (textureCoordinateNode)
      {
         switch (textureCoordinateNode .getType () .at (-1))
         {
            case X3DConstants/* default */.A .TextureCoordinate:
            {
               const
                  skinTextureCoordinateNode = skin .textureCoordinateNode,
                  point                     = skinTextureCoordinateNode ._point;

               textureCoordinateNode ._point .forEach ((p, i) => point [i + start] = p);
               geometryNode ._texCoord = skinTextureCoordinateNode;

               break;
            }
            case X3DConstants/* default */.A .MultiTextureCoordinate:
            {
               const skinMultiTextureCoordinateNode = skin .multiTextureCoordinateNode;

               for (const t of textureCoordinateNode ._texCoord)
               {
                  let s = skinMultiTextureCoordinateNode ._texCoord .find (s => s .mapping === t .mapping) ?.getValue ();

                  if (!s)
                  {
                     if (t .mapping === "TEXCOORD_0")
                     {
                        s = skin .textureCoordinateNode;
                     }
                     else
                     {
                        s           = this .getScene () .createNode ("TextureCoordinate", false);
                        s ._mapping = t .mapping;

                        s .setup ();
                     }

                     skinMultiTextureCoordinateNode ._texCoord .push (s);
                  }

                  const point = s ._point;

                  t .point .forEach ((p, i) => point [i + start] = p);
               }

               geometryNode ._texCoord = skinMultiTextureCoordinateNode;
               break;
            }
         }
      }

      if (normalNode)
      {
         const
            skinNormalNode = skin .normalNode,
            vector         = skinNormalNode ._vector;

         normalNode ._vector .forEach ((v, i) => vector [i + start] = v);
         geometryNode ._normal = skinNormalNode;
      }

      if (coordinateNode)
      {
         const point = skinCoordinateNode ._point;
         coordinateNode ._point .forEach ((p, i) => point [i + start] = p);
         geometryNode ._coord = skinCoordinateNode;
      }
   },
   createInterpolator (timeSensorNode, node, target, interpolation, times, keyValues, cycleInterval)
   {
      const scene = this .getScene ();

      switch (target .path)
      {
         case "pointer":
         {
            const [node, field] = this .getAnimationPointer (target .extensions ?.KHR_animation_pointer ?.pointer);

            return this .createAnimationPointerInterpolator (timeSensorNode, node, field, interpolation, times, keyValues, cycleInterval);
         }
         case "translation":
         case "rotation":
         case "scale":
         {
            const field = node .getField (target .path);

            return this .createAnimationPointerInterpolator (timeSensorNode, node, field, interpolation, times, keyValues, cycleInterval);
         }
         case "weights":
         {
            const
               node              = this .nodes [target .node],
               mesh              = this .meshes [node .mesh],
               primitives        = mesh ?.primitives,
               interpolatorNodes = [ ];

            if (!(primitives instanceof Array))
               return null;

            for (const { shapeNode, targets, attributes } of primitives)
            {
               const geometryNode = shapeNode ._geometry .getValue ();

               if (!geometryNode || !geometryNode ._coord .getValue ())
                  continue;

               if (attributes ["POSITION"] ?.field .length !== geometryNode ._coord .point .length)
                  continue;

               const coordinateInterpolatorNode = this .createArrayInterpolator ("CoordinateInterpolator", interpolation, times, keyValues .array, cycleInterval, targets, attributes, "POSITION");

               if (!coordinateInterpolatorNode)
                  continue;

               if (coordinateInterpolatorNode ._key .length < 2)
                  continue;

               if (coordinateInterpolatorNode ._keyValue .length / coordinateInterpolatorNode ._key .length !== geometryNode ._coord .point .length)
                  continue;

               interpolatorNodes .push (coordinateInterpolatorNode);

               scene .addRoute (timeSensorNode, "fraction_changed", coordinateInterpolatorNode, "set_fraction");
               scene .addRoute (coordinateInterpolatorNode, "value_changed", geometryNode ._coord, "point");
            }

            for (const { shapeNode, targets, attributes } of primitives)
            {
               const geometryNode = shapeNode ._geometry .getValue ();

               if (!geometryNode || !geometryNode ._normal .getValue ())
                  continue;

               if (attributes ["NORMAL"] ?.field .length !== geometryNode ._normal .vector .length)
                  continue;

               const normalInterpolatorNode = this .createArrayInterpolator ("NormalInterpolator", interpolation, times, keyValues .array, cycleInterval, targets, attributes, "NORMAL");

               if (!normalInterpolatorNode)
                  continue;

               if (normalInterpolatorNode ._key .length < 2)
                  continue;

               if (normalInterpolatorNode ._keyValue .length / normalInterpolatorNode ._key .length !== geometryNode ._normal .vector .length)
                  continue;

               interpolatorNodes .push (normalInterpolatorNode);

               scene .addRoute (timeSensorNode, "fraction_changed", normalInterpolatorNode, "set_fraction");
               scene .addRoute (normalInterpolatorNode, "value_changed", geometryNode ._normal, "vector");
            }

            return interpolatorNodes;
         }
         default:
         {
            return [ ];
         }
      }
   },
   createAnimationPointerInterpolator: (() =>
   {
      const interpolators = new Map ([
         [X3DConstants/* default */.A .SFBool,  { typeName: "BooleanSequencer" }],
         [X3DConstants/* default */.A .SFInt32, { typeName: "IntegerSequencer" }],
         [X3DConstants/* default */.A .SFFloat, { typeName: "ScalarInterpolator",     components: 1 }],
         [X3DConstants/* default */.A .SFVec2f, { typeName: "PositionInterpolator2D", components: 2 }],
         [X3DConstants/* default */.A .SFVec3f, { typeName: "PositionInterpolator",   components: 3 }],
      ]);

      return function (timeSensorNode, node, field, interpolation, times, keyValues, cycleInterval)
      {
         if (!(node && field))
            return [ ];

         const scene = this .getScene ();

         switch (field .getType ())
         {
            case X3DConstants/* default */.A .SFColor:
            {
               const interpolatorNodes = [ ];

               let colors, transparencies;

               switch ((keyValues .array .length / times .length) % 3)
               {
                  case 0: // Color3 pointer
                  {
                     colors = keyValues .array;
                     break;
                  }
                  default: // Color4 pointer
                  {
                     colors         = keyValues .array .filter ((_, i) => i % 4 < 3),
                     transparencies = keyValues .array .filter ((_, i) => i % 4 === 3);

                     transparencies = transparencies .every (value => value >= 1)
                        ? undefined
                        : transparencies .map (value => 1 - value);

                     break;
                  }
               }

               const interpolatorNode = this .createNamedInterpolator ("ColorInterpolator", 3, interpolation, times, colors, cycleInterval);

               scene .addNamedNode (scene .getUniqueName (`${$.toUpperCaseFirst (field .getName ())}Interpolator`), interpolatorNode);

               scene .addRoute (timeSensorNode, "fraction_changed", interpolatorNode, "set_fraction");
               scene .addRoute (interpolatorNode, "value_changed", node, field .getName ());

               interpolatorNodes .push (interpolatorNode);

               // These are currently the only two affected fields, which are SFColor but pointer is Color4.
               if (field .getName () .match (/^(?:baseColor|emissiveColor)$/) && transparencies)
               {
                  const interpolatorNode = this .createNamedInterpolator ("ScalarInterpolator", 1, interpolation, times, transparencies, cycleInterval);

                  scene .addNamedNode (scene .getUniqueName ("TransparencyInterpolator"), interpolatorNode);

                  scene .addRoute (timeSensorNode, "fraction_changed", interpolatorNode, "set_fraction");
                  scene .addRoute (interpolatorNode, "value_changed", node, "transparency");

                  interpolatorNodes .push (interpolatorNode);
               }

               return interpolatorNodes;
            }
            case X3DConstants/* default */.A .SFColorRGBA:
            {
               const interpolatorNodes = [ ];

               let
                  colors         = keyValues .array .filter ((_, i) => i % 4 < 3),
                  transparencies = keyValues .array .filter ((_, i) => i % 4 === 3);

               transparencies = transparencies .every (value => value >= 1)
                  ? undefined
                  : transparencies .map (value => 1 - value);

               // Script

               const scriptNode = scene .createNode ("Script", false);

               scriptNode .addUserDefinedField (X3DConstants/* default */.A .inputOutput, "color",         new Fields/* default */.A .SFColor (1, 1, 1));
               scriptNode .addUserDefinedField (X3DConstants/* default */.A .inputOutput, "alpha" ,        new Fields/* default */.A .SFFloat (1));
               scriptNode .addUserDefinedField (X3DConstants/* default */.A .outputOnly,  "value_changed", new Fields/* default */.A .SFColorRGBA ());

               scriptNode ._url = [/* js */ `ecmascript:

function eventsProcessed ()
{
   value_changed [0] = color [0];
   value_changed [1] = color [1];
   value_changed [2] = color [2];
   value_changed [3] = alpha;
}
   `];

               scriptNode .setup ();

               scene .addNamedNode (scene .getUniqueName ("CombineColorRGBAScript"), scriptNode);
               scene .addRoute (scriptNode, "value_changed", node, field .getName ());

               // ColorInterpolator

               const interpolatorNode = this .createNamedInterpolator ("ColorInterpolator", 3, interpolation, times, colors, cycleInterval);

               scene .addNamedNode (scene .getUniqueName (`${$.toUpperCaseFirst (field .getName ())}Interpolator`), interpolatorNode);

               scene .addRoute (timeSensorNode, "fraction_changed", interpolatorNode, "set_fraction");
               scene .addRoute (interpolatorNode, "value_changed", scriptNode, "color");

               interpolatorNodes .push (interpolatorNode);

               // AlphaInterpolator

               if (transparencies)
               {
                  const interpolatorNode = this .createNamedInterpolator ("ScalarInterpolator", 1, interpolation, times, transparencies, cycleInterval);

                  scene .addNamedNode (scene .getUniqueName ("AlphaInterpolator"), interpolatorNode);

                  scene .addRoute (timeSensorNode, "fraction_changed", interpolatorNode, "set_fraction");
                  scene .addRoute (interpolatorNode, "value_changed", scriptNode, "alpha");

                  interpolatorNodes .push (interpolatorNode);
               }

               interpolatorNodes .push (scriptNode);

               return interpolatorNodes;
            }
            case X3DConstants/* default */.A .SFRotation:
            {
               const interpolatorNode = this .createOrientationInterpolator (interpolation, times, keyValues .array, cycleInterval);

               scene .addNamedNode (scene .getUniqueName (`${$.toUpperCaseFirst (field .getName ())}Interpolator`), interpolatorNode);

               scene .addRoute (timeSensorNode, "fraction_changed", interpolatorNode, "set_fraction");
               scene .addRoute (interpolatorNode, "value_changed", node, field .getName ());

               return interpolatorNode;
            }
            case X3DConstants/* default */.A .SFBool:
            case X3DConstants/* default */.A .SFInt32:
            case X3DConstants/* default */.A .SFFloat:
            case X3DConstants/* default */.A .SFVec2f:
            case X3DConstants/* default */.A .SFVec3f:
            {
               const
                  { typeName, components} = interpolators .get (field .getType ()),
                  suffix                  = typeName .replace (/^.*?(Sequencer|Interpolator).*?$/, "$1");

               const interpolatorNode = this .createNamedInterpolator (typeName, components, components ? interpolation : "LINEAR", times, keyValues .array, cycleInterval);

               scene .addNamedNode (scene .getUniqueName ($.toUpperCaseFirst (field .getName ()) + suffix), interpolatorNode);

               scene .addRoute (timeSensorNode, "fraction_changed", interpolatorNode, "set_fraction");
               scene .addRoute (interpolatorNode, "value_changed", node, field .getName ());

               return interpolatorNode;
            }
            default:
            {
               return [ ];
            }
         }
      };
   })(),
   getAnimationPointer (pointer = "")
   {
      const
         path  = pointer .split ("/") .filter (p => p),
         field = path .pop () .replace (/(?:Factor$)/, "");

      let glTF = this .input;

      for (const property of path)
         glTF = glTF ?.[property];

      return glTF ?.pointers
         ?.map (node => [node, $.try (() => node ?.getField (this .getAnimationPointerAlias (node, field) ?? field))])
         ?.find (([node, field]) => field)
         ?? [ ];
   },
   addAnimationPointerAlias (node, field, alias)
   {
      const key = `${node .getTypeName ()}.${field}`;

      this .pointerAliases .set (key, alias);
   },
   getAnimationPointerAlias (node, field)
   {
      const key = `${node .getTypeName ()}.${field}`;

      return this .pointerAliases .get (key);
   },
   createNamedInterpolator (typeName, components, interpolation, times, keyValues, cycleInterval)
   {
      const
         scene            = this .getScene (),
         interpolatorNode = scene .createNode (typeName, false);

      switch (interpolation)
      {
         case "STEP":
         {
            const
               key      = [ ],
               keyValue = [ ];

            // Key

            key .push (times [0] / cycleInterval);

            for (let i = 1, length = times .length; i < length; ++ i)
               key .push (times [i] / cycleInterval, times [i] / cycleInterval);

            // KeyValue

            const components2 = components * 2;

            for (let c = 0; c < components; ++ c)
               keyValue .push (keyValues [c]);

            for (let i = 0, length = keyValues .length - components; i < length; i += components)
            {
               for (let c = 0; c < components2; ++ c)
                  keyValue .push (keyValues [i + c]);
            }

            // Finish

            interpolatorNode ._key      = key;
            interpolatorNode ._keyValue = keyValue;

            interpolatorNode .setup ();

            return interpolatorNode;
         }
         default:
         case "LINEAR":
         {
            interpolatorNode ._key      = times .map (t => t / cycleInterval);
            interpolatorNode ._keyValue = keyValues;

            interpolatorNode .setup ();

            return interpolatorNode;
         }
         case "CUBICSPLINE":
         {
            const
               key      = [ ],
               keyValue = [ ],
               vectors  = [ ],
               Vector   = [Vector2/* default */.A, Vector2/* default */.A, Vector3/* default */.A] [components - 1];

            for (let i = 0, length = keyValues .length; i < length; i += components)
            {
               vectors .push (new Vector (... keyValues .subarray (i, i + components)));
            }

            const
               length  = Math .floor (times .at (-1) * SAMPLES_PER_SECOND),
               samples = Array .from ({ length: length }, (_, i) => i / (length - 1) * times .at (-1))

            for (const t of samples)
            {
               key      .push (t / cycleInterval);
               keyValue .push (... this .cubicSplineVector (t, times, vectors));
            }

            // Finish

            interpolatorNode ._key      = key;
            interpolatorNode ._keyValue = components === 1 ? keyValue .filter ((_, i) => i % 2 < 1) : keyValue;

            interpolatorNode .setup ();

            return interpolatorNode;
         }
      }
   },
   createOrientationInterpolator (interpolation, times, keyValues, cycleInterval)
   {
      const
         scene            = this .getScene (),
         interpolatorNode = scene .createNode ("OrientationInterpolator", false);

      switch (interpolation)
      {
         case "STEP":
         {
            // Key

            interpolatorNode ._key .push (times [0] / cycleInterval);

            for (let i = 1, length = times .length; i < length; ++ i)
               interpolatorNode ._key .push (times [i] / cycleInterval, times [i] / cycleInterval);

            // KeyValue

            interpolatorNode ._keyValue .push (new Rotation4/* default */.A (new Quaternion/* default */.A (keyValues [0],
                                                                              keyValues [1],
                                                                              keyValues [2],
                                                                              keyValues [3])));

            for (let i = 0, length = keyValues .length - 4; i < length; i += 4)
            {
               interpolatorNode ._keyValue .push (new Rotation4/* default */.A (new Quaternion/* default */.A (keyValues [i + 0],
                                                                                 keyValues [i + 1],
                                                                                 keyValues [i + 2],
                                                                                 keyValues [i + 3])),
                                                  new Rotation4/* default */.A (new Quaternion/* default */.A (keyValues [i + 4],
                                                                                 keyValues [i + 5],
                                                                                 keyValues [i + 6],
                                                                                 keyValues [i + 7])));
            }

            // Finish

            interpolatorNode .setup ();

            return interpolatorNode;
         }
         default:
         case "LINEAR":
         {
            interpolatorNode ._key = times .map (t => t / cycleInterval);

            for (let i = 0, length = keyValues .length; i < length; i += 4)
            {
               interpolatorNode ._keyValue .push (new Rotation4/* default */.A (new Quaternion/* default */.A (keyValues [i + 0],
                                                                                 keyValues [i + 1],
                                                                                 keyValues [i + 2],
                                                                                 keyValues [i + 3])));
            }

            interpolatorNode .setup ();

            return interpolatorNode;
         }
         case "CUBICSPLINE":
         {
            const quaternions = [ ];

            for (let i = 0, length = keyValues .length; i < length; i += 4)
            {
               quaternions .push (new Quaternion/* default */.A (keyValues [i + 0],
                                                  keyValues [i + 1],
                                                  keyValues [i + 2],
                                                  keyValues [i + 3]));
            }

            const
               length  = Math .floor (times .at (-1) * SAMPLES_PER_SECOND),
               samples = Array .from ({ length: length }, (_, i) => i / (length - 1) * times .at (-1))

            for (const t of samples)
            {
               const q = this .cubicSplineVector (t, times, quaternions) .normalize ();

               interpolatorNode ._key      .push (t / cycleInterval);
               interpolatorNode ._keyValue .push (new Rotation4/* default */.A (q));
            }

            interpolatorNode .setup ();

            return interpolatorNode;
         }
      }
   },
   createArrayInterpolator (typeName, interpolation, times, weights, cycleInterval, targets, accessors, key)
   {
      const accessor = accessors [key];

      if (!accessor)
         return null;

      const
         scene            = this .getScene (),
         interpolatorNode = scene .createNode (typeName, false);

      switch (interpolation)
      {
         case "STEP":
         {
            // Key

            interpolatorNode ._key .push (times [0] / cycleInterval);

            for (let i = 1, length = times .length; i < length; ++ i)
               interpolatorNode ._key .push (times [i] / cycleInterval, times [i] / cycleInterval);

            // KeyValue

            const w = Array .from (targets .keys (), i => weights [i]);

            for (const value of this .applyMorphTargets (accessor .field, targets, key, w))
               interpolatorNode ._keyValue .push (value);

            for (let t = 1, length = times .length; t < length; ++ t)
            {
               const
                  w      = Array .from (targets .keys (), i => weights [t * targets .length + i]),
                  values = this .applyMorphTargets (accessor .field, targets, key, w);

               for (const value of values)
                  interpolatorNode ._keyValue .push (value);

               for (const value of values)
                  interpolatorNode ._keyValue .push (value);
            }

            // Finish

            interpolatorNode .setup ();

            return interpolatorNode;
         }
         default:
         case "LINEAR":
         {
            // Key

            interpolatorNode ._key = times .map (t => t / cycleInterval);

            // KeyValue

            for (const t of times .keys ())
            {
               const w = Array .from (targets .keys (), i => weights [t * targets .length + i]);

               for (const value of this .applyMorphTargets (accessor .field, targets, key, w))
                  interpolatorNode ._keyValue .push (value);
            }

            // Finish

            interpolatorNode .setup ();

            return interpolatorNode;
         }
         case "CUBICSPLINE":
         {
            // Key

            const
               length  = Math .floor (times .at (-1) * SAMPLES_PER_SECOND),
               samples = Array .from ({ length: length }, (_, i) => i / (length - 1) * times .at (-1))

            // KeyValue

            for (const t of samples)
            {
               interpolatorNode ._key .push (t / cycleInterval);

               const w = Array .from (targets .keys (), i => this .cubicSplineScalarArray (t, times, weights, targets .length, i));

               for (const value of this .applyMorphTargets (accessor .field, targets, key, w))
                  interpolatorNode ._keyValue .push (value);
            }

            // Finish

            interpolatorNode .setup ();

            return interpolatorNode;
         }
      }
   },
   applyMorphTargets: (() =>
   {
      const value = new Vector3/* default */.A ();

      return function (array, targets, key, weights)
      {
         const vectors = Array .from (array, v => v .getValue () .copy ());

         for (const [i, target] of targets .entries ())
         {
            const weight = weights [i];

            if (!weight)
               continue;

            const accessor = this .accessors [target [key]];

            if (accessor ?.type !== "VEC3")
               continue;

            const
               array  = accessor .array,
               length = array .length;

            for (let a = 0, p = 0; a < length; a += 3, ++ p)
               vectors [p] .add (value .set (array [a], array [a + 1], array [a + 2]) .multiply (weight));
         }

         return vectors;
      };
   })(),
   cubicSplineVector (time, times, values)
   {
      const
         index1 = Algorithm/* default */.A .clamp (Algorithm/* default */.A .upperBound (times, 0, times .length, time), 1, times .length - 1),
         index0 = index1 - 1,
         td     = times [index1] - times [index0],
         t1     = (time - times [index0]) / td,
         t2     = t1 * t1,
         t3     = t2 * t1,
         v0     = values [index0 * 3 + 1] .copy (),
         b0     = values [index0 * 3 + 2] .copy (),
         v1     = values [index1 * 3 + 1] .copy (),
         a1     = values [index1 * 3 + 0] .copy ();

      v0 .multiply (2 * t3 - 3 * t2 + 1);
      b0 .multiply (td * (t3 - 2 * t2 + t1));
      v1 .multiply (-2 * t3 + 3 * t2);
      a1 .multiply (td * (t3 - t2));

      return v0 .add (b0) .add (v1) .add (a1);
   },
   cubicSplineScalarArray (time, times, values, length, i)
   {
      const
         index1 = Algorithm/* default */.A .clamp (Algorithm/* default */.A .upperBound (times, 0, times .length, time), 1, times .length - 1),
         index0 = index1 - 1,
         td     = times [index1] - times [index0],
         t1     = (time - times [index0]) / td,
         t2     = t1 * t1,
         t3     = t2 * t1;

      let
         v0 = values [(index0 + 1) * length + i],
         b0 = values [(index0 + 2) * length + i],
         v1 = values [(index1 + 1) * length + i],
         a1 = values [(index1 + 0) * length + i];

      v0 *= 2 * t3 - 3 * t2 + 1;
      b0 *= td * (t3 - 2 * t2 + t1);
      v1 *= -2 * t3 + 3 * t2;
      a1 *= td * (t3 - t2);

      return v0 + b0 + v1 + a1;
   },
   vectorValue (array, vector)
   {
      if (!(array instanceof Array))
         return false;

      if (array .length !== vector .length)
         return false;

      vector .set (... array);

      return true;
   },
   numberValue (value, defaultValue)
   {
      if (typeof value !== "number")
         return defaultValue;

      return value;
   },
   stringValue (value, defaultValue)
   {
      if (typeof value !== "string")
         return defaultValue;

      return value;
   },
   description (string)
   {
      return string ?.replace (/_+/g, " ") .trim () ?? "";
   },
});

const GLTF2Parser_default_ = GLTF2Parser;
;

/* harmony default export */ const Parser_GLTF2Parser = (Namespace/* default */.A .add ("GLTF2Parser", GLTF2Parser_default_));
;// ./src/x_ite/Parser/GLB2Parser.js
/* provided dependency */ var GLB2Parser_$ = __webpack_require__(4993);



function GLB2Parser (scene)
{
   X3DParser/* default */.A .call (this, scene);

   this .json    = [ ];
   this .buffers = [ ];
}

Object .assign (Object .setPrototypeOf (GLB2Parser .prototype, X3DParser/* default */.A .prototype),
{
   getEncoding ()
   {
      return "ARRAY_BUFFER";
   },
   setInput (input)
   {
      this .arrayBuffer = input;
      this .dataView    = new DataView (input);
   },
   isValid ()
   {
      if (!(this .arrayBuffer instanceof ArrayBuffer))
         return false;

      if (this .dataView .byteLength < 12)
         return false;

      if (this .dataView .getUint32 (0, true) !== 0x46546C67)
         return false;

      if (this .dataView .getUint32 (4, true) !== 2)
         return false;

      if (this .dataView .getUint32 (8, true) !== this .dataView .byteLength)
         return false;

      return true;
   },
   parseIntoScene (resolve, reject)
   {
      this .glb ()
         .then (resolve)
         .catch (reject);
   },
   async glb ()
   {
      this .chunks ();

      const parser = new Parser_GLTF2Parser (this .getScene ());

      parser .setBuffers (this .buffers);

      for (const json of this .json)
      {
         parser .setInput (json);

         if (!parser .isValid ())
            continue;

         await parser .rootObject (parser .input);
      }

      return this .getScene ();
   },
   chunks ()
   {
      for (let i = 12; i < this .dataView .byteLength;)
      {
         const
            length = this .dataView .getUint32 (i, true),
            type   = this .dataView .getUint32 (i + 4, true);

         i += 8;

         switch (type)
         {
            case 0x4e4f534a: // Structured JSON content
            {
               this .json .push (GLB2Parser_$.decodeText (this .arrayBuffer .slice (i, i + length)));
               break;
            }
            case 0x004e4942: // Binary buffer
            {
               this .buffers .push (this .arrayBuffer .slice (i, i + length));
               break;
            }
         }

         i += length;
      }

      return this .getScene ();
   },
});

const GLB2Parser_default_ = GLB2Parser;
;

/* harmony default export */ const Parser_GLB2Parser = (Namespace/* default */.A .add ("GLB2Parser", GLB2Parser_default_));
// EXTERNAL MODULE: ./src/x_ite/Parser/Expressions.js
var Expressions = __webpack_require__(9845);
// EXTERNAL MODULE: ./src/x_ite/DEVELOPMENT.js
var DEVELOPMENT = __webpack_require__(5025);
;// ./src/x_ite/Parser/OBJParser.js
/* provided dependency */ var OBJParser_$ = __webpack_require__(4993);






// http://paulbourke.net/dataformats/obj/
// https://people.sc.fsu.edu/~jburkardt/data/obj/obj.html

/*
 *  Grammar
 */

// Lexical elements
const Grammar = (0,Expressions/* default */.A) ({
   // General
   whitespaces: /[\x20\n\t\r,]+/gy,
   whitespacesNoLineTerminator: /[\x20\t]+/gy,
   comment: /#.*?(?=[\n\r]|$)/gy,
   untilEndOfLine: /[^\r\n]+/gy,

   // Keywords
   mtllib: /\bmtllib\b/gy,
   usemtl: /\busemtl\b/gy,
   newmtl: /\bnewmtl\b/gy,
   Ka: /\bKa\b/gy,
   Kd: /\bKd\b/gy,
   Ks: /\bKs\b/gy,
   Ns: /\bNs\b/gy,
   d: /\bd\b/gy,
   Tr: /\bTr\b/gy,
   illum: /\billum\b/gy,
   map_Kd: /\bmap_Kd\b/gy,
   o: /\bo\b/gy,
   v: /\bv\b/gy,
   vt: /\bvt\b/gy,
   vn: /\bvn\b/gy,
   g: /\bg\b/gy,
   s: /\bs\b/gy,
   off: /\boff\b/gy,
   f: /\bf\b/gy,
   slash: /\//gy,

   // Values
   int32:  /(?:0[xX][\da-fA-F]+)|(?:[+-]?\d+)/gy,
   double: /[+-]?(?:(?:(?:\d*\.\d+)|(?:\d+(?:\.)?))(?:[eE][+-]?\d+)?)/gy,
   constants: /([+-])((?:NAN|INF|INFINITY))/igy,
});

/*
 * Parser
 */

function OBJParser (scene)
{
   X3DParser/* default */.A    .call (this, scene);
   Parser_X3DOptimizer .call (this);

   // Optimizer

   this .removeEmptyGroups    = true;
   this .combineGroupingNodes = false;

   // Globals

   this .geometryIndices = new Map ();
   this .smoothingGroup  = 0;
   this .smoothingGroups = new Map ();
   this .groups          = new Map ();
   this .materials       = new Map ();
   this .textures        = new Map ();
   this .lastIndex       = 0;
}

Object .assign (Object .setPrototypeOf (OBJParser .prototype, X3DParser/* default */.A .prototype),
   Parser_X3DOptimizer .prototype,
{
   CONSTANTS: new Map ([
      ["NAN", NaN],
      ["INF", Infinity],
      ["INFINITY", Infinity],
   ]),
   getEncoding ()
   {
      return "STRING";
   },
   setInput (string)
   {
      this .input = string;
   },
   isValid ()
   {
      if (typeof this .input !== "string")
         return false;

      return !! this .input .match (/^(?:[\x20\n\t\r]+|#.*?[\r\n])*\b(?:mtllib|usemtl|o|g|s|vt|vn|v|f)\b/);
   },
   parseIntoScene (resolve, reject)
   {
      this .obj ()
         .then (resolve)
         .catch (reject);
   },
   async obj ()
   {
      // Set profile and components.

      const
         browser = this .getBrowser (),
         scene   = this .getScene ();

      scene .setEncoding ("OBJ");
      scene .setProfile (browser .getProfile ("Interchange"));

      await browser .loadComponents (scene);

      // Init nodes.

      this .object          = scene .createNode ("Transform");
      this .group           = scene .createNode ("Group");
      this .defaultMaterial = scene .createNode ("Material");
      this .texCoord        = scene .createNode ("TextureCoordinate");
      this .normal          = scene .createNode ("Normal");
      this .coord           = scene .createNode ("Coordinate");

      this .texCoords = [ ];
      this .normals   = [ ];
      this .vertices  = [ ];

      this .object .children .push (this .group);

      scene .getRootNodes () .push (this .object);

      // Parse scene.

      await this .statements ();

      // Assign indices and points.

      for (const [geometry, indices] of this .geometryIndices)
      {
         geometry .texCoordIndex = indices .texCoordIndex;
         geometry .normalIndex   = indices .normalIndex;
         geometry .coordIndex    = indices .coordIndex;
      }

      this .texCoord .point  = this .texCoords;
      this .normal   .vector = this .normals;
      this .coord    .point  = this .vertices;

      // Finish scene.

      this .optimizeSceneGraph (scene .getRootNodes ());

      return this .getScene ();
   },
   comments ()
   {
      while (this .comment ())
         ;
   },
   comment ()
   {
      this .whitespaces ();

      if (Grammar .comment .parse (this))
         return true;

      return false;
   },
   whitespaces ()
   {
      Grammar .whitespaces .parse (this);
   },
   whitespacesNoLineTerminator ()
   {
      Grammar .whitespacesNoLineTerminator .parse (this);
   },
   async statements ()
   {
      while (await this .statement ())
         ;
   },
   async statement ()
   {
      if (await this .mtllibs ())
         return true;

      if (this .usemtl ())
         return true;

      if (this .o ())
         return true;

      if (this .g ())
         return true;

      if (this .s ())
         return true;

      if (this .vts ())
         return true;

      if (this .vns ())
         return true;

      if (this .vs ())
         return true;

      if (this .fs ())
         return true;

      // Skip empty and unknown lines.

      if (Grammar .untilEndOfLine .parse (this))
         return true;

      return false;
   },
   async mtllibs ()
   {
      this .comments ();

      if (Grammar .mtllib .parse (this))
      {
         this .whitespacesNoLineTerminator ();

         if (Grammar .untilEndOfLine .parse (this))
         {
            const mtllibs = this .result [0] .trim () .split (/\s+/);

            await Promise .all (mtllibs .map (path => this .mtllib (path)));
         }

         return true;
      }

      return false;
   },
   async mtllib (path)
   {
      try
      {
         const
            scene       = this .getExecutionContext (),
            url         = new URL (path, scene .getBaseURL ()),
            response    = await fetch (url),
            arrayBuffer = await response .arrayBuffer (),
            input       = OBJParser_$.decodeText (OBJParser_$.ungzip (arrayBuffer)),
            parser      = new MaterialParser (scene, input);

         parser .parse ();

         for (const [id, material] of parser .materials)
         {
            const name = this .sanitizeName (id);

            if (name)
            {
               scene .addNamedNode (scene .getUniqueName (name), material);
               scene .addExportedNode (scene .getUniqueExportName (name), material);
            }

            this .materials .set (id, material);
         }

         for (const [id, texture] of parser .textures)
         {
            const name = this .sanitizeName (id);

            if (name)
            {
               scene .addNamedNode (scene .getUniqueName (name), texture);
               scene .addExportedNode (scene .getUniqueExportName (name), texture);
            }

            this .textures .set (id, texture);
         }
      }
      catch (error)
      {
         console .warn (error);
      }
   },
   usemtl ()
   {
      this .comments ();

      if (Grammar .usemtl .parse (this))
      {
         this .whitespacesNoLineTerminator ();

         if (Grammar .untilEndOfLine .parse (this))
         {
            const id = this .result [0];

            this .material = this .materials .get (id) || this .defaultMaterial;
            this .texture  = this .textures .get (id);

            const smoothingGroup = this .smoothingGroups .get (this .group .getNodeName ());

            if (smoothingGroup)
               smoothingGroup .delete (this .smoothingGroup);
         }

         return true;
      }

      return false;
   },
   o ()
   {
      this .comments ();

      if (Grammar .o .parse (this))
      {
         this .whitespacesNoLineTerminator ();

         if (Grammar .untilEndOfLine .parse (this))
         {
            const
               scene = this .getExecutionContext (),
               name  = this .sanitizeName (this .result [0]);

            if (this .group .children .length)
            {
               this .object = scene .createNode("Transform");
               this .group  = scene .createNode ("Group");

               this .object .children .push (this .group);
               scene .getRootNodes () .push (this .object);
            }

            if (name && !this .object .getValue () .getName ())
            {
               scene .addNamedNode (scene .getUniqueName (name), this .object);
               scene .addExportedNode (scene .getUniqueExportName (name), this .object);
            }
         }

         return true;
      }

      return false;
   },
   g ()
   {
      this .comments ();

      if (Grammar .g .parse (this))
      {
         this .whitespacesNoLineTerminator ();

         if (Grammar .untilEndOfLine .parse (this))
         {
            const
               scene = this .getExecutionContext (),
               id    = this .result [0],
               name  = this .sanitizeName (id),
               group = this .groups .get (id);

            if (group)
            {
               this .group = group;
            }
            else
            {
               if (this .group .children .length)
               {
                  this .group = scene .createNode ("Group");

                  this .object .children .push (this .group);
               }
            }

            this .groups .set (id, this .group);

            if (name && !this .group .getValue () .getName ())
            {
               scene .addNamedNode (scene .getUniqueName (name), this .group);
               scene .addExportedNode (scene .getUniqueExportName (name), this .group);
            }

            this .smoothingGroup = 0;
         }

         return true;
      }

      return false;
   },
   s ()
   {
      this .comments ();

      if (Grammar .s .parse (this))
      {
         this .whitespacesNoLineTerminator ();

         if (Grammar .off .parse (this))
         {
            this .smoothingGroup = 0;
            return true;
         }

         if (this .int32 ())
         {
            this .smoothingGroup = this .value;
            return true;
         }

         return true;
      }

      return false;
   },
   vts ()
   {
      const texCoords = this .texCoords;

      let result = false;

      while (this .vt (texCoords))
         result = true;

      return result;
   },
   vt (texCoords)
   {
      this .comments ();

      if (Grammar .vt .parse (this))
      {
         if (this .vec2 (texCoords))
            return true;

         throw new Error ("Expected a texture coordinate.");
      }

      return false;
   },
   vns ()
   {
      const normals = this .normals;

      let result = false;

      while (this .vn (normals))
         result = true;

      return result;
   },
   vn (normals)
   {
      this .comments ();

      if (Grammar .vn .parse (this))
      {
         if (this .vec3 (normals))
            return true;

         throw new Error ("Expected a normal vector.");
      }

      return false;
   },
   vs ()
   {
      const vertices = this .vertices;

      let result = false;

      while (this .v (vertices))
         result = true;

      return result;
   },
   v (vertices)
   {
      this .comments ();

      if (Grammar .v .parse (this))
      {
         if (this .vec3 (vertices))
            return true;

         throw new Error ("Expected a vertex coordinate.");
      }

      return false;
   },
   fs ()
   {
      this .comments ();

      if (Grammar .f .lookahead (this))
      {
         try
         {
            this .shape    = this .smoothingGroups .get (this .group .getNodeName ()) .get (this .smoothingGroup);
            this .geometry = this .shape .geometry;

            const indices = this .geometryIndices .get (this .geometry);

            this .texCoordIndex = indices .texCoordIndex;
            this .normalIndex   = indices .normalIndex;
            this .coordIndex    = indices .coordIndex;
         }
         catch
         {
            const
               scene      = this .getExecutionContext (),
               appearance = scene .createNode ("Appearance");

            this .shape         = scene .createNode ("Shape");
            this .geometry      = scene .createNode ("IndexedFaceSet");
            this .texCoordIndex = [ ];
            this .normalIndex   = [ ];
            this .coordIndex    = [ ];

            this .geometryIndices .set (this .geometry,
            {
               texCoordIndex: this .texCoordIndex,
               normalIndex:   this .normalIndex,
               coordIndex:    this .coordIndex,
            });

            appearance .material        = this .material;
            appearance .texture         = this .texture;
            this .geometry .creaseAngle = this .smoothingGroup ? Math .PI : 0;
            this .shape .appearance     = appearance;
            this .shape .geometry       = this .geometry;

            this .group .children .push (this .shape);

            if (!this .smoothingGroups .has (this .group .getNodeName ()))
               this .smoothingGroups .set (this .group .getNodeName (), new Map ());

            this .smoothingGroups .get (this .group .getNodeName ()) .set (this .smoothingGroup, this .shape);
         }

         while (this .f ())
            ;

         if (this .texCoordIndex .length)
            this .geometry .texCoord = this .texCoord;

         if (this .normalIndex .length)
            this .geometry .normal = this .normal;

         this .geometry .coord = this .coord;

         return true;
      }

      return false;
   },
   f ()
   {
      this .comments ();

      if (Grammar .f .parse (this))
      {
         const
            texCoordIndex      = this .texCoordIndex,
            normalIndex        = this .normalIndex,
            coordIndex         = this .coordIndex,
            numTexCoordIndices = texCoordIndex .length,
            numNormalIndices   = normalIndex .length,
            numTexCoords       = this .texCoords .length,
            numNormals         = this .normals .length,
            numCoords          = this .vertices .length;

         while (this .indices (texCoordIndex, normalIndex, coordIndex, numTexCoords, numNormals, numCoords))
            ;

         if (texCoordIndex .length !== numTexCoordIndices)
            texCoordIndex .push (-1);

         if (normalIndex .length !== numNormalIndices)
            normalIndex .push (-1);

         coordIndex .push (-1);

         return true;
      }

      return false;
   },
   indices (texCoordIndex, normalIndex, coordIndex, numTexCoords, numNormals, numCoords)
   {
      if (this .int32 ())
      {
         coordIndex .push (this .index (this .value, numCoords));

         if (Grammar .slash .parse (this))
         {
            if (this .int32 ())
            {
               texCoordIndex .push (this .index (this .value, numTexCoords));
            }

            if (Grammar .slash .parse (this))
            {
               if (this .int32 ())
               {
                  normalIndex .push (this .index (this .value, numNormals));
               }
            }
         }

         return true;
      }

      return false;
   },
   index (index, length)
   {
      if (index === 0)
         throw new Error ("Invalid index.");

      if (index < 0)
         return length + index;

      return index - 1;
   },
   int32 ()
   {
      this .whitespaces ();

      if (Grammar .int32 .parse (this))
      {
         this .value = parseInt (this .result [0]);

         return true;
      }

      return false;
   },
   double ()
   {
      this .whitespaces ();

      if (Grammar .double .parse (this))
      {
         this .value = parseFloat (this .result [0]);

         return true;
      }

      if (Grammar .constants .parse (this))
      {
         this .value = this .CONSTANTS .get (this .result [2] .toUpperCase ());

         if (this .result [1] === "-")
            this .value = - this .value;

         return true;
      }

      return false;
   },
   vec2 (array)
   {
      if (this .double ())
      {
         const x = this .value;

         if (this .double ())
         {
            const y = this .value;

            array .push (x, y);
            return true;
         }
      }

      return false;
   },
   vec3 (array)
   {
      if (this .double ())
      {
         const x = this .value;

         if (this .double ())
         {
            const y = this .value;

            if (this .double ())
            {
               const z = this .value;

               array .push (x, y, z)
               return true;
            }
         }
      }

      return false;
   },
});

function MaterialParser (scene, input)
{
   this .executionContext = scene;
   this .input            = input;
   this .material         = scene .createNode ("Material");
   this .materials        = new Map ();
   this .textures         = new Map ();
   this .color3           = new Color3/* default */.A ();
   this .id               = "";
}

Object .assign (MaterialParser .prototype,
{
   CONSTANTS: new Map ([
      ["NAN", NaN],
      ["INF", Infinity],
      ["INFINITY", Infinity],
   ]),
   parse ()
   {
      try
      {
         this .statements ();
      }
      catch (error)
      {
         if (DEVELOPMENT/* default */.A)
            console .log (error);
      }
   },
   comments ()
   {
      while (this .comment ())
         ;
   },
   comment ()
   {
      this .whitespaces ();

      if (Grammar .comment .parse (this))
         return true;

      return false;
   },
   whitespaces ()
   {
      Grammar .whitespaces .parse (this);
   },
   whitespacesNoLineTerminator ()
   {
      Grammar .whitespacesNoLineTerminator .parse (this);
   },
   statements ()
   {
      while (this .statement ())
         ;
   },
   statement ()
   {
      if (this .newmtl ())
         return true;

      if (this .Ka ())
         return true;

      if (this .Kd ())
         return true;

      if (this .Ks ())
         return true;

      if (this .Ns ())
         return true;

      if (this .d ())
         return true;

      if (this .Tr ())
         return true;

      if (this .illum ())
         return true;

      if (this .map_Kd ())
         return true;

      // Skip empty and unknown lines.

      if (Grammar .untilEndOfLine .parse (this))
         return true;

      return false;
   },
   newmtl ()
   {
      this .comments ();

      if (Grammar .newmtl .parse (this))
      {
         this .whitespacesNoLineTerminator ();

         this .id = "";

         if (Grammar .untilEndOfLine .parse (this))
         {
            this .id = this .result [0];

            this .material = this .executionContext .createNode ("Material");

            this .materials .set (this .id, this .material);

            return true;
         }

         Grammar .untilEndOfLine .parse (this);

         return true;
      }

      return false;
   },
   Ka ()
   {
      this .comments ();

      if (Grammar .Ka .parse (this))
      {
         if (this .col3 ())
         {
            const hsv = this .color3 .getHSV ([ ]);

            this .material .ambientIntensity = hsv [2];

            return true;
         }

         Grammar .untilEndOfLine .parse (this);

         return true;
      }

      return false;
   },
   Kd ()
   {
      this .comments ();

      if (Grammar .Kd .parse (this))
      {
         if (this .col3 ())
         {
            this .material .diffuseColor = this .color3;

            return true;
         }

         Grammar .untilEndOfLine .parse (this);

         return true;
      }

      return false;
   },
   Ks ()
   {
      this .comments ();

      if (Grammar .Ks .parse (this))
      {
         if (this .col3 ())
         {
            this .material .specularColor = this .color3;

            return true;
         }

         Grammar .untilEndOfLine .parse (this);

         return true;
      }

      return false;
   },
   Ns ()
   {
      this .comments ();

      if (Grammar .Ns .parse (this))
      {
         if (this .double ())
         {
            this .material .shininess = this .value / 1000;

            return true;
         }

         Grammar .untilEndOfLine .parse (this);

         return true;
      }

      return false;
   },
   d ()
   {
      this .comments ();

      if (Grammar .d .parse (this))
      {
         if (this .double ())
         {
            this .material .transparency = 1 - this .value;

            return true;
         }

         Grammar .untilEndOfLine .parse (this);

         return true;
      }

      return false;
   },
   Tr ()
   {
      this .comments ();

      if (Grammar .Tr .parse (this))
      {
         if (this .double ())
         {
            this .material .transparency = this .value;

            return true;
         }

         Grammar .untilEndOfLine .parse (this);

         return true;
      }

      return false;
   },
   illum ()
   {
      this .comments ();

      if (Grammar .illum .parse (this))
      {
         if (this .int32 ())
         {
            // Don't know what to do with illum value in X3D.
            return true;
         }

         Grammar .untilEndOfLine .parse (this);

         return true;
      }

      return false;
   },
   map_Kd ()
   {
      this .comments ();

      if (Grammar .map_Kd .parse (this))
      {
         this .whitespacesNoLineTerminator ();

         if (Grammar .untilEndOfLine .parse (this))
         {
            const string = this .result [0];

            if (string .length && this .id .length)
            {
               const paths = string .trim () .split (/\s+/);

               if (paths .length)
               {
                  const
                     scene   = this .executionContext,
                     texture = scene .createNode ("ImageTexture"),
                     path    = paths .at (-1) .replace (/\\/g, "/");

                  texture .url = [path];

                  this .textures .set (this .id, texture);
               }
            }

            return true;
         }

         Grammar .untilEndOfLine .parse (this);

         return true;
      }

      return false;
   },
   int32 ()
   {
      this .whitespaces ();

      if (Grammar .int32 .parse (this))
      {
         this .value = parseInt (this .result [0]);

         return true;
      }

      return false;
   },
   double ()
   {
      this .whitespaces ();

      if (Grammar .double .parse (this))
      {
         this .value = parseFloat (this .result [0]);

         return true;
      }

      if (Grammar .constants .parse (this))
      {
         this .value = this .CONSTANTS .get (this .result [2] .toUpperCase ());

         if (this .result [1] === "-")
            this .value = -this .value;

         return true;
      }

      return false;
   },
   col3 ()
   {
      if (this .double ())
      {
         this .color3 .r = this .value;

         if (this .double ())
         {
            this .color3 .g = this .value;

            if (this .double ())
            {
               this .color3 .b = this .value;

               return true;
            }
         }
      }

      return false;
   },
});

const OBJParser_default_ = OBJParser;
;

/* harmony default export */ const Parser_OBJParser = (Namespace/* default */.A .add ("OBJParser", OBJParser_default_));
;// ./src/x_ite/Parser/STLAParser.js




// http://paulbourke.net/dataformats/stl/
// https://people.sc.fsu.edu/~jburkardt/data/obj/obj.html

/*
 *  Grammar
 */

// Lexical elements
const STLAParser_Grammar = (0,Expressions/* default */.A) ({
   // General
   whitespaces: /[\x20\n\t\r,]+/gy,
   whitespacesNoLineTerminator: /[\x20\t]+/gy,
   comment: /;.*?(?=[\n\r]|$)/gy,
   untilEndOfLine: /[^\r\n]+/gy,

   // Keywords
   solid: /solid/gy,
   facet: /facet/gy,
   normal: /normal/gy,
   outer: /outer/gy,
   loop: /loop/gy,
   vertex: /vertex/gy,
   endloop: /endloop/gy,
   endfacet: /endfacet/gy,
   endsolid: /endsolid/gy,

   // Values
   name: /\w+/gy,
   double: /[+-]?(?:(?:(?:\d*\.\d+)|(?:\d+(?:\.)?))(?:[eE][+-]?\d+)?)/gy,
   constants: /([+-])((?:NAN|INF|INFINITY))/igy,
});

/*
 * Parser
 */

function STLAParser (scene)
{
   X3DParser/* default */.A .call (this, scene);
}

Object .assign (Object .setPrototypeOf (STLAParser .prototype, X3DParser/* default */.A .prototype),
{
   CONSTANTS: new Map ([
      ["NAN", NaN],
      ["INF", Infinity],
      ["INFINITY", Infinity],
   ]),
   getEncoding ()
   {
      return "STRING";
   },
   setInput (string)
   {
      this .input = string;
   },
   isValid ()
   {
      if (typeof this .input !== "string")
         return false;

      return !! this .input .match (/^(?:[\x20\n\t\r]+|;.*?[\r\n])*\b(?:solid)\b/);
   },
   parseIntoScene (resolve, reject)
   {
      this .stl ()
         .then (resolve)
         .catch (reject);
   },
   async stl ()
   {
      // Set profile and components.

      const
         browser = this .getBrowser (),
         scene   = this .getScene ();

      scene .setEncoding ("STL");
      scene .setProfile (browser .getProfile ("Interchange"));

      await browser .loadComponents (scene);

      // Create nodes.

      this .material   = scene .createNode ("Material");
      this .appearance = scene .createNode ("Appearance");

      this .material .diffuseColor = Color3/* default */.A .WHITE;
      this .appearance .material   = this .material;

      // Parse scene.

      this .statements ();

      return this .getScene ();
   },
   comments ()
   {
      while (this .comment ())
         ;
   },
   comment ()
   {
      this .whitespaces ();

      if (STLAParser_Grammar .comment .parse (this))
         return true;

      return false;
   },
   whitespaces ()
   {
      STLAParser_Grammar .whitespaces .parse (this);
   },
   whitespacesNoLineTerminator ()
   {
      STLAParser_Grammar .whitespacesNoLineTerminator .parse (this);
   },
   statements ()
   {
      while (this .solid ())
         ;
   },
   solid ()
   {
      this .comments ();

      if (STLAParser_Grammar .solid .parse (this))
      {
         this .whitespacesNoLineTerminator ();

         const
            scene      = this .getExecutionContext (),
            shape      = scene .createNode ("Shape"),
            geometry   = scene .createNode ("TriangleSet"),
            normal     = scene .createNode ("Normal"),
            coordinate = scene .createNode ("Coordinate"),
            name       = this .sanitizeName (STLAParser_Grammar .name .parse (this) ? this .result [0] : "");

         STLAParser_Grammar .untilEndOfLine .parse (this);

         this .facets ();

         shape .appearance         = this .appearance;
         shape .geometry           = geometry;
         geometry .normalPerVertex = false;
         geometry .normal          = normal;
         geometry .coord           = coordinate;
         normal .vector            = this .normals;
         coordinate .point         = this .vertices;

         if (name)
         {
            scene .addNamedNode (scene .getUniqueName (name), shape);
            scene .addExportedNode (scene .getUniqueExportName (name), shape);
         }

         scene .getRootNodes () .push (shape);

         this .comments ();

         if (STLAParser_Grammar .endsolid .parse (this))
            return true;

         throw new Error ("Expected 'endsolid' statement.");
      }

      return false;
   },
   facets ()
   {
      this .normals  = [ ];
      this .vertices = [ ];

      while (this .facet (this .normals, this .vertices))
         ;
   },
   facet (normals, vertices)
   {
      this .comments ()

      if (STLAParser_Grammar .facet .parse (this))
      {
         if (this .normal (normals))
         {
            if (this .loop (vertices))
            {
               this .comments ();

               if (STLAParser_Grammar .endfacet .parse (this))
                  return true;

               throw new Error ("Expected 'endfacet' statement.");
            }
         }
      }

      return false;
   },
   normal (normals)
   {
      this .whitespacesNoLineTerminator ();

      if (STLAParser_Grammar .normal .parse (this))
      {
         if (this .double ())
         {
            const x = this .value;

            if (this .double ())
            {
               const y = this .value;

               if (this .double ())
               {
                  const z = this .value;

                  normals .push (x, y, z);
                  return true;
               }

               throw new Error ("Expected a double.");
            }

            throw new Error ("Expected a double.");
         }

         throw new Error ("Expected a double.");
      }

      throw new Error ("Expected 'normal' statement.");
   },
   loop (vertices)
   {
      this .comments ();

      if (STLAParser_Grammar .outer .parse (this))
      {
         this .whitespacesNoLineTerminator ();

         if (STLAParser_Grammar .loop .parse (this))
         {
            if (this .vertex (vertices))
            {
               if (this .vertex (vertices))
               {
                  if (this .vertex (vertices))
                  {
                     this .comments ();

                     if (STLAParser_Grammar .endloop .parse (this))
                        return true;

                     throw new Error ("Expected 'endloop' statement.");
                  }
               }
            }
         }

         throw new Error ("Expected 'loop' statement.");
      }

      throw new Error ("Expected 'outer' statement.");
   },
   vertex (vertices)
   {
      this .comments ();

      if (STLAParser_Grammar .vertex .parse (this))
      {
         if (this .double ())
         {
            const x = this .value;

            if (this .double ())
            {
               const y = this .value;

               if (this .double ())
               {
                  const z = this .value;

                  vertices .push (x, y, z);
                  return true;
               }

               throw new Error ("Expected a double.");
            }

            throw new Error ("Expected a double.");
         }

         throw new Error ("Expected a double.");
      }

      throw new Error ("Expected 'vertex' statement.");
   },
   double ()
   {
      this .whitespacesNoLineTerminator ();

      if (STLAParser_Grammar .double .parse (this))
      {
         this .value = parseFloat (this .result [0]);

         return true;
      }

      if (STLAParser_Grammar .constants .parse (this))
      {
         this .value = this .CONSTANTS .get (this .result [2] .toUpperCase ());

         if (this .result [1] === "-")
            this .value = - this .value;

         return true;
      }

      return false;
   },
});

const STLAParser_default_ = STLAParser;
;

/* harmony default export */ const Parser_STLAParser = (Namespace/* default */.A .add ("STLAParser", STLAParser_default_));
;// ./src/x_ite/Parser/STLBParser.js



// http://paulbourke.net/dataformats/stl/
// https://people.sc.fsu.edu/~jburkardt/data/obj/obj.html

/*
 * Parser
 */

function STLBParser (scene)
{
   X3DParser/* default */.A .call (this, scene);
}

Object .assign (Object .setPrototypeOf (STLBParser .prototype, X3DParser/* default */.A .prototype),
{
   getEncoding ()
   {
      return "ARRAY_BUFFER";
   },
   setInput (input)
   {
      this .arrayBuffer = input;
      this .dataView    = new DataView (input);
   },
   isValid ()
   {
      if (!(this .arrayBuffer instanceof ArrayBuffer))
         return false;

      if (this .dataView .byteLength < 84)
         return false;

      const
         numFaces   = this .dataView .getUint32 (80, true),
         byteLength = numFaces * 50 + 84;

      return byteLength === this .dataView .byteLength;
   },
   parseIntoScene (resolve, reject)
   {
      this .stl ()
         .then (resolve)
         .catch (reject);
   },
   async stl ()
   {
      // Set profile and components.

      const
         browser = this .getBrowser (),
         scene   = this .getScene ();

      scene .setEncoding ("STL");
      scene .setProfile (browser .getProfile ("Interchange"));

      await browser .loadComponents (scene);

      // Create nodes.

      this .material   = scene .createNode ("Material");
      this .appearance = scene .createNode ("Appearance");

      this .material .diffuseColor = Color3/* default */.A .WHITE;
      this .appearance .material   = this .material;

      // Parse scene.

      this .shape ();

      return this .getScene ();
   },
   shape ()
   {
      const
         scene      = this .getExecutionContext (),
         shape      = scene .createNode ("Shape"),
         geometry   = scene .createNode ("TriangleSet"),
         normal     = scene .createNode ("Normal"),
         coordinate = scene .createNode ("Coordinate"),
         dataView   = this .dataView,
         byteLength = this .dataView .byteLength,
         vector     = [ ],
         point      = [ ];

      for (let i = 84; i < byteLength; i += 50)
      {
         for (let f = 0; f < 3; ++ f)
            vector .push (dataView .getFloat32 (i + f * 4, true));

         for (let f = 3; f < 12; ++ f)
            point .push (dataView .getFloat32 (i + f * 4, true));
      }

      shape .appearance         = this .appearance;
      shape .geometry           = geometry;
      geometry .normalPerVertex = false;
      geometry .normal          = normal;
      geometry .coord           = coordinate;
      normal .vector            = vector;
      coordinate .point         = point;

      scene .getRootNodes () .push (shape);
   },
});

const STLBParser_default_ = STLBParser;
;

/* harmony default export */ const Parser_STLBParser = (Namespace/* default */.A .add ("STLBParser", STLBParser_default_));
;// ./src/x_ite/Parser/PLYAParser.js



/*
 *  Grammar
 */

// Lexical elements
const PLYAParser_Grammar = (0,Expressions/* default */.A) ({
   // General
   whitespaces: /[\x20\n\t\r,]+/gy,
   whitespacesNoLineTerminator: /[\x20\t]+/gy,
   untilEndOfLine: /[^\r\n]+/gy,
   line: /.*?\r?\n/gy,

   // Keywords
   ply: /ply/gy,
   format: /format ascii 1.0/gy,
   comment: /\bcomment\b/gy,
   element: /\belement\b/gy,
   elementName: /\b\S+\b/gy,
   property: /\bproperty\b/gy,
   propertyList: /\blist\b/gy,
   propertyType: /\b(?:char|uchar|short|ushort|int|uint|float|double|int8|uint8|int16|uint16|int32|uint32|float32|float64)\b/gy,
   propertyName: /\b\S+\b/gy,
   endHeader: /\bend_header\b/gy,

   double: /[+-]?(?:(?:(?:\d*\.\d+)|(?:\d+(?:\.)?))(?:[eE][+-]?\d+)?)/gy,
   int32:  /(?:0[xX][\da-fA-F]+)|(?:[+-]?\d+)/gy,
});

/*
 * Parser
 */

function PLYAParser (scene)
{
   X3DParser/* default */.A .call (this, scene);

   this .comments = [ ];

   this .typeMapping = new Map ([
      ["char",    this .int32],
      ["uchar",   this .int32],
      ["short",   this .int32],
      ["ushort",  this .int32],
      ["int",     this .int32],
      ["uint",    this .int32],
      ["float",   this .double],
      ["double",  this .double],
      ["int8",    this .int32],
      ["uint8",   this .int32],
      ["int16",   this .int32],
      ["uint16",  this .int32],
      ["int32",   this .int32],
      ["uint32",  this .int32],
      ["float32", this .double],
      ["float64", this .double],
   ]);
}

Object .assign (Object .setPrototypeOf (PLYAParser .prototype, X3DParser/* default */.A .prototype),
{
   getEncoding ()
   {
      return "STRING";
   },
   setInput (input)
   {
      this .input = input;
   },
   isValid ()
   {
      return this .input .match (/^ply\r?\nformat ascii 1.0/);
   },
   parseIntoScene (resolve, reject)
   {
      this .ply ()
         .then (resolve)
         .catch (reject);
   },
   async ply ()
   {
      // Set profile and components.

      const
         browser = this .getBrowser (),
         scene   = this .getScene ();

      scene .setEncoding ("PLY");
      scene .setProfile (browser .getProfile ("Interchange"));

      await browser .loadComponents (scene);

      this .processElements (this .header ([ ]))

      // Create nodes.

      return this .getScene ();
   },
   whitespacesOrComments ()
   {
      while (this .whitespaces () || this .comment ())
         ;
   },
   whitespaces ()
   {
      return PLYAParser_Grammar .whitespaces .parse (this);
   },
   whitespacesNoLineTerminator ()
   {
      PLYAParser_Grammar .whitespacesNoLineTerminator .parse (this);
   },
   comment ()
   {
      if (PLYAParser_Grammar .comment .parse (this) && PLYAParser_Grammar .untilEndOfLine .parse (this))
      {
         this .comments .push (this .result [0] .trim ());
         return true;
      }

      return false;
   },
   double ()
   {
      this .whitespacesNoLineTerminator ();

      if (PLYAParser_Grammar .double .parse (this))
      {
         this .value = parseFloat (this .result [0]);

         return true;
      }

      return false;
   },
   int32 ()
   {
      this .whitespacesNoLineTerminator ();

      if (PLYAParser_Grammar .int32 .parse (this))
      {
         this .value = parseInt (this .result [0]);

         return true;
      }

      return false;
   },
   convertColor (value, type)
   {
      switch (type)
      {
         case "uchar":
         case "uint8":
            return value / 0xff;
         case "ushort":
         case "uint16":
            return value / 0xfffff;
         case "uint":
         case "uint32":
            return value / 0xffffffff;
         case "float":
         case "float32":
         case "double":
         case "float64":
            return value;
      }
   },
   convertFDC (f_dc)
   {
      // https://github.com/graphdeco-inria/gaussian-splatting/issues/485

      const C0 = 0.28209479177387814;

      return 0.5 + C0 * f_dc;
   },
   header (elements)
   {
      PLYAParser_Grammar .ply .parse (this);
      PLYAParser_Grammar .whitespaces .parse (this);
      PLYAParser_Grammar .format .parse (this);

      this .headings (elements);

      const
         scene     = this .getScene (),
         worldInfo = scene .createNode ("WorldInfo"),
         url       = new URL (scene .worldURL);

      worldInfo .title = url .protocol === "data:" ? "PLY Model" : url .pathname .split ('/') .at (-1);
      worldInfo .info  = this .comments;

      scene .rootNodes .push (worldInfo);

      return elements;
   },
   headings (elements)
   {
      while (this .head (elements))
         ;
   },
   head (elements)
   {
      if (this .element (elements))
         return true;

      if (PLYAParser_Grammar .endHeader .parse (this))
         return false;

      if (PLYAParser_Grammar .untilEndOfLine .parse (this))
         return true;

      return false;
   },
   element (elements)
   {
      this .whitespacesOrComments ();

      if (PLYAParser_Grammar .element .parse (this))
      {
         this .whitespacesNoLineTerminator ();

         if (PLYAParser_Grammar .elementName .parse (this))
         {
            const name = this .result [0];

            if (this .int32 ())
            {
               const element =
               {
                  name: name,
                  count: this .value,
                  properties: [ ],
               };

               this .properties (element .properties);

               elements .push (element);
               return true;
            }
         }
      }

      return false;
   },
   properties (properties)
   {
      while (this .property (properties))
         ;
   },
   property (properties)
   {
      this .whitespacesOrComments ();

      if (PLYAParser_Grammar .property .parse (this))
      {
         this .whitespacesNoLineTerminator ();

         if (PLYAParser_Grammar .propertyType .parse (this))
         {
            const
               type  = this .result [0],
               value = this .typeMapping .get (type);

            this .whitespacesNoLineTerminator ();

            if (PLYAParser_Grammar .propertyName .parse (this))
            {
               const name = this .result [0];

               properties .push ({ type, value, name });
               return true;
            }
         }

         if (PLYAParser_Grammar .propertyList .parse (this))
         {
            this .whitespacesNoLineTerminator ();

            if (PLYAParser_Grammar .propertyType .parse (this))
            {
               const count = this .typeMapping .get (this .result [0]);

               this .whitespacesNoLineTerminator ();

               if (PLYAParser_Grammar .propertyType .parse (this))
               {
                  const
                     type  = this .result [0],
                     value = this .typeMapping .get (type);

                  this .whitespacesNoLineTerminator ();

                  if (PLYAParser_Grammar .propertyName .parse (this))
                  {
                     const name = this .result [0];

                     properties .push ({ count, type, value, name });
                     return true;
                  }
               }
            }
         }
      }

      return false;
   },
   processElements (elements)
   {
      // console .log (elements)

      for (const element of elements)
         this .processElement (element);

      if (!this .points ?.length)
         return;

      const scene = this .getScene ();

      if (this .coordIndex) // IndexedFaceSet
      {
         const
            hasNormals = this .normals ?.some (v => v !== 0),
            shape      = scene .createNode ("Shape"),
            appearance = scene .createNode ("Appearance"),
            material   = scene .createNode ("Material"),
            geometry   = scene .createNode ("IndexedFaceSet"),
            coordinate = scene .createNode ("Coordinate");

         geometry .solid      = false;
         geometry .coordIndex = this .coordIndex;

         if (this .colors ?.length)
         {
            const
               alpha = this .alpha && this .colors .some ((v, i) => i % 4 === 3 && v < 1),
               color = scene .createNode (alpha ? "ColorRGBA" : "Color");

            color .color    = alpha || !this .alpha ? this .colors : this .colors .filter ((v, i) => i % 4 !== 3);
            geometry .color = color;
         }

         if (this .texCoords ?.length)
         {
            // TextureTransform

            const textureTransform = scene .createNode ("TextureTransform");

            textureTransform .translation .y = -1;
            textureTransform .scale .y       = -1;

            appearance .textureTransform = textureTransform;

            // TextureCoordinate

            const texCoord = scene .createNode ("TextureCoordinate");

            texCoord .point    = this .texCoords;
            geometry .texCoord = texCoord;

            // Index

            if (this .texCoordIndex ?.length)
               geometry .texCoordIndex = this .texCoordIndex;
         }

         if (hasNormals)
         {
            const normal = scene .createNode ("Normal");

            normal .vector   = this .normals;
            geometry .normal = normal;
         }

         coordinate .point = this .points;
         geometry .coord   = coordinate;

         appearance .material = material;
         shape .appearance    = appearance;
         shape .geometry      = geometry;

         scene .rootNodes .push (shape);
      }
      else // PointSet
      {
         const
            hasNormals = this .normals ?.some (v => v !== 0),
            shape      = scene .createNode ("Shape"),
            appearance = scene .createNode ("Appearance"),
            material   = scene .createNode (hasNormals ? "Material" : "UnlitMaterial"),
            geometry   = scene .createNode ("PointSet"),
            coordinate = scene .createNode ("Coordinate");

         if (this .colors ?.length)
         {
            const
               alpha = this .alpha && this .colors .some ((v, i) => i % 4 === 3 && v < 1),
               color = scene .createNode (alpha ? "ColorRGBA" : "Color");

            color .color    = alpha || !this .alpha ? this .colors : this .colors .filter ((v, i) => i % 4 !== 3);
            geometry .color = color;
         }

         if (hasNormals)
         {
            const normal = scene .createNode ("Normal");

            normal .vector   = this .normals;
            geometry .normal = normal;
         }

         coordinate .point = this .points;
         geometry .coord   = coordinate;

         appearance .material = material;
         shape .appearance    = appearance;
         shape .geometry      = geometry;

         scene .rootNodes .push (shape);
      }
   },
   processElement (element)
   {
      switch (element .name)
      {
         case "vertex":
            this .parseVertices (element);
            break;
         case "face":
            this .parseFaces (element);
            break;
         case "multi_texture_vertex":
            this .parseMultiTextureVertices (element);
            break;
         case "multi_texture_face":
            this .parseMultiTextureFaces (element);
            break;
         default:
            this .parseUnknown (element);
            break;
      }
   },
   parseVertices ({ count, properties })
   {
      const
         scales    = [ ],
         rotations = [ ],
         colors    = [ ],
         texCoords = [ ],
         normals   = [ ],
         points    = [ ];

      // console .time ("vertices")

      for (let i = 0; i < count; ++ i)
      {
         this .whitespaces ();

         for (const { value, name, type } of properties)
         {
            if (!value .call (this))
               throw new Error (`Couldn't parse value for property ${name}.`);

            switch (name)
            {
               case "scale_0": case "scale_1": case "scale_2":
                  scales .push (this .value);
                  break;
               case "rot_0": case "rot_1": case "rot_2": case "rot_3":
                  rotations .push (this .value);
                  break;
               case "red": case "green": case "blue": case "alpha":
               case "r": case "g": case "b": case "a":
                  colors .push (this .convertColor (this .value, type));
                  break;
               case "f_dc_0": case "f_dc_1": case "f_dc_2":
                  colors .push (this .convertFDC (this .convertColor (this .value, type)));
                  break;
               case "opacity":
                  // https://github.com/antimatter15/splat/blob/main/convert.py
                  colors .push (1 / (1 + Math .exp (-this .value)));
                  break;
               case "s": case "t":
               case "u": case "v":
                  texCoords .push (this .value);
                  break;
               case "nx": case "ny": case "nz":
                  normals .push (this .value);
                  break;
               case "x": case "y": case "z":
                  points .push (this .value);
                  break;
            }
         }
      }

      // console .timeEnd ("vertices")

      // Geometric properties

      this .rotations = rotations;
      this .scales    = scales;
      this .alpha     = properties .some (p => p .name .match (/^(?:alpha|a|opacity)$/));
      this .colors    = colors;
      this .texCoords = texCoords;
      this .normals   = normals;
      this .points    = points;
   },
   parseFaces ({ count, properties })
   {
      const coordIndex = [ ];

      for (let i = 0; i < count; ++ i)
      {
         this .whitespaces ();

         for (const { count, value, name } of properties)
         {
            if (!count .call (this))
               throw new Error (`Couldn't parse property count for ${name}.`);

            const length = this .value;

            for (let i = 0; i < length; ++ i)
            {
               if (!value .call (this))
                  throw new Error (`Couldn't parse a property value for ${name}.`);

               coordIndex .push (this .value);
            }

            coordIndex .push (-1);
         }
      }

      this .coordIndex = coordIndex;
   },
   parseMultiTextureVertices ({ count, properties })
   {
      const texCoords = [ ];

      for (let i = 0; i < count; ++ i)
      {
         this .whitespaces ();

         for (const { value, name } of properties)
         {
            if (!value .call (this))
               throw new Error (`Couldn't parse value for property ${name}.`);

            switch (name)
            {
               case "s": case "t":
               case "u": case "v":
                  texCoords .push (this .value);
                  break;
            }
         }
      }

      this .texCoords = texCoords;
   },
   parseMultiTextureFaces ({ count, properties })
   {
      const texCoordIndex = [ ];

      for (let i = 0; i < count; ++ i)
      {
         for (const { count, value, name } of properties)
         {
            if (count)
            {
               if (!count .call (this))
                  throw new Error (`Couldn't parse property count for ${name}.`);

               const length = this .value;

               for (let i = 0; i < length; ++ i)
               {
                  if (!value .call (this))
                     throw new Error (`Couldn't parse value for property ${name}.`);

                  texCoordIndex .push (this .value);
               }

               texCoordIndex .push (-1);
            }
            else
            {
               if (!value .call (this))
                  throw new Error (`Couldn't parse value for property ${name}.`);
            }
         }
      }

      this .texCoordIndex = texCoordIndex;
   },
   parseUnknown ({ count })
   {
      this .whitespaces ();

      for (let i = 0; i < count; ++ i)
         PLYAParser_Grammar .line .parse (this);
   },
});

const PLYAParser_default_ = PLYAParser;
;

/* harmony default export */ const Parser_PLYAParser = (Namespace/* default */.A .add ("PLYAParser", PLYAParser_default_));
;// ./src/x_ite/Parser/PLYBParser.js


function PLYBParser (scene)
{
   Parser_PLYAParser .call (this, scene);

   this .typeMapping = new Map ([
      ["char",    this .binaryInt8],
      ["uchar",   this .binaryUint8],
      ["short",   this .binaryInt16],
      ["ushort",  this .binaryUint16],
      ["int",     this .binaryInt32],
      ["uint",    this .binaryUint32],
      ["float",   this .binaryFloat32],
      ["double",  this .binaryFloat64],
      ["int8",    this .binaryInt8],
      ["uint8",   this .binaryUint8],
      ["int16",   this .binaryInt16],
      ["uint16",  this .binaryUint16],
      ["int32",   this .binaryInt32],
      ["uint32",  this .binaryUint32],
      ["float32", this .binaryFloat32],
      ["float64", this .binaryFloat64],
   ]);

   this .binaryInt8    .bytes = 1;
   this .binaryUint8   .bytes = 1;
   this .binaryInt16   .bytes = 2;
   this .binaryUint16  .bytes = 2;
   this .binaryInt32   .bytes = 4;
   this .binaryUint32  .bytes = 4;
   this .binaryFloat32 .bytes = 4;
   this .binaryFloat64 .bytes = 8;
}

Object .assign (Object .setPrototypeOf (PLYBParser .prototype, Parser_PLYAParser .prototype),
{
   getEncoding ()
   {
      return ["ARRAY_BUFFER", "STRING"];
   },
   setInput (inputs)
   {
      this .arrayBuffer  = inputs [0];
      this .dataView     = new DataView (this .arrayBuffer);
      this .input        = inputs [1];
      this .magic        = this .input .match (/^ply\r?\nformat (binary_(?:little|big)_endian) 1.0.*?end_header\r?\n/s);
      this .byteOffset   = this .magic ?.[0] .length;
      this .littleEndian = this .magic ?.[1] === "binary_little_endian";
   },
   isValid ()
   {
      if (!(this .arrayBuffer instanceof ArrayBuffer))
         return false;

      return !! this .magic;
   },
   binaryInt8 ()
   {
      this .value       = this .dataView .getInt8 (this .byteOffset, this .littleEndian);
      this .byteOffset += 1;

      return true;
   },
   binaryUint8 ()
   {
      this .value       = this .dataView .getUint8 (this .byteOffset, this .littleEndian);
      this .byteOffset += 1;

      return true;
   },
   binaryInt16 ()
   {
      this .value       = this .dataView .getInt16 (this .byteOffset, this .littleEndian);
      this .byteOffset += 2;

      return true;
   },
   binaryUint16 ()
   {
      this .value       = this .dataView .getUint16 (this .byteOffset, this .littleEndian);
      this .byteOffset += 2;

      return true;
   },
   binaryInt32 ()
   {
      this .value       = this .dataView .getInt32 (this .byteOffset, this .littleEndian);
      this .byteOffset += 4;

      return true;
   },
   binaryUint32 ()
   {
      this .value       = this .dataView .getUint32 (this .byteOffset, this .littleEndian);
      this .byteOffset += 4;

      return true;
   },
   binaryFloat32 ()
   {
      this .value       = this .dataView .getFloat32 (this .byteOffset, this .littleEndian);
      this .byteOffset += 4;

      return true;
   },
   binaryFloat64 ()
   {
      this .value       = this .dataView .getFloat64 (this .byteOffset, this .littleEndian);
      this .byteOffset += 8;

      return true;
   },
   processElements (elements)
   {
      this .whitespaces = Function .prototype;

      return Parser_PLYAParser .prototype .processElements .call (this, elements);
   },
   parseUnknown ({ count, properties })
   {
      for (let i = 0; i < count; ++ i)
      {
         for (const { count, type } of properties)
         {
            if (count)
            {
               count .call (this);

               this .byteOffset += this .value * this .typeMapping .get (type) .bytes;
            }
            else
            {
               this .byteOffset += this .typeMapping .get (type) .bytes;
            }
         }
      }
   },
   // parseUnknown ({ count, properties })
   // {
   //    let string = "";

   //    for (let i = 0; i < count; ++ i)
   //    {
   //       for (const { count, type, value } of properties)
   //       {
   //          if (count === undefined)
   //          {
   //             value .call (this);

   //             string += this .value + " "
   //          }
   //          else
   //          {
   //             count .call (this);

   //             string += this .value + " "

   //             for (let i = 0, l = this .value; i < l; ++ i)
   //             {
   //                value .call (this);

   //                string += this .value + " "
   //             }
   //          }
   //       }

   //       string += "\n"
   //    }

   //    console .log (string .substring (0, 1000))
   // },
});

const PLYBParser_default_ = PLYBParser;
;

/* harmony default export */ const Parser_PLYBParser = (Namespace/* default */.A .add ("PLYBParser", PLYBParser_default_));
// EXTERNAL MODULE: ./src/standard/Math/Numbers/Vector4.js
var Vector4 = __webpack_require__(7591);
// EXTERNAL MODULE: ./src/standard/Math/Numbers/Matrix3.js + 1 modules
var Matrix3 = __webpack_require__(1224);
// EXTERNAL MODULE: ./src/standard/Math/Numbers/Complex.js
var Complex = __webpack_require__(8318);
;// ./src/standard/Math/Geometry/Box2.js



function Box2 (... args) /* size, center */
{
   this .matrix = new Matrix3/* default */.A ();

   this .set (... args);
}

Object .assign (Box2 .prototype,
{
   copy ()
   {
      const copy = Object .create (Box2 .prototype);

      copy .matrix = this .matrix .copy ();

      return copy;
   },
   assign (box)
   {
      this .matrix .assign (box .matrix);

      return this;
   },
   equals (box)
   {
      return this .matrix .equals (box .matrix);
   },
   set (size, center)
   {
      switch (arguments .length)
      {
         case 0:
         {
            this .matrix .set (0, 0, 0,
                               0, 0, 0,
                               0, 0, 0);

            return this;
         }
         case 2:
         {
            this .matrix .set (size .x / 2, 0, 0,
                               0, size .y / 2, 0,
                               center .x, center .y, 1);

            return this;
         }
         // case 3:
         // {
         //    console .trace ()
         //    return this .setExtents (arguments [0], arguments [1]);
         // }
      }
   },
   setExtents (min, max)
   {
      const
         sx = (max .x - min .x) / 2,
         sy = (max .y - min .y) / 2,
         cx = (max .x + min .x) / 2,
         cy = (max .y + min .y) / 2;

      this .matrix .set (sx,  0, 0,
                          0, sy, 0,
                         cx, cy, 1);

      return this;
   },
   isEmpty ()
   {
      return this .matrix [8] === 0;
   },
   add: (() =>
   {
      const
         lhs_min = new Vector2/* default */.A (),
         lhs_max = new Vector2/* default */.A (),
         rhs_min = new Vector2/* default */.A (),
         rhs_max = new Vector2/* default */.A ();

      return function (box)
      {
         if (this .isEmpty ())
            return this .assign (box);

         if (box .isEmpty ())
            return this;

         this .getExtents (lhs_min, lhs_max);
         box  .getExtents (rhs_min, rhs_max);

         return this .setExtents (lhs_min .min (rhs_min), lhs_max .max (rhs_max));
      };
   })(),
   multLeft (matrix)
   {
      this .matrix .multLeft (matrix);
      return this;
   },
   multRight (matrix)
   {
      this .matrix .multRight (matrix);
      return this;
   },
   getExtents (min, max)
   {
      this .getAbsoluteExtents (min, max);

      min .add (this .center);
      max .add (this .center);
   },
   getAbsoluteExtents: (() =>
   {
      const p1 = new Vector2/* default */.A ();

      return function (min, max)
      {
         const
            m = this .matrix,
            x = m .xAxis,
            y = m .yAxis;

         p1 .assign (x) .add (y);

         const p2 = y .subtract (x);

         min .assign (p1) .min (p2);
         max .assign (p1) .max (p2);

         p1 .negate ();
         p2 .negate ();

         min .min (p1, p2);
         max .max (p1, p2);
      };
   })(),
   containsPoint: (() =>
   {
      const
         min = new Vector2/* default */.A (),
         max = new Vector2/* default */.A ();

      return function (point)
      {
         this .getExtents (min, max);

         return min .x <= point .x &&
                max .x >= point .x &&
                min .y <= point .y &&
                max .y >= point .y;
      };
   })(),
   toString ()
   {
      return `${this .size}, ${this .center}`;
   },
});

Object .assign (Box2,
{
   Extents (min, max)
   {
      return new Box2 () .setExtents (min, max);
   },
   Points (points)
   {
      const
         min = new Vector2/* default */.A (Number .POSITIVE_INFINITY),
         max = new Vector2/* default */.A (Number .NEGATIVE_INFINITY);

      for (const point of points)
      {
         min .min (point);
         max .max (point);
      }

      return new Box2 () .setExtents (min, max);
   },
});

Object .defineProperties (Box2 .prototype,
{
   size:
   {
      get: (() =>
      {
         const
            min = new Vector2/* default */.A (),
            max = new Vector2/* default */.A ();

         return function ()
         {
            this .getAbsoluteExtents (min, max);

            return max .subtract (min);
         };
      })(),
      enumerable: true,
   },
   center:
   {
      get ()
      {
         return this .matrix .origin;
      },
      enumerable: true,
   },
});

const Box2_default_ = Box2;
;

/* harmony default export */ const Geometry_Box2 = (Namespace/* default */.A .add ("Box2", Box2_default_));
;// ./src/standard/Math/Algorithms/Bezier.js







const { interval } = Algorithm/* default */.A;

// https://pomax.github.io/bezierinfo/

const Bezier =
{
   quadric: (() =>
   {
      const
         c = new Matrix3/* default */.A (1, 0, 0, -2, 2, 0, 1, -2, 1),
         p = new Matrix3/* default */.A ();

      return function (x0, y0, z0, x1, y1, z1, x2, y2, z2, steps, points)
      {
         p
            .set (x0, y0, z0, x1, y1, z1, x2, y2, z2)
            .multLeft (c);

         for (let i = 0, d = steps - 1; i < steps; ++ i)
         {
            const t = i / d;

            points .push (p .multVecMatrix (new Vector3/* default */.A (1, t, t * t)));
         }
      };
   })(),
   cubic: (() =>
   {
      const
         v = new Vector4/* default */.A (),
         c = new Matrix4/* default */.A (1, 0, 0, 0, -3, 3, 0, 0, 3, -6, 3, 0, -1, 3, -3, 1),
         p = new Matrix4/* default */.A ();

      return function (x0, y0, z0, x1, y1, z1, x2, y2, z2, x3, y3, z3, steps, points)
      {
         p
            .set (x0, y0, z0, 0, x1, y1, z1, 0, x2, y2, z2, 0, x3, y3, z3, 0)
            .multLeft (c);

         for (let i = 0, d = steps - 1; i < steps; ++ i)
         {
            const t = i / d;

            p .multVecMatrix (v .set (1, t, t * t, t * t * t));

            points .push (new Vector3/* default */.A (v .x, v .y, v .z));
         }
      };
   })(),
   arc (ax, ay, rx, ry, xAxisRotation, largeArcFlag, sweepFlag, x, y, steps, points)
   {
      // https://ericeastwood.com/blog/25/curves-and-arcs-quadratic-cubic-elliptical-svg-implementations
      // See https://www.w3.org/TR/SVG/implnote.html#ArcImplementationNotes.

      // If the endpoints are identical, then this is equivalent to omitting the elliptical arc segment entirely.
      if (ax === x && ay === y)
      {
         points .push (new Vector3/* default */.A (x, y, 0));
         return;
      }

      // In accordance to: http://www.w3.org/TR/SVG/implnote.html#ArcOutOfRangeParameters

      rx = Math .abs (rx);
      ry = Math .abs (ry);

      // If rx = 0 or ry = 0 then this arc is treated as a straight line segment joining the endpoints.
      if (rx === 0 || ry === 0)
      {
         points .push (new Vector3/* default */.A (ax, ay, 0), new Vector3/* default */.A (x, y, 0));
         return;
      }

      const
         rx2 = rx * rx,
         ry2 = ry * ry;

      // In accordance to: http://www.w3.org/TR/SVG/implnote.html#ArcOutOfRangeParameters

      xAxisRotation = interval (xAxisRotation, 0, 2 * Math .PI);

      const
         sinRotation = Math .sin (xAxisRotation),
         cosRotation = Math .cos (xAxisRotation);

      // Following "Conversion from endpoint to center parameterization"
      // http://www.w3.org/TR/SVG/implnote.html#ArcConversionEndpointToCenter

      // Step #1: Compute transformedPoint
      const d = new Vector2/* default */.A (ax - x, ay - y) .divide (2);

      const transformedPoint = new Vector2/* default */.A ( cosRotation * d .x + sinRotation * d .y,
                                             -sinRotation * d .x + cosRotation * d .y);

      const transformedPoint2 = transformedPoint .copy () .multVec (transformedPoint);

      // Ensure radii are large enough
      const radiiCheck = transformedPoint2 .x / rx2 + transformedPoint2 .y / ry2;

      if (radiiCheck > 1)
      {
         rx = Math .sqrt (radiiCheck) * rx;
         ry = Math .sqrt (radiiCheck) * ry;
      }

      // Step #2: Compute transformedCenter
      const cSquareNumerator = rx2 * ry2 - rx2 * transformedPoint2 .y - ry2 * transformedPoint2 .x;
      const cSquareRootDenom =             rx2 * transformedPoint2 .y + ry2 * transformedPoint2 .x;
      let   cRadicand        = cSquareNumerator / cSquareRootDenom;

      // Make sure this never drops below zero because of precision
      cRadicand = Math .max (0, cRadicand);

      const cCoef = (largeArcFlag !== sweepFlag ? 1 : -1) * Math .sqrt (cRadicand);

      const transformedCenter = new Vector2/* default */.A ( cCoef * rx * transformedPoint .y / ry,
                                             -cCoef * ry * transformedPoint .x / rx);

      // Step #3: Compute center
      const center = new Vector2/* default */.A (cosRotation * transformedCenter .x - sinRotation * transformedCenter .y + ((ax + x) / 2),
                                  sinRotation * transformedCenter .x + cosRotation * transformedCenter .y + ((ay + y) / 2));

      // Step #4: Compute start/sweep angles
      const startVector = new Vector2/* default */.A ((transformedPoint .x - transformedCenter .x) / rx,
                                       (transformedPoint .y - transformedCenter .y) / ry);

      const endVector = new Vector2/* default */.A ((-transformedPoint .x - transformedCenter .x) / rx,
                                     (-transformedPoint .y - transformedCenter .y) / ry);

      const get_angle  = (x) => { return x > 0 ? x : 2 * Math .PI + x; }; // transform angle to range [0, 2pi]
      const startAngle = get_angle (Math .atan2 (startVector .y, startVector .x));
      const endAngle   = get_angle (Math .atan2 (endVector   .y, endVector   .x));

      let sweepAngle = endAngle - startAngle;

      if (largeArcFlag)
      {
         // sweepAngle must be positive
         if (sweepAngle < 0)
            sweepAngle += 2 * Math .PI;
      }
      else
      {
         // sweepAngle must be negative
         if (sweepAngle > 0)
            sweepAngle -= 2 * Math .PI;
      }

      if (sweepFlag && sweepAngle < 0)
         sweepAngle += 2 *Math .PI;

      else if (!sweepFlag && sweepAngle > 0)
         sweepAngle -= 2 * Math .PI;

      // Interpolate:

      const bezier_steps   = Math .max (4, Math .abs (sweepAngle) * steps / (2 * Math .PI));
      const bezier_steps_1 = bezier_steps - 1;

      points .push (new Vector3/* default */.A (ax, ay, 0));

      for (let i = 1; i < bezier_steps_1; ++ i)
      {
         const t = i / bezier_steps_1;

         // From http://www.w3.org/TR/SVG/implnote.html#ArcParameterizationAlternatives
         const angle = startAngle + (sweepAngle * t);
         const x     = rx * Math .cos (angle);
         const y     = ry * Math .sin (angle);

         points .push (new Vector3/* default */.A (cosRotation * x - sinRotation * y + center .x,
                                    sinRotation * x + cosRotation * y + center .y,
                                    0));
      }

      points .push (new Vector3/* default */.A (x, y, 0));
   },
};

const Bezier_default_ = Bezier;
;

/* harmony default export */ const Algorithms_Bezier = (Namespace/* default */.A .add ("Bezier", Bezier_default_));
// EXTERNAL MODULE: ./src/standard/Math/Utility/MatrixStack.js
var MatrixStack = __webpack_require__(151);
;// ./src/x_ite/Parser/SVGParser.js
/* provided dependency */ var SVGParser_$ = __webpack_require__(4993);
/* provided dependency */ var libtess = __webpack_require__(3921);

















/*
 *  Grammar
 */

// Lexical elements
const SVGParser_Grammar = (0,Expressions/* default */.A) ({
   // General
   whitespaces: /[\x20\n\t\r]+/gy,
   comma: /,/gy,
   openParenthesis: /\(/gy,
   closeParenthesis: /\)/gy,

   // Units
   length: /em|ex|px|in|cm|mm|pt|pc|%/gy,
   percent: /%/gy,

   // Values
   int32: /(?:0[xX][\da-fA-F]+)|(?:[+-]?\d+)/gy,
   double: /[+-]?(?:(?:(?:\d*\.\d+)|(?:\d+(?:\.)?))(?:[eE][+-]?\d+)?)/gy,
   constants: /([+-])((?:NAN|INF|INFINITY))/igy,
   matrix: /matrix/gy,
   translate: /translate/gy,
   rotate: /rotate/gy,
   scale: /scale/gy,
   skewX: /skewX/gy,
   skewY: /skewY/gy,
   color: /[a-zA-Z]+|#[\da-fA-F]+|rgba?\(.*?\)/gy,
   url: /url\("?(.*?)"?\)/gy,
   path: /[mMlLhHvVqQtTcCsSaAzZ]/gy,
});

/*
 *  Constants
 */

const
   MM     = 0.001,     // One mm in meters.
   CM     = 0.01,      // One cm in meters.
   INCH   = 0.0254,    // One inch in meters.
   POINT  = INCH / 72, // One point in meters.
   PICA   = INCH / 6,  // One pica in meters.
   PIXEL  = INCH / 90, // One pixel in meters.
   EM     = 16,        // One em in pixels.
   SPREAD = 16;        // Spread factor, Integer.

/*
 *  Parser
 */

function SVGParser (scene)
{
   X3DParser/* default */.A    .call (this, scene);
   Parser_X3DOptimizer .call (this);

   // Optimizer

   this .removeEmptyGroups    = true;
   this .combineGroupingNodes = true;

   // Options

   this .solid = false; // Are 2D primitives solid?

   // Globals

   this .viewBox          = new Vector4/* default */.A (0, 0, 100, 100);
   this .modelMatrix      = new MatrixStack/* default */.A (Matrix4/* default */.A);
   this .fillGeometries   = new Map ();
   this .strokeGeometries = new Map ();
   this .lineProperties   = new Map ();
   this .tessy            = this .createTesselator ();
   this .context          = document .createElement ("canvas") .getContext ("2d", { willReadFrequently: true });
   this .numSwitchNodes   = 0;

   this .styles = [{
      display: "inline",
      fillType: "COLOR",
      fillColor: Color4/* default */.A .BLACK,
      fillURL: "",
      fillOpacity: 1,
      fillRule: "nonzero",
      strokeType: "none",
      strokeColor: Color4/* default */.A .BLACK,
      strokeURL: "",
      strokeOpacity: 1,
      strokeWidth: 1,
      opacity: 1,
      stopColor: Color4/* default */.A .BLACK,
      stopOpacity: 1,
      vectorEffect: "none",
   }];

   // Constants

   const browser = scene .getBrowser ()

   switch (browser .getBrowserOption ("PrimitiveQuality"))
   {
      case "LOW":
         this .BEZIER_STEPS = 9;  // Subdivisions of a span.
         this .CIRCLE_STEPS = 20; // Subdivisions of a circle, used for arc and rounded rect.
         break;
      case "HIGH":
         this .BEZIER_STEPS = 15; // Subdivisions of a span.
         this .CIRCLE_STEPS = 64; // Subdivisions of a circle, used for arc and rounded rect.
         break;
      default:
         this .BEZIER_STEPS = 12;  // Subdivisions of a span.
         this .CIRCLE_STEPS = 32; // Subdivisions of a circle, used for arc and rounded rect.
         break;
   }

   switch (browser .getBrowserOption ("TextureQuality"))
   {
      case "LOW":
         this .GRADIENT_SIZE = 128; // In pixels.
         break;
      case "HIGH":
         this .GRADIENT_SIZE = 512; // In pixels.
         break;
      default:
         this .GRADIENT_SIZE = 256; // In pixels.
         break;
   }

   // Use .canvas to support foreign 2d libs.
   this .context .canvas .width  = this .GRADIENT_SIZE;
   this .context .canvas .height = this .GRADIENT_SIZE;
}

Object .assign (Object .setPrototypeOf (SVGParser .prototype, X3DParser/* default */.A .prototype),
   Parser_X3DOptimizer .prototype,
{
   CONSTANTS: new Map ([
      ["NAN", NaN],
      ["INF", Infinity],
      ["INFINITY", Infinity],
   ]),
   getEncoding ()
   {
      return "XML";
   },
   setInput (xmlElement)
   {
      try
      {
         if (typeof xmlElement === "string")
            xmlElement = SVGParser_$.parseXML (xmlElement);

         this .input = xmlElement;
      }
      catch
      {
         this .input = undefined;
      }
   },
   isValid ()
   {
      if (!(this .input instanceof XMLDocument))
         return false;

      if (SVGParser_$(this .input) .children ("svg") .length)
         return true;

      if (this .input .nodeName === "svg")
         return true;

      return false;
   },
   parseIntoScene (resolve, reject)
   {
      this .xmlElement (this .input)
         .then (resolve)
         .catch (reject);
   },
   async xmlElement (xmlElement)
   {
      switch (xmlElement .nodeName)
      {
         case "#document":
         {
            const svg = SVGParser_$(xmlElement) .children ("svg");

            for (const xmlElement of svg)
               await this .svgElement (xmlElement);

            break;
         }
         case "svg":
         {
            await this .svgElement (xmlElement);
            break;
         }
      }

      return this .getScene ();
   },
   async svgElement (xmlElement)
   {
      const
         browser = this .getBrowser (),
         scene   = this .getScene ();

      scene .setEncoding ("SVG");
      scene .setProfile (browser .getProfile ("Interchange"));
      scene .addComponent (browser .getComponent ("Geometry2D", 2));

      await browser .loadComponents (scene);

      // Init nodes.

      this .document              = this .input;
      this .rootTransform         = scene .createNode ("Transform");
      this .groupNodes            = [this .rootTransform];
      this .texturePropertiesNode = this .createTextureProperties ();

      // Create background.

      const background = scene .createNode ("Background");

      background .skyColor = [1, 1, 1];

      scene .getRootNodes () .push (background);

      // Create navigation info.

      const navigationInfo = scene .createNode ("NavigationInfo");

      navigationInfo .type = ["PLANE", "PLANE_create3000.github.io", "EXAMINE", "ANY"];

      // Get attributes of svg element.

      const
         defaultWidth   = this .lengthAttribute (xmlElement .getAttribute ("width"),  300, "width"),
         defaultHeight  = this .lengthAttribute (xmlElement .getAttribute ("height"), 150, "height"),
         defaultViewBox = this .viewBox .set (0, 0, defaultWidth, defaultHeight),
         viewBox        = this .viewBoxAttribute (xmlElement .getAttribute ("viewBox"), defaultViewBox),
         width          = this .lengthAttribute (xmlElement .getAttribute ("width"),  viewBox [2], "width"),
         height         = this .lengthAttribute (xmlElement .getAttribute ("height"), viewBox [3], "height");

      if (true) // default
      {
         // preserveAspectRatio = "xMidYMid meet"

         const
            r  = width / height,
            rv = viewBox [2] / viewBox [3];

         if (rv > r)
            viewBox [3] += viewBox [2] / r - viewBox [3];
         else
            viewBox [2] += viewBox [3] * r - viewBox [2];
      }

      // Create viewpoint.

      const
         viewpoint = scene .createNode ("OrthoViewpoint"),
         x         =  (viewBox .x + width  / 2) * PIXEL,
         y         = -(viewBox .y + height / 2) * PIXEL;

      viewpoint .navigationInfo   = navigationInfo;
      viewpoint .position         = new Vector3/* default */.A (x, y, 10);
      viewpoint .centerOfRotation = new Vector3/* default */.A (x, y, 0);

      viewpoint .fieldOfView = [
         -width  / 2 * PIXEL,
         -height / 2 * PIXEL,
          width  / 2 * PIXEL,
          height / 2 * PIXEL,
      ];

      scene .getRootNodes () .push (viewpoint);

      // Create view matrix.

      const scale = new Vector3/* default */.A (width * PIXEL / viewBox [2], -height * PIXEL / viewBox [3], 1);

      this .rootTransform .scale = scale;

      // Parse elements.

      this .elements (xmlElement);

      // Add root Transform node.

      scene .addNamedNode (scene .getUniqueName ("ViewBox"), this .rootTransform);
      scene .addExportedNode (scene .getUniqueExportName ("ViewBox"), this .rootTransform);
      scene .getRootNodes () .push (this .rootTransform);

      // Optimize scene graph.

      this .optimizeSceneGraph (scene .getRootNodes ());
   },
   elements (xmlElement)
   {
      for (const childNode of xmlElement .childNodes)
         this .element (childNode);
   },
   element (xmlElement)
   {
      switch (xmlElement .nodeName)
      {
         case "use":
            return this .useElement (xmlElement);
         case "g":
            return this .gElement (xmlElement);
         case "switch":
            return this .switchElement (xmlElement);
         case "a":
            return this .aElement (xmlElement);
         case "rect":
            return this .rectElement (xmlElement);
         case "circle":
            return this .circleElement (xmlElement);
         case "ellipse":
            return this .ellipseElement (xmlElement);
         case "text":
            return this .textElement (xmlElement);
         case "image":
            return this .imageElement (xmlElement);
         case "polyline":
            return this .polylineElement (xmlElement);
         case "polygon":
            return this .polygonElement (xmlElement);
         case "path":
            return this .pathElement (xmlElement);
      }
   },
   useElement (xmlElement)
   {
      // Get href.

      const usedElement = this .hrefAttribute (xmlElement .getAttribute ("href") || xmlElement .getAttribute ("xlink:href"));

      if (!usedElement)
         return;

      // Determine style.

      if (!this .styleAttributes (xmlElement))
         return;

      // Create Transform node.

      const
         x = this .lengthAttribute (xmlElement .getAttribute ("x"), 0, "width"),
         y = this .lengthAttribute (xmlElement .getAttribute ("y"), 0, "height");

      const transformNode = this .createTransform (xmlElement, new Vector2/* default */.A (x, y));

      this .groupNodes .push (transformNode);

      this .element (usedElement);

      this .popAll ();
   },
   gElement (xmlElement)
   {
      // Determine style.

      if (!this .styleAttributes (xmlElement))
         return;

      // Create Transform node.

      const transformNode = this .createTransform (xmlElement);

      // Get child elements.

      this .groupNodes .push (transformNode);

      this .elements (xmlElement);

      this .popAll ();
   },
   switchElement (xmlElement)
   {
      // Determine style.

      if (!this .styleAttributes (xmlElement))
         return;

      // Create Transform node.

      const
         scene         = this .getExecutionContext (),
         transformNode = this .createTransform (xmlElement),
         switchNode    = scene .createNode ("Switch");

      transformNode .children .push (switchNode);

      switchNode .whichChoice = 0;

      scene .addExportedNode (scene .getUniqueExportName (`Switch${++ this .numSwitchNodes}`), node);

      // Get child elements.

      this .groupNodes .push (switchNode);

      this .elements (xmlElement);

      this .popAll ();
   },
   aElement (xmlElement)
   {
      // Determine style.

      if (!this .styleAttributes (xmlElement))
         return;

      // Get attributes.

      const
         href   = xmlElement .getAttribute ("href") || xmlElement .getAttribute ("xlink:href"),
         title  = xmlElement .getAttribute ("title") || xmlElement .getAttribute ("xlink:title"),
         target = xmlElement .getAttribute ("target");

      // Create Transform node.

      const
         scene         = this .getExecutionContext (),
         transformNode = this .createTransform (xmlElement),
         anchorNode    = scene .createNode ("Anchor");

      transformNode .children .push (anchorNode);

      anchorNode .description = title;
      anchorNode .url         = [href];

      if (target)
         anchorNode .parameter = [`target=${target}`];

      // Get child elements.

      this .groupNodes .push (anchorNode);

      this .elements (xmlElement);

      this .popAll ();
   },
   rectElement (xmlElement)
   {
      // Create Transform node.

      const
         x      = this .lengthAttribute (xmlElement .getAttribute ("x"),      0, "width"),
         y      = this .lengthAttribute (xmlElement .getAttribute ("y"),      0, "height"),
         width  = this .lengthAttribute (xmlElement .getAttribute ("width"),  0, "width"),
         height = this .lengthAttribute (xmlElement .getAttribute ("height"), 0, "height");

      let
         rx = Math .max (0, this .lengthAttribute (xmlElement .getAttribute ("rx"), 0, "width")),
         ry = Math .max (0, this .lengthAttribute (xmlElement .getAttribute ("ry"), 0, "height"));

      if (rx === 0 && ry === 0)
      {
         // Determine style.

         if (!this .styleAttributes (xmlElement))
            return;

         // Create Transform node.

         const
            scene         = this .getExecutionContext (),
            size          = new Vector2/* default */.A (width, height),
            center        = new Vector2/* default */.A (x + width / 2, y + height / 2),
            bbox          = new Geometry_Box2 (size, center),
            transformNode = this .createTransform (xmlElement, center);

         this .groupNodes .push (transformNode);

         // Create nodes.

         if (this .style .fillType !== "none")
         {
            const
               shapeNode     = scene .createNode ("Shape"),
               rectangleNode = this .fillGeometries .get (xmlElement);

            transformNode .children .push (shapeNode);
            shapeNode .appearance = this .createFillAppearance (bbox);

            if (rectangleNode)
            {
               shapeNode .geometry = rectangleNode;
            }
            else
            {
               const rectangleNode = scene .createNode ("Rectangle2D");

               this .fillGeometries .set (xmlElement, rectangleNode);

               shapeNode .geometry  = rectangleNode;
               rectangleNode .solid = this .solid;
               rectangleNode .size  = size;
            }
         }

         if (this .style .strokeType !== "none")
         {
            const
               shapeNode    = scene .createNode ("Shape"),
               polylineNode = this .strokeGeometries .get (xmlElement);

            transformNode .children .push (shapeNode);
            shapeNode .appearance = this .createStrokeAppearance ();

            if (polylineNode)
            {
               shapeNode .geometry = polylineNode;
            }
            else
            {
               const
                  polylineNode = scene .createNode ("Polyline2D"),
                  width1_2     = width / 2,
                  height1_2    = height / 2;

               this .strokeGeometries .set (xmlElement, polylineNode);

               shapeNode .geometry = polylineNode;

               polylineNode .lineSegments = [ width1_2,  height1_2,
                                             -width1_2,  height1_2,
                                             -width1_2, -height1_2,
                                              width1_2, -height1_2,
                                              width1_2,  height1_2];
            }
         }

         this .popAll ();
      }
      else
      {
         // Create points.

         if (rx && !ry) ry = rx;
         if (ry && !rx) rx = ry;

         rx = Math .min (rx, width / 2);
         ry = Math .min (ry, height / 2);

         const
            xOffsets = [x + width - rx, x + rx , x + rx, x + width - rx],
            yOffsets = [y + height - ry, y + height - ry, y + ry, y + ry],
            points   = Object .assign ([ ], { closed: true });

         for (let c = 0; c < 4; ++ c)
         {
            const s = c * Math .PI / 2;

            for (let i = 0, N = this .CIRCLE_STEPS / 4; i < N; ++ i)
            {
               const p = Complex/* default */.A .Polar (1, s + Math .PI / 2 * i / (N - 1));

               points .push (new Vector3/* default */.A (xOffsets [c] + p .real * rx, yOffsets [c] + p .imag * ry, 0));
            }
         }

         points .pop ();

         // Create nodes.

         this .pathLikeElement (xmlElement, [points]);
      }
   },
   circleElement (xmlElement)
   {
      // Determine style.

      if (!this .styleAttributes (xmlElement))
         return;

      // Create Transform node.

      const
         cx = this .lengthAttribute (xmlElement .getAttribute ("cx"), 0, "width"),
         cy = this .lengthAttribute (xmlElement .getAttribute ("cy"), 0, "height"),
         r  = this .lengthAttribute (xmlElement .getAttribute ("r"),  0);

      const
         scene         = this .getExecutionContext (),
         bbox          = new Geometry_Box2 (new Vector2/* default */.A (r * 2, r * 2), new Vector2/* default */.A (cx, cy)),
         transformNode = this .createTransform (xmlElement, new Vector2/* default */.A (cx, cy));

      this .groupNodes .push (transformNode);

      // Create nodes.

      if (this .style .fillType !== "none")
      {
         const
            shapeNode = scene .createNode ("Shape"),
            diskNode  = this .fillGeometries .get (xmlElement);

         transformNode .children .push (shapeNode);
         shapeNode .appearance = this .createFillAppearance (bbox);

         if (diskNode)
         {
            shapeNode .geometry = diskNode;
         }
         else
         {
            const diskNode = scene .createNode ("Disk2D");

            this .fillGeometries .set (xmlElement, diskNode);

            shapeNode .geometry   = diskNode;
            diskNode .solid       = this .solid;
            diskNode .outerRadius = r;
         }
      }

      if (this .style .strokeType !== "none")
      {
         const
            shapeNode  = scene .createNode ("Shape"),
            circleNode = this .strokeGeometries .get (xmlElement);

         transformNode .children .push (shapeNode);
         shapeNode .appearance = this .createStrokeAppearance ();

         if (circleNode)
         {
            shapeNode .geometry = circleNode;
         }
         else
         {
            const circleNode = scene .createNode ("Circle2D");

            this .strokeGeometries .set (xmlElement, circleNode);

            shapeNode .geometry = circleNode;
            circleNode .radius  = r;
         }
      }

      this .popAll ();
   },
   ellipseElement (xmlElement)
   {
      // Determine style.

      if (!this .styleAttributes (xmlElement))
         return;

      // Create Transform node.

      const
         cx = this .lengthAttribute (xmlElement .getAttribute ("cx"), 0, "width"),
         cy = this .lengthAttribute (xmlElement .getAttribute ("cy"), 0, "height"),
         rx = this .lengthAttribute (xmlElement .getAttribute ("rx"), 0, "width"),
         ry = this .lengthAttribute (xmlElement .getAttribute ("ry"), 0, "height");

      const
         scene         = this .getExecutionContext (),
         rMin          = Math .min (rx, ry),
         bbox          = new Geometry_Box2 (new Vector2/* default */.A (rx * 2, ry * 2), new Vector2/* default */.A (cx, cy)),
         transformNode = this .createTransform (xmlElement, new Vector2/* default */.A (cx, cy), new Vector2/* default */.A (rx / rMin, ry / rMin));

      this .groupNodes .push (transformNode);

      // Create nodes.

      if (this .style .fillType !== "none")
      {
         const
            shapeNode = scene .createNode ("Shape"),
            diskNode  = this .fillGeometries .get (xmlElement);

         transformNode .children .push (shapeNode);
         shapeNode .appearance = this .createFillAppearance (bbox);

         if (diskNode)
         {
            shapeNode .geometry = diskNode;
         }
         else
         {
            const diskNode = scene .createNode ("Disk2D");

            this .fillGeometries .set (xmlElement, diskNode);

            shapeNode .geometry   = diskNode;
            diskNode .solid       = this .solid;
            diskNode .outerRadius = rMin;
         }
      }

      if (this .style .strokeType !== "none")
      {
         const
            shapeNode  = scene .createNode ("Shape"),
            circleNode = this .strokeGeometries .get (xmlElement);

         transformNode .children .push (shapeNode);
         shapeNode .appearance = this .createStrokeAppearance ();

         if (circleNode)
         {
            shapeNode .geometry = circleNode;
         }
         else
         {
            const circleNode = scene .createNode ("Circle2D");

            this .strokeGeometries .set (xmlElement, circleNode);

            shapeNode .geometry = circleNode;
            circleNode .radius  = rMin;
         }
      }

      this .popAll ();
   },
   textElement (xmlElement)
   {

   },
   imageElement (xmlElement)
   {
      const transformNode = this .fillGeometries .get (xmlElement);

      if (transformNode)
      {
         this .groupNodes .at (-1) .children .push (transformNode);
      }
      else
      {
         // Determine style.

         if (!this .styleAttributes (xmlElement))
            return;

         // Create Transform node.

         const
            x      = this .lengthAttribute (xmlElement .getAttribute ("x"),      0, "width"),
            y      = this .lengthAttribute (xmlElement .getAttribute ("y"),      0, "height"),
            width  = this .lengthAttribute (xmlElement .getAttribute ("width"),  0, "width"),
            height = this .lengthAttribute (xmlElement .getAttribute ("height"), 0, "height"),
            href   = xmlElement .getAttribute ("href") || xmlElement .getAttribute ("xlink:href");

         const
            scene         = this .getExecutionContext (),
            transformNode = this .createTransform (xmlElement, new Vector2/* default */.A (x + width / 2, y + height / 2), new Vector2/* default */.A (1, -1));

         this .fillGeometries .set (xmlElement, transformNode);
         this .groupNodes .push (transformNode);

         // Create nodes.

         const
            shapeNode      = scene .createNode ("Shape"),
            appearanceNode = scene .createNode ("Appearance"),
            textureNode    = scene .createNode ("ImageTexture"),
            rectangleNode  = scene .createNode ("Rectangle2D");

         shapeNode .appearance          = appearanceNode;
         shapeNode .geometry            = rectangleNode;
         appearanceNode .texture        = textureNode;
         textureNode .url               = [href];
         textureNode .textureProperties = this .texturePropertiesNode;
         rectangleNode .solid           = this .solid;
         rectangleNode .size            = new Vector2/* default */.A (width, height);

         transformNode .children .push (shapeNode);

         this .popAll ();
      }
   },
   polylineElement (xmlElement)
   {
      // Get points.

      const points = [ ];

      if (!this .pointsAttribute (xmlElement .getAttribute ("points"), points))
         return;

      // Create nodes.

      this .pathLikeElement (xmlElement, [points]);
   },
   polygonElement (xmlElement)
   {
      // Get points.

      const points = Object .assign ([ ], { closed: true });

      if (!this .pointsAttribute (xmlElement .getAttribute ("points"), points))
         return;

      // Create nodes.

      this .pathLikeElement (xmlElement, [points]);
   },
   pathElement (xmlElement)
   {
      // Get path points.

      const contours = [ ];

      if (!this .dAttribute (xmlElement .getAttribute ("d"), contours))
         return;

      // Create nodes.

      this .pathLikeElement (xmlElement, contours);
   },
   pathLikeElement (xmlElement, contours)
   {
      // Determine style.

      if (!this .styleAttributes (xmlElement))
         return;

      // Filter consecutive equal points.

      const EPSILON = 1e-9; // Min point distance.

      contours = contours .map (points =>
      {
         if (points .closed)
         {
            return Object .assign (points .filter ((p, i, a) => p .distance (a [(i + 1) % a .length]) > EPSILON),
            {
               closed: true,
            });
         }
         else
         {
            return points .filter ((p, i, a) => !i || p .distance (a [i - 1]) > EPSILON);
         }
      })
      .filter (points => points .length > 2);

      // Add index property to points.

      contours .forEach ((points, i, a) => points .index = i ? a [i - 1] .index + a [i - 1] .length : 0);

      // Create Transform node.

      const
         scene         = this .getExecutionContext (),
         transformNode = this .createTransform (xmlElement),
         bbox          = new Geometry_Box2 ();

      for (const points of contours)
         bbox .add (Geometry_Box2 .Points (points));

      this .groupNodes .push (transformNode);

      // Create nodes.

      const
         coordinateNode = scene .createNode ("Coordinate"),
         vertices       = coordinateNode .point;

      for (const points of contours)
      {
         for (const point of points)
            vertices .push (point);
      }

      if (this .style .fillType !== "none")
      {
         const
            shapeNode    = scene .createNode ("Shape"),
            geometryNode = this .fillGeometries .get (xmlElement);

         transformNode .children .push (shapeNode);
         shapeNode .appearance = this .createFillAppearance (bbox);

         if (geometryNode)
         {
            shapeNode .geometry = geometryNode;
         }
         else
         {
            const geometryNode = scene .createNode ("IndexedTriangleSet");

            this .fillGeometries .set (xmlElement, geometryNode);

            shapeNode .geometry    = geometryNode;
            geometryNode .solid    = this .solid;
            geometryNode .index    = this .triangulatePolygon (contours, coordinateNode);
            geometryNode .texCoord = this .createTextureCoordinate (coordinateNode, bbox, shapeNode .appearance);
            geometryNode .coord    = coordinateNode;
         }
      }

      if (this .style .strokeType !== "none")
      {
         const
            shapeNode    = scene .createNode ("Shape"),
            geometryNode = this .strokeGeometries .get (xmlElement);

         transformNode .children .push (shapeNode);
         shapeNode .appearance = this .createStrokeAppearance ();

         if (geometryNode)
         {
            shapeNode .geometry = geometryNode;
         }
         else
         {
            const geometryNode = scene .createNode ("IndexedLineSet");

            this .strokeGeometries .set (xmlElement, geometryNode);

            shapeNode .geometry = geometryNode;
            geometryNode .coord = coordinateNode;

            // Create contour indices.

            const indices = [ ];

            for (const points of contours)
            {
               for (const i of points .keys ())
                  indices .push (points .index + i);

               if (points .closed)
                  indices .push (points .index);

               indices .push (-1);
            }

            geometryNode .coordIndex = indices;
         }
      }

      this .popAll ();
   },
   linearGradientElementUrl (xmlElement, bbox)
   {
      const
         g        = this .linearGradientElement (xmlElement, bbox, { stops: [ ] }),
         gradient = this .context .createLinearGradient (g .x1, g .y1, g .x2, g .y2);

      return this .drawGradient (gradient, g, bbox);
   },
   linearGradientElement (xmlElement, bbox, gradient)
   {
      if (xmlElement .nodeName !== "linearGradient")
         return;

      // Attribute xlink:href

      const refElement = this .hrefAttribute (xmlElement .getAttribute ("href") || xmlElement .getAttribute ("xlink:href"));

      if (refElement)
         this .gradientElement (refElement, bbox, gradient);

      // Attributes

      gradient .x1        = this .lengthAttribute (xmlElement .getAttribute ("x1"), gradient .x1 || 0, "width");
      gradient .y1        = this .lengthAttribute (xmlElement .getAttribute ("y1"), gradient .y1 || 0, "height");
      gradient .x2        = this .lengthAttribute (xmlElement .getAttribute ("x2"), gradient .x2 || 1, "width");
      gradient .y2        = this .lengthAttribute (xmlElement .getAttribute ("y2"), gradient .y2 || 0, "height");
      gradient .units     = xmlElement .getAttribute ("gradientUnits") || "objectBoundingBox";
      gradient .transform = this .transformAttribute (xmlElement .getAttribute ("gradientTransform"));

      // Spread matrix

      const
         s = new Matrix3/* default */.A (),
         c = new Vector2/* default */.A (gradient .x1, gradient .y1);

      s .translate (c);
      s .scale (new Vector2/* default */.A (SPREAD, SPREAD));
      s .translate (c .negate ());

      gradient .spreadMatrix = s;

      // Stops

      for (const childNode of xmlElement .childNodes)
         this .gradientChild (childNode, gradient);

      return gradient;
   },
   radialGradientElementUrl (xmlElement, bbox)
   {
      const
         g        = this .radialGradientElement (xmlElement, bbox, { stops: [ ] }),
         gradient = this .context .createRadialGradient (g .fx, g .fy, g .fr, g .cx, g .cy, g .r);

      return this .drawGradient (gradient, g, bbox);
   },
   radialGradientElement (xmlElement, bbox, gradient)
   {
      // Attribute xlink:href

      const refElement = this .hrefAttribute (xmlElement .getAttribute ("href") || xmlElement .getAttribute ("xlink:href"));

      if (refElement)
         this .gradientElement (refElement, bbox, gradient);

      // Attributes

      gradient .cx           = this .lengthAttribute (xmlElement .getAttribute ("cx"), gradient .cx || 0.5, "width"),
      gradient .cy           = this .lengthAttribute (xmlElement .getAttribute ("cy"), gradient .cy || 0.5, "height"),
      gradient .r            = this .lengthAttribute (xmlElement .getAttribute ("r"),  gradient .r  || 0.5),
      gradient .fx           = this .lengthAttribute (xmlElement .getAttribute ("fx"), gradient .fx || gradient .cx, "width"),
      gradient .fy           = this .lengthAttribute (xmlElement .getAttribute ("fy"), gradient .fy || gradient .cy, "height"),
      gradient .fr           = this .lengthAttribute (xmlElement .getAttribute ("fr"), gradient .fr || 0),
      gradient .units        = xmlElement .getAttribute ("gradientUnits") || "objectBoundingBox";
      gradient .spreadMethod = xmlElement .getAttribute ("spreadMethod");
      gradient .transform    = this .transformAttribute (xmlElement .getAttribute ("gradientTransform"));

      // Spread matrix

      const
         s = new Matrix3/* default */.A (),
         c = new Vector2/* default */.A (gradient .fx, gradient .fy);

      s .translate (c);
      s .scale (new Vector2/* default */.A (SPREAD));
      s .translate (c .negate ());

      gradient .spreadMatrix = s;

      // Stops

      for (const childNode of xmlElement .childNodes)
         this .gradientChild (childNode, gradient);

      return gradient;
   },
   gradientElement (xmlElement, bbox, gradient)
   {
      if (!xmlElement)
         return;

      switch (xmlElement .nodeName)
      {
         case "linearGradient":
            return this .linearGradientElement (xmlElement, bbox, gradient);
         case "radialGradient":
            return this .radialGradientElement (xmlElement, bbox, gradient);
      }
   },
   gradientChild (xmlElement, gradient)
   {
      if (xmlElement .nodeName === "stop")
         return this .stopElement (xmlElement, gradient);
   },
   stopElement (xmlElement, gradient)
   {
      if (!this .styleAttributes (xmlElement))
         return;

      const offset = this .percentAttribute (xmlElement .getAttribute ("offset"), 0);

      if (offset < 0 || offset > 1)
         return;

      const { stopColor, stopOpacity } = this .style;

      gradient .stops .push ([offset, stopColor, stopOpacity]);

      this .styles .pop ();
   },
   drawGradient (gradient, g, bbox)
   {
      // Add color stops.

      switch (g .spreadMethod)
      {
         default: // pad
         {
            g .spreadMatrix .identity ();

            for (const [o, c, a] of g .stops)
               gradient .addColorStop (o, this .cssColor (c, a));

            break;
         }
         case "repeat":
         {
            for (let i = 0; i < SPREAD; ++ i)
            {
               const s = i / SPREAD;

               for (const [o, c, a] of g .stops)
                  gradient .addColorStop (s + o / SPREAD, this .cssColor (c, a));
            }

            break;
         }
         case "reflect":
         {
            for (let i = 0; i < SPREAD; ++ i)
            {
               const s = i / SPREAD;

               for (const [o, c, a] of g .stops)
                  gradient .addColorStop (s + (i % 2 ? 1 - o : o) / SPREAD, this .cssColor (c, a));
            }

            break;
         }
      }

      // Create Matrix.

      const m = new Matrix3/* default */.A ();

      m .scale (new Vector2/* default */.A (this .GRADIENT_SIZE / 2));
      m .translate (Vector2/* default */.A .ONE);
      m .scale (new Vector2/* default */.A (1, -1));

      if (g .units === "userSpaceOnUse")
         m .multLeft (bbox .matrix .copy () .inverse ());
      else
         m .multLeft (new Matrix3/* default */.A (2, 0, 0, 0, 2, 0, -1, -1, 1));

      m .multLeft (g .transform);
      m .multLeft (g .spreadMatrix);

      // Paint.

      const cx = this .context;

      cx .fillStyle = gradient;
      cx .save ();
      cx .clearRect (0, 0, this .GRADIENT_SIZE, this .GRADIENT_SIZE);
      cx .rect (0, 0, this .GRADIENT_SIZE, this .GRADIENT_SIZE);
      cx .transform (m [0], m [1], m [3], m [4], m [6], m [7]);
      cx .fill ();
      cx .restore ();

      // Use PNG because image can have alpha channel.
      return this .context .canvas .toDataURL ("image/png");
   },
   patternUrl (xmlElement)
   {
      //console .debug ("pattern");
   },
   idAttribute (attribute, node)
   {
      if (attribute === null)
         return;

      const
         scene = this .getExecutionContext (),
         name  = this .sanitizeName (attribute);

      if (!name)
         return;

      scene .addNamedNode (scene .getUniqueName (name), node);
      scene .addExportedNode (scene .getUniqueExportName (name), node);
   },
   viewBoxAttribute (attribute, defaultValue)
   {
      if (attribute === null)
         return defaultValue;

      this .parseValue (attribute);

      if (this .double ())
      {
         const x = this .value;

         if (this .double ())
         {
            const y = this .value;

            if (this .double ())
            {
               const width = this .value;

               if (this .double ())
               {
                  const height = this .value;

                  return new Vector4/* default */.A (x, y, width, height);
               }
            }
         }
      }

      return defaultValue;
   },
   hrefAttribute (attribute)
   {
      if (!attribute)
         return;

      const
         scene = this .getExecutionContext (),
         hash  = new URL (attribute, scene .getBaseURL ()) .hash .slice (1);

      return this .document .getElementById (hash);
   },
   lengthAttribute (attribute, defaultValue, percent)
   {
      // Returns length in pixel.

      if (attribute === null)
         return defaultValue;

      this .parseValue (attribute);

      if (this .double ())
      {
         let value = this .value;

         // Parse unit

         if (SVGParser_Grammar .length .parse (this))
         {
            switch (this .result [0])
            {
               case "em":
                  value *= EM;
                  break;
               case "ex":
                  // TODO
                  break;
               case "px":
                  // We are pixels :)
                  break;
               case "in":
                  value *= INCH / PIXEL;
                  break;
               case "cm":
                  value *= CM / PIXEL;
                  break;
               case "mm":
                  value *= MM / PIXEL;
                  break;
               case "pt":
                  value *= POINT / PIXEL;
                  break;
               case "pc":
                  value *= PICA / PIXEL;
                  break;
               case "%":
               {
                  switch (percent)
                  {
                     case "width":
                        value *= this .viewBox [2] / 100;
                        break;
                     case "height":
                        value *= this .viewBox [3] / 100;
                        break;
                     default:
                        value *= Math .hypot (this .viewBox [2], this .viewBox [3]) / 100;
                        break;
                     }

                  break;
               }
            }
         }

         return value;
      }

      return defaultValue;
   },
   percentAttribute (attribute, defaultValue)
   {
      this .parseValue (attribute);

      if (this .double ())
      {
         let value = this .value;

         // Parse unit

         if (SVGParser_Grammar .percent .parse (this))
            value /= 100;

         return Algorithm/* default */.A .clamp (value, 0, 1);
      }

      return defaultValue;
   },
   pointsAttribute (attribute, points)
   {
      if (attribute === null)
         return false;

      this .parseValue (attribute);

      while (true)
      {
         if (this .double ())
         {
            const x = this .value;

            if (this .comma ())
            {
               if (this .double ())
               {
                  const y = this .value;

                  points .push (new Vector3/* default */.A (x, y, 0));

                  if (this .comma ())
                     continue;
               }
            }
         }

         break;
      }

      return !! points .length;
   },
   dAttribute (attribute, contours)
   {
      if (attribute === null)
         return false;

      this .parseValue (attribute);

      let
         points   = [ ],
         previous = "",
         command  = "",
         relative = false,
         ax       = 0,
         ay       = 0,
         px       = 0,
         py       = 0;

      while (true)
      {
         this .whitespaces ();

         if (!SVGParser_Grammar .path .parse (this))
            break;

         previous = command;
         command  = this .result [0];
         relative = command === command .toLowerCase ();

         switch (command)
         {
            case "m":
            case "M":
            {
               // moveto

               if (points .length > 2)
                  contours .push (Object .assign (points, { closed: false }));

               points = [ ];

               while (true)
               {
                  if (this .double ())
                  {
                     let x = this .value;

                     this .comma ();

                     if (this .double ())
                     {
                        let y = this .value;

                        if (relative)
                        {
                           x += ax;
                           y += ay;
                        }

                        points .push (new Vector3/* default */.A (x, y, 0));

                        ax = x;
                        ay = y;

                        this .comma ();
                        continue;
                     }
                  }

                  break;
               }

               continue;
            }
            case "l":
            case "L":
            {
               // lineto

               while (true)
               {
                  if (this .double ())
                  {
                     let x = this .value;

                     this .comma ();

                     if (this .double ())
                     {
                        let y = this .value;

                        if (relative)
                        {
                           x += ax;
                           y += ay;
                        }

                        points .push (new Vector3/* default */.A (x, y, 0));

                        ax = x;
                        ay = y;

                        this .comma ();
                        continue;
                     }
                  }

                  break;
               }

               continue;
            }
            case "h":
            case "H":
            {
               // horizontal lineto

               while (true)
               {
                  if (this .double ())
                  {
                     let x = this .value;

                     if (relative)
                        x += ax;

                     points .push (new Vector3/* default */.A (x, ay, 0));

                     ax = x;

                     this .comma ();
                     continue;
                  }

                  break;
               }

               continue;
            }
            case "v":
            case "V":
            {
               // vertical lineto

               while (this)
               {
                  if (this .double ())
                  {
                     let y = this .value;

                     if (relative)
                        y += ay;

                     points .push (new Vector3/* default */.A (ax, y, 0));

                     ay = y;

                     this .comma ();
                     continue;
                  }

                  break;
               }

               continue;
            }
            case "q":
            case "Q":
            {
               // quadratic Bézier curveto

               while (true)
               {
                  if (this .double ())
                  {
                     let x1 = this .value;

                     this .comma ();

                     if (this .double ())
                     {
                        let y1 = this .value;

                        this .comma ();

                        if (this .double ())
                        {
                           let x = this .value;

                           this .comma ();

                           if (this .double ())
                           {
                              let y = this .value;

                              if (relative)
                              {
                                 x1 += ax;
                                 y1 += ay;
                                 x  += ax;
                                 y  += ay;
                              }

                              Algorithms_Bezier .quadric (ax, ay, 0, x1, y1, 0, x, y, 0, this .BEZIER_STEPS, points);

                              ax = x;
                              ay = y;
                              px = x1;
                              py = y1;

                              this .comma ();
                              continue;
                           }
                        }
                     }
                  }

                  break;
               }

               continue;
            }
            case "t":
            case "T":
            {
               // Shorthand/smooth quadratic Bézier curveto

               while (true)
               {
                  if (this .double ())
                  {
                     let x = this .value;

                     this .comma ();

                     if (this .double ())
                     {
                        let y = this .value;

                        if (relative)
                        {
                           x += ax;
                           y += ay;
                        }

                        let x1, y1;

                        switch (previous)
                        {
                           case 'Q':
                           case 'q':
                           case 'T':
                           case 't':
                           {
                              x1 = ax + (ax - px);
                              y1 = ay + (ay - py);
                              break;
                           }
                           default:
                           {
                              x1 = ax;
                              y1 = ay;
                              break;
                           }
                        }

                        Algorithms_Bezier .quadric (ax, ay, 0, x1, y1, 0, x, y, 0, this .BEZIER_STEPS, points);

                        ax = x;
                        ay = y;

                        this .comma ();
                        continue;
                     }
                  }

                  break;
               }

               continue;
            }
            case "c":
            case "C":
            {
               // curveto, cubic Bézier curve

               while (true)
               {
                  if (this .double ())
                  {
                     let x1 = this .value;

                     this .comma ();

                     if (this .double ())
                     {
                        let y1 = this .value;

                        this .comma ();

                        if (this .double ())
                        {
                           let x2 = this .value;

                           this .comma ();

                           if (this .double ())
                           {
                              let y2 = this .value;

                              this .comma ();

                              if (this .double ())
                              {
                                 let x = this .value;

                                 this .comma ();

                                 if (this .double ())
                                 {
                                    let y = this .value;

                                    if (relative)
                                    {
                                       x1 += ax;
                                       y1 += ay;
                                       x2 += ax;
                                       y2 += ay;
                                       x  += ax;
                                       y  += ay;
                                    }

                                    Algorithms_Bezier .cubic (ax, ay, 0, x1, y1, 0, x2, y2, 0, x, y, 0, this .BEZIER_STEPS, points);

                                    ax = x;
                                    ay = y;
                                    px = x2;
                                    py = y2;

                                    this .comma ();
                                    continue;
                                 }
                              }
                           }
                        }
                     }
                  }

                  break;
               }

               continue;
            }
            case "s":
            case "S":
            {
               // shorthand/smooth curveto, cubic Bézier curve

               while (true)
               {
                  if (this .double ())
                  {
                     let x2 = this .value;

                     this .comma ();

                     if (this .double ())
                     {
                        let y2 = this .value;

                        this .comma ();

                        if (this .double ())
                        {
                           let x = this .value;

                           this .comma ();

                           if (this .double ())
                           {
                              let y = this .value;

                              if (relative)
                              {
                                 x2 += ax;
                                 y2 += ay;
                                 x  += ax;
                                 y  += ay;
                              }

                              let x1, y1;

                              switch (previous)
                              {
                                 case 'C':
                                 case 'c':
                                 case 'S':
                                 case 's':
                                 {
                                    x1 = ax + (ax - px);
                                    y1 = ay + (ay - py);
                                    break;
                                 }
                                 default:
                                 {
                                    x1 = ax;
                                    y1 = ay;
                                    break;
                                 }
                              }

                              Algorithms_Bezier .cubic (ax, ay, 0, x1, y1, 0, x2, y2, 0, x, y, 0, this .BEZIER_STEPS, points);

                              ax = x;
                              ay = y;
                              px = x2;
                              py = y2;

                              this .comma ();
                              continue;
                           }
                        }
                     }
                  }

                  break;
               }

               continue;
            }
            case "a":
            case "A":
            {
               // elliptical arc

               while (true)
               {
                  if (this .double ())
                  {
                     let rx = this .value;

                     this .comma ();

                     if (this .double ())
                     {
                        let ry = this .value;

                        this .comma ();

                        if (this .double ())
                        {
                           let xAxisRotation = Algorithm/* default */.A .radians (this .value);

                           this .comma ();

                           if (this .int32 ())
                           {
                              let largeArcFlag = this .value;

                              this .comma ();

                              if (this .int32 ())
                              {
                                 let sweepFlag = this .value;

                                 this .comma ();

                                 if (this .double ())
                                 {
                                    let x = this .value;

                                    this .comma ();

                                    if (this .double ())
                                    {
                                       let y = this .value;

                                       if (relative)
                                       {
                                          x += ax;
                                          y += ay;
                                       }

                                       Algorithms_Bezier .arc (ax, ay, rx, ry, xAxisRotation, largeArcFlag, sweepFlag, x, y, this .CIRCLE_STEPS, points);

                                       ax = x;
                                       ay = y;

                                       this .comma ();
                                       continue;
                                    }
                                 }
                              }
                           }
                        }
                     }
                  }

                  break;
               }

               continue;
            }
            case "z":
            case "Z":
            {
               // closepath

               if (points .length > 2)
               {
                  ax = points [0] .x;
                  ay = points [0] .y;

                  contours .push (Object .assign (points, { closed: true }));
               }

               points = [ ];

               this .comma ();
               continue;
            }
         }

         break;
      }

      if (points .length > 2)
         contours .push (Object .assign (points, { closed: false }));

      return !! contours .length;
   },
   transformAttribute (attribute)
   {
      const matrix = new Matrix3/* default */.A ();

      if (attribute === null)
         return matrix;

      this .parseValue (attribute);

      while (true)
      {
         this .comma ();
         this .whitespaces ();

         if (SVGParser_Grammar .matrix .parse (this))
         {
            this .whitespaces ();

            if (SVGParser_Grammar .openParenthesis .parse (this))
            {
               if (this .double ())
               {
                  const a = this .value;

                  if (this .comma ())
                  {
                     if (this .double ())
                     {
                        const b = this .value;

                        if (this .comma ())
                        {
                           if (this .double ())
                           {
                              const c = this .value;

                              if (this .comma ())
                              {
                                 if (this .double ())
                                 {
                                    const d = this .value;

                                    if (this .comma ())
                                    {
                                       if (this .double ())
                                       {
                                          const e = this .value;

                                          if (this .comma ())
                                          {
                                             if (this .double ())
                                             {
                                                const f = this .value;

                                                this .whitespaces ();

                                                if (SVGParser_Grammar .closeParenthesis .parse (this))
                                                {
                                                   matrix .multLeft (new Matrix3/* default */.A (a, b, 0, c, d, 0, e, f, 1));
                                                   continue;
                                                }
                                             }
                                          }
                                       }
                                    }
                                 }
                              }
                           }
                        }
                     }
                  }
               }
            }
         }
         else if (SVGParser_Grammar .translate .parse (this))
         {
            this .whitespaces ();

            if (SVGParser_Grammar .openParenthesis .parse (this))
            {
               if (this .double ())
               {
                  const tx = this .value;

                  let ty;

                  if (this .comma ())
                  {
                     if (this .double ())
                     {
                        ty = this .value;
                     }
                  }
                  else
                  {
                     ty = 0;
                  }

                  this .whitespaces ();

                  if (SVGParser_Grammar .closeParenthesis .parse (this))
                  {
                     matrix .translate (new Vector2/* default */.A (tx, ty));
                     continue;
                  }
               }
            }
         }
         else if (SVGParser_Grammar .rotate .parse (this))
         {
            this .whitespaces ();

            if (SVGParser_Grammar .openParenthesis .parse (this))
            {
               if (this .double ())
               {
                  const angle = this .value;

                  this .whitespaces ();

                  if (SVGParser_Grammar .closeParenthesis .parse (this))
                  {
                     matrix .rotate (Algorithm/* default */.A .radians (angle));
                     continue;
                  }
                  else
                  {
                     if (this .comma ())
                     {
                        if (this .double ())
                        {
                           const cx = this .value;

                           if (this .comma ())
                           {
                              if (this .double ())
                              {
                                 const cy = this .value;

                                 this .whitespaces ();

                                 if (SVGParser_Grammar .closeParenthesis .parse (this))
                                 {
                                    matrix .translate (new Vector2/* default */.A (cx, cy));
                                    matrix .rotate (Algorithm/* default */.A .radians (angle));
                                    matrix .translate (new Vector2/* default */.A (-cx, -cy));
                                    continue;
                                 }
                              }
                           }
                        }
                     }
                  }
               }
            }
         }
         else if (SVGParser_Grammar .scale .parse (this))
         {
            this .whitespaces ();

            if (SVGParser_Grammar .openParenthesis .parse (this))
            {
               if (this .double ())
               {
                  const sx = this .value;

                  let sy;

                  if (this .comma ())
                  {
                     if (this .double ())
                     {
                        sy = this .value;
                     }
                  }
                  else
                  {
                     sy = sx;
                  }

                  this .whitespaces ();

                  if (SVGParser_Grammar .closeParenthesis .parse (this))
                  {
                     matrix .scale (new Vector2/* default */.A (sx, sy));
                     continue;
                  }
               }
            }
         }
         else if (SVGParser_Grammar .skewX .parse (this))
         {
            this .whitespaces ();

            if (SVGParser_Grammar .openParenthesis .parse (this))
            {
               if (this .double ())
               {
                  const angle = this .value;

                  this .whitespaces ();

                  if (SVGParser_Grammar .closeParenthesis .parse (this))
                  {
                     matrix .skewX (Algorithm/* default */.A .radians (angle));
                     continue;
                  }
               }
            }
         }
         else if (SVGParser_Grammar .skewY .parse (this))
         {
            this .whitespaces ();

            if (SVGParser_Grammar .openParenthesis .parse (this))
            {
               if (this .double ())
               {
                  const angle = this .value;

                  this .whitespaces ();

                  if (SVGParser_Grammar .closeParenthesis .parse (this))
                  {
                     matrix .skewY (Algorithm/* default */.A .radians (angle));
                     continue;
                  }
               }
            }
         }

         break;
      }

      return matrix;
   },
   styleAttributes (xmlElement)
   {
      const style = Object .assign ({ }, this .styles .at (-1));

      if (this .style .display === "none")
         return false;

      this .styles .push (style);

      for (const attribute of xmlElement .attributes)
         this .parseStyle (attribute .name, attribute .value)

      // Style attribute has higher precedence.

      this .styleAttribute (xmlElement .getAttribute ("style"));

      return true;
   },
   styleAttribute (attribute)
   {
      if (attribute === null)
         return;

      const values = attribute .split (";");

      for (const value of values)
      {
         const pair = value .split (":");

         if (pair .length !== 2)
            continue;

         this .parseStyle (pair [0] .trim (), pair [1] .trim ());
      }
   },
   parseStyle (style, value)
   {
      if (value === "inherit" || value == "unset")
         return;

      this .parseValue (value);

      switch (style)
      {
         case "display":
            this .displayStyle (value);
            break;
         case "fill":
            this .fillStyle (value);
            break;
         case "fill-opacity":
            this .fillOpacityStyle (value);
            break;
         case "fill-rule":
            this .fillRuleStyle (value);
            break;
         case "stroke":
            this .strokeStyle (value);
            break;
         case "stroke-opacity":
            this .strokeOpacityStyle (value);
            break;
         case "stroke-width":
            this .strokeWidthStyle (value);
            break;
         case "opacity":
            this .opacityStyle (value);
            break;
         case "stop-color":
            this .stopColorStyle (value);
            break;
         case "stop-opacity":
            this .stopOpacityStyle (value);
            break;
         case "vector-effect":
            this .vectorEffectStyle (value);
            break;
      }
   },
   displayStyle (value)
   {
      if (value === "default")
      {
         this .style .display = "inline";
         return;
      }

      this .style .display = value;
   },
   fillStyle (value)
   {
      if (value === "default")
      {
         this .style .fillType  = this .styles [0] .fillType;
         this .style .fillColor = this .styles [0] .fillColor;
         this .style .fillURL   = this .styles [0] .fillURL;
         return;
      }

      if (value === "transparent")
      {
         this .style .fillType = "none";
         return;
      }

      if (value === "none")
      {
         this .style .fillType = "none";
         return;
      }

      if (this .urlValue ())
      {
         this .style .fillType = "URL";
         this .style .fillURL  = this .result [1] .trim ();
         return;
      }

      if (this .colorValue (this .styles .at (-1) .fillColor))
      {
         this .style .fillType  = "COLOR";
         this .style .fillColor = this .value .copy ();
         return;
      }
   },
   fillOpacityStyle (value)
   {
      if (value === "default")
      {
         this .style .fillOpacity = this .styles [0] .fillOpacity;
         return;
      }

      if (value === "transparent")
      {
         this .style .fillOpacity = 0;
         return;
      }

      if (this .double ())
      {
         this .style .fillOpacity = Algorithm/* default */.A .clamp (this .value, 0, 1);
         return;
      }
   },
   fillRuleStyle (value)
   {
      if (value === "default")
      {
         this .style .fillRule = this .styles [0] .fillRule;
         return;
      }

      this .style .fillRule = value;
   },
   strokeStyle (value)
   {
      if (value === "default")
      {
         this .style .strokeType  = this .styles [0] .strokeType;
         this .style .strokeColor = this .styles [0] .strokeColor;
         this .style .strokeURL   = this .styles [0] .strokeURL;
         return;
      }

      if (value === "transparent")
      {
         this .style .strokeType = "none";
         return;
      }

      if (value === "none")
      {
         this .style .strokeType = "none";
         return;
      }

      if (this .urlValue ())
      {
         this .style .strokeType = "URL";
         this .style .strokeURL  = this .result [1] .trim ();
         return;
      }

      if (this .colorValue (this .styles .at (-1) .strokeColor))
      {
         this .style .strokeType  = "COLOR";
         this .style .strokeColor = this .value .copy ();
         return;
      }
   },
   strokeOpacityStyle (value)
   {
      if (value === "default")
      {
         this .style .strokeOpacity = this .styles [0] .strokeOpacity;
         return;
      }

      if (value === "transparent")
      {
         this .style .strokeOpacity = 0;
         return;
      }

      if (this .double ())
      {
         this .style .strokeOpacity = Algorithm/* default */.A .clamp (this .value, 0, 1);
         return;
      }
   },
   strokeWidthStyle (value)
   {
      if (value === "default")
      {
         this .style .strokeWidth = this .styles [0] .strokeWidth;
         return;
      }

      if (value === "none")
      {
         this .style .strokeWidth = 0;
         return;
      }

      if (this .double ())
      {
         this .style .strokeWidth = this .lengthAttribute (this .value, 1);
         return;
      }
   },
   opacityStyle (value)
   {
      if (value === "default")
      {
         this .style .opacity = this .styles [0] .opacity;
         return;
      }

      if (value === "transparent")
      {
         this .style .opacity = 0;
         return;
      }

      if (this .double ())
      {
         this .style .opacity = Algorithm/* default */.A .clamp (this .value, 0, 1) * this .styles .at (-1) .opacity;
         return;
      }
   },
   stopColorStyle (value)
   {
      if (value === "default")
      {
         this .style .stopColor = this .styles [0] .stopColor;
         return;
      }

      if (this .colorValue (Color4/* default */.A .BLACK))
      {
         this .style .stopColor = this .value .copy ();
         return;
      }
   },
   stopOpacityStyle (value)
   {
      if (value === "default")
      {
         this .style .stopOpacity = this .styles [0] .stopOpacity;
         return;
      }

      if (value === "transparent")
      {
         this .style .stopOpacity = 0;
         return;
      }

      if (this .double ())
      {
         this .style .stopOpacity = Algorithm/* default */.A .clamp (this .value, 0, 1);
         return;
      }
   },
   vectorEffectStyle (value)
   {
      if (value === "default")
      {
         this .style .vectorEffect = this .styles [0] .vectorEffect;
         return;
      }

      this .style .vectorEffect = value;
   },
   parseValue (value)
   {
      this .input     = value;
      this .lastIndex = 0;
      this .value     = undefined;
   },
   whitespaces ()
   {
      return SVGParser_Grammar .whitespaces .parse (this);
   },
   comma ()
   {
      return !! (this .whitespaces () | SVGParser_Grammar .comma .parse (this));
   },
   int32 ()
   {
      this .whitespaces ();

      if (SVGParser_Grammar .int32 .parse (this))
      {
         this .value = parseInt (this .result [0]);

         return true;
      }

      return false;
   },
   double ()
   {
      this .whitespaces ();

      if (SVGParser_Grammar .double .parse (this))
      {
         this .value = parseFloat (this .result [0]);

         return true;
      }

      if (SVGParser_Grammar .constants .parse (this))
      {
         this .value = this .CONSTANTS .get (this .result [2] .toUpperCase ());

         if (this .result [1] === "-")
            this .value = - this .value;

         return true;
      }

      return false;
   },
   colorValue: (() =>
   {
      const color = new Color4/* default */.A ();

      return function (c)
      {
         if (!SVGParser_Grammar .color .parse (this))
            return false;

         const defaultColor = this .cssColor (c);

         this .value = color .set (... this .convertColor (this .result [0], defaultColor));

         return true;
      };
   })(),
   urlValue ()
   {
      return SVGParser_Grammar .url .parse (this);
   },
   cssColor (c, a = c .a)
   {
      return `rgba(${c .r * 255},${c .g * 255},${c .b * 255},${a})`;
   },
   createTransform (xmlElement, t = Vector2/* default */.A .ZERO, s = Vector2/* default */.A .ONE)
   {
      // Determine matrix.

      const
         scene = this .getExecutionContext (),
         m     = this .transformAttribute (xmlElement .getAttribute ("transform"));

      this .modelMatrix .push ();
      this .modelMatrix .multLeft (Matrix4/* default */.A .Matrix3 (m));

      m .translate (t);
      m .scale (s);

      // Create node.

      const
         transformNode    = scene .createNode ("Transform"),
         matrix           = Matrix4/* default */.A .Matrix3 (m),
         translation      = new Vector3/* default */.A (),
         rotation         = new Rotation4/* default */.A (),
         scale            = new Vector3/* default */.A (1),
         scaleOrientation = new Rotation4/* default */.A ();

      matrix .get (translation, rotation, scale, scaleOrientation);

      transformNode .translation      = translation;
      transformNode .rotation         = rotation;
      transformNode .scale            = scale;
      transformNode .scaleOrientation = scaleOrientation;

      // Set name.

      this .idAttribute (xmlElement .getAttribute ("id"), transformNode);

      // Add node to parent.

      this .groupNodes .at (-1) .children .push (transformNode);

      return transformNode;
   },
   popAll ()
   {
      this .groupNodes  .pop ();
      this .modelMatrix .pop ();
      this .styles      .pop ();
   },
   createFillAppearance (bbox)
   {
      const
         scene          = this .getExecutionContext (),
         appearanceNode = scene .createNode ("Appearance");

      switch (this .style .fillType)
      {
         case "none":
         {
            return null;
         }
         case "COLOR":
         {
            const materialNode = scene .createNode ("UnlitMaterial");

            appearanceNode .material    = materialNode;
            materialNode .emissiveColor = new Color3/* default */.A (... this .style .fillColor);
            materialNode .transparency  = 1 - this .style .fillOpacity * this .style .opacity;

            break;
         }
         case "URL":
         {
            // Gradient

            const
               scene       = this .getExecutionContext (),
               textureNode = scene .createNode ("ImageTexture"),
               url         = this .getFillUrl (this .style .fillURL, bbox);

            // Get image from url.

            if (!url)
               return null;

            textureNode .url               = [url];
            textureNode .textureProperties = this .texturePropertiesNode;
            appearanceNode .texture        = textureNode;

            break;
         }
      }

      return appearanceNode;
   },
   getFillUrl (fillURL, bbox)
   {
      const xmlElement = this .hrefAttribute (fillURL);

      if (!xmlElement)
         return;

      switch (xmlElement .nodeName)
      {
         case "linearGradient":
            return this .linearGradientElementUrl (xmlElement, bbox);

         case "radialGradient":
            return this .radialGradientElementUrl (xmlElement, bbox);

         case "pattern":
            return this .patternUrl (xmlElement);
      }
   },
   createStrokeAppearance ()
   {
      const
         scene          = this .getExecutionContext (),
         appearanceNode = scene .createNode ("Appearance"),
         materialNode   = scene .createNode ("UnlitMaterial");

      appearanceNode .material    = materialNode;
      materialNode .emissiveColor = new Color3/* default */.A (... this .style .strokeColor);
      materialNode .transparency  = 1 - this .style .strokeOpacity * this .style .opacity;

      const strokeWidth = this .vectorEffect === "non-scaling-stroke"
         ? this .style .strokeWidth
         : this .getStokeWidth ();

      if (strokeWidth > 1)
         appearanceNode .lineProperties = this .getLineProperties (strokeWidth);

      return appearanceNode;
   },
   getStokeWidth ()
   {
      const
         modelMatrix = this .modelMatrix .get (),
         strokeWidth = modelMatrix .multDirMatrix (new Vector3/* default */.A (this .style .strokeWidth, this .style .strokeWidth, 0));

      return (strokeWidth .x + strokeWidth .y) / 2;
   },
   getLineProperties (strokeWidth)
   {
      const lineProperties = this .lineProperties .get (strokeWidth);

      if (lineProperties)
      {
         return lineProperties;
      }
      else
      {
         const
            scene          = this .getExecutionContext (),
            lineProperties = scene .createNode ("LineProperties");

         lineProperties .linewidthScaleFactor = strokeWidth;

         this .lineProperties .set (strokeWidth, lineProperties);

         return lineProperties;
      }
   },
   createTextureProperties ()
   {
      const
         scene                 = this .getExecutionContext (),
         texturePropertiesNode = scene .createNode ("TextureProperties");

      texturePropertiesNode .generateMipMaps     = true;
      texturePropertiesNode .minificationFilter  = "NICEST";
      texturePropertiesNode .magnificationFilter = "NICEST";
      texturePropertiesNode .boundaryModeS       = "CLAMP_TO_EDGE";
      texturePropertiesNode .boundaryModeT       = "CLAMP_TO_EDGE";
      texturePropertiesNode .boundaryModeR       = "CLAMP_TO_EDGE";
      texturePropertiesNode .textureCompression  = "DEFAULT";

      return texturePropertiesNode;
   },
   createTextureCoordinate (coordinateNode, bbox, appearance)
   {
      if (!appearance || !appearance .texture)
         return null;

      const
         scene        = this .getExecutionContext (),
         texCoordNode = scene .createNode ("TextureCoordinate"),
         invMatrix    = bbox .matrix .copy () .inverse ();

      for (const point of coordinateNode .point)
         texCoordNode .point .push (invMatrix .multVecMatrix (new Vector2/* default */.A (point .x, point .y)) .add (Vector2/* default */.A .ONE) .divide (2));

      return texCoordNode;
   },
   createTesselator ()
   {
      // Function called for each vertex of tessellator output.

      function vertexCallback (index, triangles)
      {
         triangles .push (index);
      }

      const tessy = new libtess .GluTesselator ();

      tessy .gluTessCallback (libtess .gluEnum .GLU_TESS_VERTEX_DATA, vertexCallback);
      tessy .gluTessNormal (0, 0, 1);

      return tessy;
   },
   triangulatePolygon (contours, coordinateNode)
   {
      // Callback for when segments intersect and must be split.

      const vertices = coordinateNode .point;

      function combineCallback (coords, data, weight)
      {
         const index = vertices .length;

         vertices .push (new Vector3/* default */.A (... coords));

         return index;
      }

      const
         tessy     = this .tessy,
         winding   = this .style .fillRule === "evenodd" ? "GLU_TESS_WINDING_ODD" : "GLU_TESS_WINDING_NONZERO",
         triangles = [ ];

      tessy .gluTessProperty (libtess .gluEnum .GLU_TESS_WINDING_RULE, libtess .windingRule [winding]);
      tessy .gluTessCallback (libtess .gluEnum .GLU_TESS_COMBINE,      combineCallback);
      tessy .gluTessBeginPolygon (triangles);

      for (const points of contours)
      {
         tessy .gluTessBeginContour ();

         for (const [i, point] of points .entries ())
            tessy .gluTessVertex (point, points .index + i);

         tessy .gluTessEndContour ();
      }

      tessy .gluTessEndPolygon ();

      // Array of indices of triangles.
      return triangles;
   },
});

Object .defineProperty (SVGParser .prototype, "style",
{
   get ()
   {
      return this .styles .at (-1);
   },
})

const SVGParser_default_ = SVGParser;
;

/* harmony default export */ const Parser_SVGParser = (Namespace/* default */.A .add ("SVGParser", SVGParser_default_));
;// ./src/x_ite/Parser/GoldenGate.js
/* provided dependency */ var GoldenGate_$ = __webpack_require__(4993);













class GoldenGate extends X3DParser/* default */.A
{
   #inputs = new Map ();

   static #parsers = [
      Parser_SVGParser,
      XMLParser/* default */.A,
      Parser_GLTF2Parser,
      Parser_GLB2Parser,
      JSONParser/* default */.A,
      VRMLParser/* default */.A,
      Parser_OBJParser,
      Parser_STLAParser,
      Parser_STLBParser,
      Parser_PLYAParser,
      Parser_PLYBParser,
   ];

   static addParsers (... args)
   {
      this .#parsers .push (... args);
   }

   static removeParsers (... args)
   {
      this .#parsers = this .#parsers .filter (parser => !args .includes (parser));
   }

   static getParsers ()
   {
      return this .#parsers .slice ();
   }

   /**
    * @deprecated Use `GoldenGate.add/remove/getParsers`.
    */
   static get Parser () { return this .#parsers; }

   parseIntoScene (x3dSyntax, resolve, reject)
   {
      for (const Parser of GoldenGate .#parsers)
      {
         try
         {
            const
               parser = new Parser (this .getScene ()),
               input  = this .getInput (parser .getEncoding (), x3dSyntax);

            if (Array .isArray (input) ? input .some (i => i === undefined) : input === undefined)
               continue;

            parser .setInput (input);

            if (!parser .isValid ())
               continue;

            parser .pushExecutionContext (this .getExecutionContext ());
            parser .parseIntoScene (resolve, reject);
            return;
         }
         catch (error)
         {
            if (reject)
               reject (error);
            else
               throw error;

            return;
         }
      }

      if (this .getScene () .worldURL .startsWith ("data:"))
         throw new Error ("Couldn't parse X3D. No suitable file handler found for 'data:' URL.");
      else
         throw new Error (`Couldn't parse X3D. No suitable file handler found for '${this .getScene () .worldURL}'.`);
   }

   getInput (encoding, x3dSyntax)
   {
      if (Array .isArray (encoding))
      {
         return encoding .map (encoding => this .getInput (encoding));
      }
      else
      {
         if (this .#inputs .has (encoding))
            return this .#inputs .get (encoding);

         const input = this .createInput (encoding, x3dSyntax);

         this .#inputs .set (encoding, input);

         return input;
      }
   }

   createInput (encoding, x3dSyntax)
   {
      try
      {
         switch (encoding)
         {
            case "STRING":
               return GoldenGate_$.decodeText (x3dSyntax);
            case "XML":
               return GoldenGate_$.parseXML (this .getInput ("STRING", x3dSyntax));
            case "JSON":
               return JSON .parse (this .getInput ("STRING", x3dSyntax));
            case "ARRAY_BUFFER":
               return x3dSyntax instanceof ArrayBuffer ? x3dSyntax : undefined;
         }
      }
      catch
      {
         return undefined;
      }
   }
}

const GoldenGate_default_ = GoldenGate;
;

/* harmony default export */ const Parser_GoldenGate = (Namespace/* default */.A .add ("GoldenGate", GoldenGate_default_));
// EXTERNAL MODULE: ./src/x_ite/Execution/X3DWorld.js
var X3DWorld = __webpack_require__(5212);
// EXTERNAL MODULE: ./src/x_ite/Execution/X3DScene.js
var X3DScene = __webpack_require__(5756);
;// ./src/x_ite/InputOutput/FileLoader.js
/* provided dependency */ var FileLoader_$ = __webpack_require__(4993);







const foreignMimeType = new Set ([
   "text/html",
   "application/xhtml+xml",
])

function FileLoader (node)
{
   X3DObject/* default */.A .call (this);

   this .node             = node;
   this .browser          = node .getBrowser ();
   this .executionContext = node .getExecutionContext ();
   this .target           = "";
   this .url              = [ ];
   this .URL              = new URL (this .getBaseURL ());
   this .controller       = new AbortController ();
}

Object .assign (Object .setPrototypeOf (FileLoader .prototype, X3DObject/* default */.A .prototype),
{
   abort ()
   {
      this .url .length = 0;

      this .controller .abort ();
   },
   getURL ()
   {
      return this .URL;
   },
   getBaseURL ()
   {
      if (this .node instanceof X3DWorld/* default */.A)
         return this .browser .getBaseURL ();

      return this .executionContext .getBaseURL ();
   },
   getTarget (parameters)
   {
      for (const parameter of parameters)
      {
         const pair = parameter .split ("=");

         if (pair .length !== 2)
            continue;

         if (pair [0] === "target")
            return pair [1];
      }

      return "";
   },
   createX3DFromString (worldURL, string = "", resolve, reject)
   {
      try
      {
         const scene = new X3DScene/* default */.A (this .browser);

         if (!(this .node instanceof X3DWorld/* default */.A))
            scene .setExecutionContext (this .executionContext);

         scene .setWorldURL (new URL (worldURL, this .getBaseURL ()));
         scene .setup ();

         if (resolve)
            resolve = this .setScene .bind (this, scene, resolve, reject);

         new Parser_GoldenGate (scene) .parseIntoScene (string, resolve, reject);

         return scene;
      }
      catch (error)
      {
         if (reject)
            reject (error);
         else
            throw error;
      }
   },
   setScene (scene, resolve, reject)
   {
      scene ._loadCount .addInterest ("set_loadCount__", this, scene, resolve, reject);
      scene ._loadCount .addEvent ();
   },
   async set_loadCount__ (scene, resolve, reject)
   {
      try
      {
         if (scene ._loadCount .getValue ())
            return;

         scene ._loadCount .removeInterest ("set_loadCount__", this);

         // Wait for instances to be created and events to be processed.

         await this .browser .nextFrame ();

         resolve (scene);
      }
      catch (error)
      {
         if (reject)
            reject (error);
         else
            throw error;
      }

      if (DEVELOPMENT/* default */.A)
      {
         if (this .URL .protocol !== "data:")
            console .info (`Done loading scene '${decodeURI (this .URL)}'.`);
      }
   },
   createX3DFromURL (url, parameter, callback, bindViewpoint, foreign)
   {
      this .bindViewpoint = bindViewpoint;
      this .foreign       = foreign;
      this .target        = this .getTarget (parameter || new Fields/* default */.A .MFString ());

      return this .loadDocument (url, this .createX3DFromURLAsync .bind (this, callback));
   },
   createX3DFromURLAsync (callback, data)
   {
      if (data === null)
         callback (null);
      else
         this .createX3DFromString (this .URL, data, callback, this .loadDocumentError .bind (this));
   },
   loadDocument (url, callback)
   {
      this .url      = url .slice ();
      this .callback = callback;

      if (url .length === 0)
         return this .loadDocumentError (new Error ("No URL given."));

      this .loadDocumentAsync (String (this .url .shift ()))
         .catch (this .loadDocumentError .bind (this));
   },
   async loadDocumentAsync (url)
   {
      if (url .length === 0)
      {
         this .loadDocumentError (new Error ("URL is empty."));
         return;
      }

      // Script
      {
         const result = url .match (/^\s*(?:ecmascript|javascript|vrmlscript)\:/s);

         if (result)
         {
            await this .callback (url .substring (result [0] .length));
            return;
         }
      }

      this .URL = new URL (url, this .getBaseURL ());

      // Data URL
      {
         const result = url .match (/^\s*data:(.*?)(?:;charset=(.*?))?(?:;(base64))?,/s);

         if (result && result [3] !== "base64")
         {
            // const mimeType = result [1] || "text/plain"";

            let data = url .substring (result [0] .length);

            data = FileLoader_$.try (() => decodeURIComponent (data)) ?? data; // Decode data.
            data = data .replace (/^ï»¿/, "");                      // Remove BOM.

            await this .callback (data);
            return;
         }
      }

      if (this .URL .protocol !== "data:" && this .bindViewpoint)
      {
         const referer = new URL (this .getBaseURL ());

         if (this .URL .protocol === referer .protocol &&
             this .URL .hostname === referer .hostname &&
             this .URL .port     === referer .port &&
             this .URL .pathname === referer .pathname &&
             this .URL .hash)
         {
            this .bindViewpoint (decodeURIComponent (this .URL .hash .substring (1)));
            return;
         }
      }

      if (this .foreign)
      {
         // Handle target

         if (this .target .length && this .target !== "_self")
            return this .foreign (this .URL .href, this .target);

         // Handle well known foreign content depending on extension or if path looks like directory.

         if (this .URL .protocol !== "data:" && this .URL .href .match (/\.(?:html|htm|xhtml)$/))
            return this .foreign (this .URL .href, this .target);
      }

      // Load URL async

      const
         options  = { cache: this .node .getCache () ? "default" : "reload", signal: this .controller .signal },
         response = this .checkResponse (await fetch (this .URL, options)),
         mimeType = response .headers .get ("content-type") ?.replace (/;.*$/, "");

      if (this .foreign)
      {
         // console .log (mimeType);

         if (foreignMimeType .has (mimeType))
            return this .foreign (this .URL .href, this .target);
      }

      await this .callback (FileLoader_$.ungzip (await response .arrayBuffer ()), this .URL);
   },
   checkResponse (response)
   {
      if (response .ok)
         return response;

      throw Error (response .statusText || response .status);
   },
   loadDocumentError (error)
   {
      // Output error.

      this .printError (error);

      // Try to load next URL.

      if (this .url .length)
      {
         this .loadDocumentAsync (String (this .url .shift ()))
            .catch (this .loadDocumentError .bind (this));
      }
      else
      {
         this .callback (null);
      }
   },
   printError (error)
   {
      const typeName = this .node instanceof X3DWorld/* default */.A ? "" : ` of ${this .node .getTypeName ()}`;

      if (this .URL .protocol === "data:")
         console .error (`Couldn't load data URL${typeName}.`, error);
      else
         console .error (`Couldn't load URL '${FileLoader_$.try (() => decodeURI (this .URL)) ?? this .URL}'${typeName}.`, error);
   },
});

for (const key of Object .keys (FileLoader .prototype))
   Object .defineProperty (FileLoader .prototype, key, { enumerable: false });

const FileLoader_default_ = FileLoader;
;

/* harmony default export */ const InputOutput_FileLoader = (Namespace/* default */.A .add ("FileLoader", FileLoader_default_));

/***/ },

/***/ 361
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(7910);
/* harmony import */ var _x_ite_Namespace_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(6334);
/* provided dependency */ var libtess = __webpack_require__(3921);


const Triangle3 =
{
   /**
    *
    * @param {Vector3} a first point of triangle
    * @param {Vector3} b second point of triangle
    * @param {Vector3} c third point of triangle
    * @returns
    */
   area: (() =>
   {
      const
         B = new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A (),
         C = new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A ();

      return function (a, b, c)
      {
         return B .assign (b) .subtract (a) .cross (C .assign (c) .subtract (a)) .norm () / 2;
      };
   })(),
   /**
    *
    * @param {Vector3} a first point of triangle
    * @param {Vector3} b second point of triangle
    * @param {Vector3} c third point of triangle
    * @param {Vector3} normal resulting normal
    * @returns
    */
   normal (a, b, c, normal)
   {
      const
         x1 = c .x - b .x,
         y1 = c .y - b .y,
         z1 = c .z - b .z,
         x2 = a .x - b .x,
         y2 = a .y - b .y,
         z2 = a .z - b .z;

      normal .set (y1 * z2 - z1 * y2,
                   z1 * x2 - x1 * z2,
                   x1 * y2 - y1 * x2);

      return normal .normalize ();
   },
   /**
    *
    * @param {Vector3} a first point of quad
    * @param {Vector3} b second point of quad
    * @param {Vector3} c third point of quad
    * @param {Vector3} d third point of quad
    * @param {Vector3} normal resulting normal
    * @returns
    */
   quadNormal (a, b, c, d, normal)
   {
      const
         x1 = c .x - a .x,
         y1 = c .y - a .y,
         z1 = c .z - a .z,
         x2 = d .x - b .x,
         y2 = d .y - b .y,
         z2 = d .z - b .z;

      normal .set (y1 * z2 - z1 * y2,
                   z1 * x2 - x1 * z2,
                   x1 * y2 - y1 * x2);

      return normal .normalize ();
   },
   triangulatePolygon: (() =>
   {
      // Function called for each vertex of tesselator output.

      function vertexCallback (index, triangles)
      {
         triangles .push (index);
      }

      // Required in case of a combine, otherwise an empty array is returned.

      function combineCallback (coords, data, weight)
      {
         return data [0];
      }

      const tessy = new libtess .GluTesselator ();

      tessy .gluTessCallback (libtess .gluEnum .GLU_TESS_VERTEX_DATA,  vertexCallback);
      tessy .gluTessCallback (libtess .gluEnum .GLU_TESS_COMBINE,      combineCallback);
      tessy .gluTessProperty (libtess .gluEnum .GLU_TESS_WINDING_RULE, libtess .windingRule .GLU_TESS_WINDING_ODD);

      return function (polygon, triangles)
      {
         tessy .gluTessBeginPolygon (triangles);
         tessy .gluTessBeginContour ();

         for (const point of polygon)
            tessy .gluTessVertex (point, point .index);

         tessy .gluTessEndContour ();
         tessy .gluTessEndPolygon ();

         // Return array of indices.
         return triangles;
      };
   })(),
   triangulateConvexPolygon (vertices, triangles)
   {
      // Fallback: Very simple triangulation for convex polygons.

      const numVertices_1 = vertices .length - 1;

      for (let i = 1; i < numVertices_1; ++ i)
         triangles .push (vertices [0], vertices [i], vertices [i + 1]);

      return triangles;
   },
};

const __default__ = Triangle3;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_x_ite_Namespace_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .add ("Triangle3", __default__));

/***/ },

/***/ 717
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Fields_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(3515);
/* harmony import */ var _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(2914);
/* harmony import */ var _Base_FieldDefinitionArray_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(9572);
/* harmony import */ var _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(8450);
/* harmony import */ var _X3DViewpointNode_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(5282);
/* harmony import */ var _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(4946);
/* harmony import */ var _standard_Math_Geometry_Camera_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(2941);
/* harmony import */ var _standard_Math_Numbers_Vector2_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(2005);
/* harmony import */ var _standard_Math_Numbers_Matrix4_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(2597);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(6334);










function Viewpoint (executionContext)
{
   _X3DViewpointNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .call (this, executionContext);

   this .addType (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .Viewpoint);

   // Units

   this ._position         .setUnit ("length");
   this ._centerOfRotation .setUnit ("length");
   this ._fieldOfView      .setUnit ("angle");

   // Private properties

   this .projectionMatrix = new _standard_Math_Numbers_Matrix4_js__WEBPACK_IMPORTED_MODULE_8__/* ["default"] */ .A ();
}

Object .assign (Object .setPrototypeOf (Viewpoint .prototype, _X3DViewpointNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .prototype),
{
   getRelativeTransformation (fromViewpointNode)
   {
      const relative = _X3DViewpointNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .prototype .getRelativeTransformation .call (this, fromViewpointNode);

      if (fromViewpointNode .constructor === this .constructor)
         relative .fieldOfView = fromViewpointNode .getUserFieldOfView ();

      return relative;
   },
   setInterpolators (fromViewpointNode, relative)
   {
      if (fromViewpointNode .constructor === this .constructor)
      {
         const scale = relative .fieldOfView / this .getUserFieldOfView ();

         this .fieldOfViewScaleInterpolator ._keyValue = new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFFloat (scale, this ._fieldOfViewScale .getValue ());

         this ._fieldOfViewScale = scale;
      }
      else
      {
         this .fieldOfViewScaleInterpolator ._keyValue = new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFFloat (this ._fieldOfViewScale .getValue (), this ._fieldOfViewScale .getValue ());

         this ._fieldOfViewScale = this ._fieldOfViewScale .getValue ();
      }
   },
   getLogarithmicDepthBuffer ()
   {
      return false;
   },
   getFieldOfView ()
   {
      const fov = this ._fieldOfView .getValue ();

      return fov > 0 && fov < Math .PI ? fov : Math .PI / 4;
   },
   setFieldOfView (value)
   {
      this ._fieldOfView = value;
   },
   getUserFieldOfView ()
   {
      const fov = this ._fieldOfView .getValue () * this ._fieldOfViewScale .getValue ();

      return fov > 0 && fov < Math .PI ? fov : Math .PI / 4;
   },
   getScreenScale (point, viewport, screenScale)
   {
      // Returns the screen scale in meter/pixel for on pixel.

      const
         width  = viewport [2],
         height = viewport [3],
         pose   = this .getBrowser () .getPose ();

      // MDN says fov can be determined from projectionMatrix.
      // https://developer.mozilla.org/en-US/docs/Web/API/WebXR_Device_API/Perspective
      const fov1_2 = pose
         ? 1 / pose .views [0] .projectionMatrix [5]
         : Math .tan (this .getUserFieldOfView () / 2);

      let size = Math .abs (point .z) * fov1_2 * 2;

      if (width > height)
         size /= height;
      else
         size /= width;

      return screenScale .set (size, size, size);
   },
   getViewportSize: (() =>
   {
      const viewportSize = new _standard_Math_Numbers_Vector2_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A ();

      return function (viewport, nearValue)
      {
         // Returns viewport size in meters.

         const
            width  = viewport [2],
            height = viewport [3],
            size   = nearValue * Math .tan (this .getUserFieldOfView () / 2) * 2,
            aspect = width / height;

         if (aspect > 1)
            return viewportSize .set (size * aspect, size);

         return viewportSize .set (size, size / aspect);
      };
   })(),
   getLookAtDistance (bbox)
   {
      return (bbox .size .norm () / 2) / Math .tan (this .getUserFieldOfView () / 2);
   },
   getProjectionMatrixWithLimits (nearValue, farValue, viewport)
   {
      return _standard_Math_Geometry_Camera_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .perspective (this .getUserFieldOfView (), nearValue, farValue, viewport [2], viewport [3], this .projectionMatrix);
   },
});

Object .defineProperties (Viewpoint,
{
   ... _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .getStaticProperties ("Viewpoint", "Navigation", 1, "children", "2.0"),
   fieldDefinitions:
   {
      value: new _Base_FieldDefinitionArray_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A ([
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .inputOutput, "metadata",          new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFNode ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .inputOnly,   "set_bind",          new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFBool ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .inputOutput, "description",       new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFString ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .inputOutput, "position",          new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFVec3f (0, 0, 10)),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .inputOutput, "orientation",       new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFRotation ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .inputOutput, "centerOfRotation",  new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFVec3f ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .inputOutput, "fieldOfView",       new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFFloat (0.785398)),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .inputOutput, "nearDistance",      new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFFloat (-1)),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .inputOutput, "farDistance",       new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFFloat (-1)),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .inputOutput, "viewAll",           new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFBool ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .inputOutput, "jump",              new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFBool (true)),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .inputOutput, "retainUserOffsets", new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFBool ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .outputOnly,  "isBound",           new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFBool ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .outputOnly,  "bindTime",          new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFTime ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .inputOutput, "navigationInfo",    new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFNode ()),
      ]),
      enumerable: true,
   },
});

const __default__ = Viewpoint;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_9__/* ["default"] */ .A .add ("Viewpoint", __default__));

/***/ },

/***/ 857
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Color3_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(2028);
/* harmony import */ var _x_ite_Namespace_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(6334);


const
   _r = Symbol .for ("X_ITE.Color3.r"),
   _g = Symbol .for ("X_ITE.Color3.g"),
   _b = Symbol .for ("X_ITE.Color3.b"),
   _a = Symbol ();

// glTF sometimes allows color values greater than 1.
// See: https://github.com/KhronosGroup/glTF/blob/main/extensions/2.0/Khronos/KHR_materials_specular/README.md
// See: https://raw.githubusercontent.com/KhronosGroup/glTF-Sample-Assets/master/Models/SpecularTest/glTF/SpecularTest.gltf

function Color4 (r = 0, g = r, b = g, a = b)
{
   this [_r] = r;
   this [_g] = g;
   this [_b] = b;
   this [_a] = a;
}

Object .assign (Color4 .prototype,
{
   *[Symbol .iterator] ()
   {
      yield this [_r];
      yield this [_g];
      yield this [_b];
      yield this [_a];
   },
   copy ()
   {
      const copy = Object .create (Color4 .prototype);
      copy [_r] = this [_r];
      copy [_g] = this [_g];
      copy [_b] = this [_b];
      copy [_a] = this [_a];
      return copy;
   },
   assign (color)
   {
      this [_r] = color [_r];
      this [_g] = color [_g];
      this [_b] = color [_b];
      this [_a] = color [_a];
      return this;
   },
   set (r = 0, g = r, b = g, a = b)
   {
      this [_r] = r;
      this [_g] = g;
      this [_b] = b;
      this [_a] = a;
      return this;
   },
   equals (color)
   {
      return this [_r] === color [_r] &&
             this [_g] === color [_g] &&
             this [_b] === color [_b] &&
             this [_a] === color [_a];
   },
   getHSVA (result)
   {
      _Color3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .prototype .getHSV .call (this, result);

      result [3] = this [_a];

      return result;
   },
   setHSVA (h, s, v, a)
   {
      _Color3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .prototype .setHSV .call (this, h, s, v);

      this [_a] = a;

      return this;
   },
   linearToSRGB (color = new Color4 ())
   {
      _Color3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .prototype .linearToSRGB .call (this, color);

      color [_a] = this [_a];

      return color;
   },
   sRGBToLinear (color = new Color4 ())
   {
      _Color3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .prototype .sRGBToLinear .call (this, color);

      color [_a] = this [_a];

      return color;
   },
   toString ()
   {
      return this [_r] + " " +
             this [_g] + " " +
             this [_b] + " " +
             this [_a];
   },
});

for (const key of Object .keys (Color4 .prototype))
   Object .defineProperty (Color4 .prototype, key, { enumerable: false });

const r = {
   get () { return this [_r]; },
   set (value) { this [_r] = value; },
};

const g = {
   get () { return this [_g]; },
   set (value) { this [_g] = value; },
};

const b = {
   get () { return this [_b]; },
   set (value) { this [_b] = value; },
};

const a = {
   get () { return this [_a]; },
   set (value) { this [_a] = value; },
};

Object .defineProperties (Color4 .prototype,
{
   length: { value: 4 },
   0: r,
   1: g,
   2: b,
   3: a,
   r: Object .assign ({ enumerable: true }, r),
   g: Object .assign ({ enumerable: true }, g),
   b: Object .assign ({ enumerable: true }, b),
   a: Object .assign ({ enumerable: true }, a),
});

Object .assign (Color4,
{
   TRANSPARENT: Object .freeze (new Color4 ()),
   BLACK: Object .freeze (new Color4 (0, 0, 0, 1)),
   WHITE: Object .freeze (new Color4 (1)),
   HSVA (h, s, v, a)
   {
      const color = Object .create (this .prototype);
      color .setHSVA (h, s, v, a);
      return color;
   },
   lerp (a, b, t, r)
   {
      // Linearely interpolate in HSVA space between source color @a a and destination color @a b by an amount of @a t.
      // Source and destination color must be in HSVA space. The resulting HSVA color is stored in @a r.
      const aa = a [3];
      _Color3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .lerp (a, b, t, r);
      r [3] = aa + t * (b [3] - aa);
      return r;
   },
});

const __default__ = Color4;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_x_ite_Namespace_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .add ("Color4", __default__));

/***/ },

/***/ 914
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  A: () => (/* binding */ Grouping_X3DBoundedObject)
});

// EXTERNAL MODULE: ./src/x_ite/Fields.js + 15 modules
var Fields = __webpack_require__(3515);
// EXTERNAL MODULE: ./src/x_ite/Components/Core/X3DNode.js
var X3DNode = __webpack_require__(8450);
// EXTERNAL MODULE: ./src/x_ite/Base/X3DConstants.js
var X3DConstants = __webpack_require__(4946);
// EXTERNAL MODULE: ./src/x_ite/Base/X3DFieldDefinition.js
var X3DFieldDefinition = __webpack_require__(2914);
// EXTERNAL MODULE: ./src/x_ite/Base/FieldDefinitionArray.js
var FieldDefinitionArray = __webpack_require__(9572);
// EXTERNAL MODULE: ./src/x_ite/Components/Core/X3DChildNode.js
var X3DChildNode = __webpack_require__(266);
// EXTERNAL MODULE: ./src/x_ite/Rendering/TraverseType.js
var TraverseType = __webpack_require__(5465);
// EXTERNAL MODULE: ./src/standard/Math/Numbers/Matrix4.js
var Matrix4 = __webpack_require__(2597);
// EXTERNAL MODULE: ./src/standard/Math/Geometry/Box3.js
var Box3 = __webpack_require__(6524);
// EXTERNAL MODULE: ./src/standard/Math/Numbers/Vector3.js
var Vector3 = __webpack_require__(7910);
// EXTERNAL MODULE: ./src/x_ite/Namespace.js
var Namespace = __webpack_require__(6334);
;// ./src/x_ite/Browser/Grouping/X3DBBoxNode.js











function X3DBBoxNode (executionContext, boundedObject)
{
   X3DChildNode/* default */.A .call (this, executionContext);

   // Private properties

   this .boundedObject = boundedObject;
   this .bboxShape     = this .getBrowser () .getBBoxShape ();
}

Object .assign (Object .setPrototypeOf (X3DBBoxNode .prototype, X3DChildNode/* default */.A .prototype),
{
   getMatrix: (() =>
   {
      const
         bbox    = new Box3/* default */.A (),
         matrix  = new Matrix4/* default */.A (),
         epsilon = new Vector3/* default */.A (1e-6);

      return function ()
      {
         this .boundedObject .getBBox (bbox);

         const
            browser    = this .getBrowser (),
            max        = browser .getRenderingProperty ("ContentScale") === 1 ? Vector3/* default */.A .ZERO : epsilon,
            bboxSize   = bbox .size .max (max),
            bboxCenter = bbox .center;

         return matrix .set (bboxCenter, null, bboxSize);
      };
   })(),
   getShapes (shapes, parentModelMatrix)
   {
      const modelMatrix = parentModelMatrix .copy () .multLeft (this .getMatrix ());

      return this .bboxShape .getShapes (shapes, modelMatrix);
   },
   traverse (type, renderObject)
   {
      if (type === TraverseType/* default */.A .PICKING)
         return;

      const modelViewMatrix = renderObject .getModelViewMatrix ();

      modelViewMatrix .push ();
      modelViewMatrix .multLeft (this .getMatrix ());

      this .bboxShape .traverse (type, renderObject);

      modelViewMatrix .pop ();
   },
});

Object .defineProperties (X3DBBoxNode,
{
   ... X3DNode/* default */.A .getStaticProperties ("X3DBBoxNode", "Grouping", 1, "children", "2.0"),
   fieldDefinitions:
   {
      value: new FieldDefinitionArray/* default */.A ([
         new X3DFieldDefinition/* default */.A (X3DConstants/* default */.A .inputOutput, "metadata", new Fields/* default */.A .SFNode ()),
      ]),
      enumerable: true,
   },
});

const __default__ = X3DBBoxNode;
;

/* harmony default export */ const Grouping_X3DBBoxNode = (Namespace/* default */.A .add ("X3DBBoxNode", __default__));
;// ./src/x_ite/Components/Grouping/X3DBoundedObject.js







function X3DBoundedObject (executionContext)
{
   this .addType (X3DConstants/* default */.A .X3DBoundedObject);

   this .addChildObjects (X3DConstants/* default */.A .outputOnly, "hidden",           new Fields/* default */.A .SFBool (),
                          X3DConstants/* default */.A .outputOnly, "display",          new Fields/* default */.A .SFBool (true),
                          X3DConstants/* default */.A .outputOnly, "transformSensors", new Fields/* default */.A .SFTime ());

   // Units

   this ._bboxSize   .setUnit ("length");
   this ._bboxCenter .setUnit ("length");

   // Private properties

   this .childBBox            = new Box3/* default */.A (); // Must be unique for each X3DBoundedObject.
   this .transformSensorNodes = new Set ();
}

Object .assign (X3DBoundedObject .prototype,
{
   childBBox: new Box3/* default */.A (), // X3DExecutionContext needs this.
   initialize ()
   {
      this ._hidden  .addInterest ("set_visible_and_hidden__", this);
      this ._visible .addInterest ("set_visible_and_hidden__", this);

      this .set_visible_and_hidden__ ();
   },
   isVisible ()
   {
      return this ._display .getValue ();
   },
   isHidden ()
   {
      return this ._hidden .getValue ();
   },
   setHidden (value)
   {
      if (value === this ._hidden .getValue ())
         return;

      this ._hidden = value;
   },
   isDefaultBBoxSize: (() =>
   {
      const defaultBBoxSize = new Vector3/* default */.A (-1);

      return function ()
      {
         return this ._bboxSize .getValue () .equals (defaultBBoxSize);
      };
   })(),
   isBBoxVisible ()
   {
      return this ._bboxDisplay .getValue ();
   },
   getBBox (nodes, bbox, shadows)
   {
      // Must be unique for each X3DBoundedObject.
      const childBBox = this .childBBox;

      // Add bounding boxes.

      bbox .set ();

      for (const node of nodes)
         bbox .add (node .getBBox ?.(childBBox, shadows) ?? childBBox .set ());

      return bbox;
   },
   getBBoxNode ()
   {
      return this .bboxNode ??= (() =>
      {
         const bboxNode = new Grouping_X3DBBoxNode (this .getExecutionContext (), this);

         bboxNode .setPrivate (true);
         bboxNode .setup ();

         return bboxNode;
      })();
   },
   addTransformSensor (transformSensorNode)
   {
      this .transformSensorNodes .add (transformSensorNode);

      this ._transformSensors = this .getBrowser () .getCurrentTime ();
   },
   removeTransformSensor (transformSensorNode)
   {
      this .transformSensorNodes .delete (transformSensorNode);

      this ._transformSensors = this .getBrowser () .getCurrentTime ();
   },
   getTransformSensors ()
   {
      return this .transformSensorNodes;
   },
   set_visible_and_hidden__ ()
   {
      const value = this ._visible .getValue () && !this ._hidden .getValue ();

      if (value === this ._display .getValue ())
         return;

      this ._display = value;
   },
   dispose () { },
});

Object .defineProperties (X3DBoundedObject, X3DNode/* default */.A .getStaticProperties ("X3DBoundedObject", "Grouping", 1));

const X3DBoundedObject_default_ = X3DBoundedObject;
;

/* harmony default export */ const Grouping_X3DBoundedObject = (Namespace/* default */.A .add ("X3DBoundedObject", X3DBoundedObject_default_));

/***/ },

/***/ 986
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Base_X3DInfoArray_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(3046);
/* harmony import */ var _UnitInfo_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(1195);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(6334);



function UnitInfoArray (values = [ ])
{
   return _Base_X3DInfoArray_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .call (this, Array .from (values, value => [value .category, value]), _UnitInfo_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A);
}

Object .setPrototypeOf (UnitInfoArray .prototype, _Base_X3DInfoArray_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .prototype);

for (const key of Object .keys (UnitInfoArray .prototype))
   Object .defineProperty (UnitInfoArray .prototype, key, { enumerable: false });

Object .defineProperties (UnitInfoArray,
{
   typeName:
   {
      value: "UnitInfoArray",
      enumerable: true,
   },
});

const __default__ = UnitInfoArray;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .add ("UnitInfoArray", __default__));

/***/ },

/***/ 1047
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(7910);
/* harmony import */ var _x_ite_Namespace_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(6334);


function Line3 (point = _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .ZERO, direction = _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .Z_AXIS)
{
   this .point     = new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A ();
   this .direction = new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A ();

   this .set (point, direction);
}

Object .assign (Line3 .prototype,
{
   copy ()
   {
      const copy = Object .create (Line3 .prototype);

      copy .point     = this .point .copy ();
      copy .direction = this .direction .copy ();

      return copy;
   },
   assign (line)
   {
      this .point     .assign (line .point);
      this .direction .assign (line .direction);

      return this;
   },
   equals (line)
   {
      return this .point .equals (line .point) && this .direction .equals (line .direction);
   },
   set (point = _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .ZERO, direction = _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .Z_AXIS)
   {
      this .point     .assign (point);
      this .direction .assign (direction);
      return this;
   },
   setPoints (point1, point2)
   {
      this .point .assign (point1);
      this .direction .assign (point2) .subtract (point1) .normalize ();
      return this;
   },
   multMatrixLine (matrix)
   {
      matrix .multMatrixVec (this .point);
      matrix .multMatrixDir (this .direction) .normalize ();
      return this;
   },
   multLineMatrix (matrix)
   {
      matrix .multVecMatrix (this .point);
      matrix .multDirMatrix (this .direction) .normalize ();
      return this;
   },
   getClosestPointToPoint (point, result = new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A ())
   {
      const
         r = result .assign (point) .subtract (this .point),
         d = r .dot (this .direction);

      return result .assign (this .direction) .multiply (d) .add (this .point);
   },
   getClosestPointToLine: (() =>
   {
      const u = new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A ();

      return function (line, point)
      {
         const
            { point: p1, direction: d1 } = this,
            { point: p2, direction: d2 } = line;

         let t = d1 .dot (d2);

         if (Math .abs (t) >= 1)
            return false;  // lines are parallel

         u .assign (p2) .subtract (p1);

         t = (u .dot (d1) - t * u .dot (d2)) / (1 - t * t);

         point .assign (d1) .multiply (t) .add (p1);
         return true;
      };
   })(),
   getPerpendicularVectorToPoint: (() =>
   {
      const t = new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A ();

      return function (point, result = new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A ())
      {
         result .assign (this .point) .subtract (point);

         return result .subtract (t .assign (this .direction) .multiply (result .dot (this .direction)));
      };
   })(),
   getPerpendicularVectorToLine: (() =>
   {
      const
         diff   = new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A (),
         proj   = new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A (),
         d      = new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A (),
         point1 = new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A ();

      return function (line, result = new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A ())
      {
         const
            { point: p1, direction: d1 } = this,
            { point: p2, direction: d2 } = line;

         const t = d1 .dot (d2);

         if (Math .abs (t) >= 1)
         {
            // Lines are parallel

            diff .assign (p2) .subtract (p1);
            proj .assign (d1) .multiply (diff .dot (d1) / d1 .dot (d1));

            return proj .subtract (diff);
         }

         d .assign (p1) .subtract (p2);

         const
            re1 = d .dot (d1),
            re2 = d .dot (d2),
            e12 = d1 .dot (d2),
            E12 = e12 * e12;

         const
            a =  (re1 - re2 * e12) / (1 - E12),
            b = -(re2 - re1 * e12) / (1 - E12);

         point1 .assign (d1) .multiply (a);
         result .assign (d2) .multiply (b);

         return result .subtract (point1) .add (d);
      };
   })(),
   intersectsTriangle: (() =>
   {
      const
         pvec = new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A (),
         tvec = new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A ();

      return function (A, B, C, uvt)
      {
         // Find vectors for two edges sharing vert0.
         const
            edge1 = B .subtract (A),
            edge2 = C .subtract (A);

         // Begin calculating determinant - also used to calculate U parameter.
         pvec .assign (this .direction) .cross (edge2);

         // If determinant is near zero, ray lies in plane of triangle.
         const det = edge1 .dot (pvec);

         // Non culling intersection.

         if (det === 0)
            return false;

            const inv_det = 1 / det;

         // Calculate distance from vert0 to ray point.
         tvec .assign (this .point) .subtract (A);

         // Calculate U parameter and test bounds.
         const u = tvec .dot (pvec) * inv_det;

         if (u < 0 || u > 1)
            return false;

         // Prepare to test V parameter.
         const qvec = tvec .cross (edge1);

         // Calculate V parameter and test bounds.
         const v = this .direction .dot (qvec) * inv_det;

         if (v < 0 || u + v > 1)
            return false;

         //let u = edge2 .dot (qvec) * inv_det;

         uvt .u = 1 - u - v;
         uvt .v = u;
         uvt .t = v;

         return true;
      };
   })(),
   toString ()
   {
      return `${this .point}, ${this .direction}`;
   },
});

Object .assign (Line3,
{
   Points (point1, point2)
   {
      const line = Object .create (Line3 .prototype);
      line .point     = point1 .copy ();
      line .direction = point2 .copy () .subtract (point1) .normalize ();
      return line;
   },
});

const __default__ = Line3;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_x_ite_Namespace_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .add ("Line3", __default__));

/***/ },

/***/ 1195
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Base_X3DObject_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(7092);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(6334);


function UnitInfo (category, name, conversionFactor)
{
   Object .defineProperties (this,
   {
      category: { value: category, enumerable: true },
      name: { value: name, enumerable: true },
      conversionFactor: { value: conversionFactor, enumerable: true },
   });
}

Object .assign (Object .setPrototypeOf (UnitInfo .prototype, _Base_X3DObject_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .prototype),
{
   toVRMLStream (generator)
   {
      generator .Indent ();
      generator .string += "UNIT";
      generator .Space ();
      generator .string += this .category;
      generator .Space ();
      generator .string += this .name;
      generator .Space ();
      generator .string += this .conversionFactor;
   },
   toXMLStream (generator)
   {
      generator .openTag ("unit");
      generator .attribute ("category",         this .category);
      generator .attribute ("name",             this .name);
      generator .attribute ("conversionFactor", this .conversionFactor);
      generator .closeTag ("unit");
   },
   toJSONStream (generator, _throw)
   {
      if (this .conversionFactor === 1)
         throw new Error ("conversionFactor is 1");

      generator .beginObject ("", false);
      generator .stringProperty ("@category",         this .category, false);
      generator .stringProperty ("@name",             this .name);
      generator .numberProperty ("@conversionFactor", this .conversionFactor);
      generator .endObject ();
   },
});

for (const key of Object .keys (UnitInfo .prototype))
   Object .defineProperty (UnitInfo .prototype, key, { enumerable: false });

Object .defineProperty (UnitInfo .prototype, "conversion_factor",
{
   get () { return this .conversionFactor; },
});

Object .defineProperties (UnitInfo,
{
   typeName:
   {
      value: "UnitInfo",
      enumerable: true,
   },
});

const __default__ = UnitInfo;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .add ("UnitInfo", __default__));

/***/ },

/***/ 1224
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  A: () => (/* binding */ Numbers_Matrix3)
});

// EXTERNAL MODULE: ./src/standard/Math/Numbers/Vector2.js
var Vector2 = __webpack_require__(2005);
// EXTERNAL MODULE: ./src/standard/Math/Numbers/Vector3.js
var Vector3 = __webpack_require__(7910);
// EXTERNAL MODULE: ./src/x_ite/Namespace.js
var Namespace = __webpack_require__(6334);
;// ./src/standard/Math/Numbers/Matrix2.js


function Matrix2 (... args)
{
   if (args .length)
   {
      for (let i = 0; i < 4; ++ i)
         this [i] = args [i];
   }
   else
   {
      this .identity ();
   }
}

Object .assign (Matrix2 .prototype,
{
   *[Symbol .iterator] ()
   {
      for (let i = 0; i < 4; ++ i)
         yield this [i];
   },
   copy ()
   {
      const copy = Object .create (Matrix2 .prototype);

      for (let i = 0; i < 4; ++ i)
         copy [i] = this [i];

      return copy;
   },
   assign (matrix)
   {
      for (let i = 0; i < 4; ++ i)
         this [i] = matrix [i];

      return this;
   },
   equals (matrix)
   {
      return this [0] === matrix [0] &&
             this [1] === matrix [1] &&
             this [2] === matrix [2] &&
             this [3] === matrix [3];
   },
   set1 (r, c, value)
   {
      this [r * this .order + c] = value;
   },
   get1 (r, c)
   {
      return this [r * this .order + c];
   },
   set ()
   {
      switch (arguments .length)
      {
         case 0:
         {
            this .identity ();
            break;
         }
         case 4:
         {
            for (let i = 0; i < 4; ++ i)
               this [i] = arguments [i];

            break;
         }
      }

      return this;
   },
   determinant1 ()
   {
      return this [0];
   },
   determinant ()
   {
      const { 0: m0, 1: m1, 2: m2, 3: m3 } = this;

      return m0 * m3 - m1 * m2;
   },
   transpose ()
   {
      const tmp = this [1];

      this [1] = this [2];
      this [2] = tmp;

      return this;
   },
   inverse ()
   {
      const
         { 0: A, 1: B, 2: C, 3: D } = this,
         d = A * D - B * C;

      // if (d === 0) ... determinant is zero.

      this [0] =  D / d;
      this [1] = -B / d;
      this [2] = -C / d;
      this [3] =  A / d;

      return this;
   },
   multLeft (matrix)
   {
      const
         { 0: a0, 1: a1, 2: a2, 3: a3 } = this,
         { 0: b0, 1: b1, 2: b2, 3: b3 } = matrix;

      this [0] = a0 * b0 + a2 * b1;
      this [1] = a1 * b0 + a3 * b1;
      this [2] = a0 * b2 + a2 * b3;
      this [3] = a1 * b2 + a3 * b3;

      return this;
   },
   multRight (matrix)
   {
      const
         { 0: a0, 1: a1, 2: a2, 3: a3 } = this,
         { 0: b0, 1: b1, 2: b2, 3: b3 } = matrix;

      this [0] = b0 * a0 + b2 * a1;
      this [1] = b1 * a0 + b3 * a1;
      this [2] = b0 * a2 + b2 * a3;
      this [3] = b1 * a2 + b3 * a3;

      return this;
   },
   multVecMatrix (vector)
   {
      if (typeof vector === "number")
      {
         const
            x = vector,
            w = x * this [1] + this [3];

         return (x * this [0] + this [2]) / w;
      }
      else
      {
         const { x, y } = vector;

         vector .x = x * this [0] + y * this [2];
         vector .y = x * this [1] + y * this [3];

         return vector;
      }
   },
   multMatrixVec (vector)
   {
      if (typeof vector === "number")
      {
         const
            x = vector,
            w = x * this [2] + this [3];

         return (x * this [0] + this [1]) / w;
      }
      else
      {
         const { x, y } = vector;

         vector .x = x * this [0] + y * this [1];
         vector .y = x * this [2] + y * this [3];

         return vector;
      }
   },
   identity ()
   {
      this [0] = 1;
      this [1] = 0;
      this [2] = 0;
      this [3] = 1;
   },
   toString ()
   {
      return Array .prototype .join .call (this, " ");
   },
});

for (const key of Object .keys (Matrix2 .prototype))
   Object .defineProperty (Matrix2 .prototype, key, { enumerable: false });

Object .defineProperties (Matrix2 .prototype,
{
   order: { value: 2 },
   length: { value: 4 },
   x:
   {
      get: (() =>
      {
         const vector = new Vector2/* default */.A ();

         return function () { return vector .set (this [0], this [1]); };
      })(),
   },
   y:
   {
      get: (() =>
      {
         const vector = new Vector2/* default */.A ();

         return function () { return vector .set (this [2], this [3]); };
      })(),
   },
   xAxis:
   {
      get () { return this [0]; },
   },
   origin:
   {
      get () { return this [2]; },
   },
   submatrix:
   {
      get () { return this [0]; },
   },
});

Object .assign (Matrix2,
{
   IDENTITY: Object .freeze (new Matrix2 ()),
});

const __default__ = Matrix2;
;

/* harmony default export */ const Numbers_Matrix2 = (Namespace/* default */.A .add ("Matrix2", __default__));
// EXTERNAL MODULE: ./src/standard/Math/Algorithms/eigen_decomposition.js
var eigen_decomposition = __webpack_require__(4682);
;// ./src/standard/Math/Numbers/Matrix3.js





function Matrix3 (... args)
{
   if (args .length)
   {
      for (let i = 0; i < 9; ++ i)
         this [i] = args [i];
   }
   else
   {
      this .identity ();
   }
}

Object .assign (Matrix3 .prototype,
{
   *[Symbol .iterator] ()
   {
      for (let i = 0; i < 9; ++ i)
         yield this [i];
   },
   copy ()
   {
      const copy = Object .create (Matrix3 .prototype);

      for (let i = 0; i < 9; ++ i)
         copy [i] = this [i];

      return copy;
   },
   assign (matrix)
   {
      for (let i = 0; i < 9; ++ i)
         this [i] = matrix [i];

      return this;
   },
   equals (matrix)
   {
      return this [0] === matrix [0] &&
             this [1] === matrix [1] &&
             this [2] === matrix [2] &&
             this [3] === matrix [3] &&
             this [4] === matrix [4] &&
             this [5] === matrix [5] &&
             this [6] === matrix [6] &&
             this [7] === matrix [7] &&
             this [8] === matrix [8];
   },
   set1 (r, c, value)
   {
      this [r * this .order + c] = value;

      return this;
   },
   get1 (r, c)
   {
      return this [r * this .order + c];
   },
   set: (() =>
   {
      const invCenter = new Vector2/* default */.A ();

      return function (translation, rotation, scale, scaleOrientation, center)
      {
         this .identity ();

         switch (arguments .length)
         {
            case 1:
            {
               if (translation && !translation .equals (Vector2/* default */.A .ZERO))
                  this .translate (translation);

               break;
            }
            case 2:
            {
               if (translation && !translation .equals (Vector2/* default */.A .ZERO))
                  this .translate (translation);

               if (rotation)
                  this .rotate (rotation);

               break;
            }
            case 3:
            {
               if (translation && !translation .equals (Vector2/* default */.A .ZERO))
                  this .translate (translation);

               if (rotation)
                  this .rotate (rotation);

               if (scale && !scale .equals (Vector2/* default */.A .ONE))
                  this .scale  (scale);

               break;
            }
            case 4:
            {
               if (translation && !translation .equals (Vector2/* default */.A .ZERO))
                  this .translate (translation);

               if (rotation)
                  this .rotate (rotation);

               if (scale && !scale .equals (Vector2/* default */.A .ONE))
               {
                  if (scaleOrientation)
                  {
                     this .rotate (scaleOrientation);
                     this .scale (scale);
                     this .rotate (-scaleOrientation);
                  }
                  else
                  {
                     this .scale (scale);
                  }
               }

               break;
            }
            case 5:
            {
               // P' = T * C * R * SR * S * -SR * -C * P
               if (translation && !translation .equals (Vector2/* default */.A .ZERO))
                  this .translate (translation);

               const hasCenter = center && !center .equals (Vector2/* default */.A .ZERO);

               if (hasCenter)
                  this .translate (center);

               if (rotation)
                  this .rotate (rotation);

               if (scale && !scale .equals (Vector2/* default */.A .ONE))
               {
                  if (scaleOrientation)
                  {
                     this .rotate (scaleOrientation);
                     this .scale (scale);
                     this .rotate (-scaleOrientation);
                  }
                  else
                  {
                     this .scale (scale);
                  }
               }

               if (hasCenter)
                  this .translate (invCenter .assign (center) .negate ());

               break;
            }
            case 9:
            {
               for (let i = 0; i < 9; ++ i)
                  this [i] = arguments [i];

               break;
            }
         }

         return this;
      };
   })(),
   get: (() =>
   {
      const c = new Vector2/* default */.A ();

      return function (translation, rotation, scale, scaleOrientation, center)
      {
         switch (arguments .length)
         {
            case 1:
            {
               translation .set (this [6], this [7]);
               break;
            }
            case 2:
            case 3:
            case 4:
            {
               this .factor (translation, rotation, scale, scaleOrientation);
               break;
            }
            case 5:
            {
               if (center)
               {
                  m .set (c .assign (center) .negate ());
                  m .multLeft (this);
                  m .translate (center);
                  m .get (translation, rotation, scale, scaleOrientation);
               }
               else
               {
                  this .factor (translation, rotation, scale, scaleOrientation);
               }

               break;
            }
         }
      };
   })(),
   factor: (() =>
   {
      const
         s  = new Vector2/* default */.A (),
         si = new Numbers_Matrix2 (),
         so = new Numbers_Matrix2 (),
         b  = new Numbers_Matrix2 ();

      const eigen = { values: [ ], vectors: [[ ], [ ]] };

      return function (translation, rotation, scale, scaleOrientation)
      {
         // (1) Get translation.
         translation ?.set (this [6], this [7]);

         // (2) Create 3x3 matrix.
         const a = this .submatrix;

         // (3) Compute det A. If negative, set sign = -1, else sign = 1
         const det      = a .determinant ();
         const det_sign = det < 0 ? -1 : 1;

         // (4) B = A * !A  (here !A means A transpose)
         b .assign (a) .transpose () .multLeft (a);
         const e = (0,eigen_decomposition/* default */.A) (b, eigen);

         // Find min / max eigenvalues and do ratio test to determine singularity.

         so .set (e .vectors [0] [0], e .vectors [1] [0],
                  e .vectors [0] [1], e .vectors [1] [1]);

         if (scaleOrientation)
         {
            scaleOrientation [0] = so [0];
            scaleOrientation [1] = so [1];
            scaleOrientation [2] = Math .atan2 (so [1], so [0]);
         }

         // Compute s = sqrt(eigen values), with sign. Set si = s-inverse

         s .set (det_sign * Math .sqrt (e .values [0]),
                 det_sign * Math .sqrt (e .values [1]));

         scale ?.assign (s);

         if (rotation)
         {
            si [0] = 1 / s .x;
            si [3] = 1 / s .y;

            // (5) Compute U = !R ~S R A.
            a .multLeft (so) .multLeft (si) .multLeft (so .transpose ());

            rotation [0] = a [0];
            rotation [1] = a [1];
            rotation [2] = Math .atan2 (a [1], a [0]);
         }
      };
   })(),
   determinant2 ()
   {
      const { 0: m0, 1: m1, 3: m3, 4: m4 } = this;

      return m0 * m4 - m1 * m3;
   },
   determinant ()
   {
      const { 0: m0, 1: m1, 2: m2, 3: m3, 4: m4, 5: m5, 6: m6, 7: m7, 8: m8 } = this;

      return m0 * (m4 * m8 - m5 * m7) -
             m1 * (m3 * m8 - m5 * m6) +
             m2 * (m3 * m7 - m4 * m6);
   },
   transpose ()
   {
      let tmp;

      tmp = this [1]; this [1] = this [3]; this [3] = tmp;
      tmp = this [2]; this [2] = this [6]; this [6] = tmp;
      tmp = this [5]; this [5] = this [7]; this [7] = tmp;

      return this;
   },
   inverse ()
   {
      // Complexity 2 +, 16 -, 33 *, 1 /.

      const
         { 0: m0, 1: m1, 2: m2, 3: m3, 4: m4, 5: m5, 6: m6, 7: m7, 8: m8 } = this,
         t4  = m0 * m4,
         t6  = m0 * m7,
         t8  = m3 * m1,
         t10 = m3 * m7,
         t12 = m6 * m1,
         t14 = m6 * m4;

      let d = (t4 * m8 - t6 * m5 - t8 * m8 + t10 * m2 + t12 * m5 - t14 * m2);

      // if (d === 0) ... determinant is zero.

      d = 1 / d;

      const
         b0 =  (m4 * m8 - m7 * m5) * d,
         b1 = -(m1 * m8 - m7 * m2) * d,
         b2 =  (m1 * m5 - m4 * m2) * d,
         b3 = -(m3 * m8 - m6 * m5) * d,
         b4 =  (m0 * m8 - m6 * m2) * d,
         b5 = -(m0 * m5 - m3 * m2) * d;

      this [0] = b0;
      this [1] = b1;
      this [2] = b2;
      this [3] = b3;
      this [4] = b4;
      this [5] = b5;
      this [6] =  (t10 - t14) * d;
      this [7] = -(t6 - t12) * d;
      this [8] =  (t4 - t8) * d;

      return this;
   },
   multLeft (matrix)
   {
      // Complexity 18 +, 27 *.

      const
         { 0: a0, 1: a1, 2: a2, 3: a3, 4: a4, 5: a5, 6: a6, 7: a7, 8: a8 } = this,
         { 0: b0, 1: b1, 2: b2, 3: b3, 4: b4, 5: b5, 6: b6, 7: b7, 8: b8 } = matrix;

      this [0] = a0 * b0 + a3 * b1 + a6 * b2;
      this [1] = a1 * b0 + a4 * b1 + a7 * b2;
      this [2] = a2 * b0 + a5 * b1 + a8 * b2;
      this [3] = a0 * b3 + a3 * b4 + a6 * b5;
      this [4] = a1 * b3 + a4 * b4 + a7 * b5;
      this [5] = a2 * b3 + a5 * b4 + a8 * b5;
      this [6] = a0 * b6 + a3 * b7 + a6 * b8;
      this [7] = a1 * b6 + a4 * b7 + a7 * b8;
      this [8] = a2 * b6 + a5 * b7 + a8 * b8;

      return this;
   },
   multRight (matrix)
   {
      // Complexity 18 +, 27 *.

      const
         { 0: a0, 1: a1, 2: a2, 3: a3, 4: a4, 5: a5, 6: a6, 7: a7, 8: a8 } = this,
         { 0: b0, 1: b1, 2: b2, 3: b3, 4: b4, 5: b5, 6: b6, 7: b7, 8: b8 } = matrix;

      this [0] = a0 * b0 + a1 * b3 + a2 * b6;
      this [1] = a0 * b1 + a1 * b4 + a2 * b7;
      this [2] = a0 * b2 + a1 * b5 + a2 * b8;
      this [3] = a3 * b0 + a4 * b3 + a5 * b6;
      this [4] = a3 * b1 + a4 * b4 + a5 * b7;
      this [5] = a3 * b2 + a4 * b5 + a5 * b8;
      this [6] = a6 * b0 + a7 * b3 + a8 * b6;
      this [7] = a6 * b1 + a7 * b4 + a8 * b7;
      this [8] = a6 * b2 + a7 * b5 + a8 * b8;

      return this;
   },
   multVecMatrix (vector)
   {
      if (vector .length === 2)
      {
         const
            { x, y } = vector,
            w = x * this [2] + y * this [5] + this [8];

         vector .x = (x * this [0] + y * this [3] + this [6]) / w;
         vector .y = (x * this [1] + y * this [4] + this [7]) / w;

         return vector;
      }
      else
      {
         const { x, y, z } = vector;

         vector .x = x * this [0] + y * this [3] + z * this [6];
         vector .y = x * this [1] + y * this [4] + z * this [7];
         vector .z = x * this [2] + y * this [5] + z * this [8];

         return vector;
      }
   },
   multMatrixVec (vector)
   {
      if (vector .length === 2)
      {
         const
            { x, y } = vector,
            w = x * this [6] + y * this [7] + this [8];

         vector .x = (x * this [0] + y * this [1] + this [2]) / w;
         vector .y = (x * this [3] + y * this [4] + this [5]) / w;

         return vector;
      }
      else
      {
         const { x, y, z } = vector;

         vector .x = x * this [0] + y * this [1] + z * this [2];
         vector .y = x * this [3] + y * this [4] + z * this [5];
         vector .z = x * this [6] + y * this [7] + z * this [8];

         return vector;
      }
   },
   multDirMatrix (vector)
   {
      const { x, y } = vector;

      vector .x = x * this [0] + y * this [3];
      vector .y = x * this [1] + y * this [4];

      return vector;
   },
   multMatrixDir (vector)
   {
      const { x, y } = vector;

      vector .x = x * this [0] + y * this [1];
      vector .y = x * this [3] + y * this [4];

      return vector;
   },
   identity ()
   {
      this [0] = 1; this [1] = 0; this [2] = 0;
      this [3] = 0; this [4] = 1; this [5] = 0;
      this [6] = 0; this [7] = 0; this [8] = 1;

      return this;
   },
   translate (translation)
   {
      const { x, y } = translation;

      this [6] += this [0] * x + this [3] * y;
      this [7] += this [1] * x + this [4] * y;

      return this;
   },
   rotate (rotation)
   {
      return this .multLeft (Matrix3 .Rotation (rotation));
   },
   scale (scale)
   {
      const { x, y } = scale;

      this [0] *= x;
      this [3] *= y;

      this [1] *= x;
      this [4] *= y;

      return this;
   },
   skewX (angle)
   {
      const a = Math .tan (angle);

      this [3] += this [0] * a;
      this [4] += this [1] * a;
      this [5] += this [2] * a;

      return this;
   },
   skewY (angle)
   {
      const a = Math .tan (angle);

      this [0] += this [3] * a;
      this [1] += this [4] * a;
      this [2] += this [5] * a;

      return this;
   },
   toString ()
   {
      return Array .prototype .join .call (this, " ");
   },
});

for (const key of Object .keys (Matrix3 .prototype))
   Object .defineProperty (Matrix3 .prototype, key, { enumerable: false });

Object .defineProperties (Matrix3 .prototype,
{
   order: { value: 3 },
   length: { value: 9 },
   x:
   {
      get: (() =>
      {
         const vector = new Vector3/* default */.A ();

         return function () { return vector .set (this [0], this [1], this [2]); };
      })(),
   },
   y:
   {
      get: (() =>
      {
         const vector = new Vector3/* default */.A ();

         return function () { return vector .set (this [3], this [4], this [5]); };
      })(),
   },
   z:
   {
      get: (() =>
      {
         const vector = new Vector3/* default */.A ();

         return function () { return vector .set (this [6], this [7], this [8]); };
      })(),
   },
   xAxis:
   {
      get: (() =>
      {
         const vector = new Vector2/* default */.A ();

         return function () { return vector .set (this [0], this [1]); };
      })(),
   },
   yAxis:
   {
      get: (() =>
      {
         const vector = new Vector2/* default */.A ();

         return function () { return vector .set (this [3], this [4]); };
      })(),
   },
   origin:
   {
      get: (() =>
      {
         const vector = new Vector2/* default */.A ();

         return function () { return vector .set (this [6], this [7]); };
      })(),
   },
   submatrix:
   {
      get: (() =>
      {
         const matrix = new Numbers_Matrix2 ();

         return function ()
         {
            matrix [0] = this [0]; matrix [1] = this [1];
            matrix [2] = this [3]; matrix [3] = this [4];
            return matrix;
         };
      })(),
   },
});

Object .assign (Matrix3,
{
   IDENTITY: Object .freeze (new Matrix3 ()),
   Rotation (rotation)
   {
      const
         sinAngle = Math .sin (rotation),
         cosAngle = Math .cos (rotation);

      return new Matrix3 ( cosAngle, sinAngle, 0,
                          -sinAngle, cosAngle, 0,
                           0, 0, 1);
   },
   Matrix2 (matrix)
   {
      return new Matrix3 (matrix [0], matrix [1], 0,
                          matrix [2], matrix [3], 0,
                          0, 0, 1);
   },
});

const m = new Matrix3 ();

const Matrix3_default_ = Matrix3;
;

/* harmony default export */ const Numbers_Matrix3 = (Namespace/* default */.A .add ("Matrix3", Matrix3_default_));

/***/ },

/***/ 1319
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Fields_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(3515);
/* harmony import */ var _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(8450);
/* harmony import */ var _Core_X3DBindableNode_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(3869);
/* harmony import */ var _Browser_Rendering_GeometryContext_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(5291);
/* harmony import */ var _Rendering_VertexArray_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(6620);
/* harmony import */ var _Rendering_TraverseType_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(5465);
/* harmony import */ var _Browser_Shape_AlphaMode_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(6018);
/* harmony import */ var _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(4946);
/* harmony import */ var _Rendering_RenderPass_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(7922);
/* harmony import */ var _standard_Math_Numbers_Complex_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(8318);
/* harmony import */ var _standard_Math_Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(7910);
/* harmony import */ var _standard_Math_Numbers_Rotation4_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(4580);
/* harmony import */ var _standard_Math_Numbers_Matrix4_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(2597);
/* harmony import */ var _standard_Math_Algorithm_js__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(5370);
/* harmony import */ var _standard_Utility_BitSet_js__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(8222);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(6334);
















function X3DBackgroundNode (executionContext)
{
   _Core_X3DBindableNode_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .call (this, executionContext);

   this .addType (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .X3DBackgroundNode);

   this .addChildObjects (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .inputOutput, "hidden", new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFBool ());

   this .setVisibleObject (true);

   // Units

   this ._skyAngle    .setUnit ("angle");
   this ._groundAngle .setUnit ("angle");

   // Private properties

   this .modelMatrix      = new _standard_Math_Numbers_Matrix4_js__WEBPACK_IMPORTED_MODULE_12__/* ["default"] */ .A ();
   this .clipPlanes       = [ ];
   this .colors           = [ ];
   this .sphere           = [ ];
   this .textureNodes     = new Array (6);
   this .textureBits      = new _standard_Utility_BitSet_js__WEBPACK_IMPORTED_MODULE_14__/* ["default"] */ .A ();
   this .sphereContext    = new _Browser_Rendering_GeometryContext_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A ({ colorMaterial: true });
   this .texturesContext  = new _Browser_Rendering_GeometryContext_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A ({ localObjectsKeys: this .sphereContext .localObjectsKeys });
   this .localObjectsKeys = this .sphereContext .localObjectsKeys;

   this [_Rendering_RenderPass_js__WEBPACK_IMPORTED_MODULE_8__/* ["default"] */ .A .RENDER_KEY]         = this;
   this [_Rendering_RenderPass_js__WEBPACK_IMPORTED_MODULE_8__/* ["default"] */ .A .TRANSMISSION_KEY]   = this;
   this [_Rendering_RenderPass_js__WEBPACK_IMPORTED_MODULE_8__/* ["default"] */ .A .VOLUME_SCATTER_KEY] = null;

}

Object .assign (Object .setPrototypeOf (X3DBackgroundNode .prototype, _Core_X3DBindableNode_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .prototype),
{
   initialize ()
   {
      _Core_X3DBindableNode_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .prototype .initialize .call (this);

      const
         browser = this .getBrowser (),
         gl      = browser .getContext ();

      this .colorBuffer         = gl .createBuffer ();
      this .sphereBuffer        = gl .createBuffer ();
      this .texCoordBuffers     = [gl .createBuffer ()];
      this .textureBuffers      = Array .from ({length: 6}, () => gl .createBuffer ());
      this .sphereArrayObject   = new _Rendering_VertexArray_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A (gl);
      this .textureArrayObjects = Array .from ({length: 6}, () => new _Rendering_VertexArray_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A (gl));

      this ._groundAngle .addInterest ("build", this);
      this ._groundColor .addInterest ("build", this);
      this ._skyAngle    .addInterest ("build", this);
      this ._skyColor    .addInterest ("build", this);

      this .build ();
      this .transferRectangle ();
   },
   isHidden ()
   {
      return this ._hidden .getValue ();
   },
   setHidden (value)
   {
      if (value === this ._hidden .getValue ())
         return;

      this ._hidden = value;
   },
   isTransparent ()
   {
      if (this ._hidden .getValue ())
         return true;

      if (this ._transparency .getValue () <= 0)
         return false;

      if (this .textureBits .size !== 6)
         return true;

      for (const i of this .textureBits)
      {
         if (this .textureNodes [i] ._transparent .getValue ())
            return true;
      }

      return false;
   },
   getRenderPassNodes ()
   {
      return this .renderPassNodes;
   },
   set_texture__ (index, textureNode)
   {
      this .textureNodes [index] ?.removeInterest (`set_loadState${index}__`, this);

      this .textureNodes [index] = textureNode;

      textureNode ?.addInterest (`set_loadState${index}__`, this, index, textureNode);

      this .set_loadState__ (index, textureNode);
   },
   set_loadState__ (index, textureNode)
   {
      this .setTextureBit (index, textureNode ?.checkLoadState ());
   },
   setTextureBit (bit, loadState)
   {
      this .textureBits .set (bit, loadState === _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .COMPLETE_STATE);
   },
   getColor (theta, color, angle)
   {
      const index = _standard_Math_Algorithm_js__WEBPACK_IMPORTED_MODULE_13__/* ["default"] */ .A .upperBound (angle, 0, angle .length, theta);

      return color [index];
   },
   build ()
   {
      this .colors .length = 0;
      this .sphere .length = 0;

      if (this ._groundColor .length === 0 && this ._skyColor .length == 1)
      {
         // Build cube

         this .sphere .vertices = 36;

         this .sphere .push ( 1,  1, -1, 1, -1,  1, -1, 1, -1, -1, -1, 1, // Back
                              1,  1, -1, 1, -1, -1, -1, 1,  1, -1, -1, 1,
                             -1,  1,  1, 1,  1,  1,  1, 1, -1, -1,  1, 1, // Front
                             -1, -1,  1, 1,  1,  1,  1, 1,  1, -1,  1, 1,
                             -1,  1, -1, 1, -1,  1,  1, 1, -1, -1,  1, 1, // Left
                             -1,  1, -1, 1, -1, -1,  1, 1, -1, -1, -1, 1,
                              1,  1,  1, 1,  1,  1, -1, 1,  1, -1,  1, 1, // Right
                              1, -1,  1, 1,  1,  1, -1, 1,  1, -1, -1, 1,
                              1,  1,  1, 1, -1,  1,  1, 1, -1,  1, -1, 1, // Top
                              1,  1,  1, 1, -1,  1, -1, 1,  1,  1, -1, 1,
                             -1, -1,  1, 1,  1, -1,  1, 1, -1, -1, -1, 1, // Bottom
                             -1, -1, -1, 1,  1, -1,  1, 1,  1, -1, -1, 1);

         const color = this ._skyColor [0];

         for (let i = 0, vertices = this .sphere .vertices; i < vertices; ++ i)
            this .colors .push (... color, 1);
      }
      else
      {
         // Build sphere

         if (this ._skyColor .length > this ._skyAngle .length)
         {
            const vAngle = this ._skyAngle .slice ();

            if (vAngle .length === 0 || vAngle [0] > 0)
               vAngle .unshift (0);

            if (vAngle .at (-1) < Math .PI)
               vAngle .push (Math .PI);

            if (vAngle .length === 2)
               vAngle .splice (1, 0, (vAngle [0] + vAngle [1]) / 2)

            this .buildSphere (vAngle, this ._skyAngle, this ._skyColor, false);
         }

         if (this ._groundColor .length > this ._groundAngle .length)
         {
            const vAngle = this ._groundAngle .slice () .reverse ();

            if (vAngle .length === 0 || vAngle [0] < Math .PI / 2)
               vAngle .unshift (Math .PI / 2);

            if (vAngle .at (-1) > 0)
               vAngle .push (0);

            this .buildSphere (vAngle, this ._groundAngle, this ._groundColor, true);
         }
      }

      this .transferSphere ();
   },
   buildSphere: (() =>
   {
      const U_DIMENSION = 20;

      const
         z1 = new _standard_Math_Numbers_Complex_js__WEBPACK_IMPORTED_MODULE_9__/* ["default"] */ .A (),
         z2 = new _standard_Math_Numbers_Complex_js__WEBPACK_IMPORTED_MODULE_9__/* ["default"] */ .A (),
         y1 = new _standard_Math_Numbers_Complex_js__WEBPACK_IMPORTED_MODULE_9__/* ["default"] */ .A (),
         y2 = new _standard_Math_Numbers_Complex_js__WEBPACK_IMPORTED_MODULE_9__/* ["default"] */ .A (),
         y3 = new _standard_Math_Numbers_Complex_js__WEBPACK_IMPORTED_MODULE_9__/* ["default"] */ .A (),
         y4 = new _standard_Math_Numbers_Complex_js__WEBPACK_IMPORTED_MODULE_9__/* ["default"] */ .A ();

      return function (vAngle, angle, color, bottom)
      {
         const
            vAngleMax   = bottom ? Math .PI / 2 : Math .PI,
            V_DIMENSION = vAngle .length - 1;

         for (let v = 0; v < V_DIMENSION; ++ v)
         {
            let
               theta1 = _standard_Math_Algorithm_js__WEBPACK_IMPORTED_MODULE_13__/* ["default"] */ .A .clamp (vAngle [v],     0, vAngleMax),
               theta2 = _standard_Math_Algorithm_js__WEBPACK_IMPORTED_MODULE_13__/* ["default"] */ .A .clamp (vAngle [v + 1], 0, vAngleMax);

            if (bottom)
            {
               theta1 = Math .PI - theta1;
               theta2 = Math .PI - theta2;
            }

            z1 .setPolar (1, theta1);
            z2 .setPolar (1, theta2);

            const
               c1 = this .getColor (vAngle [v],     color, angle),
               c2 = this .getColor (vAngle [v + 1], color, angle);

            for (let u = 0; u < U_DIMENSION; ++ u)
            {
               // p4 --- p1
               //  |   / |
               //  | /   |
               // p3 --- p2

               // The last point is the first one.
               const u1 = u < U_DIMENSION - 1 ? u + 1 : 0;

               // p1, p2
               let phi = 2 * Math .PI * (u / U_DIMENSION);
               y1 .setPolar (-z1 .imag, phi);
               y2 .setPolar (-z2 .imag, phi);

               // p3, p4
               phi = 2 * Math .PI * (u1 / U_DIMENSION);
               y3 .setPolar (-z2 .imag, phi);
               y4 .setPolar (-z1 .imag, phi);

               // Triangle 1 and 2

               this .colors .push (... c1, 1,
                                   ... c2, 1,
                                   ... c2, 1,
                                   // Triangle 2
                                   ... c1, 1,
                                   ... c1, 1,
                                   ... c2, 1);

               this .sphere .push (y1 .imag, z1 .real, y1 .real, 1,
                                   y3 .imag, z2 .real, y3 .real, 1,
                                   y2 .imag, z2 .real, y2 .real, 1,
                                   // Triangle 2
                                   y1 .imag, z1 .real, y1 .real, 1,
                                   y4 .imag, z1 .real, y4 .real, 1,
                                   y3 .imag, z2 .real, y3 .real, 1);
            }
         }
      };
   })(),
   transferSphere ()
   {
      const gl = this .getBrowser () .getContext ();

      // Transfer colors.

      gl .bindBuffer (gl .ARRAY_BUFFER, this .colorBuffer);
      gl .bufferData (gl .ARRAY_BUFFER, new Float32Array (this .colors), gl .DYNAMIC_DRAW);

      // Transfer sphere.

      gl .bindBuffer (gl .ARRAY_BUFFER, this .sphereBuffer);
      gl .bufferData (gl .ARRAY_BUFFER, new Float32Array (this .sphere), gl .DYNAMIC_DRAW);

      this .sphereCount = this .sphere .length / 4;
   },
   transferRectangle: (() =>
   {
      const texCoords = new Float32Array ([
         1, 1, 0, 1,
         0, 1, 0, 1,
         0, 0, 0, 1,
         1, 1, 0, 1,
         0, 0, 0, 1,
         1, 0, 0, 1,
      ]);

      const frontVertices = new Float32Array ([
         1,  1, -1, 1,
        -1,  1, -1, 1,
        -1, -1, -1, 1,
         1,  1, -1, 1,
        -1, -1, -1, 1,
         1, -1, -1, 1,
      ]);

      const backVertices = new Float32Array ([
         -1,  1,  1, 1,
          1,  1,  1, 1,
          1, -1,  1, 1,
         -1,  1,  1, 1,
          1, -1,  1, 1,
         -1, -1,  1, 1,
      ]);

      const leftVertices = new Float32Array ([
         -1,  1, -1, 1,
         -1,  1,  1, 1,
         -1, -1,  1, 1,
         -1,  1, -1, 1,
         -1, -1,  1, 1,
         -1, -1, -1, 1,
      ]);

      const rightVertices = new Float32Array ([
         1,  1,  1, 1,
         1,  1, -1, 1,
         1, -1, -1, 1,
         1,  1,  1, 1,
         1, -1, -1, 1,
         1, -1,  1, 1,
      ]);

      const topVertices = new Float32Array ([
          1, 1,  1, 1,
         -1, 1,  1, 1,
         -1, 1, -1, 1,
          1, 1,  1, 1,
         -1, 1, -1, 1,
          1, 1, -1, 1,
      ]);

      const bottomVertices = new Float32Array ([
          1, -1, -1, 1,
         -1, -1, -1, 1,
         -1, -1,  1, 1,
          1, -1, -1, 1,
         -1, -1,  1, 1,
          1, -1,  1, 1,
      ]);

      const vertices = [
         frontVertices,
         backVertices,
         leftVertices,
         rightVertices,
         topVertices,
         bottomVertices,
      ];

      return function ()
      {
         const gl = this .getBrowser () .getContext ();

         // Transfer texCoords.

         gl .bindBuffer (gl .ARRAY_BUFFER, this .texCoordBuffers [0]);
         gl .bufferData (gl .ARRAY_BUFFER, texCoords, gl .DYNAMIC_DRAW);

         // Transfer rectangle.

         for (let i = 0; i < 6; ++ i)
         {
            gl .bindBuffer (gl .ARRAY_BUFFER, this .textureBuffers [i]);
            gl .bufferData (gl .ARRAY_BUFFER, vertices [i], gl .DYNAMIC_DRAW);
         }
      };
   })(),
   traverse (type, renderObject)
   {
      switch (type)
      {
         case _Rendering_TraverseType_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .CAMERA:
         {
            renderObject .getLayer () .getBackgrounds () .push (this);

            this .modelMatrix .assign (renderObject .getModelViewMatrix () .get ());
            return;
         }
         case _Rendering_TraverseType_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .DISPLAY:
         {
            const
               localObjects     = renderObject .getLocalObjects (),
               clipPlanes       = this .clipPlanes,
               localObjectsKeys = this .localObjectsKeys;

            let c = 0;

            for (const localObject of localObjects)
            {
               if (localObject .isClipPlane)
                  clipPlanes [c ++] = localObject;
            }

            clipPlanes       .length = c;
            localObjectsKeys .length = c;
            localObjectsKeys .fill (0);
            return;
         }
      }
   },
   display: (() =>
   {
      const
         projectionMatrixArray = new Float32Array (16),
         projectionMatrix      = new _standard_Math_Numbers_Matrix4_js__WEBPACK_IMPORTED_MODULE_12__/* ["default"] */ .A (),
         projectionScale       = new _standard_Math_Numbers_Matrix4_js__WEBPACK_IMPORTED_MODULE_12__/* ["default"] */ .A (1,0,0,0, 0,1,0,0, 0,0,0,0, 0,0,0,1),
         modelViewMatrixArray  = new Float32Array (16),
         modelViewMatrix       = new _standard_Math_Numbers_Matrix4_js__WEBPACK_IMPORTED_MODULE_12__/* ["default"] */ .A (),
         rotation              = new _standard_Math_Numbers_Rotation4_js__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A (),
         scale                 = new _standard_Math_Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_10__/* ["default"] */ .A ();

      return function (gl, renderObject)
      {
         if (this ._hidden .getValue ())
            return;

         const browser = this .getBrowser ();

         // Always fill background.

         if (browser .getWireframe ())
         {
            const ext = gl .getExtension ("WEBGL_polygon_mode");

            ext ?.polygonModeWEBGL (gl .FRONT_AND_BACK, ext .FILL_WEBGL);
         }

         // Setup context.

         gl .disable (gl .DEPTH_TEST);
         gl .depthMask (false);
         gl .enable (gl .CULL_FACE);
         gl .frontFace (gl .CCW);

         // Create projection matrix.
         // The projectionScale will set gl_Position.z to 0,
         // so it is in the middle of near and far plane.

         projectionMatrixArray .set (projectionMatrix
            .assign (renderObject .getProjectionMatrixArray ())
            .multRight (projectionScale));

         // Rotate and scale background.

         const far = renderObject .getViewpoint () .getMaxFarValue ();

         modelViewMatrix .assign (this .modelMatrix);
         modelViewMatrix .multRight (renderObject .getViewMatrix () .get ());
         modelViewMatrix .get (null, rotation);
         modelViewMatrix .identity ();
         modelViewMatrix .rotate (rotation);
         modelViewMatrix .scale (scale .set (far, far, far));

         modelViewMatrixArray .set (modelViewMatrix);

         // Draw background sphere and texture cube.

         this .drawSphere (renderObject, modelViewMatrixArray, projectionMatrixArray);

         if (+this .textureBits)
            this .drawCube (renderObject, modelViewMatrixArray, projectionMatrixArray);

         gl .depthMask (true);
         gl .enable (gl .DEPTH_TEST);
         gl .disable (gl .BLEND);

         // Restore polygon mode.

         if (browser .getWireframe ())
         {
            const ext = gl .getExtension ("WEBGL_polygon_mode");

            ext ?.polygonModeWEBGL (gl .FRONT_AND_BACK, ext .LINE_WEBGL);
         }
      };
   })(),
   drawSphere (renderObject, modelViewMatrixArray, projectionMatrixArray)
   {
      const transparency = _standard_Math_Algorithm_js__WEBPACK_IMPORTED_MODULE_13__/* ["default"] */ .A .clamp (this ._transparency .getValue (), 0, 1);

      if (transparency === 1)
         return;

      const
         browser       = this .getBrowser (),
         gl            = browser .getContext (),
         sphereContext = this .sphereContext;

      sphereContext .alphaMode    = transparency ? _Browser_Shape_AlphaMode_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .BLEND : _Browser_Shape_AlphaMode_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .OPAQUE;
      sphereContext .renderObject = renderObject;

      const shaderNode = browser .getDefaultMaterial () .getShader (sphereContext);

      shaderNode .enable (gl);
      shaderNode .setClipPlanes (gl, this .clipPlanes, renderObject);

      // Uniforms

      gl .uniformMatrix4fv (shaderNode .x3d_ProjectionMatrix, false, projectionMatrixArray);
      gl .uniformMatrix4fv (shaderNode .x3d_EyeMatrix,        false, renderObject .getEyeMatrixArray ());
      gl .uniformMatrix4fv (shaderNode .x3d_ModelViewMatrix,  false, modelViewMatrixArray);

      gl .uniform3f (shaderNode .x3d_EmissiveColor,                        1, 1, 1)
      gl .uniform1f (shaderNode .x3d_Transparency,                         transparency)
      gl .uniform1i (shaderNode .x3d_TextureCoordinateGenerator [0] .mode, 0);

      // Enable vertex attribute arrays.

      if (this .sphereArrayObject .enable (shaderNode .getProgram ()))
      {
         shaderNode .enableColorAttribute  (gl, this .colorBuffer,  0, 0);
         shaderNode .enableVertexAttribute (gl, this .sphereBuffer, 0, 0);
      }

      // Draw.

      if (transparency)
         gl .enable (gl .BLEND);
      else
         gl .disable (gl .BLEND);

      gl .drawArrays (gl .TRIANGLES, 0, this .sphereCount);
   },
   drawCube: (() =>
   {
      const textureMatrixArray = new Float32Array (_standard_Math_Numbers_Matrix4_js__WEBPACK_IMPORTED_MODULE_12__/* ["default"] */ .A .IDENTITY);

      return function (renderObject, modelViewMatrixArray, projectionMatrixArray)
      {
         const
            browser         = this .getBrowser (),
            gl              = browser .getContext (),
            texturesContext = this .texturesContext;

         // Draw all textures.

         for (const i of this .textureBits)
         {
            const textureNode = this .textureNodes [i];

            texturesContext .alphaMode    = textureNode ._transparent .getValue () ? _Browser_Shape_AlphaMode_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .BLEND : _Browser_Shape_AlphaMode_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .OPAQUE;
            texturesContext .textureNode  = textureNode;
            texturesContext .renderObject = renderObject;

            const shaderNode = browser .getDefaultMaterial () .getShader (texturesContext);

            shaderNode .enable (gl);
            shaderNode .setClipPlanes (gl, this .clipPlanes, renderObject);

            // Set uniforms.

            gl .uniformMatrix4fv (shaderNode .x3d_ProjectionMatrix,  false, projectionMatrixArray);
            gl .uniformMatrix4fv (shaderNode .x3d_EyeMatrix,         false, renderObject .getEyeMatrixArray ());
            gl .uniformMatrix4fv (shaderNode .x3d_ModelViewMatrix,   false, modelViewMatrixArray);
            gl .uniformMatrix4fv (shaderNode .x3d_TextureMatrix [0], false, textureMatrixArray);

            gl .uniform3f (shaderNode .x3d_EmissiveColor,                        1, 1, 1);
            gl .uniform1f (shaderNode .x3d_Transparency,                         0);
            gl .uniform1i (shaderNode .x3d_TextureCoordinateGenerator [0] .mode, 0);

            this .drawRectangle (gl, browser, shaderNode, textureNode, this .textureBuffers [i], this .textureArrayObjects [i]);
         }
      };
   })(),
   drawRectangle (gl, browser, shaderNode, textureNode, buffer, vertexArray)
   {
      textureNode .setShaderUniforms (gl, shaderNode .x3d_Texture [0]);

      if (vertexArray .enable (shaderNode .getProgram ()))
      {
         shaderNode .enableTexCoordAttribute (gl, this .texCoordBuffers, 0, 0);
         shaderNode .enableVertexAttribute (gl, buffer, 0, 0);
      }

      // Draw.

      if (textureNode ._transparent .getValue ())
         gl .enable (gl .BLEND);
      else
         gl .disable (gl .BLEND);

      gl .drawArrays (gl .TRIANGLES, 0, 6);

      browser .resetTextureUnits ();
   },
});

Object .defineProperties (X3DBackgroundNode, _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .getStaticProperties ("X3DBackgroundNode", "EnvironmentalEffects", 1));

for (let index = 0; index < 6; ++ index)
{
   X3DBackgroundNode .prototype [`set_loadState${index}__`] = function (index, textureNode)
   {
      this .set_loadState__ (index, textureNode);
   };
}

const __default__ = X3DBackgroundNode;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_15__/* ["default"] */ .A .add ("X3DBackgroundNode", __default__));

/***/ },

/***/ 1658
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Features_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(5345);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(6334);


const __default__ = _Features_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .WEAK_REF && _Features_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .FINALIZATION_REGISTRY ?
/**
 * IterableWeakSet is a writable set-like class.
 */
class IterableWeakSet
{
   #map      = new Map ();
   #registry = new FinalizationRegistry (id => this .#map .delete (id));

   constructor (objects)
   {
      if (objects)
      {
         for (const object of objects)
            this .add (object);
      }
   }

   *[Symbol .iterator] ()
   {
      yield* this .values ();
   }

   get size ()
   {
      return this .#map .size;
   }

   add (object)
   {
      this .#map .set (object .getId (), new WeakRef (object));
      this .#registry .register (object, object .getId (), object);
   }

   clear ()
   {
      for (const object of this .values ())
         this .#registry .unregister (object);

      this .#map .clear ();
   }

   delete (object)
   {
      this .#map .delete (object .getId ());
      this .#registry .unregister (object);
   }

   forEach (callbackFn, thisArg)
   {
      for (const object of this .values ())
         callbackFn .call (thisArg, object, object, this);
   }

   has (object)
   {
      return this .#map .has (object .getId ());
   }

   *entries ()
   {
      for (const object of this .values ())
         yield [object, object];
   }

   *keys ()
   {
      yield *this .values ();
   }

   *values ()
   {
      for (const weakRef of this .#map .values ())
      {
         const object = weakRef .deref ();

         if (object)
            yield object;
      }
   }
}
:
class IterableWeakSet extends Set
{
   constructor (objects)
   {
      super (objects);
   }
};
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .add ("IterableWeakSet", __default__));

/***/ },

/***/ 1662
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Fields_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(3515);
/* harmony import */ var _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(2914);
/* harmony import */ var _Base_FieldDefinitionArray_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(9572);
/* harmony import */ var _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(8450);
/* harmony import */ var _X3DBackgroundNode_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(1319);
/* harmony import */ var _Texturing_ImageTexture_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(6316);
/* harmony import */ var _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(4946);
/* harmony import */ var _standard_Math_Numbers_Color3_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(2028);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(6334);









function Background (executionContext)
{
   _X3DBackgroundNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .call (this, executionContext);

   this .addType (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .Background);
}

Object .assign (Object .setPrototypeOf (Background .prototype, _X3DBackgroundNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .prototype),
{
   initialize ()
   {
      _X3DBackgroundNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .prototype .initialize .call (this);

      const
         frontTexture      = new _Texturing_ImageTexture_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A (this .getExecutionContext ()),
         backTexture       = new _Texturing_ImageTexture_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A (this .getExecutionContext ()),
         leftTexture       = new _Texturing_ImageTexture_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A (this .getExecutionContext ()),
         rightTexture      = new _Texturing_ImageTexture_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A (this .getExecutionContext ()),
         topTexture        = new _Texturing_ImageTexture_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A (this .getExecutionContext ()),
         bottomTexture     = new _Texturing_ImageTexture_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A (this .getExecutionContext ()),
         textureProperties = this .getBrowser () .getBackgroundTextureProperties ();

      this ._frontUrl  .addFieldInterest (frontTexture  ._url);
      this ._backUrl   .addFieldInterest (backTexture   ._url);
      this ._leftUrl   .addFieldInterest (leftTexture   ._url);
      this ._rightUrl  .addFieldInterest (rightTexture  ._url);
      this ._topUrl    .addFieldInterest (topTexture    ._url);
      this ._bottomUrl .addFieldInterest (bottomTexture ._url);

      frontTexture  ._url = this ._frontUrl;
      backTexture   ._url = this ._backUrl;
      leftTexture   ._url = this ._leftUrl;
      rightTexture  ._url = this ._rightUrl;
      topTexture    ._url = this ._topUrl;
      bottomTexture ._url = this ._bottomUrl;

      frontTexture  ._textureProperties = textureProperties;
      backTexture   ._textureProperties = textureProperties;
      leftTexture   ._textureProperties = textureProperties;
      rightTexture  ._textureProperties = textureProperties;
      topTexture    ._textureProperties = textureProperties;
      bottomTexture ._textureProperties = textureProperties;

      frontTexture  .setup ();
      backTexture   .setup ();
      leftTexture   .setup ();
      rightTexture  .setup ();
      topTexture    .setup ();
      bottomTexture .setup ();

      this .set_texture__ (0, frontTexture);
      this .set_texture__ (1, backTexture);
      this .set_texture__ (2, leftTexture);
      this .set_texture__ (3, rightTexture);
      this .set_texture__ (4, topTexture);
      this .set_texture__ (5, bottomTexture);
   }
});

Object .defineProperties (Background,
{
   ... _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .getStaticProperties ("Background", "EnvironmentalEffects", 1, "children", "2.0"),
   fieldDefinitions:
   {
      value: new _Base_FieldDefinitionArray_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A ([
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .inputOutput, "metadata",     new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFNode ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .inputOnly,   "set_bind",     new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFBool ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .inputOutput, "frontUrl",     new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFString ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .inputOutput, "backUrl",      new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFString ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .inputOutput, "leftUrl",      new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFString ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .inputOutput, "rightUrl",     new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFString ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .inputOutput, "topUrl",       new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFString ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .inputOutput, "bottomUrl",    new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFString ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .inputOutput, "skyAngle",     new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFFloat ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .inputOutput, "skyColor",     new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFColor (new _standard_Math_Numbers_Color3_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A ())),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .inputOutput, "groundAngle",  new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFFloat ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .inputOutput, "groundColor",  new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFColor ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .inputOutput, "transparency", new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFFloat ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .outputOnly,  "isBound",      new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFBool ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .outputOnly,  "bindTime",     new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFTime ()),
      ]),
      enumerable: true,
   },
});

const __default__ = Background;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_8__/* ["default"] */ .A .add ("Background", __default__));

/***/ },

/***/ 1736
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _X3DField_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(3247);
/* harmony import */ var _Features_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(5345);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(6334);




function X3DArrayField (value)
{
   _X3DField_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .call (this, value);
}

Object .assign (Object .setPrototypeOf (X3DArrayField .prototype, _X3DField_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .prototype),
{
   // Implement all function also in TypedArray, if possible.
   at: Array .prototype .at,
   concat: Array .prototype .concat,
   // copyWithin: Array.prototype.copyWithin,
   entries: Array .prototype .entries,
   every: Array .prototype .every,
   fill: Array .prototype .fill,
   filter (/* callbackFn, thisArg */)
   {
      const array = new (this .constructor) ();

      for (const v of Array .prototype .filter .call (this, ... arguments))
         array .push (v);

      return array;
   },
   find: Array .prototype .find,
   findIndex: Array .prototype .findIndex,
   findLast: Array .prototype .findLast,
   findLastIndex: Array .prototype .findLastIndex,
   flat: Array .prototype .flat,
   flatMap: Array .prototype .flatMap,
   forEach: Array .prototype .forEach,
   includes: Array .prototype .includes,
   indexOf: Array .prototype .indexOf,
   join: Array .prototype .join,
   keys: Array .prototype .keys,
   lastIndexOf: Array .prototype .lastIndexOf,
   map (/* callbackFn, thisArg */)
   {
      const array = new (this .constructor) ();

      for (const v of Array .prototype .map .call (this, ... arguments))
         array .push (v);

      return array;
   },
   reduce: Array .prototype .reduce,
   reduceRight: Array .prototype .reduceRight,
   reverse: Array .prototype .reverse,
   slice (/* start, end */)
   {
      const array = new (this .constructor) ();

      for (const v of Array .prototype .slice .call (this, ... arguments))
         array .push (v);

      return array;
   },
   some: Array .prototype .some,
   sort: Array .prototype .sort,
   toReversed ()
   {
      return this .copy () .reverse ();
   },
   toSorted (/* compareFn */)
   {
      return this .copy () .sort (... arguments);
   },
   toSpliced (/* start, deleteCount, ... insertValues */)
   {
      const copy = this .copy ();

      copy .splice (... arguments);

      return copy;
   },
   values: Array .prototype .values,
   with (index, value)
   {
      const copy = this .copy ();

      copy [index] = value;

      return copy;
   },
});

for (const key of Object .keys (X3DArrayField .prototype))
   Object .defineProperty (X3DArrayField .prototype, key, { enumerable: false });

const __default__ = X3DArrayField;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .add ("X3DArrayField", __default__));

/***/ },

/***/ 2005
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Algorithm_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(5370);
/* harmony import */ var _x_ite_Namespace_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(6334);


function Vector2 (x = 0, y = x)
{
   this .x = x;
   this .y = y;
}

Object .assign (Vector2 .prototype,
{
   *[Symbol .iterator] ()
   {
      yield this .x;
      yield this .y;
   },
   copy ()
   {
      const copy = Object .create (Vector2 .prototype);
      copy .x = this .x;
      copy .y = this .y;
      return copy;
   },
   assign ({ x, y })
   {
      this .x = x;
      this .y = y;
      return this;
   },
   set (x = 0, y = x)
   {
      this .x = x;
      this .y = y;
      return this;
   },
   equals ({ x, y })
   {
      return this .x === x &&
             this .y === y;
   },
   negate ()
   {
      this .x = -this .x;
      this .y = -this .y;
      return this;
   },
   inverse ()
   {
      this .x = 1 / this .x;
      this .y = 1 / this .y;
      return this;
   },
   add ({ x, y })
   {
      this .x += x;
      this .y += y;
      return this;
   },
   subtract ({ x, y })
   {
      this .x -= x;
      this .y -= y;
      return this;
   },
   multiply (value)
   {
      this .x *= value;
      this .y *= value;
      return this;
   },
   multVec ({ x, y })
   {
      this .x *= x;
      this .y *= y;
      return this;
   },
   divide (value)
   {
      this .x /= value;
      this .y /= value;
      return this;
   },
   divVec ({ x, y })
   {
      this .x /= x;
      this .y /= y;
      return this;
   },
   normalize ()
   {
      const length = Math .hypot (this .x, this .y);

      if (length)
      {
         this .x /= length;
         this .y /= length;
      }

      return this;
   },
   dot ({ x, y })
   {
      return this .x * x +
             this .y * y;
   },
   squaredNorm ()
   {
      const { x, y } = this;

      return x * x +
             y * y;
   },
   norm ()
   {
      return Math .hypot (this .x, this .y);
   },
   distance ({ x, y })
   {
      return Math .hypot (this .x - x,
                          this .y - y);
   },
   lerp ({ x: dX, y: dY }, t)
   {
      const { x, y } = this;

      this .x = x + t * (dX - x);
      this .y = y + t * (dY - y);
      return this;
   },
   abs ()
   {
      const { x, y } = this;

      this .x = Math .abs (x);
      this .y = Math .abs (y);
      return this;
   },
   min (vector)
   {
      let { x, y } = this;

      for (const { x: minX, y: minY } of arguments)
      {
         x = Math .min (x, minX);
         y = Math .min (y, minY);
      }

      this .x = x;
      this .y = y;
      return this;
   },
   max (vector)
   {
      let { x, y } = this;

      for (const { x: maxX, y: maxY } of arguments)
      {
         x = Math .max (x, maxX);
         y = Math .max (y, maxY);
      }

      this .x = x;
      this .y = y;
      return this;
   },
   clamp ({ x: minX, y: minY }, { x: maxX, y: maxY })
   {
      this .x = _Algorithm_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .clamp (this .x, minX, maxX);
      this .y = _Algorithm_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .clamp (this .y, minY, maxY);
      return this;
   },
   toString ()
   {
      return this .x + " " +
             this .y;
   }
});

for (const key of Object .keys (Vector2 .prototype))
   Object .defineProperty (Vector2 .prototype, key, { enumerable: false });

Object .defineProperties (Vector2 .prototype,
{
   length: { value: 2 },
   0:
   {
      get () { return this .x; },
      set (value) { this .x = value; },
   },
   1:
   {
      get () { return this .y; },
      set (value) { this .y = value; },
   },
});

Object .assign (Vector2,
{
   ZERO: Object .freeze (new Vector2 ()),
   // Positive values
   ONE: Object .freeze (new Vector2 (1)),
   X_AXIS: Object .freeze (new Vector2 (1, 0)),
   Y_AXIS: Object .freeze (new Vector2 (0, 1)),
   // Negative values
   NEGATIVE_ONE: Object .freeze (new Vector2 (-1)),
   NEGATIVE_X_AXIS: Object .freeze (new Vector2 (-1, 0)),
   NEGATIVE_Y_AXIS: Object .freeze (new Vector2 (0, -1)),
});

const __default__ = Vector2;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_x_ite_Namespace_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .add ("Vector2", __default__));

/***/ },

/***/ 2028
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Algorithm_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(5370);
/* harmony import */ var _x_ite_Namespace_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(6334);


const { interval, degrees } = _Algorithm_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A;

const
   _r = Symbol .for ("X_ITE.Color3.r"),
   _g = Symbol .for ("X_ITE.Color3.g"),
   _b = Symbol .for ("X_ITE.Color3.b");

// glTF sometimes allows color values greater than 1.
// See: https://github.com/KhronosGroup/glTF/blob/main/extensions/2.0/Khronos/KHR_materials_specular/README.md
// See: https://raw.githubusercontent.com/KhronosGroup/glTF-Sample-Assets/master/Models/SpecularTest/glTF/SpecularTest.gltf

function Color3 (r = 0, g = r, b = g)
{
   this [_r] = r;
   this [_g] = g;
   this [_b] = b;
}

Object .assign (Color3 .prototype,
{
   *[Symbol .iterator] ()
   {
      yield this [_r];
      yield this [_g];
      yield this [_b];
   },
   copy ()
   {
      const copy = Object .create (Color3 .prototype);
      copy [_r] = this [_r];
      copy [_g] = this [_g];
      copy [_b] = this [_b];
      return copy;
   },
   assign (color)
   {
      this [_r] = color [_r];
      this [_g] = color [_g];
      this [_b] = color [_b];
      return this;
   },
   set (r = 0, g = r, b = g)
   {
      this [_r] = r;
      this [_g] = g;
      this [_b] = b;
      return this;
   },
   equals (color)
   {
      return this [_r] === color [_r] &&
             this [_g] === color [_g] &&
             this [_b] === color [_b];
   },
   getHSV (result = [ ])
   {
      let h, s, v;

      const
         r = this [_r],
         g = this [_g],
         b = this [_b];

      const
         min = Math .min (r, g, b),
         max = Math .max (r, g, b);

      v = max; // value

      const delta = max - min;

      if (max !== 0 && delta !== 0)
      {
         s = delta / max; // s

         if (r === max)
            h =     (g - b) / delta;  // between yellow & magenta
         else if (g === max)
            h = 2 + (b - r) / delta;  // between cyan & yellow
         else
            h = 4 + (r - g) / delta;  // between magenta & cyan

         h *= Math .PI / 3;  // radiants

         if (h < 0)
            h += Math .PI * 2;
      }
      else
      {
         s = h = 0; // s = 0, h is undefined
      }

      result [0] = h;
      result [1] = s;
      result [2] = v;

      return result;
   },
   setHSV (h, s, v)
   {
      s = Math .max (s, 0),
      v = Math .max (v, 0);

      // H is given on [0, 2 * Pi]. S and V are given on [0, 1].
      // RGB are each returned on [0, 1].

      if (s === 0)
      {
         // achromatic (grey)
         this [_r] = this [_g] = this [_b] = v;
      }
      else
      {
         const w = degrees (interval (h, 0, Math .PI * 2)) / 60;     // sector 0 to 5

         const i = Math .floor (w);
         const f = w - i;                      // factorial part of h
         const p = v * ( 1 - s );
         const q = v * ( 1 - s * f );
         const t = v * ( 1 - s * ( 1 - f ) );

         switch (i % 6)
         {
            case 0:  this [_r] = v; this [_g] = t; this [_b] = p; break;
            case 1:  this [_r] = q; this [_g] = v; this [_b] = p; break;
            case 2:  this [_r] = p; this [_g] = v; this [_b] = t; break;
            case 3:  this [_r] = p; this [_g] = q; this [_b] = v; break;
            case 4:  this [_r] = t; this [_g] = p; this [_b] = v; break;
            default: this [_r] = v; this [_g] = p; this [_b] = q; break;
         }
      }

      return this;
   },
   linearToSRGB (color = new Color3 ())
   {
      color [_r] = Math .pow (this [_r], 1 / 2.2);
      color [_g] = Math .pow (this [_g], 1 / 2.2);
      color [_b] = Math .pow (this [_b], 1 / 2.2);

      return color;
   },
   sRGBToLinear (color = new Color3 ())
   {
      color [_r] = Math .pow (this [_r], 2.2);
      color [_g] = Math .pow (this [_g], 2.2);
      color [_b] = Math .pow (this [_b], 2.2);

      return color;
   },
   toString ()
   {
      return this [_r] + " " +
             this [_g] + " " +
             this [_b];
   },
});

for (const key of Object .keys (Color3 .prototype))
   Object .defineProperty (Color3 .prototype, key, { enumerable: false });

const r = {
   get () { return this [_r]; },
   set (value) { this [_r] = value; },
};

const g = {
   get () { return this [_g]; },
   set (value) { this [_g] = value; },
};

const b = {
   get () { return this [_b]; },
   set (value) { this [_b] = value; },
};

Object .defineProperties (Color3 .prototype,
{
   length: { value: 3 },
   0: r,
   1: g,
   2: b,
   r: Object .assign ({ enumerable: true }, r),
   g: Object .assign ({ enumerable: true }, g),
   b: Object .assign ({ enumerable: true }, b),
});

Object .assign (Color3,
{
   BLACK: Object .freeze (new Color3 ()),
   WHITE: Object .freeze (new Color3 (1)),
   HSV (h, s, v)
   {
      const color = Object .create (this .prototype);
      color .setHSV (h, s, v);
      return color;
   },
   lerp (a, b, t, r)
   {
      // Linearly interpolate in HSV space between source color @a a and destination color @a b by an amount of @a t.
      // Source and destination color must be in HSV space. The resulting HSV color is stored in @a r.

      let
         [ha, sa, va] = a,
         [hb, sb, vb] = b;

      if (sa === 0)
         ha = hb;

      if (sb === 0)
         hb = ha;

      const range = Math .abs (hb - ha);

      if (range <= Math .PI)
      {
         r [0] = ha + t * (hb - ha);
         r [1] = sa + t * (sb - sa);
         r [2] = va + t * (vb - va);
         return r;
      }

      const
         PI2  = Math .PI * 2,
         step = (PI2 - range) * t;

      let h = ha < hb ? ha - step : ha + step;

      if (h < 0)
         h += PI2;

      else if (h > PI2)
         h -= PI2;

      r [0] = h;
      r [1] = sa + t * (sb - sa);
      r [2] = va + t * (vb - va);
      return r;
   },
});

const __default__ = Color3;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_x_ite_Namespace_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .add ("Color3", __default__));

/***/ },

/***/ 2228
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Base_X3DInfoArray_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(3046);
/* harmony import */ var _X3DExportedNode_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(7437);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(6334);



function ExportedNodesArray (values = [ ])
{
   return _Base_X3DInfoArray_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .call (this, Array .from (values, value => [value .getExportedName (), value]), _X3DExportedNode_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A);
}

Object .setPrototypeOf (ExportedNodesArray .prototype, _Base_X3DInfoArray_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .prototype);

for (const key of Object .keys (ExportedNodesArray .prototype))
   Object .defineProperty (ExportedNodesArray .prototype, key, { enumerable: false });

Object .defineProperties (ExportedNodesArray,
{
   typeName:
   {
      value: "ExportedNodesArray",
      enumerable: true,
   },
});

const __default__ = ExportedNodesArray;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .add ("ExportedNodesArray", __default__));

/***/ },

/***/ 2310
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   l: () => (/* binding */ getUniqueName)
/* harmony export */ });
const getUniqueName = function (map, name = "")
{
   name = String (name);

   if (name && !map .has (name))
      return name;

   name = name .replace (/_\d+$/, "");

   if (name && !map .has (name))
      return name;

   let
      newName = "",
      lo,
      hi = 1;

   do
   {
      lo   = hi;
      hi <<= 1;

      newName = `${name}_${lo}`;
   }
   while (map .has (newName));

   lo >>>= 1;
   hi >>>= 1;

   if (lo && hi)
   {
      while (lo < hi)
      {
         const m = (lo + hi) >>> 1;

         if (map .has (`${name}_${m}`))
            lo = m + 1;
         else
            hi = m;
      }

      newName = `${name}_${lo}`;
   }

   return newName;
};


/***/ },

/***/ 2406
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _x_ite_Namespace_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6334);
const
   extents1 = { min: 0, max: 0 },
   extents2 = { min: 0, max: 0 };

/**
 *  Class to represent the Separating Axis Theorem.
 */
function SAT () { }

SAT .isSeparated = function (axes, points1, points2)
{
   // https://gamedev.stackexchange.com/questions/25397/obb-vs-obb-collision-detection

   for (const axis of axes)
   {
      project (points1, axis, extents1);
      project (points2, axis, extents2);

      if (overlaps (extents1 .min, extents1 .max, extents2 .min, extents2 .max))
         continue;

      return true;
   }

   return false;
};

///  Projects @a points to @a axis and returns the minimum and maximum bounds.
function project (points, axis, extents)
{
   extents .min = Number .POSITIVE_INFINITY;
   extents .max = Number .NEGATIVE_INFINITY;

   for (const point of points)
   {
      // Just dot it to get the min and max along this axis.
      // NOTE: the axis must be normalized to get accurate projections to calculate the MTV, but if it is only needed to
      // know whether it overlaps, every axis can be used.

      const dotVal = point .dot (axis);

      if (dotVal < extents .min)
         extents .min = dotVal;

      if (dotVal > extents .max)
         extents .max = dotVal;
   }
}

///  Returns true if both ranges overlap, otherwise false.
function overlaps (min1, max1, min2, max2)
{
   return is_between (min2, min1, max1) || is_between (min1, min2, max2);
}

///  Returns true if @a value is between @a lowerBound and @a upperBound, otherwise false.
function is_between (value, lowerBound, upperBound)
{
   return lowerBound <= value && value <= upperBound;
}

const __default__ = SAT;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_x_ite_Namespace_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .add ("SAT", __default__));

/***/ },

/***/ 2476
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Fields_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(3515);
/* harmony import */ var _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(2914);
/* harmony import */ var _Base_FieldDefinitionArray_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(9572);
/* harmony import */ var _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(8450);
/* harmony import */ var _X3DInterpolatorNode_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(3066);
/* harmony import */ var _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(4946);
/* harmony import */ var _standard_Math_Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(7910);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(6334);








function PositionInterpolator (executionContext)
{
   _X3DInterpolatorNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .call (this, executionContext);

   this .addType (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .PositionInterpolator);
}

Object .assign (Object .setPrototypeOf (PositionInterpolator .prototype, _X3DInterpolatorNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .prototype),
{
   initialize ()
   {
      _X3DInterpolatorNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .prototype .initialize .call (this);

      this ._keyValue .addInterest ("set_keyValue__", this);
   },
   set_keyValue__ ()
   {
      const
         key      = this ._key,
         keyValue = this ._keyValue;

      if (keyValue .length < key .length)
         keyValue .resize (key .length, keyValue .length ? keyValue [keyValue .length - 1] : new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFVec3f ());

      // If there was already an set_fraction event in this frame, send a new value_changed to prevent glitches.
      if (this ._set_fraction .getModificationTime () >= this .getBrowser () .getCurrentTime ())
         this .set_fraction__ ();
   },
   interpolate: (() =>
   {
      const keyValue = new _standard_Math_Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A ();

      return function (index0, index1, weight)
      {
         this ._value_changed = keyValue .assign (this ._keyValue [index0] .getValue ()) .lerp (this ._keyValue [index1] .getValue (), weight);
      };
   })(),
});

Object .defineProperties (PositionInterpolator,
{
   ... _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .getStaticProperties ("PositionInterpolator", "Interpolation", 1, "children", "2.0"),
   fieldDefinitions:
   {
      value: new _Base_FieldDefinitionArray_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A ([
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .inputOutput, "metadata",      new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFNode ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .inputOnly,   "set_fraction",  new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFFloat ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .inputOutput, "key",           new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFFloat ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .inputOutput, "keyValue",      new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFVec3f ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .outputOnly,  "value_changed", new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFVec3f ()),
      ]),
      enumerable: true,
   },
});

const __default__ = PositionInterpolator;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .add ("PositionInterpolator", __default__));

/***/ },

/***/ 2588
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Fields_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(3515);
/* harmony import */ var _Base_X3DBaseNode_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(7906);
/* harmony import */ var _Components_Core_X3DPrototypeInstance_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(5397);
/* harmony import */ var _Fields_SFNodeCache_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(7149);
/* harmony import */ var _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(4946);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(6334);






const
   _appInfo       = Symbol (),
   _documentation = Symbol ();

function X3DProtoDeclarationNode (executionContext)
{
   _Base_X3DBaseNode_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .call (this, executionContext);

   this .addType (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .X3DProtoDeclarationNode);

   this .addChildObjects (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .outputOnly, "updateInstances", new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFTime ());

   // Private properties

   this [_appInfo]       = "";
   this [_documentation] = "";
}

Object .assign (Object .setPrototypeOf (X3DProtoDeclarationNode .prototype, _Base_X3DBaseNode_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .prototype),
{
   canUserDefinedFields ()
   {
      return true;
   },
   getAppInfo ()
   {
      return this [_appInfo];
   },
   setAppInfo (value)
   {
      this [_appInfo] = String (value);
   },
   getDocumentation ()
   {
      return this [_documentation];
   },
   setDocumentation (value)
   {
      this [_documentation] = String (value);
   },
   createInstance (executionContext, setup = true /* non-public argument */)
   {
      if (setup === false)
      {
         return new _Components_Core_X3DPrototypeInstance_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A (executionContext, this);
      }
      else
      {
         const instance = new _Components_Core_X3DPrototypeInstance_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A (executionContext, this);

         instance .setup ();

         return _Fields_SFNodeCache_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .get (instance);
      }
   },
   newInstance ()
   {
      return this .createInstance (this .getExecutionContext ());
   },
   requestUpdateInstances ()
   {
      this ._updateInstances = Date .now () / 1000;
   },
   updateInstances ()
   {
      this ._updateInstances .processEvent ();
   },
});

for (const key of Object .keys (X3DProtoDeclarationNode .prototype))
   Object .defineProperty (X3DProtoDeclarationNode .prototype, key, { enumerable: false });

Object .defineProperties (X3DProtoDeclarationNode .prototype,
{
   name:
   {
      get: X3DProtoDeclarationNode .prototype .getName,
      enumerable: true,
   },
   fields:
   {
      get: X3DProtoDeclarationNode .prototype .getFieldDefinitions,
      enumerable: true,
   },
   appInfo:
   {
      get: X3DProtoDeclarationNode .prototype .getAppInfo,
      set: X3DProtoDeclarationNode .prototype .setAppInfo,
      enumerable: true,
   },
   documentation:
   {
      get: X3DProtoDeclarationNode .prototype .getDocumentation,
      set: X3DProtoDeclarationNode .prototype .setDocumentation,
      enumerable: true,
   },
});

Object .defineProperties (X3DProtoDeclarationNode,
{
   typeName:
   {
      value: "X3DProtoDeclarationNode",
      enumerable: true,
   },
});

_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .addConstant (X3DProtoDeclarationNode .typeName);

const __default__ = X3DProtoDeclarationNode;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .add ("X3DProtoDeclarationNode", __default__));

/***/ },

/***/ 2597
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Vector3_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(7910);
/* harmony import */ var _Vector4_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(7591);
/* harmony import */ var _Quaternion_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(4556);
/* harmony import */ var _Rotation4_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(4580);
/* harmony import */ var _Matrix3_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(1224);
/* harmony import */ var _Algorithms_eigen_decomposition_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(4682);
/* harmony import */ var _x_ite_Namespace_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(6334);







function Matrix4 (... args)
{
   if (args .length)
   {
      for (let i = 0; i < 16; ++ i)
         this [i] = args [i];
   }
   else
   {
      this .identity ();
   }
}

Object .assign (Matrix4 .prototype,
{
   *[Symbol .iterator] ()
   {
      for (let i = 0; i < 16; ++ i)
         yield this [i];
   },
   copy ()
   {
      const copy = Object .create (Matrix4 .prototype);

      for (let i = 0; i < 16; ++ i)
         copy [i] = this [i];

      return copy;
   },
   assign (matrix)
   {
      for (let i = 0; i < 16; ++ i)
         this [i] = matrix [i];

      return this;
   },
   equals (matrix)
   {
      return this [ 0] === matrix [ 0] &&
             this [ 1] === matrix [ 1] &&
             this [ 2] === matrix [ 2] &&
             this [ 3] === matrix [ 3] &&
             this [ 4] === matrix [ 4] &&
             this [ 5] === matrix [ 5] &&
             this [ 6] === matrix [ 6] &&
             this [ 7] === matrix [ 7] &&
             this [ 8] === matrix [ 8] &&
             this [ 9] === matrix [ 9] &&
             this [10] === matrix [10] &&
             this [11] === matrix [11] &&
             this [12] === matrix [12] &&
             this [13] === matrix [13] &&
             this [14] === matrix [14] &&
             this [15] === matrix [15];
   },
   set1 (r, c, value)
   {
      this [r * this .order + c] = value;

      return this;
   },
   get1 (r, c)
   {
      return this [r * this .order + c];
   },
   set: (() =>
   {
      const
         invScaleOrientation = new _Rotation4_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A (),
         invCenter           = new _Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A ();

      return function (translation, rotation, scale, scaleOrientation, center)
      {
         this .identity ();

         switch (arguments .length)
         {
            case 1:
            {
               if (translation && !translation .equals (_Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .ZERO))
                  this .translate (translation);

               break;
            }
            case 2:
            {
               if (translation && !translation .equals (_Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .ZERO))
                  this .translate (translation);

               if (rotation && !rotation .equals (_Rotation4_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .IDENTITY))
                  this .rotate (rotation);

               break;
            }
            case 3:
            {
               if (translation && !translation .equals (_Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .ZERO))
                  this .translate (translation);

               if (rotation && !rotation .equals (_Rotation4_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .IDENTITY))
                  this .rotate (rotation);

               if (scale && !scale .equals (_Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .ONE))
                  this .scale (scale);

               break;
            }
            case 4:
            {
               if (translation && !translation .equals (_Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .ZERO))
                  this .translate (translation);

               if (rotation && !rotation .equals (_Rotation4_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .IDENTITY))
                  this .rotate (rotation);

               if (scale && !scale .equals (_Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .ONE))
               {
                  if (scaleOrientation && !scaleOrientation .equals (_Rotation4_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .IDENTITY))
                  {
                     this .rotate (scaleOrientation);
                     this .scale (scale);
                     this .rotate (invScaleOrientation .assign (scaleOrientation) .inverse ());
                  }
                  else
                  {
                     this .scale (scale);
                  }
               }

               break;
            }
            case 5:
            {
               // P' = T * C * R * SR * S * -SR * -C * P
               if (translation && !translation .equals (_Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .ZERO))
                  this .translate (translation);

               const hasCenter = center && !center .equals (_Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .ZERO);

               if (hasCenter)
                  this .translate (center);

               if (rotation && !rotation .equals (_Rotation4_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .IDENTITY))
                  this .rotate (rotation);

               if (scale && !scale .equals (_Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .ONE))
               {
                  if (scaleOrientation && !scaleOrientation .equals (_Rotation4_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .IDENTITY))
                  {
                     this .rotate (scaleOrientation);
                     this .scale (scale);
                     this .rotate (invScaleOrientation .assign (scaleOrientation) .inverse ());
                  }
                  else
                  {
                     this .scale (scale);
                  }
               }

               if (hasCenter)
                  this .translate (invCenter .assign (center) .negate ());

               break;
            }
            case 16:
            {
               for (let i = 0; i < 16; ++ i)
                  this [i] = arguments [i];

               break;
            }
         }

         return this;
      };
   })(),
   get: (() =>
   {
      const c = new _Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A ();

      return function (translation, rotation, scale, scaleOrientation, center)
      {
         switch (arguments .length)
         {
            case 1:
            {
               translation .set (this [12], this [13], this [14]);
               break;
            }
            case 2:
            case 3:
            case 4:
            {
               this .factor (translation, rotation, scale, scaleOrientation);
               break;
            }
            case 5:
            {
               if (center)
               {
                  m .set (c .assign (center) .negate ());
                  m .multLeft (this);
                  m .translate (center);
                  m .get (translation, rotation, scale, scaleOrientation);
               }
               else
               {
                  this .factor (translation, rotation, scale, scaleOrientation);
               }

               break;
            }
         }
      };
   })(),
   setRotation (rotation)
   {
      return this .setQuaternion (rotation .getQuaternion (q));
   },
   setQuaternion (quaternion)
   {
      const
         { x, y, z, w } = quaternion,
         A = y * y,
         B = z * z,
         C = x * y,
         D = z * w,
         E = z * x,
         F = y * w,
         G = x * x,
         H = y * z,
         I = x * w;

      this [0]  = 1 - 2 * (A + B);
      this [1]  = 2 * (C + D);
      this [2]  = 2 * (E - F);
      this [3]  = 0;
      this [4]  = 2 * (C - D);
      this [5]  = 1 - 2 * (B + G);
      this [6]  = 2 * (H + I);
      this [7]  = 0;
      this [8]  = 2 * (E + F);
      this [9]  = 2 * (H - I);
      this [10] = 1 - 2 * (A + G);
      this [11] = 0;
      this [12] = 0;
      this [13] = 0;
      this [14] = 0;
      this [15] = 1;

      return this;
   },
   factor: (() =>
   {
      const
         s  = new _Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A (),
         si = new _Matrix3_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A (),
         so = new _Matrix3_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A (),
         b  = new _Matrix3_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A ();

      const eigen = { values: [ ], vectors: [[ ], [ ], [ ]] };

      return function (translation, rotation, scale, scaleOrientation)
      {
         // (1) Get translation.
         translation ?.set (this [12], this [13], this [14]);

         // (2) Create 3x3 matrix.
         const a = this .submatrix;

         // (3) Compute det A. If negative, set sign = -1, else sign = 1
         const det      = a .determinant ();
         const det_sign = det < 0 ? -1 : 1;

         // (4) B = A * !A  (here !A means A transpose)
         b .assign (a) .transpose () .multLeft (a);
         const e = (0,_Algorithms_eigen_decomposition_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A) (b, eigen);

         // Find min / max eigenvalues and do ratio test to determine singularity.

         so .set (e .vectors [0] [0], e .vectors [1] [0], e .vectors [2] [0],
                  e .vectors [0] [1], e .vectors [1] [1], e .vectors [2] [1],
                  e .vectors [0] [2], e .vectors [1] [2], e .vectors [2] [2]);

         scaleOrientation ?.setMatrix (so);

         // Compute s = sqrt(eigen values), with sign. Set si = s-inverse

         s .set (det_sign * Math .sqrt (e .values [0]),
                 det_sign * Math .sqrt (e .values [1]),
                 det_sign * Math .sqrt (e .values [2]));

         scale ?.assign (s);

         if (rotation)
         {
            si [0] = 1 / s .x;
            si [4] = 1 / s .y;
            si [8] = 1 / s .z;

            // (5) Compute U = !R ~S R A.
            rotation .setMatrix (a .multLeft (so) .multLeft (si) .multLeft (so .transpose ()));
         }
      };
   })(),
   determinant3 ()
   {
      const { 0: m00, 1: m01, 2: m02,
              4: m04, 5: m05, 6: m06,
              8: m08, 9: m09, 10: m10 } = this;

      return m00 * (m05 * m10 - m06 * m09) -
             m01 * (m04 * m10 - m06 * m08) +
             m02 * (m04 * m09 - m05 * m08);
   },
   determinant ()
   {
      const
         { 0: m00, 1: m01, 2: m02, 3: m03, 4: m04, 5: m05, 6: m06, 7: m07,
           8: m08, 9: m09, 10: m10, 11: m11, 12: m12, 13: m13, 14: m14, 15: m15 } = this,
         b = m10 * m15,
         c = m14 * m11,
         d = m06 * m15,
         e = m14 * m07,
         f = m06 * m11,
         g = m10 * m07,
         h = m02 * m15,
         i = m14 * m03,
         j = m02 * m11,
         o = m10 * m03,
         r = m02 * m07,
         x = m06 * m03,
         H = b * m05 + e * m09 + f * m13 - (c * m05) - (d * m09) - (g * m13),
         I = c * m01 + h * m09 + o * m13 - (b * m01) - (i * m09) - (j * m13),
         J = d * m01 + i * m05 + r * m13 - (e * m01) - (h * m05) - (x * m13),
         K = g * m01 + j * m05 + x * m09 - (f * m01) - (o * m05) - (r * m09);

      return m00 * H + m04 * I + m08 * J + m12 * K;
   },
   transpose ()
   {
      let tmp;

      tmp = this [ 1]; this [ 1] = this [ 4]; this [ 4] = tmp;
      tmp = this [ 2]; this [ 2] = this [ 8]; this [ 8] = tmp;
      tmp = this [ 3]; this [ 3] = this [12]; this [12] = tmp;
      tmp = this [ 6]; this [ 6] = this [ 9]; this [ 9] = tmp;
      tmp = this [ 7]; this [ 7] = this [13]; this [13] = tmp;
      tmp = this [11]; this [11] = this [14]; this [14] = tmp;

      return this;
   },
   inverse ()
   {
      // Complexity 43 +, 40 -, 140 *. 1 /

      const
         { 0: m00, 1: m01, 2: m02, 3: m03, 4: m04, 5: m05, 6: m06, 7: m07,
           8: m08, 9: m09, 10: m10, 11: m11, 12: m12, 13: m13, 14: m14, 15: m15 } = this,
         b = m10 * m15,
         c = m14 * m11,
         d = m06 * m15,
         e = m14 * m07,
         f = m06 * m11,
         g = m10 * m07,
         h = m02 * m15,
         i = m14 * m03,
         j = m02 * m11,
         o = m10 * m03,
         r = m02 * m07,
         x = m06 * m03,
         t = m08 * m13,
         p = m12 * m09,
         v = m04 * m13,
         s = m12 * m05,
         y = m04 * m09,
         z = m08 * m05,
         A = m00 * m13,
         C = m12 * m01,
         D = m00 * m09,
         E = m08 * m01,
         F = m00 * m05,
         G = m04 * m01,
         H = b * m05 + e * m09 + f * m13 - ((c * m05) + (d * m09) + (g * m13)),
         I = c * m01 + h * m09 + o * m13 - ((b * m01) + (i * m09) + (j * m13)),
         J = d * m01 + i * m05 + r * m13 - ((e * m01) + (h * m05) + (x * m13)),
         K = g * m01 + j * m05 + x * m09 - ((f * m01) + (o * m05) + (r * m09));

      let B = m00 * H + m04 * I + m08 * J + m12 * K;

      // if (B === 0) ... determinant is zero.

      B = 1 / B;

      this [ 0] = B * H;
      this [ 1] = B * I;
      this [ 2] = B * J;
      this [ 3] = B * K;
      this [ 4] = B * (c * m04 + d * m08 + g * m12 - (b * m04) - (e * m08) - (f * m12));
      this [ 5] = B * (b * m00 + i * m08 + j * m12 - (c * m00) - (h * m08) - (o * m12));
      this [ 6] = B * (e * m00 + h * m04 + x * m12 - (d * m00) - (i * m04) - (r * m12));
      this [ 7] = B * (f * m00 + o * m04 + r * m08 - (g * m00) - (j * m04) - (x * m08));
      this [ 8] = B * (t * m07 + s * m11 + y * m15 - (p * m07) - (v * m11) - (z * m15));
      this [ 9] = B * (p * m03 + A * m11 + E * m15 - (t * m03) - (C * m11) - (D * m15));
      this [10] = B * (v * m03 + C * m07 + F * m15 - (s * m03) - (A * m07) - (G * m15));
      this [11] = B * (z * m03 + D * m07 + G * m11 - (y * m03) - (E * m07) - (F * m11));
      this [12] = B * (v * m10 + z * m14 + p * m06 - (y * m14) - (t * m06) - (s * m10));
      this [13] = B * (D * m14 + t * m02 + C * m10 - (A * m10) - (E * m14) - (p * m02));
      this [14] = B * (A * m06 + G * m14 + s * m02 - (F * m14) - (v * m02) - (C * m06));
      this [15] = B * (F * m10 + y * m02 + E * m06 - (D * m06) - (G * m10) - (z * m02));

      return this;
   },
   multLeft (matrix)
   {
      // Complexity 48 +, 64 *.

      const
         { 0: a00, 1: a01, 2: a02, 3: a03, 4: a04, 5: a05, 6: a06, 7: a07,
           8: a08, 9: a09, 10: a10, 11: a11, 12: a12, 13: a13, 14: a14, 15: a15 } = this,
         { 0: b00, 1: b01, 2: b02, 3: b03, 4: b04, 5: b05, 6: b06, 7: b07,
           8: b08, 9: b09, 10: b10, 11: b11, 12: b12, 13: b13, 14: b14, 15: b15 } = matrix;

      this [ 0] = a00 * b00 + a04 * b01 + a08 * b02 + a12 * b03;
      this [ 1] = a01 * b00 + a05 * b01 + a09 * b02 + a13 * b03;
      this [ 2] = a02 * b00 + a06 * b01 + a10 * b02 + a14 * b03;
      this [ 3] = a03 * b00 + a07 * b01 + a11 * b02 + a15 * b03;
      this [ 4] = a00 * b04 + a04 * b05 + a08 * b06 + a12 * b07;
      this [ 5] = a01 * b04 + a05 * b05 + a09 * b06 + a13 * b07;
      this [ 6] = a02 * b04 + a06 * b05 + a10 * b06 + a14 * b07;
      this [ 7] = a03 * b04 + a07 * b05 + a11 * b06 + a15 * b07;
      this [ 8] = a00 * b08 + a04 * b09 + a08 * b10 + a12 * b11;
      this [ 9] = a01 * b08 + a05 * b09 + a09 * b10 + a13 * b11;
      this [10] = a02 * b08 + a06 * b09 + a10 * b10 + a14 * b11;
      this [11] = a03 * b08 + a07 * b09 + a11 * b10 + a15 * b11;
      this [12] = a00 * b12 + a04 * b13 + a08 * b14 + a12 * b15;
      this [13] = a01 * b12 + a05 * b13 + a09 * b14 + a13 * b15;
      this [14] = a02 * b12 + a06 * b13 + a10 * b14 + a14 * b15;
      this [15] = a03 * b12 + a07 * b13 + a11 * b14 + a15 * b15;

      return this;
   },
   multRight (matrix)
   {
      // Complexity 48 +, 64 *.

      const
         { 0: a00, 1: a01, 2: a02, 3: a03, 4: a04, 5: a05, 6: a06, 7: a07,
           8: a08, 9: a09, 10: a10, 11: a11, 12: a12, 13: a13, 14: a14, 15: a15 } = this,
         { 0: b00, 1: b01, 2: b02, 3: b03, 4: b04, 5: b05, 6: b06, 7: b07,
           8: b08, 9: b09, 10: b10, 11: b11, 12: b12, 13: b13, 14: b14, 15: b15 } = matrix;

      this [ 0] = a00 * b00 + a01 * b04 + a02 * b08 + a03 * b12;
      this [ 1] = a00 * b01 + a01 * b05 + a02 * b09 + a03 * b13;
      this [ 2] = a00 * b02 + a01 * b06 + a02 * b10 + a03 * b14;
      this [ 3] = a00 * b03 + a01 * b07 + a02 * b11 + a03 * b15;
      this [ 4] = a04 * b00 + a05 * b04 + a06 * b08 + a07 * b12;
      this [ 5] = a04 * b01 + a05 * b05 + a06 * b09 + a07 * b13;
      this [ 6] = a04 * b02 + a05 * b06 + a06 * b10 + a07 * b14;
      this [ 7] = a04 * b03 + a05 * b07 + a06 * b11 + a07 * b15;
      this [ 8] = a08 * b00 + a09 * b04 + a10 * b08 + a11 * b12;
      this [ 9] = a08 * b01 + a09 * b05 + a10 * b09 + a11 * b13;
      this [10] = a08 * b02 + a09 * b06 + a10 * b10 + a11 * b14;
      this [11] = a08 * b03 + a09 * b07 + a10 * b11 + a11 * b15;
      this [12] = a12 * b00 + a13 * b04 + a14 * b08 + a15 * b12;
      this [13] = a12 * b01 + a13 * b05 + a14 * b09 + a15 * b13;
      this [14] = a12 * b02 + a13 * b06 + a14 * b10 + a15 * b14;
      this [15] = a12 * b03 + a13 * b07 + a14 * b11 + a15 * b15;

      return this;
   },
   multVecMatrix (vector)
   {
      if (vector .length === 3)
      {
         const
            { x, y, z } = vector,
            w = 1 / (x * this [3] + y * this [7] + z * this [11] + this [15]);

         vector .x = (x * this [0] + y * this [4] + z * this [ 8] + this [12]) * w;
         vector .y = (x * this [1] + y * this [5] + z * this [ 9] + this [13]) * w;
         vector .z = (x * this [2] + y * this [6] + z * this [10] + this [14]) * w;

         return vector;
      }
      else
      {
         const { x, y, z, w } = vector;

         vector .x = x * this [0] + y * this [4] + z * this [ 8] + w * this [12];
         vector .y = x * this [1] + y * this [5] + z * this [ 9] + w * this [13];
         vector .z = x * this [2] + y * this [6] + z * this [10] + w * this [14];
         vector .w = x * this [3] + y * this [7] + z * this [11] + w * this [15];

         return vector;
      }
   },
   multMatrixVec (vector)
   {
      if (vector .length === 3)
      {
         const
            { x, y, z } = vector,
            w = 1 / (x * this [12] + y * this [13] + z * this [14] + this [15]);

         vector .x = (x * this [0] + y * this [1] + z * this [ 2] + this [ 3]) * w;
         vector .y = (x * this [4] + y * this [5] + z * this [ 6] + this [ 7]) * w;
         vector .z = (x * this [8] + y * this [9] + z * this [10] + this [11]) * w;

         return vector;
      }
      else
      {
         const { x, y, z, w } = vector;

         vector .x = x * this [ 0] + y * this [ 1] + z * this [ 2] + w * this [ 3];
         vector .y = x * this [ 4] + y * this [ 5] + z * this [ 6] + w * this [ 7];
         vector .z = x * this [ 8] + y * this [ 9] + z * this [10] + w * this [11];
         vector .w = x * this [12] + y * this [13] + z * this [14] + w * this [15];

         return vector;
      }
   },
   multDirMatrix (vector)
   {
      const { x, y, z } = vector;

      vector .x = x * this [0] + y * this [4] + z * this [ 8];
      vector .y = x * this [1] + y * this [5] + z * this [ 9];
      vector .z = x * this [2] + y * this [6] + z * this [10];

      return vector;
   },
   multMatrixDir (vector)
   {
      const { x, y, z } = vector;

      vector .x = x * this [0] + y * this [1] + z * this [ 2];
      vector .y = x * this [4] + y * this [5] + z * this [ 6];
      vector .z = x * this [8] + y * this [9] + z * this [10];

      return vector;
   },
   identity ()
   {
      this [ 0] = 1; this [ 1] = 0; this [ 2] = 0; this [ 3] = 0;
      this [ 4] = 0; this [ 5] = 1; this [ 6] = 0; this [ 7] = 0;
      this [ 8] = 0; this [ 9] = 0; this [10] = 1; this [11] = 0;
      this [12] = 0; this [13] = 0; this [14] = 0; this [15] = 1;

      return this;
   },
   translate (translation)
   {
      const { x, y, z } = translation;

      this [12] += this [ 0] * x + this [ 4] * y + this [ 8] * z;
      this [13] += this [ 1] * x + this [ 5] * y + this [ 9] * z;
      this [14] += this [ 2] * x + this [ 6] * y + this [10] * z;

      return this;
   },
   rotate (rotation)
   {
      return this .multLeft (m .setQuaternion (rotation .getQuaternion (q)));
   },
   scale (scale)
   {
      const { x, y, z } = scale;

      this [ 0] *= x;
      this [ 4] *= y;
      this [ 8] *= z;

      this [ 1] *= x;
      this [ 5] *= y;
      this [ 9] *= z;

      this [ 2] *= x;
      this [ 6] *= y;
      this [10] *= z;

      return this;
   },
   toString ()
   {
      return Array .prototype .join .call (this, " ");
   },
});

for (const key of Object .keys (Matrix4 .prototype))
   Object .defineProperty (Matrix4 .prototype, key, { enumerable: false });

Object .defineProperties (Matrix4 .prototype,
{
   order: { value: 4 },
   length: { value: 16 },
   x:
   {
      get: (() =>
      {
         const vector = new _Vector4_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A ();

         return function () { return vector .set (this [0], this [1], this [2], this [3]); };
      })(),
   },
   y:
   {
      get: (() =>
      {
         const vector = new _Vector4_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A ();

         return function () { return vector .set (this [4], this [5], this [6], this [7]); };
      })(),
   },
   z:
   {
      get: (() =>
      {
         const vector = new _Vector4_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A ();

         return function () { return vector .set (this [8], this [9], this [10], this [11]); };
      })(),
   },
   w:
   {
      get: (() =>
      {
         const vector = new _Vector4_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A ();

         return function () { return vector .set (this [12], this [13], this [14], this [15]); };
      })(),
   },
   xAxis:
   {
      get: (() =>
      {
         const vector = new _Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A ();

         return function () { return vector .set (this [0], this [1], this [2]); };
      })(),
   },
   yAxis:
   {
      get: (() =>
      {
         const vector = new _Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A ();

         return function () { return vector .set (this [4], this [5], this [6]); };
      })(),
   },
   zAxis:
   {
      get: (() =>
      {
         const vector = new _Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A ();

         return function () { return vector .set (this [8], this [9], this [10]); };
      })(),
   },
   origin:
   {
      get: (() =>
      {
         const vector = new _Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A ();

         return function () { return vector .set (this [12], this [13], this [14]); };
      })(),
   },
   submatrix:
   {
      get: (() =>
      {
         const matrix = new _Matrix3_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A ();

         return function ()
         {
            matrix [0] = this [0]; matrix [1] = this [1]; matrix [2] = this [ 2];
            matrix [3] = this [4]; matrix [4] = this [5]; matrix [5] = this [ 6];
            matrix [6] = this [8]; matrix [7] = this [9]; matrix [8] = this [10];
            return matrix;
         };
      })(),
   },
});

Object .assign (Matrix4,
{
   IDENTITY: Object .freeze (new Matrix4 ()),
   Rotation (rotation)
   {
      return Object .create (this .prototype) .setQuaternion (rotation .getQuaternion (q));
   },
   Quaternion (quaternion)
   {
      return Object .create (this .prototype) .setQuaternion (quaternion);
   },
   Matrix3 (matrix)
   {
      return new Matrix4 (matrix [0], matrix [1], 0, 0,
                          matrix [3], matrix [4], 0, 0,
                          0, 0, 1, 0,
                          matrix [6], matrix [7], 0, 1);
   },
   SubMatrix (matrix)
   {
      return new Matrix4 (matrix [0], matrix [1], matrix [2], 0,
                          matrix [3], matrix [4], matrix [5], 0,
                          matrix [6], matrix [7], matrix [8], 0,
                          0, 0, 0, 1);
   },
});

const
   q = new _Quaternion_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A (),
   m = new Matrix4 ();

const __default__ = Matrix4;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_x_ite_Namespace_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .add ("Matrix4", __default__));

/***/ },

/***/ 2676
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Fields_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(3515);
/* harmony import */ var _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(2914);
/* harmony import */ var _Base_FieldDefinitionArray_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(9572);
/* harmony import */ var _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(8450);
/* harmony import */ var _Core_X3DBindableNode_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(3869);
/* harmony import */ var _X3DFogObject_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(6364);
/* harmony import */ var _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(4946);
/* harmony import */ var _standard_Math_Numbers_Matrix4_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(2597);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(6334);









function Fog (executionContext)
{
   _Core_X3DBindableNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .call (this, executionContext);
   _X3DFogObject_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A    .call (this, executionContext);

   this .addType (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .Fog);

   this .modelMatrix = new _standard_Math_Numbers_Matrix4_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A ();
}

Object .assign (Object .setPrototypeOf (Fog .prototype, _Core_X3DBindableNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .prototype),
   _X3DFogObject_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .prototype,
{
   initialize ()
   {
      _Core_X3DBindableNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .prototype .initialize .call (this);
      _X3DFogObject_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A    .prototype .initialize .call (this);
   },
   getModelMatrix ()
   {
      return this .modelMatrix;
   },
   traverse (type, renderObject)
   {
      renderObject .getLayer () .getFogs () .push (this);

      this .modelMatrix .assign (renderObject .getModelViewMatrix () .get ());
   },
   dispose ()
   {
      _X3DFogObject_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A    .prototype .dispose .call (this);
      _Core_X3DBindableNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .prototype .dispose .call (this);
   },
});

Object .defineProperties (Fog,
{
   ... _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .getStaticProperties ("Fog", "EnvironmentalEffects", 2, "children", "2.0"),
   fieldDefinitions:
   {
      value: new _Base_FieldDefinitionArray_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A ([
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .inputOutput, "metadata",        new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFNode ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .inputOnly,   "set_bind",        new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFBool ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .inputOutput, "fogType",         new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFString ("LINEAR")),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .inputOutput, "color",           new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFColor (1, 1, 1)),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .inputOutput, "visibilityStart", new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFFloat ()), // experimental
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .inputOutput, "visibilityRange", new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFFloat ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .outputOnly,  "isBound",         new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFBool ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .outputOnly,  "bindTime",        new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFTime ()),
      ]),
      enumerable: true,
   },
});

const __default__ = Fog;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_8__/* ["default"] */ .A .add ("Fog", __default__));

/***/ },

/***/ 2914
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _X3DObject_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(7092);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(6334);


const
   _accessType = Symbol (),
   _name       = Symbol (),
   _value      = Symbol ();

function X3DFieldDefinition (accessType, name, value)
{
   this [_accessType] = accessType;
   this [_name]       = name;
   this [_value]      = value;
}

Object .assign (Object .setPrototypeOf (X3DFieldDefinition .prototype, _X3DObject_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .prototype),
{
   getAccessType ()
   {
      return this [_accessType];
   },
   getDataType ()
   {
      return this [_value] .getType ();
   },
   getName ()
   {
      return this [_name];
   },
   getValue ()
   {
      return this [_value];
   },
   getAppInfo ()
   {
      return this [_value] .getAppInfo ();
   },
   setAppInfo (value)
   {
      return this [_value] .setAppInfo (value);
   },
   getDocumentation ()
   {
      return this [_value] .getDocumentation ();
   },
   setDocumentation (value)
   {
      this [_value] .setDocumentation (value);
   },
});

for (const key of Object .keys (X3DFieldDefinition .prototype))
   Object .defineProperty (X3DFieldDefinition .prototype, key, { enumerable: false });

Object .defineProperties (X3DFieldDefinition .prototype,
{
   accessType:
   {
      get: X3DFieldDefinition .prototype .getAccessType,
      enumerable: true,
   },
   dataType:
   {
      get: X3DFieldDefinition .prototype .getDataType,
      enumerable: true,
   },
   name:
   {
      get: X3DFieldDefinition .prototype .getName,
      enumerable: true,
   },
   value:
   {
      get () { return this .getValue () .valueOf (); },
      enumerable: true,
   },
   appInfo:
   {
      get: X3DFieldDefinition .prototype .getAppInfo,
      set: X3DFieldDefinition .prototype .setAppInfo,
      enumerable: true,
   },
   documentation:
   {
      get: X3DFieldDefinition .prototype .getDocumentation,
      set: X3DFieldDefinition .prototype .setDocumentation,
      enumerable: true,
   },
});

Object .defineProperties (X3DFieldDefinition,
{
   typeName:
   {
      value: "X3DFieldDefinition",
      enumerable: true,
   },
});

const __default__ = X3DFieldDefinition;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .add ("X3DFieldDefinition", __default__));

/***/ },

/***/ 2941
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(7910);
/* harmony import */ var _x_ite_Namespace_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(6334);


const Camera =
{
   frustum (l, r, b, t, n, f, matrix)
   {
      const
         r_l = r - l,
         t_b = t - b,
         f_n = f - n,
         n_2 = 2 * n,

         A = (r + l) / r_l,
         B = (t + b) / t_b,
         C = -(f + n) / f_n,
         D = -(n_2 * f) / f_n,
         E = n_2 / r_l,
         F = n_2 / t_b;

      return matrix .set (E, 0, 0, 0,
                          0, F, 0, 0,
                          A, B, C, -1,
                          0, 0, D, 0);
   },
   perspective (fieldOfView, zNear, zFar, width, height, matrix)
   {
      const ratio = Math .tan (fieldOfView / 2) * zNear;

      if (width > height)
      {
         const aspect = width * ratio / height;
         return this .frustum (-aspect, aspect, -ratio, ratio, zNear, zFar, matrix);
      }
      else
      {
         const aspect = height * ratio / width;
         return this .frustum (-ratio, ratio, -aspect, aspect, zNear, zFar, matrix);
      }
   },
   perspective2 (fieldOfView, zNear, zFar, width, height, matrix)
   {
      const ratio = Math .tan (fieldOfView / 2) * zNear;

      return this .frustum (-ratio, ratio, -ratio, ratio, zNear, zFar, matrix);
   },
   ortho (l, r, b, t, n, f, matrix)
   {
      const
         r_l = r - l,
         t_b = t - b,
         f_n = f - n,

         A =  2 / r_l,
         B =  2 / t_b,
         C = -2 / f_n,
         D = -(r + l) / r_l,
         E = -(t + b) / t_b,
         F = -(f + n) / f_n;

      return matrix .set (A, 0, 0, 0,
                          0, B, 0, 0,
                          0, 0, C, 0,
                          D, E, F, 1);
   },
   orthoBox: (() =>
   {
      const
         min = new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A (),
         max = new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A ();

      return function (box, matrix)
      {
         box .getExtents (min, max);

         return this .ortho (min .x, max .x, min .y, max .y, -max .z, -min .z, matrix);
      };
   })(),
};

const __default__ = Camera;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_x_ite_Namespace_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .add ("Camera", __default__));

/***/ },

/***/ 3046
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _X3DChildObject_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(3586);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(6334);


const
   _array     = Symbol (),
   _index     = Symbol (),
   _valueType = Symbol ();

const handler =
{
   get (target, key)
   {
      const value = target [key];

      if (value !== undefined)
         return value;

      if (typeof key === "string")
      {
         const index = +key;

         if (Number .isInteger (index))
            return target [_array] [index];

         return;
      }
   },
   set (target, key, value)
   {
      if (target [key] === undefined)
         return false;

      target [key] = value;
      return true;
   },
   has (target, key)
   {
      if (Number .isInteger (+key))
         return key < target [_array] .length;

      return key in target;
   },
   ownKeys (target)
   {
      return Object .keys (target [_array]);
   },
   getOwnPropertyDescriptor (target, key)
   {
      if (typeof key !== "string")
         return;

      const index = +key;

      if (Number .isInteger (index) && index < target [_array] .length)
      {
         const propertyDescriptor = Object .getOwnPropertyDescriptor (target [_array], key);

         if (propertyDescriptor)
            propertyDescriptor .writable = false;

         return propertyDescriptor;
      }
   },
};

function X3DInfoArray (values, valueType)
{
   const proxy = new Proxy (this, handler);

   _X3DChildObject_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .call (this);

   this [_array]     = [ ];
   this [_index]     = new Map ();
   this [_valueType] = valueType;

   for (const [key, value] of values)
      this .add (key, value);

   return proxy;
}

Object .assign (Object .setPrototypeOf (X3DInfoArray .prototype, _X3DChildObject_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .prototype),
{
   *[Symbol .iterator] ()
   {
      yield* this [_array];
   },
   copy ()
   {
      const copy = new (this .constructor) ();

      copy .assign (this);

      return copy;
   },
   clear ()
   {
      this [_array] .length = 0;
      this [_index] .clear ();

      this .addEvent ();
   },
   assign (array)
   {
      if (!(array instanceof this .constructor))
         throw new Error ("Couldn't assign info array, wrong type.");

      this [_array] = Array .from (array [_array]);
      this [_index] = new Map (array [_index]);

      this .addEvent ();
   },
   equals (array)
   {
      const
         a      = this [_array],
         b      = array [_array],
         length = a .length;

      if (a === b)
         return true;

      if (length !== b .length)
         return false;

      for (let i = 0; i < length; ++ i)
      {
         if (a [i] !== b [i])
            return false;
      }

      return true;
   },
   has (key)
   {
      return this [_index] .has (key);
   },
   get (key)
   {
      return this [_index] .get (key);
   },
   add (key, value)
   {
      if (this [_index] .has (key))
         throw new Error (`Couldn't add value to ${this .getTypeName ()}, key '${key}' already exists.`);

      if (!(value instanceof this [_valueType]))
         throw new Error (`Couldn't add value to ${this .getTypeName ()}, value for key '${key}' has wrong type.`);

      this [_array] .push (value);
      this [_index] .set (key, value);

      this .addEvent ();
   },
   alias (alias, value)
   {
      this [_index] .set (alias, value);

      this .addEvent ();
   },
   update (oldKey, newKey, value)
   {
      // TODO: update alias.

      if (!(value instanceof this [_valueType]))
         throw new Error (`Couldn't update value of ${this .getTypeName ()}, value for key '${key}' has wrong type.`);

      const oldValue = this [_index] .get (oldKey);

      if (oldKey !== newKey)
         this .remove (newKey);

      this [_index] .delete (oldKey);
      this [_index] .set (newKey, value);

      if (oldValue !== undefined)
      {
         const index = this [_array] .indexOf (oldValue);

         if (index > -1)
            this [_array] [index] = value;
      }
      else
      {
         this [_array] .push (value);
      }

      this .addEvent ();
   },
   remove (key)
   {
      // TODO: remove alias.

      const value = this [_index] .get (key);

      if (value === undefined)
         return;

      const index = this [_array] .indexOf (value);

      this [_index] .delete (key);

      if (index > -1)
         this [_array] .splice (index, 1);

      this .addEvent ();
   },
   at: Array .prototype .at,
   // concat: Array .prototype .concat,
   // copyWithin: Array.prototype.copyWithin,
   entries: Array .prototype .entries,
   every: Array .prototype .every,
   // fill: Array .prototype .fill,
   filter (callbackFn, thisArg)
   {
      return new (this .constructor) (Array .prototype .filter .call (this, callbackFn, thisArg));
   },
   find: Array .prototype .find,
   findIndex: Array .prototype .findIndex,
   findLast: Array .prototype .findLast,
   findLastIndex: Array .prototype .findLastIndex,
   flat: Array .prototype .flat,
   flatMap: Array .prototype .flatMap,
   forEach: Array .prototype .forEach,
   includes: Array .prototype .includes,
   indexOf: Array .prototype .indexOf,
   join: Array .prototype .join,
   keys: Array .prototype .keys,
   lastIndexOf: Array .prototype .lastIndexOf,
   map (callbackFn, thisArg)
   {
      return new (this .constructor) (Array .prototype .map .call (this, callbackFn, thisArg));
   },
   reduce: Array .prototype .reduce,
   reduceRight: Array .prototype .reduceRight,
   // reverse: Array .prototype .reverse,
   slice (start, end)
   {
      return new (this .constructor) (Array .prototype .slice .call (this, start, end));
   },
   some: Array .prototype .some,
   // sort: Array .prototype .sort,
   toReversed ()
   {
      return new (this .constructor) ([... this] .reverse ());
   },
   toSorted (compareFn)
   {
      return new (this .constructor) ([... this] .sort (compareFn));
   },
   toSpliced (start, deleteCount, ... insertValues)
   {
      const array = [... this];

      array .splice (start, deleteCount, ... insertValues)

      return new (this .constructor) (array);
   },
   values: Array .prototype .values,
   with (index, value)
   {
      const array = [... this];

      array [index] = value;

      return new (this .constructor) (array);
   },
   toVRMLStream (generator)
   {
      const proto = this .getTypeName () .includes ("Proto");

      for (const value of this [_array])
      {
         try
         {
            value .toVRMLStream (generator);

            generator .Break ();

            if (proto)
               generator .TidyBreak ();
         }
         catch (error)
         {
            // console .error (error);
         }
      }
   },
   toXMLStream (generator)
   {
      for (const value of this [_array])
      {
         try
         {
            value .toXMLStream (generator);

            generator .TidyBreak ();
         }
         catch (error)
         {
            // console .error (error);
         }
      }
   },
   toJSONStream (generator, comma = false)
   {
      for (const value of this [_array])
      {
         try
         {
            if (comma)
               generator .string += ',';

            value .toJSONStream (generator, true);

            comma = true;
         }
         catch
         {
            generator .RemoveComma ();
         }
      }

      return comma;
   },
});

for (const key of Object .keys (X3DInfoArray .prototype))
   Object .defineProperty (X3DInfoArray .prototype, key, { enumerable: false });

Object .defineProperties (X3DInfoArray .prototype,
{
   length:
   {
      get () { return this [_array] .length; },
   },
});

const __default__ = X3DInfoArray;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .add ("X3DInfoArray", __default__));

/***/ },

/***/ 3066
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(8450);
/* harmony import */ var _Core_X3DChildNode_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(266);
/* harmony import */ var _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(4946);
/* harmony import */ var _standard_Math_Algorithm_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(5370);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(6334);





function X3DInterpolatorNode (executionContext)
{
   _Core_X3DChildNode_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .call (this, executionContext);

   this .addType (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .X3DInterpolatorNode);
}

Object .assign (Object .setPrototypeOf (X3DInterpolatorNode .prototype, _Core_X3DChildNode_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .prototype),
{
   setup ()
   {
      // If an X3DInterpolatorNode value_changed outputOnly field is read before it receives any inputs,
      // keyValue[0] is returned if keyValue is not empty. If keyValue is empty (i.e., [ ]), the initial
      // value for the respective field type is returned (EXAMPLE  (0, 0, 0) for Fields .SFVec3f);

      this .set_key__ ();
      this .set_fraction__ ();

      _Core_X3DChildNode_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .prototype .setup .call (this);
   },
   initialize ()
   {
      _Core_X3DChildNode_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .prototype .initialize .call (this);

      this ._set_fraction .addInterest ("set_fraction__", this);
      this ._key          .addInterest ("set_key__",      this);
   },
   set_fraction__ ()
   {
      const
         key      = this ._key,
         length   = key .length,
         fraction = this ._set_fraction .getValue ();

      switch (length)
      {
         case 0:
            // Interpolator nodes containing no keys in the key field shall not produce any events.
            return;
         case 1:
            return this .interpolate (0, 0, 0);
         default:
         {
            if (fraction <= key [0])
               return this .interpolate (0, 1, 0);

            const index1 = _standard_Math_Algorithm_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .upperBound (key, 0, length, fraction);

            if (index1 !== length)
            {
               const
                  index0 = index1 - 1,
                  weight = (fraction - key [index0]) / (key [index1] - key [index0]);

               this .interpolate (index0, index1, _standard_Math_Algorithm_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .clamp (weight, 0, 1));
            }
            else
               this .interpolate (length - 2, length - 1, 1);
         }
      }
   },
   set_key__ ()
   {
      this .set_keyValue__ ();
   },
});

Object .defineProperties (X3DInterpolatorNode, _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .getStaticProperties ("X3DInterpolatorNode", "Interpolation", 1));

const __default__ = X3DInterpolatorNode;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .add ("X3DInterpolatorNode", __default__));

/***/ },

/***/ 3122
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _X3DParser_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6570);
/* harmony import */ var _Expressions_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(9845);
/* harmony import */ var _Fields_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(3515);
/* harmony import */ var _Base_X3DField_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(3247);
/* harmony import */ var _Execution_X3DImportedNode_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(4850);
/* harmony import */ var _Prototype_X3DExternProtoDeclaration_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(4078);
/* harmony import */ var _Prototype_X3DProtoDeclaration_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(4492);
/* harmony import */ var _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(4946);
/* harmony import */ var _Placeholder_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(4303);
/* harmony import */ var _standard_Math_Numbers_Color3_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(2028);
/* harmony import */ var _standard_Math_Numbers_Color4_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(857);
/* harmony import */ var _standard_Math_Numbers_Matrix3_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(1224);
/* harmony import */ var _standard_Math_Numbers_Matrix4_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(2597);
/* harmony import */ var _standard_Math_Numbers_Rotation4_js__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(4580);
/* harmony import */ var _standard_Math_Numbers_Vector2_js__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(2005);
/* harmony import */ var _standard_Math_Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(7910);
/* harmony import */ var _standard_Math_Numbers_Vector4_js__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(7591);
/* harmony import */ var _DEVELOPMENT_js__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(5025);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(6334);
/* provided dependency */ var $ = __webpack_require__(4993);



















/*
 *  Grammar
 */

// VRML lexical elements
const Grammar = (0,_Expressions_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A) ({
   // General
   Whitespaces: /[\x20\n,\t\r]+/gy,
   Comment:     /#\/\*[\s\S]*?\*\/#|#.*?(?=[\n\r]|$)/gy,
   Comment3_2:  /#.*?(?=[\n\r]|$)/gy,
   Break:       /\r?\n/g,

   // Header
   Header:      /^#(VRML|X3D) V(.*?) (utf8)(?:[ \t]+(.*?))?[ \t]*[\n\r]/gy,

   // Keywords
   AS:          /AS/gy,
   COMPONENT:   /COMPONENT/gy,
   DEF:         /DEF/gy,
   EXPORT:      /EXPORT/gy,
   EXTERNPROTO: /EXTERNPROTO/gy,
   FALSE:       /FALSE|false/gy,
   IMPORT:      /IMPORT/gy,
   IS:          /IS/gy,
   META:        /META/gy,
   NULL:        /NULL|null/gy,
   TRUE:        /TRUE|true/gy,
   PROFILE:     /PROFILE/gy,
   PROTO:       /PROTO/gy,
   ROUTE:       /ROUTE/gy,
   TO:          /TO/gy,
   UNIT:        /UNIT/gy,
   USE:         /USE/gy,

   // Terminal symbols
   OpenBrace:    /\{/gy,
   CloseBrace:   /\}/gy,
   OpenBracket:  /\[/gy,
   CloseBracket: /\]/gy,
   Period:       /\./gy,
   Colon:        /\:/gy,

   Id: /[^\x30-\x39\x00-\x20\x22\x23\x27\x2b\x2c\x2d\x2e\x5b\x5c\x5d\x7b\x7d\x7f]{1}[^\x00-\x20\x22\x23\x27\x2c\x2e\x5b\x5c\x5d\x7b\x7d\x7f]*/gy,
   ComponentNameId: /[^\x30-\x39\x00-\x20\x22\x23\x27\x2b\x2c\x2d\x2e\x5b\x5c\x5d\x7b\x7d\x7f\x3a]{1}[^\x00-\x20\x22\x23\x27\x2c\x2e\x5b\x5c\x5d\x7b\x7d\x7f\x3a]*/gy,

   initializeOnly: /initializeOnly/gy,
   inputOnly:      /inputOnly/gy,
   outputOnly:     /outputOnly/gy,
   inputOutput:    /inputOutput/gy,

   field:        /field/gy,
   eventIn:      /eventIn/gy,
   eventOut:     /eventOut/gy,
   exposedField: /exposedField/gy,

   FieldType: /[SM]F(?:Bool|ColorRGBA|Color|Double|Float|Image|Int32|Matrix3d|Matrix3f|Matrix4d|Matrix4f|Node|Rotation|String|Time|Vec2d|Vec2f|Vec3d|Vec3f|Vec4d|Vec4f)/gy,

   // Values
   int32: /(?:0[xX][\da-fA-F]+)|(?:[+-]?\d+)/gy,
   double: /[+-]?(?:(?:(?:\d*\.\d+)|(?:\d+(?:\.)?))(?:[eE][+-]?\d+)?)/gy,
   doubleQuotes: /"/gy,
   noDoubleQuotes: /[^"]+/gy,

   CONSTANTS: /([+-]?)\b(NAN|INFINITY|INF|PI|PI2|PI1_4|PI2_4|PI3_4|PI4_4|PI5_4|PI6_4|PI7_4|PI8_4|PI1_2|PI2_2|PI3_2|PI4_2|PI1_3|PI2_3|PI3_3|PI4_3|PI5_3|PI6_3|SQRT1_2|SQRT2)\b/igy,
   HTMLColor: /[a-zA-Z]+|0[xX][\da-fA-F]+|rgba?\(.*?\)/gy,
});

/*
 *  Parser
 */

function VRMLParser (scene)
{
   _X3DParser_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .call (this, scene);

   this .Grammar =
   {
      Comment: Grammar .Comment,
   };
}

Object .assign (Object .setPrototypeOf (VRMLParser .prototype, _X3DParser_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .prototype),
{
   accessTypes: new Map ([
      ["field",          _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .initializeOnly],
      ["eventIn",        _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .inputOnly],
      ["eventOut",       _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .outputOnly],
      ["exposedField",   _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .inputOutput],
      ["initializeOnly", _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .initializeOnly],
      ["inputOnly",      _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .inputOnly],
      ["outputOnly",     _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .outputOnly],
      ["inputOutput",    _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .inputOutput],
   ]),
   SFImage: new _Fields_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .SFImage (),
   SFNode: new _Fields_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .SFNode (),
   MFString: new _Fields_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .MFString (),
   Color3: new _standard_Math_Numbers_Color3_js__WEBPACK_IMPORTED_MODULE_9__/* ["default"] */ .A (),
   Color4: new _standard_Math_Numbers_Color4_js__WEBPACK_IMPORTED_MODULE_10__/* ["default"] */ .A (),
   Matrix3: new _standard_Math_Numbers_Matrix3_js__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A (),
   Matrix4: new _standard_Math_Numbers_Matrix4_js__WEBPACK_IMPORTED_MODULE_12__/* ["default"] */ .A (),
   Rotation4: new _standard_Math_Numbers_Rotation4_js__WEBPACK_IMPORTED_MODULE_13__/* ["default"] */ .A (),
   Vector2: new _standard_Math_Numbers_Vector2_js__WEBPACK_IMPORTED_MODULE_14__/* ["default"] */ .A (),
   Vector3: new _standard_Math_Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_15__/* ["default"] */ .A (),
   Vector4: new _standard_Math_Numbers_Vector4_js__WEBPACK_IMPORTED_MODULE_16__/* ["default"] */ .A (),
   CONSTANTS: new Map ([
      ["NAN",      Number .NaN],
      ["INFINITY", Number .POSITIVE_INFINITY],
      ["INF",      Number .POSITIVE_INFINITY],
      ["PI",    Math .PI],
      ["PI2",   Math .PI * 2],
      ["PI1_4", Math .PI * 1/4],
      ["PI2_4", Math .PI * 2/4],
      ["PI3_4", Math .PI * 3/4],
      ["PI4_4", Math .PI * 4/4],
      ["PI5_4", Math .PI * 5/4],
      ["PI6_4", Math .PI * 6/4],
      ["PI7_4", Math .PI * 7/4],
      ["PI8_4", Math .PI * 8/4],
      ["PI1_2", Math .PI * 1/2],
      ["PI2_2", Math .PI * 2/2],
      ["PI3_2", Math .PI * 3/2],
      ["PI4_2", Math .PI * 4/2],
      ["PI1_3", Math .PI * 1/3],
      ["PI2_3", Math .PI * 2/3],
      ["PI3_3", Math .PI * 3/3],
      ["PI4_3", Math .PI * 4/3],
      ["PI5_3", Math .PI * 5/3],
      ["PI6_3", Math .PI * 6/3],
      ["SQRT1_2", Math .SQRT1_2],
      ["SQRT2",   Math .SQRT2],
   ]),
   unknownLevel: 0,
   getEncoding ()
   {
      return "STRING";
   },
   setInput (vrmlSyntax)
   {
      this .input      = vrmlSyntax;
      this .lineNumber = 1;
      this .lastIndex  = 0;
   },
   isValid ()
   {
      if (typeof this .input !== "string")
         return false;

      if (this .input .match (/^#VRML V1.0/))
         return false;

      return !! this .input .match (/^(?:#X3D|#VRML|(?:[\x20\n,\t\r]*|#.*?[\r\n])*(PROFILE|COMPONENT|META|UNIT|EXTERNPROTO|PROTO|DEF|NULL|IMPORT|EXPORT|ROUTE|\w+(?:[\x20\n,\t\r]*|#.*?[\r\n])\{|$))/);
   },
   parseIntoScene (resolve, reject)
   {
      try
      {
         this .resolve = resolve;
         this .reject  = reject;

         this .getScene () .setEncoding ("VRML");
         this .getScene () .setProfile (this .getBrowser () .getProfile ("Full"));
         this .x3dScene ();
      }
      catch (error)
      {
         throw new Error (this .getError (error));
      }
   },
   getError (error)
   {
      if (_DEVELOPMENT_js__WEBPACK_IMPORTED_MODULE_17__/* ["default"] */ .A)
         console .error (error);

      const
         string     = error .message,
         unexpected = this .lastIndex === this .input .length ? "Unexpected end of file. " : "";

      let
         rest     = this .getLine (),
         line     = this .getLastLine (),
         lastLine = this .getLastLine (),
         linePos  = line .length - rest .length + 1;

      if (line .length > 80)
      {
         line     = line .substring (linePos - 40, linePos + 40);
         lastLine = "";
         linePos  = 40;
      }

      // Get world URL.

      let worldURL = this .getExecutionContext () .getWorldURL ();

      if (worldURL .startsWith ("data:"))
         worldURL = worldURL .substring (0, worldURL .indexOf (","));

      // Format error.

      const message = "\n"
         + `********************************************************************************\n`
         + `Parser error at line ${this .lineNumber}:${linePos}\n`
         + `in '${worldURL}'\n`
         + `\n`
         + `${lastLine}\n`
         + `${line}\n`
         + `${Array (linePos) .join (" ")}^\n`
         + `${unexpected}${string}\n`
         + `********************************************************************************\n`
      ;

      return message;
   },
   getLine ()
   {
      let
         input     = this .input,
         lastIndex = this .lastIndex,
         line      = "";

      while (lastIndex < input .length && input [lastIndex] !== "\n" && input [lastIndex] !== "\r")
         line += input [lastIndex ++];

      this .lastIndex = lastIndex;

      return line;
   },
   getLastLine ()
   {
      let
         input     = this .input,
         lastIndex = Math .min (this .lastIndex, this .input .length - 1),
         line      = "";

      if (lastIndex < input .length && (input [lastIndex] !== "\n" || input [lastIndex] !== "\r"))
         -- lastIndex;

      while (lastIndex >= 0 && input [lastIndex] !== "\n" && input [lastIndex] !== "\r")
         line = input [lastIndex --] + line;

      this .lastIndex = lastIndex;

      return line;
   },
   comments ()
   {
      while (this .comment ())
         ;
   },
   comment ()
   {
      if (this .whitespaces ())
         return true;

      return this .Grammar .Comment .parse (this);
   },
   whitespaces ()
   {
      if (Grammar .Whitespaces .parse (this))
      {
         this .lines (this .result [0]);

         return true;
      }

      return false;
   },
   lines (string)
   {
      const match = string .match (Grammar .Break);

      if (match)
         this .lineNumber += match .length;
   },
   x3dScene: (() =>
   {
      const VRML =
      [
         "EnvironmentalSensor",
         "PointingDeviceSensor",
         "Scripting",
         "Sound",
         "Text",
      ];

      return function ()
      {
         const
            browser = this .getBrowser (),
            scene   = this .getScene ();

         this .headerStatement ();
         this .profileStatement ();
         this .componentStatements ();
         this .unitStatements ();
         this .metaStatements ();

         if (scene .getSpecificationVersion () === "2.0")
         {
            scene .setProfile (browser .getProfile ("Interchange"));

            for (const componentName of VRML)
               scene .updateComponent (browser .getComponent (componentName));
         }

         if (this .resolve)
         {
            browser .loadComponents (scene) .then (() =>
            {
               try
               {
                  this .statements (this .getExecutionContext () .rootNodes);
                  this .setupNodes ();

                  if (this .lastIndex < this .input .length)
                     throw new Error ("Unknown statement.");

                  this .resolve (scene);
               }
               catch (error)
               {
                  throw new Error (this .getError (error));
               }
            })
            .catch (this .reject);
         }
         else
         {
            this .statements (this .getExecutionContext () .rootNodes);
            this .setupNodes ();

            if (this .lastIndex < this .input .length)
               throw new Error ("Unknown statement.");
         }
      };
   })(),
   headerStatement ()
   {
      if (Grammar .Header .parse (this))
      {
         this .lines (this .result [0]);

         this .getScene () .setSpecificationVersion (this .result [2]);

         if (this .getScene () .getSpecificationVersion () <= 3.2)
            this .Grammar .Comment = Grammar .Comment3_2;

         return true;
      }

      return false;
   },
   profileStatement ()
   {
      this .comments ();

      if (Grammar .PROFILE .parse (this))
      {
         if (this .profileNameId ())
         {
            const profile = this .getBrowser () .getProfile (this .result [0]);

            this .getScene () .setProfile (profile);
            return;
         }

         throw new Error ("Expected a profile name.");
      }
   },
   componentStatements ()
   {
      let component;

      while (component = this .componentStatement ())
      {
         if (this .getScene () .hasComponent (component))
            continue;

         this .getScene () .updateComponent (component);
      }
   },
   componentStatement ()
   {
      this .comments ();

      if (Grammar .COMPONENT .parse (this))
      {
         if (this .componentNameId ())
         {
            const componentNameIdCharacters = this .result [0];

            this .comments ();

            if (Grammar .Colon .parse (this))
            {
               if (this .componentSupportLevel ())
               {
                  const componentSupportLevel = this .value;

                  return this .getBrowser () .getComponent (componentNameIdCharacters, componentSupportLevel);
               }

               throw new Error ("Expected a component support level.");
            }

            throw new Error ("Expected a ':' after component name.");
         }

         throw new Error ("Expected a component name.");
      }

      return null;
   },
   componentSupportLevel ()
   {
      return this .int32 ();
   },
   unitStatements ()
   {
      while (this .unitStatement ())
         ;
   },
   unitStatement ()
   {
      this .comments ();

      if (Grammar .UNIT .parse (this))
      {
         if (this .categoryNameId ())
         {
            const categoryNameId = this .result [0];

            if (this .unitNameId ())
            {
               const unitNameId = this .result [0];

               if (this .unitConversionFactor ())
               {
                  const unitConversionFactor = this .value;

                  try
                  {
                     this .getScene () .updateUnit (categoryNameId, unitNameId, unitConversionFactor);
                     return true;
                  }
                  catch (error)
                  {
                     console .warn (`Parser error at line ${this .lineNumber}: ${error .message}`);
                     return true;
                  }
               }

               throw new Error ("Expected unit conversion factor.");
            }

            throw new Error ("Expected unit name identifier.");
         }

         throw new Error ("Expected category name identifier after UNIT statement.");
      }

      return false;
   },
   unitConversionFactor ()
   {
      return this .double ();
   },
   metaStatements ()
   {
      while (this .metaStatement ())
         ;
   },
   metaStatement ()
   {
      this .comments ();

      if (Grammar .META .parse (this))
      {
         if (this .metaKey ())
         {
            const metaKey = this .value;

            if (this .metaValue ())
            {
               const metaValue = this .value;

               this .getScene () .addMetaData (metaKey, metaValue);
               return true;
            }

            throw new Error ("Expected metadata value.");
         }

         throw new Error ("Expected metadata key.");
      }

      return false;
   },
   metaKey ()
   {
      return this .string ();
   },
   metaValue ()
   {
      return this .string ();
   },
   exportStatement ()
   {
      this .comments ();

      if (Grammar .EXPORT .parse (this))
      {
         if (this .nodeNameId ())
         {
            const localNodeNameId = this .result [0];

            this .comments ();

            const node = this .getScene () .getLocalNode (localNodeNameId);

            let exportedNodeNameId;

            if (Grammar .AS .parse (this))
            {
               if (this .exportedNodeNameId ())
                  exportedNodeNameId = this .result [0];
               else
                  throw new Error ("No name given after AS.");
            }
            else
            {
               exportedNodeNameId = localNodeNameId;
            }

            try
            {
               const existingNode = this .getScene () .getExportedNode (exportedNodeNameId);

               this .getScene () .addExportedNode (this .getScene () .getUniqueExportName (exportedNodeNameId), existingNode);
            }
            catch
            { }

            this .getScene () .updateExportedNode (exportedNodeNameId, node);
            return true;
         }

         throw new Error ("No name given after EXPORT.");
      }

      return false;
   },
   importStatement ()
   {
      this .comments ();

      if (Grammar .IMPORT .parse (this))
      {
         if (this .nodeNameId ())
         {
            const
               inlineNodeNameId = this .result [0],
               namedNode        = this .getExecutionContext () .getNamedNode (inlineNodeNameId);

            this .comments ();

            if (Grammar .Period .parse (this))
            {
               if (this .exportedNodeNameId ())
               {
                  const exportedNodeNameId = this .result [0];

                  this .comments ();

                  let nodeNameId;

                  if (Grammar .AS .parse (this))
                  {
                     if (this .nodeNameId ())
                        nodeNameId = this .result [0];

                     else
                        throw new Error ("No name given after AS.");
                  }
                  else
                  {
                     nodeNameId = exportedNodeNameId;
                  }

                  // Rename existing imported node.

                  this .renameExistingNode (nodeNameId);

                  // Add new imported node.

                  this .getExecutionContext () .addImportedNode (namedNode, exportedNodeNameId, nodeNameId);

                  if (!this .getImportedNodes () .has (nodeNameId))
                  {
                     this .getImportedNodes () .set (nodeNameId, this .getExecutionContext () .getImportedNodes () .get (nodeNameId));
                  }

                  return true;
               }

               throw new Error ("Expected exported node name.");
            }

            throw new Error ("Expected a '.' after exported node name.");
         }

         throw new Error ("No name given after IMPORT statement.");
      }
      return false;
   },
   statements (field)
   {
      while (this .statement (field))
         ;
   },
   statement (field)
   {
      if (this .protoStatement ())
         return true;

      if (this .routeStatement ())
         return true;

      if (this .importStatement ())
         return true;

      if (this .exportStatement ())
         return true;

      const node = this .nodeStatement ();

      if (node !== false)
      {
         field .push (node);
         return true;
      }

      return false;
   },
   nodeStatement ()
   {
      this .comments ();

      if (Grammar .DEF .parse (this))
      {
         if (this .nodeNameId ())
            return this .node (this .result [0]);

         throw new Error ("No name given after DEF.");
      }

      if (Grammar .USE .parse (this))
      {
         if (this .nodeNameId ())
         {
            const nodeNameId = this .result [0];

            try
            {
               const localNode = this .getExecutionContext () .getLocalNode (nodeNameId);

               return localNode instanceof _Execution_X3DImportedNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A
                  ? localNode .getExportedNode ()
                  : localNode .getValue ();
            }
            catch
            {
               const placeholder = this .getPlaceholders () .get (nodeNameId);

               if (placeholder)
               {
                  return placeholder;
               }
               else
               {
                  const placeholder = new _Placeholder_js__WEBPACK_IMPORTED_MODULE_8__/* ["default"] */ .A (this, nodeNameId);

                  this .getPlaceholders () .set (nodeNameId, placeholder);

                  return placeholder;
               }
            }
         }

         throw new Error ("No name given after USE.");
      }

      if (Grammar .NULL .parse (this))
         return null;

      return this .node ("");
   },
   protoStatement ()
   {
      if (this .proto ())
         return true;

      if (this .externproto ())
         return true;

      return false;
   },
   protoStatements ()
   {
      while (this .protoStatement ())
         ;
   },
   proto ()
   {
      this .comments ();

      if (Grammar .PROTO .parse (this))
      {
         if (this .nodeTypeId ())
         {
            const nodeTypeId = this .result [0];

            this .comments ();

            if (Grammar .OpenBracket .parse (this))
            {
               const interfaceDeclarations = this .interfaceDeclarations ();

               this .comments ();

               if (Grammar .CloseBracket .parse (this))
               {
                  this .comments ();

                  if (Grammar .OpenBrace .parse (this))
                  {
                     const proto = new _Prototype_X3DProtoDeclaration_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A (this .getExecutionContext ());

                     for (const field of interfaceDeclarations)
                        proto .addUserDefinedField (field .getAccessType (), field .getName (), field);

                     this .pushExecutionContext (proto .getBody ());
                     this .protoBody (proto .getBody () .rootNodes);
                     this .setupNodes ();
                     this .popExecutionContext ();

                     this .comments ();

                     if (Grammar .CloseBrace .parse (this))
                     {
                        proto .setup ();

                        try
                        {
                           const existingProto = this .getExecutionContext () .getProtoDeclaration (nodeTypeId);

                           console .warn (`A proto named '${nodeTypeId}' is already defined and will be overridden.`);

                           this .getExecutionContext () .updateProtoDeclaration (this .getExecutionContext () .getUniqueProtoName (nodeTypeId), existingProto);
                        }
                        catch
                        { }

                        this .getExecutionContext () .updateProtoDeclaration (nodeTypeId, proto);

                        return true;
                     }

                     throw new Error ("Expected a '}' at the end of PROTO body.");
                  }

                  throw new Error ("Expected a '{' at the beginning of PROTO body.");
               }

               throw new Error ("Expected a ']' at the end of PROTO interface declaration.");
            }

            throw new Error ("Expected a '[' at the beginning of PROTO interface declaration.");
         }

         throw new Error ("Invalid PROTO definition name.");
      }

      return false;
   },
   protoBody (rootNodes)
   {
      this .protoStatements ();

      const rootNodeStatement = this .rootNodeStatement ();

      if (rootNodeStatement !== false)
         rootNodes .push (rootNodeStatement);

      this .statements (rootNodes);
   },
   rootNodeStatement ()
   {
      this .comments ();

      if (Grammar .DEF .parse (this))
      {
         if (this .nodeNameId ())
         {
            const
               nodeNameId = this .result [0],
               baseNode   = this .node (nodeNameId);

            if (baseNode !== false)
               return baseNode;

            throw new Error ("Expected node type name after DEF.");
         }

         throw new Error ("No name given after DEF.");
      }

      const baseNode = this .node ("");

      if (baseNode !== false)
         return baseNode;

      return false;
   },
   interfaceDeclarations ()
   {
      const interfaceDeclarations = [ ];

      let field;

      while (field = this .interfaceDeclaration ())
         interfaceDeclarations .push (field);

      return interfaceDeclarations;
   },
   restrictedInterfaceDeclaration ()
   {
      this .comments ();

      if (Grammar .inputOnly .parse (this) || Grammar .eventIn .parse (this))
      {
         if (this .fieldType ())
         {
            const fieldType = this .result [0];

            if (this .inputOnlyId ())
            {
               const
                  fieldId = this .result [0],
                  field   = new (_Fields_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A [fieldType]) ();

               field .setAccessType (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .inputOnly);
               field .setName (fieldId);

               return field;
            }

            throw new Error ("Expected a name for field.");
         }

         this .Id ();

         throw new Error (`Unknown event or field type: '${this .result [0]}'.`);
      }

      if (Grammar .outputOnly .parse (this) || Grammar .eventOut .parse (this))
      {
         if (this .fieldType ())
         {
            const fieldType = this .result [0];

            if (this .outputOnlyId ())
            {
               const
                  fieldId = this .result [0],
                  field   = new (_Fields_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A [fieldType]) ();

               field .setAccessType (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .outputOnly);
               field .setName (fieldId);

               return field;
            }

            throw new Error ("Expected a name for field.");
         }

         this .Id ();

         throw new Error (`Unknown event or field type: '${this .result [0]}'.`);
      }

      if (Grammar .initializeOnly .parse (this) || Grammar .field .parse (this))
      {
         if (this .fieldType ())
         {
            const fieldType = this .result [0];

            if (this .initializeOnlyId ())
            {
               const
                  fieldId = this .result [0],
                  field   = new (_Fields_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A [fieldType]) ();

               if (this .fieldValue (field))
               {
                  field .setAccessType (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .initializeOnly);
                  field .setName (fieldId);

                  return field;
               }

               throw new Error (`Couldn't read value for field '${fieldId}'.`);
            }

            throw new Error ("Expected a name for field.");
         }

         this .Id ();

         throw new Error (`Unknown event or field type: '${this .result [0]}'.`);
      }

      return null;
   },
   interfaceDeclaration ()
   {
      const field = this .restrictedInterfaceDeclaration ();

      if (field)
         return field;

      this .comments ();

      if (Grammar .inputOutput .parse (this) || Grammar .exposedField .parse (this))
      {
         if (this .fieldType ())
         {
            const fieldType = this .result [0];

            if (this .inputOutputId ())
            {
               const
                  fieldId = this .result [0],
                  field   = new (_Fields_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A [fieldType]) ();

               if (this .fieldValue (field))
               {
                  field .setAccessType (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .inputOutput);
                  field .setName (fieldId);

                  return field;
               }

               throw new Error (`Couldn't read value for field '${fieldId}'.`);
            }

            throw new Error ("Expected a name for field.");
         }

         this .Id ();

         throw new Error (`Unknown event or field type: '${this .result [0]}'.`);
      }

      return null;
   },
   externproto ()
   {
      this .comments ();

      if (Grammar .EXTERNPROTO .parse (this))
      {
         if (this .nodeTypeId ())
         {
            const nodeTypeId = this .result [0];

            this .comments ();

            if (Grammar .OpenBracket .parse (this))
            {
               const externInterfaceDeclarations = this .externInterfaceDeclarations ();

               this .comments ();

               if (Grammar .CloseBracket .parse (this))
               {
                  if (this .URLList (this .MFString))
                  {
                     const externproto = new _Prototype_X3DExternProtoDeclaration_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A (this .getExecutionContext (), this .MFString);

                     for (const field of externInterfaceDeclarations)
                        externproto .addUserDefinedField (field .getAccessType (), field .getName (), field);

                     externproto .setup ();

                     try
                     {
                        const existingExternProto = this .getExecutionContext () .getExternProtoDeclaration (nodeTypeId);

                        console .warn (`A extern proto named '${nodeTypeId}' is already defined and will be overridden.`);

                        this .getExecutionContext () .updateExternProtoDeclaration (this .getExecutionContext () .getUniqueExternProtoName (nodeTypeId), existingExternProto);
                     }
                     catch
                     { }

                     this .getExecutionContext () .updateExternProtoDeclaration (nodeTypeId, externproto);
                     return true;
                  }

                  throw new Error (`Expected a URL list after EXTERNPROTO interface declaration '${nodeTypeId}'.`);
               }

               throw new Error ("Expected a ']' at the end of EXTERNPROTO interface declaration.");
            }

            throw new Error ("Expected a '[' at the beginning of EXTERNPROTO interface declaration.");
         }

         throw new Error ("Invalid EXTERNPROTO definition name.");
      }

      return false;
   },
   externInterfaceDeclarations ()
   {
      const externInterfaceDeclarations = [ ];

      let field;

      while (field = this .externInterfaceDeclaration ())
         externInterfaceDeclarations .push (field);

      return externInterfaceDeclarations;
   },
   externInterfaceDeclaration ()
   {
      this .comments ();

      if (Grammar .inputOnly .parse (this) || Grammar .eventIn .parse (this))
      {
         if (this .fieldType ())
         {
            const fieldType = this .result [0];

            if (this .inputOnlyId ())
            {
               const
                  fieldId = this .result [0],
                  field   = new (_Fields_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A [fieldType]) ();

               field .setAccessType (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .inputOnly);
               field .setName (fieldId);

               return field;
            }

            throw new Error ("Expected a name for field.");
         }

         this .Id ()

         throw new Error (`Unknown event or field type: '${this .result [0]}'.`);
      }

      if (Grammar .outputOnly .parse (this) || Grammar .eventOut .parse (this))
      {
         if (this .fieldType ())
         {
            const fieldType = this .result [0];

            if (this .outputOnlyId ())
            {
               const
                  fieldId = this .result [0],
                  field   = new (_Fields_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A [fieldType]) ();

               field .setAccessType (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .outputOnly);
               field .setName (fieldId);

               return field;
            }

            throw new Error ("Expected a name for field.");
         }

         this .Id ()

         throw new Error (`Unknown event or field type: '${this .result [0]}'.`);
      }

      if (Grammar .initializeOnly .parse (this) || Grammar .field .parse (this))
      {
         if (this .fieldType ())
         {
            const fieldType = this .result [0];

            if (this .initializeOnlyId ())
            {
               const
                  fieldId = this .result [0],
                  field   = new (_Fields_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A [fieldType]) ();

               field .setAccessType (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .initializeOnly);
               field .setName (fieldId);

               return field;
            }

            throw new Error ("Expected a name for field.");
         }

         this .Id ()

         throw new Error (`Unknown event or field type: '${this .result [0]}'.`);
      }

      if (Grammar .inputOutput .parse (this) || Grammar .exposedField .parse (this))
      {
         if (this .fieldType ())
         {
            const fieldType = this .result [0];

            if (this .inputOutputId ())
            {
               const
                  fieldId = this .result [0],
                  field   = new (_Fields_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A [fieldType]) ();

               field .setAccessType (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .inputOutput);
               field .setName (fieldId);

               return field;
            }

            throw new Error ("Expected a name for field.");
         }

         this .Id ()

         throw new Error (`Unknown event or field type: '${this .result [0]}'.`);
      }

      return null;
   },
   URLList (field)
   {
      return this .mfstringValue (field);
   },
   routeStatement ()
   {
      this .comments ();

      if (Grammar .ROUTE .parse (this))
      {
         if (this .nodeNameId ())
         {
            const
               fromNodeId = this .result [0],
               fromNode   = this .getExecutionContext () .getLocalNode (fromNodeId);

            this .comments ();

            if (Grammar .Period .parse (this))
            {
               if (this .outputOnlyId ())
               {
                  const eventOutId = this .result [0];

                  this .comments ();

                  if (Grammar .TO .parse (this))
                  {
                     if (this .nodeNameId ())
                     {
                        const
                           toNodeId = this .result [0],
                           toNode   = this .getExecutionContext () .getLocalNode (toNodeId);

                        this .comments ();

                        if (Grammar .Period .parse (this))
                        {
                           if (this .inputOnlyId ())
                           {
                              try
                              {
                                 const eventInId = this .result [0];

                                 this .getExecutionContext () .addRoute (fromNode, eventOutId, toNode, eventInId);
                                 return true;
                              }
                              catch (error)
                              {
                                 console .warn (`Parser error at line ${this .lineNumber}: ${error .message}`);

                                 return true;
                              }
                           }

                           throw new Error ("Bad ROUTE specification: Expected a field name.");
                        }

                        throw new Error ("Bad ROUTE specification: Expected a '.' after node name.");
                     }

                     throw new Error ("Bad ROUTE specification: Expected a node name.");
                  }

                  throw new Error ("Bad ROUTE specification: Expected a 'TO'.");
               }

               throw new Error ("Bad ROUTE specification: Expected a field name.");
            }

            throw new Error ("Bad ROUTE specification: Expected a '.' after node name.");
         }

         throw new Error ("Bad ROUTE specification: Expected a node name.");
      }

      return false;
   },
   node (nodeNameId)
   {
      if (this .nodeTypeId ())
      {
         const nodeTypeId = this .result [0];

         const baseNode = this .getExecutionContext () .createNode (nodeTypeId, false)
            ?? this .getExecutionContext () .createProto (nodeTypeId, false);

         if (!baseNode)
         {
            // Parse unknown node.

            if (!this .unknownLevel)
            {
               console .warn (`Parser error at line ${this .lineNumber}: Unknown node type or proto '${nodeTypeId}'. You probably have insufficient component/profile statements, and/or an inappropriate specification version.`);
            }

            this .comments ();

            if (Grammar .OpenBrace .parse (this))
            {
               ++ this .unknownLevel;

               this .nodeBody (this .getExecutionContext () .createNode ("WorldInfo", false));

               -- this .unknownLevel;

               this .comments ();

               if (Grammar .CloseBrace .parse (this))
                  return null;
            }

            return false;
         }

         if (nodeNameId .length)
         {
            if (!this .getNamedNodes () .has (nodeNameId))
               this .getNamedNodes () .set (nodeNameId, baseNode);

            this .renameExistingNode (nodeNameId);

            this .getExecutionContext () .updateNamedNode (nodeNameId, baseNode);
         }

         this .comments ();

         if (Grammar .OpenBrace .parse (this))
         {
            if (baseNode .canUserDefinedFields ())
               this .scriptBody (baseNode);

            else
               this .nodeBody (baseNode);

            this .comments ();

            if (Grammar .CloseBrace .parse (this))
            {
               if (!this .isInsideProtoDeclaration ())
                  this .getNodes () .push (baseNode);

               return baseNode;
            }

            throw new Error ("Expected '}' at the end of node body.");
         }

         throw new Error ("Expected '{' at the beginning of node body.");
      }

      return false;
   },
   scriptBody (baseNode)
   {
      while (this .scriptBodyElement (baseNode))
         ;
   },
   scriptBodyElement (baseNode)
   {
      const { lastIndex, lineNumber } = this;

      if (this .Id ())
      {
         const accessType = this .accessTypes .get (this .result [0]);

         if (accessType)
         {
            if (this .fieldType ())
            {
               const fieldType = this .result [0];

               if (this .Id ())
               {
                  const fieldId = this .result [0];

                  this .comments ();

                  if (Grammar .IS .parse (this))
                  {
                     if (this .isInsideProtoDeclaration ())
                     {
                        if (this .Id ())
                        {
                           const isId = this .result [0];

                           let reference;

                           try
                           {
                              reference = this .getOuterNode () .getField (isId);
                           }
                           catch
                           {
                              console .warn (`Parser error at line ${this .lineNumber}: No such event or field '${isId}' inside PROTO ${this .getOuterNode () .getName ()} interface declaration.`);

                              return true;
                           }

                           if (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A [fieldType] === reference .getType ())
                           {
                              if (reference .isReference (accessType))
                              {
                                 let field = $.try (() => baseNode .getUserDefinedField (fieldId));

                                 if (!field)
                                 {
                                    field = new (_Fields_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A [fieldType]) ();

                                    baseNode .addUserDefinedField (accessType, fieldId, field);
                                 }

                                 if (accessType === field .getAccessType () && reference .getType () === field .getType ())
                                 {
                                    field .addReference (reference);
                                    return true;
                                 }

                                 throw new Error (`Couldn't add field '${fieldId}', field already exists with different access type or data type.`);
                              }

                              throw new Error (`Field '${fieldId}' and '${reference .getName ()}' in PROTO '${this .getOuterNode () .getName ()}' are incompatible as an IS mapping.`);
                           }

                           throw new Error (`Field '${fieldId}' and '${reference .getName ()}' in PROTO '${this .getOuterNode () .getName ()}' have different types.`);
                        }

                        throw new Error ("No name give after IS statement.");
                     }

                     throw new Error ("IS statement outside PROTO definition.");
                  }
               }
            }
         }
      }

      this .lastIndex  = lastIndex;
      this .lineNumber = lineNumber;

      const field = this .interfaceDeclaration ();

      if (field)
      {
         const existingField = $.try (() => baseNode .getUserDefinedField (field .getName ()));

         if (existingField)
         {
            if (existingField .getAccessType () === field .getAccessType () && existingField .getType () === field .getType ())
            {
               existingField .assign (field);
               return true;
            }

            throw new Error (`Couldn't set value for field '${field .getName ()}', field already exists with different access type or data type.`);
         }

         baseNode .addUserDefinedField (field .getAccessType (), field .getName (), field);
         return true;
      }

      return this .nodeBodyElement (baseNode);
   },
   nodeBody (baseNode)
   {
      while (this .nodeBodyElement (baseNode))
         ;
   },
   nodeBodyElement (baseNode)
   {
      if (this .protoStatement ())
         return true;

      if (this .routeStatement ())
         return true;

      if (this .Id ())
      {
         const fieldId = this .result [0];

         let field;

         try
         {
            field = baseNode .getPredefinedField (fieldId);
         }
         catch
         {
            // Parse unknown field value.

            const { lastIndex, lineNumber } = this;

            if (this .unknownValue ())
            {
               if (!this .unknownLevel)
               {
                  console .warn (`Parser error at line ${lineNumber}: Unknown field '${fieldId}' in class '${baseNode .getTypeName ()}'.`);
               }

               return true;
            }

            this .lastIndex  = lastIndex;
            this .lineNumber = lineNumber;

            throw new Error (`Unknown field '${fieldId}' in class '${baseNode .getTypeName ()}'.`);
         }

         this .comments ();

         if (Grammar .IS .parse (this))
         {
            if (this .isInsideProtoDeclaration ())
            {
               if (this .Id ())
               {
                  const isId = this .result [0];

                  let reference;

                  try
                  {
                     reference = this .getOuterNode () .getField (isId);
                  }
                  catch
                  {
                     console .warn (`Parser error at line ${this .lineNumber}: No such event or field '${isId}' inside PROTO ${this .getOuterNode () .getName ()}`);

                     return true;
                  }

                  if (field .getType () === reference .getType ())
                  {
                     if (reference .isReference (field .getAccessType ()))
                     {
                        field .addReference (reference);
                        return true;
                     }

                     throw new Error (`Field '${field .getName ()}' and '${reference .getName ()}' in PROTO ${this .getOuterNode () .getName ()} are incompatible as an IS mapping.`);
                  }

                  throw new Error (`Field '${field .getName ()}' and '${reference .getName ()}' in PROTO ${this .getOuterNode () .getName ()} have different types.`);
               }

               throw new Error ("No name give after IS statement.");
            }

            throw new Error ("IS statement outside PROTO definition.");
         }

         if (field .isInitializable ())
         {
            if (this .fieldValue (field))
               return true;

            throw new Error (`Couldn't read value for field '${fieldId}'.`);
         }

         // Parse value of a inputOnly or outputOnly, and output a warning.

         if (!this .unknownValue ())
            throw new Error (`Couldn't read value for field '${fieldId}'.`);

         console .warn (`Parser error at line ${this .lineNumber}: Couldn't assign value to ${this .accessTypeToString (field .getAccessType ())} field '${fieldId}'.`);

         return true;
      }

      return false;
   },
   profileNameId () { return this .Id (); },
   componentNameId ()
   {
      this .comments ();

      return Grammar .ComponentNameId .parse (this);
   },
   categoryNameId () { return this .Id (); },
   unitNameId () { return this .Id (); },
   exportedNodeNameId () { return this .Id (); },
   nodeNameId () { return this .Id (); },
   nodeTypeId () { return this .Id (); },
   initializeOnlyId () { return this .Id (); },
   inputOnlyId () { return this .Id (); },
   outputOnlyId () { return this .Id (); },
   inputOutputId () { return this .Id (); },
   Id ()
   {
      this .comments ();

      return Grammar .Id .parse (this);
   },
   fieldType ()
   {
      this .comments ();

      return Grammar .FieldType .parse (this);
   },
   fieldValue (field)
   {
      return this [field .getType ()] (field, field .getUnit ());
   },
   bool ()
   {
      this .comments ();

      if (Grammar .TRUE .parse (this))
      {
         this .value = true;
         return true;
      }

      if (Grammar .FALSE .parse (this))
      {
         this .value = false;
         return true;
      }

      return false;
   },
   double ()
   {
      this .comments ();

      if (Grammar .double .parse (this))
      {
         this .value = parseFloat (this .result [0]);
         return true;
      }

      // Constants

      if (Grammar .CONSTANTS .parse (this))
      {
         this .value = this .CONSTANTS .get (this .result [2] .toUpperCase ());

         if (this .result [1] === "-")
            this .value = -this .value;

         return true;
      }

      return false;
   },
   int32 ()
   {
      this .comments ();

      if (Grammar .int32 .parse (this))
      {
         this .value = parseInt (this .result [0]);
         return true;
      }

      return false;
   },
   string ()
   {
      this .comments ();

      if (Grammar .doubleQuotes .parse (this))
      {
         let value = "";

         while (Grammar .noDoubleQuotes .parse (this))
         {
            value += this .result [0];

            const m = value .match (/\\+$/);

            if (!m || m [0] .length % 2 === 0)
               break;

            Grammar .doubleQuotes .parse (this);

            value += '"';
         }

         if (Grammar .doubleQuotes .parse (this))
         {
            this .lines (value);

            this .value = _Fields_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .SFString .unescape (value);

            return true;
         }
      }

      return false;
   },
   sfboolValue (field)
   {
      if (this .bool ())
      {
         field .setValue (this .value);
         return true;
      }

      return false;
   },
   mfboolValue (field)
   {
      field .length = 0;

      if (this .bool ())
      {
         field .push (this .value);
         return true;
      }

      if (Grammar .OpenBracket .parse (this))
      {
         this .sfboolValues (field);

         if (Grammar .CloseBracket .parse (this))
            return true;

         throw new Error ("Expected ']'.");
      }

      return false;
   },
   sfboolValues (field)
   {
      const array = [ ];

      while (this .bool ())
         array .push (this .value);

      field .setValue (array);

      return field .length !== 0;
   },
   sfcolorValue (field)
   {
      const lastIndex = this .lastIndex;

      if (this .double ())
      {
         const r = this .value;

         if (this .double ())
         {
            const g = this .value;

            if (this .double ())
            {
               const b = this .value;

               field .r = r;
               field .g = g;
               field .b = b;

               return true;
            }
         }
      }

      this .lastIndex = lastIndex;

      this .comments ();

      if (Grammar .HTMLColor .parse (this))
      {
         const color = this .convertColor (this .result [0] .replace (/0x/i, "#"));

         field .r = color [0];
         field .g = color [1];
         field .b = color [2];

         return true;
      }

      return false;
   },
   mfcolorValue (field)
   {
      field .length = 0;

      if (this .sfcolorValue (this .Color3))
      {
         field .push (this .Color3);
         return true;
      }

      if (Grammar .OpenBracket .parse (this))
      {
         this .sfcolorValues (field);

         if (Grammar .CloseBracket .parse (this))
            return true;

         throw new Error ("Expected ']'.");
      }

      return false;
   },
   sfcolorValues (field)
   {
      const array = [ ];

      while (this .double ())
         array .push (this .value);

      field .setValue (array);

      return field .length !== 0;
   },
   sfcolorrgbaValue (field)
   {
      const lastIndex = this .lastIndex;

      if (this .double ())
      {
         const r = this .value;

         if (this .double ())
         {
            const g = this .value;

            if (this .double ())
            {
               const b = this .value;

               if (this .double ())
               {
                  const a = this .value;

                  field .r = r;
                  field .g = g;
                  field .b = b;
                  field .a = a;

                  return true;
               }
            }
         }
      }

      this .lastIndex = lastIndex;

      this .comments ();

      if (Grammar .HTMLColor .parse (this))
      {
         const color = this .convertColor (this .result [0] .replace (/0x/i, "#"));

         field .r = color [0];
         field .g = color [1];
         field .b = color [2];
         field .a = color [3];

         return true;
      }

      return false;
   },
   mfcolorrgbaValue (field)
   {
      field .length = 0;

      if (this .sfcolorrgbaValue (this .Color4))
      {
         field .push (this .Color4);
         return true;
      }

      if (Grammar .OpenBracket .parse (this))
      {
         this .sfcolorValues (field);

         if (Grammar .CloseBracket .parse (this))
            return true;

         throw new Error ("Expected ']'.");
      }

      return false;
   },
   sfdoubleValue (field)
   {
      if (this .double ())
      {
         field .setValue (this .fromUnit (field .getUnit (), this .value));
         return true;
      }

      return false;
   },
   mfdoubleValue (field)
   {
      field .length = 0;

      if (this .double ())
      {
         field .push (this .fromUnit (field .getUnit (), this .value));
         return true;
      }

      if (Grammar .OpenBracket .parse (this))
      {
         this .sfdoubleValues (field);

         if (Grammar .CloseBracket .parse (this))
            return true;

         throw new Error ("Expected ']'.");
      }

      return false;
   },
   sfdoubleValues (field)
   {
      const
         unit  = field .getUnit (),
         array = [ ];

      while (this .double ())
         array .push (this .fromUnit (unit, this .value));

      field .setValue (array);

      return field .length !== 0;
   },
   sfimageValue (field)
   {
      if (this .int32 ())
      {
         const width = this .value;

         if (this .int32 ())
         {
            const height = this .value;

            if (this .int32 ())
            {
               const
                  comp  = this .value,
                  size  = width * height,
                  array = [ ];

               for (let i = 0; i < size; ++ i)
               {
                  if (this .int32 ())
                  {
                     array .push (this .value);
                     continue;
                  }

                  return false;
               }

               field .width  = width;
               field .height = height;
               field .comp   = comp;
               field .array  = array;

               return true;
            }
         }
      }

      return false;
   },
   mfimageValue (field)
   {
      field .length = 0;

      if (this .sfimageValue (this .SFImage))
      {
         field .push (this .SFImage);
         return true;
      }

      if (Grammar .OpenBracket .parse (this))
      {
         this .sfimageValues (field);

         if (Grammar .CloseBracket .parse (this))
            return true;

         throw new Error ("Expected ']'.");
      }

      return false;
   },
   sfimageValues (field)
   {
      field .length = 0;

      const
         target = field .getTarget (),
         value  = this .SFImage;

      while (this .sfimageValue (value))
         target .push (value);

      return field .length !== 0;
   },
   sfint32Value (field)
   {
      if (this .int32 ())
      {
         field .setValue (this .value);
         return true;
      }

      return false;
   },
   mfint32Value (field)
   {
      field .length = 0;

      if (this .int32 ())
      {
         field .push (this .value);
         return true;
      }

      if (Grammar .OpenBracket .parse (this))
      {
         this .sfint32Values (field);

         if (Grammar .CloseBracket .parse (this))
            return true;

         throw new Error ("Expected ']'.");
      }

      return false;
   },
   sfint32Values (field)
   {
      const array = [ ];

      while (this .int32 ())
         array .push (this .value);

      field .setValue (array);

      return field .length !== 0;
   },
   sfmatrix3Value (field)
   {
      if (this .double ())
      {
         const m00 = this .value;

         if (this .double ())
         {
            const m01 = this .value;

            if (this .double ())
            {
               const m02 = this .value;

                  if (this .double ())
                  {
                     const m10 = this .value;

                     if (this .double ())
                     {
                        const m11 = this .value;

                        if (this .double ())
                        {
                           const m12 = this .value;

                           if (this .double ())
                           {
                              const m20 = this .value;

                              if (this .double ())
                              {
                                 const m21 = this .value;

                                 if (this .double ())
                                 {
                                    const m22 = this .value;

                                    field [0] = m00;
                                    field [1] = m01;
                                    field [2] = m02;
                                    field [3] = m10;
                                    field [4] = m11;
                                    field [5] = m12;
                                    field [6] = m20;
                                    field [7] = m21;
                                    field [8] = m22;

                                    return true;
                              }
                           }
                        }
                     }
                  }
               }
            }
         }
      }

      return false;
   },
   mfmatrix3Value (field)
   {
      field .length = 0;

      if (this .sfmatrix3Value (this .Matrix3))
      {
         field .push (this .Matrix3);
         return true;
      }

      if (Grammar .OpenBracket .parse (this))
      {
         this .sfmatrixValues (field);

         if (Grammar .CloseBracket .parse (this))
            return true;

         throw new Error ("Expected ']'.");
      }

      return false;
   },
   sfmatrixValues (field)
   {
      const array = [ ];

      while (this .double ())
         array .push (this .value);

      field .setValue (array);

      return field .length !== 0;
   },
   sfmatrix4Value (field)
   {
      if (this .double ())
      {
         const m00 = this .value;

         if (this .double ())
         {
            const m01 = this .value;

            if (this .double ())
            {
               const m02 = this .value;

               if (this .double ())
               {
                  const m03 = this .value;

                  if (this .double ())
                  {
                     const m10 = this .value;

                     if (this .double ())
                     {
                        const m11 = this .value;

                        if (this .double ())
                        {
                           const m12 = this .value;

                           if (this .double ())
                           {
                              const m13 = this .value;

                              if (this .double ())
                              {
                                 const m20 = this .value;

                                 if (this .double ())
                                 {
                                    const m21 = this .value;

                                    if (this .double ())
                                    {
                                       const m22 = this .value;

                                       if (this .double ())
                                       {
                                          const m23 = this .value;

                                          if (this .double ())
                                          {
                                             const m30 = this .value;

                                             if (this .double ())
                                             {
                                                const m31 = this .value;

                                                if (this .double ())
                                                {
                                                   const m32 = this .value;

                                                   if (this .double ())
                                                   {
                                                      const m33 = this .value;

                                                      field [ 0] = m00;
                                                      field [ 1] = m01;
                                                      field [ 2] = m02;
                                                      field [ 3] = m03;
                                                      field [ 4] = m10;
                                                      field [ 5] = m11;
                                                      field [ 6] = m12;
                                                      field [ 7] = m13;
                                                      field [ 8] = m20;
                                                      field [ 9] = m21;
                                                      field [10] = m22;
                                                      field [11] = m23;
                                                      field [12] = m30;
                                                      field [13] = m31;
                                                      field [14] = m32;
                                                      field [15] = m33;

                                                      return true;
                                                   }
                                                }
                                             }
                                          }
                                       }
                                    }
                                 }
                              }
                           }
                        }
                     }
                  }
               }
            }
         }
      }

      return false;
   },
   mfmatrix4Value (field)
   {
      field .length = 0;

      if (this .sfmatrix4Value (this .Matrix4))
      {
         field .push (this .Matrix4);
         return true;
      }

      if (Grammar .OpenBracket .parse (this))
      {
         this .sfmatrixValues (field);

         if (Grammar .CloseBracket .parse (this))
            return true;

         throw new Error ("Expected ']'.");
      }

      return false;
   },
   sfnodeValue (field)
   {
      const baseNode = this .nodeStatement ();

      if (baseNode !== false)
      {
         field .setValue (baseNode);
         return true;
      }

      return false;
   },
   mfnodeValue (field)
   {
      field .length = 0;

      const node = this .nodeStatement ();

      if (node !== false)
      {
         field .push (node);
         return true;
      }

      if (Grammar .OpenBracket .parse (this))
      {
         this .nodeStatements (field);

         if (Grammar .CloseBracket .parse (this))
            return true;

         throw new Error ("Expected ']'.");
      }

      return false;
   },
   nodeStatements (field)
   {
      this .statements (field);

      // let node = this .nodeStatement ();

      // while (node !== false)
      // {
      //    field .push (node);

      //    node = this .nodeStatement ();
      // }
   },
   sfrotationValue (field)
   {
      if (this .double ())
      {
         const x = this .value;

         if (this .double ())
         {
            const y = this .value;

            if (this .double ())
            {
               const z = this .value;

               if (this .double ())
               {
                  const angle = this .value;

                  field .x     = x;
                  field .y     = y;
                  field .z     = z;
                  field .angle = this .fromUnit ("angle", angle);

                  return true;
               }
            }
         }
      }

      return false;
   },
   mfrotationValue (field)
   {
      field .length = 0;

      if (this .sfrotationValue (this .Rotation4))
      {
         field .push (this .Rotation4);
         return true;
      }

      if (Grammar .OpenBracket .parse (this))
      {
         this .sfrotationValues (field);

         if (Grammar .CloseBracket .parse (this))
            return true;

         throw new Error ("Expected ']'.");
      }

      return false;
   },
   sfrotationValues (field)
   {
      field .length = 0;

      const
         target = field .getTarget (),
         value  = this .Rotation4;

      while (this .sfrotationValue (value))
         target .push (value);

      return field .length !== 0;
   },
   sfstringValue (field)
   {
      if (this .string ())
      {
         field .setValue (this .value);
         return true;
      }

      return false;
   },
   mfstringValue (field)
   {
      field .length = 0;

      if (this .string ())
      {
         field .push (this .value);
         return true;
      }

      if (Grammar .OpenBracket .parse (this))
      {
         this .sfstringValues (field);

         if (Grammar .CloseBracket .parse (this))
            return true;

         throw new Error ("Expected ']'.");
      }

      return false;
   },
   sfstringValues (field)
   {
      const array = [ ];

      while (this .string ())
         array .push (this .value);

      field .setValue (array);

      return field .length !== 0;
   },
   sfvec2Value (field, unit)
   {
      if (this .double ())
      {
         const x = this .value;

         if (this .double ())
         {
            const y = this .value;

            field .x = this .fromUnit (unit, x);
            field .y = this .fromUnit (unit, y);

            return true;
         }
      }

      return false;
   },
   mfvec2Value (field)
   {
      field .length = 0;

      if (this .sfvec2Value (this .Vector2, field .getUnit ()))
      {
         field .push (this .Vector2);
         return true;
      }

      if (Grammar .OpenBracket .parse (this))
      {
         this .sfvecValues (field);

         if (Grammar .CloseBracket .parse (this))
            return true;

         throw new Error ("Expected ']'.");
      }

      return false;
   },
   sfvecValues (field)
   {
      const
         unit  = field .getUnit (),
         array = [ ];

      while (this .double ())
         array .push (this .fromUnit (unit, this .value));

      field .setValue (array);

      return field .length !== 0;
   },
   sfvec3Value (field, unit)
   {
      if (this .double ())
      {
         const x = this .value;

         if (this .double ())
         {
            const y = this .value;

            if (this .double ())
            {
               const z = this .value;

               field .x = this .fromUnit (unit, x);
               field .y = this .fromUnit (unit, y);
               field .z = this .fromUnit (unit, z);

               return true;
            }
         }
      }

      return false;
   },
   mfvec3Value (field)
   {
      field .length = 0;

      if (this .sfvec3Value (this .Vector3, field .getUnit ()))
      {
         field .push (this .Vector3);
         return true;
      }

      if (Grammar .OpenBracket .parse (this))
      {
         this .sfvecValues (field);

         if (Grammar .CloseBracket .parse (this))
            return true;

         throw new Error ("Expected ']'.");
      }

      return false;
   },
   sfvec4Value (field, unit)
   {
      if (this .double ())
      {
         const x = this .value;

         if (this .double ())
         {
            const y = this .value;

            if (this .double ())
            {
               const z = this .value;

               if (this .double ())
               {
                  const w = this .value;

                  field .x = this .fromUnit (unit, x);
                  field .y = this .fromUnit (unit, y);
                  field .z = this .fromUnit (unit, z);
                  field .w = this .fromUnit (unit, w);

                  return true;
               }
            }
         }
      }

      return false;
   },
   mfvec4Value (field)
   {
      field .length = 0;

      if (this .sfvec4Value (this .Vector4, field .getUnit ()))
      {
         field .push (this .Vector4);
         return true;
      }

      if (Grammar .OpenBracket .parse (this))
      {
         this .sfvecValues (field);

         if (Grammar .CloseBracket .parse (this))
            return true;

         throw new Error ("Expected ']'.");
      }

      return false;
   },
   unknownValue ()
   {
      try
      {
         ++ this .unknownLevel;

         this .comments ();

         if (Grammar .IS .parse (this))
         {
            if (this .isInsideProtoDeclaration ())
            {
               if (this .Id ())
                  return true;
            }
         }

         if (this .mfunknownValue ())
            return true;

         return false;
      }
      finally
      {
         -- this .unknownLevel;
      }
   },
   sfunknownValue ()
   {
      if (this .sfboolValue (new _Fields_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .SFBool ()))
         return true;

      if (this .sfdoubleValues (new _Fields_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .MFFloat ()))
         return true;

      if (this .sfstringValue (new _Fields_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .SFString ()))
         return true;

      if (this .sfnodeValue (new _Fields_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .SFNode ()))
         return true;

      return false;
   },
   mfunknownValue ()
   {
      if (this .sfunknownValue ())
         return true;

      if (Grammar .OpenBracket .parse (this))
      {
         this .sfunknownValues ();

         if (Grammar .CloseBracket .parse (this))
            return true;

         throw new Error ("Expected ']'.");
      }

      return false;
   },
   sfunknownValues ()
   {
      while (this .sfunknownValue ())
         ;
   },
   accessTypeToString (accessType)
   {
      switch (accessType)
      {
         case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .initializeOnly:
            return "initializeOnly";
         case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .inputOnly:
            return "inputOnly";
         case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .outputOnly:
            return "outputOnly";
         case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .inputOutput:
            return "inputOutput";
      }
   },
});

Object .assign (VRMLParser .prototype,
{
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .SFBool]:      VRMLParser .prototype .sfboolValue,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .SFColor]:     VRMLParser .prototype .sfcolorValue,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .SFColorRGBA]: VRMLParser .prototype .sfcolorrgbaValue,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .SFDouble]:    VRMLParser .prototype .sfdoubleValue,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .SFFloat]:     VRMLParser .prototype .sfdoubleValue,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .SFImage]:     VRMLParser .prototype .sfimageValue,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .SFInt32]:     VRMLParser .prototype .sfint32Value,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .SFMatrix3f]:  VRMLParser .prototype .sfmatrix3Value,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .SFMatrix3d]:  VRMLParser .prototype .sfmatrix3Value,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .SFMatrix4f]:  VRMLParser .prototype .sfmatrix4Value,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .SFMatrix4d]:  VRMLParser .prototype .sfmatrix4Value,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .SFNode]:      VRMLParser .prototype .sfnodeValue,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .SFRotation]:  VRMLParser .prototype .sfrotationValue,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .SFString]:    VRMLParser .prototype .sfstringValue,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .SFTime]:      VRMLParser .prototype .sfdoubleValue,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .SFVec2d]:     VRMLParser .prototype .sfvec2Value,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .SFVec2f]:     VRMLParser .prototype .sfvec2Value,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .SFVec3d]:     VRMLParser .prototype .sfvec3Value,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .SFVec3f]:     VRMLParser .prototype .sfvec3Value,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .SFVec4d]:     VRMLParser .prototype .sfvec4Value,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .SFVec4f]:     VRMLParser .prototype .sfvec4Value,

   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .VrmlMatrix]:  VRMLParser .prototype .sfmatrix4Value,

   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .MFBool]:      VRMLParser .prototype .mfboolValue,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .MFColor]:     VRMLParser .prototype .mfcolorValue,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .MFColorRGBA]: VRMLParser .prototype .mfcolorrgbaValue,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .MFDouble]:    VRMLParser .prototype .mfdoubleValue,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .MFFloat]:     VRMLParser .prototype .mfdoubleValue,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .MFImage]:     VRMLParser .prototype .mfimageValue,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .MFInt32]:     VRMLParser .prototype .mfint32Value,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .MFMatrix3d]:  VRMLParser .prototype .mfmatrix3Value,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .MFMatrix3f]:  VRMLParser .prototype .mfmatrix3Value,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .MFMatrix4d]:  VRMLParser .prototype .mfmatrix4Value,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .MFMatrix4f]:  VRMLParser .prototype .mfmatrix4Value,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .MFNode]:      VRMLParser .prototype .mfnodeValue,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .MFRotation]:  VRMLParser .prototype .mfrotationValue,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .MFString]:    VRMLParser .prototype .mfstringValue,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .MFTime]:      VRMLParser .prototype .mfdoubleValue,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .MFVec2d]:     VRMLParser .prototype .mfvec2Value,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .MFVec2f]:     VRMLParser .prototype .mfvec2Value,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .MFVec3d]:     VRMLParser .prototype .mfvec3Value,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .MFVec3f]:     VRMLParser .prototype .mfvec3Value,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .MFVec4d]:     VRMLParser .prototype .mfvec4Value,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .MFVec4f]:     VRMLParser .prototype .mfvec4Value,
});

_Base_X3DField_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .prototype .fromVRMLString = function (string, scene)
{
   const parser = new VRMLParser (scene);

   parser .setUnits (!!scene);
   parser .setInput (string);

   if (!parser .fieldValue (this))
      throw new Error (`Couldn't read value for field '${this .getName ()}'.`);

   parser .setupNodes ();
};

const __default__ = VRMLParser;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_18__/* ["default"] */ .A .add ("VRMLParser", __default__));

/***/ },

/***/ 3247
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _X3DChildObject_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(3586);
/* harmony import */ var _X3DConstants_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(4946);
/* harmony import */ var _Events_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(8511);
/* harmony import */ var _IterableWeakSet_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(1658);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(6334);





const
   _value               = Symbol (),
   _accessType          = Symbol (),
   _unit                = Symbol (),
   _references          = Symbol (),
   _referencesCallbacks = Symbol (),
   _fieldInterests      = Symbol (),
   _fieldCallbacks      = Symbol (),
   _inputRoutes         = Symbol (),
   _outputRoutes        = Symbol (),
   _routeCallbacks      = Symbol (),
   _appInfo             = Symbol (),
   _documentation       = Symbol (),
   _uniformLocation     = Symbol .for ("X_ITE.X3DField.uniformLocation");

const EMPTY = [ ];

function X3DField (value)
{
   _X3DChildObject_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .call (this);

   this [_value] = value;
}

Object .assign (Object .setPrototypeOf (X3DField .prototype, _X3DChildObject_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .prototype),
{
   [_value]: undefined,
   [_accessType]: _X3DConstants_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .initializeOnly,
   [_unit]: undefined,
   [_references]: null,
   [_referencesCallbacks]: null,
   [_fieldInterests]: null,
   [_fieldCallbacks]: null,
   [_inputRoutes]: null,
   [_outputRoutes]: null,
   [_routeCallbacks]: null,
   [_uniformLocation]: null,
   [_appInfo]: "",
   [_documentation]: "",
   create ()
   {
      return new (this .constructor) ();
   },
   equals (field)
   {
      return this [_value] === field .valueOf ();
   },
   assign (field)
   {
      // Assigns field to this field.
      this .set (field .getValue ());
      this .addEvent ();
   },
   set (value)
   {
      // Sets internal value without generating event.
      this [_value] = value;
   },
   setValue (value)
   {
      // Sets internal value and generates event.
      this .set (value instanceof this .constructor ? value .getValue () : value);
      this .addEvent ();
   },
   getValue ()
   {
      return this [_value];
   },
   getType ()
   {
      return this .constructor .type;
   },
   setAccessType (value)
   {
      this [_accessType] = value;
   },
   getAccessType ()
   {
      return this [_accessType];
   },
   isInitializable ()
   {
      return !! (this [_accessType] & _X3DConstants_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .initializeOnly);
   },
   isInput ()
   {
      return !! (this [_accessType] & _X3DConstants_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .inputOnly);
   },
   isOutput ()
   {
      return !! (this [_accessType] & _X3DConstants_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .outputOnly);
   },
   isReadable ()
   {
      return this [_accessType] !== _X3DConstants_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .inputOnly;
   },
   isWritable ()
   {
      return this [_accessType] !== _X3DConstants_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .outputOnly;
   },
   setUnit (value)
   {
      this [_unit] = value;
   },
   getUnit ()
   {
      return this [_unit];
   },
   isReference (accessType)
   {
      return accessType === this [_accessType] || accessType === _X3DConstants_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .inputOutput;
   },
   addReference (reference)
   {
      const references = this .getReferences ();

      if (references .has (reference))
         return;

      references .add (reference);

      // Create IS relationship

      switch (this .getAccessType () & reference .getAccessType ())
      {
         case _X3DConstants_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .initializeOnly:
            reference .addFieldInterest (this);
            this .processEvent (_Events_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .from (reference));
            break;
         case _X3DConstants_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .inputOnly:
            reference .addFieldInterest (this);
            break;
         case _X3DConstants_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .outputOnly:
            this .addFieldInterest (reference);
            break;
         case _X3DConstants_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .inputOutput:
            reference .addFieldInterest (this);
            this .addFieldInterest (reference);
            this .processEvent (_Events_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .from (reference));
            break;
      }

      this .processReferencesCallbacks ();
   },
   removeReference (reference)
   {
      this [_references] ?.delete (reference);

      // Create IS relationship

      switch (this .getAccessType () & reference .getAccessType ())
      {
         case _X3DConstants_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .initializeOnly:
            reference .removeFieldInterest (this);
            break;
         case _X3DConstants_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .inputOnly:
            reference .removeFieldInterest (this);
            break;
         case _X3DConstants_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .outputOnly:
            this .removeFieldInterest (reference);
            break;
         case _X3DConstants_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .inputOutput:
            reference .removeFieldInterest (this);
            this .removeFieldInterest (reference);
            break;
      }

      this .processReferencesCallbacks ();
   },
   getReferences ()
   {
      return this [_references] ??= new _IterableWeakSet_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A ();
   },
   addReferencesCallback (key, object)
   {
      this [_referencesCallbacks] = new Map (this [_referencesCallbacks]);

      this [_referencesCallbacks] .set (key, object);
   },
   removeReferencesCallback (key)
   {
      this [_referencesCallbacks] ?.delete (key);
   },
   getReferencesCallbacks ()
   {
      return this [_referencesCallbacks] ??= new Map ();
   },
   processReferencesCallbacks ()
   {
      for (const callback of this [_referencesCallbacks] ?.values () ?? EMPTY)
         callback ();
   },
   addFieldInterest (field)
   {
      // There must be no copy, because the event is not executed immediately.

      this .getFieldInterests () .add (field);
   },
   removeFieldInterest (field)
   {
      this [_fieldInterests] ?.delete (field);
   },
   getFieldInterests ()
   {
      return this [_fieldInterests] ??= new _IterableWeakSet_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A ();
   },
   addFieldCallback (key, object)
   {
      this [_fieldCallbacks] = new Map (this [_fieldCallbacks]);

      this [_fieldCallbacks] .set (key, object);
   },
   removeFieldCallback (key)
   {
      this [_fieldCallbacks] ?.delete (key);
   },
   getFieldCallbacks ()
   {
      return this [_fieldCallbacks] ??= new Map ();
   },
   addInputRoute (route)
   {
      this .getInputRoutes () .add (route);
      this .processRouteCallbacks ();
   },
   removeInputRoute (route)
   {
      this [_inputRoutes] ?.delete (route);

      this .processRouteCallbacks ();
   },
   getInputRoutes ()
   {
      return this [_inputRoutes] ??= new _IterableWeakSet_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A ();
   },
   addOutputRoute (route)
   {
      this .getOutputRoutes () .add (route);
      this .processRouteCallbacks ();
   },
   removeOutputRoute (route)
   {
      this [_outputRoutes] ?.delete (route);

      this .processRouteCallbacks ();
   },
   getOutputRoutes ()
   {
      return this [_outputRoutes] ??= new _IterableWeakSet_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A ();
   },
   addRouteCallback (key, object)
   {
      // Processed if routes are changed.

      this [_routeCallbacks] = new Map (this [_routeCallbacks]);

      this [_routeCallbacks] .set (key, object);
   },
   removeRouteCallback (key)
   {
      this [_routeCallbacks] ?.delete (key);
   },
   getRouteCallbacks ()
   {
      return this [_routeCallbacks] ??= new Map ();
   },
   processRouteCallbacks ()
   {
      for (const callback of this [_routeCallbacks] ?.values () ?? EMPTY)
         callback ();
   },
   processEvent (event = _Events_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .create (this))
   {
      event .add (this);

      this .setTainted (false);

      const field = event .field;

      if (field !== this)
         this .set (field .getValue (), field .length);

      // Process interests.

      this .processInterests ();

      // Process routes.

      let first = true;

      for (const field of this [_fieldInterests] ?? EMPTY)
      {
         if (event .has (field))
            continue;

         if (first)
         {
            first = false;
            field .addEventObject (this, event);
         }
         else
         {
            field .addEventObject (this, _Events_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .copy (event));
         }
      }

      if (first)
         _Events_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .push (event);

      // Process field callbacks.

      for (const callback of this [_fieldCallbacks] ?.values () ?? EMPTY)
         callback (this .valueOf ());
   },
   getAppInfo ()
   {
      return this [_appInfo];
   },
   setAppInfo (value)
   {
      this [_appInfo] = String (value);
   },
   setDocumentation (value)
   {
      this [_documentation] = String (value);
   },
   getDocumentation ()
   {
      return this [_documentation];
   },
   fromString (string, scene)
   {
      this .fromVRMLString (string, scene);
   },
   fromVRMLString (string, scene)
   {
      // Function will be overridden in VRMLParser.
   },
   fromXMLString (string, scene)
   {
      // Function will be overridden in XMLParser.
   },
   dispose ()
   {
      for (const reference of this [_references] ?? EMPTY)
         reference .removeFieldInterest (this);

      for (const route of Array .from (this [_inputRoutes] ?? EMPTY))
         route .dispose ();

      for (const route of Array .from (this [_outputRoutes] ?? EMPTY))
         route .dispose ();

      this [_references]          ?.clear ();
      this [_referencesCallbacks] ?.clear ();
      this [_fieldInterests]      ?.clear ();
      this [_fieldCallbacks]      ?.clear ();
      this [_inputRoutes]         ?.clear ();
      this [_outputRoutes]        ?.clear ();
      this [_routeCallbacks]      ?.clear ();

      _X3DChildObject_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .prototype .dispose .call (this);
   }
});

for (const key of Object .keys (X3DField .prototype))
   Object .defineProperty (X3DField .prototype, key, { enumerable: false });

const __default__ = X3DField;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .add ("X3DField", __default__));

/***/ },

/***/ 3503
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Base_X3DInfoArray_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(3046);
/* harmony import */ var _X3DImportedNode_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(4850);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(6334);



function ImportedNodesArray (values = [ ])
{
   return _Base_X3DInfoArray_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .call (this, Array .from (values, value => [value .getImportedName (), value]), _X3DImportedNode_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A);
}

Object .setPrototypeOf (ImportedNodesArray .prototype, _Base_X3DInfoArray_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .prototype);

for (const key of Object .keys (ImportedNodesArray .prototype))
   Object .defineProperty (ImportedNodesArray .prototype, key, { enumerable: false });

Object .defineProperties (ImportedNodesArray,
{
   typeName:
   {
      value: "ImportedNodesArray",
      enumerable: true,
   },
});

const __default__ = ImportedNodesArray;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .add ("ImportedNodesArray", __default__));

/***/ },

/***/ 3515
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  A: () => (/* binding */ x_ite_Fields)
});

// EXTERNAL MODULE: ./src/x_ite/Base/X3DField.js
var X3DField = __webpack_require__(3247);
// EXTERNAL MODULE: ./src/x_ite/Base/X3DConstants.js
var X3DConstants = __webpack_require__(4946);
// EXTERNAL MODULE: ./src/x_ite/Namespace.js
var Namespace = __webpack_require__(6334);
;// ./src/x_ite/Fields/SFScalar.js



function SFBoolTemplate (TypeName)
{
   function SFBool (value)
   {
      X3DField/* default */.A .call (this, !! value);
   }

   return SFScalarPrototypeTemplate (SFBool, TypeName,
   {
      isDefaultValue ()
      {
         return this .getValue () === false;
      },
      set (value)
      {
         X3DField/* default */.A .prototype .set .call (this, !! value);
      },
      toStream (generator)
      {
         generator .string += this .getValue () ? "TRUE" : "FALSE";
      },
      toXMLStream (generator)
      {
         generator .string += this .getValue () ? "true" : "false";
      },
      toJSONStreamValue (generator)
      {
         generator .string += this .getValue () ? "true" : "false";
      },
   });
}

function SFNumberTemplate (TypeName, double, defaultValue)
{
   const _formatter = double ? "DoubleFormat" : "FloatFormat";

   function SFNumber (value)
   {
      X3DField/* default */.A .call (this, arguments .length ? +value : defaultValue);
   }

   return SFScalarPrototypeTemplate (SFNumber, TypeName,
   {
      isDefaultValue ()
      {
         return this .getValue () === defaultValue;
      },
      set (value)
      {
         X3DField/* default */.A .prototype .set .call (this, +value);
      },
      toStream (generator)
      {
         const category = this .getUnit ();

         generator .string += generator [_formatter] (generator .ToUnit (category, this .getValue ()));
      },
      toJSONStreamValue (generator)
      {
         const category = this .getUnit ();

         generator .string += generator .Number (generator [_formatter] (generator .ToUnit (category, this .getValue ())));
      },
   });
}

function SFInt32Template (TypeName)
{
   function SFInt32 (value)
   {
      X3DField/* default */.A .call (this, value|0);
   }

   return SFScalarPrototypeTemplate (SFInt32, TypeName,
   {
      isDefaultValue ()
      {
         return this .getValue () === 0;
      },
      set (value)
      {
         X3DField/* default */.A .prototype .set .call (this, value|0);
      },
   });
}

function SFStringTemplate (TypeName)
{
   function SFString (value)
   {
      X3DField/* default */.A .call (this, arguments .length ? String (value) : "");
   }

   SFScalarPrototypeTemplate (SFString, TypeName,
   {
      *[Symbol .iterator] ()
      {
         yield* this .getValue ();
      },
      isDefaultValue ()
      {
         return this .getValue () === "";
      },
      set (value)
      {
         X3DField/* default */.A .prototype .set .call (this, String (value));
      },
      toStream (generator)
      {
         generator .string += '"';
         generator .string += SFString .escape (this .getValue ());
         generator .string += '"';
      },
      toXMLStream (generator, sourceText = false)
      {
         generator .string += sourceText
            ? generator .EncodeSourceText (this .getValue ())
            : generator .EncodeString (this .getValue ());
      },
      toJSONStreamValue (generator)
      {
         generator .string += '"';
         generator .string += generator .EncodeString (this .getValue ());
         generator .string += '"';
      },
   });

   Object .defineProperty (SFString .prototype, "length",
   {
      get ()
      {
         return this .getValue () .length;
      },
   });

   Object .assign (SFString,
   {
      unescape (string)
      {
         return string .replace (/\\([\\"])/g, "$1");
      },
      escape (string)
      {
         return string .replace (/([\\"])/g, "\\$1");
      },
   });

   return SFString;
}

function SFScalarPrototypeTemplate (Constructor, TypeName, properties = { })
{
   Object .defineProperties (Constructor,
   {
      type:
      {
         value: X3DConstants/* default */.A [TypeName],
         enumerable: true,
      },
      typeName:
      {
         value: TypeName,
         enumerable: true,
      },
   });

   Object .assign (Object .setPrototypeOf (Constructor .prototype, X3DField/* default */.A .prototype),
   {
      copy ()
      {
         return new Constructor (this .getValue ());
      },
      valueOf: X3DField/* default */.A .prototype .getValue,
      toStream (generator)
      {
         generator .string += String (this .getValue ());
      },
      toVRMLStream (generator)
      {
         this .toStream (generator);
      },
      toXMLStream (generator)
      {
         this .toStream (generator);
      },
      toJSONStream (generator)
      {
         this .toJSONStreamValue (generator);
      },
      toJSONStreamValue (generator)
      {
         this .toStream (generator);
      },
   },
   properties);

   for (const key of Object .keys (Constructor .prototype))
      Object .defineProperty (Constructor .prototype, key, { enumerable: false });

   return Constructor;
}

const SFScalar = {
   SFBool:   SFBoolTemplate   ("SFBool"),
   SFDouble: SFNumberTemplate ("SFDouble", true,  0),
   SFFloat:  SFNumberTemplate ("SFFloat",  false, 0),
   SFInt32:  SFInt32Template  ("SFInt32"),
   SFString: SFStringTemplate ("SFString"),
   SFTime:   SFNumberTemplate ("SFTime",   true, -1),
};

const __default__ = SFScalar;
;

/* harmony default export */ const Fields_SFScalar = (Namespace/* default */.A .add ("SFScalar", __default__));
// EXTERNAL MODULE: ./src/standard/Math/Numbers/Color3.js
var Color3 = __webpack_require__(2028);
;// ./src/x_ite/Fields/SFColor.js




function SFColor (r, g, b)
{
   switch (arguments .length)
   {
      case 0:
         X3DField/* default */.A .call (this, new Color3/* default */.A ());
         break;

      case 1:
         X3DField/* default */.A .call (this, arguments [0]);
         break;

      case 3:
         X3DField/* default */.A .call (this, new Color3/* default */.A (+r, +g, +b));
         break;

      default:
         throw new Error ("Invalid arguments.");
   }
}

Object .assign (Object .setPrototypeOf (SFColor .prototype, X3DField/* default */.A .prototype),
{
   *[Symbol .iterator] ()
   {
      yield* this .getValue ();
   },
   copy ()
   {
      return new SFColor (this .getValue () .copy ());
   },
   equals (color)
   {
      return this .getValue () .equals (color .getValue ());
   },
   isDefaultValue ()
   {
      return this .getValue () .equals (Color3/* default */.A .BLACK);
   },
   set (value)
   {
      this .getValue () .assign (value);
   },
   getHSV ()
   {
      return this .getValue () .getHSV ([ ]);
   },
   setHSV (h, s, v)
   {
      this .getValue () .setHSV (h, s, v);
      this .addEvent ();
   },
   linearToSRGB ()
   {
      return new SFColor (this .getValue () .linearToSRGB ());
   },
   sRGBToLinear ()
   {
      return new SFColor (this .getValue () .sRGBToLinear ());
   },
   lerp: (() =>
   {
      const
         s = [ ],
         d = [ ],
         r = [ ];

      return function (destination, t)
      {
         const result = new SFColor ();

         this .getValue () .getHSV (s);
         destination .getValue () .getHSV (d);

         Color3/* default */.A .lerp (s, d, t, r);

         result .setHSV (r [0], r [1], r [2]);

         return result;
      };
   })(),
   toStream (generator)
   {
      const
         value = this .getValue (),
         last  = value .length - 1;

      for (let i = 0; i < last; ++ i)
      {
         generator .string += generator .FloatFormat (value [i]);
         generator .Space ();
      }

      generator .string += generator .FloatFormat (value [last]);
   },
   toVRMLStream (generator)
   {
      this .toStream (generator);
   },
   toXMLStream (generator)
   {
      this .toStream (generator);
   },
   toJSONStream (generator)
   {
      generator .string += '[';
      generator .TidySpace ();

      this .toJSONStreamValue (generator);

      generator .TidySpace ();
      generator .string += ']';
   },
   toJSONStreamValue (generator)
   {
      const
         value = this .getValue (),
         last  = value .length - 1;

      for (let i = 0; i < last; ++ i)
      {
         generator .string += generator .Number (generator .FloatFormat (value [i]));
         generator .string += ',';
         generator .TidySpace ();
      }

      generator .string += generator .Number (generator .FloatFormat (value [last]));
   },
});

for (const key of Object .keys (SFColor .prototype))
   Object .defineProperty (SFColor .prototype, key, { enumerable: false });

const r = {
   get ()
   {
      return this .getValue () .r;
   },
   set (value)
   {
      this .getValue () .r = +value;
      this .addEvent ();
   },
};

const g = {
   get ()
   {
      return this .getValue () .g;
   },
   set (value)
   {
      this .getValue () .g = +value;
      this .addEvent ();
   },
};

const b = {
   get ()
   {
      return this .getValue () .b;
   },
   set (value)
   {
      this .getValue () .b = +value;
      this .addEvent ();
   },
};

Object .defineProperties (SFColor .prototype,
{
   0: r,
   1: g,
   2: b,
   r: Object .assign ({ enumerable: true }, r),
   g: Object .assign ({ enumerable: true }, g),
   b: Object .assign ({ enumerable: true }, b),
});

Object .defineProperties (SFColor,
{
   type:
   {
      value: X3DConstants/* default */.A .SFColor,
      enumerable: true,
   },
   typeName:
   {
      value: "SFColor",
      enumerable: true,
   },
});

const SFColor_default_ = SFColor;
;

/* harmony default export */ const Fields_SFColor = (Namespace/* default */.A .add ("SFColor", SFColor_default_));
// EXTERNAL MODULE: ./src/standard/Math/Numbers/Color4.js
var Color4 = __webpack_require__(857);
;// ./src/x_ite/Fields/SFColorRGBA.js





function SFColorRGBA (r, g, b, a)
{
   switch (arguments .length)
   {
      case 0:
         X3DField/* default */.A .call (this, new Color4/* default */.A ());
         break;

      case 1:
         X3DField/* default */.A .call (this, arguments [0]);
         break;

      case 4:
         X3DField/* default */.A .call (this, new Color4/* default */.A (+r, +g, +b, +a));
         break

      default:
         throw new Error ("Invalid arguments.");
   }
}

Object .assign (Object .setPrototypeOf (SFColorRGBA .prototype, X3DField/* default */.A .prototype),
{
   *[Symbol .iterator] ()
   {
      yield* this .getValue ();
   },
   copy ()
   {
      return new SFColorRGBA (this .getValue () .copy ());
   },
   equals: Fields_SFColor .prototype .equals,
   isDefaultValue ()
   {
      return this .getValue () .equals (Color4/* default */.A .TRANSPARENT);
   },
   set: Fields_SFColor .prototype .set,
   getHSVA ()
   {
      return this .getValue () .getHSVA ([ ]);
   },
   setHSVA (h, s, v, a)
   {
      this .getValue () .setHSVA (h, s, v, a);
      this .addEvent ();
   },
   linearToSRGB ()
   {
      return new SFColorRGBA (this .getValue () .linearToSRGB ());
   },
   sRGBToLinear ()
   {
      return new SFColorRGBA (this .getValue () .sRGBToLinear ());
   },
   lerp: (() =>
   {
      const
         s = [ ],
         d = [ ],
         r = [ ];

      return function (destination, t)
      {
         const result = new SFColorRGBA ();

         this .getValue () .getHSVA (s);
         destination .getValue () .getHSVA (d);

         Color4/* default */.A .lerp (s, d, t, r);

         result .setHSVA (r [0], r [1], r [2], r [3]);

         return result;
      };
   })(),
   toStream: Fields_SFColor .prototype .toStream,
   toVRMLStream: Fields_SFColor .prototype .toVRMLStream,
   toXMLStream: Fields_SFColor .prototype .toXMLStream,
   toJSONStream: Fields_SFColor .prototype .toJSONStream,
   toJSONStreamValue: Fields_SFColor .prototype .toJSONStreamValue,
});

for (const key of Object .keys (SFColorRGBA .prototype))
   Object .defineProperty (SFColorRGBA .prototype, key, { enumerable: false });

const SFColorRGBA_r = {
   get ()
   {
      return this .getValue () .r;
   },
   set (value)
   {
      this .getValue () .r = +value;
      this .addEvent ();
   },
};

const SFColorRGBA_g = {
   get ()
   {
      return this .getValue () .g;
   },
   set (value)
   {
      this .getValue () .g = +value;
      this .addEvent ();
   },
};

const SFColorRGBA_b = {
   get ()
   {
      return this .getValue () .b;
   },
   set (value)
   {
      this .getValue () .b = +value;
      this .addEvent ();
   },
};

const a = {
   get ()
   {
      return this .getValue () .a;
   },
   set (value)
   {
      this .getValue () .a = +value;
      this .addEvent ();
   },
};

Object .defineProperties (SFColorRGBA .prototype,
{
   0: SFColorRGBA_r,
   1: SFColorRGBA_g,
   2: SFColorRGBA_b,
   3: a,
   r: Object .assign ({ enumerable: true }, SFColorRGBA_r),
   g: Object .assign ({ enumerable: true }, SFColorRGBA_g),
   b: Object .assign ({ enumerable: true }, SFColorRGBA_b),
   a: Object .assign ({ enumerable: true }, a),
});

Object .defineProperties (SFColorRGBA,
{
   type:
   {
      value: X3DConstants/* default */.A .SFColorRGBA,
      enumerable: true,
   },
   typeName:
   {
      value: "SFColorRGBA",
      enumerable: true,
   },
});

const SFColorRGBA_default_ = SFColorRGBA;
;

/* harmony default export */ const Fields_SFColorRGBA = (Namespace/* default */.A .add ("SFColorRGBA", SFColorRGBA_default_));
;// ./src/x_ite/Fields/SFMatrixPrototypeTemplate.js



function SFMatrixPrototypeTemplate (Constructor, TypeName, Matrix, double, properties = { })
{
   const _formatter = double ? "DoubleFormat" : "FloatFormat";

   Object .defineProperties (Constructor,
   {
      type:
      {
         value: X3DConstants/* default */.A [TypeName],
         enumerable: true,
      },
      typeName:
      {
         value: TypeName,
         enumerable: true,
      },
   });

   Object .assign (Object .setPrototypeOf (Constructor .prototype, X3DField/* default */.A .prototype),
   {
      *[Symbol .iterator] ()
      {
         yield* this .getValue ();
      },
      copy ()
      {
         return new (this .constructor) (this .getValue () .copy ());
      },
      equals (matrix)
      {
         return this .getValue () .equals (matrix .getValue ());
      },
      isDefaultValue ()
      {
         return this .getValue () .equals (Matrix .IDENTITY);
      },
      set (value)
      {
         this .getValue () .assign (value);
      },
      setTransform: (() =>
      {
         const args = [ ];

         return function (translation, rotation, scale, scaleOrientation, center)
         {
            args .push (translation      ?.getValue (),
                        rotation         ?.getValue (),
                        scale            ?.getValue (),
                        scaleOrientation ?.getValue (),
                        center           ?.getValue ());

            for (let i = args .length - 1; i > -1; -- i)
            {
               if (args [i])
                  break;

               args .pop ();
            }

            this .getValue () .set (... args);

            args .length = 0;
         };
      })(),
      getTransform: (() =>
      {
         const args = [ ];

         return function (translation, rotation, scale, scaleOrientation, center)
         {
            args .push (translation      ?.getValue (),
                        rotation         ?.getValue (),
                        scale            ?.getValue (),
                        scaleOrientation ?.getValue (),
                        center           ?.getValue ());

            for (let i = args .length - 1; i > -1; -- i)
            {
               if (args [i])
                  break;

               args .pop ();
            }

            this .getValue () .get (... args);

            translation      ?.addEvent ();
            rotation         ?.addEvent ();
            scale            ?.addEvent ();
            scaleOrientation ?.addEvent ();

            args .length = 0;
         };
      })(),
      determinant ()
      {
         return this .getValue () .determinant ();
      },
      transpose ()
      {
         return new (this .constructor) (this .getValue () .copy () .transpose ());
      },
      inverse ()
      {
         return new (this .constructor) (this .getValue () .copy () .inverse ());
      },
      multLeft (matrix)
      {
         return new (this .constructor) (this .getValue () .copy () .multLeft (matrix .getValue ()));
      },
      multRight (matrix)
      {
         return new (this .constructor) (this .getValue () .copy () .multRight (matrix .getValue ()));
      },
      multVecMatrix (vector)
      {
         return new (vector .constructor) (this .getValue () .multVecMatrix (vector .getValue () .copy ()));
      },
      multMatrixVec (vector)
      {
         return new (vector .constructor) (this .getValue () .multMatrixVec (vector .getValue () .copy ()));
      },
      multDirMatrix (vector)
      {
         return new (vector .constructor) (this .getValue () .multDirMatrix (vector .getValue () .copy ()));
      },
      multMatrixDir (vector)
      {
         return new (vector .constructor) (this .getValue () .multMatrixDir (vector .getValue () .copy ()));
      },
      translate (translation)
      {
         return new (this .constructor) (this .getValue () .copy () .translate (translation .getValue ()));
      },
      rotate (rotation)
      {
         return new (this .constructor) (this .getValue () .copy () .rotate (rotation .getValue ()));
      },
      scale (scale)
      {
         return new (this .constructor) (this .getValue () .copy () .scale (scale .getValue ()));
      },
      toStream (generator)
      {
         const
            value = this .getValue (),
            last  = value .length - 1;

         for (let i = 0; i < last; ++ i)
         {
            generator .string += generator [_formatter] (value [i]);
            generator .Space ();
         }

         generator .string += generator [_formatter] (value [last]);
      },
      toVRMLStream (generator)
      {
         this .toStream (generator);
      },
      toXMLStream (generator)
      {
         this .toStream (generator);
      },
      toJSONStream (generator)
      {
         generator .string += '[';
         generator .TidySpace ();

         this .toJSONStreamValue (generator);

         generator .TidySpace ();
         generator .string += ']';
      },
      toJSONStreamValue (generator)
      {
         const
            value = this .getValue (),
            last  = value .length - 1;

         for (let i = 0; i < last; ++ i)
         {
            generator .string += generator .Number (generator [_formatter] (value [i]));
            generator .string += ',';
            generator .TidySpace ();
         }

         generator .string += generator .Number (generator [_formatter] (value [last]));
      },
   },
   properties);

   for (const key of Object .keys (Constructor .prototype))
      Object .defineProperty (Constructor .prototype, key, { enumerable: false });

   function defineProperty (i)
   {
      Object .defineProperty (Constructor .prototype, i,
      {
         get ()
         {
            return this .getValue () [i];
         },
         set (value)
         {
            this .getValue () [i] = +value;
            this .addEvent ();
         },
         enumerable: true,
      });
   }

   for (let i = 0; i < Matrix .prototype .length; ++ i)
      defineProperty (i);

   return Constructor;
}

const SFMatrixPrototypeTemplate_default_ = SFMatrixPrototypeTemplate;
;

/* harmony default export */ const Fields_SFMatrixPrototypeTemplate = (Namespace/* default */.A .add ("SFMatrixPrototypeTemplate", SFMatrixPrototypeTemplate_default_));
// EXTERNAL MODULE: ./src/standard/Math/Numbers/Matrix3.js + 1 modules
var Matrix3 = __webpack_require__(1224);
;// ./src/x_ite/Fields/SFMatrix3.js




function SFMatrix3Template (TypeName, double)
{
   function SFMatrix3 (m00, m01, m02,
                       m10, m11, m12,
                       m20, m21, m22)
   {
      switch (arguments .length)
      {
         case 0:
            X3DField/* default */.A .call (this, new Matrix3/* default */.A ());
            break;

         case 1:
            X3DField/* default */.A .call (this, arguments [0]);
            break;

         case 3:
         {
            const
               r0 = arguments [0],
               r1 = arguments [1],
               r2 = arguments [2];

            X3DField/* default */.A .call (this, new Matrix3/* default */.A (r0 .x, r0 .y, r0 .z,
                                               r1 .x, r1 .y, r1 .z,
                                               r2 .x, r2 .y, r2 .z));

            break;
         }
         case 9:
         {
            X3DField/* default */.A .call (this, new Matrix3/* default */.A (+m00, +m01, +m02,
                                               +m10, +m11, +m12,
                                               +m20, +m21, +m22));

            break;
         }
         default:
            throw new Error ("Invalid arguments.");
      }
   }

   return Fields_SFMatrixPrototypeTemplate (SFMatrix3, TypeName, Matrix3/* default */.A, double,
   {
      setTransform: (() =>
      {
         const args = [ ];

         return function (translation, rotation, scale, scaleOrientation, center)
         {
            args .push (translation ?.getValue (), rotation, scale ?.getValue (), scaleOrientation, center ?.getValue ());

            for (let i = args .length - 1; i > -1; -- i)
            {
               if (args [i])
                  break;

               args .pop ();
            }

            this .getValue () .set (... args);

            args .length = 0;
         };
      })(),
      rotate (rotation)
      {
         return new (this .constructor) (this .getValue () .copy () .rotate (rotation));
      },
      skewX (angle)
      {
         return new (this .constructor) (this .getValue () .copy () .skewX (angle));
      },
      skewY (angle)
      {
         return new (this .constructor) (this .getValue () .copy () .skewY (angle));
      },
   });
}

const SFMatrix3 = {
   SFMatrix3d: SFMatrix3Template ("SFMatrix3d", true),
   SFMatrix3f: SFMatrix3Template ("SFMatrix3f", false),
};

const SFMatrix3_default_ = SFMatrix3;
;

/* harmony default export */ const Fields_SFMatrix3 = (Namespace/* default */.A .add ("SFMatrix3", SFMatrix3_default_));
// EXTERNAL MODULE: ./src/standard/Math/Numbers/Matrix4.js
var Matrix4 = __webpack_require__(2597);
;// ./src/x_ite/Fields/SFMatrix4.js




function SFMatrix4Template (TypeName, double)
{
   function SFMatrix4 (m00, m01, m02, m03,
                       m10, m11, m12, m13,
                       m20, m21, m22, m23,
                       m30, m31, m32, m33)
   {
      switch (arguments .length)
      {
         case 0:
            X3DField/* default */.A .call (this, new Matrix4/* default */.A ());
            break;

         case 1:
            X3DField/* default */.A .call (this, arguments [0]);
            break;

         case 4:
         {
            const
               r0 = arguments [0],
               r1 = arguments [1],
               r2 = arguments [2],
               r3 = arguments [3];

            X3DField/* default */.A .call (this, new Matrix4/* default */.A (r0 .x, r0 .y, r0 .z, r0 .w,
                                               r1 .x, r1 .y, r1 .z, r1 .w,
                                               r2 .x, r2 .y, r2 .z, r2 .w,
                                               r3 .x, r3 .y, r3 .z, r3 .w));

            break;
         }
         case 16:
         {
            X3DField/* default */.A .call (this, new Matrix4/* default */.A (+m00, +m01, +m02, +m03,
                                               +m10, +m11, +m12, +m13,
                                               +m20, +m21, +m22, +m23,
                                               +m30, +m31, +m32, +m33));

            break;
         }
         default:
            throw new Error ("Invalid arguments.");
      }
   }

   return Fields_SFMatrixPrototypeTemplate (SFMatrix4, TypeName, Matrix4/* default */.A, double);
}

const SFMatrix4 = {
   SFMatrix4d: SFMatrix4Template ("SFMatrix4d", true),
   SFMatrix4f: SFMatrix4Template ("SFMatrix4f", false),
   VrmlMatrix: SFMatrix4Template ("VrmlMatrix", false),
};

const SFMatrix4_default_ = SFMatrix4;
;

/* harmony default export */ const Fields_SFMatrix4 = (Namespace/* default */.A .add ("SFMatrix4", SFMatrix4_default_));
// EXTERNAL MODULE: ./src/x_ite/Fields/SFNode.js
var SFNode = __webpack_require__(4815);
;// ./src/x_ite/Fields/SFVecPrototypeTemplate.js



function SFVecPrototypeTemplate (Constructor, TypeName, Vector, double, properties = { })
{
   const _formatter = double ? "DoubleFormat" : "FloatFormat";

   Object .defineProperties (Constructor,
   {
      type:
      {
         value: X3DConstants/* default */.A [TypeName],
         enumerable: true,
      },
      typeName:
      {
         value: TypeName,
         enumerable: true,
      },
   });

   Object .assign (Object .setPrototypeOf (Constructor .prototype, X3DField/* default */.A .prototype),
   {
      *[Symbol .iterator] ()
      {
         yield* this .getValue ();
      },
      copy ()
      {
         return new (this .constructor) (this .getValue () .copy ());
      },
      equals (vector)
      {
         return this .getValue () .equals (vector .getValue ());
      },
      isDefaultValue ()
      {
         return this .getValue () .equals (Vector .ZERO);
      },
      set (value)
      {
         this .getValue () .assign (value);
      },
      abs ()
      {
         return new (this .constructor) (this .getValue () .copy () .abs ());
      },
      add (vector)
      {
         return new (this .constructor) (this .getValue () .copy () .add (vector .getValue ()));
      },
      clamp (low, high)
      {
         return new (this .constructor) (this .getValue () .copy () .clamp (low .getValue (), high .getValue ()));
      },
      distance (vector)
      {
         return this .getValue () .distance (vector .getValue ());
      },
      divide (value)
      {
         return new (this .constructor) (this .getValue () .copy () .divide (value));
      },
      divVec (vector)
      {
         return new (this .constructor) (this .getValue () .copy () .divVec (vector .getValue ()));
      },
      dot (vector)
      {
         return this .getValue () .dot (vector .getValue ());
      },
      inverse ()
      {
         return new (this .constructor) (this .getValue () .copy () .inverse ());
      },
      length ()
      {
         return this .getValue () .norm ();
      },
      lerp (destination, t)
      {
         return new (this .constructor) (this .getValue () .copy () .lerp (destination, t));
      },
      max (vector)
      {
         return new (this .constructor) (this .getValue () .copy () .max (vector .getValue ()));
      },
      min (vector)
      {
         return new (this .constructor) (this .getValue () .copy () .min (vector .getValue ()));
      },
      multiply (value)
      {
         return new (this .constructor) (this .getValue () .copy () .multiply (value));
      },
      multVec (vector)
      {
         return new (this .constructor) (this .getValue () .copy () .multVec (vector .getValue ()));
      },
      negate ()
      {
         return new (this .constructor) (this .getValue () .copy () .negate ());
      },
      normalize (vector)
      {
         return new (this .constructor) (this .getValue () .copy () .normalize ());
      },
      subtract (vector)
      {
         return new (this .constructor) (this .getValue () .copy () .subtract (vector .getValue ()));
      },
      toStream (generator)
      {
         const
            value    = this .getValue (),
            last     = value .length - 1,
            category = this .getUnit ();

         for (let i = 0; i < last; ++ i)
         {
            generator .string += generator [_formatter] (generator .ToUnit (category, value [i]));
            generator .Space ();
         }

         generator .string += generator [_formatter] (generator .ToUnit (category, value [last]));
      },
      toVRMLStream (generator)
      {
         this .toStream (generator);
      },
      toXMLStream (generator)
      {
         this .toStream (generator);
      },
      toJSONStream (generator)
      {
         generator .string += '[';
         generator .TidySpace ();

         this .toJSONStreamValue (generator);

         generator .TidySpace ();
         generator .string += ']';
      },
      toJSONStreamValue (generator)
      {
         const
            value    = this .getValue (),
            last     = value .length - 1,
            category = this .getUnit ();

         for (let i = 0; i < last; ++ i)
         {
            generator .string += generator .Number (generator [_formatter] (generator .ToUnit (category, value [i])));
            generator .string += ',';
            generator .TidySpace ();
         }

         generator .string += generator .Number (generator [_formatter] (generator .ToUnit (category, value [last])));
      },
   },
   properties);

   for (const key of Object .keys (Constructor .prototype))
      Object .defineProperty (Constructor .prototype, key, { enumerable: false });

   const x = {
      get ()
      {
         return this .getValue () .x;
      },
      set (value)
      {
         this .getValue () .x = +value;
         this .addEvent ();
      },
   };

   const y = {
      get ()
      {
         return this .getValue () .y;
      },
      set (value)
      {
         this .getValue () .y = +value;
         this .addEvent ();
      },
   };

   const z = {
      get ()
      {
         return this .getValue () .z;
      },
      set (value)
      {
         this .getValue () .z = +value;
         this .addEvent ();
      },
   };

   const w = {
      get ()
      {
         return this .getValue () .w;
      },
      set (value)
      {
         this .getValue () .w = +value;
         this .addEvent ();
      },
   };

   const indices = [
      [0, x],
      [1, y],
      [2, z],
      [3, w],
   ];

   const props = [
      ["x", Object .assign ({ enumerable: true }, x)],
      ["y", Object .assign ({ enumerable: true }, y)],
      ["z", Object .assign ({ enumerable: true }, z)],
      ["w", Object .assign ({ enumerable: true }, w)],
   ];

   indices .length = Vector .prototype .length;
   props   .length = Vector .prototype .length;

   Object .defineProperties (Constructor .prototype, Object .fromEntries (indices .concat (props)));

   return Constructor;
}

const SFVecPrototypeTemplate_default_ = SFVecPrototypeTemplate;
;

/* harmony default export */ const Fields_SFVecPrototypeTemplate = (Namespace/* default */.A .add ("SFVecPrototypeTemplate", SFVecPrototypeTemplate_default_));
// EXTERNAL MODULE: ./src/standard/Math/Numbers/Vector3.js
var Vector3 = __webpack_require__(7910);
;// ./src/x_ite/Fields/SFVec3.js




function SFVec3Template (TypeName, double)
{
   function SFVec3 (x, y, z)
   {
      switch (arguments .length)
      {
         case 0:
            X3DField/* default */.A .call (this, new Vector3/* default */.A ());
            break;

         case 1:
            X3DField/* default */.A .call (this, arguments [0]);
            break;

         case 3:
            X3DField/* default */.A .call (this, new Vector3/* default */.A (+x, +y, +z));
            break;

         default:
            throw new Error ("Invalid arguments.");
      }
   }

   return Fields_SFVecPrototypeTemplate (SFVec3, TypeName, Vector3/* default */.A, double,
   {
      cross (vector)
      {
         return new (this .constructor) (this .getValue () .copy () .cross (vector .getValue ()));
      },
   });
}

const SFVec3 = {
   SFVec3d: SFVec3Template ("SFVec3d", true),
   SFVec3f: SFVec3Template ("SFVec3f", false),
};

const SFVec3_default_ = SFVec3;
;

/* harmony default export */ const Fields_SFVec3 = (Namespace/* default */.A .add ("SFVec3", SFVec3_default_));
// EXTERNAL MODULE: ./src/standard/Math/Numbers/Rotation4.js
var Rotation4 = __webpack_require__(4580);
// EXTERNAL MODULE: ./src/standard/Math/Numbers/Quaternion.js
var Quaternion = __webpack_require__(4556);
;// ./src/x_ite/Fields/SFRotation.js







const
   SFVec3d    = Fields_SFVec3 .SFVec3d,
   SFVec3f    = Fields_SFVec3 .SFVec3f,
   SFMatrix3d = Fields_SFMatrix3 .SFMatrix3d,
   SFMatrix3f = Fields_SFMatrix3 .SFMatrix3f;

function SFRotation (x, y, z, angle)
{
   switch (arguments .length)
   {
      case 0:
      {
         X3DField/* default */.A .call (this, new Rotation4/* default */.A ());
         break;
      }
      case 1:
      {
         if ((arguments [0] instanceof SFMatrix3d) || (arguments [0] instanceof SFMatrix3f))
         {
            X3DField/* default */.A .call (this, new Rotation4/* default */.A () .setMatrix (arguments [0] .getValue ()));
            break;
         }

         X3DField/* default */.A .call (this, arguments [0]);
         break;
      }
      case 2:
      {
         if ((arguments [1] instanceof SFVec3d) || (arguments [1] instanceof SFVec3f))
         {
            X3DField/* default */.A .call (this, new Rotation4/* default */.A (arguments [0] .getValue (), arguments [1] .getValue ()));
            break;
         }

         X3DField/* default */.A .call (this, new Rotation4/* default */.A (arguments [0] .getValue (), +arguments [1]));
         break;
      }
      case 4:
      {
         X3DField/* default */.A .call (this, new Rotation4/* default */.A (+x, +y, +z, +angle));
         break;
      }
      default:
         throw new Error ("Invalid arguments.");
   }
}

Object .assign (Object .setPrototypeOf (SFRotation .prototype, X3DField/* default */.A .prototype),
{
   *[Symbol .iterator] ()
   {
      yield* this .getValue ();
   },
   copy ()
   {
      return new SFRotation (this .getValue () .copy ());
   },
   equals (rotation)
   {
      return this .getValue () .equals (rotation .getValue ());
   },
   isDefaultValue ()
   {
      return this .getValue () .equals (Rotation4/* default */.A .IDENTITY);
   },
   set (value)
   {
      this .getValue () .assign (value);
   },
   setAxis (vector)
   {
      this .getValue () .setAxis (vector .getValue ());
      this .addEvent ();
   },
   getAxis ()
   {
      return new SFVec3f (this .getValue () .getAxis ());
   },
   setMatrix (matrix)
   {
      this .getValue () .setMatrix (matrix .getValue ());
      this .addEvent ();
   },
   getMatrix ()
   {
      return new SFMatrix3f (this .getValue () .getMatrix ());
   },
   setQuaternion: (() =>
   {
      const q = new Quaternion/* default */.A ();

      return function (x, y, z, w)
      {
         this .getValue () .setQuaternion (q .set (x, y, z, w));
         this .addEvent ();
      };
   })(),
   getQuaternion: (() =>
   {
      const q = new Quaternion/* default */.A ();

      return function ()
      {
         return [... this .getValue () .getQuaternion (q)];
      };
   })(),
   inverse ()
   {
      return new SFRotation (this .getValue () .copy () .inverse ());
   },
   multiply (rotation)
   {
      return new SFRotation (this .getValue () .copy () .multRight (rotation .getValue ()));
   },
   multVec (vector)
   {
      return new (vector .constructor) (this .getValue () .multVecRot (vector .getValue () .copy ()));
   },
   slerp (rotation, t)
   {
      return new SFRotation (this .getValue () .copy () .slerp (rotation .getValue (), t));
   },
   straighten (upVector)
   {
      return new SFRotation (this .getValue () .copy () .straighten (upVector ?.getValue ()));
   },
   toStream (generator)
   {
      const { x, y, z, angle } = this .getValue ();

      generator .string += generator .DoubleFormat (x);
      generator .Space ();
      generator .string += generator .DoubleFormat (y);
      generator .Space ();
      generator .string += generator .DoubleFormat (z);
      generator .Space ();
      generator .string += generator .DoubleFormat (generator .ToUnit ("angle", angle));
   },
   toVRMLStream (generator)
   {
      this .toStream (generator);
   },
   toXMLStream (generator)
   {
      this .toStream (generator);
   },
   toJSONStream (generator)
   {
      generator .string += '[';
      generator .TidySpace ();

      this .toJSONStreamValue (generator);

      generator .TidySpace ();
      generator .string += ']';
   },
   toJSONStreamValue (generator)
   {
      const { x, y, z, angle } = this .getValue ();

      generator .string += generator .Number (generator .DoubleFormat (x));
      generator .string += ',';
      generator .TidySpace ();
      generator .string += generator .Number (generator .DoubleFormat (y));
      generator .string += ',';
      generator .TidySpace ();
      generator .string += generator .Number (generator .DoubleFormat (z));
      generator .string += ',';
      generator .TidySpace ();
      generator .string += generator .Number (generator .DoubleFormat (generator .ToUnit ("angle", angle)));
   },
});

for (const key of Object .keys (SFRotation .prototype))
   Object .defineProperty (SFRotation .prototype, key, { enumerable: false });

const x = {
   get ()
   {
      return this .getValue () .x;
   },
   set (value)
   {
      this .getValue () .x = +value;
      this .addEvent ();
   },
};

const y = {
   get ()
   {
      return this .getValue () .y;
   },
   set (value)
   {
      this .getValue () .y = +value;
      this .addEvent ();
   },
};

const z = {
   get ()
   {
      return this .getValue () .z;
   },
   set (value)
   {
      this .getValue () .z = +value;
      this .addEvent ();
   },
};

const angle = {
   get ()
   {
      return this .getValue () .angle;
   },
   set (value)
   {
      this .getValue () .angle = +value;
      this .addEvent ();
   },
};

Object .defineProperties (SFRotation .prototype,
{
   0: x,
   1: y,
   2: z,
   3: angle,
   x: Object .assign ({ enumerable: true }, x),
   y: Object .assign ({ enumerable: true }, y),
   z: Object .assign ({ enumerable: true }, z),
   angle: Object .assign ({ enumerable: true }, angle),
});

Object .defineProperties (SFRotation,
{
   type:
   {
      value: X3DConstants/* default */.A .SFRotation,
      enumerable: true,
   },
   typeName:
   {
      value: "SFRotation",
      enumerable: true,
   },
});

const SFRotation_default_ = SFRotation;
;

/* harmony default export */ const Fields_SFRotation = (Namespace/* default */.A .add ("SFRotation", SFRotation_default_));
// EXTERNAL MODULE: ./src/standard/Math/Numbers/Vector2.js
var Vector2 = __webpack_require__(2005);
;// ./src/x_ite/Fields/SFVec2.js




function SFVec2Template (TypeName, double)
{
   function SFVec2 (x, y)
   {
      switch (arguments .length)
      {
         case 0:
            X3DField/* default */.A .call (this, new Vector2/* default */.A ());
            break;

         case 1:
            X3DField/* default */.A .call (this, arguments [0]);
            break;

         case 2:
            X3DField/* default */.A .call (this, new Vector2/* default */.A (+x, +y));
            break;

         default:
            throw new Error ("Invalid arguments.");
      }
   }

   return Fields_SFVecPrototypeTemplate (SFVec2, TypeName, Vector2/* default */.A, double);
}

const SFVec2 = {
   SFVec2d: SFVec2Template ("SFVec2d", true),
   SFVec2f: SFVec2Template ("SFVec2f", false),
};

const SFVec2_default_ = SFVec2;
;

/* harmony default export */ const Fields_SFVec2 = (Namespace/* default */.A .add ("SFVec2", SFVec2_default_));
// EXTERNAL MODULE: ./src/standard/Math/Numbers/Vector4.js
var Vector4 = __webpack_require__(7591);
;// ./src/x_ite/Fields/SFVec4.js




function SFVec4Template (TypeName, double)
{
   function SFVec4 (x, y, z, w)
   {
      switch (arguments .length)
      {
         case 0:
            X3DField/* default */.A .call (this, new Vector4/* default */.A (0, 0, 0, 1));
            break;

         case 1:
            X3DField/* default */.A .call (this, arguments [0]);
            break;

         case 4:
            X3DField/* default */.A .call (this, new Vector4/* default */.A (+x, +y, +z, +w));
            break;

         default:
            throw new Error ("Invalid arguments.");
      }
   }

   return Fields_SFVecPrototypeTemplate (SFVec4, TypeName, Vector4/* default */.A, double,
   {
      isDefaultValue ()
      {
         return this .getValue () .equals (Vector4/* default */.A .W_AXIS);
      },
   });
}

const SFVec4 = {
   SFVec4d: SFVec4Template ("SFVec4d", true),
   SFVec4f: SFVec4Template ("SFVec4f", false),
};

const SFVec4_default_ = SFVec4;
;

/* harmony default export */ const Fields_SFVec4 = (Namespace/* default */.A .add ("SFVec4", SFVec4_default_));
// EXTERNAL MODULE: ./src/x_ite/Base/X3DArrayField.js
var X3DArrayField = __webpack_require__(1736);
;// ./src/x_ite/Base/X3DObjectArrayField.js



const
   _target = Symbol (),
   _proxy  = Symbol (),
   _insert = Symbol (),
   _erase  = Symbol ();

const handler =
{
   get (target, key)
   {
      const value = target [key];

      if (value !== undefined)
         return value;

      if (typeof key === "string")
      {
         const
            array = target .getValue (),
            index = +key;

         if (Number .isInteger (index))
         {
            // For historical reasons this behavior is intended (resize), there are enough
            // X3D/VRML worlds in the Internet who rely on this behavior.
            if (index >= array .length)
               target .resize (index + 1);

            return array [index] .valueOf ();
         }
         else
         {
            return target [key];
         }
      }
   },
   set (target, key, value)
   {
      if (key in target)
      {
         target [key] = value;
         return true;
      }

      const
         array = target .getValue (),
         index = +key;

      if (index >= array .length)
         target .resize (index + 1);

      array [index] .setValue (value);

      return true;
   },
   has (target, key)
   {
      if (Number .isInteger (+key))
         return key < target .getValue () .length;

      return key in target;
   },
   ownKeys (target)
   {
      return Object .keys (target .getValue ());
   },
   getOwnPropertyDescriptor (target, key)
   {
      if (typeof key !== "string")
         return;

      const index = +key;

      if (Number .isInteger (index) && index < target .getValue () .length)
         return Object .getOwnPropertyDescriptor (target .getValue (), key);
   },
};

function X3DObjectArrayField (values)
{
   const proxy = new Proxy (this, handler);

   X3DArrayField/* default */.A .call (this, [ ]);

   this [_target] = this;
   this [_proxy]  = proxy;

   for (const value of values)
      this .push (value);

   return proxy;
}

Object .assign (Object .setPrototypeOf (X3DObjectArrayField .prototype, X3DArrayField/* default */.A .prototype),
{
   [_target]: null,
   [_proxy]: null,
   *[Symbol .iterator] ()
   {
      const
         target = this [_target],
         array  = target .getValue ();

      for (const value of array)
         yield value .valueOf ();
   },
   getTarget ()
   {
      return this [_target];
   },
   copy ()
   {
      const
         target = this [_target],
         copy   = target .create ();

      copy .assign (target);

      return copy;
   },
   equals (array)
   {
      const
         target = this [_target],
         a      = target .getValue (),
         b      = array .getValue (),
         length = a .length;

      if (a === b)
         return true;

      if (length !== b .length)
         return false;

      for (let i = 0; i < length; ++ i)
      {
         if (!a [i] .equals (b [i]))
            return false;
      }

      return true;
   },
   isDefaultValue ()
   {
      return this .length === 0;
   },
   set (value)
   {
      const
         target    = this [_target],
         array     = target .getValue (),
         newLength = value .length;

      target .resize (newLength, undefined, true);

      for (let i = 0; i < newLength; ++ i)
         array [i] .set (value [i] instanceof X3DField/* default */.A ? value [i] .getValue () : value [i]);
   },
   setValue (value)
   {
      const target = this [_target];

      target .set (value instanceof X3DObjectArrayField ? value .getValue () : value);
      target .addEvent ();
   },
   unshift (... args)
   {
      const
         target = this [_target],
         array  = target .getValue ();

      for (let i = args .length - 1; i >= 0; -- i)
      {
         const field = new (target .getSingleType ()) ();

         field .setValue (args [i]);
         target .addChildObject (field);
         array .unshift (field);
      }

      target .addEvent ();

      return array .length;
   },
   shift ()
   {
      const
         target = this [_target],
         array  = target .getValue ();

      if (array .length)
      {
         const
            field  = array .shift (),
            result = field .valueOf ();

         target .removeChildObject (field);
         target .addEvent ();

         return result;
      }
   },
   push (... args)
   {
      const
         target = this [_target],
         array  = target .getValue ();

      for (const argument of args)
      {
         const field = new (target .getSingleType ()) ();

         field .setValue (argument);
         target .addChildObject (field);
         array .push (field);
      }

      target .addEvent ();

      return array .length;
   },
   pop ()
   {
      const
         target = this [_target],
         array  = target .getValue ();

      if (array .length)
      {
         const
            field  = array .pop (),
            result = field .valueOf ();

         target .removeChildObject (field);
         target .addEvent ();

         return result;
      }
   },
   splice (index, deleteCount, ... insertValues)
   {
      const
         target = this [_target],
         array  = target .getValue (),
         length = array .length;

      if (arguments .length === 0)
         return new (target .constructor) ();

      if (arguments .length < 2)
         deleteCount = length;

      const result = target [_erase] (index, deleteCount);

      if (insertValues .length)
         target [_insert] (index, insertValues);

      return result;
   },
   [_insert] (index, array)
   {
      const
         target = this [_target],
         args   = [ ];

      for (const value of array)
      {
         const field = new (target .getSingleType ()) ();

         field .setValue (value);
         target .addChildObject (field);
         args .push (field);
      }

      target .getValue () .splice (index, 0, ... args);
      target .addEvent ();
   },
   [_erase] (index, deleteCount)
   {
      const
         target = this [_target],
         values = target .getValue () .splice (index, deleteCount),
         result = new (target .constructor) ();

      for (const value of values)
      {
         result .push (value);
         target .removeChildObject (value);
      }

      target .addEvent ();

      return result;
   },
   resize (newLength, value, silently)
   {
      const
         target = this [_target],
         array  = target .getValue (),
         length = array .length;

      if (newLength < 0)
         throw new RangeError ("Invalid array length");

      if (newLength < length)
      {
         for (let i = newLength; i < length; ++ i)
            target .removeChildObject (array [i]);

         array .length = newLength;

         if (!silently)
            target .addEvent ();
      }
      else if (newLength > length)
      {
         for (let i = length; i < newLength; ++ i)
         {
            const field = new (target .getSingleType ()) ();

            if (value !== undefined)
               field .setValue (value);

            target .addChildObject (field);
            array .push (field);
         }

         if (!silently)
            target .addEvent ();
      }
   },
   addChildObject (value)
   {
      value .addParent (this [_proxy]);
   },
   removeChildObject (value)
   {
      value .dispose ();
   },
   shrinkToFit ()
   {
      return this .getValue ();
   },
   concat (... args)
   {
      const
         result = this .copy (),
         target = result [_target];

      for (const arg of args)
      {
         for (const value of arg)
            target .push (value);
      }

      return result;
   },
   reverse ()
   {
      const target = this [_target];

      target .getValue () .reverse ();
      target .addEvent ();

      return target [_proxy];
   },
   sort (compareFn)
   {
      const target = this [_target];

      Array .prototype .sort .call (this, compareFn);
      target .addEvent ();

      return target [_proxy];
   },
   valueOf ()
   {
      return this [_proxy];
   },
   toStream (generator)
   {
      const
         target = this [_target],
         array  = target .getValue (),
         length = array .length;

      switch (length)
      {
         case 0:
         {
            generator .string += "[";
            generator .TidySpace ();
            generator .string += "]";
            break;
         }
         case 1:
         {
            array [0] .toStream (generator);
            break;
         }
         default:
         {
            const last = length - 1;

            generator .string += "[";
            generator .ListStart ();
            generator .IncIndent ();

            for (let i = 0; i < last; ++ i)
            {
               generator .ListIndent ();
               array [i] .toStream (generator);
               generator .Comma ();
               generator .ListBreak ();
            }

            generator .ListIndent ();
            array .at (-1) .toStream (generator);

            generator .ListEnd ();
            generator .DecIndent ();
            generator .ListIndent ();
            generator .string += "]";
            break;
         }
      }
   },
   toVRMLStream (generator)
   {
      this .toStream (generator);
   },
   toXMLStream (generator)
   {
      const
         target = this [_target],
         length = target .length;

      if (length)
      {
         const
            array = target .getValue (),
            last  = length - 1;

         for (let i = 0; i < last; ++ i)
         {
            array [i] .toXMLStream (generator);
            generator .Comma ();
            generator .TidySpace ();
         }

         array .at (-1) .toXMLStream (generator);
      }
   },
   toJSONStream (generator)
   {
      const
         target = this [_target],
         length = target .length;

      if (length)
      {
         const
            array = target .getValue (),
            last  = length - 1;

         generator .string += '[';
         generator .ListBreak ();
         generator .IncIndent ();

         for (let i = 0; i < last; ++ i)
         {
            generator .ListIndent ();

            array [i] .toJSONStreamValue (generator);

            generator .string += ',';
            generator .ListBreak ();
         }

         generator .ListIndent ();

         array .at (-1) .toJSONStreamValue (generator);

         generator .ListBreak ();
         generator .DecIndent ();
         generator .ListIndent ();
         generator .string += ']';
      }
      else
      {
         generator .string += '[';
         generator .TidySpace ();
         generator .string += ']';
      }
   },
});

for (const key of Object .keys (X3DObjectArrayField .prototype))
   Object .defineProperty (X3DObjectArrayField .prototype, key, { enumerable: false });

Object .defineProperty (X3DObjectArrayField .prototype, "length",
{
   get () { return this [_target] .getValue () .length; },
   set (value) { this [_target] .resize (value); },
});

const X3DObjectArrayField_default_ = X3DObjectArrayField;
;

/* harmony default export */ const Base_X3DObjectArrayField = (Namespace/* default */.A .add ("X3DObjectArrayField", X3DObjectArrayField_default_));
// EXTERNAL MODULE: ./src/standard/Math/Algorithm.js
var Algorithm = __webpack_require__(5370);
;// ./src/x_ite/Base/X3DTypedArrayField.js



const
   X3DTypedArrayField_target = Symbol (),
   X3DTypedArrayField_proxy  = Symbol (),
   _cache  = Symbol (),
   _tmp    = Symbol (),
   _length = Symbol (),
   X3DTypedArrayField_insert = Symbol (),
   X3DTypedArrayField_erase  = Symbol (),
   _grow   = Symbol (),
   _fill   = Symbol ();

const X3DTypedArrayField_handler =
{
   get (target, key)
   {
      const value = target [key];

      if (value !== undefined)
         return value;

      if (typeof key === "string")
      {
         const index = +key;

         if (Number .isInteger (index))
         {
            const
               components = target .getComponents (),
               valueType  = target .getValueType ();

            // For historical reasons this behavior is intended (resize), there are
            // enough X3D/VRML worlds in the Internet who rely on this behavior.
            const array = index < target [_length]
               ? target .getValue ()
               : target .resize (index + 1, target .getSingleValue ());

            if (components === 1)
            {
               // Return native JavaScript value.
               return valueType (array [index]);
            }
            else
            {
               // Return reference to index.

               return target [_cache] [index]
                  ?? (target [_cache] [index] = createValue (target, index, components, valueType));
            }
         }
         else
         {
            return target [key];
         }
      }
   },
   set (target, key, value)
   {
      if (key in target)
      {
         target [key] = value;
         return true;
      }

      const components = target .getComponents ();

      let
         index = +key,
         array = target .getValue ();

      if (index >= target [_length])
         array = target .resize (index + 1, target .getSingleValue ());

      if (components === 1)
      {
         const valueType = target .getValueType ();

         array [index] = valueType (value);
      }
      else
      {
         index *= components;

         for (let c = 0; c < components; ++ c, ++ index)
            array [index] = value [c];
      }

      target .addEvent ();

      return true;
   },
   has (target, key)
   {
      if (Number .isInteger (+key))
         return key < target [_length];

      return key in target;
   },
   ownKeys (target)
   {
      const ownKeys = [ ];

      for (let i = 0, length = target [_length]; i < length; ++ i)
         ownKeys .push (String (i));

      return ownKeys;
   },
   getOwnPropertyDescriptor (target, key)
   {
      if (typeof key !== "string")
         return;

      const index = +key;

      if (Number .isInteger (index) && index < target [_length])
         return Object .getOwnPropertyDescriptor (target .getValue (), key);
   },
};

function X3DTypedArrayField (values)
{
   const proxy = new Proxy (this, X3DTypedArrayField_handler);

   X3DArrayField/* default */.A .call (this, new (this .getArrayType ()) (16));

   this [X3DTypedArrayField_target] = this;
   this [X3DTypedArrayField_proxy]  = proxy;

   if (this .getComponents () > 1)
   {
      this [_cache] = [ ]; // Cache of elements.
      this [_tmp]   = [ ]; // Array with components size.
   }

   for (const value of values)
      this .push (value);

   return proxy;
}

Object .assign (Object .setPrototypeOf (X3DTypedArrayField .prototype, X3DArrayField/* default */.A .prototype),
{
   [X3DTypedArrayField_target]: null,
   [_tmp]: null,
   [_length]: 0,
   *[Symbol .iterator] ()
   {
      const
         target     = this [X3DTypedArrayField_target],
         array      = target .getValue (),
         components = target .getComponents (),
         valueType  = target .getValueType (),
         length     = target [_length];

      if (components === 1)
      {
         // Return native JavaScript value.

         for (let index = 0; index < length; ++ index)
            yield valueType (array [index]);
      }
      else
      {
         // Return reference to index.

         const cache = target [_cache];

         for (let index = 0; index < length; ++ index)
         {
            yield cache [index]
               ?? (cache [index] = createValue (target, index, components, valueType));
         }
      }
   },
   getTarget ()
   {
      return this [X3DTypedArrayField_target];
   },
   copy ()
   {
      const
         target = this [X3DTypedArrayField_target],
         array  = target .getValue (),
         copy   = target .create ();

      copy .set (array, target [_length]);

      return copy;
   },
   equals (other)
   {
      const
         target      = this [X3DTypedArrayField_target],
         otherTarget = other [X3DTypedArrayField_target],
         length      = target [_length];

      if (target === otherTarget)
         return true;

      if (length !== otherTarget [_length])
         return false;

      const
         a = target .getValue (),
         b = otherTarget .getValue (),
         l = length * target .getComponents ();

      for (let i = 0; i < l; ++ i)
      {
         if (a [i] !== b [i])
            return false;
      }

      return true;
   },
   assign (value)
   {
      const target = this [X3DTypedArrayField_target];

      target .set (value .getValue (), value .length);
      target .addEvent ();
   },
   set (otherArray /* value of field */, l /* length of field */)
   {
      const
         target      = this [X3DTypedArrayField_target],
         components  = target .getComponents (),
         length      = target [_length];

      let
         array       = target .getValue (),
         otherLength = l !== undefined ? l * components : otherArray .length;

      const rest = otherLength % components;

      if (rest)
      {
         otherLength -= rest;

         console .warn (`Array length must be multiple of components size, which is ${components}.`);
      }

      otherLength /= components;

      if (array .length < otherArray .length)
      {
         array = target [_grow] (otherArray .length);

         array .set (otherArray);

         if (rest)
            array .fill (0, otherLength * components, otherLength * components + rest);
      }
      else
      {
         array .set (otherArray);

         if (otherLength < length)
            array .fill (0, otherLength * components, length * components);
      }

      target [_length] = otherLength;
   },
   isDefaultValue ()
   {
      return this [_length] === 0;
   },
   setValue (value)
   {
      const target = this [X3DTypedArrayField_target];

      if (value instanceof target .constructor)
      {
         target .assign (value);
      }
      else
      {
         target .set (value);
         target .addEvent ();
      }
   },
   unshift (... args)
   {
      const
         target          = this [X3DTypedArrayField_target],
         components      = target .getComponents (),
         length          = target [_length],
         argumentsLength = args .length,
         array           = target [_grow] ((length + argumentsLength) * components);

      array .copyWithin (argumentsLength * components, 0, length * components);

      if (components === 1)
      {
         const valueType = target .getValueType ();

         for (let a = 0; a < argumentsLength; ++ a)
            array [a] = valueType (args [a]);
      }
      else
      {
         for (let i = 0, a = 0; a < argumentsLength; ++ a)
         {
            const argument = args [a];

            for (let c = 0; c < components; ++ c, ++ i)
            {
               array [i] = argument [c];
            }
         }
      }

      target [_length] += argumentsLength;

      target .addEvent ();

      return target [_length];
   },
   shift ()
   {
      const
         target = this [X3DTypedArrayField_target],
         length = target [_length];

      if (length)
      {
         const
            array      = target .getValue (),
            components = target .getComponents (),
            valueType  = target .getValueType (),
            newLength  = length - 1;

         let value;

         if (components === 1)
         {
            value = valueType (array [0]);
         }
         else
         {
            const tmp = target [_tmp];

            for (let c = 0; c < components; ++ c)
               tmp [c] = array [c];

            value = new valueType (... tmp);
         }

         array .copyWithin (0, components, length * components);
         array .fill (0, components * newLength, length * components);

         target [_length] = newLength;

         target .addEvent ();
         return value;
      }
   },
   push (... args)
   {
      const
         target          = this [X3DTypedArrayField_target],
         components      = target .getComponents (),
         length          = target [_length],
         argumentsLength = args .length,
         array           = target [_grow] ((length + argumentsLength) * components);

      if (components === 1)
      {
         const valueType = target .getValueType ();

         for (let a = 0, i = length; a < argumentsLength; ++ a, ++ i)
            array [i] = valueType (args [a]);
      }
      else
      {
         for (let i = length * components, a = 0; a < argumentsLength; ++ a)
         {
            const argument = args [a];

            for (let c = 0; c < components; ++ c,  ++ i)
            {
               array [i] = argument [c];
            }
         }
      }

      target [_length] += argumentsLength;

      target .addEvent ();

      return target [_length];
   },
   pop ()
   {
      const
         target = this [X3DTypedArrayField_target],
         length = target [_length];

      if (length)
      {
         const
            array      = target .getValue (),
            components = target .getComponents (),
            valueType  = target .getValueType (),
            newLength  = length - 1;

         let value;

         if (components === 1)
         {
            value = valueType (array [length - 1]); // Don't use at(-1).
         }
         else
         {
            const tmp = target [_tmp];

            for (let c = 0, a = newLength * components; c < components; ++ c, ++ a)
               tmp [c] = array [a];

            value = new valueType (... tmp);
         }

         array .fill (0, newLength * components, length * components);

         target [_length] = newLength;

         target .addEvent ();

         return value;
      }
   },
   splice (index, deleteCount, ... insertValues)
   {
      const
         target = this [X3DTypedArrayField_target],
         length = target [_length];

      if (arguments .length === 0)
         return new (target .constructor) ();

      index |= 0;

      if (index < 0)
         index += length;

      index = Algorithm/* default */.A .clamp (index, 0, length);

      if (arguments .length < 2)
         deleteCount = length;

      deleteCount |= 0;

      if (index + deleteCount > length)
         deleteCount = length - index;

      deleteCount = Math .max (deleteCount, 0);

      const result = target [X3DTypedArrayField_erase] (index, index + deleteCount);

      if (insertValues .length)
         target [X3DTypedArrayField_insert] (index, insertValues);

      target .addEvent ();

      return result;
   },
   [X3DTypedArrayField_insert] (index, other)
   {
      const
         target      = this [X3DTypedArrayField_target],
         components  = target .getComponents (),
         length      = target [_length],
         otherLength = other .length,
         array       = target [_grow] ((length + otherLength) * components);

      index *= components;

      array .copyWithin (index + otherLength * components, index, length * components);

      if (components === 1)
      {
         const valueType = target .getValueType ();

         for (let a = 0, i = index; a < otherLength; ++ a, ++ i)
            array [i] = valueType (other [a]);
      }
      else
      {
         for (let i = 0, a = index; i < otherLength; ++ i)
         {
            const value = other [i];

            for (let c = 0; c < components; ++ c, ++ a)
               array [a] = value [c];
         }
      }

      target [_length] += otherLength;
   },
   [X3DTypedArrayField_erase] (first, last)
   {
      const
         target     = this [X3DTypedArrayField_target],
         array      = target .getValue (),
         components = target .getComponents (),
         difference = last - first,
         length     = target [_length],
         newLength  = length - difference,
         values     = target [X3DTypedArrayField_proxy] .slice (first, last);

      first *= components;
      last  *= components;

      array .copyWithin (first, last, length * components);
      array .fill (0, newLength * components, length * components);

      target [_length] = newLength;

      if (components > 1)
         target [_cache] .length = newLength;

      target .addEvent ();

      return values;
   },
   resize (newLength, value, silently)
   {
      const
         target     = this [X3DTypedArrayField_target],
         length     = target [_length],
         components = target .getComponents ();

      if (newLength < 0)
         throw new RangeError ("Invalid array length");

      let array = target .getValue ();

      target [_length] = newLength;

      if (newLength < length)
      {
         array .fill (0, newLength * components, length * components);

         if (components > 1)
            target [_cache] .length = newLength;

         if (!silently)
            target .addEvent ();
      }
      else if (newLength > length)
      {
         array = target [_grow] (newLength * components);

         if (value !== undefined)
            this [_fill] (value, length, newLength);

         if (!silently)
            target .addEvent ();
      }

      return array;
   },
   [_grow] (length)
   {
      const
         target = this [X3DTypedArrayField_target],
         array  = target .getValue ();

      if (length <= array .length)
         return array;

      const
         maxLength = Algorithm/* default */.A .nextPowerOfTwo (length),
         newArray  = new (target .getArrayType ()) (maxLength);

      newArray .set (array);

      X3DArrayField/* default */.A .prototype .set .call (target, newArray);

      return newArray;
   },
   shrinkToFit ()
   {
      const
         target = this [X3DTypedArrayField_target],
         array  = target .getValue (),
         length = target [_length] * target .getComponents ();

      if (array .length === length)
         return array;

      const newArray = array .subarray (0, length);

      X3DArrayField/* default */.A .prototype .set .call (target, newArray);

      return newArray;
   },
   concat (... args)
   {
      const
         result     = this .copy (),
         target     = result [X3DTypedArrayField_target],
         components = target .getComponents (),
         length     = target [_length] + args .reduce ((p, c) => p + c .length, 0),
         value      = target [_grow] (length * components);

      let offset = target [_length] * components;

      for (const arg of args)
      {
         value .set (arg .shrinkToFit (), offset);

         offset += arg .length * components;
      }

      target [_length] = length;

      return result;
   },
   flat ()
   {
      const
         target     = this [X3DTypedArrayField_target],
         array      = target .shrinkToFit (),
         components = target .getComponents (),
         valueType  = target .getValueType ();

      if (components === 1)
         return Array .from (array, value => valueType (value));

      return Array .from (array);
   },
   flatMap (... args)
   {
      return this .map (...args) .flat ();
   },
   [_fill] (value, start = 0, end = this .length)
   {
      const
         target     = this [X3DTypedArrayField_target],
         length     = target [_length],
         array      = target .getValue (),
         components = target .getComponents ();

      if (-length <= start && start < 0)
         start = start + length;

      if (start < -length)
         start = 0;

      if (start >= length)
         return;

      if (-length <= end && end < 0)
         end = end + length;

      if (end < -length)
         end = 0;

      if (end >= length)
         end = length;

      if (start >= end)
         return;

      if (components === 1)
      {
         const valueType = target .getValueType ();

         array .fill (valueType (value), start * components, end * components);
      }
      else
      {
         // More efficient way to copy repeating sequence into TypedArray?
         // https://stackoverflow.com/questions/46313130/more-efficient-way-to-copy-repeating-sequence-into-typedarray

         const
            i0 = start * components,
            il = end * components;

         for (let i = i0, c = 0; c < components; ++ i, ++ c)
         {
            array [i] = value [c];
         }

         let
            i = i0 + components,
            c = components;

         while (i < il)
         {
            const sl = i + c > il ? il - i : c;

            array .copyWithin (i, i0, i0 + sl);

            i  += c;
            c <<= 1;
         }
      }

      return target [X3DTypedArrayField_proxy];
   },
   fill (value, start = 0, end = this .length)
   {
      const target = this [X3DTypedArrayField_target];

      this [_fill] (value, start, end);

      target .addEvent ();

      return target [X3DTypedArrayField_proxy];
   },
   reverse ()
   {
      const
         target     = this [X3DTypedArrayField_target],
         array      = target .getValue (),
         components = target .getComponents (),
         length     = target [_length] * components,
         length1_2  = Math .floor (target [_length] / 2) * components;

      if (components === 1)
      {
         for (let i = 0; i < length1_2; ++ i)
         {
            const
               i2 = length - i - 1,
               t  = array [i];

            array [i]  = array [i2];
            array [i2] = t;
         }
      }
      else
      {
         for (let i = 0; i < length1_2; i += components)
         {
            for (let c = 0; c < components; ++ c)
            {
               const
                  i1 = i + c,
                  i2 = length - i - 1 - (components - c - 1),
                  t  = array [i1];

               array [i1] = array [i2];
               array [i2] = t;
            }
         }
      }

      target .addEvent ();

      return target [X3DTypedArrayField_proxy];
   },
   sort (compareFn)
   {
      const
         target     = this [X3DTypedArrayField_target],
         array      = target .getValue (),
         components = target .getComponents (),
         length     = target [_length];

      if (components === 1)
      {
         const valueType = target .getValueType ();

         const cmp = compareFn
            ? (a, b) => compareFn (valueType (a), valueType (b))
            : Algorithm/* default */.A .cmp;

         target .set (array .subarray (0, length) .sort (cmp));
      }
      else
      {
         const result = Array .from (target [X3DTypedArrayField_proxy], value => value .copy ())
            .sort (compareFn ?? ((a, b) =>
         {
            for (let c = 0; c < components; ++ c)
            {
               if (a [c] < b [c])
                  return -1;

               if (b [c] < a [c])
                  return 1;
            }

            return 0;
         }));

         for (let i = 0; i < length; ++ i)
         {
            const value = result [i];

            for (let c = 0, first = i * components; c < components; ++ c, ++ first)
               array [first] = value [c];
         }
      }

      target .addEvent ();

      return target [X3DTypedArrayField_proxy];
   },
   valueOf ()
   {
      return this [X3DTypedArrayField_proxy];
   },
   toStream (generator)
   {
      const
         target     = this [X3DTypedArrayField_target],
         array      = target .getValue (),
         length     = target [_length],
         components = target .getComponents (),
         value      = new (target .getSingleType ()) ();

      value .setUnit (target .getUnit ());

      switch (length)
      {
         case 0:
         {
            generator .string += "[";
            generator .TidySpace ();
            generator .string += "]";
            break;
         }
         case 1:
         {
            if (components === 1)
            {
               value .set (array [0]);
               value .toStream (generator);
            }
            else
            {
               for (let c = 0, first = 0; c < components; ++ c, ++ first)
                  value [c] = array [first];

               value .toStream (generator);
            }

            break;
         }
         default:
         {
            const last = length - 1;

            generator .string += "[";
            generator .ListStart ();
            generator .IncIndent ();

            if (components === 1)
            {
               for (let i = 0; i < last; ++ i)
               {
                  generator .ListIndent ();

                  value .set (array [i * components]);
                  value .toStream (generator);

                  generator .Comma ();
                  generator .ListBreak ();
               }

               generator .ListIndent ();

               value .set (array [last * components]);
               value .toStream (generator);
            }
            else
            {
               for (let i = 0; i < last; ++ i)
               {
                  generator .ListIndent ();

                  for (let c = 0, first = i * components; c < components; ++ c, ++ first)
                     value [c] = array [first];

                  value .toStream (generator);

                  generator .Comma ();
                  generator .ListBreak ();
               }

               generator .ListIndent ();

               for (let c = 0, first = last * components; c < components; ++ c, ++ first)
                  value [c] = array [first];

               value .toStream (generator);
            }

            generator .ListEnd ();
            generator .DecIndent ();
            generator .ListIndent ();
            generator .string += "]";
            break;
         }
      }
   },
   toVRMLStream (generator)
   {
      this .toStream (generator);
   },
   toXMLStream (generator)
   {
      const
         target = this [X3DTypedArrayField_target],
         length = target [_length];

      if (length)
      {
         const
            array      = target .getValue (),
            components = target .getComponents (),
            value      = new (target .getSingleType ()) (),
            last       = length - 1;

         value .setUnit (target .getUnit ());

         if (components === 1)
         {
            for (let i = 0; i < last; ++ i)
            {
               value .set (array [i * components]);
               value .toXMLStream (generator);

               generator .Comma ();
               generator .TidySpace ();
            }

            value .set (array [last * components]);
            value .toXMLStream (generator);
         }
         else
         {
            for (let i = 0; i < last; ++ i)
            {
               for (let c = 0, first = i * components; c < components; ++ c, ++ first)
                  value [c] = array [first];

               value .toXMLStream (generator);

               generator .Comma ();
               generator .TidySpace ();
            }

            for (let c = 0, first = last * components; c < components; ++ c, ++ first)
               value [c] = array [first];

            value .toXMLStream (generator);
         }
      }
   },
   toJSONStream (generator)
   {
      const
         target = this [X3DTypedArrayField_target],
         length = target .length;

      if (length)
      {
         const
            array      = target .getValue (),
            components = target .getComponents (),
            value      = new (target .getSingleType ()) (),
            last       = length - 1;

         value .setUnit (target .getUnit ());

         generator .string += '[';
         generator .ListBreak ();
         generator .IncIndent ();

         if (components === 1)
         {
            for (let i = 0; i < last; ++ i)
            {
               generator .ListIndent ();

               value .set (array [i * components]);
               value .toJSONStreamValue (generator);

               generator .string += ',';
               generator .ListBreak ();
            }

            generator .ListIndent ();

            value .set (array [last * components]);
            value .toJSONStreamValue (generator);
         }
         else
         {
            for (let i = 0; i < last; ++ i)
            {
               generator .ListIndent ();

               for (let c = 0, first = i * components; c < components; ++ c, ++ first)
                  value [c] = array [first];

               value .toJSONStreamValue (generator);

               generator .string += ',';
               generator .ListBreak ();
            }

            generator .ListIndent ();

            for (let c = 0, first = last * components; c < components; ++ c, ++ first)
               value [c] = array [first];

            value .toJSONStreamValue (generator);
         }

         generator .ListBreak ();
         generator .DecIndent ();
         generator .ListIndent ();
         generator .string += ']';
      }
      else
      {
         generator .string += '[';
         generator .TidySpace ();
         generator .string += ']';
      }
   },
   dispose ()
   {
      X3DArrayField/* default */.A .prototype .dispose .call (this [X3DTypedArrayField_target]);
   },
});

for (const key of Object .keys (X3DTypedArrayField .prototype))
   Object .defineProperty (X3DTypedArrayField .prototype, key, { enumerable: false });

Object .defineProperty (X3DTypedArrayField .prototype, "length",
{
   get () { return this [_length]; },
   set (value)
   {
      const target = this [X3DTypedArrayField_target];

      target .resize (value, target .getSingleValue ());
   },
});

// Getter/Setter functions to reference a value for a given index.

function createValue (target, index, components, valueType)
{
   const
      value         = new valueType (),
      internalValue = value .getValue (),
      i             = index * components;

   Object .defineProperties (value,
   {
      addEvent:
      {
         value: addEvent .bind (target, i, components, internalValue),
         configurable: true,
      },
      getValue:
      {
         value: getValue .bind (target, i, components, internalValue),
         configurable: true,
      },
   });

   return value;
}

function getValue (index, components, internalValue)
{
   const array = this .getValue ();

   for (let c = 0; c < components; ++ c, ++ index)
      internalValue [c] = array [index];

   return internalValue;
}

function addEvent (index, components, internalValue)
{
   const array = this .getValue ();

   for (let c = 0; c < components; ++ c, ++ index)
      array [index] = internalValue [c];

   this .addEvent ();
}

const X3DTypedArrayField_default_ = X3DTypedArrayField;
;

/* harmony default export */ const Base_X3DTypedArrayField = (Namespace/* default */.A .add ("X3DTypedArrayField", X3DTypedArrayField_default_));
;// ./src/x_ite/Fields/ArrayFields.js



















const
   { SFBool, SFDouble, SFFloat, SFInt32, SFString, SFTime } = Fields_SFScalar,
   { SFMatrix3d: ArrayFields_SFMatrix3d, SFMatrix3f: ArrayFields_SFMatrix3f } = Fields_SFMatrix3,
   { SFMatrix4d, SFMatrix4f } = Fields_SFMatrix4,
   { SFVec2d, SFVec2f }       = Fields_SFVec2,
   { SFVec3d: ArrayFields_SFVec3d, SFVec3f: ArrayFields_SFVec3f }       = Fields_SFVec3,
   { SFVec4d, SFVec4f }       = Fields_SFVec4;

/*
 *  MFNode
 */

function MFNode (... args)
{
   return Base_X3DObjectArrayField .call (this, args);
}

Object .assign (Object .setPrototypeOf (MFNode .prototype, Base_X3DObjectArrayField .prototype),
{
   getSingleType ()
   {
      return SFNode/* default */.A;
   },
   copy (instance)
   {
      if (instance)
      {
         const copy = new MFNode ();

         for (const node of this .getValue ())
            copy .push (node .copy (instance));

         return copy;
      }
      else
      {
         return Base_X3DObjectArrayField .prototype .copy .call (this);
      }
   },
   toStream (generator)
   {
      const
         target = this .getTarget (),
         array  = target .getValue (),
         length = array .length;

      switch (length)
      {
         case 0:
         {
            generator .string += "[";
            generator .TidySpace ();
            generator .string += "]";
            break;
         }
         case 1:
         {
            array [0] .toStream (generator);
            break;
         }
         default:
         {
            generator .string += "[";
            generator .TidyBreak ();
            generator .IncIndent ();

            for (let i = 0; i < length; ++ i)
            {
               generator .Indent ();
               array [i] .toStream (generator);
               generator .TidyBreak ();
            }

            generator .DecIndent ();
            generator .Indent ();
            generator .string += "]";
            break;
         }
      }
   },
   toVRMLStream (generator)
   {
      const
         target = this .getTarget (),
         array  = target .getValue (),
         length = array .length;

      switch (length)
      {
         case 0:
         {
            generator .string += "[";
            generator .TidySpace ();
            generator .string += "]";
            break;
         }
         case 1:
         {
            array [0] .toVRMLStream (generator);
            break;
         }
         default:
         {
            generator .string += "[";
            generator .TidyBreak ();
            generator .IncIndent ();

            for (const element of array)
            {
               generator .Indent ();
               element .toVRMLStream (generator);
               generator .TidyBreak ();
            }

            generator .DecIndent ();
            generator .Indent ();
            generator .string += "]";
            break;
         }
      }
   },
   toXMLStream (generator)
   {
      const
         target = this .getTarget (),
         length = target .length;

      if (length)
      {
         const
            array = target .getValue (),
            last  = length - 1;

         for (let i = 0; i < last; ++ i)
         {
            const node = array [i] .getValue ();

            if (node)
            {
               node .toXMLStream (generator);
            }
            else
            {
               generator .openTag ("NULL");
               generator .containerField ();
               generator .closeTag ("NULL");
            }

            generator .TidyBreak ();
         }

         const node = array .at (-1) .getValue ();

         if (node)
         {
            node .toXMLStream (generator);
         }
         else
         {
            generator .openTag ("NULL");
            generator .containerField ();
            generator .closeTag ("NULL");
         }
      }
   },
   toJSONStream (generator)
   {
      const
         target = this .getTarget (),
         length = target .length;

      if (length)
      {
         const
            array = target .getValue (),
            last  = length - 1;

         generator .string += '[';
         generator .TidyBreak ();
         generator .IncIndent ();

         for (let i = 0; i < last; ++ i)
         {
            generator .Indent ();

            if (array [i])
               array [i] .toJSONStreamValue (generator);
            else
               generator .string += 'null';

            generator .string += ',';
            generator .TidyBreak ();
         }

         generator .Indent ();

         if (array .at (-1))
            array .at (-1) .toJSONStreamValue (generator);
         else
            generator .string += 'null';

         generator .TidyBreak ();
         generator .DecIndent ();
         generator .Indent ();
         generator .string += ']';
      }
      else
      {
         generator .string += '[';
         generator .TidySpace ();
         generator .string += ']';
      }
   },
   dispose ()
   {
      const target = this .getTarget ();

      target .resize (0, undefined, true);
      target .processInterests ();

      Base_X3DObjectArrayField .prototype .dispose .call (target);
   },
});

for (const key of Object .keys (MFNode .prototype))
   Object .defineProperty (MFNode .prototype, key, { enumerable: false });

Object .defineProperties (MFNode,
{
   type:
   {
      value: X3DConstants/* default */.A .MFNode,
      enumerable: true,
   },
   typeName:
   {
      value: "MFNode",
      enumerable: true,
   },
});

function MFString (... args)
{
   return Base_X3DObjectArrayField .call (this, args);
}

Object .assign (Object .setPrototypeOf (MFString .prototype, Base_X3DObjectArrayField .prototype),
{
   getSingleType ()
   {
      return SFString;
   },
   toXMLStream (generator, sourceText = false)
   {
      const
         target = this .getTarget (),
         length = target .length;

      if (length)
      {
         const value = target .getValue ();

         for (let i = 0, n = length - 1; i < n; ++ i)
         {
            generator .string += "\"";
            value [i] .toXMLStream (generator, sourceText);
            generator .string += "\"";
            generator .Comma ();
            generator .TidySpace ();
         }

         generator .string += "\"";
         value .at (-1) .toXMLStream (generator, sourceText);
         generator .string += "\"";
      }
   },
});

for (const key of Object .keys (MFString .prototype))
   Object .defineProperty (MFString .prototype, key, { enumerable: false });

Object .defineProperties (MFString,
{
   type:
   {
      value: X3DConstants/* default */.A .MFString,
      enumerable: true,
   },
   typeName:
   {
      value: "MFString",
      enumerable: true,
   },
});

/**
 * MFImage
 */

function MFImage (... args)
{
   return Base_X3DObjectArrayField .call (this, args);
}

Object .assign (Object .setPrototypeOf (MFImage .prototype, Base_X3DObjectArrayField .prototype),
{
   getSingleType ()
   {
      return Fields_SFImage;
   },
});

for (const key of Object .keys (MFImage .prototype))
   Object .defineProperty (MFImage .prototype, key, { enumerable: false });

Object .defineProperties (MFImage,
{
   type:
   {
      value: X3DConstants/* default */.A .MFImage,
      enumerable: true,
   },
   typeName:
   {
      value: "MFImage",
      enumerable: true,
   },
});

function TypedArrayTemplate (TypeName, SingleType, ValueType, ArrayType, Components, singleValue)
{
   function ArrayField (... args)
   {
      return Base_X3DTypedArrayField .call (this, args);
   }

   Object .assign (Object .setPrototypeOf (ArrayField .prototype, Base_X3DTypedArrayField .prototype),
   {
      getSingleValue ()
      {
         return singleValue;
      },
      getSingleType ()
      {
         return SingleType;
      },
      getValueType ()
      {
         return ValueType;
      },
      getArrayType ()
      {
         return ArrayType;
      },
      getComponents ()
      {
         return Components;
      },
   });

   for (const key of Object .keys (ArrayField .prototype))
      Object .defineProperty (ArrayField .prototype, key, { enumerable: false });

   Object .defineProperties (ArrayField,
   {
      type:
      {
         value: X3DConstants/* default */.A [TypeName],
         enumerable: true,
      },
      typeName:
      {
         value: TypeName,
         enumerable: true,
      },
   });

   return ArrayField;
}

const Value = value => value;

const ArrayFields =
{
   MFBool:      TypedArrayTemplate ("MFBool",      SFBool,      Boolean,     Uint8Array,   1),
   MFColor:     TypedArrayTemplate ("MFColor",     Fields_SFColor,     Fields_SFColor,     Float32Array, 3),
   MFColorRGBA: TypedArrayTemplate ("MFColorRGBA", Fields_SFColorRGBA, Fields_SFColorRGBA, Float32Array, 4),
   MFDouble:    TypedArrayTemplate ("MFDouble",    SFDouble,    Value,       Float64Array, 1),
   MFFloat:     TypedArrayTemplate ("MFFloat",     SFFloat,     Value,       Float32Array, 1),
   MFImage:     MFImage,
   MFInt32:     TypedArrayTemplate ("MFInt32",     SFInt32,     Value,       Int32Array,   1),
   MFMatrix3d:  TypedArrayTemplate ("MFMatrix3d",  ArrayFields_SFMatrix3d,  ArrayFields_SFMatrix3d,  Float64Array, 9,  Matrix3/* default */.A .IDENTITY),
   MFMatrix3f:  TypedArrayTemplate ("MFMatrix3f",  ArrayFields_SFMatrix3f,  ArrayFields_SFMatrix3f,  Float32Array, 9,  Matrix3/* default */.A .IDENTITY),
   MFMatrix4d:  TypedArrayTemplate ("MFMatrix4d",  SFMatrix4d,  SFMatrix4d,  Float64Array, 16, Matrix4/* default */.A .IDENTITY),
   MFMatrix4f:  TypedArrayTemplate ("MFMatrix4f",  SFMatrix4f,  SFMatrix4f,  Float32Array, 16, Matrix4/* default */.A .IDENTITY),
   MFNode:      MFNode,
   MFRotation:  TypedArrayTemplate ("MFRotation",  Fields_SFRotation,  Fields_SFRotation,  Float64Array, 4,  Rotation4/* default */.A .IDENTITY),
   MFString:    MFString,
   MFTime:      TypedArrayTemplate ("MFTime",      SFTime,      Value,       Float64Array, 1,  -1),
   MFVec2d:     TypedArrayTemplate ("MFVec2d",     SFVec2d,     SFVec2d,     Float64Array, 2),
   MFVec2f:     TypedArrayTemplate ("MFVec2f",     SFVec2f,     SFVec2f,     Float32Array, 2),
   MFVec3d:     TypedArrayTemplate ("MFVec3d",     ArrayFields_SFVec3d,     ArrayFields_SFVec3d,     Float64Array, 3),
   MFVec3f:     TypedArrayTemplate ("MFVec3f",     ArrayFields_SFVec3f,     ArrayFields_SFVec3f,     Float32Array, 3),
   MFVec4d:     TypedArrayTemplate ("MFVec4d",     SFVec4d,     SFVec4d,     Float64Array, 4,  Vector4/* default */.A .W_AXIS),
   MFVec4f:     TypedArrayTemplate ("MFVec4f",     SFVec4f,     SFVec4f,     Float32Array, 4,  Vector4/* default */.A .W_AXIS),
};

const ArrayFields_default_ = ArrayFields;
;

/* harmony default export */ const Fields_ArrayFields = (Namespace/* default */.A .add ("ArrayFields", ArrayFields_default_));
;// ./src/x_ite/Fields/SFImage.js





const MFInt32 = Fields_ArrayFields .MFInt32;

/*
 *  Image
 */

function Image (width, height, comp, array)
{
   this .width  = Math .max (width|0, 0);
   this .height = Math .max (height|0, 0);
   this .comp   = Algorithm/* default */.A .clamp (comp|0, 0, 4);
   this .array  = new MFInt32 ();
   this .array .setValue (array);
   this .array .length = this .width * this .height;
}

Object .assign (Image .prototype,
{
   copy ()
   {
      return new Image (this .width, this .height, this .comp, this .array);
   },
   equals (image)
   {
      return this .width  === image .width &&
             this .height === image .height &&
             this .comp   === image .comp &&
             this .array .equals (image .array);
   },
   assign (image)
   {
      this .width  = image .width;
      this .height = image .height;
      this .comp   = image .comp;
      this .array .assign (image .array);
   },
   set (width, height, comp, array)
   {
      this .width  = width|0;
      this .height = height|0;
      this .comp   = comp|0;
      this .array .assign (array);
   },
   setWidth (value)
   {
      this .width = Math .max (value|0, 0);
      this .array .length = this .width * this .height;
   },
   getWidth ()
   {
      return this .width;
   },
   setHeight (value)
   {
      this .height = Math .max (value|0, 0);
      this .array .length = this .width * this .height;
   },
   getHeight ()
   {
      return this .height;
   },
   setComp (value)
   {
      this .comp = Algorithm/* default */.A .clamp (value|0, 0, 4);
   },
   getComp ()
   {
      return this .comp;
   },
   setArray (value)
   {
      this .array .setValue (value);
      this .array .length = this .width * this .height;
   },
   getArray ()
   {
      return this .array;
   },
});

/*
 *  SFImage
 */

const _set_size = Symbol ();

function SFImage (width, height, comp, array)
{
   switch (arguments .length)
   {
      case 0:
         X3DField/* default */.A .call (this, new Image (0, 0, 0, new MFInt32 ()));
         break;

      case 1:
         X3DField/* default */.A .call (this, arguments [0]);
         break;

      case 3:
         X3DField/* default */.A .call (this, new Image (width, height, comp, new MFInt32 ()));
         break;

      case 4:
         X3DField/* default */.A .call (this, new Image (width, height, comp, array));
         break;

      default:
         throw new Error ("Invalid arguments.");
   }

   this .getValue () .getArray () .addParent (this);
   this .addInterest (_set_size, this);
}

Object .assign (Object .setPrototypeOf (SFImage .prototype, X3DField/* default */.A .prototype),
{
   [_set_size] ()
   {
      this .getValue () .getArray () .length = this .width * this .height;
   },
   *[Symbol .iterator] ()
   {
      yield  this .width;
      yield  this .height;
      yield  this .comp;
      yield* this .array;
   },
   copy ()
   {
      return new SFImage (this .getValue () .copy ());
   },
   equals (image)
   {
      return this .getValue () .equals (image .getValue ());
   },
   isDefaultValue ()
   {
      return (
         this .width  === 0 &&
         this .height === 0 &&
         this .comp   === 0);
   },
   set (image)
   {
      this .getValue () .assign (image);
   },
   toStream (generator)
   {
      const
         width  = this .width,
         height = this .height,
         array  = new Uint32Array (this .array .getValue () .buffer);

      generator .string += width;
      generator .Space ();
      generator .string += height;
      generator .Space ();
      generator .string += this .comp;
      generator .AttribBreak ();

      generator .IncIndent ();

      for (let y = 0; y < height; ++ y)
      {
         generator .ListIndent ();

         const s = y * width;

         for (let x = 0; x < width; ++ x)
         {
            generator .string += "0x";
            generator .string += array [x + s] .toString (16);

            if (x !== width - 1)
               generator .Space ();
         }

         if (y !== height - 1)
            generator .AttribBreak ();
      }

      generator .DecIndent ();
   },
   toVRMLStream (generator)
   {
      this .toStream (generator);
   },
   toXMLStream (generator)
   {
      this .toStream (generator);
   },
   toJSONStream (generator)
   {
      generator .string += '[';
      generator .ListBreak ();
      generator .IncIndent ();
      generator .ListIndent ();

      this .toJSONStreamValue (generator);

      generator .DecIndent ();
      generator .ListBreak ();
      generator .ListIndent ();
      generator .string += ']';
   },
   toJSONStreamValue (generator)
   {
      const
         width  = this .width,
         height = this .height,
         array  = new Uint32Array (this .array .getValue () .buffer),
         length = this .array .length;

      generator .string += width;
      generator .string += ',';
      generator .TidySpace ();
      generator .string += height;
      generator .string += ',';
      generator .TidySpace ();
      generator .string += this .comp;
      generator .string += ',';

      if (width && height)
      {
         generator .ListBreak ();
         generator .IncIndent ();

         for (let y = 0; y < height; ++ y)
         {
            generator .ListIndent ();

            const s = y * width;

            for (let x = 0; x < width; ++ x)
            {
               generator .string += array [x + s];

               if (x + s !== length - 1)
                  generator .string += ',';

               if (x !== width - 1)
                  generator .TidySpace ();
            }

            if (y !== height - 1)
               generator .ListBreak ();
         }

         generator .DecIndent ();
      }
   },
});

for (const key of Object .keys (SFImage .prototype))
   Object .defineProperty (SFImage .prototype, key, { enumerable: false });

const width = {
   get ()
   {
      return this .getValue () .getWidth ();
   },
   set (value)
   {
      this .getValue () .setWidth (value);
      this .addEvent ();
   },
};

const height = {
   get ()
   {
      return this .getValue () .getHeight ();
   },
   set (value)
   {
      this .getValue () .setHeight (value);
      this .addEvent ();
   },
};

const comp = {
   get ()
   {
      return this .getValue () .getComp ();
   },
   set (value)
   {
      this .getValue () .setComp (value);
      this .addEvent ();
   },
};

const array = {
   get ()
   {
      return this .getValue () .getArray ();
   },
   set (value)
   {
      this .getValue () .setArray (value);
      this .addEvent ();
   },
};

Object .defineProperties (SFImage .prototype,
{
   x: width,
   y: height,
   width:  Object .assign ({ enumerable: true }, width),
   height: Object .assign ({ enumerable: true }, height),
   comp:   Object .assign ({ enumerable: true }, comp),
   array:  Object .assign ({ enumerable: true }, array),
});

Object .defineProperties (SFImage,
{
   type:
   {
      value: X3DConstants/* default */.A .SFImage,
      enumerable: true,
   },
   typeName:
   {
      value: "SFImage",
      enumerable: true,
   },
});

const SFImage_default_ = SFImage;
;

/* harmony default export */ const Fields_SFImage = (Namespace/* default */.A .add ("SFImage", SFImage_default_));
;// ./src/x_ite/Fields.js













const Fields = {
   SFColor:     Fields_SFColor,
   SFColorRGBA: Fields_SFColorRGBA,
   SFImage:     Fields_SFImage,
   SFNode:      SFNode/* default */.A,
   SFRotation:  Fields_SFRotation,
   ... Fields_SFScalar,
   ... Fields_SFMatrix3,
   ... Fields_SFMatrix4,
   ... Fields_SFVec2,
   ... Fields_SFVec3,
   ... Fields_SFVec4,
   ... Fields_ArrayFields,
};

const Fields_default_ = Fields;
;

/* harmony default export */ const x_ite_Fields = (Namespace/* default */.A .add ("Fields", Fields_default_));

/***/ },

/***/ 3586
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _X3DObject_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(7092);
/* harmony import */ var _IterableWeakSet_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(1658);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(6334);



const
   _modificationTime = Symbol (),
   _tainted          = Symbol (),
   _parents          = Symbol (),
   _private          = Symbol ();

const EMPTY = [ ];

function X3DChildObject ()
{
   _X3DObject_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .call (this);
}

Object .assign (Object .setPrototypeOf (X3DChildObject .prototype, _X3DObject_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .prototype),
{
   [_modificationTime]: -1,
   [_tainted]: false,
   [_parents]: null,
   [_private]: false,
   isInitializable ()
   {
      return true;
   },
   isInput ()
   {
      return false;
   },
   isOutput ()
   {
      return false;
   },
   setModificationTime (value)
   {
      this [_modificationTime] = value;
   },
   getModificationTime ()
   {
      return this [_modificationTime];
   },
   setTainted (value)
   {
      this [_tainted] = value;
   },
   isTainted ()
   {
      return this [_tainted];
   },
   addEvent ()
   {
      for (const parent of this [_parents] ?? EMPTY)
         parent .addEvent (this);
   },
   addEventObject (field, event)
   {
      for (const parent of this [_parents] ?? EMPTY)
         parent .addEventObject (this, event);
   },
   processEvent ()
   {
      this .setTainted (false);
      this .processInterests ();
   },
   isPrivate ()
   {
      return this [_private];
   },
   setPrivate (value)
   {
      this [_private] = value;
   },
   collectCloneCount ()
   {
      let cloneCount = 0;

      for (const parent of this [_parents] ?? EMPTY)
      {
         if (parent [_private])
            continue;

         cloneCount += parent .collectCloneCount ();
      }

      return cloneCount;
   },
   addParent (parent)
   {
      this .getParents () .add (parent);

      this .parentsChanged ();
   },
   removeParent (parent)
   {
      this [_parents] ?.delete (parent);

      this .parentsChanged ();
   },
   getParents ()
   {
      return this [_parents] ??= new _IterableWeakSet_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A ();
   },
   parentsChanged ()
   { },
   dispose ()
   {
      this [_parents] ?.clear ();

      _X3DObject_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .prototype .dispose .call (this);
   },
});

for (const key of Object .keys (X3DChildObject .prototype))
   Object .defineProperty (X3DChildObject .prototype, key, { enumerable: false });

const __default__ = X3DChildObject;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .add ("X3DChildObject", __default__));

/***/ },

/***/ 3869
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(8450);
/* harmony import */ var _X3DChildNode_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(266);
/* harmony import */ var _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(4946);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(6334);




let modificationCount = 0;

function X3DBindableNode (executionContext)
{
   _X3DChildNode_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .call (this, executionContext);

   this .addType (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .X3DBindableNode);

   this .modificationCount = 0;
}

Object .assign (Object .setPrototypeOf (X3DBindableNode .prototype, _X3DChildNode_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .prototype),
{
   initialize ()
   {
      _X3DChildNode_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .prototype .initialize .call (this);

      this ._set_bind .addInterest ("set_bind__", this);
   },
   isCameraObject ()
   {
      return true;
   },
   getModificationCount ()
   {
      return this .modificationCount;
   },
   transitionStart ()
   { },
   set_bind__ ()
   {
      if (modificationCount === Number .MAX_SAFE_INTEGER)
         modificationCount = 0;

      this .modificationCount = ++ modificationCount;
   },
});

Object .defineProperties (X3DBindableNode, _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .getStaticProperties ("X3DBindableNode", "Core", 1));

Object .defineProperties (X3DBindableNode,
{
   getModificationCount:
   {
      value ()
      {
         return modificationCount;
      },
      enumerable: false,
   },
});

const __default__ = X3DBindableNode;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .add ("X3DBindableNode", __default__));

/***/ },

/***/ 3921
(module) {

/**
 * @license
 * Copyright 2000, Silicon Graphics, Inc. All Rights Reserved.
 * Copyright 2015, Google Inc. All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to
 * deal in the Software without restriction, including without limitation the
 * rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
 * sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice including the dates of first publication and
 * either this permission notice or a reference to http://oss.sgi.com/projects/FreeB/
 * shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * SILICON GRAPHICS, INC. BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR
 * IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 * Original Code. The Original Code is: OpenGL Sample Implementation,
 * Version 1.2.1, released January 26, 2000, developed by Silicon Graphics,
 * Inc. The Original Code is Copyright (c) 1991-2000 Silicon Graphics, Inc.
 * Copyright in any portions created by third parties is as indicated
 * elsewhere herein. All Rights Reserved.
 */
/**
 * @author ericv@cs.stanford.edu (Eric Veach)
 * @author bckenny@google.com (Brendan Kenny)
 */

/**
 * Base namespace.
 * @const
 */
var libtess = {};

/**
 * Whether to run asserts and extra debug checks.
 * @define {boolean}
 */
libtess.DEBUG = false;

/**
 * Checks if the condition evaluates to true if libtess.DEBUG is true.
 * @param {*} condition The condition to check.
 * @param {string=} opt_message Error message in case of failure.
 * @throws {Error} Assertion failed, the condition evaluates to false.
 */
libtess.assert = function(condition, opt_message) {
  if (libtess.DEBUG && !condition) {
    throw new Error('Assertion failed' +
        (opt_message ? ': ' + opt_message : ''));
  }
};

/**
 * The maximum vertex coordinate size, 1e150. Anything larger will trigger a
 * GLU_TESS_COORD_TOO_LARGE error callback and the vertex will be clamped to
 * this value for all tessellation calculations.
 * @const {number}
 */
libtess.GLU_TESS_MAX_COORD = 1e150;
// NOTE(bckenny): value from glu.pl generator

/**
 * Normally the polygon is projected to a plane perpendicular to one of the
 * three coordinate axes before tessellating in 2d. This helps numerical
 * accuracy by forgoing a transformation step by simply dropping one coordinate
 * dimension.
 *
 * However, this can affect the placement of intersection points for non-axis-
 * aligned polygons. Setting TRUE_PROJECT to true will instead project onto a
 * plane actually perpendicular to the polygon's normal.
 *
 * NOTE(bckenny): I can find no instances on the internet in which this mode has
 * been used, but it's difficult to search for. This was a compile-time setting
 * in the original, so setting this as constant. If this is exposed in the
 * public API, remove the ignore coverage directives on
 * libtess.normal.projectPolygon and libtess.normal.normalize_.
 * @const {boolean}
 */
libtess.TRUE_PROJECT = false;

/**
 * The default tolerance for merging features, 0, meaning vertices are only
 * merged if they are exactly coincident
 * If a higher tolerance is needed, significant rewriting will need to occur.
 * See libtess.sweep.TOLERANCE_NONZERO_ as a starting place.
 * @const {number}
 */
libtess.GLU_TESS_DEFAULT_TOLERANCE = 0;

/**
 * The input contours parition the plane into regions. A winding
 * rule determines which of these regions are inside the polygon.
 *
 * For a single contour C, the winding number of a point x is simply
 * the signed number of revolutions we make around x as we travel
 * once around C (where CCW is positive). When there are several
 * contours, the individual winding numbers are summed. This
 * procedure associates a signed integer value with each point x in
 * the plane. Note that the winding number is the same for all
 * points in a single region.
 *
 * The winding rule classifies a region as "inside" if its winding
 * number belongs to the chosen category (odd, nonzero, positive,
 * negative, or absolute value of at least two). The current GLU
 * tesselator implements the "odd" rule. The "nonzero" rule is another
 * common way to define the interior. The other three rules are
 * useful for polygon CSG operations.
 * @enum {number}
 */
libtess.windingRule = {
  // NOTE(bckenny): values from enumglu.spec
  GLU_TESS_WINDING_ODD: 100130,
  GLU_TESS_WINDING_NONZERO: 100131,
  GLU_TESS_WINDING_POSITIVE: 100132,
  GLU_TESS_WINDING_NEGATIVE: 100133,
  GLU_TESS_WINDING_ABS_GEQ_TWO: 100134
};

/**
 * The type of primitive return from a "begin" callback. GL_LINE_LOOP is only
 * returned when GLU_TESS_BOUNDARY_ONLY is true. GL_TRIANGLE_STRIP and
 * GL_TRIANGLE_FAN are no longer returned since 1.1.0 (see release notes).
 * @enum {number}
 */
libtess.primitiveType = {
  GL_LINE_LOOP: 2,
  GL_TRIANGLES: 4,
  GL_TRIANGLE_STRIP: 5,
  GL_TRIANGLE_FAN: 6
};

/**
 * The types of errors provided in the error callback.
 * @enum {number}
 */
libtess.errorType = {
  // TODO(bckenny) doc types
  // NOTE(bckenny): values from enumglu.spec
  GLU_TESS_MISSING_BEGIN_POLYGON: 100151,
  GLU_TESS_MISSING_END_POLYGON: 100153,
  GLU_TESS_MISSING_BEGIN_CONTOUR: 100152,
  GLU_TESS_MISSING_END_CONTOUR: 100154,
  GLU_TESS_COORD_TOO_LARGE: 100155,
  GLU_TESS_NEED_COMBINE_CALLBACK: 100156
};

/**
 * Enum values necessary for providing settings and callbacks. See the readme
 * for details.
 * @enum {number}
 */
libtess.gluEnum = {
  // TODO(bckenny): rename so not always typing libtess.gluEnum.*?

  // NOTE(bckenny): values from enumglu.spec
  GLU_TESS_BEGIN: 100100,
  GLU_TESS_VERTEX: 100101,
  GLU_TESS_END: 100102,
  GLU_TESS_ERROR: 100103,
  GLU_TESS_EDGE_FLAG: 100104,
  GLU_TESS_COMBINE: 100105,
  GLU_TESS_BEGIN_DATA: 100106,
  GLU_TESS_VERTEX_DATA: 100107,
  GLU_TESS_END_DATA: 100108,
  GLU_TESS_ERROR_DATA: 100109,
  GLU_TESS_EDGE_FLAG_DATA: 100110,
  GLU_TESS_COMBINE_DATA: 100111,

  GLU_TESS_MESH: 100112,  //  NOTE(bckenny): from tess.c
  GLU_TESS_TOLERANCE: 100142,
  GLU_TESS_WINDING_RULE: 100140,
  GLU_TESS_BOUNDARY_ONLY: 100141,

  // TODO(bckenny): move this to libtess.errorType?
  GLU_INVALID_ENUM: 100900,
  GLU_INVALID_VALUE: 100901
};

/** @typedef {number} */
libtess.PQHandle;

/* global libtess */

/** @const */
libtess.geom = {};

/**
 * Returns whether vertex u and vertex v are equal.
 * @param {libtess.GluVertex} u
 * @param {libtess.GluVertex} v
 * @return {boolean}
 */
libtess.geom.vertEq = function(u, v) {
  return u.s === v.s && u.t === v.t;
};

/**
 * Returns whether vertex u is lexicographically less than or equal to vertex v.
 * @param {libtess.GluVertex} u
 * @param {libtess.GluVertex} v
 * @return {boolean}
 */
libtess.geom.vertLeq = function(u, v) {
  return (u.s < v.s) || (u.s === v.s && u.t <= v.t);
};

/**
 * Given three vertices u,v,w such that geom.vertLeq(u,v) && geom.vertLeq(v,w),
 * evaluates the t-coord of the edge uw at the s-coord of the vertex v.
 * Returns v.t - (uw)(v.s), ie. the signed distance from uw to v.
 * If uw is vertical (and thus passes thru v), the result is zero.
 *
 * The calculation is extremely accurate and stable, even when v
 * is very close to u or w.  In particular if we set v.t = 0 and
 * let r be the negated result (this evaluates (uw)(v.s)), then
 * r is guaranteed to satisfy MIN(u.t,w.t) <= r <= MAX(u.t,w.t).
 * @param {libtess.GluVertex} u
 * @param {libtess.GluVertex} v
 * @param {libtess.GluVertex} w
 * @return {number}
 */
libtess.geom.edgeEval = function(u, v, w) {

  var gapL = v.s - u.s;
  var gapR = w.s - v.s;

  if (gapL + gapR > 0) {
    if (gapL < gapR) {
      return (v.t - u.t) + (u.t - w.t) * (gapL / (gapL + gapR));
    } else {
      return (v.t - w.t) + (w.t - u.t) * (gapR / (gapL + gapR));
    }
  }

  // vertical line
  return 0;
};

/**
 * Returns a number whose sign matches geom.edgeEval(u,v,w) but which
 * is cheaper to evaluate.  Returns > 0, == 0 , or < 0
 * as v is above, on, or below the edge uw.
 * @param {libtess.GluVertex} u
 * @param {libtess.GluVertex} v
 * @param {libtess.GluVertex} w
 * @return {number}
 */
libtess.geom.edgeSign = function(u, v, w) {

  var gapL = v.s - u.s;
  var gapR = w.s - v.s;

  if (gapL + gapR > 0) {
    return (v.t - w.t) * gapL + (v.t - u.t) * gapR;
  }

  // vertical line
  return 0;
};

/**
 * Version of VertLeq with s and t transposed.
 * Returns whether vertex u is lexicographically less than or equal to vertex v.
 * @param {libtess.GluVertex} u
 * @param {libtess.GluVertex} v
 * @return {boolean}
 */
libtess.geom.transLeq = function(u, v) {
  return (u.t < v.t) || (u.t === v.t && u.s <= v.s);
};

/**
 * Version of geom.edgeEval with s and t transposed.
 * Given three vertices u,v,w such that geom.transLeq(u,v) &&
 * geom.transLeq(v,w), evaluates the t-coord of the edge uw at the s-coord of
 * the vertex v. Returns v.s - (uw)(v.t), ie. the signed distance from uw to v.
 * If uw is vertical (and thus passes thru v), the result is zero.
 *
 * The calculation is extremely accurate and stable, even when v
 * is very close to u or w.  In particular if we set v.s = 0 and
 * let r be the negated result (this evaluates (uw)(v.t)), then
 * r is guaranteed to satisfy MIN(u.s,w.s) <= r <= MAX(u.s,w.s).
 * @param {libtess.GluVertex} u
 * @param {libtess.GluVertex} v
 * @param {libtess.GluVertex} w
 * @return {number}
 */
libtess.geom.transEval = function(u, v, w) {

  var gapL = v.t - u.t;
  var gapR = w.t - v.t;

  if (gapL + gapR > 0) {
    if (gapL < gapR) {
      return (v.s - u.s) + (u.s - w.s) * (gapL / (gapL + gapR));
    } else {
      return (v.s - w.s) + (w.s - u.s) * (gapR / (gapL + gapR));
    }
  }

  // vertical line
  return 0;
};

/**
 * Version of geom.edgeSign with s and t transposed.
 * Returns a number whose sign matches geom.transEval(u,v,w) but which
 * is cheaper to evaluate.  Returns > 0, == 0 , or < 0
 * as v is above, on, or below the edge uw.
 * @param {libtess.GluVertex} u
 * @param {libtess.GluVertex} v
 * @param {libtess.GluVertex} w
 * @return {number}
 */
libtess.geom.transSign = function(u, v, w) {

  var gapL = v.t - u.t;
  var gapR = w.t - v.t;

  if (gapL + gapR > 0) {
    return (v.s - w.s) * gapL + (v.s - u.s) * gapR;
  }

  // vertical line
  return 0;
};

/**
 * Returns whether edge is directed from right to left.
 * @param {libtess.GluHalfEdge} e
 * @return {boolean}
 */
libtess.geom.edgeGoesLeft = function(e) {
  return libtess.geom.vertLeq(e.dst(), e.org);
};

/**
 * Returns whether edge is directed from left to right.
 * @param {libtess.GluHalfEdge} e
 * @return {boolean}
 */
libtess.geom.edgeGoesRight = function(e) {
  return libtess.geom.vertLeq(e.org, e.dst());
};

/**
 * Calculates the L1 distance between vertices u and v.
 * @param {libtess.GluVertex} u
 * @param {libtess.GluVertex} v
 * @return {number}
 */
libtess.geom.vertL1dist = function(u, v) {
  return Math.abs(u.s - v.s) + Math.abs(u.t - v.t);
};

// NOTE(bckenny): vertCCW is called nowhere in libtess and isn't part of the
// public API.
/* istanbul ignore next */
/**
 * For almost-degenerate situations, the results are not reliable.
 * Unless the floating-point arithmetic can be performed without
 * rounding errors, *any* implementation will give incorrect results
 * on some degenerate inputs, so the client must have some way to
 * handle this situation.
 * @param {!libtess.GluVertex} u
 * @param {!libtess.GluVertex} v
 * @param {!libtess.GluVertex} w
 * @return {boolean}
 */
libtess.geom.vertCCW = function(u, v, w) {
  return (u.s * (v.t - w.t) + v.s * (w.t - u.t) + w.s * (u.t - v.t)) >= 0;
};

/**
 * Given parameters a,x,b,y returns the value (b*x+a*y)/(a+b),
 * or (x+y)/2 if a==b==0. It requires that a,b >= 0, and enforces
 * this in the rare case that one argument is slightly negative.
 * The implementation is extremely stable numerically.
 * In particular it guarantees that the result r satisfies
 * MIN(x,y) <= r <= MAX(x,y), and the results are very accurate
 * even when a and b differ greatly in magnitude.
 * @private
 * @param {number} a
 * @param {number} x
 * @param {number} b
 * @param {number} y
 * @return {number}
 */
libtess.geom.interpolate_ = function(a, x, b, y) {
  // from Macro RealInterpolate:
  //(a = (a < 0) ? 0 : a, b = (b < 0) ? 0 : b, ((a <= b) ? ((b == 0) ? ((x+y) / 2) : (x + (y-x) * (a/(a+b)))) : (y + (x-y) * (b/(a+b)))))
  a = (a < 0) ? 0 : a;
  b = (b < 0) ? 0 : b;

  if (a <= b) {
    if (b === 0) {
      return (x + y) / 2;
    } else {
      return x + (y - x) * (a / (a + b));
    }
  } else {
    return y + (x - y) * (b / (a + b));
  }
};

/**
 * Given edges (o1,d1) and (o2,d2), compute their point of intersection.
 * The computed point is guaranteed to lie in the intersection of the
 * bounding rectangles defined by each edge.
 * @param {!libtess.GluVertex} o1
 * @param {!libtess.GluVertex} d1
 * @param {!libtess.GluVertex} o2
 * @param {!libtess.GluVertex} d2
 * @param {!libtess.GluVertex} v
 */
libtess.geom.edgeIntersect = function(o1, d1, o2, d2, v) {
  // This is certainly not the most efficient way to find the intersection
  // of two line segments, but it is very numerically stable.

  // Strategy: find the two middle vertices in the VertLeq ordering,
  // and interpolate the intersection s-value from these. Then repeat
  // using the TransLeq ordering to find the intersection t-value.
  var z1;
  var z2;
  var tmp;
  if (!libtess.geom.vertLeq(o1, d1)) {
    // Swap(o1, d1);
    tmp = o1;
    o1 = d1;
    d1 = tmp;
  }
  if (!libtess.geom.vertLeq(o2, d2)) {
    // Swap(o2, d2);
    tmp = o2;
    o2 = d2;
    d2 = tmp;
  }
  if (!libtess.geom.vertLeq(o1, o2)) {
    // Swap(o1, o2);
    tmp = o1;
    o1 = o2;
    o2 = tmp;
    // Swap(d1, d2);
    tmp = d1;
    d1 = d2;
    d2 = tmp;
  }

  if (!libtess.geom.vertLeq(o2, d1)) {
    // Technically, no intersection -- do our best
    v.s = (o2.s + d1.s) / 2;

  } else if (libtess.geom.vertLeq(d1, d2)) {
    // Interpolate between o2 and d1
    z1 = libtess.geom.edgeEval(o1, o2, d1);
    z2 = libtess.geom.edgeEval(o2, d1, d2);
    if (z1 + z2 < 0) { z1 = -z1; z2 = -z2; }
    v.s = libtess.geom.interpolate_(z1, o2.s, z2, d1.s);

  } else {
    // Interpolate between o2 and d2
    z1 = libtess.geom.edgeSign(o1, o2, d1);
    z2 = -libtess.geom.edgeSign(o1, d2, d1);
    if (z1 + z2 < 0) { z1 = -z1; z2 = -z2; }
    v.s = libtess.geom.interpolate_(z1, o2.s, z2, d2.s);
  }

  // Now repeat the process for t
  if (!libtess.geom.transLeq(o1, d1)) {
    // Swap(o1, d1);
    tmp = o1;
    o1 = d1;
    d1 = tmp;
  }
  if (!libtess.geom.transLeq(o2, d2)) {
    // Swap(o2, d2);
    tmp = o2;
    o2 = d2;
    d2 = tmp;
  }
  if (!libtess.geom.transLeq(o1, o2)) {
    // Swap(o1, o2);
    tmp = o1;
    o1 = o2;
    o2 = tmp;
    // Swap(d1, d2);
    tmp = d1;
    d1 = d2;
    d2 = tmp;
  }

  if (!libtess.geom.transLeq(o2, d1)) {
    // Technically, no intersection -- do our best
    v.t = (o2.t + d1.t) / 2;

  } else if (libtess.geom.transLeq(d1, d2)) {
    // Interpolate between o2 and d1
    z1 = libtess.geom.transEval(o1, o2, d1);
    z2 = libtess.geom.transEval(o2, d1, d2);
    if (z1 + z2 < 0) { z1 = -z1; z2 = -z2; }
    v.t = libtess.geom.interpolate_(z1, o2.t, z2, d1.t);

  } else {
    // Interpolate between o2 and d2
    z1 = libtess.geom.transSign(o1, o2, d1);
    z2 = -libtess.geom.transSign(o1, d2, d1);
    if (z1 + z2 < 0) { z1 = -z1; z2 = -z2; }
    v.t = libtess.geom.interpolate_(z1, o2.t, z2, d2.t);
  }
};

/* global libtess */

// TODO(bckenny): could maybe merge GluMesh and mesh.js since these are
// operations on the mesh

/** @const */
libtess.mesh = {};

/****************** Basic Edge Operations **********************/


/**
 * makeEdge creates one edge, two vertices, and a loop (face).
 * The loop consists of the two new half-edges.
 *
 * @param {libtess.GluMesh} mesh [description].
 * @return {libtess.GluHalfEdge} [description].
 */
libtess.mesh.makeEdge = function(mesh) {
  // TODO(bckenny): probably move to GluMesh, but needs Make* methods with it

  var e = libtess.mesh.makeEdgePair_(mesh.eHead);

  // complete edge with vertices and face (see mesh.makeEdgePair_)
  libtess.mesh.makeVertex_(e, mesh.vHead);
  libtess.mesh.makeVertex_(e.sym, mesh.vHead);
  libtess.mesh.makeFace_(e, mesh.fHead);

  return e;
};


/**
 * meshSplice(eOrg, eDst) is the basic operation for changing the
 * mesh connectivity and topology. It changes the mesh so that
 *  eOrg.oNext <- OLD( eDst.oNext )
 *  eDst.oNext <- OLD( eOrg.oNext )
 * where OLD(...) means the value before the meshSplice operation.
 *
 * This can have two effects on the vertex structure:
 *  - if eOrg.org != eDst.org, the two vertices are merged together
 *  - if eOrg.org == eDst.org, the origin is split into two vertices
 * In both cases, eDst.org is changed and eOrg.org is untouched.
 *
 * Similarly (and independently) for the face structure,
 *  - if eOrg.lFace == eDst.lFace, one loop is split into two
 *  - if eOrg.lFace != eDst.lFace, two distinct loops are joined into one
 * In both cases, eDst.lFace is changed and eOrg.lFace is unaffected.
 *
 * Some special cases:
 * If eDst == eOrg, the operation has no effect.
 * If eDst == eOrg.lNext, the new face will have a single edge.
 * If eDst == eOrg.lPrev(), the old face will have a single edge.
 * If eDst == eOrg.oNext, the new vertex will have a single edge.
 * If eDst == eOrg.oPrev(), the old vertex will have a single edge.
 *
 * @param {libtess.GluHalfEdge} eOrg [description].
 * @param {libtess.GluHalfEdge} eDst [description].
 */
libtess.mesh.meshSplice = function(eOrg, eDst) {
  // TODO: more descriptive name?

  var joiningLoops = false;
  var joiningVertices = false;

  if (eOrg === eDst) {
    return;
  }

  if (eDst.org !== eOrg.org) {
    // We are merging two disjoint vertices -- destroy eDst.org
    joiningVertices = true;
    libtess.mesh.killVertex_(eDst.org, eOrg.org);
  }

  if (eDst.lFace !== eOrg.lFace) {
    // We are connecting two disjoint loops -- destroy eDst.lFace
    joiningLoops = true;
    libtess.mesh.killFace_(eDst.lFace, eOrg.lFace);
  }

  // Change the edge structure
  libtess.mesh.splice_(eDst, eOrg);

  if (!joiningVertices) {
    // We split one vertex into two -- the new vertex is eDst.org.
    // Make sure the old vertex points to a valid half-edge.
    libtess.mesh.makeVertex_(eDst, eOrg.org);
    eOrg.org.anEdge = eOrg;
  }

  if (!joiningLoops) {
    // We split one loop into two -- the new loop is eDst.lFace.
    // Make sure the old face points to a valid half-edge.
    libtess.mesh.makeFace_(eDst, eOrg.lFace);
    eOrg.lFace.anEdge = eOrg;
  }
};


/**
 * deleteEdge(eDel) removes the edge eDel. There are several cases:
 * if (eDel.lFace != eDel.rFace()), we join two loops into one; the loop
 * eDel.lFace is deleted. Otherwise, we are splitting one loop into two;
 * the newly created loop will contain eDel.dst(). If the deletion of eDel
 * would create isolated vertices, those are deleted as well.
 *
 * This function could be implemented as two calls to __gl_meshSplice
 * plus a few calls to memFree, but this would allocate and delete
 * unnecessary vertices and faces.
 *
 * @param {libtess.GluHalfEdge} eDel [description].
 */
libtess.mesh.deleteEdge = function(eDel) {
  var eDelSym = eDel.sym;
  var joiningLoops = false;

  // First step: disconnect the origin vertex eDel.org.  We make all
  // changes to get a consistent mesh in this "intermediate" state.
  if (eDel.lFace !== eDel.rFace()) {
    // We are joining two loops into one -- remove the left face
    joiningLoops = true;
    libtess.mesh.killFace_(eDel.lFace, eDel.rFace());
  }

  if (eDel.oNext === eDel) {
    libtess.mesh.killVertex_(eDel.org, null);

  } else {
    // Make sure that eDel.org and eDel.rFace() point to valid half-edges
    eDel.rFace().anEdge = eDel.oPrev();
    eDel.org.anEdge = eDel.oNext;

    libtess.mesh.splice_(eDel, eDel.oPrev());

    if (!joiningLoops) {
      // We are splitting one loop into two -- create a new loop for eDel.
      libtess.mesh.makeFace_(eDel, eDel.lFace);
    }
  }

  // Claim: the mesh is now in a consistent state, except that eDel.org
  // may have been deleted.  Now we disconnect eDel.dst().
  if (eDelSym.oNext === eDelSym) {
    libtess.mesh.killVertex_(eDelSym.org, null);
    libtess.mesh.killFace_(eDelSym.lFace, null);

  } else {
    // Make sure that eDel.dst() and eDel.lFace point to valid half-edges
    eDel.lFace.anEdge = eDelSym.oPrev();
    eDelSym.org.anEdge = eDelSym.oNext;
    libtess.mesh.splice_(eDelSym, eDelSym.oPrev());
  }

  // Any isolated vertices or faces have already been freed.
  libtess.mesh.killEdge_(eDel);
};

/******************** Other Edge Operations **********************/

/* All these routines can be implemented with the basic edge
 * operations above.  They are provided for convenience and efficiency.
 */


/**
 * addEdgeVertex(eOrg) creates a new edge eNew such that
 * eNew == eOrg.lNext, and eNew.dst() is a newly created vertex.
 * eOrg and eNew will have the same left face.
 *
 * @param {libtess.GluHalfEdge} eOrg [description].
 * @return {libtess.GluHalfEdge} [description].
 */
libtess.mesh.addEdgeVertex = function(eOrg) {
  // TODO(bckenny): why is it named this?

  var eNew = libtess.mesh.makeEdgePair_(eOrg);
  var eNewSym = eNew.sym;

  // Connect the new edge appropriately
  libtess.mesh.splice_(eNew, eOrg.lNext);

  // Set the vertex and face information
  eNew.org = eOrg.dst();

  libtess.mesh.makeVertex_(eNewSym, eNew.org);

  eNew.lFace = eNewSym.lFace = eOrg.lFace;

  return eNew;
};


/**
 * splitEdge(eOrg) splits eOrg into two edges eOrg and eNew,
 * such that eNew == eOrg.lNext. The new vertex is eOrg.dst() == eNew.org.
 * eOrg and eNew will have the same left face.
 *
 * @param {libtess.GluHalfEdge} eOrg [description].
 * @return {!libtess.GluHalfEdge} [description].
 */
libtess.mesh.splitEdge = function(eOrg) {
  var tempHalfEdge = libtess.mesh.addEdgeVertex(eOrg);
  var eNew = tempHalfEdge.sym;

  // Disconnect eOrg from eOrg.dst() and connect it to eNew.org
  libtess.mesh.splice_(eOrg.sym, eOrg.sym.oPrev());
  libtess.mesh.splice_(eOrg.sym, eNew);

  // Set the vertex and face information
  eOrg.sym.org = eNew.org; // NOTE(bckenny): assignment to dst
  eNew.dst().anEdge = eNew.sym;  // may have pointed to eOrg.sym
  eNew.sym.lFace = eOrg.rFace(); // NOTE(bckenny): assignment to rFace
  eNew.winding = eOrg.winding;  // copy old winding information
  eNew.sym.winding = eOrg.sym.winding;

  return eNew;
};


/**
 * connect(eOrg, eDst) creates a new edge from eOrg.dst()
 * to eDst.org, and returns the corresponding half-edge eNew.
 * If eOrg.lFace == eDst.lFace, this splits one loop into two,
 * and the newly created loop is eNew.lFace. Otherwise, two disjoint
 * loops are merged into one, and the loop eDst.lFace is destroyed.
 *
 * If (eOrg == eDst), the new face will have only two edges.
 * If (eOrg.lNext == eDst), the old face is reduced to a single edge.
 * If (eOrg.lNext.lNext == eDst), the old face is reduced to two edges.
 *
 * @param {libtess.GluHalfEdge} eOrg [description].
 * @param {libtess.GluHalfEdge} eDst [description].
 * @return {!libtess.GluHalfEdge} [description].
 */
libtess.mesh.connect = function(eOrg, eDst) {
  var joiningLoops = false;
  var eNew = libtess.mesh.makeEdgePair_(eOrg);
  var eNewSym = eNew.sym;

  if (eDst.lFace !== eOrg.lFace) {
    // We are connecting two disjoint loops -- destroy eDst.lFace
    joiningLoops = true;
    libtess.mesh.killFace_(eDst.lFace, eOrg.lFace);
  }

  // Connect the new edge appropriately
  libtess.mesh.splice_(eNew, eOrg.lNext);
  libtess.mesh.splice_(eNewSym, eDst);

  // Set the vertex and face information
  eNew.org = eOrg.dst();
  eNewSym.org = eDst.org;
  eNew.lFace = eNewSym.lFace = eOrg.lFace;

  // Make sure the old face points to a valid half-edge
  eOrg.lFace.anEdge = eNewSym;

  if (!joiningLoops) {
    // We split one loop into two -- the new loop is eNew.lFace
    libtess.mesh.makeFace_(eNew, eOrg.lFace);
  }
  return eNew;
};

/******************** Other Operations **********************/


/**
 * zapFace(fZap) destroys a face and removes it from the
 * global face list. All edges of fZap will have a null pointer as their
 * left face. Any edges which also have a null pointer as their right face
 * are deleted entirely (along with any isolated vertices this produces).
 * An entire mesh can be deleted by zapping its faces, one at a time,
 * in any order. Zapped faces cannot be used in further mesh operations!
 *
 * @param {libtess.GluFace} fZap [description].
 */
libtess.mesh.zapFace = function(fZap) {
  var eStart = fZap.anEdge;

  // walk around face, deleting edges whose right face is also NULL
  var eNext = eStart.lNext;
  var e;
  do {
    e = eNext;
    eNext = e.lNext;

    e.lFace = null;
    if (e.rFace() === null) {
      // delete the edge -- see mesh.deleteEdge above
      if (e.oNext === e) {
        libtess.mesh.killVertex_(e.org, null);

      } else {
        // Make sure that e.org points to a valid half-edge
        e.org.anEdge = e.oNext;
        libtess.mesh.splice_(e, e.oPrev());
      }

      var eSym = e.sym;

      if (eSym.oNext === eSym) {
        libtess.mesh.killVertex_(eSym.org, null);

      } else {
        // Make sure that eSym.org points to a valid half-edge
        eSym.org.anEdge = eSym.oNext;
        libtess.mesh.splice_(eSym, eSym.oPrev());
      }
      libtess.mesh.killEdge_(e);
    }
  } while (e !== eStart);

  // delete from circular doubly-linked list
  var fPrev = fZap.prev;
  var fNext = fZap.next;
  fNext.prev = fPrev;
  fPrev.next = fNext;

  // TODO(bckenny): memFree( fZap );
  // TODO(bckenny): probably null at callsite
};

// TODO(bckenny): meshUnion isn't called within libtess and isn't part of the
// public API. Could be useful if more mesh manipulation functions are exposed.
/* istanbul ignore next */
/**
 * meshUnion() forms the union of all structures in
 * both meshes, and returns the new mesh (the old meshes are destroyed).
 *
 * @param {!libtess.GluMesh} mesh1
 * @param {!libtess.GluMesh} mesh2
 * @return {!libtess.GluMesh}
 */
libtess.mesh.meshUnion = function(mesh1, mesh2) {
  // TODO(bceknny): probably move to GluMesh method
  var f1 = mesh1.fHead;
  var v1 = mesh1.vHead;
  var e1 = mesh1.eHead;

  var f2 = mesh2.fHead;
  var v2 = mesh2.vHead;
  var e2 = mesh2.eHead;

  // Add the faces, vertices, and edges of mesh2 to those of mesh1
  if (f2.next !== f2) {
    f1.prev.next = f2.next;
    f2.next.prev = f1.prev;
    f2.prev.next = f1;
    f1.prev = f2.prev;
  }

  if (v2.next !== v2) {
    v1.prev.next = v2.next;
    v2.next.prev = v1.prev;
    v2.prev.next = v1;
    v1.prev = v2.prev;
  }

  if (e2.next !== e2) {
    e1.sym.next.sym.next = e2.next;
    e2.next.sym.next = e1.sym.next;
    e2.sym.next.sym.next = e1;
    e1.sym.next = e2.sym.next;
  }

  // TODO(bckenny): memFree(mesh2);
  // TODO(bckenny): If function is kept, remove mesh2's data to enforce.
  return mesh1;
};


/**
 * deleteMesh(mesh) will free all storage for any valid mesh.
 * @param {libtess.GluMesh} mesh [description].
 */
libtess.mesh.deleteMesh = function(mesh) {
  // TODO(bckenny): unnecessary, I think.
  // TODO(bckenny): might want to explicitly null at callsite
  // lots of memFrees. see also DELETE_BY_ZAPPING
};

/************************ Utility Routines ************************/


/**
 * Creates a new pair of half-edges which form their own loop.
 * No vertex or face structures are allocated, but these must be assigned
 * before the current edge operation is completed.
 *
 * TODO(bckenny): warning about eNext strictly being first of pair? (see code)
 *
 * @private
 * @param {libtess.GluHalfEdge} eNext [description].
 * @return {libtess.GluHalfEdge} [description].
 */
libtess.mesh.makeEdgePair_ = function(eNext) {
  var e = new libtess.GluHalfEdge();
  var eSym = new libtess.GluHalfEdge();

  // TODO(bckenny): how do we ensure this? see above comment in jsdoc
  // Make sure eNext points to the first edge of the edge pair
  // if (eNext->Sym < eNext ) { eNext = eNext->Sym; }

  // NOTE(bckenny): check this for bugs in current implementation!

  // Insert in circular doubly-linked list before eNext.
  // Note that the prev pointer is stored in sym.next.
  var ePrev = eNext.sym.next;
  eSym.next = ePrev;
  ePrev.sym.next = e;
  e.next = eNext;
  eNext.sym.next = eSym;

  e.sym = eSym;
  e.oNext = e;
  e.lNext = eSym;

  eSym.sym = e;
  eSym.oNext = eSym;
  eSym.lNext = e;

  return e;
};


/**
 * splice_ is best described by the Guibas/Stolfi paper or the
 * CS348a notes. Basically, it modifies the mesh so that
 * a.oNext and b.oNext are exchanged. This can have various effects
 * depending on whether a and b belong to different face or vertex rings.
 * For more explanation see mesh.meshSplice below.
 *
 * @private
 * @param {libtess.GluHalfEdge} a [description].
 * @param {libtess.GluHalfEdge} b [description].
 */
libtess.mesh.splice_ = function(a, b) {
  var aONext = a.oNext;
  var bONext = b.oNext;

  aONext.sym.lNext = b;
  bONext.sym.lNext = a;
  a.oNext = bONext;
  b.oNext = aONext;
};


/**
 * makeVertex_(eOrig, vNext) attaches a new vertex and makes it the
 * origin of all edges in the vertex loop to which eOrig belongs. "vNext" gives
 * a place to insert the new vertex in the global vertex list.  We insert
 * the new vertex *before* vNext so that algorithms which walk the vertex
 * list will not see the newly created vertices.
 *
 * NOTE: unlike original, acutally allocates new vertex.
 *
 * @private
 * @param {libtess.GluHalfEdge} eOrig [description].
 * @param {libtess.GluVertex} vNext [description].
 */
libtess.mesh.makeVertex_ = function(eOrig, vNext) {
  // insert in circular doubly-linked list before vNext
  var vPrev = vNext.prev;
  var vNew = new libtess.GluVertex(vNext, vPrev);
  vPrev.next = vNew;
  vNext.prev = vNew;

  vNew.anEdge = eOrig;
  // leave coords, s, t undefined
  // TODO(bckenny): does above line mean 0 specifically, or does it matter?

  // fix other edges on this vertex loop
  var e = eOrig;
  do {
    e.org = vNew;
    e = e.oNext;
  } while (e !== eOrig);
};


/**
 * makeFace_(eOrig, fNext) attaches a new face and makes it the left
 * face of all edges in the face loop to which eOrig belongs. "fNext" gives
 * a place to insert the new face in the global face list.  We insert
 * the new face *before* fNext so that algorithms which walk the face
 * list will not see the newly created faces.
 *
 * NOTE: unlike original, acutally allocates new face.
 *
 * @private
 * @param {libtess.GluHalfEdge} eOrig [description].
 * @param {libtess.GluFace} fNext [description].
 */
libtess.mesh.makeFace_ = function(eOrig, fNext) {
  // insert in circular doubly-linked list before fNext
  var fPrev = fNext.prev;
  var fNew = new libtess.GluFace(fNext, fPrev);
  fPrev.next = fNew;
  fNext.prev = fNew;

  fNew.anEdge = eOrig;

  // The new face is marked "inside" if the old one was.  This is a
  // convenience for the common case where a face has been split in two.
  fNew.inside = fNext.inside;

  // fix other edges on this face loop
  var e = eOrig;
  do {
    e.lFace = fNew;
    e = e.lNext;
  } while (e !== eOrig);
};


/**
 * killEdge_ destroys an edge (the half-edges eDel and eDel.sym),
 * and removes from the global edge list.
 *
 * @private
 * @param {libtess.GluHalfEdge} eDel [description].
 */
libtess.mesh.killEdge_ = function(eDel) {
  // TODO(bckenny): in this case, no need to worry(?), but check when checking mesh.makeEdgePair_
  // Half-edges are allocated in pairs, see EdgePair above
  // if (eDel->Sym < eDel ) { eDel = eDel->Sym; }

  // delete from circular doubly-linked list
  var eNext = eDel.next;
  var ePrev = eDel.sym.next;
  eNext.sym.next = ePrev;
  ePrev.sym.next = eNext;

  // TODO(bckenny): memFree( eDel ); (which also frees eDel.sym)
  // TODO(bckenny): need to null at callsites?
};


/**
 * killVertex_ destroys a vertex and removes it from the global
 * vertex list. It updates the vertex loop to point to a given new vertex.
 *
 * @private
 * @param {libtess.GluVertex} vDel [description].
 * @param {libtess.GluVertex} newOrg [description].
 */
libtess.mesh.killVertex_ = function(vDel, newOrg) {
  var eStart = vDel.anEdge;

  // change the origin of all affected edges
  var e = eStart;
  do {
    e.org = newOrg;
    e = e.oNext;
  } while (e !== eStart);

  // delete from circular doubly-linked list
  var vPrev = vDel.prev;
  var vNext = vDel.next;
  vNext.prev = vPrev;
  vPrev.next = vNext;

  // TODO(bckenny): memFree( vDel );
  // TODO(bckenny): need to null at callsites?
};


/**
 * killFace_ destroys a face and removes it from the global face
 * list. It updates the face loop to point to a given new face.
 *
 * @private
 * @param {libtess.GluFace} fDel [description].
 * @param {libtess.GluFace} newLFace [description].
 */
libtess.mesh.killFace_ = function(fDel, newLFace) {
  var eStart = fDel.anEdge;

  // change the left face of all affected edges
  var e = eStart;
  do {
    e.lFace = newLFace;
    e = e.lNext;
  } while (e !== eStart);

  // delete from circular doubly-linked list
  var fPrev = fDel.prev;
  var fNext = fDel.next;
  fNext.prev = fPrev;
  fPrev.next = fNext;

  // TODO(bckenny): memFree( fDel );
  // TODO(bckenny): need to null at callsites?
};

/* global libtess */

/** @const */
libtess.normal = {};

// TODO(bckenny): Integrate SLANTED_SWEEP somehow?
/* The "feature merging" is not intended to be complete. There are
 * special cases where edges are nearly parallel to the sweep line
 * which are not implemented. The algorithm should still behave
 * robustly (ie. produce a reasonable tesselation) in the presence
 * of such edges, however it may miss features which could have been
 * merged. We could minimize this effect by choosing the sweep line
 * direction to be something unusual (ie. not parallel to one of the
 * coordinate axes).
 * #if defined(SLANTED_SWEEP)
 * #define S_UNIT_X  0.50941539564955385 // Pre-normalized
 * #define S_UNIT_Y  0.86052074622010633
 * #endif
 */

/**
 * X coordinate of local basis for polygon projection.
 * @private {number}
 * @const
 */
libtess.normal.S_UNIT_X_ = 1.0;

/**
 * Y coordinate of local basis for polygon projection.
 * @private {number}
 * @const
 */
libtess.normal.S_UNIT_Y_ = 0.0;

/**
 * Determines a polygon normal and projects vertices onto the plane of the
 * polygon. A pre-computed normal for the data may be provided, or set to the
 * zero vector if one should be computed from it.
 * @param {!libtess.GluTesselator} tess
 * @param {number} normalX
 * @param {number} normalY
 * @param {number} normalZ
 */
libtess.normal.projectPolygon = function(tess, normalX, normalY, normalZ) {
  var computedNormal = false;

  var norm = [
    normalX,
    normalY,
    normalZ
  ];
  if (normalX === 0 && normalY === 0 && normalZ === 0) {
    libtess.normal.computeNormal_(tess, norm);
    computedNormal = true;
  }

  var i = libtess.normal.longAxis_(norm);
  var vHead = tess.mesh.vHead;
  var v;

  // NOTE(bckenny): This branch is never taken. See comment on
  // libtess.TRUE_PROJECT.
  /* istanbul ignore if */
  if (libtess.TRUE_PROJECT) {
    // Choose the initial sUnit vector to be approximately perpendicular
    // to the normal.
    libtess.normal.normalize_(norm);

    var sUnit = [0, 0, 0];
    var tUnit = [0, 0, 0];

    sUnit[i] = 0;
    sUnit[(i + 1) % 3] = libtess.normal.S_UNIT_X_;
    sUnit[(i + 2) % 3] = libtess.normal.S_UNIT_Y_;

    // Now make it exactly perpendicular
    var w = libtess.normal.dot_(sUnit, norm);
    sUnit[0] -= w * norm[0];
    sUnit[1] -= w * norm[1];
    sUnit[2] -= w * norm[2];
    libtess.normal.normalize_(sUnit);

    // Choose tUnit so that (sUnit,tUnit,norm) form a right-handed frame
    tUnit[0] = norm[1] * sUnit[2] - norm[2] * sUnit[1];
    tUnit[1] = norm[2] * sUnit[0] - norm[0] * sUnit[2];
    tUnit[2] = norm[0] * sUnit[1] - norm[1] * sUnit[0];
    libtess.normal.normalize_(tUnit);

    // Project the vertices onto the sweep plane
    for (v = vHead.next; v !== vHead; v = v.next) {
      v.s = libtess.normal.dot_(v.coords, sUnit);
      v.t = libtess.normal.dot_(v.coords, tUnit);
    }

  } else {
    // Project perpendicular to a coordinate axis -- better numerically
    var sAxis = (i + 1) % 3;
    var tAxis = (i + 2) % 3;
    var tNegate = norm[i] > 0 ? 1 : -1;

    // Project the vertices onto the sweep plane
    for (v = vHead.next; v !== vHead; v = v.next) {
      v.s = v.coords[sAxis];
      v.t = tNegate * v.coords[tAxis];
    }
  }

  if (computedNormal) {
    libtess.normal.checkOrientation_(tess);
  }
};

// NOTE(bckenny): libtess.normal.dot_ is no longer called in code without
// libtess.TRUE_PROJECT defined.
/* istanbul ignore next */
/**
 * Computes the dot product of vectors u and v.
 * @private
 * @param {!Array<number>} u
 * @param {!Array<number>} v
 * @return {number}
 */
libtess.normal.dot_ = function(u, v) {
  return u[0] * v[0] + u[1] * v[1] + u[2] * v[2];
};

// NOTE(bckenny): only called from within libtess.normal.projectPolygon's
// TRUE_PROJECT branch, so ignoring for code coverage.
/* istanbul ignore next */
/**
 * Normalize vector v.
 * @private
 * @param {!Array<number>} v
 */
libtess.normal.normalize_ = function(v) {
  var len = v[0] * v[0] + v[1] * v[1] + v[2] * v[2];

  len = Math.sqrt(len);
  v[0] /= len;
  v[1] /= len;
  v[2] /= len;
};

/**
 * Returns the index of the longest component of vector v.
 * @private
 * @param {!Array<number>} v
 * @return {number}
 */
libtess.normal.longAxis_ = function(v) {
  var i = 0;

  if (Math.abs(v[1]) > Math.abs(v[0])) {
    i = 1;
  }
  if (Math.abs(v[2]) > Math.abs(v[i])) {
    i = 2;
  }

  return i;
};

/**
 * Compute an approximate normal of the polygon from the vertices themselves.
 * Result returned in norm.
 * @private
 * @param {!libtess.GluTesselator} tess
 * @param {!Array<number>} norm
 */
libtess.normal.computeNormal_ = function(tess, norm) {
  var maxVal = [
    -2 * libtess.GLU_TESS_MAX_COORD,
    -2 * libtess.GLU_TESS_MAX_COORD,
    -2 * libtess.GLU_TESS_MAX_COORD
  ];
  var minVal = [
    2 * libtess.GLU_TESS_MAX_COORD,
    2 * libtess.GLU_TESS_MAX_COORD,
    2 * libtess.GLU_TESS_MAX_COORD
  ];
  var maxVert = [];
  var minVert = [];

  var v;
  var vHead = tess.mesh.vHead;
  for (v = vHead.next; v !== vHead; v = v.next) {
    for (var i = 0; i < 3; ++i) {
      var c = v.coords[i];
      if (c < minVal[i]) { minVal[i] = c; minVert[i] = v; }
      if (c > maxVal[i]) { maxVal[i] = c; maxVert[i] = v; }
    }
  }

  // Find two vertices separated by at least 1/sqrt(3) of the maximum
  // distance between any two vertices
  var index = 0;
  if (maxVal[1] - minVal[1] > maxVal[0] - minVal[0]) { index = 1; }
  if (maxVal[2] - minVal[2] > maxVal[index] - minVal[index]) { index = 2; }
  if (minVal[index] >= maxVal[index]) {
    // All vertices are the same -- normal doesn't matter
    norm[0] = 0; norm[1] = 0; norm[2] = 1;
    return;
  }

  // Look for a third vertex which forms the triangle with maximum area
  // (Length of normal == twice the triangle area)
  var maxLen2 = 0;
  var v1 = minVert[index];
  var v2 = maxVert[index];
  var tNorm = [0, 0, 0];
  var d1 = [
    v1.coords[0] - v2.coords[0],
    v1.coords[1] - v2.coords[1],
    v1.coords[2] - v2.coords[2]
  ];
  var d2 = [0, 0, 0];
  for (v = vHead.next; v !== vHead; v = v.next) {
    d2[0] = v.coords[0] - v2.coords[0];
    d2[1] = v.coords[1] - v2.coords[1];
    d2[2] = v.coords[2] - v2.coords[2];
    tNorm[0] = d1[1] * d2[2] - d1[2] * d2[1];
    tNorm[1] = d1[2] * d2[0] - d1[0] * d2[2];
    tNorm[2] = d1[0] * d2[1] - d1[1] * d2[0];
    var tLen2 = tNorm[0] * tNorm[0] + tNorm[1] * tNorm[1] + tNorm[2] * tNorm[2];
    if (tLen2 > maxLen2) {
      maxLen2 = tLen2;
      norm[0] = tNorm[0];
      norm[1] = tNorm[1];
      norm[2] = tNorm[2];
    }
  }

  if (maxLen2 <= 0) {
    // All points lie on a single line -- any decent normal will do
    norm[0] = norm[1] = norm[2] = 0;
    norm[libtess.normal.longAxis_(d1)] = 1;
  }
};

/**
 * Check that the sum of the signed area of all projected contours is
 * non-negative. If not, negate the t-coordinates to reverse the orientation and
 * make it so.
 * @private
 * @param {!libtess.GluTesselator} tess
 */
libtess.normal.checkOrientation_ = function(tess) {
  var area = 0;
  var fHead = tess.mesh.fHead;
  for (var f = fHead.next; f !== fHead; f = f.next) {
    var e = f.anEdge;
    if (e.winding <= 0) { continue; }
    do {
      area += (e.org.s - e.dst().s) * (e.org.t + e.dst().t);
      e = e.lNext;
    } while (e !== f.anEdge);
  }

  if (area < 0) {
    // Reverse the orientation by flipping all the t-coordinates
    var vHead = tess.mesh.vHead;
    for (var v = vHead.next; v !== vHead; v = v.next) {
      v.t = -v.t;
    }
  }
};

/* global libtess */

/** @const */
libtess.render = {};

/**
 * Takes a mesh, breaks it into separate triangles, and renders them. The
 * rendering output is provided as callbacks (see the API). Set flagEdges to
 * true to get edgeFlag callbacks (tess.flagBoundary in original libtess).
 * @param {!libtess.GluTesselator} tess
 * @param {!libtess.GluMesh} mesh
 * @param {boolean} flagEdges
 */
libtess.render.renderMesh = function(tess, mesh, flagEdges) {
  var beginCallbackCalled = false;

  // TODO(bckenny): edgeState needs to be boolean, but !== on first call
  // force edge state output for first vertex
  var edgeState = -1;

  // We examine all faces in an arbitrary order. Whenever we find
  // an inside triangle f, we render f.
  // NOTE(bckenny): go backwards through face list to match original libtess
  // triangle order
  for (var f = mesh.fHead.prev; f !== mesh.fHead; f = f.prev) {
    if (f.inside) {
      // We're going to emit a triangle, so call begin callback once
      if (!beginCallbackCalled) {
        tess.callBeginCallback(libtess.primitiveType.GL_TRIANGLES);
        beginCallbackCalled = true;
      }

      // check that face has only three edges
      var e = f.anEdge;
      // Loop once for each edge (there will always be 3 edges)
      do {
        if (flagEdges) {
          // Set the "edge state" to true just before we output the
          // first vertex of each edge on the polygon boundary.
          var newState = !e.rFace().inside ? 1 : 0; // TODO(bckenny): total hack to get edgeState working. fix me.
          if (edgeState !== newState) {
            edgeState = newState;
            // TODO(bckenny): edgeState should be boolean now
            tess.callEdgeFlagCallback(!!edgeState);
          }
        }

        // emit vertex
        tess.callVertexCallback(e.org.data);

        e = e.lNext;
      } while (e !== f.anEdge);
    }
  }

  // only call end callback if begin was called
  if (beginCallbackCalled) {
    tess.callEndCallback();
  }
};

/**
 * Takes a mesh, and outputs one contour for each face marked "inside". The
 * rendering output is provided as callbacks (see the API).
 * @param {!libtess.GluTesselator} tess
 * @param {!libtess.GluMesh} mesh
 */
libtess.render.renderBoundary = function(tess, mesh) {
  for (var f = mesh.fHead.next; f !== mesh.fHead; f = f.next) {
    if (f.inside) {
      tess.callBeginCallback(libtess.primitiveType.GL_LINE_LOOP);

      var e = f.anEdge;
      do {
        tess.callVertexCallback(e.org.data);
        e = e.lNext;
      } while (e !== f.anEdge);

      tess.callEndCallback();
    }
  }
};

/* global libtess */

// TODO(bckenny): a number of these never return null (as opposed to original) and should be typed appropriately

/*
 * Invariants for the Edge Dictionary.
 * - each pair of adjacent edges e2=succ(e1) satisfies edgeLeq_(e1,e2)
 *   at any valid location of the sweep event
 * - if edgeLeq_(e2,e1) as well (at any valid sweep event), then e1 and e2
 *   share a common endpoint
 * - for each e, e.dst() has been processed, but not e.org
 * - each edge e satisfies vertLeq(e.dst(),event) && vertLeq(event,e.org)
 *   where "event" is the current sweep line event.
 * - no edge e has zero length
 *
 * Invariants for the Mesh (the processed portion).
 * - the portion of the mesh left of the sweep line is a planar graph,
 *   ie. there is *some* way to embed it in the plane
 * - no processed edge has zero length
 * - no two processed vertices have identical coordinates
 * - each "inside" region is monotone, ie. can be broken into two chains
 *   of monotonically increasing vertices according to VertLeq(v1,v2)
 *   - a non-invariant: these chains may intersect (very slightly)
 *
 * Invariants for the Sweep.
 * - if none of the edges incident to the event vertex have an activeRegion
 *   (ie. none of these edges are in the edge dictionary), then the vertex
 *   has only right-going edges.
 * - if an edge is marked "fixUpperEdge" (it is a temporary edge introduced
 *   by ConnectRightVertex), then it is the only right-going edge from
 *   its associated vertex.  (This says that these edges exist only
 *   when it is necessary.)
 */

/** @const */
libtess.sweep = {};


/**
 * Make the sentinel coordinates big enough that they will never be
 * merged with real input features.  (Even with the largest possible
 * input contour and the maximum tolerance of 1.0, no merging will be
 * done with coordinates larger than 3 * libtess.GLU_TESS_MAX_COORD).
 * @private
 * @const
 * @type {number}
 */
libtess.sweep.SENTINEL_COORD_ = 4 * libtess.GLU_TESS_MAX_COORD;


/**
 * Because vertices at exactly the same location are merged together
 * before we process the sweep event, some degenerate cases can't occur.
 * However if someone eventually makes the modifications required to
 * merge features which are close together, the cases below marked
 * TOLERANCE_NONZERO will be useful.  They were debugged before the
 * code to merge identical vertices in the main loop was added.
 * @private
 * @const
 * @type {boolean}
 */
libtess.sweep.TOLERANCE_NONZERO_ = false;


/**
 * computeInterior(tess) computes the planar arrangement specified
 * by the given contours, and further subdivides this arrangement
 * into regions. Each region is marked "inside" if it belongs
 * to the polygon, according to the rule given by tess.windingRule.
 * Each interior region is guaranteed be monotone.
 *
 * @param {libtess.GluTesselator} tess [description].
 */
libtess.sweep.computeInterior = function(tess) {
  tess.fatalError = false;

  // Each vertex defines an event for our sweep line. Start by inserting
  // all the vertices in a priority queue. Events are processed in
  // lexicographic order, ie.
  // e1 < e2  iff  e1.x < e2.x || (e1.x == e2.x && e1.y < e2.y)
  libtess.sweep.removeDegenerateEdges_(tess);
  libtess.sweep.initPriorityQ_(tess);
  libtess.sweep.initEdgeDict_(tess);

  var v;
  while ((v = tess.pq.extractMin()) !== null) {
    for (;;) {
      var vNext = tess.pq.minimum();
      if (vNext === null || !libtess.geom.vertEq(vNext, v)) {
        break;
      }

      /* Merge together all vertices at exactly the same location.
       * This is more efficient than processing them one at a time,
       * simplifies the code (see connectLeftDegenerate), and is also
       * important for correct handling of certain degenerate cases.
       * For example, suppose there are two identical edges A and B
       * that belong to different contours (so without this code they would
       * be processed by separate sweep events).  Suppose another edge C
       * crosses A and B from above.  When A is processed, we split it
       * at its intersection point with C.  However this also splits C,
       * so when we insert B we may compute a slightly different
       * intersection point.  This might leave two edges with a small
       * gap between them.  This kind of error is especially obvious
       * when using boundary extraction (GLU_TESS_BOUNDARY_ONLY).
       */
      vNext = tess.pq.extractMin();
      libtess.sweep.spliceMergeVertices_(tess, v.anEdge, vNext.anEdge);
    }
    libtess.sweep.sweepEvent_(tess, v);
  }

  // TODO(bckenny): what does the next comment mean? can we eliminate event except when debugging?
  // Set tess.event for debugging purposes
  var minRegion = tess.dict.getMin().getKey();
  tess.event = minRegion.eUp.org;
  libtess.sweep.doneEdgeDict_(tess);
  libtess.sweep.donePriorityQ_(tess);

  libtess.sweep.removeDegenerateFaces_(tess.mesh);
  tess.mesh.checkMesh();
};


/**
 * When we merge two edges into one, we need to compute the combined
 * winding of the new edge.
 * @private
 * @param {libtess.GluHalfEdge} eDst [description].
 * @param {libtess.GluHalfEdge} eSrc [description].
 */
libtess.sweep.addWinding_ = function(eDst, eSrc) {
  // NOTE(bckenny): from AddWinding macro
  eDst.winding += eSrc.winding;
  eDst.sym.winding += eSrc.sym.winding;
};


/**
 * Both edges must be directed from right to left (this is the canonical
 * direction for the upper edge of each region).
 *
 * The strategy is to evaluate a "t" value for each edge at the
 * current sweep line position, given by tess.event.  The calculations
 * are designed to be very stable, but of course they are not perfect.
 *
 * Special case: if both edge destinations are at the sweep event,
 * we sort the edges by slope (they would otherwise compare equally).
 *
 * @private
 * @param {!libtess.GluTesselator} tess
 * @param {!libtess.ActiveRegion} reg1
 * @param {!libtess.ActiveRegion} reg2
 * @return {boolean}
 */
libtess.sweep.edgeLeq_ = function(tess, reg1, reg2) {
  var event = tess.event;
  var e1 = reg1.eUp;
  var e2 = reg2.eUp;

  if (e1.dst() === event) {
    if (e2.dst() === event) {
      // Two edges right of the sweep line which meet at the sweep event.
      // Sort them by slope.
      if (libtess.geom.vertLeq(e1.org, e2.org)) {
        return libtess.geom.edgeSign(e2.dst(), e1.org, e2.org) <= 0;
      }

      return libtess.geom.edgeSign(e1.dst(), e2.org, e1.org) >= 0;
    }

    return libtess.geom.edgeSign(e2.dst(), event, e2.org) <= 0;
  }

  if (e2.dst() === event) {
    return libtess.geom.edgeSign(e1.dst(), event, e1.org) >= 0;
  }

  // General case - compute signed distance *from* e1, e2 to event
  var t1 = libtess.geom.edgeEval(e1.dst(), event, e1.org);
  var t2 = libtess.geom.edgeEval(e2.dst(), event, e2.org);
  return (t1 >= t2);
};


/**
 * [deleteRegion_ description]
 * @private
 * @param {libtess.GluTesselator} tess [description].
 * @param {libtess.ActiveRegion} reg [description].
 */
libtess.sweep.deleteRegion_ = function(tess, reg) {
  if (reg.fixUpperEdge) {
    // It was created with zero winding number, so it better be
    // deleted with zero winding number (ie. it better not get merged
    // with a real edge).
  }

  reg.eUp.activeRegion = null;

  tess.dict.deleteNode(reg.nodeUp);
  reg.nodeUp = null;

  // memFree( reg ); TODO(bckenny)
  // TODO(bckenny): may need to null at callsite
};


/**
 * Replace an upper edge which needs fixing (see connectRightVertex).
 * @private
 * @param {libtess.ActiveRegion} reg [description].
 * @param {libtess.GluHalfEdge} newEdge [description].
 */
libtess.sweep.fixUpperEdge_ = function(reg, newEdge) {
  libtess.mesh.deleteEdge(reg.eUp);

  reg.fixUpperEdge = false;
  reg.eUp = newEdge;
  newEdge.activeRegion = reg;
};


/**
 * Find the region above the uppermost edge with the same origin.
 * @private
 * @param {libtess.ActiveRegion} reg [description].
 * @return {libtess.ActiveRegion} [description].
 */
libtess.sweep.topLeftRegion_ = function(reg) {
  var org = reg.eUp.org;

  // Find the region above the uppermost edge with the same origin
  do {
    reg = reg.regionAbove();
  } while (reg.eUp.org === org);

  // If the edge above was a temporary edge introduced by connectRightVertex,
  // now is the time to fix it.
  if (reg.fixUpperEdge) {
    var e = libtess.mesh.connect(reg.regionBelow().eUp.sym, reg.eUp.lNext);
    libtess.sweep.fixUpperEdge_(reg, e);
    reg = reg.regionAbove();
  }

  return reg;
};


/**
 * Find the region above the uppermost edge with the same destination.
 * @private
 * @param {libtess.ActiveRegion} reg [description].
 * @return {libtess.ActiveRegion} [description].
 */
libtess.sweep.topRightRegion_ = function(reg) {
  var dst = reg.eUp.dst();

  do {
    reg = reg.regionAbove();
  } while (reg.eUp.dst() === dst);

  return reg;
};


/**
 * Add a new active region to the sweep line, *somewhere* below "regAbove"
 * (according to where the new edge belongs in the sweep-line dictionary).
 * The upper edge of the new region will be "eNewUp".
 * Winding number and "inside" flag are not updated.
 *
 * @private
 * @param {libtess.GluTesselator} tess [description].
 * @param {libtess.ActiveRegion} regAbove [description].
 * @param {libtess.GluHalfEdge} eNewUp [description].
 * @return {libtess.ActiveRegion} regNew.
 */
libtess.sweep.addRegionBelow_ = function(tess, regAbove, eNewUp) {
  var regNew = new libtess.ActiveRegion();

  regNew.eUp = eNewUp;
  regNew.nodeUp = tess.dict.insertBefore(regAbove.nodeUp, regNew);
  eNewUp.activeRegion = regNew;

  return regNew;
};


/**
 * [isWindingInside_ description]
 * @private
 * @param {libtess.GluTesselator} tess [description].
 * @param {number} n int.
 * @return {boolean} [description].
 */
libtess.sweep.isWindingInside_ = function(tess, n) {
  switch (tess.windingRule) {
    case libtess.windingRule.GLU_TESS_WINDING_ODD:
      return ((n & 1) !== 0);
    case libtess.windingRule.GLU_TESS_WINDING_NONZERO:
      return (n !== 0);
    case libtess.windingRule.GLU_TESS_WINDING_POSITIVE:
      return (n > 0);
    case libtess.windingRule.GLU_TESS_WINDING_NEGATIVE:
      return (n < 0);
    case libtess.windingRule.GLU_TESS_WINDING_ABS_GEQ_TWO:
      return (n >= 2) || (n <= -2);
  }

  // TODO(bckenny): not reached
  return false;
};


/**
 * [computeWinding_ description]
 * @private
 * @param {libtess.GluTesselator} tess [description].
 * @param {libtess.ActiveRegion} reg [description].
 */
libtess.sweep.computeWinding_ = function(tess, reg) {
  reg.windingNumber = reg.regionAbove().windingNumber + reg.eUp.winding;
  reg.inside = libtess.sweep.isWindingInside_(tess, reg.windingNumber);
};


/**
 * Delete a region from the sweep line. This happens when the upper
 * and lower chains of a region meet (at a vertex on the sweep line).
 * The "inside" flag is copied to the appropriate mesh face (we could
 * not do this before -- since the structure of the mesh is always
 * changing, this face may not have even existed until now).
 *
 * @private
 * @param {libtess.GluTesselator} tess [description].
 * @param {libtess.ActiveRegion} reg [description].
 */
libtess.sweep.finishRegion_ = function(tess, reg) {
  // TODO(bckenny): may need to null reg at callsite

  var e = reg.eUp;
  var f = e.lFace;

  f.inside = reg.inside;
  f.anEdge = e;   // optimization for tessmono.tessellateMonoRegion() // TODO(bckenny): how so?
  libtess.sweep.deleteRegion_(tess, reg);
};


/**
 * We are given a vertex with one or more left-going edges. All affected
 * edges should be in the edge dictionary. Starting at regFirst.eUp,
 * we walk down deleting all regions where both edges have the same
 * origin vOrg. At the same time we copy the "inside" flag from the
 * active region to the face, since at this point each face will belong
 * to at most one region (this was not necessarily true until this point
 * in the sweep). The walk stops at the region above regLast; if regLast
 * is null we walk as far as possible. At the same time we relink the
 * mesh if necessary, so that the ordering of edges around vOrg is the
 * same as in the dictionary.
 *
 * @private
 * @param {libtess.GluTesselator} tess [description].
 * @param {libtess.ActiveRegion} regFirst [description].
 * @param {libtess.ActiveRegion} regLast [description].
 * @return {libtess.GluHalfEdge} [description].
 */
libtess.sweep.finishLeftRegions_ = function(tess, regFirst, regLast) {
  var regPrev = regFirst;
  var ePrev = regFirst.eUp;
  while (regPrev !== regLast) {
    // placement was OK
    regPrev.fixUpperEdge = false;
    var reg = regPrev.regionBelow();
    var e = reg.eUp;
    if (e.org !== ePrev.org) {
      if (!reg.fixUpperEdge) {
        /* Remove the last left-going edge. Even though there are no further
         * edges in the dictionary with this origin, there may be further
         * such edges in the mesh (if we are adding left edges to a vertex
         * that has already been processed). Thus it is important to call
         * finishRegion rather than just deleteRegion.
         */
        libtess.sweep.finishRegion_(tess, regPrev);
        break;
      }

      // If the edge below was a temporary edge introduced by
      // connectRightVertex, now is the time to fix it.
      e = libtess.mesh.connect(ePrev.lPrev(), e.sym);
      libtess.sweep.fixUpperEdge_(reg, e);
    }

    // Relink edges so that ePrev.oNext === e
    if (ePrev.oNext !== e) {
      libtess.mesh.meshSplice(e.oPrev(), e);
      libtess.mesh.meshSplice(ePrev, e);
    }

    // may change reg.eUp
    libtess.sweep.finishRegion_(tess, regPrev);
    ePrev = reg.eUp;
    regPrev = reg;
  }

  return ePrev;
};


/**
 * Purpose: insert right-going edges into the edge dictionary, and update
 * winding numbers and mesh connectivity appropriately. All right-going
 * edges share a common origin vOrg. Edges are inserted CCW starting at
 * eFirst; the last edge inserted is eLast.oPrev. If vOrg has any
 * left-going edges already processed, then eTopLeft must be the edge
 * such that an imaginary upward vertical segment from vOrg would be
 * contained between eTopLeft.oPrev and eTopLeft; otherwise eTopLeft
 * should be null.
 *
 * @private
 * @param {libtess.GluTesselator} tess [description].
 * @param {libtess.ActiveRegion} regUp [description].
 * @param {libtess.GluHalfEdge} eFirst [description].
 * @param {libtess.GluHalfEdge} eLast [description].
 * @param {libtess.GluHalfEdge} eTopLeft [description].
 * @param {boolean} cleanUp [description].
 */
libtess.sweep.addRightEdges_ = function(tess, regUp, eFirst, eLast, eTopLeft,
    cleanUp) {

  var firstTime = true;

  // Insert the new right-going edges in the dictionary
  var e = eFirst;
  do {
    libtess.sweep.addRegionBelow_(tess, regUp, e.sym);
    e = e.oNext;
  } while (e !== eLast);

  // Walk *all* right-going edges from e.org, in the dictionary order,
  // updating the winding numbers of each region, and re-linking the mesh
  // edges to match the dictionary ordering (if necessary).
  if (eTopLeft === null) {
    eTopLeft = regUp.regionBelow().eUp.rPrev();
  }
  var regPrev = regUp;
  var ePrev = eTopLeft;
  var reg;
  for (;;) {
    reg = regPrev.regionBelow();
    e = reg.eUp.sym;
    if (e.org !== ePrev.org) {
      break;
    }

    if (e.oNext !== ePrev) {
      // Unlink e from its current position, and relink below ePrev
      libtess.mesh.meshSplice(e.oPrev(), e);
      libtess.mesh.meshSplice(ePrev.oPrev(), e);
    }
    // Compute the winding number and "inside" flag for the new regions
    reg.windingNumber = regPrev.windingNumber - e.winding;
    reg.inside = libtess.sweep.isWindingInside_(tess, reg.windingNumber);

    // Check for two outgoing edges with same slope -- process these
    // before any intersection tests (see example in libtess.sweep.computeInterior).
    regPrev.dirty = true;
    if (!firstTime && libtess.sweep.checkForRightSplice_(tess, regPrev)) {
      libtess.sweep.addWinding_(e, ePrev);
      libtess.sweep.deleteRegion_(tess, regPrev); // TODO(bckenny): need to null regPrev anywhere else?
      libtess.mesh.deleteEdge(ePrev);
    }
    firstTime = false;
    regPrev = reg;
    ePrev = e;
  }

  regPrev.dirty = true;

  if (cleanUp) {
    // Check for intersections between newly adjacent edges.
    libtess.sweep.walkDirtyRegions_(tess, regPrev);
  }
};


/**
 * Set up data for and call GLU_TESS_COMBINE callback on GluTesselator.
 * @private
 * @param {!libtess.GluTesselator} tess
 * @param {!libtess.GluVertex} isect A raw vertex at the intersection.
 * @param {!Array<Object>} data The vertices of the intersecting edges.
 * @param {!Array<number>} weights The linear combination coefficients for this intersection.
 * @param {boolean} needed Whether a returned vertex is necessary in this case.
 */
libtess.sweep.callCombine_ = function(tess, isect, data, weights, needed) {
  // Copy coord data in case the callback changes it.
  var coords = [
    isect.coords[0],
    isect.coords[1],
    isect.coords[2]
  ];

  isect.data = null;
  isect.data = tess.callCombineCallback(coords, data, weights);
  if (isect.data === null) {
    if (!needed) {
      // not needed, so just use data from first vertex
      isect.data = data[0];

    } else if (!tess.fatalError) {
      // The only way fatal error is when two edges are found to intersect,
      // but the user has not provided the callback necessary to handle
      // generated intersection points.
      tess.callErrorCallback(libtess.errorType.GLU_TESS_NEED_COMBINE_CALLBACK);
      tess.fatalError = true;
    }
  }
};


/**
 * Two vertices with idential coordinates are combined into one.
 * e1.org is kept, while e2.org is discarded.
 * @private
 * @param {!libtess.GluTesselator} tess
 * @param {libtess.GluHalfEdge} e1 [description].
 * @param {libtess.GluHalfEdge} e2 [description].
 */
libtess.sweep.spliceMergeVertices_ = function(tess, e1, e2) {
  // TODO(bckenny): better way to init these? save them?
  var data = [null, null, null, null];
  var weights = [0.5, 0.5, 0, 0];

  data[0] = e1.org.data;
  data[1] = e2.org.data;
  libtess.sweep.callCombine_(tess, e1.org, data, weights, false);
  libtess.mesh.meshSplice(e1, e2);
};


/**
 * Find some weights which describe how the intersection vertex is
 * a linear combination of org and dst. Each of the two edges
 * which generated "isect" is allocated 50% of the weight; each edge
 * splits the weight between its org and dst according to the
 * relative distance to "isect".
 *
 * @private
 * @param {libtess.GluVertex} isect [description].
 * @param {libtess.GluVertex} org [description].
 * @param {libtess.GluVertex} dst [description].
 * @param {Array.<number>} weights [description].
 * @param {number} weightIndex Index into weights for first weight to supply.
 */
libtess.sweep.vertexWeights_ = function(isect, org, dst, weights, weightIndex) {
  // TODO(bckenny): think through how we can use L1dist here and be correct for coords
  var t1 = libtess.geom.vertL1dist(org, isect);
  var t2 = libtess.geom.vertL1dist(dst, isect);

  // TODO(bckenny): introduced weightIndex to mimic addressing in original
  // 1) document (though it is private and only used from getIntersectData)
  // 2) better way? manually inline into getIntersectData? supply two two-length tmp arrays?
  var i0 = weightIndex;
  var i1 = weightIndex + 1;
  weights[i0] = 0.5 * t2 / (t1 + t2);
  weights[i1] = 0.5 * t1 / (t1 + t2);
  isect.coords[0] += weights[i0] * org.coords[0] + weights[i1] * dst.coords[0];
  isect.coords[1] += weights[i0] * org.coords[1] + weights[i1] * dst.coords[1];
  isect.coords[2] += weights[i0] * org.coords[2] + weights[i1] * dst.coords[2];
};


/**
 * We've computed a new intersection point, now we need a "data" pointer
 * from the user so that we can refer to this new vertex in the
 * rendering callbacks.
 * @private
 * @param {!libtess.GluTesselator} tess
 * @param {libtess.GluVertex} isect [description].
 * @param {libtess.GluVertex} orgUp [description].
 * @param {libtess.GluVertex} dstUp [description].
 * @param {libtess.GluVertex} orgLo [description].
 * @param {libtess.GluVertex} dstLo [description].
 */
libtess.sweep.getIntersectData_ = function(tess, isect, orgUp, dstUp, orgLo,
    dstLo) {

  // TODO(bckenny): called for every intersection event, should these be from a pool?
  // TODO(bckenny): better way to init these?
  var weights = [0, 0, 0, 0];
  var data = [
    orgUp.data,
    dstUp.data,
    orgLo.data,
    dstLo.data
  ];

  // TODO(bckenny): it appears isect is a reappropriated vertex, so does need to be zeroed.
  // double check this.
  isect.coords[0] = isect.coords[1] = isect.coords[2] = 0;

  // TODO(bckenny): see note in libtess.sweep.vertexWeights_ for explanation of weightIndex. fix?
  libtess.sweep.vertexWeights_(isect, orgUp, dstUp, weights, 0);
  libtess.sweep.vertexWeights_(isect, orgLo, dstLo, weights, 2);

  libtess.sweep.callCombine_(tess, isect, data, weights, true);
};


/**
 * Check the upper and lower edge of regUp, to make sure that the
 * eUp.org is above eLo, or eLo.org is below eUp (depending on which
 * origin is leftmost).
 *
 * The main purpose is to splice right-going edges with the same
 * dest vertex and nearly identical slopes (ie. we can't distinguish
 * the slopes numerically). However the splicing can also help us
 * to recover from numerical errors. For example, suppose at one
 * point we checked eUp and eLo, and decided that eUp.org is barely
 * above eLo. Then later, we split eLo into two edges (eg. from
 * a splice operation like this one). This can change the result of
 * our test so that now eUp.org is incident to eLo, or barely below it.
 * We must correct this condition to maintain the dictionary invariants.
 *
 * One possibility is to check these edges for intersection again
 * (i.e. checkForIntersect). This is what we do if possible. However
 * checkForIntersect requires that tess.event lies between eUp and eLo,
 * so that it has something to fall back on when the intersection
 * calculation gives us an unusable answer. So, for those cases where
 * we can't check for intersection, this routine fixes the problem
 * by just splicing the offending vertex into the other edge.
 * This is a guaranteed solution, no matter how degenerate things get.
 * Basically this is a combinatorial solution to a numerical problem.
 *
 * @private
 * @param {libtess.GluTesselator} tess [description].
 * @param {libtess.ActiveRegion} regUp [description].
 * @return {boolean} [description].
 */
libtess.sweep.checkForRightSplice_ = function(tess, regUp) {
  // TODO(bckenny): fully learn how these two checks work

  var regLo = regUp.regionBelow();
  var eUp = regUp.eUp;
  var eLo = regLo.eUp;

  if (libtess.geom.vertLeq(eUp.org, eLo.org)) {
    if (libtess.geom.edgeSign(eLo.dst(), eUp.org, eLo.org) > 0) {
      return false;
    }

    // eUp.org appears to be below eLo
    if (!libtess.geom.vertEq(eUp.org, eLo.org)) {
      // Splice eUp.org into eLo
      libtess.mesh.splitEdge(eLo.sym);
      libtess.mesh.meshSplice(eUp, eLo.oPrev());
      regUp.dirty = regLo.dirty = true;

    } else if (eUp.org !== eLo.org) {
      // merge the two vertices, discarding eUp.org
      tess.pq.remove(eUp.org.pqHandle);
      libtess.sweep.spliceMergeVertices_(tess, eLo.oPrev(), eUp);
    }

  } else {
    if (libtess.geom.edgeSign(eUp.dst(), eLo.org, eUp.org) < 0) {
      return false;
    }

    // eLo.org appears to be above eUp, so splice eLo.org into eUp
    regUp.regionAbove().dirty = regUp.dirty = true;
    libtess.mesh.splitEdge(eUp.sym);
    libtess.mesh.meshSplice(eLo.oPrev(), eUp);
  }

  return true;
};


/**
 * Check the upper and lower edge of regUp to make sure that the
 * eUp.dst() is above eLo, or eLo.dst() is below eUp (depending on which
 * destination is rightmost).
 *
 * Theoretically, this should always be true. However, splitting an edge
 * into two pieces can change the results of previous tests. For example,
 * suppose at one point we checked eUp and eLo, and decided that eUp.dst()
 * is barely above eLo. Then later, we split eLo into two edges (eg. from
 * a splice operation like this one). This can change the result of
 * the test so that now eUp.dst() is incident to eLo, or barely below it.
 * We must correct this condition to maintain the dictionary invariants
 * (otherwise new edges might get inserted in the wrong place in the
 * dictionary, and bad stuff will happen).
 *
 * We fix the problem by just splicing the offending vertex into the
 * other edge.
 *
 * @private
 * @param {libtess.GluTesselator} tess description].
 * @param {libtess.ActiveRegion} regUp [description].
 * @return {boolean} [description].
 */
libtess.sweep.checkForLeftSplice_ = function(tess, regUp) {
  var regLo = regUp.regionBelow();
  var eUp = regUp.eUp;
  var eLo = regLo.eUp;
  var e;

  if (libtess.geom.vertLeq(eUp.dst(), eLo.dst())) {
    if (libtess.geom.edgeSign(eUp.dst(), eLo.dst(), eUp.org) < 0) {
      return false;
    }

    // eLo.dst() is above eUp, so splice eLo.dst() into eUp
    regUp.regionAbove().dirty = regUp.dirty = true;
    e = libtess.mesh.splitEdge(eUp);
    libtess.mesh.meshSplice(eLo.sym, e);
    e.lFace.inside = regUp.inside;

  } else {
    if (libtess.geom.edgeSign(eLo.dst(), eUp.dst(), eLo.org) > 0) {
      return false;
    }

    // eUp.dst() is below eLo, so splice eUp.dst() into eLo
    regUp.dirty = regLo.dirty = true;
    e = libtess.mesh.splitEdge(eLo);
    libtess.mesh.meshSplice(eUp.lNext, eLo.sym);
    e.rFace().inside = regUp.inside;
  }

  return true;
};


/**
 * Check the upper and lower edges of the given region to see if
 * they intersect. If so, create the intersection and add it
 * to the data structures.
 *
 * Returns true if adding the new intersection resulted in a recursive
 * call to addRightEdges_(); in this case all "dirty" regions have been
 * checked for intersections, and possibly regUp has been deleted.
 *
 * @private
 * @param {libtess.GluTesselator} tess [description].
 * @param {libtess.ActiveRegion} regUp [description].
 * @return {boolean} [description].
 */
libtess.sweep.checkForIntersect_ = function(tess, regUp) {
  var regLo = regUp.regionBelow();
  var eUp = regUp.eUp;
  var eLo = regLo.eUp;
  var orgUp = eUp.org;
  var orgLo = eLo.org;
  var dstUp = eUp.dst();
  var dstLo = eLo.dst();

  var isect = new libtess.GluVertex();

  if (orgUp === orgLo) {
    // right endpoints are the same
    return false;
  }

  var tMinUp = Math.min(orgUp.t, dstUp.t);
  var tMaxLo = Math.max(orgLo.t, dstLo.t);
  if (tMinUp > tMaxLo) {
    // t ranges do not overlap
    return false;
  }

  if (libtess.geom.vertLeq(orgUp, orgLo)) {
    if (libtess.geom.edgeSign(dstLo, orgUp, orgLo) > 0) {
      return false;
    }
  } else {
    if (libtess.geom.edgeSign(dstUp, orgLo, orgUp) < 0) {
      return false;
    }
  }

  // At this point the edges intersect, at least marginally
  libtess.geom.edgeIntersect(dstUp, orgUp, dstLo, orgLo, isect);

  // The following properties are guaranteed:

  if (libtess.geom.vertLeq(isect, tess.event)) {
    /* The intersection point lies slightly to the left of the sweep line,
     * so move it until it's slightly to the right of the sweep line.
     * (If we had perfect numerical precision, this would never happen
     * in the first place). The easiest and safest thing to do is
     * replace the intersection by tess.event.
     */
    isect.s = tess.event.s;
    isect.t = tess.event.t;
  }

  // TODO(bckenny): try to find test54.d
  /* Similarly, if the computed intersection lies to the right of the
   * rightmost origin (which should rarely happen), it can cause
   * unbelievable inefficiency on sufficiently degenerate inputs.
   * (If you have the test program, try running test54.d with the
   * "X zoom" option turned on).
   */
  var orgMin = libtess.geom.vertLeq(orgUp, orgLo) ? orgUp : orgLo;
  if (libtess.geom.vertLeq(orgMin, isect)) {
    isect.s = orgMin.s;
    isect.t = orgMin.t;
  }

  if (libtess.geom.vertEq(isect, orgUp) || libtess.geom.vertEq(isect, orgLo)) {
    // Easy case -- intersection at one of the right endpoints
    libtess.sweep.checkForRightSplice_(tess, regUp);
    return false;
  }

  // TODO(bckenny): clean this up; length is distracting
  if ((!libtess.geom.vertEq(dstUp, tess.event) &&
      libtess.geom.edgeSign(dstUp, tess.event, isect) >= 0) ||
      (!libtess.geom.vertEq(dstLo, tess.event) &&
      libtess.geom.edgeSign(dstLo, tess.event, isect) <= 0)) {

    /* Very unusual -- the new upper or lower edge would pass on the
     * wrong side of the sweep event, or through it. This can happen
     * due to very small numerical errors in the intersection calculation.
     */
    if (dstLo === tess.event) {
      // Splice dstLo into eUp, and process the new region(s)
      libtess.mesh.splitEdge(eUp.sym);
      libtess.mesh.meshSplice(eLo.sym, eUp);
      regUp = libtess.sweep.topLeftRegion_(regUp);
      eUp = regUp.regionBelow().eUp;
      libtess.sweep.finishLeftRegions_(tess, regUp.regionBelow(), regLo);
      libtess.sweep.addRightEdges_(tess, regUp, eUp.oPrev(), eUp, eUp, true);
      return true;
    }

    if (dstUp === tess.event) {
      // Splice dstUp into eLo, and process the new region(s)
      libtess.mesh.splitEdge(eLo.sym);
      libtess.mesh.meshSplice(eUp.lNext, eLo.oPrev());
      regLo = regUp;
      regUp = libtess.sweep.topRightRegion_(regUp);
      var e = regUp.regionBelow().eUp.rPrev();
      regLo.eUp = eLo.oPrev();
      eLo = libtess.sweep.finishLeftRegions_(tess, regLo, null);
      libtess.sweep.addRightEdges_(tess, regUp, eLo.oNext, eUp.rPrev(), e,
          true);
      return true;
    }

    /* Special case: called from connectRightVertex. If either
     * edge passes on the wrong side of tess.event, split it
     * (and wait for connectRightVertex to splice it appropriately).
     */
    if (libtess.geom.edgeSign(dstUp, tess.event, isect) >= 0) {
      regUp.regionAbove().dirty = regUp.dirty = true;
      libtess.mesh.splitEdge(eUp.sym);
      eUp.org.s = tess.event.s;
      eUp.org.t = tess.event.t;
    }

    if (libtess.geom.edgeSign(dstLo, tess.event, isect) <= 0) {
      regUp.dirty = regLo.dirty = true;
      libtess.mesh.splitEdge(eLo.sym);
      eLo.org.s = tess.event.s;
      eLo.org.t = tess.event.t;
    }

    // leave the rest for connectRightVertex
    return false;
  }

  /* General case -- split both edges, splice into new vertex.
   * When we do the splice operation, the order of the arguments is
   * arbitrary as far as correctness goes. However, when the operation
   * creates a new face, the work done is proportional to the size of
   * the new face. We expect the faces in the processed part of
   * the mesh (ie. eUp.lFace) to be smaller than the faces in the
   * unprocessed original contours (which will be eLo.oPrev.lFace).
   */
  libtess.mesh.splitEdge(eUp.sym);
  libtess.mesh.splitEdge(eLo.sym);
  libtess.mesh.meshSplice(eLo.oPrev(), eUp);
  eUp.org.s = isect.s;
  eUp.org.t = isect.t;
  eUp.org.pqHandle = tess.pq.insert(eUp.org);
  libtess.sweep.getIntersectData_(tess, eUp.org, orgUp, dstUp, orgLo, dstLo);
  regUp.regionAbove().dirty = regUp.dirty = regLo.dirty = true;

  return false;
};


/**
 * When the upper or lower edge of any region changes, the region is
 * marked "dirty". This routine walks through all the dirty regions
 * and makes sure that the dictionary invariants are satisfied
 * (see the comments at the beginning of this file). Of course,
 * new dirty regions can be created as we make changes to restore
 * the invariants.
 * @private
 * @param {libtess.GluTesselator} tess [description].
 * @param {libtess.ActiveRegion} regUp [description].
 */
libtess.sweep.walkDirtyRegions_ = function(tess, regUp) {
  var regLo = regUp.regionBelow();

  for (;;) {
    // Find the lowest dirty region (we walk from the bottom up).
    while (regLo.dirty) {
      regUp = regLo;
      regLo = regLo.regionBelow();
    }
    if (!regUp.dirty) {
      regLo = regUp;
      regUp = regUp.regionAbove();
      if (regUp === null || !regUp.dirty) {
        // We've walked all the dirty regions
        return;
      }
    }

    regUp.dirty = false;
    var eUp = regUp.eUp;
    var eLo = regLo.eUp;

    if (eUp.dst() !== eLo.dst()) {
      // Check that the edge ordering is obeyed at the dst vertices.
      if (libtess.sweep.checkForLeftSplice_(tess, regUp)) {
        // If the upper or lower edge was marked fixUpperEdge, then
        // we no longer need it (since these edges are needed only for
        // vertices which otherwise have no right-going edges).
        if (regLo.fixUpperEdge) {
          libtess.sweep.deleteRegion_(tess, regLo);
          libtess.mesh.deleteEdge(eLo);
          regLo = regUp.regionBelow();
          eLo = regLo.eUp;

        } else if (regUp.fixUpperEdge) {
          libtess.sweep.deleteRegion_(tess, regUp);
          libtess.mesh.deleteEdge(eUp);
          regUp = regLo.regionAbove();
          eUp = regUp.eUp;
        }
      }
    }

    if (eUp.org !== eLo.org) {
      if (eUp.dst() !== eLo.dst() && !regUp.fixUpperEdge &&
          !regLo.fixUpperEdge &&
          (eUp.dst() === tess.event || eLo.dst() === tess.event)) {
        /* When all else fails in checkForIntersect(), it uses tess.event
         * as the intersection location. To make this possible, it requires
         * that tess.event lie between the upper and lower edges, and also
         * that neither of these is marked fixUpperEdge (since in the worst
         * case it might splice one of these edges into tess.event, and
         * violate the invariant that fixable edges are the only right-going
         * edge from their associated vertex).
         */
        if (libtess.sweep.checkForIntersect_(tess, regUp)) {
          // walkDirtyRegions() was called recursively; we're done
          return;
        }

      } else {
        // Even though we can't use checkForIntersect(), the org vertices
        // may violate the dictionary edge ordering. Check and correct this.
        libtess.sweep.checkForRightSplice_(tess, regUp);
      }
    }

    if (eUp.org === eLo.org && eUp.dst() === eLo.dst()) {
      // A degenerate loop consisting of only two edges -- delete it.
      libtess.sweep.addWinding_(eLo, eUp);
      libtess.sweep.deleteRegion_(tess, regUp);
      libtess.mesh.deleteEdge(eUp);
      regUp = regLo.regionAbove();
    }
  }
};


/**
 * Purpose: connect a "right" vertex vEvent (one where all edges go left)
 * to the unprocessed portion of the mesh. Since there are no right-going
 * edges, two regions (one above vEvent and one below) are being merged
 * into one. regUp is the upper of these two regions.
 *
 * There are two reasons for doing this (adding a right-going edge):
 *  - if the two regions being merged are "inside", we must add an edge
 *    to keep them separated (the combined region would not be monotone).
 *  - in any case, we must leave some record of vEvent in the dictionary,
 *    so that we can merge vEvent with features that we have not seen yet.
 *    For example, maybe there is a vertical edge which passes just to
 *    the right of vEvent; we would like to splice vEvent into this edge.
 *
 * However, we don't want to connect vEvent to just any vertex. We don't
 * want the new edge to cross any other edges; otherwise we will create
 * intersection vertices even when the input data had no self-intersections.
 * (This is a bad thing; if the user's input data has no intersections,
 * we don't want to generate any false intersections ourselves.)
 *
 * Our eventual goal is to connect vEvent to the leftmost unprocessed
 * vertex of the combined region (the union of regUp and regLo).
 * But because of unseen vertices with all right-going edges, and also
 * new vertices which may be created by edge intersections, we don't
 * know where that leftmost unprocessed vertex is. In the meantime, we
 * connect vEvent to the closest vertex of either chain, and mark the region
 * as "fixUpperEdge". This flag says to delete and reconnect this edge
 * to the next processed vertex on the boundary of the combined region.
 * Quite possibly the vertex we connected to will turn out to be the
 * closest one, in which case we won't need to make any changes.
 *
 * @private
 * @param {libtess.GluTesselator} tess [description].
 * @param {libtess.ActiveRegion} regUp [description].
 * @param {libtess.GluHalfEdge} eBottomLeft [description].
 */
libtess.sweep.connectRightVertex_ = function(tess, regUp, eBottomLeft) {
  var eTopLeft = eBottomLeft.oNext;
  var regLo = regUp.regionBelow();
  var eUp = regUp.eUp;
  var eLo = regLo.eUp;
  var degenerate = false;

  if (eUp.dst() !== eLo.dst()) {
    libtess.sweep.checkForIntersect_(tess, regUp);
  }

  // Possible new degeneracies: upper or lower edge of regUp may pass
  // through vEvent, or may coincide with new intersection vertex
  if (libtess.geom.vertEq(eUp.org, tess.event)) {
    libtess.mesh.meshSplice(eTopLeft.oPrev(), eUp);
    regUp = libtess.sweep.topLeftRegion_(regUp);
    eTopLeft = regUp.regionBelow().eUp;
    libtess.sweep.finishLeftRegions_(tess, regUp.regionBelow(), regLo);
    degenerate = true;
  }
  if (libtess.geom.vertEq(eLo.org, tess.event)) {
    libtess.mesh.meshSplice(eBottomLeft, eLo.oPrev());
    eBottomLeft = libtess.sweep.finishLeftRegions_(tess, regLo, null);
    degenerate = true;
  }
  if (degenerate) {
    libtess.sweep.addRightEdges_(tess, regUp, eBottomLeft.oNext, eTopLeft,
        eTopLeft, true);
    return;
  }

  // Non-degenerate situation -- need to add a temporary, fixable edge.
  // Connect to the closer of eLo.org, eUp.org.
  var eNew;
  if (libtess.geom.vertLeq(eLo.org, eUp.org)) {
    eNew = eLo.oPrev();
  } else {
    eNew = eUp;
  }
  eNew = libtess.mesh.connect(eBottomLeft.lPrev(), eNew);

  // Prevent cleanup, otherwise eNew might disappear before we've even
  // had a chance to mark it as a temporary edge.
  libtess.sweep.addRightEdges_(tess, regUp, eNew, eNew.oNext, eNew.oNext,
      false);
  eNew.sym.activeRegion.fixUpperEdge = true;
  libtess.sweep.walkDirtyRegions_(tess, regUp);
};


/**
 * The event vertex lies exacty on an already-processed edge or vertex.
 * Adding the new vertex involves splicing it into the already-processed
 * part of the mesh.
 * @private
 * @param {!libtess.GluTesselator} tess
 * @param {libtess.ActiveRegion} regUp [description].
 * @param {libtess.GluVertex} vEvent [description].
 */
libtess.sweep.connectLeftDegenerate_ = function(tess, regUp, vEvent) {
  var e = regUp.eUp;
  /* istanbul ignore if */
  if (libtess.geom.vertEq(e.org, vEvent)) {
    // NOTE(bckenny): this code is unreachable but remains for a hypothetical
    // future extension of libtess. See docs on libtess.sweep.TOLERANCE_NONZERO_
    // for more information. Conditional on TOLERANCE_NONZERO_ to help Closure
    // Compiler eliminate dead code.
    // e.org is an unprocessed vertex - just combine them, and wait
    // for e.org to be pulled from the queue
    if (libtess.sweep.TOLERANCE_NONZERO_) {
      libtess.sweep.spliceMergeVertices_(tess, e, vEvent.anEdge);
    }
    return;
  }

  if (!libtess.geom.vertEq(e.dst(), vEvent)) {
    // General case -- splice vEvent into edge e which passes through it
    libtess.mesh.splitEdge(e.sym);

    if (regUp.fixUpperEdge) {
      // This edge was fixable -- delete unused portion of original edge
      libtess.mesh.deleteEdge(e.oNext);
      regUp.fixUpperEdge = false;
    }

    libtess.mesh.meshSplice(vEvent.anEdge, e);

    // recurse
    libtess.sweep.sweepEvent_(tess, vEvent);
    return;
  }

  // NOTE(bckenny): this code is unreachable but remains for a hypothetical
  // future extension of libtess. See docs on libtess.sweep.TOLERANCE_NONZERO_
  // for more information. Conditional on TOLERANCE_NONZERO_ to help Closure
  // Compiler eliminate dead code.
  // vEvent coincides with e.dst(), which has already been processed.
  // Splice in the additional right-going edges.
  /* istanbul ignore next */

  /* istanbul ignore next */
  if (libtess.sweep.TOLERANCE_NONZERO_) {
    regUp = libtess.sweep.topRightRegion_(regUp);
    var reg = regUp.regionBelow();
    var eTopRight = reg.eUp.sym;
    var eTopLeft = eTopRight.oNext;
    var eLast = eTopLeft;

    if (reg.fixUpperEdge) {
      // Here e.dst() has only a single fixable edge going right.
      // We can delete it since now we have some real right-going edges.

      // there are some left edges too
      libtess.sweep.deleteRegion_(tess, reg); // TODO(bckenny): something to null?
      libtess.mesh.deleteEdge(eTopRight);
      eTopRight = eTopLeft.oPrev();
    }

    libtess.mesh.meshSplice(vEvent.anEdge, eTopRight);
    if (!libtess.geom.edgeGoesLeft(eTopLeft)) {
      // e.dst() had no left-going edges -- indicate this to addRightEdges()
      eTopLeft = null;
    }

    libtess.sweep.addRightEdges_(tess, regUp, eTopRight.oNext, eLast, eTopLeft,
        true);
  }
};


/**
 * Connect a "left" vertex (one where both edges go right)
 * to the processed portion of the mesh. Let R be the active region
 * containing vEvent, and let U and L be the upper and lower edge
 * chains of R. There are two possibilities:
 *
 * - the normal case: split R into two regions, by connecting vEvent to
 *   the rightmost vertex of U or L lying to the left of the sweep line
 *
 * - the degenerate case: if vEvent is close enough to U or L, we
 *   merge vEvent into that edge chain. The subcases are:
 *  - merging with the rightmost vertex of U or L
 *  - merging with the active edge of U or L
 *  - merging with an already-processed portion of U or L
 *
 * @private
 * @param {libtess.GluTesselator} tess   [description].
 * @param {libtess.GluVertex} vEvent [description].
 */
libtess.sweep.connectLeftVertex_ = function(tess, vEvent) {
  // TODO(bckenny): tmp only used for sweep. better to keep tmp across calls?
  var tmp = new libtess.ActiveRegion();

  // NOTE(bckenny): this was commented out in the original
  // libtess.assert(vEvent.anEdge.oNext.oNext === vEvent.anEdge);

  // Get a pointer to the active region containing vEvent
  tmp.eUp = vEvent.anEdge.sym;
  var regUp = tess.dict.search(tmp).getKey();
  var regLo = regUp.regionBelow();
  var eUp = regUp.eUp;
  var eLo = regLo.eUp;

  // try merging with U or L first
  if (libtess.geom.edgeSign(eUp.dst(), vEvent, eUp.org) === 0) {
    libtess.sweep.connectLeftDegenerate_(tess, regUp, vEvent);
    return;
  }

  // Connect vEvent to rightmost processed vertex of either chain.
  // e.dst() is the vertex that we will connect to vEvent.
  var reg = libtess.geom.vertLeq(eLo.dst(), eUp.dst()) ? regUp : regLo;
  var eNew;
  if (regUp.inside || reg.fixUpperEdge) {
    if (reg === regUp) {
      eNew = libtess.mesh.connect(vEvent.anEdge.sym, eUp.lNext);

    } else {
      var tempHalfEdge = libtess.mesh.connect(eLo.dNext(), vEvent.anEdge);
      eNew = tempHalfEdge.sym;
    }

    if (reg.fixUpperEdge) {
      libtess.sweep.fixUpperEdge_(reg, eNew);

    } else {
      libtess.sweep.computeWinding_(tess,
          libtess.sweep.addRegionBelow_(tess, regUp, eNew));
    }
    libtess.sweep.sweepEvent_(tess, vEvent);

  } else {
    // The new vertex is in a region which does not belong to the polygon.
    // We don''t need to connect this vertex to the rest of the mesh.
    libtess.sweep.addRightEdges_(tess, regUp, vEvent.anEdge, vEvent.anEdge,
        null, true);
  }
};


/**
 * Does everything necessary when the sweep line crosses a vertex.
 * Updates the mesh and the edge dictionary.
 * @private
 * @param {libtess.GluTesselator} tess [description].
 * @param {libtess.GluVertex} vEvent [description].
 */
libtess.sweep.sweepEvent_ = function(tess, vEvent) {
  tess.event = vEvent; // for access in edgeLeq_ // TODO(bckenny): wuh?

  /* Check if this vertex is the right endpoint of an edge that is
   * already in the dictionary.  In this case we don't need to waste
   * time searching for the location to insert new edges.
   */
  var e = vEvent.anEdge;
  while (e.activeRegion === null) {
    e = e.oNext;
    if (e === vEvent.anEdge) {
      // All edges go right -- not incident to any processed edges
      libtess.sweep.connectLeftVertex_(tess, vEvent);
      return;
    }
  }

  /* Processing consists of two phases: first we "finish" all the
   * active regions where both the upper and lower edges terminate
   * at vEvent (ie. vEvent is closing off these regions).
   * We mark these faces "inside" or "outside" the polygon according
   * to their winding number, and delete the edges from the dictionary.
   * This takes care of all the left-going edges from vEvent.
   */
  var regUp = libtess.sweep.topLeftRegion_(e.activeRegion);
  var reg = regUp.regionBelow();
  var eTopLeft = reg.eUp;
  var eBottomLeft = libtess.sweep.finishLeftRegions_(tess, reg, null);

  /* Next we process all the right-going edges from vEvent. This
   * involves adding the edges to the dictionary, and creating the
   * associated "active regions" which record information about the
   * regions between adjacent dictionary edges.
   */
  if (eBottomLeft.oNext === eTopLeft) {
    // No right-going edges -- add a temporary "fixable" edge
    libtess.sweep.connectRightVertex_(tess, regUp, eBottomLeft);

  } else {
    libtess.sweep.addRightEdges_(tess, regUp, eBottomLeft.oNext, eTopLeft,
        eTopLeft, true);
  }
};


/**
 * We add two sentinel edges above and below all other edges,
 * to avoid special cases at the top and bottom.
 * @private
 * @param {libtess.GluTesselator} tess [description].
 * @param {number} t [description].
 */
libtess.sweep.addSentinel_ = function(tess, t) {
  var reg = new libtess.ActiveRegion();

  var e = libtess.mesh.makeEdge(tess.mesh);

  e.org.s = libtess.sweep.SENTINEL_COORD_;
  e.org.t = t;
  e.dst().s = -libtess.sweep.SENTINEL_COORD_;
  e.dst().t = t;
  tess.event = e.dst(); //initialize it

  reg.eUp = e;
  reg.windingNumber = 0;
  reg.inside = false;
  reg.fixUpperEdge = false;
  reg.sentinel = true;
  reg.dirty = false;
  reg.nodeUp = tess.dict.insert(reg);
};


/**
 * We maintain an ordering of edge intersections with the sweep line.
 * This order is maintained in a dynamic dictionary.
 * @private
 * @param {libtess.GluTesselator} tess [description].
 */
libtess.sweep.initEdgeDict_ = function(tess) {
  tess.dict = new libtess.Dict(tess, libtess.sweep.edgeLeq_);

  libtess.sweep.addSentinel_(tess, -libtess.sweep.SENTINEL_COORD_);
  libtess.sweep.addSentinel_(tess, libtess.sweep.SENTINEL_COORD_);
};


/**
 * [doneEdgeDict_ description]
 * @private
 * @param {libtess.GluTesselator} tess [description].
 */
libtess.sweep.doneEdgeDict_ = function(tess) {
  // NOTE(bckenny): fixedEdges is only used in the assert below, so ignore so
  // when asserts are removed jshint won't error.
  /* jshint unused:false */
  var fixedEdges = 0;

  var reg;
  while ((reg = tess.dict.getMin().getKey()) !== null) {
    // At the end of all processing, the dictionary should contain
    // only the two sentinel edges, plus at most one "fixable" edge
    // created by connectRightVertex().
    if (!reg.sentinel) {
    }
    libtess.sweep.deleteRegion_(tess, reg);
  }

  // NOTE(bckenny): see tess.dict.deleteDict_() for old delete dict function
  tess.dict = null;
};


/**
 * Remove zero-length edges, and contours with fewer than 3 vertices.
 * @private
 * @param {libtess.GluTesselator} tess [description].
 */
libtess.sweep.removeDegenerateEdges_ = function(tess) {
  var eHead = tess.mesh.eHead;

  var eNext;
  for (var e = eHead.next; e !== eHead; e = eNext) {
    eNext = e.next;
    var eLNext = e.lNext;

    if (libtess.geom.vertEq(e.org, e.dst()) && e.lNext.lNext !== e) {
      // Zero-length edge, contour has at least 3 edges
      libtess.sweep.spliceMergeVertices_(tess, eLNext, e); // deletes e.org
      libtess.mesh.deleteEdge(e); // e is a self-loop TODO(bckenny): does this comment really apply here?
      e = eLNext;
      eLNext = e.lNext;
    }

    if (eLNext.lNext === e) {
      // Degenerate contour (one or two edges)
      if (eLNext !== e) {
        if (eLNext === eNext || eLNext === eNext.sym) {
          eNext = eNext.next;
        }
        libtess.mesh.deleteEdge(eLNext);
      }

      if (e === eNext || e === eNext.sym) {
        eNext = eNext.next;
      }
      libtess.mesh.deleteEdge(e);
    }
  }
};


/**
 * Construct priority queue and insert all vertices into it, which determines
 * the order in which vertices cross the sweep line.
 * @private
 * @param {libtess.GluTesselator} tess [description].
 */
libtess.sweep.initPriorityQ_ = function(tess) {
  var pq = new libtess.PriorityQ();
  tess.pq = pq;

  var vHead = tess.mesh.vHead;
  var v;
  for (v = vHead.next; v !== vHead; v = v.next) {
    v.pqHandle = pq.insert(v);
  }

  pq.init();
};


/**
 * [donePriorityQ_ description]
 * @private
 * @param {libtess.GluTesselator} tess [description].
 */
libtess.sweep.donePriorityQ_ = function(tess) {
  // TODO(bckenny): probably don't need deleteQ. check that function for comment
  tess.pq.deleteQ();
  tess.pq = null;
};


/**
 * Delete any degenerate faces with only two edges. walkDirtyRegions()
 * will catch almost all of these, but it won't catch degenerate faces
 * produced by splice operations on already-processed edges.
 * The two places this can happen are in finishLeftRegions(), when
 * we splice in a "temporary" edge produced by connectRightVertex(),
 * and in checkForLeftSplice(), where we splice already-processed
 * edges to ensure that our dictionary invariants are not violated
 * by numerical errors.
 *
 * In both these cases it is *very* dangerous to delete the offending
 * edge at the time, since one of the routines further up the stack
 * will sometimes be keeping a pointer to that edge.
 *
 * @private
 * @param {libtess.GluMesh} mesh [description].
 */
libtess.sweep.removeDegenerateFaces_ = function(mesh) {
  var fNext;
  for (var f = mesh.fHead.next; f !== mesh.fHead; f = fNext) {
    fNext = f.next;
    var e = f.anEdge;

    if (e.lNext.lNext === e) {
      // A face with only two edges
      libtess.sweep.addWinding_(e.oNext, e);
      libtess.mesh.deleteEdge(e);
    }
  }
};

/* global libtess */

/** @const */
libtess.tessmono = {};

/**
 * Tessellates a monotone region (what else would it do??). The region must
 * consist of a single loop of half-edges (see mesh.js) oriented CCW. "Monotone"
 * in this case means that any vertical line intersects the interior of the
 * region in a single interval.
 *
 * Tessellation consists of adding interior edges (actually pairs of
 * half-edges), to split the region into non-overlapping triangles.
 * @private
 * @param {!libtess.GluFace} face
 */
libtess.tessmono.tessellateMonoRegion_ = function(face) {
  /* The basic idea is explained in Preparata and Shamos (which I don't
   * have handy right now), although their implementation is more
   * complicated than this one. The are two edge chains, an upper chain
   * and a lower chain. We process all vertices from both chains in order,
   * from right to left.
   *
   * The algorithm ensures that the following invariant holds after each
   * vertex is processed: the untessellated region consists of two
   * chains, where one chain (say the upper) is a single edge, and
   * the other chain is concave. The left vertex of the single edge
   * is always to the left of all vertices in the concave chain.
   *
   * Each step consists of adding the rightmost unprocessed vertex to one
   * of the two chains, and forming a fan of triangles from the rightmost
   * of two chain endpoints. Determining whether we can add each triangle
   * to the fan is a simple orientation test. By making the fan as large
   * as possible, we restore the invariant (check it yourself).
   *
   * All edges are oriented CCW around the boundary of the region.
   * First, find the half-edge whose origin vertex is rightmost.
   * Since the sweep goes from left to right, face.anEdge should
   * be close to the edge we want.
   */
  var up = face.anEdge;

  for (; libtess.geom.vertLeq(up.dst(), up.org); up = up.lPrev()) { }
  for (; libtess.geom.vertLeq(up.org, up.dst()); up = up.lNext) { }

  var lo = up.lPrev();

  var tempHalfEdge;
  while (up.lNext !== lo) {
    if (libtess.geom.vertLeq(up.dst(), lo.org)) {
      // up.dst() is on the left. It is safe to form triangles from lo.org.
      // The edgeGoesLeft test guarantees progress even when some triangles
      // are CW, given that the upper and lower chains are truly monotone.
      while (lo.lNext !== up && (libtess.geom.edgeGoesLeft(lo.lNext) ||
          libtess.geom.edgeSign(lo.org, lo.dst(), lo.lNext.dst()) <= 0)) {

        tempHalfEdge = libtess.mesh.connect(lo.lNext, lo);
        lo = tempHalfEdge.sym;
      }
      lo = lo.lPrev();

    } else {
      // lo.org is on the left. We can make CCW triangles from up.dst().
      while (lo.lNext !== up && (libtess.geom.edgeGoesRight(up.lPrev()) ||
          libtess.geom.edgeSign(up.dst(), up.org, up.lPrev().org) >= 0)) {

        tempHalfEdge = libtess.mesh.connect(up, up.lPrev());
        up = tempHalfEdge.sym;
      }
      up = up.lNext;
    }
  }

  // Now lo.org == up.dst() == the leftmost vertex. The remaining region
  // can be tessellated in a fan from this leftmost vertex.
  while (lo.lNext.lNext !== up) {
    tempHalfEdge = libtess.mesh.connect(lo.lNext, lo);
    lo = tempHalfEdge.sym;
  }
};

/**
 * Tessellates each region of the mesh which is marked "inside" the polygon.
 * Each such region must be monotone.
 * @param {!libtess.GluMesh} mesh
 */
libtess.tessmono.tessellateInterior = function(mesh) {
  var next;
  for (var f = mesh.fHead.next; f !== mesh.fHead; f = next) {
    // Make sure we don't try to tessellate the new triangles.
    next = f.next;
    if (f.inside) {
      libtess.tessmono.tessellateMonoRegion_(f);
    }
  }
};

/**
 * Zaps (i.e. sets to null) all faces which are not marked "inside" the polygon.
 * Since further mesh operations on null faces are not allowed, the main purpose
 * is to clean up the mesh so that exterior loops are not represented in the
 * data structure.
 * @param {!libtess.GluMesh} mesh
 */
libtess.tessmono.discardExterior = function(mesh) {
  var next;
  for (var f = mesh.fHead.next; f !== mesh.fHead; f = next) {
    // Since f will be destroyed, save its next pointer.
    next = f.next;
    if (!f.inside) {
      libtess.mesh.zapFace(f);
    }
  }
};

/**
 * Resets the winding numbers on all edges so that regions marked "inside" the
 * polygon have a winding number of "value", and regions outside have a winding
 * number of 0.
 *
 * If keepOnlyBoundary is true, it also deletes all edges which do not separate
 * an interior region from an exterior one.
 *
 * @param {!libtess.GluMesh} mesh
 * @param {number} value
 * @param {boolean} keepOnlyBoundary
 */
libtess.tessmono.setWindingNumber = function(mesh, value, keepOnlyBoundary) {
  var eNext;
  for (var e = mesh.eHead.next; e !== mesh.eHead; e = eNext) {
    eNext = e.next;

    if (e.rFace().inside !== e.lFace.inside) {
      // This is a boundary edge (one side is interior, one is exterior).
      e.winding = (e.lFace.inside) ? value : -value;

    } else {
      // Both regions are interior, or both are exterior.
      if (!keepOnlyBoundary) {
        e.winding = 0;

      } else {
        libtess.mesh.deleteEdge(e);
      }
    }
  }
};

/* global libtess */

/**
 * A list of edges crossing the sweep line, sorted from top to bottom.
 * Implementation is a doubly-linked list, sorted by the injected edgeLeq
 * comparator function. Here it is a simple ordering, but see libtess.sweep for
 * the list of invariants on the edge dictionary this ordering creates.
 * @constructor
 * @struct
 * @param {!libtess.GluTesselator} frame
 * @param {function(!libtess.GluTesselator, !libtess.ActiveRegion, !libtess.ActiveRegion): boolean} leq
 */
libtess.Dict = function(frame, leq) {

  /**
   * The head of the doubly-linked DictNode list. At creation time, links back
   * and forward only to itself.
   * @private {!libtess.DictNode}
   */
  this.head_ = new libtess.DictNode();

  /**
   * The GluTesselator used as the frame for edge/event comparisons.
   * @private {!libtess.GluTesselator}
   */
  this.frame_ = frame;

  /**
   * Comparison function to maintain the invariants of the Dict. See
   * libtess.sweep.edgeLeq_ for source.
   * @private
   * @type {function(!libtess.GluTesselator, !libtess.ActiveRegion, !libtess.ActiveRegion): boolean}
   */
  this.leq_ = leq;
};

/* istanbul ignore next */
/**
 * Formerly used to delete the dict.
 * NOTE(bckenny): No longer called but left for memFree documentation. Nulled at
 * former callsite instead (sweep.doneEdgeDict_)
 * @private
 */
libtess.Dict.prototype.deleteDict_ = function() {
  // for (var node = this.head_.next; node !== this.head_; node = node.next) {
  //   memFree(node);
  // }
  // memFree(dict);
};

/**
 * Insert the supplied key into the edge list and return its new node.
 * @param {libtess.DictNode} node
 * @param {!libtess.ActiveRegion} key
 * @return {!libtess.DictNode}
 */
libtess.Dict.prototype.insertBefore = function(node, key) {
  do {
    node = node.prev;
  } while (node.key !== null && !this.leq_(this.frame_, node.key, key));

  // insert the new node and update the surrounding nodes to point to it
  var newNode = new libtess.DictNode(key, node.next, node);
  node.next.prev = newNode;
  node.next = newNode;

  return newNode;
};

/**
 * Insert key into the dict and return the new node that contains it.
 * @param {!libtess.ActiveRegion} key
 * @return {!libtess.DictNode}
 */
libtess.Dict.prototype.insert = function(key) {
  // NOTE(bckenny): from a macro in dict.h/dict-list.h
  return this.insertBefore(this.head_, key);
};

/**
 * Remove node from the list.
 * @param {libtess.DictNode} node
 */
libtess.Dict.prototype.deleteNode = function(node) {
  node.next.prev = node.prev;
  node.prev.next = node.next;

  // NOTE(bckenny): nulled at callsite (sweep.deleteRegion_)
  // memFree( node );
};

/**
 * Search returns the node with the smallest key greater than or equal
 * to the given key. If there is no such key, returns a node whose
 * key is null. Similarly, max(d).getSuccessor() has a null key, etc.
 * @param {!libtess.ActiveRegion} key
 * @return {!libtess.DictNode}
 */
libtess.Dict.prototype.search = function(key) {
  var node = this.head_;

  do {
    node = node.next;
  } while (node.key !== null && !this.leq_(this.frame_, key, node.key));

  return node;
};

/**
 * Return the node with the smallest key.
 * @return {!libtess.DictNode}
 */
libtess.Dict.prototype.getMin = function() {
  // NOTE(bckenny): from a macro in dict.h/dict-list.h
  return this.head_.next;
};

// NOTE(bckenny): libtess.Dict.getMax isn't called within libtess and isn't part
// of the public API. For now, leaving in but ignoring for coverage.
/* istanbul ignore next */
/**
 * Returns the node with the greatest key.
 * @return {!libtess.DictNode}
 */
libtess.Dict.prototype.getMax = function() {
  // NOTE(bckenny): from a macro in dict.h/dict-list.h
  return this.head_.prev;
};

/* global libtess */

/**
 * A doubly-linked-list node with a libtess.ActiveRegion payload.
 * The key for this node and the next and previous nodes in the parent Dict list
 * can be provided to insert it into an existing list (or all can be omitted if
 * this is to be the founding node of the list).
 * @param {!libtess.ActiveRegion=} opt_key
 * @param {!libtess.DictNode=} opt_nextNode
 * @param {!libtess.DictNode=} opt_prevNode
 * @constructor
 * @struct
 */
libtess.DictNode = function(opt_key, opt_nextNode, opt_prevNode) {
  /**
   * The ActiveRegion key for this node, or null if the head of the list.
   * @type {libtess.ActiveRegion}
   */
  this.key = opt_key || null;

  /**
   * Link to next DictNode in parent list or to self if this is the first node.
   * @type {!libtess.DictNode}
   */
  this.next = opt_nextNode || this;

  /**
   * Link to previous DictNode in parent list or to self if this is the first
   * node.
   * @type {!libtess.DictNode}
   */
  this.prev = opt_prevNode || this;
};

/**
 * Get the key from this node.
 * @return {libtess.ActiveRegion}
 */
libtess.DictNode.prototype.getKey = function() {
  return this.key;
};

/**
 * Get the successor node to this one.
 * @return {!libtess.DictNode}
 */
libtess.DictNode.prototype.getSuccessor = function() {
  return this.next;
};

/**
 * Get the predecessor node to this one.
 * @return {!libtess.DictNode}
 */
libtess.DictNode.prototype.getPredecessor = function() {
  return this.prev;
};

/* global libtess */

// TODO(bckenny): create more javascript-y API, e.g. make gluTessEndPolygon
// async, don't require so many temp objects created

/**
 * The tesselator main class, providing the public API.
 * @constructor
 * @struct
 */
libtess.GluTesselator = function() {
  // Only initialize fields which can be changed by the api. Other fields
  // are initialized where they are used.

  /*** state needed for collecting the input data ***/

  /**
   * Tesselator state, tracking what begin/end calls have been seen.
   * @private {libtess.GluTesselator.tessState_}
   */
  this.state_ = libtess.GluTesselator.tessState_.T_DORMANT;

  /**
   * lastEdge_.org is the most recent vertex
   * @private {libtess.GluHalfEdge}
   */
  this.lastEdge_ = null;

  /**
   * stores the input contours, and eventually the tessellation itself
   * @type {libtess.GluMesh}
   */
  this.mesh = null;

  /**
   * Error callback.
   * @private {?function((libtess.errorType|libtess.gluEnum), Object=)}
   */
  this.errorCallback_ = null;

  /*** state needed for projecting onto the sweep plane ***/

  /**
   * user-specified normal (if provided)
   * @private {!Array<number>}
   */
  this.normal_ = [0, 0, 0];

  /*** state needed for the line sweep ***/

  /**
   * rule for determining polygon interior
   * @type {libtess.windingRule}
   */
  this.windingRule = libtess.windingRule.GLU_TESS_WINDING_ODD;

  /**
   * fatal error: needed combine callback
   * @type {boolean}
   */
  this.fatalError = false;

  /**
   * edge dictionary for sweep line
   * @type {libtess.Dict}
   */
  this.dict = null;
  // NOTE(bckenny): dict initialized in sweep.initEdgeDict_, removed in sweep.doneEdgeDict_

  /**
   * priority queue of vertex events
   * @type {libtess.PriorityQ}
   */
  this.pq = null;
  // NOTE(bckenny): pq initialized in sweep.initPriorityQ

  /**
   * current sweep event being processed
   * @type {libtess.GluVertex}
   */
  this.event = null;

  /**
   * Combine callback.
   * @private {?function(Array<number>, Array<Object>, Array<number>, Object=): Object}
   */
  this.combineCallback_ = null;

  /*** state needed for rendering callbacks (see render.js) ***/

  /**
   * Extract contours, not triangles
   * @private {boolean}
   */
  this.boundaryOnly_ = false;

  /**
   * Begin callback.
   * @private {?function(libtess.primitiveType, Object=)}
   */
  this.beginCallback_ = null;

  /**
   * Edge flag callback.
   * @private {?function(boolean, Object=)}
   */
  this.edgeFlagCallback_ = null;

  /**
   * Vertex callback.
   * @private {?function(Object, Object=)}
   */
  this.vertexCallback_ = null;

  /**
   * End callback.
   * @private {?function(Object=)}
   */
  this.endCallback_ = null;

  /**
   * Mesh callback.
   * @private {?function(libtess.GluMesh)}
   */
  this.meshCallback_ = null;

  /**
   * client data for current polygon
   * @private {Object}
   */
  this.polygonData_ = null;
};

/**
 * The begin/end calls must be properly nested. We keep track of the current
 * state to enforce the ordering.
 * @enum {number}
 * @private
 */
libtess.GluTesselator.tessState_ = {
  T_DORMANT: 0,
  T_IN_POLYGON: 1,
  T_IN_CONTOUR: 2
};

/**
 * Destory the tesselator object. See README.
 */
libtess.GluTesselator.prototype.gluDeleteTess = function() {
  // TODO(bckenny): This does nothing but assert that it isn't called while
  // building the polygon since we rely on GC to handle memory. *If* the public
  // API changes, this should go.
  this.requireState_(libtess.GluTesselator.tessState_.T_DORMANT);
  // memFree(tess); TODO(bckenny)
};

/**
 * Set properties for control over tesselation. See README.
 * @param {libtess.gluEnum} which [description].
 * @param {number|boolean} value [description].
 */
libtess.GluTesselator.prototype.gluTessProperty = function(which, value) {
  // TODO(bckenny): split into more setters?
  // TODO(bckenny): in any case, we can do better than this switch statement

  switch (which) {
    case libtess.gluEnum.GLU_TESS_TOLERANCE:
      // NOTE(bckenny): libtess has never supported any tolerance but 0.
      return;

    case libtess.gluEnum.GLU_TESS_WINDING_RULE:
      var windingRule = /** @type {libtess.windingRule} */(value);

      switch (windingRule) {
        case libtess.windingRule.GLU_TESS_WINDING_ODD:
        case libtess.windingRule.GLU_TESS_WINDING_NONZERO:
        case libtess.windingRule.GLU_TESS_WINDING_POSITIVE:
        case libtess.windingRule.GLU_TESS_WINDING_NEGATIVE:
        case libtess.windingRule.GLU_TESS_WINDING_ABS_GEQ_TWO:
          this.windingRule = windingRule;
          return;
        default:
      }
      break;

    case libtess.gluEnum.GLU_TESS_BOUNDARY_ONLY:
      this.boundaryOnly_ = !!value;
      return;

    default:
      this.callErrorCallback(libtess.gluEnum.GLU_INVALID_ENUM);
      return;
  }
  this.callErrorCallback(libtess.gluEnum.GLU_INVALID_VALUE);
};

/**
 * Returns tessellator property
 * @param {libtess.gluEnum} which [description].
 * @return {number|boolean} [description].
 */
libtess.GluTesselator.prototype.gluGetTessProperty = function(which) {
  // TODO(bckenny): as above, split into more getters? and improve on switch statement
  // why are these being asserted in getter but not setter?

  switch (which) {
    case libtess.gluEnum.GLU_TESS_TOLERANCE:
      return 0;

    case libtess.gluEnum.GLU_TESS_WINDING_RULE:
      var rule = this.windingRule;
      return rule;

    case libtess.gluEnum.GLU_TESS_BOUNDARY_ONLY:
      return this.boundaryOnly_;

    default:
      this.callErrorCallback(libtess.gluEnum.GLU_INVALID_ENUM);
      break;
  }
  return false;
};

/**
 * Lets the user supply the polygon normal, if known. All input data is
 * projected into a plane perpendicular to the normal before tesselation. All
 * output triangles are oriented CCW with respect to the normal (CW orientation
 * can be obtained by reversing the sign of the supplied normal). For example,
 * if you know that all polygons lie in the x-y plane, call
 * `tess.gluTessNormal(0.0, 0.0, 1.0)` before rendering any polygons.
 * @param {number} x
 * @param {number} y
 * @param {number} z
 */
libtess.GluTesselator.prototype.gluTessNormal = function(x, y, z) {
  this.normal_[0] = x;
  this.normal_[1] = y;
  this.normal_[2] = z;
};

/**
 * Specify callbacks. See README for callback descriptions. A null or undefined
 * opt_fn removes current callback.
 * @param {libtess.gluEnum} which The callback-type gluEnum value.
 * @param {?Function=} opt_fn
 */
libtess.GluTesselator.prototype.gluTessCallback = function(which, opt_fn) {
  var fn = !opt_fn ? null : opt_fn;
  // TODO(bckenny): better opt_fn typing?
  // TODO(bckenny): should add documentation that references in callback are volatile (or make a copy)

  switch (which) {
    case libtess.gluEnum.GLU_TESS_BEGIN:
    case libtess.gluEnum.GLU_TESS_BEGIN_DATA:
      this.beginCallback_ = /** @type {?function(libtess.primitiveType, Object=)} */ (fn);
      return;

    case libtess.gluEnum.GLU_TESS_EDGE_FLAG:
    case libtess.gluEnum.GLU_TESS_EDGE_FLAG_DATA:
      this.edgeFlagCallback_ = /** @type {?function(boolean, Object=)} */ (fn);
      return;

    case libtess.gluEnum.GLU_TESS_VERTEX:
    case libtess.gluEnum.GLU_TESS_VERTEX_DATA:
      this.vertexCallback_ = /** @type {?function(Object, Object=)} */ (fn);
      return;

    case libtess.gluEnum.GLU_TESS_END:
    case libtess.gluEnum.GLU_TESS_END_DATA:
      this.endCallback_ = /** @type {?function(Object=)} */ (fn);
      return;

    case libtess.gluEnum.GLU_TESS_ERROR:
    case libtess.gluEnum.GLU_TESS_ERROR_DATA:
      this.errorCallback_ = /** @type {?function((libtess.errorType|libtess.gluEnum), Object=)} */ (fn);
      return;

    case libtess.gluEnum.GLU_TESS_COMBINE:
    case libtess.gluEnum.GLU_TESS_COMBINE_DATA:
      this.combineCallback_ = /** @type {?function(Array<number>, Array<Object>, Array<number>, Object=): Object} */ (fn);
      return;

    case libtess.gluEnum.GLU_TESS_MESH:
      this.meshCallback_ = /** @type {?function(libtess.GluMesh)} */ (fn);
      return;

    default:
      this.callErrorCallback(libtess.gluEnum.GLU_INVALID_ENUM);
      return;
  }
};

/**
 * Specify a vertex and associated data. Must be within calls to
 * beginContour/endContour. See README.
 * @param {!Array<number>} coords
 * @param {Object} data
 */
libtess.GluTesselator.prototype.gluTessVertex = function(coords, data) {
  var tooLarge = false;

  // TODO(bckenny): pool allocation?
  var clamped = [0, 0, 0];

  this.requireState_(libtess.GluTesselator.tessState_.T_IN_CONTOUR);

  for (var i = 0; i < 3; ++i) {
    var x = coords[i];
    if (x < -libtess.GLU_TESS_MAX_COORD) {
      x = -libtess.GLU_TESS_MAX_COORD;
      tooLarge = true;
    }
    if (x > libtess.GLU_TESS_MAX_COORD) {
      x = libtess.GLU_TESS_MAX_COORD;
      tooLarge = true;
    }
    clamped[i] = x;
  }

  if (tooLarge) {
    this.callErrorCallback(libtess.errorType.GLU_TESS_COORD_TOO_LARGE);
  }

  this.addVertex_(clamped, data);
};

/**
 * [gluTessBeginPolygon description]
 * @param {Object} data Client data for current polygon.
 */
libtess.GluTesselator.prototype.gluTessBeginPolygon = function(data) {
  this.requireState_(libtess.GluTesselator.tessState_.T_DORMANT);

  this.state_ = libtess.GluTesselator.tessState_.T_IN_POLYGON;

  this.mesh = new libtess.GluMesh();

  this.polygonData_ = data;
};

/**
 * [gluTessBeginContour description]
 */
libtess.GluTesselator.prototype.gluTessBeginContour = function() {
  this.requireState_(libtess.GluTesselator.tessState_.T_IN_POLYGON);

  this.state_ = libtess.GluTesselator.tessState_.T_IN_CONTOUR;
  this.lastEdge_ = null;
};

/**
 * [gluTessEndContour description]
 */
libtess.GluTesselator.prototype.gluTessEndContour = function() {
  this.requireState_(libtess.GluTesselator.tessState_.T_IN_CONTOUR);
  this.state_ = libtess.GluTesselator.tessState_.T_IN_POLYGON;
};

/**
 * [gluTessEndPolygon description]
 */
libtess.GluTesselator.prototype.gluTessEndPolygon = function() {
  this.requireState_(libtess.GluTesselator.tessState_.T_IN_POLYGON);
  this.state_ = libtess.GluTesselator.tessState_.T_DORMANT;

  // Determine the polygon normal and project vertices onto the plane
  // of the polygon.
  libtess.normal.projectPolygon(this, this.normal_[0], this.normal_[1],
      this.normal_[2]);

  // computeInterior(tess) computes the planar arrangement specified
  // by the given contours, and further subdivides this arrangement
  // into regions. Each region is marked "inside" if it belongs
  // to the polygon, according to the rule given by this.windingRule.
  // Each interior region is guaranteed be monotone.
  libtess.sweep.computeInterior(this);

  if (!this.fatalError) {
    // If the user wants only the boundary contours, we throw away all edges
    // except those which separate the interior from the exterior.
    // Otherwise we tessellate all the regions marked "inside".
    // NOTE(bckenny): we know this.mesh has been initialized, so help closure out.
    var mesh = /** @type {!libtess.GluMesh} */(this.mesh);
    if (this.boundaryOnly_) {
      libtess.tessmono.setWindingNumber(mesh, 1, true);
    } else {
      libtess.tessmono.tessellateInterior(mesh);
    }

    this.mesh.checkMesh();

    if (this.beginCallback_ || this.endCallback_ || this.vertexCallback_ ||
        this.edgeFlagCallback_) {

      if (this.boundaryOnly_) {
        // output boundary contours
        libtess.render.renderBoundary(this, this.mesh);

      } else {
        // output triangles (with edge callback if one is set)
        var flagEdges = !!this.edgeFlagCallback_;
        libtess.render.renderMesh(this, this.mesh, flagEdges);
      }
    }

    if (this.meshCallback_) {
      // Throw away the exterior faces, so that all faces are interior.
      // This way the user doesn't have to check the "inside" flag,
      // and we don't need to even reveal its existence. It also leaves
      // the freedom for an implementation to not generate the exterior
      // faces in the first place.
      libtess.tessmono.discardExterior(this.mesh);
      // user wants the mesh itself
      this.meshCallback_(this.mesh);

      this.mesh = null;
      this.polygonData_ = null;
      return;
    }
  }

  libtess.mesh.deleteMesh(this.mesh);
  this.polygonData_ = null;
  this.mesh = null;
};

/**
 * Change the tesselator state.
 * @private
 * @param {libtess.GluTesselator.tessState_} state
 */
libtess.GluTesselator.prototype.requireState_ = function(state) {
  if (this.state_ !== state) {
    this.gotoState_(state);
  }
};

/**
 * Change the current tesselator state one level at a time to get to the
 * desired state. Only triggered when the API is not called in the correct order
 * so an error callback is made, however the tesselator will always attempt to
 * recover afterwards (see README).
 * @private
 * @param {libtess.GluTesselator.tessState_} newState
 */
libtess.GluTesselator.prototype.gotoState_ = function(newState) {
  while (this.state_ !== newState) {
    if (this.state_ < newState) {
      switch (this.state_) {
        case libtess.GluTesselator.tessState_.T_DORMANT:
          this.callErrorCallback(
              libtess.errorType.GLU_TESS_MISSING_BEGIN_POLYGON);
          this.gluTessBeginPolygon(null);
          break;

        case libtess.GluTesselator.tessState_.T_IN_POLYGON:
          this.callErrorCallback(
              libtess.errorType.GLU_TESS_MISSING_BEGIN_CONTOUR);
          this.gluTessBeginContour();
          break;
      }

    } else {
      switch (this.state_) {
        case libtess.GluTesselator.tessState_.T_IN_CONTOUR:
          this.callErrorCallback(
              libtess.errorType.GLU_TESS_MISSING_END_CONTOUR);
          this.gluTessEndContour();
          break;

        case libtess.GluTesselator.tessState_.T_IN_POLYGON:
          this.callErrorCallback(
              libtess.errorType.GLU_TESS_MISSING_END_POLYGON);
          // NOTE(bckenny): libtess originally reset the tesselator, even though
          // the README claims it should spit out the tessellated results at
          // this point.
          // (see http://cgit.freedesktop.org/mesa/glu/tree/src/libtess/tess.c#n180)
          this.gluTessEndPolygon();
          break;
      }
    }
  }
};

/**
 * [addVertex_ description]
 * @private
 * @param {!Array<number>} coords [description].
 * @param {Object} data [description].
 */
libtess.GluTesselator.prototype.addVertex_ = function(coords, data) {
  var e = this.lastEdge_;
  if (e === null) {
    // Make a self-loop (one vertex, one edge).
    e = libtess.mesh.makeEdge(this.mesh);
    libtess.mesh.meshSplice(e, e.sym);

  } else {
    // Create a new vertex and edge which immediately follow e
    // in the ordering around the left face.
    libtess.mesh.splitEdge(e);
    e = e.lNext;
  }

  // The new vertex is now e.org.
  e.org.data = data;
  e.org.coords[0] = coords[0];
  e.org.coords[1] = coords[1];
  e.org.coords[2] = coords[2];

  // The winding of an edge says how the winding number changes as we
  // cross from the edge''s right face to its left face.  We add the
  // vertices in such an order that a CCW contour will add +1 to
  // the winding number of the region inside the contour.
  e.winding = 1;
  e.sym.winding = -1;

  this.lastEdge_ = e;
};

/**
 * Call callback to indicate the start of a primitive, to be followed by emitted
 * vertices, if any. In libtess.js, `type` will always be `GL_TRIANGLES`.
 * @param {libtess.primitiveType} type
 */
libtess.GluTesselator.prototype.callBeginCallback = function(type) {
  if (this.beginCallback_) {
    this.beginCallback_(type, this.polygonData_);
  }
};

/**
 * Call callback to emit a vertex of the tessellated polygon.
 * @param {Object} data
 */
libtess.GluTesselator.prototype.callVertexCallback = function(data) {
  if (this.vertexCallback_) {
    this.vertexCallback_(data, this.polygonData_);
  }
};

/**
 * Call callback to indicate whether the vertices to follow begin edges which
 * lie on a polygon boundary.
 * @param {boolean} flag
 */
libtess.GluTesselator.prototype.callEdgeFlagCallback = function(flag) {
  if (this.edgeFlagCallback_) {
    this.edgeFlagCallback_(flag, this.polygonData_);
  }
};

/**
 * Call callback to indicate the end of tessellation.
 */
libtess.GluTesselator.prototype.callEndCallback = function() {
  if (this.endCallback_) {
    this.endCallback_(this.polygonData_);
  }
};

/* jscs:disable maximumLineLength */
/**
 * Call callback for combining vertices at edge intersection requiring the
 * creation of a new vertex.
 * @param {!Array<number>} coords Intersection coordinates.
 * @param {!Array<Object>} data Array of vertex data, one per edge vertices.
 * @param {!Array<number>} weight Coefficients used for the linear combination of vertex coordinates that gives coords.
 * @return {?Object} Interpolated vertex.
 */
libtess.GluTesselator.prototype.callCombineCallback = function(coords, data, weight) {
  if (this.combineCallback_) {
    return this.combineCallback_(coords, data, weight, this.polygonData_) ||
        null;
  }

  return null;
};
/* jscs:enable maximumLineLength */

/**
 * Call error callback, if specified, with errno.
 * @param {(libtess.errorType|libtess.gluEnum)} errno
 */
libtess.GluTesselator.prototype.callErrorCallback = function(errno) {
  if (this.errorCallback_) {
    this.errorCallback_(errno, this.polygonData_);
  }
};

/* global libtess */

/**
 * Each face has a pointer to the next and previous faces in the
 * circular list, and a pointer to a half-edge with this face as
 * the left face (null if this is the dummy header). There is also
 * a field "data" for client data.
 *
 * @param {libtess.GluFace=} opt_nextFace
 * @param {libtess.GluFace=} opt_prevFace
 * @constructor
 * @struct
 */
libtess.GluFace = function(opt_nextFace, opt_prevFace) {
  // TODO(bckenny): reverse order of params?

  /**
   * next face (never null)
   * @type {!libtess.GluFace}
   */
  this.next = opt_nextFace || this;

  /**
   * previous face (never NULL)
   * @type {!libtess.GluFace}
   */
  this.prev = opt_prevFace || this;

  /**
   * A half edge with this left face.
   * @type {libtess.GluHalfEdge}
   */
  this.anEdge = null;

  /**
   * room for client's data
   * @type {Object}
   */
  this.data = null;

  /**
   * This face is in the polygon interior.
   * @type {boolean}
   */
  this.inside = false;
};

/* global libtess */

/**
 * The fundamental data structure is the "half-edge". Two half-edges
 * go together to make an edge, but they point in opposite directions.
 * Each half-edge has a pointer to its mate (the "symmetric" half-edge sym),
 * its origin vertex (org), the face on its left side (lFace), and the
 * adjacent half-edges in the CCW direction around the origin vertex
 * (oNext) and around the left face (lNext). There is also a "next"
 * pointer for the global edge list (see below).
 *
 * The notation used for mesh navigation:
 *  sym   = the mate of a half-edge (same edge, but opposite direction)
 *  oNext = edge CCW around origin vertex (keep same origin)
 *  dNext = edge CCW around destination vertex (keep same dest)
 *  lNext = edge CCW around left face (dest becomes new origin)
 *  rNext = edge CCW around right face (origin becomes new dest)
 *
 * "prev" means to substitute CW for CCW in the definitions above.
 *
 * The circular edge list is special; since half-edges always occur
 * in pairs (e and e.sym), each half-edge stores a pointer in only
 * one direction. Starting at eHead and following the e.next pointers
 * will visit each *edge* once (ie. e or e.sym, but not both).
 * e.sym stores a pointer in the opposite direction, thus it is
 * always true that e.sym.next.sym.next === e.
 *
 * @param {libtess.GluHalfEdge=} opt_nextEdge
 * @constructor
 * @struct
 */
libtess.GluHalfEdge = function(opt_nextEdge) {
  // TODO(bckenny): are these the right defaults? (from gl_meshNewMesh requirements)

  /**
   * doubly-linked list (prev==sym->next)
   * @type {!libtess.GluHalfEdge}
   */
  this.next = opt_nextEdge || this;

  // TODO(bckenny): how can this be required if created in pairs? move to factory creation only?
  /**
   * same edge, opposite direction
   * @type {libtess.GluHalfEdge}
   */
  this.sym = null;

  /**
   * next edge CCW around origin
   * @type {libtess.GluHalfEdge}
   */
  this.oNext = null;

  /**
   * next edge CCW around left face
   * @type {libtess.GluHalfEdge}
   */
  this.lNext = null;

  /**
   * origin vertex (oVertex too long)
   * @type {libtess.GluVertex}
   */
  this.org = null;

  /**
   * left face
   * @type {libtess.GluFace}
   */
  this.lFace = null;

  // Internal data (keep hidden)
  // NOTE(bckenny): can't be private, though...

  /**
   * a region with this upper edge (see sweep.js)
   * @type {libtess.ActiveRegion}
   */
  this.activeRegion = null;

  /**
   * change in winding number when crossing from the right face to the left face
   * @type {number}
   */
  this.winding = 0;
};

// NOTE(bckenny): the following came from macros in mesh
// TODO(bckenny): using methods as aliases for sym connections for now.
// not sure about this approach. getters? renames?


/**
 * [rFace description]
 * @return {libtess.GluFace} [description].
 */
libtess.GluHalfEdge.prototype.rFace = function() {
  return this.sym.lFace;
};


/**
 * [dst description]
 * @return {libtess.GluVertex} [description].
 */
libtess.GluHalfEdge.prototype.dst = function() {
  return this.sym.org;
};


/**
 * [oPrev description]
 * @return {libtess.GluHalfEdge} [description].
 */
libtess.GluHalfEdge.prototype.oPrev = function() {
  return this.sym.lNext;
};


/**
 * [lPrev description]
 * @return {libtess.GluHalfEdge} [description].
 */
libtess.GluHalfEdge.prototype.lPrev = function() {
  return this.oNext.sym;
};

// NOTE(bckenny): libtess.GluHalfEdge.dPrev is called nowhere in libtess and
// isn't part of the current public API. It could be useful for mesh traversal
// and manipulation if made public, however.
/* istanbul ignore next */
/**
 * The edge clockwise around destination vertex (keep same dest).
 * @return {libtess.GluHalfEdge}
 */
libtess.GluHalfEdge.prototype.dPrev = function() {
  return this.lNext.sym;
};


/**
 * [rPrev description]
 * @return {libtess.GluHalfEdge} [description].
 */
libtess.GluHalfEdge.prototype.rPrev = function() {
  return this.sym.oNext;
};


/**
 * [dNext description]
 * @return {libtess.GluHalfEdge} [description].
 */
libtess.GluHalfEdge.prototype.dNext = function() {
  return this.rPrev().sym;
};


// NOTE(bckenny): libtess.GluHalfEdge.rNext is called nowhere in libtess and
// isn't part of the current public API. It could be useful for mesh traversal
// and manipulation if made public, however.
/* istanbul ignore next */
/**
 * The edge CCW around the right face (origin of this becomes new dest).
 * @return {libtess.GluHalfEdge}
 */
libtess.GluHalfEdge.prototype.rNext = function() {
  return this.oPrev().sym;
};

/* global libtess */

/**
 * Creates a new mesh with no edges, no vertices,
 * and no loops (what we usually call a "face").
 *
 * @constructor
 * @struct
 */
libtess.GluMesh = function() {
  /**
   * dummy header for vertex list
   * @type {libtess.GluVertex}
   */
  this.vHead = new libtess.GluVertex();

  /**
   * dummy header for face list
   * @type {libtess.GluFace}
   */
  this.fHead = new libtess.GluFace();

  /**
   * dummy header for edge list
   * @type {libtess.GluHalfEdge}
   */
  this.eHead = new libtess.GluHalfEdge();

  /**
   * and its symmetric counterpart
   * @type {libtess.GluHalfEdge}
   */
  this.eHeadSym = new libtess.GluHalfEdge();

  // TODO(bckenny): better way to pair these?
  this.eHead.sym = this.eHeadSym;
  this.eHeadSym.sym = this.eHead;
};


// TODO(bckenny): #ifndef NDEBUG
/**
 * Checks mesh for self-consistency.
 */
libtess.GluMesh.prototype.checkMesh = function() {
  if (!libtess.DEBUG) {
    return;
  }

  var fHead = this.fHead;
  var vHead = this.vHead;
  var eHead = this.eHead;

  var e;

  // faces
  var f;
  var fPrev = fHead;
  for (fPrev = fHead; (f = fPrev.next) !== fHead; fPrev = f) {
    e = f.anEdge;
    do {
      e = e.lNext;
    } while (e !== f.anEdge);
  }

  // vertices
  var v;
  var vPrev = vHead;
  for (vPrev = vHead; (v = vPrev.next) !== vHead; vPrev = v) {
    e = v.anEdge;
    do {
      e = e.oNext;
    } while (e !== v.anEdge);
  }

  // edges
  var ePrev = eHead;
  for (ePrev = eHead; (e = ePrev.next) !== eHead; ePrev = e) {
  }
};

/* global libtess */

/**
 * Each vertex has a pointer to next and previous vertices in the
 * circular list, and a pointer to a half-edge with this vertex as
 * the origin (null if this is the dummy header). There is also a
 * field "data" for client data.
 * @param {libtess.GluVertex=} opt_nextVertex Optional reference to next vertex in the vertex list.
 * @param {libtess.GluVertex=} opt_prevVertex Optional reference to previous vertex in the vertex list.
 * @constructor
 * @struct
 */
libtess.GluVertex = function(opt_nextVertex, opt_prevVertex) {
  /**
   * Next vertex (never null).
   * @type {!libtess.GluVertex}
   */
  this.next = opt_nextVertex || this;

  /**
   * Previous vertex (never null).
   * @type {!libtess.GluVertex}
   */
  this.prev = opt_prevVertex || this;

  /**
   * A half-edge with this origin.
   * @type {libtess.GluHalfEdge}
   */
  this.anEdge = null;

  /**
   * The client's data.
   * @type {Object}
   */
  this.data = null;

  /**
   * The vertex location in 3D.
   * @type {!Array.<number>}
   */
  this.coords = [0, 0, 0];
  // TODO(bckenny): we may want to rethink coords, either eliminate (using s
  // and t and user data) or index into contiguous storage?

  /**
   * Component of projection onto the sweep plane.
   * @type {number}
   */
  this.s = 0;

  /**
   * Component of projection onto the sweep plane.
   * @type {number}
   */
  this.t = 0;

  /**
   * Handle to allow deletion from priority queue, or 0 if not yet inserted into
   * queue.
   * @type {libtess.PQHandle}
   */
  this.pqHandle = 0;
};

/* global libtess */

/**
 * A priority queue of vertices, ordered by libtess.geom.vertLeq, implemented
 * with a sorted array. Used for initial insertion of vertices (see
 * libtess.sweep.initPriorityQ_), sorted once, then it uses an internal
 * libtess.PriorityQHeap for any subsequently created vertices from
 * intersections.
 * @constructor
 * @struct
 */
libtess.PriorityQ = function() {
  /**
   * An unordered list of vertices that have been inserted in the queue, with
   * null in empty slots.
   * @private {Array<libtess.GluVertex>}
   */
  this.verts_ = [];

  /**
   * Array of indices into this.verts_, sorted by vertLeq over the addressed
   * vertices.
   * @private {Array<number>}
   */
  this.order_ = null;

  /**
   * The size of this queue, not counting any vertices stored in heap_.
   * @private {number}
   */
  this.size_ = 0;

  /**
   * Indicates that the queue has been initialized via init. If false, inserts
   * are fast insertions at the end of the verts_ array. If true, the verts_
   * array is sorted and subsequent inserts are done in the heap.
   * @private {boolean}
   */
  this.initialized_ = false;

  /**
   * A priority queue heap, used for faster insertions of vertices after verts_
   * has been sorted.
   * @private {libtess.PriorityQHeap}
   */
  this.heap_ = new libtess.PriorityQHeap();
};

/**
 * Release major storage memory used by priority queue.
 */
libtess.PriorityQ.prototype.deleteQ = function() {
  // TODO(bckenny): could instead clear most of these.
  this.heap_ = null;
  this.order_ = null;
  this.verts_ = null;
  // NOTE(bckenny): nulled at callsite (sweep.donePriorityQ_)
};

/**
 * Sort vertices by libtess.geom.vertLeq. Must be called before any method other
 * than insert is called to ensure correctness when removing or querying.
 */
libtess.PriorityQ.prototype.init = function() {
  // TODO(bckenny): reuse. in theory, we don't have to empty this, as access is
  // dictated by this.size_, but array.sort doesn't know that
  this.order_ = [];

  // Create an array of indirect pointers to the verts, so that
  // the handles we have returned are still valid.
  // TODO(bckenny): valid for when? it appears we can just store indexes into
  // verts_, but what did this mean?
  for (var i = 0; i < this.size_; i++) {
    this.order_[i] = i;
  }

  // sort the indirect pointers in descending order of the verts themselves
  // TODO(bckenny): make sure it's ok that verts[a] === verts[b] returns 1
  // TODO(bckenny): unstable sort means we may get slightly different polys in
  // different browsers, but only when passing in equal points
  // TODO(bckenny): make less awkward closure?
  var comparator = (function(verts) {
    return function(a, b) {
      return libtess.geom.vertLeq(verts[a], verts[b]) ? 1 : -1;
    };
  })(this.verts_);
  this.order_.sort(comparator);

  this.initialized_ = true;
  this.heap_.init();

  // NOTE(bckenny): debug assert of ordering of the verts_ array.
  if (libtess.DEBUG) {
    var p = 0;
    var r = p + this.size_ - 1;
    for (i = p; i < r; ++i) {
    }
  }
};

/**
 * Insert a vertex into the priority queue. Returns a PQHandle to refer to it,
 * which will never be 0.
 * @param {libtess.GluVertex} vert
 * @return {libtess.PQHandle}
 */
libtess.PriorityQ.prototype.insert = function(vert) {
  // NOTE(bckenny): originally returned LONG_MAX as alloc failure signal. no
  // longer does.
  if (this.initialized_) {
    return this.heap_.insert(vert);
  }

  var curr = this.size_++;

  this.verts_[curr] = vert;

  // Negative handles index the sorted array.
  return -(curr + 1);
};

/**
 * Removes the minimum vertex from the queue and returns it. If the queue is
 * empty, null will be returned.
 * @return {libtess.GluVertex}
 */
libtess.PriorityQ.prototype.extractMin = function() {
  if (this.size_ === 0) {
    return this.heap_.extractMin();
  }

  var sortMin = this.verts_[this.order_[this.size_ - 1]];
  if (!this.heap_.isEmpty()) {
    var heapMin = this.heap_.minimum();
    if (libtess.geom.vertLeq(heapMin, sortMin)) {
      return this.heap_.extractMin();
    }
  }

  do {
    --this.size_;
  } while (this.size_ > 0 && this.verts_[this.order_[this.size_ - 1]] === null);

  return sortMin;
};

/**
 * Returns the minimum vertex in the queue. If the queue is empty, null will be
 * returned.
 * @return {libtess.GluVertex}
 */
libtess.PriorityQ.prototype.minimum = function() {
  if (this.size_ === 0) {
    return this.heap_.minimum();
  }

  var sortMin = this.verts_[this.order_[this.size_ - 1]];
  if (!this.heap_.isEmpty()) {
    var heapMin = this.heap_.minimum();
    if (libtess.geom.vertLeq(heapMin, sortMin)) {
      return heapMin;
    }
  }

  return sortMin;
};

/**
 * Remove vertex with handle removeHandle from queue.
 * @param {libtess.PQHandle} removeHandle
 */
libtess.PriorityQ.prototype.remove = function(removeHandle) {
  if (removeHandle >= 0) {
    this.heap_.remove(removeHandle);
    return;
  }
  removeHandle = -(removeHandle + 1);

  this.verts_[removeHandle] = null;
  while (this.size_ > 0 && this.verts_[this.order_[this.size_ - 1]] === null) {
    --this.size_;
  }
};

/* global libtess */

/**
 * A priority queue of vertices, ordered by libtess.geom.vertLeq, implemented
 * with a binary heap. Used only within libtess.PriorityQ for prioritizing
 * vertices created by intersections (see libtess.sweep.checkForIntersect_).
 * @constructor
 * @struct
 */
libtess.PriorityQHeap = function() {
  /**
   * The heap itself. Active nodes are stored in the range 1..size, with the
   * minimum at 1. Each node stores only an index into verts_ and handles_.
   * @private {!Array<number>}
   */
  this.heap_ = libtess.PriorityQHeap.reallocNumeric_([0],
      libtess.PriorityQHeap.INIT_SIZE_ + 1);

  /**
   * An unordered list of vertices in the heap, with null in empty slots.
   * @private {!Array<libtess.GluVertex>}
   */
  this.verts_ = [null, null];

  /**
   * An unordered list of indices mapping vertex handles into the heap. An entry
   * at index i will map the vertex at i in verts_ to its place in the heap
   * (i.e. heap_[handles_[i]] === i).
   * Empty slots below size_ are a free list chain starting at freeList_.
   * @private {!Array<number>}
   */
  this.handles_ = [0, 0];

  /**
   * The size of the queue.
   * @private {number}
   */
  this.size_ = 0;

  /**
   * The queue's current allocated space.
   * @private {number}
   */
  this.max_ = libtess.PriorityQHeap.INIT_SIZE_;

  /**
   * The index of the next free hole in the verts_ array. That slot in handles_
   * has the next index in the free list. If there are no holes, freeList_ === 0
   * and a new vertex must be appended to the list.
   * @private {libtess.PQHandle}
   */
  this.freeList_ = 0;

  /**
   * Indicates that the heap has been initialized via init. If false, inserts
   * are fast insertions at the end of a list. If true, all inserts will now be
   * correctly ordered in the queue before returning.
   * @private {boolean}
   */
  this.initialized_ = false;

  // Point the first index at the first (currently null) vertex.
  this.heap_[1] = 1;
};

/**
 * The initial allocated space for the queue.
 * @const
 * @private {number}
 */
libtess.PriorityQHeap.INIT_SIZE_ = 32;

/**
 * Allocate a numeric index array of size size. oldArray's contents are copied
 * to the beginning of the new array. The rest of the array is filled with
 * zeroes.
 * @private
 * @param {!Array<number>} oldArray
 * @param {number} size
 * @return {!Array<number>}
 */
libtess.PriorityQHeap.reallocNumeric_ = function(oldArray, size) {
  var newArray = new Array(size);

  // NOTE(bckenny): V8 likes this significantly more than simply growing the
  // array element-by-element or expanding the existing array all at once, so,
  // for now, emulating realloc.
  for (var index = 0; index < oldArray.length; index++) {
    newArray[index] = oldArray[index];
  }

  for (; index < size; index++) {
    newArray[index] = 0;
  }

  return newArray;
};

/**
 * Initializing ordering of the heap. Must be called before any method other
 * than insert is called to ensure correctness when removing or querying.
 */
libtess.PriorityQHeap.prototype.init = function() {
  // This method of building a heap is O(n), rather than O(n lg n).
  for (var i = this.size_; i >= 1; --i) {
    // TODO(bckenny): since init is called before anything is inserted (see
    // PriorityQ.init), this will always be empty. Better to lazily init?
    this.floatDown_(i);
  }

  this.initialized_ = true;
};

/**
 * Insert a new vertex into the heap.
 * @param {libtess.GluVertex} vert The vertex to insert.
 * @return {libtess.PQHandle} A handle that can be used to remove the vertex.
 */
libtess.PriorityQHeap.prototype.insert = function(vert) {
  var endIndex = ++this.size_;

  // If the heap overflows, double its size.
  if ((endIndex * 2) > this.max_) {
    this.max_ *= 2;

    this.handles_ = libtess.PriorityQHeap.reallocNumeric_(this.handles_,
        this.max_ + 1);
  }

  var newVertSlot;
  if (this.freeList_ === 0) {
    // No free slots, append vertex.
    newVertSlot = endIndex;
  } else {
    // Put vertex in free slot, update freeList_ to next free slot.
    newVertSlot = this.freeList_;
    this.freeList_ = this.handles_[this.freeList_];
  }

  this.verts_[newVertSlot] = vert;
  this.handles_[newVertSlot] = endIndex;
  this.heap_[endIndex] = newVertSlot;

  if (this.initialized_) {
    this.floatUp_(endIndex);
  }
  return newVertSlot;
};

/**
 * @return {boolean} Whether the heap is empty.
 */
libtess.PriorityQHeap.prototype.isEmpty = function() {
  return this.size_ === 0;
};

/**
 * Returns the minimum vertex in the heap. If the heap is empty, null will be
 * returned.
 * @return {libtess.GluVertex}
 */
libtess.PriorityQHeap.prototype.minimum = function() {
  return this.verts_[this.heap_[1]];
};

/**
 * Removes the minimum vertex from the heap and returns it. If the heap is
 * empty, null will be returned.
 * @return {libtess.GluVertex}
 */
libtess.PriorityQHeap.prototype.extractMin = function() {
  var heap = this.heap_;
  var verts = this.verts_;
  var handles = this.handles_;

  var minHandle = heap[1];
  var minVertex = verts[minHandle];

  if (this.size_ > 0) {
    // Replace min with last vertex.
    heap[1] = heap[this.size_];
    handles[heap[1]] = 1;

    // Clear min vertex and put slot at front of freeList_.
    verts[minHandle] = null;
    handles[minHandle] = this.freeList_;
    this.freeList_ = minHandle;

    // Restore heap.
    if (--this.size_ > 0) {
      this.floatDown_(1);
    }
  }

  return minVertex;
};

/**
 * Remove vertex with handle removeHandle from heap.
 * @param {libtess.PQHandle} removeHandle
 */
libtess.PriorityQHeap.prototype.remove = function(removeHandle) {
  var heap = this.heap_;
  var verts = this.verts_;
  var handles = this.handles_;

  var heapIndex = handles[removeHandle];

  // Replace with last vertex.
  heap[heapIndex] = heap[this.size_];
  handles[heap[heapIndex]] = heapIndex;

  // Restore heap.
  if (heapIndex <= --this.size_) {
    if (heapIndex <= 1) {
      this.floatDown_(heapIndex);
    } else {
      var vert = verts[heap[heapIndex]];
      var parentVert = verts[heap[heapIndex >> 1]];
      if (libtess.geom.vertLeq(parentVert, vert)) {
        this.floatDown_(heapIndex);
      } else {
        this.floatUp_(heapIndex);
      }
    }
  }

  // Clear vertex and put slot at front of freeList_.
  verts[removeHandle] = null;
  handles[removeHandle] = this.freeList_;
  this.freeList_ = removeHandle;
};

/**
 * Restore heap by moving the vertex at index in the heap downwards to a valid
 * slot.
 * @private
 * @param {libtess.PQHandle} index
 */
libtess.PriorityQHeap.prototype.floatDown_ = function(index) {
  var heap = this.heap_;
  var verts = this.verts_;
  var handles = this.handles_;

  var currIndex = index;
  var currHandle = heap[currIndex];
  for (;;) {
    // The children of node i are nodes 2i and 2i+1.
    var childIndex = currIndex << 1;
    if (childIndex < this.size_) {
      // Set child to the index of the child with the minimum vertex.
      if (libtess.geom.vertLeq(verts[heap[childIndex + 1]],
          verts[heap[childIndex]])) {
        childIndex = childIndex + 1;
      }
    }

    var childHandle = heap[childIndex];
    if (childIndex > this.size_ ||
        libtess.geom.vertLeq(verts[currHandle], verts[childHandle])) {
      // Heap restored.
      heap[currIndex] = currHandle;
      handles[currHandle] = currIndex;
      return;
    }

    // Swap current node and child; repeat from childIndex.
    heap[currIndex] = childHandle;
    handles[childHandle] = currIndex;
    currIndex = childIndex;
  }
};

/**
 * Restore heap by moving the vertex at index in the heap upwards to a valid
 * slot.
 * @private
 * @param {libtess.PQHandle} index
 */
libtess.PriorityQHeap.prototype.floatUp_ = function(index) {
  var heap = this.heap_;
  var verts = this.verts_;
  var handles = this.handles_;

  var currIndex = index;
  var currHandle = heap[currIndex];
  for (;;) {
    // The parent of node i is node floor(i/2).
    var parentIndex = currIndex >> 1;
    var parentHandle = heap[parentIndex];

    if (parentIndex === 0 ||
        libtess.geom.vertLeq(verts[parentHandle], verts[currHandle])) {
      // Heap restored.
      heap[currIndex] = currHandle;
      handles[currHandle] = currIndex;
      return;
    }

    // Swap current node and parent; repeat from parentIndex.
    heap[currIndex] = parentHandle;
    handles[parentHandle] = currIndex;
    currIndex = parentIndex;
  }
};

/* global libtess */

// TODO(bckenny): apparently only visible outside of sweep for debugging routines.
// find out if we can hide

/**
 * For each pair of adjacent edges crossing the sweep line, there is
 * an ActiveRegion to represent the region between them. The active
 * regions are kept in sorted order in a dynamic dictionary. As the
 * sweep line crosses each vertex, we update the affected regions.
 * @constructor
 * @struct
 */
libtess.ActiveRegion = function() {
  // TODO(bckenny): I *think* eUp and nodeUp could be passed in as constructor params

  /**
   * The upper edge of the region, directed right to left
   * @type {libtess.GluHalfEdge}
   */
  this.eUp = null;

  /**
   * Dictionary node corresponding to eUp edge.
   * @type {libtess.DictNode}
   */
  this.nodeUp = null;

  /**
   * Used to determine which regions are inside the polygon.
   * @type {number}
   */
  this.windingNumber = 0;

  /**
   * Whether this region is inside the polygon.
   * @type {boolean}
   */
  this.inside = false;

  /**
   * Marks fake edges at t = +/-infinity.
   * @type {boolean}
   */
  this.sentinel = false;

  /**
   * Marks regions where the upper or lower edge has changed, but we haven't
   * checked whether they intersect yet.
   * @type {boolean}
   */
  this.dirty = false;

  /**
   * marks temporary edges introduced when we process a "right vertex" (one
   * without any edges leaving to the right)
   * @type {boolean}
   */
  this.fixUpperEdge = false;
};

/**
 * Returns the ActiveRegion below this one.
 * @return {libtess.ActiveRegion}
 */
libtess.ActiveRegion.prototype.regionBelow = function() {
  return this.nodeUp.getPredecessor().getKey();
};

/**
 * Returns the ActiveRegion above this one.
 * @return {libtess.ActiveRegion}
 */
libtess.ActiveRegion.prototype.regionAbove = function() {
  return this.nodeUp.getSuccessor().getKey();
};

/* global libtess, module */

/**
 * node.js export for non-compiled source
 */
if (true) {
  module.exports = libtess;
}


/***/ },

/***/ 4030
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Features_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(5345);
/* harmony import */ var _BROWSER_VERSION_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(5975);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(6334);



const URLs =
{
   getScriptURL: (() =>
   {
      let src;

      switch (_Features_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .ENVIRONMENT)
      {
         case "NODE":
         {
            src = __webpack_require__.g .require ("url") .pathToFileURL (__filename) .href;
            break;
         }
         case "BROWSER":
         {
            src = document .currentScript ?.src ?? document .location .href;
            break;
         }
         case "MODULE":
         {
            // src = import .meta .url;
            break;
         }
      }

      // Prevent caching issues with jsDelivr and UNPKG.
      src = src .replace ("/x_ite@latest/", `/x_ite@${_BROWSER_VERSION_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A}/`);

      return function ()
      {
         return src;
      };
   })(),
   getProviderURL (component)
   {
      if (!component)
         return "https://create3000.github.io/x_ite/";

      const min = this .getScriptURL () .match (/\.min\.m?js$/) ? ".min" : "";

      return new URL (`assets/components/${component}Component${min}.js`, this .getScriptURL ()) .href;
   },
   getFontsURL (file)
   {
      return new URL (`assets/fonts/${file}`, this .getScriptURL ()) .href;
   },
   getLinetypeURL ()
   {
      return new URL ("assets/linetype/linetypes.png", this .getScriptURL ()) .href;
   },
   getHatchingURL (index)
   {
      return new URL (`assets/hatching/${index}.png`, this .getScriptURL ()) .href;
   },
   getLibraryURL (file)
   {
      return new URL (`assets/lib/${file}`, this .getScriptURL ()) .href;
   },
};

const __default__ = URLs;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .add ("URLs", __default__));

/***/ },

/***/ 4057
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Base_X3DInfoArray_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(3046);
/* harmony import */ var _ComponentInfo_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(6870);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(6334);



function ComponentInfoArray (values = [ ])
{
   return _Base_X3DInfoArray_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .call (this, Array .from (values, value => [value .name, value]), _ComponentInfo_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A);
}

Object .assign (Object .setPrototypeOf (ComponentInfoArray .prototype, _Base_X3DInfoArray_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .prototype),
{
   add (name, { level, title, providerURL, external = false, dependencies = [ ] })
   {
      _Base_X3DInfoArray_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .prototype .add .call (this, name, new _ComponentInfo_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (name, level, title, providerURL, external, dependencies));
   },
});

for (const key of Object .keys (ComponentInfoArray .prototype))
   Object .defineProperty (ComponentInfoArray .prototype, key, { enumerable: false });

Object .defineProperties (ComponentInfoArray,
{
   typeName:
   {
      value: "ComponentInfoArray",
      enumerable: true,
   },
});

const __default__ = ComponentInfoArray;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .add ("ComponentInfoArray", __default__));

/***/ },

/***/ 4078
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Fields_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(3515);
/* harmony import */ var _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(2914);
/* harmony import */ var _Base_FieldDefinitionArray_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(9572);
/* harmony import */ var _Components_Networking_X3DUrlObject_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(4386);
/* harmony import */ var _X3DProtoDeclarationNode_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(2588);
/* harmony import */ var _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(4946);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(6334);







const
   _proto = Symbol (),
   _scene = Symbol (),
   _cache = Symbol ();

function X3DExternProtoDeclaration (executionContext, url)
{
   _X3DProtoDeclarationNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .call (this, executionContext);
   _Components_Networking_X3DUrlObject_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A            .call (this, executionContext);

   this .addType (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .X3DExternProtoDeclaration);

   this .addChildObjects (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .inputOutput, "load",                 new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFBool (true),
                          _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .inputOutput, "url",                  url .copy (), // Must be of type MFString.
                          _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .inputOutput, "autoRefresh",          new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFTime (0),
                          _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .inputOutput, "autoRefreshTimeLimit", new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFTime (3600));

   this .getBrowser () [_cache] ??= new Map ();
}

Object .assign (Object .setPrototypeOf (X3DExternProtoDeclaration .prototype, _X3DProtoDeclarationNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .prototype),
   _Components_Networking_X3DUrlObject_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .prototype,
{
   initialize ()
   {
      _X3DProtoDeclarationNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .prototype .initialize .call (this);
      _Components_Networking_X3DUrlObject_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A            .prototype .initialize .call (this);
   },
   getAppInfo ()
   {
      return this [_proto] ?.getAppInfo ()
         || _X3DProtoDeclarationNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .prototype .getAppInfo .call (this);
   },
   setAppInfo (value)
   {
      if (this [_proto])
         this [_proto] .setAppInfo (value);
      else
         _X3DProtoDeclarationNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .prototype .setAppInfo .call (this, value);
   },
   getDocumentation ()
   {
      return this [_proto] ?.getDocumentation ()
         || _X3DProtoDeclarationNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .prototype .getDocumentation .call (this);
   },
   setDocumentation (value)
   {
      if (this [_proto])
         this [_proto] .setDocumentation (value);
      else
         _X3DProtoDeclarationNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .prototype .setDocumentation .call (this, value);
   },
   getProtoDeclaration ()
   {
      return this [_proto];
   },
   setProtoDeclaration (proto)
   {
      this [_proto] = proto;

      if (proto)
      {
         this .getFieldDefinitions ()  .assign (proto .getFieldDefinitions ());
         this .getUserDefinedFields () .assign (proto .getUserDefinedFields ());
      }

      this .updateInstances ();
   },
   async loadData ()
   {
      const browser = this .getBrowser ();

      if (!this ._url .length)
      {
         this .setError (new Error ("No URL given."));
         return;
      }

      const { default: FileLoader } = await Promise.resolve(/* import() */).then(__webpack_require__.bind(__webpack_require__, 324));

      for (const url of this ._url)
      {
         try
         {
            const
               fileURL  = new URL (url, this .getExecutionContext () .getBaseURL ()),
               cacheURL = new URL (fileURL),
               cache    = browser .getBrowserOption ("Cache");

            cacheURL .hash = "";

            const cachePromise = cache
               ? browser [_cache] .get (cacheURL .href)
               : null;

            const promise = cachePromise ?? new Promise (resolve =>
            {
               new FileLoader (this) .createX3DFromURL ([cacheURL], null, resolve);
            });

            if (!cachePromise && !cacheURL .search)
               browser [_cache] .set (cacheURL .href, promise);

            const scene = await promise;

            if (!scene)
               continue;

            this .setInternalScene (scene, fileURL, cache);
            return;
         }
         catch (error)
         {
            console .warn (error .message);
         }
      }

      this .setError (new Error ("File could not be loaded."));
   },
   getInternalScene ()
   {
      ///  Returns the internal X3DScene of this extern proto, that is loaded from the url given.

      return this [_scene];
   },
   setInternalScene (scene, fileURL, cache)
   {
      const browser = this .getBrowser ();

      if (this [_scene] !== browser .getDefaultScene () && !this [_cache])
         this [_scene] ?.dispose ();

      this [_scene] = scene;
      this [_cache] = cache;

      const
         protoName = decodeURIComponent (fileURL .hash .substring (1)),
         proto     = protoName ? this [_scene] .protos .get (protoName) : this [_scene] .protos [0];

      if (!proto)
         throw new Error ("PROTO not found");

      this [_scene] .setExecutionContext (this [_cache] ? browser .getDefaultScene () : this .getExecutionContext ());
      this [_scene] .setLive (true);

      this .setLoadState (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .COMPLETE_STATE);
      this .setProtoDeclaration (proto);
   },
   setError (error)
   {
      console .error (`Error loading extern prototype '${this .getName ()}':`, error);

      this [_scene] = this .getBrowser () .getDefaultScene ();

      this .setLoadState (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .FAILED_STATE);
      this .setProtoDeclaration (null);
   },
   toVRMLStream (generator)
   {
      generator .Indent ();
      generator .string += "EXTERNPROTO";
      generator .Space ();
      generator .string += this .getName ();
      generator .TidySpace ();
      generator .string += "[";

      const userDefinedFields = this .getUserDefinedFields ();

      if (userDefinedFields .length === 0)
      {
         generator .TidySpace ();
      }
      else
      {
         let
            fieldTypeLength   = 0,
            accessTypeLength  = 0;

         for (const field of userDefinedFields)
         {
            fieldTypeLength  = Math .max (fieldTypeLength, field .getTypeName () .length);
            accessTypeLength = Math .max (accessTypeLength, generator .AccessType (field .getAccessType ()) .length);
         }

         generator .TidyBreak ();

         generator .IncIndent ();

         const last = userDefinedFields .at (-1);

         for (const field of userDefinedFields)
         {
            this .toVRMLStreamUserDefinedField (generator, field, fieldTypeLength, accessTypeLength);

            if (field === last)
               generator .TidyBreak ();
            else
               generator .Break ();
         }

         generator .DecIndent ();

         generator .Indent ();
      }

      generator .string += "]";
      generator .TidyBreak ();
      generator .Indent ();

      this ._url .toVRMLStream (generator);
   },
   toVRMLStreamUserDefinedField (generator, field, fieldTypeLength, accessTypeLength)
   {
      generator .Indent ();
      generator .string += generator .AccessType (field .getAccessType ()) .padEnd (accessTypeLength, generator .TidySpace ());
      generator .Space ();
      generator .string += field .getTypeName () .padEnd (fieldTypeLength, generator .TidySpace ());
      generator .Space ();
      generator .string += field .getName ();
   },
   toXMLStream (generator)
   {
      generator .openTag ("ExternProtoDeclare");
      generator .attribute ("name", this .getName ());

      generator .Space ();
      generator .string += "url='";

      this ._url .toXMLStream (generator);

      generator .string += "'";

      if (this .getAppInfo ())
         generator .attribute ("appinfo", this .getAppInfo ());

      if (this .getDocumentation ())
         generator .attribute ("documentation", this .getDocumentation ());

      const userDefinedFields = this .getUserDefinedFields ();

      if (userDefinedFields .length)
      {
         generator .endTag ();
         generator .IncIndent ();

         for (const field of userDefinedFields)
         {
            generator .openTag ("field");
            generator .attribute ("accessType", generator .AccessType (field .getAccessType ()));
            generator .attribute ("type",       field .getTypeName ());
            generator .attribute ("name",       field .getName ());

            if (field .getAppInfo ())
               generator .attribute ("appinfo", field .getAppInfo ());

            if (field .getDocumentation ())
               generator .attribute ("documentation", field .getDocumentation ());

            generator .closeTag ("field");
            generator .TidyBreak ();
         }

         generator .DecIndent ();
         generator .closingTag ("ExternProtoDeclare");
      }
      else
      {
         generator .closeTag ("ExternProtoDeclare");
      }
   },
   toJSONStream (generator)
   {
      generator .TidyBreak ();
      generator .Indent ();

      generator .beginObject ("ExternProtoDeclare", false, true);
      generator .stringProperty ("@name", this .getName (), false);

      if (this .getAppInfo ())
         generator .stringProperty ("@appinfo", this .getAppInfo ());

      if (this .getDocumentation ())
         generator .stringProperty ("@documentation", this .getDocumentation ());

      // Fields

      const userDefinedFields = this .getUserDefinedFields ();

      if (userDefinedFields .length)
      {
         generator .beginArray ("field");

         for (const field of userDefinedFields)
         {
            generator .beginObject ("", field !== userDefinedFields [0]);
            generator .stringProperty ("@accessType", generator .AccessType (field .getAccessType ()), false);
            generator .stringProperty ("@type",       field .getTypeName ());
            generator .stringProperty ("@name",       field .getName ());

            if (field .getAppInfo ())
               generator .stringProperty ("@appinfo", field .getAppInfo ());

            if (field .getDocumentation ())
               generator .stringProperty ("@documentation", field .getDocumentation ());

            generator .endObject ();
         }

         generator .endArray ();
      }

      // URL

      generator .string += ',';
      generator .TidyBreak ();
      generator .Indent ();
      generator .string += '"';
      generator .string += "@url";
      generator .string += '"';
      generator .string += ':';
      generator .TidySpace ();

      this ._url .toJSONStream (generator);

      // End

      generator .endObject ();
      generator .endObject ();
   },
});

for (const key of Object .keys (X3DExternProtoDeclaration .prototype))
   Object .defineProperty (X3DExternProtoDeclaration .prototype, key, { enumerable: false });

Object .defineProperties (X3DExternProtoDeclaration .prototype,
{
   isExternProto:
   {
      value: true,
      enumerable: true,
   },
   urls:
   {
      get () { return this ._url; },
      enumerable: true,
   },
   loadState:
   {
      get: X3DExternProtoDeclaration .prototype .checkLoadState,
      enumerable: true,
   },
});

Object .defineProperties (X3DExternProtoDeclaration,
{
   typeName:
   {
      value: "X3DExternProtoDeclaration",
      enumerable: true,
   },
   fieldDefinitions:
   {
      value: new _Base_FieldDefinitionArray_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A ([
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .inputOutput, "metadata", new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFNode ()),
      ]),
      enumerable: true,
   },
});

_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .addConstant (X3DExternProtoDeclaration .typeName);

const __default__ = X3DExternProtoDeclaration;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .add ("X3DExternProtoDeclaration", __default__));

/***/ },

/***/ 4303
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Fields_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(3515);
/* harmony import */ var _Components_Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(8450);
/* harmony import */ var _Execution_X3DImportedNode_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(4850);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(6334);




class Placeholder extends _Components_Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A
{
   #parser;
   #lastIndex;
   #lineNumber;
   #name;
   #namedNodes;
   #importedNodes;
   #type;
   #typeName;

   constructor (parser, name, type = _Components_Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A, typeName)
   {
      super (parser .getExecutionContext ());

      this .#parser        = parser;
      this .#lastIndex     = parser .lastIndex,
      this .#lineNumber    = parser .lineNumber;
      this .#namedNodes    = parser .getNamedNodes ();
      this .#importedNodes = parser .getImportedNodes ();

      this .#name     = name;
      this .#type     = type;
      this .#typeName = typeName;
   }

   getComponentInfo ()
   {
      return this .#type .componentInfo;
   }

   getContainerField ()
   {
      return this .#type .containerField;
   }

   getSpecificationRange ()
   {
      return this .#type .specificationRange;
   }

   replaceWithNode ()
   {
      const
         name      = this .#name,
         localNode = this .#namedNodes .get (name) ?? this .#importedNodes .get (name);

      const node = localNode instanceof _Execution_X3DImportedNode_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A
         ? localNode .getExportedNode (this .#type)
         : localNode;

      if (!node)
      {
         this .#parser .lastIndex  = this .#lastIndex;
         this .#parser .lineNumber = this .#lineNumber;

         throw new Error (`Named node '${name}' not found.`);
      }

      this .#parser .checkNodeType (node, this .#name, this .#type, this .#typeName);

      for (const parent of Array .from (this .getParents ()))
      {
         if (!(parent instanceof _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFNode))
            continue;

         parent .setValue (node);
      }
   }
}

const __default__ = Placeholder;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .add ("Placeholder", __default__));

/***/ },

/***/ 4310
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Fields_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(3515);
/* harmony import */ var _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(8450);
/* harmony import */ var _X3DTextureNode_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(4910);
/* harmony import */ var _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(4946);
/* harmony import */ var _Base_X3DCast_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(5400);
/* harmony import */ var _standard_Math_Numbers_Matrix4_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(2597);
/* harmony import */ var _standard_Math_Algorithm_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(5370);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(6334);








function X3DSingleTextureNode (executionContext)
{
   _X3DTextureNode_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .call (this, executionContext);

   this .addType (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .X3DSingleTextureNode);

   this .addChildObjects (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .outputOnly, "linear", new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFBool ())

   this .matrix = new Float32Array (_standard_Math_Numbers_Matrix4_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .IDENTITY);
}

Object .assign (Object .setPrototypeOf (X3DSingleTextureNode .prototype, _X3DTextureNode_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .prototype),
{
   initialize ()
   {
      _X3DTextureNode_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .prototype .initialize .call (this);

      this ._textureProperties .addInterest ("set_textureProperties__", this, true);

      const gl = this .getBrowser () .getContext ();

      this .texture = gl .createTexture ();

      this .set_textureProperties__ (false);
   },
   getCount ()
   {
      return 1;
   },
   getTextureTypeString ()
   {
      switch (this .getTextureType ())
      {
         case 1:                // ImageTexture, MovieTexture (flipY)
         case 2: return "2D";   // PixelTexture
         case 3: return "3D";   // X3DTexture3DNode
         case 4: return "CUBE"; // X3DEnvironmentTextureNode
      }
   },
   getTexture ()
   {
      return this .texture;
   },
   setTexture (texture)
   {
      const gl = this .getBrowser () .getContext ();

      gl .deleteTexture (this .texture);

      this .texture = texture;

      this .addNodeEvent ();
   },
   isLinear ()
   {
      return this ._linear .getValue ();
   },
   setLinear (value)
   {
      if (!!value !== this ._linear .getValue ())
         this ._linear = value;
   },
   canMipMaps ()
   {
      return this .mipMaps;
   },
   setMipMaps (value)
   {
      this .mipMaps = value;
   },
   getMatrix ()
   {
      // Normally the identity matrix or a flipY matrix.
      return this .matrix;
   },
   isImageTransparent (data)
   {
      const length = data .length;

      for (let i = 3; i < length; i += 4)
      {
         if (data [i] !== 255)
            return true;
      }

      return false;
   },
   set_textureProperties__ (update)
   {
      if (this .texturePropertiesNode)
         this .texturePropertiesNode .removeInterest ("updateTextureParameters", this);

      this .texturePropertiesNode = (0,_Base_X3DCast_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A) (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .TextureProperties, this ._textureProperties)
         ?? this .getBrowser () .getDefaultTextureProperties ();

      this .texturePropertiesNode .addInterest ("updateTextureParameters", this);

      if (update)
         this .updateTextureParameters ();
   },
   updateTextureParameters (target, haveTextureProperties, textureProperties, width, height, repeatS, repeatT, repeatR)
   {
      const
         browser = this .getBrowser (),
         gl      = browser .getContext ();

      gl .bindTexture (target, this .getTexture ());

      if (!haveTextureProperties && Math .max (width, height) < browser .getMinTextureSize ())
      {
         // Don't generate MipMaps.
         gl .texParameteri (target, gl .TEXTURE_MIN_FILTER, gl .NEAREST);
         gl .texParameteri (target, gl .TEXTURE_MAG_FILTER, gl .NEAREST);
      }
      else if (this .canMipMaps () && textureProperties ._generateMipMaps .getValue ())
      {
         // Can MipMaps and wants MipMaps.
         gl .generateMipmap (target);

         gl .texParameteri (target, gl .TEXTURE_MIN_FILTER, gl [textureProperties .getMinificationFilter ()]);
         gl .texParameteri (target, gl .TEXTURE_MAG_FILTER, gl [textureProperties .getMagnificationFilter ()]);
      }
      else
      {
         // No MipMaps.
         gl .texParameteri (target, gl .TEXTURE_MIN_FILTER, gl [textureProperties .getMinificationFilter (false)]);
         gl .texParameteri (target, gl .TEXTURE_MAG_FILTER, gl [textureProperties .getMagnificationFilter (false)]);
      }

      if (haveTextureProperties)
      {
         gl .texParameteri (target, gl .TEXTURE_WRAP_S, gl [textureProperties .getBoundaryModeS ()]);
         gl .texParameteri (target, gl .TEXTURE_WRAP_T, gl [textureProperties .getBoundaryModeT ()]);
         gl .texParameteri (target, gl .TEXTURE_WRAP_R, gl [textureProperties .getBoundaryModeR ()]);
      }
      else
      {
         gl .texParameteri (target, gl .TEXTURE_WRAP_S, repeatS ? gl .REPEAT : gl .CLAMP_TO_EDGE);
         gl .texParameteri (target, gl .TEXTURE_WRAP_T, repeatT ? gl .REPEAT : gl .CLAMP_TO_EDGE);
         gl .texParameteri (target, gl .TEXTURE_WRAP_R, repeatR ? gl .REPEAT : gl .CLAMP_TO_EDGE);
      }

      //gl .texParameterfv (target, gl .TEXTURE_BORDER_COLOR, textureProperties ._borderColor .getValue ());
      //gl .texParameterf  (target, gl .TEXTURE_PRIORITY,     textureProperties ._texturePriority .getValue ());

      const ext = browser .getAnisotropicExtension ();

      if (ext)
      {
         const max = gl .getParameter (ext .MAX_TEXTURE_MAX_ANISOTROPY_EXT);

         gl .texParameterf (target, ext .TEXTURE_MAX_ANISOTROPY_EXT, _standard_Math_Algorithm_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .clamp (textureProperties ._anisotropicDegree .getValue (), 0, max));
      }
   },
   getTextureBits ()
   {
      return (this .isLinear () << 3) | this .getTextureType ();
   },
   updateTextureBits (textureBits, channel = 0)
   {
      textureBits .add (channel * 4, this .getTextureBits ());
   },
   getShaderOptions (options, name = 0, ext = false)
   {
      if (typeof name === "number")
      {
         options .push (`X3D_TEXTURE_${name}_${this .getTextureTypeString ()}`);

         if (this .getTextureType () === 1)
            options .push (`X3D_TEXTURE_${name}_FLIP_Y`);

         if (this .isLinear ())
            options .push (`X3D_TEXTURE_${name}_LINEAR`);
      }
      else
      {
         ext = ext ? "_EXT" : "";

         options .push (`X3D_${name}_TEXTURE${ext}`, `X3D_${name}_TEXTURE${ext}_${this .getTextureTypeString ()}`);

         if (this .getTextureType () === 1)
            options .push (`X3D_${name}_TEXTURE${ext}_FLIP_Y`);

         if (this .isLinear ())
            options .push (`X3D_${name}_TEXTURE${ext}_LINEAR`);
      }
   },
   setNamedShaderUniforms (gl, uniformStruct, mapping, textureTransformMapping, textureCoordinateMapping)
   {
      this .setShaderUniforms (gl, uniformStruct);

      gl .uniform1i (uniformStruct .textureTransformMapping,  textureTransformMapping  .get (mapping) ?? 0);
      gl .uniform1i (uniformStruct .textureCoordinateMapping, textureCoordinateMapping .get (mapping) ?? 0);
   },
});

Object .defineProperties (X3DSingleTextureNode, _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .getStaticProperties ("X3DSingleTextureNode", "Texturing", 1));

const __default__ = X3DSingleTextureNode;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .add ("X3DSingleTextureNode", __default__));

/***/ },

/***/ 4386
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Fields_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(3515);
/* harmony import */ var _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(8450);
/* harmony import */ var _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(4946);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(6334);




const
   _cache                   = Symbol (),
   _autoRefreshStartTime    = Symbol (),
   _autoRefreshCompleteTime = Symbol (),
   _autoRefreshId           = Symbol ();

function X3DUrlObject (executionContext)
{
   this .addType (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .X3DUrlObject);

   this .addChildObjects (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .outputOnly, "loadState", new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFInt32 (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .NOT_STARTED_STATE),
                          _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .outputOnly, "loadData",  new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFTime ());

   this [_cache]                = true;
   this [_autoRefreshStartTime] = Date .now ();
}

Object .assign (X3DUrlObject .prototype,
{
   initialize ()
   {
      this .getLive () .addInterest ("set_live__", this);

      this ._load                 .addInterest ("set_load__",        this);
      this ._url                  .addInterest ("set_url__",         this);
      this ._loadData             .addInterest ("loadData",          this);
      this ._autoRefresh          .addInterest ("set_autoRefresh__", this);
      this ._autoRefreshTimeLimit .addInterest ("set_autoRefresh__", this);
   },
   getAllowEmptyUrl ()
   {
      return false;
   },
   setLoadState (value, notify = true)
   {
      this ._loadState = value;

      switch (value)
      {
         case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .COMPLETE_STATE:
         case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .FAILED_STATE:
         {
            this [_autoRefreshCompleteTime] = Date .now ();
            this .setAutoRefreshTimer (Math .max (this ._autoRefresh .getValue (), 0));
            break;
         }
      }

      if (!notify)
         return;

      switch (value)
      {
         case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .NOT_STARTED_STATE:
            break;
         case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .IN_PROGRESS_STATE:
         {
            this .getScene () .addLoadingObject (this);
            break;
         }
         case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .COMPLETE_STATE:
         case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .FAILED_STATE:
         {
            this .getScene () .removeLoadingObject (this);
            break;
         }
      }
   },
   checkLoadState ()
   {
      return this ._loadState .getValue ();
   },
   getLoadState ()
   {
      return this ._loadState;
   },
   setCache (value)
   {
      this [_cache] = value;
   },
   getCache ()
   {
      return this [_cache] && this .getBrowser () .getBrowserOption ("Cache");
   },
   async requestImmediateLoad (cache = true)
   {
      switch (this .checkLoadState ())
      {
         case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .IN_PROGRESS_STATE:
         {
            await this .loading ();
            return;
         }
         case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .COMPLETE_STATE:
         {
            return;
         }
         case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .FAILED_STATE:
         {
            throw new Error (`Failed loading ${this .getTypeName ()}.`);
         }
      }

      const browser = this .getBrowser ();

      if (!browser .getBrowserOption ("LoadUrlObjects") && this .getExecutionContext () !== browser .getPrivateScene ())
         return;

      if (!this ._load .getValue ())
         throw new Error (`${this .getTypeName ()}.load is false.`);

      if (this ._url .length === 0 && !this .getAllowEmptyUrl ())
      {
         this .unloadData ();
         return;
      }

      this .setCache (cache);
      this .setLoadState (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .IN_PROGRESS_STATE);

      if (this .isInitialized ())
         // Buffer prevents double load of the scene if load and url field are set at the same time.
         this ._loadData = this .getBrowser () .getCurrentTime ();
      else
         this .loadData ();

      await this .loading ();
   },
   loading ()
   {
      return new Promise ((resolve, reject) =>
      {
         const _loading = Symbol ();

         this ._loadState .addFieldCallback (_loading, () =>
         {
            switch (this .checkLoadState ())
            {
               case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .COMPLETE_STATE:
               {
                  this ._loadState .removeFieldCallback (_loading);
                  resolve ();
                  break;
               }
               case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .FAILED_STATE:
               {
                  this ._loadState .removeFieldCallback (_loading);
                  reject (new Error (`Failed loading ${this .getTypeName ()}.`));
                  break;
               }
            }
         });
      });
   },
   loadNow ()
   {
      this .setLoadState (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .NOT_STARTED_STATE);

      return this .requestImmediateLoad ();
   },
   loadData ()
   { },
   requestUnload ()
   {
      const loadState = this .checkLoadState ();

      if (loadState === _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .NOT_STARTED_STATE || loadState === _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .FAILED_STATE)
         return;

      this .setLoadState (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .NOT_STARTED_STATE);
      this .unloadData ();
   },
   unloadNow ()
   {
      this .requestUnload ();
   },
   unloadData ()
   { },
   setAutoRefreshTimer (autoRefreshInterval)
   {
      clearTimeout (this [_autoRefreshId]);

      if (this ._autoRefresh .getValue () <= 0)
         return;

      const autoRefreshTimeLimit = this ._autoRefreshTimeLimit .getValue ();

      if (autoRefreshTimeLimit > 0)
      {
         if ((Date .now () - this [_autoRefreshStartTime]) / 1000 > autoRefreshTimeLimit - autoRefreshInterval)
            return;
      }

      this [_autoRefreshId] = setTimeout (this .performAutoRefresh .bind (this), autoRefreshInterval * 1000);
   },
   performAutoRefresh ()
   {
      this .setLoadState (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .NOT_STARTED_STATE);
      this .requestImmediateLoad (false) .catch (Function .prototype);
   },
   set_live__ ()
   {
      if (this .getLive () .getValue ())
         this .set_autoRefresh__ ();
      else
         clearTimeout (this [_autoRefreshId]);
   },
   set_load__ ()
   {
      if (this ._load .getValue ())
         this .requestImmediateLoad () .catch (Function .prototype);
      else
         this .requestUnload ();
   },
   set_url__ ()
   {
      if (!this ._load .getValue ())
         return;

      this .setLoadState (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .NOT_STARTED_STATE);
      this .requestImmediateLoad () .catch (Function .prototype);
   },
   set_autoRefresh__ ()
   {
      if (this .checkLoadState () !== _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .COMPLETE_STATE)
         return;

      const
         elapsedTime = (Date .now () - this [_autoRefreshCompleteTime]) / 1000,
         autoRefresh = Math .max (this ._autoRefresh .getValue (), 0);

      let autoRefreshInterval = autoRefresh - elapsedTime;

      if (autoRefreshInterval < 0)
         autoRefreshInterval = Math .ceil (elapsedTime / autoRefresh) * autoRefresh - elapsedTime;

      this .setAutoRefreshTimer (autoRefreshInterval);
   },
   dispose () { },
});

Object .defineProperties (X3DUrlObject, _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .getStaticProperties ("X3DUrlObject", "Networking", 1));

const __default__ = X3DUrlObject;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .add ("X3DUrlObject", __default__));

/***/ },

/***/ 4398
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Base_X3DInfoArray_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(3046);
/* harmony import */ var _X3DProtoDeclaration_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(4492);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(6334);



function ProtoDeclarationArray (values = [ ])
{
   return _Base_X3DInfoArray_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .call (this, Array .from (values, value => [value .name, value]), _X3DProtoDeclaration_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A);
}

Object .setPrototypeOf (ProtoDeclarationArray .prototype, _Base_X3DInfoArray_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .prototype);

for (const key of Object .keys (ProtoDeclarationArray .prototype))
   Object .defineProperty (ProtoDeclarationArray .prototype, key, { enumerable: false });

Object .defineProperties (ProtoDeclarationArray,
{
   typeName:
   {
      value: "ProtoDeclarationArray",
      enumerable: true,
   },
});

const __default__ = ProtoDeclarationArray;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .add ("ProtoDeclarationArray", __default__));

/***/ },

/***/ 4458
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6334);
// Latest implemented specification version:

const __default__ = "4.0";
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .add ("LATEST_VERSION", __default__));

/***/ },

/***/ 4492
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Fields_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(3515);
/* harmony import */ var _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(2914);
/* harmony import */ var _Base_FieldDefinitionArray_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(9572);
/* harmony import */ var _Execution_X3DExecutionContext_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(8599);
/* harmony import */ var _X3DProtoDeclarationNode_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(2588);
/* harmony import */ var _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(4946);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(6334);







const
   _body = Symbol ();

function X3DProtoDeclaration (executionContext)
{
   _X3DProtoDeclarationNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .call (this, executionContext);

   this .addType (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .X3DProtoDeclaration);

   this [_body] = new _Execution_X3DExecutionContext_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A (executionContext, this);
   this [_body] .setLive (false);
   this .setLive (false);
}

Object .assign (Object .setPrototypeOf (X3DProtoDeclaration .prototype, _X3DProtoDeclarationNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .prototype),
{
   initialize ()
   {
      _X3DProtoDeclarationNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .prototype .initialize .call (this);

      this [_body] .setup ();
   },
   getProtoDeclaration ()
   {
      return this;
   },
   getBody ()
   {
      return this [_body];
   },
   getCloneCount ()
   {
      return _X3DProtoDeclarationNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .prototype .collectCloneCount .call (this);
   },
   collectCloneCount ()
   {
      return 1;
   },
   toVRMLStream (generator)
   {
      generator .Indent ();
      generator .string += "PROTO";
      generator .Space ();
      generator .string += this .getName ();
      generator .TidySpace ();
      generator .string += "[";

      const userDefinedFields = this .getUserDefinedFields ();

      if (userDefinedFields .length === 0)
      {
         generator .TidySpace ();
      }
      else
      {
         let
            fieldTypeLength  = 0,
            accessTypeLength = 0;

         for (const field of userDefinedFields)
         {
            fieldTypeLength  = Math .max (fieldTypeLength, field .getTypeName () .length);
            accessTypeLength = Math .max (accessTypeLength, generator .AccessType (field .getAccessType ()) .length);
         }

         generator .TidyBreak ();

         generator .IncIndent ();

         const last = userDefinedFields .at (-1);

         for (const field of userDefinedFields)
         {
            this .toVRMLStreamUserDefinedField (generator, field, fieldTypeLength, accessTypeLength);

            if (field === last)
               generator .TidyBreak ();
            else
               generator .Break ();
         }

         generator .DecIndent ();

         generator .Indent ();
      }

      generator .string += "]";
      generator .TidyBreak ();

      generator .Indent ();
      generator .string += "{";
      generator .TidyBreak ();

      generator .IncIndent ();

      this [_body] .toVRMLStream (generator);

      generator .DecIndent ();

      generator .Indent ();
      generator .string += "}";
   },
   toVRMLStreamUserDefinedField (generator, field, fieldTypeLength, accessTypeLength)
   {
      generator .Indent ();
      generator .string += generator .AccessType (field .getAccessType ()) .padEnd (accessTypeLength, generator .TidySpace ());
      generator .Space ();
      generator .string += field .getTypeName () .padEnd (fieldTypeLength, generator .TidySpace ());
      generator .Space ();
      generator .string += field .getName ();

      if (!field .isInitializable ())
         return;

      generator .Space ();

      field .toVRMLStream (generator);
   },
   toXMLStream (generator)
   {
      generator .openTag ("ProtoDeclare");
      generator .attribute ("name", this .getName ());

      if (this .getAppInfo ())
         generator .attribute ("appinfo", this .getAppInfo ());

      if (this .getDocumentation ())
         generator .attribute ("documentation", this .getDocumentation ());

      generator .endTag ();

      // <ProtoInterface>

      const userDefinedFields = this .getUserDefinedFields ();

      if (userDefinedFields .length !== 0)
      {
         generator .IncIndent ();
         generator .openingTag ("ProtoInterface");
         generator .TidyBreak ();
         generator .IncIndent ();

         for (const field of userDefinedFields)
         {
            generator .openTag ("field");
            generator .attribute ("accessType", generator .AccessType (field .getAccessType ()));
            generator .attribute ("type",       field .getTypeName ());
            generator .attribute ("name",       field .getName ());

            if (field .isDefaultValue () || !field .isInitializable ())
            {
               if (field .getAppInfo ())
                  generator .attribute ("appinfo", field .getAppInfo ());

               if (field .getDocumentation ())
                  generator .attribute ("documentation", field .getDocumentation ());

               generator .closeTag ("field");
               generator .TidyBreak ();
            }
            else
            {
               switch (field .getType ())
               {
                  case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .SFNode:
                  case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .MFNode:
                  {
                     if (field .getAppInfo ())
                        generator .attribute ("appinfo", field .getAppInfo ());

                     if (field .getDocumentation ())
                        generator .attribute ("documentation", field .getDocumentation ());

                     generator .endTag ();
                     generator .IncIndent ();
                     generator .PushContainerField (null);

                     field .toXMLStream (generator);

                     generator .TidyBreak ();
                     generator .DecIndent ();
                     generator .closingTag ("field");
                     generator .TidyBreak ();
                     generator .PopContainerField ();
                     break;
                  }
                  default:
                  {
                     generator .Space ();
                     generator .string += "value='";

                     field .toXMLStream (generator);

                     generator .string += "'";

                     if (field .getAppInfo ())
                        generator .attribute ("appinfo", field .getAppInfo ());

                     if (field .getDocumentation ())
                        generator .attribute ("documentation", field .getDocumentation ());

                     generator .closeTag ("field");
                     generator .TidyBreak ();
                     break;
                  }
               }
            }
         }

         generator .DecIndent ();
         generator .closingTag ("ProtoInterface");
         generator .TidyBreak ();
         generator .DecIndent ();
      }

      // </ProtoInterface>

      // <ProtoBody>

      generator .IncIndent ();
      generator .openingTag ("ProtoBody");
      generator .TidyBreak ();
      generator .IncIndent ();

      this [_body] .toXMLStream (generator);

      generator .DecIndent ();
      generator .closingTag ("ProtoBody");
      generator .TidyBreak ();
      generator .DecIndent ();

      // </ProtoBody>

      generator .closingTag ("ProtoDeclare");
   },
   toJSONStream (generator)
   {
      generator .TidyBreak ();
      generator .Indent ();

      generator .beginObject ("ProtoDeclare", false, true);
      generator .stringProperty ("@name", this .getName (), false);

      if (this .getAppInfo ())
         generator .stringProperty ("@appinfo", this .getAppInfo ());

      if (this .getDocumentation ())
         generator .stringProperty ("@documentation", this .getDocumentation ());

      // Fields

      generator .beginObject ("ProtoInterface");

      const userDefinedFields = this .getUserDefinedFields ();

      if (userDefinedFields .length)
      {
         generator .beginArray ("field", false);

         for (const field of userDefinedFields)
         {
            generator .beginObject ("", field !== userDefinedFields [0]);
            generator .stringProperty ("@accessType", generator .AccessType (field .getAccessType ()), false);
            generator .stringProperty ("@type",       field .getTypeName ());
            generator .stringProperty ("@name",       field .getName ());

            if (!field .isDefaultValue () && field .isInitializable ())
            {
               // Output value

               switch (field .getType ())
               {
                  case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .SFNode:
                  {
                     generator .beginArray ("-children");

                     generator .TidyBreak ();
                     generator .Indent ();

                     field .toJSONStream (generator);

                     generator .endArray ();
                     break;
                  }
                  case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .MFNode:
                  {
                     generator .beginValue ("-children", true);

                     field .toJSONStream (generator);
                     break;
                  }
                  default:
                  {
                     generator .beginValue ("@value", true);

                     field .toJSONStream (generator);
                     break;
                  }
               }
            }

            if (field .getAppInfo ())
               generator .stringProperty ("@appinfo", field .getAppInfo ());

            if (field .getDocumentation ())
               generator .stringProperty ("@documentation", field .getDocumentation ());

            generator .endObject ();
         }

         generator .endArray ();
      }

      generator .endObject ();

      // ProtoBody

      generator .beginObject ("ProtoBody");
      generator .beginArray ("-children", false);

      this [_body] .toJSONStream (generator);

      generator .endArray ();
      generator .endObject ();

      // End

      generator .endObject ();
      generator .endObject ();
   },
});

for (const key of Object .keys (X3DProtoDeclaration .prototype))
   Object .defineProperty (X3DProtoDeclaration .prototype, key, { enumerable: false });

Object .defineProperties (X3DProtoDeclaration .prototype,
{
   isExternProto:
   {
      value: false,
      enumerable: true,
   },
});

Object .defineProperties (X3DProtoDeclaration,
{
   typeName:
   {
      value: "X3DProtoDeclaration",
      enumerable: true,
   },
   fieldDefinitions:
   {
      value: new _Base_FieldDefinitionArray_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A ([
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .inputOutput, "metadata", new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFNode ()),
      ]),
      enumerable: true,
   },
});

_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .addConstant (X3DProtoDeclaration .typeName);

const __default__ = X3DProtoDeclaration;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .add ("X3DProtoDeclaration", __default__));

/***/ },

/***/ 4556
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Vector3_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(7910);
/* harmony import */ var _Matrix3_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(1224);
/* harmony import */ var _Algorithm_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(5370);
/* harmony import */ var _x_ite_Namespace_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(6334);




function Quaternion (x = 0, y = 0, z = 0, w = 1)
{
   this .x = x;
   this .y = y;
   this .z = z;
   this .w = w;
}

Object .assign (Quaternion .prototype,
{
   *[Symbol .iterator] ()
   {
      yield this .x;
      yield this .y;
      yield this .z;
      yield this .w;
   },
   copy ()
   {
      const copy = Object .create (Quaternion .prototype);
      copy .x = this .x;
      copy .y = this .y;
      copy .z = this .z;
      copy .w = this .w;
      return copy;
   },
   assign ({ x, y, z, w })
   {
      this .x = x;
      this .y = y;
      this .z = z;
      this .w = w;
      return this;
   },
   set (x = 0, y = 0, z = 0, w = 1)
   {
      this .x = x;
      this .y = y;
      this .z = z;
      this .w = w;
      return this;
   },
   setMatrix (matrix)
   {
      // First, find largest diagonal in matrix:

      const i = matrix [0] > matrix [4]
         ? matrix [0] > matrix [8] ? 0 : 2
         : matrix [4] > matrix [8] ? 1 : 2;

      const scaleRow = matrix [0] + matrix [4] + matrix [8];

      if (scaleRow > matrix [i * 3 + i])
      {
         // Compute w first:
         this [3] = Math .sqrt (scaleRow + 1) / 2;

         // And compute other values:
         const d = 4 * this [3];
         this [0] = (matrix [5] - matrix [7]) / d;
         this [1] = (matrix [6] - matrix [2]) / d;
         this [2] = (matrix [1] - matrix [3]) / d;
      }
      else
      {
         // Compute x, y, or z first:
         const j = (i + 1) % 3;
         const k = (i + 2) % 3;

         // Compute first value:
         this [i] = Math .sqrt (matrix [i * 3 + i] - matrix [j * 3 + j] - matrix [k * 3 + k] + 1) / 2;

         // And the others:
         const d = 4 * this [i];
         this [j] = (matrix [i * 3 + j] + matrix [j * 3 + i]) / d;
         this [k] = (matrix [i * 3 + k] + matrix [k * 3 + i]) / d;
         this [3] = (matrix [j * 3 + k] - matrix [k * 3 + j]) / d;
      }

      return this;
   },
   getMatrix (matrix = new _Matrix3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A ())
   {
      const { x, y, z, w } = this;

      const
         a = x * x,
         b = x * y,
         c = y * y,
         d = y * z,
         e = z * x,
         f = z * z,
         g = w * x,
         h = w * y,
         i = w * z;

      matrix [0] = 1 - 2 * (c + f);
      matrix [1] =     2 * (b + i);
      matrix [2] =     2 * (e - h);

      matrix [3] =     2 * (b - i);
      matrix [4] = 1 - 2 * (f + a);
      matrix [5] =     2 * (d + g);

      matrix [6] =     2 * (e + h);
      matrix [7] =     2 * (d - g);
      matrix [8] = 1 - 2 * (c + a);

      return matrix;
   },
   /**
    * Sets the Euler components.
    * @param {number} x - The angle of the x axis in radians.
    * @param {number} y - The angle of the y axis in radians.
    * @param {number} z - The angle of the z axis in radians.
    * @param {string} order - A string representing the order that the rotations are applied.
    * @returns {Quaternion} A reference to this quaternion.
    */
   setEuler (x, y, z, order = "XYZ")
   {
      // https://github.com/toji/gl-matrix/blob/accefb6ddf1897a0dc443bbc7664c90e67af6455/src/quat.js#L460

      x /= 2;
      y /= 2;
      z /= 2;

      const
         sx = Math .sin (x),
         sy = Math .sin (y),
         sz = Math .sin (z),
         cx = Math .cos (x),
         cy = Math .cos (y),
         cz = Math .cos (z);

      switch (order)
      {
         case "XYZ":
            this .x = sx * cy * cz + cx * sy * sz;
            this .y = cx * sy * cz - sx * cy * sz;
            this .z = cx * cy * sz + sx * sy * cz;
            this .w = cx * cy * cz - sx * sy * sz;
            break;

         case "ZYX":
            this .x = sx * cy * cz - cx * sy * sz;
            this .y = cx * sy * cz + sx * cy * sz;
            this .z = cx * cy * sz - sx * sy * cz;
            this .w = cx * cy * cz + sx * sy * sz;
            break;

         case "YXZ":
            this .x = sx * cy * cz + cx * sy * sz;
            this .y = cx * sy * cz - sx * cy * sz;
            this .z = cx * cy * sz - sx * sy * cz;
            this .w = cx * cy * cz + sx * sy * sz;
            break;

         case "ZXY":
            this .x = sx * cy * cz - cx * sy * sz;
            this .y = cx * sy * cz + sx * cy * sz;
            this .z = cx * cy * sz + sx * sy * cz;
            this .w = cx * cy * cz - sx * sy * sz;
            break;

         case "YZX":
            this .x = sx * cy * cz + cx * sy * sz;
            this .y = cx * sy * cz + sx * cy * sz;
            this .z = cx * cy * sz - sx * sy * cz;
            this .w = cx * cy * cz - sx * sy * sz;
            break;

         case "XZY":
            this .x = sx * cy * cz - cx * sy * sz;
            this .y = cx * sy * cz - sx * cy * sz;
            this .z = cx * cy * sz + sx * sy * cz;
            this .w = cx * cy * cz + sx * sy * sz;
            break;
      }

      return this;
   },
   /**
    * Gets the Euler components.
    * @param {number[]} euler - Array to be returned.
    * @param {string} order - A string representing the order that the rotations are applied.
    * @returns {number[]} The angles of the Euler rotations in radians.
    */
   getEuler (euler = [ ], order = "XYZ")
   {
      // https://github.com/mrdoob/three.js/blob/7a4f6b6637fbf10f1f36c9bb1f34b32452e516c6/src/math/Euler.js#L189

      const { 0: m0, 1: m1, 2: m2, 3: m3, 4: m4, 5: m5, 6: m6, 7: m7, 8: m8 } = this .getMatrix (m);

      switch (order)
      {
         case "XYZ":
         {
            euler [1] = Math .asin (_Algorithm_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .clamp (m6, -1, 1));

            if (Math .abs (m6) < 0.9999999)
            {
               euler [0] = Math .atan2 (-m7, m8);
               euler [2] = Math .atan2 (-m3, m0);
            }
            else
            {
               euler [0] = Math .atan2 (m5, m4);
               euler [2] = 0;
            }

            break;
         }
         case "ZYX":
         {
            euler [1] = Math .asin (-_Algorithm_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .clamp (m2, -1, 1));

            if (Math .abs (m2) < 0.9999999)
            {
               euler [0] = Math .atan2 (m5, m8);
               euler [2] = Math .atan2 (m1, m0);
            }
            else
            {
               euler [0] = 0;
               euler [2] = Math .atan2 (-m3, m4);
            }

            break;
         }
         case "YXZ":
         {
            euler [0] = Math .asin (-_Algorithm_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .clamp (m7, -1, 1));

            if (Math .abs (m7) < 0.9999999)
            {
               euler [1] = Math .atan2 (m6, m8);
               euler [2] = Math .atan2 (m1, m4);

            }
            else
            {
               euler [1] = Math .atan2 (-m2, m0);
               euler [2] = 0;
            }

            break;
         }
         case "ZXY":
         {
            euler [0] = Math .asin (_Algorithm_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .clamp (m5, -1, 1));

            if (Math .abs (m5) < 0.9999999)
            {
               euler [1] = Math .atan2 (-m2, m8);
               euler [2] = Math .atan2 (-m3, m4);
            }
            else
            {
               euler [1] = 0;
               euler [2] = Math .atan2 (m1, m0);
            }

            break;
         }
         case "YZX":
         {
            euler [2] = Math .asin (_Algorithm_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .clamp (m1, -1, 1));

            if (Math .abs (m1) < 0.9999999)
            {
               euler [0] = Math .atan2 (-m7, m4);
               euler [1] = Math .atan2 (-m2, m0);
            }
            else
            {
               euler [0] = 0;
               euler [1] = Math .atan2 (m6, m8);
            }

            break;
         }
         case "XZY":
         {
            euler [2] = Math .asin (-_Algorithm_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .clamp (m3, -1, 1));

            if (Math .abs (m3) < 0.9999999)
            {
               euler [0] = Math .atan2 (m5, m4);
               euler [1] = Math .atan2 (m6, m0);

            }
            else
            {
               euler [0] = Math .atan2 (-m7, m8);
               euler [1] = 0;
            }

            break;
         }
      }

      return euler;
   },
   isReal ()
   {
      return !(this .x || this .y || this .z);
   },
   isImag ()
   {
      return !this .w;
   },
   equals ({ x, y, z, w })
   {
      return this .x === x &&
             this .y === y &&
             this .z === z &&
             this .w === w;
   },
   negate ()
   {
      this .x = -this .x;
      this .y = -this .y;
      this .z = -this .z;
      this .w = -this .w;
      return this;
   },
   inverse ()
   {
      this .x = -this .x;
      this .y = -this .y;
      this .z = -this .z;
      return this;
   },
   add ({ x, y, z, w })
   {
      this .x += x;
      this .y += y;
      this .z += z;
      this .w += w;
      return this;
   },
   subtract ({ x, y, z, w })
   {
      this .x -= x;
      this .y -= y;
      this .z -= z;
      this .w -= w;
      return this;
   },
   multiply (value)
   {
      this .x *= value;
      this .y *= value;
      this .z *= value;
      this .w *= value;
      return this;
   },
   multLeft (quat)
   {
      const
         { x: ax, y: ay, z: az, w: aw } = this,
         { x: bx, y: by, z: bz, w: bw } = quat;

      this .x = aw * bx + ax * bw + ay * bz - az * by;
      this .y = aw * by + ay * bw + az * bx - ax * bz;
      this .z = aw * bz + az * bw + ax * by - ay * bx;
      this .w = aw * bw - ax * bx - ay * by - az * bz;

      return this;
   },
   multRight (quat)
   {
      const
         { x: ax, y: ay, z: az, w: aw } = this,
         { x: bx, y: by, z: bz, w: bw } = quat;

      this .x = bw * ax + bx * aw + by * az - bz * ay;
      this .y = bw * ay + by * aw + bz * ax - bx * az;
      this .z = bw * az + bz * aw + bx * ay - by * ax;
      this .w = bw * aw - bx * ax - by * ay - bz * az;

      return this;
   },
   divide (value)
   {
      this .x /= value;
      this .y /= value;
      this .z /= value;
      this .w /= value;
      return this;
   },
   multVecQuat (vector)
   {
      // https://en.wikipedia.org/wiki/Conversion_between_quaternions_and_Euler_angles#Vector_rotation

      const
         { x: qx, y: qy, z: qz, w: qw } = this,
         { x: vx, y: vy, z: vz } = vector,
         tx = 2 * (qy * vz - qz * vy),
         ty = 2 * (qz * vx - qx * vz),
         tz = 2 * (qx * vy - qy * vx);

      vector .x += qw * tx + qy * tz - qz * ty;
      vector .y += qw * ty + qz * tx - qx * tz;
      vector .z += qw * tz + qx * ty - qy * tx;

      return vector;
   },
   multQuatVec (vector)
   {
      // https://en.wikipedia.org/wiki/Conversion_between_quaternions_and_Euler_angles#Vector_rotation

      const
         { x: qx, y: qy, z: qz, w: qw } = this,
         { x: vx, y: vy, z: vz } = vector,
         tx = 2 * (qz * vy - qy * vz),
         ty = 2 * (qx * vz - qz * vx),
         tz = 2 * (qy * vx - qx * vy);

      vector .x += qw * tx - qy * tz + qz * ty;
      vector .y += qw * ty - qz * tx + qx * tz;
      vector .z += qw * tz - qx * ty + qy * tx;

      return vector;
   },
   normalize ()
   {
      const length = Math .hypot (this .x, this .y, this .z, this .w);

      if (length)
      {
         this .x /= length;
         this .y /= length;
         this .z /= length;
         this .w /= length;
      }

      return this;
   },
   dot (quat)
   {
      return this .x * quat .x +
             this .y * quat .y +
             this .z * quat .z +
             this .w * quat .w;
   },
   squaredNorm ()
   {
      const { x, y, z, w } = this;

      return x * x +
             y * y +
             z * z +
             w * w;
   },
   norm ()
   {
      return Math .hypot (this .x, this .y, this .z, this .w);
   },
   pow (exponent)
   {
      if (exponent instanceof Quaternion)
         return this .assign (e .assign (exponent) .multRight (this .log ()) .exp ());

      if (this .isReal ())
         return this .set (0, 0, 0, this .w ** exponent);

      const
         l     = this .norm (),
         theta = Math .acos (this .w / l),
         li    = this .imag .norm (),
         ltoe  = l ** exponent,
         et    = exponent * theta,
         scale = ltoe / li * Math .sin (et);

      this .x *= scale;
      this .y *= scale;
      this .z *= scale;
      this .w  = ltoe * Math .cos (et);
      return this;
   },
   log ()
   {
      if (this .isReal ())
      {
         if (this .w > 0)
            return this .set (0, 0, 0, Math .log (this .w));

         else
            return this .set (Math .PI, 0, 0, Math .log (-this .w));
      }

      const
         l = this .norm (),
         v = this .imag .normalize () .multiply (Math .acos (this .w / l)),
         w = Math .log (l);

      this .x = v .x;
      this .y = v .y;
      this .z = v .z;
      this .w = w;
      return this;
   },
   exp ()
   {
      if (this .isReal ())
         return this .set (0, 0, 0, Math .exp (this .w));

      const
         i  = this .imag,
         li = i .norm (),
         ew = Math .exp (this .w),
         w  = ew * Math .cos (li),
         v  = i .multiply (ew * Math .sin (li) / li);

      this .x = v .x;
      this .y = v .y;
      this .z = v .z;
      this .w = w;
      return this;
   },
   slerp (destination, t)
   {
      return _Algorithm_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .slerp (this, t1 .assign (destination), t);
   },
   squad (a, b, destination, t)
   {
      // Ken Shoemake defines Squad as:
      // We must use shortest path slerp to prevent flipping. See also spline below.
      // a = spline (si-1, si, si+1) and b = spline (di-1, di, di+1), where si = source and di = destination

      return _Algorithm_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .slerp (_Algorithm_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .slerp (this, t1 .assign (destination), t),
                               _Algorithm_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .slerp (t2 .assign (a), t3 .assign (b), t),
                               2 * t * (1 - t));
   },
   toString ()
   {
      return this .x + " " +
             this .y + " " +
             this .z + " " +
             this .w;
   },
});

for (const key of Object .keys (Quaternion .prototype))
   Object .defineProperty (Quaternion .prototype, key, { enumerable: false });

Object .defineProperties (Quaternion .prototype,
{
   length: { value: 4 },
   0:
   {
      get () { return this .x; },
      set (value) { this .x = value; },
   },
   1:
   {
      get () { return this .y; },
      set (value) { this .y = value; },
   },
   2:
   {
      get () { return this .z; },
      set (value) { this .z = value; },
   },
   3:
   {
      get () { return this .w; },
      set (value) { this .w = value; },
   },
   real:
   {
      get () { return this .w; },
   },
   imag:
   {
      get: (() =>
      {
         const result = new _Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A ();

         return function ()
         {
            return result .set (this .x,
                                this .y,
                                this .z);
         };
      })(),
   },
});

Object .assign (Quaternion,
{
   IDENTITY: Object .freeze (new Quaternion ()),
   spline: (() =>
   {
      const
         q0   = new Quaternion (),
         q1   = new Quaternion (),
         q2   = new Quaternion (),
         q1_i = new Quaternion ();

      return function (Q0, Q1, Q2)
      {
         q0 .assign (Q0);
         q1 .assign (Q1);
         q2 .assign (Q2);

         // If the dot product is smaller than 0 we must negate the quaternion to prevent flipping. If we negate all
         // the terms we get a different quaternion but it represents the same rotation.

         if (q0 .dot (q1) < 0)
            q0 .negate ();

         if (q2 .dot (q1) < 0)
            q2 .negate ();

         q1_i .assign (q1) .inverse ();

         // The result must be normalized as it will be used in slerp and we can only slerp normalized vectors.

         return q1 .multRight (
            t1 .assign (q1_i) .multRight (q0) .log () .add (t2 .assign (q1_i) .multRight (q2) .log ()) .divide (-4) .exp ()
         )
         .normalize () .copy ();
      };
   })(),
});

const
   t1 = new Quaternion (),
   t2 = new Quaternion (),
   t3 = new Quaternion (),
   m  = new _Matrix3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A ();

const __default__ = Quaternion;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_x_ite_Namespace_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .add ("Quaternion", __default__));

/***/ },

/***/ 4580
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Quaternion_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(4556);
/* harmony import */ var _Vector3_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(7910);
/* harmony import */ var _Vector4_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(7591);
/* harmony import */ var _Matrix3_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(1224);
/* harmony import */ var _Algorithm_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(5370);
/* harmony import */ var _x_ite_Namespace_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(6334);






const
   _x          = Symbol (),
   _y          = Symbol (),
   _z          = Symbol (),
   _angle      = Symbol (),
   _quaternion = Symbol ();

function Rotation4 (x, y, z, angle)
{
   this [_x]     = 0;
   this [_y]     = 0;
   this [_z]     = 1;
   this [_angle] = 0;

   switch (arguments .length)
   {
      case 0:
      {
         this [_quaternion] = new _Quaternion_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A ();
         return;
      }
      case 1:
      {
         this [_quaternion] = arguments [0];
         this .update ();
         return;
      }
      case 2:
      {
         const
            arg0 = arguments [0],
            arg1 = arguments [1];

         this [_quaternion] = new _Quaternion_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A ();

         if (arg1 instanceof _Vector3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A)
            return this .setFromToVec (arg0, arg1);

         this .set (arg0 .x,
                    arg0 .y,
                    arg0 .z,
                    arg1);

         return;
      }
      case 4:
      {
         this [_quaternion] = new _Quaternion_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A ();
         this .set (x, y, z, angle);
         return;
      }
   }
}

Object .assign (Rotation4 .prototype,
{
   *[Symbol .iterator] ()
   {
      yield this [_x];
      yield this [_y];
      yield this [_z];
      yield this [_angle];
   },
   update ()
   {
      const rotation = this .get ();

      this [_x]     = rotation .x;
      this [_y]     = rotation .y;
      this [_z]     = rotation .z;
      this [_angle] = rotation .w;

      return this;
   },
   copy ()
   {
      const copy = Object .create (Rotation4 .prototype);

      copy [_x]     = this [_x];
      copy [_y]     = this [_y];
      copy [_z]     = this [_z];
      copy [_angle] = this [_angle];

      copy [_quaternion] = this [_quaternion] .copy ();

      return copy;
   },
   assign (rotation)
   {
      this [_x]     = rotation [_x];
      this [_y]     = rotation [_y];
      this [_z]     = rotation [_z];
      this [_angle] = rotation [_angle];

      this [_quaternion] .assign (rotation [_quaternion]);

      return this;
   },
   set (x = 0, y = 0, z = 1, angle = 0)
   {
      this [_x]     = x;
      this [_y]     = y;
      this [_z]     = z;
      this [_angle] = angle;

      const scale = Math .hypot (x, y, z);

      if (scale === 0)
      {
         this [_quaternion] .set (0, 0, 0, 1);
         return this;
      }

      // Calculate quaternion

      const
         halfTheta = _Algorithm_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .interval (angle / 2, 0, Math .PI),
         ascale    = Math .sin (halfTheta) / scale;

      this [_quaternion] .set (x * ascale,
                               y * ascale,
                               z * ascale,
                               Math .cos (halfTheta));
      return this;
   },
   get: (() =>
   {
      const result = new _Vector4_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A ();

      return function ()
      {
         const quaternion = this [_quaternion];

         if (Math .abs (quaternion .w) > 1)
         {
            return _Vector4_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .Z_AXIS;
         }
         else
         {
            const
               angle = Math .acos (quaternion .w) * 2,
               scale = Math .sin (angle / 2);

            if (scale === 0)
            {
               return _Vector4_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .Z_AXIS;
            }
            else
            {
               const axis = quaternion .imag .divide (scale);

               return result .set (axis .x,
                                   axis .y,
                                   axis .z,
                                   angle);
            }
         }
      };
   })(),
   setAxisAngle (axis, angle)
   {
      return this .set (axis .x, axis .y, axis .z, angle);
   },
   setFromToVec: (() =>
   {
      const
         from = new _Vector3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (),
         to   = new _Vector3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (),
         cv   = new _Vector3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (),
         t    = new _Vector3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A ();

      return function (fromVec, toVec)
      {
         // https://bitbucket.org/Coin3D/coin/src/abc9f50968c9/src/base/SbRotation.cpp

         from .assign (fromVec) .normalize ();
         to   .assign (toVec)   .normalize ();

         const
            cos_angle = _Algorithm_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .clamp (from .dot (to), -1, 1),
            crossvec  = cv .assign (from) .cross (to) .normalize (),
            crosslen  = crossvec .norm ();

         if (crosslen === 0)
         {
            // Parallel vectors
            // Check if they are pointing in the same direction.
            if (cos_angle > 0)
               this [_quaternion] .set (0, 0, 0, 1); // standard rotation

            // Ok, so they are parallel and pointing in the opposite direction
            // of each other.
            else
            {
               // Try crossing with x axis.
               t .assign (from) .cross (_Vector3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .X_AXIS);

               // If not ok, cross with y axis.
               if (t .squaredNorm () === 0)
                  t .assign (from) .cross (_Vector3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .Y_AXIS);

               t .normalize ();

               this [_quaternion] .set (t .x, t .y, t .z, 0);
            }
         }
         else
         {
            // Vectors are not parallel
            // The abs () wrapping is to avoid problems when `dot' "overflows" a tiny wee bit,
            // which can lead to sqrt () returning NaN.
            crossvec .multiply (Math .sqrt (Math .abs (1 - cos_angle) / 2));

            this [_quaternion] .set (crossvec .x,
                                     crossvec .y,
                                     crossvec .z,
                                     Math .sqrt (Math .abs (1 + cos_angle) / 2));
         }

         this .update ();

         return this;
      };
   })(),
   setAxis (vector)
   {
      this .set (vector .x, vector .y, vector .z, this [_angle]);
   },
   getAxis (axis = new _Vector3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A ())
   {
      return axis .set (this [_x], this [_y], this [_z]);
   },
   setQuaternion (quaternion)
   {
      this [_quaternion] .assign (quaternion) .normalize ();
      this .update ();
      return this;
   },
   getQuaternion (quaternion = new _Quaternion_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A ())
   {
      return quaternion .assign (this [_quaternion]);
   },
   setMatrix (matrix)
   {
      this [_quaternion] .setMatrix (matrix) .normalize ();
      this .update ();
      return this;
   },
   getMatrix (matrix = new _Matrix3_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A ())
   {
      return this [_quaternion] .getMatrix (matrix);
   },
   setEuler (x, y, z, order = "XYZ")
   {
      // Quaternion is then already normalized.
      this [_quaternion] .setEuler (x, y, z, order);
      this .update ();
      return this;
   },
   getEuler (euler = [ ], order = "XYZ")
   {
      return this [_quaternion] .getEuler (euler, order);
   },
   equals (rotation)
   {
      return this [_quaternion] .equals (rotation [_quaternion]);
   },
   inverse ()
   {
      this [_quaternion] .inverse ();
      this .update ();
      return this;
   },
   multLeft (rotation)
   {
      this [_quaternion] .multLeft (rotation [_quaternion]) .normalize ();
      this .update ();
      return this;
   },
   multRight (rotation)
   {
      this [_quaternion] .multRight (rotation [_quaternion]) .normalize ();
      this .update ();
      return this;
   },
   multVecRot (vector)
   {
      return this [_quaternion] .multVecQuat (vector);
   },
   multRotVec (vector)
   {
      return this [_quaternion] .multQuatVec (vector);
   },
   normalize ()
   {
      this [_quaternion] .normalize ();
      this .update ();
      return this;
   },
   pow (exponent)
   {
      this [_quaternion] .pow (exponent);
      this .update ();
      return this;
   },
   slerp (dest, t)
   {
      this [_quaternion] .slerp (dest [_quaternion], t);
      this .update ();
      return this;
   },
   squad (a, b, dest, t)
   {
      this [_quaternion] .squad (a [_quaternion], b [_quaternion], dest [_quaternion], t);
      this .update ();
      return this;
   },
   /**
    * Straightens the rotation so that the x-axis of this rotation is parallel to the plane spawned by upVector.
    */
   straighten: (() =>
   {
      const
         localXAxis = new _Vector3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (),
         localZAxis = new _Vector3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (),
         upNormal   = new _Vector3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (),
         rotation   = new Rotation4 ();

      return function (upVector = _Vector3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .Y_AXIS)
      {
         upNormal .assign (upVector) .normalize ();

         this .multVecRot (localXAxis .assign (_Vector3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .X_AXIS) .negate ());
         this .multVecRot (localZAxis .assign (_Vector3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .Z_AXIS));

         // If viewer looks along up vector.
         if (Math .abs (localZAxis .dot (upNormal)) >= 1)
            return this;

         const newXAxis = localZAxis .cross (upNormal) .normalize ();

         if (newXAxis .dot (localXAxis) <= -1)
         {
            rotation .setAxisAngle (_Vector3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .Z_AXIS, Math .PI);

            return this .multLeft (rotation);
         }
         else
         {
            rotation .setFromToVec (localXAxis, newXAxis);

            return this .multRight (rotation);
         }
      };
   })(),
   toString ()
   {
      return this [_x] + " " +
             this [_y] + " " +
             this [_z] + " " +
             this [_angle];
   }
});

for (const key of Object .keys (Rotation4 .prototype))
   Object .defineProperty (Rotation4 .prototype, key, { enumerable: false });

const x = {
   get ()
   {
      return this [_x];
   },
   set (x)
   {
      this [_x] = x;
      this .set (x, this [_y], this [_z], this [_angle]);
   },
   enumerable: true,
};

const y = {
   get ()
   {
      return this [_y];
   },
   set (y)
   {
      this [_y] = y;
      this .set (this [_x], y, this [_z], this [_angle]);
   },
   enumerable: true,
};

const z = {
   get ()
   {
      return this [_z];
   },
   set (z)
   {
      this [_z] = z;
      this .set (this [_x], this [_y], z, this [_angle]);
   },
   enumerable: true,
};

const angle = {
   get ()
   {
      return this [_angle];
   },
   set (angle)
   {
      this [_angle] = angle;
      this .set (this [_x], this [_y], this [_z], angle);
   },
   enumerable: true,
};

Object .defineProperties (Rotation4 .prototype,
{
   length: { value: 4 },
   x: x,
   y: y,
   z: z,
   angle: angle,
});

x     .enumerable = false;
y     .enumerable = false;
z     .enumerable = false;
angle .enumerable = false;

Object .defineProperties (Rotation4 .prototype,
{
   0: x,
   1: y,
   2: z,
   3: angle,
});

Object .assign (Rotation4,
{
   IDENTITY: Object .freeze (new Rotation4 ()),
   fromQuaternion (quaternion)
   {
      return new Rotation4 () .setQuaternion (quaternion);
   },
   fromMatrix (matrix)
   {
      return new Rotation4 () .setMatrix (matrix);
   },
   fromEuler (x, y, z, order = "XYZ")
   {
      return new Rotation4 () .setEuler (x, y, z, order);
   },
   spline (r0, r1, r2)
   {
      const copy = Object .create (this .prototype);
      copy [_quaternion] = _Quaternion_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .spline (r0 [_quaternion], r1 [_quaternion], r2 [_quaternion]);
      copy .update ();
      return copy;
   },
});

const __default__ = Rotation4;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_x_ite_Namespace_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .add ("Rotation4", __default__));

/***/ },

/***/ 4609
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Base_X3DObject_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(7092);
/* harmony import */ var _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(4946);
/* harmony import */ var _Fields_SFNodeCache_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(7149);
/* harmony import */ var _Components_Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(8450);
/* harmony import */ var _Execution_X3DImportedNode_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(4850);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(6334);
/* provided dependency */ var $ = __webpack_require__(4993);






const
   _executionContext     = Symbol (),
   _sourceNode           = Symbol (),
   _sourceFieldName      = Symbol (),
   _sourceField          = Symbol (),
   _destinationNode      = Symbol (),
   _destinationFieldName = Symbol (),
   _destinationField     = Symbol (),
   _disposed             = Symbol ();

function X3DRoute (executionContext, sourceNode, sourceFieldName, destinationNode, destinationFieldName)
{
   _Base_X3DObject_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .call (this, executionContext);

   this [_executionContext]     = executionContext;
   this [_sourceNode]           = sourceNode;
   this [_sourceFieldName]      = sourceFieldName;
   this [_destinationNode]      = destinationNode;
   this [_destinationFieldName] = destinationFieldName;

   if (sourceNode instanceof _Execution_X3DImportedNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A)
      sourceNode .getInlineNode () ._loadState .addInterest ("reconnect", this);

   if (destinationNode instanceof _Execution_X3DImportedNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A)
      destinationNode .getInlineNode () ._loadState .addInterest ("reconnect", this);

   this .reconnect ();
}

Object .assign (Object .setPrototypeOf (X3DRoute .prototype, _Base_X3DObject_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .prototype),
{
   getExecutionContext ()
   {
      return this [_executionContext];
   },
   getRouteId ()
   {
      return X3DRoute .getRouteId (this [_sourceNode], this [_sourceFieldName], this [_destinationNode], this [_destinationFieldName]);
   },
   getSourceNode ()
   {
      ///  SAI

      if (this [_sourceNode] instanceof _Execution_X3DImportedNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A)
         return this [_sourceNode] .getExportedNode ();

      return this [_sourceNode];
   },
   getSourceField ()
   {
      ///  SAI

      if (this [_sourceField])
      {
         return this [_sourceField] .getAccessType () === _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .inputOutput
            ? this [_sourceField] .getName () + "_changed"
            : this [_sourceField] .getName ();
      }
      else
      {
         return this [_sourceFieldName];
      }

   },
   getDestinationNode ()
   {
      ///  SAI

      if (this [_destinationNode] instanceof _Execution_X3DImportedNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A)
         return this [_destinationNode] .getExportedNode ();

      return this [_destinationNode];
   },
   getDestinationField ()
   {
      ///  SAI

      if (this [_destinationField])
      {
         return this [_destinationField] .getAccessType () === _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .inputOutput
            ? "set_" + this [_destinationField] .getName ()
            : this [_destinationField] .getName ();
      }
      else
      {
         return this [_destinationFieldName];
      }
   },
   reconnect ()
   {
      try
      {
         this .disconnect ();
         this .connect ();
      }
      catch (error)
      {
         if ((this [_sourceNode] instanceof _Components_Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A ||
              this [_sourceNode] .getInlineNode () .checkLoadState () === _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .COMPLETE_STATE) &&
             (this [_destinationNode] instanceof _Components_Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A ||
              this [_destinationNode] .getInlineNode () .checkLoadState () === _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .COMPLETE_STATE))
         {
            console .warn (error);
         }
      }
   },
   connect ()
   {
      if (this [_disposed])
         return;

      let firstError, secondError;

      try
      {
         const sourceNode = this [_sourceNode] instanceof _Components_Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A
            ? this [_sourceNode]
            : this [_sourceNode] .getExportedNode ();

         this [_sourceField] = sourceNode .getField (this [_sourceFieldName]);
      }
      catch (error)
      {
         firstError = error;
      }

      try
      {
         const destinationNode = this [_destinationNode] instanceof _Components_Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A
            ? this [_destinationNode]
            : this [_destinationNode] .getExportedNode ();

         this [_destinationField] = destinationNode .getField (this [_destinationFieldName]);
      }
      catch (error)
      {
         secondError = error;
      }

      if (this [_sourceField] && this [_destinationField])
      {
         if (this [_sourceField] .getType () !== this [_destinationField] .getType ())
            throw new Error (`Bad ROUTE statement: Source field type must match destination field type of fields named "${this [_sourceField] .getName ()}" and "${this [_destinationField] .getName ()}".`);

         if (!this [_sourceField] .isOutput ())
            throw new Error (`Bad ROUTE statement: Source field "${this [_sourceField] .getName ()}" must be an output.`);

         if (!this [_destinationField] .isInput ())
            throw new Error (`Bad ROUTE statement: Destination field "${this [_destinationField] .getName ()}" must be an input.`);

         this [_sourceField]      .addOutputRoute (this);
         this [_destinationField] .addInputRoute (this);
         this [_sourceField]      .addFieldInterest (this [_destinationField]);
      }
      else
      {
         throw firstError ?? secondError;
      }
   },
   disconnect ()
   {
      this [_sourceField]      ?.removeOutputRoute (this);
      this [_destinationField] ?.removeInputRoute (this);

      if (this [_sourceField] && this [_destinationField])
         this [_sourceField] .removeFieldInterest (this [_destinationField]);

      this [_sourceField]      = null;
      this [_destinationField] = null;
   },
   toVRMLStream (generator)
   {
      if (!generator .ExistsRouteNode (this [_sourceNode]))
         throw new Error (`Source node does not exist in scene graph.`);

      if (!generator .ExistsRouteNode (this [_destinationNode]))
         throw new Error (`Destination node does not exist in scene graph.`);

      const sourceNodeName = this [_sourceNode] instanceof _Components_Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A
         ? generator .Name (this [_sourceNode])
         : generator .ImportedName (this [_sourceNode]);

      const destinationNodeName = this [_destinationNode] instanceof _Components_Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A
         ? generator .Name (this [_destinationNode])
         : generator .ImportedName (this [_destinationNode]);

      generator .Indent ();
      generator .string += "ROUTE";
      generator .Space ();
      generator .string += sourceNodeName;
      generator .string += ".";
      generator .string += this .getSourceField ();
      generator .Space ();
      generator .string += "TO";
      generator .Space ();
      generator .string += destinationNodeName;
      generator .string += ".";
      generator .string += this .getDestinationField ();
   },
   toXMLStream (generator)
   {
      if (!generator .ExistsRouteNode (this [_sourceNode]))
         throw new Error (`Source node does not exist in scene graph.`);

      if (!generator .ExistsRouteNode (this [_destinationNode]))
         throw new Error (`Destination node does not exist in scene graph.`);

      const sourceNodeName = this [_sourceNode] instanceof _Components_Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A
         ? generator .Name (this [_sourceNode])
         : generator .ImportedName (this [_sourceNode]);

      const destinationNodeName = this [_destinationNode] instanceof _Components_Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A
         ? generator .Name (this [_destinationNode])
         : generator .ImportedName (this [_destinationNode]);

      generator .openTag ("ROUTE");
      generator .attribute ("fromNode",  sourceNodeName);
      generator .attribute ("fromField", this .getSourceField ());
      generator .attribute ("toNode",    destinationNodeName);
      generator .attribute ("toField",   this .getDestinationField ());
      generator .closeTag ("ROUTE");
   },
   toJSONStream (generator)
   {
      if (!generator .ExistsRouteNode (this [_sourceNode]))
         throw new Error (`Source node does not exist in scene graph.`);

      if (!generator .ExistsRouteNode (this [_destinationNode]))
         throw new Error (`Destination node does not exist in scene graph.`);

      const sourceNodeName = this [_sourceNode] instanceof _Components_Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A
         ? generator .Name (this [_sourceNode])
         : generator .ImportedName (this [_sourceNode]);

      const destinationNodeName = this [_destinationNode] instanceof _Components_Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A
         ? generator .Name (this [_destinationNode])
         : generator .ImportedName (this [_destinationNode]);

      generator .TidyBreak ();
      generator .Indent ();

      generator .beginObject ("ROUTE", false, true);

      generator .stringProperty ("@fromNode",  sourceNodeName, false);
      generator .stringProperty ("@fromField", this .getSourceField ());
      generator .stringProperty ("@toNode",    destinationNodeName);
      generator .stringProperty ("@toField",   this .getDestinationField ());

      generator .endObject ();
      generator .endObject ();
   },
   dispose ()
   {
      if (this [_disposed])
         return;

      this [_disposed] = true;

      this .disconnect ();

      if (this [_sourceNode] instanceof _Execution_X3DImportedNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A)
         this [_sourceNode] .getInlineNode () ._loadState .removeInterest ("reconnect", this);

      if (this [_destinationNode] instanceof _Execution_X3DImportedNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A)
         this [_destinationNode] .getInlineNode () ._loadState .removeInterest ("reconnect", this);

      this [_executionContext] .deleteRoute (this);

      _Base_X3DObject_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .prototype .dispose .call (this);
   }
});

for (const key of Object .keys (X3DRoute .prototype))
   Object .defineProperty (X3DRoute .prototype, key, { enumerable: false });

Object .defineProperties (X3DRoute .prototype,
{
   sourceNode:
   {
      get ()
      {
         return _Fields_SFNodeCache_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .get (this .getSourceNode ());
      },
      enumerable: true,
   },
   sourceField:
   {
      get: X3DRoute .prototype .getSourceField,
      enumerable: true,
   },
   destinationNode:
   {
      get ()
      {
         return _Fields_SFNodeCache_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .get (this .getDestinationNode ());
      },
      enumerable: true,
   },
   destinationField:
   {
      get: X3DRoute .prototype .getDestinationField,
      enumerable: true,
   },
});

Object .defineProperties (X3DRoute,
{
   typeName:
   {
      value: "X3DRoute",
      enumerable: true,
   },
});

Object .assign (X3DRoute,
{
   getRouteId (sourceNode, sourceFieldName, destinationNode, destinationFieldName)
   {
      const sourceField = sourceNode instanceof _Components_Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A
         ? sourceNode .getField (sourceFieldName)
         : $.try (() => sourceNode .getExportedNode () .getField (sourceFieldName));

      const destinationField = destinationNode instanceof _Components_Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A
         ? destinationNode .getField (destinationFieldName)
         : $.try (() => destinationNode .getExportedNode () .getField (destinationFieldName));

      if (sourceField)
      {
         sourceFieldName = sourceField .getName ();

         if (sourceField .getAccessType () === _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .inputOutput)
            sourceFieldName += "_changed";
      }

      if (destinationField)
      {
         destinationFieldName = destinationField .getName ();

         if (destinationField .getAccessType () === _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .inputOutput)
            destinationFieldName = "set_" + destinationFieldName;
      }

      return `${sourceNode .getId ()}.${sourceFieldName}.${destinationNode .getId ()}.${destinationFieldName}`;
   },
});

const __default__ = X3DRoute;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .add ("X3DRoute", __default__));

/***/ },

/***/ 4611
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Fields_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(3515);
/* harmony import */ var _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(2914);
/* harmony import */ var _Base_FieldDefinitionArray_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(9572);
/* harmony import */ var _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(8450);
/* harmony import */ var _X3DInterpolatorNode_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(3066);
/* harmony import */ var _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(4946);
/* harmony import */ var _standard_Math_Numbers_Rotation4_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(4580);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(6334);








function OrientationInterpolator (executionContext)
{
   _X3DInterpolatorNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .call (this, executionContext);

   this .addType (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .OrientationInterpolator);

   // Units

   this ._keyValue      .setUnit ("angle");
   this ._value_changed .setUnit ("angle");
}

Object .assign (Object .setPrototypeOf (OrientationInterpolator .prototype, _X3DInterpolatorNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .prototype),
{
   initialize ()
   {
      _X3DInterpolatorNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .prototype .initialize .call (this);

      this ._keyValue .addInterest ("set_keyValue__", this);
   },
   set_keyValue__ ()
   {
      const
         key      = this ._key,
         keyValue = this ._keyValue;

      if (keyValue .length < key .length)
         keyValue .resize (key .length, keyValue .length ? keyValue [keyValue .length - 1] : new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFRotation ());

      // If there was already an set_fraction event in this frame, send a new value_changed to prevent glitches.
      if (this ._set_fraction .getModificationTime () >= this .getBrowser () .getCurrentTime ())
         this .set_fraction__ ();
   },
   interpolate: (() =>
   {
      const
         keyValue0 = new _standard_Math_Numbers_Rotation4_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A (),
         keyValue1 = new _standard_Math_Numbers_Rotation4_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A ();

      return function (index0, index1, weight)
      {
         // Both values can change in slerp.
         keyValue0 .assign (this ._keyValue [index0] .getValue ());
         keyValue1 .assign (this ._keyValue [index1] .getValue ());

         this ._value_changed = keyValue0 .slerp (keyValue1, weight);
      };
   })(),
});

Object .defineProperties (OrientationInterpolator,
{
   ... _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .getStaticProperties ("OrientationInterpolator", "Interpolation", 1, "children", "2.0"),
   fieldDefinitions:
   {
      value: new _Base_FieldDefinitionArray_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A ([
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .inputOutput, "metadata",      new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFNode ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .inputOnly,   "set_fraction",  new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFFloat ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .inputOutput, "key",           new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFFloat ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .inputOutput, "keyValue",      new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFRotation ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .outputOnly,  "value_changed", new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFRotation ()),
      ]),
      enumerable: true,
   },
});

const __default__ = OrientationInterpolator;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .add ("OrientationInterpolator", __default__));

/***/ },

/***/ 4682
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _x_ite_Namespace_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6334);
const a = [ ]; // more scratch
const b = [ ]; // more scratch
const z = [ ]; // more scratch

// Calculate eigenvalues and eigenvectors.
// This is from SGI Inventor Matrix.cpp.
function eigen_decomposition (matrix, result)
{
   const
      ORDER   = matrix .order,
      SIZE    = matrix .length,
      values  = result .values,
      vectors = result .vectors;

   let
      sm,         // smallest entry
      theta,      // angle for Jacobi rotation
      c, s, t,    // cosine, sine, tangent of theta
      tau,        // sine / (1 + cos)
      h, g,       // two scrap values
      thresh,     // threshold below which no rotation done
      p, q, i, j; // indices

   // initializations
   for (i = 0; i < ORDER; ++ i)
   {
      a [i] = a [i] ?? [ ];
      b [i] = values [i] = matrix .get1 (i, i);
      z [i] = 0;

      for (j = 0; j < ORDER; ++ j)
      {
         vectors [i] [j] = (i === j) ? 1 : 0;
         a [i] [j] = matrix .get1 (j, i);
      }
   }

   // Why 50? I don't know--it's the way the folks who wrote the
   // algorithm did it:
   for (i = 0; i < 50; ++ i)
   {
      sm = 0;

      for (p = 0; p < ORDER - 1; ++ p)
      {
         for (q = p + 1; q < ORDER; ++ q)
            sm += Math .abs (a [p] [q]);
      }

      if (sm === 0)
         break;

      thresh = i < 3 ?
         0.2 * sm / SIZE :
         0;

      for (p = 0; p < ORDER - 1; ++ p)
      {
         for (q = p + 1; q < ORDER; ++ q)
         {
            g = 100 * Math .abs (a [p] [q]);

            if (i > 3
                && (Math .abs (values [p]) + g === Math .abs (values [p]))
                && (Math .abs (values [q]) + g === Math .abs (values [q]))
            )
            {
               a [p] [q] = 0;
            }

            else if (Math .abs (a [p] [q]) > thresh)
            {
               h = values [q] - values [p];

               if (Math .abs (h) + g === Math .abs (h))
               {
                  t = a [p] [q] / h;
               }
               else
               {
                  theta = 0.5 * h / a [p] [q];
                  t     = 1 / (Math .abs (theta) + Math .sqrt (1 + theta * theta));

                  if (theta < 0)  t = -t;
               }
               // End of computing tangent of rotation angle

               c           = 1 / Math .sqrt (1 + t * t);
               s           = t * c;
               tau         = s / (1 + c);
               h           = t * a [p] [q];
               z [p]      -= h;
               z [q]      += h;
               values [p] -= h;
               values [q] += h;
               a [p] [q]   = 0;

               for (j = 0; j < p; ++ j)
               {
                  g = a [j] [p];
                  h = a [j] [q];
                  a [j] [p] = g - s * (h + g * tau);
                  a [j] [q] = h + s * (g - h * tau);
               }

               for (j = p + 1; j < q; ++ j)
               {
                  g = a [p] [j];
                  h = a [j] [q];
                  a [p] [j] = g - s * (h + g * tau);
                  a [j] [q] = h + s * (g - h * tau);
               }

               for (j = q + 1; j < ORDER; ++ j)
               {
                  g = a [p] [j];
                  h = a [q] [j];
                  a [p] [j] = g - s * (h + g * tau);
                  a [q] [j] = h + s * (g - h * tau);
               }

               for (j = 0; j < ORDER; ++ j)
               {
                  g = vectors [j] [p];
                  h = vectors [j] [q];
                  vectors [j] [p] = g - s * (h + g * tau);
                  vectors [j] [q] = h + s * (g - h * tau);
               }
            }
         }
      }

      for (p = 0; p < ORDER; ++ p)
      {
         values [p] = b [p] += z [p];
         z [p] = 0;
      }
   }

   return result;
}

const __default__ = eigen_decomposition;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_x_ite_Namespace_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .add ("eigen_decomposition", __default__));

/***/ },

/***/ 4730
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(8450);
/* harmony import */ var _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(4946);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(6334);



function X3DAppearanceChildNode (executionContext)
{
   _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .call (this, executionContext);

   this .addType (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .X3DAppearanceChildNode);
}

Object .setPrototypeOf (X3DAppearanceChildNode .prototype, _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .prototype);

Object .defineProperties (X3DAppearanceChildNode, _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .getStaticProperties ("X3DAppearanceChildNode", "Shape", 1));

const __default__ = X3DAppearanceChildNode;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .add ("X3DAppearanceChildNode", __default__));

/***/ },

/***/ 4815
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Base_X3DField_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(3247);
/* harmony import */ var _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(4946);
/* harmony import */ var _SFNodeCache_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(7149);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(6334);




const
   _target = Symbol (),
   _proxy  = Symbol ();

const handler =
{
   get (target, key)
   {
      try
      {
         const value = target [key];

         if (value !== undefined)
            return value;

         const
            node  = target .getValue (),
            field = node .getField (key);

         // Specification conform would be: accessType & X3DConstants .outputOnly.
         // But we allow read access to plain fields, too.
         if (field .getAccessType () === _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .inputOnly)
            return undefined;

         return field .valueOf ();
      }
      catch
      {
         return undefined;
      }
   },
   set (target, key, value)
   {
      if (key in target)
      {
         target [key] = value;
         return true;
      }

      try
      {
         const
            node       = target .getValue (),
            field      = node .getField (key),
            accessType = field .getAccessType ();

         if (accessType !== _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .outputOnly)
            field .setValue (value);

         return true;
      }
      catch (error)
      {
         console .error (target, key, error);
         return false;
      }
   },
   has (target, key)
   {
      try
      {
         return !! target .getValue () .getField (key);
      }
      catch
      {
         return key in target;
      }
   },
   ownKeys (target)
   {
      const
         value   = target .getValue (),
         ownKeys = [ ];

      if (value)
      {
         for (const { name } of value .getFieldDefinitions ())
            ownKeys .push (name);
      }

      return ownKeys;
   },
   getOwnPropertyDescriptor (target, key)
   {
      const value = target .getValue ();

      if (value)
      {
         const fieldDefinition = value .getFieldDefinitions () .get (key);

         if (fieldDefinition)
         {
            return {
               value: this .get (target, key),
               writable: fieldDefinition .accessType !== _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .outputOnly,
               enumerable: true,
               configurable: true,
            };
         }
      }
   },
};

function SFNode (value)
{
   // Node need to test for X3DBaseNode, because there is a special version of SFNode in Script.

   const proxy = new Proxy (this, handler);

   this [_target] = this;
   this [_proxy]  = proxy;

   if (value ?.getType () .includes (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .X3DNode))
   {
      value .addParent (proxy);

      _Base_X3DField_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .call (this, value);
   }
   else
   {
      _Base_X3DField_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .call (this, null);
   }

   return proxy;
}

Object .assign (Object .setPrototypeOf (SFNode .prototype, _Base_X3DField_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .prototype),
{
   [_target]: null,
   [_proxy]: null,
   copy (instance)
   {
      const
         target = this [_target],
         value  = target .getValue ();

      if (value && instance)
      {
         const copy = value .copy (instance);

         if (!copy .isInitialized () && !instance .getExecutionContext () .getOuterNode () ?.getType () .includes (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .X3DProtoDeclaration))
         {
            copy .setup ();
         }

         return new SFNode (copy);
      }

      return new SFNode (value);
   },
   equals (node)
   {
      const target = this [_target];

      if (node)
         return target .getValue () === node .getValue ();

      return target .getValue () === null;
   },
   isDefaultValue ()
   {
      const target = this [_target];

      return target .getValue () === null;
   },
   set (value)
   {
      const
         target  = this [_target],
         current = target .getValue ();

      current ?.removeParent (target [_proxy]);

      // No need to test for X3DBaseNode, because there is a special version of SFNode in Script.

      if (value ?.getType () .includes (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .X3DNode))
      {
         value .addParent (target [_proxy]);

         _Base_X3DField_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .prototype .set .call (target, value);
      }
      else
      {
         _Base_X3DField_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .prototype .set .call (target, null);
      }
   },
   getNodeTypeName ()
   {
      const
         target = this [_target],
         value  = target .getValue ();

      if (value)
         return value .getTypeName ();

      throw new Error ("SFNode.getNodeTypeName: node is null.");
   },
   getNodeName ()
   {
      const
         target = this [_target],
         value  = target .getValue ();

      if (value)
         return value .getName ();

      throw new Error ("SFNode.getNodeName: node is null.");
   },
   getNodeDisplayName ()
   {
      const
         target = this [_target],
         value  = target .getValue ();

      if (value)
         return value .getDisplayName ();

      throw new Error ("SFNode.getNodeDisplayName: node is null.");
   },
   getNodeType ()
   {
      const
         target = this [_target],
         value  = target .getValue ();

      if (value)
         return Array .from (value .getType ());

      throw new Error ("SFNode.getNodeType: node is null.");
   },
   getFieldDefinition (name)
   {
      const fieldDefinition = this .getFieldDefinitions () .get (name);

      if (fieldDefinition)
         return fieldDefinition;

      throw new Error (`Unknown field '${name}' in node class ${this .getNodeTypeName ()}.`);
   },
   getFieldDefinitions ()
   {
      const
         target = this [_target],
         value  = target .getValue ();

      if (value)
         return value .getFieldDefinitions ();

      throw new Error ("SFNode.getFieldDefinitions: node is null.");
   },
   /**
   * @deprecated Returns the corresponding X3DField object associated with *name*. Use sfnode.{fieldName} syntax.
   */
   getField (name)
   {
      const
         target = this [_target],
         value  = target .getValue ();

      if (value)
         return value .getField (name);

      throw new Error ("SFNode is disposed.")
   },
   addFieldCallback (... args)
   {
      const target = this [_target];

      switch (args .length)
      {
         case 2:
         {
            const [key, callback] = args;

            return _Base_X3DField_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .prototype .addFieldCallback .call (target, key, callback);
         }
         case 3:
         {
            const
               [key, name, callback] = args,
               value                 = target .getValue ();

            if (value)
               return value .getField (name) .addFieldCallback (key, callback);

            throw new Error ("SFNode.addFieldCallback: node is null.");
         }
      }
   },
   removeFieldCallback (... args)
   {
      const target = this [_target];

      switch (args .length)
      {
         case 1:
         {
            const key = [args];

            return _Base_X3DField_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .prototype .removeFieldCallback .call (target, key);
         }
         case 2:
         {
            const
               [key, name] = args,
               value       = target .getValue ();

            if (value)
               return value .getField (name) .removeFieldCallback (key);

            throw new Error ("SFNode.removeFieldCallback: node is null.");
         }
      }
   },
   getNodeUserData (key)
   {
      const value = this [_target] .getValue ();

      if (value)
         return value .getUserData (key);

      throw new Error ("SFNode.getNodeUserData: node is null.");
   },
   setNodeUserData (key, data)
   {
      const value = this [_target] .getValue ();

      if (value)
         return value .setUserData (key, data);

      throw new Error ("SFNode.setNodeUserData: node is null.");
   },
   removeNodeUserData (key)
   {
      const value = this [_target] .getValue ();

      if (value)
         return value .removeUserData (key);

      throw new Error ("SFNode.removeNodeUserData: node is null.");
   },
   valueOf ()
   {
      const
         target = this [_target],
         value  = target .getValue ();

      return value ? _SFNodeCache_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .get (value) : null;
   },
   toStream (generator)
   {
      const
         target = this [_target],
         value  = target .getValue ();

      if (value)
         value .toStream (generator);
      else
         generator .NULL ();
   },
   toVRMLStream (generator)
   {
      const
         target = this [_target],
         value  = target .getValue ();

      if (value)
         value .toVRMLStream (generator);
      else
         generator .NULL ();
   },
   toXMLStream (generator)
   {
      const
         target = this [_target],
         value  = target .getValue ();

      if (value)
         value .toXMLStream (generator);
      else
         generator .string += "<!-- NULL -->";
   },
   toJSONStream (generator)
   {
      this .toJSONStreamValue (generator);
   },
   toJSONStreamValue (generator)
   {
      const
         target = this [_target],
         value  = target .getValue ();

      if (value)
         value .toJSONStream (generator);
      else
         generator .string += "null";
   },
   dispose ()
   {
      const target = this [_target];

      target .set (null);
      target .processInterests ();

      _Base_X3DField_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .prototype .dispose .call (target);
   },
});

for (const key of Object .keys (SFNode .prototype))
   Object .defineProperty (SFNode .prototype, key, { enumerable: false });

Object .defineProperties (SFNode,
{
   type:
   {
      value: _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .SFNode,
      enumerable: true,
   },
   typeName:
   {
      value: "SFNode",
      enumerable: true,
   },
});

const __default__ = SFNode;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .add ("SFNode", __default__));

/***/ },

/***/ 4824
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Fields_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(3515);
/* harmony import */ var _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(2914);
/* harmony import */ var _Base_FieldDefinitionArray_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(9572);
/* harmony import */ var _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(8450);
/* harmony import */ var _Core_X3DBindableNode_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(3869);
/* harmony import */ var _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(4946);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(6334);







function NavigationInfo (executionContext)
{
   _Core_X3DBindableNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .call (this, executionContext);

   this .addType (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .NavigationInfo);

   this .addChildObjects (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .outputOnly, "transitionStart",  new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFBool (),
                          _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .outputOnly, "transitionActive", new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFBool (),
                          _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .outputOnly, "availableViewers", new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFString (),
                          _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .outputOnly, "viewer",           new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFString ());

   // Units

   this ._avatarSize      .setUnit ("length");
   this ._speed           .setUnit ("speed");
   this ._visibilityLimit .setUnit ("length");

   // Legacy

   // Actually the type field had this value, but we never knew this.
   // if (executionContext .getSpecificationVersion () == 2.0)
   //    this ._type = ["WALK", "ANY"]; // VRML2
}

Object .assign (Object .setPrototypeOf (NavigationInfo .prototype, _Core_X3DBindableNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .prototype),
{
   initialize ()
   {
      _Core_X3DBindableNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .prototype .initialize .call (this);

      this ._type               .addInterest ("set_type__",               this);
      this ._headlight          .addInterest ("set_headlight__",          this);
      this ._visibilityLimit    .addInterest ("set_visibilityLimit__",    this);
      this ._transitionStart    .addInterest ("set_transitionStart__",    this);
      this ._transitionComplete .addInterest ("set_transitionComplete__", this);
      this ._isBound            .addInterest ("set_isBound__",            this);

      this .set_type__ ();
      this .set_headlight__ ();
      this .set_visibilityLimit__ ();
   },
   getViewer ()
   {
      return this ._viewer .getValue ();
   },
   getCollisionRadius ()
   {
      if (this ._avatarSize .length > 0)
      {
         if (this ._avatarSize [0] > 0)
            return this ._avatarSize [0];
      }

      return 0.25;
   },
   getAvatarHeight ()
   {
      if (this ._avatarSize .length > 1)
         return this ._avatarSize [1];

      return 1.6;
   },
   getStepHeight ()
   {
      if (this ._avatarSize .length > 2)
         return this ._avatarSize [2];

      return 0.75;
   },
   getNearValue ()
   {
      const nearValue = this .getCollisionRadius ();

      return nearValue === 0 ? 1e-5 : nearValue / 2;
   },
   getFarValue ()
   {
      return this .visibilityLimit;
   },
   getTransitionType: (() =>
   {
      const TransitionTypes = new Set ([
         "TELEPORT",
         "LINEAR",
         "ANIMATE",
      ]);

      return function ()
      {
         for (const value of this ._transitionType)
         {
            if (TransitionTypes .has (value))
               return value;
         }

         return "LINEAR";
      };
   })(),
   set_type__ ()
   {
      // Determine active viewer.

      this ._viewer = "EXAMINE";

      for (const string of this ._type)
      {
         switch (string)
         {
            case "EXAMINE":
            case "WALK":
            case "FLY":
            case "LOOKAT":
            case "PLANE":
            case "NONE":
               this ._viewer = string;
               break;
            case "PLANE_create3000.github.io":
            case "PLANE_create3000.de":
               this ._viewer = "PLANE";
               break;
            default:
               continue;
         }

         // Leave for loop.
         break;
      }

      // Determine available viewers.

      let
         examineViewer = false,
         walkViewer    = false,
         flyViewer     = false,
         planeViewer   = false,
         noneViewer    = false,
         lookAt        = false;

      if (!this ._type .length)
      {
         examineViewer = true;
         walkViewer    = true;
         flyViewer     = true;
         planeViewer   = true;
         noneViewer    = true;
         lookAt        = true;
      }
      else
      {
         for (const string of this ._type)
         {
            switch (string)
            {
               case "EXAMINE":
                  examineViewer = true;
                  continue;
               case "WALK":
                  walkViewer = true;
                  continue;
               case "FLY":
                  flyViewer = true;
                  continue;
               case "LOOKAT":
                  lookAt = true;
                  continue;
               case "PLANE":
               case "PLANE_create3000.github.io":
               case "PLANE_create3000.de":
                  planeViewer = true;
                  continue;
               case "NONE":
                  noneViewer = true;
                  continue;
               case "ANY":
                  examineViewer = true;
                  walkViewer    = true;
                  flyViewer     = true;
                  planeViewer   = true;
                  noneViewer    = true;
                  lookAt        = true;
                  break;
               default:
                  // Any string leads to:
                  examineViewer = true;
                  continue;
            }

            break;
         }
      }

      this ._availableViewers .length = 0;

      if (examineViewer)
         this ._availableViewers .push ("EXAMINE");

      if (walkViewer)
         this ._availableViewers .push ("WALK");

      if (flyViewer)
         this ._availableViewers .push ("FLY");

      if (planeViewer)
         this ._availableViewers .push ("PLANE");

      if (lookAt)
         this ._availableViewers .push ("LOOKAT");

      if (noneViewer)
         this ._availableViewers .push ("NONE");
   },
   set_headlight__ ()
   {
      if (this ._headlight .getValue ())
         delete this .enable;
      else
         this .enable = Function .prototype;
   },
   set_visibilityLimit__ ()
   {
      this .visibilityLimit = Math .max (this ._visibilityLimit .getValue (), 0);
   },
   set_transitionStart__ ()
   {
      if (!this ._transitionActive .getValue ())
         this ._transitionActive = true;
   },
   set_transitionComplete__ ()
   {
      if (this ._transitionActive .getValue ())
         this ._transitionActive = false;
   },
   set_isBound__ ()
   {
      if (this ._isBound .getValue ())
         return;

      if (this ._transitionActive .getValue ())
         this ._transitionActive = false;
   },
   enable (type, renderObject)
   {
      if (!this ._headlight .getValue ())
         return;

      const headlight = this .getBrowser () .getHeadlight ();

      renderObject .getGlobalLights ()     .push (headlight);
      renderObject .getGlobalLightsKeys () .push (headlight .lightNode .getLightKey ());
   },
   traverse (type, renderObject)
   {
      renderObject .getLayer () .getNavigationInfos () .push (this);
   }
});

Object .defineProperties (NavigationInfo,
{
   ... _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .getStaticProperties ("NavigationInfo", "Navigation", 1, "children", "2.0"),
   fieldDefinitions:
   {
      value: new _Base_FieldDefinitionArray_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A ([
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .inputOutput, "metadata",           new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFNode ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .inputOnly,   "set_bind",           new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFBool ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .inputOutput, "type",               new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFString ("EXAMINE", "ANY")),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .inputOutput, "avatarSize",         new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFFloat (0.25, 1.6, 0.75)),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .inputOutput, "speed",              new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFFloat (1)),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .inputOutput, "headlight",          new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFBool (true)),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .inputOutput, "visibilityLimit",    new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFFloat ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .inputOutput, "transitionType",     new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFString ("LINEAR")),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .inputOutput, "transitionTime",     new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFTime (1)),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .outputOnly,  "transitionComplete", new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFBool ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .outputOnly,  "isBound",            new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFBool ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .outputOnly,  "bindTime",           new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFTime ()),
      ]),
      enumerable: true,
   },
});

const __default__ = NavigationInfo;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .add ("NavigationInfo", __default__));

/***/ },

/***/ 4832
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Fields_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(3515);
/* harmony import */ var _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(2914);
/* harmony import */ var _Base_FieldDefinitionArray_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(9572);
/* harmony import */ var _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(8450);
/* harmony import */ var _X3DLayerNode_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(6562);
/* harmony import */ var _Navigation_Viewpoint_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(717);
/* harmony import */ var _Grouping_Group_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(8512);
/* harmony import */ var _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(4946);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(6334);









function Layer (executionContext)
{
   _X3DLayerNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .call (this,
                       executionContext,
                       new _Navigation_Viewpoint_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A (executionContext),
                       new _Grouping_Group_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A (executionContext));

   this .addType (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .Layer);
}

Object .assign (Object .setPrototypeOf (Layer .prototype, _X3DLayerNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .prototype),
{
   initialize ()
   {
      _X3DLayerNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .prototype .initialize .call (this);

      const groupNode = this .getGroups () ._children [0] .getValue ();

      this ._addChildren    .addFieldInterest (groupNode ._addChildren);
      this ._removeChildren .addFieldInterest (groupNode ._removeChildren);
      this ._children       .addFieldInterest (groupNode ._children);

      groupNode ._children = this ._children;

      groupNode .setPrivate (true);
      groupNode .setup ();

      this .getGroups () .setup ();
   },
});

Object .defineProperties (Layer,
{
   ... _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .getStaticProperties ("Layer", "Layering", 1, "layers", "3.2"),
   fieldDefinitions:
   {
      value: new _Base_FieldDefinitionArray_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A ([
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .inputOutput, "metadata",       new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFNode ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .inputOutput, "pickable",       new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFBool (true)),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .inputOutput, "objectType",     new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFString ("ALL")),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .inputOutput, "pointerEvents",  new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFBool (true)), // skip test
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .inputOutput, "visible",        new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFBool (true)),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .inputOutput, "viewport",       new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFNode ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .inputOnly,   "addChildren",    new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFNode ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .inputOnly,   "removeChildren", new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFNode ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .inputOutput, "children",       new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFNode ()),
      ]),
      enumerable: true,
   },
});

const __default__ = Layer;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_8__/* ["default"] */ .A .add ("Layer", __default__));

/***/ },

/***/ 4850
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Base_X3DObject_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(7092);
/* harmony import */ var _Fields_SFNodeCache_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(7149);
/* harmony import */ var _Components_Core_X3DImportedNodeProxy_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(7948);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(6334);




const
   _executionContext = Symbol (),
   _inlineNode       = Symbol (),
   _exportedName     = Symbol (),
   _importedName     = Symbol (),
   _exportedNodes    = Symbol ();

function X3DImportedNode (executionContext, inlineNode, exportedName, importedName)
{
   _Base_X3DObject_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .call (this);

   this [_executionContext] = executionContext;
   this [_inlineNode]       = inlineNode;
   this [_exportedName]     = exportedName;
   this [_importedName]     = importedName;
   this [_exportedNodes]    = executionContext [_exportedNodes] ??= new Map ();
}

Object .assign (Object .setPrototypeOf (X3DImportedNode .prototype, _Base_X3DObject_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .prototype),
{
   getExecutionContext ()
   {
      return this [_executionContext];
   },
   getInlineNode ()
   {
      return this [_inlineNode];
   },
   getExportedName ()
   {
      return this [_exportedName];
   },
   getExportedNode (type)
   {
      const exportedNode = this [_exportedNodes] .get (this [_importedName]);

      exportedNode ?.setTypeHint (type);

      return exportedNode ?? this .createExportedNode (type);
   },
   createExportedNode (type)
   {
      const exportedNode = new _Components_Core_X3DImportedNodeProxy_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A (this .getExecutionContext (), this [_importedName], type);

      this [_exportedNodes] .set (this [_importedName], exportedNode);

      return exportedNode;
   },
   updateExportedNode ()
   {
      this [_exportedNodes] .get (this [_importedName]) ?.update ();
   },
   getSharedNode ()
   {
      const exportedNode = this .getInlineNode () .getInternalScene () .getExportedNodes () .get (this [_exportedName]);

      if (exportedNode)
         return exportedNode .getLocalNode ();

      throw new Error (`Exported node '${this [_exportedName]}' not found.`);
   },
   getImportedName ()
   {
      return this [_importedName];
   },
   [Symbol .for ("X_ITE.X3DImportedNode.setImportName")] (importedName)
   {
      const
         exportedNode  = this .getExportedNode (),
         exportedNodes = this [_exportedNodes];

      exportedNodes .delete (this [_importedName]);
      exportedNodes .set (importedName, exportedNode);

      this [_importedName] = importedName;

      exportedNode .setName (importedName);
   },
   toVRMLStream (generator)
   {
      if (!generator .ExistsNode (this .getInlineNode ()))
         throw new Error ("X3DImportedNode.toVRMLStream: Inline node does not exist.");

      generator .AddRouteNode (this);

      const importedName = generator .ImportedName (this);

      generator .Indent ();
      generator .string += "IMPORT";
      generator .Space ();
      generator .string += generator .Name (this .getInlineNode ());
      generator .string += ".";
      generator .string += this .getExportedName ();

      if (importedName !== this .getExportedName ())
      {
         generator .Space ();
         generator .string += "AS";
         generator .Space ();
         generator .string += importedName;
      }
   },
   toXMLStream (generator)
   {
      if (!generator .ExistsNode (this .getInlineNode ()))
         throw new Error ("X3DImportedNode.toXMLStream: Inline node does not exist.");

      generator .AddRouteNode (this);

      const importedName = generator .ImportedName (this);

      generator .openTag ("IMPORT");
      generator .attribute ("inlineDEF",   generator .Name (this .getInlineNode ()));
      generator .attribute ("importedDEF", this .getExportedName ());

      if (importedName !== this .getExportedName ())
         generator .attribute ("AS", importedName);

      generator .closeTag ("IMPORT");
   },
   toJSONStream (generator)
   {
      if (!generator .ExistsNode (this .getInlineNode ()))
         throw new Error ("X3DImportedNode.toJSONStream: Inline node does not exist.");

      generator .TidyBreak ();
      generator .Indent ();

      generator .AddRouteNode (this);
      generator .beginObject ("IMPORT", false, true);
      generator .stringProperty ("@inlineDEF",   generator .Name (this .getInlineNode ()), false);
      generator .stringProperty ("@importedDEF", this .getExportedName ());

      const importedName = generator .ImportedName (this);

      if (importedName !== this .getExportedName ())
         generator .stringProperty ("@AS", importedName);

      generator .endObject ();
      generator .endObject ();
   },
   dispose ()
   {
      for (const route of Array .from (this [_executionContext] .getRoutes ()))
      {
         if (route .getSourceNode () === this)
         {
            this [_executionContext] .deleteRoute (route);
            continue;
         }

         if (route .getDestinationNode () === this)
         {
            this [_executionContext] .deleteRoute (route);
            continue;
         }
      }

      _Base_X3DObject_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .prototype .dispose .call (this);
   },
});

for (const key of Object .keys (X3DImportedNode .prototype))
   Object .defineProperty (X3DImportedNode .prototype, key, { enumerable: false });

Object .defineProperties (X3DImportedNode .prototype,
{
   inlineNode:
   {
      get ()
      {
         return _Fields_SFNodeCache_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .get (this [_inlineNode]);
      },
      enumerable: true,
   },
   exportedName:
   {
      get ()
      {
         return this [_exportedName];
      },
      enumerable: true,
   },
   exportedNode:
   {
      get ()
      {
         return _Fields_SFNodeCache_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .get (this .getExportedNode ());
      },
      enumerable: true,
   },
   importedName:
   {
      get ()
      {
         return this [_importedName];
      },
      enumerable: true,
   },
});

Object .defineProperties (X3DImportedNode,
{
   typeName:
   {
      value: "X3DImportedNode",
      enumerable: true,
   },
});

const __default__ = X3DImportedNode;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .add ("X3DImportedNode", __default__));

/***/ },

/***/ 4910
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Fields_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(3515);
/* harmony import */ var _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(8450);
/* harmony import */ var _Shape_X3DAppearanceChildNode_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(4730);
/* harmony import */ var _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(4946);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(6334);





function X3DTextureNode (executionContext)
{
   _Shape_X3DAppearanceChildNode_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .call (this, executionContext);

   this .addType (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .X3DTextureNode);

   this .addChildObjects (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .outputOnly, "transparent", new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFBool ());
}

Object .assign (Object .setPrototypeOf (X3DTextureNode .prototype, _Shape_X3DAppearanceChildNode_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .prototype),
{
   setTransparent (value)
   {
      if (!!value !== this ._transparent .getValue ())
         this ._transparent = value;
   },
   isTransparent ()
   {
      return this ._transparent .getValue ();
   },
});

Object .defineProperties (X3DTextureNode, _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .getStaticProperties ("X3DTextureNode", "Texturing", 1));

const __default__ = X3DTextureNode;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .add ("X3DTextureNode", __default__));

/***/ },

/***/ 4946
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6334);
const X3DConstants =
{
   [Symbol .toStringTag]: "X3DConstants",
};

let CONSTANT_VALUE = 1000;

Object .defineProperty (X3DConstants, "addConstant",
{
   value (name, value)
   {
      if (this .hasOwnProperty (name) || this .hasOwnProperty (value))
         return;

      Object .defineProperty (this, name,
      {
         value: value ?? ++ CONSTANT_VALUE,
         enumerable: true,
      });

      Object .defineProperty (this, this [name],
      {
         value: name,
      });
   },
});

Object .entries ({
   // Access types

   initializeOnly: 0b001,
   inputOnly:      0b010,
   outputOnly:     0b100,
   inputOutput:    0b111,
})
.forEach (([name, value]) => X3DConstants .addConstant (name, value));

[
   // Browser events

   "CONNECTION_ERROR",
   "BROWSER_EVENT",
   "INITIALIZED_EVENT",
   "SHUTDOWN_EVENT",
   "INITIALIZED_ERROR",

   // Load states

   "NOT_STARTED_STATE",
   "IN_PROGRESS_STATE",
   "COMPLETE_STATE",
   "FAILED_STATE",

   // X3DField

   "SFBool",
   "SFColor",
   "SFColorRGBA",
   "SFDouble",
   "SFFloat",
   "SFImage",
   "SFInt32",
   "SFMatrix3d",
   "SFMatrix3f",
   "SFMatrix4d",
   "SFMatrix4f",
   "SFNode",
   "SFRotation",
   "SFString",
   "SFTime",
   "SFVec2d",
   "SFVec2f",
   "SFVec3d",
   "SFVec3f",
   "SFVec4d",
   "SFVec4f",

   "VrmlMatrix",

   // X3DArrayField

   "MFBool",
   "MFColor",
   "MFColorRGBA",
   "MFDouble",
   "MFFloat",
   "MFImage",
   "MFInt32",
   "MFMatrix3d",
   "MFMatrix3f",
   "MFMatrix4d",
   "MFMatrix4f",
   "MFNode",
   "MFRotation",
   "MFString",
   "MFTime",
   "MFVec2d",
   "MFVec2f",
   "MFVec3d",
   "MFVec3f",
   "MFVec4d",
   "MFVec4f",

   // Abstract and concrete nodes and nodes types are added later.
]
.forEach (name => X3DConstants .addConstant (name));

const __default__ = X3DConstants;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .add ("X3DConstants", __default__));

/***/ },

/***/ 4993
(module, exports) {

var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;/*!
 * jQuery JavaScript Library v3.7.1 -ajax,-ajax/jsonp,-ajax/load,-ajax/script,-ajax/var/location,-ajax/var/nonce,-ajax/var/rquery,-ajax/xhr,-manipulation/_evalUrl,-deprecated/ajax-event-alias,-effects,-effects/animatedSelector,-effects/Tween
 * https://jquery.com/
 *
 * Copyright OpenJS Foundation and other contributors
 * Released under the MIT license
 * https://jquery.org/license
 *
 * Date: 2023-08-28T13:37Z
 */
( function( global, factory ) {

	"use strict";

	if (  true && typeof module.exports === "object" ) {

		// For CommonJS and CommonJS-like environments where a proper `window`
		// is present, execute the factory and get jQuery.
		// For environments that do not have a `window` with a `document`
		// (such as Node.js), expose a factory as module.exports.
		// This accentuates the need for the creation of a real `window`.
		// e.g. var jQuery = require("jquery")(window);
		// See ticket trac-14549 for more info.
		module.exports = global.document ?
			factory( global, true ) :
			function( w ) {
				if ( !w.document ) {
					throw new Error( "jQuery requires a window with a document" );
				}
				return factory( w );
			};
	} else {
		factory( global );
	}

// Pass this if window is not defined yet
} )( typeof window !== "undefined" ? window : this, function( window, noGlobal ) {

// Edge <= 12 - 13+, Firefox <=18 - 45+, IE 10 - 11, Safari 5.1 - 9+, iOS 6 - 9.1
// throw exceptions when non-strict code (e.g., ASP.NET 4.5) accesses strict mode
// arguments.callee.caller (trac-13335). But as of jQuery 3.0 (2016), strict mode should be common
// enough that all such attempts are guarded in a try block.
"use strict";

var arr = [];

var getProto = Object.getPrototypeOf;

var slice = arr.slice;

var flat = arr.flat ? function( array ) {
	return arr.flat.call( array );
} : function( array ) {
	return arr.concat.apply( [], array );
};


var push = arr.push;

var indexOf = arr.indexOf;

var class2type = {};

var toString = class2type.toString;

var hasOwn = class2type.hasOwnProperty;

var fnToString = hasOwn.toString;

var ObjectFunctionString = fnToString.call( Object );

var support = {};

var isFunction = function isFunction( obj ) {

		// Support: Chrome <=57, Firefox <=52
		// In some browsers, typeof returns "function" for HTML <object> elements
		// (i.e., `typeof document.createElement( "object" ) === "function"`).
		// We don't want to classify *any* DOM node as a function.
		// Support: QtWeb <=3.8.5, WebKit <=534.34, wkhtmltopdf tool <=0.12.5
		// Plus for old WebKit, typeof returns "function" for HTML collections
		// (e.g., `typeof document.getElementsByTagName("div") === "function"`). (gh-4756)
		return typeof obj === "function" && typeof obj.nodeType !== "number" &&
			typeof obj.item !== "function";
	};


var isWindow = function isWindow( obj ) {
		return obj != null && obj === obj.window;
	};


var document = window.document;



	var preservedScriptAttributes = {
		type: true,
		src: true,
		nonce: true,
		noModule: true
	};

	function DOMEval( code, node, doc ) {
		doc = doc || document;

		var i, val,
			script = doc.createElement( "script" );

		script.text = code;
		if ( node ) {
			for ( i in preservedScriptAttributes ) {

				// Support: Firefox 64+, Edge 18+
				// Some browsers don't support the "nonce" property on scripts.
				// On the other hand, just using `getAttribute` is not enough as
				// the `nonce` attribute is reset to an empty string whenever it
				// becomes browsing-context connected.
				// See https://github.com/whatwg/html/issues/2369
				// See https://html.spec.whatwg.org/#nonce-attributes
				// The `node.getAttribute` check was added for the sake of
				// `jQuery.globalEval` so that it can fake a nonce-containing node
				// via an object.
				val = node[ i ] || node.getAttribute && node.getAttribute( i );
				if ( val ) {
					script.setAttribute( i, val );
				}
			}
		}
		doc.head.appendChild( script ).parentNode.removeChild( script );
	}


function toType( obj ) {
	if ( obj == null ) {
		return obj + "";
	}

	// Support: Android <=2.3 only (functionish RegExp)
	return typeof obj === "object" || typeof obj === "function" ?
		class2type[ toString.call( obj ) ] || "object" :
		typeof obj;
}
/* global Symbol */
// Defining this global in .eslintrc.json would create a danger of using the global
// unguarded in another place, it seems safer to define global only for this module



var version = "3.7.1 -ajax,-ajax/jsonp,-ajax/load,-ajax/script,-ajax/var/location,-ajax/var/nonce,-ajax/var/rquery,-ajax/xhr,-manipulation/_evalUrl,-deprecated/ajax-event-alias,-effects,-effects/animatedSelector,-effects/Tween",

	rhtmlSuffix = /HTML$/i,

	// Define a local copy of jQuery
	jQuery = function( selector, context ) {

		// The jQuery object is actually just the init constructor 'enhanced'
		// Need init if jQuery is called (just allow error to be thrown if not included)
		return new jQuery.fn.init( selector, context );
	};

jQuery.fn = jQuery.prototype = {

	// The current version of jQuery being used
	jquery: version,

	constructor: jQuery,

	// The default length of a jQuery object is 0
	length: 0,

	toArray: function() {
		return slice.call( this );
	},

	// Get the Nth element in the matched element set OR
	// Get the whole matched element set as a clean array
	get: function( num ) {

		// Return all the elements in a clean array
		if ( num == null ) {
			return slice.call( this );
		}

		// Return just the one element from the set
		return num < 0 ? this[ num + this.length ] : this[ num ];
	},

	// Take an array of elements and push it onto the stack
	// (returning the new matched element set)
	pushStack: function( elems ) {

		// Build a new jQuery matched element set
		var ret = jQuery.merge( this.constructor(), elems );

		// Add the old object onto the stack (as a reference)
		ret.prevObject = this;

		// Return the newly-formed element set
		return ret;
	},

	// Execute a callback for every element in the matched set.
	each: function( callback ) {
		return jQuery.each( this, callback );
	},

	map: function( callback ) {
		return this.pushStack( jQuery.map( this, function( elem, i ) {
			return callback.call( elem, i, elem );
		} ) );
	},

	slice: function() {
		return this.pushStack( slice.apply( this, arguments ) );
	},

	first: function() {
		return this.eq( 0 );
	},

	last: function() {
		return this.eq( -1 );
	},

	even: function() {
		return this.pushStack( jQuery.grep( this, function( _elem, i ) {
			return ( i + 1 ) % 2;
		} ) );
	},

	odd: function() {
		return this.pushStack( jQuery.grep( this, function( _elem, i ) {
			return i % 2;
		} ) );
	},

	eq: function( i ) {
		var len = this.length,
			j = +i + ( i < 0 ? len : 0 );
		return this.pushStack( j >= 0 && j < len ? [ this[ j ] ] : [] );
	},

	end: function() {
		return this.prevObject || this.constructor();
	},

	// For internal use only.
	// Behaves like an Array's method, not like a jQuery method.
	push: push,
	sort: arr.sort,
	splice: arr.splice
};

jQuery.extend = jQuery.fn.extend = function() {
	var options, name, src, copy, copyIsArray, clone,
		target = arguments[ 0 ] || {},
		i = 1,
		length = arguments.length,
		deep = false;

	// Handle a deep copy situation
	if ( typeof target === "boolean" ) {
		deep = target;

		// Skip the boolean and the target
		target = arguments[ i ] || {};
		i++;
	}

	// Handle case when target is a string or something (possible in deep copy)
	if ( typeof target !== "object" && !isFunction( target ) ) {
		target = {};
	}

	// Extend jQuery itself if only one argument is passed
	if ( i === length ) {
		target = this;
		i--;
	}

	for ( ; i < length; i++ ) {

		// Only deal with non-null/undefined values
		if ( ( options = arguments[ i ] ) != null ) {

			// Extend the base object
			for ( name in options ) {
				copy = options[ name ];

				// Prevent Object.prototype pollution
				// Prevent never-ending loop
				if ( name === "__proto__" || target === copy ) {
					continue;
				}

				// Recurse if we're merging plain objects or arrays
				if ( deep && copy && ( jQuery.isPlainObject( copy ) ||
					( copyIsArray = Array.isArray( copy ) ) ) ) {
					src = target[ name ];

					// Ensure proper type for the source value
					if ( copyIsArray && !Array.isArray( src ) ) {
						clone = [];
					} else if ( !copyIsArray && !jQuery.isPlainObject( src ) ) {
						clone = {};
					} else {
						clone = src;
					}
					copyIsArray = false;

					// Never move original objects, clone them
					target[ name ] = jQuery.extend( deep, clone, copy );

				// Don't bring in undefined values
				} else if ( copy !== undefined ) {
					target[ name ] = copy;
				}
			}
		}
	}

	// Return the modified object
	return target;
};

jQuery.extend( {

	// Unique for each copy of jQuery on the page
	expando: "jQuery" + ( version + Math.random() ).replace( /\D/g, "" ),

	// Assume jQuery is ready without the ready module
	isReady: true,

	error: function( msg ) {
		throw new Error( msg );
	},

	noop: function() {},

	isPlainObject: function( obj ) {
		var proto, Ctor;

		// Detect obvious negatives
		// Use toString instead of jQuery.type to catch host objects
		if ( !obj || toString.call( obj ) !== "[object Object]" ) {
			return false;
		}

		proto = getProto( obj );

		// Objects with no prototype (e.g., `Object.create( null )`) are plain
		if ( !proto ) {
			return true;
		}

		// Objects with prototype are plain iff they were constructed by a global Object function
		Ctor = hasOwn.call( proto, "constructor" ) && proto.constructor;
		return typeof Ctor === "function" && fnToString.call( Ctor ) === ObjectFunctionString;
	},

	isEmptyObject: function( obj ) {
		var name;

		for ( name in obj ) {
			return false;
		}
		return true;
	},

	// Evaluates a script in a provided context; falls back to the global one
	// if not specified.
	globalEval: function( code, options, doc ) {
		DOMEval( code, { nonce: options && options.nonce }, doc );
	},

	each: function( obj, callback ) {
		var length, i = 0;

		if ( isArrayLike( obj ) ) {
			length = obj.length;
			for ( ; i < length; i++ ) {
				if ( callback.call( obj[ i ], i, obj[ i ] ) === false ) {
					break;
				}
			}
		} else {
			for ( i in obj ) {
				if ( callback.call( obj[ i ], i, obj[ i ] ) === false ) {
					break;
				}
			}
		}

		return obj;
	},


	// Retrieve the text value of an array of DOM nodes
	text: function( elem ) {
		var node,
			ret = "",
			i = 0,
			nodeType = elem.nodeType;

		if ( !nodeType ) {

			// If no nodeType, this is expected to be an array
			while ( ( node = elem[ i++ ] ) ) {

				// Do not traverse comment nodes
				ret += jQuery.text( node );
			}
		}
		if ( nodeType === 1 || nodeType === 11 ) {
			return elem.textContent;
		}
		if ( nodeType === 9 ) {
			return elem.documentElement.textContent;
		}
		if ( nodeType === 3 || nodeType === 4 ) {
			return elem.nodeValue;
		}

		// Do not include comment or processing instruction nodes

		return ret;
	},

	// results is for internal usage only
	makeArray: function( arr, results ) {
		var ret = results || [];

		if ( arr != null ) {
			if ( isArrayLike( Object( arr ) ) ) {
				jQuery.merge( ret,
					typeof arr === "string" ?
						[ arr ] : arr
				);
			} else {
				push.call( ret, arr );
			}
		}

		return ret;
	},

	inArray: function( elem, arr, i ) {
		return arr == null ? -1 : indexOf.call( arr, elem, i );
	},

	isXMLDoc: function( elem ) {
		var namespace = elem && elem.namespaceURI,
			docElem = elem && ( elem.ownerDocument || elem ).documentElement;

		// Assume HTML when documentElement doesn't yet exist, such as inside
		// document fragments.
		return !rhtmlSuffix.test( namespace || docElem && docElem.nodeName || "HTML" );
	},

	// Support: Android <=4.0 only, PhantomJS 1 only
	// push.apply(_, arraylike) throws on ancient WebKit
	merge: function( first, second ) {
		var len = +second.length,
			j = 0,
			i = first.length;

		for ( ; j < len; j++ ) {
			first[ i++ ] = second[ j ];
		}

		first.length = i;

		return first;
	},

	grep: function( elems, callback, invert ) {
		var callbackInverse,
			matches = [],
			i = 0,
			length = elems.length,
			callbackExpect = !invert;

		// Go through the array, only saving the items
		// that pass the validator function
		for ( ; i < length; i++ ) {
			callbackInverse = !callback( elems[ i ], i );
			if ( callbackInverse !== callbackExpect ) {
				matches.push( elems[ i ] );
			}
		}

		return matches;
	},

	// arg is for internal usage only
	map: function( elems, callback, arg ) {
		var length, value,
			i = 0,
			ret = [];

		// Go through the array, translating each of the items to their new values
		if ( isArrayLike( elems ) ) {
			length = elems.length;
			for ( ; i < length; i++ ) {
				value = callback( elems[ i ], i, arg );

				if ( value != null ) {
					ret.push( value );
				}
			}

		// Go through every key on the object,
		} else {
			for ( i in elems ) {
				value = callback( elems[ i ], i, arg );

				if ( value != null ) {
					ret.push( value );
				}
			}
		}

		// Flatten any nested arrays
		return flat( ret );
	},

	// A global GUID counter for objects
	guid: 1,

	// jQuery.support is not used in Core but other projects attach their
	// properties to it so it needs to exist.
	support: support
} );

if ( typeof Symbol === "function" ) {
	jQuery.fn[ Symbol.iterator ] = arr[ Symbol.iterator ];
}

// Populate the class2type map
jQuery.each( "Boolean Number String Function Array Date RegExp Object Error Symbol".split( " " ),
	function( _i, name ) {
		class2type[ "[object " + name + "]" ] = name.toLowerCase();
	} );

function isArrayLike( obj ) {

	// Support: real iOS 8.2 only (not reproducible in simulator)
	// `in` check used to prevent JIT error (gh-2145)
	// hasOwn isn't used here due to false negatives
	// regarding Nodelist length in IE
	var length = !!obj && "length" in obj && obj.length,
		type = toType( obj );

	if ( isFunction( obj ) || isWindow( obj ) ) {
		return false;
	}

	return type === "array" || length === 0 ||
		typeof length === "number" && length > 0 && ( length - 1 ) in obj;
}


function nodeName( elem, name ) {

	return elem.nodeName && elem.nodeName.toLowerCase() === name.toLowerCase();

}
var pop = arr.pop;


var sort = arr.sort;


var splice = arr.splice;


var whitespace = "[\\x20\\t\\r\\n\\f]";


var rtrimCSS = new RegExp(
	"^" + whitespace + "+|((?:^|[^\\\\])(?:\\\\.)*)" + whitespace + "+$",
	"g"
);




// Note: an element does not contain itself
jQuery.contains = function( a, b ) {
	var bup = b && b.parentNode;

	return a === bup || !!( bup && bup.nodeType === 1 && (

		// Support: IE 9 - 11+
		// IE doesn't have `contains` on SVG.
		a.contains ?
			a.contains( bup ) :
			a.compareDocumentPosition && a.compareDocumentPosition( bup ) & 16
	) );
};




// CSS string/identifier serialization
// https://drafts.csswg.org/cssom/#common-serializing-idioms
var rcssescape = /([\0-\x1f\x7f]|^-?\d)|^-$|[^\x80-\uFFFF\w-]/g;

function fcssescape( ch, asCodePoint ) {
	if ( asCodePoint ) {

		// U+0000 NULL becomes U+FFFD REPLACEMENT CHARACTER
		if ( ch === "\0" ) {
			return "\uFFFD";
		}

		// Control characters and (dependent upon position) numbers get escaped as code points
		return ch.slice( 0, -1 ) + "\\" + ch.charCodeAt( ch.length - 1 ).toString( 16 ) + " ";
	}

	// Other potentially-special ASCII characters get backslash-escaped
	return "\\" + ch;
}

jQuery.escapeSelector = function( sel ) {
	return ( sel + "" ).replace( rcssescape, fcssescape );
};




var preferredDoc = document,
	pushNative = push;

( function() {

var i,
	Expr,
	outermostContext,
	sortInput,
	hasDuplicate,
	push = pushNative,

	// Local document vars
	document,
	documentElement,
	documentIsHTML,
	rbuggyQSA,
	matches,

	// Instance-specific data
	expando = jQuery.expando,
	dirruns = 0,
	done = 0,
	classCache = createCache(),
	tokenCache = createCache(),
	compilerCache = createCache(),
	nonnativeSelectorCache = createCache(),
	sortOrder = function( a, b ) {
		if ( a === b ) {
			hasDuplicate = true;
		}
		return 0;
	},

	booleans = "checked|selected|async|autofocus|autoplay|controls|defer|disabled|hidden|ismap|" +
		"loop|multiple|open|readonly|required|scoped",

	// Regular expressions

	// https://www.w3.org/TR/css-syntax-3/#ident-token-diagram
	identifier = "(?:\\\\[\\da-fA-F]{1,6}" + whitespace +
		"?|\\\\[^\\r\\n\\f]|[\\w-]|[^\0-\\x7f])+",

	// Attribute selectors: https://www.w3.org/TR/selectors/#attribute-selectors
	attributes = "\\[" + whitespace + "*(" + identifier + ")(?:" + whitespace +

		// Operator (capture 2)
		"*([*^$|!~]?=)" + whitespace +

		// "Attribute values must be CSS identifiers [capture 5] or strings [capture 3 or capture 4]"
		"*(?:'((?:\\\\.|[^\\\\'])*)'|\"((?:\\\\.|[^\\\\\"])*)\"|(" + identifier + "))|)" +
		whitespace + "*\\]",

	pseudos = ":(" + identifier + ")(?:\\((" +

		// To reduce the number of selectors needing tokenize in the preFilter, prefer arguments:
		// 1. quoted (capture 3; capture 4 or capture 5)
		"('((?:\\\\.|[^\\\\'])*)'|\"((?:\\\\.|[^\\\\\"])*)\")|" +

		// 2. simple (capture 6)
		"((?:\\\\.|[^\\\\()[\\]]|" + attributes + ")*)|" +

		// 3. anything else (capture 2)
		".*" +
		")\\)|)",

	// Leading and non-escaped trailing whitespace, capturing some non-whitespace characters preceding the latter
	rwhitespace = new RegExp( whitespace + "+", "g" ),

	rcomma = new RegExp( "^" + whitespace + "*," + whitespace + "*" ),
	rleadingCombinator = new RegExp( "^" + whitespace + "*([>+~]|" + whitespace + ")" +
		whitespace + "*" ),
	rdescend = new RegExp( whitespace +