/* X_ITE v12.2.3 */
(function webpackUniversalModuleDefinition(root, factory) {
	if(typeof exports === 'object' && typeof module === 'object')
		module.exports = factory();
	else if(typeof define === 'function' && define.amd)
		define([], factory);
	else if(typeof exports === 'object')
		exports["X3D"] = factory();
	else
		root["X3D"] = factory();
})(self, () => {
return /******/ (() => { // webpackBootstrap
/******/ 	var __webpack_modules__ = ({

/***/ 254:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Base_X3DObject_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(3078);
/* harmony import */ var _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(8899);
/* harmony import */ var _Fields_SFNodeCache_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(6882);
/* harmony import */ var _Components_Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(8415);
/* harmony import */ var _Execution_X3DImportedNode_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(7627);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(6707);
/* provided dependency */ var $ = __webpack_require__(7682);






const
   _executionContext     = Symbol (),
   _sourceNode           = Symbol (),
   _sourceFieldName      = Symbol (),
   _sourceField          = Symbol (),
   _destinationNode      = Symbol (),
   _destinationFieldName = Symbol (),
   _destinationField     = Symbol (),
   _disposed             = Symbol ();

function X3DRoute (executionContext, sourceNode, sourceFieldName, destinationNode, destinationFieldName)
{
   _Base_X3DObject_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .call (this, executionContext);

   this [_executionContext]     = executionContext;
   this [_sourceNode]           = sourceNode;
   this [_sourceFieldName]      = sourceFieldName;
   this [_destinationNode]      = destinationNode;
   this [_destinationFieldName] = destinationFieldName;

   if (sourceNode instanceof _Execution_X3DImportedNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A)
      sourceNode .getInlineNode () ._loadState .addInterest ("reconnect", this);

   if (destinationNode instanceof _Execution_X3DImportedNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A)
      destinationNode .getInlineNode () ._loadState .addInterest ("reconnect", this);

   this .reconnect ();
}

Object .assign (Object .setPrototypeOf (X3DRoute .prototype, _Base_X3DObject_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .prototype),
{
   getExecutionContext ()
   {
      return this [_executionContext];
   },
   getRouteId ()
   {
      return X3DRoute .getRouteId (this [_sourceNode], this [_sourceFieldName], this [_destinationNode], this [_destinationFieldName]);
   },
   getSourceNode ()
   {
      ///  SAI

      if (this [_sourceNode] instanceof _Execution_X3DImportedNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A)
         return this [_sourceNode] .getExportedNode ();

      return this [_sourceNode];
   },
   getSourceField ()
   {
      ///  SAI

      if (this [_sourceField])
      {
         return this [_sourceField] .getAccessType () === _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .inputOutput
            ? this [_sourceField] .getName () + "_changed"
            : this [_sourceField] .getName ();
      }
      else
      {
         return this [_sourceFieldName];
      }

   },
   getDestinationNode ()
   {
      ///  SAI

      if (this [_destinationNode] instanceof _Execution_X3DImportedNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A)
         return this [_destinationNode] .getExportedNode ();

      return this [_destinationNode];
   },
   getDestinationField ()
   {
      ///  SAI

      if (this [_destinationField])
      {
         return this [_destinationField] .getAccessType () === _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .inputOutput
            ? "set_" + this [_destinationField] .getName ()
            : this [_destinationField] .getName ();
      }
      else
      {
         return this [_destinationFieldName];
      }
   },
   reconnect ()
   {
      try
      {
         this .disconnect ();
         this .connect ();
      }
      catch (error)
      {
         if ((this [_sourceNode] instanceof _Components_Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A ||
              this [_sourceNode] .getInlineNode () .checkLoadState () === _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .COMPLETE_STATE) &&
             (this [_destinationNode] instanceof _Components_Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A ||
              this [_destinationNode] .getInlineNode () .checkLoadState () === _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .COMPLETE_STATE))
         {
            console .warn (error);
         }
      }
   },
   connect ()
   {
      if (this [_disposed])
         return;

      let firstError, secondError;

      try
      {
         const sourceNode = this [_sourceNode] instanceof _Components_Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A
            ? this [_sourceNode]
            : this [_sourceNode] .getExportedNode ();

         this [_sourceField] = sourceNode .getField (this [_sourceFieldName]);
      }
      catch (error)
      {
         firstError = error;
      }

      try
      {
         const destinationNode = this [_destinationNode] instanceof _Components_Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A
            ? this [_destinationNode]
            : this [_destinationNode] .getExportedNode ();

         this [_destinationField] = destinationNode .getField (this [_destinationFieldName]);
      }
      catch (error)
      {
         secondError = error;
      }

      if (this [_sourceField] && this [_destinationField])
      {
         if (this [_sourceField] .getType () !== this [_destinationField] .getType ())
            throw new Error (`Bad ROUTE statement: Source field type must match destination field type of fields named "${this [_sourceField] .getName ()}" and "${this [_destinationField] .getName ()}".`);

         if (!this [_sourceField] .isOutput ())
            throw new Error (`Bad ROUTE statement: Source field "${this [_sourceField] .getName ()}" must be an output.`);

         if (!this [_destinationField] .isInput ())
            throw new Error (`Bad ROUTE statement: Destination field "${this [_destinationField] .getName ()}" must be an input.`);

         this [_sourceField]      .addOutputRoute (this);
         this [_destinationField] .addInputRoute (this);
         this [_sourceField]      .addFieldInterest (this [_destinationField]);
      }
      else
      {
         throw firstError ?? secondError;
      }
   },
   disconnect ()
   {
      this [_sourceField]      ?.removeOutputRoute (this);
      this [_destinationField] ?.removeInputRoute (this);

      if (this [_sourceField] && this [_destinationField])
         this [_sourceField] .removeFieldInterest (this [_destinationField]);

      this [_sourceField]      = null;
      this [_destinationField] = null;
   },
   toVRMLStream (generator)
   {
      if (!generator .ExistsRouteNode (this [_sourceNode]))
         throw new Error (`Source node does not exist in scene graph.`);

      if (!generator .ExistsRouteNode (this [_destinationNode]))
         throw new Error (`Destination node does not exist in scene graph.`);

      const sourceNodeName = this [_sourceNode] instanceof _Components_Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A
         ? generator .Name (this [_sourceNode])
         : generator .ImportedName (this [_sourceNode]);

      const destinationNodeName = this [_destinationNode] instanceof _Components_Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A
         ? generator .Name (this [_destinationNode])
         : generator .ImportedName (this [_destinationNode]);

      generator .Indent ();
      generator .string += "ROUTE";
      generator .Space ();
      generator .string += sourceNodeName;
      generator .string += ".";
      generator .string += this .getSourceField ();
      generator .Space ();
      generator .string += "TO";
      generator .Space ();
      generator .string += destinationNodeName;
      generator .string += ".";
      generator .string += this .getDestinationField ();
   },
   toXMLStream (generator)
   {
      if (!generator .ExistsRouteNode (this [_sourceNode]))
         throw new Error (`Source node does not exist in scene graph.`);

      if (!generator .ExistsRouteNode (this [_destinationNode]))
         throw new Error (`Destination node does not exist in scene graph.`);

      const sourceNodeName = this [_sourceNode] instanceof _Components_Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A
         ? generator .Name (this [_sourceNode])
         : generator .ImportedName (this [_sourceNode]);

      const destinationNodeName = this [_destinationNode] instanceof _Components_Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A
         ? generator .Name (this [_destinationNode])
         : generator .ImportedName (this [_destinationNode]);

      generator .openTag ("ROUTE");
      generator .attribute ("fromNode",  sourceNodeName);
      generator .attribute ("fromField", this .getSourceField ());
      generator .attribute ("toNode",    destinationNodeName);
      generator .attribute ("toField",   this .getDestinationField ());
      generator .closeTag ("ROUTE");
   },
   toJSONStream (generator)
   {
      if (!generator .ExistsRouteNode (this [_sourceNode]))
         throw new Error (`Source node does not exist in scene graph.`);

      if (!generator .ExistsRouteNode (this [_destinationNode]))
         throw new Error (`Destination node does not exist in scene graph.`);

      const sourceNodeName = this [_sourceNode] instanceof _Components_Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A
         ? generator .Name (this [_sourceNode])
         : generator .ImportedName (this [_sourceNode]);

      const destinationNodeName = this [_destinationNode] instanceof _Components_Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A
         ? generator .Name (this [_destinationNode])
         : generator .ImportedName (this [_destinationNode]);

      generator .TidyBreak ();
      generator .Indent ();

      generator .beginObject ("ROUTE", false, true);

      generator .stringProperty ("@fromNode",  sourceNodeName, false);
      generator .stringProperty ("@fromField", this .getSourceField ());
      generator .stringProperty ("@toNode",    destinationNodeName);
      generator .stringProperty ("@toField",   this .getDestinationField ());

      generator .endObject ();
      generator .endObject ();
   },
   dispose ()
   {
      if (this [_disposed])
         return;

      this [_disposed] = true;

      this .disconnect ();

      if (this [_sourceNode] instanceof _Execution_X3DImportedNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A)
         this [_sourceNode] .getInlineNode () ._loadState .removeInterest ("reconnect", this);

      if (this [_destinationNode] instanceof _Execution_X3DImportedNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A)
         this [_destinationNode] .getInlineNode () ._loadState .removeInterest ("reconnect", this);

      this [_executionContext] .deleteRoute (this);

      _Base_X3DObject_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .prototype .dispose .call (this);
   }
});

for (const key of Object .keys (X3DRoute .prototype))
   Object .defineProperty (X3DRoute .prototype, key, { enumerable: false });

Object .defineProperties (X3DRoute .prototype,
{
   sourceNode:
   {
      get ()
      {
         return _Fields_SFNodeCache_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .get (this .getSourceNode ());
      },
      enumerable: true,
   },
   sourceField:
   {
      get: X3DRoute .prototype .getSourceField,
      enumerable: true,
   },
   destinationNode:
   {
      get ()
      {
         return _Fields_SFNodeCache_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .get (this .getDestinationNode ());
      },
      enumerable: true,
   },
   destinationField:
   {
      get: X3DRoute .prototype .getDestinationField,
      enumerable: true,
   },
});

Object .defineProperties (X3DRoute,
{
   typeName:
   {
      value: "X3DRoute",
      enumerable: true,
   },
});

Object .assign (X3DRoute,
{
   getRouteId (sourceNode, sourceFieldName, destinationNode, destinationFieldName)
   {
      const sourceField = sourceNode instanceof _Components_Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A
         ? sourceNode .getField (sourceFieldName)
         : $.try (() => sourceNode .getExportedNode () .getField (sourceFieldName));

      const destinationField = destinationNode instanceof _Components_Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A
         ? destinationNode .getField (destinationFieldName)
         : $.try (() => destinationNode .getExportedNode () .getField (destinationFieldName));

      if (sourceField)
      {
         sourceFieldName = sourceField .getName ();

         if (sourceField .getAccessType () === _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .inputOutput)
            sourceFieldName += "_changed";
      }

      if (destinationField)
      {
         destinationFieldName = destinationField .getName ();

         if (destinationField .getAccessType () === _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .inputOutput)
            destinationFieldName = "set_" + destinationFieldName;
      }

      return `${sourceNode .getId ()}.${sourceFieldName}.${destinationNode .getId ()}.${destinationFieldName}`;
   },
});

const __default__ = X3DRoute;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .add ("X3DRoute", __default__));

/***/ }),

/***/ 388:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(2639);
/* harmony import */ var _x_ite_Namespace_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(6707);


function Line3 (point = _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .ZERO, direction = _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .Z_AXIS)
{
   this .point     = new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A ();
   this .direction = new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A ();

   this .set (point, direction);
}

Object .assign (Line3 .prototype,
{
   copy ()
   {
      const copy = Object .create (Line3 .prototype);

      copy .point     = this .point .copy ();
      copy .direction = this .direction .copy ();

      return copy;
   },
   assign (line)
   {
      this .point     .assign (line .point);
      this .direction .assign (line .direction);

      return this;
   },
   equals (line)
   {
      return this .point .equals (line .point) && this .direction .equals (line .direction);
   },
   set (point = _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .ZERO, direction = _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .Z_AXIS)
   {
      this .point     .assign (point);
      this .direction .assign (direction);
      return this;
   },
   setPoints (point1, point2)
   {
      this .point .assign (point1);
      this .direction .assign (point2) .subtract (point1) .normalize ();
      return this;
   },
   multMatrixLine (matrix)
   {
      matrix .multMatrixVec (this .point);
      matrix .multMatrixDir (this .direction) .normalize ();
      return this;
   },
   multLineMatrix (matrix)
   {
      matrix .multVecMatrix (this .point);
      matrix .multDirMatrix (this .direction) .normalize ();
      return this;
   },
   getClosestPointToPoint (point, result = new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A ())
   {
      const
         r = result .assign (point) .subtract (this .point),
         d = r .dot (this .direction);

      return result .assign (this .direction) .multiply (d) .add (this .point);
   },
   getClosestPointToLine: (() =>
   {
      const u = new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A ();

      return function (line, point)
      {
         const
            { point: p1, direction: d1 } = this,
            { point: p2, direction: d2 } = line;

         let t = d1 .dot (d2);

         if (Math .abs (t) >= 1)
            return false;  // lines are parallel

         u .assign (p2) .subtract (p1);

         t = (u .dot (d1) - t * u .dot (d2)) / (1 - t * t);

         point .assign (d1) .multiply (t) .add (p1);
         return true;
      };
   })(),
   getPerpendicularVectorToPoint: (() =>
   {
      const t = new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A ();

      return function (point, result = new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A ())
      {
         result .assign (this .point) .subtract (point);

         return result .subtract (t .assign (this .direction) .multiply (result .dot (this .direction)));
      };
   })(),
   getPerpendicularVectorToLine: (() =>
   {
      const
         diff   = new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A (),
         proj   = new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A (),
         d      = new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A (),
         point1 = new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A ();

      return function (line, result = new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A ())
      {
         const
            { point: p1, direction: d1 } = this,
            { point: p2, direction: d2 } = line;

         const t = d1 .dot (d2);

         if (Math .abs (t) >= 1)
         {
            // Lines are parallel

            diff .assign (p2) .subtract (p1);
            proj .assign (d1) .multiply (diff .dot (d1) / d1 .dot (d1));

            return proj .subtract (diff);
         }

         d .assign (p1) .subtract (p2);

         const
            re1 = d .dot (d1),
            re2 = d .dot (d2),
            e12 = d1 .dot (d2),
            E12 = e12 * e12;

         const
            a =  (re1 - re2 * e12) / (1 - E12),
            b = -(re2 - re1 * e12) / (1 - E12);

         point1 .assign (d1) .multiply (a);
         result .assign (d2) .multiply (b);

         return result .subtract (point1) .add (d);
      };
   })(),
   intersectsTriangle: (() =>
   {
      const
         pvec = new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A (),
         tvec = new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A ();

      return function (A, B, C, uvt)
      {
         // Find vectors for two edges sharing vert0.
         const
            edge1 = B .subtract (A),
            edge2 = C .subtract (A);

         // Begin calculating determinant - also used to calculate U parameter.
         pvec .assign (this .direction) .cross (edge2);

         // If determinant is near zero, ray lies in plane of triangle.
         const det = edge1 .dot (pvec);

         // Non culling intersection.

         if (det === 0)
            return false;

            const inv_det = 1 / det;

         // Calculate distance from vert0 to ray point.
         tvec .assign (this .point) .subtract (A);

         // Calculate U parameter and test bounds.
         const u = tvec .dot (pvec) * inv_det;

         if (u < 0 || u > 1)
            return false;

         // Prepare to test V parameter.
         const qvec = tvec .cross (edge1);

         // Calculate V parameter and test bounds.
         const v = this .direction .dot (qvec) * inv_det;

         if (v < 0 || u + v > 1)
            return false;

         //let u = edge2 .dot (qvec) * inv_det;

         uvt .u = 1 - u - v;
         uvt .v = u;
         uvt .t = v;

         return true;
      };
   })(),
   toString ()
   {
      return `${this .point}, ${this .direction}`;
   },
});

Object .assign (Line3,
{
   Points (point1, point2)
   {
      const line = Object .create (Line3 .prototype);
      line .point     = point1 .copy ();
      line .direction = point2 .copy () .subtract (point1) .normalize ();
      return line;
   },
});

const __default__ = Line3;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_x_ite_Namespace_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .add ("Line3", __default__));

/***/ }),

/***/ 564:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  A: () => (/* binding */ x_ite_Fields)
});

// EXTERNAL MODULE: ./src/x_ite/Base/X3DField.js
var X3DField = __webpack_require__(5702);
// EXTERNAL MODULE: ./src/x_ite/Base/X3DConstants.js
var X3DConstants = __webpack_require__(8899);
// EXTERNAL MODULE: ./src/x_ite/Namespace.js
var Namespace = __webpack_require__(6707);
;// ./src/x_ite/Fields/SFScalar.js



function SFBoolTemplate (TypeName)
{
   function SFBool (value)
   {
      X3DField/* default */.A .call (this, !! value);
   }

   return SFScalarPrototypeTemplate (SFBool, TypeName,
   {
      isDefaultValue ()
      {
         return this .getValue () === false;
      },
      set (value)
      {
         X3DField/* default */.A .prototype .set .call (this, !! value);
      },
      toStream (generator)
      {
         generator .string += this .getValue () ? "TRUE" : "FALSE";
      },
      toXMLStream (generator)
      {
         generator .string += this .getValue () ? "true" : "false";
      },
      toJSONStreamValue (generator)
      {
         generator .string += this .getValue () ? "true" : "false";
      },
   });
}

function SFNumberTemplate (TypeName, double, defaultValue)
{
   const _formatter = double ? "DoubleFormat" : "FloatFormat";

   function SFNumber (value)
   {
      X3DField/* default */.A .call (this, arguments .length ? +value : defaultValue);
   }

   return SFScalarPrototypeTemplate (SFNumber, TypeName,
   {
      isDefaultValue ()
      {
         return this .getValue () === defaultValue;
      },
      set (value)
      {
         X3DField/* default */.A .prototype .set .call (this, +value);
      },
      toStream (generator)
      {
         const category = this .getUnit ();

         generator .string += generator [_formatter] (generator .ToUnit (category, this .getValue ()));
      },
      toJSONStreamValue (generator)
      {
         const category = this .getUnit ();

         generator .string += generator .Number (generator [_formatter] (generator .ToUnit (category, this .getValue ())));
      },
   });
}

function SFInt32Template (TypeName)
{
   function SFInt32 (value)
   {
      X3DField/* default */.A .call (this, value|0);
   }

   return SFScalarPrototypeTemplate (SFInt32, TypeName,
   {
      isDefaultValue ()
      {
         return this .getValue () === 0;
      },
      set (value)
      {
         X3DField/* default */.A .prototype .set .call (this, value|0);
      },
   });
}

function SFStringTemplate (TypeName)
{
   function SFString (value)
   {
      X3DField/* default */.A .call (this, arguments .length ? String (value) : "");
   }

   SFScalarPrototypeTemplate (SFString, TypeName,
   {
      *[Symbol .iterator] ()
      {
         yield* this .getValue ();
      },
      isDefaultValue ()
      {
         return this .getValue () === "";
      },
      set (value)
      {
         X3DField/* default */.A .prototype .set .call (this, String (value));
      },
      toStream (generator)
      {
         generator .string += '"';
         generator .string += SFString .escape (this .getValue ());
         generator .string += '"';
      },
      toXMLStream (generator, sourceText = false)
      {
         generator .string += sourceText
            ? generator .EncodeSourceText (this .getValue ())
            : generator .EncodeString (this .getValue ());
      },
      toJSONStreamValue (generator)
      {
         generator .string += '"';
         generator .string += generator .EncodeString (this .getValue ());
         generator .string += '"';
      },
   });

   Object .defineProperty (SFString .prototype, "length",
   {
      get ()
      {
         return this .getValue () .length;
      },
   });

   Object .assign (SFString,
   {
      unescape (string)
      {
         return string .replace (/\\([\\"])/g, "$1");
      },
      escape (string)
      {
         return string .replace (/([\\"])/g, "\\$1");
      },
   });

   return SFString;
}

function SFScalarPrototypeTemplate (Constructor, TypeName, properties = { })
{
   Object .defineProperties (Constructor,
   {
      type:
      {
         value: X3DConstants/* default */.A [TypeName],
         enumerable: true,
      },
      typeName:
      {
         value: TypeName,
         enumerable: true,
      },
   });

   Object .assign (Object .setPrototypeOf (Constructor .prototype, X3DField/* default */.A .prototype),
   {
      copy ()
      {
         return new Constructor (this .getValue ());
      },
      valueOf: X3DField/* default */.A .prototype .getValue,
      toStream (generator)
      {
         generator .string += String (this .getValue ());
      },
      toVRMLStream (generator)
      {
         this .toStream (generator);
      },
      toXMLStream (generator)
      {
         this .toStream (generator);
      },
      toJSONStream (generator)
      {
         this .toJSONStreamValue (generator);
      },
      toJSONStreamValue (generator)
      {
         this .toStream (generator);
      },
   },
   properties);

   for (const key of Object .keys (Constructor .prototype))
      Object .defineProperty (Constructor .prototype, key, { enumerable: false });

   return Constructor;
}

const SFScalar = {
   SFBool:   SFBoolTemplate   ("SFBool"),
   SFDouble: SFNumberTemplate ("SFDouble", true,  0),
   SFFloat:  SFNumberTemplate ("SFFloat",  false, 0),
   SFInt32:  SFInt32Template  ("SFInt32"),
   SFString: SFStringTemplate ("SFString"),
   SFTime:   SFNumberTemplate ("SFTime",   true, -1),
};

const __default__ = SFScalar;
;

/* harmony default export */ const Fields_SFScalar = (Namespace/* default */.A .add ("SFScalar", __default__));
// EXTERNAL MODULE: ./src/standard/Math/Numbers/Color3.js
var Color3 = __webpack_require__(567);
;// ./src/x_ite/Fields/SFColor.js




function SFColor (r, g, b)
{
   switch (arguments .length)
   {
      case 0:
         X3DField/* default */.A .call (this, new Color3/* default */.A ());
         break;

      case 1:
         X3DField/* default */.A .call (this, arguments [0]);
         break;

      case 3:
         X3DField/* default */.A .call (this, new Color3/* default */.A (+r, +g, +b));
         break;

      default:
         throw new Error ("Invalid arguments.");
   }
}

Object .assign (Object .setPrototypeOf (SFColor .prototype, X3DField/* default */.A .prototype),
{
   *[Symbol .iterator] ()
   {
      yield* this .getValue ();
   },
   copy ()
   {
      return new SFColor (this .getValue () .copy ());
   },
   equals (color)
   {
      return this .getValue () .equals (color .getValue ());
   },
   isDefaultValue ()
   {
      return this .getValue () .equals (Color3/* default */.A .BLACK);
   },
   set (value)
   {
      this .getValue () .assign (value);
   },
   getHSV ()
   {
      return this .getValue () .getHSV ([ ]);
   },
   setHSV (h, s, v)
   {
      this .getValue () .setHSV (h, s, v);
      this .addEvent ();
   },
   linearToSRGB ()
   {
      return new SFColor (this .getValue () .linearToSRGB ());
   },
   sRGBToLinear ()
   {
      return new SFColor (this .getValue () .sRGBToLinear ());
   },
   lerp: (() =>
   {
      const
         s = [ ],
         d = [ ],
         r = [ ];

      return function (destination, t)
      {
         const result = new SFColor ();

         this .getValue () .getHSV (s);
         destination .getValue () .getHSV (d);

         Color3/* default */.A .lerp (s, d, t, r);

         result .setHSV (r [0], r [1], r [2]);

         return result;
      };
   })(),
   toStream (generator)
   {
      const
         value = this .getValue (),
         last  = value .length - 1;

      for (let i = 0; i < last; ++ i)
      {
         generator .string += generator .FloatFormat (value [i]);
         generator .Space ();
      }

      generator .string += generator .FloatFormat (value [last]);
   },
   toVRMLStream (generator)
   {
      this .toStream (generator);
   },
   toXMLStream (generator)
   {
      this .toStream (generator);
   },
   toJSONStream (generator)
   {
      generator .string += '[';
      generator .TidySpace ();

      this .toJSONStreamValue (generator);

      generator .TidySpace ();
      generator .string += ']';
   },
   toJSONStreamValue (generator)
   {
      const
         value = this .getValue (),
         last  = value .length - 1;

      for (let i = 0; i < last; ++ i)
      {
         generator .string += generator .Number (generator .FloatFormat (value [i]));
         generator .string += ',';
         generator .TidySpace ();
      }

      generator .string += generator .Number (generator .FloatFormat (value [last]));
   },
});

for (const key of Object .keys (SFColor .prototype))
   Object .defineProperty (SFColor .prototype, key, { enumerable: false });

const r = {
   get ()
   {
      return this .getValue () .r;
   },
   set (value)
   {
      this .getValue () .r = +value;
      this .addEvent ();
   },
};

const g = {
   get ()
   {
      return this .getValue () .g;
   },
   set (value)
   {
      this .getValue () .g = +value;
      this .addEvent ();
   },
};

const b = {
   get ()
   {
      return this .getValue () .b;
   },
   set (value)
   {
      this .getValue () .b = +value;
      this .addEvent ();
   },
};

Object .defineProperties (SFColor .prototype,
{
   0: r,
   1: g,
   2: b,
   r: Object .assign ({ enumerable: true }, r),
   g: Object .assign ({ enumerable: true }, g),
   b: Object .assign ({ enumerable: true }, b),
});

Object .defineProperties (SFColor,
{
   type:
   {
      value: X3DConstants/* default */.A .SFColor,
      enumerable: true,
   },
   typeName:
   {
      value: "SFColor",
      enumerable: true,
   },
});

const SFColor_default_ = SFColor;
;

/* harmony default export */ const Fields_SFColor = (Namespace/* default */.A .add ("SFColor", SFColor_default_));
// EXTERNAL MODULE: ./src/standard/Math/Numbers/Color4.js
var Color4 = __webpack_require__(9302);
;// ./src/x_ite/Fields/SFColorRGBA.js





function SFColorRGBA (r, g, b, a)
{
   switch (arguments .length)
   {
      case 0:
         X3DField/* default */.A .call (this, new Color4/* default */.A ());
         break;

      case 1:
         X3DField/* default */.A .call (this, arguments [0]);
         break;

      case 4:
         X3DField/* default */.A .call (this, new Color4/* default */.A (+r, +g, +b, +a));
         break

      default:
         throw new Error ("Invalid arguments.");
   }
}

Object .assign (Object .setPrototypeOf (SFColorRGBA .prototype, X3DField/* default */.A .prototype),
{
   *[Symbol .iterator] ()
   {
      yield* this .getValue ();
   },
   copy ()
   {
      return new SFColorRGBA (this .getValue () .copy ());
   },
   equals: Fields_SFColor .prototype .equals,
   isDefaultValue ()
   {
      return this .getValue () .equals (Color4/* default */.A .TRANSPARENT);
   },
   set: Fields_SFColor .prototype .set,
   getHSVA ()
   {
      return this .getValue () .getHSVA ([ ]);
   },
   setHSVA (h, s, v, a)
   {
      this .getValue () .setHSVA (h, s, v, a);
      this .addEvent ();
   },
   linearToSRGB ()
   {
      return new SFColorRGBA (this .getValue () .linearToSRGB ());
   },
   sRGBToLinear ()
   {
      return new SFColorRGBA (this .getValue () .sRGBToLinear ());
   },
   lerp: (() =>
   {
      const
         s = [ ],
         d = [ ],
         r = [ ];

      return function (destination, t)
      {
         const result = new SFColorRGBA ();

         this .getValue () .getHSVA (s);
         destination .getValue () .getHSVA (d);

         Color4/* default */.A .lerp (s, d, t, r);

         result .setHSVA (r [0], r [1], r [2], r [3]);

         return result;
      };
   })(),
   toStream: Fields_SFColor .prototype .toStream,
   toVRMLStream: Fields_SFColor .prototype .toVRMLStream,
   toXMLStream: Fields_SFColor .prototype .toXMLStream,
   toJSONStream: Fields_SFColor .prototype .toJSONStream,
   toJSONStreamValue: Fields_SFColor .prototype .toJSONStreamValue,
});

for (const key of Object .keys (SFColorRGBA .prototype))
   Object .defineProperty (SFColorRGBA .prototype, key, { enumerable: false });

const SFColorRGBA_r = {
   get ()
   {
      return this .getValue () .r;
   },
   set (value)
   {
      this .getValue () .r = +value;
      this .addEvent ();
   },
};

const SFColorRGBA_g = {
   get ()
   {
      return this .getValue () .g;
   },
   set (value)
   {
      this .getValue () .g = +value;
      this .addEvent ();
   },
};

const SFColorRGBA_b = {
   get ()
   {
      return this .getValue () .b;
   },
   set (value)
   {
      this .getValue () .b = +value;
      this .addEvent ();
   },
};

const a = {
   get ()
   {
      return this .getValue () .a;
   },
   set (value)
   {
      this .getValue () .a = +value;
      this .addEvent ();
   },
};

Object .defineProperties (SFColorRGBA .prototype,
{
   0: SFColorRGBA_r,
   1: SFColorRGBA_g,
   2: SFColorRGBA_b,
   3: a,
   r: Object .assign ({ enumerable: true }, SFColorRGBA_r),
   g: Object .assign ({ enumerable: true }, SFColorRGBA_g),
   b: Object .assign ({ enumerable: true }, SFColorRGBA_b),
   a: Object .assign ({ enumerable: true }, a),
});

Object .defineProperties (SFColorRGBA,
{
   type:
   {
      value: X3DConstants/* default */.A .SFColorRGBA,
      enumerable: true,
   },
   typeName:
   {
      value: "SFColorRGBA",
      enumerable: true,
   },
});

const SFColorRGBA_default_ = SFColorRGBA;
;

/* harmony default export */ const Fields_SFColorRGBA = (Namespace/* default */.A .add ("SFColorRGBA", SFColorRGBA_default_));
;// ./src/x_ite/Fields/SFMatrixPrototypeTemplate.js



function SFMatrixPrototypeTemplate (Constructor, TypeName, Matrix, double, properties = { })
{
   const _formatter = double ? "DoubleFormat" : "FloatFormat";

   Object .defineProperties (Constructor,
   {
      type:
      {
         value: X3DConstants/* default */.A [TypeName],
         enumerable: true,
      },
      typeName:
      {
         value: TypeName,
         enumerable: true,
      },
   });

   Object .assign (Object .setPrototypeOf (Constructor .prototype, X3DField/* default */.A .prototype),
   {
      *[Symbol .iterator] ()
      {
         yield* this .getValue ();
      },
      copy ()
      {
         return new (this .constructor) (this .getValue () .copy ());
      },
      equals (matrix)
      {
         return this .getValue () .equals (matrix .getValue ());
      },
      isDefaultValue ()
      {
         return this .getValue () .equals (Matrix .IDENTITY);
      },
      set (value)
      {
         this .getValue () .assign (value);
      },
      setTransform: (() =>
      {
         const args = [ ];

         return function (translation, rotation, scale, scaleOrientation, center)
         {
            args .push (translation      ?.getValue (),
                        rotation         ?.getValue (),
                        scale            ?.getValue (),
                        scaleOrientation ?.getValue (),
                        center           ?.getValue ());

            for (let i = args .length - 1; i > -1; -- i)
            {
               if (args [i])
                  break;

               args .pop ();
            }

            this .getValue () .set (... args);

            args .length = 0;
         };
      })(),
      getTransform: (() =>
      {
         const args = [ ];

         return function (translation, rotation, scale, scaleOrientation, center)
         {
            args .push (translation      ?.getValue (),
                        rotation         ?.getValue (),
                        scale            ?.getValue (),
                        scaleOrientation ?.getValue (),
                        center           ?.getValue ());

            for (let i = args .length - 1; i > -1; -- i)
            {
               if (args [i])
                  break;

               args .pop ();
            }

            this .getValue () .get (... args);

            translation      ?.addEvent ();
            rotation         ?.addEvent ();
            scale            ?.addEvent ();
            scaleOrientation ?.addEvent ();

            args .length = 0;
         };
      })(),
      determinant ()
      {
         return this .getValue () .determinant ();
      },
      transpose ()
      {
         return new (this .constructor) (this .getValue () .copy () .transpose ());
      },
      inverse ()
      {
         return new (this .constructor) (this .getValue () .copy () .inverse ());
      },
      multLeft (matrix)
      {
         return new (this .constructor) (this .getValue () .copy () .multLeft (matrix .getValue ()));
      },
      multRight (matrix)
      {
         return new (this .constructor) (this .getValue () .copy () .multRight (matrix .getValue ()));
      },
      multVecMatrix (vector)
      {
         return new (vector .constructor) (this .getValue () .multVecMatrix (vector .getValue () .copy ()));
      },
      multMatrixVec (vector)
      {
         return new (vector .constructor) (this .getValue () .multMatrixVec (vector .getValue () .copy ()));
      },
      multDirMatrix (vector)
      {
         return new (vector .constructor) (this .getValue () .multDirMatrix (vector .getValue () .copy ()));
      },
      multMatrixDir (vector)
      {
         return new (vector .constructor) (this .getValue () .multMatrixDir (vector .getValue () .copy ()));
      },
      translate (translation)
      {
         return new (this .constructor) (this .getValue () .copy () .translate (translation .getValue ()));
      },
      rotate (rotation)
      {
         return new (this .constructor) (this .getValue () .copy () .rotate (rotation .getValue ()));
      },
      scale (scale)
      {
         return new (this .constructor) (this .getValue () .copy () .scale (scale .getValue ()));
      },
      toStream (generator)
      {
         const
            value = this .getValue (),
            last  = value .length - 1;

         for (let i = 0; i < last; ++ i)
         {
            generator .string += generator [_formatter] (value [i]);
            generator .Space ();
         }

         generator .string += generator [_formatter] (value [last]);
      },
      toVRMLStream (generator)
      {
         this .toStream (generator);
      },
      toXMLStream (generator)
      {
         this .toStream (generator);
      },
      toJSONStream (generator)
      {
         generator .string += '[';
         generator .TidySpace ();

         this .toJSONStreamValue (generator);

         generator .TidySpace ();
         generator .string += ']';
      },
      toJSONStreamValue (generator)
      {
         const
            value = this .getValue (),
            last  = value .length - 1;

         for (let i = 0; i < last; ++ i)
         {
            generator .string += generator .Number (generator [_formatter] (value [i]));
            generator .string += ',';
            generator .TidySpace ();
         }

         generator .string += generator .Number (generator [_formatter] (value [last]));
      },
   },
   properties);

   for (const key of Object .keys (Constructor .prototype))
      Object .defineProperty (Constructor .prototype, key, { enumerable: false });

   function defineProperty (i)
   {
      Object .defineProperty (Constructor .prototype, i,
      {
         get ()
         {
            return this .getValue () [i];
         },
         set (value)
         {
            this .getValue () [i] = +value;
            this .addEvent ();
         },
         enumerable: true,
      });
   }

   for (let i = 0; i < Matrix .prototype .length; ++ i)
      defineProperty (i);

   return Constructor;
}

const SFMatrixPrototypeTemplate_default_ = SFMatrixPrototypeTemplate;
;

/* harmony default export */ const Fields_SFMatrixPrototypeTemplate = (Namespace/* default */.A .add ("SFMatrixPrototypeTemplate", SFMatrixPrototypeTemplate_default_));
// EXTERNAL MODULE: ./src/standard/Math/Numbers/Matrix3.js + 1 modules
var Matrix3 = __webpack_require__(3012);
;// ./src/x_ite/Fields/SFMatrix3.js




function SFMatrix3Template (TypeName, double)
{
   function SFMatrix3 (m00, m01, m02,
                       m10, m11, m12,
                       m20, m21, m22)
   {
      switch (arguments .length)
      {
         case 0:
            X3DField/* default */.A .call (this, new Matrix3/* default */.A ());
            break;

         case 1:
            X3DField/* default */.A .call (this, arguments [0]);
            break;

         case 3:
         {
            const
               r0 = arguments [0],
               r1 = arguments [1],
               r2 = arguments [2];

            X3DField/* default */.A .call (this, new Matrix3/* default */.A (r0 .x, r0 .y, r0 .z,
                                               r1 .x, r1 .y, r1 .z,
                                               r2 .x, r2 .y, r2 .z));

            break;
         }
         case 9:
         {
            X3DField/* default */.A .call (this, new Matrix3/* default */.A (+m00, +m01, +m02,
                                               +m10, +m11, +m12,
                                               +m20, +m21, +m22));

            break;
         }
         default:
            throw new Error ("Invalid arguments.");
      }
   }

   return Fields_SFMatrixPrototypeTemplate (SFMatrix3, TypeName, Matrix3/* default */.A, double,
   {
      setTransform: (() =>
      {
         const args = [ ];

         return function (translation, rotation, scale, scaleOrientation, center)
         {
            args .push (translation ?.getValue (), rotation, scale ?.getValue (), scaleOrientation, center ?.getValue ());

            for (let i = args .length - 1; i > -1; -- i)
            {
               if (args [i])
                  break;

               args .pop ();
            }

            this .getValue () .set (... args);

            args .length = 0;
         };
      })(),
      rotate (rotation)
      {
         return new (this .constructor) (this .getValue () .copy () .rotate (rotation));
      },
      skewX (angle)
      {
         return new (this .constructor) (this .getValue () .copy () .skewX (angle));
      },
      skewY (angle)
      {
         return new (this .constructor) (this .getValue () .copy () .skewY (angle));
      },
   });
}

const SFMatrix3 = {
   SFMatrix3d: SFMatrix3Template ("SFMatrix3d", true),
   SFMatrix3f: SFMatrix3Template ("SFMatrix3f", false),
};

const SFMatrix3_default_ = SFMatrix3;
;

/* harmony default export */ const Fields_SFMatrix3 = (Namespace/* default */.A .add ("SFMatrix3", SFMatrix3_default_));
// EXTERNAL MODULE: ./src/standard/Math/Numbers/Matrix4.js
var Matrix4 = __webpack_require__(1048);
;// ./src/x_ite/Fields/SFMatrix4.js




function SFMatrix4Template (TypeName, double)
{
   function SFMatrix4 (m00, m01, m02, m03,
                       m10, m11, m12, m13,
                       m20, m21, m22, m23,
                       m30, m31, m32, m33)
   {
      switch (arguments .length)
      {
         case 0:
            X3DField/* default */.A .call (this, new Matrix4/* default */.A ());
            break;

         case 1:
            X3DField/* default */.A .call (this, arguments [0]);
            break;

         case 4:
         {
            const
               r0 = arguments [0],
               r1 = arguments [1],
               r2 = arguments [2],
               r3 = arguments [3];

            X3DField/* default */.A .call (this, new Matrix4/* default */.A (r0 .x, r0 .y, r0 .z, r0 .w,
                                               r1 .x, r1 .y, r1 .z, r1 .w,
                                               r2 .x, r2 .y, r2 .z, r2 .w,
                                               r3 .x, r3 .y, r3 .z, r3 .w));

            break;
         }
         case 16:
         {
            X3DField/* default */.A .call (this, new Matrix4/* default */.A (+m00, +m01, +m02, +m03,
                                               +m10, +m11, +m12, +m13,
                                               +m20, +m21, +m22, +m23,
                                               +m30, +m31, +m32, +m33));

            break;
         }
         default:
            throw new Error ("Invalid arguments.");
      }
   }

   return Fields_SFMatrixPrototypeTemplate (SFMatrix4, TypeName, Matrix4/* default */.A, double);
}

const SFMatrix4 = {
   SFMatrix4d: SFMatrix4Template ("SFMatrix4d", true),
   SFMatrix4f: SFMatrix4Template ("SFMatrix4f", false),
   VrmlMatrix: SFMatrix4Template ("VrmlMatrix", false),
};

const SFMatrix4_default_ = SFMatrix4;
;

/* harmony default export */ const Fields_SFMatrix4 = (Namespace/* default */.A .add ("SFMatrix4", SFMatrix4_default_));
// EXTERNAL MODULE: ./src/x_ite/Fields/SFNode.js
var SFNode = __webpack_require__(1426);
;// ./src/x_ite/Fields/SFVecPrototypeTemplate.js



function SFVecPrototypeTemplate (Constructor, TypeName, Vector, double, properties = { })
{
   const _formatter = double ? "DoubleFormat" : "FloatFormat";

   Object .defineProperties (Constructor,
   {
      type:
      {
         value: X3DConstants/* default */.A [TypeName],
         enumerable: true,
      },
      typeName:
      {
         value: TypeName,
         enumerable: true,
      },
   });

   Object .assign (Object .setPrototypeOf (Constructor .prototype, X3DField/* default */.A .prototype),
   {
      *[Symbol .iterator] ()
      {
         yield* this .getValue ();
      },
      copy ()
      {
         return new (this .constructor) (this .getValue () .copy ());
      },
      equals (vector)
      {
         return this .getValue () .equals (vector .getValue ());
      },
      isDefaultValue ()
      {
         return this .getValue () .equals (Vector .ZERO);
      },
      set (value)
      {
         this .getValue () .assign (value);
      },
      abs ()
      {
         return new (this .constructor) (this .getValue () .copy () .abs ());
      },
      add (vector)
      {
         return new (this .constructor) (this .getValue () .copy () .add (vector .getValue ()));
      },
      clamp (low, high)
      {
         return new (this .constructor) (this .getValue () .copy () .clamp (low .getValue (), high .getValue ()));
      },
      distance (vector)
      {
         return this .getValue () .distance (vector .getValue ());
      },
      divide (value)
      {
         return new (this .constructor) (this .getValue () .copy () .divide (value));
      },
      divVec (vector)
      {
         return new (this .constructor) (this .getValue () .copy () .divVec (vector .getValue ()));
      },
      dot (vector)
      {
         return this .getValue () .dot (vector .getValue ());
      },
      inverse ()
      {
         return new (this .constructor) (this .getValue () .copy () .inverse ());
      },
      length ()
      {
         return this .getValue () .norm ();
      },
      lerp (destination, t)
      {
         return new (this .constructor) (this .getValue () .copy () .lerp (destination, t));
      },
      max (vector)
      {
         return new (this .constructor) (this .getValue () .copy () .max (vector .getValue ()));
      },
      min (vector)
      {
         return new (this .constructor) (this .getValue () .copy () .min (vector .getValue ()));
      },
      multiply (value)
      {
         return new (this .constructor) (this .getValue () .copy () .multiply (value));
      },
      multVec (vector)
      {
         return new (this .constructor) (this .getValue () .copy () .multVec (vector .getValue ()));
      },
      negate ()
      {
         return new (this .constructor) (this .getValue () .copy () .negate ());
      },
      normalize (vector)
      {
         return new (this .constructor) (this .getValue () .copy () .normalize ());
      },
      subtract (vector)
      {
         return new (this .constructor) (this .getValue () .copy () .subtract (vector .getValue ()));
      },
      toStream (generator)
      {
         const
            value    = this .getValue (),
            last     = value .length - 1,
            category = this .getUnit ();

         for (let i = 0; i < last; ++ i)
         {
            generator .string += generator [_formatter] (generator .ToUnit (category, value [i]));
            generator .Space ();
         }

         generator .string += generator [_formatter] (generator .ToUnit (category, value [last]));
      },
      toVRMLStream (generator)
      {
         this .toStream (generator);
      },
      toXMLStream (generator)
      {
         this .toStream (generator);
      },
      toJSONStream (generator)
      {
         generator .string += '[';
         generator .TidySpace ();

         this .toJSONStreamValue (generator);

         generator .TidySpace ();
         generator .string += ']';
      },
      toJSONStreamValue (generator)
      {
         const
            value    = this .getValue (),
            last     = value .length - 1,
            category = this .getUnit ();

         for (let i = 0; i < last; ++ i)
         {
            generator .string += generator .Number (generator [_formatter] (generator .ToUnit (category, value [i])));
            generator .string += ',';
            generator .TidySpace ();
         }

         generator .string += generator .Number (generator [_formatter] (generator .ToUnit (category, value [last])));
      },
   },
   properties);

   for (const key of Object .keys (Constructor .prototype))
      Object .defineProperty (Constructor .prototype, key, { enumerable: false });

   const x = {
      get ()
      {
         return this .getValue () .x;
      },
      set (value)
      {
         this .getValue () .x = +value;
         this .addEvent ();
      },
   };

   const y = {
      get ()
      {
         return this .getValue () .y;
      },
      set (value)
      {
         this .getValue () .y = +value;
         this .addEvent ();
      },
   };

   const z = {
      get ()
      {
         return this .getValue () .z;
      },
      set (value)
      {
         this .getValue () .z = +value;
         this .addEvent ();
      },
   };

   const w = {
      get ()
      {
         return this .getValue () .w;
      },
      set (value)
      {
         this .getValue () .w = +value;
         this .addEvent ();
      },
   };

   const indices = [
      [0, x],
      [1, y],
      [2, z],
      [3, w],
   ];

   const props = [
      ["x", Object .assign ({ enumerable: true }, x)],
      ["y", Object .assign ({ enumerable: true }, y)],
      ["z", Object .assign ({ enumerable: true }, z)],
      ["w", Object .assign ({ enumerable: true }, w)],
   ];

   indices .length = Vector .prototype .length;
   props   .length = Vector .prototype .length;

   Object .defineProperties (Constructor .prototype, Object .fromEntries (indices .concat (props)));

   return Constructor;
}

const SFVecPrototypeTemplate_default_ = SFVecPrototypeTemplate;
;

/* harmony default export */ const Fields_SFVecPrototypeTemplate = (Namespace/* default */.A .add ("SFVecPrototypeTemplate", SFVecPrototypeTemplate_default_));
// EXTERNAL MODULE: ./src/standard/Math/Numbers/Vector3.js
var Vector3 = __webpack_require__(2639);
;// ./src/x_ite/Fields/SFVec3.js




function SFVec3Template (TypeName, double)
{
   function SFVec3 (x, y, z)
   {
      switch (arguments .length)
      {
         case 0:
            X3DField/* default */.A .call (this, new Vector3/* default */.A ());
            break;

         case 1:
            X3DField/* default */.A .call (this, arguments [0]);
            break;

         case 3:
            X3DField/* default */.A .call (this, new Vector3/* default */.A (+x, +y, +z));
            break;

         default:
            throw new Error ("Invalid arguments.");
      }
   }

   return Fields_SFVecPrototypeTemplate (SFVec3, TypeName, Vector3/* default */.A, double,
   {
      cross (vector)
      {
         return new (this .constructor) (this .getValue () .copy () .cross (vector .getValue ()));
      },
   });
}

const SFVec3 = {
   SFVec3d: SFVec3Template ("SFVec3d", true),
   SFVec3f: SFVec3Template ("SFVec3f", false),
};

const SFVec3_default_ = SFVec3;
;

/* harmony default export */ const Fields_SFVec3 = (Namespace/* default */.A .add ("SFVec3", SFVec3_default_));
// EXTERNAL MODULE: ./src/standard/Math/Numbers/Rotation4.js
var Rotation4 = __webpack_require__(1029);
// EXTERNAL MODULE: ./src/standard/Math/Numbers/Quaternion.js
var Quaternion = __webpack_require__(9595);
;// ./src/x_ite/Fields/SFRotation.js







const
   SFVec3d    = Fields_SFVec3 .SFVec3d,
   SFVec3f    = Fields_SFVec3 .SFVec3f,
   SFMatrix3d = Fields_SFMatrix3 .SFMatrix3d,
   SFMatrix3f = Fields_SFMatrix3 .SFMatrix3f;

function SFRotation (x, y, z, angle)
{
   switch (arguments .length)
   {
      case 0:
      {
         X3DField/* default */.A .call (this, new Rotation4/* default */.A ());
         break;
      }
      case 1:
      {
         if ((arguments [0] instanceof SFMatrix3d) || (arguments [0] instanceof SFMatrix3f))
         {
            X3DField/* default */.A .call (this, new Rotation4/* default */.A () .setMatrix (arguments [0] .getValue ()));
            break;
         }

         X3DField/* default */.A .call (this, arguments [0]);
         break;
      }
      case 2:
      {
         if ((arguments [1] instanceof SFVec3d) || (arguments [1] instanceof SFVec3f))
         {
            X3DField/* default */.A .call (this, new Rotation4/* default */.A (arguments [0] .getValue (), arguments [1] .getValue ()));
            break;
         }

         X3DField/* default */.A .call (this, new Rotation4/* default */.A (arguments [0] .getValue (), +arguments [1]));
         break;
      }
      case 4:
      {
         X3DField/* default */.A .call (this, new Rotation4/* default */.A (+x, +y, +z, +angle));
         break;
      }
      default:
         throw new Error ("Invalid arguments.");
   }
}

Object .assign (Object .setPrototypeOf (SFRotation .prototype, X3DField/* default */.A .prototype),
{
   *[Symbol .iterator] ()
   {
      yield* this .getValue ();
   },
   copy ()
   {
      return new SFRotation (this .getValue () .copy ());
   },
   equals (rotation)
   {
      return this .getValue () .equals (rotation .getValue ());
   },
   isDefaultValue ()
   {
      return this .getValue () .equals (Rotation4/* default */.A .IDENTITY);
   },
   set (value)
   {
      this .getValue () .assign (value);
   },
   setAxis (vector)
   {
      this .getValue () .setAxis (vector .getValue ());
      this .addEvent ();
   },
   getAxis ()
   {
      return new SFVec3f (this .getValue () .getAxis ());
   },
   setMatrix (matrix)
   {
      this .getValue () .setMatrix (matrix .getValue ());
      this .addEvent ();
   },
   getMatrix ()
   {
      return new SFMatrix3f (this .getValue () .getMatrix ());
   },
   setQuaternion: (() =>
   {
      const q = new Quaternion/* default */.A ();

      return function (x, y, z, w)
      {
         this .getValue () .setQuaternion (q .set (x, y, z, w));
         this .addEvent ();
      };
   })(),
   getQuaternion: (() =>
   {
      const q = new Quaternion/* default */.A ();

      return function ()
      {
         return [... this .getValue () .getQuaternion (q)];
      };
   })(),
   inverse ()
   {
      return new SFRotation (this .getValue () .copy () .inverse ());
   },
   multiply (rotation)
   {
      return new SFRotation (this .getValue () .copy () .multRight (rotation .getValue ()));
   },
   multVec (vector)
   {
      return new (vector .constructor) (this .getValue () .multVecRot (vector .getValue () .copy ()));
   },
   slerp (rotation, t)
   {
      return new SFRotation (this .getValue () .copy () .slerp (rotation .getValue (), t));
   },
   straighten (upVector)
   {
      return new SFRotation (this .getValue () .copy () .straighten (upVector ?.getValue ()));
   },
   toStream (generator)
   {
      const { x, y, z, angle } = this .getValue ();

      generator .string += generator .DoubleFormat (x);
      generator .Space ();
      generator .string += generator .DoubleFormat (y);
      generator .Space ();
      generator .string += generator .DoubleFormat (z);
      generator .Space ();
      generator .string += generator .DoubleFormat (generator .ToUnit ("angle", angle));
   },
   toVRMLStream (generator)
   {
      this .toStream (generator);
   },
   toXMLStream (generator)
   {
      this .toStream (generator);
   },
   toJSONStream (generator)
   {
      generator .string += '[';
      generator .TidySpace ();

      this .toJSONStreamValue (generator);

      generator .TidySpace ();
      generator .string += ']';
   },
   toJSONStreamValue (generator)
   {
      const { x, y, z, angle } = this .getValue ();

      generator .string += generator .Number (generator .DoubleFormat (x));
      generator .string += ',';
      generator .TidySpace ();
      generator .string += generator .Number (generator .DoubleFormat (y));
      generator .string += ',';
      generator .TidySpace ();
      generator .string += generator .Number (generator .DoubleFormat (z));
      generator .string += ',';
      generator .TidySpace ();
      generator .string += generator .Number (generator .DoubleFormat (generator .ToUnit ("angle", angle)));
   },
});

for (const key of Object .keys (SFRotation .prototype))
   Object .defineProperty (SFRotation .prototype, key, { enumerable: false });

const x = {
   get ()
   {
      return this .getValue () .x;
   },
   set (value)
   {
      this .getValue () .x = +value;
      this .addEvent ();
   },
};

const y = {
   get ()
   {
      return this .getValue () .y;
   },
   set (value)
   {
      this .getValue () .y = +value;
      this .addEvent ();
   },
};

const z = {
   get ()
   {
      return this .getValue () .z;
   },
   set (value)
   {
      this .getValue () .z = +value;
      this .addEvent ();
   },
};

const angle = {
   get ()
   {
      return this .getValue () .angle;
   },
   set (value)
   {
      this .getValue () .angle = +value;
      this .addEvent ();
   },
};

Object .defineProperties (SFRotation .prototype,
{
   0: x,
   1: y,
   2: z,
   3: angle,
   x: Object .assign ({ enumerable: true }, x),
   y: Object .assign ({ enumerable: true }, y),
   z: Object .assign ({ enumerable: true }, z),
   angle: Object .assign ({ enumerable: true }, angle),
});

Object .defineProperties (SFRotation,
{
   type:
   {
      value: X3DConstants/* default */.A .SFRotation,
      enumerable: true,
   },
   typeName:
   {
      value: "SFRotation",
      enumerable: true,
   },
});

const SFRotation_default_ = SFRotation;
;

/* harmony default export */ const Fields_SFRotation = (Namespace/* default */.A .add ("SFRotation", SFRotation_default_));
// EXTERNAL MODULE: ./src/standard/Math/Numbers/Vector2.js
var Vector2 = __webpack_require__(8024);
;// ./src/x_ite/Fields/SFVec2.js




function SFVec2Template (TypeName, double)
{
   function SFVec2 (x, y)
   {
      switch (arguments .length)
      {
         case 0:
            X3DField/* default */.A .call (this, new Vector2/* default */.A ());
            break;

         case 1:
            X3DField/* default */.A .call (this, arguments [0]);
            break;

         case 2:
            X3DField/* default */.A .call (this, new Vector2/* default */.A (+x, +y));
            break;

         default:
            throw new Error ("Invalid arguments.");
      }
   }

   return Fields_SFVecPrototypeTemplate (SFVec2, TypeName, Vector2/* default */.A, double);
}

const SFVec2 = {
   SFVec2d: SFVec2Template ("SFVec2d", true),
   SFVec2f: SFVec2Template ("SFVec2f", false),
};

const SFVec2_default_ = SFVec2;
;

/* harmony default export */ const Fields_SFVec2 = (Namespace/* default */.A .add ("SFVec2", SFVec2_default_));
// EXTERNAL MODULE: ./src/standard/Math/Numbers/Vector4.js
var Vector4 = __webpack_require__(3630);
;// ./src/x_ite/Fields/SFVec4.js




function SFVec4Template (TypeName, double)
{
   function SFVec4 (x, y, z, w)
   {
      switch (arguments .length)
      {
         case 0:
            X3DField/* default */.A .call (this, new Vector4/* default */.A (0, 0, 0, 1));
            break;

         case 1:
            X3DField/* default */.A .call (this, arguments [0]);
            break;

         case 4:
            X3DField/* default */.A .call (this, new Vector4/* default */.A (+x, +y, +z, +w));
            break;

         default:
            throw new Error ("Invalid arguments.");
      }
   }

   return Fields_SFVecPrototypeTemplate (SFVec4, TypeName, Vector4/* default */.A, double,
   {
      isDefaultValue ()
      {
         return this .getValue () .equals (Vector4/* default */.A .W_AXIS);
      },
   });
}

const SFVec4 = {
   SFVec4d: SFVec4Template ("SFVec4d", true),
   SFVec4f: SFVec4Template ("SFVec4f", false),
};

const SFVec4_default_ = SFVec4;
;

/* harmony default export */ const Fields_SFVec4 = (Namespace/* default */.A .add ("SFVec4", SFVec4_default_));
// EXTERNAL MODULE: ./src/x_ite/Base/X3DArrayField.js
var X3DArrayField = __webpack_require__(8155);
;// ./src/x_ite/Base/X3DObjectArrayField.js



const
   _target = Symbol (),
   _proxy  = Symbol (),
   _insert = Symbol (),
   _erase  = Symbol ();

const handler =
{
   get (target, key)
   {
      const value = target [key];

      if (value !== undefined)
         return value;

      if (typeof key === "string")
      {
         const
            array = target .getValue (),
            index = +key;

         if (Number .isInteger (index))
         {
            // For historical reasons this behavior is intended (resize), there are enough
            // X3D/VRML worlds in the Internet who rely on this behavior.
            if (index >= array .length)
               target .resize (index + 1);

            return array [index] .valueOf ();
         }
         else
         {
            return target [key];
         }
      }
   },
   set (target, key, value)
   {
      if (key in target)
      {
         target [key] = value;
         return true;
      }

      const
         array = target .getValue (),
         index = +key;

      if (index >= array .length)
         target .resize (index + 1);

      array [index] .setValue (value);

      return true;
   },
   has (target, key)
   {
      if (Number .isInteger (+key))
         return key < target .getValue () .length;

      return key in target;
   },
   ownKeys (target)
   {
      return Object .keys (target .getValue ());
   },
   getOwnPropertyDescriptor (target, key)
   {
      if (typeof key !== "string")
         return;

      const index = +key;

      if (Number .isInteger (index) && index < target .getValue () .length)
         return Object .getOwnPropertyDescriptor (target .getValue (), key);
   },
};

function X3DObjectArrayField (values)
{
   const proxy = new Proxy (this, handler);

   X3DArrayField/* default */.A .call (this, [ ]);

   this [_target] = this;
   this [_proxy]  = proxy;

   for (const value of values)
      this .push (value);

   return proxy;
}

Object .assign (Object .setPrototypeOf (X3DObjectArrayField .prototype, X3DArrayField/* default */.A .prototype),
{
   [_target]: null,
   [_proxy]: null,
   *[Symbol .iterator] ()
   {
      const
         target = this [_target],
         array  = target .getValue ();

      for (const value of array)
         yield value .valueOf ();
   },
   getTarget ()
   {
      return this [_target];
   },
   copy ()
   {
      const
         target = this [_target],
         copy   = target .create ();

      copy .assign (target);

      return copy;
   },
   equals (array)
   {
      const
         target = this [_target],
         a      = target .getValue (),
         b      = array .getValue (),
         length = a .length;

      if (a === b)
         return true;

      if (length !== b .length)
         return false;

      for (let i = 0; i < length; ++ i)
      {
         if (!a [i] .equals (b [i]))
            return false;
      }

      return true;
   },
   isDefaultValue ()
   {
      return this .length === 0;
   },
   set (value)
   {
      const
         target    = this [_target],
         array     = target .getValue (),
         newLength = value .length;

      target .resize (newLength, undefined, true);

      for (let i = 0; i < newLength; ++ i)
         array [i] .set (value [i] instanceof X3DField/* default */.A ? value [i] .getValue () : value [i]);
   },
   setValue (value)
   {
      const target = this [_target];

      target .set (value instanceof X3DObjectArrayField ? value .getValue () : value);
      target .addEvent ();
   },
   unshift (... args)
   {
      const
         target = this [_target],
         array  = target .getValue ();

      for (let i = args .length - 1; i >= 0; -- i)
      {
         const field = new (target .getSingleType ()) ();

         field .setValue (args [i]);
         target .addChildObject (field);
         array .unshift (field);
      }

      target .addEvent ();

      return array .length;
   },
   shift ()
   {
      const
         target = this [_target],
         array  = target .getValue ();

      if (array .length)
      {
         const
            field  = array .shift (),
            result = field .valueOf ();

         target .removeChildObject (field);
         target .addEvent ();

         return result;
      }
   },
   push (... args)
   {
      const
         target = this [_target],
         array  = target .getValue ();

      for (const argument of args)
      {
         const field = new (target .getSingleType ()) ();

         field .setValue (argument);
         target .addChildObject (field);
         array .push (field);
      }

      target .addEvent ();

      return array .length;
   },
   pop ()
   {
      const
         target = this [_target],
         array  = target .getValue ();

      if (array .length)
      {
         const
            field  = array .pop (),
            result = field .valueOf ();

         target .removeChildObject (field);
         target .addEvent ();

         return result;
      }
   },
   splice (index, deleteCount, ... insertValues)
   {
      const
         target = this [_target],
         array  = target .getValue (),
         length = array .length;

      if (arguments .length === 0)
         return new (target .constructor) ();

      if (arguments .length < 2)
         deleteCount = length;

      const result = target [_erase] (index, deleteCount);

      if (insertValues .length)
         target [_insert] (index, insertValues);

      return result;
   },
   [_insert] (index, array)
   {
      const
         target = this [_target],
         args   = [ ];

      for (const value of array)
      {
         const field = new (target .getSingleType ()) ();

         field .setValue (value);
         target .addChildObject (field);
         args .push (field);
      }

      target .getValue () .splice (index, 0, ... args);
      target .addEvent ();
   },
   [_erase] (index, deleteCount)
   {
      const
         target = this [_target],
         values = target .getValue () .splice (index, deleteCount),
         result = new (target .constructor) ();

      for (const value of values)
      {
         result .push (value);
         target .removeChildObject (value);
      }

      target .addEvent ();

      return result;
   },
   resize (newLength, value, silently)
   {
      const
         target = this [_target],
         array  = target .getValue (),
         length = array .length;

      if (newLength < 0)
         throw new RangeError ("Invalid array length");

      if (newLength < length)
      {
         for (let i = newLength; i < length; ++ i)
            target .removeChildObject (array [i]);

         array .length = newLength;

         if (!silently)
            target .addEvent ();
      }
      else if (newLength > length)
      {
         for (let i = length; i < newLength; ++ i)
         {
            const field = new (target .getSingleType ()) ();

            if (value !== undefined)
               field .setValue (value);

            target .addChildObject (field);
            array .push (field);
         }

         if (!silently)
            target .addEvent ();
      }
   },
   addChildObject (value)
   {
      value .addParent (this [_proxy]);
   },
   removeChildObject (value)
   {
      value .dispose ();
   },
   shrinkToFit ()
   {
      return this .getValue ();
   },
   concat (... args)
   {
      const
         result = this .copy (),
         target = result [_target];

      for (const arg of args)
      {
         for (const value of arg)
            target .push (value);
      }

      return result;
   },
   reverse ()
   {
      const target = this [_target];

      target .getValue () .reverse ();
      target .addEvent ();

      return target [_proxy];
   },
   sort (compareFn)
   {
      const target = this [_target];

      Array .prototype .sort .call (this, compareFn);
      target .addEvent ();

      return target [_proxy];
   },
   valueOf ()
   {
      return this [_proxy];
   },
   toStream (generator)
   {
      const
         target = this [_target],
         array  = target .getValue (),
         length = array .length;

      switch (length)
      {
         case 0:
         {
            generator .string += "[";
            generator .TidySpace ();
            generator .string += "]";
            break;
         }
         case 1:
         {
            array [0] .toStream (generator);
            break;
         }
         default:
         {
            const last = length - 1;

            generator .string += "[";
            generator .ListStart ();
            generator .IncIndent ();

            for (let i = 0; i < last; ++ i)
            {
               generator .ListIndent ();
               array [i] .toStream (generator);
               generator .Comma ();
               generator .ListBreak ();
            }

            generator .ListIndent ();
            array .at (-1) .toStream (generator);

            generator .ListEnd ();
            generator .DecIndent ();
            generator .ListIndent ();
            generator .string += "]";
            break;
         }
      }
   },
   toVRMLStream (generator)
   {
      this .toStream (generator);
   },
   toXMLStream (generator)
   {
      const
         target = this [_target],
         length = target .length;

      if (length)
      {
         const
            array = target .getValue (),
            last  = length - 1;

         for (let i = 0; i < last; ++ i)
         {
            array [i] .toXMLStream (generator);
            generator .Comma ();
            generator .TidySpace ();
         }

         array .at (-1) .toXMLStream (generator);
      }
   },
   toJSONStream (generator)
   {
      const
         target = this [_target],
         length = target .length;

      if (length)
      {
         const
            array = target .getValue (),
            last  = length - 1;

         generator .string += '[';
         generator .ListBreak ();
         generator .IncIndent ();

         for (let i = 0; i < last; ++ i)
         {
            generator .ListIndent ();

            array [i] .toJSONStreamValue (generator);

            generator .string += ',';
            generator .ListBreak ();
         }

         generator .ListIndent ();

         array .at (-1) .toJSONStreamValue (generator);

         generator .ListBreak ();
         generator .DecIndent ();
         generator .ListIndent ();
         generator .string += ']';
      }
      else
      {
         generator .string += '[';
         generator .TidySpace ();
         generator .string += ']';
      }
   },
});

for (const key of Object .keys (X3DObjectArrayField .prototype))
   Object .defineProperty (X3DObjectArrayField .prototype, key, { enumerable: false });

Object .defineProperty (X3DObjectArrayField .prototype, "length",
{
   get () { return this [_target] .getValue () .length; },
   set (value) { this [_target] .resize (value); },
});

const X3DObjectArrayField_default_ = X3DObjectArrayField;
;

/* harmony default export */ const Base_X3DObjectArrayField = (Namespace/* default */.A .add ("X3DObjectArrayField", X3DObjectArrayField_default_));
// EXTERNAL MODULE: ./src/standard/Math/Algorithm.js
var Algorithm = __webpack_require__(4559);
;// ./src/x_ite/Base/X3DTypedArrayField.js



const
   X3DTypedArrayField_target = Symbol (),
   X3DTypedArrayField_proxy  = Symbol (),
   _cache  = Symbol (),
   _tmp    = Symbol (),
   _length = Symbol (),
   X3DTypedArrayField_insert = Symbol (),
   X3DTypedArrayField_erase  = Symbol (),
   _grow   = Symbol (),
   _fill   = Symbol ();

const X3DTypedArrayField_handler =
{
   get (target, key)
   {
      const value = target [key];

      if (value !== undefined)
         return value;

      if (typeof key === "string")
      {
         const index = +key;

         if (Number .isInteger (index))
         {
            const
               components = target .getComponents (),
               valueType  = target .getValueType ();

            // For historical reasons this behavior is intended (resize), there are
            // enough X3D/VRML worlds in the Internet who rely on this behavior.
            const array = index < target [_length]
               ? target .getValue ()
               : target .resize (index + 1, target .getSingleValue ());

            if (components === 1)
            {
               // Return native JavaScript value.
               return valueType (array [index]);
            }
            else
            {
               // Return reference to index.

               return target [_cache] [index]
                  ?? (target [_cache] [index] = createValue (target, index, components, valueType));
            }
         }
         else
         {
            return target [key];
         }
      }
   },
   set (target, key, value)
   {
      if (key in target)
      {
         target [key] = value;
         return true;
      }

      const components = target .getComponents ();

      let
         index = +key,
         array = target .getValue ();

      if (index >= target [_length])
         array = target .resize (index + 1, target .getSingleValue ());

      if (components === 1)
      {
         const valueType = target .getValueType ();

         array [index] = valueType (value);
      }
      else
      {
         index *= components;

         for (let c = 0; c < components; ++ c, ++ index)
            array [index] = value [c];
      }

      target .addEvent ();

      return true;
   },
   has (target, key)
   {
      if (Number .isInteger (+key))
         return key < target [_length];

      return key in target;
   },
   ownKeys (target)
   {
      const ownKeys = [ ];

      for (let i = 0, length = target [_length]; i < length; ++ i)
         ownKeys .push (String (i));

      return ownKeys;
   },
   getOwnPropertyDescriptor (target, key)
   {
      if (typeof key !== "string")
         return;

      const index = +key;

      if (Number .isInteger (index) && index < target [_length])
         return Object .getOwnPropertyDescriptor (target .getValue (), key);
   },
};

function X3DTypedArrayField (values)
{
   const proxy = new Proxy (this, X3DTypedArrayField_handler);

   X3DArrayField/* default */.A .call (this, new (this .getArrayType ()) (16));

   this [X3DTypedArrayField_target] = this;
   this [X3DTypedArrayField_proxy]  = proxy;

   if (this .getComponents () > 1)
   {
      this [_cache] = [ ]; // Cache of elements.
      this [_tmp]   = [ ]; // Array with components size.
   }

   for (const value of values)
      this .push (value);

   return proxy;
}

Object .assign (Object .setPrototypeOf (X3DTypedArrayField .prototype, X3DArrayField/* default */.A .prototype),
{
   [X3DTypedArrayField_target]: null,
   [_tmp]: null,
   [_length]: 0,
   *[Symbol .iterator] ()
   {
      const
         target     = this [X3DTypedArrayField_target],
         array      = target .getValue (),
         components = target .getComponents (),
         valueType  = target .getValueType (),
         length     = target [_length];

      if (components === 1)
      {
         // Return native JavaScript value.

         for (let index = 0; index < length; ++ index)
            yield valueType (array [index]);
      }
      else
      {
         // Return reference to index.

         const cache = target [_cache];

         for (let index = 0; index < length; ++ index)
         {
            yield cache [index]
               ?? (cache [index] = createValue (target, index, components, valueType));
         }
      }
   },
   getTarget ()
   {
      return this [X3DTypedArrayField_target];
   },
   copy ()
   {
      const
         target = this [X3DTypedArrayField_target],
         array  = target .getValue (),
         copy   = target .create ();

      copy .set (array, target [_length]);

      return copy;
   },
   equals (other)
   {
      const
         target      = this [X3DTypedArrayField_target],
         otherTarget = other [X3DTypedArrayField_target],
         length      = target [_length];

      if (target === otherTarget)
         return true;

      if (length !== otherTarget [_length])
         return false;

      const
         a = target .getValue (),
         b = otherTarget .getValue (),
         l = length * target .getComponents ();

      for (let i = 0; i < l; ++ i)
      {
         if (a [i] !== b [i])
            return false;
      }

      return true;
   },
   assign (value)
   {
      const target = this [X3DTypedArrayField_target];

      target .set (value .getValue (), value .length);
      target .addEvent ();
   },
   set (otherArray /* value of field */, l /* length of field */)
   {
      const
         target      = this [X3DTypedArrayField_target],
         components  = target .getComponents (),
         length      = target [_length];

      let
         array       = target .getValue (),
         otherLength = l !== undefined ? l * components : otherArray .length;

      const rest = otherLength % components;

      if (rest)
      {
         otherLength -= rest;

         console .warn (`Array length must be multiple of components size, which is ${components}.`);
      }

      otherLength /= components;

      if (array .length < otherArray .length)
      {
         array = target [_grow] (otherArray .length);

         array .set (otherArray);

         if (rest)
            array .fill (0, otherLength * components, otherLength * components + rest);
      }
      else
      {
         array .set (otherArray);

         if (otherLength < length)
            array .fill (0, otherLength * components, length * components);
      }

      target [_length] = otherLength;
   },
   isDefaultValue ()
   {
      return this [_length] === 0;
   },
   setValue (value)
   {
      const target = this [X3DTypedArrayField_target];

      if (value instanceof target .constructor)
      {
         target .assign (value);
      }
      else
      {
         target .set (value);
         target .addEvent ();
      }
   },
   unshift (... args)
   {
      const
         target          = this [X3DTypedArrayField_target],
         components      = target .getComponents (),
         length          = target [_length],
         argumentsLength = args .length,
         array           = target [_grow] ((length + argumentsLength) * components);

      array .copyWithin (argumentsLength * components, 0, length * components);

      if (components === 1)
      {
         const valueType = target .getValueType ();

         for (let a = 0; a < argumentsLength; ++ a)
            array [a] = valueType (args [a]);
      }
      else
      {
         for (let i = 0, a = 0; a < argumentsLength; ++ a)
         {
            const argument = args [a];

            for (let c = 0; c < components; ++ c, ++ i)
            {
               array [i] = argument [c];
            }
         }
      }

      target [_length] += argumentsLength;

      target .addEvent ();

      return target [_length];
   },
   shift ()
   {
      const
         target = this [X3DTypedArrayField_target],
         length = target [_length];

      if (length)
      {
         const
            array      = target .getValue (),
            components = target .getComponents (),
            valueType  = target .getValueType (),
            newLength  = length - 1;

         let value;

         if (components === 1)
         {
            value = valueType (array [0]);
         }
         else
         {
            const tmp = target [_tmp];

            for (let c = 0; c < components; ++ c)
               tmp [c] = array [c];

            value = new valueType (... tmp);
         }

         array .copyWithin (0, components, length * components);
         array .fill (0, components * newLength, length * components);

         target [_length] = newLength;

         target .addEvent ();
         return value;
      }
   },
   push (... args)
   {
      const
         target          = this [X3DTypedArrayField_target],
         components      = target .getComponents (),
         length          = target [_length],
         argumentsLength = args .length,
         array           = target [_grow] ((length + argumentsLength) * components);

      if (components === 1)
      {
         const valueType = target .getValueType ();

         for (let a = 0, i = length; a < argumentsLength; ++ a, ++ i)
            array [i] = valueType (args [a]);
      }
      else
      {
         for (let i = length * components, a = 0; a < argumentsLength; ++ a)
         {
            const argument = args [a];

            for (let c = 0; c < components; ++ c,  ++ i)
            {
               array [i] = argument [c];
            }
         }
      }

      target [_length] += argumentsLength;

      target .addEvent ();

      return target [_length];
   },
   pop ()
   {
      const
         target = this [X3DTypedArrayField_target],
         length = target [_length];

      if (length)
      {
         const
            array      = target .getValue (),
            components = target .getComponents (),
            valueType  = target .getValueType (),
            newLength  = length - 1;

         let value;

         if (components === 1)
         {
            value = valueType (array [length - 1]); // Don't use at(-1).
         }
         else
         {
            const tmp = target [_tmp];

            for (let c = 0, a = newLength * components; c < components; ++ c, ++ a)
               tmp [c] = array [a];

            value = new valueType (... tmp);
         }

         array .fill (0, newLength * components, length * components);

         target [_length] = newLength;

         target .addEvent ();

         return value;
      }
   },
   splice (index, deleteCount, ... insertValues)
   {
      const
         target = this [X3DTypedArrayField_target],
         length = target [_length];

      if (arguments .length === 0)
         return new (target .constructor) ();

      index |= 0;

      if (index < 0)
         index += length;

      index = Algorithm/* default */.A .clamp (index, 0, length);

      if (arguments .length < 2)
         deleteCount = length;

      deleteCount |= 0;

      if (index + deleteCount > length)
         deleteCount = length - index;

      deleteCount = Math .max (deleteCount, 0);

      const result = target [X3DTypedArrayField_erase] (index, index + deleteCount);

      if (insertValues .length)
         target [X3DTypedArrayField_insert] (index, insertValues);

      target .addEvent ();

      return result;
   },
   [X3DTypedArrayField_insert] (index, other)
   {
      const
         target      = this [X3DTypedArrayField_target],
         components  = target .getComponents (),
         length      = target [_length],
         otherLength = other .length,
         array       = target [_grow] ((length + otherLength) * components);

      index *= components;

      array .copyWithin (index + otherLength * components, index, length * components);

      if (components === 1)
      {
         const valueType = target .getValueType ();

         for (let a = 0, i = index; a < otherLength; ++ a, ++ i)
            array [i] = valueType (other [a]);
      }
      else
      {
         for (let i = 0, a = index; i < otherLength; ++ i)
         {
            const value = other [i];

            for (let c = 0; c < components; ++ c, ++ a)
               array [a] = value [c];
         }
      }

      target [_length] += otherLength;
   },
   [X3DTypedArrayField_erase] (first, last)
   {
      const
         target     = this [X3DTypedArrayField_target],
         array      = target .getValue (),
         components = target .getComponents (),
         difference = last - first,
         length     = target [_length],
         newLength  = length - difference,
         values     = target [X3DTypedArrayField_proxy] .slice (first, last);

      first *= components;
      last  *= components;

      array .copyWithin (first, last, length * components);
      array .fill (0, newLength * components, length * components);

      target [_length] = newLength;

      if (components > 1)
         target [_cache] .length = newLength;

      target .addEvent ();

      return values;
   },
   resize (newLength, value, silently)
   {
      const
         target     = this [X3DTypedArrayField_target],
         length     = target [_length],
         components = target .getComponents ();

      if (newLength < 0)
         throw new RangeError ("Invalid array length");

      let array = target .getValue ();

      target [_length] = newLength;

      if (newLength < length)
      {
         array .fill (0, newLength * components, length * components);

         if (components > 1)
            target [_cache] .length = newLength;

         if (!silently)
            target .addEvent ();
      }
      else if (newLength > length)
      {
         array = target [_grow] (newLength * components);

         if (value !== undefined)
            this [_fill] (value, length, newLength);

         if (!silently)
            target .addEvent ();
      }

      return array;
   },
   [_grow] (length)
   {
      const
         target = this [X3DTypedArrayField_target],
         array  = target .getValue ();

      if (length <= array .length)
         return array;

      const
         maxLength = Algorithm/* default */.A .nextPowerOfTwo (length),
         newArray  = new (target .getArrayType ()) (maxLength);

      newArray .set (array);

      X3DArrayField/* default */.A .prototype .set .call (target, newArray);

      return newArray;
   },
   shrinkToFit ()
   {
      const
         target = this [X3DTypedArrayField_target],
         array  = target .getValue (),
         length = target [_length] * target .getComponents ();

      if (array .length === length)
         return array;

      const newArray = array .subarray (0, length);

      X3DArrayField/* default */.A .prototype .set .call (target, newArray);

      return newArray;
   },
   concat (... args)
   {
      const
         result     = this .copy (),
         target     = result [X3DTypedArrayField_target],
         components = target .getComponents (),
         length     = target [_length] + args .reduce ((p, c) => p + c .length, 0),
         value      = target [_grow] (length * components);

      let offset = target [_length] * components;

      for (const arg of args)
      {
         value .set (arg .shrinkToFit (), offset);

         offset += arg .length * components;
      }

      target [_length] = length;

      return result;
   },
   flat ()
   {
      const
         target     = this [X3DTypedArrayField_target],
         array      = target .shrinkToFit (),
         components = target .getComponents (),
         valueType  = target .getValueType ();

      if (components === 1)
         return Array .from (array, value => valueType (value));

      return Array .from (array);
   },
   flatMap (... args)
   {
      return this .map (...args) .flat ();
   },
   [_fill] (value, start = 0, end = this .length)
   {
      const
         target     = this [X3DTypedArrayField_target],
         length     = target [_length],
         array      = target .getValue (),
         components = target .getComponents ();

      if (-length <= start && start < 0)
         start = start + length;

      if (start < -length)
         start = 0;

      if (start >= length)
         return;

      if (-length <= end && end < 0)
         end = end + length;

      if (end < -length)
         end = 0;

      if (end >= length)
         end = length;

      if (start >= end)
         return;

      if (components === 1)
      {
         const valueType = target .getValueType ();

         array .fill (valueType (value), start * components, end * components);
      }
      else
      {
         // More efficient way to copy repeating sequence into TypedArray?
         // https://stackoverflow.com/questions/46313130/more-efficient-way-to-copy-repeating-sequence-into-typedarray

         const
            i0 = start * components,
            il = end * components;

         for (let i = i0, c = 0; c < components; ++ i, ++ c)
         {
            array [i] = value [c];
         }

         let
            i = i0 + components,
            c = components;

         while (i < il)
         {
            const sl = i + c > il ? il - i : c;

            array .copyWithin (i, i0, i0 + sl);

            i  += c;
            c <<= 1;
         }
      }

      return target [X3DTypedArrayField_proxy];
   },
   fill (value, start = 0, end = this .length)
   {
      const target = this [X3DTypedArrayField_target];

      this [_fill] (value, start, end);

      target .addEvent ();

      return target [X3DTypedArrayField_proxy];
   },
   reverse ()
   {
      const
         target     = this [X3DTypedArrayField_target],
         array      = target .getValue (),
         components = target .getComponents (),
         length     = target [_length] * components,
         length1_2  = Math .floor (target [_length] / 2) * components;

      if (components === 1)
      {
         for (let i = 0; i < length1_2; ++ i)
         {
            const
               i2 = length - i - 1,
               t  = array [i];

            array [i]  = array [i2];
            array [i2] = t;
         }
      }
      else
      {
         for (let i = 0; i < length1_2; i += components)
         {
            for (let c = 0; c < components; ++ c)
            {
               const
                  i1 = i + c,
                  i2 = length - i - 1 - (components - c - 1),
                  t  = array [i1];

               array [i1] = array [i2];
               array [i2] = t;
            }
         }
      }

      target .addEvent ();

      return target [X3DTypedArrayField_proxy];
   },
   sort (compareFn)
   {
      const
         target     = this [X3DTypedArrayField_target],
         array      = target .getValue (),
         components = target .getComponents (),
         length     = target [_length];

      if (components === 1)
      {
         const valueType = target .getValueType ();

         const cmp = compareFn
            ? (a, b) => compareFn (valueType (a), valueType (b))
            : Algorithm/* default */.A .cmp;

         target .set (array .subarray (0, length) .sort (cmp));
      }
      else
      {
         const result = Array .from (target [X3DTypedArrayField_proxy], value => value .copy ())
            .sort (compareFn ?? ((a, b) =>
         {
            for (let c = 0; c < components; ++ c)
            {
               if (a [c] < b [c])
                  return -1;

               if (b [c] < a [c])
                  return 1;
            }

            return 0;
         }));

         for (let i = 0; i < length; ++ i)
         {
            const value = result [i];

            for (let c = 0, first = i * components; c < components; ++ c, ++ first)
               array [first] = value [c];
         }
      }

      target .addEvent ();

      return target [X3DTypedArrayField_proxy];
   },
   valueOf ()
   {
      return this [X3DTypedArrayField_proxy];
   },
   toStream (generator)
   {
      const
         target     = this [X3DTypedArrayField_target],
         array      = target .getValue (),
         length     = target [_length],
         components = target .getComponents (),
         value      = new (target .getSingleType ()) ();

      value .setUnit (target .getUnit ());

      switch (length)
      {
         case 0:
         {
            generator .string += "[";
            generator .TidySpace ();
            generator .string += "]";
            break;
         }
         case 1:
         {
            if (components === 1)
            {
               value .set (array [0]);
               value .toStream (generator);
            }
            else
            {
               for (let c = 0, first = 0; c < components; ++ c, ++ first)
                  value [c] = array [first];

               value .toStream (generator);
            }

            break;
         }
         default:
         {
            const last = length - 1;

            generator .string += "[";
            generator .ListStart ();
            generator .IncIndent ();

            if (components === 1)
            {
               for (let i = 0; i < last; ++ i)
               {
                  generator .ListIndent ();

                  value .set (array [i * components]);
                  value .toStream (generator);

                  generator .Comma ();
                  generator .ListBreak ();
               }

               generator .ListIndent ();

               value .set (array [last * components]);
               value .toStream (generator);
            }
            else
            {
               for (let i = 0; i < last; ++ i)
               {
                  generator .ListIndent ();

                  for (let c = 0, first = i * components; c < components; ++ c, ++ first)
                     value [c] = array [first];

                  value .toStream (generator);

                  generator .Comma ();
                  generator .ListBreak ();
               }

               generator .ListIndent ();

               for (let c = 0, first = last * components; c < components; ++ c, ++ first)
                  value [c] = array [first];

               value .toStream (generator);
            }

            generator .ListEnd ();
            generator .DecIndent ();
            generator .ListIndent ();
            generator .string += "]";
            break;
         }
      }
   },
   toVRMLStream (generator)
   {
      this .toStream (generator);
   },
   toXMLStream (generator)
   {
      const
         target = this [X3DTypedArrayField_target],
         length = target [_length];

      if (length)
      {
         const
            array      = target .getValue (),
            components = target .getComponents (),
            value      = new (target .getSingleType ()) (),
            last       = length - 1;

         value .setUnit (target .getUnit ());

         if (components === 1)
         {
            for (let i = 0; i < last; ++ i)
            {
               value .set (array [i * components]);
               value .toXMLStream (generator);

               generator .Comma ();
               generator .TidySpace ();
            }

            value .set (array [last * components]);
            value .toXMLStream (generator);
         }
         else
         {
            for (let i = 0; i < last; ++ i)
            {
               for (let c = 0, first = i * components; c < components; ++ c, ++ first)
                  value [c] = array [first];

               value .toXMLStream (generator);

               generator .Comma ();
               generator .TidySpace ();
            }

            for (let c = 0, first = last * components; c < components; ++ c, ++ first)
               value [c] = array [first];

            value .toXMLStream (generator);
         }
      }
   },
   toJSONStream (generator)
   {
      const
         target = this [X3DTypedArrayField_target],
         length = target .length;

      if (length)
      {
         const
            array      = target .getValue (),
            components = target .getComponents (),
            value      = new (target .getSingleType ()) (),
            last       = length - 1;

         value .setUnit (target .getUnit ());

         generator .string += '[';
         generator .ListBreak ();
         generator .IncIndent ();

         if (components === 1)
         {
            for (let i = 0; i < last; ++ i)
            {
               generator .ListIndent ();

               value .set (array [i * components]);
               value .toJSONStreamValue (generator);

               generator .string += ',';
               generator .ListBreak ();
            }

            generator .ListIndent ();

            value .set (array [last * components]);
            value .toJSONStreamValue (generator);
         }
         else
         {
            for (let i = 0; i < last; ++ i)
            {
               generator .ListIndent ();

               for (let c = 0, first = i * components; c < components; ++ c, ++ first)
                  value [c] = array [first];

               value .toJSONStreamValue (generator);

               generator .string += ',';
               generator .ListBreak ();
            }

            generator .ListIndent ();

            for (let c = 0, first = last * components; c < components; ++ c, ++ first)
               value [c] = array [first];

            value .toJSONStreamValue (generator);
         }

         generator .ListBreak ();
         generator .DecIndent ();
         generator .ListIndent ();
         generator .string += ']';
      }
      else
      {
         generator .string += '[';
         generator .TidySpace ();
         generator .string += ']';
      }
   },
   dispose ()
   {
      X3DArrayField/* default */.A .prototype .dispose .call (this [X3DTypedArrayField_target]);
   },
});

for (const key of Object .keys (X3DTypedArrayField .prototype))
   Object .defineProperty (X3DTypedArrayField .prototype, key, { enumerable: false });

Object .defineProperty (X3DTypedArrayField .prototype, "length",
{
   get () { return this [_length]; },
   set (value)
   {
      const target = this [X3DTypedArrayField_target];

      target .resize (value, target .getSingleValue ());
   },
});

// Getter/Setter functions to reference a value for a given index.

function createValue (target, index, components, valueType)
{
   const
      value         = new valueType (),
      internalValue = value .getValue (),
      i             = index * components;

   Object .defineProperties (value,
   {
      addEvent:
      {
         value: addEvent .bind (target, i, components, internalValue),
         configurable: true,
      },
      getValue:
      {
         value: getValue .bind (target, i, components, internalValue),
         configurable: true,
      },
   });

   return value;
}

function getValue (index, components, internalValue)
{
   const array = this .getValue ();

   for (let c = 0; c < components; ++ c, ++ index)
      internalValue [c] = array [index];

   return internalValue;
}

function addEvent (index, components, internalValue)
{
   const array = this .getValue ();

   for (let c = 0; c < components; ++ c, ++ index)
      array [index] = internalValue [c];

   this .addEvent ();
}

const X3DTypedArrayField_default_ = X3DTypedArrayField;
;

/* harmony default export */ const Base_X3DTypedArrayField = (Namespace/* default */.A .add ("X3DTypedArrayField", X3DTypedArrayField_default_));
;// ./src/x_ite/Fields/ArrayFields.js



















const
   { SFBool, SFDouble, SFFloat, SFInt32, SFString, SFTime } = Fields_SFScalar,
   { SFMatrix3d: ArrayFields_SFMatrix3d, SFMatrix3f: ArrayFields_SFMatrix3f } = Fields_SFMatrix3,
   { SFMatrix4d, SFMatrix4f } = Fields_SFMatrix4,
   { SFVec2d, SFVec2f }       = Fields_SFVec2,
   { SFVec3d: ArrayFields_SFVec3d, SFVec3f: ArrayFields_SFVec3f }       = Fields_SFVec3,
   { SFVec4d, SFVec4f }       = Fields_SFVec4;

/*
 *  MFNode
 */

function MFNode (... args)
{
   return Base_X3DObjectArrayField .call (this, args);
}

Object .assign (Object .setPrototypeOf (MFNode .prototype, Base_X3DObjectArrayField .prototype),
{
   getSingleType ()
   {
      return SFNode/* default */.A;
   },
   copy (instance)
   {
      if (instance)
      {
         const copy = new MFNode ();

         for (const node of this .getValue ())
            copy .push (node .copy (instance));

         return copy;
      }
      else
      {
         return Base_X3DObjectArrayField .prototype .copy .call (this);
      }
   },
   toStream (generator)
   {
      const
         target = this .getTarget (),
         array  = target .getValue (),
         length = array .length;

      switch (length)
      {
         case 0:
         {
            generator .string += "[";
            generator .TidySpace ();
            generator .string += "]";
            break;
         }
         case 1:
         {
            array [0] .toStream (generator);
            break;
         }
         default:
         {
            generator .string += "[";
            generator .TidyBreak ();
            generator .IncIndent ();

            for (let i = 0; i < length; ++ i)
            {
               generator .Indent ();
               array [i] .toStream (generator);
               generator .TidyBreak ();
            }

            generator .DecIndent ();
            generator .Indent ();
            generator .string += "]";
            break;
         }
      }
   },
   toVRMLStream (generator)
   {
      const
         target = this .getTarget (),
         array  = target .getValue (),
         length = array .length;

      switch (length)
      {
         case 0:
         {
            generator .string += "[";
            generator .TidySpace ();
            generator .string += "]";
            break;
         }
         case 1:
         {
            array [0] .toVRMLStream (generator);
            break;
         }
         default:
         {
            generator .string += "[";
            generator .TidyBreak ();
            generator .IncIndent ();

            for (const element of array)
            {
               generator .Indent ();
               element .toVRMLStream (generator);
               generator .TidyBreak ();
            }

            generator .DecIndent ();
            generator .Indent ();
            generator .string += "]";
            break;
         }
      }
   },
   toXMLStream (generator)
   {
      const
         target = this .getTarget (),
         length = target .length;

      if (length)
      {
         const
            array = target .getValue (),
            last  = length - 1;

         for (let i = 0; i < last; ++ i)
         {
            const node = array [i] .getValue ();

            if (node)
            {
               node .toXMLStream (generator);
            }
            else
            {
               generator .openTag ("NULL");
               generator .containerField ();
               generator .closeTag ("NULL");
            }

            generator .TidyBreak ();
         }

         const node = array .at (-1) .getValue ();

         if (node)
         {
            node .toXMLStream (generator);
         }
         else
         {
            generator .openTag ("NULL");
            generator .containerField ();
            generator .closeTag ("NULL");
         }
      }
   },
   toJSONStream (generator)
   {
      const
         target = this .getTarget (),
         length = target .length;

      if (length)
      {
         const
            array = target .getValue (),
            last  = length - 1;

         generator .string += '[';
         generator .TidyBreak ();
         generator .IncIndent ();

         for (let i = 0; i < last; ++ i)
         {
            generator .Indent ();

            if (array [i])
               array [i] .toJSONStreamValue (generator);
            else
               generator .string += 'null';

            generator .string += ',';
            generator .TidyBreak ();
         }

         generator .Indent ();

         if (array .at (-1))
            array .at (-1) .toJSONStreamValue (generator);
         else
            generator .string += 'null';

         generator .TidyBreak ();
         generator .DecIndent ();
         generator .Indent ();
         generator .string += ']';
      }
      else
      {
         generator .string += '[';
         generator .TidySpace ();
         generator .string += ']';
      }
   },
   dispose ()
   {
      const target = this .getTarget ();

      target .resize (0, undefined, true);
      target .processInterests ();

      Base_X3DObjectArrayField .prototype .dispose .call (target);
   },
});

for (const key of Object .keys (MFNode .prototype))
   Object .defineProperty (MFNode .prototype, key, { enumerable: false });

Object .defineProperties (MFNode,
{
   type:
   {
      value: X3DConstants/* default */.A .MFNode,
      enumerable: true,
   },
   typeName:
   {
      value: "MFNode",
      enumerable: true,
   },
});

function MFString (... args)
{
   return Base_X3DObjectArrayField .call (this, args);
}

Object .assign (Object .setPrototypeOf (MFString .prototype, Base_X3DObjectArrayField .prototype),
{
   getSingleType ()
   {
      return SFString;
   },
   toXMLStream (generator, sourceText = false)
   {
      const
         target = this .getTarget (),
         length = target .length;

      if (length)
      {
         const value = target .getValue ();

         for (let i = 0, n = length - 1; i < n; ++ i)
         {
            generator .string += "\"";
            value [i] .toXMLStream (generator, sourceText);
            generator .string += "\"";
            generator .Comma ();
            generator .TidySpace ();
         }

         generator .string += "\"";
         value .at (-1) .toXMLStream (generator, sourceText);
         generator .string += "\"";
      }
   },
});

for (const key of Object .keys (MFString .prototype))
   Object .defineProperty (MFString .prototype, key, { enumerable: false });

Object .defineProperties (MFString,
{
   type:
   {
      value: X3DConstants/* default */.A .MFString,
      enumerable: true,
   },
   typeName:
   {
      value: "MFString",
      enumerable: true,
   },
});

/**
 * MFImage
 */

function MFImage (... args)
{
   return Base_X3DObjectArrayField .call (this, args);
}

Object .assign (Object .setPrototypeOf (MFImage .prototype, Base_X3DObjectArrayField .prototype),
{
   getSingleType ()
   {
      return Fields_SFImage;
   },
});

for (const key of Object .keys (MFImage .prototype))
   Object .defineProperty (MFImage .prototype, key, { enumerable: false });

Object .defineProperties (MFImage,
{
   type:
   {
      value: X3DConstants/* default */.A .MFImage,
      enumerable: true,
   },
   typeName:
   {
      value: "MFImage",
      enumerable: true,
   },
});

function TypedArrayTemplate (TypeName, SingleType, ValueType, ArrayType, Components, singleValue)
{
   function ArrayField (... args)
   {
      return Base_X3DTypedArrayField .call (this, args);
   }

   Object .assign (Object .setPrototypeOf (ArrayField .prototype, Base_X3DTypedArrayField .prototype),
   {
      getSingleValue ()
      {
         return singleValue;
      },
      getSingleType ()
      {
         return SingleType;
      },
      getValueType ()
      {
         return ValueType;
      },
      getArrayType ()
      {
         return ArrayType;
      },
      getComponents ()
      {
         return Components;
      },
   });

   for (const key of Object .keys (ArrayField .prototype))
      Object .defineProperty (ArrayField .prototype, key, { enumerable: false });

   Object .defineProperties (ArrayField,
   {
      type:
      {
         value: X3DConstants/* default */.A [TypeName],
         enumerable: true,
      },
      typeName:
      {
         value: TypeName,
         enumerable: true,
      },
   });

   return ArrayField;
}

const Value = value => value;

const ArrayFields =
{
   MFBool:      TypedArrayTemplate ("MFBool",      SFBool,      Boolean,     Uint8Array,   1),
   MFColor:     TypedArrayTemplate ("MFColor",     Fields_SFColor,     Fields_SFColor,     Float32Array, 3),
   MFColorRGBA: TypedArrayTemplate ("MFColorRGBA", Fields_SFColorRGBA, Fields_SFColorRGBA, Float32Array, 4),
   MFDouble:    TypedArrayTemplate ("MFDouble",    SFDouble,    Value,       Float64Array, 1),
   MFFloat:     TypedArrayTemplate ("MFFloat",     SFFloat,     Value,       Float32Array, 1),
   MFImage:     MFImage,
   MFInt32:     TypedArrayTemplate ("MFInt32",     SFInt32,     Value,       Int32Array,   1),
   MFMatrix3d:  TypedArrayTemplate ("MFMatrix3d",  ArrayFields_SFMatrix3d,  ArrayFields_SFMatrix3d,  Float64Array, 9,  Matrix3/* default */.A .IDENTITY),
   MFMatrix3f:  TypedArrayTemplate ("MFMatrix3f",  ArrayFields_SFMatrix3f,  ArrayFields_SFMatrix3f,  Float32Array, 9,  Matrix3/* default */.A .IDENTITY),
   MFMatrix4d:  TypedArrayTemplate ("MFMatrix4d",  SFMatrix4d,  SFMatrix4d,  Float64Array, 16, Matrix4/* default */.A .IDENTITY),
   MFMatrix4f:  TypedArrayTemplate ("MFMatrix4f",  SFMatrix4f,  SFMatrix4f,  Float32Array, 16, Matrix4/* default */.A .IDENTITY),
   MFNode:      MFNode,
   MFRotation:  TypedArrayTemplate ("MFRotation",  Fields_SFRotation,  Fields_SFRotation,  Float64Array, 4,  Rotation4/* default */.A .IDENTITY),
   MFString:    MFString,
   MFTime:      TypedArrayTemplate ("MFTime",      SFTime,      Value,       Float64Array, 1,  -1),
   MFVec2d:     TypedArrayTemplate ("MFVec2d",     SFVec2d,     SFVec2d,     Float64Array, 2),
   MFVec2f:     TypedArrayTemplate ("MFVec2f",     SFVec2f,     SFVec2f,     Float32Array, 2),
   MFVec3d:     TypedArrayTemplate ("MFVec3d",     ArrayFields_SFVec3d,     ArrayFields_SFVec3d,     Float64Array, 3),
   MFVec3f:     TypedArrayTemplate ("MFVec3f",     ArrayFields_SFVec3f,     ArrayFields_SFVec3f,     Float32Array, 3),
   MFVec4d:     TypedArrayTemplate ("MFVec4d",     SFVec4d,     SFVec4d,     Float64Array, 4,  Vector4/* default */.A .W_AXIS),
   MFVec4f:     TypedArrayTemplate ("MFVec4f",     SFVec4f,     SFVec4f,     Float32Array, 4,  Vector4/* default */.A .W_AXIS),
};

const ArrayFields_default_ = ArrayFields;
;

/* harmony default export */ const Fields_ArrayFields = (Namespace/* default */.A .add ("ArrayFields", ArrayFields_default_));
;// ./src/x_ite/Fields/SFImage.js





const MFInt32 = Fields_ArrayFields .MFInt32;

/*
 *  Image
 */

function Image (width, height, comp, array)
{
   this .width  = Math .max (width|0, 0);
   this .height = Math .max (height|0, 0);
   this .comp   = Algorithm/* default */.A .clamp (comp|0, 0, 4);
   this .array  = new MFInt32 ();
   this .array .setValue (array);
   this .array .length = this .width * this .height;
}

Object .assign (Image .prototype,
{
   copy ()
   {
      return new Image (this .width, this .height, this .comp, this .array);
   },
   equals (image)
   {
      return this .width  === image .width &&
             this .height === image .height &&
             this .comp   === image .comp &&
             this .array .equals (image .array);
   },
   assign (image)
   {
      this .width  = image .width;
      this .height = image .height;
      this .comp   = image .comp;
      this .array .assign (image .array);
   },
   set (width, height, comp, array)
   {
      this .width  = width|0;
      this .height = height|0;
      this .comp   = comp|0;
      this .array .assign (array);
   },
   setWidth (value)
   {
      this .width = Math .max (value|0, 0);
      this .array .length = this .width * this .height;
   },
   getWidth ()
   {
      return this .width;
   },
   setHeight (value)
   {
      this .height = Math .max (value|0, 0);
      this .array .length = this .width * this .height;
   },
   getHeight ()
   {
      return this .height;
   },
   setComp (value)
   {
      this .comp = Algorithm/* default */.A .clamp (value|0, 0, 4);
   },
   getComp ()
   {
      return this .comp;
   },
   setArray (value)
   {
      this .array .setValue (value);
      this .array .length = this .width * this .height;
   },
   getArray ()
   {
      return this .array;
   },
});

/*
 *  SFImage
 */

const _set_size = Symbol ();

function SFImage (width, height, comp, array)
{
   switch (arguments .length)
   {
      case 0:
         X3DField/* default */.A .call (this, new Image (0, 0, 0, new MFInt32 ()));
         break;

      case 1:
         X3DField/* default */.A .call (this, arguments [0]);
         break;

      case 3:
         X3DField/* default */.A .call (this, new Image (width, height, comp, new MFInt32 ()));
         break;

      case 4:
         X3DField/* default */.A .call (this, new Image (width, height, comp, array));
         break;

      default:
         throw new Error ("Invalid arguments.");
   }

   this .getValue () .getArray () .addParent (this);
   this .addInterest (_set_size, this);
}

Object .assign (Object .setPrototypeOf (SFImage .prototype, X3DField/* default */.A .prototype),
{
   [_set_size] ()
   {
      this .getValue () .getArray () .length = this .width * this .height;
   },
   *[Symbol .iterator] ()
   {
      yield  this .width;
      yield  this .height;
      yield  this .comp;
      yield* this .array;
   },
   copy ()
   {
      return new SFImage (this .getValue () .copy ());
   },
   equals (image)
   {
      return this .getValue () .equals (image .getValue ());
   },
   isDefaultValue ()
   {
      return (
         this .width  === 0 &&
         this .height === 0 &&
         this .comp   === 0);
   },
   set (image)
   {
      this .getValue () .assign (image);
   },
   toStream (generator)
   {
      const
         width  = this .width,
         height = this .height,
         array  = new Uint32Array (this .array .getValue () .buffer);

      generator .string += width;
      generator .Space ();
      generator .string += height;
      generator .Space ();
      generator .string += this .comp;
      generator .AttribBreak ();

      generator .IncIndent ();

      for (let y = 0; y < height; ++ y)
      {
         generator .ListIndent ();

         const s = y * width;

         for (let x = 0; x < width; ++ x)
         {
            generator .string += "0x";
            generator .string += array [x + s] .toString (16);

            if (x !== width - 1)
               generator .Space ();
         }

         if (y !== height - 1)
            generator .AttribBreak ();
      }

      generator .DecIndent ();
   },
   toVRMLStream (generator)
   {
      this .toStream (generator);
   },
   toXMLStream (generator)
   {
      this .toStream (generator);
   },
   toJSONStream (generator)
   {
      generator .string += '[';
      generator .ListBreak ();
      generator .IncIndent ();
      generator .ListIndent ();

      this .toJSONStreamValue (generator);

      generator .DecIndent ();
      generator .ListBreak ();
      generator .ListIndent ();
      generator .string += ']';
   },
   toJSONStreamValue (generator)
   {
      const
         width  = this .width,
         height = this .height,
         array  = new Uint32Array (this .array .getValue () .buffer),
         length = this .array .length;

      generator .string += width;
      generator .string += ',';
      generator .TidySpace ();
      generator .string += height;
      generator .string += ',';
      generator .TidySpace ();
      generator .string += this .comp;
      generator .string += ',';

      if (width && height)
      {
         generator .ListBreak ();
         generator .IncIndent ();

         for (let y = 0; y < height; ++ y)
         {
            generator .ListIndent ();

            const s = y * width;

            for (let x = 0; x < width; ++ x)
            {
               generator .string += array [x + s];

               if (x + s !== length - 1)
                  generator .string += ',';

               if (x !== width - 1)
                  generator .TidySpace ();
            }

            if (y !== height - 1)
               generator .ListBreak ();
         }

         generator .DecIndent ();
      }
   },
});

for (const key of Object .keys (SFImage .prototype))
   Object .defineProperty (SFImage .prototype, key, { enumerable: false });

const width = {
   get ()
   {
      return this .getValue () .getWidth ();
   },
   set (value)
   {
      this .getValue () .setWidth (value);
      this .addEvent ();
   },
};

const height = {
   get ()
   {
      return this .getValue () .getHeight ();
   },
   set (value)
   {
      this .getValue () .setHeight (value);
      this .addEvent ();
   },
};

const comp = {
   get ()
   {
      return this .getValue () .getComp ();
   },
   set (value)
   {
      this .getValue () .setComp (value);
      this .addEvent ();
   },
};

const array = {
   get ()
   {
      return this .getValue () .getArray ();
   },
   set (value)
   {
      this .getValue () .setArray (value);
      this .addEvent ();
   },
};

Object .defineProperties (SFImage .prototype,
{
   x: width,
   y: height,
   width:  Object .assign ({ enumerable: true }, width),
   height: Object .assign ({ enumerable: true }, height),
   comp:   Object .assign ({ enumerable: true }, comp),
   array:  Object .assign ({ enumerable: true }, array),
});

Object .defineProperties (SFImage,
{
   type:
   {
      value: X3DConstants/* default */.A .SFImage,
      enumerable: true,
   },
   typeName:
   {
      value: "SFImage",
      enumerable: true,
   },
});

const SFImage_default_ = SFImage;
;

/* harmony default export */ const Fields_SFImage = (Namespace/* default */.A .add ("SFImage", SFImage_default_));
;// ./src/x_ite/Fields.js













const Fields = {
   SFColor:     Fields_SFColor,
   SFColorRGBA: Fields_SFColorRGBA,
   SFImage:     Fields_SFImage,
   SFNode:      SFNode/* default */.A,
   SFRotation:  Fields_SFRotation,
   ... Fields_SFScalar,
   ... Fields_SFMatrix3,
   ... Fields_SFMatrix4,
   ... Fields_SFVec2,
   ... Fields_SFVec3,
   ... Fields_SFVec4,
   ... Fields_ArrayFields,
};

const Fields_default_ = Fields;
;

/* harmony default export */ const x_ite_Fields = (Namespace/* default */.A .add ("Fields", Fields_default_));

/***/ }),

/***/ 567:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Algorithm_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(4559);
/* harmony import */ var _x_ite_Namespace_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(6707);


const { interval, degrees } = _Algorithm_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A;

const
   _r = Symbol .for ("X_ITE.Color3.r"),
   _g = Symbol .for ("X_ITE.Color3.g"),
   _b = Symbol .for ("X_ITE.Color3.b");

// glTF sometimes allows color values greater than 1.
// See: https://github.com/KhronosGroup/glTF/blob/main/extensions/2.0/Khronos/KHR_materials_specular/README.md
// See: https://raw.githubusercontent.com/KhronosGroup/glTF-Sample-Assets/master/Models/SpecularTest/glTF/SpecularTest.gltf

function Color3 (r = 0, g = r, b = g)
{
   this [_r] = r;
   this [_g] = g;
   this [_b] = b;
}

Object .assign (Color3 .prototype,
{
   *[Symbol .iterator] ()
   {
      yield this [_r];
      yield this [_g];
      yield this [_b];
   },
   copy ()
   {
      const copy = Object .create (Color3 .prototype);
      copy [_r] = this [_r];
      copy [_g] = this [_g];
      copy [_b] = this [_b];
      return copy;
   },
   assign (color)
   {
      this [_r] = color [_r];
      this [_g] = color [_g];
      this [_b] = color [_b];
      return this;
   },
   set (r = 0, g = r, b = g)
   {
      this [_r] = r;
      this [_g] = g;
      this [_b] = b;
      return this;
   },
   equals (color)
   {
      return this [_r] === color [_r] &&
             this [_g] === color [_g] &&
             this [_b] === color [_b];
   },
   getHSV (result = [ ])
   {
      let h, s, v;

      const
         r = this [_r],
         g = this [_g],
         b = this [_b];

      const
         min = Math .min (r, g, b),
         max = Math .max (r, g, b);

      v = max; // value

      const delta = max - min;

      if (max !== 0 && delta !== 0)
      {
         s = delta / max; // s

         if (r === max)
            h =     (g - b) / delta;  // between yellow & magenta
         else if (g === max)
            h = 2 + (b - r) / delta;  // between cyan & yellow
         else
            h = 4 + (r - g) / delta;  // between magenta & cyan

         h *= Math .PI / 3;  // radiants

         if (h < 0)
            h += Math .PI * 2;
      }
      else
      {
         s = h = 0; // s = 0, h is undefined
      }

      result [0] = h;
      result [1] = s;
      result [2] = v;

      return result;
   },
   setHSV (h, s, v)
   {
      s = Math .max (s, 0),
      v = Math .max (v, 0);

      // H is given on [0, 2 * Pi]. S and V are given on [0, 1].
      // RGB are each returned on [0, 1].

      if (s === 0)
      {
         // achromatic (grey)
         this [_r] = this [_g] = this [_b] = v;
      }
      else
      {
         const w = degrees (interval (h, 0, Math .PI * 2)) / 60;     // sector 0 to 5

         const i = Math .floor (w);
         const f = w - i;                      // factorial part of h
         const p = v * ( 1 - s );
         const q = v * ( 1 - s * f );
         const t = v * ( 1 - s * ( 1 - f ) );

         switch (i % 6)
         {
            case 0:  this [_r] = v; this [_g] = t; this [_b] = p; break;
            case 1:  this [_r] = q; this [_g] = v; this [_b] = p; break;
            case 2:  this [_r] = p; this [_g] = v; this [_b] = t; break;
            case 3:  this [_r] = p; this [_g] = q; this [_b] = v; break;
            case 4:  this [_r] = t; this [_g] = p; this [_b] = v; break;
            default: this [_r] = v; this [_g] = p; this [_b] = q; break;
         }
      }

      return this;
   },
   linearToSRGB (color = new Color3 ())
   {
      color [_r] = Math .pow (this [_r], 1 / 2.2);
      color [_g] = Math .pow (this [_g], 1 / 2.2);
      color [_b] = Math .pow (this [_b], 1 / 2.2);

      return color;
   },
   sRGBToLinear (color = new Color3 ())
   {
      color [_r] = Math .pow (this [_r], 2.2);
      color [_g] = Math .pow (this [_g], 2.2);
      color [_b] = Math .pow (this [_b], 2.2);

      return color;
   },
   toString ()
   {
      return this [_r] + " " +
             this [_g] + " " +
             this [_b];
   },
});

for (const key of Object .keys (Color3 .prototype))
   Object .defineProperty (Color3 .prototype, key, { enumerable: false });

const r = {
   get () { return this [_r]; },
   set (value) { this [_r] = value; },
};

const g = {
   get () { return this [_g]; },
   set (value) { this [_g] = value; },
};

const b = {
   get () { return this [_b]; },
   set (value) { this [_b] = value; },
};

Object .defineProperties (Color3 .prototype,
{
   length: { value: 3 },
   0: r,
   1: g,
   2: b,
   r: Object .assign ({ enumerable: true }, r),
   g: Object .assign ({ enumerable: true }, g),
   b: Object .assign ({ enumerable: true }, b),
});

Object .assign (Color3,
{
   BLACK: Object .freeze (new Color3 ()),
   WHITE: Object .freeze (new Color3 (1)),
   HSV (h, s, v)
   {
      const color = Object .create (this .prototype);
      color .setHSV (h, s, v);
      return color;
   },
   lerp (a, b, t, r)
   {
      // Linearly interpolate in HSV space between source color @a a and destination color @a b by an amount of @a t.
      // Source and destination color must be in HSV space. The resulting HSV color is stored in @a r.

      let
         [ha, sa, va] = a,
         [hb, sb, vb] = b;

      if (sa === 0)
         ha = hb;

      if (sb === 0)
         hb = ha;

      const range = Math .abs (hb - ha);

      if (range <= Math .PI)
      {
         r [0] = ha + t * (hb - ha);
         r [1] = sa + t * (sb - sa);
         r [2] = va + t * (vb - va);
         return r;
      }

      const
         PI2  = Math .PI * 2,
         step = (PI2 - range) * t;

      let h = ha < hb ? ha - step : ha + step;

      if (h < 0)
         h += PI2;

      else if (h > PI2)
         h -= PI2;

      r [0] = h;
      r [1] = sa + t * (sb - sa);
      r [2] = va + t * (vb - va);
      return r;
   },
});

const __default__ = Color3;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_x_ite_Namespace_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .add ("Color3", __default__));

/***/ }),

/***/ 635:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Fields_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(564);
/* harmony import */ var _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(8311);
/* harmony import */ var _Base_FieldDefinitionArray_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(6973);
/* harmony import */ var _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(8415);
/* harmony import */ var _Core_X3DBindableNode_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(9108);
/* harmony import */ var _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(8899);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(6707);







function NavigationInfo (executionContext)
{
   _Core_X3DBindableNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .call (this, executionContext);

   this .addType (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .NavigationInfo);

   this .addChildObjects (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .outputOnly, "transitionStart",  new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFBool (),
                          _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .outputOnly, "transitionActive", new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFBool (),
                          _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .outputOnly, "availableViewers", new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFString (),
                          _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .outputOnly, "viewer",           new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFString ());

   // Units

   this ._avatarSize      .setUnit ("length");
   this ._speed           .setUnit ("speed");
   this ._visibilityLimit .setUnit ("length");

   // Legacy

   // Actually the type field had this value, but we never knew this.
   // if (executionContext .getSpecificationVersion () == 2.0)
   //    this ._type = ["WALK", "ANY"]; // VRML2
}

Object .assign (Object .setPrototypeOf (NavigationInfo .prototype, _Core_X3DBindableNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .prototype),
{
   initialize ()
   {
      _Core_X3DBindableNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .prototype .initialize .call (this);

      this ._type               .addInterest ("set_type__",               this);
      this ._headlight          .addInterest ("set_headlight__",          this);
      this ._visibilityLimit    .addInterest ("set_visibilityLimit__",    this);
      this ._transitionStart    .addInterest ("set_transitionStart__",    this);
      this ._transitionComplete .addInterest ("set_transitionComplete__", this);
      this ._isBound            .addInterest ("set_isBound__",            this);

      this .set_type__ ();
      this .set_headlight__ ();
      this .set_visibilityLimit__ ();
   },
   getViewer ()
   {
      return this ._viewer .getValue ();
   },
   getCollisionRadius ()
   {
      if (this ._avatarSize .length > 0)
      {
         if (this ._avatarSize [0] > 0)
            return this ._avatarSize [0];
      }

      return 0.25;
   },
   getAvatarHeight ()
   {
      if (this ._avatarSize .length > 1)
         return this ._avatarSize [1];

      return 1.6;
   },
   getStepHeight ()
   {
      if (this ._avatarSize .length > 2)
         return this ._avatarSize [2];

      return 0.75;
   },
   getNearValue ()
   {
      const nearValue = this .getCollisionRadius ();

      return nearValue === 0 ? 1e-5 : nearValue / 2;
   },
   getFarValue ()
   {
      return this .visibilityLimit;
   },
   getTransitionType: (() =>
   {
      const TransitionTypes = new Set ([
         "TELEPORT",
         "LINEAR",
         "ANIMATE",
      ]);

      return function ()
      {
         for (const value of this ._transitionType)
         {
            if (TransitionTypes .has (value))
               return value;
         }

         return "LINEAR";
      };
   })(),
   set_type__ ()
   {
      // Determine active viewer.

      this ._viewer = "EXAMINE";

      for (const string of this ._type)
      {
         switch (string)
         {
            case "EXAMINE":
            case "WALK":
            case "FLY":
            case "LOOKAT":
            case "PLANE":
            case "NONE":
               this ._viewer = string;
               break;
            case "PLANE_create3000.github.io":
            case "PLANE_create3000.de":
               this ._viewer = "PLANE";
               break;
            default:
               continue;
         }

         // Leave for loop.
         break;
      }

      // Determine available viewers.

      let
         examineViewer = false,
         walkViewer    = false,
         flyViewer     = false,
         planeViewer   = false,
         noneViewer    = false,
         lookAt        = false;

      if (!this ._type .length)
      {
         examineViewer = true;
         walkViewer    = true;
         flyViewer     = true;
         planeViewer   = true;
         noneViewer    = true;
         lookAt        = true;
      }
      else
      {
         for (const string of this ._type)
         {
            switch (string)
            {
               case "EXAMINE":
                  examineViewer = true;
                  continue;
               case "WALK":
                  walkViewer = true;
                  continue;
               case "FLY":
                  flyViewer = true;
                  continue;
               case "LOOKAT":
                  lookAt = true;
                  continue;
               case "PLANE":
               case "PLANE_create3000.github.io":
               case "PLANE_create3000.de":
                  planeViewer = true;
                  continue;
               case "NONE":
                  noneViewer = true;
                  continue;
               case "ANY":
                  examineViewer = true;
                  walkViewer    = true;
                  flyViewer     = true;
                  planeViewer   = true;
                  noneViewer    = true;
                  lookAt        = true;
                  break;
               default:
                  // Any string leads to:
                  examineViewer = true;
                  continue;
            }

            break;
         }
      }

      this ._availableViewers .length = 0;

      if (examineViewer)
         this ._availableViewers .push ("EXAMINE");

      if (walkViewer)
         this ._availableViewers .push ("WALK");

      if (flyViewer)
         this ._availableViewers .push ("FLY");

      if (planeViewer)
         this ._availableViewers .push ("PLANE");

      if (lookAt)
         this ._availableViewers .push ("LOOKAT");

      if (noneViewer)
         this ._availableViewers .push ("NONE");
   },
   set_headlight__ ()
   {
      if (this ._headlight .getValue ())
         delete this .enable;
      else
         this .enable = Function .prototype;
   },
   set_visibilityLimit__ ()
   {
      this .visibilityLimit = Math .max (this ._visibilityLimit .getValue (), 0);
   },
   set_transitionStart__ ()
   {
      if (!this ._transitionActive .getValue ())
         this ._transitionActive = true;
   },
   set_transitionComplete__ ()
   {
      if (this ._transitionActive .getValue ())
         this ._transitionActive = false;
   },
   set_isBound__ ()
   {
      if (this ._isBound .getValue ())
         return;

      if (this ._transitionActive .getValue ())
         this ._transitionActive = false;
   },
   enable (type, renderObject)
   {
      if (!this ._headlight .getValue ())
         return;

      const headlight = this .getBrowser () .getHeadlight ();

      renderObject .getGlobalLights ()     .push (headlight);
      renderObject .getGlobalLightsKeys () .push (headlight .lightNode .getLightKey ());
   },
   traverse (type, renderObject)
   {
      renderObject .getLayer () .getNavigationInfos () .push (this);
   }
});

Object .defineProperties (NavigationInfo,
{
   ... _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .getStaticProperties ("NavigationInfo", "Navigation", 1, "children", "2.0"),
   fieldDefinitions:
   {
      value: new _Base_FieldDefinitionArray_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A ([
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .inputOutput, "metadata",           new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFNode ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .inputOnly,   "set_bind",           new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFBool ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .inputOutput, "type",               new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFString ("EXAMINE", "ANY")),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .inputOutput, "avatarSize",         new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFFloat (0.25, 1.6, 0.75)),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .inputOutput, "speed",              new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFFloat (1)),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .inputOutput, "headlight",          new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFBool (true)),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .inputOutput, "visibilityLimit",    new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFFloat ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .inputOutput, "transitionType",     new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFString ("LINEAR")),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .inputOutput, "transitionTime",     new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFTime (1)),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .outputOnly,  "transitionComplete", new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFBool ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .outputOnly,  "isBound",            new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFBool ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .outputOnly,  "bindTime",           new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFTime ()),
      ]),
      enumerable: true,
   },
});

const __default__ = NavigationInfo;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .add ("NavigationInfo", __default__));

/***/ }),

/***/ 661:
/***/ ((module, exports, __webpack_require__) => {

var __WEBPACK_AMD_DEFINE_FACTORY__, __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;/*!
 * jQuery Mousewheel 3.2.2
 * Copyright OpenJS Foundation and other contributors
 */

( function( factory ) {
    "use strict";

    if ( true ) {

        // AMD. Register as an anonymous module.
        !(__WEBPACK_AMD_DEFINE_ARRAY__ = [ __webpack_require__(7682) ], __WEBPACK_AMD_DEFINE_FACTORY__ = (factory),
		__WEBPACK_AMD_DEFINE_RESULT__ = (typeof __WEBPACK_AMD_DEFINE_FACTORY__ === 'function' ?
		(__WEBPACK_AMD_DEFINE_FACTORY__.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__)) : __WEBPACK_AMD_DEFINE_FACTORY__),
		__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
    } else // removed by dead control flow
{}
} )( function( $ ) {
    "use strict";

    var nullLowestDeltaTimeout, lowestDelta,
        modernEvents = !!$.fn.on,
        toFix  = [ "wheel", "mousewheel", "DOMMouseScroll", "MozMousePixelScroll" ],
        toBind = ( "onwheel" in window.document || window.document.documentMode >= 9 ) ?
            [ "wheel" ] : [ "mousewheel", "DomMouseScroll", "MozMousePixelScroll" ],
        slice  = Array.prototype.slice;

    if ( $.event.fixHooks ) {
        for ( var i = toFix.length; i; ) {
            $.event.fixHooks[ toFix[ --i ] ] = $.event.mouseHooks;
        }
    }

    var special = $.event.special.mousewheel = {
        version: "3.2.2",

        setup: function() {
            if ( this.addEventListener ) {
                for ( var i = toBind.length; i; ) {
                    this.addEventListener( toBind[ --i ], handler, false );
                }
            } else {
                this.onmousewheel = handler;
            }

            // Store the line height and page height for this particular element
            $.data( this, "mousewheel-line-height", special.getLineHeight( this ) );
            $.data( this, "mousewheel-page-height", special.getPageHeight( this ) );
        },

        teardown: function() {
            if ( this.removeEventListener ) {
                for ( var i = toBind.length; i; ) {
                    this.removeEventListener( toBind[ --i ], handler, false );
                }
            } else {
                this.onmousewheel = null;
            }

            // Clean up the data we added to the element
            $.removeData( this, "mousewheel-line-height" );
            $.removeData( this, "mousewheel-page-height" );
        },

        getLineHeight: function( elem ) {
            var $elem = $( elem ),
                $parent = $elem[ "offsetParent" in $.fn ? "offsetParent" : "parent" ]();
            if ( !$parent.length ) {
                $parent = $( "body" );
            }
            return parseInt( $parent.css( "fontSize" ), 10 ) ||
                parseInt( $elem.css( "fontSize" ), 10 ) || 16;
        },

        getPageHeight: function( elem ) {
            return $( elem ).height();
        },

        settings: {
            adjustOldDeltas: true, // see shouldAdjustOldDeltas() below
            normalizeOffset: true  // calls getBoundingClientRect for each event
        }
    };

    $.fn.extend( {
        mousewheel: function( fn ) {
            return fn ?
                this[ modernEvents ? "on" : "bind" ]( "mousewheel", fn ) :
                this.trigger( "mousewheel" );
        },

        unmousewheel: function( fn ) {
            return this[ modernEvents ? "off" : "unbind" ]( "mousewheel", fn );
        }
    } );


    function handler( event ) {
        var orgEvent   = event || window.event,
            args       = slice.call( arguments, 1 ),
            delta      = 0,
            deltaX     = 0,
            deltaY     = 0,
            absDelta   = 0;
        event = $.event.fix( orgEvent );
        event.type = "mousewheel";

        // Old school scrollwheel delta
        if ( "detail" in orgEvent ) {
            deltaY = orgEvent.detail * -1;
        }
        if ( "wheelDelta" in orgEvent ) {
            deltaY = orgEvent.wheelDelta;
        }
        if ( "wheelDeltaY" in orgEvent ) {
            deltaY = orgEvent.wheelDeltaY;
        }
        if ( "wheelDeltaX" in orgEvent ) {
            deltaX = orgEvent.wheelDeltaX * -1;
        }

        // Firefox < 17 horizontal scrolling related to DOMMouseScroll event
        if ( "axis" in orgEvent && orgEvent.axis === orgEvent.HORIZONTAL_AXIS ) {
            deltaX = deltaY * -1;
            deltaY = 0;
        }

        // Set delta to be deltaY or deltaX if deltaY is 0 for backwards compatability
        delta = deltaY === 0 ? deltaX : deltaY;

        // New school wheel delta (wheel event)
        if ( "deltaY" in orgEvent ) {
            deltaY = orgEvent.deltaY * -1;
            delta  = deltaY;
        }
        if ( "deltaX" in orgEvent ) {
            deltaX = orgEvent.deltaX;
            if ( deltaY === 0 ) {
                delta  = deltaX * -1;
            }
        }

        // No change actually happened, no reason to go any further
        if ( deltaY === 0 && deltaX === 0 ) {
            return;
        }

        // Need to convert lines and pages to pixels if we aren't already in pixels
        // There are three delta modes:
        //   * deltaMode 0 is by pixels, nothing to do
        //   * deltaMode 1 is by lines
        //   * deltaMode 2 is by pages
        if ( orgEvent.deltaMode === 1 ) {
            var lineHeight = $.data( this, "mousewheel-line-height" );
            delta  *= lineHeight;
            deltaY *= lineHeight;
            deltaX *= lineHeight;
        } else if ( orgEvent.deltaMode === 2 ) {
            var pageHeight = $.data( this, "mousewheel-page-height" );
            delta  *= pageHeight;
            deltaY *= pageHeight;
            deltaX *= pageHeight;
        }

        // Store lowest absolute delta to normalize the delta values
        absDelta = Math.max( Math.abs( deltaY ), Math.abs( deltaX ) );

        if ( !lowestDelta || absDelta < lowestDelta ) {
            lowestDelta = absDelta;

            // Adjust older deltas if necessary
            if ( shouldAdjustOldDeltas( orgEvent, absDelta ) ) {
                lowestDelta /= 40;
            }
        }

        // Adjust older deltas if necessary
        if ( shouldAdjustOldDeltas( orgEvent, absDelta ) ) {

            // Divide all the things by 40!
            delta  /= 40;
            deltaX /= 40;
            deltaY /= 40;
        }

        // Get a whole, normalized value for the deltas
        delta  = Math[ delta  >= 1 ? "floor" : "ceil" ]( delta  / lowestDelta );
        deltaX = Math[ deltaX >= 1 ? "floor" : "ceil" ]( deltaX / lowestDelta );
        deltaY = Math[ deltaY >= 1 ? "floor" : "ceil" ]( deltaY / lowestDelta );

        // Normalise offsetX and offsetY properties
        if ( special.settings.normalizeOffset && this.getBoundingClientRect ) {
            var boundingRect = this.getBoundingClientRect();
            event.offsetX = event.clientX - boundingRect.left;
            event.offsetY = event.clientY - boundingRect.top;
        }

        // Add information to the event object
        event.deltaX = deltaX;
        event.deltaY = deltaY;
        event.deltaFactor = lowestDelta;

        // Go ahead and set deltaMode to 0 since we converted to pixels
        // Although this is a little odd since we overwrite the deltaX/Y
        // properties with normalized deltas.
        event.deltaMode = 0;

        // Add event and delta to the front of the arguments
        args.unshift( event, delta, deltaX, deltaY );

        // Clear out lowestDelta after sometime to better
        // handle multiple device types that give different
        // a different lowestDelta
        // Ex: trackpad = 3 and mouse wheel = 120
        if ( nullLowestDeltaTimeout ) {
            window.clearTimeout( nullLowestDeltaTimeout );
        }
        nullLowestDeltaTimeout = window.setTimeout( function() {
            lowestDelta = null;
        }, 200 );

        return ( $.event.dispatch || $.event.handle ).apply( this, args );
    }

    function shouldAdjustOldDeltas( orgEvent, absDelta ) {

        // If this is an older event and the delta is divisible by 120,
        // then we are assuming that the browser is treating this as an
        // older mouse wheel event and that we should divide the deltas
        // by 40 to try and get a more usable deltaFactor.
        // Side note, this actually impacts the reported scroll distance
        // in older browsers and can cause scrolling to be slower than native.
        // Turn this off by setting $.event.special.mousewheel.settings.adjustOldDeltas to false.
        return special.settings.adjustOldDeltas && orgEvent.type === "mousewheel" &&
            absDelta % 120 === 0;
    }

} );


/***/ }),

/***/ 832:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Fields_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(564);
/* harmony import */ var _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(8415);
/* harmony import */ var _Core_X3DChildNode_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(8193);
/* harmony import */ var _X3DBoundedObject_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(2582);
/* harmony import */ var _Rendering_TraverseType_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(834);
/* harmony import */ var _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(8899);
/* harmony import */ var _Base_X3DCast_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(4667);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(6707);








function X3DGroupingNode (executionContext)
{
   _Core_X3DChildNode_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A     .call (this, executionContext);
   _X3DBoundedObject_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .call (this, executionContext);

   this .addType (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .X3DGroupingNode);

   this .addChildObjects (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .outputOnly, "rebuild", new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFTime ());

   this .setBoundedObject (true);
   this .setPointingObject (true);
   this .setCollisionObject (true);
   this .setShadowObject (true);
   this .setVisibleObject (true);

   // Private properties

   this .allowedTypes              = new Set ();
   this .pointingDeviceSensorNodes = new Set ();
   this .pointingObjects           = new Set ();
   this .clipPlaneNodes            = new Set ();
   this .displayNodes              = new Set ();
   this .cameraObjects             = new Set ();
   this .pickableSensorNodes       = new Set ();
   this .pickableObjects           = new Set ();
   this .collisionObjects          = new Set ();
   this .shadowObjects             = new Set ();
   this .childNodes                = new Set ();
   this .visibleObjects            = new Set ();
   this .boundedObjects            = new Set ();
   this .sensors                   = [ ];
}

Object .assign (Object .setPrototypeOf (X3DGroupingNode .prototype, _Core_X3DChildNode_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .prototype),
   _X3DBoundedObject_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .prototype,
{
   initialize ()
   {
      _Core_X3DChildNode_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A     .prototype .initialize .call (this);
      _X3DBoundedObject_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .prototype .initialize .call (this);

      this ._rebuild          .addInterest ("set_children__",        this);
      this ._transformSensors .addInterest ("set_pickableObjects__", this);

      this ._bboxSize       .addInterest ("set_boundedObjects__", this);
      this ._addChildren    .addInterest ("set_addChildren__",    this);
      this ._removeChildren .addInterest ("set_removeChildren__", this);
      this ._children       .addInterest ("requestRebuild",       this);

      this .set_children__ ();
   },
   addAllowedTypes (... types)
   {
      for (const type of types)
         this .allowedTypes .add (type);
   },
   getBBox (bbox, shadows)
   {
      if (this .isDefaultBBoxSize ())
         return this .getSubBBox (bbox, shadows);

      return bbox .set (this ._bboxSize .getValue (), this ._bboxCenter .getValue ());
   },
   getSubBBox (bbox, shadows)
   {
      return _X3DBoundedObject_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .prototype .getBBox .call (this, this .boundedObjects, bbox, shadows);
   },
   getShapes (shapes, modelMatrix)
   {
      for (const visibleObject of this .visibleObjects)
         visibleObject .getShapes (shapes, modelMatrix);

      return shapes;
   },
   requestRebuild ()
   {
      this ._rebuild .addEvent ();
   },
   set_addChildren__ ()
   {
      if (this ._addChildren .length === 0)
         return;

      this ._addChildren .setTainted (true);

      const addChildren = new Set (this ._addChildren);

      for (const node of this ._children)
         addChildren .delete (node);

      this .addChildren (addChildren);

      if (!this ._children .isTainted ())
      {
         this ._children .removeInterest ("requestRebuild", this);
         this ._children .addInterest ("connectChildren", this);
      }

      for (const child of addChildren)
         this ._children .push (child);

      this ._addChildren .length = 0;
      this ._addChildren .setTainted (false);
   },
   set_removeChildren__ ()
   {
      if (this ._removeChildren .length === 0)
         return;

      this ._removeChildren .setTainted (true);

      if (this ._children .length > 0)
      {
         const removeChildren = new Set (this ._removeChildren);

         this .removeChildren (removeChildren);

         if (!this ._children .isTainted ())
         {
            this ._children .removeInterest ("requestRebuild", this);
            this ._children .addInterest ("connectChildren", this);
         }

         this ._children = this ._children .filter (child => !removeChildren .has (child));
      }

      this ._removeChildren .length = 0;
      this ._removeChildren .setTainted (false);
   },
   set_children__ ()
   {
      this .clearChildren ();
      this .addChildren (this ._children);
   },
   connectChildren ()
   {
      this ._children .removeInterest ("connectChildren", this);
      this ._children .addInterest ("requestRebuild", this);
   },
   clearChildren ()
   {
      for (const childNode of this .childNodes)
      {
         childNode ._isBoundedObject   .removeInterest ("requestRebuild", this);
         childNode ._isPointingObject  .removeInterest ("requestRebuild", this);
         childNode ._isCameraObject    .removeInterest ("requestRebuild", this);
         childNode ._isPickableObject  .removeInterest ("requestRebuild", this);
         childNode ._isCollisionObject .removeInterest ("requestRebuild", this);
         childNode ._isShadowObject    .removeInterest ("requestRebuild", this);
         childNode ._isVisibleObject   .removeInterest ("requestRebuild", this);

         if ((0,_Base_X3DCast_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A) (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .X3DBoundedObject, childNode))
         {
            childNode ._display     .removeInterest ("requestRebuild", this);
            childNode ._bboxDisplay .removeInterest ("requestRebuild", this);
         }
      }

      this .boundedObjects            .clear ();
      this .pointingDeviceSensorNodes .clear ();
      this .pointingObjects           .clear ();
      this .clipPlaneNodes            .clear ();
      this .displayNodes              .clear ();
      this .cameraObjects             .clear ();
      this .pickableSensorNodes       .clear ();
      this .pickableObjects           .clear ();
      this .collisionObjects          .clear ();
      this .shadowObjects             .clear ();
      this .childNodes                .clear ();
      this .visibleObjects            .clear ();
   },
   addChildren (children)
   {
      // Make sure that the order of children is preserved,
      // otherwise flickering of transparent objects may occur.

      for (const child of children)
         this .addChild (child);

      this .set_objects__ ();
   },
   addChild (child)
   {
      const childNode = (0,_Base_X3DCast_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A) (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .X3DChildNode, child);

      if (!childNode)
         return;

      const type = childNode .getType ();

      if (this .allowedTypes .size)
      {
         if (!type .some (Set .prototype .has, this .allowedTypes))
            return;
      }

      for (let t = type .length - 1; t >= 0; -- t)
      {
         switch (type [t])
         {
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .X3DPointingDeviceSensorNode:
            {
               this .pointingDeviceSensorNodes .add (childNode);
               continue;
            }
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .ClipPlane:
            {
               this .clipPlaneNodes .add (childNode);
               this .displayNodes   .add (childNode);
               continue;
            }
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .LocalFog:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .X3DLightNode:
            {
               this .displayNodes .add (childNode);
               continue;
            }
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .TransformSensor:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .X3DPickSensorNode:
            {
               if (childNode .isPickableObject ())
                  this .pickableSensorNodes .add (childNode);

               continue;
            }
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .X3DChildNode:
            {
               childNode ._isBoundedObject   .addInterest ("requestRebuild", this);
               childNode ._isPointingObject  .addInterest ("requestRebuild", this);
               childNode ._isCameraObject    .addInterest ("requestRebuild", this);
               childNode ._isPickableObject  .addInterest ("requestRebuild", this);
               childNode ._isCollisionObject .addInterest ("requestRebuild", this);
               childNode ._isShadowObject    .addInterest ("requestRebuild", this);
               childNode ._isVisibleObject   .addInterest ("requestRebuild", this);

               this .childNodes .add (childNode);

               if (childNode .isVisible ())
               {
                  if (childNode .isBoundedObject ())
                     this .boundedObjects .add (childNode);

                  if (childNode .isPointingObject ())
                     this .pointingObjects .add (childNode);

                  if (childNode .isCameraObject ())
                     this .cameraObjects .add (childNode);

                  if (childNode .isPickableObject () && !this .pickableSensorNodes .has (childNode))
                     this .pickableObjects .add (childNode);

                  if (childNode .isCollisionObject ())
                     this .collisionObjects .add (childNode);

                  if (childNode .isShadowObject ())
                     this .shadowObjects .add (childNode);

                  if (childNode .isVisibleObject ())
                     this .visibleObjects .add (childNode);
               }

               if ((0,_Base_X3DCast_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A) (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .X3DBoundedObject, childNode))
               {
                  childNode ._display     .addInterest ("requestRebuild", this);
                  childNode ._bboxDisplay .addInterest ("requestRebuild", this);

                  if (childNode .isBBoxVisible ())
                     this .visibleObjects .add (childNode .getBBoxNode ());
               }

               break;
            }
            default:
               continue;
         }

         break;
      }
   },
   removeChildren (children)
   {
      for (const child of children)
         this .removeChild (child);

      this .set_objects__ ();
   },
   removeChild (child)
   {
      const childNode = (0,_Base_X3DCast_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A) (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .X3DChildNode, child);

      if (!childNode)
         return;

      const type = childNode .getType ();

      for (let t = type .length - 1; t >= 0; -- t)
      {
         switch (type [t])
         {
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .X3DPointingDeviceSensorNode:
            {
               this .pointingDeviceSensorNodes .delete (childNode);
               continue;
            }
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .ClipPlane:
            {
               this .clipPlaneNodes .delete (childNode);
               this .displayNodes   .delete (childNode);
               continue;
            }
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .LocalFog:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .X3DLightNode:
            {
               this .displayNodes .delete (childNode);
               continue;
            }
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .TransformSensor:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .X3DPickSensorNode:
            {
               this .pickableSensorNodes .delete (childNode);
               continue;
            }
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .X3DChildNode:
            {
               childNode ._isBoundedObject   .removeInterest ("requestRebuild", this);
               childNode ._isPointingObject  .removeInterest ("requestRebuild", this);
               childNode ._isCameraObject    .removeInterest ("requestRebuild", this);
               childNode ._isPickableObject  .removeInterest ("requestRebuild", this);
               childNode ._isCollisionObject .removeInterest ("requestRebuild", this);
               childNode ._isShadowObject    .removeInterest ("requestRebuild", this);
               childNode ._isVisibleObject   .removeInterest ("requestRebuild", this);

               if ((0,_Base_X3DCast_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A) (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .X3DBoundedObject, childNode))
               {
                  childNode ._display     .removeInterest ("requestRebuild", this);
                  childNode ._bboxDisplay .removeInterest ("requestRebuild", this);
               }

               this .boundedObjects   .delete (childNode);
               this .pointingObjects  .delete (childNode);
               this .cameraObjects    .delete (childNode);
               this .pickableObjects  .delete (childNode);
               this .collisionObjects .delete (childNode);
               this .shadowObjects    .delete (childNode);
               this .childNodes       .delete (childNode);
               this .visibleObjects   .delete (childNode);
               break;
            }
            default:
               continue;
         }

         break;
      }
   },
   set_objects__ ()
   {
      this .set_boundedObjects__ ();
      this .set_pointingObjects__ ();
      this .set_cameraObjects__ ();
      this .set_pickableObjects__ ();
      this .set_collisionObjects__ ();
      this .set_shadowObjects__ ();
      this .set_visibleObjects__ ();
   },
   set_boundedObjects__ ()
   {
      this .setBoundedObject (this .boundedObjects .size || !this .isDefaultBBoxSize ());
   },
   set_pointingObjects__ ()
   {
      this .setPointingObject (this .pointingObjects .size);
   },
   set_cameraObjects__ ()
   {
      this .setCameraObject (this .cameraObjects .size);
   },
   set_pickableObjects__ ()
   {
      this .setPickableObject (this .getTransformSensors () .size || this .pickableSensorNodes .size || this .pickableObjects .size);
   },
   set_collisionObjects__ ()
   {
      this .setCollisionObject (this .collisionObjects .size);
   },
   set_shadowObjects__ ()
   {
      this .setShadowObject (this .shadowObjects .size);
   },
   set_visibleObjects__ ()
   {
      this .setVisibleObject (this .visibleObjects .size);
   },
   traverse (type, renderObject)
   {
      switch (type)
      {
         case _Rendering_TraverseType_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .POINTER:
         {
            const { sensors, pointingDeviceSensorNodes, clipPlaneNodes, pointingObjects } = this;

            if (pointingDeviceSensorNodes .size)
            {
               for (const pointingDeviceSensorNode of pointingDeviceSensorNodes)
                  pointingDeviceSensorNode .push (renderObject, sensors);

               if (sensors .length)
                  renderObject .getSensors () .push (sensors);
            }

            for (const clipPlaneNode of clipPlaneNodes)
               clipPlaneNode .push (renderObject);

            for (const pointingObject of pointingObjects)
               pointingObject .traverse (type, renderObject);

            for (const clipPlaneNode of clipPlaneNodes)
               clipPlaneNode .pop (renderObject);

            if (sensors .length)
            {
               sensors .length = 0;

               renderObject .getSensors () .pop ();
            }

            return;
         }
         case _Rendering_TraverseType_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .CAMERA:
         {
            for (const cameraObject of this .cameraObjects)
               cameraObject .traverse (type, renderObject);

            return;
         }
         case _Rendering_TraverseType_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .PICKING:
         {
            if (this .getTransformSensors () .size)
            {
               const modelMatrix = renderObject .getModelViewMatrix () .get ();

               for (const transformSensorNode of this .getTransformSensors ())
                  transformSensorNode .collect (modelMatrix);
            }

            for (const pickableSensorNode of this .pickableSensorNodes)
               pickableSensorNode .traverse (type, renderObject);

            const
               browser          = this .getBrowser (),
               pickingHierarchy = browser .getPickingHierarchy ();

            pickingHierarchy .push (this);

            if (browser .getPickable () .at (-1))
            {
               for (const visibleObject of this .visibleObjects)
                  visibleObject .traverse (type, renderObject);
            }
            else
            {
               for (const pickableObject of this .pickableObjects)
                  pickableObject .traverse (type, renderObject);
            }

            pickingHierarchy .pop ();
            return;
         }
         case _Rendering_TraverseType_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .COLLISION:
         {
            const { clipPlaneNodes, collisionObjects } = this;

            for (const clipPlaneNode of clipPlaneNodes)
               clipPlaneNode .push (renderObject);

            for (const collisionObject of collisionObjects)
               collisionObject .traverse (type, renderObject);

            for (const clipPlaneNode of clipPlaneNodes)
               clipPlaneNode .pop (renderObject);

            return;
         }
         case _Rendering_TraverseType_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .SHADOW:
         {
            // Nodes that are not visible do not cast shadows.

            const { clipPlaneNodes, shadowObjects } = this;

            for (const clipPlaneNode of clipPlaneNodes)
               clipPlaneNode .push (renderObject);

            for (const shadowObject of shadowObjects)
               shadowObject .traverse (type, renderObject);

            for (const clipPlaneNode of clipPlaneNodes)
               clipPlaneNode .pop (renderObject);

            return;
         }
         case _Rendering_TraverseType_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .DISPLAY:
         {
            const { displayNodes, visibleObjects } = this;

            for (const displayNode of displayNodes)
               displayNode .push (renderObject, this);

            for (const visibleObject of visibleObjects)
               visibleObject .traverse (type, renderObject);

            for (const displayNode of displayNodes)
               displayNode .pop (renderObject);

            return;
         }
      }
   },
   dispose ()
   {
      _X3DBoundedObject_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .prototype .dispose .call (this);
      _Core_X3DChildNode_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A     .prototype .dispose .call (this);
   },
});

Object .defineProperties (X3DGroupingNode, _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .getStaticProperties ("X3DGroupingNode", "Grouping", 1));

const __default__ = X3DGroupingNode;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .add ("X3DGroupingNode", __default__));

/***/ }),

/***/ 834:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6707);
let i = 0;

const TraverseType = Object .freeze ({
   BBOX:      i ++,
   POINTER:   i ++,
   CAMERA:    i ++,
   PICKING:   i ++,
   COLLISION: i ++,
   SHADOW:    i ++,
   DISPLAY:   i ++,
});

const __default__ = TraverseType;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .add ("TraverseType", __default__));

/***/ }),

/***/ 1029:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Quaternion_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(9595);
/* harmony import */ var _Vector3_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(2639);
/* harmony import */ var _Vector4_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(3630);
/* harmony import */ var _Matrix3_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(3012);
/* harmony import */ var _Algorithm_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(4559);
/* harmony import */ var _x_ite_Namespace_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(6707);






const
   _x          = Symbol (),
   _y          = Symbol (),
   _z          = Symbol (),
   _angle      = Symbol (),
   _quaternion = Symbol ();

function Rotation4 (x, y, z, angle)
{
   this [_x]     = 0;
   this [_y]     = 0;
   this [_z]     = 1;
   this [_angle] = 0;

   switch (arguments .length)
   {
      case 0:
      {
         this [_quaternion] = new _Quaternion_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A ();
         return;
      }
      case 1:
      {
         this [_quaternion] = arguments [0];
         this .update ();
         return;
      }
      case 2:
      {
         const
            arg0 = arguments [0],
            arg1 = arguments [1];

         this [_quaternion] = new _Quaternion_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A ();

         if (arg1 instanceof _Vector3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A)
            return this .setFromToVec (arg0, arg1);

         this .set (arg0 .x,
                    arg0 .y,
                    arg0 .z,
                    arg1);

         return;
      }
      case 4:
      {
         this [_quaternion] = new _Quaternion_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A ();
         this .set (x, y, z, angle);
         return;
      }
   }
}

Object .assign (Rotation4 .prototype,
{
   *[Symbol .iterator] ()
   {
      yield this [_x];
      yield this [_y];
      yield this [_z];
      yield this [_angle];
   },
   update ()
   {
      const rotation = this .get ();

      this [_x]     = rotation .x;
      this [_y]     = rotation .y;
      this [_z]     = rotation .z;
      this [_angle] = rotation .w;

      return this;
   },
   copy ()
   {
      const copy = Object .create (Rotation4 .prototype);

      copy [_x]     = this [_x];
      copy [_y]     = this [_y];
      copy [_z]     = this [_z];
      copy [_angle] = this [_angle];

      copy [_quaternion] = this [_quaternion] .copy ();

      return copy;
   },
   assign (rotation)
   {
      this [_x]     = rotation [_x];
      this [_y]     = rotation [_y];
      this [_z]     = rotation [_z];
      this [_angle] = rotation [_angle];

      this [_quaternion] .assign (rotation [_quaternion]);

      return this;
   },
   set (x = 0, y = 0, z = 1, angle = 0)
   {
      this [_x]     = x;
      this [_y]     = y;
      this [_z]     = z;
      this [_angle] = angle;

      const scale = Math .hypot (x, y, z);

      if (scale === 0)
      {
         this [_quaternion] .set (0, 0, 0, 1);
         return this;
      }

      // Calculate quaternion

      const
         halfTheta = _Algorithm_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .interval (angle / 2, 0, Math .PI),
         ascale    = Math .sin (halfTheta) / scale;

      this [_quaternion] .set (x * ascale,
                               y * ascale,
                               z * ascale,
                               Math .cos (halfTheta));
      return this;
   },
   get: (() =>
   {
      const result = new _Vector4_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A ();

      return function ()
      {
         const quaternion = this [_quaternion];

         if (Math .abs (quaternion .w) > 1)
         {
            return _Vector4_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .Z_AXIS;
         }
         else
         {
            const
               angle = Math .acos (quaternion .w) * 2,
               scale = Math .sin (angle / 2);

            if (scale === 0)
            {
               return _Vector4_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .Z_AXIS;
            }
            else
            {
               const axis = quaternion .imag .divide (scale);

               return result .set (axis .x,
                                   axis .y,
                                   axis .z,
                                   angle);
            }
         }
      };
   })(),
   setAxisAngle (axis, angle)
   {
      return this .set (axis .x, axis .y, axis .z, angle);
   },
   setFromToVec: (() =>
   {
      const
         from = new _Vector3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (),
         to   = new _Vector3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (),
         cv   = new _Vector3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (),
         t    = new _Vector3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A ();

      return function (fromVec, toVec)
      {
         // https://bitbucket.org/Coin3D/coin/src/abc9f50968c9/src/base/SbRotation.cpp

         from .assign (fromVec) .normalize ();
         to   .assign (toVec)   .normalize ();

         const
            cos_angle = _Algorithm_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .clamp (from .dot (to), -1, 1),
            crossvec  = cv .assign (from) .cross (to) .normalize (),
            crosslen  = crossvec .norm ();

         if (crosslen === 0)
         {
            // Parallel vectors
            // Check if they are pointing in the same direction.
            if (cos_angle > 0)
               this [_quaternion] .set (0, 0, 0, 1); // standard rotation

            // Ok, so they are parallel and pointing in the opposite direction
            // of each other.
            else
            {
               // Try crossing with x axis.
               t .assign (from) .cross (_Vector3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .X_AXIS);

               // If not ok, cross with y axis.
               if (t .squaredNorm () === 0)
                  t .assign (from) .cross (_Vector3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .Y_AXIS);

               t .normalize ();

               this [_quaternion] .set (t .x, t .y, t .z, 0);
            }
         }
         else
         {
            // Vectors are not parallel
            // The abs () wrapping is to avoid problems when `dot' "overflows" a tiny wee bit,
            // which can lead to sqrt () returning NaN.
            crossvec .multiply (Math .sqrt (Math .abs (1 - cos_angle) / 2));

            this [_quaternion] .set (crossvec .x,
                                     crossvec .y,
                                     crossvec .z,
                                     Math .sqrt (Math .abs (1 + cos_angle) / 2));
         }

         this .update ();

         return this;
      };
   })(),
   setAxis (vector)
   {
      this .set (vector .x, vector .y, vector .z, this [_angle]);
   },
   getAxis (axis = new _Vector3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A ())
   {
      return axis .set (this [_x], this [_y], this [_z]);
   },
   setQuaternion (quaternion)
   {
      this [_quaternion] .assign (quaternion) .normalize ();
      this .update ();
      return this;
   },
   getQuaternion (quaternion = new _Quaternion_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A ())
   {
      return quaternion .assign (this [_quaternion]);
   },
   setMatrix (matrix)
   {
      this [_quaternion] .setMatrix (matrix) .normalize ();
      this .update ();
      return this;
   },
   getMatrix (matrix = new _Matrix3_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A ())
   {
      return this [_quaternion] .getMatrix (matrix);
   },
   setEuler (x, y, z, order = "XYZ")
   {
      // Quaternion is then already normalized.
      this [_quaternion] .setEuler (x, y, z, order);
      this .update ();
      return this;
   },
   getEuler (euler = [ ], order = "XYZ")
   {
      return this [_quaternion] .getEuler (euler, order);
   },
   equals (rotation)
   {
      return this [_quaternion] .equals (rotation [_quaternion]);
   },
   inverse ()
   {
      this [_quaternion] .inverse ();
      this .update ();
      return this;
   },
   multLeft (rotation)
   {
      this [_quaternion] .multLeft (rotation [_quaternion]) .normalize ();
      this .update ();
      return this;
   },
   multRight (rotation)
   {
      this [_quaternion] .multRight (rotation [_quaternion]) .normalize ();
      this .update ();
      return this;
   },
   multVecRot (vector)
   {
      return this [_quaternion] .multVecQuat (vector);
   },
   multRotVec (vector)
   {
      return this [_quaternion] .multQuatVec (vector);
   },
   normalize ()
   {
      this [_quaternion] .normalize ();
      this .update ();
      return this;
   },
   pow (exponent)
   {
      this [_quaternion] .pow (exponent);
      this .update ();
      return this;
   },
   slerp (dest, t)
   {
      this [_quaternion] .slerp (dest [_quaternion], t);
      this .update ();
      return this;
   },
   squad (a, b, dest, t)
   {
      this [_quaternion] .squad (a [_quaternion], b [_quaternion], dest [_quaternion], t);
      this .update ();
      return this;
   },
   /**
    * Straightens the rotation so that the x-axis of this rotation is parallel to the plane spawned by upVector.
    */
   straighten: (() =>
   {
      const
         localXAxis = new _Vector3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (),
         localZAxis = new _Vector3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (),
         upNormal   = new _Vector3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (),
         rotation   = new Rotation4 ();

      return function (upVector = _Vector3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .Y_AXIS)
      {
         upNormal .assign (upVector) .normalize ();

         this .multVecRot (localXAxis .assign (_Vector3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .X_AXIS) .negate ());
         this .multVecRot (localZAxis .assign (_Vector3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .Z_AXIS));

         // If viewer looks along up vector.
         if (Math .abs (localZAxis .dot (upNormal)) >= 1)
            return this;

         const newXAxis = localZAxis .cross (upNormal) .normalize ();

         if (newXAxis .dot (localXAxis) <= -1)
         {
            rotation .setAxisAngle (_Vector3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .Z_AXIS, Math .PI);

            return this .multLeft (rotation);
         }
         else
         {
            rotation .setFromToVec (localXAxis, newXAxis);

            return this .multRight (rotation);
         }
      };
   })(),
   toString ()
   {
      return this [_x] + " " +
             this [_y] + " " +
             this [_z] + " " +
             this [_angle];
   }
});

for (const key of Object .keys (Rotation4 .prototype))
   Object .defineProperty (Rotation4 .prototype, key, { enumerable: false });

const x = {
   get ()
   {
      return this [_x];
   },
   set (x)
   {
      this [_x] = x;
      this .set (x, this [_y], this [_z], this [_angle]);
   },
   enumerable: true,
};

const y = {
   get ()
   {
      return this [_y];
   },
   set (y)
   {
      this [_y] = y;
      this .set (this [_x], y, this [_z], this [_angle]);
   },
   enumerable: true,
};

const z = {
   get ()
   {
      return this [_z];
   },
   set (z)
   {
      this [_z] = z;
      this .set (this [_x], this [_y], z, this [_angle]);
   },
   enumerable: true,
};

const angle = {
   get ()
   {
      return this [_angle];
   },
   set (angle)
   {
      this [_angle] = angle;
      this .set (this [_x], this [_y], this [_z], angle);
   },
   enumerable: true,
};

Object .defineProperties (Rotation4 .prototype,
{
   length: { value: 4 },
   x: x,
   y: y,
   z: z,
   angle: angle,
});

x     .enumerable = false;
y     .enumerable = false;
z     .enumerable = false;
angle .enumerable = false;

Object .defineProperties (Rotation4 .prototype,
{
   0: x,
   1: y,
   2: z,
   3: angle,
});

Object .assign (Rotation4,
{
   IDENTITY: Object .freeze (new Rotation4 ()),
   fromQuaternion (quaternion)
   {
      return new Rotation4 () .setQuaternion (quaternion);
   },
   fromMatrix (matrix)
   {
      return new Rotation4 () .setMatrix (matrix);
   },
   fromEuler (x, y, z, order = "XYZ")
   {
      return new Rotation4 () .setEuler (x, y, z, order);
   },
   spline (r0, r1, r2)
   {
      const copy = Object .create (this .prototype);
      copy [_quaternion] = _Quaternion_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .spline (r0 [_quaternion], r1 [_quaternion], r2 [_quaternion]);
      copy .update ();
      return copy;
   },
});

const __default__ = Rotation4;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_x_ite_Namespace_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .add ("Rotation4", __default__));

/***/ }),

/***/ 1048:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Vector3_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(2639);
/* harmony import */ var _Vector4_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(3630);
/* harmony import */ var _Quaternion_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(9595);
/* harmony import */ var _Rotation4_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(1029);
/* harmony import */ var _Matrix3_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(3012);
/* harmony import */ var _Algorithms_eigen_decomposition_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(6253);
/* harmony import */ var _x_ite_Namespace_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(6707);







function Matrix4 (... args)
{
   if (args .length)
   {
      for (let i = 0; i < 16; ++ i)
         this [i] = args [i];
   }
   else
   {
      this .identity ();
   }
}

Object .assign (Matrix4 .prototype,
{
   *[Symbol .iterator] ()
   {
      for (let i = 0; i < 16; ++ i)
         yield this [i];
   },
   copy ()
   {
      const copy = Object .create (Matrix4 .prototype);

      for (let i = 0; i < 16; ++ i)
         copy [i] = this [i];

      return copy;
   },
   assign (matrix)
   {
      for (let i = 0; i < 16; ++ i)
         this [i] = matrix [i];

      return this;
   },
   equals (matrix)
   {
      return this [ 0] === matrix [ 0] &&
             this [ 1] === matrix [ 1] &&
             this [ 2] === matrix [ 2] &&
             this [ 3] === matrix [ 3] &&
             this [ 4] === matrix [ 4] &&
             this [ 5] === matrix [ 5] &&
             this [ 6] === matrix [ 6] &&
             this [ 7] === matrix [ 7] &&
             this [ 8] === matrix [ 8] &&
             this [ 9] === matrix [ 9] &&
             this [10] === matrix [10] &&
             this [11] === matrix [11] &&
             this [12] === matrix [12] &&
             this [13] === matrix [13] &&
             this [14] === matrix [14] &&
             this [15] === matrix [15];
   },
   set1 (r, c, value)
   {
      this [r * this .order + c] = value;

      return this;
   },
   get1 (r, c)
   {
      return this [r * this .order + c];
   },
   set: (() =>
   {
      const
         invScaleOrientation = new _Rotation4_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A (),
         invCenter           = new _Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A ();

      return function (translation, rotation, scale, scaleOrientation, center)
      {
         this .identity ();

         switch (arguments .length)
         {
            case 1:
            {
               if (translation && !translation .equals (_Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .ZERO))
                  this .translate (translation);

               break;
            }
            case 2:
            {
               if (translation && !translation .equals (_Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .ZERO))
                  this .translate (translation);

               if (rotation && !rotation .equals (_Rotation4_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .IDENTITY))
                  this .rotate (rotation);

               break;
            }
            case 3:
            {
               if (translation && !translation .equals (_Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .ZERO))
                  this .translate (translation);

               if (rotation && !rotation .equals (_Rotation4_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .IDENTITY))
                  this .rotate (rotation);

               if (scale && !scale .equals (_Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .ONE))
                  this .scale (scale);

               break;
            }
            case 4:
            {
               if (translation && !translation .equals (_Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .ZERO))
                  this .translate (translation);

               if (rotation && !rotation .equals (_Rotation4_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .IDENTITY))
                  this .rotate (rotation);

               if (scale && !scale .equals (_Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .ONE))
               {
                  if (scaleOrientation && !scaleOrientation .equals (_Rotation4_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .IDENTITY))
                  {
                     this .rotate (scaleOrientation);
                     this .scale (scale);
                     this .rotate (invScaleOrientation .assign (scaleOrientation) .inverse ());
                  }
                  else
                  {
                     this .scale (scale);
                  }
               }

               break;
            }
            case 5:
            {
               // P' = T * C * R * SR * S * -SR * -C * P
               if (translation && !translation .equals (_Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .ZERO))
                  this .translate (translation);

               const hasCenter = center && !center .equals (_Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .ZERO);

               if (hasCenter)
                  this .translate (center);

               if (rotation && !rotation .equals (_Rotation4_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .IDENTITY))
                  this .rotate (rotation);

               if (scale && !scale .equals (_Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .ONE))
               {
                  if (scaleOrientation && !scaleOrientation .equals (_Rotation4_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .IDENTITY))
                  {
                     this .rotate (scaleOrientation);
                     this .scale (scale);
                     this .rotate (invScaleOrientation .assign (scaleOrientation) .inverse ());
                  }
                  else
                  {
                     this .scale (scale);
                  }
               }

               if (hasCenter)
                  this .translate (invCenter .assign (center) .negate ());

               break;
            }
            case 16:
            {
               for (let i = 0; i < 16; ++ i)
                  this [i] = arguments [i];

               break;
            }
         }

         return this;
      };
   })(),
   get: (() =>
   {
      const c = new _Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A ();

      return function (translation, rotation, scale, scaleOrientation, center)
      {
         switch (arguments .length)
         {
            case 1:
            {
               translation .set (this [12], this [13], this [14]);
               break;
            }
            case 2:
            case 3:
            case 4:
            {
               this .factor (translation, rotation, scale, scaleOrientation);
               break;
            }
            case 5:
            {
               if (center)
               {
                  m .set (c .assign (center) .negate ());
                  m .multLeft (this);
                  m .translate (center);
                  m .get (translation, rotation, scale, scaleOrientation);
               }
               else
               {
                  this .factor (translation, rotation, scale, scaleOrientation);
               }

               break;
            }
         }
      };
   })(),
   setRotation (rotation)
   {
      return this .setQuaternion (rotation .getQuaternion (q));
   },
   setQuaternion (quaternion)
   {
      const
         { x, y, z, w } = quaternion,
         A = y * y,
         B = z * z,
         C = x * y,
         D = z * w,
         E = z * x,
         F = y * w,
         G = x * x,
         H = y * z,
         I = x * w;

      this [0]  = 1 - 2 * (A + B);
      this [1]  = 2 * (C + D);
      this [2]  = 2 * (E - F);
      this [3]  = 0;
      this [4]  = 2 * (C - D);
      this [5]  = 1 - 2 * (B + G);
      this [6]  = 2 * (H + I);
      this [7]  = 0;
      this [8]  = 2 * (E + F);
      this [9]  = 2 * (H - I);
      this [10] = 1 - 2 * (A + G);
      this [11] = 0;
      this [12] = 0;
      this [13] = 0;
      this [14] = 0;
      this [15] = 1;

      return this;
   },
   factor: (() =>
   {
      const
         s  = new _Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A (),
         si = new _Matrix3_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A (),
         so = new _Matrix3_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A (),
         b  = new _Matrix3_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A ();

      const eigen = { values: [ ], vectors: [[ ], [ ], [ ]] };

      return function (translation, rotation, scale, scaleOrientation)
      {
         // (1) Get translation.
         translation ?.set (this [12], this [13], this [14]);

         // (2) Create 3x3 matrix.
         const a = this .submatrix;

         // (3) Compute det A. If negative, set sign = -1, else sign = 1
         const det      = a .determinant ();
         const det_sign = det < 0 ? -1 : 1;

         // (4) B = A * !A  (here !A means A transpose)
         b .assign (a) .transpose () .multLeft (a);
         const e = (0,_Algorithms_eigen_decomposition_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A) (b, eigen);

         // Find min / max eigenvalues and do ratio test to determine singularity.

         so .set (e .vectors [0] [0], e .vectors [1] [0], e .vectors [2] [0],
                  e .vectors [0] [1], e .vectors [1] [1], e .vectors [2] [1],
                  e .vectors [0] [2], e .vectors [1] [2], e .vectors [2] [2]);

         scaleOrientation ?.setMatrix (so);

         // Compute s = sqrt(eigen values), with sign. Set si = s-inverse

         s .set (det_sign * Math .sqrt (e .values [0]),
                 det_sign * Math .sqrt (e .values [1]),
                 det_sign * Math .sqrt (e .values [2]));

         scale ?.assign (s);

         if (rotation)
         {
            si [0] = 1 / s .x;
            si [4] = 1 / s .y;
            si [8] = 1 / s .z;

            // (5) Compute U = !R ~S R A.
            rotation .setMatrix (a .multLeft (so) .multLeft (si) .multLeft (so .transpose ()));
         }
      };
   })(),
   determinant3 ()
   {
      const { 0: m00, 1: m01, 2: m02,
              4: m04, 5: m05, 6: m06,
              8: m08, 9: m09, 10: m10 } = this;

      return m00 * (m05 * m10 - m06 * m09) -
             m01 * (m04 * m10 - m06 * m08) +
             m02 * (m04 * m09 - m05 * m08);
   },
   determinant ()
   {
      const
         { 0: m00, 1: m01, 2: m02, 3: m03, 4: m04, 5: m05, 6: m06, 7: m07,
           8: m08, 9: m09, 10: m10, 11: m11, 12: m12, 13: m13, 14: m14, 15: m15 } = this,
         b = m10 * m15,
         c = m14 * m11,
         d = m06 * m15,
         e = m14 * m07,
         f = m06 * m11,
         g = m10 * m07,
         h = m02 * m15,
         i = m14 * m03,
         j = m02 * m11,
         o = m10 * m03,
         r = m02 * m07,
         x = m06 * m03,
         H = b * m05 + e * m09 + f * m13 - (c * m05) - (d * m09) - (g * m13),
         I = c * m01 + h * m09 + o * m13 - (b * m01) - (i * m09) - (j * m13),
         J = d * m01 + i * m05 + r * m13 - (e * m01) - (h * m05) - (x * m13),
         K = g * m01 + j * m05 + x * m09 - (f * m01) - (o * m05) - (r * m09);

      return m00 * H + m04 * I + m08 * J + m12 * K;
   },
   transpose ()
   {
      let tmp;

      tmp = this [ 1]; this [ 1] = this [ 4]; this [ 4] = tmp;
      tmp = this [ 2]; this [ 2] = this [ 8]; this [ 8] = tmp;
      tmp = this [ 3]; this [ 3] = this [12]; this [12] = tmp;
      tmp = this [ 6]; this [ 6] = this [ 9]; this [ 9] = tmp;
      tmp = this [ 7]; this [ 7] = this [13]; this [13] = tmp;
      tmp = this [11]; this [11] = this [14]; this [14] = tmp;

      return this;
   },
   inverse ()
   {
      // Complexity 43 +, 40 -, 140 *. 1 /

      const
         { 0: m00, 1: m01, 2: m02, 3: m03, 4: m04, 5: m05, 6: m06, 7: m07,
           8: m08, 9: m09, 10: m10, 11: m11, 12: m12, 13: m13, 14: m14, 15: m15 } = this,
         b = m10 * m15,
         c = m14 * m11,
         d = m06 * m15,
         e = m14 * m07,
         f = m06 * m11,
         g = m10 * m07,
         h = m02 * m15,
         i = m14 * m03,
         j = m02 * m11,
         o = m10 * m03,
         r = m02 * m07,
         x = m06 * m03,
         t = m08 * m13,
         p = m12 * m09,
         v = m04 * m13,
         s = m12 * m05,
         y = m04 * m09,
         z = m08 * m05,
         A = m00 * m13,
         C = m12 * m01,
         D = m00 * m09,
         E = m08 * m01,
         F = m00 * m05,
         G = m04 * m01,
         H = b * m05 + e * m09 + f * m13 - ((c * m05) + (d * m09) + (g * m13)),
         I = c * m01 + h * m09 + o * m13 - ((b * m01) + (i * m09) + (j * m13)),
         J = d * m01 + i * m05 + r * m13 - ((e * m01) + (h * m05) + (x * m13)),
         K = g * m01 + j * m05 + x * m09 - ((f * m01) + (o * m05) + (r * m09));

      let B = m00 * H + m04 * I + m08 * J + m12 * K;

      // if (B === 0) ... determinant is zero.

      B = 1 / B;

      this [ 0] = B * H;
      this [ 1] = B * I;
      this [ 2] = B * J;
      this [ 3] = B * K;
      this [ 4] = B * (c * m04 + d * m08 + g * m12 - (b * m04) - (e * m08) - (f * m12));
      this [ 5] = B * (b * m00 + i * m08 + j * m12 - (c * m00) - (h * m08) - (o * m12));
      this [ 6] = B * (e * m00 + h * m04 + x * m12 - (d * m00) - (i * m04) - (r * m12));
      this [ 7] = B * (f * m00 + o * m04 + r * m08 - (g * m00) - (j * m04) - (x * m08));
      this [ 8] = B * (t * m07 + s * m11 + y * m15 - (p * m07) - (v * m11) - (z * m15));
      this [ 9] = B * (p * m03 + A * m11 + E * m15 - (t * m03) - (C * m11) - (D * m15));
      this [10] = B * (v * m03 + C * m07 + F * m15 - (s * m03) - (A * m07) - (G * m15));
      this [11] = B * (z * m03 + D * m07 + G * m11 - (y * m03) - (E * m07) - (F * m11));
      this [12] = B * (v * m10 + z * m14 + p * m06 - (y * m14) - (t * m06) - (s * m10));
      this [13] = B * (D * m14 + t * m02 + C * m10 - (A * m10) - (E * m14) - (p * m02));
      this [14] = B * (A * m06 + G * m14 + s * m02 - (F * m14) - (v * m02) - (C * m06));
      this [15] = B * (F * m10 + y * m02 + E * m06 - (D * m06) - (G * m10) - (z * m02));

      return this;
   },
   multLeft (matrix)
   {
      // Complexity 48 +, 64 *.

      const
         { 0: a00, 1: a01, 2: a02, 3: a03, 4: a04, 5: a05, 6: a06, 7: a07,
           8: a08, 9: a09, 10: a10, 11: a11, 12: a12, 13: a13, 14: a14, 15: a15 } = this,
         { 0: b00, 1: b01, 2: b02, 3: b03, 4: b04, 5: b05, 6: b06, 7: b07,
           8: b08, 9: b09, 10: b10, 11: b11, 12: b12, 13: b13, 14: b14, 15: b15 } = matrix;

      this [ 0] = a00 * b00 + a04 * b01 + a08 * b02 + a12 * b03;
      this [ 1] = a01 * b00 + a05 * b01 + a09 * b02 + a13 * b03;
      this [ 2] = a02 * b00 + a06 * b01 + a10 * b02 + a14 * b03;
      this [ 3] = a03 * b00 + a07 * b01 + a11 * b02 + a15 * b03;
      this [ 4] = a00 * b04 + a04 * b05 + a08 * b06 + a12 * b07;
      this [ 5] = a01 * b04 + a05 * b05 + a09 * b06 + a13 * b07;
      this [ 6] = a02 * b04 + a06 * b05 + a10 * b06 + a14 * b07;
      this [ 7] = a03 * b04 + a07 * b05 + a11 * b06 + a15 * b07;
      this [ 8] = a00 * b08 + a04 * b09 + a08 * b10 + a12 * b11;
      this [ 9] = a01 * b08 + a05 * b09 + a09 * b10 + a13 * b11;
      this [10] = a02 * b08 + a06 * b09 + a10 * b10 + a14 * b11;
      this [11] = a03 * b08 + a07 * b09 + a11 * b10 + a15 * b11;
      this [12] = a00 * b12 + a04 * b13 + a08 * b14 + a12 * b15;
      this [13] = a01 * b12 + a05 * b13 + a09 * b14 + a13 * b15;
      this [14] = a02 * b12 + a06 * b13 + a10 * b14 + a14 * b15;
      this [15] = a03 * b12 + a07 * b13 + a11 * b14 + a15 * b15;

      return this;
   },
   multRight (matrix)
   {
      // Complexity 48 +, 64 *.

      const
         { 0: a00, 1: a01, 2: a02, 3: a03, 4: a04, 5: a05, 6: a06, 7: a07,
           8: a08, 9: a09, 10: a10, 11: a11, 12: a12, 13: a13, 14: a14, 15: a15 } = this,
         { 0: b00, 1: b01, 2: b02, 3: b03, 4: b04, 5: b05, 6: b06, 7: b07,
           8: b08, 9: b09, 10: b10, 11: b11, 12: b12, 13: b13, 14: b14, 15: b15 } = matrix;

      this [ 0] = a00 * b00 + a01 * b04 + a02 * b08 + a03 * b12;
      this [ 1] = a00 * b01 + a01 * b05 + a02 * b09 + a03 * b13;
      this [ 2] = a00 * b02 + a01 * b06 + a02 * b10 + a03 * b14;
      this [ 3] = a00 * b03 + a01 * b07 + a02 * b11 + a03 * b15;
      this [ 4] = a04 * b00 + a05 * b04 + a06 * b08 + a07 * b12;
      this [ 5] = a04 * b01 + a05 * b05 + a06 * b09 + a07 * b13;
      this [ 6] = a04 * b02 + a05 * b06 + a06 * b10 + a07 * b14;
      this [ 7] = a04 * b03 + a05 * b07 + a06 * b11 + a07 * b15;
      this [ 8] = a08 * b00 + a09 * b04 + a10 * b08 + a11 * b12;
      this [ 9] = a08 * b01 + a09 * b05 + a10 * b09 + a11 * b13;
      this [10] = a08 * b02 + a09 * b06 + a10 * b10 + a11 * b14;
      this [11] = a08 * b03 + a09 * b07 + a10 * b11 + a11 * b15;
      this [12] = a12 * b00 + a13 * b04 + a14 * b08 + a15 * b12;
      this [13] = a12 * b01 + a13 * b05 + a14 * b09 + a15 * b13;
      this [14] = a12 * b02 + a13 * b06 + a14 * b10 + a15 * b14;
      this [15] = a12 * b03 + a13 * b07 + a14 * b11 + a15 * b15;

      return this;
   },
   multVecMatrix (vector)
   {
      if (vector .length === 3)
      {
         const
            { x, y, z } = vector,
            w = 1 / (x * this [3] + y * this [7] + z * this [11] + this [15]);

         vector .x = (x * this [0] + y * this [4] + z * this [ 8] + this [12]) * w;
         vector .y = (x * this [1] + y * this [5] + z * this [ 9] + this [13]) * w;
         vector .z = (x * this [2] + y * this [6] + z * this [10] + this [14]) * w;

         return vector;
      }
      else
      {
         const { x, y, z, w } = vector;

         vector .x = x * this [0] + y * this [4] + z * this [ 8] + w * this [12];
         vector .y = x * this [1] + y * this [5] + z * this [ 9] + w * this [13];
         vector .z = x * this [2] + y * this [6] + z * this [10] + w * this [14];
         vector .w = x * this [3] + y * this [7] + z * this [11] + w * this [15];

         return vector;
      }
   },
   multMatrixVec (vector)
   {
      if (vector .length === 3)
      {
         const
            { x, y, z } = vector,
            w = 1 / (x * this [12] + y * this [13] + z * this [14] + this [15]);

         vector .x = (x * this [0] + y * this [1] + z * this [ 2] + this [ 3]) * w;
         vector .y = (x * this [4] + y * this [5] + z * this [ 6] + this [ 7]) * w;
         vector .z = (x * this [8] + y * this [9] + z * this [10] + this [11]) * w;

         return vector;
      }
      else
      {
         const { x, y, z, w } = vector;

         vector .x = x * this [ 0] + y * this [ 1] + z * this [ 2] + w * this [ 3];
         vector .y = x * this [ 4] + y * this [ 5] + z * this [ 6] + w * this [ 7];
         vector .z = x * this [ 8] + y * this [ 9] + z * this [10] + w * this [11];
         vector .w = x * this [12] + y * this [13] + z * this [14] + w * this [15];

         return vector;
      }
   },
   multDirMatrix (vector)
   {
      const { x, y, z } = vector;

      vector .x = x * this [0] + y * this [4] + z * this [ 8];
      vector .y = x * this [1] + y * this [5] + z * this [ 9];
      vector .z = x * this [2] + y * this [6] + z * this [10];

      return vector;
   },
   multMatrixDir (vector)
   {
      const { x, y, z } = vector;

      vector .x = x * this [0] + y * this [1] + z * this [ 2];
      vector .y = x * this [4] + y * this [5] + z * this [ 6];
      vector .z = x * this [8] + y * this [9] + z * this [10];

      return vector;
   },
   identity ()
   {
      this [ 0] = 1; this [ 1] = 0; this [ 2] = 0; this [ 3] = 0;
      this [ 4] = 0; this [ 5] = 1; this [ 6] = 0; this [ 7] = 0;
      this [ 8] = 0; this [ 9] = 0; this [10] = 1; this [11] = 0;
      this [12] = 0; this [13] = 0; this [14] = 0; this [15] = 1;

      return this;
   },
   translate (translation)
   {
      const { x, y, z } = translation;

      this [12] += this [ 0] * x + this [ 4] * y + this [ 8] * z;
      this [13] += this [ 1] * x + this [ 5] * y + this [ 9] * z;
      this [14] += this [ 2] * x + this [ 6] * y + this [10] * z;

      return this;
   },
   rotate (rotation)
   {
      return this .multLeft (m .setQuaternion (rotation .getQuaternion (q)));
   },
   scale (scale)
   {
      const { x, y, z } = scale;

      this [ 0] *= x;
      this [ 4] *= y;
      this [ 8] *= z;

      this [ 1] *= x;
      this [ 5] *= y;
      this [ 9] *= z;

      this [ 2] *= x;
      this [ 6] *= y;
      this [10] *= z;

      return this;
   },
   toString ()
   {
      return Array .prototype .join .call (this, " ");
   },
});

for (const key of Object .keys (Matrix4 .prototype))
   Object .defineProperty (Matrix4 .prototype, key, { enumerable: false });

Object .defineProperties (Matrix4 .prototype,
{
   order: { value: 4 },
   length: { value: 16 },
   x:
   {
      get: (() =>
      {
         const vector = new _Vector4_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A ();

         return function () { return vector .set (this [0], this [1], this [2], this [3]); };
      })(),
   },
   y:
   {
      get: (() =>
      {
         const vector = new _Vector4_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A ();

         return function () { return vector .set (this [4], this [5], this [6], this [7]); };
      })(),
   },
   z:
   {
      get: (() =>
      {
         const vector = new _Vector4_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A ();

         return function () { return vector .set (this [8], this [9], this [10], this [11]); };
      })(),
   },
   w:
   {
      get: (() =>
      {
         const vector = new _Vector4_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A ();

         return function () { return vector .set (this [12], this [13], this [14], this [15]); };
      })(),
   },
   X_AXIS:
   {
      get: (() =>
      {
         const vector = new _Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A ();

         return function () { return vector .set (this [0], this [1], this [2]); };
      })(),
   },
   Y_AXIS:
   {
      get: (() =>
      {
         const vector = new _Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A ();

         return function () { return vector .set (this [4], this [5], this [6]); };
      })(),
   },
   Z_AXIS:
   {
      get: (() =>
      {
         const vector = new _Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A ();

         return function () { return vector .set (this [8], this [9], this [10]); };
      })(),
   },
   origin:
   {
      get: (() =>
      {
         const vector = new _Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A ();

         return function () { return vector .set (this [12], this [13], this [14]); };
      })(),
   },
   submatrix:
   {
      get: (() =>
      {
         const matrix = new _Matrix3_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A ();

         return function ()
         {
            matrix [0] = this [0]; matrix [1] = this [1]; matrix [2] = this [ 2];
            matrix [3] = this [4]; matrix [4] = this [5]; matrix [5] = this [ 6];
            matrix [6] = this [8]; matrix [7] = this [9]; matrix [8] = this [10];
            return matrix;
         };
      })(),
   },
});

Object .assign (Matrix4,
{
   IDENTITY: Object .freeze (new Matrix4 ()),
   Rotation (rotation)
   {
      return Object .create (this .prototype) .setQuaternion (rotation .getQuaternion (q));
   },
   Quaternion (quaternion)
   {
      return Object .create (this .prototype) .setQuaternion (quaternion);
   },
   Matrix3 (matrix)
   {
      return new Matrix4 (matrix [0], matrix [1], 0, 0,
                          matrix [3], matrix [4], 0, 0,
                          0, 0, 1, 0,
                          matrix [6], matrix [7], 0, 1);
   },
   SubMatrix (matrix)
   {
      return new Matrix4 (matrix [0], matrix [1], matrix [2], 0,
                          matrix [3], matrix [4], matrix [5], 0,
                          matrix [6], matrix [7], matrix [8], 0,
                          0, 0, 0, 1);
   },
});

const
   q = new _Quaternion_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A (),
   m = new Matrix4 ();

const __default__ = Matrix4;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_x_ite_Namespace_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .add ("Matrix4", __default__));

/***/ }),

/***/ 1209:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Fields_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(564);
/* harmony import */ var _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(8311);
/* harmony import */ var _Base_FieldDefinitionArray_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(6973);
/* harmony import */ var _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(8415);
/* harmony import */ var _X3DGroupingNode_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(832);
/* harmony import */ var _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(8899);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(6707);







function Group (executionContext)
{
   _X3DGroupingNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .call (this, executionContext);

   this .addType (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .Group);
}

Object .setPrototypeOf (Group .prototype, _X3DGroupingNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .prototype);

Object .defineProperties (Group,
{
   ... _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .getStaticProperties ("Group", "Grouping", 1, "children", "2.0"),
   fieldDefinitions:
   {
      value: new _Base_FieldDefinitionArray_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A ([
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .inputOutput,    "metadata",       new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFNode ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .inputOutput,    "visible",        new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFBool (true)),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .inputOutput,    "bboxDisplay",    new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFBool ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .initializeOnly, "bboxSize",       new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFVec3f (-1, -1, -1)),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .initializeOnly, "bboxCenter",     new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFVec3f ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .inputOnly,      "addChildren",    new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFNode ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .inputOnly,      "removeChildren", new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFNode ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .inputOutput,    "children",       new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFNode ()),
      ]),
      enumerable: true,
   },
});

const __default__ = Group;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .add ("Group", __default__));

/***/ }),

/***/ 1426:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Base_X3DField_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(5702);
/* harmony import */ var _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(8899);
/* harmony import */ var _SFNodeCache_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(6882);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(6707);




const
   _target = Symbol (),
   _proxy  = Symbol ();

const handler =
{
   get (target, key)
   {
      try
      {
         const value = target [key];

         if (value !== undefined)
            return value;

         const
            node  = target .getValue (),
            field = node .getField (key);

         // Specification conform would be: accessType & X3DConstants .outputOnly.
         // But we allow read access to plain fields, too.
         if (field .getAccessType () === _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .inputOnly)
            return undefined;

         return field .valueOf ();
      }
      catch
      {
         return undefined;
      }
   },
   set (target, key, value)
   {
      if (key in target)
      {
         target [key] = value;
         return true;
      }

      try
      {
         const
            node       = target .getValue (),
            field      = node .getField (key),
            accessType = field .getAccessType ();

         if (accessType !== _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .outputOnly)
            field .setValue (value);

         return true;
      }
      catch (error)
      {
         console .error (target, key, error);
         return false;
      }
   },
   has (target, key)
   {
      try
      {
         return !! target .getValue () .getField (key);
      }
      catch
      {
         return key in target;
      }
   },
   ownKeys (target)
   {
      const
         value   = target .getValue (),
         ownKeys = [ ];

      if (value)
      {
         for (const { name } of value .getFieldDefinitions ())
            ownKeys .push (name);
      }

      return ownKeys;
   },
   getOwnPropertyDescriptor (target, key)
   {
      const value = target .getValue ();

      if (value)
      {
         const fieldDefinition = value .getFieldDefinitions () .get (key);

         if (fieldDefinition)
         {
            return {
               value: this .get (target, key),
               writable: fieldDefinition .accessType !== _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .outputOnly,
               enumerable: true,
               configurable: true,
            };
         }
      }
   },
};

function SFNode (value)
{
   // Node need to test for X3DBaseNode, because there is a special version of SFNode in Script.

   const proxy = new Proxy (this, handler);

   this [_target] = this;
   this [_proxy]  = proxy;

   if (value ?.getType () .includes (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .X3DNode))
   {
      value .addParent (proxy);

      _Base_X3DField_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .call (this, value);
   }
   else
   {
      _Base_X3DField_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .call (this, null);
   }

   return proxy;
}

Object .assign (Object .setPrototypeOf (SFNode .prototype, _Base_X3DField_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .prototype),
{
   [_target]: null,
   [_proxy]: null,
   copy (instance)
   {
      const
         target = this [_target],
         value  = target .getValue ();

      if (value && instance)
      {
         const copy = value .copy (instance);

         copy .setup ();

         return new SFNode (copy);
      }

      return new SFNode (value);
   },
   equals (node)
   {
      const target = this [_target];

      if (node)
         return target .getValue () === node .getValue ();

      return target .getValue () === null;
   },
   isDefaultValue ()
   {
      const target = this [_target];

      return target .getValue () === null;
   },
   set (value)
   {
      const
         target  = this [_target],
         current = target .getValue ();

      current ?.removeParent (target [_proxy]);

      // No need to test for X3DBaseNode, because there is a special version of SFNode in Script.

      if (value ?.getType () .includes (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .X3DNode))
      {
         value .addParent (target [_proxy]);

         _Base_X3DField_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .prototype .set .call (target, value);
      }
      else
      {
         _Base_X3DField_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .prototype .set .call (target, null);
      }
   },
   getNodeTypeName ()
   {
      const
         target = this [_target],
         value  = target .getValue ();

      if (value)
         return value .getTypeName ();

      throw new Error ("SFNode.getNodeTypeName: node is null.");
   },
   getNodeName ()
   {
      const
         target = this [_target],
         value  = target .getValue ();

      if (value)
         return value .getName ();

      throw new Error ("SFNode.getNodeName: node is null.");
   },
   getNodeDisplayName ()
   {
      const
         target = this [_target],
         value  = target .getValue ();

      if (value)
         return value .getDisplayName ();

      throw new Error ("SFNode.getNodeDisplayName: node is null.");
   },
   getNodeType ()
   {
      const
         target = this [_target],
         value  = target .getValue ();

      if (value)
         return Array .from (value .getType ());

      throw new Error ("SFNode.getNodeType: node is null.");
   },
   getFieldDefinition (name)
   {
      const fieldDefinition = this .getFieldDefinitions () .get (name);

      if (fieldDefinition)
         return fieldDefinition;

      throw new Error (`Unknown field '${name}' in node class ${this .getNodeTypeName ()}.`);
   },
   getFieldDefinitions ()
   {
      const
         target = this [_target],
         value  = target .getValue ();

      if (value)
         return value .getFieldDefinitions ();

      throw new Error ("SFNode.getFieldDefinitions: node is null.");
   },
   /**
   * @deprecated Returns the corresponding X3DField object associated with *name*. Use sfnode.{fieldName} syntax.
   */
   getField (name)
   {
      const
         target = this [_target],
         value  = target .getValue ();

      if (value)
         return value .getField (name);

      throw new Error ("SFNode is disposed.")
   },
   addFieldCallback (... args)
   {
      const target = this [_target];

      switch (args .length)
      {
         case 2:
         {
            const [key, callback] = args;

            return _Base_X3DField_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .prototype .addFieldCallback .call (target, key, callback);
         }
         case 3:
         {
            const
               [key, name, callback] = args,
               value                 = target .getValue ();

            if (value)
               return value .getField (name) .addFieldCallback (key, callback);

            throw new Error ("SFNode.addFieldCallback: node is null.");
         }
      }
   },
   removeFieldCallback (... args)
   {
      const target = this [_target];

      switch (args .length)
      {
         case 1:
         {
            const key = [args];

            return _Base_X3DField_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .prototype .removeFieldCallback .call (target, key);
         }
         case 2:
         {
            const
               [key, name] = args,
               value       = target .getValue ();

            if (value)
               return value .getField (name) .removeFieldCallback (key);

            throw new Error ("SFNode.removeFieldCallback: node is null.");
         }
      }
   },
   getNodeUserData (key)
   {
      const value = this [_target] .getValue ();

      if (value)
         return value .getUserData (key);

      throw new Error ("SFNode.getNodeUserData: node is null.");
   },
   setNodeUserData (key, data)
   {
      const value = this [_target] .getValue ();

      if (value)
         return value .setUserData (key, data);

      throw new Error ("SFNode.setNodeUserData: node is null.");
   },
   removeNodeUserData (key)
   {
      const value = this [_target] .getValue ();

      if (value)
         return value .removeUserData (key);

      throw new Error ("SFNode.removeNodeUserData: node is null.");
   },
   valueOf ()
   {
      const
         target = this [_target],
         value  = target .getValue ();

      return value ? _SFNodeCache_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .get (value) : null;
   },
   toStream (generator)
   {
      const
         target = this [_target],
         value  = target .getValue ();

      if (value)
         value .toStream (generator);
      else
         generator .NULL ();
   },
   toVRMLStream (generator)
   {
      const
         target = this [_target],
         value  = target .getValue ();

      if (value)
         value .toVRMLStream (generator);
      else
         generator .NULL ();
   },
   toXMLStream (generator)
   {
      const
         target = this [_target],
         value  = target .getValue ();

      if (value)
         value .toXMLStream (generator);
      else
         generator .string += "<!-- NULL -->";
   },
   toJSONStream (generator)
   {
      this .toJSONStreamValue (generator);
   },
   toJSONStreamValue (generator)
   {
      const
         target = this [_target],
         value  = target .getValue ();

      if (value)
         value .toJSONStream (generator);
      else
         generator .string += "null";
   },
   dispose ()
   {
      const target = this [_target];

      target .set (null);
      target .processInterests ();

      _Base_X3DField_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .prototype .dispose .call (target);
   },
});

for (const key of Object .keys (SFNode .prototype))
   Object .defineProperty (SFNode .prototype, key, { enumerable: false });

Object .defineProperties (SFNode,
{
   type:
   {
      value: _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .SFNode,
      enumerable: true,
   },
   typeName:
   {
      value: "SFNode",
      enumerable: true,
   },
});

const __default__ = SFNode;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .add ("SFNode", __default__));

/***/ }),

/***/ 1509:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6707);
// Latest implemented specification version:

const __default__ = "4.0";
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .add ("LATEST_VERSION", __default__));

/***/ }),

/***/ 1542:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6707);
const Events = Object .assign ([ ],
{
   create (field)
   {
      const event = this .pop () ?? new Set ();

      event .field = field;
      event .clear ();

      return event;
   },
   copy (event)
   {
      const copy = this .create (event .field);

      for (const source of event)
         copy .add (source);

      return copy;
   },
   from (field)
   {
      const event = this .create (field);

      event .add (field);

      return event;
   },
});

for (const key of Object .keys (Events))
   Object .defineProperty (Events, key, { enumerable: false });

const __default__ = Events;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .add ("Events", __default__));

/***/ }),

/***/ 1571:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Fields_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(564);
/* harmony import */ var _X3DExecutionContext_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(7926);
/* harmony import */ var _NamedNodesHandling_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(6029);
/* harmony import */ var _Configuration_ComponentInfo_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(4503);
/* harmony import */ var _Configuration_ComponentInfoArray_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(1678);
/* harmony import */ var _Configuration_UnitInfo_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(8060);
/* harmony import */ var _Configuration_UnitInfoArray_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(4747);
/* harmony import */ var _X3DExportedNode_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(2512);
/* harmony import */ var _ExportedNodesArray_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(5295);
/* harmony import */ var _Base_X3DCast_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(4667);
/* harmony import */ var _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(8899);
/* harmony import */ var _Fields_SFNodeCache_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(6882);
/* harmony import */ var _LATEST_VERSION_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(1509);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(6707);














const
   _specificationVersion = Symbol (),
   _encoding             = Symbol (),
   _profile              = Symbol (),
   _components           = Symbol (),
   _worldURL             = Symbol (),
   _units                = Symbol (),
   _metadata             = Symbol (),
   _exportedNodes        = Symbol (),
   _loadingObjects       = Symbol ();

function X3DScene (browser)
{
   _X3DExecutionContext_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .call (this, null, null, browser);

   this .addType (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_10__/* ["default"] */ .A .X3DScene)

   this .addChildObjects (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_10__/* ["default"] */ .A .outputOnly, "profile_changed",  new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFTime (),
                          _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_10__/* ["default"] */ .A .outputOnly, "metadata_changed", new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFTime (),
                          _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_10__/* ["default"] */ .A .outputOnly, "loadCount",        new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFInt32 ())

   this .getRootNodes () .setAccessType (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_10__/* ["default"] */ .A .inputOutput);

   this .setLive (false);

   // Private properties

   this [_specificationVersion] = _LATEST_VERSION_js__WEBPACK_IMPORTED_MODULE_12__/* ["default"] */ .A;
   this [_encoding]             = "SCRIPTED";
   this [_profile]              = null;
   this [_components]           = new _Configuration_ComponentInfoArray_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A ([ ]);
   this [_worldURL]             = location .toString ();
   this [_units]                = new _Configuration_UnitInfoArray_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A ();

   this [_units] .add ("angle",  new _Configuration_UnitInfo_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A ("angle",  "radian",   1));
   this [_units] .add ("force",  new _Configuration_UnitInfo_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A ("force",  "newton",   1));
   this [_units] .add ("length", new _Configuration_UnitInfo_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A ("length", "metre",    1));
   this [_units] .add ("mass",   new _Configuration_UnitInfo_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A ("mass",   "kilogram", 1));

   this [_metadata]       = [ ];
   this [_exportedNodes]  = new _ExportedNodesArray_js__WEBPACK_IMPORTED_MODULE_8__/* ["default"] */ .A ();
   this [_loadingObjects] = new Set ();

   this [_components]    .addParent (this);
   this [_units]         .addParent (this);
   this [_exportedNodes] .addParent (this);
}

Object .assign (Object .setPrototypeOf (X3DScene .prototype, _X3DExecutionContext_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .prototype),
{
   getLocalScene ()
   {
      return this;
   },
   setSpecificationVersion (specificationVersion)
   {
      this [_specificationVersion] = String (specificationVersion);
   },
   getSpecificationVersion ()
   {
      return this [_specificationVersion];
   },
   setEncoding (encoding)
   {
      this [_encoding] = String (encoding);
   },
   getEncoding ()
   {
      return this [_encoding];
   },
   setWorldURL (url)
   {
      this [_worldURL] = String (url);
   },
   getWorldURL ()
   {
      return this [_worldURL];
   },
   getBaseURL ()
   {
      if (this [_worldURL] .match (/^(?:data|blob):/))
      {
         return this .getExecutionContext () ?.getBaseURL ()
            ?? this .getBrowser () .getBaseURL ();
      }

      return this [_worldURL];
   },
   setProfile (profile)
   {
      this [_profile] = profile;

      this ._profile_changed = Date .now () / 1000;
   },
   getProfile ()
   {
      return this [_profile];
   },
   hasComponent (name, level = 0)
   {
      if (name instanceof _Configuration_ComponentInfo_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A)
         var { name, level } = name;

      const
         browser = this .getBrowser (),
         profile = this [_profile] ?? browser .getProfile ("Full");

      return [profile .components .get (name), this [_components] .get (name)]
         .some (component => component && level <= component .level);
   },
   addComponent (component)
   {
      this [_components] .add (component .name, component);

      this ._components_changed = Date .now () / 1000;
   },
   updateComponent (component)
   {
      this [_components] .update (component .name, component .name, component);

      this ._components_changed = Date .now () / 1000;
   },
   removeComponent (name)
   {
      this [_components] .remove (name);

      this ._components_changed = Date .now () / 1000;
   },
   getComponents ()
   {
      return this [_components];
   },
   updateUnit (category, name, conversionFactor)
   {
      // Private function.

      if (!this [_units] .has (category))
         return;

      this [_units] .update (category, category, new _Configuration_UnitInfo_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A (category, String (name),  Number (conversionFactor)));

      this ._units_changed = Date .now () / 1000;
   },
   getUnit (category)
   {
      return this [_units] .get (category);
   },
   getUnits ()
   {
      return this [_units];
   },
   fromUnit (category, value)
   {
      switch (category)
      {
         // Base units

         case "angle":
         case "force":
         case "length":
         case "mass":
            return value * this .getUnits () .get (category) .conversionFactor;

         // Derived units

         case "acceleration:":
            return value * this .getUnits () .get ("length") .conversionFactor;
         case "angularRate":
            return value * this .getUnits () .get ("angle") .conversionFactor;
         case "area":
            return value * this .getUnits () .get ("length") .conversionFactor ** 2;
         case "speed":
            return value * this .getUnits () .get ("length") .conversionFactor;
         case "volume":
            return value * this .getUnits () .get ("length") .conversionFactor ** 3;
      }

      return value;
   },
   toUnit (category, value)
   {
      switch (category)
      {
         // Base units

         case "angle":
         case "force":
         case "length":
         case "mass":
            return value / this .getUnits () .get (category) .conversionFactor;

         // Derived units

         case "acceleration:":
            return value / this .getUnits () .get ("length") .conversionFactor;
         case "angularRate":
            return value / this .getUnits () .get ("angle") .conversionFactor;
         case "area":
            return value / this .getUnits () .get ("length") .conversionFactor ** 2;
         case "speed":
            return value / this .getUnits () .get ("length") .conversionFactor;
         case "volume":
            return value / this .getUnits () .get ("length") .conversionFactor ** 3;
      }

      return value;
   },
   setMetaData (name, values)
   {
      name   = String (name);
      values = Array .isArray (values) ? values .map (String) : [String (values)];

      if (!name .length)
         throw new Error ("Couldn't add metadata: name is empty.");

      let index = this [_metadata] .findIndex (entry => entry [0] === name);

      this .removeMetaData (name);

      if (index === -1)
         index = this [_metadata] .length;

      for (const [i, value] of values .entries ())
         this [_metadata] .splice (index + i, 0, [name, value]);

      this ._metadata_changed = Date .now () / 1000;
   },
   addMetaData (name, values)
   {
      name   = String (name);
      values = Array .isArray (values) ? values .map (String) : [String (values)];

      if (!name .length)
         throw new Error ("Couldn't add metadata: name is empty.");

      for (const value of values)
         this [_metadata] .push ([name, value]);

      this ._metadata_changed = Date .now () / 1000;
   },
   removeMetaData (name)
   {
      name = String (name);

      this [_metadata] = this [_metadata] .filter (entry => entry [0] !== name);

      this ._metadata_changed = Date .now () / 1000;
   },
   getMetaData (name)
   {
      name = String (name);

      const values = this [_metadata]
         .filter (entry => entry [0] === name)
         .map (entry => entry [1]);

      if (values .length)
         return values;

      return undefined;
   },
   getMetaDatas ()
   {
      return this [_metadata] .map (entry => entry .slice ());
   },
   addExportedNode (exportedName, node)
   {
      exportedName = String (exportedName);

      if (this [_exportedNodes] .has (exportedName))
         throw new Error (`Couldn't add exported node: exported name '${exportedName}' already in use.`);

      this .updateExportedNode (exportedName, node);

      this ._sceneGraph_changed = Date .now () / 1000;
   },
   updateExportedNode (exportedName, node)
   {
      exportedName = String (exportedName);
      node         = (0,_Base_X3DCast_js__WEBPACK_IMPORTED_MODULE_9__/* ["default"] */ .A) (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_10__/* ["default"] */ .A .X3DNode, node, false);

      if (exportedName .length === 0)
         throw new Error ("Couldn't update exported node: node exported name is empty.");

      if (!node)
         throw new Error ("Couldn't update exported node: node must be of type X3DNode.");

      //if (node .getExecutionContext () !== this)
      //   throw new Error ("Couldn't update exported node: node does not belong to this execution context.");

      const exportedNode = new _X3DExportedNode_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A (this, exportedName, node);

      this [_exportedNodes] .update (exportedName, exportedName, exportedNode);

      this ._sceneGraph_changed = Date .now () / 1000;
   },
   removeExportedNode (exportedName)
   {
      exportedName = String (exportedName);

      this [_exportedNodes] .remove (exportedName);

      this ._sceneGraph_changed = Date .now () / 1000;
   },
   getExportedNode (exportedName)
   {
      exportedName = String (exportedName);

      const exportedNode = this [_exportedNodes] .get (exportedName);

      if (exportedNode)
         return exportedNode .localNode;

      throw new Error (`Exported node '${exportedName}' not found.`);
   },
   getExportedNodes ()
   {
      return this [_exportedNodes];
   },
   getUniqueExportName (name)
   {
      return (0,_NamedNodesHandling_js__WEBPACK_IMPORTED_MODULE_2__/* .getUniqueName */ .l) (this [_exportedNodes], name);
   },
   addRootNode (node)
   {
      node = _Fields_SFNodeCache_js__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A .get ((0,_Base_X3DCast_js__WEBPACK_IMPORTED_MODULE_9__/* ["default"] */ .A) (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_10__/* ["default"] */ .A .X3DNode, node, false));

      const rootNodes = this .getRootNodes ();

      if (rootNodes .includes (node))
         return;

      rootNodes .push (node);
   },
   removeRootNode (node)
   {
      node = _Fields_SFNodeCache_js__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A .get ((0,_Base_X3DCast_js__WEBPACK_IMPORTED_MODULE_9__/* ["default"] */ .A) (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_10__/* ["default"] */ .A .X3DNode, node, false));

      const rootNodes = this .getRootNodes ();

      rootNodes .assign (rootNodes .filter (rootNode => rootNode !== node));
   },
   setRootNodes (value)
   {
      this .getRootNodes () .assign (value);
   },
   toVRMLStream (generator)
   {
      generator .Indent ();
      generator .string += "#X3D V";
      generator .string += _LATEST_VERSION_js__WEBPACK_IMPORTED_MODULE_12__/* ["default"] */ .A;
      generator .Space ();
      generator .string += "utf8";
      generator .Space ();
      generator .string += this .getBrowser () .name;
      generator .Space ();
      generator .string += "V";
      generator .string += this .getBrowser () .version;
      generator .string += "\n";
      generator .string += "\n";

      const profile = this .getProfile ();

      if (profile)
      {
         profile .toVRMLStream (generator);

         generator .Break ();
         generator .TidyBreak ();
      }

      const components = this .getComponents ();

      if (components .length)
      {
         components .toVRMLStream (generator);

         generator .TidyBreak ();
      }

      const units = this .getUnits () .filter (unit => unit .conversionFactor !== 1);

      if (units .length)
      {
         for (const unit of units)
         {
            unit .toVRMLStream (generator);

            generator .Break ();
         }

         generator .TidyBreak ();
      }

      const metadata = this .getMetaDatas ();

      if (metadata .length)
      {
         for (const [key, value] of metadata)
         {
            generator .Indent ();
            generator .string += "META";
            generator .Space ();
            generator .string += new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFString (key) .toString ();
            generator .Space ();
            generator .string += new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFString (value) .toString ();
            generator .Break ();
         }

         generator .TidyBreak ();
      }

      const exportedNodes = this .getExportedNodes ();

      generator .PushExecutionContext (this);
      generator .ExportedNodes (exportedNodes);

      _X3DExecutionContext_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .prototype .toVRMLStream .call (this, generator);

      if (exportedNodes .length)
      {
         generator .TidyBreak ();

         exportedNodes .toVRMLStream (generator);
      }

      generator .PopExecutionContext ();
   },
   toXMLStream (generator)
   {
      if (!generator .html)
      {
         generator .Indent ();
         generator .string += "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
         generator .TidyBreak ();
         generator .Indent ();
         generator .string += "<!DOCTYPE X3D PUBLIC \"ISO//Web3D//DTD X3D ";
         generator .string += _LATEST_VERSION_js__WEBPACK_IMPORTED_MODULE_12__/* ["default"] */ .A;
         generator .string += "//EN\" \"https://www.web3d.org/specifications/x3d-";
         generator .string += _LATEST_VERSION_js__WEBPACK_IMPORTED_MODULE_12__/* ["default"] */ .A;
         generator .string += ".dtd\">";
         generator .TidyBreak ();
      }

      generator .openTag ("X3D");
      generator .attribute ("profile",   this .getProfile () ?.name ?? "Full");
      generator .attribute ("version",   _LATEST_VERSION_js__WEBPACK_IMPORTED_MODULE_12__/* ["default"] */ .A);
      generator .attribute ("xmlns:xsd", "http://www.w3.org/2001/XMLSchema-instance");
      generator .attribute ("xsd:noNamespaceSchemaLocation", `https://www.web3d.org/specifications/x3d-${_LATEST_VERSION_js__WEBPACK_IMPORTED_MODULE_12__/* ["default"] */ .A}.xsd`);

      generator .endTag ();
      generator .IncIndent ();

      const metadata = this .getMetaDatas ();

      if (this .getComponents () .length ||
          this .getUnits () .some (unit => unit .conversionFactor !== 1) ||
          metadata .length)
      {
         generator .openingTag ("head");
         generator .TidyBreak ();
         generator .IncIndent ();

         // <head>

         this .getComponents () .toXMLStream (generator);

         for (const unit of this .getUnits ())
         {
            if (unit .conversionFactor !== 1)
            {
               unit .toXMLStream (generator);
               generator .TidyBreak ();
            }
         }

         for (const [key, value] of metadata)
         {
            generator .openTag ("meta");
            generator .attribute ("name",    key);
            generator .attribute ("content", value);
            generator .closeTag ("meta");
            generator .TidyBreak ();
         }

         // </head>

         generator .DecIndent ();
         generator .closingTag ("head");
         generator .TidyBreak ();
      }

      if (this .getExternProtoDeclarations () .length ||
          this .getProtoDeclarations () .length ||
          this .getRootNodes () .length)
      {
         generator .openingTag ("Scene");
         generator .TidyBreak ();
         generator .IncIndent ();

         // <Scene>

         const exportedNodes = this .getExportedNodes ();

         generator .PushExecutionContext (this);
         generator .ExportedNodes (exportedNodes);

         _X3DExecutionContext_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .prototype .toXMLStream .call (this, generator);

         exportedNodes .toXMLStream (generator);

         generator .PopExecutionContext ();
         generator .DecIndent ();
         generator .closingTag ("Scene");
      }
      else
      {
         generator .openTag ("Scene");
         generator .closeTag ("Scene");
      }

      generator .TidyBreak ();
      generator .DecIndent ();
      generator .closingTag ("X3D");
      generator .TidyBreak ();
   },
   toJSONStream (generator)
   {
      // X3D

      generator .beginObject ("X3D", false, true);
      generator .stringProperty ("encoding", "UTF-8", false);
      generator .stringProperty ("@profile", this .getProfile () ?.name ?? "Full");
      generator .stringProperty ("@version", _LATEST_VERSION_js__WEBPACK_IMPORTED_MODULE_12__/* ["default"] */ .A);
      generator .stringProperty ("@xsd:noNamespaceSchemaLocation", `https://www.web3d.org/specifications/x3d-${_LATEST_VERSION_js__WEBPACK_IMPORTED_MODULE_12__/* ["default"] */ .A}.xsd`);
      generator .stringProperty ("JSON schema", `https://www.web3d.org/specifications/x3d-${_LATEST_VERSION_js__WEBPACK_IMPORTED_MODULE_12__/* ["default"] */ .A}-JSONSchema.json`);

      // Head

      const
         outputUnits = this .getUnits () .some (unit => unit .conversionFactor !== 1),
         metadata    = this .getMetaDatas ();

      if (this .getComponents () .length || outputUnits || metadata .length)
      {
         let headLastProperty = false;

         generator .beginObject ("head");

         // Meta data

         if (metadata .length)
         {
            // Meta data begin

            generator .beginArray ("meta", headLastProperty);

            // Meta data

            for (const [i, [key, value]] of metadata .entries ())
            {
               generator .beginObject ("", i !== 0);
               generator .stringProperty ("@name",    key, false);
               generator .stringProperty ("@content", value);
               generator .endObject ();
            }

            // Meta data end

            generator .endArray ();

            headLastProperty = true;
         }

         // Components

         if (this .getComponents () .length)
         {
            generator .beginArray ("component", headLastProperty);

            this .getComponents () .toJSONStream (generator);

            generator .endArray ();

            headLastProperty = true;
         }

         // Units

         if (outputUnits)
         {
            generator .beginArray ("unit", headLastProperty);

            this .getUnits () .toJSONStream (generator);

            generator .endArray ();

            headLastProperty = true;
         }

         // Head end

         generator .endObject ();
      }

      // Scene

      generator .beginObject ("Scene");
      generator .beginArray ("-children", false);

      const exportedNodes = this .getExportedNodes ();

      generator .PushExecutionContext (this);
      generator .ExportedNodes (exportedNodes);

      const comma = _X3DExecutionContext_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .prototype .toJSONStream .call (this, generator);

      // Exported nodes

      this .getExportedNodes () .toJSONStream (generator, comma);

      generator .PopExecutionContext ();

      // Scene end

      generator .endArray ();
      generator .endObject ();

      // X3D end

      generator .endObject ();
      generator .endObject ();
      generator .TidyBreak ();
   },
   dispose ()
   {
      this .exportedNodes .clear ();

      _X3DExecutionContext_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .prototype .dispose .call (this);
   },
},
{
   setExecutionContext (executionContext)
   {
      // Remove loading objects from old parent scene.
      {
         const scene = this .getScene ();

         if (scene)
         {
            for (const object of this [_loadingObjects])
               scene .removeLoadingObject (object);
         }
      }

      _X3DExecutionContext_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .prototype .setExecutionContext .call (this, executionContext);

      // Add loading objects to new parent scene.
      {
         const scene = this .getScene ();

         if (scene)
         {
            for (const object of this [_loadingObjects])
               scene .addLoadingObject (object);
         }
      }
   },
   getLoadingObjects ()
   {
      return this [_loadingObjects];
   },
   addLoadingObject (node)
   {
      this [_loadingObjects] .add (node);

      this ._loadCount = this [_loadingObjects] .size;

      const parent = this .getScene () ?? this .getBrowser ();

      parent .addLoadingObject (node);
   },
   removeLoadingObject (node)
   {
      this [_loadingObjects] .delete (node);

      this ._loadCount = this [_loadingObjects] .size;

      const parent = this .getScene () ?? this .getBrowser ();

      parent .removeLoadingObject (node);
   },
});

for (const key of Object .keys (X3DScene .prototype))
   Object .defineProperty (X3DScene .prototype, key, { enumerable: false });

Object .defineProperties (X3DScene .prototype,
{
   isScene:
   {
      value: true,
      enumerable: true,
   },
   specificationVersion:
   {
      get: X3DScene .prototype .getSpecificationVersion,
      enumerable: true,
   },
   encoding:
   {
      get: X3DScene .prototype .getEncoding,
      enumerable: true,
   },
   profile:
   {
      get: X3DScene .prototype .getProfile,
      enumerable: true,
   },
   profile_changed:
   {
      get () { return this ._profile_changed; },
      enumerable: false,
   },
   components:
   {
      get: X3DScene .prototype .getComponents,
      enumerable: true,
   },
   worldURL:
   {
      get: X3DScene .prototype .getWorldURL,
      enumerable: true,
   },
   baseURL:
   {
      get: X3DScene .prototype .getBaseURL,
      enumerable: true,
   },
   units:
   {
      get: X3DScene .prototype .getUnits,
      enumerable: true,
   },
   metadata_changed:
   {
      get () { return this ._metadata_changed; },
      enumerable: false,
   },
   rootNodes:
   {
      get: X3DScene .prototype .getRootNodes,
      set: X3DScene .prototype .setRootNodes,
      enumerable: true,
   },
   exportedNodes:
   {
      get: X3DScene .prototype .getExportedNodes,
      enumerable: true,
   },
   sceneGraph_changed:
   {
      get () { return this ._sceneGraph_changed; },
      enumerable: false,
   },
});

Object .defineProperties (X3DScene,
{
   typeName:
   {
      value: "X3DScene",
      enumerable: true,
   },
});

_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_10__/* ["default"] */ .A .addConstant (X3DScene .typeName);

const __default__ = X3DScene;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_13__/* ["default"] */ .A .add ("X3DScene", __default__));

/***/ }),

/***/ 1605:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Base_X3DInfoArray_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(4635);
/* harmony import */ var _X3DExternProtoDeclaration_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(5175);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(6707);



function ExternProtoDeclarationArray (values = [ ])
{
   return _Base_X3DInfoArray_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .call (this, Array .from (values, value => [value .name, value]), _X3DExternProtoDeclaration_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A);
}

Object .setPrototypeOf (ExternProtoDeclarationArray .prototype, _Base_X3DInfoArray_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .prototype);

for (const key of Object .keys (ExternProtoDeclarationArray .prototype))
   Object .defineProperty (ExternProtoDeclarationArray .prototype, key, { enumerable: false });

Object .defineProperties (ExternProtoDeclarationArray,
{
   typeName:
   {
      value: "ExternProtoDeclarationArray",
      enumerable: true,
   },
});

const __default__ = ExternProtoDeclarationArray;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .add ("ExternProtoDeclarationArray", __default__));

/***/ }),

/***/ 1678:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Base_X3DInfoArray_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(4635);
/* harmony import */ var _ComponentInfo_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(4503);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(6707);



function ComponentInfoArray (values = [ ])
{
   return _Base_X3DInfoArray_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .call (this, Array .from (values, value => [value .name, value]), _ComponentInfo_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A);
}

Object .assign (Object .setPrototypeOf (ComponentInfoArray .prototype, _Base_X3DInfoArray_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .prototype),
{
   add (name, { level, title, providerURL, external = false, dependencies = [ ] })
   {
      _Base_X3DInfoArray_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .prototype .add .call (this, name, new _ComponentInfo_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (name, level, title, providerURL, external, dependencies));
   },
});

for (const key of Object .keys (ComponentInfoArray .prototype))
   Object .defineProperty (ComponentInfoArray .prototype, key, { enumerable: false });

Object .defineProperties (ComponentInfoArray,
{
   typeName:
   {
      value: "ComponentInfoArray",
      enumerable: true,
   },
});

const __default__ = ComponentInfoArray;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .add ("ComponentInfoArray", __default__));

/***/ }),

/***/ 1698:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _x_ite_Namespace_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6707);
class MatrixStack extends Array
{
   #top = 0;

   constructor (Type)
   {
      super ();

      this .push (new Type ());
   }

   set (matrix)
   {
      this [this .#top] .assign (matrix);
   }

   get ()
   {
      return this [this .#top];
   }

   push (matrix = this [this .#top])
   {
      const top = ++ this .#top;

      if (top < this .length)
         this [top] .assign (matrix);
      else
         this [top] = matrix .copy ();
   }

   pop ()
   {
      -- this .#top;
   }

   clear ()
   {
      this .#top = 0;
   }

   size ()
   {
      return this .#top + 1;
   }

   identity ()
   {
      this [this .#top] .identity ();
   }

   inverse ()
   {
      this [this .#top] .inverse ();
   }

   multRight (matrix)
   {
      this [this .#top] .multRight (matrix);
   }

   multLeft (matrix)
   {
      this [this .#top] .multLeft (matrix);
   }

   translate (vector)
   {
      this [this .#top] .translate (vector);
   }

   rotate (rotation)
   {
      this [this .#top] .rotate (rotation);
   }

   scale (vector)
   {
      this [this .#top] .scale (vector);
   }
}

const __default__ = MatrixStack;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_x_ite_Namespace_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .add ("MatrixStack", __default__));

/***/ }),

/***/ 1769:
/***/ (function(__unused_webpack_module, exports) {


/*! pako 2.1.0 https://github.com/nodeca/pako @license (MIT AND Zlib) */
(function (global, factory) {
   true ? factory(exports) :
  0;
})(this, (function (exports) { 'use strict';

  // Note: adler32 takes 12% for level 0 and 2% for level 6.
  // It isn't worth it to make additional optimizations as in original.
  // Small size is preferable.

  // (C) 1995-2013 Jean-loup Gailly and Mark Adler
  // (C) 2014-2017 Vitaly Puzrin and Andrey Tupitsin
  //
  // This software is provided 'as-is', without any express or implied
  // warranty. In no event will the authors be held liable for any damages
  // arising from the use of this software.
  //
  // Permission is granted to anyone to use this software for any purpose,
  // including commercial applications, and to alter it and redistribute it
  // freely, subject to the following restrictions:
  //
  // 1. The origin of this software must not be misrepresented; you must not
  //   claim that you wrote the original software. If you use this software
  //   in a product, an acknowledgment in the product documentation would be
  //   appreciated but is not required.
  // 2. Altered source versions must be plainly marked as such, and must not be
  //   misrepresented as being the original software.
  // 3. This notice may not be removed or altered from any source distribution.

  const adler32 = (adler, buf, len, pos) => {
    let s1 = (adler & 0xffff) |0,
        s2 = ((adler >>> 16) & 0xffff) |0,
        n = 0;

    while (len !== 0) {
      // Set limit ~ twice less than 5552, to keep
      // s2 in 31-bits, because we force signed ints.
      // in other case %= will fail.
      n = len > 2000 ? 2000 : len;
      len -= n;

      do {
        s1 = (s1 + buf[pos++]) |0;
        s2 = (s2 + s1) |0;
      } while (--n);

      s1 %= 65521;
      s2 %= 65521;
    }

    return (s1 | (s2 << 16)) |0;
  };


  var adler32_1 = adler32;

  // Note: we can't get significant speed boost here.
  // So write code to minimize size - no pregenerated tables
  // and array tools dependencies.

  // (C) 1995-2013 Jean-loup Gailly and Mark Adler
  // (C) 2014-2017 Vitaly Puzrin and Andrey Tupitsin
  //
  // This software is provided 'as-is', without any express or implied
  // warranty. In no event will the authors be held liable for any damages
  // arising from the use of this software.
  //
  // Permission is granted to anyone to use this software for any purpose,
  // including commercial applications, and to alter it and redistribute it
  // freely, subject to the following restrictions:
  //
  // 1. The origin of this software must not be misrepresented; you must not
  //   claim that you wrote the original software. If you use this software
  //   in a product, an acknowledgment in the product documentation would be
  //   appreciated but is not required.
  // 2. Altered source versions must be plainly marked as such, and must not be
  //   misrepresented as being the original software.
  // 3. This notice may not be removed or altered from any source distribution.

  // Use ordinary array, since untyped makes no boost here
  const makeTable = () => {
    let c, table = [];

    for (var n = 0; n < 256; n++) {
      c = n;
      for (var k = 0; k < 8; k++) {
        c = ((c & 1) ? (0xEDB88320 ^ (c >>> 1)) : (c >>> 1));
      }
      table[n] = c;
    }

    return table;
  };

  // Create table on load. Just 255 signed longs. Not a problem.
  const crcTable = new Uint32Array(makeTable());


  const crc32 = (crc, buf, len, pos) => {
    const t = crcTable;
    const end = pos + len;

    crc ^= -1;

    for (let i = pos; i < end; i++) {
      crc = (crc >>> 8) ^ t[(crc ^ buf[i]) & 0xFF];
    }

    return (crc ^ (-1)); // >>> 0;
  };


  var crc32_1 = crc32;

  // (C) 1995-2013 Jean-loup Gailly and Mark Adler
  // (C) 2014-2017 Vitaly Puzrin and Andrey Tupitsin
  //
  // This software is provided 'as-is', without any express or implied
  // warranty. In no event will the authors be held liable for any damages
  // arising from the use of this software.
  //
  // Permission is granted to anyone to use this software for any purpose,
  // including commercial applications, and to alter it and redistribute it
  // freely, subject to the following restrictions:
  //
  // 1. The origin of this software must not be misrepresented; you must not
  //   claim that you wrote the original software. If you use this software
  //   in a product, an acknowledgment in the product documentation would be
  //   appreciated but is not required.
  // 2. Altered source versions must be plainly marked as such, and must not be
  //   misrepresented as being the original software.
  // 3. This notice may not be removed or altered from any source distribution.

  // See state defs from inflate.js
  const BAD$1 = 16209;       /* got a data error -- remain here until reset */
  const TYPE$1 = 16191;      /* i: waiting for type bits, including last-flag bit */

  /*
     Decode literal, length, and distance codes and write out the resulting
     literal and match bytes until either not enough input or output is
     available, an end-of-block is encountered, or a data error is encountered.
     When large enough input and output buffers are supplied to inflate(), for
     example, a 16K input buffer and a 64K output buffer, more than 95% of the
     inflate execution time is spent in this routine.

     Entry assumptions:

          state.mode === LEN
          strm.avail_in >= 6
          strm.avail_out >= 258
          start >= strm.avail_out
          state.bits < 8

     On return, state.mode is one of:

          LEN -- ran out of enough output space or enough available input
          TYPE -- reached end of block code, inflate() to interpret next block
          BAD -- error in block data

     Notes:

      - The maximum input bits used by a length/distance pair is 15 bits for the
        length code, 5 bits for the length extra, 15 bits for the distance code,
        and 13 bits for the distance extra.  This totals 48 bits, or six bytes.
        Therefore if strm.avail_in >= 6, then there is enough input to avoid
        checking for available input while decoding.

      - The maximum bytes that a single length/distance pair can output is 258
        bytes, which is the maximum length that can be coded.  inflate_fast()
        requires strm.avail_out >= 258 for each loop to avoid checking for
        output space.
   */
  var inffast = function inflate_fast(strm, start) {
    let _in;                    /* local strm.input */
    let last;                   /* have enough input while in < last */
    let _out;                   /* local strm.output */
    let beg;                    /* inflate()'s initial strm.output */
    let end;                    /* while out < end, enough space available */
  //#ifdef INFLATE_STRICT
    let dmax;                   /* maximum distance from zlib header */
  //#endif
    let wsize;                  /* window size or zero if not using window */
    let whave;                  /* valid bytes in the window */
    let wnext;                  /* window write index */
    // Use `s_window` instead `window`, avoid conflict with instrumentation tools
    let s_window;               /* allocated sliding window, if wsize != 0 */
    let hold;                   /* local strm.hold */
    let bits;                   /* local strm.bits */
    let lcode;                  /* local strm.lencode */
    let dcode;                  /* local strm.distcode */
    let lmask;                  /* mask for first level of length codes */
    let dmask;                  /* mask for first level of distance codes */
    let here;                   /* retrieved table entry */
    let op;                     /* code bits, operation, extra bits, or */
                                /*  window position, window bytes to copy */
    let len;                    /* match length, unused bytes */
    let dist;                   /* match distance */
    let from;                   /* where to copy match from */
    let from_source;


    let input, output; // JS specific, because we have no pointers

    /* copy state to local variables */
    const state = strm.state;
    //here = state.here;
    _in = strm.next_in;
    input = strm.input;
    last = _in + (strm.avail_in - 5);
    _out = strm.next_out;
    output = strm.output;
    beg = _out - (start - strm.avail_out);
    end = _out + (strm.avail_out - 257);
  //#ifdef INFLATE_STRICT
    dmax = state.dmax;
  //#endif
    wsize = state.wsize;
    whave = state.whave;
    wnext = state.wnext;
    s_window = state.window;
    hold = state.hold;
    bits = state.bits;
    lcode = state.lencode;
    dcode = state.distcode;
    lmask = (1 << state.lenbits) - 1;
    dmask = (1 << state.distbits) - 1;


    /* decode literals and length/distances until end-of-block or not enough
       input data or output space */

    top:
    do {
      if (bits < 15) {
        hold += input[_in++] << bits;
        bits += 8;
        hold += input[_in++] << bits;
        bits += 8;
      }

      here = lcode[hold & lmask];

      dolen:
      for (;;) { // Goto emulation
        op = here >>> 24/*here.bits*/;
        hold >>>= op;
        bits -= op;
        op = (here >>> 16) & 0xff/*here.op*/;
        if (op === 0) {                          /* literal */
          //Tracevv((stderr, here.val >= 0x20 && here.val < 0x7f ?
          //        "inflate:         literal '%c'\n" :
          //        "inflate:         literal 0x%02x\n", here.val));
          output[_out++] = here & 0xffff/*here.val*/;
        }
        else if (op & 16) {                     /* length base */
          len = here & 0xffff/*here.val*/;
          op &= 15;                           /* number of extra bits */
          if (op) {
            if (bits < op) {
              hold += input[_in++] << bits;
              bits += 8;
            }
            len += hold & ((1 << op) - 1);
            hold >>>= op;
            bits -= op;
          }
          //Tracevv((stderr, "inflate:         length %u\n", len));
          if (bits < 15) {
            hold += input[_in++] << bits;
            bits += 8;
            hold += input[_in++] << bits;
            bits += 8;
          }
          here = dcode[hold & dmask];

          dodist:
          for (;;) { // goto emulation
            op = here >>> 24/*here.bits*/;
            hold >>>= op;
            bits -= op;
            op = (here >>> 16) & 0xff/*here.op*/;

            if (op & 16) {                      /* distance base */
              dist = here & 0xffff/*here.val*/;
              op &= 15;                       /* number of extra bits */
              if (bits < op) {
                hold += input[_in++] << bits;
                bits += 8;
                if (bits < op) {
                  hold += input[_in++] << bits;
                  bits += 8;
                }
              }
              dist += hold & ((1 << op) - 1);
  //#ifdef INFLATE_STRICT
              if (dist > dmax) {
                strm.msg = 'invalid distance too far back';
                state.mode = BAD$1;
                break top;
              }
  //#endif
              hold >>>= op;
              bits -= op;
              //Tracevv((stderr, "inflate:         distance %u\n", dist));
              op = _out - beg;                /* max distance in output */
              if (dist > op) {                /* see if copy from window */
                op = dist - op;               /* distance back in window */
                if (op > whave) {
                  if (state.sane) {
                    strm.msg = 'invalid distance too far back';
                    state.mode = BAD$1;
                    break top;
                  }

  // (!) This block is disabled in zlib defaults,
  // don't enable it for binary compatibility
  //#ifdef INFLATE_ALLOW_INVALID_DISTANCE_TOOFAR_ARRR
  //                if (len <= op - whave) {
  //                  do {
  //                    output[_out++] = 0;
  //                  } while (--len);
  //                  continue top;
  //                }
  //                len -= op - whave;
  //                do {
  //                  output[_out++] = 0;
  //                } while (--op > whave);
  //                if (op === 0) {
  //                  from = _out - dist;
  //                  do {
  //                    output[_out++] = output[from++];
  //                  } while (--len);
  //                  continue top;
  //                }
  //#endif
                }
                from = 0; // window index
                from_source = s_window;
                if (wnext === 0) {           /* very common case */
                  from += wsize - op;
                  if (op < len) {         /* some from window */
                    len -= op;
                    do {
                      output[_out++] = s_window[from++];
                    } while (--op);
                    from = _out - dist;  /* rest from output */
                    from_source = output;
                  }
                }
                else if (wnext < op) {      /* wrap around window */
                  from += wsize + wnext - op;
                  op -= wnext;
                  if (op < len) {         /* some from end of window */
                    len -= op;
                    do {
                      output[_out++] = s_window[from++];
                    } while (--op);
                    from = 0;
                    if (wnext < len) {  /* some from start of window */
                      op = wnext;
                      len -= op;
                      do {
                        output[_out++] = s_window[from++];
                      } while (--op);
                      from = _out - dist;      /* rest from output */
                      from_source = output;
                    }
                  }
                }
                else {                      /* contiguous in window */
                  from += wnext - op;
                  if (op < len) {         /* some from window */
                    len -= op;
                    do {
                      output[_out++] = s_window[from++];
                    } while (--op);
                    from = _out - dist;  /* rest from output */
                    from_source = output;
                  }
                }
                while (len > 2) {
                  output[_out++] = from_source[from++];
                  output[_out++] = from_source[from++];
                  output[_out++] = from_source[from++];
                  len -= 3;
                }
                if (len) {
                  output[_out++] = from_source[from++];
                  if (len > 1) {
                    output[_out++] = from_source[from++];
                  }
                }
              }
              else {
                from = _out - dist;          /* copy direct from output */
                do {                        /* minimum length is three */
                  output[_out++] = output[from++];
                  output[_out++] = output[from++];
                  output[_out++] = output[from++];
                  len -= 3;
                } while (len > 2);
                if (len) {
                  output[_out++] = output[from++];
                  if (len > 1) {
                    output[_out++] = output[from++];
                  }
                }
              }
            }
            else if ((op & 64) === 0) {          /* 2nd level distance code */
              here = dcode[(here & 0xffff)/*here.val*/ + (hold & ((1 << op) - 1))];
              continue dodist;
            }
            else {
              strm.msg = 'invalid distance code';
              state.mode = BAD$1;
              break top;
            }

            break; // need to emulate goto via "continue"
          }
        }
        else if ((op & 64) === 0) {              /* 2nd level length code */
          here = lcode[(here & 0xffff)/*here.val*/ + (hold & ((1 << op) - 1))];
          continue dolen;
        }
        else if (op & 32) {                     /* end-of-block */
          //Tracevv((stderr, "inflate:         end of block\n"));
          state.mode = TYPE$1;
          break top;
        }
        else {
          strm.msg = 'invalid literal/length code';
          state.mode = BAD$1;
          break top;
        }

        break; // need to emulate goto via "continue"
      }
    } while (_in < last && _out < end);

    /* return unused bytes (on entry, bits < 8, so in won't go too far back) */
    len = bits >> 3;
    _in -= len;
    bits -= len << 3;
    hold &= (1 << bits) - 1;

    /* update state and return */
    strm.next_in = _in;
    strm.next_out = _out;
    strm.avail_in = (_in < last ? 5 + (last - _in) : 5 - (_in - last));
    strm.avail_out = (_out < end ? 257 + (end - _out) : 257 - (_out - end));
    state.hold = hold;
    state.bits = bits;
    return;
  };

  // (C) 1995-2013 Jean-loup Gailly and Mark Adler
  // (C) 2014-2017 Vitaly Puzrin and Andrey Tupitsin
  //
  // This software is provided 'as-is', without any express or implied
  // warranty. In no event will the authors be held liable for any damages
  // arising from the use of this software.
  //
  // Permission is granted to anyone to use this software for any purpose,
  // including commercial applications, and to alter it and redistribute it
  // freely, subject to the following restrictions:
  //
  // 1. The origin of this software must not be misrepresented; you must not
  //   claim that you wrote the original software. If you use this software
  //   in a product, an acknowledgment in the product documentation would be
  //   appreciated but is not required.
  // 2. Altered source versions must be plainly marked as such, and must not be
  //   misrepresented as being the original software.
  // 3. This notice may not be removed or altered from any source distribution.

  const MAXBITS = 15;
  const ENOUGH_LENS$1 = 852;
  const ENOUGH_DISTS$1 = 592;
  //const ENOUGH = (ENOUGH_LENS+ENOUGH_DISTS);

  const CODES$1 = 0;
  const LENS$1 = 1;
  const DISTS$1 = 2;

  const lbase = new Uint16Array([ /* Length codes 257..285 base */
    3, 4, 5, 6, 7, 8, 9, 10, 11, 13, 15, 17, 19, 23, 27, 31,
    35, 43, 51, 59, 67, 83, 99, 115, 131, 163, 195, 227, 258, 0, 0
  ]);

  const lext = new Uint8Array([ /* Length codes 257..285 extra */
    16, 16, 16, 16, 16, 16, 16, 16, 17, 17, 17, 17, 18, 18, 18, 18,
    19, 19, 19, 19, 20, 20, 20, 20, 21, 21, 21, 21, 16, 72, 78
  ]);

  const dbase = new Uint16Array([ /* Distance codes 0..29 base */
    1, 2, 3, 4, 5, 7, 9, 13, 17, 25, 33, 49, 65, 97, 129, 193,
    257, 385, 513, 769, 1025, 1537, 2049, 3073, 4097, 6145,
    8193, 12289, 16385, 24577, 0, 0
  ]);

  const dext = new Uint8Array([ /* Distance codes 0..29 extra */
    16, 16, 16, 16, 17, 17, 18, 18, 19, 19, 20, 20, 21, 21, 22, 22,
    23, 23, 24, 24, 25, 25, 26, 26, 27, 27,
    28, 28, 29, 29, 64, 64
  ]);

  const inflate_table = (type, lens, lens_index, codes, table, table_index, work, opts) =>
  {
    const bits = opts.bits;
        //here = opts.here; /* table entry for duplication */

    let len = 0;               /* a code's length in bits */
    let sym = 0;               /* index of code symbols */
    let min = 0, max = 0;          /* minimum and maximum code lengths */
    let root = 0;              /* number of index bits for root table */
    let curr = 0;              /* number of index bits for current table */
    let drop = 0;              /* code bits to drop for sub-table */
    let left = 0;                   /* number of prefix codes available */
    let used = 0;              /* code entries in table used */
    let huff = 0;              /* Huffman code */
    let incr;              /* for incrementing code, index */
    let fill;              /* index for replicating entries */
    let low;               /* low bits for current root entry */
    let mask;              /* mask for low root bits */
    let next;             /* next available space in table */
    let base = null;     /* base value table to use */
  //  let shoextra;    /* extra bits table to use */
    let match;                  /* use base and extra for symbol >= match */
    const count = new Uint16Array(MAXBITS + 1); //[MAXBITS+1];    /* number of codes of each length */
    const offs = new Uint16Array(MAXBITS + 1); //[MAXBITS+1];     /* offsets in table for each length */
    let extra = null;

    let here_bits, here_op, here_val;

    /*
     Process a set of code lengths to create a canonical Huffman code.  The
     code lengths are lens[0..codes-1].  Each length corresponds to the
     symbols 0..codes-1.  The Huffman code is generated by first sorting the
     symbols by length from short to long, and retaining the symbol order
     for codes with equal lengths.  Then the code starts with all zero bits
     for the first code of the shortest length, and the codes are integer
     increments for the same length, and zeros are appended as the length
     increases.  For the deflate format, these bits are stored backwards
     from their more natural integer increment ordering, and so when the
     decoding tables are built in the large loop below, the integer codes
     are incremented backwards.

     This routine assumes, but does not check, that all of the entries in
     lens[] are in the range 0..MAXBITS.  The caller must assure this.
     1..MAXBITS is interpreted as that code length.  zero means that that
     symbol does not occur in this code.

     The codes are sorted by computing a count of codes for each length,
     creating from that a table of starting indices for each length in the
     sorted table, and then entering the symbols in order in the sorted
     table.  The sorted table is work[], with that space being provided by
     the caller.

     The length counts are used for other purposes as well, i.e. finding
     the minimum and maximum length codes, determining if there are any
     codes at all, checking for a valid set of lengths, and looking ahead
     at length counts to determine sub-table sizes when building the
     decoding tables.
     */

    /* accumulate lengths for codes (assumes lens[] all in 0..MAXBITS) */
    for (len = 0; len <= MAXBITS; len++) {
      count[len] = 0;
    }
    for (sym = 0; sym < codes; sym++) {
      count[lens[lens_index + sym]]++;
    }

    /* bound code lengths, force root to be within code lengths */
    root = bits;
    for (max = MAXBITS; max >= 1; max--) {
      if (count[max] !== 0) { break; }
    }
    if (root > max) {
      root = max;
    }
    if (max === 0) {                     /* no symbols to code at all */
      //table.op[opts.table_index] = 64;  //here.op = (var char)64;    /* invalid code marker */
      //table.bits[opts.table_index] = 1;   //here.bits = (var char)1;
      //table.val[opts.table_index++] = 0;   //here.val = (var short)0;
      table[table_index++] = (1 << 24) | (64 << 16) | 0;


      //table.op[opts.table_index] = 64;
      //table.bits[opts.table_index] = 1;
      //table.val[opts.table_index++] = 0;
      table[table_index++] = (1 << 24) | (64 << 16) | 0;

      opts.bits = 1;
      return 0;     /* no symbols, but wait for decoding to report error */
    }
    for (min = 1; min < max; min++) {
      if (count[min] !== 0) { break; }
    }
    if (root < min) {
      root = min;
    }

    /* check for an over-subscribed or incomplete set of lengths */
    left = 1;
    for (len = 1; len <= MAXBITS; len++) {
      left <<= 1;
      left -= count[len];
      if (left < 0) {
        return -1;
      }        /* over-subscribed */
    }
    if (left > 0 && (type === CODES$1 || max !== 1)) {
      return -1;                      /* incomplete set */
    }

    /* generate offsets into symbol table for each length for sorting */
    offs[1] = 0;
    for (len = 1; len < MAXBITS; len++) {
      offs[len + 1] = offs[len] + count[len];
    }

    /* sort symbols by length, by symbol order within each length */
    for (sym = 0; sym < codes; sym++) {
      if (lens[lens_index + sym] !== 0) {
        work[offs[lens[lens_index + sym]]++] = sym;
      }
    }

    /*
     Create and fill in decoding tables.  In this loop, the table being
     filled is at next and has curr index bits.  The code being used is huff
     with length len.  That code is converted to an index by dropping drop
     bits off of the bottom.  For codes where len is less than drop + curr,
     those top drop + curr - len bits are incremented through all values to
     fill the table with replicated entries.

     root is the number of index bits for the root table.  When len exceeds
     root, sub-tables are created pointed to by the root entry with an index
     of the low root bits of huff.  This is saved in low to check for when a
     new sub-table should be started.  drop is zero when the root table is
     being filled, and drop is root when sub-tables are being filled.

     When a new sub-table is needed, it is necessary to look ahead in the
     code lengths to determine what size sub-table is needed.  The length
     counts are used for this, and so count[] is decremented as codes are
     entered in the tables.

     used keeps track of how many table entries have been allocated from the
     provided *table space.  It is checked for LENS and DIST tables against
     the constants ENOUGH_LENS and ENOUGH_DISTS to guard against changes in
     the initial root table size constants.  See the comments in inftrees.h
     for more information.

     sym increments through all symbols, and the loop terminates when
     all codes of length max, i.e. all codes, have been processed.  This
     routine permits incomplete codes, so another loop after this one fills
     in the rest of the decoding tables with invalid code markers.
     */

    /* set up for code type */
    // poor man optimization - use if-else instead of switch,
    // to avoid deopts in old v8
    if (type === CODES$1) {
      base = extra = work;    /* dummy value--not used */
      match = 20;

    } else if (type === LENS$1) {
      base = lbase;
      extra = lext;
      match = 257;

    } else {                    /* DISTS */
      base = dbase;
      extra = dext;
      match = 0;
    }

    /* initialize opts for loop */
    huff = 0;                   /* starting code */
    sym = 0;                    /* starting code symbol */
    len = min;                  /* starting code length */
    next = table_index;              /* current table to fill in */
    curr = root;                /* current table index bits */
    drop = 0;                   /* current bits to drop from code for index */
    low = -1;                   /* trigger new sub-table when len > root */
    used = 1 << root;          /* use root table entries */
    mask = used - 1;            /* mask for comparing low */

    /* check available table space */
    if ((type === LENS$1 && used > ENOUGH_LENS$1) ||
      (type === DISTS$1 && used > ENOUGH_DISTS$1)) {
      return 1;
    }

    /* process all codes and make table entries */
    for (;;) {
      /* create table entry */
      here_bits = len - drop;
      if (work[sym] + 1 < match) {
        here_op = 0;
        here_val = work[sym];
      }
      else if (work[sym] >= match) {
        here_op = extra[work[sym] - match];
        here_val = base[work[sym] - match];
      }
      else {
        here_op = 32 + 64;         /* end of block */
        here_val = 0;
      }

      /* replicate for those indices with low len bits equal to huff */
      incr = 1 << (len - drop);
      fill = 1 << curr;
      min = fill;                 /* save offset to next table */
      do {
        fill -= incr;
        table[next + (huff >> drop) + fill] = (here_bits << 24) | (here_op << 16) | here_val |0;
      } while (fill !== 0);

      /* backwards increment the len-bit code huff */
      incr = 1 << (len - 1);
      while (huff & incr) {
        incr >>= 1;
      }
      if (incr !== 0) {
        huff &= incr - 1;
        huff += incr;
      } else {
        huff = 0;
      }

      /* go to next symbol, update count, len */
      sym++;
      if (--count[len] === 0) {
        if (len === max) { break; }
        len = lens[lens_index + work[sym]];
      }

      /* create new sub-table if needed */
      if (len > root && (huff & mask) !== low) {
        /* if first time, transition to sub-tables */
        if (drop === 0) {
          drop = root;
        }

        /* increment past last table */
        next += min;            /* here min is 1 << curr */

        /* determine length of next table */
        curr = len - drop;
        left = 1 << curr;
        while (curr + drop < max) {
          left -= count[curr + drop];
          if (left <= 0) { break; }
          curr++;
          left <<= 1;
        }

        /* check for enough space */
        used += 1 << curr;
        if ((type === LENS$1 && used > ENOUGH_LENS$1) ||
          (type === DISTS$1 && used > ENOUGH_DISTS$1)) {
          return 1;
        }

        /* point entry in root table to sub-table */
        low = huff & mask;
        /*table.op[low] = curr;
        table.bits[low] = root;
        table.val[low] = next - opts.table_index;*/
        table[low] = (root << 24) | (curr << 16) | (next - table_index) |0;
      }
    }

    /* fill in remaining table entry if code is incomplete (guaranteed to have
     at most one remaining entry, since if the code is incomplete, the
     maximum code length that was allowed to get this far is one bit) */
    if (huff !== 0) {
      //table.op[next + huff] = 64;            /* invalid code marker */
      //table.bits[next + huff] = len - drop;
      //table.val[next + huff] = 0;
      table[next + huff] = ((len - drop) << 24) | (64 << 16) |0;
    }

    /* set return parameters */
    //opts.table_index += used;
    opts.bits = root;
    return 0;
  };


  var inftrees = inflate_table;

  // (C) 1995-2013 Jean-loup Gailly and Mark Adler
  // (C) 2014-2017 Vitaly Puzrin and Andrey Tupitsin
  //
  // This software is provided 'as-is', without any express or implied
  // warranty. In no event will the authors be held liable for any damages
  // arising from the use of this software.
  //
  // Permission is granted to anyone to use this software for any purpose,
  // including commercial applications, and to alter it and redistribute it
  // freely, subject to the following restrictions:
  //
  // 1. The origin of this software must not be misrepresented; you must not
  //   claim that you wrote the original software. If you use this software
  //   in a product, an acknowledgment in the product documentation would be
  //   appreciated but is not required.
  // 2. Altered source versions must be plainly marked as such, and must not be
  //   misrepresented as being the original software.
  // 3. This notice may not be removed or altered from any source distribution.

  var constants$1 = {

    /* Allowed flush values; see deflate() and inflate() below for details */
    Z_NO_FLUSH:         0,
    Z_PARTIAL_FLUSH:    1,
    Z_SYNC_FLUSH:       2,
    Z_FULL_FLUSH:       3,
    Z_FINISH:           4,
    Z_BLOCK:            5,
    Z_TREES:            6,

    /* Return codes for the compression/decompression functions. Negative values
    * are errors, positive values are used for special but normal events.
    */
    Z_OK:               0,
    Z_STREAM_END:       1,
    Z_NEED_DICT:        2,
    Z_ERRNO:           -1,
    Z_STREAM_ERROR:    -2,
    Z_DATA_ERROR:      -3,
    Z_MEM_ERROR:       -4,
    Z_BUF_ERROR:       -5,
    //Z_VERSION_ERROR: -6,

    /* compression levels */
    Z_NO_COMPRESSION:         0,
    Z_BEST_SPEED:             1,
    Z_BEST_COMPRESSION:       9,
    Z_DEFAULT_COMPRESSION:   -1,


    Z_FILTERED:               1,
    Z_HUFFMAN_ONLY:           2,
    Z_RLE:                    3,
    Z_FIXED:                  4,
    Z_DEFAULT_STRATEGY:       0,

    /* Possible values of the data_type field (though see inflate()) */
    Z_BINARY:                 0,
    Z_TEXT:                   1,
    //Z_ASCII:                1, // = Z_TEXT (deprecated)
    Z_UNKNOWN:                2,

    /* The deflate compression method */
    Z_DEFLATED:               8
    //Z_NULL:                 null // Use -1 or null inline, depending on var type
  };

  // (C) 1995-2013 Jean-loup Gailly and Mark Adler
  // (C) 2014-2017 Vitaly Puzrin and Andrey Tupitsin
  //
  // This software is provided 'as-is', without any express or implied
  // warranty. In no event will the authors be held liable for any damages
  // arising from the use of this software.
  //
  // Permission is granted to anyone to use this software for any purpose,
  // including commercial applications, and to alter it and redistribute it
  // freely, subject to the following restrictions:
  //
  // 1. The origin of this software must not be misrepresented; you must not
  //   claim that you wrote the original software. If you use this software
  //   in a product, an acknowledgment in the product documentation would be
  //   appreciated but is not required.
  // 2. Altered source versions must be plainly marked as such, and must not be
  //   misrepresented as being the original software.
  // 3. This notice may not be removed or altered from any source distribution.






  const CODES = 0;
  const LENS = 1;
  const DISTS = 2;

  /* Public constants ==========================================================*/
  /* ===========================================================================*/

  const {
    Z_FINISH: Z_FINISH$1, Z_BLOCK, Z_TREES,
    Z_OK: Z_OK$1, Z_STREAM_END: Z_STREAM_END$1, Z_NEED_DICT: Z_NEED_DICT$1, Z_STREAM_ERROR: Z_STREAM_ERROR$1, Z_DATA_ERROR: Z_DATA_ERROR$1, Z_MEM_ERROR: Z_MEM_ERROR$1, Z_BUF_ERROR,
    Z_DEFLATED
  } = constants$1;


  /* STATES ====================================================================*/
  /* ===========================================================================*/


  const    HEAD = 16180;       /* i: waiting for magic header */
  const    FLAGS = 16181;      /* i: waiting for method and flags (gzip) */
  const    TIME = 16182;       /* i: waiting for modification time (gzip) */
  const    OS = 16183;         /* i: waiting for extra flags and operating system (gzip) */
  const    EXLEN = 16184;      /* i: waiting for extra length (gzip) */
  const    EXTRA = 16185;      /* i: waiting for extra bytes (gzip) */
  const    NAME = 16186;       /* i: waiting for end of file name (gzip) */
  const    COMMENT = 16187;    /* i: waiting for end of comment (gzip) */
  const    HCRC = 16188;       /* i: waiting for header crc (gzip) */
  const    DICTID = 16189;    /* i: waiting for dictionary check value */
  const    DICT = 16190;      /* waiting for inflateSetDictionary() call */
  const        TYPE = 16191;      /* i: waiting for type bits, including last-flag bit */
  const        TYPEDO = 16192;    /* i: same, but skip check to exit inflate on new block */
  const        STORED = 16193;    /* i: waiting for stored size (length and complement) */
  const        COPY_ = 16194;     /* i/o: same as COPY below, but only first time in */
  const        COPY = 16195;      /* i/o: waiting for input or output to copy stored block */
  const        TABLE = 16196;     /* i: waiting for dynamic block table lengths */
  const        LENLENS = 16197;   /* i: waiting for code length code lengths */
  const        CODELENS = 16198;  /* i: waiting for length/lit and distance code lengths */
  const            LEN_ = 16199;      /* i: same as LEN below, but only first time in */
  const            LEN = 16200;       /* i: waiting for length/lit/eob code */
  const            LENEXT = 16201;    /* i: waiting for length extra bits */
  const            DIST = 16202;      /* i: waiting for distance code */
  const            DISTEXT = 16203;   /* i: waiting for distance extra bits */
  const            MATCH = 16204;     /* o: waiting for output space to copy string */
  const            LIT = 16205;       /* o: waiting for output space to write literal */
  const    CHECK = 16206;     /* i: waiting for 32-bit check value */
  const    LENGTH = 16207;    /* i: waiting for 32-bit length (gzip) */
  const    DONE = 16208;      /* finished check, done -- remain here until reset */
  const    BAD = 16209;       /* got a data error -- remain here until reset */
  const    MEM = 16210;       /* got an inflate() memory error -- remain here until reset */
  const    SYNC = 16211;      /* looking for synchronization bytes to restart inflate() */

  /* ===========================================================================*/



  const ENOUGH_LENS = 852;
  const ENOUGH_DISTS = 592;
  //const ENOUGH =  (ENOUGH_LENS+ENOUGH_DISTS);

  const MAX_WBITS = 15;
  /* 32K LZ77 window */
  const DEF_WBITS = MAX_WBITS;


  const zswap32 = (q) => {

    return  (((q >>> 24) & 0xff) +
            ((q >>> 8) & 0xff00) +
            ((q & 0xff00) << 8) +
            ((q & 0xff) << 24));
  };


  function InflateState() {
    this.strm = null;           /* pointer back to this zlib stream */
    this.mode = 0;              /* current inflate mode */
    this.last = false;          /* true if processing last block */
    this.wrap = 0;              /* bit 0 true for zlib, bit 1 true for gzip,
                                   bit 2 true to validate check value */
    this.havedict = false;      /* true if dictionary provided */
    this.flags = 0;             /* gzip header method and flags (0 if zlib), or
                                   -1 if raw or no header yet */
    this.dmax = 0;              /* zlib header max distance (INFLATE_STRICT) */
    this.check = 0;             /* protected copy of check value */
    this.total = 0;             /* protected copy of output count */
    // TODO: may be {}
    this.head = null;           /* where to save gzip header information */

    /* sliding window */
    this.wbits = 0;             /* log base 2 of requested window size */
    this.wsize = 0;             /* window size or zero if not using window */
    this.whave = 0;             /* valid bytes in the window */
    this.wnext = 0;             /* window write index */
    this.window = null;         /* allocated sliding window, if needed */

    /* bit accumulator */
    this.hold = 0;              /* input bit accumulator */
    this.bits = 0;              /* number of bits in "in" */

    /* for string and stored block copying */
    this.length = 0;            /* literal or length of data to copy */
    this.offset = 0;            /* distance back to copy string from */

    /* for table and code decoding */
    this.extra = 0;             /* extra bits needed */

    /* fixed and dynamic code tables */
    this.lencode = null;          /* starting table for length/literal codes */
    this.distcode = null;         /* starting table for distance codes */
    this.lenbits = 0;           /* index bits for lencode */
    this.distbits = 0;          /* index bits for distcode */

    /* dynamic table building */
    this.ncode = 0;             /* number of code length code lengths */
    this.nlen = 0;              /* number of length code lengths */
    this.ndist = 0;             /* number of distance code lengths */
    this.have = 0;              /* number of code lengths in lens[] */
    this.next = null;              /* next available space in codes[] */

    this.lens = new Uint16Array(320); /* temporary storage for code lengths */
    this.work = new Uint16Array(288); /* work area for code table building */

    /*
     because we don't have pointers in js, we use lencode and distcode directly
     as buffers so we don't need codes
    */
    //this.codes = new Int32Array(ENOUGH);       /* space for code tables */
    this.lendyn = null;              /* dynamic table for length/literal codes (JS specific) */
    this.distdyn = null;             /* dynamic table for distance codes (JS specific) */
    this.sane = 0;                   /* if false, allow invalid distance too far */
    this.back = 0;                   /* bits back of last unprocessed length/lit */
    this.was = 0;                    /* initial length of match */
  }


  const inflateStateCheck = (strm) => {

    if (!strm) {
      return 1;
    }
    const state = strm.state;
    if (!state || state.strm !== strm ||
      state.mode < HEAD || state.mode > SYNC) {
      return 1;
    }
    return 0;
  };


  const inflateResetKeep = (strm) => {

    if (inflateStateCheck(strm)) { return Z_STREAM_ERROR$1; }
    const state = strm.state;
    strm.total_in = strm.total_out = state.total = 0;
    strm.msg = ''; /*Z_NULL*/
    if (state.wrap) {       /* to support ill-conceived Java test suite */
      strm.adler = state.wrap & 1;
    }
    state.mode = HEAD;
    state.last = 0;
    state.havedict = 0;
    state.flags = -1;
    state.dmax = 32768;
    state.head = null/*Z_NULL*/;
    state.hold = 0;
    state.bits = 0;
    //state.lencode = state.distcode = state.next = state.codes;
    state.lencode = state.lendyn = new Int32Array(ENOUGH_LENS);
    state.distcode = state.distdyn = new Int32Array(ENOUGH_DISTS);

    state.sane = 1;
    state.back = -1;
    //Tracev((stderr, "inflate: reset\n"));
    return Z_OK$1;
  };


  const inflateReset = (strm) => {

    if (inflateStateCheck(strm)) { return Z_STREAM_ERROR$1; }
    const state = strm.state;
    state.wsize = 0;
    state.whave = 0;
    state.wnext = 0;
    return inflateResetKeep(strm);

  };


  const inflateReset2 = (strm, windowBits) => {
    let wrap;

    /* get the state */
    if (inflateStateCheck(strm)) { return Z_STREAM_ERROR$1; }
    const state = strm.state;

    /* extract wrap request from windowBits parameter */
    if (windowBits < 0) {
      wrap = 0;
      windowBits = -windowBits;
    }
    else {
      wrap = (windowBits >> 4) + 5;
      if (windowBits < 48) {
        windowBits &= 15;
      }
    }

    /* set number of window bits, free window if different */
    if (windowBits && (windowBits < 8 || windowBits > 15)) {
      return Z_STREAM_ERROR$1;
    }
    if (state.window !== null && state.wbits !== windowBits) {
      state.window = null;
    }

    /* update state and reset the rest of it */
    state.wrap = wrap;
    state.wbits = windowBits;
    return inflateReset(strm);
  };


  const inflateInit2 = (strm, windowBits) => {

    if (!strm) { return Z_STREAM_ERROR$1; }
    //strm.msg = Z_NULL;                 /* in case we return an error */

    const state = new InflateState();

    //if (state === Z_NULL) return Z_MEM_ERROR;
    //Tracev((stderr, "inflate: allocated\n"));
    strm.state = state;
    state.strm = strm;
    state.window = null/*Z_NULL*/;
    state.mode = HEAD;     /* to pass state test in inflateReset2() */
    const ret = inflateReset2(strm, windowBits);
    if (ret !== Z_OK$1) {
      strm.state = null/*Z_NULL*/;
    }
    return ret;
  };


  const inflateInit = (strm) => {

    return inflateInit2(strm, DEF_WBITS);
  };


  /*
   Return state with length and distance decoding tables and index sizes set to
   fixed code decoding.  Normally this returns fixed tables from inffixed.h.
   If BUILDFIXED is defined, then instead this routine builds the tables the
   first time it's called, and returns those tables the first time and
   thereafter.  This reduces the size of the code by about 2K bytes, in
   exchange for a little execution time.  However, BUILDFIXED should not be
   used for threaded applications, since the rewriting of the tables and virgin
   may not be thread-safe.
   */
  let virgin = true;

  let lenfix, distfix; // We have no pointers in JS, so keep tables separate


  const fixedtables = (state) => {

    /* build fixed huffman tables if first call (may not be thread safe) */
    if (virgin) {
      lenfix = new Int32Array(512);
      distfix = new Int32Array(32);

      /* literal/length table */
      let sym = 0;
      while (sym < 144) { state.lens[sym++] = 8; }
      while (sym < 256) { state.lens[sym++] = 9; }
      while (sym < 280) { state.lens[sym++] = 7; }
      while (sym < 288) { state.lens[sym++] = 8; }

      inftrees(LENS,  state.lens, 0, 288, lenfix,   0, state.work, { bits: 9 });

      /* distance table */
      sym = 0;
      while (sym < 32) { state.lens[sym++] = 5; }

      inftrees(DISTS, state.lens, 0, 32,   distfix, 0, state.work, { bits: 5 });

      /* do this just once */
      virgin = false;
    }

    state.lencode = lenfix;
    state.lenbits = 9;
    state.distcode = distfix;
    state.distbits = 5;
  };


  /*
   Update the window with the last wsize (normally 32K) bytes written before
   returning.  If window does not exist yet, create it.  This is only called
   when a window is already in use, or when output has been written during this
   inflate call, but the end of the deflate stream has not been reached yet.
   It is also called to create a window for dictionary data when a dictionary
   is loaded.

   Providing output buffers larger than 32K to inflate() should provide a speed
   advantage, since only the last 32K of output is copied to the sliding window
   upon return from inflate(), and since all distances after the first 32K of
   output will fall in the output data, making match copies simpler and faster.
   The advantage may be dependent on the size of the processor's data caches.
   */
  const updatewindow = (strm, src, end, copy) => {

    let dist;
    const state = strm.state;

    /* if it hasn't been done already, allocate space for the window */
    if (state.window === null) {
      state.wsize = 1 << state.wbits;
      state.wnext = 0;
      state.whave = 0;

      state.window = new Uint8Array(state.wsize);
    }

    /* copy state->wsize or less output bytes into the circular window */
    if (copy >= state.wsize) {
      state.window.set(src.subarray(end - state.wsize, end), 0);
      state.wnext = 0;
      state.whave = state.wsize;
    }
    else {
      dist = state.wsize - state.wnext;
      if (dist > copy) {
        dist = copy;
      }
      //zmemcpy(state->window + state->wnext, end - copy, dist);
      state.window.set(src.subarray(end - copy, end - copy + dist), state.wnext);
      copy -= dist;
      if (copy) {
        //zmemcpy(state->window, end - copy, copy);
        state.window.set(src.subarray(end - copy, end), 0);
        state.wnext = copy;
        state.whave = state.wsize;
      }
      else {
        state.wnext += dist;
        if (state.wnext === state.wsize) { state.wnext = 0; }
        if (state.whave < state.wsize) { state.whave += dist; }
      }
    }
    return 0;
  };


  const inflate$1 = (strm, flush) => {

    let state;
    let input, output;          // input/output buffers
    let next;                   /* next input INDEX */
    let put;                    /* next output INDEX */
    let have, left;             /* available input and output */
    let hold;                   /* bit buffer */
    let bits;                   /* bits in bit buffer */
    let _in, _out;              /* save starting available input and output */
    let copy;                   /* number of stored or match bytes to copy */
    let from;                   /* where to copy match bytes from */
    let from_source;
    let here = 0;               /* current decoding table entry */
    let here_bits, here_op, here_val; // paked "here" denormalized (JS specific)
    //let last;                   /* parent table entry */
    let last_bits, last_op, last_val; // paked "last" denormalized (JS specific)
    let len;                    /* length to copy for repeats, bits to drop */
    let ret;                    /* return code */
    const hbuf = new Uint8Array(4);    /* buffer for gzip header crc calculation */
    let opts;

    let n; // temporary variable for NEED_BITS

    const order = /* permutation of code lengths */
      new Uint8Array([ 16, 17, 18, 0, 8, 7, 9, 6, 10, 5, 11, 4, 12, 3, 13, 2, 14, 1, 15 ]);


    if (inflateStateCheck(strm) || !strm.output ||
        (!strm.input && strm.avail_in !== 0)) {
      return Z_STREAM_ERROR$1;
    }

    state = strm.state;
    if (state.mode === TYPE) { state.mode = TYPEDO; }    /* skip check */


    //--- LOAD() ---
    put = strm.next_out;
    output = strm.output;
    left = strm.avail_out;
    next = strm.next_in;
    input = strm.input;
    have = strm.avail_in;
    hold = state.hold;
    bits = state.bits;
    //---

    _in = have;
    _out = left;
    ret = Z_OK$1;

    inf_leave: // goto emulation
    for (;;) {
      switch (state.mode) {
        case HEAD:
          if (state.wrap === 0) {
            state.mode = TYPEDO;
            break;
          }
          //=== NEEDBITS(16);
          while (bits < 16) {
            if (have === 0) { break inf_leave; }
            have--;
            hold += input[next++] << bits;
            bits += 8;
          }
          //===//
          if ((state.wrap & 2) && hold === 0x8b1f) {  /* gzip header */
            if (state.wbits === 0) {
              state.wbits = 15;
            }
            state.check = 0/*crc32(0L, Z_NULL, 0)*/;
            //=== CRC2(state.check, hold);
            hbuf[0] = hold & 0xff;
            hbuf[1] = (hold >>> 8) & 0xff;
            state.check = crc32_1(state.check, hbuf, 2, 0);
            //===//

            //=== INITBITS();
            hold = 0;
            bits = 0;
            //===//
            state.mode = FLAGS;
            break;
          }
          if (state.head) {
            state.head.done = false;
          }
          if (!(state.wrap & 1) ||   /* check if zlib header allowed */
            (((hold & 0xff)/*BITS(8)*/ << 8) + (hold >> 8)) % 31) {
            strm.msg = 'incorrect header check';
            state.mode = BAD;
            break;
          }
          if ((hold & 0x0f)/*BITS(4)*/ !== Z_DEFLATED) {
            strm.msg = 'unknown compression method';
            state.mode = BAD;
            break;
          }
          //--- DROPBITS(4) ---//
          hold >>>= 4;
          bits -= 4;
          //---//
          len = (hold & 0x0f)/*BITS(4)*/ + 8;
          if (state.wbits === 0) {
            state.wbits = len;
          }
          if (len > 15 || len > state.wbits) {
            strm.msg = 'invalid window size';
            state.mode = BAD;
            break;
          }

          // !!! pako patch. Force use `options.windowBits` if passed.
          // Required to always use max window size by default.
          state.dmax = 1 << state.wbits;
          //state.dmax = 1 << len;

          state.flags = 0;               /* indicate zlib header */
          //Tracev((stderr, "inflate:   zlib header ok\n"));
          strm.adler = state.check = 1/*adler32(0L, Z_NULL, 0)*/;
          state.mode = hold & 0x200 ? DICTID : TYPE;
          //=== INITBITS();
          hold = 0;
          bits = 0;
          //===//
          break;
        case FLAGS:
          //=== NEEDBITS(16); */
          while (bits < 16) {
            if (have === 0) { break inf_leave; }
            have--;
            hold += input[next++] << bits;
            bits += 8;
          }
          //===//
          state.flags = hold;
          if ((state.flags & 0xff) !== Z_DEFLATED) {
            strm.msg = 'unknown compression method';
            state.mode = BAD;
            break;
          }
          if (state.flags & 0xe000) {
            strm.msg = 'unknown header flags set';
            state.mode = BAD;
            break;
          }
          if (state.head) {
            state.head.text = ((hold >> 8) & 1);
          }
          if ((state.flags & 0x0200) && (state.wrap & 4)) {
            //=== CRC2(state.check, hold);
            hbuf[0] = hold & 0xff;
            hbuf[1] = (hold >>> 8) & 0xff;
            state.check = crc32_1(state.check, hbuf, 2, 0);
            //===//
          }
          //=== INITBITS();
          hold = 0;
          bits = 0;
          //===//
          state.mode = TIME;
          /* falls through */
        case TIME:
          //=== NEEDBITS(32); */
          while (bits < 32) {
            if (have === 0) { break inf_leave; }
            have--;
            hold += input[next++] << bits;
            bits += 8;
          }
          //===//
          if (state.head) {
            state.head.time = hold;
          }
          if ((state.flags & 0x0200) && (state.wrap & 4)) {
            //=== CRC4(state.check, hold)
            hbuf[0] = hold & 0xff;
            hbuf[1] = (hold >>> 8) & 0xff;
            hbuf[2] = (hold >>> 16) & 0xff;
            hbuf[3] = (hold >>> 24) & 0xff;
            state.check = crc32_1(state.check, hbuf, 4, 0);
            //===
          }
          //=== INITBITS();
          hold = 0;
          bits = 0;
          //===//
          state.mode = OS;
          /* falls through */
        case OS:
          //=== NEEDBITS(16); */
          while (bits < 16) {
            if (have === 0) { break inf_leave; }
            have--;
            hold += input[next++] << bits;
            bits += 8;
          }
          //===//
          if (state.head) {
            state.head.xflags = (hold & 0xff);
            state.head.os = (hold >> 8);
          }
          if ((state.flags & 0x0200) && (state.wrap & 4)) {
            //=== CRC2(state.check, hold);
            hbuf[0] = hold & 0xff;
            hbuf[1] = (hold >>> 8) & 0xff;
            state.check = crc32_1(state.check, hbuf, 2, 0);
            //===//
          }
          //=== INITBITS();
          hold = 0;
          bits = 0;
          //===//
          state.mode = EXLEN;
          /* falls through */
        case EXLEN:
          if (state.flags & 0x0400) {
            //=== NEEDBITS(16); */
            while (bits < 16) {
              if (have === 0) { break inf_leave; }
              have--;
              hold += input[next++] << bits;
              bits += 8;
            }
            //===//
            state.length = hold;
            if (state.head) {
              state.head.extra_len = hold;
            }
            if ((state.flags & 0x0200) && (state.wrap & 4)) {
              //=== CRC2(state.check, hold);
              hbuf[0] = hold & 0xff;
              hbuf[1] = (hold >>> 8) & 0xff;
              state.check = crc32_1(state.check, hbuf, 2, 0);
              //===//
            }
            //=== INITBITS();
            hold = 0;
            bits = 0;
            //===//
          }
          else if (state.head) {
            state.head.extra = null/*Z_NULL*/;
          }
          state.mode = EXTRA;
          /* falls through */
        case EXTRA:
          if (state.flags & 0x0400) {
            copy = state.length;
            if (copy > have) { copy = have; }
            if (copy) {
              if (state.head) {
                len = state.head.extra_len - state.length;
                if (!state.head.extra) {
                  // Use untyped array for more convenient processing later
                  state.head.extra = new Uint8Array(state.head.extra_len);
                }
                state.head.extra.set(
                  input.subarray(
                    next,
                    // extra field is limited to 65536 bytes
                    // - no need for additional size check
                    next + copy
                  ),
                  /*len + copy > state.head.extra_max - len ? state.head.extra_max : copy,*/
                  len
                );
                //zmemcpy(state.head.extra + len, next,
                //        len + copy > state.head.extra_max ?
                //        state.head.extra_max - len : copy);
              }
              if ((state.flags & 0x0200) && (state.wrap & 4)) {
                state.check = crc32_1(state.check, input, copy, next);
              }
              have -= copy;
              next += copy;
              state.length -= copy;
            }
            if (state.length) { break inf_leave; }
          }
          state.length = 0;
          state.mode = NAME;
          /* falls through */
        case NAME:
          if (state.flags & 0x0800) {
            if (have === 0) { break inf_leave; }
            copy = 0;
            do {
              // TODO: 2 or 1 bytes?
              len = input[next + copy++];
              /* use constant limit because in js we should not preallocate memory */
              if (state.head && len &&
                  (state.length < 65536 /*state.head.name_max*/)) {
                state.head.name += String.fromCharCode(len);
              }
            } while (len && copy < have);

            if ((state.flags & 0x0200) && (state.wrap & 4)) {
              state.check = crc32_1(state.check, input, copy, next);
            }
            have -= copy;
            next += copy;
            if (len) { break inf_leave; }
          }
          else if (state.head) {
            state.head.name = null;
          }
          state.length = 0;
          state.mode = COMMENT;
          /* falls through */
        case COMMENT:
          if (state.flags & 0x1000) {
            if (have === 0) { break inf_leave; }
            copy = 0;
            do {
              len = input[next + copy++];
              /* use constant limit because in js we should not preallocate memory */
              if (state.head && len &&
                  (state.length < 65536 /*state.head.comm_max*/)) {
                state.head.comment += String.fromCharCode(len);
              }
            } while (len && copy < have);
            if ((state.flags & 0x0200) && (state.wrap & 4)) {
              state.check = crc32_1(state.check, input, copy, next);
            }
            have -= copy;
            next += copy;
            if (len) { break inf_leave; }
          }
          else if (state.head) {
            state.head.comment = null;
          }
          state.mode = HCRC;
          /* falls through */
        case HCRC:
          if (state.flags & 0x0200) {
            //=== NEEDBITS(16); */
            while (bits < 16) {
              if (have === 0) { break inf_leave; }
              have--;
              hold += input[next++] << bits;
              bits += 8;
            }
            //===//
            if ((state.wrap & 4) && hold !== (state.check & 0xffff)) {
              strm.msg = 'header crc mismatch';
              state.mode = BAD;
              break;
            }
            //=== INITBITS();
            hold = 0;
            bits = 0;
            //===//
          }
          if (state.head) {
            state.head.hcrc = ((state.flags >> 9) & 1);
            state.head.done = true;
          }
          strm.adler = state.check = 0;
          state.mode = TYPE;
          break;
        case DICTID:
          //=== NEEDBITS(32); */
          while (bits < 32) {
            if (have === 0) { break inf_leave; }
            have--;
            hold += input[next++] << bits;
            bits += 8;
          }
          //===//
          strm.adler = state.check = zswap32(hold);
          //=== INITBITS();
          hold = 0;
          bits = 0;
          //===//
          state.mode = DICT;
          /* falls through */
        case DICT:
          if (state.havedict === 0) {
            //--- RESTORE() ---
            strm.next_out = put;
            strm.avail_out = left;
            strm.next_in = next;
            strm.avail_in = have;
            state.hold = hold;
            state.bits = bits;
            //---
            return Z_NEED_DICT$1;
          }
          strm.adler = state.check = 1/*adler32(0L, Z_NULL, 0)*/;
          state.mode = TYPE;
          /* falls through */
        case TYPE:
          if (flush === Z_BLOCK || flush === Z_TREES) { break inf_leave; }
          /* falls through */
        case TYPEDO:
          if (state.last) {
            //--- BYTEBITS() ---//
            hold >>>= bits & 7;
            bits -= bits & 7;
            //---//
            state.mode = CHECK;
            break;
          }
          //=== NEEDBITS(3); */
          while (bits < 3) {
            if (have === 0) { break inf_leave; }
            have--;
            hold += input[next++] << bits;
            bits += 8;
          }
          //===//
          state.last = (hold & 0x01)/*BITS(1)*/;
          //--- DROPBITS(1) ---//
          hold >>>= 1;
          bits -= 1;
          //---//

          switch ((hold & 0x03)/*BITS(2)*/) {
            case 0:                             /* stored block */
              //Tracev((stderr, "inflate:     stored block%s\n",
              //        state.last ? " (last)" : ""));
              state.mode = STORED;
              break;
            case 1:                             /* fixed block */
              fixedtables(state);
              //Tracev((stderr, "inflate:     fixed codes block%s\n",
              //        state.last ? " (last)" : ""));
              state.mode = LEN_;             /* decode codes */
              if (flush === Z_TREES) {
                //--- DROPBITS(2) ---//
                hold >>>= 2;
                bits -= 2;
                //---//
                break inf_leave;
              }
              break;
            case 2:                             /* dynamic block */
              //Tracev((stderr, "inflate:     dynamic codes block%s\n",
              //        state.last ? " (last)" : ""));
              state.mode = TABLE;
              break;
            case 3:
              strm.msg = 'invalid block type';
              state.mode = BAD;
          }
          //--- DROPBITS(2) ---//
          hold >>>= 2;
          bits -= 2;
          //---//
          break;
        case STORED:
          //--- BYTEBITS() ---// /* go to byte boundary */
          hold >>>= bits & 7;
          bits -= bits & 7;
          //---//
          //=== NEEDBITS(32); */
          while (bits < 32) {
            if (have === 0) { break inf_leave; }
            have--;
            hold += input[next++] << bits;
            bits += 8;
          }
          //===//
          if ((hold & 0xffff) !== ((hold >>> 16) ^ 0xffff)) {
            strm.msg = 'invalid stored block lengths';
            state.mode = BAD;
            break;
          }
          state.length = hold & 0xffff;
          //Tracev((stderr, "inflate:       stored length %u\n",
          //        state.length));
          //=== INITBITS();
          hold = 0;
          bits = 0;
          //===//
          state.mode = COPY_;
          if (flush === Z_TREES) { break inf_leave; }
          /* falls through */
        case COPY_:
          state.mode = COPY;
          /* falls through */
        case COPY:
          copy = state.length;
          if (copy) {
            if (copy > have) { copy = have; }
            if (copy > left) { copy = left; }
            if (copy === 0) { break inf_leave; }
            //--- zmemcpy(put, next, copy); ---
            output.set(input.subarray(next, next + copy), put);
            //---//
            have -= copy;
            next += copy;
            left -= copy;
            put += copy;
            state.length -= copy;
            break;
          }
          //Tracev((stderr, "inflate:       stored end\n"));
          state.mode = TYPE;
          break;
        case TABLE:
          //=== NEEDBITS(14); */
          while (bits < 14) {
            if (have === 0) { break inf_leave; }
            have--;
            hold += input[next++] << bits;
            bits += 8;
          }
          //===//
          state.nlen = (hold & 0x1f)/*BITS(5)*/ + 257;
          //--- DROPBITS(5) ---//
          hold >>>= 5;
          bits -= 5;
          //---//
          state.ndist = (hold & 0x1f)/*BITS(5)*/ + 1;
          //--- DROPBITS(5) ---//
          hold >>>= 5;
          bits -= 5;
          //---//
          state.ncode = (hold & 0x0f)/*BITS(4)*/ + 4;
          //--- DROPBITS(4) ---//
          hold >>>= 4;
          bits -= 4;
          //---//
  //#ifndef PKZIP_BUG_WORKAROUND
          if (state.nlen > 286 || state.ndist > 30) {
            strm.msg = 'too many length or distance symbols';
            state.mode = BAD;
            break;
          }
  //#endif
          //Tracev((stderr, "inflate:       table sizes ok\n"));
          state.have = 0;
          state.mode = LENLENS;
          /* falls through */
        case LENLENS:
          while (state.have < state.ncode) {
            //=== NEEDBITS(3);
            while (bits < 3) {
              if (have === 0) { break inf_leave; }
              have--;
              hold += input[next++] << bits;
              bits += 8;
            }
            //===//
            state.lens[order[state.have++]] = (hold & 0x07);//BITS(3);
            //--- DROPBITS(3) ---//
            hold >>>= 3;
            bits -= 3;
            //---//
          }
          while (state.have < 19) {
            state.lens[order[state.have++]] = 0;
          }
          // We have separate tables & no pointers. 2 commented lines below not needed.
          //state.next = state.codes;
          //state.lencode = state.next;
          // Switch to use dynamic table
          state.lencode = state.lendyn;
          state.lenbits = 7;

          opts = { bits: state.lenbits };
          ret = inftrees(CODES, state.lens, 0, 19, state.lencode, 0, state.work, opts);
          state.lenbits = opts.bits;

          if (ret) {
            strm.msg = 'invalid code lengths set';
            state.mode = BAD;
            break;
          }
          //Tracev((stderr, "inflate:       code lengths ok\n"));
          state.have = 0;
          state.mode = CODELENS;
          /* falls through */
        case CODELENS:
          while (state.have < state.nlen + state.ndist) {
            for (;;) {
              here = state.lencode[hold & ((1 << state.lenbits) - 1)];/*BITS(state.lenbits)*/
              here_bits = here >>> 24;
              here_op = (here >>> 16) & 0xff;
              here_val = here & 0xffff;

              if ((here_bits) <= bits) { break; }
              //--- PULLBYTE() ---//
              if (have === 0) { break inf_leave; }
              have--;
              hold += input[next++] << bits;
              bits += 8;
              //---//
            }
            if (here_val < 16) {
              //--- DROPBITS(here.bits) ---//
              hold >>>= here_bits;
              bits -= here_bits;
              //---//
              state.lens[state.have++] = here_val;
            }
            else {
              if (here_val === 16) {
                //=== NEEDBITS(here.bits + 2);
                n = here_bits + 2;
                while (bits < n) {
                  if (have === 0) { break inf_leave; }
                  have--;
                  hold += input[next++] << bits;
                  bits += 8;
                }
                //===//
                //--- DROPBITS(here.bits) ---//
                hold >>>= here_bits;
                bits -= here_bits;
                //---//
                if (state.have === 0) {
                  strm.msg = 'invalid bit length repeat';
                  state.mode = BAD;
                  break;
                }
                len = state.lens[state.have - 1];
                copy = 3 + (hold & 0x03);//BITS(2);
                //--- DROPBITS(2) ---//
                hold >>>= 2;
                bits -= 2;
                //---//
              }
              else if (here_val === 17) {
                //=== NEEDBITS(here.bits + 3);
                n = here_bits + 3;
                while (bits < n) {
                  if (have === 0) { break inf_leave; }
                  have--;
                  hold += input[next++] << bits;
                  bits += 8;
                }
                //===//
                //--- DROPBITS(here.bits) ---//
                hold >>>= here_bits;
                bits -= here_bits;
                //---//
                len = 0;
                copy = 3 + (hold & 0x07);//BITS(3);
                //--- DROPBITS(3) ---//
                hold >>>= 3;
                bits -= 3;
                //---//
              }
              else {
                //=== NEEDBITS(here.bits + 7);
                n = here_bits + 7;
                while (bits < n) {
                  if (have === 0) { break inf_leave; }
                  have--;
                  hold += input[next++] << bits;
                  bits += 8;
                }
                //===//
                //--- DROPBITS(here.bits) ---//
                hold >>>= here_bits;
                bits -= here_bits;
                //---//
                len = 0;
                copy = 11 + (hold & 0x7f);//BITS(7);
                //--- DROPBITS(7) ---//
                hold >>>= 7;
                bits -= 7;
                //---//
              }
              if (state.have + copy > state.nlen + state.ndist) {
                strm.msg = 'invalid bit length repeat';
                state.mode = BAD;
                break;
              }
              while (copy--) {
                state.lens[state.have++] = len;
              }
            }
          }

          /* handle error breaks in while */
          if (state.mode === BAD) { break; }

          /* check for end-of-block code (better have one) */
          if (state.lens[256] === 0) {
            strm.msg = 'invalid code -- missing end-of-block';
            state.mode = BAD;
            break;
          }

          /* build code tables -- note: do not change the lenbits or distbits
             values here (9 and 6) without reading the comments in inftrees.h
             concerning the ENOUGH constants, which depend on those values */
          state.lenbits = 9;

          opts = { bits: state.lenbits };
          ret = inftrees(LENS, state.lens, 0, state.nlen, state.lencode, 0, state.work, opts);
          // We have separate tables & no pointers. 2 commented lines below not needed.
          // state.next_index = opts.table_index;
          state.lenbits = opts.bits;
          // state.lencode = state.next;

          if (ret) {
            strm.msg = 'invalid literal/lengths set';
            state.mode = BAD;
            break;
          }

          state.distbits = 6;
          //state.distcode.copy(state.codes);
          // Switch to use dynamic table
          state.distcode = state.distdyn;
          opts = { bits: state.distbits };
          ret = inftrees(DISTS, state.lens, state.nlen, state.ndist, state.distcode, 0, state.work, opts);
          // We have separate tables & no pointers. 2 commented lines below not needed.
          // state.next_index = opts.table_index;
          state.distbits = opts.bits;
          // state.distcode = state.next;

          if (ret) {
            strm.msg = 'invalid distances set';
            state.mode = BAD;
            break;
          }
          //Tracev((stderr, 'inflate:       codes ok\n'));
          state.mode = LEN_;
          if (flush === Z_TREES) { break inf_leave; }
          /* falls through */
        case LEN_:
          state.mode = LEN;
          /* falls through */
        case LEN:
          if (have >= 6 && left >= 258) {
            //--- RESTORE() ---
            strm.next_out = put;
            strm.avail_out = left;
            strm.next_in = next;
            strm.avail_in = have;
            state.hold = hold;
            state.bits = bits;
            //---
            inffast(strm, _out);
            //--- LOAD() ---
            put = strm.next_out;
            output = strm.output;
            left = strm.avail_out;
            next = strm.next_in;
            input = strm.input;
            have = strm.avail_in;
            hold = state.hold;
            bits = state.bits;
            //---

            if (state.mode === TYPE) {
              state.back = -1;
            }
            break;
          }
          state.back = 0;
          for (;;) {
            here = state.lencode[hold & ((1 << state.lenbits) - 1)];  /*BITS(state.lenbits)*/
            here_bits = here >>> 24;
            here_op = (here >>> 16) & 0xff;
            here_val = here & 0xffff;

            if (here_bits <= bits) { break; }
            //--- PULLBYTE() ---//
            if (have === 0) { break inf_leave; }
            have--;
            hold += input[next++] << bits;
            bits += 8;
            //---//
          }
          if (here_op && (here_op & 0xf0) === 0) {
            last_bits = here_bits;
            last_op = here_op;
            last_val = here_val;
            for (;;) {
              here = state.lencode[last_val +
                      ((hold & ((1 << (last_bits + last_op)) - 1))/*BITS(last.bits + last.op)*/ >> last_bits)];
              here_bits = here >>> 24;
              here_op = (here >>> 16) & 0xff;
              here_val = here & 0xffff;

              if ((last_bits + here_bits) <= bits) { break; }
              //--- PULLBYTE() ---//
              if (have === 0) { break inf_leave; }
              have--;
              hold += input[next++] << bits;
              bits += 8;
              //---//
            }
            //--- DROPBITS(last.bits) ---//
            hold >>>= last_bits;
            bits -= last_bits;
            //---//
            state.back += last_bits;
          }
          //--- DROPBITS(here.bits) ---//
          hold >>>= here_bits;
          bits -= here_bits;
          //---//
          state.back += here_bits;
          state.length = here_val;
          if (here_op === 0) {
            //Tracevv((stderr, here.val >= 0x20 && here.val < 0x7f ?
            //        "inflate:         literal '%c'\n" :
            //        "inflate:         literal 0x%02x\n", here.val));
            state.mode = LIT;
            break;
          }
          if (here_op & 32) {
            //Tracevv((stderr, "inflate:         end of block\n"));
            state.back = -1;
            state.mode = TYPE;
            break;
          }
          if (here_op & 64) {
            strm.msg = 'invalid literal/length code';
            state.mode = BAD;
            break;
          }
          state.extra = here_op & 15;
          state.mode = LENEXT;
          /* falls through */
        case LENEXT:
          if (state.extra) {
            //=== NEEDBITS(state.extra);
            n = state.extra;
            while (bits < n) {
              if (have === 0) { break inf_leave; }
              have--;
              hold += input[next++] << bits;
              bits += 8;
            }
            //===//
            state.length += hold & ((1 << state.extra) - 1)/*BITS(state.extra)*/;
            //--- DROPBITS(state.extra) ---//
            hold >>>= state.extra;
            bits -= state.extra;
            //---//
            state.back += state.extra;
          }
          //Tracevv((stderr, "inflate:         length %u\n", state.length));
          state.was = state.length;
          state.mode = DIST;
          /* falls through */
        case DIST:
          for (;;) {
            here = state.distcode[hold & ((1 << state.distbits) - 1)];/*BITS(state.distbits)*/
            here_bits = here >>> 24;
            here_op = (here >>> 16) & 0xff;
            here_val = here & 0xffff;

            if ((here_bits) <= bits) { break; }
            //--- PULLBYTE() ---//
            if (have === 0) { break inf_leave; }
            have--;
            hold += input[next++] << bits;
            bits += 8;
            //---//
          }
          if ((here_op & 0xf0) === 0) {
            last_bits = here_bits;
            last_op = here_op;
            last_val = here_val;
            for (;;) {
              here = state.distcode[last_val +
                      ((hold & ((1 << (last_bits + last_op)) - 1))/*BITS(last.bits + last.op)*/ >> last_bits)];
              here_bits = here >>> 24;
              here_op = (here >>> 16) & 0xff;
              here_val = here & 0xffff;

              if ((last_bits + here_bits) <= bits) { break; }
              //--- PULLBYTE() ---//
              if (have === 0) { break inf_leave; }
              have--;
              hold += input[next++] << bits;
              bits += 8;
              //---//
            }
            //--- DROPBITS(last.bits) ---//
            hold >>>= last_bits;
            bits -= last_bits;
            //---//
            state.back += last_bits;
          }
          //--- DROPBITS(here.bits) ---//
          hold >>>= here_bits;
          bits -= here_bits;
          //---//
          state.back += here_bits;
          if (here_op & 64) {
            strm.msg = 'invalid distance code';
            state.mode = BAD;
            break;
          }
          state.offset = here_val;
          state.extra = (here_op) & 15;
          state.mode = DISTEXT;
          /* falls through */
        case DISTEXT:
          if (state.extra) {
            //=== NEEDBITS(state.extra);
            n = state.extra;
            while (bits < n) {
              if (have === 0) { break inf_leave; }
              have--;
              hold += input[next++] << bits;
              bits += 8;
            }
            //===//
            state.offset += hold & ((1 << state.extra) - 1)/*BITS(state.extra)*/;
            //--- DROPBITS(state.extra) ---//
            hold >>>= state.extra;
            bits -= state.extra;
            //---//
            state.back += state.extra;
          }
  //#ifdef INFLATE_STRICT
          if (state.offset > state.dmax) {
            strm.msg = 'invalid distance too far back';
            state.mode = BAD;
            break;
          }
  //#endif
          //Tracevv((stderr, "inflate:         distance %u\n", state.offset));
          state.mode = MATCH;
          /* falls through */
        case MATCH:
          if (left === 0) { break inf_leave; }
          copy = _out - left;
          if (state.offset > copy) {         /* copy from window */
            copy = state.offset - copy;
            if (copy > state.whave) {
              if (state.sane) {
                strm.msg = 'invalid distance too far back';
                state.mode = BAD;
                break;
              }
  // (!) This block is disabled in zlib defaults,
  // don't enable it for binary compatibility
  //#ifdef INFLATE_ALLOW_INVALID_DISTANCE_TOOFAR_ARRR
  //          Trace((stderr, "inflate.c too far\n"));
  //          copy -= state.whave;
  //          if (copy > state.length) { copy = state.length; }
  //          if (copy > left) { copy = left; }
  //          left -= copy;
  //          state.length -= copy;
  //          do {
  //            output[put++] = 0;
  //          } while (--copy);
  //          if (state.length === 0) { state.mode = LEN; }
  //          break;
  //#endif
            }
            if (copy > state.wnext) {
              copy -= state.wnext;
              from = state.wsize - copy;
            }
            else {
              from = state.wnext - copy;
            }
            if (copy > state.length) { copy = state.length; }
            from_source = state.window;
          }
          else {                              /* copy from output */
            from_source = output;
            from = put - state.offset;
            copy = state.length;
          }
          if (copy > left) { copy = left; }
          left -= copy;
          state.length -= copy;
          do {
            output[put++] = from_source[from++];
          } while (--copy);
          if (state.length === 0) { state.mode = LEN; }
          break;
        case LIT:
          if (left === 0) { break inf_leave; }
          output[put++] = state.length;
          left--;
          state.mode = LEN;
          break;
        case CHECK:
          if (state.wrap) {
            //=== NEEDBITS(32);
            while (bits < 32) {
              if (have === 0) { break inf_leave; }
              have--;
              // Use '|' instead of '+' to make sure that result is signed
              hold |= input[next++] << bits;
              bits += 8;
            }
            //===//
            _out -= left;
            strm.total_out += _out;
            state.total += _out;
            if ((state.wrap & 4) && _out) {
              strm.adler = state.check =
                  /*UPDATE_CHECK(state.check, put - _out, _out);*/
                  (state.flags ? crc32_1(state.check, output, _out, put - _out) : adler32_1(state.check, output, _out, put - _out));

            }
            _out = left;
            // NB: crc32 stored as signed 32-bit int, zswap32 returns signed too
            if ((state.wrap & 4) && (state.flags ? hold : zswap32(hold)) !== state.check) {
              strm.msg = 'incorrect data check';
              state.mode = BAD;
              break;
            }
            //=== INITBITS();
            hold = 0;
            bits = 0;
            //===//
            //Tracev((stderr, "inflate:   check matches trailer\n"));
          }
          state.mode = LENGTH;
          /* falls through */
        case LENGTH:
          if (state.wrap && state.flags) {
            //=== NEEDBITS(32);
            while (bits < 32) {
              if (have === 0) { break inf_leave; }
              have--;
              hold += input[next++] << bits;
              bits += 8;
            }
            //===//
            if ((state.wrap & 4) && hold !== (state.total & 0xffffffff)) {
              strm.msg = 'incorrect length check';
              state.mode = BAD;
              break;
            }
            //=== INITBITS();
            hold = 0;
            bits = 0;
            //===//
            //Tracev((stderr, "inflate:   length matches trailer\n"));
          }
          state.mode = DONE;
          /* falls through */
        case DONE:
          ret = Z_STREAM_END$1;
          break inf_leave;
        case BAD:
          ret = Z_DATA_ERROR$1;
          break inf_leave;
        case MEM:
          return Z_MEM_ERROR$1;
        case SYNC:
          /* falls through */
        default:
          return Z_STREAM_ERROR$1;
      }
    }

    // inf_leave <- here is real place for "goto inf_leave", emulated via "break inf_leave"

    /*
       Return from inflate(), updating the total counts and the check value.
       If there was no progress during the inflate() call, return a buffer
       error.  Call updatewindow() to create and/or update the window state.
       Note: a memory error from inflate() is non-recoverable.
     */

    //--- RESTORE() ---
    strm.next_out = put;
    strm.avail_out = left;
    strm.next_in = next;
    strm.avail_in = have;
    state.hold = hold;
    state.bits = bits;
    //---

    if (state.wsize || (_out !== strm.avail_out && state.mode < BAD &&
                        (state.mode < CHECK || flush !== Z_FINISH$1))) {
      if (updatewindow(strm, strm.output, strm.next_out, _out - strm.avail_out)) ;
    }
    _in -= strm.avail_in;
    _out -= strm.avail_out;
    strm.total_in += _in;
    strm.total_out += _out;
    state.total += _out;
    if ((state.wrap & 4) && _out) {
      strm.adler = state.check = /*UPDATE_CHECK(state.check, strm.next_out - _out, _out);*/
        (state.flags ? crc32_1(state.check, output, _out, strm.next_out - _out) : adler32_1(state.check, output, _out, strm.next_out - _out));
    }
    strm.data_type = state.bits + (state.last ? 64 : 0) +
                      (state.mode === TYPE ? 128 : 0) +
                      (state.mode === LEN_ || state.mode === COPY_ ? 256 : 0);
    if (((_in === 0 && _out === 0) || flush === Z_FINISH$1) && ret === Z_OK$1) {
      ret = Z_BUF_ERROR;
    }
    return ret;
  };


  const inflateEnd = (strm) => {

    if (inflateStateCheck(strm)) {
      return Z_STREAM_ERROR$1;
    }

    let state = strm.state;
    if (state.window) {
      state.window = null;
    }
    strm.state = null;
    return Z_OK$1;
  };


  const inflateGetHeader = (strm, head) => {

    /* check state */
    if (inflateStateCheck(strm)) { return Z_STREAM_ERROR$1; }
    const state = strm.state;
    if ((state.wrap & 2) === 0) { return Z_STREAM_ERROR$1; }

    /* save header structure */
    state.head = head;
    head.done = false;
    return Z_OK$1;
  };


  const inflateSetDictionary = (strm, dictionary) => {
    const dictLength = dictionary.length;

    let state;
    let dictid;
    let ret;

    /* check state */
    if (inflateStateCheck(strm)) { return Z_STREAM_ERROR$1; }
    state = strm.state;

    if (state.wrap !== 0 && state.mode !== DICT) {
      return Z_STREAM_ERROR$1;
    }

    /* check for correct dictionary identifier */
    if (state.mode === DICT) {
      dictid = 1; /* adler32(0, null, 0)*/
      /* dictid = adler32(dictid, dictionary, dictLength); */
      dictid = adler32_1(dictid, dictionary, dictLength, 0);
      if (dictid !== state.check) {
        return Z_DATA_ERROR$1;
      }
    }
    /* copy dictionary to window using updatewindow(), which will amend the
     existing dictionary if appropriate */
    ret = updatewindow(strm, dictionary, dictLength, dictLength);
    if (ret) {
      state.mode = MEM;
      return Z_MEM_ERROR$1;
    }
    state.havedict = 1;
    // Tracev((stderr, "inflate:   dictionary set\n"));
    return Z_OK$1;
  };


  var inflateReset_1 = inflateReset;
  var inflateReset2_1 = inflateReset2;
  var inflateResetKeep_1 = inflateResetKeep;
  var inflateInit_1 = inflateInit;
  var inflateInit2_1 = inflateInit2;
  var inflate_2$1 = inflate$1;
  var inflateEnd_1 = inflateEnd;
  var inflateGetHeader_1 = inflateGetHeader;
  var inflateSetDictionary_1 = inflateSetDictionary;
  var inflateInfo = 'pako inflate (from Nodeca project)';

  /* Not implemented
  module.exports.inflateCodesUsed = inflateCodesUsed;
  module.exports.inflateCopy = inflateCopy;
  module.exports.inflateGetDictionary = inflateGetDictionary;
  module.exports.inflateMark = inflateMark;
  module.exports.inflatePrime = inflatePrime;
  module.exports.inflateSync = inflateSync;
  module.exports.inflateSyncPoint = inflateSyncPoint;
  module.exports.inflateUndermine = inflateUndermine;
  module.exports.inflateValidate = inflateValidate;
  */

  var inflate_1$1 = {
  	inflateReset: inflateReset_1,
  	inflateReset2: inflateReset2_1,
  	inflateResetKeep: inflateResetKeep_1,
  	inflateInit: inflateInit_1,
  	inflateInit2: inflateInit2_1,
  	inflate: inflate_2$1,
  	inflateEnd: inflateEnd_1,
  	inflateGetHeader: inflateGetHeader_1,
  	inflateSetDictionary: inflateSetDictionary_1,
  	inflateInfo: inflateInfo
  };

  const _has = (obj, key) => {
    return Object.prototype.hasOwnProperty.call(obj, key);
  };

  var assign = function (obj /*from1, from2, from3, ...*/) {
    const sources = Array.prototype.slice.call(arguments, 1);
    while (sources.length) {
      const source = sources.shift();
      if (!source) { continue; }

      if (typeof source !== 'object') {
        throw new TypeError(source + 'must be non-object');
      }

      for (const p in source) {
        if (_has(source, p)) {
          obj[p] = source[p];
        }
      }
    }

    return obj;
  };


  // Join array of chunks to single array.
  var flattenChunks = (chunks) => {
    // calculate data length
    let len = 0;

    for (let i = 0, l = chunks.length; i < l; i++) {
      len += chunks[i].length;
    }

    // join chunks
    const result = new Uint8Array(len);

    for (let i = 0, pos = 0, l = chunks.length; i < l; i++) {
      let chunk = chunks[i];
      result.set(chunk, pos);
      pos += chunk.length;
    }

    return result;
  };

  var common = {
  	assign: assign,
  	flattenChunks: flattenChunks
  };

  // String encode/decode helpers


  // Quick check if we can use fast array to bin string conversion
  //
  // - apply(Array) can fail on Android 2.2
  // - apply(Uint8Array) can fail on iOS 5.1 Safari
  //
  let STR_APPLY_UIA_OK = true;

  try { String.fromCharCode.apply(null, new Uint8Array(1)); } catch (__) { STR_APPLY_UIA_OK = false; }


  // Table with utf8 lengths (calculated by first byte of sequence)
  // Note, that 5 & 6-byte values and some 4-byte values can not be represented in JS,
  // because max possible codepoint is 0x10ffff
  const _utf8len = new Uint8Array(256);
  for (let q = 0; q < 256; q++) {
    _utf8len[q] = (q >= 252 ? 6 : q >= 248 ? 5 : q >= 240 ? 4 : q >= 224 ? 3 : q >= 192 ? 2 : 1);
  }
  _utf8len[254] = _utf8len[254] = 1; // Invalid sequence start


  // convert string to array (typed, when possible)
  var string2buf = (str) => {
    if (typeof TextEncoder === 'function' && TextEncoder.prototype.encode) {
      return new TextEncoder().encode(str);
    }

    let buf, c, c2, m_pos, i, str_len = str.length, buf_len = 0;

    // count binary size
    for (m_pos = 0; m_pos < str_len; m_pos++) {
      c = str.charCodeAt(m_pos);
      if ((c & 0xfc00) === 0xd800 && (m_pos + 1 < str_len)) {
        c2 = str.charCodeAt(m_pos + 1);
        if ((c2 & 0xfc00) === 0xdc00) {
          c = 0x10000 + ((c - 0xd800) << 10) + (c2 - 0xdc00);
          m_pos++;
        }
      }
      buf_len += c < 0x80 ? 1 : c < 0x800 ? 2 : c < 0x10000 ? 3 : 4;
    }

    // allocate buffer
    buf = new Uint8Array(buf_len);

    // convert
    for (i = 0, m_pos = 0; i < buf_len; m_pos++) {
      c = str.charCodeAt(m_pos);
      if ((c & 0xfc00) === 0xd800 && (m_pos + 1 < str_len)) {
        c2 = str.charCodeAt(m_pos + 1);
        if ((c2 & 0xfc00) === 0xdc00) {
          c = 0x10000 + ((c - 0xd800) << 10) + (c2 - 0xdc00);
          m_pos++;
        }
      }
      if (c < 0x80) {
        /* one byte */
        buf[i++] = c;
      } else if (c < 0x800) {
        /* two bytes */
        buf[i++] = 0xC0 | (c >>> 6);
        buf[i++] = 0x80 | (c & 0x3f);
      } else if (c < 0x10000) {
        /* three bytes */
        buf[i++] = 0xE0 | (c >>> 12);
        buf[i++] = 0x80 | (c >>> 6 & 0x3f);
        buf[i++] = 0x80 | (c & 0x3f);
      } else {
        /* four bytes */
        buf[i++] = 0xf0 | (c >>> 18);
        buf[i++] = 0x80 | (c >>> 12 & 0x3f);
        buf[i++] = 0x80 | (c >>> 6 & 0x3f);
        buf[i++] = 0x80 | (c & 0x3f);
      }
    }

    return buf;
  };

  // Helper
  const buf2binstring = (buf, len) => {
    // On Chrome, the arguments in a function call that are allowed is `65534`.
    // If the length of the buffer is smaller than that, we can use this optimization,
    // otherwise we will take a slower path.
    if (len < 65534) {
      if (buf.subarray && STR_APPLY_UIA_OK) {
        return String.fromCharCode.apply(null, buf.length === len ? buf : buf.subarray(0, len));
      }
    }

    let result = '';
    for (let i = 0; i < len; i++) {
      result += String.fromCharCode(buf[i]);
    }
    return result;
  };


  // convert array to string
  var buf2string = (buf, max) => {
    const len = max || buf.length;

    if (typeof TextDecoder === 'function' && TextDecoder.prototype.decode) {
      return new TextDecoder().decode(buf.subarray(0, max));
    }

    let i, out;

    // Reserve max possible length (2 words per char)
    // NB: by unknown reasons, Array is significantly faster for
    //     String.fromCharCode.apply than Uint16Array.
    const utf16buf = new Array(len * 2);

    for (out = 0, i = 0; i < len;) {
      let c = buf[i++];
      // quick process ascii
      if (c < 0x80) { utf16buf[out++] = c; continue; }

      let c_len = _utf8len[c];
      // skip 5 & 6 byte codes
      if (c_len > 4) { utf16buf[out++] = 0xfffd; i += c_len - 1; continue; }

      // apply mask on first byte
      c &= c_len === 2 ? 0x1f : c_len === 3 ? 0x0f : 0x07;
      // join the rest
      while (c_len > 1 && i < len) {
        c = (c << 6) | (buf[i++] & 0x3f);
        c_len--;
      }

      // terminated by end of string?
      if (c_len > 1) { utf16buf[out++] = 0xfffd; continue; }

      if (c < 0x10000) {
        utf16buf[out++] = c;
      } else {
        c -= 0x10000;
        utf16buf[out++] = 0xd800 | ((c >> 10) & 0x3ff);
        utf16buf[out++] = 0xdc00 | (c & 0x3ff);
      }
    }

    return buf2binstring(utf16buf, out);
  };


  // Calculate max possible position in utf8 buffer,
  // that will not break sequence. If that's not possible
  // - (very small limits) return max size as is.
  //
  // buf[] - utf8 bytes array
  // max   - length limit (mandatory);
  var utf8border = (buf, max) => {

    max = max || buf.length;
    if (max > buf.length) { max = buf.length; }

    // go back from last position, until start of sequence found
    let pos = max - 1;
    while (pos >= 0 && (buf[pos] & 0xC0) === 0x80) { pos--; }

    // Very small and broken sequence,
    // return max, because we should return something anyway.
    if (pos < 0) { return max; }

    // If we came to start of buffer - that means buffer is too small,
    // return max too.
    if (pos === 0) { return max; }

    return (pos + _utf8len[buf[pos]] > max) ? pos : max;
  };

  var strings = {
  	string2buf: string2buf,
  	buf2string: buf2string,
  	utf8border: utf8border
  };

  // (C) 1995-2013 Jean-loup Gailly and Mark Adler
  // (C) 2014-2017 Vitaly Puzrin and Andrey Tupitsin
  //
  // This software is provided 'as-is', without any express or implied
  // warranty. In no event will the authors be held liable for any damages
  // arising from the use of this software.
  //
  // Permission is granted to anyone to use this software for any purpose,
  // including commercial applications, and to alter it and redistribute it
  // freely, subject to the following restrictions:
  //
  // 1. The origin of this software must not be misrepresented; you must not
  //   claim that you wrote the original software. If you use this software
  //   in a product, an acknowledgment in the product documentation would be
  //   appreciated but is not required.
  // 2. Altered source versions must be plainly marked as such, and must not be
  //   misrepresented as being the original software.
  // 3. This notice may not be removed or altered from any source distribution.

  var messages = {
    2:      'need dictionary',     /* Z_NEED_DICT       2  */
    1:      'stream end',          /* Z_STREAM_END      1  */
    0:      '',                    /* Z_OK              0  */
    '-1':   'file error',          /* Z_ERRNO         (-1) */
    '-2':   'stream error',        /* Z_STREAM_ERROR  (-2) */
    '-3':   'data error',          /* Z_DATA_ERROR    (-3) */
    '-4':   'insufficient memory', /* Z_MEM_ERROR     (-4) */
    '-5':   'buffer error',        /* Z_BUF_ERROR     (-5) */
    '-6':   'incompatible version' /* Z_VERSION_ERROR (-6) */
  };

  // (C) 1995-2013 Jean-loup Gailly and Mark Adler
  // (C) 2014-2017 Vitaly Puzrin and Andrey Tupitsin
  //
  // This software is provided 'as-is', without any express or implied
  // warranty. In no event will the authors be held liable for any damages
  // arising from the use of this software.
  //
  // Permission is granted to anyone to use this software for any purpose,
  // including commercial applications, and to alter it and redistribute it
  // freely, subject to the following restrictions:
  //
  // 1. The origin of this software must not be misrepresented; you must not
  //   claim that you wrote the original software. If you use this software
  //   in a product, an acknowledgment in the product documentation would be
  //   appreciated but is not required.
  // 2. Altered source versions must be plainly marked as such, and must not be
  //   misrepresented as being the original software.
  // 3. This notice may not be removed or altered from any source distribution.

  function ZStream() {
    /* next input byte */
    this.input = null; // JS specific, because we have no pointers
    this.next_in = 0;
    /* number of bytes available at input */
    this.avail_in = 0;
    /* total number of input bytes read so far */
    this.total_in = 0;
    /* next output byte should be put there */
    this.output = null; // JS specific, because we have no pointers
    this.next_out = 0;
    /* remaining free space at output */
    this.avail_out = 0;
    /* total number of bytes output so far */
    this.total_out = 0;
    /* last error message, NULL if no error */
    this.msg = ''/*Z_NULL*/;
    /* not visible by applications */
    this.state = null;
    /* best guess about the data type: binary or text */
    this.data_type = 2/*Z_UNKNOWN*/;
    /* adler32 value of the uncompressed data */
    this.adler = 0;
  }

  var zstream = ZStream;

  // (C) 1995-2013 Jean-loup Gailly and Mark Adler
  // (C) 2014-2017 Vitaly Puzrin and Andrey Tupitsin
  //
  // This software is provided 'as-is', without any express or implied
  // warranty. In no event will the authors be held liable for any damages
  // arising from the use of this software.
  //
  // Permission is granted to anyone to use this software for any purpose,
  // including commercial applications, and to alter it and redistribute it
  // freely, subject to the following restrictions:
  //
  // 1. The origin of this software must not be misrepresented; you must not
  //   claim that you wrote the original software. If you use this software
  //   in a product, an acknowledgment in the product documentation would be
  //   appreciated but is not required.
  // 2. Altered source versions must be plainly marked as such, and must not be
  //   misrepresented as being the original software.
  // 3. This notice may not be removed or altered from any source distribution.

  function GZheader() {
    /* true if compressed data believed to be text */
    this.text       = 0;
    /* modification time */
    this.time       = 0;
    /* extra flags (not used when writing a gzip file) */
    this.xflags     = 0;
    /* operating system */
    this.os         = 0;
    /* pointer to extra field or Z_NULL if none */
    this.extra      = null;
    /* extra field length (valid if extra != Z_NULL) */
    this.extra_len  = 0; // Actually, we don't need it in JS,
                         // but leave for few code modifications

    //
    // Setup limits is not necessary because in js we should not preallocate memory
    // for inflate use constant limit in 65536 bytes
    //

    /* space at extra (only when reading header) */
    // this.extra_max  = 0;
    /* pointer to zero-terminated file name or Z_NULL */
    this.name       = '';
    /* space at name (only when reading header) */
    // this.name_max   = 0;
    /* pointer to zero-terminated comment or Z_NULL */
    this.comment    = '';
    /* space at comment (only when reading header) */
    // this.comm_max   = 0;
    /* true if there was or will be a header crc */
    this.hcrc       = 0;
    /* true when done reading gzip header (not used when writing a gzip file) */
    this.done       = false;
  }

  var gzheader = GZheader;

  const toString = Object.prototype.toString;

  /* Public constants ==========================================================*/
  /* ===========================================================================*/

  const {
    Z_NO_FLUSH, Z_FINISH,
    Z_OK, Z_STREAM_END, Z_NEED_DICT, Z_STREAM_ERROR, Z_DATA_ERROR, Z_MEM_ERROR
  } = constants$1;

  /* ===========================================================================*/


  /**
   * class Inflate
   *
   * Generic JS-style wrapper for zlib calls. If you don't need
   * streaming behaviour - use more simple functions: [[inflate]]
   * and [[inflateRaw]].
   **/

  /* internal
   * inflate.chunks -> Array
   *
   * Chunks of output data, if [[Inflate#onData]] not overridden.
   **/

  /**
   * Inflate.result -> Uint8Array|String
   *
   * Uncompressed result, generated by default [[Inflate#onData]]
   * and [[Inflate#onEnd]] handlers. Filled after you push last chunk
   * (call [[Inflate#push]] with `Z_FINISH` / `true` param).
   **/

  /**
   * Inflate.err -> Number
   *
   * Error code after inflate finished. 0 (Z_OK) on success.
   * Should be checked if broken data possible.
   **/

  /**
   * Inflate.msg -> String
   *
   * Error message, if [[Inflate.err]] != 0
   **/


  /**
   * new Inflate(options)
   * - options (Object): zlib inflate options.
   *
   * Creates new inflator instance with specified params. Throws exception
   * on bad params. Supported options:
   *
   * - `windowBits`
   * - `dictionary`
   *
   * [http://zlib.net/manual.html#Advanced](http://zlib.net/manual.html#Advanced)
   * for more information on these.
   *
   * Additional options, for internal needs:
   *
   * - `chunkSize` - size of generated data chunks (16K by default)
   * - `raw` (Boolean) - do raw inflate
   * - `to` (String) - if equal to 'string', then result will be converted
   *   from utf8 to utf16 (javascript) string. When string output requested,
   *   chunk length can differ from `chunkSize`, depending on content.
   *
   * By default, when no options set, autodetect deflate/gzip data format via
   * wrapper header.
   *
   * ##### Example:
   *
   * ```javascript
   * const pako = require('pako')
   * const chunk1 = new Uint8Array([1,2,3,4,5,6,7,8,9])
   * const chunk2 = new Uint8Array([10,11,12,13,14,15,16,17,18,19]);
   *
   * const inflate = new pako.Inflate({ level: 3});
   *
   * inflate.push(chunk1, false);
   * inflate.push(chunk2, true);  // true -> last chunk
   *
   * if (inflate.err) { throw new Error(inflate.err); }
   *
   * console.log(inflate.result);
   * ```
   **/
  function Inflate(options) {
    this.options = common.assign({
      chunkSize: 1024 * 64,
      windowBits: 15,
      to: ''
    }, options || {});

    const opt = this.options;

    // Force window size for `raw` data, if not set directly,
    // because we have no header for autodetect.
    if (opt.raw && (opt.windowBits >= 0) && (opt.windowBits < 16)) {
      opt.windowBits = -opt.windowBits;
      if (opt.windowBits === 0) { opt.windowBits = -15; }
    }

    // If `windowBits` not defined (and mode not raw) - set autodetect flag for gzip/deflate
    if ((opt.windowBits >= 0) && (opt.windowBits < 16) &&
        !(options && options.windowBits)) {
      opt.windowBits += 32;
    }

    // Gzip header has no info about windows size, we can do autodetect only
    // for deflate. So, if window size not set, force it to max when gzip possible
    if ((opt.windowBits > 15) && (opt.windowBits < 48)) {
      // bit 3 (16) -> gzipped data
      // bit 4 (32) -> autodetect gzip/deflate
      if ((opt.windowBits & 15) === 0) {
        opt.windowBits |= 15;
      }
    }

    this.err    = 0;      // error code, if happens (0 = Z_OK)
    this.msg    = '';     // error message
    this.ended  = false;  // used to avoid multiple onEnd() calls
    this.chunks = [];     // chunks of compressed data

    this.strm   = new zstream();
    this.strm.avail_out = 0;

    let status  = inflate_1$1.inflateInit2(
      this.strm,
      opt.windowBits
    );

    if (status !== Z_OK) {
      throw new Error(messages[status]);
    }

    this.header = new gzheader();

    inflate_1$1.inflateGetHeader(this.strm, this.header);

    // Setup dictionary
    if (opt.dictionary) {
      // Convert data if needed
      if (typeof opt.dictionary === 'string') {
        opt.dictionary = strings.string2buf(opt.dictionary);
      } else if (toString.call(opt.dictionary) === '[object ArrayBuffer]') {
        opt.dictionary = new Uint8Array(opt.dictionary);
      }
      if (opt.raw) { //In raw mode we need to set the dictionary early
        status = inflate_1$1.inflateSetDictionary(this.strm, opt.dictionary);
        if (status !== Z_OK) {
          throw new Error(messages[status]);
        }
      }
    }
  }

  /**
   * Inflate#push(data[, flush_mode]) -> Boolean
   * - data (Uint8Array|ArrayBuffer): input data
   * - flush_mode (Number|Boolean): 0..6 for corresponding Z_NO_FLUSH..Z_TREE
   *   flush modes. See constants. Skipped or `false` means Z_NO_FLUSH,
   *   `true` means Z_FINISH.
   *
   * Sends input data to inflate pipe, generating [[Inflate#onData]] calls with
   * new output chunks. Returns `true` on success. If end of stream detected,
   * [[Inflate#onEnd]] will be called.
   *
   * `flush_mode` is not needed for normal operation, because end of stream
   * detected automatically. You may try to use it for advanced things, but
   * this functionality was not tested.
   *
   * On fail call [[Inflate#onEnd]] with error code and return false.
   *
   * ##### Example
   *
   * ```javascript
   * push(chunk, false); // push one of data chunks
   * ...
   * push(chunk, true);  // push last chunk
   * ```
   **/
  Inflate.prototype.push = function (data, flush_mode) {
    const strm = this.strm;
    const chunkSize = this.options.chunkSize;
    const dictionary = this.options.dictionary;
    let status, _flush_mode, last_avail_out;

    if (this.ended) return false;

    if (flush_mode === ~~flush_mode) _flush_mode = flush_mode;
    else _flush_mode = flush_mode === true ? Z_FINISH : Z_NO_FLUSH;

    // Convert data if needed
    if (toString.call(data) === '[object ArrayBuffer]') {
      strm.input = new Uint8Array(data);
    } else {
      strm.input = data;
    }

    strm.next_in = 0;
    strm.avail_in = strm.input.length;

    for (;;) {
      if (strm.avail_out === 0) {
        strm.output = new Uint8Array(chunkSize);
        strm.next_out = 0;
        strm.avail_out = chunkSize;
      }

      status = inflate_1$1.inflate(strm, _flush_mode);

      if (status === Z_NEED_DICT && dictionary) {
        status = inflate_1$1.inflateSetDictionary(strm, dictionary);

        if (status === Z_OK) {
          status = inflate_1$1.inflate(strm, _flush_mode);
        } else if (status === Z_DATA_ERROR) {
          // Replace code with more verbose
          status = Z_NEED_DICT;
        }
      }

      // Skip snyc markers if more data follows and not raw mode
      while (strm.avail_in > 0 &&
             status === Z_STREAM_END &&
             strm.state.wrap > 0 &&
             data[strm.next_in] !== 0)
      {
        inflate_1$1.inflateReset(strm);
        status = inflate_1$1.inflate(strm, _flush_mode);
      }

      switch (status) {
        case Z_STREAM_ERROR:
        case Z_DATA_ERROR:
        case Z_NEED_DICT:
        case Z_MEM_ERROR:
          this.onEnd(status);
          this.ended = true;
          return false;
      }

      // Remember real `avail_out` value, because we may patch out buffer content
      // to align utf8 strings boundaries.
      last_avail_out = strm.avail_out;

      if (strm.next_out) {
        if (strm.avail_out === 0 || status === Z_STREAM_END) {

          if (this.options.to === 'string') {

            let next_out_utf8 = strings.utf8border(strm.output, strm.next_out);

            let tail = strm.next_out - next_out_utf8;
            let utf8str = strings.buf2string(strm.output, next_out_utf8);

            // move tail & realign counters
            strm.next_out = tail;
            strm.avail_out = chunkSize - tail;
            if (tail) strm.output.set(strm.output.subarray(next_out_utf8, next_out_utf8 + tail), 0);

            this.onData(utf8str);

          } else {
            this.onData(strm.output.length === strm.next_out ? strm.output : strm.output.subarray(0, strm.next_out));
          }
        }
      }

      // Must repeat iteration if out buffer is full
      if (status === Z_OK && last_avail_out === 0) continue;

      // Finalize if end of stream reached.
      if (status === Z_STREAM_END) {
        status = inflate_1$1.inflateEnd(this.strm);
        this.onEnd(status);
        this.ended = true;
        return true;
      }

      if (strm.avail_in === 0) break;
    }

    return true;
  };


  /**
   * Inflate#onData(chunk) -> Void
   * - chunk (Uint8Array|String): output data. When string output requested,
   *   each chunk will be string.
   *
   * By default, stores data blocks in `chunks[]` property and glue
   * those in `onEnd`. Override this handler, if you need another behaviour.
   **/
  Inflate.prototype.onData = function (chunk) {
    this.chunks.push(chunk);
  };


  /**
   * Inflate#onEnd(status) -> Void
   * - status (Number): inflate status. 0 (Z_OK) on success,
   *   other if not.
   *
   * Called either after you tell inflate that the input stream is
   * complete (Z_FINISH). By default - join collected chunks,
   * free memory and fill `results` / `err` properties.
   **/
  Inflate.prototype.onEnd = function (status) {
    // On success - join
    if (status === Z_OK) {
      if (this.options.to === 'string') {
        this.result = this.chunks.join('');
      } else {
        this.result = common.flattenChunks(this.chunks);
      }
    }
    this.chunks = [];
    this.err = status;
    this.msg = this.strm.msg;
  };


  /**
   * inflate(data[, options]) -> Uint8Array|String
   * - data (Uint8Array|ArrayBuffer): input data to decompress.
   * - options (Object): zlib inflate options.
   *
   * Decompress `data` with inflate/ungzip and `options`. Autodetect
   * format via wrapper header by default. That's why we don't provide
   * separate `ungzip` method.
   *
   * Supported options are:
   *
   * - windowBits
   *
   * [http://zlib.net/manual.html#Advanced](http://zlib.net/manual.html#Advanced)
   * for more information.
   *
   * Sugar (options):
   *
   * - `raw` (Boolean) - say that we work with raw stream, if you don't wish to specify
   *   negative windowBits implicitly.
   * - `to` (String) - if equal to 'string', then result will be converted
   *   from utf8 to utf16 (javascript) string. When string output requested,
   *   chunk length can differ from `chunkSize`, depending on content.
   *
   *
   * ##### Example:
   *
   * ```javascript
   * const pako = require('pako');
   * const input = pako.deflate(new Uint8Array([1,2,3,4,5,6,7,8,9]));
   * let output;
   *
   * try {
   *   output = pako.inflate(input);
   * } catch (err) {
   *   console.log(err);
   * }
   * ```
   **/
  function inflate(input, options) {
    const inflator = new Inflate(options);

    inflator.push(input);

    // That will never happens, if you don't cheat with options :)
    if (inflator.err) throw inflator.msg || messages[inflator.err];

    return inflator.result;
  }


  /**
   * inflateRaw(data[, options]) -> Uint8Array|String
   * - data (Uint8Array|ArrayBuffer): input data to decompress.
   * - options (Object): zlib inflate options.
   *
   * The same as [[inflate]], but creates raw data, without wrapper
   * (header and adler32 crc).
   **/
  function inflateRaw(input, options) {
    options = options || {};
    options.raw = true;
    return inflate(input, options);
  }


  /**
   * ungzip(data[, options]) -> Uint8Array|String
   * - data (Uint8Array|ArrayBuffer): input data to decompress.
   * - options (Object): zlib inflate options.
   *
   * Just shortcut to [[inflate]], because it autodetects format
   * by header.content. Done for convenience.
   **/


  var Inflate_1 = Inflate;
  var inflate_2 = inflate;
  var inflateRaw_1 = inflateRaw;
  var ungzip = inflate;
  var constants = constants$1;

  var inflate_1 = {
  	Inflate: Inflate_1,
  	inflate: inflate_2,
  	inflateRaw: inflateRaw_1,
  	ungzip: ungzip,
  	constants: constants
  };

  exports.Inflate = Inflate_1;
  exports.constants = constants;
  exports["default"] = inflate_1;
  exports.inflate = inflate_2;
  exports.inflateRaw = inflateRaw_1;
  exports.ungzip = ungzip;

  Object.defineProperty(exports, '__esModule', { value: true });

}));


/***/ }),

/***/ 1785:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Fields_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(564);
/* harmony import */ var _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(8311);
/* harmony import */ var _Base_FieldDefinitionArray_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(6973);
/* harmony import */ var _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(8415);
/* harmony import */ var _X3DLayerNode_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(3281);
/* harmony import */ var _Navigation_Viewpoint_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(1848);
/* harmony import */ var _Grouping_Group_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(1209);
/* harmony import */ var _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(8899);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(6707);









function Layer (executionContext)
{
   _X3DLayerNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .call (this,
                       executionContext,
                       new _Navigation_Viewpoint_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A (executionContext),
                       new _Grouping_Group_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A (executionContext));

   this .addType (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .Layer);
}

Object .assign (Object .setPrototypeOf (Layer .prototype, _X3DLayerNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .prototype),
{
   initialize ()
   {
      _X3DLayerNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .prototype .initialize .call (this);

      const groupNode = this .getGroups () ._children [0] .getValue ();

      this ._addChildren    .addFieldInterest (groupNode ._addChildren);
      this ._removeChildren .addFieldInterest (groupNode ._removeChildren);
      this ._children       .addFieldInterest (groupNode ._children);

      groupNode ._children = this ._children;

      groupNode .setPrivate (true);
      groupNode .setup ();

      this .getGroups () .setup ();
   },
});

Object .defineProperties (Layer,
{
   ... _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .getStaticProperties ("Layer", "Layering", 1, "layers", "3.2"),
   fieldDefinitions:
   {
      value: new _Base_FieldDefinitionArray_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A ([
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .inputOutput, "metadata",       new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFNode ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .inputOutput, "pickable",       new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFBool (true)),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .inputOutput, "objectType",     new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFString ("ALL")),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .inputOutput, "pointerEvents",  new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFBool (true)), // skip test
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .inputOutput, "visible",        new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFBool (true)),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .inputOutput, "viewport",       new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFNode ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .inputOnly,   "addChildren",    new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFNode ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .inputOnly,   "removeChildren", new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFNode ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .inputOutput, "children",       new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFNode ()),
      ]),
      enumerable: true,
   },
});

const __default__ = Layer;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_8__/* ["default"] */ .A .add ("Layer", __default__));

/***/ }),

/***/ 1848:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Fields_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(564);
/* harmony import */ var _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(8311);
/* harmony import */ var _Base_FieldDefinitionArray_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(6973);
/* harmony import */ var _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(8415);
/* harmony import */ var _X3DViewpointNode_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(8001);
/* harmony import */ var _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(8899);
/* harmony import */ var _standard_Math_Geometry_Camera_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(6832);
/* harmony import */ var _standard_Math_Numbers_Vector2_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(8024);
/* harmony import */ var _standard_Math_Numbers_Matrix4_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(1048);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(6707);










function Viewpoint (executionContext)
{
   _X3DViewpointNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .call (this, executionContext);

   this .addType (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .Viewpoint);

   // Units

   this ._position         .setUnit ("length");
   this ._centerOfRotation .setUnit ("length");
   this ._fieldOfView      .setUnit ("angle");

   // Private properties

   this .projectionMatrix = new _standard_Math_Numbers_Matrix4_js__WEBPACK_IMPORTED_MODULE_8__/* ["default"] */ .A ();
}

Object .assign (Object .setPrototypeOf (Viewpoint .prototype, _X3DViewpointNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .prototype),
{
   getRelativeTransformation (fromViewpointNode)
   {
      const relative = _X3DViewpointNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .prototype .getRelativeTransformation .call (this, fromViewpointNode);

      if (fromViewpointNode .constructor === this .constructor)
         relative .fieldOfView = fromViewpointNode .getUserFieldOfView ();

      return relative;
   },
   setInterpolators (fromViewpointNode, relative)
   {
      if (fromViewpointNode .constructor === this .constructor)
      {
         const scale = relative .fieldOfView / this .getUserFieldOfView ();

         this .fieldOfViewScaleInterpolator ._keyValue = new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFFloat (scale, this ._fieldOfViewScale .getValue ());

         this ._fieldOfViewScale = scale;
      }
      else
      {
         this .fieldOfViewScaleInterpolator ._keyValue = new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFFloat (this ._fieldOfViewScale .getValue (), this ._fieldOfViewScale .getValue ());

         this ._fieldOfViewScale = this ._fieldOfViewScale .getValue ();
      }
   },
   getLogarithmicDepthBuffer ()
   {
      return false;
   },
   getFieldOfView ()
   {
      const fov = this ._fieldOfView .getValue ();

      return fov > 0 && fov < Math .PI ? fov : Math .PI / 4;
   },
   setFieldOfView (value)
   {
      this ._fieldOfView = value;
   },
   getUserFieldOfView ()
   {
      const fov = this ._fieldOfView .getValue () * this ._fieldOfViewScale .getValue ();

      return fov > 0 && fov < Math .PI ? fov : Math .PI / 4;
   },
   getScreenScale (point, viewport, screenScale)
   {
      // Returns the screen scale in meter/pixel for on pixel.

      const
         width  = viewport [2],
         height = viewport [3],
         pose   = this .getBrowser () .getPose ();

      // MDN says fov can be determined from projectionMatrix.
      // https://developer.mozilla.org/en-US/docs/Web/API/WebXR_Device_API/Perspective
      const fov1_2 = pose
         ? 1 / pose .views [0] .projectionMatrix [5]
         : Math .tan (this .getUserFieldOfView () / 2);

      let size = Math .abs (point .z) * fov1_2 * 2;

      if (width > height)
         size /= height;
      else
         size /= width;

      return screenScale .set (size, size, size);
   },
   getViewportSize: (() =>
   {
      const viewportSize = new _standard_Math_Numbers_Vector2_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A ();

      return function (viewport, nearValue)
      {
         // Returns viewport size in meters.

         const
            width  = viewport [2],
            height = viewport [3],
            size   = nearValue * Math .tan (this .getUserFieldOfView () / 2) * 2,
            aspect = width / height;

         if (aspect > 1)
            return viewportSize .set (size * aspect, size);

         return viewportSize .set (size, size / aspect);
      };
   })(),
   getLookAtDistance (bbox)
   {
      return (bbox .size .norm () / 2) / Math .tan (this .getUserFieldOfView () / 2);
   },
   getProjectionMatrixWithLimits (nearValue, farValue, viewport)
   {
      return _standard_Math_Geometry_Camera_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .perspective (this .getUserFieldOfView (), nearValue, farValue, viewport [2], viewport [3], this .projectionMatrix);
   },
});

Object .defineProperties (Viewpoint,
{
   ... _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .getStaticProperties ("Viewpoint", "Navigation", 1, "children", "2.0"),
   fieldDefinitions:
   {
      value: new _Base_FieldDefinitionArray_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A ([
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .inputOutput, "metadata",          new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFNode ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .inputOnly,   "set_bind",          new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFBool ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .inputOutput, "description",       new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFString ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .inputOutput, "position",          new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFVec3f (0, 0, 10)),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .inputOutput, "orientation",       new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFRotation ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .inputOutput, "centerOfRotation",  new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFVec3f ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .inputOutput, "fieldOfView",       new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFFloat (0.785398)),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .inputOutput, "nearDistance",      new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFFloat (-1)),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .inputOutput, "farDistance",       new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFFloat (-1)),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .inputOutput, "viewAll",           new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFBool ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .inputOutput, "jump",              new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFBool (true)),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .inputOutput, "retainUserOffsets", new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFBool ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .outputOnly,  "isBound",           new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFBool ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .outputOnly,  "bindTime",          new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFTime ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .inputOutput, "navigationInfo",    new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFNode ()),
      ]),
      enumerable: true,
   },
});

const __default__ = Viewpoint;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_9__/* ["default"] */ .A .add ("Viewpoint", __default__));

/***/ }),

/***/ 2006:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Components_Rendering_X3DGeometryNode_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(7097);
/* harmony import */ var _Shape_AlphaMode_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(2939);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(6707);



function GeometryContext (options = { })
{
   Object .assign (this,
   {
      alphaMode: _Shape_AlphaMode_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .OPAQUE,
      geometryType: 3,
      hasFogCoords: false,
      colorMaterial: false,
      hasNormals: false,
      hasTangents: false,
      textureNode: null,
      localObjectsKeys: [ ],
      textureCoordinateMapping: new Map (),
      textureCoordinateNode: null,
   },
   options)

   this .updateGeometryKey ();
}

Object .assign (GeometryContext .prototype,
{
   getTextureCoordinateMapping ()
   {
      return this .textureCoordinateMapping;
   },
   getTextureCoordinate ()
   {
      return this .textureCoordinateNode;
   },
   updateGeometryKey: _Components_Rendering_X3DGeometryNode_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .prototype .updateGeometryKey,
});

const __default__ = GeometryContext;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .add ("GeometryContext", __default__));

/***/ }),

/***/ 2084:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6707);
// Modified during dist build.

const __default__ = false;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .add ("DEVELOPMENT", __default__));

/***/ }),

/***/ 2100:
/***/ (function(module, exports) {

var __WEBPACK_AMD_DEFINE_FACTORY__, __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;/*
	SuperGif

	Example usage:

		<img src="./example1_preview.gif" rel:animated_src="./example1.gif" width="360" height="360" rel:auto_play="1" />

		<script type="text/javascript">
			$$('img').each(function (img_tag) {
				if (/.*\.gif/.test(img_tag.src)) {
					var rub = new SuperGif({ gif: img_tag } );
					rub.load();
				}
			});
		</script>

	Image tag attributes:

		rel:animated_src -	If this url is specified, it's loaded into the player instead of src.
							This allows a preview frame to be shown until animated gif data is streamed into the canvas

		rel:auto_play -		Defaults to 1 if not specified. If set to zero, a call to the play() method is needed

	Constructor options args

		gif 				Required. The DOM element of an img tag.
		loop_mode			Optional. Setting this to false will force disable looping of the gif.
		auto_play 			Optional. Same as the rel:auto_play attribute above, this arg overrides the img tag info.
		max_width			Optional. Scale images over max_width down to max_width. Helpful with mobile.
 		on_end				Optional. Add a callback for when the gif reaches the end of a single loop (one iteration). The first argument passed will be the gif HTMLElement.
		loop_delay			Optional. The amount of time to pause (in ms) after each single loop (iteration).
		draw_while_loading	Optional. Determines whether the gif will be drawn to the canvas whilst it is loaded.
		show_progress_bar	Optional. Only applies when draw_while_loading is set to true.
        on_error            Optional. Add a callback for when a load error occurs.

	Instance methods

		// loading
		load( callback )		Loads the gif specified by the src or rel:animated_src sttributie of the img tag into a canvas element and then calls callback if one is passed
		load_url( src, callback )	Loads the gif file specified in the src argument into a canvas element and then calls callback if one is passed

		// play controls
		play -				Start playing the gif
		pause -				Stop playing the gif
		move_to(i) -		Move to frame i of the gif
		move_relative(i) -	Move i frames ahead (or behind if i < 0)

		// getters
		get_canvas			The canvas element that the gif is playing in. Handy for assigning event handlers to.
		get_playing			Whether or not the gif is currently playing
		get_loading			Whether or not the gif has finished loading/parsing
		get_auto_play		Whether or not the gif is set to play automatically
		get_length			The number of frames in the gif
		get_current_frame	The index of the currently displayed frame of the gif
		get_frames	        An array containing the data for all parsed frames
		get_duration	    Returns the duration of the gif in hundredths of a second (standard for GIF spec)
		get_duration_ms	    Returns the duration of the gif in milliseconds

		For additional customization (viewport inside iframe) these params may be passed:
		c_w, c_h - width and height of canvas
		vp_t, vp_l, vp_ w, vp_h - top, left, width and height of the viewport

		A bonus: few articles to understand what is going on
			http://enthusiasms.org/post/16976438906
			http://www.matthewflickinger.com/lab/whatsinagif/bits_and_bytes.asp
			http://humpy77.deviantart.com/journal/Frame-Delay-Times-for-Animated-GIFs-214150546

*/
(function (root, factory) {
    if (true) {
        !(__WEBPACK_AMD_DEFINE_ARRAY__ = [], __WEBPACK_AMD_DEFINE_FACTORY__ = (factory),
		__WEBPACK_AMD_DEFINE_RESULT__ = (typeof __WEBPACK_AMD_DEFINE_FACTORY__ === 'function' ?
		(__WEBPACK_AMD_DEFINE_FACTORY__.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__)) : __WEBPACK_AMD_DEFINE_FACTORY__),
		__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
    } else // removed by dead control flow
{}
}(this, function () {
    // Generic functions
    var bitsToNum = function (ba) {
        return ba.reduce(function (s, n) {
            return s * 2 + n;
        }, 0);
    };

    var byteToBitArr = function (bite) {
        var a = [];
        for (var i = 7; i >= 0; i--) {
            a.push( !! (bite & (1 << i)));
        }
        return a;
    };

    // Stream
    /**
     * @constructor
     */
    // Make compiler happy.
    var Stream = function (data) {
        this.data = data;
        this.len = this.data.length;
        this.pos = 0;

        this.readByte = function () {
            if (this.pos >= this.data.length) {
                throw new Error('Attempted to read past end of stream.');
            }
            if (data instanceof Uint8Array)
                return data[this.pos++];
            else
                return data.charCodeAt(this.pos++) & 0xFF;
        };

        this.readBytes = function (n) {
            var bytes = [];
            for (var i = 0; i < n; i++) {
                bytes.push(this.readByte());
            }
            return bytes;
        };

        this.read = function (n) {
            var s = '';
            for (var i = 0; i < n; i++) {
                s += String.fromCharCode(this.readByte());
            }
            return s;
        };

        this.readUnsigned = function () { // Little-endian.
            var a = this.readBytes(2);
            return (a[1] << 8) + a[0];
        };
    };

    var lzwDecode = function (minCodeSize, data) {
        // TODO: Now that the GIF parser is a bit different, maybe this should get an array of bytes instead of a String?
        var pos = 0; // Maybe this streaming thing should be merged with the Stream?
        var readCode = function (size) {
            var code = 0;
            for (var i = 0; i < size; i++) {
                if (data.charCodeAt(pos >> 3) & (1 << (pos & 7))) {
                    code |= 1 << i;
                }
                pos++;
            }
            return code;
        };

        var output = [];

        var clearCode = 1 << minCodeSize;
        var eoiCode = clearCode + 1;

        var codeSize = minCodeSize + 1;

        var dict = [];

        var clear = function () {
            dict = [];
            codeSize = minCodeSize + 1;
            for (var i = 0; i < clearCode; i++) {
                dict[i] = [i];
            }
            dict[clearCode] = [];
            dict[eoiCode] = null;

        };

        var code;
        var last;

        while (true) {
            last = code;
            code = readCode(codeSize);

            if (code === clearCode) {
                clear();
                continue;
            }
            if (code === eoiCode) break;

            if (code < dict.length) {
                if (last !== clearCode) {
                    dict.push(dict[last].concat(dict[code][0]));
                }
            }
            else {
                if (code !== dict.length) throw new Error('Invalid LZW code.');
                dict.push(dict[last].concat(dict[last][0]));
            }
            output.push.apply(output, dict[code]);

            if (dict.length === (1 << codeSize) && codeSize < 12) {
                // If we're at the last code and codeSize is 12, the next code will be a clearCode, and it'll be 12 bits long.
                codeSize++;
            }
        }

        // I don't know if this is technically an error, but some GIFs do it.
        //if (Math.ceil(pos / 8) !== data.length) throw new Error('Extraneous LZW bytes.');
        return output;
    };


    // The actual parsing; returns an object with properties.
    var parseGIF = function (st, handler) {
        handler || (handler = {});

        // LZW (GIF-specific)
        var parseCT = function (entries) { // Each entry is 3 bytes, for RGB.
            var ct = [];
            for (var i = 0; i < entries; i++) {
                ct.push(st.readBytes(3));
            }
            return ct;
        };

        var readSubBlocks = function () {
            var size, data;
            data = '';
            do {
                size = st.readByte();
                data += st.read(size);
            } while (size !== 0);
            return data;
        };

        var parseHeader = function () {
            var hdr = {};
            hdr.sig = st.read(3);
            hdr.ver = st.read(3);
            if (hdr.sig !== 'GIF') throw new Error('Not a GIF file.'); // XXX: This should probably be handled more nicely.
            hdr.width = st.readUnsigned();
            hdr.height = st.readUnsigned();

            var bits = byteToBitArr(st.readByte());
            hdr.gctFlag = bits.shift();
            hdr.colorRes = bitsToNum(bits.splice(0, 3));
            hdr.sorted = bits.shift();
            hdr.gctSize = bitsToNum(bits.splice(0, 3));

            hdr.bgColor = st.readByte();
            hdr.pixelAspectRatio = st.readByte(); // if not 0, aspectRatio = (pixelAspectRatio + 15) / 64
            if (hdr.gctFlag) {
                hdr.gct = parseCT(1 << (hdr.gctSize + 1));
            }
            handler.hdr && handler.hdr(hdr);
        };

        var parseExt = function (block) {
            var parseGCExt = function (block) {
                var blockSize = st.readByte(); // Always 4
                var bits = byteToBitArr(st.readByte());
                block.reserved = bits.splice(0, 3); // Reserved; should be 000.
                block.disposalMethod = bitsToNum(bits.splice(0, 3));
                block.userInput = bits.shift();
                block.transparencyGiven = bits.shift();

                block.delayTime = st.readUnsigned();

                block.transparencyIndex = st.readByte();

                block.terminator = st.readByte();

                handler.gce && handler.gce(block);
            };

            var parseComExt = function (block) {
                block.comment = readSubBlocks();
                handler.com && handler.com(block);
            };

            var parsePTExt = function (block) {
                // No one *ever* uses this. If you use it, deal with parsing it yourself.
                var blockSize = st.readByte(); // Always 12
                block.ptHeader = st.readBytes(12);
                block.ptData = readSubBlocks();
                handler.pte && handler.pte(block);
            };

            var parseAppExt = function (block) {
                var parseNetscapeExt = function (block) {
                    var blockSize = st.readByte(); // Always 3
                    block.unknown = st.readByte(); // ??? Always 1? What is this?
                    block.iterations = st.readUnsigned();
                    block.terminator = st.readByte();
                    handler.app && handler.app.NETSCAPE && handler.app.NETSCAPE(block);
                };

                var parseUnknownAppExt = function (block) {
                    block.appData = readSubBlocks();
                    // FIXME: This won't work if a handler wants to match on any identifier.
                    handler.app && handler.app[block.identifier] && handler.app[block.identifier](block);
                };

                var blockSize = st.readByte(); // Always 11
                block.identifier = st.read(8);
                block.authCode = st.read(3);
                switch (block.identifier) {
                    case 'NETSCAPE':
                        parseNetscapeExt(block);
                        break;
                    default:
                        parseUnknownAppExt(block);
                        break;
                }
            };

            var parseUnknownExt = function (block) {
                block.data = readSubBlocks();
                handler.unknown && handler.unknown(block);
            };

            block.label = st.readByte();
            switch (block.label) {
                case 0xF9:
                    block.extType = 'gce';
                    parseGCExt(block);
                    break;
                case 0xFE:
                    block.extType = 'com';
                    parseComExt(block);
                    break;
                case 0x01:
                    block.extType = 'pte';
                    parsePTExt(block);
                    break;
                case 0xFF:
                    block.extType = 'app';
                    parseAppExt(block);
                    break;
                default:
                    block.extType = 'unknown';
                    parseUnknownExt(block);
                    break;
            }
        };

        var parseImg = function (img) {
            var deinterlace = function (pixels, width) {
                // Of course this defeats the purpose of interlacing. And it's *probably*
                // the least efficient way it's ever been implemented. But nevertheless...
                var newPixels = new Array(pixels.length);
                var rows = pixels.length / width;
                var cpRow = function (toRow, fromRow) {
                    var fromPixels = pixels.slice(fromRow * width, (fromRow + 1) * width);
                    newPixels.splice.apply(newPixels, [toRow * width, width].concat(fromPixels));
                };

                // See appendix E.
                var offsets = [0, 4, 2, 1];
                var steps = [8, 8, 4, 2];

                var fromRow = 0;
                for (var pass = 0; pass < 4; pass++) {
                    for (var toRow = offsets[pass]; toRow < rows; toRow += steps[pass]) {
                        cpRow(toRow, fromRow)
                        fromRow++;
                    }
                }

                return newPixels;
            };

            img.leftPos = st.readUnsigned();
            img.topPos = st.readUnsigned();
            img.width = st.readUnsigned();
            img.height = st.readUnsigned();

            var bits = byteToBitArr(st.readByte());
            img.lctFlag = bits.shift();
            img.interlaced = bits.shift();
            img.sorted = bits.shift();
            img.reserved = bits.splice(0, 2);
            img.lctSize = bitsToNum(bits.splice(0, 3));

            if (img.lctFlag) {
                img.lct = parseCT(1 << (img.lctSize + 1));
            }

            img.lzwMinCodeSize = st.readByte();

            var lzwData = readSubBlocks();

            img.pixels = lzwDecode(img.lzwMinCodeSize, lzwData);

            if (img.interlaced) { // Move
                img.pixels = deinterlace(img.pixels, img.width);
            }

            handler.img && handler.img(img);
        };

        var parseBlock = function () {
            var block = {};
            block.sentinel = st.readByte();

            switch (String.fromCharCode(block.sentinel)) { // For ease of matching
                case '!':
                    block.type = 'ext';
                    parseExt(block);
                    break;
                case ',':
                    block.type = 'img';
                    parseImg(block);
                    break;
                case ';':
                    block.type = 'eof';
                    handler.eof && handler.eof(block);
                    break;
                default:
                    throw new Error('Unknown block: 0x' + block.sentinel.toString(16)); // TODO: Pad this with a 0.
            }

            if (block.type !== 'eof') setTimeout(parseBlock, 0);
        };

        var parse = function () {
            parseHeader();
            setTimeout(parseBlock, 0);
        };

        parse();
    };

    var SuperGif = function ( opts ) {
        var options = {
            //viewport position
            vp_l: 0,
            vp_t: 0,
            vp_w: null,
            vp_h: null,
            //canvas sizes
            c_w: null,
            c_h: null
        };
        for (var i in opts ) { options[i] = opts[i] }
        if (options.vp_w && options.vp_h) options.is_vp = true;

        var stream;
        var hdr;

        var loadError = null;
        var loading = false;

        var transparency = null;
        var delay = null;
        var disposalMethod = null;
        var disposalRestoreFromIdx = null;
        var lastDisposalMethod = null;
        var frame = null;
        var lastImg = null;

        var playing = true;
        var forward = true;

        var ctx_scaled = false;

        var frames = [];
        var frameOffsets = []; // elements have .x and .y properties

        var gif = options.gif;
        if (typeof options.auto_play == 'undefined')
            options.auto_play = (!gif.getAttribute('rel:auto_play') || gif.getAttribute('rel:auto_play') == '1');

        var onEndListener = (options.hasOwnProperty('on_end') ? options.on_end : null);
        var onErrorListener = (options.hasOwnProperty('on_error') ? options.on_error : null);
        var loopDelay = (options.hasOwnProperty('loop_delay') ? options.loop_delay : 0);
        var overrideLoopMode = (options.hasOwnProperty('loop_mode') ? options.loop_mode : 'auto');
        var drawWhileLoading = (options.hasOwnProperty('draw_while_loading') ? options.draw_while_loading : true);
        var showProgressBar = drawWhileLoading ? (options.hasOwnProperty('show_progress_bar') ? options.show_progress_bar : true) : false;
        var progressBarHeight = (options.hasOwnProperty('progressbar_height') ? options.progressbar_height : 25);
        var progressBarBackgroundColor = (options.hasOwnProperty('progressbar_background_color') ? options.progressbar_background_color : 'rgba(255,255,255,0.4)');
        var progressBarForegroundColor = (options.hasOwnProperty('progressbar_foreground_color') ? options.progressbar_foreground_color : 'rgba(255,0,22,.8)');

        var clear = function () {
            transparency = null;
            delay = null;
            lastDisposalMethod = disposalMethod;
            disposalMethod = null;
            frame = null;
        };

        // XXX: There's probably a better way to handle catching exceptions when
        // callbacks are involved.
        var doParse = function () {
            try {
                parseGIF(stream, handler);
            }
            catch (err) {
                doLoadError('parse');
            }
        };

        var doText = function (text) {
            toolbar.innerHTML = text; // innerText? Escaping? Whatever.
            toolbar.style.visibility = 'visible';
        };

        var setSizes = function(w, h) {
            canvas.width = w * get_canvas_scale();
            canvas.height = h * get_canvas_scale();
            toolbar.style.minWidth = ( w * get_canvas_scale() ) + 'px';

            tmpCanvas.width = w;
            tmpCanvas.height = h;
            tmpCanvas.style.width = w + 'px';
            tmpCanvas.style.height = h + 'px';
            tmpCanvas.getContext('2d', { willReadFrequently: true }).setTransform(1, 0, 0, 1, 0, 0);
        };

        var setFrameOffset = function(frame, offset) {
            if (!frameOffsets[frame]) {
                frameOffsets[frame] = offset;
                return;
            }
            if (typeof offset.x !== 'undefined') {
                frameOffsets[frame].x = offset.x;
            }
            if (typeof offset.y !== 'undefined') {
                frameOffsets[frame].y = offset.y;
            }
        };

        var doShowProgress = function (pos, length, draw) {
            if (draw && showProgressBar) {
                var height = progressBarHeight;
                var left, mid, top, width;
                if (options.is_vp) {
                    if (!ctx_scaled) {
                        top = (options.vp_t + options.vp_h - height);
                        height = height;
                        left = options.vp_l;
                        mid = left + (pos / length) * options.vp_w;
                        width = canvas.width;
                    } else {
                        top = (options.vp_t + options.vp_h - height) / get_canvas_scale();
                        height = height / get_canvas_scale();
                        left = (options.vp_l / get_canvas_scale() );
                        mid = left + (pos / length) * (options.vp_w / get_canvas_scale());
                        width = canvas.width / get_canvas_scale();
                    }
                    //some debugging, draw rect around viewport
                    if (false) // removed by dead control flow
{ var w, h, l, t; }
                }
                else {
                    top = (canvas.height - height) / (ctx_scaled ? get_canvas_scale() : 1);
                    mid = ((pos / length) * canvas.width) / (ctx_scaled ? get_canvas_scale() : 1);
                    width = canvas.width / (ctx_scaled ? get_canvas_scale() : 1 );
                    height /= ctx_scaled ? get_canvas_scale() : 1;
                }

                ctx.fillStyle = progressBarBackgroundColor;
                ctx.fillRect(mid, top, width - mid, height);

                ctx.fillStyle = progressBarForegroundColor;
                ctx.fillRect(0, top, mid, height);
            }
        };

        var doLoadError = function (originOfError) {
            var drawError = function () {
                ctx.fillStyle = 'black';
                ctx.fillRect(0, 0, options.c_w ? options.c_w : hdr.width, options.c_h ? options.c_h : hdr.height);
                ctx.strokeStyle = 'red';
                ctx.lineWidth = 3;
                ctx.moveTo(0, 0);
                ctx.lineTo(options.c_w ? options.c_w : hdr.width, options.c_h ? options.c_h : hdr.height);
                ctx.moveTo(0, options.c_h ? options.c_h : hdr.height);
                ctx.lineTo(options.c_w ? options.c_w : hdr.width, 0);
                ctx.stroke();
            };

            loadError = originOfError;
            hdr = {
                width: gif.width,
                height: gif.height
            }; // Fake header.
            frames = [];
            drawError();

            if (originOfError)
                onErrorListener ?.(originOfError);
        };

        var doHdr = function (_hdr) {
            hdr = _hdr;
            setSizes(hdr.width, hdr.height)
        };

        var doGCE = function (gce) {
            pushFrame();
            clear();
            transparency = gce.transparencyGiven ? gce.transparencyIndex : null;
            delay = gce.delayTime;
            disposalMethod = gce.disposalMethod;
            // We don't have much to do with the rest of GCE.
        };

        var pushFrame = function () {
            if (!frame) return;
            frames.push({
                            data: frame.getImageData(0, 0, hdr.width, hdr.height),
                            delay: delay
                        });
            frameOffsets.push({ x: 0, y: 0 });
        };

        var doImg = function (img) {
            if (!frame) frame = tmpCanvas.getContext('2d', { willReadFrequently: true });

            var currIdx = frames.length;

            //ct = color table, gct = global color table
            var ct = img.lctFlag ? img.lct : hdr.gct; // TODO: What if neither exists?

            /*
            Disposal method indicates the way in which the graphic is to
            be treated after being displayed.

            Values :    0 - No disposal specified. The decoder is
                            not required to take any action.
                        1 - Do not dispose. The graphic is to be left
                            in place.
                        2 - Restore to background color. The area used by the
                            graphic must be restored to the background color.
                        3 - Restore to previous. The decoder is required to
                            restore the area overwritten by the graphic with
                            what was there prior to rendering the graphic.

                            Importantly, "previous" means the frame state
                            after the last disposal of method 0, 1, or 2.
            */
            if (currIdx > 0) {
                if (lastDisposalMethod === 3) {
                    // Restore to previous
                    // If we disposed every frame including first frame up to this point, then we have
                    // no composited frame to restore to. In this case, restore to background instead.
                    if (disposalRestoreFromIdx !== null) {
                    	frame.putImageData(frames[disposalRestoreFromIdx].data, 0, 0);
                    } else {
                    	frame.clearRect(lastImg.leftPos, lastImg.topPos, lastImg.width, lastImg.height);
                    }
                } else {
                    disposalRestoreFromIdx = currIdx - 1;
                }

                if (lastDisposalMethod === 2) {
                    // Restore to background color
                    // Browser implementations historically restore to transparent; we do the same.
                    // http://www.wizards-toolkit.org/discourse-server/viewtopic.php?f=1&t=21172#p86079
                    frame.clearRect(lastImg.leftPos, lastImg.topPos, lastImg.width, lastImg.height);
                }
            }
            // else, Undefined/Do not dispose.
            // frame contains final pixel data from the last frame; do nothing

            //Get existing pixels for img region after applying disposal method
            var imgData = frame.getImageData(img.leftPos, img.topPos, img.width, img.height);

            //apply color table colors
            img.pixels.forEach(function (pixel, i) {
                // imgData.data === [R,G,B,A,R,G,B,A,...]
                if (pixel !== transparency) {
                    imgData.data[i * 4 + 0] = ct[pixel][0];
                    imgData.data[i * 4 + 1] = ct[pixel][1];
                    imgData.data[i * 4 + 2] = ct[pixel][2];
                    imgData.data[i * 4 + 3] = 255; // Opaque.
                }
            });

            frame.putImageData(imgData, img.leftPos, img.topPos);

            if (!ctx_scaled) {
                ctx.scale(get_canvas_scale(),get_canvas_scale());
                ctx_scaled = true;
            }

            // We could use the on-page canvas directly, except that we draw a progress
            // bar for each image chunk (not just the final image).
            if (drawWhileLoading) {
                ctx.drawImage(tmpCanvas, 0, 0);
                drawWhileLoading = options.auto_play;
            }

            lastImg = img;
        };

        var player = (function () {
            var i = -1;
            var iterationCount = 0;

            var showingInfo = false;
            var pinned = false;

            /**
             * Gets the index of the frame "up next".
             * @returns {number}
             */
            var getNextFrameNo = function () {
                var delta = (forward ? 1 : -1);
                return (i + delta + frames.length) % frames.length;
            };

            var stepFrame = function (amount) { // XXX: Name is confusing.
                i = i + amount;

                putFrame();
            };

            var step = (function () {
                var stepping = false;

                var completeLoop = function () {
                    if (onEndListener !== null)
                        onEndListener(gif);
                    iterationCount++;

                    if (overrideLoopMode !== false || iterationCount < 0) {
                        doStep();
                    } else {
                        stepping = false;
                        playing = false;
                    }
                };

                var doStep = function () {
                    stepping = playing;
                    if (!stepping) return;

                    stepFrame(1);
                    var delay = frames[i].delay * 10;
                    if (!delay) delay = 100; // FIXME: Should this even default at all? What should it be?

                    var nextFrameNo = getNextFrameNo();
                    if (nextFrameNo === 0) {
                        delay += loopDelay;
                        setTimeout(completeLoop, delay);
                    } else {
                        setTimeout(doStep, delay);
                    }
                };

                return function () {
                    if (!stepping) setTimeout(doStep, 0);
                };
            }());

            var putFrame = function () {
                var offset;
                i = parseInt(i, 10);

                if (i > frames.length - 1){
                    i = 0;
                }

                if (i < 0){
                    i = 0;
                }

                offset = frameOffsets[i];

                tmpCanvas.getContext("2d", { willReadFrequently: true }).putImageData(frames[i].data, offset.x, offset.y);
                ctx.globalCompositeOperation = "copy";
                ctx.drawImage(tmpCanvas, 0, 0);
            };

            var play = function () {
                playing = true;
                step();
            };

            var pause = function () {
                playing = false;
            };


            return {
                init: function () {
                    if (loadError) return;

                    if ( ! (options.c_w && options.c_h) ) {
                        ctx.scale(get_canvas_scale(),get_canvas_scale());
                    }

                    if (options.auto_play) {
                        step();
                    }
                    else {
                        i = 0;
                        putFrame();
                    }
                },
                step: step,
                play: play,
                pause: pause,
                playing: playing,
                move_relative: stepFrame,
                current_frame: function() { return i; },
                length: function() { return frames.length },
                move_to: function ( frame_idx ) {
                    i = frame_idx;
                    putFrame();
                }
            }
        }());

        var doDecodeProgress = function (draw) {
            doShowProgress(stream.pos, stream.data.length, draw);
        };

        var doNothing = function () {};
        /**
         * @param{boolean=} draw Whether to draw progress bar or not; this is not idempotent because of translucency.
         *                       Note that this means that the text will be unsynchronized with the progress bar on non-frames;
         *                       but those are typically so small (GCE etc.) that it doesn't really matter. TODO: Do this properly.
         */
        var withProgress = function (fn, draw) {
            return function (block) {
                fn(block);
                doDecodeProgress(draw);
            };
        };


        var handler = {
            hdr: withProgress(doHdr),
            gce: withProgress(doGCE),
            com: withProgress(doNothing),
            // I guess that's all for now.
            app: {
                // TODO: Is there much point in actually supporting iterations?
                NETSCAPE: withProgress(doNothing)
            },
            img: withProgress(doImg, true),
            eof: function (block) {
                //toolbar.style.display = '';
                pushFrame();
                doDecodeProgress(false);
                if ( ! (options.c_w && options.c_h) ) {
                    canvas.width = hdr.width * get_canvas_scale();
                    canvas.height = hdr.height * get_canvas_scale();
                }
                player.init();
                loading = false;
                if (load_callback) {
                    load_callback(gif);
                }

            }
        };

        var init = function () {
            var parent = gif.parentNode;

            var div = document.createElement('div');
            canvas = document.createElement('canvas');
            ctx = canvas.getContext('2d', { willReadFrequently: true });
            toolbar = document.createElement('div');

            tmpCanvas = document.createElement('canvas');

            div.width = canvas.width = gif.width;
            div.height = canvas.height = gif.height;
            toolbar.style.minWidth = gif.width + 'px';

            div.className = 'jsgif';
            toolbar.className = 'jsgif_toolbar';
            div.appendChild(canvas);
            div.appendChild(toolbar);

            parent.insertBefore(div, gif);
            parent.removeChild(gif);

            if (options.c_w && options.c_h) setSizes(options.c_w, options.c_h);
            initialized=true;
        };

        var get_canvas_scale = function() {
            var scale;
            if (options.max_width && hdr && hdr.width > options.max_width) {
                scale = options.max_width / hdr.width;
            }
            else {
                scale = 1;
            }
            return scale;
        }

        var canvas, ctx, toolbar, tmpCanvas;
        var initialized = false;
        var load_callback = false;

        var load_setup = function(callback) {
            if (loading) return false;
            if (callback) load_callback = callback;
            else load_callback = false;

            loading = true;
            frames = [];
            clear();
            disposalRestoreFromIdx = null;
            lastDisposalMethod = null;
            frame = null;
            lastImg = null;

            return true;
        }

        var calculateDuration = function() {
            return frames.reduce(function(duration, frame) {
                return duration + frame.delay;
            }, 0);
        }

        return {
            // play controls
            play: player.play,
            pause: player.pause,
            move_relative: player.move_relative,
            move_to: player.move_to,

            // getters for instance vars
            get_playing      : function() { return playing },
            get_canvas       : function() { return canvas },
            get_canvas_scale : function() { return get_canvas_scale() },
            get_loading      : function() { return loading },
            get_auto_play    : function() { return options.auto_play },
            get_length       : function() { return player.length() },
            get_frames       : function() { return frames },
            get_duration     : function() { return calculateDuration() },
            get_duration_ms  : function() { return calculateDuration() * 10 },
            get_current_frame: function() { return player.current_frame() },
            load_url: function(src,callback){
                if (!load_setup(callback)) return;

                var h = new XMLHttpRequest();
                // new browsers (XMLHttpRequest2-compliant)
                h.open('GET', src, true);

                if ('overrideMimeType' in h) {
                    h.overrideMimeType('text/plain; charset=x-user-defined');
                }

                // old browsers (XMLHttpRequest-compliant)
                else if ('responseType' in h) {
                    h.responseType = 'arraybuffer';
                }

                // IE9 (Microsoft.XMLHTTP-compliant)
                else {
                    h.setRequestHeader('Accept-Charset', 'x-user-defined');
                }

                h.onloadstart = function() {
                    // Wait until connection is opened to replace the gif element with a canvas to avoid a blank img
                    if (!initialized) init();
                };
                h.onload = function(e) {
                    if (this.status != 200) {
                        doLoadError('xhr - response');
                    }
                    // emulating response field for IE9
                    if (!('response' in this)) {
                        this.response = new VBArray(this.responseText).toArray().map(String.fromCharCode).join('');
                    }
                    var data = this.response;
                    if (data.toString().indexOf("ArrayBuffer") > 0) {
                        data = new Uint8Array(data);
                    }

                    stream = new Stream(data);
                    setTimeout(doParse, 0);
                };
                h.onprogress = function (e) {
                    if (e.lengthComputable) doShowProgress(e.loaded, e.total, true);
                };
                h.onerror = function() { doLoadError('xhr'); };
                h.send();
            },
            load: function (callback) {
                this.load_url(gif.getAttribute('rel:animated_src') || gif.src,callback);
            },
            load_raw: function(arr, callback) {
                if (!load_setup(callback)) return;
                if (!initialized) init();
                stream = new Stream(arr);
                setTimeout(doParse, 0);
            },
            set_frame_offset: setFrameOffset
        };
    };

    return SuperGif;
}));




/***/ }),

/***/ 2315:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Fields_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(564);
/* harmony import */ var _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(8311);
/* harmony import */ var _Base_FieldDefinitionArray_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(6973);
/* harmony import */ var _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(8415);
/* harmony import */ var _Core_X3DSensorNode_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(5561);
/* harmony import */ var _X3DTimeDependentNode_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(8805);
/* harmony import */ var _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(8899);
/* harmony import */ var _standard_Math_Algorithm_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(4559);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(6707);









function TimeSensor (executionContext)
{
   _Core_X3DSensorNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A        .call (this, executionContext);
   _X3DTimeDependentNode_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .call (this, executionContext);

   this .addType (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .TimeSensor);

   this .addChildObjects (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .inputOutput, "range", new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFFloat (0, 0, 1)); // current, first, last (in fractions) - play range starting at current

   this .cycle    = 0;
   this .interval = 0;
   this .fraction = 0;
   this .first    = 0;
   this .last     = 1;
   this .scale    = 1;
}

Object .assign (Object .setPrototypeOf (TimeSensor .prototype, _Core_X3DSensorNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .prototype),
   _X3DTimeDependentNode_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .prototype,
{
   initialize ()
   {
      _Core_X3DSensorNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A        .prototype .initialize .call (this);
      _X3DTimeDependentNode_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .prototype .initialize .call (this);

      this ._cycleInterval .addInterest ("set_cycleInterval__", this);
      this ._range         .addInterest ("set_range__",         this);
   },
   setRange (fraction, firstFraction, lastFraction, offset)
   {
      const
         currentTime   = this .getBrowser () .getCurrentTime (),
         startTime     = this ._startTime .getValue (),
         cycleInterval = this ._cycleInterval .getValue ();

      this .first    = _standard_Math_Algorithm_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .clamp (firstFraction, 0, 1);
      this .last     = _standard_Math_Algorithm_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .clamp (lastFraction, 0, 1);
      this .scale    = this .last - this .first;
      this .interval = cycleInterval * this .scale;
      this .offset   = offset && this .interval ? (currentTime - startTime) / this .interval : 0;
      this .fraction = _standard_Math_Algorithm_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .fract (fraction + this .offset);
      this .cycle    = currentTime - (this .fraction - this .first) * cycleInterval;
   },
   set_cycleInterval__ ()
   {
      if (!this ._isActive .getValue ())
         return;

      this .setRange (this .fraction, this ._range [1], this ._range [2], false);
   },
   set_range__ ()
   {
      if (!this ._isActive .getValue ())
         return;

      this .setRange (this ._range [0], this ._range [1], this ._range [2], false);

      if (this ._isPaused .getValue ())
         return;

      this .set_fraction (this .getBrowser () .getCurrentTime ());
   },
   set_start ()
   {
      this .setRange (this ._range [0], this ._range [1], this ._range [2], true);

      const time = this .getBrowser () .getCurrentTime ();

      this ._time             = time;
      this ._cycleTime        = time;
      this ._fraction_changed = this .fraction;
   },
   set_resume (pauseInterval)
   {
      this .setRange (this .fraction, this ._range [1], this ._range [2], false);
   },
   set_fraction (time)
   {
      const fraction = this .first + (this .interval ? _standard_Math_Algorithm_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .fract ((time - this .cycle) / this .interval) : 0) * this .scale;

      this .fraction          = fraction;
      this ._fraction_changed = fraction;
   },
   set_time ()
   {
      // The event order below is very important.

      const time = this .getBrowser () .getCurrentTime ();

      this ._time = time;

      if (time - this .cycle >= this .interval)
      {
         if (this ._loop .getValue ())
         {
            if (this .interval)
            {
               this .cycle += this .interval * Math .floor ((time - this .cycle) / this .interval);

               this ._elapsedTime = this .getElapsedTime ();
               this ._cycleTime   = time;

               this .set_fraction (time);
            }
         }
         else
         {
            this ._elapsedTime      = this .getElapsedTime ();
            this ._fraction_changed = this .fraction = this .last;

            this .stop ();
         }
      }
      else
      {
         this ._elapsedTime = this .getElapsedTime ();

         this .set_fraction (time);
      }
   },
   dispose ()
   {
      _X3DTimeDependentNode_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .prototype .dispose .call (this);
      _Core_X3DSensorNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A        .prototype .dispose .call (this);
   },
});

Object .defineProperties (TimeSensor,
{
   ... _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .getStaticProperties ("TimeSensor", "Time", 1, "children", "2.0"),
   fieldDefinitions:
   {
      value: new _Base_FieldDefinitionArray_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A ([
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .inputOutput, "metadata",         new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFNode ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .inputOutput, "description",      new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFString ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .inputOutput, "enabled",          new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFBool (true)),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .inputOutput, "cycleInterval",    new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFTime (1)),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .inputOutput, "loop",             new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFBool ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .inputOutput, "startTime",        new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFTime (0)),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .inputOutput, "resumeTime",       new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFTime (0)),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .inputOutput, "pauseTime",        new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFTime (0)),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .inputOutput, "stopTime",         new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFTime (0)),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .outputOnly,  "isPaused",         new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFBool ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .outputOnly,  "isActive",         new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFBool ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .outputOnly,  "cycleTime",        new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFTime ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .outputOnly,  "elapsedTime",      new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFTime ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .outputOnly,  "fraction_changed", new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFFloat ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .outputOnly,  "time",             new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFTime ()),
      ]),
      enumerable: true,
   },
});

const __default__ = TimeSensor;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_8__/* ["default"] */ .A .add ("TimeSensor", __default__));

/***/ }),

/***/ 2512:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Base_X3DObject_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(3078);
/* harmony import */ var _Fields_SFNodeCache_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(6882);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(6707);



const
   _executionContext = Symbol (),
   _exportedName     = Symbol (),
   _localNode        = Symbol ();

function X3DExportedNode (executionContext, exportedName, localNode)
{
   _Base_X3DObject_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .call (this);

   this [_executionContext] = executionContext;
   this [_exportedName]     = exportedName;
   this [_localNode]        = localNode;
}

Object .assign (Object .setPrototypeOf (X3DExportedNode .prototype, _Base_X3DObject_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .prototype),
{
   getExecutionContext ()
   {
      return this [_executionContext];
   },
   getExportedName ()
   {
      return this [_exportedName];
   },
   getLocalNode ()
   {
      return this [_localNode];
   },
   toVRMLStream (generator)
   {
      const localName = generator .Name (this .getLocalNode ());

      generator .Indent ();
      generator .string += "EXPORT";
      generator .Space ();
      generator .string += localName;

      if (this [_exportedName] !== localName)
      {
         generator .Space ();
         generator .string += "AS";
         generator .Space ();
         generator .string += this [_exportedName];
      }
   },
   toXMLStream (generator)
   {
      const localName = generator .Name (this .getLocalNode ());

      generator .openTag ("EXPORT");
      generator .attribute ("localDEF", localName);

      if (this [_exportedName] !== localName)
         generator .attribute ("AS", this [_exportedName]);

      generator .closeTag ("EXPORT");
   },
   toJSONStream (generator)
   {
      const localName = generator .Name (this .getLocalNode ());

      generator .TidyBreak ();
      generator .Indent ();

      generator .beginObject ("EXPORT", false, true);
      generator .stringProperty ("@localDEF", localName, false);

      if (this [_exportedName] !== localName)
         generator .stringProperty ("@AS", this [_exportedName]);

      generator .endObject ();
      generator .endObject ();
   },
});

for (const key of Object .keys (X3DExportedNode .prototype))
   Object .defineProperty (X3DExportedNode .prototype, key, { enumerable: false });

Object .defineProperties (X3DExportedNode .prototype,
{
   exportedName:
   {
      get ()
      {
         return this [_exportedName];
      },
      enumerable: true,
   },
   localNode:
   {
      get ()
      {
         return _Fields_SFNodeCache_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .get (this [_localNode]);
      },
      enumerable: true,
   },
});

Object .defineProperties (X3DExportedNode,
{
   typeName:
   {
      value: "X3DExportedNode",
      enumerable: true,
   },
});

const __default__ = X3DExportedNode;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .add ("X3DExportedNode", __default__));

/***/ }),

/***/ 2582:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  A: () => (/* binding */ Grouping_X3DBoundedObject)
});

// EXTERNAL MODULE: ./src/x_ite/Fields.js + 15 modules
var Fields = __webpack_require__(564);
// EXTERNAL MODULE: ./src/x_ite/Components/Core/X3DNode.js
var X3DNode = __webpack_require__(8415);
// EXTERNAL MODULE: ./src/x_ite/Base/X3DConstants.js
var X3DConstants = __webpack_require__(8899);
// EXTERNAL MODULE: ./src/x_ite/Base/X3DFieldDefinition.js
var X3DFieldDefinition = __webpack_require__(8311);
// EXTERNAL MODULE: ./src/x_ite/Base/FieldDefinitionArray.js
var FieldDefinitionArray = __webpack_require__(6973);
// EXTERNAL MODULE: ./src/x_ite/Components/Core/X3DChildNode.js
var X3DChildNode = __webpack_require__(8193);
// EXTERNAL MODULE: ./src/x_ite/Rendering/TraverseType.js
var TraverseType = __webpack_require__(834);
// EXTERNAL MODULE: ./src/standard/Math/Numbers/Matrix4.js
var Matrix4 = __webpack_require__(1048);
// EXTERNAL MODULE: ./src/standard/Math/Geometry/Box3.js
var Box3 = __webpack_require__(5837);
// EXTERNAL MODULE: ./src/standard/Math/Numbers/Vector3.js
var Vector3 = __webpack_require__(2639);
// EXTERNAL MODULE: ./src/x_ite/Namespace.js
var Namespace = __webpack_require__(6707);
;// ./src/x_ite/Browser/Grouping/X3DBBoxNode.js











function X3DBBoxNode (executionContext, boundedObject)
{
   X3DChildNode/* default */.A .call (this, executionContext);

   // Private properties

   this .boundedObject = boundedObject;
   this .bboxShape     = this .getBrowser () .getBBoxShape ();
}

Object .assign (Object .setPrototypeOf (X3DBBoxNode .prototype, X3DChildNode/* default */.A .prototype),
{
   getMatrix: (() =>
   {
      const
         bbox    = new Box3/* default */.A (),
         matrix  = new Matrix4/* default */.A (),
         epsilon = new Vector3/* default */.A (1e-6);

      return function ()
      {
         this .boundedObject .getBBox (bbox);

         const
            browser    = this .getBrowser (),
            max        = browser .getRenderingProperty ("ContentScale") === 1 ? Vector3/* default */.A .ZERO : epsilon,
            bboxSize   = bbox .size .max (max),
            bboxCenter = bbox .center;

         return matrix .set (bboxCenter, null, bboxSize);
      };
   })(),
   getShapes (shapes, parentModelMatrix)
   {
      const modelMatrix = parentModelMatrix .copy () .multLeft (this .getMatrix ());

      return this .bboxShape .getShapes (shapes, modelMatrix);
   },
   traverse (type, renderObject)
   {
      if (type === TraverseType/* default */.A .PICKING)
         return;

      const modelViewMatrix = renderObject .getModelViewMatrix ();

      modelViewMatrix .push ();
      modelViewMatrix .multLeft (this .getMatrix ());

      this .bboxShape .traverse (type, renderObject);

      modelViewMatrix .pop ();
   },
});

Object .defineProperties (X3DBBoxNode,
{
   ... X3DNode/* default */.A .getStaticProperties ("X3DBBoxNode", "Grouping", 1, "children", "2.0"),
   fieldDefinitions:
   {
      value: new FieldDefinitionArray/* default */.A ([
         new X3DFieldDefinition/* default */.A (X3DConstants/* default */.A .inputOutput, "metadata", new Fields/* default */.A .SFNode ()),
      ]),
      enumerable: true,
   },
});

const __default__ = X3DBBoxNode;
;

/* harmony default export */ const Grouping_X3DBBoxNode = (Namespace/* default */.A .add ("X3DBBoxNode", __default__));
;// ./src/x_ite/Components/Grouping/X3DBoundedObject.js







function X3DBoundedObject (executionContext)
{
   this .addType (X3DConstants/* default */.A .X3DBoundedObject);

   this .addChildObjects (X3DConstants/* default */.A .outputOnly, "hidden",           new Fields/* default */.A .SFBool (),
                          X3DConstants/* default */.A .outputOnly, "display",          new Fields/* default */.A .SFBool (true),
                          X3DConstants/* default */.A .outputOnly, "transformSensors", new Fields/* default */.A .SFTime ());

   // Units

   this ._bboxSize   .setUnit ("length");
   this ._bboxCenter .setUnit ("length");

   // Private properties

   this .childBBox            = new Box3/* default */.A (); // Must be unique for each X3DBoundedObject.
   this .transformSensorNodes = new Set ();
}

Object .assign (X3DBoundedObject .prototype,
{
   childBBox: new Box3/* default */.A (), // X3DExecutionContext needs this.
   initialize ()
   {
      this ._hidden  .addInterest ("set_visible_and_hidden__", this);
      this ._visible .addInterest ("set_visible_and_hidden__", this);

      this .set_visible_and_hidden__ ();
   },
   isVisible ()
   {
      return this ._display .getValue ();
   },
   isHidden ()
   {
      return this ._hidden .getValue ();
   },
   setHidden (value)
   {
      if (value === this ._hidden .getValue ())
         return;

      this ._hidden = value;
   },
   isDefaultBBoxSize: (() =>
   {
      const defaultBBoxSize = new Vector3/* default */.A (-1);

      return function ()
      {
         return this ._bboxSize .getValue () .equals (defaultBBoxSize);
      };
   })(),
   isBBoxVisible ()
   {
      return this ._bboxDisplay .getValue ();
   },
   getBBox (nodes, bbox, shadows)
   {
      // Must be unique for each X3DBoundedObject.
      const childBBox = this .childBBox;

      // Add bounding boxes.

      bbox .set ();

      for (const node of nodes)
         bbox .add (node .getBBox ?.(childBBox, shadows) ?? childBBox .set ());

      return bbox;
   },
   getBBoxNode ()
   {
      return this .bboxNode ??= (() =>
      {
         const bboxNode = new Grouping_X3DBBoxNode (this .getExecutionContext (), this);

         bboxNode .setPrivate (true);
         bboxNode .setup ();

         return bboxNode;
      })();
   },
   addTransformSensor (transformSensorNode)
   {
      this .transformSensorNodes .add (transformSensorNode);

      this ._transformSensors = this .getBrowser () .getCurrentTime ();
   },
   removeTransformSensor (transformSensorNode)
   {
      this .transformSensorNodes .delete (transformSensorNode);

      this ._transformSensors = this .getBrowser () .getCurrentTime ();
   },
   getTransformSensors ()
   {
      return this .transformSensorNodes;
   },
   set_visible_and_hidden__ ()
   {
      const value = this ._visible .getValue () && !this ._hidden .getValue ();

      if (value === this ._display .getValue ())
         return;

      this ._display = value;
   },
   dispose () { },
});

Object .defineProperties (X3DBoundedObject, X3DNode/* default */.A .getStaticProperties ("X3DBoundedObject", "Grouping", 1));

const X3DBoundedObject_default_ = X3DBoundedObject;
;

/* harmony default export */ const Grouping_X3DBoundedObject = (Namespace/* default */.A .add ("X3DBoundedObject", X3DBoundedObject_default_));

/***/ }),

/***/ 2639:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Algorithm_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(4559);
/* harmony import */ var _x_ite_Namespace_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(6707);


function Vector3 (x = 0, y = x, z = y)
{
   this .x = x;
   this .y = y;
   this .z = z;
}

Object .assign (Vector3 .prototype,
{
   *[Symbol .iterator] ()
   {
      yield this .x;
      yield this .y;
      yield this .z;
   },
   copy ()
   {
      const copy = Object .create (Vector3 .prototype);
      copy .x = this .x;
      copy .y = this .y;
      copy .z = this .z;
      return copy;
   },
   assign ({ x, y, z })
   {
      this .x = x;
      this .y = y;
      this .z = z;
      return this;
   },
   set (x = 0, y = x, z = y)
   {
      this .x = x;
      this .y = y;
      this .z = z;
      return this;
   },
   equals ({ x, y, z })
   {
      return this .x === x &&
             this .y === y &&
             this .z === z;
   },
   negate ()
   {
      this .x = -this .x;
      this .y = -this .y;
      this .z = -this .z;
      return this;
   },
   inverse ()
   {
      this .x = 1 / this .x;
      this .y = 1 / this .y;
      this .z = 1 / this .z;
      return this;
   },
   add ({ x, y, z })
   {
      this .x += x;
      this .y += y;
      this .z += z;
      return this;
   },
   subtract ({ x, y, z })
   {
      this .x -= x;
      this .y -= y;
      this .z -= z;
      return this;
   },
   multiply (value)
   {
      this .x *= value;
      this .y *= value;
      this .z *= value;
      return this;
   },
   multVec ({ x, y, z })
   {
      this .x *= x;
      this .y *= y;
      this .z *= z;
      return this;
   },
   divide (value)
   {
      this .x /= value;
      this .y /= value;
      this .z /= value;
      return this;
   },
   divVec ({ x, y, z })
   {
      this .x /= x;
      this .y /= y;
      this .z /= z;
      return this;
   },
   cross ({ x: bx, y: by, z: bz })
   {
      const { x: ax, y: ay, z: az } = this;

      this .x = ay * bz - az * by;
      this .y = az * bx - ax * bz;
      this .z = ax * by - ay * bx;

      return this;
   },
   normalize ()
   {
      const length = Math .hypot (this .x, this .y, this .z);

      if (length)
      {
         this .x /= length;
         this .y /= length;
         this .z /= length;
      }

      return this;
   },
   dot ({ x, y, z })
   {
      return this .x * x +
             this .y * y +
             this .z * z;
   },
   squaredNorm ()
   {
      const { x, y, z } = this;

      return x * x +
             y * y +
             z * z;
   },
   norm ()
   {
      return Math .hypot (this .x, this .y, this .z);
   },
   distance ({ x, y, z })
   {
      return Math .hypot (this .x - x,
                          this .y - y,
                          this .z - z);
   },
   lerp ({ x: dX, y: dY, z: dZ }, t)
   {
      const { x, y, z } = this;

      this .x = x + t * (dX - x);
      this .y = y + t * (dY - y);
      this .z = z + t * (dZ - z);
      return this;
   },
   slerp: (() =>
   {
      const tmp = new Vector3 ();

      return function (destination, t)
      {
         return _Algorithm_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .simpleSlerp (this, tmp .assign (destination), t);
      };
   })(),
   abs ()
   {
      const { x, y, z } = this;

      this .x = Math .abs (x);
      this .y = Math .abs (y);
      this .z = Math .abs (z);
      return this;
   },
   min (vector)
   {
      let { x, y, z } = this;

      for (const { x: minX, y: minY, z: minZ } of arguments)
      {
         x = Math .min (x, minX);
         y = Math .min (y, minY);
         z = Math .min (z, minZ);
      }

      this .x = x;
      this .y = y;
      this .z = z;
      return this;
   },
   max (vector)
   {
      let { x, y, z } = this;

      for (const { x: maxX, y: maxY, z: maxZ } of arguments)
      {
         x = Math .max (x, maxX);
         y = Math .max (y, maxY);
         z = Math .max (z, maxZ);
      }

      this .x = x;
      this .y = y;
      this .z = z;
      return this;
   },
   clamp ({ x: minX, y: minY, z: minZ }, { x: maxX, y: maxY, z: maxZ })
   {
      this .x = _Algorithm_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .clamp (this .x, minX, maxX);
      this .y = _Algorithm_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .clamp (this .y, minY, maxY);
      this .z = _Algorithm_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .clamp (this .z, minZ, maxZ);
      return this;
   },
   toString ()
   {
      return this .x + " " +
             this .y + " " +
             this .z;
   }
});

for (const key of Object .keys (Vector3 .prototype))
   Object .defineProperty (Vector3 .prototype, key, { enumerable: false });

Object .defineProperties (Vector3 .prototype,
{
   length: { value: 3 },
   0:
   {
      get () { return this .x; },
      set (value) { this .x = value; },
   },
   1:
   {
      get () { return this .y; },
      set (value) { this .y = value; },
   },
   2:
   {
      get () { return this .z; },
      set (value) { this .z = value; },
   },
});

Object .assign (Vector3,
{
   ZERO: Object .freeze (new Vector3 ()),
   // Positive values
   ONE: Object .freeze (new Vector3 (1)),
   X_AXIS: Object .freeze (new Vector3 (1, 0, 0)),
   Y_AXIS: Object .freeze (new Vector3 (0, 1, 0)),
   Z_AXIS: Object .freeze (new Vector3 (0, 0, 1)),
   // Negative values
   NEGATIVE_ONE: Object .freeze (new Vector3 (-1)),
   NEGATIVE_X_AXIS: Object .freeze (new Vector3 (-1, 0, 0)),
   NEGATIVE_Y_AXIS: Object .freeze (new Vector3 (0, -1, 0)),
   NEGATIVE_Z_AXIS: Object .freeze (new Vector3 (0, 0, -1)),
});

const __default__ = Vector3;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_x_ite_Namespace_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .add ("Vector3", __default__));

/***/ }),

/***/ 2731:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Base_X3DInfoArray_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(4635);
/* harmony import */ var _Fields_SFNode_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(1426);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(6707);



function NamedNodesArray (values = [ ])
{
   return _Base_X3DInfoArray_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .call (this, Array .from (values, value => [value .getNodeName (), value]), _Fields_SFNode_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A);
}

Object .setPrototypeOf (NamedNodesArray .prototype, _Base_X3DInfoArray_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .prototype);

for (const key of Object .keys (NamedNodesArray .prototype))
   Object .defineProperty (NamedNodesArray .prototype, key, { enumerable: false });

Object .defineProperties (NamedNodesArray,
{
   typeName:
   {
      value: "NamedNodesArray",
      enumerable: true,
   },
});

const __default__ = NamedNodesArray;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .add ("NamedNodesArray", __default__));

/***/ }),

/***/ 2850:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6707);
const __default__ = "12.2.3";
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .add ("BROWSER_VERSION", __default__));

/***/ }),

/***/ 2887:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Fields_SFNode_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(1426);
/* harmony import */ var _Base_X3DBaseNode_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(7982);
/* harmony import */ var _Components_Layering_LayerSet_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(5289);
/* harmony import */ var _Components_Layering_Layer_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(1785);
/* harmony import */ var _Base_X3DCast_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(4667);
/* harmony import */ var _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(8899);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(6707);







function X3DWorld (executionContext)
{
   _Base_X3DBaseNode_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .call (this, executionContext);

   this .addType (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .X3DWorld)

   this .addChildObjects (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .outputOnly, "activeLayer", new _Fields_SFNode_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A (this .layer0));

   this .defaultLayerSet = new _Components_Layering_LayerSet_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A (executionContext);
   this .layerSet        = this .defaultLayerSet;
   this .layer0          = new _Components_Layering_Layer_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A (executionContext);
}

Object .assign (Object .setPrototypeOf (X3DWorld .prototype, _Base_X3DBaseNode_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .prototype),
{
   initialize ()
   {
      _Base_X3DBaseNode_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .prototype .initialize .call (this);

      this .layerSet .setPrivate (true);
      this .layerSet .setup ();
      this .layerSet .setLayer0 (this .layer0);
      this .layerSet ._activeLayer .addInterest ("set_rootNodes__", this);

      this .getExecutionContext () .getRootNodes () .addInterest ("set_rootNodes__", this);

      this .set_rootNodes__ ();

      this .layer0 .setPrivate (true);
      this .layer0 .setLayer0 (true);
      this .layer0 .setup ();

      this .set_activeLayer__ ();
   },
   getCache ()
   {
      return this .getBrowser () .getBrowserOption ("Cache");
   },
   getLayerSet ()
   {
      return this .layerSet;
   },
   getActiveLayer ()
   {
      return this ._activeLayer .getValue ();
   },
   getLayer0 ()
   {
      return this .layer0;
   },
   set_rootNodes__ ()
   {
      const
         oldLayerSet = this .layerSet,
         rootNodes   = this .getExecutionContext () .getRootNodes ();

      this .layerSet          = this .defaultLayerSet;
      this .layer0 ._children = rootNodes;

      for (const rootNode of rootNodes)
      {
         const layerSet = (0,_Base_X3DCast_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A) (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .LayerSet, rootNode);

         if (layerSet)
            this .layerSet = layerSet;
      }

      if (this .layerSet === oldLayerSet)
         return;

      this .layerSet .setLayer0 (this .layer0);

      oldLayerSet    ._activeLayerNode .removeInterest ("set_activeLayer__", this);
      this .layerSet ._activeLayerNode .addInterest    ("set_activeLayer__", this);

      this .set_activeLayer__ ();
   },
   set_activeLayer__ ()
   {
      this ._activeLayer = this .layerSet .getActiveLayer ();
   },
   bindBindables ()
   {
      // Bind first X3DBindableNodes found in each layer.

      const worldURL = this .getExecutionContext () .getWorldURL ();

      this .layerSet .bindBindables (decodeURIComponent (new URL (worldURL) .hash .substring (1)));
   },
   traverse (type, renderObject)
   {
      this .layerSet .traverse (type, renderObject);
   },
});

for (const key of Object .keys (X3DWorld .prototype))
   Object .defineProperty (X3DWorld .prototype, key, { enumerable: false });

Object .defineProperties (X3DWorld,
{
   typeName:
   {
      value: "X3DWorld",
      enumerable: true,
   },
});

_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .addConstant (X3DWorld .typeName);

const __default__ = X3DWorld;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .add ("X3DWorld", __default__));

/***/ }),

/***/ 2907:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Base_X3DChildObject_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(7503);
/* harmony import */ var _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(8899);
/* harmony import */ var _X3DNode_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(8415);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(6707);
/* provided dependency */ var $ = __webpack_require__(7682);




const
   _importedName = Symbol (),
   _importedNode = Symbol (),
   _type         = Symbol ();

const handler =
{
   get (target, key)
   {
      if (key in target)
         return target [key];

      const
         node     = target .getSharedNode (),
         property = node ?.[key];

      if (typeof property === "function")
         return property .bind (node);

      return property;
   },
   set (target, key, value)
   {
      if (key in target)
      {
         target [key] = value;
      }
      else
      {
         const node = target .getSharedNode ();

         if (node)
            node [key] = value;
      }

      return true;
   },
   has (target, key)
   {
      return key in (target .getSharedNode () ?? { });
   },
   ownKeys (target)
   {
      return Object .keys (target .getSharedNode () ?? { });
   },
   getOwnPropertyDescriptor (target, key)
   {
      return Object .getOwnPropertyDescriptor (target .getSharedNode () ?? { }, key);
   },
}

function X3DImportedNodeProxy (executionContext, importedName, type)
{
   _X3DNode_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .call (this, executionContext);

   const proxy = new Proxy (this, handler);

   this [_importedName] = importedName;
   this [_type]         = type;

   this .setup ();

   return proxy;
}

Object .assign (Object .setPrototypeOf (X3DImportedNodeProxy .prototype, _X3DNode_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .prototype),
{
   initialize ()
   {
      _X3DNode_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .prototype .initialize .call (this);

      this .getExecutionContext () .importedNodes .addInterest ("update", this);

      this .update ();
   },
   getExtendedEventHandling ()
   {
      return false;
   },
   setTypeHint (value)
   {
      this [_type] ??= value;
   },
   getSharedNode ()
   {
      return $.try (() => this [_importedNode] .getSharedNode ()) ?? null;
   },
   getImportedNode ()
   {
      return this [_importedNode];
   },
   getInnerNode ()
   {
      return this [_importedNode] .getSharedNode () .getInnerNode ();
   },
   getName ()
   {
      return this [_importedName];
   },
   setName (value)
   {
      this [_importedName] = value;

      this ._name_changed = Date .now () / 1000;
   },
   ... Object .fromEntries ([
      ["getComponentInfo",      "componentInfo"],
      ["getContainerField",     "containerField"],
      ["getSpecificationRange", "specificationRange"],
      ["getTypeName",           "typeName"],
   ]
   .map (([fn, property]) => [fn, function ()
   {
      return this .getSharedNode () ?.[fn] () ?? this .constructor [property];
   }])),
   ... Object .fromEntries ([
      "getType",
      "getFieldDefinitions",
      "getPredefinedField",
      "getPredefinedFields",
      "getUserDefinedField",
      "getUserDefinedFields",
      "getField",
      "getFields",
      "getChangedFields",
      "isDefaultValue",
      "hasRoutes",
   ]
   .map (fn => [fn, function (... args)
   {
      return this .getSharedNode () ?.[fn] (... args) ?? _X3DNode_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .prototype [fn] .call (this, ... args);
   }])),
   update ()
   {
      const importedNode = this .getExecutionContext () .getImportedNodes () .get (this [_importedName])
         ?? null;

      this [_importedNode] ?.getInlineNode () ._loadState .removeInterest ("set_loadState__", this);

      this [_importedNode] = importedNode;

      this [_importedNode] ?.getInlineNode () ._loadState .addInterest ("set_loadState__", this);

      this .set_loadState__ ();
   },
   set_loadState__ ()
   {
      if (this [_importedNode] ?.getInlineNode () .checkLoadState () === _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .COMPLETE_STATE)
         this [_type] = this .getSharedNode () ?.constructor ?? this [_type];

      this ._typeName_changed = Date .now () / 1000;

      _Base_X3DChildObject_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .prototype .addEvent .call (this);
   },
   toVRMLStream (generator)
   {
      generator .CheckSpace ();
      generator .string += "USE";
      generator .Space ();
      generator .string += this [_importedName];
      generator .NeedsSpace ();
   },
   toXMLStream (generator)
   {
      generator .openTag (this .getTypeName ());

      if (generator .html && this .getTypeName () === "Script")
         generator .attribute ("type", "model/x3d+xml");

      generator .attribute ("USE", this [_importedName]);
      generator .containerField (this .getContainerField ());
      generator .closeTag (this .getTypeName ());
   },
   toJSONStream (generator)
   {
      generator .beginObject (this .getTypeName (), false, true);
      generator .stringProperty ("@USE", this [_importedName], false);
      generator .endObject ();
      generator .endObject ();
   },
});

Object .defineProperties (X3DImportedNodeProxy .prototype,
{
   constructor:
   {
      get ()
      {
         return this [_type] ?? _X3DNode_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A;
      },
   }
});

Object .defineProperties (X3DImportedNodeProxy, _X3DNode_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .getStaticProperties ("X3DImportedNodeProxy", "Core", 2, "children", "4.1"));

const __default__ = X3DImportedNodeProxy;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .add ("X3DImportedNodeProxy", __default__));

/***/ }),

/***/ 2939:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6707);
let i = 0;

const AlphaMode =
{
   AUTO:   i ++, // Must be zero!
   OPAQUE: i ++,
   MASK:   i ++,
   BLEND:  i ++,
};

const __default__ = Object .assign (new Map (Object .entries (AlphaMode)), AlphaMode);
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .add ("AlphaMode", __default__));

/***/ }),

/***/ 3012:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  A: () => (/* binding */ Numbers_Matrix3)
});

// EXTERNAL MODULE: ./src/standard/Math/Numbers/Vector2.js
var Vector2 = __webpack_require__(8024);
// EXTERNAL MODULE: ./src/standard/Math/Numbers/Vector3.js
var Vector3 = __webpack_require__(2639);
// EXTERNAL MODULE: ./src/x_ite/Namespace.js
var Namespace = __webpack_require__(6707);
;// ./src/standard/Math/Numbers/Matrix2.js


function Matrix2 (... args)
{
   if (args .length)
   {
      for (let i = 0; i < 4; ++ i)
         this [i] = args [i];
   }
   else
   {
      this .identity ();
   }
}

Object .assign (Matrix2 .prototype,
{
   *[Symbol .iterator] ()
   {
      for (let i = 0; i < 4; ++ i)
         yield this [i];
   },
   copy ()
   {
      const copy = Object .create (Matrix2 .prototype);

      for (let i = 0; i < 4; ++ i)
         copy [i] = this [i];

      return copy;
   },
   assign (matrix)
   {
      for (let i = 0; i < 4; ++ i)
         this [i] = matrix [i];

      return this;
   },
   equals (matrix)
   {
      return this [0] === matrix [0] &&
             this [1] === matrix [1] &&
             this [2] === matrix [2] &&
             this [3] === matrix [3];
   },
   set1 (r, c, value)
   {
      this [r * this .order + c] = value;
   },
   get1 (r, c)
   {
      return this [r * this .order + c];
   },
   set ()
   {
      switch (arguments .length)
      {
         case 0:
         {
            this .identity ();
            break;
         }
         case 4:
         {
            for (let i = 0; i < 4; ++ i)
               this [i] = arguments [i];

            break;
         }
      }

      return this;
   },
   determinant1 ()
   {
      return this [0];
   },
   determinant ()
   {
      const { 0: m0, 1: m1, 2: m2, 3: m3 } = this;

      return m0 * m3 - m1 * m2;
   },
   transpose ()
   {
      const tmp = this [1];

      this [1] = this [2];
      this [2] = tmp;

      return this;
   },
   inverse ()
   {
      const
         { 0: A, 1: B, 2: C, 3: D } = this,
         d = A * D - B * C;

      // if (d === 0) ... determinant is zero.

      this [0] =  D / d;
      this [1] = -B / d;
      this [2] = -C / d;
      this [3] =  A / d;

      return this;
   },
   multLeft (matrix)
   {
      const
         { 0: a0, 1: a1, 2: a2, 3: a3 } = this,
         { 0: b0, 1: b1, 2: b2, 3: b3 } = matrix;

      this [0] = a0 * b0 + a2 * b1;
      this [1] = a1 * b0 + a3 * b1;
      this [2] = a0 * b2 + a2 * b3;
      this [3] = a1 * b2 + a3 * b3;

      return this;
   },
   multRight (matrix)
   {
      const
         { 0: a0, 1: a1, 2: a2, 3: a3 } = this,
         { 0: b0, 1: b1, 2: b2, 3: b3 } = matrix;

      this [0] = b0 * a0 + b2 * a1;
      this [1] = b1 * a0 + b3 * a1;
      this [2] = b0 * a2 + b2 * a3;
      this [3] = b1 * a2 + b3 * a3;

      return this;
   },
   multVecMatrix (vector)
   {
      if (typeof vector === "number")
      {
         const
            x = vector,
            w = x * this [1] + this [3];

         return (x * this [0] + this [2]) / w;
      }
      else
      {
         const { x, y } = vector;

         vector .x = x * this [0] + y * this [2];
         vector .y = x * this [1] + y * this [3];

         return vector;
      }
   },
   multMatrixVec (vector)
   {
      if (typeof vector === "number")
      {
         const
            x = vector,
            w = x * this [2] + this [3];

         return (x * this [0] + this [1]) / w;
      }
      else
      {
         const { x, y } = vector;

         vector .x = x * this [0] + y * this [1];
         vector .y = x * this [2] + y * this [3];

         return vector;
      }
   },
   identity ()
   {
      this [0] = 1;
      this [1] = 0;
      this [2] = 0;
      this [3] = 1;
   },
   toString ()
   {
      return Array .prototype .join .call (this, " ");
   },
});

for (const key of Object .keys (Matrix2 .prototype))
   Object .defineProperty (Matrix2 .prototype, key, { enumerable: false });

Object .defineProperties (Matrix2 .prototype,
{
   order: { value: 2 },
   length: { value: 4 },
   x:
   {
      get: (() =>
      {
         const vector = new Vector2/* default */.A ();

         return function () { return vector .set (this [0], this [1]); };
      })(),
   },
   y:
   {
      get: (() =>
      {
         const vector = new Vector2/* default */.A ();

         return function () { return vector .set (this [2], this [3]); };
      })(),
   },
   X_AXIS:
   {
      get () { return this [0]; },
   },
   origin:
   {
      get () { return this [2]; },
   },
   submatrix:
   {
      get () { return this [0]; },
   },
});

Object .assign (Matrix2,
{
   IDENTITY: Object .freeze (new Matrix2 ()),
});

const __default__ = Matrix2;
;

/* harmony default export */ const Numbers_Matrix2 = (Namespace/* default */.A .add ("Matrix2", __default__));
// EXTERNAL MODULE: ./src/standard/Math/Algorithms/eigen_decomposition.js
var eigen_decomposition = __webpack_require__(6253);
;// ./src/standard/Math/Numbers/Matrix3.js





function Matrix3 (... args)
{
   if (args .length)
   {
      for (let i = 0; i < 9; ++ i)
         this [i] = args [i];
   }
   else
   {
      this .identity ();
   }
}

Object .assign (Matrix3 .prototype,
{
   *[Symbol .iterator] ()
   {
      for (let i = 0; i < 9; ++ i)
         yield this [i];
   },
   copy ()
   {
      const copy = Object .create (Matrix3 .prototype);

      for (let i = 0; i < 9; ++ i)
         copy [i] = this [i];

      return copy;
   },
   assign (matrix)
   {
      for (let i = 0; i < 9; ++ i)
         this [i] = matrix [i];

      return this;
   },
   equals (matrix)
   {
      return this [0] === matrix [0] &&
             this [1] === matrix [1] &&
             this [2] === matrix [2] &&
             this [3] === matrix [3] &&
             this [4] === matrix [4] &&
             this [5] === matrix [5] &&
             this [6] === matrix [6] &&
             this [7] === matrix [7] &&
             this [8] === matrix [8];
   },
   set1 (r, c, value)
   {
      this [r * this .order + c] = value;

      return this;
   },
   get1 (r, c)
   {
      return this [r * this .order + c];
   },
   set: (() =>
   {
      const invCenter = new Vector2/* default */.A ();

      return function (translation, rotation, scale, scaleOrientation, center)
      {
         this .identity ();

         switch (arguments .length)
         {
            case 1:
            {
               if (translation && !translation .equals (Vector2/* default */.A .ZERO))
                  this .translate (translation);

               break;
            }
            case 2:
            {
               if (translation && !translation .equals (Vector2/* default */.A .ZERO))
                  this .translate (translation);

               if (rotation)
                  this .rotate (rotation);

               break;
            }
            case 3:
            {
               if (translation && !translation .equals (Vector2/* default */.A .ZERO))
                  this .translate (translation);

               if (rotation)
                  this .rotate (rotation);

               if (scale && !scale .equals (Vector2/* default */.A .ONE))
                  this .scale  (scale);

               break;
            }
            case 4:
            {
               if (translation && !translation .equals (Vector2/* default */.A .ZERO))
                  this .translate (translation);

               if (rotation)
                  this .rotate (rotation);

               if (scale && !scale .equals (Vector2/* default */.A .ONE))
               {
                  if (scaleOrientation)
                  {
                     this .rotate (scaleOrientation);
                     this .scale (scale);
                     this .rotate (-scaleOrientation);
                  }
                  else
                  {
                     this .scale (scale);
                  }
               }

               break;
            }
            case 5:
            {
               // P' = T * C * R * SR * S * -SR * -C * P
               if (translation && !translation .equals (Vector2/* default */.A .ZERO))
                  this .translate (translation);

               const hasCenter = center && !center .equals (Vector2/* default */.A .ZERO);

               if (hasCenter)
                  this .translate (center);

               if (rotation)
                  this .rotate (rotation);

               if (scale && !scale .equals (Vector2/* default */.A .ONE))
               {
                  if (scaleOrientation)
                  {
                     this .rotate (scaleOrientation);
                     this .scale (scale);
                     this .rotate (-scaleOrientation);
                  }
                  else
                  {
                     this .scale (scale);
                  }
               }

               if (hasCenter)
                  this .translate (invCenter .assign (center) .negate ());

               break;
            }
            case 9:
            {
               for (let i = 0; i < 9; ++ i)
                  this [i] = arguments [i];

               break;
            }
         }

         return this;
      };
   })(),
   get: (() =>
   {
      const c = new Vector2/* default */.A ();

      return function (translation, rotation, scale, scaleOrientation, center)
      {
         switch (arguments .length)
         {
            case 1:
            {
               translation .set (this [6], this [7]);
               break;
            }
            case 2:
            case 3:
            case 4:
            {
               this .factor (translation, rotation, scale, scaleOrientation);
               break;
            }
            case 5:
            {
               if (center)
               {
                  m .set (c .assign (center) .negate ());
                  m .multLeft (this);
                  m .translate (center);
                  m .get (translation, rotation, scale, scaleOrientation);
               }
               else
               {
                  this .factor (translation, rotation, scale, scaleOrientation);
               }

               break;
            }
         }
      };
   })(),
   factor: (() =>
   {
      const
         s  = new Vector2/* default */.A (),
         si = new Numbers_Matrix2 (),
         so = new Numbers_Matrix2 (),
         b  = new Numbers_Matrix2 ();

      const eigen = { values: [ ], vectors: [[ ], [ ]] };

      return function (translation, rotation, scale, scaleOrientation)
      {
         // (1) Get translation.
         translation ?.set (this [6], this [7]);

         // (2) Create 3x3 matrix.
         const a = this .submatrix;

         // (3) Compute det A. If negative, set sign = -1, else sign = 1
         const det      = a .determinant ();
         const det_sign = det < 0 ? -1 : 1;

         // (4) B = A * !A  (here !A means A transpose)
         b .assign (a) .transpose () .multLeft (a);
         const e = (0,eigen_decomposition/* default */.A) (b, eigen);

         // Find min / max eigenvalues and do ratio test to determine singularity.

         so .set (e .vectors [0] [0], e .vectors [1] [0],
                  e .vectors [0] [1], e .vectors [1] [1]);

         if (scaleOrientation)
         {
            scaleOrientation [0] = so [0];
            scaleOrientation [1] = so [1];
            scaleOrientation [2] = Math .atan2 (so [1], so [0]);
         }

         // Compute s = sqrt(eigen values), with sign. Set si = s-inverse

         s .set (det_sign * Math .sqrt (e .values [0]),
                 det_sign * Math .sqrt (e .values [1]));

         scale ?.assign (s);

         if (rotation)
         {
            si [0] = 1 / s .x;
            si [3] = 1 / s .y;

            // (5) Compute U = !R ~S R A.
            a .multLeft (so) .multLeft (si) .multLeft (so .transpose ());

            rotation [0] = a [0];
            rotation [1] = a [1];
            rotation [2] = Math .atan2 (a [1], a [0]);
         }
      };
   })(),
   determinant2 ()
   {
      const { 0: m0, 1: m1, 3: m3, 4: m4 } = this;

      return m0 * m4 - m1 * m3;
   },
   determinant ()
   {
      const { 0: m0, 1: m1, 2: m2, 3: m3, 4: m4, 5: m5, 6: m6, 7: m7, 8: m8 } = this;

      return m0 * (m4 * m8 - m5 * m7) -
             m1 * (m3 * m8 - m5 * m6) +
             m2 * (m3 * m7 - m4 * m6);
   },
   transpose ()
   {
      let tmp;

      tmp = this [1]; this [1] = this [3]; this [3] = tmp;
      tmp = this [2]; this [2] = this [6]; this [6] = tmp;
      tmp = this [5]; this [5] = this [7]; this [7] = tmp;

      return this;
   },
   inverse ()
   {
      // Complexity 2 +, 16 -, 33 *, 1 /.

      const
         { 0: m0, 1: m1, 2: m2, 3: m3, 4: m4, 5: m5, 6: m6, 7: m7, 8: m8 } = this,
         t4  = m0 * m4,
         t6  = m0 * m7,
         t8  = m3 * m1,
         t10 = m3 * m7,
         t12 = m6 * m1,
         t14 = m6 * m4;

      let d = (t4 * m8 - t6 * m5 - t8 * m8 + t10 * m2 + t12 * m5 - t14 * m2);

      // if (d === 0) ... determinant is zero.

      d = 1 / d;

      const
         b0 =  (m4 * m8 - m7 * m5) * d,
         b1 = -(m1 * m8 - m7 * m2) * d,
         b2 =  (m1 * m5 - m4 * m2) * d,
         b3 = -(m3 * m8 - m6 * m5) * d,
         b4 =  (m0 * m8 - m6 * m2) * d,
         b5 = -(m0 * m5 - m3 * m2) * d;

      this [0] = b0;
      this [1] = b1;
      this [2] = b2;
      this [3] = b3;
      this [4] = b4;
      this [5] = b5;
      this [6] =  (t10 - t14) * d;
      this [7] = -(t6 - t12) * d;
      this [8] =  (t4 - t8) * d;

      return this;
   },
   multLeft (matrix)
   {
      // Complexity 18 +, 27 *.

      const
         { 0: a0, 1: a1, 2: a2, 3: a3, 4: a4, 5: a5, 6: a6, 7: a7, 8: a8 } = this,
         { 0: b0, 1: b1, 2: b2, 3: b3, 4: b4, 5: b5, 6: b6, 7: b7, 8: b8 } = matrix;

      this [0] = a0 * b0 + a3 * b1 + a6 * b2;
      this [1] = a1 * b0 + a4 * b1 + a7 * b2;
      this [2] = a2 * b0 + a5 * b1 + a8 * b2;
      this [3] = a0 * b3 + a3 * b4 + a6 * b5;
      this [4] = a1 * b3 + a4 * b4 + a7 * b5;
      this [5] = a2 * b3 + a5 * b4 + a8 * b5;
      this [6] = a0 * b6 + a3 * b7 + a6 * b8;
      this [7] = a1 * b6 + a4 * b7 + a7 * b8;
      this [8] = a2 * b6 + a5 * b7 + a8 * b8;

      return this;
   },
   multRight (matrix)
   {
      // Complexity 18 +, 27 *.

      const
         { 0: a0, 1: a1, 2: a2, 3: a3, 4: a4, 5: a5, 6: a6, 7: a7, 8: a8 } = this,
         { 0: b0, 1: b1, 2: b2, 3: b3, 4: b4, 5: b5, 6: b6, 7: b7, 8: b8 } = matrix;

      this [0] = a0 * b0 + a1 * b3 + a2 * b6;
      this [1] = a0 * b1 + a1 * b4 + a2 * b7;
      this [2] = a0 * b2 + a1 * b5 + a2 * b8;
      this [3] = a3 * b0 + a4 * b3 + a5 * b6;
      this [4] = a3 * b1 + a4 * b4 + a5 * b7;
      this [5] = a3 * b2 + a4 * b5 + a5 * b8;
      this [6] = a6 * b0 + a7 * b3 + a8 * b6;
      this [7] = a6 * b1 + a7 * b4 + a8 * b7;
      this [8] = a6 * b2 + a7 * b5 + a8 * b8;

      return this;
   },
   multVecMatrix (vector)
   {
      if (vector .length === 2)
      {
         const
            { x, y } = vector,
            w = x * this [2] + y * this [5] + this [8];

         vector .x = (x * this [0] + y * this [3] + this [6]) / w;
         vector .y = (x * this [1] + y * this [4] + this [7]) / w;

         return vector;
      }
      else
      {
         const { x, y, z } = vector;

         vector .x = x * this [0] + y * this [3] + z * this [6];
         vector .y = x * this [1] + y * this [4] + z * this [7];
         vector .z = x * this [2] + y * this [5] + z * this [8];

         return vector;
      }
   },
   multMatrixVec (vector)
   {
      if (vector .length === 2)
      {
         const
            { x, y } = vector,
            w = x * this [6] + y * this [7] + this [8];

         vector .x = (x * this [0] + y * this [1] + this [2]) / w;
         vector .y = (x * this [3] + y * this [4] + this [5]) / w;

         return vector;
      }
      else
      {
         const { x, y, z } = vector;

         vector .x = x * this [0] + y * this [1] + z * this [2];
         vector .y = x * this [3] + y * this [4] + z * this [5];
         vector .z = x * this [6] + y * this [7] + z * this [8];

         return vector;
      }
   },
   multDirMatrix (vector)
   {
      const { x, y } = vector;

      vector .x = x * this [0] + y * this [3];
      vector .y = x * this [1] + y * this [4];

      return vector;
   },
   multMatrixDir (vector)
   {
      const { x, y } = vector;

      vector .x = x * this [0] + y * this [1];
      vector .y = x * this [3] + y * this [4];

      return vector;
   },
   identity ()
   {
      this [0] = 1; this [1] = 0; this [2] = 0;
      this [3] = 0; this [4] = 1; this [5] = 0;
      this [6] = 0; this [7] = 0; this [8] = 1;

      return this;
   },
   translate (translation)
   {
      const { x, y } = translation;

      this [6] += this [0] * x + this [3] * y;
      this [7] += this [1] * x + this [4] * y;

      return this;
   },
   rotate (rotation)
   {
      return this .multLeft (Matrix3 .Rotation (rotation));
   },
   scale (scale)
   {
      const { x, y } = scale;

      this [0] *= x;
      this [3] *= y;

      this [1] *= x;
      this [4] *= y;

      return this;
   },
   skewX (angle)
   {
      const a = Math .tan (angle);

      this [3] += this [0] * a;
      this [4] += this [1] * a;
      this [5] += this [2] * a;

      return this;
   },
   skewY (angle)
   {
      const a = Math .tan (angle);

      this [0] += this [3] * a;
      this [1] += this [4] * a;
      this [2] += this [5] * a;

      return this;
   },
   toString ()
   {
      return Array .prototype .join .call (this, " ");
   },
});

for (const key of Object .keys (Matrix3 .prototype))
   Object .defineProperty (Matrix3 .prototype, key, { enumerable: false });

Object .defineProperties (Matrix3 .prototype,
{
   order: { value: 3 },
   length: { value: 9 },
   x:
   {
      get: (() =>
      {
         const vector = new Vector3/* default */.A ();

         return function () { return vector .set (this [0], this [1], this [2]); };
      })(),
   },
   y:
   {
      get: (() =>
      {
         const vector = new Vector3/* default */.A ();

         return function () { return vector .set (this [3], this [4], this [5]); };
      })(),
   },
   z:
   {
      get: (() =>
      {
         const vector = new Vector3/* default */.A ();

         return function () { return vector .set (this [6], this [7], this [8]); };
      })(),
   },
   X_AXIS:
   {
      get: (() =>
      {
         const vector = new Vector2/* default */.A ();

         return function () { return vector .set (this [0], this [1]); };
      })(),
   },
   Y_AXIS:
   {
      get: (() =>
      {
         const vector = new Vector2/* default */.A ();

         return function () { return vector .set (this [3], this [4]); };
      })(),
   },
   origin:
   {
      get: (() =>
      {
         const vector = new Vector2/* default */.A ();

         return function () { return vector .set (this [6], this [7]); };
      })(),
   },
   submatrix:
   {
      get: (() =>
      {
         const matrix = new Numbers_Matrix2 ();

         return function ()
         {
            matrix [0] = this [0]; matrix [1] = this [1];
            matrix [2] = this [3]; matrix [3] = this [4];
            return matrix;
         };
      })(),
   },
});

Object .assign (Matrix3,
{
   IDENTITY: Object .freeze (new Matrix3 ()),
   Rotation (rotation)
   {
      const
         sinAngle = Math .sin (rotation),
         cosAngle = Math .cos (rotation);

      return new Matrix3 ( cosAngle, sinAngle, 0,
                          -sinAngle, cosAngle, 0,
                           0, 0, 1);
   },
   Matrix2 (matrix)
   {
      return new Matrix3 (matrix [0], matrix [1], 0,
                          matrix [2], matrix [3], 0,
                          0, 0, 1);
   },
});

const m = new Matrix3 ();

const Matrix3_default_ = Matrix3;
;

/* harmony default export */ const Numbers_Matrix3 = (Namespace/* default */.A .add ("Matrix3", Matrix3_default_));

/***/ }),

/***/ 3078:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  A: () => (/* binding */ Base_X3DObject)
});

// EXTERNAL MODULE: ./src/x_ite/Base/X3DConstants.js
var X3DConstants = __webpack_require__(8899);
// EXTERNAL MODULE: ./src/standard/Math/Algorithm.js
var Algorithm = __webpack_require__(4559);
// EXTERNAL MODULE: ./src/x_ite/Execution/NamedNodesHandling.js
var NamedNodesHandling = __webpack_require__(6029);
// EXTERNAL MODULE: ./src/x_ite/Namespace.js
var Namespace = __webpack_require__(6707);
;// ./src/x_ite/InputOutput/X3DGenerator.js




function Generator ({ style = "TIDY", indent = "", indentChar = "  ", precision = 7, doublePrecision = 15, names = true } = { })
{
   this .string          = "";
   this .indent          = indent;
   this .listIndent      = indent;
   this .precision       = Algorithm/* default */.A .clamp (precision, 1, 21);
   this .doublePrecision = Algorithm/* default */.A .clamp (doublePrecision, 1, 21);
   this .outputNames     = names; // private option: used in StaticGroup for toVRMLString.

   this .floatFormat             = this .createFloatFormat (this .precision);
   this .floatExponentialFormat  = this .createFloatExponentialFormat (this .precision);
   this .doubleFormat            = this .createFloatFormat (this .doublePrecision);
   this .doubleExponentialFormat = this .createFloatExponentialFormat (this .doublePrecision);

   this .Style (style, indentChar);

   this .executionContextStack = [ ];
   this .executionContextIndex = new Set ();
   this .importedNodesIndex    = new Map ();
   this .importedNames         = new Map ();
   this .exportedNodesIndex    = new Map ();
   this .nodes                 = new Map ();
   this .names                 = new Map ();
   this .namesByNode           = new Map ();
   this .routeNodes            = new Map ();
}

Object .assign (Generator .prototype,
{
   Style (style, indentChar = "  ")
   {
      switch (style)
      {
         case "CLEAN":
         {
            this .listIndent = "";

            this .comma          = " ";
            this .break          = " ";
            this .tidyBreak      = "";
            this .tidySpace      = "";
            this .indentChar     = "";
            this .listEnclosure  = "";
            this .listBreak      = "";
            this .listIndentChar = "";
            this .attribBreak    = " ";
            break;
         }
         case "SMALL":
         {
            this .listIndent = "";

            this .comma          = ",";
            this .break          = "\n";
            this .tidyBreak      = "\n";
            this .tidySpace      = "";
            this .indentChar     = "";
            this .listEnclosure  = "";
            this .listBreak      = "";
            this .listIndentChar = "";
            this .attribBreak    = " ";
            break;
         }
         case "COMPACT":
         {
            this .listIndent = "";

            this .comma          = ",";
            this .break          = "\n";
            this .tidyBreak      = "\n";
            this .tidySpace      = " ";
            this .indentChar     = indentChar;
            this .listEnclosure  = " ";
            this .listBreak      = " ";
            this .listIndentChar = "";
            this .attribBreak    = " ";
            break;
         }
         case "TIDY":
         default:
         {
            this .comma          = ",";
            this .break          = "\n";
            this .tidyBreak      = "\n";
            this .tidySpace      = " ";
            this .indentChar     = indentChar;
            this .listEnclosure  = "\n";
            this .listBreak      = "\n";
            this .listIndentChar = this .indentChar;
            this .attribBreak    = "\n";
            break;
         }
      }
   },
   Comma ()
   {
      this .string += this .comma;
   },
   Break ()
   {
      this .needsSpace = false;

      this .string += this .break;
   },
   TidyBreak ()
   {
      this .needsSpace &&= !this .tidyBreak;

      this .string += this .tidyBreak;
   },
   Space ()
   {
      this .needsSpace = false;

      this .string += " ";
   },
   TidySpace ()
   {
      this .needsSpace &&= !this .tidySpace;

      this .string += this .tidySpace;
   },
   ListStart ()
   {
      this .string += this .listEnclosure;
   },
   ListEnd ()
   {
      this .string += this .listEnclosure;
   },
   ListBreak ()
   {
      this .string += this .listBreak;
   },
   AttribBreak ()
   {
      this .string += this .attribBreak;
   },
   Indent ()
   {
      this .string += this .indent;
   },
   ListIndent ()
   {
      this .string += this .listIndent;
   },
   IncIndent ()
   {
      this .indent     += this .indentChar;
      this .listIndent += this .listIndentChar;
   },
   DecIndent ()
   {
      this .indent     = this .indent     .slice (0, -this .indentChar     .length);
      this .listIndent = this .listIndent .slice (0, -this .listIndentChar .length);
   },
   NeedsSpace ()
   {
      this .needsSpace = true;
   },
   CheckSpace ()
   {
      if (this .needsSpace)
         this .string += " ";

      this .needsSpace = false;
   },
   createFloatFormat (precision)
   {
      return new Intl .NumberFormat ("en",
      {
         notation: "standard",
         maximumSignificantDigits: precision,
         useGrouping: false,
      })
      .format;
   },
   createFloatExponentialFormat (precision)
   {
      return new Intl .NumberFormat ("en",
      {
         notation: "scientific",
         maximumSignificantDigits: precision,
         useGrouping: false,
      })
      .format;
   },
   FloatFormat  (value)
   {
      if (Number .isFinite (value))
      {
         const exponent = Math .log10 (Math .abs (value));

         if ((this .precision > exponent && exponent >= -4) || value === 0)
            return this .floatFormat (value);

         return this .floatExponentialFormat (value) .toLowerCase ();
      }
      else
      {
         return String (value);
      }
   },
   DoubleFormat  (value)
   {
      if (Number .isFinite (value))
      {
         const exponent = Math .log10 (Math .abs (value));

         if ((this .doublePrecision > exponent && exponent >= -4) || value === 0)
            return this .doubleFormat (value);

         return this .doubleExponentialFormat (value) .toLowerCase ();
      }
      else
      {
         return String (value);
      }
   },
   PushExecutionContext (executionContext)
   {
      this .executionContextStack .push (executionContext);

      if (this .executionContextIndex .has (executionContext))
         return;

      this .executionContextIndex .add (executionContext);
      this .importedNodesIndex    .set (executionContext, new Set ());
      this .importedNames         .set (executionContext, new Map ());
      this .exportedNodesIndex    .set (executionContext, new Set ());
      this .nodes                 .set (executionContext, new Set ());
      this .names                 .set (executionContext, new Set ());
      this .namesByNode           .set (executionContext, new Map ());
      this .routeNodes            .set (executionContext, new Set ());

      this .needsSpace = false;
   },
   PopExecutionContext ()
   {
      const executionContext = this .executionContextStack .pop ();

      if (this .executionContextStack .at (-1) === executionContext)
         return;

      this .executionContextIndex .delete (executionContext);
      this .importedNodesIndex    .delete (executionContext);
      this .importedNames         .delete (executionContext);
      this .exportedNodesIndex    .delete (executionContext);
      this .nodes                 .delete (executionContext);
      this .names                 .delete (executionContext);
      this .namesByNode           .delete (executionContext);
      this .routeNodes            .delete (executionContext);
   },
   ExecutionContext ()
   {
      return this .executionContextStack .at (-1);
   },
   NamedNodes (namedNodes)
   {
      const
         names       = this .names .get (this .ExecutionContext ()),
         namesByNode = this .namesByNode .get (this .ExecutionContext ());

      for (const node of namedNodes)
      {
         if (node .getNodeName () .match (/^_\d+$/))
            continue;

         names .add (node .getNodeName ());
         namesByNode .set (node .getValue (), node .getNodeName ());
      }
   },
   ExportedNodes (exportedNodes)
   {
      const index = this .exportedNodesIndex .get (this .ExecutionContext ());

      for (const exportedNode of exportedNodes)
         index .add (exportedNode .getLocalNode ());
   },
   ImportedNodes (importedNodes)
   {
      const index = this .importedNodesIndex .get (this .ExecutionContext ());

      for (const importedNode of importedNodes)
         index .add (importedNode .getInlineNode ());
   },
   AddRouteNode (routeNode)
   {
      const routeNodes = this .routeNodes .get (this .ExecutionContext ());

      routeNodes .add (routeNode);
   },
   ExistsRouteNode (routeNode)
   {
      const routeNodes = this .routeNodes .get (this .ExecutionContext ());

      return routeNodes .has (routeNode);
   },
   IsSharedNode (baseNode)
   {
      return this .ExecutionContext () !== baseNode .getExecutionContext ();
   },
   AddNode (baseNode)
   {
      const nodes = this .nodes .get (this .ExecutionContext ());

      nodes .add (baseNode);

      this .AddRouteNode (baseNode);
   },
   ExistsNode (baseNode)
   {
      const nodes = this .nodes .get (this .ExecutionContext ());

      return nodes .has (baseNode);
   },
   Name (baseNode)
   {
      // Is the node already in index.

      const
         namesByNode = this .namesByNode .get (this .ExecutionContext ()),
         name        = namesByNode .get (baseNode);

      if (name !== undefined)
      {
         return name;
      }
      else
      {
         const
            names = this .names .get (this .ExecutionContext ()),
            name  = baseNode .getName ();

         // The node has no name.

         if (name .match (/^(?:_\d+)?$/) && !this .NeedsName (baseNode))
            return "";

         const newName = (0,NamedNodesHandling/* getUniqueName */.l) (names, name);

         // Add to indices.

         names .add (newName);
         namesByNode .set (baseNode, newName);

         return newName;
      }
   },
   NeedsName (baseNode)
   {
      if (baseNode .getCloneCount () > 1)
         return true;

      if (baseNode .hasRoutes ())
         return true;

      const executionContext = this .ExecutionContext ();

      if (this .importedNodesIndex .get (executionContext) .has (baseNode))
         return true;

      if (this .exportedNodesIndex .get (executionContext) .has (baseNode))
         return true;

      return false;
   },
   ImportedName (importedNode)
   {
      const importedNames = this .importedNames .get (this .ExecutionContext ());

      if (importedNames .has (importedNode))
         return importedNames .get (importedNode);

      const
         names   = this .names .get (this .ExecutionContext ()),
         newName = (0,NamedNodesHandling/* getUniqueName */.l) (names, importedNode .getImportedName ());

      // Add to indices.

      names .add (newName);
      importedNames .set (importedNode, newName);

      return newName;
   },
   AccessType (accessType)
   {
      switch (accessType)
      {
         case X3DConstants/* default */.A .initializeOnly:
            return "initializeOnly";
         case X3DConstants/* default */.A .inputOnly:
            return "inputOnly";
         case X3DConstants/* default */.A .outputOnly:
            return "outputOnly";
         case X3DConstants/* default */.A .inputOutput:
            return "inputOutput";
      }
   },
   ToUnit (category, value)
   {
      return this .ExecutionContext () ?.toUnit (category, value) ?? value;
   },
});

for (const key of Object .keys (Generator .prototype))
   Object .defineProperty (Generator .prototype, key, { enumerable: false });

const __default__ = Generator;
;

/* harmony default export */ const X3DGenerator = (Namespace/* default */.A .add ("X3DGenerator", __default__));
;// ./src/x_ite/InputOutput/VRMLGenerator.js


function VRMLGenerator (options)
{
   X3DGenerator .call (this, options);
}

Object .assign (Object .setPrototypeOf (VRMLGenerator .prototype, X3DGenerator .prototype),
{
   NULL ()
   {
      this .CheckSpace ();
      this .string += "NULL";
      this .NeedsSpace ();
   },
});

for (const key of Object .keys (VRMLGenerator .prototype))
   Object .defineProperty (VRMLGenerator .prototype, key, { enumerable: false });

const VRMLGenerator_default_ = VRMLGenerator;
;

/* harmony default export */ const InputOutput_VRMLGenerator = (Namespace/* default */.A .add ("VRMLGenerator", VRMLGenerator_default_));
;// ./src/x_ite/InputOutput/XMLGenerator.js


function XMLGenerator (options = { })
{
   X3DGenerator .call (this, options);

   const { html = false, closingTags = false } = options;

   this .html            = html;
   this .closingTags     = html || closingTags;
   this .containerFields = [ ];
}

Object .assign (Object .setPrototypeOf (XMLGenerator .prototype, X3DGenerator .prototype),
{
   PushContainerField (field)
   {
      this .containerFields .push (field);
   },
   PopContainerField ()
   {
      this .containerFields .pop ();
   },
   EncodeString: (() =>
   {
      const map = {
         "\\": "\\\\",
         "\r": "&#xD;",
         "\n": "&#xA;",
         "\t": "&#x9;",
         "\"": "\\\"",
         "'": "&apos;",
         "<": "&lt;",
         ">": "&gt;",
         "&": "&amp;",
      };

      const regex = /([\\\r\n\t"'<>&])/g;

      return function (string)
      {
         return String (string) .replace (regex, char => map [char]);
      };
   })(),
   EncodeSourceText: (() =>
   {
      const map = {
         "\\": "\\\\",
         "\"": "\\\"",
         "'": "&apos;",
         "<": "&lt;",
         ">": "&gt;",
         "&": "&amp;",
      };

      const regex = /([\\"'<>&])/g;

      return function (string)
      {
         return string .replace (regex, char => map [char]);
      };
   })(),
   openingTag (name)
   {
      this .Indent ();
      this .string += "<";
      this .string += name;
      this .string += ">";
   },
   closingTag (name)
   {
      this .Indent ();
      this .string += "</";
      this .string += name;
      this .string += ">";
   },
   openTag (name)
   {
      this .Indent ();
      this .string += "<";
      this .string += name;
   },
   endTag ()
   {
      this .string += ">";
      this .TidyBreak ();
   },
   closeTag (name)
   {
      if (this .closingTags)
      {
         this .string += "></";
         this .string += name;
         this .string += ">";
      }
      else
      {
         this .string += "/>";
      }
   },
   attribute (name, value)
   {
      this .Space ();
      this .string += name;
      this .string += "='";
      this .string += this .EncodeString (value);
      this .string += "'";
   },
   containerField (defaultContainerField)
   {
      const containerField = this .containerFields .at (-1);

      if (!containerField)
         return;

      if (containerField .getName () !== defaultContainerField)
         this .attribute ("containerField", containerField .getName ());
   },
});

for (const key of Object .keys (XMLGenerator .prototype))
   Object .defineProperty (XMLGenerator .prototype, key, { enumerable: false });

const XMLGenerator_default_ = XMLGenerator;
;

/* harmony default export */ const InputOutput_XMLGenerator = (Namespace/* default */.A .add ("XMLGenerator", XMLGenerator_default_));
;// ./src/x_ite/InputOutput/JSONGenerator.js


function JSONGenerator (options)
{
   X3DGenerator .call (this, options);
}

Object .assign (Object .setPrototypeOf (JSONGenerator .prototype, X3DGenerator .prototype),
{
   EncodeString: (() =>
   {
      const map = {
         "\\": "\\\\",
         "\r": "\\r",
         "\n": "\\n",
         "\t": "\\t",
         "\"": "\\\"",
      };

      const regex = /([\\\t\n\r"])/g;

      return function (string)
      {
         return String (string) .replace (regex, char => map [char]);
      };
   })(),
   Number (value)
   {
      switch (value)
      {
         case "NaN":
         case "Infinity":
         case "-Infinity":
            return '"' + value + '"';
         default:
            return value;
      }
   },
   RemoveComma ()
   {
      this .string = this .string .replace (/,\s*$/s, "");
   },
   stringProperty (key, value, comma = true)
   {
      if (comma)
         this .string += ',';

      this .TidyBreak ();
      this .Indent ();
      this .string += '"';
      this .string += key;
      this .string += '"';
      this .string += ':';
      this .TidySpace ();
      this .string += '"';
      this .string += this .EncodeString (value);
      this .string += '"';
   },
   numberProperty (key, value, comma = true)
   {
      if (comma)
         this .string += ',';

      this .TidyBreak ();
      this .Indent ();
      this .string += '"';
      this .string += key;
      this .string += '"';
      this .string += ':';
      this .TidySpace ();
      this .string += value;
   },
   beginObject (name, comma = true, main = false)
   {
      if (comma)
         this .string += ',';

      if (name)
      {
         if (main)
         {
            this .string += '{';
            this .TidySpace ();
            this .string += '"';
            this .string += name;
            this .string += '"';
            this .string += ':';
            this .TidyBreak ();
            this .IncIndent ();
            this .Indent ();
            this .string += '{';
            this .IncIndent ();
         }
         else
         {
            this .TidyBreak ();
            this .Indent ();
            this .string += '"';
            this .string += name;
            this .string += '"';
            this .string += ':';
            this .TidySpace ();
            this .string += '{';
            this .IncIndent ();
         }
      }
      else
      {
         this .TidyBreak ();
         this .Indent ();
         this .string += '{';
         this .IncIndent ();
      }
   },
   endObject ()
   {
      this .TidyBreak ();
      this .DecIndent ();
      this .Indent ();
      this .string += '}';
   },
   beginArray (name, comma = true)
   {
      this .beginValue (name, comma);

      this .string += '[';
      this .IncIndent ();
   },
   endArray ()
   {
      this .TidyBreak ();
      this .DecIndent ();
      this .Indent ();
      this .string += ']';
   },
   beginValue (name, comma = true)
   {
      if (comma)
         this .string += ',';

      this .TidyBreak ();
      this .Indent ();
      this .string += '"';
      this .string += name;
      this .string += '"';
      this .string += ':';
      this .TidySpace ();
   },
});

for (const key of Object .keys (JSONGenerator .prototype))
   Object .defineProperty (JSONGenerator .prototype, key, { enumerable: false });

const JSONGenerator_default_ = JSONGenerator;
;

/* harmony default export */ const InputOutput_JSONGenerator = (Namespace/* default */.A .add ("JSONGenerator", JSONGenerator_default_));
// EXTERNAL MODULE: ./src/x_ite/Features.js
var Features = __webpack_require__(6818);
;// ./src/x_ite/Base/X3DObject.js
/* provided dependency */ var $ = __webpack_require__(7682);





const
   _name          = Symbol (),
   _interests     = Symbol (),
   _registry      = Symbol (),
   _userData      = Symbol (),
   _vrmlGenerator = Symbol (),
   _xmlGenerator  = Symbol (),
   _jsonGenerator = Symbol ();

function X3DObject () { }

Object .assign (X3DObject .prototype,
{
   [_name]: "",
   [_interests]: null,
   [_registry]: null,
   [_userData]: null,
   getId ()
   {
      return X3DObject .getId (this);
   },
   getTypeName ()
   {
      return this .constructor .typeName;
   },
   setName (value)
   {
      this [_name] = value;
   },
   getName ()
   {
      return this [_name];
   },
   getDisplayName ()
   {
      return this [_name];
   },
   hasInterest (callbackName, object)
   {
      return this [_interests] ?.has (X3DObject .getInterestId (object [callbackName], object)) ?? false;
   },
   addInterest (callbackName, object, ... args)
   {
      const
         weakRef    = new WeakRef (object),
         callback   = object [callbackName],
         interestId = X3DObject .getInterestId (callback, object);

      this [_registry] ??= new FinalizationRegistry (objectId =>
      {
         for (const interestId of this [_interests] .keys ())
         {
            if (interestId .endsWith (objectId))
               this [_interests] .delete (interestId);
         }
      });

      this [_interests] = new Map (this [_interests]);

      this [_registry] .register (object, interestId .replace (/^[^:]+/, ""), object);
      this [_interests] .set (interestId, { callback, weakRef, args });
   },
   removeInterest (callbackName, object)
   {
      this [_interests] ?.delete (X3DObject .getInterestId (object [callbackName], object));
   },
   getInterests ()
   {
      return this [_interests] ??= new Map ();
   },
   processInterests: (() =>
   {
      const EMPTY = [ ];

      return function ()
      {
         for (const { callback, weakRef, args } of this [_interests] ?.values () ?? EMPTY)
         {
            const object = weakRef .deref ();

            if (object)
               callback .call (object, ... args, this);
         }
      };
   })(),
   getUserData (key)
   {
      return this [_userData] ?.get (key);
   },
   setUserData (key, value)
   {
      this [_userData] ??= new Map ();

      this [_userData] .set (key, value);
   },
   removeUserData (key)
   {
      this [_userData] ?.delete (key);
   },
   toString (options)
   {
      const generator = !options || $.isEmptyObject (options)
         ? X3DObject [_vrmlGenerator] ??= new InputOutput_VRMLGenerator ()
         : new InputOutput_VRMLGenerator (options);

      generator .string = "";

      generator .PushExecutionContext (options ?.scene ?? null);

      this .toStream (generator);

      generator .PopExecutionContext ();

      return generator .string;
   },
   toVRMLString (options)
   {
      const generator = !options || $.isEmptyObject (options)
         ? X3DObject [_vrmlGenerator] ??= new InputOutput_VRMLGenerator ()
         : new InputOutput_VRMLGenerator (options);

      generator .string = "";

      generator .PushExecutionContext (options ?.scene ?? null);

      this .toVRMLStream (generator);

      generator .PopExecutionContext ();

      return generator .string;
   },
   toXMLString (options)
   {
      const generator = !options || $.isEmptyObject (options)
         ? X3DObject [_xmlGenerator] ??= new InputOutput_XMLGenerator ()
         : new InputOutput_XMLGenerator (options);

      generator .string = "";

      generator .PushExecutionContext (options ?.scene ?? null);

      this .toXMLStream (generator);

      generator .PopExecutionContext ();

      return generator .string;
   },
   toJSONString (options)
   {
      const generator = !options || $.isEmptyObject (options)
         ? X3DObject [_jsonGenerator] ??= new InputOutput_JSONGenerator ()
         : new InputOutput_JSONGenerator (options);

      generator .string = "";

      generator .PushExecutionContext (options ?.scene ?? null);

      this .toJSONStream (generator);

      generator .PopExecutionContext ();

      return generator .string;
   },
   toStream (generator)
   {
      generator .string = Object .prototype .toString .call (this);
   },
   dispose ()
   {
      this [_interests] ?.clear ();
      this [_userData]  ?.clear ();
   },
});

for (const key of Object .keys (X3DObject .prototype))
   Object .defineProperty (X3DObject .prototype, key, { enumerable: false });

Object .defineProperties (X3DObject .prototype,
{
   [Symbol .toStringTag]:
   {
      get () { return this .getTypeName (); },
   },
});

Object .assign (X3DObject,
{
   [_vrmlGenerator]: null,
   [_xmlGenerator]: null,
   [_jsonGenerator]: null,
   getId: Features/* default */.A .FINALIZATION_REGISTRY ? (() =>
   {
      const
         map      = new WeakMap (),
         cache    = [ ],
         registry = new FinalizationRegistry (id => cache .push (id));

      let counter = 0;

      return function (object)
      {
         const id = map .get (object);

         if (id !== undefined)
         {
            return id;
         }
         else
         {
            const id = cache .pop () ?? ++ counter;

            map .set (object, id);
            registry .register (object, id);

            return id;
         }
      };
   })() : (() =>
   {
      const map = new WeakMap ();

      let counter = 0;

      return function (object)
      {
         const id = map .get (object);

         if (id !== undefined)
            return id;

         map .set (object, ++ counter);

         return counter;
      };
   })(),
   getInterestId (callback, object)
   {
      return `${this .getId (callback)}:${this .getId (object)}`;
   },
});

const X3DObject_default_ = X3DObject;
;

/* harmony default export */ const Base_X3DObject = (Namespace/* default */.A .add ("X3DObject", X3DObject_default_));

/***/ }),

/***/ 3265:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Fields_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(564);
/* harmony import */ var _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(8311);
/* harmony import */ var _Base_FieldDefinitionArray_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(6973);
/* harmony import */ var _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(8415);
/* harmony import */ var _X3DBackgroundNode_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(9926);
/* harmony import */ var _Texturing_ImageTexture_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(5257);
/* harmony import */ var _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(8899);
/* harmony import */ var _standard_Math_Numbers_Color3_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(567);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(6707);









function Background (executionContext)
{
   _X3DBackgroundNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .call (this, executionContext);

   this .addType (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .Background);
}

Object .assign (Object .setPrototypeOf (Background .prototype, _X3DBackgroundNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .prototype),
{
   initialize ()
   {
      _X3DBackgroundNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .prototype .initialize .call (this);

      const
         frontTexture      = new _Texturing_ImageTexture_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A (this .getExecutionContext ()),
         backTexture       = new _Texturing_ImageTexture_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A (this .getExecutionContext ()),
         leftTexture       = new _Texturing_ImageTexture_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A (this .getExecutionContext ()),
         rightTexture      = new _Texturing_ImageTexture_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A (this .getExecutionContext ()),
         topTexture        = new _Texturing_ImageTexture_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A (this .getExecutionContext ()),
         bottomTexture     = new _Texturing_ImageTexture_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A (this .getExecutionContext ()),
         textureProperties = this .getBrowser () .getBackgroundTextureProperties ();

      this ._frontUrl  .addFieldInterest (frontTexture  ._url);
      this ._backUrl   .addFieldInterest (backTexture   ._url);
      this ._leftUrl   .addFieldInterest (leftTexture   ._url);
      this ._rightUrl  .addFieldInterest (rightTexture  ._url);
      this ._topUrl    .addFieldInterest (topTexture    ._url);
      this ._bottomUrl .addFieldInterest (bottomTexture ._url);

      frontTexture  ._url = this ._frontUrl;
      backTexture   ._url = this ._backUrl;
      leftTexture   ._url = this ._leftUrl;
      rightTexture  ._url = this ._rightUrl;
      topTexture    ._url = this ._topUrl;
      bottomTexture ._url = this ._bottomUrl;

      frontTexture  ._textureProperties = textureProperties;
      backTexture   ._textureProperties = textureProperties;
      leftTexture   ._textureProperties = textureProperties;
      rightTexture  ._textureProperties = textureProperties;
      topTexture    ._textureProperties = textureProperties;
      bottomTexture ._textureProperties = textureProperties;

      frontTexture  .setup ();
      backTexture   .setup ();
      leftTexture   .setup ();
      rightTexture  .setup ();
      topTexture    .setup ();
      bottomTexture .setup ();

      this .set_texture__ (0, frontTexture);
      this .set_texture__ (1, backTexture);
      this .set_texture__ (2, leftTexture);
      this .set_texture__ (3, rightTexture);
      this .set_texture__ (4, topTexture);
      this .set_texture__ (5, bottomTexture);
   }
});

Object .defineProperties (Background,
{
   ... _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .getStaticProperties ("Background", "EnvironmentalEffects", 1, "children", "2.0"),
   fieldDefinitions:
   {
      value: new _Base_FieldDefinitionArray_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A ([
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .inputOutput, "metadata",     new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFNode ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .inputOnly,   "set_bind",     new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFBool ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .inputOutput, "frontUrl",     new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFString ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .inputOutput, "backUrl",      new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFString ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .inputOutput, "leftUrl",      new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFString ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .inputOutput, "rightUrl",     new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFString ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .inputOutput, "topUrl",       new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFString ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .inputOutput, "bottomUrl",    new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFString ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .inputOutput, "skyAngle",     new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFFloat ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .inputOutput, "skyColor",     new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFColor (new _standard_Math_Numbers_Color3_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A ())),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .inputOutput, "groundAngle",  new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFFloat ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .inputOutput, "groundColor",  new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFColor ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .inputOutput, "transparency", new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFFloat ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .outputOnly,  "isBound",      new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFBool ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .outputOnly,  "bindTime",     new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFTime ()),
      ]),
      enumerable: true,
   },
});

const __default__ = Background;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_8__/* ["default"] */ .A .add ("Background", __default__));

/***/ }),

/***/ 3281:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  A: () => (/* binding */ Layering_X3DLayerNode)
});

// EXTERNAL MODULE: ./src/x_ite/Fields.js + 15 modules
var Fields = __webpack_require__(564);
// EXTERNAL MODULE: ./src/x_ite/Components/Core/X3DNode.js
var X3DNode = __webpack_require__(8415);
// EXTERNAL MODULE: ./src/x_ite/Rendering/TextureBuffer.js
var TextureBuffer = __webpack_require__(5123);
// EXTERNAL MODULE: ./src/x_ite/Rendering/TraverseType.js
var TraverseType = __webpack_require__(834);
// EXTERNAL MODULE: ./src/x_ite/Rendering/RenderPass.js
var RenderPass = __webpack_require__(6685);
// EXTERNAL MODULE: ./src/standard/Math/Algorithm.js
var Algorithm = __webpack_require__(4559);
// EXTERNAL MODULE: ./src/x_ite/Namespace.js
var Namespace = __webpack_require__(6707);
;// ./src/standard/Math/Algorithms/MergeSort.js
function MergeSort (array, compare)
{
   this .array     = array;
   this .auxiliary = [ ];

   if (compare)
      this .compare = compare;
}

Object .assign (MergeSort .prototype,
{
   compare (lhs, rhs)
   {
      return lhs < rhs;
   },
   sort (first, last)
   {
      this .mergeSort (first, last - 1);
   },
   mergeSort (lo, hi)
   {
      if (lo < hi)
      {
         const m = (lo + hi) >>> 1;
         this .mergeSort (lo, m);   // Recursion
         this .mergeSort (m + 1, hi); // Recursion
         this .merge (lo, m, hi);
      }
   },
   merge (lo, m, hi)
   {
      const { array, auxiliary, compare } = this;

      let i, j, k;

      i = 0, j = lo;
      // Copy first half of array a to auxiliary array b.
      while (j <= m)
         auxiliary [i++] = array [j++];

      i = 0; k = lo;
      // Copy back next-greatest element at each time.
      while (k < j && j <= hi)
      {
         if (compare (array [j], auxiliary [i]))
            array [k++] = array [j++];
         else
            array [k++] = auxiliary [i++];
      }

      // Copy back remaining elements of first half (if any).
      while (k < j)
         array [k++] = auxiliary [i++];
   }
});

const __default__ = MergeSort;
;

/* harmony default export */ const Algorithms_MergeSort = (Namespace/* default */.A .add ("MergeSort", __default__));
// EXTERNAL MODULE: ./src/standard/Math/Geometry/Camera.js
var Camera = __webpack_require__(6832);
// EXTERNAL MODULE: ./src/standard/Math/Geometry/Line3.js
var Line3 = __webpack_require__(388);
// EXTERNAL MODULE: ./src/standard/Math/Geometry/ViewVolume.js
var ViewVolume = __webpack_require__(7364);
// EXTERNAL MODULE: ./src/standard/Math/Numbers/Vector3.js
var Vector3 = __webpack_require__(2639);
// EXTERNAL MODULE: ./src/standard/Math/Numbers/Vector4.js
var Vector4 = __webpack_require__(3630);
// EXTERNAL MODULE: ./src/standard/Math/Numbers/Rotation4.js
var Rotation4 = __webpack_require__(1029);
// EXTERNAL MODULE: ./src/standard/Math/Numbers/Matrix4.js
var Matrix4 = __webpack_require__(1048);
// EXTERNAL MODULE: ./src/standard/Math/Utility/MatrixStack.js
var MatrixStack = __webpack_require__(1698);
// EXTERNAL MODULE: ./src/standard/Math/Geometry/Plane3.js
var Plane3 = __webpack_require__(4828);
// EXTERNAL MODULE: ./src/standard/Time/StopWatch.js
var StopWatch = __webpack_require__(5946);
;// ./src/x_ite/Rendering/X3DRenderObject.js
















const DEPTH_BUFFER_SIZE = 16;

function X3DRenderObject (executionContext)
{
   const browser = executionContext .getBrowser ();

   this .partialRenderKey         = "";
   this .renderKey                = "";
   this .renderCount              = 0;
   this .view                     = null;
   this .viewVolumes              = [ ];
   this .projectionMatrix         = new MatrixStack/* default */.A (Matrix4/* default */.A);
   this .modelViewMatrix          = new MatrixStack/* default */.A (Matrix4/* default */.A);
   this .viewMatrix               = new MatrixStack/* default */.A (Matrix4/* default */.A);
   this .cameraSpaceMatrix        = new MatrixStack/* default */.A (Matrix4/* default */.A);
   this .viewportArray            = new Int32Array (4);
   this .projectionMatrixArray    = new Float32Array (16);
   this .eyeMatrixArray           = new Float32Array (16);
   this .viewMatrixArray          = new Float32Array (16);
   this .cameraSpaceMatrixArray   = new Float32Array (16);
   this .hitRay                   = new Line3/* default */.A ();
   this .sensors                  = [[ ]];
   this .viewpointGroups          = [ ];
   this .lights                   = [ ];
   this .globalLightsKeys         = [ ];
   this .globalLights             = [ ];
   this .localObjectsKeys         = [ ];
   this .localObjects             = [ ];
   this .globalShadows            = [ false ];
   this .globalShadow             = false;
   this .localShadows             = [ false ];
   this .localFogs                = [ null ];
   this .layouts                  = [ ];
   this .hAnimNode                = [ null ];
   this .invHumanoidMatrix        = new MatrixStack/* default */.A (Matrix4/* default */.A);
   this .generatedCubeMapTextures = [ ];
   this .collisions               = [ ];
   this .collisionTime            = new StopWatch/* default */.A ();
   this .numPointingShapes        = 0;
   this .numCollisionShapes       = 0;
   this .numShadowShapes          = 0;
   this .numOpaqueShapes          = 0;
   this .numTransparentShapes     = 0;
   this .pointingShapes           = [ ];
   this .collisionShapes          = [ ];
   this .activeCollisions         = [ ];
   this .shadowShapes             = [ ];
   this .opaqueShapes             = [ ];
   this .transparentShapes        = [ ];
   this .transparencySorter       = new Algorithms_MergeSort (this .transparentShapes, (a, b) => a .distance < b .distance);
   this .renderPasses             = 0;
   this .renderPass               = RenderPass/* default */.A .NONE;
   this .speed                    = 0;
   this .depthBuffer              = new TextureBuffer/* default */.A ({ browser, width: DEPTH_BUFFER_SIZE, height: DEPTH_BUFFER_SIZE, float: true, colorTextures: 2 });
}

Object .assign (X3DRenderObject .prototype,
{
   initialize ()
   {
      const browser = this .getBrowser ();

      browser .getRenderingProperties () ._Shading                 .addInterest ("set_renderKey__", this);
      browser .getRenderingProperties () ._LogarithmicDepthBuffer  .addInterest ("set_renderKey__", this);
      browser .getRenderingProperties () ._XRSession               .addInterest ("set_renderKey__", this);
      browser .getBrowserOptions () ._ColorSpace                   .addInterest ("set_renderKey__", this);
      browser .getBrowserOptions () ._OrderIndependentTransparency .addInterest ("set_renderKey__", this);
      browser .getBrowserOptions () ._ToneMapping                  .addInterest ("set_renderKey__", this);

      this .getViewpointStack ()  .addInterest ("set_renderKey__", this);

      this .set_renderKey__ ();
   },
   isIndependent ()
   {
      return true;
   },
   set_renderKey__ ()
   {
      const browser = this .getBrowser ();

      this .logarithmicDepthBuffer       = browser .getRenderingProperty ("LogarithmicDepthBuffer")
         || this .getViewpoint () .getLogarithmicDepthBuffer ();
      this .orderIndependentTransparency = browser .getBrowserOption ("OrderIndependentTransparency");

      let renderKey = "";

      renderKey += browser .getRenderingProperty ("Shading") === "FLAT" ? 1 : 0;
      renderKey += browser .getRenderingProperty ("XRSession")          ? 1 : 0;
      renderKey += this .logarithmicDepthBuffer                         ? 1 : 0;
      renderKey += this .orderIndependentTransparency                   ? 1 : 0;

      switch (browser .getBrowserOption ("ColorSpace"))
      {
         case "SRGB":
            renderKey += 0;
            break;
         default: // LINEAR_WHEN_PHYSICAL_MATERIAL
            renderKey += 1;
            break;
         case "LINEAR":
            renderKey += 2;
            break;
      }

      switch (browser .getBrowserOption ("ToneMapping"))
      {
         default: // NONE
            renderKey += 0;
            break;
         case "ACES_NARKOWICZ":
            renderKey += 1;
            break;
         case "ACES_HILL":
            renderKey += 2;
            break;
         case "ACES_HILL_EXPOSURE_BOOST":
            renderKey += 3;
            break;
         case "KHR_PBR_NEUTRAL":
            renderKey += 4;
            break;
      }

      this .partialRenderKey = renderKey;
   },
   getLogarithmicDepthBuffer ()
   {
      return this .logarithmicDepthBuffer;
   },
   getOrderIndependentTransparency ()
   {
      return this .orderIndependentTransparency;
   },
   getRenderKey ()
   {
      return this .renderKey;
   },
   getRenderCount ()
   {
      return this .renderCount;
   },
   advanceRenderCount: (() =>
   {
      let renderCount = 0;

      return function ()
      {
         if (renderCount === Number .MAX_SAFE_INTEGER)
            renderCount = 0;

         this .renderCount = ++ renderCount;
      }
   })(),
   getFramebuffers ()
   {
      return this .getBrowser () .getFramebuffers ();
   },
   getView ()
   {
      return this .view;
   },
   getViewVolumes ()
   {
      return this .viewVolumes;
   },
   getViewVolume ()
   {
      return this .viewVolumes .at (-1);
   },
   getProjectionMatrix ()
   {
      return this .projectionMatrix;
   },
   getProjectionMatrixWithLimits (nearValue, farValue, viewport)
   {
      return this .getViewpoint () .getProjectionMatrixWithLimits (nearValue, farValue, viewport);
   },
   getModelViewMatrix ()
   {
      return this .modelViewMatrix;
   },
   getViewMatrix ()
   {
      return this .viewMatrix;
   },
   getCameraSpaceMatrix ()
   {
      return this .cameraSpaceMatrix;
   },
   getViewportArray ()
   {
      return this .viewportArray;
   },
   getProjectionMatrixArray ()
   {
      return this .projectionMatrixArray;
   },
   getEyeMatrixArray ()
   {
      return this .eyeMatrixArray;
   },
   getViewMatrixArray ()
   {
      return this .viewMatrixArray;
   },
   getCameraSpaceMatrixArray ()
   {
      return this .cameraSpaceMatrixArray;
   },
   getHitRay ()
   {
      return this .hitRay;
   },
   getSensors ()
   {
      return this .sensors;
   },
   getViewpointGroups ()
   {
      return this .viewpointGroups;
   },
   getLights ()
   {
      return this .lights;
   },
   getGlobalLights ()
   {
      return this .globalLights;
   },
   getGlobalLightsKeys ()
   {
      return this .globalLightsKeys;
   },
   getLocalObjects ()
   {
      return this .localObjects;
   },
   getLocalObjectsKeys ()
   {
      return this .localObjectsKeys;
   },
   pushGlobalShadows (value)
   {
      this .globalShadows .push (value || this .globalShadows .at (-1));
   },
   getGlobalShadows ()
   {
      return this .globalShadows;
   },
   getGlobalShadow ()
   {
      return this .globalShadow;
   },
   pushLocalShadows (value)
   {
      this .localShadows .push (value || this .localShadows .at (-1));
   },
   popLocalShadows ()
   {
      this .localShadows .pop ();
   },
   setGlobalFog: (() =>
   {
      const modelViewMatrix = new Matrix4/* default */.A ();

      return function (fogNode)
      {
         if (fogNode .getFogType ())
         {
            const fogContainer = this .localFogs [0] || fogNode .getFogs () .pop ();

            modelViewMatrix .assign (fogNode .getModelMatrix ()) .multRight (this .getViewMatrix () .get ());
            fogContainer .set (fogNode, modelViewMatrix);

            this .localFogs [0] = fogContainer;
         }
         else
         {
            this .localFogs [0] = null;
         }
      };
   })(),
   getLocalFogs ()
   {
      return this .localFogs;
   },
   getLayouts ()
   {
      return this .layouts;
   },
   getParentLayout ()
   {
      return this .layouts .at (-1);
   },
   getHAnimNode ()
   {
      return this .hAnimNode;
   },
   getInvHumanoidMatrix ()
   {
      return this .invHumanoidMatrix;
   },
   getGeneratedCubeMapTextures ()
   {
      return this .generatedCubeMapTextures;
   },
   getCollisions ()
   {
      return this .collisions;
   },
   getCollisionTime ()
   {
      return this .collisionTime;
   },
   getNumPointingShapes ()
   {
      return this .numPointingShapes;
   },
   getPointingShapes ()
   {
      return this .pointingShapes;
   },
   getNumCollisionShapes ()
   {
      return this .numCollisionShapes;
   },
   getCollisionShapes ()
   {
      return this .collisionShapes;
   },
   getNumShadowShapes ()
   {
      return this .numShadowShapes;
   },
   getShadowShapes ()
   {
      return this .shadowShapes;
   },
   getNumOpaqueShapes ()
   {
      return this .numOpaqueShapes;
   },
   getOpaqueShapes ()
   {
      return this .opaqueShapes;
   },
   getNumTransparentShapes ()
   {
      return this .numTransparentShapes;
   },
   getTransparentShapes ()
   {
      return this .transparentShapes;
   },
   getRenderPass ()
   {
      return this .renderPass;
   },
   constrainTranslation: (() =>
   {
      const
         plane       = new Plane3/* default */.A (),
         point       = new Vector3/* default */.A (),
         closest     = new Vector3/* default */.A (),
         constrained = new Vector3/* default */.A ();

      return function (translation, stepBack = true, slide = true)
      {
         // Constrains a *translation*, which should be added to viewpoint position to a possible value that avatar can move to. If the avatar reaches or intersects with an obstacle the translation is either constrained to slide along the wall or to stop.

         // Constrain translation when the viewer collides with an obstacle.

         const
            closestObject   = this .getClosestObject (translation),
            collisionRadius = this .getNavigationInfo () .getCollisionRadius (),
            distance        = closestObject .distance - collisionRadius;

         if (distance > 0)
         {
            // Move.

            const length = translation .norm ();

            if (length > distance)
            {
               // Collision, the avatar would intersect with the obstacle.
               // Slide along normal plane.

               point .assign (translation) .normalize () .multiply (distance);

               if (!slide)
                  return point;

               const wallFriction = Algorithm/* default */.A .clamp (this .getBrowser () .getBrowserOption ("WallFriction"), 0, 1);

               // Project translation on normal plane.
               plane .set (point, closestObject .normal);
               plane .getClosestPointToPoint (translation, closest);

               // Project translation on up-vector plane.
               plane .set (Vector3/* default */.A .ZERO, this .getViewpoint () .getUpVector ());
               plane .getClosestPointToPoint (closest, constrained);

               // Adjust length.
               constrained .subtract (point) .normalize () .multiply (length * (1 - wallFriction));

               return this .constrainTranslation (constrained, false, false);
            }

            // Everything is fine.

            return translation;
         }

         // Collision, the avatar is already within an obstacle.

         if (stepBack)
         {
            point .assign (translation) .normalize () .multiply (distance);

            return this .constrainTranslation (point, false, false);
         }

         return translation .assign (Vector3/* default */.A .ZERO);
      };
   })(),
   getClosestObject: (() =>
   {
      const
         projectionMatrix     = new Matrix4/* default */.A (),
         viewProjectionMatrix = new Matrix4/* default */.A (),
         viewMatrix           = new Matrix4/* default */.A (),
         localOrientation     = new Rotation4/* default */.A (),
         rotation             = new Rotation4/* default */.A ();

      return function (direction)
      {
         ///  Returns the distance to the closest object in @a direction.  The maximum determinable value is avatarHeight * 2.

         this .collisionTime .start ();

         const
            navigationInfoNode = this .getNavigationInfo (),
            viewpointNode      = this .getViewpoint (),
            collisionRadius    = navigationInfoNode .getCollisionRadius (),
            bottom             = navigationInfoNode .getStepHeight () - navigationInfoNode .getAvatarHeight (),
            nearValue          = viewpointNode .getNearDistance (navigationInfoNode),
            avatarHeight       = navigationInfoNode .getAvatarHeight ();

         // Determine width and height of camera

         // Reshape camera

         Camera/* default */.A .ortho (-collisionRadius,
                        collisionRadius,
                        Math .min (bottom, -collisionRadius), /// TODO: bottom could be a positive value if stepHeight > avatarHeight.
                        collisionRadius,
                        nearValue,
                        Math .max (collisionRadius * 2, avatarHeight * 2),
                        projectionMatrix);

         // Translate camera to user position and to look in the direction of the direction.

         localOrientation
            .assign (viewpointNode ._orientation .getValue ())
            .inverse ()
            .multRight (viewpointNode .getOrientation ());

         rotation
            .setFromToVec (Vector3/* default */.A .NEGATIVE_Z_AXIS, direction)
            .multRight (localOrientation);

         viewpointNode .straightenHorizon (rotation);

         viewMatrix
            .assign (viewpointNode .getModelMatrix ())
            .translate (viewpointNode .getUserPosition ())
            .rotate (rotation)
            .inverse ()
            .multLeft (viewpointNode .getCameraSpaceMatrix ());

         viewProjectionMatrix
            .assign (viewMatrix)
            .multRight (projectionMatrix);

         this .getProjectionMatrix () .push (viewProjectionMatrix);

         const closestObject = this .getCollisionShape (projectionMatrix);

         closestObject .modelViewMatrix .multRight (viewMatrix) .submatrix
            .inverse () .multMatrixVec (closestObject .normal);

         rotation .multVecRot (closestObject .normal) .normalize ();

         this .getProjectionMatrix () .pop ();

         this .collisionTime .stop ();

         return closestObject;
      };
   })(),
   getCollisionShape: (() =>
   {
      const
         depthBufferViewport   = new Vector4/* default */.A (0, 0, DEPTH_BUFFER_SIZE, DEPTH_BUFFER_SIZE),
         depthBufferViewVolume = new ViewVolume/* default */.A (Matrix4/* default */.A .IDENTITY, depthBufferViewport),
         result                = { id: -1, distance: 0, normal: new Vector3/* default */.A (), modelViewMatrix: new Matrix4/* default */.A () };

      return function (projectionMatrix)
      {
         // Returns the depth value to the closest object.
         // The maximum determinable value is avatarHeight * 2.

         this .depthBuffer .bind ();
         this .viewVolumes .push (depthBufferViewVolume);

         this .depth (this .collisionShapes, this .numCollisionShapes, true);

         const depth = this .depthBuffer .readDepth (projectionMatrix, depthBufferViewport, result);

         this .viewVolumes .pop ();

         if (depth .id < 0)
         {
            depth .node = null;
         }
         else
         {
            const renderContext = this .collisionShapes [depth .id];

            depth .node = renderContext .shapeNode;
            depth .modelViewMatrix .assign (renderContext .modelViewMatrix);
         }

         return depth;
      };
   })(),
   render (type, callback, group)
   {
      switch (type)
      {
         case TraverseType/* default */.A .POINTER:
         {
            this .numPointingShapes = 0;

            callback .call (group, type, this);
            this .pointing (this .pointingShapes, this .numPointingShapes);
            break;
         }
         case TraverseType/* default */.A .COLLISION:
         {
            // Collect for collide and gravitate
            this .numCollisionShapes = 0;

            callback .call (group, type, this);
            this .collide ();
            this .gravitate ();
            break;
         }
         case TraverseType/* default */.A .SHADOW:
         {
            this .numShadowShapes = 0;

            callback .call (group, type, this);
            this .depth (this .shadowShapes, this .numShadowShapes, false);
            break;
         }
         case TraverseType/* default */.A .DISPLAY:
         {
            this .lightIndex           = 0;
            this .renderPasses         = 0;
            this .numOpaqueShapes      = 0;
            this .numTransparentShapes = 0;

            this .setGlobalFog (this .getFog ());

            callback .call (group, type, this);
            this .draw ();
            break;
         }
      }
   },
   setHitRay (projectionMatrix, viewport, pointer)
   {
      ViewVolume/* default */.A .unProjectRay (pointer .x, pointer .y, Matrix4/* default */.A .IDENTITY, projectionMatrix, viewport, this .hitRay);
   },
   addPointingShape: (() =>
   {
      const
         bboxSize   = new Vector3/* default */.A (),
         bboxCenter = new Vector3/* default */.A ();

      return function (shapeNode)
      {
         const modelViewMatrix = this .getModelViewMatrix () .get ();

         modelViewMatrix .multDirMatrix (bboxSize   .assign (shapeNode .getBBoxSize ()));
         modelViewMatrix .multVecMatrix (bboxCenter .assign (shapeNode .getBBoxCenter ()));

         const
            radius     = bboxSize .norm () / 2,
            viewVolume = this .viewVolumes .at (-1);

         if (!viewVolume .intersectsSphere (radius, bboxCenter))
            return false;

         const num = this .numPointingShapes ++;

         if (num === this .pointingShapes .length)
         {
            const renderContext = {
               renderObject: this,
               modelViewMatrix: new Float32Array (16),
               viewport: new Vector4/* default */.A (),
               clipPlanes: [ ],
               sensors: [ ],
               get renderContext () { return this; },
            };

            this .pointingShapes .push (renderContext);
         }

         const renderContext = this .pointingShapes [num];

         renderContext .modelViewMatrix .set (modelViewMatrix);
         renderContext .viewport .assign (viewVolume .getViewport ());
         renderContext .hAnimNode = this .hAnimNode .at (-1);
         renderContext .shapeNode = shapeNode;

         // Clip planes & sensors

         X3DRenderObject_assign (renderContext .clipPlanes, this .localObjects);
         X3DRenderObject_assign (renderContext .sensors,    this .sensors .at (-1));

         return true;
      };
   })(),
   addCollisionShape: (() =>
   {
      const
         bboxSize   = new Vector3/* default */.A (),
         bboxCenter = new Vector3/* default */.A ();

      return function (shapeNode)
      {
         const modelViewMatrix = this .getModelViewMatrix () .get ();

         modelViewMatrix .multDirMatrix (bboxSize   .assign (shapeNode .getBBoxSize ()));
         modelViewMatrix .multVecMatrix (bboxCenter .assign (shapeNode .getBBoxCenter ()));

         const
            radius     = bboxSize .norm () / 2,
            viewVolume = this .viewVolumes .at (-1);

         if (!viewVolume .intersectsSphere (radius, bboxCenter))
            return false;

         const num = this .numCollisionShapes ++;

         if (num === this .collisionShapes .length)
         {
            const renderContext = {
               renderObject: this,
               modelViewMatrix: new Float32Array (16),
               collisions: [ ],
               clipPlanes: [ ],
               get renderContext () { return this; },
            };

            this .collisionShapes .push (renderContext);
         }

         const renderContext = this .collisionShapes [num];

         renderContext .modelViewMatrix .set (modelViewMatrix);
         renderContext .hAnimNode = this .hAnimNode .at (-1);
         renderContext .shapeNode = shapeNode;

         // Clip planes & Collision nodes

         X3DRenderObject_assign (renderContext .clipPlanes, this .localObjects);
         X3DRenderObject_assign (renderContext .collisions, this .collisions);

         return true;
      };
   })(),
   addShadowShape: (() =>
   {
      const
         bboxSize   = new Vector3/* default */.A (),
         bboxCenter = new Vector3/* default */.A ();

      return function (shapeNode)
      {
         const modelViewMatrix = this .getModelViewMatrix () .get ();

         modelViewMatrix .multDirMatrix (bboxSize   .assign (shapeNode .getBBoxSize ()));
         modelViewMatrix .multVecMatrix (bboxCenter .assign (shapeNode .getBBoxCenter ()));

         const
            radius     = bboxSize .norm () / 2,
            viewVolume = this .viewVolumes .at (-1);

         if (!viewVolume .intersectsSphere (radius, bboxCenter))
            return false;

         const num = this .numShadowShapes ++;

         if (num === this .shadowShapes .length)
         {
            const renderContext = {
               renderObject: this,
               modelViewMatrix: new Float32Array (16),
               viewport: new Vector4/* default */.A (),
               clipPlanes: [ ],
               get renderContext () { return this; },
            };

            this .shadowShapes .push (renderContext);
         }

         const renderContext = this .shadowShapes [num];

         renderContext .modelViewMatrix .set (modelViewMatrix);
         renderContext .viewport .assign (viewVolume .getViewport ());
         renderContext .hAnimNode = this .hAnimNode .at (-1);
         renderContext .shapeNode = shapeNode;

         // Clip planes

         X3DRenderObject_assign (renderContext .clipPlanes, this .localObjects);

         return true;
      };
   })(),
   addDisplayShape: (() =>
   {
      const
         bboxSize   = new Vector3/* default */.A (),
         bboxCenter = new Vector3/* default */.A ();

      return function (shapeNode)
      {
         const modelViewMatrix = this .getModelViewMatrix () .get ();

         modelViewMatrix .multDirMatrix (bboxSize   .assign (shapeNode .getBBoxSize ()));
         modelViewMatrix .multVecMatrix (bboxCenter .assign (shapeNode .getBBoxCenter ()));

         const
            radius     = bboxSize .norm () / 2,
            viewVolume = this .viewVolumes .at (-1);

         if (!viewVolume .intersectsSphere (radius, bboxCenter))
            return false;

         let renderContext;

         if (shapeNode .isTransparent ())
         {
            const num = this .numTransparentShapes ++;

            if (num === this .transparentShapes .length)
               this .transparentShapes .push (this .createRenderContext (true));

            renderContext = this .transparentShapes [num];

            renderContext .distance = bboxCenter .z;
         }
         else
         {
            const num = this .numOpaqueShapes ++;

            if (num === this .opaqueShapes .length)
               this .opaqueShapes .push (this .createRenderContext (false));

            renderContext = this .opaqueShapes [num];
         }

         this .renderPasses |= shapeNode .getRenderPasses ();

         renderContext .modelViewMatrix .set (modelViewMatrix);
         renderContext .viewport .assign (viewVolume .getViewport ());

         renderContext .shadows        = this .localShadows .at (-1);
         renderContext .fogNode        = this .localFogs .at (-1);
         renderContext .hAnimNode      = this .hAnimNode .at (-1);
         renderContext .shapeNode      = shapeNode;
         renderContext .appearanceNode = shapeNode .getAppearance ();

         // Clip planes and local lights

         X3DRenderObject_assign (renderContext .localObjects,     this .localObjects); // ClipPane, X3DLightNode
         X3DRenderObject_assign (renderContext .localObjectsKeys, this .localObjectsKeys);

         return true;
      };
   })(),
   createRenderContext (transparent)
   {
      return {
         renderObject: this,
         transparent: transparent,
         modelViewMatrix: new Float32Array (16),
         viewport: new Vector4/* default */.A (),
         localObjects: [ ],
         localObjectsKeys: [ ], // [clip planes, lights]
         get renderContext () { return this; },
      };
   },
   pointing: (() =>
   {
      const projectionMatrixArray = new Float32Array (16);

      return function (shapes, numShapes)
      {
         const
            browser  = this .getBrowser (),
            gl       = browser .getContext (),
            viewport = this .viewVolumes .at (-1) .getViewport (),
            { x, y } = browser .getPointer ();

         // Configure depth shaders.

         projectionMatrixArray .set (this .getProjectionMatrix () .get ());

         // Configure viewport and background.

         gl .viewport (viewport .x - x,
                       viewport .y - y,
                       viewport .z,
                       viewport .w);

         gl .scissor (0, 0, 1, 1);
         gl .clear (gl .DEPTH_BUFFER_BIT);

         // Render all objects.

         gl .disable (gl .CULL_FACE);

         for (let s = 0; s < numShapes; ++ s)
         {
            const
               { renderContext, modelViewMatrix, viewport, shapeNode, hAnimNode, clipPlanes } = shapes [s],
               appearanceNode      = shapeNode .getAppearance (),
               geometryContext     = shapeNode .getGeometryContext (),
               depthModeNode       = appearanceNode .getDepthMode (),
               stylePropertiesNode = appearanceNode .getStyleProperties (geometryContext .geometryType),
               shaderNode          = browser .getPointingShader (clipPlanes .length, shapeNode, hAnimNode),
               id                  = browser .addPointingShape (renderContext);

            gl .viewport (viewport .x - x,
                          viewport .y - y,
                          viewport .z,
                          viewport .w);

            // Draw shape.

            shaderNode .enable (gl);
            shaderNode .setClipPlanes (gl, clipPlanes);

            gl .uniformMatrix4fv (shaderNode .x3d_ProjectionMatrix, false, projectionMatrixArray);
            gl .uniformMatrix4fv (shaderNode .x3d_ModelViewMatrix,  false, modelViewMatrix);
            gl .uniform1f (shaderNode .x3d_Id, id);

            depthModeNode       ?.enable (gl);
            stylePropertiesNode ?.setShaderUniforms (gl, shaderNode);
            hAnimNode           ?.setShaderUniforms (gl, shaderNode);

            shapeNode .displaySimple (gl, renderContext, shaderNode);

            depthModeNode ?.disable (gl);
            browser .resetTextureUnits ();
         }
      };
   })(),
   collide: (() =>
   {
      const axes = [
         Vector3/* default */.A .X_AXIS,
         Vector3/* default */.A .Y_AXIS,
         Vector3/* default */.A .Z_AXIS,
         Vector3/* default */.A .NEGATIVE_X_AXIS,
         Vector3/* default */.A .NEGATIVE_Y_AXIS,
         Vector3/* default */.A .NEGATIVE_Z_AXIS,
      ];

      const
         closestShapes    = new Set (),
         activeCollisions = [ ]; // current active Collision nodes

      return function ()
      {
         const browser = this .getBrowser ();

         // Check if there are enabled Collision nodes.
         if (!browser .getCollisionCount ())
            return;

         // Collision nodes are handled here.

         const collisionRadius = this .getNavigationInfo () .getCollisionRadius () * Math .SQRT2;

         if (this .numCollisionShapes)
         {
            for (const axis of axes)
            {
               const closestObject = this .getClosestObject (axis);

               if (closestObject .id < 0)
                  continue;

               if (closestObject .distance > collisionRadius)
                  continue;

               closestShapes .add (closestObject .id);
            }

            for (const i of closestShapes)
            {
               const { collisions } = this .collisionShapes [i];

               for (const collision of collisions)
                  activeCollisions .push (collision);
            }

            closestShapes .clear ();
         }

         // Set isActive to FALSE for affected nodes.

         for (const collision of this .activeCollisions)
         {
            if (activeCollisions .includes (collision))
               continue;

            collision .set_active__ (false);
         }

         // Set isActive to TRUE for affected nodes.

         for (const collision of activeCollisions)
            collision .set_active__ (true);

         X3DRenderObject_assign (this .activeCollisions, activeCollisions);

         activeCollisions .length = 0;
      };
   })(),
   gravitate: (() =>
   {
      const
         projectionMatrix     = new Matrix4/* default */.A (),
         viewProjectionMatrix = new Matrix4/* default */.A (),
         translation          = new Vector3/* default */.A (),
         rotation             = new Rotation4/* default */.A ();

      return function ()
      {
         const browser = this .getBrowser ();

         // Terrain following and gravitation.

         if (browser .getActiveLayer () === this)
         {
            if (browser .getCurrentViewer () !== "WALK")
               return;
         }
         else
         {
            return;
         }

         // Get NavigationInfo values.

         const
            navigationInfoNode = this .getNavigationInfo (),
            viewpointNode      = this .getViewpoint (),
            collisionRadius    = navigationInfoNode .getCollisionRadius (),
            avatarHeight       = navigationInfoNode .getAvatarHeight (),
            stepHeight         = navigationInfoNode .getStepHeight (),
            nearValue          = viewpointNode .getNearDistance (navigationInfoNode);

         // Reshape viewpoint for gravitate.

         Camera/* default */.A .ortho (-collisionRadius,
                        collisionRadius,
                        -collisionRadius,
                        collisionRadius,
                        nearValue,
                        Math .max (collisionRadius, avatarHeight) * 2,
                        projectionMatrix);

         // Transform viewpoint to look down the up vector.

         const
            upVector = viewpointNode .getUpVector (),
            down     = rotation .setFromToVec (Vector3/* default */.A .Z_AXIS, upVector);

         viewProjectionMatrix
            .assign (viewpointNode .getModelMatrix ())
            .translate (viewpointNode .getUserPosition ())
            .rotate (down)
            .inverse ()
            .multRight (projectionMatrix)
            .multLeft (viewpointNode .getCameraSpaceMatrix ());

         this .getProjectionMatrix () .push (viewProjectionMatrix);

         const depth = this .getCollisionShape (projectionMatrix);

         let distance = depth .distance;

         this .getProjectionMatrix () .pop ();

         // gravitate or step up.

         distance -= avatarHeight;

         const up = rotation .setFromToVec (Vector3/* default */.A .Y_AXIS, upVector);

         if (distance > 0)
         {
            // Gravitate and fall down the to the floor.

            const currentFrameRate = this .speed ? browser .getCurrentFrameRate () : 1000000;

            this .speed -= browser .getBrowserOptions () ._Gravity .getValue () / currentFrameRate;

            let dy = this .speed / currentFrameRate;

            if (dy < -distance)
            {
               // The ground has been reached.

               dy = -distance;

               this .speed = 0;
            }

            const falling = up .multVecRot (translation .set (0, dy, 0));

            viewpointNode ._positionOffset = falling .add (viewpointNode ._positionOffset .getValue ());
         }
         else
         {
            this .speed = 0;

            distance = -distance;

            if (distance > 0.01 && distance < stepHeight)
            {
               // Step up.

               const step = up .multVecRot (translation .set (0, distance, 0));

               viewpointNode ._positionOffset = step .add (viewpointNode ._positionOffset .getValue ());
            }
         }
      };
   })(),
   depth: (() =>
   {
      const projectionMatrixArray = new Float32Array (16);

      return function (shapes, numShapes, normal)
      {
         const
            browser  = this .getBrowser (),
            gl       = browser .getContext (),
            viewport = this .viewVolumes .at (-1) .getViewport ();

         // Configure depth shaders.

         projectionMatrixArray .set (this .getProjectionMatrix () .get ());

         // Configure viewport and background

         gl .viewport (... viewport);
         gl .scissor (... viewport);

         gl .clearColor (1, -1, -1, -1); // '1' for infinity, '-1' for no hit.
         gl .clear (gl .COLOR_BUFFER_BIT | gl .DEPTH_BUFFER_BIT);

         // Render all objects

         gl .disable (gl .CULL_FACE);

         for (let s = 0; s < numShapes; ++ s)
         {
            const
               { renderContext, clipPlanes, modelViewMatrix, shapeNode, hAnimNode } = shapes [s],
               appearanceNode      = shapeNode .getAppearance (),
               geometryContext     = shapeNode .getGeometryContext (),
               stylePropertiesNode = appearanceNode .getStyleProperties (geometryContext .geometryType),
               shaderNode          = browser .getDepthShader (normal, clipPlanes .length, shapeNode, hAnimNode);

            // Cannot change viewport here, because the viewport is special here.

            // Draw

            shaderNode .enable (gl);
            shaderNode .setClipPlanes (gl, clipPlanes);

            gl .uniform1i (shaderNode .x3d_Id, s);
            gl .uniformMatrix4fv (shaderNode .x3d_ProjectionMatrix, false, projectionMatrixArray);
            gl .uniformMatrix4fv (shaderNode .x3d_ModelViewMatrix,  false, modelViewMatrix);

            stylePropertiesNode ?.setShaderUniforms (gl, shaderNode);
            hAnimNode           ?.setShaderUniforms (gl, shaderNode);

            shapeNode .displaySimple (gl, renderContext, shaderNode);
            browser .resetTextureUnits ();
         }
      };
   })(),
   draw ()
   {
      const
         independent              = this .isIndependent (),
         browser                  = this .getBrowser (),
         gl                       = browser .getContext (),
         pose                     = browser .getPose (),
         framebuffers             = this .getFramebuffers (),
         numFramebuffers          = framebuffers .length,
         viewport                 = this .viewVolumes .at (-1) .getViewport (),
         lights                   = this .lights,
         globalLightsKeys         = this .globalLightsKeys,
         globalLightsKey          = globalLightsKeys .join (""),
         globalLights             = this .globalLights,
         generatedCubeMapTextures = this .generatedCubeMapTextures,
         globalShadows            = this .globalShadows,
         headlight                = this .getNavigationInfo () ._headlight .getValue ();

      // PREPARATIONS

      // Set matrices.

      this .viewportArray          .set (viewport);
      this .viewMatrixArray        .set (this .getViewMatrix () .get ());
      this .cameraSpaceMatrixArray .set (this .getCameraSpaceMatrix () .get ());

      if (independent)
      {
         // Render shadow maps and prepare texture projectors.

         for (const light of lights)
            light .renderShadowMap (this);

         // Render GeneratedCubeMapTexture nodes.

         for (const generatedCubeMapTexture of generatedCubeMapTextures)
            generatedCubeMapTexture .renderTexture (this);
      }

      this .globalShadow = globalShadows .at (-1);

      // DRAW

      // Sort transparent shapes.

      if (!this .orderIndependentTransparency)
      {
         const { numTransparentShapes, transparencySorter } = this;

         transparencySorter .sort (0, numTransparentShapes);
      }

      // Draw to all framebuffers.

      for (let i = 0; i < numFramebuffers; ++ i)
      {
         this .advanceRenderCount ();

         // Set matrices with XR support.

         const view = this .view = pose ?.views [i];

         if (view)
         {
            this .projectionMatrixArray .set (view .projectionMatrix);
            this .eyeMatrixArray        .set (view .matrix);
         }
         else
         {
            this .projectionMatrixArray .set (this .getProjectionMatrix () .get ());
            this .eyeMatrixArray        .set (Matrix4/* default */.A .IDENTITY);
         }

         // Set up shadow matrix for all lights, and matrices for all projective textures.

         if (headlight)
            browser .getHeadlight () .setGlobalVariables (this);

         for (const light of lights)
            light .setGlobalVariables (this);

         // Render transmission texture and volume scatter texture.

         if (this .renderPasses !== RenderPass/* default */.A .NONE)
         {
            // Render to volume scatter buffer.

            if (this .renderPasses & RenderPass/* default */.A .VOLUME_SCATTER_BIT)
            {
               browser .resetShapeId ();

               this .renderPass = RenderPass/* default */.A .VOLUME_SCATTER_KEY;
               this .renderKey  = `.${this .partialRenderKey}.${this .renderPass}.${globalLightsKey}.`;

               const volumeScatterBuffer = browser .getVolumeScatterBuffer ();

               this .drawShapes (RenderPass/* default */.A .VOLUME_SCATTER_KEY, gl, browser, volumeScatterBuffer, gl .COLOR_BUFFER_BIT, viewport);
            }

            // Render to transmission buffer.

            if (this .renderPasses & RenderPass/* default */.A .TRANSMISSION_BIT)
            {
               this .renderPass = RenderPass/* default */.A .TRANSMISSION_KEY;
               this .renderKey  = `.${this .partialRenderKey}.${this .renderPass}.${globalLightsKey}.`;

               const transmissionBuffer = browser .getTransmissionBuffer ();

               this .drawShapes (RenderPass/* default */.A .TRANSMISSION_KEY, gl, browser, transmissionBuffer, gl .COLOR_BUFFER_BIT, viewport);

               // Mipmap is later selected based on roughness and ior.
               gl .bindTexture (gl .TEXTURE_2D, transmissionBuffer .getColorTexture ());
               gl .generateMipmap (gl .TEXTURE_2D);
            }
         }

         // Draw with sorted blend or OIT.

         this .renderPass = RenderPass/* default */.A .RENDER_KEY;
         this .renderKey  = `.${this .partialRenderKey}.${this .renderPass}.${globalLightsKey}.`;

         const frameBuffer = framebuffers [i];

         this .drawShapes (RenderPass/* default */.A .RENDER_KEY, gl, browser, frameBuffer, 0, viewport);
      }

      this .view = null;

      // POST DRAW

      if (independent)
      {
         // Recycle clip planes, local fogs, local lights, and local projective textures.

         const localObjects = browser .getLocalObjects ();

         for (const localObject of localObjects)
            localObject .dispose ();

         localObjects .length = 0;

         // Recycle global lights and global projective textures.

         for (const globalObject of globalLights)
            globalObject .dispose ();

         browser .resetGlobalTextureUnits ();
      }

      // Reset containers.

      globalLightsKeys         .length = 0;
      globalLights             .length = 0;
      lights                   .length = 0;
      globalShadows            .length = 1;
      generatedCubeMapTextures .length = 0;
   },
   drawShapes (renderPass, gl, browser, frameBuffer, clearBits, viewport)
   {
      const { opaqueShapes, numOpaqueShapes, transparentShapes, numTransparentShapes } = this;

      frameBuffer .bind ();

      // Configure viewport and background.

      gl .viewport (... viewport);
      gl .scissor (... viewport);

      // Draw background.

      gl .clearColor (0, 0, 0, 0);
      gl .clear (gl .DEPTH_BUFFER_BIT | clearBits);
      gl .blendFuncSeparate (gl .SRC_ALPHA, gl .ONE_MINUS_SRC_ALPHA, gl .ONE, gl .ONE_MINUS_SRC_ALPHA);

      this .getBackground () [renderPass] ?.display (gl, this);

      // Use sorted blend or order independent transparency.
      // Render opaque objects first.

      for (let i = 0; i < numOpaqueShapes; ++ i)
      {
         const { renderContext, shapeNode } = opaqueShapes [i];

         shapeNode [renderPass] ?.display (gl, renderContext);
      }

      // Render transparent objects.

      if (frameBuffer .getOIT ())
         frameBuffer .bindTransparency ();

      gl .depthMask (false);
      gl .enable (gl .BLEND);

      for (let i = 0; i < numTransparentShapes; ++ i)
      {
         const { renderContext, shapeNode } = transparentShapes [i];

         shapeNode [renderPass] ?.display (gl, renderContext);
      }

      gl .depthMask (true);
      gl .disable (gl .BLEND);

      if (frameBuffer .getOIT ())
         frameBuffer .compose ();
   },
});

function X3DRenderObject_assign (lhs, rhs)
{
   const length = rhs .length;

   for (let i = 0; i < length; ++ i)
      lhs [i] = rhs [i];

   lhs .length = length;
}

const X3DRenderObject_default_ = X3DRenderObject;
;

/* harmony default export */ const Rendering_X3DRenderObject = (Namespace/* default */.A .add ("X3DRenderObject", X3DRenderObject_default_));
// EXTERNAL MODULE: ./src/x_ite/Base/X3DBaseNode.js + 1 modules
var X3DBaseNode = __webpack_require__(7982);
;// ./src/x_ite/Execution/BindableStack.js


function BindableStack (executionContext, defaultNode)
{
   X3DBaseNode/* default */.A .call (this, executionContext);

   this .nodes = [ defaultNode ];
}

Object .assign (Object .setPrototypeOf (BindableStack .prototype, X3DBaseNode/* default */.A .prototype),
{
   get ()
   {
      return this .nodes;
   },
   top ()
   {
      return this .nodes .at (-1);
   },
   pushOnTop (node)
   {
      if (node !== this .nodes [0])
      {
         this .nodes .at (-1) ._isBound = false;
         this .nodes .push (node);
      }

      // Don't do set_bind.
      node ._isBound  = true;
      node ._bindTime = this .getBrowser () .getCurrentTime ();

      this .addNodeEvent ();
   },
   update (layerNode, removedNodes, changedNodes)
   {
      if (!removedNodes .length && !changedNodes .length)
         return;

      // Save top node for later use.

      const
         fromNode  = this .top (),
         boundNode = this .nodes .at (-1);

      // Remove invisible nodes and unbind them if needed.

      for (const removedNode of removedNodes)
      {
         const index = this .nodes .indexOf (removedNode);

         if (index > 0)
            this .nodes .splice (index, 1);
      }

      // Unbind nodes with set_bind false and pop top node.

      if (boundNode !== this .nodes [0])
      {
         if (changedNodes .some (node => !node ._set_bind .getValue () && node === boundNode))
         {
            this .nodes .pop ();
         }
      }

      // Push nodes with set_bind true to top of stack.

      for (const bindNode of changedNodes)
      {
         if (!bindNode ._set_bind .getValue ())
            continue;

         const index = this .nodes .indexOf (bindNode);

         if (index > -1)
            this .nodes .splice (index, 1);

         this .nodes .push (bindNode);
      }

      // Bind top node if not bound.

      const top = this .nodes .at (-1);

      if (top !== boundNode)
      {
         // First unbind last bound node.

         boundNode ._isBound = false;

         // Now bind new top node.

         top ._isBound  = true;
         top ._bindTime = this .getBrowser () .getCurrentTime ();

         // Do transition.

         top .transitionStart (layerNode, fromNode);
      }
      else
      {
         // Do transition.

         if (changedNodes .includes (top))
            top .transitionStart (layerNode, fromNode);
      }

      this .addNodeEvent ();
   },
});

for (const key of Object .keys (BindableStack .prototype))
   Object .defineProperty (BindableStack .prototype, key, { enumerable: false });

Object .defineProperties (BindableStack,
{
   typeName:
   {
      value: "BindableStack",
      enumerable: true,
   },
});

const BindableStack_default_ = BindableStack;
;

/* harmony default export */ const Execution_BindableStack = (Namespace/* default */.A .add ("BindableStack", BindableStack_default_));
// EXTERNAL MODULE: ./src/x_ite/Components/Core/X3DBindableNode.js
var X3DBindableNode = __webpack_require__(9108);
;// ./src/x_ite/Execution/BindableList.js



function BindableList (executionContext, defaultNode)
{
   X3DBaseNode/* default */.A .call (this, executionContext);

   this .modificationCount = 0;
   this .nodes             = [ defaultNode ];
   this .collectedNodes    = [ defaultNode ];
   this .changedNodes      = [ ];
   this .removedNodes      = [ ];
}

Object .assign (Object .setPrototypeOf (BindableList .prototype, X3DBaseNode/* default */.A .prototype),
{
   get ()
   {
      return this .nodes;
   },
   getBound (name)
   {
      const length = this .nodes .length;

      if (length === 1)
         return this .nodes [0]; // Return default viewpoint.

      const enableInlineBindables = false;

      if (name)
      {
         // Return first viewpoint with @name.

         for (let i = 1; i < length; ++ i)
         {
            const
               node  = this .nodes [i],
               scene = node .getExecutionContext () .getOuterNode () ?.getScene () ?? node .getScene ();

            if (!enableInlineBindables && scene .getExecutionContext ())
               continue;

            if (node .getName () == name)
               return node;
         }
      }

      // Return first bound viewpoint in scene.

      for (let i = 1; i < length; ++ i)
      {
         const
            node  = this .nodes [i],
            scene = node .getExecutionContext () .getOuterNode () ?.getScene () ?? node .getScene ();

         if (!enableInlineBindables && scene .getExecutionContext ())
            continue;

         if (node ._isBound .getValue ())
            return node;
      }

      // Return first viewpoint in scene.

      for (let i = 1; i < length; ++ i)
      {
         const
            node  = this .nodes [i],
            scene = node .getExecutionContext () .getOuterNode () ?.getScene () ?? node .getScene ();

         if (!enableInlineBindables && scene .getExecutionContext ())
            continue;

         return node;
      }

      return this .nodes [0]; // Return default viewpoint.
   },
   push (node)
   {
      return this .collectedNodes .push (node);
   },
   update (layerNode, stack)
   {
      const { collectedNodes, changedNodes, removedNodes } = this;

      for (const node of collectedNodes)
      {
         if (node .getModificationCount () > this .modificationCount)
            changedNodes .push (node);
      }

      if (!equals (collectedNodes, this .nodes))
      {
         // Unbind nodes not in current list (collectedNodes);

         for (const node of this .nodes)
         {
            if (!collectedNodes .includes (node))
               removedNodes .push (node);
         }

         // Swap nodes.

         const tmp = this .nodes;

         this .nodes          = collectedNodes;
         this .collectedNodes = tmp;

         this .addNodeEvent ();
      }

      // Clear collected nodes.

      this .collectedNodes .length = 1;

      // Update stack.

      stack .update (layerNode, removedNodes, changedNodes)

      changedNodes .length = 0;
      removedNodes .length = 0;

      // Advance modificationCount time.

      this .modificationCount = X3DBindableNode/* default */.A .getModificationCount ();
   },
});

for (const key of Object .keys (BindableList .prototype))
   Object .defineProperty (BindableList .prototype, key, { enumerable: false });

// Compares two arrays.

function equals (lhs, rhs)
{
   const lhsLength = lhs .length;

   if (lhsLength !== rhs .length)
      return false;

   for (let i = 0; i < lhsLength; ++ i)
   {
      if (lhs [i] !== rhs [i])
         return false;
   }

   return true;
}

Object .defineProperties (BindableList,
{
   typeName:
   {
      value: "BindableList",
      enumerable: true,
   },
});

const BindableList_default_ = BindableList;
;

/* harmony default export */ const Execution_BindableList = (Namespace/* default */.A .add ("BindableList", BindableList_default_));
// EXTERNAL MODULE: ./src/x_ite/Components/Grouping/Group.js
var Group = __webpack_require__(1209);
// EXTERNAL MODULE: ./src/x_ite/Components/Navigation/NavigationInfo.js
var NavigationInfo = __webpack_require__(635);
// EXTERNAL MODULE: ./src/x_ite/Components/EnvironmentalEffects/Fog.js
var Fog = __webpack_require__(9689);
// EXTERNAL MODULE: ./src/x_ite/Components/EnvironmentalEffects/Background.js
var Background = __webpack_require__(3265);
// EXTERNAL MODULE: ./src/x_ite/Base/X3DCast.js
var X3DCast = __webpack_require__(4667);
// EXTERNAL MODULE: ./src/x_ite/Base/X3DConstants.js
var X3DConstants = __webpack_require__(8899);
// EXTERNAL MODULE: ./src/standard/Math/Geometry/Box3.js
var Box3 = __webpack_require__(5837);
;// ./src/x_ite/Components/Layering/X3DLayerNode.js

















function X3DLayerNode (executionContext, defaultViewpoint, groupNode)
{
   X3DNode/* default */.A         .call (this, executionContext);
   Rendering_X3DRenderObject .call (this, executionContext);

   this .addType (X3DConstants/* default */.A .X3DLayerNode);

   this .addChildObjects (X3DConstants/* default */.A .inputOutput, "hidden",  new Fields/* default */.A .SFBool (),
                          X3DConstants/* default */.A .outputOnly,  "display", new Fields/* default */.A .SFBool (true));

   // Legacy

   if (executionContext .getSpecificationVersion () <= 3.3)
      this .addAlias ("isPickable", this ._pickable);

   // Create main Group node.
   // This Group node is setuped in Layer or LayoutLayer.

   let groupNodes;

   if (executionContext .hasComponent ("Picking"))
   {
      groupNodes = executionContext .createNode ("PickableGroup", false);

      if (groupNodes)
      {
         this ._pickable   .addFieldInterest (groupNodes ._pickable);
         this ._objectType .addFieldInterest (groupNodes ._objectType);
      }
   }

   groupNodes ??= new Group/* default */.A (executionContext);

   groupNodes ._children = [groupNode];
   groupNodes .setPrivate (true);

   // Private properties

   this .active     = false;
   this .layer0     = false;
   this .groupNodes = groupNodes;

   this .defaultNavigationInfo = new NavigationInfo/* default */.A (executionContext);
   this .defaultViewpoint      = defaultViewpoint;
   this .defaultBackground     = new Background/* default */.A (executionContext);
   this .defaultFog            = new Fog/* default */.A (executionContext);

   this .navigationInfoStack = new Execution_BindableStack (executionContext, this .defaultNavigationInfo);
   this .viewpointStack      = new Execution_BindableStack (executionContext, this .defaultViewpoint);
   this .backgroundStack     = new Execution_BindableStack (executionContext, this .defaultBackground);
   this .fogStack            = new Execution_BindableStack (executionContext, this .defaultFog);

   this .navigationInfos = new Execution_BindableList (executionContext, this .defaultNavigationInfo);
   this .viewpoints      = new Execution_BindableList (executionContext, this .defaultViewpoint);
   this .backgrounds     = new Execution_BindableList (executionContext, this .defaultBackground);
   this .fogs            = new Execution_BindableList (executionContext, this .defaultFog);

   this .defaultBackground .setHidden (true);
   this .defaultFog        .setHidden (true);
}

Object .assign (Object .setPrototypeOf (X3DLayerNode .prototype, X3DNode/* default */.A .prototype),
   Rendering_X3DRenderObject .prototype,
{
   layer0: false,
   initialize ()
   {
      X3DNode/* default */.A         .prototype .initialize .call (this);
      Rendering_X3DRenderObject .prototype .initialize .call (this);

      this .defaultNavigationInfo .setup ();
      this .defaultViewpoint      .setup ();
      this .defaultBackground     .setup ();
      this .defaultFog            .setup ();

      this .navigationInfoStack .setup ();
      this .viewpointStack      .setup ();
      this .backgroundStack     .setup ();
      this .fogStack            .setup ();

      this .navigationInfos .setup ();
      this .viewpoints      .setup ();
      this .backgrounds     .setup ();
      this .fogs            .setup ();

      this ._hidden   .addInterest ("set_visible_and_hidden__", this);
      this ._visible  .addInterest ("set_visible_and_hidden__", this);
      this ._viewport .addInterest ("set_viewport__",           this);

      this .set_visible_and_hidden__ ();
      this .set_viewport__ ();
   },
   isHidden ()
   {
      return this ._hidden .getValue ();
   },
   setHidden (value)
   {
      if (value === this ._hidden .getValue ())
         return;

      this ._hidden = value;
   },
   getBBox (bbox, shadows)
   {
      return this .groupNodes .getBBox (bbox, shadows);
   },
   isLayer0 ()
   {
      return this .layer0;
   },
   setLayer0 (value)
   {
      this .layer0 = value;
      this .defaultBackground .setHidden (!value);
   },
   getLayer ()
   {
      return this;
   },
   getGroups ()
   {
      return this .groupNodes;
   },
   getViewport ()
   {
      return this .viewportNode;
   },
   getBackground ()
   {
      return this .backgroundStack .top ();
   },
   getFog ()
   {
      return this .fogStack .top ();
   },
   getNavigationInfo ()
   {
      return this .navigationInfoStack .top ();
   },
   getViewpoint ()
   {
      return this .viewpointStack .top ();
   },
   getBackgrounds ()
   {
      return this .backgrounds;
   },
   getFogs ()
   {
      return this .fogs;
   },
   getNavigationInfos ()
   {
      return this .navigationInfos;
   },
   getViewpoints ()
   {
      return this .viewpoints;
   },
   getUserViewpoints ()
   {
      const
         browser                = this .getBrowser (),
         enableInlineViewpoints = browser .getBrowserOption ("EnableInlineViewpoints"),
         currentScene           = browser .currentScene;

      return Array .from (new Set (this .viewpoints .get ()
         .filter (viewpointNode => viewpointNode .getDescriptions () .length)
         .filter (viewpointNode => enableInlineViewpoints || viewpointNode .getScene () === currentScene)));
   },
   getBackgroundStack ()
   {
      return this .backgroundStack;
   },
   getFogStack ()
   {
      return this .fogStack;
   },
   getNavigationInfoStack ()
   {
      return this .navigationInfoStack;
   },
   getViewpointStack ()
   {
      return this .viewpointStack;
   },
   viewAll (transitionTime = 1, factor = 1, straighten = false)
   {
      const
         viewpointNode = this .getViewpoint (),
         bbox          = this .getBBox (new Box3/* default */.A ()) .multRight (viewpointNode .getModelMatrix () .copy () .inverse ());

      if (bbox .size .equals (Vector3/* default */.A .ZERO))
         return;

      viewpointNode .lookAt (this, bbox .center, viewpointNode .getLookAtDistance (bbox), transitionTime, factor, straighten);
   },
   straightenView ()
   {
      this .getViewpoint () .straightenView (this);
   },
   set_visible_and_hidden__ ()
   {
      const value = this ._visible .getValue () && !this ._hidden .getValue ();

      if (value === this ._display .getValue ())
         return;

      this ._display = value;
   },
   set_viewport__ ()
   {
      this .viewportNode = (0,X3DCast/* default */.A) (X3DConstants/* default */.A .X3DViewportNode, this ._viewport)
         ?? this .getBrowser () .getDefaultViewport ();
   },
   bindBindables (viewpointName)
   {
      this .traverse (TraverseType/* default */.A .CAMERA, this);

      // Bind first viewpoint in viewpoint list and other bindables too.

      const
         navigationInfoNode = this .navigationInfos .getBound (),
         backgroundNode     = this .backgrounds     .getBound (),
         fogNode            = this .fogs            .getBound (),
         viewpointNode      = this .viewpoints      .getBound (viewpointName);

      this .navigationInfoStack .pushOnTop (navigationInfoNode);
      this .backgroundStack     .pushOnTop (backgroundNode);
      this .fogStack            .pushOnTop (fogNode);
      this .viewpointStack      .pushOnTop (viewpointNode);

      // Update matrices of viewpoint.

      viewpointNode .resetUserOffsets ();

      if (viewpointNode ._viewAll .getValue ())
         viewpointNode .viewAll (this .getBBox (new Box3/* default */.A ()));

      viewpointNode .update ();
   },
   traverse: (() =>
   {
      const projectionMatrix = new Matrix4/* default */.A ();

      return function (type, renderObject = this)
      {
         const
            browser       = this .getBrowser (),
            viewpointNode = this .getViewpoint (),
            pose          = browser .getPose ();

         if (pose ?.views .length)
         {
            switch (type)
            {
               case TraverseType/* default */.A .POINTER:
               {
                  const
                     navigationInfoNode = this .getNavigationInfo (),
                     farValue           = viewpointNode .getFarDistance (navigationInfoNode),
                     inputSource        = browser .getPointingInputSource ();

                  Camera/* default */.A .ortho (-1, 1, -1, 1, 0, farValue, projectionMatrix);

                  this .getProjectionMatrix ()  .push (projectionMatrix);
                  this .getCameraSpaceMatrix () .push (inputSource .matrix);
                  this .getViewMatrix ()        .push (inputSource .inverse);

                  if (this !== browser .getActiveLayer ())
                  {
                     // Remove pose effect from matrices here.
                     this .getCameraSpaceMatrix () .multRight (pose .viewMatrix);
                     this .getViewMatrix ()        .multLeft  (pose .cameraSpaceMatrix);
                  }

                  this .getCameraSpaceMatrix () .multRight (viewpointNode .getCameraSpaceMatrix ());
                  this .getViewMatrix ()        .multLeft  (viewpointNode .getViewMatrix ());
                  break;
               }
               case TraverseType/* default */.A .COLLISION:
               {
                  // This projection matrix will change later before rendering.
                  this .getProjectionMatrix ()  .push (pose .views [0] .projectionMatrix);
                  this .getCameraSpaceMatrix () .push (viewpointNode .getCameraSpaceMatrix ());
                  this .getViewMatrix ()        .push (viewpointNode .getViewMatrix ());
                  break;
               }
               default:
               {
                  // This projection matrix will change later before rendering.
                  this .getProjectionMatrix () .push (pose .views [0] .projectionMatrix);

                  if (this === browser .getActiveLayer ())
                  {
                     this .getCameraSpaceMatrix () .push (pose .cameraSpaceMatrix);
                     this .getViewMatrix ()        .push (pose .viewMatrix);

                     this .getCameraSpaceMatrix () .multRight (viewpointNode .getCameraSpaceMatrix ());
                     this .getViewMatrix ()        .multLeft  (viewpointNode .getViewMatrix ());
                  }
                  else
                  {
                     this .getCameraSpaceMatrix () .push (viewpointNode .getCameraSpaceMatrix ());
                     this .getViewMatrix ()        .push (viewpointNode .getViewMatrix ());
                  }

                  break;
               }
            }
         }
         else
         {
            this .getProjectionMatrix ()  .push (viewpointNode .getProjectionMatrix (this));
            this .getCameraSpaceMatrix () .push (viewpointNode .getCameraSpaceMatrix ());
            this .getViewMatrix ()        .push (viewpointNode .getViewMatrix ());
         }

         switch (type)
         {
            case TraverseType/* default */.A .POINTER:
               this .pointer (type, renderObject);
               break;
            case TraverseType/* default */.A .CAMERA:
               this .camera (type, renderObject);
               break;
            case TraverseType/* default */.A .PICKING:
               this .picking (type, renderObject);
               break;
            case TraverseType/* default */.A .COLLISION:
               this .collision (type, renderObject);
               break;
            case TraverseType/* default */.A .SHADOW:
            case TraverseType/* default */.A .DISPLAY:
               this .display (type, renderObject);
               break;
         }

         this .getViewMatrix ()        .pop ();
         this .getCameraSpaceMatrix () .pop ();
         this .getProjectionMatrix ()  .pop ();
      };
   })(),
   pointer (type, renderObject)
   {
      if (!this ._pointerEvents .getValue ())
         return;

      const
         browser  = this .getBrowser (),
         viewport = this .viewportNode .getRectangle ();

      if (browser .getPointingLayer ())
      {
         if (browser .getPointingLayer () !== this)
            return;
      }
      else
      {
         if (!browser .isPointerInRectangle (viewport))
            return;
      }

      const { viewportNode, groupNodes } = this;

      this .setHitRay (this .getProjectionMatrix () .get (), viewport, browser .getPointer ());
      this .getModelViewMatrix () .push (this .getViewMatrix () .get ());

      viewportNode .push (this);
      renderObject .render (type, groupNodes .traverse, groupNodes);
      viewportNode .pop (this);

      this .getModelViewMatrix () .pop ();
   },
   camera (type, renderObject)
   {
      this .getModelViewMatrix () .push (Matrix4/* default */.A .IDENTITY);

      const { viewportNode, groupNodes } = this;

      viewportNode .push (this);
      groupNodes .traverse (type, renderObject);
      viewportNode .pop (this);

      this .getModelViewMatrix () .pop ();

      this .navigationInfos .update (this, this .navigationInfoStack);
      this .viewpoints      .update (this, this .viewpointStack);
      this .backgrounds     .update (this, this .backgroundStack);
      this .fogs            .update (this, this .fogStack);

      this .getViewpoint () .update ();
   },
   picking (type, renderObject)
   {
      if (!this ._pickable .getValue ())
         return;

      const { viewportNode, groupNodes } = this;

      this .getModelViewMatrix () .push (Matrix4/* default */.A .IDENTITY);

      viewportNode .push (this);
      groupNodes .traverse (type, renderObject);
      viewportNode .pop (this);

      this .getModelViewMatrix () .pop ();
   },
   collision: (() =>
   {
      const projectionMatrix = new Matrix4/* default */.A ();

      return function (type, renderObject)
      {
         const navigationInfoNode = this .getNavigationInfo ();

         if (navigationInfoNode ._transitionActive .getValue ())
            return;

         const
            collisionRadius = navigationInfoNode .getCollisionRadius (),
            avatarHeight    = navigationInfoNode .getAvatarHeight (),
            size            = Math .max (collisionRadius * 2, avatarHeight * 2);

         const { viewportNode, groupNodes } = this;

         Camera/* default */.A .ortho (-size, size, -size, size, -size, size, projectionMatrix);

         this .getProjectionMatrix () .push (projectionMatrix);
         this .getModelViewMatrix  () .push (this .getViewMatrix () .get ());

         // Render
         viewportNode .push (this);
         renderObject .render (type, groupNodes .traverse, groupNodes);
         viewportNode .pop (this);

         this .getModelViewMatrix  () .pop ();
         this .getProjectionMatrix () .pop ();
      };
   })(),
   display (type, renderObject)
   {
      const { viewportNode, groupNodes } = this;

      this .getNavigationInfo () .enable (type, renderObject);
      this .getModelViewMatrix () .push (this .getViewMatrix () .get ());

      viewportNode .push (this);
      renderObject .render (type, groupNodes .traverse, groupNodes);
      viewportNode .pop (this);

      this .getModelViewMatrix () .pop ();
   },
});

Object .defineProperties (X3DLayerNode, X3DNode/* default */.A .getStaticProperties ("X3DLayerNode", "Layering", 1));

const X3DLayerNode_default_ = X3DLayerNode;
;

/* harmony default export */ const Layering_X3DLayerNode = (Namespace/* default */.A .add ("X3DLayerNode", X3DLayerNode_default_));

/***/ }),

/***/ 3383:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _x_ite_Namespace_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6707);
function ObjectCache (Type)
{
   return Object .assign ([ ],
   {
      top: 0,
      pop ()
      {
         if (this .top !== 0)
            return this [-- this .top];

         return new Type ();
      },
      push (object)
      {
         this [this .top ++] = object;
      },
      clear ()
      {
         this .length = 0;
         this .top    = 0;
      },
   });
}

const __default__ = ObjectCache;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_x_ite_Namespace_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .add ("ObjectCache", __default__));

/***/ }),

/***/ 3630:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Algorithm_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(4559);
/* harmony import */ var _x_ite_Namespace_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(6707);


function Vector4 (x = 0, y = x, z = y, w = z)
{
   this .x = x;
   this .y = y;
   this .z = z;
   this .w = w;
}

Object .assign (Vector4 .prototype,
{
   *[Symbol .iterator] ()
   {
      yield this .x;
      yield this .y;
      yield this .z;
      yield this .w;
   },
   copy ()
   {
      const copy = Object .create (Vector4 .prototype);
      copy .x = this .x;
      copy .y = this .y;
      copy .z = this .z;
      copy .w = this .w;
      return copy;
   },
   assign ({ x, y, z, w })
   {
      this .x = x;
      this .y = y;
      this .z = z;
      this .w = w;
      return this;
   },
   set (x = 0, y = x, z = y, w = z)
   {
      this .x = x;
      this .y = y;
      this .z = z;
      this .w = w;
      return this;
   },
   equals ({ x, y, z, w })
   {
      return this .x === x &&
             this .y === y &&
             this .z === z &&
             this .w === w;
   },
   negate ()
   {
      this .x = -this .x;
      this .y = -this .y;
      this .z = -this .z;
      this .w = -this .w;
      return this;
   },
   inverse ()
   {
      this .x = 1 / this .x;
      this .y = 1 / this .y;
      this .z = 1 / this .z;
      this .w = 1 / this .w;
      return this;
   },
   add ({ x, y, z, w })
   {
      this .x += x;
      this .y += y;
      this .z += z;
      this .w += w;
      return this;
   },
   subtract ({ x, y, z, w })
   {
      this .x -= x;
      this .y -= y;
      this .z -= z;
      this .w -= w;
      return this;
   },
   multiply (value)
   {
      this .x *= value;
      this .y *= value;
      this .z *= value;
      this .w *= value;
      return this;
   },
   multVec ({ x, y, z, w })
   {
      this .x *= x;
      this .y *= y;
      this .z *= z;
      this .w *= w;
      return this;
   },
   divide (value)
   {
      this .x /= value;
      this .y /= value;
      this .z /= value;
      this .w /= value;
      return this;
   },
   divVec ({ x, y, z, w })
   {
      this .x /= x;
      this .y /= y;
      this .z /= z;
      this .w /= w;
      return this;
   },
   normalize ()
   {
      const length = Math .hypot (this .x, this .y, this .z, this .w);

      if (length)
      {
         this .x /= length;
         this .y /= length;
         this .z /= length;
         this .w /= length;
      }

      return this;
   },
   dot ({ x, y, z, w })
   {
      return this .x * x +
             this .y * y +
             this .z * z +
             this .w * w;
   },
   squaredNorm ()
   {
      const { x, y, z, w } = this;

      return x * x +
             y * y +
             z * z +
             w * w;
   },
   norm ()
   {
      return Math .hypot (this .x, this .y, this .z, this .w);
   },
   distance ({ x, y, z, w })
   {
      return Math .hypot (this .x - x,
                          this .y - y,
                          this .z - z,
                          this .w - w);
   },
   lerp ({ x: dX, y: dY, z: dZ, w: dW }, t)
   {
      const { x, y, z, w } = this;

      this .x = x + t * (dX - x);
      this .y = y + t * (dY - y);
      this .z = z + t * (dZ - z);
      this .w = w + t * (dW - w);
      return this;
   },
   abs ()
   {
      const { x, y, z, w } = this;

      this .x = Math .abs (x);
      this .y = Math .abs (y);
      this .z = Math .abs (z);
      this .w = Math .abs (w);
      return this;
   },
   min (vector)
   {
      let { x, y, z, w } = this;

      for (const { x: minX, y: minY, z: minZ, w: minW } of arguments)
      {
         x = Math .min (x, minX);
         y = Math .min (y, minY);
         z = Math .min (z, minZ);
         w = Math .min (w, minW);
      }

      this .x = x;
      this .y = y;
      this .z = z;
      this .w = w;
      return this;
   },
   max (vector)
   {
      let { x, y, z, w } = this;

      for (const { x: maxX, y: maxY, z: maxZ, w: maxW } of arguments)
      {
         x = Math .max (x, maxX);
         y = Math .max (y, maxY);
         z = Math .max (z, maxZ);
         w = Math .max (w, maxW);
      }

      this .x = x;
      this .y = y;
      this .z = z;
      this .w = w;
      return this;
   },
   clamp  ({ x: minX, y: minY, z: minZ, w: minW }, { x: maxX, y: maxY, z: maxZ, w: maxW })
   {
      this .x = _Algorithm_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .clamp (this .x, minX, maxX);
      this .y = _Algorithm_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .clamp (this .y, minY, maxY);
      this .z = _Algorithm_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .clamp (this .z, minZ, maxZ);
      this .w = _Algorithm_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .clamp (this .w, minW, maxW);
      return this;
   },
   toString ()
   {
      return this .x + " " +
             this .y + " " +
             this .z + " " +
             this .w;
   },
});

for (const key of Object .keys (Vector4 .prototype))
   Object .defineProperty (Vector4 .prototype, key, { enumerable: false });

Object .defineProperties (Vector4 .prototype,
{
   length: { value: 4 },
   0:
   {
      get () { return this .x; },
      set (value) { this .x = value; },
   },
   1:
   {
      get () { return this .y; },
      set (value) { this .y = value; },
   },
   2:
   {
      get () { return this .z; },
      set (value) { this .z = value; },
   },
   3:
   {
      get () { return this .w; },
      set (value) { this .w = value; },
   },
});

Object .assign (Vector4,
{
   ZERO: Object .freeze (new Vector4 ()),
   // Positive values
   ONE: Object .freeze (new Vector4 (1)),
   X_AXIS: Object .freeze (new Vector4 (1, 0, 0, 0)),
   Y_AXIS: Object .freeze (new Vector4 (0, 1, 0, 0)),
   Z_AXIS: Object .freeze (new Vector4 (0, 0, 1, 0)),
   W_AXIS: Object .freeze (new Vector4 (0, 0, 0, 1)),
   // Negative values
   NEGATIVE_ONE: Object .freeze (new Vector4 (-1)),
   NEGATIVE_X_AXIS: Object .freeze (new Vector4 (-1, 0, 0, 0)),
   NEGATIVE_Y_AXIS: Object .freeze (new Vector4 (0, -1, 0, 0)),
   NEGATIVE_Z_AXIS: Object .freeze (new Vector4 (0, 0, -1, 0)),
   NEGATIVE_W_AXIS: Object .freeze (new Vector4 (0, 0, 0, -1)),
});

const __default__ = Vector4;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_x_ite_Namespace_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .add ("Vector4", __default__));

/***/ }),

/***/ 3658:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(2639);
/* harmony import */ var _x_ite_Namespace_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(6707);
/* provided dependency */ var libtess = __webpack_require__(7326);


const Triangle3 =
{
   /**
    *
    * @param {Vector3} a first point of triangle
    * @param {Vector3} b second point of triangle
    * @param {Vector3} c third point of triangle
    * @returns
    */
   area: (() =>
   {
      const
         B = new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A (),
         C = new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A ();

      return function (a, b, c)
      {
         return B .assign (b) .subtract (a) .cross (C .assign (c) .subtract (a)) .norm () / 2;
      };
   })(),
   /**
    *
    * @param {Vector3} a first point of triangle
    * @param {Vector3} b second point of triangle
    * @param {Vector3} c third point of triangle
    * @param {Vector3} normal resulting normal
    * @returns
    */
   normal (a, b, c, normal)
   {
      const
         x1 = c .x - b .x,
         y1 = c .y - b .y,
         z1 = c .z - b .z,
         x2 = a .x - b .x,
         y2 = a .y - b .y,
         z2 = a .z - b .z;

      normal .set (y1 * z2 - z1 * y2,
                   z1 * x2 - x1 * z2,
                   x1 * y2 - y1 * x2);

      return normal .normalize ();
   },
   /**
    *
    * @param {Vector3} a first point of quad
    * @param {Vector3} b second point of quad
    * @param {Vector3} c third point of quad
    * @param {Vector3} d third point of quad
    * @param {Vector3} normal resulting normal
    * @returns
    */
   quadNormal (a, b, c, d, normal)
   {
      const
         x1 = c .x - a .x,
         y1 = c .y - a .y,
         z1 = c .z - a .z,
         x2 = d .x - b .x,
         y2 = d .y - b .y,
         z2 = d .z - b .z;

      normal .set (y1 * z2 - z1 * y2,
                   z1 * x2 - x1 * z2,
                   x1 * y2 - y1 * x2);

      return normal .normalize ();
   },
   triangulatePolygon: (() =>
   {
      // Function called for each vertex of tesselator output.

      function vertexCallback (index, triangles)
      {
         triangles .push (index);
      }

      // Required in case of a combine, otherwise an empty array is returned.

      function combineCallback (coords, data, weight)
      {
         return data [0];
      }

      const tessy = new libtess .GluTesselator ();

      tessy .gluTessCallback (libtess .gluEnum .GLU_TESS_VERTEX_DATA,  vertexCallback);
      tessy .gluTessCallback (libtess .gluEnum .GLU_TESS_COMBINE,      combineCallback);
      tessy .gluTessProperty (libtess .gluEnum .GLU_TESS_WINDING_RULE, libtess .windingRule .GLU_TESS_WINDING_ODD);

      return function (polygon, triangles)
      {
         tessy .gluTessBeginPolygon (triangles);
         tessy .gluTessBeginContour ();

         for (const point of polygon)
            tessy .gluTessVertex (point, point .index);

         tessy .gluTessEndContour ();
         tessy .gluTessEndPolygon ();

         // Return array of indices.
         return triangles;
      };
   })(),
   triangulateConvexPolygon (vertices, triangles)
   {
      // Fallback: Very simple triangulation for convex polygons.

      const numVertices_1 = vertices .length - 1;

      for (let i = 1; i < numVertices_1; ++ i)
         triangles .push (vertices [0], vertices [i], vertices [i + 1]);

      return triangles;
   },
};

const __default__ = Triangle3;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_x_ite_Namespace_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .add ("Triangle3", __default__));

/***/ }),

/***/ 3768:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _XMLParser_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(4159);
/* harmony import */ var _X3DParser_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(8265);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(6707);
/* provided dependency */ var $ = __webpack_require__(7682);



function JSONParser (scene)
{
   _X3DParser_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .call (this, scene);

   this .namespace = "http://www.web3d.org/specifications/x3d-namespace";
}

Object .assign (Object .setPrototypeOf (JSONParser .prototype, _X3DParser_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .prototype),
{
   getEncoding ()
   {
      return "JSON";
   },
   setInput (json)
   {
      try
      {
         if (typeof json === "string")
            json = JSON .parse (json);

         this .input = json;
      }
      catch
      {
         this .input = undefined;
      }
   },
   isValid ()
   {
      return this .input instanceof Object;
   },
   parseIntoScene (resolve, reject)
   {
      /**
       * Load X3D JSON into an element.
       * json - the JavaScript object to convert to DOM.
       */

      const child = this .createElement ("X3D");

      this .convertToDOM (this .input, "", child);

      // Call the DOM parser.

      const parser = new _XMLParser_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A (this .getScene ());

      parser .setInput (child);
      parser .parseIntoScene (resolve, reject);

      this .getScene () .setEncoding ("JSON");
   },
   elementSetAttribute (element, key, value)
   {
      /**
       * Yet another way to set an attribute on an element.  does not allow you to
       * set JSON schema or encoding.
       */

      switch (key)
      {
         case "SON schema":
         {
            // JSON Schema
            break;
         }
         case "ncoding":
         {
            // encoding, UTF-8, UTF-16 or UTF-32
            break;
         }
         default:
         {
            if (typeof element .setAttribute === "function")
               element .setAttribute (key, value);

            break;
         }
      }
   },
   convertChildren (parentkey, object, element)
   {
      /**
       * converts children of object to DOM.
       */

      for (const key in object)
      {
         if (typeof object [key] !== "object")
            continue;

         if (isNaN (parseInt (key)))
            this .convertObject (key, object, element, parentkey .substring (1));
         else
            this .convertToDOM (object [key], key, element, parentkey .substring (1));
      }
   },
   createElement (key, containerField)
   {
      /**
       * a method to create and element with tagnam key to DOM in a namespace.  If
       * containerField is set, then the containerField is set in the elemetn.
       */

      let child;

      if (typeof this .namespace === "undefined")
      {
         child = document .createElement (key);
      }
      else
      {
         child = document .createElementNS (this .namespace, key);

         if (child === null || typeof child === "undefined")
         {
            console .error ("Trouble creating element for", key);

            child = document .createElement (key);
         }
      }

      if (typeof containerField !== "undefined")
         this .elementSetAttribute (child, "containerField", containerField);

      return child;
   },
   createCDATA (document, element, str)
   {
      const
         docu  = $.parseXML ("<xml></xml>", "application/xml"),
         cdata = docu .createCDATASection (str);

      element .appendChild (cdata);
   },
   convertObject (key, object, element, containerField)
   {
      /**
       * convert the object at object[key] to DOM.
       */

      if (object !== null && typeof object [key] === "object")
      {
         if (key [0] === "@")
         {
            this .convertToDOM (object [key], key, element);
         }
         else if (key [0] === "-")
         {
            this .convertChildren (key, object [key], element);
         }
         else if (key === "#comment")
         {
            for (const c in object [key])
            {
               const child = document .createComment (this .commentStringToXML (object [key] [c]));

               element .appendChild (child);
            }
         }
         else if (key === "#sourceCode" || key === "@sourceCode" || key === "#sourceText")
         {
            this .createCDATA (document, element, object [key] .join ("\n"));
         }
         else if (key === "connect" || key === "fieldValue" || key === "field" || key === "meta" || key === "component" || key === "unit")
         {
            for (const childkey in object [key])
            {
               // for each field
               if (typeof object [key] [childkey] === "object")
               {
                  const child = this .createElement (key, containerField);

                  this .convertToDOM (object [key] [childkey], childkey, child);

                  element .appendChild (child);
                  element .appendChild (document .createTextNode ("\n"));
               }
            }
         }
         else
         {
            const child = this .createElement (key, containerField);

            this .convertToDOM (object [key], key, child);

            element .appendChild (child);
            element .appendChild (document .createTextNode ("\n"));
         }
      }
   },
   commentStringToXML (str)
   {
      /**
       * convert a comment string in JavaScript to XML.  Pass the string
       */

      return str .replace (/\\\\/g, "\\");
   },
   SFStringToXML (str)
   {
      /**
       * convert an SFString to XML.
       */

      return String (str) .replace (/([\\"])/g, "\\$1");
   },
   JSONStringToXML (str)
   {
      /**
       * convert a JSON String to XML.
       */

      str = str .replace (/\\/g, "\\\\");
      str = str .replace (/\n/g, "\\n");

      return str;
   },
   convertToDOM (object, parentkey, element, containerField)
   {
      /**
       * main routine for converting a JavaScript object to DOM.
       * object is the object to convert.
       * parentkey is the key of the object in the parent.
       * element is the parent element.
       * containerField is a possible containerField.
       */

      if (object === null)
      {
         const isArray = !isNaN (parseInt (parentkey));

         if (isArray)
         {
            const child = this .createElement ("NULL", containerField);

            element .appendChild (child);
         }
         else
         {
            this .elementSetAttribute (element, "value", null);
         }

         return element;
      }

      let
         isArray        = false,
         localArray     = [ ],
         arrayOfStrings = false;

      for (const key in object)
      {
         isArray = !isNaN (parseInt (key));

         if (isArray)
         {
            switch (typeof object [key])
            {
               case "number":
               {
                  localArray .push (object [key]);
                  break;
               }
               case "string":
               {
                  localArray .push (object [key]);

                  arrayOfStrings = true;
                  break;
               }
               case "boolean":
               {
                  localArray .push (object [key]);
                  break;
               }
               case "object":
               {
                  /*
                  if (object[key] != null && typeof object[key].join === "function") {
                     localArray.push(object[key].join(" "));
                  }
                  */
                  this .convertToDOM (object [key], key, element);
                  break;
               }
               case "undefined":
               {
                  break;
               }
               default:
               {
                  console .error (`Unknown type found in array ${typeof object [key]}`);
               }
            }
         }
         else
         {
            switch (typeof object [key])
            {
               case "object":
               {
                  // This is where the whole thing starts

                  if (key === "X3D")
                     this .convertToDOM (object [key], key, element);

                  else
                     this .convertObject (key, object, element, containerField);

                  break;
               }
               case "number":
               {
                  this .elementSetAttribute (element, key .substring (1), object [key]);
                  break;
               }
               case "string":
               {
                  if (key !== "#comment")
                  {
                     // ordinary string attributes
                     this .elementSetAttribute (element, key .substring (1), this .JSONStringToXML (object [key]));
                  }
                  else
                  {
                     const child = document .createComment (this .commentStringToXML (object [key]));

                     element .appendChild (child);
                  }

                  break;
               }
               case "boolean":
               {
                  this .elementSetAttribute (element, key .substring (1), object [key]);
                  break;
               }
               case "undefined":
               {
                  break;
               }
               default:
               {
                  console .error (`Unknown type found in object ${typeof object [key]}`);
                  console .error (object);
               }
            }
         }
      }

      if (isArray)
      {
         if (parentkey [0] === "@")
         {
            if (arrayOfStrings)
            {
               arrayOfStrings = false;

               for (const [str, value] of localArray .entries ())
                  localArray [str] = this .SFStringToXML (value);

               this .elementSetAttribute (element, parentkey .substring (1), '"' + localArray .join ('" "') + '"');
            }
            else
            {
               // if non string array
               this .elementSetAttribute (element, parentkey .substring (1), localArray .join (" "));
            }
         }

         isArray = false;
      }

      return element;
   },
});

const __default__ = JSONParser;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .add ("JSONParser", __default__));

/***/ }),

/***/ 3876:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Base_X3DInfoArray_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(4635);
/* harmony import */ var _X3DRoute_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(254);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(6707);



function RouteArray (values = [ ])
{
   return _Base_X3DInfoArray_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .call (this, Array .from (values, value => [value .getId (), value]), _X3DRoute_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A);
}

Object .setPrototypeOf (RouteArray .prototype, _Base_X3DInfoArray_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .prototype);

for (const key of Object .keys (RouteArray .prototype))
   Object .defineProperty (RouteArray .prototype, key, { enumerable: false });

Object .defineProperties (RouteArray,
{
   typeName:
   {
      value: "RouteArray",
      enumerable: true,
   },
});

const __default__ = RouteArray;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .add ("RouteArray", __default__));

/***/ }),

/***/ 4126:
/***/ (function(module) {

(function webpackUniversalModuleDefinition(root, factory) {
	if(true)
		module.exports = factory();
	else // removed by dead control flow
{}
})(this, function() {
return /******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};

/******/ 	// The require function
/******/ 	function __nested_webpack_require_529__(moduleId) {

/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId])
/******/ 			return installedModules[moduleId].exports;

/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			exports: {},
/******/ 			id: moduleId,
/******/ 			loaded: false
/******/ 		};

/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __nested_webpack_require_529__);

/******/ 		// Flag the module as loaded
/******/ 		module.loaded = true;

/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}


/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__nested_webpack_require_529__.m = modules;

/******/ 	// expose the module cache
/******/ 	__nested_webpack_require_529__.c = installedModules;

/******/ 	// __webpack_public_path__
/******/ 	__nested_webpack_require_529__.p = "";

/******/ 	// Load entry module and return exports
/******/ 	return __nested_webpack_require_529__(0);
/******/ })
/************************************************************************/
/******/ ([
/* 0 */
/***/ (function(module, exports, __nested_webpack_require_1730__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	    value: true
	});
	exports.isNotPNG = isNotPNG;
	exports.isNotAPNG = isNotAPNG;
	exports.default = parseAPNG;

	var _crc = __nested_webpack_require_1730__(1);

	var _crc2 = _interopRequireDefault(_crc);

	var _structs = __nested_webpack_require_1730__(2);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	var errNotPNG = new Error('Not a PNG');
	var errNotAPNG = new Error('Not an animated PNG');

	function isNotPNG(err) {
	    return err === errNotPNG;
	}
	function isNotAPNG(err) {
	    return err === errNotAPNG;
	}

	// '\x89PNG\x0d\x0a\x1a\x0a'
	var PNGSignature = new Uint8Array([0x89, 0x50, 0x4e, 0x47, 0x0d, 0x0a, 0x1a, 0x0a]);

	/**
	 * Parse APNG data
	 * @param {ArrayBuffer} buffer
	 * @return {APNG|Error}
	 */
	function parseAPNG(buffer) {
	    var bytes = new Uint8Array(buffer);

	    if (Array.prototype.some.call(PNGSignature, function (b, i) {
	        return b !== bytes[i];
	    })) {
	        return errNotPNG;
	    }

	    // fast animation test
	    var isAnimated = false;
	    eachChunk(bytes, function (type) {
	        return !(isAnimated = type === 'acTL');
	    });
	    if (!isAnimated) {
	        return errNotAPNG;
	    }

	    var preDataParts = [],
	        postDataParts = [];
	    var headerDataBytes = null,
	        frame = null,
	        frameNumber = 0,
	        apng = new _structs.APNG();

	    eachChunk(bytes, function (type, bytes, off, length) {
	        var dv = new DataView(bytes.buffer);
	        switch (type) {
	            case 'IHDR':
	                headerDataBytes = bytes.subarray(off + 8, off + 8 + length);
	                apng.width = dv.getUint32(off + 8);
	                apng.height = dv.getUint32(off + 12);
	                break;
	            case 'acTL':
	                apng.numPlays = dv.getUint32(off + 8 + 4);
	                break;
	            case 'fcTL':
	                if (frame) {
	                    apng.frames.push(frame);
	                    frameNumber++;
	                }
	                frame = new _structs.Frame();
	                frame.width = dv.getUint32(off + 8 + 4);
	                frame.height = dv.getUint32(off + 8 + 8);
	                frame.left = dv.getUint32(off + 8 + 12);
	                frame.top = dv.getUint32(off + 8 + 16);
	                var delayN = dv.getUint16(off + 8 + 20);
	                var delayD = dv.getUint16(off + 8 + 22);
	                if (delayD === 0) {
	                    delayD = 100;
	                }
	                frame.delay = 1000 * delayN / delayD;
	                // https://bugzilla.mozilla.org/show_bug.cgi?id=125137
	                // https://bugzilla.mozilla.org/show_bug.cgi?id=139677
	                // https://bugzilla.mozilla.org/show_bug.cgi?id=207059
	                if (frame.delay <= 10) {
	                    frame.delay = 100;
	                }
	                apng.playTime += frame.delay;
	                frame.disposeOp = dv.getUint8(off + 8 + 24);
	                frame.blendOp = dv.getUint8(off + 8 + 25);
	                frame.dataParts = [];
	                if (frameNumber === 0 && frame.disposeOp === 2) {
	                    frame.disposeOp = 1;
	                }
	                break;
	            case 'fdAT':
	                if (frame) {
	                    frame.dataParts.push(bytes.subarray(off + 8 + 4, off + 8 + length));
	                }
	                break;
	            case 'IDAT':
	                if (frame) {
	                    frame.dataParts.push(bytes.subarray(off + 8, off + 8 + length));
	                }
	                break;
	            case 'IEND':
	                postDataParts.push(subBuffer(bytes, off, 12 + length));
	                break;
	            default:
	                preDataParts.push(subBuffer(bytes, off, 12 + length));
	        }
	    });

	    if (frame) {
	        apng.frames.push(frame);
	    }

	    if (apng.frames.length == 0) {
	        return errNotAPNG;
	    }

	    var preBlob = new Blob(preDataParts),
	        postBlob = new Blob(postDataParts);

	    apng.frames.forEach(function (frame) {
	        var bb = [];
	        bb.push(PNGSignature);
	        headerDataBytes.set(makeDWordArray(frame.width), 0);
	        headerDataBytes.set(makeDWordArray(frame.height), 4);
	        bb.push(makeChunkBytes('IHDR', headerDataBytes));
	        bb.push(preBlob);
	        frame.dataParts.forEach(function (p) {
	            return bb.push(makeChunkBytes('IDAT', p));
	        });
	        bb.push(postBlob);
	        frame.imageData = new Blob(bb, { 'type': 'image/png' });
	        delete frame.dataParts;
	        bb = null;
	    });

	    return apng;
	}

	/**
	 * @param {Uint8Array} bytes
	 * @param {function(string, Uint8Array, int, int): boolean} callback
	 */
	function eachChunk(bytes, callback) {
	    var dv = new DataView(bytes.buffer);
	    var off = 8,
	        type = void 0,
	        length = void 0,
	        res = void 0;
	    do {
	        length = dv.getUint32(off);
	        type = readString(bytes, off + 4, 4);
	        res = callback(type, bytes, off, length);
	        off += 12 + length;
	    } while (res !== false && type != 'IEND' && off < bytes.length);
	}

	/**
	 *
	 * @param {Uint8Array} bytes
	 * @param {number} off
	 * @param {number} length
	 * @return {string}
	 */
	function readString(bytes, off, length) {
	    var chars = Array.prototype.slice.call(bytes.subarray(off, off + length));
	    return String.fromCharCode.apply(String, chars);
	}

	/**
	 *
	 * @param {string} x
	 * @return {Uint8Array}
	 */
	function makeStringArray(x) {
	    var res = new Uint8Array(x.length);
	    for (var i = 0; i < x.length; i++) {
	        res[i] = x.charCodeAt(i);
	    }
	    return res;
	}

	/**
	 * @param {Uint8Array} bytes
	 * @param {int} start
	 * @param {int} length
	 * @return {Uint8Array}
	 */
	function subBuffer(bytes, start, length) {
	    var a = new Uint8Array(length);
	    a.set(bytes.subarray(start, start + length));
	    return a;
	}

	/**
	 * @param {string} type
	 * @param {Uint8Array} dataBytes
	 * @return {Uint8Array}
	 */
	var makeChunkBytes = function makeChunkBytes(type, dataBytes) {
	    var crcLen = type.length + dataBytes.length;
	    var bytes = new Uint8Array(crcLen + 8);
	    var dv = new DataView(bytes.buffer);

	    dv.setUint32(0, dataBytes.length);
	    bytes.set(makeStringArray(type), 4);
	    bytes.set(dataBytes, 8);
	    var crc = (0, _crc2.default)(bytes, 4, crcLen);
	    dv.setUint32(crcLen + 4, crc);
	    return bytes;
	};

	var makeDWordArray = function makeDWordArray(x) {
	    return new Uint8Array([x >>> 24 & 0xff, x >>> 16 & 0xff, x >>> 8 & 0xff, x & 0xff]);
	};

/***/ }),
/* 1 */
/***/ (function(module, exports) {

	"use strict";

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	exports.default = function (bytes) {
	  var start = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
	  var length = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : bytes.length - start;

	  var crc = -1;
	  for (var _i = start, l = start + length; _i < l; _i++) {
	    crc = crc >>> 8 ^ table[(crc ^ bytes[_i]) & 0xFF];
	  }
	  return crc ^ -1;
	};

	var table = new Uint32Array(256);

	for (var i = 0; i < 256; i++) {
	  var c = i;
	  for (var k = 0; k < 8; k++) {
	    c = (c & 1) !== 0 ? 0xEDB88320 ^ c >>> 1 : c >>> 1;
	  }
	  table[i] = c;
	}

	/**
	 *
	 * @param {Uint8Array} bytes
	 * @param {number} start
	 * @param {number} length
	 * @return {number}
	 */

/***/ }),
/* 2 */
/***/ (function(module, exports, __nested_webpack_require_9403__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	    value: true
	});
	exports.Frame = exports.APNG = undefined;

	var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

	var _player = __nested_webpack_require_9403__(3);

	var _player2 = _interopRequireDefault(_player);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

	/**
	 * @property {number} currFrameNumber
	 * @property {Frame} currFrame
	 * @property {boolean} paused
	 * @property {boolean} ended
	 */
	var APNG = exports.APNG = function () {
	    function APNG() {
	        _classCallCheck(this, APNG);

	        this.width = 0;
	        this.height = 0;
	        this.numPlays = 0;
	        this.playTime = 0;
	        this.frames = [];
	    }
	    /** @type {number} */

	    /** @type {number} */

	    /** @type {number} */

	    /** @type {number} */

	    /** @type {Frame[]} */


	    _createClass(APNG, [{
	        key: 'createImages',


	        /**
	         *
	         * @return {Promise.<*>}
	         */
	        value: function createImages() {
	            return Promise.all(this.frames.map(function (f) {
	                return f.createImage();
	            }));
	        }

	        /**
	         *
	         * @param {CanvasRenderingContext2D} context
	         * @param {boolean} autoPlay
	         * @return {Promise.<Player>}
	         */

	    }, {
	        key: 'getPlayer',
	        value: function getPlayer(context) {
	            var _this = this;

	            var autoPlay = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;

	            return this.createImages().then(function () {
	                return new _player2.default(_this, context, autoPlay);
	            });
	        }
	    }]);

	    return APNG;
	}();

	var Frame = exports.Frame = function () {
	    function Frame() {
	        _classCallCheck(this, Frame);

	        this.left = 0;
	        this.top = 0;
	        this.width = 0;
	        this.height = 0;
	        this.delay = 0;
	        this.disposeOp = 0;
	        this.blendOp = 0;
	        this.imageData = null;
	        this.imageElement = null;
	    }
	    /** @type {number} */

	    /** @type {number} */

	    /** @type {number} */

	    /** @type {number} */

	    /** @type {number} */

	    /** @type {number} */

	    /** @type {number} */

	    /** @type {Blob} */

	    /** @type {HTMLImageElement} */


	    _createClass(Frame, [{
	        key: 'createImage',
	        value: function createImage() {
	            var _this2 = this;

	            if (this.imageElement) {
	                return Promise.resolve();
	            }
	            return new Promise(function (resolve, reject) {
	                var url = URL.createObjectURL(_this2.imageData);
	                _this2.imageElement = document.createElement('img');
	                _this2.imageElement.onload = function () {
	                    URL.revokeObjectURL(url);
	                    resolve();
	                };
	                _this2.imageElement.onerror = function () {
	                    URL.revokeObjectURL(url);
	                    _this2.imageElement = null;
	                    reject(new Error("Image creation error"));
	                };
	                _this2.imageElement.src = url;
	            });
	        }
	    }]);

	    return Frame;
	}();

/***/ }),
/* 3 */
/***/ (function(module, exports, __nested_webpack_require_13509__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	    value: true
	});

	var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

	var _events = __nested_webpack_require_13509__(4);

	var _events2 = _interopRequireDefault(_events);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

	function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

	function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

	var _class = function (_EventEmitter) {
	    _inherits(_class, _EventEmitter);

	    /**
	     * @param {APNG} apng
	     * @param {CanvasRenderingContext2D} context
	     * @param {boolean} autoPlay
	     */

	    /** @type {number} */


	    /** @type {boolean} */

	    /** @type {ImageData} */


	    /** @type {APNG} */

	    /** @type {CanvasRenderingContext2D} */
	    function _class(apng, context, autoPlay) {
	        _classCallCheck(this, _class);

	        var _this = _possibleConstructorReturn(this, (_class.__proto__ || Object.getPrototypeOf(_class)).call(this));

	        _this.playbackRate = 1.0;
	        _this._currentFrameNumber = 0;
	        _this._ended = false;
	        _this._paused = true;
	        _this._numPlays = 0;
	        _this._rafId = null;

	        _this._apng = apng;
	        _this.context = context;
	        _this.stop();
	        if (autoPlay) {
	            _this.play();
	        }
	        return _this;
	    }

	    /**
	     *
	     * @return {number}
	     */

	    /** @type {number|null} */

	    /** @type {boolean} */

	    /** @type {number} */

	    /** @type {Frame} */

	    /** @type {number} */


	    _createClass(_class, [{
	        key: 'renderNextFrame',
	        value: function renderNextFrame() {
	            this._currentFrameNumber = (this._currentFrameNumber + 1) % this._apng.frames.length;
	            if (this._currentFrameNumber === this._apng.frames.length - 1) {
	                this._numPlays++;
	                if (this._apng.numPlays !== 0 && this._numPlays >= this._apng.numPlays) {
	                    this._ended = true;
	                    this._paused = true;
	                }
	            }

	            if (this._prevFrame && this._prevFrame.disposeOp == 1) {
	                this.context.clearRect(this._prevFrame.left, this._prevFrame.top, this._prevFrame.width, this._prevFrame.height);
	            } else if (this._prevFrame && this._prevFrame.disposeOp == 2) {
	                this.context.putImageData(this._prevFrameData, this._prevFrame.left, this._prevFrame.top);
	            }

	            var frame = this.currentFrame;
	            this._prevFrame = frame;
	            this._prevFrameData = null;
	            if (frame.disposeOp == 2) {
	                this._prevFrameData = this.context.getImageData(frame.left, frame.top, frame.width, frame.height);
	            }
	            if (frame.blendOp == 0) {
	                this.context.clearRect(frame.left, frame.top, frame.width, frame.height);
	            }

	            this.context.drawImage(frame.imageElement, frame.left, frame.top);

	            this.emit('frame', this._currentFrameNumber);
	            if (this._ended) {
	                this.emit('end');
	            }
	        }

	        // playback

	    }, {
	        key: 'play',
	        value: function play() {
	            var _this2 = this;

	            if (this._rafId) {
	                cancelAnimationFrame(this._rafId);
	            }

	            this.emit('play');

	            if (this._ended) {
	                this.stop();
	            }
	            this._paused = false;

	            var nextRenderTime = performance.now() + this.currentFrame.delay / this.playbackRate;
	            var tick = function tick(now) {
	                if (_this2._ended || _this2._paused) {
	                    return;
	                }
	                if (now >= nextRenderTime) {
	                    while (now - nextRenderTime >= _this2._apng.playTime / _this2.playbackRate) {
	                        nextRenderTime += _this2._apng.playTime / _this2.playbackRate;
	                        _this2._numPlays++;
	                    }
	                    do {
	                        _this2.renderNextFrame();
	                        nextRenderTime += _this2.currentFrame.delay / _this2.playbackRate;
	                    } while (!_this2._ended && !_this2._paused && now > nextRenderTime);
	                }
	                _this2._rafId = requestAnimationFrame(tick);
	            };
	            this._rafId = requestAnimationFrame(tick);
	        }
	    }, {
	        key: 'pause',
	        value: function pause() {
	            if (!this._paused) {
	                if (this._rafId) {
	                    cancelAnimationFrame(this._rafId);
	                    this._rafId = null;
	                }
	                this.emit('pause');
	                this._paused = true;
	            }
	        }
	    }, {
	        key: 'stop',
	        value: function stop() {
	            if (this._rafId) {
	                cancelAnimationFrame(this._rafId);
	                this._rafId = null;
	            }
	            this.emit('stop');
	            this._numPlays = 0;
	            this._ended = false;
	            this._paused = true;
	            // render first frame
	            this._currentFrameNumber = -1;
	            this.context.clearRect(0, 0, this._apng.width, this._apng.height);
	            this.renderNextFrame();
	        }
	    }, {
	        key: 'currentFrameNumber',
	        get: function get() {
	            return this._currentFrameNumber;
	        }

	        /**
	         *
	         * @return {Frame}
	         */

	    }, {
	        key: 'currentFrame',
	        get: function get() {
	            return this._apng.frames[this._currentFrameNumber];
	        }
	    }, {
	        key: 'paused',
	        get: function get() {
	            return this._paused;
	        }
	    }, {
	        key: 'ended',
	        get: function get() {
	            return this._ended;
	        }
	    }]);

	    return _class;
	}(_events2.default);

	exports.default = _class;

/***/ }),
/* 4 */
/***/ (function(module, exports) {

	// Copyright Joyent, Inc. and other Node contributors.
	//
	// Permission is hereby granted, free of charge, to any person obtaining a
	// copy of this software and associated documentation files (the
	// "Software"), to deal in the Software without restriction, including
	// without limitation the rights to use, copy, modify, merge, publish,
	// distribute, sublicense, and/or sell copies of the Software, and to permit
	// persons to whom the Software is furnished to do so, subject to the
	// following conditions:
	//
	// The above copyright notice and this permission notice shall be included
	// in all copies or substantial portions of the Software.
	//
	// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
	// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
	// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
	// NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
	// DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
	// OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
	// USE OR OTHER DEALINGS IN THE SOFTWARE.

	function EventEmitter() {
	  this._events = this._events || {};
	  this._maxListeners = this._maxListeners || undefined;
	}
	module.exports = EventEmitter;

	// Backwards-compat with node 0.10.x
	EventEmitter.EventEmitter = EventEmitter;

	EventEmitter.prototype._events = undefined;
	EventEmitter.prototype._maxListeners = undefined;

	// By default EventEmitters will print a warning if more than 10 listeners are
	// added to it. This is a useful default which helps finding memory leaks.
	EventEmitter.defaultMaxListeners = 10;

	// Obviously not all Emitters should be limited to 10. This function allows
	// that to be increased. Set to zero for unlimited.
	EventEmitter.prototype.setMaxListeners = function(n) {
	  if (!isNumber(n) || n < 0 || isNaN(n))
	    throw TypeError('n must be a positive number');
	  this._maxListeners = n;
	  return this;
	};

	EventEmitter.prototype.emit = function(type) {
	  var er, handler, len, args, i, listeners;

	  if (!this._events)
	    this._events = {};

	  // If there is no 'error' event listener then throw.
	  if (type === 'error') {
	    if (!this._events.error ||
	        (isObject(this._events.error) && !this._events.error.length)) {
	      er = arguments[1];
	      if (er instanceof Error) {
	        throw er; // Unhandled 'error' event
	      } else {
	        // At least give some kind of context to the user
	        var err = new Error('Uncaught, unspecified "error" event. (' + er + ')');
	        err.context = er;
	        throw err;
	      }
	    }
	  }

	  handler = this._events[type];

	  if (isUndefined(handler))
	    return false;

	  if (isFunction(handler)) {
	    switch (arguments.length) {
	      // fast cases
	      case 1:
	        handler.call(this);
	        break;
	      case 2:
	        handler.call(this, arguments[1]);
	        break;
	      case 3:
	        handler.call(this, arguments[1], arguments[2]);
	        break;
	      // slower
	      default:
	        args = Array.prototype.slice.call(arguments, 1);
	        handler.apply(this, args);
	    }
	  } else if (isObject(handler)) {
	    args = Array.prototype.slice.call(arguments, 1);
	    listeners = handler.slice();
	    len = listeners.length;
	    for (i = 0; i < len; i++)
	      listeners[i].apply(this, args);
	  }

	  return true;
	};

	EventEmitter.prototype.addListener = function(type, listener) {
	  var m;

	  if (!isFunction(listener))
	    throw TypeError('listener must be a function');

	  if (!this._events)
	    this._events = {};

	  // To avoid recursion in the case that type === "newListener"! Before
	  // adding it to the listeners, first emit "newListener".
	  if (this._events.newListener)
	    this.emit('newListener', type,
	              isFunction(listener.listener) ?
	              listener.listener : listener);

	  if (!this._events[type])
	    // Optimize the case of one listener. Don't need the extra array object.
	    this._events[type] = listener;
	  else if (isObject(this._events[type]))
	    // If we've already got an array, just append.
	    this._events[type].push(listener);
	  else
	    // Adding the second element, need to change to array.
	    this._events[type] = [this._events[type], listener];

	  // Check for listener leak
	  if (isObject(this._events[type]) && !this._events[type].warned) {
	    if (!isUndefined(this._maxListeners)) {
	      m = this._maxListeners;
	    } else {
	      m = EventEmitter.defaultMaxListeners;
	    }

	    if (m && m > 0 && this._events[type].length > m) {
	      this._events[type].warned = true;
	      console.error('(node) warning: possible EventEmitter memory ' +
	                    'leak detected. %d listeners added. ' +
	                    'Use emitter.setMaxListeners() to increase limit.',
	                    this._events[type].length);
	      if (typeof console.trace === 'function') {
	        // not supported in IE 10
	        console.trace();
	      }
	    }
	  }

	  return this;
	};

	EventEmitter.prototype.on = EventEmitter.prototype.addListener;

	EventEmitter.prototype.once = function(type, listener) {
	  if (!isFunction(listener))
	    throw TypeError('listener must be a function');

	  var fired = false;

	  function g() {
	    this.removeListener(type, g);

	    if (!fired) {
	      fired = true;
	      listener.apply(this, arguments);
	    }
	  }

	  g.listener = listener;
	  this.on(type, g);

	  return this;
	};

	// emits a 'removeListener' event iff the listener was removed
	EventEmitter.prototype.removeListener = function(type, listener) {
	  var list, position, length, i;

	  if (!isFunction(listener))
	    throw TypeError('listener must be a function');

	  if (!this._events || !this._events[type])
	    return this;

	  list = this._events[type];
	  length = list.length;
	  position = -1;

	  if (list === listener ||
	      (isFunction(list.listener) && list.listener === listener)) {
	    delete this._events[type];
	    if (this._events.removeListener)
	      this.emit('removeListener', type, listener);

	  } else if (isObject(list)) {
	    for (i = length; i-- > 0;) {
	      if (list[i] === listener ||
	          (list[i].listener && list[i].listener === listener)) {
	        position = i;
	        break;
	      }
	    }

	    if (position < 0)
	      return this;

	    if (list.length === 1) {
	      list.length = 0;
	      delete this._events[type];
	    } else {
	      list.splice(position, 1);
	    }

	    if (this._events.removeListener)
	      this.emit('removeListener', type, listener);
	  }

	  return this;
	};

	EventEmitter.prototype.removeAllListeners = function(type) {
	  var key, listeners;

	  if (!this._events)
	    return this;

	  // not listening for removeListener, no need to emit
	  if (!this._events.removeListener) {
	    if (arguments.length === 0)
	      this._events = {};
	    else if (this._events[type])
	      delete this._events[type];
	    return this;
	  }

	  // emit removeListener for all listeners on all events
	  if (arguments.length === 0) {
	    for (key in this._events) {
	      if (key === 'removeListener') continue;
	      this.removeAllListeners(key);
	    }
	    this.removeAllListeners('removeListener');
	    this._events = {};
	    return this;
	  }

	  listeners = this._events[type];

	  if (isFunction(listeners)) {
	    this.removeListener(type, listeners);
	  } else if (listeners) {
	    // LIFO order
	    while (listeners.length)
	      this.removeListener(type, listeners[listeners.length - 1]);
	  }
	  delete this._events[type];

	  return this;
	};

	EventEmitter.prototype.listeners = function(type) {
	  var ret;
	  if (!this._events || !this._events[type])
	    ret = [];
	  else if (isFunction(this._events[type]))
	    ret = [this._events[type]];
	  else
	    ret = this._events[type].slice();
	  return ret;
	};

	EventEmitter.prototype.listenerCount = function(type) {
	  if (this._events) {
	    var evlistener = this._events[type];

	    if (isFunction(evlistener))
	      return 1;
	    else if (evlistener)
	      return evlistener.length;
	  }
	  return 0;
	};

	EventEmitter.listenerCount = function(emitter, type) {
	  return emitter.listenerCount(type);
	};

	function isFunction(arg) {
	  return typeof arg === 'function';
	}

	function isNumber(arg) {
	  return typeof arg === 'number';
	}

	function isObject(arg) {
	  return typeof arg === 'object' && arg !== null;
	}

	function isUndefined(arg) {
	  return arg === void 0;
	}


/***/ })
/******/ ])
});
;

/***/ }),

/***/ 4159:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Base_X3DField_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(5702);
/* harmony import */ var _Base_X3DBaseNode_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(7982);
/* harmony import */ var _Components_Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(8415);
/* harmony import */ var _Components_Core_X3DPrototypeInstance_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(8982);
/* harmony import */ var _Fields_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(564);
/* harmony import */ var _X3DParser_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(8265);
/* harmony import */ var _VRMLParser_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(4187);
/* harmony import */ var _HTMLSupport_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(9621);
/* harmony import */ var _Execution_X3DImportedNode_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(7627);
/* harmony import */ var _Prototype_X3DExternProtoDeclaration_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(5175);
/* harmony import */ var _Prototype_X3DProtoDeclaration_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(5317);
/* harmony import */ var _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(8899);
/* harmony import */ var _Placeholder_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(4716);
/* harmony import */ var _DEVELOPMENT_js__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(2084);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(6707);
/* provided dependency */ var $ = __webpack_require__(7682);















const AccessType =
{
   initializeOnly: _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A .initializeOnly,
   inputOnly:      _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A .inputOnly,
   outputOnly:     _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A .outputOnly,
   inputOutput:    _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A .inputOutput,
};

function XMLParser (scene)
{
   _X3DParser_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .call (this, scene);

   this .protoDeclarations = [ ];
   this .parents           = [ ];
   this .parser            = new _VRMLParser_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A (scene);
   this .url               = new _Fields_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .MFString ();
   this .protoNames        = new Map ();
   this .protoFields       = new WeakMap ();

   this .parser .setUnits (!!scene);
}

Object .assign (Object .setPrototypeOf (XMLParser .prototype, _X3DParser_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .prototype),
{
   getEncoding ()
   {
      return "XML";
   },
   setInput (xmlElement)
   {
      try
      {
         if (typeof xmlElement === "string")
            xmlElement = $.parseXML (xmlElement);

         this .input = xmlElement;
         this .xml   = this .isXML (xmlElement);

         if (!this .xml)
            Object .assign (this, HTMLParser);
      }
      catch
      {
         this .input = undefined;
      }
   },
   isValid ()
   {
      return (this .input instanceof XMLDocument) || (this .input instanceof HTMLElement) || (this .input === null);
   },
   isXML (element)
   {
      if (element instanceof HTMLElement)
         return false;
      else
         return true;
   },
   parseIntoScene (resolve, reject)
   {
      const
         browser = this .getBrowser (),
         scene   = this .getScene ();

      this .resolve = resolve;
      this .reject  = reject;

      scene .setEncoding ("XML");
      scene .setProfile (browser .getProfile ("Full"));

      this .xmlElement (this .input);
   },
   xmlElement (xmlElement)
   {
      const
         browser = this .getBrowser (),
         scene   = this .getScene ();

      if (xmlElement === null)
         return this .resolve ?.(scene);

      switch (xmlElement .nodeName)
      {
         case "#document":
         {
            const X3D = $(xmlElement) .children ("X3D");

            if (X3D .length)
            {
               for (const xmlElement of X3D)
                  this .x3dElement (xmlElement);
            }
            else
            {
               if (this .resolve)
               {
                  browser .loadComponents (scene) .then (() =>
                  {
                     this .childrenElements (xmlElement);
                     this .setupNodes ();
                     this .resolve (scene);
                  })
                  .catch (this .reject);
               }
               else
               {
                  this .childrenElements (xmlElement);
                  this .setupNodes ();
               }
            }

            break;
         }
         case "X3D":
         {
            this .x3dElement (xmlElement);
            break;
         }
         case "Scene":
         case "SCENE":
         {
            if (this .resolve)
            {
               browser .loadComponents (scene) .then (() =>
               {
                  this .sceneElement (xmlElement);
                  this .setupNodes ();
                  this .resolve (scene);
               })
               .catch (this .reject);
            }
            else
            {
               this .sceneElement (xmlElement);
               this .setupNodes ();
            }

            break;
         }
         default:
         {
            if (this .resolve)
            {
               browser .loadComponents (scene) .then (() =>
               {
                  this .childrenElements (xmlElement);
                  this .setupNodes ();
                  this .resolve (scene);
               })
               .catch (this .reject);
            }
            else
            {
               this .childrenElements (xmlElement);
               this .setupNodes ();
            }

            break;
         }
      }
   },
   x3dElement (xmlElement)
   {
      const
         browser = this .getBrowser (),
         scene   = this .getScene ();

      try
      {
         // Profile

         const
            profileNameId = xmlElement .getAttribute ("profile"),
            profile       = browser .getProfile (profileNameId || "Full");

         $.data (this .scene, "X3D", xmlElement);

         scene .setProfile (profile);
      }
      catch (error)
      {
         console .error (error);
      }

      // Specification version

      const specificationVersion = xmlElement .getAttribute ("version");

      if (specificationVersion)
         scene .setSpecificationVersion (specificationVersion);

      // Process child nodes

      for (const childNode of xmlElement .childNodes)
         this .x3dElementChildHead (childNode)

      if (!this .xml)
         this .headElement (xmlElement);

      if (this .resolve)
      {
         browser .loadComponents (scene) .then (() =>
         {
            for (const childNode of xmlElement .childNodes)
               this .x3dElementChildScene (childNode)

            this .setupNodes ();
            this .resolve (scene);
         })
         .catch (this .reject);
      }
      else
      {
         for (const childNode of xmlElement .childNodes)
            this .x3dElementChildScene (childNode)

         this .setupNodes ();
      }
   },
   x3dElementChildHead (xmlElement)
   {
      switch (xmlElement .nodeName)
      {
         case "head":
         case "HEAD":
            this .headElement (xmlElement);
            return;
      }
   },
   x3dElementChildScene (xmlElement)
   {
      switch (xmlElement .nodeName)
      {
         case "Scene":
         case "SCENE":
            this .sceneElement (xmlElement);
            return;
      }
   },
   headElement (xmlElement)
   {
      for (const childNode of xmlElement .childNodes)
         this .headElementChild (childNode);
   },
   headElementChild (xmlElement)
   {
      switch (xmlElement .nodeName)
      {
         case "component":
         case "COMPONENT":
            this .componentElement (xmlElement);
            return;
         case "unit":
         case "UNIT":
            this .unitElement (xmlElement);
            return;
         case "meta":
         case "META":
            this .metaElement (xmlElement);
            return;
      }
   },
   componentElement (xmlElement)
   {
      try
      {
         const
            componentNameIdCharacters = xmlElement .getAttribute ("name"),
            componentSupportLevel     = xmlElement .getAttribute ("level");

         if (componentNameIdCharacters === null)
            return console .warn ("XML Parser: Bad component statement. Expected name attribute.");

         if (componentSupportLevel === null)
            return console .warn ("XML Parser: Bad component statement. Expected level attribute.");

         const component = this .getBrowser () .getComponent (componentNameIdCharacters, parseInt (componentSupportLevel));

         if (this .getScene () .hasComponent (component))
            return;

         this .getScene () .updateComponent (component);
      }
      catch (error)
      {
         console .log (error .message);
      }
   },
   unitElement (xmlElement)
   {
      const
         category         = xmlElement .getAttribute ("category"),
         name             = xmlElement .getAttribute ("name"),
         conversionFactor = xmlElement .getAttribute ("conversionFactor"); //works for html5 as well

      if (category === null)
         return console .warn ("XML Parser: Bad unit statement. Expected category attribute.");

      if (name === null)
         return console .warn ("XML Parser: Bad unit statement. Expected name attribute.");

      if (conversionFactor === null)
         return console .warn ("XML Parser: Bad unit statement. Expected conversionFactor attribute.");

      this .getScene () .updateUnit (category, name, parseFloat (conversionFactor));
   },
   metaElement (xmlElement)
   {
      const
         metakey   = xmlElement .getAttribute ("name"),
         metavalue = xmlElement .getAttribute ("content");

      if (metakey === null)
         return console .warn ("XML Parser: Bad meta statement. Expected name attribute.");

      if (metavalue === null)
         return console .warn ("XML Parser: Bad meta statement. Expected content attribute.");

      this .getScene () .addMetaData (metakey, metavalue);
   },
   sceneElement (xmlElement)
   {
      $.data (xmlElement, "node", this .scene);

      this .childrenElements (xmlElement);
   },
   childrenElements (xmlElement)
   {
      for (const childNode of xmlElement .childNodes)
         this .childElement (childNode);
   },
   childElement (xmlElement)
   {
      switch (xmlElement .nodeName)
      {
         case "#comment":
         case "#text":
            return;

         case "#cdata-section":
            this .cdataNode (xmlElement);
            return;

         case "ExternProtoDeclare":
         case "EXTERNPROTODECLARE":
            this .externProtoDeclareElement (xmlElement);
            return;

         case "ProtoDeclare":
         case "PROTODECLARE":
            this .protoDeclareElement (xmlElement);
            return;

         case "IS":
            this .isElement (xmlElement);
            return;

         case "ProtoInstance":
         case "PROTOINSTANCE":
            this .protoInstanceElement (xmlElement);
            return;

         case "fieldValue":
         case "FIELDVALUE":
            this .fieldValueElement (xmlElement);
            return;

         case "field":
         case "FIELD":
            this .fieldElement (xmlElement);
            return;

         case "ROUTE":
            this .routeElement (xmlElement);
            return;

         case "IMPORT":
            this .importElement (xmlElement);
            return;

         case "EXPORT":
            this .exportElement (xmlElement);
            return;

         default:
            this .nodeElement (xmlElement);
            return;
      }
   },
   externProtoDeclareElement (xmlElement)
   {
      const name = xmlElement .getAttribute ("name");

      if (this .id (name))
      {
         const
            url           = xmlElement .getAttribute ("url"),
            appInfo       = xmlElement .getAttribute ("appinfo"),
            documentation = xmlElement .getAttribute ("documentation");

         this .parser .setInput (url ?? "");
         this .parser .sfstringValues (this .url);

         if (!this .url .length)
            console .warn ("XML Parser: Bad ExternProtoDeclare statement. Expected url attribute with value.");

         const externproto = new _Prototype_X3DExternProtoDeclaration_js__WEBPACK_IMPORTED_MODULE_9__/* ["default"] */ .A (this .getExecutionContext (), this .url);

         this .pushParent (externproto);
         this .protoInterfaceElement (xmlElement);
         this .popParent ();
         this .addProtoFieldNames (externproto);

         externproto .setAppInfo (appInfo ?? "");
         externproto .setDocumentation (documentation ?? "");
         externproto .setup ();

         try
         {
            const existingExternProto = this .getExecutionContext () .getExternProtoDeclaration (name);

            console .warn (`A extern proto named '${name}' is already defined and will be overridden.`);

            this .getExecutionContext () .updateExternProtoDeclaration (this .getExecutionContext () .getUniqueExternProtoName (name), existingExternProto);
         }
         catch
         { }

         this .getExecutionContext () .updateExternProtoDeclaration (name, externproto);

         this .addProtoName (name);
      }
   },
   protoDeclareElement (xmlElement)
   {
      const
         name          = xmlElement .getAttribute ("name"),
         appInfo       = xmlElement .getAttribute ("appinfo"),
         documentation = xmlElement .getAttribute ("documentation");

      if (this .id (name))
      {
         const proto = new _Prototype_X3DProtoDeclaration_js__WEBPACK_IMPORTED_MODULE_10__/* ["default"] */ .A (this .getExecutionContext ());

         for (const childNode of xmlElement .childNodes)
         {
            switch (childNode .nodeName)
            {
               case "ProtoInterface":
               case "PROTOINTERFACE":
               {
                  this .pushParent (proto);
                  this .protoInterfaceElement (childNode);
                  this .popParent ();
                  this .addProtoFieldNames (proto);
                  break;
               }
               default:
                  continue;
            }

            break;
         }

         for (const childNode of xmlElement .childNodes)
         {
            switch (childNode .nodeName)
            {
               case "ProtoBody":
               case "PROTOBODY":
               {
                  this .pushExecutionContext (proto .getBody ());
                  this .pushParent (proto);
                  this .protoBodyElement (childNode);
                  this .popParent ();
                  this .setupNodes ();
                  this .popExecutionContext ();
                  break;
               }
               default:
                  continue;
            }

            break;
         }

         proto .setAppInfo (appInfo ?? "");
         proto .setDocumentation (documentation ?? "");
         proto .setup ();

         try
         {
            const existingProto = this .getExecutionContext () .getProtoDeclaration (name);

            console .warn (`A proto named '${name}' is already defined and will be overridden.`);

            this .getExecutionContext () .updateProtoDeclaration (this .getExecutionContext () .getUniqueProtoName (name), existingProto);
         }
         catch
         { }

         this .getExecutionContext () .updateProtoDeclaration (name, proto);

         this .addProtoName (name);
      }
   },
   protoInterfaceElement (xmlElement)
   {
      for (const childNode of xmlElement .childNodes)
         this .protoInterfaceElementChild (childNode);
   },
   protoInterfaceElementChild (xmlElement)
   {
      switch (xmlElement .nodeName)
      {
         case "field": // User-defined field
         case "FIELD": // User-defined field
            this .fieldElement (xmlElement);
            return;
      }
   },
   fieldElement (xmlElement)
   {
      try
      {
         if (this .getParents () .length === 0)
            return;

         const node = this .getParent ();

         if (!(node instanceof _Base_X3DBaseNode_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A))
            return;

         if (!node .canUserDefinedFields ())
            return;

         const
            accessType = AccessType [xmlElement .getAttribute ("accessType")] || _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A .initializeOnly,
            Field      = _Fields_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A [xmlElement .getAttribute ("type")];

         if (!Field)
            return;

         const
            name          = xmlElement .getAttribute ("name"),
            appInfo       = xmlElement .getAttribute ("appinfo"),
            documentation = xmlElement .getAttribute ("documentation");

         if (!this .id (name))
            return;

         const field = new Field ();

         field .setAppInfo (appInfo ?? "");
         field .setDocumentation (documentation ?? "");

         if (accessType & _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A .initializeOnly)
         {
            this .fieldValue (field, xmlElement .getAttribute ("value"));

            this .pushParent (field);
            this .childrenElements (xmlElement);
            this .popParent ();
         }

         node .addUserDefinedField (accessType, name, field);
      }
      catch (error)
      {
         console .error (error);
      }
   },
   protoBodyElement (xmlElement)
   {
      this .childrenElements (xmlElement);
   },
   isElement (xmlElement)
   {
      if (this .isInsideProtoDeclaration ())
      {
         for (const childNode of xmlElement .childNodes)
            this .isElementChild (childNode);
      }
   },
   isElementChild (xmlElement)
   {
      switch (xmlElement .nodeName)
      {
         case "connect":
         case "CONNECT":
            this .connectElement (xmlElement);
            return;
      }
   },
   connectElement (xmlElement)
   {
      const
         nodeFieldName  = xmlElement .getAttribute ("nodeField"),
         protoFieldName = xmlElement .getAttribute ("protoField");

      if (nodeFieldName === null)
         return console .warn ("XML Parser: Bad connect statement. Expected nodeField attribute.");

      if (protoFieldName === null)
         return console .warn ("XML Parser: Bad connect statement. Expected protoField attribute.");

      try
      {
         if (this .getParents () .length === 0)
            return;

         const
            node  = this .getParent (),
            proto = this .getOuterNode ();

         if (!(node instanceof _Components_Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A))
            return;

         const
            nodeField  = node .getField (nodeFieldName),
            protoField = proto .getField (protoFieldName);

         if (nodeField .getType () === protoField .getType ())
         {
            if (protoField .isReference (nodeField .getAccessType ()))
               nodeField .addReference (protoField);
            else
               throw new Error (`Field '${nodeField .getName ()}' and '${protoField .getName ()}' in PROTO ${proto .getName ()} are incompatible as an IS mapping.`);
         }
         else
            throw new Error (`Field '${nodeField .getName ()}' and '${protoField .getName ()}' in PROTO ${this .proto .getName()} have different types.`);
      }
      catch (error)
      {
         console .warn (`XML Parser: Couldn't create IS reference. ${error .message}`);
      }
   },
   protoInstanceElement (xmlElement)
   {
      try
      {
         if (this .useAttribute (xmlElement))
            return;

         const name = xmlElement .getAttribute ("name");

         if (this .id (name))
         {
            const node = this .getExecutionContext () .createProto (name, false);

            if (!node)
               throw new Error (`Unknown proto or externproto type '${name}'.`);

            ///DOMIntegration: attach node to DOM xmlElement for access from DOM.
            $.data (xmlElement, "node", node);

            this .defAttribute (xmlElement, node);
            this .addNode (xmlElement, node);
            this .pushParent (node);
            this .childrenElements (xmlElement);

            if (!this .isInsideProtoDeclaration ())
               this .getNodes () .push (node);

            this .popParent ();
         }
      }
      catch (error)
      {
         console .warn ("XML Parser: ", error .message);

         if (_DEVELOPMENT_js__WEBPACK_IMPORTED_MODULE_13__/* ["default"] */ .A)
            console .error (error);
      }
   },
   fieldValueElement (xmlElement)
   {
      try
      {
         if (this .getParents () .length === 0)
            return;

         const
            node = this .getParent (),
            name = xmlElement .getAttribute ("name");

         if (!(node instanceof _Components_Core_X3DPrototypeInstance_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A))
            return;

         if (!this .id (name))
            return;

         const
            field      = node .getField (name),
            accessType = field .getAccessType ();

         if (accessType & _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A .initializeOnly)
         {
            if (field .getType () === _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A .MFNode)
            {
               field .length = 0
            }

            this .fieldValue (field, xmlElement .getAttribute ("value"));

            this .pushParent (field);
            this .childrenElements (xmlElement);
            this .popParent ();
         }
      }
      catch (error)
      {
         console .warn (`XML Parser: Couldn't assign field value. ${error .message}`);
      }
   },
   nodeElement (xmlElement)
   {
      try
      {
         if (this .useAttribute (xmlElement))
            return;

         const node = this .getExecutionContext () .createNode (this .nodeNameToCamelCase (xmlElement .nodeName), false)
            ?? this .getExecutionContext () .createProto (this .protoNameToCamelCase (xmlElement .nodeName), false);

         if (!node)
            throw new Error (`Unknown node type '${xmlElement .nodeName}'. You probably have insufficient component/profile statements and/or an inappropriate specification version.`);

         ///DOMIntegration: attach node to DOM xmlElement for access from DOM.
         $.data (xmlElement, "node", node);

         //DOMIntegration: Script node support for HTML.
         if (xmlElement .nodeName === "SCRIPT")
            this .scriptElement (xmlElement);

         this .defAttribute (xmlElement, node);
         this .addNode (xmlElement, node);
         this .pushParent (node);
         this .nodeAttributes (xmlElement, node);
         this .childrenElements (xmlElement);

         if (!this .isInsideProtoDeclaration ())
            this .getNodes () .push (node);

         this .popParent ();
      }
      catch (error)
      {
         // NULL

         if (xmlElement .nodeName == "NULL")
         {
            this .addNode (xmlElement, null);
            return;
         }

         if (_DEVELOPMENT_js__WEBPACK_IMPORTED_MODULE_13__/* ["default"] */ .A)
            console .error (error);
         else
            console .error (`XML Parser: ${error .message}`);
      }
   },
   scriptElement (element)
   {
      const
         scriptDocument = $.parseXML (element .outerHTML, "application/xml"),
         childNodes     = scriptDocument .children [0] .childNodes;

      element .textContent = "// Content moved into childNodes.";

      for (const childNode of childNodes)
      {
         // Add elements and cdata.
         if (childNode .nodeType === 1 || childNode .nodeType === 4)
            element .appendChild (childNode);
      }
   },
   routeElement (xmlElement)
   {
      try
      {
         const
            sourceNodeName      = xmlElement .getAttribute ("fromNode"),
            sourceField         = xmlElement .getAttribute ("fromField"),
            destinationNodeName = xmlElement .getAttribute ("toNode"),
            destinationField    = xmlElement .getAttribute ("toField");

         if (sourceNodeName === null)
            throw new Error ("Bad ROUTE statement: Expected fromNode attribute.");

         if (sourceField === null)
            throw new Error ("Bad ROUTE statement: Expected fromField attribute.");

         if (destinationNodeName === null)
            throw new Error ("Bad ROUTE statement: Expected toNode attribute.");

         if (destinationField === null)
            throw new Error ("Bad ROUTE statement: Expected toField attribute.");

         const
            executionContext = this .getExecutionContext (),
            sourceNode       = executionContext .getLocalNode (sourceNodeName),
            destinationNode  = executionContext .getLocalNode (destinationNodeName),
            route            = executionContext .addRoute (sourceNode, sourceField, destinationNode, destinationField);

         ///DOMIntegration: attach node to DOM xmlElement for access from DOM.
         $.data (xmlElement, "node", route);
      }
      catch (error)
      {
         console .warn (`XML Parser: ${error .message}`);

         if (_DEVELOPMENT_js__WEBPACK_IMPORTED_MODULE_13__/* ["default"] */ .A)
            console .error (error);
      }
   },
   importElement (xmlElement)
   {
      try
      {
         const
            inlineNodeName   = xmlElement .getAttribute ("inlineDEF"),
            exportedNodeName = xmlElement .getAttribute ("importedDEF") || xmlElement .getAttribute ("exportedDEF"),
            localNodeName    = xmlElement .getAttribute ("AS") || exportedNodeName;

         if (inlineNodeName === null)
            throw new Error ("Bad IMPORT statement: Expected inlineDEF attribute.");

         if (exportedNodeName === null)
            throw new Error ("Bad IMPORT statement: Expected importedDEF attribute.");

         const inlineNode = this .getExecutionContext () .getNamedNode (inlineNodeName);

         // Rename existing imported node.

         this .renameExistingNode (localNodeName);

         // Add new imported node.

         this .getExecutionContext () .addImportedNode (inlineNode, exportedNodeName, localNodeName);

         if (!this .getImportedNodes () .has (localNodeName))
         {
            this .getImportedNodes () .set (localNodeName, this .getExecutionContext () .getImportedNodes () .get (localNodeName));
         }
      }
      catch (error)
      {
         console .warn (`XML Parser: ${error .message}`);
      }
   },
   exportElement (xmlElement)
   {
      try
      {
         const
            localNodeName    = xmlElement .getAttribute ("localDEF"),
            exportedNodeName = xmlElement .getAttribute ("AS") || localNodeName;

         if (localNodeName === null)
            throw new Error ("Bad EXPORT statement: Expected localDEF attribute.");

         const localNode = this .getExecutionContext () .getLocalNode (localNodeName);

         try
         {
            const existingNode = this .getScene () .getExportedNode (exportedNodeName);

            this .getScene () .addExportedNode (this .getScene () .getUniqueExportName (exportedNodeName), existingNode);
         }
         catch
         { }

         this .getScene () .updateExportedNode (exportedNodeName, localNode);
      }
      catch (error)
      {
         console .warn (`XML Parser: ${error .message}`);
      }
   },
   cdataNode (xmlElement)
   {
      if (this .getParents () .length === 0)
         return;

      const node = this .getParent ();

      if (node instanceof _Components_Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A)
         node .getSourceText () ?.push (xmlElement .data);
   },
   useAttribute (xmlElement)
   {
      const name = xmlElement .getAttribute ("USE");

      if (this .id (name))
      {
         const
            browser  = this .getBrowser (),
            nodeName = this .nodeNameToCamelCase (xmlElement .nodeName);

         const type = $.try (() => nodeName === "ProtoInstance"
            ? browser .getAbstractNode ("X3DPrototypeInstance")
            : browser .getConcreteNode (nodeName))
            ?? _Components_Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A;

         const typeName = xmlElement .getAttribute ("name");

         try
         {
            const localNode = this .getExecutionContext () .getLocalNode (name);

            const node = localNode instanceof _Execution_X3DImportedNode_js__WEBPACK_IMPORTED_MODULE_8__/* ["default"] */ .A
               ? localNode .getExportedNode (type)
               : localNode .getValue ();

            this .checkNodeType (node, name, type, typeName);
            this .addNode (xmlElement, node);
         }
         catch
         {
            const placeholder = this .getPlaceholders () .get (name);

            if (placeholder)
            {
               this .addNode (xmlElement, placeholder);
            }
            else
            {
               const placeholder = new _Placeholder_js__WEBPACK_IMPORTED_MODULE_12__/* ["default"] */ .A (this, name, type, typeName);

               this .getPlaceholders () .set (name, placeholder);
               this .addNode (xmlElement, placeholder);
            }
         }

         return true;
      }

      return false;
   },
   checkNodeType (node, name, type, typeName)
   {
      if (type === _Components_Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A)
         return;

      if (type === _Components_Core_X3DPrototypeInstance_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A)
      {
         if (!node .getType () .includes (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A .X3DPrototypeInstance))
         {
            console .warn (`XML Parser: DEF/USE mismatch, '${name}', referenced node is not of type X3DPrototypeInstance.`);
         }
         else if (typeName !== node .getTypeName ())
         {
            console .warn (`XML Parser: DEF/USE mismatch, '${name}', name ${typeName} != ${node .getTypeName ()}.`);
         }
      }
      else if (type !== node .constructor)
      {
         console .warn (`XML Parser: DEF/USE mismatch, '${name}', ${type .typeName} != ${node .getTypeName ()}.`);
      }
   },
   defAttribute (xmlElement, node)
   {
      try
      {
         const name = xmlElement .getAttribute ("DEF");

         if (name)
         {
            if (!this .getNamedNodes () .has (name))
               this .getNamedNodes () .set (name, node);

            this .renameExistingNode (name);

            this .getExecutionContext () .updateNamedNode (name, node);
         }
      }
      catch (error)
      {
         console .warn (`XML Parser: Invalid DEF name: ${error .message}`);
      }
   },
   nodeAttributes (xmlElement, node)
   {
      for (const xmlAttribute of xmlElement .attributes)
         this .nodeAttribute (xmlAttribute, node);
   },
   nodeAttribute (xmlAttribute, node)
   {
      try
      {
         const field = node .getPredefinedField (this .attributeToCamelCase (node, xmlAttribute .name));

         if (field .isInitializable ())
            this .fieldValue (field, xmlAttribute .value);
      }
      catch (error)
      {
         //console .error (error);
      }
   },
   fieldValue (field, value)
   {
      if (value === null)
         return false;

      this .parser .pushExecutionContext (this .getExecutionContext ());
      this .parser .setInput (value);

      const ok = this [field .getType ()] .call (this .parser, field, field .getUnit ());

      this .parser .popExecutionContext ();

      return ok;
   },
   id (string)
   {
      if (string === null)
         return false;

      if (string .length === 0)
         return false;

      return true;
   },
   getParents ()
   {
      return this .parents;
   },
   getParent ()
   {
      return this .parents .at (-1);
   },
   pushParent (parent)
   {
      return this .parents .push (parent);
   },
   popParent ()
   {
      this .parents .pop ();
   },
   addNode (xmlElement, node)
   {
      if (this .parents .length === 0 || this .getParent () instanceof _Prototype_X3DProtoDeclaration_js__WEBPACK_IMPORTED_MODULE_10__/* ["default"] */ .A)
      {
         this .getExecutionContext () .rootNodes .push (node);
         return;
      }

      const parent = this .getParent ();

      if (parent instanceof _Base_X3DField_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A)
      {
         switch (parent .getType ())
         {
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A .SFNode:
               parent .setValue (node);
               return;

            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A .MFNode:
               parent .push (node);
               return;
         }

         return;
      }

      // parent is a node.

      try
      {
         const containerField = xmlElement .getAttribute ("containerField")
            || node ?.getContainerField (this .getExecutionContext () .getSpecificationVersion ());

         if (!containerField)
         {
            console .warn ("XML Parser: Node must have a container field attribute.");
            return;
         }

         const field = parent .getField (containerField);

         switch (field .getType ())
         {
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A .SFNode:
               field .setValue (node);
               return;

            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A .MFNode:
               field .push (node);
               return;
         }
      }
      catch (error)
      {
         // console .error (error);

         if (node ?.getType () .includes (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A .X3DMetadataObject))
         {
            xmlElement .setAttribute ("containerField", "metadata");

            this .addNode (xmlElement, node);
         }
      }
   },
   // Overloaded by HTMLParser.
   addProtoName (name)
   { },
   addProtoFieldNames (protoNode)
   { },
   protoNameToCamelCase (typeName)
   {
      return typeName;
   },
   nodeNameToCamelCase (typeName)
   {
      return typeName;
   },
   attributeToCamelCase (node, name)
   {
      return name;
   },
});

Object .assign (XMLParser .prototype,
{
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A .SFBool]:      _VRMLParser_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .prototype .sfboolValue,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A .SFColor]:     _VRMLParser_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .prototype .sfcolorValue,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A .SFColorRGBA]: _VRMLParser_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .prototype .sfcolorrgbaValue,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A .SFDouble]:    _VRMLParser_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .prototype .sfdoubleValue,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A .SFFloat]:     _VRMLParser_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .prototype .sfdoubleValue,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A .SFImage]:     _VRMLParser_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .prototype .sfimageValue,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A .SFInt32]:     _VRMLParser_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .prototype .sfint32Value,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A .SFMatrix3f]:  _VRMLParser_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .prototype .sfmatrix3Value,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A .SFMatrix3d]:  _VRMLParser_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .prototype .sfmatrix3Value,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A .SFMatrix4f]:  _VRMLParser_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .prototype .sfmatrix4Value,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A .SFMatrix4d]:  _VRMLParser_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .prototype .sfmatrix4Value,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A .SFNode] (field)
   {
      field .setValue (null);
      return true;
   },
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A .SFRotation]:  _VRMLParser_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .prototype .sfrotationValue,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A .SFString] (field)
   {
      field .setValue (_Fields_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .SFString .unescape (this .input));
      return true;
   },
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A .SFTime]:      _VRMLParser_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .prototype .sfdoubleValue,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A .SFVec2d]:     _VRMLParser_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .prototype .sfvec2Value,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A .SFVec2f]:     _VRMLParser_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .prototype .sfvec2Value,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A .SFVec3d]:     _VRMLParser_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .prototype .sfvec3Value,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A .SFVec3f]:     _VRMLParser_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .prototype .sfvec3Value,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A .SFVec4d]:     _VRMLParser_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .prototype .sfvec4Value,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A .SFVec4f]:     _VRMLParser_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .prototype .sfvec4Value,

   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A .VrmlMatrix]:  _VRMLParser_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .prototype .sfmatrix4Value,

   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A .MFBool]:      _VRMLParser_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .prototype .sfboolValues,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A .MFColor]:     _VRMLParser_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .prototype .sfcolorValues,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A .MFColorRGBA]: _VRMLParser_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .prototype .sfcolorValues,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A .MFDouble]:    _VRMLParser_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .prototype .sfdoubleValues,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A .MFFloat]:     _VRMLParser_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .prototype .sfdoubleValues,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A .MFImage]:     _VRMLParser_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .prototype .sfimageValues,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A .MFInt32]:     _VRMLParser_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .prototype .sfint32Values,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A .MFMatrix3d]:  _VRMLParser_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .prototype .sfmatrixValues,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A .MFMatrix3f]:  _VRMLParser_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .prototype .sfmatrixValues,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A .MFMatrix4d]:  _VRMLParser_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .prototype .sfmatrixValues,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A .MFMatrix4f]:  _VRMLParser_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .prototype .sfmatrixValues,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A .MFNode] (field)
   {
      field .length = 0;
      return true;
   },
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A .MFRotation]:  _VRMLParser_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .prototype .sfrotationValues,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A .MFString]:    _VRMLParser_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .prototype .sfstringValues,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A .MFTime]:      _VRMLParser_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .prototype .sfdoubleValues,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A .MFVec2d]:     _VRMLParser_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .prototype .sfvecValues,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A .MFVec2f]:     _VRMLParser_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .prototype .sfvecValues,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A .MFVec3d]:     _VRMLParser_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .prototype .sfvecValues,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A .MFVec3f]:     _VRMLParser_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .prototype .sfvecValues,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A .MFVec4d]:     _VRMLParser_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .prototype .sfvecValues,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A .MFVec4f]:     _VRMLParser_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .prototype .sfvecValues,
});

// HTML Support

const HTMLParser =
{
   addProtoName (name)
   {
      // DOMIntegration: add uppercase versions of proto name.

      this .protoNames .set (name,                 name);
      this .protoNames .set (name .toUpperCase (), name);
   },
   addProtoFieldNames: (() =>
   {
      const reservedAttributes = new Set ();

      for (const reservedAttribute of [
         "DEF",
         "USE",
         "containerField",
      ])
      {
         reservedAttributes
            .add (reservedAttribute)
            .add (reservedAttribute .toLowerCase ());
      }

      return function (protoNode)
      {
         //DOMIntegration: handle lowercase versions of field names.

         const fields = new Map ();

         this .protoFields .set (protoNode, fields);

         for (const { name } of protoNode .getFieldDefinitions ())
         {
            if (reservedAttributes .has (name))
               continue;

            fields .set (name,                 name);
            fields .set (name .toLowerCase (), name);
         }
      };
   })(),
   protoNameToCamelCase (typeName)
   {
      //DOMIntegration: handle uppercase versions of node names.
      return this .protoNames .get (typeName);
   },
   nodeNameToCamelCase (typeName)
   {
      //DOMIntegration: handle uppercase versions of node names.
      return _HTMLSupport_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .getNodeTypeName (typeName);
   },
   attributeToCamelCase (node, name)
   {
      //DOMIntegration: handle lowercase versions of field names.

      if (node instanceof _Components_Core_X3DPrototypeInstance_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A)
         return this .protoFields .get (node .getProtoNode ()) .get (name);

      return _HTMLSupport_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .getFieldName (name);
   },
};

_Base_X3DField_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .prototype .fromXMLString = function (string, scene)
{
   const parser = new XMLParser (scene);

   if (!parser .fieldValue (this, string))
      throw new Error (`Couldn't read value for field '${this .getName ()}'.`);

   parser .setupNodes ();
};

const __default__ = XMLParser;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_14__/* ["default"] */ .A .add ("XMLParser", __default__));

/***/ }),

/***/ 4187:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _X3DParser_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(8265);
/* harmony import */ var _Expressions_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(7274);
/* harmony import */ var _Fields_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(564);
/* harmony import */ var _Base_X3DField_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(5702);
/* harmony import */ var _Execution_X3DImportedNode_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(7627);
/* harmony import */ var _Prototype_X3DExternProtoDeclaration_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(5175);
/* harmony import */ var _Prototype_X3DProtoDeclaration_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(5317);
/* harmony import */ var _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(8899);
/* harmony import */ var _Placeholder_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(4716);
/* harmony import */ var _standard_Math_Numbers_Color3_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(567);
/* harmony import */ var _standard_Math_Numbers_Color4_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(9302);
/* harmony import */ var _standard_Math_Numbers_Matrix3_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(3012);
/* harmony import */ var _standard_Math_Numbers_Matrix4_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(1048);
/* harmony import */ var _standard_Math_Numbers_Rotation4_js__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(1029);
/* harmony import */ var _standard_Math_Numbers_Vector2_js__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(8024);
/* harmony import */ var _standard_Math_Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(2639);
/* harmony import */ var _standard_Math_Numbers_Vector4_js__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(3630);
/* harmony import */ var _DEVELOPMENT_js__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(2084);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(6707);
/* provided dependency */ var $ = __webpack_require__(7682);



















/*
 *  Grammar
 */

// VRML lexical elements
const Grammar = (0,_Expressions_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A) ({
   // General
   Whitespaces: /[\x20\n,\t\r]+/gy,
   Comment:     /#\/\*[\s\S]*?\*\/#|#.*?(?=[\n\r]|$)/gy,
   Comment3_2:  /#.*?(?=[\n\r]|$)/gy,
   Break:       /\r?\n/g,

   // Header
   Header:      /^#(VRML|X3D) V(.*?) (utf8)(?:[ \t]+(.*?))?[ \t]*[\n\r]/gy,

   // Keywords
   AS:          /AS/gy,
   COMPONENT:   /COMPONENT/gy,
   DEF:         /DEF/gy,
   EXPORT:      /EXPORT/gy,
   EXTERNPROTO: /EXTERNPROTO/gy,
   FALSE:       /FALSE|false/gy,
   IMPORT:      /IMPORT/gy,
   IS:          /IS/gy,
   META:        /META/gy,
   NULL:        /NULL|null/gy,
   TRUE:        /TRUE|true/gy,
   PROFILE:     /PROFILE/gy,
   PROTO:       /PROTO/gy,
   ROUTE:       /ROUTE/gy,
   TO:          /TO/gy,
   UNIT:        /UNIT/gy,
   USE:         /USE/gy,

   // Terminal symbols
   OpenBrace:    /\{/gy,
   CloseBrace:   /\}/gy,
   OpenBracket:  /\[/gy,
   CloseBracket: /\]/gy,
   Period:       /\./gy,
   Colon:        /\:/gy,

   Id: /[^\x30-\x39\x00-\x20\x22\x23\x27\x2b\x2c\x2d\x2e\x5b\x5c\x5d\x7b\x7d\x7f]{1}[^\x00-\x20\x22\x23\x27\x2c\x2e\x5b\x5c\x5d\x7b\x7d\x7f]*/gy,
   ComponentNameId: /[^\x30-\x39\x00-\x20\x22\x23\x27\x2b\x2c\x2d\x2e\x5b\x5c\x5d\x7b\x7d\x7f\x3a]{1}[^\x00-\x20\x22\x23\x27\x2c\x2e\x5b\x5c\x5d\x7b\x7d\x7f\x3a]*/gy,

   initializeOnly: /initializeOnly/gy,
   inputOnly:      /inputOnly/gy,
   outputOnly:     /outputOnly/gy,
   inputOutput:    /inputOutput/gy,

   field:        /field/gy,
   eventIn:      /eventIn/gy,
   eventOut:     /eventOut/gy,
   exposedField: /exposedField/gy,

   FieldType: /[SM]F(?:Bool|ColorRGBA|Color|Double|Float|Image|Int32|Matrix3d|Matrix3f|Matrix4d|Matrix4f|Node|Rotation|String|Time|Vec2d|Vec2f|Vec3d|Vec3f|Vec4d|Vec4f)/gy,

   // Values
   int32: /(?:0[xX][\da-fA-F]+)|(?:[+-]?\d+)/gy,
   double: /[+-]?(?:(?:(?:\d*\.\d+)|(?:\d+(?:\.)?))(?:[eE][+-]?\d+)?)/gy,
   doubleQuotes: /"/gy,
   noDoubleQuotes: /[^"]+/gy,

   CONSTANTS: /([+-]?)\b(NAN|INFINITY|INF|PI|PI2|PI1_4|PI2_4|PI3_4|PI4_4|PI5_4|PI6_4|PI7_4|PI8_4|PI1_2|PI2_2|PI3_2|PI4_2|PI1_3|PI2_3|PI3_3|PI4_3|PI5_3|PI6_3|SQRT1_2|SQRT2)\b/igy,
   HTMLColor: /[a-zA-Z]+|0[xX][\da-fA-F]+|rgba?\(.*?\)/gy,
});

/*
 *  Parser
 */

function VRMLParser (scene)
{
   _X3DParser_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .call (this, scene);

   this .Grammar =
   {
      Comment: Grammar .Comment,
   };
}

Object .assign (Object .setPrototypeOf (VRMLParser .prototype, _X3DParser_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .prototype),
{
   accessTypes: new Map ([
      ["field",          _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .initializeOnly],
      ["eventIn",        _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .inputOnly],
      ["eventOut",       _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .outputOnly],
      ["exposedField",   _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .inputOutput],
      ["initializeOnly", _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .initializeOnly],
      ["inputOnly",      _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .inputOnly],
      ["outputOnly",     _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .outputOnly],
      ["inputOutput",    _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .inputOutput],
   ]),
   SFImage: new _Fields_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .SFImage (),
   SFNode: new _Fields_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .SFNode (),
   MFString: new _Fields_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .MFString (),
   Color3: new _standard_Math_Numbers_Color3_js__WEBPACK_IMPORTED_MODULE_9__/* ["default"] */ .A (),
   Color4: new _standard_Math_Numbers_Color4_js__WEBPACK_IMPORTED_MODULE_10__/* ["default"] */ .A (),
   Matrix3: new _standard_Math_Numbers_Matrix3_js__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A (),
   Matrix4: new _standard_Math_Numbers_Matrix4_js__WEBPACK_IMPORTED_MODULE_12__/* ["default"] */ .A (),
   Rotation4: new _standard_Math_Numbers_Rotation4_js__WEBPACK_IMPORTED_MODULE_13__/* ["default"] */ .A (),
   Vector2: new _standard_Math_Numbers_Vector2_js__WEBPACK_IMPORTED_MODULE_14__/* ["default"] */ .A (),
   Vector3: new _standard_Math_Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_15__/* ["default"] */ .A (),
   Vector4: new _standard_Math_Numbers_Vector4_js__WEBPACK_IMPORTED_MODULE_16__/* ["default"] */ .A (),
   CONSTANTS: new Map ([
      ["NAN",      Number .NaN],
      ["INFINITY", Number .POSITIVE_INFINITY],
      ["INF",      Number .POSITIVE_INFINITY],
      ["PI",    Math .PI],
      ["PI2",   Math .PI * 2],
      ["PI1_4", Math .PI * 1/4],
      ["PI2_4", Math .PI * 2/4],
      ["PI3_4", Math .PI * 3/4],
      ["PI4_4", Math .PI * 4/4],
      ["PI5_4", Math .PI * 5/4],
      ["PI6_4", Math .PI * 6/4],
      ["PI7_4", Math .PI * 7/4],
      ["PI8_4", Math .PI * 8/4],
      ["PI1_2", Math .PI * 1/2],
      ["PI2_2", Math .PI * 2/2],
      ["PI3_2", Math .PI * 3/2],
      ["PI4_2", Math .PI * 4/2],
      ["PI1_3", Math .PI * 1/3],
      ["PI2_3", Math .PI * 2/3],
      ["PI3_3", Math .PI * 3/3],
      ["PI4_3", Math .PI * 4/3],
      ["PI5_3", Math .PI * 5/3],
      ["PI6_3", Math .PI * 6/3],
      ["SQRT1_2", Math .SQRT1_2],
      ["SQRT2",   Math .SQRT2],
   ]),
   unknownLevel: 0,
   getEncoding ()
   {
      return "STRING";
   },
   setInput (vrmlSyntax)
   {
      this .input      = vrmlSyntax;
      this .lineNumber = 1;
      this .lastIndex  = 0;
   },
   isValid ()
   {
      if (typeof this .input !== "string")
         return false;

      if (this .input .match (/^#VRML V1.0/))
         return false;

      return !! this .input .match (/^(?:#X3D|#VRML|(?:[\x20\n,\t\r]*|#.*?[\r\n])*(PROFILE|COMPONENT|META|UNIT|EXTERNPROTO|PROTO|DEF|NULL|IMPORT|EXPORT|ROUTE|\w+(?:[\x20\n,\t\r]*|#.*?[\r\n])\{|$))/);
   },
   parseIntoScene (resolve, reject)
   {
      try
      {
         this .resolve = resolve;
         this .reject  = reject;

         this .getScene () .setEncoding ("VRML");
         this .getScene () .setProfile (this .getBrowser () .getProfile ("Full"));
         this .x3dScene ();
      }
      catch (error)
      {
         throw new Error (this .getError (error));
      }
   },
   getError (error)
   {
      if (_DEVELOPMENT_js__WEBPACK_IMPORTED_MODULE_17__/* ["default"] */ .A)
         console .error (error);

      const
         string     = error .message,
         unexpected = this .lastIndex === this .input .length ? "Unexpected end of file. " : "";

      let
         rest     = this .getLine (),
         line     = this .getLastLine (),
         lastLine = this .getLastLine (),
         linePos  = line .length - rest .length + 1;

      if (line .length > 80)
      {
         line     = line .substring (linePos - 40, linePos + 40);
         lastLine = "";
         linePos  = 40;
      }

      // Get world URL.

      let worldURL = this .getExecutionContext () .getWorldURL ();

      if (worldURL .startsWith ("data:"))
         worldURL = worldURL .substring (0, worldURL .indexOf (","));

      // Format error.

      const message = "\n"
         + `********************************************************************************\n`
         + `Parser error at line ${this .lineNumber}:${linePos}\n`
         + `in '${worldURL}'\n`
         + `\n`
         + `${lastLine}\n`
         + `${line}\n`
         + `${Array (linePos) .join (" ")}^\n`
         + `${unexpected}${string}\n`
         + `********************************************************************************\n`
      ;

      return message;
   },
   getLine ()
   {
      let
         input     = this .input,
         lastIndex = this .lastIndex,
         line      = "";

      while (lastIndex < input .length && input [lastIndex] !== "\n" && input [lastIndex] !== "\r")
         line += input [lastIndex ++];

      this .lastIndex = lastIndex;

      return line;
   },
   getLastLine ()
   {
      let
         input     = this .input,
         lastIndex = Math .min (this .lastIndex, this .input .length - 1),
         line      = "";

      if (lastIndex < input .length && (input [lastIndex] !== "\n" || input [lastIndex] !== "\r"))
         -- lastIndex;

      while (lastIndex >= 0 && input [lastIndex] !== "\n" && input [lastIndex] !== "\r")
         line = input [lastIndex --] + line;

      this .lastIndex = lastIndex;

      return line;
   },
   comments ()
   {
      while (this .comment ())
         ;
   },
   comment ()
   {
      if (this .whitespaces ())
         return true;

      return this .Grammar .Comment .parse (this);
   },
   whitespaces ()
   {
      if (Grammar .Whitespaces .parse (this))
      {
         this .lines (this .result [0]);

         return true;
      }

      return false;
   },
   lines (string)
   {
      const match = string .match (Grammar .Break);

      if (match)
         this .lineNumber += match .length;
   },
   x3dScene: (() =>
   {
      const VRML =
      [
         "EnvironmentalSensor",
         "PointingDeviceSensor",
         "Scripting",
         "Sound",
         "Text",
      ];

      return function ()
      {
         const
            browser = this .getBrowser (),
            scene   = this .getScene ();

         this .headerStatement ();
         this .profileStatement ();
         this .componentStatements ();
         this .unitStatements ();
         this .metaStatements ();

         if (scene .getSpecificationVersion () === "2.0")
         {
            scene .setProfile (browser .getProfile ("Interchange"));

            for (const componentName of VRML)
               scene .updateComponent (browser .getComponent (componentName));
         }

         if (this .resolve)
         {
            browser .loadComponents (scene) .then (() =>
            {
               try
               {
                  this .statements (this .getExecutionContext () .rootNodes);
                  this .setupNodes ();

                  if (this .lastIndex < this .input .length)
                     throw new Error ("Unknown statement.");

                  this .resolve (scene);
               }
               catch (error)
               {
                  throw new Error (this .getError (error));
               }
            })
            .catch (this .reject);
         }
         else
         {
            this .statements (this .getExecutionContext () .rootNodes);
            this .setupNodes ();

            if (this .lastIndex < this .input .length)
               throw new Error ("Unknown statement.");
         }
      };
   })(),
   headerStatement ()
   {
      if (Grammar .Header .parse (this))
      {
         this .lines (this .result [0]);

         this .getScene () .setSpecificationVersion (this .result [2]);

         if (this .getScene () .getSpecificationVersion () <= 3.2)
            this .Grammar .Comment = Grammar .Comment3_2;

         return true;
      }

      return false;
   },
   profileStatement ()
   {
      this .comments ();

      if (Grammar .PROFILE .parse (this))
      {
         if (this .profileNameId ())
         {
            const profile = this .getBrowser () .getProfile (this .result [0]);

            this .getScene () .setProfile (profile);
            return;
         }

         throw new Error ("Expected a profile name.");
      }
   },
   componentStatements ()
   {
      let component;

      while (component = this .componentStatement ())
      {
         if (this .getScene () .hasComponent (component))
            continue;

         this .getScene () .updateComponent (component);
      }
   },
   componentStatement ()
   {
      this .comments ();

      if (Grammar .COMPONENT .parse (this))
      {
         if (this .componentNameId ())
         {
            const componentNameIdCharacters = this .result [0];

            this .comments ();

            if (Grammar .Colon .parse (this))
            {
               if (this .componentSupportLevel ())
               {
                  const componentSupportLevel = this .value;

                  return this .getBrowser () .getComponent (componentNameIdCharacters, componentSupportLevel);
               }

               throw new Error ("Expected a component support level.");
            }

            throw new Error ("Expected a ':' after component name.");
         }

         throw new Error ("Expected a component name.");
      }

      return null;
   },
   componentSupportLevel ()
   {
      return this .int32 ();
   },
   unitStatements ()
   {
      while (this .unitStatement ())
         ;
   },
   unitStatement ()
   {
      this .comments ();

      if (Grammar .UNIT .parse (this))
      {
         if (this .categoryNameId ())
         {
            const categoryNameId = this .result [0];

            if (this .unitNameId ())
            {
               const unitNameId = this .result [0];

               if (this .unitConversionFactor ())
               {
                  const unitConversionFactor = this .value;

                  try
                  {
                     this .getScene () .updateUnit (categoryNameId, unitNameId, unitConversionFactor);
                     return true;
                  }
                  catch (error)
                  {
                     console .warn (`Parser error at line ${this .lineNumber}: ${error .message}`);
                     return true;
                  }
               }

               throw new Error ("Expected unit conversion factor.");
            }

            throw new Error ("Expected unit name identifier.");
         }

         throw new Error ("Expected category name identifier after UNIT statement.");
      }

      return false;
   },
   unitConversionFactor ()
   {
      return this .double ();
   },
   metaStatements ()
   {
      while (this .metaStatement ())
         ;
   },
   metaStatement ()
   {
      this .comments ();

      if (Grammar .META .parse (this))
      {
         if (this .metaKey ())
         {
            const metaKey = this .value;

            if (this .metaValue ())
            {
               const metaValue = this .value;

               this .getScene () .addMetaData (metaKey, metaValue);
               return true;
            }

            throw new Error ("Expected metadata value.");
         }

         throw new Error ("Expected metadata key.");
      }

      return false;
   },
   metaKey ()
   {
      return this .string ();
   },
   metaValue ()
   {
      return this .string ();
   },
   exportStatement ()
   {
      this .comments ();

      if (Grammar .EXPORT .parse (this))
      {
         if (this .nodeNameId ())
         {
            const localNodeNameId = this .result [0];

            this .comments ();

            const node = this .getScene () .getLocalNode (localNodeNameId);

            let exportedNodeNameId;

            if (Grammar .AS .parse (this))
            {
               if (this .exportedNodeNameId ())
                  exportedNodeNameId = this .result [0];
               else
                  throw new Error ("No name given after AS.");
            }
            else
            {
               exportedNodeNameId = localNodeNameId;
            }

            try
            {
               const existingNode = this .getScene () .getExportedNode (exportedNodeNameId);

               this .getScene () .addExportedNode (this .getScene () .getUniqueExportName (exportedNodeNameId), existingNode);
            }
            catch
            { }

            this .getScene () .updateExportedNode (exportedNodeNameId, node);
            return true;
         }

         throw new Error ("No name given after EXPORT.");
      }

      return false;
   },
   importStatement ()
   {
      this .comments ();

      if (Grammar .IMPORT .parse (this))
      {
         if (this .nodeNameId ())
         {
            const
               inlineNodeNameId = this .result [0],
               namedNode        = this .getExecutionContext () .getNamedNode (inlineNodeNameId);

            this .comments ();

            if (Grammar .Period .parse (this))
            {
               if (this .exportedNodeNameId ())
               {
                  const exportedNodeNameId = this .result [0];

                  this .comments ();

                  let nodeNameId;

                  if (Grammar .AS .parse (this))
                  {
                     if (this .nodeNameId ())
                        nodeNameId = this .result [0];

                     else
                        throw new Error ("No name given after AS.");
                  }
                  else
                  {
                     nodeNameId = exportedNodeNameId;
                  }

                  // Rename existing imported node.

                  this .renameExistingNode (nodeNameId);

                  // Add new imported node.

                  this .getExecutionContext () .addImportedNode (namedNode, exportedNodeNameId, nodeNameId);

                  if (!this .getImportedNodes () .has (nodeNameId))
                  {
                     this .getImportedNodes () .set (nodeNameId, this .getExecutionContext () .getImportedNodes () .get (nodeNameId));
                  }

                  return true;
               }

               throw new Error ("Expected exported node name.");
            }

            throw new Error ("Expected a '.' after exported node name.");
         }

         throw new Error ("No name given after IMPORT statement.");
      }
      return false;
   },
   statements (field)
   {
      while (this .statement (field))
         ;
   },
   statement (field)
   {
      if (this .protoStatement ())
         return true;

      if (this .routeStatement ())
         return true;

      if (this .importStatement ())
         return true;

      if (this .exportStatement ())
         return true;

      const node = this .nodeStatement ();

      if (node !== false)
      {
         field .push (node);
         return true;
      }

      return false;
   },
   nodeStatement ()
   {
      this .comments ();

      if (Grammar .DEF .parse (this))
      {
         if (this .nodeNameId ())
            return this .node (this .result [0]);

         throw new Error ("No name given after DEF.");
      }

      if (Grammar .USE .parse (this))
      {
         if (this .nodeNameId ())
         {
            const nodeNameId = this .result [0];

            try
            {
               const localNode = this .getExecutionContext () .getLocalNode (nodeNameId);

               return localNode instanceof _Execution_X3DImportedNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A
                  ? localNode .getExportedNode ()
                  : localNode .getValue ();
            }
            catch
            {
               const placeholder = this .getPlaceholders () .get (nodeNameId);

               if (placeholder)
               {
                  return placeholder;
               }
               else
               {
                  const placeholder = new _Placeholder_js__WEBPACK_IMPORTED_MODULE_8__/* ["default"] */ .A (this, nodeNameId);

                  this .getPlaceholders () .set (nodeNameId, placeholder);

                  return placeholder;
               }
            }
         }

         throw new Error ("No name given after USE.");
      }

      if (Grammar .NULL .parse (this))
         return null;

      return this .node ("");
   },
   protoStatement ()
   {
      if (this .proto ())
         return true;

      if (this .externproto ())
         return true;

      return false;
   },
   protoStatements ()
   {
      while (this .protoStatement ())
         ;
   },
   proto ()
   {
      this .comments ();

      if (Grammar .PROTO .parse (this))
      {
         if (this .nodeTypeId ())
         {
            const nodeTypeId = this .result [0];

            this .comments ();

            if (Grammar .OpenBracket .parse (this))
            {
               const interfaceDeclarations = this .interfaceDeclarations ();

               this .comments ();

               if (Grammar .CloseBracket .parse (this))
               {
                  this .comments ();

                  if (Grammar .OpenBrace .parse (this))
                  {
                     const proto = new _Prototype_X3DProtoDeclaration_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A (this .getExecutionContext ());

                     for (const field of interfaceDeclarations)
                        proto .addUserDefinedField (field .getAccessType (), field .getName (), field);

                     this .pushExecutionContext (proto .getBody ());
                     this .protoBody (proto .getBody () .rootNodes);
                     this .setupNodes ();
                     this .popExecutionContext ();

                     this .comments ();

                     if (Grammar .CloseBrace .parse (this))
                     {
                        proto .setup ();

                        try
                        {
                           const existingProto = this .getExecutionContext () .getProtoDeclaration (nodeTypeId);

                           console .warn (`A proto named '${nodeTypeId}' is already defined and will be overridden.`);

                           this .getExecutionContext () .updateProtoDeclaration (this .getExecutionContext () .getUniqueProtoName (nodeTypeId), existingProto);
                        }
                        catch
                        { }

                        this .getExecutionContext () .updateProtoDeclaration (nodeTypeId, proto);

                        return true;
                     }

                     throw new Error ("Expected a '}' at the end of PROTO body.");
                  }

                  throw new Error ("Expected a '{' at the beginning of PROTO body.");
               }

               throw new Error ("Expected a ']' at the end of PROTO interface declaration.");
            }

            throw new Error ("Expected a '[' at the beginning of PROTO interface declaration.");
         }

         throw new Error ("Invalid PROTO definition name.");
      }

      return false;
   },
   protoBody (rootNodes)
   {
      this .protoStatements ();

      const rootNodeStatement = this .rootNodeStatement ();

      if (rootNodeStatement !== false)
         rootNodes .push (rootNodeStatement);

      this .statements (rootNodes);
   },
   rootNodeStatement ()
   {
      this .comments ();

      if (Grammar .DEF .parse (this))
      {
         if (this .nodeNameId ())
         {
            const
               nodeNameId = this .result [0],
               baseNode   = this .node (nodeNameId);

            if (baseNode !== false)
               return baseNode;

            throw new Error ("Expected node type name after DEF.");
         }

         throw new Error ("No name given after DEF.");
      }

      const baseNode = this .node ("");

      if (baseNode !== false)
         return baseNode;

      return false;
   },
   interfaceDeclarations ()
   {
      const interfaceDeclarations = [ ];

      let field;

      while (field = this .interfaceDeclaration ())
         interfaceDeclarations .push (field);

      return interfaceDeclarations;
   },
   restrictedInterfaceDeclaration ()
   {
      this .comments ();

      if (Grammar .inputOnly .parse (this) || Grammar .eventIn .parse (this))
      {
         if (this .fieldType ())
         {
            const fieldType = this .result [0];

            if (this .inputOnlyId ())
            {
               const
                  fieldId = this .result [0],
                  field   = new (_Fields_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A [fieldType]) ();

               field .setAccessType (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .inputOnly);
               field .setName (fieldId);

               return field;
            }

            throw new Error ("Expected a name for field.");
         }

         this .Id ();

         throw new Error (`Unknown event or field type: '${this .result [0]}'.`);
      }

      if (Grammar .outputOnly .parse (this) || Grammar .eventOut .parse (this))
      {
         if (this .fieldType ())
         {
            const fieldType = this .result [0];

            if (this .outputOnlyId ())
            {
               const
                  fieldId = this .result [0],
                  field   = new (_Fields_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A [fieldType]) ();

               field .setAccessType (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .outputOnly);
               field .setName (fieldId);

               return field;
            }

            throw new Error ("Expected a name for field.");
         }

         this .Id ();

         throw new Error (`Unknown event or field type: '${this .result [0]}'.`);
      }

      if (Grammar .initializeOnly .parse (this) || Grammar .field .parse (this))
      {
         if (this .fieldType ())
         {
            const fieldType = this .result [0];

            if (this .initializeOnlyId ())
            {
               const
                  fieldId = this .result [0],
                  field   = new (_Fields_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A [fieldType]) ();

               if (this .fieldValue (field))
               {
                  field .setAccessType (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .initializeOnly);
                  field .setName (fieldId);

                  return field;
               }

               throw new Error (`Couldn't read value for field '${fieldId}'.`);
            }

            throw new Error ("Expected a name for field.");
         }

         this .Id ();

         throw new Error (`Unknown event or field type: '${this .result [0]}'.`);
      }

      return null;
   },
   interfaceDeclaration ()
   {
      const field = this .restrictedInterfaceDeclaration ();

      if (field)
         return field;

      this .comments ();

      if (Grammar .inputOutput .parse (this) || Grammar .exposedField .parse (this))
      {
         if (this .fieldType ())
         {
            const fieldType = this .result [0];

            if (this .inputOutputId ())
            {
               const
                  fieldId = this .result [0],
                  field   = new (_Fields_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A [fieldType]) ();

               if (this .fieldValue (field))
               {
                  field .setAccessType (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .inputOutput);
                  field .setName (fieldId);

                  return field;
               }

               throw new Error (`Couldn't read value for field '${fieldId}'.`);
            }

            throw new Error ("Expected a name for field.");
         }

         this .Id ();

         throw new Error (`Unknown event or field type: '${this .result [0]}'.`);
      }

      return null;
   },
   externproto ()
   {
      this .comments ();

      if (Grammar .EXTERNPROTO .parse (this))
      {
         if (this .nodeTypeId ())
         {
            const nodeTypeId = this .result [0];

            this .comments ();

            if (Grammar .OpenBracket .parse (this))
            {
               const externInterfaceDeclarations = this .externInterfaceDeclarations ();

               this .comments ();

               if (Grammar .CloseBracket .parse (this))
               {
                  if (this .URLList (this .MFString))
                  {
                     const externproto = new _Prototype_X3DExternProtoDeclaration_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A (this .getExecutionContext (), this .MFString);

                     for (const field of externInterfaceDeclarations)
                        externproto .addUserDefinedField (field .getAccessType (), field .getName (), field);

                     externproto .setup ();

                     try
                     {
                        const existingExternProto = this .getExecutionContext () .getExternProtoDeclaration (nodeTypeId);

                        console .warn (`A extern proto named '${nodeTypeId}' is already defined and will be overridden.`);

                        this .getExecutionContext () .updateExternProtoDeclaration (this .getExecutionContext () .getUniqueExternProtoName (nodeTypeId), existingExternProto);
                     }
                     catch
                     { }

                     this .getExecutionContext () .updateExternProtoDeclaration (nodeTypeId, externproto);
                     return true;
                  }

                  throw new Error (`Expected a URL list after EXTERNPROTO interface declaration '${nodeTypeId}'.`);
               }

               throw new Error ("Expected a ']' at the end of EXTERNPROTO interface declaration.");
            }

            throw new Error ("Expected a '[' at the beginning of EXTERNPROTO interface declaration.");
         }

         throw new Error ("Invalid EXTERNPROTO definition name.");
      }

      return false;
   },
   externInterfaceDeclarations ()
   {
      const externInterfaceDeclarations = [ ];

      let field;

      while (field = this .externInterfaceDeclaration ())
         externInterfaceDeclarations .push (field);

      return externInterfaceDeclarations;
   },
   externInterfaceDeclaration ()
   {
      this .comments ();

      if (Grammar .inputOnly .parse (this) || Grammar .eventIn .parse (this))
      {
         if (this .fieldType ())
         {
            const fieldType = this .result [0];

            if (this .inputOnlyId ())
            {
               const
                  fieldId = this .result [0],
                  field   = new (_Fields_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A [fieldType]) ();

               field .setAccessType (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .inputOnly);
               field .setName (fieldId);

               return field;
            }

            throw new Error ("Expected a name for field.");
         }

         this .Id ()

         throw new Error (`Unknown event or field type: '${this .result [0]}'.`);
      }

      if (Grammar .outputOnly .parse (this) || Grammar .eventOut .parse (this))
      {
         if (this .fieldType ())
         {
            const fieldType = this .result [0];

            if (this .outputOnlyId ())
            {
               const
                  fieldId = this .result [0],
                  field   = new (_Fields_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A [fieldType]) ();

               field .setAccessType (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .outputOnly);
               field .setName (fieldId);

               return field;
            }

            throw new Error ("Expected a name for field.");
         }

         this .Id ()

         throw new Error (`Unknown event or field type: '${this .result [0]}'.`);
      }

      if (Grammar .initializeOnly .parse (this) || Grammar .field .parse (this))
      {
         if (this .fieldType ())
         {
            const fieldType = this .result [0];

            if (this .initializeOnlyId ())
            {
               const
                  fieldId = this .result [0],
                  field   = new (_Fields_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A [fieldType]) ();

               field .setAccessType (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .initializeOnly);
               field .setName (fieldId);

               return field;
            }

            throw new Error ("Expected a name for field.");
         }

         this .Id ()

         throw new Error (`Unknown event or field type: '${this .result [0]}'.`);
      }

      if (Grammar .inputOutput .parse (this) || Grammar .exposedField .parse (this))
      {
         if (this .fieldType ())
         {
            const fieldType = this .result [0];

            if (this .inputOutputId ())
            {
               const
                  fieldId = this .result [0],
                  field   = new (_Fields_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A [fieldType]) ();

               field .setAccessType (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .inputOutput);
               field .setName (fieldId);

               return field;
            }

            throw new Error ("Expected a name for field.");
         }

         this .Id ()

         throw new Error (`Unknown event or field type: '${this .result [0]}'.`);
      }

      return null;
   },
   URLList (field)
   {
      return this .mfstringValue (field);
   },
   routeStatement ()
   {
      this .comments ();

      if (Grammar .ROUTE .parse (this))
      {
         if (this .nodeNameId ())
         {
            const
               fromNodeId = this .result [0],
               fromNode   = this .getExecutionContext () .getLocalNode (fromNodeId);

            this .comments ();

            if (Grammar .Period .parse (this))
            {
               if (this .outputOnlyId ())
               {
                  const eventOutId = this .result [0];

                  this .comments ();

                  if (Grammar .TO .parse (this))
                  {
                     if (this .nodeNameId ())
                     {
                        const
                           toNodeId = this .result [0],
                           toNode   = this .getExecutionContext () .getLocalNode (toNodeId);

                        this .comments ();

                        if (Grammar .Period .parse (this))
                        {
                           if (this .inputOnlyId ())
                           {
                              try
                              {
                                 const eventInId = this .result [0];

                                 this .getExecutionContext () .addRoute (fromNode, eventOutId, toNode, eventInId);
                                 return true;
                              }
                              catch (error)
                              {
                                 console .warn (`Parser error at line ${this .lineNumber}: ${error .message}`);

                                 return true;
                              }
                           }

                           throw new Error ("Bad ROUTE specification: Expected a field name.");
                        }

                        throw new Error ("Bad ROUTE specification: Expected a '.' after node name.");
                     }

                     throw new Error ("Bad ROUTE specification: Expected a node name.");
                  }

                  throw new Error ("Bad ROUTE specification: Expected a 'TO'.");
               }

               throw new Error ("Bad ROUTE specification: Expected a field name.");
            }

            throw new Error ("Bad ROUTE specification: Expected a '.' after node name.");
         }

         throw new Error ("Bad ROUTE specification: Expected a node name.");
      }

      return false;
   },
   node (nodeNameId)
   {
      if (this .nodeTypeId ())
      {
         const nodeTypeId = this .result [0];

         const baseNode = this .getExecutionContext () .createNode (nodeTypeId, false)
            ?? this .getExecutionContext () .createProto (nodeTypeId, false);

         if (!baseNode)
         {
            // Parse unknown node.

            if (!this .unknownLevel)
            {
               console .warn (`Parser error at line ${this .lineNumber}: Unknown node type or proto '${nodeTypeId}'. You probably have insufficient component/profile statements, and/or an inappropriate specification version.`);
            }

            this .comments ();

            if (Grammar .OpenBrace .parse (this))
            {
               ++ this .unknownLevel;

               this .nodeBody (this .getExecutionContext () .createNode ("WorldInfo", false));

               -- this .unknownLevel;

               this .comments ();

               if (Grammar .CloseBrace .parse (this))
                  return null;
            }

            return false;
         }

         if (nodeNameId .length)
         {
            if (!this .getNamedNodes () .has (nodeNameId))
               this .getNamedNodes () .set (nodeNameId, baseNode);

            this .renameExistingNode (nodeNameId);

            this .getExecutionContext () .updateNamedNode (nodeNameId, baseNode);
         }

         this .comments ();

         if (Grammar .OpenBrace .parse (this))
         {
            if (baseNode .canUserDefinedFields ())
               this .scriptBody (baseNode);

            else
               this .nodeBody (baseNode);

            this .comments ();

            if (Grammar .CloseBrace .parse (this))
            {
               if (!this .isInsideProtoDeclaration ())
                  this .getNodes () .push (baseNode);

               return baseNode;
            }

            throw new Error ("Expected '}' at the end of node body.");
         }

         throw new Error ("Expected '{' at the beginning of node body.");
      }

      return false;
   },
   scriptBody (baseNode)
   {
      while (this .scriptBodyElement (baseNode))
         ;
   },
   scriptBodyElement (baseNode)
   {
      const { lastIndex, lineNumber } = this;

      if (this .Id ())
      {
         const accessType = this .accessTypes .get (this .result [0]);

         if (accessType)
         {
            if (this .fieldType ())
            {
               const fieldType = this .result [0];

               if (this .Id ())
               {
                  const fieldId = this .result [0];

                  this .comments ();

                  if (Grammar .IS .parse (this))
                  {
                     if (this .isInsideProtoDeclaration ())
                     {
                        if (this .Id ())
                        {
                           const isId = this .result [0];

                           let reference;

                           try
                           {
                              reference = this .getOuterNode () .getField (isId);
                           }
                           catch
                           {
                              console .warn (`Parser error at line ${this .lineNumber}: No such event or field '${isId}' inside PROTO ${this .getOuterNode () .getName ()} interface declaration.`);

                              return true;
                           }

                           if (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A [fieldType] === reference .getType ())
                           {
                              if (reference .isReference (accessType))
                              {
                                 let field = $.try (() => baseNode .getUserDefinedField (fieldId));

                                 if (!field)
                                 {
                                    field = new (_Fields_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A [fieldType]) ();

                                    baseNode .addUserDefinedField (accessType, fieldId, field);
                                 }

                                 if (accessType === field .getAccessType () && reference .getType () === field .getType ())
                                 {
                                    field .addReference (reference);
                                    return true;
                                 }

                                 throw new Error (`Couldn't add field '${fieldId}', field already exists with different access type or data type.`);
                              }

                              throw new Error (`Field '${fieldId}' and '${reference .getName ()}' in PROTO '${this .getOuterNode () .getName ()}' are incompatible as an IS mapping.`);
                           }

                           throw new Error (`Field '${fieldId}' and '${reference .getName ()}' in PROTO '${this .getOuterNode () .getName ()}' have different types.`);
                        }

                        throw new Error ("No name give after IS statement.");
                     }

                     throw new Error ("IS statement outside PROTO definition.");
                  }
               }
            }
         }
      }

      this .lastIndex  = lastIndex;
      this .lineNumber = lineNumber;

      const field = this .interfaceDeclaration ();

      if (field)
      {
         const existingField = $.try (() => baseNode .getUserDefinedField (field .getName ()));

         if (existingField)
         {
            if (existingField .getAccessType () === field .getAccessType () && existingField .getType () === field .getType ())
            {
               existingField .assign (field);
               return true;
            }

            throw new Error (`Couldn't set value for field '${field .getName ()}', field already exists with different access type or data type.`);
         }

         baseNode .addUserDefinedField (field .getAccessType (), field .getName (), field);
         return true;
      }

      return this .nodeBodyElement (baseNode);
   },
   nodeBody (baseNode)
   {
      while (this .nodeBodyElement (baseNode))
         ;
   },
   nodeBodyElement (baseNode)
   {
      if (this .protoStatement ())
         return true;

      if (this .routeStatement ())
         return true;

      if (this .Id ())
      {
         const fieldId = this .result [0];

         let field;

         try
         {
            field = baseNode .getPredefinedField (fieldId);
         }
         catch
         {
            // Parse unknown field value.

            const { lastIndex, lineNumber } = this;

            if (this .unknownValue ())
            {
               if (!this .unknownLevel)
               {
                  console .warn (`Parser error at line ${lineNumber}: Unknown field '${fieldId}' in class '${baseNode .getTypeName ()}'.`);
               }

               return true;
            }

            this .lastIndex  = lastIndex;
            this .lineNumber = lineNumber;

            throw new Error (`Unknown field '${fieldId}' in class '${baseNode .getTypeName ()}'.`);
         }

         this .comments ();

         if (Grammar .IS .parse (this))
         {
            if (this .isInsideProtoDeclaration ())
            {
               if (this .Id ())
               {
                  const isId = this .result [0];

                  let reference;

                  try
                  {
                     reference = this .getOuterNode () .getField (isId);
                  }
                  catch
                  {
                     console .warn (`Parser error at line ${this .lineNumber}: No such event or field '${isId}' inside PROTO ${this .getOuterNode () .getName ()}`);

                     return true;
                  }

                  if (field .getType () === reference .getType ())
                  {
                     if (reference .isReference (field .getAccessType ()))
                     {
                        field .addReference (reference);
                        return true;
                     }

                     throw new Error (`Field '${field .getName ()}' and '${reference .getName ()}' in PROTO ${this .getOuterNode () .getName ()} are incompatible as an IS mapping.`);
                  }

                  throw new Error (`Field '${field .getName ()}' and '${reference .getName ()}' in PROTO ${this .getOuterNode () .getName ()} have different types.`);
               }

               throw new Error ("No name give after IS statement.");
            }

            throw new Error ("IS statement outside PROTO definition.");
         }

         if (field .isInitializable ())
         {
            if (this .fieldValue (field))
               return true;

            throw new Error (`Couldn't read value for field '${fieldId}'.`);
         }

         // Parse value of a inputOnly or outputOnly, and output a warning.

         if (!this .unknownValue ())
            throw new Error (`Couldn't read value for field '${fieldId}'.`);

         console .warn (`Parser error at line ${this .lineNumber}: Couldn't assign value to ${this .accessTypeToString (field .getAccessType ())} field '${fieldId}'.`);

         return true;
      }

      return false;
   },
   profileNameId () { return this .Id (); },
   componentNameId ()
   {
      this .comments ();

      return Grammar .ComponentNameId .parse (this);
   },
   categoryNameId () { return this .Id (); },
   unitNameId () { return this .Id (); },
   exportedNodeNameId () { return this .Id (); },
   nodeNameId () { return this .Id (); },
   nodeTypeId () { return this .Id (); },
   initializeOnlyId () { return this .Id (); },
   inputOnlyId () { return this .Id (); },
   outputOnlyId () { return this .Id (); },
   inputOutputId () { return this .Id (); },
   Id ()
   {
      this .comments ();

      return Grammar .Id .parse (this);
   },
   fieldType ()
   {
      this .comments ();

      return Grammar .FieldType .parse (this);
   },
   fieldValue (field)
   {
      return this [field .getType ()] (field, field .getUnit ());
   },
   bool ()
   {
      this .comments ();

      if (Grammar .TRUE .parse (this))
      {
         this .value = true;
         return true;
      }

      if (Grammar .FALSE .parse (this))
      {
         this .value = false;
         return true;
      }

      return false;
   },
   double ()
   {
      this .comments ();

      if (Grammar .double .parse (this))
      {
         this .value = parseFloat (this .result [0]);
         return true;
      }

      // Constants

      if (Grammar .CONSTANTS .parse (this))
      {
         this .value = this .CONSTANTS .get (this .result [2] .toUpperCase ());

         if (this .result [1] === "-")
            this .value = -this .value;

         return true;
      }

      return false;
   },
   int32 ()
   {
      this .comments ();

      if (Grammar .int32 .parse (this))
      {
         this .value = parseInt (this .result [0]);
         return true;
      }

      return false;
   },
   string ()
   {
      this .comments ();

      if (Grammar .doubleQuotes .parse (this))
      {
         let value = "";

         while (Grammar .noDoubleQuotes .parse (this))
         {
            value += this .result [0];

            const m = value .match (/\\+$/);

            if (!m || m [0] .length % 2 === 0)
               break;

            Grammar .doubleQuotes .parse (this);

            value += '"';
         }

         if (Grammar .doubleQuotes .parse (this))
         {
            this .lines (value);

            this .value = _Fields_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .SFString .unescape (value);

            return true;
         }
      }

      return false;
   },
   sfboolValue (field)
   {
      if (this .bool ())
      {
         field .setValue (this .value);
         return true;
      }

      return false;
   },
   mfboolValue (field)
   {
      field .length = 0;

      if (this .bool ())
      {
         field .push (this .value);
         return true;
      }

      if (Grammar .OpenBracket .parse (this))
      {
         this .sfboolValues (field);

         if (Grammar .CloseBracket .parse (this))
            return true;

         throw new Error ("Expected ']'.");
      }

      return false;
   },
   sfboolValues (field)
   {
      const array = [ ];

      while (this .bool ())
         array .push (this .value);

      field .setValue (array);

      return field .length !== 0;
   },
   sfcolorValue (field)
   {
      const lastIndex = this .lastIndex;

      if (this .double ())
      {
         const r = this .value;

         if (this .double ())
         {
            const g = this .value;

            if (this .double ())
            {
               const b = this .value;

               field .r = r;
               field .g = g;
               field .b = b;

               return true;
            }
         }
      }

      this .lastIndex = lastIndex;

      this .comments ();

      if (Grammar .HTMLColor .parse (this))
      {
         const color = this .convertColor (this .result [0] .replace (/0x/i, "#"));

         field .r = color [0];
         field .g = color [1];
         field .b = color [2];

         return true;
      }

      return false;
   },
   mfcolorValue (field)
   {
      field .length = 0;

      if (this .sfcolorValue (this .Color3))
      {
         field .push (this .Color3);
         return true;
      }

      if (Grammar .OpenBracket .parse (this))
      {
         this .sfcolorValues (field);

         if (Grammar .CloseBracket .parse (this))
            return true;

         throw new Error ("Expected ']'.");
      }

      return false;
   },
   sfcolorValues (field)
   {
      const array = [ ];

      while (this .double ())
         array .push (this .value);

      field .setValue (array);

      return field .length !== 0;
   },
   sfcolorrgbaValue (field)
   {
      const lastIndex = this .lastIndex;

      if (this .double ())
      {
         const r = this .value;

         if (this .double ())
         {
            const g = this .value;

            if (this .double ())
            {
               const b = this .value;

               if (this .double ())
               {
                  const a = this .value;

                  field .r = r;
                  field .g = g;
                  field .b = b;
                  field .a = a;

                  return true;
               }
            }
         }
      }

      this .lastIndex = lastIndex;

      this .comments ();

      if (Grammar .HTMLColor .parse (this))
      {
         const color = this .convertColor (this .result [0] .replace (/0x/i, "#"));

         field .r = color [0];
         field .g = color [1];
         field .b = color [2];
         field .a = color [3];

         return true;
      }

      return false;
   },
   mfcolorrgbaValue (field)
   {
      field .length = 0;

      if (this .sfcolorrgbaValue (this .Color4))
      {
         field .push (this .Color4);
         return true;
      }

      if (Grammar .OpenBracket .parse (this))
      {
         this .sfcolorValues (field);

         if (Grammar .CloseBracket .parse (this))
            return true;

         throw new Error ("Expected ']'.");
      }

      return false;
   },
   sfdoubleValue (field)
   {
      if (this .double ())
      {
         field .setValue (this .fromUnit (field .getUnit (), this .value));
         return true;
      }

      return false;
   },
   mfdoubleValue (field)
   {
      field .length = 0;

      if (this .double ())
      {
         field .push (this .fromUnit (field .getUnit (), this .value));
         return true;
      }

      if (Grammar .OpenBracket .parse (this))
      {
         this .sfdoubleValues (field);

         if (Grammar .CloseBracket .parse (this))
            return true;

         throw new Error ("Expected ']'.");
      }

      return false;
   },
   sfdoubleValues (field)
   {
      const
         unit  = field .getUnit (),
         array = [ ];

      while (this .double ())
         array .push (this .fromUnit (unit, this .value));

      field .setValue (array);

      return field .length !== 0;
   },
   sfimageValue (field)
   {
      if (this .int32 ())
      {
         const width = this .value;

         if (this .int32 ())
         {
            const height = this .value;

            if (this .int32 ())
            {
               const
                  comp  = this .value,
                  size  = width * height,
                  array = [ ];

               for (let i = 0; i < size; ++ i)
               {
                  if (this .int32 ())
                  {
                     array .push (this .value);
                     continue;
                  }

                  return false;
               }

               field .width  = width;
               field .height = height;
               field .comp   = comp;
               field .array  = array;

               return true;
            }
         }
      }

      return false;
   },
   mfimageValue (field)
   {
      field .length = 0;

      if (this .sfimageValue (this .SFImage))
      {
         field .push (this .SFImage);
         return true;
      }

      if (Grammar .OpenBracket .parse (this))
      {
         this .sfimageValues (field);

         if (Grammar .CloseBracket .parse (this))
            return true;

         throw new Error ("Expected ']'.");
      }

      return false;
   },
   sfimageValues (field)
   {
      field .length = 0;

      const
         target = field .getTarget (),
         value  = this .SFImage;

      while (this .sfimageValue (value))
         target .push (value);

      return field .length !== 0;
   },
   sfint32Value (field)
   {
      if (this .int32 ())
      {
         field .setValue (this .value);
         return true;
      }

      return false;
   },
   mfint32Value (field)
   {
      field .length = 0;

      if (this .int32 ())
      {
         field .push (this .value);
         return true;
      }

      if (Grammar .OpenBracket .parse (this))
      {
         this .sfint32Values (field);

         if (Grammar .CloseBracket .parse (this))
            return true;

         throw new Error ("Expected ']'.");
      }

      return false;
   },
   sfint32Values (field)
   {
      const array = [ ];

      while (this .int32 ())
         array .push (this .value);

      field .setValue (array);

      return field .length !== 0;
   },
   sfmatrix3Value (field)
   {
      if (this .double ())
      {
         const m00 = this .value;

         if (this .double ())
         {
            const m01 = this .value;

            if (this .double ())
            {
               const m02 = this .value;

                  if (this .double ())
                  {
                     const m10 = this .value;

                     if (this .double ())
                     {
                        const m11 = this .value;

                        if (this .double ())
                        {
                           const m12 = this .value;

                           if (this .double ())
                           {
                              const m20 = this .value;

                              if (this .double ())
                              {
                                 const m21 = this .value;

                                 if (this .double ())
                                 {
                                    const m22 = this .value;

                                    field [0] = m00;
                                    field [1] = m01;
                                    field [2] = m02;
                                    field [3] = m10;
                                    field [4] = m11;
                                    field [5] = m12;
                                    field [6] = m20;
                                    field [7] = m21;
                                    field [8] = m22;

                                    return true;
                              }
                           }
                        }
                     }
                  }
               }
            }
         }
      }

      return false;
   },
   mfmatrix3Value (field)
   {
      field .length = 0;

      if (this .sfmatrix3Value (this .Matrix3))
      {
         field .push (this .Matrix3);
         return true;
      }

      if (Grammar .OpenBracket .parse (this))
      {
         this .sfmatrixValues (field);

         if (Grammar .CloseBracket .parse (this))
            return true;

         throw new Error ("Expected ']'.");
      }

      return false;
   },
   sfmatrixValues (field)
   {
      const array = [ ];

      while (this .double ())
         array .push (this .value);

      field .setValue (array);

      return field .length !== 0;
   },
   sfmatrix4Value (field)
   {
      if (this .double ())
      {
         const m00 = this .value;

         if (this .double ())
         {
            const m01 = this .value;

            if (this .double ())
            {
               const m02 = this .value;

               if (this .double ())
               {
                  const m03 = this .value;

                  if (this .double ())
                  {
                     const m10 = this .value;

                     if (this .double ())
                     {
                        const m11 = this .value;

                        if (this .double ())
                        {
                           const m12 = this .value;

                           if (this .double ())
                           {
                              const m13 = this .value;

                              if (this .double ())
                              {
                                 const m20 = this .value;

                                 if (this .double ())
                                 {
                                    const m21 = this .value;

                                    if (this .double ())
                                    {
                                       const m22 = this .value;

                                       if (this .double ())
                                       {
                                          const m23 = this .value;

                                          if (this .double ())
                                          {
                                             const m30 = this .value;

                                             if (this .double ())
                                             {
                                                const m31 = this .value;

                                                if (this .double ())
                                                {
                                                   const m32 = this .value;

                                                   if (this .double ())
                                                   {
                                                      const m33 = this .value;

                                                      field [ 0] = m00;
                                                      field [ 1] = m01;
                                                      field [ 2] = m02;
                                                      field [ 3] = m03;
                                                      field [ 4] = m10;
                                                      field [ 5] = m11;
                                                      field [ 6] = m12;
                                                      field [ 7] = m13;
                                                      field [ 8] = m20;
                                                      field [ 9] = m21;
                                                      field [10] = m22;
                                                      field [11] = m23;
                                                      field [12] = m30;
                                                      field [13] = m31;
                                                      field [14] = m32;
                                                      field [15] = m33;

                                                      return true;
                                                   }
                                                }
                                             }
                                          }
                                       }
                                    }
                                 }
                              }
                           }
                        }
                     }
                  }
               }
            }
         }
      }

      return false;
   },
   mfmatrix4Value (field)
   {
      field .length = 0;

      if (this .sfmatrix4Value (this .Matrix4))
      {
         field .push (this .Matrix4);
         return true;
      }

      if (Grammar .OpenBracket .parse (this))
      {
         this .sfmatrixValues (field);

         if (Grammar .CloseBracket .parse (this))
            return true;

         throw new Error ("Expected ']'.");
      }

      return false;
   },
   sfnodeValue (field)
   {
      const baseNode = this .nodeStatement ();

      if (baseNode !== false)
      {
         field .setValue (baseNode);
         return true;
      }

      return false;
   },
   mfnodeValue (field)
   {
      field .length = 0;

      const node = this .nodeStatement ();

      if (node !== false)
      {
         field .push (node);
         return true;
      }

      if (Grammar .OpenBracket .parse (this))
      {
         this .nodeStatements (field);

         if (Grammar .CloseBracket .parse (this))
            return true;

         throw new Error ("Expected ']'.");
      }

      return false;
   },
   nodeStatements (field)
   {
      this .statements (field);

      // let node = this .nodeStatement ();

      // while (node !== false)
      // {
      //    field .push (node);

      //    node = this .nodeStatement ();
      // }
   },
   sfrotationValue (field)
   {
      if (this .double ())
      {
         const x = this .value;

         if (this .double ())
         {
            const y = this .value;

            if (this .double ())
            {
               const z = this .value;

               if (this .double ())
               {
                  const angle = this .value;

                  field .x     = x;
                  field .y     = y;
                  field .z     = z;
                  field .angle = this .fromUnit ("angle", angle);

                  return true;
               }
            }
         }
      }

      return false;
   },
   mfrotationValue (field)
   {
      field .length = 0;

      if (this .sfrotationValue (this .Rotation4))
      {
         field .push (this .Rotation4);
         return true;
      }

      if (Grammar .OpenBracket .parse (this))
      {
         this .sfrotationValues (field);

         if (Grammar .CloseBracket .parse (this))
            return true;

         throw new Error ("Expected ']'.");
      }

      return false;
   },
   sfrotationValues (field)
   {
      field .length = 0;

      const
         target = field .getTarget (),
         value  = this .Rotation4;

      while (this .sfrotationValue (value))
         target .push (value);

      return field .length !== 0;
   },
   sfstringValue (field)
   {
      if (this .string ())
      {
         field .setValue (this .value);
         return true;
      }

      return false;
   },
   mfstringValue (field)
   {
      field .length = 0;

      if (this .string ())
      {
         field .push (this .value);
         return true;
      }

      if (Grammar .OpenBracket .parse (this))
      {
         this .sfstringValues (field);

         if (Grammar .CloseBracket .parse (this))
            return true;

         throw new Error ("Expected ']'.");
      }

      return false;
   },
   sfstringValues (field)
   {
      const array = [ ];

      while (this .string ())
         array .push (this .value);

      field .setValue (array);

      return field .length !== 0;
   },
   sfvec2Value (field, unit)
   {
      if (this .double ())
      {
         const x = this .value;

         if (this .double ())
         {
            const y = this .value;

            field .x = this .fromUnit (unit, x);
            field .y = this .fromUnit (unit, y);

            return true;
         }
      }

      return false;
   },
   mfvec2Value (field)
   {
      field .length = 0;

      if (this .sfvec2Value (this .Vector2, field .getUnit ()))
      {
         field .push (this .Vector2);
         return true;
      }

      if (Grammar .OpenBracket .parse (this))
      {
         this .sfvecValues (field);

         if (Grammar .CloseBracket .parse (this))
            return true;

         throw new Error ("Expected ']'.");
      }

      return false;
   },
   sfvecValues (field)
   {
      const
         unit  = field .getUnit (),
         array = [ ];

      while (this .double ())
         array .push (this .fromUnit (unit, this .value));

      field .setValue (array);

      return field .length !== 0;
   },
   sfvec3Value (field, unit)
   {
      if (this .double ())
      {
         const x = this .value;

         if (this .double ())
         {
            const y = this .value;

            if (this .double ())
            {
               const z = this .value;

               field .x = this .fromUnit (unit, x);
               field .y = this .fromUnit (unit, y);
               field .z = this .fromUnit (unit, z);

               return true;
            }
         }
      }

      return false;
   },
   mfvec3Value (field)
   {
      field .length = 0;

      if (this .sfvec3Value (this .Vector3, field .getUnit ()))
      {
         field .push (this .Vector3);
         return true;
      }

      if (Grammar .OpenBracket .parse (this))
      {
         this .sfvecValues (field);

         if (Grammar .CloseBracket .parse (this))
            return true;

         throw new Error ("Expected ']'.");
      }

      return false;
   },
   sfvec4Value (field, unit)
   {
      if (this .double ())
      {
         const x = this .value;

         if (this .double ())
         {
            const y = this .value;

            if (this .double ())
            {
               const z = this .value;

               if (this .double ())
               {
                  const w = this .value;

                  field .x = this .fromUnit (unit, x);
                  field .y = this .fromUnit (unit, y);
                  field .z = this .fromUnit (unit, z);
                  field .w = this .fromUnit (unit, w);

                  return true;
               }
            }
         }
      }

      return false;
   },
   mfvec4Value (field)
   {
      field .length = 0;

      if (this .sfvec4Value (this .Vector4, field .getUnit ()))
      {
         field .push (this .Vector4);
         return true;
      }

      if (Grammar .OpenBracket .parse (this))
      {
         this .sfvecValues (field);

         if (Grammar .CloseBracket .parse (this))
            return true;

         throw new Error ("Expected ']'.");
      }

      return false;
   },
   unknownValue ()
   {
      try
      {
         ++ this .unknownLevel;

         this .comments ();

         if (Grammar .IS .parse (this))
         {
            if (this .isInsideProtoDeclaration ())
            {
               if (this .Id ())
                  return true;
            }
         }

         if (this .mfunknownValue ())
            return true;

         return false;
      }
      finally
      {
         -- this .unknownLevel;
      }
   },
   sfunknownValue ()
   {
      if (this .sfboolValue (new _Fields_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .SFBool ()))
         return true;

      if (this .sfdoubleValues (new _Fields_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .MFFloat ()))
         return true;

      if (this .sfstringValue (new _Fields_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .SFString ()))
         return true;

      if (this .sfnodeValue (new _Fields_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .SFNode ()))
         return true;

      return false;
   },
   mfunknownValue ()
   {
      if (this .sfunknownValue ())
         return true;

      if (Grammar .OpenBracket .parse (this))
      {
         this .sfunknownValues ();

         if (Grammar .CloseBracket .parse (this))
            return true;

         throw new Error ("Expected ']'.");
      }

      return false;
   },
   sfunknownValues ()
   {
      while (this .sfunknownValue ())
         ;
   },
   accessTypeToString (accessType)
   {
      switch (accessType)
      {
         case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .initializeOnly:
            return "initializeOnly";
         case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .inputOnly:
            return "inputOnly";
         case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .outputOnly:
            return "outputOnly";
         case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .inputOutput:
            return "inputOutput";
      }
   },
});

Object .assign (VRMLParser .prototype,
{
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .SFBool]:      VRMLParser .prototype .sfboolValue,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .SFColor]:     VRMLParser .prototype .sfcolorValue,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .SFColorRGBA]: VRMLParser .prototype .sfcolorrgbaValue,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .SFDouble]:    VRMLParser .prototype .sfdoubleValue,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .SFFloat]:     VRMLParser .prototype .sfdoubleValue,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .SFImage]:     VRMLParser .prototype .sfimageValue,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .SFInt32]:     VRMLParser .prototype .sfint32Value,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .SFMatrix3f]:  VRMLParser .prototype .sfmatrix3Value,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .SFMatrix3d]:  VRMLParser .prototype .sfmatrix3Value,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .SFMatrix4f]:  VRMLParser .prototype .sfmatrix4Value,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .SFMatrix4d]:  VRMLParser .prototype .sfmatrix4Value,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .SFNode]:      VRMLParser .prototype .sfnodeValue,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .SFRotation]:  VRMLParser .prototype .sfrotationValue,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .SFString]:    VRMLParser .prototype .sfstringValue,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .SFTime]:      VRMLParser .prototype .sfdoubleValue,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .SFVec2d]:     VRMLParser .prototype .sfvec2Value,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .SFVec2f]:     VRMLParser .prototype .sfvec2Value,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .SFVec3d]:     VRMLParser .prototype .sfvec3Value,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .SFVec3f]:     VRMLParser .prototype .sfvec3Value,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .SFVec4d]:     VRMLParser .prototype .sfvec4Value,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .SFVec4f]:     VRMLParser .prototype .sfvec4Value,

   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .VrmlMatrix]:  VRMLParser .prototype .sfmatrix4Value,

   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .MFBool]:      VRMLParser .prototype .mfboolValue,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .MFColor]:     VRMLParser .prototype .mfcolorValue,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .MFColorRGBA]: VRMLParser .prototype .mfcolorrgbaValue,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .MFDouble]:    VRMLParser .prototype .mfdoubleValue,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .MFFloat]:     VRMLParser .prototype .mfdoubleValue,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .MFImage]:     VRMLParser .prototype .mfimageValue,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .MFInt32]:     VRMLParser .prototype .mfint32Value,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .MFMatrix3d]:  VRMLParser .prototype .mfmatrix3Value,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .MFMatrix3f]:  VRMLParser .prototype .mfmatrix3Value,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .MFMatrix4d]:  VRMLParser .prototype .mfmatrix4Value,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .MFMatrix4f]:  VRMLParser .prototype .mfmatrix4Value,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .MFNode]:      VRMLParser .prototype .mfnodeValue,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .MFRotation]:  VRMLParser .prototype .mfrotationValue,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .MFString]:    VRMLParser .prototype .mfstringValue,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .MFTime]:      VRMLParser .prototype .mfdoubleValue,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .MFVec2d]:     VRMLParser .prototype .mfvec2Value,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .MFVec2f]:     VRMLParser .prototype .mfvec2Value,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .MFVec3d]:     VRMLParser .prototype .mfvec3Value,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .MFVec3f]:     VRMLParser .prototype .mfvec3Value,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .MFVec4d]:     VRMLParser .prototype .mfvec4Value,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .MFVec4f]:     VRMLParser .prototype .mfvec4Value,
});

_Base_X3DField_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .prototype .fromVRMLString = function (string, scene)
{
   const parser = new VRMLParser (scene);

   parser .setUnits (!!scene);
   parser .setInput (string);

   if (!parser .fieldValue (this))
      throw new Error (`Couldn't read value for field '${this .getName ()}'.`);

   parser .setupNodes ();
};

const __default__ = VRMLParser;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_18__/* ["default"] */ .A .add ("VRMLParser", __default__));

/***/ }),

/***/ 4383:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Fields_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(564);
/* harmony import */ var _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(8415);
/* harmony import */ var _X3DTextureNode_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(5075);
/* harmony import */ var _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(8899);
/* harmony import */ var _Base_X3DCast_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(4667);
/* harmony import */ var _standard_Math_Numbers_Matrix4_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(1048);
/* harmony import */ var _standard_Math_Algorithm_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(4559);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(6707);








function X3DSingleTextureNode (executionContext)
{
   _X3DTextureNode_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .call (this, executionContext);

   this .addType (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .X3DSingleTextureNode);

   this .addChildObjects (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .outputOnly, "linear", new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFBool ())

   this .matrix = new Float32Array (_standard_Math_Numbers_Matrix4_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .IDENTITY);
}

Object .assign (Object .setPrototypeOf (X3DSingleTextureNode .prototype, _X3DTextureNode_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .prototype),
{
   initialize ()
   {
      _X3DTextureNode_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .prototype .initialize .call (this);

      this ._textureProperties .addInterest ("set_textureProperties__", this, true);

      const gl = this .getBrowser () .getContext ();

      this .texture = gl .createTexture ();

      this .set_textureProperties__ (false);
   },
   getCount ()
   {
      return 1;
   },
   getTextureTypeString ()
   {
      switch (this .getTextureType ())
      {
         case 1:                // ImageTexture, MovieTexture (flipY)
         case 2: return "2D";   // PixelTexture
         case 3: return "3D";   // X3DTexture3DNode
         case 4: return "CUBE"; // X3DEnvironmentTextureNode
      }
   },
   getTexture ()
   {
      return this .texture;
   },
   setTexture (texture)
   {
      const gl = this .getBrowser () .getContext ();

      gl .deleteTexture (this .texture);

      this .texture = texture;

      this .addNodeEvent ();
   },
   isLinear ()
   {
      return this ._linear .getValue ();
   },
   setLinear (value)
   {
      if (!!value !== this ._linear .getValue ())
         this ._linear = value;
   },
   canMipMaps ()
   {
      return this .mipMaps;
   },
   setMipMaps (value)
   {
      this .mipMaps = value;
   },
   getMatrix ()
   {
      // Normally the identity matrix or a flipY matrix.
      return this .matrix;
   },
   isImageTransparent (data)
   {
      const length = data .length;

      for (let i = 3; i < length; i += 4)
      {
         if (data [i] !== 255)
            return true;
      }

      return false;
   },
   set_textureProperties__ (update)
   {
      if (this .texturePropertiesNode)
         this .texturePropertiesNode .removeInterest ("updateTextureParameters", this);

      this .texturePropertiesNode = (0,_Base_X3DCast_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A) (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .TextureProperties, this ._textureProperties)
         ?? this .getBrowser () .getDefaultTextureProperties ();

      this .texturePropertiesNode .addInterest ("updateTextureParameters", this);

      if (update)
         this .updateTextureParameters ();
   },
   updateTextureParameters (target, haveTextureProperties, textureProperties, width, height, repeatS, repeatT, repeatR)
   {
      const
         browser = this .getBrowser (),
         gl      = browser .getContext ();

      gl .bindTexture (target, this .getTexture ());

      if (!haveTextureProperties && Math .max (width, height) < browser .getMinTextureSize ())
      {
         // Don't generate MipMaps.
         gl .texParameteri (target, gl .TEXTURE_MIN_FILTER, gl .NEAREST);
         gl .texParameteri (target, gl .TEXTURE_MAG_FILTER, gl .NEAREST);
      }
      else if (this .canMipMaps () && textureProperties ._generateMipMaps .getValue ())
      {
         // Can MipMaps and wants MipMaps.
         gl .generateMipmap (target);

         gl .texParameteri (target, gl .TEXTURE_MIN_FILTER, gl [textureProperties .getMinificationFilter ()]);
         gl .texParameteri (target, gl .TEXTURE_MAG_FILTER, gl [textureProperties .getMagnificationFilter ()]);
      }
      else
      {
         // No MipMaps.
         gl .texParameteri (target, gl .TEXTURE_MIN_FILTER, gl [textureProperties .getMinificationFilter (false)]);
         gl .texParameteri (target, gl .TEXTURE_MAG_FILTER, gl [textureProperties .getMagnificationFilter (false)]);
      }

      if (haveTextureProperties)
      {
         gl .texParameteri (target, gl .TEXTURE_WRAP_S, gl [textureProperties .getBoundaryModeS ()]);
         gl .texParameteri (target, gl .TEXTURE_WRAP_T, gl [textureProperties .getBoundaryModeT ()]);
         gl .texParameteri (target, gl .TEXTURE_WRAP_R, gl [textureProperties .getBoundaryModeR ()]);
      }
      else
      {
         gl .texParameteri (target, gl .TEXTURE_WRAP_S, repeatS ? gl .REPEAT : gl .CLAMP_TO_EDGE);
         gl .texParameteri (target, gl .TEXTURE_WRAP_T, repeatT ? gl .REPEAT : gl .CLAMP_TO_EDGE);
         gl .texParameteri (target, gl .TEXTURE_WRAP_R, repeatR ? gl .REPEAT : gl .CLAMP_TO_EDGE);
      }

      //gl .texParameterfv (target, gl .TEXTURE_BORDER_COLOR, textureProperties ._borderColor .getValue ());
      //gl .texParameterf  (target, gl .TEXTURE_PRIORITY,     textureProperties ._texturePriority .getValue ());

      const ext = browser .getAnisotropicExtension ();

      if (ext)
      {
         const max = gl .getParameter (ext .MAX_TEXTURE_MAX_ANISOTROPY_EXT);

         gl .texParameterf (target, ext .TEXTURE_MAX_ANISOTROPY_EXT, _standard_Math_Algorithm_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .clamp (textureProperties ._anisotropicDegree .getValue (), 0, max));
      }
   },
   getTextureBits ()
   {
      return (this .isLinear () << 3) | this .getTextureType ();
   },
   updateTextureBits (textureBits, channel = 0)
   {
      textureBits .add (channel * 4, this .getTextureBits ());
   },
   getShaderOptions (options, name = 0, ext = false)
   {
      if (typeof name === "number")
      {
         options .push (`X3D_TEXTURE_${name}_${this .getTextureTypeString ()}`);

         if (this .getTextureType () === 1)
            options .push (`X3D_TEXTURE_${name}_FLIP_Y`);

         if (this .isLinear ())
            options .push (`X3D_TEXTURE_${name}_LINEAR`);
      }
      else
      {
         ext = ext ? "_EXT" : "";

         options .push (`X3D_${name}_TEXTURE${ext}`, `X3D_${name}_TEXTURE${ext}_${this .getTextureTypeString ()}`);

         if (this .getTextureType () === 1)
            options .push (`X3D_${name}_TEXTURE${ext}_FLIP_Y`);

         if (this .isLinear ())
            options .push (`X3D_${name}_TEXTURE${ext}_LINEAR`);
      }
   },
   setNamedShaderUniforms (gl, uniformStruct, mapping, textureTransformMapping, textureCoordinateMapping)
   {
      this .setShaderUniforms (gl, uniformStruct);

      gl .uniform1i (uniformStruct .textureTransformMapping,  textureTransformMapping  .get (mapping) ?? 0);
      gl .uniform1i (uniformStruct .textureCoordinateMapping, textureCoordinateMapping .get (mapping) ?? 0);
   },
});

Object .defineProperties (X3DSingleTextureNode, _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .getStaticProperties ("X3DSingleTextureNode", "Texturing", 1));

const __default__ = X3DSingleTextureNode;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .add ("X3DSingleTextureNode", __default__));

/***/ }),

/***/ 4471:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _x_ite_Namespace_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6707);
function Complex (real = 0, imag = 0)
{
   this .real = real;
   this .imag = imag;
}

Object .assign (Complex .prototype,
{
   *[Symbol .iterator] ()
   {
      yield this .real;
      yield this .imag;
   },
   copy ()
   {
      const copy = Object .create (Complex .prototype);
      copy .real = this .real;
      copy .imag = this .imag;
      return copy;
   },
   assign (complex)
   {
      this .real = complex .real;
      this .imag = complex .imag;
      return this;
   },
   equals (complex)
   {
      return this .real === complex .real &&
             this .imag === complex .imag;
   },
   set (real = 0, imag = 0)
   {
      this .real = real;
      this .imag = imag;
      return this;
   },
   setPolar (magnitude, angle)
   {
      this .real = magnitude * Math .cos (angle);
      this .imag = magnitude * Math .sin (angle);
      return this;
   },
   conjugate ()
   {
      this .imag = -this .imag;
      return this;
   },
   negate ()
   {
      this .real = -this .real;
      this .imag = -this .imag;
      return this;
   },
   inverse ()
   {
      const d = this .real * this .real + this .imag * this .imag;

      this .real /=  d;
      this .imag /= -d;
      return this;
   },
   add (value)
   {
      this .real += value .real;
      this .imag += value .imag;
      return this;
   },
   subtract (value)
   {
      this .real -= value .real;
      this .imag -= value .imag;
      return this;
   },
   multiply (value)
   {
      this .real *= value;
      this .imag *= value;
      return this;
   },
   multComp (value)
   {
      const
         { real: ar, imag: ai } = this,
         { real: br, imag: bi } = value;

      this .real = ar * br - ai * bi;
      this .imag = ar * bi + ai * br;
      return this;
   },
   divide (value)
   {
      this .real /= value;
      this .imag /= value;
      return this;
   },
   divComp (value)
   {
      const
         { real: ar, imag: ai } = this,
         { real: br, imag: bi } = value,
         d = br * br + bi * bi;

      this .real = (ar * br + ai * bi) / d;
      this .imag = (ai * br - ar * bi) / d;
      return this;
   },
   toString ()
   {
      let string = "";

      string += this .real;

      if (this .imag < 0)
      {
         string += this .imag;
         string += "i";
      }
      else if (this .imag > 0)
      {
         string += "+";
         string += this .imag;
         string += "i";
      }

      return string;
   },
});

for (const key of Object .keys (Complex .prototype))
   Object .defineProperty (Complex .prototype, key, { enumerable: false });

Object .defineProperties (Complex .prototype,
{
   length: { value: 2 },
   0:
   {
      get ()
      {
         return this .real;
      },
      set (value)
      {
         this .real = value;
      },
   },
   1:
   {
      get ()
      {
         return this .imag;
      },
      set (value)
      {
         this .imag = value;
      },
   },
   magnitude:
   {
      get ()
      {
         if (this .real)
         {
            if (this .imag)
               return Math .hypot (this .real, this .imag);

            return Math .abs (this .real);
         }

         return Math .abs (this .imag);
      },
      set (magnitude)
      {
         this .setPolar (magnitude, this .angle);
      },
   },
   angle:
   {
      get ()
      {
         return Math .atan2 (this .imag, this .real);
      },
      set (angle)
      {
         this .setPolar (this .magnitude, angle);
      },
   },
});

Object .assign (Complex,
{
   Polar (magnitude, angle)
   {
      return Object .create (Complex .prototype) .setPolar (magnitude, angle);
   },
});

const __default__ = Complex;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_x_ite_Namespace_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .add ("Complex", __default__));

/***/ }),

/***/ 4503:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Base_X3DObject_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(3078);
/* harmony import */ var _Browser_Networking_URLs_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(5991);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(6707);



function ComponentInfo (name, level, title, providerURL, external = false, dependencies = [ ])
{
   Object .defineProperties (this,
   {
      name: { value: name, enumerable: true },
      level: { value: level, enumerable: true },
      title: { value: title, enumerable: true },
      providerURL: { value: providerURL || _Browser_Networking_URLs_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .getProviderURL (external && name), enumerable: true },
      external: { value: external },
      dependencies: { value: dependencies },
   });
}

Object .assign (Object .setPrototypeOf (ComponentInfo .prototype, _Base_X3DObject_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .prototype),
{
   toVRMLStream (generator)
   {
      generator .Indent ();
      generator .string += "COMPONENT";
      generator .Space ();
      generator .string += this .name;
      generator .TidySpace ();
      generator .string += ":";
      generator .TidySpace ();
      generator .string += this .level;
   },
   toXMLStream (generator)
   {
      generator .openTag ("component");
      generator .attribute ("name",  this .name);
      generator .attribute ("level", this .level);
      generator .closeTag ("component");
   },
   toJSONStream (generator)
   {
      generator .beginObject ("", false);
      generator .stringProperty ("@name", this .name, false);
      generator .numberProperty ("@level", this .level);
      generator .endObject ();
   },
});

for (const key of Object .keys (ComponentInfo .prototype))
   Object .defineProperty (ComponentInfo .prototype, key, { enumerable: false });

Object .defineProperties (ComponentInfo,
{
   typeName:
   {
      value: "ComponentInfo",
      enumerable: true,
   },
});

Object .defineProperties (ComponentInfo .prototype,
{
   providerUrl: // legacy
   {
      get: function () { return this .providerURL; },
   },
});

const __default__ = ComponentInfo;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .add ("ComponentInfo", __default__));

/***/ }),

/***/ 4548:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Base_X3DInfoArray_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(4635);
/* harmony import */ var _X3DImportedNode_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(7627);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(6707);



function ImportedNodesArray (values = [ ])
{
   return _Base_X3DInfoArray_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .call (this, Array .from (values, value => [value .getImportedName (), value]), _X3DImportedNode_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A);
}

Object .setPrototypeOf (ImportedNodesArray .prototype, _Base_X3DInfoArray_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .prototype);

for (const key of Object .keys (ImportedNodesArray .prototype))
   Object .defineProperty (ImportedNodesArray .prototype, key, { enumerable: false });

Object .defineProperties (ImportedNodesArray,
{
   typeName:
   {
      value: "ImportedNodesArray",
      enumerable: true,
   },
});

const __default__ = ImportedNodesArray;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .add ("ImportedNodesArray", __default__));

/***/ }),

/***/ 4559:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _x_ite_Namespace_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6707);
const Algorithm =
{
   radians (value)
   {
      // Convert degrees to radians.
      return value * (Math .PI / 180);
   },
   degrees (value)
   {
      // Convert radians to degrees.
      return value * (180 / Math .PI);
   },
   random (min, max)
   {
      return min + Math .random () * (max - min);
   },
   fract (value)
   {
      return value % 1;
   },
   clamp (value, min, max)
   {
      // https://registry.khronos.org/OpenGL-Refpages/gl4/html/clamp.xhtml
      return Math .min (Math .max (value, min), max);
   },
   interval (value, low, high)
   {
      if (value >= high)
         return ((value - low) % (high - low)) + low;

      if (value < low)
         return ((value - high) % (high - low)) + high;

      return value;
   },
   project (value, fromLow, fromHigh, toLow, toHigh)
   {
      return toLow + ((value - fromLow) / (fromHigh - fromLow)) * (toHigh - toLow);
   },
   roundToMultiple (value, multiple)
   {
      return Math .ceil (value / multiple) * multiple;
   },
   lerp (source, destination, t)
   {
      return source + t * (destination - source);
   },
   slerp (source, destination, t, short = true)
   {
      let cosom = source .dot (destination);

      // if (cosom <= -1) ... vectors are inverse colinear.
      // ; // This case is not handled.

      if (short && cosom < 0)
      {
         // Reverse signs so we travel the short way round.
         cosom = -cosom;
         destination .negate ();
      }

      if (cosom >= 1) // Both normal vectors are equal.
         return source;

      const
         omega  = Math .acos (cosom),
         sinom  = Math .sin  (omega),
         scale0 = Math .sin ((1 - t) * omega) / sinom,
         scale1 = Math .sin (t * omega) / sinom;

      source .x = source .x * scale0 + destination .x * scale1;
      source .y = source .y * scale0 + destination .y * scale1;
      source .z = source .z * scale0 + destination .z * scale1;
      source .w = source .w * scale0 + destination .w * scale1;

      return source;
   },
   simpleSlerp (source, destination, t)
   {
      return this .slerp (source, destination, t, false);
   },
   isPowerOfTwo (n)
   {
      return ((n - 1) & n) === 0;
   },
   nextPowerOfTwo (n)
   {
      ///  Returns the next power of two of @a n. If n is a power of two, n is returned.

      if (Algorithm .isPowerOfTwo (n))
         return n;

      return 1 << (32 - Math .clz32 (n));
   },
   bitCount (n)
   {
      n = n - ((n >>> 1) & 0x55555555);
      n = (n & 0x33333333) + ((n >>> 2) & 0x33333333);
      return ((n + (n >>> 4) & 0xF0F0F0F) * 0x1010101) >>> 24;
   },
   cmp (lhs, rhs)
   {
      return lhs > rhs ? 1 : lhs < rhs ? -1 : 0;
   },
   less (lhs, rhs)
   {
      return lhs < rhs;
   },
   greater (lhs, rhs)
   {
      return lhs > rhs;
   },
   lowerBound (array, first, last, value, comp = Algorithm.less)
   {
      // https://en.cppreference.com/w/cpp/algorithm/lower_bound

      let
         index = 0,
         step  = 0,
         count = last - first;

      while (count > 0)
      {
         step  = count >>> 1;
         index = first + step;

         if (comp (array [index], value))
         {
            first  = ++ index;
            count -= step + 1;
         }
         else
         {
            count = step;
         }
      }

      return first;
   },
   upperBound (array, first, last, value, comp = Algorithm.less)
   {
      // https://en.cppreference.com/w/cpp/algorithm/upper_bound

      let
         index = 0,
         step  = 0,
         count = last - first;

      while (count > 0)
      {
         step  = count >>> 1;
         index = first + step;

         if (comp (value, array [index]))
         {
            count = step;
         }
         else
         {
            first  = ++ index;
            count -= step + 1;
         }
      }

      return first;
   },
};

const __default__ = Algorithm;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_x_ite_Namespace_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .add ("Algorithm", __default__));

/***/ }),

/***/ 4635:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _X3DChildObject_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(7503);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(6707);


const
   _array     = Symbol (),
   _index     = Symbol (),
   _valueType = Symbol ();

const handler =
{
   get (target, key)
   {
      const value = target [key];

      if (value !== undefined)
         return value;

      if (typeof key === "string")
      {
         const index = +key;

         if (Number .isInteger (index))
            return target [_array] [index];

         return;
      }
   },
   set (target, key, value)
   {
      if (target [key] === undefined)
         return false;

      target [key] = value;
      return true;
   },
   has (target, key)
   {
      if (Number .isInteger (+key))
         return key < target [_array] .length;

      return key in target;
   },
   ownKeys (target)
   {
      return Object .keys (target [_array]);
   },
   getOwnPropertyDescriptor (target, key)
   {
      if (typeof key !== "string")
         return;

      const index = +key;

      if (Number .isInteger (index) && index < target [_array] .length)
      {
         const propertyDescriptor = Object .getOwnPropertyDescriptor (target [_array], key);

         if (propertyDescriptor)
            propertyDescriptor .writable = false;

         return propertyDescriptor;
      }
   },
};

function X3DInfoArray (values, valueType)
{
   const proxy = new Proxy (this, handler);

   _X3DChildObject_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .call (this);

   this [_array]     = [ ];
   this [_index]     = new Map ();
   this [_valueType] = valueType;

   for (const [key, value] of values)
      this .add (key, value);

   return proxy;
}

Object .assign (Object .setPrototypeOf (X3DInfoArray .prototype, _X3DChildObject_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .prototype),
{
   *[Symbol .iterator] ()
   {
      yield* this [_array];
   },
   copy ()
   {
      const copy = new (this .constructor) ();

      copy .assign (this);

      return copy;
   },
   clear ()
   {
      this [_array] .length = 0;
      this [_index] .clear ();

      this .addEvent ();
   },
   assign (array)
   {
      if (!(array instanceof this .constructor))
         throw new Error ("Couldn't assign info array, wrong type.");

      this [_array] = Array .from (array [_array]);
      this [_index] = new Map (array [_index]);

      this .addEvent ();
   },
   equals (array)
   {
      const
         a      = this [_array],
         b      = array [_array],
         length = a .length;

      if (a === b)
         return true;

      if (length !== b .length)
         return false;

      for (let i = 0; i < length; ++ i)
      {
         if (a [i] !== b [i])
            return false;
      }

      return true;
   },
   has (key)
   {
      return this [_index] .has (key);
   },
   get (key)
   {
      return this [_index] .get (key);
   },
   add (key, value)
   {
      if (this [_index] .has (key))
         throw new Error (`Couldn't add value to ${this .getTypeName ()}, key '${key}' already exists.`);

      if (!(value instanceof this [_valueType]))
         throw new Error (`Couldn't add value to ${this .getTypeName ()}, value for key '${key}' has wrong type.`);

      this [_array] .push (value);
      this [_index] .set (key, value);

      this .addEvent ();
   },
   alias (alias, value)
   {
      this [_index] .set (alias, value);

      this .addEvent ();
   },
   update (oldKey, newKey, value)
   {
      // TODO: update alias.

      if (!(value instanceof this [_valueType]))
         throw new Error (`Couldn't update value of ${this .getTypeName ()}, value for key '${key}' has wrong type.`);

      const oldValue = this [_index] .get (oldKey);

      if (oldKey !== newKey)
         this .remove (newKey);

      this [_index] .delete (oldKey);
      this [_index] .set (newKey, value);

      if (oldValue !== undefined)
      {
         const index = this [_array] .indexOf (oldValue);

         if (index > -1)
            this [_array] [index] = value;
      }
      else
      {
         this [_array] .push (value);
      }

      this .addEvent ();
   },
   remove (key)
   {
      // TODO: remove alias.

      const value = this [_index] .get (key);

      if (value === undefined)
         return;

      const index = this [_array] .indexOf (value);

      this [_index] .delete (key);

      if (index > -1)
         this [_array] .splice (index, 1);

      this .addEvent ();
   },
   at: Array .prototype .at,
   // concat: Array .prototype .concat,
   // copyWithin: Array.prototype.copyWithin,
   entries: Array .prototype .entries,
   every: Array .prototype .every,
   // fill: Array .prototype .fill,
   filter (callbackFn, thisArg)
   {
      return new (this .constructor) (Array .prototype .filter .call (this, callbackFn, thisArg));
   },
   find: Array .prototype .find,
   findIndex: Array .prototype .findIndex,
   findLast: Array .prototype .findLast,
   findLastIndex: Array .prototype .findLastIndex,
   flat: Array .prototype .flat,
   flatMap: Array .prototype .flatMap,
   forEach: Array .prototype .forEach,
   includes: Array .prototype .includes,
   indexOf: Array .prototype .indexOf,
   join: Array .prototype .join,
   keys: Array .prototype .keys,
   lastIndexOf: Array .prototype .lastIndexOf,
   map (callbackFn, thisArg)
   {
      return new (this .constructor) (Array .prototype .map .call (this, callbackFn, thisArg));
   },
   reduce: Array .prototype .reduce,
   reduceRight: Array .prototype .reduceRight,
   // reverse: Array .prototype .reverse,
   slice (start, end)
   {
      return new (this .constructor) (Array .prototype .slice .call (this, start, end));
   },
   some: Array .prototype .some,
   // sort: Array .prototype .sort,
   toReversed ()
   {
      return new (this .constructor) ([... this] .reverse ());
   },
   toSorted (compareFn)
   {
      return new (this .constructor) ([... this] .sort (compareFn));
   },
   toSpliced (start, deleteCount, ... insertValues)
   {
      const array = [... this];

      array .splice (start, deleteCount, ... insertValues)

      return new (this .constructor) (array);
   },
   values: Array .prototype .values,
   with (index, value)
   {
      const array = [... this];

      array [index] = value;

      return new (this .constructor) (array);
   },
   toVRMLStream (generator)
   {
      const proto = this .getTypeName () .includes ("Proto");

      for (const value of this [_array])
      {
         try
         {
            value .toVRMLStream (generator);

            generator .Break ();

            if (proto)
               generator .TidyBreak ();
         }
         catch (error)
         {
            // console .error (error);
         }
      }
   },
   toXMLStream (generator)
   {
      for (const value of this [_array])
      {
         try
         {
            value .toXMLStream (generator);

            generator .TidyBreak ();
         }
         catch (error)
         {
            // console .error (error);
         }
      }
   },
   toJSONStream (generator, comma = false)
   {
      for (const value of this [_array])
      {
         try
         {
            if (comma)
               generator .string += ',';

            value .toJSONStream (generator, true);

            comma = true;
         }
         catch
         {
            generator .RemoveComma ();
         }
      }

      return comma;
   },
});

for (const key of Object .keys (X3DInfoArray .prototype))
   Object .defineProperty (X3DInfoArray .prototype, key, { enumerable: false });

Object .defineProperties (X3DInfoArray .prototype,
{
   length:
   {
      get () { return this [_array] .length; },
   },
});

const __default__ = X3DInfoArray;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .add ("X3DInfoArray", __default__));

/***/ }),

/***/ 4666:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Fields_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(564);
/* harmony import */ var _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(8415);
/* harmony import */ var _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(8899);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(6707);




const
   _cache                   = Symbol (),
   _autoRefreshStartTime    = Symbol (),
   _autoRefreshCompleteTime = Symbol (),
   _autoRefreshId           = Symbol ();

function X3DUrlObject (executionContext)
{
   this .addType (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .X3DUrlObject);

   this .addChildObjects (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .outputOnly, "loadState", new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFInt32 (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .NOT_STARTED_STATE),
                          _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .outputOnly, "loadData",  new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFTime ());

   this [_cache]                = true;
   this [_autoRefreshStartTime] = Date .now ();
}

Object .assign (X3DUrlObject .prototype,
{
   initialize ()
   {
      this .getLive () .addInterest ("set_live__", this);

      this ._load                 .addInterest ("set_load__",        this);
      this ._url                  .addInterest ("set_url__",         this);
      this ._loadData             .addInterest ("loadData",          this);
      this ._autoRefresh          .addInterest ("set_autoRefresh__", this);
      this ._autoRefreshTimeLimit .addInterest ("set_autoRefresh__", this);
   },
   getAllowEmptyUrl ()
   {
      return false;
   },
   setLoadState (value, notify = true)
   {
      this ._loadState = value;

      switch (value)
      {
         case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .COMPLETE_STATE:
         case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .FAILED_STATE:
         {
            this [_autoRefreshCompleteTime] = Date .now ();
            this .setAutoRefreshTimer (Math .max (this ._autoRefresh .getValue (), 0));
            break;
         }
      }

      if (!notify)
         return;

      switch (value)
      {
         case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .NOT_STARTED_STATE:
            break;
         case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .IN_PROGRESS_STATE:
         {
            this .getScene () .addLoadingObject (this);
            break;
         }
         case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .COMPLETE_STATE:
         case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .FAILED_STATE:
         {
            this .getScene () .removeLoadingObject (this);
            break;
         }
      }
   },
   checkLoadState ()
   {
      return this ._loadState .getValue ();
   },
   getLoadState ()
   {
      return this ._loadState;
   },
   setCache (value)
   {
      this [_cache] = value;
   },
   getCache ()
   {
      return this [_cache] && this .getBrowser () .getBrowserOption ("Cache");
   },
   async requestImmediateLoad (cache = true)
   {
      switch (this .checkLoadState ())
      {
         case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .IN_PROGRESS_STATE:
         {
            await this .loading ();
            return;
         }
         case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .COMPLETE_STATE:
         {
            return;
         }
         case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .FAILED_STATE:
         {
            throw new Error (`Failed loading ${this .getTypeName ()}.`);
         }
      }

      const browser = this .getBrowser ();

      if (!browser .getBrowserOption ("LoadUrlObjects") && this .getExecutionContext () !== browser .getPrivateScene ())
         return;

      if (!this ._load .getValue ())
         throw new Error (`${this .getTypeName ()}.load is false.`);

      if (this ._url .length === 0 && !this .getAllowEmptyUrl ())
      {
         this .unloadData ();
         return;
      }

      this .setCache (cache);
      this .setLoadState (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .IN_PROGRESS_STATE);

      if (this .isInitialized ())
         // Buffer prevents double load of the scene if load and url field are set at the same time.
         this ._loadData = this .getBrowser () .getCurrentTime ();
      else
         this .loadData ();

      await this .loading ();
   },
   loading ()
   {
      return new Promise ((resolve, reject) =>
      {
         const _loading = Symbol ();

         this ._loadState .addFieldCallback (_loading, () =>
         {
            switch (this .checkLoadState ())
            {
               case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .COMPLETE_STATE:
               {
                  this ._loadState .removeFieldCallback (_loading);
                  resolve ();
                  break;
               }
               case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .FAILED_STATE:
               {
                  this ._loadState .removeFieldCallback (_loading);
                  reject (new Error (`Failed loading ${this .getTypeName ()}.`));
                  break;
               }
            }
         });
      });
   },
   loadNow ()
   {
      this .setLoadState (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .NOT_STARTED_STATE);

      return this .requestImmediateLoad ();
   },
   loadData ()
   { },
   requestUnload ()
   {
      const loadState = this .checkLoadState ();

      if (loadState === _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .NOT_STARTED_STATE || loadState === _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .FAILED_STATE)
         return;

      this .setLoadState (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .NOT_STARTED_STATE);
      this .unloadData ();
   },
   unloadNow ()
   {
      this .requestUnload ();
   },
   unloadData ()
   { },
   setAutoRefreshTimer (autoRefreshInterval)
   {
      clearTimeout (this [_autoRefreshId]);

      if (this ._autoRefresh .getValue () <= 0)
         return;

      const autoRefreshTimeLimit = this ._autoRefreshTimeLimit .getValue ();

      if (autoRefreshTimeLimit > 0)
      {
         if ((Date .now () - this [_autoRefreshStartTime]) / 1000 > autoRefreshTimeLimit - autoRefreshInterval)
            return;
      }

      this [_autoRefreshId] = setTimeout (this .performAutoRefresh .bind (this), autoRefreshInterval * 1000);
   },
   performAutoRefresh ()
   {
      this .setLoadState (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .NOT_STARTED_STATE);
      this .requestImmediateLoad (false) .catch (Function .prototype);
   },
   set_live__ ()
   {
      if (this .getLive () .getValue ())
         this .set_autoRefresh__ ();
      else
         clearTimeout (this [_autoRefreshId]);
   },
   set_load__ ()
   {
      if (this ._load .getValue ())
         this .requestImmediateLoad () .catch (Function .prototype);
      else
         this .requestUnload ();
   },
   set_url__ ()
   {
      if (!this ._load .getValue ())
         return;

      this .setLoadState (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .NOT_STARTED_STATE);
      this .requestImmediateLoad () .catch (Function .prototype);
   },
   set_autoRefresh__ ()
   {
      if (this .checkLoadState () !== _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .COMPLETE_STATE)
         return;

      const
         elapsedTime = (Date .now () - this [_autoRefreshCompleteTime]) / 1000,
         autoRefresh = Math .max (this ._autoRefresh .getValue (), 0);

      let autoRefreshInterval = autoRefresh - elapsedTime;

      if (autoRefreshInterval < 0)
         autoRefreshInterval = Math .ceil (elapsedTime / autoRefresh) * autoRefresh - elapsedTime;

      this .setAutoRefreshTimer (autoRefreshInterval);
   },
   dispose () { },
});

Object .defineProperties (X3DUrlObject, _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .getStaticProperties ("X3DUrlObject", "Networking", 1));

const __default__ = X3DUrlObject;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .add ("X3DUrlObject", __default__));

/***/ }),

/***/ 4667:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Fields_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(564);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(6707);


function X3DCast (type, node, innerNode = true)
{
   try
   {
      if (node)
      {
         if (node instanceof _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFNode)
            node = node .getValue ();

         if (node)
         {
            if (innerNode)
               node = node .getInnerNode ();
            else
               node = node .valueOf ();

            if (node .getType () .includes (type))
               return node;
         }
      }
   }
   catch
   { }

   return null;
}

const __default__ = X3DCast;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .add ("X3DCast", __default__));

/***/ }),

/***/ 4716:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Fields_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(564);
/* harmony import */ var _Components_Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(8415);
/* harmony import */ var _Execution_X3DImportedNode_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(7627);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(6707);




class Placeholder extends _Components_Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A
{
   #parser;
   #lastIndex;
   #lineNumber;
   #name;
   #namedNodes;
   #importedNodes;
   #type;
   #typeName;

   constructor (parser, name, type = _Components_Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A, typeName)
   {
      super (parser .getExecutionContext ());

      this .#parser        = parser;
      this .#lastIndex     = parser .lastIndex,
      this .#lineNumber    = parser .lineNumber;
      this .#namedNodes    = parser .getNamedNodes ();
      this .#importedNodes = parser .getImportedNodes ();

      this .#name     = name;
      this .#type     = type;
      this .#typeName = typeName;
   }

   getComponentInfo ()
   {
      return this .#type .componentInfo;
   }

   getContainerField ()
   {
      return this .#type .containerField;
   }

   getSpecificationRange ()
   {
      return this .#type .specificationRange;
   }

   replaceWithNode ()
   {
      const
         name      = this .#name,
         localNode = this .#namedNodes .get (name) ?? this .#importedNodes .get (name);

      const node = localNode instanceof _Execution_X3DImportedNode_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A
         ? localNode .getExportedNode (this .#type)
         : localNode;

      if (!node)
      {
         this .#parser .lastIndex  = this .#lastIndex;
         this .#parser .lineNumber = this .#lineNumber;

         throw new Error (`Named node '${name}' not found.`);
      }

      this .#parser .checkNodeType (node, this .#name, this .#type, this .#typeName);

      for (const parent of Array .from (this .getParents ()))
      {
         if (!(parent instanceof _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFNode))
            continue;

         parent .setValue (node);
      }
   }
}

const __default__ = Placeholder;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .add ("Placeholder", __default__));

/***/ }),

/***/ 4747:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Base_X3DInfoArray_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(4635);
/* harmony import */ var _UnitInfo_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(8060);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(6707);



function UnitInfoArray (values = [ ])
{
   return _Base_X3DInfoArray_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .call (this, Array .from (values, value => [value .category, value]), _UnitInfo_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A);
}

Object .setPrototypeOf (UnitInfoArray .prototype, _Base_X3DInfoArray_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .prototype);

for (const key of Object .keys (UnitInfoArray .prototype))
   Object .defineProperty (UnitInfoArray .prototype, key, { enumerable: false });

Object .defineProperties (UnitInfoArray,
{
   typeName:
   {
      value: "UnitInfoArray",
      enumerable: true,
   },
});

const __default__ = UnitInfoArray;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .add ("UnitInfoArray", __default__));

/***/ }),

/***/ 4828:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(2639);
/* harmony import */ var _Numbers_Matrix4_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(1048);
/* harmony import */ var _x_ite_Namespace_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(6707);



const
   point     = new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A (),
   invMatrix = new _Numbers_Matrix4_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A ();

function Plane3 (point = _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .ZERO, normal = _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .Z_AXIS)
{
   this .normal = new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A ();

   this .set (point, normal);
}

Object .assign (Plane3 .prototype,
{
   copy ()
   {
      const copy = Object .create (Plane3 .prototype);

      copy .normal             = this .normal .copy ();
      copy .distanceFromOrigin = this .distanceFromOrigin;

      return copy;
   },
   assign (plane)
   {
      this .normal .assign (plane .normal);
      this .distanceFromOrigin = plane .distanceFromOrigin;

      return this;
   },
   equals (plane)
   {
      return this .distanceFromOrigin === plane .distanceFromOrigin && this .normal .equals (plane .normal);
   },
   set (point = _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .ZERO, normal = _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .Z_AXIS)
   {
      this .normal .assign (normal);
      this .distanceFromOrigin = normal .dot (point);
      return this;
   },
   multLeft (matrix)
   {
      // Taken from Inventor:

      // Find the point on the plane along the normal from the origin
      point .assign (this .normal) .multiply (this .distanceFromOrigin);

      // Transform the plane normal by the matrix
      // to get the new normal. Use the inverse transpose
      // of the matrix so that normals are not scaled incorrectly.
      // n' = !~m * n = n * ~m
      invMatrix .assign (matrix) .submatrix .inverse ()
         .multVecMatrix (this .normal) .normalize ();

      // Transform the point by the matrix
      matrix .multMatrixVec (point);

      // The new distance is the projected distance of the vector to the
      // transformed point onto the (unit) transformed normal. This is
      // just a dot product.
      this .distanceFromOrigin = this .normal .dot (point);

      return this;
   },
   multRight (matrix)
   {
      // Taken from Inventor:

      // Find the point on the plane along the normal from the origin
      point .assign (this .normal) .multiply (this .distanceFromOrigin);

      // Transform the plane normal by the matrix
      // to get the new normal. Use the inverse transpose
      // of the matrix so that normals are not scaled incorrectly.
      // n' = n * !~m = ~m * n
      invMatrix .assign (matrix) .submatrix .inverse ()
         .multMatrixVec (this .normal) .normalize ();

      // Transform the point by the matrix
      matrix .multVecMatrix (point);

      // The new distance is the projected distance of the vector to the
      // transformed point onto the (unit) transformed normal. This is
      // just a dot product.
      this .distanceFromOrigin = this .normal .dot (point);

      return this;
   },
   getDistanceToPoint (point)
   {
      return point .dot (this .normal) - this .distanceFromOrigin;
   },
   getPerpendicularVectorToPoint (point, result = new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A ())
   {
      return result .assign (this .normal) .multiply (-this .getDistanceToPoint (point));
   },
   getClosestPointToPoint (point, result = new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A ())
   {
      return this .getPerpendicularVectorToPoint (point, result) .add (point);
   },
   intersectsLine (line, intersection)
   {
      const { point, direction } = line;

      // Check if the line is parallel to the plane.
      const theta = direction .dot (this .normal);

      // Plane and line are parallel.
      if (theta === 0)
         return false;

      // Plane and line are not parallel. The intersection point can be calculated now.
      const t = (this .distanceFromOrigin - this .normal .dot (point)) / theta;

      intersection .assign (direction) .multiply (t) .add (point);

      return true;
   },
   toString ()
   {
      return `${this .normal}, ${this .distanceFromOrigin}`;
   },
});

const __default__ = Plane3;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_x_ite_Namespace_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .add ("Plane3", __default__));

/***/ }),

/***/ 5075:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Fields_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(564);
/* harmony import */ var _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(8415);
/* harmony import */ var _Shape_X3DAppearanceChildNode_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(8259);
/* harmony import */ var _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(8899);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(6707);





function X3DTextureNode (executionContext)
{
   _Shape_X3DAppearanceChildNode_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .call (this, executionContext);

   this .addType (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .X3DTextureNode);

   this .addChildObjects (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .outputOnly, "transparent", new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFBool ());
}

Object .assign (Object .setPrototypeOf (X3DTextureNode .prototype, _Shape_X3DAppearanceChildNode_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .prototype),
{
   setTransparent (value)
   {
      if (!!value !== this ._transparent .getValue ())
         this ._transparent = value;
   },
   isTransparent ()
   {
      return this ._transparent .getValue ();
   },
});

Object .defineProperties (X3DTextureNode, _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .getStaticProperties ("X3DTextureNode", "Texturing", 1));

const __default__ = X3DTextureNode;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .add ("X3DTextureNode", __default__));

/***/ }),

/***/ 5123:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _standard_Math_Geometry_ViewVolume_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(7364);
/* harmony import */ var _standard_Math_Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(2639);
/* harmony import */ var _standard_Math_Numbers_Matrix4_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(1048);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(6707);




function TextureBuffer ({ browser, width, height, float = false, mipMaps = false, colorTextures = 1 })
{
   const gl = browser .getContext ();

   this .context = gl;
   this .width   = width;
   this .height  = height;

   Object .defineProperty (this, "array",
   {
      get ()
      {
         const value = float ? new Float32Array (width * height * 4) : new Uint8Array (width * height * 4);

         Object .defineProperty (this, "array", { value: value });

         return value;
      },
      configurable: true,
   });

   // Get current frame buffer.

   const currentFrameBuffer = gl .getParameter (gl .FRAMEBUFFER_BINDING);

   // Create frame buffer.

   this .frameBuffer = gl .createFramebuffer ();

   gl .bindFramebuffer (gl .FRAMEBUFFER, this .frameBuffer);

   // Set draw buffers.

   gl .drawBuffers (Array .from ({ length: colorTextures }, (_, i) => gl .COLOR_ATTACHMENT0 + i));

   // Create color textures.

   this .colorTextures = [ ];

   for (let i = 0; i < colorTextures; ++ i)
   {
      this .colorTextures [i] = gl .createTexture ();

      gl .bindTexture (gl .TEXTURE_2D, this .colorTextures [i]);
      gl .texParameteri (gl .TEXTURE_2D, gl .TEXTURE_WRAP_S, gl .CLAMP_TO_EDGE);
      gl .texParameteri (gl .TEXTURE_2D, gl .TEXTURE_WRAP_T, gl .CLAMP_TO_EDGE);

      if (mipMaps)
      {
         gl .texParameteri (gl .TEXTURE_2D, gl .TEXTURE_MIN_FILTER, gl .LINEAR_MIPMAP_LINEAR);
         gl .texParameteri (gl .TEXTURE_2D, gl .TEXTURE_MAG_FILTER, gl .LINEAR);
      }
      else
      {
         gl .texParameteri (gl .TEXTURE_2D, gl .TEXTURE_MIN_FILTER, gl .NEAREST);
         gl .texParameteri (gl .TEXTURE_2D, gl .TEXTURE_MAG_FILTER, gl .NEAREST);
      }

      if (float)
         gl .texImage2D (gl .TEXTURE_2D, 0, gl .RGBA32F, width, height, 0, gl .RGBA, gl .FLOAT, null);
      else
         gl .texImage2D (gl .TEXTURE_2D, 0, gl .RGBA, width, height, 0, gl .RGBA, gl .UNSIGNED_BYTE, null);

      gl .framebufferTexture2D (gl .FRAMEBUFFER, gl .COLOR_ATTACHMENT0 + i, gl .TEXTURE_2D, this .colorTextures [i], 0);
   }

   // Create depth buffer.

   this .depthTexture = gl .createTexture ();

   gl .bindTexture (gl .TEXTURE_2D, this .depthTexture);

   gl .texParameteri (gl .TEXTURE_2D, gl .TEXTURE_WRAP_S,     gl .CLAMP_TO_EDGE);
   gl .texParameteri (gl .TEXTURE_2D, gl .TEXTURE_WRAP_T,     gl .CLAMP_TO_EDGE);
   gl .texParameteri (gl .TEXTURE_2D, gl .TEXTURE_MAG_FILTER, gl .NEAREST);
   gl .texParameteri (gl .TEXTURE_2D, gl .TEXTURE_MIN_FILTER, gl .NEAREST);

   gl .texImage2D (gl .TEXTURE_2D, 0, gl .DEPTH_COMPONENT24, width, height, 0, gl .DEPTH_COMPONENT, gl .UNSIGNED_INT, null);
   gl .framebufferTexture2D (gl .FRAMEBUFFER, gl .DEPTH_ATTACHMENT, gl .TEXTURE_2D, this .depthTexture, 0);

   const status = gl .checkFramebufferStatus (gl .FRAMEBUFFER) === gl .FRAMEBUFFER_COMPLETE;

   // Restore previous frame buffer.

   gl .bindFramebuffer (gl .FRAMEBUFFER, currentFrameBuffer);

   // Always check that our framebuffer is ok.

   if (!status)
      throw new Error ("Couldn't create frame buffer.");
}

Object .assign (TextureBuffer .prototype,
{
   getOIT ()
   {
      return false;
   },
   getWidth ()
   {
      return this .width;
   },
   getHeight ()
   {
      return this .height;
   },
   getColorTexture (i = 0)
   {
      return this .colorTextures [i];
   },
   getDepthTexture ()
   {
      return this .depthTexture;
   },
   readPixels ()
   {
      const { context: gl, array, width, height } = this;

      gl .readPixels (0, 0, width, height, gl .RGBA, gl .UNSIGNED_BYTE, array);

      return array;
   },
   readDepth: (() =>
   {
      const
         invProjectionMatrix = new _standard_Math_Numbers_Matrix4_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A (),
         point               = new _standard_Math_Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A ();

      return function (projectionMatrix, viewport, result)
      {
         const { context: gl, array, width, height } = this;

         gl .readBuffer (gl .COLOR_ATTACHMENT0);
         gl .readPixels (0, 0, width, height, gl .RGBA, gl .FLOAT, array);

         let
            winX  = 0,
            winY  = 0,
            winZ  = Number .POSITIVE_INFINITY,
            index = -1;

         for (let wy = 0, i = 0; wy < height; ++ wy)
         {
            for (let wx = 0; wx < width; ++ wx, i += 4)
            {
               const wz = array [i];

               if (wz < winZ)
               {
                  winX  = wx;
                  winY  = wy;
                  winZ  = wz;
                  index = i;
               }
            }
         }

         invProjectionMatrix .assign (projectionMatrix) .inverse ();

         _standard_Math_Geometry_ViewVolume_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .unProjectPointMatrix (winX, winY, winZ, invProjectionMatrix, viewport, point);

         result .distance = -point .z;
         result .id       = array [index + 1];

         gl .readBuffer (gl .COLOR_ATTACHMENT1);
         gl .readPixels (0, 0, width, height, gl .RGBA, gl .FLOAT, array);

         result .normal .set (array [index], array [index + 1], array [index + 2]);
         // result .frontFacing = array [index + 3] ? true : false;

         return result;
      };
   })(),
   bind ()
   {
      const gl = this .context;

      gl .bindFramebuffer (gl .FRAMEBUFFER, this .frameBuffer);
   },
   dispose ()
   {
      const gl = this .context;

      gl .deleteFramebuffer (this .frameBuffer);

      for (const colorTexture of this .colorTextures)
         gl .deleteTexture (colorTexture);

      gl .deleteTexture (this .depthTexture);
    },
});

for (const key of Object .keys (TextureBuffer .prototype))
   Object .defineProperty (TextureBuffer .prototype, key, { enumerable: false });

const __default__ = TextureBuffer;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .add ("TextureBuffer", __default__));

/***/ }),

/***/ 5175:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Fields_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(564);
/* harmony import */ var _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(8311);
/* harmony import */ var _Base_FieldDefinitionArray_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(6973);
/* harmony import */ var _Components_Networking_X3DUrlObject_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(4666);
/* harmony import */ var _X3DProtoDeclarationNode_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(9609);
/* harmony import */ var _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(8899);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(6707);







const
   _proto = Symbol (),
   _scene = Symbol (),
   _cache = Symbol ();

function X3DExternProtoDeclaration (executionContext, url)
{
   _X3DProtoDeclarationNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .call (this, executionContext);
   _Components_Networking_X3DUrlObject_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A            .call (this, executionContext);

   this .addType (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .X3DExternProtoDeclaration)

   this .addChildObjects (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .inputOutput, "load",                 new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFBool (true),
                          _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .inputOutput, "url",                  url .copy (), // Must be of type MFString.
                          _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .inputOutput, "autoRefresh",          new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFTime (0),
                          _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .inputOutput, "autoRefreshTimeLimit", new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFTime (3600));

   this .getBrowser () [_cache] ??= new Map ();
}

Object .assign (Object .setPrototypeOf (X3DExternProtoDeclaration .prototype, _X3DProtoDeclarationNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .prototype),
   _Components_Networking_X3DUrlObject_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .prototype,
{
   initialize ()
   {
      _X3DProtoDeclarationNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .prototype .initialize .call (this);
      _Components_Networking_X3DUrlObject_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A            .prototype .initialize .call (this);
   },
   getAppInfo ()
   {
      return this [_proto] ?.getAppInfo ()
         || _X3DProtoDeclarationNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .prototype .getAppInfo .call (this);
   },
   setAppInfo (value)
   {
      if (this [_proto])
         this [_proto] .setAppInfo (value);
      else
         _X3DProtoDeclarationNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .prototype .setAppInfo .call (this, value);
   },
   getDocumentation ()
   {
      return this [_proto] ?.getDocumentation ()
         || _X3DProtoDeclarationNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .prototype .getDocumentation .call (this);
   },
   setDocumentation (value)
   {
      if (this [_proto])
         this [_proto] .setDocumentation (value);
      else
         _X3DProtoDeclarationNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .prototype .setDocumentation .call (this, value);
   },
   getProtoDeclaration ()
   {
      return this [_proto];
   },
   setProtoDeclaration (proto)
   {
      this [_proto] = proto;

      if (proto)
      {
         this .getFieldDefinitions ()  .assign (proto .getFieldDefinitions ());
         this .getUserDefinedFields () .assign (proto .getUserDefinedFields ());
      }

      this .updateInstances ();
   },
   async loadData ()
   {
      const browser = this .getBrowser ();

      if (!this ._url .length)
      {
         this .setError (new Error ("No URL given."));
         return;
      }

      const { default: FileLoader } = await Promise.resolve(/* import() */).then(__webpack_require__.bind(__webpack_require__, 9084));

      for (const url of this ._url)
      {
         try
         {
            const
               fileURL  = new URL (url, this .getExecutionContext () .getBaseURL ()),
               cacheURL = new URL (fileURL),
               cache    = browser .getBrowserOption ("Cache");

            cacheURL .hash = "";

            const cachePromise = cache
               ? browser [_cache] .get (cacheURL .href)
               : null;

            const promise = cachePromise ?? new Promise (resolve =>
            {
               new FileLoader (this) .createX3DFromURL ([cacheURL], null, resolve);
            });

            if (!cachePromise && !cacheURL .search)
               browser [_cache] .set (cacheURL .href, promise);

            const scene = await promise;

            if (!scene)
               continue;

            this .setInternalScene (scene, fileURL, cache);
            return;
         }
         catch (error)
         {
            console .warn (error .message);
         }
      }

      this .setError (new Error ("File could not be loaded."));
   },
   getInternalScene ()
   {
      ///  Returns the internal X3DScene of this extern proto, that is loaded from the url given.

      return this [_scene];
   },
   setInternalScene (scene, fileURL, cache)
   {
      const browser = this .getBrowser ();

      if (this [_scene] !== browser .getDefaultScene () && !this [_cache])
         this [_scene] ?.dispose ();

      this [_scene] = scene;
      this [_cache] = cache;

      const
         protoName = decodeURIComponent (fileURL .hash .substring (1)),
         proto     = protoName ? this [_scene] .protos .get (protoName) : this [_scene] .protos [0];

      if (!proto)
         throw new Error ("PROTO not found");

      this [_scene] .setExecutionContext (this [_cache] ? browser .getDefaultScene () : this .getExecutionContext ());
      this [_scene] .setLive (true);

      this .setLoadState (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .COMPLETE_STATE);
      this .setProtoDeclaration (proto);
   },
   setError (error)
   {
      console .error (`Error loading extern prototype '${this .getName ()}':`, error);

      this [_scene] = this .getBrowser () .getDefaultScene ();

      this .setLoadState (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .FAILED_STATE);
      this .setProtoDeclaration (null);
   },
   toVRMLStream (generator)
   {
      generator .Indent ();
      generator .string += "EXTERNPROTO";
      generator .Space ();
      generator .string += this .getName ();
      generator .TidySpace ();
      generator .string += "[";

      const userDefinedFields = this .getUserDefinedFields ();

      if (userDefinedFields .length === 0)
      {
         generator .TidySpace ();
      }
      else
      {
         let
            fieldTypeLength   = 0,
            accessTypeLength  = 0;

         for (const field of userDefinedFields)
         {
            fieldTypeLength  = Math .max (fieldTypeLength, field .getTypeName () .length);
            accessTypeLength = Math .max (accessTypeLength, generator .AccessType (field .getAccessType ()) .length);
         }

         generator .TidyBreak ();

         generator .IncIndent ();

         const last = userDefinedFields .at (-1);

         for (const field of userDefinedFields)
         {
            this .toVRMLStreamUserDefinedField (generator, field, fieldTypeLength, accessTypeLength);

            if (field === last)
               generator .TidyBreak ();
            else
               generator .Break ();
         }

         generator .DecIndent ();

         generator .Indent ();
      }

      generator .string += "]";
      generator .TidyBreak ();
      generator .Indent ();

      this ._url .toVRMLStream (generator);
   },
   toVRMLStreamUserDefinedField (generator, field, fieldTypeLength, accessTypeLength)
   {
      generator .Indent ();
      generator .string += generator .AccessType (field .getAccessType ()) .padEnd (accessTypeLength, generator .TidySpace ());
      generator .Space ();
      generator .string += field .getTypeName () .padEnd (fieldTypeLength, generator .TidySpace ());
      generator .Space ();
      generator .string += field .getName ();
   },
   toXMLStream (generator)
   {
      generator .openTag ("ExternProtoDeclare");
      generator .attribute ("name", this .getName ());

      generator .Space ();
      generator .string += "url='";

      this ._url .toXMLStream (generator);

      generator .string += "'";

      if (this .getAppInfo ())
         generator .attribute ("appinfo", this .getAppInfo ());

      if (this .getDocumentation ())
         generator .attribute ("documentation", this .getDocumentation ());

      const userDefinedFields = this .getUserDefinedFields ();

      if (userDefinedFields .length)
      {
         generator .endTag ();
         generator .IncIndent ();

         for (const field of userDefinedFields)
         {
            generator .openTag ("field");
            generator .attribute ("accessType", generator .AccessType (field .getAccessType ()));
            generator .attribute ("type",       field .getTypeName ());
            generator .attribute ("name",       field .getName ());

            if (field .getAppInfo ())
               generator .attribute ("appinfo", field .getAppInfo ());

            if (field .getDocumentation ())
               generator .attribute ("documentation", field .getDocumentation ());

            generator .closeTag ("field");
            generator .TidyBreak ();
         }

         generator .DecIndent ();
         generator .closingTag ("ExternProtoDeclare");
      }
      else
      {
         generator .closeTag ("ExternProtoDeclare");
      }
   },
   toJSONStream (generator)
   {
      generator .TidyBreak ();
      generator .Indent ();

      generator .beginObject ("ExternProtoDeclare", false, true);
      generator .stringProperty ("@name", this .getName (), false);

      if (this .getAppInfo ())
         generator .stringProperty ("@appinfo", this .getAppInfo ());

      if (this .getDocumentation ())
         generator .stringProperty ("@documentation", this .getDocumentation ());

      // Fields

      const userDefinedFields = this .getUserDefinedFields ();

      if (userDefinedFields .length)
      {
         generator .beginArray ("field");

         for (const field of userDefinedFields)
         {
            generator .beginObject ("", field !== userDefinedFields [0]);
            generator .stringProperty ("@accessType", generator .AccessType (field .getAccessType ()), false);
            generator .stringProperty ("@type",       field .getTypeName ());
            generator .stringProperty ("@name",       field .getName ());

            if (field .getAppInfo ())
               generator .stringProperty ("@appinfo", field .getAppInfo ());

            if (field .getDocumentation ())
               generator .stringProperty ("@documentation", field .getDocumentation ());

            generator .endObject ();
         }

         generator .endArray ();
      }

      // URL

      generator .string += ',';
      generator .TidyBreak ();
      generator .Indent ();
      generator .string += '"';
      generator .string += "@url";
      generator .string += '"';
      generator .string += ':';
      generator .TidySpace ();

      this ._url .toJSONStream (generator);

      // End

      generator .endObject ();
      generator .endObject ();
   },
});

for (const key of Object .keys (X3DExternProtoDeclaration .prototype))
   Object .defineProperty (X3DExternProtoDeclaration .prototype, key, { enumerable: false });

Object .defineProperties (X3DExternProtoDeclaration .prototype,
{
   isExternProto:
   {
      value: true,
      enumerable: true,
   },
   urls:
   {
      get () { return this ._url; },
      enumerable: true,
   },
   loadState:
   {
      get: X3DExternProtoDeclaration .prototype .checkLoadState,
      enumerable: true,
   },
});

Object .defineProperties (X3DExternProtoDeclaration,
{
   typeName:
   {
      value: "X3DExternProtoDeclaration",
      enumerable: true,
   },
   fieldDefinitions:
   {
      value: new _Base_FieldDefinitionArray_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A ([
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .inputOutput, "metadata", new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFNode ()),
      ]),
      enumerable: true,
   },
});

_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .addConstant (X3DExternProtoDeclaration .typeName);

const __default__ = X3DExternProtoDeclaration;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .add ("X3DExternProtoDeclaration", __default__));

/***/ }),

/***/ 5257:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Fields_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(564);
/* harmony import */ var _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(8311);
/* harmony import */ var _Base_FieldDefinitionArray_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(6973);
/* harmony import */ var _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(8415);
/* harmony import */ var _X3DTexture2DNode_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(7181);
/* harmony import */ var _Networking_X3DUrlObject_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(4666);
/* harmony import */ var _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(8899);
/* harmony import */ var _DEVELOPMENT_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(2084);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(6707);
/* provided dependency */ var $ = __webpack_require__(7682);









function ImageTexture (executionContext)
{
   _X3DTexture2DNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .call (this, executionContext);
   _Networking_X3DUrlObject_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A     .call (this, executionContext);

   this .addType (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .ImageTexture);

   this .image    = $("<img></img>");
   this .urlStack = new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFString ();

   this .getMatrix () .set ([1, 0, 0, 0, 0, -1, 0, 0, 0, 0, 1, 0, 0, 1, 0, 1]); // flipY
}

Object .assign (Object .setPrototypeOf (ImageTexture .prototype, _X3DTexture2DNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .prototype),
   _Networking_X3DUrlObject_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .prototype,
{
   initialize ()
   {
      _X3DTexture2DNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .prototype .initialize .call (this);
      _Networking_X3DUrlObject_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A     .prototype .initialize .call (this);

      this ._colorSpaceConversion .addInterest ("loadNow", this);

      this .image
         .on ("load", this .setImage .bind (this))
         .on ("abort error", this .setError .bind (this))
         .attr ("crossorigin", "anonymous");

      this .requestImmediateLoad () .catch (Function .prototype);
   },
   getTextureType ()
   {
      return 1;
   },
   unloadData ()
   {
      this .clearTexture ();
   },
   loadData ()
   {
      this .urlStack .setValue (this ._url);
      this .loadNext ();
   },
   loadNext ()
   {
      if (this .urlStack .length === 0)
      {
         this .clearTexture ();
         this .setLoadState (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .FAILED_STATE);
         return;
      }

      // Get URL.

      this .URL = new URL (this .urlStack .shift (), this .getExecutionContext () .getBaseURL ());

      if (this .URL .pathname .match (/\.ktx2?(?:\.gz)?$/) || this .URL .href .match (/^data:image\/ktx2[;,]/))
      {
         this .setLinear (true);
         this .setMipMaps (false);

         this .getBrowser () .getKTXDecoder ()
            .then (decoder => decoder .loadKTXFromURL (this .URL, this .getCache ()))
            .then (texture => this .setKTXTexture (texture))
            .catch (error => this .setError ({ type: error .message }));
      }
      else
      {
         this .setLinear (false);
         this .setMipMaps (true);

         if (this .URL .protocol !== "data:")
         {
            if (!this .getCache ())
               this .URL .searchParams .set ("_", Date .now ());
         }

         this .image .attr ("src", this .URL);
      }
   },
   setError (event)
   {
      if (this .URL .protocol !== "data:")
         console .warn (`Error loading image '${decodeURI (this .URL)}:'`, event .type);

      this .loadNext ();
   },
   setKTXTexture (texture)
   {
      if (texture .target !== this .getTarget ())
         return this .setError ({ type: "Invalid KTX texture target, must be 'TEXTURE_2D'." });

      if (_DEVELOPMENT_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A)
      {
         if (this .URL .protocol !== "data:")
            console .info (`Done loading image texture '${decodeURI (this .URL)}'.`);
      }

      try
      {
         this .setTexture (texture);
         this .setTransparent (false);
         this .setWidth (texture .baseWidth);
         this .setHeight (texture .baseHeight);
         this .updateTextureParameters ();

         this .setLoadState (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .COMPLETE_STATE);
      }
      catch (error)
      {
         // Catch security error from cross origin requests.
         this .setError ({ type: error .message });
      }
   },
   setImage ()
   {
      if (_DEVELOPMENT_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A)
      {
         if (this .URL .protocol !== "data:")
            console .info (`Done loading image texture '${decodeURI (this .URL)}'.`);
      }

      try
      {
         const
            image             = this .image [0],
            { width, height } = image;

         // Upload image to GPU.

         this .setTextureData (width, height, this ._colorSpaceConversion .getValue (), this .isTransparent (), image);
         this .setTransparent (this .isImageTransparent (this .getTextureData (this .getTexture (), width, height)));
         this .setLoadState (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .COMPLETE_STATE);
         this .addNodeEvent ();
      }
      catch (error)
      {
         // Catch security error from cross origin requests.
         this .setError ({ type: error .message });
      }
   },
   dispose ()
   {
      _Networking_X3DUrlObject_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A     .prototype .dispose .call (this);
      _X3DTexture2DNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .prototype .dispose .call (this);
   },
});

Object .defineProperties (ImageTexture,
{
   ... _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .getStaticProperties ("ImageTexture", "Texturing", 1, "texture", "2.0"),
   fieldDefinitions:
   {
      value: new _Base_FieldDefinitionArray_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A ([
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .inputOutput,    "metadata",             new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFNode ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .inputOutput,    "description",          new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFString ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .inputOutput,    "load",                 new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFBool (true)),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .inputOutput,    "url",                  new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFString ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .inputOutput,    "autoRefresh",          new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFTime (0)),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .inputOutput,    "autoRefreshTimeLimit", new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFTime (3600)),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .initializeOnly, "colorSpaceConversion", new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFBool (true)), // experimental
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .initializeOnly, "repeatS",              new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFBool (true)),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .initializeOnly, "repeatT",              new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFBool (true)),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .initializeOnly, "textureProperties",    new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFNode ()),
      ]),
      enumerable: true,
   },
});

const __default__ = ImageTexture;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_8__/* ["default"] */ .A .add ("ImageTexture", __default__));

/***/ }),

/***/ 5289:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Fields_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(564);
/* harmony import */ var _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(8311);
/* harmony import */ var _Base_FieldDefinitionArray_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(6973);
/* harmony import */ var _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(8415);
/* harmony import */ var _Layer_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(1785);
/* harmony import */ var _Base_X3DCast_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(4667);
/* harmony import */ var _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(8899);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(6707);








function LayerSet (executionContext)
{
   _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .call (this, executionContext);

   this .addType (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .LayerSet);

   this .addChildObject (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .outputOnly, "activeLayerNode",  new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFNode ());

   this .layerNodes = [ new _Layer_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A (executionContext) ];
   this .layerNode0 = this .layerNodes [0];
}

Object .assign (Object .setPrototypeOf (LayerSet .prototype, _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .prototype),
{
   initialize ()
   {
      _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .prototype .initialize .call (this);

      this .layerNode0 .setPrivate (true);
      this .layerNode0 .setup ();
      this .layerNode0 .setLayer0 (true);

      this ._activeLayer .addInterest ("set_activeLayer__", this);
      this ._order       .addInterest ("set_layers__",      this);
      this ._layers      .addInterest ("set_layers__",      this);

      this .set_layers__ ();
   },
   getActiveLayer ()
   {
      return this ._activeLayerNode .getValue ();
   },
   getLayer0 ()
   {
      return this .layerNode0;
   },
   setLayer0 (value)
   {
      this .layerNode0 = value;

      this .set_layers__ ();
   },
   getLayers ()
   {
      return this .layerNodes;
   },
   set_activeLayer__ ()
   {
      let activeLayerNode;

      if (this ._activeLayer .getValue () === 0)
      {
         activeLayerNode = this .layerNode0;
      }
      else
      {
         const index = this ._activeLayer .getValue () - 1;

         if (index >= 0 && index < this ._layers .length)
         {
            activeLayerNode = (0,_Base_X3DCast_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A) (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .X3DLayerNode, this ._layers [index]);
         }
         else
         {
            activeLayerNode = null;
         }
      }

      if (!activeLayerNode ?._display .getValue ())
         activeLayerNode = null;

      if (this ._activeLayerNode .getValue () !== activeLayerNode)
         this ._activeLayerNode = activeLayerNode;
   },
   set_layers__ ()
   {
      const layers = this ._layers .getValue ();

      for (const layerNode of this .layerNodes)
         layerNode ._display .removeInterest ("set_layers__", this);

      this .layerNodes .length = 0;

      for (let index of this ._order)
      {
         if (index === 0)
         {
            this .layerNode0 ._display .addInterest ("set_layers__", this);
            this .layerNodes .push (this .layerNode0);
         }
         else
         {
            -- index;

            if (index >= 0 && index < layers .length)
            {
               const layerNode = (0,_Base_X3DCast_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A) (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .X3DLayerNode, layers [index]);

               if (!layerNode)
                  continue;

               layerNode ._display .addInterest ("set_layers__", this);

               if (layerNode ._display .getValue ())
                  this .layerNodes .push (layerNode);
            }
         }
      }

      this .set_activeLayer__ ();
   },
   bindBindables (viewpointName)
   {
      this .layerNode0 ?.bindBindables (viewpointName);

      for (const node of this ._layers)
      {
         const layerNode = (0,_Base_X3DCast_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A) (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .X3DLayerNode, node);

         layerNode ?.bindBindables (viewpointName);
      }
   },
   traverse (type, renderObject)
   {
      for (const layerNode of this .layerNodes)
         layerNode .traverse (type, renderObject);
   },
});

Object .defineProperties (LayerSet,
{
   ... _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .getStaticProperties ("LayerSet", "Layering", 1, "children", "3.2"),
   fieldDefinitions:
   {
      value: new _Base_FieldDefinitionArray_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A ([
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .inputOutput, "metadata",    new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFNode ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .inputOutput, "activeLayer", new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFInt32 ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .inputOutput, "order",       new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFInt32 (0)),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .inputOutput, "layers",      new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFNode ()),
      ]),
      enumerable: true,
   },
});

const __default__ = LayerSet;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .add ("LayerSet", __default__));

/***/ }),

/***/ 5295:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Base_X3DInfoArray_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(4635);
/* harmony import */ var _X3DExportedNode_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(2512);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(6707);



function ExportedNodesArray (values = [ ])
{
   return _Base_X3DInfoArray_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .call (this, Array .from (values, value => [value .getExportedName (), value]), _X3DExportedNode_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A);
}

Object .setPrototypeOf (ExportedNodesArray .prototype, _Base_X3DInfoArray_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .prototype);

for (const key of Object .keys (ExportedNodesArray .prototype))
   Object .defineProperty (ExportedNodesArray .prototype, key, { enumerable: false });

Object .defineProperties (ExportedNodesArray,
{
   typeName:
   {
      value: "ExportedNodesArray",
      enumerable: true,
   },
});

const __default__ = ExportedNodesArray;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .add ("ExportedNodesArray", __default__));

/***/ }),

/***/ 5317:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Fields_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(564);
/* harmony import */ var _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(8311);
/* harmony import */ var _Base_FieldDefinitionArray_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(6973);
/* harmony import */ var _Execution_X3DExecutionContext_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(7926);
/* harmony import */ var _X3DProtoDeclarationNode_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(9609);
/* harmony import */ var _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(8899);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(6707);







const
   _body = Symbol ();

function X3DProtoDeclaration (executionContext)
{
   _X3DProtoDeclarationNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .call (this, executionContext);

   this .addType (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .X3DProtoDeclaration)

   this [_body] = new _Execution_X3DExecutionContext_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A (executionContext, this);
   this [_body] .setLive (false);
   this .setLive (false);
}

Object .assign (Object .setPrototypeOf (X3DProtoDeclaration .prototype, _X3DProtoDeclarationNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .prototype),
{
   initialize ()
   {
      _X3DProtoDeclarationNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .prototype .initialize .call (this);

      this [_body] .setup ();
   },
   getProtoDeclaration ()
   {
      return this;
   },
   getBody ()
   {
      return this [_body];
   },
   getCloneCount ()
   {
      return _X3DProtoDeclarationNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .prototype .collectCloneCount .call (this);
   },
   collectCloneCount ()
   {
      return 1;
   },
   toVRMLStream (generator)
   {
      generator .Indent ();
      generator .string += "PROTO";
      generator .Space ();
      generator .string += this .getName ();
      generator .TidySpace ();
      generator .string += "[";

      const userDefinedFields = this .getUserDefinedFields ();

      if (userDefinedFields .length === 0)
      {
         generator .TidySpace ();
      }
      else
      {
         let
            fieldTypeLength  = 0,
            accessTypeLength = 0;

         for (const field of userDefinedFields)
         {
            fieldTypeLength  = Math .max (fieldTypeLength, field .getTypeName () .length);
            accessTypeLength = Math .max (accessTypeLength, generator .AccessType (field .getAccessType ()) .length);
         }

         generator .TidyBreak ();

         generator .IncIndent ();

         const last = userDefinedFields .at (-1);

         for (const field of userDefinedFields)
         {
            this .toVRMLStreamUserDefinedField (generator, field, fieldTypeLength, accessTypeLength);

            if (field === last)
               generator .TidyBreak ();
            else
               generator .Break ();
         }

         generator .DecIndent ();

         generator .Indent ();
      }

      generator .string += "]";
      generator .TidyBreak ();

      generator .Indent ();
      generator .string += "{";
      generator .TidyBreak ();

      generator .IncIndent ();

      this [_body] .toVRMLStream (generator);

      generator .DecIndent ();

      generator .Indent ();
      generator .string += "}";
   },
   toVRMLStreamUserDefinedField (generator, field, fieldTypeLength, accessTypeLength)
   {
      generator .Indent ();
      generator .string += generator .AccessType (field .getAccessType ()) .padEnd (accessTypeLength, generator .TidySpace ());
      generator .Space ();
      generator .string += field .getTypeName () .padEnd (fieldTypeLength, generator .TidySpace ());
      generator .Space ();
      generator .string += field .getName ();

      if (!field .isInitializable ())
         return;

      generator .Space ();

      field .toVRMLStream (generator);
   },
   toXMLStream (generator)
   {
      generator .openTag ("ProtoDeclare");
      generator .attribute ("name", this .getName ());

      if (this .getAppInfo ())
         generator .attribute ("appinfo", this .getAppInfo ());

      if (this .getDocumentation ())
         generator .attribute ("documentation", this .getDocumentation ());

      generator .endTag ();

      // <ProtoInterface>

      const userDefinedFields = this .getUserDefinedFields ();

      if (userDefinedFields .length !== 0)
      {
         generator .IncIndent ();
         generator .openingTag ("ProtoInterface");
         generator .TidyBreak ();
         generator .IncIndent ();

         for (const field of userDefinedFields)
         {
            generator .openTag ("field");
            generator .attribute ("accessType", generator .AccessType (field .getAccessType ()));
            generator .attribute ("type",       field .getTypeName ());
            generator .attribute ("name",       field .getName ());

            if (field .isDefaultValue () || !field .isInitializable ())
            {
               if (field .getAppInfo ())
                  generator .attribute ("appinfo", field .getAppInfo ());

               if (field .getDocumentation ())
                  generator .attribute ("documentation", field .getDocumentation ());

               generator .closeTag ("field");
               generator .TidyBreak ();
            }
            else
            {
               switch (field .getType ())
               {
                  case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .SFNode:
                  case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .MFNode:
                  {
                     if (field .getAppInfo ())
                        generator .attribute ("appinfo", field .getAppInfo ());

                     if (field .getDocumentation ())
                        generator .attribute ("documentation", field .getDocumentation ());

                     generator .endTag ();
                     generator .IncIndent ();
                     generator .PushContainerField (null);

                     field .toXMLStream (generator);

                     generator .TidyBreak ();
                     generator .DecIndent ();
                     generator .closingTag ("field");
                     generator .TidyBreak ();
                     generator .PopContainerField ();
                     break;
                  }
                  default:
                  {
                     generator .Space ();
                     generator .string += "value='";

                     field .toXMLStream (generator);

                     generator .string += "'";

                     if (field .getAppInfo ())
                        generator .attribute ("appinfo", field .getAppInfo ());

                     if (field .getDocumentation ())
                        generator .attribute ("documentation", field .getDocumentation ());

                     generator .closeTag ("field");
                     generator .TidyBreak ();
                     break;
                  }
               }
            }
         }

         generator .DecIndent ();
         generator .closingTag ("ProtoInterface");
         generator .TidyBreak ();
         generator .DecIndent ();
      }

      // </ProtoInterface>

      // <ProtoBody>

      generator .IncIndent ();
      generator .openingTag ("ProtoBody");
      generator .TidyBreak ();
      generator .IncIndent ();

      this [_body] .toXMLStream (generator);

      generator .DecIndent ();
      generator .closingTag ("ProtoBody");
      generator .TidyBreak ();
      generator .DecIndent ();

      // </ProtoBody>

      generator .closingTag ("ProtoDeclare");
   },
   toJSONStream (generator)
   {
      generator .TidyBreak ();
      generator .Indent ();

      generator .beginObject ("ProtoDeclare", false, true);
      generator .stringProperty ("@name", this .getName (), false);

      if (this .getAppInfo ())
         generator .stringProperty ("@appinfo", this .getAppInfo ());

      if (this .getDocumentation ())
         generator .stringProperty ("@documentation", this .getDocumentation ());

      // Fields

      generator .beginObject ("ProtoInterface");

      const userDefinedFields = this .getUserDefinedFields ();

      if (userDefinedFields .length)
      {
         generator .beginArray ("field", false);

         for (const field of userDefinedFields)
         {
            generator .beginObject ("", field !== userDefinedFields [0]);
            generator .stringProperty ("@accessType", generator .AccessType (field .getAccessType ()), false);
            generator .stringProperty ("@type",       field .getTypeName ());
            generator .stringProperty ("@name",       field .getName ());

            if (!field .isDefaultValue () && field .isInitializable ())
            {
               // Output value

               switch (field .getType ())
               {
                  case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .SFNode:
                  {
                     generator .beginArray ("-children");

                     generator .TidyBreak ();
                     generator .Indent ();

                     field .toJSONStream (generator);

                     generator .endArray ();
                     break;
                  }
                  case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .MFNode:
                  {
                     generator .beginValue ("-children", true);

                     field .toJSONStream (generator);
                     break;
                  }
                  default:
                  {
                     generator .beginValue ("@value", true);

                     field .toJSONStream (generator);
                     break;
                  }
               }
            }

            if (field .getAppInfo ())
               generator .stringProperty ("@appinfo", field .getAppInfo ());

            if (field .getDocumentation ())
               generator .stringProperty ("@documentation", field .getDocumentation ());

            generator .endObject ();
         }

         generator .endArray ();
      }

      generator .endObject ();

      // ProtoBody

      generator .beginObject ("ProtoBody");
      generator .beginArray ("-children", false);

      this [_body] .toJSONStream (generator);

      generator .endArray ();
      generator .endObject ();

      // End

      generator .endObject ();
      generator .endObject ();
   },
});

for (const key of Object .keys (X3DProtoDeclaration .prototype))
   Object .defineProperty (X3DProtoDeclaration .prototype, key, { enumerable: false });

Object .defineProperties (X3DProtoDeclaration .prototype,
{
   isExternProto:
   {
      value: false,
      enumerable: true,
   },
});

Object .defineProperties (X3DProtoDeclaration,
{
   typeName:
   {
      value: "X3DProtoDeclaration",
      enumerable: true,
   },
   fieldDefinitions:
   {
      value: new _Base_FieldDefinitionArray_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A ([
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .inputOutput, "metadata", new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFNode ()),
      ]),
      enumerable: true,
   },
});

_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .addConstant (X3DProtoDeclaration .typeName);

const __default__ = X3DProtoDeclaration;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .add ("X3DProtoDeclaration", __default__));

/***/ }),

/***/ 5320:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Fields_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(564);
/* harmony import */ var _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(8311);
/* harmony import */ var _Base_FieldDefinitionArray_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(6973);
/* harmony import */ var _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(8415);
/* harmony import */ var _X3DInterpolatorNode_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(9825);
/* harmony import */ var _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(8899);
/* harmony import */ var _standard_Math_Numbers_Rotation4_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(1029);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(6707);








function OrientationInterpolator (executionContext)
{
   _X3DInterpolatorNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .call (this, executionContext);

   this .addType (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .OrientationInterpolator);

   // Units

   this ._keyValue      .setUnit ("angle");
   this ._value_changed .setUnit ("angle");
}

Object .assign (Object .setPrototypeOf (OrientationInterpolator .prototype, _X3DInterpolatorNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .prototype),
{
   initialize ()
   {
      _X3DInterpolatorNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .prototype .initialize .call (this);

      this ._keyValue .addInterest ("set_keyValue__", this);
   },
   set_keyValue__ ()
   {
      const
         key      = this ._key,
         keyValue = this ._keyValue;

      if (keyValue .length < key .length)
         keyValue .resize (key .length, keyValue .length ? keyValue [keyValue .length - 1] : new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFRotation ());

      // If there was already an set_fraction event in this frame, send a new value_changed to prevent glitches.
      if (this ._set_fraction .getModificationTime () >= this .getBrowser () .getCurrentTime ())
         this .set_fraction__ ();
   },
   interpolate: (() =>
   {
      const
         keyValue0 = new _standard_Math_Numbers_Rotation4_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A (),
         keyValue1 = new _standard_Math_Numbers_Rotation4_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A ();

      return function (index0, index1, weight)
      {
         // Both values can change in slerp.
         keyValue0 .assign (this ._keyValue [index0] .getValue ());
         keyValue1 .assign (this ._keyValue [index1] .getValue ());

         this ._value_changed = keyValue0 .slerp (keyValue1, weight);
      };
   })(),
});

Object .defineProperties (OrientationInterpolator,
{
   ... _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .getStaticProperties ("OrientationInterpolator", "Interpolation", 1, "children", "2.0"),
   fieldDefinitions:
   {
      value: new _Base_FieldDefinitionArray_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A ([
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .inputOutput, "metadata",      new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFNode ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .inputOnly,   "set_fraction",  new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFFloat ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .inputOutput, "key",           new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFFloat ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .inputOutput, "keyValue",      new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFRotation ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .outputOnly,  "value_changed", new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFRotation ()),
      ]),
      enumerable: true,
   },
});

const __default__ = OrientationInterpolator;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .add ("OrientationInterpolator", __default__));

/***/ }),

/***/ 5561:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(8415);
/* harmony import */ var _X3DChildNode_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(8193);
/* harmony import */ var _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(8899);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(6707);




function X3DSensorNode (executionContext)
{
   _X3DChildNode_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .call (this, executionContext);

   this .addType (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .X3DSensorNode);
}

Object .setPrototypeOf (X3DSensorNode .prototype, _X3DChildNode_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .prototype);

Object .defineProperties (X3DSensorNode, _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .getStaticProperties ("X3DSensorNode", "Core", 1));

const __default__ = X3DSensorNode;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .add ("X3DSensorNode", __default__));

/***/ }),

/***/ 5702:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _X3DChildObject_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(7503);
/* harmony import */ var _X3DConstants_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(8899);
/* harmony import */ var _Events_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(1542);
/* harmony import */ var _IterableWeakSet_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(7281);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(6707);





const
   _value               = Symbol (),
   _accessType          = Symbol (),
   _unit                = Symbol (),
   _references          = Symbol (),
   _referencesCallbacks = Symbol (),
   _fieldInterests      = Symbol (),
   _fieldCallbacks      = Symbol (),
   _inputRoutes         = Symbol (),
   _outputRoutes        = Symbol (),
   _routeCallbacks      = Symbol (),
   _appInfo             = Symbol (),
   _documentation       = Symbol (),
   _uniformLocation     = Symbol .for ("X_ITE.X3DField.uniformLocation");

const EMPTY = [ ];

function X3DField (value)
{
   _X3DChildObject_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .call (this);

   this [_value] = value;
}

Object .assign (Object .setPrototypeOf (X3DField .prototype, _X3DChildObject_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .prototype),
{
   [_value]: undefined,
   [_accessType]: _X3DConstants_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .initializeOnly,
   [_unit]: undefined,
   [_references]: null,
   [_referencesCallbacks]: null,
   [_fieldInterests]: null,
   [_fieldCallbacks]: null,
   [_inputRoutes]: null,
   [_outputRoutes]: null,
   [_routeCallbacks]: null,
   [_uniformLocation]: null,
   [_appInfo]: "",
   [_documentation]: "",
   create ()
   {
      return new (this .constructor) ();
   },
   equals (field)
   {
      return this [_value] === field .valueOf ();
   },
   assign (field)
   {
      // Assigns field to this field.
      this .set (field .getValue ());
      this .addEvent ();
   },
   set (value)
   {
      // Sets internal value without generating event.
      this [_value] = value;
   },
   setValue (value)
   {
      // Sets internal value and generates event.
      this .set (value instanceof this .constructor ? value .getValue () : value);
      this .addEvent ();
   },
   getValue ()
   {
      return this [_value];
   },
   getType ()
   {
      return this .constructor .type;
   },
   setAccessType (value)
   {
      this [_accessType] = value;
   },
   getAccessType ()
   {
      return this [_accessType];
   },
   isInitializable ()
   {
      return !! (this [_accessType] & _X3DConstants_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .initializeOnly);
   },
   isInput ()
   {
      return !! (this [_accessType] & _X3DConstants_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .inputOnly);
   },
   isOutput ()
   {
      return !! (this [_accessType] & _X3DConstants_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .outputOnly);
   },
   isReadable ()
   {
      return this [_accessType] !== _X3DConstants_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .inputOnly;
   },
   isWritable ()
   {
      return this [_accessType] !== _X3DConstants_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .outputOnly;
   },
   setUnit (value)
   {
      this [_unit] = value;
   },
   getUnit ()
   {
      return this [_unit];
   },
   isReference (accessType)
   {
      return accessType === this [_accessType] || accessType === _X3DConstants_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .inputOutput;
   },
   addReference (reference)
   {
      const references = this .getReferences ();

      if (references .has (reference))
         return;

      references .add (reference);

      // Create IS relationship

      switch (this .getAccessType () & reference .getAccessType ())
      {
         case _X3DConstants_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .initializeOnly:
            reference .addFieldInterest (this);
            this .processEvent (_Events_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .from (reference));
            break;
         case _X3DConstants_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .inputOnly:
            reference .addFieldInterest (this);
            break;
         case _X3DConstants_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .outputOnly:
            this .addFieldInterest (reference);
            break;
         case _X3DConstants_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .inputOutput:
            reference .addFieldInterest (this);
            this .addFieldInterest (reference);
            this .processEvent (_Events_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .from (reference));
            break;
      }

      this .processReferencesCallbacks ();
   },
   removeReference (reference)
   {
      this [_references] ?.delete (reference);

      // Create IS relationship

      switch (this .getAccessType () & reference .getAccessType ())
      {
         case _X3DConstants_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .initializeOnly:
            reference .removeFieldInterest (this);
            break;
         case _X3DConstants_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .inputOnly:
            reference .removeFieldInterest (this);
            break;
         case _X3DConstants_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .outputOnly:
            this .removeFieldInterest (reference);
            break;
         case _X3DConstants_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .inputOutput:
            reference .removeFieldInterest (this);
            this .removeFieldInterest (reference);
            break;
      }

      this .processReferencesCallbacks ();
   },
   getReferences ()
   {
      return this [_references] ??= new _IterableWeakSet_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A ();
   },
   addReferencesCallback (key, object)
   {
      this [_referencesCallbacks] = new Map (this [_referencesCallbacks]);

      this [_referencesCallbacks] .set (key, object);
   },
   removeReferencesCallback (key)
   {
      this [_referencesCallbacks] ?.delete (key);
   },
   getReferencesCallbacks ()
   {
      return this [_referencesCallbacks] ??= new Map ();
   },
   processReferencesCallbacks ()
   {
      for (const callback of this [_referencesCallbacks] ?.values () ?? EMPTY)
         callback ();
   },
   addFieldInterest (field)
   {
      // There must be no copy, because the event is not executed immediately.

      this .getFieldInterests () .add (field);
   },
   removeFieldInterest (field)
   {
      this [_fieldInterests] ?.delete (field);
   },
   getFieldInterests ()
   {
      return this [_fieldInterests] ??= new _IterableWeakSet_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A ();
   },
   addFieldCallback (key, object)
   {
      this [_fieldCallbacks] = new Map (this [_fieldCallbacks]);

      this [_fieldCallbacks] .set (key, object);
   },
   removeFieldCallback (key)
   {
      this [_fieldCallbacks] ?.delete (key);
   },
   getFieldCallbacks ()
   {
      return this [_fieldCallbacks] ??= new Map ();
   },
   addInputRoute (route)
   {
      this .getInputRoutes () .add (route);
      this .processRouteCallbacks ();
   },
   removeInputRoute (route)
   {
      this [_inputRoutes] ?.delete (route);

      this .processRouteCallbacks ();
   },
   getInputRoutes ()
   {
      return this [_inputRoutes] ??= new _IterableWeakSet_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A ();
   },
   addOutputRoute (route)
   {
      this .getOutputRoutes () .add (route);
      this .processRouteCallbacks ();
   },
   removeOutputRoute (route)
   {
      this [_outputRoutes] ?.delete (route);

      this .processRouteCallbacks ();
   },
   getOutputRoutes ()
   {
      return this [_outputRoutes] ??= new _IterableWeakSet_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A ();
   },
   addRouteCallback (key, object)
   {
      // Processed if routes are changed.

      this [_routeCallbacks] = new Map (this [_routeCallbacks]);

      this [_routeCallbacks] .set (key, object);
   },
   removeRouteCallback (key)
   {
      this [_routeCallbacks] ?.delete (key);
   },
   getRouteCallbacks ()
   {
      return this [_routeCallbacks] ??= new Map ();
   },
   processRouteCallbacks ()
   {
      for (const callback of this [_routeCallbacks] ?.values () ?? EMPTY)
         callback ();
   },
   processEvent (event = _Events_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .create (this))
   {
      event .add (this);

      this .setTainted (false);

      const field = event .field;

      if (field !== this)
         this .set (field .getValue (), field .length);

      // Process interests.

      this .processInterests ();

      // Process routes.

      let first = true;

      for (const field of this [_fieldInterests] ?? EMPTY)
      {
         if (event .has (field))
            continue;

         if (first)
         {
            first = false;
            field .addEventObject (this, event);
         }
         else
         {
            field .addEventObject (this, _Events_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .copy (event));
         }
      }

      if (first)
         _Events_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .push (event);

      // Process field callbacks.

      for (const callback of this [_fieldCallbacks] ?.values () ?? EMPTY)
         callback (this .valueOf ());
   },
   getAppInfo ()
   {
      return this [_appInfo];
   },
   setAppInfo (value)
   {
      this [_appInfo] = String (value);
   },
   setDocumentation (value)
   {
      this [_documentation] = String (value);
   },
   getDocumentation ()
   {
      return this [_documentation];
   },
   fromString (string, scene)
   {
      this .fromVRMLString (string, scene);
   },
   fromVRMLString (string, scene)
   {
      // Function will be overridden in VRMLParser.
   },
   fromXMLString (string, scene)
   {
      // Function will be overridden in XMLParser.
   },
   dispose ()
   {
      for (const reference of this [_references] ?? EMPTY)
         reference .removeFieldInterest (this);

      for (const route of Array .from (this [_inputRoutes] ?? EMPTY))
         route .dispose ();

      for (const route of Array .from (this [_outputRoutes] ?? EMPTY))
         route .dispose ();

      this [_references]          ?.clear ();
      this [_referencesCallbacks] ?.clear ();
      this [_fieldInterests]      ?.clear ();
      this [_fieldCallbacks]      ?.clear ();
      this [_inputRoutes]         ?.clear ();
      this [_outputRoutes]        ?.clear ();
      this [_routeCallbacks]      ?.clear ();

      _X3DChildObject_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .prototype .dispose .call (this);
   }
});

for (const key of Object .keys (X3DField .prototype))
   Object .defineProperty (X3DField .prototype, key, { enumerable: false });

const __default__ = X3DField;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .add ("X3DField", __default__));

/***/ }),

/***/ 5837:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Numbers_Matrix4_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(1048);
/* harmony import */ var _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(2639);
/* harmony import */ var _Algorithms_SAT_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(6313);
/* harmony import */ var _x_ite_Namespace_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(6707);




function Box3 (... args) /* size, center */
{
   this .matrix = new _Numbers_Matrix4_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A ();

   this .set (... arguments);
}

Object .assign (Box3 .prototype,
{
   copy ()
   {
      const copy = Object .create (Box3 .prototype);

      copy .matrix = this .matrix .copy ();

      return copy;
   },
   assign (box)
   {
      this .matrix .assign (box .matrix);

      return this;
   },
   equals (box)
   {
      return this .matrix .equals (box .matrix);
   },
   getMatrix ()
   {
      return this .matrix;
   },
   set (size, center)
   {
      switch (arguments .length)
      {
         case 0:
         {
            this .matrix .set (0, 0, 0, 0,
                               0, 0, 0, 0,
                               0, 0, 0, 0,
                               0, 0, 0, 0);

            return this;
         }
         case 2:
         {
            this .matrix .set (size .x / 2, 0, 0, 0,
                               0, size .y / 2, 0, 0,
                               0, 0, size .z / 2, 0,
                               center .x, center .y, center .z, 1);

            return this;
         }
         // case 3:
         // {
         //    console .trace ()
         //    return this .setExtents (arguments [0], arguments [1]);
         // }
      }
   },
   setExtents (min, max)
   {
      const
         sx = (max .x - min .x) / 2,
         sy = (max .y - min .y) / 2,
         sz = (max .z - min .z) / 2,
         cx = (max .x + min .x) / 2,
         cy = (max .y + min .y) / 2,
         cz = (max .z + min .z) / 2;

      this .matrix .set (sx, 0,  0,  0,
                         0,  sy, 0,  0,
                         0,  0,  sz, 0,
                         cx, cy, cz, 1);

      return this;
   },
   getExtents (min, max)
   {
      this .getAbsoluteExtents (min, max);

      min .add (this .center);
      max .add (this .center);
   },
   getAbsoluteExtents: (() =>
   {
      const
         r1 = new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (),
         p1 = new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (),
         p4 = new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A ();

      return function (min, max)
      {
         const
            m = this .matrix,
            x = m .X_AXIS,
            y = m .Y_AXIS,
            z = m .Z_AXIS;

         r1 .assign (y) .add (z);

         const r2 = z .subtract (y);

         p1 .assign (x) .add (r1),
         p4 .assign (x) .add (r2);

         const
            p2 = r1 .subtract (x),
            p3 = r2 .subtract (x);

         min .assign (p1) .min (p2, p3, p4);
         max .assign (p1) .max (p2, p3, p4);

         p1 .negate ();
         p2 .negate ();
         p3 .negate ();
         p4 .negate ();

         min .min (p1, p2, p3, p4);
         max .max (p1, p2, p3, p4);
      };
   })(),
   getPoints: (() =>
   {
      const
         x  = new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (),
         y  = new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (),
         z  = new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (),
         r1 = new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A ();

      return function (points)
      {
         /*
          * p6 ---------- p5
          * | \           | \
          * | p2------------ p1
          * |  |          |  |
          * |  |          |  |
          * p7 |_________ p8 |
          *  \ |           \ |
          *   \|            \|
          *    p3 ---------- p4
          */

         const m = this .matrix;

         x .assign (m .X_AXIS);
         y .assign (m .Y_AXIS);
         z .assign (m .Z_AXIS);

         r1 .assign (y) .add (z);

         const r2 = z .subtract (y);

         points [0] .assign (x)  .add (r1);
         points [1] .assign (r1) .subtract (x);
         points [2] .assign (r2) .subtract (x);
         points [3] .assign (x)  .add (r2);

         points [4] .assign (points [2]) .negate ();
         points [5] .assign (points [3]) .negate ();
         points [6] .assign (points [0]) .negate ();
         points [7] .assign (points [1]) .negate ();

         const center = this .center;

         points [0] .add (center);
         points [1] .add (center);
         points [2] .add (center);
         points [3] .add (center);

         points [4] .add (center);
         points [5] .add (center);
         points [6] .add (center);
         points [7] .add (center);

         return points;
      };
   })(),
   getAxes (axes)
   {
      const m = this .matrix;

      axes [0] .assign (m .X_AXIS);
      axes [1] .assign (m .Y_AXIS);
      axes [2] .assign (m .Z_AXIS);

      return axes;
   },
   getNormals: (() =>
   {
      const
         x = new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (),
         y = new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (),
         z = new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A ();

      const axes = [ _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .X_AXIS, _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .Y_AXIS, _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .Z_AXIS ];

      return function (normals)
      {
         const m = this .matrix;

         x .assign (m .X_AXIS);
         y .assign (m .Y_AXIS);
         z .assign (m .Z_AXIS);

         if (x .squaredNorm () === 0)
         {
            x .assign (y) .cross (z);

            if (x .squaredNorm () === 0)
            {
               for (const axis of axes)
               {
                  x .assign (axis) .cross (y);

                  if (x .squaredNorm () !== 0)
                     break;
               }

               if (x .squaredNorm () === 0)
               {
                  for (const axis of axes)
                  {
                     x .assign (axis) .cross (z);

                     if (x .squaredNorm () !== 0)
                        break;
                  }

                  if (x .squaredNorm () === 0)
                     x .assign (_Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .X_AXIS);
               }
            }
         }

         if (y .squaredNorm () === 0)
         {
            y .assign (z) .cross (x);

            if (y .squaredNorm () === 0)
            {
               for (const axis of axes)
               {
                  y .assign (axis) .cross (z);

                  if (y .squaredNorm () !== 0)
                     break;
               }

               if (y .squaredNorm () === 0)
               {
                  for (const axis of axes)
                  {
                     y .assign (axis) .cross (x);

                     if (y .squaredNorm () !== 0)
                        break;
                  }

                  if (y .squaredNorm () === 0)
                     y .assign (_Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .Y_AXIS);
               }
            }
         }

         if (z .squaredNorm () === 0)
         {
            z .assign (x) .cross (y);

            if (z .squaredNorm () === 0)
            {
               for (const axis of axes)
               {
                  z .assign (axis) .cross (x);

                  if (z .squaredNorm () !== 0)
                     break;
               }

               if (z .squaredNorm () === 0)
               {
                  for (const axis of axes)
                  {
                     z .assign (axis) .cross (y);

                     if (z .squaredNorm () !== 0)
                        break;
                  }

                  if (z .squaredNorm () === 0)
                     z .assign (_Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .Z_AXIS);
               }
            }
         }

         normals [0] .assign (y) .cross (z) .normalize ();
         normals [1] .assign (z) .cross (x) .normalize ();
         normals [2] .assign (x) .cross (y) .normalize ();

         return normals;
      };
   })(),
   isEmpty ()
   {
      return this .matrix [15] === 0;
   },
   add: (() =>
   {
      const
         lhs_min = new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (),
         lhs_max = new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (),
         rhs_min = new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (),
         rhs_max = new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A ();

      return function (box)
      {
         if (this .isEmpty ())
            return this .assign (box);

         if (box .isEmpty ())
            return this;

         this .getExtents (lhs_min, lhs_max);
         box  .getExtents (rhs_min, rhs_max);

         return this .setExtents (lhs_min .min (rhs_min), lhs_max .max (rhs_max));
      };
   })(),
   multLeft (matrix)
   {
      this .matrix .multLeft (matrix);
      return this;
   },
   multRight (matrix)
   {
      this .matrix .multRight (matrix);
      return this;
   },
   containsPoint: (() =>
   {
      const
         min = new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (),
         max = new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A ();

      return function (point)
      {
         this .getExtents (min, max);

         return min .x <= point .x &&
                max .x >= point .x &&
                min .y <= point .y &&
                max .y >= point .y &&
                min .z <= point .z &&
                max .z >= point .z;
      };
   })(),
   intersectsBox: (() =>
   {
      const
         points1 = Array .from ({ length: 8 }, () => new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A ()),
         points2 = Array .from ({ length: 8 }, () => new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A ()),
         axes1   = Array .from ({ length: 3 }, () => new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A ()),
         axes2   = Array .from ({ length: 3 }, () => new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A ()),
         axes9   = Array .from ({ length: 9 }, () => new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A ()),
         normals = Array .from ({ length: 3 }, () => new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A ());

      return function (other)
      {
         // Test special cases.

         if (this .isEmpty ())
            return false;

         if (other .isEmpty ())
            return false;

         // Get points.

         this  .getPoints (points1);
         other .getPoints (points2);

         // Test the three planes spanned by the normal vectors of the faces of the first parallelepiped.

         if (_Algorithms_SAT_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .isSeparated (this .getNormals (normals), points1, points2))
            return false;

         // Test the three planes spanned by the normal vectors of the faces of the second parallelepiped.

         if (_Algorithms_SAT_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .isSeparated (other .getNormals (normals), points1, points2))
            return false;

         // Test the nine other planes spanned by the edges of each parallelepiped.

         this  .getAxes (axes1);
         other .getAxes (axes2);

         for (let i1 = 0; i1 < 3; ++ i1)
         {
            for (let i2 = 0; i2 < 3; ++ i2)
               axes9 [i1 * 3 + i2] .assign (axes1 [i1]) .cross (axes2 [i2]);
         }

         if (_Algorithms_SAT_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .isSeparated (axes9, points1, points2))
            return false;

         // Both boxes intersect.

         return true;
      };
   })(),
   // import Triangle3 from "./Triangle3.js";
   // intersectsTriangle: (() =>
   // {
   //    const
   //       points1        = Array .from ({ length: 8 }, () => new Vector3 ()),
   //       axes1          = Array .from ({ length: 3 }, () => new Vector3 ()),
   //       axes9          = Array .from ({ length: 9 }, () => new Vector3 ()),
   //       normals        = Array .from ({ length: 3 }, () => new Vector3 ()),
   //       triangle       = [ ],
   //       triangleNormal = [ new Vector3 () ],
   //       triangleEdges  = Array .from ({ length: 3 }, () => new Vector3 ());

   //    return function (a, b, c)
   //    {
   //       // Test special cases.

   //       if (this .isEmpty ())
   //          return false;

   //       // Get points.

   //       this .getPoints (points1);

   //       triangle [0] = a;
   //       triangle [1] = b;
   //       triangle [2] = c;

   //       // Test the three planes spanned by the normal vectors of the faces of the first parallelepiped.

   //       if (SAT .isSeparated (this .getNormals (normals), points1, triangle))
   //          return false;

   //       // Test the normal of the triangle.

   //       Triangle3 .normal (a, b, c, triangleNormal [0]);

   //       if (SAT .isSeparated (triangleNormal, points1, triangle))
   //          return false;

   //       // Test the nine other planes spanned by the edges of each parallelepiped.

   //       this .getAxes (axes1);

   //       triangleEdges [0] .assign (a) .subtract (b);
   //       triangleEdges [1] .assign (b) .subtract (c);
   //       triangleEdges [2] .assign (c) .subtract (a);

   //       for (let i1 = 0; i1 < 3; ++ i1)
   //       {
   //          for (let i2 = 0; i2 < 3; ++ i2)
   //             axes9 [i1 * 3 + i2] .assign (axes1 [i1]) .cross (triangleEdges [i2]);
   //       }

   //       if (SAT .isSeparated (axes9, points1, triangle))
   //          return false;

   //       // Box and triangle intersect.

   //       return true;
   //    };
   // })(),
   toString ()
   {
      return `${this .size}, ${this .center}`;
   },
});

Object .assign (Box3,
{
   Extents (min, max)
   {
      return new Box3 () .setExtents (min, max);
   },
   Points (points)
   {
      const
         min = new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (Number .POSITIVE_INFINITY),
         max = new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (Number .NEGATIVE_INFINITY);

      for (const point of points)
      {
         min .min (point);
         max .max (point);
      }

      return new Box3 () .setExtents (min, max);
   },
});

Object .defineProperties (Box3 .prototype,
{
   size:
   {
      get: (() =>
      {
         const
            min = new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (),
            max = new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A ();

         return function ()
         {
            this .getAbsoluteExtents (min, max);

            return max .subtract (min);
         };
      })(),
      enumerable: true,
   },
   center:
   {
      get ()
      {
         return this .matrix .origin;
      },
      enumerable: true,
   },
});

const __default__ = Box3;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_x_ite_Namespace_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .add ("Box3", __default__));

/***/ }),

/***/ 5903:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Math_Algorithm_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(4559);
/* harmony import */ var _x_ite_Namespace_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(6707);


const _value = Symbol ();

function BitSet (value = 0)
{
   this [_value] = value >>> 0;
}

Object .assign (BitSet .prototype,
{
   *[Symbol .iterator] ()
   {
      let
         value = this [_value],
         index = 0;

      while (value)
      {
         if (value & 1)
            yield index;

         value >>>= 1;
         ++ index;
      }
   },
   get (index)
   {
      const mask = 1 << index;

      return !! (this [_value] & mask);
   },
   set (index, value)
   {
      if (value)
         this .add (index);
      else
         this .remove (index);
   },
   add (index, mask = 1)
   {
      this [_value] |= mask << index;
      this [_value] >>>= 0;
   },
   remove (index, mask = 1)
   {
      this [_value] &= ~(mask << index);
      this [_value] >>>= 0;
   },
   clear ()
   {
      this [_value] = 0;
   },
   *entries ()
   {
      for (const i of this)
         yield [i, i];
   },
   valueOf ()
   {
      return this [_value];
   },
   toString (radix)
   {
      return this [_value] .toString (radix);
   },
});

BitSet .prototype .keys   = BitSet .prototype [Symbol .iterator];
BitSet .prototype .values = BitSet .prototype [Symbol .iterator];

Object .defineProperty (BitSet .prototype, "size",
{
   get ()
   {
      return _Math_Algorithm_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .bitCount (this [_value]);
   },
});

const __default__ = BitSet;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_x_ite_Namespace_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .add ("BitSet", __default__));

/***/ }),

/***/ 5946:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _x_ite_Namespace_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6707);
class StopWatch
{
   #startTime = 0;
   #stopTime = 0;
   cycles = 0;
   elapsedTime = 0;

   start ()
   {
      this .#startTime = Date .now ();
   }

   stop ()
   {
      if (this .#startTime <= this .#stopTime)
         return;

      this .#stopTime    = Date .now ();
      this .cycles      += 1;
      this .elapsedTime += this .#stopTime - this .#startTime;
   }

   reset ()
   {
      this .#startTime  = 0;
      this .#stopTime   = 0;
      this .cycles      = 0;
      this .elapsedTime = 0;
   }

   get averageTime ()
   {
      return this .cycles ? this .elapsedTime / this .cycles : 0;
   }
}

const __default__ = StopWatch;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_x_ite_Namespace_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .add ("StopWatch", __default__));

/***/ }),

/***/ 5991:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Features_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6818);
/* harmony import */ var _BROWSER_VERSION_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(2850);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(6707);



const URLs =
{
   getScriptURL: (() =>
   {
      let src;

      switch (_Features_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .ENVIRONMENT)
      {
         case "NODE":
         {
            src = __webpack_require__.g .require ("url") .pathToFileURL (__filename) .href;
            break;
         }
         case "BROWSER":
         {
            src = document .currentScript ?.src ?? document .location .href;
            break;
         }
         case "MODULE":
         {
            // src = import .meta .url;
            break;
         }
      }

      // Prevent caching issues with jsDelivr and UNPKG.
      src = src .replace ("/x_ite@latest/", `/x_ite@${_BROWSER_VERSION_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A}/`);

      return function ()
      {
         return src;
      };
   })(),
   getProviderURL (component)
   {
      if (!component)
         return "https://create3000.github.io/x_ite/";

      const min = this .getScriptURL () .match (/\.min\.m?js$/) ? ".min" : "";

      return new URL (`assets/components/${component}Component${min}.js`, this .getScriptURL ()) .href;
   },
   getFontsURL (file)
   {
      return new URL (`assets/fonts/${file}`, this .getScriptURL ()) .href;
   },
   getLinetypeURL ()
   {
      return new URL ("assets/linetype/linetypes.png", this .getScriptURL ()) .href;
   },
   getHatchingURL (index)
   {
      return new URL (`assets/hatching/${index}.png`, this .getScriptURL ()) .href;
   },
   getLibraryURL (file)
   {
      return new URL (`assets/lib/${file}`, this .getScriptURL ()) .href;
   },
};

const __default__ = URLs;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .add ("URLs", __default__));

/***/ }),

/***/ 6029:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   l: () => (/* binding */ getUniqueName)
/* harmony export */ });
const getUniqueName = function (map, name = "")
{
   name = String (name);

   if (name && !map .has (name))
      return name;

   name = name .replace (/_\d+$/, "");

   if (name && !map .has (name))
      return name;

   let
      newName = "",
      lo,
      hi = 1;

   do
   {
      lo   = hi;
      hi <<= 1;

      newName = `${name}_${lo}`;
   }
   while (map .has (newName));

   lo >>>= 1;
   hi >>>= 1;

   if (lo && hi)
   {
      while (lo < hi)
      {
         const m = (lo + hi) >>> 1;

         if (map .has (`${name}_${m}`))
            lo = m + 1;
         else
            hi = m;
      }

      newName = `${name}_${lo}`;
   }

   return newName;
};


/***/ }),

/***/ 6253:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _x_ite_Namespace_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6707);
const a = [ ]; // more scratch
const b = [ ]; // more scratch
const z = [ ]; // more scratch

// Calculate eigenvalues and eigenvectors.
// This is from SGI Inventor Matrix.cpp.
function eigen_decomposition (matrix, result)
{
   const
      ORDER   = matrix .order,
      SIZE    = matrix .length,
      values  = result .values,
      vectors = result .vectors;

   let
      sm,         // smallest entry
      theta,      // angle for Jacobi rotation
      c, s, t,    // cosine, sine, tangent of theta
      tau,        // sine / (1 + cos)
      h, g,       // two scrap values
      thresh,     // threshold below which no rotation done
      p, q, i, j; // indices

   // initializations
   for (i = 0; i < ORDER; ++ i)
   {
      a [i] = a [i] ?? [ ];
      b [i] = values [i] = matrix .get1 (i, i);
      z [i] = 0;

      for (j = 0; j < ORDER; ++ j)
      {
         vectors [i] [j] = (i === j) ? 1 : 0;
         a [i] [j] = matrix .get1 (j, i);
      }
   }

   // Why 50? I don't know--it's the way the folks who wrote the
   // algorithm did it:
   for (i = 0; i < 50; ++ i)
   {
      sm = 0;

      for (p = 0; p < ORDER - 1; ++ p)
      {
         for (q = p + 1; q < ORDER; ++ q)
            sm += Math .abs (a [p] [q]);
      }

      if (sm === 0)
         break;

      thresh = i < 3 ?
         0.2 * sm / SIZE :
         0;

      for (p = 0; p < ORDER - 1; ++ p)
      {
         for (q = p + 1; q < ORDER; ++ q)
         {
            g = 100 * Math .abs (a [p] [q]);

            if (i > 3
                && (Math .abs (values [p]) + g === Math .abs (values [p]))
                && (Math .abs (values [q]) + g === Math .abs (values [q]))
            )
            {
               a [p] [q] = 0;
            }

            else if (Math .abs (a [p] [q]) > thresh)
            {
               h = values [q] - values [p];

               if (Math .abs (h) + g === Math .abs (h))
               {
                  t = a [p] [q] / h;
               }
               else
               {
                  theta = 0.5 * h / a [p] [q];
                  t     = 1 / (Math .abs (theta) + Math .sqrt (1 + theta * theta));

                  if (theta < 0)  t = -t;
               }
               // End of computing tangent of rotation angle

               c           = 1 / Math .sqrt (1 + t * t);
               s           = t * c;
               tau         = s / (1 + c);
               h           = t * a [p] [q];
               z [p]      -= h;
               z [q]      += h;
               values [p] -= h;
               values [q] += h;
               a [p] [q]   = 0;

               for (j = 0; j < p; ++ j)
               {
                  g = a [j] [p];
                  h = a [j] [q];
                  a [j] [p] = g - s * (h + g * tau);
                  a [j] [q] = h + s * (g - h * tau);
               }

               for (j = p + 1; j < q; ++ j)
               {
                  g = a [p] [j];
                  h = a [j] [q];
                  a [p] [j] = g - s * (h + g * tau);
                  a [j] [q] = h + s * (g - h * tau);
               }

               for (j = q + 1; j < ORDER; ++ j)
               {
                  g = a [p] [j];
                  h = a [q] [j];
                  a [p] [j] = g - s * (h + g * tau);
                  a [q] [j] = h + s * (g - h * tau);
               }

               for (j = 0; j < ORDER; ++ j)
               {
                  g = vectors [j] [p];
                  h = vectors [j] [q];
                  vectors [j] [p] = g - s * (h + g * tau);
                  vectors [j] [q] = h + s * (g - h * tau);
               }
            }
         }
      }

      for (p = 0; p < ORDER; ++ p)
      {
         values [p] = b [p] += z [p];
         z [p] = 0;
      }
   }

   return result;
}

const __default__ = eigen_decomposition;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_x_ite_Namespace_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .add ("eigen_decomposition", __default__));

/***/ }),

/***/ 6313:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _x_ite_Namespace_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6707);
const
   extents1 = { min: 0, max: 0 },
   extents2 = { min: 0, max: 0 };

/**
 *  Class to represent the Separating Axis Theorem.
 */
function SAT () { }

SAT .isSeparated = function (axes, points1, points2)
{
   // https://gamedev.stackexchange.com/questions/25397/obb-vs-obb-collision-detection

   for (const axis of axes)
   {
      project (points1, axis, extents1);
      project (points2, axis, extents2);

      if (overlaps (extents1 .min, extents1 .max, extents2 .min, extents2 .max))
         continue;

      return true;
   }

   return false;
};

///  Projects @a points to @a axis and returns the minimum and maximum bounds.
function project (points, axis, extents)
{
   extents .min = Number .POSITIVE_INFINITY;
   extents .max = Number .NEGATIVE_INFINITY;

   for (const point of points)
   {
      // Just dot it to get the min and max along this axis.
      // NOTE: the axis must be normalized to get accurate projections to calculate the MTV, but if it is only needed to
      // know whether it overlaps, every axis can be used.

      const dotVal = point .dot (axis);

      if (dotVal < extents .min)
         extents .min = dotVal;

      if (dotVal > extents .max)
         extents .max = dotVal;
   }
}

///  Returns true if both ranges overlap, otherwise false.
function overlaps (min1, max1, min2, max2)
{
   return is_between (min2, min1, max1) || is_between (min1, min2, max2);
}

///  Returns true if @a value is between @a lowerBound and @a upperBound, otherwise false.
function is_between (value, lowerBound, upperBound)
{
   return lowerBound <= value && value <= upperBound;
}

const __default__ = SAT;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_x_ite_Namespace_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .add ("SAT", __default__));

/***/ }),

/***/ 6362:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Fields_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(564);
/* harmony import */ var _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(8311);
/* harmony import */ var _Base_FieldDefinitionArray_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(6973);
/* harmony import */ var _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(8415);
/* harmony import */ var _X3DInterpolatorNode_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(9825);
/* harmony import */ var _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(8899);
/* harmony import */ var _standard_Math_Algorithm_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(4559);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(6707);








function ScalarInterpolator (executionContext)
{
   _X3DInterpolatorNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .call (this, executionContext);

   this .addType (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .ScalarInterpolator);
}

Object .assign (Object .setPrototypeOf (ScalarInterpolator .prototype, _X3DInterpolatorNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .prototype),
{
   initialize ()
   {
      _X3DInterpolatorNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .prototype .initialize .call (this);

      this ._keyValue .addInterest ("set_keyValue__", this);
   },
   set_keyValue__ ()
   {
      const
         key      = this ._key,
         keyValue = this ._keyValue;

      if (keyValue .length < key .length)
         keyValue .resize (key .length, keyValue .length ? keyValue [keyValue .length - 1] : 0);

      // If there was already an set_fraction event in this frame, send a new value_changed to prevent glitches.
      if (this ._set_fraction .getModificationTime () >= this .getBrowser () .getCurrentTime ())
         this .set_fraction__ ();
   },
   interpolate (index0, index1, weight)
   {
      this ._value_changed = _standard_Math_Algorithm_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .lerp (this ._keyValue [index0], this ._keyValue [index1], weight);
   },
});

Object .defineProperties (ScalarInterpolator,
{
   ... _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .getStaticProperties ("ScalarInterpolator", "Interpolation", 1, "children", "2.0"),
   fieldDefinitions:
   {
      value: new _Base_FieldDefinitionArray_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A ([
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .inputOutput, "metadata",      new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFNode ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .inputOnly,   "set_fraction",  new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFFloat ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .inputOutput, "key",           new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFFloat ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .inputOutput, "keyValue",      new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFFloat ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .outputOnly,  "value_changed", new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFFloat ()),
      ]),
      enumerable: true,
   },
});

const __default__ = ScalarInterpolator;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .add ("ScalarInterpolator", __default__));

/***/ }),

/***/ 6685:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6707);
const RenderPass =
{
   // Bits
   NONE:               0b00,
   VOLUME_SCATTER_BIT: 0b01,
   TRANSMISSION_BIT:   0b10,
   // Keys
   RENDER_KEY:         0,
   VOLUME_SCATTER_KEY: 1,
   TRANSMISSION_KEY:   2,
};

const __default__ = RenderPass;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .add ("RenderPass", __default__));

/***/ }),

/***/ 6707:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
const Namespace = { };

Object .defineProperty (Namespace, "add",
{
   value (name, module)
   {
      if (Namespace .hasOwnProperty (name))
      {
         console .error (new Error (`Namespace: "${name}" already exists.`));
         return module;
      }

      const X3D = window [Symbol .for ("X_ITE.X3D-12.2.3")];

      if (X3D)
         X3D [name] = module;

      // For x_ite.js:
      return Namespace [name] = module;
   },
});

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Namespace .add ("Namespace", Namespace));


/***/ }),

/***/ 6818:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _DEVELOPMENT_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(2084);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(6707);


const MODULE = false;

const Features =
{
   get ENVIRONMENT ()
   {
      if (_DEVELOPMENT_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A)
         return "BROWSER";

      if (MODULE)
         return "MODULE";

      if ((typeof process === "object") && (process ?.release ?.name ?.match ?.(/node|io.js/)))
         return "NODE";

      return "BROWSER";
   },
   WEAK_REF: typeof WeakRef !== "undefined",
   FINALIZATION_REGISTRY: typeof FinalizationRegistry !== "undefined",
};

(() =>
{
   // Added at February 2022
   // https://github.com/tc39/proposal-relative-indexing-method#polyfill

   function at (n)
   {
      // ToInteger() abstract op
      n = Math.trunc(n) || 0;
      // Allow negative indexing from the end
      if (n < 0) n += this.length;
      // OOB access is guaranteed to return undefined
      if (n < 0 || n >= this.length) return undefined;
      // Otherwise, this is just normal property access
      return this[n];
   }

   const TypedArray = Reflect .getPrototypeOf (Int8Array);
   for (const C of [Array, String, TypedArray])
   {
      if (C .prototype .at === undefined)
      {
         Object .defineProperty (C .prototype, "at",
         {
            value: at,
            writable: true,
            enumerable: false,
            configurable: true,
         });
      }
   }
})();

(() =>
{
   if (!Features .WEAK_REF)
   {
      if (_DEVELOPMENT_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A)
         console .info ("Added shim for WeakRef.");

      window .WeakRef = class WeakRef
      {
         #object;

         constructor (object)
         {
            this .#object = object;
         }

         deref ()
         {
            return this .#object;
         }
      };
   }

   if (!Features .FINALIZATION_REGISTRY)
   {
      if (_DEVELOPMENT_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A)
         console .info ("Added shim for FinalizationRegistry.");

      window .FinalizationRegistry = class FinalizationRegistry
      {
         register () { }
         unregister () { }
      };
   }
})();

(() =>
{
   // https://tc39.es/proposal-upsert/

   for (const Class of [Map, WeakMap])
   {
      Class .prototype .getOrInsert ??= function (key, value)
      {
         if (this .has (key))
            return this .get (key);

         this .set (key, value);

         return value;
      };
   }

   for (const Class of [Map, WeakMap])
   {
      Class .prototype .getOrInsertComputed ??= function (key, callbackfn)
      {
         if (this .has (key))
            return this .get (key);

         const value = callbackfn (key);

         this .set (key, value);

         return value;
      };
   }
})();

const __default__ = Features;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .add ("Features", __default__));

/***/ }),

/***/ 6832:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(2639);
/* harmony import */ var _x_ite_Namespace_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(6707);


const Camera =
{
   frustum (l, r, b, t, n, f, matrix)
   {
      const
         r_l = r - l,
         t_b = t - b,
         f_n = f - n,
         n_2 = 2 * n,

         A = (r + l) / r_l,
         B = (t + b) / t_b,
         C = -(f + n) / f_n,
         D = -(n_2 * f) / f_n,
         E = n_2 / r_l,
         F = n_2 / t_b;

      return matrix .set (E, 0, 0, 0,
                          0, F, 0, 0,
                          A, B, C, -1,
                          0, 0, D, 0);
   },
   perspective (fieldOfView, zNear, zFar, width, height, matrix)
   {
      const ratio = Math .tan (fieldOfView / 2) * zNear;

      if (width > height)
      {
         const aspect = width * ratio / height;
         return this .frustum (-aspect, aspect, -ratio, ratio, zNear, zFar, matrix);
      }
      else
      {
         const aspect = height * ratio / width;
         return this .frustum (-ratio, ratio, -aspect, aspect, zNear, zFar, matrix);
      }
   },
   perspective2 (fieldOfView, zNear, zFar, width, height, matrix)
   {
      const ratio = Math .tan (fieldOfView / 2) * zNear;

      return this .frustum (-ratio, ratio, -ratio, ratio, zNear, zFar, matrix);
   },
   ortho (l, r, b, t, n, f, matrix)
   {
      const
         r_l = r - l,
         t_b = t - b,
         f_n = f - n,

         A =  2 / r_l,
         B =  2 / t_b,
         C = -2 / f_n,
         D = -(r + l) / r_l,
         E = -(t + b) / t_b,
         F = -(f + n) / f_n;

      return matrix .set (A, 0, 0, 0,
                          0, B, 0, 0,
                          0, 0, C, 0,
                          D, E, F, 1);
   },
   orthoBox: (() =>
   {
      const
         min = new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A (),
         max = new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A ();

      return function (box, matrix)
      {
         box .getExtents (min, max);

         return this .ortho (min .x, max .x, min .y, max .y, -max .z, -min .z, matrix);
      };
   })(),
};

const __default__ = Camera;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_x_ite_Namespace_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .add ("Camera", __default__));

/***/ }),

/***/ 6882:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _SFNode_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(1426);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(6707);


const cache = new WeakMap ();

// const r = new FinalizationRegistry (t => console .error (`object deleted ${--i} ${t}`));
// let i = 0;

const SFNodeCache =
{
   get (baseNode)
   {
      const node = cache .get (baseNode);

      if (node)
      {
         return node;
      }
      else
      {
         const node = new _SFNode_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A (baseNode);

         this .set (baseNode, node);

         // i += 2;
         // console .warn (`baseNode ${i} ${baseNode .getTypeName ()}`);
         // r .register (baseNode, `baseNode ${baseNode .getTypeName ()}`);
         // r .register (node, `node ${baseNode .getTypeName ()}`);

         return node;
      }
   },
   set (baseNode, node)
   {
      Object .defineProperty (node, "dispose",
      {
         value: dispose,
         writable: true,
         configurable: true,
      });

      // WeakMap allows associating data to objects in a way that doesn't prevent
      // the key objects from being collected, even if the values reference the keys.
      // https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/WeakMap
      cache .set (baseNode, node);
   },
   delete (baseNode)
   {
      cache .delete (baseNode);
   },
};

function dispose ()
{
   this .getValue () ?.dispose ();

   _SFNode_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .prototype .dispose .call (this);
}

const __default__ = SFNodeCache;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .add ("SFNodeCache", __default__));

/***/ }),

/***/ 6973:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _X3DInfoArray_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(4635);
/* harmony import */ var _X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(8311);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(6707);



function FieldDefinitionArray (values = [ ])
{
   return _X3DInfoArray_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .call (this, Array .from (values, value => [value .name, value]), _X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A);
}

Object .setPrototypeOf (FieldDefinitionArray .prototype, _X3DInfoArray_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .prototype);

for (const key of Object .keys (FieldDefinitionArray .prototype))
   Object .defineProperty (FieldDefinitionArray .prototype, key, { enumerable: false });

Object .defineProperties (FieldDefinitionArray,
{
   typeName:
   {
      value: "FieldDefinitionArray",
      enumerable: true,
   },
});

const __default__ = FieldDefinitionArray;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .add ("FieldDefinitionArray", __default__));

/***/ }),

/***/ 7071:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Base_X3DInfoArray_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(4635);
/* harmony import */ var _X3DProtoDeclaration_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(5317);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(6707);



function ProtoDeclarationArray (values = [ ])
{
   return _Base_X3DInfoArray_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .call (this, Array .from (values, value => [value .name, value]), _X3DProtoDeclaration_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A);
}

Object .setPrototypeOf (ProtoDeclarationArray .prototype, _Base_X3DInfoArray_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .prototype);

for (const key of Object .keys (ProtoDeclarationArray .prototype))
   Object .defineProperty (ProtoDeclarationArray .prototype, key, { enumerable: false });

Object .defineProperties (ProtoDeclarationArray,
{
   typeName:
   {
      value: "ProtoDeclarationArray",
      enumerable: true,
   },
});

const __default__ = ProtoDeclarationArray;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .add ("ProtoDeclarationArray", __default__));

/***/ }),

/***/ 7097:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  A: () => (/* binding */ Rendering_X3DGeometryNode)
});

// EXTERNAL MODULE: ./src/x_ite/Fields.js + 15 modules
var Fields = __webpack_require__(564);
// EXTERNAL MODULE: ./src/x_ite/Rendering/VertexArray.js
var VertexArray = __webpack_require__(7513);
// EXTERNAL MODULE: ./src/x_ite/Components/Core/X3DNode.js
var X3DNode = __webpack_require__(8415);
// EXTERNAL MODULE: ./src/x_ite/Base/X3DConstants.js
var X3DConstants = __webpack_require__(8899);
// EXTERNAL MODULE: ./src/x_ite/Base/X3DCast.js
var X3DCast = __webpack_require__(4667);
// EXTERNAL MODULE: ./src/x_ite/Browser/Networking/URLs.js
var URLs = __webpack_require__(5991);
// EXTERNAL MODULE: ./src/x_ite/Namespace.js
var Namespace = __webpack_require__(6707);
;// ./src/x_ite/Browser/Rendering/MikkTSpace.js


// See: https://github.com/donmccurdy/mikktspace-wasm

const __default__ = new class MikkTSpace
{
   #promise;

   async initialize ()
   {
      return this .#promise = this .#promise ?? new Promise (async resolve =>
      {
         const imports =
         {
            wbg:
            {
               __wbindgen_string_new: (arg0, arg1) =>
               {
                  const ret = this .#getStringFromWasm0 (arg0, arg1);

                  return this .#addHeapObject (ret);
               },
               __wbindgen_rethrow: (arg0) =>
               {
                  throw this .#takeObject (arg0);
               },
            },
         };

         const input = await fetch (URLs/* default */.A .getLibraryURL ("mikktspace_bg.wasm"));

         const { instance } = await this .#load (input, imports);

         this .#wasm = instance .exports;

         resolve ();
      });
   }

   isInitialized ()
   {
      return !! this .#wasm;
   }

   async #load (response, imports)
   {
      if (typeof WebAssembly .instantiateStreaming === "function")
      {
         try
         {
            return await WebAssembly .instantiateStreaming (response, imports);
         }
         catch (error)
         {
            if (response .headers .get ("Content-Type") !== "application/wasm")
            {
               // console .warn ("`WebAssembly.instantiateStreaming` failed because your server does not serve wasm with `application/wasm` MIME type. Falling back to `WebAssembly.instantiate` which is slower. Original error:\n", error);
            }
            else
            {
               throw error;
            }
         }
      }

      const bytes = await response .arrayBuffer ();

      return await WebAssembly .instantiate (bytes, imports);
   }

   /**
   * Generates vertex tangents for the given position/normal/texcoord attributes.
   * @param {Float32Array} position vec3
   * @param {Float32Array} normal vec3
   * @param {Float32Array} texcoord vec2
   * @returns {Float32Array} vec4
   */
   generateTangents (position, normal, texcoord)
   {
      try
      {
         const
            retptr = this .#wasm .__wbindgen_add_to_stack_pointer (-16),
            ptr0   = this .#passArrayF32ToWasm0 (position, this .#wasm .__wbindgen_malloc),
            len0   = this .#WASM_VECTOR_LEN,
            ptr1   = this .#passArrayF32ToWasm0 (normal, this .#wasm .__wbindgen_malloc),
            len1   = this .#WASM_VECTOR_LEN,
            ptr2   = this .#passArrayF32ToWasm0 (texcoord, this .#wasm .__wbindgen_malloc),
            len2   = this .#WASM_VECTOR_LEN;

         this .#wasm .generateTangents (retptr, ptr0, len0, ptr1, len1, ptr2, len2);

         const
            r0 = this .#getInt32Memory0 () [retptr / 4 + 0],
            r1 = this .#getInt32Memory0 () [retptr / 4 + 1],
            v3 = this .#getArrayF32FromWasm0 (r0, r1) .slice ();

         this .#wasm .__wbindgen_free (r0, r1 * 4);

         return v3;
      }
      finally
      {
         this .#wasm .__wbindgen_add_to_stack_pointer (16);
      }
   }

   #wasm;
   #textDecoder = new TextDecoder ("utf-8", { ignoreBOM: true, fatal: true });
   #uint8Memory0;

   #getUint8Memory0 ()
   {
      if (this .#uint8Memory0 ?.buffer !== this .#wasm .memory .buffer)
         this .#uint8Memory0 = new Uint8Array (this .#wasm .memory .buffer);

      return this .#uint8Memory0;
   }

   #getStringFromWasm0 (ptr, len)
   {
      return this .#textDecoder .decode (this .#getUint8Memory0 () .subarray (ptr, ptr + len));
   }

   #heap = Array .from ({ length: 32 }) .concat ([undefined, null, true, false]);
   #heap_next = this .#heap .length;

   #addHeapObject (obj)
   {
      if (this .#heap_next === this .#heap .length)
         this .#heap .push (this .#heap .length + 1);

      const i = this .#heap_next;

      this .#heap_next = this .#heap [i];
      this .#heap [i]  = obj;

      return i;
   }

   #getObject (i)
   {
      return this .#heap [i];
   }

   #dropObject (i)
   {
      if (i < 36)
         return;

      this .#heap [i] = this .#heap_next;

      this .#heap_next = i;
   }

   #takeObject (i)
   {
      const ret = this .#getObject (i);

      this .#dropObject (i);

      return ret;
   }

   #float32Memory0;

   #getFloat32Memory0 ()
   {
      if (this .#float32Memory0 ?.buffer !== this .#wasm .memory .buffer)
         this .#float32Memory0 = new Float32Array (this .#wasm .memory .buffer);

      return this .#float32Memory0;
   }

   #WASM_VECTOR_LEN = 0;

   #passArrayF32ToWasm0 (arg, malloc)
   {
      const ptr = malloc (arg .length * 4);

      this .#getFloat32Memory0 () .set (arg, ptr / 4);

      this .#WASM_VECTOR_LEN = arg .length;

      return ptr;
   }

   #int32Memory0;

   #getInt32Memory0 ()
   {
      if (this .#int32Memory0 ?.buffer !== this .#wasm .memory .buffer)
         this .#int32Memory0 = new Int32Array (this .#wasm .memory .buffer);

      return this .#int32Memory0;
   }

   #getArrayF32FromWasm0 (ptr, len)
   {
      return this .#getFloat32Memory0 () .subarray (ptr / 4, ptr / 4 + len);
   }
};
;

/* harmony default export */ const MikkTSpace = (Namespace/* default */.A .add ("MikkTSpace", __default__));
// EXTERNAL MODULE: ./src/standard/Math/Numbers/Vector3.js
var Vector3 = __webpack_require__(2639);
// EXTERNAL MODULE: ./src/standard/Math/Numbers/Vector4.js
var Vector4 = __webpack_require__(3630);
// EXTERNAL MODULE: ./src/standard/Math/Numbers/Matrix4.js
var Matrix4 = __webpack_require__(1048);
// EXTERNAL MODULE: ./src/standard/Math/Geometry/Box3.js
var Box3 = __webpack_require__(5837);
// EXTERNAL MODULE: ./src/standard/Math/Geometry/Plane3.js
var Plane3 = __webpack_require__(4828);
// EXTERNAL MODULE: ./src/standard/Math/Algorithm.js
var Algorithm = __webpack_require__(4559);
// EXTERNAL MODULE: ./src/x_ite/DEVELOPMENT.js
var DEVELOPMENT = __webpack_require__(2084);
;// ./src/x_ite/Components/Rendering/X3DGeometryNode.js














// Box normals for bbox / line intersection.
const boxNormals = [
   Vector3/* default */.A .Z_AXIS,          // front
   Vector3/* default */.A .NEGATIVE_Z_AXIS, // back
   Vector3/* default */.A .Y_AXIS,          // top
   Vector3/* default */.A .NEGATIVE_Y_AXIS, // bottom
   Vector3/* default */.A .X_AXIS,          // right
   // left: We do not need to test for left.
];

function X3DGeometryNode (executionContext)
{
   X3DNode/* default */.A .call (this, executionContext);

   this .addType (X3DConstants/* default */.A .X3DGeometryNode);

   this .addChildObjects (X3DConstants/* default */.A .outputOnly, "transparent",  new Fields/* default */.A .SFBool (),
                          X3DConstants/* default */.A .outputOnly, "bbox_changed", new Fields/* default */.A .SFTime (),
                          X3DConstants/* default */.A .outputOnly, "rebuild",      new Fields/* default */.A .SFTime (Date .now () / 1000));

   // Members

   this .min                      = new Vector3/* default */.A ();
   this .max                      = new Vector3/* default */.A ();
   this .bbox                     = Box3/* default */.A .Extents (this .min, this .max);
   this .solid                    = true;
   this .geometryType             = 3;
   this .colorMaterial            = false;
   this .attribNodes              = [ ];
   this .attribArrays             = [ ];
   this .textureCoordinateMapping = new Map ();
   this .multiTexCoords           = [ ];
   this .coordIndices             = X3DGeometryNode .createArray ();
   this .texCoords                = X3DGeometryNode .createArray ();
   this .fogDepths                = X3DGeometryNode .createArray ();
   this .colors                   = X3DGeometryNode .createArray ();
   this .tangents                 = X3DGeometryNode .createArray ();
   this .normals                  = X3DGeometryNode .createArray ();
   this .vertices                 = X3DGeometryNode .createArray ();
   this .hasFogCoords             = false;
   this .hasNormals               = false;
   this .geometryKey              = "";
   this .vertexCount              = 0;
   this .planes                   = [ ];

   for (let i = 0; i < 5; ++ i)
      this .planes [i] = new Plane3/* default */.A ();
}

class GeometryArray extends Array
{
   #typedArray = new Float32Array ();

   assign (value)
   {
      const length = value .length;

      this .length = length;

      for (let i = 0; i < length; ++ i)
         this [i] = value [i];
   }

   getValue ()
   {
      return this .#typedArray;
   }

   shrinkToFit ()
   {
      if (this .length === this .#typedArray .length)
         this .#typedArray .set (this);
      else
         this .#typedArray = new Float32Array (this);

      return this .#typedArray;
   }
}

Object .defineProperty (X3DGeometryNode, "createArray",
{
   // Function to select ether Array or MFFloat for color/normal/vertex arrays.
   // Array version runs faster, see BeyondGermany and TreasureIsland.
   value ()
   {
      // return new Fields .MFFloat ();

      return new GeometryArray ();
   },
})

Object .assign (Object .setPrototypeOf (X3DGeometryNode .prototype, X3DNode/* default */.A .prototype),
{
   setup ()
   {
      X3DNode/* default */.A .prototype .setup .call (this);

      this .rebuild ();
   },
   initialize ()
   {
      X3DNode/* default */.A .prototype .initialize .call (this);

      const
         browser = this .getBrowser (),
         gl      = browser .getContext ();

      this .getLive () .addInterest ("set_live__", this);

      this .addInterest ("requestRebuild", this);
      this ._rebuild .addInterest ("rebuild", this);

      this .coordIndexBuffer      = gl .createBuffer ();
      this .attribBuffers         = [ ];
      this .textureCoordinateNode = browser .getDefaultTextureCoordinate ();
      this .texCoordBuffers       = Array .from ({length: browser .getMaxTexCoords ()}, () => gl .createBuffer ());
      this .fogDepthBuffer        = gl .createBuffer ();
      this .colorBuffer           = gl .createBuffer ();
      this .tangentBuffer         = gl .createBuffer ();
      this .normalBuffer          = gl .createBuffer ();
      this .vertexBuffer          = gl .createBuffer ();
      this .vertexArrayObject     = new VertexArray/* default */.A (gl);

      this .setCCW (true);
      this .set_live__ ();
   },
   getGeometryType ()
   {
      return this .geometryType;
   },
   setGeometryType (value)
   {
      this .geometryType = value;
   },
   setTransparent (value)
   {
      if (!!value !== this ._transparent .getValue ())
         this ._transparent = value;
   },
   isTransparent ()
   {
      return this ._transparent .getValue ();
   },
   getBBox ()
   {
      // With screen matrix applied.
      return this .bbox;
   },
   setBBox (bbox)
   {
      if (bbox .equals (this .bbox))
         return;

      bbox .getExtents (this .min, this .max);

      this .bbox .assign (bbox);

      for (let i = 0; i < 5; ++ i)
         this .planes [i] .set (i % 2 ? this .min : this .max, boxNormals [i]);

      this ._bbox_changed .addEvent ();
   },
   getMin ()
   {
      // With screen matrix applied.
      return this .min;
   },
   getMax ()
   {
      // With screen matrix applied.
      return this .max;
   },
   getMatrix ()
   {
      return Matrix4/* default */.A .IDENTITY;
   },
   setSolid (value)
   {
      this .solid = value;
   },
   isSolid ()
   {
      return this .solid;
   },
   setCCW (value)
   {
      const gl = this .getBrowser () .getContext ();

      this .frontFace = value ? gl .CCW : gl .CW;
      this .backFace  = value ? gl .CW  : gl .CCW;
   },
   getCoordIndices ()
   {
      return this .coordIndices;
   },
   getAttrib ()
   {
      return this .attribNodes;
   },
   getAttribs ()
   {
      return this .attribArrays;
   },
   getAttribBuffers ()
   {
      return this .attribBuffers;
   },
   getFogDepths ()
   {
      return this .fogDepths;
   },
   getColors ()
   {
      return this .colors;
   },
   getMultiTexCoords ()
   {
      return this .multiTexCoords;
   },
   getTexCoords ()
   {
      return this .texCoords;
   },
   getTextureCoordinate ()
   {
      return this .textureCoordinateNode;
   },
   setTextureCoordinate (value)
   {
      this .textureCoordinateNode .removeInterest ("updateTextureCoordinateMapping", this);

      this .textureCoordinateNode = value ?? this .getBrowser () .getDefaultTextureCoordinate ();

      this .textureCoordinateNode .addInterest ("updateTextureCoordinateMapping", this);

      this .updateTextureCoordinateMapping ();
   },
   getTextureCoordinateMapping ()
   {
      return this .textureCoordinateMapping;
   },
   updateTextureCoordinateMapping ()
   {
      this .textureCoordinateMapping .clear ();

      this .textureCoordinateNode .getTextureCoordinateMapping (this .textureCoordinateMapping);
   },
   getTangents ()
   {
      return this .tangents;
   },
   getNormals ()
   {
      return this .normals;
   },
   getVertices ()
   {
      return this .vertices;
   },
   updateVertexArrays ()
   {
      this .vertexArrayObject .update ();

      this .updateInstances = true;
   },
   generateTexCoords ()
   {
      const texCoords = this .texCoords;

      if (texCoords .length === 0)
      {
         const
            p         = this .getTexCoordParams (),
            min       = p .min,
            Sindex    = p .Sindex,
            Tindex    = p .Tindex,
            Ssize     = p .Ssize,
            S         = min [Sindex],
            T         = min [Tindex],
            vertices  = this .vertices .getValue (),
            length    = vertices .length;

         for (let i = 0; i < length; i += 4)
         {
            texCoords .push ((vertices [i + Sindex] - S) / Ssize,
                             (vertices [i + Tindex] - T) / Ssize,
                             0,
                             1);
         }

         texCoords .shrinkToFit ();
      }

      this .getMultiTexCoords () .push (texCoords);
   },
   getTexCoordParams: (() =>
   {
      const texCoordParams = { min: new Vector3/* default */.A (), Ssize: 0, Sindex: 0, Tindex: 0 };

      return function ()
      {
         const
            bbox  = this .getBBox (),
            size  = bbox .size,
            Xsize = size .x,
            Ysize = size .y,
            Zsize = size .z;

         texCoordParams .min .assign (bbox .center) .subtract (size .divide (2));

         if ((Xsize >= Ysize) && (Xsize >= Zsize))
         {
            // X size largest
            texCoordParams .Ssize  = Xsize;
            texCoordParams .Sindex = 0;

            if (Ysize >= Zsize)
               texCoordParams .Tindex = 1;
            else
               texCoordParams .Tindex = 2;
         }
         else if ((Ysize >= Xsize) && (Ysize >= Zsize))
         {
            // Y size largest
            texCoordParams .Ssize  = Ysize;
            texCoordParams .Sindex = 1;

            if (Xsize >= Zsize)
               texCoordParams .Tindex = 0;
            else
               texCoordParams .Tindex = 2;
         }
         else
         {
            // Z is the largest
            texCoordParams .Ssize  = Zsize;
            texCoordParams .Sindex = 2;

            if (Xsize >= Ysize)
               texCoordParams .Tindex = 0;
            else
               texCoordParams .Tindex = 1;
         }

         return texCoordParams;
      };
   })(),
   generateTangents ()
   {
      try
      {
         if (this .geometryType < 2)
            return;

         if (!this .vertices .length)
            return;

         if (!MikkTSpace .isInitialized ())
         {
            return void (MikkTSpace .initialize () .then (() =>
            {
               this .generateTangents ();
               this .transfer ();
               this .updateGeometryKey ();
               this .updateRenderFunctions ();
               this .getBrowser () .addBrowserEvent ();
            }));
         }

         const
            vertices  = this .vertices .getValue () .filter ((v, i) => i % 4 < 3),
            normals   = this .normals .getValue (),
            texCoords = this .multiTexCoords [0] .getValue () .filter ((v, i) => i % 4 < 2),
            tangents  = MikkTSpace .generateTangents (vertices, normals, texCoords),
            length    = tangents .length;

         // Convert coordinate system handedness to respect output format of MikkTSpace.
         for (let i = 3; i < length; i += 4)
            tangents [i] = -tangents [i]; // Flip w-channel.

         this .tangents .assign (tangents);
         this .tangents .shrinkToFit ();
      }
      catch (error)
      {
         if (DEVELOPMENT/* default */.A)
            console .error (error);
      }
   },
   refineNormals (normalIndex, normals, creaseAngle)
   {
      if (creaseAngle <= 0)
         return normals;

      const
         cosCreaseAngle = Math .cos (Algorithm/* default */.A .clamp (creaseAngle, 0, Math .PI)),
         refinedNormals = [ ];

      for (const vertex of normalIndex .values ())
      {
         for (const p of vertex)
         {
            const
               P = normals [p],
               N = new Vector3/* default */.A ();

            for (const q of vertex)
            {
               const Q = normals [q];

               if (Q .dot (P) > cosCreaseAngle)
                  N .add (Q);
            }

            refinedNormals [p] = N .normalize ();
         }
      }

      return refinedNormals;
   },
   transformLine (hitRay)
   {
      // Apply screen nodes transformation in place here.
   },
   transformMatrix (hitRay)
   {
      // Apply screen nodes transformation in place here.
   },
   intersectsLine: (() =>
   {
      const
         modelViewMatrix = new Matrix4/* default */.A (),
         uvt             = { u: 0, v: 0, t: 0 },
         v0              = new Vector3/* default */.A (),
         v1              = new Vector3/* default */.A (),
         v2              = new Vector3/* default */.A ();

      return function (hitRay, matrix, intersections)
      {
         if (this .intersectsBBox (hitRay))
         {
            this .transformLine (hitRay); // Apply screen transformations from screen nodes.
            this .transformMatrix (modelViewMatrix .assign (matrix)); // Apply screen transformations from screen nodes.

            const
               texCoords   = this .multiTexCoords [0] .getValue (),
               normals     = this .normals .getValue (),
               vertices    = this .vertices .getValue (),
               vertexCount = this .vertexCount;

            for (let i = 0; i < vertexCount; i += 3)
            {
               const i4 = i * 4;

               v0 .x = vertices [i4];     v0 .y = vertices [i4 + 1]; v0 .z = vertices [i4 +  2];
               v1 .x = vertices [i4 + 4]; v1 .y = vertices [i4 + 5]; v1 .z = vertices [i4 +  6];
               v2 .x = vertices [i4 + 8]; v2 .y = vertices [i4 + 9]; v2 .z = vertices [i4 + 10];

               if (!hitRay .intersectsTriangle (v0, v1, v2, uvt))
                  continue;

               // Get barycentric coordinates.

               const { u, v, t } = uvt;

               // Determine vectors for LinePickSensor.

               const point = new Vector3/* default */.A (u * vertices [i4]     + v * vertices [i4 + 4] + t * vertices [i4 +  8],
                                          u * vertices [i4 + 1] + v * vertices [i4 + 5] + t * vertices [i4 +  9],
                                          u * vertices [i4 + 2] + v * vertices [i4 + 6] + t * vertices [i4 + 10]);

               const texCoord = new Vector4/* default */.A (u * texCoords [i4]     + v * texCoords [i4 + 4] + t * texCoords [i4 + 8],
                                             u * texCoords [i4 + 1] + v * texCoords [i4 + 5] + t * texCoords [i4 + 9],
                                             u * texCoords [i4 + 2] + v * texCoords [i4 + 6] + t * texCoords [i4 + 10],
                                             u * texCoords [i4 + 3] + v * texCoords [i4 + 7] + t * texCoords [i4 + 11]);

               const i3 = i * 3;

               const normal = new Vector3/* default */.A (u * normals [i3]     + v * normals [i3 + 3] + t * normals [i3 + 6],
                                           u * normals [i3 + 1] + v * normals [i3 + 4] + t * normals [i3 + 7],
                                           u * normals [i3 + 2] + v * normals [i3 + 5] + t * normals [i3 + 8]);

               intersections .push ({ texCoord, normal, point: this .getMatrix () .multVecMatrix (point) });
            }
         }

         return intersections .length;
      };
   })(),
   intersectsBBox: (() =>
   {
      const intersection = new Vector3/* default */.A ();

      return function (hitRay)
      {
         const { min, max, planes } = this;

         const
            minX = min .x,
            maxX = max .x,
            minY = min .y,
            maxY = max .y,
            minZ = min .z,
            maxZ = max .z;

         // front
         if (planes [0] .intersectsLine (hitRay, intersection))
         {
            if (intersection .x >= minX && intersection .x <= maxX &&
                intersection .y >= minY && intersection .y <= maxY)
               return true;
         }

         // back
         if (planes [1] .intersectsLine (hitRay, intersection))
         {
            if (intersection .x >= minX && intersection .x <= maxX &&
                intersection .y >= minY && intersection .y <= maxY)
               return true;
         }

         // top
         if (planes [2] .intersectsLine (hitRay, intersection))
         {
            if (intersection .x >= minX && intersection .x <= maxX &&
                intersection .z >= minZ && intersection .z <= maxZ)
               return true;
         }

         // bottom
         if (planes [3] .intersectsLine (hitRay, intersection))
         {
            if (intersection .x >= minX && intersection .x <= maxX &&
                intersection .z >= minZ && intersection .z <= maxZ)
               return true;
         }

         // right
         if (planes [4] .intersectsLine (hitRay, intersection))
         {
            if (intersection .y >= minY && intersection .y <= maxY &&
                intersection .z >= minZ && intersection .z <= maxZ)
               return true;
         }

         return false;
      };
   })(),
   set_live__ ()
   {
      // Is overloaded by primitives with option nodes.
   },
   connectOptions (options)
   {
      const
         browser      = this .getBrowser (),
         alwaysUpdate = this .isLive () && browser .getBrowserOption ("AlwaysUpdateGeometries");

      if (this .getLive () .getValue () || alwaysUpdate)
      {
         options .addInterest ("requestRebuild", this);

         if (options .getModificationTime () >= this ._rebuild .getValue ())
            this .requestRebuild ();
      }
      else
      {
         options .removeInterest ("requestRebuild", this);
      }
   },
   requestRebuild ()
   {
      this ._rebuild = Date .now () / 1000;
   },
   rebuild ()
   {
      this .clear ();
      this .build ();

      // Shrink arrays before transferring them to graphics card.

      for (const attribArray of this .attribArrays)
         attribArray .shrinkToFit ();

      for (const multiTexCoord of this .multiTexCoords)
         multiTexCoord .shrinkToFit ();

      this .coordIndices .shrinkToFit ();
      this .fogDepths    .shrinkToFit ();
      this .colors       .shrinkToFit ();
      this .tangents     .shrinkToFit ();
      this .normals      .shrinkToFit ();
      this .vertices     .shrinkToFit ();

      this .updateBBox ();

      // Generate texCoord if needed.

      if (!this .multiTexCoords .length)
         this .generateTexCoords ();

      // Generate tangents if needed.

      if (!this .tangents .length)
         this .generateTangents ();

      // Transfer arrays and update.

      this .transfer ();
      this .updateGeometryKey ();
      this .updateRenderFunctions ();
   },
   clear ()
   {
      // BBox

      this .min .set (Number .POSITIVE_INFINITY);
      this .max .set (Number .NEGATIVE_INFINITY);

      // Create attribArray arrays.
      {
         const attribArrays = this .attribArrays;

         for (const attribArray of attribArrays)
            attribArray .length = 0;

         const length = this .attribNodes .length;

         for (let a = attribArrays .length; a < length; ++ a)
            attribArrays [a] = X3DGeometryNode .createArray ();

         attribArrays .length = length;
      }

      // Buffer

      this .coordIndices   .length = 0;
      this .fogDepths      .length = 0;
      this .colors         .length = 0;
      this .multiTexCoords .length = 0;
      this .texCoords      .length = 0;
      this .tangents       .length = 0;
      this .normals        .length = 0;
      this .vertices       .length = 0;
   },
   updateBBox: (() =>
   {
      const point = new Vector3/* default */.A ();

      return function ()
      {
         // Determine bbox.

         const
            vertices    = this .vertices .getValue (),
            numVertices = vertices .length,
            min         = this .min,
            max         = this .max;

         if (numVertices)
         {
            if (min .x === Number .POSITIVE_INFINITY)
            {
               for (let i = 0; i < numVertices; i += 4)
               {
                  const { [i]: v1, [i + 1]: v2, [i + 2]: v3 } = vertices;

                  point .set (v1, v2, v3);

                  min .min (point);
                  max .max (point);
               }
            }

            this .bbox .setExtents (min, max);
         }
         else
         {
            this .bbox .setExtents (min .set (0), max .set (0));
         }

         for (let i = 0; i < 5; ++ i)
            this .planes [i] .set (i % 2 ? min : max, boxNormals [i]);

         this ._bbox_changed .addEvent ();
      };
   })(),
   transfer ()
   {
      const gl = this .getBrowser () .getContext ();

      // Transfer coord indices.

      gl .bindBuffer (gl .ARRAY_BUFFER, this .coordIndexBuffer);
      gl .bufferData (gl .ARRAY_BUFFER, this .coordIndices .getValue (), gl .DYNAMIC_DRAW);

      // Transfer attribArrays.

      for (let i = this .attribBuffers .length, length = this .attribArrays .length; i < length; ++ i)
         this .attribBuffers .push (gl .createBuffer ());

      for (let i = 0, length = this .attribArrays .length; i < length; ++ i)
      {
         gl .bindBuffer (gl .ARRAY_BUFFER, this .attribBuffers [i]);
         gl .bufferData (gl .ARRAY_BUFFER, this .attribArrays [i] .getValue (), gl .DYNAMIC_DRAW);
      }

      // Transfer fog depths.

      const lastHasFogCoords = this .hasFogCoords;

      gl .bindBuffer (gl .ARRAY_BUFFER, this .fogDepthBuffer);
      gl .bufferData (gl .ARRAY_BUFFER, this .fogDepths .getValue (), gl .DYNAMIC_DRAW);

      this .hasFogCoords = !! this .fogDepths .length;

      if (this .hasFogCoords !== lastHasFogCoords)
         this .updateVertexArrays ();

      // Transfer colors.

      const lastColorMaterial = this .colorMaterial;

      gl .bindBuffer (gl .ARRAY_BUFFER, this .colorBuffer);
      gl .bufferData (gl .ARRAY_BUFFER, this .colors .getValue (), gl .DYNAMIC_DRAW);

      this .colorMaterial = !! this .colors .length;

      if (this .colorMaterial !== lastColorMaterial)
         this .updateVertexArrays ();

      // Transfer multiTexCoords.

      for (let i = 0, length = this .multiTexCoords .length; i < length; ++ i)
      {
         gl .bindBuffer (gl .ARRAY_BUFFER, this .texCoordBuffers [i]);
         gl .bufferData (gl .ARRAY_BUFFER, this .multiTexCoords [i] .getValue (), gl .DYNAMIC_DRAW);
      }

      // Transfer tangents.

      const lastHasTangents = this .hasTangents;

      gl .bindBuffer (gl .ARRAY_BUFFER, this .tangentBuffer);
      gl .bufferData (gl .ARRAY_BUFFER, this .tangents .getValue (), gl .DYNAMIC_DRAW);

      this .hasTangents = !! this .tangents .length;

      if (this .hasTangents !== lastHasTangents)
         this .updateVertexArrays ();

      // Transfer normals or flat normals.

      const lastHasNormals = this .hasNormals;

      gl .bindBuffer (gl .ARRAY_BUFFER, this .normalBuffer);
      gl .bufferData (gl .ARRAY_BUFFER, this .normals .getValue (), gl .DYNAMIC_DRAW);

      this .hasNormals = !! this .normals .length;

      if (this .hasNormals !== lastHasNormals)
         this .updateVertexArrays ();

      // Transfer vertices.

      gl .bindBuffer (gl .ARRAY_BUFFER, this .vertexBuffer);
      gl .bufferData (gl .ARRAY_BUFFER, this .vertices .getValue (), gl .DYNAMIC_DRAW);

      this .vertexCount = this .vertices .length / 4;
   },
   updateGeometryKey ()
   {
      let key = "";

      key += this .geometryType;
      key += this .hasFogCoords  ? 1 : 0;
      key += this .colorMaterial ? 1 : 0;
      key += this .hasTangents   ? 1 : 0;
      key += this .hasNormals    ? 1 : 0;

      this .geometryKey = key;
   },
   updateRenderFunctions ()
   {
      if (this .vertexCount)
      {
         // Use default render functions.

         delete this .displaySimple;
         delete this .display;
         delete this .displaySimpleInstanced;
         delete this .displayInstanced;
      }
      else
      {
         // Use no render function.

         this .displaySimple          = Function .prototype;
         this .display                = Function .prototype;
         this .displaySimpleInstanced = Function .prototype;
         this .displayInstanced       = Function .prototype;
      }
   },
   traverse (type, renderObject)
   { },
   displaySimple (gl, renderContext, shaderNode)
   {
      if (this .vertexArrayObject .enable (shaderNode .getProgram ()))
      {
         if (this .coordIndices .length)
            shaderNode .enableCoordIndexAttribute (gl, this .coordIndexBuffer, 0, 0);

         if (this .multiTexCoords .length)
            shaderNode .enableTexCoordAttribute (gl, this .texCoordBuffers, 0, 0);

         if (this .hasNormals)
            shaderNode .enableNormalAttribute (gl, this .normalBuffer, 0, 0);

         shaderNode .enableVertexAttribute (gl, this .vertexBuffer, 0, 0);
      }

      gl .drawArrays (gl .TRIANGLES, 0, this .vertexCount);
   },
   display (gl, renderContext)
   {
      const
         { viewport, appearanceNode, modelViewMatrix } = renderContext,
         browser         = this .getBrowser (),
         primitiveMode   = browser .getPrimitiveMode (gl .TRIANGLES),
         renderModeNodes = appearanceNode .getRenderModes (),
         shaderNode      = appearanceNode .getShader (this, renderContext);

      // Set viewport.

      gl .viewport (... viewport);

      // Enable render mode nodes.

      for (const node of renderModeNodes)
         node .enable (gl);

      // Handle negative scale.

      const positiveScale = Matrix4/* default */.A .prototype .determinant3 .call (modelViewMatrix) > 0;

      gl .frontFace (positiveScale ? this .frontFace : this .backFace);

      // Draw front and back faces.

      if (this .solid || !appearanceNode .getBackMaterial ())
      {
         this .displayGeometry (gl, renderContext, shaderNode, primitiveMode, true, true);
      }
      else
      {
         const backShaderNode = appearanceNode .getBackShader (this, renderContext);

         this .displayGeometry (gl, renderContext, backShaderNode, primitiveMode, true,  false);
         this .displayGeometry (gl, renderContext, shaderNode,     primitiveMode, false, true);
      }

      // Disable render mode nodes.

      for (const node of renderModeNodes)
         node .disable (gl);

      // Reset texture units.

      browser .resetTextureUnits ();
   },
   displayGeometry (gl, renderContext, shaderNode, primitiveMode, back, front)
   {
      shaderNode .enable (gl);
      shaderNode .setUniforms (gl, renderContext, this, front);

      // Setup vertex attributes.

      if (this .vertexArrayObject .enable (shaderNode .getProgram ()))
      {
         const
            attribNodes   = this .getAttrib (),
            attribBuffers = this .getAttribBuffers ();

         if (this .coordIndices .length)
            shaderNode .enableCoordIndexAttribute (gl, this .coordIndexBuffer, 0, 0);

         for (let i = 0, length = attribNodes .length; i < length; ++ i)
            attribNodes [i] .enable (gl, shaderNode, attribBuffers [i]);

         if (this .hasFogCoords)
            shaderNode .enableFogDepthAttribute (gl, this .fogDepthBuffer, 0, 0);

         if (this .colorMaterial)
            shaderNode .enableColorAttribute (gl, this .colorBuffer, 0, 0);

         if (this .hasTangents)
            shaderNode .enableTangentAttribute (gl, this .tangentBuffer, 0, 0);

         shaderNode .enableTexCoordAttribute (gl, this .texCoordBuffers, 0, 0);
         shaderNode .enableNormalAttribute   (gl, this .normalBuffer,    0, 0);
         shaderNode .enableVertexAttribute   (gl, this .vertexBuffer,    0, 0);
      }

      // Draw depending on wireframe, solid and transparent.

      if (renderContext .transparent || back !== front)
      {
         // Render transparent or back or front.

         gl .enable (gl .CULL_FACE);

         // Render back.

         if (back && !this .solid)
         {
            gl .cullFace (gl .FRONT);
            gl .drawArrays (primitiveMode, 0, this .vertexCount);
         }

         // Render front.

         if (front)
         {
            gl .cullFace (gl .BACK);
            gl .drawArrays (primitiveMode, 0, this .vertexCount);
         }
      }
      else
      {
         // Render solid or both sides.

         if (this .solid)
            gl .enable (gl .CULL_FACE);
         else
            gl .disable (gl .CULL_FACE);

         gl .drawArrays (primitiveMode, 0, this .vertexCount);
      }
   },
   displaySimpleInstanced (gl, shaderNode, shapeNode)
   {
      const instances = shapeNode .getInstances ();

      if (instances .vertexArrayObject .update (this .updateInstances) .enable (shaderNode .getProgram ()))
      {
         const { instancesStride, particleOffset, matrixOffset, normalMatrixOffset } = shapeNode;

         if (particleOffset !== undefined)
            shaderNode .enableParticleAttribute (gl, instances, instancesStride, particleOffset, 1);

         shaderNode .enableInstanceMatrixAttribute (gl, instances, instancesStride, matrixOffset, 1);

         if (normalMatrixOffset !== undefined)
            shaderNode .enableInstanceNormalMatrixAttribute (gl, instances, instancesStride, normalMatrixOffset, 1);

         if (this .coordIndices .length)
            shaderNode .enableCoordIndexAttribute (gl, this .coordIndexBuffer, 0, 0);

         shaderNode .enableTexCoordAttribute (gl, this .texCoordBuffers, 0, 0);
         shaderNode .enableNormalAttribute   (gl, this .normalBuffer,    0, 0);
         shaderNode .enableVertexAttribute   (gl, this .vertexBuffer,    0, 0);

         this .updateInstances = false;
      }

      gl .drawArraysInstanced (gl .TRIANGLES, 0, this .vertexCount, shapeNode .getNumInstances ());
   },
   displayInstanced (gl, renderContext, shapeNode)
   {
      const
         { viewport, appearanceNode, modelViewMatrix } = renderContext,
         browser         = this .getBrowser (),
         primitiveMode   = browser .getPrimitiveMode (gl .TRIANGLES),
         renderModeNodes = appearanceNode .getRenderModes (),
         shaderNode      = appearanceNode .getShader (this, renderContext);

      // Set viewport.

      gl .viewport (... viewport);

      // Enable render mode nodes.

      for (const node of renderModeNodes)
         node .enable (gl);

      // Handle negative scale.

      const positiveScale = Matrix4/* default */.A .prototype .determinant3 .call (modelViewMatrix) > 0;

      gl .frontFace (positiveScale ? this .frontFace : this .backFace);

      // Draw front and back faces.

      if (this .solid || !appearanceNode .getBackMaterial ())
      {
         this .displayInstancedGeometry (gl, renderContext, shaderNode, primitiveMode, true, true, shapeNode);
      }
      else
      {
         const backShaderNode = appearanceNode .getBackShader (this, renderContext);

         this .displayInstancedGeometry (gl, renderContext, backShaderNode, primitiveMode, true,  false, shapeNode);
         this .displayInstancedGeometry (gl, renderContext, shaderNode,     primitiveMode, false, true,  shapeNode);
      }

      // Disable render mode nodes.

      for (const node of renderModeNodes)
         node .disable (gl);

      // Reset texture units.

      browser .resetTextureUnits ();
   },
   displayInstancedGeometry (gl, renderContext, shaderNode, primitiveMode, back, front, shapeNode)
   {
      // Setup shader.

      shaderNode .enable (gl);
      shaderNode .setUniforms (gl, renderContext, this, front);

      // Setup vertex attributes.

      const instances = shapeNode .getInstances ();

      if (instances .vertexArrayObject .update (this .updateInstances) .enable (shaderNode .getProgram ()))
      {
         const { instancesStride, particleOffset, velocityOffset, matrixOffset, normalMatrixOffset } = shapeNode;

         const
            attribNodes   = this .getAttrib (),
            attribBuffers = this .getAttribBuffers ();

         if (particleOffset !== undefined)
            shaderNode .enableParticleAttribute (gl, instances, instancesStride, particleOffset, 1);

         if (velocityOffset !== undefined)
            shaderNode .enableParticleVelocityAttribute (gl, instances, instancesStride, velocityOffset, 1);

         shaderNode .enableInstanceMatrixAttribute (gl, instances, instancesStride, matrixOffset, 1);

         if (normalMatrixOffset !== undefined)
            shaderNode .enableInstanceNormalMatrixAttribute (gl, instances, instancesStride, normalMatrixOffset, 1);

         if (this .coordIndices .length)
            shaderNode .enableCoordIndexAttribute (gl, this .coordIndexBuffer, 0, 0);

         for (let i = 0, length = attribNodes .length; i < length; ++ i)
            attribNodes [i] .enable (gl, shaderNode, attribBuffers [i]);

         if (this .hasFogCoords)
            shaderNode .enableFogDepthAttribute (gl, this .fogDepthBuffer, 0, 0);

         if (this .colorMaterial)
            shaderNode .enableColorAttribute (gl, this .colorBuffer, 0, 0);

         if (this .hasTangents)
            shaderNode .enableTangentAttribute  (gl, this .tangentBuffer, 0, 0);

         shaderNode .enableTexCoordAttribute (gl, this .texCoordBuffers, 0, 0);
         shaderNode .enableNormalAttribute   (gl, this .normalBuffer,    0, 0);
         shaderNode .enableVertexAttribute   (gl, this .vertexBuffer,    0, 0);

         this .updateInstances = false;
      }

      // Draw depending on wireframe, solid and transparent.

      if (renderContext .transparent || back !== front)
      {
         // Render transparent or back or front.

         gl .enable (gl .CULL_FACE);

         if (back && !this .solid)
         {
            gl .cullFace (gl .FRONT);
            gl .drawArraysInstanced (primitiveMode, 0, this .vertexCount, shapeNode .getNumInstances ());
         }

         if (front)
         {
            gl .cullFace (gl .BACK);
            gl .drawArraysInstanced (primitiveMode, 0, this .vertexCount, shapeNode .getNumInstances ());
         }
      }
      else
      {
         // Render solid or both sides.

         if (this .solid)
            gl .enable (gl .CULL_FACE);
         else
            gl .disable (gl .CULL_FACE);

         gl .drawArraysInstanced (primitiveMode, 0, this .vertexCount, shapeNode .getNumInstances ());
      }
   },
},
// Common functions for all X3DComposedGeometryNode types and some other nodes:
{
   getFogCoord ()
   {
      return this .fogCoordNode;
   },
   getColor ()
   {
      return this .colorNode;
   },
   getTexCoord ()
   {
      return this .texCoordNode;
   },
   getTangent ()
   {
      return this .tangentNode;
   },
   getNormal ()
   {
      return this .normalNode;
   },
   getCoord ()
   {
      return this .coordNode;
   },
   set_attrib__ ()
   {
      const attribNodes = this .getAttrib ();

      for (const attribNode of attribNodes)
      {
         attribNode .removeInterest ("requestRebuild", this);
         attribNode ._attribute_changed .removeInterest ("updateVertexArrays", this);
      }

      attribNodes .length = 0;

      for (const node of this ._attrib)
      {
         const attribNode = (0,X3DCast/* default */.A) (X3DConstants/* default */.A .X3DVertexAttributeNode, node);

         if (attribNode)
            attribNodes .push (attribNode);
      }

      for (const attribNode of attribNodes)
      {
         attribNode .addInterest ("requestRebuild", this);
         attribNode ._attribute_changed .addInterest ("updateVertexArrays", this);
      }

      this .updateVertexArrays ();
   },
   set_fogCoord__ ()
   {
      this .fogCoordNode ?.removeInterest ("requestRebuild", this);

      this .fogCoordNode = (0,X3DCast/* default */.A) (X3DConstants/* default */.A .FogCoordinate, this ._fogCoord);

      this .fogCoordNode ?.addInterest ("requestRebuild", this);
   },
   set_color__ ()
   {
      this .colorNode ?.removeInterest ("requestRebuild", this);

      this .colorNode = (0,X3DCast/* default */.A) (X3DConstants/* default */.A .X3DColorNode, this ._color);

      this .colorNode ?.addInterest ("requestRebuild", this);

      this .setTransparent (this .colorNode ?.isTransparent ());
   },
   set_texCoord__ ()
   {
      this .texCoordNode ?.removeInterest ("requestRebuild", this);

      this .texCoordNode = (0,X3DCast/* default */.A) (X3DConstants/* default */.A .X3DTextureCoordinateNode, this ._texCoord);

      this .texCoordNode ?.addInterest ("requestRebuild", this);

      this .setTextureCoordinate (this .texCoordNode);
   },
   set_tangent__ ()
   {
      this .tangentNode ?.removeInterest ("requestRebuild", this);

      this .tangentNode = (0,X3DCast/* default */.A) (X3DConstants/* default */.A .X3DTangentNode, this ._tangent);

      this .tangentNode ?.addInterest ("requestRebuild", this);
   },
   set_normal__ ()
   {
      this .normalNode ?.removeInterest ("requestRebuild", this);

      this .normalNode = (0,X3DCast/* default */.A) (X3DConstants/* default */.A .X3DNormalNode, this ._normal);

      this .normalNode ?.addInterest ("requestRebuild", this);
   },
   set_coord__ ()
   {
      this .coordNode ?.removeInterest ("requestRebuild", this);

      this .coordNode = (0,X3DCast/* default */.A) (X3DConstants/* default */.A .X3DCoordinateNode, this ._coord);

      this .coordNode ?.addInterest ("requestRebuild", this);
   },
});

Object .defineProperties (X3DGeometryNode, X3DNode/* default */.A .getStaticProperties ("X3DGeometryNode", "Rendering", 1));

const X3DGeometryNode_default_ = X3DGeometryNode;
;

/* harmony default export */ const Rendering_X3DGeometryNode = (Namespace/* default */.A .add ("X3DGeometryNode", X3DGeometryNode_default_));

/***/ }),

/***/ 7181:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(8415);
/* harmony import */ var _X3DSingleTextureNode_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(4383);
/* harmony import */ var _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(8899);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(6707);




const defaultData = new Uint8Array ([ 255, 255, 255, 255 ]);

function X3DTexture2DNode (executionContext)
{
   _X3DSingleTextureNode_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .call (this, executionContext);

   this .addType (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .X3DTexture2DNode);

   const gl = this .getBrowser () .getContext ();

   this .target = gl .TEXTURE_2D;
   this .width  = 0;
   this .height = 0;
}

Object .assign (Object .setPrototypeOf (X3DTexture2DNode .prototype, _X3DSingleTextureNode_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .prototype),
{
   initialize ()
   {
      _X3DSingleTextureNode_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .prototype .initialize .call (this);

      this ._repeatS .addInterest ("updateTextureParameters", this);
      this ._repeatT .addInterest ("updateTextureParameters", this);

      const gl = this .getBrowser () .getContext ();

      gl .bindTexture (gl .TEXTURE_2D, this .getTexture ());
      gl .texImage2D  (gl .TEXTURE_2D, 0, gl .RGBA, 1, 1, 0, gl .RGBA, gl .UNSIGNED_BYTE, defaultData);
   },
   getTarget ()
   {
      return this .target;
   },
   getWidth ()
   {
      return this .width;
   },
   setWidth (value)
   {
      this .width = value;
   },
   getHeight ()
   {
      return this .height;
   },
   setHeight (value)
   {
      this .height = value;
   },
   clearTexture ()
   {
      this .setTextureData (1, 1, false, false, defaultData);
   },
   getTextureData (texture = this .getTexture (), width = this .getWidth (), height = this .getHeight ())
   {
      const
         gl          = this .getBrowser () .getContext (),
         framebuffer = gl .createFramebuffer (),
         data        = new Uint8Array (width * height * 4);

      gl .bindFramebuffer (gl .FRAMEBUFFER, framebuffer);
      gl .framebufferTexture2D (gl .FRAMEBUFFER, gl .COLOR_ATTACHMENT0, gl .TEXTURE_2D, texture, 0);
      gl .readPixels (0, 0, width, height, gl .RGBA, gl .UNSIGNED_BYTE, data);
      gl .deleteFramebuffer (framebuffer);

      return data;
   },
   setTextureData (width, height, colorSpaceConversion, transparent, data)
   {
      this .width  = width;
      this .height = height;

      const
         gl  = this .getBrowser () .getContext (),
         max = gl .getParameter (gl .MAX_TEXTURE_SIZE);

      if (width > max || height > max)
      {
         throw new Error (`At least one dimension (${width} × ${height}) is greater than the maximum texture size (${max} px).`);
      }

      gl .bindTexture (gl .TEXTURE_2D, this .getTexture ());
      gl .pixelStorei (gl .UNPACK_COLORSPACE_CONVERSION_WEBGL, colorSpaceConversion ? gl .BROWSER_DEFAULT_WEBGL : gl .NONE);
      gl .texImage2D  (gl .TEXTURE_2D, 0, gl .RGBA, width, height, 0, gl .RGBA, gl .UNSIGNED_BYTE, data);
      gl .pixelStorei (gl .UNPACK_COLORSPACE_CONVERSION_WEBGL, gl .BROWSER_DEFAULT_WEBGL);

      this .setTransparent (transparent);
      this .updateTextureParameters ();
      this .addNodeEvent ();
   },
   updateTextureData (data)
   {
      const gl = this .getBrowser () .getContext ();

      gl .bindTexture (gl .TEXTURE_2D, this .getTexture ());
      gl .texSubImage2D (gl .TEXTURE_2D, 0, 0, 0, gl .RGBA, gl .UNSIGNED_BYTE, data);

      if (this .texturePropertiesNode ._generateMipMaps .getValue ())
         gl .generateMipmap (gl .TEXTURE_2D);

      this .addNodeEvent ();
   },
   updateTextureParameters ()
   {
      _X3DSingleTextureNode_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .prototype .updateTextureParameters .call (this,
                                                                      this .target,
                                                                      this ._textureProperties .getValue (),
                                                                      this .texturePropertiesNode,
                                                                      this .width,
                                                                      this .height,
                                                                      this ._repeatS .getValue (),
                                                                      this ._repeatT .getValue (),
                                                                      false);
   },
   setShaderUniforms (gl, channel)
   {
      const textureUnit = this .getBrowser () .popTextureUnit ();

      gl .activeTexture (gl .TEXTURE0 + textureUnit);
      gl .bindTexture (gl .TEXTURE_2D, this .getTexture ());
      gl .uniform1i (channel .texture2D, textureUnit);
   },
});

Object .defineProperties (X3DTexture2DNode, _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .getStaticProperties ("X3DTexture2DNode", "Texturing", 1));

const __default__ = X3DTexture2DNode;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .add ("X3DTexture2DNode", __default__));

/***/ }),

/***/ 7274:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6707);
const functions =
{
   parse (parser)
   {
      this .lastIndex = parser .lastIndex;

      parser .result = this .exec (parser .input);

      if (parser .result)
      {
         parser .lastIndex = this .lastIndex;
         return true;
      }

      return false;
   },
   lookahead (parser)
   {
      const
         lastIndex = parser .lastIndex,
         result    = this .parse (parser);

      parser .lastIndex = lastIndex;

      return result;
   },
};

function Expressions (Grammar)
{
   for (const value of Object .values (Grammar))
      Object .assign (value, functions);

   return Grammar;
}

const __default__ = Expressions;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .add ("Expressions", __default__));

/***/ }),

/***/ 7281:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Features_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6818);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(6707);


const __default__ = _Features_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .WEAK_REF && _Features_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .FINALIZATION_REGISTRY ?
/**
 * IterableWeakSet is a writable set-like class.
 */
class IterableWeakSet
{
   #map      = new Map ();
   #registry = new FinalizationRegistry (id => this .#map .delete (id));

   constructor (objects)
   {
      if (objects)
      {
         for (const object of objects)
            this .add (object);
      }
   }

   *[Symbol .iterator] ()
   {
      yield* this .values ();
   }

   get size ()
   {
      return this .#map .size;
   }

   add (object)
   {
      this .#map .set (object .getId (), new WeakRef (object));
      this .#registry .register (object, object .getId (), object);
   }

   clear ()
   {
      for (const object of this .values ())
         this .#registry .unregister (object);

      this .#map .clear ();
   }

   delete (object)
   {
      this .#map .delete (object .getId ());
      this .#registry .unregister (object);
   }

   forEach (callbackFn, thisArg)
   {
      for (const object of this .values ())
         callbackFn .call (thisArg, object, object, this);
   }

   has (object)
   {
      return this .#map .has (object .getId ());
   }

   *entries ()
   {
      for (const object of this .values ())
         yield [object, object];
   }

   *keys ()
   {
      yield *this .values ();
   }

   *values ()
   {
      for (const weakRef of this .#map .values ())
      {
         const object = weakRef .deref ();

         if (object)
            yield object;
      }
   }
}
:
class IterableWeakSet extends Set
{
   constructor (objects)
   {
      super (objects);
   }
};
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .add ("IterableWeakSet", __default__));

/***/ }),

/***/ 7326:
/***/ ((module) => {

/**
 * @license
 * Copyright 2000, Silicon Graphics, Inc. All Rights Reserved.
 * Copyright 2015, Google Inc. All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to
 * deal in the Software without restriction, including without limitation the
 * rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
 * sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice including the dates of first publication and
 * either this permission notice or a reference to http://oss.sgi.com/projects/FreeB/
 * shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * SILICON GRAPHICS, INC. BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR
 * IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 * Original Code. The Original Code is: OpenGL Sample Implementation,
 * Version 1.2.1, released January 26, 2000, developed by Silicon Graphics,
 * Inc. The Original Code is Copyright (c) 1991-2000 Silicon Graphics, Inc.
 * Copyright in any portions created by third parties is as indicated
 * elsewhere herein. All Rights Reserved.
 */
/**
 * @author ericv@cs.stanford.edu (Eric Veach)
 * @author bckenny@google.com (Brendan Kenny)
 */

/**
 * Base namespace.
 * @const
 */
var libtess = {};

/**
 * Whether to run asserts and extra debug checks.
 * @define {boolean}
 */
libtess.DEBUG = false;

/**
 * Checks if the condition evaluates to true if libtess.DEBUG is true.
 * @param {*} condition The condition to check.
 * @param {string=} opt_message Error message in case of failure.
 * @throws {Error} Assertion failed, the condition evaluates to false.
 */
libtess.assert = function(condition, opt_message) {
  if (libtess.DEBUG && !condition) {
    throw new Error('Assertion failed' +
        (opt_message ? ': ' + opt_message : ''));
  }
};

/**
 * The maximum vertex coordinate size, 1e150. Anything larger will trigger a
 * GLU_TESS_COORD_TOO_LARGE error callback and the vertex will be clamped to
 * this value for all tessellation calculations.
 * @const {number}
 */
libtess.GLU_TESS_MAX_COORD = 1e150;
// NOTE(bckenny): value from glu.pl generator

/**
 * Normally the polygon is projected to a plane perpendicular to one of the
 * three coordinate axes before tessellating in 2d. This helps numerical
 * accuracy by forgoing a transformation step by simply dropping one coordinate
 * dimension.
 *
 * However, this can affect the placement of intersection points for non-axis-
 * aligned polygons. Setting TRUE_PROJECT to true will instead project onto a
 * plane actually perpendicular to the polygon's normal.
 *
 * NOTE(bckenny): I can find no instances on the internet in which this mode has
 * been used, but it's difficult to search for. This was a compile-time setting
 * in the original, so setting this as constant. If this is exposed in the
 * public API, remove the ignore coverage directives on
 * libtess.normal.projectPolygon and libtess.normal.normalize_.
 * @const {boolean}
 */
libtess.TRUE_PROJECT = false;

/**
 * The default tolerance for merging features, 0, meaning vertices are only
 * merged if they are exactly coincident
 * If a higher tolerance is needed, significant rewriting will need to occur.
 * See libtess.sweep.TOLERANCE_NONZERO_ as a starting place.
 * @const {number}
 */
libtess.GLU_TESS_DEFAULT_TOLERANCE = 0;

/**
 * The input contours parition the plane into regions. A winding
 * rule determines which of these regions are inside the polygon.
 *
 * For a single contour C, the winding number of a point x is simply
 * the signed number of revolutions we make around x as we travel
 * once around C (where CCW is positive). When there are several
 * contours, the individual winding numbers are summed. This
 * procedure associates a signed integer value with each point x in
 * the plane. Note that the winding number is the same for all
 * points in a single region.
 *
 * The winding rule classifies a region as "inside" if its winding
 * number belongs to the chosen category (odd, nonzero, positive,
 * negative, or absolute value of at least two). The current GLU
 * tesselator implements the "odd" rule. The "nonzero" rule is another
 * common way to define the interior. The other three rules are
 * useful for polygon CSG operations.
 * @enum {number}
 */
libtess.windingRule = {
  // NOTE(bckenny): values from enumglu.spec
  GLU_TESS_WINDING_ODD: 100130,
  GLU_TESS_WINDING_NONZERO: 100131,
  GLU_TESS_WINDING_POSITIVE: 100132,
  GLU_TESS_WINDING_NEGATIVE: 100133,
  GLU_TESS_WINDING_ABS_GEQ_TWO: 100134
};

/**
 * The type of primitive return from a "begin" callback. GL_LINE_LOOP is only
 * returned when GLU_TESS_BOUNDARY_ONLY is true. GL_TRIANGLE_STRIP and
 * GL_TRIANGLE_FAN are no longer returned since 1.1.0 (see release notes).
 * @enum {number}
 */
libtess.primitiveType = {
  GL_LINE_LOOP: 2,
  GL_TRIANGLES: 4,
  GL_TRIANGLE_STRIP: 5,
  GL_TRIANGLE_FAN: 6
};

/**
 * The types of errors provided in the error callback.
 * @enum {number}
 */
libtess.errorType = {
  // TODO(bckenny) doc types
  // NOTE(bckenny): values from enumglu.spec
  GLU_TESS_MISSING_BEGIN_POLYGON: 100151,
  GLU_TESS_MISSING_END_POLYGON: 100153,
  GLU_TESS_MISSING_BEGIN_CONTOUR: 100152,
  GLU_TESS_MISSING_END_CONTOUR: 100154,
  GLU_TESS_COORD_TOO_LARGE: 100155,
  GLU_TESS_NEED_COMBINE_CALLBACK: 100156
};

/**
 * Enum values necessary for providing settings and callbacks. See the readme
 * for details.
 * @enum {number}
 */
libtess.gluEnum = {
  // TODO(bckenny): rename so not always typing libtess.gluEnum.*?

  // NOTE(bckenny): values from enumglu.spec
  GLU_TESS_BEGIN: 100100,
  GLU_TESS_VERTEX: 100101,
  GLU_TESS_END: 100102,
  GLU_TESS_ERROR: 100103,
  GLU_TESS_EDGE_FLAG: 100104,
  GLU_TESS_COMBINE: 100105,
  GLU_TESS_BEGIN_DATA: 100106,
  GLU_TESS_VERTEX_DATA: 100107,
  GLU_TESS_END_DATA: 100108,
  GLU_TESS_ERROR_DATA: 100109,
  GLU_TESS_EDGE_FLAG_DATA: 100110,
  GLU_TESS_COMBINE_DATA: 100111,

  GLU_TESS_MESH: 100112,  //  NOTE(bckenny): from tess.c
  GLU_TESS_TOLERANCE: 100142,
  GLU_TESS_WINDING_RULE: 100140,
  GLU_TESS_BOUNDARY_ONLY: 100141,

  // TODO(bckenny): move this to libtess.errorType?
  GLU_INVALID_ENUM: 100900,
  GLU_INVALID_VALUE: 100901
};

/** @typedef {number} */
libtess.PQHandle;

/* global libtess */

/** @const */
libtess.geom = {};

/**
 * Returns whether vertex u and vertex v are equal.
 * @param {libtess.GluVertex} u
 * @param {libtess.GluVertex} v
 * @return {boolean}
 */
libtess.geom.vertEq = function(u, v) {
  return u.s === v.s && u.t === v.t;
};

/**
 * Returns whether vertex u is lexicographically less than or equal to vertex v.
 * @param {libtess.GluVertex} u
 * @param {libtess.GluVertex} v
 * @return {boolean}
 */
libtess.geom.vertLeq = function(u, v) {
  return (u.s < v.s) || (u.s === v.s && u.t <= v.t);
};

/**
 * Given three vertices u,v,w such that geom.vertLeq(u,v) && geom.vertLeq(v,w),
 * evaluates the t-coord of the edge uw at the s-coord of the vertex v.
 * Returns v.t - (uw)(v.s), ie. the signed distance from uw to v.
 * If uw is vertical (and thus passes thru v), the result is zero.
 *
 * The calculation is extremely accurate and stable, even when v
 * is very close to u or w.  In particular if we set v.t = 0 and
 * let r be the negated result (this evaluates (uw)(v.s)), then
 * r is guaranteed to satisfy MIN(u.t,w.t) <= r <= MAX(u.t,w.t).
 * @param {libtess.GluVertex} u
 * @param {libtess.GluVertex} v
 * @param {libtess.GluVertex} w
 * @return {number}
 */
libtess.geom.edgeEval = function(u, v, w) {

  var gapL = v.s - u.s;
  var gapR = w.s - v.s;

  if (gapL + gapR > 0) {
    if (gapL < gapR) {
      return (v.t - u.t) + (u.t - w.t) * (gapL / (gapL + gapR));
    } else {
      return (v.t - w.t) + (w.t - u.t) * (gapR / (gapL + gapR));
    }
  }

  // vertical line
  return 0;
};

/**
 * Returns a number whose sign matches geom.edgeEval(u,v,w) but which
 * is cheaper to evaluate.  Returns > 0, == 0 , or < 0
 * as v is above, on, or below the edge uw.
 * @param {libtess.GluVertex} u
 * @param {libtess.GluVertex} v
 * @param {libtess.GluVertex} w
 * @return {number}
 */
libtess.geom.edgeSign = function(u, v, w) {

  var gapL = v.s - u.s;
  var gapR = w.s - v.s;

  if (gapL + gapR > 0) {
    return (v.t - w.t) * gapL + (v.t - u.t) * gapR;
  }

  // vertical line
  return 0;
};

/**
 * Version of VertLeq with s and t transposed.
 * Returns whether vertex u is lexicographically less than or equal to vertex v.
 * @param {libtess.GluVertex} u
 * @param {libtess.GluVertex} v
 * @return {boolean}
 */
libtess.geom.transLeq = function(u, v) {
  return (u.t < v.t) || (u.t === v.t && u.s <= v.s);
};

/**
 * Version of geom.edgeEval with s and t transposed.
 * Given three vertices u,v,w such that geom.transLeq(u,v) &&
 * geom.transLeq(v,w), evaluates the t-coord of the edge uw at the s-coord of
 * the vertex v. Returns v.s - (uw)(v.t), ie. the signed distance from uw to v.
 * If uw is vertical (and thus passes thru v), the result is zero.
 *
 * The calculation is extremely accurate and stable, even when v
 * is very close to u or w.  In particular if we set v.s = 0 and
 * let r be the negated result (this evaluates (uw)(v.t)), then
 * r is guaranteed to satisfy MIN(u.s,w.s) <= r <= MAX(u.s,w.s).
 * @param {libtess.GluVertex} u
 * @param {libtess.GluVertex} v
 * @param {libtess.GluVertex} w
 * @return {number}
 */
libtess.geom.transEval = function(u, v, w) {

  var gapL = v.t - u.t;
  var gapR = w.t - v.t;

  if (gapL + gapR > 0) {
    if (gapL < gapR) {
      return (v.s - u.s) + (u.s - w.s) * (gapL / (gapL + gapR));
    } else {
      return (v.s - w.s) + (w.s - u.s) * (gapR / (gapL + gapR));
    }
  }

  // vertical line
  return 0;
};

/**
 * Version of geom.edgeSign with s and t transposed.
 * Returns a number whose sign matches geom.transEval(u,v,w) but which
 * is cheaper to evaluate.  Returns > 0, == 0 , or < 0
 * as v is above, on, or below the edge uw.
 * @param {libtess.GluVertex} u
 * @param {libtess.GluVertex} v
 * @param {libtess.GluVertex} w
 * @return {number}
 */
libtess.geom.transSign = function(u, v, w) {

  var gapL = v.t - u.t;
  var gapR = w.t - v.t;

  if (gapL + gapR > 0) {
    return (v.s - w.s) * gapL + (v.s - u.s) * gapR;
  }

  // vertical line
  return 0;
};

/**
 * Returns whether edge is directed from right to left.
 * @param {libtess.GluHalfEdge} e
 * @return {boolean}
 */
libtess.geom.edgeGoesLeft = function(e) {
  return libtess.geom.vertLeq(e.dst(), e.org);
};

/**
 * Returns whether edge is directed from left to right.
 * @param {libtess.GluHalfEdge} e
 * @return {boolean}
 */
libtess.geom.edgeGoesRight = function(e) {
  return libtess.geom.vertLeq(e.org, e.dst());
};

/**
 * Calculates the L1 distance between vertices u and v.
 * @param {libtess.GluVertex} u
 * @param {libtess.GluVertex} v
 * @return {number}
 */
libtess.geom.vertL1dist = function(u, v) {
  return Math.abs(u.s - v.s) + Math.abs(u.t - v.t);
};

// NOTE(bckenny): vertCCW is called nowhere in libtess and isn't part of the
// public API.
/* istanbul ignore next */
/**
 * For almost-degenerate situations, the results are not reliable.
 * Unless the floating-point arithmetic can be performed without
 * rounding errors, *any* implementation will give incorrect results
 * on some degenerate inputs, so the client must have some way to
 * handle this situation.
 * @param {!libtess.GluVertex} u
 * @param {!libtess.GluVertex} v
 * @param {!libtess.GluVertex} w
 * @return {boolean}
 */
libtess.geom.vertCCW = function(u, v, w) {
  return (u.s * (v.t - w.t) + v.s * (w.t - u.t) + w.s * (u.t - v.t)) >= 0;
};

/**
 * Given parameters a,x,b,y returns the value (b*x+a*y)/(a+b),
 * or (x+y)/2 if a==b==0. It requires that a,b >= 0, and enforces
 * this in the rare case that one argument is slightly negative.
 * The implementation is extremely stable numerically.
 * In particular it guarantees that the result r satisfies
 * MIN(x,y) <= r <= MAX(x,y), and the results are very accurate
 * even when a and b differ greatly in magnitude.
 * @private
 * @param {number} a
 * @param {number} x
 * @param {number} b
 * @param {number} y
 * @return {number}
 */
libtess.geom.interpolate_ = function(a, x, b, y) {
  // from Macro RealInterpolate:
  //(a = (a < 0) ? 0 : a, b = (b < 0) ? 0 : b, ((a <= b) ? ((b == 0) ? ((x+y) / 2) : (x + (y-x) * (a/(a+b)))) : (y + (x-y) * (b/(a+b)))))
  a = (a < 0) ? 0 : a;
  b = (b < 0) ? 0 : b;

  if (a <= b) {
    if (b === 0) {
      return (x + y) / 2;
    } else {
      return x + (y - x) * (a / (a + b));
    }
  } else {
    return y + (x - y) * (b / (a + b));
  }
};

/**
 * Given edges (o1,d1) and (o2,d2), compute their point of intersection.
 * The computed point is guaranteed to lie in the intersection of the
 * bounding rectangles defined by each edge.
 * @param {!libtess.GluVertex} o1
 * @param {!libtess.GluVertex} d1
 * @param {!libtess.GluVertex} o2
 * @param {!libtess.GluVertex} d2
 * @param {!libtess.GluVertex} v
 */
libtess.geom.edgeIntersect = function(o1, d1, o2, d2, v) {
  // This is certainly not the most efficient way to find the intersection
  // of two line segments, but it is very numerically stable.

  // Strategy: find the two middle vertices in the VertLeq ordering,
  // and interpolate the intersection s-value from these. Then repeat
  // using the TransLeq ordering to find the intersection t-value.
  var z1;
  var z2;
  var tmp;
  if (!libtess.geom.vertLeq(o1, d1)) {
    // Swap(o1, d1);
    tmp = o1;
    o1 = d1;
    d1 = tmp;
  }
  if (!libtess.geom.vertLeq(o2, d2)) {
    // Swap(o2, d2);
    tmp = o2;
    o2 = d2;
    d2 = tmp;
  }
  if (!libtess.geom.vertLeq(o1, o2)) {
    // Swap(o1, o2);
    tmp = o1;
    o1 = o2;
    o2 = tmp;
    // Swap(d1, d2);
    tmp = d1;
    d1 = d2;
    d2 = tmp;
  }

  if (!libtess.geom.vertLeq(o2, d1)) {
    // Technically, no intersection -- do our best
    v.s = (o2.s + d1.s) / 2;

  } else if (libtess.geom.vertLeq(d1, d2)) {
    // Interpolate between o2 and d1
    z1 = libtess.geom.edgeEval(o1, o2, d1);
    z2 = libtess.geom.edgeEval(o2, d1, d2);
    if (z1 + z2 < 0) { z1 = -z1; z2 = -z2; }
    v.s = libtess.geom.interpolate_(z1, o2.s, z2, d1.s);

  } else {
    // Interpolate between o2 and d2
    z1 = libtess.geom.edgeSign(o1, o2, d1);
    z2 = -libtess.geom.edgeSign(o1, d2, d1);
    if (z1 + z2 < 0) { z1 = -z1; z2 = -z2; }
    v.s = libtess.geom.interpolate_(z1, o2.s, z2, d2.s);
  }

  // Now repeat the process for t
  if (!libtess.geom.transLeq(o1, d1)) {
    // Swap(o1, d1);
    tmp = o1;
    o1 = d1;
    d1 = tmp;
  }
  if (!libtess.geom.transLeq(o2, d2)) {
    // Swap(o2, d2);
    tmp = o2;
    o2 = d2;
    d2 = tmp;
  }
  if (!libtess.geom.transLeq(o1, o2)) {
    // Swap(o1, o2);
    tmp = o1;
    o1 = o2;
    o2 = tmp;
    // Swap(d1, d2);
    tmp = d1;
    d1 = d2;
    d2 = tmp;
  }

  if (!libtess.geom.transLeq(o2, d1)) {
    // Technically, no intersection -- do our best
    v.t = (o2.t + d1.t) / 2;

  } else if (libtess.geom.transLeq(d1, d2)) {
    // Interpolate between o2 and d1
    z1 = libtess.geom.transEval(o1, o2, d1);
    z2 = libtess.geom.transEval(o2, d1, d2);
    if (z1 + z2 < 0) { z1 = -z1; z2 = -z2; }
    v.t = libtess.geom.interpolate_(z1, o2.t, z2, d1.t);

  } else {
    // Interpolate between o2 and d2
    z1 = libtess.geom.transSign(o1, o2, d1);
    z2 = -libtess.geom.transSign(o1, d2, d1);
    if (z1 + z2 < 0) { z1 = -z1; z2 = -z2; }
    v.t = libtess.geom.interpolate_(z1, o2.t, z2, d2.t);
  }
};

/* global libtess */

// TODO(bckenny): could maybe merge GluMesh and mesh.js since these are
// operations on the mesh

/** @const */
libtess.mesh = {};

/****************** Basic Edge Operations **********************/


/**
 * makeEdge creates one edge, two vertices, and a loop (face).
 * The loop consists of the two new half-edges.
 *
 * @param {libtess.GluMesh} mesh [description].
 * @return {libtess.GluHalfEdge} [description].
 */
libtess.mesh.makeEdge = function(mesh) {
  // TODO(bckenny): probably move to GluMesh, but needs Make* methods with it

  var e = libtess.mesh.makeEdgePair_(mesh.eHead);

  // complete edge with vert