/* X_ITE v12.1.2 */
(function webpackUniversalModuleDefinition(root, factory) {
	if(typeof exports === 'object' && typeof module === 'object')
		module.exports = factory();
	else if(typeof define === 'function' && define.amd)
		define([], factory);
	else if(typeof exports === 'object')
		exports["X3D"] = factory();
	else
		root["X3D"] = factory();
})(self, () => {
return /******/ (() => { // webpackBootstrap
/******/ 	var __webpack_modules__ = ({

/***/ 44:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(2340);
/* harmony import */ var _Core_X3DChildNode_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(5084);
/* harmony import */ var _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(2212);
/* harmony import */ var _standard_Math_Algorithm_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(780);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(717);





function X3DInterpolatorNode (executionContext)
{
   _Core_X3DChildNode_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .call (this, executionContext);

   this .addType (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .X3DInterpolatorNode);
}

Object .assign (Object .setPrototypeOf (X3DInterpolatorNode .prototype, _Core_X3DChildNode_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .prototype),
{
   setup ()
   {
      // If an X3DInterpolatorNode value_changed outputOnly field is read before it receives any inputs,
      // keyValue[0] is returned if keyValue is not empty. If keyValue is empty (i.e., [ ]), the initial
      // value for the respective field type is returned (EXAMPLE  (0, 0, 0) for Fields .SFVec3f);

      this .set_key__ ();
      this .set_fraction__ ();

      _Core_X3DChildNode_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .prototype .setup .call (this);
   },
   initialize ()
   {
      _Core_X3DChildNode_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .prototype .initialize .call (this);

      this ._set_fraction .addInterest ("set_fraction__", this);
      this ._key          .addInterest ("set_key__",      this);
   },
   set_fraction__ ()
   {
      const
         key      = this ._key,
         length   = key .length,
         fraction = this ._set_fraction .getValue ();

      switch (length)
      {
         case 0:
            // Interpolator nodes containing no keys in the key field shall not produce any events.
            return;
         case 1:
            return this .interpolate (0, 0, 0);
         default:
         {
            if (fraction <= key [0])
               return this .interpolate (0, 1, 0);

            const index1 = _standard_Math_Algorithm_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .upperBound (key, 0, length, fraction);

            if (index1 !== length)
            {
               const
                  index0 = index1 - 1,
                  weight = (fraction - key [index0]) / (key [index1] - key [index0]);

               this .interpolate (index0, index1, _standard_Math_Algorithm_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .clamp (weight, 0, 1));
            }
            else
               this .interpolate (length - 2, length - 1, 1);
         }
      }
   },
   set_key__ ()
   {
      this .set_keyValue__ ();
   },
});

Object .defineProperties (X3DInterpolatorNode, _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .getStaticProperties ("X3DInterpolatorNode", "Interpolation", 1));

const __default__ = X3DInterpolatorNode;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .add ("X3DInterpolatorNode", __default__));

/***/ }),

/***/ 223:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Fields_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(4598);
/* harmony import */ var _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(2340);
/* harmony import */ var _Core_X3DChildNode_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(5084);
/* harmony import */ var _X3DBoundedObject_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(2526);
/* harmony import */ var _Rendering_TraverseType_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(2927);
/* harmony import */ var _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(2212);
/* harmony import */ var _Base_X3DCast_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(7638);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(717);








function X3DGroupingNode (executionContext)
{
   _Core_X3DChildNode_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A     .call (this, executionContext);
   _X3DBoundedObject_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .call (this, executionContext);

   this .addType (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .X3DGroupingNode);

   this .addChildObjects (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .outputOnly, "rebuild", new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFTime ());

   this .setBoundedObject (true);
   this .setPointingObject (true);
   this .setCollisionObject (true);
   this .setShadowObject (true);
   this .setVisibleObject (true);

   // Private properties

   this .allowedTypes              = new Set ();
   this .pointingDeviceSensorNodes = new Set ();
   this .pointingObjects           = new Set ();
   this .clipPlaneNodes            = new Set ();
   this .displayNodes              = new Set ();
   this .cameraObjects             = new Set ();
   this .pickableSensorNodes       = new Set ();
   this .pickableObjects           = new Set ();
   this .collisionObjects          = new Set ();
   this .shadowObjects             = new Set ();
   this .childNodes                = new Set ();
   this .visibleObjects            = new Set ();
   this .boundedObjects            = new Set ();
   this .sensors                   = [ ];
}

Object .assign (Object .setPrototypeOf (X3DGroupingNode .prototype, _Core_X3DChildNode_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .prototype),
   _X3DBoundedObject_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .prototype,
{
   initialize ()
   {
      _Core_X3DChildNode_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A     .prototype .initialize .call (this);
      _X3DBoundedObject_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .prototype .initialize .call (this);

      this ._rebuild          .addInterest ("set_children__",        this);
      this ._transformSensors .addInterest ("set_pickableObjects__", this);

      this ._bboxSize       .addInterest ("set_boundedObjects__", this);
      this ._addChildren    .addInterest ("set_addChildren__",    this);
      this ._removeChildren .addInterest ("set_removeChildren__", this);
      this ._children       .addInterest ("requestRebuild",       this);

      this .set_children__ ();
   },
   addAllowedTypes (... types)
   {
      for (const type of types)
         this .allowedTypes .add (type);
   },
   getBBox (bbox, shadows)
   {
      if (this .isDefaultBBoxSize ())
         return this .getSubBBox (bbox, shadows);

      return bbox .set (this ._bboxSize .getValue (), this ._bboxCenter .getValue ());
   },
   getSubBBox (bbox, shadows)
   {
      return _X3DBoundedObject_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .prototype .getBBox .call (this, this .boundedObjects, bbox, shadows);
   },
   getShapes (shapes, modelMatrix)
   {
      for (const visibleObject of this .visibleObjects)
         visibleObject .getShapes (shapes, modelMatrix);

      return shapes;
   },
   requestRebuild ()
   {
      this ._rebuild .addEvent ();
   },
   set_addChildren__ ()
   {
      if (this ._addChildren .length === 0)
         return;

      this ._addChildren .setTainted (true);

      const addChildren = new Set (this ._addChildren);

      for (const node of this ._children)
         addChildren .delete (node);

      this .addChildren (addChildren);

      if (!this ._children .isTainted ())
      {
         this ._children .removeInterest ("requestRebuild", this);
         this ._children .addInterest ("connectChildren", this);
      }

      for (const child of addChildren)
         this ._children .push (child);

      this ._addChildren .length = 0;
      this ._addChildren .setTainted (false);
   },
   set_removeChildren__ ()
   {
      if (this ._removeChildren .length === 0)
         return;

      this ._removeChildren .setTainted (true);

      if (this ._children .length > 0)
      {
         const removeChildren = new Set (this ._removeChildren);

         this .removeChildren (removeChildren);

         if (!this ._children .isTainted ())
         {
            this ._children .removeInterest ("requestRebuild", this);
            this ._children .addInterest ("connectChildren", this);
         }

         this ._children = this ._children .filter (child => !removeChildren .has (child));
      }

      this ._removeChildren .length = 0;
      this ._removeChildren .setTainted (false);
   },
   set_children__ ()
   {
      this .clearChildren ();
      this .addChildren (this ._children);
   },
   connectChildren ()
   {
      this ._children .removeInterest ("connectChildren", this);
      this ._children .addInterest ("requestRebuild", this);
   },
   clearChildren ()
   {
      for (const childNode of this .childNodes)
      {
         childNode ._isBoundedObject   .removeInterest ("requestRebuild", this);
         childNode ._isPointingObject  .removeInterest ("requestRebuild", this);
         childNode ._isCameraObject    .removeInterest ("requestRebuild", this);
         childNode ._isPickableObject  .removeInterest ("requestRebuild", this);
         childNode ._isCollisionObject .removeInterest ("requestRebuild", this);
         childNode ._isShadowObject    .removeInterest ("requestRebuild", this);
         childNode ._isVisibleObject   .removeInterest ("requestRebuild", this);

         if ((0,_Base_X3DCast_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A) (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .X3DBoundedObject, childNode))
         {
            childNode ._display     .removeInterest ("requestRebuild", this);
            childNode ._bboxDisplay .removeInterest ("requestRebuild", this);
         }
      }

      this .boundedObjects            .clear ();
      this .pointingDeviceSensorNodes .clear ();
      this .pointingObjects           .clear ();
      this .clipPlaneNodes            .clear ();
      this .displayNodes              .clear ();
      this .cameraObjects             .clear ();
      this .pickableSensorNodes       .clear ();
      this .pickableObjects           .clear ();
      this .collisionObjects          .clear ();
      this .shadowObjects             .clear ();
      this .childNodes                .clear ();
      this .visibleObjects            .clear ();
   },
   addChildren (children)
   {
      // Make sure that the order of children is preserved,
      // otherwise flickering of transparent objects may occur.

      for (const child of children)
         this .addChild (child);

      this .set_objects__ ();
   },
   addChild (child)
   {
      const childNode = (0,_Base_X3DCast_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A) (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .X3DChildNode, child);

      if (!childNode)
         return;

      const type = childNode .getType ();

      if (this .allowedTypes .size)
      {
         if (!type .some (Set .prototype .has, this .allowedTypes))
            return;
      }

      for (let t = type .length - 1; t >= 0; -- t)
      {
         switch (type [t])
         {
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .X3DPointingDeviceSensorNode:
            {
               this .pointingDeviceSensorNodes .add (childNode);
               continue;
            }
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .ClipPlane:
            {
               this .clipPlaneNodes .add (childNode);
               this .displayNodes   .add (childNode);
               continue;
            }
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .LocalFog:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .X3DLightNode:
            {
               this .displayNodes .add (childNode);
               continue;
            }
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .TransformSensor:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .X3DPickSensorNode:
            {
               if (childNode .isPickableObject ())
                  this .pickableSensorNodes .add (childNode);

               continue;
            }
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .X3DChildNode:
            {
               childNode ._isBoundedObject   .addInterest ("requestRebuild", this);
               childNode ._isPointingObject  .addInterest ("requestRebuild", this);
               childNode ._isCameraObject    .addInterest ("requestRebuild", this);
               childNode ._isPickableObject  .addInterest ("requestRebuild", this);
               childNode ._isCollisionObject .addInterest ("requestRebuild", this);
               childNode ._isShadowObject    .addInterest ("requestRebuild", this);
               childNode ._isVisibleObject   .addInterest ("requestRebuild", this);

               this .childNodes .add (childNode);

               if (childNode .isVisible ())
               {
                  if (childNode .isBoundedObject ())
                     this .boundedObjects .add (childNode);

                  if (childNode .isPointingObject ())
                     this .pointingObjects .add (childNode);

                  if (childNode .isCameraObject ())
                     this .cameraObjects .add (childNode);

                  if (childNode .isPickableObject () && !this .pickableSensorNodes .has (childNode))
                     this .pickableObjects .add (childNode);

                  if (childNode .isCollisionObject ())
                     this .collisionObjects .add (childNode);

                  if (childNode .isShadowObject ())
                     this .shadowObjects .add (childNode);

                  if (childNode .isVisibleObject ())
                     this .visibleObjects .add (childNode);
               }

               if ((0,_Base_X3DCast_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A) (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .X3DBoundedObject, childNode))
               {
                  childNode ._display     .addInterest ("requestRebuild", this);
                  childNode ._bboxDisplay .addInterest ("requestRebuild", this);

                  if (childNode .isBBoxVisible ())
                     this .visibleObjects .add (childNode .getBBoxNode ());
               }

               break;
            }
            default:
               continue;
         }

         break;
      }
   },
   removeChildren (children)
   {
      for (const child of children)
         this .removeChild (child);

      this .set_objects__ ();
   },
   removeChild (child)
   {
      const childNode = (0,_Base_X3DCast_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A) (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .X3DChildNode, child);

      if (!childNode)
         return;

      const type = childNode .getType ();

      for (let t = type .length - 1; t >= 0; -- t)
      {
         switch (type [t])
         {
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .X3DPointingDeviceSensorNode:
            {
               this .pointingDeviceSensorNodes .delete (childNode);
               continue;
            }
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .ClipPlane:
            {
               this .clipPlaneNodes .delete (childNode);
               this .displayNodes   .delete (childNode);
               continue;
            }
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .LocalFog:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .X3DLightNode:
            {
               this .displayNodes .delete (childNode);
               continue;
            }
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .TransformSensor:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .X3DPickSensorNode:
            {
               this .pickableSensorNodes .delete (childNode);
               continue;
            }
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .X3DChildNode:
            {
               childNode ._isBoundedObject   .removeInterest ("requestRebuild", this);
               childNode ._isPointingObject  .removeInterest ("requestRebuild", this);
               childNode ._isCameraObject    .removeInterest ("requestRebuild", this);
               childNode ._isPickableObject  .removeInterest ("requestRebuild", this);
               childNode ._isCollisionObject .removeInterest ("requestRebuild", this);
               childNode ._isShadowObject    .removeInterest ("requestRebuild", this);
               childNode ._isVisibleObject   .removeInterest ("requestRebuild", this);

               if ((0,_Base_X3DCast_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A) (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .X3DBoundedObject, childNode))
               {
                  childNode ._display     .removeInterest ("requestRebuild", this);
                  childNode ._bboxDisplay .removeInterest ("requestRebuild", this);
               }

               this .boundedObjects   .delete (childNode);
               this .pointingObjects  .delete (childNode);
               this .cameraObjects    .delete (childNode);
               this .pickableObjects  .delete (childNode);
               this .collisionObjects .delete (childNode);
               this .shadowObjects    .delete (childNode);
               this .childNodes       .delete (childNode);
               this .visibleObjects   .delete (childNode);
               break;
            }
            default:
               continue;
         }

         break;
      }
   },
   set_objects__ ()
   {
      this .set_boundedObjects__ ();
      this .set_pointingObjects__ ();
      this .set_cameraObjects__ ();
      this .set_pickableObjects__ ();
      this .set_collisionObjects__ ();
      this .set_shadowObjects__ ();
      this .set_visibleObjects__ ();
   },
   set_boundedObjects__ ()
   {
      this .setBoundedObject (this .boundedObjects .size || !this .isDefaultBBoxSize ());
   },
   set_pointingObjects__ ()
   {
      this .setPointingObject (this .pointingObjects .size);
   },
   set_cameraObjects__ ()
   {
      this .setCameraObject (this .cameraObjects .size);
   },
   set_pickableObjects__ ()
   {
      this .setPickableObject (this .getTransformSensors () .size || this .pickableSensorNodes .size || this .pickableObjects .size);
   },
   set_collisionObjects__ ()
   {
      this .setCollisionObject (this .collisionObjects .size);
   },
   set_shadowObjects__ ()
   {
      this .setShadowObject (this .shadowObjects .size);
   },
   set_visibleObjects__ ()
   {
      this .setVisibleObject (this .visibleObjects .size);
   },
   traverse (type, renderObject)
   {
      switch (type)
      {
         case _Rendering_TraverseType_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .POINTER:
         {
            const
               pointingDeviceSensorNodes = this .pointingDeviceSensorNodes,
               clipPlaneNodes            = this .clipPlaneNodes,
               sensors                   = this .sensors;

            sensors .length = 0;

            if (pointingDeviceSensorNodes .size)
            {
               for (const pointingDeviceSensorNode of pointingDeviceSensorNodes)
                  pointingDeviceSensorNode .push (renderObject, sensors);

               if (sensors .length)
                  renderObject .getSensors () .push (sensors);
            }

            for (const clipPlaneNode of clipPlaneNodes)
               clipPlaneNode .push (renderObject);

            for (const pointingObject of this .pointingObjects)
               pointingObject .traverse (type, renderObject);

            for (const clipPlaneNode of clipPlaneNodes)
               clipPlaneNode .pop (renderObject);

            if (sensors .length)
               renderObject .getSensors () .pop ();

            return;
         }
         case _Rendering_TraverseType_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .CAMERA:
         {
            for (const cameraObject of this .cameraObjects)
               cameraObject .traverse (type, renderObject);

            return;
         }
         case _Rendering_TraverseType_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .PICKING:
         {
            if (this .getTransformSensors () .size)
            {
               const modelMatrix = renderObject .getModelViewMatrix () .get ();

               for (const transformSensorNode of this .getTransformSensors ())
                  transformSensorNode .collect (modelMatrix);
            }

            for (const pickableSensorNode of this .pickableSensorNodes)
               pickableSensorNode .traverse (type, renderObject);

            const
               browser          = this .getBrowser (),
               pickingHierarchy = browser .getPickingHierarchy ();

            pickingHierarchy .push (this);

            if (browser .getPickable () .at (-1))
            {
               for (const visibleObject of this .visibleObjects)
                  visibleObject .traverse (type, renderObject);
            }
            else
            {
               for (const pickableObject of this .pickableObjects)
                  pickableObject .traverse (type, renderObject);
            }

            pickingHierarchy .pop ();
            return;
         }
         case _Rendering_TraverseType_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .COLLISION:
         {
            const clipPlaneNodes = this .clipPlaneNodes;

            for (const clipPlaneNode of clipPlaneNodes)
               clipPlaneNode .push (renderObject);

            for (const collisionObject of this .collisionObjects)
               collisionObject .traverse (type, renderObject);

            for (const clipPlaneNode of clipPlaneNodes)
               clipPlaneNode .pop (renderObject);

            return;
         }
         case _Rendering_TraverseType_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .SHADOW:
         {
            // Nodes that are not visible do not cast shadows.

            const clipPlaneNodes = this .clipPlaneNodes;

            for (const clipPlaneNode of clipPlaneNodes)
               clipPlaneNode .push (renderObject);

            for (const shadowObject of this .shadowObjects)
               shadowObject .traverse (type, renderObject);

            for (const clipPlaneNode of clipPlaneNodes)
               clipPlaneNode .pop (renderObject);

            return;
         }
         case _Rendering_TraverseType_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .DISPLAY:
         {
            const displayNodes = this .displayNodes;

            for (const displayNode of displayNodes)
               displayNode .push (renderObject, this);

            for (const visibleObject of this .visibleObjects)
               visibleObject .traverse (type, renderObject);

            for (const displayNode of displayNodes)
               displayNode .pop (renderObject);

            return;
         }
      }
   },
   dispose ()
   {
      _X3DBoundedObject_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .prototype .dispose .call (this);
      _Core_X3DChildNode_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A     .prototype .dispose .call (this);
   },
});

Object .defineProperties (X3DGroupingNode, _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .getStaticProperties ("X3DGroupingNode", "Grouping", 1));

const __default__ = X3DGroupingNode;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .add ("X3DGroupingNode", __default__));

/***/ }),

/***/ 282:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _X3DField_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(2269);
/* harmony import */ var _Features_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(7859);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(717);




function X3DArrayField (value)
{
   _X3DField_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .call (this, value);
}

Object .assign (Object .setPrototypeOf (X3DArrayField .prototype, _X3DField_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .prototype),
{
   // Implement all function also in TypedArray, if possible.
   at: Array .prototype .at,
   concat: Array .prototype .concat,
   // copyWithin: Array.prototype.copyWithin,
   entries: Array .prototype .entries,
   every: Array .prototype .every,
   fill: Array .prototype .fill,
   filter (/* callbackFn, thisArg */)
   {
      const array = new (this .constructor) ();

      for (const v of Array .prototype .filter .call (this, ... arguments))
         array .push (v);

      return array;
   },
   find: Array .prototype .find,
   findIndex: Array .prototype .findIndex,
   findLast: Array .prototype .findLast,
   findLastIndex: Array .prototype .findLastIndex,
   flat: Array .prototype .flat,
   flatMap: Array .prototype .flatMap,
   forEach: Array .prototype .forEach,
   includes: Array .prototype .includes,
   indexOf: Array .prototype .indexOf,
   join: Array .prototype .join,
   keys: Array .prototype .keys,
   lastIndexOf: Array .prototype .lastIndexOf,
   map (/* callbackFn, thisArg */)
   {
      const array = new (this .constructor) ();

      for (const v of Array .prototype .map .call (this, ... arguments))
         array .push (v);

      return array;
   },
   reduce: Array .prototype .reduce,
   reduceRight: Array .prototype .reduceRight,
   reverse: Array .prototype .reverse,
   slice (/* start, end */)
   {
      const array = new (this .constructor) ();

      for (const v of Array .prototype .slice .call (this, ... arguments))
         array .push (v);

      return array;
   },
   some: Array .prototype .some,
   sort: Array .prototype .sort,
   toReversed ()
   {
      return this .copy () .reverse ();
   },
   toSorted (/* compareFn */)
   {
      return this .copy () .sort (... arguments);
   },
   toSpliced (/* start, deleteCount, ... insertValues */)
   {
      const copy = this .copy ();

      copy .splice (... arguments);

      return copy;
   },
   values: Array .prototype .values,
   with (index, value)
   {
      const copy = this .copy ();

      copy [index] = value;

      return copy;
   },
});

for (const key of Object .keys (X3DArrayField .prototype))
   Object .defineProperty (X3DArrayField .prototype, key, { enumerable: false });

const __default__ = X3DArrayField;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .add ("X3DArrayField", __default__));

/***/ }),

/***/ 336:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _x_ite_Namespace_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(717);
const
   extents1 = { min: 0, max: 0 },
   extents2 = { min: 0, max: 0 };

/**
 *  Class to represent the Separating Axis Theorem.
 */
function SAT () { }

SAT .isSeparated = function (axes, points1, points2)
{
   // https://gamedev.stackexchange.com/questions/25397/obb-vs-obb-collision-detection

   for (const axis of axes)
   {
      project (points1, axis, extents1);
      project (points2, axis, extents2);

      if (overlaps (extents1 .min, extents1 .max, extents2 .min, extents2 .max))
         continue;

      return true;
   }

   return false;
};

///  Projects @a points to @a axis and returns the minimum and maximum bounds.
function project (points, axis, extents)
{
   extents .min = Number .POSITIVE_INFINITY;
   extents .max = Number .NEGATIVE_INFINITY;

   for (const point of points)
   {
      // Just dot it to get the min and max along this axis.
      // NOTE: the axis must be normalized to get accurate projections to calculate the MTV, but if it is only needed to
      // know whether it overlaps, every axis can be used.

      const dotVal = point .dot (axis);

      if (dotVal < extents .min)
         extents .min = dotVal;

      if (dotVal > extents .max)
         extents .max = dotVal;
   }
}

///  Returns true if both ranges overlap, otherwise false.
function overlaps (min1, max1, min2, max2)
{
   return is_between (min2, min1, max1) || is_between (min1, min2, max2);
}

///  Returns true if @a value is between @a lowerBound and @a upperBound, otherwise false.
function is_between (value, lowerBound, upperBound)
{
   return lowerBound <= value && value <= upperBound;
}

const __default__ = SAT;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_x_ite_Namespace_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .add ("SAT", __default__));

/***/ }),

/***/ 353:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Fields_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(4598);
/* harmony import */ var _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(2340);
/* harmony import */ var _Core_X3DBindableNode_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(1275);
/* harmony import */ var _Browser_Rendering_GeometryContext_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(681);
/* harmony import */ var _Rendering_VertexArray_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(2062);
/* harmony import */ var _Rendering_TraverseType_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(2927);
/* harmony import */ var _Browser_Shape_AlphaMode_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(3500);
/* harmony import */ var _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(2212);
/* harmony import */ var _Rendering_RenderPass_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(8258);
/* harmony import */ var _standard_Math_Numbers_Complex_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(7955);
/* harmony import */ var _standard_Math_Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(7572);
/* harmony import */ var _standard_Math_Numbers_Rotation4_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(7078);
/* harmony import */ var _standard_Math_Numbers_Matrix4_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(6179);
/* harmony import */ var _standard_Math_Algorithm_js__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(780);
/* harmony import */ var _standard_Utility_BitSet_js__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(828);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(717);
















function X3DBackgroundNode (executionContext)
{
   _Core_X3DBindableNode_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .call (this, executionContext);

   this .addType (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .X3DBackgroundNode);

   this .addChildObjects (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .inputOutput, "hidden", new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFBool ());

   this .setVisibleObject (true);

   // Units

   this ._skyAngle    .setUnit ("angle");
   this ._groundAngle .setUnit ("angle");

   // Private properties

   this .modelMatrix      = new _standard_Math_Numbers_Matrix4_js__WEBPACK_IMPORTED_MODULE_12__/* ["default"] */ .A ();
   this .clipPlanes       = [ ];
   this .colors           = [ ];
   this .sphere           = [ ];
   this .textureNodes     = new Array (6);
   this .textureBits      = new _standard_Utility_BitSet_js__WEBPACK_IMPORTED_MODULE_14__/* ["default"] */ .A ();
   this .sphereContext    = new _Browser_Rendering_GeometryContext_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A ({ colorMaterial: true });
   this .texturesContext  = new _Browser_Rendering_GeometryContext_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A ({ localObjectsKeys: this .sphereContext .localObjectsKeys });
   this .localObjectsKeys = this .sphereContext .localObjectsKeys;

   this [_Rendering_RenderPass_js__WEBPACK_IMPORTED_MODULE_8__/* ["default"] */ .A .RENDER_KEY]         = this;
   this [_Rendering_RenderPass_js__WEBPACK_IMPORTED_MODULE_8__/* ["default"] */ .A .TRANSMISSION_KEY]   = this;
   this [_Rendering_RenderPass_js__WEBPACK_IMPORTED_MODULE_8__/* ["default"] */ .A .VOLUME_SCATTER_KEY] = null;

}

Object .assign (Object .setPrototypeOf (X3DBackgroundNode .prototype, _Core_X3DBindableNode_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .prototype),
{
   initialize ()
   {
      _Core_X3DBindableNode_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .prototype .initialize .call (this);

      const
         browser = this .getBrowser (),
         gl      = browser .getContext ();

      this .colorBuffer         = gl .createBuffer ();
      this .sphereBuffer        = gl .createBuffer ();
      this .texCoordBuffers     = [gl .createBuffer ()];
      this .textureBuffers      = Array .from ({length: 6}, () => gl .createBuffer ());
      this .sphereArrayObject   = new _Rendering_VertexArray_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A (gl);
      this .textureArrayObjects = Array .from ({length: 6}, () => new _Rendering_VertexArray_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A (gl));

      this ._groundAngle .addInterest ("build", this);
      this ._groundColor .addInterest ("build", this);
      this ._skyAngle    .addInterest ("build", this);
      this ._skyColor    .addInterest ("build", this);

      this .build ();
      this .transferRectangle ();
   },
   isHidden ()
   {
      return this ._hidden .getValue ();
   },
   setHidden (value)
   {
      if (value === this ._hidden .getValue ())
         return;

      this ._hidden = value;
   },
   isTransparent ()
   {
      if (this ._hidden .getValue ())
         return true;

      if (this ._transparency .getValue () <= 0)
         return false;

      if (this .textureBits .size !== 6)
         return true;

      for (const i of this .textureBits)
      {
         if (this .textureNodes [i] ._transparent .getValue ())
            return true;
      }

      return false;
   },
   getRenderPassNodes ()
   {
      return this .renderPassNodes;
   },
   set_texture__ (index, textureNode)
   {
      this .textureNodes [index] ?.removeInterest (`set_loadState${index}__`, this);

      this .textureNodes [index] = textureNode;

      textureNode ?.addInterest (`set_loadState${index}__`, this, index, textureNode);

      this .set_loadState__ (index, textureNode);
   },
   set_loadState__ (index, textureNode)
   {
      this .setTextureBit (index, textureNode ?.checkLoadState ());
   },
   setTextureBit (bit, loadState)
   {
      this .textureBits .set (bit, loadState === _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .COMPLETE_STATE);
   },
   getColor (theta, color, angle)
   {
      const index = _standard_Math_Algorithm_js__WEBPACK_IMPORTED_MODULE_13__/* ["default"] */ .A .upperBound (angle, 0, angle .length, theta);

      return color [index];
   },
   build ()
   {
      this .colors .length = 0;
      this .sphere .length = 0;

      if (this ._groundColor .length === 0 && this ._skyColor .length == 1)
      {
         // Build cube

         this .sphere .vertices = 36;

         this .sphere .push ( 1,  1, -1, 1, -1,  1, -1, 1, -1, -1, -1, 1, // Back
                              1,  1, -1, 1, -1, -1, -1, 1,  1, -1, -1, 1,
                             -1,  1,  1, 1,  1,  1,  1, 1, -1, -1,  1, 1, // Front
                             -1, -1,  1, 1,  1,  1,  1, 1,  1, -1,  1, 1,
                             -1,  1, -1, 1, -1,  1,  1, 1, -1, -1,  1, 1, // Left
                             -1,  1, -1, 1, -1, -1,  1, 1, -1, -1, -1, 1,
                              1,  1,  1, 1,  1,  1, -1, 1,  1, -1,  1, 1, // Right
                              1, -1,  1, 1,  1,  1, -1, 1,  1, -1, -1, 1,
                              1,  1,  1, 1, -1,  1,  1, 1, -1,  1, -1, 1, // Top
                              1,  1,  1, 1, -1,  1, -1, 1,  1,  1, -1, 1,
                             -1, -1,  1, 1,  1, -1,  1, 1, -1, -1, -1, 1, // Bottom
                             -1, -1, -1, 1,  1, -1,  1, 1,  1, -1, -1, 1);

         const color = this ._skyColor [0];

         for (let i = 0, vertices = this .sphere .vertices; i < vertices; ++ i)
            this .colors .push (... color, 1);
      }
      else
      {
         // Build sphere

         if (this ._skyColor .length > this ._skyAngle .length)
         {
            const vAngle = this ._skyAngle .slice ();

            if (vAngle .length === 0 || vAngle [0] > 0)
               vAngle .unshift (0);

            if (vAngle .at (-1) < Math .PI)
               vAngle .push (Math .PI);

            if (vAngle .length === 2)
               vAngle .splice (1, 0, (vAngle [0] + vAngle [1]) / 2)

            this .buildSphere (vAngle, this ._skyAngle, this ._skyColor, false);
         }

         if (this ._groundColor .length > this ._groundAngle .length)
         {
            const vAngle = this ._groundAngle .slice () .reverse ();

            if (vAngle .length === 0 || vAngle [0] < Math .PI / 2)
               vAngle .unshift (Math .PI / 2);

            if (vAngle .at (-1) > 0)
               vAngle .push (0);

            this .buildSphere (vAngle, this ._groundAngle, this ._groundColor, true);
         }
      }

      this .transferSphere ();
   },
   buildSphere: (() =>
   {
      const U_DIMENSION = 20;

      const
         z1 = new _standard_Math_Numbers_Complex_js__WEBPACK_IMPORTED_MODULE_9__/* ["default"] */ .A (),
         z2 = new _standard_Math_Numbers_Complex_js__WEBPACK_IMPORTED_MODULE_9__/* ["default"] */ .A (),
         y1 = new _standard_Math_Numbers_Complex_js__WEBPACK_IMPORTED_MODULE_9__/* ["default"] */ .A (),
         y2 = new _standard_Math_Numbers_Complex_js__WEBPACK_IMPORTED_MODULE_9__/* ["default"] */ .A (),
         y3 = new _standard_Math_Numbers_Complex_js__WEBPACK_IMPORTED_MODULE_9__/* ["default"] */ .A (),
         y4 = new _standard_Math_Numbers_Complex_js__WEBPACK_IMPORTED_MODULE_9__/* ["default"] */ .A ();

      return function (vAngle, angle, color, bottom)
      {
         const
            vAngleMax   = bottom ? Math .PI / 2 : Math .PI,
            V_DIMENSION = vAngle .length - 1;

         for (let v = 0; v < V_DIMENSION; ++ v)
         {
            let
               theta1 = _standard_Math_Algorithm_js__WEBPACK_IMPORTED_MODULE_13__/* ["default"] */ .A .clamp (vAngle [v],     0, vAngleMax),
               theta2 = _standard_Math_Algorithm_js__WEBPACK_IMPORTED_MODULE_13__/* ["default"] */ .A .clamp (vAngle [v + 1], 0, vAngleMax);

            if (bottom)
            {
               theta1 = Math .PI - theta1;
               theta2 = Math .PI - theta2;
            }

            z1 .setPolar (1, theta1);
            z2 .setPolar (1, theta2);

            const
               c1 = this .getColor (vAngle [v],     color, angle),
               c2 = this .getColor (vAngle [v + 1], color, angle);

            for (let u = 0; u < U_DIMENSION; ++ u)
            {
               // p4 --- p1
               //  |   / |
               //  | /   |
               // p3 --- p2

               // The last point is the first one.
               const u1 = u < U_DIMENSION - 1 ? u + 1 : 0;

               // p1, p2
               let phi = 2 * Math .PI * (u / U_DIMENSION);
               y1 .setPolar (-z1 .imag, phi);
               y2 .setPolar (-z2 .imag, phi);

               // p3, p4
               phi = 2 * Math .PI * (u1 / U_DIMENSION);
               y3 .setPolar (-z2 .imag, phi);
               y4 .setPolar (-z1 .imag, phi);

               // Triangle 1 and 2

               this .colors .push (... c1, 1,
                                   ... c2, 1,
                                   ... c2, 1,
                                   // Triangle 2
                                   ... c1, 1,
                                   ... c1, 1,
                                   ... c2, 1);

               this .sphere .push (y1 .imag, z1 .real, y1 .real, 1,
                                   y3 .imag, z2 .real, y3 .real, 1,
                                   y2 .imag, z2 .real, y2 .real, 1,
                                   // Triangle 2
                                   y1 .imag, z1 .real, y1 .real, 1,
                                   y4 .imag, z1 .real, y4 .real, 1,
                                   y3 .imag, z2 .real, y3 .real, 1);
            }
         }
      };
   })(),
   transferSphere ()
   {
      const gl = this .getBrowser () .getContext ();

      // Transfer colors.

      gl .bindBuffer (gl .ARRAY_BUFFER, this .colorBuffer);
      gl .bufferData (gl .ARRAY_BUFFER, new Float32Array (this .colors), gl .DYNAMIC_DRAW);

      // Transfer sphere.

      gl .bindBuffer (gl .ARRAY_BUFFER, this .sphereBuffer);
      gl .bufferData (gl .ARRAY_BUFFER, new Float32Array (this .sphere), gl .DYNAMIC_DRAW);

      this .sphereCount = this .sphere .length / 4;
   },
   transferRectangle: (() =>
   {
      const texCoords = new Float32Array ([
         1, 1, 0, 1,
         0, 1, 0, 1,
         0, 0, 0, 1,
         1, 1, 0, 1,
         0, 0, 0, 1,
         1, 0, 0, 1,
      ]);

      const frontVertices = new Float32Array ([
         1,  1, -1, 1,
        -1,  1, -1, 1,
        -1, -1, -1, 1,
         1,  1, -1, 1,
        -1, -1, -1, 1,
         1, -1, -1, 1,
      ]);

      const backVertices = new Float32Array ([
         -1,  1,  1, 1,
          1,  1,  1, 1,
          1, -1,  1, 1,
         -1,  1,  1, 1,
          1, -1,  1, 1,
         -1, -1,  1, 1,
      ]);

      const leftVertices = new Float32Array ([
         -1,  1, -1, 1,
         -1,  1,  1, 1,
         -1, -1,  1, 1,
         -1,  1, -1, 1,
         -1, -1,  1, 1,
         -1, -1, -1, 1,
      ]);

      const rightVertices = new Float32Array ([
         1,  1,  1, 1,
         1,  1, -1, 1,
         1, -1, -1, 1,
         1,  1,  1, 1,
         1, -1, -1, 1,
         1, -1,  1, 1,
      ]);

      const topVertices = new Float32Array ([
          1, 1,  1, 1,
         -1, 1,  1, 1,
         -1, 1, -1, 1,
          1, 1,  1, 1,
         -1, 1, -1, 1,
          1, 1, -1, 1,
      ]);

      const bottomVertices = new Float32Array ([
          1, -1, -1, 1,
         -1, -1, -1, 1,
         -1, -1,  1, 1,
          1, -1, -1, 1,
         -1, -1,  1, 1,
          1, -1,  1, 1,
      ]);

      const vertices = [
         frontVertices,
         backVertices,
         leftVertices,
         rightVertices,
         topVertices,
         bottomVertices,
      ];

      return function ()
      {
         const gl = this .getBrowser () .getContext ();

         // Transfer texCoords.

         gl .bindBuffer (gl .ARRAY_BUFFER, this .texCoordBuffers [0]);
         gl .bufferData (gl .ARRAY_BUFFER, texCoords, gl .DYNAMIC_DRAW);

         // Transfer rectangle.

         for (let i = 0; i < 6; ++ i)
         {
            gl .bindBuffer (gl .ARRAY_BUFFER, this .textureBuffers [i]);
            gl .bufferData (gl .ARRAY_BUFFER, vertices [i], gl .DYNAMIC_DRAW);
         }
      };
   })(),
   traverse (type, renderObject)
   {
      switch (type)
      {
         case _Rendering_TraverseType_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .CAMERA:
         {
            renderObject .getLayer () .getBackgrounds () .push (this);

            this .modelMatrix .assign (renderObject .getModelViewMatrix () .get ());
            return;
         }
         case _Rendering_TraverseType_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .DISPLAY:
         {
            const
               localObjects     = renderObject .getLocalObjects (),
               clipPlanes       = this .clipPlanes,
               localObjectsKeys = this .localObjectsKeys;

            let c = 0;

            for (const localObject of localObjects)
            {
               if (localObject .isClipPlane)
                  clipPlanes [c ++] = localObject;
            }

            clipPlanes       .length = c;
            localObjectsKeys .length = c;
            localObjectsKeys .fill (0);
            return;
         }
      }
   },
   display: (() =>
   {
      const
         projectionMatrixArray = new Float32Array (16),
         projectionMatrix      = new _standard_Math_Numbers_Matrix4_js__WEBPACK_IMPORTED_MODULE_12__/* ["default"] */ .A (),
         projectionScale       = new _standard_Math_Numbers_Matrix4_js__WEBPACK_IMPORTED_MODULE_12__/* ["default"] */ .A (1,0,0,0, 0,1,0,0, 0,0,0,0, 0,0,0,1),
         modelViewMatrixArray  = new Float32Array (16),
         modelViewMatrix       = new _standard_Math_Numbers_Matrix4_js__WEBPACK_IMPORTED_MODULE_12__/* ["default"] */ .A (),
         rotation              = new _standard_Math_Numbers_Rotation4_js__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A (),
         scale                 = new _standard_Math_Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_10__/* ["default"] */ .A ();

      return function (gl, renderObject)
      {
         if (this ._hidden .getValue ())
            return;

         const browser = this .getBrowser ();

         // Always fill background.

         if (browser .getWireframe ())
         {
            const ext = gl .getExtension ("WEBGL_polygon_mode");

            ext ?.polygonModeWEBGL (gl .FRONT_AND_BACK, ext .FILL_WEBGL);
         }

         // Setup context.

         gl .disable (gl .DEPTH_TEST);
         gl .depthMask (false);
         gl .enable (gl .CULL_FACE);
         gl .frontFace (gl .CCW);

         // Create projection matrix.
         // The projectionScale will set gl_Position.z to 0,
         // so it is in the middle of near and far plane.

         projectionMatrixArray .set (projectionMatrix
            .assign (renderObject .getProjectionMatrixArray ())
            .multRight (projectionScale));

         // Rotate and scale background.

         const far = renderObject .getViewpoint () .getMaxFarValue ();

         modelViewMatrix .assign (this .modelMatrix);
         modelViewMatrix .multRight (renderObject .getViewMatrix () .get ());
         modelViewMatrix .get (null, rotation);
         modelViewMatrix .identity ();
         modelViewMatrix .rotate (rotation);
         modelViewMatrix .scale (scale .set (far, far, far));

         modelViewMatrixArray .set (modelViewMatrix);

         // Draw background sphere and texture cube.

         this .drawSphere (renderObject, modelViewMatrixArray, projectionMatrixArray);

         if (+this .textureBits)
            this .drawCube (renderObject, modelViewMatrixArray, projectionMatrixArray);

         gl .depthMask (true);
         gl .enable (gl .DEPTH_TEST);
         gl .disable (gl .BLEND);

         // Restore polygon mode.

         if (browser .getWireframe ())
         {
            const ext = gl .getExtension ("WEBGL_polygon_mode");

            ext ?.polygonModeWEBGL (gl .FRONT_AND_BACK, ext .LINE_WEBGL);
         }
      };
   })(),
   drawSphere (renderObject, modelViewMatrixArray, projectionMatrixArray)
   {
      const transparency = _standard_Math_Algorithm_js__WEBPACK_IMPORTED_MODULE_13__/* ["default"] */ .A .clamp (this ._transparency .getValue (), 0, 1);

      if (transparency === 1)
         return;

      const
         browser       = this .getBrowser (),
         gl            = browser .getContext (),
         sphereContext = this .sphereContext;

      sphereContext .alphaMode    = transparency ? _Browser_Shape_AlphaMode_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .BLEND : _Browser_Shape_AlphaMode_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .OPAQUE;
      sphereContext .renderObject = renderObject;

      const shaderNode = browser .getDefaultMaterial () .getShader (sphereContext);

      shaderNode .enable (gl);
      shaderNode .setClipPlanes (gl, this .clipPlanes, renderObject);

      // Uniforms

      gl .uniformMatrix4fv (shaderNode .x3d_ProjectionMatrix, false, projectionMatrixArray);
      gl .uniformMatrix4fv (shaderNode .x3d_EyeMatrix,        false, renderObject .getEyeMatrixArray ());
      gl .uniformMatrix4fv (shaderNode .x3d_ModelViewMatrix,  false, modelViewMatrixArray);

      gl .uniform3f (shaderNode .x3d_EmissiveColor,                      1, 1, 1)
      gl .uniform1f (shaderNode .x3d_Transparency,                       transparency)
      gl .uniform1i (shaderNode .x3d_TextureCoordinateGeneratorMode [0], 0);
      gl .uniform1f (shaderNode .x3d_Exposure,                           1);

      // Enable vertex attribute arrays.

      if (this .sphereArrayObject .enable (shaderNode .getProgram ()))
      {
         shaderNode .enableColorAttribute  (gl, this .colorBuffer,  0, 0);
         shaderNode .enableVertexAttribute (gl, this .sphereBuffer, 0, 0);
      }

      // Draw.

      if (transparency)
         gl .enable (gl .BLEND);
      else
         gl .disable (gl .BLEND);

      gl .drawArrays (gl .TRIANGLES, 0, this .sphereCount);

      gl .uniform1f (shaderNode .x3d_Exposure, Math .max (browser .getBrowserOption ("Exposure"), 0));
   },
   drawCube: (() =>
   {
      const textureMatrixArray = new Float32Array (_standard_Math_Numbers_Matrix4_js__WEBPACK_IMPORTED_MODULE_12__/* ["default"] */ .A .IDENTITY);

      return function (renderObject, modelViewMatrixArray, projectionMatrixArray)
      {
         const
            browser         = this .getBrowser (),
            gl              = browser .getContext (),
            texturesContext = this .texturesContext;

         // Draw all textures.

         for (const i of this .textureBits)
         {
            const textureNode = this .textureNodes [i];

            texturesContext .alphaMode    = textureNode ._transparent .getValue () ? _Browser_Shape_AlphaMode_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .BLEND : _Browser_Shape_AlphaMode_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .OPAQUE;
            texturesContext .textureNode  = textureNode;
            texturesContext .renderObject = renderObject;

            const shaderNode = browser .getDefaultMaterial () .getShader (texturesContext);

            shaderNode .enable (gl);
            shaderNode .setClipPlanes (gl, this .clipPlanes, renderObject);

            // Set uniforms.

            gl .uniformMatrix4fv (shaderNode .x3d_ProjectionMatrix,  false, projectionMatrixArray);
            gl .uniformMatrix4fv (shaderNode .x3d_EyeMatrix,         false, renderObject .getEyeMatrixArray ());
            gl .uniformMatrix4fv (shaderNode .x3d_ModelViewMatrix,   false, modelViewMatrixArray);
            gl .uniformMatrix4fv (shaderNode .x3d_TextureMatrix [0], false, textureMatrixArray);

            gl .uniform3f (shaderNode .x3d_EmissiveColor,                      1, 1, 1);
            gl .uniform1f (shaderNode .x3d_Transparency,                       0);
            gl .uniform1i (shaderNode .x3d_TextureCoordinateGeneratorMode [0], 0);
            gl .uniform1f (shaderNode .x3d_Exposure,                           1);

            this .drawRectangle (gl, browser, shaderNode, textureNode, this .textureBuffers [i], this .textureArrayObjects [i]);

            gl .uniform1f (shaderNode .x3d_Exposure, Math .max (browser .getBrowserOption ("Exposure"), 0));
         }
      };
   })(),
   drawRectangle (gl, browser, shaderNode, textureNode, buffer, vertexArray)
   {
      textureNode .setShaderUniforms (gl, shaderNode .x3d_Texture [0]);

      if (vertexArray .enable (shaderNode .getProgram ()))
      {
         shaderNode .enableTexCoordAttribute (gl, this .texCoordBuffers, 0, 0);
         shaderNode .enableVertexAttribute (gl, buffer, 0, 0);
      }

      // Draw.

      if (textureNode ._transparent .getValue ())
         gl .enable (gl .BLEND);
      else
         gl .disable (gl .BLEND);

      gl .drawArrays (gl .TRIANGLES, 0, 6);

      browser .resetTextureUnits ();
   },
});

Object .defineProperties (X3DBackgroundNode, _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .getStaticProperties ("X3DBackgroundNode", "EnvironmentalEffects", 1));

for (let index = 0; index < 6; ++ index)
{
   X3DBackgroundNode .prototype [`set_loadState${index}__`] = function (index, textureNode)
   {
      this .set_loadState__ (index, textureNode);
   };
}

const __default__ = X3DBackgroundNode;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_15__/* ["default"] */ .A .add ("X3DBackgroundNode", __default__));

/***/ }),

/***/ 362:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Fields_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(4598);
/* harmony import */ var _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(2040);
/* harmony import */ var _Base_FieldDefinitionArray_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(1870);
/* harmony import */ var _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(2340);
/* harmony import */ var _X3DGroupingNode_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(223);
/* harmony import */ var _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(2212);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(717);







function Group (executionContext)
{
   _X3DGroupingNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .call (this, executionContext);

   this .addType (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .Group);
}

Object .setPrototypeOf (Group .prototype, _X3DGroupingNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .prototype);

Object .defineProperties (Group,
{
   ... _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .getStaticProperties ("Group", "Grouping", 1, "children", "2.0"),
   fieldDefinitions:
   {
      value: new _Base_FieldDefinitionArray_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A ([
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .inputOutput,    "metadata",       new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFNode ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .inputOutput,    "visible",        new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFBool (true)),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .inputOutput,    "bboxDisplay",    new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFBool ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .initializeOnly, "bboxSize",       new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFVec3f (-1, -1, -1)),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .initializeOnly, "bboxCenter",     new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFVec3f ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .inputOnly,      "addChildren",    new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFNode ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .inputOnly,      "removeChildren", new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFNode ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .inputOutput,    "children",       new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFNode ()),
      ]),
      enumerable: true,
   },
});

const __default__ = Group;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .add ("Group", __default__));

/***/ }),

/***/ 615:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(717);
// Modified during dist build.

const __default__ = false;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .add ("DEVELOPMENT", __default__));

/***/ }),

/***/ 639:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Fields_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(4598);
/* harmony import */ var _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(2340);
/* harmony import */ var _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(2212);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(717);




const
   _cache                   = Symbol (),
   _autoRefreshStartTime    = Symbol (),
   _autoRefreshCompleteTime = Symbol (),
   _autoRefreshId           = Symbol ();

function X3DUrlObject (executionContext)
{
   this .addType (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .X3DUrlObject);

   this .addChildObjects (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .outputOnly, "loadState", new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFInt32 (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .NOT_STARTED_STATE),
                          _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .outputOnly, "loadData",  new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFTime ());

   this [_cache]                = true;
   this [_autoRefreshStartTime] = Date .now ();
}

Object .assign (X3DUrlObject .prototype,
{
   initialize ()
   {
      this .getLive () .addInterest ("set_live__", this);

      this ._load                 .addInterest ("set_load__",        this);
      this ._url                  .addInterest ("set_url__",         this);
      this ._loadData             .addInterest ("loadData",          this);
      this ._autoRefresh          .addInterest ("set_autoRefresh__", this);
      this ._autoRefreshTimeLimit .addInterest ("set_autoRefresh__", this);
   },
   getAllowEmptyUrl ()
   {
      return false;
   },
   setLoadState (value, notify = true)
   {
      this ._loadState = value;

      switch (value)
      {
         case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .COMPLETE_STATE:
         case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .FAILED_STATE:
         {
            this [_autoRefreshCompleteTime] = Date .now ();
            this .setAutoRefreshTimer (Math .max (this ._autoRefresh .getValue (), 0));
            break;
         }
      }

      if (!notify)
         return;

      switch (value)
      {
         case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .NOT_STARTED_STATE:
            break;
         case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .IN_PROGRESS_STATE:
         {
            this .getScene () .addLoadingObject (this);
            break;
         }
         case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .COMPLETE_STATE:
         case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .FAILED_STATE:
         {
            this .getScene () .removeLoadingObject (this);
            break;
         }
      }
   },
   checkLoadState ()
   {
      return this ._loadState .getValue ();
   },
   getLoadState ()
   {
      return this ._loadState;
   },
   setCache (value)
   {
      this [_cache] = value;
   },
   getCache ()
   {
      return this [_cache] && this .getBrowser () .getBrowserOption ("Cache");
   },
   async requestImmediateLoad (cache = true)
   {
      switch (this .checkLoadState ())
      {
         case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .IN_PROGRESS_STATE:
         {
            await this .loading ();
            return;
         }
         case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .COMPLETE_STATE:
         {
            return;
         }
         case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .FAILED_STATE:
         {
            throw new Error (`Failed loading ${this .getTypeName ()}.`);
         }
      }

      const browser = this .getBrowser ();

      if (!browser .getBrowserOption ("LoadUrlObjects") && this .getExecutionContext () !== browser .getPrivateScene ())
         return;

      if (!this ._load .getValue ())
         throw new Error (`${this .getTypeName ()}.load is false.`);

      if (this ._url .length === 0 && !this .getAllowEmptyUrl ())
      {
         this .unloadData ();
         return;
      }

      this .setCache (cache);
      this .setLoadState (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .IN_PROGRESS_STATE);

      if (this .isInitialized ())
         // Buffer prevents double load of the scene if load and url field are set at the same time.
         this ._loadData = this .getBrowser () .getCurrentTime ();
      else
         this .loadData ();

      await this .loading ();
   },
   loading ()
   {
      return new Promise ((resolve, reject) =>
      {
         const _loading = Symbol ();

         this ._loadState .addFieldCallback (_loading, () =>
         {
            switch (this .checkLoadState ())
            {
               case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .COMPLETE_STATE:
               {
                  this ._loadState .removeFieldCallback (_loading);
                  resolve ();
                  break;
               }
               case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .FAILED_STATE:
               {
                  this ._loadState .removeFieldCallback (_loading);
                  reject (new Error (`Failed loading ${this .getTypeName ()}.`));
                  break;
               }
            }
         });
      });
   },
   loadNow ()
   {
      this .setLoadState (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .NOT_STARTED_STATE);

      return this .requestImmediateLoad ();
   },
   loadData ()
   { },
   requestUnload ()
   {
      const loadState = this .checkLoadState ();

      if (loadState === _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .NOT_STARTED_STATE || loadState === _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .FAILED_STATE)
         return;

      this .setLoadState (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .NOT_STARTED_STATE);
      this .unloadData ();
   },
   unloadNow ()
   {
      this .requestUnload ();
   },
   unloadData ()
   { },
   setAutoRefreshTimer (autoRefreshInterval)
   {
      clearTimeout (this [_autoRefreshId]);

      if (this ._autoRefresh .getValue () <= 0)
         return;

      const autoRefreshTimeLimit = this ._autoRefreshTimeLimit .getValue ();

      if (autoRefreshTimeLimit > 0)
      {
         if ((Date .now () - this [_autoRefreshStartTime]) / 1000 > autoRefreshTimeLimit - autoRefreshInterval)
            return;
      }

      this [_autoRefreshId] = setTimeout (this .performAutoRefresh .bind (this), autoRefreshInterval * 1000);
   },
   performAutoRefresh ()
   {
      this .setLoadState (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .NOT_STARTED_STATE);
      this .requestImmediateLoad (false) .catch (Function .prototype);
   },
   set_live__ ()
   {
      if (this .getLive () .getValue ())
         this .set_autoRefresh__ ();
      else
         clearTimeout (this [_autoRefreshId]);
   },
   set_load__ ()
   {
      if (this ._load .getValue ())
         this .requestImmediateLoad () .catch (Function .prototype);
      else
         this .requestUnload ();
   },
   set_url__ ()
   {
      if (!this ._load .getValue ())
         return;

      this .setLoadState (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .NOT_STARTED_STATE);
      this .requestImmediateLoad () .catch (Function .prototype);
   },
   set_autoRefresh__ ()
   {
      if (this .checkLoadState () !== _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .COMPLETE_STATE)
         return;

      const
         elapsedTime = (Date .now () - this [_autoRefreshCompleteTime]) / 1000,
         autoRefresh = Math .max (this ._autoRefresh .getValue (), 0);

      let autoRefreshInterval = autoRefresh - elapsedTime;

      if (autoRefreshInterval < 0)
         autoRefreshInterval = Math .ceil (elapsedTime / autoRefresh) * autoRefresh - elapsedTime;

      this .setAutoRefreshTimer (autoRefreshInterval);
   },
   dispose () { },
});

Object .defineProperties (X3DUrlObject, _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .getStaticProperties ("X3DUrlObject", "Networking", 1));

const __default__ = X3DUrlObject;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .add ("X3DUrlObject", __default__));

/***/ }),

/***/ 681:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Components_Rendering_X3DGeometryNode_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(5339);
/* harmony import */ var _Shape_AlphaMode_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(3500);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(717);



function GeometryContext (options = { })
{
   Object .assign (this,
   {
      alphaMode: _Shape_AlphaMode_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .OPAQUE,
      geometryType: 3,
      hasFogCoords: false,
      colorMaterial: false,
      hasNormals: false,
      hasTangents: false,
      textureNode: null,
      localObjectsKeys: [ ],
      textureCoordinateMapping: new Map (),
      textureCoordinateNode: null,
   },
   options)

   this .updateGeometryKey ();
}

Object .assign (GeometryContext .prototype,
{
   getTextureCoordinateMapping ()
   {
      return this .textureCoordinateMapping;
   },
   getTextureCoordinate ()
   {
      return this .textureCoordinateNode;
   },
   updateGeometryKey: _Components_Rendering_X3DGeometryNode_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .prototype .updateGeometryKey,
});

const __default__ = GeometryContext;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .add ("GeometryContext", __default__));

/***/ }),

/***/ 712:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Base_X3DInfoArray_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(3020);
/* harmony import */ var _UnitInfo_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(2605);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(717);



function UnitInfoArray (values = [ ])
{
   return _Base_X3DInfoArray_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .call (this, Array .from (values, value => [value .category, value]), _UnitInfo_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A);
}

Object .setPrototypeOf (UnitInfoArray .prototype, _Base_X3DInfoArray_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .prototype);

for (const key of Object .keys (UnitInfoArray .prototype))
   Object .defineProperty (UnitInfoArray .prototype, key, { enumerable: false });

Object .defineProperties (UnitInfoArray,
{
   typeName:
   {
      value: "UnitInfoArray",
      enumerable: true,
   },
});

const __default__ = UnitInfoArray;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .add ("UnitInfoArray", __default__));

/***/ }),

/***/ 717:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
const Namespace = { };

Object .defineProperty (Namespace, "add",
{
   value (name, module)
   {
      if (Namespace .hasOwnProperty (name))
      {
         console .error (new Error (`Namespace: "${name}" already exists.`));
         return module;
      }

      const X3D = window [Symbol .for ("X_ITE.X3D-12.1.2")];

      if (X3D)
         X3D [name] = module;

      // For x_ite.js:
      return Namespace [name] = module;
   },
});

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Namespace .add ("Namespace", Namespace));


/***/ }),

/***/ 780:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _x_ite_Namespace_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(717);
const Algorithm =
{
   radians (value)
   {
      // Convert degrees to radians.
      return value * (Math .PI / 180);
   },
   degrees (value)
   {
      // Convert radians to degrees.
      return value * (180 / Math .PI);
   },
   random (min, max)
   {
      return min + Math .random () * (max - min);
   },
   fract (value)
   {
      return value % 1;
   },
   clamp (value, min, max)
   {
      // https://registry.khronos.org/OpenGL-Refpages/gl4/html/clamp.xhtml
      return Math .min (Math .max (value, min), max);
   },
   interval (value, low, high)
   {
      if (value >= high)
         return ((value - low) % (high - low)) + low;

      if (value < low)
         return ((value - high) % (high - low)) + high;

      return value;
   },
   project (value, fromLow, fromHigh, toLow, toHigh)
   {
      return toLow + ((value - fromLow) / (fromHigh - fromLow)) * (toHigh - toLow);
   },
   roundToMultiple (value, multiple)
   {
      return Math .ceil (value / multiple) * multiple;
   },
   lerp (source, destination, t)
   {
      return source + t * (destination - source);
   },
   slerp (source, destination, t)
   {
      let cosom = source .dot (destination);

      // if (cosom <= -1) ... vectors are inverse colinear.
      // ; // This case is not handled.

      if (cosom >= 1) // Both normal vectors are equal.
         return source;

      if (cosom < 0)
      {
         // Reverse signs so we travel the short way round.
         cosom = -cosom;
         destination .negate ();
      }

      const
         omega  = Math .acos (cosom),
         sinom  = Math .sin  (omega),
         scale0 = Math .sin ((1 - t) * omega) / sinom,
         scale1 = Math .sin (t * omega) / sinom;

      source .x = source .x * scale0 + destination .x * scale1;
      source .y = source .y * scale0 + destination .y * scale1;
      source .z = source .z * scale0 + destination .z * scale1;
      source .w = source .w * scale0 + destination .w * scale1;

      return source;
   },
   simpleSlerp (source, destination, t)
   {
      const cosom = source .dot (destination);

      // if (cosom <= -1) ... vectors are inverse colinear.

      if (cosom >= 1) // Both normal vectors are equal.
         return source;

      const
         omega  = Math .acos (cosom),
         sinom  = Math .sin  (omega),
         scale0 = Math .sin ((1 - t) * omega) / sinom,
         scale1 = Math .sin (t * omega) / sinom;

      source .x = source .x * scale0 + destination .x * scale1;
      source .y = source .y * scale0 + destination .y * scale1;
      source .z = source .z * scale0 + destination .z * scale1;
      source .w = source .w * scale0 + destination .w * scale1;

      return source;
   },
   isPowerOfTwo (n)
   {
      return ((n - 1) & n) === 0;
   },
   nextPowerOfTwo (n)
   {
      ///  Returns the next power of two of @a n. If n is a power of two, n is returned.

      if (Algorithm .isPowerOfTwo (n))
         return n;

      return 1 << (32 - Math .clz32 (n));
   },
   bitCount (n)
   {
      n = n - ((n >>> 1) & 0x55555555);
      n = (n & 0x33333333) + ((n >>> 2) & 0x33333333);
      return ((n + (n >>> 4) & 0xF0F0F0F) * 0x1010101) >>> 24;
   },
   cmp (lhs, rhs)
   {
      return lhs > rhs ? 1 : lhs < rhs ? -1 : 0;
   },
   less (lhs, rhs)
   {
      return lhs < rhs;
   },
   greater (lhs, rhs)
   {
      return lhs > rhs;
   },
   lowerBound (array, first, last, value, comp = Algorithm.less)
   {
      // https://en.cppreference.com/w/cpp/algorithm/lower_bound

      let
         index = 0,
         step  = 0,
         count = last - first;

      while (count > 0)
      {
         step  = count >>> 1;
         index = first + step;

         if (comp (array [index], value))
         {
            first  = ++ index;
            count -= step + 1;
         }
         else
         {
            count = step;
         }
      }

      return first;
   },
   upperBound (array, first, last, value, comp = Algorithm.less)
   {
      // https://en.cppreference.com/w/cpp/algorithm/upper_bound

      let
         index = 0,
         step  = 0,
         count = last - first;

      while (count > 0)
      {
         step  = count >>> 1;
         index = first + step;

         if (comp (value, array [index]))
         {
            count = step;
         }
         else
         {
            first  = ++ index;
            count -= step + 1;
         }
      }

      return first;
   },
};

const __default__ = Algorithm;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_x_ite_Namespace_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .add ("Algorithm", __default__));

/***/ }),

/***/ 810:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(2340);
/* harmony import */ var _X3DSingleTextureNode_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(7224);
/* harmony import */ var _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(2212);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(717);




const defaultData = new Uint8Array ([ 255, 255, 255, 255 ]);

function X3DTexture2DNode (executionContext)
{
   _X3DSingleTextureNode_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .call (this, executionContext);

   this .addType (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .X3DTexture2DNode);

   const gl = this .getBrowser () .getContext ();

   this .target = gl .TEXTURE_2D;
   this .width  = 0;
   this .height = 0;
}

Object .assign (Object .setPrototypeOf (X3DTexture2DNode .prototype, _X3DSingleTextureNode_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .prototype),
{
   initialize ()
   {
      _X3DSingleTextureNode_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .prototype .initialize .call (this);

      this ._repeatS .addInterest ("updateTextureParameters", this);
      this ._repeatT .addInterest ("updateTextureParameters", this);

      const gl = this .getBrowser () .getContext ();

      gl .bindTexture (gl .TEXTURE_2D, this .getTexture ());
      gl .texImage2D  (gl .TEXTURE_2D, 0, gl .RGBA, 1, 1, 0, gl .RGBA, gl .UNSIGNED_BYTE, defaultData);
   },
   getTarget ()
   {
      return this .target;
   },
   getWidth ()
   {
      return this .width;
   },
   setWidth (value)
   {
      this .width = value;
   },
   getHeight ()
   {
      return this .height;
   },
   setHeight (value)
   {
      this .height = value;
   },
   clearTexture ()
   {
      this .setTextureData (1, 1, false, false, defaultData);
   },
   getTextureData (texture = this .getTexture (), width = this .getWidth (), height = this .getHeight ())
   {
      const
         gl          = this .getBrowser () .getContext (),
         framebuffer = gl .createFramebuffer (),
         data        = new Uint8Array (width * height * 4);

      gl .bindFramebuffer (gl .FRAMEBUFFER, framebuffer);
      gl .framebufferTexture2D (gl .FRAMEBUFFER, gl .COLOR_ATTACHMENT0, gl .TEXTURE_2D, texture, 0);
      gl .readPixels (0, 0, width, height, gl .RGBA, gl .UNSIGNED_BYTE, data);
      gl .deleteFramebuffer (framebuffer);

      return data;
   },
   setTextureData (width, height, colorSpaceConversion, transparent, data)
   {
      this .width  = width;
      this .height = height;

      const
         gl  = this .getBrowser () .getContext (),
         max = gl .getParameter (gl .MAX_TEXTURE_SIZE);

      if (width > max || height > max)
      {
         throw new Error (`At least one dimension (${width} × ${height}) is greater than the maximum texture size (${max} px).`);
      }

      gl .bindTexture (gl .TEXTURE_2D, this .getTexture ());
      gl .pixelStorei (gl .UNPACK_COLORSPACE_CONVERSION_WEBGL, colorSpaceConversion ? gl .BROWSER_DEFAULT_WEBGL : gl .NONE);
      gl .texImage2D  (gl .TEXTURE_2D, 0, gl .RGBA, width, height, 0, gl .RGBA, gl .UNSIGNED_BYTE, data);
      gl .pixelStorei (gl .UNPACK_COLORSPACE_CONVERSION_WEBGL, gl .BROWSER_DEFAULT_WEBGL);

      this .setTransparent (transparent);
      this .updateTextureParameters ();
      this .addNodeEvent ();
   },
   updateTextureData (data)
   {
      const gl = this .getBrowser () .getContext ();

      gl .bindTexture (gl .TEXTURE_2D, this .getTexture ());
      gl .texSubImage2D (gl .TEXTURE_2D, 0, 0, 0, gl .RGBA, gl .UNSIGNED_BYTE, data);

      if (this .texturePropertiesNode ._generateMipMaps .getValue ())
         gl .generateMipmap (gl .TEXTURE_2D);

      this .addNodeEvent ();
   },
   updateTextureParameters ()
   {
      _X3DSingleTextureNode_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .prototype .updateTextureParameters .call (this,
                                                                      this .target,
                                                                      this ._textureProperties .getValue (),
                                                                      this .texturePropertiesNode,
                                                                      this .width,
                                                                      this .height,
                                                                      this ._repeatS .getValue (),
                                                                      this ._repeatT .getValue (),
                                                                      false);
   },
   setShaderUniforms (gl, channel)
   {
      const textureUnit = this .getBrowser () .getTextureUnit ();

      gl .activeTexture (gl .TEXTURE0 + textureUnit);
      gl .bindTexture (gl .TEXTURE_2D, this .getTexture ());
      gl .uniform1i (channel .texture2D, textureUnit);
   },
});

Object .defineProperties (X3DTexture2DNode, _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .getStaticProperties ("X3DTexture2DNode", "Texturing", 1));

const __default__ = X3DTexture2DNode;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .add ("X3DTexture2DNode", __default__));

/***/ }),

/***/ 828:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Math_Algorithm_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(780);
/* harmony import */ var _x_ite_Namespace_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(717);


const _value = Symbol ();

function BitSet (value = 0)
{
   this [_value] = value >>> 0;
}

Object .assign (BitSet .prototype,
{
   *[Symbol .iterator] ()
   {
      let
         value = this [_value],
         index = 0;

      while (value)
      {
         if (value & 1)
            yield index;

         value >>>= 1;
         ++ index;
      }
   },
   get (index)
   {
      const mask = 1 << index;

      return !! (this [_value] & mask);
   },
   set (index, value)
   {
      if (value)
         this .add (index);
      else
         this .remove (index);
   },
   add (index, mask = 1)
   {
      this [_value] |= mask << index;
      this [_value] >>>= 0;
   },
   remove (index, mask = 1)
   {
      this [_value] &= ~(mask << index);
      this [_value] >>>= 0;
   },
   clear ()
   {
      this [_value] = 0;
   },
   *entries ()
   {
      for (const i of this)
         yield [i, i];
   },
   valueOf ()
   {
      return this [_value];
   },
   toString (radix)
   {
      return this [_value] .toString (radix);
   },
});

BitSet .prototype .keys   = BitSet .prototype [Symbol .iterator];
BitSet .prototype .values = BitSet .prototype [Symbol .iterator];

Object .defineProperty (BitSet .prototype, "size",
{
   get ()
   {
      return _Math_Algorithm_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .bitCount (this [_value]);
   },
});

const __default__ = BitSet;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_x_ite_Namespace_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .add ("BitSet", __default__));

/***/ }),

/***/ 923:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Algorithm_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(780);
/* harmony import */ var _x_ite_Namespace_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(717);


function Vector2 (x = 0, y = x)
{
   this .x = x;
   this .y = y;
}

Object .assign (Vector2 .prototype,
{
   *[Symbol .iterator] ()
   {
      yield this .x;
      yield this .y;
   },
   copy ()
   {
      const copy = Object .create (Vector2 .prototype);
      copy .x = this .x;
      copy .y = this .y;
      return copy;
   },
   assign ({ x, y })
   {
      this .x = x;
      this .y = y;
      return this;
   },
   set (x = 0, y = x)
   {
      this .x = x;
      this .y = y;
      return this;
   },
   equals ({ x, y })
   {
      return this .x === x &&
             this .y === y;
   },
   negate ()
   {
      this .x = -this .x;
      this .y = -this .y;
      return this;
   },
   inverse ()
   {
      this .x = 1 / this .x;
      this .y = 1 / this .y;
      return this;
   },
   add ({ x, y })
   {
      this .x += x;
      this .y += y;
      return this;
   },
   subtract ({ x, y })
   {
      this .x -= x;
      this .y -= y;
      return this;
   },
   multiply (value)
   {
      this .x *= value;
      this .y *= value;
      return this;
   },
   multVec ({ x, y })
   {
      this .x *= x;
      this .y *= y;
      return this;
   },
   divide (value)
   {
      this .x /= value;
      this .y /= value;
      return this;
   },
   divVec ({ x, y })
   {
      this .x /= x;
      this .y /= y;
      return this;
   },
   normalize ()
   {
      const length = Math .hypot (this .x, this .y);

      if (length)
      {
         this .x /= length;
         this .y /= length;
      }

      return this;
   },
   dot ({ x, y })
   {
      return this .x * x +
             this .y * y;
   },
   squaredNorm ()
   {
      const { x, y } = this;

      return x * x +
             y * y;
   },
   norm ()
   {
      return Math .hypot (this .x, this .y);
   },
   distance ({ x, y })
   {
      return Math .hypot (this .x - x,
                          this .y - y);
   },
   lerp ({ x: dX, y: dY }, t)
   {
      const { x, y } = this;

      this .x = x + t * (dX - x);
      this .y = y + t * (dY - y);
      return this;
   },
   abs ()
   {
      const { x, y } = this;

      this .x = Math .abs (x);
      this .y = Math .abs (y);
      return this;
   },
   min (vector)
   {
      let { x, y } = this;

      for (const { x: minX, y: minY } of arguments)
      {
         x = Math .min (x, minX);
         y = Math .min (y, minY);
      }

      this .x = x;
      this .y = y;
      return this;
   },
   max (vector)
   {
      let { x, y } = this;

      for (const { x: maxX, y: maxY } of arguments)
      {
         x = Math .max (x, maxX);
         y = Math .max (y, maxY);
      }

      this .x = x;
      this .y = y;
      return this;
   },
   clamp ({ x: minX, y: minY }, { x: maxX, y: maxY })
   {
      this .x = _Algorithm_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .clamp (this .x, minX, maxX);
      this .y = _Algorithm_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .clamp (this .y, minY, maxY);
      return this;
   },
   toString ()
   {
      return this .x + " " +
             this .y;
   }
});

for (const key of Object .keys (Vector2 .prototype))
   Object .defineProperty (Vector2 .prototype, key, { enumerable: false });

Object .defineProperties (Vector2 .prototype,
{
   length: { value: 2 },
   0:
   {
      get () { return this .x; },
      set (value) { this .x = value; },
   },
   1:
   {
      get () { return this .y; },
      set (value) { this .y = value; },
   },
});

Object .assign (Vector2,
{
   ZERO: Object .freeze (new Vector2 ()),
   // Positive values
   ONE: Object .freeze (new Vector2 (1)),
   X_AXIS: Object .freeze (new Vector2 (1, 0)),
   Y_AXIS: Object .freeze (new Vector2 (0, 1)),
   // Negative values
   NEGATIVE_ONE: Object .freeze (new Vector2 (-1)),
   NEGATIVE_X_AXIS: Object .freeze (new Vector2 (-1, 0)),
   NEGATIVE_Y_AXIS: Object .freeze (new Vector2 (0, -1)),
});

const __default__ = Vector2;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_x_ite_Namespace_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .add ("Vector2", __default__));

/***/ }),

/***/ 946:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  A: () => (/* binding */ Base_X3DObject)
});

// EXTERNAL MODULE: ./src/x_ite/Base/X3DConstants.js
var X3DConstants = __webpack_require__(2212);
// EXTERNAL MODULE: ./src/standard/Math/Algorithm.js
var Algorithm = __webpack_require__(780);
// EXTERNAL MODULE: ./src/x_ite/Execution/NamedNodesHandling.js
var NamedNodesHandling = __webpack_require__(1168);
// EXTERNAL MODULE: ./src/x_ite/Namespace.js
var Namespace = __webpack_require__(717);
;// ./src/x_ite/InputOutput/X3DGenerator.js




function Generator ({ style = "TIDY", indent = "", indentChar = "  ", precision = 7, doublePrecision = 15, names = true } = { })
{
   this .string          = "";
   this .indent          = indent;
   this .listIndent      = indent;
   this .precision       = Algorithm/* default */.A .clamp (precision, 1, 21);
   this .doublePrecision = Algorithm/* default */.A .clamp (doublePrecision, 1, 21);
   this .outputNames     = names; // private option: used in StaticGroup for toVRMLString.

   this .floatFormat             = this .createFloatFormat (this .precision);
   this .floatExponentialFormat  = this .createFloatExponentialFormat (this .precision);
   this .doubleFormat            = this .createFloatFormat (this .doublePrecision);
   this .doubleExponentialFormat = this .createFloatExponentialFormat (this .doublePrecision);

   this .Style (style, indentChar);

   this .executionContextStack = [ ];
   this .executionContextIndex = new Set ();
   this .importedNodesIndex    = new Map ();
   this .importedNames         = new Map ();
   this .exportedNodesIndex    = new Map ();
   this .nodes                 = new Map ();
   this .names                 = new Map ();
   this .namesByNode           = new Map ();
   this .routeNodes            = new Map ();
}

Object .assign (Generator .prototype,
{
   Style (style, indentChar = "  ")
   {
      switch (style)
      {
         case "CLEAN":
         {
            this .listIndent = "";

            this .comma          = " ";
            this .break          = " ";
            this .tidyBreak      = "";
            this .tidySpace      = "";
            this .indentChar     = "";
            this .listEnclosure  = "";
            this .listBreak      = "";
            this .listIndentChar = "";
            this .attribBreak    = " ";
            break;
         }
         case "SMALL":
         {
            this .listIndent = "";

            this .comma          = ",";
            this .break          = "\n";
            this .tidyBreak      = "\n";
            this .tidySpace      = "";
            this .indentChar     = "";
            this .listEnclosure  = "";
            this .listBreak      = "";
            this .listIndentChar = "";
            this .attribBreak    = " ";
            break;
         }
         case "COMPACT":
         {
            this .listIndent = "";

            this .comma          = ",";
            this .break          = "\n";
            this .tidyBreak      = "\n";
            this .tidySpace      = " ";
            this .indentChar     = indentChar;
            this .listEnclosure  = " ";
            this .listBreak      = " ";
            this .listIndentChar = "";
            this .attribBreak    = " ";
            break;
         }
         case "TIDY":
         default:
         {
            this .comma          = ",";
            this .break          = "\n";
            this .tidyBreak      = "\n";
            this .tidySpace      = " ";
            this .indentChar     = indentChar;
            this .listEnclosure  = "\n";
            this .listBreak      = "\n";
            this .listIndentChar = this .indentChar;
            this .attribBreak    = "\n";
            break;
         }
      }
   },
   Comma ()
   {
      return this .comma;
   },
   Break ()
   {
      return this .break;
   },
   TidyBreak ()
   {
      return this .tidyBreak;
   },
   AddTidyBreak ()
   {
      this .string += this .tidyBreak;
   },
   ForceBreak ()
   {
      return "\n";
   },
   Space ()
   {
      return " ";
   },
   TidySpace ()
   {
      return this .tidySpace;
   },
   ListStart ()
   {
      return this .listEnclosure;
   },
   ListEnd ()
   {
      return this .listEnclosure;
   },
   ListBreak ()
   {
      return this .listBreak;
   },
   AttribBreak ()
   {
      return this .attribBreak;
   },
   Indent ()
   {
      return this .indent;
   },
   ListIndent ()
   {
      return this .listIndent;
   },
   IncIndent ()
   {
      this .indent     += this .indentChar;
      this .listIndent += this .listIndentChar;

      return "";
   },
   DecIndent ()
   {
      this .indent     = this .indent     .slice (0, this .indent     .length - this .indentChar     .length);
      this .listIndent = this .listIndent .slice (0, this .listIndent .length - this .listIndentChar .length);

      return "";
   },
   createFloatFormat (precision)
   {
      return new Intl .NumberFormat ("en",
      {
         notation: "standard",
         maximumSignificantDigits: precision,
         useGrouping: false,
      })
      .format;
   },
   createFloatExponentialFormat (precision)
   {
      return new Intl .NumberFormat ("en",
      {
         notation: "scientific",
         maximumSignificantDigits: precision,
         useGrouping: false,
      })
      .format;
   },
   FloatFormat  (value)
   {
      if (Number .isFinite (value))
      {
         const exponent = Math .log10 (Math .abs (value));

         if ((this .precision > exponent && exponent >= -4) || value === 0)
            return this .floatFormat (value);

         return this .floatExponentialFormat (value) .toLowerCase ();
      }
      else
      {
         return String (value);
      }
   },
   DoubleFormat  (value)
   {
      if (Number .isFinite (value))
      {
         const exponent = Math .log10 (Math .abs (value));

         if ((this .doublePrecision > exponent && exponent >= -4) || value === 0)
            return this .doubleFormat (value);

         return this .doubleExponentialFormat (value) .toLowerCase ();
      }
      else
      {
         return String (value);
      }
   },
   PushExecutionContext (executionContext)
   {
      this .executionContextStack .push (executionContext);

      if (this .executionContextIndex .has (executionContext))
         return;

      this .executionContextIndex .add (executionContext);
      this .importedNodesIndex    .set (executionContext, new Set ());
      this .importedNames         .set (executionContext, new Map ());
      this .exportedNodesIndex    .set (executionContext, new Set ());
      this .nodes                 .set (executionContext, new Set ());
      this .names                 .set (executionContext, new Set ());
      this .namesByNode           .set (executionContext, new Map ());
      this .routeNodes            .set (executionContext, new Set ());
   },
   PopExecutionContext ()
   {
      const executionContext = this .executionContextStack .pop ();

      if (this .executionContextStack .at (-1) === executionContext)
         return;

      this .executionContextIndex .delete (executionContext);
      this .importedNodesIndex    .delete (executionContext);
      this .importedNames         .delete (executionContext);
      this .exportedNodesIndex    .delete (executionContext);
      this .nodes                 .delete (executionContext);
      this .names                 .delete (executionContext);
      this .namesByNode           .delete (executionContext);
      this .routeNodes            .delete (executionContext);
   },
   ExecutionContext ()
   {
      return this .executionContextStack .at (-1);
   },
   EnterScope ()
   {
      // TODO: remove me.
   },
   LeaveScope ()
   {
      // TODO: remove me.
   },
   NamedNodes (namedNodes)
   {
      const
         names       = this .names .get (this .ExecutionContext ()),
         namesByNode = this .namesByNode .get (this .ExecutionContext ());

      for (const node of namedNodes)
      {
         if (node .getNodeName () .match (/^_\d+$/))
            continue;

         names .add (node .getNodeName ());
         namesByNode .set (node .getValue (), node .getNodeName ());
      }
   },
   ExportedNodes (exportedNodes)
   {
      const index = this .exportedNodesIndex .get (this .ExecutionContext ());

      for (const exportedNode of exportedNodes)
         index .add (exportedNode .getLocalNode ());
   },
   ImportedNodes (importedNodes)
   {
      const index = this .importedNodesIndex .get (this .ExecutionContext ());

      for (const importedNode of importedNodes)
      {
         try
         {
            index .add (importedNode .getInlineNode ());
         }
         catch
         { }
      }
   },
   AddRouteNode (routeNode)
   {
      const routeNodes = this .routeNodes .get (this .ExecutionContext ());

      routeNodes .add (routeNode);
   },
   ExistsRouteNode (routeNode)
   {
      const routeNodes = this .routeNodes .get (this .ExecutionContext ());

      return routeNodes .has (routeNode);
   },
   IsSharedNode (baseNode)
   {
      return this .ExecutionContext () !== baseNode .getExecutionContext ();
   },
   AddNode (baseNode)
   {
      const nodes = this .nodes .get (this .ExecutionContext ());

      nodes .add (baseNode);

      this .AddRouteNode (baseNode);
   },
   ExistsNode (baseNode)
   {
      const nodes = this .nodes .get (this .ExecutionContext ());

      return nodes .has (baseNode);
   },
   Name (baseNode)
   {
      // Is the node already in index.

      const
         namesByNode = this .namesByNode .get (this .ExecutionContext ()),
         name        = namesByNode .get (baseNode);

      if (name !== undefined)
      {
         return name;
      }
      else
      {
         const
            names = this .names .get (this .ExecutionContext ()),
            name  = baseNode .getName ();

         // The node has no name.

         if (name .match (/^(?:_\d+)?$/) && !this .NeedsName (baseNode))
            return "";

         const newName = (0,NamedNodesHandling/* getUniqueName */.l) (names, name);

         // Add to indices.

         names .add (newName);
         namesByNode .set (baseNode, newName);

         return newName;
      }
   },
   NeedsName (baseNode)
   {
      if (baseNode .getCloneCount () > 1)
         return true;

      if (baseNode .hasRoutes ())
         return true;

      const executionContext = this .ExecutionContext ();

      if (this .importedNodesIndex .get (executionContext) .has (baseNode))
         return true;

      if (this .exportedNodesIndex .get (executionContext) .has (baseNode))
         return true;

      return false;
   },
   ImportedName (importedNode)
   {
      const importedNames = this .importedNames .get (this .ExecutionContext ());

      if (importedNames .has (importedNode))
         return importedNames .get (importedNode);

      const
         names   = this .names .get (this .ExecutionContext ()),
         newName = (0,NamedNodesHandling/* getUniqueName */.l) (names, importedNode .getImportedName ());

      // Add to indices.

      names .add (newName);
      importedNames .set (importedNode, newName);

      return newName;
   },
   AccessType (accessType)
   {
      switch (accessType)
      {
         case X3DConstants/* default */.A .initializeOnly:
            return "initializeOnly";
         case X3DConstants/* default */.A .inputOnly:
            return "inputOnly";
         case X3DConstants/* default */.A .outputOnly:
            return "outputOnly";
         case X3DConstants/* default */.A .inputOutput:
            return "inputOutput";
      }
   },
   ToUnit (category, value)
   {
      return this .ExecutionContext () ?.toUnit (category, value) ?? value;
   },
});

for (const key of Object .keys (Generator .prototype))
   Object .defineProperty (Generator .prototype, key, { enumerable: false });

const __default__ = Generator;
;

/* harmony default export */ const X3DGenerator = (Namespace/* default */.A .add ("X3DGenerator", __default__));
;// ./src/x_ite/InputOutput/VRMLGenerator.js


function VRMLGenerator (options)
{
   X3DGenerator .call (this, options);
}

Object .setPrototypeOf (VRMLGenerator .prototype, X3DGenerator .prototype);

for (const key of Object .keys (VRMLGenerator .prototype))
   Object .defineProperty (VRMLGenerator .prototype, key, { enumerable: false });

const VRMLGenerator_default_ = VRMLGenerator;
;

/* harmony default export */ const InputOutput_VRMLGenerator = (Namespace/* default */.A .add ("VRMLGenerator", VRMLGenerator_default_));
;// ./src/x_ite/InputOutput/XMLGenerator.js


function XMLGenerator (options = { })
{
   X3DGenerator .call (this, options);

   const { html = false, closingTags = false } = options;

   this .html            = html;
   this .closingTags     = html || closingTags;
   this .containerFields = [ ];
}

Object .assign (Object .setPrototypeOf (XMLGenerator .prototype, X3DGenerator .prototype),
{
   PushContainerField (field)
   {
      this .containerFields .push (field);
   },
   PopContainerField ()
   {
      this .containerFields .pop ();
   },
   ContainerField ()
   {
      return this .containerFields .at (-1);
   },
   EncodeString: (() =>
   {
      const map = {
         "\\": "\\\\",
         "\r": "&#xD;",
         "\n": "&#xA;",
         "\t": "&#x9;",
         "\"": "\\\"",
         "'": "&apos;",
         "<": "&lt;",
         ">": "&gt;",
         "&": "&amp;",
      };

      const regex = /([\\\r\n\t"'<>&])/g;

      return function (string)
      {
         return String (string) .replace (regex, char => map [char]);
      };
   })(),
   EncodeSourceText: (() =>
   {
      const map = {
         "\\": "\\\\",
         "\"": "\\\"",
         "'": "&apos;",
         "<": "&lt;",
         ">": "&gt;",
         "&": "&amp;",
      };

      const regex = /([\\"'<>&])/g;

      return function (string)
      {
         return string .replace (regex, char => map [char]);
      };
   })(),
   openingTag (name)
   {
      this .string += this .Indent ();
      this .string += "<";
      this .string += name;
      this .string += ">";
   },
   closingTag (name)
   {
      this .string += this .Indent ();
      this .string += "</";
      this .string += name;
      this .string += ">";
   },
   openTag (name)
   {
      this .string += this .Indent ();
      this .string += "<";
      this .string += name;
   },
   endTag ()
   {
      this .string += ">";
      this .string += this .TidyBreak ();
   },
   closeTag (name)
   {
      if (this .closingTags)
      {
         this .string += "></";
         this .string += name;
         this .string += ">";
      }
      else
      {
         this .string += "/>";
      }
   },
   attribute (name, value)
   {
      this .string += this .Space ();
      this .string += name;
      this .string += "='";
      this .string += this .EncodeString (value);
      this .string += "'";
   },
});

for (const key of Object .keys (XMLGenerator .prototype))
   Object .defineProperty (XMLGenerator .prototype, key, { enumerable: false });

const XMLGenerator_default_ = XMLGenerator;
;

/* harmony default export */ const InputOutput_XMLGenerator = (Namespace/* default */.A .add ("XMLGenerator", XMLGenerator_default_));
;// ./src/x_ite/InputOutput/JSONGenerator.js


function JSONGenerator (options)
{
   X3DGenerator .call (this, options);
}

Object .assign (Object .setPrototypeOf (JSONGenerator .prototype, X3DGenerator .prototype),
{
   EncodeString: (() =>
   {
      const map = {
         "\\": "\\\\",
         "\r": "\\r",
         "\n": "\\n",
         "\t": "\\t",
         "\"": "\\\"",
      };

      const regex = /([\\\t\n\r"])/g;

      return function (string)
      {
         return String (string) .replace (regex, char => map [char]);
      };
   })(),
   Number (value)
   {
      switch (value)
      {
         case "NaN":
         case "Infinity":
         case "-Infinity":
            return '"' + value + '"';
         default:
            return value;
      }
   },
   RemoveComma ()
   {
      this .string = this .string .replace (/,\s*$/s, "");
   },
   stringProperty (key, value, comma = true)
   {
      if (comma)
         this .string += ',';

      this .string += this .TidyBreak ();
      this .string += this .Indent ();
      this .string += '"';
      this .string += key;
      this .string += '"';
      this .string += ':';
      this .string += this .TidySpace ();
      this .string += '"';
      this .string += this .EncodeString (value);
      this .string += '"';
   },
   numberProperty (key, value, comma = true)
   {
      if (comma)
         this .string += ',';

      this .string += this .TidyBreak ();
      this .string += this .Indent ();
      this .string += '"';
      this .string += key;
      this .string += '"';
      this .string += ':';
      this .string += this .TidySpace ();
      this .string += value;
   },
   beginObject (name, comma = true, main = false)
   {
      if (comma)
         this .string += ',';

      if (name)
      {
         if (main)
         {
            this .string += '{';
            this .string += this .TidySpace ();
            this .string += '"';
            this .string += name;
            this .string += '"';
            this .string += ':';
            this .string += this .TidyBreak ();
            this .string += this .IncIndent ();
            this .string += this .Indent ();
            this .string += '{';
            this .string += this .IncIndent ();
         }
         else
         {
            this .string += this .TidyBreak ();
            this .string += this .Indent ();
            this .string += '"';
            this .string += name;
            this .string += '"';
            this .string += ':';
            this .string += this .TidySpace ();
            this .string += '{';
            this .string += this .IncIndent ();
         }
      }
      else
      {
         this .string += this .TidyBreak ();
         this .string += this .Indent ();
         this .string += '{';
         this .string += this .IncIndent ();
      }
   },
   endObject ()
   {
      this .string += this .TidyBreak ();
      this .string += this .DecIndent ();
      this .string += this .Indent ();
      this .string += '}';
   },
   beginArray (name, comma = true)
   {
      this .beginValue (name, comma);

      this .string += '[';
      this .string += this .IncIndent ();
   },
   endArray ()
   {
      this .string += this .TidyBreak ();
      this .string += this .DecIndent ();
      this .string += this .Indent ();
      this .string += ']';
   },
   beginValue (name, comma = true)
   {
      if (comma)
         this .string += ',';

      this .string += this .TidyBreak ();
      this .string += this .Indent ();
      this .string += '"';
      this .string += name;
      this .string += '"';
      this .string += ':';
      this .string += this .TidySpace ();
   },
});

for (const key of Object .keys (JSONGenerator .prototype))
   Object .defineProperty (JSONGenerator .prototype, key, { enumerable: false });

const JSONGenerator_default_ = JSONGenerator;
;

/* harmony default export */ const InputOutput_JSONGenerator = (Namespace/* default */.A .add ("JSONGenerator", JSONGenerator_default_));
// EXTERNAL MODULE: ./src/x_ite/Features.js
var Features = __webpack_require__(7859);
;// ./src/x_ite/Base/X3DObject.js
/* provided dependency */ var $ = __webpack_require__(9547);





const
   _name          = Symbol (),
   _interests     = Symbol (),
   _registry      = Symbol (),
   _userData      = Symbol (),
   _vrmlGenerator = Symbol (),
   _xmlGenerator  = Symbol (),
   _jsonGenerator = Symbol ();

function X3DObject () { }

Object .assign (X3DObject .prototype,
{
   [_name]: "",
   [_interests]: null,
   [_registry]: null,
   [_userData]: null,
   getId ()
   {
      return X3DObject .getId (this);
   },
   getTypeName ()
   {
      return this .constructor .typeName;
   },
   setName (value)
   {
      this [_name] = value;
   },
   getName ()
   {
      return this [_name];
   },
   getDisplayName ()
   {
      return this [_name];
   },
   hasInterest (callbackName, object)
   {
      return this [_interests] ?.has (X3DObject .getInterestId (object [callbackName], object)) ?? false;
   },
   addInterest (callbackName, object, ... args)
   {
      const
         weakRef    = new WeakRef (object),
         callback   = object [callbackName],
         interestId = X3DObject .getInterestId (callback, object);

      this [_registry] ??= new FinalizationRegistry (objectId =>
      {
         for (const interestId of this [_interests] .keys ())
         {
            if (interestId .endsWith (objectId))
               this [_interests] .delete (interestId);
         }
      });

      this [_interests] = new Map (this [_interests]);

      this [_registry] .register (object, interestId .replace (/^[^:]+/, ""), object);
      this [_interests] .set (interestId, { callback, weakRef, args });
   },
   removeInterest (callbackName, object)
   {
      this [_interests] ?.delete (X3DObject .getInterestId (object [callbackName], object));
   },
   getInterests ()
   {
      return this [_interests] ??= new Map ();
   },
   processInterests: (() =>
   {
      const EMPTY = [ ];

      return function ()
      {
         for (const { callback, weakRef, args } of this [_interests] ?.values () ?? EMPTY)
         {
            const object = weakRef .deref ();

            if (object)
               callback .call (object, ... args, this);
         }
      };
   })(),
   getUserData (key)
   {
      return this [_userData] ?.get (key);
   },
   setUserData (key, value)
   {
      this [_userData] ??= new Map ();

      this [_userData] .set (key, value);
   },
   removeUserData (key)
   {
      this [_userData] ?.delete (key);
   },
   toString (options)
   {
      const generator = !options || $.isEmptyObject (options)
         ? X3DObject [_vrmlGenerator] ??= new InputOutput_VRMLGenerator ()
         : new InputOutput_VRMLGenerator (options);

      generator .string = "";

      generator .PushExecutionContext (options ?.scene ?? null);

      this .toStream (generator);

      generator .PopExecutionContext ();

      return generator .string;
   },
   toVRMLString (options)
   {
      const generator = !options || $.isEmptyObject (options)
         ? X3DObject [_vrmlGenerator] ??= new InputOutput_VRMLGenerator ()
         : new InputOutput_VRMLGenerator (options);

      generator .string = "";

      generator .PushExecutionContext (options ?.scene ?? null);

      this .toVRMLStream (generator);

      generator .PopExecutionContext ();

      return generator .string;
   },
   toXMLString (options)
   {
      const generator = !options || $.isEmptyObject (options)
         ? X3DObject [_xmlGenerator] ??= new InputOutput_XMLGenerator ()
         : new InputOutput_XMLGenerator (options);

      generator .string = "";

      generator .PushExecutionContext (options ?.scene ?? null);

      this .toXMLStream (generator);

      generator .PopExecutionContext ();

      return generator .string;
   },
   toJSONString (options)
   {
      const generator = !options || $.isEmptyObject (options)
         ? X3DObject [_jsonGenerator] ??= new InputOutput_JSONGenerator ()
         : new InputOutput_JSONGenerator (options);

      generator .string = "";

      generator .PushExecutionContext (options ?.scene ?? null);

      this .toJSONStream (generator);

      generator .PopExecutionContext ();

      return generator .string;
   },
   toStream (generator)
   {
      generator .string = Object .prototype .toString .call (this);
   },
   dispose ()
   {
      this [_interests] ?.clear ();
      this [_userData]  ?.clear ();
   },
});

for (const key of Object .keys (X3DObject .prototype))
   Object .defineProperty (X3DObject .prototype, key, { enumerable: false });

Object .defineProperties (X3DObject .prototype,
{
   [Symbol .toStringTag]:
   {
      get () { return this .getTypeName (); },
   },
});

Object .assign (X3DObject,
{
   [_vrmlGenerator]: null,
   [_xmlGenerator]: null,
   [_jsonGenerator]: null,
   getId: Features/* default */.A .FINALIZATION_REGISTRY ? (() =>
   {
      const
         map      = new WeakMap (),
         cache    = [ ],
         registry = new FinalizationRegistry (id => cache .push (id));

      let counter = 0;

      return function (object)
      {
         const id = map .get (object);

         if (id !== undefined)
         {
            return id;
         }
         else
         {
            const id = cache .pop () ?? ++ counter;

            map .set (object, id);
            registry .register (object, id);

            return id;
         }
      };
   })() : (() =>
   {
      const map = new WeakMap ();

      let counter = 0;

      return function (object)
      {
         const id = map .get (object);

         if (id !== undefined)
            return id;

         map .set (object, ++ counter);

         return counter;
      };
   })(),
   getInterestId (callback, object)
   {
      return `${this .getId (callback)}:${this .getId (object)}`;
   },
});

const X3DObject_default_ = X3DObject;
;

/* harmony default export */ const Base_X3DObject = (Namespace/* default */.A .add ("X3DObject", X3DObject_default_));

/***/ }),

/***/ 1061:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Base_X3DField_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(2269);
/* harmony import */ var _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(2212);
/* harmony import */ var _SFNodeCache_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(6015);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(717);




const
   _target = Symbol (),
   _proxy  = Symbol ();

const handler =
{
   get (target, key)
   {
      try
      {
         const value = target [key];

         if (value !== undefined)
            return value;

         const
            node  = target .getValue (),
            field = node .getField (key);

         // Specification conform would be: accessType & X3DConstants .outputOnly.
         // But we allow read access to plain fields, too.
         if (field .getAccessType () === _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .inputOnly)
            return undefined;

         return field .valueOf ();
      }
      catch
      {
         return undefined;
      }
   },
   set (target, key, value)
   {
      if (key in target)
      {
         target [key] = value;
         return true;
      }

      try
      {
         const
            node       = target .getValue (),
            field      = node .getField (key),
            accessType = field .getAccessType ();

         if (accessType !== _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .outputOnly)
            field .setValue (value);

         return true;
      }
      catch (error)
      {
         console .error (target, key, error);
         return false;
      }
   },
   has (target, key)
   {
      try
      {
         return !! target .getValue () .getField (key);
      }
      catch
      {
         return key in target;
      }
   },
   ownKeys (target)
   {
      const
         value   = target .getValue (),
         ownKeys = [ ];

      if (value)
      {
         for (const { name } of value .getFieldDefinitions ())
            ownKeys .push (name);
      }

      return ownKeys;
   },
   getOwnPropertyDescriptor (target, key)
   {
      const value = target .getValue ();

      if (value)
      {
         const fieldDefinition = value .getFieldDefinitions () .get (key);

         if (fieldDefinition)
         {
            return {
               value: this .get (target, key),
               writable: fieldDefinition .accessType !== _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .outputOnly,
               enumerable: true,
               configurable: true,
            };
         }
      }
   },
};

function SFNode (value)
{
   // Node need to test for X3DBaseNode, because there is a special version of SFNode in Script.

   const proxy = new Proxy (this, handler);

   this [_target] = this;
   this [_proxy]  = proxy;

   if (value ?.getType () .includes (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .X3DNode))
   {
      value .addParent (proxy);

      _Base_X3DField_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .call (this, value);
   }
   else
   {
      _Base_X3DField_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .call (this, null);
   }

   return proxy;
}

Object .assign (Object .setPrototypeOf (SFNode .prototype, _Base_X3DField_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .prototype),
{
   [_target]: null,
   [_proxy]: null,
   copy (instance)
   {
      const
         target = this [_target],
         value  = target .getValue ();

      if (value && instance)
      {
         const copy = value .copy (instance);

         copy .setup ();

         return new SFNode (copy);
      }

      return new SFNode (value);
   },
   equals (node)
   {
      const target = this [_target];

      if (node)
         return target .getValue () === node .getValue ();

      return target .getValue () === null;
   },
   isDefaultValue ()
   {
      const target = this [_target];

      return target .getValue () === null;
   },
   set (value)
   {
      const
         target  = this [_target],
         current = target .getValue ();

      current ?.removeParent (target [_proxy]);

      // No need to test for X3DBaseNode, because there is a special version of SFNode in Script.

      if (value ?.getType () .includes (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .X3DNode))
      {
         value .addParent (target [_proxy]);

         _Base_X3DField_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .prototype .set .call (target, value);
      }
      else
      {
         _Base_X3DField_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .prototype .set .call (target, null);
      }
   },
   getNodeTypeName ()
   {
      const
         target = this [_target],
         value  = target .getValue ();

      if (value)
         return value .getTypeName ();

      throw new Error ("SFNode.getNodeTypeName: node is null.");
   },
   getNodeName ()
   {
      const
         target = this [_target],
         value  = target .getValue ();

      if (value)
         return value .getName ();

      throw new Error ("SFNode.getNodeName: node is null.");
   },
   getNodeDisplayName ()
   {
      const
         target = this [_target],
         value  = target .getValue ();

      if (value)
         return value .getDisplayName ();

      throw new Error ("SFNode.getNodeDisplayName: node is null.");
   },
   getNodeType ()
   {
      const
         target = this [_target],
         value  = target .getValue ();

      if (value)
         return Array .from (value .getType ());

      throw new Error ("SFNode.getNodeType: node is null.");
   },
   getFieldDefinition (name)
   {
      const fieldDefinition = this .getFieldDefinitions () .get (name);

      if (fieldDefinition)
         return fieldDefinition;

      throw new Error (`Unknown field '${name}' in node class ${this .getNodeTypeName ()}.`);
   },
   getFieldDefinitions ()
   {
      const
         target = this [_target],
         value  = target .getValue ();

      if (value)
         return value .getFieldDefinitions ();

      throw new Error ("SFNode.getFieldDefinitions: node is null.");
   },
   /**
   * @deprecated Returns the corresponding X3DField object associated with *name*. Use sfnode.{fieldName} syntax.
   */
   getField (name)
   {
      const
         target = this [_target],
         value  = target .getValue ();

      if (value)
         return value .getField (name);

      throw new Error ("SFNode is disposed.")
   },
   addFieldCallback (... args)
   {
      const target = this [_target];

      switch (args .length)
      {
         case 2:
         {
            const [key, callback] = args;

            return _Base_X3DField_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .prototype .addFieldCallback .call (target, key, callback);
         }
         case 3:
         {
            const
               [key, name, callback] = args,
               value                 = target .getValue ();

            if (value)
               return value .getField (name) .addFieldCallback (key, callback);

            throw new Error ("SFNode.addFieldCallback: node is null.");
         }
      }
   },
   removeFieldCallback (... args)
   {
      const target = this [_target];

      switch (args .length)
      {
         case 1:
         {
            const key = [args];

            return _Base_X3DField_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .prototype .removeFieldCallback .call (target, key);
         }
         case 2:
         {
            const
               [key, name] = args,
               value       = target .getValue ();

            if (value)
               return value .getField (name) .removeFieldCallback (key);

            throw new Error ("SFNode.removeFieldCallback: node is null.");
         }
      }
   },
   getNodeUserData (key)
   {
      const value = this [_target] .getValue ();

      if (value)
         return value .getUserData (key);

      throw new Error ("SFNode.getNodeUserData: node is null.");
   },
   setNodeUserData (key, data)
   {
      const value = this [_target] .getValue ();

      if (value)
         return value .setUserData (key, data);

      throw new Error ("SFNode.setNodeUserData: node is null.");
   },
   removeNodeUserData (key)
   {
      const value = this [_target] .getValue ();

      if (value)
         return value .removeUserData (key);

      throw new Error ("SFNode.removeNodeUserData: node is null.");
   },
   valueOf ()
   {
      const
         target = this [_target],
         value  = target .getValue ();

      return value ? _SFNodeCache_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .get (value) : null;
   },
   toStream (generator)
   {
      const
         target = this [_target],
         value  = target .getValue ();

      if (value)
         value .toStream (generator);
      else
         generator .string += "NULL";
   },
   toVRMLStream (generator)
   {
      const
         target = this [_target],
         value  = target .getValue ();

      if (value)
         value .toVRMLStream (generator);
      else
         generator .string += "NULL";
   },
   toXMLStream (generator)
   {
      const
         target = this [_target],
         value  = target .getValue ();

      if (value)
         value .toXMLStream (generator);
      else
         generator .string += "<!-- NULL -->";
   },
   toJSONStream (generator)
   {
      this .toJSONStreamValue (generator);
   },
   toJSONStreamValue (generator)
   {
      const
         target = this [_target],
         value  = target .getValue ();

      if (value)
         value .toJSONStream (generator);
      else
         generator .string += "null";
   },
   dispose ()
   {
      const target = this [_target];

      target .set (null);
      target .processInterests ();

      _Base_X3DField_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .prototype .dispose .call (target);
   },
});

for (const key of Object .keys (SFNode .prototype))
   Object .defineProperty (SFNode .prototype, key, { enumerable: false });

Object .defineProperties (SFNode,
{
   typeName:
   {
      value: "SFNode",
      enumerable: true,
   },
});

const __default__ = SFNode;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .add ("SFNode", __default__));

/***/ }),

/***/ 1168:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   l: () => (/* binding */ getUniqueName)
/* harmony export */ });
const getUniqueName = function (map, name = "")
{
   name = String (name);

   if (name && !map .has (name))
      return name;

   name = name .replace (/_\d+$/, "");

   if (name && !map .has (name))
      return name;

   let
      newName = "",
      lo,
      hi = 1;

   do
   {
      lo   = hi;
      hi <<= 1;

      newName = `${name}_${lo}`;
   }
   while (map .has (newName));

   lo >>>= 1;
   hi >>>= 1;

   if (lo && hi)
   {
      while (lo < hi)
      {
         const m = (lo + hi) >>> 1;

         if (map .has (`${name}_${m}`))
            lo = m + 1;
         else
            hi = m;
      }

      newName = `${name}_${lo}`;
   }

   return newName;
};


/***/ }),

/***/ 1206:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Base_X3DField_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(2269);
/* harmony import */ var _Base_X3DBaseNode_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(3643);
/* harmony import */ var _Components_Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(2340);
/* harmony import */ var _Components_Core_X3DPrototypeInstance_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(6807);
/* harmony import */ var _Fields_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(4598);
/* harmony import */ var _X3DParser_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(6376);
/* harmony import */ var _VRMLParser_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(3816);
/* harmony import */ var _HTMLSupport_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(1376);
/* harmony import */ var _Execution_X3DImportedNode_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(3288);
/* harmony import */ var _Prototype_X3DExternProtoDeclaration_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(8616);
/* harmony import */ var _Prototype_X3DProtoDeclaration_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(4246);
/* harmony import */ var _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(2212);
/* harmony import */ var _Placeholder_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(2921);
/* harmony import */ var _DEVELOPMENT_js__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(615);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(717);
/* provided dependency */ var $ = __webpack_require__(9547);















const AccessType =
{
   initializeOnly: _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A .initializeOnly,
   inputOnly:      _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A .inputOnly,
   outputOnly:     _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A .outputOnly,
   inputOutput:    _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A .inputOutput,
};

function XMLParser (scene)
{
   _X3DParser_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .call (this, scene);

   this .protoDeclarations = [ ];
   this .parents           = [ ];
   this .parser            = new _VRMLParser_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A (scene);
   this .url               = new _Fields_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .MFString ();
   this .protoNames        = new Map ();
   this .protoFields       = new WeakMap ();

   this .parser .setUnits (!!scene);
}

Object .assign (Object .setPrototypeOf (XMLParser .prototype, _X3DParser_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .prototype),
{
   getEncoding ()
   {
      return "XML";
   },
   setInput (xmlElement)
   {
      try
      {
         if (typeof xmlElement === "string")
            xmlElement = $.parseXML (xmlElement);

         this .input = xmlElement;
         this .xml   = this .isXML (xmlElement);

         if (!this .xml)
            Object .assign (this, HTMLParser);
      }
      catch
      {
         this .input = undefined;
      }
   },
   isValid ()
   {
      return (this .input instanceof XMLDocument) || (this .input instanceof HTMLElement) || (this .input === null);
   },
   isXML (element)
   {
      if (element instanceof HTMLElement)
         return false;
      else
         return true;
   },
   parseIntoScene (resolve, reject)
   {
      const
         browser = this .getBrowser (),
         scene   = this .getScene ();

      this .resolve = resolve;
      this .reject  = reject;

      scene .setEncoding ("XML");
      scene .setProfile (browser .getProfile ("Full"));

      this .xmlElement (this .input);
   },
   xmlElement (xmlElement)
   {
      const
         browser = this .getBrowser (),
         scene   = this .getScene ();

      if (xmlElement === null)
         return this .resolve ?.(scene);

      switch (xmlElement .nodeName)
      {
         case "#document":
         {
            const X3D = $(xmlElement) .children ("X3D");

            if (X3D .length)
            {
               for (const xmlElement of X3D)
                  this .x3dElement (xmlElement);
            }
            else
            {
               if (this .resolve)
               {
                  browser .loadComponents (scene) .then (() =>
                  {
                     this .childrenElements (xmlElement);
                     this .setupNodes ();
                     this .resolve (scene);
                  })
                  .catch (this .reject);
               }
               else
               {
                  this .childrenElements (xmlElement);
                  this .setupNodes ();
               }
            }

            break;
         }
         case "X3D":
         {
            this .x3dElement (xmlElement);
            break;
         }
         case "Scene":
         case "SCENE":
         {
            if (this .resolve)
            {
               browser .loadComponents (scene) .then (() =>
               {
                  this .sceneElement (xmlElement);
                  this .setupNodes ();
                  this .resolve (scene);
               })
               .catch (this .reject);
            }
            else
            {
               this .sceneElement (xmlElement);
               this .setupNodes ();
            }

            break;
         }
         default:
         {
            if (this .resolve)
            {
               browser .loadComponents (scene) .then (() =>
               {
                  this .childrenElements (xmlElement);
                  this .setupNodes ();
                  this .resolve (scene);
               })
               .catch (this .reject);
            }
            else
            {
               this .childrenElements (xmlElement);
               this .setupNodes ();
            }

            break;
         }
      }
   },
   x3dElement (xmlElement)
   {
      const
         browser = this .getBrowser (),
         scene   = this .getScene ();

      try
      {
         // Profile

         const
            profileNameId = xmlElement .getAttribute ("profile"),
            profile       = browser .getProfile (profileNameId || "Full");

         $.data (this .scene, "X3D", xmlElement);

         scene .setProfile (profile);
      }
      catch (error)
      {
         console .error (error);
      }

      // Specification version

      const specificationVersion = xmlElement .getAttribute ("version");

      if (specificationVersion)
         scene .setSpecificationVersion (specificationVersion);

      // Process child nodes

      for (const childNode of xmlElement .childNodes)
         this .x3dElementChildHead (childNode)

      if (!this .xml)
         this .headElement (xmlElement);

      if (this .resolve)
      {
         browser .loadComponents (scene) .then (() =>
         {
            for (const childNode of xmlElement .childNodes)
               this .x3dElementChildScene (childNode)

            this .setupNodes ();
            this .resolve (scene);
         })
         .catch (this .reject);
      }
      else
      {
         for (const childNode of xmlElement .childNodes)
            this .x3dElementChildScene (childNode)

         this .setupNodes ();
      }
   },
   x3dElementChildHead (xmlElement)
   {
      switch (xmlElement .nodeName)
      {
         case "head":
         case "HEAD":
            this .headElement (xmlElement);
            return;
      }
   },
   x3dElementChildScene (xmlElement)
   {
      switch (xmlElement .nodeName)
      {
         case "Scene":
         case "SCENE":
            this .sceneElement (xmlElement);
            return;
      }
   },
   headElement (xmlElement)
   {
      for (const childNode of xmlElement .childNodes)
         this .headElementChild (childNode);
   },
   headElementChild (xmlElement)
   {
      switch (xmlElement .nodeName)
      {
         case "component":
         case "COMPONENT":
            this .componentElement (xmlElement);
            return;
         case "unit":
         case "UNIT":
            this .unitElement (xmlElement);
            return;
         case "meta":
         case "META":
            this .metaElement (xmlElement);
            return;
      }
   },
   componentElement (xmlElement)
   {
      try
      {
         const
            componentNameIdCharacters = xmlElement .getAttribute ("name"),
            componentSupportLevel     = xmlElement .getAttribute ("level");

         if (componentNameIdCharacters === null)
            return console .warn ("XML Parser: Bad component statement. Expected name attribute.");

         if (componentSupportLevel === null)
            return console .warn ("XML Parser: Bad component statement. Expected level attribute.");

         const component = this .getBrowser () .getComponent (componentNameIdCharacters, parseInt (componentSupportLevel));

         if (this .getScene () .hasComponent (component))
            return;

         this .getScene () .updateComponent (component);
      }
      catch (error)
      {
         console .log (error .message);
      }
   },
   unitElement (xmlElement)
   {
      const
         category         = xmlElement .getAttribute ("category"),
         name             = xmlElement .getAttribute ("name"),
         conversionFactor = xmlElement .getAttribute ("conversionFactor"); //works for html5 as well

      if (category === null)
         return console .warn ("XML Parser: Bad unit statement. Expected category attribute.");

      if (name === null)
         return console .warn ("XML Parser: Bad unit statement. Expected name attribute.");

      if (conversionFactor === null)
         return console .warn ("XML Parser: Bad unit statement. Expected conversionFactor attribute.");

      this .getScene () .updateUnit (category, name, parseFloat (conversionFactor));
   },
   metaElement (xmlElement)
   {
      const
         metakey   = xmlElement .getAttribute ("name"),
         metavalue = xmlElement .getAttribute ("content");

      if (metakey === null)
         return console .warn ("XML Parser: Bad meta statement. Expected name attribute.");

      if (metavalue === null)
         return console .warn ("XML Parser: Bad meta statement. Expected content attribute.");

      this .getScene () .addMetaData (metakey, metavalue);
   },
   sceneElement (xmlElement)
   {
      $.data (xmlElement, "node", this .scene);

      this .childrenElements (xmlElement);
   },
   childrenElements (xmlElement)
   {
      for (const childNode of xmlElement .childNodes)
         this .childElement (childNode);
   },
   childElement (xmlElement)
   {
      switch (xmlElement .nodeName)
      {
         case "#comment":
         case "#text":
            return;

         case "#cdata-section":
            this .cdataNode (xmlElement);
            return;

         case "ExternProtoDeclare":
         case "EXTERNPROTODECLARE":
            this .externProtoDeclareElement (xmlElement);
            return;

         case "ProtoDeclare":
         case "PROTODECLARE":
            this .protoDeclareElement (xmlElement);
            return;

         case "IS":
            this .isElement (xmlElement);
            return;

         case "ProtoInstance":
         case "PROTOINSTANCE":
            this .protoInstanceElement (xmlElement);
            return;

         case "fieldValue":
         case "FIELDVALUE":
            this .fieldValueElement (xmlElement);
            return;

         case "field":
         case "FIELD":
            this .fieldElement (xmlElement);
            return;

         case "ROUTE":
            this .routeElement (xmlElement);
            return;

         case "IMPORT":
            this .importElement (xmlElement);
            return;

         case "EXPORT":
            this .exportElement (xmlElement);
            return;

         default:
            this .nodeElement (xmlElement);
            return;
      }
   },
   externProtoDeclareElement (xmlElement)
   {
      const name = xmlElement .getAttribute ("name");

      if (this .id (name))
      {
         const
            url           = xmlElement .getAttribute ("url"),
            appInfo       = xmlElement .getAttribute ("appinfo"),
            documentation = xmlElement .getAttribute ("documentation");

         this .parser .setInput (url ?? "");
         this .parser .sfstringValues (this .url);

         if (!this .url .length)
            console .warn ("XML Parser: Bad ExternProtoDeclare statement. Expected url attribute with value.");

         const externproto = new _Prototype_X3DExternProtoDeclaration_js__WEBPACK_IMPORTED_MODULE_9__/* ["default"] */ .A (this .getExecutionContext (), this .url);

         this .pushParent (externproto);
         this .protoInterfaceElement (xmlElement);
         this .popParent ();
         this .addProtoFieldNames (externproto);

         externproto .setAppInfo (appInfo ?? "");
         externproto .setDocumentation (documentation ?? "");
         externproto .setup ();

         try
         {
            const existingExternProto = this .getExecutionContext () .getExternProtoDeclaration (name);

            console .warn (`A extern proto named '${name}' is already defined and will be overridden.`);

            this .getExecutionContext () .updateExternProtoDeclaration (this .getExecutionContext () .getUniqueExternProtoName (name), existingExternProto);
         }
         catch
         { }

         this .getExecutionContext () .updateExternProtoDeclaration (name, externproto);

         this .addProtoName (name);
      }
   },
   protoDeclareElement (xmlElement)
   {
      const
         name          = xmlElement .getAttribute ("name"),
         appInfo       = xmlElement .getAttribute ("appinfo"),
         documentation = xmlElement .getAttribute ("documentation");

      if (this .id (name))
      {
         const proto = new _Prototype_X3DProtoDeclaration_js__WEBPACK_IMPORTED_MODULE_10__/* ["default"] */ .A (this .getExecutionContext ());

         for (const childNode of xmlElement .childNodes)
         {
            switch (childNode .nodeName)
            {
               case "ProtoInterface":
               case "PROTOINTERFACE":
               {
                  this .pushParent (proto);
                  this .protoInterfaceElement (childNode);
                  this .popParent ();
                  this .addProtoFieldNames (proto);
                  break;
               }
               default:
                  continue;
            }

            break;
         }

         for (const childNode of xmlElement .childNodes)
         {
            switch (childNode .nodeName)
            {
               case "ProtoBody":
               case "PROTOBODY":
               {
                  this .pushExecutionContext (proto .getBody ());
                  this .pushParent (proto);
                  this .protoBodyElement (childNode);
                  this .popParent ();
                  this .setupNodes ();
                  this .popExecutionContext ();
                  break;
               }
               default:
                  continue;
            }

            break;
         }

         proto .setAppInfo (appInfo ?? "");
         proto .setDocumentation (documentation ?? "");
         proto .setup ();

         try
         {
            const existingProto = this .getExecutionContext () .getProtoDeclaration (name);

            console .warn (`A proto named '${name}' is already defined and will be overridden.`);

            this .getExecutionContext () .updateProtoDeclaration (this .getExecutionContext () .getUniqueProtoName (name), existingProto);
         }
         catch
         { }

         this .getExecutionContext () .updateProtoDeclaration (name, proto);

         this .addProtoName (name);
      }
   },
   protoInterfaceElement (xmlElement)
   {
      for (const childNode of xmlElement .childNodes)
         this .protoInterfaceElementChild (childNode);
   },
   protoInterfaceElementChild (xmlElement)
   {
      switch (xmlElement .nodeName)
      {
         case "field": // User-defined field
         case "FIELD": // User-defined field
            this .fieldElement (xmlElement);
            return;
      }
   },
   fieldElement (xmlElement)
   {
      try
      {
         if (this .getParents () .length === 0)
            return;

         const node = this .getParent ();

         if (!(node instanceof _Base_X3DBaseNode_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A))
            return;

         if (!node .canUserDefinedFields ())
            return;

         const
            accessType = AccessType [xmlElement .getAttribute ("accessType")] || _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A .initializeOnly,
            Field      = _Fields_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A [xmlElement .getAttribute ("type")];

         if (!Field)
            return;

         const
            name          = xmlElement .getAttribute ("name"),
            appInfo       = xmlElement .getAttribute ("appinfo"),
            documentation = xmlElement .getAttribute ("documentation");

         if (!this .id (name))
            return;

         const field = new Field ();

         field .setAppInfo (appInfo ?? "");
         field .setDocumentation (documentation ?? "");

         if (accessType & _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A .initializeOnly)
         {
            this .fieldValue (field, xmlElement .getAttribute ("value"));

            this .pushParent (field);
            this .childrenElements (xmlElement);
            this .popParent ();
         }

         node .addUserDefinedField (accessType, name, field);
      }
      catch (error)
      {
         console .error (error);
      }
   },
   protoBodyElement (xmlElement)
   {
      this .childrenElements (xmlElement);
   },
   isElement (xmlElement)
   {
      if (this .isInsideProtoDeclaration ())
      {
         for (const childNode of xmlElement .childNodes)
            this .isElementChild (childNode);
      }
   },
   isElementChild (xmlElement)
   {
      switch (xmlElement .nodeName)
      {
         case "connect":
         case "CONNECT":
            this .connectElement (xmlElement);
            return;
      }
   },
   connectElement (xmlElement)
   {
      const
         nodeFieldName  = xmlElement .getAttribute ("nodeField"),
         protoFieldName = xmlElement .getAttribute ("protoField");

      if (nodeFieldName === null)
         return console .warn ("XML Parser: Bad connect statement. Expected nodeField attribute.");

      if (protoFieldName === null)
         return console .warn ("XML Parser: Bad connect statement. Expected protoField attribute.");

      try
      {
         if (this .getParents () .length === 0)
            return;

         const
            node  = this .getParent (),
            proto = this .getOuterNode ();

         if (!(node instanceof _Components_Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A))
            return;

         const
            nodeField  = node .getField (nodeFieldName),
            protoField = proto .getField (protoFieldName);

         if (nodeField .getType () === protoField .getType ())
         {
            if (protoField .isReference (nodeField .getAccessType ()))
               nodeField .addReference (protoField);
            else
               throw new Error (`Field '${nodeField .getName ()}' and '${protoField .getName ()}' in PROTO ${proto .getName ()} are incompatible as an IS mapping.`);
         }
         else
            throw new Error (`Field '${nodeField .getName ()}' and '${protoField .getName ()}' in PROTO ${this .proto .getName()} have different types.`);
      }
      catch (error)
      {
         console .warn (`XML Parser: Couldn't create IS reference. ${error .message}`);
      }
   },
   protoInstanceElement (xmlElement)
   {
      try
      {
         if (this .useAttribute (xmlElement))
            return;

         const name = xmlElement .getAttribute ("name");

         if (this .id (name))
         {
            const node = this .getExecutionContext () .createProto (name, false);

            if (!node)
               throw new Error (`Unknown proto or externproto type '${name}'.`);

            ///DOMIntegration: attach node to DOM xmlElement for access from DOM.
            $.data (xmlElement, "node", node);

            this .defAttribute (xmlElement, node);
            this .addNode (xmlElement, node);
            this .pushParent (node);
            this .childrenElements (xmlElement);

            if (!this .isInsideProtoDeclaration ())
               this .getNodes () .push (node);

            this .popParent ();
         }
      }
      catch (error)
      {
         console .warn ("XML Parser: ", error .message);

         if (_DEVELOPMENT_js__WEBPACK_IMPORTED_MODULE_13__/* ["default"] */ .A)
            console .error (error);
      }
   },
   fieldValueElement (xmlElement)
   {
      try
      {
         if (this .getParents () .length === 0)
            return;

         const
            node = this .getParent (),
            name = xmlElement .getAttribute ("name");

         if (!(node instanceof _Components_Core_X3DPrototypeInstance_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A))
            return;

         if (!this .id (name))
            return;

         const
            field      = node .getField (name),
            accessType = field .getAccessType ();

         if (accessType & _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A .initializeOnly)
         {
            if (field .getType () === _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A .MFNode)
            {
               field .length = 0
            }

            this .fieldValue (field, xmlElement .getAttribute ("value"));

            this .pushParent (field);
            this .childrenElements (xmlElement);
            this .popParent ();
         }
      }
      catch (error)
      {
         console .warn (`XML Parser: Couldn't assign field value. ${error .message}`);
      }
   },
   nodeElement (xmlElement)
   {
      try
      {
         if (this .useAttribute (xmlElement))
            return;

         const node = this .getExecutionContext () .createNode (this .nodeNameToCamelCase (xmlElement .nodeName), false)
            ?? this .getExecutionContext () .createProto (this .protoNameToCamelCase (xmlElement .nodeName), false);

         if (!node)
            throw new Error (`Unknown node type '${xmlElement .nodeName}', you probably have insufficient component/profile statements and/or an inappropriate specification version.`);

         ///DOMIntegration: attach node to DOM xmlElement for access from DOM.
         $.data (xmlElement, "node", node);

         //DOMIntegration: Script node support for HTML.
         if (xmlElement .nodeName === "SCRIPT")
            this .scriptElement (xmlElement);

         this .defAttribute (xmlElement, node);
         this .addNode (xmlElement, node);
         this .pushParent (node);
         this .nodeAttributes (xmlElement, node);
         this .childrenElements (xmlElement);

         if (!this .isInsideProtoDeclaration ())
            this .getNodes () .push (node);

         this .popParent ();
      }
      catch (error)
      {
         // NULL

         if (xmlElement .nodeName == "NULL")
         {
            this .addNode (xmlElement, null);
            return;
         }

         if (_DEVELOPMENT_js__WEBPACK_IMPORTED_MODULE_13__/* ["default"] */ .A)
            console .error (error);
         else
            console .error (`XML Parser: ${error .message}`);
      }
   },
   scriptElement (element)
   {
      const
         scriptDocument = $.parseXML (element .outerHTML, "application/xml"),
         childNodes     = scriptDocument .children [0] .childNodes;

      element .textContent = "// Content moved into childNodes.";

      for (const childNode of childNodes)
      {
         // Add elements and cdata.
         if (childNode .nodeType === 1 || childNode .nodeType === 4)
            element .appendChild (childNode);
      }
   },
   routeElement (xmlElement)
   {
      try
      {
         const
            sourceNodeName      = xmlElement .getAttribute ("fromNode"),
            sourceField         = xmlElement .getAttribute ("fromField"),
            destinationNodeName = xmlElement .getAttribute ("toNode"),
            destinationField    = xmlElement .getAttribute ("toField");

         if (sourceNodeName === null)
            throw new Error ("Bad ROUTE statement: Expected fromNode attribute.");

         if (sourceField === null)
            throw new Error ("Bad ROUTE statement: Expected fromField attribute.");

         if (destinationNodeName === null)
            throw new Error ("Bad ROUTE statement: Expected toNode attribute.");

         if (destinationField === null)
            throw new Error ("Bad ROUTE statement: Expected toField attribute.");

         const
            executionContext = this .getExecutionContext (),
            sourceNode       = executionContext .getLocalNode (sourceNodeName),
            destinationNode  = executionContext .getLocalNode (destinationNodeName),
            route            = executionContext .addRoute (sourceNode, sourceField, destinationNode, destinationField);

         ///DOMIntegration: attach node to DOM xmlElement for access from DOM.
         $.data (xmlElement, "node", route);
      }
      catch (error)
      {
         console .warn (`XML Parser: ${error .message}`);

         if (_DEVELOPMENT_js__WEBPACK_IMPORTED_MODULE_13__/* ["default"] */ .A)
            console .error (error);
      }
   },
   importElement (xmlElement)
   {
      try
      {
         const
            inlineNodeName   = xmlElement .getAttribute ("inlineDEF"),
            exportedNodeName = xmlElement .getAttribute ("importedDEF") || xmlElement .getAttribute ("exportedDEF"),
            localNodeName    = xmlElement .getAttribute ("AS") || exportedNodeName;

         if (inlineNodeName === null)
            throw new Error ("Bad IMPORT statement: Expected inlineDEF attribute.");

         if (exportedNodeName === null)
            throw new Error ("Bad IMPORT statement: Expected importedDEF attribute.");

         const inlineNode = this .getExecutionContext () .getNamedNode (inlineNodeName);

         // Rename existing imported node.

         this .renameExistingNode (localNodeName);

         // Add new imported node.

         this .getExecutionContext () .addImportedNode (inlineNode, exportedNodeName, localNodeName);

         if (!this .getImportedNodes () .has (localNodeName))
         {
            this .getImportedNodes () .set (localNodeName, this .getExecutionContext () .getImportedNodes () .get (localNodeName));
         }
      }
      catch (error)
      {
         console .warn (`XML Parser: ${error .message}`);
      }
   },
   exportElement (xmlElement)
   {
      try
      {
         const
            localNodeName    = xmlElement .getAttribute ("localDEF"),
            exportedNodeName = xmlElement .getAttribute ("AS") || localNodeName;

         if (localNodeName === null)
            throw new Error ("Bad EXPORT statement: Expected localDEF attribute.");

         const localNode = this .getExecutionContext () .getLocalNode (localNodeName);

         try
         {
            const existingNode = this .getScene () .getExportedNode (exportedNodeName);

            this .getScene () .addExportedNode (this .getScene () .getUniqueExportName (exportedNodeName), existingNode);
         }
         catch
         { }

         this .getScene () .updateExportedNode (exportedNodeName, localNode);
      }
      catch (error)
      {
         console .warn (`XML Parser: ${error .message}`);
      }
   },
   cdataNode (xmlElement)
   {
      if (this .getParents () .length === 0)
         return;

      const node = this .getParent ();

      if (node instanceof _Components_Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A)
         node .getSourceText () ?.push (xmlElement .data);
   },
   useAttribute (xmlElement)
   {
      try
      {
         const name = xmlElement .getAttribute ("USE");

         if (this .id (name))
         {
            const nodeName = this .nodeNameToCamelCase (xmlElement .nodeName);

            const type = nodeName === "ProtoInstance"
               ? this .getBrowser () .getAbstractNode ("X3DPrototypeInstance")
               : this .getBrowser () .getConcreteNode (nodeName);

            const typeName = xmlElement .getAttribute ("name");

            try
            {
               const localNode = this .getExecutionContext () .getLocalNode (name);

               const node = localNode instanceof _Execution_X3DImportedNode_js__WEBPACK_IMPORTED_MODULE_8__/* ["default"] */ .A
                  ? localNode .getExportedNode (type)
                  : localNode .getValue ();

               this .checkNodeType (node, name, type, typeName);
               this .addNode (xmlElement, node);
            }
            catch
            {
               const placeholder = this .getPlaceholders () .get (name);

               if (placeholder)
               {
                  this .addNode (xmlElement, placeholder);
               }
               else
               {
                  const placeholder = new _Placeholder_js__WEBPACK_IMPORTED_MODULE_12__/* ["default"] */ .A (this, name, type, typeName);

                  this .getPlaceholders () .set (name, placeholder);
                  this .addNode (xmlElement, placeholder);
               }
            }

            return true;
         }
      }
      catch (error)
      {
         console .warn (`XML Parser: Invalid USE name: ${error .message}`);
      }

      return false;
   },
   checkNodeType (node, name, type, typeName)
   {
      if (type !== _Components_Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A)
      {
         if (type === _Components_Core_X3DPrototypeInstance_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A)
         {
            if (!node .getType () .includes (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A .X3DPrototypeInstance))
            {
               console .warn (`XML Parser: DEF/USE mismatch, '${name}', referenced node is not of type X3DPrototypeInstance.`);
            }
            else if (typeName !== node .getTypeName ())
            {
               console .warn (`XML Parser: DEF/USE mismatch, '${name}', name ${typeName} != ${node .getTypeName ()}.`);
            }
         }
         else if (type !== node .constructor)
         {
            console .warn (`XML Parser: DEF/USE mismatch, '${name}', ${type .typeName} != ${node .getTypeName ()}.`);
         }
      }
   },
   defAttribute (xmlElement, node)
   {
      try
      {
         const name = xmlElement .getAttribute ("DEF");

         if (name)
         {
            if (!this .getNamedNodes () .has (name))
               this .getNamedNodes () .set (name, node);

            this .renameExistingNode (name);

            this .getExecutionContext () .updateNamedNode (name, node);
         }
      }
      catch (error)
      {
         console .warn (`XML Parser: Invalid DEF name: ${error .message}`);
      }
   },
   nodeAttributes (xmlElement, node)
   {
      for (const xmlAttribute of xmlElement .attributes)
         this .nodeAttribute (xmlAttribute, node);
   },
   nodeAttribute (xmlAttribute, node)
   {
      try
      {
         const field = node .getPredefinedField (this .attributeToCamelCase (node, xmlAttribute .name));

         if (field .isInitializable ())
            this .fieldValue (field, xmlAttribute .value);
      }
      catch (error)
      {
         //console .error (error);
      }
   },
   fieldValue (field, value)
   {
      if (value === null)
         return false;

      this .parser .pushExecutionContext (this .getExecutionContext ());
      this .parser .setInput (value);

      const ok = this [field .getType ()] .call (this .parser, field, field .getUnit ());

      this .parser .popExecutionContext ();

      return ok;
   },
   id (string)
   {
      if (string === null)
         return false;

      if (string .length === 0)
         return false;

      return true;
   },
   getParents ()
   {
      return this .parents;
   },
   getParent ()
   {
      return this .parents .at (-1);
   },
   pushParent (parent)
   {
      return this .parents .push (parent);
   },
   popParent ()
   {
      this .parents .pop ();
   },
   addNode (xmlElement, node)
   {
      if (this .parents .length === 0 || this .getParent () instanceof _Prototype_X3DProtoDeclaration_js__WEBPACK_IMPORTED_MODULE_10__/* ["default"] */ .A)
      {
         this .getExecutionContext () .rootNodes .push (node);
         return;
      }

      const parent = this .getParent ();

      if (parent instanceof _Base_X3DField_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A)
      {
         switch (parent .getType ())
         {
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A .SFNode:
               parent .setValue (node);
               return;

            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A .MFNode:
               parent .push (node);
               return;
         }

         return;
      }

      // parent is a node.

      try
      {
         const containerField = xmlElement .getAttribute ("containerField")
            || node ?.getContainerField (this .getExecutionContext () .getSpecificationVersion ());

         if (!containerField)
         {
            console .warn ("XML Parser: Node must have a container field attribute.");
            return;
         }

         const field = parent .getField (containerField);

         switch (field .getType ())
         {
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A .SFNode:
               field .setValue (node);
               return;

            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A .MFNode:
               field .push (node);
               return;
         }
      }
      catch (error)
      {
         // console .error (error);

         if (node ?.getType () .includes (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A .X3DMetadataObject))
         {
            xmlElement .setAttribute ("containerField", "metadata");

            this .addNode (xmlElement, node);
         }
      }
   },
   // Overloaded by HTMLParser.
   addProtoName (name)
   { },
   addProtoFieldNames (protoNode)
   { },
   protoNameToCamelCase (typeName)
   {
      return typeName;
   },
   nodeNameToCamelCase (typeName)
   {
      return typeName;
   },
   attributeToCamelCase (node, name)
   {
      return name;
   },
});

Object .assign (XMLParser .prototype,
{
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A .SFBool]:      _VRMLParser_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .prototype .sfboolValue,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A .SFColor]:     _VRMLParser_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .prototype .sfcolorValue,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A .SFColorRGBA]: _VRMLParser_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .prototype .sfcolorrgbaValue,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A .SFDouble]:    _VRMLParser_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .prototype .sfdoubleValue,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A .SFFloat]:     _VRMLParser_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .prototype .sfdoubleValue,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A .SFImage]:     _VRMLParser_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .prototype .sfimageValue,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A .SFInt32]:     _VRMLParser_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .prototype .sfint32Value,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A .SFMatrix3f]:  _VRMLParser_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .prototype .sfmatrix3Value,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A .SFMatrix3d]:  _VRMLParser_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .prototype .sfmatrix3Value,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A .SFMatrix4f]:  _VRMLParser_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .prototype .sfmatrix4Value,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A .SFMatrix4d]:  _VRMLParser_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .prototype .sfmatrix4Value,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A .SFNode] (field)
   {
      field .setValue (null);
      return true;
   },
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A .SFRotation]:  _VRMLParser_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .prototype .sfrotationValue,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A .SFString] (field)
   {
      field .setValue (_Fields_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .SFString .unescape (this .input));
      return true;
   },
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A .SFTime]:      _VRMLParser_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .prototype .sfdoubleValue,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A .SFVec2d]:     _VRMLParser_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .prototype .sfvec2Value,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A .SFVec2f]:     _VRMLParser_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .prototype .sfvec2Value,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A .SFVec3d]:     _VRMLParser_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .prototype .sfvec3Value,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A .SFVec3f]:     _VRMLParser_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .prototype .sfvec3Value,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A .SFVec4d]:     _VRMLParser_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .prototype .sfvec4Value,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A .SFVec4f]:     _VRMLParser_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .prototype .sfvec4Value,

   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A .VrmlMatrix]:  _VRMLParser_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .prototype .sfmatrix4Value,

   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A .MFBool]:      _VRMLParser_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .prototype .sfboolValues,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A .MFColor]:     _VRMLParser_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .prototype .sfcolorValues,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A .MFColorRGBA]: _VRMLParser_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .prototype .sfcolorValues,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A .MFDouble]:    _VRMLParser_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .prototype .sfdoubleValues,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A .MFFloat]:     _VRMLParser_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .prototype .sfdoubleValues,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A .MFImage]:     _VRMLParser_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .prototype .sfimageValues,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A .MFInt32]:     _VRMLParser_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .prototype .sfint32Values,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A .MFMatrix3d]:  _VRMLParser_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .prototype .sfmatrixValues,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A .MFMatrix3f]:  _VRMLParser_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .prototype .sfmatrixValues,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A .MFMatrix4d]:  _VRMLParser_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .prototype .sfmatrixValues,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A .MFMatrix4f]:  _VRMLParser_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .prototype .sfmatrixValues,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A .MFNode] (field)
   {
      field .length = 0;
      return true;
   },
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A .MFRotation]:  _VRMLParser_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .prototype .sfrotationValues,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A .MFString]:    _VRMLParser_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .prototype .sfstringValues,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A .MFTime]:      _VRMLParser_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .prototype .sfdoubleValues,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A .MFVec2d]:     _VRMLParser_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .prototype .sfvecValues,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A .MFVec2f]:     _VRMLParser_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .prototype .sfvecValues,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A .MFVec3d]:     _VRMLParser_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .prototype .sfvecValues,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A .MFVec3f]:     _VRMLParser_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .prototype .sfvecValues,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A .MFVec4d]:     _VRMLParser_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .prototype .sfvecValues,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A .MFVec4f]:     _VRMLParser_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .prototype .sfvecValues,
});

// HTML Support

const HTMLParser =
{
   addProtoName (name)
   {
      // DOMIntegration: add uppercase versions of proto name.

      this .protoNames .set (name,                 name);
      this .protoNames .set (name .toUpperCase (), name);
   },
   addProtoFieldNames: (() =>
   {
      const reservedAttributes = new Set ();

      for (const reservedAttribute of [
         "DEF",
         "USE",
         "containerField",
      ])
      {
         reservedAttributes
            .add (reservedAttribute)
            .add (reservedAttribute .toLowerCase ());
      }

      return function (protoNode)
      {
         //DOMIntegration: handle lowercase versions of field names.

         const fields = new Map ();

         this .protoFields .set (protoNode, fields);

         for (const { name } of protoNode .getFieldDefinitions ())
         {
            if (reservedAttributes .has (name))
               continue;

            fields .set (name,                 name);
            fields .set (name .toLowerCase (), name);
         }
      };
   })(),
   protoNameToCamelCase (typeName)
   {
      //DOMIntegration: handle uppercase versions of node names.
      return this .protoNames .get (typeName);
   },
   nodeNameToCamelCase (typeName)
   {
      //DOMIntegration: handle uppercase versions of node names.
      return _HTMLSupport_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .getNodeTypeName (typeName);
   },
   attributeToCamelCase (node, name)
   {
      //DOMIntegration: handle lowercase versions of field names.

      if (node instanceof _Components_Core_X3DPrototypeInstance_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A)
         return this .protoFields .get (node .getProtoNode ()) .get (name);

      return _HTMLSupport_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .getFieldName (name);
   },
};

_Base_X3DField_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .prototype .fromXMLString = function (string, scene)
{
   const parser = new XMLParser (scene);

   if (!parser .fieldValue (this, string))
      throw new Error (`Couldn't read value for field '${this .getName ()}'.`);

   parser .setupNodes ();
};

const __default__ = XMLParser;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_14__/* ["default"] */ .A .add ("XMLParser", __default__));

/***/ }),

/***/ 1275:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(2340);
/* harmony import */ var _X3DChildNode_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(5084);
/* harmony import */ var _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(2212);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(717);




let modificationCount = 0;

function X3DBindableNode (executionContext)
{
   _X3DChildNode_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .call (this, executionContext);

   this .addType (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .X3DBindableNode);

   this .modificationCount = 0;
}

Object .assign (Object .setPrototypeOf (X3DBindableNode .prototype, _X3DChildNode_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .prototype),
{
   initialize ()
   {
      _X3DChildNode_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .prototype .initialize .call (this);

      this ._set_bind .addInterest ("set_bind__", this);
   },
   isCameraObject ()
   {
      return true;
   },
   getModificationCount ()
   {
      return this .modificationCount;
   },
   transitionStart ()
   { },
   set_bind__ ()
   {
      if (modificationCount === Number .MAX_SAFE_INTEGER)
         modificationCount = 0;

      this .modificationCount = ++ modificationCount;
   },
});

Object .defineProperties (X3DBindableNode, _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .getStaticProperties ("X3DBindableNode", "Core", 1));

Object .defineProperties (X3DBindableNode,
{
   getModificationCount:
   {
      value ()
      {
         return modificationCount;
      },
      enumerable: false,
   },
});

const __default__ = X3DBindableNode;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .add ("X3DBindableNode", __default__));

/***/ }),

/***/ 1331:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(717);
const functions =
{
   parse (parser)
   {
      this .lastIndex = parser .lastIndex;

      parser .result = this .exec (parser .input);

      if (parser .result)
      {
         parser .lastIndex = this .lastIndex;
         return true;
      }

      return false;
   },
   lookahead (parser)
   {
      const
         lastIndex = parser .lastIndex,
         result    = this .parse (parser);

      parser .lastIndex = lastIndex;

      return result;
   },
};

function Expressions (Grammar)
{
   for (const value of Object .values (Grammar))
      Object .assign (value, functions);

   return Grammar;
}

const __default__ = Expressions;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .add ("Expressions", __default__));

/***/ }),

/***/ 1376:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(2212);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(717);


const
   nodeTypeNames = new Map (), // (TYPENAME -> TypeName)
   fieldNames    = new Map (); // (fieldname -> fieldName)

const HTMLSupport =
{
   addConcreteNode ({ typeName, fieldDefinitions })
   {
      if (nodeTypeNames .has (typeName))
         return;

      this .addNodeTypeName (typeName);

      for (const { name, accessType } of fieldDefinitions)
      {
         if (accessType & _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .initializeOnly)
            this .addFieldName (name)
      }
   },
   addNodeTypeName (typeName)
   {
      nodeTypeNames .set (typeName,                 typeName);
      nodeTypeNames .set (typeName .toUpperCase (), typeName);
   },
   getNodeTypeName (typeName)
   {
      return nodeTypeNames .get (typeName);
   },
   addFieldName (name)
   {
      fieldNames .set (name,                 name);
      fieldNames .set (name .toLowerCase (), name);
   },
   getFieldName (name)
   {
      return fieldNames .get (name);
   },
};

HTMLSupport .addNodeTypeName ("ProtoInstance");

const __default__ = HTMLSupport;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .add ("HTMLSupport", __default__));

/***/ }),

/***/ 1412:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Fields_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(4598);
/* harmony import */ var _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(2340);
/* harmony import */ var _Shape_X3DAppearanceChildNode_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(8692);
/* harmony import */ var _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(2212);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(717);





function X3DTextureNode (executionContext)
{
   _Shape_X3DAppearanceChildNode_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .call (this, executionContext);

   this .addType (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .X3DTextureNode);

   this .addChildObjects (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .outputOnly, "transparent", new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFBool ());
}

Object .assign (Object .setPrototypeOf (X3DTextureNode .prototype, _Shape_X3DAppearanceChildNode_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .prototype),
{
   setTransparent (value)
   {
      if (!!value !== this ._transparent .getValue ())
         this ._transparent = value;
   },
   isTransparent ()
   {
      return this ._transparent .getValue ();
   },
});

Object .defineProperties (X3DTextureNode, _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .getStaticProperties ("X3DTextureNode", "Texturing", 1));

const __default__ = X3DTextureNode;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .add ("X3DTextureNode", __default__));

/***/ }),

/***/ 1428:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _x_ite_Namespace_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(717);
const a = [ ]; // more scratch
const b = [ ]; // more scratch
const z = [ ]; // more scratch

// Calculate eigenvalues and eigenvectors.
// This is from SGI Inventor Matrix.cpp.
function eigen_decomposition (matrix, result)
{
   const
      ORDER   = matrix .order,
      SIZE    = matrix .length,
      values  = result .values,
      vectors = result .vectors;

   let
      sm,         // smallest entry
      theta,      // angle for Jacobi rotation
      c, s, t,    // cosine, sine, tangent of theta
      tau,        // sine / (1 + cos)
      h, g,       // two scrap values
      thresh,     // threshold below which no rotation done
      p, q, i, j; // indices

   // initializations
   for (i = 0; i < ORDER; ++ i)
   {
      a [i] = a [i] ?? [ ];
      b [i] = values [i] = matrix .get1 (i, i);
      z [i] = 0;

      for (j = 0; j < ORDER; ++ j)
      {
         vectors [i] [j] = (i === j) ? 1 : 0;
         a [i] [j] = matrix .get1 (j, i);
      }
   }

   // Why 50? I don't know--it's the way the folks who wrote the
   // algorithm did it:
   for (i = 0; i < 50; ++ i)
   {
      sm = 0;

      for (p = 0; p < ORDER - 1; ++ p)
      {
         for (q = p + 1; q < ORDER; ++ q)
            sm += Math .abs (a [p] [q]);
      }

      if (sm === 0)
         break;

      thresh = i < 3 ?
         0.2 * sm / SIZE :
         0;

      for (p = 0; p < ORDER - 1; ++ p)
      {
         for (q = p + 1; q < ORDER; ++ q)
         {
            g = 100 * Math .abs (a [p] [q]);

            if (i > 3
                && (Math .abs (values [p]) + g === Math .abs (values [p]))
                && (Math .abs (values [q]) + g === Math .abs (values [q]))
            )
            {
               a [p] [q] = 0;
            }

            else if (Math .abs (a [p] [q]) > thresh)
            {
               h = values [q] - values [p];

               if (Math .abs (h) + g === Math .abs (h))
               {
                  t = a [p] [q] / h;
               }
               else
               {
                  theta = 0.5 * h / a [p] [q];
                  t     = 1 / (Math .abs (theta) + Math .sqrt (1 + theta * theta));

                  if (theta < 0)  t = -t;
               }
               // End of computing tangent of rotation angle

               c           = 1 / Math .sqrt (1 + t * t);
               s           = t * c;
               tau         = s / (1 + c);
               h           = t * a [p] [q];
               z [p]      -= h;
               z [q]      += h;
               values [p] -= h;
               values [q] += h;
               a [p] [q]   = 0;

               for (j = 0; j < p; ++ j)
               {
                  g = a [j] [p];
                  h = a [j] [q];
                  a [j] [p] = g - s * (h + g * tau);
                  a [j] [q] = h + s * (g - h * tau);
               }

               for (j = p + 1; j < q; ++ j)
               {
                  g = a [p] [j];
                  h = a [j] [q];
                  a [p] [j] = g - s * (h + g * tau);
                  a [j] [q] = h + s * (g - h * tau);
               }

               for (j = q + 1; j < ORDER; ++ j)
               {
                  g = a [p] [j];
                  h = a [q] [j];
                  a [p] [j] = g - s * (h + g * tau);
                  a [q] [j] = h + s * (g - h * tau);
               }

               for (j = 0; j < ORDER; ++ j)
               {
                  g = vectors [j] [p];
                  h = vectors [j] [q];
                  vectors [j] [p] = g - s * (h + g * tau);
                  vectors [j] [q] = h + s * (g - h * tau);
               }
            }
         }
      }

      for (p = 0; p < ORDER; ++ p)
      {
         values [p] = b [p] += z [p];
         z [p] = 0;
      }
   }

   return result;
}

const __default__ = eigen_decomposition;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_x_ite_Namespace_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .add ("eigen_decomposition", __default__));

/***/ }),

/***/ 1619:
/***/ ((module) => {

/**
 * @license
 * Copyright 2000, Silicon Graphics, Inc. All Rights Reserved.
 * Copyright 2015, Google Inc. All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to
 * deal in the Software without restriction, including without limitation the
 * rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
 * sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice including the dates of first publication and
 * either this permission notice or a reference to http://oss.sgi.com/projects/FreeB/
 * shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * SILICON GRAPHICS, INC. BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR
 * IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 * Original Code. The Original Code is: OpenGL Sample Implementation,
 * Version 1.2.1, released January 26, 2000, developed by Silicon Graphics,
 * Inc. The Original Code is Copyright (c) 1991-2000 Silicon Graphics, Inc.
 * Copyright in any portions created by third parties is as indicated
 * elsewhere herein. All Rights Reserved.
 */
/**
 * @author ericv@cs.stanford.edu (Eric Veach)
 * @author bckenny@google.com (Brendan Kenny)
 */

/**
 * Base namespace.
 * @const
 */
var libtess = {};

/**
 * Whether to run asserts and extra debug checks.
 * @define {boolean}
 */
libtess.DEBUG = false;

/**
 * Checks if the condition evaluates to true if libtess.DEBUG is true.
 * @param {*} condition The condition to check.
 * @param {string=} opt_message Error message in case of failure.
 * @throws {Error} Assertion failed, the condition evaluates to false.
 */
libtess.assert = function(condition, opt_message) {
  if (libtess.DEBUG && !condition) {
    throw new Error('Assertion failed' +
        (opt_message ? ': ' + opt_message : ''));
  }
};

/**
 * The maximum vertex coordinate size, 1e150. Anything larger will trigger a
 * GLU_TESS_COORD_TOO_LARGE error callback and the vertex will be clamped to
 * this value for all tessellation calculations.
 * @const {number}
 */
libtess.GLU_TESS_MAX_COORD = 1e150;
// NOTE(bckenny): value from glu.pl generator

/**
 * Normally the polygon is projected to a plane perpendicular to one of the
 * three coordinate axes before tessellating in 2d. This helps numerical
 * accuracy by forgoing a transformation step by simply dropping one coordinate
 * dimension.
 *
 * However, this can affect the placement of intersection points for non-axis-
 * aligned polygons. Setting TRUE_PROJECT to true will instead project onto a
 * plane actually perpendicular to the polygon's normal.
 *
 * NOTE(bckenny): I can find no instances on the internet in which this mode has
 * been used, but it's difficult to search for. This was a compile-time setting
 * in the original, so setting this as constant. If this is exposed in the
 * public API, remove the ignore coverage directives on
 * libtess.normal.projectPolygon and libtess.normal.normalize_.
 * @const {boolean}
 */
libtess.TRUE_PROJECT = false;

/**
 * The default tolerance for merging features, 0, meaning vertices are only
 * merged if they are exactly coincident
 * If a higher tolerance is needed, significant rewriting will need to occur.
 * See libtess.sweep.TOLERANCE_NONZERO_ as a starting place.
 * @const {number}
 */
libtess.GLU_TESS_DEFAULT_TOLERANCE = 0;

/**
 * The input contours parition the plane into regions. A winding
 * rule determines which of these regions are inside the polygon.
 *
 * For a single contour C, the winding number of a point x is simply
 * the signed number of revolutions we make around x as we travel
 * once around C (where CCW is positive). When there are several
 * contours, the individual winding numbers are summed. This
 * procedure associates a signed integer value with each point x in
 * the plane. Note that the winding number is the same for all
 * points in a single region.
 *
 * The winding rule classifies a region as "inside" if its winding
 * number belongs to the chosen category (odd, nonzero, positive,
 * negative, or absolute value of at least two). The current GLU
 * tesselator implements the "odd" rule. The "nonzero" rule is another
 * common way to define the interior. The other three rules are
 * useful for polygon CSG operations.
 * @enum {number}
 */
libtess.windingRule = {
  // NOTE(bckenny): values from enumglu.spec
  GLU_TESS_WINDING_ODD: 100130,
  GLU_TESS_WINDING_NONZERO: 100131,
  GLU_TESS_WINDING_POSITIVE: 100132,
  GLU_TESS_WINDING_NEGATIVE: 100133,
  GLU_TESS_WINDING_ABS_GEQ_TWO: 100134
};

/**
 * The type of primitive return from a "begin" callback. GL_LINE_LOOP is only
 * returned when GLU_TESS_BOUNDARY_ONLY is true. GL_TRIANGLE_STRIP and
 * GL_TRIANGLE_FAN are no longer returned since 1.1.0 (see release notes).
 * @enum {number}
 */
libtess.primitiveType = {
  GL_LINE_LOOP: 2,
  GL_TRIANGLES: 4,
  GL_TRIANGLE_STRIP: 5,
  GL_TRIANGLE_FAN: 6
};

/**
 * The types of errors provided in the error callback.
 * @enum {number}
 */
libtess.errorType = {
  // TODO(bckenny) doc types
  // NOTE(bckenny): values from enumglu.spec
  GLU_TESS_MISSING_BEGIN_POLYGON: 100151,
  GLU_TESS_MISSING_END_POLYGON: 100153,
  GLU_TESS_MISSING_BEGIN_CONTOUR: 100152,
  GLU_TESS_MISSING_END_CONTOUR: 100154,
  GLU_TESS_COORD_TOO_LARGE: 100155,
  GLU_TESS_NEED_COMBINE_CALLBACK: 100156
};

/**
 * Enum values necessary for providing settings and callbacks. See the readme
 * for details.
 * @enum {number}
 */
libtess.gluEnum = {
  // TODO(bckenny): rename so not always typing libtess.gluEnum.*?

  // NOTE(bckenny): values from enumglu.spec
  GLU_TESS_BEGIN: 100100,
  GLU_TESS_VERTEX: 100101,
  GLU_TESS_END: 100102,
  GLU_TESS_ERROR: 100103,
  GLU_TESS_EDGE_FLAG: 100104,
  GLU_TESS_COMBINE: 100105,
  GLU_TESS_BEGIN_DATA: 100106,
  GLU_TESS_VERTEX_DATA: 100107,
  GLU_TESS_END_DATA: 100108,
  GLU_TESS_ERROR_DATA: 100109,
  GLU_TESS_EDGE_FLAG_DATA: 100110,
  GLU_TESS_COMBINE_DATA: 100111,

  GLU_TESS_MESH: 100112,  //  NOTE(bckenny): from tess.c
  GLU_TESS_TOLERANCE: 100142,
  GLU_TESS_WINDING_RULE: 100140,
  GLU_TESS_BOUNDARY_ONLY: 100141,

  // TODO(bckenny): move this to libtess.errorType?
  GLU_INVALID_ENUM: 100900,
  GLU_INVALID_VALUE: 100901
};

/** @typedef {number} */
libtess.PQHandle;

/* global libtess */

/** @const */
libtess.geom = {};

/**
 * Returns whether vertex u and vertex v are equal.
 * @param {libtess.GluVertex} u
 * @param {libtess.GluVertex} v
 * @return {boolean}
 */
libtess.geom.vertEq = function(u, v) {
  return u.s === v.s && u.t === v.t;
};

/**
 * Returns whether vertex u is lexicographically less than or equal to vertex v.
 * @param {libtess.GluVertex} u
 * @param {libtess.GluVertex} v
 * @return {boolean}
 */
libtess.geom.vertLeq = function(u, v) {
  return (u.s < v.s) || (u.s === v.s && u.t <= v.t);
};

/**
 * Given three vertices u,v,w such that geom.vertLeq(u,v) && geom.vertLeq(v,w),
 * evaluates the t-coord of the edge uw at the s-coord of the vertex v.
 * Returns v.t - (uw)(v.s), ie. the signed distance from uw to v.
 * If uw is vertical (and thus passes thru v), the result is zero.
 *
 * The calculation is extremely accurate and stable, even when v
 * is very close to u or w.  In particular if we set v.t = 0 and
 * let r be the negated result (this evaluates (uw)(v.s)), then
 * r is guaranteed to satisfy MIN(u.t,w.t) <= r <= MAX(u.t,w.t).
 * @param {libtess.GluVertex} u
 * @param {libtess.GluVertex} v
 * @param {libtess.GluVertex} w
 * @return {number}
 */
libtess.geom.edgeEval = function(u, v, w) {

  var gapL = v.s - u.s;
  var gapR = w.s - v.s;

  if (gapL + gapR > 0) {
    if (gapL < gapR) {
      return (v.t - u.t) + (u.t - w.t) * (gapL / (gapL + gapR));
    } else {
      return (v.t - w.t) + (w.t - u.t) * (gapR / (gapL + gapR));
    }
  }

  // vertical line
  return 0;
};

/**
 * Returns a number whose sign matches geom.edgeEval(u,v,w) but which
 * is cheaper to evaluate.  Returns > 0, == 0 , or < 0
 * as v is above, on, or below the edge uw.
 * @param {libtess.GluVertex} u
 * @param {libtess.GluVertex} v
 * @param {libtess.GluVertex} w
 * @return {number}
 */
libtess.geom.edgeSign = function(u, v, w) {

  var gapL = v.s - u.s;
  var gapR = w.s - v.s;

  if (gapL + gapR > 0) {
    return (v.t - w.t) * gapL + (v.t - u.t) * gapR;
  }

  // vertical line
  return 0;
};

/**
 * Version of VertLeq with s and t transposed.
 * Returns whether vertex u is lexicographically less than or equal to vertex v.
 * @param {libtess.GluVertex} u
 * @param {libtess.GluVertex} v
 * @return {boolean}
 */
libtess.geom.transLeq = function(u, v) {
  return (u.t < v.t) || (u.t === v.t && u.s <= v.s);
};

/**
 * Version of geom.edgeEval with s and t transposed.
 * Given three vertices u,v,w such that geom.transLeq(u,v) &&
 * geom.transLeq(v,w), evaluates the t-coord of the edge uw at the s-coord of
 * the vertex v. Returns v.s - (uw)(v.t), ie. the signed distance from uw to v.
 * If uw is vertical (and thus passes thru v), the result is zero.
 *
 * The calculation is extremely accurate and stable, even when v
 * is very close to u or w.  In particular if we set v.s = 0 and
 * let r be the negated result (this evaluates (uw)(v.t)), then
 * r is guaranteed to satisfy MIN(u.s,w.s) <= r <= MAX(u.s,w.s).
 * @param {libtess.GluVertex} u
 * @param {libtess.GluVertex} v
 * @param {libtess.GluVertex} w
 * @return {number}
 */
libtess.geom.transEval = function(u, v, w) {

  var gapL = v.t - u.t;
  var gapR = w.t - v.t;

  if (gapL + gapR > 0) {
    if (gapL < gapR) {
      return (v.s - u.s) + (u.s - w.s) * (gapL / (gapL + gapR));
    } else {
      return (v.s - w.s) + (w.s - u.s) * (gapR / (gapL + gapR));
    }
  }

  // vertical line
  return 0;
};

/**
 * Version of geom.edgeSign with s and t transposed.
 * Returns a number whose sign matches geom.transEval(u,v,w) but which
 * is cheaper to evaluate.  Returns > 0, == 0 , or < 0
 * as v is above, on, or below the edge uw.
 * @param {libtess.GluVertex} u
 * @param {libtess.GluVertex} v
 * @param {libtess.GluVertex} w
 * @return {number}
 */
libtess.geom.transSign = function(u, v, w) {

  var gapL = v.t - u.t;
  var gapR = w.t - v.t;

  if (gapL + gapR > 0) {
    return (v.s - w.s) * gapL + (v.s - u.s) * gapR;
  }

  // vertical line
  return 0;
};

/**
 * Returns whether edge is directed from right to left.
 * @param {libtess.GluHalfEdge} e
 * @return {boolean}
 */
libtess.geom.edgeGoesLeft = function(e) {
  return libtess.geom.vertLeq(e.dst(), e.org);
};

/**
 * Returns whether edge is directed from left to right.
 * @param {libtess.GluHalfEdge} e
 * @return {boolean}
 */
libtess.geom.edgeGoesRight = function(e) {
  return libtess.geom.vertLeq(e.org, e.dst());
};

/**
 * Calculates the L1 distance between vertices u and v.
 * @param {libtess.GluVertex} u
 * @param {libtess.GluVertex} v
 * @return {number}
 */
libtess.geom.vertL1dist = function(u, v) {
  return Math.abs(u.s - v.s) + Math.abs(u.t - v.t);
};

// NOTE(bckenny): vertCCW is called nowhere in libtess and isn't part of the
// public API.
/* istanbul ignore next */
/**
 * For almost-degenerate situations, the results are not reliable.
 * Unless the floating-point arithmetic can be performed without
 * rounding errors, *any* implementation will give incorrect results
 * on some degenerate inputs, so the client must have some way to
 * handle this situation.
 * @param {!libtess.GluVertex} u
 * @param {!libtess.GluVertex} v
 * @param {!libtess.GluVertex} w
 * @return {boolean}
 */
libtess.geom.vertCCW = function(u, v, w) {
  return (u.s * (v.t - w.t) + v.s * (w.t - u.t) + w.s * (u.t - v.t)) >= 0;
};

/**
 * Given parameters a,x,b,y returns the value (b*x+a*y)/(a+b),
 * or (x+y)/2 if a==b==0. It requires that a,b >= 0, and enforces
 * this in the rare case that one argument is slightly negative.
 * The implementation is extremely stable numerically.
 * In particular it guarantees that the result r satisfies
 * MIN(x,y) <= r <= MAX(x,y), and the results are very accurate
 * even when a and b differ greatly in magnitude.
 * @private
 * @param {number} a
 * @param {number} x
 * @param {number} b
 * @param {number} y
 * @return {number}
 */
libtess.geom.interpolate_ = function(a, x, b, y) {
  // from Macro RealInterpolate:
  //(a = (a < 0) ? 0 : a, b = (b < 0) ? 0 : b, ((a <= b) ? ((b == 0) ? ((x+y) / 2) : (x + (y-x) * (a/(a+b)))) : (y + (x-y) * (b/(a+b)))))
  a = (a < 0) ? 0 : a;
  b = (b < 0) ? 0 : b;

  if (a <= b) {
    if (b === 0) {
      return (x + y) / 2;
    } else {
      return x + (y - x) * (a / (a + b));
    }
  } else {
    return y + (x - y) * (b / (a + b));
  }
};

/**
 * Given edges (o1,d1) and (o2,d2), compute their point of intersection.
 * The computed point is guaranteed to lie in the intersection of the
 * bounding rectangles defined by each edge.
 * @param {!libtess.GluVertex} o1
 * @param {!libtess.GluVertex} d1
 * @param {!libtess.GluVertex} o2
 * @param {!libtess.GluVertex} d2
 * @param {!libtess.GluVertex} v
 */
libtess.geom.edgeIntersect = function(o1, d1, o2, d2, v) {
  // This is certainly not the most efficient way to find the intersection
  // of two line segments, but it is very numerically stable.

  // Strategy: find the two middle vertices in the VertLeq ordering,
  // and interpolate the intersection s-value from these. Then repeat
  // using the TransLeq ordering to find the intersection t-value.
  var z1;
  var z2;
  var tmp;
  if (!libtess.geom.vertLeq(o1, d1)) {
    // Swap(o1, d1);
    tmp = o1;
    o1 = d1;
    d1 = tmp;
  }
  if (!libtess.geom.vertLeq(o2, d2)) {
    // Swap(o2, d2);
    tmp = o2;
    o2 = d2;
    d2 = tmp;
  }
  if (!libtess.geom.vertLeq(o1, o2)) {
    // Swap(o1, o2);
    tmp = o1;
    o1 = o2;
    o2 = tmp;
    // Swap(d1, d2);
    tmp = d1;
    d1 = d2;
    d2 = tmp;
  }

  if (!libtess.geom.vertLeq(o2, d1)) {
    // Technically, no intersection -- do our best
    v.s = (o2.s + d1.s) / 2;

  } else if (libtess.geom.vertLeq(d1, d2)) {
    // Interpolate between o2 and d1
    z1 = libtess.geom.edgeEval(o1, o2, d1);
    z2 = libtess.geom.edgeEval(o2, d1, d2);
    if (z1 + z2 < 0) { z1 = -z1; z2 = -z2; }
    v.s = libtess.geom.interpolate_(z1, o2.s, z2, d1.s);

  } else {
    // Interpolate between o2 and d2
    z1 = libtess.geom.edgeSign(o1, o2, d1);
    z2 = -libtess.geom.edgeSign(o1, d2, d1);
    if (z1 + z2 < 0) { z1 = -z1; z2 = -z2; }
    v.s = libtess.geom.interpolate_(z1, o2.s, z2, d2.s);
  }

  // Now repeat the process for t
  if (!libtess.geom.transLeq(o1, d1)) {
    // Swap(o1, d1);
    tmp = o1;
    o1 = d1;
    d1 = tmp;
  }
  if (!libtess.geom.transLeq(o2, d2)) {
    // Swap(o2, d2);
    tmp = o2;
    o2 = d2;
    d2 = tmp;
  }
  if (!libtess.geom.transLeq(o1, o2)) {
    // Swap(o1, o2);
    tmp = o1;
    o1 = o2;
    o2 = tmp;
    // Swap(d1, d2);
    tmp = d1;
    d1 = d2;
    d2 = tmp;
  }

  if (!libtess.geom.transLeq(o2, d1)) {
    // Technically, no intersection -- do our best
    v.t = (o2.t + d1.t) / 2;

  } else if (libtess.geom.transLeq(d1, d2)) {
    // Interpolate between o2 and d1
    z1 = libtess.geom.transEval(o1, o2, d1);
    z2 = libtess.geom.transEval(o2, d1, d2);
    if (z1 + z2 < 0) { z1 = -z1; z2 = -z2; }
    v.t = libtess.geom.interpolate_(z1, o2.t, z2, d1.t);

  } else {
    // Interpolate between o2 and d2
    z1 = libtess.geom.transSign(o1, o2, d1);
    z2 = -libtess.geom.transSign(o1, d2, d1);
    if (z1 + z2 < 0) { z1 = -z1; z2 = -z2; }
    v.t = libtess.geom.interpolate_(z1, o2.t, z2, d2.t);
  }
};

/* global libtess */

// TODO(bckenny): could maybe merge GluMesh and mesh.js since these are
// operations on the mesh

/** @const */
libtess.mesh = {};

/****************** Basic Edge Operations **********************/


/**
 * makeEdge creates one edge, two vertices, and a loop (face).
 * The loop consists of the two new half-edges.
 *
 * @param {libtess.GluMesh} mesh [description].
 * @return {libtess.GluHalfEdge} [description].
 */
libtess.mesh.makeEdge = function(mesh) {
  // TODO(bckenny): probably move to GluMesh, but needs Make* methods with it

  var e = libtess.mesh.makeEdgePair_(mesh.eHead);

  // complete edge with vertices and face (see mesh.makeEdgePair_)
  libtess.mesh.makeVertex_(e, mesh.vHead);
  libtess.mesh.makeVertex_(e.sym, mesh.vHead);
  libtess.mesh.makeFace_(e, mesh.fHead);

  return e;
};


/**
 * meshSplice(eOrg, eDst) is the basic operation for changing the
 * mesh connectivity and topology. It changes the mesh so that
 *  eOrg.oNext <- OLD( eDst.oNext )
 *  eDst.oNext <- OLD( eOrg.oNext )
 * where OLD(...) means the value before the meshSplice operation.
 *
 * This can have two effects on the vertex structure:
 *  - if eOrg.org != eDst.org, the two vertices are merged together
 *  - if eOrg.org == eDst.org, the origin is split into two vertices
 * In both cases, eDst.org is changed and eOrg.org is untouched.
 *
 * Similarly (and independently) for the face structure,
 *  - if eOrg.lFace == eDst.lFace, one loop is split into two
 *  - if eOrg.lFace != eDst.lFace, two distinct loops are joined into one
 * In both cases, eDst.lFace is changed and eOrg.lFace is unaffected.
 *
 * Some special cases:
 * If eDst == eOrg, the operation has no effect.
 * If eDst == eOrg.lNext, the new face will have a single edge.
 * If eDst == eOrg.lPrev(), the old face will have a single edge.
 * If eDst == eOrg.oNext, the new vertex will have a single edge.
 * If eDst == eOrg.oPrev(), the old vertex will have a single edge.
 *
 * @param {libtess.GluHalfEdge} eOrg [description].
 * @param {libtess.GluHalfEdge} eDst [description].
 */
libtess.mesh.meshSplice = function(eOrg, eDst) {
  // TODO: more descriptive name?

  var joiningLoops = false;
  var joiningVertices = false;

  if (eOrg === eDst) {
    return;
  }

  if (eDst.org !== eOrg.org) {
    // We are merging two disjoint vertices -- destroy eDst.org
    joiningVertices = true;
    libtess.mesh.killVertex_(eDst.org, eOrg.org);
  }

  if (eDst.lFace !== eOrg.lFace) {
    // We are connecting two disjoint loops -- destroy eDst.lFace
    joiningLoops = true;
    libtess.mesh.killFace_(eDst.lFace, eOrg.lFace);
  }

  // Change the edge structure
  libtess.mesh.splice_(eDst, eOrg);

  if (!joiningVertices) {
    // We split one vertex into two -- the new vertex is eDst.org.
    // Make sure the old vertex points to a valid half-edge.
    libtess.mesh.makeVertex_(eDst, eOrg.org);
    eOrg.org.anEdge = eOrg;
  }

  if (!joiningLoops) {
    // We split one loop into two -- the new loop is eDst.lFace.
    // Make sure the old face points to a valid half-edge.
    libtess.mesh.makeFace_(eDst, eOrg.lFace);
    eOrg.lFace.anEdge = eOrg;
  }
};


/**
 * deleteEdge(eDel) removes the edge eDel. There are several cases:
 * if (eDel.lFace != eDel.rFace()), we join two loops into one; the loop
 * eDel.lFace is deleted. Otherwise, we are splitting one loop into two;
 * the newly created loop will contain eDel.dst(). If the deletion of eDel
 * would create isolated vertices, those are deleted as well.
 *
 * This function could be implemented as two calls to __gl_meshSplice
 * plus a few calls to memFree, but this would allocate and delete
 * unnecessary vertices and faces.
 *
 * @param {libtess.GluHalfEdge} eDel [description].
 */
libtess.mesh.deleteEdge = function(eDel) {
  var eDelSym = eDel.sym;
  var joiningLoops = false;

  // First step: disconnect the origin vertex eDel.org.  We make all
  // changes to get a consistent mesh in this "intermediate" state.
  if (eDel.lFace !== eDel.rFace()) {
    // We are joining two loops into one -- remove the left face
    joiningLoops = true;
    libtess.mesh.killFace_(eDel.lFace, eDel.rFace());
  }

  if (eDel.oNext === eDel) {
    libtess.mesh.killVertex_(eDel.org, null);

  } else {
    // Make sure that eDel.org and eDel.rFace() point to valid half-edges
    eDel.rFace().anEdge = eDel.oPrev();
    eDel.org.anEdge = eDel.oNext;

    libtess.mesh.splice_(eDel, eDel.oPrev());

    if (!joiningLoops) {
      // We are splitting one loop into two -- create a new loop for eDel.
      libtess.mesh.makeFace_(eDel, eDel.lFace);
    }
  }

  // Claim: the mesh is now in a consistent state, except that eDel.org
  // may have been deleted.  Now we disconnect eDel.dst().
  if (eDelSym.oNext === eDelSym) {
    libtess.mesh.killVertex_(eDelSym.org, null);
    libtess.mesh.killFace_(eDelSym.lFace, null);

  } else {
    // Make sure that eDel.dst() and eDel.lFace point to valid half-edges
    eDel.lFace.anEdge = eDelSym.oPrev();
    eDelSym.org.anEdge = eDelSym.oNext;
    libtess.mesh.splice_(eDelSym, eDelSym.oPrev());
  }

  // Any isolated vertices or faces have already been freed.
  libtess.mesh.killEdge_(eDel);
};

/******************** Other Edge Operations **********************/

/* All these routines can be implemented with the basic edge
 * operations above.  They are provided for convenience and efficiency.
 */


/**
 * addEdgeVertex(eOrg) creates a new edge eNew such that
 * eNew == eOrg.lNext, and eNew.dst() is a newly created vertex.
 * eOrg and eNew will have the same left face.
 *
 * @param {libtess.GluHalfEdge} eOrg [description].
 * @return {libtess.GluHalfEdge} [description].
 */
libtess.mesh.addEdgeVertex = function(eOrg) {
  // TODO(bckenny): why is it named this?

  var eNew = libtess.mesh.makeEdgePair_(eOrg);
  var eNewSym = eNew.sym;

  // Connect the new edge appropriately
  libtess.mesh.splice_(eNew, eOrg.lNext);

  // Set the vertex and face information
  eNew.org = eOrg.dst();

  libtess.mesh.makeVertex_(eNewSym, eNew.org);

  eNew.lFace = eNewSym.lFace = eOrg.lFace;

  return eNew;
};


/**
 * splitEdge(eOrg) splits eOrg into two edges eOrg and eNew,
 * such that eNew == eOrg.lNext. The new vertex is eOrg.dst() == eNew.org.
 * eOrg and eNew will have the same left face.
 *
 * @param {libtess.GluHalfEdge} eOrg [description].
 * @return {!libtess.GluHalfEdge} [description].
 */
libtess.mesh.splitEdge = function(eOrg) {
  var tempHalfEdge = libtess.mesh.addEdgeVertex(eOrg);
  var eNew = tempHalfEdge.sym;

  // Disconnect eOrg from eOrg.dst() and connect it to eNew.org
  libtess.mesh.splice_(eOrg.sym, eOrg.sym.oPrev());
  libtess.mesh.splice_(eOrg.sym, eNew);

  // Set the vertex and face information
  eOrg.sym.org = eNew.org; // NOTE(bckenny): assignment to dst
  eNew.dst().anEdge = eNew.sym;  // may have pointed to eOrg.sym
  eNew.sym.lFace = eOrg.rFace(); // NOTE(bckenny): assignment to rFace
  eNew.winding = eOrg.winding;  // copy old winding information
  eNew.sym.winding = eOrg.sym.winding;

  return eNew;
};


/**
 * connect(eOrg, eDst) creates a new edge from eOrg.dst()
 * to eDst.org, and returns the corresponding half-edge eNew.
 * If eOrg.lFace == eDst.lFace, this splits one loop into two,
 * and the newly created loop is eNew.lFace. Otherwise, two disjoint
 * loops are merged into one, and the loop eDst.lFace is destroyed.
 *
 * If (eOrg == eDst), the new face will have only two edges.
 * If (eOrg.lNext == eDst), the old face is reduced to a single edge.
 * If (eOrg.lNext.lNext == eDst), the old face is reduced to two edges.
 *
 * @param {libtess.GluHalfEdge} eOrg [description].
 * @param {libtess.GluHalfEdge} eDst [description].
 * @return {!libtess.GluHalfEdge} [description].
 */
libtess.mesh.connect = function(eOrg, eDst) {
  var joiningLoops = false;
  var eNew = libtess.mesh.makeEdgePair_(eOrg);
  var eNewSym = eNew.sym;

  if (eDst.lFace !== eOrg.lFace) {
    // We are connecting two disjoint loops -- destroy eDst.lFace
    joiningLoops = true;
    libtess.mesh.killFace_(eDst.lFace, eOrg.lFace);
  }

  // Connect the new edge appropriately
  libtess.mesh.splice_(eNew, eOrg.lNext);
  libtess.mesh.splice_(eNewSym, eDst);

  // Set the vertex and face information
  eNew.org = eOrg.dst();
  eNewSym.org = eDst.org;
  eNew.lFace = eNewSym.lFace = eOrg.lFace;

  // Make sure the old face points to a valid half-edge
  eOrg.lFace.anEdge = eNewSym;

  if (!joiningLoops) {
    // We split one loop into two -- the new loop is eNew.lFace
    libtess.mesh.makeFace_(eNew, eOrg.lFace);
  }
  return eNew;
};

/******************** Other Operations **********************/


/**
 * zapFace(fZap) destroys a face and removes it from the
 * global face list. All edges of fZap will have a null pointer as their
 * left face. Any edges which also have a null pointer as their right face
 * are deleted entirely (along with any isolated vertices this produces).
 * An entire mesh can be deleted by zapping its faces, one at a time,
 * in any order. Zapped faces cannot be used in further mesh operations!
 *
 * @param {libtess.GluFace} fZap [description].
 */
libtess.mesh.zapFace = function(fZap) {
  var eStart = fZap.anEdge;

  // walk around face, deleting edges whose right face is also NULL
  var eNext = eStart.lNext;
  var e;
  do {
    e = eNext;
    eNext = e.lNext;

    e.lFace = null;
    if (e.rFace() === null) {
      // delete the edge -- see mesh.deleteEdge above
      if (e.oNext === e) {
        libtess.mesh.killVertex_(e.org, null);

      } else {
        // Make sure that e.org points to a valid half-edge
        e.org.anEdge = e.oNext;
        libtess.mesh.splice_(e, e.oPrev());
      }

      var eSym = e.sym;

      if (eSym.oNext === eSym) {
        libtess.mesh.killVertex_(eSym.org, null);

      } else {
        // Make sure that eSym.org points to a valid half-edge
        eSym.org.anEdge = eSym.oNext;
        libtess.mesh.splice_(eSym, eSym.oPrev());
      }
      libtess.mesh.killEdge_(e);
    }
  } while (e !== eStart);

  // delete from circular doubly-linked list
  var fPrev = fZap.prev;
  var fNext = fZap.next;
  fNext.prev = fPrev;
  fPrev.next = fNext;

  // TODO(bckenny): memFree( fZap );
  // TODO(bckenny): probably null at callsite
};

// TODO(bckenny): meshUnion isn't called within libtess and isn't part of the
// public API. Could be useful if more mesh manipulation functions are exposed.
/* istanbul ignore next */
/**
 * meshUnion() forms the union of all structures in
 * both meshes, and returns the new mesh (the old meshes are destroyed).
 *
 * @param {!libtess.GluMesh} mesh1
 * @param {!libtess.GluMesh} mesh2
 * @return {!libtess.GluMesh}
 */
libtess.mesh.meshUnion = function(mesh1, mesh2) {
  // TODO(bceknny): probably move to GluMesh method
  var f1 = mesh1.fHead;
  var v1 = mesh1.vHead;
  var e1 = mesh1.eHead;

  var f2 = mesh2.fHead;
  var v2 = mesh2.vHead;
  var e2 = mesh2.eHead;

  // Add the faces, vertices, and edges of mesh2 to those of mesh1
  if (f2.next !== f2) {
    f1.prev.next = f2.next;
    f2.next.prev = f1.prev;
    f2.prev.next = f1;
    f1.prev = f2.prev;
  }

  if (v2.next !== v2) {
    v1.prev.next = v2.next;
    v2.next.prev = v1.prev;
    v2.prev.next = v1;
    v1.prev = v2.prev;
  }

  if (e2.next !== e2) {
    e1.sym.next.sym.next = e2.next;
    e2.next.sym.next = e1.sym.next;
    e2.sym.next.sym.next = e1;
    e1.sym.next = e2.sym.next;
  }

  // TODO(bckenny): memFree(mesh2);
  // TODO(bckenny): If function is kept, remove mesh2's data to enforce.
  return mesh1;
};


/**
 * deleteMesh(mesh) will free all storage for any valid mesh.
 * @param {libtess.GluMesh} mesh [description].
 */
libtess.mesh.deleteMesh = function(mesh) {
  // TODO(bckenny): unnecessary, I think.
  // TODO(bckenny): might want to explicitly null at callsite
  // lots of memFrees. see also DELETE_BY_ZAPPING
};

/************************ Utility Routines ************************/


/**
 * Creates a new pair of half-edges which form their own loop.
 * No vertex or face structures are allocated, but these must be assigned
 * before the current edge operation is completed.
 *
 * TODO(bckenny): warning about eNext strictly being first of pair? (see code)
 *
 * @private
 * @param {libtess.GluHalfEdge} eNext [description].
 * @return {libtess.GluHalfEdge} [description].
 */
libtess.mesh.makeEdgePair_ = function(eNext) {
  var e = new libtess.GluHalfEdge();
  var eSym = new libtess.GluHalfEdge();

  // TODO(bckenny): how do we ensure this? see above comment in jsdoc
  // Make sure eNext points to the first edge of the edge pair
  // if (eNext->Sym < eNext ) { eNext = eNext->Sym; }

  // NOTE(bckenny): check this for bugs in current implementation!

  // Insert in circular doubly-linked list before eNext.
  // Note that the prev pointer is stored in sym.next.
  var ePrev = eNext.sym.next;
  eSym.next = ePrev;
  ePrev.sym.next = e;
  e.next = eNext;
  eNext.sym.next = eSym;

  e.sym = eSym;
  e.oNext = e;
  e.lNext = eSym;

  eSym.sym = e;
  eSym.oNext = eSym;
  eSym.lNext = e;

  return e;
};


/**
 * splice_ is best described by the Guibas/Stolfi paper or the
 * CS348a notes. Basically, it modifies the mesh so that
 * a.oNext and b.oNext are exchanged. This can have various effects
 * depending on whether a and b belong to different face or vertex rings.
 * For more explanation see mesh.meshSplice below.
 *
 * @private
 * @param {libtess.GluHalfEdge} a [description].
 * @param {libtess.GluHalfEdge} b [description].
 */
libtess.mesh.splice_ = function(a, b) {
  var aONext = a.oNext;
  var bONext = b.oNext;

  aONext.sym.lNext = b;
  bONext.sym.lNext = a;
  a.oNext = bONext;
  b.oNext = aONext;
};


/**
 * makeVertex_(eOrig, vNext) attaches a new vertex and makes it the
 * origin of all edges in the vertex loop to which eOrig belongs. "vNext" gives
 * a place to insert the new vertex in the global vertex list.  We insert
 * the new vertex *before* vNext so that algorithms which walk the vertex
 * list will not see the newly created vertices.
 *
 * NOTE: unlike original, acutally allocates new vertex.
 *
 * @private
 * @param {libtess.GluHalfEdge} eOrig [description].
 * @param {libtess.GluVertex} vNext [description].
 */
libtess.mesh.makeVertex_ = function(eOrig, vNext) {
  // insert in circular doubly-linked list before vNext
  var vPrev = vNext.prev;
  var vNew = new libtess.GluVertex(vNext, vPrev);
  vPrev.next = vNew;
  vNext.prev = vNew;

  vNew.anEdge = eOrig;
  // leave coords, s, t undefined
  // TODO(bckenny): does above line mean 0 specifically, or does it matter?

  // fix other edges on this vertex loop
  var e = eOrig;
  do {
    e.org = vNew;
    e = e.oNext;
  } while (e !== eOrig);
};


/**
 * makeFace_(eOrig, fNext) attaches a new face and makes it the left
 * face of all edges in the face loop to which eOrig belongs. "fNext" gives
 * a place to insert the new face in the global face list.  We insert
 * the new face *before* fNext so that algorithms which walk the face
 * list will not see the newly created faces.
 *
 * NOTE: unlike original, acutally allocates new face.
 *
 * @private
 * @param {libtess.GluHalfEdge} eOrig [description].
 * @param {libtess.GluFace} fNext [description].
 */
libtess.mesh.makeFace_ = function(eOrig, fNext) {
  // insert in circular doubly-linked list before fNext
  var fPrev = fNext.prev;
  var fNew = new libtess.GluFace(fNext, fPrev);
  fPrev.next = fNew;
  fNext.prev = fNew;

  fNew.anEdge = eOrig;

  // The new face is marked "inside" if the old one was.  This is a
  // convenience for the common case where a face has been split in two.
  fNew.inside = fNext.inside;

  // fix other edges on this face loop
  var e = eOrig;
  do {
    e.lFace = fNew;
    e = e.lNext;
  } while (e !== eOrig);
};


/**
 * killEdge_ destroys an edge (the half-edges eDel and eDel.sym),
 * and removes from the global edge list.
 *
 * @private
 * @param {libtess.GluHalfEdge} eDel [description].
 */
libtess.mesh.killEdge_ = function(eDel) {
  // TODO(bckenny): in this case, no need to worry(?), but check when checking mesh.makeEdgePair_
  // Half-edges are allocated in pairs, see EdgePair above
  // if (eDel->Sym < eDel ) { eDel = eDel->Sym; }

  // delete from circular doubly-linked list
  var eNext = eDel.next;
  var ePrev = eDel.sym.next;
  eNext.sym.next = ePrev;
  ePrev.sym.next = eNext;

  // TODO(bckenny): memFree( eDel ); (which also frees eDel.sym)
  // TODO(bckenny): need to null at callsites?
};


/**
 * killVertex_ destroys a vertex and removes it from the global
 * vertex list. It updates the vertex loop to point to a given new vertex.
 *
 * @private
 * @param {libtess.GluVertex} vDel [description].
 * @param {libtess.GluVertex} newOrg [description].
 */
libtess.mesh.killVertex_ = function(vDel, newOrg) {
  var eStart = vDel.anEdge;

  // change the origin of all affected edges
  var e = eStart;
  do {
    e.org = newOrg;
    e = e.oNext;
  } while (e !== eStart);

  // delete from circular doubly-linked list
  var vPrev = vDel.prev;
  var vNext = vDel.next;
  vNext.prev = vPrev;
  vPrev.next = vNext;

  // TODO(bckenny): memFree( vDel );
  // TODO(bckenny): need to null at callsites?
};


/**
 * killFace_ destroys a face and removes it from the global face
 * list. It updates the face loop to point to a given new face.
 *
 * @private
 * @param {libtess.GluFace} fDel [description].
 * @param {libtess.GluFace} newLFace [description].
 */
libtess.mesh.killFace_ = function(fDel, newLFace) {
  var eStart = fDel.anEdge;

  // change the left face of all affected edges
  var e = eStart;
  do {
    e.lFace = newLFace;
    e = e.lNext;
  } while (e !== eStart);

  // delete from circular doubly-linked list
  var fPrev = fDel.prev;
  var fNext = fDel.next;
  fNext.prev = fPrev;
  fPrev.next = fNext;

  // TODO(bckenny): memFree( fDel );
  // TODO(bckenny): need to null at callsites?
};

/* global libtess */

/** @const */
libtess.normal = {};

// TODO(bckenny): Integrate SLANTED_SWEEP somehow?
/* The "feature merging" is not intended to be complete. There are
 * special cases where edges are nearly parallel to the sweep line
 * which are not implemented. The algorithm should still behave
 * robustly (ie. produce a reasonable tesselation) in the presence
 * of such edges, however it may miss features which could have been
 * merged. We could minimize this effect by choosing the sweep line
 * direction to be something unusual (ie. not parallel to one of the
 * coordinate axes).
 * #if defined(SLANTED_SWEEP)
 * #define S_UNIT_X  0.50941539564955385 // Pre-normalized
 * #define S_UNIT_Y  0.86052074622010633
 * #endif
 */

/**
 * X coordinate of local basis for polygon projection.
 * @private {number}
 * @const
 */
libtess.normal.S_UNIT_X_ = 1.0;

/**
 * Y coordinate of local basis for polygon projection.
 * @private {number}
 * @const
 */
libtess.normal.S_UNIT_Y_ = 0.0;

/**
 * Determines a polygon normal and projects vertices onto the plane of the
 * polygon. A pre-computed normal for the data may be provided, or set to the
 * zero vector if one should be computed from it.
 * @param {!libtess.GluTesselator} tess
 * @param {number} normalX
 * @param {number} normalY
 * @param {number} normalZ
 */
libtess.normal.projectPolygon = function(tess, normalX, normalY, normalZ) {
  var computedNormal = false;

  var norm = [
    normalX,
    normalY,
    normalZ
  ];
  if (normalX === 0 && normalY === 0 && normalZ === 0) {
    libtess.normal.computeNormal_(tess, norm);
    computedNormal = true;
  }

  var i = libtess.normal.longAxis_(norm);
  var vHead = tess.mesh.vHead;
  var v;

  // NOTE(bckenny): This branch is never taken. See comment on
  // libtess.TRUE_PROJECT.
  /* istanbul ignore if */
  if (libtess.TRUE_PROJECT) {
    // Choose the initial sUnit vector to be approximately perpendicular
    // to the normal.
    libtess.normal.normalize_(norm);

    var sUnit = [0, 0, 0];
    var tUnit = [0, 0, 0];

    sUnit[i] = 0;
    sUnit[(i + 1) % 3] = libtess.normal.S_UNIT_X_;
    sUnit[(i + 2) % 3] = libtess.normal.S_UNIT_Y_;

    // Now make it exactly perpendicular
    var w = libtess.normal.dot_(sUnit, norm);
    sUnit[0] -= w * norm[0];
    sUnit[1] -= w * norm[1];
    sUnit[2] -= w * norm[2];
    libtess.normal.normalize_(sUnit);

    // Choose tUnit so that (sUnit,tUnit,norm) form a right-handed frame
    tUnit[0] = norm[1] * sUnit[2] - norm[2] * sUnit[1];
    tUnit[1] = norm[2] * sUnit[0] - norm[0] * sUnit[2];
    tUnit[2] = norm[0] * sUnit[1] - norm[1] * sUnit[0];
    libtess.normal.normalize_(tUnit);

    // Project the vertices onto the sweep plane
    for (v = vHead.next; v !== vHead; v = v.next) {
      v.s = libtess.normal.dot_(v.coords, sUnit);
      v.t = libtess.normal.dot_(v.coords, tUnit);
    }

  } else {
    // Project perpendicular to a coordinate axis -- better numerically
    var sAxis = (i + 1) % 3;
    var tAxis = (i + 2) % 3;
    var tNegate = norm[i] > 0 ? 1 : -1;

    // Project the vertices onto the sweep plane
    for (v = vHead.next; v !== vHead; v = v.next) {
      v.s = v.coords[sAxis];
      v.t = tNegate * v.coords[tAxis];
    }
  }

  if (computedNormal) {
    libtess.normal.checkOrientation_(tess);
  }
};

// NOTE(bckenny): libtess.normal.dot_ is no longer called in code without
// libtess.TRUE_PROJECT defined.
/* istanbul ignore next */
/**
 * Computes the dot product of vectors u and v.
 * @private
 * @param {!Array<number>} u
 * @param {!Array<number>} v
 * @return {number}
 */
libtess.normal.dot_ = function(u, v) {
  return u[0] * v[0] + u[1] * v[1] + u[2] * v[2];
};

// NOTE(bckenny): only called from within libtess.normal.projectPolygon's
// TRUE_PROJECT branch, so ignoring for code coverage.
/* istanbul ignore next */
/**
 * Normalize vector v.
 * @private
 * @param {!Array<number>} v
 */
libtess.normal.normalize_ = function(v) {
  var len = v[0] * v[0] + v[1] * v[1] + v[2] * v[2];

  len = Math.sqrt(len);
  v[0] /= len;
  v[1] /= len;
  v[2] /= len;
};

/**
 * Returns the index of the longest component of vector v.
 * @private
 * @param {!Array<number>} v
 * @return {number}
 */
libtess.normal.longAxis_ = function(v) {
  var i = 0;

  if (Math.abs(v[1]) > Math.abs(v[0])) {
    i = 1;
  }
  if (Math.abs(v[2]) > Math.abs(v[i])) {
    i = 2;
  }

  return i;
};

/**
 * Compute an approximate normal of the polygon from the vertices themselves.
 * Result returned in norm.
 * @private
 * @param {!libtess.GluTesselator} tess
 * @param {!Array<number>} norm
 */
libtess.normal.computeNormal_ = function(tess, norm) {
  var maxVal = [
    -2 * libtess.GLU_TESS_MAX_COORD,
    -2 * libtess.GLU_TESS_MAX_COORD,
    -2 * libtess.GLU_TESS_MAX_COORD
  ];
  var minVal = [
    2 * libtess.GLU_TESS_MAX_COORD,
    2 * libtess.GLU_TESS_MAX_COORD,
    2 * libtess.GLU_TESS_MAX_COORD
  ];
  var maxVert = [];
  var minVert = [];

  var v;
  var vHead = tess.mesh.vHead;
  for (v = vHead.next; v !== vHead; v = v.next) {
    for (var i = 0; i < 3; ++i) {
      var c = v.coords[i];
      if (c < minVal[i]) { minVal[i] = c; minVert[i] = v; }
      if (c > maxVal[i]) { maxVal[i] = c; maxVert[i] = v; }
    }
  }

  // Find two vertices separated by at least 1/sqrt(3) of the maximum
  // distance between any two vertices
  var index = 0;
  if (maxVal[1] - minVal[1] > maxVal[0] - minVal[0]) { index = 1; }
  if (maxVal[2] - minVal[2] > maxVal[index] - minVal[index]) { index = 2; }
  if (minVal[index] >= maxVal[index]) {
    // All vertices are the same -- normal doesn't matter
    norm[0] = 0; norm[1] = 0; norm[2] = 1;
    return;
  }

  // Look for a third vertex which forms the triangle with maximum area
  // (Length of normal == twice the triangle area)
  var maxLen2 = 0;
  var v1 = minVert[index];
  var v2 = maxVert[index];
  var tNorm = [0, 0, 0];
  var d1 = [
    v1.coords[0] - v2.coords[0],
    v1.coords[1] - v2.coords[1],
    v1.coords[2] - v2.coords[2]
  ];
  var d2 = [0, 0, 0];
  for (v = vHead.next; v !== vHead; v = v.next) {
    d2[0] = v.coords[0] - v2.coords[0];
    d2[1] = v.coords[1] - v2.coords[1];
    d2[2] = v.coords[2] - v2.coords[2];
    tNorm[0] = d1[1] * d2[2] - d1[2] * d2[1];
    tNorm[1] = d1[2] * d2[0] - d1[0] * d2[2];
    tNorm[2] = d1[0] * d2[1] - d1[1] * d2[0];
    var tLen2 = tNorm[0] * tNorm[0] + tNorm[1] * tNorm[1] + tNorm[2] * tNorm[2];
    if (tLen2 > maxLen2) {
      maxLen2 = tLen2;
      norm[0] = tNorm[0];
      norm[1] = tNorm[1];
      norm[2] = tNorm[2];
    }
  }

  if (maxLen2 <= 0) {
    // All points lie on a single line -- any decent normal will do
    norm[0] = norm[1] = norm[2] = 0;
    norm[libtess.normal.longAxis_(d1)] = 1;
  }
};

/**
 * Check that the sum of the signed area of all projected contours is
 * non-negative. If not, negate the t-coordinates to reverse the orientation and
 * make it so.
 * @private
 * @param {!libtess.GluTesselator} tess
 */
libtess.normal.checkOrientation_ = function(tess) {
  var area = 0;
  var fHead = tess.mesh.fHead;
  for (var f = fHead.next; f !== fHead; f = f.next) {
    var e = f.anEdge;
    if (e.winding <= 0) { continue; }
    do {
      area += (e.org.s - e.dst().s) * (e.org.t + e.dst().t);
      e = e.lNext;
    } while (e !== f.anEdge);
  }

  if (area < 0) {
    // Reverse the orientation by flipping all the t-coordinates
    var vHead = tess.mesh.vHead;
    for (var v = vHead.next; v !== vHead; v = v.next) {
      v.t = -v.t;
    }
  }
};

/* global libtess */

/** @const */
libtess.render = {};

/**
 * Takes a mesh, breaks it into separate triangles, and renders them. The
 * rendering output is provided as callbacks (see the API). Set flagEdges to
 * true to get edgeFlag callbacks (tess.flagBoundary in original libtess).
 * @param {!libtess.GluTesselator} tess
 * @param {!libtess.GluMesh} mesh
 * @param {boolean} flagEdges
 */
libtess.render.renderMesh = function(tess, mesh, flagEdges) {
  var beginCallbackCalled = false;

  // TODO(bckenny): edgeState needs to be boolean, but !== on first call
  // force edge state output for first vertex
  var edgeState = -1;

  // We examine all faces in an arbitrary order. Whenever we find
  // an inside triangle f, we render f.
  // NOTE(bckenny): go backwards through face list to match original libtess
  // triangle order
  for (var f = mesh.fHead.prev; f !== mesh.fHead; f = f.prev) {
    if (f.inside) {
      // We're going to emit a triangle, so call begin callback once
      if (!beginCallbackCalled) {
        tess.callBeginCallback(libtess.primitiveType.GL_TRIANGLES);
        beginCallbackCalled = true;
      }

      // check that face has only three edges
      var e = f.anEdge;
      // Loop once for each edge (there will always be 3 edges)
      do {
        if (flagEdges) {
          // Set the "edge state" to true just before we output the
          // first vertex of each edge on the polygon boundary.
          var newState = !e.rFace().inside ? 1 : 0; // TODO(bckenny): total hack to get edgeState working. fix me.
          if (edgeState !== newState) {
            edgeState = newState;
            // TODO(bckenny): edgeState should be boolean now
            tess.callEdgeFlagCallback(!!edgeState);
          }
        }

        // emit vertex
        tess.callVertexCallback(e.org.data);

        e = e.lNext;
      } while (e !== f.anEdge);
    }
  }

  // only call end callback if begin was called
  if (beginCallbackCalled) {
    tess.callEndCallback();
  }
};

/**
 * Takes a mesh, and outputs one contour for each face marked "inside". The
 * rendering output is provided as callbacks (see the API).
 * @param {!libtess.GluTesselator} tess
 * @param {!libtess.GluMesh} mesh
 */
libtess.render.renderBoundary = function(tess, mesh) {
  for (var f = mesh.fHead.next; f !== mesh.fHead; f = f.next) {
    if (f.inside) {
      tess.callBeginCallback(libtess.primitiveType.GL_LINE_LOOP);

      var e = f.anEdge;
      do {
        tess.callVertexCallback(e.org.data);
        e = e.lNext;
      } while (e !== f.anEdge);

      tess.callEndCallback();
    }
  }
};

/* global libtess */

// TODO(bckenny): a number of these never return null (as opposed to original) and should be typed appropriately

/*
 * Invariants for the Edge Dictionary.
 * - each pair of adjacent edges e2=succ(e1) satisfies edgeLeq_(e1,e2)
 *   at any valid location of the sweep event
 * - if edgeLeq_(e2,e1) as well (at any valid sweep event), then e1 and e2
 *   share a common endpoint
 * - for each e, e.dst() has been processed, but not e.org
 * - each edge e satisfies vertLeq(e.dst(),event) && vertLeq(event,e.org)
 *   where "event" is the current sweep line event.
 * - no edge e has zero length
 *
 * Invariants for the Mesh (the processed portion).
 * - the portion of the mesh left of the sweep line is a planar graph,
 *   ie. there is *some* way to embed it in the plane
 * - no processed edge has zero length
 * - no two processed vertices have identical coordinates
 * - each "inside" region is monotone, ie. can be broken into two chains
 *   of monotonically increasing vertices according to VertLeq(v1,v2)
 *   - a non-invariant: these chains may intersect (very slightly)
 *
 * Invariants for the Sweep.
 * - if none of the edges incident to the event vertex have an activeRegion
 *   (ie. none of these edges are in the edge dictionary), then the vertex
 *   has only right-going edges.
 * - if an edge is marked "fixUpperEdge" (it is a temporary edge introduced
 *   by ConnectRightVertex), then it is the only right-going edge from
 *   its associated vertex.  (This says that these edges exist only
 *   when it is necessary.)
 */

/** @const */
libtess.sweep = {};


/**
 * Make the sentinel coordinates big enough that they will never be
 * merged with real input features.  (Even with the largest possible
 * input contour and the maximum tolerance of 1.0, no merging will be
 * done with coordinates larger than 3 * libtess.GLU_TESS_MAX_COORD).
 * @private
 * @const
 * @type {number}
 */
libtess.sweep.SENTINEL_COORD_ = 4 * libtess.GLU_TESS_MAX_COORD;


/**
 * Because vertices at exactly the same location are merged together
 * before we process the sweep event, some degenerate cases can't occur.
 * However if someone eventually makes the modifications required to
 * merge features which are close together, the cases below marked
 * TOLERANCE_NONZERO will be useful.  They were debugged before the
 * code to merge identical vertices in the main loop was added.
 * @private
 * @const
 * @type {boolean}
 */
libtess.sweep.TOLERANCE_NONZERO_ = false;


/**
 * computeInterior(tess) computes the planar arrangement specified
 * by the given contours, and further subdivides this arrangement
 * into regions. Each region is marked "inside" if it belongs
 * to the polygon, according to the rule given by tess.windingRule.
 * Each interior region is guaranteed be monotone.
 *
 * @param {libtess.GluTesselator} tess [description].
 */
libtess.sweep.computeInterior = function(tess) {
  tess.fatalError = false;

  // Each vertex defines an event for our sweep line. Start by inserting
  // all the vertices in a priority queue. Events are processed in
  // lexicographic order, ie.
  // e1 < e2  iff  e1.x < e2.x || (e1.x == e2.x && e1.y < e2.y)
  libtess.sweep.removeDegenerateEdges_(tess);
  libtess.sweep.initPriorityQ_(tess);
  libtess.sweep.initEdgeDict_(tess);

  var v;
  while ((v = tess.pq.extractMin()) !== null) {
    for (;;) {
      var vNext = tess.pq.minimum();
      if (vNext === null || !libtess.geom.vertEq(vNext, v)) {
        break;
      }

      /* Merge together all vertices at exactly the same location.
       * This is more efficient than processing them one at a time,
       * simplifies the code (see connectLeftDegenerate), and is also
       * important for correct handling of certain degenerate cases.
       * For example, suppose there are two identical edges A and B
       * that belong to different contours (so without this code they would
       * be processed by separate sweep events).  Suppose another edge C
       * crosses A and B from above.  When A is processed, we split it
       * at its intersection point with C.  However this also splits C,
       * so when we insert B we may compute a slightly different
       * intersection point.  This might leave two edges with a small
       * gap between them.  This kind of error is especially obvious
       * when using boundary extraction (GLU_TESS_BOUNDARY_ONLY).
       */
      vNext = tess.pq.extractMin();
      libtess.sweep.spliceMergeVertices_(tess, v.anEdge, vNext.anEdge);
    }
    libtess.sweep.sweepEvent_(tess, v);
  }

  // TODO(bckenny): what does the next comment mean? can we eliminate event except when debugging?
  // Set tess.event for debugging purposes
  var minRegion = tess.dict.getMin().getKey();
  tess.event = minRegion.eUp.org;
  libtess.sweep.doneEdgeDict_(tess);
  libtess.sweep.donePriorityQ_(tess);

  libtess.sweep.removeDegenerateFaces_(tess.mesh);
  tess.mesh.checkMesh();
};


/**
 * When we merge two edges into one, we need to compute the combined
 * winding of the new edge.
 * @private
 * @param {libtess.GluHalfEdge} eDst [description].
 * @param {libtess.GluHalfEdge} eSrc [description].
 */
libtess.sweep.addWinding_ = function(eDst, eSrc) {
  // NOTE(bckenny): from AddWinding macro
  eDst.winding += eSrc.winding;
  eDst.sym.winding += eSrc.sym.winding;
};


/**
 * Both edges must be directed from right to left (this is the canonical
 * direction for the upper edge of each region).
 *
 * The strategy is to evaluate a "t" value for each edge at the
 * current sweep line position, given by tess.event.  The calculations
 * are designed to be very stable, but of course they are not perfect.
 *
 * Special case: if both edge destinations are at the sweep event,
 * we sort the edges by slope (they would otherwise compare equally).
 *
 * @private
 * @param {!libtess.GluTesselator} tess
 * @param {!libtess.ActiveRegion} reg1
 * @param {!libtess.ActiveRegion} reg2
 * @return {boolean}
 */
libtess.sweep.edgeLeq_ = function(tess, reg1, reg2) {
  var event = tess.event;
  var e1 = reg1.eUp;
  var e2 = reg2.eUp;

  if (e1.dst() === event) {
    if (e2.dst() === event) {
      // Two edges right of the sweep line which meet at the sweep event.
      // Sort them by slope.
      if (libtess.geom.vertLeq(e1.org, e2.org)) {
        return libtess.geom.edgeSign(e2.dst(), e1.org, e2.org) <= 0;
      }

      return libtess.geom.edgeSign(e1.dst(), e2.org, e1.org) >= 0;
    }

    return libtess.geom.edgeSign(e2.dst(), event, e2.org) <= 0;
  }

  if (e2.dst() === event) {
    return libtess.geom.edgeSign(e1.dst(), event, e1.org) >= 0;
  }

  // General case - compute signed distance *from* e1, e2 to event
  var t1 = libtess.geom.edgeEval(e1.dst(), event, e1.org);
  var t2 = libtess.geom.edgeEval(e2.dst(), event, e2.org);
  return (t1 >= t2);
};


/**
 * [deleteRegion_ description]
 * @private
 * @param {libtess.GluTesselator} tess [description].
 * @param {libtess.ActiveRegion} reg [description].
 */
libtess.sweep.deleteRegion_ = function(tess, reg) {
  if (reg.fixUpperEdge) {
    // It was created with zero winding number, so it better be
    // deleted with zero winding number (ie. it better not get merged
    // with a real edge).
  }

  reg.eUp.activeRegion = null;

  tess.dict.deleteNode(reg.nodeUp);
  reg.nodeUp = null;

  // memFree( reg ); TODO(bckenny)
  // TODO(bckenny): may need to null at callsite
};


/**
 * Replace an upper edge which needs fixing (see connectRightVertex).
 * @private
 * @param {libtess.ActiveRegion} reg [description].
 * @param {libtess.GluHalfEdge} newEdge [description].
 */
libtess.sweep.fixUpperEdge_ = function(reg, newEdge) {
  libtess.mesh.deleteEdge(reg.eUp);

  reg.fixUpperEdge = false;
  reg.eUp = newEdge;
  newEdge.activeRegion = reg;
};


/**
 * Find the region above the uppermost edge with the same origin.
 * @private
 * @param {libtess.ActiveRegion} reg [description].
 * @return {libtess.ActiveRegion} [description].
 */
libtess.sweep.topLeftRegion_ = function(reg) {
  var org = reg.eUp.org;

  // Find the region above the uppermost edge with the same origin
  do {
    reg = reg.regionAbove();
  } while (reg.eUp.org === org);

  // If the edge above was a temporary edge introduced by connectRightVertex,
  // now is the time to fix it.
  if (reg.fixUpperEdge) {
    var e = libtess.mesh.connect(reg.regionBelow().eUp.sym, reg.eUp.lNext);
    libtess.sweep.fixUpperEdge_(reg, e);
    reg = reg.regionAbove();
  }

  return reg;
};


/**
 * Find the region above the uppermost edge with the same destination.
 * @private
 * @param {libtess.ActiveRegion} reg [description].
 * @return {libtess.ActiveRegion} [description].
 */
libtess.sweep.topRightRegion_ = function(reg) {
  var dst = reg.eUp.dst();

  do {
    reg = reg.regionAbove();
  } while (reg.eUp.dst() === dst);

  return reg;
};


/**
 * Add a new active region to the sweep line, *somewhere* below "regAbove"
 * (according to where the new edge belongs in the sweep-line dictionary).
 * The upper edge of the new region will be "eNewUp".
 * Winding number and "inside" flag are not updated.
 *
 * @private
 * @param {libtess.GluTesselator} tess [description].
 * @param {libtess.ActiveRegion} regAbove [description].
 * @param {libtess.GluHalfEdge} eNewUp [description].
 * @return {libtess.ActiveRegion} regNew.
 */
libtess.sweep.addRegionBelow_ = function(tess, regAbove, eNewUp) {
  var regNew = new libtess.ActiveRegion();

  regNew.eUp = eNewUp;
  regNew.nodeUp = tess.dict.insertBefore(regAbove.nodeUp, regNew);
  eNewUp.activeRegion = regNew;

  return regNew;
};


/**
 * [isWindingInside_ description]
 * @private
 * @param {libtess.GluTesselator} tess [description].
 * @param {number} n int.
 * @return {boolean} [description].
 */
libtess.sweep.isWindingInside_ = function(tess, n) {
  switch (tess.windingRule) {
    case libtess.windingRule.GLU_TESS_WINDING_ODD:
      return ((n & 1) !== 0);
    case libtess.windingRule.GLU_TESS_WINDING_NONZERO:
      return (n !== 0);
    case libtess.windingRule.GLU_TESS_WINDING_POSITIVE:
      return (n > 0);
    case libtess.windingRule.GLU_TESS_WINDING_NEGATIVE:
      return (n < 0);
    case libtess.windingRule.GLU_TESS_WINDING_ABS_GEQ_TWO:
      return (n >= 2) || (n <= -2);
  }

  // TODO(bckenny): not reached
  return false;
};


/**
 * [computeWinding_ description]
 * @private
 * @param {libtess.GluTesselator} tess [description].
 * @param {libtess.ActiveRegion} reg [description].
 */
libtess.sweep.computeWinding_ = function(tess, reg) {
  reg.windingNumber = reg.regionAbove().windingNumber + reg.eUp.winding;
  reg.inside = libtess.sweep.isWindingInside_(tess, reg.windingNumber);
};


/**
 * Delete a region from the sweep line. This happens when the upper
 * and lower chains of a region meet (at a vertex on the sweep line).
 * The "inside" flag is copied to the appropriate mesh face (we could
 * not do this before -- since the structure of the mesh is always
 * changing, this face may not have even existed until now).
 *
 * @private
 * @param {libtess.GluTesselator} tess [description].
 * @param {libtess.ActiveRegion} reg [description].
 */
libtess.sweep.finishRegion_ = function(tess, reg) {
  // TODO(bckenny): may need to null reg at callsite

  var e = reg.eUp;
  var f = e.lFace;

  f.inside = reg.inside;
  f.anEdge = e;   // optimization for tessmono.tessellateMonoRegion() // TODO(bckenny): how so?
  libtess.sweep.deleteRegion_(tess, reg);
};


/**
 * We are given a vertex with one or more left-going edges. All affected
 * edges should be in the edge dictionary. Starting at regFirst.eUp,
 * we walk down deleting all regions where both edges have the same
 * origin vOrg. At the same time we copy the "inside" flag from the
 * active region to the face, since at this point each face will belong
 * to at most one region (this was not necessarily true until this point
 * in the sweep). The walk stops at the region above regLast; if regLast
 * is null we walk as far as possible. At the same time we relink the
 * mesh if necessary, so that the ordering of edges around vOrg is the
 * same as in the dictionary.
 *
 * @private
 * @param {libtess.GluTesselator} tess [description].
 * @param {libtess.ActiveRegion} regFirst [description].
 * @param {libtess.ActiveRegion} regLast [description].
 * @return {libtess.GluHalfEdge} [description].
 */
libtess.sweep.finishLeftRegions_ = function(tess, regFirst, regLast) {
  var regPrev = regFirst;
  var ePrev = regFirst.eUp;
  while (regPrev !== regLast) {
    // placement was OK
    regPrev.fixUpperEdge = false;
    var reg = regPrev.regionBelow();
    var e = reg.eUp;
    if (e.org !== ePrev.org) {
      if (!reg.fixUpperEdge) {
        /* Remove the last left-going edge. Even though there are no further
         * edges in the dictionary with this origin, there may be further
         * such edges in the mesh (if we are adding left edges to a vertex
         * that has already been processed). Thus it is important to call
         * finishRegion rather than just deleteRegion.
         */
        libtess.sweep.finishRegion_(tess, regPrev);
        break;
      }

      // If the edge below was a temporary edge introduced by
      // connectRightVertex, now is the time to fix it.
      e = libtess.mesh.connect(ePrev.lPrev(), e.sym);
      libtess.sweep.fixUpperEdge_(reg, e);
    }

    // Relink edges so that ePrev.oNext === e
    if (ePrev.oNext !== e) {
      libtess.mesh.meshSplice(e.oPrev(), e);
      libtess.mesh.meshSplice(ePrev, e);
    }

    // may change reg.eUp
    libtess.sweep.finishRegion_(tess, regPrev);
    ePrev = reg.eUp;
    regPrev = reg;
  }

  return ePrev;
};


/**
 * Purpose: insert right-going edges into the edge dictionary, and update
 * winding numbers and mesh connectivity appropriately. All right-going
 * edges share a common origin vOrg. Edges are inserted CCW starting at
 * eFirst; the last edge inserted is eLast.oPrev. If vOrg has any
 * left-going edges already processed, then eTopLeft must be the edge
 * such that an imaginary upward vertical segment from vOrg would be
 * contained between eTopLeft.oPrev and eTopLeft; otherwise eTopLeft
 * should be null.
 *
 * @private
 * @param {libtess.GluTesselator} tess [description].
 * @param {libtess.ActiveRegion} regUp [description].
 * @param {libtess.GluHalfEdge} eFirst [description].
 * @param {libtess.GluHalfEdge} eLast [description].
 * @param {libtess.GluHalfEdge} eTopLeft [description].
 * @param {boolean} cleanUp [description].
 */
libtess.sweep.addRightEdges_ = function(tess, regUp, eFirst, eLast, eTopLeft,
    cleanUp) {

  var firstTime = true;

  // Insert the new right-going edges in the dictionary
  var e = eFirst;
  do {
    libtess.sweep.addRegionBelow_(tess, regUp, e.sym);
    e = e.oNext;
  } while (e !== eLast);

  // Walk *all* right-going edges from e.org, in the dictionary order,
  // updating the winding numbers of each region, and re-linking the mesh
  // edges to match the dictionary ordering (if necessary).
  if (eTopLeft === null) {
    eTopLeft = regUp.regionBelow().eUp.rPrev();
  }
  var regPrev = regUp;
  var ePrev = eTopLeft;
  var reg;
  for (;;) {
    reg = regPrev.regionBelow();
    e = reg.eUp.sym;
    if (e.org !== ePrev.org) {
      break;
    }

    if (e.oNext !== ePrev) {
      // Unlink e from its current position, and relink below ePrev
      libtess.mesh.meshSplice(e.oPrev(), e);
      libtess.mesh.meshSplice(ePrev.oPrev(), e);
    }
    // Compute the winding number and "inside" flag for the new regions
    reg.windingNumber = regPrev.windingNumber - e.winding;
    reg.inside = libtess.sweep.isWindingInside_(tess, reg.windingNumber);

    // Check for two outgoing edges with same slope -- process these
    // before any intersection tests (see example in libtess.sweep.computeInterior).
    regPrev.dirty = true;
    if (!firstTime && libtess.sweep.checkForRightSplice_(tess, regPrev)) {
      libtess.sweep.addWinding_(e, ePrev);
      libtess.sweep.deleteRegion_(tess, regPrev); // TODO(bckenny): need to null regPrev anywhere else?
      libtess.mesh.deleteEdge(ePrev);
    }
    firstTime = false;
    regPrev = reg;
    ePrev = e;
  }

  regPrev.dirty = true;

  if (cleanUp) {
    // Check for intersections between newly adjacent edges.
    libtess.sweep.walkDirtyRegions_(tess, regPrev);
  }
};


/**
 * Set up data for and call GLU_TESS_COMBINE callback on GluTesselator.
 * @private
 * @param {!libtess.GluTesselator} tess
 * @param {!libtess.GluVertex} isect A raw vertex at the intersection.
 * @param {!Array<Object>} data The vertices of the intersecting edges.
 * @param {!Array<number>} weights The linear combination coefficients for this intersection.
 * @param {boolean} needed Whether a returned vertex is necessary in this case.
 */
libtess.sweep.callCombine_ = function(tess, isect, data, weights, needed) {
  // Copy coord data in case the callback changes it.
  var coords = [
    isect.coords[0],
    isect.coords[1],
    isect.coords[2]
  ];

  isect.data = null;
  isect.data = tess.callCombineCallback(coords, data, weights);
  if (isect.data === null) {
    if (!needed) {
      // not needed, so just use data from first vertex
      isect.data = data[0];

    } else if (!tess.fatalError) {
      // The only way fatal error is when two edges are found to intersect,
      // but the user has not provided the callback necessary to handle
      // generated intersection points.
      tess.callErrorCallback(libtess.errorType.GLU_TESS_NEED_COMBINE_CALLBACK);
      tess.fatalError = true;
    }
  }
};


/**
 * Two vertices with idential coordinates are combined into one.
 * e1.org is kept, while e2.org is discarded.
 * @private
 * @param {!libtess.GluTesselator} tess
 * @param {libtess.GluHalfEdge} e1 [description].
 * @param {libtess.GluHalfEdge} e2 [description].
 */
libtess.sweep.spliceMergeVertices_ = function(tess, e1, e2) {
  // TODO(bckenny): better way to init these? save them?
  var data = [null, null, null, null];
  var weights = [0.5, 0.5, 0, 0];

  data[0] = e1.org.data;
  data[1] = e2.org.data;
  libtess.sweep.callCombine_(tess, e1.org, data, weights, false);
  libtess.mesh.meshSplice(e1, e2);
};


/**
 * Find some weights which describe how the intersection vertex is
 * a linear combination of org and dst. Each of the two edges
 * which generated "isect" is allocated 50% of the weight; each edge
 * splits the weight between its org and dst according to the
 * relative distance to "isect".
 *
 * @private
 * @param {libtess.GluVertex} isect [description].
 * @param {libtess.GluVertex} org [description].
 * @param {libtess.GluVertex} dst [description].
 * @param {Array.<number>} weights [description].
 * @param {number} weightIndex Index into weights for first weight to supply.
 */
libtess.sweep.vertexWeights_ = function(isect, org, dst, weights, weightIndex) {
  // TODO(bckenny): think through how we can use L1dist here and be correct for coords
  var t1 = libtess.geom.vertL1dist(org, isect);
  var t2 = libtess.geom.vertL1dist(dst, isect);

  // TODO(bckenny): introduced weightIndex to mimic addressing in original
  // 1) document (though it is private and only used from getIntersectData)
  // 2) better way? manually inline into getIntersectData? supply two two-length tmp arrays?
  var i0 = weightIndex;
  var i1 = weightIndex + 1;
  weights[i0] = 0.5 * t2 / (t1 + t2);
  weights[i1] = 0.5 * t1 / (t1 + t2);
  isect.coords[0] += weights[i0] * org.coords[0] + weights[i1] * dst.coords[0];
  isect.coords[1] += weights[i0] * org.coords[1] + weights[i1] * dst.coords[1];
  isect.coords[2] += weights[i0] * org.coords[2] + weights[i1] * dst.coords[2];
};


/**
 * We've computed a new intersection point, now we need a "data" pointer
 * from the user so that we can refer to this new vertex in the
 * rendering callbacks.
 * @private
 * @param {!libtess.GluTesselator} tess
 * @param {libtess.GluVertex} isect [description].
 * @param {libtess.GluVertex} orgUp [description].
 * @param {libtess.GluVertex} dstUp [description].
 * @param {libtess.GluVertex} orgLo [description].
 * @param {libtess.GluVertex} dstLo [description].
 */
libtess.sweep.getIntersectData_ = function(tess, isect, orgUp, dstUp, orgLo,
    dstLo) {

  // TODO(bckenny): called for every intersection event, should these be from a pool?
  // TODO(bckenny): better way to init these?
  var weights = [0, 0, 0, 0];
  var data = [
    orgUp.data,
    dstUp.data,
    orgLo.data,
    dstLo.data
  ];

  // TODO(bckenny): it appears isect is a reappropriated vertex, so does need to be zeroed.
  // double check this.
  isect.coords[0] = isect.coords[1] = isect.coords[2] = 0;

  // TODO(bckenny): see note in libtess.sweep.vertexWeights_ for explanation of weightIndex. fix?
  libtess.sweep.vertexWeights_(isect, orgUp, dstUp, weights, 0);
  libtess.sweep.vertexWeights_(isect, orgLo, dstLo, weights, 2);

  libtess.sweep.callCombine_(tess, isect, data, weights, true);
};


/**
 * Check the upper and lower edge of regUp, to make sure that the
 * eUp.org is above eLo, or eLo.org is below eUp (depending on which
 * origin is leftmost).
 *
 * The main purpose is to splice right-going edges with the same
 * dest vertex and nearly identical slopes (ie. we can't distinguish
 * the slopes numerically). However the splicing can also help us
 * to recover from numerical errors. For example, suppose at one
 * point we checked eUp and eLo, and decided that eUp.org is barely
 * above eLo. Then later, we split eLo into two edges (eg. from
 * a splice operation like this one). This can change the result of
 * our test so that now eUp.org is incident to eLo, or barely below it.
 * We must correct this condition to maintain the dictionary invariants.
 *
 * One possibility is to check these edges for intersection again
 * (i.e. checkForIntersect). This is what we do if possible. However
 * checkForIntersect requires that tess.event lies between eUp and eLo,
 * so that it has something to fall back on when the intersection
 * calculation gives us an unusable answer. So, for those cases where
 * we can't check for intersection, this routine fixes the problem
 * by just splicing the offending vertex into the other edge.
 * This is a guaranteed solution, no matter how degenerate things get.
 * Basically this is a combinatorial solution to a numerical problem.
 *
 * @private
 * @param {libtess.GluTesselator} tess [description].
 * @param {libtess.ActiveRegion} regUp [description].
 * @return {boolean} [description].
 */
libtess.sweep.checkForRightSplice_ = function(tess, regUp) {
  // TODO(bckenny): fully learn how these two checks work

  var regLo = regUp.regionBelow();
  var eUp = regUp.eUp;
  var eLo = regLo.eUp;

  if (libtess.geom.vertLeq(eUp.org, eLo.org)) {
    if (libtess.geom.edgeSign(eLo.dst(), eUp.org, eLo.org) > 0) {
      return false;
    }

    // eUp.org appears to be below eLo
    if (!libtess.geom.vertEq(eUp.org, eLo.org)) {
      // Splice eUp.org into eLo
      libtess.mesh.splitEdge(eLo.sym);
      libtess.mesh.meshSplice(eUp, eLo.oPrev());
      regUp.dirty = regLo.dirty = true;

    } else if (eUp.org !== eLo.org) {
      // merge the two vertices, discarding eUp.org
      tess.pq.remove(eUp.org.pqHandle);
      libtess.sweep.spliceMergeVertices_(tess, eLo.oPrev(), eUp);
    }

  } else {
    if (libtess.geom.edgeSign(eUp.dst(), eLo.org, eUp.org) < 0) {
      return false;
    }

    // eLo.org appears to be above eUp, so splice eLo.org into eUp
    regUp.regionAbove().dirty = regUp.dirty = true;
    libtess.mesh.splitEdge(eUp.sym);
    libtess.mesh.meshSplice(eLo.oPrev(), eUp);
  }

  return true;
};


/**
 * Check the upper and lower edge of regUp to make sure that the
 * eUp.dst() is above eLo, or eLo.dst() is below eUp (depending on which
 * destination is rightmost).
 *
 * Theoretically, this should always be true. However, splitting an edge
 * into two pieces can change the results of previous tests. For example,
 * suppose at one point we checked eUp and eLo, and decided that eUp.dst()
 * is barely above eLo. Then later, we split eLo into two edges (eg. from
 * a splice operation like this one). This can change the result of
 * the test so that now eUp.dst() is incident to eLo, or barely below it.
 * We must correct this condition to maintain the dictionary invariants
 * (otherwise new edges might get inserted in the wrong place in the
 * dictionary, and bad stuff will happen).
 *
 * We fix the problem by just splicing the offending vertex into the
 * other edge.
 *
 * @private
 * @param {libtess.GluTesselator} tess description].
 * @param {libtess.ActiveRegion} regUp [description].
 * @return {boolean} [description].
 */
libtess.sweep.checkForLeftSplice_ = function(tess, regUp) {
  var regLo = regUp.regionBelow();
  var eUp = regUp.eUp;
  var eLo = regLo.eUp;
  var e;

  if (libtess.geom.vertLeq(eUp.dst(), eLo.dst())) {
    if (libtess.geom.edgeSign(eUp.dst(), eLo.dst(), eUp.org) < 0) {
      return false;
    }

    // eLo.dst() is above eUp, so splice eLo.dst() into eUp
    regUp.regionAbove().dirty = regUp.dirty = true;
    e = libtess.mesh.splitEdge(eUp);
    libtess.mesh.meshSplice(eLo.sym, e);
    e.lFace.inside = regUp.inside;

  } else {
    if (libtess.geom.edgeSign(eLo.dst(), eUp.dst(), eLo.org) > 0) {
      return false;
    }

    // eUp.dst() is below eLo, so splice eUp.dst() into eLo
    regUp.dirty = regLo.dirty = true;
    e = libtess.mesh.splitEdge(eLo);
    libtess.mesh.meshSplice(eUp.lNext, eLo.sym);
    e.rFace().inside = regUp.inside;
  }

  return true;
};


/**
 * Check the upper and lower edges of the given region to see if
 * they intersect. If so, create the intersection and add it
 * to the data structures.
 *
 * Returns true if adding the new intersection resulted in a recursive
 * call to addRightEdges_(); in this case all "dirty" regions have been
 * checked for intersections, and possibly regUp has been deleted.
 *
 * @private
 * @param {libtess.GluTesselator} tess [description].
 * @param {libtess.ActiveRegion} regUp [description].
 * @return {boolean} [description].
 */
libtess.sweep.checkForIntersect_ = function(tess, regUp) {
  var regLo = regUp.regionBelow();
  var eUp = regUp.eUp;
  var eLo = regLo.eUp;
  var orgUp = eUp.org;
  var orgLo = eLo.org;
  var dstUp = eUp.dst();
  var dstLo = eLo.dst();

  var isect = new libtess.GluVertex();

  if (orgUp === orgLo) {
    // right endpoints are the same
    return false;
  }

  var tMinUp = Math.min(orgUp.t, dstUp.t);
  var tMaxLo = Math.max(orgLo.t, dstLo.t);
  if (tMinUp > tMaxLo) {
    // t ranges do not overlap
    return false;
  }

  if (libtess.geom.vertLeq(orgUp, orgLo)) {
    if (libtess.geom.edgeSign(dstLo, orgUp, orgLo) > 0) {
      return false;
    }
  } else {
    if (libtess.geom.edgeSign(dstUp, orgLo, orgUp) < 0) {
      return false;
    }
  }

  // At this point the edges intersect, at least marginally
  libtess.geom.edgeIntersect(dstUp, orgUp, dstLo, orgLo, isect);

  // The following properties are guaranteed:

  if (libtess.geom.vertLeq(isect, tess.event)) {
    /* The intersection point lies slightly to the left of the sweep line,
     * so move it until it's slightly to the right of the sweep line.
     * (If we had perfect numerical precision, this would never happen
     * in the first place). The easiest and safest thing to do is
     * replace the intersection by tess.event.
     */
    isect.s = tess.event.s;
    isect.t = tess.event.t;
  }

  // TODO(bckenny): try to find test54.d
  /* Similarly, if the computed intersection lies to the right of the
   * rightmost origin (which should rarely happen), it can cause
   * unbelievable inefficiency on sufficiently degenerate inputs.
   * (If you have the test program, try running test54.d with the
   * "X zoom" option turned on).
   */
  var orgMin = libtess.geom.vertLeq(orgUp, orgLo) ? orgUp : orgLo;
  if (libtess.geom.vertLeq(orgMin, isect)) {
    isect.s = orgMin.s;
    isect.t = orgMin.t;
  }

  if (libtess.geom.vertEq(isect, orgUp) || libtess.geom.vertEq(isect, orgLo)) {
    // Easy case -- intersection at one of the right endpoints
    libtess.sweep.checkForRightSplice_(tess, regUp);
    return false;
  }

  // TODO(bckenny): clean this up; length is distracting
  if ((!libtess.geom.vertEq(dstUp, tess.event) &&
      libtess.geom.edgeSign(dstUp, tess.event, isect) >= 0) ||
      (!libtess.geom.vertEq(dstLo, tess.event) &&
      libtess.geom.edgeSign(dstLo, tess.event, isect) <= 0)) {

    /* Very unusual -- the new upper or lower edge would pass on the
     * wrong side of the sweep event, or through it. This can happen
     * due to very small numerical errors in the intersection calculation.
     */
    if (dstLo === tess.event) {
      // Splice dstLo into eUp, and process the new region(s)
      libtess.mesh.splitEdge(eUp.sym);
      libtess.mesh.meshSplice(eLo.sym, eUp);
      regUp = libtess.sweep.topLeftRegion_(regUp);
      eUp = regUp.regionBelow().eUp;
      libtess.sweep.finishLeftRegions_(tess, regUp.regionBelow(), regLo);
      libtess.sweep.addRightEdges_(tess, regUp, eUp.oPrev(), eUp, eUp, true);
      return true;
    }

    if (dstUp === tess.event) {
      // Splice dstUp into eLo, and process the new region(s)
      libtess.mesh.splitEdge(eLo.sym);
      libtess.mesh.meshSplice(eUp.lNext, eLo.oPrev());
      regLo = regUp;
      regUp = libtess.sweep.topRightRegion_(regUp);
      var e = regUp.regionBelow().eUp.rPrev();
      regLo.eUp = eLo.oPrev();
      eLo = libtess.sweep.finishLeftRegions_(tess, regLo, null);
      libtess.sweep.addRightEdges_(tess, regUp, eLo.oNext, eUp.rPrev(), e,
          true);
      return true;
    }

    /* Special case: called from connectRightVertex. If either
     * edge passes on the wrong side of tess.event, split it
     * (and wait for connectRightVertex to splice it appropriately).
     */
    if (libtess.geom.edgeSign(dstUp, tess.event, isect) >= 0) {
      regUp.regionAbove().dirty = regUp.dirty = true;
      libtess.mesh.splitEdge(eUp.sym);
      eUp.org.s = tess.event.s;
      eUp.org.t = tess.event.t;
    }

    if (libtess.geom.edgeSign(dstLo, tess.event, isect) <= 0) {
      regUp.dirty = regLo.dirty = true;
      libtess.mesh.splitEdge(eLo.sym);
      eLo.org.s = tess.event.s;
      eLo.org.t = tess.event.t;
    }

    // leave the rest for connectRightVertex
    return false;
  }

  /* General case -- split both edges, splice into new vertex.
   * When we do the splice operation, the order of the arguments is
   * arbitrary as far as correctness goes. However, when the operation
   * creates a new face, the work done is proportional to the size of
   * the new face. We expect the faces in the processed part of
   * the mesh (ie. eUp.lFace) to be smaller than the faces in the
   * unprocessed original contours (which will be eLo.oPrev.lFace).
   */
  libtess.mesh.splitEdge(eUp.sym);
  libtess.mesh.splitEdge(eLo.sym);
  libtess.mesh.meshSplice(eLo.oPrev(), eUp);
  eUp.org.s = isect.s;
  eUp.org.t = isect.t;
  eUp.org.pqHandle = tess.pq.insert(eUp.org);
  libtess.sweep.getIntersectData_(tess, eUp.org, orgUp, dstUp, orgLo, dstLo);
  regUp.regionAbove().dirty = regUp.dirty = regLo.dirty = true;

  return false;
};


/**
 * When the upper or lower edge of any region changes, the region is
 * marked "dirty". This routine walks through all the dirty regions
 * and makes sure that the dictionary invariants are satisfied
 * (see the comments at the beginning of this file). Of course,
 * new dirty regions can be created as we make changes to restore
 * the invariants.
 * @private
 * @param {libtess.GluTesselator} tess [description].
 * @param {libtess.ActiveRegion} regUp [description].
 */
libtess.sweep.walkDirtyRegions_ = function(tess, regUp) {
  var regLo = regUp.regionBelow();

  for (;;) {
    // Find the lowest dirty region (we walk from the bottom up).
    while (regLo.dirty) {
      regUp = regLo;
      regLo = regLo.regionBelow();
    }
    if (!regUp.dirty) {
      regLo = regUp;
      regUp = regUp.regionAbove();
      if (regUp === null || !regUp.dirty) {
        // We've walked all the dirty regions
        return;
      }
    }

    regUp.dirty = false;
    var eUp = regUp.eUp;
    var eLo = regLo.eUp;

    if (eUp.dst() !== eLo.dst()) {
      // Check that the edge ordering is obeyed at the dst vertices.
      if (libtess.sweep.checkForLeftSplice_(tess, regUp)) {
        // If the upper or lower edge was marked fixUpperEdge, then
        // we no longer need it (since these edges are needed only for
        // vertices which otherwise have no right-going edges).
        if (regLo.fixUpperEdge) {
          libtess.sweep.deleteRegion_(tess, regLo);
          libtess.mesh.deleteEdge(eLo);
          regLo = regUp.regionBelow();
          eLo = regLo.eUp;

        } else if (regUp.fixUpperEdge) {
          libtess.sweep.deleteRegion_(tess, regUp);
          libtess.mesh.deleteEdge(eUp);
          regUp = regLo.regionAbove();
          eUp = regUp.eUp;
        }
      }
    }

    if (eUp.org !== eLo.org) {
      if (eUp.dst() !== eLo.dst() && !regUp.fixUpperEdge &&
          !regLo.fixUpperEdge &&
          (eUp.dst() === tess.event || eLo.dst() === tess.event)) {
        /* When all else fails in checkForIntersect(), it uses tess.event
         * as the intersection location. To make this possible, it requires
         * that tess.event lie between the upper and lower edges, and also
         * that neither of these is marked fixUpperEdge (since in the worst
         * case it might splice one of these edges into tess.event, and
         * violate the invariant that fixable edges are the only right-going
         * edge from their associated vertex).
         */
        if (libtess.sweep.checkForIntersect_(tess, regUp)) {
          // walkDirtyRegions() was called recursively; we're done
          return;
        }

      } else {
        // Even though we can't use checkForIntersect(), the org vertices
        // may violate the dictionary edge ordering. Check and correct this.
        libtess.sweep.checkForRightSplice_(tess, regUp);
      }
    }

    if (eUp.org === eLo.org && eUp.dst() === eLo.dst()) {
      // A degenerate loop consisting of only two edges -- delete it.
      libtess.sweep.addWinding_(eLo, eUp);
      libtess.sweep.deleteRegion_(tess, regUp);
      libtess.mesh.deleteEdge(eUp);
      regUp = regLo.regionAbove();
    }
  }
};


/**
 * Purpose: connect a "right" vertex vEvent (one where all edges go left)
 * to the unprocessed portion of the mesh. Since there are no right-going
 * edges, two regions (one above vEvent and one below) are being merged
 * into one. regUp is the upper of these two regions.
 *
 * There are two reasons for doing this (adding a right-going edge):
 *  - if the two regions being merged are "inside", we must add an edge
 *    to keep them separated (the combined region would not be monotone).
 *  - in any case, we must leave some record of vEvent in the dictionary,
 *    so that we can merge vEvent with features that we have not seen yet.
 *    For example, maybe there is a vertical edge which passes just to
 *    the right of vEvent; we would like to splice vEvent into this edge.
 *
 * However, we don't want to connect vEvent to just any vertex. We don't
 * want the new edge to cross any other edges; otherwise we will create
 * intersection vertices even when the input data had no self-intersections.
 * (This is a bad thing; if the user's input data has no intersections,
 * we don't want to generate any false intersections ourselves.)
 *
 * Our eventual goal is to connect vEvent to the leftmost unprocessed
 * vertex of the combined region (the union of regUp and regLo).
 * But because of unseen vertices with all right-going edges, and also
 * new vertices which may be created by edge intersections, we don't
 * know where that leftmost unprocessed vertex is. In the meantime, we
 * connect vEvent to the closest vertex of either chain, and mark the region
 * as "fixUpperEdge". This flag says to delete and reconnect this edge
 * to the next processed vertex on the boundary of the combined region.
 * Quite possibly the vertex we connected to will turn out to be the
 * closest one, in which case we won't need to make any changes.
 *
 * @private
 * @param {libtess.GluTesselator} tess [description].
 * @param {libtess.ActiveRegion} regUp [description].
 * @param {libtess.GluHalfEdge} eBottomLeft [description].
 */
libtess.sweep.connectRightVertex_ = function(tess, regUp, eBottomLeft) {
  var eTopLeft = eBottomLeft.oNext;
  var regLo = regUp.regionBelow();
  var eUp = regUp.eUp;
  var eLo = regLo.eUp;
  var degenerate = false;

  if (eUp.dst() !== eLo.dst()) {
    libtess.sweep.checkForIntersect_(tess, regUp);
  }

  // Possible new degeneracies: upper or lower edge of regUp may pass
  // through vEvent, or may coincide with new intersection vertex
  if (libtess.geom.vertEq(eUp.org, tess.event)) {
    libtess.mesh.meshSplice(eTopLeft.oPrev(), eUp);
    regUp = libtess.sweep.topLeftRegion_(regUp);
    eTopLeft = regUp.regionBelow().eUp;
    libtess.sweep.finishLeftRegions_(tess, regUp.regionBelow(), regLo);
    degenerate = true;
  }
  if (libtess.geom.vertEq(eLo.org, tess.event)) {
    libtess.mesh.meshSplice(eBottomLeft, eLo.oPrev());
    eBottomLeft = libtess.sweep.finishLeftRegions_(tess, regLo, null);
    degenerate = true;
  }
  if (degenerate) {
    libtess.sweep.addRightEdges_(tess, regUp, eBottomLeft.oNext, eTopLeft,
        eTopLeft, true);
    return;
  }

  // Non-degenerate situation -- need to add a temporary, fixable edge.
  // Connect to the closer of eLo.org, eUp.org.
  var eNew;
  if (libtess.geom.vertLeq(eLo.org, eUp.org)) {
    eNew = eLo.oPrev();
  } else {
    eNew = eUp;
  }
  eNew = libtess.mesh.connect(eBottomLeft.lPrev(), eNew);

  // Prevent cleanup, otherwise eNew might disappear before we've even
  // had a chance to mark it as a temporary edge.
  libtess.sweep.addRightEdges_(tess, regUp, eNew, eNew.oNext, eNew.oNext,
      false);
  eNew.sym.activeRegion.fixUpperEdge = true;
  libtess.sweep.walkDirtyRegions_(tess, regUp);
};


/**
 * The event vertex lies exacty on an already-processed edge or vertex.
 * Adding the new vertex involves splicing it into the already-processed
 * part of the mesh.
 * @private
 * @param {!libtess.GluTesselator} tess
 * @param {libtess.ActiveRegion} regUp [description].
 * @param {libtess.GluVertex} vEvent [description].
 */
libtess.sweep.connectLeftDegenerate_ = function(tess, regUp, vEvent) {
  var e = regUp.eUp;
  /* istanbul ignore if */
  if (libtess.geom.vertEq(e.org, vEvent)) {
    // NOTE(bckenny): this code is unreachable but remains for a hypothetical
    // future extension of libtess. See docs on libtess.sweep.TOLERANCE_NONZERO_
    // for more information. Conditional on TOLERANCE_NONZERO_ to help Closure
    // Compiler eliminate dead code.
    // e.org is an unprocessed vertex - just combine them, and wait
    // for e.org to be pulled from the queue
    if (libtess.sweep.TOLERANCE_NONZERO_) {
      libtess.sweep.spliceMergeVertices_(tess, e, vEvent.anEdge);
    }
    return;
  }

  if (!libtess.geom.vertEq(e.dst(), vEvent)) {
    // General case -- splice vEvent into edge e which passes through it
    libtess.mesh.splitEdge(e.sym);

    if (regUp.fixUpperEdge) {
      // This edge was fixable -- delete unused portion of original edge
      libtess.mesh.deleteEdge(e.oNext);
      regUp.fixUpperEdge = false;
    }

    libtess.mesh.meshSplice(vEvent.anEdge, e);

    // recurse
    libtess.sweep.sweepEvent_(tess, vEvent);
    return;
  }

  // NOTE(bckenny): this code is unreachable but remains for a hypothetical
  // future extension of libtess. See docs on libtess.sweep.TOLERANCE_NONZERO_
  // for more information. Conditional on TOLERANCE_NONZERO_ to help Closure
  // Compiler eliminate dead code.
  // vEvent coincides with e.dst(), which has already been processed.
  // Splice in the additional right-going edges.
  /* istanbul ignore next */

  /* istanbul ignore next */
  if (libtess.sweep.TOLERANCE_NONZERO_) {
    regUp = libtess.sweep.topRightRegion_(regUp);
    var reg = regUp.regionBelow();
    var eTopRight = reg.eUp.sym;
    var eTopLeft = eTopRight.oNext;
    var eLast = eTopLeft;

    if (reg.fixUpperEdge) {
      // Here e.dst() has only a single fixable edge going right.
      // We can delete it since now we have some real right-going edges.

      // there are some left edges too
      libtess.sweep.deleteRegion_(tess, reg); // TODO(bckenny): something to null?
      libtess.mesh.deleteEdge(eTopRight);
      eTopRight = eTopLeft.oPrev();
    }

    libtess.mesh.meshSplice(vEvent.anEdge, eTopRight);
    if (!libtess.geom.edgeGoesLeft(eTopLeft)) {
      // e.dst() had no left-going edges -- indicate this to addRightEdges()
      eTopLeft = null;
    }

    libtess.sweep.addRightEdges_(tess, regUp, eTopRight.oNext, eLast, eTopLeft,
        true);
  }
};


/**
 * Connect a "left" vertex (one where both edges go right)
 * to the processed portion of the mesh. Let R be the active region
 * containing vEvent, and let U and L be the upper and lower edge
 * chains of R. There are two possibilities:
 *
 * - the normal case: split R into two regions, by connecting vEvent to
 *   the rightmost vertex of U or L lying to the left of the sweep line
 *
 * - the degenerate case: if vEvent is close enough to U or L, we
 *   merge vEvent into that edge chain. The subcases are:
 *  - merging with the rightmost vertex of U or L
 *  - merging with the active edge of U or L
 *  - merging with an already-processed portion of U or L
 *
 * @private
 * @param {libtess.GluTesselator} tess   [description].
 * @param {libtess.GluVertex} vEvent [description].
 */
libtess.sweep.connectLeftVertex_ = function(tess, vEvent) {
  // TODO(bckenny): tmp only used for sweep. better to keep tmp across calls?
  var tmp = new libtess.ActiveRegion();

  // NOTE(bckenny): this was commented out in the original
  // libtess.assert(vEvent.anEdge.oNext.oNext === vEvent.anEdge);

  // Get a pointer to the active region containing vEvent
  tmp.eUp = vEvent.anEdge.sym;
  var regUp = tess.dict.search(tmp).getKey();
  var regLo = regUp.regionBelow();
  var eUp = regUp.eUp;
  var eLo = regLo.eUp;

  // try merging with U or L first
  if (libtess.geom.edgeSign(eUp.dst(), vEvent, eUp.org) === 0) {
    libtess.sweep.connectLeftDegenerate_(tess, regUp, vEvent);
    return;
  }

  // Connect vEvent to rightmost processed vertex of either chain.
  // e.dst() is the vertex that we will connect to vEvent.
  var reg = libtess.geom.vertLeq(eLo.dst(), eUp.dst()) ? regUp : regLo;
  var eNew;
  if (regUp.inside || reg.fixUpperEdge) {
    if (reg === regUp) {
      eNew = libtess.mesh.connect(vEvent.anEdge.sym, eUp.lNext);

    } else {
      var tempHalfEdge = libtess.mesh.connect(eLo.dNext(), vEvent.anEdge);
      eNew = tempHalfEdge.sym;
    }

    if (reg.fixUpperEdge) {
      libtess.sweep.fixUpperEdge_(reg, eNew);

    } else {
      libtess.sweep.computeWinding_(tess,
          libtess.sweep.addRegionBelow_(tess, regUp, eNew));
    }
    libtess.sweep.sweepEvent_(tess, vEvent);

  } else {
    // The new vertex is in a region which does not belong to the polygon.
    // We don''t need to connect this vertex to the rest of the mesh.
    libtess.sweep.addRightEdges_(tess, regUp, vEvent.anEdge, vEvent.anEdge,
        null, true);
  }
};


/**
 * Does everything necessary when the sweep line crosses a vertex.
 * Updates the mesh and the edge dictionary.
 * @private
 * @param {libtess.GluTesselator} tess [description].
 * @param {libtess.GluVertex} vEvent [description].
 */
libtess.sweep.sweepEvent_ = function(tess, vEvent) {
  tess.event = vEvent; // for access in edgeLeq_ // TODO(bckenny): wuh?

  /* Check if this vertex is the right endpoint of an edge that is
   * already in the dictionary.  In this case we don't need to waste
   * time searching for the location to insert new edges.
   */
  var e = vEvent.anEdge;
  while (e.activeRegion === null) {
    e = e.oNext;
    if (e === vEvent.anEdge) {
      // All edges go right -- not incident to any processed edges
      libtess.sweep.connectLeftVertex_(tess, vEvent);
      return;
    }
  }

  /* Processing consists of two phases: first we "finish" all the
   * active regions where both the upper and lower edges terminate
   * at vEvent (ie. vEvent is closing off these regions).
   * We mark these faces "inside" or "outside" the polygon according
   * to their winding number, and delete the edges from the dictionary.
   * This takes care of all the left-going edges from vEvent.
   */
  var regUp = libtess.sweep.topLeftRegion_(e.activeRegion);
  var reg = regUp.regionBelow();
  var eTopLeft = reg.eUp;
  var eBottomLeft = libtess.sweep.finishLeftRegions_(tess, reg, null);

  /* Next we process all the right-going edges from vEvent. This
   * involves adding the edges to the dictionary, and creating the
   * associated "active regions" which record information about the
   * regions between adjacent dictionary edges.
   */
  if (eBottomLeft.oNext === eTopLeft) {
    // No right-going edges -- add a temporary "fixable" edge
    libtess.sweep.connectRightVertex_(tess, regUp, eBottomLeft);

  } else {
    libtess.sweep.addRightEdges_(tess, regUp, eBottomLeft.oNext, eTopLeft,
        eTopLeft, true);
  }
};


/**
 * We add two sentinel edges above and below all other edges,
 * to avoid special cases at the top and bottom.
 * @private
 * @param {libtess.GluTesselator} tess [description].
 * @param {number} t [description].
 */
libtess.sweep.addSentinel_ = function(tess, t) {
  var reg = new libtess.ActiveRegion();

  var e = libtess.mesh.makeEdge(tess.mesh);

  e.org.s = libtess.sweep.SENTINEL_COORD_;
  e.org.t = t;
  e.dst().s = -libtess.sweep.SENTINEL_COORD_;
  e.dst().t = t;
  tess.event = e.dst(); //initialize it

  reg.eUp = e;
  reg.windingNumber = 0;
  reg.inside = false;
  reg.fixUpperEdge = false;
  reg.sentinel = true;
  reg.dirty = false;
  reg.nodeUp = tess.dict.insert(reg);
};


/**
 * We maintain an ordering of edge intersections with the sweep line.
 * This order is maintained in a dynamic dictionary.
 * @private
 * @param {libtess.GluTesselator} tess [description].
 */
libtess.sweep.initEdgeDict_ = function(tess) {
  tess.dict = new libtess.Dict(tess, libtess.sweep.edgeLeq_);

  libtess.sweep.addSentinel_(tess, -libtess.sweep.SENTINEL_COORD_);
  libtess.sweep.addSentinel_(tess, libtess.sweep.SENTINEL_COORD_);
};


/**
 * [doneEdgeDict_ description]
 * @private
 * @param {libtess.GluTesselator} tess [description].
 */
libtess.sweep.doneEdgeDict_ = function(tess) {
  // NOTE(bckenny): fixedEdges is only used in the assert below, so ignore so
  // when asserts are removed jshint won't error.
  /* jshint unused:false */
  var fixedEdges = 0;

  var reg;
  while ((reg = tess.dict.getMin().getKey()) !== null) {
    // At the end of all processing, the dictionary should contain
    // only the two sentinel edges, plus at most one "fixable" edge
    // created by connectRightVertex().
    if (!reg.sentinel) {
    }
    libtess.sweep.deleteRegion_(tess, reg);
  }

  // NOTE(bckenny): see tess.dict.deleteDict_() for old delete dict function
  tess.dict = null;
};


/**
 * Remove zero-length edges, and contours with fewer than 3 vertices.
 * @private
 * @param {libtess.GluTesselator} tess [description].
 */
libtess.sweep.removeDegenerateEdges_ = function(tess) {
  var eHead = tess.mesh.eHead;

  var eNext;
  for (var e = eHead.next; e !== eHead; e = eNext) {
    eNext = e.next;
    var eLNext = e.lNext;

    if (libtess.geom.vertEq(e.org, e.dst()) && e.lNext.lNext !== e) {
      // Zero-length edge, contour has at least 3 edges
      libtess.sweep.spliceMergeVertices_(tess, eLNext, e); // deletes e.org
      libtess.mesh.deleteEdge(e); // e is a self-loop TODO(bckenny): does this comment really apply here?
      e = eLNext;
      eLNext = e.lNext;
    }

    if (eLNext.lNext === e) {
      // Degenerate contour (one or two edges)
      if (eLNext !== e) {
        if (eLNext === eNext || eLNext === eNext.sym) {
          eNext = eNext.next;
        }
        libtess.mesh.deleteEdge(eLNext);
      }

      if (e === eNext || e === eNext.sym) {
        eNext = eNext.next;
      }
      libtess.mesh.deleteEdge(e);
    }
  }
};


/**
 * Construct priority queue and insert all vertices into it, which determines
 * the order in which vertices cross the sweep line.
 * @private
 * @param {libtess.GluTesselator} tess [description].
 */
libtess.sweep.initPriorityQ_ = function(tess) {
  var pq = new libtess.PriorityQ();
  tess.pq = pq;

  var vHead = tess.mesh.vHead;
  var v;
  for (v = vHead.next; v !== vHead; v = v.next) {
    v.pqHandle = pq.insert(v);
  }

  pq.init();
};


/**
 * [donePriorityQ_ description]
 * @private
 * @param {libtess.GluTesselator} tess [description].
 */
libtess.sweep.donePriorityQ_ = function(tess) {
  // TODO(bckenny): probably don't need deleteQ. check that function for comment
  tess.pq.deleteQ();
  tess.pq = null;
};


/**
 * Delete any degenerate faces with only two edges. walkDirtyRegions()
 * will catch almost all of these, but it won't catch degenerate faces
 * produced by splice operations on already-processed edges.
 * The two places this can happen are in finishLeftRegions(), when
 * we splice in a "temporary" edge produced by connectRightVertex(),
 * and in checkForLeftSplice(), where we splice already-processed
 * edges to ensure that our dictionary invariants are not violated
 * by numerical errors.
 *
 * In both these cases it is *very* dangerous to delete the offending
 * edge at the time, since one of the routines further up the stack
 * will sometimes be keeping a pointer to that edge.
 *
 * @private
 * @param {libtess.GluMesh} mesh [description].
 */
libtess.sweep.removeDegenerateFaces_ = function(mesh) {
  var fNext;
  for (var f = mesh.fHead.next; f !== mesh.fHead; f = fNext) {
    fNext = f.next;
    var e = f.anEdge;

    if (e.lNext.lNext === e) {
      // A face with only two edges
      libtess.sweep.addWinding_(e.oNext, e);
      libtess.mesh.deleteEdge(e);
    }
  }
};

/* global libtess */

/** @const */
libtess.tessmono = {};

/**
 * Tessellates a monotone region (what else would it do??). The region must
 * consist of a single loop of half-edges (see mesh.js) oriented CCW. "Monotone"
 * in this case means that any vertical line intersects the interior of the
 * region in a single interval.
 *
 * Tessellation consists of adding interior edges (actually pairs of
 * half-edges), to split the region into non-overlapping triangles.
 * @private
 * @param {!libtess.GluFace} face
 */
libtess.tessmono.tessellateMonoRegion_ = function(face) {
  /* The basic idea is explained in Preparata and Shamos (which I don't
   * have handy right now), although their implementation is more
   * complicated than this one. The are two edge chains, an upper chain
   * and a lower chain. We process all vertices from both chains in order,
   * from right to left.
   *
   * The algorithm ensures that the following invariant holds after each
   * vertex is processed: the untessellated region consists of two
   * chains, where one chain (say the upper) is a single edge, and
   * the other chain is concave. The left vertex of the single edge
   * is always to the left of all vertices in the concave chain.
   *
   * Each step consists of adding the rightmost unprocessed vertex to one
   * of the two chains, and forming a fan of triangles from the rightmost
   * of two chain endpoints. Determining whether we can add each triangle
   * to the fan is a simple orientation test. By making the fan as large
   * as possible, we restore the invariant (check it yourself).
   *
   * All edges are oriented CCW around the boundary of the region.
   * First, find the half-edge whose origin vertex is rightmost.
   * Since the sweep goes from left to right, face.anEdge should
   * be close to the edge we want.
   */
  var up = face.anEdge;

  for (; libtess.geom.vertLeq(up.dst(), up.org); up = up.lPrev()) { }
  for (; libtess.geom.vertLeq(up.org, up.dst()); up = up.lNext) { }

  var lo = up.lPrev();

  var tempHalfEdge;
  while (up.lNext !== lo) {
    if (libtess.geom.vertLeq(up.dst(), lo.org)) {
      // up.dst() is on the left. It is safe to form triangles from lo.org.
      // The edgeGoesLeft test guarantees progress even when some triangles
      // are CW, given that the upper and lower chains are truly monotone.
      while (lo.lNext !== up && (libtess.geom.edgeGoesLeft(lo.lNext) ||
          libtess.geom.edgeSign(lo.org, lo.dst(), lo.lNext.dst()) <= 0)) {

        tempHalfEdge = libtess.mesh.connect(lo.lNext, lo);
        lo = tempHalfEdge.sym;
      }
      lo = lo.lPrev();

    } else {
      // lo.org is on the left. We can make CCW triangles from up.dst().
      while (lo.lNext !== up && (libtess.geom.edgeGoesRight(up.lPrev()) ||
          libtess.geom.edgeSign(up.dst(), up.org, up.lPrev().org) >= 0)) {

        tempHalfEdge = libtess.mesh.connect(up, up.lPrev());
        up = tempHalfEdge.sym;
      }
      up = up.lNext;
    }
  }

  // Now lo.org == up.dst() == the leftmost vertex. The remaining region
  // can be tessellated in a fan from this leftmost vertex.
  while (lo.lNext.lNext !== up) {
    tempHalfEdge = libtess.mesh.connect(lo.lNext, lo);
    lo = tempHalfEdge.sym;
  }
};

/**
 * Tessellates each region of the mesh which is marked "inside" the polygon.
 * Each such region must be monotone.
 * @param {!libtess.GluMesh} mesh
 */
libtess.tessmono.tessellateInterior = function(mesh) {
  var next;
  for (var f = mesh.fHead.next; f !== mesh.fHead; f = next) {
    // Make sure we don't try to tessellate the new triangles.
    next = f.next;
    if (f.inside) {
      libtess.tessmono.tessellateMonoRegion_(f);
    }
  }
};

/**
 * Zaps (i.e. sets to null) all faces which are not marked "inside" the polygon.
 * Since further mesh operations on null faces are not allowed, the main purpose
 * is to clean up the mesh so that exterior loops are not represented in the
 * data structure.
 * @param {!libtess.GluMesh} mesh
 */
libtess.tessmono.discardExterior = function(mesh) {
  var next;
  for (var f = mesh.fHead.next; f !== mesh.fHead; f = next) {
    // Since f will be destroyed, save its next pointer.
    next = f.next;
    if (!f.inside) {
      libtess.mesh.zapFace(f);
    }
  }
};

/**
 * Resets the winding numbers on all edges so that regions marked "inside" the
 * polygon have a winding number of "value", and regions outside have a winding
 * number of 0.
 *
 * If keepOnlyBoundary is true, it also deletes all edges which do not separate
 * an interior region from an exterior one.
 *
 * @param {!libtess.GluMesh} mesh
 * @param {number} value
 * @param {boolean} keepOnlyBoundary
 */
libtess.tessmono.setWindingNumber = function(mesh, value, keepOnlyBoundary) {
  var eNext;
  for (var e = mesh.eHead.next; e !== mesh.eHead; e = eNext) {
    eNext = e.next;

    if (e.rFace().inside !== e.lFace.inside) {
      // This is a boundary edge (one side is interior, one is exterior).
      e.winding = (e.lFace.inside) ? value : -value;

    } else {
      // Both regions are interior, or both are exterior.
      if (!keepOnlyBoundary) {
        e.winding = 0;

      } else {
        libtess.mesh.deleteEdge(e);
      }
    }
  }
};

/* global libtess */

/**
 * A list of edges crossing the sweep line, sorted from top to bottom.
 * Implementation is a doubly-linked list, sorted by the injected edgeLeq
 * comparator function. Here it is a simple ordering, but see libtess.sweep for
 * the list of invariants on the edge dictionary this ordering creates.
 * @constructor
 * @struct
 * @param {!libtess.GluTesselator} frame
 * @param {function(!libtess.GluTesselator, !libtess.ActiveRegion, !libtess.ActiveRegion): boolean} leq
 */
libtess.Dict = function(frame, leq) {

  /**
   * The head of the doubly-linked DictNode list. At creation time, links back
   * and forward only to itself.
   * @private {!libtess.DictNode}
   */
  this.head_ = new libtess.DictNode();

  /**
   * The GluTesselator used as the frame for edge/event comparisons.
   * @private {!libtess.GluTesselator}
   */
  this.frame_ = frame;

  /**
   * Comparison function to maintain the invariants of the Dict. See
   * libtess.sweep.edgeLeq_ for source.
   * @private
   * @type {function(!libtess.GluTesselator, !libtess.ActiveRegion, !libtess.ActiveRegion): boolean}
   */
  this.leq_ = leq;
};

/* istanbul ignore next */
/**
 * Formerly used to delete the dict.
 * NOTE(bckenny): No longer called but left for memFree documentation. Nulled at
 * former callsite instead (sweep.doneEdgeDict_)
 * @private
 */
libtess.Dict.prototype.deleteDict_ = function() {
  // for (var node = this.head_.next; node !== this.head_; node = node.next) {
  //   memFree(node);
  // }
  // memFree(dict);
};

/**
 * Insert the supplied key into the edge list and return its new node.
 * @param {libtess.DictNode} node
 * @param {!libtess.ActiveRegion} key
 * @return {!libtess.DictNode}
 */
libtess.Dict.prototype.insertBefore = function(node, key) {
  do {
    node = node.prev;
  } while (node.key !== null && !this.leq_(this.frame_, node.key, key));

  // insert the new node and update the surrounding nodes to point to it
  var newNode = new libtess.DictNode(key, node.next, node);
  node.next.prev = newNode;
  node.next = newNode;

  return newNode;
};

/**
 * Insert key into the dict and return the new node that contains it.
 * @param {!libtess.ActiveRegion} key
 * @return {!libtess.DictNode}
 */
libtess.Dict.prototype.insert = function(key) {
  // NOTE(bckenny): from a macro in dict.h/dict-list.h
  return this.insertBefore(this.head_, key);
};

/**
 * Remove node from the list.
 * @param {libtess.DictNode} node
 */
libtess.Dict.prototype.deleteNode = function(node) {
  node.next.prev = node.prev;
  node.prev.next = node.next;

  // NOTE(bckenny): nulled at callsite (sweep.deleteRegion_)
  // memFree( node );
};

/**
 * Search returns the node with the smallest key greater than or equal
 * to the given key. If there is no such key, returns a node whose
 * key is null. Similarly, max(d).getSuccessor() has a null key, etc.
 * @param {!libtess.ActiveRegion} key
 * @return {!libtess.DictNode}
 */
libtess.Dict.prototype.search = function(key) {
  var node = this.head_;

  do {
    node = node.next;
  } while (node.key !== null && !this.leq_(this.frame_, key, node.key));

  return node;
};

/**
 * Return the node with the smallest key.
 * @return {!libtess.DictNode}
 */
libtess.Dict.prototype.getMin = function() {
  // NOTE(bckenny): from a macro in dict.h/dict-list.h
  return this.head_.next;
};

// NOTE(bckenny): libtess.Dict.getMax isn't called within libtess and isn't part
// of the public API. For now, leaving in but ignoring for coverage.
/* istanbul ignore next */
/**
 * Returns the node with the greatest key.
 * @return {!libtess.DictNode}
 */
libtess.Dict.prototype.getMax = function() {
  // NOTE(bckenny): from a macro in dict.h/dict-list.h
  return this.head_.prev;
};

/* global libtess */

/**
 * A doubly-linked-list node with a libtess.ActiveRegion payload.
 * The key for this node and the next and previous nodes in the parent Dict list
 * can be provided to insert it into an existing list (or all can be omitted if
 * this is to be the founding node of the list).
 * @param {!libtess.ActiveRegion=} opt_key
 * @param {!libtess.DictNode=} opt_nextNode
 * @param {!libtess.DictNode=} opt_prevNode
 * @constructor
 * @struct
 */
libtess.DictNode = function(opt_key, opt_nextNode, opt_prevNode) {
  /**
   * The ActiveRegion key for this node, or null if the head of the list.
   * @type {libtess.ActiveRegion}
   */
  this.key = opt_key || null;

  /**
   * Link to next DictNode in parent list or to self if this is the first node.
   * @type {!libtess.DictNode}
   */
  this.next = opt_nextNode || this;

  /**
   * Link to previous DictNode in parent list or to self if this is the first
   * node.
   * @type {!libtess.DictNode}
   */
  this.prev = opt_prevNode || this;
};

/**
 * Get the key from this node.
 * @return {libtess.ActiveRegion}
 */
libtess.DictNode.prototype.getKey = function() {
  return this.key;
};

/**
 * Get the successor node to this one.
 * @return {!libtess.DictNode}
 */
libtess.DictNode.prototype.getSuccessor = function() {
  return this.next;
};

/**
 * Get the predecessor node to this one.
 * @return {!libtess.DictNode}
 */
libtess.DictNode.prototype.getPredecessor = function() {
  return this.prev;
};

/* global libtess */

// TODO(bckenny): create more javascript-y API, e.g. make gluTessEndPolygon
// async, don't require so many temp objects created

/**
 * The tesselator main class, providing the public API.
 * @constructor
 * @struct
 */
libtess.GluTesselator = function() {
  // Only initialize fields which can be changed by the api. Other fields
  // are initialized where they are used.

  /*** state needed for collecting the input data ***/

  /**
   * Tesselator state, tracking what begin/end calls have been seen.
   * @private {libtess.GluTesselator.tessState_}
   */
  this.state_ = libtess.GluTesselator.tessState_.T_DORMANT;

  /**
   * lastEdge_.org is the most recent vertex
   * @private {libtess.GluHalfEdge}
   */
  this.lastEdge_ = null;

  /**
   * stores the input contours, and eventually the tessellation itself
   * @type {libtess.GluMesh}
   */
  this.mesh = null;

  /**
   * Error callback.
   * @private {?function((libtess.errorType|libtess.gluEnum), Object=)}
   */
  this.errorCallback_ = null;

  /*** state needed for projecting onto the sweep plane ***/

  /**
   * user-specified normal (if provided)
   * @private {!Array<number>}
   */
  this.normal_ = [0, 0, 0];

  /*** state needed for the line sweep ***/

  /**
   * rule for determining polygon interior
   * @type {libtess.windingRule}
   */
  this.windingRule = libtess.windingRule.GLU_TESS_WINDING_ODD;

  /**
   * fatal error: needed combine callback
   * @type {boolean}
   */
  this.fatalError = false;

  /**
   * edge dictionary for sweep line
   * @type {libtess.Dict}
   */
  this.dict = null;
  // NOTE(bckenny): dict initialized in sweep.initEdgeDict_, removed in sweep.doneEdgeDict_

  /**
   * priority queue of vertex events
   * @type {libtess.PriorityQ}
   */
  this.pq = null;
  // NOTE(bckenny): pq initialized in sweep.initPriorityQ

  /**
   * current sweep event being processed
   * @type {libtess.GluVertex}
   */
  this.event = null;

  /**
   * Combine callback.
   * @private {?function(Array<number>, Array<Object>, Array<number>, Object=): Object}
   */
  this.combineCallback_ = null;

  /*** state needed for rendering callbacks (see render.js) ***/

  /**
   * Extract contours, not triangles
   * @private {boolean}
   */
  this.boundaryOnly_ = false;

  /**
   * Begin callback.
   * @private {?function(libtess.primitiveType, Object=)}
   */
  this.beginCallback_ = null;

  /**
   * Edge flag callback.
   * @private {?function(boolean, Object=)}
   */
  this.edgeFlagCallback_ = null;

  /**
   * Vertex callback.
   * @private {?function(Object, Object=)}
   */
  this.vertexCallback_ = null;

  /**
   * End callback.
   * @private {?function(Object=)}
   */
  this.endCallback_ = null;

  /**
   * Mesh callback.
   * @private {?function(libtess.GluMesh)}
   */
  this.meshCallback_ = null;

  /**
   * client data for current polygon
   * @private {Object}
   */
  this.polygonData_ = null;
};

/**
 * The begin/end calls must be properly nested. We keep track of the current
 * state to enforce the ordering.
 * @enum {number}
 * @private
 */
libtess.GluTesselator.tessState_ = {
  T_DORMANT: 0,
  T_IN_POLYGON: 1,
  T_IN_CONTOUR: 2
};

/**
 * Destory the tesselator object. See README.
 */
libtess.GluTesselator.prototype.gluDeleteTess = function() {
  // TODO(bckenny): This does nothing but assert that it isn't called while
  // building the polygon since we rely on GC to handle memory. *If* the public
  // API changes, this should go.
  this.requireState_(libtess.GluTesselator.tessState_.T_DORMANT);
  // memFree(tess); TODO(bckenny)
};

/**
 * Set properties for control over tesselation. See README.
 * @param {libtess.gluEnum} which [description].
 * @param {number|boolean} value [description].
 */
libtess.GluTesselator.prototype.gluTessProperty = function(which, value) {
  // TODO(bckenny): split into more setters?
  // TODO(bckenny): in any case, we can do better than this switch statement

  switch (which) {
    case libtess.gluEnum.GLU_TESS_TOLERANCE:
      // NOTE(bckenny): libtess has never supported any tolerance but 0.
      return;

    case libtess.gluEnum.GLU_TESS_WINDING_RULE:
      var windingRule = /** @type {libtess.windingRule} */(value);

      switch (windingRule) {
        case libtess.windingRule.GLU_TESS_WINDING_ODD:
        case libtess.windingRule.GLU_TESS_WINDING_NONZERO:
        case libtess.windingRule.GLU_TESS_WINDING_POSITIVE:
        case libtess.windingRule.GLU_TESS_WINDING_NEGATIVE:
        case libtess.windingRule.GLU_TESS_WINDING_ABS_GEQ_TWO:
          this.windingRule = windingRule;
          return;
        default:
      }
      break;

    case libtess.gluEnum.GLU_TESS_BOUNDARY_ONLY:
      this.boundaryOnly_ = !!value;
      return;

    default:
      this.callErrorCallback(libtess.gluEnum.GLU_INVALID_ENUM);
      return;
  }
  this.callErrorCallback(libtess.gluEnum.GLU_INVALID_VALUE);
};

/**
 * Returns tessellator property
 * @param {libtess.gluEnum} which [description].
 * @return {number|boolean} [description].
 */
libtess.GluTesselator.prototype.gluGetTessProperty = function(which) {
  // TODO(bckenny): as above, split into more getters? and improve on switch statement
  // why are these being asserted in getter but not setter?

  switch (which) {
    case libtess.gluEnum.GLU_TESS_TOLERANCE:
      return 0;

    case libtess.gluEnum.GLU_TESS_WINDING_RULE:
      var rule = this.windingRule;
      return rule;

    case libtess.gluEnum.GLU_TESS_BOUNDARY_ONLY:
      return this.boundaryOnly_;

    default:
      this.callErrorCallback(libtess.gluEnum.GLU_INVALID_ENUM);
      break;
  }
  return false;
};

/**
 * Lets the user supply the polygon normal, if known. All input data is
 * projected into a plane perpendicular to the normal before tesselation. All
 * output triangles are oriented CCW with respect to the normal (CW orientation
 * can be obtained by reversing the sign of the supplied normal). For example,
 * if you know that all polygons lie in the x-y plane, call
 * `tess.gluTessNormal(0.0, 0.0, 1.0)` before rendering any polygons.
 * @param {number} x
 * @param {number} y
 * @param {number} z
 */
libtess.GluTesselator.prototype.gluTessNormal = function(x, y, z) {
  this.normal_[0] = x;
  this.normal_[1] = y;
  this.normal_[2] = z;
};

/**
 * Specify callbacks. See README for callback descriptions. A null or undefined
 * opt_fn removes current callback.
 * @param {libtess.gluEnum} which The callback-type gluEnum value.
 * @param {?Function=} opt_fn
 */
libtess.GluTesselator.prototype.gluTessCallback = function(which, opt_fn) {
  var fn = !opt_fn ? null : opt_fn;
  // TODO(bckenny): better opt_fn typing?
  // TODO(bckenny): should add documentation that references in callback are volatile (or make a copy)

  switch (which) {
    case libtess.gluEnum.GLU_TESS_BEGIN:
    case libtess.gluEnum.GLU_TESS_BEGIN_DATA:
      this.beginCallback_ = /** @type {?function(libtess.primitiveType, Object=)} */ (fn);
      return;

    case libtess.gluEnum.GLU_TESS_EDGE_FLAG:
    case libtess.gluEnum.GLU_TESS_EDGE_FLAG_DATA:
      this.edgeFlagCallback_ = /** @type {?function(boolean, Object=)} */ (fn);
      return;

    case libtess.gluEnum.GLU_TESS_VERTEX:
    case libtess.gluEnum.GLU_TESS_VERTEX_DATA:
      this.vertexCallback_ = /** @type {?function(Object, Object=)} */ (fn);
      return;

    case libtess.gluEnum.GLU_TESS_END:
    case libtess.gluEnum.GLU_TESS_END_DATA:
      this.endCallback_ = /** @type {?function(Object=)} */ (fn);
      return;

    case libtess.gluEnum.GLU_TESS_ERROR:
    case libtess.gluEnum.GLU_TESS_ERROR_DATA:
      this.errorCallback_ = /** @type {?function((libtess.errorType|libtess.gluEnum), Object=)} */ (fn);
      return;

    case libtess.gluEnum.GLU_TESS_COMBINE:
    case libtess.gluEnum.GLU_TESS_COMBINE_DATA:
      this.combineCallback_ = /** @type {?function(Array<number>, Array<Object>, Array<number>, Object=): Object} */ (fn);
      return;

    case libtess.gluEnum.GLU_TESS_MESH:
      this.meshCallback_ = /** @type {?function(libtess.GluMesh)} */ (fn);
      return;

    default:
      this.callErrorCallback(libtess.gluEnum.GLU_INVALID_ENUM);
      return;
  }
};

/**
 * Specify a vertex and associated data. Must be within calls to
 * beginContour/endContour. See README.
 * @param {!Array<number>} coords
 * @param {Object} data
 */
libtess.GluTesselator.prototype.gluTessVertex = function(coords, data) {
  var tooLarge = false;

  // TODO(bckenny): pool allocation?
  var clamped = [0, 0, 0];

  this.requireState_(libtess.GluTesselator.tessState_.T_IN_CONTOUR);

  for (var i = 0; i < 3; ++i) {
    var x = coords[i];
    if (x < -libtess.GLU_TESS_MAX_COORD) {
      x = -libtess.GLU_TESS_MAX_COORD;
      tooLarge = true;
    }
    if (x > libtess.GLU_TESS_MAX_COORD) {
      x = libtess.GLU_TESS_MAX_COORD;
      tooLarge = true;
    }
    clamped[i] = x;
  }

  if (tooLarge) {
    this.callErrorCallback(libtess.errorType.GLU_TESS_COORD_TOO_LARGE);
  }

  this.addVertex_(clamped, data);
};

/**
 * [gluTessBeginPolygon description]
 * @param {Object} data Client data for current polygon.
 */
libtess.GluTesselator.prototype.gluTessBeginPolygon = function(data) {
  this.requireState_(libtess.GluTesselator.tessState_.T_DORMANT);

  this.state_ = libtess.GluTesselator.tessState_.T_IN_POLYGON;

  this.mesh = new libtess.GluMesh();

  this.polygonData_ = data;
};

/**
 * [gluTessBeginContour description]
 */
libtess.GluTesselator.prototype.gluTessBeginContour = function() {
  this.requireState_(libtess.GluTesselator.tessState_.T_IN_POLYGON);

  this.state_ = libtess.GluTesselator.tessState_.T_IN_CONTOUR;
  this.lastEdge_ = null;
};

/**
 * [gluTessEndContour description]
 */
libtess.GluTesselator.prototype.gluTessEndContour = function() {
  this.requireState_(libtess.GluTesselator.tessState_.T_IN_CONTOUR);
  this.state_ = libtess.GluTesselator.tessState_.T_IN_POLYGON;
};

/**
 * [gluTessEndPolygon description]
 */
libtess.GluTesselator.prototype.gluTessEndPolygon = function() {
  this.requireState_(libtess.GluTesselator.tessState_.T_IN_POLYGON);
  this.state_ = libtess.GluTesselator.tessState_.T_DORMANT;

  // Determine the polygon normal and project vertices onto the plane
  // of the polygon.
  libtess.normal.projectPolygon(this, this.normal_[0], this.normal_[1],
      this.normal_[2]);

  // computeInterior(tess) computes the planar arrangement specified
  // by the given contours, and further subdivides this arrangement
  // into regions. Each region is marked "inside" if it belongs
  // to the polygon, according to the rule given by this.windingRule.
  // Each interior region is guaranteed be monotone.
  libtess.sweep.computeInterior(this);

  if (!this.fatalError) {
    // If the user wants only the boundary contours, we throw away all edges
    // except those which separate the interior from the exterior.
    // Otherwise we tessellate all the regions marked "inside".
    // NOTE(bckenny): we know this.mesh has been initialized, so help closure out.
    var mesh = /** @type {!libtess.GluMesh} */(this.mesh);
    if (this.boundaryOnly_) {
      libtess.tessmono.setWindingNumber(mesh, 1, true);
    } else {
      libtess.tessmono.tessellateInterior(mesh);
    }

    this.mesh.checkMesh();

    if (this.beginCallback_ || this.endCallback_ || this.vertexCallback_ ||
        this.edgeFlagCallback_) {

      if (this.boundaryOnly_) {
        // output boundary contours
        libtess.render.renderBoundary(this, this.mesh);

      } else {
        // output triangles (with edge callback if one is set)
        var flagEdges = !!this.edgeFlagCallback_;
        libtess.render.renderMesh(this, this.mesh, flagEdges);
      }
    }

    if (this.meshCallback_) {
      // Throw away the exterior faces, so that all faces are interior.
      // This way the user doesn't have to check the "inside" flag,
      // and we don't need to even reveal its existence. It also leaves
      // the freedom for an implementation to not generate the exterior
      // faces in the first place.
      libtess.tessmono.discardExterior(this.mesh);
      // user wants the mesh itself
      this.meshCallback_(this.mesh);

      this.mesh = null;
      this.polygonData_ = null;
      return;
    }
  }

  libtess.mesh.deleteMesh(this.mesh);
  this.polygonData_ = null;
  this.mesh = null;
};

/**
 * Change the tesselator state.
 * @private
 * @param {libtess.GluTesselator.tessState_} state
 */
libtess.GluTesselator.prototype.requireState_ = function(state) {
  if (this.state_ !== state) {
    this.gotoState_(state);
  }
};

/**
 * Change the current tesselator state one level at a time to get to the
 * desired state. Only triggered when the API is not called in the correct order
 * so an error callback is made, however the tesselator will always attempt to
 * recover afterwards (see README).
 * @private
 * @param {libtess.GluTesselator.tessState_} newState
 */
libtess.GluTesselator.prototype.gotoState_ = function(newState) {
  while (this.state_ !== newState) {
    if (this.state_ < newState) {
      switch (this.state_) {
        case libtess.GluTesselator.tessState_.T_DORMANT:
          this.callErrorCallback(
              libtess.errorType.GLU_TESS_MISSING_BEGIN_POLYGON);
          this.gluTessBeginPolygon(null);
          break;

        case libtess.GluTesselator.tessState_.T_IN_POLYGON:
          this.callErrorCallback(
              libtess.errorType.GLU_TESS_MISSING_BEGIN_CONTOUR);
          this.gluTessBeginContour();
          break;
      }

    } else {
      switch (this.state_) {
        case libtess.GluTesselator.tessState_.T_IN_CONTOUR:
          this.callErrorCallback(
              libtess.errorType.GLU_TESS_MISSING_END_CONTOUR);
          this.gluTessEndContour();
          break;

        case libtess.GluTesselator.tessState_.T_IN_POLYGON:
          this.callErrorCallback(
              libtess.errorType.GLU_TESS_MISSING_END_POLYGON);
          // NOTE(bckenny): libtess originally reset the tesselator, even though
          // the README claims it should spit out the tessellated results at
          // this point.
          // (see http://cgit.freedesktop.org/mesa/glu/tree/src/libtess/tess.c#n180)
          this.gluTessEndPolygon();
          break;
      }
    }
  }
};

/**
 * [addVertex_ description]
 * @private
 * @param {!Array<number>} coords [description].
 * @param {Object} data [description].
 */
libtess.GluTesselator.prototype.addVertex_ = function(coords, data) {
  var e = this.lastEdge_;
  if (e === null) {
    // Make a self-loop (one vertex, one edge).
    e = libtess.mesh.makeEdge(this.mesh);
    libtess.mesh.meshSplice(e, e.sym);

  } else {
    // Create a new vertex and edge which immediately follow e
    // in the ordering around the left face.
    libtess.mesh.splitEdge(e);
    e = e.lNext;
  }

  // The new vertex is now e.org.
  e.org.data = data;
  e.org.coords[0] = coords[0];
  e.org.coords[1] = coords[1];
  e.org.coords[2] = coords[2];

  // The winding of an edge says how the winding number changes as we
  // cross from the edge''s right face to its left face.  We add the
  // vertices in such an order that a CCW contour will add +1 to
  // the winding number of the region inside the contour.
  e.winding = 1;
  e.sym.winding = -1;

  this.lastEdge_ = e;
};

/**
 * Call callback to indicate the start of a primitive, to be followed by emitted
 * vertices, if any. In libtess.js, `type` will always be `GL_TRIANGLES`.
 * @param {libtess.primitiveType} type
 */
libtess.GluTesselator.prototype.callBeginCallback = function(type) {
  if (this.beginCallback_) {
    this.beginCallback_(type, this.polygonData_);
  }
};

/**
 * Call callback to emit a vertex of the tessellated polygon.
 * @param {Object} data
 */
libtess.GluTesselator.prototype.callVertexCallback = function(data) {
  if (this.vertexCallback_) {
    this.vertexCallback_(data, this.polygonData_);
  }
};

/**
 * Call callback to indicate whether the vertices to follow begin edges which
 * lie on a polygon boundary.
 * @param {boolean} flag
 */
libtess.GluTesselator.prototype.callEdgeFlagCallback = function(flag) {
  if (this.edgeFlagCallback_) {
    this.edgeFlagCallback_(flag, this.polygonData_);
  }
};

/**
 * Call callback to indicate the end of tessellation.
 */
libtess.GluTesselator.prototype.callEndCallback = function() {
  if (this.endCallback_) {
    this.endCallback_(this.polygonData_);
  }
};

/* jscs:disable maximumLineLength */
/**
 * Call callback for combining vertices at edge intersection requiring the
 * creation of a new vertex.
 * @param {!Array<number>} coords Intersection coordinates.
 * @param {!Array<Object>} data Array of vertex data, one per edge vertices.
 * @param {!Array<number>} weight Coefficients used for the linear combination of vertex coordinates that gives coords.
 * @return {?Object} Interpolated vertex.
 */
libtess.GluTesselator.prototype.callCombineCallback = function(coords, data, weight) {
  if (this.combineCallback_) {
    return this.combineCallback_(coords, data, weight, this.polygonData_) ||
        null;
  }

  return null;
};
/* jscs:enable maximumLineLength */

/**
 * Call error callback, if specified, with errno.
 * @param {(libtess.errorType|libtess.gluEnum)} errno
 */
libtess.GluTesselator.prototype.callErrorCallback = function(errno) {
  if (this.errorCallback_) {
    this.errorCallback_(errno, this.polygonData_);
  }
};

/* global libtess */

/**
 * Each face has a pointer to the next and previous faces in the
 * circular list, and a pointer to a half-edge with this face as
 * the left face (null if this is the dummy header). There is also
 * a field "data" for client data.
 *
 * @param {libtess.GluFace=} opt_nextFace
 * @param {libtess.GluFace=} opt_prevFace
 * @constructor
 * @struct
 */
libtess.GluFace = function(opt_nextFace, opt_prevFace) {
  // TODO(bckenny): reverse order of params?

  /**
   * next face (never null)
   * @type {!libtess.GluFace}
   */
  this.next = opt_nextFace || this;

  /**
   * previous face (never NULL)
   * @type {!libtess.GluFace}
   */
  this.prev = opt_prevFace || this;

  /**
   * A half edge with this left face.
   * @type {libtess.GluHalfEdge}
   */
  this.anEdge = null;

  /**
   * room for client's data
   * @type {Object}
   */
  this.data = null;

  /**
   * This face is in the polygon interior.
   * @type {boolean}
   */
  this.inside = false;
};

/* global libtess */

/**
 * The fundamental data structure is the "half-edge". Two half-edges
 * go together to make an edge, but they point in opposite directions.
 * Each half-edge has a pointer to its mate (the "symmetric" half-edge sym),
 * its origin vertex (org), the face on its left side (lFace), and the
 * adjacent half-edges in the CCW direction around the origin vertex
 * (oNext) and around the left face (lNext). There is also a "next"
 * pointer for the global edge list (see below).
 *
 * The notation used for mesh navigation:
 *  sym   = the mate of a half-edge (same edge, but opposite direction)
 *  oNext = edge CCW around origin vertex (keep same origin)
 *  dNext = edge CCW around destination vertex (keep same dest)
 *  lNext = edge CCW around left face (dest becomes new origin)
 *  rNext = edge CCW around right face (origin becomes new dest)
 *
 * "prev" means to substitute CW for CCW in the definitions above.
 *
 * The circular edge list is special; since half-edges always occur
 * in pairs (e and e.sym), each half-edge stores a pointer in only
 * one direction. Starting at eHead and following the e.next pointers
 * will visit each *edge* once (ie. e or e.sym, but not both).
 * e.sym stores a pointer in the opposite direction, thus it is
 * always true that e.sym.next.sym.next === e.
 *
 * @param {libtess.GluHalfEdge=} opt_nextEdge
 * @constructor
 * @struct
 */
libtess.GluHalfEdge = function(opt_nextEdge) {
  // TODO(bckenny): are these the right defaults? (from gl_meshNewMesh requirements)

  /**
   * doubly-linked list (prev==sym->next)
   * @type {!libtess.GluHalfEdge}
   */
  this.next = opt_nextEdge || this;

  // TODO(bckenny): how can this be required if created in pairs? move to factory creation only?
  /**
   * same edge, opposite direction
   * @type {libtess.GluHalfEdge}
   */
  this.sym = null;

  /**
   * next edge CCW around origin
   * @type {libtess.GluHalfEdge}
   */
  this.oNext = null;

  /**
   * next edge CCW around left face
   * @type {libtess.GluHalfEdge}
   */
  this.lNext = null;

  /**
   * origin vertex (oVertex too long)
   * @type {libtess.GluVertex}
   */
  this.org = null;

  /**
   * left face
   * @type {libtess.GluFace}
   */
  this.lFace = null;

  // Internal data (keep hidden)
  // NOTE(bckenny): can't be private, though...

  /**
   * a region with this upper edge (see sweep.js)
   * @type {libtess.ActiveRegion}
   */
  this.activeRegion = null;

  /**
   * change in winding number when crossing from the right face to the left face
   * @type {number}
   */
  this.winding = 0;
};

// NOTE(bckenny): the following came from macros in mesh
// TODO(bckenny): using methods as aliases for sym connections for now.
// not sure about this approach. getters? renames?


/**
 * [rFace description]
 * @return {libtess.GluFace} [description].
 */
libtess.GluHalfEdge.prototype.rFace = function() {
  return this.sym.lFace;
};


/**
 * [dst description]
 * @return {libtess.GluVertex} [description].
 */
libtess.GluHalfEdge.prototype.dst = function() {
  return this.sym.org;
};


/**
 * [oPrev description]
 * @return {libtess.GluHalfEdge} [description].
 */
libtess.GluHalfEdge.prototype.oPrev = function() {
  return this.sym.lNext;
};


/**
 * [lPrev description]
 * @return {libtess.GluHalfEdge} [description].
 */
libtess.GluHalfEdge.prototype.lPrev = function() {
  return this.oNext.sym;
};

// NOTE(bckenny): libtess.GluHalfEdge.dPrev is called nowhere in libtess and
// isn't part of the current public API. It could be useful for mesh traversal
// and manipulation if made public, however.
/* istanbul ignore next */
/**
 * The edge clockwise around destination vertex (keep same dest).
 * @return {libtess.GluHalfEdge}
 */
libtess.GluHalfEdge.prototype.dPrev = function() {
  return this.lNext.sym;
};


/**
 * [rPrev description]
 * @return {libtess.GluHalfEdge} [description].
 */
libtess.GluHalfEdge.prototype.rPrev = function() {
  return this.sym.oNext;
};


/**
 * [dNext description]
 * @return {libtess.GluHalfEdge} [description].
 */
libtess.GluHalfEdge.prototype.dNext = function() {
  return this.rPrev().sym;
};


// NOTE(bckenny): libtess.GluHalfEdge.rNext is called nowhere in libtess and
// isn't part of the current public API. It could be useful for mesh traversal
// and manipulation if made public, however.
/* istanbul ignore next */
/**
 * The edge CCW around the right face (origin of this becomes new dest).
 * @return {libtess.GluHalfEdge}
 */
libtess.GluHalfEdge.prototype.rNext = function() {
  return this.oPrev().sym;
};

/* global libtess */

/**
 * Creates a new mesh with no edges, no vertices,
 * and no loops (what we usually call a "face").
 *
 * @constructor
 * @struct
 */
libtess.GluMesh = function() {
  /**
   * dummy header for vertex list
   * @type {libtess.GluVertex}
   */
  this.vHead = new libtess.GluVertex();

  /**
   * dummy header for face list
   * @type {libtess.GluFace}
   */
  this.fHead = new libtess.GluFace();

  /**
   * dummy header for edge list
   * @type {libtess.GluHalfEdge}
   */
  this.eHead = new libtess.GluHalfEdge();

  /**
   * and its symmetric counterpart
   * @type {libtess.GluHalfEdge}
   */
  this.eHeadSym = new libtess.GluHalfEdge();

  // TODO(bckenny): better way to pair these?
  this.eHead.sym = this.eHeadSym;
  this.eHeadSym.sym = this.eHead;
};


// TODO(bckenny): #ifndef NDEBUG
/**
 * Checks mesh for self-consistency.
 */
libtess.GluMesh.prototype.checkMesh = function() {
  if (!libtess.DEBUG) {
    return;
  }

  var fHead = this.fHead;
  var vHead = this.vHead;
  var eHead = this.eHead;

  var e;

  // faces
  var f;
  var fPrev = fHead;
  for (fPrev = fHead; (f = fPrev.next) !== fHead; fPrev = f) {
    e = f.anEdge;
    do {
      e = e.lNext;
    } while (e !== f.anEdge);
  }

  // vertices
  var v;
  var vPrev = vHead;
  for (vPrev = vHead; (v = vPrev.next) !== vHead; vPrev = v) {
    e = v.anEdge;
    do {
      e = e.oNext;
    } while (e !== v.anEdge);
  }

  // edges
  var ePrev = eHead;
  for (ePrev = eHead; (e = ePrev.next) !== eHead; ePrev = e) {
  }
};

/* global libtess */

/**
 * Each vertex has a pointer to next and previous vertices in the
 * circular list, and a pointer to a half-edge with this vertex as
 * the origin (null if this is the dummy header). There is also a
 * field "data" for client data.
 * @param {libtess.GluVertex=} opt_nextVertex Optional reference to next vertex in the vertex list.
 * @param {libtess.GluVertex=} opt_prevVertex Optional reference to previous vertex in the vertex list.
 * @constructor
 * @struct
 */
libtess.GluVertex = function(opt_nextVertex, opt_prevVertex) {
  /**
   * Next vertex (never null).
   * @type {!libtess.GluVertex}
   */
  this.next = opt_nextVertex || this;

  /**
   * Previous vertex (never null).
   * @type {!libtess.GluVertex}
   */
  this.prev = opt_prevVertex || this;

  /**
   * A half-edge with this origin.
   * @type {libtess.GluHalfEdge}
   */
  this.anEdge = null;

  /**
   * The client's data.
   * @type {Object}
   */
  this.data = null;

  /**
   * The vertex location in 3D.
   * @type {!Array.<number>}
   */
  this.coords = [0, 0, 0];
  // TODO(bckenny): we may want to rethink coords, either eliminate (using s
  // and t and user data) or index into contiguous storage?

  /**
   * Component of projection onto the sweep plane.
   * @type {number}
   */
  this.s = 0;

  /**
   * Component of projection onto the sweep plane.
   * @type {number}
   */
  this.t = 0;

  /**
   * Handle to allow deletion from priority queue, or 0 if not yet inserted into
   * queue.
   * @type {libtess.PQHandle}
   */
  this.pqHandle = 0;
};

/* global libtess */

/**
 * A priority queue of vertices, ordered by libtess.geom.vertLeq, implemented
 * with a sorted array. Used for initial insertion of vertices (see
 * libtess.sweep.initPriorityQ_), sorted once, then it uses an internal
 * libtess.PriorityQHeap for any subsequently created vertices from
 * intersections.
 * @constructor
 * @struct
 */
libtess.PriorityQ = function() {
  /**
   * An unordered list of vertices that have been inserted in the queue, with
   * null in empty slots.
   * @private {Array<libtess.GluVertex>}
   */
  this.verts_ = [];

  /**
   * Array of indices into this.verts_, sorted by vertLeq over the addressed
   * vertices.
   * @private {Array<number>}
   */
  this.order_ = null;

  /**
   * The size of this queue, not counting any vertices stored in heap_.
   * @private {number}
   */
  this.size_ = 0;

  /**
   * Indicates that the queue has been initialized via init. If false, inserts
   * are fast insertions at the end of the verts_ array. If true, the verts_
   * array is sorted and subsequent inserts are done in the heap.
   * @private {boolean}
   */
  this.initialized_ = false;

  /**
   * A priority queue heap, used for faster insertions of vertices after verts_
   * has been sorted.
   * @private {libtess.PriorityQHeap}
   */
  this.heap_ = new libtess.PriorityQHeap();
};

/**
 * Release major storage memory used by priority queue.
 */
libtess.PriorityQ.prototype.deleteQ = function() {
  // TODO(bckenny): could instead clear most of these.
  this.heap_ = null;
  this.order_ = null;
  this.verts_ = null;
  // NOTE(bckenny): nulled at callsite (sweep.donePriorityQ_)
};

/**
 * Sort vertices by libtess.geom.vertLeq. Must be called before any method other
 * than insert is called to ensure correctness when removing or querying.
 */
libtess.PriorityQ.prototype.init = function() {
  // TODO(bckenny): reuse. in theory, we don't have to empty this, as access is
  // dictated by this.size_, but array.sort doesn't know that
  this.order_ = [];

  // Create an array of indirect pointers to the verts, so that
  // the handles we have returned are still valid.
  // TODO(bckenny): valid for when? it appears we can just store indexes into
  // verts_, but what did this mean?
  for (var i = 0; i < this.size_; i++) {
    this.order_[i] = i;
  }

  // sort the indirect pointers in descending order of the verts themselves
  // TODO(bckenny): make sure it's ok that verts[a] === verts[b] returns 1
  // TODO(bckenny): unstable sort means we may get slightly different polys in
  // different browsers, but only when passing in equal points
  // TODO(bckenny): make less awkward closure?
  var comparator = (function(verts) {
    return function(a, b) {
      return libtess.geom.vertLeq(verts[a], verts[b]) ? 1 : -1;
    };
  })(this.verts_);
  this.order_.sort(comparator);

  this.initialized_ = true;
  this.heap_.init();

  // NOTE(bckenny): debug assert of ordering of the verts_ array.
  if (libtess.DEBUG) {
    var p = 0;
    var r = p + this.size_ - 1;
    for (i = p; i < r; ++i) {
    }
  }
};

/**
 * Insert a vertex into the priority queue. Returns a PQHandle to refer to it,
 * which will never be 0.
 * @param {libtess.GluVertex} vert
 * @return {libtess.PQHandle}
 */
libtess.PriorityQ.prototype.insert = function(vert) {
  // NOTE(bckenny): originally returned LONG_MAX as alloc failure signal. no
  // longer does.
  if (this.initialized_) {
    return this.heap_.insert(vert);
  }

  var curr = this.size_++;

  this.verts_[curr] = vert;

  // Negative handles index the sorted array.
  return -(curr + 1);
};

/**
 * Removes the minimum vertex from the queue and returns it. If the queue is
 * empty, null will be returned.
 * @return {libtess.GluVertex}
 */
libtess.PriorityQ.prototype.extractMin = function() {
  if (this.size_ === 0) {
    return this.heap_.extractMin();
  }

  var sortMin = this.verts_[this.order_[this.size_ - 1]];
  if (!this.heap_.isEmpty()) {
    var heapMin = this.heap_.minimum();
    if (libtess.geom.vertLeq(heapMin, sortMin)) {
      return this.heap_.extractMin();
    }
  }

  do {
    --this.size_;
  } while (this.size_ > 0 && this.verts_[this.order_[this.size_ - 1]] === null);

  return sortMin;
};

/**
 * Returns the minimum vertex in the queue. If the queue is empty, null will be
 * returned.
 * @return {libtess.GluVertex}
 */
libtess.PriorityQ.prototype.minimum = function() {
  if (this.size_ === 0) {
    return this.heap_.minimum();
  }

  var sortMin = this.verts_[this.order_[this.size_ - 1]];
  if (!this.heap_.isEmpty()) {
    var heapMin = this.heap_.minimum();
    if (libtess.geom.vertLeq(heapMin, sortMin)) {
      return heapMin;
    }
  }

  return sortMin;
};

/**
 * Remove vertex with handle removeHandle from queue.
 * @param {libtess.PQHandle} removeHandle
 */
libtess.PriorityQ.prototype.remove = function(removeHandle) {
  if (removeHandle >= 0) {
    this.heap_.remove(removeHandle);
    return;
  }
  removeHandle = -(removeHandle + 1);

  this.verts_[removeHandle] = null;
  while (this.size_ > 0 && this.verts_[this.order_[this.size_ - 1]] === null) {
    --this.size_;
  }
};

/* global libtess */

/**
 * A priority queue of vertices, ordered by libtess.geom.vertLeq, implemented
 * with a binary heap. Used only within libtess.PriorityQ for prioritizing
 * vertices created by intersections (see libtess.sweep.checkForIntersect_).
 * @constructor
 * @struct
 */
libtess.PriorityQHeap = function() {
  /**
   * The heap itself. Active nodes are stored in the range 1..size, with the
   * minimum at 1. Each node stores only an index into verts_ and handles_.
   * @private {!Array<number>}
   */
  this.heap_ = libtess.PriorityQHeap.reallocNumeric_([0],
      libtess.PriorityQHeap.INIT_SIZE_ + 1);

  /**
   * An unordered list of vertices in the heap, with null in empty slots.
   * @private {!Array<libtess.GluVertex>}
   */
  this.verts_ = [null, null];

  /**
   * An unordered list of indices mapping vertex handles into the heap. An entry
   * at index i will map the vertex at i in verts_ to its place in the heap
   * (i.e. heap_[handles_[i]] === i).
   * Empty slots below size_ are a free list chain starting at freeList_.
   * @private {!Array<number>}
   */
  this.handles_ = [0, 0];

  /**
   * The size of the queue.
   * @private {number}
   */
  this.size_ = 0;

  /**
   * The queue's current allocated space.
   * @private {number}
   */
  this.max_ = libtess.PriorityQHeap.INIT_SIZE_;

  /**
   * The index of the next free hole in the verts_ array. That slot in handles_
   * has the next index in the free list. If there are no holes, freeList_ === 0
   * and a new vertex must be appended to the list.
   * @private {libtess.PQHandle}
   */
  this.freeList_ = 0;

  /**
   * Indicates that the heap has been initialized via init. If false, inserts
   * are fast insertions at the end of a list. If true, all inserts will now be
   * correctly ordered in the queue before returning.
   * @private {boolean}
   */
  this.initialized_ = false;

  // Point the first index at the first (currently null) vertex.
  this.heap_[1] = 1;
};

/**
 * The initial allocated space for the queue.
 * @const
 * @private {number}
 */
libtess.PriorityQHeap.INIT_SIZE_ = 32;

/**
 * Allocate a numeric index array of size size. oldArray's contents are copied
 * to the beginning of the new array. The rest of the array is filled with
 * zeroes.
 * @private
 * @param {!Array<number>} oldArray
 * @param {number} size
 * @return {!Array<number>}
 */
libtess.PriorityQHeap.reallocNumeric_ = function(oldArray, size) {
  var newArray = new Array(size);

  // NOTE(bckenny): V8 likes this significantly more than simply growing the
  // array element-by-element or expanding the existing array all at once, so,
  // for now, emulating realloc.
  for (var index = 0; index < oldArray.length; index++) {
    newArray[index] = oldArray[index];
  }

  for (; index < size; index++) {
    newArray[index] = 0;
  }

  return newArray;
};

/**
 * Initializing ordering of the heap. Must be called before any method other
 * than insert is called to ensure correctness when removing or querying.
 */
libtess.PriorityQHeap.prototype.init = function() {
  // This method of building a heap is O(n), rather than O(n lg n).
  for (var i = this.size_; i >= 1; --i) {
    // TODO(bckenny): since init is called before anything is inserted (see
    // PriorityQ.init), this will always be empty. Better to lazily init?
    this.floatDown_(i);
  }

  this.initialized_ = true;
};

/**
 * Insert a new vertex into the heap.
 * @param {libtess.GluVertex} vert The vertex to insert.
 * @return {libtess.PQHandle} A handle that can be used to remove the vertex.
 */
libtess.PriorityQHeap.prototype.insert = function(vert) {
  var endIndex = ++this.size_;

  // If the heap overflows, double its size.
  if ((endIndex * 2) > this.max_) {
    this.max_ *= 2;

    this.handles_ = libtess.PriorityQHeap.reallocNumeric_(this.handles_,
        this.max_ + 1);
  }

  var newVertSlot;
  if (this.freeList_ === 0) {
    // No free slots, append vertex.
    newVertSlot = endIndex;
  } else {
    // Put vertex in free slot, update freeList_ to next free slot.
    newVertSlot = this.freeList_;
    this.freeList_ = this.handles_[this.freeList_];
  }

  this.verts_[newVertSlot] = vert;
  this.handles_[newVertSlot] = endIndex;
  this.heap_[endIndex] = newVertSlot;

  if (this.initialized_) {
    this.floatUp_(endIndex);
  }
  return newVertSlot;
};

/**
 * @return {boolean} Whether the heap is empty.
 */
libtess.PriorityQHeap.prototype.isEmpty = function() {
  return this.size_ === 0;
};

/**
 * Returns the minimum vertex in the heap. If the heap is empty, null will be
 * returned.
 * @return {libtess.GluVertex}
 */
libtess.PriorityQHeap.prototype.minimum = function() {
  return this.verts_[this.heap_[1]];
};

/**
 * Removes the minimum vertex from the heap and returns it. If the heap is
 * empty, null will be returned.
 * @return {libtess.GluVertex}
 */
libtess.PriorityQHeap.prototype.extractMin = function() {
  var heap = this.heap_;
  var verts = this.verts_;
  var handles = this.handles_;

  var minHandle = heap[1];
  var minVertex = verts[minHandle];

  if (this.size_ > 0) {
    // Replace min with last vertex.
    heap[1] = heap[this.size_];
    handles[heap[1]] = 1;

    // Clear min vertex and put slot at front of freeList_.
    verts[minHandle] = null;
    handles[minHandle] = this.freeList_;
    this.freeList_ = minHandle;

    // Restore heap.
    if (--this.size_ > 0) {
      this.floatDown_(1);
    }
  }

  return minVertex;
};

/**
 * Remove vertex with handle removeHandle from heap.
 * @param {libtess.PQHandle} removeHandle
 */
libtess.PriorityQHeap.prototype.remove = function(removeHandle) {
  var heap = this.heap_;
  var verts = this.verts_;
  var handles = this.handles_;

  var heapIndex = handles[removeHandle];

  // Replace with last vertex.
  heap[heapIndex] = heap[this.size_];
  handles[heap[heapIndex]] = heapIndex;

  // Restore heap.
  if (heapIndex <= --this.size_) {
    if (heapIndex <= 1) {
      this.floatDown_(heapIndex);
    } else {
      var vert = verts[heap[heapIndex]];
      var parentVert = verts[heap[heapIndex >> 1]];
      if (libtess.geom.vertLeq(parentVert, vert)) {
        this.floatDown_(heapIndex);
      } else {
        this.floatUp_(heapIndex);
      }
    }
  }

  // Clear vertex and put slot at front of freeList_.
  verts[removeHandle] = null;
  handles[removeHandle] = this.freeList_;
  this.freeList_ = removeHandle;
};

/**
 * Restore heap by moving the vertex at index in the heap downwards to a valid
 * slot.
 * @private
 * @param {libtess.PQHandle} index
 */
libtess.PriorityQHeap.prototype.floatDown_ = function(index) {
  var heap = this.heap_;
  var verts = this.verts_;
  var handles = this.handles_;

  var currIndex = index;
  var currHandle = heap[currIndex];
  for (;;) {
    // The children of node i are nodes 2i and 2i+1.
    var childIndex = currIndex << 1;
    if (childIndex < this.size_) {
      // Set child to the index of the child with the minimum vertex.
      if (libtess.geom.vertLeq(verts[heap[childIndex + 1]],
          verts[heap[childIndex]])) {
        childIndex = childIndex + 1;
      }
    }

    var childHandle = heap[childIndex];
    if (childIndex > this.size_ ||
        libtess.geom.vertLeq(verts[currHandle], verts[childHandle])) {
      // Heap restored.
      heap[currIndex] = currHandle;
      handles[currHandle] = currIndex;
      return;
    }

    // Swap current node and child; repeat from childIndex.
    heap[currIndex] = childHandle;
    handles[childHandle] = currIndex;
    currIndex = childIndex;
  }
};

/**
 * Restore heap by moving the vertex at index in the heap upwards to a valid
 * slot.
 * @private
 * @param {libtess.PQHandle} index
 */
libtess.PriorityQHeap.prototype.floatUp_ = function(index) {
  var heap = this.heap_;
  var verts = this.verts_;
  var handles = this.handles_;

  var currIndex = index;
  var currHandle = heap[currIndex];
  for (;;) {
    // The parent of node i is node floor(i/2).
    var parentIndex = currIndex >> 1;
    var parentHandle = heap[parentIndex];

    if (parentIndex === 0 ||
        libtess.geom.vertLeq(verts[parentHandle], verts[currHandle])) {
      // Heap restored.
      heap[currIndex] = currHandle;
      handles[currHandle] = currIndex;
      return;
    }

    // Swap current node and parent; repeat from parentIndex.
    heap[currIndex] = parentHandle;
    handles[parentHandle] = currIndex;
    currIndex = parentIndex;
  }
};

/* global libtess */

// TODO(bckenny): apparently only visible outside of sweep for debugging routines.
// find out if we can hide

/**
 * For each pair of adjacent edges crossing the sweep line, there is
 * an ActiveRegion to represent the region between them. The active
 * regions are kept in sorted order in a dynamic dictionary. As the
 * sweep line crosses each vertex, we update the affected regions.
 * @constructor
 * @struct
 */
libtess.ActiveRegion = function() {
  // TODO(bckenny): I *think* eUp and nodeUp could be passed in as constructor params

  /**
   * The upper edge of the region, directed right to left
   * @type {libtess.GluHalfEdge}
   */
  this.eUp = null;

  /**
   * Dictionary node corresponding to eUp edge.
   * @type {libtess.DictNode}
   */
  this.nodeUp = null;

  /**
   * Used to determine which regions are inside the polygon.
   * @type {number}
   */
  this.windingNumber = 0;

  /**
   * Whether this region is inside the polygon.
   * @type {boolean}
   */
  this.inside = false;

  /**
   * Marks fake edges at t = +/-infinity.
   * @type {boolean}
   */
  this.sentinel = false;

  /**
   * Marks regions where the upper or lower edge has changed, but we haven't
   * checked whether they intersect yet.
   * @type {boolean}
   */
  this.dirty = false;

  /**
   * marks temporary edges introduced when we process a "right vertex" (one
   * without any edges leaving to the right)
   * @type {boolean}
   */
  this.fixUpperEdge = false;
};

/**
 * Returns the ActiveRegion below this one.
 * @return {libtess.ActiveRegion}
 */
libtess.ActiveRegion.prototype.regionBelow = function() {
  return this.nodeUp.getPredecessor().getKey();
};

/**
 * Returns the ActiveRegion above this one.
 * @return {libtess.ActiveRegion}
 */
libtess.ActiveRegion.prototype.regionAbove = function() {
  return this.nodeUp.getSuccessor().getKey();
};

/* global libtess, module */

/**
 * node.js export for non-compiled source
 */
if (true) {
  module.exports = libtess;
}


/***/ }),

/***/ 1626:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Fields_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(4598);
/* harmony import */ var _X3DExecutionContext_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(7493);
/* harmony import */ var _NamedNodesHandling_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(1168);
/* harmony import */ var _Configuration_ComponentInfo_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(4804);
/* harmony import */ var _Configuration_ComponentInfoArray_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(4547);
/* harmony import */ var _Configuration_UnitInfo_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(2605);
/* harmony import */ var _Configuration_UnitInfoArray_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(712);
/* harmony import */ var _X3DExportedNode_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(6491);
/* harmony import */ var _ExportedNodesArray_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(2502);
/* harmony import */ var _Base_X3DCast_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(7638);
/* harmony import */ var _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(2212);
/* harmony import */ var _Fields_SFNodeCache_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(6015);
/* harmony import */ var _LATEST_VERSION_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(4828);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(717);














const
   _specificationVersion = Symbol (),
   _encoding             = Symbol (),
   _profile              = Symbol (),
   _components           = Symbol (),
   _worldURL             = Symbol (),
   _units                = Symbol (),
   _metadata             = Symbol (),
   _exportedNodes        = Symbol (),
   _loadingObjects       = Symbol ();

function X3DScene (browser)
{
   _X3DExecutionContext_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .call (this, null, null, browser);

   this .addType (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_10__/* ["default"] */ .A .X3DScene)

   this .addChildObjects (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_10__/* ["default"] */ .A .outputOnly, "profile_changed",  new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFTime (),
                          _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_10__/* ["default"] */ .A .outputOnly, "metadata_changed", new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFTime (),
                          _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_10__/* ["default"] */ .A .outputOnly, "loadCount",        new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFInt32 ())

   this .getRootNodes () .setAccessType (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_10__/* ["default"] */ .A .inputOutput);

   this .setLive (false);

   // Private properties

   this [_specificationVersion] = _LATEST_VERSION_js__WEBPACK_IMPORTED_MODULE_12__/* ["default"] */ .A;
   this [_encoding]             = "SCRIPTED";
   this [_profile]              = null;
   this [_components]           = new _Configuration_ComponentInfoArray_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A ([ ]);
   this [_worldURL]             = location .toString ();
   this [_units]                = new _Configuration_UnitInfoArray_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A ();

   this [_units] .add ("angle",  new _Configuration_UnitInfo_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A ("angle",  "radian",   1));
   this [_units] .add ("force",  new _Configuration_UnitInfo_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A ("force",  "newton",   1));
   this [_units] .add ("length", new _Configuration_UnitInfo_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A ("length", "metre",    1));
   this [_units] .add ("mass",   new _Configuration_UnitInfo_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A ("mass",   "kilogram", 1));

   this [_metadata]       = [ ];
   this [_exportedNodes]  = new _ExportedNodesArray_js__WEBPACK_IMPORTED_MODULE_8__/* ["default"] */ .A ();
   this [_loadingObjects] = new Set ();

   this [_components]    .addParent (this);
   this [_units]         .addParent (this);
   this [_exportedNodes] .addParent (this);
}

Object .assign (Object .setPrototypeOf (X3DScene .prototype, _X3DExecutionContext_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .prototype),
{
   getLocalScene ()
   {
      return this;
   },
   setSpecificationVersion (specificationVersion)
   {
      this [_specificationVersion] = String (specificationVersion);
   },
   getSpecificationVersion ()
   {
      return this [_specificationVersion];
   },
   setEncoding (encoding)
   {
      this [_encoding] = String (encoding);
   },
   getEncoding ()
   {
      return this [_encoding];
   },
   setWorldURL (url)
   {
      this [_worldURL] = String (url);
   },
   getWorldURL ()
   {
      return this [_worldURL];
   },
   getBaseURL ()
   {
      if (this [_worldURL] .match (/^(?:data|blob):/))
      {
         return this .getExecutionContext () ?.getBaseURL ()
            ?? this .getBrowser () .getBaseURL ();
      }

      return this [_worldURL];
   },
   setProfile (profile)
   {
      this [_profile] = profile;

      this ._profile_changed = Date .now () / 1000;
   },
   getProfile ()
   {
      return this [_profile];
   },
   hasComponent (name, level = 0)
   {
      if (name instanceof _Configuration_ComponentInfo_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A)
         var { name, level } = name;

      const
         browser = this .getBrowser (),
         profile = this [_profile] ?? browser .getProfile ("Full");

      return [profile .components .get (name), this [_components] .get (name)]
         .some (component => component && level <= component .level);
   },
   addComponent (component)
   {
      this [_components] .add (component .name, component);

      this ._components_changed = Date .now () / 1000;
   },
   updateComponent (component)
   {
      this [_components] .update (component .name, component .name, component);

      this ._components_changed = Date .now () / 1000;
   },
   removeComponent (name)
   {
      this [_components] .remove (name);

      this ._components_changed = Date .now () / 1000;
   },
   getComponents ()
   {
      return this [_components];
   },
   updateUnit (category, name, conversionFactor)
   {
      // Private function.

      if (!this [_units] .has (category))
         return;

      this [_units] .update (category, category, new _Configuration_UnitInfo_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A (category, String (name),  Number (conversionFactor)));

      this ._units_changed = Date .now () / 1000;
   },
   getUnit (category)
   {
      return this [_units] .get (category);
   },
   getUnits ()
   {
      return this [_units];
   },
   fromUnit (category, value)
   {
      switch (category)
      {
         // Base units

         case "angle":
         case "force":
         case "length":
         case "mass":
            return value * this .getUnits () .get (category) .conversionFactor;

         // Derived units

         case "acceleration:":
            return value * this .getUnits () .get ("length") .conversionFactor;
         case "angularRate":
            return value * this .getUnits () .get ("angle") .conversionFactor;
         case "area":
            return value * this .getUnits () .get ("length") .conversionFactor ** 2;
         case "speed":
            return value * this .getUnits () .get ("length") .conversionFactor;
         case "volume":
            return value * this .getUnits () .get ("length") .conversionFactor ** 3;
      }

      return value;
   },
   toUnit (category, value)
   {
      switch (category)
      {
         // Base units

         case "angle":
         case "force":
         case "length":
         case "mass":
            return value / this .getUnits () .get (category) .conversionFactor;

         // Derived units

         case "acceleration:":
            return value / this .getUnits () .get ("length") .conversionFactor;
         case "angularRate":
            return value / this .getUnits () .get ("angle") .conversionFactor;
         case "area":
            return value / this .getUnits () .get ("length") .conversionFactor ** 2;
         case "speed":
            return value / this .getUnits () .get ("length") .conversionFactor;
         case "volume":
            return value / this .getUnits () .get ("length") .conversionFactor ** 3;
      }

      return value;
   },
   setMetaData (name, values)
   {
      name   = String (name);
      values = Array .isArray (values) ? values .map (String) : [String (values)];

      if (!name .length)
         throw new Error ("Couldn't add metadata: name is empty.");

      let index = this [_metadata] .findIndex (entry => entry [0] === name);

      this .removeMetaData (name);

      if (index === -1)
         index = this [_metadata] .length;

      for (const [i, value] of values .entries ())
         this [_metadata] .splice (index + i, 0, [name, value]);

      this ._metadata_changed = Date .now () / 1000;
   },
   addMetaData (name, values)
   {
      name   = String (name);
      values = Array .isArray (values) ? values .map (String) : [String (values)];

      if (!name .length)
         throw new Error ("Couldn't add metadata: name is empty.");

      for (const value of values)
         this [_metadata] .push ([name, value]);

      this ._metadata_changed = Date .now () / 1000;
   },
   removeMetaData (name)
   {
      name = String (name);

      this [_metadata] = this [_metadata] .filter (entry => entry [0] !== name);

      this ._metadata_changed = Date .now () / 1000;
   },
   getMetaData (name)
   {
      name = String (name);

      const values = this [_metadata]
         .filter (entry => entry [0] === name)
         .map (entry => entry [1]);

      if (values .length)
         return values;

      return undefined;
   },
   getMetaDatas ()
   {
      return this [_metadata] .map (entry => entry .slice ());
   },
   addExportedNode (exportedName, node)
   {
      exportedName = String (exportedName);

      if (this [_exportedNodes] .has (exportedName))
         throw new Error (`Couldn't add exported node: exported name '${exportedName}' already in use.`);

      this .updateExportedNode (exportedName, node);

      this ._sceneGraph_changed = Date .now () / 1000;
   },
   updateExportedNode (exportedName, node)
   {
      exportedName = String (exportedName);
      node         = (0,_Base_X3DCast_js__WEBPACK_IMPORTED_MODULE_9__/* ["default"] */ .A) (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_10__/* ["default"] */ .A .X3DNode, node, false);

      if (exportedName .length === 0)
         throw new Error ("Couldn't update exported node: node exported name is empty.");

      if (!node)
         throw new Error ("Couldn't update exported node: node must be of type X3DNode.");

      //if (node .getExecutionContext () !== this)
      //   throw new Error ("Couldn't update exported node: node does not belong to this execution context.");

      const exportedNode = new _X3DExportedNode_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A (this, exportedName, node);

      this [_exportedNodes] .update (exportedName, exportedName, exportedNode);

      this ._sceneGraph_changed = Date .now () / 1000;
   },
   removeExportedNode (exportedName)
   {
      exportedName = String (exportedName);

      this [_exportedNodes] .remove (exportedName);

      this ._sceneGraph_changed = Date .now () / 1000;
   },
   getExportedNode (exportedName)
   {
      exportedName = String (exportedName);

      const exportedNode = this [_exportedNodes] .get (exportedName);

      if (exportedNode)
         return exportedNode .localNode;

      throw new Error (`Exported node '${exportedName}' not found.`);
   },
   getExportedNodes ()
   {
      return this [_exportedNodes];
   },
   getUniqueExportName (name)
   {
      return (0,_NamedNodesHandling_js__WEBPACK_IMPORTED_MODULE_2__/* .getUniqueName */ .l) (this [_exportedNodes], name);
   },
   addRootNode (node)
   {
      node = _Fields_SFNodeCache_js__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A .get ((0,_Base_X3DCast_js__WEBPACK_IMPORTED_MODULE_9__/* ["default"] */ .A) (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_10__/* ["default"] */ .A .X3DNode, node, false));

      const rootNodes = this .getRootNodes ();

      if (rootNodes .includes (node))
         return;

      rootNodes .push (node);
   },
   removeRootNode (node)
   {
      node = _Fields_SFNodeCache_js__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A .get ((0,_Base_X3DCast_js__WEBPACK_IMPORTED_MODULE_9__/* ["default"] */ .A) (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_10__/* ["default"] */ .A .X3DNode, node, false));

      const rootNodes = this .getRootNodes ();

      rootNodes .assign (rootNodes .filter (rootNode => rootNode !== node));
   },
   setRootNodes (value)
   {
      this .getRootNodes () .assign (value);
   },
   toVRMLStream (generator)
   {
      generator .string += generator .Indent ();
      generator .string += "#X3D V";
      generator .string += _LATEST_VERSION_js__WEBPACK_IMPORTED_MODULE_12__/* ["default"] */ .A;
      generator .string += generator .Space ();
      generator .string += "utf8";
      generator .string += generator .Space ();
      generator .string += this .getBrowser () .name;
      generator .string += generator .Space ();
      generator .string += "V";
      generator .string += this .getBrowser () .version;
      generator .string += generator .ForceBreak ();
      generator .string += generator .ForceBreak ();

      const profile = this .getProfile ();

      if (profile)
      {
         profile .toVRMLStream (generator);

         generator .string += generator .Break ();
         generator .string += generator .TidyBreak ();
      }

      const components = this .getComponents ();

      if (components .length)
      {
         components .toVRMLStream (generator);

         generator .string += generator .TidyBreak ();
      }

      const units = this .getUnits () .filter (unit => unit .conversionFactor !== 1);

      if (units .length)
      {
         for (const unit of units)
         {
            unit .toVRMLStream (generator);

            generator .string += generator .Break ();
         }

         generator .string += generator .TidyBreak ();
      }

      const metadata = this .getMetaDatas ();

      if (metadata .length)
      {
         for (const [key, value] of metadata)
         {
            generator .string += generator .Indent ();
            generator .string += "META";
            generator .string += generator .Space ();
            generator .string += new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFString (key) .toString ();
            generator .string += generator .Space ();
            generator .string += new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFString (value) .toString ();
            generator .string += generator .Break ();
         }

         generator .string += generator .TidyBreak ();
      }

      const exportedNodes = this .getExportedNodes ();

      generator .PushExecutionContext (this);
      generator .EnterScope ();
      generator .ExportedNodes (exportedNodes);

      _X3DExecutionContext_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .prototype .toVRMLStream .call (this, generator);

      if (exportedNodes .length)
      {
         generator .string += generator .TidyBreak ();

         exportedNodes .toVRMLStream (generator);
      }

      generator .LeaveScope ();
      generator .PopExecutionContext ();
   },
   toXMLStream (generator)
   {
      if (!generator .html)
      {
         generator .string += generator .Indent ();
         generator .string += "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
         generator .string += generator .TidyBreak ();
         generator .string += generator .Indent ();
         generator .string += "<!DOCTYPE X3D PUBLIC \"ISO//Web3D//DTD X3D ";
         generator .string += _LATEST_VERSION_js__WEBPACK_IMPORTED_MODULE_12__/* ["default"] */ .A;
         generator .string += "//EN\" \"https://www.web3d.org/specifications/x3d-";
         generator .string += _LATEST_VERSION_js__WEBPACK_IMPORTED_MODULE_12__/* ["default"] */ .A;
         generator .string += ".dtd\">";
         generator .string += generator .TidyBreak ();
      }

      generator .openTag ("X3D");
      generator .attribute ("profile",   this .getProfile () ?.name ?? "Full");
      generator .attribute ("version",   _LATEST_VERSION_js__WEBPACK_IMPORTED_MODULE_12__/* ["default"] */ .A);
      generator .attribute ("xmlns:xsd", "http://www.w3.org/2001/XMLSchema-instance");
      generator .attribute ("xsd:noNamespaceSchemaLocation", `https://www.web3d.org/specifications/x3d-${_LATEST_VERSION_js__WEBPACK_IMPORTED_MODULE_12__/* ["default"] */ .A}.xsd`);

      generator .endTag ();
      generator .IncIndent ();

      const metadata = this .getMetaDatas ();

      if (this .getComponents () .length ||
          this .getUnits () .some (unit => unit .conversionFactor !== 1) ||
          metadata .length)
      {
         generator .openingTag ("head");
         generator .AddTidyBreak ();
         generator .IncIndent ();

         // <head>

         this .getComponents () .toXMLStream (generator);

         for (const unit of this .getUnits ())
         {
            if (unit .conversionFactor !== 1)
            {
               unit .toXMLStream (generator);
               generator .AddTidyBreak ();
            }
         }

         for (const [key, value] of metadata)
         {
            generator .openTag ("meta");
            generator .attribute ("name",    key);
            generator .attribute ("content", value);
            generator .closeTag ("meta");
            generator .AddTidyBreak ();
         }

         // </head>

         generator .DecIndent ();
         generator .closingTag ("head");
         generator .AddTidyBreak ();
      }

      if (this .getExternProtoDeclarations () .length ||
          this .getProtoDeclarations () .length ||
          this .getRootNodes () .length)
      {
         generator .openingTag ("Scene");
         generator .AddTidyBreak ();
         generator .IncIndent ();

         // <Scene>

         const exportedNodes = this .getExportedNodes ();

         generator .PushExecutionContext (this);
         generator .EnterScope ();
         generator .ExportedNodes (exportedNodes);

         _X3DExecutionContext_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .prototype .toXMLStream .call (this, generator);

         exportedNodes .toXMLStream (generator);

         generator .LeaveScope ();
         generator .PopExecutionContext ();
         generator .DecIndent ();
      }

      generator .closingTag ("Scene");
      generator .AddTidyBreak ();
      generator .DecIndent ();
      generator .closingTag ("X3D");
      generator .AddTidyBreak ();
   },
   toJSONStream (generator)
   {
      // X3D

      generator .beginObject ("X3D", false, true);
      generator .stringProperty ("encoding", "UTF-8", false);
      generator .stringProperty ("@profile", this .getProfile () ?.name ?? "Full");
      generator .stringProperty ("@version", _LATEST_VERSION_js__WEBPACK_IMPORTED_MODULE_12__/* ["default"] */ .A);
      generator .stringProperty ("@xsd:noNamespaceSchemaLocation", `https://www.web3d.org/specifications/x3d-${_LATEST_VERSION_js__WEBPACK_IMPORTED_MODULE_12__/* ["default"] */ .A}.xsd`);
      generator .stringProperty ("JSON schema", `https://www.web3d.org/specifications/x3d-${_LATEST_VERSION_js__WEBPACK_IMPORTED_MODULE_12__/* ["default"] */ .A}-JSONSchema.json`);

      // Head

      const
         outputUnits = this .getUnits () .some (unit => unit .conversionFactor !== 1),
         metadata    = this .getMetaDatas ();

      if (this .getComponents () .length || outputUnits || metadata .length)
      {
         let headLastProperty = false;

         generator .beginObject ("head");

         // Meta data

         if (metadata .length)
         {
            // Meta data begin

            generator .beginArray ("meta", headLastProperty);

            // Meta data

            for (const [i, [key, value]] of metadata .entries ())
            {
               generator .beginObject ("", i !== 0);
               generator .stringProperty ("@name",    key, false);
               generator .stringProperty ("@content", value);
               generator .endObject ();
            }

            // Meta data end

            generator .endArray ();

            headLastProperty = true;
         }

         // Components

         if (this .getComponents () .length)
         {
            generator .beginArray ("component", headLastProperty);

            this .getComponents () .toJSONStream (generator);

            generator .endArray ();

            headLastProperty = true;
         }

         // Units

         if (outputUnits)
         {
            generator .beginArray ("unit", headLastProperty);

            this .getUnits () .toJSONStream (generator);

            generator .endArray ();

            headLastProperty = true;
         }

         // Head end

         generator .endObject ();
      }

      // Scene

      generator .beginObject ("Scene");
      generator .beginArray ("-children", false);

      const exportedNodes = this .getExportedNodes ();

      generator .PushExecutionContext (this);
      generator .EnterScope ();
      generator .ExportedNodes (exportedNodes);

      const comma = _X3DExecutionContext_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .prototype .toJSONStream .call (this, generator);

      // Exported nodes

      this .getExportedNodes () .toJSONStream (generator, comma);

      generator .LeaveScope ();
      generator .PopExecutionContext ();

      // Scene end

      generator .endArray ();
      generator .endObject ();

      // X3D end

      generator .endObject ();
      generator .endObject ();
      generator .AddTidyBreak ();
   },
   dispose ()
   {
      this .exportedNodes .clear ();

      _X3DExecutionContext_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .prototype .dispose .call (this);
   },
},
{
   setExecutionContext (executionContext)
   {
      // Remove loading objects from old parent scene.
      {
         const scene = this .getScene ();

         if (scene)
         {
            for (const object of this [_loadingObjects])
               scene .removeLoadingObject (object);
         }
      }

      _X3DExecutionContext_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .prototype .setExecutionContext .call (this, executionContext);

      // Add loading objects to new parent scene.
      {
         const scene = this .getScene ();

         if (scene)
         {
            for (const object of this [_loadingObjects])
               scene .addLoadingObject (object);
         }
      }
   },
   getLoadingObjects ()
   {
      return this [_loadingObjects];
   },
   addLoadingObject (node)
   {
      this [_loadingObjects] .add (node);

      this ._loadCount = this [_loadingObjects] .size;

      const parent = this .getScene () ?? this .getBrowser ();

      parent .addLoadingObject (node);
   },
   removeLoadingObject (node)
   {
      this [_loadingObjects] .delete (node);

      this ._loadCount = this [_loadingObjects] .size;

      const parent = this .getScene () ?? this .getBrowser ();

      parent .removeLoadingObject (node);
   },
});

for (const key of Object .keys (X3DScene .prototype))
   Object .defineProperty (X3DScene .prototype, key, { enumerable: false });

Object .defineProperties (X3DScene .prototype,
{
   isScene:
   {
      value: true,
      enumerable: true,
   },
   specificationVersion:
   {
      get: X3DScene .prototype .getSpecificationVersion,
      enumerable: true,
   },
   encoding:
   {
      get: X3DScene .prototype .getEncoding,
      enumerable: true,
   },
   profile:
   {
      get: X3DScene .prototype .getProfile,
      enumerable: true,
   },
   profile_changed:
   {
      get () { return this ._profile_changed; },
      enumerable: false,
   },
   components:
   {
      get: X3DScene .prototype .getComponents,
      enumerable: true,
   },
   worldURL:
   {
      get: X3DScene .prototype .getWorldURL,
      enumerable: true,
   },
   baseURL:
   {
      get: X3DScene .prototype .getBaseURL,
      enumerable: true,
   },
   units:
   {
      get: X3DScene .prototype .getUnits,
      enumerable: true,
   },
   metadata_changed:
   {
      get () { return this ._metadata_changed; },
      enumerable: false,
   },
   rootNodes:
   {
      get: X3DScene .prototype .getRootNodes,
      set: X3DScene .prototype .setRootNodes,
      enumerable: true,
   },
   exportedNodes:
   {
      get: X3DScene .prototype .getExportedNodes,
      enumerable: true,
   },
   sceneGraph_changed:
   {
      get () { return this ._sceneGraph_changed; },
      enumerable: false,
   },
});

Object .defineProperties (X3DScene,
{
   typeName:
   {
      value: "X3DScene",
      enumerable: true,
   },
});

_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_10__/* ["default"] */ .A .addConstant (X3DScene .typeName);

const __default__ = X3DScene;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_13__/* ["default"] */ .A .add ("X3DScene", __default__));

/***/ }),

/***/ 1770:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Vector3_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(7572);
/* harmony import */ var _Matrix3_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(8713);
/* harmony import */ var _Algorithm_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(780);
/* harmony import */ var _x_ite_Namespace_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(717);




function Quaternion (x = 0, y = 0, z = 0, w = 1)
{
   this .x = x;
   this .y = y;
   this .z = z;
   this .w = w;
}

Object .assign (Quaternion .prototype,
{
   *[Symbol .iterator] ()
   {
      yield this .x;
      yield this .y;
      yield this .z;
      yield this .w;
   },
   copy ()
   {
      const copy = Object .create (Quaternion .prototype);
      copy .x = this .x;
      copy .y = this .y;
      copy .z = this .z;
      copy .w = this .w;
      return copy;
   },
   assign ({ x, y, z, w })
   {
      this .x = x;
      this .y = y;
      this .z = z;
      this .w = w;
      return this;
   },
   set (x = 0, y = 0, z = 0, w = 1)
   {
      this .x = x;
      this .y = y;
      this .z = z;
      this .w = w;
      return this;
   },
   setMatrix (matrix)
   {
      // First, find largest diagonal in matrix:

      const i = matrix [0] > matrix [4]
         ? matrix [0] > matrix [8] ? 0 : 2
         : matrix [4] > matrix [8] ? 1 : 2;

      const scaleRow = matrix [0] + matrix [4] + matrix [8];

      if (scaleRow > matrix [i * 3 + i])
      {
         // Compute w first:
         this [3] = Math .sqrt (scaleRow + 1) / 2;

         // And compute other values:
         const d = 4 * this [3];
         this [0] = (matrix [5] - matrix [7]) / d;
         this [1] = (matrix [6] - matrix [2]) / d;
         this [2] = (matrix [1] - matrix [3]) / d;
      }
      else
      {
         // Compute x, y, or z first:
         const j = (i + 1) % 3;
         const k = (i + 2) % 3;

         // Compute first value:
         this [i] = Math .sqrt (matrix [i * 3 + i] - matrix [j * 3 + j] - matrix [k * 3 + k] + 1) / 2;

         // And the others:
         const d = 4 * this [i];
         this [j] = (matrix [i * 3 + j] + matrix [j * 3 + i]) / d;
         this [k] = (matrix [i * 3 + k] + matrix [k * 3 + i]) / d;
         this [3] = (matrix [j * 3 + k] - matrix [k * 3 + j]) / d;
      }

      return this;
   },
   getMatrix (matrix = new _Matrix3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A ())
   {
      const { x, y, z, w } = this;

      const
         a = x * x,
         b = x * y,
         c = y * y,
         d = y * z,
         e = z * x,
         f = z * z,
         g = w * x,
         h = w * y,
         i = w * z;

      matrix [0] = 1 - 2 * (c + f);
      matrix [1] =     2 * (b + i);
      matrix [2] =     2 * (e - h);

      matrix [3] =     2 * (b - i);
      matrix [4] = 1 - 2 * (f + a);
      matrix [5] =     2 * (d + g);

      matrix [6] =     2 * (e + h);
      matrix [7] =     2 * (d - g);
      matrix [8] = 1 - 2 * (c + a);

      return matrix;
   },
   setEuler (x, y, z, order = "XYZ")
   {
		// http://www.mathworks.com/matlabcentral/fileexchange/20696-function-to-convert-between-dcm-euler-angles-quaternions-and-euler-vectors/content/SpinCalc.m

      const
		   c1 = Math .cos (x / 2),
		   c2 = Math .cos (y / 2),
		   c3 = Math .cos (z / 2),
		   s1 = Math .sin (x / 2),
		   s2 = Math .sin (y / 2),
		   s3 = Math .sin (z / 2);

		switch (order)
      {
			case "XYZ":
				this .x = s1 * c2 * c3 + c1 * s2 * s3;
				this .y = c1 * s2 * c3 - s1 * c2 * s3;
				this .z = c1 * c2 * s3 + s1 * s2 * c3;
				this .w = c1 * c2 * c3 - s1 * s2 * s3;
				break;

         case "ZYX":
            this .x = s1 * c2 * c3 - c1 * s2 * s3;
            this .y = c1 * s2 * c3 + s1 * c2 * s3;
            this .z = c1 * c2 * s3 - s1 * s2 * c3;
            this .w = c1 * c2 * c3 + s1 * s2 * s3;
            break;

			case "YXZ":
				this .x = s1 * c2 * c3 + c1 * s2 * s3;
				this .y = c1 * s2 * c3 - s1 * c2 * s3;
				this .z = c1 * c2 * s3 - s1 * s2 * c3;
				this .w = c1 * c2 * c3 + s1 * s2 * s3;
				break;

			case "ZXY":
				this .x = s1 * c2 * c3 - c1 * s2 * s3;
				this .y = c1 * s2 * c3 + s1 * c2 * s3;
				this .z = c1 * c2 * s3 + s1 * s2 * c3;
				this .w = c1 * c2 * c3 - s1 * s2 * s3;
				break;

			case "YZX":
				this .x = s1 * c2 * c3 + c1 * s2 * s3;
				this .y = c1 * s2 * c3 + s1 * c2 * s3;
				this .z = c1 * c2 * s3 - s1 * s2 * c3;
				this .w = c1 * c2 * c3 - s1 * s2 * s3;
				break;

			case "XZY":
				this .x = s1 * c2 * c3 - c1 * s2 * s3;
				this .y = c1 * s2 * c3 - s1 * c2 * s3;
				this .z = c1 * c2 * s3 + s1 * s2 * c3;
				this .w = c1 * c2 * c3 + s1 * s2 * s3;
				break;
		}

		return this;
	},
   getEuler (euler = [ ], order = "XYZ")
   {
      const { 0: m0, 1: m1, 2: m2, 3: m3, 4: m4, 5: m5, 6: m6, 7: m7, 8: m8 } = this .getMatrix (m);

		switch (order)
      {
			case "XYZ":
         {
				euler [1] = Math .asin (_Algorithm_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .clamp (m6, -1, 1));

				if (Math .abs (m6) < 0.9999999)
            {
					euler [0] = Math .atan2 (-m7, m8);
					euler [2] = Math .atan2 (-m3, m0);
				}
            else
            {
					euler [0] = Math .atan2 (m5, m4);
					euler [2] = 0;
				}

				break;
         }
			case "ZYX":
         {
				euler [1] = Math .asin (- _Algorithm_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .clamp (m2, -1, 1));

				if (Math .abs (m2) < 0.9999999)
            {
					euler [0] = Math .atan2 (m5, m8);
					euler [2] = Math .atan2 (m1, m0);
				}
            else
            {
					euler [0] = 0;
					euler [2] = Math .atan2 (-m3, m4);
				}

				break;
         }
			case "YXZ":
         {
				euler [0] = Math .asin (- _Algorithm_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .clamp (m7, -1, 1));

				if (Math .abs (m7) < 0.9999999)
            {
					euler [1] = Math .atan2 (m6, m8);
					euler [2] = Math .atan2 (m1, m4);

				}
            else
            {
					euler [1] = Math .atan2 (-m2, m0);
					euler [2] = 0;
				}

				break;
         }
			case "ZXY":
         {
				euler [0] = Math .asin (_Algorithm_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .clamp (m5, -1, 1));

				if (Math .abs (m5) < 0.9999999)
            {
					euler [1] = Math .atan2 (-m2, m8);
					euler [2] = Math .atan2 (-m3, m4);
				}
            else
            {
					euler [1] = 0;
					euler [2] = Math .atan2 (m1, m0);
				}

				break;
         }
			case "YZX":
         {
				euler [2] = Math .asin (_Algorithm_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .clamp (m1, -1, 1));

				if (Math .abs (m1) < 0.9999999)
            {
					euler [0] = Math .atan2 (-m7, m4);
					euler [1] = Math .atan2 (-m2, m0);
				}
            else
            {
					euler [0] = 0;
					euler [1] = Math .atan2 (m6, m8);
				}

				break;
         }
			case "XZY":
         {
				euler [2] = Math .asin (- _Algorithm_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .clamp (m3, -1, 1));

				if (Math .abs (m3) < 0.9999999)
            {
					euler [0] = Math .atan2 (m5, m4);
					euler [1] = Math .atan2 (m6, m0);

				}
            else
            {
					euler [0] = Math .atan2 (-m7, m8);
					euler [1] = 0;
				}

				break;
         }
		}

		return euler;
   },
   isReal ()
   {
      return !(this .x || this .y || this .z);
   },
   isImag ()
   {
      return !this .w;
   },
   equals ({ x, y, z, w })
   {
      return this .x === x &&
             this .y === y &&
             this .z === z &&
             this .w === w;
   },
   negate ()
   {
      this .x = -this .x;
      this .y = -this .y;
      this .z = -this .z;
      this .w = -this .w;
      return this;
   },
   inverse ()
   {
      this .x = -this .x;
      this .y = -this .y;
      this .z = -this .z;
      return this;
   },
   add ({ x, y, z, w })
   {
      this .x += x;
      this .y += y;
      this .z += z;
      this .w += w;
      return this;
   },
   subtract ({ x, y, z, w })
   {
      this .x -= x;
      this .y -= y;
      this .z -= z;
      this .w -= w;
      return this;
   },
   multiply (value)
   {
      this .x *= value;
      this .y *= value;
      this .z *= value;
      this .w *= value;
      return this;
   },
   multLeft (quat)
   {
      const
         { x: ax, y: ay, z: az, w: aw } = this,
         { x: bx, y: by, z: bz, w: bw } = quat;

      this .x = aw * bx + ax * bw + ay * bz - az * by;
      this .y = aw * by + ay * bw + az * bx - ax * bz;
      this .z = aw * bz + az * bw + ax * by - ay * bx;
      this .w = aw * bw - ax * bx - ay * by - az * bz;

      return this;
   },
   multRight (quat)
   {
      const
         { x: ax, y: ay, z: az, w: aw } = this,
         { x: bx, y: by, z: bz, w: bw } = quat;

      this .x = bw * ax + bx * aw + by * az - bz * ay;
      this .y = bw * ay + by * aw + bz * ax - bx * az;
      this .z = bw * az + bz * aw + bx * ay - by * ax;
      this .w = bw * aw - bx * ax - by * ay - bz * az;

      return this;
   },
   divide (value)
   {
      this .x /= value;
      this .y /= value;
      this .z /= value;
      this .w /= value;
      return this;
   },
   multVecQuat (vector)
   {
      // https://en.wikipedia.org/wiki/Conversion_between_quaternions_and_Euler_angles#Vector_rotation

      const
         { x: qx, y: qy, z: qz, w: qw } = this,
         { x: vx, y: vy, z: vz } = vector,
         tx = 2 * (qy * vz - qz * vy),
         ty = 2 * (qz * vx - qx * vz),
         tz = 2 * (qx * vy - qy * vx);

      vector .x += qw * tx + qy * tz - qz * ty;
      vector .y += qw * ty + qz * tx - qx * tz;
      vector .z += qw * tz + qx * ty - qy * tx;

      return vector;
   },
   multQuatVec (vector)
   {
      // https://en.wikipedia.org/wiki/Conversion_between_quaternions_and_Euler_angles#Vector_rotation

      const
         { x: qx, y: qy, z: qz, w: qw } = this,
         { x: vx, y: vy, z: vz } = vector,
         tx = 2 * (qz * vy - qy * vz),
         ty = 2 * (qx * vz - qz * vx),
         tz = 2 * (qy * vx - qx * vy);

      vector .x += qw * tx - qy * tz + qz * ty;
      vector .y += qw * ty - qz * tx + qx * tz;
      vector .z += qw * tz - qx * ty + qy * tx;

      return vector;
   },
   normalize ()
   {
      const length = Math .hypot (this .x, this .y, this .z, this .w);

      if (length)
      {
         this .x /= length;
         this .y /= length;
         this .z /= length;
         this .w /= length;
      }

      return this;
   },
   dot (quat)
   {
      return this .x * quat .x +
             this .y * quat .y +
             this .z * quat .z +
             this .w * quat .w;
   },
   squaredNorm ()
   {
      const { x, y, z, w } = this;

      return x * x +
             y * y +
             z * z +
             w * w;
   },
   norm ()
   {
      return Math .hypot (this .x, this .y, this .z, this .w);
   },
   pow (exponent)
   {
      if (exponent instanceof Quaternion)
         return this .assign (e .assign (exponent) .multRight (this .log ()) .exp ());

      if (this .isReal ())
         return this .set (0, 0, 0, this .w ** exponent);

      const
         l     = this .norm (),
         theta = Math .acos (this .w / l),
         li    = this .imag .norm (),
         ltoe  = l ** exponent,
         et    = exponent * theta,
         scale = ltoe / li * Math .sin (et);

      this .x *= scale;
      this .y *= scale;
      this .z *= scale;
      this .w  = ltoe * Math .cos (et);
      return this;
   },
   log ()
   {
      if (this .isReal ())
      {
         if (this .w > 0)
            return this .set (0, 0, 0, Math .log (this .w));

         else
            return this .set (Math .PI, 0, 0, Math .log (-this .w));
      }

      const
         l = this .norm (),
         v = this .imag .normalize () .multiply (Math .acos (this .w / l)),
         w = Math .log (l);

      this .x = v .x;
      this .y = v .y;
      this .z = v .z;
      this .w = w;
      return this;
   },
   exp ()
   {
      if (this .isReal ())
         return this .set (0, 0, 0, Math .exp (this .w));

      const
         i  = this .imag,
         li = i .norm (),
         ew = Math .exp (this .w),
         w  = ew * Math .cos (li),
         v  = i .multiply (ew * Math .sin (li) / li);

      this .x = v .x;
      this .y = v .y;
      this .z = v .z;
      this .w = w;
      return this;
   },
   slerp (destination, t)
   {
      return _Algorithm_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .slerp (this, t1 .assign (destination), t);
   },
   squad (a, b, destination, t)
   {
      // Ken Shoemake defines Squad as:
      // We must use shortest path slerp to prevent flipping. See also spline below.
      // a = spline (si-1, si, si+1) and b = spline (di-1, di, di+1), where si = source and di = destination

      return _Algorithm_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .slerp (_Algorithm_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .slerp (this, t1 .assign (destination), t),
                               _Algorithm_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .slerp (t2 .assign (a), t3 .assign (b), t),
                               2 * t * (1 - t));
   },
   toString ()
   {
      return this .x + " " +
             this .y + " " +
             this .z + " " +
             this .w;
   },
});

for (const key of Object .keys (Quaternion .prototype))
   Object .defineProperty (Quaternion .prototype, key, { enumerable: false });

Object .defineProperties (Quaternion .prototype,
{
   length: { value: 4 },
   0:
   {
      get () { return this .x; },
      set (value) { this .x = value; },
   },
   1:
   {
      get () { return this .y; },
      set (value) { this .y = value; },
   },
   2:
   {
      get () { return this .z; },
      set (value) { this .z = value; },
   },
   3:
   {
      get () { return this .w; },
      set (value) { this .w = value; },
   },
   real:
   {
      get () { return this .w; },
   },
   imag:
   {
      get: (() =>
      {
         const result = new _Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A ();

         return function ()
         {
            return result .set (this .x,
                                this .y,
                                this .z);
         };
      })(),
   },
});

Object .assign (Quaternion,
{
   IDENTITY: Object .freeze (new Quaternion ()),
   spline: (() =>
   {
      const
         q0   = new Quaternion (),
         q1   = new Quaternion (),
         q2   = new Quaternion (),
         q1_i = new Quaternion ();

      return function (Q0, Q1, Q2)
      {
         q0 .assign (Q0);
         q1 .assign (Q1);
         q2 .assign (Q2);

         // If the dot product is smaller than 0 we must negate the quaternion to prevent flipping. If we negate all
         // the terms we get a different quaternion but it represents the same rotation.

         if (q0 .dot (q1) < 0)
            q0 .negate ();

         if (q2 .dot (q1) < 0)
            q2 .negate ();

         q1_i .assign (q1) .inverse ();

         // The result must be normalized as it will be used in slerp and we can only slerp normalized vectors.

         return q1 .multRight (
            t1 .assign (q1_i) .multRight (q0) .log () .add (t2 .assign (q1_i) .multRight (q2) .log ()) .divide (-4) .exp ()
         )
         .normalize () .copy ();
      };
   })(),
});

const
   t1 = new Quaternion (),
   t2 = new Quaternion (),
   t3 = new Quaternion (),
   m  = new _Matrix3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A ();

const __default__ = Quaternion;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_x_ite_Namespace_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .add ("Quaternion", __default__));

/***/ }),

/***/ 1870:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _X3DInfoArray_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(3020);
/* harmony import */ var _X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(2040);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(717);



function FieldDefinitionArray (values = [ ])
{
   return _X3DInfoArray_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .call (this, Array .from (values, value => [value .name, value]), _X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A);
}

Object .setPrototypeOf (FieldDefinitionArray .prototype, _X3DInfoArray_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .prototype);

for (const key of Object .keys (FieldDefinitionArray .prototype))
   Object .defineProperty (FieldDefinitionArray .prototype, key, { enumerable: false });

Object .defineProperties (FieldDefinitionArray,
{
   typeName:
   {
      value: "FieldDefinitionArray",
      enumerable: true,
   },
});

const __default__ = FieldDefinitionArray;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .add ("FieldDefinitionArray", __default__));

/***/ }),

/***/ 2010:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Fields_SFNode_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(1061);
/* harmony import */ var _Base_X3DBaseNode_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(3643);
/* harmony import */ var _Components_Layering_LayerSet_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(2532);
/* harmony import */ var _Components_Layering_Layer_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(3314);
/* harmony import */ var _Base_X3DCast_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(7638);
/* harmony import */ var _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(2212);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(717);







function X3DWorld (executionContext)
{
   _Base_X3DBaseNode_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .call (this, executionContext);

   this .addType (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .X3DWorld)

   this .addChildObjects (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .outputOnly, "activeLayer", new _Fields_SFNode_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A (this .layer0));

   this .defaultLayerSet = new _Components_Layering_LayerSet_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A (executionContext);
   this .layerSet        = this .defaultLayerSet;
   this .layer0          = new _Components_Layering_Layer_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A (executionContext);
}

Object .assign (Object .setPrototypeOf (X3DWorld .prototype, _Base_X3DBaseNode_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .prototype),
{
   initialize ()
   {
      _Base_X3DBaseNode_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .prototype .initialize .call (this);

      this .layerSet .setPrivate (true);
      this .layerSet .setup ();
      this .layerSet .setLayer0 (this .layer0);
      this .layerSet ._activeLayer .addInterest ("set_rootNodes__", this);

      this .getExecutionContext () .getRootNodes () .addInterest ("set_rootNodes__", this);

      this .set_rootNodes__ ();

      this .layer0 .setPrivate (true);
      this .layer0 .setLayer0 (true);
      this .layer0 .setup ();

      this .set_activeLayer__ ();
   },
   getCache ()
   {
      return this .getBrowser () .getBrowserOption ("Cache");
   },
   getLayerSet ()
   {
      return this .layerSet;
   },
   getActiveLayer ()
   {
      return this ._activeLayer .getValue ();
   },
   getLayer0 ()
   {
      return this .layer0;
   },
   set_rootNodes__ ()
   {
      const
         oldLayerSet = this .layerSet,
         rootNodes   = this .getExecutionContext () .getRootNodes ();

      this .layerSet          = this .defaultLayerSet;
      this .layer0 ._children = rootNodes;

      for (const rootNode of rootNodes)
      {
         const layerSet = (0,_Base_X3DCast_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A) (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .LayerSet, rootNode);

         if (layerSet)
            this .layerSet = layerSet;
      }

      if (this .layerSet === oldLayerSet)
         return;

      this .layerSet .setLayer0 (this .layer0);

      oldLayerSet    ._activeLayerNode .removeInterest ("set_activeLayer__", this);
      this .layerSet ._activeLayerNode .addInterest    ("set_activeLayer__", this);

      this .set_activeLayer__ ();
   },
   set_activeLayer__ ()
   {
      this ._activeLayer = this .layerSet .getActiveLayer ();
   },
   bindBindables ()
   {
      // Bind first X3DBindableNodes found in each layer.

      const worldURL = this .getExecutionContext () .getWorldURL ();

      this .layerSet .bindBindables (decodeURIComponent (new URL (worldURL) .hash .substring (1)));
   },
   traverse (type, renderObject)
   {
      this .layerSet .traverse (type, renderObject);
   },
});

for (const key of Object .keys (X3DWorld .prototype))
   Object .defineProperty (X3DWorld .prototype, key, { enumerable: false });

Object .defineProperties (X3DWorld,
{
   typeName:
   {
      value: "X3DWorld",
      enumerable: true,
   },
});

_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .addConstant (X3DWorld .typeName);

const __default__ = X3DWorld;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .add ("X3DWorld", __default__));

/***/ }),

/***/ 2040:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _X3DObject_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(946);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(717);


const
   _accessType = Symbol (),
   _name       = Symbol (),
   _value      = Symbol ();

function X3DFieldDefinition (accessType, name, value)
{
   this [_accessType] = accessType;
   this [_name]       = name;
   this [_value]      = value;
}

Object .assign (Object .setPrototypeOf (X3DFieldDefinition .prototype, _X3DObject_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .prototype),
{
   getAccessType ()
   {
      return this [_accessType];
   },
   getDataType ()
   {
      return this [_value] .getType ();
   },
   getName ()
   {
      return this [_name];
   },
   getValue ()
   {
      return this [_value];
   },
   getAppInfo ()
   {
      return this [_value] .getAppInfo ();
   },
   getDocumentation ()
   {
      return this [_value] .getDocumentation ();
   },
});

for (const key of Object .keys (X3DFieldDefinition .prototype))
   Object .defineProperty (X3DFieldDefinition .prototype, key, { enumerable: false });

Object .defineProperties (X3DFieldDefinition .prototype,
{
   accessType:
   {
      get: X3DFieldDefinition .prototype .getAccessType,
      enumerable: true,
   },
   dataType:
   {
      get: X3DFieldDefinition .prototype .getDataType,
      enumerable: true,
   },
   name:
   {
      get: X3DFieldDefinition .prototype .getName,
      enumerable: true,
   },
   value:
   {
      get () { return this .getValue () .valueOf (); },
      enumerable: true,
   },
   appInfo:
   {
      get: X3DFieldDefinition .prototype .getAppInfo,
      enumerable: true,
   },
   documentation:
   {
      get: X3DFieldDefinition .prototype .getDocumentation,
      enumerable: true,
   },
});

Object .defineProperties (X3DFieldDefinition,
{
   typeName:
   {
      value: "X3DFieldDefinition",
      enumerable: true,
   },
});

const __default__ = X3DFieldDefinition;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .add ("X3DFieldDefinition", __default__));

/***/ }),

/***/ 2062:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(717);
function VertexArray (gl)
{
   this .gl           = gl;
   this .vertexArrays = new Map ();
}

Object .assign (VertexArray .prototype,
{
   update (value = true)
   {
      if (value)
         this .dispose ();

      return this;
   },
   enable (program)
   {
      const { gl, vertexArrays } = this;

      const vertexArray = vertexArrays .get (program);

      if (vertexArray)
      {
         gl .bindVertexArray (vertexArray);

         return false;
      }
      else
      {
         // Memory leak prevention when shaders are reloaded. There should normally be no more than maybe 10 VAOs, except when shaders are often reloaded.
         if (vertexArrays .size > 100)
            this .dispose ();

         const vertexArray = gl .createVertexArray ();

         vertexArrays .set (program, vertexArray)

         gl .bindVertexArray (vertexArray);

         // console .log ("rebuild vao");

         return true; // Rebuild
      }
   },
   dispose ()
   {
      const { gl, vertexArrays } = this;

      for (const vertexArray of vertexArrays .values ())
         gl .deleteVertexArray (vertexArray);

      vertexArrays .clear ();
   },
});

const __default__ = VertexArray;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .add ("VertexArray", __default__));

/***/ }),

/***/ 2212:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(717);
const X3DConstants =
{
   [Symbol .toStringTag]: "X3DConstants",
};

let CONSTANT_VALUE = 1000;

Object .defineProperty (X3DConstants, "addConstant",
{
   value (name, value)
   {
      if (this .hasOwnProperty (name) || this .hasOwnProperty (value))
         return;

      Object .defineProperty (this, name,
      {
         value: value ?? ++ CONSTANT_VALUE,
         enumerable: true,
      });

      Object .defineProperty (this, this [name],
      {
         value: name,
      });
   },
});

Object .entries ({
   // Access types

   initializeOnly: 0b001,
   inputOnly:      0b010,
   outputOnly:     0b100,
   inputOutput:    0b111,
})
.forEach (([name, value]) => X3DConstants .addConstant (name, value));

[
   // Browser events

   "CONNECTION_ERROR",
   "BROWSER_EVENT",
   "INITIALIZED_EVENT",
   "SHUTDOWN_EVENT",
   "INITIALIZED_ERROR",

   // Load states

   "NOT_STARTED_STATE",
   "IN_PROGRESS_STATE",
   "COMPLETE_STATE",
   "FAILED_STATE",

   // X3DField

   "SFBool",
   "SFColor",
   "SFColorRGBA",
   "SFDouble",
   "SFFloat",
   "SFImage",
   "SFInt32",
   "SFMatrix3d",
   "SFMatrix3f",
   "SFMatrix4d",
   "SFMatrix4f",
   "SFNode",
   "SFRotation",
   "SFString",
   "SFTime",
   "SFVec2d",
   "SFVec2f",
   "SFVec3d",
   "SFVec3f",
   "SFVec4d",
   "SFVec4f",

   "VrmlMatrix",

   // X3DArrayField

   "MFBool",
   "MFColor",
   "MFColorRGBA",
   "MFDouble",
   "MFFloat",
   "MFImage",
   "MFInt32",
   "MFMatrix3d",
   "MFMatrix3f",
   "MFMatrix4d",
   "MFMatrix4f",
   "MFNode",
   "MFRotation",
   "MFString",
   "MFTime",
   "MFVec2d",
   "MFVec2f",
   "MFVec3d",
   "MFVec3f",
   "MFVec4d",
   "MFVec4f",

   // Abstract and concrete nodes and nodes types are added later.
]
.forEach (name => X3DConstants .addConstant (name));

const __default__ = X3DConstants;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .add ("X3DConstants", __default__));

/***/ }),

/***/ 2262:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Algorithm_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(780);
/* harmony import */ var _x_ite_Namespace_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(717);


const { interval, degrees } = _Algorithm_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A;

const
   _r = Symbol .for ("X_ITE.Color3.r"),
   _g = Symbol .for ("X_ITE.Color3.g"),
   _b = Symbol .for ("X_ITE.Color3.b");

// glTF sometimes allows color values greater than 1.
// See: https://github.com/KhronosGroup/glTF/blob/main/extensions/2.0/Khronos/KHR_materials_specular/README.md
// See: https://raw.githubusercontent.com/KhronosGroup/glTF-Sample-Assets/master/Models/SpecularTest/glTF/SpecularTest.gltf

function Color3 (r = 0, g = r, b = g)
{
   this [_r] = r;
   this [_g] = g;
   this [_b] = b;
}

Object .assign (Color3 .prototype,
{
   *[Symbol .iterator] ()
   {
      yield this [_r];
      yield this [_g];
      yield this [_b];
   },
   copy ()
   {
      const copy = Object .create (Color3 .prototype);
      copy [_r] = this [_r];
      copy [_g] = this [_g];
      copy [_b] = this [_b];
      return copy;
   },
   assign (color)
   {
      this [_r] = color [_r];
      this [_g] = color [_g];
      this [_b] = color [_b];
      return this;
   },
   set (r = 0, g = r, b = g)
   {
      this [_r] = r;
      this [_g] = g;
      this [_b] = b;
      return this;
   },
   equals (color)
   {
      return this [_r] === color [_r] &&
             this [_g] === color [_g] &&
             this [_b] === color [_b];
   },
   getHSV (result = [ ])
   {
      let h, s, v;

      const
         r = this [_r],
         g = this [_g],
         b = this [_b];

      const
         min = Math .min (r, g, b),
         max = Math .max (r, g, b);

      v = max; // value

      const delta = max - min;

      if (max !== 0 && delta !== 0)
      {
         s = delta / max; // s

         if (r === max)
            h =     (g - b) / delta;  // between yellow & magenta
         else if (g === max)
            h = 2 + (b - r) / delta;  // between cyan & yellow
         else
            h = 4 + (r - g) / delta;  // between magenta & cyan

         h *= Math .PI / 3;  // radiants

         if (h < 0)
            h += Math .PI * 2;
      }
      else
      {
         s = h = 0; // s = 0, h is undefined
      }

      result [0] = h;
      result [1] = s;
      result [2] = v;

      return result;
   },
   setHSV (h, s, v)
   {
      s = Math .max (s, 0),
      v = Math .max (v, 0);

      // H is given on [0, 2 * Pi]. S and V are given on [0, 1].
      // RGB are each returned on [0, 1].

      if (s === 0)
      {
         // achromatic (grey)
         this [_r] = this [_g] = this [_b] = v;
      }
      else
      {
         const w = degrees (interval (h, 0, Math .PI * 2)) / 60;     // sector 0 to 5

         const i = Math .floor (w);
         const f = w - i;                      // factorial part of h
         const p = v * ( 1 - s );
         const q = v * ( 1 - s * f );
         const t = v * ( 1 - s * ( 1 - f ) );

         switch (i % 6)
         {
            case 0:  this [_r] = v; this [_g] = t; this [_b] = p; break;
            case 1:  this [_r] = q; this [_g] = v; this [_b] = p; break;
            case 2:  this [_r] = p; this [_g] = v; this [_b] = t; break;
            case 3:  this [_r] = p; this [_g] = q; this [_b] = v; break;
            case 4:  this [_r] = t; this [_g] = p; this [_b] = v; break;
            default: this [_r] = v; this [_g] = p; this [_b] = q; break;
         }
      }

      return this;
   },
   linearToSRGB (color = new Color3 ())
   {
      color [_r] = Math .pow (this [_r], 1 / 2.2);
      color [_g] = Math .pow (this [_g], 1 / 2.2);
      color [_b] = Math .pow (this [_b], 1 / 2.2);

      return color;
   },
   sRGBToLinear (color = new Color3 ())
   {
      color [_r] = Math .pow (this [_r], 2.2);
      color [_g] = Math .pow (this [_g], 2.2);
      color [_b] = Math .pow (this [_b], 2.2);

      return color;
   },
   toString ()
   {
      return this [_r] + " " +
             this [_g] + " " +
             this [_b];
   },
});

for (const key of Object .keys (Color3 .prototype))
   Object .defineProperty (Color3 .prototype, key, { enumerable: false });

const r = {
   get () { return this [_r]; },
   set (value) { this [_r] = value; },
};

const g = {
   get () { return this [_g]; },
   set (value) { this [_g] = value; },
};

const b = {
   get () { return this [_b]; },
   set (value) { this [_b] = value; },
};

Object .defineProperties (Color3 .prototype,
{
   length: { value: 3 },
   0: r,
   1: g,
   2: b,
   r: Object .assign ({ enumerable: true }, r),
   g: Object .assign ({ enumerable: true }, g),
   b: Object .assign ({ enumerable: true }, b),
});

Object .assign (Color3,
{
   BLACK: Object .freeze (new Color3 ()),
   WHITE: Object .freeze (new Color3 (1)),
   HSV (h, s, v)
   {
      const color = Object .create (this .prototype);
      color .setHSV (h, s, v);
      return color;
   },
   lerp (a, b, t, r)
   {
      // Linearly interpolate in HSV space between source color @a a and destination color @a b by an amount of @a t.
      // Source and destination color must be in HSV space. The resulting HSV color is stored in @a r.

      let
         [ha, sa, va] = a,
         [hb, sb, vb] = b;

      if (sa === 0)
         ha = hb;

      if (sb === 0)
         hb = ha;

      const range = Math .abs (hb - ha);

      if (range <= Math .PI)
      {
         r [0] = ha + t * (hb - ha);
         r [1] = sa + t * (sb - sa);
         r [2] = va + t * (vb - va);
         return r;
      }

      const
         PI2  = Math .PI * 2,
         step = (PI2 - range) * t;

      let h = ha < hb ? ha - step : ha + step;

      if (h < 0)
         h += PI2;

      else if (h > PI2)
         h -= PI2;

      r [0] = h;
      r [1] = sa + t * (sb - sa);
      r [2] = va + t * (vb - va);
      return r;
   },
});

const __default__ = Color3;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_x_ite_Namespace_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .add ("Color3", __default__));

/***/ }),

/***/ 2269:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _X3DChildObject_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(4072);
/* harmony import */ var _X3DConstants_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(2212);
/* harmony import */ var _Events_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(5625);
/* harmony import */ var _IterableWeakSet_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(7016);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(717);





const
   _value               = Symbol (),
   _accessType          = Symbol (),
   _unit                = Symbol (),
   _references          = Symbol (),
   _referencesCallbacks = Symbol (),
   _fieldInterests      = Symbol (),
   _fieldCallbacks      = Symbol (),
   _inputRoutes         = Symbol (),
   _outputRoutes        = Symbol (),
   _routeCallbacks      = Symbol (),
   _appInfo             = Symbol (),
   _documentation       = Symbol (),
   _uniformLocation     = Symbol .for ("X_ITE.X3DField.uniformLocation");

const EMPTY = [ ];

function X3DField (value)
{
   _X3DChildObject_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .call (this);

   this [_value] = value;
}

Object .assign (Object .setPrototypeOf (X3DField .prototype, _X3DChildObject_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .prototype),
{
   [_value]: undefined,
   [_accessType]: _X3DConstants_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .initializeOnly,
   [_unit]: undefined,
   [_references]: null,
   [_referencesCallbacks]: null,
   [_fieldInterests]: null,
   [_fieldCallbacks]: null,
   [_inputRoutes]: null,
   [_outputRoutes]: null,
   [_routeCallbacks]: null,
   [_uniformLocation]: null,
   [_appInfo]: "",
   [_documentation]: "",
   create ()
   {
      return new (this .constructor) ();
   },
   equals (field)
   {
      return this [_value] === field .valueOf ();
   },
   assign (field)
   {
      // Assigns field to this field.
      this .set (field .getValue ());
      this .addEvent ();
   },
   set (value)
   {
      // Sets internal value without generating event.
      this [_value] = value;
   },
   setValue (value)
   {
      // Sets internal value and generates event.
      this .set (value instanceof this .constructor ? value .getValue () : value);
      this .addEvent ();
   },
   getValue ()
   {
      return this [_value];
   },
   getType ()
   {
      return _X3DConstants_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A [this .constructor .typeName];
   },
   setAccessType (value)
   {
      this [_accessType] = value;
   },
   getAccessType ()
   {
      return this [_accessType];
   },
   isInitializable ()
   {
      return !! (this [_accessType] & _X3DConstants_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .initializeOnly);
   },
   isInput ()
   {
      return !! (this [_accessType] & _X3DConstants_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .inputOnly);
   },
   isOutput ()
   {
      return !! (this [_accessType] & _X3DConstants_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .outputOnly);
   },
   isReadable ()
   {
      return this [_accessType] !== _X3DConstants_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .inputOnly;
   },
   isWritable ()
   {
      return this [_accessType] !== _X3DConstants_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .outputOnly;
   },
   setUnit (value)
   {
      this [_unit] = value;
   },
   getUnit ()
   {
      return this [_unit];
   },
   isReference (accessType)
   {
      return accessType === this [_accessType] || accessType === _X3DConstants_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .inputOutput;
   },
   addReference (reference)
   {
      const references = this .getReferences ();

      if (references .has (reference))
         return;

      references .add (reference);

      // Create IS relationship

      switch (this .getAccessType () & reference .getAccessType ())
      {
         case _X3DConstants_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .initializeOnly:
            reference .addFieldInterest (this);
            this .processEvent (_Events_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .from (reference));
            break;
         case _X3DConstants_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .inputOnly:
            reference .addFieldInterest (this);
            break;
         case _X3DConstants_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .outputOnly:
            this .addFieldInterest (reference);
            break;
         case _X3DConstants_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .inputOutput:
            reference .addFieldInterest (this);
            this .addFieldInterest (reference);
            this .processEvent (_Events_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .from (reference));
            break;
      }

      this .processReferencesCallbacks ();
   },
   removeReference (reference)
   {
      this [_references] ?.delete (reference);

      // Create IS relationship

      switch (this .getAccessType () & reference .getAccessType ())
      {
         case _X3DConstants_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .initializeOnly:
            reference .removeFieldInterest (this);
            break;
         case _X3DConstants_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .inputOnly:
            reference .removeFieldInterest (this);
            break;
         case _X3DConstants_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .outputOnly:
            this .removeFieldInterest (reference);
            break;
         case _X3DConstants_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .inputOutput:
            reference .removeFieldInterest (this);
            this .removeFieldInterest (reference);
            break;
      }

      this .processReferencesCallbacks ();
   },
   getReferences ()
   {
      return this [_references] ??= new _IterableWeakSet_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A ();
   },
   addReferencesCallback (key, object)
   {
      this [_referencesCallbacks] = new Map (this [_referencesCallbacks]);

      this [_referencesCallbacks] .set (key, object);
   },
   removeReferencesCallback (key)
   {
      this [_referencesCallbacks] ?.delete (key);
   },
   getReferencesCallbacks ()
   {
      return this [_referencesCallbacks] ??= new Map ();
   },
   processReferencesCallbacks ()
   {
      for (const callback of this [_referencesCallbacks] ?.values () ?? EMPTY)
         callback ();
   },
   addFieldInterest (field)
   {
      // There must be no copy, because the event is not executed immediately.

      this .getFieldInterests () .add (field);
   },
   removeFieldInterest (field)
   {
      this [_fieldInterests] ?.delete (field);
   },
   getFieldInterests ()
   {
      return this [_fieldInterests] ??= new _IterableWeakSet_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A ();
   },
   addFieldCallback (key, object)
   {
      this [_fieldCallbacks] = new Map (this [_fieldCallbacks]);

      this [_fieldCallbacks] .set (key, object);
   },
   removeFieldCallback (key)
   {
      this [_fieldCallbacks] ?.delete (key);
   },
   getFieldCallbacks ()
   {
      return this [_fieldCallbacks] ??= new Map ();
   },
   addInputRoute (route)
   {
      this .getInputRoutes () .add (route);
      this .processRouteCallbacks ();
   },
   removeInputRoute (route)
   {
      this [_inputRoutes] ?.delete (route);

      this .processRouteCallbacks ();
   },
   getInputRoutes ()
   {
      return this [_inputRoutes] ??= new _IterableWeakSet_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A ();
   },
   addOutputRoute (route)
   {
      this .getOutputRoutes () .add (route);
      this .processRouteCallbacks ();
   },
   removeOutputRoute (route)
   {
      this [_outputRoutes] ?.delete (route);

      this .processRouteCallbacks ();
   },
   getOutputRoutes ()
   {
      return this [_outputRoutes] ??= new _IterableWeakSet_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A ();
   },
   addRouteCallback (key, object)
   {
      // Processed if routes are changed.

      this [_routeCallbacks] = new Map (this [_routeCallbacks]);

      this [_routeCallbacks] .set (key, object);
   },
   removeRouteCallback (key)
   {
      this [_routeCallbacks] ?.delete (key);
   },
   getRouteCallbacks ()
   {
      return this [_routeCallbacks] ??= new Map ();
   },
   processRouteCallbacks ()
   {
      for (const callback of this [_routeCallbacks] ?.values () ?? EMPTY)
         callback ();
   },
   processEvent (event = _Events_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .create (this))
   {
      event .add (this);

      this .setTainted (false);

      const field = event .field;

      if (field !== this)
         this .set (field .getValue (), field .length);

      // Process interests.

      this .processInterests ();

      // Process routes.

      let first = true;

      for (const field of this [_fieldInterests] ?? EMPTY)
      {
         if (event .has (field))
            continue;

         if (first)
         {
            first = false;
            field .addEventObject (this, event);
         }
         else
         {
            field .addEventObject (this, _Events_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .copy (event));
         }
      }

      if (first)
         _Events_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .push (event);

      // Process field callbacks.

      for (const callback of this [_fieldCallbacks] ?.values () ?? EMPTY)
         callback (this .valueOf ());
   },
   getAppInfo ()
   {
      return this [_appInfo];
   },
   setAppInfo (value)
   {
      this [_appInfo] = String (value);
   },
   setDocumentation (value)
   {
      this [_documentation] = String (value);
   },
   getDocumentation ()
   {
      return this [_documentation];
   },
   fromString (string, scene)
   {
      this .fromVRMLString (string, scene);
   },
   fromVRMLString (string, scene)
   {
      // Function will be overridden in VRMLParser.
   },
   fromXMLString (string, scene)
   {
      // Function will be overridden in XMLParser.
   },
   dispose ()
   {
      for (const reference of this [_references] ?? EMPTY)
         reference .removeFieldInterest (this);

      for (const route of Array .from (this [_inputRoutes] ?? EMPTY))
         route .dispose ();

      for (const route of Array .from (this [_outputRoutes] ?? EMPTY))
         route .dispose ();

      this [_references]          ?.clear ();
      this [_referencesCallbacks] ?.clear ();
      this [_fieldInterests]      ?.clear ();
      this [_fieldCallbacks]      ?.clear ();
      this [_inputRoutes]         ?.clear ();
      this [_outputRoutes]        ?.clear ();
      this [_routeCallbacks]      ?.clear ();

      _X3DChildObject_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .prototype .dispose .call (this);
   }
});

for (const key of Object .keys (X3DField .prototype))
   Object .defineProperty (X3DField .prototype, key, { enumerable: false });

const __default__ = X3DField;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .add ("X3DField", __default__));

/***/ }),

/***/ 2340:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Fields_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(4598);
/* harmony import */ var _Base_X3DBaseNode_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(3643);
/* harmony import */ var _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(2212);
/* harmony import */ var _Base_X3DField_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(2269);
/* harmony import */ var _Fields_SFNodeCache_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(6015);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(717);






const _metaDataCallbacks = Symbol ();

function X3DNode (executionContext)
{
   _Base_X3DBaseNode_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .call (this, executionContext);

   this .addType (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .X3DNode);
}

Object .assign (Object .setPrototypeOf (X3DNode .prototype, _Base_X3DBaseNode_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .prototype),
{
   getComponentInfo ()
   {
      return this .constructor .componentInfo;
   },
   getContainerField ()
   {
      return this .constructor .containerField;
   },
   getSpecificationRange ()
   {
      return this .constructor .specificationRange;
   },
   create (executionContext = this .getExecutionContext ())
   {
      return new (this .constructor) (executionContext);
   },
   copy (instance)
   {
      if (instance ?.getType () .includes (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .X3DExecutionContext) ?? true)
      {
         const copy = this .create (instance);

         for (const field of this .getPredefinedFields ())
            copy .getPredefinedFields () .get (field .getName ()) .assign (field);

         if (this .canUserDefinedFields ())
         {
            for (const field of this .getUserDefinedFields ())
               copy .addUserDefinedField (field .getAccessType (), field .getName (), field .copy ());
         }

         return copy;
      }
      else
      {
         const executionContext = instance .getBody ();

         // First try to get a named node with the node's name.

         if (this .getName () .length)
         {
            const namedNode = executionContext .getNamedNodes () .get (this .getName ());

            if (namedNode)
               return namedNode .getValue ();
         }

         // Create copy.

         const copy = this .create (executionContext);

         // Support editing of protos.
         if (this .getNeedsName ())
            this .getExecutionContext () .updateNamedNode (this .getExecutionContext () .getUniqueName (), this);

         if (this .getName () .length)
            executionContext .updateNamedNode (this .getName (), copy);

         // Default fields

         for (const sourceField of this .getPredefinedFields ())
         {
            try
            {
               const destinationField = copy .getPredefinedField (sourceField .getName ());

               let initializableReferences = false;

               for (const originalReference of sourceField .getReferences ())
                  initializableReferences ||= originalReference .isInitializable ();

               if (sourceField .isInitializable () && !initializableReferences)
               {
                  switch (sourceField .getType ())
                  {
                     case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .SFNode:
                     case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .MFNode:
                        destinationField .assign (sourceField .copy (instance));
                        break;
                     default:
                        destinationField .assign (sourceField);
                        break;
                  }
               }

               if (sourceField .getReferences () .size)
               {
                  // IS relationship

                  for (const originalReference of sourceField .getReferences ())
                  {
                     try
                     {
                        destinationField .addReference (instance .getField (originalReference .getName ()));
                     }
                     catch (error)
                     {
                        console .error (error);
                     }
                  }
               }

               destinationField .setModificationTime (sourceField .getModificationTime ());
            }
            catch (error)
            {
               console .error (error);
            }
         }

         // User-defined fields

         for (const sourceField of this .getUserDefinedFields ())
         {
            let initializableReferences = false;

            for (const originalReference of sourceField .getReferences ())
               initializableReferences ||= originalReference .isInitializable ();

            const destinationField = initializableReferences
               ? sourceField .create ()
               : sourceField .copy (instance);

            copy .addUserDefinedField (sourceField .getAccessType (),
                                       sourceField .getName (),
                                       destinationField);

            if (sourceField .getReferences () .size)
            {
               // IS relationship

               for (const originalReference of sourceField .getReferences ())
               {
                  try
                  {
                     destinationField .addReference (instance .getField (originalReference .getName ()));
                  }
                  catch (error)
                  {
                     console .error (`No reference '${originalReference .getName ()}' inside execution context ${instance .getTypeName ()} '${instance .getName ()}'.`);
                  }
               }
            }

            destinationField .setModificationTime (sourceField .getModificationTime ());
         }

         return copy;
      }
   },
   getDisplayName ()
   {
      return this .getName () .replace (/_\d+$/, "");
   },
   getNeedsName ()
   {
      if (this .getName () .length)
         return false;

      if (this .getCloneCount () > 1)
         return true;

      if (this .hasRoutes ())
         return true;

      const executionContext = this .getExecutionContext ()

      for (const importedNode of executionContext .getImportedNodes ())
      {
         if (importedNode .getInlineNode () === this)
            return true;
      }

      if (executionContext .isScene)
      {
         for (const exportedNode of executionContext .getExportedNodes ())
         {
            if (exportedNode .getLocalNode () === this)
               return true;
         }
      }

      return false;
   },
   hasRoutes ()
   {
      ///  Returns true if there are any routes from or to fields of this node, otherwise false.

      for (const field of this .getPredefinedFields ())
      {
         if (field .getInputRoutes () .size || field .getOutputRoutes () .size)
            return true;
      }

      for (const field of this .getUserDefinedFields ())
      {
         if (field .getInputRoutes () .size || field .getOutputRoutes () .size)
            return true;
      }

      for (const route of this .getExecutionContext () .getRoutes ())
      {
         if (route .getSourceNode () === this || route .getDestinationNode () === this)
            return true;
      }

      return false;
   },
   getCloneCount ()
   {
      return _Base_X3DBaseNode_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .prototype .collectCloneCount .call (this);
   },
   collectCloneCount ()
   {
      return 1;
   },
   getSourceText ()
   {
      return null;
   },
   traverse ()
   { },
   hasMetaData (path)
   {
      const names = path .split ("/");

      if (names .length < 2)
         return false;

      const
         last           = names .pop (),
         metadataSet    = this .getMetadataSet (names),
         metadataObject = metadataSet ?.getValue () .getMetaValue (last);

      return !!metadataObject;
   },
   getMetaData (path, field)
   {
      const names = path .split ("/");

      if (names .length < 2)
         return;

      const
         last           = names .pop (),
         metadataSet    = this .getMetadataSet (names),
         metadataObject = metadataSet ?.getValue () .getMetaValue (last);

      if (field instanceof _Base_X3DField_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A)
      {
         if (!metadataObject)
            return field;

         switch (field .getType ())
         {
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .SFBool:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .SFDouble:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .SFFloat:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .SFInt32:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .SFString:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .SFTime:
            {
               field .setValue (metadataObject .value [0]);
               break;
            }
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .SFColor:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .SFColorRGBA:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .SFMatrix3d:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .SFMatrix3f:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .SFMatrix4d:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .SFMatrix4f:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .SFRotation:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .SFVec2d:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .SFVec2f:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .SFVec3d:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .SFVec3f:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .SFVec4d:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .SFVec4f:
            {
               const value = metadataObject .value;

               let i = 0;

               for (const key in field)
                  field [key] = value [i ++];

               break;
            }
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .SFImage:
            {
               const
                  value = metadataObject .value,
                  array = field .array;

               field .width  = value [0];
               field .height = value [1];
               field .comp   = value [2];

               const l = array .length;

               for (let i = 0; i < l; ++ i)
                  array [i] = value [3 + i];

               break;
            }
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .SFNode:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .MFNode:
            {
               throw new Error ("SFNode and MFNode are not supported as metadata value.");
            }
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .MFBool:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .MFDouble:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .MFFloat:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .MFInt32:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .MFString:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .MFTime:
            {
               field .length = 0;

               for (const v of metadataObject .value)
                  field .push (v);

               break;
            }
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .MFColor:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .MFColorRGBA:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .MFMatrix3d:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .MFMatrix3f:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .MFMatrix4d:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .MFMatrix4f:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .MFRotation:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .MFVec2d:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .MFVec2f:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .MFVec3d:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .MFVec3f:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .MFVec4d:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .MFVec4f:
            {
               const
                  value  = metadataObject .value,
                  length = value .length;

               field .length = 0;

               for (let i = 0; i < length;)
               {
                  const
                     l = field .length ++,
                     f = field [l];

                  for (const key in f)
                     f [key] = value [i ++];
               }

               break;
            }
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .MFImage:
            {
               const
                  value  = metadataObject .value,
                  length = value .length;

               field .length = 0;

               for (let i = 0; i < length;)
               {
                  const
                     l = field .length ++,
                     f = field [l],
                     a = f .array;

                  f .width  = value [i ++];
                  f .height = value [i ++];
                  f .comp   = value [i ++];

                  const p = a .length;

                  for (let k = 0; k < p; ++ k)
                     a [k] = value [i ++];
               }

               break;
            }
         }

         return field;
      }
      else if (field)
      {
         // Support for Numbers (Vector234, Color34, ...).

         if (!metadataObject)
            return field;

         const value = metadataObject .value;

         let i = 0;

         for (const key in field)
            field [key] = value [i ++];

         return field;
      }

      return metadataObject ? Array .from (metadataObject .value) : [ ];
   },
   setMetaData (path, value)
   {
      const names = path .split ("/");

      if (names .length < 2)
         return;

      const
         last        = names .pop (),
         metadataSet = this .getMetadataSet (names, true);

      if (value instanceof _Base_X3DField_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A)
      {
         const field = value;

         switch (value .getType ())
         {
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .SFBool:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .SFDouble:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .SFFloat:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .SFInt32:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .SFString:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .SFTime:
            {
               value = [field .valueOf ()];
               break;
            }
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .SFNode:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .MFNode:
               throw new Error ("SFNode and MFNode are not supported as metadata value.");
            default:
            {
               value = Array .from (field, f => f instanceof _Base_X3DField_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A ? Array .from (f) : f) .flat ();
               break;
            }
         }

         switch (field .getType ())
         {
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .SFBool:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .MFBool:
               value .type = "boolean";
               break;
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .SFDouble:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .SFMatrix3d:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .SFMatrix4d:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .SFRotation:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .SFTime:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .SFVec2d:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .SFVec3d:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .SFVec4d:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .MFDouble:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .MFMatrix3d:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .MFMatrix4d:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .MFRotation:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .MFTime:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .MFVec2d:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .MFVec3d:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .MFVec4d:
               value .type = "double";
               break;
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .SFColor:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .SFColorRGBA:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .SFFloat:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .SFMatrix3f:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .SFMatrix4f:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .SFVec2f:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .SFVec3f:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .SFVec4f:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .MFColor:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .MFColorRGBA:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .MFFloat:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .MFMatrix3f:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .MFMatrix4f:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .MFVec2f:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .MFVec3f:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .MFVec4f:
               value .type = "float";
               break;
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .SFInt32:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .SFImage:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .MFInt32:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .MFImage:
               value .type = "integer";
               break;
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .SFString:
            case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .MFString:
               value .type = "string";
               break;
         }
      }
      else if (!Array .isArray (value) && value .valueOf () instanceof Object)
      {
         // Support for Numbers (Vector234, Color34, ...).

         value = Array .from (value);
         value .type = "double";
      }

      metadataSet .getValue () .setMetaValue (last, value);

      this .processMetaDataCallback (path);
   },
   removeMetaData (path)
   {
      const names = path .split ("/");

      if (names .length < 2)
         return;

      function removeMetaData (metadataSet, names)
      {
         if (!metadataSet)
            return false;

         const name = names .shift ();

         if (!names .length || removeMetaData (metadataSet .getValue () .getMetadataObject ("MetadataSet", name), names))
         {
            metadataSet .getValue () .removeMetaValue (name);
         }

         return !metadataSet .value .length;
      }

      if (removeMetaData (this .getMetadataSet ([names .shift ()]), names))
         this ._metadata = null;
   },
   getMetadataSet (names, create = false)
   {
      const name = names .shift ();

      let metadataSet = this ._metadata .valueOf ();

      if (metadataSet ?.getNodeTypeName () !== "MetadataSet" || metadataSet ?.name !== name)
      {
         if (!create)
            return null;

         this ._metadata = this .getExecutionContext () .createNode ("MetadataSet");
         metadataSet     = this ._metadata .valueOf ();

         this .getExecutionContext () .addNamedNode (this .getExecutionContext () .getUniqueName (name), metadataSet);

         metadataSet .reference = this .getBrowser () .getBrowserOption ("MetadataReference");
         metadataSet .name      = name;
      }

      for (const name of names)
         metadataSet = metadataSet .getValue () .getMetadataObject ("MetadataSet", name, create);

      return metadataSet;
   },
   [_metaDataCallbacks]: new Map (),
   addMetaDataCallback (key, path, callback)
   {
      if (!this .hasOwnProperty (_metaDataCallbacks))
         this [_metaDataCallbacks] = new Map ();

      let map = this [_metaDataCallbacks] .get (path);

      if (!map)
         this [_metaDataCallbacks] .set (path, map = new Map ());

      map .set (key, callback);
   },
   removeMetaDataCallback (key, path)
   {
      const map = this [_metaDataCallbacks] .get (path);

      if (!map)
         return;

      map .delete (key);

      if (map .size === 0)
         this [_metaDataCallbacks] .delete (path);
   },
   processMetaDataCallback (path)
   {
      const map = this [_metaDataCallbacks] .get (path);

      if (!map)
         return;

      for (const callback of map .values ())
         callback ();
   },
   toStream (generator)
   {
      generator .string += this .getTypeName () + " { }";
   },
   toVRMLStream (generator)
   {
      generator .EnterScope ();

      if (!generator .string .match (/^$|[ \t\r\n,\[\]\{\}]$/))
         generator .string += generator .Space ();

      if (generator .outputNames)
      {
         const name = generator .Name (this);

         if (name .length)
         {
            if (generator .ExistsNode (this))
            {
               generator .string += "USE";
               generator .string += generator .Space ();
               generator .string += name;

               generator .LeaveScope ();
               return;
            }
         }

         if (name .length)
         {
            generator .AddNode (this);

            generator .string += "DEF";
            generator .string += generator .Space ();
            generator .string += name;
            generator .string += generator .Space ();
         }
      }

      generator .string += this .getTypeName ();
      generator .string += generator .TidySpace ();
      generator .string += "{";

      const
         fields            = this .getChangedFields (),
         userDefinedFields = this .getUserDefinedFields ();

      if (this .canUserDefinedFields ())
      {
         if (userDefinedFields .length)
         {
            let
               fieldTypeLength  = 0,
               accessTypeLength = 0;

            for (const field of userDefinedFields)
            {
               fieldTypeLength  = Math .max (fieldTypeLength, field .getTypeName () .length);
               accessTypeLength = Math .max (accessTypeLength, generator .AccessType (field .getAccessType ()) .length);
            }

            generator .string += generator .TidyBreak ();
            generator .IncIndent ();

            const last = userDefinedFields .at (-1);

            for (const field of userDefinedFields)
            {
               this .toVRMLStreamUserDefinedField (generator, field, fieldTypeLength, accessTypeLength);

               if (field === last)
                  generator .string += generator .TidyBreak ();
               else
                  generator .string += generator .Break ();
            }

            generator .DecIndent ();

            if (fields .length !== 0)
               generator .string += generator .TidyBreak ();
         }
      }

      if (fields .length === 0)
      {
         if (userDefinedFields .length)
            generator .string += generator .Indent ();
         else
            generator .string += generator .TidySpace ();
      }
      else
      {
         const last = fields .at (-1);

         if (userDefinedFields .length === 0)
            generator .string += generator .TidyBreak ();

         generator .IncIndent ();

         for (const field of fields)
         {
            this .toVRMLStreamField (generator, field);

            if (field === last)
               generator .string += generator .TidyBreak ();
            else
               generator .string += generator .Break ();
         }

         generator .DecIndent ();
         generator .string += generator .Indent ();
      }

      generator .string += "}";

      generator .LeaveScope ();
   },
   toVRMLStreamUserDefinedField (generator, field, fieldTypeLength, accessTypeLength)
   {
      const sharedNode = generator .IsSharedNode (this);

      if (field .getReferences () .size === 0 || !generator .ExecutionContext () || sharedNode)
      {
         generator .string += generator .Indent ();
         generator .string += generator .AccessType (field .getAccessType ()) .padEnd (accessTypeLength, generator .TidySpace ());
         generator .string += generator .Space ();
         generator .string += field .getTypeName () .padEnd (fieldTypeLength, generator .TidySpace ());
         generator .string += generator .Space ();
         generator .string += field .getName ();

         if (field .isInitializable ())
         {
            generator .string += generator .Space ();

            field .toVRMLStream (generator);
         }
      }
      else
      {
         let
            index                  = 0,
            initializableReferences = false;

         for (const reference of field .getReferences ())
         {
            initializableReferences ||= reference .isInitializable ();

            // Output user defined reference field

            generator .string += generator .Indent ();
            generator .string += generator .AccessType (field .getAccessType ()) .padEnd (accessTypeLength, generator .TidySpace ());
            generator .string += generator .Space ();
            generator .string += field .getTypeName () .padEnd (fieldTypeLength, generator .TidySpace ());
            generator .string += generator .Space ();
            generator .string += field .getName ();
            generator .string += generator .Space ();
            generator .string += "IS";
            generator .string += generator .Space ();
            generator .string += reference .getName ();

            ++ index;

            if (index !== field .getReferences () .size)
               generator .string += generator .Break ();
         }

         if (field .getAccessType () === _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .inputOutput && !initializableReferences && !field .isDefaultValue ())
         {
            generator .string += generator .Break ();
            generator .string += generator .Indent ();
            generator .string += generator .AccessType (field .getAccessType ()) .padEnd (accessTypeLength, generator .TidySpace ());
            generator .string += generator .Space ();
            generator .string += field .getTypeName () .padEnd (fieldTypeLength, generator .TidySpace ());
            generator .string += generator .Space ();
            generator .string += field .getName ();

            if (field .isInitializable ())
            {
               generator .string += generator .Space ();

               field .toVRMLStream (generator);
            }
         }
      }
   },
   toVRMLStreamField (generator, field)
   {
      const sharedNode = generator .IsSharedNode (this);

      if (field .getReferences () .size === 0 || !generator .ExecutionContext () || sharedNode)
      {
         if (field .isInitializable ())
         {
            generator .string += generator .Indent ();
            generator .string += field .getName ();
            generator .string += generator .Space ();

            field .toVRMLStream (generator);
         }
      }
      else
      {
         let
            index                  = 0,
            initializableReferences = false;

         for (const reference of field .getReferences ())
         {
            initializableReferences ||= reference .isInitializable ();

            // Output build in reference field

            generator .string += generator .Indent ();
            generator .string += field .getName ();
            generator .string += generator .Space ();
            generator .string += "IS";
            generator .string += generator .Space ();
            generator .string += reference .getName ();

            ++ index;

            if (index !== field .getReferences () .size)
               generator .string += generator .Break ();
         }

         if (field .getAccessType () === _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .inputOutput && !initializableReferences && !this .isDefaultValue (field))
         {
            // Output build in field

            generator .string += generator .Break ();
            generator .string += generator .Indent ();
            generator .string += field .getName ();
            generator .string += generator .Space ();

            field .toVRMLStream (generator);
         }
      }
   },
   toXMLStream (generator)
   {
      generator .EnterScope ();

      const
         sharedNode = generator .IsSharedNode (this),
         name       = generator .Name (this);

      if (name .length)
      {
         if (generator .ExistsNode (this))
         {
            generator .openTag (this .getTypeName ());

            if (generator .html && this .getTypeName () === "Script")
               generator .attribute ("type", "model/x3d+xml");

            generator .attribute ("USE", name);

            const containerField = generator .ContainerField ();

            if (containerField)
            {
               if (containerField .getName () !== this .getContainerField ())
                  generator .attribute ("containerField", containerField .getName ());
            }

            generator .closeTag (this .getTypeName ());
            generator .LeaveScope ();
            return;
         }
      }

      generator .openTag (this .getTypeName ());

      if (generator .html && this .getTypeName () === "Script")
         generator .attribute ("type", "model/x3d+xml");

      if (name .length)
      {
         generator .AddNode (this);
         generator .attribute ("DEF", name);
      }

      const containerField = generator .ContainerField ();

      if (containerField)
      {
         if (containerField .getName () !== this .getContainerField ())
            generator .attribute ("containerField", containerField .getName ());
      }

      const
         fields            = this .getChangedFields (),
         userDefinedFields = this .getUserDefinedFields ();

      const
         references = [ ],
         childNodes = [ ];

      let cdata = this .getSourceText ();

      if (cdata ?.length === 0 || (generator .html && this .getTypeName () !== "Script"))
         cdata = null;

      if (!cdata ?.some (string => string .match (/^\s*(?:data|ecmascript|javascript|vrmlscript)\:/s)))
         cdata = null;

      generator .IncIndent ();
      generator .IncIndent ();

      for (const field of fields)
      {
         // If the field is a inputOutput and we have as reference only inputOnly or outputOnly we must output the value
         // for this field.

         let mustOutputValue = false;

         if (generator .ExecutionContext ())
         {
            if (field .getAccessType () === _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .inputOutput && field .getReferences () .size !== 0)
            {
               if (!Array .from (field .getReferences ()) .some (reference => reference .isInitializable ()))
                  mustOutputValue = !this .isDefaultValue (field);
            }
         }

         // If we have no execution context we are not in a proto and must not generate IS references the same is true
         // if the node is a shared node as the node does not belong to the execution context.

         if (field .getReferences () .size === 0 || !generator .ExecutionContext () || sharedNode || mustOutputValue)
         {
            if (mustOutputValue)
               references .push (field);

            if (field .isInitializable ())
            {
               switch (field .getType ())
               {
                  case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .SFNode:
                  case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .MFNode:
                  {
                     childNodes .push (field);
                     break;
                  }
                  default:
                  {
                     if (field === cdata)
                        break;

                     generator .string += generator .AttribBreak ();
                     generator .string += generator .ListIndent ();
                     generator .string += field .getName ();
                     generator .string += "='";

                     field .toXMLStream (generator, field === this .getSourceText ());

                     generator .string += "'";
                     break;
                  }
               }
            }
         }
         else
         {
            references .push (field);
         }
      }

      generator .DecIndent ();
      generator .DecIndent ();

      if ((!this .canUserDefinedFields () || !userDefinedFields .length) && (!references .length || sharedNode) && !childNodes .length && !cdata)
      {
         generator .closeTag (this .getTypeName ());
      }
      else
      {
         generator .endTag ();
         generator .IncIndent ();

         if (this .canUserDefinedFields ())
         {
            for (const field of userDefinedFields)
            {
               generator .openTag ("field");
               generator .attribute ("accessType", generator .AccessType (field .getAccessType ()));
               generator .attribute ("type",       field .getTypeName ());
               generator .attribute ("name",       field .getName ());

               // If the field is a inputOutput and we have as reference only inputOnly or outputOnly we must output the value
               // for this field.

               let mustOutputValue = false;

               if (generator .ExecutionContext ())
               {
                  if (field .getAccessType () === _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .inputOutput && field .getReferences () .size !== 0)
                  {
                     if (!Array .from (field .getReferences ()) .some (reference => reference .isInitializable ()))
                        mustOutputValue = true;
                  }
               }

               if ((field .getReferences () .size === 0 || !generator .ExecutionContext ()) || sharedNode || mustOutputValue)
               {
                  if (mustOutputValue && generator .ExecutionContext ())
                     references .push (field);

                  if (!field .isInitializable () || field .isDefaultValue ())
                  {
                     if (field .getAppInfo ())
                        generator .attribute ("appinfo", field .getAppInfo ());

                     if (field .getDocumentation ())
                        generator .attribute ("documentation", field .getDocumentation ());

                     generator .closeTag ("field");
                     generator .AddTidyBreak ();
                  }
                  else
                  {
                     // Output value

                     switch (field .getType ())
                     {
                        case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .SFNode:
                        case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .MFNode:
                        {
                           if (field .getAppInfo ())
                              generator .attribute ("appinfo", field .getAppInfo ());

                           if (field .getDocumentation ())
                              generator .attribute ("documentation", field .getDocumentation ());

                           generator .endTag ();
                           generator .IncIndent ();
                           generator .PushContainerField (null);

                           field .toXMLStream (generator);

                           generator .AddTidyBreak ();
                           generator .DecIndent ();
                           generator .closingTag ("field");
                           generator .AddTidyBreak ();
                           generator .PopContainerField ();
                           break;
                        }
                        default:
                        {
                           generator .string += generator .Space ();
                           generator .string += "value='";

                           field .toXMLStream (generator);

                           generator .string += "'";

                           if (field .getAppInfo ())
                              generator .attribute ("appinfo", field .getAppInfo ());

                           if (field .getDocumentation ())
                              generator .attribute ("documentation", field .getDocumentation ());

                           generator .closeTag ("field");
                           generator .AddTidyBreak ();
                           break;
                        }
                     }
                  }
               }
               else
               {
                  if (generator .ExecutionContext ())
                     references .push (field);

                  if (field .getAppInfo ())
                     generator .attribute ("appinfo", field .getAppInfo ());

                  if (field .getDocumentation ())
                     generator .attribute ("documentation", field .getDocumentation ());

                  generator .closeTag ("field");
                  generator .AddTidyBreak ();
               }
            }
         }

         if (references .length && !sharedNode)
         {
            generator .openingTag ("IS");
            generator .AddTidyBreak ();
            generator .IncIndent ();

            for (const field of references)
            {
               const protoFields = field .getReferences ();

               for (const protoField of protoFields)
               {
                  generator .openTag ("connect");
                  generator .attribute ("nodeField",  field .getName ());
                  generator .attribute ("protoField", protoField .getName ());
                  generator .closeTag ("connect");
                  generator .AddTidyBreak ();
               }
            }

            generator .DecIndent ();
            generator .closingTag ("IS");
            generator .AddTidyBreak ();
         }

         for (const field of childNodes)
         {
            generator .PushContainerField (field);

            field .toXMLStream (generator);

            generator .AddTidyBreak ();
            generator .PopContainerField ();
         }

         for (const value of cdata ?? [ ])
         {
            generator .string += "<![CDATA[";
            generator .string += value;
            generator .string += "]]>";
            generator .string += generator .Break ();
         }

         generator .DecIndent ();
         generator .closingTag (this .getTypeName ());
      }

      generator .LeaveScope ();
   },
   toJSONStream (generator)
   {
      generator .EnterScope ();

      const
         sharedNode = generator .IsSharedNode (this),
         name       = generator .Name (this);

      // Type name

      generator .beginObject (this .getTypeName (), false, true);

      // USE name

      if (name .length)
      {
         if (generator .ExistsNode (this))
         {
            generator .stringProperty ("@USE", name, false);
            generator .endObject ();
            generator .endObject ();

            generator .LeaveScope ();
            return;
         }
      }

      let comma = false;

      // DEF name

      if (name .length)
      {
         generator .AddNode (this);
         generator .stringProperty ("@DEF", name, false);

         comma = true;
      }

      // Fields

      const
         fields            = this .getChangedFields (),
         userDefinedFields = this .getUserDefinedFields ();

      const references = [ ];

      let sourceText = this .getSourceText ();

      // Source text

      if (sourceText ?.length !== 1)
         sourceText = null;

      if (!sourceText ?.some (string => string .match (/^\s*(?:data|ecmascript|javascript|vrmlscript)\:/s)))
         sourceText = null;

      // Predefined fields

      if (fields .length)
      {
         const outputFields = [ ];

         for (const field of fields)
         {
            // If the field is a inputOutput and we have as reference only inputOnly or outputOnly we must output the value
            // for this field.

            let mustOutputValue = false;

            if (generator .ExecutionContext ())
            {
               if (field .getAccessType () === _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .inputOutput && field .getReferences () .size !== 0)
               {
                  if (!Array .from (field .getReferences ()) .some (reference => reference .isInitializable ()))
                     mustOutputValue = !this .isDefaultValue (field);
               }
            }

            // If we have no execution context we are not in a proto and must not generate IS references the same is true
            // if the node is a shared node as the node does not belong to the execution context.

            if (field .getReferences () .size === 0 || !generator .ExecutionContext () || sharedNode || mustOutputValue)
            {
               if (mustOutputValue)
                  references .push (field);

               if (field !== sourceText && field .isInitializable ())
                  outputFields .push (field);
            }
            else
            {
               references .push (field);
            }
         }

         for (const field of outputFields)
         {
            switch (field .getType ())
            {
               case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .SFNode:
               case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .MFNode:
               {
                  generator .beginValue (`-${field .getName ()}`, comma || field !== outputFields [0]);

                  field .toJSONStream (generator);
                  break;
               }
               default:
               {
                  generator .beginValue (`@${field .getName ()}`, comma || field !== outputFields [0]);

                  field .toJSONStream (generator);
                  break;
               }
            }
         }

         comma ||= !! outputFields .length;
      }

      // User defined fields

      if (this .canUserDefinedFields () && userDefinedFields .length)
      {
         generator .beginArray ("field", comma);

         for (const field of userDefinedFields)
         {
            generator .beginObject ("", field !== userDefinedFields [0]);
            generator .stringProperty ("@accessType", generator .AccessType (field .getAccessType ()), false);
            generator .stringProperty ("@type",       field .getTypeName ());
            generator .stringProperty ("@name",       field .getName ());

            // If the field is a inputOutput and we have as reference only inputOnly or outputOnly we must output the value
            // for this field.

            let mustOutputValue = false;

            if (generator .ExecutionContext ())
            {
               if (field .getAccessType () === _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .inputOutput && field .getReferences () .size !== 0)
               {
                  if (!Array .from (field .getReferences ()) .some (reference => reference .isInitializable ()))
                     mustOutputValue = true;
               }
            }

            if ((field .getReferences () .size === 0 || !generator .ExecutionContext ()) || sharedNode || mustOutputValue)
            {
               if (mustOutputValue && generator .ExecutionContext ())
                  references .push (field);

               if (field .isInitializable () && !field .isDefaultValue ())
               {
                  // Output value

                  switch (field .getType ())
                  {
                     case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .SFNode:
                     {
                        generator .beginArray ("-children");

                        generator .string += generator .TidyBreak ();
                        generator .string += generator .Indent ();

                        field .toJSONStream (generator);

                        generator .endArray ();
                        break;
                     }
                     case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .MFNode:
                     {
                        generator .beginValue ("-children");

                        field .toJSONStream (generator);
                        break;
                     }
                     default:
                     {
                        generator .beginValue ("@value");

                        field .toJSONStream (generator);
                        break;
                     }
                  }
               }
            }
            else
            {
               if (generator .ExecutionContext ())
                  references .push (field);
            }

            if (field .getAppInfo ())
               generator .stringProperty ("@appinfo", field .getAppInfo ());

            if (field .getDocumentation ())
               generator .stringProperty ("@documentation", field .getDocumentation ());

            generator .endObject ();
         }

         generator .endArray ();

         comma = true;
      }

      // Source text

      if (sourceText)
      {
         generator .beginArray ("#sourceCode", comma);

         const lines = sourceText [0] .split ("\n");

         for (const [i, line] of lines .entries ())
         {
            if (i !== 0)
               generator .string += ',';

            generator .string += generator .TidyBreak ();
            generator .string += generator .ListIndent ();
            generator .string += '"';
            generator .string += generator .EncodeString (line);
            generator .string += '"';
         }

         generator .endArray ();

         comma = true;
      }

      // IS references

      if (references .length && !sharedNode)
      {
         generator .beginObject ("IS", comma);
         generator .beginArray ("connect", false);

         for (const field of references)
         {
            const protoFields = Array .from (field .getReferences ());

            for (const protoField of protoFields)
            {
               generator .beginObject ("", field !== references [0] || protoField !== protoFields [0]);
               generator .stringProperty ("@nodeField",  field .getName (), false);
               generator .stringProperty ("@protoField", protoField .getName ());
               generator .endObject ();
            }
         }

         generator .endArray ();
         generator .endObject ();
      }

      // End

      generator .endObject ();
      generator .endObject ();

      generator .LeaveScope ();
   },
   dispose ()
   {
      const executionContext = this .getExecutionContext ();

      // Remove named node if any.

      if (this .getName ())
         executionContext .removeNamedNode (this .getName ())

      if (executionContext .isScene)
      {
         // Remove exported node if any.

         for (const exportedNode of Array .from (executionContext .getExportedNodes ()))
         {
            if (exportedNode .getLocalNode () === this)
               executionContext .removeExportedNode (exportedNode .getExportedName ());
         }

         // Remove imported node if any.

         const parentContext = executionContext .getExecutionContext ();

         if (parentContext)
         {
            for (const importedNode of parentContext .getImportedNodes ())
               importedNode .getExportedNode () .update ();
         }
      }

      // Remove node from entire scene graph.

      for (const firstParent of Array .from (this .getParents ()))
      {
         if (!(firstParent instanceof _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFNode))
            continue;

         for (const secondParent of Array .from (firstParent .getParents ()))
         {
            if (!(secondParent instanceof _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFNode))
               continue;

            secondParent .setValue (Array .from (secondParent) .filter (node => node ?.getValue () !== this))
         }
      }

      for (const firstParent of Array .from (this .getParents ()))
      {
         if (!(firstParent instanceof _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFNode))
            continue;

         firstParent .setValue (null);
      }

      _Fields_SFNodeCache_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .delete (this);

      // Call super.dispose, where fields get disposed.

      _Base_X3DBaseNode_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .prototype .dispose .call (this);
   },
});

for (const key of Object .keys (X3DNode .prototype))
   Object .defineProperty (X3DNode .prototype, key, { enumerable: false });

Object .defineProperties (X3DNode,
{
   getStaticProperties:
   {
      value (typeName, componentName, componentLevel, containerField, fromVersion, toVersion = "Infinity")
      {
         return {
            typeName:
            {
               value: typeName,
               enumerable: true,
            },
            componentInfo:
            {
               value: Object .freeze ({ name: componentName, level: componentLevel }),
               enumerable: true,
            },
            ... containerField ?
            {
               containerField:
               {
                  value: containerField,
                  enumerable: true,
               },
            } : { },
            ... fromVersion && toVersion ?
            {
               specificationRange:
               {
                  value: Object .freeze ({ from: fromVersion, to: toVersion }),
                  enumerable: true,
               },
            } : { },
         };
      },
   },
})

Object .defineProperties (X3DNode, X3DNode .getStaticProperties ("X3DNode", "Core", 1));

const __default__ = X3DNode;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .add ("X3DNode", __default__));

/***/ }),

/***/ 2489:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(717);
const __default__ = "12.1.2";
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .add ("BROWSER_VERSION", __default__));

/***/ }),

/***/ 2502:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Base_X3DInfoArray_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(3020);
/* harmony import */ var _X3DExportedNode_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(6491);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(717);



function ExportedNodesArray (values = [ ])
{
   return _Base_X3DInfoArray_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .call (this, Array .from (values, value => [value .getExportedName (), value]), _X3DExportedNode_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A);
}

Object .setPrototypeOf (ExportedNodesArray .prototype, _Base_X3DInfoArray_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .prototype);

for (const key of Object .keys (ExportedNodesArray .prototype))
   Object .defineProperty (ExportedNodesArray .prototype, key, { enumerable: false });

Object .defineProperties (ExportedNodesArray,
{
   typeName:
   {
      value: "ExportedNodesArray",
      enumerable: true,
   },
});

const __default__ = ExportedNodesArray;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .add ("ExportedNodesArray", __default__));

/***/ }),

/***/ 2526:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  A: () => (/* binding */ Grouping_X3DBoundedObject)
});

// EXTERNAL MODULE: ./src/x_ite/Fields.js + 15 modules
var Fields = __webpack_require__(4598);
// EXTERNAL MODULE: ./src/x_ite/Components/Core/X3DNode.js
var X3DNode = __webpack_require__(2340);
// EXTERNAL MODULE: ./src/x_ite/Base/X3DConstants.js
var X3DConstants = __webpack_require__(2212);
// EXTERNAL MODULE: ./src/x_ite/Base/X3DFieldDefinition.js
var X3DFieldDefinition = __webpack_require__(2040);
// EXTERNAL MODULE: ./src/x_ite/Base/FieldDefinitionArray.js
var FieldDefinitionArray = __webpack_require__(1870);
// EXTERNAL MODULE: ./src/x_ite/Components/Core/X3DChildNode.js
var X3DChildNode = __webpack_require__(5084);
// EXTERNAL MODULE: ./src/x_ite/Rendering/TraverseType.js
var TraverseType = __webpack_require__(2927);
// EXTERNAL MODULE: ./src/standard/Math/Numbers/Matrix4.js
var Matrix4 = __webpack_require__(6179);
// EXTERNAL MODULE: ./src/standard/Math/Geometry/Box3.js
var Box3 = __webpack_require__(2918);
// EXTERNAL MODULE: ./src/standard/Math/Numbers/Vector3.js
var Vector3 = __webpack_require__(7572);
// EXTERNAL MODULE: ./src/x_ite/Namespace.js
var Namespace = __webpack_require__(717);
;// ./src/x_ite/Browser/Grouping/X3DBBoxNode.js











function X3DBBoxNode (executionContext, boundedObject)
{
   X3DChildNode/* default */.A .call (this, executionContext);

   // Private properties

   this .boundedObject = boundedObject;
   this .bboxShape     = this .getBrowser () .getBBoxShape ();
}

Object .assign (Object .setPrototypeOf (X3DBBoxNode .prototype, X3DChildNode/* default */.A .prototype),
{
   getMatrix: (() =>
   {
      const
         bbox    = new Box3/* default */.A (),
         matrix  = new Matrix4/* default */.A (),
         epsilon = new Vector3/* default */.A (1e-6);

      return function ()
      {
         this .boundedObject .getBBox (bbox);

         const
            browser    = this .getBrowser (),
            max        = browser .getRenderingProperty ("ContentScale") === 1 ? Vector3/* default */.A .ZERO : epsilon,
            bboxSize   = bbox .size .max (max),
            bboxCenter = bbox .center;

         return matrix .set (bboxCenter, null, bboxSize);
      };
   })(),
   getShapes (shapes, parentModelMatrix)
   {
      const modelMatrix = parentModelMatrix .copy () .multLeft (this .getMatrix ());

      return this .bboxShape .getShapes (shapes, modelMatrix);
   },
   traverse (type, renderObject)
   {
      if (type === TraverseType/* default */.A .PICKING)
         return;

      const modelViewMatrix = renderObject .getModelViewMatrix ();

      modelViewMatrix .push ();
      modelViewMatrix .multLeft (this .getMatrix ());

      this .bboxShape .traverse (type, renderObject);

      modelViewMatrix .pop ();
   },
});

Object .defineProperties (X3DBBoxNode,
{
   ... X3DNode/* default */.A .getStaticProperties ("X3DBBoxNode", "Grouping", 1, "children", "2.0"),
   fieldDefinitions:
   {
      value: new FieldDefinitionArray/* default */.A ([
         new X3DFieldDefinition/* default */.A (X3DConstants/* default */.A .inputOutput, "metadata", new Fields/* default */.A .SFNode ()),
      ]),
      enumerable: true,
   },
});

const __default__ = X3DBBoxNode;
;

/* harmony default export */ const Grouping_X3DBBoxNode = (Namespace/* default */.A .add ("X3DBBoxNode", __default__));
;// ./src/x_ite/Components/Grouping/X3DBoundedObject.js







function X3DBoundedObject (executionContext)
{
   this .addType (X3DConstants/* default */.A .X3DBoundedObject);

   this .addChildObjects (X3DConstants/* default */.A .outputOnly, "hidden",           new Fields/* default */.A .SFBool (),
                          X3DConstants/* default */.A .outputOnly, "display",          new Fields/* default */.A .SFBool (true),
                          X3DConstants/* default */.A .outputOnly, "transformSensors", new Fields/* default */.A .SFTime ());

   // Units

   this ._bboxSize   .setUnit ("length");
   this ._bboxCenter .setUnit ("length");

   // Private properties

   this .childBBox            = new Box3/* default */.A (); // Must be unique for each X3DBoundedObject.
   this .transformSensorNodes = new Set ();
}

Object .assign (X3DBoundedObject .prototype,
{
   childBBox: new Box3/* default */.A (), // X3DExecutionContext needs this.
   initialize ()
   {
      this ._hidden  .addInterest ("set_visible_and_hidden__", this);
      this ._visible .addInterest ("set_visible_and_hidden__", this);

      this .set_visible_and_hidden__ ();
   },
   isVisible ()
   {
      return this ._display .getValue ();
   },
   isHidden ()
   {
      return this ._hidden .getValue ();
   },
   setHidden (value)
   {
      if (value === this ._hidden .getValue ())
         return;

      this ._hidden = value;
   },
   isDefaultBBoxSize: (() =>
   {
      const defaultBBoxSize = new Vector3/* default */.A (-1);

      return function ()
      {
         return this ._bboxSize .getValue () .equals (defaultBBoxSize);
      };
   })(),
   isBBoxVisible ()
   {
      return this ._bboxDisplay .getValue ();
   },
   getBBox (nodes, bbox, shadows)
   {
      // Must be unique for each X3DBoundedObject.
      const childBBox = this .childBBox;

      // Add bounding boxes.

      bbox .set ();

      for (const node of nodes)
         bbox .add (node .getBBox ?.(childBBox, shadows) ?? childBBox .set ());

      return bbox;
   },
   getBBoxNode ()
   {
      return this .bboxNode ??= (() =>
      {
         const bboxNode = new Grouping_X3DBBoxNode (this .getExecutionContext (), this);

         bboxNode .setPrivate (true);
         bboxNode .setup ();

         return bboxNode;
      })();
   },
   addTransformSensor (transformSensorNode)
   {
      this .transformSensorNodes .add (transformSensorNode);

      this ._transformSensors = this .getBrowser () .getCurrentTime ();
   },
   removeTransformSensor (transformSensorNode)
   {
      this .transformSensorNodes .delete (transformSensorNode);

      this ._transformSensors = this .getBrowser () .getCurrentTime ();
   },
   getTransformSensors ()
   {
      return this .transformSensorNodes;
   },
   set_visible_and_hidden__ ()
   {
      const value = this ._visible .getValue () && !this ._hidden .getValue ();

      if (value === this ._display .getValue ())
         return;

      this ._display = value;
   },
   dispose () { },
});

Object .defineProperties (X3DBoundedObject, X3DNode/* default */.A .getStaticProperties ("X3DBoundedObject", "Grouping", 1));

const X3DBoundedObject_default_ = X3DBoundedObject;
;

/* harmony default export */ const Grouping_X3DBoundedObject = (Namespace/* default */.A .add ("X3DBoundedObject", X3DBoundedObject_default_));

/***/ }),

/***/ 2532:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Fields_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(4598);
/* harmony import */ var _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(2040);
/* harmony import */ var _Base_FieldDefinitionArray_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(1870);
/* harmony import */ var _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(2340);
/* harmony import */ var _Layer_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(3314);
/* harmony import */ var _Base_X3DCast_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(7638);
/* harmony import */ var _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(2212);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(717);








function LayerSet (executionContext)
{
   _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .call (this, executionContext);

   this .addType (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .LayerSet);

   this .addChildObject (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .outputOnly, "activeLayerNode",  new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFNode ());

   this .layerNodes = [ new _Layer_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A (executionContext) ];
   this .layerNode0 = this .layerNodes [0];
}

Object .assign (Object .setPrototypeOf (LayerSet .prototype, _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .prototype),
{
   initialize ()
   {
      _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .prototype .initialize .call (this);

      this .layerNode0 .setPrivate (true);
      this .layerNode0 .setup ();
      this .layerNode0 .setLayer0 (true);

      this ._activeLayer .addInterest ("set_activeLayer__", this);
      this ._order       .addInterest ("set_layers__",      this);
      this ._layers      .addInterest ("set_layers__",      this);

      this .set_layers__ ();
   },
   getActiveLayer ()
   {
      return this ._activeLayerNode .getValue ();
   },
   getLayer0 ()
   {
      return this .layerNode0;
   },
   setLayer0 (value)
   {
      this .layerNode0 = value;

      this .set_layers__ ();
   },
   getLayers ()
   {
      return this .layerNodes;
   },
   set_activeLayer__ ()
   {
      let activeLayerNode;

      if (this ._activeLayer .getValue () === 0)
      {
         activeLayerNode = this .layerNode0;
      }
      else
      {
         const index = this ._activeLayer .getValue () - 1;

         if (index >= 0 && index < this ._layers .length)
         {
            activeLayerNode = (0,_Base_X3DCast_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A) (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .X3DLayerNode, this ._layers [index]);
         }
         else
         {
            activeLayerNode = null;
         }
      }

      if (!activeLayerNode ?._display .getValue ())
         activeLayerNode = null;

      if (this ._activeLayerNode .getValue () !== activeLayerNode)
         this ._activeLayerNode = activeLayerNode;
   },
   set_layers__ ()
   {
      const layers = this ._layers .getValue ();

      for (const layerNode of this .layerNodes)
         layerNode ._display .removeInterest ("set_layers__", this);

      this .layerNodes .length = 0;

      for (let index of this ._order)
      {
         if (index === 0)
         {
            this .layerNode0 ._display .addInterest ("set_layers__", this);
            this .layerNodes .push (this .layerNode0);
         }
         else
         {
            -- index;

            if (index >= 0 && index < layers .length)
            {
               const layerNode = (0,_Base_X3DCast_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A) (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .X3DLayerNode, layers [index]);

               if (!layerNode)
                  continue;

               layerNode ._display .addInterest ("set_layers__", this);

               if (layerNode ._display .getValue ())
                  this .layerNodes .push (layerNode);
            }
         }
      }

      this .set_activeLayer__ ();
   },
   bindBindables (viewpointName)
   {
      this .layerNode0 ?.bindBindables (viewpointName);

      for (const node of this ._layers)
      {
         const layerNode = (0,_Base_X3DCast_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A) (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .X3DLayerNode, node);

         layerNode ?.bindBindables (viewpointName);
      }
   },
   traverse (type, renderObject)
   {
      for (const layerNode of this .layerNodes)
         layerNode .traverse (type, renderObject);
   },
});

Object .defineProperties (LayerSet,
{
   ... _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .getStaticProperties ("LayerSet", "Layering", 1, "children", "3.2"),
   fieldDefinitions:
   {
      value: new _Base_FieldDefinitionArray_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A ([
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .inputOutput, "metadata",    new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFNode ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .inputOutput, "activeLayer", new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFInt32 ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .inputOutput, "order",       new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFInt32 (0)),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .inputOutput, "layers",      new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFNode ()),
      ]),
      enumerable: true,
   },
});

const __default__ = LayerSet;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .add ("LayerSet", __default__));

/***/ }),

/***/ 2605:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Base_X3DObject_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(946);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(717);


function UnitInfo (category, name, conversionFactor)
{
   Object .defineProperties (this,
   {
      category: { value: category, enumerable: true },
      name: { value: name, enumerable: true },
      conversionFactor: { value: conversionFactor, enumerable: true },
   });
}

Object .assign (Object .setPrototypeOf (UnitInfo .prototype, _Base_X3DObject_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .prototype),
{
   toVRMLStream (generator)
   {
      generator .string += generator .Indent ();
      generator .string += "UNIT";
      generator .string += generator .Space ();
      generator .string += this .category;
      generator .string += generator .Space ();
      generator .string += this .name;
      generator .string += generator .Space ();
      generator .string += this .conversionFactor;
   },
   toXMLStream (generator)
   {
      generator .openTag ("unit");
      generator .attribute ("category",         this .category);
      generator .attribute ("name",             this .name);
      generator .attribute ("conversionFactor", this .conversionFactor);
      generator .closeTag ("unit");
   },
   toJSONStream (generator, _throw)
   {
      if (this .conversionFactor === 1)
         throw new Error ("conversionFactor is 1");

      generator .beginObject ("", false);
      generator .stringProperty ("@category",         this .category, false);
      generator .stringProperty ("@name",             this .name);
      generator .numberProperty ("@conversionFactor", this .conversionFactor);
      generator .endObject ();
   },
});

for (const key of Object .keys (UnitInfo .prototype))
   Object .defineProperty (UnitInfo .prototype, key, { enumerable: false });

Object .defineProperty (UnitInfo .prototype, "conversion_factor",
{
   get () { return this .conversionFactor; },
});

Object .defineProperties (UnitInfo,
{
   typeName:
   {
      value: "UnitInfo",
      enumerable: true,
   },
});

const __default__ = UnitInfo;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .add ("UnitInfo", __default__));

/***/ }),

/***/ 2911:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _XMLParser_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(1206);
/* harmony import */ var _X3DParser_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(6376);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(717);
/* provided dependency */ var $ = __webpack_require__(9547);



function JSONParser (scene)
{
   _X3DParser_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .call (this, scene);

   this .namespace = "http://www.web3d.org/specifications/x3d-namespace";
}

Object .assign (Object .setPrototypeOf (JSONParser .prototype, _X3DParser_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .prototype),
{
   getEncoding ()
   {
      return "JSON";
   },
   setInput (json)
   {
      try
      {
         if (typeof json === "string")
            json = JSON .parse (json);

         this .input = json;
      }
      catch
      {
         this .input = undefined;
      }
   },
   isValid ()
   {
      return this .input instanceof Object;
   },
   parseIntoScene (resolve, reject)
   {
      /**
       * Load X3D JSON into an element.
       * json - the JavaScript object to convert to DOM.
       */

      const child = this .createElement ("X3D");

      this .convertToDOM (this .input, "", child);

      // Call the DOM parser.

      const parser = new _XMLParser_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A (this .getScene ());

      parser .setInput (child);
      parser .parseIntoScene (resolve, reject);

      this .getScene () .setEncoding ("JSON");
   },
   elementSetAttribute (element, key, value)
   {
      /**
       * Yet another way to set an attribute on an element.  does not allow you to
       * set JSON schema or encoding.
       */

      switch (key)
      {
         case "SON schema":
         {
            // JSON Schema
            break;
         }
         case "ncoding":
         {
            // encoding, UTF-8, UTF-16 or UTF-32
            break;
         }
         default:
         {
            if (typeof element .setAttribute === "function")
               element .setAttribute (key, value);

            break;
         }
      }
   },
   convertChildren (parentkey, object, element)
   {
      /**
       * converts children of object to DOM.
       */

      for (const key in object)
      {
         if (typeof object [key] !== "object")
            continue;

         if (isNaN (parseInt (key)))
            this .convertObject (key, object, element, parentkey .substring (1));
         else
            this .convertToDOM (object [key], key, element, parentkey .substring (1));
      }
   },
   createElement (key, containerField)
   {
      /**
       * a method to create and element with tagnam key to DOM in a namespace.  If
       * containerField is set, then the containerField is set in the elemetn.
       */

      let child;

      if (typeof this .namespace === "undefined")
      {
         child = document .createElement (key);
      }
      else
      {
         child = document .createElementNS (this .namespace, key);

         if (child === null || typeof child === "undefined")
         {
            console .error ("Trouble creating element for", key);

            child = document .createElement (key);
         }
      }

      if (typeof containerField !== "undefined")
         this .elementSetAttribute (child, "containerField", containerField);

      return child;
   },
   createCDATA (document, element, str)
   {
      const
         docu  = $.parseXML ("<xml></xml>", "application/xml"),
         cdata = docu .createCDATASection (str);

      element .appendChild (cdata);
   },
   convertObject (key, object, element, containerField)
   {
      /**
       * convert the object at object[key] to DOM.
       */

      if (object !== null && typeof object [key] === "object")
      {
         if (key [0] === "@")
         {
            this .convertToDOM (object [key], key, element);
         }
         else if (key [0] === "-")
         {
            this .convertChildren (key, object [key], element);
         }
         else if (key === "#comment")
         {
            for (const c in object [key])
            {
               const child = document .createComment (this .commentStringToXML (object [key] [c]));

               element .appendChild (child);
            }
         }
         else if (key === "#sourceCode" || key === "@sourceCode" || key === "#sourceText")
         {
            this .createCDATA (document, element, object [key] .join ("\n"));
         }
         else if (key === "connect" || key === "fieldValue" || key === "field" || key === "meta" || key === "component" || key === "unit")
         {
            for (const childkey in object [key])
            {
               // for each field
               if (typeof object [key] [childkey] === "object")
               {
                  const child = this .createElement (key, containerField);

                  this .convertToDOM (object [key] [childkey], childkey, child);

                  element .appendChild (child);
                  element .appendChild (document .createTextNode ("\n"));
               }
            }
         }
         else
         {
            const child = this .createElement (key, containerField);

            this .convertToDOM (object [key], key, child);

            element .appendChild (child);
            element .appendChild (document .createTextNode ("\n"));
         }
      }
   },
   commentStringToXML (str)
   {
      /**
       * convert a comment string in JavaScript to XML.  Pass the string
       */

      return str .replace (/\\\\/g, "\\");
   },
   SFStringToXML (str)
   {
      /**
       * convert an SFString to XML.
       */

      return String (str) .replace (/([\\"])/g, "\\$1");
   },
   JSONStringToXML (str)
   {
      /**
       * convert a JSON String to XML.
       */

      str = str .replace (/\\/g, "\\\\");
      str = str .replace (/\n/g, "\\n");

      return str;
   },
   convertToDOM (object, parentkey, element, containerField)
   {
      /**
       * main routine for converting a JavaScript object to DOM.
       * object is the object to convert.
       * parentkey is the key of the object in the parent.
       * element is the parent element.
       * containerField is a possible containerField.
       */

      if (object === null)
      {
         const isArray = !isNaN (parseInt (parentkey));

         if (isArray)
         {
            const child = this .createElement ("NULL", containerField);

            element .appendChild (child);
         }
         else
         {
            this .elementSetAttribute (element, "value", null);
         }

         return element;
      }

      let
         isArray        = false,
         localArray     = [ ],
         arrayOfStrings = false;

      for (const key in object)
      {
         isArray = !isNaN (parseInt (key));

         if (isArray)
         {
            switch (typeof object [key])
            {
               case "number":
               {
                  localArray .push (object [key]);
                  break;
               }
               case "string":
               {
                  localArray .push (object [key]);

                  arrayOfStrings = true;
                  break;
               }
               case "boolean":
               {
                  localArray .push (object [key]);
                  break;
               }
               case "object":
               {
                  /*
                  if (object[key] != null && typeof object[key].join === "function") {
                     localArray.push(object[key].join(" "));
                  }
                  */
                  this .convertToDOM (object [key], key, element);
                  break;
               }
               case "undefined":
               {
                  break;
               }
               default:
               {
                  console .error (`Unknown type found in array ${typeof object [key]}`);
               }
            }
         }
         else
         {
            switch (typeof object [key])
            {
               case "object":
               {
                  // This is where the whole thing starts

                  if (key === "X3D")
                     this .convertToDOM (object [key], key, element);

                  else
                     this .convertObject (key, object, element, containerField);

                  break;
               }
               case "number":
               {
                  this .elementSetAttribute (element, key .substring (1), object [key]);
                  break;
               }
               case "string":
               {
                  if (key !== "#comment")
                  {
                     // ordinary string attributes
                     this .elementSetAttribute (element, key .substring (1), this .JSONStringToXML (object [key]));
                  }
                  else
                  {
                     const child = document .createComment (this .commentStringToXML (object [key]));

                     element .appendChild (child);
                  }

                  break;
               }
               case "boolean":
               {
                  this .elementSetAttribute (element, key .substring (1), object [key]);
                  break;
               }
               case "undefined":
               {
                  break;
               }
               default:
               {
                  console .error (`Unknown type found in object ${typeof object [key]}`);
                  console .error (object);
               }
            }
         }
      }

      if (isArray)
      {
         if (parentkey [0] === "@")
         {
            if (arrayOfStrings)
            {
               arrayOfStrings = false;

               for (const [str, value] of localArray .entries ())
                  localArray [str] = this .SFStringToXML (value);

               this .elementSetAttribute (element, parentkey .substring (1), '"' + localArray .join ('" "') + '"');
            }
            else
            {
               // if non string array
               this .elementSetAttribute (element, parentkey .substring (1), localArray .join (" "));
            }
         }

         isArray = false;
      }

      return element;
   },
});

const __default__ = JSONParser;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .add ("JSONParser", __default__));

/***/ }),

/***/ 2918:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Numbers_Matrix4_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6179);
/* harmony import */ var _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(7572);
/* harmony import */ var _Algorithms_SAT_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(336);
/* harmony import */ var _x_ite_Namespace_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(717);




function Box3 (... args) /* size, center */
{
   this .matrix = new _Numbers_Matrix4_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A ();

   this .set (... arguments);
}

Object .assign (Box3 .prototype,
{
   copy ()
   {
      const copy = Object .create (Box3 .prototype);

      copy .matrix = this .matrix .copy ();

      return copy;
   },
   assign (box)
   {
      this .matrix .assign (box .matrix);

      return this;
   },
   equals (box)
   {
      return this .matrix .equals (box .matrix);
   },
   getMatrix ()
   {
      return this .matrix;
   },
   set (size, center)
   {
      switch (arguments .length)
      {
         case 0:
         {
            this .matrix .set (0, 0, 0, 0,
                               0, 0, 0, 0,
                               0, 0, 0, 0,
                               0, 0, 0, 0);

            return this;
         }
         case 2:
         {
            this .matrix .set (size .x / 2, 0, 0, 0,
                               0, size .y / 2, 0, 0,
                               0, 0, size .z / 2, 0,
                               center .x, center .y, center .z, 1);

            return this;
         }
         // case 3:
         // {
         //    console .trace ()
         //    return this .setExtents (arguments [0], arguments [1]);
         // }
      }
   },
   setExtents (min, max)
   {
      const
         sx = (max .x - min .x) / 2,
         sy = (max .y - min .y) / 2,
         sz = (max .z - min .z) / 2,
         cx = (max .x + min .x) / 2,
         cy = (max .y + min .y) / 2,
         cz = (max .z + min .z) / 2;

      this .matrix .set (sx, 0,  0,  0,
                         0,  sy, 0,  0,
                         0,  0,  sz, 0,
                         cx, cy, cz, 1);

      return this;
   },
   getExtents (min, max)
   {
      this .getAbsoluteExtents (min, max);

      min .add (this .center);
      max .add (this .center);
   },
   getAbsoluteExtents: (() =>
   {
      const
         r1 = new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (),
         p1 = new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (),
         p4 = new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A ();

      return function (min, max)
      {
         const
            m = this .matrix,
            x = m .X_AXIS,
            y = m .Y_AXIS,
            z = m .Z_AXIS;

         r1 .assign (y) .add (z);

         const r2 = z .subtract (y);

         p1 .assign (x) .add (r1),
         p4 .assign (x) .add (r2);

         const
            p2 = r1 .subtract (x),
            p3 = r2 .subtract (x);

         min .assign (p1) .min (p2, p3, p4);
         max .assign (p1) .max (p2, p3, p4);

         p1 .negate ();
         p2 .negate ();
         p3 .negate ();
         p4 .negate ();

         min .min (p1, p2, p3, p4);
         max .max (p1, p2, p3, p4);
      };
   })(),
   getPoints: (() =>
   {
      const
         x  = new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (),
         y  = new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (),
         z  = new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (),
         r1 = new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A ();

      return function (points)
      {
         /*
          * p6 ---------- p5
          * | \           | \
          * | p2------------ p1
          * |  |          |  |
          * |  |          |  |
          * p7 |_________ p8 |
          *  \ |           \ |
          *   \|            \|
          *    p3 ---------- p4
          */

         const m = this .matrix;

         x .assign (m .X_AXIS);
         y .assign (m .Y_AXIS);
         z .assign (m .Z_AXIS);

         r1 .assign (y) .add (z);

         const r2 = z .subtract (y);

         points [0] .assign (x)  .add (r1);
         points [1] .assign (r1) .subtract (x);
         points [2] .assign (r2) .subtract (x);
         points [3] .assign (x)  .add (r2);

         points [4] .assign (points [2]) .negate ();
         points [5] .assign (points [3]) .negate ();
         points [6] .assign (points [0]) .negate ();
         points [7] .assign (points [1]) .negate ();

         const center = this .center;

         points [0] .add (center);
         points [1] .add (center);
         points [2] .add (center);
         points [3] .add (center);

         points [4] .add (center);
         points [5] .add (center);
         points [6] .add (center);
         points [7] .add (center);

         return points;
      };
   })(),
   getAxes (axes)
   {
      const m = this .matrix;

      axes [0] .assign (m .X_AXIS);
      axes [1] .assign (m .Y_AXIS);
      axes [2] .assign (m .Z_AXIS);

      return axes;
   },
   getNormals: (() =>
   {
      const
         x = new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (),
         y = new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (),
         z = new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A ();

      const axes = [ _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .X_AXIS, _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .Y_AXIS, _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .Z_AXIS ];

      return function (normals)
      {
         const m = this .matrix;

         x .assign (m .X_AXIS);
         y .assign (m .Y_AXIS);
         z .assign (m .Z_AXIS);

         if (x .squaredNorm () === 0)
         {
            x .assign (y) .cross (z);

            if (x .squaredNorm () === 0)
            {
               for (const axis of axes)
               {
                  x .assign (axis) .cross (y);

                  if (x .squaredNorm () !== 0)
                     break;
               }

               if (x .squaredNorm () === 0)
               {
                  for (const axis of axes)
                  {
                     x .assign (axis) .cross (z);

                     if (x .squaredNorm () !== 0)
                        break;
                  }

                  if (x .squaredNorm () === 0)
                     x .assign (_Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .X_AXIS);
               }
            }
         }

         if (y .squaredNorm () === 0)
         {
            y .assign (z) .cross (x);

            if (y .squaredNorm () === 0)
            {
               for (const axis of axes)
               {
                  y .assign (axis) .cross (z);

                  if (y .squaredNorm () !== 0)
                     break;
               }

               if (y .squaredNorm () === 0)
               {
                  for (const axis of axes)
                  {
                     y .assign (axis) .cross (x);

                     if (y .squaredNorm () !== 0)
                        break;
                  }

                  if (y .squaredNorm () === 0)
                     y .assign (_Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .Y_AXIS);
               }
            }
         }

         if (z .squaredNorm () === 0)
         {
            z .assign (x) .cross (y);

            if (z .squaredNorm () === 0)
            {
               for (const axis of axes)
               {
                  z .assign (axis) .cross (x);

                  if (z .squaredNorm () !== 0)
                     break;
               }

               if (z .squaredNorm () === 0)
               {
                  for (const axis of axes)
                  {
                     z .assign (axis) .cross (y);

                     if (z .squaredNorm () !== 0)
                        break;
                  }

                  if (z .squaredNorm () === 0)
                     z .assign (_Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .Z_AXIS);
               }
            }
         }

         normals [0] .assign (y) .cross (z) .normalize ();
         normals [1] .assign (z) .cross (x) .normalize ();
         normals [2] .assign (x) .cross (y) .normalize ();

         return normals;
      };
   })(),
   isEmpty ()
   {
      return this .matrix [15] === 0;
   },
   add: (() =>
   {
      const
         lhs_min = new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (),
         lhs_max = new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (),
         rhs_min = new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (),
         rhs_max = new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A ();

      return function (box)
      {
         if (this .isEmpty ())
            return this .assign (box);

         if (box .isEmpty ())
            return this;

         this .getExtents (lhs_min, lhs_max);
         box  .getExtents (rhs_min, rhs_max);

         return this .setExtents (lhs_min .min (rhs_min), lhs_max .max (rhs_max));
      };
   })(),
   multLeft (matrix)
   {
      this .matrix .multLeft (matrix);
      return this;
   },
   multRight (matrix)
   {
      this .matrix .multRight (matrix);
      return this;
   },
   containsPoint: (() =>
   {
      const
         min = new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (),
         max = new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A ();

      return function (point)
      {
         this .getExtents (min, max);

         return min .x <= point .x &&
                max .x >= point .x &&
                min .y <= point .y &&
                max .y >= point .y &&
                min .z <= point .z &&
                max .z >= point .z;
      };
   })(),
   intersectsBox: (() =>
   {
      const
         points1 = Array .from ({ length: 8 }, () => new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A ()),
         points2 = Array .from ({ length: 8 }, () => new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A ()),
         axes1   = Array .from ({ length: 3 }, () => new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A ()),
         axes2   = Array .from ({ length: 3 }, () => new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A ()),
         axes9   = Array .from ({ length: 9 }, () => new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A ()),
         normals = Array .from ({ length: 3 }, () => new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A ());

      return function (other)
      {
         // Test special cases.

         if (this .isEmpty ())
            return false;

         if (other .isEmpty ())
            return false;

         // Get points.

         this  .getPoints (points1);
         other .getPoints (points2);

         // Test the three planes spanned by the normal vectors of the faces of the first parallelepiped.

         if (_Algorithms_SAT_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .isSeparated (this .getNormals (normals), points1, points2))
            return false;

         // Test the three planes spanned by the normal vectors of the faces of the second parallelepiped.

         if (_Algorithms_SAT_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .isSeparated (other .getNormals (normals), points1, points2))
            return false;

         // Test the nine other planes spanned by the edges of each parallelepiped.

         this  .getAxes (axes1);
         other .getAxes (axes2);

         for (let i1 = 0; i1 < 3; ++ i1)
         {
            for (let i2 = 0; i2 < 3; ++ i2)
               axes9 [i1 * 3 + i2] .assign (axes1 [i1]) .cross (axes2 [i2]);
         }

         if (_Algorithms_SAT_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .isSeparated (axes9, points1, points2))
            return false;

         // Both boxes intersect.

         return true;
      };
   })(),
   // import Triangle3 from "./Triangle3.js";
   // intersectsTriangle: (() =>
   // {
   //    const
   //       points1        = Array .from ({ length: 8 }, () => new Vector3 ()),
   //       axes1          = Array .from ({ length: 3 }, () => new Vector3 ()),
   //       axes9          = Array .from ({ length: 9 }, () => new Vector3 ()),
   //       normals        = Array .from ({ length: 3 }, () => new Vector3 ()),
   //       triangle       = [ ],
   //       triangleNormal = [ new Vector3 () ],
   //       triangleEdges  = Array .from ({ length: 3 }, () => new Vector3 ());

   //    return function (a, b, c)
   //    {
   //       // Test special cases.

   //       if (this .isEmpty ())
   //          return false;

   //       // Get points.

   //       this .getPoints (points1);

   //       triangle [0] = a;
   //       triangle [1] = b;
   //       triangle [2] = c;

   //       // Test the three planes spanned by the normal vectors of the faces of the first parallelepiped.

   //       if (SAT .isSeparated (this .getNormals (normals), points1, triangle))
   //          return false;

   //       // Test the normal of the triangle.

   //       Triangle3 .normal (a, b, c, triangleNormal [0]);

   //       if (SAT .isSeparated (triangleNormal, points1, triangle))
   //          return false;

   //       // Test the nine other planes spanned by the edges of each parallelepiped.

   //       this .getAxes (axes1);

   //       triangleEdges [0] .assign (a) .subtract (b);
   //       triangleEdges [1] .assign (b) .subtract (c);
   //       triangleEdges [2] .assign (c) .subtract (a);

   //       for (let i1 = 0; i1 < 3; ++ i1)
   //       {
   //          for (let i2 = 0; i2 < 3; ++ i2)
   //             axes9 [i1 * 3 + i2] .assign (axes1 [i1]) .cross (triangleEdges [i2]);
   //       }

   //       if (SAT .isSeparated (axes9, points1, triangle))
   //          return false;

   //       // Box and triangle intersect.

   //       return true;
   //    };
   // })(),
   toString ()
   {
      return `${this .size}, ${this .center}`;
   },
});

Object .assign (Box3,
{
   Extents (min, max)
   {
      return new Box3 () .setExtents (min, max);
   },
   Points (points)
   {
      const
         min = new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (Number .POSITIVE_INFINITY),
         max = new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (Number .NEGATIVE_INFINITY);

      for (const point of points)
      {
         min .min (point);
         max .max (point);
      }

      return new Box3 () .setExtents (min, max);
   },
});

Object .defineProperties (Box3 .prototype,
{
   size:
   {
      get: (() =>
      {
         const
            min = new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (),
            max = new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A ();

         return function ()
         {
            this .getAbsoluteExtents (min, max);

            return max .subtract (min);
         };
      })(),
      enumerable: true,
   },
   center:
   {
      get ()
      {
         return this .matrix .origin;
      },
      enumerable: true,
   },
});

const __default__ = Box3;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_x_ite_Namespace_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .add ("Box3", __default__));

/***/ }),

/***/ 2921:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Fields_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(4598);
/* harmony import */ var _Components_Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(2340);
/* harmony import */ var _Execution_X3DImportedNode_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(3288);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(717);




class Placeholder extends _Components_Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A
{
   #parser;
   #lastIndex;
   #lineNumber;
   #name;
   #namedNodes;
   #importedNodes;
   #type;
   #typeName;

   constructor (parser, name, type = _Components_Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A, typeName)
   {
      super (parser .getExecutionContext ());

      this .#parser        = parser;
      this .#lastIndex     = parser .lastIndex,
      this .#lineNumber    = parser .lineNumber;
      this .#namedNodes    = parser .getNamedNodes ();
      this .#importedNodes = parser .getImportedNodes ();

      this .#name     = name;
      this .#type     = type;
      this .#typeName = typeName;
   }

   getComponentInfo ()
   {
      return this .#type .componentInfo;
   }

   getContainerField ()
   {
      return this .#type .containerField;
   }

   getSpecificationRange ()
   {
      return this .#type .specificationRange;
   }

   replaceWithNode ()
   {
      const
         name      = this .#name,
         localNode = this .#namedNodes .get (name) ?? this .#importedNodes .get (name);

      const node = localNode instanceof _Execution_X3DImportedNode_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A
         ? localNode .getExportedNode (this .#type)
         : localNode;

      if (!node)
      {
         this .#parser .lastIndex  = this .#lastIndex;
         this .#parser .lineNumber = this .#lineNumber;

         throw new Error (`Named node '${name}' not found.`);
      }

      this .#parser .checkNodeType (node, this .#name, this .#type, this .#typeName);

      for (const parent of Array .from (this .getParents ()))
      {
         if (!(parent instanceof _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFNode))
            continue;

         parent .setValue (node);
      }
   }
}

const __default__ = Placeholder;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .add ("Placeholder", __default__));

/***/ }),

/***/ 2927:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(717);
let i = 0;

const TraverseType = Object .freeze ({
   BBOX:      i ++,
   POINTER:   i ++,
   CAMERA:    i ++,
   PICKING:   i ++,
   COLLISION: i ++,
   SHADOW:    i ++,
   DISPLAY:   i ++,
});

const __default__ = TraverseType;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .add ("TraverseType", __default__));

/***/ }),

/***/ 2961:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _x_ite_Namespace_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(717);
class MatrixStack extends Array
{
   #top = 0;

   constructor (Type)
   {
      super ();

      this .push (new Type ());
   }

   set (matrix)
   {
      this [this .#top] .assign (matrix);
   }

   get ()
   {
      return this [this .#top];
   }

   push (matrix = this [this .#top])
   {
      const top = ++ this .#top;

      if (top < this .length)
         this [top] .assign (matrix);
      else
         this [top] = matrix .copy ();
   }

   pop ()
   {
      -- this .#top;
   }

   clear ()
   {
      this .#top = 0;
   }

   size ()
   {
      return this .#top + 1;
   }

   identity ()
   {
      this [this .#top] .identity ();
   }

   inverse ()
   {
      this [this .#top] .inverse ();
   }

   multRight (matrix)
   {
      this [this .#top] .multRight (matrix);
   }

   multLeft (matrix)
   {
      this [this .#top] .multLeft (matrix);
   }

   translate (vector)
   {
      this [this .#top] .translate (vector);
   }

   rotate (rotation)
   {
      this [this .#top] .rotate (rotation);
   }

   scale (vector)
   {
      this [this .#top] .scale (vector);
   }
}

const __default__ = MatrixStack;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_x_ite_Namespace_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .add ("MatrixStack", __default__));

/***/ }),

/***/ 3020:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _X3DChildObject_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(4072);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(717);


const
   _array     = Symbol (),
   _index     = Symbol (),
   _valueType = Symbol ();

const handler =
{
   get (target, key)
   {
      const value = target [key];

      if (value !== undefined)
         return value;

      if (typeof key === "string")
      {
         const index = +key;

         if (Number .isInteger (index))
            return target [_array] [index];

         return;
      }
   },
   set (target, key, value)
   {
      if (target [key] === undefined)
         return false;

      target [key] = value;
      return true;
   },
   has (target, key)
   {
      if (Number .isInteger (+key))
         return key < target [_array] .length;

      return key in target;
   },
   ownKeys (target)
   {
      return Object .keys (target [_array]);
   },
   getOwnPropertyDescriptor (target, key)
   {
      if (typeof key !== "string")
         return;

      const index = +key;

      if (Number .isInteger (index) && index < target [_array] .length)
      {
         const propertyDescriptor = Object .getOwnPropertyDescriptor (target [_array], key);

         if (propertyDescriptor)
            propertyDescriptor .writable = false;

         return propertyDescriptor;
      }
   },
};

function X3DInfoArray (values, valueType)
{
   const proxy = new Proxy (this, handler);

   _X3DChildObject_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .call (this);

   this [_array]     = [ ];
   this [_index]     = new Map ();
   this [_valueType] = valueType;

   for (const [key, value] of values)
      this .add (key, value);

   return proxy;
}

Object .assign (Object .setPrototypeOf (X3DInfoArray .prototype, _X3DChildObject_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .prototype),
{
   *[Symbol .iterator] ()
   {
      yield* this [_array];
   },
   copy ()
   {
      const copy = new (this .constructor) ();

      copy .assign (this);

      return copy;
   },
   clear ()
   {
      this [_array] .length = 0;
      this [_index] .clear ();

      this .addEvent ();
   },
   assign (array)
   {
      if (!(array instanceof this .constructor))
         throw new Error ("Couldn't assign info array, wrong type.");

      this [_array] = Array .from (array [_array]);
      this [_index] = new Map (array [_index]);

      this .addEvent ();
   },
   equals (array)
   {
      const
         a      = this [_array],
         b      = array [_array],
         length = a .length;

      if (a === b)
         return true;

      if (length !== b .length)
         return false;

      for (let i = 0; i < length; ++ i)
      {
         if (a [i] !== b [i])
            return false;
      }

      return true;
   },
   has (key)
   {
      return this [_index] .has (key);
   },
   get (key)
   {
      return this [_index] .get (key);
   },
   add (key, value)
   {
      if (this [_index] .has (key))
         throw new Error (`Couldn't add value to ${this .getTypeName ()}, key '${key}' already exists.`);

      if (!(value instanceof this [_valueType]))
         throw new Error (`Couldn't add value to ${this .getTypeName ()}, value for key '${key}' has wrong type.`);

      this [_array] .push (value);
      this [_index] .set (key, value);

      this .addEvent ();
   },
   alias (alias, value)
   {
      this [_index] .set (alias, value);

      this .addEvent ();
   },
   update (oldKey, newKey, value)
   {
      // TODO: update alias.

      if (!(value instanceof this [_valueType]))
         throw new Error (`Couldn't update value of ${this .getTypeName ()}, value for key '${key}' has wrong type.`);

      const oldValue = this [_index] .get (oldKey);

      if (oldKey !== newKey)
         this .remove (newKey);

      this [_index] .delete (oldKey);
      this [_index] .set (newKey, value);

      if (oldValue !== undefined)
      {
         const index = this [_array] .indexOf (oldValue);

         if (index > -1)
            this [_array] [index] = value;
      }
      else
      {
         this [_array] .push (value);
      }

      this .addEvent ();
   },
   remove (key)
   {
      // TODO: remove alias.

      const value = this [_index] .get (key);

      if (value === undefined)
         return;

      const index = this [_array] .indexOf (value);

      this [_index] .delete (key);

      if (index > -1)
         this [_array] .splice (index, 1);

      this .addEvent ();
   },
   at: Array .prototype .at,
   // concat: Array .prototype .concat,
   // copyWithin: Array.prototype.copyWithin,
   entries: Array .prototype .entries,
   every: Array .prototype .every,
   // fill: Array .prototype .fill,
   filter (callbackFn, thisArg)
   {
      return new (this .constructor) (Array .prototype .filter .call (this, callbackFn, thisArg));
   },
   find: Array .prototype .find,
   findIndex: Array .prototype .findIndex,
   findLast: Array .prototype .findLast,
   findLastIndex: Array .prototype .findLastIndex,
   flat: Array .prototype .flat,
   flatMap: Array .prototype .flatMap,
   forEach: Array .prototype .forEach,
   includes: Array .prototype .includes,
   indexOf: Array .prototype .indexOf,
   join: Array .prototype .join,
   keys: Array .prototype .keys,
   lastIndexOf: Array .prototype .lastIndexOf,
   map (callbackFn, thisArg)
   {
      return new (this .constructor) (Array .prototype .map .call (this, callbackFn, thisArg));
   },
   reduce: Array .prototype .reduce,
   reduceRight: Array .prototype .reduceRight,
   // reverse: Array .prototype .reverse,
   slice (start, end)
   {
      return new (this .constructor) (Array .prototype .slice .call (this, start, end));
   },
   some: Array .prototype .some,
   // sort: Array .prototype .sort,
   toReversed ()
   {
      return new (this .constructor) ([... this] .reverse ());
   },
   toSorted (compareFn)
   {
      return new (this .constructor) ([... this] .sort (compareFn));
   },
   toSpliced (start, deleteCount, ... insertValues)
   {
      const array = [... this];

      array .splice (start, deleteCount, ... insertValues)

      return new (this .constructor) (array);
   },
   values: Array .prototype .values,
   with (index, value)
   {
      const array = [... this];

      array [index] = value;

      return new (this .constructor) (array);
   },
   toVRMLStream (generator)
   {
      for (const value of this [_array])
      {
         try
         {
            value .toVRMLStream (generator);

            generator .string += generator .Break ();

            if (this .getTypeName () .match (/Proto/))
               generator .string += generator .TidyBreak ();
         }
         catch (error)
         {
            // console .error (error);
         }
      }
   },
   toXMLStream (generator)
   {
      for (const value of this [_array])
      {
         try
         {
            value .toXMLStream (generator);

            generator .string += generator .TidyBreak ();
         }
         catch (error)
         {
            // console .error (error);
         }
      }
   },
   toJSONStream (generator, comma = false)
   {
      for (const value of this [_array])
      {
         try
         {
            if (comma)
               generator .string += ',';

            value .toJSONStream (generator, true);

            comma = true;
         }
         catch
         {
            generator .RemoveComma ();
         }
      }

      return comma;
   },
});

for (const key of Object .keys (X3DInfoArray .prototype))
   Object .defineProperty (X3DInfoArray .prototype, key, { enumerable: false });

Object .defineProperties (X3DInfoArray .prototype,
{
   length:
   {
      get () { return this [_array] .length; },
   },
});

const __default__ = X3DInfoArray;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .add ("X3DInfoArray", __default__));

/***/ }),

/***/ 3074:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Base_X3DChildObject_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(4072);
/* harmony import */ var _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(2212);
/* harmony import */ var _X3DNode_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(2340);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(717);
/* provided dependency */ var $ = __webpack_require__(9547);




const
   _importedName = Symbol (),
   _importedNode = Symbol (),
   _type         = Symbol ();

const handler =
{
   get (target, key)
   {
      if (key in target)
         return target [key];

      const
         node     = target .getSharedNode (),
         property = node ?.[key];

      if (typeof property === "function")
         return property .bind (node);

      return property;
   },
   set (target, key, value)
   {
      if (key in target)
      {
         target [key] = value;
      }
      else
      {
         const node = target .getSharedNode ();

         if (node)
            node [key] = value;
      }

      return true;
   },
   has (target, key)
   {
      return key in (target .getSharedNode () ?? { });
   },
   ownKeys (target)
   {
      return Object .keys (target .getSharedNode () ?? { });
   },
   getOwnPropertyDescriptor (target, key)
   {
      return Object .getOwnPropertyDescriptor (target .getSharedNode () ?? { }, key);
   },
}

function X3DImportedNodeProxy (executionContext, importedName, type = _X3DNode_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A)
{
   _X3DNode_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .call (this, executionContext);

   const proxy = new Proxy (this, handler);

   this [_importedName] = importedName;
   this [_type]         = type;

   this .setup ();

   return proxy;
}

Object .assign (Object .setPrototypeOf (X3DImportedNodeProxy .prototype, _X3DNode_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .prototype),
{
   initialize ()
   {
      _X3DNode_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .prototype .initialize .call (this);

      this .getExecutionContext () .importedNodes .addInterest ("update", this);

      this .update ();
   },
   getExtendedEventHandling ()
   {
      return false;
   },
   getSharedNode ()
   {
      return $.try (() => this [_importedNode] .getSharedNode ()) ?? null;
   },
   getImportedNode ()
   {
      return this [_importedNode];
   },
   getInnerNode ()
   {
      return this [_importedNode] .getSharedNode () .getInnerNode ();
   },
   getName ()
   {
      return this [_importedName];
   },
   setName (value)
   {
      this [_importedName] = value;

      this ._name_changed = Date .now () / 1000;
   },
   ... Object .fromEntries ([
      ["getComponentInfo",      "componentInfo"],
      ["getContainerField",     "containerField"],
      ["getSpecificationRange", "specificationRange"],
      ["getTypeName",           "typeName"],
   ]
   .map (([fn, property]) => [fn, function ()
   {
      return this .getSharedNode () ?.[fn] () ?? this [_type] [property];
   }])),
   ... Object .fromEntries ([
      "getType",
      "getFieldDefinitions",
      "getPredefinedField",
      "getPredefinedFields",
      "getUserDefinedField",
      "getUserDefinedFields",
      "getField",
      "getFields",
      "getChangedFields",
      "isDefaultValue",
      "hasRoutes",
   ]
   .map (fn => [fn, function (... args)
   {
      return this .getSharedNode () ?.[fn] (... args) ?? _X3DNode_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .prototype [fn] .call (this, ... args);
   }])),
   update ()
   {
      const importedNode = this .getExecutionContext () .getImportedNodes () .get (this [_importedName])
         ?? null;

      this [_importedNode] ?.getInlineNode () ._loadState .removeInterest ("set_loadState__", this);

      this [_importedNode] = importedNode;

      this [_importedNode] ?.getInlineNode () ._loadState .addInterest ("set_loadState__", this);

      this .set_loadState__ ();
   },
   set_loadState__ ()
   {
      if (this [_importedNode] ?.getInlineNode () .checkLoadState () === _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .COMPLETE_STATE)
         this [_type] = this .getSharedNode () ?.constructor ?? this [_type];

      this ._typeName_changed = Date .now () / 1000;

      _Base_X3DChildObject_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .prototype .addEvent .call (this);
   },
   toVRMLStream (generator)
   {
      if (this [_importedNode])
      {
         const importedName = generator .ImportedName (this [_importedNode]);

         generator .string += "USE";
         generator .string += generator .Space ();
         generator .string += importedName;
      }
      else
      {
         generator .string += "NULL";
      }
   },
   toXMLStream (generator)
   {
      if (this [_importedNode])
      {
         const importedName = generator .ImportedName (this [_importedNode]);

         generator .openTag (this .getTypeName ());

         if (generator .html && this .getTypeName () === "Script")
            generator .attribute ("type", "model/x3d+xml");

         generator .attribute ("USE", importedName);

         const containerField = generator .ContainerField ();

         if (containerField)
         {
            if (containerField .getName () !== this .getContainerField ())
               generator .attribute ("containerField", containerField .getName ());
         }

         generator .closeTag (this .getTypeName ());
      }
      else
      {
         generator .openTag ("NULL");

         const containerField = generator .ContainerField ();

         if (containerField)
            generator .attribute ("containerField", containerField .getName ());

         generator .closeTag ("NULL");
      }
   },
   toJSONStream (generator)
   {
      if (this [_importedNode])
      {
         const importedName = generator .ImportedName (this [_importedNode]);

         generator .beginObject (this .getTypeName (), false, true);
         generator .stringProperty ("@USE", importedName, false);
         generator .endObject ();
         generator .endObject ();
      }
      else
      {
         generator .string += 'null';
      }
   },
});

Object .defineProperties (X3DImportedNodeProxy .prototype,
{
   constructor:
   {
      get ()
      {
         return this [_type] ?? X3DImportedNodeProxy;
      },
   }
});

Object .defineProperties (X3DImportedNodeProxy, _X3DNode_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .getStaticProperties ("X3DImportedNodeProxy", "Core", 2, "children", "4.1"));

const __default__ = X3DImportedNodeProxy;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .add ("X3DImportedNodeProxy", __default__));

/***/ }),

/***/ 3288:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Base_X3DObject_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(946);
/* harmony import */ var _Fields_SFNodeCache_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(6015);
/* harmony import */ var _Components_Core_X3DImportedNodeProxy_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(3074);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(717);




const
   _executionContext = Symbol (),
   _inlineNode       = Symbol (),
   _exportedName     = Symbol (),
   _importedName     = Symbol (),
   _exportedNodes    = Symbol ();

function X3DImportedNode (executionContext, inlineNode, exportedName, importedName)
{
   _Base_X3DObject_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .call (this);

   this [_executionContext] = executionContext;
   this [_inlineNode]       = inlineNode;
   this [_exportedName]     = exportedName;
   this [_importedName]     = importedName;
   this [_exportedNodes]    = executionContext [_exportedNodes] ??= new Map ();
}

Object .assign (Object .setPrototypeOf (X3DImportedNode .prototype, _Base_X3DObject_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .prototype),
{
   getExecutionContext ()
   {
      return this [_executionContext];
   },
   getInlineNode ()
   {
      return this [_inlineNode];
   },
   getExportedName ()
   {
      return this [_exportedName];
   },
   getExportedNode (type)
   {
      return this [_exportedNodes] .get (this [_importedName])
         ?? this .createExportedNode (type);
   },
   createExportedNode (type)
   {
      const exportedNode = new _Components_Core_X3DImportedNodeProxy_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A (this .getExecutionContext (), this [_importedName], type);

      this [_exportedNodes] .set (this [_importedName], exportedNode);

      return exportedNode;
   },
   getSharedNode ()
   {
      const exportedNode = this .getInlineNode () .getInternalScene () .getExportedNodes () .get (this [_exportedName]);

      if (exportedNode)
         return exportedNode .getLocalNode ();

      throw new Error (`Exported node '${this [_exportedName]}' not found.`);
   },
   getImportedName ()
   {
      return this [_importedName];
   },
   [Symbol .for ("X_ITE.X3DImportedNode.setImportName")] (importedName)
   {
      const
         exportedNode  = this .getExportedNode (),
         exportedNodes = this [_exportedNodes];

      exportedNodes .delete (this [_importedName]);
      exportedNodes .set (importedName, exportedNode);

      this [_importedName] = importedName;

      exportedNode .setName (importedName);
   },
   toVRMLStream (generator)
   {
      if (!generator .ExistsNode (this .getInlineNode ()))
         throw new Error ("X3DImportedNode.toVRMLStream: Inline node does not exist.");

      generator .AddRouteNode (this);

      const importedName = generator .ImportedName (this);

      generator .string += generator .Indent ();
      generator .string += "IMPORT";
      generator .string += generator .Space ();
      generator .string += generator .Name (this .getInlineNode ());
      generator .string += ".";
      generator .string += this .getExportedName ();

      if (importedName !== this .getExportedName ())
      {
         generator .string += generator .Space ();
         generator .string += "AS";
         generator .string += generator .Space ();
         generator .string += importedName;
      }
   },
   toXMLStream (generator)
   {
      if (!generator .ExistsNode (this .getInlineNode ()))
         throw new Error ("X3DImportedNode.toXMLStream: Inline node does not exist.");

      generator .AddRouteNode (this);

      const importedName = generator .ImportedName (this);

      generator .openTag ("IMPORT");
      generator .attribute ("inlineDEF",   generator .Name (this .getInlineNode ()));
      generator .attribute ("importedDEF", this .getExportedName ());

      if (importedName !== this .getExportedName ())
         generator .attribute ("AS", importedName);

      generator .closeTag ("IMPORT");
   },
   toJSONStream (generator)
   {
      if (!generator .ExistsNode (this .getInlineNode ()))
         throw new Error ("X3DImportedNode.toJSONStream: Inline node does not exist.");

      generator .string += generator .TidyBreak ();
      generator .string += generator .Indent ();

      generator .AddRouteNode (this);
      generator .beginObject ("IMPORT", false, true);
      generator .stringProperty ("@inlineDEF",   generator .Name (this .getInlineNode ()), false);
      generator .stringProperty ("@importedDEF", this .getExportedName ());

      const importedName = generator .ImportedName (this);

      if (importedName !== this .getExportedName ())
         generator .stringProperty ("@AS", importedName);

      generator .endObject ();
      generator .endObject ();
   },
   dispose ()
   {
      for (const route of Array .from (this [_executionContext] .getRoutes ()))
      {
         if (route .getSourceNode () === this)
         {
            this [_executionContext] .deleteRoute (route);
            continue;
         }

         if (route .getDestinationNode () === this)
         {
            this [_executionContext] .deleteRoute (route);
            continue;
         }
      }

      _Base_X3DObject_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .prototype .dispose .call (this);
   },
});

for (const key of Object .keys (X3DImportedNode .prototype))
   Object .defineProperty (X3DImportedNode .prototype, key, { enumerable: false });

Object .defineProperties (X3DImportedNode .prototype,
{
   inlineNode:
   {
      get ()
      {
         return _Fields_SFNodeCache_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .get (this [_inlineNode]);
      },
      enumerable: true,
   },
   exportedName:
   {
      get ()
      {
         return this [_exportedName];
      },
      enumerable: true,
   },
   exportedNode:
   {
      get ()
      {
         return _Fields_SFNodeCache_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .get (this .getExportedNode ());
      },
      enumerable: true,
   },
   importedName:
   {
      get ()
      {
         return this [_importedName];
      },
      enumerable: true,
   },
});

Object .defineProperties (X3DImportedNode,
{
   typeName:
   {
      value: "X3DImportedNode",
      enumerable: true,
   },
});

const __default__ = X3DImportedNode;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .add ("X3DImportedNode", __default__));

/***/ }),

/***/ 3314:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Fields_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(4598);
/* harmony import */ var _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(2040);
/* harmony import */ var _Base_FieldDefinitionArray_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(1870);
/* harmony import */ var _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(2340);
/* harmony import */ var _X3DLayerNode_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(9436);
/* harmony import */ var _Navigation_Viewpoint_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(9419);
/* harmony import */ var _Grouping_Group_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(362);
/* harmony import */ var _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(2212);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(717);









function Layer (executionContext)
{
   _X3DLayerNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .call (this,
                       executionContext,
                       new _Navigation_Viewpoint_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A (executionContext),
                       new _Grouping_Group_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A (executionContext));

   this .addType (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .Layer);
}

Object .assign (Object .setPrototypeOf (Layer .prototype, _X3DLayerNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .prototype),
{
   initialize ()
   {
      _X3DLayerNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .prototype .initialize .call (this);

      const groupNode = this .getGroups () ._children [0] .getValue ();

      this ._addChildren    .addFieldInterest (groupNode ._addChildren);
      this ._removeChildren .addFieldInterest (groupNode ._removeChildren);
      this ._children       .addFieldInterest (groupNode ._children);

      groupNode ._children = this ._children;

      groupNode .setPrivate (true);
      groupNode .setup ();

      this .getGroups () .setup ();
   },
});

Object .defineProperties (Layer,
{
   ... _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .getStaticProperties ("Layer", "Layering", 1, "layers", "3.2"),
   fieldDefinitions:
   {
      value: new _Base_FieldDefinitionArray_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A ([
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .inputOutput, "metadata",       new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFNode ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .inputOutput, "pickable",       new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFBool (true)),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .inputOutput, "objectType",     new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFString ("ALL")),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .inputOutput, "pointerEvents",  new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFBool (true)), // skip test
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .inputOutput, "visible",        new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFBool (true)),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .inputOutput, "viewport",       new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFNode ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .inputOnly,   "addChildren",    new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFNode ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .inputOnly,   "removeChildren", new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFNode ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .inputOutput, "children",       new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFNode ()),
      ]),
      enumerable: true,
   },
});

const __default__ = Layer;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_8__/* ["default"] */ .A .add ("Layer", __default__));

/***/ }),

/***/ 3454:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Fields_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(4598);
/* harmony import */ var _Base_X3DBaseNode_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(3643);
/* harmony import */ var _Components_Core_X3DPrototypeInstance_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(6807);
/* harmony import */ var _Fields_SFNodeCache_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(6015);
/* harmony import */ var _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(2212);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(717);






const
   _appInfo       = Symbol (),
   _documentation = Symbol ();

function X3DProtoDeclarationNode (executionContext)
{
   _Base_X3DBaseNode_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .call (this, executionContext);

   this .addType (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .X3DProtoDeclarationNode);

   this .addChildObjects (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .outputOnly, "updateInstances", new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFTime ());

   // Private properties

   this [_appInfo]       = "";
   this [_documentation] = "";
}

Object .assign (Object .setPrototypeOf (X3DProtoDeclarationNode .prototype, _Base_X3DBaseNode_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .prototype),
{
   canUserDefinedFields ()
   {
      return true;
   },
   getAppInfo ()
   {
      return this [_appInfo];
   },
   setAppInfo (value)
   {
      this [_appInfo] = String (value);
   },
   setDocumentation (value)
   {
      this [_documentation] = String (value);
   },
   getDocumentation ()
   {
      return this [_documentation];
   },
   createInstance (executionContext, setup = true /* non-public argument */)
   {
      if (setup === false)
      {
         return new _Components_Core_X3DPrototypeInstance_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A (executionContext, this);
      }
      else
      {
         const instance = new _Components_Core_X3DPrototypeInstance_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A (executionContext, this);

         instance .setup ();

         return _Fields_SFNodeCache_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .get (instance);
      }
   },
   newInstance ()
   {
      return this .createInstance (this .getExecutionContext ());
   },
   requestUpdateInstances ()
   {
      this ._updateInstances = Date .now () / 1000;
   },
   updateInstances ()
   {
      this ._updateInstances .processEvent ();
   },
});

for (const key of Object .keys (X3DProtoDeclarationNode .prototype))
   Object .defineProperty (X3DProtoDeclarationNode .prototype, key, { enumerable: false });

Object .defineProperties (X3DProtoDeclarationNode .prototype,
{
   name:
   {
      get: X3DProtoDeclarationNode .prototype .getName,
      enumerable: true,
   },
   fields:
   {
      get: X3DProtoDeclarationNode .prototype .getFieldDefinitions,
      enumerable: true,
   },
   appInfo:
   {
      get: X3DProtoDeclarationNode .prototype .getAppInfo,
      enumerable: true,
   },
   documentation:
   {
      get: X3DProtoDeclarationNode .prototype .getDocumentation,
      enumerable: true,
   },
});

Object .defineProperties (X3DProtoDeclarationNode,
{
   typeName:
   {
      value: "X3DProtoDeclarationNode",
      enumerable: true,
   },
});

_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .addConstant (X3DProtoDeclarationNode .typeName);

const __default__ = X3DProtoDeclarationNode;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .add ("X3DProtoDeclarationNode", __default__));

/***/ }),

/***/ 3500:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(717);
let i = 0;

const AlphaMode =
{
   AUTO:   i ++, // Must be zero!
   OPAQUE: i ++,
   MASK:   i ++,
   BLEND:  i ++,
};

const __default__ = Object .assign (new Map (Object .entries (AlphaMode)), AlphaMode);
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .add ("AlphaMode", __default__));

/***/ }),

/***/ 3527:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Color3_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(2262);
/* harmony import */ var _x_ite_Namespace_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(717);


const
   _r = Symbol .for ("X_ITE.Color3.r"),
   _g = Symbol .for ("X_ITE.Color3.g"),
   _b = Symbol .for ("X_ITE.Color3.b"),
   _a = Symbol ();

// glTF sometimes allows color values greater than 1.
// See: https://github.com/KhronosGroup/glTF/blob/main/extensions/2.0/Khronos/KHR_materials_specular/README.md
// See: https://raw.githubusercontent.com/KhronosGroup/glTF-Sample-Assets/master/Models/SpecularTest/glTF/SpecularTest.gltf

function Color4 (r = 0, g = r, b = g, a = b)
{
   this [_r] = r;
   this [_g] = g;
   this [_b] = b;
   this [_a] = a;
}

Object .assign (Color4 .prototype,
{
   *[Symbol .iterator] ()
   {
      yield this [_r];
      yield this [_g];
      yield this [_b];
      yield this [_a];
   },
   copy ()
   {
      const copy = Object .create (Color4 .prototype);
      copy [_r] = this [_r];
      copy [_g] = this [_g];
      copy [_b] = this [_b];
      copy [_a] = this [_a];
      return copy;
   },
   assign (color)
   {
      this [_r] = color [_r];
      this [_g] = color [_g];
      this [_b] = color [_b];
      this [_a] = color [_a];
      return this;
   },
   set (r = 0, g = r, b = g, a = b)
   {
      this [_r] = r;
      this [_g] = g;
      this [_b] = b;
      this [_a] = a;
      return this;
   },
   equals (color)
   {
      return this [_r] === color [_r] &&
             this [_g] === color [_g] &&
             this [_b] === color [_b] &&
             this [_a] === color [_a];
   },
   getHSVA (result)
   {
      _Color3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .prototype .getHSV .call (this, result);

      result [3] = this [_a];

      return result;
   },
   setHSVA (h, s, v, a)
   {
      _Color3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .prototype .setHSV .call (this, h, s, v);

      this [_a] = a;

      return this;
   },
   linearToSRGB (color = new Color4 ())
   {
      _Color3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .prototype .linearToSRGB .call (this, color);

      color [_a] = this [_a];

      return color;
   },
   sRGBToLinear (color = new Color4 ())
   {
      _Color3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .prototype .sRGBToLinear .call (this, color);

      color [_a] = this [_a];

      return color;
   },
   toString ()
   {
      return this [_r] + " " +
             this [_g] + " " +
             this [_b] + " " +
             this [_a];
   },
});

for (const key of Object .keys (Color4 .prototype))
   Object .defineProperty (Color4 .prototype, key, { enumerable: false });

const r = {
   get () { return this [_r]; },
   set (value) { this [_r] = value; },
};

const g = {
   get () { return this [_g]; },
   set (value) { this [_g] = value; },
};

const b = {
   get () { return this [_b]; },
   set (value) { this [_b] = value; },
};

const a = {
   get () { return this [_a]; },
   set (value) { this [_a] = value; },
};

Object .defineProperties (Color4 .prototype,
{
   length: { value: 4 },
   0: r,
   1: g,
   2: b,
   3: a,
   r: Object .assign ({ enumerable: true }, r),
   g: Object .assign ({ enumerable: true }, g),
   b: Object .assign ({ enumerable: true }, b),
   a: Object .assign ({ enumerable: true }, a),
});

Object .assign (Color4,
{
   TRANSPARENT: Object .freeze (new Color4 ()),
   BLACK: Object .freeze (new Color4 (0, 0, 0, 1)),
   WHITE: Object .freeze (new Color4 (1)),
   HSVA (h, s, v, a)
   {
      const color = Object .create (this .prototype);
      color .setHSVA (h, s, v, a);
      return color;
   },
   lerp (a, b, t, r)
   {
      // Linearely interpolate in HSVA space between source color @a a and destination color @a b by an amount of @a t.
      // Source and destination color must be in HSVA space. The resulting HSVA color is stored in @a r.
      const aa = a [3];
      _Color3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .lerp (a, b, t, r);
      r [3] = aa + t * (b [3] - aa);
      return r;
   },
});

const __default__ = Color4;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_x_ite_Namespace_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .add ("Color4", __default__));

/***/ }),

/***/ 3643:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  A: () => (/* binding */ Base_X3DBaseNode)
});

// EXTERNAL MODULE: ./src/x_ite/Base/X3DChildObject.js
var X3DChildObject = __webpack_require__(4072);
// EXTERNAL MODULE: ./src/x_ite/Base/Events.js
var Events = __webpack_require__(5625);
// EXTERNAL MODULE: ./src/x_ite/Base/X3DFieldDefinition.js
var X3DFieldDefinition = __webpack_require__(2040);
// EXTERNAL MODULE: ./src/x_ite/Base/FieldDefinitionArray.js
var FieldDefinitionArray = __webpack_require__(1870);
// EXTERNAL MODULE: ./src/x_ite/Base/X3DInfoArray.js
var X3DInfoArray = __webpack_require__(3020);
// EXTERNAL MODULE: ./src/x_ite/Base/X3DField.js
var X3DField = __webpack_require__(2269);
// EXTERNAL MODULE: ./src/x_ite/Namespace.js
var Namespace = __webpack_require__(717);
;// ./src/x_ite/Base/FieldArray.js



function FieldArray (values = [ ])
{
   return X3DInfoArray/* default */.A .call (this, Array .from (values, value => [value .getName (), value]), X3DField/* default */.A);
}

Object .setPrototypeOf (FieldArray .prototype, X3DInfoArray/* default */.A .prototype);

for (const key of Object .keys (FieldArray .prototype))
   Object .defineProperty (FieldArray .prototype, key, { enumerable: false });

Object .defineProperties (FieldArray,
{
   typeName:
   {
      value: "FieldArray",
      enumerable: true,
   },
});

const __default__ = FieldArray;
;

/* harmony default export */ const Base_FieldArray = (Namespace/* default */.A .add ("FieldArray", __default__));
// EXTERNAL MODULE: ./src/x_ite/Fields.js + 15 modules
var Fields = __webpack_require__(4598);
// EXTERNAL MODULE: ./src/x_ite/Base/X3DConstants.js
var X3DConstants = __webpack_require__(2212);
// EXTERNAL MODULE: ./src/x_ite/Parser/HTMLSupport.js
var HTMLSupport = __webpack_require__(1376);
;// ./src/x_ite/Base/X3DBaseNode.js









const
   _browser           = Symbol (),
   _executionContext  = Symbol (),
   _type              = Symbol (),
   _fieldDefinitions  = Symbol .for ("X_ITE.X3DBaseNode.fieldDefinitions"),
   _predefinedFields  = Symbol (),
   _userDefinedFields = Symbol (),
   _childObjects      = Symbol (),
   _initialized       = Symbol (),
   _live              = Symbol (),
   _set_live__        = Symbol .for ("X_ITE.X3DBaseNode.set_live__");

function X3DBaseNode (executionContext, browser = executionContext .getBrowser ())
{
   if (this [_executionContext])
      return;

   X3DChildObject/* default */.A .call (this);

   this [_browser]           = browser;
   this [_executionContext]  = executionContext;
   this [_type]              = [ ];
   this [_fieldDefinitions]  = this .constructor .fieldDefinitions ?? this [_fieldDefinitions];
   this [_predefinedFields]  = new Base_FieldArray ();
   this [_userDefinedFields] = new Base_FieldArray ();
   this [_childObjects]      = [ ];
   this [_live]              = true;
   this [_initialized]       = false;

   // Create fields.

   if (this .canUserDefinedFields ())
      this [_fieldDefinitions] = new FieldDefinitionArray/* default */.A (this [_fieldDefinitions]);

   for (const fieldDefinition of this [_fieldDefinitions])
      this .addPredefinedField (fieldDefinition);

   // Create events.

   this .addChildObjects (X3DConstants/* default */.A .outputOnly, "name_changed",     new Fields/* default */.A .SFTime (),
                          X3DConstants/* default */.A .outputOnly, "typeName_changed", new Fields/* default */.A .SFTime (),
                          X3DConstants/* default */.A .outputOnly, "parents_changed",  new Fields/* default */.A .SFTime ());
}

Object .assign (Object .setPrototypeOf (X3DBaseNode .prototype, X3DChildObject/* default */.A .prototype),
{
   [_fieldDefinitions]: new FieldDefinitionArray/* default */.A ([ ]),
   setName (value)
   {
      X3DChildObject/* default */.A .prototype .setName .call (this, value)

      this ._name_changed = Date .now () / 1000;
   },
   getBrowser ()
   {
      return this [_browser];
   },
   getScene ()
   {
      return this [_executionContext] ?.getLocalScene () ?? null;
   },
   getExecutionContext ()
   {
      return this [_executionContext];
   },
   setExecutionContext (executionContext)
   {
      if (!this [_type] .includes (X3DConstants/* default */.A .X3DScene))
         throw new Error (`${this .getTypeName ()}.setExecutionContext is not supported.`);

      // Disconnect interests.

      this .getOuterNode ?.()  ?.getLive () .removeInterest (_set_live__, this);
      this [_executionContext] ?.getLive () .removeInterest (_set_live__, this);
      this [_browser]           .getLive () .removeInterest (_set_live__, this);

      // Currently only useful for Scene.
      this [_executionContext] = executionContext;

      // Connect interests.

      if (this .getOuterNode ?.())
         this .getOuterNode () .getLive () .addInterest (_set_live__, this);

      else if (this [_executionContext])
         this [_executionContext] .getLive () .addInterest (_set_live__, this);

      else
         this [_browser] .getLive () .addInterest (_set_live__, this);

      this [_set_live__] ();
   },
   addType (value)
   {
      this [_type] .push (value);
   },
   getType ()
   {
      return this [_type];
   },
   setup ()
   {
      Object .freeze (this [_type]);

      this [_fieldDefinitions]  .addParent (this);
      this [_predefinedFields]  .addParent (this);
      this [_userDefinedFields] .addParent (this);

      for (const field of this [_childObjects])
         field .setTainted (false);

      for (const field of this [_predefinedFields])
         field .setTainted (false);

      for (const field of this [_userDefinedFields])
         field .setTainted (false);

      this .initialize ();

      this [_initialized] = true;
   },
   initialize ()
   { },
   isInitialized ()
   {
      return this [_initialized];
   },
   getInnerNode ()
   {
      return this;
   },
   isLive ()
   {
      ///  Returns the own live state of this node.

      return this [_live];
   },
   setLive (value)
   {
      ///  Sets the own live state of this node.  Setting the live state to false
      ///  temporarily disables this node completely.

      this [_live] = !!value .valueOf ();

      this [_set_live__] ();
   },
   getLive: (() =>
   {
      function getLive ()
      {
         return this ._live;
      }

      return function ()
      {
         ///  Returns the live event of this node.

         // Change function.

         Object .defineProperty (this, "getLive", { value: getLive });

         // Add isLive event.

         this .addChildObjects (X3DConstants/* default */.A .outputOnly, "live", new Fields/* default */.A .SFBool (this .checkLiveState ()));

         // Event processing is done manually and immediately, so:
         this ._live .removeParent (this);

         // Connect to execution context.

         if (this .getOuterNode ?.())
            this .getOuterNode () .getLive () .addInterest (_set_live__, this);

         else if (this [_executionContext] && this !== this [_browser])
            this [_executionContext] .getLive () .addInterest (_set_live__, this);

         else if (!this [_executionContext] && this !== this [_browser])
            this [_browser] .getLive () .addInterest (_set_live__, this);

         // Return field.

         return this ._live;
      };
   })(),
   checkLiveState ()
   {
      ///  Determines the live state of this node.

      if (this .getOuterNode ?.())
         return this [_live] && this .getOuterNode () .getLive () .getValue ();

      else if (this [_executionContext] && this !== this [_browser])
         return this [_live] && this [_executionContext] .getLive () .getValue ();

      else if (!this [_executionContext] && this !== this [_browser])
         return this [_live] && this [_browser] .isLive ();

      return this [_live];
   },
   [_set_live__] ()
   {
      const live = this ._live;

      if (!live)
         return;

      if (this .checkLiveState ())
      {
         if (live .getValue ())
            return;

         live .set (true);
         live .processEvent ();
      }
      else
      {
         if (live .getValue ())
         {
            live .set (false);
            live .processEvent ();
         }
      }
   },
   addChildObjects (... args /* accessType, name, field, ... */)
   {
      const length = args .length;

      for (let i = 0; i < length; i += 3)
         this .addChildObject (args [i], args [i + 1], args [i + 2]);
   },
   addChildObject (accessType, name, field)
   {
      this [_childObjects] .push (field);

      field .setPrivate (true);
      field .setTainted (true);
      field .addParent (this);
      field .setName (name);
      field .setAccessType (accessType);

      Object .defineProperty (this, `_${name}`,
      {
         get () { return field; },
         set (value) { field .setValue (value); },
      });
   },
   getFieldDefinitions ()
   {
      return this [_fieldDefinitions];
   },
   getField (name)
   {
      const field = getFieldFromArray (this [_userDefinedFields], name)
         ?? getFieldFromArray (this [_predefinedFields], name);

      if (field)
         return field;

      throw new Error (`Unknown field '${name}' in node class ${this .getTypeName ()}.`);
   },
   getFields ()
   {
      return [... this [_predefinedFields], ... this [_userDefinedFields]];
   },
   addPredefinedField (fieldDefinition)
   {
      const
         accessType = fieldDefinition .getAccessType (),
         name       = fieldDefinition .getName (),
         field      = fieldDefinition .getValue () .copy ();

      field .setTainted (!this [_initialized]);
      field .addParent (this);
      field .setName (name);
      field .setAccessType (accessType);

      this [_predefinedFields] .add (name, field);

      Object .defineProperty (this, `_${name}`,
      {
         get () { return field; },
         set (value) { field .setValue (value); },
         configurable: true,
      });
   },
   addAlias (alias, field)
   {
      this [_predefinedFields] .alias (alias, field);

      if (field .isInitializable ())
         HTMLSupport/* default */.A .addFieldName (alias);
   },
   removePredefinedField (name)
   {
      const field = this [_predefinedFields] .get (name);

      if (!field)
         return;

      field .removeParent (this);

      this [_predefinedFields] .remove (name);

      delete this [`_${field .getName ()}`];
   },
   getPredefinedField (name)
   {
      const field = getFieldFromArray (this [_predefinedFields], name);

      if (field)
         return field;

      throw new Error (`Unknown predefined field '${name}' in node class ${this .getTypeName ()}.`);
   },
   getPredefinedFields ()
   {
      return this [_predefinedFields];
   },
   canUserDefinedFields ()
   {
      return false;
   },
   addUserDefinedField (accessType, name, field)
   {
      if (!this .canUserDefinedFields ())
         throw new Error ("Couldn't add user-defined field, node does not support this.");

      if (this [_userDefinedFields] .has (name))
         this .removeUserDefinedField (name);

      field .setTainted (!this [_initialized]);
      field .addParent (this);
      field .setName (name);
      field .setAccessType (accessType);

      this [_fieldDefinitions] .remove (name);

      this [_fieldDefinitions]  .add (name, new X3DFieldDefinition/* default */.A (accessType, name, field));
      this [_userDefinedFields] .add (name, field);
   },
   removeUserDefinedField (name)
   {
      const field = this [_userDefinedFields] .get (name);

      if (!field)
         return;

      field .removeParent (this);

      this [_fieldDefinitions]  .remove (name);
      this [_userDefinedFields] .remove (name);
   },
   getUserDefinedField (name)
   {
      const field = getFieldFromArray (this [_userDefinedFields], name);

      if (field)
         return field;

      throw new Error (`Unknown user-defined field '${name}' in node class ${this .getTypeName ()}.`);
   },
   getUserDefinedFields ()
   {
      return this [_userDefinedFields];
   },
   /**
    *
    * @param {boolean} extended  also return user-defined fields and fields with routes
    * @returns Array<X3DField>
    */
   getChangedFields (extended = false)
   {
      const changedFields = [ ];

      if (extended)
      {
         for (const field of this [_userDefinedFields])
            changedFields .push (field);
      }

      for (const field of this [_predefinedFields])
      {
         if (extended)
         {
            if (field .getInputRoutes () .size || field .getOutputRoutes () .size)
            {
               changedFields .push (field);
               continue;
            }
         }

         if (field .getReferences () .size === 0)
         {
            if (!field .isInitializable ())
               continue;

            if (this .isDefaultValue (field))
               continue;
         }

         changedFields .push (field);
      }

      return changedFields;
   },
   isDefaultValue (field)
   {
      const
         name = field .getName (),
         f    = this [_userDefinedFields] .get (name) ?? this [_predefinedFields] .get (name);

      const fieldDefinition = f === field
         ? this [_fieldDefinitions] .get (name)
         : this .constructor .fieldDefinitions ?.get (name);

      return fieldDefinition ?.getValue () .equals (field) ?? field .getModificationTime () < 0;
   },
   getExtendedEventHandling ()
   {
      // Whether initializeOnly field are treated like inputOnly and inputOutput fields.
      return true;
   },
   addEvent (field)
   {
      if (field .isTainted ())
      {
         field .setModificationTime (Date .now () / 1000);
         return;
      }

      // if (this .getTypeName () === "HAnimMotion")
      // {
      //    console .log (field .getName ());
      //    console .trace ();
      // }

      field .setTainted (true);

      this .addEventObject (field, Events/* default */.A .create (field));
   },
   addEventObject (field, event)
   {
      const browser = this [_browser];

      field .setModificationTime (Date .now () / 1000);

      // Register for processEvent

      browser .addTaintedField (field, event);
      browser .addBrowserEvent ();

      // Register for eventsProcessed

      if (this .isTainted ())
         return;

      if (field .isInput () || (this .getExtendedEventHandling () && field .isInitializable ()))
      {
         this .addNodeEvent ();
      }
   },
   addNodeEvent ()
   {
      this .setModificationTime (Date .now () / 1000);

      if (this .isTainted ())
         return;

      // if (this .getTypeName () === "HAnimMotion")
      // {
      //    console .trace ();
      // }

      const browser = this [_browser];

      this .setTainted (true);
      browser .addTaintedNode (this);
      browser .addBrowserEvent ();
   },
   parentsChanged ()
   {
      const time = Date .now () / 1000;

      if (this [_executionContext])
         this [_executionContext] ._sceneGraph_changed = time;

      this ._parents_changed = time;
   },
   dispose ()
   {
      this .getOuterNode ?.()  ?.getLive () .removeInterest (_set_live__, this);
      this [_executionContext] ?.getLive () .removeInterest (_set_live__, this);
      this [_browser]          ?.getLive () .removeInterest (_set_live__, this);

      this .setLive (false);

      for (const field of this [_childObjects])
         field .dispose ();

      for (const field of this [_predefinedFields])
         field .dispose ();

      for (const field of this [_userDefinedFields])
         field .dispose ();

      X3DChildObject/* default */.A .prototype .dispose .call (this);
   },
});

const getFieldFromArray = (() =>
{
   const
      set_field     = /^set_(.*?)$/,
      field_changed = /^(.*?)_changed$/;

   return function (array, name)
   {
      const field = array .get (name);

      if (field)
         return field;

      const match = name .match (set_field);

      if (match)
      {
         const field = array .get (match [1]);

         if (field ?.getAccessType () === X3DConstants/* default */.A .inputOutput)
            return field;
      }
      else
      {
         const match = name .match (field_changed);

         if (match)
         {
            const field = array .get (match [1]);

            if (field ?.getAccessType () === X3DConstants/* default */.A .inputOutput)
               return field;
         }
      }
   };
})();

for (const key of Object .keys (X3DBaseNode .prototype))
   Object .defineProperty (X3DBaseNode .prototype, key, { enumerable: false });

Object .defineProperties (X3DBaseNode .prototype,
{
   name_changed:
   {
      get () { return this ._name_changed; },
   },
   typeName_changed:
   {
      get () { return this ._typeName_changed; },
   },
   parents_changed:
   {
      get () { return this ._parents_changed; },
   },
});

const X3DBaseNode_default_ = X3DBaseNode;
;

/* harmony default export */ const Base_X3DBaseNode = (Namespace/* default */.A .add ("X3DBaseNode", X3DBaseNode_default_));

/***/ }),

/***/ 3816:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _X3DParser_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6376);
/* harmony import */ var _Expressions_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(1331);
/* harmony import */ var _Fields_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(4598);
/* harmony import */ var _Base_X3DField_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(2269);
/* harmony import */ var _Execution_X3DImportedNode_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(3288);
/* harmony import */ var _Prototype_X3DExternProtoDeclaration_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(8616);
/* harmony import */ var _Prototype_X3DProtoDeclaration_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(4246);
/* harmony import */ var _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(2212);
/* harmony import */ var _Placeholder_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(2921);
/* harmony import */ var _standard_Math_Numbers_Color3_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(2262);
/* harmony import */ var _standard_Math_Numbers_Color4_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(3527);
/* harmony import */ var _standard_Math_Numbers_Matrix3_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(8713);
/* harmony import */ var _standard_Math_Numbers_Matrix4_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(6179);
/* harmony import */ var _standard_Math_Numbers_Rotation4_js__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(7078);
/* harmony import */ var _standard_Math_Numbers_Vector2_js__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(923);
/* harmony import */ var _standard_Math_Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(7572);
/* harmony import */ var _standard_Math_Numbers_Vector4_js__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(8913);
/* harmony import */ var _DEVELOPMENT_js__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(615);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(717);
/* provided dependency */ var $ = __webpack_require__(9547);



















/*
 *  Grammar
 */

// VRML lexical elements
const Grammar = (0,_Expressions_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A) ({
   // General
   Whitespaces: /[\x20\n,\t\r]+/gy,
   Comment:     /#\/\*[\s\S]*?\*\/#|#.*?(?=[\n\r]|$)/gy,
   Comment3_2:  /#.*?(?=[\n\r]|$)/gy,
   Break:       /\r?\n/g,

   // Header
   Header:      /^#(VRML|X3D) V(.*?) (utf8)(?:[ \t]+(.*?))?[ \t]*[\n\r]/gy,

   // Keywords
   AS:          /AS/gy,
   COMPONENT:   /COMPONENT/gy,
   DEF:         /DEF/gy,
   EXPORT:      /EXPORT/gy,
   EXTERNPROTO: /EXTERNPROTO/gy,
   FALSE:       /FALSE|false/gy,
   IMPORT:      /IMPORT/gy,
   IS:          /IS/gy,
   META:        /META/gy,
   NULL:        /NULL|null/gy,
   TRUE:        /TRUE|true/gy,
   PROFILE:     /PROFILE/gy,
   PROTO:       /PROTO/gy,
   ROUTE:       /ROUTE/gy,
   TO:          /TO/gy,
   UNIT:        /UNIT/gy,
   USE:         /USE/gy,

   // Terminal symbols
   OpenBrace:    /\{/gy,
   CloseBrace:   /\}/gy,
   OpenBracket:  /\[/gy,
   CloseBracket: /\]/gy,
   Period:       /\./gy,
   Colon:        /\:/gy,

   Id: /[^\x30-\x39\x00-\x20\x22\x23\x27\x2b\x2c\x2d\x2e\x5b\x5c\x5d\x7b\x7d\x7f]{1}[^\x00-\x20\x22\x23\x27\x2c\x2e\x5b\x5c\x5d\x7b\x7d\x7f]*/gy,
   ComponentNameId: /[^\x30-\x39\x00-\x20\x22\x23\x27\x2b\x2c\x2d\x2e\x5b\x5c\x5d\x7b\x7d\x7f\x3a]{1}[^\x00-\x20\x22\x23\x27\x2c\x2e\x5b\x5c\x5d\x7b\x7d\x7f\x3a]*/gy,

   initializeOnly: /initializeOnly/gy,
   inputOnly:      /inputOnly/gy,
   outputOnly:     /outputOnly/gy,
   inputOutput:    /inputOutput/gy,

   field:        /field/gy,
   eventIn:      /eventIn/gy,
   eventOut:     /eventOut/gy,
   exposedField: /exposedField/gy,

   FieldType: /[SM]F(?:Bool|ColorRGBA|Color|Double|Float|Image|Int32|Matrix3d|Matrix3f|Matrix4d|Matrix4f|Node|Rotation|String|Time|Vec2d|Vec2f|Vec3d|Vec3f|Vec4d|Vec4f)/gy,

   // Values
   int32: /(?:0[xX][\da-fA-F]+)|(?:[+-]?\d+)/gy,
   double: /[+-]?(?:(?:(?:\d*\.\d+)|(?:\d+(?:\.)?))(?:[eE][+-]?\d+)?)/gy,
   doubleQuotes: /"/gy,
   noDoubleQuotes: /[^"]+/gy,

   CONSTANTS: /([+-]?)\b(NAN|INFINITY|INF|PI|PI2|PI1_4|PI2_4|PI3_4|PI4_4|PI5_4|PI6_4|PI7_4|PI8_4|PI1_2|PI2_2|PI3_2|PI4_2|PI1_3|PI2_3|PI3_3|PI4_3|PI5_3|PI6_3|SQRT1_2|SQRT2)\b/igy,
   HTMLColor: /[a-zA-Z]+|0[xX][\da-fA-F]+|rgba?\(.*?\)/gy,
});

/*
 *  Parser
 */

function VRMLParser (scene)
{
   _X3DParser_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .call (this, scene);

   this .Grammar =
   {
      Comment: Grammar .Comment,
   };
}

Object .assign (Object .setPrototypeOf (VRMLParser .prototype, _X3DParser_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .prototype),
{
   accessTypes: new Map ([
      ["field",          _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .initializeOnly],
      ["eventIn",        _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .inputOnly],
      ["eventOut",       _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .outputOnly],
      ["exposedField",   _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .inputOutput],
      ["initializeOnly", _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .initializeOnly],
      ["inputOnly",      _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .inputOnly],
      ["outputOnly",     _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .outputOnly],
      ["inputOutput",    _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .inputOutput],
   ]),
   SFImage: new _Fields_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .SFImage (),
   SFNode: new _Fields_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .SFNode (),
   MFString: new _Fields_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .MFString (),
   Color3: new _standard_Math_Numbers_Color3_js__WEBPACK_IMPORTED_MODULE_9__/* ["default"] */ .A (),
   Color4: new _standard_Math_Numbers_Color4_js__WEBPACK_IMPORTED_MODULE_10__/* ["default"] */ .A (),
   Matrix3: new _standard_Math_Numbers_Matrix3_js__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A (),
   Matrix4: new _standard_Math_Numbers_Matrix4_js__WEBPACK_IMPORTED_MODULE_12__/* ["default"] */ .A (),
   Rotation4: new _standard_Math_Numbers_Rotation4_js__WEBPACK_IMPORTED_MODULE_13__/* ["default"] */ .A (),
   Vector2: new _standard_Math_Numbers_Vector2_js__WEBPACK_IMPORTED_MODULE_14__/* ["default"] */ .A (),
   Vector3: new _standard_Math_Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_15__/* ["default"] */ .A (),
   Vector4: new _standard_Math_Numbers_Vector4_js__WEBPACK_IMPORTED_MODULE_16__/* ["default"] */ .A (),
   CONSTANTS: new Map ([
      ["NAN",      Number .NaN],
      ["INFINITY", Number .POSITIVE_INFINITY],
      ["INF",      Number .POSITIVE_INFINITY],
      ["PI",    Math .PI],
      ["PI2",   Math .PI * 2],
      ["PI1_4", Math .PI * 1/4],
      ["PI2_4", Math .PI * 2/4],
      ["PI3_4", Math .PI * 3/4],
      ["PI4_4", Math .PI * 4/4],
      ["PI5_4", Math .PI * 5/4],
      ["PI6_4", Math .PI * 6/4],
      ["PI7_4", Math .PI * 7/4],
      ["PI8_4", Math .PI * 8/4],
      ["PI1_2", Math .PI * 1/2],
      ["PI2_2", Math .PI * 2/2],
      ["PI3_2", Math .PI * 3/2],
      ["PI4_2", Math .PI * 4/2],
      ["PI1_3", Math .PI * 1/3],
      ["PI2_3", Math .PI * 2/3],
      ["PI3_3", Math .PI * 3/3],
      ["PI4_3", Math .PI * 4/3],
      ["PI5_3", Math .PI * 5/3],
      ["PI6_3", Math .PI * 6/3],
      ["SQRT1_2", Math .SQRT1_2],
      ["SQRT2",   Math .SQRT2],
   ]),
   unknownLevel: 0,
   getEncoding ()
   {
      return "STRING";
   },
   setInput (vrmlSyntax)
   {
      this .input      = vrmlSyntax;
      this .lineNumber = 1;
      this .lastIndex  = 0;
   },
   isValid ()
   {
      if (typeof this .input !== "string")
         return false;

      if (this .input .match (/^#VRML V1.0/))
         return false;

      return !! this .input .match (/^(?:#X3D|#VRML|(?:[\x20\n,\t\r]*|#.*?[\r\n])*(PROFILE|COMPONENT|META|UNIT|EXTERNPROTO|PROTO|DEF|NULL|IMPORT|EXPORT|ROUTE|\w+(?:[\x20\n,\t\r]*|#.*?[\r\n])\{|$))/);
   },
   parseIntoScene (resolve, reject)
   {
      try
      {
         this .resolve = resolve;
         this .reject  = reject;

         this .getScene () .setEncoding ("VRML");
         this .getScene () .setProfile (this .getBrowser () .getProfile ("Full"));
         this .x3dScene ();
      }
      catch (error)
      {
         throw new Error (this .getError (error));
      }
   },
   getError (error)
   {
      if (_DEVELOPMENT_js__WEBPACK_IMPORTED_MODULE_17__/* ["default"] */ .A)
         console .error (error);

      const
         string     = error .message,
         unexpected = this .lastIndex === this .input .length ? "Unexpected end of file. " : "";

      let
         rest     = this .getLine (),
         line     = this .getLastLine (),
         lastLine = this .getLastLine (),
         linePos  = line .length - rest .length + 1;

      if (line .length > 80)
      {
         line     = line .substring (linePos - 40, linePos + 40);
         lastLine = "";
         linePos  = 40;
      }

      // Get world URL.

      let worldURL = this .getExecutionContext () .getWorldURL ();

      if (worldURL .startsWith ("data:"))
         worldURL = worldURL .substring (0, worldURL .indexOf (","));

      // Format error.

      const message = "\n"
         + `********************************************************************************\n`
         + `Parser error at line ${this .lineNumber}:${linePos}\n`
         + `in '${worldURL}'\n`
         + `\n`
         + `${lastLine}\n`
         + `${line}\n`
         + `${Array (linePos) .join (" ")}^\n`
         + `${unexpected}${string}\n`
         + `********************************************************************************\n`
      ;

      return message;
   },
   getLine ()
   {
      let
         input     = this .input,
         lastIndex = this .lastIndex,
         line      = "";

      while (lastIndex < input .length && input [lastIndex] !== "\n" && input [lastIndex] !== "\r")
         line += input [lastIndex ++];

      this .lastIndex = lastIndex;

      return line;
   },
   getLastLine ()
   {
      let
         input     = this .input,
         lastIndex = Math .min (this .lastIndex, this .input .length - 1),
         line      = "";

      if (lastIndex < input .length && (input [lastIndex] !== "\n" || input [lastIndex] !== "\r"))
         -- lastIndex;

      while (lastIndex >= 0 && input [lastIndex] !== "\n" && input [lastIndex] !== "\r")
         line = input [lastIndex --] + line;

      this .lastIndex = lastIndex;

      return line;
   },
   comments ()
   {
      while (this .comment ())
         ;
   },
   comment ()
   {
      if (this .whitespaces ())
         return true;

      return this .Grammar .Comment .parse (this);
   },
   whitespaces ()
   {
      if (Grammar .Whitespaces .parse (this))
      {
         this .lines (this .result [0]);

         return true;
      }

      return false;
   },
   lines (string)
   {
      const match = string .match (Grammar .Break);

      if (match)
         this .lineNumber += match .length;
   },
   x3dScene: (() =>
   {
      const VRML =
      [
         "EnvironmentalSensor",
         "PointingDeviceSensor",
         "Scripting",
         "Sound",
         "Text",
      ];

      return function ()
      {
         const
            browser = this .getBrowser (),
            scene   = this .getScene ();

         this .headerStatement ();
         this .profileStatement ();
         this .componentStatements ();
         this .unitStatements ();
         this .metaStatements ();

         if (scene .getSpecificationVersion () === "2.0")
         {
            scene .setProfile (browser .getProfile ("Interchange"));

            for (const componentName of VRML)
               scene .updateComponent (browser .getComponent (componentName));
         }

         if (this .resolve)
         {
            browser .loadComponents (scene) .then (() =>
            {
               try
               {
                  this .statements (this .getExecutionContext () .rootNodes);
                  this .setupNodes ()

                  if (this .lastIndex < this .input .length)
                     throw new Error ("Unknown statement.");

                  this .resolve (scene);
               }
               catch (error)
               {
                  throw new Error (this .getError (error));
               }
            })
            .catch (this .reject);
         }
         else
         {
            this .statements (this .getExecutionContext () .rootNodes);
            this .setupNodes ()

            if (this .lastIndex < this .input .length)
               throw new Error ("Unknown statement.");
         }
      };
   })(),
   headerStatement ()
   {
      if (Grammar .Header .parse (this))
      {
         this .lines (this .result [0]);

         this .getScene () .setSpecificationVersion (this .result [2]);

         if (this .getScene () .getSpecificationVersion () <= 3.2)
            this .Grammar .Comment = Grammar .Comment3_2;

         return true;
      }

      return false;
   },
   profileStatement ()
   {
      this .comments ();

      if (Grammar .PROFILE .parse (this))
      {
         if (this .profileNameId ())
         {
            const profile = this .getBrowser () .getProfile (this .result [0]);

            this .getScene () .setProfile (profile);
            return;
         }

         throw new Error ("Expected a profile name.");
      }
   },
   componentStatements ()
   {
      let component;

      while (component = this .componentStatement ())
      {
         if (this .getScene () .hasComponent (component))
            continue;

         this .getScene () .updateComponent (component);
      }
   },
   componentStatement ()
   {
      this .comments ();

      if (Grammar .COMPONENT .parse (this))
      {
         if (this .componentNameId ())
         {
            const componentNameIdCharacters = this .result [0];

            this .comments ();

            if (Grammar .Colon .parse (this))
            {
               if (this .componentSupportLevel ())
               {
                  const componentSupportLevel = this .value;

                  return this .getBrowser () .getComponent (componentNameIdCharacters, componentSupportLevel);
               }

               throw new Error ("Expected a component support level.");
            }

            throw new Error ("Expected a ':' after component name.");
         }

         throw new Error ("Expected a component name.");
      }

      return null;
   },
   componentSupportLevel ()
   {
      return this .int32 ();
   },
   unitStatements ()
   {
      while (this .unitStatement ())
         ;
   },
   unitStatement ()
   {
      this .comments ();

      if (Grammar .UNIT .parse (this))
      {
         if (this .categoryNameId ())
         {
            const categoryNameId = this .result [0];

            if (this .unitNameId ())
            {
               const unitNameId = this .result [0];

               if (this .unitConversionFactor ())
               {
                  const unitConversionFactor = this .value;

                  try
                  {
                     this .getScene () .updateUnit (categoryNameId, unitNameId, unitConversionFactor);
                     return true;
                  }
                  catch (error)
                  {
                     console .warn (`Parser error at line ${this .lineNumber}: ${error .message}`);
                     return true;
                  }
               }

               throw new Error ("Expected unit conversion factor.");
            }

            throw new Error ("Expected unit name identifier.");
         }

         throw new Error ("Expected category name identifier after UNIT statement.");
      }

      return false;
   },
   unitConversionFactor ()
   {
      return this .double ();
   },
   metaStatements ()
   {
      while (this .metaStatement ())
         ;
   },
   metaStatement ()
   {
      this .comments ();

      if (Grammar .META .parse (this))
      {
         if (this .metaKey ())
         {
            const metaKey = this .value;

            if (this .metaValue ())
            {
               const metaValue = this .value;

               this .getScene () .addMetaData (metaKey, metaValue);
               return true;
            }

            throw new Error ("Expected metadata value.");
         }

         throw new Error ("Expected metadata key.");
      }

      return false;
   },
   metaKey ()
   {
      return this .string ();
   },
   metaValue ()
   {
      return this .string ();
   },
   exportStatement ()
   {
      this .comments ();

      if (Grammar .EXPORT .parse (this))
      {
         if (this .nodeNameId ())
         {
            const localNodeNameId = this .result [0];

            this .comments ();

            const node = this .getScene () .getLocalNode (localNodeNameId);

            let exportedNodeNameId;

            if (Grammar .AS .parse (this))
            {
               if (this .exportedNodeNameId ())
                  exportedNodeNameId = this .result [0];
               else
                  throw new Error ("No name given after AS.");
            }
            else
            {
               exportedNodeNameId = localNodeNameId;
            }

            try
            {
               const existingNode = this .getScene () .getExportedNode (exportedNodeNameId);

               this .getScene () .addExportedNode (this .getScene () .getUniqueExportName (exportedNodeNameId), existingNode);
            }
            catch
            { }

            this .getScene () .updateExportedNode (exportedNodeNameId, node);
            return true;
         }

         throw new Error ("No name given after EXPORT.");
      }

      return false;
   },
   importStatement ()
   {
      this .comments ();

      if (Grammar .IMPORT .parse (this))
      {
         if (this .nodeNameId ())
         {
            const
               inlineNodeNameId = this .result [0],
               namedNode        = this .getExecutionContext () .getNamedNode (inlineNodeNameId);

            this .comments ();

            if (Grammar .Period .parse (this))
            {
               if (this .exportedNodeNameId ())
               {
                  const exportedNodeNameId = this .result [0];

                  this .comments ();

                  let nodeNameId;

                  if (Grammar .AS .parse (this))
                  {
                     if (this .nodeNameId ())
                        nodeNameId = this .result [0];

                     else
                        throw new Error ("No name given after AS.");
                  }
                  else
                  {
                     nodeNameId = exportedNodeNameId;
                  }

                  // Rename existing imported node.

                  this .renameExistingNode (nodeNameId);

                  // Add new imported node.

                  this .getExecutionContext () .addImportedNode (namedNode, exportedNodeNameId, nodeNameId);

                  if (!this .getImportedNodes () .has (nodeNameId))
                  {
                     this .getImportedNodes () .set (nodeNameId, this .getExecutionContext () .getImportedNodes () .get (nodeNameId));
                  }

                  return true;
               }

               throw new Error ("Expected exported node name.");
            }

            throw new Error ("Expected a '.' after exported node name.");
         }

         throw new Error ("No name given after IMPORT statement.");
      }
      return false;
   },
   statements (field)
   {
      while (this .statement (field))
         ;
   },
   statement (field)
   {
      if (this .protoStatement ())
         return true;

      if (this .routeStatement ())
         return true;

      if (this .importStatement ())
         return true;

      if (this .exportStatement ())
         return true;

      const node = this .nodeStatement ();

      if (node !== false)
      {
         field .push (node);
         return true;
      }

      return false;
   },
   nodeStatement ()
   {
      this .comments ();

      if (Grammar .DEF .parse (this))
      {
         if (this .nodeNameId ())
            return this .node (this .result [0]);

         throw new Error ("No name given after DEF.");
      }

      if (Grammar .USE .parse (this))
      {
         if (this .nodeNameId ())
         {
            const nodeNameId = this .result [0];

            try
            {
               const localNode = this .getExecutionContext () .getLocalNode (nodeNameId);

               return localNode instanceof _Execution_X3DImportedNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A
                  ? localNode .getExportedNode ()
                  : localNode .getValue ();
            }
            catch
            {
               const placeholder = this .getPlaceholders () .get (nodeNameId);

               if (placeholder)
               {
                  return placeholder;
               }
               else
               {
                  const placeholder = new _Placeholder_js__WEBPACK_IMPORTED_MODULE_8__/* ["default"] */ .A (this, nodeNameId);

                  this .getPlaceholders () .set (nodeNameId, placeholder);

                  return placeholder;
               }
            }
         }

         throw new Error ("No name given after USE.");
      }

      if (Grammar .NULL .parse (this))
         return null;

      return this .node ("");
   },
   protoStatement ()
   {
      if (this .proto ())
         return true;

      if (this .externproto ())
         return true;

      return false;
   },
   protoStatements ()
   {
      while (this .protoStatement ())
         ;
   },
   proto ()
   {
      this .comments ();

      if (Grammar .PROTO .parse (this))
      {
         if (this .nodeTypeId ())
         {
            const nodeTypeId = this .result [0];

            this .comments ();

            if (Grammar .OpenBracket .parse (this))
            {
               const interfaceDeclarations = this .interfaceDeclarations ();

               this .comments ();

               if (Grammar .CloseBracket .parse (this))
               {
                  this .comments ();

                  if (Grammar .OpenBrace .parse (this))
                  {
                     const proto = new _Prototype_X3DProtoDeclaration_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A (this .getExecutionContext ());

                     for (const field of interfaceDeclarations)
                        proto .addUserDefinedField (field .getAccessType (), field .getName (), field);

                     this .pushExecutionContext (proto .getBody ());
                     this .protoBody (proto .getBody () .rootNodes);
                     this .setupNodes ();
                     this .popExecutionContext ();

                     this .comments ();

                     if (Grammar .CloseBrace .parse (this))
                     {
                        proto .setup ();

                        try
                        {
                           const existingProto = this .getExecutionContext () .getProtoDeclaration (nodeTypeId);

                           console .warn (`A proto named '${nodeTypeId}' is already defined and will be overridden.`);

                           this .getExecutionContext () .updateProtoDeclaration (this .getExecutionContext () .getUniqueProtoName (nodeTypeId), existingProto);
                        }
                        catch
                        { }

                        this .getExecutionContext () .updateProtoDeclaration (nodeTypeId, proto);

                        return true;
                     }

                     throw new Error ("Expected a '}' at the end of PROTO body.");
                  }

                  throw new Error ("Expected a '{' at the beginning of PROTO body.");
               }

               throw new Error ("Expected a ']' at the end of PROTO interface declaration.");
            }

            throw new Error ("Expected a '[' at the beginning of PROTO interface declaration.");
         }

         throw new Error ("Invalid PROTO definition name.");
      }

      return false;
   },
   protoBody (rootNodes)
   {
      this .protoStatements ();

      const rootNodeStatement = this .rootNodeStatement ();

      if (rootNodeStatement !== false)
         rootNodes .push (rootNodeStatement);

      this .statements (rootNodes);
   },
   rootNodeStatement ()
   {
      this .comments ();

      if (Grammar .DEF .parse (this))
      {
         if (this .nodeNameId ())
         {
            const
               nodeNameId = this .result [0],
               baseNode   = this .node (nodeNameId);

            if (baseNode !== false)
               return baseNode;

            throw new Error ("Expected node type name after DEF.");
         }

         throw new Error ("No name given after DEF.");
      }

      const baseNode = this .node ("");

      if (baseNode !== false)
         return baseNode;

      return false;
   },
   interfaceDeclarations ()
   {
      const interfaceDeclarations = [ ];

      let field;

      while (field = this .interfaceDeclaration ())
         interfaceDeclarations .push (field);

      return interfaceDeclarations;
   },
   restrictedInterfaceDeclaration ()
   {
      this .comments ();

      if (Grammar .inputOnly .parse (this) || Grammar .eventIn .parse (this))
      {
         if (this .fieldType ())
         {
            const fieldType = this .result [0];

            if (this .inputOnlyId ())
            {
               const
                  fieldId = this .result [0],
                  field   = new (_Fields_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A [fieldType]) ();

               field .setAccessType (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .inputOnly);
               field .setName (fieldId);

               return field;
            }

            throw new Error ("Expected a name for field.");
         }

         this .Id ();

         throw new Error (`Unknown event or field type: '${this .result [0]}'.`);
      }

      if (Grammar .outputOnly .parse (this) || Grammar .eventOut .parse (this))
      {
         if (this .fieldType ())
         {
            const fieldType = this .result [0];

            if (this .outputOnlyId ())
            {
               const
                  fieldId = this .result [0],
                  field   = new (_Fields_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A [fieldType]) ();

               field .setAccessType (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .outputOnly);
               field .setName (fieldId);

               return field;
            }

            throw new Error ("Expected a name for field.");
         }

         this .Id ();

         throw new Error (`Unknown event or field type: '${this .result [0]}'.`);
      }

      if (Grammar .initializeOnly .parse (this) || Grammar .field .parse (this))
      {
         if (this .fieldType ())
         {
            const fieldType = this .result [0];

            if (this .initializeOnlyId ())
            {
               const
                  fieldId = this .result [0],
                  field   = new (_Fields_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A [fieldType]) ();

               if (this .fieldValue (field))
               {
                  field .setAccessType (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .initializeOnly);
                  field .setName (fieldId);

                  return field;
               }

               throw new Error (`Couldn't read value for field '${fieldId}'.`);
            }

            throw new Error ("Expected a name for field.");
         }

         this .Id ();

         throw new Error (`Unknown event or field type: '${this .result [0]}'.`);
      }

      return null;
   },
   interfaceDeclaration ()
   {
      const field = this .restrictedInterfaceDeclaration ();

      if (field)
         return field;

      this .comments ();

      if (Grammar .inputOutput .parse (this) || Grammar .exposedField .parse (this))
      {
         if (this .fieldType ())
         {
            const fieldType = this .result [0];

            if (this .inputOutputId ())
            {
               const
                  fieldId = this .result [0],
                  field   = new (_Fields_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A [fieldType]) ();

               if (this .fieldValue (field))
               {
                  field .setAccessType (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .inputOutput);
                  field .setName (fieldId);

                  return field;
               }

               throw new Error (`Couldn't read value for field '${fieldId}'.`);
            }

            throw new Error ("Expected a name for field.");
         }

         this .Id ();

         throw new Error (`Unknown event or field type: '${this .result [0]}'.`);
      }

      return null;
   },
   externproto ()
   {
      this .comments ();

      if (Grammar .EXTERNPROTO .parse (this))
      {
         if (this .nodeTypeId ())
         {
            const nodeTypeId = this .result [0];

            this .comments ();

            if (Grammar .OpenBracket .parse (this))
            {
               const externInterfaceDeclarations = this .externInterfaceDeclarations ();

               this .comments ();

               if (Grammar .CloseBracket .parse (this))
               {
                  if (this .URLList (this .MFString))
                  {
                     const externproto = new _Prototype_X3DExternProtoDeclaration_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A (this .getExecutionContext (), this .MFString);

                     for (const field of externInterfaceDeclarations)
                        externproto .addUserDefinedField (field .getAccessType (), field .getName (), field);

                     externproto .setup ();

                     try
                     {
                        const existingExternProto = this .getExecutionContext () .getExternProtoDeclaration (nodeTypeId);

                        console .warn (`A extern proto named '${nodeTypeId}' is already defined and will be overridden.`);

                        this .getExecutionContext () .updateExternProtoDeclaration (this .getExecutionContext () .getUniqueExternProtoName (nodeTypeId), existingExternProto);
                     }
                     catch
                     { }

                     this .getExecutionContext () .updateExternProtoDeclaration (nodeTypeId, externproto);
                     return true;
                  }

                  throw new Error (`Expected a URL list after EXTERNPROTO interface declaration '${nodeTypeId}'.`);
               }

               throw new Error ("Expected a ']' at the end of EXTERNPROTO interface declaration.");
            }

            throw new Error ("Expected a '[' at the beginning of EXTERNPROTO interface declaration.");
         }

         throw new Error ("Invalid EXTERNPROTO definition name.");
      }

      return false;
   },
   externInterfaceDeclarations ()
   {
      const externInterfaceDeclarations = [ ];

      let field;

      while (field = this .externInterfaceDeclaration ())
         externInterfaceDeclarations .push (field);

      return externInterfaceDeclarations;
   },
   externInterfaceDeclaration ()
   {
      this .comments ();

      if (Grammar .inputOnly .parse (this) || Grammar .eventIn .parse (this))
      {
         if (this .fieldType ())
         {
            const fieldType = this .result [0];

            if (this .inputOnlyId ())
            {
               const
                  fieldId = this .result [0],
                  field   = new (_Fields_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A [fieldType]) ();

               field .setAccessType (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .inputOnly);
               field .setName (fieldId);

               return field;
            }

            throw new Error ("Expected a name for field.");
         }

         this .Id ()

         throw new Error (`Unknown event or field type: '${this .result [0]}'.`);
      }

      if (Grammar .outputOnly .parse (this) || Grammar .eventOut .parse (this))
      {
         if (this .fieldType ())
         {
            const fieldType = this .result [0];

            if (this .outputOnlyId ())
            {
               const
                  fieldId = this .result [0],
                  field   = new (_Fields_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A [fieldType]) ();

               field .setAccessType (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .outputOnly);
               field .setName (fieldId);

               return field;
            }

            throw new Error ("Expected a name for field.");
         }

         this .Id ()

         throw new Error (`Unknown event or field type: '${this .result [0]}'.`);
      }

      if (Grammar .initializeOnly .parse (this) || Grammar .field .parse (this))
      {
         if (this .fieldType ())
         {
            const fieldType = this .result [0];

            if (this .initializeOnlyId ())
            {
               const
                  fieldId = this .result [0],
                  field   = new (_Fields_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A [fieldType]) ();

               field .setAccessType (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .initializeOnly);
               field .setName (fieldId);

               return field;
            }

            throw new Error ("Expected a name for field.");
         }

         this .Id ()

         throw new Error (`Unknown event or field type: '${this .result [0]}'.`);
      }

      if (Grammar .inputOutput .parse (this) || Grammar .exposedField .parse (this))
      {
         if (this .fieldType ())
         {
            const fieldType = this .result [0];

            if (this .inputOutputId ())
            {
               const
                  fieldId = this .result [0],
                  field   = new (_Fields_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A [fieldType]) ();

               field .setAccessType (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .inputOutput);
               field .setName (fieldId);

               return field;
            }

            throw new Error ("Expected a name for field.");
         }

         this .Id ()

         throw new Error (`Unknown event or field type: '${this .result [0]}'.`);
      }

      return null;
   },
   URLList (field)
   {
      return this .mfstringValue (field);
   },
   routeStatement ()
   {
      this .comments ();

      if (Grammar .ROUTE .parse (this))
      {
         if (this .nodeNameId ())
         {
            const
               fromNodeId = this .result [0],
               fromNode   = this .getExecutionContext () .getLocalNode (fromNodeId);

            this .comments ();

            if (Grammar .Period .parse (this))
            {
               if (this .outputOnlyId ())
               {
                  const eventOutId = this .result [0];

                  this .comments ();

                  if (Grammar .TO .parse (this))
                  {
                     if (this .nodeNameId ())
                     {
                        const
                           toNodeId = this .result [0],
                           toNode   = this .getExecutionContext () .getLocalNode (toNodeId);

                        this .comments ();

                        if (Grammar .Period .parse (this))
                        {
                           if (this .inputOnlyId ())
                           {
                              try
                              {
                                 const eventInId = this .result [0];

                                 this .getExecutionContext () .addRoute (fromNode, eventOutId, toNode, eventInId);
                                 return true;
                              }
                              catch (error)
                              {
                                 console .warn (`Parser error at line ${this .lineNumber}: ${error .message}`);

                                 return true;
                              }
                           }

                           throw new Error ("Bad ROUTE specification: Expected a field name.");
                        }

                        throw new Error ("Bad ROUTE specification: Expected a '.' after node name.");
                     }

                     throw new Error ("Bad ROUTE specification: Expected a node name.");
                  }

                  throw new Error ("Bad ROUTE specification: Expected a 'TO'.");
               }

               throw new Error ("Bad ROUTE specification: Expected a field name.");
            }

            throw new Error ("Bad ROUTE specification: Expected a '.' after node name.");
         }

         throw new Error ("Bad ROUTE specification: Expected a node name.");
      }

      return false;
   },
   node (nodeNameId)
   {
      if (this .nodeTypeId ())
      {
         const nodeTypeId = this .result [0];

         const baseNode = this .getExecutionContext () .createNode (nodeTypeId, false)
            ?? this .getExecutionContext () .createProto (nodeTypeId, false);

         if (!baseNode)
         {
            // Parse unknown node.

            if (!this .unknownLevel)
            {
               console .warn (`Parser error at line ${this .lineNumber}: Unknown node type or proto '${nodeTypeId}', you probably have insufficient component/profile statements, and/or an inappropriate specification version.`);
            }

            this .comments ();

            if (Grammar .OpenBrace .parse (this))
            {
               ++ this .unknownLevel;

               this .nodeBody (this .getExecutionContext () .createNode ("MetadataBoolean", false));

               -- this .unknownLevel;

               this .comments ();

               if (Grammar .CloseBrace .parse (this))
                  return null;
            }

            return false;
         }

         if (nodeNameId .length)
         {
            if (!this .getNamedNodes () .has (nodeNameId))
               this .getNamedNodes () .set (nodeNameId, baseNode);

            this .renameExistingNode (nodeNameId);

            this .getExecutionContext () .updateNamedNode (nodeNameId, baseNode);
         }

         this .comments ();

         if (Grammar .OpenBrace .parse (this))
         {
            if (baseNode .canUserDefinedFields ())
               this .scriptBody (baseNode);

            else
               this .nodeBody (baseNode);

            this .comments ();

            if (Grammar .CloseBrace .parse (this))
            {
               if (!this .isInsideProtoDeclaration ())
                  this .getNodes () .push (baseNode);

               return baseNode;
            }

            throw new Error ("Expected '}' at the end of node body.");
         }

         throw new Error ("Expected '{' at the beginning of node body.");
      }

      return false;
   },
   scriptBody (baseNode)
   {
      while (this .scriptBodyElement (baseNode))
         ;
   },
   scriptBodyElement (baseNode)
   {
      const
         lastIndex  = this .lastIndex,
         lineNumber = this .lineNumber;

      if (this .Id ())
      {
         const accessType = this .accessTypes .get (this .result [0]);

         if (accessType)
         {
            if (this .fieldType ())
            {
               const fieldType = this .result [0];

               if (this .Id ())
               {
                  const fieldId = this .result [0];

                  this .comments ();

                  if (Grammar .IS .parse (this))
                  {
                     if (this .isInsideProtoDeclaration ())
                     {
                        if (this .Id ())
                        {
                           const isId = this .result [0];

                           let reference;

                           try
                           {
                              reference = this .getOuterNode () .getField (isId);
                           }
                           catch
                           {
                              console .warn (`Parser error at line ${this .lineNumber}: No such event or field '${isId}' inside PROTO ${this .getOuterNode () .getName ()} interface declaration.`);

                              return true;
                           }

                           if (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A [fieldType] === reference .getType ())
                           {
                              if (reference .isReference (accessType))
                              {
                                 let field = $.try (() => baseNode .getUserDefinedField (fieldId));

                                 if (!field)
                                 {
                                    field = new (_Fields_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A [fieldType]) ();

                                    baseNode .addUserDefinedField (accessType, fieldId, field);
                                 }

                                 if (accessType === field .getAccessType () && reference .getType () === field .getType ())
                                 {
                                    field .addReference (reference);
                                    return true;
                                 }

                                 throw new Error (`Couldn't add field '${fieldId}', field already exists with different access type or data type.`);
                              }

                              throw new Error (`Field '${fieldId}' and '${reference .getName ()}' in PROTO '${this .getOuterNode () .getName ()}' are incompatible as an IS mapping.`);
                           }

                           throw new Error (`Field '${fieldId}' and '${reference .getName ()}' in PROTO '${this .getOuterNode () .getName ()}' have different types.`);
                        }

                        throw new Error ("No name give after IS statement.");
                     }

                     throw new Error ("IS statement outside PROTO definition.");
                  }
               }
            }
         }
      }

      this .lastIndex  = lastIndex;
      this .lineNumber = lineNumber;

      const field = this .interfaceDeclaration ();

      if (field)
      {
         const existingField = $.try (() => baseNode .getUserDefinedField (field .getName ()));

         if (existingField)
         {
            if (existingField .getAccessType () === field .getAccessType () && existingField .getType () === field .getType ())
            {
               existingField .assign (field);
               return true;
            }

            throw new Error (`Couldn't set value for field '${field .getName ()}', field already exists with different access type or data type.`);
         }

         baseNode .addUserDefinedField (field .getAccessType (), field .getName (), field);
         return true;
      }

      return this .nodeBodyElement (baseNode);
   },
   nodeBody (baseNode)
   {
      while (this .nodeBodyElement (baseNode))
         ;
   },
   nodeBodyElement (baseNode)
   {
      if (this .protoStatement ())
         return true;

      if (this .routeStatement ())
         return true;

      if (this .Id ())
      {
         const fieldId = this .result [0];

         let field;

         try
         {
            field = baseNode .getPredefinedField (fieldId);
         }
         catch
         {
            // Parse unknown field value.

            const lineNumber = this .lineNumber;

            if (this .unknownValue ())
            {
               if (!this .unknownLevel)
               {
                  console .warn (`Parser error at line ${lineNumber}: Unknown field '${fieldId}' in class '${baseNode .getTypeName ()}'.`);
               }

               return true;
            }

            throw new Error (`Unknown field '${fieldId}' in class '${baseNode .getTypeName ()}'.`);
         }

         this .comments ();

         if (Grammar .IS .parse (this))
         {
            if (this .isInsideProtoDeclaration ())
            {
               if (this .Id ())
               {
                  const isId = this .result [0];

                  let reference;

                  try
                  {
                     reference = this .getOuterNode () .getField (isId);
                  }
                  catch
                  {
                     console .warn (`Parser error at line ${this .lineNumber}: No such event or field '${isId}' inside PROTO ${this .getOuterNode () .getName ()}`);

                     return true;
                  }

                  if (field .getType () === reference .getType ())
                  {
                     if (reference .isReference (field .getAccessType ()))
                     {
                        field .addReference (reference);
                        return true;
                     }

                     throw new Error (`Field '${field .getName ()}' and '${reference .getName ()}' in PROTO ${this .getOuterNode () .getName ()} are incompatible as an IS mapping.`);
                  }

                  throw new Error (`Field '${field .getName ()}' and '${reference .getName ()}' in PROTO ${this .getOuterNode () .getName ()} have different types.`);
               }

               throw new Error ("No name give after IS statement.");
            }

            throw new Error ("IS statement outside PROTO definition.");
         }

         if (field .isInitializable ())
         {
            if (this .fieldValue (field))
               return true;

            throw new Error (`Couldn't read value for field '${fieldId}'.`);
         }

         // Parse value of a inputOnly or outputOnly, and output a warning.

         if (!this .unknownValue ())
            throw new Error (`Couldn't read value for field '${fieldId}'.`);

         console .warn (`Parser error at line ${this .lineNumber}: Couldn't assign value to ${this .accessTypeToString (field .getAccessType ())} field '${fieldId}'.`);

         return true;
      }

      return false;
   },
   profileNameId () { return this .Id (); },
   componentNameId ()
   {
      this .comments ();

      return Grammar .ComponentNameId .parse (this);
   },
   categoryNameId () { return this .Id (); },
   unitNameId () { return this .Id (); },
   exportedNodeNameId () { return this .Id (); },
   nodeNameId () { return this .Id (); },
   nodeTypeId () { return this .Id (); },
   initializeOnlyId () { return this .Id (); },
   inputOnlyId () { return this .Id (); },
   outputOnlyId () { return this .Id (); },
   inputOutputId () { return this .Id (); },
   Id ()
   {
      this .comments ();

      return Grammar .Id .parse (this);
   },
   fieldType ()
   {
      this .comments ();

      return Grammar .FieldType .parse (this);
   },
   fieldValue (field)
   {
      return this [field .getType ()] (field, field .getUnit ());
   },
   bool ()
   {
      this .comments ();

      if (Grammar .TRUE .parse (this))
      {
         this .value = true;
         return true;
      }

      if (Grammar .FALSE .parse (this))
      {
         this .value = false;
         return true;
      }

      return false;
   },
   double ()
   {
      this .comments ();

      if (Grammar .double .parse (this))
      {
         this .value = parseFloat (this .result [0]);
         return true;
      }

      // Constants

      if (Grammar .CONSTANTS .parse (this))
      {
         this .value = this .CONSTANTS .get (this .result [2] .toUpperCase ());

         if (this .result [1] === "-")
            this .value = -this .value;

         return true;
      }

      return false;
   },
   int32 ()
   {
      this .comments ();

      if (Grammar .int32 .parse (this))
      {
         this .value = parseInt (this .result [0]);
         return true;
      }

      return false;
   },
   string ()
   {
      this .comments ();

      if (Grammar .doubleQuotes .parse (this))
      {
         let value = "";

         while (Grammar .noDoubleQuotes .parse (this))
         {
            value += this .result [0];

            const m = value .match (/\\+$/);

            if (!m || m [0] .length % 2 === 0)
               break;

            Grammar .doubleQuotes .parse (this);

            value += '"';
         }

         if (Grammar .doubleQuotes .parse (this))
         {
            this .lines (value);

            this .value = _Fields_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .SFString .unescape (value);

            return true;
         }
      }

      return false;
   },
   sfboolValue (field)
   {
      if (this .bool ())
      {
         field .setValue (this .value);
         return true;
      }

      return false;
   },
   mfboolValue (field)
   {
      field .length = 0;

      if (this .bool ())
      {
         field .push (this .value);
         return true;
      }

      if (Grammar .OpenBracket .parse (this))
      {
         this .sfboolValues (field);

         if (Grammar .CloseBracket .parse (this))
            return true;

         throw new Error ("Expected ']'.");
      }

      return false;
   },
   sfboolValues (field)
   {
      const array = [ ];

      while (this .bool ())
         array .push (this .value);

      field .setValue (array);

      return field .length !== 0;
   },
   sfcolorValue (field)
   {
      const lastIndex = this .lastIndex;

      if (this .double ())
      {
         const r = this .value;

         if (this .double ())
         {
            const g = this .value;

            if (this .double ())
            {
               const b = this .value;

               field .r = r;
               field .g = g;
               field .b = b;

               return true;
            }
         }
      }

      this .lastIndex = lastIndex;

      this .comments ();

      if (Grammar .HTMLColor .parse (this))
      {
         const color = this .convertColor (this .result [0] .replace (/0x/i, "#"));

         field .r = color [0];
         field .g = color [1];
         field .b = color [2];

         return true;
      }

      return false;
   },
   mfcolorValue (field)
   {
      field .length = 0;

      if (this .sfcolorValue (this .Color3))
      {
         field .push (this .Color3);
         return true;
      }

      if (Grammar .OpenBracket .parse (this))
      {
         this .sfcolorValues (field);

         if (Grammar .CloseBracket .parse (this))
            return true;

         throw new Error ("Expected ']'.");
      }

      return false;
   },
   sfcolorValues (field)
   {
      const array = [ ];

      while (this .double ())
         array .push (this .value);

      field .setValue (array);

      return field .length !== 0;
   },
   sfcolorrgbaValue (field)
   {
      const lastIndex = this .lastIndex;

      if (this .double ())
      {
         const r = this .value;

         if (this .double ())
         {
            const g = this .value;

            if (this .double ())
            {
               const b = this .value;

               if (this .double ())
               {
                  const a = this .value;

                  field .r = r;
                  field .g = g;
                  field .b = b;
                  field .a = a;

                  return true;
               }
            }
         }
      }

      this .lastIndex = lastIndex;

      this .comments ();

      if (Grammar .HTMLColor .parse (this))
      {
         const color = this .convertColor (this .result [0] .replace (/0x/i, "#"));

         field .r = color [0];
         field .g = color [1];
         field .b = color [2];
         field .a = color [3];

         return true;
      }

      return false;
   },
   mfcolorrgbaValue (field)
   {
      field .length = 0;

      if (this .sfcolorrgbaValue (this .Color4))
      {
         field .push (this .Color4);
         return true;
      }

      if (Grammar .OpenBracket .parse (this))
      {
         this .sfcolorValues (field);

         if (Grammar .CloseBracket .parse (this))
            return true;

         throw new Error ("Expected ']'.");
      }

      return false;
   },
   sfdoubleValue (field)
   {
      if (this .double ())
      {
         field .setValue (this .fromUnit (field .getUnit (), this .value));
         return true;
      }

      return false;
   },
   mfdoubleValue (field)
   {
      field .length = 0;

      if (this .double ())
      {
         field .push (this .fromUnit (field .getUnit (), this .value));
         return true;
      }

      if (Grammar .OpenBracket .parse (this))
      {
         this .sfdoubleValues (field);

         if (Grammar .CloseBracket .parse (this))
            return true;

         throw new Error ("Expected ']'.");
      }

      return false;
   },
   sfdoubleValues (field)
   {
      const
         unit  = field .getUnit (),
         array = [ ];

      while (this .double ())
         array .push (this .fromUnit (unit, this .value));

      field .setValue (array);

      return field .length !== 0;
   },
   sfimageValue (field)
   {
      if (this .int32 ())
      {
         const width = this .value;

         if (this .int32 ())
         {
            const height = this .value;

            if (this .int32 ())
            {
               const
                  comp  = this .value,
                  size  = width * height,
                  array = [ ];

               for (let i = 0; i < size; ++ i)
               {
                  if (this .int32 ())
                  {
                     array .push (this .value);
                     continue;
                  }

                  return false;
               }

               field .width  = width;
               field .height = height;
               field .comp   = comp;
               field .array  = array;

               return true;
            }
         }
      }

      return false;
   },
   mfimageValue (field)
   {
      field .length = 0;

      if (this .sfimageValue (this .SFImage))
      {
         field .push (this .SFImage);
         return true;
      }

      if (Grammar .OpenBracket .parse (this))
      {
         this .sfimageValues (field);

         if (Grammar .CloseBracket .parse (this))
            return true;

         throw new Error ("Expected ']'.");
      }

      return false;
   },
   sfimageValues (field)
   {
      field .length = 0;

      const
         target = field .getTarget (),
         value  = this .SFImage;

      while (this .sfimageValue (value))
         target .push (value);

      return field .length !== 0;
   },
   sfint32Value (field)
   {
      if (this .int32 ())
      {
         field .setValue (this .value);
         return true;
      }

      return false;
   },
   mfint32Value (field)
   {
      field .length = 0;

      if (this .int32 ())
      {
         field .push (this .value);
         return true;
      }

      if (Grammar .OpenBracket .parse (this))
      {
         this .sfint32Values (field);

         if (Grammar .CloseBracket .parse (this))
            return true;

         throw new Error ("Expected ']'.");
      }

      return false;
   },
   sfint32Values (field)
   {
      const array = [ ];

      while (this .int32 ())
         array .push (this .value);

      field .setValue (array);

      return field .length !== 0;
   },
   sfmatrix3Value (field)
   {
      if (this .double ())
      {
         const m00 = this .value;

         if (this .double ())
         {
            const m01 = this .value;

            if (this .double ())
            {
               const m02 = this .value;

                  if (this .double ())
                  {
                     const m10 = this .value;

                     if (this .double ())
                     {
                        const m11 = this .value;

                        if (this .double ())
                        {
                           const m12 = this .value;

                           if (this .double ())
                           {
                              const m20 = this .value;

                              if (this .double ())
                              {
                                 const m21 = this .value;

                                 if (this .double ())
                                 {
                                    const m22 = this .value;

                                    field [0] = m00;
                                    field [1] = m01;
                                    field [2] = m02;
                                    field [3] = m10;
                                    field [4] = m11;
                                    field [5] = m12;
                                    field [6] = m20;
                                    field [7] = m21;
                                    field [8] = m22;

                                    return true;
                              }
                           }
                        }
                     }
                  }
               }
            }
         }
      }

      return false;
   },
   mfmatrix3Value (field)
   {
      field .length = 0;

      if (this .sfmatrix3Value (this .Matrix3))
      {
         field .push (this .Matrix3);
         return true;
      }

      if (Grammar .OpenBracket .parse (this))
      {
         this .sfmatrixValues (field);

         if (Grammar .CloseBracket .parse (this))
            return true;

         throw new Error ("Expected ']'.");
      }

      return false;
   },
   sfmatrixValues (field)
   {
      const array = [ ];

      while (this .double ())
         array .push (this .value);

      field .setValue (array);

      return field .length !== 0;
   },
   sfmatrix4Value (field)
   {
      if (this .double ())
      {
         const m00 = this .value;

         if (this .double ())
         {
            const m01 = this .value;

            if (this .double ())
            {
               const m02 = this .value;

               if (this .double ())
               {
                  const m03 = this .value;

                  if (this .double ())
                  {
                     const m10 = this .value;

                     if (this .double ())
                     {
                        const m11 = this .value;

                        if (this .double ())
                        {
                           const m12 = this .value;

                           if (this .double ())
                           {
                              const m13 = this .value;

                              if (this .double ())
                              {
                                 const m20 = this .value;

                                 if (this .double ())
                                 {
                                    const m21 = this .value;

                                    if (this .double ())
                                    {
                                       const m22 = this .value;

                                       if (this .double ())
                                       {
                                          const m23 = this .value;

                                          if (this .double ())
                                          {
                                             const m30 = this .value;

                                             if (this .double ())
                                             {
                                                const m31 = this .value;

                                                if (this .double ())
                                                {
                                                   const m32 = this .value;

                                                   if (this .double ())
                                                   {
                                                      const m33 = this .value;

                                                      field [ 0] = m00;
                                                      field [ 1] = m01;
                                                      field [ 2] = m02;
                                                      field [ 3] = m03;
                                                      field [ 4] = m10;
                                                      field [ 5] = m11;
                                                      field [ 6] = m12;
                                                      field [ 7] = m13;
                                                      field [ 8] = m20;
                                                      field [ 9] = m21;
                                                      field [10] = m22;
                                                      field [11] = m23;
                                                      field [12] = m30;
                                                      field [13] = m31;
                                                      field [14] = m32;
                                                      field [15] = m33;

                                                      return true;
                                                   }
                                                }
                                             }
                                          }
                                       }
                                    }
                                 }
                              }
                           }
                        }
                     }
                  }
               }
            }
         }
      }

      return false;
   },
   mfmatrix4Value (field)
   {
      field .length = 0;

      if (this .sfmatrix4Value (this .Matrix4))
      {
         field .push (this .Matrix4);
         return true;
      }

      if (Grammar .OpenBracket .parse (this))
      {
         this .sfmatrixValues (field);

         if (Grammar .CloseBracket .parse (this))
            return true;

         throw new Error ("Expected ']'.");
      }

      return false;
   },
   sfnodeValue (field)
   {
      const baseNode = this .nodeStatement ();

      if (baseNode !== false)
      {
         field .setValue (baseNode);
         return true;
      }

      return false;
   },
   mfnodeValue (field)
   {
      field .length = 0;

      const node = this .nodeStatement ();

      if (node !== false)
      {
         field .push (node);
         return true;
      }

      if (Grammar .OpenBracket .parse (this))
      {
         this .nodeStatements (field);

         if (Grammar .CloseBracket .parse (this))
            return true;

         throw new Error ("Expected ']'.");
      }

      return false;
   },
   nodeStatements (field)
   {
      this .statements (field);

      // let node = this .nodeStatement ();

      // while (node !== false)
      // {
      //    field .push (node);

      //    node = this .nodeStatement ();
      // }
   },
   sfrotationValue (field)
   {
      if (this .double ())
      {
         const x = this .value;

         if (this .double ())
         {
            const y = this .value;

            if (this .double ())
            {
               const z = this .value;

               if (this .double ())
               {
                  const angle = this .value;

                  field .x     = x;
                  field .y     = y;
                  field .z     = z;
                  field .angle = this .fromUnit ("angle", angle);

                  return true;
               }
            }
         }
      }

      return false;
   },
   mfrotationValue (field)
   {
      field .length = 0;

      if (this .sfrotationValue (this .Rotation4))
      {
         field .push (this .Rotation4);
         return true;
      }

      if (Grammar .OpenBracket .parse (this))
      {
         this .sfrotationValues (field);

         if (Grammar .CloseBracket .parse (this))
            return true;

         throw new Error ("Expected ']'.");
      }

      return false;
   },
   sfrotationValues (field)
   {
      field .length = 0;

      const
         target = field .getTarget (),
         value  = this .Rotation4;

      while (this .sfrotationValue (value))
         target .push (value);

      return field .length !== 0;
   },
   sfstringValue (field)
   {
      if (this .string ())
      {
         field .setValue (this .value);
         return true;
      }

      return false;
   },
   mfstringValue (field)
   {
      field .length = 0;

      if (this .string ())
      {
         field .push (this .value);
         return true;
      }

      if (Grammar .OpenBracket .parse (this))
      {
         this .sfstringValues (field);

         if (Grammar .CloseBracket .parse (this))
            return true;

         throw new Error ("Expected ']'.");
      }

      return false;
   },
   sfstringValues (field)
   {
      const array = [ ];

      while (this .string ())
         array .push (this .value);

      field .setValue (array);

      return field .length !== 0;
   },
   sfvec2Value (field, unit)
   {
      if (this .double ())
      {
         const x = this .value;

         if (this .double ())
         {
            const y = this .value;

            field .x = this .fromUnit (unit, x);
            field .y = this .fromUnit (unit, y);

            return true;
         }
      }

      return false;
   },
   mfvec2Value (field)
   {
      field .length = 0;

      if (this .sfvec2Value (this .Vector2, field .getUnit ()))
      {
         field .push (this .Vector2);
         return true;
      }

      if (Grammar .OpenBracket .parse (this))
      {
         this .sfvecValues (field);

         if (Grammar .CloseBracket .parse (this))
            return true;

         throw new Error ("Expected ']'.");
      }

      return false;
   },
   sfvecValues (field)
   {
      const
         unit  = field .getUnit (),
         array = [ ];

      while (this .double ())
         array .push (this .fromUnit (unit, this .value));

      field .setValue (array);

      return field .length !== 0;
   },
   sfvec3Value (field, unit)
   {
      if (this .double ())
      {
         const x = this .value;

         if (this .double ())
         {
            const y = this .value;

            if (this .double ())
            {
               const z = this .value;

               field .x = this .fromUnit (unit, x);
               field .y = this .fromUnit (unit, y);
               field .z = this .fromUnit (unit, z);

               return true;
            }
         }
      }

      return false;
   },
   mfvec3Value (field)
   {
      field .length = 0;

      if (this .sfvec3Value (this .Vector3, field .getUnit ()))
      {
         field .push (this .Vector3);
         return true;
      }

      if (Grammar .OpenBracket .parse (this))
      {
         this .sfvecValues (field);

         if (Grammar .CloseBracket .parse (this))
            return true;

         throw new Error ("Expected ']'.");
      }

      return false;
   },
   sfvec4Value (field, unit)
   {
      if (this .double ())
      {
         const x = this .value;

         if (this .double ())
         {
            const y = this .value;

            if (this .double ())
            {
               const z = this .value;

               if (this .double ())
               {
                  const w = this .value;

                  field .x = this .fromUnit (unit, x);
                  field .y = this .fromUnit (unit, y);
                  field .z = this .fromUnit (unit, z);
                  field .w = this .fromUnit (unit, w);

                  return true;
               }
            }
         }
      }

      return false;
   },
   mfvec4Value (field)
   {
      field .length = 0;

      if (this .sfvec4Value (this .Vector4, field .getUnit ()))
      {
         field .push (this .Vector4);
         return true;
      }

      if (Grammar .OpenBracket .parse (this))
      {
         this .sfvecValues (field);

         if (Grammar .CloseBracket .parse (this))
            return true;

         throw new Error ("Expected ']'.");
      }

      return false;
   },
   unknownValue ()
   {
      try
      {
         ++ this .unknownLevel;

         if (Grammar .IS .parse (this))
         {
            if (this .isInsideProtoDeclaration ())
            {
               if (this .Id ())
                  return true;
            }
         }

         if (this .mfunknownValue ())
            return true;

         return false;
      }
      finally
      {
         -- this .unknownLevel;
      }
   },
   sfunknownValue ()
   {
      if (this .sfboolValue (new _Fields_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .SFBool ()))
         return true;

      if (this .sfdoubleValues (new _Fields_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .MFFloat ()))
         return true;

      if (this .sfstringValue (new _Fields_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .SFString ()))
         return true;

      if (this .sfnodeValue (new _Fields_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .SFNode ()))
         return true;

      return false;
   },
   mfunknownValue ()
   {
      if (this .sfunknownValue ())
         return true;

      if (Grammar .OpenBracket .parse (this))
      {
         this .sfunknownValues ();

         if (Grammar .CloseBracket .parse (this))
            return true;

         throw new Error ("Expected ']'.");
      }

      return false;
   },
   sfunknownValues ()
   {
      while (this .sfunknownValue ())
         ;
   },
   accessTypeToString (accessType)
   {
      switch (accessType)
      {
         case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .initializeOnly:
            return "initializeOnly";
         case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .inputOnly:
            return "inputOnly";
         case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .outputOnly:
            return "outputOnly";
         case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .inputOutput:
            return "inputOutput";
      }
   },
});

Object .assign (VRMLParser .prototype,
{
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .SFBool]:      VRMLParser .prototype .sfboolValue,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .SFColor]:     VRMLParser .prototype .sfcolorValue,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .SFColorRGBA]: VRMLParser .prototype .sfcolorrgbaValue,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .SFDouble]:    VRMLParser .prototype .sfdoubleValue,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .SFFloat]:     VRMLParser .prototype .sfdoubleValue,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .SFImage]:     VRMLParser .prototype .sfimageValue,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .SFInt32]:     VRMLParser .prototype .sfint32Value,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .SFMatrix3f]:  VRMLParser .prototype .sfmatrix3Value,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .SFMatrix3d]:  VRMLParser .prototype .sfmatrix3Value,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .SFMatrix4f]:  VRMLParser .prototype .sfmatrix4Value,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .SFMatrix4d]:  VRMLParser .prototype .sfmatrix4Value,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .SFNode]:      VRMLParser .prototype .sfnodeValue,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .SFRotation]:  VRMLParser .prototype .sfrotationValue,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .SFString]:    VRMLParser .prototype .sfstringValue,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .SFTime]:      VRMLParser .prototype .sfdoubleValue,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .SFVec2d]:     VRMLParser .prototype .sfvec2Value,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .SFVec2f]:     VRMLParser .prototype .sfvec2Value,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .SFVec3d]:     VRMLParser .prototype .sfvec3Value,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .SFVec3f]:     VRMLParser .prototype .sfvec3Value,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .SFVec4d]:     VRMLParser .prototype .sfvec4Value,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .SFVec4f]:     VRMLParser .prototype .sfvec4Value,

   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .VrmlMatrix]:  VRMLParser .prototype .sfmatrix4Value,

   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .MFBool]:      VRMLParser .prototype .mfboolValue,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .MFColor]:     VRMLParser .prototype .mfcolorValue,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .MFColorRGBA]: VRMLParser .prototype .mfcolorrgbaValue,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .MFDouble]:    VRMLParser .prototype .mfdoubleValue,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .MFFloat]:     VRMLParser .prototype .mfdoubleValue,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .MFImage]:     VRMLParser .prototype .mfimageValue,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .MFInt32]:     VRMLParser .prototype .mfint32Value,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .MFMatrix3d]:  VRMLParser .prototype .mfmatrix3Value,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .MFMatrix3f]:  VRMLParser .prototype .mfmatrix3Value,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .MFMatrix4d]:  VRMLParser .prototype .mfmatrix4Value,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .MFMatrix4f]:  VRMLParser .prototype .mfmatrix4Value,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .MFNode]:      VRMLParser .prototype .mfnodeValue,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .MFRotation]:  VRMLParser .prototype .mfrotationValue,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .MFString]:    VRMLParser .prototype .mfstringValue,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .MFTime]:      VRMLParser .prototype .mfdoubleValue,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .MFVec2d]:     VRMLParser .prototype .mfvec2Value,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .MFVec2f]:     VRMLParser .prototype .mfvec2Value,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .MFVec3d]:     VRMLParser .prototype .mfvec3Value,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .MFVec3f]:     VRMLParser .prototype .mfvec3Value,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .MFVec4d]:     VRMLParser .prototype .mfvec4Value,
   [_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .MFVec4f]:     VRMLParser .prototype .mfvec4Value,
});

_Base_X3DField_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .prototype .fromVRMLString = function (string, scene)
{
   const parser = new VRMLParser (scene);

   parser .setUnits (!!scene);
   parser .setInput (string);

   if (!parser .fieldValue (this))
      throw new Error (`Couldn't read value for field '${this .getName ()}'.`);

   parser .setupNodes ();
};

const __default__ = VRMLParser;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_18__/* ["default"] */ .A .add ("VRMLParser", __default__));

/***/ }),

/***/ 3909:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Base_X3DInfoArray_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(3020);
/* harmony import */ var _X3DRoute_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(4679);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(717);



function RouteArray (values = [ ])
{
   return _Base_X3DInfoArray_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .call (this, Array .from (values, value => [value .getId (), value]), _X3DRoute_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A);
}

Object .setPrototypeOf (RouteArray .prototype, _Base_X3DInfoArray_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .prototype);

for (const key of Object .keys (RouteArray .prototype))
   Object .defineProperty (RouteArray .prototype, key, { enumerable: false });

Object .defineProperties (RouteArray,
{
   typeName:
   {
      value: "RouteArray",
      enumerable: true,
   },
});

const __default__ = RouteArray;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .add ("RouteArray", __default__));

/***/ }),

/***/ 4045:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Fields_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(4598);
/* harmony import */ var _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(2040);
/* harmony import */ var _Base_FieldDefinitionArray_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(1870);
/* harmony import */ var _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(2340);
/* harmony import */ var _X3DInterpolatorNode_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(44);
/* harmony import */ var _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(2212);
/* harmony import */ var _standard_Math_Numbers_Rotation4_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(7078);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(717);








function OrientationInterpolator (executionContext)
{
   _X3DInterpolatorNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .call (this, executionContext);

   this .addType (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .OrientationInterpolator);

   // Units

   this ._keyValue      .setUnit ("angle");
   this ._value_changed .setUnit ("angle");
}

Object .assign (Object .setPrototypeOf (OrientationInterpolator .prototype, _X3DInterpolatorNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .prototype),
{
   initialize ()
   {
      _X3DInterpolatorNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .prototype .initialize .call (this);

      this ._keyValue .addInterest ("set_keyValue__", this);
   },
   set_keyValue__ ()
   {
      const
         key      = this ._key,
         keyValue = this ._keyValue;

      if (keyValue .length < key .length)
         keyValue .resize (key .length, keyValue .length ? keyValue [keyValue .length - 1] : new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFRotation ());

      // If there was already an set_fraction event in this frame, send a new value_changed to prevent glitches.
      if (this ._set_fraction .getModificationTime () >= this .getBrowser () .getCurrentTime ())
         this .set_fraction__ ();
   },
   interpolate: (() =>
   {
      const
         keyValue0 = new _standard_Math_Numbers_Rotation4_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A (),
         keyValue1 = new _standard_Math_Numbers_Rotation4_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A ();

      return function (index0, index1, weight)
      {
         // Both values can change in slerp.
         keyValue0 .assign (this ._keyValue [index0] .getValue ());
         keyValue1 .assign (this ._keyValue [index1] .getValue ());

         this ._value_changed = keyValue0 .slerp (keyValue1, weight);
      };
   })(),
});

Object .defineProperties (OrientationInterpolator,
{
   ... _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .getStaticProperties ("OrientationInterpolator", "Interpolation", 1, "children", "2.0"),
   fieldDefinitions:
   {
      value: new _Base_FieldDefinitionArray_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A ([
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .inputOutput, "metadata",      new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFNode ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .inputOnly,   "set_fraction",  new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFFloat ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .inputOutput, "key",           new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFFloat ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .inputOutput, "keyValue",      new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFRotation ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .outputOnly,  "value_changed", new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFRotation ()),
      ]),
      enumerable: true,
   },
});

const __default__ = OrientationInterpolator;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .add ("OrientationInterpolator", __default__));

/***/ }),

/***/ 4072:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _X3DObject_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(946);
/* harmony import */ var _IterableWeakSet_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(7016);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(717);



const
   _modificationTime = Symbol (),
   _tainted          = Symbol (),
   _parents          = Symbol (),
   _private          = Symbol ();

const EMPTY = [ ];

function X3DChildObject ()
{
   _X3DObject_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .call (this);
}

Object .assign (Object .setPrototypeOf (X3DChildObject .prototype, _X3DObject_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .prototype),
{
   [_modificationTime]: -1,
   [_tainted]: false,
   [_parents]: null,
   [_private]: false,
   isInitializable ()
   {
      return true;
   },
   isInput ()
   {
      return false;
   },
   isOutput ()
   {
      return false;
   },
   setModificationTime (value)
   {
      this [_modificationTime] = value;
   },
   getModificationTime ()
   {
      return this [_modificationTime];
   },
   setTainted (value)
   {
      this [_tainted] = value;
   },
   isTainted ()
   {
      return this [_tainted];
   },
   addEvent ()
   {
      for (const parent of this [_parents] ?? EMPTY)
         parent .addEvent (this);
   },
   addEventObject (field, event)
   {
      for (const parent of this [_parents] ?? EMPTY)
         parent .addEventObject (this, event);
   },
   processEvent ()
   {
      this .setTainted (false);
      this .processInterests ();
   },
   isPrivate ()
   {
      return this [_private];
   },
   setPrivate (value)
   {
      this [_private] = value;
   },
   collectCloneCount ()
   {
      let cloneCount = 0;

      for (const parent of this [_parents] ?? EMPTY)
      {
         if (parent [_private])
            continue;

         cloneCount += parent .collectCloneCount ();
      }

      return cloneCount;
   },
   addParent (parent)
   {
      this .getParents () .add (parent);

      this .parentsChanged ();
   },
   removeParent (parent)
   {
      this [_parents] ?.delete (parent);

      this .parentsChanged ();
   },
   getParents ()
   {
      return this [_parents] ??= new _IterableWeakSet_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A ();
   },
   parentsChanged ()
   { },
   dispose ()
   {
      this [_parents] ?.clear ();

      _X3DObject_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .prototype .dispose .call (this);
   },
});

for (const key of Object .keys (X3DChildObject .prototype))
   Object .defineProperty (X3DChildObject .prototype, key, { enumerable: false });

const __default__ = X3DChildObject;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .add ("X3DChildObject", __default__));

/***/ }),

/***/ 4218:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Fields_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(4598);
/* harmony import */ var _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(2040);
/* harmony import */ var _Base_FieldDefinitionArray_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(1870);
/* harmony import */ var _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(2340);
/* harmony import */ var _X3DTexture2DNode_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(810);
/* harmony import */ var _Networking_X3DUrlObject_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(639);
/* harmony import */ var _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(2212);
/* harmony import */ var _DEVELOPMENT_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(615);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(717);
/* provided dependency */ var $ = __webpack_require__(9547);









function ImageTexture (executionContext)
{
   _X3DTexture2DNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .call (this, executionContext);
   _Networking_X3DUrlObject_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A     .call (this, executionContext);

   this .addType (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .ImageTexture);

   this .image    = $("<img></img>");
   this .urlStack = new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFString ();

   this .getMatrix () .set ([1, 0, 0, 0, 0, -1, 0, 0, 0, 0, 1, 0, 0, 1, 0, 1]); // flipY
}

Object .assign (Object .setPrototypeOf (ImageTexture .prototype, _X3DTexture2DNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .prototype),
   _Networking_X3DUrlObject_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .prototype,
{
   initialize ()
   {
      _X3DTexture2DNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .prototype .initialize .call (this);
      _Networking_X3DUrlObject_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A     .prototype .initialize .call (this);

      this ._colorSpaceConversion .addInterest ("loadNow", this);

      this .image
         .on ("load", this .setImage .bind (this))
         .on ("abort error", this .setError .bind (this))
         .attr ("crossorigin", "anonymous");

      this .requestImmediateLoad () .catch (Function .prototype);
   },
   getTextureType ()
   {
      return 1;
   },
   unloadData ()
   {
      this .clearTexture ();
   },
   loadData ()
   {
      this .urlStack .setValue (this ._url);
      this .loadNext ();
   },
   loadNext ()
   {
      if (this .urlStack .length === 0)
      {
         this .clearTexture ();
         this .setLoadState (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .FAILED_STATE);
         return;
      }

      // Get URL.

      this .URL = new URL (this .urlStack .shift (), this .getExecutionContext () .getBaseURL ());

      if (this .URL .pathname .match (/\.ktx2?(?:\.gz)?$/) || this .URL .href .match (/^data:image\/ktx2[;,]/))
      {
         this .setLinear (true);
         this .setMipMaps (false);

         this .getBrowser () .getKTXDecoder ()
            .then (decoder => decoder .loadKTXFromURL (this .URL, this .getCache ()))
            .then (texture => this .setKTXTexture (texture))
            .catch (error => this .setError ({ type: error .message }));
      }
      else
      {
         this .setLinear (false);
         this .setMipMaps (true);

         if (this .URL .protocol !== "data:")
         {
            if (!this .getCache ())
               this .URL .searchParams .set ("_", Date .now ());
         }

         this .image .attr ("src", this .URL);
      }
   },
   setError (event)
   {
      if (this .URL .protocol !== "data:")
         console .warn (`Error loading image '${decodeURI (this .URL)}:'`, event .type);

      this .loadNext ();
   },
   setKTXTexture (texture)
   {
      if (texture .target !== this .getTarget ())
         return this .setError ({ type: "Invalid KTX texture target, must be 'TEXTURE_2D'." });

      if (_DEVELOPMENT_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A)
      {
         if (this .URL .protocol !== "data:")
            console .info (`Done loading image texture '${decodeURI (this .URL)}'.`);
      }

      try
      {
         this .setTexture (texture);
         this .setTransparent (false);
         this .setWidth (texture .baseWidth);
         this .setHeight (texture .baseHeight);
         this .updateTextureParameters ();

         this .setLoadState (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .COMPLETE_STATE);
      }
      catch (error)
      {
         // Catch security error from cross origin requests.
         this .setError ({ type: error .message });
      }
   },
   setImage ()
   {
      if (_DEVELOPMENT_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A)
      {
         if (this .URL .protocol !== "data:")
            console .info (`Done loading image texture '${decodeURI (this .URL)}'.`);
      }

      try
      {
         const
            image             = this .image [0],
            { width, height } = image;

         // Upload image to GPU.

         this .setTextureData (width, height, this ._colorSpaceConversion .getValue (), this .isTransparent (), image);
         this .setTransparent (this .isImageTransparent (this .getTextureData (this .getTexture (), width, height)));
         this .setLoadState (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .COMPLETE_STATE);
         this .addNodeEvent ();
      }
      catch (error)
      {
         // Catch security error from cross origin requests.
         this .setError ({ type: error .message });
      }
   },
   dispose ()
   {
      _Networking_X3DUrlObject_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A     .prototype .dispose .call (this);
      _X3DTexture2DNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .prototype .dispose .call (this);
   },
});

Object .defineProperties (ImageTexture,
{
   ... _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .getStaticProperties ("ImageTexture", "Texturing", 1, "texture", "2.0"),
   fieldDefinitions:
   {
      value: new _Base_FieldDefinitionArray_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A ([
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .inputOutput,    "metadata",             new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFNode ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .inputOutput,    "description",          new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFString ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .inputOutput,    "load",                 new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFBool (true)),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .inputOutput,    "url",                  new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFString ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .inputOutput,    "autoRefresh",          new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFTime (0)),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .inputOutput,    "autoRefreshTimeLimit", new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFTime (3600)),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .initializeOnly, "colorSpaceConversion", new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFBool (true)), // experimental
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .initializeOnly, "repeatS",              new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFBool (true)),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .initializeOnly, "repeatT",              new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFBool (true)),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .initializeOnly, "textureProperties",    new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFNode ()),
      ]),
      enumerable: true,
   },
});

const __default__ = ImageTexture;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_8__/* ["default"] */ .A .add ("ImageTexture", __default__));

/***/ }),

/***/ 4246:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Fields_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(4598);
/* harmony import */ var _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(2040);
/* harmony import */ var _Base_FieldDefinitionArray_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(1870);
/* harmony import */ var _Execution_X3DExecutionContext_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(7493);
/* harmony import */ var _X3DProtoDeclarationNode_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(3454);
/* harmony import */ var _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(2212);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(717);







const
   _body = Symbol ();

function X3DProtoDeclaration (executionContext)
{
   _X3DProtoDeclarationNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .call (this, executionContext);

   this .addType (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .X3DProtoDeclaration)

   this [_body] = new _Execution_X3DExecutionContext_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A (executionContext, this);
   this [_body] .setLive (false);
   this .setLive (false);
}

Object .assign (Object .setPrototypeOf (X3DProtoDeclaration .prototype, _X3DProtoDeclarationNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .prototype),
{
   initialize ()
   {
      _X3DProtoDeclarationNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .prototype .initialize .call (this);

      this [_body] .setup ();
   },
   getProtoDeclaration ()
   {
      return this;
   },
   getBody ()
   {
      return this [_body];
   },
   getCloneCount ()
   {
      return _X3DProtoDeclarationNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .prototype .collectCloneCount .call (this);
   },
   collectCloneCount ()
   {
      return 1;
   },
   toVRMLStream (generator)
   {
      generator .string += generator .Indent ();
      generator .string += "PROTO";
      generator .string += generator .Space ();
      generator .string += this .getName ();
      generator .string += generator .TidySpace ();
      generator .string += "[";

      generator .EnterScope ();

      const userDefinedFields = this .getUserDefinedFields ();

      if (userDefinedFields .length === 0)
      {
         generator .string += generator .TidySpace ();
      }
      else
      {
         let
            fieldTypeLength  = 0,
            accessTypeLength = 0;

         for (const field of userDefinedFields)
         {
            fieldTypeLength  = Math .max (fieldTypeLength, field .getTypeName () .length);
            accessTypeLength = Math .max (accessTypeLength, generator .AccessType (field .getAccessType ()) .length);
         }

         generator .string += generator .TidyBreak ();

         generator .IncIndent ();

         const last = userDefinedFields .at (-1);

         for (const field of userDefinedFields)
         {
            this .toVRMLStreamUserDefinedField (generator, field, fieldTypeLength, accessTypeLength);

            if (field === last)
               generator .string += generator .TidyBreak ();
            else
               generator .string += generator .Break ();
         }

         generator .DecIndent ();

         generator .string += generator .Indent ();
      }

      generator .LeaveScope ();

      generator .string += "]";
      generator .string += generator .TidyBreak ();

      generator .string += generator .Indent ();
      generator .string += "{";
      generator .string += generator .TidyBreak ();

      generator .IncIndent ();

      this [_body] .toVRMLStream (generator);

      generator .DecIndent ();

      generator .string += generator .Indent ();
      generator .string += "}";
   },
   toVRMLStreamUserDefinedField (generator, field, fieldTypeLength, accessTypeLength)
   {
      generator .string += generator .Indent ();
      generator .string += generator .AccessType (field .getAccessType ()) .padEnd (accessTypeLength, generator .TidySpace ());
      generator .string += generator .Space ();
      generator .string += field .getTypeName () .padEnd (fieldTypeLength, generator .TidySpace ());
      generator .string += generator .Space ();
      generator .string += field .getName ();

      if (!field .isInitializable ())
         return;

      generator .string += generator .Space ();

      field .toVRMLStream (generator);
   },
   toXMLStream (generator)
   {
      generator .openTag ("ProtoDeclare");
      generator .attribute ("name", this .getName ());

      if (this .getAppInfo ())
         generator .attribute ("appinfo", this .getAppInfo ());

      if (this .getDocumentation ())
         generator .attribute ("documentation", this .getDocumentation ());

      generator .endTag ();

      // <ProtoInterface>

      generator .EnterScope ();

      const userDefinedFields = this .getUserDefinedFields ();

      if (userDefinedFields .length !== 0)
      {
         generator .IncIndent ();
         generator .openingTag ("ProtoInterface");
         generator .AddTidyBreak ();
         generator .IncIndent ();

         for (const field of userDefinedFields)
         {
            generator .openTag ("field");
            generator .attribute ("accessType", generator .AccessType (field .getAccessType ()));
            generator .attribute ("type",       field .getTypeName ());
            generator .attribute ("name",       field .getName ());

            if (field .isDefaultValue () || !field .isInitializable ())
            {
               if (field .getAppInfo ())
                  generator .attribute ("appinfo", field .getAppInfo ());

               if (field .getDocumentation ())
                  generator .attribute ("documentation", field .getDocumentation ());

               generator .closeTag ("field");
               generator .AddTidyBreak ();
            }
            else
            {
               switch (field .getType ())
               {
                  case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .SFNode:
                  case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .MFNode:
                  {
                     if (field .getAppInfo ())
                        generator .attribute ("appinfo", field .getAppInfo ());

                     if (field .getDocumentation ())
                        generator .attribute ("documentation", field .getDocumentation ());

                     generator .endTag ();
                     generator .IncIndent ();
                     generator .PushContainerField (null);

                     field .toXMLStream (generator);

                     generator .AddTidyBreak ();
                     generator .DecIndent ();
                     generator .closingTag ("field");
                     generator .AddTidyBreak ();
                     generator .PopContainerField ();
                     break;
                  }
                  default:
                  {
                     generator .string += generator .Space ();
                     generator .string += "value='";

                     field .toXMLStream (generator);

                     generator .string += "'";

                     if (field .getAppInfo ())
                        generator .attribute ("appinfo", field .getAppInfo ());

                     if (field .getDocumentation ())
                        generator .attribute ("documentation", field .getDocumentation ());

                     generator .closeTag ("field");
                     generator .AddTidyBreak ();
                     break;
                  }
               }
            }
         }

         generator .DecIndent ();
         generator .closingTag ("ProtoInterface");
         generator .AddTidyBreak ();
         generator .DecIndent ();
      }

      generator .LeaveScope ();

      // </ProtoInterface>

      // <ProtoBody>

      generator .IncIndent ();
      generator .openingTag ("ProtoBody");
      generator .AddTidyBreak ();
      generator .IncIndent ();

      this [_body] .toXMLStream (generator);

      generator .DecIndent ();
      generator .closingTag ("ProtoBody");
      generator .AddTidyBreak ();
      generator .DecIndent ();

      // </ProtoBody>

      generator .closingTag ("ProtoDeclare");
   },
   toJSONStream (generator)
   {
      generator .string += generator .TidyBreak ();
      generator .string += generator .Indent ();

      generator .beginObject ("ProtoDeclare", false, true);
      generator .stringProperty ("@name", this .getName (), false);

      if (this .getAppInfo ())
         generator .stringProperty ("@appinfo", this .getAppInfo ());

      if (this .getDocumentation ())
         generator .stringProperty ("@documentation", this .getDocumentation ());

      // Fields

      generator .EnterScope ();
      generator .beginObject ("ProtoInterface");

      const userDefinedFields = this .getUserDefinedFields ();

      if (userDefinedFields .length)
      {
         generator .beginArray ("field", false);

         for (const field of userDefinedFields)
         {
            generator .beginObject ("", field !== userDefinedFields [0]);
            generator .stringProperty ("@accessType", generator .AccessType (field .getAccessType ()), false);
            generator .stringProperty ("@type",       field .getTypeName ());
            generator .stringProperty ("@name",       field .getName ());

            if (!field .isDefaultValue () && field .isInitializable ())
            {
               // Output value

               switch (field .getType ())
               {
                  case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .SFNode:
                  {
                     generator .beginArray ("-children");

                     generator .string += generator .TidyBreak ();
                     generator .string += generator .Indent ();

                     field .toJSONStream (generator);

                     generator .endArray ();
                     break;
                  }
                  case _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .MFNode:
                  {
                     generator .beginValue ("-children", true);

                     field .toJSONStream (generator);
                     break;
                  }
                  default:
                  {
                     generator .beginValue ("@value", true);

                     field .toJSONStream (generator);
                     break;
                  }
               }
            }

            if (field .getAppInfo ())
               generator .stringProperty ("@appinfo", field .getAppInfo ());

            if (field .getDocumentation ())
               generator .stringProperty ("@documentation", field .getDocumentation ());

            generator .endObject ();
         }

         generator .endArray ();
      }

      generator .endObject ();
      generator .LeaveScope ();

      // ProtoBody

      generator .beginObject ("ProtoBody");
      generator .beginArray ("-children", false);

      this [_body] .toJSONStream (generator);

      generator .endArray ();
      generator .endObject ();

      // End

      generator .endObject ();
      generator .endObject ();
   },
});

for (const key of Object .keys (X3DProtoDeclaration .prototype))
   Object .defineProperty (X3DProtoDeclaration .prototype, key, { enumerable: false });

Object .defineProperties (X3DProtoDeclaration .prototype,
{
   isExternProto:
   {
      value: false,
      enumerable: true,
   },
});

Object .defineProperties (X3DProtoDeclaration,
{
   typeName:
   {
      value: "X3DProtoDeclaration",
      enumerable: true,
   },
   fieldDefinitions:
   {
      value: new _Base_FieldDefinitionArray_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A ([
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .inputOutput, "metadata", new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFNode ()),
      ]),
      enumerable: true,
   },
});

_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .addConstant (X3DProtoDeclaration .typeName);

const __default__ = X3DProtoDeclaration;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .add ("X3DProtoDeclaration", __default__));

/***/ }),

/***/ 4477:
/***/ (function(module, exports) {

var __WEBPACK_AMD_DEFINE_FACTORY__, __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;/*
	SuperGif

	Example usage:

		<img src="./example1_preview.gif" rel:animated_src="./example1.gif" width="360" height="360" rel:auto_play="1" />

		<script type="text/javascript">
			$$('img').each(function (img_tag) {
				if (/.*\.gif/.test(img_tag.src)) {
					var rub = new SuperGif({ gif: img_tag } );
					rub.load();
				}
			});
		</script>

	Image tag attributes:

		rel:animated_src -	If this url is specified, it's loaded into the player instead of src.
							This allows a preview frame to be shown until animated gif data is streamed into the canvas

		rel:auto_play -		Defaults to 1 if not specified. If set to zero, a call to the play() method is needed

	Constructor options args

		gif 				Required. The DOM element of an img tag.
		loop_mode			Optional. Setting this to false will force disable looping of the gif.
		auto_play 			Optional. Same as the rel:auto_play attribute above, this arg overrides the img tag info.
		max_width			Optional. Scale images over max_width down to max_width. Helpful with mobile.
 		on_end				Optional. Add a callback for when the gif reaches the end of a single loop (one iteration). The first argument passed will be the gif HTMLElement.
		loop_delay			Optional. The amount of time to pause (in ms) after each single loop (iteration).
		draw_while_loading	Optional. Determines whether the gif will be drawn to the canvas whilst it is loaded.
		show_progress_bar	Optional. Only applies when draw_while_loading is set to true.
        on_error            Optional. Add a callback for when a load error occurs.

	Instance methods

		// loading
		load( callback )		Loads the gif specified by the src or rel:animated_src sttributie of the img tag into a canvas element and then calls callback if one is passed
		load_url( src, callback )	Loads the gif file specified in the src argument into a canvas element and then calls callback if one is passed

		// play controls
		play -				Start playing the gif
		pause -				Stop playing the gif
		move_to(i) -		Move to frame i of the gif
		move_relative(i) -	Move i frames ahead (or behind if i < 0)

		// getters
		get_canvas			The canvas element that the gif is playing in. Handy for assigning event handlers to.
		get_playing			Whether or not the gif is currently playing
		get_loading			Whether or not the gif has finished loading/parsing
		get_auto_play		Whether or not the gif is set to play automatically
		get_length			The number of frames in the gif
		get_current_frame	The index of the currently displayed frame of the gif
		get_frames	        An array containing the data for all parsed frames
		get_duration	    Returns the duration of the gif in hundredths of a second (standard for GIF spec)
		get_duration_ms	    Returns the duration of the gif in milliseconds

		For additional customization (viewport inside iframe) these params may be passed:
		c_w, c_h - width and height of canvas
		vp_t, vp_l, vp_ w, vp_h - top, left, width and height of the viewport

		A bonus: few articles to understand what is going on
			http://enthusiasms.org/post/16976438906
			http://www.matthewflickinger.com/lab/whatsinagif/bits_and_bytes.asp
			http://humpy77.deviantart.com/journal/Frame-Delay-Times-for-Animated-GIFs-214150546

*/
(function (root, factory) {
    if (true) {
        !(__WEBPACK_AMD_DEFINE_ARRAY__ = [], __WEBPACK_AMD_DEFINE_FACTORY__ = (factory),
		__WEBPACK_AMD_DEFINE_RESULT__ = (typeof __WEBPACK_AMD_DEFINE_FACTORY__ === 'function' ?
		(__WEBPACK_AMD_DEFINE_FACTORY__.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__)) : __WEBPACK_AMD_DEFINE_FACTORY__),
		__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
    } else // removed by dead control flow
{}
}(this, function () {
    // Generic functions
    var bitsToNum = function (ba) {
        return ba.reduce(function (s, n) {
            return s * 2 + n;
        }, 0);
    };

    var byteToBitArr = function (bite) {
        var a = [];
        for (var i = 7; i >= 0; i--) {
            a.push( !! (bite & (1 << i)));
        }
        return a;
    };

    // Stream
    /**
     * @constructor
     */
    // Make compiler happy.
    var Stream = function (data) {
        this.data = data;
        this.len = this.data.length;
        this.pos = 0;

        this.readByte = function () {
            if (this.pos >= this.data.length) {
                throw new Error('Attempted to read past end of stream.');
            }
            if (data instanceof Uint8Array)
                return data[this.pos++];
            else
                return data.charCodeAt(this.pos++) & 0xFF;
        };

        this.readBytes = function (n) {
            var bytes = [];
            for (var i = 0; i < n; i++) {
                bytes.push(this.readByte());
            }
            return bytes;
        };

        this.read = function (n) {
            var s = '';
            for (var i = 0; i < n; i++) {
                s += String.fromCharCode(this.readByte());
            }
            return s;
        };

        this.readUnsigned = function () { // Little-endian.
            var a = this.readBytes(2);
            return (a[1] << 8) + a[0];
        };
    };

    var lzwDecode = function (minCodeSize, data) {
        // TODO: Now that the GIF parser is a bit different, maybe this should get an array of bytes instead of a String?
        var pos = 0; // Maybe this streaming thing should be merged with the Stream?
        var readCode = function (size) {
            var code = 0;
            for (var i = 0; i < size; i++) {
                if (data.charCodeAt(pos >> 3) & (1 << (pos & 7))) {
                    code |= 1 << i;
                }
                pos++;
            }
            return code;
        };

        var output = [];

        var clearCode = 1 << minCodeSize;
        var eoiCode = clearCode + 1;

        var codeSize = minCodeSize + 1;

        var dict = [];

        var clear = function () {
            dict = [];
            codeSize = minCodeSize + 1;
            for (var i = 0; i < clearCode; i++) {
                dict[i] = [i];
            }
            dict[clearCode] = [];
            dict[eoiCode] = null;

        };

        var code;
        var last;

        while (true) {
            last = code;
            code = readCode(codeSize);

            if (code === clearCode) {
                clear();
                continue;
            }
            if (code === eoiCode) break;

            if (code < dict.length) {
                if (last !== clearCode) {
                    dict.push(dict[last].concat(dict[code][0]));
                }
            }
            else {
                if (code !== dict.length) throw new Error('Invalid LZW code.');
                dict.push(dict[last].concat(dict[last][0]));
            }
            output.push.apply(output, dict[code]);

            if (dict.length === (1 << codeSize) && codeSize < 12) {
                // If we're at the last code and codeSize is 12, the next code will be a clearCode, and it'll be 12 bits long.
                codeSize++;
            }
        }

        // I don't know if this is technically an error, but some GIFs do it.
        //if (Math.ceil(pos / 8) !== data.length) throw new Error('Extraneous LZW bytes.');
        return output;
    };


    // The actual parsing; returns an object with properties.
    var parseGIF = function (st, handler) {
        handler || (handler = {});

        // LZW (GIF-specific)
        var parseCT = function (entries) { // Each entry is 3 bytes, for RGB.
            var ct = [];
            for (var i = 0; i < entries; i++) {
                ct.push(st.readBytes(3));
            }
            return ct;
        };

        var readSubBlocks = function () {
            var size, data;
            data = '';
            do {
                size = st.readByte();
                data += st.read(size);
            } while (size !== 0);
            return data;
        };

        var parseHeader = function () {
            var hdr = {};
            hdr.sig = st.read(3);
            hdr.ver = st.read(3);
            if (hdr.sig !== 'GIF') throw new Error('Not a GIF file.'); // XXX: This should probably be handled more nicely.
            hdr.width = st.readUnsigned();
            hdr.height = st.readUnsigned();

            var bits = byteToBitArr(st.readByte());
            hdr.gctFlag = bits.shift();
            hdr.colorRes = bitsToNum(bits.splice(0, 3));
            hdr.sorted = bits.shift();
            hdr.gctSize = bitsToNum(bits.splice(0, 3));

            hdr.bgColor = st.readByte();
            hdr.pixelAspectRatio = st.readByte(); // if not 0, aspectRatio = (pixelAspectRatio + 15) / 64
            if (hdr.gctFlag) {
                hdr.gct = parseCT(1 << (hdr.gctSize + 1));
            }
            handler.hdr && handler.hdr(hdr);
        };

        var parseExt = function (block) {
            var parseGCExt = function (block) {
                var blockSize = st.readByte(); // Always 4
                var bits = byteToBitArr(st.readByte());
                block.reserved = bits.splice(0, 3); // Reserved; should be 000.
                block.disposalMethod = bitsToNum(bits.splice(0, 3));
                block.userInput = bits.shift();
                block.transparencyGiven = bits.shift();

                block.delayTime = st.readUnsigned();

                block.transparencyIndex = st.readByte();

                block.terminator = st.readByte();

                handler.gce && handler.gce(block);
            };

            var parseComExt = function (block) {
                block.comment = readSubBlocks();
                handler.com && handler.com(block);
            };

            var parsePTExt = function (block) {
                // No one *ever* uses this. If you use it, deal with parsing it yourself.
                var blockSize = st.readByte(); // Always 12
                block.ptHeader = st.readBytes(12);
                block.ptData = readSubBlocks();
                handler.pte && handler.pte(block);
            };

            var parseAppExt = function (block) {
                var parseNetscapeExt = function (block) {
                    var blockSize = st.readByte(); // Always 3
                    block.unknown = st.readByte(); // ??? Always 1? What is this?
                    block.iterations = st.readUnsigned();
                    block.terminator = st.readByte();
                    handler.app && handler.app.NETSCAPE && handler.app.NETSCAPE(block);
                };

                var parseUnknownAppExt = function (block) {
                    block.appData = readSubBlocks();
                    // FIXME: This won't work if a handler wants to match on any identifier.
                    handler.app && handler.app[block.identifier] && handler.app[block.identifier](block);
                };

                var blockSize = st.readByte(); // Always 11
                block.identifier = st.read(8);
                block.authCode = st.read(3);
                switch (block.identifier) {
                    case 'NETSCAPE':
                        parseNetscapeExt(block);
                        break;
                    default:
                        parseUnknownAppExt(block);
                        break;
                }
            };

            var parseUnknownExt = function (block) {
                block.data = readSubBlocks();
                handler.unknown && handler.unknown(block);
            };

            block.label = st.readByte();
            switch (block.label) {
                case 0xF9:
                    block.extType = 'gce';
                    parseGCExt(block);
                    break;
                case 0xFE:
                    block.extType = 'com';
                    parseComExt(block);
                    break;
                case 0x01:
                    block.extType = 'pte';
                    parsePTExt(block);
                    break;
                case 0xFF:
                    block.extType = 'app';
                    parseAppExt(block);
                    break;
                default:
                    block.extType = 'unknown';
                    parseUnknownExt(block);
                    break;
            }
        };

        var parseImg = function (img) {
            var deinterlace = function (pixels, width) {
                // Of course this defeats the purpose of interlacing. And it's *probably*
                // the least efficient way it's ever been implemented. But nevertheless...
                var newPixels = new Array(pixels.length);
                var rows = pixels.length / width;
                var cpRow = function (toRow, fromRow) {
                    var fromPixels = pixels.slice(fromRow * width, (fromRow + 1) * width);
                    newPixels.splice.apply(newPixels, [toRow * width, width].concat(fromPixels));
                };

                // See appendix E.
                var offsets = [0, 4, 2, 1];
                var steps = [8, 8, 4, 2];

                var fromRow = 0;
                for (var pass = 0; pass < 4; pass++) {
                    for (var toRow = offsets[pass]; toRow < rows; toRow += steps[pass]) {
                        cpRow(toRow, fromRow)
                        fromRow++;
                    }
                }

                return newPixels;
            };

            img.leftPos = st.readUnsigned();
            img.topPos = st.readUnsigned();
            img.width = st.readUnsigned();
            img.height = st.readUnsigned();

            var bits = byteToBitArr(st.readByte());
            img.lctFlag = bits.shift();
            img.interlaced = bits.shift();
            img.sorted = bits.shift();
            img.reserved = bits.splice(0, 2);
            img.lctSize = bitsToNum(bits.splice(0, 3));

            if (img.lctFlag) {
                img.lct = parseCT(1 << (img.lctSize + 1));
            }

            img.lzwMinCodeSize = st.readByte();

            var lzwData = readSubBlocks();

            img.pixels = lzwDecode(img.lzwMinCodeSize, lzwData);

            if (img.interlaced) { // Move
                img.pixels = deinterlace(img.pixels, img.width);
            }

            handler.img && handler.img(img);
        };

        var parseBlock = function () {
            var block = {};
            block.sentinel = st.readByte();

            switch (String.fromCharCode(block.sentinel)) { // For ease of matching
                case '!':
                    block.type = 'ext';
                    parseExt(block);
                    break;
                case ',':
                    block.type = 'img';
                    parseImg(block);
                    break;
                case ';':
                    block.type = 'eof';
                    handler.eof && handler.eof(block);
                    break;
                default:
                    throw new Error('Unknown block: 0x' + block.sentinel.toString(16)); // TODO: Pad this with a 0.
            }

            if (block.type !== 'eof') setTimeout(parseBlock, 0);
        };

        var parse = function () {
            parseHeader();
            setTimeout(parseBlock, 0);
        };

        parse();
    };

    var SuperGif = function ( opts ) {
        var options = {
            //viewport position
            vp_l: 0,
            vp_t: 0,
            vp_w: null,
            vp_h: null,
            //canvas sizes
            c_w: null,
            c_h: null
        };
        for (var i in opts ) { options[i] = opts[i] }
        if (options.vp_w && options.vp_h) options.is_vp = true;

        var stream;
        var hdr;

        var loadError = null;
        var loading = false;

        var transparency = null;
        var delay = null;
        var disposalMethod = null;
        var disposalRestoreFromIdx = null;
        var lastDisposalMethod = null;
        var frame = null;
        var lastImg = null;

        var playing = true;
        var forward = true;

        var ctx_scaled = false;

        var frames = [];
        var frameOffsets = []; // elements have .x and .y properties

        var gif = options.gif;
        if (typeof options.auto_play == 'undefined')
            options.auto_play = (!gif.getAttribute('rel:auto_play') || gif.getAttribute('rel:auto_play') == '1');

        var onEndListener = (options.hasOwnProperty('on_end') ? options.on_end : null);
        var onErrorListener = (options.hasOwnProperty('on_error') ? options.on_error : null);
        var loopDelay = (options.hasOwnProperty('loop_delay') ? options.loop_delay : 0);
        var overrideLoopMode = (options.hasOwnProperty('loop_mode') ? options.loop_mode : 'auto');
        var drawWhileLoading = (options.hasOwnProperty('draw_while_loading') ? options.draw_while_loading : true);
        var showProgressBar = drawWhileLoading ? (options.hasOwnProperty('show_progress_bar') ? options.show_progress_bar : true) : false;
        var progressBarHeight = (options.hasOwnProperty('progressbar_height') ? options.progressbar_height : 25);
        var progressBarBackgroundColor = (options.hasOwnProperty('progressbar_background_color') ? options.progressbar_background_color : 'rgba(255,255,255,0.4)');
        var progressBarForegroundColor = (options.hasOwnProperty('progressbar_foreground_color') ? options.progressbar_foreground_color : 'rgba(255,0,22,.8)');

        var clear = function () {
            transparency = null;
            delay = null;
            lastDisposalMethod = disposalMethod;
            disposalMethod = null;
            frame = null;
        };

        // XXX: There's probably a better way to handle catching exceptions when
        // callbacks are involved.
        var doParse = function () {
            try {
                parseGIF(stream, handler);
            }
            catch (err) {
                doLoadError('parse');
            }
        };

        var doText = function (text) {
            toolbar.innerHTML = text; // innerText? Escaping? Whatever.
            toolbar.style.visibility = 'visible';
        };

        var setSizes = function(w, h) {
            canvas.width = w * get_canvas_scale();
            canvas.height = h * get_canvas_scale();
            toolbar.style.minWidth = ( w * get_canvas_scale() ) + 'px';

            tmpCanvas.width = w;
            tmpCanvas.height = h;
            tmpCanvas.style.width = w + 'px';
            tmpCanvas.style.height = h + 'px';
            tmpCanvas.getContext('2d', { willReadFrequently: true }).setTransform(1, 0, 0, 1, 0, 0);
        };

        var setFrameOffset = function(frame, offset) {
            if (!frameOffsets[frame]) {
                frameOffsets[frame] = offset;
                return;
            }
            if (typeof offset.x !== 'undefined') {
                frameOffsets[frame].x = offset.x;
            }
            if (typeof offset.y !== 'undefined') {
                frameOffsets[frame].y = offset.y;
            }
        };

        var doShowProgress = function (pos, length, draw) {
            if (draw && showProgressBar) {
                var height = progressBarHeight;
                var left, mid, top, width;
                if (options.is_vp) {
                    if (!ctx_scaled) {
                        top = (options.vp_t + options.vp_h - height);
                        height = height;
                        left = options.vp_l;
                        mid = left + (pos / length) * options.vp_w;
                        width = canvas.width;
                    } else {
                        top = (options.vp_t + options.vp_h - height) / get_canvas_scale();
                        height = height / get_canvas_scale();
                        left = (options.vp_l / get_canvas_scale() );
                        mid = left + (pos / length) * (options.vp_w / get_canvas_scale());
                        width = canvas.width / get_canvas_scale();
                    }
                    //some debugging, draw rect around viewport
                    if (false) // removed by dead control flow
{ var w, h, l, t; }
                }
                else {
                    top = (canvas.height - height) / (ctx_scaled ? get_canvas_scale() : 1);
                    mid = ((pos / length) * canvas.width) / (ctx_scaled ? get_canvas_scale() : 1);
                    width = canvas.width / (ctx_scaled ? get_canvas_scale() : 1 );
                    height /= ctx_scaled ? get_canvas_scale() : 1;
                }

                ctx.fillStyle = progressBarBackgroundColor;
                ctx.fillRect(mid, top, width - mid, height);

                ctx.fillStyle = progressBarForegroundColor;
                ctx.fillRect(0, top, mid, height);
            }
        };

        var doLoadError = function (originOfError) {
            var drawError = function () {
                ctx.fillStyle = 'black';
                ctx.fillRect(0, 0, options.c_w ? options.c_w : hdr.width, options.c_h ? options.c_h : hdr.height);
                ctx.strokeStyle = 'red';
                ctx.lineWidth = 3;
                ctx.moveTo(0, 0);
                ctx.lineTo(options.c_w ? options.c_w : hdr.width, options.c_h ? options.c_h : hdr.height);
                ctx.moveTo(0, options.c_h ? options.c_h : hdr.height);
                ctx.lineTo(options.c_w ? options.c_w : hdr.width, 0);
                ctx.stroke();
            };

            loadError = originOfError;
            hdr = {
                width: gif.width,
                height: gif.height
            }; // Fake header.
            frames = [];
            drawError();

            if (originOfError)
                onErrorListener ?.(originOfError);
        };

        var doHdr = function (_hdr) {
            hdr = _hdr;
            setSizes(hdr.width, hdr.height)
        };

        var doGCE = function (gce) {
            pushFrame();
            clear();
            transparency = gce.transparencyGiven ? gce.transparencyIndex : null;
            delay = gce.delayTime;
            disposalMethod = gce.disposalMethod;
            // We don't have much to do with the rest of GCE.
        };

        var pushFrame = function () {
            if (!frame) return;
            frames.push({
                            data: frame.getImageData(0, 0, hdr.width, hdr.height),
                            delay: delay
                        });
            frameOffsets.push({ x: 0, y: 0 });
        };

        var doImg = function (img) {
            if (!frame) frame = tmpCanvas.getContext('2d', { willReadFrequently: true });

            var currIdx = frames.length;

            //ct = color table, gct = global color table
            var ct = img.lctFlag ? img.lct : hdr.gct; // TODO: What if neither exists?

            /*
            Disposal method indicates the way in which the graphic is to
            be treated after being displayed.

            Values :    0 - No disposal specified. The decoder is
                            not required to take any action.
                        1 - Do not dispose. The graphic is to be left
                            in place.
                        2 - Restore to background color. The area used by the
                            graphic must be restored to the background color.
                        3 - Restore to previous. The decoder is required to
                            restore the area overwritten by the graphic with
                            what was there prior to rendering the graphic.

                            Importantly, "previous" means the frame state
                            after the last disposal of method 0, 1, or 2.
            */
            if (currIdx > 0) {
                if (lastDisposalMethod === 3) {
                    // Restore to previous
                    // If we disposed every frame including first frame up to this point, then we have
                    // no composited frame to restore to. In this case, restore to background instead.
                    if (disposalRestoreFromIdx !== null) {
                    	frame.putImageData(frames[disposalRestoreFromIdx].data, 0, 0);
                    } else {
                    	frame.clearRect(lastImg.leftPos, lastImg.topPos, lastImg.width, lastImg.height);
                    }
                } else {
                    disposalRestoreFromIdx = currIdx - 1;
                }

                if (lastDisposalMethod === 2) {
                    // Restore to background color
                    // Browser implementations historically restore to transparent; we do the same.
                    // http://www.wizards-toolkit.org/discourse-server/viewtopic.php?f=1&t=21172#p86079
                    frame.clearRect(lastImg.leftPos, lastImg.topPos, lastImg.width, lastImg.height);
                }
            }
            // else, Undefined/Do not dispose.
            // frame contains final pixel data from the last frame; do nothing

            //Get existing pixels for img region after applying disposal method
            var imgData = frame.getImageData(img.leftPos, img.topPos, img.width, img.height);

            //apply color table colors
            img.pixels.forEach(function (pixel, i) {
                // imgData.data === [R,G,B,A,R,G,B,A,...]
                if (pixel !== transparency) {
                    imgData.data[i * 4 + 0] = ct[pixel][0];
                    imgData.data[i * 4 + 1] = ct[pixel][1];
                    imgData.data[i * 4 + 2] = ct[pixel][2];
                    imgData.data[i * 4 + 3] = 255; // Opaque.
                }
            });

            frame.putImageData(imgData, img.leftPos, img.topPos);

            if (!ctx_scaled) {
                ctx.scale(get_canvas_scale(),get_canvas_scale());
                ctx_scaled = true;
            }

            // We could use the on-page canvas directly, except that we draw a progress
            // bar for each image chunk (not just the final image).
            if (drawWhileLoading) {
                ctx.drawImage(tmpCanvas, 0, 0);
                drawWhileLoading = options.auto_play;
            }

            lastImg = img;
        };

        var player = (function () {
            var i = -1;
            var iterationCount = 0;

            var showingInfo = false;
            var pinned = false;

            /**
             * Gets the index of the frame "up next".
             * @returns {number}
             */
            var getNextFrameNo = function () {
                var delta = (forward ? 1 : -1);
                return (i + delta + frames.length) % frames.length;
            };

            var stepFrame = function (amount) { // XXX: Name is confusing.
                i = i + amount;

                putFrame();
            };

            var step = (function () {
                var stepping = false;

                var completeLoop = function () {
                    if (onEndListener !== null)
                        onEndListener(gif);
                    iterationCount++;

                    if (overrideLoopMode !== false || iterationCount < 0) {
                        doStep();
                    } else {
                        stepping = false;
                        playing = false;
                    }
                };

                var doStep = function () {
                    stepping = playing;
                    if (!stepping) return;

                    stepFrame(1);
                    var delay = frames[i].delay * 10;
                    if (!delay) delay = 100; // FIXME: Should this even default at all? What should it be?

                    var nextFrameNo = getNextFrameNo();
                    if (nextFrameNo === 0) {
                        delay += loopDelay;
                        setTimeout(completeLoop, delay);
                    } else {
                        setTimeout(doStep, delay);
                    }
                };

                return function () {
                    if (!stepping) setTimeout(doStep, 0);
                };
            }());

            var putFrame = function () {
                var offset;
                i = parseInt(i, 10);

                if (i > frames.length - 1){
                    i = 0;
                }

                if (i < 0){
                    i = 0;
                }

                offset = frameOffsets[i];

                tmpCanvas.getContext("2d", { willReadFrequently: true }).putImageData(frames[i].data, offset.x, offset.y);
                ctx.globalCompositeOperation = "copy";
                ctx.drawImage(tmpCanvas, 0, 0);
            };

            var play = function () {
                playing = true;
                step();
            };

            var pause = function () {
                playing = false;
            };


            return {
                init: function () {
                    if (loadError) return;

                    if ( ! (options.c_w && options.c_h) ) {
                        ctx.scale(get_canvas_scale(),get_canvas_scale());
                    }

                    if (options.auto_play) {
                        step();
                    }
                    else {
                        i = 0;
                        putFrame();
                    }
                },
                step: step,
                play: play,
                pause: pause,
                playing: playing,
                move_relative: stepFrame,
                current_frame: function() { return i; },
                length: function() { return frames.length },
                move_to: function ( frame_idx ) {
                    i = frame_idx;
                    putFrame();
                }
            }
        }());

        var doDecodeProgress = function (draw) {
            doShowProgress(stream.pos, stream.data.length, draw);
        };

        var doNothing = function () {};
        /**
         * @param{boolean=} draw Whether to draw progress bar or not; this is not idempotent because of translucency.
         *                       Note that this means that the text will be unsynchronized with the progress bar on non-frames;
         *                       but those are typically so small (GCE etc.) that it doesn't really matter. TODO: Do this properly.
         */
        var withProgress = function (fn, draw) {
            return function (block) {
                fn(block);
                doDecodeProgress(draw);
            };
        };


        var handler = {
            hdr: withProgress(doHdr),
            gce: withProgress(doGCE),
            com: withProgress(doNothing),
            // I guess that's all for now.
            app: {
                // TODO: Is there much point in actually supporting iterations?
                NETSCAPE: withProgress(doNothing)
            },
            img: withProgress(doImg, true),
            eof: function (block) {
                //toolbar.style.display = '';
                pushFrame();
                doDecodeProgress(false);
                if ( ! (options.c_w && options.c_h) ) {
                    canvas.width = hdr.width * get_canvas_scale();
                    canvas.height = hdr.height * get_canvas_scale();
                }
                player.init();
                loading = false;
                if (load_callback) {
                    load_callback(gif);
                }

            }
        };

        var init = function () {
            var parent = gif.parentNode;

            var div = document.createElement('div');
            canvas = document.createElement('canvas');
            ctx = canvas.getContext('2d', { willReadFrequently: true });
            toolbar = document.createElement('div');

            tmpCanvas = document.createElement('canvas');

            div.width = canvas.width = gif.width;
            div.height = canvas.height = gif.height;
            toolbar.style.minWidth = gif.width + 'px';

            div.className = 'jsgif';
            toolbar.className = 'jsgif_toolbar';
            div.appendChild(canvas);
            div.appendChild(toolbar);

            parent.insertBefore(div, gif);
            parent.removeChild(gif);

            if (options.c_w && options.c_h) setSizes(options.c_w, options.c_h);
            initialized=true;
        };

        var get_canvas_scale = function() {
            var scale;
            if (options.max_width && hdr && hdr.width > options.max_width) {
                scale = options.max_width / hdr.width;
            }
            else {
                scale = 1;
            }
            return scale;
        }

        var canvas, ctx, toolbar, tmpCanvas;
        var initialized = false;
        var load_callback = false;

        var load_setup = function(callback) {
            if (loading) return false;
            if (callback) load_callback = callback;
            else load_callback = false;

            loading = true;
            frames = [];
            clear();
            disposalRestoreFromIdx = null;
            lastDisposalMethod = null;
            frame = null;
            lastImg = null;

            return true;
        }

        var calculateDuration = function() {
            return frames.reduce(function(duration, frame) {
                return duration + frame.delay;
            }, 0);
        }

        return {
            // play controls
            play: player.play,
            pause: player.pause,
            move_relative: player.move_relative,
            move_to: player.move_to,

            // getters for instance vars
            get_playing      : function() { return playing },
            get_canvas       : function() { return canvas },
            get_canvas_scale : function() { return get_canvas_scale() },
            get_loading      : function() { return loading },
            get_auto_play    : function() { return options.auto_play },
            get_length       : function() { return player.length() },
            get_frames       : function() { return frames },
            get_duration     : function() { return calculateDuration() },
            get_duration_ms  : function() { return calculateDuration() * 10 },
            get_current_frame: function() { return player.current_frame() },
            load_url: function(src,callback){
                if (!load_setup(callback)) return;

                var h = new XMLHttpRequest();
                // new browsers (XMLHttpRequest2-compliant)
                h.open('GET', src, true);

                if ('overrideMimeType' in h) {
                    h.overrideMimeType('text/plain; charset=x-user-defined');
                }

                // old browsers (XMLHttpRequest-compliant)
                else if ('responseType' in h) {
                    h.responseType = 'arraybuffer';
                }

                // IE9 (Microsoft.XMLHTTP-compliant)
                else {
                    h.setRequestHeader('Accept-Charset', 'x-user-defined');
                }

                h.onloadstart = function() {
                    // Wait until connection is opened to replace the gif element with a canvas to avoid a blank img
                    if (!initialized) init();
                };
                h.onload = function(e) {
                    if (this.status != 200) {
                        doLoadError('xhr - response');
                    }
                    // emulating response field for IE9
                    if (!('response' in this)) {
                        this.response = new VBArray(this.responseText).toArray().map(String.fromCharCode).join('');
                    }
                    var data = this.response;
                    if (data.toString().indexOf("ArrayBuffer") > 0) {
                        data = new Uint8Array(data);
                    }

                    stream = new Stream(data);
                    setTimeout(doParse, 0);
                };
                h.onprogress = function (e) {
                    if (e.lengthComputable) doShowProgress(e.loaded, e.total, true);
                };
                h.onerror = function() { doLoadError('xhr'); };
                h.send();
            },
            load: function (callback) {
                this.load_url(gif.getAttribute('rel:animated_src') || gif.src,callback);
            },
            load_raw: function(arr, callback) {
                if (!load_setup(callback)) return;
                if (!initialized) init();
                stream = new Stream(arr);
                setTimeout(doParse, 0);
            },
            set_frame_offset: setFrameOffset
        };
    };

    return SuperGif;
}));




/***/ }),

/***/ 4547:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Base_X3DInfoArray_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(3020);
/* harmony import */ var _ComponentInfo_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(4804);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(717);



function ComponentInfoArray (values = [ ])
{
   return _Base_X3DInfoArray_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .call (this, Array .from (values, value => [value .name, value]), _ComponentInfo_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A);
}

Object .assign (Object .setPrototypeOf (ComponentInfoArray .prototype, _Base_X3DInfoArray_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .prototype),
{
   add (name, { level, title, providerURL, external = false, dependencies = [ ] })
   {
      _Base_X3DInfoArray_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .prototype .add .call (this, name, new _ComponentInfo_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (name, level, title, providerURL, external, dependencies));
   },
});

for (const key of Object .keys (ComponentInfoArray .prototype))
   Object .defineProperty (ComponentInfoArray .prototype, key, { enumerable: false });

Object .defineProperties (ComponentInfoArray,
{
   typeName:
   {
      value: "ComponentInfoArray",
      enumerable: true,
   },
});

const __default__ = ComponentInfoArray;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .add ("ComponentInfoArray", __default__));

/***/ }),

/***/ 4598:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  A: () => (/* binding */ x_ite_Fields)
});

// EXTERNAL MODULE: ./src/x_ite/Base/X3DField.js
var X3DField = __webpack_require__(2269);
// EXTERNAL MODULE: ./src/x_ite/Namespace.js
var Namespace = __webpack_require__(717);
;// ./src/x_ite/Fields/SFScalar.js


function SFBoolTemplate (TypeName)
{
   function SFBool (value)
   {
      X3DField/* default */.A .call (this, !! value);
   }

   return SFScalarPrototypeTemplate (SFBool, TypeName,
   {
      isDefaultValue ()
      {
         return this .getValue () === false;
      },
      set (value)
      {
         X3DField/* default */.A .prototype .set .call (this, !! value);
      },
      toStream (generator)
      {
         generator .string += this .getValue () ? "TRUE" : "FALSE";
      },
      toXMLStream (generator)
      {
         generator .string += this .getValue () ? "true" : "false";
      },
      toJSONStreamValue (generator)
      {
         generator .string += this .getValue () ? "true" : "false";
      },
   });
}

function SFNumberTemplate (TypeName, double, defaultValue)
{
   const _formatter = double ? "DoubleFormat" : "FloatFormat";

   function SFNumber (value)
   {
      X3DField/* default */.A .call (this, arguments .length ? +value : defaultValue);
   }

   return SFScalarPrototypeTemplate (SFNumber, TypeName,
   {
      isDefaultValue ()
      {
         return this .getValue () === defaultValue;
      },
      set (value)
      {
         X3DField/* default */.A .prototype .set .call (this, +value);
      },
      toStream (generator)
      {
         const category = this .getUnit ();

         generator .string += generator [_formatter] (generator .ToUnit (category, this .getValue ()));
      },
      toJSONStreamValue (generator)
      {
         const category = this .getUnit ();

         generator .string += generator .Number (generator [_formatter] (generator .ToUnit (category, this .getValue ())));
      },
   });
}

function SFInt32Template (TypeName)
{
   function SFInt32 (value)
   {
      X3DField/* default */.A .call (this, value|0);
   }

   return SFScalarPrototypeTemplate (SFInt32, TypeName,
   {
      isDefaultValue ()
      {
         return this .getValue () === 0;
      },
      set (value)
      {
         X3DField/* default */.A .prototype .set .call (this, value|0);
      },
   });
}

function SFStringTemplate (TypeName)
{
   function SFString (value)
   {
      X3DField/* default */.A .call (this, arguments .length ? String (value) : "");
   }

   SFScalarPrototypeTemplate (SFString, TypeName,
   {
      *[Symbol .iterator] ()
      {
         yield* this .getValue ();
      },
      isDefaultValue ()
      {
         return this .getValue () === "";
      },
      set (value)
      {
         X3DField/* default */.A .prototype .set .call (this, String (value));
      },
      toStream (generator)
      {
         generator .string += '"';
         generator .string += SFString .escape (this .getValue ());
         generator .string += '"';
      },
      toXMLStream (generator, sourceText = false)
      {
         generator .string += sourceText
            ? generator .EncodeSourceText (this .getValue ())
            : generator .EncodeString (this .getValue ());
      },
      toJSONStreamValue (generator)
      {
         generator .string += '"';
         generator .string += generator .EncodeString (this .getValue ());
         generator .string += '"';
      },
   });

   Object .defineProperty (SFString .prototype, "length",
   {
      get ()
      {
         return this .getValue () .length;
      },
   });

   Object .assign (SFString,
   {
      unescape (string)
      {
         return string .replace (/\\([\\"])/g, "$1");
      },
      escape (string)
      {
         return string .replace (/([\\"])/g, "\\$1");
      },
   });

   return SFString;
}

function SFScalarPrototypeTemplate (Constructor, TypeName, properties = { })
{
   Object .defineProperties (Constructor,
   {
      typeName:
      {
         value: TypeName,
         enumerable: true,
      },
   });

   Object .assign (Object .setPrototypeOf (Constructor .prototype, X3DField/* default */.A .prototype),
   {
      copy ()
      {
         return new Constructor (this .getValue ());
      },
      valueOf: X3DField/* default */.A .prototype .getValue,
      toStream (generator)
      {
         generator .string += String (this .getValue ());
      },
      toVRMLStream (generator)
      {
         this .toStream (generator);
      },
      toXMLStream (generator)
      {
         this .toStream (generator);
      },
      toJSONStream (generator)
      {
         this .toJSONStreamValue (generator);
      },
      toJSONStreamValue (generator)
      {
         this .toStream (generator);
      },
   },
   properties);

   for (const key of Object .keys (Constructor .prototype))
      Object .defineProperty (Constructor .prototype, key, { enumerable: false });

   return Constructor;
}

const SFScalar = {
   SFBool:   SFBoolTemplate   ("SFBool"),
   SFDouble: SFNumberTemplate ("SFDouble", true,  0),
   SFFloat:  SFNumberTemplate ("SFFloat",  false, 0),
   SFInt32:  SFInt32Template  ("SFInt32"),
   SFString: SFStringTemplate ("SFString"),
   SFTime:   SFNumberTemplate ("SFTime",   true, -1),
};

const __default__ = SFScalar;
;

/* harmony default export */ const Fields_SFScalar = (Namespace/* default */.A .add ("SFScalar", __default__));
// EXTERNAL MODULE: ./src/standard/Math/Numbers/Color3.js
var Color3 = __webpack_require__(2262);
;// ./src/x_ite/Fields/SFColor.js



function SFColor (r, g, b)
{
   switch (arguments .length)
   {
      case 0:
         X3DField/* default */.A .call (this, new Color3/* default */.A ());
         break;

      case 1:
         X3DField/* default */.A .call (this, arguments [0]);
         break;

      case 3:
         X3DField/* default */.A .call (this, new Color3/* default */.A (+r, +g, +b));
         break;

      default:
         throw new Error ("Invalid arguments.");
   }
}

Object .assign (Object .setPrototypeOf (SFColor .prototype, X3DField/* default */.A .prototype),
{
   *[Symbol .iterator] ()
   {
      yield* this .getValue ();
   },
   copy ()
   {
      return new SFColor (this .getValue () .copy ());
   },
   equals (color)
   {
      return this .getValue () .equals (color .getValue ());
   },
   isDefaultValue ()
   {
      return this .getValue () .equals (Color3/* default */.A .BLACK);
   },
   set (value)
   {
      this .getValue () .assign (value);
   },
   getHSV ()
   {
      return this .getValue () .getHSV ([ ]);
   },
   setHSV (h, s, v)
   {
      this .getValue () .setHSV (h, s, v);
      this .addEvent ();
   },
   linearToSRGB ()
   {
      return new SFColor (this .getValue () .linearToSRGB ());
   },
   sRGBToLinear ()
   {
      return new SFColor (this .getValue () .sRGBToLinear ());
   },
   lerp: (() =>
   {
      const
         s = [ ],
         d = [ ],
         r = [ ];

      return function (destination, t)
      {
         const result = new SFColor ();

         this .getValue () .getHSV (s);
         destination .getValue () .getHSV (d);

         Color3/* default */.A .lerp (s, d, t, r);

         result .setHSV (r [0], r [1], r [2]);

         return result;
      };
   })(),
   toStream (generator)
   {
      const
         value = this .getValue (),
         last  = value .length - 1;

      for (let i = 0; i < last; ++ i)
      {
         generator .string += generator .FloatFormat (value [i]);
         generator .string += generator .Space ();
      }

      generator .string += generator .FloatFormat (value [last]);
   },
   toVRMLStream (generator)
   {
      this .toStream (generator);
   },
   toXMLStream (generator)
   {
      this .toStream (generator);
   },
   toJSONStream (generator)
   {
      generator .string += '[';
      generator .string += generator .TidySpace ();

      this .toJSONStreamValue (generator);

      generator .string += generator .TidySpace ();
      generator .string += ']';
   },
   toJSONStreamValue (generator)
   {
      const
         value = this .getValue (),
         last  = value .length - 1;

      for (let i = 0; i < last; ++ i)
      {
         generator .string += generator .Number (generator .FloatFormat (value [i]));
         generator .string += ',';
         generator .string += generator .TidySpace ();
      }

      generator .string += generator .Number (generator .FloatFormat (value [last]));
   },
});

for (const key of Object .keys (SFColor .prototype))
   Object .defineProperty (SFColor .prototype, key, { enumerable: false });

const r = {
   get ()
   {
      return this .getValue () .r;
   },
   set (value)
   {
      this .getValue () .r = +value;
      this .addEvent ();
   },
};

const g = {
   get ()
   {
      return this .getValue () .g;
   },
   set (value)
   {
      this .getValue () .g = +value;
      this .addEvent ();
   },
};

const b = {
   get ()
   {
      return this .getValue () .b;
   },
   set (value)
   {
      this .getValue () .b = +value;
      this .addEvent ();
   },
};

Object .defineProperties (SFColor .prototype,
{
   0: r,
   1: g,
   2: b,
   r: Object .assign ({ enumerable: true }, r),
   g: Object .assign ({ enumerable: true }, g),
   b: Object .assign ({ enumerable: true }, b),
});

Object .defineProperties (SFColor,
{
   typeName:
   {
      value: "SFColor",
      enumerable: true,
   },
});

const SFColor_default_ = SFColor;
;

/* harmony default export */ const Fields_SFColor = (Namespace/* default */.A .add ("SFColor", SFColor_default_));
// EXTERNAL MODULE: ./src/standard/Math/Numbers/Color4.js
var Color4 = __webpack_require__(3527);
;// ./src/x_ite/Fields/SFColorRGBA.js




function SFColorRGBA (r, g, b, a)
{
   switch (arguments .length)
   {
      case 0:
         X3DField/* default */.A .call (this, new Color4/* default */.A ());
         break;

      case 1:
         X3DField/* default */.A .call (this, arguments [0]);
         break;

      case 4:
         X3DField/* default */.A .call (this, new Color4/* default */.A (+r, +g, +b, +a));
         break

      default:
         throw new Error ("Invalid arguments.");
   }
}

Object .assign (Object .setPrototypeOf (SFColorRGBA .prototype, X3DField/* default */.A .prototype),
{
   *[Symbol .iterator] ()
   {
      yield* this .getValue ();
   },
   copy ()
   {
      return new SFColorRGBA (this .getValue () .copy ());
   },
   equals: Fields_SFColor .prototype .equals,
   isDefaultValue ()
   {
      return this .getValue () .equals (Color4/* default */.A .TRANSPARENT);
   },
   set: Fields_SFColor .prototype .set,
   getHSVA ()
   {
      return this .getValue () .getHSVA ([ ]);
   },
   setHSVA (h, s, v, a)
   {
      this .getValue () .setHSVA (h, s, v, a);
      this .addEvent ();
   },
   linearToSRGB ()
   {
      return new SFColorRGBA (this .getValue () .linearToSRGB ());
   },
   sRGBToLinear ()
   {
      return new SFColorRGBA (this .getValue () .sRGBToLinear ());
   },
   lerp: (() =>
   {
      const
         s = [ ],
         d = [ ],
         r = [ ];

      return function (destination, t)
      {
         const result = new SFColorRGBA ();

         this .getValue () .getHSVA (s);
         destination .getValue () .getHSVA (d);

         Color4/* default */.A .lerp (s, d, t, r);

         result .setHSVA (r [0], r [1], r [2], r [3]);

         return result;
      };
   })(),
   toStream: Fields_SFColor .prototype .toStream,
   toVRMLStream: Fields_SFColor .prototype .toVRMLStream,
   toXMLStream: Fields_SFColor .prototype .toXMLStream,
   toJSONStream: Fields_SFColor .prototype .toJSONStream,
   toJSONStreamValue: Fields_SFColor .prototype .toJSONStreamValue,
});

for (const key of Object .keys (SFColorRGBA .prototype))
   Object .defineProperty (SFColorRGBA .prototype, key, { enumerable: false });

const SFColorRGBA_r = {
   get ()
   {
      return this .getValue () .r;
   },
   set (value)
   {
      this .getValue () .r = +value;
      this .addEvent ();
   },
};

const SFColorRGBA_g = {
   get ()
   {
      return this .getValue () .g;
   },
   set (value)
   {
      this .getValue () .g = +value;
      this .addEvent ();
   },
};

const SFColorRGBA_b = {
   get ()
   {
      return this .getValue () .b;
   },
   set (value)
   {
      this .getValue () .b = +value;
      this .addEvent ();
   },
};

const a = {
   get ()
   {
      return this .getValue () .a;
   },
   set (value)
   {
      this .getValue () .a = +value;
      this .addEvent ();
   },
};

Object .defineProperties (SFColorRGBA .prototype,
{
   0: SFColorRGBA_r,
   1: SFColorRGBA_g,
   2: SFColorRGBA_b,
   3: a,
   r: Object .assign ({ enumerable: true }, SFColorRGBA_r),
   g: Object .assign ({ enumerable: true }, SFColorRGBA_g),
   b: Object .assign ({ enumerable: true }, SFColorRGBA_b),
   a: Object .assign ({ enumerable: true }, a),
});

Object .defineProperties (SFColorRGBA,
{
   typeName:
   {
      value: "SFColorRGBA",
      enumerable: true,
   },
});

const SFColorRGBA_default_ = SFColorRGBA;
;

/* harmony default export */ const Fields_SFColorRGBA = (Namespace/* default */.A .add ("SFColorRGBA", SFColorRGBA_default_));
;// ./src/x_ite/Fields/SFMatrixPrototypeTemplate.js


function SFMatrixPrototypeTemplate (Constructor, TypeName, Matrix, double, properties = { })
{
   const _formatter = double ? "DoubleFormat" : "FloatFormat";

   Object .defineProperties (Constructor,
   {
      typeName:
      {
         value: TypeName,
         enumerable: true,
      },
   });

   Object .assign (Object .setPrototypeOf (Constructor .prototype, X3DField/* default */.A .prototype),
   {
      *[Symbol .iterator] ()
      {
         yield* this .getValue ();
      },
      copy ()
      {
         return new (this .constructor) (this .getValue () .copy ());
      },
      equals (matrix)
      {
         return this .getValue () .equals (matrix .getValue ());
      },
      isDefaultValue ()
      {
         return this .getValue () .equals (Matrix .IDENTITY);
      },
      set (value)
      {
         this .getValue () .assign (value);
      },
      setTransform: (() =>
      {
         const args = [ ];

         return function (translation, rotation, scale, scaleOrientation, center)
         {
            args .push (translation      ?.getValue (),
                        rotation         ?.getValue (),
                        scale            ?.getValue (),
                        scaleOrientation ?.getValue (),
                        center           ?.getValue ());

            for (let i = args .length - 1; i > -1; -- i)
            {
               if (args [i])
                  break;

               args .pop ();
            }

            this .getValue () .set (... args);

            args .length = 0;
         };
      })(),
      getTransform: (() =>
      {
         const args = [ ];

         return function (translation, rotation, scale, scaleOrientation, center)
         {
            args .push (translation      ?.getValue (),
                        rotation         ?.getValue (),
                        scale            ?.getValue (),
                        scaleOrientation ?.getValue (),
                        center           ?.getValue ());

            for (let i = args .length - 1; i > -1; -- i)
            {
               if (args [i])
                  break;

               args .pop ();
            }

            this .getValue () .get (... args);

            translation      ?.addEvent ();
            rotation         ?.addEvent ();
            scale            ?.addEvent ();
            scaleOrientation ?.addEvent ();

            args .length = 0;
         };
      })(),
      determinant ()
      {
         return this .getValue () .determinant ();
      },
      transpose ()
      {
         return new (this .constructor) (this .getValue () .copy () .transpose ());
      },
      inverse ()
      {
         return new (this .constructor) (this .getValue () .copy () .inverse ());
      },
      multLeft (matrix)
      {
         return new (this .constructor) (this .getValue () .copy () .multLeft (matrix .getValue ()));
      },
      multRight (matrix)
      {
         return new (this .constructor) (this .getValue () .copy () .multRight (matrix .getValue ()));
      },
      multVecMatrix (vector)
      {
         return new (vector .constructor) (this .getValue () .multVecMatrix (vector .getValue () .copy ()));
      },
      multMatrixVec (vector)
      {
         return new (vector .constructor) (this .getValue () .multMatrixVec (vector .getValue () .copy ()));
      },
      multDirMatrix (vector)
      {
         return new (vector .constructor) (this .getValue () .multDirMatrix (vector .getValue () .copy ()));
      },
      multMatrixDir (vector)
      {
         return new (vector .constructor) (this .getValue () .multMatrixDir (vector .getValue () .copy ()));
      },
      translate (translation)
      {
         return new (this .constructor) (this .getValue () .copy () .translate (translation .getValue ()));
      },
      rotate (rotation)
      {
         return new (this .constructor) (this .getValue () .copy () .rotate (rotation .getValue ()));
      },
      scale (scale)
      {
         return new (this .constructor) (this .getValue () .copy () .scale (scale .getValue ()));
      },
      toStream (generator)
      {
         const
            value = this .getValue (),
            last  = value .length - 1;

         for (let i = 0; i < last; ++ i)
         {
            generator .string += generator [_formatter] (value [i]);
            generator .string += generator .Space ();
         }

         generator .string += generator [_formatter] (value [last]);
      },
      toVRMLStream (generator)
      {
         this .toStream (generator);
      },
      toXMLStream (generator)
      {
         this .toStream (generator);
      },
      toJSONStream (generator)
      {
         generator .string += '[';
         generator .string += generator .TidySpace ();

         this .toJSONStreamValue (generator);

         generator .string += generator .TidySpace ();
         generator .string += ']';
      },
      toJSONStreamValue (generator)
      {
         const
            value = this .getValue (),
            last  = value .length - 1;

         for (let i = 0; i < last; ++ i)
         {
            generator .string += generator .Number (generator [_formatter] (value [i]));
            generator .string += ',';
            generator .string += generator .TidySpace ();
         }

         generator .string += generator .Number (generator [_formatter] (value [last]));
      },
   },
   properties);

   for (const key of Object .keys (Constructor .prototype))
      Object .defineProperty (Constructor .prototype, key, { enumerable: false });

   function defineProperty (i)
   {
      Object .defineProperty (Constructor .prototype, i,
      {
         get ()
         {
            return this .getValue () [i];
         },
         set (value)
         {
            this .getValue () [i] = +value;
            this .addEvent ();
         },
         enumerable: true,
      });
   }

   for (let i = 0; i < Matrix .prototype .length; ++ i)
      defineProperty (i);

   return Constructor;
}

const SFMatrixPrototypeTemplate_default_ = SFMatrixPrototypeTemplate;
;

/* harmony default export */ const Fields_SFMatrixPrototypeTemplate = (Namespace/* default */.A .add ("SFMatrixPrototypeTemplate", SFMatrixPrototypeTemplate_default_));
// EXTERNAL MODULE: ./src/standard/Math/Numbers/Matrix3.js + 1 modules
var Matrix3 = __webpack_require__(8713);
;// ./src/x_ite/Fields/SFMatrix3.js




function SFMatrix3Template (TypeName, double)
{
   function SFMatrix3 (m00, m01, m02,
                       m10, m11, m12,
                       m20, m21, m22)
   {
      switch (arguments .length)
      {
         case 0:
            X3DField/* default */.A .call (this, new Matrix3/* default */.A ());
            break;

         case 1:
            X3DField/* default */.A .call (this, arguments [0]);
            break;

         case 3:
         {
            const
               r0 = arguments [0],
               r1 = arguments [1],
               r2 = arguments [2];

            X3DField/* default */.A .call (this, new Matrix3/* default */.A (r0 .x, r0 .y, r0 .z,
                                               r1 .x, r1 .y, r1 .z,
                                               r2 .x, r2 .y, r2 .z));

            break;
         }
         case 9:
         {
            X3DField/* default */.A .call (this, new Matrix3/* default */.A (+m00, +m01, +m02,
                                               +m10, +m11, +m12,
                                               +m20, +m21, +m22));

            break;
         }
         default:
            throw new Error ("Invalid arguments.");
      }
   }

   return Fields_SFMatrixPrototypeTemplate (SFMatrix3, TypeName, Matrix3/* default */.A, double,
   {
      setTransform: (() =>
      {
         const args = [ ];

         return function (translation, rotation, scale, scaleOrientation, center)
         {
            args .push (translation ?.getValue (), rotation, scale ?.getValue (), scaleOrientation, center ?.getValue ());

            for (let i = args .length - 1; i > -1; -- i)
            {
               if (args [i])
                  break;

               args .pop ();
            }

            this .getValue () .set (... args);

            args .length = 0;
         };
      })(),
      rotate (rotation)
      {
         return new (this .constructor) (this .getValue () .copy () .rotate (rotation));
      },
      skewX (angle)
      {
         return new (this .constructor) (this .getValue () .copy () .skewX (angle));
      },
      skewY (angle)
      {
         return new (this .constructor) (this .getValue () .copy () .skewY (angle));
      },
   });
}

const SFMatrix3 = {
   SFMatrix3d: SFMatrix3Template ("SFMatrix3d", true),
   SFMatrix3f: SFMatrix3Template ("SFMatrix3f", false),
};

const SFMatrix3_default_ = SFMatrix3;
;

/* harmony default export */ const Fields_SFMatrix3 = (Namespace/* default */.A .add ("SFMatrix3", SFMatrix3_default_));
// EXTERNAL MODULE: ./src/standard/Math/Numbers/Matrix4.js
var Matrix4 = __webpack_require__(6179);
;// ./src/x_ite/Fields/SFMatrix4.js




function SFMatrix4Template (TypeName, double)
{
   function SFMatrix4 (m00, m01, m02, m03,
                       m10, m11, m12, m13,
                       m20, m21, m22, m23,
                       m30, m31, m32, m33)
   {
      switch (arguments .length)
      {
         case 0:
            X3DField/* default */.A .call (this, new Matrix4/* default */.A ());
            break;

         case 1:
            X3DField/* default */.A .call (this, arguments [0]);
            break;

         case 4:
         {
            const
               r0 = arguments [0],
               r1 = arguments [1],
               r2 = arguments [2],
               r3 = arguments [3];

            X3DField/* default */.A .call (this, new Matrix4/* default */.A (r0 .x, r0 .y, r0 .z, r0 .w,
                                               r1 .x, r1 .y, r1 .z, r1 .w,
                                               r2 .x, r2 .y, r2 .z, r2 .w,
                                               r3 .x, r3 .y, r3 .z, r3 .w));

            break;
         }
         case 16:
         {
            X3DField/* default */.A .call (this, new Matrix4/* default */.A (+m00, +m01, +m02, +m03,
                                               +m10, +m11, +m12, +m13,
                                               +m20, +m21, +m22, +m23,
                                               +m30, +m31, +m32, +m33));

            break;
         }
         default:
            throw new Error ("Invalid arguments.");
      }
   }

   return Fields_SFMatrixPrototypeTemplate (SFMatrix4, TypeName, Matrix4/* default */.A, double);
}

const SFMatrix4 = {
   SFMatrix4d: SFMatrix4Template ("SFMatrix4d", true),
   SFMatrix4f: SFMatrix4Template ("SFMatrix4f", false),
   VrmlMatrix: SFMatrix4Template ("VrmlMatrix", false),
};

const SFMatrix4_default_ = SFMatrix4;
;

/* harmony default export */ const Fields_SFMatrix4 = (Namespace/* default */.A .add ("SFMatrix4", SFMatrix4_default_));
// EXTERNAL MODULE: ./src/x_ite/Fields/SFNode.js
var SFNode = __webpack_require__(1061);
;// ./src/x_ite/Fields/SFVecPrototypeTemplate.js


function SFVecPrototypeTemplate (Constructor, TypeName, Vector, double, properties = { })
{
   const _formatter = double ? "DoubleFormat" : "FloatFormat";

   Object .defineProperties (Constructor,
   {
      typeName:
      {
         value: TypeName,
         enumerable: true,
      },
   });

   Object .assign (Object .setPrototypeOf (Constructor .prototype, X3DField/* default */.A .prototype),
   {
      *[Symbol .iterator] ()
      {
         yield* this .getValue ();
      },
      copy ()
      {
         return new (this .constructor) (this .getValue () .copy ());
      },
      equals (vector)
      {
         return this .getValue () .equals (vector .getValue ());
      },
      isDefaultValue ()
      {
         return this .getValue () .equals (Vector .ZERO);
      },
      set (value)
      {
         this .getValue () .assign (value);
      },
      abs ()
      {
         return new (this .constructor) (this .getValue () .copy () .abs ());
      },
      add (vector)
      {
         return new (this .constructor) (this .getValue () .copy () .add (vector .getValue ()));
      },
      clamp (low, high)
      {
         return new (this .constructor) (this .getValue () .copy () .clamp (low .getValue (), high .getValue ()));
      },
      distance (vector)
      {
         return this .getValue () .distance (vector .getValue ());
      },
      divide (value)
      {
         return new (this .constructor) (this .getValue () .copy () .divide (value));
      },
      divVec (vector)
      {
         return new (this .constructor) (this .getValue () .copy () .divVec (vector .getValue ()));
      },
      dot (vector)
      {
         return this .getValue () .dot (vector .getValue ());
      },
      inverse ()
      {
         return new (this .constructor) (this .getValue () .copy () .inverse ());
      },
      length ()
      {
         return this .getValue () .norm ();
      },
      lerp (destination, t)
      {
         return new (this .constructor) (this .getValue () .copy () .lerp (destination, t));
      },
      max (vector)
      {
         return new (this .constructor) (this .getValue () .copy () .max (vector .getValue ()));
      },
      min (vector)
      {
         return new (this .constructor) (this .getValue () .copy () .min (vector .getValue ()));
      },
      multiply (value)
      {
         return new (this .constructor) (this .getValue () .copy () .multiply (value));
      },
      multVec (vector)
      {
         return new (this .constructor) (this .getValue () .copy () .multVec (vector .getValue ()));
      },
      negate ()
      {
         return new (this .constructor) (this .getValue () .copy () .negate ());
      },
      normalize (vector)
      {
         return new (this .constructor) (this .getValue () .copy () .normalize ());
      },
      subtract (vector)
      {
         return new (this .constructor) (this .getValue () .copy () .subtract (vector .getValue ()));
      },
      toStream (generator)
      {
         const
            value    = this .getValue (),
            last     = value .length - 1,
            category = this .getUnit ();

         for (let i = 0; i < last; ++ i)
         {
            generator .string += generator [_formatter] (generator .ToUnit (category, value [i]));
            generator .string += generator .Space ();
         }

         generator .string += generator [_formatter] (generator .ToUnit (category, value [last]));
      },
      toVRMLStream (generator)
      {
         this .toStream (generator);
      },
      toXMLStream (generator)
      {
         this .toStream (generator);
      },
      toJSONStream (generator)
      {
         generator .string += '[';
         generator .string += generator .TidySpace ();

         this .toJSONStreamValue (generator);

         generator .string += generator .TidySpace ();
         generator .string += ']';
      },
      toJSONStreamValue (generator)
      {
         const
            value    = this .getValue (),
            last     = value .length - 1,
            category = this .getUnit ();

         for (let i = 0; i < last; ++ i)
         {
            generator .string += generator .Number (generator [_formatter] (generator .ToUnit (category, value [i])));
            generator .string += ',';
            generator .string += generator .TidySpace ();
         }

         generator .string += generator .Number (generator [_formatter] (generator .ToUnit (category, value [last])));
      },
   },
   properties);

   for (const key of Object .keys (Constructor .prototype))
      Object .defineProperty (Constructor .prototype, key, { enumerable: false });

   const x = {
      get ()
      {
         return this .getValue () .x;
      },
      set (value)
      {
         this .getValue () .x = +value;
         this .addEvent ();
      },
   };

   const y = {
      get ()
      {
         return this .getValue () .y;
      },
      set (value)
      {
         this .getValue () .y = +value;
         this .addEvent ();
      },
   };

   const z = {
      get ()
      {
         return this .getValue () .z;
      },
      set (value)
      {
         this .getValue () .z = +value;
         this .addEvent ();
      },
   };

   const w = {
      get ()
      {
         return this .getValue () .w;
      },
      set (value)
      {
         this .getValue () .w = +value;
         this .addEvent ();
      },
   };

   const indices = [
      [0, x],
      [1, y],
      [2, z],
      [3, w],
   ];

   const props = [
      ["x", Object .assign ({ enumerable: true }, x)],
      ["y", Object .assign ({ enumerable: true }, y)],
      ["z", Object .assign ({ enumerable: true }, z)],
      ["w", Object .assign ({ enumerable: true }, w)],
   ];

   indices .length = Vector .prototype .length;
   props   .length = Vector .prototype .length;

   Object .defineProperties (Constructor .prototype, Object .fromEntries (indices .concat (props)));

   return Constructor;
}

const SFVecPrototypeTemplate_default_ = SFVecPrototypeTemplate;
;

/* harmony default export */ const Fields_SFVecPrototypeTemplate = (Namespace/* default */.A .add ("SFVecPrototypeTemplate", SFVecPrototypeTemplate_default_));
// EXTERNAL MODULE: ./src/standard/Math/Numbers/Vector3.js
var Vector3 = __webpack_require__(7572);
;// ./src/x_ite/Fields/SFVec3.js




function SFVec3Template (TypeName, double)
{
   function SFVec3 (x, y, z)
   {
      switch (arguments .length)
      {
         case 0:
            X3DField/* default */.A .call (this, new Vector3/* default */.A ());
            break;

         case 1:
            X3DField/* default */.A .call (this, arguments [0]);
            break;

         case 3:
            X3DField/* default */.A .call (this, new Vector3/* default */.A (+x, +y, +z));
            break;

         default:
            throw new Error ("Invalid arguments.");
      }
   }

   return Fields_SFVecPrototypeTemplate (SFVec3, TypeName, Vector3/* default */.A, double,
   {
      cross (vector)
      {
         return new (this .constructor) (this .getValue () .copy () .cross (vector .getValue ()));
      },
   });
}

const SFVec3 = {
   SFVec3d: SFVec3Template ("SFVec3d", true),
   SFVec3f: SFVec3Template ("SFVec3f", false),
};

const SFVec3_default_ = SFVec3;
;

/* harmony default export */ const Fields_SFVec3 = (Namespace/* default */.A .add ("SFVec3", SFVec3_default_));
// EXTERNAL MODULE: ./src/standard/Math/Numbers/Rotation4.js
var Rotation4 = __webpack_require__(7078);
// EXTERNAL MODULE: ./src/standard/Math/Numbers/Quaternion.js
var Quaternion = __webpack_require__(1770);
;// ./src/x_ite/Fields/SFRotation.js






const
   SFVec3d    = Fields_SFVec3 .SFVec3d,
   SFVec3f    = Fields_SFVec3 .SFVec3f,
   SFMatrix3d = Fields_SFMatrix3 .SFMatrix3d,
   SFMatrix3f = Fields_SFMatrix3 .SFMatrix3f;

function SFRotation (x, y, z, angle)
{
   switch (arguments .length)
   {
      case 0:
      {
         X3DField/* default */.A .call (this, new Rotation4/* default */.A ());
         break;
      }
      case 1:
      {
         if ((arguments [0] instanceof SFMatrix3d) || (arguments [0] instanceof SFMatrix3f))
         {
            X3DField/* default */.A .call (this, new Rotation4/* default */.A () .setMatrix (arguments [0] .getValue ()));
            break;
         }

         X3DField/* default */.A .call (this, arguments [0]);
         break;
      }
      case 2:
      {
         if ((arguments [1] instanceof SFVec3d) || (arguments [1] instanceof SFVec3f))
         {
            X3DField/* default */.A .call (this, new Rotation4/* default */.A (arguments [0] .getValue (), arguments [1] .getValue ()));
            break;
         }

         X3DField/* default */.A .call (this, new Rotation4/* default */.A (arguments [0] .getValue (), +arguments [1]));
         break;
      }
      case 4:
      {
         X3DField/* default */.A .call (this, new Rotation4/* default */.A (+x, +y, +z, +angle));
         break;
      }
      default:
         throw new Error ("Invalid arguments.");
   }
}

Object .assign (Object .setPrototypeOf (SFRotation .prototype, X3DField/* default */.A .prototype),
{
   *[Symbol .iterator] ()
   {
      yield* this .getValue ();
   },
   copy ()
   {
      return new SFRotation (this .getValue () .copy ());
   },
   equals (rotation)
   {
      return this .getValue () .equals (rotation .getValue ());
   },
   isDefaultValue ()
   {
      return this .getValue () .equals (Rotation4/* default */.A .IDENTITY);
   },
   set (value)
   {
      this .getValue () .assign (value);
   },
   setAxis (vector)
   {
      this .getValue () .setAxis (vector .getValue ());
      this .addEvent ();
   },
   getAxis ()
   {
      return new SFVec3f (this .getValue () .getAxis ());
   },
   setMatrix (matrix)
   {
      this .getValue () .setMatrix (matrix .getValue ());
      this .addEvent ();
   },
   getMatrix ()
   {
      return new SFMatrix3f (this .getValue () .getMatrix ());
   },
   setQuaternion: (() =>
   {
      const q = new Quaternion/* default */.A ();

      return function (x, y, z, w)
      {
         this .getValue () .setQuaternion (q .set (x, y, z, w));
         this .addEvent ();
      };
   })(),
   getQuaternion: (() =>
   {
      const q = new Quaternion/* default */.A ();

      return function ()
      {
         return [... this .getValue () .getQuaternion (q)];
      };
   })(),
   inverse ()
   {
      return new SFRotation (this .getValue () .copy () .inverse ());
   },
   multiply (rotation)
   {
      return new SFRotation (this .getValue () .copy () .multRight (rotation .getValue ()));
   },
   multVec (vector)
   {
      return new (vector .constructor) (this .getValue () .multVecRot (vector .getValue () .copy ()));
   },
   slerp (rotation, t)
   {
      return new SFRotation (this .getValue () .copy () .slerp (rotation .getValue (), t));
   },
   straighten (upVector)
   {
      return new SFRotation (this .getValue () .copy () .straighten (upVector ?.getValue ()));
   },
   toStream (generator)
   {
      const { x, y, z, angle } = this .getValue ();

      generator .string += generator .DoubleFormat (x);
      generator .string += generator .Space ();
      generator .string += generator .DoubleFormat (y);
      generator .string += generator .Space ();
      generator .string += generator .DoubleFormat (z);
      generator .string += generator .Space ();
      generator .string += generator .DoubleFormat (generator .ToUnit ("angle", angle));
   },
   toVRMLStream (generator)
   {
      this .toStream (generator);
   },
   toXMLStream (generator)
   {
      this .toStream (generator);
   },
   toJSONStream (generator)
   {
      generator .string += '[';
      generator .string += generator .TidySpace ();

      this .toJSONStreamValue (generator);

      generator .string += generator .TidySpace ();
      generator .string += ']';
   },
   toJSONStreamValue (generator)
   {
      const { x, y, z, angle } = this .getValue ();

      generator .string += generator .Number (generator .DoubleFormat (x));
      generator .string += ',';
      generator .string += generator .TidySpace ();
      generator .string += generator .Number (generator .DoubleFormat (y));
      generator .string += ',';
      generator .string += generator .TidySpace ();
      generator .string += generator .Number (generator .DoubleFormat (z));
      generator .string += ',';
      generator .string += generator .TidySpace ();
      generator .string += generator .Number (generator .DoubleFormat (generator .ToUnit ("angle", angle)));
   },
});

for (const key of Object .keys (SFRotation .prototype))
   Object .defineProperty (SFRotation .prototype, key, { enumerable: false });

const x = {
   get ()
   {
      return this .getValue () .x;
   },
   set (value)
   {
      this .getValue () .x = +value;
      this .addEvent ();
   },
};

const y = {
   get ()
   {
      return this .getValue () .y;
   },
   set (value)
   {
      this .getValue () .y = +value;
      this .addEvent ();
   },
};

const z = {
   get ()
   {
      return this .getValue () .z;
   },
   set (value)
   {
      this .getValue () .z = +value;
      this .addEvent ();
   },
};

const angle = {
   get ()
   {
      return this .getValue () .angle;
   },
   set (value)
   {
      this .getValue () .angle = +value;
      this .addEvent ();
   },
};

Object .defineProperties (SFRotation .prototype,
{
   0: x,
   1: y,
   2: z,
   3: angle,
   x: Object .assign ({ enumerable: true }, x),
   y: Object .assign ({ enumerable: true }, y),
   z: Object .assign ({ enumerable: true }, z),
   angle: Object .assign ({ enumerable: true }, angle),
});

Object .defineProperties (SFRotation,
{
   typeName:
   {
      value: "SFRotation",
      enumerable: true,
   },
});

const SFRotation_default_ = SFRotation;
;

/* harmony default export */ const Fields_SFRotation = (Namespace/* default */.A .add ("SFRotation", SFRotation_default_));
// EXTERNAL MODULE: ./src/standard/Math/Numbers/Vector2.js
var Vector2 = __webpack_require__(923);
;// ./src/x_ite/Fields/SFVec2.js




function SFVec2Template (TypeName, double)
{
   function SFVec2 (x, y)
   {
      switch (arguments .length)
      {
         case 0:
            X3DField/* default */.A .call (this, new Vector2/* default */.A ());
            break;

         case 1:
            X3DField/* default */.A .call (this, arguments [0]);
            break;

         case 2:
            X3DField/* default */.A .call (this, new Vector2/* default */.A (+x, +y));
            break;

         default:
            throw new Error ("Invalid arguments.");
      }
   }

   return Fields_SFVecPrototypeTemplate (SFVec2, TypeName, Vector2/* default */.A, double);
}

const SFVec2 = {
   SFVec2d: SFVec2Template ("SFVec2d", true),
   SFVec2f: SFVec2Template ("SFVec2f", false),
};

const SFVec2_default_ = SFVec2;
;

/* harmony default export */ const Fields_SFVec2 = (Namespace/* default */.A .add ("SFVec2", SFVec2_default_));
// EXTERNAL MODULE: ./src/standard/Math/Numbers/Vector4.js
var Vector4 = __webpack_require__(8913);
;// ./src/x_ite/Fields/SFVec4.js




function SFVec4Template (TypeName, double)
{
   function SFVec4 (x, y, z, w)
   {
      switch (arguments .length)
      {
         case 0:
            X3DField/* default */.A .call (this, new Vector4/* default */.A (0, 0, 0, 1));
            break;

         case 1:
            X3DField/* default */.A .call (this, arguments [0]);
            break;

         case 4:
            X3DField/* default */.A .call (this, new Vector4/* default */.A (+x, +y, +z, +w));
            break;

         default:
            throw new Error ("Invalid arguments.");
      }
   }

   return Fields_SFVecPrototypeTemplate (SFVec4, TypeName, Vector4/* default */.A, double,
   {
      isDefaultValue ()
      {
         return this .getValue () .equals (Vector4/* default */.A .W_AXIS);
      },
   });
}

const SFVec4 = {
   SFVec4d: SFVec4Template ("SFVec4d", true),
   SFVec4f: SFVec4Template ("SFVec4f", false),
};

const SFVec4_default_ = SFVec4;
;

/* harmony default export */ const Fields_SFVec4 = (Namespace/* default */.A .add ("SFVec4", SFVec4_default_));
// EXTERNAL MODULE: ./src/x_ite/Base/X3DArrayField.js
var X3DArrayField = __webpack_require__(282);
;// ./src/x_ite/Base/X3DObjectArrayField.js



const
   _target = Symbol (),
   _proxy  = Symbol (),
   _insert = Symbol (),
   _erase  = Symbol ();

const handler =
{
   get (target, key)
   {
      const value = target [key];

      if (value !== undefined)
         return value;

      if (typeof key === "string")
      {
         const
            array = target .getValue (),
            index = +key;

         if (Number .isInteger (index))
         {
            // For historical reasons this behavior is intended (resize), there are enough
            // X3D/VRML worlds in the Internet who rely on this behavior.
            if (index >= array .length)
               target .resize (index + 1);

            return array [index] .valueOf ();
         }
         else
         {
            return target [key];
         }
      }
   },
   set (target, key, value)
   {
      if (key in target)
      {
         target [key] = value;
         return true;
      }

      const
         array = target .getValue (),
         index = +key;

      if (index >= array .length)
         target .resize (index + 1);

      array [index] .setValue (value);

      return true;
   },
   has (target, key)
   {
      if (Number .isInteger (+key))
         return key < target .getValue () .length;

      return key in target;
   },
   ownKeys (target)
   {
      return Object .keys (target .getValue ());
   },
   getOwnPropertyDescriptor (target, key)
   {
      if (typeof key !== "string")
         return;

      const index = +key;

      if (Number .isInteger (index) && index < target .getValue () .length)
         return Object .getOwnPropertyDescriptor (target .getValue (), key);
   },
};

function X3DObjectArrayField (values)
{
   const proxy = new Proxy (this, handler);

   X3DArrayField/* default */.A .call (this, [ ]);

   this [_target] = this;
   this [_proxy]  = proxy;

   for (const value of values)
      this .push (value);

   return proxy;
}

Object .assign (Object .setPrototypeOf (X3DObjectArrayField .prototype, X3DArrayField/* default */.A .prototype),
{
   [_target]: null,
   [_proxy]: null,
   *[Symbol .iterator] ()
   {
      const
         target = this [_target],
         array  = target .getValue ();

      for (const value of array)
         yield value .valueOf ();
   },
   getTarget ()
   {
      return this [_target];
   },
   copy ()
   {
      const
         target = this [_target],
         copy   = target .create ();

      copy .assign (target);

      return copy;
   },
   equals (array)
   {
      const
         target = this [_target],
         a      = target .getValue (),
         b      = array .getValue (),
         length = a .length;

      if (a === b)
         return true;

      if (length !== b .length)
         return false;

      for (let i = 0; i < length; ++ i)
      {
         if (!a [i] .equals (b [i]))
            return false;
      }

      return true;
   },
   isDefaultValue ()
   {
      return this .length === 0;
   },
   set (value)
   {
      const
         target    = this [_target],
         array     = target .getValue (),
         newLength = value .length;

      target .resize (newLength, undefined, true);

      for (let i = 0; i < newLength; ++ i)
         array [i] .set (value [i] instanceof X3DField/* default */.A ? value [i] .getValue () : value [i]);
   },
   setValue (value)
   {
      const target = this [_target];

      target .set (value instanceof X3DObjectArrayField ? value .getValue () : value);
      target .addEvent ();
   },
   unshift (... args)
   {
      const
         target = this [_target],
         array  = target .getValue ();

      for (let i = args .length - 1; i >= 0; -- i)
      {
         const field = new (target .getSingleType ()) ();

         field .setValue (args [i]);
         target .addChildObject (field);
         array .unshift (field);
      }

      target .addEvent ();

      return array .length;
   },
   shift ()
   {
      const
         target = this [_target],
         array  = target .getValue ();

      if (array .length)
      {
         const
            field  = array .shift (),
            result = field .valueOf ();

         target .removeChildObject (field);
         target .addEvent ();

         return result;
      }
   },
   push (... args)
   {
      const
         target = this [_target],
         array  = target .getValue ();

      for (const argument of args)
      {
         const field = new (target .getSingleType ()) ();

         field .setValue (argument);
         target .addChildObject (field);
         array .push (field);
      }

      target .addEvent ();

      return array .length;
   },
   pop ()
   {
      const
         target = this [_target],
         array  = target .getValue ();

      if (array .length)
      {
         const
            field  = array .pop (),
            result = field .valueOf ();

         target .removeChildObject (field);
         target .addEvent ();

         return result;
      }
   },
   splice (index, deleteCount, ... insertValues)
   {
      const
         target = this [_target],
         array  = target .getValue (),
         length = array .length;

      if (arguments .length === 0)
         return new (target .constructor) ();

      if (arguments .length < 2)
         deleteCount = length;

      const result = target [_erase] (index, deleteCount);

      if (insertValues .length)
         target [_insert] (index, insertValues);

      return result;
   },
   [_insert] (index, array)
   {
      const
         target = this [_target],
         args   = [ ];

      for (const value of array)
      {
         const field = new (target .getSingleType ()) ();

         field .setValue (value);
         target .addChildObject (field);
         args .push (field);
      }

      target .getValue () .splice (index, 0, ... args);
      target .addEvent ();
   },
   [_erase] (index, deleteCount)
   {
      const
         target = this [_target],
         values = target .getValue () .splice (index, deleteCount),
         result = new (target .constructor) ();

      for (const value of values)
      {
         result .push (value);
         target .removeChildObject (value);
      }

      target .addEvent ();

      return result;
   },
   resize (newLength, value, silently)
   {
      const
         target = this [_target],
         array  = target .getValue (),
         length = array .length;

      if (newLength < 0)
         throw new RangeError ("Invalid array length");

      if (newLength < length)
      {
         for (let i = newLength; i < length; ++ i)
            target .removeChildObject (array [i]);

         array .length = newLength;

         if (!silently)
            target .addEvent ();
      }
      else if (newLength > length)
      {
         for (let i = length; i < newLength; ++ i)
         {
            const field = new (target .getSingleType ()) ();

            if (value !== undefined)
               field .setValue (value);

            target .addChildObject (field);
            array .push (field);
         }

         if (!silently)
            target .addEvent ();
      }
   },
   addChildObject (value)
   {
      value .addParent (this [_proxy]);
   },
   removeChildObject (value)
   {
      value .dispose ();
   },
   shrinkToFit ()
   {
      return this .getValue ();
   },
   concat (... args)
   {
      const
         result = this .copy (),
         target = result [_target];

      for (const arg of args)
      {
         for (const value of arg)
            target .push (value);
      }

      return result;
   },
   reverse ()
   {
      const target = this [_target];

      target .getValue () .reverse ();
      target .addEvent ();

      return target [_proxy];
   },
   sort (compareFn)
   {
      const target = this [_target];

      Array .prototype .sort .call (this, compareFn);
      target .addEvent ();

      return target [_proxy];
   },
   valueOf ()
   {
      return this [_proxy];
   },
   toStream (generator)
   {
      const
         target = this [_target],
         array  = target .getValue ();

      switch (array .length)
      {
         case 0:
         {
            generator .string += "[";
            generator .string += generator .TidySpace ();
            generator .string += "]";
            break;
         }
         case 1:
         {
            array [0] .toStream (generator);
            break;
         }
         default:
         {
            generator .string += "[";
            generator .string += generator .ListStart ();
            generator .IncIndent ();

            for (let i = 0, length = array .length - 1; i < length; ++ i)
            {
               generator .string += generator .ListIndent ();
               array [i] .toStream (generator);
               generator .string += generator .Comma ();
               generator .string += generator .ListBreak ();
            }

            generator .string += generator .ListIndent ();
            array .at (-1) .toStream (generator);

            generator .string += generator .ListEnd ();
            generator .DecIndent ();
            generator .string += generator .ListIndent ();
            generator .string += "]";
            break;
         }
      }
   },
   toVRMLStream (generator)
   {
      this .toStream (generator);
   },
   toXMLStream (generator)
   {
      const
         target = this [_target],
         length = target .length;

      if (length)
      {
         const array = target .getValue ();

         for (let i = 0, length = array .length - 1; i < length; ++ i)
         {
            array [i] .toXMLStream (generator);
            generator .string += generator .Comma ();
            generator .string += generator .TidySpace ();
         }

         array .at (-1) .toXMLStream (generator);
      }
   },
   toJSONStream (generator)
   {
      const
         target = this [_target],
         length = target .length;

      if (length)
      {
         const value = this .getValue ();

         generator .string += '[';
         generator .string += generator .ListBreak ();
         generator .string += generator .IncIndent ();

         for (let i = 0, n = length - 1; i < n; ++ i)
         {
            generator .string += generator .ListIndent ();

            value [i] .toJSONStreamValue (generator);

            generator .string += ',';
            generator .string += generator .ListBreak ();
         }

         generator .string += generator .ListIndent ();

         value .at (-1) .toJSONStreamValue (generator);

         generator .string += generator .ListBreak ();
         generator .string += generator .DecIndent ();
         generator .string += generator .ListIndent ();
         generator .string += ']';
      }
      else
      {
         generator .string += '[';
         generator .string += generator .TidySpace ();
         generator .string += ']';
      }
   },
});

for (const key of Object .keys (X3DObjectArrayField .prototype))
   Object .defineProperty (X3DObjectArrayField .prototype, key, { enumerable: false });

Object .defineProperty (X3DObjectArrayField .prototype, "length",
{
   get () { return this [_target] .getValue () .length; },
   set (value) { this [_target] .resize (value); },
});

const X3DObjectArrayField_default_ = X3DObjectArrayField;
;

/* harmony default export */ const Base_X3DObjectArrayField = (Namespace/* default */.A .add ("X3DObjectArrayField", X3DObjectArrayField_default_));
// EXTERNAL MODULE: ./src/standard/Math/Algorithm.js
var Algorithm = __webpack_require__(780);
;// ./src/x_ite/Base/X3DTypedArrayField.js



const
   X3DTypedArrayField_target = Symbol (),
   X3DTypedArrayField_proxy  = Symbol (),
   _cache  = Symbol (),
   _tmp    = Symbol (),
   _length = Symbol (),
   X3DTypedArrayField_insert = Symbol (),
   X3DTypedArrayField_erase  = Symbol (),
   _grow   = Symbol (),
   _fill   = Symbol ();

const X3DTypedArrayField_handler =
{
   get (target, key)
   {
      const value = target [key];

      if (value !== undefined)
         return value;

      if (typeof key === "string")
      {
         const index = +key;

         if (Number .isInteger (index))
         {
            const
               components = target .getComponents (),
               valueType  = target .getValueType ();

            // For historical reasons this behavior is intended (resize), there are
            // enough X3D/VRML worlds in the Internet who rely on this behavior.
            const array = index < target [_length]
               ? target .getValue ()
               : target .resize (index + 1, target .getSingleValue ());

            if (components === 1)
            {
               // Return native JavaScript value.
               return valueType (array [index]);
            }
            else
            {
               // Return reference to index.

               return target [_cache] [index]
                  ?? (target [_cache] [index] = createValue (target, index, components, valueType));
            }
         }
         else
         {
            return target [key];
         }
      }
   },
   set (target, key, value)
   {
      if (key in target)
      {
         target [key] = value;
         return true;
      }

      const components = target .getComponents ();

      let
         index = +key,
         array = target .getValue ();

      if (index >= target [_length])
         array = target .resize (index + 1, target .getSingleValue ());

      if (components === 1)
      {
         const valueType = target .getValueType ();

         array [index] = valueType (value);
      }
      else
      {
         index *= components;

         for (let c = 0; c < components; ++ c, ++ index)
            array [index] = value [c];
      }

      target .addEvent ();

      return true;
   },
   has (target, key)
   {
      if (Number .isInteger (+key))
         return key < target [_length];

      return key in target;
   },
   ownKeys (target)
   {
      const ownKeys = [ ];

      for (let i = 0, length = target [_length]; i < length; ++ i)
         ownKeys .push (String (i));

      return ownKeys;
   },
   getOwnPropertyDescriptor (target, key)
   {
      if (typeof key !== "string")
         return;

      const index = +key;

      if (Number .isInteger (index) && index < target [_length])
         return Object .getOwnPropertyDescriptor (target .getValue (), key);
   },
};

function X3DTypedArrayField (values)
{
   const proxy = new Proxy (this, X3DTypedArrayField_handler);

   X3DArrayField/* default */.A .call (this, new (this .getArrayType ()) (16));

   this [X3DTypedArrayField_target] = this;
   this [X3DTypedArrayField_proxy]  = proxy;

   if (this .getComponents () > 1)
   {
      this [_cache] = [ ]; // Cache of elements.
      this [_tmp]   = [ ]; // Array with components size.
   }

   for (const value of values)
      this .push (value);

   return proxy;
}

Object .assign (Object .setPrototypeOf (X3DTypedArrayField .prototype, X3DArrayField/* default */.A .prototype),
{
   [X3DTypedArrayField_target]: null,
   [_tmp]: null,
   [_length]: 0,
   *[Symbol .iterator] ()
   {
      const
         target     = this [X3DTypedArrayField_target],
         array      = target .getValue (),
         components = target .getComponents (),
         valueType  = target .getValueType (),
         length     = target [_length];

      if (components === 1)
      {
         // Return native JavaScript value.

         for (let index = 0; index < length; ++ index)
            yield valueType (array [index]);
      }
      else
      {
         // Return reference to index.

         const cache = target [_cache];

         for (let index = 0; index < length; ++ index)
         {
            yield cache [index]
               ?? (cache [index] = createValue (target, index, components, valueType));
         }
      }
   },
   getTarget ()
   {
      return this [X3DTypedArrayField_target];
   },
   copy ()
   {
      const
         target = this [X3DTypedArrayField_target],
         array  = target .getValue (),
         copy   = target .create ();

      copy .set (array, target [_length]);

      return copy;
   },
   equals (other)
   {
      const
         target      = this [X3DTypedArrayField_target],
         otherTarget = other [X3DTypedArrayField_target],
         length      = target [_length];

      if (target === otherTarget)
         return true;

      if (length !== otherTarget [_length])
         return false;

      const
         a = target .getValue (),
         b = otherTarget .getValue (),
         l = length * target .getComponents ();

      for (let i = 0; i < l; ++ i)
      {
         if (a [i] !== b [i])
            return false;
      }

      return true;
   },
   assign (value)
   {
      const target = this [X3DTypedArrayField_target];

      target .set (value .getValue (), value .length);
      target .addEvent ();
   },
   set (otherArray /* value of field */, l /* length of field */)
   {
      const
         target      = this [X3DTypedArrayField_target],
         components  = target .getComponents (),
         length      = target [_length];

      let
         array       = target .getValue (),
         otherLength = l !== undefined ? l * components : otherArray .length;

      const rest = otherLength % components;

      if (rest)
      {
         otherLength -= rest;

         console .warn (`Array length must be multiple of components size, which is ${components}.`);
      }

      otherLength /= components;

      if (array .length < otherArray .length)
      {
         array = target [_grow] (otherArray .length);

         array .set (otherArray);

         if (rest)
            array .fill (0, otherLength * components, otherLength * components + rest);
      }
      else
      {
         array .set (otherArray);

         if (otherLength < length)
            array .fill (0, otherLength * components, length * components);
      }

      target [_length] = otherLength;
   },
   isDefaultValue ()
   {
      return this [_length] === 0;
   },
   setValue (value)
   {
      const target = this [X3DTypedArrayField_target];

      if (value instanceof target .constructor)
      {
         target .assign (value);
      }
      else
      {
         target .set (value);
         target .addEvent ();
      }
   },
   unshift (... args)
   {
      const
         target          = this [X3DTypedArrayField_target],
         components      = target .getComponents (),
         length          = target [_length],
         argumentsLength = args .length,
         array           = target [_grow] ((length + argumentsLength) * components);

      array .copyWithin (argumentsLength * components, 0, length * components);

      if (components === 1)
      {
         const valueType = target .getValueType ();

         for (let a = 0; a < argumentsLength; ++ a)
            array [a] = valueType (args [a]);
      }
      else
      {
         for (let i = 0, a = 0; a < argumentsLength; ++ a)
         {
            const argument = args [a];

            for (let c = 0; c < components; ++ c, ++ i)
            {
               array [i] = argument [c];
            }
         }
      }

      target [_length] += argumentsLength;

      target .addEvent ();

      return target [_length];
   },
   shift ()
   {
      const
         target = this [X3DTypedArrayField_target],
         length = target [_length];

      if (length)
      {
         const
            array      = target .getValue (),
            components = target .getComponents (),
            valueType  = target .getValueType (),
            newLength  = length - 1;

         let value;

         if (components === 1)
         {
            value = valueType (array [0]);
         }
         else
         {
            const tmp = target [_tmp];

            for (let c = 0; c < components; ++ c)
               tmp [c] = array [c];

            value = new valueType (... tmp);
         }

         array .copyWithin (0, components, length * components);
         array .fill (0, components * newLength, length * components);

         target [_length] = newLength;

         target .addEvent ();
         return value;
      }
   },
   push (... args)
   {
      const
         target          = this [X3DTypedArrayField_target],
         components      = target .getComponents (),
         length          = target [_length],
         argumentsLength = args .length,
         array           = target [_grow] ((length + argumentsLength) * components);

      if (components === 1)
      {
         const valueType = target .getValueType ();

         for (let a = 0, i = length; a < argumentsLength; ++ a, ++ i)
            array [i] = valueType (args [a]);
      }
      else
      {
         for (let i = length * components, a = 0; a < argumentsLength; ++ a)
         {
            const argument = args [a];

            for (let c = 0; c < components; ++ c,  ++ i)
            {
               array [i] = argument [c];
            }
         }
      }

      target [_length] += argumentsLength;

      target .addEvent ();

      return target [_length];
   },
   pop ()
   {
      const
         target = this [X3DTypedArrayField_target],
         length = target [_length];

      if (length)
      {
         const
            array      = target .getValue (),
            components = target .getComponents (),
            valueType  = target .getValueType (),
            newLength  = length - 1;

         let value;

         if (components === 1)
         {
            value = valueType (array [length - 1]); // Don't use at(-1).
         }
         else
         {
            const tmp = target [_tmp];

            for (let c = 0, a = newLength * components; c < components; ++ c, ++ a)
               tmp [c] = array [a];

            value = new valueType (... tmp);
         }

         array .fill (0, newLength * components, length * components);

         target [_length] = newLength;

         target .addEvent ();

         return value;
      }
   },
   splice (index, deleteCount, ... insertValues)
   {
      const
         target = this [X3DTypedArrayField_target],
         length = target [_length];

      if (arguments .length === 0)
         return new (target .constructor) ();

      index |= 0;

      if (index < 0)
         index += length;

      index = Algorithm/* default */.A .clamp (index, 0, length);

      if (arguments .length < 2)
         deleteCount = length;

      deleteCount |= 0;

      if (index + deleteCount > length)
         deleteCount = length - index;

      deleteCount = Math .max (deleteCount, 0);

      const result = target [X3DTypedArrayField_erase] (index, index + deleteCount);

      if (insertValues .length)
         target [X3DTypedArrayField_insert] (index, insertValues);

      target .addEvent ();

      return result;
   },
   [X3DTypedArrayField_insert] (index, other)
   {
      const
         target      = this [X3DTypedArrayField_target],
         components  = target .getComponents (),
         length      = target [_length],
         otherLength = other .length,
         array       = target [_grow] ((length + otherLength) * components);

      index *= components;

      array .copyWithin (index + otherLength * components, index, length * components);

      if (components === 1)
      {
         const valueType = target .getValueType ();

         for (let a = 0, i = index; a < otherLength; ++ a, ++ i)
            array [i] = valueType (other [a]);
      }
      else
      {
         for (let i = 0, a = index; i < otherLength; ++ i)
         {
            const value = other [i];

            for (let c = 0; c < components; ++ c, ++ a)
               array [a] = value [c];
         }
      }

      target [_length] += otherLength;
   },
   [X3DTypedArrayField_erase] (first, last)
   {
      const
         target     = this [X3DTypedArrayField_target],
         array      = target .getValue (),
         components = target .getComponents (),
         difference = last - first,
         length     = target [_length],
         newLength  = length - difference,
         values     = target [X3DTypedArrayField_proxy] .slice (first, last);

      first *= components;
      last  *= components;

      array .copyWithin (first, last, length * components);
      array .fill (0, newLength * components, length * components);

      target [_length] = newLength;

      if (components > 1)
         target [_cache] .length = newLength;

      target .addEvent ();

      return values;
   },
   resize (newLength, value, silently)
   {
      const
         target     = this [X3DTypedArrayField_target],
         length     = target [_length],
         components = target .getComponents ();

      if (newLength < 0)
         throw new RangeError ("Invalid array length");

      let array = target .getValue ();

      target [_length] = newLength;

      if (newLength < length)
      {
         array .fill (0, newLength * components, length * components);

         if (components > 1)
            target [_cache] .length = newLength;

         if (!silently)
            target .addEvent ();
      }
      else if (newLength > length)
      {
         array = target [_grow] (newLength * components);

         if (value !== undefined)
            this [_fill] (value, length, newLength);

         if (!silently)
            target .addEvent ();
      }

      return array;
   },
   [_grow] (length)
   {
      const
         target = this [X3DTypedArrayField_target],
         array  = target .getValue ();

      if (length <= array .length)
         return array;

      const
         maxLength = Algorithm/* default */.A .nextPowerOfTwo (length),
         newArray  = new (target .getArrayType ()) (maxLength);

      newArray .set (array);

      X3DArrayField/* default */.A .prototype .set .call (target, newArray);

      return newArray;
   },
   shrinkToFit ()
   {
      const
         target = this [X3DTypedArrayField_target],
         array  = target .getValue (),
         length = target [_length] * target .getComponents ();

      if (array .length === length)
         return array;

      const newArray = array .subarray (0, length);

      X3DArrayField/* default */.A .prototype .set .call (target, newArray);

      return newArray;
   },
   concat (... args)
   {
      const
         result     = this .copy (),
         target     = result [X3DTypedArrayField_target],
         components = target .getComponents (),
         length     = target [_length] + args .reduce ((p, c) => p + c .length, 0),
         value      = target [_grow] (length * components);

      let offset = target [_length] * components;

      for (const arg of args)
      {
         value .set (arg .shrinkToFit (), offset);

         offset += arg .length * components;
      }

      target [_length] = length;

      return result;
   },
   flat ()
   {
      const
         target     = this [X3DTypedArrayField_target],
         array      = target .shrinkToFit (),
         components = target .getComponents (),
         valueType  = target .getValueType ();

      if (components === 1)
         return Array .from (array, value => valueType (value));

      return Array .from (array);
   },
   flatMap (... args)
   {
      return this .map (...args) .flat ();
   },
   [_fill] (value, start = 0, end = this .length)
   {
      const
         target     = this [X3DTypedArrayField_target],
         length     = target [_length],
         array      = target .getValue (),
         components = target .getComponents ();

      if (-length <= start && start < 0)
         start = start + length;

      if (start < -length)
         start = 0;

      if (start >= length)
         return;

      if (-length <= end && end < 0)
         end = end + length;

      if (end < -length)
         end = 0;

      if (end >= length)
         end = length;

      if (start >= end)
         return;

      if (components === 1)
      {
         const valueType = target .getValueType ();

         array .fill (valueType (value), start * components, end * components);
      }
      else
      {
         // More efficient way to copy repeating sequence into TypedArray?
         // https://stackoverflow.com/questions/46313130/more-efficient-way-to-copy-repeating-sequence-into-typedarray

         const
            i0 = start * components,
            il = end * components;

         for (let i = i0, c = 0; c < components; ++ i, ++ c)
         {
            array [i] = value [c];
         }

         let
            i = i0 + components,
            c = components;

         while (i < il)
         {
            const sl = i + c > il ? il - i : c;

            array .copyWithin (i, i0, i0 + sl);

            i  += c;
            c <<= 1;
         }
      }

      return target [X3DTypedArrayField_proxy];
   },
   fill (value, start = 0, end = this .length)
   {
      const target = this [X3DTypedArrayField_target];

      this [_fill] (value, start, end);

      target .addEvent ();

      return target [X3DTypedArrayField_proxy];
   },
   reverse ()
   {
      const
         target     = this [X3DTypedArrayField_target],
         array      = target .getValue (),
         components = target .getComponents (),
         length     = target [_length] * components,
         length1_2  = Math .floor (target [_length] / 2) * components;

      if (components === 1)
      {
         for (let i = 0; i < length1_2; ++ i)
         {
            const
               i2 = length - i - 1,
               t  = array [i];

            array [i]  = array [i2];
            array [i2] = t;
         }
      }
      else
      {
         for (let i = 0; i < length1_2; i += components)
         {
            for (let c = 0; c < components; ++ c)
            {
               const
                  i1 = i + c,
                  i2 = length - i - 1 - (components - c - 1),
                  t  = array [i1];

               array [i1] = array [i2];
               array [i2] = t;
            }
         }
      }

      target .addEvent ();

      return target [X3DTypedArrayField_proxy];
   },
   sort (compareFn)
   {
      const
         target     = this [X3DTypedArrayField_target],
         array      = target .getValue (),
         components = target .getComponents (),
         length     = target [_length];

      if (components === 1)
      {
         const valueType = target .getValueType ();

         const cmp = compareFn
            ? (a, b) => compareFn (valueType (a), valueType (b))
            : Algorithm/* default */.A .cmp;

         target .set (array .subarray (0, length) .sort (cmp));
      }
      else
      {
         const result = Array .from (target [X3DTypedArrayField_proxy], value => value .copy ())
            .sort (compareFn ?? ((a, b) =>
         {
            for (let c = 0; c < components; ++ c)
            {
               if (a [c] < b [c])
                  return -1;

               if (b [c] < a [c])
                  return 1;
            }

            return 0;
         }));

         for (let i = 0; i < length; ++ i)
         {
            const value = result [i];

            for (let c = 0, first = i * components; c < components; ++ c, ++ first)
               array [first] = value [c];
         }
      }

      target .addEvent ();

      return target [X3DTypedArrayField_proxy];
   },
   valueOf ()
   {
      return this [X3DTypedArrayField_proxy];
   },
   toStream (generator)
   {
      const
         target     = this [X3DTypedArrayField_target],
         array      = target .getValue (),
         length     = target [_length],
         components = target .getComponents (),
         value      = new (target .getSingleType ()) ();

      value .setUnit (target .getUnit ());

      switch (length)
      {
         case 0:
         {
            generator .string += "[";
            generator .string += generator .TidySpace ();
            generator .string += "]";
            break;
         }
         case 1:
         {
            if (components === 1)
            {
               value .set (array [0]);
               value .toStream (generator);
            }
            else
            {
               for (let c = 0, first = 0; c < components; ++ c, ++ first)
                  value [c] = array [first];

               value .toStream (generator);
            }

            break;
         }
         default:
         {
            generator .string += "[";
            generator .string += generator .ListStart ();
            generator .IncIndent ();

            if (components === 1)
            {
               for (let i = 0, n = length - 1; i < n; ++ i)
               {
                  generator .string += generator .ListIndent ();

                  value .set (array [i * components]);
                  value .toStream (generator);

                  generator .string += generator .Comma ();
                  generator .string += generator .ListBreak ();
               }

               generator .string += generator .ListIndent ();
               value .set (array [(length - 1) * components]);
               value .toStream (generator);
            }
            else
            {
               for (let i = 0, n = length - 1; i < n; ++ i)
               {
                  generator .string += generator .ListIndent ();

                  for (let c = 0, first = i * components; c < components; ++ c, ++ first)
                     value [c] = array [first];

                  value .toStream (generator);

                  generator .string += generator .Comma ();
                  generator .string += generator .ListBreak ();
               }

               generator .string += generator .ListIndent ();

               for (let c = 0, first = (length - 1) * components; c < components; ++ c, ++ first)
                  value [c] = array [first];

               value .toStream (generator);
            }

            generator .string += generator .ListEnd ();
            generator .DecIndent ();
            generator .string += generator .ListIndent ();
            generator .string += "]";
            break;
         }
      }
   },
   toVRMLStream (generator)
   {
      this .toStream (generator);
   },
   toXMLStream (generator)
   {
      const
         target = this [X3DTypedArrayField_target],
         length = target [_length];

      if (length)
      {
         const
            array      = target .getValue (),
            components = target .getComponents (),
            value      = new (target .getSingleType ()) ();

         value .setUnit (target .getUnit ());

         if (components === 1)
         {
            for (let i = 0, n = length - 1; i < n; ++ i)
            {
               value .set (array [i * components]);
               value .toXMLStream (generator);

               generator .string += generator .Comma ();
               generator .string += generator .TidySpace ();
            }

            value .set (array [(length - 1) * components]);

            value .toXMLStream (generator);
         }
         else
         {
            for (let i = 0, n = length - 1; i < n; ++ i)
            {
               for (let c = 0, first = i * components; c < components; ++ c, ++ first)
                  value [c] = array [first];

               value .toXMLStream (generator);

               generator .string += generator .Comma ();
               generator .string += generator .TidySpace ();
            }

            for (let c = 0, first = (length - 1) * components; c < components; ++ c, ++ first)
               value [c] = array [first];

            value .toXMLStream (generator);
         }
      }
   },
   toJSONStream (generator)
   {
      const
         target = this [X3DTypedArrayField_target],
         length = target .length;

      if (length)
      {
         const
            array      = target .getValue (),
            components = target .getComponents (),
            value      = new (target .getSingleType ()) ();

         value .setUnit (target .getUnit ());

         generator .string += '[';
         generator .string += generator .ListBreak ();
         generator .string += generator .IncIndent ();

         if (components === 1)
         {
            for (let i = 0, n = length - 1; i < n; ++ i)
            {
               generator .string += generator .ListIndent ();

               value .set (array [i * components]);
               value .toJSONStreamValue (generator);

               generator .string += ',';
               generator .string += generator .ListBreak ();
            }

            generator .string += generator .ListIndent ();

            value .set (array [(length - 1) * components]);
            value .toJSONStreamValue (generator);
         }
         else
         {
            for (let i = 0, n = length - 1; i < n; ++ i)
            {
               generator .string += generator .ListIndent ();

               for (let c = 0, first = i * components; c < components; ++ c, ++ first)
                  value [c] = array [first];

               value .toJSONStreamValue (generator);

               generator .string += ',';
               generator .string += generator .ListBreak ();
            }

            generator .string += generator .ListIndent ();

            for (let c = 0, first = (length - 1) * components; c < components; ++ c, ++ first)
               value [c] = array [first];

            value .toJSONStreamValue (generator);
         }

         generator .string += generator .ListBreak ();
         generator .string += generator .DecIndent ();
         generator .string += generator .ListIndent ();
         generator .string += ']';
      }
      else
      {
         generator .string += '[';
         generator .string += generator .TidySpace ();
         generator .string += ']';
      }
   },
   dispose ()
   {
      X3DArrayField/* default */.A .prototype .dispose .call (this [X3DTypedArrayField_target]);
   },
});

for (const key of Object .keys (X3DTypedArrayField .prototype))
   Object .defineProperty (X3DTypedArrayField .prototype, key, { enumerable: false });

Object .defineProperty (X3DTypedArrayField .prototype, "length",
{
   get () { return this [_length]; },
   set (value)
   {
      const target = this [X3DTypedArrayField_target];

      target .resize (value, target .getSingleValue ());
   },
});

// Getter/Setter functions to reference a value for a given index.

function createValue (target, index, components, valueType)
{
   const
      value         = new valueType (),
      internalValue = value .getValue (),
      i             = index * components;

   Object .defineProperties (value,
   {
      addEvent:
      {
         value: addEvent .bind (target, i, components, internalValue),
         configurable: true,
      },
      getValue:
      {
         value: getValue .bind (target, i, components, internalValue),
         configurable: true,
      },
   });

   return value;
}

function getValue (index, components, internalValue)
{
   const array = this .getValue ();

   for (let c = 0; c < components; ++ c, ++ index)
      internalValue [c] = array [index];

   return internalValue;
}

function addEvent (index, components, internalValue)
{
   const array = this .getValue ();

   for (let c = 0; c < components; ++ c, ++ index)
      array [index] = internalValue [c];

   this .addEvent ();
}

const X3DTypedArrayField_default_ = X3DTypedArrayField;
;

/* harmony default export */ const Base_X3DTypedArrayField = (Namespace/* default */.A .add ("X3DTypedArrayField", X3DTypedArrayField_default_));
;// ./src/x_ite/Fields/ArrayFields.js


















const
   { SFBool, SFDouble, SFFloat, SFInt32, SFString, SFTime } = Fields_SFScalar,
   { SFMatrix3d: ArrayFields_SFMatrix3d, SFMatrix3f: ArrayFields_SFMatrix3f } = Fields_SFMatrix3,
   { SFMatrix4d, SFMatrix4f } = Fields_SFMatrix4,
   { SFVec2d, SFVec2f }       = Fields_SFVec2,
   { SFVec3d: ArrayFields_SFVec3d, SFVec3f: ArrayFields_SFVec3f }       = Fields_SFVec3,
   { SFVec4d, SFVec4f }       = Fields_SFVec4;

/*
 *  MFNode
 */

function MFNode (... args)
{
   return Base_X3DObjectArrayField .call (this, args);
}

Object .assign (Object .setPrototypeOf (MFNode .prototype, Base_X3DObjectArrayField .prototype),
{
   getSingleType ()
   {
      return SFNode/* default */.A;
   },
   copy (instance)
   {
      if (instance)
      {
         const copy = new MFNode ();

         for (const node of this .getValue ())
            copy .push (node .copy (instance));

         return copy;
      }
      else
      {
         return Base_X3DObjectArrayField .prototype .copy .call (this);
      }
   },
   toStream (generator)
   {
      const
         target = this .getTarget (),
         array  = target .getValue (),
         length = array .length;

      switch (length)
      {
         case 0:
         {
            generator .string += "[";
            generator .string += generator .TidySpace ();
            generator .string += "]";
            break;
         }
         case 1:
         {
            array [0] .toStream (generator);
            break;
         }
         default:
         {
            generator .string += "[";
            generator .string += generator .TidyBreak ();
            generator .IncIndent ();

            for (let i = 0; i < length; ++ i)
            {
               generator .string += generator .Indent ();
               array [i] .toStream (generator);
               generator .string += generator .string .at (-1) === "}" ? generator .TidyBreak () : generator .Break ();
            }

            generator .DecIndent ();
            generator .string += generator .Indent ();
            generator .string += "]";
            break;
         }
      }
   },
   toVRMLStream (generator)
   {
      const
         target = this .getTarget (),
         array  = target .getValue (),
         length = array .length;

      switch (length)
      {
         case 0:
         {
            generator .string += "[";
            generator .string += generator .TidySpace ();
            generator .string += "]";
            break;
         }
         case 1:
         {
            generator .EnterScope ();

            array [0] .toVRMLStream (generator);

            generator .LeaveScope ();
            break;
         }
         default:
         {
            generator .EnterScope ();

            generator .string += "[";
            generator .string += generator .TidyBreak ();
            generator .IncIndent ();

            for (const element of array)
            {
               generator .string += generator .Indent ();
               element .toVRMLStream (generator);
               generator .string += generator .string .at (-1) === "}" ? generator .TidyBreak () : generator .Break ();
            }

            generator .DecIndent ();
            generator .string += generator .Indent ();
            generator .string += "]";

            generator .LeaveScope ();
            break;
         }
      }
   },
   toXMLStream (generator)
   {
      const
         target = this .getTarget (),
         length = target .length;

      if (length)
      {
         generator .EnterScope ();

         const array = target .getValue ();

         for (let i = 0, n = length - 1; i < n; ++ i)
         {
            const node = array [i] .getValue ();

            if (node)
            {
               node .toXMLStream (generator);
               generator .string += generator .TidyBreak ();
            }
            else
            {
               generator .openTag ("NULL");

               const containerField = generator .ContainerField ();

               if (containerField)
                  generator .attribute ("containerField", containerField .getName ());

               generator .closeTag ("NULL");

               generator .string += generator .TidyBreak ();
            }
         }

         const node = array .at (-1) .getValue ();

         if (node)
         {
            node .toXMLStream (generator);
         }
         else
         {
            generator .openTag ("NULL");

            const containerField = generator .ContainerField ();

            if (containerField)
            {
               generator .string += generator .Space ();
               generator .string += "containerField='";
               generator .string += generator .EncodeString (containerField .getName ());
               generator .string += "'";
            }

            generator .closeTag ("NULL");
         }

         generator .LeaveScope ();
      }
   },
   toJSONStream (generator)
   {
      const
         target = this .getTarget (),
         length = target .length;

      if (length)
      {
         const array = target .getValue ();

         generator .EnterScope ();

         generator .string += '[';
         generator .string += generator .TidyBreak ();
         generator .string += generator .IncIndent ();

         for (let i = 0, n = length - 1; i < n; ++ i)
         {
            generator .string += generator .Indent ();

            if (array [i])
               array [i] .toJSONStreamValue (generator);
            else
               generator .string += 'null';

            generator .string += ',';
            generator .string += generator .TidyBreak ();
         }

         generator .string += generator .Indent ();

         if (array .at (-1))
            array .at (-1) .toJSONStreamValue (generator);
         else
            generator .string += 'null';

         generator .string += generator .TidyBreak ();
         generator .string += generator .DecIndent ();
         generator .string += generator .Indent ();
         generator .string += ']';

         generator .LeaveScope ();
      }
      else
      {
         generator .string += '[';
         generator .string += generator .TidySpace ();
         generator .string += ']';
      }
   },
   dispose ()
   {
      const target = this .getTarget ();

      target .resize (0, undefined, true);
      target .processInterests ();

      Base_X3DObjectArrayField .prototype .dispose .call (target);
   },
});

for (const key of Object .keys (MFNode .prototype))
   Object .defineProperty (MFNode .prototype, key, { enumerable: false });

Object .defineProperties (MFNode,
{
   typeName:
   {
      value: "MFNode",
      enumerable: true,
   },
});

function MFString (... args)
{
   return Base_X3DObjectArrayField .call (this, args);
}

Object .assign (Object .setPrototypeOf (MFString .prototype, Base_X3DObjectArrayField .prototype),
{
   getSingleType ()
   {
      return SFString;
   },
   toXMLStream (generator, sourceText = false)
   {
      const
         target = this .getTarget (),
         length = target .length;

      if (length)
      {
         const value = target .getValue ();

         for (let i = 0, n = length - 1; i < n; ++ i)
         {
            generator .string += "\"";
            value [i] .toXMLStream (generator, sourceText);
            generator .string += "\"";
            generator .string += generator .Comma ();
            generator .string += generator .TidySpace ();
         }

         generator .string += "\"";
         value .at (-1) .toXMLStream (generator, sourceText);
         generator .string += "\"";
      }
   },
});

for (const key of Object .keys (MFString .prototype))
   Object .defineProperty (MFString .prototype, key, { enumerable: false });

Object .defineProperties (MFString,
{
   typeName:
   {
      value: "MFString",
      enumerable: true,
   },
});

/**
 * MFImage
 */

function MFImage (... args)
{
   return Base_X3DObjectArrayField .call (this, args);
}

Object .assign (Object .setPrototypeOf (MFImage .prototype, Base_X3DObjectArrayField .prototype),
{
   getSingleType ()
   {
      return Fields_SFImage;
   },
});

for (const key of Object .keys (MFImage .prototype))
   Object .defineProperty (MFImage .prototype, key, { enumerable: false });

Object .defineProperties (MFImage,
{
   typeName:
   {
      value: "MFImage",
      enumerable: true,
   },
});

function TypedArrayTemplate (TypeName, SingleType, ValueType, ArrayType, Components, singleValue)
{
   function ArrayField (... args)
   {
      return Base_X3DTypedArrayField .call (this, args);
   }

   Object .assign (Object .setPrototypeOf (ArrayField .prototype, Base_X3DTypedArrayField .prototype),
   {
      getSingleValue ()
      {
         return singleValue;
      },
      getSingleType ()
      {
         return SingleType;
      },
      getValueType ()
      {
         return ValueType;
      },
      getArrayType ()
      {
         return ArrayType;
      },
      getComponents ()
      {
         return Components;
      },
   });

   for (const key of Object .keys (ArrayField .prototype))
      Object .defineProperty (ArrayField .prototype, key, { enumerable: false });

   Object .defineProperties (ArrayField,
   {
      typeName:
      {
         value: TypeName,
         enumerable: true,
      },
   });

   return ArrayField;
}

const Value = value => value;

const ArrayFields =
{
   MFBool:      TypedArrayTemplate ("MFBool",      SFBool,      Boolean,     Uint8Array,   1),
   MFColor:     TypedArrayTemplate ("MFColor",     Fields_SFColor,     Fields_SFColor,     Float32Array, 3),
   MFColorRGBA: TypedArrayTemplate ("MFColorRGBA", Fields_SFColorRGBA, Fields_SFColorRGBA, Float32Array, 4),
   MFDouble:    TypedArrayTemplate ("MFDouble",    SFDouble,    Value,       Float64Array, 1),
   MFFloat:     TypedArrayTemplate ("MFFloat",     SFFloat,     Value,       Float32Array, 1),
   MFImage:     MFImage,
   MFInt32:     TypedArrayTemplate ("MFInt32",     SFInt32,     Value,       Int32Array,   1),
   MFMatrix3d:  TypedArrayTemplate ("MFMatrix3d",  ArrayFields_SFMatrix3d,  ArrayFields_SFMatrix3d,  Float64Array, 9,  Matrix3/* default */.A .IDENTITY),
   MFMatrix3f:  TypedArrayTemplate ("MFMatrix3f",  ArrayFields_SFMatrix3f,  ArrayFields_SFMatrix3f,  Float32Array, 9,  Matrix3/* default */.A .IDENTITY),
   MFMatrix4d:  TypedArrayTemplate ("MFMatrix4d",  SFMatrix4d,  SFMatrix4d,  Float64Array, 16, Matrix4/* default */.A .IDENTITY),
   MFMatrix4f:  TypedArrayTemplate ("MFMatrix4f",  SFMatrix4f,  SFMatrix4f,  Float32Array, 16, Matrix4/* default */.A .IDENTITY),
   MFNode:      MFNode,
   MFRotation:  TypedArrayTemplate ("MFRotation",  Fields_SFRotation,  Fields_SFRotation,  Float64Array, 4,  Rotation4/* default */.A .IDENTITY),
   MFString:    MFString,
   MFTime:      TypedArrayTemplate ("MFTime",      SFTime,      Value,       Float64Array, 1,  -1),
   MFVec2d:     TypedArrayTemplate ("MFVec2d",     SFVec2d,     SFVec2d,     Float64Array, 2),
   MFVec2f:     TypedArrayTemplate ("MFVec2f",     SFVec2f,     SFVec2f,     Float32Array, 2),
   MFVec3d:     TypedArrayTemplate ("MFVec3d",     ArrayFields_SFVec3d,     ArrayFields_SFVec3d,     Float64Array, 3),
   MFVec3f:     TypedArrayTemplate ("MFVec3f",     ArrayFields_SFVec3f,     ArrayFields_SFVec3f,     Float32Array, 3),
   MFVec4d:     TypedArrayTemplate ("MFVec4d",     SFVec4d,     SFVec4d,     Float64Array, 4,  Vector4/* default */.A .W_AXIS),
   MFVec4f:     TypedArrayTemplate ("MFVec4f",     SFVec4f,     SFVec4f,     Float32Array, 4,  Vector4/* default */.A .W_AXIS),
};

const ArrayFields_default_ = ArrayFields;
;

/* harmony default export */ const Fields_ArrayFields = (Namespace/* default */.A .add ("ArrayFields", ArrayFields_default_));
;// ./src/x_ite/Fields/SFImage.js




const MFInt32 = Fields_ArrayFields .MFInt32;

/*
 *  Image
 */

function Image (width, height, comp, array)
{
   this .width  = Math .max (width|0, 0);
   this .height = Math .max (height|0, 0);
   this .comp   = Algorithm/* default */.A .clamp (comp|0, 0, 4);
   this .array  = new MFInt32 ();
   this .array .setValue (array);
   this .array .length = this .width * this .height;
}

Object .assign (Image .prototype,
{
   copy ()
   {
      return new Image (this .width, this .height, this .comp, this .array);
   },
   equals (image)
   {
      return this .width  === image .width &&
             this .height === image .height &&
             this .comp   === image .comp &&
             this .array .equals (image .array);
   },
   assign (image)
   {
      this .width  = image .width;
      this .height = image .height;
      this .comp   = image .comp;
      this .array .assign (image .array);
   },
   set (width, height, comp, array)
   {
      this .width  = width|0;
      this .height = height|0;
      this .comp   = comp|0;
      this .array .assign (array);
   },
   setWidth (value)
   {
      this .width = Math .max (value|0, 0);
      this .array .length = this .width * this .height;
   },
   getWidth ()
   {
      return this .width;
   },
   setHeight (value)
   {
      this .height = Math .max (value|0, 0);
      this .array .length = this .width * this .height;
   },
   getHeight ()
   {
      return this .height;
   },
   setComp (value)
   {
      this .comp = Algorithm/* default */.A .clamp (value|0, 0, 4);
   },
   getComp ()
   {
      return this .comp;
   },
   setArray (value)
   {
      this .array .setValue (value);
      this .array .length = this .width * this .height;
   },
   getArray ()
   {
      return this .array;
   },
});

/*
 *  SFImage
 */

const _set_size = Symbol ();

function SFImage (width, height, comp, array)
{
   switch (arguments .length)
   {
      case 0:
         X3DField/* default */.A .call (this, new Image (0, 0, 0, new MFInt32 ()));
         break;

      case 1:
         X3DField/* default */.A .call (this, arguments [0]);
         break;

      case 3:
         X3DField/* default */.A .call (this, new Image (width, height, comp, new MFInt32 ()));
         break;

      case 4:
         X3DField/* default */.A .call (this, new Image (width, height, comp, array));
         break;

      default:
         throw new Error ("Invalid arguments.");
   }

   this .getValue () .getArray () .addParent (this);
   this .addInterest (_set_size, this);
}

Object .assign (Object .setPrototypeOf (SFImage .prototype, X3DField/* default */.A .prototype),
{
   [_set_size] ()
   {
      this .getValue () .getArray () .length = this .width * this .height;
   },
   *[Symbol .iterator] ()
   {
      yield  this .width;
      yield  this .height;
      yield  this .comp;
      yield* this .array;
   },
   copy ()
   {
      return new SFImage (this .getValue () .copy ());
   },
   equals (image)
   {
      return this .getValue () .equals (image .getValue ());
   },
   isDefaultValue ()
   {
      return (
         this .width  === 0 &&
         this .height === 0 &&
         this .comp   === 0);
   },
   set (image)
   {
      this .getValue () .assign (image);
   },
   toStream (generator)
   {
      const
         width  = this .width,
         height = this .height,
         array  = new Uint32Array (this .array .getValue () .buffer);

      generator .string += width;
      generator .string += generator .Space ();
      generator .string += height;
      generator .string += generator .Space ();
      generator .string += this .comp;
      generator .string += generator .AttribBreak ();

      generator .IncIndent ();

      for (let y = 0; y < height; ++ y)
      {
         generator .string += generator .ListIndent ();

         const s = y * width;

         for (let x = 0; x < width; ++ x)
         {
            generator .string += "0x";
            generator .string += array [x + s] .toString (16);

            if (x !== width - 1)
               generator .string += generator .Space ();
         }

         if (y !== height - 1)
            generator .string += generator .AttribBreak ();
      }

      generator .DecIndent ();
   },
   toVRMLStream (generator)
   {
      this .toStream (generator);
   },
   toXMLStream (generator)
   {
      this .toStream (generator);
   },
   toJSONStream (generator)
   {
      generator .string += '[';
      generator .string += generator .ListBreak ();
      generator .string += generator .IncIndent ();
      generator .string += generator .ListIndent ();

      this .toJSONStreamValue (generator);

      generator .string += generator .DecIndent ();
      generator .string += generator .ListBreak ();
      generator .string += generator .ListIndent ();
      generator .string += ']';
   },
   toJSONStreamValue (generator)
   {
      const
         width  = this .width,
         height = this .height,
         array  = new Uint32Array (this .array .getValue () .buffer),
         length = this .array .length;

      generator .string += width;
      generator .string += ',';
      generator .string += generator .TidySpace ();
      generator .string += height;
      generator .string += ',';
      generator .string += generator .TidySpace ();
      generator .string += this .comp;
      generator .string += ',';

      if (width && height)
      {
         generator .string += generator .ListBreak ();
         generator .string += generator .IncIndent ();

         for (let y = 0; y < height; ++ y)
         {
            generator .string += generator .ListIndent ();

            const s = y * width;

            for (let x = 0; x < width; ++ x)
            {
               generator .string += array [x + s];

               if (x + s !== length - 1)
                  generator .string += ',';

               if (x !== width - 1)
                  generator .string += generator .TidySpace ();
            }

            if (y !== height - 1)
               generator .string += generator .ListBreak ();
         }

         generator .string += generator .DecIndent ();
      }
   },
});

for (const key of Object .keys (SFImage .prototype))
   Object .defineProperty (SFImage .prototype, key, { enumerable: false });

const width = {
   get ()
   {
      return this .getValue () .getWidth ();
   },
   set (value)
   {
      this .getValue () .setWidth (value);
      this .addEvent ();
   },
};

const height = {
   get ()
   {
      return this .getValue () .getHeight ();
   },
   set (value)
   {
      this .getValue () .setHeight (value);
      this .addEvent ();
   },
};

const comp = {
   get ()
   {
      return this .getValue () .getComp ();
   },
   set (value)
   {
      this .getValue () .setComp (value);
      this .addEvent ();
   },
};

const array = {
   get ()
   {
      return this .getValue () .getArray ();
   },
   set (value)
   {
      this .getValue () .setArray (value);
      this .addEvent ();
   },
};

Object .defineProperties (SFImage .prototype,
{
   x: width,
   y: height,
   width:  Object .assign ({ enumerable: true }, width),
   height: Object .assign ({ enumerable: true }, height),
   comp:   Object .assign ({ enumerable: true }, comp),
   array:  Object .assign ({ enumerable: true }, array),
});

Object .defineProperties (SFImage,
{
   typeName:
   {
      value: "SFImage",
      enumerable: true,
   },
});

const SFImage_default_ = SFImage;
;

/* harmony default export */ const Fields_SFImage = (Namespace/* default */.A .add ("SFImage", SFImage_default_));
;// ./src/x_ite/Fields.js













const Fields = {
   SFColor:     Fields_SFColor,
   SFColorRGBA: Fields_SFColorRGBA,
   SFImage:     Fields_SFImage,
   SFNode:      SFNode/* default */.A,
   SFRotation:  Fields_SFRotation,
   ... Fields_SFScalar,
   ... Fields_SFMatrix3,
   ... Fields_SFMatrix4,
   ... Fields_SFVec2,
   ... Fields_SFVec3,
   ... Fields_SFVec4,
   ... Fields_ArrayFields,
};

const Fields_default_ = Fields;
;

/* harmony default export */ const x_ite_Fields = (Namespace/* default */.A .add ("Fields", Fields_default_));

/***/ }),

/***/ 4679:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Base_X3DObject_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(946);
/* harmony import */ var _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(2212);
/* harmony import */ var _Fields_SFNodeCache_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(6015);
/* harmony import */ var _Components_Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(2340);
/* harmony import */ var _Execution_X3DImportedNode_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(3288);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(717);
/* provided dependency */ var $ = __webpack_require__(9547);






const
   _executionContext     = Symbol (),
   _sourceNode           = Symbol (),
   _sourceFieldName      = Symbol (),
   _sourceField          = Symbol (),
   _destinationNode      = Symbol (),
   _destinationFieldName = Symbol (),
   _destinationField     = Symbol (),
   _disposed             = Symbol ();

function X3DRoute (executionContext, sourceNode, sourceFieldName, destinationNode, destinationFieldName)
{
   _Base_X3DObject_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .call (this, executionContext);

   this [_executionContext]     = executionContext;
   this [_sourceNode]           = sourceNode;
   this [_sourceFieldName]      = sourceFieldName;
   this [_destinationNode]      = destinationNode;
   this [_destinationFieldName] = destinationFieldName;

   if (sourceNode instanceof _Execution_X3DImportedNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A)
      sourceNode .getInlineNode () .getLoadState () .addInterest ("reconnect", this);

   if (destinationNode instanceof _Execution_X3DImportedNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A)
      destinationNode .getInlineNode () .getLoadState () .addInterest ("reconnect", this);

   this .reconnect ();
}

Object .assign (Object .setPrototypeOf (X3DRoute .prototype, _Base_X3DObject_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .prototype),
{
   getExecutionContext ()
   {
      return this [_executionContext];
   },
   getRouteId ()
   {
      return X3DRoute .getRouteId (this [_sourceNode], this [_sourceFieldName], this [_destinationNode], this [_destinationFieldName]);
   },
   getSourceNode ()
   {
      ///  SAI

      if (this [_sourceNode] instanceof _Execution_X3DImportedNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A)
         return this [_sourceNode] .getExportedNode ();

      return this [_sourceNode];
   },
   getSourceField ()
   {
      ///  SAI

      if (this [_sourceField])
      {
         return this [_sourceField] .getAccessType () === _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .inputOutput
            ? this [_sourceField] .getName () + "_changed"
            : this [_sourceField] .getName ();
      }
      else
      {
         return this [_sourceFieldName];
      }

   },
   getDestinationNode ()
   {
      ///  SAI

      if (this [_destinationNode] instanceof _Execution_X3DImportedNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A)
         return this [_destinationNode] .getExportedNode ();

      return this [_destinationNode];
   },
   getDestinationField ()
   {
      ///  SAI

      if (this [_destinationField])
      {
         return this [_destinationField] .getAccessType () === _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .inputOutput
            ? "set_" + this [_destinationField] .getName ()
            : this [_destinationField] .getName ();
      }
      else
      {
         return this [_destinationFieldName];
      }
   },
   reconnect ()
   {
      try
      {
         this .disconnect ();
         this .connect ();
      }
      catch (error)
      {
         if ((this [_sourceNode] instanceof _Components_Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A ||
              this [_sourceNode] .getInlineNode () .checkLoadState () === _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .COMPLETE_STATE) &&
             (this [_destinationNode] instanceof _Components_Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A ||
              this [_destinationNode] .getInlineNode () .checkLoadState () === _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .COMPLETE_STATE))
         {
            console .warn (error);
         }
      }
   },
   connect ()
   {
      if (this [_disposed])
         return;

      let firstError, secondError;

      try
      {
         const sourceNode = this [_sourceNode] instanceof _Components_Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A
            ? this [_sourceNode]
            : this [_sourceNode] .getExportedNode ();

         this [_sourceField] = sourceNode .getField (this [_sourceFieldName]);
      }
      catch (error)
      {
         firstError = error;
      }

      try
      {
         const destinationNode = this [_destinationNode] instanceof _Components_Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A
            ? this [_destinationNode]
            : this [_destinationNode] .getExportedNode ();

         this [_destinationField] = destinationNode .getField (this [_destinationFieldName]);

      }
      catch (error)
      {
         secondError = error;
      }

      if (this [_sourceField] && this [_destinationField])
      {
         if (this [_sourceField] .getType () !== this [_destinationField] .getType ())
            throw new Error (`Bad ROUTE statement: Source field type must match destination field type of fields named "${this [_sourceField] .getName ()}" and "${this [_destinationField] .getName ()}".`);

         if (!this [_sourceField] .isOutput ())
            throw new Error (`Bad ROUTE statement: Source field "${this [_sourceField] .getName ()}" must be an output.`);

         if (!this [_destinationField] .isInput ())
            throw new Error (`Bad ROUTE statement: Destination field "${this [_destinationField] .getName ()}" must be an input.`);

         this [_sourceField]      .addOutputRoute (this);
         this [_destinationField] .addInputRoute (this);
         this [_sourceField]      .addFieldInterest (this [_destinationField]);
      }
      else
      {
         throw firstError ?? secondError;
      }
   },
   disconnect ()
   {
      this [_sourceField]      ?.removeOutputRoute (this);
      this [_destinationField] ?.removeInputRoute (this);

      if (this [_sourceField] && this [_destinationField])
         this [_sourceField] .removeFieldInterest (this [_destinationField]);

      this [_sourceField]      = null;
      this [_destinationField] = null;
   },
   toVRMLStream (generator)
   {
      if (!generator .ExistsRouteNode (this [_sourceNode]))
         throw new Error (`Source node does not exist in scene graph.`);

      if (!generator .ExistsRouteNode (this [_destinationNode]))
         throw new Error (`Destination node does not exist in scene graph.`);

      const sourceNodeName = this [_sourceNode] instanceof _Components_Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A
         ? generator .Name (this [_sourceNode])
         : generator .ImportedName (this [_sourceNode]);

      const destinationNodeName = this [_destinationNode] instanceof _Components_Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A
         ? generator .Name (this [_destinationNode])
         : generator .ImportedName (this [_destinationNode]);

      generator .string += generator .Indent ();
      generator .string += "ROUTE";
      generator .string += generator .Space ();
      generator .string += sourceNodeName;
      generator .string += ".";
      generator .string += this .getSourceField ();
      generator .string += generator .Space ();
      generator .string += "TO";
      generator .string += generator .Space ();
      generator .string += destinationNodeName;
      generator .string += ".";
      generator .string += this .getDestinationField ();
   },
   toXMLStream (generator)
   {
      if (!generator .ExistsRouteNode (this [_sourceNode]))
         throw new Error (`Source node does not exist in scene graph.`);

      if (!generator .ExistsRouteNode (this [_destinationNode]))
         throw new Error (`Destination node does not exist in scene graph.`);

      const sourceNodeName = this [_sourceNode] instanceof _Components_Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A
         ? generator .Name (this [_sourceNode])
         : generator .ImportedName (this [_sourceNode]);

      const destinationNodeName = this [_destinationNode] instanceof _Components_Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A
         ? generator .Name (this [_destinationNode])
         : generator .ImportedName (this [_destinationNode]);

      generator .openTag ("ROUTE");
      generator .attribute ("fromNode",  sourceNodeName);
      generator .attribute ("fromField", this .getSourceField ());
      generator .attribute ("toNode",    destinationNodeName);
      generator .attribute ("toField",   this .getDestinationField ());
      generator .closeTag ("ROUTE");
   },
   toJSONStream (generator)
   {
      if (!generator .ExistsRouteNode (this [_sourceNode]))
         throw new Error (`Source node does not exist in scene graph.`);

      if (!generator .ExistsRouteNode (this [_destinationNode]))
         throw new Error (`Destination node does not exist in scene graph.`);

      const sourceNodeName = this [_sourceNode] instanceof _Components_Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A
         ? generator .Name (this [_sourceNode])
         : generator .ImportedName (this [_sourceNode]);

      const destinationNodeName = this [_destinationNode] instanceof _Components_Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A
         ? generator .Name (this [_destinationNode])
         : generator .ImportedName (this [_destinationNode]);

      generator .string += generator .TidyBreak ();
      generator .string += generator .Indent ();

      generator .beginObject ("ROUTE", false, true);

      generator .stringProperty ("@fromNode",  sourceNodeName, false);
      generator .stringProperty ("@fromField", this .getSourceField ());
      generator .stringProperty ("@toNode",    destinationNodeName);
      generator .stringProperty ("@toField",   this .getDestinationField ());

      generator .endObject ();
      generator .endObject ();
   },
   dispose ()
   {
      if (this [_disposed])
         return;

      this [_disposed] = true;

      this .disconnect ();

      if (this [_sourceNode] instanceof _Execution_X3DImportedNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A)
         this [_sourceNode] .getInlineNode () .getLoadState () .removeInterest ("reconnect", this);

      if (this [_destinationNode] instanceof _Execution_X3DImportedNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A)
         this [_destinationNode] .getInlineNode () .getLoadState () .removeInterest ("reconnect", this);

      this [_executionContext] .deleteRoute (this);

      _Base_X3DObject_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .prototype .dispose .call (this);
   }
});

for (const key of Object .keys (X3DRoute .prototype))
   Object .defineProperty (X3DRoute .prototype, key, { enumerable: false });

Object .defineProperties (X3DRoute .prototype,
{
   sourceNode:
   {
      get ()
      {
         return _Fields_SFNodeCache_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .get (this .getSourceNode ());
      },
      enumerable: true,
   },
   sourceField:
   {
      get: X3DRoute .prototype .getSourceField,
      enumerable: true,
   },
   destinationNode:
   {
      get ()
      {
         return _Fields_SFNodeCache_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .get (this .getDestinationNode ());
      },
      enumerable: true,
   },
   destinationField:
   {
      get: X3DRoute .prototype .getDestinationField,
      enumerable: true,
   },
});

Object .defineProperties (X3DRoute,
{
   typeName:
   {
      value: "X3DRoute",
      enumerable: true,
   },
});

Object .assign (X3DRoute,
{
   getRouteId (sourceNode, sourceFieldName, destinationNode, destinationFieldName)
   {
      const sourceField = sourceNode instanceof _Components_Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A
         ? sourceNode .getField (sourceFieldName)
         : $.try (() => sourceNode .getExportedNode () .getField (sourceFieldName));

      const destinationField = destinationNode instanceof _Components_Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A
         ? destinationNode .getField (destinationFieldName)
         : $.try (() => destinationNode .getExportedNode () .getField (destinationFieldName));

      if (sourceField)
      {
         sourceFieldName = sourceField .getName ();

         if (sourceField .getAccessType () === _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .inputOutput)
            sourceFieldName += "_changed";
      }

      if (destinationField)
      {
         destinationFieldName = destinationField .getName ();

         if (destinationField .getAccessType () === _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .inputOutput)
            destinationFieldName = "set_" + destinationFieldName;
      }

      return `${sourceNode .getId ()}.${sourceFieldName}.${destinationNode .getId ()}.${destinationFieldName}`;
   },
});

const __default__ = X3DRoute;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .add ("X3DRoute", __default__));

/***/ }),

/***/ 4804:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Base_X3DObject_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(946);
/* harmony import */ var _Browser_Networking_URLs_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(7300);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(717);



function ComponentInfo (name, level, title, providerURL, external = false, dependencies = [ ])
{
   Object .defineProperties (this,
   {
      name: { value: name, enumerable: true },
      level: { value: level, enumerable: true },
      title: { value: title, enumerable: true },
      providerURL: { value: providerURL || _Browser_Networking_URLs_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .getProviderURL (external && name), enumerable: true },
      external: { value: external },
      dependencies: { value: dependencies },
   });
}

Object .assign (Object .setPrototypeOf (ComponentInfo .prototype, _Base_X3DObject_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .prototype),
{
   toVRMLStream (generator)
   {
      generator .string += generator .Indent ();
      generator .string += "COMPONENT";
      generator .string += generator .Space ();
      generator .string += this .name;
      generator .string += generator .TidySpace ();
      generator .string += ":";
      generator .string += generator .TidySpace ();
      generator .string += this .level;
   },
   toXMLStream (generator)
   {
      generator .openTag ("component");
      generator .attribute ("name",  this .name);
      generator .attribute ("level", this .level);
      generator .closeTag ("component");
   },
   toJSONStream (generator)
   {
      generator .beginObject ("", false);
      generator .stringProperty ("@name", this .name, false);
      generator .numberProperty ("@level", this .level);
      generator .endObject ();
   },
});

for (const key of Object .keys (ComponentInfo .prototype))
   Object .defineProperty (ComponentInfo .prototype, key, { enumerable: false });

Object .defineProperties (ComponentInfo,
{
   typeName:
   {
      value: "ComponentInfo",
      enumerable: true,
   },
});

Object .defineProperties (ComponentInfo .prototype,
{
   providerUrl: // legacy
   {
      get: function () { return this .providerURL; },
   },
});

const __default__ = ComponentInfo;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .add ("ComponentInfo", __default__));

/***/ }),

/***/ 4828:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(717);
// Latest implemented specification version:

const __default__ = "4.0";
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .add ("LATEST_VERSION", __default__));

/***/ }),

/***/ 4866:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Fields_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(4598);
/* harmony import */ var _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(2340);
/* harmony import */ var _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(2212);
/* harmony import */ var _standard_Utility_ObjectCache_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(9966);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(717);





const Fogs = (0,_standard_Utility_ObjectCache_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A) (FogContainer);

function FogContainer ()
{
   this .fogMatrix = new Float32Array (9);
}

Object .assign (FogContainer .prototype,
{
   set (fogNode, modelViewMatrix)
   {
      this .fogNode = fogNode;

      this .fogMatrix .set (modelViewMatrix .submatrix .inverse ());
   },
   getFogType ()
   {
      return this .fogNode .getFogType ();
   },
   setShaderUniforms (gl, shaderObject)
   {
      if (shaderObject .hasFog (this))
         return;

      const fogNode = this .fogNode;

      gl .uniform3fv       (shaderObject .x3d_FogColor,           fogNode .colorArray);
      gl .uniform1f        (shaderObject .x3d_FogVisibilityStart, fogNode .visibilityStart);
      gl .uniform1f        (shaderObject .x3d_FogVisibilityRange, fogNode .visibilityRange);
      gl .uniformMatrix3fv (shaderObject .x3d_FogMatrix, false,   this .fogMatrix);
   },
   dispose ()
   {
      Fogs .push (this);
   },
});

function X3DFogObject (executionContext)
{
   this .addType (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .X3DFogObject);

   this .addChildObjects (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .inputOutput, "hidden", new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFBool ());

   // Units

   this ._visibilityRange .setUnit ("length");

   // Private properties

   this .colorArray = new Float32Array (3);
}

Object .assign (X3DFogObject .prototype,
{
   initialize ()
   {
      this ._hidden          .addInterest ("set_fogType__",         this);
      this ._fogType         .addInterest ("set_fogType__",         this);
      this ._color           .addInterest ("set_color__",           this);
      this ._visibilityStart .addInterest ("set_visibilityRange__", this);
      this ._visibilityRange .addInterest ("set_visibilityRange__", this);

      this .set_color__ ();
      this .set_visibilityRange__ ();
   },
   isHidden ()
   {
      return this ._hidden .getValue ();
   },
   setHidden (value)
   {
      if (value === this ._hidden .getValue ())
         return;

      this ._hidden = value;
   },
   getFogType ()
   {
      return this .fogType;
   },
   getFogs ()
   {
      return Fogs;
   },
   set_fogType__: (() =>
   {
      const fogTypes = new Map ([
         ["LINEAR",      1],
         ["EXPONENTIAL", 2],
      ]);

      return function ()
      {
         if (this ._hidden .getValue () || (this .visibilityRange === 0 && this .visibilityStart === 0))
            this .fogType = 0;
         else
            this .fogType = fogTypes .get (this ._fogType .getValue ()) || 1;
      };
   })(),
   set_color__ ()
   {
      this .colorArray .set (this ._color .getValue ());
   },
   set_visibilityRange__ ()
   {
      this .visibilityStart = Math .max (this ._visibilityStart .getValue (), 0);
      this .visibilityRange = Math .max (this ._visibilityRange .getValue (), 0);

      this .set_fogType__ ();
   },
   dispose () { },
});

Object .defineProperties (X3DFogObject, _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .getStaticProperties ("X3DFogObject", "EnvironmentalEffects", 1));

const __default__ = X3DFogObject;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .add ("X3DFogObject", __default__));

/***/ }),

/***/ 4880:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Fields_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(4598);
/* harmony import */ var _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(2340);
/* harmony import */ var _Core_X3DBindableNode_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(1275);
/* harmony import */ var _Time_TimeSensor_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(9646);
/* harmony import */ var _Interpolation_EaseInEaseOut_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(9939);
/* harmony import */ var _Interpolation_PositionInterpolator_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(5054);
/* harmony import */ var _Interpolation_OrientationInterpolator_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(4045);
/* harmony import */ var _Interpolation_ScalarInterpolator_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(7325);
/* harmony import */ var _Base_X3DCast_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(7638);
/* harmony import */ var _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(2212);
/* harmony import */ var _standard_Math_Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(7572);
/* harmony import */ var _standard_Math_Numbers_Rotation4_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(7078);
/* harmony import */ var _standard_Math_Numbers_Matrix3_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(8713);
/* harmony import */ var _standard_Math_Numbers_Matrix4_js__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(6179);
/* harmony import */ var _standard_Math_Geometry_Box3_js__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(2918);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(717);
















function X3DViewpointNode (executionContext)
{
   _Core_X3DBindableNode_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .call (this, executionContext);

   this .addType (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_9__/* ["default"] */ .A .X3DViewpointNode);

   this .addChildObjects (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_9__/* ["default"] */ .A .inputOutput, "positionOffset",         new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFVec3f (),
                          _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_9__/* ["default"] */ .A .inputOutput, "orientationOffset",      new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFRotation (),
                          _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_9__/* ["default"] */ .A .inputOutput, "scaleOffset",            new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFVec3f (1, 1, 1),
                          _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_9__/* ["default"] */ .A .inputOutput, "scaleOrientationOffset", new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFRotation (),
                          _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_9__/* ["default"] */ .A .inputOutput, "centerOfRotationOffset", new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFVec3f (),
                          _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_9__/* ["default"] */ .A .inputOutput, "fieldOfViewScale",       new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFFloat (1));

   this .descriptions         = [ ];
   this .userPosition         = new _standard_Math_Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_10__/* ["default"] */ .A ();
   this .userOrientation      = new _standard_Math_Numbers_Rotation4_js__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A ();
   this .userCenterOfRotation = new _standard_Math_Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_10__/* ["default"] */ .A ();
   this .modelMatrix          = new _standard_Math_Numbers_Matrix4_js__WEBPACK_IMPORTED_MODULE_13__/* ["default"] */ .A ();
   this .cameraSpaceMatrix    = new _standard_Math_Numbers_Matrix4_js__WEBPACK_IMPORTED_MODULE_13__/* ["default"] */ .A (1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0,  10, 1);
   this .viewMatrix           = new _standard_Math_Numbers_Matrix4_js__WEBPACK_IMPORTED_MODULE_13__/* ["default"] */ .A (1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, -10, 1);

   const
      browser      = this .getBrowser (),
      privateScene = browser .getPrivateScene ();

   this .timeSensor                   = new _Time_TimeSensor_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A              (privateScene);
   this .easeInEaseOut                = new _Interpolation_EaseInEaseOut_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A           (privateScene);
   this .positionInterpolator         = new _Interpolation_PositionInterpolator_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A    (privateScene);
   this .orientationInterpolator      = new _Interpolation_OrientationInterpolator_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A (privateScene);
   this .scaleInterpolator            = new _Interpolation_PositionInterpolator_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A    (privateScene);
   this .scaleOrientationInterpolator = new _Interpolation_OrientationInterpolator_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A (privateScene);
   this .fieldOfViewScaleInterpolator = new _Interpolation_ScalarInterpolator_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A      (privateScene);
}

Object .assign (Object .setPrototypeOf (X3DViewpointNode .prototype, _Core_X3DBindableNode_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .prototype),
{
   initialize ()
   {
      _Core_X3DBindableNode_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .prototype .initialize .call (this);

      this .timeSensor ._stopTime = 1;
      this .timeSensor .setup ();

      this .easeInEaseOut ._key           = new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFFloat (0, 1);
      this .easeInEaseOut ._easeInEaseOut = new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFVec2f (new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFVec2f (), new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFVec2f ());
      this .easeInEaseOut .setup ();

      this .positionInterpolator         ._key = new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFFloat (0, 1);
      this .orientationInterpolator      ._key = new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFFloat (0, 1);
      this .scaleInterpolator            ._key = new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFFloat (0, 1);
      this .scaleOrientationInterpolator ._key = new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFFloat (0, 1);
      this .fieldOfViewScaleInterpolator ._key = new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFFloat (0, 1);

      this .positionInterpolator         .setup ();
      this .orientationInterpolator      .setup ();
      this .scaleInterpolator            .setup ();
      this .scaleOrientationInterpolator .setup ();
      this .fieldOfViewScaleInterpolator .setup ();

      this .timeSensor ._fraction_changed .addFieldInterest (this .easeInEaseOut ._set_fraction);

      this .easeInEaseOut ._modifiedFraction_changed .addFieldInterest (this .positionInterpolator         ._set_fraction);
      this .easeInEaseOut ._modifiedFraction_changed .addFieldInterest (this .orientationInterpolator      ._set_fraction);
      this .easeInEaseOut ._modifiedFraction_changed .addFieldInterest (this .scaleInterpolator            ._set_fraction);
      this .easeInEaseOut ._modifiedFraction_changed .addFieldInterest (this .scaleOrientationInterpolator ._set_fraction);
      this .easeInEaseOut ._modifiedFraction_changed .addFieldInterest (this .fieldOfViewScaleInterpolator ._set_fraction);

      this .positionInterpolator         ._value_changed .addFieldInterest (this ._positionOffset);
      this .orientationInterpolator      ._value_changed .addFieldInterest (this ._orientationOffset);
      this .scaleInterpolator            ._value_changed .addFieldInterest (this ._scaleOffset);
      this .scaleOrientationInterpolator ._value_changed .addFieldInterest (this ._scaleOrientationOffset);
      this .fieldOfViewScaleInterpolator ._value_changed .addFieldInterest (this ._fieldOfViewScale);

      this ._nearDistance   .addInterest ("set_nearDistance__",   this);
      this ._farDistance    .addInterest ("set_farDistance__",    this);
      this ._viewAll        .addInterest ("set_viewAll__",        this);
      this ._navigationInfo .addInterest ("set_navigationInfo__", this);
      this ._isBound        .addInterest ("set_bound__",          this);

      this .set_nearDistance__ ();
      this .set_farDistance__ ();
      this .set_navigationInfo__ ();
   },
   set_nearDistance__ ()
   {
      const nearDistance = this ._nearDistance .getValue ();

      this .nearDistance = nearDistance >= 0 ? nearDistance : undefined;
   },
   set_farDistance__ ()
   {
      const farDistance = this ._farDistance .getValue ();

      this .farDistance = farDistance >= 0 ? farDistance : undefined;
   },
   set_viewAll__ ()
   {
      if (!this ._viewAll .getValue ())
         return;

      if (!this ._isBound .getValue ())
         return;

      this ._set_bind = true;
   },
   set_navigationInfo__ ()
   {
      if (this .navigationInfoNode)
         this ._isBound .removeFieldInterest (this .navigationInfoNode ._set_bind);

      this .navigationInfoNode = (0,_Base_X3DCast_js__WEBPACK_IMPORTED_MODULE_8__/* ["default"] */ .A) (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_9__/* ["default"] */ .A .NavigationInfo, this ._navigationInfo);

      if (this .navigationInfoNode)
         this ._isBound .addFieldInterest (this .navigationInfoNode ._set_bind);
   },
   set_bound__ ()
   {
      if (this ._isBound .getValue ())
         this .getBrowser () .setDescription (this ._description);
      else
         this .timeSensor ._stopTime = Date .now () / 1000;
   },
   set_active__ (navigationInfoNode, active)
   {
      if (active .getValue ())
         return;

      this .timeSensor ._isActive .removeInterest ("set_active__", this);

      if (!this ._isBound .getValue ())
         return;

      if (this .timeSensor ._fraction_changed .getValue () !== 1)
         return;

      navigationInfoNode ._transitionComplete = true;
   },
   setInterpolators ()
   { },
   getDescriptions ()
   {
      return this .descriptions;
   },
   getPosition ()
   {
      return this ._position .getValue ();
   },
   setPosition (value)
   {
      this ._position = value;
   },
   getOrientation ()
   {
      return this ._orientation .getValue ();
   },
   setOrientation (value)
   {
      this ._orientation = value;
   },
   getCenterOfRotation ()
   {
      return this ._centerOfRotation .getValue ();
   },
   setCenterOfRotation (value)
   {
      this ._centerOfRotation = value;
   },
   getUserPosition ()
   {
      return this .userPosition .assign (this .getPosition ())
         .add (this ._positionOffset .getValue ());
   },
   setUserPosition (userPosition)
   {
      this ._positionOffset = this .userPosition .assign (userPosition)
         .subtract (this .getPosition ());
   },
   getUserOrientation ()
   {
      return this .userOrientation .assign (this .getOrientation ())
         .multRight (this ._orientationOffset .getValue ());
   },
   setUserOrientation (userOrientation)
   {
      this ._orientationOffset = this .userOrientation .assign (this .getOrientation ()) .inverse ()
         .multRight (userOrientation);
   },
   getUserCenterOfRotation ()
   {
      return this .userCenterOfRotation .assign (this .getCenterOfRotation ())
         .add (this ._centerOfRotationOffset .getValue ());
   },
   setUserCenterOfRotation (userCenterOfRotation)
   {
      this ._centerOfRotationOffset = this .userCenterOfRotation .assign (userCenterOfRotation)
         .subtract (this .getCenterOfRotation ());
   },
   getFieldOfViewScale ()
   {
      return this ._fieldOfViewScale .getValue ();
   },
   setFieldOfViewScale (value)
   {
      this ._fieldOfViewScale = value;
   },
   getNearDistance (navigationInfoNode)
   {
      return this .nearDistance ?? navigationInfoNode ?.getNearValue ();
   },
   setNearDistance (value)
   {
      this .nearDistance = value;
   },
   getFarDistance (navigationInfoNode)
   {
      return this .farDistance
         ?? (navigationInfoNode ? navigationInfoNode .getFarValue () || this .getMaxFarValue () : undefined);
   },
   setFarDistance (value)
   {
      this .farDistance = value;
   },
   getProjectionMatrix (renderObject)
   {
      const navigationInfoNode = renderObject .getNavigationInfo ();

      return this .getProjectionMatrixWithLimits (this .getNearDistance (navigationInfoNode),
                                                  this .getFarDistance (navigationInfoNode),
                                                  renderObject .getLayer () .getViewport () .getRectangle ());
   },
   getCameraSpaceMatrix ()
   {
      return this .cameraSpaceMatrix;
   },
   getViewMatrix ()
   {
      return this .viewMatrix;
   },
   getModelMatrix ()
   {
      return this .modelMatrix;
   },
   getMaxFarValue ()
   {
      return this .getBrowser () .getRenderingProperty ("LogarithmicDepthBuffer") ? 1e10 : 1e5;
   },
   getUpVector ()
   {
      // Local y-axis,
      // see https://www.web3d.org/documents/specifications/19775-1/V4.0/Part01/components/navigation.html#NavigationInfo.
      return _standard_Math_Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_10__/* ["default"] */ .A .Y_AXIS;
   },
   getSpeedFactor ()
   {
      return 1;
   },
   setVRMLTransition (value)
   {
      // VRML behavior support.
      this .VRMLTransition = value;
   },
   getVRMLTransition ()
   {
      // VRML behavior support.
      return this .VRMLTransition;
   },
   checkTransition (description)
   {
      if (this .timeSensor ._isActive .getValue () && this .timeSensor ._description .getValue () === description)
         return true;

      this .timeSensor ._description = description;

      return false;
   },
   transitionStart (layerNode, fromViewpointNode)
   {
      if (this ._jump .getValue ())
      {
         if (this .checkTransition ("transitionStart"))
            return;

         const relative = this .getRelativeTransformation (fromViewpointNode);

         if (!this ._retainUserOffsets .getValue ())
            this .resetUserOffsets ();

         if (this ._viewAll .getValue ())
            this .viewAll (layerNode .getBBox (new _standard_Math_Geometry_Box3_js__WEBPACK_IMPORTED_MODULE_14__/* ["default"] */ .A ()));

         // Handle NavigationInfo.

         const
            navigationInfoNode = layerNode .getNavigationInfo (),
            transitionTime     = navigationInfoNode ._transitionTime .getValue ();

         let transitionType = navigationInfoNode .getTransitionType ();

         // VRML behavior

         if (this .getExecutionContext () .getSpecificationVersion () == 2.0)
         {
            if (this .getVRMLTransition ())
               transitionType = "LINEAR";
            else
               transitionType = "TELEPORT";
         }

         this .setVRMLTransition (false);

         // End VRML behavior

         if (transitionTime <= 0)
            transitionType = "TELEPORT";

         if (this .constructor !== fromViewpointNode .constructor)
            transitionType = "TELEPORT";

         switch (transitionType)
         {
            case "TELEPORT":
            {
               navigationInfoNode ._transitionComplete = true;
               return;
            }
            case "ANIMATE":
            {
               this .easeInEaseOut ._easeInEaseOut = new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFVec2f (new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFVec2f (0, 1), new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFVec2f (1, 0));
               break;
            }
            default:
            {
               // LINEAR
               this .easeInEaseOut ._easeInEaseOut = new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFVec2f (new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFVec2f (), new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFVec2f ());
               break;
            }
         }

         navigationInfoNode ._transitionStart = true;

         this .timeSensor ._cycleInterval = transitionTime;
         this .timeSensor ._stopTime      = Date .now () / 1000;
         this .timeSensor ._startTime     = Date .now () / 1000;

         this .timeSensor ._isActive .addInterest ("set_active__", this, navigationInfoNode);

         this .positionInterpolator         ._keyValue = new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFVec3f    (relative .position,         this ._positionOffset);
         this .orientationInterpolator      ._keyValue = new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFRotation (relative .orientation,      this ._orientationOffset);
         this .scaleInterpolator            ._keyValue = new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFVec3f    (relative .scale,            this ._scaleOffset);
         this .scaleOrientationInterpolator ._keyValue = new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFRotation (relative .scaleOrientation, this ._scaleOrientationOffset);

         this ._positionOffset         = relative .position;
         this ._orientationOffset      = relative .orientation;
         this ._scaleOffset            = relative .scale;
         this ._scaleOrientationOffset = relative .scaleOrientation;

         this .setInterpolators (fromViewpointNode, relative);
      }
      else
      {
         this .transitionStop ();

         const navigationInfoNode = layerNode .getNavigationInfo ();

         navigationInfoNode ._transitionComplete = true;

         const relative = this .getRelativeTransformation (fromViewpointNode);

         this ._positionOffset         = relative .position;
         this ._orientationOffset      = relative .orientation;
         this ._scaleOffset            = relative .scale;
         this ._scaleOrientationOffset = relative .scaleOrientation;

         this .setInterpolators (fromViewpointNode, relative);
      }
   },
   transitionStop ()
   {
      this .timeSensor ._stopTime = Date .now () / 1000;
      this .timeSensor ._isActive .removeInterest ("set_active__", this);
   },
   resetUserOffsets ()
   {
      this ._positionOffset         = _standard_Math_Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_10__/* ["default"] */ .A   .ZERO;
      this ._orientationOffset      = _standard_Math_Numbers_Rotation4_js__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A .IDENTITY;
      this ._scaleOffset            = _standard_Math_Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_10__/* ["default"] */ .A   .ONE;
      this ._scaleOrientationOffset = _standard_Math_Numbers_Rotation4_js__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A .IDENTITY;
      this ._centerOfRotationOffset = _standard_Math_Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_10__/* ["default"] */ .A   .ZERO;
      this ._fieldOfViewScale       = 1;

      this .set_nearDistance__ ();
      this .set_farDistance__ ();
   },
   getRelativeTransformation: (() =>
   {
      const
         position         = new _standard_Math_Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_10__/* ["default"] */ .A (),
         orientation      = new _standard_Math_Numbers_Rotation4_js__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A (),
         scale            = new _standard_Math_Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_10__/* ["default"] */ .A (),
         scaleOrientation = new _standard_Math_Numbers_Rotation4_js__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A ();

      return function (fromViewpointNode)
      {
         const differenceMatrix = this .modelMatrix .copy () .multRight (fromViewpointNode .getViewMatrix ()) .inverse ();

         differenceMatrix .get (position, orientation, scale, scaleOrientation);

         position .subtract (this .getPosition ());
         orientation .multLeft (this .getOrientation () .copy () .inverse ());

         return {
            position: position,
            orientation: orientation,
            scale: scale,
            scaleOrientation: scaleOrientation,
         };
      };
   })(),
   getLookAtRotation: (() =>
   {
      const
         x = new _standard_Math_Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_10__/* ["default"] */ .A (),
         y = new _standard_Math_Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_10__/* ["default"] */ .A (),
         z = new _standard_Math_Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_10__/* ["default"] */ .A (),
         m = new _standard_Math_Numbers_Matrix3_js__WEBPACK_IMPORTED_MODULE_12__/* ["default"] */ .A (),
         r = new _standard_Math_Numbers_Rotation4_js__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A ();

      return function (fromPoint, toPoint)
      {
         const up = this .getUpVector (true);

         z .assign (fromPoint) .subtract (toPoint) .normalize ();
         x .assign (up) .cross (z) .normalize ();
         y .assign (z) .cross (x) .normalize ();

         m .set (... x, ... y, ... z);
         r .setMatrix (m);

         return r;
      };
   })(),
   lookAtPoint (layerNode, point, transitionTime = 1, factor = 1, straighten = false)
   {
      this .getCameraSpaceMatrix () .multVecMatrix (point);
      this .getModelMatrix () .copy () .inverse () .multVecMatrix (point);

      const minDistance = this .getNearDistance (layerNode .getNavigationInfo ()) * 2;

      this .lookAt (layerNode, point, minDistance, transitionTime, factor, straighten);
   },
   lookAtBBox (layerNode, bbox, transitionTime = 1, factor = 1, straighten = false)
   {
      if (bbox .size .equals (_standard_Math_Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_10__/* ["default"] */ .A .ZERO))
         return;

      bbox = bbox .copy () .multRight (this .getModelMatrix () .copy () .inverse ());

      this .lookAt (layerNode, bbox .center, this .getLookAtDistance (bbox), transitionTime, factor, straighten);
   },
   lookAt (layerNode, point, distance, transitionTime = 1, factor = 1, straighten = false)
   {
      this .timeSensor ._description = "lookAt";

      const
         offset = point .copy () .add (this .getUserOrientation () .multVecRot (new _standard_Math_Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_10__/* ["default"] */ .A (0, 0, distance))) .subtract (this .getPosition ());

      layerNode .getNavigationInfo () ._transitionStart = true;

      this .timeSensor ._cycleInterval = transitionTime;
      this .timeSensor ._stopTime      = Date .now () / 1000;
      this .timeSensor ._startTime     = Date .now () / 1000;

      this .timeSensor ._isActive .addInterest ("set_active__", this, layerNode .getNavigationInfo ());

      this .easeInEaseOut ._easeInEaseOut = new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFVec2f (new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFVec2f (0, 1), new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFVec2f (1, 0));

      const
         translation = this ._positionOffset .getValue () .copy () .lerp (offset, factor),
         direction   = this .getPosition () .copy () .add (translation) .subtract (point);

      let rotation = this ._orientationOffset .getValue () .copy () .multRight (new _standard_Math_Numbers_Rotation4_js__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A (this .getUserOrientation () .multVecRot (new _standard_Math_Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_10__/* ["default"] */ .A (0, 0, 1)), direction));

      if (straighten)
      {
         rotation = this .getOrientation () .copy () .inverse () .multRight (this .straightenHorizon (this .getOrientation () .copy () .multRight (rotation)));
      }

      this .positionInterpolator         ._keyValue = new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFVec3f (this ._positionOffset, translation);
      this .orientationInterpolator      ._keyValue = new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFRotation (this ._orientationOffset, rotation);
      this .scaleInterpolator            ._keyValue = new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFVec3f (this ._scaleOffset, _standard_Math_Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_10__/* ["default"] */ .A .ONE);
      this .scaleOrientationInterpolator ._keyValue = new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFRotation (this ._scaleOrientationOffset, this ._scaleOrientationOffset);

      const relative = this .getRelativeTransformation (this);

      this ._fieldOfViewScale       = 1;
      this ._centerOfRotationOffset = point .copy () .subtract (this .getCenterOfRotation ());
      this .nearDistance            = distance * (0.125 / 10);
      this .farDistance             = this .nearDistance * this .getMaxFarValue () / 0.125;

      this .setInterpolators (this, relative);
   },
   straightenView (layerNode)
   {
      if (this .checkTransition ("straightenView"))
         return;

      layerNode .getNavigationInfo () ._transitionStart = true;

      this .timeSensor ._cycleInterval = 1;
      this .timeSensor ._stopTime      = Date .now () / 1000;
      this .timeSensor ._startTime     = Date .now () / 1000;

      this .timeSensor ._isActive .addInterest ("set_active__", this, layerNode .getNavigationInfo ());

      this .easeInEaseOut ._easeInEaseOut = new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFVec2f (new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFVec2f (0, 1), new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFVec2f (1, 0));

      const rotation = this .getOrientation () .copy () .inverse () .multRight (this .straightenHorizon (this .getUserOrientation ()));

      this .positionInterpolator         ._keyValue = new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFVec3f (this ._positionOffset, this ._positionOffset);
      this .orientationInterpolator      ._keyValue = new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFRotation (this ._orientationOffset, rotation);
      this .scaleInterpolator            ._keyValue = new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFVec3f (this ._scaleOffset, this ._scaleOffset);
      this .scaleOrientationInterpolator ._keyValue = new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFRotation (this ._scaleOrientationOffset, this ._scaleOrientationOffset);

      const relative = this .getRelativeTransformation (this);

      this ._fieldOfViewScale = 1;

      this .setInterpolators (this, relative);
   },
   straightenHorizon (orientation, upVector = this .getUpVector (true))
   {
      return orientation .straighten (upVector);
   },
   viewAll (bbox)
   {
      bbox .copy () .multRight (this .modelMatrix .copy () .inverse ());

      if (bbox .size .equals (_standard_Math_Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_10__/* ["default"] */ .A .ZERO))
      {
         this .set_nearDistance__ ();
         this .set_farDistance__ ();
      }
      else
      {
         const
            direction       = this .getUserPosition () .copy () .subtract (bbox .center) .normalize (),
            distance        = this .getLookAtDistance (bbox),
            userPosition    = bbox .center .copy () .add (direction .multiply (distance)),
            userOrientation = this .getLookAtRotation (userPosition, bbox .center);

         this ._positionOffset         = userPosition .subtract (this .getPosition ());
         this ._orientationOffset      = this .getOrientation () .copy () .inverse () .multRight (userOrientation);
         this ._centerOfRotationOffset = bbox .center .copy () .subtract (this .getCenterOfRotation ());
         this ._fieldOfViewScale       = 1;
         this .nearDistance            = distance * (0.125 / 10);
         this .farDistance             = this .nearDistance * this .getMaxFarValue () / 0.125;
      }
   },
   traverse (type, renderObject)
   {
      // Handle NavigationInfo node.

      this .navigationInfoNode ?.traverse (type, renderObject);

      // Check if the viewpoint is displayed.

      this .descriptions .length = 0;

      const description = this ._description .getValue ();

      if (description)
      {
         if (renderObject .getViewpointGroups () .every (viewpointGroupNode => viewpointGroupNode .getDisplayed ()))
         {
            for (const viewpointGroupNode of renderObject .getViewpointGroups ())
            {
               const description = viewpointGroupNode ._description .getValue ();

               if (description)
                  this .descriptions .push (description);
            }

            this .descriptions .push (description);
         }
      }

      // Add the viewpoint to the list of available viewpoints.

      renderObject .getLayer () .getViewpoints () .push (this);

      this .modelMatrix .assign (renderObject .getModelViewMatrix () .get ());
   },
   update ()
   {
      this .cameraSpaceMatrix .set (this .getUserPosition (),
                                    this .getUserOrientation (),
                                    this ._scaleOffset .getValue (),
                                    this ._scaleOrientationOffset .getValue ());

      this .cameraSpaceMatrix .multRight (this .modelMatrix);

      this .viewMatrix .assign (this .cameraSpaceMatrix) .inverse ();
   }
});

Object .defineProperties (X3DViewpointNode, _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .getStaticProperties ("X3DViewpointNode", "Navigation", 1));

const __default__ = X3DViewpointNode;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_15__/* ["default"] */ .A .add ("X3DViewpointNode", __default__));

/***/ }),

/***/ 5048:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Fields_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(4598);
/* harmony import */ var _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(2340);
/* harmony import */ var _Core_X3DChildNode_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(5084);
/* harmony import */ var _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(2212);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(717);





function X3DTimeDependentNode (executionContext)
{
   this .addType (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .X3DTimeDependentNode);

   this .addChildObjects (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .outputOnly,  "initialized", new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFTime (),
                          _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .inputOutput, "evenLive",    new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFBool ());

   this .startTimeValue  = 0;
   this .pauseTimeValue  = 0;
   this .resumeTimeValue = 0;
   this .stopTimeValue   = 0;
   this .start           = 0;
   this .pause           = 0;
   this .pauseInterval   = 0;
   this .timeouts        = new Map ();
   this .disabled        = false;
}

Object .assign (Object .setPrototypeOf (X3DTimeDependentNode .prototype, _Core_X3DChildNode_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .prototype),
{
   initialize ()
   {
      this .getLive () .addInterest ("set_live__", this);
      this ._evenLive  .addInterest (Symbol .for ("X_ITE.X3DBaseNode.set_live__"), this);

      this ._initialized .addInterest ("set_loop__",       this);
      this ._enabled     .addInterest ("set_enabled__",    this);
      this ._loop        .addInterest ("set_loop__",       this);
      this ._startTime   .addInterest ("set_startTime__",  this);
      this ._pauseTime   .addInterest ("set_pauseTime__",  this);
      this ._resumeTime  .addInterest ("set_resumeTime__", this);
      this ._stopTime    .addInterest ("set_stopTime__",   this);

      this .startTimeValue  = this ._startTime  .getValue ();
      this .pauseTimeValue  = this ._pauseTime  .getValue ();
      this .resumeTimeValue = this ._resumeTime .getValue ();
      this .stopTimeValue   = this ._stopTime   .getValue ();

      this ._initialized = this .getBrowser () .getCurrentTime ();
   },
   checkLiveState ()
   {
      ///  Determines the live state of this node.

      return this .isLive () && (this .getExecutionContext () .getLive () .getValue () || this ._evenLive .getValue ());
   },
   getElapsedTime ()
   {
      return this .getBrowser () .getCurrentTime () - this .start - this .pauseInterval;
   },
   resetElapsedTime ()
   {
      this .start         = this .getBrowser () .getCurrentTime ();
      this .pause         = this .getBrowser () .getCurrentTime ();
      this .pauseInterval = 0;
   },
   set_live__ ()
   {
      if (this .getLive () .getValue ())
      {
         if (this .disabled)
         {
            this .disabled = false;

            if (this ._isActive .getValue () && !this ._isPaused .getValue ())
               this .real_resume ();
         }
      }
      else
      {
         if (!this .disabled && this ._isActive .getValue () && !this ._isPaused .getValue ())
         {
            // Only disable if needed, ie. if running!
            this .disabled = true;
            this .real_pause ();
         }
      }
   },
   set_enabled__ ()
   {
      if (this ._enabled .getValue ())
         this .set_loop__ ();

      else
         this .stop ();
   },
   set_loop__ ()
   {
      if (this ._enabled .getValue ())
      {
         if (this ._loop .getValue ())
         {
            if (this .stopTimeValue <= this .startTimeValue)
            {
               if (this .startTimeValue <= this .getBrowser () .getCurrentTime ())
                  this .do_start ();
            }
         }
      }

      this .set_loop ();
   },
   set_startTime__ ()
   {
      this .startTimeValue = this ._startTime .getValue ();

      if (this ._enabled .getValue ())
      {
         this .removeTimeout ("start");

         if (this .startTimeValue <= this .getBrowser () .getCurrentTime ())
            this .do_start ();

         else
            this .addTimeout ("start", "do_start", this .startTimeValue);
      }
   },
   set_pauseTime__ ()
   {
      this .pauseTimeValue = this ._pauseTime .getValue ();

      if (this ._enabled .getValue ())
      {
         this .removeTimeout ("pause");

         if (this .pauseTimeValue <= this .resumeTimeValue)
            return;

         if (this .pauseTimeValue <= this .getBrowser () .getCurrentTime ())
            this .do_pause ();

         else
            this .addTimeout ("pause", "do_pause", this .pauseTimeValue);
      }
   },
   set_resumeTime__ ()
   {
      this .resumeTimeValue = this ._resumeTime .getValue ();

      if (this ._enabled .getValue ())
      {
         this .removeTimeout ("resume");

         if (this .resumeTimeValue <= this .pauseTimeValue)
            return;

         if (this .resumeTimeValue <= this .getBrowser () .getCurrentTime ())
            this .do_resume ();

         else
            this .addTimeout ("resume", "do_resume", this .resumeTimeValue);
      }
   },
   set_stopTime__ ()
   {
      this .stopTimeValue = this ._stopTime .getValue ();

      if (this ._enabled .getValue ())
      {
         this .removeTimeout ("stop");

         if (this .stopTimeValue <= this .startTimeValue)
            return;

         if (this .stopTimeValue <= this .getBrowser () .getCurrentTime ())
            this .do_stop ();

         else
            this .addTimeout ("stop", "do_stop", this .stopTimeValue);
      }
   },
   do_start ()
   {
      if (!this ._isActive .getValue ())
      {
         this .resetElapsedTime ();

         // The event order below is very important.

         this ._isActive    = true;
         this ._elapsedTime = 0;

         this .set_start ();

         if (this .getLive () .getValue ())
         {
            this .getBrowser () .timeEvents () .addInterest ("set_time" ,this);
         }
         else
         {
            this .disabled = true;
            this .real_pause ();
         }
      }
   },
   do_pause ()
   {
      if (this ._isActive .getValue () && !this ._isPaused .getValue ())
      {
         this ._isPaused = true;

         if (this .getLive () .getValue ())
            this .real_pause ();
      }
   },
   real_pause ()
   {
      this .pause = Date .now () / 1000;

      this .set_pause ();

      this .getBrowser () .timeEvents () .removeInterest ("set_time" ,this);
   },
   do_resume ()
   {
      if (this ._isActive .getValue () && this ._isPaused .getValue ())
      {
         this ._isPaused = false;

         if (this .getLive () .getValue ())
            this .real_resume ();
      }
   },
   real_resume ()
   {
      const interval = Date .now () / 1000 - this .pause;

      this .pauseInterval += interval;

      this .set_resume (interval);

      this .getBrowser () .timeEvents () .addInterest ("set_time", this);
      this .getBrowser () .addBrowserEvent ();
   },
   do_stop ()
   {
      this .stop ();
   },
   stop ()
   {
      if (this ._isActive .getValue ())
      {
         // The event order below is very important.

         this .set_stop ();

         this ._elapsedTime = this .getElapsedTime ();

         if (this ._isPaused .getValue ())
            this ._isPaused = false;

         this ._isActive = false;

         this .getBrowser () .timeEvents () .removeInterest ("set_time" ,this);
      }
   },
   addTimeout (name, callback, startTime)
   {
      const ms = (startTime - this .getBrowser () .getCurrentTime ()) * 1000;

      this .removeTimeout (name);

      this .timeouts .set (name, setTimeout (() => this .processTimeout (callback), ms));
   },
   removeTimeout (name)
   {
      clearTimeout (this .timeouts .get (name));

      this .timeouts .delete (name);
   },
   processTimeout (callback)
   {
      if (!this ._enabled .getValue ())
         return;

      if (!(this .getLive () .getValue ()))
         return;

      this .getBrowser () .advanceOnlyTime ();

      this [callback] ();
   },
   set_loop: Function .prototype,
   set_start: Function .prototype,
   set_pause: Function .prototype,
   set_resume: Function .prototype,
   set_stop: Function .prototype,
   set_time: Function .prototype,
   dispose ()
   {
      for (const name of [... this .timeouts .keys ()])
         this .removeTimeout (name);
   },
});

Object .defineProperties (X3DTimeDependentNode, _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .getStaticProperties ("X3DTimeDependentNode", "Time", 1));

const __default__ = X3DTimeDependentNode;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .add ("X3DTimeDependentNode", __default__));

/***/ }),

/***/ 5054:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Fields_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(4598);
/* harmony import */ var _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(2040);
/* harmony import */ var _Base_FieldDefinitionArray_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(1870);
/* harmony import */ var _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(2340);
/* harmony import */ var _X3DInterpolatorNode_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(44);
/* harmony import */ var _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(2212);
/* harmony import */ var _standard_Math_Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(7572);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(717);








function PositionInterpolator (executionContext)
{
   _X3DInterpolatorNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .call (this, executionContext);

   this .addType (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .PositionInterpolator);
}

Object .assign (Object .setPrototypeOf (PositionInterpolator .prototype, _X3DInterpolatorNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .prototype),
{
   initialize ()
   {
      _X3DInterpolatorNode_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .prototype .initialize .call (this);

      this ._keyValue .addInterest ("set_keyValue__", this);
   },
   set_keyValue__ ()
   {
      const
         key      = this ._key,
         keyValue = this ._keyValue;

      if (keyValue .length < key .length)
         keyValue .resize (key .length, keyValue .length ? keyValue [keyValue .length - 1] : new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFVec3f ());

      // If there was already an set_fraction event in this frame, send a new value_changed to prevent glitches.
      if (this ._set_fraction .getModificationTime () >= this .getBrowser () .getCurrentTime ())
         this .set_fraction__ ();
   },
   interpolate: (() =>
   {
      const keyValue = new _standard_Math_Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A ();

      return function (index0, index1, weight)
      {
         this ._value_changed = keyValue .assign (this ._keyValue [index0] .getValue ()) .lerp (this ._keyValue [index1] .getValue (), weight);
      };
   })(),
});

Object .defineProperties (PositionInterpolator,
{
   ... _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .getStaticProperties ("PositionInterpolator", "Interpolation", 1, "children", "2.0"),
   fieldDefinitions:
   {
      value: new _Base_FieldDefinitionArray_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A ([
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .inputOutput, "metadata",      new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFNode ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .inputOnly,   "set_fraction",  new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFFloat ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .inputOutput, "key",           new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFFloat ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .inputOutput, "keyValue",      new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .MFVec3f ()),
         new _Base_X3DFieldDefinition_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .outputOnly,  "value_changed", new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFVec3f ()),
      ]),
      enumerable: true,
   },
});

const __default__ = PositionInterpolator;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A .add ("PositionInterpolator", __default__));

/***/ }),

/***/ 5084:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Fields_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(4598);
/* harmony import */ var _X3DNode_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(2340);
/* harmony import */ var _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(2212);
/* harmony import */ var _Rendering_TraverseType_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(2927);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(717);





function X3DChildNode (executionContext)
{
   if (this .getExecutionContext ())
      return;

   _X3DNode_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .call (this, executionContext);

   this .addType (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .X3DChildNode);

   this .addChildObjects (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .outputOnly, "isBoundedObject",   new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFBool (),
                          _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .outputOnly, "isPointingObject",  new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFBool (),
                          _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .outputOnly, "isCameraObject",    new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFBool (),
                          _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .outputOnly, "isPickableObject",  new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFBool (),
                          _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .outputOnly, "isCollisionObject", new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFBool (),
                          _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .outputOnly, "isShadowObject",    new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFBool (),
                          _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .outputOnly, "isVisibleObject",   new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFBool ());
}

Object .assign (Object .setPrototypeOf (X3DChildNode .prototype, _X3DNode_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .prototype),
{
   setBoundedObject (value)
   {
      if (!!value !== this ._isBoundedObject .getValue ())
         this ._isBoundedObject = value;
   },
   isBoundedObject ()
   {
      return this ._isBoundedObject .getValue ();
   },
   setPointingObject (value)
   {
      if (!!value !== this ._isPointingObject .getValue ())
         this ._isPointingObject = value;
   },
   isPointingObject ()
   {
      return this ._isPointingObject .getValue ();
   },
   setCameraObject (value)
   {
      if (!!value !== this ._isCameraObject .getValue ())
         this ._isCameraObject = value;
   },
   isCameraObject ()
   {
      return this ._isCameraObject .getValue ();
   },
   setPickableObject (value)
   {
      if (!!value !== this ._isPickableObject .getValue ())
         this ._isPickableObject = value;
   },
   isPickableObject ()
   {
      return this ._isPickableObject .getValue ();
   },
   setShadowObject (value)
   {
      if (!!value !== this ._isShadowObject .getValue ())
         this ._isShadowObject = value;
   },
   isShadowObject ()
   {
      return this ._isShadowObject .getValue ();
   },
   setCollisionObject (value)
   {
      if (!!value !== this ._isCollisionObject .getValue ())
         this ._isCollisionObject = value;
   },
   isCollisionObject ()
   {
      return this ._isCollisionObject .getValue ();
   },
   setVisibleObject (value)
   {
      if (!!value !== this ._isVisibleObject .getValue ())
         this ._isVisibleObject = value;
   },
   isVisibleObject ()
   {
      return this ._isVisibleObject .getValue ();
   },
   isVisible ()
   {
      // This function will be overloaded by X3DBoundedObject.
      return true;
   },
   connectChildNode (childNode, excludes)
   {
      if (!excludes ?.includes (_Rendering_TraverseType_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .BBOX))
      {
         childNode ._isBoundedObject .addFieldInterest (this ._isBoundedObject);
         this .setBoundedObject (childNode .isBoundedObject ());
      }

      if (!excludes ?.includes (_Rendering_TraverseType_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .POINTER))
      {
         childNode ._isPointingObject .addFieldInterest (this ._isPointingObject);
         this .setPointingObject (childNode .isPointingObject ());
      }

      if (!excludes ?.includes (_Rendering_TraverseType_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .CAMERA))
      {
         childNode ._isCameraObject .addFieldInterest (this ._isCameraObject);
         this .setCameraObject (childNode .isCameraObject ());
      }

      if (!excludes ?.includes (_Rendering_TraverseType_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .PICKING))
      {
         childNode ._isPickableObject .addFieldInterest (this ._isPickableObject);
         this .setPickableObject (childNode .isPickableObject ());
      }

      if (!excludes ?.includes (_Rendering_TraverseType_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .COLLISION))
      {
         childNode ._isCollisionObject .addFieldInterest (this ._isCollisionObject);
         this .setCollisionObject (childNode .isCollisionObject ());
      }

      if (!excludes ?.includes (_Rendering_TraverseType_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .SHADOW))
      {
         childNode ._isShadowObject .addFieldInterest (this ._isShadowObject);
         this .setShadowObject (childNode .isShadowObject ());
      }

      if (!excludes ?.includes (_Rendering_TraverseType_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .DISPLAY))
      {
         childNode ._isVisibleObject .addFieldInterest (this ._isVisibleObject);
         this .setVisibleObject (childNode .isVisibleObject ());
      }
   },
   disconnectChildNode (childNode)
   {
      childNode ._isBoundedObject   .removeFieldInterest (this ._isBoundedObject);
      childNode ._isPointingObject  .removeFieldInterest (this ._isPointingObject);
      childNode ._isCameraObject    .removeFieldInterest (this ._isCameraObject);
      childNode ._isPickableObject  .removeFieldInterest (this ._isPickableObject);
      childNode ._isCollisionObject .removeFieldInterest (this ._isCollisionObject);
      childNode ._isShadowObject    .removeFieldInterest (this ._isShadowObject);
      childNode ._isVisibleObject   .removeFieldInterest (this ._isVisibleObject);
   },
   getShapes (shapes, modelMatrix)
   {
      return shapes;
   },
});

Object .defineProperties (X3DChildNode, _X3DNode_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .getStaticProperties ("X3DChildNode", "Core", 1));

const __default__ = X3DChildNode;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A .add ("X3DChildNode", __default__));

/***/ }),

/***/ 5143:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(7572);
/* harmony import */ var _Numbers_Matrix4_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(6179);
/* harmony import */ var _x_ite_Namespace_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(717);



const
   point     = new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A (),
   invMatrix = new _Numbers_Matrix4_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A ();

function Plane3 (point = _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .ZERO, normal = _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .Z_AXIS)
{
   this .normal = new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A ();

   this .set (point, normal);
}

Object .assign (Plane3 .prototype,
{
   copy ()
   {
      const copy = Object .create (Plane3 .prototype);

      copy .normal             = this .normal .copy ();
      copy .distanceFromOrigin = this .distanceFromOrigin;

      return copy;
   },
   assign (plane)
   {
      this .normal .assign (plane .normal);
      this .distanceFromOrigin = plane .distanceFromOrigin;

      return this;
   },
   equals (plane)
   {
      return this .distanceFromOrigin === plane .distanceFromOrigin && this .normal .equals (plane .normal);
   },
   set (point = _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .ZERO, normal = _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .Z_AXIS)
   {
      this .normal .assign (normal);
      this .distanceFromOrigin = normal .dot (point);
      return this;
   },
   multLeft (matrix)
   {
      // Taken from Inventor:

      // Find the point on the plane along the normal from the origin
      point .assign (this .normal) .multiply (this .distanceFromOrigin);

      // Transform the plane normal by the matrix
      // to get the new normal. Use the inverse transpose
      // of the matrix so that normals are not scaled incorrectly.
      // n' = !~m * n = n * ~m
      invMatrix .assign (matrix) .submatrix .inverse ()
         .multVecMatrix (this .normal) .normalize ();

      // Transform the point by the matrix
      matrix .multMatrixVec (point);

      // The new distance is the projected distance of the vector to the
      // transformed point onto the (unit) transformed normal. This is
      // just a dot product.
      this .distanceFromOrigin = this .normal .dot (point);

      return this;
   },
   multRight (matrix)
   {
      // Taken from Inventor:

      // Find the point on the plane along the normal from the origin
      point .assign (this .normal) .multiply (this .distanceFromOrigin);

      // Transform the plane normal by the matrix
      // to get the new normal. Use the inverse transpose
      // of the matrix so that normals are not scaled incorrectly.
      // n' = n * !~m = ~m * n
      invMatrix .assign (matrix) .submatrix .inverse ()
         .multMatrixVec (this .normal) .normalize ();

      // Transform the point by the matrix
      matrix .multVecMatrix (point);

      // The new distance is the projected distance of the vector to the
      // transformed point onto the (unit) transformed normal. This is
      // just a dot product.
      this .distanceFromOrigin = this .normal .dot (point);

      return this;
   },
   getDistanceToPoint (point)
   {
      return point .dot (this .normal) - this .distanceFromOrigin;
   },
   getPerpendicularVectorToPoint (point, result = new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A ())
   {
      return result .assign (this .normal) .multiply (-this .getDistanceToPoint (point));
   },
	getClosestPointToPoint (point, result = new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A ())
   {
      return this .getPerpendicularVectorToPoint (point, result) .add (point);
   },
   intersectsLine (line, intersection)
   {
      const { point, direction } = line;

      // Check if the line is parallel to the plane.
      const theta = direction .dot (this .normal);

      // Plane and line are parallel.
      if (theta === 0)
         return false;

      // Plane and line are not parallel. The intersection point can be calculated now.
      const t = (this .distanceFromOrigin - this .normal .dot (point)) / theta;

      intersection .assign (direction) .multiply (t) .add (point);

      return true;
   },
   toString ()
   {
      return `${this .normal}, ${this .distanceFromOrigin}`;
   },
});

const __default__ = Plane3;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_x_ite_Namespace_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .add ("Plane3", __default__));

/***/ }),

/***/ 5292:
/***/ (function(module) {

(function webpackUniversalModuleDefinition(root, factory) {
	if(true)
		module.exports = factory();
	else // removed by dead control flow
{}
})(this, function() {
return /******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};

/******/ 	// The require function
/******/ 	function __nested_webpack_require_529__(moduleId) {

/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId])
/******/ 			return installedModules[moduleId].exports;

/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			exports: {},
/******/ 			id: moduleId,
/******/ 			loaded: false
/******/ 		};

/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __nested_webpack_require_529__);

/******/ 		// Flag the module as loaded
/******/ 		module.loaded = true;

/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}


/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__nested_webpack_require_529__.m = modules;

/******/ 	// expose the module cache
/******/ 	__nested_webpack_require_529__.c = installedModules;

/******/ 	// __webpack_public_path__
/******/ 	__nested_webpack_require_529__.p = "";

/******/ 	// Load entry module and return exports
/******/ 	return __nested_webpack_require_529__(0);
/******/ })
/************************************************************************/
/******/ ([
/* 0 */
/***/ (function(module, exports, __nested_webpack_require_1730__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	    value: true
	});
	exports.isNotPNG = isNotPNG;
	exports.isNotAPNG = isNotAPNG;
	exports.default = parseAPNG;

	var _crc = __nested_webpack_require_1730__(1);

	var _crc2 = _interopRequireDefault(_crc);

	var _structs = __nested_webpack_require_1730__(2);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	var errNotPNG = new Error('Not a PNG');
	var errNotAPNG = new Error('Not an animated PNG');

	function isNotPNG(err) {
	    return err === errNotPNG;
	}
	function isNotAPNG(err) {
	    return err === errNotAPNG;
	}

	// '\x89PNG\x0d\x0a\x1a\x0a'
	var PNGSignature = new Uint8Array([0x89, 0x50, 0x4e, 0x47, 0x0d, 0x0a, 0x1a, 0x0a]);

	/**
	 * Parse APNG data
	 * @param {ArrayBuffer} buffer
	 * @return {APNG|Error}
	 */
	function parseAPNG(buffer) {
	    var bytes = new Uint8Array(buffer);

	    if (Array.prototype.some.call(PNGSignature, function (b, i) {
	        return b !== bytes[i];
	    })) {
	        return errNotPNG;
	    }

	    // fast animation test
	    var isAnimated = false;
	    eachChunk(bytes, function (type) {
	        return !(isAnimated = type === 'acTL');
	    });
	    if (!isAnimated) {
	        return errNotAPNG;
	    }

	    var preDataParts = [],
	        postDataParts = [];
	    var headerDataBytes = null,
	        frame = null,
	        frameNumber = 0,
	        apng = new _structs.APNG();

	    eachChunk(bytes, function (type, bytes, off, length) {
	        var dv = new DataView(bytes.buffer);
	        switch (type) {
	            case 'IHDR':
	                headerDataBytes = bytes.subarray(off + 8, off + 8 + length);
	                apng.width = dv.getUint32(off + 8);
	                apng.height = dv.getUint32(off + 12);
	                break;
	            case 'acTL':
	                apng.numPlays = dv.getUint32(off + 8 + 4);
	                break;
	            case 'fcTL':
	                if (frame) {
	                    apng.frames.push(frame);
	                    frameNumber++;
	                }
	                frame = new _structs.Frame();
	                frame.width = dv.getUint32(off + 8 + 4);
	                frame.height = dv.getUint32(off + 8 + 8);
	                frame.left = dv.getUint32(off + 8 + 12);
	                frame.top = dv.getUint32(off + 8 + 16);
	                var delayN = dv.getUint16(off + 8 + 20);
	                var delayD = dv.getUint16(off + 8 + 22);
	                if (delayD === 0) {
	                    delayD = 100;
	                }
	                frame.delay = 1000 * delayN / delayD;
	                // https://bugzilla.mozilla.org/show_bug.cgi?id=125137
	                // https://bugzilla.mozilla.org/show_bug.cgi?id=139677
	                // https://bugzilla.mozilla.org/show_bug.cgi?id=207059
	                if (frame.delay <= 10) {
	                    frame.delay = 100;
	                }
	                apng.playTime += frame.delay;
	                frame.disposeOp = dv.getUint8(off + 8 + 24);
	                frame.blendOp = dv.getUint8(off + 8 + 25);
	                frame.dataParts = [];
	                if (frameNumber === 0 && frame.disposeOp === 2) {
	                    frame.disposeOp = 1;
	                }
	                break;
	            case 'fdAT':
	                if (frame) {
	                    frame.dataParts.push(bytes.subarray(off + 8 + 4, off + 8 + length));
	                }
	                break;
	            case 'IDAT':
	                if (frame) {
	                    frame.dataParts.push(bytes.subarray(off + 8, off + 8 + length));
	                }
	                break;
	            case 'IEND':
	                postDataParts.push(subBuffer(bytes, off, 12 + length));
	                break;
	            default:
	                preDataParts.push(subBuffer(bytes, off, 12 + length));
	        }
	    });

	    if (frame) {
	        apng.frames.push(frame);
	    }

	    if (apng.frames.length == 0) {
	        return errNotAPNG;
	    }

	    var preBlob = new Blob(preDataParts),
	        postBlob = new Blob(postDataParts);

	    apng.frames.forEach(function (frame) {
	        var bb = [];
	        bb.push(PNGSignature);
	        headerDataBytes.set(makeDWordArray(frame.width), 0);
	        headerDataBytes.set(makeDWordArray(frame.height), 4);
	        bb.push(makeChunkBytes('IHDR', headerDataBytes));
	        bb.push(preBlob);
	        frame.dataParts.forEach(function (p) {
	            return bb.push(makeChunkBytes('IDAT', p));
	        });
	        bb.push(postBlob);
	        frame.imageData = new Blob(bb, { 'type': 'image/png' });
	        delete frame.dataParts;
	        bb = null;
	    });

	    return apng;
	}

	/**
	 * @param {Uint8Array} bytes
	 * @param {function(string, Uint8Array, int, int): boolean} callback
	 */
	function eachChunk(bytes, callback) {
	    var dv = new DataView(bytes.buffer);
	    var off = 8,
	        type = void 0,
	        length = void 0,
	        res = void 0;
	    do {
	        length = dv.getUint32(off);
	        type = readString(bytes, off + 4, 4);
	        res = callback(type, bytes, off, length);
	        off += 12 + length;
	    } while (res !== false && type != 'IEND' && off < bytes.length);
	}

	/**
	 *
	 * @param {Uint8Array} bytes
	 * @param {number} off
	 * @param {number} length
	 * @return {string}
	 */
	function readString(bytes, off, length) {
	    var chars = Array.prototype.slice.call(bytes.subarray(off, off + length));
	    return String.fromCharCode.apply(String, chars);
	}

	/**
	 *
	 * @param {string} x
	 * @return {Uint8Array}
	 */
	function makeStringArray(x) {
	    var res = new Uint8Array(x.length);
	    for (var i = 0; i < x.length; i++) {
	        res[i] = x.charCodeAt(i);
	    }
	    return res;
	}

	/**
	 * @param {Uint8Array} bytes
	 * @param {int} start
	 * @param {int} length
	 * @return {Uint8Array}
	 */
	function subBuffer(bytes, start, length) {
	    var a = new Uint8Array(length);
	    a.set(bytes.subarray(start, start + length));
	    return a;
	}

	/**
	 * @param {string} type
	 * @param {Uint8Array} dataBytes
	 * @return {Uint8Array}
	 */
	var makeChunkBytes = function makeChunkBytes(type, dataBytes) {
	    var crcLen = type.length + dataBytes.length;
	    var bytes = new Uint8Array(crcLen + 8);
	    var dv = new DataView(bytes.buffer);

	    dv.setUint32(0, dataBytes.length);
	    bytes.set(makeStringArray(type), 4);
	    bytes.set(dataBytes, 8);
	    var crc = (0, _crc2.default)(bytes, 4, crcLen);
	    dv.setUint32(crcLen + 4, crc);
	    return bytes;
	};

	var makeDWordArray = function makeDWordArray(x) {
	    return new Uint8Array([x >>> 24 & 0xff, x >>> 16 & 0xff, x >>> 8 & 0xff, x & 0xff]);
	};

/***/ }),
/* 1 */
/***/ (function(module, exports) {

	"use strict";

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	exports.default = function (bytes) {
	  var start = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
	  var length = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : bytes.length - start;

	  var crc = -1;
	  for (var _i = start, l = start + length; _i < l; _i++) {
	    crc = crc >>> 8 ^ table[(crc ^ bytes[_i]) & 0xFF];
	  }
	  return crc ^ -1;
	};

	var table = new Uint32Array(256);

	for (var i = 0; i < 256; i++) {
	  var c = i;
	  for (var k = 0; k < 8; k++) {
	    c = (c & 1) !== 0 ? 0xEDB88320 ^ c >>> 1 : c >>> 1;
	  }
	  table[i] = c;
	}

	/**
	 *
	 * @param {Uint8Array} bytes
	 * @param {number} start
	 * @param {number} length
	 * @return {number}
	 */

/***/ }),
/* 2 */
/***/ (function(module, exports, __nested_webpack_require_9403__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	    value: true
	});
	exports.Frame = exports.APNG = undefined;

	var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

	var _player = __nested_webpack_require_9403__(3);

	var _player2 = _interopRequireDefault(_player);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

	/**
	 * @property {number} currFrameNumber
	 * @property {Frame} currFrame
	 * @property {boolean} paused
	 * @property {boolean} ended
	 */
	var APNG = exports.APNG = function () {
	    function APNG() {
	        _classCallCheck(this, APNG);

	        this.width = 0;
	        this.height = 0;
	        this.numPlays = 0;
	        this.playTime = 0;
	        this.frames = [];
	    }
	    /** @type {number} */

	    /** @type {number} */

	    /** @type {number} */

	    /** @type {number} */

	    /** @type {Frame[]} */


	    _createClass(APNG, [{
	        key: 'createImages',


	        /**
	         *
	         * @return {Promise.<*>}
	         */
	        value: function createImages() {
	            return Promise.all(this.frames.map(function (f) {
	                return f.createImage();
	            }));
	        }

	        /**
	         *
	         * @param {CanvasRenderingContext2D} context
	         * @param {boolean} autoPlay
	         * @return {Promise.<Player>}
	         */

	    }, {
	        key: 'getPlayer',
	        value: function getPlayer(context) {
	            var _this = this;

	            var autoPlay = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;

	            return this.createImages().then(function () {
	                return new _player2.default(_this, context, autoPlay);
	            });
	        }
	    }]);

	    return APNG;
	}();

	var Frame = exports.Frame = function () {
	    function Frame() {
	        _classCallCheck(this, Frame);

	        this.left = 0;
	        this.top = 0;
	        this.width = 0;
	        this.height = 0;
	        this.delay = 0;
	        this.disposeOp = 0;
	        this.blendOp = 0;
	        this.imageData = null;
	        this.imageElement = null;
	    }
	    /** @type {number} */

	    /** @type {number} */

	    /** @type {number} */

	    /** @type {number} */

	    /** @type {number} */

	    /** @type {number} */

	    /** @type {number} */

	    /** @type {Blob} */

	    /** @type {HTMLImageElement} */


	    _createClass(Frame, [{
	        key: 'createImage',
	        value: function createImage() {
	            var _this2 = this;

	            if (this.imageElement) {
	                return Promise.resolve();
	            }
	            return new Promise(function (resolve, reject) {
	                var url = URL.createObjectURL(_this2.imageData);
	                _this2.imageElement = document.createElement('img');
	                _this2.imageElement.onload = function () {
	                    URL.revokeObjectURL(url);
	                    resolve();
	                };
	                _this2.imageElement.onerror = function () {
	                    URL.revokeObjectURL(url);
	                    _this2.imageElement = null;
	                    reject(new Error("Image creation error"));
	                };
	                _this2.imageElement.src = url;
	            });
	        }
	    }]);

	    return Frame;
	}();

/***/ }),
/* 3 */
/***/ (function(module, exports, __nested_webpack_require_13509__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	    value: true
	});

	var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

	var _events = __nested_webpack_require_13509__(4);

	var _events2 = _interopRequireDefault(_events);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

	function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

	function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

	var _class = function (_EventEmitter) {
	    _inherits(_class, _EventEmitter);

	    /**
	     * @param {APNG} apng
	     * @param {CanvasRenderingContext2D} context
	     * @param {boolean} autoPlay
	     */

	    /** @type {number} */


	    /** @type {boolean} */

	    /** @type {ImageData} */


	    /** @type {APNG} */

	    /** @type {CanvasRenderingContext2D} */
	    function _class(apng, context, autoPlay) {
	        _classCallCheck(this, _class);

	        var _this = _possibleConstructorReturn(this, (_class.__proto__ || Object.getPrototypeOf(_class)).call(this));

	        _this.playbackRate = 1.0;
	        _this._currentFrameNumber = 0;
	        _this._ended = false;
	        _this._paused = true;
	        _this._numPlays = 0;
	        _this._rafId = null;

	        _this._apng = apng;
	        _this.context = context;
	        _this.stop();
	        if (autoPlay) {
	            _this.play();
	        }
	        return _this;
	    }

	    /**
	     *
	     * @return {number}
	     */

	    /** @type {number|null} */

	    /** @type {boolean} */

	    /** @type {number} */

	    /** @type {Frame} */

	    /** @type {number} */


	    _createClass(_class, [{
	        key: 'renderNextFrame',
	        value: function renderNextFrame() {
	            this._currentFrameNumber = (this._currentFrameNumber + 1) % this._apng.frames.length;
	            if (this._currentFrameNumber === this._apng.frames.length - 1) {
	                this._numPlays++;
	                if (this._apng.numPlays !== 0 && this._numPlays >= this._apng.numPlays) {
	                    this._ended = true;
	                    this._paused = true;
	                }
	            }

	            if (this._prevFrame && this._prevFrame.disposeOp == 1) {
	                this.context.clearRect(this._prevFrame.left, this._prevFrame.top, this._prevFrame.width, this._prevFrame.height);
	            } else if (this._prevFrame && this._prevFrame.disposeOp == 2) {
	                this.context.putImageData(this._prevFrameData, this._prevFrame.left, this._prevFrame.top);
	            }

	            var frame = this.currentFrame;
	            this._prevFrame = frame;
	            this._prevFrameData = null;
	            if (frame.disposeOp == 2) {
	                this._prevFrameData = this.context.getImageData(frame.left, frame.top, frame.width, frame.height);
	            }
	            if (frame.blendOp == 0) {
	                this.context.clearRect(frame.left, frame.top, frame.width, frame.height);
	            }

	            this.context.drawImage(frame.imageElement, frame.left, frame.top);

	            this.emit('frame', this._currentFrameNumber);
	            if (this._ended) {
	                this.emit('end');
	            }
	        }

	        // playback

	    }, {
	        key: 'play',
	        value: function play() {
	            var _this2 = this;

	            if (this._rafId) {
	                cancelAnimationFrame(this._rafId);
	            }

	            this.emit('play');

	            if (this._ended) {
	                this.stop();
	            }
	            this._paused = false;

	            var nextRenderTime = performance.now() + this.currentFrame.delay / this.playbackRate;
	            var tick = function tick(now) {
	                if (_this2._ended || _this2._paused) {
	                    return;
	                }
	                if (now >= nextRenderTime) {
	                    while (now - nextRenderTime >= _this2._apng.playTime / _this2.playbackRate) {
	                        nextRenderTime += _this2._apng.playTime / _this2.playbackRate;
	                        _this2._numPlays++;
	                    }
	                    do {
	                        _this2.renderNextFrame();
	                        nextRenderTime += _this2.currentFrame.delay / _this2.playbackRate;
	                    } while (!_this2._ended && !_this2._paused && now > nextRenderTime);
	                }
	                _this2._rafId = requestAnimationFrame(tick);
	            };
	            this._rafId = requestAnimationFrame(tick);
	        }
	    }, {
	        key: 'pause',
	        value: function pause() {
	            if (!this._paused) {
	                if (this._rafId) {
	                    cancelAnimationFrame(this._rafId);
	                    this._rafId = null;
	                }
	                this.emit('pause');
	                this._paused = true;
	            }
	        }
	    }, {
	        key: 'stop',
	        value: function stop() {
	            if (this._rafId) {
	                cancelAnimationFrame(this._rafId);
	                this._rafId = null;
	            }
	            this.emit('stop');
	            this._numPlays = 0;
	            this._ended = false;
	            this._paused = true;
	            // render first frame
	            this._currentFrameNumber = -1;
	            this.context.clearRect(0, 0, this._apng.width, this._apng.height);
	            this.renderNextFrame();
	        }
	    }, {
	        key: 'currentFrameNumber',
	        get: function get() {
	            return this._currentFrameNumber;
	        }

	        /**
	         *
	         * @return {Frame}
	         */

	    }, {
	        key: 'currentFrame',
	        get: function get() {
	            return this._apng.frames[this._currentFrameNumber];
	        }
	    }, {
	        key: 'paused',
	        get: function get() {
	            return this._paused;
	        }
	    }, {
	        key: 'ended',
	        get: function get() {
	            return this._ended;
	        }
	    }]);

	    return _class;
	}(_events2.default);

	exports.default = _class;

/***/ }),
/* 4 */
/***/ (function(module, exports) {

	// Copyright Joyent, Inc. and other Node contributors.
	//
	// Permission is hereby granted, free of charge, to any person obtaining a
	// copy of this software and associated documentation files (the
	// "Software"), to deal in the Software without restriction, including
	// without limitation the rights to use, copy, modify, merge, publish,
	// distribute, sublicense, and/or sell copies of the Software, and to permit
	// persons to whom the Software is furnished to do so, subject to the
	// following conditions:
	//
	// The above copyright notice and this permission notice shall be included
	// in all copies or substantial portions of the Software.
	//
	// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
	// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
	// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
	// NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
	// DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
	// OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
	// USE OR OTHER DEALINGS IN THE SOFTWARE.

	function EventEmitter() {
	  this._events = this._events || {};
	  this._maxListeners = this._maxListeners || undefined;
	}
	module.exports = EventEmitter;

	// Backwards-compat with node 0.10.x
	EventEmitter.EventEmitter = EventEmitter;

	EventEmitter.prototype._events = undefined;
	EventEmitter.prototype._maxListeners = undefined;

	// By default EventEmitters will print a warning if more than 10 listeners are
	// added to it. This is a useful default which helps finding memory leaks.
	EventEmitter.defaultMaxListeners = 10;

	// Obviously not all Emitters should be limited to 10. This function allows
	// that to be increased. Set to zero for unlimited.
	EventEmitter.prototype.setMaxListeners = function(n) {
	  if (!isNumber(n) || n < 0 || isNaN(n))
	    throw TypeError('n must be a positive number');
	  this._maxListeners = n;
	  return this;
	};

	EventEmitter.prototype.emit = function(type) {
	  var er, handler, len, args, i, listeners;

	  if (!this._events)
	    this._events = {};

	  // If there is no 'error' event listener then throw.
	  if (type === 'error') {
	    if (!this._events.error ||
	        (isObject(this._events.error) && !this._events.error.length)) {
	      er = arguments[1];
	      if (er instanceof Error) {
	        throw er; // Unhandled 'error' event
	      } else {
	        // At least give some kind of context to the user
	        var err = new Error('Uncaught, unspecified "error" event. (' + er + ')');
	        err.context = er;
	        throw err;
	      }
	    }
	  }

	  handler = this._events[type];

	  if (isUndefined(handler))
	    return false;

	  if (isFunction(handler)) {
	    switch (arguments.length) {
	      // fast cases
	      case 1:
	        handler.call(this);
	        break;
	      case 2:
	        handler.call(this, arguments[1]);
	        break;
	      case 3:
	        handler.call(this, arguments[1], arguments[2]);
	        break;
	      // slower
	      default:
	        args = Array.prototype.slice.call(arguments, 1);
	        handler.apply(this, args);
	    }
	  } else if (isObject(handler)) {
	    args = Array.prototype.slice.call(arguments, 1);
	    listeners = handler.slice();
	    len = listeners.length;
	    for (i = 0; i < len; i++)
	      listeners[i].apply(this, args);
	  }

	  return true;
	};

	EventEmitter.prototype.addListener = function(type, listener) {
	  var m;

	  if (!isFunction(listener))
	    throw TypeError('listener must be a function');

	  if (!this._events)
	    this._events = {};

	  // To avoid recursion in the case that type === "newListener"! Before
	  // adding it to the listeners, first emit "newListener".
	  if (this._events.newListener)
	    this.emit('newListener', type,
	              isFunction(listener.listener) ?
	              listener.listener : listener);

	  if (!this._events[type])
	    // Optimize the case of one listener. Don't need the extra array object.
	    this._events[type] = listener;
	  else if (isObject(this._events[type]))
	    // If we've already got an array, just append.
	    this._events[type].push(listener);
	  else
	    // Adding the second element, need to change to array.
	    this._events[type] = [this._events[type], listener];

	  // Check for listener leak
	  if (isObject(this._events[type]) && !this._events[type].warned) {
	    if (!isUndefined(this._maxListeners)) {
	      m = this._maxListeners;
	    } else {
	      m = EventEmitter.defaultMaxListeners;
	    }

	    if (m && m > 0 && this._events[type].length > m) {
	      this._events[type].warned = true;
	      console.error('(node) warning: possible EventEmitter memory ' +
	                    'leak detected. %d listeners added. ' +
	                    'Use emitter.setMaxListeners() to increase limit.',
	                    this._events[type].length);
	      if (typeof console.trace === 'function') {
	        // not supported in IE 10
	        console.trace();
	      }
	    }
	  }

	  return this;
	};

	EventEmitter.prototype.on = EventEmitter.prototype.addListener;

	EventEmitter.prototype.once = function(type, listener) {
	  if (!isFunction(listener))
	    throw TypeError('listener must be a function');

	  var fired = false;

	  function g() {
	    this.removeListener(type, g);

	    if (!fired) {
	      fired = true;
	      listener.apply(this, arguments);
	    }
	  }

	  g.listener = listener;
	  this.on(type, g);

	  return this;
	};

	// emits a 'removeListener' event iff the listener was removed
	EventEmitter.prototype.removeListener = function(type, listener) {
	  var list, position, length, i;

	  if (!isFunction(listener))
	    throw TypeError('listener must be a function');

	  if (!this._events || !this._events[type])
	    return this;

	  list = this._events[type];
	  length = list.length;
	  position = -1;

	  if (list === listener ||
	      (isFunction(list.listener) && list.listener === listener)) {
	    delete this._events[type];
	    if (this._events.removeListener)
	      this.emit('removeListener', type, listener);

	  } else if (isObject(list)) {
	    for (i = length; i-- > 0;) {
	      if (list[i] === listener ||
	          (list[i].listener && list[i].listener === listener)) {
	        position = i;
	        break;
	      }
	    }

	    if (position < 0)
	      return this;

	    if (list.length === 1) {
	      list.length = 0;
	      delete this._events[type];
	    } else {
	      list.splice(position, 1);
	    }

	    if (this._events.removeListener)
	      this.emit('removeListener', type, listener);
	  }

	  return this;
	};

	EventEmitter.prototype.removeAllListeners = function(type) {
	  var key, listeners;

	  if (!this._events)
	    return this;

	  // not listening for removeListener, no need to emit
	  if (!this._events.removeListener) {
	    if (arguments.length === 0)
	      this._events = {};
	    else if (this._events[type])
	      delete this._events[type];
	    return this;
	  }

	  // emit removeListener for all listeners on all events
	  if (arguments.length === 0) {
	    for (key in this._events) {
	      if (key === 'removeListener') continue;
	      this.removeAllListeners(key);
	    }
	    this.removeAllListeners('removeListener');
	    this._events = {};
	    return this;
	  }

	  listeners = this._events[type];

	  if (isFunction(listeners)) {
	    this.removeListener(type, listeners);
	  } else if (listeners) {
	    // LIFO order
	    while (listeners.length)
	      this.removeListener(type, listeners[listeners.length - 1]);
	  }
	  delete this._events[type];

	  return this;
	};

	EventEmitter.prototype.listeners = function(type) {
	  var ret;
	  if (!this._events || !this._events[type])
	    ret = [];
	  else if (isFunction(this._events[type]))
	    ret = [this._events[type]];
	  else
	    ret = this._events[type].slice();
	  return ret;
	};

	EventEmitter.prototype.listenerCount = function(type) {
	  if (this._events) {
	    var evlistener = this._events[type];

	    if (isFunction(evlistener))
	      return 1;
	    else if (evlistener)
	      return evlistener.length;
	  }
	  return 0;
	};

	EventEmitter.listenerCount = function(emitter, type) {
	  return emitter.listenerCount(type);
	};

	function isFunction(arg) {
	  return typeof arg === 'function';
	}

	function isNumber(arg) {
	  return typeof arg === 'number';
	}

	function isObject(arg) {
	  return typeof arg === 'object' && arg !== null;
	}

	function isUndefined(arg) {
	  return arg === void 0;
	}


/***/ })
/******/ ])
});
;

/***/ }),

/***/ 5339:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Fields_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(4598);
/* harmony import */ var _Rendering_VertexArray_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(2062);
/* harmony import */ var _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(2340);
/* harmony import */ var _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(2212);
/* harmony import */ var _Base_X3DCast_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(7638);
/* harmony import */ var _Browser_Rendering_MikkTSpace_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(9334);
/* harmony import */ var _standard_Math_Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(7572);
/* harmony import */ var _standard_Math_Numbers_Vector4_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(8913);
/* harmony import */ var _standard_Math_Numbers_Matrix4_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(6179);
/* harmony import */ var _standard_Math_Geometry_Box3_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(2918);
/* harmony import */ var _standard_Math_Geometry_Plane3_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(5143);
/* harmony import */ var _standard_Math_Algorithm_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(780);
/* harmony import */ var _DEVELOPMENT_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(615);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(717);














// Box normals for bbox / line intersection.
const boxNormals = [
   _standard_Math_Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .Z_AXIS,          // front
   _standard_Math_Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .NEGATIVE_Z_AXIS, // back
   _standard_Math_Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .Y_AXIS,          // top
   _standard_Math_Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .NEGATIVE_Y_AXIS, // bottom
   _standard_Math_Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A .X_AXIS,          // right
   // left: We do not need to test for left.
];

function X3DGeometryNode (executionContext)
{
   _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .call (this, executionContext);

   this .addType (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .X3DGeometryNode);

   this .addChildObjects (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .outputOnly, "transparent",  new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFBool (),
                          _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .outputOnly, "bbox_changed", new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFTime (),
                          _Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .outputOnly, "rebuild",      new _Fields_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .SFTime (Date .now () / 1000));

   // Members

   const browser = this .getBrowser ();

   this .min                      = new _standard_Math_Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A ();
   this .max                      = new _standard_Math_Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A ();
   this .bbox                     = _standard_Math_Geometry_Box3_js__WEBPACK_IMPORTED_MODULE_9__/* ["default"] */ .A .Extents (this .min, this .max);
   this .solid                    = true;
   this .primitiveMode            = browser .getContext () .TRIANGLES;
   this .geometryType             = 3;
   this .colorMaterial            = false;
   this .attribNodes              = [ ];
   this .attribArrays             = [ ];
   this .textureCoordinateMapping = new Map ();
   this .multiTexCoords           = [ ];
   this .coordIndices             = X3DGeometryNode .createArray ();
   this .texCoords                = X3DGeometryNode .createArray ();
   this .fogDepths                = X3DGeometryNode .createArray ();
   this .colors                   = X3DGeometryNode .createArray ();
   this .tangents                 = X3DGeometryNode .createArray ();
   this .normals                  = X3DGeometryNode .createArray ();
   this .vertices                 = X3DGeometryNode .createArray ();
   this .hasFogCoords             = false;
   this .hasNormals               = false;
   this .geometryKey              = "";
   this .vertexCount              = 0;
   this .planes                   = [ ];

   for (let i = 0; i < 5; ++ i)
      this .planes [i] = new _standard_Math_Geometry_Plane3_js__WEBPACK_IMPORTED_MODULE_10__/* ["default"] */ .A ();
}

class GeometryArray extends Array
{
   #typedArray = new Float32Array ();

   assign (value)
   {
      const length = value .length;

      for (let i = 0; i < length; ++ i)
         this [i] = value [i];

      this .length = length;
   }

   getValue ()
   {
      return this .#typedArray;
   }

   shrinkToFit ()
   {
      if (this .length === this .#typedArray .length)
         this .#typedArray .set (this);
      else
         this .#typedArray = new Float32Array (this);
   }
}

Object .defineProperty (X3DGeometryNode, "createArray",
{
   // Function to select ether Array or MFFloat for color/normal/vertex arrays.
   // Array version runs faster, see BeyondGermany and TreasureIsland.
   value ()
   {
      // return new Fields .MFFloat ();

      return new GeometryArray ();
   },
})

Object .assign (Object .setPrototypeOf (X3DGeometryNode .prototype, _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .prototype),
{
   setup ()
   {
      _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .prototype .setup .call (this);

      this .rebuild ();
   },
   initialize ()
   {
      _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .prototype .initialize .call (this);

      const
         browser = this .getBrowser (),
         gl      = browser .getContext ();

      this .getLive () .addInterest ("set_live__", this);

      this .addInterest ("requestRebuild", this);
      this ._rebuild .addInterest ("rebuild", this);

      this .coordIndexBuffer      = gl .createBuffer ();
      this .attribBuffers         = [ ];
      this .textureCoordinateNode = browser .getDefaultTextureCoordinate ();
      this .texCoordBuffers       = Array .from ({length: browser .getMaxTexCoords ()}, () => gl .createBuffer ());
      this .fogDepthBuffer        = gl .createBuffer ();
      this .colorBuffer           = gl .createBuffer ();
      this .tangentBuffer         = gl .createBuffer ();
      this .normalBuffer          = gl .createBuffer ();
      this .vertexBuffer          = gl .createBuffer ();
      this .vertexArrayObject     = new _Rendering_VertexArray_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A (gl);

      this .setCCW (true);
      this .set_live__ ();
   },
   getGeometryType ()
   {
      return this .geometryType;
   },
   setGeometryType (value)
   {
      this .geometryType = value;
   },
   setTransparent (value)
   {
      if (!!value !== this ._transparent .getValue ())
         this ._transparent = value;
   },
   isTransparent ()
   {
      return this ._transparent .getValue ();
   },
   getBBox ()
   {
      // With screen matrix applied.
      return this .bbox;
   },
   setBBox (bbox)
   {
      if (bbox .equals (this .bbox))
         return;

      bbox .getExtents (this .min, this .max);

      this .bbox .assign (bbox);

      for (let i = 0; i < 5; ++ i)
         this .planes [i] .set (i % 2 ? this .min : this .max, boxNormals [i]);

      this ._bbox_changed .addEvent ();
   },
   getMin ()
   {
      // With screen matrix applied.
      return this .min;
   },
   getMax ()
   {
      // With screen matrix applied.
      return this .max;
   },
   getMatrix ()
   {
      return _standard_Math_Numbers_Matrix4_js__WEBPACK_IMPORTED_MODULE_8__/* ["default"] */ .A .IDENTITY;
   },
   getPrimitiveMode ()
   {
      return this .primitiveMode;
   },
   setPrimitiveMode (value)
   {
      this .primitiveMode = value;
   },
   setSolid (value)
   {
      this .solid = value;
   },
   isSolid ()
   {
      return this .solid;
   },
   setCCW (value)
   {
      const gl = this .getBrowser () .getContext ();

      this .frontFace = value ? gl .CCW : gl .CW;
      this .backFace  = value ? gl .CW  : gl .CCW;
   },
   getCoordIndices ()
   {
      return this .coordIndices;
   },
   getAttrib ()
   {
      return this .attribNodes;
   },
   getAttribs ()
   {
      return this .attribArrays;
   },
   getAttribBuffers ()
   {
      return this .attribBuffers;
   },
   getFogDepths ()
   {
      return this .fogDepths;
   },
   getColors ()
   {
      return this .colors;
   },
   getMultiTexCoords ()
   {
      return this .multiTexCoords;
   },
   getTexCoords ()
   {
      return this .texCoords;
   },
   getTextureCoordinate ()
   {
      return this .textureCoordinateNode;
   },
   setTextureCoordinate (value)
   {
      this .textureCoordinateNode .removeInterest ("updateTextureCoordinateMapping", this);

      this .textureCoordinateNode = value ?? this .getBrowser () .getDefaultTextureCoordinate ();

      this .textureCoordinateNode .addInterest ("updateTextureCoordinateMapping", this);

      this .updateTextureCoordinateMapping ();
   },
   getTextureCoordinateMapping ()
   {
      return this .textureCoordinateMapping;
   },
   updateTextureCoordinateMapping ()
   {
      this .textureCoordinateMapping .clear ();

      this .textureCoordinateNode .getTextureCoordinateMapping (this .textureCoordinateMapping);
   },
   getTangents ()
   {
      return this .tangents;
   },
   getNormals ()
   {
      return this .normals;
   },
   getVertices ()
   {
      return this .vertices;
   },
   updateVertexArrays ()
   {
      this .vertexArrayObject .update ();

      this .updateInstances = true;
   },
   generateTexCoords ()
   {
      const texCoords = this .texCoords;

      if (texCoords .length === 0)
      {
         const
            p         = this .getTexCoordParams (),
            min       = p .min,
            Sindex    = p .Sindex,
            Tindex    = p .Tindex,
            Ssize     = p .Ssize,
            S         = min [Sindex],
            T         = min [Tindex],
            vertices  = this .vertices .getValue (),
            length    = vertices .length;

         for (let i = 0; i < length; i += 4)
         {
            texCoords .push ((vertices [i + Sindex] - S) / Ssize,
                             (vertices [i + Tindex] - T) / Ssize,
                             0,
                             1);
         }

         texCoords .shrinkToFit ();
      }

      this .getMultiTexCoords () .push (texCoords);
   },
   getTexCoordParams: (() =>
   {
      const texCoordParams = { min: new _standard_Math_Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A (), Ssize: 0, Sindex: 0, Tindex: 0 };

      return function ()
      {
         const
            bbox  = this .getBBox (),
            size  = bbox .size,
            Xsize = size .x,
            Ysize = size .y,
            Zsize = size .z;

         texCoordParams .min .assign (bbox .center) .subtract (size .divide (2));

         if ((Xsize >= Ysize) && (Xsize >= Zsize))
         {
            // X size largest
            texCoordParams .Ssize  = Xsize;
            texCoordParams .Sindex = 0;

            if (Ysize >= Zsize)
               texCoordParams .Tindex = 1;
            else
               texCoordParams .Tindex = 2;
         }
         else if ((Ysize >= Xsize) && (Ysize >= Zsize))
         {
            // Y size largest
            texCoordParams .Ssize  = Ysize;
            texCoordParams .Sindex = 1;

            if (Xsize >= Zsize)
               texCoordParams .Tindex = 0;
            else
               texCoordParams .Tindex = 2;
         }
         else
         {
            // Z is the largest
            texCoordParams .Ssize  = Zsize;
            texCoordParams .Sindex = 2;

            if (Xsize >= Ysize)
               texCoordParams .Tindex = 0;
            else
               texCoordParams .Tindex = 1;
         }

         return texCoordParams;
      };
   })(),
   generateTangents ()
   {
      try
      {
         if (this .geometryType < 2)
            return;

         if (!this .vertices .length)
            return;

         if (!_Browser_Rendering_MikkTSpace_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .isInitialized ())
            return void (_Browser_Rendering_MikkTSpace_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .initialize () .then (() => this .requestRebuild ()));

         const
            vertices  = this .vertices .getValue () .filter ((v, i) => i % 4 < 3),
            normals   = this .normals .getValue (),
            texCoords = this .multiTexCoords [0] .getValue () .filter ((v, i) => i % 4 < 2),
            tangents  = _Browser_Rendering_MikkTSpace_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A .generateTangents (vertices, normals, texCoords),
            length    = tangents .length;

         // Convert coordinate system handedness to respect output format of MikkTSpace.
         for (let i = 3; i < length; i += 4)
            tangents [i] = -tangents [i]; // Flip w-channel.

         this .tangents .assign (tangents);
         this .tangents .shrinkToFit ();
      }
      catch (error)
      {
         if (_DEVELOPMENT_js__WEBPACK_IMPORTED_MODULE_12__/* ["default"] */ .A)
            console .error (error);
      }
   },
   refineNormals (normalIndex, normals, creaseAngle)
   {
      if (creaseAngle <= 0)
         return normals;

      const
         cosCreaseAngle = Math .cos (_standard_Math_Algorithm_js__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .A .clamp (creaseAngle, 0, Math .PI)),
         refinedNormals = [ ];

      for (const vertex of normalIndex .values ())
      {
         for (const p of vertex)
         {
            const
               P = normals [p],
               N = new _standard_Math_Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A ();

            for (const q of vertex)
            {
               const Q = normals [q];

               if (Q .dot (P) > cosCreaseAngle)
                  N .add (Q);
            }

            refinedNormals [p] = N .normalize ();
         }
      }

      return refinedNormals;
   },
   transformLine (hitRay)
   {
      // Apply screen nodes transformation in place here.
   },
   transformMatrix (hitRay)
   {
      // Apply screen nodes transformation in place here.
   },
   intersectsLine: (() =>
   {
      const
         modelViewMatrix = new _standard_Math_Numbers_Matrix4_js__WEBPACK_IMPORTED_MODULE_8__/* ["default"] */ .A (),
         uvt             = { u: 0, v: 0, t: 0 },
         v0              = new _standard_Math_Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A (),
         v1              = new _standard_Math_Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A (),
         v2              = new _standard_Math_Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A ();

      return function (hitRay, matrix, intersections)
      {
         if (this .intersectsBBox (hitRay))
         {
            this .transformLine (hitRay); // Apply screen transformations from screen nodes.
            this .transformMatrix (modelViewMatrix .assign (matrix)); // Apply screen transformations from screen nodes.

            const
               texCoords   = this .multiTexCoords [0] .getValue (),
               normals     = this .normals .getValue (),
               vertices    = this .vertices .getValue (),
               vertexCount = this .vertexCount;

            for (let i = 0; i < vertexCount; i += 3)
            {
               const i4 = i * 4;

               v0 .x = vertices [i4];     v0 .y = vertices [i4 + 1]; v0 .z = vertices [i4 +  2];
               v1 .x = vertices [i4 + 4]; v1 .y = vertices [i4 + 5]; v1 .z = vertices [i4 +  6];
               v2 .x = vertices [i4 + 8]; v2 .y = vertices [i4 + 9]; v2 .z = vertices [i4 + 10];

               if (!hitRay .intersectsTriangle (v0, v1, v2, uvt))
                  continue;

               // Get barycentric coordinates.

               const { u, v, t } = uvt;

               // Determine vectors for LinePickSensor.

               const point = new _standard_Math_Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A (u * vertices [i4]     + v * vertices [i4 + 4] + t * vertices [i4 +  8],
                                          u * vertices [i4 + 1] + v * vertices [i4 + 5] + t * vertices [i4 +  9],
                                          u * vertices [i4 + 2] + v * vertices [i4 + 6] + t * vertices [i4 + 10]);

               const texCoord = new _standard_Math_Numbers_Vector4_js__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .A (u * texCoords [i4]     + v * texCoords [i4 + 4] + t * texCoords [i4 + 8],
                                             u * texCoords [i4 + 1] + v * texCoords [i4 + 5] + t * texCoords [i4 + 9],
                                             u * texCoords [i4 + 2] + v * texCoords [i4 + 6] + t * texCoords [i4 + 10],
                                             u * texCoords [i4 + 3] + v * texCoords [i4 + 7] + t * texCoords [i4 + 11]);

               const i3 = i * 3;

               const normal = new _standard_Math_Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A (u * normals [i3]     + v * normals [i3 + 3] + t * normals [i3 + 6],
                                           u * normals [i3 + 1] + v * normals [i3 + 4] + t * normals [i3 + 7],
                                           u * normals [i3 + 2] + v * normals [i3 + 5] + t * normals [i3 + 8]);

               intersections .push ({ texCoord, normal, point: this .getMatrix () .multVecMatrix (point) });
            }
         }

         return intersections .length;
      };
   })(),
   intersectsBBox: (() =>
   {
      const intersection = new _standard_Math_Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A ();

      return function (hitRay)
      {
         const { min, max, planes } = this;

         const
            minX = min .x,
            maxX = max .x,
            minY = min .y,
            maxY = max .y,
            minZ = min .z,
            maxZ = max .z;

         // front
         if (planes [0] .intersectsLine (hitRay, intersection))
         {
            if (intersection .x >= minX && intersection .x <= maxX &&
                intersection .y >= minY && intersection .y <= maxY)
               return true;
         }

         // back
         if (planes [1] .intersectsLine (hitRay, intersection))
         {
            if (intersection .x >= minX && intersection .x <= maxX &&
                intersection .y >= minY && intersection .y <= maxY)
               return true;
         }

         // top
         if (planes [2] .intersectsLine (hitRay, intersection))
         {
            if (intersection .x >= minX && intersection .x <= maxX &&
                intersection .z >= minZ && intersection .z <= maxZ)
               return true;
         }

         // bottom
         if (planes [3] .intersectsLine (hitRay, intersection))
         {
            if (intersection .x >= minX && intersection .x <= maxX &&
                intersection .z >= minZ && intersection .z <= maxZ)
               return true;
         }

         // right
         if (planes [4] .intersectsLine (hitRay, intersection))
         {
            if (intersection .y >= minY && intersection .y <= maxY &&
                intersection .z >= minZ && intersection .z <= maxZ)
               return true;
         }

         return false;
      };
   })(),
   set_live__ ()
   {
      // Is overloaded by primitives with option nodes.
   },
   connectOptions (options)
   {
      const
         browser      = this .getBrowser (),
         alwaysUpdate = this .isLive () && browser .getBrowserOption ("AlwaysUpdateGeometries");

      if (this .getLive () .getValue () || alwaysUpdate)
      {
         options .addInterest ("requestRebuild", this);

         if (options .getModificationTime () >= this ._rebuild .getValue ())
            this .requestRebuild ();
      }
      else
      {
         options .removeInterest ("requestRebuild", this);
      }
   },
   requestRebuild ()
   {
      this ._rebuild = Date .now () / 1000;
   },
   rebuild ()
   {
      this .clear ();
      this .build ();

      // Shrink arrays before transferring them to graphics card.

      for (const attribArray of this .attribArrays)
         attribArray .shrinkToFit ();

      for (const multiTexCoord of this .multiTexCoords)
         multiTexCoord .shrinkToFit ();

      this .coordIndices .shrinkToFit ();
      this .fogDepths    .shrinkToFit ();
      this .colors       .shrinkToFit ();
      this .tangents     .shrinkToFit ();
      this .normals      .shrinkToFit ();
      this .vertices     .shrinkToFit ();

      this .updateBBox ();

      // Generate texCoord if needed.

      if (!this .multiTexCoords .length)
         this .generateTexCoords ();

      // Generate tangents if needed.

      if (!this .tangents .length)
         this .generateTangents ();

      // Transfer arrays and update.

      this .transfer ();
      this .updateGeometryKey ();
      this .updateRenderFunctions ();
   },
   clear ()
   {
      // BBox

      this .min .set (Number .POSITIVE_INFINITY);
      this .max .set (Number .NEGATIVE_INFINITY);

      // Create attribArray arrays.
      {
         const attribArrays = this .attribArrays;

         for (const attribArray of attribArrays)
            attribArray .length = 0;

         const length = this .attribNodes .length;

         for (let a = attribArrays .length; a < length; ++ a)
            attribArrays [a] = X3DGeometryNode .createArray ();

         attribArrays .length = length;
      }

      // Buffer

      this .coordIndices   .length = 0;
      this .fogDepths      .length = 0;
      this .colors         .length = 0;
      this .multiTexCoords .length = 0;
      this .texCoords      .length = 0;
      this .tangents       .length = 0;
      this .normals        .length = 0;
      this .vertices       .length = 0;
   },
   updateBBox: (() =>
   {
      const point = new _standard_Math_Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .A ();

      return function ()
      {
         // Determine bbox.

         const
            vertices    = this .vertices .getValue (),
            numVertices = vertices .length,
            min         = this .min,
            max         = this .max;

         if (numVertices)
         {
            if (min .x === Number .POSITIVE_INFINITY)
            {
               for (let i = 0; i < numVertices; i += 4)
               {
                  const { [i]: v1, [i + 1]: v2, [i + 2]: v3 } = vertices;

                  point .set (v1, v2, v3);

                  min .min (point);
                  max .max (point);
               }
            }

            this .bbox .setExtents (min, max);
         }
         else
         {
            this .bbox .setExtents (min .set (0), max .set (0));
         }

         for (let i = 0; i < 5; ++ i)
            this .planes [i] .set (i % 2 ? min : max, boxNormals [i]);

         this ._bbox_changed .addEvent ();
      };
   })(),
   transfer ()
   {
      const gl = this .getBrowser () .getContext ();

      // Transfer coord indices.

      gl .bindBuffer (gl .ARRAY_BUFFER, this .coordIndexBuffer);
      gl .bufferData (gl .ARRAY_BUFFER, this .coordIndices .getValue (), gl .DYNAMIC_DRAW);

      // Transfer attribArrays.

      for (let i = this .attribBuffers .length, length = this .attribArrays .length; i < length; ++ i)
         this .attribBuffers .push (gl .createBuffer ());

      for (let i = 0, length = this .attribArrays .length; i < length; ++ i)
      {
         gl .bindBuffer (gl .ARRAY_BUFFER, this .attribBuffers [i]);
         gl .bufferData (gl .ARRAY_BUFFER, this .attribArrays [i] .getValue (), gl .DYNAMIC_DRAW);
      }

      // Transfer fog depths.

      const lastHasFogCoords = this .hasFogCoords;

      gl .bindBuffer (gl .ARRAY_BUFFER, this .fogDepthBuffer);
      gl .bufferData (gl .ARRAY_BUFFER, this .fogDepths .getValue (), gl .DYNAMIC_DRAW);

      this .hasFogCoords = !! this .fogDepths .length;

      if (this .hasFogCoords !== lastHasFogCoords)
         this .updateVertexArrays ();

      // Transfer colors.

      const lastColorMaterial = this .colorMaterial;

      gl .bindBuffer (gl .ARRAY_BUFFER, this .colorBuffer);
      gl .bufferData (gl .ARRAY_BUFFER, this .colors .getValue (), gl .DYNAMIC_DRAW);

      this .colorMaterial = !! this .colors .length;

      if (this .colorMaterial !== lastColorMaterial)
         this .updateVertexArrays ();

      // Transfer multiTexCoords.

      for (let i = 0, length = this .multiTexCoords .length; i < length; ++ i)
      {
         gl .bindBuffer (gl .ARRAY_BUFFER, this .texCoordBuffers [i]);
         gl .bufferData (gl .ARRAY_BUFFER, this .multiTexCoords [i] .getValue (), gl .DYNAMIC_DRAW);
      }

      // Transfer tangents.

      const lastHasTangents = this .hasTangents;

      gl .bindBuffer (gl .ARRAY_BUFFER, this .tangentBuffer);
      gl .bufferData (gl .ARRAY_BUFFER, this .tangents .getValue (), gl .DYNAMIC_DRAW);

      this .hasTangents = !! this .tangents .length;

      if (this .hasTangents !== lastHasTangents)
         this .updateVertexArrays ();

      // Transfer normals or flat normals.

      const lastHasNormals = this .hasNormals;

      gl .bindBuffer (gl .ARRAY_BUFFER, this .normalBuffer);
      gl .bufferData (gl .ARRAY_BUFFER, this .normals .getValue (), gl .DYNAMIC_DRAW);

      this .hasNormals = !! this .normals .length;

      if (this .hasNormals !== lastHasNormals)
         this .updateVertexArrays ();

      // Transfer vertices.

      gl .bindBuffer (gl .ARRAY_BUFFER, this .vertexBuffer);
      gl .bufferData (gl .ARRAY_BUFFER, this .vertices .getValue (), gl .DYNAMIC_DRAW);

      this .vertexCount = this .vertices .length / 4;
   },
   updateGeometryKey ()
   {
      let key = "";

      key += this .geometryType;
      key += this .hasFogCoords  ? 1 : 0;
      key += this .colorMaterial ? 1 : 0;
      key += this .hasTangents   ? 1 : 0;
      key += this .hasNormals    ? 1 : 0;

      this .geometryKey = key;
   },
   updateRenderFunctions ()
   {
      if (this .vertexCount)
      {
         // Use default render functions.

         delete this .displaySimple;
         delete this .display;
         delete this .displaySimpleInstanced;
         delete this .displayInstanced;
      }
      else
      {
         // Use no render function.

         this .displaySimple          = Function .prototype;
         this .display                = Function .prototype;
         this .displaySimpleInstanced = Function .prototype;
         this .displayInstanced       = Function .prototype;
      }
   },
   traverse (type, renderObject)
   { },
   displaySimple (gl, renderContext, shaderNode)
   {
      if (this .vertexArrayObject .enable (shaderNode .getProgram ()))
      {
         if (this .coordIndices .length)
            shaderNode .enableCoordIndexAttribute (gl, this .coordIndexBuffer, 0, 0);

         if (this .multiTexCoords .length)
            shaderNode .enableTexCoordAttribute (gl, this .texCoordBuffers, 0, 0);

         if (this .hasNormals)
            shaderNode .enableNormalAttribute (gl, this .normalBuffer, 0, 0);

         shaderNode .enableVertexAttribute (gl, this .vertexBuffer, 0, 0);
      }

      gl .drawArrays (this .primitiveMode, 0, this .vertexCount);
   },
   display (gl, renderContext)
   {
      const
         { viewport, appearanceNode, modelViewMatrix } = renderContext,
         browser         = this .getBrowser (),
         primitiveMode   = browser .getPrimitiveMode (this .primitiveMode),
         renderModeNodes = appearanceNode .getRenderModes (),
         shaderNode      = appearanceNode .getShader (this, renderContext);

      // Set viewport.

      gl .viewport (... viewport);

      // Enable render mode nodes.

      for (const node of renderModeNodes)
         node .enable (gl);

      // Handle negative scale.

      const positiveScale = _standard_Math_Numbers_Matrix4_js__WEBPACK_IMPORTED_MODULE_8__/* ["default"] */ .A .prototype .determinant3 .call (modelViewMatrix) > 0;

      gl .frontFace (positiveScale ? this .frontFace : this .backFace);

      // Draw front and back faces.

      if (this .solid || !appearanceNode .getBackMaterial ())
      {
         this .displayGeometry (gl, renderContext, shaderNode, primitiveMode, true, true);
      }
      else
      {
         const backShaderNode = appearanceNode .getBackShader (this, renderContext);

         this .displayGeometry (gl, renderContext, backShaderNode, primitiveMode, true,  false);
         this .displayGeometry (gl, renderContext, shaderNode,     primitiveMode, false, true);
      }

      // Disable render mode nodes.

      for (const node of renderModeNodes)
         node .disable (gl);

      // Reset texture units.

      browser .resetTextureUnits ();
   },
   displayGeometry (gl, renderContext, shaderNode, primitiveMode, back, front)
   {
      shaderNode .enable (gl);
      shaderNode .setUniforms (gl, renderContext, this, front);

      // Setup vertex attributes.

      if (this .vertexArrayObject .enable (shaderNode .getProgram ()))
      {
         const
            attribNodes   = this .getAttrib (),
            attribBuffers = this .getAttribBuffers ();

         if (this .coordIndices .length)
            shaderNode .enableCoordIndexAttribute (gl, this .coordIndexBuffer, 0, 0);

         for (let i = 0, length = attribNodes .length; i < length; ++ i)
            attribNodes [i] .enable (gl, shaderNode, attribBuffers [i]);

         if (this .hasFogCoords)
            shaderNode .enableFogDepthAttribute (gl, this .fogDepthBuffer, 0, 0);

         if (this .colorMaterial)
            shaderNode .enableColorAttribute (gl, this .colorBuffer, 0, 0);

         if (this .hasTangents)
            shaderNode .enableTangentAttribute (gl, this .tangentBuffer, 0, 0);

         shaderNode .enableTexCoordAttribute (gl, this .texCoordBuffers, 0, 0);
         shaderNode .enableNormalAttribute   (gl, this .normalBuffer,    0, 0);
         shaderNode .enableVertexAttribute   (gl, this .vertexBuffer,    0, 0);
      }

      // Draw depending on wireframe, solid and transparent.

      if (renderContext .transparent || back !== front)
      {
         // Render transparent or back or front.

         gl .enable (gl .CULL_FACE);

         // Render back.

         if (back && !this .solid)
         {
            gl .cullFace (gl .FRONT);
            gl .drawArrays (primitiveMode, 0, this .vertexCount);
         }

         // Render front.

         if (front)
         {
            gl .cullFace (gl .BACK);
            gl .drawArrays (primitiveMode, 0, this .vertexCount);
         }
      }
      else
      {
         // Render solid or both sides.

         if (this .solid)
            gl .enable (gl .CULL_FACE);
         else
            gl .disable (gl .CULL_FACE);

         gl .drawArrays (primitiveMode, 0, this .vertexCount);
      }
   },
   displaySimpleInstanced (gl, shaderNode, shapeNode)
   {
      const instances = shapeNode .getInstances ();

      if (instances .vertexArrayObject .update (this .updateInstances) .enable (shaderNode .getProgram ()))
      {
         const { instancesStride, particleOffset, matrixOffset, normalMatrixOffset } = shapeNode;

         if (particleOffset !== undefined)
            shaderNode .enableParticleAttribute (gl, instances, instancesStride, particleOffset, 1);

         shaderNode .enableInstanceMatrixAttribute (gl, instances, instancesStride, matrixOffset, 1);

         if (normalMatrixOffset !== undefined)
            shaderNode .enableInstanceNormalMatrixAttribute (gl, instances, instancesStride, normalMatrixOffset, 1);

         if (this .coordIndices .length)
            shaderNode .enableCoordIndexAttribute (gl, this .coordIndexBuffer, 0, 0);

         shaderNode .enableTexCoordAttribute (gl, this .texCoordBuffers, 0, 0);
         shaderNode .enableNormalAttribute   (gl, this .normalBuffer,    0, 0);
         shaderNode .enableVertexAttribute   (gl, this .vertexBuffer,    0, 0);

         this .updateInstances = false;
      }

      gl .drawArraysInstanced (this .primitiveMode, 0, this .vertexCount, shapeNode .getNumInstances ());
   },
   displayInstanced (gl, renderContext, shapeNode)
   {
      const
         { viewport, appearanceNode, modelViewMatrix } = renderContext,
         browser         = this .getBrowser (),
         primitiveMode   = browser .getPrimitiveMode (this .primitiveMode),
         renderModeNodes = appearanceNode .getRenderModes (),
         shaderNode      = appearanceNode .getShader (this, renderContext);

      // Set viewport.

      gl .viewport (... viewport);

      // Enable render mode nodes.

      for (const node of renderModeNodes)
         node .enable (gl);

      // Handle negative scale.

      const positiveScale = _standard_Math_Numbers_Matrix4_js__WEBPACK_IMPORTED_MODULE_8__/* ["default"] */ .A .prototype .determinant3 .call (modelViewMatrix) > 0;

      gl .frontFace (positiveScale ? this .frontFace : this .backFace);

      // Draw front and back faces.

      if (this .solid || !appearanceNode .getBackMaterial ())
      {
         this .displayInstancedGeometry (gl, renderContext, shaderNode, primitiveMode, true, true, shapeNode);
      }
      else
      {
         const backShaderNode = appearanceNode .getBackShader (this, renderContext);

         this .displayInstancedGeometry (gl, renderContext, backShaderNode, primitiveMode, true,  false, shapeNode);
         this .displayInstancedGeometry (gl, renderContext, shaderNode,     primitiveMode, false, true,  shapeNode);
      }

      // Disable render mode nodes.

      for (const node of renderModeNodes)
         node .disable (gl);

      // Reset texture units.

      browser .resetTextureUnits ();
   },
   displayInstancedGeometry (gl, renderContext, shaderNode, primitiveMode, back, front, shapeNode)
   {
      // Setup shader.

      shaderNode .enable (gl);
      shaderNode .setUniforms (gl, renderContext, this, front);

      // Setup vertex attributes.

      const instances = shapeNode .getInstances ();

      if (instances .vertexArrayObject .update (this .updateInstances) .enable (shaderNode .getProgram ()))
      {
         const { instancesStride, particleOffset, velocityOffset, matrixOffset, normalMatrixOffset } = shapeNode;

         const
            attribNodes   = this .getAttrib (),
            attribBuffers = this .getAttribBuffers ();

         if (particleOffset !== undefined)
            shaderNode .enableParticleAttribute (gl, instances, instancesStride, particleOffset, 1);

         if (velocityOffset !== undefined)
            shaderNode .enableParticleVelocityAttribute (gl, instances, instancesStride, velocityOffset, 1);

         shaderNode .enableInstanceMatrixAttribute (gl, instances, instancesStride, matrixOffset, 1);

         if (normalMatrixOffset !== undefined)
            shaderNode .enableInstanceNormalMatrixAttribute (gl, instances, instancesStride, normalMatrixOffset, 1);

         if (this .coordIndices .length)
            shaderNode .enableCoordIndexAttribute (gl, this .coordIndexBuffer, 0, 0);

         for (let i = 0, length = attribNodes .length; i < length; ++ i)
            attribNodes [i] .enable (gl, shaderNode, attribBuffers [i]);

         if (this .hasFogCoords)
            shaderNode .enableFogDepthAttribute (gl, this .fogDepthBuffer, 0, 0);

         if (this .colorMaterial)
            shaderNode .enableColorAttribute (gl, this .colorBuffer, 0, 0);

         if (this .hasTangents)
            shaderNode .enableTangentAttribute  (gl, this .tangentBuffer, 0, 0);

         shaderNode .enableTexCoordAttribute (gl, this .texCoordBuffers, 0, 0);
         shaderNode .enableNormalAttribute   (gl, this .normalBuffer,    0, 0);
         shaderNode .enableVertexAttribute   (gl, this .vertexBuffer,    0, 0);

         this .updateInstances = false;
      }

      // Draw depending on wireframe, solid and transparent.

      if (renderContext .transparent || back !== front)
      {
         // Render transparent or back or front.

         gl .enable (gl .CULL_FACE);

         if (back && !this .solid)
         {
            gl .cullFace (gl .FRONT);
            gl .drawArraysInstanced (primitiveMode, 0, this .vertexCount, shapeNode .getNumInstances ());
         }

         if (front)
         {
            gl .cullFace (gl .BACK);
            gl .drawArraysInstanced (primitiveMode, 0, this .vertexCount, shapeNode .getNumInstances ());
         }
      }
      else
      {
         // Render solid or both sides.

         if (this .solid)
            gl .enable (gl .CULL_FACE);
         else
            gl .disable (gl .CULL_FACE);

         gl .drawArraysInstanced (primitiveMode, 0, this .vertexCount, shapeNode .getNumInstances ());
      }
   },
},
// Common functions for all X3DComposedGeometryNode types and some other nodes:
{
   getFogCoord ()
   {
      return this .fogCoordNode;
   },
   getColor ()
   {
      return this .colorNode;
   },
   getTexCoord ()
   {
      return this .texCoordNode;
   },
   getTangent ()
   {
      return this .tangentNode;
   },
   getNormal ()
   {
      return this .normalNode;
   },
   getCoord ()
   {
      return this .coordNode;
   },
   set_attrib__ ()
   {
      const attribNodes = this .getAttrib ();

      for (const attribNode of attribNodes)
      {
         attribNode .removeInterest ("requestRebuild", this);
         attribNode ._attribute_changed .removeInterest ("updateVertexArrays", this);
      }

      attribNodes .length = 0;

      for (const node of this ._attrib)
      {
         const attribNode = (0,_Base_X3DCast_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A) (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .X3DVertexAttributeNode, node);

         if (attribNode)
            attribNodes .push (attribNode);
      }

      for (const attribNode of attribNodes)
      {
         attribNode .addInterest ("requestRebuild", this);
         attribNode ._attribute_changed .addInterest ("updateVertexArrays", this);
      }

      this .updateVertexArrays ();
   },
   set_fogCoord__ ()
   {
      this .fogCoordNode ?.removeInterest ("requestRebuild", this);

      this .fogCoordNode = (0,_Base_X3DCast_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A) (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .FogCoordinate, this ._fogCoord);

      this .fogCoordNode ?.addInterest ("requestRebuild", this);
   },
   set_color__ ()
   {
      this .colorNode ?.removeInterest ("requestRebuild", this);

      this .colorNode = (0,_Base_X3DCast_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A) (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .X3DColorNode, this ._color);

      this .colorNode ?.addInterest ("requestRebuild", this);

      this .setTransparent (this .colorNode ?.isTransparent ());
   },
   set_texCoord__ ()
   {
      this .texCoordNode ?.removeInterest ("requestRebuild", this);

      this .texCoordNode = (0,_Base_X3DCast_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A) (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .X3DTextureCoordinateNode, this ._texCoord);

      this .texCoordNode ?.addInterest ("requestRebuild", this);

      this .setTextureCoordinate (this .texCoordNode);
   },
   set_tangent__ ()
   {
      this .tangentNode ?.removeInterest ("requestRebuild", this);

      this .tangentNode = (0,_Base_X3DCast_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A) (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .X3DTangentNode, this ._tangent);

      this .tangentNode ?.addInterest ("requestRebuild", this);
   },
   set_normal__ ()
   {
      this .normalNode ?.removeInterest ("requestRebuild", this);

      this .normalNode = (0,_Base_X3DCast_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A) (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .X3DNormalNode, this ._normal);

      this .normalNode ?.addInterest ("requestRebuild", this);
   },
   set_coord__ ()
   {
      this .coordNode ?.removeInterest ("requestRebuild", this);

      this .coordNode = (0,_Base_X3DCast_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A) (_Base_X3DConstants_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .X3DCoordinateNode, this ._coord);

      this .coordNode ?.addInterest ("requestRebuild", this);
   },
});

Object .defineProperties (X3DGeometryNode, _Core_X3DNode_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .getStaticProperties ("X3DGeometryNode", "Rendering", 1));

const __default__ = X3DGeometryNode;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_13__/* ["default"] */ .A .add ("X3DGeometryNode", __default__));

/***/ }),

/***/ 5432:
/***/ ((module, exports, __webpack_require__) => {

var __WEBPACK_AMD_DEFINE_FACTORY__, __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;/*!
 * jQuery Mousewheel 3.2.2
 * Copyright OpenJS Foundation and other contributors
 */

( function( factory ) {
    "use strict";

    if ( true ) {

        // AMD. Register as an anonymous module.
        !(__WEBPACK_AMD_DEFINE_ARRAY__ = [ __webpack_require__(9547) ], __WEBPACK_AMD_DEFINE_FACTORY__ = (factory),
		__WEBPACK_AMD_DEFINE_RESULT__ = (typeof __WEBPACK_AMD_DEFINE_FACTORY__ === 'function' ?
		(__WEBPACK_AMD_DEFINE_FACTORY__.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__)) : __WEBPACK_AMD_DEFINE_FACTORY__),
		__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
    } else // removed by dead control flow
{}
} )( function( $ ) {
    "use strict";

    var nullLowestDeltaTimeout, lowestDelta,
        modernEvents = !!$.fn.on,
        toFix  = [ "wheel", "mousewheel", "DOMMouseScroll", "MozMousePixelScroll" ],
        toBind = ( "onwheel" in window.document || window.document.documentMode >= 9 ) ?
            [ "wheel" ] : [ "mousewheel", "DomMouseScroll", "MozMousePixelScroll" ],
        slice  = Array.prototype.slice;

    if ( $.event.fixHooks ) {
        for ( var i = toFix.length; i; ) {
            $.event.fixHooks[ toFix[ --i ] ] = $.event.mouseHooks;
        }
    }

    var special = $.event.special.mousewheel = {
        version: "3.2.2",

        setup: function() {
            if ( this.addEventListener ) {
                for ( var i = toBind.length; i; ) {
                    this.addEventListener( toBind[ --i ], handler, false );
                }
            } else {
                this.onmousewheel = handler;
            }

            // Store the line height and page height for this particular element
            $.data( this, "mousewheel-line-height", special.getLineHeight( this ) );
            $.data( this, "mousewheel-page-height", special.getPageHeight( this ) );
        },

        teardown: function() {
            if ( this.removeEventListener ) {
                for ( var i = toBind.length; i; ) {
                    this.removeEventListener( toBind[ --i ], handler, false );
                }
            } else {
                this.onmousewheel = null;
            }

            // Clean up the data we added to the element
            $.removeData( this, "mousewheel-line-height" );
            $.removeData( this, "mousewheel-page-height" );
        },

        getLineHeight: function( elem ) {
            var $elem = $( elem ),
                $parent = $elem[ "offsetParent" in $.fn ? "offsetParent" : "parent" ]();
            if ( !$parent.length ) {
                $parent = $( "body" );
            }
            return parseInt( $parent.css( "fontSize" ), 10 ) ||
                parseInt( $elem.css( "fontSize" ), 10 ) || 16;
        },

        getPageHeight: function( elem ) {
            return $( elem ).height();
        },

        settings: {
            adjustOldDeltas: true, // see shouldAdjustOldDeltas() below
            normalizeOffset: true  // calls getBoundingClientRect for each event
        }
    };

    $.fn.extend( {
        mousewheel: function( fn ) {
            return fn ?
                this[ modernEvents ? "on" : "bind" ]( "mousewheel", fn ) :
                this.trigger( "mousewheel" );
        },

        unmousewheel: function( fn ) {
            return this[ modernEvents ? "off" : "unbind" ]( "mousewheel", fn );
        }
    } );


    function handler( event ) {
        var orgEvent   = event || window.event,
            args       = slice.call( arguments, 1 ),
            delta      = 0,
            deltaX     = 0,
            deltaY     = 0,
            absDelta   = 0;
        event = $.event.fix( orgEvent );
        event.type = "mousewheel";

        // Old school scrollwheel delta
        if ( "detail" in orgEvent ) {
            deltaY = orgEvent.detail * -1;
        }
        if ( "wheelDelta" in orgEvent ) {
            deltaY = orgEvent.wheelDelta;
        }
        if ( "wheelDeltaY" in orgEvent ) {
            deltaY = orgEvent.wheelDeltaY;
        }
        if ( "wheelDeltaX" in orgEvent ) {
            deltaX = orgEvent.wheelDeltaX * -1;
        }

        // Firefox < 17 horizontal scrolling related to DOMMouseScroll event
        if ( "axis" in orgEvent && orgEvent.axis === orgEvent.HORIZONTAL_AXIS ) {
            deltaX = deltaY * -1;
            deltaY = 0;
        }

        // Set delta to be deltaY or deltaX if deltaY is 0 for backwards compatability
        delta = deltaY === 0 ? deltaX : deltaY;

        // New school wheel delta (wheel event)
        if ( "deltaY" in orgEvent ) {
            deltaY = orgEvent.deltaY * -1;
            delta  = deltaY;
        }
        if ( "deltaX" in orgEvent ) {
            deltaX = orgEvent.deltaX;
            if ( deltaY === 0 ) {
                delta  = deltaX * -1;
            }
        }

        // No change actually happened, no reason to go any further
        if ( deltaY === 0 && deltaX === 0 ) {
            return;
        }

        // Need to convert lines and pages to pixels if we aren't already in pixels
        // There are three delta modes:
        //   * deltaMode 0 is by pixels, nothing to do
        //   * deltaMode 1 is by lines
        //   * deltaMode 2 is by pages
        if ( orgEvent.deltaMode === 1 ) {
            var lineHeight = $.data( this, "mousewheel-line-height" );
            delta  *= lineHeight;
            deltaY *= lineHeight;
            deltaX *= lineHeight;
        } else if ( orgEvent.deltaMode === 2 ) {
            var pageHeight = $.data( this, "mousewheel-page-height" );
            delta  *= pageHeight;
            deltaY *= pageHeight;
            deltaX *= pageHeight;
        }

        // Store lowest absolute delta to normalize the delta values
        absDelta = Math.max( Math.abs( deltaY ), Math.abs( deltaX ) );

        if ( !lowestDelta || absDelta < lowestDelta ) {
            lowestDelta = absDelta;

            // Adjust older deltas if necessary
            if ( shouldAdjustOldDeltas( orgEvent, absDelta ) ) {
                lowestDelta /= 40;
            }
        }

        // Adjust older deltas if necessary
        if ( shouldAdjustOldDeltas( orgEvent, absDelta ) ) {

            // Divide all the things by 40!
            delta  /= 40;
            deltaX /= 40;
            deltaY /= 40;
        }

        // Get a whole, normalized value for the deltas
        delta  = Math[ delta  >= 1 ? "floor" : "ceil" ]( delta  / lowestDelta );
        deltaX = Math[ deltaX >= 1 ? "floor" : "ceil" ]( deltaX / lowestDelta );
        deltaY = Math[ deltaY >= 1 ? "floor" : "ceil" ]( deltaY / lowestDelta );

        // Normalise offsetX and offsetY properties
        if ( special.settings.normalizeOffset && this.getBoundingClientRect ) {
            var boundingRect = this.getBoundingClientRect();
            event.offsetX = event.clientX - boundingRect.left;
            event.offsetY = event.clientY - boundingRect.top;
        }

        // Add information to the event object
        event.deltaX = deltaX;
        event.deltaY = deltaY;
        event.deltaFactor = lowestDelta;

        // Go ahead and set deltaMode to 0 since we converted to pixels
        // Although this is a little odd since we overwrite the deltaX/Y
        // properties with normalized deltas.
        event.deltaMode = 0;

        // Add event and delta to the front of the arguments
        args.unshift( event, delta, deltaX, deltaY );

        // Clear out lowestDelta after sometime to better
        // handle multiple device types that give different
        // a different lowestDelta
        // Ex: trackpad = 3 and mouse wheel = 120
        if ( nullLowestDeltaTimeout ) {
            window.clearTimeout( nullLowestDeltaTimeout );
        }
        nullLowestDeltaTimeout = window.setTimeout( function() {
            lowestDelta = null;
        }, 200 );

        return ( $.event.dispatch || $.event.handle ).apply( this, args );
    }

    function shouldAdjustOldDeltas( orgEvent, absDelta ) {

        // If this is an older event and the delta is divisible by 120,
        // then we are assuming that the browser is treating this as an
        // older mouse wheel event and that we should divide the deltas
        // by 40 to try and get a more usable deltaFactor.
        // Side note, this actually impacts the reported scroll distance
        // in older browsers and can cause scrolling to be slower than native.
        // Turn this off by setting $.event.special.mousewheel.settings.adjustOldDeltas to false.
        return special.settings.adjustOldDeltas && orgEvent.type === "mousewheel" &&
            absDelta % 120 === 0;
    }

} );


/***/ }),

/***/ 5524:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Base_X3DInfoArray_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(3020);
/* harmony import */ var _X3DProtoDeclaration_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(4246);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(717);



function ProtoDeclarationArray (values = [ ])
{
   return _Base_X3DInfoArray_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .call (this, Array .from (values, value => [value .name, value]), _X3DProtoDeclaration_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A);
}

Object .setPrototypeOf (ProtoDeclarationArray .prototype, _Base_X3DInfoArray_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .prototype);

for (const key of Object .keys (ProtoDeclarationArray .prototype))
   Object .defineProperty (ProtoDeclarationArray .prototype, key, { enumerable: false });

Object .defineProperties (ProtoDeclarationArray,
{
   typeName:
   {
      value: "ProtoDeclarationArray",
      enumerable: true,
   },
});

const __default__ = ProtoDeclarationArray;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .add ("ProtoDeclarationArray", __default__));

/***/ }),

/***/ 5625:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(717);
const Events = Object .assign ([ ],
{
   create (field)
   {
      const event = this .pop () ?? new Set ();

      event .field = field;
      event .clear ();

      return event;
   },
   copy (event)
   {
      const copy = this .create (event .field);

      for (const source of event)
         copy .add (source);

      return copy;
   },
   from (field)
   {
      const event = this .create (field);

      event .add (field);

      return event;
   },
});

for (const key of Object .keys (Events))
   Object .defineProperty (Events, key, { enumerable: false });

const __default__ = Events;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .add ("Events", __default__));

/***/ }),

/***/ 5708:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Base_X3DInfoArray_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(3020);
/* harmony import */ var _Fields_SFNode_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(1061);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(717);



function NamedNodesArray (values = [ ])
{
   return _Base_X3DInfoArray_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .call (this, Array .from (values, value => [value .getNodeName (), value]), _Fields_SFNode_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A);
}

Object .setPrototypeOf (NamedNodesArray .prototype, _Base_X3DInfoArray_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .prototype);

for (const key of Object .keys (NamedNodesArray .prototype))
   Object .defineProperty (NamedNodesArray .prototype, key, { enumerable: false });

Object .defineProperties (NamedNodesArray,
{
   typeName:
   {
      value: "NamedNodesArray",
      enumerable: true,
   },
});

const __default__ = NamedNodesArray;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A .add ("NamedNodesArray", __default__));

/***/ }),

/***/ 5859:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(7572);
/* harmony import */ var _x_ite_Namespace_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(717);
/* provided dependency */ var libtess = __webpack_require__(1619);


const Triangle3 =
{
   /**
    *
    * @param {Vector3} a first point of triangle
    * @param {Vector3} b second point of triangle
    * @param {Vector3} c third point of triangle
    * @returns
    */
   area: (() =>
   {
      const
         B = new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A (),
         C = new _Numbers_Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A ();

      return function (a, b, c)
      {
         return B .assign (b) .subtract (a) .cross (C .assign (c) .subtract (a)) .norm () / 2;
      };
   })(),
   /**
    *
    * @param {Vector3} a first point of triangle
    * @param {Vector3} b second point of triangle
    * @param {Vector3} c third point of triangle
    * @param {Vector3} normal resulting normal
    * @returns
    */
   normal (a, b, c, normal)
   {
      const
         x1 = c .x - b .x,
         y1 = c .y - b .y,
         z1 = c .z - b .z,
         x2 = a .x - b .x,
         y2 = a .y - b .y,
         z2 = a .z - b .z;

      normal .set (y1 * z2 - z1 * y2,
                   z1 * x2 - x1 * z2,
                   x1 * y2 - y1 * x2);

      return normal .normalize ();
   },
   /**
    *
    * @param {Vector3} a first point of quad
    * @param {Vector3} b second point of quad
    * @param {Vector3} c third point of quad
    * @param {Vector3} d third point of quad
    * @param {Vector3} normal resulting normal
    * @returns
    */
   quadNormal (a, b, c, d, normal)
   {
      const
         x1 = c .x - a .x,
         y1 = c .y - a .y,
         z1 = c .z - a .z,
         x2 = d .x - b .x,
         y2 = d .y - b .y,
         z2 = d .z - b .z;

      normal .set (y1 * z2 - z1 * y2,
                   z1 * x2 - x1 * z2,
                   x1 * y2 - y1 * x2);

      return normal .normalize ();
   },
   triangulatePolygon: (() =>
   {
      // Function called for each vertex of tesselator output.

      function vertexCallback (index, triangles)
      {
         triangles .push (index);
      }

      // Required in case of a combine, otherwise an empty array is returned.

      function combineCallback (coords, data, weight)
      {
         return data [0];
      }

      const tessy = new libtess .GluTesselator ();

      tessy .gluTessCallback (libtess .gluEnum .GLU_TESS_VERTEX_DATA,  vertexCallback);
      tessy .gluTessCallback (libtess .gluEnum .GLU_TESS_COMBINE,      combineCallback);
      tessy .gluTessProperty (libtess .gluEnum .GLU_TESS_WINDING_RULE, libtess .windingRule .GLU_TESS_WINDING_ODD);

      return function (polygon, triangles)
      {
         tessy .gluTessBeginPolygon (triangles);
         tessy .gluTessBeginContour ();

         for (const point of polygon)
            tessy .gluTessVertex (point, point .index);

         tessy .gluTessEndContour ();
         tessy .gluTessEndPolygon ();

         // Return array of indices.
         return triangles;
      };
   })(),
   triangulateConvexPolygon (vertices, triangles)
   {
      // Fallback: Very simple triangulation for convex polygons.

      const numVertices_1 = vertices .length - 1;

      for (let i = 1; i < numVertices_1; ++ i)
         triangles .push (vertices [0], vertices [i], vertices [i + 1]);

      return triangles;
   },
};

const __default__ = Triangle3;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_x_ite_Namespace_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .add ("Triangle3", __default__));

/***/ }),

/***/ 6015:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _SFNode_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(1061);
/* harmony import */ var _Namespace_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(717);


const cache = new WeakMap ();

// const r = new FinalizationRegistry (t => console .error (`object deleted ${--i} ${t}`));
// let i = 0;

const SFNodeCache =
{
   get (baseNode)
   {
      const node = cache .get (baseNode);

      if (node)
      {
         return node;
      }
      else
      {
         const node = new _SFNode_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A (baseNode);

         this .set (baseNode, node);

         // i += 2;
         // console .warn (`baseNode ${i} ${baseNode .getTypeName ()}`);
         // r .register (baseNode, `baseNode ${baseNode .getTypeName ()}`);
         // r .register (node, `node ${baseNode .getTypeName ()}`);

         return node;
      }
   },
   set (baseNode, node)
   {
      Object .defineProperty (node, "dispose",
      {
         value: dispose,
         writable: true,
         configurable: true,
      });

      // WeakMap allows associating data to objects in a way that doesn't prevent
      // the key objects from being collected, even if the values reference the keys.
      // https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/WeakMap
      cache .set (baseNode, node);
   },
   delete (baseNode)
   {
      cache .delete (baseNode);
   },
};

function dispose ()
{
   this .getValue () ?.dispose ();

   _SFNode_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .prototype .dispose .call (this);
}

const __default__ = SFNodeCache;
;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Namespace_js__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A .add ("SFNodeCache", __default__));

/***/ }),

/***/ 6179:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Vector3_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(7572);
/* harmony import */ var _Vector4_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(8913);
/* harmony import */ var _Quaternion_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(1770);
/* harmony import */ var _Rotation4_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(7078);
/* harmony import */ var _Matrix3_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(8713);
/* harmony import */ var _Algorithms_eigen_decomposition_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(1428);
/* harmony import */ var _x_ite_Namespace_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(717);







function Matrix4 (... args)
{
   if (args .length)
   {
      for (let i = 0; i < 16; ++ i)
         this [i] = args [i];
   }
   else
   {
      this .identity ();
   }
}

Object .assign (Matrix4 .prototype,
{
   *[Symbol .iterator] ()
   {
      for (let i = 0; i < 16; ++ i)
         yield this [i];
   },
   copy ()
   {
      const copy = Object .create (Matrix4 .prototype);

      for (let i = 0; i < 16; ++ i)
         copy [i] = this [i];

      return copy;
   },
   assign (matrix)
   {
      for (let i = 0; i < 16; ++ i)
         this [i] = matrix [i];

      return this;
   },
   equals (matrix)
   {
      return this [ 0] === matrix [ 0] &&
             this [ 1] === matrix [ 1] &&
             this [ 2] === matrix [ 2] &&
             this [ 3] === matrix [ 3] &&
             this [ 4] === matrix [ 4] &&
             this [ 5] === matrix [ 5] &&
             this [ 6] === matrix [ 6] &&
             this [ 7] === matrix [ 7] &&
             this [ 8] === matrix [ 8] &&
             this [ 9] === matrix [ 9] &&
             this [10] === matrix [10] &&
             this [11] === matrix [11] &&
             this [12] === matrix [12] &&
             this [13] === matrix [13] &&
             this [14] === matrix [14] &&
             this [15] === matrix [15];
   },
   set1 (r, c, value)
   {
      this [r * this .order + c] = value;

      return this;
   },
   get1 (r, c)
   {
      return this [r * this .order + c];
   },
   set: (() =>
   {
      const
         invScaleOrientation = new _Rotation4_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A (),
         invCenter           = new _Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A ();

      return function (translation, rotation, scale, scaleOrientation, center)
      {
         this .identity ();

         switch (arguments .length)
         {
            case 1:
            {
               if (translation && !translation .equals (_Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .ZERO))
                  this .translate (translation);

               break;
            }
            case 2:
            {
               if (translation && !translation .equals (_Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .ZERO))
                  this .translate (translation);

               if (rotation && !rotation .equals (_Rotation4_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .IDENTITY))
                  this .rotate (rotation);

               break;
            }
            case 3:
            {
               if (translation && !translation .equals (_Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .ZERO))
                  this .translate (translation);

               if (rotation && !rotation .equals (_Rotation4_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .IDENTITY))
                  this .rotate (rotation);

               if (scale && !scale .equals (_Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .ONE))
                  this .scale (scale);

               break;
            }
            case 4:
            {
               if (translation && !translation .equals (_Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .ZERO))
                  this .translate (translation);

               if (rotation && !rotation .equals (_Rotation4_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .IDENTITY))
                  this .rotate (rotation);

               if (scale && !scale .equals (_Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .ONE))
               {
                  if (scaleOrientation && !scaleOrientation .equals (_Rotation4_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .IDENTITY))
                  {
                     this .rotate (scaleOrientation);
                     this .scale (scale);
                     this .rotate (invScaleOrientation .assign (scaleOrientation) .inverse ());
                  }
                  else
                  {
                     this .scale (scale);
                  }
               }

               break;
            }
            case 5:
            {
               // P' = T * C * R * SR * S * -SR * -C * P
               if (translation && !translation .equals (_Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .ZERO))
                  this .translate (translation);

               const hasCenter = center && !center .equals (_Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .ZERO);

               if (hasCenter)
                  this .translate (center);

               if (rotation && !rotation .equals (_Rotation4_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .IDENTITY))
                  this .rotate (rotation);

               if (scale && !scale .equals (_Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A .ONE))
               {
                  if (scaleOrientation && !scaleOrientation .equals (_Rotation4_js__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A .IDENTITY))
                  {
                     this .rotate (scaleOrientation);
                     this .scale (scale);
                     this .rotate (invScaleOrientation .assign (scaleOrientation) .inverse ());
                  }
                  else
                  {
                     this .scale (scale);
                  }
               }

               if (hasCenter)
                  this .translate (invCenter .assign (center) .negate ());

               break;
            }
            case 16:
            {
               for (let i = 0; i < 16; ++ i)
                  this [i] = arguments [i];

               break;
            }
         }

         return this;
      };
   })(),
   get: (() =>
   {
      const c = new _Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A ();

      return function (translation, rotation, scale, scaleOrientation, center)
      {
         switch (arguments .length)
         {
            case 1:
            {
               translation .set (this [12], this [13], this [14]);
               break;
            }
            case 2:
            case 3:
            case 4:
            {
               this .factor (translation, rotation, scale, scaleOrientation);
               break;
            }
            case 5:
            {
               if (center)
               {
                  m .set (c .assign (center) .negate ());
                  m .multLeft (this);
                  m .translate (center);
                  m .get (translation, rotation, scale, scaleOrientation);
               }
               else
               {
                  this .factor (translation, rotation, scale, scaleOrientation);
               }

               break;
            }
         }
      };
   })(),
   setRotation (rotation)
   {
      return this .setQuaternion (rotation .getQuaternion (q));
   },
   setQuaternion (quaternion)
   {
      const
         { x, y, z, w } = quaternion,
         A = y * y,
         B = z * z,
         C = x * y,
         D = z * w,
         E = z * x,
         F = y * w,
         G = x * x,
         H = y * z,
         I = x * w;

      this [0]  = 1 - 2 * (A + B);
      this [1]  = 2 * (C + D);
      this [2]  = 2 * (E - F);
      this [3]  = 0;
      this [4]  = 2 * (C - D);
      this [5]  = 1 - 2 * (B + G);
      this [6]  = 2 * (H + I);
      this [7]  = 0;
      this [8]  = 2 * (E + F);
      this [9]  = 2 * (H - I);
      this [10] = 1 - 2 * (A + G);
      this [11] = 0;
      this [12] = 0;
      this [13] = 0;
      this [14] = 0;
      this [15] = 1;

      return this;
   },
   factor: (() =>
   {
      const
         s  = new _Vector3_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A (),
         si = new _Matrix3_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A (),
         so = new _Matrix3_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A (),
         b  = new _Matrix3_js__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A ();

      const eigen = { values: [ ], vectors: [[ ], [ ], [ ]] };

      return function (translation, rotation, scale, scaleOrientation)
      {
         // (1) Get translation.
         translation ?.set (this [12], this [13], this [14]);

         // (2) Create 3x3 matrix.
         const a = this .submatrix;

         // (3) Compute det A. If negative, set sign = -1, else sign = 1
         const det      = a .determinant ();
         const det_sign = det < 0 ? -1 : 1;

         // (4) B = A * !A  (here !A means A transpose)
         b .assign (a) .transpose () .multLeft (a);
         const e = (0,_Algorithms_eigen_decomposition_js__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A) (b, eigen);

         // Find min / max eigenvalues and do ratio test to determine singularity.

         so .set (e .vectors [0] [0], e .vectors [1] [0], e .vectors [2] [0],
                  e .vectors [0] [1], e .vectors [1] [1], e .vectors [2] [1],
                  e .vectors [0] [2], e .vectors [1] [2], e .vectors [2] [2]);

         scaleOrientation ?.setMatrix (so);

         // Compute s = sqrt(eigen values), with sign. Set si = s-inverse

         s .set (det_sign * Math .sqrt (e .values [0]),
                 det_sign * Math .sqrt (e .values [1]),
                 det_sign * Math .sqrt (e .values [2]));

         scale ?.assign (s);

         if (rotation)
         {
            si [0] = 1 / s .x;
            si [4] = 1 / s .y;
            si [8] = 1 / s .z;

            // (5) Compute U = !R ~S R A.
            rotation .setMatrix (a .multLeft (so) .multLeft (si) .multLeft (so .transpose ()));
         }
      };
   })(),
   determinant3 ()
   {
      const { 0: m00, 1: m01, 2: m02,
              4: m04, 5: m05, 6: m06,
              8: m08, 9: m09, 10: m10 } = this;

      return m00 * (m05 * m10 - m06 * m09) -
             m01 * (m04 * m10 - m06 * m08) +
             m02 * (m04 * m09 - m05 * m08);
   },
   determinant ()
   {
      const
         { 0: m00, 1: m01, 2: m02, 3: m03, 4: m04, 5: m05, 6: m06, 7: m07,
           8: m08, 9: m09, 10: m10, 11: m11, 12: m12, 13: m13, 14: m14, 15: m15 } = this,
         b = m10 * m15,
         c = m14 * m11,
         d = m06 * m15,
         e = m14 * m07,
         f = m06 * m11,
         g = m10 * m07,
         h = m02 * m15,
         i = m14 * m03,
         j = m02 * m11,
         o = m10 * m03,
         r = m02 * m07,
         x = m06 * m03,
         H = b * m05 + e * m09 + f * m13 - (c * m05) - (d * m09) - (g * m13),
         I = c * m01 + h * m09 + o * m13 - (b * m01) - (i * m09) - (j * m13),
         J = d * m01 + i * m05 + r * m13 - (e * m01) - (h * m05) - (x * m13),
         K = g * m01 + j * m05 + x * m09 - (f * m01) - (o * m05) - (r * m09);

      return m00 * H + m04 * I + m08 * J + m12 * K;
   },
   transpose ()
   {
      let tmp;

      tmp = this [ 1]; this [ 1] = this [ 4]; this [ 4] = tmp;
      tmp = this [ 2]; this [ 2] = this [ 8]; this [ 8] = tmp;
      tmp = this [ 3]; this [ 3] = this [12]; this [12] = tmp;
      tmp = this [ 6]; this [ 6] = this [ 9]; this [ 9] = tmp;
      tmp = this [ 7]; this [ 7] = this [13]; this [13] = tmp;
      tmp = this [11]; this [11] = this [14]; this [14] = tmp;

      return this;
   },
   inverse ()
   {
      // Complexity 43 +, 40 -, 140 *. 1 /

      const
         { 0: m00, 1: m01, 2: m02, 3: m03, 4: m04, 5: m05, 6: m06, 7: m07,
           8: m08, 9: m09, 10: m10, 11: m11, 12: m12, 13: m13, 14: m14, 15: m15 } = this,
         b = m10 * m15,
         c = m14 * m11,
         d = m06 * m15,
         e = m14 * m07,
         f = m06 * m11,
         g = m10 * m07,
         h = m02 * m15,
         i = m14 * m03,
         j = m02 * m11,
         o = m10 * m03,
         r = m02 * m07,
         x = m06 * m03,
         t = m08 * m13,
         p = m12 * m09,
         v = m04 * m13,
         s = m12 * m05,
         y = m04 * m09,
         z = m08 * m05,
         A = m00 * m13,
         C = m12 * m01,
         D = m00 * m09,
         E = m08 * m01,
         F = m00 * m05,
         G = m04 * m01,
         H = b * m05 + e * m09 + f * m13 - ((c * m05) + (d * m09) + (g * m13)),
         I = c * m01 + h * m09 + o * m13 - ((b * m01) + (i * m09) + (j * m13)),
         J = d * m01 + i * m05 + r * m13 - ((e * m01) + (h * m05) + (x * m13)),
         K = g * m01 + j * m05 + x * m09 - ((f * m01) + (o * m05) + (r * m09));

      let B = m00 * H + m04 * I + m08 * J + m12 * K;

      // if (B === 0) ... determinant is zero.

      B = 1 / B;

      this [ 0] = B * H;
      this [ 1] = B * I;
      this [ 2] = B * J;
      this [ 3] = B * K;
      this [ 4] = B * (c * m04 + d * m08 + g * m12 - (b * m04) - (e * m08) - (f * m12));
      this [ 5] = B * (b * m00 + i * m08 + j * m12 - (c * m00) - (h * m08) - (o * m12));
      this [ 6] = B * (e * m00 + h * m04 + x * m12 - (d * m00) - (i * m04) - (r * m12));
      this [ 7] = B * (f * m00 + o * m04 + r * m08 - (g * m00) - (j * m04) - (x * m08));
      this [ 8] = B * (t * m07 + s * m11 + y * m15 - (p * m07) - (v * m11) - (z * m15));
      this [ 9] = B * (p * m03 + A * m11 + E * m15 - (t * m03) - (C * m11) - (D * m15));
      this [10] = B * (v * m03 + C * m07 + F * m15 - (s * m03) - (A * m07) - (G * m15));
      this [11] = B * (z * m03 + D * m07 + G * m11 - (y * m03) - (E * m07) - (F * m11));
      this [12] = B * (v * m10 + z * m14 + p * m06 - (y * m14) - (t * m06) - (s * m10));
      this [13] = B * (D * m14 + t * m02 + C * m10 - (A * m10) - (E * m14) - (p * m02));
      this [14] = B * (A * m06 + G * m14 + s * m02 - (F * m14) - (v * m02) - (C * m06));
      this [15] = B * (F * m10 + y * m02 + E * m06 - (D * m06) - (G * m10) - (z * m02));

      return this;
   },
   multLeft (matrix)
   {
      // Complexity 48 +, 64 *.

      const
         { 0: a00, 1: a01, 2: a02, 3: a03, 4: a04, 5: a05, 6: a06, 7: a07,
           8: a08, 9: a09, 10: a10, 11: a11, 12: a12, 13: a13, 14: a14, 15: a15 } = this,
         { 0: b00, 1: b01, 2: b02, 3: b03, 4: b04, 5: b05, 6: b06, 7: b07,
           8: b08, 9: b09, 10: b10, 11: b11, 12: b12, 13: b13, 14: b14, 15: b15 } = matrix;

      this [ 0] = a00 * b00 + a04 * b01 + a08 * b02 + a12 * b03;
      this [ 1] = a01 * b00 + a05 * b01 + a09 * b02 + a13 * b03;
      this [ 2] = a02 * b00 + a06 * b01 + a10 * b02 + a14 * b03;
      this [ 3] = a03 * b00 + a07 * b01 + a11 * b02 + a15 * b03;
      this [ 4] = a00 * b04 + a04 * b05 + a08 * b06 + a12 * b07;
      this [ 5] = a01 * b04 + a05 * b05 + a09 * b06 + a13 * b07;
      this [ 6] = a02 * b04 + a06 * b05 + a10 * b06 + a14 * b07;
      this [ 7] = a03 * b04 + a07 * b05 + a11 * b06 + a15 * b07;
      this [ 8] = a00 * b08 + a04 * b09 + a08 * b10 + a12 * b11;
      this [ 9] = a01 * b08 + a05 * b09 + a09 * b10 + a13 * b11;
      this [10] = a02 * b08 + a06 * b09 + a10 * b10 + a14 * b11;
      this [11] = a03 * b08 + a07 * b09 + a11 * b10 + a15 * b11;
      this [12] = a00 * b12 + a04 * b13 + a08 * b14 + a12 * b15;
      this [13] = a01 * b12 + a05 * b13 + a09 * b14 + a13 * b15;
      this [14] = a02 * b12 + a06 * b13 + a10 * b14 + a14 * b15;
      this [15] = a03 * b12 + a07 * b13 + a11 * b14 + a15 * b15;

      return this;
   },
   multRight (matrix)
   {
      // Complexity 48 +, 64 *.

      const
         { 0: a00, 1: a01, 2: a02, 3: a03, 4: a04, 5: a05, 6: a06, 7: a07,
           8: a08, 9: a09, 10: a10, 11: a11, 12: a12, 13: a13, 14: a14, 15: a15 } = this,
         { 0: b00, 1: b01, 2: b02, 3: b03, 4: b04, 5: b05, 6: b06, 7: b07,
           8: b08, 9: b09, 10: b10, 11: b11, 12: b12, 13: b13, 14: b14, 15: b15 } = matrix;

      this [ 0] = a00 * b00 + a01 * b04 + a02 * b08 + a03 * b12;
      this [ 1] = a00 * b01 + a01 * b05 + a02 * b09 + a03 * b13;
      this [ 2] = a00 * b02 + a01 * b06 + a02 * b10 + a03 * b14;
      this [ 3] = a00 * b03 + a01 * b07 + a02 * b11 + a03 * b15;
      this [ 4] = a04 * b00 + a05 * b04 + a06 * b08 + a07 * b12;
      this [ 5] = a04 * b01 + a05 * b05 + a06 * b09 + a07 * b13;
      this [ 6] = a04 * b02 + a05 * b06 + a06 * b10 + a07 * b14;
      this [ 7] = a04 * b03 + a05 * b07 + a06 * b11 + a07 * b15;
      this [ 8] = a08 * b00 + a09 * b04 + a10 * b08 + a11 * b12;
      this [ 9] = a08 * b01 + a09 * b05 + a10 * b09 + a11 * b13;
      this [10] = a08 * b02 + a09 * b06 + a10 * b10 + a11 * b14;
      this [11] = a08 * b03 + a09 * b07 + a10 * b11 + a11 * b15;
      this [12] = a12 * b00 + a13 * b04 + a14 * b08 + a15 * b12;
      this [13] = a12 * b01 + a13 * b05 + a14 * b09 + a15 * b13;
      this [14] = a12 * b02 + a13 * b06 + a14 * b10 + a15 * b14;
      this [15] = a12 * b03 + a13 * b07 + a14 * b11 + a15 * b15;

      return this;
   },
   multVecMatrix (vector)
   {
      if (vector .length === 3)
      {
         const
            { x, y, z } = vector,
            w = 1 / (x * this [3] + y * this [7] + z * this [11] + this [15]);

         vector .x = (x * this [0] + y * this [4] + z * this [ 8] + this [12]) * w;
         vector .y = (x * this [1] + y * this [5] + z * this [ 9] + this [13]) * w;
         vector .z = (x * this [2] + y * this [6] + z * this [10] + this [14]) * w;

         return vector;
      }
      else
      {
         const { x