<!DOCTYPE html>
<html lang="zh">
<head>
    <meta charset="UTF-8">
    <title>AI Assistant</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/highlight.js/11.7.0/styles/github-dark.min.css">
    <script src="https://cdn.jsdelivr.net/npm/marked/marked.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/highlight.js/11.7.0/highlight.min.js"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <style>
        body { font-family: sans-serif; background: #f4f7f6; display: flex; flex-direction: column; height: 100vh; margin: 0; }
        #chat-container { flex: 1; overflow-y: auto; padding: 20px; }
        .message { margin-bottom: 20px; max-width: 80%; padding: 10px 15px; border-radius: 10px; line-height: 1.6; }
        .user { align-self: flex-end; background: #007bff; color: white; margin-left: auto; }
        .ai { align-self: flex-start; background: white; border: 1px solid #ddd; }
        pre { background: #282c34; padding: 10px; border-radius: 5px; overflow-x: auto; }
        .input-area { background: white; padding: 20px; border-top: 1px solid #ddd; display: flex; }
        input { flex: 1; padding: 12px; border: 1px solid #ddd; border-radius: 4px; outline: none; }
        button { padding: 0 20px; background: #007bff; color: white; border: none; margin-left: 10px; cursor: pointer; border-radius: 4px; }
        button:disabled { background: #ccc; }
    </style>
</head>
<body>
<div id="chat-container"></div>
<div class="input-area">
    <input type="text" id="userInput" placeholder="输入问题，按回车发送..." autocomplete="off">
    <button id="sendBtn">发送</button>
</div>

<script>
    function appendMessage(role, text) {
        const htmlContent = role === 'ai' ? marked.parse(text) : text;
        const msgDiv = $('<div class="message ' + role + '"></div>').html(htmlContent);
        $('#chat-container').append(msgDiv);
        $('#chat-container').scrollTop($('#chat-container')[0].scrollHeight);
        // 触发代码高亮
        msgDiv.find('pre code').each(function(i, block) { hljs.highlightElement(block); });
    }

    function send() {
        const msg = $('#userInput').val().trim();
        if (!msg) return;

        $('#userInput').val('').prop('disabled', true);
        $('#sendBtn').prop('disabled', true);
        appendMessage('user', msg);

        $.post('/chat/send', { message: msg }, function(res) {
            if (res.success) {
                appendMessage('ai', res.data);
            } else {
                appendMessage('ai', "错误: " + res.message);
            }
            $('#userInput').prop('disabled', false).focus();
            $('#sendBtn').prop('disabled', false);
        });
    }

    $('#sendBtn').click(send);
    $('#userInput').keypress(function(e) { if(e.which == 13) send(); });
</script>
</body>
</html>
