# 🤖 AI Assistant 快速上手指南

本程序基于 **Spring Boot + FreeMarker** 构建，集成了阿里云 **通义千问 (DashScope)** 大模型，支持对话上下文记忆、Markdown 渲染及代码高亮展示。

## 🛠️ 环境准备

* **Java 版本**: JDK 21
* **构建工具**: Maven 3.9.11
* **开发框架**: Spring Boot 4.0.2
* **AI 接口协议**: OpenAI SDK 兼容模式

---

## 🚀 操作步骤

### 步骤一：获取 API-KEY

在使用本服务前，你需要获取阿里云百炼大模型的访问权限：

1. **登录控制台**：访问 [阿里云百炼控制台](https://bailian.console.com/)。
2. **开通服务**：首次使用请根据提示开通“模型百炼”服务（新用户通常有免费额度）。
3. **创建 Key**：点击页面左下角的 **[API-KEY]** 菜单，或直接访问 [API-KEY 管理页](https://bailian.console.aliyun.com/cn-beijing/?tab=model#/api-key)。
4. **保存密钥**：点击“创建 API-KEY”，生成的字符串即为调用凭证，请妥善保管。

### 步骤二：项目配置

获取 API-KEY 后，将其配置到项目的配置文件中：

1. 打开 `src/main/resources/application.yml`。
2. 找到以下配置项并替换你的 Key：
```yaml
dashscope:
  api:
    key: YOUR_API_KEY_HERE  # 替换为你刚才创建的 Key
```

### 步骤三：启动服务

1. 找到主启动类 `DemoApplication.java`。
2. 右键点击 **Run** 或使用命令行执行 `mvn spring-boot:run`。
3. 等待控制台输出 `Started DemoApplication in ... seconds`。

---

## 🖥️ 访问与使用

服务启动成功后，通过浏览器访问：

[http://localhost:8080/](http://localhost:8080/)

截图如下：

![screenshot.png](image/screenshot.png)

### 功能特性

* **实时对话**：支持与通义千问模型进行连续问答。
* **上下文记忆**：基于 Session 的会话管理，AI 能记得你之前说的话（默认保留最近 5 轮对话）。
* **专业展示**：
* **Markdown 解析**：支持列表、标题、加粗等排版。
* **代码高亮**：集成 Highlight.js，自动识别并美化编程代码块。


* **性能优化**：采用 AJAX 异步交互，无需刷新页面即可获取回复。

## 📂 核心代码说明

* **`ChatController`**: 处理消息收发、维护会话历史及调用 OpenAI SDK。
* **`AiConfig`**: 负责初始化 `OpenAIClient`，设置阿里兼容模式的 `baseUrl`。
* **`chat.ftl`**: 前端界面，负责用户交互、Markdown 渲染与自动滚动。

## 附录

- 操作步骤在：https://bailian.console.aliyun.com/cn-beijing/?tab=api#/api
- 登录 https://bailian.console.aliyun.com/
- 访问 https://bailian.console.aliyun.com/cn-beijing/?tab=model#/api-key （此菜单在页面左下角），点击 ”创建API-KEY“

