package com.example.demo;

import com.example.demo.reqresp.TradeReq;
import com.example.demo.reqresp.TradeResp;
import com.example.demo.util.SignUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

@RestController
@Slf4j
@RequestMapping("/server/api")
public class ApiController {

    @PostMapping("/trade")
    public TradeResp trade(@RequestBody TradeReq body) {
        log.info("trade begin: {}", body);
        TradeResp tradeResp = new TradeResp();
        try {
            String content = body.getContent();
            String sign = body.getSign();
            String merchantId = body.getMerchantId();
            String publicKeyByMerchantId = getPublicKeyByMerchantId(merchantId);

            boolean ok = SignUtil.verify(content, sign, publicKeyByMerchantId);

            tradeResp.setVerify(ok);
        } catch (Exception e) {
            log.error("Trade error", e);
            tradeResp.setMsg(e.getMessage());
        }
        log.info("trade end: {}", tradeResp);
        return tradeResp;
    }

    private String getPublicKeyByMerchantId(String merchantId) {
        if ("123456".equals(merchantId)) {
            return "MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAtUhgxLLj4qfvHjsS0w6i94d5pePudShmOie1OaLvz/9X9jh6cHuEQ+l9z/K/OievxI6R9XkRPLtLeZu+XHiklVG6Qu+ZH04tNK6rcgBijeI3fKFOhPNB0UHTxyhyAhu4fcFDmgoXnGrXt1isX9Ro/mmj1tykBRUQ2cQwdGJ+3NSv7kyA/QQ2s2vdsZ3Lm/Co2EfO3XKxxgoRBR6B5JQuB4ttXMyzWaRqqDev/ijddMsXbuP7T1bwgbEqBSNesobDIAazAB7W+jiUXW3g3A9t730GKNe0jRFkLqIQURoasqV6X6SvJr/86Dg0I1uVmpTL+DzqRvXC6YRiP9dIOy2OdQIDAQAB";
        }
        throw new IllegalArgumentException("invalid merchantId");
    }
}
