package com.example.demo;

import com.example.demo.util.SignUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.client.RestTemplate;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@RestController
@Slf4j
@RequestMapping("/client/api")
public class ClientApiController {

    private static final String PRIVATE_KEY = "MIIEvwIBADANBgkqhkiG9w0BAQEFAASCBKkwggSlAgEAAoIBAQC1SGDEsuPip+8eOxLTDqL3h3ml4+51KGY6J7U5ou/P/1f2OHpwe4RD6X3P8r86J6/EjpH1eRE8u0t5m75ceKSVUbpC75kfTi00rqtyAGKN4jd8oU6E80HRQdPHKHICG7h9wUOaChecate3WKxf1Gj+aaPW3KQFFRDZxDB0Yn7c1K/uTID9BDaza92xncub8KjYR87dcrHGChEFHoHklC4Hi21czLNZpGqoN6/+KN10yxdu4/tPVvCBsSoFI16yhsMgBrMAHtb6OJRdbeDcD23vfQYo17SNEWQuohBRGhqypXpfpK8mv/zoODQjW5WalMv4POpG9cLphGI/10g7LY51AgMBAAECggEAAzbXUGWDmN81ZCnT+Z4G0bC7PW+/KKCgv2M42V7ENcHnQ1xY/2mRPMsFCgzZyyQs/6UvfVS6M4N2oR9bzrPs5yDd1pX89wshzg9SxuCu3qkmJrWNeNn/TsCGCr/y1Yq8SK6GjlKjfIiAbqXJ2KEhg3FIEGU1G0n2VIYf/dBJQ40SHal214Zbk8pVTbWhb32gQC3o541b+1IqIq0V49VLH6aZ+yZOL5QnzUPj6pb2BsuTpI/HA4gkEuG3qFwSaJGD6OyGOayPBHCCslx6zU2BKq7mAG7RDkjRp6hDmr5Y42vmvxzpVzvHIKX3E9MlOitXKX1HH08aHACQqi0w4vrGOQKBgQD8DqDSVb4FDpeSvPTxEubzdb7T/1nnbnQF5UFriOTv2dVLR8/9LfB5XTkD9sDnYcXaY2EG/pXFngXxtaJkVnI0dJpUxdBiBPaJ7DoMn4whmQbx1v4Bew52gpc8EWDR9HPdNmgw1Kk2lReWAiT2EBEtPUtSzQycR2qVOobT5lInKwKBgQC4HlTE6Di7hnI79xj1m09iJpNQ6CxHxNPZlwCnHp5J3gUVzKmUtYqpKLG+beCOJErChbDfUWGj1Z1xIi345ZIHTXnGK5fjVWrEodoggvHKUEc5CdlfHCxcKaMBaScUXDPHrX9eH5ykvmXa+0VfXJCLmczisWEgqXFWVKhYGCBQ3wKBgQC/lQrN9Jfy1g2FXhQ7LGfYgxWho0QdcUnEtWVNLAb++65wgsvnH0TZqm7MwYAMHre477JvE5CZXSwddTZSV5aEomAvsQ9bgXQ2jxPsRlTHsL2jkgsM6xCqKUZ0RK03yDtM167H9swLDbWYslaPpNS5cw5OiEZefrXXaV3TsAufcwKBgQCoW5vZ/hq6ZwMYECfzlhPtxSZaCiNLcRDi27BOILJPC0SNHXtHrwVfDwYRAnoen9L4srT8T3dAD7oK1F1DRfDU2qRqcDxQNTAPI4zIw9QC0ot9/aKV1LY/hBc42AVTGciDYwOfdrqO7kdHCRLzUzodXQK7m8Ubz7UCYyEYhN8v8wKBgQCyCVm2+jiL5AUz3dpzDMpA79RQrdjuuLvJ4Rj6WCzp549MXqMsB4d3k3sufVBlVqnDsEZZLcGU7IvQboJhAjEwUeynU54o6bQUTf6GCD0TJbCy6lu71AXhb9bYqEFR2fW4EhJOMNgCNmf1C6cgwwsfd4VP2V5UhgCdRyyebZQexw==";
    private static final String MERCHANT_ID = "123456";

    @Autowired
    private RestTemplate restTemplate;

    @PostMapping("/trade")
    public String trade(@RequestBody Map<String, Object> body) {
        Object content = body.get("content");
        if (Objects.isNull(content)) {
            throw new IllegalArgumentException("content should not be null");
        }
        if (!(content instanceof String)) {
            throw new IllegalArgumentException("content should be a string");
        }
        String contentString = content.toString();
        Map<String, Object> requestBody = new HashMap<>();
        requestBody.put("content", contentString);
        requestBody.put("sign", SignUtil.sign(contentString, PRIVATE_KEY));
        requestBody.put("merchantId", MERCHANT_ID);
        return restTemplate.postForObject("http://192.168.124.66:8080/server/api/trade", requestBody, String.class);
    }

}
