docker run --rm -it  -v $PWD:/app  -v ~/.m2:/root/.m2  -w /app  maven:3.6.3-jdk-8 mvn clean package -DskipTests

docker build -t sign-client -f ./dockerfile-alpine_en_us  .
docker build -t sign-client -f ./dockerfile-bullseye_en_us  .
docker build -t sign-client -f ./dockerfile-bullseye_c  .

docker run -p 18080:18080 --name sign-client -d sign-client

docker logs -f --tail 111 sign-client


```shell
################
# 前提：先修改代码，SignUtil类中不指定编码
            signature.update(content.getBytes());
################

# 在 FROM openjdk:8u322-jdk-bullseye 且 LANG=en_US.UTF-8 时参数里无中文时验签正常
# 在 FROM openjdk:8u322-jdk-bullseye 且 LANG=C.UTF-8 时参数里无中文时验签正常
curl -X POST 'http://127.0.0.1:18080/client/api/trade' -H 'content-type: application/json' -d '{"content": "aaZAaw903jd98ldQW"}'
# 在 FROM openjdk:8u322-jdk-bullseye 且 LANG=en_US.UTF-8 时参数里有中文时验签不正常
# 在 FROM openjdk:8u322-jdk-bullseye 且 LANG=C.UTF-8 时参数里无中文时验签正常
curl -X POST 'http://127.0.0.1:18080/client/api/trade' -H 'content-type: application/json' -d '{"content": "aaZAaw903jd98ldQW啊"}'
```


```shell
################
# 前提：先修改代码，SignUtil类中指定编码
            signature.update(content.getBytes(StandardCharsets.UTF_8));
################

# 在 FROM openjdk:8u322-jdk-bullseye 且 LANG=en_US.UTF-8 时参数里无中文时验签正常
# 在 FROM openjdk:8u322-jdk-bullseye 且 LANG=C.UTF-8 时参数里无中文时验签正常
curl -X POST 'http://127.0.0.1:18080/client/api/trade' -H 'content-type: application/json' -d '{"content": "aaZAaw903jd98ldQW"}'
# 在 FROM openjdk:8u322-jdk-bullseye 且 LANG=en_US.UTF-8 时参数里有中文时验签正常
# 在 FROM openjdk:8u322-jdk-bullseye 且 LANG=C.UTF-8 时参数里无中文时验签正常
curl -X POST 'http://127.0.0.1:18080/client/api/trade' -H 'content-type: application/json' -d '{"content": "aaZAaw903jd98ldQW啊"}'
```

结论

代码中不要使用.getBytes()这样的代码，要使用.getBytes(StandardCharset.UTF_8)

