package com.example.springboot2mybatisstartpage.common;

import java.io.Serializable;

import lombok.Data;

@Data
public class ResultBody2<T> implements Serializable {

    private String code;

    private String message;

    private T data;

    /**
     * 服务请求成功code
     */
    private static final String SUCCESS_CODE = "200";
    /**
     * 服务请求成功message
     */
    private static final String SUCCESS_MESSAGE = "操作成功";
    /**
     * 服务请求失败code
     */
    private static final String FAIL_CODE = "201";
    /**
     * 服务请求失败message
     */
    private static final String FAIL_MESSAGE = "服务请求异常";

    /**
     * 适用于“保存、删除、修改”等操作返回前端的数据格式
     *
     */
    public static <T> ResultBody2<T> resultSuccess() {
        return resultSuccess(SUCCESS_MESSAGE);
    }

    /**
     * 适用于“保存、删除、修改”等操作返回前端的数据格式
     *
     */
    public static <T> ResultBody2<T> resultSuccess(String mesaage) {
        ResultBody2<T> resultBody = new ResultBody2<T>();
        resultBody.setCode(SUCCESS_CODE);
        resultBody.setMessage(mesaage);
        return resultBody;
    }

    /**
     * 适用于“报错”等操作返回前端的数据格式
     *
     */
    public static <T> ResultBody2<T> resultError() {
        ResultBody2<T> resultBody = new ResultBody2<T>();
        resultBody.setCode(FAIL_CODE);
        resultBody.setMessage(FAIL_MESSAGE);
        return resultBody;
    }

    /**
     * 适用于“报错”等操作返回前端的数据格式
     *
     */
    public static <T> ResultBody2<T> resultError(String code, String message) {
        ResultBody2<T> resultBody = new ResultBody2<T>();
        resultBody.setCode(code);
        resultBody.setMessage(message);
        return resultBody;
    }


    public static <T> ResultBody2<T> resultError(String message) {
        ResultBody2<T> resultBody = new ResultBody2<>();
        resultBody.setCode(FAIL_CODE);
        resultBody.setMessage(message);
        return resultBody;
    }

    public static <T> ResultBody2<T> success(T data) {
        ResultBody2<T> resultBody = new ResultBody2<>();
        resultBody.setCode(SUCCESS_CODE);
        resultBody.setData(data);
        return resultBody;
    }


}
