package com.example.springboot2mybatisstartpage;

import java.util.List;

import com.example.springboot2mybatisstartpage.vo.DemoPageQueryReq;
import com.example.springboot2mybatisstartpage.vo.DemoPageQueryResp;
import com.example.springboot2mybatisstartpage.vo.DemoPageQueryVo;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DemoService {
    @Autowired
    private DemoMapper demoMapper;

    public PageInfo<DemoPageQueryVo> pageQuery1(DemoPageQueryReq req) {
        PageInfo<DemoPageQueryVo> demoPageQueryVoPageInfo = PageHelper.startPage(req.getPageNum(), req.getPageSize()).doSelectPageInfo(() -> {
            queryListFromDb(req);
        });
        return demoPageQueryVoPageInfo;
    }

    private List<DemoPageQueryResp> queryListFromDb(DemoPageQueryReq req) {
        return demoMapper.selectByAreaCode(req);
    }

    public PageInfo<DemoPageQueryResp> pageQuery2(DemoPageQueryReq req) {
        PageHelper.startPage(req.getPageNum(), req.getPageSize());
        List<DemoPageQueryResp> demoPageQueryResps = queryListFromDb(req);
        return new PageInfo<>(demoPageQueryResps);
    }
}
