package com.example.springboot2mybatisstartpage;

import com.example.springboot2mybatisstartpage.common.ResultBody2;
import com.example.springboot2mybatisstartpage.vo.DemoPageQueryReq;
import com.example.springboot2mybatisstartpage.vo.DemoPageQueryResp;
import com.example.springboot2mybatisstartpage.vo.DemoPageQueryVo;
import com.github.pagehelper.PageInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping("/demo")
public class DemoController {
    @Autowired
    private DemoService demoService;

    @PostMapping("/pageQuery1")
    public ResultBody2<PageInfo<DemoPageQueryVo>> pageQuery1(@RequestBody DemoPageQueryReq req) {
        return ResultBody2.success(demoService.pageQuery1(req));
    }
    @PostMapping("/pageQuery2")
    public ResultBody2<PageInfo<DemoPageQueryResp>> pageQuery2(@RequestBody DemoPageQueryReq req) {
        return ResultBody2.success(demoService.pageQuery2(req));
    }
}
