<?php
header('Access-Control-Allow-Origin: *');

function ParsePaopaoBiaoqingCallback($match)
{
    return '<img style="height: 18px; vertical-align: -4px;" src="https://cdn.jsdelivr.net/npm/typecho_joe_theme@4.3.5/assets/owo/paopao/' . str_replace('%', '', urlencode($match[1])) . '_2x.png" />';
}

function ParseAruBiaoqingCallback($match)
{
    return '<img style="height: 18px; vertical-align: -4px;" src="https://cdn.jsdelivr.net/npm/typecho_joe_theme@4.3.5/assets/owo/aru/' . str_replace('%', '', urlencode($match[1])) . '_2x.png">';
}

class JoePrograme_Action extends Typecho_Widget implements Widget_Interface_Do
{
    public function __construct($request, $response, $params)
    {
        parent::__construct($request, $response, $params);
        $this->db  = Typecho_Db::get();
        $this->res = new Typecho_Response();
        $this->token = Typecho_Widget::widget('Widget_Options')->plugin('JoePrograme')->JToken;
        call_user_func(array(
            $this,
            $this->request->type
        ));
    }

    /* 1. 获取轮播图 */
    private function getSwiperList()
    {
        self::checkToken();
        $result = array();
        $JSwiper = Typecho_Widget::widget('Widget_Options')->plugin('JoePrograme')->JSwiper;
        $JSwiperNull = Typecho_Widget::widget('Widget_Options')->plugin('JoePrograme')->JSwiperNull;
        $cids = explode("||", $JSwiper);
        foreach ($cids as $cid) {
            $post = $this->db->fetchAll($this->db->select('cid')
                ->from('table.contents')
                ->where("table.contents.password IS NULL")
                ->where('cid = ?', $cid)
                ->where('type = ?', 'post')
                ->where('status = ?', 'publish')
                ->where('created <= ?', time()));
            if (sizeof($post) > 0 && $post[0] != null) {
                $post[0]['image'] = self::GetImage($post[0]['text']);
                $result[]    = $post[0];
            }
        }
        if (sizeof($result) > 0) {
            $this->export($result);
        } else {
            $this->export(array(array(
                "cid" => -1,
                "image" => $JSwiperNull ? $JSwiperNull : "../../assets/img/bg.jpg"
            )));
        }
    }

    /* 2. 获取公告 */
    private function getNotcie()
    {
        self::checkToken();
        $JNotice = Typecho_Widget::widget('Widget_Options')->plugin('JoePrograme')->JNotice;
        $JNoticeArr = explode("||", $JNotice);
        if (!$JNotice) {
            $this->export(null);
        } else {
            $this->export(array(
                "content" => $JNoticeArr[0],
                "cid" => $JNoticeArr[1] ? $JNoticeArr[1] : null
            ));
        }
    }

    /* 3. 获取热门文章 */
    private function getHotList()
    {
        self::checkToken();
        $limit = Typecho_Widget::widget('Widget_Options')->plugin('JoePrograme')->JHotNumer;
        $select = $this->db->select('cid', 'title', 'views', 'text')
            ->from('table.contents')
            ->where("table.contents.password IS NULL")
            ->where('type = ?', 'post')
            ->where('status = ?', 'publish')
            ->where('created <= ?', time())
            ->limit($limit)
            ->order('table.contents.views', Typecho_Db::SORT_DESC);
        $posts  = $this->db->fetchAll($select);
        $result = array();
        foreach ($posts as $post) {
            $post['views'] = number_format($post['views']);
            $post['image'] = self::GetImage($post['text']);
            $result[]    = $post;
        }
        $this->export($result);
    }

    /* 4. 获取列表 */
    private function getPostList()
    {
        self::checkToken();
        $pageSize = (int) self::GET('pageSize', 10);
        $page     = (int) self::GET('page', 1);
        $offset   = $pageSize * ($page - 1);
        $select = $this->db->select('cid', 'title', 'created', 'text', 'views', 'commentsNum')
            ->from('table.contents')
            ->where("table.contents.password IS NULL")
            ->where('type = ?', 'post')
            ->where('status = ?', 'publish')
            ->where('created <= ?', time())
            ->order('table.contents.created', Typecho_Db::SORT_DESC)
            ->offset($offset)
            ->limit($pageSize);
        $posts  = $this->db->fetchAll($select);
        $result = array();
        $result['list'] = array();
        foreach ($posts as $post) {
            $post['category'] = $this->db->fetchAll($this->db->select('name')->from('table.metas')->join('table.relationships', 'table.metas.mid = table.relationships.mid', Typecho_DB::LEFT_JOIN)->where('table.relationships.cid = ?', $post['cid'])->where('table.metas.type = ?', 'category'));
            $post['image'] = self::GetImage($post['text']);
            $text = preg_replace("/<!--markdown-->/sm", '', $post['text']);
            $text = Markdown::convert($text);
            $post['text'] = strip_tags($text);
            $post['views'] = number_format($post['views']);
            $post['publish'] = date('Y/m/d', $post['created']);
            $result['list'][]    = $post;
        }
        $result['total'] = count($this->db->fetchAll($select = $this->db->select()->from('table.contents')->where("table.contents.password IS NULL")->where('type = ?', 'post')->where('status = ?', 'publish')->where('created <= ?', time())));
        $this->export($result);
    }

    /* 5. 获取文章详情 */
    private function getPostDetail()
    {
        self::checkToken();
        $cid     = self::GET('cid');
        $select = $this->db->select('cid', 'title', 'created', 'modified', 'text', 'commentsNum', 'allowComment', 'views', 'agree')->from('table.contents')->where("table.contents.password IS NULL")->where('type = ?', 'post')->where('status = ?', 'publish')->where('created <= ?', time())->where('cid = ?', $cid);
        $post  = $this->db->fetchAll($select);
        if (sizeof($post) > 0 && $post[0] != null) {
            $post[0]['category'] = $this->db->fetchAll($this->db->select('name')->from('table.metas')->join('table.relationships', 'table.metas.mid = table.relationships.mid', Typecho_DB::LEFT_JOIN)->where('table.relationships.cid = ?', $cid)->where('table.metas.type = ?', 'category'));
            $post[0]['tags'] = $this->db->fetchAll($this->db->select('name')->from('table.metas')->join('table.relationships', 'table.metas.mid = table.relationships.mid', Typecho_DB::LEFT_JOIN)->where('table.relationships.cid = ?', $cid)->where('table.metas.type = ?', 'tag'));
            $post[0]['image'] = self::GetImage($post[0]['text']);
            $post[0]['text'] = preg_replace("/<!--markdown-->/sm", '', $post[0]['text']);
            $post[0]['views'] = number_format($post[0]['views']);
            $post[0]['publish'] = date('Y年m月d日', $post[0]['created']);
            $post[0]['modified'] = date('Y年m月d日', $post[0]['modified']);
            /* 查询上一篇 */
            $prevSql = $this->db->select('cid', 'title', 'text')
                ->from('table.contents')
                ->where('table.contents.created > ?', $post[0]['created'])
                ->where("table.contents.password IS NULL")
                ->where('table.contents.type = ?', 'post')
                ->where('table.contents.status = ?', 'publish')
                ->order('table.contents.created', Typecho_Db::SORT_ASC)
                ->limit(1);
            $prev = $this->db->fetchRow($prevSql);
            if (sizeof($prev) > 0 && $prev != null) {
                $prev['image'] = self::GetImage($prev['text']);
                $post[0]['prev'] = $prev;
            } else {
                $post[0]['prev'] = null;
            }
            /* 查询下一篇 */
            $nextSql = $this->db->select('cid', 'title', 'text')
                ->from('table.contents')
                ->where('table.contents.created < ?', $post[0]['created'])
                ->where("table.contents.password IS NULL")
                ->where('table.contents.type = ?', 'post')
                ->where('table.contents.status = ?', 'publish')
                ->order('table.contents.created', Typecho_Db::SORT_DESC)
                ->limit(1);
            $next = $this->db->fetchRow($nextSql);
            if (sizeof($next) > 0 && $next != null) {
                $next['image'] = self::GetImage($next['text']);
                $post[0]['next'] = $next;
            } else {
                $post[0]['next'] = null;
            }
        }
        $this->export($post[0]);
    }

    /* 获取标签 */
    private function getTags()
    {
        self::checkToken();
        $select = $this->db->select('mid', 'name', 'count')
            ->from("table.metas")
            ->where("type = ?", 'tag')
            ->order('table.metas.count', Typecho_Db::SORT_DESC)
            ->limit(20);
        $tags = $this->db->fetchAll($select);
        $this->export($tags);
    }

    /* 搜索结果 */
    private function getSearchList()
    {
        self::checkToken();
        $pageSize = (int) self::GET('pageSize', 10);
        $page     = (int) self::GET('page', 1);
        $offset   = $pageSize * ($page - 1);
        $keyword = self::GET('keyword');
        $type = self::GET('type');
        if ($type == '0') {
            $sort = 'created';
        } else if ($type == '1') {
            $sort = 'views';
        } else {
            $sort = 'commentsNum';
        }
        $searchQuery = '%' . str_replace(' ', '%', $keyword) . '%';
        $select = $this->db->select('cid', 'title', 'created', 'text', 'views', 'commentsNum')
            ->from('table.contents')
            ->where('table.contents.title LIKE ? OR table.contents.text LIKE ?', $searchQuery, $searchQuery)
            ->where("table.contents.password IS NULL")
            ->where('status = ?', 'publish')
            ->where('created <= ?', time())
            ->order($sort, Typecho_Db::SORT_DESC)
            ->where("type = ?", 'post')
            ->offset($offset)
            ->limit($pageSize);
        $posts  = $this->db->fetchAll($select);
        $result = array();
        $result['list'] = array();
        foreach ($posts as $post) {
            $post['category'] = $this->db->fetchAll($this->db->select('name')->from('table.metas')->join('table.relationships', 'table.metas.mid = table.relationships.mid', Typecho_DB::LEFT_JOIN)->where('table.relationships.cid = ?', $post['cid'])->where('table.metas.type = ?', 'category'));
            $post['image'] = self::GetImage($post['text']);
            $text = preg_replace("/<!--markdown-->/sm", '', $post['text']);
            $text = Markdown::convert($text);
            $post['text'] = strip_tags($text);
            $post['views'] = number_format($post['views']);
            $post['publish'] = date('Y/m/d', $post['created']);
            $result['list'][]    = $post;
        }
        $result['total'] = count(
            $this->db->fetchAll(
                $select = $this->db->select()
                    ->from('table.contents')
                    ->where('table.contents.title LIKE ? OR table.contents.text LIKE ?', $searchQuery, $searchQuery)
                    ->where("table.contents.password IS NULL")
                    ->where('status = ?', 'publish')
                    ->where('created <= ?', time())
                    ->where("type = ?", 'post')
            )
        );
        $this->export($result);
    }

    /* 获取全部分类 */
    private function getCategories()
    {
        self::checkToken();
        $select = $this->db->select("mid", 'name', 'slug')
            ->from("table.metas")
            ->where('type = ?', 'category');
        $categories  = $this->db->fetchAll($select);
        $this->export($categories);
    }

    /* 根据分类id获取文章列表 */
    private function getPostListByMid()
    {
        self::checkToken();

        $page     = (int) self::GET('page', 1);
        $pageSize = (int) self::GET('pageSize', 10);
        $offset   = $pageSize * ($page - 1);
        $mid      = self::GET('mid', -1);

        $result = array();
        $result['list'] = array();

        $posts = $this->db->fetchAll(
            $this->db->select('table.contents.cid', 'table.contents.title', 'table.contents.created', 'table.contents.commentsNum', 'table.contents.views', 'table.contents.text')
                ->from('table.contents')
                ->join('table.relationships', 'table.contents.cid = table.relationships.cid', Typecho_DB::LEFT_JOIN)
                ->where('table.relationships.mid = ?', $mid)
                ->where('table.contents.status = ?', 'publish')
                ->where("table.contents.password IS NULL")
                ->where('created <= ?', time())
                ->where("type = ?", 'post')
                ->offset($offset)
                ->limit($pageSize)
        );

        foreach ($posts as $post) {
            $post['image'] = self::GetImage($post['text']);
            $post['views'] = number_format($post['views']);
            $post['created'] = date('Y/m/d', $post['created']);
            $result['list'][] = $post;
        }


        $count = count($this->db->fetchAll(
            $this->db->select()
                ->from('table.contents')
                ->join('table.relationships', 'table.contents.cid = table.relationships.cid', Typecho_DB::LEFT_JOIN)
                ->where('table.relationships.mid = ?', $mid)
                ->where('table.contents.status = ?', 'publish')
                ->where("table.contents.password IS NULL")
                ->where('created <= ?', time())
                ->where("type = ?", 'post')
        ));

        $result['total'] = $count;

        $this->export($result);
    }

    /* 点赞 */
    private function handlePostAgree()
    {
        self::checkToken();
        $cid     = self::GET('cid');
        $type     = self::GET('type');
        $row = $this->db->fetchRow($this->db->select('agree')->from('table.contents')->where('cid = ?', $cid));
        if (sizeof($row) > 0) {
            if ($type === 'agree') {
                $this->db->query($this->db->update('table.contents')->rows(array('agree' => (int)$row['agree'] + 1))->where('cid = ?', $cid));
            } else {
                $this->db->query($this->db->update('table.contents')->rows(array('agree' => (int)$row['agree'] - 1))->where('cid = ?', $cid));
            }
            $this->export($this->db->fetchRow($this->db->select('agree')->from('table.contents')->where('cid = ?', $cid)));
        } else {
            $this->export(null, -1);
        }
    }

    /* 获取评论 */
    private function getCommentByCid()
    {
        self::checkToken();
        $cid     = self::GET('cid');
        $comments = $this->db->fetchAll(
            $this->db->select('cid', 'coid', 'created', 'author', 'mail', 'text', 'parent')
                ->from('table.comments')
                ->where('cid = ?', $cid)
                ->where('status = ?', 'approved')
                ->where('type = ?', 'comment')
                ->order('table.comments.created', Typecho_Db::SORT_ASC)
        );
        $result = array();
        $result['list'] = array();
        $result['count'] = count($comments);
        foreach ($comments as $comment) {
            if ($comment['parent'] == 0) {
                $comment['created'] = date('Y年m月d日', $comment['created']);;
                $comment['mail'] = self::ParseAvatar($comment['mail']);
                $comment['text'] = self::ParseReply($comment['text']);
                $result['list'][] = $comment;
            }
        }
        foreach ($comments as $comment) {
            if ($comment['parent'] != 0) {
                $parent = $comment['parent'];
                $temp = $this->db->fetchAll(
                    $this->db->select('cid', 'coid', 'created', 'author', 'mail', 'text', 'parent')
                        ->from('table.comments')
                        ->where('cid = ?', $cid)
                        ->where('coid = ?', $parent)
                        ->where('status = ?', 'approved')
                        ->where('type = ?', 'comment')
                        ->order('table.comments.created', Typecho_Db::SORT_DESC)
                );
                if (sizeof($temp) > 0) {

                    while ($temp[0]['parent'] != 0) {
                        $parent = $temp[0]['parent'];
                        $temp = $this->db->fetchAll(
                            $this->db->select('cid', 'coid', 'created', 'author', 'mail', 'text', 'parent')
                                ->from('table.comments')
                                ->where('cid = ?', $cid)
                                ->where('coid = ?', $parent)
                                ->where('status = ?', 'approved')
                                ->where('type = ?', 'comment')
                                ->order('table.comments.created', Typecho_Db::SORT_DESC)
                        );
                    }

                    for ($i = 0; $i < sizeof($result['list']); $i++) {
                        if ($result['list'][$i]['coid'] == $temp[0]['coid']) {
                            $comment['created'] = date('Y/m/d', $comment['created']);;
                            $comment['mail'] = self::ParseAvatar($comment['mail']);
                            $comment['text'] = self::ParseReply($comment['text']);
                            $comment['parentItem'] = $this->db->fetchRow($this->db->select('cid', 'coid', 'author')->from('table.comments')->where('cid = ?', $cid)->where('coid = ?', $comment['parent'])->where('status = ?', 'approved')->where('type = ?', 'comment'));
                            $result['list'][$i]['replys'][] = $comment;
                        }
                    }
                }
            }
        }
        $result['list'] = array_reverse($result['list']);
        $this->export($result);
    }

    /* 是否显示评论 */
    private function isShowComment()
    {
        self::checkToken();
        $JCommentStatus = Typecho_Widget::widget('Widget_Options')->plugin('JoePrograme')->JCommentStatus;
        if ($JCommentStatus === "off") {
            $this->export('off');
        } else {
            $this->export('on');
        }
    }

    /* 点赞 */
    private function handlePostView()
    {
        self::checkToken();
        $cid     = self::GET('cid');
        $row = $this->db->fetchRow($this->db->select('views')->from('table.contents')->where('cid = ?', $cid));
        if (sizeof($row) > 0) {
            $this->db->query($this->db->update('table.contents')->rows(array('views' => (int)$row['views'] + 1))->where('cid = ?', $cid));
            $this->export(null, 200);
        } else {
            $this->export(null, -1);
        }
    }

    /* 发表评论 */
    private function publishComment()
    {
        self::checkToken();
        $cid = self::GET('cid', -1);
        $author = self::GET('author', "None");
        $mail = self::GET('mail', "None");
        $text = self::GET('text', "None");
        $parent = self::GET('parent', 0);
        $coid =  $this->db->query(
            $this->db->insert('table.comments')->rows(
                array(
                    'cid' => $cid,
                    'created' => time(),
                    'author' => $author,
                    'authorId' => '0',
                    'ownerId' => '1',
                    'mail' => $mail,
                    'ip' => '8.8.8.8',
                    'agent' => 'miniprogram',
                    'text' => $text,
                    'type' => 'comment',
                    'status' => 'approved',
                    'parent' => $parent,
                )
            )
        );
        if ($coid > 0) {
            $this->export(1, 200);
        } else {
            $this->export(0, 200);
        }
    }


    public function export($data = null, $status = 200)
    {
        $this->res->throwJson(array(
            'status' => $status,
            'data' => $data
        ));
    }

    public static function GET($key, $default = '')
    {
        return isset($_GET[$key]) ? $_GET[$key] : $default;
    }

    /* 获取文章的图片 */
    public static function GetImage($content)
    {
        $random = str_replace('//usr', '/usr', str_replace(Helper::options()->siteUrl, Helper::options()->rootUrl . '/', Helper::options()->themeUrl)) . '/assets/img/random/' . rand(1, 25) . '.webp';
        if (Helper::options()->Jmos) {
            $moszu = explode("\r\n", Helper::options()->Jmos);
            $random = $moszu[array_rand($moszu, 1)] . "?jrandom=" . mt_rand(0, 1000000);
        }
        $patternMD = '/\!\[.*?\]\((http(s)?:\/\/.*?(jpg|jpeg|gif|png|webp))/i';
        $patternMDfoot = '/\[.*?\]:\s*(http(s)?:\/\/.*?(jpg|jpeg|gif|png|webp))/i';
        $img = $random;
        if (preg_match_all($patternMD, $content, $thumbUrl)) {
            $img = $thumbUrl[1][0];
        } elseif (preg_match_all($patternMDfoot, $content, $thumbUrl)) {
            $img = $thumbUrl[1][0];
        }
        return $img;
    }

    /* 解析头像 */
    public static function ParseAvatar($mail)
    {
        $b = 'https://gravatar.helingqi.com/wavatar/';
        $c = strtolower($mail);
        $d = md5($c);
        $f = str_replace('@qq.com', '', $c);
        if (strstr($c, "qq.com") && is_numeric($f) && strlen($f) < 11 && strlen($f) > 4) {
            $g = 'https://thirdqq.qlogo.cn/g?b=qq&nk=' . $f . '&s=100';
        } else {
            $g = $b . $d . '?d=mm';
        }
        return $g;
    }

    /* 解析回复 */
    public static function ParseReply($text)
    {
        $text = preg_replace_callback(
            '/\:\:\(\s*(呵呵|哈哈|吐舌|太开心|笑眼|花心|小乖|乖|捂嘴笑|滑稽|你懂的|不高兴|怒|汗|黑线|泪|真棒|喷|惊哭|阴险|鄙视|酷|啊|狂汗|what|疑问|酸爽|呀咩爹|委屈|惊讶|睡觉|笑尿|挖鼻|吐|犀利|小红脸|懒得理|勉强|爱心|心碎|玫瑰|礼物|彩虹|太阳|星星月亮|钱币|茶杯|蛋糕|大拇指|胜利|haha|OK|沙发|手纸|香蕉|便便|药丸|红领巾|蜡烛|音乐|灯泡|开心|钱|咦|呼|冷|生气|弱|吐血)\s*\)/is',
            'ParsePaopaoBiaoqingCallback',
            $text
        );
        $text = preg_replace_callback(
            '/\:\@\(\s*(高兴|小怒|脸红|内伤|装大款|赞一个|害羞|汗|吐血倒地|深思|不高兴|无语|亲亲|口水|尴尬|中指|想一想|哭泣|便便|献花|皱眉|傻笑|狂汗|吐|喷水|看不见|鼓掌|阴暗|长草|献黄瓜|邪恶|期待|得意|吐舌|喷血|无所谓|观察|暗地观察|肿包|中枪|大囧|呲牙|抠鼻|不说话|咽气|欢呼|锁眉|蜡烛|坐等|击掌|惊喜|喜极而泣|抽烟|不出所料|愤怒|无奈|黑线|投降|看热闹|扇耳光|小眼睛|中刀)\s*\)/is',
            'ParseAruBiaoqingCallback',
            $text
        );
        return $text;
    }


    /* 检查接口密钥 */
    private function checkToken()
    {
        $token = self::GET('token', 'null');
        if (strcmp($token, $this->token) != 0) {
            $this->export('Token验证失败！', 401);
        }
    }

    public function action()
    {
        $this->on($this->request);
    }
}
