#!/system/bin/sh
#需将xml文件放入同一文件夹
#编写作者：@coolapk 10007
#gitee主页https://gitee.com/keytoolazy/mapdepot

#创建busybox目录，避免无命令，或者命令冲突。
function install_magisk_busybox() {
mkdir -p /data/adb/busybox
	/data/adb/magisk/busybox --install -s /data/adb/busybox
	chmod -R 0755 /data/adb/busybox 
export PATH=/data/adb/busybox:$PATH
}

#定位变量和函数支持
local IFS=$'\n'
folder="${0%/*}"

function transfer_file(){
local file="$1"
if test -f "$file" ;then
	sed -i 's|[[:space:]]||g;s|"/>||g;/^[[:space:]]*$/d' $file
	sed -i 's|</activity>||g;s|<activity>||g;s|</broadcast>||g;s|<broadcast>||g;s|</service>||g;s|<service>||g;s|</rules>||g;s|<rules>||g;s|<component-filter.*name=\"||g;s|block=\".*\"||g;s|log=\".*\"||g' "$file"
	sed -i 's|</activity>||g;s|<activity>||g;s|</broadcast>||g;s|<broadcast>||g;s|</service>||g;s|<service>||g;s|</rules>||g;s|<rules>||g' "$file"
	sed -i 's|[[:space:]]||g;/^[[:space:]]*$/d;s|"/>||g' $file
	echo "$(cat $file | sort | uniq )" > "$file"
fi
}

function form_script(){
local file="$1"
local script_file="${file##*/}.sh"
local IFS=$'\n'
cat << key > "$script_file"
#!/system/bin/sh
IFS=\$'\n'

list='
`cat "${file}"`
'

key
cat <<key >> "$script_file"
for i in \$( echo "\${list}" | sed '/^#/d;/^[[:space:]]*$/d' )
do
#禁用组件
pm disable "\$i" >/dev/null 2>&1
pm hide "\$i" >/dev/null 2>&1
#启用组件
#pm enable "\$i" >/dev/null 2>&1
#pm unhide "\$i" >/dev/null 2>&1
done
key
}


for file in $folder/*.xml
do
	cp -rf "${file}" "${file%/*}/${file##*/}.script"
	transfer_file "${file%/*}/${file##*/}.script"
	form_script "${file%/*}/${file##*/}.script" && rm -rf "${file%/*}/${file##*/}.script"
done










