#!/system/bin/sh


mkdir -p /data/adb/busybox

/data/adb/magisk/busybox --install -s /data/adb/busybox

export PATH=$(magisk --path)/.magisk/busybox:/system/bin:/data/adb/busybox:$PATH

#恢复host拦截
find /data/adb/modules -type f -iname "hosts.bak" 2>/dev/null | while read file; do
	mv -f "${file}" "${file%/*}/hosts"
done

#恢复虎牙屏蔽
iptables -F

function X_file() {
	if test -e "$1"; then
		rm -rf "$1"
		touch "$1"
		chmod 000 "$1"
		chattr +i "$1"
	fi
}

function RE_file() {
	if test -e "$1"; then
		chattr -i "$1"
		chmod 777 "$1"
		rm -rf "$1"
	fi
}

function ads_recovery() {
	local file_path="

#豆瓣广告
/data/data/com.douban.frodo/cache/douban_ad

#驾考宝典
/data/data/com.handsgo.jiakao.android/cache/GDTDOWNLOAD
/data/media/[0-9]*/Android/data/com.handsgo.jiakao.android/cache/reward_video_cache_*
/data/media/[0-9]*/Android/data/com.handsgo.jiakao.android/cache/splash_ad_cache

#抖音
/data/media/[0-9]*/Android/data/com.ss.android.ugc.aweme/awemeSplashCache
/data/media/[0-9]*/Android/data/com.ss.android.ugc.aweme/liveSplashCache
/data/media/[0-9]*/Android/data/com.ss.android.ugc.aweme/splashCache


#QQ浏览器
/data/data/com.tencent.mtt/files/tad_cache

#QQ音乐
/data/data/com.tencent.qqmusic/app_adnet
/data/data/com.tencent.qqmusic/files/tad_cache
/data/media/[0-9]*/qqmusic/splash

#人人影视PRO
/data/data/com.yyets.pro/app_ad

#酷安
/data/media/[0-9]*/Android/data/com.coolapk.market/cachett_ad
/data/media/[0-9]*/Android/data/com.coolapk.market/cache/splash_image
/data/media/[0-9]*/Android/data/com.coolapk.market/cache/com_qq_e_download
/data/media/[0-9]*/Android/data/com.coolapk.market/cache/pangle_com.byted.pangle
/data/media/[0-9]*/Android/data/com.coolapk.market/cache/tt_tmpl_pkg
/data/media/[0-9]*/Android/data/com.coolapk.market/files/TTCache
/data/media/[0-9]*/Android/data/com.coolapk.market/cache/com.jd.jdsdk


#keep
/data/media/[0-9]*/Android/data/com.gotokeep.keep/files/keep/ads

#网易云
/data/media/[0-9]*/Android/data/com.netease.cloudmusic/cache/Ad
/data/media/[0-9]*/netease/adcache
/data/media/[0-9]*/netease/cloudmusic/Ad

#今日头条
/data/media/[0-9]*/Android/data/com.ss.android.article.news/splashCache

#腾讯微视
/data/media/[0-9]*/Android/data/com.tencent.weishi/splash_cache

#QQ
/data/media/[0-9]*/Tencent/MobileQQ/splahAD
/data/media/[0-9]*/Tencent/TMAssistantSDK
/data/media/[0-9]*/Android/data/com.tencent.mobileqq/Tencent/TMAssistantSDK
/data/media/[0-9]*/Android/data/com.tencent.mobileqq/MobileQQ/splahAD


#高德地图
/data/media/[0-9]*/autonavi/afpSplash
/data/media/[0-9]*/autonavi/splash

#酷狗音乐
/data/media/[0-9]*/kugou/.splash

#微博
/data/media/[0-9]*/sina/weibo/.weibo_ad_universal_cache
/data/media/[0-9]*/sina/weibo/.weibo_refreshad_cache
/data/media/[0-9]*/sina/weibo/.weibo_video_cache_new
/data/media/[0-9]*/sina/weibo/.weiboadcache
/data/media/[0-9]*/sina/weibo/storage/biz_keep/.weibo_ad_universal_cache
/data/media/[0-9]*/sina/weibo/storage/biz_keep/.weibo_refreshad_cache

#淘宝
/data/media/[0-9]*/Android/data/com.taobao.taobao/files/acds


#咪咕的各类应用
/data/media/[0-9]*/Mob

#MIUI
/data/media/[0-9]*/miad
/data/media/[0-9]*/Android/data/com.miui.systemAdSolution
"

	for i in $file_path; do
		file=$(find "$i" 2>/dev/null)
		RE_file "${file}" 2>/dev/null
	done

}

function ad_file_recovery() {
find /data/user /data/data /data/media/*/Android/data -iname "xm_ad_img_cache" -perm 000 -o -iname "ads" -perm 000 -o -iname "douban_ad" -perm 000 -o -iname "splashCache" -perm 000 -o -iname "SplashPreload" -perm 000 -o -iname "app_mod_resource" -perm 000 -o -iname "splash_image" -perm 000 -o -iname "splashCache" -perm 000 -o -iname "SplashData" -perm 000 -o -iname "TMEAds" -perm 000 -o -iname "qad_cache" -perm 000 -o -iname "SplashPreload" -perm 000 -o -iname "splash_ad_cache" -perm 000 -o -iname "GDTDOWNLOAD" -perm 000 -o -iname "app_adnet" -perm 000 -o -iname "tad_cache" -perm 000 -o -iname "app_ad" -perm 000 -o -iname "TTCache" -perm 000 -o -iname "app_ad" -perm 000 -o -iname "cachett_ad" -perm 000 -o -iname "tt_tmpl_pkg" -perm 000 -o -iname "com_qq_e_download" -perm 000 -o -iname "pangle_com.byted.pangle" -perm 000 2>/dev/null | while read adfile ;do
	RE_file "${adfile}" 2>/dev/null
done
}

( ads_recovery & )
( ad_file_recovery & )


