#!/system/bin/sh
#@ coolapk 10007


package="
com.xiaomi.ab
com.miui.systemAdSolution
com.miui.analytics
com.opos.ad
com.opos.ads
"

test "${MODPATH}" = "" && exit 1

function correctpath() {
case $(echo "${1}") in
/system_ext* | /vendor* | /product*)
	echo "/system"${1}""
;;
/system*)
	echo "${1}"
;;
esac
}

function recovery_app_path() {
local package=$1
dumpsys package $package | grep -w "codePath=" | sed "/\/data/d;s|.*codePath=||g" | head -n 1
}

function set_perm() {
if test -e "$1" ;then
	chown $2:$3 $1 || return 1
	chmod $4 $1 || return 1
		CON=$5
	test -z $CON && CON=u:object_r:system_file:s0
	chcon $CON $1 || return 1
fi
}

function set_perm_recursive() {
if test -e "$1" ;then
find $1 -type d 2>/dev/null | while read dir; do
	set_perm $dir $2 $3 $4 $6
done
find $1 -type f -o -type l 2>/dev/null | while read file; do
	set_perm $file $2 $3 $5 $6
done
fi
}

function mktouch() {
mkdir -p ${1%/*} 2>/dev/null
	test -z $2 && touch $1 || echo $2 >$1
chmod 644 $1
}

function trimmer_file() {
local file=$1
if test -e "${find}" ;then
	sed -i '/^[[:space:]]*$/d' ${file}
		oldfile=$(sort -n ${file} | uniq)
	echo "$oldfile" >${file}
fi
}

function system_app_cache() {
folder="${1}"
find "$folder/system" -iname "*app" -type d | grep -v 'overlay' | while read app; do
	/data/adb/magisk/busybox find $app -maxdepth 1 -type d  | while read dir; do
		app_dir=${dir##*/}
			test $app_dir = "priv-app" && continue
			test $app_dir = "app" && continue
		dda=/data/dalvik-cache/arm
			test -d "$dda"64 && dda="$dda"64
cat <<key >>${folder}/uninstall.sh
rm -rf ${dda}/system@*@${app_dir}* 2>/dev/null
rm -rf /data/system/package_cache/* 2>/dev/null
key
		done && sed -i "1i #清理系统应用的缓存" ${folder}/uninstall.sh
	trimmer_file ${folder}/uninstall.sh
done
}

function start_lite_app() {
for appname in $package ;do
app_path="$(pm path $appname 2>/dev/null | cut -d':' -f2 )"
case $app_path in
/system* | /system_ext* | /vendor* | /product*)
	app_path_target="$(correctpath ${app_path})"
	app_path_final="${app_path_target%/*}"
	mktouch "$MODPATH$app_path_final/.replace"
;;
/data*)
	install_path="$(recovery_app_path $appname)"
		mktouch "$MODPATH$(correctpath ${install_path})/.replace"
		pm clear $appname >/dev/null 2>&1
	pm disable $appname >/dev/null 2>&1
pm hide $appname >/dev/null 2>&1
;;
esac
done
}

start_lite_app
system_app_cache $MODPATH

if test "$(getprop ro.miui.ui.version.name )" = "" ;then
	rm -rf "${MODPATH}/system/app/AnalyticsCore"
fi

rm -rf /data/system/package_cache/* 2>/dev/null

if test "$(getprop ro.miui.ui.version.name | tr -cd '[0-9]' )" -gt "130" ;then
	if test -d "${MODPATH}/system" -a "${MODPATH}" != "" ;then
		find ${MODPATH}/system -iname "*app*" -type d -exec rm -rf {} \;
	fi
fi

