#!/system/bin/sh

id="GGAT_10007"
Magisk_mod=$(grep -w -q 'lite_modules' /data/adb/magisk/util_functions.sh 2>/dev/null && echo "lite_modules" || echo "modules")
MODPATH="/data/adb/$Magisk_mod/$id"

export PATH="/system/bin:$MODPATH/busybox:$PATH"

local IFS=$'\n'

#删除并且用chmod权限锁定文件，效果比chattr要差
function mkdir_file() {
	if test -e "$1"; then
		chattr =A "$1"
			rm -rf "$1"
				mkdir -p "${1%/*}"
		touch "$1"
				chmod 0000 "$1"
			chcon u:object_r:system_file:s0 "$1"
		chown root:root "$1"
	fi
}

#禁用日志文件
find /data/user/*/com.zhihu.android /data/data/com.zhihu.android /data/media/*/Android/data/com.zhihu.android -iname "*log*" -type d 2>/dev/null | while read adfile ;do
	mkdir_file $adfile 2>/dev/null 
done

if test -d /data/data/com.zhihu.android/files ;then
	mkdir_file "/data/data/com.zhihu.android/files/exid.dat"
	mkdir_file "/data/data/com.zhihu.android/files/.imprint"
	mkdir_file "/data/data/com.zhihu.android/files/sp.lock"
	mkdir_file "/data/data/com.zhihu.android/files/du.lock"
	mkdir_file "/data/data/com.zhihu.android/files/umeng_it.cache"
fi
#删除广告文件夹
for i in `ls -d /data/user/*/com.zhihu.android/files/[[:digit:]]*[[:digit:]] 2>/dev/null `
do
	mkdir_file "${i}"
done
for i in `ls -d /data/user/*/com.zhihu.android/files/-[[:digit:]]*[[:digit:]] 2>/dev/null `
do
	mkdir_file "${i}"
done

#chattr -R +i /data/user/0/com.zhihu.android/files



