#!/bin/sh

dir="${0%/*}"
MODPATH="${dir%/*}"

export PATH="$MODPATH/busybox:$PATH"

source $MODPATH/mod/util_functions.sh

function list_Install_webview_code(){
local IFS=$'\n'
local package_name='
com.android.webview
com.google.android.webview
com.google.android.webview.debug
com.google.android.webview.dev
com.google.android.webview.canary
com.google.android.webview.beta
'
for i in ${package_name}
do
	app_version_Code=`dumpsys package "${i}" 2>/dev/null | grep -i 'versionCode=' | grep -Eo '[0-9]{9}' `
	echo "${app_version_Code}"
done
}

function echo_uninstall_webview_name(){
local webview_information=`dumpsys webviewupdate 2>/dev/null`
if test "${webview_information}" != "" ;then
	webview_current_ver=`echo "${webview_information}" | grep -i 'Current.*WebView.*package' | sed 's|.*,||g;s|).*||g' | head -n 1`
		webview_current_code=`echo "${webview_information}" | sed "/${webview_current_ver}/!d" | grep -Eo '[0-9]{9}' | head -n 1`
	webview_other_version=`dumpsys package | grep -E 'name:.*version:[0-9]{9}' | sed "s/[ ]version:/_/g;s/name://g"`
	for other in `list_Install_webview_code | sed '/^[[:space:]]*$/d' `
		do
			test "${last_webview}" = "" && last_webview="${webview_other_version}"
			list_webview=`echo "${last_webview}" | sed "/${other}/d;/^[[:space:]]*$/d" `
			last_webview="${list_webview}"
	done
		test "${last_webview}" != "" && echo "${last_webview}"
fi
}

function uninstall_other_webview(){
for target in `echo_uninstall_webview_name`
do
	echo "$target"
	pm uninstall "${target}"
done
}

uninstall_other_webview | tee "${0%/*}/webview.log"






