#!/system/bin/sh

sleep 2m

function Host_info(){
local dir="${0%/*}"
local MODPATH="${dir%/*}"
local host_file=`find "${MODPATH}" -iname "hosts" -type f | head -n 1`
test "${host_file}" = "" && host_file="/system/etc/hosts"
local host_count="$(cat $host_file | sed '/^#/d;/^[[:space:]]*$/d' | wc -l)"
if test "$host_count" -ge "500000" ;then 
	local sate="网络存在一定延迟"
elif test "$host_count" -ge "50000" ;then 
	local sate="网络小幅度延迟"
elif test "$host_count" -lt "50000" ;then 
	local sate="网络基本无影响"
fi
echo "当前Host数量: ${host_count}，${sate}"
}



function echo_head_info(){
echo "品牌=`getprop ro.product.brand`"
echo "代号=`getprop ro.product.device`"
echo "模型=`getprop ro.product.model`"
echo "安卓版本=`getprop ro.build.version.release`"
test "`getprop ro.miui.ui.version.name`" != "" && echo "MIUI版本=MIUI `getprop ro.miui.ui.version.name` - `getprop ro.build.version.incremental` "
Host_info
}

function magisk_app_uid(){
local package userid
if test "$( pm list package | grep -w 'com.topjohnwu.magisk' )" != "" ;then
	package='com.topjohnwu.magisk'
elif test "$( pm list package | grep -w 'io.github.huskydg.magisk' )" != "" ;then
	package='io.github.huskydg.magisk'
else
	package=`magisk --sqlite "SELECT value FROM strings where key='requester'"`
fi
if test "$package" != '' ;then
	userid="$(dumpsys package "${package}" | grep userId | uniq | tr -cd '[0-9]' | head -n 1)"
	echo "${userid}"
else
	echo '2000'
fi
}



function notification_simulation(){
local title="${2}"
local text="${1}"
local author="${3}"
if test "$(pm list package | grep -w 'com.google.android.ext.services' )" != "" ;then
	cmd notification allow_assistant 'com.google.android.ext.services/android.ext.services.notification.Assistant'
fi
#local word_count="`echo "${text}" | wc -c`"
#test "${word_count}" -gt "375" && text='文字超出限制，请尽量控制在375个字符！'
	test -z "${title}" && title='10007'
		test -z "${text}" && text='您未给出任何信息'
	test "`echo "${author}" | grep -E '^[0-9].*[0-9]$'`" = "" && author="2000"
su -lp "${author}" -c "cmd notification post -S messaging --conversation '${title}' --message '${title}':'${text}' 'Tag' '$(echo $RANDOM)' " >/dev/null 2>&1
}


notification_simulation "$(echo_head_info)" "去广告模块" "$(magisk_app_uid)"

sleep 15s

source "${0%/*}/disable_other_module_hosts.sh"

combine_host

