#!/system/bin/sh

#限制域名网速
function limit_network(){
local ip_name="${1}"
if test "${ip_name}" != "" ;then
	iptables -A FORWARD -m limit -d "${ip_name}" --limit 1/s --limit-burst 100 -j ACCEPT 
	iptables -A FORWARD -d "${ip_name}" -j DROP
	iptables -A FORWARD -m limit -s "${ip_name}" --limit 1/s --limit-burst 100 -j ACCEPT 
	iptables -A FORWARD -s "${ip_name}" -j DROP
fi
}

#恢复域名网速限制
function disable_limit_network(){
local ip_name="${1}"
if test "${ip_name}" != "" ;then
	iptables -D FORWARD -m limit -d "${ip_name}" --limit 1/s --limit-burst 100 -j ACCEPT 
	iptables -D FORWARD -d "${ip_name}" -j DROP
	iptables -D FORWARD -m limit -s "${ip_name}" --limit 1/s --limit-burst 100 -j ACCEPT 
	iptables -D FORWARD -s "${ip_name}" -j DROP
fi
}

#域名
list='
ad.test.ximalaya.com
ad.ximalaya.com
adbehavior.wsa.ximalaya.com
adbehavior.ximalaya.com
adbs.ximalaya.com
adcos.adxmly.com
adse.test.ximalaya.com
adse.wsa.ximalaya.com
adse.ximalaya.com
adsebs.ximalaya.com
adsehera.ximalaya.com
adwbs.ximalaya.com
adweb.test.ximalaya.com
adweb.ximalaya.com
collectorbs.ctc.ximalaya.com
dns.ximalaya.com
errlog.umeng.com
linkeye.ximalaya.com
location.ximalaya.com
mobwsa.ximalaya.com
pangolin.snssdk.com
toblog.ctobsnssdk.com
ulogs.umeng.com
xdcs-collector.ximalaya.com
'

for i in ${list}
do
	limit_network "${i}"
	#disable_limit_network "${i}"
done


