#!/bin/sh

id="GGAT_10007"
Magisk_mod=$(grep -w -q 'lite_modules' /data/adb/magisk/util_functions.sh 2>/dev/null && echo "lite_modules" || echo "modules")
MODPATH="/data/adb/$Magisk_mod/$id"

export PATH="/system/bin:$MODPATH/busybox:$PATH"

test -f "$MODPATH/mod/notification.sh" && exit 0 || sleep 5m

local_host_file=`find "$MODPATH" -iname "hosts" -type f 2>/dev/null `

function show_value() {
	local value=$1
	local file="$MODPATH/配置.prop"
	test ! -f "$file" && file="$MODPATH/配置.conf"
	cat "${file}" | grep -E "(^$value=)" | sed '/^#/d;/^[[:space:]]*$/d;s/.*=//g' | sed 's/，/,/g;s/——/-/g;s/：/:/g'
}

function grep_host() {
	find /data/adb/modules -type f -iname "hosts" | cut -d'/' -f5 | sort | uniq | grep -v "$id"
}

function notification_simulation(){
local title="${2}"
local text="${1}"
local author="${3}"
if test "$(pm list package | grep -w 'com.google.android.ext.services' )" != "" ;then
	cmd notification allow_assistant 'com.google.android.ext.services/android.ext.services.notification.Assistant'
fi
#local word_count="`echo "${text}" | wc -c`"
#test "${word_count}" -gt "375" && text='文字超出限制，请尽量控制在375个字符！'
	test -z "${title}" && title='10007'
		test -z "${text}" && text='您未给出任何信息'
	test "`echo "${author}" | grep -E '^[0-9].*[0-9]$'`" = "" && author="2000"
su -lp "${author}" -c "cmd notification post -S messaging --conversation '${title}' --message '${title}':'${text}' 'Tag' '$(echo $RANDOM)' " >/dev/null 2>&1
}


function combine_host() {
	for o in $(grep_host); do
		for i in $(ls /data/adb/modules); do
			name=$(cat /data/adb/modules/$i/module.prop | grep 'name' | cut -d = -f2)
			author=$(cat /data/adb/modules/$i/module.prop | grep 'author' | cut -d = -f2)
			description=$(cat /data/adb/modules/$i/module.prop | grep 'description' | cut -d = -f2)
			size=$(du -sh /data/adb/modules/$i | sed "s|/data/adb/modules/$i||g")
			if test "$i" = "$o" -a "$i" != "$id" -a ! -e "/data/adb/modules/$i/remove" -a ! -e "/data/adb/modules/$i/disable" ; then
				echo " "
				echo "∞————————————————————————∞"
				echo ""
				echo "－名称：$name"
				echo "－作者：$author"
				echo "－简介：$description"
				echo " "
				echo "－大小：$size"
				echo " "
				echo "－ 该模块含有hosts！"
				echo ""
				test "$value" = "1" && echo "－ 正在合并模块中……"
				test "$value" = "0" && echo "－ 禁用该模块的host……"
				target_count_modules="名称:${name},作者:$author,路径:/data/adb/modules/$i"
				total_module="${target_count_modules}\n${total_module}"
				echo ""
				find "/data/adb/modules/$i" -iname "hosts" -type f | while read mod_hostfile; do
				if test "$value" = "1" ;then
					for v in "${local_host_file}" ;do
						echo "$(cat "${mod_hostfile}")" >> "${v}"
						mv -f "$mod_hostfile" "$mod_hostfile.bak"
					done
				else
					mv -f "$mod_hostfile" "$mod_hostfile.bak"
				fi
			done && echo "－ 完成！"
			echo ""
			echo "∞————————————————————————∞"
			echo " "
		fi
		done
	notification_simulation " `echo "冲突模块已做处理\n\n${total_module}" ` `echo '\n如果不生效，请先进行重启操作🇨🇳！'` " "去广告模块" "2000"
done
}

