@echo off
chcp 65001

:: 获取当前批处理文件的目录并导航到该目录
set "CURRENT_DIR=%~dp0"

:: 提示用户输入参数的值
echo.
set /p IP_ADDRESS="请输入 -i 的IP地址（例如，192.168.100.102/24）："
echo %IP_ADDRESS%
set /p NETWORK_NAME="请输入 --network-name "
echo %NETWORK_NAME%
set /p NETWORK_SECRET="请输入 --network-secret "
echo %NETWORK_SECRET%

:: 提示输入可选的子网代理 -n 值，如果不提供则留空
set /p SUBNET_PROXY="请输入子网代理 -n（例如：192.168.87.0/24 可选，如果不需要请留空）："
echo %SUBNET_PROXY%

:: 构建命令字符串
set COMMAND=%CURRENT_DIR%/nssm.exe install easytier_service "%CURRENT_DIR%easytier-core" -p tcp://public.easytier.top:11010

:: 添加 -i 参数
set COMMAND=%COMMAND% -i %IP_ADDRESS%

:: 如果提供了 -n 子网代理值，则添加它
if not "%SUBNET_PROXY%"=="" set COMMAND=%COMMAND% -n %SUBNET_PROXY%

:: 添加 --network-name 和 --network-secret 参数
set COMMAND=%COMMAND% --network-name %NETWORK_NAME% --network-secret %NETWORK_SECRET%

:: 确保删除服务之前先停止它（如果存在）
echo 正在停止并删除服务（如果存在）...
%CURRENT_DIR%/nssm.exe stop easytier_service
%CURRENT_DIR%/nssm.exe remove easytier_service confirm

:: 执行组装好的命令
echo 正在执行命令：%COMMAND%
%COMMAND%

:: 设置服务为延迟自动启动
%CURRENT_DIR%/nssm.exe set easytier_service Start SERVICE_DELAYED_AUTO_START
%CURRENT_DIR%/nssm.exe start easytier_service
echo 服务已安装并设置为了自启动！
pause
