@echo off
chcp 65001

:: 获取当前批处理文件的目录并导航到该目录
set "CURRENT_DIR=%~dp0"

:: 显示菜单，提示用户选择安装或卸载
echo ===============================
echo 请选择操作：
echo.
echo 1. 安装服务
echo.
echo 2. 卸载服务
echo.
echo ===============================
set /p ACTION="请输入选项（1 或 2）："

:: 根据用户选择执行相应的操作
if "%ACTION%"=="1" goto pre_install
if "%ACTION%"=="2" goto uninstall
echo 无效选项，退出程序。
pause
goto :bat_end_after

:pre_install
:: 提示用户输入参数的值
echo.
set /p IP_ADDRESS="请输入 -i 的IP地址（例如，192.168.100.102/24）："
echo %IP_ADDRESS%
set /p NETWORK_NAME="请输入 --network-name："
echo %NETWORK_NAME%
set /p NETWORK_SECRET="请输入 --network-secret："
echo %NETWORK_SECRET%
:: 提示输入可选的子网代理 -n 值，如果不提供则留空
set /p SUBNET_PROXY="请输入子网代理 -n（例如：192.168.87.0/24 可选，如果不需要请留空）："
echo %SUBNET_PROXY%
:: 构建命令字符串
set COMMAND=%CURRENT_DIR%/nssm.exe install easytier_service "%CURRENT_DIR%easytier-core" -p tcp://public.easytier.top:11010
:: 添加 -i 参数
set COMMAND=%COMMAND% -i %IP_ADDRESS%
:: 如果提供了 -n 子网代理值，则添加它
if not "%SUBNET_PROXY%"=="" set COMMAND=%COMMAND% -n %SUBNET_PROXY%
:: 添加 --network-name 和 --network-secret 参数
set COMMAND=%COMMAND% --network-name %NETWORK_NAME% --network-secret %NETWORK_SECRET%
:: 执行卸载命令，确保服务不存在
call :uninstall %ACTION%
:: 执行组装好的命令
echo 正在执行命令：%COMMAND%
%COMMAND%
:: 设置服务为延迟自动启动
%CURRENT_DIR%/nssm.exe set easytier_service Start SERVICE_AUTO_START
%CURRENT_DIR%/nssm.exe start easytier_service
:: 检查服务是否安装完成
if %ERRORLEVEL% NEQ 0 goto service_not_found
echo 服务已安装并设置为了自启动！
pause
goto:eof

:uninstall
:: 检查服务是否存在
%CURRENT_DIR%/nssm.exe status easytier_service >nul 2>&1
if %ERRORLEVEL% NEQ 0 goto service_not_found

:: 服务存在，执行停止和移除
%CURRENT_DIR%/nssm.exe stop easytier_service
%CURRENT_DIR%/nssm.exe remove easytier_service confirm
:: 检查服务是否移除成功
if %ERRORLEVEL% NEQ 0 goto service_uninstall_fail
echo 服务已确保移除！
if %ACTION% EQU 2 pause
goto:eof

:service_uninstall_fail
echo 服务移除失败，请重试！
if %ACTION% EQU 2 pause
goto:eof

:service_install_fail
echo 服务安装失败，请重试！
if %ACTION% EQU 2 pause
goto:eof

:service_not_found
echo 服务不存在，跳过停止和移除步骤。
if %ACTION% EQU 2 pause
goto:eof

